from setuptools import find_packages, setup

setup(
    name="promptgame",
    version="0.1",
    packages=find_packages("src"),
    package_dir={"": "src"},
    install_requires=[
        # openai 1.x releases are unusably broken as of 2023-11-19, probably
        # need to wait a few weeks before they become usable
        "openai>=0.28.1,<0.29",
        "anthropic>=0.40.0,<0.41",
        # Custom fork of Django with some backported async features (as of
        # 2022-07-29 this only includes disconnect detection).
        # TODO(sam): remove this once Django 5.0 is released.
        "django @ git+https://github.com/qxcv/django@8ec3c205a98fdb05bade6606742a4dc19243b70c",
        "django-model-utils>=4.3.1,<4.4",
        "daphne>=4.0.0,<4.1",
        # [http2,tls] lets us use HTTP/2 in Daphne
        "Twisted[http2,tls]>=24.7.0rc1,<25.0",
        # [hiredis] uses a faster C parser for Redis responses
        "redis[hiredis]>=4.5.5,<4.6",
        "django-tailwind>=3.6.0,<3.7",
        # Requests
        "httpx==0.24.1",
        "django-environ>=0.10.0,<0.11",
        # better filtering tools on the admin site
        "django-admin-rangefilter>=0.10.0,<0.11",
        "python-json-logger>=2.0.7,<2.1",
        # psycopg-binary uses a precompiled wheel for psycopg (they don't
        # recommend this for prod because the compiled-in libraries won't
        # get patches, but I don't think that matters for us since we deploy
        # with Docker & the latest version gets installed on every deploy
        # anyway)
        "psycopg[binary,pool]>=3.1.8,<3.2",
        "tiktoken>=0.4.0",
        # for static file storage/serving
        "django-storages[google]>=1.13.2,<1.14",
        # for locking down staging
        "django-lockdown>=4.0.0,<4.1",
        # for nicely formatting timedeltas etc.
        "humanize>=4.8.0,<4.9",
        # timezone
        "pytz>=2023.3,<2024",
        # For one of the restrictions
        "cmudict>=1.0.13,<1.1",
        "syllables>=1.0.7,<1.1",
        # For admin site
        "pandas>=2.2.3,<2.3",
        # For PaLM
        "google-cloud-aiplatform>=1.68.0,<1.69",
    ],
    extras_require={
        "dev": [
            "black",
            "pytest",
            "pytest-django",
            "pytest-asyncio",
            # pytype 2023.10.5 can't handle the match expressions in our code
            # for some reason (gives an inscrutable error to do with undefined
            # lookups). Pinning to the old version at least makes our CI green.
            "pytype==2023.9.27",
            "ipython",
            "isort",
            "autoflake",
            "mock",
            "pytest-mock",
            "django-silk",
            "locust",
            "beautifulsoup4",
            # same as our main dep, but with [reload] extra
            "django-tailwind[reload]>=3.6.0,<3.7",
            # jupyter's nbconvert is used in CI to check that cell outputs are
            # clear (in check.sh)
            "nbconvert",
        ],
        "deploy": [
            # we may want py-spy for profiling during deployment
            "py-spy>=0.3.14,<0.4",
            # similar profiling for memory
            "memray>=1.9.1,<1.10",
            # process manager that runs daphne instances (the ASGI server that
            # hosts our app)
            "circus>=0.18,<0.19",
        ],
    },
    python_requires=">=3.10",
    include_package_data=True,
    package_data={
        "promptgame.data": ["*.txt", "*.json"],
    },
    author="Sam Toyer",
    author_email="sam@qxcv.net",
    description="An attack/defense prompt-injection game written in Django",
    long_description=open("README.md").read(),
    url="https://github.com/qxcv/promptgame",
    license="Apache 2.0",
    classifiers=[
        "Development Status :: 3 - Alpha",
        "Intended Audience :: Developers",
        "License :: OSI Approved :: Apache Software License",
        "Programming Language :: Python :: 3.11",
        "Framework :: Django",
    ],
)
