#!/usr/bin/env python
"""Django's command-line utility for administrative tasks."""
import os
import sys


def main():
    """Run administrative tasks."""
    if "DJANGO_SETTINGS_MODULE" not in os.environ:
        print(
            "No DJANGO_SETTINGS_MODULE environment variable found, using debug settings",
            file=sys.stderr,
        )
        os.environ["DJANGO_SETTINGS_MODULE"] = "promptgame.settings.debug"
    else:
        print(f"Using {os.environ['DJANGO_SETTINGS_MODULE']=}", file=sys.stderr)
    try:
        from django.core.management import execute_from_command_line
    except ImportError as exc:
        raise ImportError(
            "Couldn't import Django. Are you sure it's installed and "
            "available on your PYTHONPATH environment variable? Did you "
            "forget to activate a virtual environment?"
        ) from exc
    execute_from_command_line(sys.argv)


if __name__ == "__main__":
    main()
