from ttdata import common


def test_cache():
    with common.Cache(":memory:") as cache:  # in-memory db gets deleted afterwards
        # nonexistent keys can't be retrieved
        assert cache.get("nonexistent") == []

        complex_key = str(("gpt3.5", 0, ("system", "user", "user")))
        cache.set(complex_key, ["access granted"])

        # existing keys can be retrieved
        assert cache.get(complex_key) == ["access granted"]

        # no harm in storing twice
        cache.set(complex_key, ["access granted", "yolo"])
        assert cache.get(complex_key) == ["access granted", "yolo"]
