from setuptools import find_packages, setup

setup(
    name="ttdata",
    version="0.1",
    packages=find_packages(where="src"),
    package_dir={"": "src"},
    install_requires=[
        "numpy",
        "pandas",
        # pyarrow is required for parquet support in Pandas
        "pyarrow",
        "click",
        "jinja2",
        "tqdm",
        "SQLAlchemy",
        # if this gives you errors on M1/M2 then take out [binary]
        "psycopg[binary]",
        "python-dotenv",
        "openai",
        "anthropic",
        "tenacity",
        # latest version of urllib3 gave errors when using with deepinfra, so we
        # pin to an older version
        "urllib3>=1.26.16,<1.27",
        "transformers",
        "google-cloud-aiplatform",
        "seaborn[stats]",
        "torch",
        "scikit-learn",
        "tensorboard",
        "datasketch",
        "python-Levenshtein",
        "adjustText @ git+https://github.com/Phlya/adjustText.git@9107083aa56ccaa8a05958f2175ce2fbf5853ab2",
    ],
    entry_points={
        "console_scripts": [
            "run_pipeline=ttdata.__main__:_launch",
            "run-pipeline=ttdata.__main__:_launch",
        ],
    },
)
