#!/bin/bash

# Convert all the .svg files in this directory to optimized 256px-high .png
# files in the right static dir.

set -euo pipefail

RED='\033[0;31m'
GREEN='\033[0;32m'
NC='\033[0m' # No Color

echo -e "${GREEN}Script started...${NC}"

for svg in *.svg; do
    basename=$(basename "$svg" .svg)
    echo -e "${GREEN}Processing image: ${svg}${NC}"

    echo -e "${RED}Converting and resizing image...${NC}"
    convert -resize x256 "$svg" ../../src/promptgame/static/images/"${basename}.png"

    echo -e "${RED}Optimizing image...${NC}"
    pngcrush -ow -brute -rem alla ../../src/promptgame/static/images/"${basename}.png"

    echo -e "${GREEN}Done processing image: ${svg}${NC}"
done

echo -e "${GREEN}Script finished...${NC}"
