# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `spoom` gem.
# Please instead update this file by running `bin/tapioca gem spoom`.


# source://spoom//lib/spoom.rb#7
module Spoom
  class << self
    # source://spoom//lib/spoom/parse.rb#13
    sig { params(ruby: ::String, file: ::String).returns(::Prism::Node) }
    def parse_ruby(ruby, file:); end
  end
end

# source://spoom//lib/spoom/cli/helper.rb#9
module Spoom::Cli; end

# source://spoom//lib/spoom/cli/deadcode.rb#8
class Spoom::Cli::Deadcode < ::Thor
  include ::Spoom::Colorize
  include ::Spoom::Cli::Helper

  # source://spoom//lib/spoom/cli/deadcode.rb#52
  sig { params(paths: ::String).void }
  def deadcode(*paths); end

  def help(command = T.unsafe(nil), subcommand = T.unsafe(nil)); end

  # source://spoom//lib/spoom/cli/deadcode.rb#154
  def remove(location_string); end
end

# source://spoom//lib/spoom/cli/helper.rb#10
module Spoom::Cli::Helper
  include ::Spoom::Colorize

  requires_ancestor { Thor }

  # source://spoom//lib/spoom/cli/helper.rb#139
  sig { params(string: ::String).returns(::String) }
  def blue(string); end

  # Is the `--color` option true?
  #
  # source://spoom//lib/spoom/cli/helper.rb#103
  sig { returns(T::Boolean) }
  def color?; end

  # Colorize a string if `color?`
  #
  # source://spoom//lib/spoom/cli/helper.rb#132
  sig { params(string: ::String, color: ::Spoom::Color).returns(::String) }
  def colorize(string, *color); end

  # Returns the context at `--path` (by default the current working directory)
  #
  # source://spoom//lib/spoom/cli/helper.rb#71
  sig { returns(::Spoom::Context) }
  def context; end

  # Raise if `spoom` is not ran inside a context with a `sorbet/config` file
  #
  # source://spoom//lib/spoom/cli/helper.rb#77
  sig { returns(::Spoom::Context) }
  def context_requiring_sorbet!; end

  # source://spoom//lib/spoom/cli/helper.rb#144
  sig { params(string: ::String).returns(::String) }
  def cyan(string); end

  # Return the path specified through `--path`
  #
  # source://spoom//lib/spoom/cli/helper.rb#92
  sig { returns(::String) }
  def exec_path; end

  # source://spoom//lib/spoom/cli/helper.rb#149
  sig { params(string: ::String).returns(::String) }
  def gray(string); end

  # source://spoom//lib/spoom/cli/helper.rb#154
  sig { params(string: ::String).returns(::String) }
  def green(string); end

  # source://spoom//lib/spoom/cli/helper.rb#108
  sig { params(string: ::String).returns(::String) }
  def highlight(string); end

  # source://spoom//lib/spoom/cli/helper.rb#159
  sig { params(string: ::String).returns(::String) }
  def red(string); end

  # Print `message` on `$stdout`
  #
  # source://spoom//lib/spoom/cli/helper.rb#20
  sig { params(message: ::String).void }
  def say(message); end

  # Print `message` on `$stderr`
  #
  # The message is prefixed by a status (default: `Error`).
  #
  # source://spoom//lib/spoom/cli/helper.rb#39
  sig { params(message: ::String, status: T.nilable(::String), nl: T::Boolean).void }
  def say_error(message, status: T.unsafe(nil), nl: T.unsafe(nil)); end

  # Print `message` on `$stderr`
  #
  # The message is prefixed by a status (default: `Warning`).
  #
  # source://spoom//lib/spoom/cli/helper.rb#59
  sig { params(message: ::String, status: T.nilable(::String), nl: T::Boolean).void }
  def say_warning(message, status: T.unsafe(nil), nl: T.unsafe(nil)); end

  # source://spoom//lib/spoom/cli/helper.rb#164
  sig { params(string: ::String).returns(::String) }
  def yellow(string); end
end

# source://spoom//lib/spoom/cli.rb#12
class Spoom::Cli::Main < ::Thor
  include ::Spoom::Colorize
  include ::Spoom::Cli::Helper

  # source://spoom//lib/spoom/cli.rb#101
  def __print_version; end

  # source://spoom//lib/spoom/cli.rb#58
  sig { params(directory: ::String).void }
  def bump(directory = T.unsafe(nil)); end

  # source://spoom//lib/spoom/cli.rb#65
  def coverage(*args); end

  # source://thor/1.3.2/lib/thor.rb#334
  def deadcode(*args); end

  # source://spoom//lib/spoom/cli.rb#75
  def lsp(*args); end

  # source://thor/1.3.2/lib/thor.rb#334
  def srb(*args); end

  # source://spoom//lib/spoom/cli.rb#94
  def tc(*paths_to_select); end

  class << self
    # @return [Boolean]
    #
    # source://spoom//lib/spoom/cli.rb#108
    def exit_on_failure?; end
  end
end

# source://spoom//lib/spoom/cli.rb#81
Spoom::Cli::Main::SORT_CODE = T.let(T.unsafe(nil), String)

# source://spoom//lib/spoom/cli.rb#83
Spoom::Cli::Main::SORT_ENUM = T.let(T.unsafe(nil), Array)

# source://spoom//lib/spoom/cli.rb#82
Spoom::Cli::Main::SORT_LOC = T.let(T.unsafe(nil), String)

# source://spoom//lib/spoom/cli/srb/bump.rb#9
module Spoom::Cli::Srb; end

# source://spoom//lib/spoom/cli/srb/bump.rb#10
class Spoom::Cli::Srb::Bump < ::Thor
  include ::Spoom::Colorize
  include ::Spoom::Cli::Helper

  # source://spoom//lib/spoom/cli/srb/bump.rb#50
  sig { params(directory: ::String).void }
  def bump(directory = T.unsafe(nil)); end

  def help(command = T.unsafe(nil), subcommand = T.unsafe(nil)); end

  # source://spoom//lib/spoom/cli/srb/bump.rb#171
  def print_changes(files, command:, from: T.unsafe(nil), to: T.unsafe(nil), dry: T.unsafe(nil), path: T.unsafe(nil)); end

  # source://spoom//lib/spoom/cli/srb/bump.rb#193
  def undo_changes(files, from_strictness); end
end

# source://spoom//lib/spoom/cli/srb/coverage.rb#10
class Spoom::Cli::Srb::Coverage < ::Thor
  include ::Spoom::Colorize
  include ::Spoom::Cli::Helper

  # source://spoom//lib/spoom/cli/srb/coverage.rb#199
  def bundle_install(path, sha); end

  def help(command = T.unsafe(nil), subcommand = T.unsafe(nil)); end

  # source://spoom//lib/spoom/cli/srb/coverage.rb#211
  def message_no_data(file); end

  # source://spoom//lib/spoom/cli/srb/coverage.rb#174
  def open(file = T.unsafe(nil)); end

  # source://spoom//lib/spoom/cli/srb/coverage.rb#190
  def parse_time(string, option); end

  # source://spoom//lib/spoom/cli/srb/coverage.rb#143
  def report; end

  # source://spoom//lib/spoom/cli/srb/coverage.rb#21
  def snapshot; end

  # source://spoom//lib/spoom/cli/srb/coverage.rb#43
  def timeline; end
end

# source://spoom//lib/spoom/cli/srb/coverage.rb#13
Spoom::Cli::Srb::Coverage::DATA_DIR = T.let(T.unsafe(nil), String)

# source://spoom//lib/spoom/cli/srb/lsp.rb#11
class Spoom::Cli::Srb::LSP < ::Thor
  include ::Spoom::Colorize
  include ::Spoom::Cli::Helper

  # TODO: options, filter, limit, kind etc.. filter rbi
  #
  # source://spoom//lib/spoom/cli/srb/lsp.rb#45
  def defs(file, line, col); end

  # TODO: options, filter, limit, kind etc.. filter rbi
  #
  # source://spoom//lib/spoom/cli/srb/lsp.rb#55
  def find(query); end

  def help(command = T.unsafe(nil), subcommand = T.unsafe(nil)); end

  # TODO: options, filter, limit, kind etc.. filter rbi
  #
  # source://spoom//lib/spoom/cli/srb/lsp.rb#31
  def hover(file, line, col); end

  # TODO: options, filter, limit, kind etc.. filter rbi
  #
  # source://spoom//lib/spoom/cli/srb/lsp.rb#16
  def list; end

  # source://spoom//lib/spoom/cli/srb/lsp.rb#104
  def lsp_client; end

  # TODO: options, filter, limit, kind etc.. filter rbi
  #
  # source://spoom//lib/spoom/cli/srb/lsp.rb#75
  def refs(file, line, col); end

  # source://spoom//lib/spoom/cli/srb/lsp.rb#127
  def run(&block); end

  # TODO: options, filter, limit, kind etc.. filter rbi
  #
  # source://spoom//lib/spoom/cli/srb/lsp.rb#85
  def sigs(file, line, col); end

  # source://spoom//lib/spoom/cli/srb/lsp.rb#119
  def symbol_printer; end

  # TODO: options, filter, limit, kind etc.. filter rbi
  #
  # source://spoom//lib/spoom/cli/srb/lsp.rb#65
  def symbols(file); end

  # source://spoom//lib/spoom/cli/srb/lsp.rb#152
  def to_uri(path); end

  # TODO: options, filter, limit, kind etc.. filter rbi
  #
  # source://spoom//lib/spoom/cli/srb/lsp.rb#95
  def types(file, line, col); end
end

# source://spoom//lib/spoom/cli/srb.rb#12
class Spoom::Cli::Srb::Main < ::Thor
  # source://thor/1.3.2/lib/thor.rb#334
  def bump(*args); end

  # source://thor/1.3.2/lib/thor.rb#334
  def coverage(*args); end

  def help(command = T.unsafe(nil), subcommand = T.unsafe(nil)); end

  # source://thor/1.3.2/lib/thor.rb#334
  def lsp(*args); end

  # source://thor/1.3.2/lib/thor.rb#334
  def tc(*args); end
end

# source://spoom//lib/spoom/cli/srb/tc.rb#7
class Spoom::Cli::Srb::Tc < ::Thor
  include ::Spoom::Colorize
  include ::Spoom::Cli::Helper

  # source://spoom//lib/spoom/cli/srb/tc.rb#132
  def colorize_message(message); end

  # source://spoom//lib/spoom/cli/srb/tc.rb#123
  def format_error(error, format); end

  def help(command = T.unsafe(nil), subcommand = T.unsafe(nil)); end

  # source://spoom//lib/spoom/cli/srb/tc.rb#27
  def tc(*paths_to_select); end
end

# source://spoom//lib/spoom/cli/srb/tc.rb#16
Spoom::Cli::Srb::Tc::DEFAULT_FORMAT = T.let(T.unsafe(nil), String)

# source://spoom//lib/spoom/cli/srb/tc.rb#12
Spoom::Cli::Srb::Tc::SORT_CODE = T.let(T.unsafe(nil), String)

# source://spoom//lib/spoom/cli/srb/tc.rb#14
Spoom::Cli::Srb::Tc::SORT_ENUM = T.let(T.unsafe(nil), Array)

# source://spoom//lib/spoom/cli/srb/tc.rb#13
Spoom::Cli::Srb::Tc::SORT_LOC = T.let(T.unsafe(nil), String)

# source://spoom//lib/spoom/colors.rb#5
class Spoom::Color < ::T::Enum
  enums do
    BLACK = new
    BLUE = new
    BOLD = new
    CLEAR = new
    CYAN = new
    GREEN = new
    LIGHT_BLACK = new
    LIGHT_BLUE = new
    LIGHT_CYAN = new
    LIGHT_GREEN = new
    LIGHT_MAGENTA = new
    LIGHT_RED = new
    LIGHT_WHITE = new
    LIGHT_YELLOW = new
    MAGENTA = new
    RED = new
    WHITE = new
    YELLOW = new
  end

  # source://spoom//lib/spoom/colors.rb#32
  sig { returns(::String) }
  def ansi_code; end
end

# source://spoom//lib/spoom/colors.rb#37
module Spoom::Colorize
  # source://spoom//lib/spoom/colors.rb#41
  sig { params(string: ::String, color: ::Spoom::Color).returns(::String) }
  def set_color(string, *color); end
end

# An abstraction to a Ruby project context
#
# A context maps to a directory in the file system.
# It is used to manipulate files and run commands in the context of this directory.
#
# source://spoom//lib/spoom/context/bundle.rb#5
class Spoom::Context
  include ::Spoom::Context::Bundle
  include ::Spoom::Context::Exec
  include ::Spoom::Context::FileSystem
  include ::Spoom::Context::Git
  include ::Spoom::Context::Sorbet

  # Create a new context about `absolute_path`
  #
  # The directory will not be created if it doesn't exist.
  # Call `#make!` to create it.
  #
  # source://spoom//lib/spoom/context.rb#51
  sig { params(absolute_path: ::String).void }
  def initialize(absolute_path); end

  # The absolute path to the directory this context is about
  #
  # source://spoom//lib/spoom/context.rb#44
  sig { returns(::String) }
  def absolute_path; end

  class << self
    # Create a new context in the system's temporary directory
    #
    # `name` is used as prefix to the temporary directory name.
    # The directory will be created if it doesn't exist.
    #
    # source://spoom//lib/spoom/context.rb#37
    sig { params(name: T.nilable(::String)).returns(T.attached_class) }
    def mktmp!(name = T.unsafe(nil)); end
  end
end

# Bundle features for a context
#
# source://spoom//lib/spoom/context/bundle.rb#7
module Spoom::Context::Bundle
  requires_ancestor { Spoom::Context }

  # Run a command with `bundle` in this context directory
  #
  # source://spoom//lib/spoom/context/bundle.rb#33
  sig { params(command: ::String, version: T.nilable(::String), capture_err: T::Boolean).returns(::Spoom::ExecResult) }
  def bundle(command, version: T.unsafe(nil), capture_err: T.unsafe(nil)); end

  # Run a command `bundle exec` in this context directory
  #
  # source://spoom//lib/spoom/context/bundle.rb#46
  sig { params(command: ::String, version: T.nilable(::String), capture_err: T::Boolean).returns(::Spoom::ExecResult) }
  def bundle_exec(command, version: T.unsafe(nil), capture_err: T.unsafe(nil)); end

  # Run `bundle install` in this context directory
  #
  # source://spoom//lib/spoom/context/bundle.rb#40
  sig { params(version: T.nilable(::String), capture_err: T::Boolean).returns(::Spoom::ExecResult) }
  def bundle_install!(version: T.unsafe(nil), capture_err: T.unsafe(nil)); end

  # Get `gem` version from the `Gemfile.lock` content
  #
  # Returns `nil` if `gem` cannot be found in the Gemfile.
  #
  # source://spoom//lib/spoom/context/bundle.rb#62
  sig { params(gem: ::String).returns(T.nilable(::Gem::Version)) }
  def gem_version_from_gemfile_lock(gem); end

  # source://spoom//lib/spoom/context/bundle.rb#51
  sig { returns(T::Hash[::String, ::Bundler::LazySpecification]) }
  def gemfile_lock_specs; end

  # Read the contents of the Gemfile in this context directory
  #
  # source://spoom//lib/spoom/context/bundle.rb#15
  sig { returns(T.nilable(::String)) }
  def read_gemfile; end

  # Read the contents of the Gemfile.lock in this context directory
  #
  # source://spoom//lib/spoom/context/bundle.rb#21
  sig { returns(T.nilable(::String)) }
  def read_gemfile_lock; end

  # Set the `contents` of the Gemfile in this context directory
  #
  # source://spoom//lib/spoom/context/bundle.rb#27
  sig { params(contents: ::String, append: T::Boolean).void }
  def write_gemfile!(contents, append: T.unsafe(nil)); end
end

# Execution features for a context
#
# source://spoom//lib/spoom/context/exec.rb#27
module Spoom::Context::Exec
  requires_ancestor { Spoom::Context }

  # Run a command in this context directory
  #
  # source://spoom//lib/spoom/context/exec.rb#35
  sig { params(command: ::String, capture_err: T::Boolean).returns(::Spoom::ExecResult) }
  def exec(command, capture_err: T.unsafe(nil)); end
end

# File System features for a context
#
# source://spoom//lib/spoom/context/file_system.rb#7
module Spoom::Context::FileSystem
  requires_ancestor { Spoom::Context }

  # Returns the absolute path to `relative_path` in the context's directory
  #
  # source://spoom//lib/spoom/context/file_system.rb#15
  sig { params(relative_path: ::String).returns(::String) }
  def absolute_path_to(relative_path); end

  # source://spoom//lib/spoom/context/file_system.rb#53
  sig do
    params(
      allow_extensions: T::Array[::String],
      allow_mime_types: T::Array[::String],
      exclude_patterns: T::Array[::String]
    ).returns(T::Array[::String])
  end
  def collect_files(allow_extensions: T.unsafe(nil), allow_mime_types: T.unsafe(nil), exclude_patterns: T.unsafe(nil)); end

  # Delete this context and its content
  #
  # Warning: it will `rm -rf` the context directory on the file system.
  #
  # source://spoom//lib/spoom/context/file_system.rb#105
  sig { void }
  def destroy!; end

  # Does the context directory at `absolute_path` exist and is a directory?
  #
  # source://spoom//lib/spoom/context/file_system.rb#21
  sig { returns(T::Boolean) }
  def exist?; end

  # Does `relative_path` point to an existing file in this context directory?
  #
  # source://spoom//lib/spoom/context/file_system.rb#65
  sig { params(relative_path: ::String).returns(T::Boolean) }
  def file?(relative_path); end

  # List all files in this context matching `pattern`
  #
  # source://spoom//lib/spoom/context/file_system.rb#34
  sig { params(pattern: ::String).returns(T::Array[::String]) }
  def glob(pattern = T.unsafe(nil)); end

  # List all files at the top level of this context directory
  #
  # source://spoom//lib/spoom/context/file_system.rb#42
  sig { returns(T::Array[::String]) }
  def list; end

  # Create the context directory at `absolute_path`
  #
  # source://spoom//lib/spoom/context/file_system.rb#27
  sig { void }
  def mkdir!; end

  # Move the file or directory from `from_relative_path` to `to_relative_path`
  #
  # source://spoom//lib/spoom/context/file_system.rb#95
  sig { params(from_relative_path: ::String, to_relative_path: ::String).void }
  def move!(from_relative_path, to_relative_path); end

  # Return the contents of the file at `relative_path` in this context directory
  #
  # Will raise if the file doesn't exist.
  #
  # source://spoom//lib/spoom/context/file_system.rb#73
  sig { params(relative_path: ::String).returns(::String) }
  def read(relative_path); end

  # Remove the path at `relative_path` (recursive + force) in this context directory
  #
  # source://spoom//lib/spoom/context/file_system.rb#89
  sig { params(relative_path: ::String).void }
  def remove!(relative_path); end

  # Write `contents` in the file at `relative_path` in this context directory
  #
  # Append to the file if `append` is true.
  #
  # source://spoom//lib/spoom/context/file_system.rb#81
  sig { params(relative_path: ::String, contents: ::String, append: T::Boolean).void }
  def write!(relative_path, contents = T.unsafe(nil), append: T.unsafe(nil)); end
end

# Git features for a context
#
# source://spoom//lib/spoom/context/git.rb#35
module Spoom::Context::Git
  requires_ancestor { Spoom::Context }

  # Run a command prefixed by `git` in this context directory
  #
  # source://spoom//lib/spoom/context/git.rb#43
  sig { params(command: ::String).returns(::Spoom::ExecResult) }
  def git(command); end

  # Run `git checkout` in this context directory
  #
  # source://spoom//lib/spoom/context/git.rb#62
  sig { params(ref: ::String).returns(::Spoom::ExecResult) }
  def git_checkout!(ref: T.unsafe(nil)); end

  # Run `git checkout -b <branch-name> <ref>` in this context directory
  #
  # source://spoom//lib/spoom/context/git.rb#68
  sig { params(branch_name: ::String, ref: T.nilable(::String)).returns(::Spoom::ExecResult) }
  def git_checkout_new_branch!(branch_name, ref: T.unsafe(nil)); end

  # Run `git add . && git commit` in this context directory
  #
  # source://spoom//lib/spoom/context/git.rb#78
  sig { params(message: ::String, time: ::Time, allow_empty: T::Boolean).returns(::Spoom::ExecResult) }
  def git_commit!(message: T.unsafe(nil), time: T.unsafe(nil), allow_empty: T.unsafe(nil)); end

  # Get the current git branch in this context directory
  #
  # source://spoom//lib/spoom/context/git.rb#89
  sig { returns(T.nilable(::String)) }
  def git_current_branch; end

  # Run `git diff` in this context directory
  #
  # source://spoom//lib/spoom/context/git.rb#98
  sig { params(arg: ::String).returns(::Spoom::ExecResult) }
  def git_diff(*arg); end

  # Run `git init` in this context directory
  #
  # Warning: passing a branch will run `git init -b <branch>` which is only available in git 2.28+.
  # In older versions, use `git_init!` followed by `git("checkout -b <branch>")`.
  #
  # source://spoom//lib/spoom/context/git.rb#52
  sig { params(branch: T.nilable(::String)).returns(::Spoom::ExecResult) }
  def git_init!(branch: T.unsafe(nil)); end

  # Get the last commit in the currently checked out branch
  #
  # source://spoom//lib/spoom/context/git.rb#104
  sig { params(short_sha: T::Boolean).returns(T.nilable(::Spoom::Git::Commit)) }
  def git_last_commit(short_sha: T.unsafe(nil)); end

  # source://spoom//lib/spoom/context/git.rb#115
  sig { params(arg: ::String).returns(::Spoom::ExecResult) }
  def git_log(*arg); end

  # Run `git push <remote> <ref>` in this context directory
  #
  # source://spoom//lib/spoom/context/git.rb#121
  sig { params(remote: ::String, ref: ::String, force: T::Boolean).returns(::Spoom::ExecResult) }
  def git_push!(remote, ref, force: T.unsafe(nil)); end

  # source://spoom//lib/spoom/context/git.rb#126
  sig { params(arg: ::String).returns(::Spoom::ExecResult) }
  def git_show(*arg); end

  # Is there uncommitted changes in this context directory?
  #
  # source://spoom//lib/spoom/context/git.rb#132
  sig { params(path: ::String).returns(T::Boolean) }
  def git_workdir_clean?(path: T.unsafe(nil)); end
end

# Sorbet features for a context
#
# source://spoom//lib/spoom/context/sorbet.rb#7
module Spoom::Context::Sorbet
  requires_ancestor { Spoom::Context }

  # Does this context has a `sorbet/config` file?
  #
  # source://spoom//lib/spoom/context/sorbet.rb#119
  sig { returns(T::Boolean) }
  def has_sorbet_config?; end

  # Read the strictness sigil from the file at `relative_path` (returns `nil` if no sigil)
  #
  # source://spoom//lib/spoom/context/sorbet.rb#142
  sig { params(relative_path: ::String).returns(T.nilable(::String)) }
  def read_file_strictness(relative_path); end

  # Read the contents of `sorbet/config` in this context directory
  #
  # source://spoom//lib/spoom/context/sorbet.rb#130
  sig { returns(::String) }
  def read_sorbet_config; end

  # source://spoom//lib/spoom/context/sorbet.rb#124
  sig { returns(::Spoom::Sorbet::Config) }
  def sorbet_config; end

  # Get the commit introducing the `sorbet/config` file
  #
  # source://spoom//lib/spoom/context/sorbet.rb#148
  sig { returns(T.nilable(::Spoom::Git::Commit)) }
  def sorbet_intro_commit; end

  # Get the commit removing the `sorbet/config` file
  #
  # source://spoom//lib/spoom/context/sorbet.rb#160
  sig { returns(T.nilable(::Spoom::Git::Commit)) }
  def sorbet_removal_commit; end

  # Run `bundle exec srb` in this context directory
  #
  # source://spoom//lib/spoom/context/sorbet.rb#15
  sig { params(arg: ::String, sorbet_bin: T.nilable(::String), capture_err: T::Boolean).returns(::Spoom::ExecResult) }
  def srb(*arg, sorbet_bin: T.unsafe(nil), capture_err: T.unsafe(nil)); end

  # List all files typechecked by Sorbet from its `config`
  #
  # source://spoom//lib/spoom/context/sorbet.rb#65
  sig { params(with_config: T.nilable(::Spoom::Sorbet::Config), include_rbis: T::Boolean).returns(T::Array[::String]) }
  def srb_files(with_config: T.unsafe(nil), include_rbis: T.unsafe(nil)); end

  # List all files typechecked by Sorbet from its `config` that matches `strictness`
  #
  # source://spoom//lib/spoom/context/sorbet.rb#104
  sig do
    params(
      strictness: ::String,
      with_config: T.nilable(::Spoom::Sorbet::Config),
      include_rbis: T::Boolean
    ).returns(T::Array[::String])
  end
  def srb_files_with_strictness(strictness, with_config: T.unsafe(nil), include_rbis: T.unsafe(nil)); end

  # source://spoom//lib/spoom/context/sorbet.rb#45
  sig do
    params(
      arg: ::String,
      sorbet_bin: T.nilable(::String),
      capture_err: T::Boolean
    ).returns(T.nilable(T::Hash[::String, ::Integer]))
  end
  def srb_metrics(*arg, sorbet_bin: T.unsafe(nil), capture_err: T.unsafe(nil)); end

  # source://spoom//lib/spoom/context/sorbet.rb#33
  sig { params(arg: ::String, sorbet_bin: T.nilable(::String), capture_err: T::Boolean).returns(::Spoom::ExecResult) }
  def srb_tc(*arg, sorbet_bin: T.unsafe(nil), capture_err: T.unsafe(nil)); end

  # source://spoom//lib/spoom/context/sorbet.rb#110
  sig { params(arg: ::String, sorbet_bin: T.nilable(::String), capture_err: T::Boolean).returns(T.nilable(::String)) }
  def srb_version(*arg, sorbet_bin: T.unsafe(nil), capture_err: T.unsafe(nil)); end

  # Set the `contents` of `sorbet/config` in this context directory
  #
  # source://spoom//lib/spoom/context/sorbet.rb#136
  sig { params(contents: ::String, append: T::Boolean).void }
  def write_sorbet_config!(contents, append: T.unsafe(nil)); end
end

# source://spoom//lib/spoom/coverage/snapshot.rb#5
module Spoom::Coverage
  class << self
    # source://spoom//lib/spoom/coverage.rb#103
    sig { params(context: ::Spoom::Context).returns(::Spoom::FileTree) }
    def file_tree(context); end

    # source://spoom//lib/spoom/coverage.rb#83
    sig do
      params(
        context: ::Spoom::Context,
        snapshots: T::Array[::Spoom::Coverage::Snapshot],
        palette: ::Spoom::Coverage::D3::ColorPalette
      ).returns(::Spoom::Coverage::Report)
    end
    def report(context, snapshots, palette:); end

    # source://spoom//lib/spoom/coverage.rb#16
    sig do
      params(
        context: ::Spoom::Context,
        rbi: T::Boolean,
        sorbet_bin: T.nilable(::String)
      ).returns(::Spoom::Coverage::Snapshot)
    end
    def snapshot(context, rbi: T.unsafe(nil), sorbet_bin: T.unsafe(nil)); end
  end
end

# source://spoom//lib/spoom/coverage/report.rb#88
module Spoom::Coverage::Cards; end

# source://spoom//lib/spoom/coverage/report.rb#89
class Spoom::Coverage::Cards::Card < ::Spoom::Coverage::Template
  # source://spoom//lib/spoom/coverage/report.rb#98
  sig { params(template: ::String, title: T.nilable(::String), body: T.nilable(::String)).void }
  def initialize(template: T.unsafe(nil), title: T.unsafe(nil), body: T.unsafe(nil)); end

  # @return [String, nil]
  #
  # source://spoom//lib/spoom/coverage/report.rb#95
  def body; end

  # source://spoom//lib/spoom/coverage/report.rb#95
  sig { returns(T.nilable(::String)) }
  def title; end
end

# source://spoom//lib/spoom/coverage/report.rb#92
Spoom::Coverage::Cards::Card::TEMPLATE = T.let(T.unsafe(nil), String)

# @abstract It cannot be directly instantiated. Subclasses must implement the `abstract` methods below.
#
# source://spoom//lib/spoom/coverage/report.rb#105
class Spoom::Coverage::Cards::Erb < ::Spoom::Coverage::Cards::Card
  abstract!

  # source://spoom//lib/spoom/coverage/report.rb#112
  sig { void }
  def initialize; end

  # @abstract
  #
  # source://spoom//lib/spoom/coverage/report.rb#120
  sig { abstract.returns(::String) }
  def erb; end

  # source://spoom//lib/spoom/coverage/report.rb#115
  sig { override.returns(::String) }
  def html; end
end

# source://spoom//lib/spoom/coverage/report.rb#153
class Spoom::Coverage::Cards::Map < ::Spoom::Coverage::Cards::Card
  # source://spoom//lib/spoom/coverage/report.rb#164
  sig do
    params(
      file_tree: ::Spoom::FileTree,
      nodes_strictnesses: T::Hash[::Spoom::FileTree::Node, T.nilable(::String)],
      nodes_strictness_scores: T::Hash[::Spoom::FileTree::Node, ::Float],
      title: ::String
    ).void
  end
  def initialize(file_tree:, nodes_strictnesses:, nodes_strictness_scores:, title: T.unsafe(nil)); end
end

# source://spoom//lib/spoom/coverage/report.rb#123
class Spoom::Coverage::Cards::Snapshot < ::Spoom::Coverage::Cards::Card
  # source://spoom//lib/spoom/coverage/report.rb#132
  sig { params(snapshot: ::Spoom::Coverage::Snapshot, title: ::String).void }
  def initialize(snapshot:, title: T.unsafe(nil)); end

  # source://spoom//lib/spoom/coverage/report.rb#143
  sig { returns(::Spoom::Coverage::D3::Pie::Calls) }
  def pie_calls; end

  # source://spoom//lib/spoom/coverage/report.rb#138
  sig { returns(::Spoom::Coverage::D3::Pie::Sigils) }
  def pie_sigils; end

  # source://spoom//lib/spoom/coverage/report.rb#148
  sig { returns(::Spoom::Coverage::D3::Pie::Sigs) }
  def pie_sigs; end

  # source://spoom//lib/spoom/coverage/report.rb#129
  sig { returns(::Spoom::Coverage::Snapshot) }
  def snapshot; end
end

# source://spoom//lib/spoom/coverage/report.rb#126
Spoom::Coverage::Cards::Snapshot::TEMPLATE = T.let(T.unsafe(nil), String)

# source://spoom//lib/spoom/coverage/report.rb#240
class Spoom::Coverage::Cards::SorbetIntro < ::Spoom::Coverage::Cards::Erb
  # source://spoom//lib/spoom/coverage/report.rb#244
  sig { params(sorbet_intro_commit: T.nilable(::String), sorbet_intro_date: T.nilable(::Time)).void }
  def initialize(sorbet_intro_commit: T.unsafe(nil), sorbet_intro_date: T.unsafe(nil)); end

  # source://spoom//lib/spoom/coverage/report.rb#250
  sig { override.returns(::String) }
  def erb; end
end

# source://spoom//lib/spoom/coverage/report.rb#177
class Spoom::Coverage::Cards::Timeline < ::Spoom::Coverage::Cards::Card
  # source://spoom//lib/spoom/coverage/report.rb#181
  sig { params(title: ::String, timeline: ::Spoom::Coverage::D3::Timeline).void }
  def initialize(title:, timeline:); end
end

# source://spoom//lib/spoom/coverage/report.rb#194
class Spoom::Coverage::Cards::Timeline::Calls < ::Spoom::Coverage::Cards::Timeline
  # source://spoom//lib/spoom/coverage/report.rb#198
  sig { params(snapshots: T::Array[::Spoom::Coverage::Snapshot], title: ::String).void }
  def initialize(snapshots:, title: T.unsafe(nil)); end
end

# source://spoom//lib/spoom/coverage/report.rb#212
class Spoom::Coverage::Cards::Timeline::RBIs < ::Spoom::Coverage::Cards::Timeline
  # source://spoom//lib/spoom/coverage/report.rb#216
  sig { params(snapshots: T::Array[::Spoom::Coverage::Snapshot], title: ::String).void }
  def initialize(snapshots:, title: T.unsafe(nil)); end
end

# source://spoom//lib/spoom/coverage/report.rb#230
class Spoom::Coverage::Cards::Timeline::Runtimes < ::Spoom::Coverage::Cards::Timeline
  # source://spoom//lib/spoom/coverage/report.rb#234
  sig { params(snapshots: T::Array[::Spoom::Coverage::Snapshot], title: ::String).void }
  def initialize(snapshots:, title: T.unsafe(nil)); end
end

# source://spoom//lib/spoom/coverage/report.rb#185
class Spoom::Coverage::Cards::Timeline::Sigils < ::Spoom::Coverage::Cards::Timeline
  # source://spoom//lib/spoom/coverage/report.rb#189
  sig { params(snapshots: T::Array[::Spoom::Coverage::Snapshot], title: ::String).void }
  def initialize(snapshots:, title: T.unsafe(nil)); end
end

# source://spoom//lib/spoom/coverage/report.rb#203
class Spoom::Coverage::Cards::Timeline::Sigs < ::Spoom::Coverage::Cards::Timeline
  # source://spoom//lib/spoom/coverage/report.rb#207
  sig { params(snapshots: T::Array[::Spoom::Coverage::Snapshot], title: ::String).void }
  def initialize(snapshots:, title: T.unsafe(nil)); end
end

# source://spoom//lib/spoom/coverage/report.rb#221
class Spoom::Coverage::Cards::Timeline::Versions < ::Spoom::Coverage::Cards::Timeline
  # source://spoom//lib/spoom/coverage/report.rb#225
  sig { params(snapshots: T::Array[::Spoom::Coverage::Snapshot], title: ::String).void }
  def initialize(snapshots:, title: T.unsafe(nil)); end
end

# source://spoom//lib/spoom/coverage/d3/base.rb#6
module Spoom::Coverage::D3
  class << self
    # source://spoom//lib/spoom/coverage/d3.rb#61
    sig { params(palette: ::Spoom::Coverage::D3::ColorPalette).returns(::String) }
    def header_script(palette); end

    # source://spoom//lib/spoom/coverage/d3.rb#21
    sig { returns(::String) }
    def header_style; end
  end
end

# @abstract It cannot be directly instantiated. Subclasses must implement the `abstract` methods below.
#
# source://spoom//lib/spoom/coverage/d3/base.rb#7
class Spoom::Coverage::D3::Base
  abstract!

  # source://spoom//lib/spoom/coverage/d3/base.rb#17
  sig { params(id: ::String, data: T.untyped).void }
  def initialize(id, data); end

  # source://spoom//lib/spoom/coverage/d3/base.rb#37
  sig { returns(::String) }
  def html; end

  # source://spoom//lib/spoom/coverage/d3/base.rb#14
  sig { returns(::String) }
  def id; end

  # @abstract
  #
  # source://spoom//lib/spoom/coverage/d3/base.rb#50
  sig { abstract.returns(::String) }
  def script; end

  # source://spoom//lib/spoom/coverage/d3/base.rb#45
  sig { returns(::String) }
  def tooltip; end

  class << self
    # source://spoom//lib/spoom/coverage/d3/base.rb#31
    sig { returns(::String) }
    def header_script; end

    # source://spoom//lib/spoom/coverage/d3/base.rb#26
    sig { returns(::String) }
    def header_style; end
  end
end

# source://spoom//lib/spoom/coverage/d3.rb#12
Spoom::Coverage::D3::COLOR_FALSE = T.let(T.unsafe(nil), String)

# source://spoom//lib/spoom/coverage/d3.rb#11
Spoom::Coverage::D3::COLOR_IGNORE = T.let(T.unsafe(nil), String)

# source://spoom//lib/spoom/coverage/d3.rb#14
Spoom::Coverage::D3::COLOR_STRICT = T.let(T.unsafe(nil), String)

# source://spoom//lib/spoom/coverage/d3.rb#15
Spoom::Coverage::D3::COLOR_STRONG = T.let(T.unsafe(nil), String)

# source://spoom//lib/spoom/coverage/d3.rb#13
Spoom::Coverage::D3::COLOR_TRUE = T.let(T.unsafe(nil), String)

# source://spoom//lib/spoom/coverage/d3/circle_map.rb#9
class Spoom::Coverage::D3::CircleMap < ::Spoom::Coverage::D3::Base
  # source://spoom//lib/spoom/coverage/d3/circle_map.rb#59
  sig { override.returns(::String) }
  def script; end

  class << self
    # source://spoom//lib/spoom/coverage/d3/circle_map.rb#40
    sig { returns(::String) }
    def header_script; end

    # source://spoom//lib/spoom/coverage/d3/circle_map.rb#14
    sig { returns(::String) }
    def header_style; end
  end
end

# source://spoom//lib/spoom/coverage/d3/circle_map.rb#148
class Spoom::Coverage::D3::CircleMap::Sigils < ::Spoom::Coverage::D3::CircleMap
  # source://spoom//lib/spoom/coverage/d3/circle_map.rb#159
  sig do
    params(
      id: ::String,
      file_tree: ::Spoom::FileTree,
      nodes_strictnesses: T::Hash[::Spoom::FileTree::Node, T.nilable(::String)],
      nodes_scores: T::Hash[::Spoom::FileTree::Node, ::Float]
    ).void
  end
  def initialize(id, file_tree, nodes_strictnesses, nodes_scores); end

  # source://spoom//lib/spoom/coverage/d3/circle_map.rb#166
  sig { params(node: ::Spoom::FileTree::Node).returns(T::Hash[::Symbol, T.untyped]) }
  def tree_node_to_json(node); end
end

# source://spoom//lib/spoom/coverage/d3.rb#103
class Spoom::Coverage::D3::ColorPalette < ::T::Struct
  prop :ignore, ::String
  prop :false, ::String
  prop :true, ::String
  prop :strict, ::String
  prop :strong, ::String

  class << self
    # source://sorbet-runtime/0.5.11589/lib/types/struct.rb#13
    def inherited(s); end
  end
end

# @abstract It cannot be directly instantiated. Subclasses must implement the `abstract` methods below.
#
# source://spoom//lib/spoom/coverage/d3/pie.rb#9
class Spoom::Coverage::D3::Pie < ::Spoom::Coverage::D3::Base
  abstract!

  # source://spoom//lib/spoom/coverage/d3/pie.rb#16
  sig { params(id: ::String, title: ::String, data: T.untyped).void }
  def initialize(id, title, data); end

  # source://spoom//lib/spoom/coverage/d3/pie.rb#56
  sig { override.returns(::String) }
  def script; end

  class << self
    # source://spoom//lib/spoom/coverage/d3/pie.rb#43
    sig { returns(::String) }
    def header_script; end

    # source://spoom//lib/spoom/coverage/d3/pie.rb#25
    sig { returns(::String) }
    def header_style; end
  end
end

# source://spoom//lib/spoom/coverage/d3/pie.rb#141
class Spoom::Coverage::D3::Pie::Calls < ::Spoom::Coverage::D3::Pie
  # source://spoom//lib/spoom/coverage/d3/pie.rb#145
  sig { params(id: ::String, title: ::String, snapshot: ::Spoom::Coverage::Snapshot).void }
  def initialize(id, title, snapshot); end

  # source://spoom//lib/spoom/coverage/d3/pie.rb#150
  sig { override.returns(::String) }
  def tooltip; end
end

# source://spoom//lib/spoom/coverage/d3/pie.rb#123
class Spoom::Coverage::D3::Pie::Sigils < ::Spoom::Coverage::D3::Pie
  # source://spoom//lib/spoom/coverage/d3/pie.rb#127
  sig { params(id: ::String, title: ::String, snapshot: ::Spoom::Coverage::Snapshot).void }
  def initialize(id, title, snapshot); end

  # source://spoom//lib/spoom/coverage/d3/pie.rb#132
  sig { override.returns(::String) }
  def tooltip; end
end

# source://spoom//lib/spoom/coverage/d3/pie.rb#159
class Spoom::Coverage::D3::Pie::Sigs < ::Spoom::Coverage::D3::Pie
  # source://spoom//lib/spoom/coverage/d3/pie.rb#163
  sig { params(id: ::String, title: ::String, snapshot: ::Spoom::Coverage::Snapshot).void }
  def initialize(id, title, snapshot); end

  # source://spoom//lib/spoom/coverage/d3/pie.rb#172
  sig { override.returns(::String) }
  def tooltip; end
end

# @abstract It cannot be directly instantiated. Subclasses must implement the `abstract` methods below.
#
# source://spoom//lib/spoom/coverage/d3/timeline.rb#9
class Spoom::Coverage::D3::Timeline < ::Spoom::Coverage::D3::Base
  abstract!

  # source://spoom//lib/spoom/coverage/d3/timeline.rb#16
  sig { params(id: ::String, data: T.untyped, keys: T::Array[::String]).void }
  def initialize(id, data, keys); end

  # source://spoom//lib/spoom/coverage/d3/timeline.rb#187
  sig { params(y: ::String, color: ::String, curve: ::String).returns(::String) }
  def area(y:, color: T.unsafe(nil), curve: T.unsafe(nil)); end

  # source://spoom//lib/spoom/coverage/d3/timeline.rb#203
  sig { params(y: ::String, color: ::String, curve: ::String).returns(::String) }
  def line(y:, color: T.unsafe(nil), curve: T.unsafe(nil)); end

  # @abstract
  #
  # source://spoom//lib/spoom/coverage/d3/timeline.rb#126
  sig { abstract.returns(::String) }
  def plot; end

  # source://spoom//lib/spoom/coverage/d3/timeline.rb#217
  sig { params(y: ::String).returns(::String) }
  def points(y:); end

  # source://spoom//lib/spoom/coverage/d3/timeline.rb#101
  sig { override.returns(::String) }
  def script; end

  # source://spoom//lib/spoom/coverage/d3/timeline.rb#129
  sig { returns(::String) }
  def x_scale; end

  # source://spoom//lib/spoom/coverage/d3/timeline.rb#145
  sig { returns(::String) }
  def x_ticks; end

  # source://spoom//lib/spoom/coverage/d3/timeline.rb#158
  sig { params(min: ::String, max: ::String, ticks: ::String).returns(::String) }
  def y_scale(min:, max:, ticks:); end

  # source://spoom//lib/spoom/coverage/d3/timeline.rb#174
  sig { params(ticks: ::String, format: ::String, padding: ::Integer).returns(::String) }
  def y_ticks(ticks:, format:, padding:); end

  class << self
    # source://spoom//lib/spoom/coverage/d3/timeline.rb#79
    sig { returns(::String) }
    def header_script; end

    # source://spoom//lib/spoom/coverage/d3/timeline.rb#25
    sig { returns(::String) }
    def header_style; end
  end
end

# source://spoom//lib/spoom/coverage/d3/timeline.rb#448
class Spoom::Coverage::D3::Timeline::Calls < ::Spoom::Coverage::D3::Timeline::Stacked
  # source://spoom//lib/spoom/coverage/d3/timeline.rb#452
  sig { params(id: ::String, snapshots: T::Array[::Spoom::Coverage::Snapshot]).void }
  def initialize(id, snapshots); end

  # source://spoom//lib/spoom/coverage/d3/timeline.rb#466
  sig { override.returns(::String) }
  def tooltip; end
end

# source://spoom//lib/spoom/coverage/d3/timeline.rb#505
class Spoom::Coverage::D3::Timeline::RBIs < ::Spoom::Coverage::D3::Timeline::Stacked
  # source://spoom//lib/spoom/coverage/d3/timeline.rb#509
  sig { params(id: ::String, snapshots: T::Array[::Spoom::Coverage::Snapshot]).void }
  def initialize(id, snapshots); end

  # source://spoom//lib/spoom/coverage/d3/timeline.rb#577
  sig { override.params(y: ::String, color: ::String, curve: ::String).returns(::String) }
  def line(y:, color: T.unsafe(nil), curve: T.unsafe(nil)); end

  # source://spoom//lib/spoom/coverage/d3/timeline.rb#617
  sig { override.returns(::String) }
  def plot; end

  # source://spoom//lib/spoom/coverage/d3/timeline.rb#537
  sig { override.returns(::String) }
  def script; end

  # source://spoom//lib/spoom/coverage/d3/timeline.rb#523
  sig { override.returns(::String) }
  def tooltip; end
end

# source://spoom//lib/spoom/coverage/d3/timeline.rb#282
class Spoom::Coverage::D3::Timeline::Runtimes < ::Spoom::Coverage::D3::Timeline
  # source://spoom//lib/spoom/coverage/d3/timeline.rb#286
  sig { params(id: ::String, snapshots: T::Array[::Spoom::Coverage::Snapshot]).void }
  def initialize(id, snapshots); end

  # source://spoom//lib/spoom/coverage/d3/timeline.rb#311
  sig { override.returns(::String) }
  def plot; end

  # source://spoom//lib/spoom/coverage/d3/timeline.rb#298
  sig { override.returns(::String) }
  def tooltip; end
end

# source://spoom//lib/spoom/coverage/d3/timeline.rb#421
class Spoom::Coverage::D3::Timeline::Sigils < ::Spoom::Coverage::D3::Timeline::Stacked
  # source://spoom//lib/spoom/coverage/d3/timeline.rb#425
  sig { params(id: ::String, snapshots: T::Array[::Spoom::Coverage::Snapshot]).void }
  def initialize(id, snapshots); end

  # source://spoom//lib/spoom/coverage/d3/timeline.rb#439
  sig { override.returns(::String) }
  def tooltip; end
end

# source://spoom//lib/spoom/coverage/d3/timeline.rb#475
class Spoom::Coverage::D3::Timeline::Sigs < ::Spoom::Coverage::D3::Timeline::Stacked
  # source://spoom//lib/spoom/coverage/d3/timeline.rb#479
  sig { params(id: ::String, snapshots: T::Array[::Spoom::Coverage::Snapshot]).void }
  def initialize(id, snapshots); end

  # source://spoom//lib/spoom/coverage/d3/timeline.rb#496
  sig { override.returns(::String) }
  def tooltip; end
end

# @abstract It cannot be directly instantiated. Subclasses must implement the `abstract` methods below.
#
# source://spoom//lib/spoom/coverage/d3/timeline.rb#329
class Spoom::Coverage::D3::Timeline::Stacked < ::Spoom::Coverage::D3::Timeline
  abstract!

  # source://spoom//lib/spoom/coverage/d3/timeline.rb#388
  sig { override.params(y: ::String, color: ::String, curve: ::String).returns(::String) }
  def line(y:, color: T.unsafe(nil), curve: T.unsafe(nil)); end

  # source://spoom//lib/spoom/coverage/d3/timeline.rb#377
  sig { override.returns(::String) }
  def plot; end

  # source://spoom//lib/spoom/coverage/d3/timeline.rb#336
  sig { override.returns(::String) }
  def script; end
end

# source://spoom//lib/spoom/coverage/d3/timeline.rb#232
class Spoom::Coverage::D3::Timeline::Versions < ::Spoom::Coverage::D3::Timeline
  # source://spoom//lib/spoom/coverage/d3/timeline.rb#236
  sig { params(id: ::String, snapshots: T::Array[::Spoom::Coverage::Snapshot]).void }
  def initialize(id, snapshots); end

  # source://spoom//lib/spoom/coverage/d3/timeline.rb#263
  sig { override.returns(::String) }
  def plot; end

  # source://spoom//lib/spoom/coverage/d3/timeline.rb#249
  sig { override.returns(::String) }
  def tooltip; end
end

# @abstract It cannot be directly instantiated. Subclasses must implement the `abstract` methods below.
#
# source://spoom//lib/spoom/coverage/report.rb#38
class Spoom::Coverage::Page < ::Spoom::Coverage::Template
  abstract!

  # source://spoom//lib/spoom/coverage/report.rb#53
  sig { params(title: ::String, palette: ::Spoom::Coverage::D3::ColorPalette, template: ::String).void }
  def initialize(title:, palette:, template: T.unsafe(nil)); end

  # source://spoom//lib/spoom/coverage/report.rb#75
  sig { returns(::String) }
  def body_html; end

  # @abstract
  #
  # source://spoom//lib/spoom/coverage/report.rb#80
  sig { abstract.returns(T::Array[::Spoom::Coverage::Cards::Card]) }
  def cards; end

  # source://spoom//lib/spoom/coverage/report.rb#83
  sig { returns(::String) }
  def footer_html; end

  # source://spoom//lib/spoom/coverage/report.rb#70
  sig { returns(::String) }
  def header_html; end

  # source://spoom//lib/spoom/coverage/report.rb#65
  sig { returns(::String) }
  def header_script; end

  # source://spoom//lib/spoom/coverage/report.rb#60
  sig { returns(::String) }
  def header_style; end

  # source://spoom//lib/spoom/coverage/report.rb#50
  sig { returns(::Spoom::Coverage::D3::ColorPalette) }
  def palette; end

  # source://spoom//lib/spoom/coverage/report.rb#47
  sig { returns(::String) }
  def title; end
end

# source://spoom//lib/spoom/coverage/report.rb#44
Spoom::Coverage::Page::TEMPLATE = T.let(T.unsafe(nil), String)

# source://spoom//lib/spoom/coverage/report.rb#261
class Spoom::Coverage::Report < ::Spoom::Coverage::Page
  # source://spoom//lib/spoom/coverage/report.rb#276
  sig do
    params(
      project_name: ::String,
      palette: ::Spoom::Coverage::D3::ColorPalette,
      snapshots: T::Array[::Spoom::Coverage::Snapshot],
      file_tree: ::Spoom::FileTree,
      nodes_strictnesses: T::Hash[::Spoom::FileTree::Node, T.nilable(::String)],
      nodes_strictness_scores: T::Hash[::Spoom::FileTree::Node, ::Float],
      sorbet_intro_commit: T.nilable(::String),
      sorbet_intro_date: T.nilable(::Time)
    ).void
  end
  def initialize(project_name:, palette:, snapshots:, file_tree:, nodes_strictnesses:, nodes_strictness_scores:, sorbet_intro_commit: T.unsafe(nil), sorbet_intro_date: T.unsafe(nil)); end

  # source://spoom//lib/spoom/coverage/report.rb#308
  sig { override.returns(T::Array[::Spoom::Coverage::Cards::Card]) }
  def cards; end

  # source://spoom//lib/spoom/coverage/report.rb#297
  sig { override.returns(::String) }
  def header_html; end
end

# source://spoom//lib/spoom/coverage/snapshot.rb#6
class Spoom::Coverage::Snapshot < ::T::Struct
  prop :timestamp, ::Integer, default: T.unsafe(nil)
  prop :version_static, T.nilable(::String), default: T.unsafe(nil)
  prop :version_runtime, T.nilable(::String), default: T.unsafe(nil)
  prop :duration, ::Integer, default: T.unsafe(nil)
  prop :commit_sha, T.nilable(::String), default: T.unsafe(nil)
  prop :commit_timestamp, T.nilable(::Integer), default: T.unsafe(nil)
  prop :files, ::Integer, default: T.unsafe(nil)
  prop :rbi_files, ::Integer, default: T.unsafe(nil)
  prop :modules, ::Integer, default: T.unsafe(nil)
  prop :classes, ::Integer, default: T.unsafe(nil)
  prop :singleton_classes, ::Integer, default: T.unsafe(nil)
  prop :methods_without_sig, ::Integer, default: T.unsafe(nil)
  prop :methods_with_sig, ::Integer, default: T.unsafe(nil)
  prop :calls_untyped, ::Integer, default: T.unsafe(nil)
  prop :calls_typed, ::Integer, default: T.unsafe(nil)
  prop :sigils, T::Hash[::String, ::Integer], default: T.unsafe(nil)
  prop :methods_with_sig_excluding_rbis, ::Integer, default: T.unsafe(nil)
  prop :methods_without_sig_excluding_rbis, ::Integer, default: T.unsafe(nil)
  prop :sigils_excluding_rbis, T::Hash[::String, ::Integer], default: T.unsafe(nil)

  # source://spoom//lib/spoom/coverage/snapshot.rb#33
  sig { params(out: T.any(::IO, ::StringIO), colors: T::Boolean, indent_level: ::Integer).void }
  def print(out: T.unsafe(nil), colors: T.unsafe(nil), indent_level: T.unsafe(nil)); end

  # source://spoom//lib/spoom/coverage/snapshot.rb#39
  sig { params(arg: T.untyped).returns(::String) }
  def to_json(*arg); end

  class << self
    # source://spoom//lib/spoom/coverage/snapshot.rb#47
    sig { params(json: ::String).returns(::Spoom::Coverage::Snapshot) }
    def from_json(json); end

    # source://spoom//lib/spoom/coverage/snapshot.rb#52
    sig { params(obj: T::Hash[::String, T.untyped]).returns(::Spoom::Coverage::Snapshot) }
    def from_obj(obj); end

    # source://sorbet-runtime/0.5.11589/lib/types/struct.rb#13
    def inherited(s); end
  end
end

# The strictness name as found in the Sorbet metrics file
#
# source://spoom//lib/spoom/coverage/snapshot.rb#30
Spoom::Coverage::Snapshot::STRICTNESSES = T.let(T.unsafe(nil), Array)

# source://spoom//lib/spoom/coverage/snapshot.rb#95
class Spoom::Coverage::SnapshotPrinter < ::Spoom::Printer
  # source://spoom//lib/spoom/coverage/snapshot.rb#99
  sig { params(snapshot: ::Spoom::Coverage::Snapshot).void }
  def print_snapshot(snapshot); end

  private

  # source://spoom//lib/spoom/coverage/snapshot.rb#158
  sig { params(value: T.nilable(::Integer), total: T.nilable(::Integer)).returns(::String) }
  def percent(value, total); end

  # source://spoom//lib/spoom/coverage/snapshot.rb#147
  sig { params(hash: T::Hash[::String, ::Integer], total: ::Integer).void }
  def print_map(hash, total); end
end

# @abstract It cannot be directly instantiated. Subclasses must implement the `abstract` methods below.
#
# source://spoom//lib/spoom/coverage/report.rb#10
class Spoom::Coverage::Template
  abstract!

  # Create a new template from an Erb file path
  #
  # source://spoom//lib/spoom/coverage/report.rb#18
  sig { params(template: ::String).void }
  def initialize(template:); end

  # source://spoom//lib/spoom/coverage/report.rb#23
  sig { returns(::String) }
  def erb; end

  # source://spoom//lib/spoom/coverage/report.rb#33
  sig { returns(::Binding) }
  def get_binding; end

  # source://spoom//lib/spoom/coverage/report.rb#28
  sig { returns(::String) }
  def html; end
end

# source://spoom//lib/spoom/deadcode/erb.rb#27
module Spoom::Deadcode
  class << self
    # source://spoom//lib/spoom/deadcode/plugins.rb#75
    sig { params(context: ::Spoom::Context).returns(T::Array[T.class_of(Spoom::Deadcode::Plugins::Base)]) }
    def load_custom_plugins(context); end

    # source://spoom//lib/spoom/deadcode/plugins.rb#61
    sig { params(context: ::Spoom::Context).returns(T::Set[T.class_of(Spoom::Deadcode::Plugins::Base)]) }
    def plugins_from_gemfile_lock(context); end
  end
end

# source://spoom//lib/spoom/deadcode/plugins.rb#26
Spoom::Deadcode::DEFAULT_CUSTOM_PLUGINS_PATH = T.let(T.unsafe(nil), String)

# source://spoom//lib/spoom/deadcode/plugins.rb#28
Spoom::Deadcode::DEFAULT_PLUGINS = T.let(T.unsafe(nil), Set)

# A definition is a class, module, method, constant, etc. being defined in the code
#
# source://spoom//lib/spoom/deadcode/definition.rb#7
class Spoom::Deadcode::Definition < ::T::Struct
  const :kind, ::Spoom::Deadcode::Definition::Kind
  const :name, ::String
  const :full_name, ::String
  const :location, ::Spoom::Location
  const :status, ::Spoom::Deadcode::Definition::Status, default: T.unsafe(nil)

  # source://spoom//lib/spoom/deadcode/definition.rb#78
  sig { void }
  def alive!; end

  # Status
  #
  # source://spoom//lib/spoom/deadcode/definition.rb#73
  sig { returns(T::Boolean) }
  def alive?; end

  # Kind
  #
  # source://spoom//lib/spoom/deadcode/definition.rb#41
  sig { returns(T::Boolean) }
  def attr_reader?; end

  # source://spoom//lib/spoom/deadcode/definition.rb#46
  sig { returns(T::Boolean) }
  def attr_writer?; end

  # source://spoom//lib/spoom/deadcode/definition.rb#51
  sig { returns(T::Boolean) }
  def class?; end

  # source://spoom//lib/spoom/deadcode/definition.rb#56
  sig { returns(T::Boolean) }
  def constant?; end

  # source://spoom//lib/spoom/deadcode/definition.rb#83
  sig { returns(T::Boolean) }
  def dead?; end

  # source://spoom//lib/spoom/deadcode/definition.rb#93
  sig { void }
  def ignored!; end

  # source://spoom//lib/spoom/deadcode/definition.rb#88
  sig { returns(T::Boolean) }
  def ignored?; end

  # source://spoom//lib/spoom/deadcode/definition.rb#61
  sig { returns(T::Boolean) }
  def method?; end

  # source://spoom//lib/spoom/deadcode/definition.rb#66
  sig { returns(T::Boolean) }
  def module?; end

  # Utils
  #
  # source://spoom//lib/spoom/deadcode/definition.rb#100
  sig { params(args: T.untyped).returns(::String) }
  def to_json(*args); end

  class << self
    # source://sorbet-runtime/0.5.11589/lib/types/struct.rb#13
    def inherited(s); end
  end
end

# source://spoom//lib/spoom/deadcode/definition.rb#10
class Spoom::Deadcode::Definition::Kind < ::T::Enum
  enums do
    AttrReader = new
    AttrWriter = new
    Class = new
    Constant = new
    Method = new
    Module = new
  end
end

# source://spoom//lib/spoom/deadcode/definition.rb#21
class Spoom::Deadcode::Definition::Status < ::T::Enum
  enums do
    ALIVE = new
    DEAD = new
    IGNORED = new
  end
end

# Custom engine to handle ERB templates as used by Rails
#
# source://spoom//lib/spoom/deadcode/erb.rb#29
class Spoom::Deadcode::ERB < ::Erubi::Engine
  # source://spoom//lib/spoom/deadcode/erb.rb#33
  sig { params(input: T.untyped, properties: T.untyped).void }
  def initialize(input, properties = T.unsafe(nil)); end

  private

  # source://spoom//lib/spoom/deadcode/erb.rb#83
  sig { override.params(code: T.untyped).void }
  def add_code(code); end

  # source://spoom//lib/spoom/deadcode/erb.rb#66
  sig { override.params(indicator: T.untyped, code: T.untyped).void }
  def add_expression(indicator, code); end

  # source://spoom//lib/spoom/deadcode/erb.rb#89
  sig { override.params(_: T.untyped).void }
  def add_postamble(_); end

  # source://spoom//lib/spoom/deadcode/erb.rb#48
  sig { override.params(text: T.untyped).void }
  def add_text(text); end

  # source://spoom//lib/spoom/deadcode/erb.rb#95
  sig { params(src: T.untyped).void }
  def flush_newline_if_pending(src); end
end

# source://spoom//lib/spoom/deadcode/erb.rb#63
Spoom::Deadcode::ERB::BLOCK_EXPR = T.let(T.unsafe(nil), Regexp)

# source://spoom//lib/spoom/deadcode/index.rb#6
class Spoom::Deadcode::Index
  # source://spoom//lib/spoom/deadcode/index.rb#29
  sig { params(model: ::Spoom::Model).void }
  def initialize(model); end

  # source://spoom//lib/spoom/deadcode/index.rb#219
  sig { returns(T::Array[::Spoom::Deadcode::Definition]) }
  def all_definitions; end

  # source://spoom//lib/spoom/deadcode/index.rb#224
  sig { returns(T::Array[::Spoom::Model::Reference]) }
  def all_references; end

  # source://spoom//lib/spoom/deadcode/index.rb#99
  sig { params(plugins: T::Array[::Spoom::Deadcode::Plugins::Base]).void }
  def apply_plugins!(plugins); end

  # source://spoom//lib/spoom/deadcode/index.rb#79
  sig { params(definition: ::Spoom::Deadcode::Definition).void }
  def define(definition); end

  # source://spoom//lib/spoom/deadcode/index.rb#23
  sig { returns(T::Hash[::String, T::Array[::Spoom::Deadcode::Definition]]) }
  def definitions; end

  # Utils
  #
  # source://spoom//lib/spoom/deadcode/index.rb#214
  sig { params(name: ::String).returns(T::Array[::Spoom::Deadcode::Definition]) }
  def definitions_for_name(name); end

  # Mark all definitions having a reference of the same name as `alive`
  #
  # To be called once all the files have been indexed and all the definitions and references discovered.
  #
  # source://spoom//lib/spoom/deadcode/index.rb#122
  sig { void }
  def finalize!; end

  # source://spoom//lib/spoom/deadcode/index.rb#94
  sig { params(symbol_def: ::Spoom::Model::SymbolDef).void }
  def ignore(symbol_def); end

  # source://spoom//lib/spoom/deadcode/index.rb#50
  sig { params(erb: ::String, file: ::String, plugins: T::Array[::Spoom::Deadcode::Plugins::Base]).void }
  def index_erb(erb, file:, plugins: T.unsafe(nil)); end

  # Indexing
  #
  # source://spoom//lib/spoom/deadcode/index.rb#39
  sig { params(file: ::String, plugins: T::Array[::Spoom::Deadcode::Plugins::Base]).void }
  def index_file(file, plugins: T.unsafe(nil)); end

  # source://spoom//lib/spoom/deadcode/index.rb#55
  sig { params(rb: ::String, file: ::String, plugins: T::Array[::Spoom::Deadcode::Plugins::Base]).void }
  def index_ruby(rb, file:, plugins: T.unsafe(nil)); end

  # source://spoom//lib/spoom/deadcode/index.rb#20
  sig { returns(::Spoom::Model) }
  def model; end

  # source://spoom//lib/spoom/deadcode/index.rb#84
  sig { params(name: ::String, location: ::Spoom::Location).void }
  def reference_constant(name, location); end

  # source://spoom//lib/spoom/deadcode/index.rb#89
  sig { params(name: ::String, location: ::Spoom::Location).void }
  def reference_method(name, location); end

  # source://spoom//lib/spoom/deadcode/index.rb#26
  sig { returns(T::Hash[::String, T::Array[::Spoom::Model::Reference]]) }
  def references; end
end

# source://spoom//lib/spoom/deadcode/index.rb#9
class Spoom::Deadcode::Index::Error < ::Spoom::Error
  # source://spoom//lib/spoom/deadcode/index.rb#13
  sig { params(message: ::String, parent: ::Exception).void }
  def initialize(message, parent:); end
end

# source://spoom//lib/spoom/deadcode/indexer.rb#6
class Spoom::Deadcode::Indexer < ::Spoom::Visitor
  # source://spoom//lib/spoom/deadcode/indexer.rb#16
  sig do
    params(
      path: ::String,
      index: ::Spoom::Deadcode::Index,
      plugins: T::Array[::Spoom::Deadcode::Plugins::Base]
    ).void
  end
  def initialize(path, index, plugins: T.unsafe(nil)); end

  # source://spoom//lib/spoom/deadcode/indexer.rb#13
  sig { returns(::Spoom::Deadcode::Index) }
  def index; end

  # source://spoom//lib/spoom/deadcode/indexer.rb#10
  sig { returns(::String) }
  def path; end

  # Visit
  #
  # source://spoom//lib/spoom/deadcode/indexer.rb#27
  sig { override.params(node: ::Prism::CallNode).void }
  def visit_call_node(node); end
end

# source://spoom//lib/spoom/deadcode/plugins.rb#36
Spoom::Deadcode::PLUGINS_FOR_GEM = T.let(T.unsafe(nil), Hash)

# source://spoom//lib/spoom/deadcode/plugins/base.rb#8
module Spoom::Deadcode::Plugins; end

# source://spoom//lib/spoom/deadcode/plugins/action_mailer.rb#7
class Spoom::Deadcode::Plugins::ActionMailer < ::Spoom::Deadcode::Plugins::Base
  # source://spoom//lib/spoom/deadcode/plugins/action_mailer.rb#11
  sig { override.params(send: ::Spoom::Deadcode::Send).void }
  def on_send(send); end
end

# source://spoom//lib/spoom/deadcode/plugins/action_mailer_preview.rb#7
class Spoom::Deadcode::Plugins::ActionMailerPreview < ::Spoom::Deadcode::Plugins::Base
  # source://spoom//lib/spoom/deadcode/plugins/action_mailer_preview.rb#13
  sig { override.params(definition: ::Spoom::Model::Method).void }
  def on_define_method(definition); end
end

# source://spoom//lib/spoom/deadcode/plugins/actionpack.rb#7
class Spoom::Deadcode::Plugins::ActionPack < ::Spoom::Deadcode::Plugins::Base
  # source://spoom//lib/spoom/deadcode/plugins/actionpack.rb#31
  sig { override.params(definition: ::Spoom::Model::Method).void }
  def on_define_method(definition); end

  # source://spoom//lib/spoom/deadcode/plugins/actionpack.rb#39
  sig { override.params(send: ::Spoom::Deadcode::Send).void }
  def on_send(send); end
end

# source://spoom//lib/spoom/deadcode/plugins/actionpack.rb#12
Spoom::Deadcode::Plugins::ActionPack::CALLBACKS = T.let(T.unsafe(nil), Array)

# source://spoom//lib/spoom/deadcode/plugins/active_job.rb#7
class Spoom::Deadcode::Plugins::ActiveJob < ::Spoom::Deadcode::Plugins::Base; end

# source://spoom//lib/spoom/deadcode/plugins/active_model.rb#7
class Spoom::Deadcode::Plugins::ActiveModel < ::Spoom::Deadcode::Plugins::Base
  # source://spoom//lib/spoom/deadcode/plugins/active_model.rb#14
  sig { override.params(send: ::Spoom::Deadcode::Send).void }
  def on_send(send); end
end

# source://spoom//lib/spoom/deadcode/plugins/active_record.rb#7
class Spoom::Deadcode::Plugins::ActiveRecord < ::Spoom::Deadcode::Plugins::Base
  # source://spoom//lib/spoom/deadcode/plugins/active_record.rb#74
  sig { override.params(send: ::Spoom::Deadcode::Send).void }
  def on_send(send); end
end

# source://spoom//lib/spoom/deadcode/plugins/active_record.rb#64
Spoom::Deadcode::Plugins::ActiveRecord::ARRAY_METHODS = T.let(T.unsafe(nil), Array)

# source://spoom//lib/spoom/deadcode/plugins/active_record.rb#20
Spoom::Deadcode::Plugins::ActiveRecord::CALLBACKS = T.let(T.unsafe(nil), Array)

# source://spoom//lib/spoom/deadcode/plugins/active_record.rb#49
Spoom::Deadcode::Plugins::ActiveRecord::CRUD_METHODS = T.let(T.unsafe(nil), Array)

# source://spoom//lib/spoom/deadcode/plugins/active_support.rb#7
class Spoom::Deadcode::Plugins::ActiveSupport < ::Spoom::Deadcode::Plugins::Base
  # source://spoom//lib/spoom/deadcode/plugins/active_support.rb#22
  sig { override.params(send: ::Spoom::Deadcode::Send).void }
  def on_send(send); end
end

# source://spoom//lib/spoom/deadcode/plugins/active_support.rb#19
Spoom::Deadcode::Plugins::ActiveSupport::SETUP_AND_TEARDOWN_METHODS = T.let(T.unsafe(nil), Array)

# @abstract It cannot be directly instantiated. Subclasses must implement the `abstract` methods below.
#
# source://spoom//lib/spoom/deadcode/plugins/base.rb#9
class Spoom::Deadcode::Plugins::Base
  abstract!

  # source://spoom//lib/spoom/deadcode/plugins/base.rb#132
  sig { params(index: ::Spoom::Deadcode::Index).void }
  def initialize(index); end

  # source://spoom//lib/spoom/deadcode/plugins/base.rb#129
  sig { returns(::Spoom::Deadcode::Index) }
  def index; end

  # Do not override this method, use `on_define_accessor` instead.
  #
  # source://spoom//lib/spoom/deadcode/plugins/base.rb#158
  sig { params(definition: ::Spoom::Model::Attr).void }
  def internal_on_define_accessor(definition); end

  # Do not override this method, use `on_define_class` instead.
  #
  # source://spoom//lib/spoom/deadcode/plugins/base.rb#182
  sig { params(definition: ::Spoom::Model::Class).void }
  def internal_on_define_class(definition); end

  # Do not override this method, use `on_define_constant` instead.
  #
  # source://spoom//lib/spoom/deadcode/plugins/base.rb#212
  sig { params(definition: ::Spoom::Model::Constant).void }
  def internal_on_define_constant(definition); end

  # Do not override this method, use `on_define_method` instead.
  #
  # source://spoom//lib/spoom/deadcode/plugins/base.rb#238
  sig { params(definition: ::Spoom::Model::Method).void }
  def internal_on_define_method(definition); end

  # Do not override this method, use `on_define_module` instead.
  #
  # source://spoom//lib/spoom/deadcode/plugins/base.rb#264
  sig { params(definition: ::Spoom::Model::Module).void }
  def internal_on_define_module(definition); end

  # Called when an accessor is defined.
  #
  # Will be called when the indexer processes a `attr_reader`, `attr_writer` or `attr_accessor` node.
  # Note that when this method is called, the definition for the node has already been added to the index.
  # It is still possible to ignore it from the plugin:
  #
  # ~~~rb
  # class MyPlugin < Spoom::Deadcode::Plugins::Base
  #   def on_define_accessor(definition)
  #     @index.ignore(definition) if symbol_def.name == "foo"
  #   end
  # end
  # ~~~
  #
  # source://spoom//lib/spoom/deadcode/plugins/base.rb#152
  sig { params(definition: ::Spoom::Model::Attr).void }
  def on_define_accessor(definition); end

  # Called when a class is defined.
  #
  # Will be called when the indexer processes a `class` node.
  # Note that when this method is called, the definition for the node has already been added to the index.
  # It is still possible to ignore it from the plugin:
  #
  # ~~~rb
  # class MyPlugin < Spoom::Deadcode::Plugins::Base
  #   def on_define_class(definition)
  #     @index.ignore(definition) if definition.name == "Foo"
  #   end
  # end
  # ~~~
  #
  # source://spoom//lib/spoom/deadcode/plugins/base.rb#176
  sig { params(definition: ::Spoom::Model::Class).void }
  def on_define_class(definition); end

  # Called when a constant is defined.
  #
  # Will be called when the indexer processes a `CONST =` node.
  # Note that when this method is called, the definition for the node has already been added to the index.
  # It is still possible to ignore it from the plugin:
  #
  # ~~~rb
  # class MyPlugin < Spoom::Deadcode::Plugins::Base
  #   def on_define_constant(definition)
  #     @index.ignore(definition) if definition.name == "FOO"
  #   end
  # end
  # ~~~
  #
  # source://spoom//lib/spoom/deadcode/plugins/base.rb#206
  sig { params(definition: ::Spoom::Model::Constant).void }
  def on_define_constant(definition); end

  # Called when a method is defined.
  #
  # Will be called when the indexer processes a `def` or `defs` node.
  # Note that when this method is called, the definition for the node has already been added to the index.
  # It is still possible to ignore it from the plugin:
  #
  # ~~~rb
  # class MyPlugin < Spoom::Deadcode::Plugins::Base
  #   def on_define_method(definition)
  #     @index.ignore(definition) if definition.name == "foo"
  #   end
  # end
  # ~~~
  #
  # source://spoom//lib/spoom/deadcode/plugins/base.rb#232
  sig { params(definition: ::Spoom::Model::Method).void }
  def on_define_method(definition); end

  # Called when a module is defined.
  #
  # Will be called when the indexer processes a `module` node.
  # Note that when this method is called, the definition for the node has already been added to the index.
  # It is still possible to ignore it from the plugin:
  #
  # ~~~rb
  # class MyPlugin < Spoom::Deadcode::Plugins::Base
  #   def on_define_module(definition)
  #     @index.ignore(definition) if definition.name == "Foo"
  #   end
  # end
  # ~~~
  #
  # source://spoom//lib/spoom/deadcode/plugins/base.rb#258
  sig { params(definition: ::Spoom::Model::Module).void }
  def on_define_module(definition); end

  # Called when a send is being processed
  #
  # ~~~rb
  # class MyPlugin < Spoom::Deadcode::Plugins::Base
  #   def on_send(send)
  #     return unless send.name == "dsl_method"
  #     return if send.args.empty?
  #
  #     method_name = send.args.first.slice.delete_prefix(":")
  #     @index.reference_method(method_name, send.node, send.loc)
  #   end
  # end
  # ~~~
  #
  # source://spoom//lib/spoom/deadcode/plugins/base.rb#284
  sig { params(send: ::Spoom::Deadcode::Send).void }
  def on_send(send); end

  private

  # Plugin utils
  #
  # source://spoom//lib/spoom/deadcode/plugins/base.rb#352
  sig { params(name: ::String).returns(::String) }
  def camelize(name); end

  # source://spoom//lib/spoom/deadcode/plugins/base.rb#301
  sig { params(name: T.nilable(::String)).returns(T::Boolean) }
  def ignored_class_name?(name); end

  # source://spoom//lib/spoom/deadcode/plugins/base.rb#320
  sig { params(name: ::String).returns(T::Boolean) }
  def ignored_constant_name?(name); end

  # source://spoom//lib/spoom/deadcode/plugins/base.rb#325
  sig { params(name: ::String).returns(T::Boolean) }
  def ignored_method_name?(name); end

  # source://spoom//lib/spoom/deadcode/plugins/base.rb#330
  sig { params(name: ::String).returns(T::Boolean) }
  def ignored_module_name?(name); end

  # source://spoom//lib/spoom/deadcode/plugins/base.rb#335
  sig { params(name: ::String, names_variable: ::Symbol, patterns_variable: ::Symbol).returns(T::Boolean) }
  def ignored_name?(name, names_variable, patterns_variable); end

  # source://spoom//lib/spoom/deadcode/plugins/base.rb#308
  sig { params(definition: ::Spoom::Model::Class).returns(T::Boolean) }
  def ignored_subclass?(definition); end

  # source://spoom//lib/spoom/deadcode/plugins/base.rb#340
  sig { params(const: ::Symbol).returns(T::Set[::String]) }
  def names(const); end

  # source://spoom//lib/spoom/deadcode/plugins/base.rb#345
  sig { params(const: ::Symbol).returns(T::Array[::Regexp]) }
  def patterns(const); end

  # DSL support
  #
  # source://spoom//lib/spoom/deadcode/plugins/base.rb#293
  sig { params(definition: ::Spoom::Model::Namespace, superclass_name: ::String).returns(T::Boolean) }
  def subclass_of?(definition, superclass_name); end

  class << self
    # Mark classes directly subclassing a class matching `names` as ignored.
    #
    # Names can be either strings or regexps:
    #
    # ~~~rb
    # class MyPlugin < Spoom::Deadcode::Plugins::Base
    #   ignore_classes_inheriting_from(
    #     "Foo",
    #     "Bar",
    #     /Baz.*/,
    #   )
    # end
    # ~~~
    #
    # source://spoom//lib/spoom/deadcode/plugins/base.rb#52
    sig { params(names: T.any(::Regexp, ::String)).void }
    def ignore_classes_inheriting_from(*names); end

    # Mark classes matching `names` as ignored.
    #
    # Names can be either strings or regexps:
    #
    # ~~~rb
    # class MyPlugin < Spoom::Deadcode::Plugins::Base
    #   ignore_class_names(
    #     "Foo",
    #     "Bar",
    #     /Baz.*/,
    #   )
    # end
    # ~~~
    #
    # source://spoom//lib/spoom/deadcode/plugins/base.rb#34
    sig { params(names: T.any(::Regexp, ::String)).void }
    def ignore_classes_named(*names); end

    # Mark constants matching `names` as ignored.
    #
    # Names can be either strings or regexps:
    #
    # ~~~rb
    # class MyPlugin < Spoom::Deadcode::Plugins::Base
    #   ignore_class_names(
    #     "FOO",
    #     "BAR",
    #     /BAZ.*/,
    #   )
    # end
    # ~~~
    #
    # source://spoom//lib/spoom/deadcode/plugins/base.rb#70
    sig { params(names: T.any(::Regexp, ::String)).void }
    def ignore_constants_named(*names); end

    # Mark methods matching `names` as ignored.
    #
    # Names can be either strings or regexps:
    #
    # ~~~rb
    # class MyPlugin < Spoom::Deadcode::Plugins::Base
    #   ignore_method_names(
    #     "foo",
    #     "bar",
    #     /baz.*/,
    #   )
    # end
    # ~~~
    #
    # source://spoom//lib/spoom/deadcode/plugins/base.rb#88
    sig { params(names: T.any(::Regexp, ::String)).void }
    def ignore_methods_named(*names); end

    # Mark modules matching `names` as ignored.
    #
    # Names can be either strings or regexps:
    #
    # ~~~rb
    # class MyPlugin < Spoom::Deadcode::Plugins::Base
    #   ignore_class_names(
    #     "Foo",
    #     "Bar",
    #     /Baz.*/,
    #   )
    # end
    # ~~~
    #
    # source://spoom//lib/spoom/deadcode/plugins/base.rb#106
    sig { params(names: T.any(::Regexp, ::String)).void }
    def ignore_modules_named(*names); end

    private

    # source://spoom//lib/spoom/deadcode/plugins/base.rb#113
    sig do
      params(
        names: T::Array[T.any(::Regexp, ::String)],
        names_variable: ::Symbol,
        patterns_variable: ::Symbol
      ).void
    end
    def save_names_and_patterns(names, names_variable, patterns_variable); end
  end
end

# source://spoom//lib/spoom/deadcode/plugins/graphql.rb#7
class Spoom::Deadcode::Plugins::GraphQL < ::Spoom::Deadcode::Plugins::Base
  # source://spoom//lib/spoom/deadcode/plugins/graphql.rb#28
  sig { override.params(send: ::Spoom::Deadcode::Send).void }
  def on_send(send); end
end

# source://spoom//lib/spoom/deadcode/plugins/minitest.rb#7
class Spoom::Deadcode::Plugins::Minitest < ::Spoom::Deadcode::Plugins::Base
  # source://spoom//lib/spoom/deadcode/plugins/minitest.rb#22
  sig { override.params(definition: ::Spoom::Model::Method).void }
  def on_define_method(definition); end

  # source://spoom//lib/spoom/deadcode/plugins/minitest.rb#28
  sig { override.params(send: ::Spoom::Deadcode::Send).void }
  def on_send(send); end
end

# source://spoom//lib/spoom/deadcode/plugins/namespaces.rb#7
class Spoom::Deadcode::Plugins::Namespaces < ::Spoom::Deadcode::Plugins::Base
  # source://spoom//lib/spoom/deadcode/plugins/namespaces.rb#11
  sig { override.params(definition: ::Spoom::Model::Class).void }
  def on_define_class(definition); end

  # source://spoom//lib/spoom/deadcode/plugins/namespaces.rb#16
  sig { override.params(definition: ::Spoom::Model::Module).void }
  def on_define_module(definition); end

  private

  # source://spoom//lib/spoom/deadcode/plugins/namespaces.rb#23
  sig { params(symbol_def: ::Spoom::Model::Namespace).returns(T::Boolean) }
  def used_as_namespace?(symbol_def); end
end

# source://spoom//lib/spoom/deadcode/plugins/rspec.rb#7
class Spoom::Deadcode::Plugins::RSpec < ::Spoom::Deadcode::Plugins::Base; end

# source://spoom//lib/spoom/deadcode/plugins/rails.rb#7
class Spoom::Deadcode::Plugins::Rails < ::Spoom::Deadcode::Plugins::Base
  # source://spoom//lib/spoom/deadcode/plugins/rails.rb#13
  sig { override.params(definition: ::Spoom::Model::Class).void }
  def on_define_class(definition); end

  # source://spoom//lib/spoom/deadcode/plugins/rails.rb#18
  sig { override.params(definition: ::Spoom::Model::Module).void }
  def on_define_module(definition); end

  private

  # source://spoom//lib/spoom/deadcode/plugins/rails.rb#25
  sig { params(symbol_def: ::Spoom::Model::Namespace).returns(T::Boolean) }
  def file_is_helper?(symbol_def); end
end

# source://spoom//lib/spoom/deadcode/plugins/rake.rb#7
class Spoom::Deadcode::Plugins::Rake < ::Spoom::Deadcode::Plugins::Base; end

# source://spoom//lib/spoom/deadcode/plugins/rubocop.rb#7
class Spoom::Deadcode::Plugins::Rubocop < ::Spoom::Deadcode::Plugins::Base
  # source://spoom//lib/spoom/deadcode/plugins/rubocop.rb#18
  sig { override.params(definition: ::Spoom::Model::Constant).void }
  def on_define_constant(definition); end

  # source://spoom//lib/spoom/deadcode/plugins/rubocop.rb#26
  sig { override.params(definition: ::Spoom::Model::Method).void }
  def on_define_method(definition); end
end

# source://spoom//lib/spoom/deadcode/plugins/rubocop.rb#10
Spoom::Deadcode::Plugins::Rubocop::RUBOCOP_CONSTANTS = T.let(T.unsafe(nil), Set)

# source://spoom//lib/spoom/deadcode/plugins/ruby.rb#7
class Spoom::Deadcode::Plugins::Ruby < ::Spoom::Deadcode::Plugins::Base
  # source://spoom//lib/spoom/deadcode/plugins/ruby.rb#24
  sig { override.params(send: ::Spoom::Deadcode::Send).void }
  def on_send(send); end

  private

  # source://spoom//lib/spoom/deadcode/plugins/ruby.rb#46
  sig { params(send: ::Spoom::Deadcode::Send, node: ::Prism::Node).void }
  def reference_symbol_as_constant(send, node); end
end

# source://spoom//lib/spoom/deadcode/plugins/sorbet.rb#7
class Spoom::Deadcode::Plugins::Sorbet < ::Spoom::Deadcode::Plugins::Base
  # source://spoom//lib/spoom/deadcode/plugins/sorbet.rb#11
  sig { override.params(definition: ::Spoom::Model::Constant).void }
  def on_define_constant(definition); end

  # source://spoom//lib/spoom/deadcode/plugins/sorbet.rb#16
  sig { override.params(definition: ::Spoom::Model::Method).void }
  def on_define_method(definition); end

  private

  # source://spoom//lib/spoom/deadcode/plugins/sorbet.rb#28
  sig { params(definition: ::Spoom::Model::Constant).returns(T::Boolean) }
  def sorbet_enum_constant?(definition); end

  # source://spoom//lib/spoom/deadcode/plugins/sorbet.rb#23
  sig { params(definition: ::Spoom::Model::Constant).returns(T::Boolean) }
  def sorbet_type_member?(definition); end
end

# source://spoom//lib/spoom/deadcode/plugins/thor.rb#7
class Spoom::Deadcode::Plugins::Thor < ::Spoom::Deadcode::Plugins::Base
  # source://spoom//lib/spoom/deadcode/plugins/thor.rb#13
  sig { override.params(definition: ::Spoom::Model::Method).void }
  def on_define_method(definition); end
end

# source://spoom//lib/spoom/deadcode/remover.rb#6
class Spoom::Deadcode::Remover
  # source://spoom//lib/spoom/deadcode/remover.rb#12
  sig { params(context: ::Spoom::Context).void }
  def initialize(context); end

  # source://spoom//lib/spoom/deadcode/remover.rb#17
  sig { params(kind: T.nilable(::Spoom::Deadcode::Definition::Kind), location: ::Spoom::Location).returns(::String) }
  def remove_location(kind, location); end
end

# source://spoom//lib/spoom/deadcode/remover.rb#9
class Spoom::Deadcode::Remover::Error < ::Spoom::Error; end

# source://spoom//lib/spoom/deadcode/remover.rb#372
class Spoom::Deadcode::Remover::NodeContext
  # source://spoom//lib/spoom/deadcode/remover.rb#392
  sig do
    params(
      source: ::String,
      comments: T::Hash[::Integer, ::Prism::Comment],
      node: ::Prism::Node,
      nesting: T::Array[::Prism::Node]
    ).void
  end
  def initialize(source, comments, node, nesting); end

  # source://spoom//lib/spoom/deadcode/remover.rb#506
  sig { params(node: ::Prism::Node).returns(T::Array[::Prism::Comment]) }
  def attached_comments(node); end

  # source://spoom//lib/spoom/deadcode/remover.rb#534
  sig { returns(T.nilable(::Prism::CallNode)) }
  def attached_sig; end

  # source://spoom//lib/spoom/deadcode/remover.rb#521
  sig { returns(T::Array[::Prism::Node]) }
  def attached_sigs; end

  # source://spoom//lib/spoom/deadcode/remover.rb#376
  sig { returns(T::Hash[::Integer, ::Prism::Comment]) }
  def comments; end

  # source://spoom//lib/spoom/deadcode/remover.rb#494
  sig { params(start_line: ::Integer, end_line: ::Integer).returns(T::Array[::Prism::Comment]) }
  def comments_between_lines(start_line, end_line); end

  # source://spoom//lib/spoom/deadcode/remover.rb#382
  sig { returns(T::Array[::Prism::Node]) }
  def nesting; end

  # @return [Array<Prism::Node>]
  #
  # source://spoom//lib/spoom/deadcode/remover.rb#382
  def nesting=(_arg0); end

  # source://spoom//lib/spoom/deadcode/remover.rb#444
  sig { returns(T.nilable(::Prism::Node)) }
  def next_node; end

  # @raise [Error]
  #
  # source://spoom//lib/spoom/deadcode/remover.rb#433
  sig { returns(T::Array[::Prism::Node]) }
  def next_nodes; end

  # source://spoom//lib/spoom/deadcode/remover.rb#379
  sig { returns(::Prism::Node) }
  def node; end

  # @raise [Error]
  #
  # source://spoom//lib/spoom/deadcode/remover.rb#408
  sig { returns(::Spoom::Deadcode::Remover::NodeContext) }
  def parent_context; end

  # @raise [Error]
  #
  # source://spoom//lib/spoom/deadcode/remover.rb#400
  sig { returns(::Prism::Node) }
  def parent_node; end

  # source://spoom//lib/spoom/deadcode/remover.rb#428
  sig { returns(T.nilable(::Prism::Node)) }
  def previous_node; end

  # @raise [Error]
  #
  # source://spoom//lib/spoom/deadcode/remover.rb#417
  sig { returns(T::Array[::Prism::Node]) }
  def previous_nodes; end

  # source://spoom//lib/spoom/deadcode/remover.rb#449
  sig { returns(T.nilable(::Spoom::Deadcode::Remover::NodeContext)) }
  def sclass_context; end

  # source://spoom//lib/spoom/deadcode/remover.rb#482
  sig { params(node: T.nilable(::Prism::Node)).returns(T::Boolean) }
  def sorbet_extend_sig?(node); end

  # source://spoom//lib/spoom/deadcode/remover.rb#477
  sig { params(node: T.nilable(::Prism::Node)).returns(T::Boolean) }
  def sorbet_signature?(node); end
end

# source://spoom//lib/spoom/deadcode/remover.rb#549
class Spoom::Deadcode::Remover::NodeFinder < ::Spoom::Visitor
  # source://spoom//lib/spoom/deadcode/remover.rb#621
  sig { params(location: ::Spoom::Location, kind: T.nilable(::Spoom::Deadcode::Definition::Kind)).void }
  def initialize(location, kind); end

  # source://spoom//lib/spoom/deadcode/remover.rb#615
  sig { returns(T.nilable(::Prism::Node)) }
  def node; end

  # source://spoom//lib/spoom/deadcode/remover.rb#618
  sig { returns(T::Array[::Prism::Node]) }
  def nodes_nesting; end

  # source://spoom//lib/spoom/deadcode/remover.rb#630
  sig { override.params(node: T.nilable(::Prism::Node)).void }
  def visit(node); end

  class << self
    # source://spoom//lib/spoom/deadcode/remover.rb#556
    sig do
      params(
        source: ::String,
        location: ::Spoom::Location,
        kind: T.nilable(::Spoom::Deadcode::Definition::Kind)
      ).returns(::Spoom::Deadcode::Remover::NodeContext)
    end
    def find(source, location, kind); end

    # source://spoom//lib/spoom/deadcode/remover.rb#590
    sig { params(node: ::Prism::Node, kind: ::Spoom::Deadcode::Definition::Kind).returns(T::Boolean) }
    def node_match_kind?(node, kind); end
  end
end

# source://spoom//lib/spoom/deadcode/remover.rb#29
class Spoom::Deadcode::Remover::NodeRemover
  # source://spoom//lib/spoom/deadcode/remover.rb#36
  sig do
    params(
      source: ::String,
      kind: T.nilable(::Spoom::Deadcode::Definition::Kind),
      location: ::Spoom::Location
    ).void
  end
  def initialize(source, kind, location); end

  # source://spoom//lib/spoom/deadcode/remover.rb#46
  sig { void }
  def apply_edit; end

  # source://spoom//lib/spoom/deadcode/remover.rb#33
  sig { returns(::String) }
  def new_source; end

  private

  # source://spoom//lib/spoom/deadcode/remover.rb#153
  sig { params(context: ::Spoom::Deadcode::Remover::NodeContext).void }
  def delete_attr_accessor(context); end

  # source://spoom//lib/spoom/deadcode/remover.rb#331
  sig { params(start_char: ::Integer, end_char: ::Integer).void }
  def delete_chars(start_char, end_char); end

  # source://spoom//lib/spoom/deadcode/remover.rb#73
  sig { params(context: ::Spoom::Deadcode::Remover::NodeContext).void }
  def delete_constant_assignment(context); end

  # source://spoom//lib/spoom/deadcode/remover.rb#324
  sig { params(start_line: ::Integer, end_line: ::Integer).void }
  def delete_lines(start_line, end_line); end

  # source://spoom//lib/spoom/deadcode/remover.rb#261
  sig { params(context: ::Spoom::Deadcode::Remover::NodeContext).void }
  def delete_node_and_comments_and_sigs(context); end

  # source://spoom//lib/spoom/deadcode/remover.rb#218
  sig do
    params(
      node: ::Prism::Node,
      send_context: ::Spoom::Deadcode::Remover::NodeContext,
      was_removed: T::Boolean
    ).void
  end
  def insert_accessor(node, send_context, was_removed:); end

  # source://spoom//lib/spoom/deadcode/remover.rb#336
  sig { params(start_char: ::Integer, end_char: ::Integer, replacement: ::String).void }
  def replace_chars(start_char, end_char, replacement); end

  # source://spoom//lib/spoom/deadcode/remover.rb#341
  sig do
    params(
      node: ::Prism::CallNode,
      name: ::String,
      kind: T.nilable(::Spoom::Deadcode::Definition::Kind)
    ).returns(::String)
  end
  def transform_sig(node, name:, kind:); end
end

# An abstraction to simplify handling of Prism::CallNode nodes.
#
# source://spoom//lib/spoom/deadcode/send.rb#7
class Spoom::Deadcode::Send < ::T::Struct
  const :node, ::Prism::CallNode
  const :name, ::String
  const :recv, T.nilable(::Prism::Node), default: T.unsafe(nil)
  const :args, T::Array[::Prism::Node], default: T.unsafe(nil)
  const :block, T.nilable(::Prism::Node), default: T.unsafe(nil)
  const :location, ::Spoom::Location

  # source://spoom//lib/spoom/deadcode/send.rb#22
  sig do
    type_parameters(:T)
      .params(
        arg_type: T::Class[T.type_parameter(:T)],
        block: T.proc.params(arg: T.type_parameter(:T)).void
      ).void
  end
  def each_arg(arg_type, &block); end

  # source://spoom//lib/spoom/deadcode/send.rb#29
  sig { params(block: T.proc.params(key: ::Prism::Node, value: T.nilable(::Prism::Node)).void).void }
  def each_arg_assoc(&block); end

  class << self
    # source://sorbet-runtime/0.5.11589/lib/types/struct.rb#13
    def inherited(s); end
  end
end

# source://spoom//lib/spoom.rb#12
class Spoom::Error < ::StandardError; end

# source://spoom//lib/spoom/context/exec.rb#5
class Spoom::ExecResult < ::T::Struct
  const :out, ::String
  const :err, T.nilable(::String)
  const :status, T::Boolean
  const :exit_code, ::Integer

  # source://spoom//lib/spoom/context/exec.rb#14
  sig { returns(::String) }
  def to_s; end

  class << self
    # source://sorbet-runtime/0.5.11589/lib/types/struct.rb#13
    def inherited(s); end
  end
end

# source://spoom//lib/spoom/file_collector.rb#5
class Spoom::FileCollector
  # Initialize a new file collector
  #
  # If `allow_extensions` is empty, all files are collected.
  # If `allow_extensions` is an array of extensions, only files with one of these extensions are collected.
  #
  # If `allow_mime_types` is empty, all files are collected.
  # If `allow_mime_types` is an array of mimetypes, files without an extension are collected if their mimetype is in
  # the list.
  #
  # source://spoom//lib/spoom/file_collector.rb#26
  sig do
    params(
      allow_extensions: T::Array[::String],
      allow_mime_types: T::Array[::String],
      exclude_patterns: T::Array[::String]
    ).void
  end
  def initialize(allow_extensions: T.unsafe(nil), allow_mime_types: T.unsafe(nil), exclude_patterns: T.unsafe(nil)); end

  # source://spoom//lib/spoom/file_collector.rb#9
  sig { returns(T::Array[::String]) }
  def files; end

  # source://spoom//lib/spoom/file_collector.rb#39
  sig { params(path: ::String).void }
  def visit_path(path); end

  # source://spoom//lib/spoom/file_collector.rb#34
  sig { params(paths: T::Array[::String]).void }
  def visit_paths(paths); end

  private

  # source://spoom//lib/spoom/file_collector.rb#56
  sig { params(path: ::String).returns(::String) }
  def clean_path(path); end

  # source://spoom//lib/spoom/file_collector.rb#73
  sig { params(path: ::String).returns(T::Boolean) }
  def excluded_file?(path); end

  # source://spoom//lib/spoom/file_collector.rb#88
  sig { params(path: ::String).returns(T::Boolean) }
  def excluded_path?(path); end

  # source://spoom//lib/spoom/file_collector.rb#97
  sig { params(path: ::String).returns(T.nilable(::String)) }
  def mime_type_for(path); end

  # source://spoom//lib/spoom/file_collector.rb#68
  sig { params(path: ::String).void }
  def visit_directory(path); end

  # source://spoom//lib/spoom/file_collector.rb#61
  sig { params(path: ::String).void }
  def visit_file(path); end
end

# Build a file hierarchy from a set of file paths.
#
# source://spoom//lib/spoom/file_tree.rb#6
class Spoom::FileTree
  # source://spoom//lib/spoom/file_tree.rb#10
  sig { params(paths: T::Enumerable[::String]).void }
  def initialize(paths = T.unsafe(nil)); end

  # Add a `path` to the tree
  #
  # This will create all nodes until the root of `path`.
  #
  # source://spoom//lib/spoom/file_tree.rb#25
  sig { params(path: ::String).returns(::Spoom::FileTree::Node) }
  def add_path(path); end

  # Add all `paths` to the tree
  #
  # source://spoom//lib/spoom/file_tree.rb#17
  sig { params(paths: T::Enumerable[::String]).void }
  def add_paths(paths); end

  # All the nodes in this tree
  #
  # source://spoom//lib/spoom/file_tree.rb#45
  sig { returns(T::Array[::Spoom::FileTree::Node]) }
  def nodes; end

  # Return a map of typing scores for each node in the tree
  #
  # source://spoom//lib/spoom/file_tree.rb#59
  sig { params(context: ::Spoom::Context).returns(T::Hash[::Spoom::FileTree::Node, ::Float]) }
  def nodes_strictness_scores(context); end

  # All the paths in this tree
  #
  # source://spoom//lib/spoom/file_tree.rb#53
  sig { returns(T::Array[::String]) }
  def paths; end

  # Return a map of typing scores for each path in the tree
  #
  # source://spoom//lib/spoom/file_tree.rb#67
  sig { params(context: ::Spoom::Context).returns(T::Hash[::String, ::Float]) }
  def paths_strictness_scores(context); end

  # source://spoom//lib/spoom/file_tree.rb#72
  sig { params(out: T.any(::IO, ::StringIO), colors: T::Boolean).void }
  def print(out: T.unsafe(nil), colors: T.unsafe(nil)); end

  # All root nodes
  #
  # source://spoom//lib/spoom/file_tree.rb#39
  sig { returns(T::Array[::Spoom::FileTree::Node]) }
  def roots; end
end

# A visitor that collects all the nodes in a tree
#
# source://spoom//lib/spoom/file_tree.rb#124
class Spoom::FileTree::CollectNodes < ::Spoom::FileTree::Visitor
  # source://spoom//lib/spoom/file_tree.rb#131
  sig { void }
  def initialize; end

  # source://spoom//lib/spoom/file_tree.rb#128
  sig { returns(T::Array[::Spoom::FileTree::Node]) }
  def nodes; end

  # source://spoom//lib/spoom/file_tree.rb#137
  sig { override.params(node: ::Spoom::FileTree::Node).void }
  def visit_node(node); end
end

# A visitor that collects the typing score of each node in a tree
#
# source://spoom//lib/spoom/file_tree.rb#167
class Spoom::FileTree::CollectScores < ::Spoom::FileTree::CollectStrictnesses
  # source://spoom//lib/spoom/file_tree.rb#174
  sig { params(context: ::Spoom::Context).void }
  def initialize(context); end

  # source://spoom//lib/spoom/file_tree.rb#171
  sig { returns(T::Hash[::Spoom::FileTree::Node, ::Float]) }
  def scores; end

  # source://spoom//lib/spoom/file_tree.rb#181
  sig { override.params(node: ::Spoom::FileTree::Node).void }
  def visit_node(node); end

  private

  # source://spoom//lib/spoom/file_tree.rb#190
  sig { params(node: ::Spoom::FileTree::Node).returns(::Float) }
  def node_score(node); end

  # source://spoom//lib/spoom/file_tree.rb#199
  sig { params(strictness: T.nilable(::String)).returns(::Float) }
  def strictness_score(strictness); end
end

# A visitor that collects the strictness of each node in a tree
#
# source://spoom//lib/spoom/file_tree.rb#144
class Spoom::FileTree::CollectStrictnesses < ::Spoom::FileTree::Visitor
  # source://spoom//lib/spoom/file_tree.rb#151
  sig { params(context: ::Spoom::Context).void }
  def initialize(context); end

  # source://spoom//lib/spoom/file_tree.rb#148
  sig { returns(T::Hash[::Spoom::FileTree::Node, T.nilable(::String)]) }
  def strictnesses; end

  # source://spoom//lib/spoom/file_tree.rb#158
  sig { override.params(node: ::Spoom::FileTree::Node).void }
  def visit_node(node); end
end

# A node representing either a file or a directory inside a FileTree
#
# source://spoom//lib/spoom/file_tree.rb#78
class Spoom::FileTree::Node < ::T::Struct
  const :parent, T.nilable(::Spoom::FileTree::Node)
  const :name, ::String
  const :children, T::Hash[::String, ::Spoom::FileTree::Node], default: T.unsafe(nil)

  # Full path to this node from root
  #
  # source://spoom//lib/spoom/file_tree.rb#92
  sig { returns(::String) }
  def path; end

  class << self
    # source://sorbet-runtime/0.5.11589/lib/types/struct.rb#13
    def inherited(s); end
  end
end

# An internal class used to print a FileTree
#
# See `FileTree#print`
#
# source://spoom//lib/spoom/file_tree.rb#212
class Spoom::FileTree::Printer < ::Spoom::FileTree::Visitor
  # source://spoom//lib/spoom/file_tree.rb#222
  sig do
    params(
      strictnesses: T::Hash[::Spoom::FileTree::Node, T.nilable(::String)],
      out: T.any(::IO, ::StringIO),
      colors: T::Boolean
    ).void
  end
  def initialize(strictnesses, out: T.unsafe(nil), colors: T.unsafe(nil)); end

  # source://spoom//lib/spoom/file_tree.rb#230
  sig { override.params(node: ::Spoom::FileTree::Node).void }
  def visit_node(node); end

  private

  # source://spoom//lib/spoom/file_tree.rb#255
  sig { params(strictness: T.nilable(::String)).returns(::Spoom::Color) }
  def strictness_color(strictness); end
end

# An abstract visitor for FileTree
#
# @abstract It cannot be directly instantiated. Subclasses must implement the `abstract` methods below.
#
# source://spoom//lib/spoom/file_tree.rb#101
class Spoom::FileTree::Visitor
  abstract!

  # source://spoom//lib/spoom/file_tree.rb#113
  sig { params(node: ::Spoom::FileTree::Node).void }
  def visit_node(node); end

  # source://spoom//lib/spoom/file_tree.rb#118
  sig { params(nodes: T::Array[::Spoom::FileTree::Node]).void }
  def visit_nodes(nodes); end

  # source://spoom//lib/spoom/file_tree.rb#108
  sig { params(tree: ::Spoom::FileTree).void }
  def visit_tree(tree); end
end

# source://spoom//lib/spoom/context/git.rb#5
module Spoom::Git; end

# source://spoom//lib/spoom/context/git.rb#6
class Spoom::Git::Commit < ::T::Struct
  const :sha, ::String
  const :time, ::Time

  # source://spoom//lib/spoom/context/git.rb#27
  sig { returns(::Integer) }
  def timestamp; end

  class << self
    # source://sorbet-runtime/0.5.11589/lib/types/struct.rb#13
    def inherited(s); end

    # Parse a line formatted as `%h %at` into a `Commit`
    #
    # source://spoom//lib/spoom/context/git.rb#14
    sig { params(string: ::String).returns(T.nilable(::Spoom::Git::Commit)) }
    def parse_line(string); end
  end
end

# source://spoom//lib/spoom/sorbet/lsp/base.rb#5
module Spoom::LSP; end

# source://spoom//lib/spoom/sorbet/lsp.rb#13
class Spoom::LSP::Client
  # source://spoom//lib/spoom/sorbet/lsp.rb#17
  sig { params(sorbet_bin: ::String, sorbet_args: ::String, path: ::String).void }
  def initialize(sorbet_bin, *sorbet_args, path: T.unsafe(nil)); end

  # source://spoom//lib/spoom/sorbet/lsp.rb#229
  sig { void }
  def close; end

  # source://spoom//lib/spoom/sorbet/lsp.rb#131
  sig { params(uri: ::String, line: ::Integer, column: ::Integer).returns(T::Array[::Spoom::LSP::Location]) }
  def definitions(uri, line, column); end

  # source://spoom//lib/spoom/sorbet/lsp.rb#212
  sig { params(uri: ::String).returns(T::Array[::Spoom::LSP::DocumentSymbol]) }
  def document_symbols(uri); end

  # source://spoom//lib/spoom/sorbet/lsp.rb#89
  sig { params(uri: ::String, line: ::Integer, column: ::Integer).returns(T.nilable(::Spoom::LSP::Hover)) }
  def hover(uri, line, column); end

  # source://spoom//lib/spoom/sorbet/lsp.rb#27
  sig { returns(::Integer) }
  def next_id; end

  # LSP requests
  #
  # @raise [Error::AlreadyOpen]
  #
  # source://spoom//lib/spoom/sorbet/lsp.rb#72
  sig { params(workspace_path: ::String).void }
  def open(workspace_path); end

  # source://spoom//lib/spoom/sorbet/lsp.rb#54
  sig { returns(T.nilable(T::Hash[T.untyped, T.untyped])) }
  def read; end

  # @raise [Error::BadHeaders]
  #
  # source://spoom//lib/spoom/sorbet/lsp.rb#43
  sig { returns(T.nilable(::String)) }
  def read_raw; end

  # source://spoom//lib/spoom/sorbet/lsp.rb#173
  sig do
    params(
      uri: ::String,
      line: ::Integer,
      column: ::Integer,
      include_decl: T::Boolean
    ).returns(T::Array[::Spoom::LSP::Location])
  end
  def references(uri, line, column, include_decl = T.unsafe(nil)); end

  # source://spoom//lib/spoom/sorbet/lsp.rb#37
  sig { params(message: ::Spoom::LSP::Message).returns(T.nilable(T::Hash[T.untyped, T.untyped])) }
  def send(message); end

  # source://spoom//lib/spoom/sorbet/lsp.rb#32
  sig { params(json_string: ::String).void }
  def send_raw(json_string); end

  # source://spoom//lib/spoom/sorbet/lsp.rb#110
  sig { params(uri: ::String, line: ::Integer, column: ::Integer).returns(T::Array[::Spoom::LSP::SignatureHelp]) }
  def signatures(uri, line, column); end

  # source://spoom//lib/spoom/sorbet/lsp.rb#197
  sig { params(query: ::String).returns(T::Array[::Spoom::LSP::DocumentSymbol]) }
  def symbols(query); end

  # source://spoom//lib/spoom/sorbet/lsp.rb#152
  sig { params(uri: ::String, line: ::Integer, column: ::Integer).returns(T::Array[::Spoom::LSP::Location]) }
  def type_definitions(uri, line, column); end
end

# source://spoom//lib/spoom/sorbet/lsp/structures.rb#178
class Spoom::LSP::Diagnostic < ::T::Struct
  include ::Spoom::LSP::PrintableSymbol

  const :range, ::Spoom::LSP::Range
  const :code, ::Integer
  const :message, ::String
  const :information, ::Object

  # source://spoom//lib/spoom/sorbet/lsp/structures.rb#202
  sig { override.params(printer: ::Spoom::LSP::SymbolPrinter).void }
  def accept_printer(printer); end

  # source://spoom//lib/spoom/sorbet/lsp/structures.rb#207
  sig { returns(::String) }
  def to_s; end

  class << self
    # source://spoom//lib/spoom/sorbet/lsp/structures.rb#191
    sig { params(json: T::Hash[T.untyped, T.untyped]).returns(::Spoom::LSP::Diagnostic) }
    def from_json(json); end

    # source://sorbet-runtime/0.5.11589/lib/types/struct.rb#13
    def inherited(s); end
  end
end

# source://spoom//lib/spoom/sorbet/lsp/structures.rb#212
class Spoom::LSP::DocumentSymbol < ::T::Struct
  include ::Spoom::LSP::PrintableSymbol

  const :name, ::String
  const :detail, T.nilable(::String)
  const :kind, ::Integer
  const :location, T.nilable(::Spoom::LSP::Location)
  const :range, T.nilable(::Spoom::LSP::Range)
  const :children, T::Array[::Spoom::LSP::DocumentSymbol]

  # source://spoom//lib/spoom/sorbet/lsp/structures.rb#240
  sig { override.params(printer: ::Spoom::LSP::SymbolPrinter).void }
  def accept_printer(printer); end

  # source://spoom//lib/spoom/sorbet/lsp/structures.rb#272
  sig { returns(::String) }
  def kind_string; end

  # source://spoom//lib/spoom/sorbet/lsp/structures.rb#267
  sig { returns(::String) }
  def to_s; end

  class << self
    # source://spoom//lib/spoom/sorbet/lsp/structures.rb#227
    sig { params(json: T::Hash[T.untyped, T.untyped]).returns(::Spoom::LSP::DocumentSymbol) }
    def from_json(json); end

    # source://sorbet-runtime/0.5.11589/lib/types/struct.rb#13
    def inherited(s); end
  end
end

# source://spoom//lib/spoom/sorbet/lsp/structures.rb#276
Spoom::LSP::DocumentSymbol::SYMBOL_KINDS = T.let(T.unsafe(nil), Hash)

# source://spoom//lib/spoom/sorbet/lsp/errors.rb#6
class Spoom::LSP::Error < ::Spoom::Error; end

# source://spoom//lib/spoom/sorbet/lsp/errors.rb#7
class Spoom::LSP::Error::AlreadyOpen < ::Spoom::LSP::Error; end

# source://spoom//lib/spoom/sorbet/lsp/errors.rb#8
class Spoom::LSP::Error::BadHeaders < ::Spoom::LSP::Error; end

# source://spoom//lib/spoom/sorbet/lsp/errors.rb#10
class Spoom::LSP::Error::Diagnostics < ::Spoom::LSP::Error
  # source://spoom//lib/spoom/sorbet/lsp/errors.rb#32
  sig { params(uri: ::String, diagnostics: T::Array[::Spoom::LSP::Diagnostic]).void }
  def initialize(uri, diagnostics); end

  # source://spoom//lib/spoom/sorbet/lsp/errors.rb#17
  sig { returns(T::Array[::Spoom::LSP::Diagnostic]) }
  def diagnostics; end

  # source://spoom//lib/spoom/sorbet/lsp/errors.rb#14
  sig { returns(::String) }
  def uri; end

  class << self
    # source://spoom//lib/spoom/sorbet/lsp/errors.rb#23
    sig { params(json: T::Hash[T.untyped, T.untyped]).returns(::Spoom::LSP::Error::Diagnostics) }
    def from_json(json); end
  end
end

# source://spoom//lib/spoom/sorbet/lsp/structures.rb#19
class Spoom::LSP::Hover < ::T::Struct
  include ::Spoom::LSP::PrintableSymbol

  const :contents, ::String
  const :range, T.nilable(T::Range[T.untyped])

  # source://spoom//lib/spoom/sorbet/lsp/structures.rb#39
  sig { override.params(printer: ::Spoom::LSP::SymbolPrinter).void }
  def accept_printer(printer); end

  # source://spoom//lib/spoom/sorbet/lsp/structures.rb#45
  sig { returns(::String) }
  def to_s; end

  class << self
    # source://spoom//lib/spoom/sorbet/lsp/structures.rb#30
    sig { params(json: T::Hash[T.untyped, T.untyped]).returns(::Spoom::LSP::Hover) }
    def from_json(json); end

    # source://sorbet-runtime/0.5.11589/lib/types/struct.rb#13
    def inherited(s); end
  end
end

# source://spoom//lib/spoom/sorbet/lsp/structures.rb#112
class Spoom::LSP::Location < ::T::Struct
  include ::Spoom::LSP::PrintableSymbol

  const :uri, ::String
  const :range, ::Spoom::LSP::Range

  # source://spoom//lib/spoom/sorbet/lsp/structures.rb#132
  sig { override.params(printer: ::Spoom::LSP::SymbolPrinter).void }
  def accept_printer(printer); end

  # source://spoom//lib/spoom/sorbet/lsp/structures.rb#138
  sig { returns(::String) }
  def to_s; end

  class << self
    # source://spoom//lib/spoom/sorbet/lsp/structures.rb#123
    sig { params(json: T::Hash[T.untyped, T.untyped]).returns(::Spoom::LSP::Location) }
    def from_json(json); end

    # source://sorbet-runtime/0.5.11589/lib/types/struct.rb#13
    def inherited(s); end
  end
end

# A general message as defined by JSON-RPC.
#
# The language server protocol always uses `"2.0"` as the `jsonrpc` version.
#
# source://spoom//lib/spoom/sorbet/lsp/base.rb#12
class Spoom::LSP::Message
  # source://spoom//lib/spoom/sorbet/lsp/base.rb#16
  sig { void }
  def initialize; end

  # source://spoom//lib/spoom/sorbet/lsp/base.rb#21
  sig { returns(T::Hash[T.untyped, T.untyped]) }
  def as_json; end

  # source://spoom//lib/spoom/sorbet/lsp/base.rb#29
  sig { params(args: T.untyped).returns(::String) }
  def to_json(*args); end
end

# A notification message.
#
# A processed notification message must not send a response back. They work like events.
#
# source://spoom//lib/spoom/sorbet/lsp/base.rb#58
class Spoom::LSP::Notification < ::Spoom::LSP::Message
  # source://spoom//lib/spoom/sorbet/lsp/base.rb#68
  sig { params(method: ::String, params: T::Hash[T.untyped, T.untyped]).void }
  def initialize(method, params); end

  # source://spoom//lib/spoom/sorbet/lsp/base.rb#62
  sig { returns(::String) }
  def method; end

  # source://spoom//lib/spoom/sorbet/lsp/base.rb#65
  sig { returns(T::Hash[T.untyped, T.untyped]) }
  def params; end
end

# source://spoom//lib/spoom/sorbet/lsp/structures.rb#50
class Spoom::LSP::Position < ::T::Struct
  include ::Spoom::LSP::PrintableSymbol

  const :line, ::Integer
  const :char, ::Integer

  # source://spoom//lib/spoom/sorbet/lsp/structures.rb#70
  sig { override.params(printer: ::Spoom::LSP::SymbolPrinter).void }
  def accept_printer(printer); end

  # source://spoom//lib/spoom/sorbet/lsp/structures.rb#75
  sig { returns(::String) }
  def to_s; end

  class << self
    # source://spoom//lib/spoom/sorbet/lsp/structures.rb#61
    sig { params(json: T::Hash[T.untyped, T.untyped]).returns(::Spoom::LSP::Position) }
    def from_json(json); end

    # source://sorbet-runtime/0.5.11589/lib/types/struct.rb#13
    def inherited(s); end
  end
end

# @abstract Subclasses must implement the `abstract` methods below.
#
# source://spoom//lib/spoom/sorbet/lsp/structures.rb#9
module Spoom::LSP::PrintableSymbol
  interface!

  # @abstract
  #
  # source://spoom//lib/spoom/sorbet/lsp/structures.rb#16
  sig { abstract.params(printer: ::Spoom::LSP::SymbolPrinter).void }
  def accept_printer(printer); end
end

# source://spoom//lib/spoom/sorbet/lsp/structures.rb#80
class Spoom::LSP::Range < ::T::Struct
  include ::Spoom::LSP::PrintableSymbol

  const :start, ::Spoom::LSP::Position
  const :end, ::Spoom::LSP::Position

  # source://spoom//lib/spoom/sorbet/lsp/structures.rb#100
  sig { override.params(printer: ::Spoom::LSP::SymbolPrinter).void }
  def accept_printer(printer); end

  # source://spoom//lib/spoom/sorbet/lsp/structures.rb#107
  sig { returns(::String) }
  def to_s; end

  class << self
    # source://spoom//lib/spoom/sorbet/lsp/structures.rb#91
    sig { params(json: T::Hash[T.untyped, T.untyped]).returns(::Spoom::LSP::Range) }
    def from_json(json); end

    # source://sorbet-runtime/0.5.11589/lib/types/struct.rb#13
    def inherited(s); end
  end
end

# A request message to describe a request between the client and the server.
#
# Every processed request must send a response back to the sender of the request.
#
# source://spoom//lib/spoom/sorbet/lsp/base.rb#37
class Spoom::LSP::Request < ::Spoom::LSP::Message
  # source://spoom//lib/spoom/sorbet/lsp/base.rb#47
  sig { params(id: ::Integer, method: ::String, params: T::Hash[T.untyped, T.untyped]).void }
  def initialize(id, method, params); end

  # source://spoom//lib/spoom/sorbet/lsp/base.rb#41
  sig { returns(::Integer) }
  def id; end

  # source://spoom//lib/spoom/sorbet/lsp/base.rb#44
  sig { returns(T::Hash[T.untyped, T.untyped]) }
  def params; end
end

# source://spoom//lib/spoom/sorbet/lsp/errors.rb#40
class Spoom::LSP::ResponseError < ::Spoom::LSP::Error
  # source://spoom//lib/spoom/sorbet/lsp/errors.rb#63
  sig { params(code: ::Integer, message: ::String, data: T::Hash[T.untyped, T.untyped]).void }
  def initialize(code, message, data); end

  # source://spoom//lib/spoom/sorbet/lsp/errors.rb#44
  sig { returns(::Integer) }
  def code; end

  # source://spoom//lib/spoom/sorbet/lsp/errors.rb#47
  sig { returns(T::Hash[T.untyped, T.untyped]) }
  def data; end

  class << self
    # source://spoom//lib/spoom/sorbet/lsp/errors.rb#53
    sig { params(json: T::Hash[T.untyped, T.untyped]).returns(::Spoom::LSP::ResponseError) }
    def from_json(json); end
  end
end

# source://spoom//lib/spoom/sorbet/lsp/structures.rb#143
class Spoom::LSP::SignatureHelp < ::T::Struct
  include ::Spoom::LSP::PrintableSymbol

  const :label, T.nilable(::String)
  const :doc, ::Object
  const :params, T::Array[T.untyped]

  # source://spoom//lib/spoom/sorbet/lsp/structures.rb#165
  sig { override.params(printer: ::Spoom::LSP::SymbolPrinter).void }
  def accept_printer(printer); end

  # source://spoom//lib/spoom/sorbet/lsp/structures.rb#173
  sig { returns(::String) }
  def to_s; end

  class << self
    # source://spoom//lib/spoom/sorbet/lsp/structures.rb#155
    sig { params(json: T::Hash[T.untyped, T.untyped]).returns(::Spoom::LSP::SignatureHelp) }
    def from_json(json); end

    # source://sorbet-runtime/0.5.11589/lib/types/struct.rb#13
    def inherited(s); end
  end
end

# source://spoom//lib/spoom/sorbet/lsp/structures.rb#309
class Spoom::LSP::SymbolPrinter < ::Spoom::Printer
  # source://spoom//lib/spoom/sorbet/lsp/structures.rb#326
  sig do
    params(
      out: T.any(::IO, ::StringIO),
      colors: T::Boolean,
      indent_level: ::Integer,
      prefix: T.nilable(::String)
    ).void
  end
  def initialize(out: T.unsafe(nil), colors: T.unsafe(nil), indent_level: T.unsafe(nil), prefix: T.unsafe(nil)); end

  # source://spoom//lib/spoom/sorbet/lsp/structures.rb#348
  sig { params(uri: ::String).returns(::String) }
  def clean_uri(uri); end

  # source://spoom//lib/spoom/sorbet/lsp/structures.rb#316
  sig { returns(T.nilable(::String)) }
  def prefix; end

  # @return [String, nil]
  #
  # source://spoom//lib/spoom/sorbet/lsp/structures.rb#316
  def prefix=(_arg0); end

  # source://spoom//lib/spoom/sorbet/lsp/structures.rb#356
  sig { params(objects: T::Array[::Spoom::LSP::PrintableSymbol]).void }
  def print_list(objects); end

  # source://spoom//lib/spoom/sorbet/lsp/structures.rb#336
  sig { params(object: T.nilable(::Spoom::LSP::PrintableSymbol)).void }
  def print_object(object); end

  # source://spoom//lib/spoom/sorbet/lsp/structures.rb#343
  sig { params(objects: T::Array[::Spoom::LSP::PrintableSymbol]).void }
  def print_objects(objects); end

  # source://spoom//lib/spoom/sorbet/lsp/structures.rb#313
  sig { returns(T::Set[::Integer]) }
  def seen; end
end

# source://spoom//lib/spoom/location.rb#5
class Spoom::Location
  include ::Comparable

  # @raise [LocationError]
  #
  # source://spoom//lib/spoom/location.rb#73
  sig do
    params(
      file: ::String,
      start_line: T.nilable(::Integer),
      start_column: T.nilable(::Integer),
      end_line: T.nilable(::Integer),
      end_column: T.nilable(::Integer)
    ).void
  end
  def initialize(file, start_line: T.unsafe(nil), start_column: T.unsafe(nil), end_line: T.unsafe(nil), end_column: T.unsafe(nil)); end

  # source://spoom//lib/spoom/location.rb#106
  sig { override.params(other: ::BasicObject).returns(T.nilable(::Integer)) }
  def <=>(other); end

  # @return [Integer, nil]
  #
  # source://spoom//lib/spoom/location.rb#62
  def end_column; end

  # @return [Integer, nil]
  #
  # source://spoom//lib/spoom/location.rb#62
  def end_line; end

  # source://spoom//lib/spoom/location.rb#59
  sig { returns(::String) }
  def file; end

  # source://spoom//lib/spoom/location.rb#93
  sig { params(other: ::Spoom::Location).returns(T::Boolean) }
  def include?(other); end

  # @return [Integer, nil]
  #
  # source://spoom//lib/spoom/location.rb#62
  def start_column; end

  # source://spoom//lib/spoom/location.rb#62
  sig { returns(T.nilable(::Integer)) }
  def start_line; end

  # source://spoom//lib/spoom/location.rb#129
  sig { returns(::String) }
  def to_s; end

  class << self
    # source://spoom//lib/spoom/location.rb#47
    sig { params(file: ::String, location: ::Prism::Location).returns(::Spoom::Location) }
    def from_prism(file, location); end

    # @raise [LocationError]
    #
    # source://spoom//lib/spoom/location.rb#16
    sig { params(location_string: ::String).returns(::Spoom::Location) }
    def from_string(location_string); end
  end
end

# source://spoom//lib/spoom/location.rb#10
class Spoom::Location::LocationError < ::Spoom::Error; end

# source://spoom//lib/spoom/model/model.rb#5
class Spoom::Model
  # source://spoom//lib/spoom/model/model.rb#238
  sig { void }
  def initialize; end

  # Get a symbol by it's full name
  #
  # Raises an error if the symbol is not found
  #
  # @raise [Error]
  #
  # source://spoom//lib/spoom/model/model.rb#247
  sig { params(full_name: ::String).returns(::Spoom::Model::Symbol) }
  def [](full_name); end

  # source://spoom//lib/spoom/model/model.rb#296
  sig { void }
  def finalize!; end

  # Register a new symbol by it's full name
  #
  # If the symbol already exists, it will be returned.
  #
  # source://spoom//lib/spoom/model/model.rb#258
  sig { params(full_name: ::String).returns(::Spoom::Model::Symbol) }
  def register_symbol(full_name); end

  # source://spoom//lib/spoom/model/model.rb#263
  sig { params(full_name: ::String, context: ::Spoom::Model::Symbol).returns(::Spoom::Model::Symbol) }
  def resolve_symbol(full_name, context:); end

  # source://spoom//lib/spoom/model/model.rb#290
  sig { params(symbol: ::Spoom::Model::Symbol).returns(T::Array[::Spoom::Model::Symbol]) }
  def subtypes(symbol); end

  # source://spoom//lib/spoom/model/model.rb#284
  sig { params(symbol: ::Spoom::Model::Symbol).returns(T::Array[::Spoom::Model::Symbol]) }
  def supertypes(symbol); end

  # All the symbols registered in this model
  #
  # source://spoom//lib/spoom/model/model.rb#232
  sig { returns(T::Hash[::String, ::Spoom::Model::Symbol]) }
  def symbols; end

  # source://spoom//lib/spoom/model/model.rb#235
  sig { returns(Spoom::Poset[::Spoom::Model::Symbol]) }
  def symbols_hierarchy; end

  private

  # source://spoom//lib/spoom/model/model.rb#303
  sig { void }
  def compute_symbols_hierarchy!; end
end

# @abstract It cannot be directly instantiated. Subclasses must implement the `abstract` methods below.
#
# source://spoom//lib/spoom/model/model.rb#179
class Spoom::Model::Attr < ::Spoom::Model::Property
  abstract!
end

# source://spoom//lib/spoom/model/model.rb#185
class Spoom::Model::AttrAccessor < ::Spoom::Model::Attr; end

# source://spoom//lib/spoom/model/model.rb#183
class Spoom::Model::AttrReader < ::Spoom::Model::Attr; end

# source://spoom//lib/spoom/model/model.rb#184
class Spoom::Model::AttrWriter < ::Spoom::Model::Attr; end

# Populate a Model by visiting the nodes from a Ruby file
#
# source://spoom//lib/spoom/model/builder.rb#7
class Spoom::Model::Builder < ::Spoom::Model::NamespaceVisitor
  # source://spoom//lib/spoom/model/builder.rb#11
  sig { params(model: ::Spoom::Model, file: ::String).void }
  def initialize(model, file); end

  # Accessors
  #
  # source://spoom//lib/spoom/model/builder.rb#146
  sig { override.params(node: ::Prism::CallNode).void }
  def visit_call_node(node); end

  # Classes
  #
  # source://spoom//lib/spoom/model/builder.rb#24
  sig { override.params(node: ::Prism::ClassNode).void }
  def visit_class_node(node); end

  # Constants
  #
  # source://spoom//lib/spoom/model/builder.rb#71
  sig { override.params(node: ::Prism::ConstantPathWriteNode).void }
  def visit_constant_path_write_node(node); end

  # source://spoom//lib/spoom/model/builder.rb#92
  sig { override.params(node: ::Prism::ConstantWriteNode).void }
  def visit_constant_write_node(node); end

  # Methods
  #
  # source://spoom//lib/spoom/model/builder.rb#127
  sig { override.params(node: ::Prism::DefNode).void }
  def visit_def_node(node); end

  # Modules
  #
  # source://spoom//lib/spoom/model/builder.rb#55
  sig { override.params(node: ::Prism::ModuleNode).void }
  def visit_module_node(node); end

  # source://spoom//lib/spoom/model/builder.rb#106
  sig { override.params(node: ::Prism::MultiWriteNode).void }
  def visit_multi_write_node(node); end

  # source://spoom//lib/spoom/model/builder.rb#39
  sig { override.params(node: ::Prism::SingletonClassNode).void }
  def visit_singleton_class_node(node); end

  private

  # source://spoom//lib/spoom/model/builder.rb#234
  sig { returns(T::Array[::Spoom::Model::Sig]) }
  def collect_sigs; end

  # source://spoom//lib/spoom/model/builder.rb#229
  sig { returns(::Spoom::Model::Visibility) }
  def current_visibility; end

  # source://spoom//lib/spoom/model/builder.rb#241
  sig { params(node: ::Prism::Node).returns(::Spoom::Location) }
  def node_location(node); end
end

# source://spoom//lib/spoom/model/model.rb#117
class Spoom::Model::Class < ::Spoom::Model::Namespace
  # source://spoom//lib/spoom/model/model.rb#129
  sig do
    params(
      symbol: ::Spoom::Model::Symbol,
      owner: T.nilable(::Spoom::Model::Namespace),
      location: ::Spoom::Location,
      superclass_name: T.nilable(::String)
    ).void
  end
  def initialize(symbol, owner:, location:, superclass_name: T.unsafe(nil)); end

  # source://spoom//lib/spoom/model/model.rb#119
  sig { returns(T.nilable(::String)) }
  def superclass_name; end

  # @return [String, nil]
  #
  # source://spoom//lib/spoom/model/model.rb#119
  def superclass_name=(_arg0); end
end

# source://spoom//lib/spoom/model/model.rb#138
class Spoom::Model::Constant < ::Spoom::Model::SymbolDef
  # source://spoom//lib/spoom/model/model.rb#143
  sig do
    params(
      symbol: ::Spoom::Model::Symbol,
      owner: T.nilable(::Spoom::Model::Namespace),
      location: ::Spoom::Location,
      value: ::String
    ).void
  end
  def initialize(symbol, owner:, location:, value:); end

  # source://spoom//lib/spoom/model/model.rb#140
  sig { returns(::String) }
  def value; end
end

# source://spoom//lib/spoom/model/model.rb#8
class Spoom::Model::Error < ::Spoom::Error; end

# source://spoom//lib/spoom/model/model.rb#213
class Spoom::Model::Extend < ::Spoom::Model::Mixin; end

# source://spoom//lib/spoom/model/model.rb#211
class Spoom::Model::Include < ::Spoom::Model::Mixin; end

# source://spoom//lib/spoom/model/model.rb#177
class Spoom::Model::Method < ::Spoom::Model::Property; end

# A mixin (include, prepend, extend) to a namespace
#
# @abstract It cannot be directly instantiated. Subclasses must implement the `abstract` methods below.
#
# source://spoom//lib/spoom/model/model.rb#196
class Spoom::Model::Mixin
  abstract!

  # source://spoom//lib/spoom/model/model.rb#206
  sig { params(name: ::String).void }
  def initialize(name); end

  # source://spoom//lib/spoom/model/model.rb#203
  sig { returns(::String) }
  def name; end
end

# source://spoom//lib/spoom/model/model.rb#136
class Spoom::Model::Module < ::Spoom::Model::Namespace; end

# A class or module
#
# @abstract It cannot be directly instantiated. Subclasses must implement the `abstract` methods below.
#
# source://spoom//lib/spoom/model/model.rb#97
class Spoom::Model::Namespace < ::Spoom::Model::SymbolDef
  abstract!

  # source://spoom//lib/spoom/model/model.rb#107
  sig do
    params(
      symbol: ::Spoom::Model::Symbol,
      owner: T.nilable(::Spoom::Model::Namespace),
      location: ::Spoom::Location
    ).void
  end
  def initialize(symbol, owner:, location:); end

  # source://spoom//lib/spoom/model/model.rb#101
  sig { returns(T::Array[::Spoom::Model::SymbolDef]) }
  def children; end

  # source://spoom//lib/spoom/model/model.rb#104
  sig { returns(T::Array[::Spoom::Model::Mixin]) }
  def mixins; end
end

# @abstract It cannot be directly instantiated. Subclasses must implement the `abstract` methods below.
#
# source://spoom//lib/spoom/model/namespace_visitor.rb#6
class Spoom::Model::NamespaceVisitor < ::Spoom::Visitor
  abstract!

  # source://spoom//lib/spoom/model/namespace_visitor.rb#12
  sig { void }
  def initialize; end

  # source://spoom//lib/spoom/model/namespace_visitor.rb#19
  sig { override.params(node: T.nilable(::Prism::Node)).void }
  def visit(node); end
end

# source://spoom//lib/spoom/model/model.rb#212
class Spoom::Model::Prepend < ::Spoom::Model::Mixin; end

# A method or an attribute accessor
#
# @abstract It cannot be directly instantiated. Subclasses must implement the `abstract` methods below.
#
# source://spoom//lib/spoom/model/model.rb#151
class Spoom::Model::Property < ::Spoom::Model::SymbolDef
  abstract!

  # source://spoom//lib/spoom/model/model.rb#169
  sig do
    params(
      symbol: ::Spoom::Model::Symbol,
      owner: T.nilable(::Spoom::Model::Namespace),
      location: ::Spoom::Location,
      visibility: ::Spoom::Model::Visibility,
      sigs: T::Array[::Spoom::Model::Sig]
    ).void
  end
  def initialize(symbol, owner:, location:, visibility:, sigs: T.unsafe(nil)); end

  # source://spoom//lib/spoom/model/model.rb#158
  sig { returns(T::Array[::Spoom::Model::Sig]) }
  def sigs; end

  # source://spoom//lib/spoom/model/model.rb#155
  sig { returns(::Spoom::Model::Visibility) }
  def visibility; end
end

# A reference to something that looks like a constant or a method
#
# Constants could be classes, modules, or actual constants.
# Methods could be accessors, instance or class methods, aliases, etc.
#
# source://spoom//lib/spoom/model/reference.rb#10
class Spoom::Model::Reference < ::T::Struct
  const :kind, ::Spoom::Model::Reference::Kind
  const :name, ::String
  const :location, ::Spoom::Location

  # source://spoom//lib/spoom/model/reference.rb#39
  sig { returns(T::Boolean) }
  def constant?; end

  # source://spoom//lib/spoom/model/reference.rb#44
  sig { returns(T::Boolean) }
  def method?; end

  class << self
    # source://spoom//lib/spoom/model/reference.rb#24
    sig { params(name: ::String, location: ::Spoom::Location).returns(::Spoom::Model::Reference) }
    def constant(name, location); end

    # source://sorbet-runtime/0.5.11589/lib/types/struct.rb#13
    def inherited(s); end

    # source://spoom//lib/spoom/model/reference.rb#29
    sig { params(name: ::String, location: ::Spoom::Location).returns(::Spoom::Model::Reference) }
    def method(name, location); end
  end
end

# source://spoom//lib/spoom/model/reference.rb#13
class Spoom::Model::Reference::Kind < ::T::Enum
  enums do
    Constant = new
    Method = new
  end
end

# Visit a file to collect all the references to constants and methods
#
# source://spoom//lib/spoom/model/references_visitor.rb#7
class Spoom::Model::ReferencesVisitor < ::Spoom::Visitor
  # source://spoom//lib/spoom/model/references_visitor.rb#14
  sig { params(file: ::String).void }
  def initialize(file); end

  # source://spoom//lib/spoom/model/references_visitor.rb#11
  sig { returns(T::Array[::Spoom::Model::Reference]) }
  def references; end

  # source://spoom//lib/spoom/model/references_visitor.rb#22
  sig { override.params(node: ::Prism::AliasMethodNode).void }
  def visit_alias_method_node(node); end

  # source://spoom//lib/spoom/model/references_visitor.rb#27
  sig { override.params(node: ::Prism::AndNode).void }
  def visit_and_node(node); end

  # source://spoom//lib/spoom/model/references_visitor.rb#33
  sig { override.params(node: ::Prism::BlockArgumentNode).void }
  def visit_block_argument_node(node); end

  # source://spoom//lib/spoom/model/references_visitor.rb#44
  sig { override.params(node: ::Prism::CallAndWriteNode).void }
  def visit_call_and_write_node(node); end

  # source://spoom//lib/spoom/model/references_visitor.rb#68
  sig { override.params(node: ::Prism::CallNode).void }
  def visit_call_node(node); end

  # source://spoom//lib/spoom/model/references_visitor.rb#52
  sig { override.params(node: ::Prism::CallOperatorWriteNode).void }
  def visit_call_operator_write_node(node); end

  # source://spoom//lib/spoom/model/references_visitor.rb#60
  sig { override.params(node: ::Prism::CallOrWriteNode).void }
  def visit_call_or_write_node(node); end

  # source://spoom//lib/spoom/model/references_visitor.rb#85
  sig { override.params(node: ::Prism::ClassNode).void }
  def visit_class_node(node); end

  # source://spoom//lib/spoom/model/references_visitor.rb#91
  sig { override.params(node: ::Prism::ConstantAndWriteNode).void }
  def visit_constant_and_write_node(node); end

  # source://spoom//lib/spoom/model/references_visitor.rb#97
  sig { override.params(node: ::Prism::ConstantOperatorWriteNode).void }
  def visit_constant_operator_write_node(node); end

  # source://spoom//lib/spoom/model/references_visitor.rb#103
  sig { override.params(node: ::Prism::ConstantOrWriteNode).void }
  def visit_constant_or_write_node(node); end

  # source://spoom//lib/spoom/model/references_visitor.rb#109
  sig { override.params(node: ::Prism::ConstantPathNode).void }
  def visit_constant_path_node(node); end

  # source://spoom//lib/spoom/model/references_visitor.rb#115
  sig { override.params(node: ::Prism::ConstantPathWriteNode).void }
  def visit_constant_path_write_node(node); end

  # source://spoom//lib/spoom/model/references_visitor.rb#121
  sig { override.params(node: ::Prism::ConstantReadNode).void }
  def visit_constant_read_node(node); end

  # source://spoom//lib/spoom/model/references_visitor.rb#126
  sig { override.params(node: ::Prism::ConstantWriteNode).void }
  def visit_constant_write_node(node); end

  # source://spoom//lib/spoom/model/references_visitor.rb#131
  sig { override.params(node: ::Prism::LocalVariableAndWriteNode).void }
  def visit_local_variable_and_write_node(node); end

  # source://spoom//lib/spoom/model/references_visitor.rb#139
  sig { override.params(node: ::Prism::LocalVariableOperatorWriteNode).void }
  def visit_local_variable_operator_write_node(node); end

  # source://spoom//lib/spoom/model/references_visitor.rb#147
  sig { override.params(node: ::Prism::LocalVariableOrWriteNode).void }
  def visit_local_variable_or_write_node(node); end

  # source://spoom//lib/spoom/model/references_visitor.rb#155
  sig { override.params(node: ::Prism::LocalVariableWriteNode).void }
  def visit_local_variable_write_node(node); end

  # source://spoom//lib/spoom/model/references_visitor.rb#161
  sig { override.params(node: ::Prism::ModuleNode).void }
  def visit_module_node(node); end

  # source://spoom//lib/spoom/model/references_visitor.rb#166
  sig { override.params(node: ::Prism::MultiWriteNode).void }
  def visit_multi_write_node(node); end

  # source://spoom//lib/spoom/model/references_visitor.rb#177
  sig { override.params(node: ::Prism::OrNode).void }
  def visit_or_node(node); end

  private

  # source://spoom//lib/spoom/model/references_visitor.rb#195
  sig { params(node: ::Prism::Node).returns(::Spoom::Location) }
  def node_location(node); end

  # source://spoom//lib/spoom/model/references_visitor.rb#185
  sig { params(name: ::String, node: ::Prism::Node).void }
  def reference_constant(name, node); end

  # source://spoom//lib/spoom/model/references_visitor.rb#190
  sig { params(name: ::String, node: ::Prism::Node).void }
  def reference_method(name, node); end
end

# A Sorbet signature (sig block)
#
# source://spoom//lib/spoom/model/model.rb#216
class Spoom::Model::Sig
  # source://spoom//lib/spoom/model/model.rb#223
  sig { params(string: ::String).void }
  def initialize(string); end

  # source://spoom//lib/spoom/model/model.rb#220
  sig { returns(::String) }
  def string; end
end

# source://spoom//lib/spoom/model/model.rb#115
class Spoom::Model::SingletonClass < ::Spoom::Model::Namespace; end

# A Symbol is a uniquely named entity in the Ruby codebase
#
# A symbol can have multiple definitions, e.g. a class can be reopened.
# Sometimes a symbol can have multiple definitions of different types,
# e.g. `foo` method can be defined both as a method and as an attribute accessor.
#
# source://spoom//lib/spoom/model/model.rb#15
class Spoom::Model::Symbol
  # source://spoom//lib/spoom/model/model.rb#27
  sig { params(full_name: ::String).void }
  def initialize(full_name); end

  # The definitions of this symbol (where it exists in the code)
  #
  # source://spoom//lib/spoom/model/model.rb#24
  sig { returns(T::Array[::Spoom::Model::SymbolDef]) }
  def definitions; end

  # The full, unique name of this symbol
  #
  # source://spoom//lib/spoom/model/model.rb#20
  sig { returns(::String) }
  def full_name; end

  # The short name of this symbol
  #
  # source://spoom//lib/spoom/model/model.rb#34
  sig { returns(::String) }
  def name; end

  # source://spoom//lib/spoom/model/model.rb#39
  sig { returns(::String) }
  def to_s; end
end

# A SymbolDef is a definition of a Symbol
#
# It can be a class, module, constant, method, etc.
# A SymbolDef has a location pointing to the actual code that defines the symbol.
#
# @abstract It cannot be directly instantiated. Subclasses must implement the `abstract` methods below.
#
# source://spoom//lib/spoom/model/model.rb#55
class Spoom::Model::SymbolDef
  abstract!

  # source://spoom//lib/spoom/model/model.rb#74
  sig do
    params(
      symbol: ::Spoom::Model::Symbol,
      owner: T.nilable(::Spoom::Model::Namespace),
      location: ::Spoom::Location
    ).void
  end
  def initialize(symbol, owner:, location:); end

  # The full name of the symbol this definition belongs to
  #
  # source://spoom//lib/spoom/model/model.rb#85
  sig { returns(::String) }
  def full_name; end

  # The actual code location of this definition
  #
  # source://spoom//lib/spoom/model/model.rb#71
  sig { returns(::Spoom::Location) }
  def location; end

  # The short name of the symbol this definition belongs to
  #
  # source://spoom//lib/spoom/model/model.rb#91
  sig { returns(::String) }
  def name; end

  # The enclosing namespace this definition belongs to
  #
  # source://spoom//lib/spoom/model/model.rb#67
  sig { returns(T.nilable(::Spoom::Model::Namespace)) }
  def owner; end

  # The symbol this definition belongs to
  #
  # source://spoom//lib/spoom/model/model.rb#63
  sig { returns(::Spoom::Model::Symbol) }
  def symbol; end
end

# source://spoom//lib/spoom/model/model.rb#44
class Spoom::Model::UnresolvedSymbol < ::Spoom::Model::Symbol
  # source://spoom//lib/spoom/model/model.rb#46
  sig { override.returns(::String) }
  def to_s; end
end

# source://spoom//lib/spoom/model/model.rb#187
class Spoom::Model::Visibility < ::T::Enum
  enums do
    Private = new
    Protected = new
    Public = new
  end
end

# source://spoom//lib/spoom/parse.rb#7
class Spoom::ParseError < ::Spoom::Error; end

# A Poset is a set of elements with a partial order relation.
#
# The partial order relation is a binary relation that is reflexive, antisymmetric, and transitive.
# It can be used to represent a hierarchy of classes or modules, the dependencies between gems, etc.
#
# source://spoom//lib/spoom/poset.rb#9
class Spoom::Poset
  extend T::Generic

  E = type_member { { upper: Object } }

  # source://spoom//lib/spoom/poset.rb#18
  sig { void }
  def initialize; end

  # Get the POSet element for a given value
  #
  # Raises if the element is not found
  #
  # @raise [Error]
  #
  # source://spoom//lib/spoom/poset.rb#26
  sig { params(value: E).returns(Spoom::Poset::Element[E]) }
  def [](value); end

  # Add a direct edge from one element to another
  #
  # Transitive edges (transitive closure) are automatically computed.
  # Adds the elements if they don't exist.
  # If the direct edge already exists, nothing is done.
  #
  # source://spoom//lib/spoom/poset.rb#54
  sig { params(from: E, to: E).void }
  def add_direct_edge(from, to); end

  # Add an element to the POSet
  #
  # source://spoom//lib/spoom/poset.rb#35
  sig { params(value: E).returns(Spoom::Poset::Element[E]) }
  def add_element(value); end

  # Is there a direct edge from `from` to `to`?
  #
  # source://spoom//lib/spoom/poset.rb#101
  sig { params(from: E, to: E).returns(T::Boolean) }
  def direct_edge?(from, to); end

  # Is there an edge (direct or indirect) from `from` to `to`?
  #
  # source://spoom//lib/spoom/poset.rb#92
  sig { params(from: E, to: E).returns(T::Boolean) }
  def edge?(from, to); end

  # Is the given value a element in the POSet?
  #
  # source://spoom//lib/spoom/poset.rb#44
  sig { params(value: E).returns(T::Boolean) }
  def element?(value); end

  # Show the POSet as a DOT graph using xdot (used for debugging)
  #
  # source://spoom//lib/spoom/poset.rb#107
  sig { params(direct: T::Boolean, transitive: T::Boolean).void }
  def show_dot(direct: T.unsafe(nil), transitive: T.unsafe(nil)); end

  # Return the POSet as a DOT graph
  #
  # source://spoom//lib/spoom/poset.rb#116
  sig { params(direct: T::Boolean, transitive: T::Boolean).returns(::String) }
  def to_dot(direct: T.unsafe(nil), transitive: T.unsafe(nil)); end
end

# An element in a POSet
#
# source://spoom//lib/spoom/poset.rb#136
class Spoom::Poset::Element
  extend T::Generic
  include ::Comparable

  E = type_member { { upper: Object } }

  # source://spoom//lib/spoom/poset.rb#152
  sig { params(value: E).void }
  def initialize(value); end

  # source://spoom//lib/spoom/poset.rb#161
  sig { params(other: T.untyped).returns(T.nilable(::Integer)) }
  def <=>(other); end

  # Direct and indirect ancestors of this element
  #
  # source://spoom//lib/spoom/poset.rb#180
  sig { returns(T::Array[E]) }
  def ancestors; end

  # Direct children of this element
  #
  # source://spoom//lib/spoom/poset.rb#186
  sig { returns(T::Array[E]) }
  def children; end

  # Direct and indirect descendants of this element
  #
  # source://spoom//lib/spoom/poset.rb#192
  sig { returns(T::Array[E]) }
  def descendants; end

  # Edges (direct and indirect) from this element to other elements in the same POSet
  #
  # @return [Set<Element[E]>]
  #
  # source://spoom//lib/spoom/poset.rb#149
  def dfroms; end

  # Edges (direct and indirect) from this element to other elements in the same POSet
  #
  # source://spoom//lib/spoom/poset.rb#149
  sig { returns(T::Set[Spoom::Poset::Element[E]]) }
  def dtos; end

  # Edges (direct and indirect) from this element to other elements in the same POSet
  #
  # @return [Set<Element[E]>]
  #
  # source://spoom//lib/spoom/poset.rb#149
  def froms; end

  # Direct parents of this element
  #
  # source://spoom//lib/spoom/poset.rb#174
  sig { returns(T::Array[E]) }
  def parents; end

  # Edges (direct and indirect) from this element to other elements in the same POSet
  #
  # @return [Set<Element[E]>]
  #
  # source://spoom//lib/spoom/poset.rb#149
  def tos; end

  # The value held by this element
  #
  # source://spoom//lib/spoom/poset.rb#145
  sig { returns(E) }
  def value; end
end

# source://spoom//lib/spoom/poset.rb#13
class Spoom::Poset::Error < ::Spoom::Error; end

# source://spoom//lib/spoom/printer.rb#7
class Spoom::Printer
  include ::Spoom::Colorize

  # source://spoom//lib/spoom/printer.rb#17
  sig { params(out: T.any(::IO, ::StringIO), colors: T::Boolean, indent_level: ::Integer).void }
  def initialize(out: T.unsafe(nil), colors: T.unsafe(nil), indent_level: T.unsafe(nil)); end

  # Colorize `string` with color if `@colors`
  #
  # source://spoom//lib/spoom/printer.rb#78
  sig { params(string: ::String, color: ::Spoom::Color).returns(::String) }
  def colorize(string, *color); end

  # Decrease indent level
  #
  # source://spoom//lib/spoom/printer.rb#31
  sig { void }
  def dedent; end

  # Increase indent level
  #
  # source://spoom//lib/spoom/printer.rb#25
  sig { void }
  def indent; end

  # source://spoom//lib/spoom/printer.rb#14
  sig { returns(T.any(::IO, ::StringIO)) }
  def out; end

  # @return [IO, StringIO]
  #
  # source://spoom//lib/spoom/printer.rb#14
  def out=(_arg0); end

  # Print `string` into `out`
  #
  # source://spoom//lib/spoom/printer.rb#37
  sig { params(string: T.nilable(::String)).void }
  def print(string); end

  # Print `string` colored with `color` into `out`
  #
  # Does not use colors unless `@colors`.
  #
  # source://spoom//lib/spoom/printer.rb#47
  sig { params(string: T.nilable(::String), color: ::Spoom::Color).void }
  def print_colored(string, *color); end

  # Print `string` with indent and newline
  #
  # source://spoom//lib/spoom/printer.rb#62
  sig { params(string: T.nilable(::String)).void }
  def printl(string); end

  # Print a new line into `out`
  #
  # source://spoom//lib/spoom/printer.rb#56
  sig { void }
  def printn; end

  # Print an indent space into `out`
  #
  # source://spoom//lib/spoom/printer.rb#72
  sig { void }
  def printt; end
end

# source://spoom//lib/spoom.rb#10
Spoom::SPOOM_PATH = T.let(T.unsafe(nil), String)

# source://spoom//lib/spoom/sorbet/config.rb#5
module Spoom::Sorbet; end

# source://spoom//lib/spoom/sorbet.rb#39
Spoom::Sorbet::BIN_PATH = T.let(T.unsafe(nil), String)

# source://spoom//lib/spoom/sorbet.rb#36
Spoom::Sorbet::CONFIG_PATH = T.let(T.unsafe(nil), String)

# Parse Sorbet config files
#
# Parses a Sorbet config file:
#
# ```ruby
# config = Spoom::Sorbet::Config.parse_file("sorbet/config")
# puts config.paths   # "."
# ```
#
# Parses a Sorbet config string:
#
# ```ruby
# config = Spoom::Sorbet::Config.parse_string(<<~CONFIG)
#   a
#   --file=b
#   --ignore=c
# CONFIG
# puts config.paths   # "a", "b"
# puts config.ignore  # "c"
# ```
#
# source://spoom//lib/spoom/sorbet/config.rb#26
class Spoom::Sorbet::Config
  # source://spoom//lib/spoom/sorbet/config.rb#38
  sig { void }
  def initialize; end

  # @return [Array<String>]
  #
  # source://spoom//lib/spoom/sorbet/config.rb#32
  def allowed_extensions; end

  # @return [Array<String>]
  #
  # source://spoom//lib/spoom/sorbet/config.rb#32
  def allowed_extensions=(_arg0); end

  # source://spoom//lib/spoom/sorbet/config.rb#46
  sig { returns(::Spoom::Sorbet::Config) }
  def copy; end

  # @return [Array<String>]
  #
  # source://spoom//lib/spoom/sorbet/config.rb#32
  def ignore; end

  # @return [Array<String>]
  #
  # source://spoom//lib/spoom/sorbet/config.rb#32
  def ignore=(_arg0); end

  # source://spoom//lib/spoom/sorbet/config.rb#35
  sig { returns(T::Boolean) }
  def no_stdlib; end

  # @return [Boolean]
  #
  # source://spoom//lib/spoom/sorbet/config.rb#35
  def no_stdlib=(_arg0); end

  # Returns self as a string of options that can be passed to Sorbet
  #
  # Example:
  # ~~~rb
  # config = Sorbet::Config.new
  # config.paths << "/foo"
  # config.paths << "/bar"
  # config.ignore << "/baz"
  # config.allowed_extensions << ".rb"
  #
  # puts config.options_string # "/foo /bar --ignore /baz --allowed-extension .rb"
  # ~~~
  #
  # source://spoom//lib/spoom/sorbet/config.rb#68
  sig { returns(::String) }
  def options_string; end

  # source://spoom//lib/spoom/sorbet/config.rb#32
  sig { returns(T::Array[::String]) }
  def paths; end

  # @return [Array<String>]
  #
  # source://spoom//lib/spoom/sorbet/config.rb#32
  def paths=(_arg0); end

  class << self
    # source://spoom//lib/spoom/sorbet/config.rb#81
    sig { params(sorbet_config_path: ::String).returns(::Spoom::Sorbet::Config) }
    def parse_file(sorbet_config_path); end

    # source://spoom//lib/spoom/sorbet/config.rb#86
    sig { params(sorbet_config: ::String).returns(::Spoom::Sorbet::Config) }
    def parse_string(sorbet_config); end

    private

    # source://spoom//lib/spoom/sorbet/config.rb#150
    sig { params(line: ::String).returns(::String) }
    def parse_option(line); end
  end
end

# source://spoom//lib/spoom/sorbet/config.rb#29
Spoom::Sorbet::Config::DEFAULT_ALLOWED_EXTENSIONS = T.let(T.unsafe(nil), Array)

# source://spoom//lib/spoom/sorbet.rb#14
class Spoom::Sorbet::Error < ::Spoom::Error
  # source://spoom//lib/spoom/sorbet.rb#29
  sig { params(message: ::String, result: ::Spoom::ExecResult).void }
  def initialize(message, result); end

  # source://spoom//lib/spoom/sorbet.rb#21
  sig { returns(::Spoom::ExecResult) }
  def result; end
end

# source://spoom//lib/spoom/sorbet.rb#17
class Spoom::Sorbet::Error::Killed < ::Spoom::Sorbet::Error; end

# source://spoom//lib/spoom/sorbet.rb#18
class Spoom::Sorbet::Error::Segfault < ::Spoom::Sorbet::Error; end

# source://spoom//lib/spoom/sorbet/errors.rb#6
module Spoom::Sorbet::Errors
  class << self
    # source://spoom//lib/spoom/sorbet/errors.rb#13
    sig { params(errors: T::Array[::Spoom::Sorbet::Errors::Error]).returns(T::Array[::Spoom::Sorbet::Errors::Error]) }
    def sort_errors_by_code(errors); end
  end
end

# source://spoom//lib/spoom/sorbet/errors.rb#7
Spoom::Sorbet::Errors::DEFAULT_ERROR_URL_BASE = T.let(T.unsafe(nil), String)

# source://spoom//lib/spoom/sorbet/errors.rb#127
class Spoom::Sorbet::Errors::Error
  include ::Comparable

  # source://spoom//lib/spoom/sorbet/errors.rb#153
  sig do
    params(
      file: T.nilable(::String),
      line: T.nilable(::Integer),
      message: T.nilable(::String),
      code: T.nilable(::Integer),
      more: T::Array[::String]
    ).void
  end
  def initialize(file, line, message, code, more = T.unsafe(nil)); end

  # By default errors are sorted by location
  #
  # source://spoom//lib/spoom/sorbet/errors.rb#164
  sig { params(other: T.untyped).returns(::Integer) }
  def <=>(other); end

  # @return [Integer, nil]
  #
  # source://spoom//lib/spoom/sorbet/errors.rb#135
  def code; end

  # source://spoom//lib/spoom/sorbet/errors.rb#132
  sig { returns(T.nilable(::String)) }
  def file; end

  # Other files associated with the error
  #
  # source://spoom//lib/spoom/sorbet/errors.rb#142
  sig { returns(T::Set[::String]) }
  def files_from_error_sections; end

  # source://spoom//lib/spoom/sorbet/errors.rb#135
  sig { returns(T.nilable(::Integer)) }
  def line; end

  # @return [String, nil]
  #
  # source://spoom//lib/spoom/sorbet/errors.rb#132
  def message; end

  # source://spoom//lib/spoom/sorbet/errors.rb#138
  sig { returns(T::Array[::String]) }
  def more; end

  # source://spoom//lib/spoom/sorbet/errors.rb#171
  sig { returns(::String) }
  def to_s; end
end

# Parse errors from Sorbet output
#
# source://spoom//lib/spoom/sorbet/errors.rb#18
class Spoom::Sorbet::Errors::Parser
  # source://spoom//lib/spoom/sorbet/errors.rb#45
  sig { params(error_url_base: ::String).void }
  def initialize(error_url_base: T.unsafe(nil)); end

  # source://spoom//lib/spoom/sorbet/errors.rb#52
  sig { params(output: ::String).returns(T::Array[::Spoom::Sorbet::Errors::Error]) }
  def parse(output); end

  private

  # @raise [ParseError]
  #
  # source://spoom//lib/spoom/sorbet/errors.rb#116
  sig { params(line: ::String).void }
  def append_error(line); end

  # @raise [ParseError]
  #
  # source://spoom//lib/spoom/sorbet/errors.rb#108
  sig { void }
  def close_error; end

  # source://spoom//lib/spoom/sorbet/errors.rb#75
  sig { params(error_url_base: ::String).returns(::Regexp) }
  def error_line_match_regexp(error_url_base); end

  # source://spoom//lib/spoom/sorbet/errors.rb#92
  sig { params(line: ::String).returns(T.nilable(::Spoom::Sorbet::Errors::Error)) }
  def match_error_line(line); end

  # @raise [ParseError]
  #
  # source://spoom//lib/spoom/sorbet/errors.rb#101
  sig { params(error: ::Spoom::Sorbet::Errors::Error).void }
  def open_error(error); end

  class << self
    # source://spoom//lib/spoom/sorbet/errors.rb#38
    sig { params(output: ::String, error_url_base: ::String).returns(T::Array[::Spoom::Sorbet::Errors::Error]) }
    def parse_string(output, error_url_base: T.unsafe(nil)); end
  end
end

# source://spoom//lib/spoom/sorbet/errors.rb#23
Spoom::Sorbet::Errors::Parser::HEADER = T.let(T.unsafe(nil), Array)

# source://spoom//lib/spoom/sorbet/errors.rb#21
class Spoom::Sorbet::Errors::Parser::ParseError < ::Spoom::Error; end

# source://spoom//lib/spoom/sorbet.rb#37
Spoom::Sorbet::GEM_PATH = T.let(T.unsafe(nil), String)

# source://spoom//lib/spoom/sorbet.rb#38
Spoom::Sorbet::GEM_VERSION = T.let(T.unsafe(nil), String)

# source://spoom//lib/spoom/sorbet.rb#41
Spoom::Sorbet::KILLED_CODE = T.let(T.unsafe(nil), Integer)

# source://spoom//lib/spoom/sorbet/metrics.rb#8
module Spoom::Sorbet::MetricsParser
  class << self
    # source://spoom//lib/spoom/sorbet/metrics.rb#15
    sig { params(path: ::String, prefix: ::String).returns(T::Hash[::String, ::Integer]) }
    def parse_file(path, prefix = T.unsafe(nil)); end

    # source://spoom//lib/spoom/sorbet/metrics.rb#25
    sig { params(obj: T::Hash[::String, T.untyped], prefix: ::String).returns(T::Hash[::String, ::Integer]) }
    def parse_hash(obj, prefix = T.unsafe(nil)); end

    # source://spoom//lib/spoom/sorbet/metrics.rb#20
    sig { params(string: ::String, prefix: ::String).returns(T::Hash[::String, ::Integer]) }
    def parse_string(string, prefix = T.unsafe(nil)); end
  end
end

# source://spoom//lib/spoom/sorbet/metrics.rb#9
Spoom::Sorbet::MetricsParser::DEFAULT_PREFIX = T.let(T.unsafe(nil), String)

# source://spoom//lib/spoom/sorbet.rb#42
Spoom::Sorbet::SEGFAULT_CODE = T.let(T.unsafe(nil), Integer)

# source://spoom//lib/spoom/sorbet/sigils.rb#9
module Spoom::Sorbet::Sigils
  class << self
    # changes the sigil in the file at the passed path to the specified new strictness
    #
    # source://spoom//lib/spoom/sorbet/sigils.rb#72
    sig { params(path: T.any(::Pathname, ::String), new_strictness: ::String).returns(T::Boolean) }
    def change_sigil_in_file(path, new_strictness); end

    # changes the sigil to have a new strictness in a list of files
    #
    # source://spoom//lib/spoom/sorbet/sigils.rb#83
    sig { params(path_list: T::Array[::String], new_strictness: ::String).returns(T::Array[::String]) }
    def change_sigil_in_files(path_list, new_strictness); end

    # returns a string containing the strictness of a sigil in a file at the passed path
    # * returns nil if no sigil
    #
    # source://spoom//lib/spoom/sorbet/sigils.rb#63
    sig { params(path: T.any(::Pathname, ::String)).returns(T.nilable(::String)) }
    def file_strictness(path); end

    # returns the full sigil comment string for the passed strictness
    #
    # source://spoom//lib/spoom/sorbet/sigils.rb#38
    sig { params(strictness: ::String).returns(::String) }
    def sigil_string(strictness); end

    # returns the strictness of a sigil in the passed file content string (nil if no sigil)
    #
    # source://spoom//lib/spoom/sorbet/sigils.rb#50
    sig { params(content: ::String).returns(T.nilable(::String)) }
    def strictness_in_content(content); end

    # returns a string which is the passed content but with the sigil updated to a new strictness
    #
    # source://spoom//lib/spoom/sorbet/sigils.rb#56
    sig { params(content: ::String, new_strictness: ::String).returns(::String) }
    def update_sigil(content, new_strictness); end

    # returns true if the passed string is a valid strictness (else false)
    #
    # source://spoom//lib/spoom/sorbet/sigils.rb#44
    sig { params(strictness: ::String).returns(T::Boolean) }
    def valid_strictness?(strictness); end
  end
end

# source://spoom//lib/spoom/sorbet/sigils.rb#31
Spoom::Sorbet::Sigils::SIGIL_REGEXP = T.let(T.unsafe(nil), Regexp)

# source://spoom//lib/spoom/sorbet/sigils.rb#13
Spoom::Sorbet::Sigils::STRICTNESS_FALSE = T.let(T.unsafe(nil), String)

# source://spoom//lib/spoom/sorbet/sigils.rb#12
Spoom::Sorbet::Sigils::STRICTNESS_IGNORE = T.let(T.unsafe(nil), String)

# source://spoom//lib/spoom/sorbet/sigils.rb#17
Spoom::Sorbet::Sigils::STRICTNESS_INTERNAL = T.let(T.unsafe(nil), String)

# source://spoom//lib/spoom/sorbet/sigils.rb#15
Spoom::Sorbet::Sigils::STRICTNESS_STRICT = T.let(T.unsafe(nil), String)

# source://spoom//lib/spoom/sorbet/sigils.rb#16
Spoom::Sorbet::Sigils::STRICTNESS_STRONG = T.let(T.unsafe(nil), String)

# source://spoom//lib/spoom/sorbet/sigils.rb#14
Spoom::Sorbet::Sigils::STRICTNESS_TRUE = T.let(T.unsafe(nil), String)

# source://spoom//lib/spoom/sorbet/sigils.rb#19
Spoom::Sorbet::Sigils::VALID_STRICTNESS = T.let(T.unsafe(nil), Array)

# source://spoom//lib/spoom/timeline.rb#5
class Spoom::Timeline
  # source://spoom//lib/spoom/timeline.rb#9
  sig { params(context: ::Spoom::Context, from: ::Time, to: ::Time).void }
  def initialize(context, from, to); end

  # Return one commit for each date in `dates`
  #
  # source://spoom//lib/spoom/timeline.rb#36
  sig { params(dates: T::Array[::Time]).returns(T::Array[::Spoom::Git::Commit]) }
  def commits_for_dates(dates); end

  # Return all months between `from` and `to`
  #
  # source://spoom//lib/spoom/timeline.rb#23
  sig { returns(T::Array[::Time]) }
  def months; end

  # Return one commit for each month between `from` and `to`
  #
  # source://spoom//lib/spoom/timeline.rb#17
  sig { returns(T::Array[::Spoom::Git::Commit]) }
  def ticks; end
end

# source://spoom//lib/spoom/version.rb#5
Spoom::VERSION = T.let(T.unsafe(nil), String)

# source://spoom//lib/spoom/visitor.rb#7
class Spoom::Visitor < ::Prism::Visitor
  # source://spoom//lib/spoom/visitor.rb#16
  sig { override.params(node: ::Prism::AliasGlobalVariableNode).void }
  def visit_alias_global_variable_node(node); end

  # source://spoom//lib/spoom/visitor.rb#21
  sig { override.params(node: ::Prism::AliasMethodNode).void }
  def visit_alias_method_node(node); end

  # source://spoom//lib/spoom/visitor.rb#26
  sig { override.params(node: ::Prism::AlternationPatternNode).void }
  def visit_alternation_pattern_node(node); end

  # source://spoom//lib/spoom/visitor.rb#31
  sig { override.params(node: ::Prism::AndNode).void }
  def visit_and_node(node); end

  # source://spoom//lib/spoom/visitor.rb#36
  sig { override.params(node: ::Prism::ArgumentsNode).void }
  def visit_arguments_node(node); end

  # source://spoom//lib/spoom/visitor.rb#41
  sig { override.params(node: ::Prism::ArrayNode).void }
  def visit_array_node(node); end

  # source://spoom//lib/spoom/visitor.rb#46
  sig { override.params(node: ::Prism::ArrayPatternNode).void }
  def visit_array_pattern_node(node); end

  # source://spoom//lib/spoom/visitor.rb#51
  sig { override.params(node: ::Prism::AssocNode).void }
  def visit_assoc_node(node); end

  # source://spoom//lib/spoom/visitor.rb#56
  sig { override.params(node: ::Prism::AssocSplatNode).void }
  def visit_assoc_splat_node(node); end

  # source://spoom//lib/spoom/visitor.rb#61
  sig { override.params(node: ::Prism::BackReferenceReadNode).void }
  def visit_back_reference_read_node(node); end

  # source://spoom//lib/spoom/visitor.rb#66
  sig { override.params(node: ::Prism::BeginNode).void }
  def visit_begin_node(node); end

  # source://spoom//lib/spoom/visitor.rb#71
  sig { override.params(node: ::Prism::BlockArgumentNode).void }
  def visit_block_argument_node(node); end

  # source://spoom//lib/spoom/visitor.rb#76
  sig { override.params(node: ::Prism::BlockLocalVariableNode).void }
  def visit_block_local_variable_node(node); end

  # source://spoom//lib/spoom/visitor.rb#81
  sig { override.params(node: ::Prism::BlockNode).void }
  def visit_block_node(node); end

  # source://spoom//lib/spoom/visitor.rb#86
  sig { override.params(node: ::Prism::BlockParameterNode).void }
  def visit_block_parameter_node(node); end

  # source://spoom//lib/spoom/visitor.rb#91
  sig { override.params(node: ::Prism::BlockParametersNode).void }
  def visit_block_parameters_node(node); end

  # source://spoom//lib/spoom/visitor.rb#96
  sig { override.params(node: ::Prism::BreakNode).void }
  def visit_break_node(node); end

  # source://spoom//lib/spoom/visitor.rb#101
  sig { override.params(node: ::Prism::CallAndWriteNode).void }
  def visit_call_and_write_node(node); end

  # source://spoom//lib/spoom/visitor.rb#106
  sig { override.params(node: ::Prism::CallNode).void }
  def visit_call_node(node); end

  # source://spoom//lib/spoom/visitor.rb#111
  sig { override.params(node: ::Prism::CallOperatorWriteNode).void }
  def visit_call_operator_write_node(node); end

  # source://spoom//lib/spoom/visitor.rb#116
  sig { override.params(node: ::Prism::CallOrWriteNode).void }
  def visit_call_or_write_node(node); end

  # source://spoom//lib/spoom/visitor.rb#121
  sig { override.params(node: ::Prism::CallTargetNode).void }
  def visit_call_target_node(node); end

  # source://spoom//lib/spoom/visitor.rb#126
  sig { override.params(node: ::Prism::CapturePatternNode).void }
  def visit_capture_pattern_node(node); end

  # source://spoom//lib/spoom/visitor.rb#131
  sig { override.params(node: ::Prism::CaseMatchNode).void }
  def visit_case_match_node(node); end

  # source://spoom//lib/spoom/visitor.rb#136
  sig { override.params(node: ::Prism::CaseNode).void }
  def visit_case_node(node); end

  # source://spoom//lib/spoom/visitor.rb#11
  sig { override.params(node: ::Prism::Node).void }
  def visit_child_nodes(node); end

  # source://spoom//lib/spoom/visitor.rb#141
  sig { override.params(node: ::Prism::ClassNode).void }
  def visit_class_node(node); end

  # source://spoom//lib/spoom/visitor.rb#146
  sig { override.params(node: ::Prism::ClassVariableAndWriteNode).void }
  def visit_class_variable_and_write_node(node); end

  # source://spoom//lib/spoom/visitor.rb#151
  sig { override.params(node: ::Prism::ClassVariableOperatorWriteNode).void }
  def visit_class_variable_operator_write_node(node); end

  # source://spoom//lib/spoom/visitor.rb#156
  sig { override.params(node: ::Prism::ClassVariableOrWriteNode).void }
  def visit_class_variable_or_write_node(node); end

  # source://spoom//lib/spoom/visitor.rb#161
  sig { override.params(node: ::Prism::ClassVariableReadNode).void }
  def visit_class_variable_read_node(node); end

  # source://spoom//lib/spoom/visitor.rb#166
  sig { override.params(node: ::Prism::ClassVariableTargetNode).void }
  def visit_class_variable_target_node(node); end

  # source://spoom//lib/spoom/visitor.rb#171
  sig { override.params(node: ::Prism::ClassVariableWriteNode).void }
  def visit_class_variable_write_node(node); end

  # source://spoom//lib/spoom/visitor.rb#176
  sig { override.params(node: ::Prism::ConstantAndWriteNode).void }
  def visit_constant_and_write_node(node); end

  # source://spoom//lib/spoom/visitor.rb#181
  sig { override.params(node: ::Prism::ConstantOperatorWriteNode).void }
  def visit_constant_operator_write_node(node); end

  # source://spoom//lib/spoom/visitor.rb#186
  sig { override.params(node: ::Prism::ConstantOrWriteNode).void }
  def visit_constant_or_write_node(node); end

  # source://spoom//lib/spoom/visitor.rb#191
  sig { override.params(node: ::Prism::ConstantPathAndWriteNode).void }
  def visit_constant_path_and_write_node(node); end

  # source://spoom//lib/spoom/visitor.rb#196
  sig { override.params(node: ::Prism::ConstantPathNode).void }
  def visit_constant_path_node(node); end

  # source://spoom//lib/spoom/visitor.rb#201
  sig { override.params(node: ::Prism::ConstantPathOperatorWriteNode).void }
  def visit_constant_path_operator_write_node(node); end

  # source://spoom//lib/spoom/visitor.rb#206
  sig { override.params(node: ::Prism::ConstantPathOrWriteNode).void }
  def visit_constant_path_or_write_node(node); end

  # source://spoom//lib/spoom/visitor.rb#211
  sig { override.params(node: ::Prism::ConstantPathTargetNode).void }
  def visit_constant_path_target_node(node); end

  # source://spoom//lib/spoom/visitor.rb#216
  sig { override.params(node: ::Prism::ConstantPathWriteNode).void }
  def visit_constant_path_write_node(node); end

  # source://spoom//lib/spoom/visitor.rb#221
  sig { override.params(node: ::Prism::ConstantReadNode).void }
  def visit_constant_read_node(node); end

  # source://spoom//lib/spoom/visitor.rb#226
  sig { override.params(node: ::Prism::ConstantTargetNode).void }
  def visit_constant_target_node(node); end

  # source://spoom//lib/spoom/visitor.rb#231
  sig { override.params(node: ::Prism::ConstantWriteNode).void }
  def visit_constant_write_node(node); end

  # source://spoom//lib/spoom/visitor.rb#236
  sig { override.params(node: ::Prism::DefNode).void }
  def visit_def_node(node); end

  # source://spoom//lib/spoom/visitor.rb#241
  sig { override.params(node: ::Prism::DefinedNode).void }
  def visit_defined_node(node); end

  # source://spoom//lib/spoom/visitor.rb#246
  sig { override.params(node: ::Prism::ElseNode).void }
  def visit_else_node(node); end

  # source://spoom//lib/spoom/visitor.rb#251
  sig { override.params(node: ::Prism::EmbeddedStatementsNode).void }
  def visit_embedded_statements_node(node); end

  # source://spoom//lib/spoom/visitor.rb#256
  sig { override.params(node: ::Prism::EmbeddedVariableNode).void }
  def visit_embedded_variable_node(node); end

  # source://spoom//lib/spoom/visitor.rb#261
  sig { override.params(node: ::Prism::EnsureNode).void }
  def visit_ensure_node(node); end

  # source://spoom//lib/spoom/visitor.rb#266
  sig { override.params(node: ::Prism::FalseNode).void }
  def visit_false_node(node); end

  # source://spoom//lib/spoom/visitor.rb#271
  sig { override.params(node: ::Prism::FindPatternNode).void }
  def visit_find_pattern_node(node); end

  # source://spoom//lib/spoom/visitor.rb#276
  sig { override.params(node: ::Prism::FlipFlopNode).void }
  def visit_flip_flop_node(node); end

  # source://spoom//lib/spoom/visitor.rb#281
  sig { override.params(node: ::Prism::FloatNode).void }
  def visit_float_node(node); end

  # source://spoom//lib/spoom/visitor.rb#286
  sig { override.params(node: ::Prism::ForNode).void }
  def visit_for_node(node); end

  # source://spoom//lib/spoom/visitor.rb#291
  sig { override.params(node: ::Prism::ForwardingArgumentsNode).void }
  def visit_forwarding_arguments_node(node); end

  # source://spoom//lib/spoom/visitor.rb#296
  sig { override.params(node: ::Prism::ForwardingParameterNode).void }
  def visit_forwarding_parameter_node(node); end

  # source://spoom//lib/spoom/visitor.rb#301
  sig { override.params(node: ::Prism::ForwardingSuperNode).void }
  def visit_forwarding_super_node(node); end

  # source://spoom//lib/spoom/visitor.rb#306
  sig { override.params(node: ::Prism::GlobalVariableAndWriteNode).void }
  def visit_global_variable_and_write_node(node); end

  # source://spoom//lib/spoom/visitor.rb#311
  sig { override.params(node: ::Prism::GlobalVariableOperatorWriteNode).void }
  def visit_global_variable_operator_write_node(node); end

  # source://spoom//lib/spoom/visitor.rb#316
  sig { override.params(node: ::Prism::GlobalVariableOrWriteNode).void }
  def visit_global_variable_or_write_node(node); end

  # source://spoom//lib/spoom/visitor.rb#321
  sig { override.params(node: ::Prism::GlobalVariableReadNode).void }
  def visit_global_variable_read_node(node); end

  # source://spoom//lib/spoom/visitor.rb#326
  sig { override.params(node: ::Prism::GlobalVariableTargetNode).void }
  def visit_global_variable_target_node(node); end

  # source://spoom//lib/spoom/visitor.rb#331
  sig { override.params(node: ::Prism::GlobalVariableWriteNode).void }
  def visit_global_variable_write_node(node); end

  # source://spoom//lib/spoom/visitor.rb#336
  sig { override.params(node: ::Prism::HashNode).void }
  def visit_hash_node(node); end

  # source://spoom//lib/spoom/visitor.rb#341
  sig { override.params(node: ::Prism::HashPatternNode).void }
  def visit_hash_pattern_node(node); end

  # source://spoom//lib/spoom/visitor.rb#346
  sig { override.params(node: ::Prism::IfNode).void }
  def visit_if_node(node); end

  # source://spoom//lib/spoom/visitor.rb#351
  sig { override.params(node: ::Prism::ImaginaryNode).void }
  def visit_imaginary_node(node); end

  # source://spoom//lib/spoom/visitor.rb#356
  sig { override.params(node: ::Prism::ImplicitNode).void }
  def visit_implicit_node(node); end

  # source://spoom//lib/spoom/visitor.rb#361
  sig { override.params(node: ::Prism::ImplicitRestNode).void }
  def visit_implicit_rest_node(node); end

  # source://spoom//lib/spoom/visitor.rb#366
  sig { override.params(node: ::Prism::InNode).void }
  def visit_in_node(node); end

  # source://spoom//lib/spoom/visitor.rb#371
  sig { override.params(node: ::Prism::IndexAndWriteNode).void }
  def visit_index_and_write_node(node); end

  # source://spoom//lib/spoom/visitor.rb#376
  sig { override.params(node: ::Prism::IndexOperatorWriteNode).void }
  def visit_index_operator_write_node(node); end

  # source://spoom//lib/spoom/visitor.rb#381
  sig { override.params(node: ::Prism::IndexOrWriteNode).void }
  def visit_index_or_write_node(node); end

  # source://spoom//lib/spoom/visitor.rb#386
  sig { override.params(node: ::Prism::IndexTargetNode).void }
  def visit_index_target_node(node); end

  # source://spoom//lib/spoom/visitor.rb#391
  sig { override.params(node: ::Prism::InstanceVariableAndWriteNode).void }
  def visit_instance_variable_and_write_node(node); end

  # source://spoom//lib/spoom/visitor.rb#396
  sig { override.params(node: ::Prism::InstanceVariableOperatorWriteNode).void }
  def visit_instance_variable_operator_write_node(node); end

  # source://spoom//lib/spoom/visitor.rb#401
  sig { override.params(node: ::Prism::InstanceVariableOrWriteNode).void }
  def visit_instance_variable_or_write_node(node); end

  # source://spoom//lib/spoom/visitor.rb#406
  sig { override.params(node: ::Prism::InstanceVariableReadNode).void }
  def visit_instance_variable_read_node(node); end

  # source://spoom//lib/spoom/visitor.rb#411
  sig { override.params(node: ::Prism::InstanceVariableTargetNode).void }
  def visit_instance_variable_target_node(node); end

  # source://spoom//lib/spoom/visitor.rb#416
  sig { override.params(node: ::Prism::InstanceVariableWriteNode).void }
  def visit_instance_variable_write_node(node); end

  # source://spoom//lib/spoom/visitor.rb#421
  sig { override.params(node: ::Prism::IntegerNode).void }
  def visit_integer_node(node); end

  # source://spoom//lib/spoom/visitor.rb#426
  sig { override.params(node: ::Prism::InterpolatedMatchLastLineNode).void }
  def visit_interpolated_match_last_line_node(node); end

  # source://spoom//lib/spoom/visitor.rb#431
  sig { override.params(node: ::Prism::InterpolatedRegularExpressionNode).void }
  def visit_interpolated_regular_expression_node(node); end

  # source://spoom//lib/spoom/visitor.rb#436
  sig { override.params(node: ::Prism::InterpolatedStringNode).void }
  def visit_interpolated_string_node(node); end

  # source://spoom//lib/spoom/visitor.rb#441
  sig { override.params(node: ::Prism::InterpolatedSymbolNode).void }
  def visit_interpolated_symbol_node(node); end

  # source://spoom//lib/spoom/visitor.rb#446
  sig { override.params(node: ::Prism::InterpolatedXStringNode).void }
  def visit_interpolated_x_string_node(node); end

  # source://spoom//lib/spoom/visitor.rb#451
  sig { override.params(node: ::Prism::KeywordHashNode).void }
  def visit_keyword_hash_node(node); end

  # source://spoom//lib/spoom/visitor.rb#456
  sig { override.params(node: ::Prism::KeywordRestParameterNode).void }
  def visit_keyword_rest_parameter_node(node); end

  # source://spoom//lib/spoom/visitor.rb#461
  sig { override.params(node: ::Prism::LambdaNode).void }
  def visit_lambda_node(node); end

  # source://spoom//lib/spoom/visitor.rb#466
  sig { override.params(node: ::Prism::LocalVariableAndWriteNode).void }
  def visit_local_variable_and_write_node(node); end

  # source://spoom//lib/spoom/visitor.rb#471
  sig { override.params(node: ::Prism::LocalVariableOperatorWriteNode).void }
  def visit_local_variable_operator_write_node(node); end

  # source://spoom//lib/spoom/visitor.rb#476
  sig { override.params(node: ::Prism::LocalVariableOrWriteNode).void }
  def visit_local_variable_or_write_node(node); end

  # source://spoom//lib/spoom/visitor.rb#481
  sig { override.params(node: ::Prism::LocalVariableReadNode).void }
  def visit_local_variable_read_node(node); end

  # source://spoom//lib/spoom/visitor.rb#486
  sig { override.params(node: ::Prism::LocalVariableTargetNode).void }
  def visit_local_variable_target_node(node); end

  # source://spoom//lib/spoom/visitor.rb#491
  sig { override.params(node: ::Prism::LocalVariableWriteNode).void }
  def visit_local_variable_write_node(node); end

  # source://spoom//lib/spoom/visitor.rb#496
  sig { override.params(node: ::Prism::MatchLastLineNode).void }
  def visit_match_last_line_node(node); end

  # source://spoom//lib/spoom/visitor.rb#501
  sig { override.params(node: ::Prism::MatchPredicateNode).void }
  def visit_match_predicate_node(node); end

  # source://spoom//lib/spoom/visitor.rb#506
  sig { override.params(node: ::Prism::MatchRequiredNode).void }
  def visit_match_required_node(node); end

  # source://spoom//lib/spoom/visitor.rb#511
  sig { override.params(node: ::Prism::MatchWriteNode).void }
  def visit_match_write_node(node); end

  # source://spoom//lib/spoom/visitor.rb#516
  sig { override.params(node: ::Prism::MissingNode).void }
  def visit_missing_node(node); end

  # source://spoom//lib/spoom/visitor.rb#521
  sig { override.params(node: ::Prism::ModuleNode).void }
  def visit_module_node(node); end

  # source://spoom//lib/spoom/visitor.rb#526
  sig { override.params(node: ::Prism::MultiTargetNode).void }
  def visit_multi_target_node(node); end

  # source://spoom//lib/spoom/visitor.rb#531
  sig { override.params(node: ::Prism::MultiWriteNode).void }
  def visit_multi_write_node(node); end

  # source://spoom//lib/spoom/visitor.rb#536
  sig { override.params(node: ::Prism::NextNode).void }
  def visit_next_node(node); end

  # source://spoom//lib/spoom/visitor.rb#541
  sig { override.params(node: ::Prism::NilNode).void }
  def visit_nil_node(node); end

  # source://spoom//lib/spoom/visitor.rb#546
  sig { override.params(node: ::Prism::NoKeywordsParameterNode).void }
  def visit_no_keywords_parameter_node(node); end

  # source://spoom//lib/spoom/visitor.rb#551
  sig { override.params(node: ::Prism::NumberedParametersNode).void }
  def visit_numbered_parameters_node(node); end

  # source://spoom//lib/spoom/visitor.rb#556
  sig { override.params(node: ::Prism::NumberedReferenceReadNode).void }
  def visit_numbered_reference_read_node(node); end

  # source://spoom//lib/spoom/visitor.rb#561
  sig { override.params(node: ::Prism::OptionalKeywordParameterNode).void }
  def visit_optional_keyword_parameter_node(node); end

  # source://spoom//lib/spoom/visitor.rb#566
  sig { override.params(node: ::Prism::OptionalParameterNode).void }
  def visit_optional_parameter_node(node); end

  # source://spoom//lib/spoom/visitor.rb#571
  sig { override.params(node: ::Prism::OrNode).void }
  def visit_or_node(node); end

  # source://spoom//lib/spoom/visitor.rb#576
  sig { override.params(node: ::Prism::ParametersNode).void }
  def visit_parameters_node(node); end

  # source://spoom//lib/spoom/visitor.rb#581
  sig { override.params(node: ::Prism::ParenthesesNode).void }
  def visit_parentheses_node(node); end

  # source://spoom//lib/spoom/visitor.rb#586
  sig { override.params(node: ::Prism::PinnedExpressionNode).void }
  def visit_pinned_expression_node(node); end

  # source://spoom//lib/spoom/visitor.rb#591
  sig { override.params(node: ::Prism::PinnedVariableNode).void }
  def visit_pinned_variable_node(node); end

  # source://spoom//lib/spoom/visitor.rb#596
  sig { override.params(node: ::Prism::PostExecutionNode).void }
  def visit_post_execution_node(node); end

  # source://spoom//lib/spoom/visitor.rb#601
  sig { override.params(node: ::Prism::PreExecutionNode).void }
  def visit_pre_execution_node(node); end

  # source://spoom//lib/spoom/visitor.rb#606
  sig { override.params(node: ::Prism::ProgramNode).void }
  def visit_program_node(node); end

  # source://spoom//lib/spoom/visitor.rb#611
  sig { override.params(node: ::Prism::RangeNode).void }
  def visit_range_node(node); end

  # source://spoom//lib/spoom/visitor.rb#616
  sig { override.params(node: ::Prism::RationalNode).void }
  def visit_rational_node(node); end

  # source://spoom//lib/spoom/visitor.rb#621
  sig { override.params(node: ::Prism::RedoNode).void }
  def visit_redo_node(node); end

  # source://spoom//lib/spoom/visitor.rb#626
  sig { override.params(node: ::Prism::RegularExpressionNode).void }
  def visit_regular_expression_node(node); end

  # source://spoom//lib/spoom/visitor.rb#631
  sig { override.params(node: ::Prism::RequiredKeywordParameterNode).void }
  def visit_required_keyword_parameter_node(node); end

  # source://spoom//lib/spoom/visitor.rb#636
  sig { override.params(node: ::Prism::RequiredParameterNode).void }
  def visit_required_parameter_node(node); end

  # source://spoom//lib/spoom/visitor.rb#641
  sig { override.params(node: ::Prism::RescueModifierNode).void }
  def visit_rescue_modifier_node(node); end

  # source://spoom//lib/spoom/visitor.rb#646
  sig { override.params(node: ::Prism::RescueNode).void }
  def visit_rescue_node(node); end

  # source://spoom//lib/spoom/visitor.rb#651
  sig { override.params(node: ::Prism::RestParameterNode).void }
  def visit_rest_parameter_node(node); end

  # source://spoom//lib/spoom/visitor.rb#656
  sig { override.params(node: ::Prism::RetryNode).void }
  def visit_retry_node(node); end

  # source://spoom//lib/spoom/visitor.rb#661
  sig { override.params(node: ::Prism::ReturnNode).void }
  def visit_return_node(node); end

  # source://spoom//lib/spoom/visitor.rb#666
  sig { override.params(node: ::Prism::SelfNode).void }
  def visit_self_node(node); end

  # source://spoom//lib/spoom/visitor.rb#671
  sig { override.params(node: ::Prism::SingletonClassNode).void }
  def visit_singleton_class_node(node); end

  # source://spoom//lib/spoom/visitor.rb#676
  sig { override.params(node: ::Prism::SourceEncodingNode).void }
  def visit_source_encoding_node(node); end

  # source://spoom//lib/spoom/visitor.rb#681
  sig { override.params(node: ::Prism::SourceFileNode).void }
  def visit_source_file_node(node); end

  # source://spoom//lib/spoom/visitor.rb#686
  sig { override.params(node: ::Prism::SourceLineNode).void }
  def visit_source_line_node(node); end

  # source://spoom//lib/spoom/visitor.rb#691
  sig { override.params(node: ::Prism::SplatNode).void }
  def visit_splat_node(node); end

  # source://spoom//lib/spoom/visitor.rb#696
  sig { override.params(node: ::Prism::StatementsNode).void }
  def visit_statements_node(node); end

  # source://spoom//lib/spoom/visitor.rb#701
  sig { override.params(node: ::Prism::StringNode).void }
  def visit_string_node(node); end

  # source://spoom//lib/spoom/visitor.rb#706
  sig { override.params(node: ::Prism::SuperNode).void }
  def visit_super_node(node); end

  # source://spoom//lib/spoom/visitor.rb#711
  sig { override.params(node: ::Prism::SymbolNode).void }
  def visit_symbol_node(node); end

  # source://spoom//lib/spoom/visitor.rb#716
  sig { override.params(node: ::Prism::TrueNode).void }
  def visit_true_node(node); end

  # source://spoom//lib/spoom/visitor.rb#721
  sig { override.params(node: ::Prism::UndefNode).void }
  def visit_undef_node(node); end

  # source://spoom//lib/spoom/visitor.rb#726
  sig { override.params(node: ::Prism::UnlessNode).void }
  def visit_unless_node(node); end

  # source://spoom//lib/spoom/visitor.rb#731
  sig { override.params(node: ::Prism::UntilNode).void }
  def visit_until_node(node); end

  # source://spoom//lib/spoom/visitor.rb#736
  sig { override.params(node: ::Prism::WhenNode).void }
  def visit_when_node(node); end

  # source://spoom//lib/spoom/visitor.rb#741
  sig { override.params(node: ::Prism::WhileNode).void }
  def visit_while_node(node); end

  # source://spoom//lib/spoom/visitor.rb#746
  sig { override.params(node: ::Prism::XStringNode).void }
  def visit_x_string_node(node); end

  # source://spoom//lib/spoom/visitor.rb#751
  sig { override.params(node: ::Prism::YieldNode).void }
  def visit_yield_node(node); end
end
