# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `rbi` gem.
# Please instead update this file by running `bin/tapioca gem rbi`.


# source://rbi//lib/rbi.rb#7
module RBI; end

# source://rbi//lib/rbi/model.rb#1045
class RBI::Arg < ::RBI::Node
  # source://rbi//lib/rbi/model.rb#1057
  sig { params(value: ::String, loc: T.nilable(::RBI::Loc)).void }
  def initialize(value, loc: T.unsafe(nil)); end

  # source://rbi//lib/rbi/model.rb#1063
  sig { params(other: T.nilable(::Object)).returns(T::Boolean) }
  def ==(other); end

  # source://rbi//lib/rbi/model.rb#1068
  sig { returns(::String) }
  def to_s; end

  # source://rbi//lib/rbi/model.rb#1049
  sig { returns(::String) }
  def value; end
end

# Attributes
#
# @abstract It cannot be directly instantiated. Subclasses must implement the `abstract` methods below.
#
# source://rbi//lib/rbi/model.rb#351
class RBI::Attr < ::RBI::NodeWithComments
  include ::RBI::Indexable

  abstract!

  # source://rbi//lib/rbi/model.rb#376
  sig do
    params(
      name: ::Symbol,
      names: T::Array[::Symbol],
      visibility: ::RBI::Visibility,
      sigs: T::Array[::RBI::Sig],
      loc: T.nilable(::RBI::Loc),
      comments: T::Array[::RBI::Comment]
    ).void
  end
  def initialize(name, names, visibility: T.unsafe(nil), sigs: T.unsafe(nil), loc: T.unsafe(nil), comments: T.unsafe(nil)); end

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#420
  sig { override.params(other: ::RBI::Node).returns(T::Boolean) }
  def compatible_with?(other); end

  # @abstract
  #
  # source://rbi//lib/rbi/rewriters/attr_to_methods.rb#61
  sig { abstract.returns(T::Array[::RBI::Method]) }
  def convert_to_methods; end

  # @abstract
  #
  # source://rbi//lib/rbi/model.rb#384
  sig { abstract.returns(T::Array[::String]) }
  def fully_qualified_names; end

  # source://rbi//lib/rbi/index.rb#113
  sig { override.returns(T::Array[::String]) }
  def index_ids; end

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#428
  sig { override.params(other: ::RBI::Node).void }
  def merge_with(other); end

  # source://rbi//lib/rbi/model.rb#358
  sig { returns(T::Array[::Symbol]) }
  def names; end

  # source://rbi//lib/rbi/model.rb#364
  sig { returns(T::Array[::RBI::Sig]) }
  def sigs; end

  # source://rbi//lib/rbi/model.rb#361
  sig { returns(::RBI::Visibility) }
  def visibility; end

  # @return [Visibility]
  #
  # source://rbi//lib/rbi/model.rb#361
  def visibility=(_arg0); end

  private

  # source://rbi//lib/rbi/rewriters/attr_to_methods.rb#89
  sig do
    params(
      name: ::String,
      sig: T.nilable(::RBI::Sig),
      visibility: ::RBI::Visibility,
      loc: T.nilable(::RBI::Loc),
      comments: T::Array[::RBI::Comment]
    ).returns(::RBI::Method)
  end
  def create_getter_method(name, sig, visibility, loc, comments); end

  # source://rbi//lib/rbi/rewriters/attr_to_methods.rb#110
  sig do
    params(
      name: ::String,
      sig: T.nilable(::RBI::Sig),
      attribute_type: T.nilable(T.any(::RBI::Type, ::String)),
      visibility: ::RBI::Visibility,
      loc: T.nilable(::RBI::Loc),
      comments: T::Array[::RBI::Comment]
    ).returns(::RBI::Method)
  end
  def create_setter_method(name, sig, attribute_type, visibility, loc, comments); end

  # @raise [UnexpectedMultipleSigsError]
  #
  # source://rbi//lib/rbi/rewriters/attr_to_methods.rb#66
  sig(:final) { returns([T.nilable(::RBI::Sig), T.nilable(T.any(::RBI::Type, ::String))]) }
  def parse_sig; end
end

# source://rbi//lib/rbi/model.rb#387
class RBI::AttrAccessor < ::RBI::Attr
  # source://rbi//lib/rbi/model.rb#401
  sig do
    params(
      name: ::Symbol,
      names: ::Symbol,
      visibility: ::RBI::Visibility,
      sigs: T::Array[::RBI::Sig],
      loc: T.nilable(::RBI::Loc),
      comments: T::Array[::RBI::Comment],
      block: T.nilable(T.proc.params(node: ::RBI::AttrAccessor).void)
    ).void
  end
  def initialize(name, *names, visibility: T.unsafe(nil), sigs: T.unsafe(nil), loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#460
  sig { override.params(other: ::RBI::Node).returns(T::Boolean) }
  def compatible_with?(other); end

  # source://rbi//lib/rbi/rewriters/attr_to_methods.rb#140
  sig { override.returns(T::Array[::RBI::Method]) }
  def convert_to_methods; end

  # source://rbi//lib/rbi/model.rb#407
  sig { override.returns(T::Array[::String]) }
  def fully_qualified_names; end

  # source://rbi//lib/rbi/model.rb#413
  sig { override.returns(::String) }
  def to_s; end
end

# source://rbi//lib/rbi/model.rb#419
class RBI::AttrReader < ::RBI::Attr
  # source://rbi//lib/rbi/model.rb#433
  sig do
    params(
      name: ::Symbol,
      names: ::Symbol,
      visibility: ::RBI::Visibility,
      sigs: T::Array[::RBI::Sig],
      loc: T.nilable(::RBI::Loc),
      comments: T::Array[::RBI::Comment],
      block: T.nilable(T.proc.params(node: ::RBI::AttrReader).void)
    ).void
  end
  def initialize(name, *names, visibility: T.unsafe(nil), sigs: T.unsafe(nil), loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#442
  sig { override.params(other: ::RBI::Node).returns(T::Boolean) }
  def compatible_with?(other); end

  # source://rbi//lib/rbi/rewriters/attr_to_methods.rb#154
  sig { override.returns(T::Array[::RBI::Method]) }
  def convert_to_methods; end

  # source://rbi//lib/rbi/model.rb#439
  sig { override.returns(T::Array[::String]) }
  def fully_qualified_names; end

  # source://rbi//lib/rbi/model.rb#445
  sig { override.returns(::String) }
  def to_s; end
end

# source://rbi//lib/rbi/model.rb#451
class RBI::AttrWriter < ::RBI::Attr
  # source://rbi//lib/rbi/model.rb#465
  sig do
    params(
      name: ::Symbol,
      names: ::Symbol,
      visibility: ::RBI::Visibility,
      sigs: T::Array[::RBI::Sig],
      loc: T.nilable(::RBI::Loc),
      comments: T::Array[::RBI::Comment],
      block: T.nilable(T.proc.params(node: ::RBI::AttrWriter).void)
    ).void
  end
  def initialize(name, *names, visibility: T.unsafe(nil), sigs: T.unsafe(nil), loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#451
  sig { override.params(other: ::RBI::Node).returns(T::Boolean) }
  def compatible_with?(other); end

  # source://rbi//lib/rbi/rewriters/attr_to_methods.rb#163
  sig { override.returns(T::Array[::RBI::Method]) }
  def convert_to_methods; end

  # source://rbi//lib/rbi/model.rb#471
  sig { override.returns(T::Array[::String]) }
  def fully_qualified_names; end

  # source://rbi//lib/rbi/model.rb#477
  sig { override.returns(::String) }
  def to_s; end
end

# An arbitrary blank line that can be added both in trees and comments
#
# source://rbi//lib/rbi/model.rb#76
class RBI::BlankLine < ::RBI::Comment
  # source://rbi//lib/rbi/model.rb#80
  sig { params(loc: T.nilable(::RBI::Loc)).void }
  def initialize(loc: T.unsafe(nil)); end
end

# source://rbi//lib/rbi/model.rb#816
class RBI::BlockParam < ::RBI::Param
  # source://rbi//lib/rbi/model.rb#827
  sig do
    params(
      name: ::String,
      loc: T.nilable(::RBI::Loc),
      comments: T::Array[::RBI::Comment],
      block: T.nilable(T.proc.params(node: ::RBI::BlockParam).void)
    ).void
  end
  def initialize(name, loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end

  # source://rbi//lib/rbi/model.rb#838
  sig { params(other: T.nilable(::Object)).returns(T::Boolean) }
  def ==(other); end

  # source://rbi//lib/rbi/model.rb#833
  sig { override.returns(::String) }
  def to_s; end
end

# source://rbi//lib/rbi/model.rb#220
class RBI::Class < ::RBI::Scope
  # source://rbi//lib/rbi/model.rb#238
  sig do
    params(
      name: ::String,
      superclass_name: T.nilable(::String),
      loc: T.nilable(::RBI::Loc),
      comments: T::Array[::RBI::Comment],
      block: T.nilable(T.proc.params(node: ::RBI::Class).void)
    ).void
  end
  def initialize(name, superclass_name: T.unsafe(nil), loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#384
  sig { override.params(other: ::RBI::Node).returns(T::Boolean) }
  def compatible_with?(other); end

  # source://rbi//lib/rbi/model.rb#246
  sig { override.returns(::String) }
  def fully_qualified_name; end

  # source://rbi//lib/rbi/model.rb#224
  sig { returns(::String) }
  def name; end

  # @return [String]
  #
  # source://rbi//lib/rbi/model.rb#224
  def name=(_arg0); end

  # source://rbi//lib/rbi/model.rb#227
  sig { returns(T.nilable(::String)) }
  def superclass_name; end

  # @return [String, nil]
  #
  # source://rbi//lib/rbi/model.rb#227
  def superclass_name=(_arg0); end
end

# source://rbi//lib/rbi/model.rb#55
class RBI::Comment < ::RBI::Node
  # source://rbi//lib/rbi/model.rb#62
  sig { params(text: ::String, loc: T.nilable(::RBI::Loc)).void }
  def initialize(text, loc: T.unsafe(nil)); end

  # source://rbi//lib/rbi/model.rb#68
  sig { params(other: ::Object).returns(T::Boolean) }
  def ==(other); end

  # source://rbi//lib/rbi/model.rb#59
  sig { returns(::String) }
  def text; end

  # @return [String]
  #
  # source://rbi//lib/rbi/model.rb#59
  def text=(_arg0); end
end

# A tree showing incompatibles nodes
#
# Is rendered as a merge conflict between `left` and` right`:
# ~~~rb
# class Foo
#   <<<<<<< left
#   def m1; end
#   def m2(a); end
#   =======
#   def m1(a); end
#   def m2; end
#   >>>>>>> right
# end
# ~~~
#
# source://rbi//lib/rbi/rewriters/merge_trees.rb#583
class RBI::ConflictTree < ::RBI::Tree
  # source://rbi//lib/rbi/rewriters/merge_trees.rb#593
  sig { params(left_name: ::String, right_name: ::String).void }
  def initialize(left_name: T.unsafe(nil), right_name: T.unsafe(nil)); end

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#587
  sig { returns(::RBI::Tree) }
  def left; end

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#590
  sig { returns(::String) }
  def left_name; end

  # @return [Tree]
  #
  # source://rbi//lib/rbi/rewriters/merge_trees.rb#587
  def right; end

  # @return [String]
  #
  # source://rbi//lib/rbi/rewriters/merge_trees.rb#590
  def right_name; end
end

# Consts
#
# source://rbi//lib/rbi/model.rb#314
class RBI::Const < ::RBI::NodeWithComments
  include ::RBI::Indexable

  # source://rbi//lib/rbi/model.rb#329
  sig do
    params(
      name: ::String,
      value: ::String,
      loc: T.nilable(::RBI::Loc),
      comments: T::Array[::RBI::Comment],
      block: T.nilable(T.proc.params(node: ::RBI::Const).void)
    ).void
  end
  def initialize(name, value, loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#411
  sig { override.params(other: ::RBI::Node).returns(T::Boolean) }
  def compatible_with?(other); end

  # source://rbi//lib/rbi/model.rb#337
  sig { returns(::String) }
  def fully_qualified_name; end

  # source://rbi//lib/rbi/index.rb#103
  sig { override.returns(T::Array[::String]) }
  def index_ids; end

  # source://rbi//lib/rbi/model.rb#318
  sig { returns(::String) }
  def name; end

  # source://rbi//lib/rbi/model.rb#344
  sig { override.returns(::String) }
  def to_s; end

  # @return [String]
  #
  # source://rbi//lib/rbi/model.rb#318
  def value; end
end

# source://rbi//lib/rbi/rewriters/merge_trees.rb#351
class RBI::DuplicateNodeError < ::RBI::Error; end

# source://rbi//lib/rbi.rb#8
class RBI::Error < ::StandardError; end

# source://rbi//lib/rbi/model.rb#891
class RBI::Extend < ::RBI::Mixin
  include ::RBI::Indexable

  # source://rbi//lib/rbi/model.rb#903
  sig do
    params(
      name: ::String,
      names: ::String,
      loc: T.nilable(::RBI::Loc),
      comments: T::Array[::RBI::Comment],
      block: T.nilable(T.proc.params(node: ::RBI::Extend).void)
    ).void
  end
  def initialize(name, *names, loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#510
  sig { override.params(other: ::RBI::Node).returns(T::Boolean) }
  def compatible_with?(other); end

  # source://rbi//lib/rbi/index.rb#143
  sig { override.returns(T::Array[::String]) }
  def index_ids; end

  # source://rbi//lib/rbi/model.rb#909
  sig { override.returns(::String) }
  def to_s; end
end

# source://rbi//lib/rbi/model.rb#139
class RBI::File
  # source://rbi//lib/rbi/model.rb#158
  sig do
    params(
      strictness: T.nilable(::String),
      comments: T::Array[::RBI::Comment],
      block: T.nilable(T.proc.params(file: ::RBI::File).void)
    ).void
  end
  def initialize(strictness: T.unsafe(nil), comments: T.unsafe(nil), &block); end

  # source://rbi//lib/rbi/model.rb#166
  sig { params(node: ::RBI::Node).void }
  def <<(node); end

  # source://rbi//lib/rbi/model.rb#149
  sig { returns(T::Array[::RBI::Comment]) }
  def comments; end

  # @return [Array<Comment>]
  #
  # source://rbi//lib/rbi/model.rb#149
  def comments=(_arg0); end

  # source://rbi//lib/rbi/model.rb#171
  sig { returns(T::Boolean) }
  def empty?; end

  # source://rbi//lib/rbi/printer.rb#743
  sig do
    params(
      out: T.any(::IO, ::StringIO),
      indent: ::Integer,
      print_locs: T::Boolean,
      max_line_length: T.nilable(::Integer)
    ).void
  end
  def print(out: T.unsafe(nil), indent: T.unsafe(nil), print_locs: T.unsafe(nil), max_line_length: T.unsafe(nil)); end

  # source://rbi//lib/rbi/rbs_printer.rb#996
  sig { params(out: T.any(::IO, ::StringIO), indent: ::Integer, print_locs: T::Boolean).void }
  def rbs_print(out: T.unsafe(nil), indent: T.unsafe(nil), print_locs: T.unsafe(nil)); end

  # source://rbi//lib/rbi/rbs_printer.rb#1002
  sig { params(indent: ::Integer, print_locs: T::Boolean).returns(::String) }
  def rbs_string(indent: T.unsafe(nil), print_locs: T.unsafe(nil)); end

  # source://rbi//lib/rbi/model.rb#143
  sig { returns(::RBI::Tree) }
  def root; end

  # @return [Tree]
  #
  # source://rbi//lib/rbi/model.rb#143
  def root=(_arg0); end

  # source://rbi//lib/rbi/model.rb#146
  sig { returns(T.nilable(::String)) }
  def strictness; end

  # @return [String, nil]
  #
  # source://rbi//lib/rbi/model.rb#146
  def strictness=(_arg0); end

  # source://rbi//lib/rbi/printer.rb#749
  sig { params(indent: ::Integer, print_locs: T::Boolean, max_line_length: T.nilable(::Integer)).returns(::String) }
  def string(indent: T.unsafe(nil), print_locs: T.unsafe(nil), max_line_length: T.unsafe(nil)); end
end

# source://rbi//lib/rbi/formatter.rb#5
class RBI::Formatter
  # source://rbi//lib/rbi/formatter.rb#24
  sig do
    params(
      add_sig_templates: T::Boolean,
      group_nodes: T::Boolean,
      max_line_length: T.nilable(::Integer),
      nest_singleton_methods: T::Boolean,
      nest_non_public_members: T::Boolean,
      sort_nodes: T::Boolean
    ).void
  end
  def initialize(add_sig_templates: T.unsafe(nil), group_nodes: T.unsafe(nil), max_line_length: T.unsafe(nil), nest_singleton_methods: T.unsafe(nil), nest_non_public_members: T.unsafe(nil), sort_nodes: T.unsafe(nil)); end

  # source://rbi//lib/rbi/formatter.rb#47
  sig { params(file: ::RBI::File).void }
  def format_file(file); end

  # source://rbi//lib/rbi/formatter.rb#52
  sig { params(tree: ::RBI::Tree).void }
  def format_tree(tree); end

  # source://rbi//lib/rbi/formatter.rb#12
  sig { returns(T.nilable(::Integer)) }
  def max_line_length; end

  # @return [Integer, nil]
  #
  # source://rbi//lib/rbi/formatter.rb#12
  def max_line_length=(_arg0); end

  # source://rbi//lib/rbi/formatter.rb#41
  sig { params(file: ::RBI::File).returns(::String) }
  def print_file(file); end

  # source://rbi//lib/rbi/formatter.rb#9
  sig { params(sort_nodes: T::Boolean).returns(T::Boolean) }
  def sort_nodes=(sort_nodes); end
end

# source://rbi//lib/rbi/rewriters/group_nodes.rb#87
class RBI::Group < ::RBI::Tree
  # source://rbi//lib/rbi/rewriters/group_nodes.rb#94
  sig { params(kind: ::RBI::Group::Kind).void }
  def initialize(kind); end

  # source://rbi//lib/rbi/rewriters/group_nodes.rb#91
  sig { returns(::RBI::Group::Kind) }
  def kind; end
end

# source://rbi//lib/rbi/rewriters/group_nodes.rb#99
class RBI::Group::Kind < ::T::Enum
  enums do
    Attrs = new
    Consts = new
    Helpers = new
    Inits = new
    Methods = new
    MixesInClassMethods = new
    Mixins = new
    RequiredAncestors = new
    Sends = new
    SingletonClasses = new
    TEnums = new
    TStructFields = new
    TypeMembers = new
  end
end

# source://rbi//lib/rbi/rewriters/group_nodes.rb#5
class RBI::GroupNodesError < ::RBI::Error; end

# Sorbet's misc.
#
# source://rbi//lib/rbi/model.rb#1374
class RBI::Helper < ::RBI::NodeWithComments
  include ::RBI::Indexable

  # source://rbi//lib/rbi/model.rb#1388
  sig do
    params(
      name: ::String,
      loc: T.nilable(::RBI::Loc),
      comments: T::Array[::RBI::Comment],
      block: T.nilable(T.proc.params(node: ::RBI::Helper).void)
    ).void
  end
  def initialize(name, loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#528
  sig { override.params(other: ::RBI::Node).returns(T::Boolean) }
  def compatible_with?(other); end

  # source://rbi//lib/rbi/index.rb#173
  sig { override.returns(T::Array[::String]) }
  def index_ids; end

  # source://rbi//lib/rbi/model.rb#1378
  sig { returns(::String) }
  def name; end

  # source://rbi//lib/rbi/model.rb#1395
  sig { override.returns(::String) }
  def to_s; end
end

# source://rbi//lib/rbi/model.rb#868
class RBI::Include < ::RBI::Mixin
  include ::RBI::Indexable

  # source://rbi//lib/rbi/model.rb#880
  sig do
    params(
      name: ::String,
      names: ::String,
      loc: T.nilable(::RBI::Loc),
      comments: T::Array[::RBI::Comment],
      block: T.nilable(T.proc.params(node: ::RBI::Include).void)
    ).void
  end
  def initialize(name, *names, loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#501
  sig { override.params(other: ::RBI::Node).returns(T::Boolean) }
  def compatible_with?(other); end

  # source://rbi//lib/rbi/index.rb#133
  sig { override.returns(T::Array[::String]) }
  def index_ids; end

  # source://rbi//lib/rbi/model.rb#886
  sig { override.returns(::String) }
  def to_s; end
end

# source://rbi//lib/rbi/index.rb#5
class RBI::Index < ::RBI::Visitor
  # source://rbi//lib/rbi/index.rb#21
  sig { void }
  def initialize; end

  # source://rbi//lib/rbi/index.rb#32
  sig { params(id: ::String).returns(T::Array[::RBI::Node]) }
  def [](id); end

  # source://rbi//lib/rbi/index.rb#37
  sig { params(nodes: ::RBI::Node).void }
  def index(*nodes); end

  # source://rbi//lib/rbi/index.rb#27
  sig { returns(T::Array[::String]) }
  def keys; end

  # source://rbi//lib/rbi/index.rb#42
  sig { override.params(node: T.nilable(::RBI::Node)).void }
  def visit(node); end

  private

  # source://rbi//lib/rbi/index.rb#59
  sig { params(node: T.all(::RBI::Indexable, ::RBI::Node)).void }
  def index_node(node); end

  class << self
    # source://rbi//lib/rbi/index.rb#13
    sig { params(node: ::RBI::Node).returns(::RBI::Index) }
    def index(*node); end
  end
end

# A Node that can be referred to by a unique ID inside an index
#
# @abstract Subclasses must implement the `abstract` methods below.
#
# source://rbi//lib/rbi/index.rb#74
module RBI::Indexable
  interface!

  # Unique IDs that refer to this node.
  #
  # Some nodes can have multiple ids, for example an attribute accessor matches the ID of the
  # getter and the setter.
  #
  # @abstract
  #
  # source://rbi//lib/rbi/index.rb#85
  sig { abstract.returns(T::Array[::String]) }
  def index_ids; end
end

# source://rbi//lib/rbi/model.rb#1073
class RBI::KwArg < ::RBI::Arg
  # source://rbi//lib/rbi/model.rb#1086
  sig { params(keyword: ::String, value: ::String, loc: T.nilable(::RBI::Loc)).void }
  def initialize(keyword, value, loc: T.unsafe(nil)); end

  # source://rbi//lib/rbi/model.rb#1092
  sig { params(other: T.nilable(::Object)).returns(T::Boolean) }
  def ==(other); end

  # source://rbi//lib/rbi/model.rb#1077
  sig { returns(::String) }
  def keyword; end

  # source://rbi//lib/rbi/model.rb#1097
  sig { returns(::String) }
  def to_s; end
end

# source://rbi//lib/rbi/model.rb#757
class RBI::KwOptParam < ::RBI::Param
  # source://rbi//lib/rbi/model.rb#772
  sig do
    params(
      name: ::String,
      value: ::String,
      loc: T.nilable(::RBI::Loc),
      comments: T::Array[::RBI::Comment],
      block: T.nilable(T.proc.params(node: ::RBI::KwOptParam).void)
    ).void
  end
  def initialize(name, value, loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end

  # source://rbi//lib/rbi/model.rb#784
  sig { params(other: T.nilable(::Object)).returns(T::Boolean) }
  def ==(other); end

  # source://rbi//lib/rbi/model.rb#779
  sig { override.returns(::String) }
  def to_s; end

  # source://rbi//lib/rbi/model.rb#761
  sig { returns(::String) }
  def value; end
end

# source://rbi//lib/rbi/model.rb#730
class RBI::KwParam < ::RBI::Param
  # source://rbi//lib/rbi/model.rb#741
  sig do
    params(
      name: ::String,
      loc: T.nilable(::RBI::Loc),
      comments: T::Array[::RBI::Comment],
      block: T.nilable(T.proc.params(node: ::RBI::KwParam).void)
    ).void
  end
  def initialize(name, loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end

  # source://rbi//lib/rbi/model.rb#752
  sig { params(other: T.nilable(::Object)).returns(T::Boolean) }
  def ==(other); end

  # source://rbi//lib/rbi/model.rb#747
  sig { override.returns(::String) }
  def to_s; end
end

# source://rbi//lib/rbi/model.rb#789
class RBI::KwRestParam < ::RBI::Param
  # source://rbi//lib/rbi/model.rb#800
  sig do
    params(
      name: ::String,
      loc: T.nilable(::RBI::Loc),
      comments: T::Array[::RBI::Comment],
      block: T.nilable(T.proc.params(node: ::RBI::KwRestParam).void)
    ).void
  end
  def initialize(name, loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end

  # source://rbi//lib/rbi/model.rb#811
  sig { params(other: T.nilable(::Object)).returns(T::Boolean) }
  def ==(other); end

  # source://rbi//lib/rbi/model.rb#806
  sig { override.returns(::String) }
  def to_s; end
end

# source://rbi//lib/rbi/loc.rb#5
class RBI::Loc
  # source://rbi//lib/rbi/loc.rb#38
  sig do
    params(
      file: T.nilable(::String),
      begin_line: T.nilable(::Integer),
      end_line: T.nilable(::Integer),
      begin_column: T.nilable(::Integer),
      end_column: T.nilable(::Integer)
    ).void
  end
  def initialize(file: T.unsafe(nil), begin_line: T.unsafe(nil), end_line: T.unsafe(nil), begin_column: T.unsafe(nil), end_column: T.unsafe(nil)); end

  # @return [Integer, nil]
  #
  # source://rbi//lib/rbi/loc.rb#27
  def begin_column; end

  # source://rbi//lib/rbi/loc.rb#27
  sig { returns(T.nilable(::Integer)) }
  def begin_line; end

  # @return [Integer, nil]
  #
  # source://rbi//lib/rbi/loc.rb#27
  def end_column; end

  # @return [Integer, nil]
  #
  # source://rbi//lib/rbi/loc.rb#27
  def end_line; end

  # source://rbi//lib/rbi/loc.rb#24
  sig { returns(T.nilable(::String)) }
  def file; end

  # source://rbi//lib/rbi/loc.rb#56
  sig { returns(T.nilable(::String)) }
  def source; end

  # source://rbi//lib/rbi/loc.rb#47
  sig { returns(::String) }
  def to_s; end

  class << self
    # source://rbi//lib/rbi/loc.rb#12
    sig { params(file: ::String, prism_location: ::Prism::Location).returns(::RBI::Loc) }
    def from_prism(file, prism_location); end
  end
end

# A tree that _might_ contain conflicts
#
# source://rbi//lib/rbi/rewriters/merge_trees.rb#330
class RBI::MergeTree < ::RBI::Tree
  # source://rbi//lib/rbi/rewriters/merge_trees.rb#344
  sig do
    params(
      loc: T.nilable(::RBI::Loc),
      comments: T::Array[::RBI::Comment],
      conflicts: T::Array[::RBI::Rewriters::Merge::Conflict],
      block: T.nilable(T.proc.params(node: ::RBI::Tree).void)
    ).void
  end
  def initialize(loc: T.unsafe(nil), comments: T.unsafe(nil), conflicts: T.unsafe(nil), &block); end

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#334
  sig { returns(T::Array[::RBI::Rewriters::Merge::Conflict]) }
  def conflicts; end
end

# Methods and args
#
# source://rbi//lib/rbi/model.rb#485
class RBI::Method < ::RBI::NodeWithComments
  include ::RBI::Indexable

  # source://rbi//lib/rbi/model.rb#515
  sig do
    params(
      name: ::String,
      params: T::Array[::RBI::Param],
      is_singleton: T::Boolean,
      visibility: ::RBI::Visibility,
      sigs: T::Array[::RBI::Sig],
      loc: T.nilable(::RBI::Loc),
      comments: T::Array[::RBI::Comment],
      block: T.nilable(T.proc.params(node: ::RBI::Method).void)
    ).void
  end
  def initialize(name, params: T.unsafe(nil), is_singleton: T.unsafe(nil), visibility: T.unsafe(nil), sigs: T.unsafe(nil), loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end

  # source://rbi//lib/rbi/model.rb#535
  sig { params(param: ::RBI::Param).void }
  def <<(param); end

  # source://rbi//lib/rbi/model.rb#570
  sig { params(name: ::String).void }
  def add_block_param(name); end

  # source://rbi//lib/rbi/model.rb#560
  sig { params(name: ::String, default_value: ::String).void }
  def add_kw_opt_param(name, default_value); end

  # source://rbi//lib/rbi/model.rb#555
  sig { params(name: ::String).void }
  def add_kw_param(name); end

  # source://rbi//lib/rbi/model.rb#565
  sig { params(name: ::String).void }
  def add_kw_rest_param(name); end

  # source://rbi//lib/rbi/model.rb#545
  sig { params(name: ::String, default_value: ::String).void }
  def add_opt_param(name, default_value); end

  # source://rbi//lib/rbi/model.rb#540
  sig { params(name: ::String).void }
  def add_param(name); end

  # source://rbi//lib/rbi/model.rb#550
  sig { params(name: ::String).void }
  def add_rest_param(name); end

  # source://rbi//lib/rbi/model.rb#587
  sig do
    params(
      params: T::Array[::RBI::SigParam],
      return_type: T.any(::RBI::Type, ::String),
      is_abstract: T::Boolean,
      is_override: T::Boolean,
      is_overridable: T::Boolean,
      is_final: T::Boolean,
      type_params: T::Array[::String],
      checked: T.nilable(::Symbol),
      block: T.proc.params(node: ::RBI::Sig).void
    ).void
  end
  def add_sig(params: T.unsafe(nil), return_type: T.unsafe(nil), is_abstract: T.unsafe(nil), is_override: T.unsafe(nil), is_overridable: T.unsafe(nil), is_final: T.unsafe(nil), type_params: T.unsafe(nil), checked: T.unsafe(nil), &block); end

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#469
  sig { override.params(other: ::RBI::Node).returns(T::Boolean) }
  def compatible_with?(other); end

  # source://rbi//lib/rbi/model.rb#613
  sig { returns(::String) }
  def fully_qualified_name; end

  # source://rbi//lib/rbi/index.rb#123
  sig { override.returns(T::Array[::String]) }
  def index_ids; end

  # source://rbi//lib/rbi/model.rb#495
  sig { returns(T::Boolean) }
  def is_singleton; end

  # @return [Boolean]
  #
  # source://rbi//lib/rbi/model.rb#495
  def is_singleton=(_arg0); end

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#478
  sig { override.params(other: ::RBI::Node).void }
  def merge_with(other); end

  # source://rbi//lib/rbi/model.rb#489
  sig { returns(::String) }
  def name; end

  # @return [String]
  #
  # source://rbi//lib/rbi/model.rb#489
  def name=(_arg0); end

  # source://rbi//lib/rbi/model.rb#492
  sig { returns(T::Array[::RBI::Param]) }
  def params; end

  # source://rbi//lib/rbi/model.rb#501
  sig { returns(T::Array[::RBI::Sig]) }
  def sigs; end

  # @return [Array<Sig>]
  #
  # source://rbi//lib/rbi/model.rb#501
  def sigs=(_arg0); end

  # source://rbi//lib/rbi/model.rb#622
  sig { override.returns(::String) }
  def to_s; end

  # source://rbi//lib/rbi/model.rb#498
  sig { returns(::RBI::Visibility) }
  def visibility; end

  # @return [Visibility]
  #
  # source://rbi//lib/rbi/model.rb#498
  def visibility=(_arg0); end
end

# source://rbi//lib/rbi/model.rb#1435
class RBI::MixesInClassMethods < ::RBI::Mixin
  include ::RBI::Indexable

  # source://rbi//lib/rbi/model.rb#1447
  sig do
    params(
      name: ::String,
      names: ::String,
      loc: T.nilable(::RBI::Loc),
      comments: T::Array[::RBI::Comment],
      block: T.nilable(T.proc.params(node: ::RBI::MixesInClassMethods).void)
    ).void
  end
  def initialize(name, *names, loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#519
  sig { override.params(other: ::RBI::Node).returns(T::Boolean) }
  def compatible_with?(other); end

  # source://rbi//lib/rbi/index.rb#153
  sig { override.returns(T::Array[::String]) }
  def index_ids; end

  # source://rbi//lib/rbi/model.rb#1453
  sig { override.returns(::String) }
  def to_s; end
end

# Mixins
#
# @abstract It cannot be directly instantiated. Subclasses must implement the `abstract` methods below.
#
# source://rbi//lib/rbi/model.rb#845
class RBI::Mixin < ::RBI::NodeWithComments
  abstract!

  # source://rbi//lib/rbi/model.rb#862
  sig do
    params(
      name: ::String,
      names: T::Array[::String],
      loc: T.nilable(::RBI::Loc),
      comments: T::Array[::RBI::Comment]
    ).void
  end
  def initialize(name, names, loc: T.unsafe(nil), comments: T.unsafe(nil)); end

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#492
  sig { override.params(other: ::RBI::Node).returns(T::Boolean) }
  def compatible_with?(other); end

  # source://rbi//lib/rbi/model.rb#852
  sig { returns(T::Array[::String]) }
  def names; end
end

# source://rbi//lib/rbi/model.rb#192
class RBI::Module < ::RBI::Scope
  # source://rbi//lib/rbi/model.rb#206
  sig do
    params(
      name: ::String,
      loc: T.nilable(::RBI::Loc),
      comments: T::Array[::RBI::Comment],
      block: T.nilable(T.proc.params(node: ::RBI::Module).void)
    ).void
  end
  def initialize(name, loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#393
  sig { override.params(other: ::RBI::Node).returns(T::Boolean) }
  def compatible_with?(other); end

  # source://rbi//lib/rbi/model.rb#213
  sig { override.returns(::String) }
  def fully_qualified_name; end

  # source://rbi//lib/rbi/model.rb#196
  sig { returns(::String) }
  def name; end

  # @return [String]
  #
  # source://rbi//lib/rbi/model.rb#196
  def name=(_arg0); end
end

# @abstract It cannot be directly instantiated. Subclasses must implement the `abstract` methods below.
#
# source://rbi//lib/rbi/model.rb#7
class RBI::Node
  abstract!

  # source://rbi//lib/rbi/model.rb#20
  sig { params(loc: T.nilable(::RBI::Loc)).void }
  def initialize(loc: T.unsafe(nil)); end

  # Can `self` and `_other` be merged into a single definition?
  #
  # source://rbi//lib/rbi/rewriters/merge_trees.rb#287
  sig { params(_other: ::RBI::Node).returns(T::Boolean) }
  def compatible_with?(_other); end

  # source://rbi//lib/rbi/model.rb#26
  sig { void }
  def detach; end

  # source://rbi//lib/rbi/model.rb#17
  sig { returns(T.nilable(::RBI::Loc)) }
  def loc; end

  # @return [Loc, nil]
  #
  # source://rbi//lib/rbi/model.rb#17
  def loc=(_arg0); end

  # Merge `self` and `other` into a single definition
  #
  # source://rbi//lib/rbi/rewriters/merge_trees.rb#293
  sig { params(other: ::RBI::Node).void }
  def merge_with(other); end

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#296
  sig { returns(T.nilable(::RBI::ConflictTree)) }
  def parent_conflict_tree; end

  # source://rbi//lib/rbi/model.rb#48
  sig { returns(T.nilable(::RBI::Scope)) }
  def parent_scope; end

  # source://rbi//lib/rbi/model.rb#14
  sig { returns(T.nilable(::RBI::Tree)) }
  def parent_tree; end

  # @return [Tree, nil]
  #
  # source://rbi//lib/rbi/model.rb#14
  def parent_tree=(_arg0); end

  # source://rbi//lib/rbi/printer.rb#767
  sig do
    params(
      out: T.any(::IO, ::StringIO),
      indent: ::Integer,
      print_locs: T::Boolean,
      max_line_length: T.nilable(::Integer)
    ).void
  end
  def print(out: T.unsafe(nil), indent: T.unsafe(nil), print_locs: T.unsafe(nil), max_line_length: T.unsafe(nil)); end

  # source://rbi//lib/rbi/rbs_printer.rb#1013
  sig { params(out: T.any(::IO, ::StringIO), indent: ::Integer, print_locs: T::Boolean).void }
  def rbs_print(out: T.unsafe(nil), indent: T.unsafe(nil), print_locs: T.unsafe(nil)); end

  # source://rbi//lib/rbi/rbs_printer.rb#1019
  sig { params(indent: ::Integer, print_locs: T::Boolean).returns(::String) }
  def rbs_string(indent: T.unsafe(nil), print_locs: T.unsafe(nil)); end

  # @raise [ReplaceNodeError]
  #
  # source://rbi//lib/rbi/model.rb#35
  sig { params(node: ::RBI::Node).void }
  def replace(node); end

  # source://rbi//lib/rbi/rewriters/filter_versions.rb#94
  sig { params(version: ::Gem::Version).returns(T::Boolean) }
  def satisfies_version?(version); end

  # source://rbi//lib/rbi/printer.rb#773
  sig { params(indent: ::Integer, print_locs: T::Boolean, max_line_length: T.nilable(::Integer)).returns(::String) }
  def string(indent: T.unsafe(nil), print_locs: T.unsafe(nil), max_line_length: T.unsafe(nil)); end
end

# @abstract It cannot be directly instantiated. Subclasses must implement the `abstract` methods below.
#
# source://rbi//lib/rbi/model.rb#85
class RBI::NodeWithComments < ::RBI::Node
  abstract!

  # source://rbi//lib/rbi/model.rb#95
  sig { params(loc: T.nilable(::RBI::Loc), comments: T::Array[::RBI::Comment]).void }
  def initialize(loc: T.unsafe(nil), comments: T.unsafe(nil)); end

  # source://rbi//lib/rbi/model.rb#101
  sig { returns(T::Array[::String]) }
  def annotations; end

  # source://rbi//lib/rbi/model.rb#92
  sig { returns(T::Array[::RBI::Comment]) }
  def comments; end

  # @return [Array<Comment>]
  #
  # source://rbi//lib/rbi/model.rb#92
  def comments=(_arg0); end

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#311
  sig { override.params(other: ::RBI::Node).void }
  def merge_with(other); end

  # source://rbi//lib/rbi/rewriters/filter_versions.rb#104
  sig { returns(T::Array[::Gem::Requirement]) }
  def version_requirements; end
end

# source://rbi//lib/rbi/model.rb#676
class RBI::OptParam < ::RBI::Param
  # source://rbi//lib/rbi/model.rb#691
  sig do
    params(
      name: ::String,
      value: ::String,
      loc: T.nilable(::RBI::Loc),
      comments: T::Array[::RBI::Comment],
      block: T.nilable(T.proc.params(node: ::RBI::OptParam).void)
    ).void
  end
  def initialize(name, value, loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end

  # source://rbi//lib/rbi/model.rb#698
  sig { params(other: T.nilable(::Object)).returns(T::Boolean) }
  def ==(other); end

  # source://rbi//lib/rbi/model.rb#680
  sig { returns(::String) }
  def value; end
end

# @abstract It cannot be directly instantiated. Subclasses must implement the `abstract` methods below.
#
# source://rbi//lib/rbi/model.rb#627
class RBI::Param < ::RBI::NodeWithComments
  abstract!

  # source://rbi//lib/rbi/model.rb#643
  sig { params(name: ::String, loc: T.nilable(::RBI::Loc), comments: T::Array[::RBI::Comment]).void }
  def initialize(name, loc: T.unsafe(nil), comments: T.unsafe(nil)); end

  # source://rbi//lib/rbi/model.rb#634
  sig { returns(::String) }
  def name; end

  # source://rbi//lib/rbi/model.rb#649
  sig { override.returns(::String) }
  def to_s; end
end

# source://rbi//lib/rbi/parser.rb#7
class RBI::ParseError < ::RBI::Error
  # source://rbi//lib/rbi/parser.rb#14
  sig { params(message: ::String, location: ::RBI::Loc).void }
  def initialize(message, location); end

  # source://rbi//lib/rbi/parser.rb#11
  sig { returns(::RBI::Loc) }
  def location; end
end

# source://rbi//lib/rbi/parser.rb#53
class RBI::Parser
  # source://rbi//lib/rbi/parser.rb#88
  sig { params(path: ::String).returns(::RBI::Tree) }
  def parse_file(path); end

  # source://rbi//lib/rbi/parser.rb#83
  sig { params(string: ::String).returns(::RBI::Tree) }
  def parse_string(string); end

  private

  # source://rbi//lib/rbi/parser.rb#95
  sig { params(source: ::String, file: ::String).returns(::RBI::Tree) }
  def parse(source, file:); end

  class << self
    # source://rbi//lib/rbi/parser.rb#65
    sig { params(path: ::String).returns(::RBI::Tree) }
    def parse_file(path); end

    # source://rbi//lib/rbi/parser.rb#70
    sig { params(paths: T::Array[::String]).returns(T::Array[::RBI::Tree]) }
    def parse_files(paths); end

    # source://rbi//lib/rbi/parser.rb#60
    sig { params(string: ::String).returns(::RBI::Tree) }
    def parse_string(string); end

    # source://rbi//lib/rbi/parser.rb#76
    sig { params(strings: T::Array[::String]).returns(T::Array[::RBI::Tree]) }
    def parse_strings(strings); end
  end
end

# source://rbi//lib/rbi/parser.rb#828
class RBI::Parser::SigBuilder < ::RBI::Parser::Visitor
  # source://rbi//lib/rbi/parser.rb#835
  sig { params(content: ::String, file: ::String).void }
  def initialize(content, file:); end

  # source://rbi//lib/rbi/parser.rb#832
  sig { returns(::RBI::Sig) }
  def current; end

  # source://rbi//lib/rbi/parser.rb#887
  sig { override.params(node: ::Prism::AssocNode).void }
  def visit_assoc_node(node); end

  # source://rbi//lib/rbi/parser.rb#842
  sig { override.params(node: ::Prism::CallNode).void }
  def visit_call_node(node); end
end

# source://rbi//lib/rbi/parser.rb#153
class RBI::Parser::TreeBuilder < ::RBI::Parser::Visitor
  # source://rbi//lib/rbi/parser.rb#163
  sig { params(source: ::String, comments: T::Array[::Prism::Comment], file: ::String).void }
  def initialize(source, comments:, file:); end

  # source://rbi//lib/rbi/parser.rb#160
  sig { returns(T.nilable(::Prism::Node)) }
  def last_node; end

  # source://rbi//lib/rbi/parser.rb#157
  sig { returns(::RBI::Tree) }
  def tree; end

  # source://rbi//lib/rbi/parser.rb#324
  sig { params(node: ::Prism::CallNode).void }
  def visit_call_node(node); end

  # source://rbi//lib/rbi/parser.rb#175
  sig { override.params(node: ::Prism::ClassNode).void }
  def visit_class_node(node); end

  # source://rbi//lib/rbi/parser.rb#224
  sig { params(node: T.any(::Prism::ConstantPathWriteNode, ::Prism::ConstantWriteNode)).void }
  def visit_constant_assign(node); end

  # source://rbi//lib/rbi/parser.rb#217
  sig { override.params(node: ::Prism::ConstantPathWriteNode).void }
  def visit_constant_path_write_node(node); end

  # source://rbi//lib/rbi/parser.rb#210
  sig { override.params(node: ::Prism::ConstantWriteNode).void }
  def visit_constant_write_node(node); end

  # source://rbi//lib/rbi/parser.rb#257
  sig { override.params(node: ::Prism::DefNode).void }
  def visit_def_node(node); end

  # source://rbi//lib/rbi/parser.rb#278
  sig { override.params(node: ::Prism::ModuleNode).void }
  def visit_module_node(node); end

  # source://rbi//lib/rbi/parser.rb#296
  sig { override.params(node: ::Prism::ProgramNode).void }
  def visit_program_node(node); end

  # source://rbi//lib/rbi/parser.rb#307
  sig { override.params(node: ::Prism::SingletonClassNode).void }
  def visit_singleton_class_node(node); end

  private

  # Collect all the remaining comments within a node
  #
  # source://rbi//lib/rbi/parser.rb#503
  sig { params(node: ::Prism::Node).void }
  def collect_dangling_comments(node); end

  # Collect all the remaining comments after visiting the tree
  #
  # source://rbi//lib/rbi/parser.rb#521
  sig { void }
  def collect_orphan_comments; end

  # source://rbi//lib/rbi/parser.rb#544
  sig { returns(::RBI::Tree) }
  def current_scope; end

  # source://rbi//lib/rbi/parser.rb#549
  sig { returns(T::Array[::RBI::Sig]) }
  def current_sigs; end

  # source://rbi//lib/rbi/parser.rb#556
  sig { params(sigs: T::Array[::RBI::Sig]).returns(T::Array[::RBI::Comment]) }
  def detach_comments_from_sigs(sigs); end

  # source://rbi//lib/rbi/parser.rb#568
  sig { params(node: ::Prism::Node).returns(T::Array[::RBI::Comment]) }
  def node_comments(node); end

  # source://rbi//lib/rbi/parser.rb#586
  sig { params(node: ::Prism::Comment).returns(::RBI::Comment) }
  def parse_comment(node); end

  # source://rbi//lib/rbi/parser.rb#615
  sig { params(node: T.nilable(::Prism::Node)).returns(T::Array[::RBI::Param]) }
  def parse_params(node); end

  # source://rbi//lib/rbi/parser.rb#591
  sig { params(node: T.nilable(::Prism::Node)).returns(T::Array[::RBI::Arg]) }
  def parse_send_args(node); end

  # source://rbi//lib/rbi/parser.rb#689
  sig { params(node: ::Prism::CallNode).returns(::RBI::Sig) }
  def parse_sig(node); end

  # source://rbi//lib/rbi/parser.rb#698
  sig do
    params(
      node: T.any(::Prism::ConstantPathWriteNode, ::Prism::ConstantWriteNode)
    ).returns(T.nilable(::RBI::Struct))
  end
  def parse_struct(node); end

  # source://rbi//lib/rbi/parser.rb#748
  sig { params(send: ::Prism::CallNode).void }
  def parse_tstruct_field(send); end

  # source://rbi//lib/rbi/parser.rb#785
  sig { params(name: ::String, node: ::Prism::Node).returns(::RBI::Visibility) }
  def parse_visibility(name, node); end

  # source://rbi//lib/rbi/parser.rb#799
  sig { void }
  def separate_header_comments; end

  # source://rbi//lib/rbi/parser.rb#809
  sig { void }
  def set_root_tree_loc; end

  # source://rbi//lib/rbi/parser.rb#823
  sig { params(node: T.nilable(::Prism::Node)).returns(T::Boolean) }
  def type_variable_definition?(node); end
end

# source://rbi//lib/rbi/parser.rb#122
class RBI::Parser::Visitor < ::Prism::Visitor
  # source://rbi//lib/rbi/parser.rb#126
  sig { params(source: ::String, file: ::String).void }
  def initialize(source, file:); end

  private

  # source://rbi//lib/rbi/parser.rb#136
  sig { params(node: ::Prism::Node).returns(::RBI::Loc) }
  def node_loc(node); end

  # source://rbi//lib/rbi/parser.rb#141
  sig { params(node: T.nilable(::Prism::Node)).returns(T.nilable(::String)) }
  def node_string(node); end

  # source://rbi//lib/rbi/parser.rb#148
  sig { params(node: ::Prism::Node).returns(::String) }
  def node_string!(node); end
end

# source://rbi//lib/rbi/printer.rb#7
class RBI::Printer < ::RBI::Visitor
  # source://rbi//lib/rbi/printer.rb#30
  sig do
    params(
      out: T.any(::IO, ::StringIO),
      indent: ::Integer,
      print_locs: T::Boolean,
      max_line_length: T.nilable(::Integer)
    ).void
  end
  def initialize(out: T.unsafe(nil), indent: T.unsafe(nil), print_locs: T.unsafe(nil), max_line_length: T.unsafe(nil)); end

  # source://rbi//lib/rbi/printer.rb#17
  sig { returns(::Integer) }
  def current_indent; end

  # source://rbi//lib/rbi/printer.rb#48
  sig { void }
  def dedent; end

  # @return [Boolean]
  #
  # source://rbi//lib/rbi/printer.rb#11
  def in_visibility_group; end

  # @return [Boolean]
  #
  # source://rbi//lib/rbi/printer.rb#11
  def in_visibility_group=(_arg0); end

  # Printing
  #
  # source://rbi//lib/rbi/printer.rb#43
  sig { void }
  def indent; end

  # source://rbi//lib/rbi/printer.rb#20
  sig { returns(T.nilable(::Integer)) }
  def max_line_length; end

  # source://rbi//lib/rbi/printer.rb#14
  sig { returns(T.nilable(::RBI::Node)) }
  def previous_node; end

  # Print a string without indentation nor `\n` at the end.
  #
  # source://rbi//lib/rbi/printer.rb#54
  sig { params(string: ::String).void }
  def print(string); end

  # source://rbi//lib/rbi/printer.rb#11
  sig { returns(T::Boolean) }
  def print_locs; end

  # @return [Boolean]
  #
  # source://rbi//lib/rbi/printer.rb#11
  def print_locs=(_arg0); end

  # Print a string with indentation and `\n` at the end.
  #
  # source://rbi//lib/rbi/printer.rb#74
  sig { params(string: ::String).void }
  def printl(string); end

  # Print a string without indentation but with a `\n` at the end.
  #
  # source://rbi//lib/rbi/printer.rb#60
  sig { params(string: T.nilable(::String)).void }
  def printn(string = T.unsafe(nil)); end

  # Print a string with indentation but without a `\n` at the end.
  #
  # source://rbi//lib/rbi/printer.rb#67
  sig { params(string: T.nilable(::String)).void }
  def printt(string = T.unsafe(nil)); end

  # source://rbi//lib/rbi/printer.rb#80
  sig { override.params(nodes: T::Array[::RBI::Node]).void }
  def visit_all(nodes); end

  # source://rbi//lib/rbi/printer.rb#91
  sig { override.params(file: ::RBI::File).void }
  def visit_file(file); end

  private

  # source://rbi//lib/rbi/printer.rb#618
  sig { params(node: ::RBI::Node).returns(T::Boolean) }
  def oneline?(node); end

  # source://rbi//lib/rbi/printer.rb#576
  sig { params(node: ::RBI::Node).void }
  def print_blank_line_before(node); end

  # source://rbi//lib/rbi/printer.rb#586
  sig { params(node: ::RBI::Node).void }
  def print_loc(node); end

  # source://rbi//lib/rbi/printer.rb#592
  sig { params(node: ::RBI::Param, last: T::Boolean).void }
  def print_param_comment_leading_space(node, last:); end

  # source://rbi//lib/rbi/printer.rb#665
  sig { params(node: ::RBI::Sig).void }
  def print_sig_as_block(node); end

  # source://rbi//lib/rbi/printer.rb#640
  sig { params(node: ::RBI::Sig).void }
  def print_sig_as_line(node); end

  # source://rbi//lib/rbi/printer.rb#610
  sig { params(node: ::RBI::SigParam, last: T::Boolean).void }
  def print_sig_param_comment_leading_space(node, last:); end

  # source://rbi//lib/rbi/printer.rb#721
  sig { params(node: ::RBI::Sig).returns(T::Array[::String]) }
  def sig_modifiers(node); end

  # source://rbi//lib/rbi/printer.rb#417
  sig { override.params(node: ::RBI::Arg).void }
  def visit_arg(node); end

  # source://rbi//lib/rbi/printer.rb#237
  sig { params(node: ::RBI::Attr).void }
  def visit_attr(node); end

  # source://rbi//lib/rbi/printer.rb#222
  sig { override.params(node: ::RBI::AttrAccessor).void }
  def visit_attr_accessor(node); end

  # source://rbi//lib/rbi/printer.rb#227
  sig { override.params(node: ::RBI::AttrReader).void }
  def visit_attr_reader(node); end

  # source://rbi//lib/rbi/printer.rb#232
  sig { override.params(node: ::RBI::AttrWriter).void }
  def visit_attr_writer(node); end

  # source://rbi//lib/rbi/printer.rb#126
  sig { override.params(node: ::RBI::BlankLine).void }
  def visit_blank_line(node); end

  # source://rbi//lib/rbi/printer.rb#344
  sig { override.params(node: ::RBI::BlockParam).void }
  def visit_block_param(node); end

  # source://rbi//lib/rbi/printer.rb#143
  sig { override.params(node: ::RBI::Class).void }
  def visit_class(node); end

  # source://rbi//lib/rbi/printer.rb#110
  sig { override.params(node: ::RBI::Comment).void }
  def visit_comment(node); end

  # source://rbi//lib/rbi/printer.rb#553
  sig { override.params(node: ::RBI::ConflictTree).void }
  def visit_conflict_tree(node); end

  # source://rbi//lib/rbi/printer.rb#213
  sig { override.params(node: ::RBI::Const).void }
  def visit_const(node); end

  # source://rbi//lib/rbi/printer.rb#354
  sig { override.params(node: ::RBI::Extend).void }
  def visit_extend(node); end

  # source://rbi//lib/rbi/printer.rb#525
  sig { override.params(node: ::RBI::Group).void }
  def visit_group(node); end

  # source://rbi//lib/rbi/printer.rb#511
  sig { override.params(node: ::RBI::Helper).void }
  def visit_helper(node); end

  # source://rbi//lib/rbi/printer.rb#349
  sig { override.params(node: ::RBI::Include).void }
  def visit_include(node); end

  # source://rbi//lib/rbi/printer.rb#422
  sig { override.params(node: ::RBI::KwArg).void }
  def visit_kw_arg(node); end

  # source://rbi//lib/rbi/printer.rb#334
  sig { override.params(node: ::RBI::KwOptParam).void }
  def visit_kw_opt_param(node); end

  # source://rbi//lib/rbi/printer.rb#329
  sig { override.params(node: ::RBI::KwParam).void }
  def visit_kw_param(node); end

  # source://rbi//lib/rbi/printer.rb#339
  sig { override.params(node: ::RBI::KwRestParam).void }
  def visit_kw_rest_param(node); end

  # source://rbi//lib/rbi/printer.rb#265
  sig { override.params(node: ::RBI::Method).void }
  def visit_method(node); end

  # source://rbi//lib/rbi/printer.rb#520
  sig { override.params(node: ::RBI::MixesInClassMethods).void }
  def visit_mixes_in_class_methods(node); end

  # source://rbi//lib/rbi/printer.rb#359
  sig { params(node: ::RBI::Mixin).void }
  def visit_mixin(node); end

  # source://rbi//lib/rbi/printer.rb#138
  sig { override.params(node: ::RBI::Module).void }
  def visit_module(node); end

  # source://rbi//lib/rbi/printer.rb#319
  sig { override.params(node: ::RBI::OptParam).void }
  def visit_opt_param(node); end

  # source://rbi//lib/rbi/printer.rb#386
  sig { override.params(node: ::RBI::Private).void }
  def visit_private(node); end

  # source://rbi//lib/rbi/printer.rb#381
  sig { override.params(node: ::RBI::Protected).void }
  def visit_protected(node); end

  # source://rbi//lib/rbi/printer.rb#376
  sig { override.params(node: ::RBI::Public).void }
  def visit_public(node); end

  # source://rbi//lib/rbi/printer.rb#314
  sig { override.params(node: ::RBI::ReqParam).void }
  def visit_req_param(node); end

  # source://rbi//lib/rbi/printer.rb#544
  sig { override.params(node: ::RBI::RequiresAncestor).void }
  def visit_requires_ancestor(node); end

  # source://rbi//lib/rbi/printer.rb#324
  sig { override.params(node: ::RBI::RestParam).void }
  def visit_rest_param(node); end

  # source://rbi//lib/rbi/printer.rb#158
  sig { params(node: ::RBI::Scope).void }
  def visit_scope(node); end

  # source://rbi//lib/rbi/printer.rb#203
  sig { params(node: ::RBI::Scope).void }
  def visit_scope_body(node); end

  # source://rbi//lib/rbi/printer.rb#562
  sig { override.params(node: ::RBI::ScopeConflict).void }
  def visit_scope_conflict(node); end

  # source://rbi//lib/rbi/printer.rb#168
  sig { params(node: ::RBI::Scope).void }
  def visit_scope_header(node); end

  # source://rbi//lib/rbi/printer.rb#400
  sig { override.params(node: ::RBI::Send).void }
  def visit_send(node); end

  # source://rbi//lib/rbi/printer.rb#427
  sig { override.params(node: ::RBI::Sig).void }
  def visit_sig(node); end

  # source://rbi//lib/rbi/printer.rb#447
  sig { override.params(node: ::RBI::SigParam).void }
  def visit_sig_param(node); end

  # source://rbi//lib/rbi/printer.rb#153
  sig { override.params(node: ::RBI::SingletonClass).void }
  def visit_singleton_class(node); end

  # source://rbi//lib/rbi/printer.rb#148
  sig { override.params(node: ::RBI::Struct).void }
  def visit_struct(node); end

  # source://rbi//lib/rbi/printer.rb#467
  sig { params(node: ::RBI::TStructField).void }
  def visit_t_struct_field(node); end

  # source://rbi//lib/rbi/printer.rb#485
  sig { override.params(node: ::RBI::TEnum).void }
  def visit_tenum(node); end

  # source://rbi//lib/rbi/printer.rb#490
  sig { override.params(node: ::RBI::TEnumBlock).void }
  def visit_tenum_block(node); end

  # source://rbi//lib/rbi/printer.rb#131
  sig { override.params(node: ::RBI::Tree).void }
  def visit_tree(node); end

  # source://rbi//lib/rbi/printer.rb#452
  sig { override.params(node: ::RBI::TStruct).void }
  def visit_tstruct(node); end

  # source://rbi//lib/rbi/printer.rb#457
  sig { override.params(node: ::RBI::TStructConst).void }
  def visit_tstruct_const(node); end

  # source://rbi//lib/rbi/printer.rb#462
  sig { override.params(node: ::RBI::TStructProp).void }
  def visit_tstruct_prop(node); end

  # source://rbi//lib/rbi/printer.rb#502
  sig { override.params(node: ::RBI::TypeMember).void }
  def visit_type_member(node); end

  # source://rbi//lib/rbi/printer.rb#391
  sig { params(node: ::RBI::Visibility).void }
  def visit_visibility(node); end

  # source://rbi//lib/rbi/printer.rb#531
  sig { override.params(node: ::RBI::VisibilityGroup).void }
  def visit_visibility_group(node); end
end

# source://rbi//lib/rbi/printer.rb#5
class RBI::PrinterError < ::RBI::Error; end

# source://rbi//lib/rbi/model.rb#986
class RBI::Private < ::RBI::Visibility
  # source://rbi//lib/rbi/model.rb#996
  sig do
    params(
      loc: T.nilable(::RBI::Loc),
      comments: T::Array[::RBI::Comment],
      block: T.nilable(T.proc.params(node: ::RBI::Private).void)
    ).void
  end
  def initialize(loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end
end

# source://rbi//lib/rbi/model.rb#970
class RBI::Protected < ::RBI::Visibility
  # source://rbi//lib/rbi/model.rb#980
  sig do
    params(
      loc: T.nilable(::RBI::Loc),
      comments: T::Array[::RBI::Comment],
      block: T.nilable(T.proc.params(node: ::RBI::Protected).void)
    ).void
  end
  def initialize(loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end
end

# source://rbi//lib/rbi/model.rb#954
class RBI::Public < ::RBI::Visibility
  # source://rbi//lib/rbi/model.rb#964
  sig do
    params(
      loc: T.nilable(::RBI::Loc),
      comments: T::Array[::RBI::Comment],
      block: T.nilable(T.proc.params(node: ::RBI::Public).void)
    ).void
  end
  def initialize(loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end
end

# source://rbi//lib/rbi/rbs_printer.rb#5
class RBI::RBSPrinter < ::RBI::Visitor
  # source://rbi//lib/rbi/rbs_printer.rb#18
  sig { params(out: T.any(::IO, ::StringIO), indent: ::Integer, print_locs: T::Boolean).void }
  def initialize(out: T.unsafe(nil), indent: T.unsafe(nil), print_locs: T.unsafe(nil)); end

  # source://rbi//lib/rbi/rbs_printer.rb#15
  sig { returns(::Integer) }
  def current_indent; end

  # source://rbi//lib/rbi/rbs_printer.rb#35
  sig { void }
  def dedent; end

  # @return [Boolean]
  #
  # source://rbi//lib/rbi/rbs_printer.rb#9
  def in_visibility_group; end

  # @return [Boolean]
  #
  # source://rbi//lib/rbi/rbs_printer.rb#9
  def in_visibility_group=(_arg0); end

  # Printing
  #
  # source://rbi//lib/rbi/rbs_printer.rb#30
  sig { void }
  def indent; end

  # source://rbi//lib/rbi/rbs_printer.rb#12
  sig { returns(T.nilable(::RBI::Node)) }
  def previous_node; end

  # Print a string without indentation nor `\n` at the end.
  #
  # source://rbi//lib/rbi/rbs_printer.rb#41
  sig { params(string: ::String).void }
  def print(string); end

  # source://rbi//lib/rbi/rbs_printer.rb#275
  sig { params(node: ::RBI::Attr, sig: ::RBI::Sig).void }
  def print_attr_sig(node, sig); end

  # source://rbi//lib/rbi/rbs_printer.rb#9
  sig { returns(T::Boolean) }
  def print_locs; end

  # @return [Boolean]
  #
  # source://rbi//lib/rbi/rbs_printer.rb#9
  def print_locs=(_arg0); end

  # source://rbi//lib/rbi/rbs_printer.rb#350
  sig { params(node: ::RBI::Method, sig: ::RBI::Sig).void }
  def print_method_sig(node, sig); end

  # Print a string with indentation and `\n` at the end.
  #
  # source://rbi//lib/rbi/rbs_printer.rb#61
  sig { params(string: ::String).void }
  def printl(string); end

  # Print a string without indentation but with a `\n` at the end.
  #
  # source://rbi//lib/rbi/rbs_printer.rb#47
  sig { params(string: T.nilable(::String)).void }
  def printn(string = T.unsafe(nil)); end

  # Print a string with indentation but without a `\n` at the end.
  #
  # source://rbi//lib/rbi/rbs_printer.rb#54
  sig { params(string: T.nilable(::String)).void }
  def printt(string = T.unsafe(nil)); end

  # source://rbi//lib/rbi/rbs_printer.rb#67
  sig { override.params(nodes: T::Array[::RBI::Node]).void }
  def visit_all(nodes); end

  # source://rbi//lib/rbi/rbs_printer.rb#505
  sig { override.params(node: ::RBI::Arg).void }
  def visit_arg(node); end

  # source://rbi//lib/rbi/rbs_printer.rb#243
  sig { params(node: ::RBI::Attr).void }
  def visit_attr(node); end

  # source://rbi//lib/rbi/rbs_printer.rb#228
  sig { override.params(node: ::RBI::AttrAccessor).void }
  def visit_attr_accessor(node); end

  # source://rbi//lib/rbi/rbs_printer.rb#233
  sig { override.params(node: ::RBI::AttrReader).void }
  def visit_attr_reader(node); end

  # source://rbi//lib/rbi/rbs_printer.rb#238
  sig { override.params(node: ::RBI::AttrWriter).void }
  def visit_attr_writer(node); end

  # source://rbi//lib/rbi/rbs_printer.rb#106
  sig { override.params(node: ::RBI::BlankLine).void }
  def visit_blank_line(node); end

  # source://rbi//lib/rbi/rbs_printer.rb#444
  sig { override.params(node: ::RBI::BlockParam).void }
  def visit_block_param(node); end

  # source://rbi//lib/rbi/rbs_printer.rb#123
  sig { override.params(node: ::RBI::Class).void }
  def visit_class(node); end

  # source://rbi//lib/rbi/rbs_printer.rb#90
  sig { override.params(node: ::RBI::Comment).void }
  def visit_comment(node); end

  # source://rbi//lib/rbi/rbs_printer.rb#625
  sig { override.params(node: ::RBI::ConflictTree).void }
  def visit_conflict_tree(node); end

  # source://rbi//lib/rbi/rbs_printer.rb#213
  sig { override.params(node: ::RBI::Const).void }
  def visit_const(node); end

  # source://rbi//lib/rbi/rbs_printer.rb#454
  sig { override.params(node: ::RBI::Extend).void }
  def visit_extend(node); end

  # source://rbi//lib/rbi/rbs_printer.rb#78
  sig { override.params(file: ::RBI::File).void }
  def visit_file(file); end

  # source://rbi//lib/rbi/rbs_printer.rb#601
  sig { override.params(node: ::RBI::Group).void }
  def visit_group(node); end

  # source://rbi//lib/rbi/rbs_printer.rb#591
  sig { override.params(node: ::RBI::Helper).void }
  def visit_helper(node); end

  # source://rbi//lib/rbi/rbs_printer.rb#449
  sig { override.params(node: ::RBI::Include).void }
  def visit_include(node); end

  # source://rbi//lib/rbi/rbs_printer.rb#510
  sig { override.params(node: ::RBI::KwArg).void }
  def visit_kw_arg(node); end

  # source://rbi//lib/rbi/rbs_printer.rb#434
  sig { override.params(node: ::RBI::KwOptParam).void }
  def visit_kw_opt_param(node); end

  # source://rbi//lib/rbi/rbs_printer.rb#429
  sig { override.params(node: ::RBI::KwParam).void }
  def visit_kw_param(node); end

  # source://rbi//lib/rbi/rbs_printer.rb#439
  sig { override.params(node: ::RBI::KwRestParam).void }
  def visit_kw_rest_param(node); end

  # source://rbi//lib/rbi/rbs_printer.rb#292
  sig { override.params(node: ::RBI::Method).void }
  def visit_method(node); end

  # source://rbi//lib/rbi/rbs_printer.rb#596
  sig { override.params(node: ::RBI::MixesInClassMethods).void }
  def visit_mixes_in_class_methods(node); end

  # source://rbi//lib/rbi/rbs_printer.rb#459
  sig { params(node: ::RBI::Mixin).void }
  def visit_mixin(node); end

  # source://rbi//lib/rbi/rbs_printer.rb#118
  sig { override.params(node: ::RBI::Module).void }
  def visit_module(node); end

  # source://rbi//lib/rbi/rbs_printer.rb#419
  sig { override.params(node: ::RBI::OptParam).void }
  def visit_opt_param(node); end

  # source://rbi//lib/rbi/rbs_printer.rb#486
  sig { override.params(node: ::RBI::Private).void }
  def visit_private(node); end

  # source://rbi//lib/rbi/rbs_printer.rb#481
  sig { override.params(node: ::RBI::Protected).void }
  def visit_protected(node); end

  # source://rbi//lib/rbi/rbs_printer.rb#476
  sig { override.params(node: ::RBI::Public).void }
  def visit_public(node); end

  # source://rbi//lib/rbi/rbs_printer.rb#414
  sig { override.params(node: ::RBI::ReqParam).void }
  def visit_req_param(node); end

  # source://rbi//lib/rbi/rbs_printer.rb#620
  sig { override.params(node: ::RBI::RequiresAncestor).void }
  def visit_requires_ancestor(node); end

  # source://rbi//lib/rbi/rbs_printer.rb#424
  sig { override.params(node: ::RBI::RestParam).void }
  def visit_rest_param(node); end

  # source://rbi//lib/rbi/rbs_printer.rb#138
  sig { params(node: ::RBI::Scope).void }
  def visit_scope(node); end

  # source://rbi//lib/rbi/rbs_printer.rb#201
  sig { params(node: ::RBI::Scope).void }
  def visit_scope_body(node); end

  # source://rbi//lib/rbi/rbs_printer.rb#634
  sig { override.params(node: ::RBI::ScopeConflict).void }
  def visit_scope_conflict(node); end

  # source://rbi//lib/rbi/rbs_printer.rb#148
  sig { params(node: ::RBI::Scope).void }
  def visit_scope_header(node); end

  # source://rbi//lib/rbi/rbs_printer.rb#500
  sig { override.params(node: ::RBI::Send).void }
  def visit_send(node); end

  # source://rbi//lib/rbi/rbs_printer.rb#133
  sig { override.params(node: ::RBI::SingletonClass).void }
  def visit_singleton_class(node); end

  # source://rbi//lib/rbi/rbs_printer.rb#128
  sig { override.params(node: ::RBI::Struct).void }
  def visit_struct(node); end

  # source://rbi//lib/rbi/rbs_printer.rb#563
  sig { override.params(node: ::RBI::TEnum).void }
  def visit_tenum(node); end

  # source://rbi//lib/rbi/rbs_printer.rb#568
  sig { override.params(node: ::RBI::TEnumBlock).void }
  def visit_tenum_block(node); end

  # source://rbi//lib/rbi/rbs_printer.rb#111
  sig { override.params(node: ::RBI::Tree).void }
  def visit_tree(node); end

  # source://rbi//lib/rbi/rbs_printer.rb#515
  sig { override.params(node: ::RBI::TStruct).void }
  def visit_tstruct(node); end

  # source://rbi//lib/rbi/rbs_printer.rb#549
  sig { override.params(node: ::RBI::TStructConst).void }
  def visit_tstruct_const(node); end

  # source://rbi//lib/rbi/rbs_printer.rb#556
  sig { override.params(node: ::RBI::TStructProp).void }
  def visit_tstruct_prop(node); end

  # source://rbi//lib/rbi/rbs_printer.rb#586
  sig { override.params(node: ::RBI::TypeMember).void }
  def visit_type_member(node); end

  # source://rbi//lib/rbi/rbs_printer.rb#491
  sig { params(node: ::RBI::Visibility).void }
  def visit_visibility(node); end

  # source://rbi//lib/rbi/rbs_printer.rb#607
  sig { override.params(node: ::RBI::VisibilityGroup).void }
  def visit_visibility_group(node); end

  private

  # source://rbi//lib/rbi/rbs_printer.rb#782
  sig { params(node: ::RBI::Type).returns(T::Boolean) }
  def bare_nilable_proc?(node); end

  # source://rbi//lib/rbi/rbs_printer.rb#777
  sig { params(node: ::RBI::Type).returns(T::Boolean) }
  def bare_proc?(node); end

  # source://rbi//lib/rbi/rbs_printer.rb#725
  sig { params(node: ::RBI::Node).returns(T::Boolean) }
  def oneline?(node); end

  # Parse a string containing a `T.let(x, X)` and extract the type
  #
  # Returns `nil` is the string is not a `T.let`.
  #
  # source://rbi//lib/rbi/rbs_printer.rb#759
  sig { params(code: T.nilable(::String)).returns(T.nilable(::String)) }
  def parse_t_let(code); end

  # source://rbi//lib/rbi/rbs_printer.rb#747
  sig { params(type: T.any(::RBI::Type, ::String)).returns(::RBI::Type) }
  def parse_type(type); end

  # source://rbi//lib/rbi/rbs_printer.rb#650
  sig { params(node: ::RBI::Node).void }
  def print_blank_line_before(node); end

  # source://rbi//lib/rbi/rbs_printer.rb#669
  sig { params(node: ::RBI::Node).void }
  def print_loc(node); end

  # source://rbi//lib/rbi/rbs_printer.rb#699
  sig { params(node: ::RBI::Param, last: T::Boolean).void }
  def print_param_comment_leading_space(node, last:); end

  # source://rbi//lib/rbi/rbs_printer.rb#675
  sig { params(node: ::RBI::Method, param: ::RBI::SigParam).void }
  def print_sig_param(node, param); end

  # source://rbi//lib/rbi/rbs_printer.rb#717
  sig { params(node: ::RBI::SigParam, last: T::Boolean).void }
  def print_sig_param_comment_leading_space(node, last:); end
end

# source://rbi//lib/rbi/rbs_printer.rb#6
class RBI::RBSPrinter::Error < ::RBI::Error; end

# source://rbi//lib/rbi/model.rb#5
class RBI::ReplaceNodeError < ::RBI::Error; end

# source://rbi//lib/rbi/model.rb#654
class RBI::ReqParam < ::RBI::Param
  # source://rbi//lib/rbi/model.rb#665
  sig do
    params(
      name: ::String,
      loc: T.nilable(::RBI::Loc),
      comments: T::Array[::RBI::Comment],
      block: T.nilable(T.proc.params(node: ::RBI::ReqParam).void)
    ).void
  end
  def initialize(name, loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end

  # source://rbi//lib/rbi/model.rb#671
  sig { params(other: T.nilable(::Object)).returns(T::Boolean) }
  def ==(other); end
end

# source://rbi//lib/rbi/model.rb#1458
class RBI::RequiresAncestor < ::RBI::NodeWithComments
  include ::RBI::Indexable

  # source://rbi//lib/rbi/model.rb#1471
  sig { params(name: ::String, loc: T.nilable(::RBI::Loc), comments: T::Array[::RBI::Comment]).void }
  def initialize(name, loc: T.unsafe(nil), comments: T.unsafe(nil)); end

  # source://rbi//lib/rbi/index.rb#163
  sig { override.returns(T::Array[::String]) }
  def index_ids; end

  # source://rbi//lib/rbi/model.rb#1462
  sig { returns(::String) }
  def name; end

  # source://rbi//lib/rbi/model.rb#1477
  sig { override.returns(::String) }
  def to_s; end
end

# source://rbi//lib/rbi/model.rb#703
class RBI::RestParam < ::RBI::Param
  # source://rbi//lib/rbi/model.rb#714
  sig do
    params(
      name: ::String,
      loc: T.nilable(::RBI::Loc),
      comments: T::Array[::RBI::Comment],
      block: T.nilable(T.proc.params(node: ::RBI::RestParam).void)
    ).void
  end
  def initialize(name, loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end

  # source://rbi//lib/rbi/model.rb#725
  sig { params(other: T.nilable(::Object)).returns(T::Boolean) }
  def ==(other); end

  # source://rbi//lib/rbi/model.rb#720
  sig { override.returns(::String) }
  def to_s; end
end

# source://rbi//lib/rbi/rewriters/add_sig_templates.rb#5
module RBI::Rewriters; end

# source://rbi//lib/rbi/rewriters/add_sig_templates.rb#6
class RBI::Rewriters::AddSigTemplates < ::RBI::Visitor
  # source://rbi//lib/rbi/rewriters/add_sig_templates.rb#10
  sig { params(with_todo_comment: T::Boolean).void }
  def initialize(with_todo_comment: T.unsafe(nil)); end

  # source://rbi//lib/rbi/rewriters/add_sig_templates.rb#16
  sig { override.params(node: T.nilable(::RBI::Node)).void }
  def visit(node); end

  private

  # source://rbi//lib/rbi/rewriters/add_sig_templates.rb#30
  sig { params(attr: ::RBI::Attr).void }
  def add_attr_sig(attr); end

  # source://rbi//lib/rbi/rewriters/add_sig_templates.rb#45
  sig { params(method: ::RBI::Method).void }
  def add_method_sig(method); end

  # source://rbi//lib/rbi/rewriters/add_sig_templates.rb#56
  sig { params(node: ::RBI::NodeWithComments).void }
  def add_todo_comment(node); end
end

# source://rbi//lib/rbi/rewriters/annotate.rb#6
class RBI::Rewriters::Annotate < ::RBI::Visitor
  # source://rbi//lib/rbi/rewriters/annotate.rb#10
  sig { params(annotation: ::String, annotate_scopes: T::Boolean, annotate_properties: T::Boolean).void }
  def initialize(annotation, annotate_scopes: T.unsafe(nil), annotate_properties: T.unsafe(nil)); end

  # source://rbi//lib/rbi/rewriters/annotate.rb#18
  sig { override.params(node: T.nilable(::RBI::Node)).void }
  def visit(node); end

  private

  # source://rbi//lib/rbi/rewriters/annotate.rb#31
  sig { params(node: ::RBI::NodeWithComments).void }
  def annotate_node(node); end

  # source://rbi//lib/rbi/rewriters/annotate.rb#38
  sig { params(node: ::RBI::Node).returns(T::Boolean) }
  def root?(node); end
end

# source://rbi//lib/rbi/rewriters/attr_to_methods.rb#22
class RBI::Rewriters::AttrToMethods < ::RBI::Visitor
  # source://rbi//lib/rbi/rewriters/attr_to_methods.rb#26
  sig { override.params(node: T.nilable(::RBI::Node)).void }
  def visit(node); end

  private

  # @raise [ReplaceNodeError]
  #
  # source://rbi//lib/rbi/rewriters/attr_to_methods.rb#39
  sig { params(node: ::RBI::Node, with: T::Array[::RBI::Node]).void }
  def replace(node, with:); end
end

# source://rbi//lib/rbi/rewriters/deannotate.rb#6
class RBI::Rewriters::Deannotate < ::RBI::Visitor
  # source://rbi//lib/rbi/rewriters/deannotate.rb#10
  sig { params(annotation: ::String).void }
  def initialize(annotation); end

  # source://rbi//lib/rbi/rewriters/deannotate.rb#16
  sig { override.params(node: T.nilable(::RBI::Node)).void }
  def visit(node); end

  private

  # source://rbi//lib/rbi/rewriters/deannotate.rb#27
  sig { params(node: ::RBI::NodeWithComments).void }
  def deannotate_node(node); end
end

# Take a gem version and filter out all RBI that is not relevant to that version based on @version annotations
# in comments. As an example:
#
# ~~~rb
# tree = Parser.parse_string(<<~RBI)
#   class Foo
#     # @version > 0.3.0
#     def bar
#     end
#
#     # @version <= 0.3.0
#     def bar(arg1)
#     end
#   end
# RBI
#
# Rewriters::FilterVersions.filter(tree, Gem::Version.new("0.3.1"))
#
# assert_equal(<<~RBI, tree.string)
#   class Foo
#     # @version > 0.3.0
#     def bar
#     end
#   end
# RBI
# ~~~
#
# Supported operators:
# - equals `=`
# - not equals `!=`
# - greater than `>`
# - greater than or equal to `>=`
# - less than `<`
# - less than or equal to `<=`
# - pessimistic or twiddle-wakka`~>`
#
# And/or logic:
# - "And" logic: put multiple versions on the same line
#   - e.g. `@version > 0.3.0, <1.0.0` means version must be greater than 0.3.0 AND less than 1.0.0
# - "Or" logic: put multiple versions on subsequent lines
#   - e.g. the following means version must be less than 0.3.0 OR greater than 1.0.0
#       ```
#       # @version < 0.3.0
#       # @version > 1.0.0
#       ```
# Prerelease versions:
# - Prerelease versions are considered less than their non-prerelease counterparts
#   - e.g. `0.4.0-prerelease` is less than `0.4.0`
#
# RBI with no versions:
# - RBI with no version annotations are automatically counted towards ALL versions
#
# source://rbi//lib/rbi/rewriters/filter_versions.rb#57
class RBI::Rewriters::FilterVersions < ::RBI::Visitor
  # source://rbi//lib/rbi/rewriters/filter_versions.rb#73
  sig { params(version: ::Gem::Version).void }
  def initialize(version); end

  # source://rbi//lib/rbi/rewriters/filter_versions.rb#79
  sig { override.params(node: T.nilable(::RBI::Node)).void }
  def visit(node); end

  class << self
    # source://rbi//lib/rbi/rewriters/filter_versions.rb#66
    sig { params(tree: ::RBI::Tree, version: ::Gem::Version).void }
    def filter(tree, version); end
  end
end

# source://rbi//lib/rbi/rewriters/filter_versions.rb#60
RBI::Rewriters::FilterVersions::VERSION_PREFIX = T.let(T.unsafe(nil), String)

# Rewrite non-singleton methods inside singleton classes to singleton methods
#
# Example:
# ~~~rb
# class << self
#  def m1; end
#  def self.m2; end
#
#  class << self
#    def m3; end
#  end
# end
# ~~~
#
# will be rewritten to:
#
# ~~~rb
# def self.m1; end
#
# class << self
#   def self.m2; end
#   def self.m3; end
# end
# ~~~
#
# source://rbi//lib/rbi/rewriters/flatten_singleton_methods.rb#30
class RBI::Rewriters::FlattenSingletonMethods < ::RBI::Visitor
  # source://rbi//lib/rbi/rewriters/flatten_singleton_methods.rb#34
  sig { override.params(node: T.nilable(::RBI::Node)).void }
  def visit(node); end
end

# Flattens visibility nodes into method nodes
#
# Example:
# ~~~rb
# class A
#   def m1; end
#   private
#   def m2; end
#   def m3; end
# end
# ~~~
#
# will be transformed into:
#
# ~~~rb
# class A
#   def m1; end
#   private def m2; end
#   private def m3; end
# end
# ~~~
#
# source://rbi//lib/rbi/rewriters/flatten_visibilities.rb#27
class RBI::Rewriters::FlattenVisibilities < ::RBI::Visitor
  # source://rbi//lib/rbi/rewriters/flatten_visibilities.rb#31
  sig { void }
  def initialize; end

  # source://rbi//lib/rbi/rewriters/flatten_visibilities.rb#38
  sig { override.params(node: T.nilable(::RBI::Node)).void }
  def visit(node); end
end

# source://rbi//lib/rbi/rewriters/group_nodes.rb#8
class RBI::Rewriters::GroupNodes < ::RBI::Visitor
  # source://rbi//lib/rbi/rewriters/group_nodes.rb#12
  sig { override.params(node: T.nilable(::RBI::Node)).void }
  def visit(node); end

  private

  # source://rbi//lib/rbi/rewriters/group_nodes.rb#36
  sig { params(node: ::RBI::Node).returns(::RBI::Group::Kind) }
  def group_kind(node); end
end

# Merge two RBI trees together
#
# Be this `Tree`:
# ~~~rb
# class Foo
#   attr_accessor :a
#   def m; end
#   C = 10
# end
# ~~~
#
# Merged with this one:
# ~~~rb
# class Foo
#   attr_reader :a
#   def m(x); end
#   C = 10
# end
# ~~~
#
# Compatible definitions are merged together while incompatible definitions are moved into a `ConflictTree`:
# ~~~rb
# class Foo
#   <<<<<<< left
#   attr_accessor :a
#   def m; end
#   =======
#   attr_reader :a
#   def m(x); end
#   >>>>>>> right
#   C = 10
# end
# ~~~
#
# source://rbi//lib/rbi/rewriters/merge_trees.rb#39
class RBI::Rewriters::Merge
  # source://rbi//lib/rbi/rewriters/merge_trees.rb#70
  sig { params(left_name: ::String, right_name: ::String, keep: ::RBI::Rewriters::Merge::Keep).void }
  def initialize(left_name: T.unsafe(nil), right_name: T.unsafe(nil), keep: T.unsafe(nil)); end

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#79
  sig { params(tree: ::RBI::Tree).void }
  def merge(tree); end

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#67
  sig { returns(::RBI::MergeTree) }
  def tree; end

  class << self
    # source://rbi//lib/rbi/rewriters/merge_trees.rb#54
    sig do
      params(
        left: ::RBI::Tree,
        right: ::RBI::Tree,
        left_name: ::String,
        right_name: ::String,
        keep: ::RBI::Rewriters::Merge::Keep
      ).returns(::RBI::MergeTree)
    end
    def merge_trees(left, right, left_name: T.unsafe(nil), right_name: T.unsafe(nil), keep: T.unsafe(nil)); end
  end
end

# Used for logging / error displaying purpose
#
# source://rbi//lib/rbi/rewriters/merge_trees.rb#86
class RBI::Rewriters::Merge::Conflict < ::T::Struct
  const :left, ::RBI::Node
  const :right, ::RBI::Node
  const :left_name, ::String
  const :right_name, ::String

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#95
  sig { returns(::String) }
  def to_s; end

  class << self
    # source://sorbet-runtime/0.5.11592/lib/types/struct.rb#13
    def inherited(s); end
  end
end

# Merge adjacent conflict trees
#
# Transform this:
# ~~~rb
# class Foo
#   <<<<<<< left
#   def m1; end
#   =======
#   def m1(a); end
#   >>>>>>> right
#   <<<<<<< left
#   def m2(a); end
#   =======
#   def m2; end
#   >>>>>>> right
# end
# ~~~
#
# Into this:
# ~~~rb
# class Foo
#   <<<<<<< left
#   def m1; end
#   def m2(a); end
#   =======
#   def m1(a); end
#   def m2; end
#   >>>>>>> right
# end
# ~~~
#
# source://rbi//lib/rbi/rewriters/merge_trees.rb#245
class RBI::Rewriters::Merge::ConflictTreeMerger < ::RBI::Visitor
  # source://rbi//lib/rbi/rewriters/merge_trees.rb#247
  sig { override.params(node: T.nilable(::RBI::Node)).void }
  def visit(node); end

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#252
  sig { override.params(nodes: T::Array[::RBI::Node]).void }
  def visit_all(nodes); end

  private

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#273
  sig { params(left: ::RBI::Tree, right: ::RBI::Tree).void }
  def merge_conflict_trees(left, right); end
end

# source://rbi//lib/rbi/rewriters/merge_trees.rb#42
class RBI::Rewriters::Merge::Keep < ::T::Enum
  enums do
    LEFT = new
    NONE = new
    RIGHT = new
  end
end

# source://rbi//lib/rbi/rewriters/merge_trees.rb#100
class RBI::Rewriters::Merge::TreeMerger < ::RBI::Visitor
  # source://rbi//lib/rbi/rewriters/merge_trees.rb#107
  sig do
    params(
      output: ::RBI::Tree,
      left_name: ::String,
      right_name: ::String,
      keep: ::RBI::Rewriters::Merge::Keep
    ).void
  end
  def initialize(output, left_name: T.unsafe(nil), right_name: T.unsafe(nil), keep: T.unsafe(nil)); end

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#104
  sig { returns(T::Array[::RBI::Rewriters::Merge::Conflict]) }
  def conflicts; end

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#119
  sig { override.params(node: T.nilable(::RBI::Node)).void }
  def visit(node); end

  private

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#168
  sig { returns(::RBI::Tree) }
  def current_scope; end

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#185
  sig { params(left: ::RBI::Scope, right: ::RBI::Scope).void }
  def make_conflict_scope(left, right); end

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#192
  sig { params(left: ::RBI::Node, right: ::RBI::Node).void }
  def make_conflict_tree(left, right); end

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#173
  sig { params(node: ::RBI::Node).returns(T.nilable(::RBI::Node)) }
  def previous_definition(node); end

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#204
  sig { params(left: ::RBI::Scope, right: ::RBI::Scope).returns(::RBI::Scope) }
  def replace_scope_header(left, right); end
end

# source://rbi//lib/rbi/rewriters/nest_non_public_members.rb#6
class RBI::Rewriters::NestNonPublicMembers < ::RBI::Visitor
  # source://rbi//lib/rbi/rewriters/nest_non_public_members.rb#10
  sig { override.params(node: T.nilable(::RBI::Node)).void }
  def visit(node); end
end

# source://rbi//lib/rbi/rewriters/nest_singleton_methods.rb#6
class RBI::Rewriters::NestSingletonMethods < ::RBI::Visitor
  # source://rbi//lib/rbi/rewriters/nest_singleton_methods.rb#10
  sig { override.params(node: T.nilable(::RBI::Node)).void }
  def visit(node); end
end

# This rewriter moves top-level members into a top-level Object class
#
# Example:
# ~~~rb
# def foo; end
# attr_reader :bar
# ~~~
#
# will be rewritten to:
#
# ~~~rb
# class Object
#  def foo; end
#  attr_reader :bar
# end
# ~~~
#
# source://rbi//lib/rbi/rewriters/nest_top_level_members.rb#22
class RBI::Rewriters::NestTopLevelMembers < ::RBI::Visitor
  # source://rbi//lib/rbi/rewriters/nest_top_level_members.rb#26
  sig { void }
  def initialize; end

  # source://rbi//lib/rbi/rewriters/nest_top_level_members.rb#33
  sig { override.params(node: T.nilable(::RBI::Node)).void }
  def visit(node); end
end

# Remove all definitions existing in the index from the current tree
#
# Let's create an `Index` from two different `Tree`s:
# ~~~rb
# tree1 = Parse.parse_string(<<~RBI)
#   class Foo
#     def foo; end
#   end
# RBI
#
# tree2 = Parse.parse_string(<<~RBI)
#   FOO = 10
# RBI
#
# index = Index.index(tree1, tree2)
# ~~~
#
# We can use `RemoveKnownDefinitions` to remove the definitions found in the `index` from the `Tree` to clean:
# ~~~rb
# tree_to_clean = Parser.parse_string(<<~RBI)
#   class Foo
#     def foo; end
#     def bar; end
#   end
#   FOO = 10
#   BAR = 42
# RBI
#
# cleaned_tree, operations = RemoveKnownDefinitions.remove(tree_to_clean, index)
#
# assert_equal(<<~RBI, cleaned_tree)
#   class Foo
#     def bar; end
#   end
#   BAR = 42
# RBI
#
# assert_equal(<<~OPERATIONS, operations.join("\n"))
#   Deleted ::Foo#foo at -:2:2-2-16 (duplicate from -:2:2-2:16)
#   Deleted ::FOO at -:5:0-5:8 (duplicate from -:1:0-1:8)
# OPERATIONS
# ~~~
#
# source://rbi//lib/rbi/rewriters/remove_known_definitions.rb#48
class RBI::Rewriters::RemoveKnownDefinitions < ::RBI::Visitor
  # source://rbi//lib/rbi/rewriters/remove_known_definitions.rb#55
  sig { params(index: ::RBI::Index).void }
  def initialize(index); end

  # source://rbi//lib/rbi/rewriters/remove_known_definitions.rb#52
  sig { returns(T::Array[::RBI::Rewriters::RemoveKnownDefinitions::Operation]) }
  def operations; end

  # source://rbi//lib/rbi/rewriters/remove_known_definitions.rb#83
  sig { override.params(node: T.nilable(::RBI::Node)).void }
  def visit(node); end

  # source://rbi//lib/rbi/rewriters/remove_known_definitions.rb#78
  sig { params(nodes: T::Array[::RBI::Node]).void }
  def visit_all(nodes); end

  private

  # source://rbi//lib/rbi/rewriters/remove_known_definitions.rb#111
  sig { params(node: ::RBI::Node, previous: ::RBI::Node).returns(T::Boolean) }
  def can_delete_node?(node, previous); end

  # source://rbi//lib/rbi/rewriters/remove_known_definitions.rb#129
  sig { params(node: ::RBI::Node, previous: ::RBI::Node).void }
  def delete_node(node, previous); end

  # source://rbi//lib/rbi/rewriters/remove_known_definitions.rb#102
  sig { params(node: ::RBI::Indexable).returns(T.nilable(::RBI::Node)) }
  def previous_definition_for(node); end

  class << self
    # source://rbi//lib/rbi/rewriters/remove_known_definitions.rb#70
    sig do
      params(
        tree: ::RBI::Tree,
        index: ::RBI::Index
      ).returns([::RBI::Tree, T::Array[::RBI::Rewriters::RemoveKnownDefinitions::Operation]])
    end
    def remove(tree, index); end
  end
end

# source://rbi//lib/rbi/rewriters/remove_known_definitions.rb#134
class RBI::Rewriters::RemoveKnownDefinitions::Operation < ::T::Struct
  const :deleted_node, ::RBI::Node
  const :duplicate_of, ::RBI::Node

  # source://rbi//lib/rbi/rewriters/remove_known_definitions.rb#141
  sig { returns(::String) }
  def to_s; end

  class << self
    # source://sorbet-runtime/0.5.11592/lib/types/struct.rb#13
    def inherited(s); end
  end
end

# source://rbi//lib/rbi/rewriters/sort_nodes.rb#6
class RBI::Rewriters::SortNodes < ::RBI::Visitor
  # source://rbi//lib/rbi/rewriters/sort_nodes.rb#10
  sig { override.params(node: T.nilable(::RBI::Node)).void }
  def visit(node); end

  private

  # source://rbi//lib/rbi/rewriters/sort_nodes.rb#73
  sig { params(kind: ::RBI::Group::Kind).returns(::Integer) }
  def group_rank(kind); end

  # source://rbi//lib/rbi/rewriters/sort_nodes.rb#94
  sig { params(node: ::RBI::Node).returns(T.nilable(::String)) }
  def node_name(node); end

  # source://rbi//lib/rbi/rewriters/sort_nodes.rb#45
  sig { params(node: ::RBI::Node).returns(::Integer) }
  def node_rank(node); end

  # source://rbi//lib/rbi/rewriters/sort_nodes.rb#106
  sig { params(node: ::RBI::Node).void }
  def sort_node_names!(node); end
end

# Scopes
#
# @abstract It cannot be directly instantiated. Subclasses must implement the `abstract` methods below.
#
# source://rbi//lib/rbi/model.rb#178
class RBI::Scope < ::RBI::Tree
  include ::RBI::Indexable

  abstract!

  # Duplicate `self` scope without its body
  #
  # source://rbi//lib/rbi/rewriters/merge_trees.rb#358
  sig { returns(T.self_type) }
  def dup_empty; end

  # @abstract
  #
  # source://rbi//lib/rbi/model.rb#184
  sig { abstract.returns(::String) }
  def fully_qualified_name; end

  # source://rbi//lib/rbi/index.rb#93
  sig { override.returns(T::Array[::String]) }
  def index_ids; end

  # source://rbi//lib/rbi/model.rb#187
  sig { override.returns(::String) }
  def to_s; end
end

# A conflict between two scope headers
#
# Is rendered as a merge conflict between `left` and` right` for scope definitions:
# ~~~rb
# <<<<<<< left
# class Foo
# =======
# module Foo
# >>>>>>> right
#   def m1; end
# end
# ~~~
#
# source://rbi//lib/rbi/rewriters/merge_trees.rb#616
class RBI::ScopeConflict < ::RBI::Tree
  # source://rbi//lib/rbi/rewriters/merge_trees.rb#633
  sig { params(left: ::RBI::Scope, right: ::RBI::Scope, left_name: ::String, right_name: ::String).void }
  def initialize(left:, right:, left_name: T.unsafe(nil), right_name: T.unsafe(nil)); end

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#620
  sig { returns(::RBI::Scope) }
  def left; end

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#623
  sig { returns(::String) }
  def left_name; end

  # @return [Scope]
  #
  # source://rbi//lib/rbi/rewriters/merge_trees.rb#620
  def right; end

  # @return [String]
  #
  # source://rbi//lib/rbi/rewriters/merge_trees.rb#623
  def right_name; end
end

# Sends
#
# source://rbi//lib/rbi/model.rb#1004
class RBI::Send < ::RBI::NodeWithComments
  include ::RBI::Indexable

  # source://rbi//lib/rbi/model.rb#1022
  sig do
    params(
      method: ::String,
      args: T::Array[::RBI::Arg],
      loc: T.nilable(::RBI::Loc),
      comments: T::Array[::RBI::Comment],
      block: T.nilable(T.proc.params(node: ::RBI::Send).void)
    ).void
  end
  def initialize(method, args = T.unsafe(nil), loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end

  # source://rbi//lib/rbi/model.rb#1030
  sig { params(arg: ::RBI::Arg).void }
  def <<(arg); end

  # source://rbi//lib/rbi/model.rb#1035
  sig { params(other: T.nilable(::Object)).returns(T::Boolean) }
  def ==(other); end

  # source://rbi//lib/rbi/model.rb#1011
  sig { returns(T::Array[::RBI::Arg]) }
  def args; end

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#537
  sig { override.params(other: ::RBI::Node).returns(T::Boolean) }
  def compatible_with?(other); end

  # source://rbi//lib/rbi/index.rb#193
  sig { override.returns(T::Array[::String]) }
  def index_ids; end

  # source://rbi//lib/rbi/model.rb#1008
  sig { returns(::String) }
  def method; end

  # source://rbi//lib/rbi/model.rb#1040
  sig { returns(::String) }
  def to_s; end
end

# Sorbet's sigs
#
# source://rbi//lib/rbi/model.rb#1104
class RBI::Sig < ::RBI::NodeWithComments
  # source://rbi//lib/rbi/model.rb#1137
  sig do
    params(
      params: T::Array[::RBI::SigParam],
      return_type: T.any(::RBI::Type, ::String),
      is_abstract: T::Boolean,
      is_override: T::Boolean,
      is_overridable: T::Boolean,
      is_final: T::Boolean,
      type_params: T::Array[::String],
      checked: T.nilable(::Symbol),
      loc: T.nilable(::RBI::Loc),
      comments: T::Array[::RBI::Comment],
      block: T.nilable(T.proc.params(node: ::RBI::Sig).void)
    ).void
  end
  def initialize(params: T.unsafe(nil), return_type: T.unsafe(nil), is_abstract: T.unsafe(nil), is_override: T.unsafe(nil), is_overridable: T.unsafe(nil), is_final: T.unsafe(nil), type_params: T.unsafe(nil), checked: T.unsafe(nil), loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end

  # source://rbi//lib/rbi/model.rb#1163
  sig { params(param: ::RBI::SigParam).void }
  def <<(param); end

  # source://rbi//lib/rbi/model.rb#1173
  sig { params(other: ::Object).returns(T::Boolean) }
  def ==(other); end

  # source://rbi//lib/rbi/model.rb#1168
  sig { params(name: ::String, type: T.any(::RBI::Type, ::String)).void }
  def add_param(name, type); end

  # source://rbi//lib/rbi/model.rb#1120
  sig { returns(T.nilable(::Symbol)) }
  def checked; end

  # @return [Symbol, nil]
  #
  # source://rbi//lib/rbi/model.rb#1120
  def checked=(_arg0); end

  # source://rbi//lib/rbi/model.rb#1114
  sig { returns(T::Boolean) }
  def is_abstract; end

  # @return [Boolean]
  #
  # source://rbi//lib/rbi/model.rb#1114
  def is_abstract=(_arg0); end

  # @return [Boolean]
  #
  # source://rbi//lib/rbi/model.rb#1114
  def is_final; end

  # @return [Boolean]
  #
  # source://rbi//lib/rbi/model.rb#1114
  def is_final=(_arg0); end

  # @return [Boolean]
  #
  # source://rbi//lib/rbi/model.rb#1114
  def is_overridable; end

  # @return [Boolean]
  #
  # source://rbi//lib/rbi/model.rb#1114
  def is_overridable=(_arg0); end

  # @return [Boolean]
  #
  # source://rbi//lib/rbi/model.rb#1114
  def is_override; end

  # @return [Boolean]
  #
  # source://rbi//lib/rbi/model.rb#1114
  def is_override=(_arg0); end

  # source://rbi//lib/rbi/model.rb#1108
  sig { returns(T::Array[::RBI::SigParam]) }
  def params; end

  # source://rbi//lib/rbi/model.rb#1111
  sig { returns(T.any(::RBI::Type, ::String)) }
  def return_type; end

  # @return [Type, String]
  #
  # source://rbi//lib/rbi/model.rb#1111
  def return_type=(_arg0); end

  # source://rbi//lib/rbi/model.rb#1117
  sig { returns(T::Array[::String]) }
  def type_params; end
end

# source://rbi//lib/rbi/model.rb#1182
class RBI::SigParam < ::RBI::NodeWithComments
  # source://rbi//lib/rbi/model.rb#1200
  sig do
    params(
      name: ::String,
      type: T.any(::RBI::Type, ::String),
      loc: T.nilable(::RBI::Loc),
      comments: T::Array[::RBI::Comment],
      block: T.nilable(T.proc.params(node: ::RBI::SigParam).void)
    ).void
  end
  def initialize(name, type, loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end

  # source://rbi//lib/rbi/model.rb#1208
  sig { params(other: ::Object).returns(T::Boolean) }
  def ==(other); end

  # source://rbi//lib/rbi/model.rb#1186
  sig { returns(::String) }
  def name; end

  # source://rbi//lib/rbi/model.rb#1189
  sig { returns(T.any(::RBI::Type, ::String)) }
  def type; end
end

# source://rbi//lib/rbi/model.rb#253
class RBI::SingletonClass < ::RBI::Scope
  # source://rbi//lib/rbi/model.rb#263
  sig do
    params(
      loc: T.nilable(::RBI::Loc),
      comments: T::Array[::RBI::Comment],
      block: T.nilable(T.proc.params(node: ::RBI::SingletonClass).void)
    ).void
  end
  def initialize(loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end

  # source://rbi//lib/rbi/model.rb#269
  sig { override.returns(::String) }
  def fully_qualified_name; end
end

# source://rbi//lib/rbi/model.rb#274
class RBI::Struct < ::RBI::Scope
  # source://rbi//lib/rbi/model.rb#296
  sig do
    params(
      name: ::String,
      members: T::Array[::Symbol],
      keyword_init: T::Boolean,
      loc: T.nilable(::RBI::Loc),
      comments: T::Array[::RBI::Comment],
      block: T.nilable(T.proc.params(struct: ::RBI::Struct).void)
    ).void
  end
  def initialize(name, members: T.unsafe(nil), keyword_init: T.unsafe(nil), loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#402
  sig { override.params(other: ::RBI::Node).returns(T::Boolean) }
  def compatible_with?(other); end

  # source://rbi//lib/rbi/model.rb#305
  sig { override.returns(::String) }
  def fully_qualified_name; end

  # source://rbi//lib/rbi/model.rb#284
  sig { returns(T::Boolean) }
  def keyword_init; end

  # @return [Boolean]
  #
  # source://rbi//lib/rbi/model.rb#284
  def keyword_init=(_arg0); end

  # source://rbi//lib/rbi/model.rb#281
  sig { returns(T::Array[::Symbol]) }
  def members; end

  # @return [Array<Symbol>]
  #
  # source://rbi//lib/rbi/model.rb#281
  def members=(_arg0); end

  # source://rbi//lib/rbi/model.rb#278
  sig { returns(::String) }
  def name; end

  # @return [String]
  #
  # source://rbi//lib/rbi/model.rb#278
  def name=(_arg0); end
end

# Sorbet's T::Enum
#
# source://rbi//lib/rbi/model.rb#1329
class RBI::TEnum < ::RBI::Class
  # source://rbi//lib/rbi/model.rb#1340
  sig do
    params(
      name: ::String,
      loc: T.nilable(::RBI::Loc),
      comments: T::Array[::RBI::Comment],
      block: T.nilable(T.proc.params(klass: ::RBI::TEnum).void)
    ).void
  end
  def initialize(name, loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end
end

# source://rbi//lib/rbi/model.rb#1346
class RBI::TEnumBlock < ::RBI::Scope
  # source://rbi//lib/rbi/model.rb#1356
  sig do
    params(
      loc: T.nilable(::RBI::Loc),
      comments: T::Array[::RBI::Comment],
      block: T.nilable(T.proc.params(node: ::RBI::TEnumBlock).void)
    ).void
  end
  def initialize(loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end

  # source://rbi//lib/rbi/model.rb#1362
  sig { override.returns(::String) }
  def fully_qualified_name; end

  # source://rbi//lib/rbi/index.rb#223
  sig { override.returns(T::Array[::String]) }
  def index_ids; end

  # source://rbi//lib/rbi/model.rb#1367
  sig { override.returns(::String) }
  def to_s; end
end

# Sorbet's T::Struct
#
# source://rbi//lib/rbi/model.rb#1215
class RBI::TStruct < ::RBI::Class
  # source://rbi//lib/rbi/model.rb#1226
  sig do
    params(
      name: ::String,
      loc: T.nilable(::RBI::Loc),
      comments: T::Array[::RBI::Comment],
      block: T.nilable(T.proc.params(klass: ::RBI::TStruct).void)
    ).void
  end
  def initialize(name, loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end
end

# source://rbi//lib/rbi/model.rb#1267
class RBI::TStructConst < ::RBI::TStructField
  include ::RBI::Indexable

  # source://rbi//lib/rbi/model.rb#1280
  sig do
    params(
      name: ::String,
      type: T.any(::RBI::Type, ::String),
      default: T.nilable(::String),
      loc: T.nilable(::RBI::Loc),
      comments: T::Array[::RBI::Comment],
      block: T.nilable(T.proc.params(node: ::RBI::TStructConst).void)
    ).void
  end
  def initialize(name, type, default: T.unsafe(nil), loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#555
  sig { override.params(other: ::RBI::Node).returns(T::Boolean) }
  def compatible_with?(other); end

  # source://rbi//lib/rbi/model.rb#1286
  sig { override.returns(T::Array[::String]) }
  def fully_qualified_names; end

  # source://rbi//lib/rbi/index.rb#203
  sig { override.returns(T::Array[::String]) }
  def index_ids; end

  # source://rbi//lib/rbi/model.rb#1292
  sig { override.returns(::String) }
  def to_s; end
end

# @abstract It cannot be directly instantiated. Subclasses must implement the `abstract` methods below.
#
# source://rbi//lib/rbi/model.rb#1232
class RBI::TStructField < ::RBI::NodeWithComments
  abstract!

  # source://rbi//lib/rbi/model.rb#1256
  sig do
    params(
      name: ::String,
      type: T.any(::RBI::Type, ::String),
      default: T.nilable(::String),
      loc: T.nilable(::RBI::Loc),
      comments: T::Array[::RBI::Comment]
    ).void
  end
  def initialize(name, type, default: T.unsafe(nil), loc: T.unsafe(nil), comments: T.unsafe(nil)); end

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#546
  sig { override.params(other: ::RBI::Node).returns(T::Boolean) }
  def compatible_with?(other); end

  # source://rbi//lib/rbi/model.rb#1245
  sig { returns(T.nilable(::String)) }
  def default; end

  # @return [String, nil]
  #
  # source://rbi//lib/rbi/model.rb#1245
  def default=(_arg0); end

  # @abstract
  #
  # source://rbi//lib/rbi/model.rb#1264
  sig { abstract.returns(T::Array[::String]) }
  def fully_qualified_names; end

  # source://rbi//lib/rbi/model.rb#1239
  sig { returns(::String) }
  def name; end

  # @return [String]
  #
  # source://rbi//lib/rbi/model.rb#1239
  def name=(_arg0); end

  # source://rbi//lib/rbi/model.rb#1242
  sig { returns(T.any(::RBI::Type, ::String)) }
  def type; end

  # @return [Type, String]
  #
  # source://rbi//lib/rbi/model.rb#1242
  def type=(_arg0); end
end

# source://rbi//lib/rbi/model.rb#1297
class RBI::TStructProp < ::RBI::TStructField
  include ::RBI::Indexable

  # source://rbi//lib/rbi/model.rb#1310
  sig do
    params(
      name: ::String,
      type: T.any(::RBI::Type, ::String),
      default: T.nilable(::String),
      loc: T.nilable(::RBI::Loc),
      comments: T::Array[::RBI::Comment],
      block: T.nilable(T.proc.params(node: ::RBI::TStructProp).void)
    ).void
  end
  def initialize(name, type, default: T.unsafe(nil), loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#564
  sig { override.params(other: ::RBI::Node).returns(T::Boolean) }
  def compatible_with?(other); end

  # source://rbi//lib/rbi/model.rb#1316
  sig { override.returns(T::Array[::String]) }
  def fully_qualified_names; end

  # source://rbi//lib/rbi/index.rb#213
  sig { override.returns(T::Array[::String]) }
  def index_ids; end

  # source://rbi//lib/rbi/model.rb#1322
  sig { override.returns(::String) }
  def to_s; end
end

# source://rbi//lib/rbi/model.rb#108
class RBI::Tree < ::RBI::NodeWithComments
  # source://rbi//lib/rbi/model.rb#121
  sig do
    params(
      loc: T.nilable(::RBI::Loc),
      comments: T::Array[::RBI::Comment],
      block: T.nilable(T.proc.params(node: ::RBI::Tree).void)
    ).void
  end
  def initialize(loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end

  # source://rbi//lib/rbi/model.rb#128
  sig { params(node: ::RBI::Node).void }
  def <<(node); end

  # source://rbi//lib/rbi/rewriters/add_sig_templates.rb#66
  sig { params(with_todo_comment: T::Boolean).void }
  def add_sig_templates!(with_todo_comment: T.unsafe(nil)); end

  # source://rbi//lib/rbi/rewriters/annotate.rb#49
  sig { params(annotation: ::String, annotate_scopes: T::Boolean, annotate_properties: T::Boolean).void }
  def annotate!(annotation, annotate_scopes: T.unsafe(nil), annotate_properties: T.unsafe(nil)); end

  # source://tapioca/0.16.3/lib/tapioca/rbi_ext/model.rb#38
  sig do
    params(
      name: ::String,
      superclass_name: T.nilable(::String),
      block: T.nilable(T.proc.params(scope: ::RBI::Scope).void)
    ).returns(::RBI::Scope)
  end
  def create_class(name, superclass_name: T.unsafe(nil), &block); end

  # source://tapioca/0.16.3/lib/tapioca/rbi_ext/model.rb#45
  sig { params(name: ::String, value: ::String).void }
  def create_constant(name, value:); end

  # source://tapioca/0.16.3/lib/tapioca/rbi_ext/model.rb#55
  sig { params(name: ::String).void }
  def create_extend(name); end

  # source://tapioca/0.16.3/lib/tapioca/rbi_ext/model.rb#50
  sig { params(name: ::String).void }
  def create_include(name); end

  # source://tapioca/0.16.3/lib/tapioca/rbi_ext/model.rb#90
  sig do
    params(
      name: ::String,
      parameters: T::Array[::RBI::TypedParam],
      return_type: T.nilable(::String),
      class_method: T::Boolean,
      visibility: ::RBI::Visibility,
      comments: T::Array[::RBI::Comment],
      block: T.nilable(T.proc.params(node: ::RBI::Method).void)
    ).void
  end
  def create_method(name, parameters: T.unsafe(nil), return_type: T.unsafe(nil), class_method: T.unsafe(nil), visibility: T.unsafe(nil), comments: T.unsafe(nil), &block); end

  # source://tapioca/0.16.3/lib/tapioca/rbi_ext/model.rb#60
  sig { params(name: ::String).void }
  def create_mixes_in_class_methods(name); end

  # source://tapioca/0.16.3/lib/tapioca/rbi_ext/model.rb#25
  sig { params(name: ::String, block: T.nilable(T.proc.params(scope: ::RBI::Scope).void)).returns(::RBI::Scope) }
  def create_module(name, &block); end

  # source://tapioca/0.16.3/lib/tapioca/rbi_ext/model.rb#9
  sig { params(constant: ::Module, block: T.nilable(T.proc.params(scope: ::RBI::Scope).void)).returns(::RBI::Scope) }
  def create_path(constant, &block); end

  # source://tapioca/0.16.3/lib/tapioca/rbi_ext/model.rb#74
  sig do
    params(
      name: ::String,
      type: ::String,
      variance: ::Symbol,
      fixed: T.nilable(::String),
      upper: T.nilable(::String),
      lower: T.nilable(::String)
    ).void
  end
  def create_type_variable(name, type:, variance: T.unsafe(nil), fixed: T.unsafe(nil), upper: T.unsafe(nil), lower: T.unsafe(nil)); end

  # source://rbi//lib/rbi/rewriters/deannotate.rb#41
  sig { params(annotation: ::String).void }
  def deannotate!(annotation); end

  # source://rbi//lib/rbi/model.rb#134
  sig { returns(T::Boolean) }
  def empty?; end

  # source://rbi//lib/rbi/rewriters/filter_versions.rb#118
  sig { params(version: ::Gem::Version).void }
  def filter_versions!(version); end

  # source://rbi//lib/rbi/rewriters/flatten_singleton_methods.rb#60
  sig { void }
  def flatten_singleton_methods!; end

  # source://rbi//lib/rbi/rewriters/flatten_visibilities.rb#60
  sig { void }
  def flatten_visibilities!; end

  # source://rbi//lib/rbi/rewriters/group_nodes.rb#81
  sig { void }
  def group_nodes!; end

  # source://rbi//lib/rbi/index.rb#68
  sig { returns(::RBI::Index) }
  def index; end

  # source://rbi//lib/rbi/rewriters/merge_trees.rb#324
  sig do
    params(
      other: ::RBI::Tree,
      left_name: ::String,
      right_name: ::String,
      keep: ::RBI::Rewriters::Merge::Keep
    ).returns(::RBI::MergeTree)
  end
  def merge(other, left_name: T.unsafe(nil), right_name: T.unsafe(nil), keep: T.unsafe(nil)); end

  # source://rbi//lib/rbi/rewriters/nest_non_public_members.rb#46
  sig { void }
  def nest_non_public_members!; end

  # source://rbi//lib/rbi/rewriters/nest_singleton_methods.rb#36
  sig { void }
  def nest_singleton_methods!; end

  # source://rbi//lib/rbi/rewriters/nest_top_level_members.rb#63
  sig { void }
  def nest_top_level_members!; end

  # source://rbi//lib/rbi/model.rb#112
  sig { returns(T::Array[::RBI::Node]) }
  def nodes; end

  # source://rbi//lib/rbi/rewriters/attr_to_methods.rb#53
  sig { void }
  def replace_attributes_with_methods!; end

  # source://rbi//lib/rbi/rewriters/sort_nodes.rb#119
  sig { void }
  def sort_nodes!; end

  private

  # source://tapioca/0.16.3/lib/tapioca/rbi_ext/model.rb#123
  sig { params(node: ::RBI::Node).returns(::RBI::Node) }
  def create_node(node); end

  # source://tapioca/0.16.3/lib/tapioca/rbi_ext/model.rb#118
  sig { returns(T::Hash[::String, ::RBI::Node]) }
  def nodes_cache; end
end

# The base class for all RBI types.
#
# @abstract It cannot be directly instantiated. Subclasses must implement the `abstract` methods below.
#
# source://rbi//lib/rbi/type.rb#6
class RBI::Type
  abstract!

  # source://rbi//lib/rbi/type.rb#699
  sig { void }
  def initialize; end

  # @abstract
  #
  # source://rbi//lib/rbi/type.rb#745
  sig { abstract.params(other: ::BasicObject).returns(T::Boolean) }
  def ==(other); end

  # source://rbi//lib/rbi/type.rb#748
  sig { params(other: ::BasicObject).returns(T::Boolean) }
  def eql?(other); end

  # source://rbi//lib/rbi/type.rb#753
  sig { override.returns(::Integer) }
  def hash; end

  # Returns a new type that is `nilable` if it is not already.
  #
  # If the type is already nilable, it returns itself.
  # ```ruby
  # type = RBI::Type.simple("String")
  # type.to_rbi # => "String"
  # type.nilable.to_rbi # => "T.nilable(String)"
  # type.nilable.nilable.to_rbi # => "T.nilable(String)"
  # ```
  #
  # source://rbi//lib/rbi/type.rb#713
  sig { returns(::RBI::Type) }
  def nilable; end

  # Returns whether the type is nilable.
  #
  # source://rbi//lib/rbi/type.rb#740
  sig { returns(T::Boolean) }
  def nilable?; end

  # Returns the non-nilable version of the type.
  # If the type is already non-nilable, it returns itself.
  # If the type is nilable, it returns the inner type.
  #
  # ```ruby
  # type = RBI::Type.nilable(RBI::Type.simple("String"))
  # type.to_rbi # => "T.nilable(String)"
  # type.non_nilable.to_rbi # => "String"
  # type.non_nilable.non_nilable.to_rbi # => "String"
  # ```
  #
  # source://rbi//lib/rbi/type.rb#728
  sig { returns(::RBI::Type) }
  def non_nilable; end

  # source://rbi//lib/rbi/rbs_printer.rb#1030
  sig { returns(::String) }
  def rbs_string; end

  # @abstract
  #
  # source://rbi//lib/rbi/type.rb#758
  sig { abstract.returns(::String) }
  def to_rbi; end

  # source://rbi//lib/rbi/type.rb#761
  sig { override.returns(::String) }
  def to_s; end

  class << self
    # Builds a type that represents an intersection of multiple types like `T.all(String, Integer)`.
    #
    # Note that this method transforms types such as `T.all(String, String)` into `String`, so
    # it may return something other than a `All`.
    #
    # source://rbi//lib/rbi/type.rb#563
    sig { params(type1: ::RBI::Type, type2: ::RBI::Type, types: ::RBI::Type).returns(::RBI::Type) }
    def all(type1, type2, *types); end

    # Builds a type that represents a union of multiple types like `T.any(String, Integer)`.
    #
    # Note that this method transforms types such as `T.any(String, NilClass)` into `T.nilable(String)`, so
    # it may return something other than a `Any`.
    #
    # source://rbi//lib/rbi/type.rb#590
    sig { params(type1: ::RBI::Type, type2: ::RBI::Type, types: ::RBI::Type).returns(::RBI::Type) }
    def any(type1, type2, *types); end

    # Builds a type that represents `T.anything`.
    #
    # source://rbi//lib/rbi/type.rb#488
    sig { returns(::RBI::Type::Anything) }
    def anything; end

    # Builds a type that represents `T.attached_class`.
    #
    # source://rbi//lib/rbi/type.rb#494
    sig { returns(::RBI::Type::AttachedClass) }
    def attached_class; end

    # Builds a type that represents `T::Boolean`.
    #
    # source://rbi//lib/rbi/type.rb#500
    sig { returns(::RBI::Type::Boolean) }
    def boolean; end

    # Builds a type that represents the singleton class of another type like `T.class_of(Foo)`.
    #
    # source://rbi//lib/rbi/type.rb#538
    sig { params(type: ::RBI::Type::Simple, type_parameter: T.nilable(::RBI::Type)).returns(::RBI::Type::ClassOf) }
    def class_of(type, type_parameter = T.unsafe(nil)); end

    # Builds a type that represents a generic type like `T::Array[String]` or `T::Hash[Symbol, Integer]`.
    #
    # source://rbi//lib/rbi/type.rb#655
    sig { params(name: ::String, params: T.any(::RBI::Type, T::Array[::RBI::Type])).returns(::RBI::Type::Generic) }
    def generic(name, *params); end

    # Builds a type that represents a nilable of another type like `T.nilable(String)`.
    #
    # Note that this method transforms types such as `T.nilable(T.untyped)` into `T.untyped`, so
    # it may return something other than a `RBI::Type::Nilable`.
    #
    # source://rbi//lib/rbi/type.rb#547
    sig { params(type: ::RBI::Type).returns(::RBI::Type) }
    def nilable(type); end

    # Builds a type that represents `T.noreturn`.
    #
    # source://rbi//lib/rbi/type.rb#506
    sig { returns(::RBI::Type::NoReturn) }
    def noreturn; end

    # source://rbi//lib/rbi/type_parser.rb#26
    sig { params(node: ::Prism::Node).returns(::RBI::Type) }
    def parse_node(node); end

    # @raise [Error]
    #
    # source://rbi//lib/rbi/type_parser.rb#10
    sig { params(string: ::String).returns(::RBI::Type) }
    def parse_string(string); end

    # Builds a type that represents a proc type like `T.proc.void`.
    #
    # source://rbi//lib/rbi/type.rb#683
    sig { returns(::RBI::Type::Proc) }
    def proc; end

    # Builds a type that represents `T.self_type`.
    #
    # source://rbi//lib/rbi/type.rb#512
    sig { returns(::RBI::Type::SelfType) }
    def self_type; end

    # Builds a type that represents a shape type like `{name: String, age: Integer}`.
    #
    # source://rbi//lib/rbi/type.rb#675
    sig { params(types: T::Hash[T.any(::String, ::Symbol), ::RBI::Type]).returns(::RBI::Type::Shape) }
    def shape(types = T.unsafe(nil)); end

    # Builds a simple type like `String` or `::Foo::Bar`.
    #
    # It raises a `NameError` if the name is not a valid Ruby class identifier.
    #
    # @raise [NameError]
    #
    # source://rbi//lib/rbi/type.rb#477
    sig { params(name: ::String).returns(::RBI::Type::Simple) }
    def simple(name); end

    # Builds a type that represents the class of another type like `T::Class[Foo]`.
    #
    # source://rbi//lib/rbi/type.rb#532
    sig { params(type: ::RBI::Type).returns(::RBI::Type::Class) }
    def t_class(type); end

    # Builds a type that represents a tuple type like `[String, Integer]`.
    #
    # source://rbi//lib/rbi/type.rb#669
    sig { params(types: T.any(::RBI::Type, T::Array[::RBI::Type])).returns(::RBI::Type::Tuple) }
    def tuple(*types); end

    # Builds a type that represents a type parameter like `T.type_parameter(:U)`.
    #
    # source://rbi//lib/rbi/type.rb#661
    sig { params(name: ::Symbol).returns(::RBI::Type::TypeParameter) }
    def type_parameter(name); end

    # Builds a type that represents `T.untyped`.
    #
    # source://rbi//lib/rbi/type.rb#518
    sig { returns(::RBI::Type::Untyped) }
    def untyped; end

    # Builds a type that represents `void`.
    #
    # source://rbi//lib/rbi/type.rb#524
    sig { returns(::RBI::Type::Void) }
    def void; end

    private

    # source://rbi//lib/rbi/type_parser.rb#263
    sig { params(node: ::Prism::CallNode).returns(T::Array[::Prism::Node]) }
    def call_chain(node); end

    # source://rbi//lib/rbi/type_parser.rb#250
    sig { params(node: ::Prism::CallNode, count: ::Integer).returns(T::Array[::Prism::Node]) }
    def check_arguments_at_least!(node, count); end

    # source://rbi//lib/rbi/type_parser.rb#235
    sig { params(node: ::Prism::CallNode, count: ::Integer).returns(T::Array[::Prism::Node]) }
    def check_arguments_exactly!(node, count); end

    # @raise [Error]
    #
    # source://rbi//lib/rbi/type_parser.rb#69
    sig { params(node: ::Prism::CallNode).returns(::RBI::Type) }
    def parse_call(node); end

    # source://rbi//lib/rbi/type_parser.rb#52
    sig { params(node: T.any(::Prism::ConstantPathNode, ::Prism::ConstantReadNode)).returns(::RBI::Type) }
    def parse_constant(node); end

    # @raise [Error]
    #
    # source://rbi//lib/rbi/type_parser.rb#195
    sig { params(node: ::Prism::CallNode).returns(::RBI::Type) }
    def parse_proc(node); end

    # source://rbi//lib/rbi/type_parser.rb#176
    sig { params(node: T.any(::Prism::HashNode, ::Prism::KeywordHashNode)).returns(::RBI::Type) }
    def parse_shape(node); end

    # source://rbi//lib/rbi/type_parser.rb#171
    sig { params(node: ::Prism::ArrayNode).returns(::RBI::Type) }
    def parse_tuple(node); end

    # source://rbi//lib/rbi/type_parser.rb#276
    sig { params(node: T.nilable(::Prism::Node)).returns(T::Boolean) }
    def t?(node); end

    # source://rbi//lib/rbi/type_parser.rb#288
    sig { params(node: T.nilable(::Prism::Node)).returns(T::Boolean) }
    def t_boolean?(node); end

    # source://rbi//lib/rbi/type_parser.rb#295
    sig { params(node: ::Prism::ConstantPathNode).returns(T::Boolean) }
    def t_class?(node); end

    # source://rbi//lib/rbi/type_parser.rb#300
    sig { params(node: T.nilable(::Prism::Node)).returns(T::Boolean) }
    def t_class_of?(node); end

    # source://rbi//lib/rbi/type_parser.rb#307
    sig { params(node: ::Prism::CallNode).returns(T::Boolean) }
    def t_proc?(node); end

    # source://rbi//lib/rbi/type.rb#693
    sig { params(name: ::String).returns(T::Boolean) }
    def valid_identifier?(name); end
  end
end

# A type that is intersection of multiple types like `T.all(String, Integer)`.
#
# source://rbi//lib/rbi/type.rb#252
class RBI::Type::All < ::RBI::Type::Composite
  # source://rbi//lib/rbi/type.rb#256
  sig { override.returns(::String) }
  def to_rbi; end
end

# A type that is union of multiple types like `T.any(String, Integer)`.
#
# source://rbi//lib/rbi/type.rb#262
class RBI::Type::Any < ::RBI::Type::Composite
  # source://rbi//lib/rbi/type.rb#271
  sig { returns(T::Boolean) }
  def nilable?; end

  # source://rbi//lib/rbi/type.rb#266
  sig { override.returns(::String) }
  def to_rbi; end
end

# `T.anything`.
#
# source://rbi//lib/rbi/type.rb#43
class RBI::Type::Anything < ::RBI::Type
  # source://rbi//lib/rbi/type.rb#47
  sig { override.params(other: ::BasicObject).returns(T::Boolean) }
  def ==(other); end

  # source://rbi//lib/rbi/type.rb#52
  sig { override.returns(::String) }
  def to_rbi; end
end

# `T.attached_class`.
#
# source://rbi//lib/rbi/type.rb#58
class RBI::Type::AttachedClass < ::RBI::Type
  # source://rbi//lib/rbi/type.rb#62
  sig { override.params(other: ::BasicObject).returns(T::Boolean) }
  def ==(other); end

  # source://rbi//lib/rbi/type.rb#67
  sig { override.returns(::String) }
  def to_rbi; end
end

# `T::Boolean`.
#
# source://rbi//lib/rbi/type.rb#73
class RBI::Type::Boolean < ::RBI::Type
  # source://rbi//lib/rbi/type.rb#77
  sig { override.params(other: ::BasicObject).returns(T::Boolean) }
  def ==(other); end

  # source://rbi//lib/rbi/type.rb#82
  sig { override.returns(::String) }
  def to_rbi; end
end

# The class of another type like `T::Class[Foo]`.
#
# source://rbi//lib/rbi/type.rb#150
class RBI::Type::Class < ::RBI::Type
  # source://rbi//lib/rbi/type.rb#157
  sig { params(type: ::RBI::Type).void }
  def initialize(type); end

  # source://rbi//lib/rbi/type.rb#163
  sig { override.params(other: ::BasicObject).returns(T::Boolean) }
  def ==(other); end

  # source://rbi//lib/rbi/type.rb#168
  sig { override.returns(::String) }
  def to_rbi; end

  # source://rbi//lib/rbi/type.rb#154
  sig { returns(::RBI::Type) }
  def type; end
end

# The singleton class of another type like `T.class_of(Foo)`.
#
# source://rbi//lib/rbi/type.rb#174
class RBI::Type::ClassOf < ::RBI::Type
  # source://rbi//lib/rbi/type.rb#184
  sig { params(type: ::RBI::Type::Simple, type_parameter: T.nilable(::RBI::Type)).void }
  def initialize(type, type_parameter = T.unsafe(nil)); end

  # source://rbi//lib/rbi/type.rb#191
  sig { override.params(other: ::BasicObject).returns(T::Boolean) }
  def ==(other); end

  # source://rbi//lib/rbi/type.rb#196
  sig { override.returns(::String) }
  def to_rbi; end

  # source://rbi//lib/rbi/type.rb#178
  sig { returns(::RBI::Type::Simple) }
  def type; end

  # source://rbi//lib/rbi/type.rb#181
  sig { returns(T.nilable(::RBI::Type)) }
  def type_parameter; end
end

# A type that is composed of multiple types like `T.all(String, Integer)`.
#
# @abstract It cannot be directly instantiated. Subclasses must implement the `abstract` methods below.
#
# source://rbi//lib/rbi/type.rb#230
class RBI::Type::Composite < ::RBI::Type
  abstract!

  # source://rbi//lib/rbi/type.rb#240
  sig { params(types: T::Array[::RBI::Type]).void }
  def initialize(types); end

  # source://rbi//lib/rbi/type.rb#246
  sig { override.params(other: ::BasicObject).returns(T::Boolean) }
  def ==(other); end

  # source://rbi//lib/rbi/type.rb#237
  sig { returns(T::Array[::RBI::Type]) }
  def types; end
end

# source://rbi//lib/rbi/type_parser.rb#6
class RBI::Type::Error < ::RBI::Error; end

# A generic type like `T::Array[String]` or `T::Hash[Symbol, Integer]`.
#
# source://rbi//lib/rbi/type.rb#279
class RBI::Type::Generic < ::RBI::Type
  # source://rbi//lib/rbi/type.rb#289
  sig { params(name: ::String, params: ::RBI::Type).void }
  def initialize(name, *params); end

  # source://rbi//lib/rbi/type.rb#296
  sig { override.params(other: ::BasicObject).returns(T::Boolean) }
  def ==(other); end

  # source://rbi//lib/rbi/type.rb#283
  sig { returns(::String) }
  def name; end

  # source://rbi//lib/rbi/type.rb#286
  sig { returns(T::Array[::RBI::Type]) }
  def params; end

  # source://rbi//lib/rbi/type.rb#301
  sig { override.returns(::String) }
  def to_rbi; end
end

# A type that can be `nil` like `T.nilable(String)`.
#
# source://rbi//lib/rbi/type.rb#206
class RBI::Type::Nilable < ::RBI::Type
  # source://rbi//lib/rbi/type.rb#213
  sig { params(type: ::RBI::Type).void }
  def initialize(type); end

  # source://rbi//lib/rbi/type.rb#219
  sig { override.params(other: ::BasicObject).returns(T::Boolean) }
  def ==(other); end

  # source://rbi//lib/rbi/type.rb#224
  sig { override.returns(::String) }
  def to_rbi; end

  # source://rbi//lib/rbi/type.rb#210
  sig { returns(::RBI::Type) }
  def type; end
end

# `T.noreturn`.
#
# source://rbi//lib/rbi/type.rb#88
class RBI::Type::NoReturn < ::RBI::Type
  # source://rbi//lib/rbi/type.rb#92
  sig { override.params(other: ::BasicObject).returns(T::Boolean) }
  def ==(other); end

  # source://rbi//lib/rbi/type.rb#97
  sig { override.returns(::String) }
  def to_rbi; end
end

# A proc type like `T.proc.void`.
#
# source://rbi//lib/rbi/type.rb#387
class RBI::Type::Proc < ::RBI::Type
  # source://rbi//lib/rbi/type.rb#400
  sig { void }
  def initialize; end

  # source://rbi//lib/rbi/type.rb#408
  sig { override.params(other: ::BasicObject).returns(T::Boolean) }
  def ==(other); end

  # source://rbi//lib/rbi/type.rb#436
  sig { params(type: T.untyped).returns(T.self_type) }
  def bind(type); end

  # source://rbi//lib/rbi/type.rb#418
  sig { params(params: ::RBI::Type).returns(T.self_type) }
  def params(**params); end

  # source://rbi//lib/rbi/type.rb#397
  sig { returns(T.nilable(::RBI::Type)) }
  def proc_bind; end

  # source://rbi//lib/rbi/type.rb#391
  sig { returns(T::Hash[::Symbol, ::RBI::Type]) }
  def proc_params; end

  # source://rbi//lib/rbi/type.rb#394
  sig { returns(::RBI::Type) }
  def proc_returns; end

  # source://rbi//lib/rbi/type.rb#424
  sig { params(type: T.untyped).returns(T.self_type) }
  def returns(type); end

  # source://rbi//lib/rbi/type.rb#442
  sig { override.returns(::String) }
  def to_rbi; end

  # source://rbi//lib/rbi/type.rb#430
  sig { returns(T.self_type) }
  def void; end
end

# `T.self_type`.
#
# source://rbi//lib/rbi/type.rb#103
class RBI::Type::SelfType < ::RBI::Type
  # source://rbi//lib/rbi/type.rb#107
  sig { override.params(other: ::BasicObject).returns(T::Boolean) }
  def ==(other); end

  # source://rbi//lib/rbi/type.rb#112
  sig { override.returns(::String) }
  def to_rbi; end
end

# A shape type like `{name: String, age: Integer}`.
#
# source://rbi//lib/rbi/type.rb#357
class RBI::Type::Shape < ::RBI::Type
  # source://rbi//lib/rbi/type.rb#364
  sig { params(types: T::Hash[T.any(::String, ::Symbol), ::RBI::Type]).void }
  def initialize(types); end

  # source://rbi//lib/rbi/type.rb#370
  sig { override.params(other: ::BasicObject).returns(T::Boolean) }
  def ==(other); end

  # source://rbi//lib/rbi/type.rb#375
  sig { override.returns(::String) }
  def to_rbi; end

  # source://rbi//lib/rbi/type.rb#361
  sig { returns(T::Hash[T.any(::String, ::Symbol), ::RBI::Type]) }
  def types; end
end

# A type that represents a simple class name like `String` or `Foo`.
#
# It can also be a qualified name like `::Foo` or `Foo::Bar`.
#
# source://rbi//lib/rbi/type.rb#17
class RBI::Type::Simple < ::RBI::Type
  # source://rbi//lib/rbi/type.rb#24
  sig { params(name: ::String).void }
  def initialize(name); end

  # source://rbi//lib/rbi/type.rb#30
  sig { override.params(other: ::BasicObject).returns(T::Boolean) }
  def ==(other); end

  # source://rbi//lib/rbi/type.rb#21
  sig { returns(::String) }
  def name; end

  # source://rbi//lib/rbi/type.rb#35
  sig { override.returns(::String) }
  def to_rbi; end
end

# A tuple type like `[String, Integer]`.
#
# source://rbi//lib/rbi/type.rb#333
class RBI::Type::Tuple < ::RBI::Type
  # source://rbi//lib/rbi/type.rb#340
  sig { params(types: T::Array[::RBI::Type]).void }
  def initialize(types); end

  # source://rbi//lib/rbi/type.rb#346
  sig { override.params(other: ::BasicObject).returns(T::Boolean) }
  def ==(other); end

  # source://rbi//lib/rbi/type.rb#351
  sig { override.returns(::String) }
  def to_rbi; end

  # source://rbi//lib/rbi/type.rb#337
  sig { returns(T::Array[::RBI::Type]) }
  def types; end
end

# A type parameter like `T.type_parameter(:U)`.
#
# source://rbi//lib/rbi/type.rb#307
class RBI::Type::TypeParameter < ::RBI::Type
  # source://rbi//lib/rbi/type.rb#314
  sig { params(name: ::Symbol).void }
  def initialize(name); end

  # source://rbi//lib/rbi/type.rb#320
  sig { override.params(other: ::BasicObject).returns(T::Boolean) }
  def ==(other); end

  # source://rbi//lib/rbi/type.rb#311
  sig { returns(::Symbol) }
  def name; end

  # source://rbi//lib/rbi/type.rb#325
  sig { override.returns(::String) }
  def to_rbi; end
end

# `T.untyped`.
#
# source://rbi//lib/rbi/type.rb#118
class RBI::Type::Untyped < ::RBI::Type
  # source://rbi//lib/rbi/type.rb#122
  sig { override.params(other: ::BasicObject).returns(T::Boolean) }
  def ==(other); end

  # source://rbi//lib/rbi/type.rb#127
  sig { override.returns(::String) }
  def to_rbi; end
end

# source://rbi//lib/rbi/type_visitor.rb#6
class RBI::Type::Visitor
  # source://rbi//lib/rbi/type_visitor.rb#12
  sig { params(node: ::RBI::Type).void }
  def visit(node); end

  private

  # source://rbi//lib/rbi/type_visitor.rb#58
  sig { params(type: ::RBI::Type::All).void }
  def visit_all(type); end

  # source://rbi//lib/rbi/type_visitor.rb#61
  sig { params(type: ::RBI::Type::Any).void }
  def visit_any(type); end

  # source://rbi//lib/rbi/type_visitor.rb#64
  sig { params(type: ::RBI::Type::Anything).void }
  def visit_anything(type); end

  # source://rbi//lib/rbi/type_visitor.rb#67
  sig { params(type: ::RBI::Type::AttachedClass).void }
  def visit_attached_class(type); end

  # source://rbi//lib/rbi/type_visitor.rb#70
  sig { params(type: ::RBI::Type::Boolean).void }
  def visit_boolean(type); end

  # source://rbi//lib/rbi/type_visitor.rb#73
  sig { params(type: ::RBI::Type::Class).void }
  def visit_class(type); end

  # source://rbi//lib/rbi/type_visitor.rb#76
  sig { params(type: ::RBI::Type::ClassOf).void }
  def visit_class_of(type); end

  # source://rbi//lib/rbi/type_visitor.rb#79
  sig { params(type: ::RBI::Type::Generic).void }
  def visit_generic(type); end

  # source://rbi//lib/rbi/type_visitor.rb#82
  sig { params(type: ::RBI::Type::Nilable).void }
  def visit_nilable(type); end

  # source://rbi//lib/rbi/type_visitor.rb#88
  sig { params(type: ::RBI::Type::NoReturn).void }
  def visit_no_return(type); end

  # source://rbi//lib/rbi/type_visitor.rb#91
  sig { params(type: ::RBI::Type::Proc).void }
  def visit_proc(type); end

  # source://rbi//lib/rbi/type_visitor.rb#94
  sig { params(type: ::RBI::Type::SelfType).void }
  def visit_self_type(type); end

  # source://rbi//lib/rbi/type_visitor.rb#100
  sig { params(type: ::RBI::Type::Shape).void }
  def visit_shape(type); end

  # source://rbi//lib/rbi/type_visitor.rb#85
  sig { params(type: ::RBI::Type::Simple).void }
  def visit_simple(type); end

  # source://rbi//lib/rbi/type_visitor.rb#103
  sig { params(type: ::RBI::Type::Tuple).void }
  def visit_tuple(type); end

  # source://rbi//lib/rbi/type_visitor.rb#106
  sig { params(type: ::RBI::Type::TypeParameter).void }
  def visit_type_parameter(type); end

  # source://rbi//lib/rbi/type_visitor.rb#109
  sig { params(type: ::RBI::Type::Untyped).void }
  def visit_untyped(type); end

  # source://rbi//lib/rbi/type_visitor.rb#97
  sig { params(type: ::RBI::Type::Void).void }
  def visit_void(type); end
end

# source://rbi//lib/rbi/type_visitor.rb#9
class RBI::Type::Visitor::Error < ::RBI::Error; end

# `void`.
#
# source://rbi//lib/rbi/type.rb#133
class RBI::Type::Void < ::RBI::Type
  # source://rbi//lib/rbi/type.rb#137
  sig { override.params(other: ::BasicObject).returns(T::Boolean) }
  def ==(other); end

  # source://rbi//lib/rbi/type.rb#142
  sig { override.returns(::String) }
  def to_rbi; end
end

# source://rbi//lib/rbi/model.rb#1400
class RBI::TypeMember < ::RBI::NodeWithComments
  include ::RBI::Indexable

  # source://rbi//lib/rbi/model.rb#1415
  sig do
    params(
      name: ::String,
      value: ::String,
      loc: T.nilable(::RBI::Loc),
      comments: T::Array[::RBI::Comment],
      block: T.nilable(T.proc.params(node: ::RBI::TypeMember).void)
    ).void
  end
  def initialize(name, value, loc: T.unsafe(nil), comments: T.unsafe(nil), &block); end

  # source://rbi//lib/rbi/model.rb#1423
  sig { returns(::String) }
  def fully_qualified_name; end

  # source://rbi//lib/rbi/index.rb#183
  sig { override.returns(T::Array[::String]) }
  def index_ids; end

  # source://rbi//lib/rbi/model.rb#1404
  sig { returns(::String) }
  def name; end

  # source://rbi//lib/rbi/model.rb#1430
  sig { override.returns(::String) }
  def to_s; end

  # @return [String]
  #
  # source://rbi//lib/rbi/model.rb#1404
  def value; end
end

# source://rbi//lib/rbi/rbs_printer.rb#787
class RBI::TypePrinter
  # source://rbi//lib/rbi/rbs_printer.rb#794
  sig { void }
  def initialize; end

  # source://rbi//lib/rbi/rbs_printer.rb#791
  sig { returns(::String) }
  def string; end

  # source://rbi//lib/rbi/rbs_printer.rb#799
  sig { params(node: ::RBI::Type).void }
  def visit(node); end

  # source://rbi//lib/rbi/rbs_printer.rb#907
  sig { params(type: ::RBI::Type::All).void }
  def visit_all(type); end

  # source://rbi//lib/rbi/rbs_printer.rb#917
  sig { params(type: ::RBI::Type::Any).void }
  def visit_any(type); end

  # source://rbi//lib/rbi/rbs_printer.rb#864
  sig { params(type: ::RBI::Type::Anything).void }
  def visit_anything(type); end

  # source://rbi//lib/rbi/rbs_printer.rb#889
  sig { params(type: ::RBI::Type::AttachedClass).void }
  def visit_attached_class(type); end

  # source://rbi//lib/rbi/rbs_printer.rb#848
  sig { params(type: ::RBI::Type::Boolean).void }
  def visit_boolean(type); end

  # source://rbi//lib/rbi/rbs_printer.rb#969
  sig { params(type: ::RBI::Type::Class).void }
  def visit_class(type); end

  # source://rbi//lib/rbi/rbs_printer.rb#900
  sig { params(type: ::RBI::Type::ClassOf).void }
  def visit_class_of(type); end

  # source://rbi//lib/rbi/rbs_printer.rb#853
  sig { params(type: ::RBI::Type::Generic).void }
  def visit_generic(type); end

  # source://rbi//lib/rbi/rbs_printer.rb#894
  sig { params(type: ::RBI::Type::Nilable).void }
  def visit_nilable(type); end

  # source://rbi//lib/rbi/rbs_printer.rb#874
  sig { params(type: ::RBI::Type::NoReturn).void }
  def visit_no_return(type); end

  # source://rbi//lib/rbi/rbs_printer.rb#948
  sig { params(type: ::RBI::Type::Proc).void }
  def visit_proc(type); end

  # source://rbi//lib/rbi/rbs_printer.rb#884
  sig { params(type: ::RBI::Type::SelfType).void }
  def visit_self_type(type); end

  # source://rbi//lib/rbi/rbs_printer.rb#937
  sig { params(type: ::RBI::Type::Shape).void }
  def visit_shape(type); end

  # source://rbi//lib/rbi/rbs_printer.rb#843
  sig { params(type: ::RBI::Type::Simple).void }
  def visit_simple(type); end

  # source://rbi//lib/rbi/rbs_printer.rb#927
  sig { params(type: ::RBI::Type::Tuple).void }
  def visit_tuple(type); end

  # source://rbi//lib/rbi/rbs_printer.rb#964
  sig { params(type: ::RBI::Type::TypeParameter).void }
  def visit_type_parameter(type); end

  # source://rbi//lib/rbi/rbs_printer.rb#879
  sig { params(type: ::RBI::Type::Untyped).void }
  def visit_untyped(type); end

  # source://rbi//lib/rbi/rbs_printer.rb#869
  sig { params(type: ::RBI::Type::Void).void }
  def visit_void(type); end

  private

  # source://rbi//lib/rbi/rbs_printer.rb#978
  sig { params(type_name: ::String).returns(::String) }
  def translate_t_type(type_name); end
end

# source://rbi//lib/rbi/rewriters/attr_to_methods.rb#5
class RBI::UnexpectedMultipleSigsError < ::RBI::Error
  # source://rbi//lib/rbi/rewriters/attr_to_methods.rb#10
  sig { params(node: ::RBI::Node).void }
  def initialize(node); end

  # source://rbi//lib/rbi/rewriters/attr_to_methods.rb#7
  sig { returns(::RBI::Node) }
  def node; end
end

# source://rbi//lib/rbi/parser.rb#20
class RBI::UnexpectedParserError < ::RBI::Error
  # source://rbi//lib/rbi/parser.rb#27
  sig { params(parent_exception: ::Exception, last_location: ::RBI::Loc).void }
  def initialize(parent_exception, last_location); end

  # source://rbi//lib/rbi/parser.rb#24
  sig { returns(::RBI::Loc) }
  def last_location; end

  # source://rbi//lib/rbi/parser.rb#34
  sig { params(io: T.any(::IO, ::StringIO)).void }
  def print_debug(io: T.unsafe(nil)); end
end

# source://rbi//lib/rbi/version.rb#5
RBI::VERSION = T.let(T.unsafe(nil), String)

# Visibility
#
# @abstract It cannot be directly instantiated. Subclasses must implement the `abstract` methods below.
#
# source://rbi//lib/rbi/model.rb#916
class RBI::Visibility < ::RBI::NodeWithComments
  abstract!

  # source://rbi//lib/rbi/model.rb#926
  sig { params(visibility: ::Symbol, loc: T.nilable(::RBI::Loc), comments: T::Array[::RBI::Comment]).void }
  def initialize(visibility, loc: T.unsafe(nil), comments: T.unsafe(nil)); end

  # source://rbi//lib/rbi/model.rb#932
  sig { params(other: T.nilable(::Object)).returns(T::Boolean) }
  def ==(other); end

  # source://rbi//lib/rbi/model.rb#949
  sig { returns(T::Boolean) }
  def private?; end

  # source://rbi//lib/rbi/model.rb#944
  sig { returns(T::Boolean) }
  def protected?; end

  # source://rbi//lib/rbi/model.rb#939
  sig { returns(T::Boolean) }
  def public?; end

  # source://rbi//lib/rbi/model.rb#923
  sig { returns(::Symbol) }
  def visibility; end
end

# source://rbi//lib/rbi/rewriters/nest_non_public_members.rb#52
class RBI::VisibilityGroup < ::RBI::Tree
  # source://rbi//lib/rbi/rewriters/nest_non_public_members.rb#59
  sig { params(visibility: ::RBI::Visibility).void }
  def initialize(visibility); end

  # source://rbi//lib/rbi/rewriters/nest_non_public_members.rb#56
  sig { returns(::RBI::Visibility) }
  def visibility; end
end

# @abstract It cannot be directly instantiated. Subclasses must implement the `abstract` methods below.
#
# source://rbi//lib/rbi/visitor.rb#7
class RBI::Visitor
  abstract!

  # source://rbi//lib/rbi/visitor.rb#14
  sig { params(node: T.nilable(::RBI::Node)).void }
  def visit(node); end

  # source://rbi//lib/rbi/visitor.rb#108
  sig { params(nodes: T::Array[::RBI::Node]).void }
  def visit_all(nodes); end

  # source://rbi//lib/rbi/visitor.rb#113
  sig { params(file: ::RBI::File).void }
  def visit_file(file); end

  private

  # source://rbi//lib/rbi/visitor.rb#195
  sig { params(node: ::RBI::Arg).void }
  def visit_arg(node); end

  # source://rbi//lib/rbi/visitor.rb#144
  sig { params(node: ::RBI::AttrAccessor).void }
  def visit_attr_accessor(node); end

  # source://rbi//lib/rbi/visitor.rb#147
  sig { params(node: ::RBI::AttrReader).void }
  def visit_attr_reader(node); end

  # source://rbi//lib/rbi/visitor.rb#150
  sig { params(node: ::RBI::AttrWriter).void }
  def visit_attr_writer(node); end

  # source://rbi//lib/rbi/visitor.rb#123
  sig { params(node: ::RBI::BlankLine).void }
  def visit_blank_line(node); end

  # source://rbi//lib/rbi/visitor.rb#174
  sig { params(node: ::RBI::BlockParam).void }
  def visit_block_param(node); end

  # source://rbi//lib/rbi/visitor.rb#129
  sig { params(node: ::RBI::Class).void }
  def visit_class(node); end

  # source://rbi//lib/rbi/visitor.rb#120
  sig { params(node: ::RBI::Comment).void }
  def visit_comment(node); end

  # source://rbi//lib/rbi/visitor.rb#240
  sig { params(node: ::RBI::ConflictTree).void }
  def visit_conflict_tree(node); end

  # source://rbi//lib/rbi/visitor.rb#141
  sig { params(node: ::RBI::Const).void }
  def visit_const(node); end

  # source://rbi//lib/rbi/visitor.rb#180
  sig { params(node: ::RBI::Extend).void }
  def visit_extend(node); end

  # source://rbi//lib/rbi/visitor.rb#234
  sig { params(node: ::RBI::Group).void }
  def visit_group(node); end

  # source://rbi//lib/rbi/visitor.rb#222
  sig { params(node: ::RBI::Helper).void }
  def visit_helper(node); end

  # source://rbi//lib/rbi/visitor.rb#177
  sig { params(node: ::RBI::Include).void }
  def visit_include(node); end

  # source://rbi//lib/rbi/visitor.rb#198
  sig { params(node: ::RBI::KwArg).void }
  def visit_kw_arg(node); end

  # source://rbi//lib/rbi/visitor.rb#168
  sig { params(node: ::RBI::KwOptParam).void }
  def visit_kw_opt_param(node); end

  # source://rbi//lib/rbi/visitor.rb#165
  sig { params(node: ::RBI::KwParam).void }
  def visit_kw_param(node); end

  # source://rbi//lib/rbi/visitor.rb#171
  sig { params(node: ::RBI::KwRestParam).void }
  def visit_kw_rest_param(node); end

  # source://rbi//lib/rbi/visitor.rb#153
  sig { params(node: ::RBI::Method).void }
  def visit_method(node); end

  # source://rbi//lib/rbi/visitor.rb#228
  sig { params(node: ::RBI::MixesInClassMethods).void }
  def visit_mixes_in_class_methods(node); end

  # source://rbi//lib/rbi/visitor.rb#126
  sig { params(node: ::RBI::Module).void }
  def visit_module(node); end

  # source://rbi//lib/rbi/visitor.rb#159
  sig { params(node: ::RBI::OptParam).void }
  def visit_opt_param(node); end

  # source://rbi//lib/rbi/visitor.rb#189
  sig { params(node: ::RBI::Private).void }
  def visit_private(node); end

  # source://rbi//lib/rbi/visitor.rb#186
  sig { params(node: ::RBI::Protected).void }
  def visit_protected(node); end

  # source://rbi//lib/rbi/visitor.rb#183
  sig { params(node: ::RBI::Public).void }
  def visit_public(node); end

  # source://rbi//lib/rbi/visitor.rb#156
  sig { params(node: ::RBI::ReqParam).void }
  def visit_req_param(node); end

  # source://rbi//lib/rbi/visitor.rb#231
  sig { params(node: ::RBI::RequiresAncestor).void }
  def visit_requires_ancestor(node); end

  # source://rbi//lib/rbi/visitor.rb#162
  sig { params(node: ::RBI::RestParam).void }
  def visit_rest_param(node); end

  # source://rbi//lib/rbi/visitor.rb#243
  sig { params(node: ::RBI::ScopeConflict).void }
  def visit_scope_conflict(node); end

  # source://rbi//lib/rbi/visitor.rb#192
  sig { params(node: ::RBI::Send).void }
  def visit_send(node); end

  # source://rbi//lib/rbi/visitor.rb#201
  sig { params(node: ::RBI::Sig).void }
  def visit_sig(node); end

  # source://rbi//lib/rbi/visitor.rb#204
  sig { params(node: ::RBI::SigParam).void }
  def visit_sig_param(node); end

  # source://rbi//lib/rbi/visitor.rb#132
  sig { params(node: ::RBI::SingletonClass).void }
  def visit_singleton_class(node); end

  # source://rbi//lib/rbi/visitor.rb#135
  sig { params(node: ::RBI::Struct).void }
  def visit_struct(node); end

  # source://rbi//lib/rbi/visitor.rb#216
  sig { params(node: ::RBI::TEnum).void }
  def visit_tenum(node); end

  # source://rbi//lib/rbi/visitor.rb#219
  sig { params(node: ::RBI::TEnumBlock).void }
  def visit_tenum_block(node); end

  # source://rbi//lib/rbi/visitor.rb#138
  sig { params(node: ::RBI::Tree).void }
  def visit_tree(node); end

  # source://rbi//lib/rbi/visitor.rb#207
  sig { params(node: ::RBI::TStruct).void }
  def visit_tstruct(node); end

  # source://rbi//lib/rbi/visitor.rb#210
  sig { params(node: ::RBI::TStructConst).void }
  def visit_tstruct_const(node); end

  # source://rbi//lib/rbi/visitor.rb#213
  sig { params(node: ::RBI::TStructProp).void }
  def visit_tstruct_prop(node); end

  # source://rbi//lib/rbi/visitor.rb#225
  sig { params(node: ::RBI::TypeMember).void }
  def visit_type_member(node); end

  # source://rbi//lib/rbi/visitor.rb#237
  sig { params(node: ::RBI::VisibilityGroup).void }
  def visit_visibility_group(node); end
end

# source://rbi//lib/rbi/visitor.rb#5
class RBI::VisitorError < ::RBI::Error; end
