# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `prism` gem.
# Please instead update this file by running `bin/tapioca gem prism`.


# typed: strict

# =begin
# This file is generated by the templates/template.rb script and should not be
# modified manually. See templates/rbi/prism/dsl.rbi.erb
# if you are looking to modify the template
# =end
# =begin
# This file is generated by the templates/template.rb script and should not be
# modified manually. See templates/rbi/prism/node.rbi.erb
# if you are looking to modify the template
# =end
# =begin
# This file is generated by the templates/template.rb script and should not be
# modified manually. See templates/rbi/prism/visitor.rbi.erb
# if you are looking to modify the template
# =end

# We keep these shims in here because our client libraries might not have parser
# in their bundle.
module Parser; end

class Parser::Base; end

# The Prism Ruby parser.
#
# "Parsing Ruby is suddenly manageable!"
#   - You, hopefully
#
# source://prism//lib/prism.rb#8
module Prism
  class << self
    # Mirror the Prism.dump API by using the serialization API.
    def dump(*_arg0); end

    # Mirror the Prism.dump_file API by using the serialization API.
    def dump_file(*_arg0); end

    # Mirror the Prism.lex API by using the serialization API.
    def lex(*_arg0); end

    # :call-seq:
    #   Prism::lex_compat(source, **options) -> LexCompat::Result
    #
    # Returns a parse result whose value is an array of tokens that closely
    # resembles the return value of Ripper::lex. The main difference is that the
    # `:on_sp` token is not emitted.
    #
    # For supported options, see Prism::parse.
    #
    # source://prism//lib/prism.rb#45
    sig { params(source: String, options: T::Hash[Symbol, T.untyped]).returns(Prism::LexCompat::Result) }
    def lex_compat(source, **options); end

    # Mirror the Prism.lex_file API by using the serialization API.
    def lex_file(*_arg0); end

    # :call-seq:
    #   Prism::lex_ripper(source) -> Array
    #
    # This lexes with the Ripper lex. It drops any space events but otherwise
    # returns the same tokens. Raises SyntaxError if the syntax in source is
    # invalid.
    #
    # source://prism//lib/prism.rb#55
    sig { params(source: String).returns(T::Array[T.untyped]) }
    def lex_ripper(source); end

    # :call-seq:
    #   Prism::load(source, serialized) -> ParseResult
    #
    # Load the serialized AST using the source as a reference into a tree.
    #
    # source://prism//lib/prism.rb#63
    sig { params(source: String, serialized: String).returns(Prism::ParseResult) }
    def load(source, serialized); end

    # Mirror the Prism.parse API by using the serialization API.
    def parse(*_arg0); end

    # Mirror the Prism.parse_comments API by using the serialization API.
    def parse_comments(*_arg0); end

    # Mirror the Prism.parse_failure? API by using the serialization API.
    #
    # @return [Boolean]
    def parse_failure?(*_arg0); end

    # Mirror the Prism.parse_file API by using the serialization API. This uses
    # native strings instead of Ruby strings because it allows us to use mmap
    # when it is available.
    def parse_file(*_arg0); end

    # Mirror the Prism.parse_file_comments API by using the serialization
    # API. This uses native strings instead of Ruby strings because it allows us
    # to use mmap when it is available.
    def parse_file_comments(*_arg0); end

    # Mirror the Prism.parse_file_failure? API by using the serialization API.
    #
    # @return [Boolean]
    def parse_file_failure?(*_arg0); end

    # Mirror the Prism.parse_file_success? API by using the serialization API.
    #
    # @return [Boolean]
    def parse_file_success?(*_arg0); end

    # Mirror the Prism.parse_lex API by using the serialization API.
    def parse_lex(*_arg0); end

    # Mirror the Prism.parse_lex_file API by using the serialization API.
    def parse_lex_file(*_arg0); end

    # Mirror the Prism.parse_stream API by using the serialization API.
    def parse_stream(*_arg0); end

    # Mirror the Prism.parse_success? API by using the serialization API.
    #
    # @return [Boolean]
    def parse_success?(*_arg0); end

    # Mirror the Prism.profile API by using the serialization API.
    def profile(*_arg0); end

    # Mirror the Prism.profile_file API by using the serialization API.
    def profile_file(*_arg0); end
  end
end

# Specialized version of Prism::Source for source code that includes ASCII
# characters only. This class is used to apply performance optimizations that
# cannot be applied to sources that include multibyte characters.
#
# In the extremely rare case that a source includes multi-byte characters but
# is marked as binary because of a magic encoding comment and it cannot be
# eagerly converted to UTF-8, this class will be used as well. This is because
# at that point we will treat everything as single-byte characters.
#
# source://prism//lib/prism/parse_result.rb#236
class Prism::ASCIISource < ::Prism::Source
  # Return the column number in characters for the given byte offset.
  #
  # source://prism//lib/prism/parse_result.rb#243
  sig { params(byte_offset: Integer).returns(Integer) }
  def character_column(byte_offset); end

  # Return the character offset for the given byte offset.
  #
  # source://prism//lib/prism/parse_result.rb#238
  sig { params(byte_offset: Integer).returns(Integer) }
  def character_offset(byte_offset); end

  # Returns a cache that is the identity function in order to maintain the
  # same interface. We can do this because code units are always equivalent to
  # byte offsets for ASCII-only sources.
  #
  # source://prism//lib/prism/parse_result.rb#260
  sig do
    params(
      encoding: Encoding
    ).returns(T.any(Prism::CodeUnitsCache, T.proc.params(byte_offset: Integer).returns(Integer)))
  end
  def code_units_cache(encoding); end

  # Specialized version of `code_units_column` that does not depend on
  # `code_units_offset`, which is a more expensive operation. This is
  # essentially the same as `Prism::Source#column`.
  #
  # source://prism//lib/prism/parse_result.rb#267
  sig { params(byte_offset: Integer, encoding: Encoding).returns(Integer) }
  def code_units_column(byte_offset, encoding); end

  # Returns the offset from the start of the file for the given byte offset
  # counting in code units for the given encoding.
  #
  # This method is tested with UTF-8, UTF-16, and UTF-32. If there is the
  # concept of code units that differs from the number of characters in other
  # encodings, it is not captured here.
  #
  # source://prism//lib/prism/parse_result.rb#253
  sig { params(byte_offset: Integer, encoding: Encoding).returns(Integer) }
  def code_units_offset(byte_offset, encoding); end
end

# Represents the use of the `alias` keyword to alias a global variable.
#
#     alias $foo $bar
#     ^^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#227
class Prism::AliasGlobalVariableNode < ::Prism::Node
  # Initialize a new AliasGlobalVariableNode node.
  #
  # @return [AliasGlobalVariableNode] a new instance of AliasGlobalVariableNode
  #
  # source://prism//lib/prism/node.rb#229
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      new_name: T.any(Prism::GlobalVariableReadNode, Prism::BackReferenceReadNode, Prism::NumberedReferenceReadNode),
      old_name: T.any(Prism::GlobalVariableReadNode, Prism::BackReferenceReadNode, Prism::NumberedReferenceReadNode, Prism::SymbolNode, Prism::MissingNode),
      keyword_loc: Prism::Location
    ).void
  end
  def initialize(source, node_id, location, flags, new_name, old_name, keyword_loc); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#316
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#240
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#245
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#255
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#250
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?new_name: GlobalVariableReadNode | BackReferenceReadNode | NumberedReferenceReadNode, ?old_name: GlobalVariableReadNode | BackReferenceReadNode | NumberedReferenceReadNode | SymbolNode | MissingNode, ?keyword_loc: Location) -> AliasGlobalVariableNode
  #
  # source://prism//lib/prism/node.rb#260
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      new_name: T.any(Prism::GlobalVariableReadNode, Prism::BackReferenceReadNode, Prism::NumberedReferenceReadNode),
      old_name: T.any(Prism::GlobalVariableReadNode, Prism::BackReferenceReadNode, Prism::NumberedReferenceReadNode, Prism::SymbolNode, Prism::MissingNode),
      keyword_loc: Prism::Location
    ).returns(Prism::AliasGlobalVariableNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), new_name: T.unsafe(nil), old_name: T.unsafe(nil), keyword_loc: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#245
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, new_name: GlobalVariableReadNode | BackReferenceReadNode | NumberedReferenceReadNode, old_name: GlobalVariableReadNode | BackReferenceReadNode | NumberedReferenceReadNode | SymbolNode | MissingNode, keyword_loc: Location }
  #
  # source://prism//lib/prism/node.rb#268
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#300
  sig { override.returns(String) }
  def inspect; end

  # def keyword: () -> String
  #
  # source://prism//lib/prism/node.rb#295
  sig { returns(String) }
  def keyword; end

  # The location of the `alias` keyword.
  #
  #     alias $foo $bar
  #     ^^^^^
  #
  # source://prism//lib/prism/node.rb#288
  sig { returns(Prism::Location) }
  def keyword_loc; end

  # Represents the new name of the global variable that can be used after aliasing.
  #
  #     alias $foo $bar
  #           ^^^^
  #
  # source://prism//lib/prism/node.rb#276
  sig { returns(T.any(Prism::GlobalVariableReadNode, Prism::BackReferenceReadNode, Prism::NumberedReferenceReadNode)) }
  def new_name; end

  # Represents the old name of the global variable that can be used before aliasing.
  #
  #     alias $foo $bar
  #                ^^^^
  #
  # source://prism//lib/prism/node.rb#282
  sig do
    returns(T.any(Prism::GlobalVariableReadNode, Prism::BackReferenceReadNode, Prism::NumberedReferenceReadNode, Prism::SymbolNode, Prism::MissingNode))
  end
  def old_name; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#305
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#310
    def type; end
  end
end

# Represents the use of the `alias` keyword to alias a method.
#
#     alias foo bar
#     ^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#328
class Prism::AliasMethodNode < ::Prism::Node
  # Initialize a new AliasMethodNode node.
  #
  # @return [AliasMethodNode] a new instance of AliasMethodNode
  #
  # source://prism//lib/prism/node.rb#330
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      new_name: T.any(Prism::SymbolNode, Prism::InterpolatedSymbolNode),
      old_name: T.any(Prism::SymbolNode, Prism::InterpolatedSymbolNode, Prism::GlobalVariableReadNode, Prism::MissingNode),
      keyword_loc: Prism::Location
    ).void
  end
  def initialize(source, node_id, location, flags, new_name, old_name, keyword_loc); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#426
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#341
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#346
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#356
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#351
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?new_name: SymbolNode | InterpolatedSymbolNode, ?old_name: SymbolNode | InterpolatedSymbolNode | GlobalVariableReadNode | MissingNode, ?keyword_loc: Location) -> AliasMethodNode
  #
  # source://prism//lib/prism/node.rb#361
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      new_name: T.any(Prism::SymbolNode, Prism::InterpolatedSymbolNode),
      old_name: T.any(Prism::SymbolNode, Prism::InterpolatedSymbolNode, Prism::GlobalVariableReadNode, Prism::MissingNode),
      keyword_loc: Prism::Location
    ).returns(Prism::AliasMethodNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), new_name: T.unsafe(nil), old_name: T.unsafe(nil), keyword_loc: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#346
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, new_name: SymbolNode | InterpolatedSymbolNode, old_name: SymbolNode | InterpolatedSymbolNode | GlobalVariableReadNode | MissingNode, keyword_loc: Location }
  #
  # source://prism//lib/prism/node.rb#369
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#410
  sig { override.returns(String) }
  def inspect; end

  # def keyword: () -> String
  #
  # source://prism//lib/prism/node.rb#405
  sig { returns(String) }
  def keyword; end

  # attr_reader keyword_loc: Location
  #
  # source://prism//lib/prism/node.rb#398
  sig { returns(Prism::Location) }
  def keyword_loc; end

  # Represents the new name of the method that will be aliased.
  #
  #     alias foo bar
  #           ^^^
  #
  #     alias :foo :bar
  #           ^^^^
  #
  #     alias :"#{foo}" :"#{bar}"
  #           ^^^^^^^^^
  #
  # source://prism//lib/prism/node.rb#383
  sig { returns(T.any(Prism::SymbolNode, Prism::InterpolatedSymbolNode)) }
  def new_name; end

  # Represents the old name of the method that will be aliased.
  #
  #     alias foo bar
  #               ^^^
  #
  #     alias :foo :bar
  #                ^^^^
  #
  #     alias :"#{foo}" :"#{bar}"
  #                     ^^^^^^^^^
  #
  # source://prism//lib/prism/node.rb#395
  sig do
    returns(T.any(Prism::SymbolNode, Prism::InterpolatedSymbolNode, Prism::GlobalVariableReadNode, Prism::MissingNode))
  end
  def old_name; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#415
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#420
    def type; end
  end
end

# Represents an alternation pattern in pattern matching.
#
#     foo => bar | baz
#            ^^^^^^^^^
#
# source://prism//lib/prism/node.rb#438
class Prism::AlternationPatternNode < ::Prism::Node
  # Initialize a new AlternationPatternNode node.
  #
  # @return [AlternationPatternNode] a new instance of AlternationPatternNode
  #
  # source://prism//lib/prism/node.rb#440
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      left: Prism::Node,
      right: Prism::Node,
      operator_loc: Prism::Location
    ).void
  end
  def initialize(source, node_id, location, flags, left, right, operator_loc); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#527
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#451
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#456
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#466
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#461
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?left: Prism::node, ?right: Prism::node, ?operator_loc: Location) -> AlternationPatternNode
  #
  # source://prism//lib/prism/node.rb#471
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      left: Prism::Node,
      right: Prism::Node,
      operator_loc: Prism::Location
    ).returns(Prism::AlternationPatternNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), left: T.unsafe(nil), right: T.unsafe(nil), operator_loc: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#456
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, left: Prism::node, right: Prism::node, operator_loc: Location }
  #
  # source://prism//lib/prism/node.rb#479
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#511
  sig { override.returns(String) }
  def inspect; end

  # Represents the left side of the expression.
  #
  #     foo => bar | baz
  #            ^^^
  #
  # source://prism//lib/prism/node.rb#487
  sig { returns(Prism::Node) }
  def left; end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#506
  sig { returns(String) }
  def operator; end

  # Represents the alternation operator location.
  #
  #     foo => bar | baz
  #                ^
  #
  # source://prism//lib/prism/node.rb#499
  sig { returns(Prism::Location) }
  def operator_loc; end

  # Represents the right side of the expression.
  #
  #     foo => bar | baz
  #                  ^^^
  #
  # source://prism//lib/prism/node.rb#493
  sig { returns(Prism::Node) }
  def right; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#516
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#521
    def type; end
  end
end

# Represents the use of the `&&` operator or the `and` keyword.
#
#     left and right
#     ^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#539
class Prism::AndNode < ::Prism::Node
  # Initialize a new AndNode node.
  #
  # @return [AndNode] a new instance of AndNode
  #
  # source://prism//lib/prism/node.rb#541
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      left: Prism::Node,
      right: Prism::Node,
      operator_loc: Prism::Location
    ).void
  end
  def initialize(source, node_id, location, flags, left, right, operator_loc); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#634
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#552
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#557
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#567
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#562
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?left: Prism::node, ?right: Prism::node, ?operator_loc: Location) -> AndNode
  #
  # source://prism//lib/prism/node.rb#572
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      left: Prism::Node,
      right: Prism::Node,
      operator_loc: Prism::Location
    ).returns(Prism::AndNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), left: T.unsafe(nil), right: T.unsafe(nil), operator_loc: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#557
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, left: Prism::node, right: Prism::node, operator_loc: Location }
  #
  # source://prism//lib/prism/node.rb#580
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#618
  sig { override.returns(String) }
  def inspect; end

  # Represents the left side of the expression. It can be any [non-void expression](https://github.com/ruby/prism/blob/main/docs/parsing_rules.md#non-void-expression).
  #
  #     left and right
  #     ^^^^
  #
  #     1 && 2
  #     ^
  #
  # source://prism//lib/prism/node.rb#591
  sig { returns(Prism::Node) }
  def left; end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#613
  sig { returns(String) }
  def operator; end

  # The location of the `and` keyword or the `&&` operator.
  #
  #     left and right
  #          ^^^
  #
  # source://prism//lib/prism/node.rb#606
  sig { returns(Prism::Location) }
  def operator_loc; end

  # Represents the right side of the expression.
  #
  #     left && right
  #             ^^^^^
  #
  #     1 and 2
  #           ^
  #
  # source://prism//lib/prism/node.rb#600
  sig { returns(Prism::Node) }
  def right; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#623
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#628
    def type; end
  end
end

# Represents a set of arguments to a method or a keyword.
#
#     return foo, bar, baz
#            ^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#646
class Prism::ArgumentsNode < ::Prism::Node
  # Initialize a new ArgumentsNode node.
  #
  # @return [ArgumentsNode] a new instance of ArgumentsNode
  #
  # source://prism//lib/prism/node.rb#648
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      arguments: T::Array[Prism::Node]
    ).void
  end
  def initialize(source, node_id, location, flags, arguments); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#734
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#657
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # attr_reader arguments: Array[Prism::node]
  #
  # source://prism//lib/prism/node.rb#715
  sig { returns(T::Array[Prism::Node]) }
  def arguments; end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#662
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#672
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#667
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def contains_forwarding?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#690
  sig { returns(T::Boolean) }
  def contains_forwarding?; end

  # def contains_keyword_splat?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#700
  sig { returns(T::Boolean) }
  def contains_keyword_splat?; end

  # def contains_keywords?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#695
  sig { returns(T::Boolean) }
  def contains_keywords?; end

  # def contains_multiple_splats?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#710
  sig { returns(T::Boolean) }
  def contains_multiple_splats?; end

  # def contains_splat?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#705
  sig { returns(T::Boolean) }
  def contains_splat?; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?arguments: Array[Prism::node]) -> ArgumentsNode
  #
  # source://prism//lib/prism/node.rb#677
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      arguments: T::Array[Prism::Node]
    ).returns(Prism::ArgumentsNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), arguments: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#662
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, arguments: Array[Prism::node] }
  #
  # source://prism//lib/prism/node.rb#685
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#718
  sig { override.returns(String) }
  def inspect; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#723
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#728
    def type; end
  end
end

# Flags for arguments nodes.
#
# source://prism//lib/prism/node.rb#16684
module Prism::ArgumentsNodeFlags; end

# if the arguments contain forwarding
#
# source://prism//lib/prism/node.rb#16686
Prism::ArgumentsNodeFlags::CONTAINS_FORWARDING = T.let(T.unsafe(nil), Integer)

# if the arguments contain keywords
#
# source://prism//lib/prism/node.rb#16689
Prism::ArgumentsNodeFlags::CONTAINS_KEYWORDS = T.let(T.unsafe(nil), Integer)

# if the arguments contain a keyword splat
#
# source://prism//lib/prism/node.rb#16692
Prism::ArgumentsNodeFlags::CONTAINS_KEYWORD_SPLAT = T.let(T.unsafe(nil), Integer)

# if the arguments contain multiple splats
#
# source://prism//lib/prism/node.rb#16698
Prism::ArgumentsNodeFlags::CONTAINS_MULTIPLE_SPLATS = T.let(T.unsafe(nil), Integer)

# if the arguments contain a splat
#
# source://prism//lib/prism/node.rb#16695
Prism::ArgumentsNodeFlags::CONTAINS_SPLAT = T.let(T.unsafe(nil), Integer)

# Represents an array literal. This can be a regular array using brackets or a special array using % like %w or %i.
#
#     [1, 2, 3]
#     ^^^^^^^^^
#
# source://prism//lib/prism/node.rb#746
class Prism::ArrayNode < ::Prism::Node
  # Initialize a new ArrayNode node.
  #
  # @return [ArrayNode] a new instance of ArrayNode
  #
  # source://prism//lib/prism/node.rb#748
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      elements: T::Array[Prism::Node],
      opening_loc: T.nilable(Prism::Location),
      closing_loc: T.nilable(Prism::Location)
    ).void
  end
  def initialize(source, node_id, location, flags, elements, opening_loc, closing_loc); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#862
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#759
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#764
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def closing: () -> String?
  #
  # source://prism//lib/prism/node.rb#841
  sig { returns(T.nilable(String)) }
  def closing; end

  # Represents the optional source location for the closing token.
  #
  #     [1,2,3]                 # "]"
  #     %w[foo bar baz]         # "]"
  #     %I(apple orange banana) # ")"
  #     foo = 1, 2, 3           # nil
  #
  # source://prism//lib/prism/node.rb#823
  sig { returns(T.nilable(Prism::Location)) }
  def closing_loc; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#774
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#769
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def contains_splat?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#792
  sig { returns(T::Boolean) }
  def contains_splat?; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?elements: Array[Prism::node], ?opening_loc: Location?, ?closing_loc: Location?) -> ArrayNode
  #
  # source://prism//lib/prism/node.rb#779
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      elements: T::Array[Prism::Node],
      opening_loc: T.nilable(Prism::Location),
      closing_loc: T.nilable(Prism::Location)
    ).returns(Prism::ArrayNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), elements: T.unsafe(nil), opening_loc: T.unsafe(nil), closing_loc: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#764
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, elements: Array[Prism::node], opening_loc: Location?, closing_loc: Location? }
  #
  # source://prism//lib/prism/node.rb#787
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # Represent the list of zero or more [non-void expressions](https://github.com/ruby/prism/blob/main/docs/parsing_rules.md#non-void-expression) within the array.
  #
  # source://prism//lib/prism/node.rb#797
  sig { returns(T::Array[Prism::Node]) }
  def elements; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#846
  sig { override.returns(String) }
  def inspect; end

  # def opening: () -> String?
  #
  # source://prism//lib/prism/node.rb#836
  sig { returns(T.nilable(String)) }
  def opening; end

  # Represents the optional source location for the opening token.
  #
  #     [1,2,3]                 # "["
  #     %w[foo bar baz]         # "%w["
  #     %I(apple orange banana) # "%I("
  #     foo = 1, 2, 3           # nil
  #
  # source://prism//lib/prism/node.rb#805
  sig { returns(T.nilable(Prism::Location)) }
  def opening_loc; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#851
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#856
    def type; end
  end
end

# Flags for array nodes.
#
# source://prism//lib/prism/node.rb#16702
module Prism::ArrayNodeFlags; end

# if array contains splat nodes
#
# source://prism//lib/prism/node.rb#16704
Prism::ArrayNodeFlags::CONTAINS_SPLAT = T.let(T.unsafe(nil), Integer)

# Represents an array pattern in pattern matching.
#
#     foo in 1, 2
#     ^^^^^^^^^^^
#
#     foo in [1, 2]
#     ^^^^^^^^^^^^^
#
#     foo in *1
#     ^^^^^^^^^
#
#     foo in Bar[]
#     ^^^^^^^^^^^^
#
#     foo in Bar[1, 2, 3]
#     ^^^^^^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#888
class Prism::ArrayPatternNode < ::Prism::Node
  # Initialize a new ArrayPatternNode node.
  #
  # @return [ArrayPatternNode] a new instance of ArrayPatternNode
  #
  # source://prism//lib/prism/node.rb#890
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      constant: T.nilable(T.any(Prism::ConstantReadNode, Prism::ConstantPathNode)),
      requireds: T::Array[Prism::Node],
      rest: T.nilable(Prism::Node),
      posts: T::Array[Prism::Node],
      opening_loc: T.nilable(Prism::Location),
      closing_loc: T.nilable(Prism::Location)
    ).void
  end
  def initialize(source, node_id, location, flags, constant, requireds, rest, posts, opening_loc, closing_loc); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#1006
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#904
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#909
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def closing: () -> String?
  #
  # source://prism//lib/prism/node.rb#985
  sig { returns(T.nilable(String)) }
  def closing; end

  # attr_reader closing_loc: Location?
  #
  # source://prism//lib/prism/node.rb#967
  sig { returns(T.nilable(Prism::Location)) }
  def closing_loc; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#924
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#914
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # attr_reader constant: ConstantReadNode | ConstantPathNode | nil
  #
  # source://prism//lib/prism/node.rb#942
  sig { returns(T.nilable(T.any(Prism::ConstantReadNode, Prism::ConstantPathNode))) }
  def constant; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?constant: ConstantReadNode | ConstantPathNode | nil, ?requireds: Array[Prism::node], ?rest: Prism::node?, ?posts: Array[Prism::node], ?opening_loc: Location?, ?closing_loc: Location?) -> ArrayPatternNode
  #
  # source://prism//lib/prism/node.rb#929
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      constant: T.nilable(T.any(Prism::ConstantReadNode, Prism::ConstantPathNode)),
      requireds: T::Array[Prism::Node],
      rest: T.nilable(Prism::Node),
      posts: T::Array[Prism::Node],
      opening_loc: T.nilable(Prism::Location),
      closing_loc: T.nilable(Prism::Location)
    ).returns(Prism::ArrayPatternNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), constant: T.unsafe(nil), requireds: T.unsafe(nil), rest: T.unsafe(nil), posts: T.unsafe(nil), opening_loc: T.unsafe(nil), closing_loc: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#909
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, constant: ConstantReadNode | ConstantPathNode | nil, requireds: Array[Prism::node], rest: Prism::node?, posts: Array[Prism::node], opening_loc: Location?, closing_loc: Location? }
  #
  # source://prism//lib/prism/node.rb#937
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#990
  sig { override.returns(String) }
  def inspect; end

  # def opening: () -> String?
  #
  # source://prism//lib/prism/node.rb#980
  sig { returns(T.nilable(String)) }
  def opening; end

  # attr_reader opening_loc: Location?
  #
  # source://prism//lib/prism/node.rb#954
  sig { returns(T.nilable(Prism::Location)) }
  def opening_loc; end

  # attr_reader posts: Array[Prism::node]
  #
  # source://prism//lib/prism/node.rb#951
  sig { returns(T::Array[Prism::Node]) }
  def posts; end

  # attr_reader requireds: Array[Prism::node]
  #
  # source://prism//lib/prism/node.rb#945
  sig { returns(T::Array[Prism::Node]) }
  def requireds; end

  # attr_reader rest: Prism::node?
  #
  # source://prism//lib/prism/node.rb#948
  sig { returns(T.nilable(Prism::Node)) }
  def rest; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#995
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#1000
    def type; end
  end
end

# Represents a hash key/value pair.
#
#     { a => b }
#       ^^^^^^
#
# source://prism//lib/prism/node.rb#1023
class Prism::AssocNode < ::Prism::Node
  # Initialize a new AssocNode node.
  #
  # @return [AssocNode] a new instance of AssocNode
  #
  # source://prism//lib/prism/node.rb#1025
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      key: Prism::Node,
      value: Prism::Node,
      operator_loc: T.nilable(Prism::Location)
    ).void
  end
  def initialize(source, node_id, location, flags, key, value, operator_loc); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#1127
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#1036
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#1041
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#1051
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#1046
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?key: Prism::node, ?value: Prism::node, ?operator_loc: Location?) -> AssocNode
  #
  # source://prism//lib/prism/node.rb#1056
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      key: Prism::Node,
      value: Prism::Node,
      operator_loc: T.nilable(Prism::Location)
    ).returns(Prism::AssocNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), key: T.unsafe(nil), value: T.unsafe(nil), operator_loc: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#1041
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, key: Prism::node, value: Prism::node, operator_loc: Location? }
  #
  # source://prism//lib/prism/node.rb#1064
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#1111
  sig { override.returns(String) }
  def inspect; end

  # The key of the association. This can be any [non-void expression](https://github.com/ruby/prism/blob/main/docs/parsing_rules.md#non-void-expression).
  #
  #     { a: b }
  #       ^
  #
  #     { foo => bar }
  #       ^^^
  #
  #     { def a; end => 1 }
  #       ^^^^^^^^^^
  #
  # source://prism//lib/prism/node.rb#1078
  sig { returns(Prism::Node) }
  def key; end

  # def operator: () -> String?
  #
  # source://prism//lib/prism/node.rb#1106
  sig { returns(T.nilable(String)) }
  def operator; end

  # The location of the `=>` operator, if present.
  #
  #     { foo => bar }
  #           ^^
  #
  # source://prism//lib/prism/node.rb#1093
  sig { returns(T.nilable(Prism::Location)) }
  def operator_loc; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#1116
  sig { override.returns(Symbol) }
  def type; end

  # The value of the association, if present. This can be any [non-void expression](https://github.com/ruby/prism/blob/main/docs/parsing_rules.md#non-void-expression).
  #
  #     { foo => bar }
  #              ^^^
  #
  #     { x: 1 }
  #          ^
  #
  # source://prism//lib/prism/node.rb#1087
  sig { returns(Prism::Node) }
  def value; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#1121
    def type; end
  end
end

# Represents a splat in a hash literal.
#
#     { **foo }
#       ^^^^^
#
# source://prism//lib/prism/node.rb#1139
class Prism::AssocSplatNode < ::Prism::Node
  # Initialize a new AssocSplatNode node.
  #
  # @return [AssocSplatNode] a new instance of AssocSplatNode
  #
  # source://prism//lib/prism/node.rb#1141
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      value: T.nilable(Prism::Node),
      operator_loc: Prism::Location
    ).void
  end
  def initialize(source, node_id, location, flags, value, operator_loc); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#1223
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#1151
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#1156
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#1168
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#1161
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?value: Prism::node?, ?operator_loc: Location) -> AssocSplatNode
  #
  # source://prism//lib/prism/node.rb#1173
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      value: T.nilable(Prism::Node),
      operator_loc: Prism::Location
    ).returns(Prism::AssocSplatNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), value: T.unsafe(nil), operator_loc: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#1156
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, value: Prism::node?, operator_loc: Location }
  #
  # source://prism//lib/prism/node.rb#1181
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#1207
  sig { override.returns(String) }
  def inspect; end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#1202
  sig { returns(String) }
  def operator; end

  # The location of the `**` operator.
  #
  #     { **x }
  #       ^^
  #
  # source://prism//lib/prism/node.rb#1195
  sig { returns(Prism::Location) }
  def operator_loc; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#1212
  sig { override.returns(Symbol) }
  def type; end

  # The value to be splatted, if present. Will be missing when keyword rest argument forwarding is used.
  #
  #     { **foo }
  #         ^^^
  #
  # source://prism//lib/prism/node.rb#1189
  sig { returns(T.nilable(Prism::Node)) }
  def value; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#1217
    def type; end
  end
end

# The FFI backend is used on other Ruby implementations.
#
# source://prism//lib/prism.rb#81
Prism::BACKEND = T.let(T.unsafe(nil), Symbol)

# Represents reading a reference to a field in the previous match.
#
#     $'
#     ^^
#
# source://prism//lib/prism/node.rb#1234
class Prism::BackReferenceReadNode < ::Prism::Node
  # Initialize a new BackReferenceReadNode node.
  #
  # @return [BackReferenceReadNode] a new instance of BackReferenceReadNode
  #
  # source://prism//lib/prism/node.rb#1236
  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol).void }
  def initialize(source, node_id, location, flags, name); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#1301
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#1245
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#1250
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#1260
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#1255
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?name: Symbol) -> BackReferenceReadNode
  #
  # source://prism//lib/prism/node.rb#1265
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol
    ).returns(Prism::BackReferenceReadNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#1250
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, name: Symbol }
  #
  # source://prism//lib/prism/node.rb#1273
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#1285
  sig { override.returns(String) }
  def inspect; end

  # The name of the back-reference variable, including the leading `$`.
  #
  #     $& # name `:$&`
  #
  #     $+ # name `:$+`
  #
  # source://prism//lib/prism/node.rb#1282
  sig { returns(Symbol) }
  def name; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#1290
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#1295
    def type; end
  end
end

# A class that knows how to walk down the tree. None of the individual visit
# methods are implemented on this visitor, so it forces the consumer to
# implement each one that they need. For a default implementation that
# continues walking the tree, see the Visitor class.
#
# source://prism//lib/prism/visitor.rb#14
class Prism::BasicVisitor
  # Calls `accept` on the given node if it is not `nil`, which in turn should
  # call back into this visitor by calling the appropriate `visit_*` method.
  #
  # source://prism//lib/prism/visitor.rb#17
  sig { params(node: T.nilable(Prism::Node)).void }
  def visit(node); end

  # Visits each node in `nodes` by calling `accept` on each one.
  #
  # source://prism//lib/prism/visitor.rb#23
  sig { params(nodes: T::Array[T.nilable(Prism::Node)]).void }
  def visit_all(nodes); end

  # Visits the child nodes of `node` by calling `accept` on each one.
  #
  # source://prism//lib/prism/visitor.rb#29
  sig { params(node: Prism::Node).void }
  def visit_child_nodes(node); end
end

# Represents a begin statement.
#
#     begin
#       foo
#     end
#     ^^^^^
#
# source://prism//lib/prism/node.rb#1313
class Prism::BeginNode < ::Prism::Node
  # Initialize a new BeginNode node.
  #
  # @return [BeginNode] a new instance of BeginNode
  #
  # source://prism//lib/prism/node.rb#1315
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      begin_keyword_loc: T.nilable(Prism::Location),
      statements: T.nilable(Prism::StatementsNode),
      rescue_clause: T.nilable(Prism::RescueNode),
      else_clause: T.nilable(Prism::ElseNode),
      ensure_clause: T.nilable(Prism::EnsureNode),
      end_keyword_loc: T.nilable(Prism::Location)
    ).void
  end
  def initialize(source, node_id, location, flags, begin_keyword_loc, statements, rescue_clause, else_clause, ensure_clause, end_keyword_loc); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#1431
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#1329
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def begin_keyword: () -> String?
  #
  # source://prism//lib/prism/node.rb#1405
  sig { returns(T.nilable(String)) }
  def begin_keyword; end

  # attr_reader begin_keyword_loc: Location?
  #
  # source://prism//lib/prism/node.rb#1367
  sig { returns(T.nilable(Prism::Location)) }
  def begin_keyword_loc; end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#1334
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#1349
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#1339
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?begin_keyword_loc: Location?, ?statements: StatementsNode?, ?rescue_clause: RescueNode?, ?else_clause: ElseNode?, ?ensure_clause: EnsureNode?, ?end_keyword_loc: Location?) -> BeginNode
  #
  # source://prism//lib/prism/node.rb#1354
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      begin_keyword_loc: T.nilable(Prism::Location),
      statements: T.nilable(Prism::StatementsNode),
      rescue_clause: T.nilable(Prism::RescueNode),
      else_clause: T.nilable(Prism::ElseNode),
      ensure_clause: T.nilable(Prism::EnsureNode),
      end_keyword_loc: T.nilable(Prism::Location)
    ).returns(Prism::BeginNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), begin_keyword_loc: T.unsafe(nil), statements: T.unsafe(nil), rescue_clause: T.unsafe(nil), else_clause: T.unsafe(nil), ensure_clause: T.unsafe(nil), end_keyword_loc: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#1334
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, begin_keyword_loc: Location?, statements: StatementsNode?, rescue_clause: RescueNode?, else_clause: ElseNode?, ensure_clause: EnsureNode?, end_keyword_loc: Location? }
  #
  # source://prism//lib/prism/node.rb#1362
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # attr_reader else_clause: ElseNode?
  #
  # source://prism//lib/prism/node.rb#1386
  sig { returns(T.nilable(Prism::ElseNode)) }
  def else_clause; end

  # def end_keyword: () -> String?
  #
  # source://prism//lib/prism/node.rb#1410
  sig { returns(T.nilable(String)) }
  def end_keyword; end

  # attr_reader end_keyword_loc: Location?
  #
  # source://prism//lib/prism/node.rb#1392
  sig { returns(T.nilable(Prism::Location)) }
  def end_keyword_loc; end

  # attr_reader ensure_clause: EnsureNode?
  #
  # source://prism//lib/prism/node.rb#1389
  sig { returns(T.nilable(Prism::EnsureNode)) }
  def ensure_clause; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#1415
  sig { override.returns(String) }
  def inspect; end

  # source://prism//lib/prism/parse_result/newlines.rb#79
  def newline_flag!(lines); end

  # attr_reader rescue_clause: RescueNode?
  #
  # source://prism//lib/prism/node.rb#1383
  sig { returns(T.nilable(Prism::RescueNode)) }
  def rescue_clause; end

  # attr_reader statements: StatementsNode?
  #
  # source://prism//lib/prism/node.rb#1380
  sig { returns(T.nilable(Prism::StatementsNode)) }
  def statements; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#1420
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#1425
    def type; end
  end
end

# Represents a block argument using `&`.
#
#     bar(&args)
#     ^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#1446
class Prism::BlockArgumentNode < ::Prism::Node
  # Initialize a new BlockArgumentNode node.
  #
  # @return [BlockArgumentNode] a new instance of BlockArgumentNode
  #
  # source://prism//lib/prism/node.rb#1448
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      expression: T.nilable(Prism::Node),
      operator_loc: Prism::Location
    ).void
  end
  def initialize(source, node_id, location, flags, expression, operator_loc); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#1524
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#1458
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#1463
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#1475
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#1468
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?expression: Prism::node?, ?operator_loc: Location) -> BlockArgumentNode
  #
  # source://prism//lib/prism/node.rb#1480
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      expression: T.nilable(Prism::Node),
      operator_loc: Prism::Location
    ).returns(Prism::BlockArgumentNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), expression: T.unsafe(nil), operator_loc: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#1463
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, expression: Prism::node?, operator_loc: Location }
  #
  # source://prism//lib/prism/node.rb#1488
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # attr_reader expression: Prism::node?
  #
  # source://prism//lib/prism/node.rb#1493
  sig { returns(T.nilable(Prism::Node)) }
  def expression; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#1508
  sig { override.returns(String) }
  def inspect; end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#1503
  sig { returns(String) }
  def operator; end

  # attr_reader operator_loc: Location
  #
  # source://prism//lib/prism/node.rb#1496
  sig { returns(Prism::Location) }
  def operator_loc; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#1513
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#1518
    def type; end
  end
end

# Represents a block local variable.
#
#     a { |; b| }
#            ^
#
# source://prism//lib/prism/node.rb#1535
class Prism::BlockLocalVariableNode < ::Prism::Node
  # Initialize a new BlockLocalVariableNode node.
  #
  # @return [BlockLocalVariableNode] a new instance of BlockLocalVariableNode
  #
  # source://prism//lib/prism/node.rb#1537
  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol).void }
  def initialize(source, node_id, location, flags, name); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#1603
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#1546
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#1551
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#1561
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#1556
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?name: Symbol) -> BlockLocalVariableNode
  #
  # source://prism//lib/prism/node.rb#1566
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol
    ).returns(Prism::BlockLocalVariableNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#1551
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, name: Symbol }
  #
  # source://prism//lib/prism/node.rb#1574
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#1587
  sig { override.returns(String) }
  def inspect; end

  # attr_reader name: Symbol
  #
  # source://prism//lib/prism/node.rb#1584
  sig { returns(Symbol) }
  def name; end

  # def repeated_parameter?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#1579
  sig { returns(T::Boolean) }
  def repeated_parameter?; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#1592
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#1597
    def type; end
  end
end

# Represents a block of ruby code.
#
#     [1, 2, 3].each { |i| puts x }
#                    ^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#1614
class Prism::BlockNode < ::Prism::Node
  # Initialize a new BlockNode node.
  #
  # @return [BlockNode] a new instance of BlockNode
  #
  # source://prism//lib/prism/node.rb#1616
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      locals: T::Array[Symbol],
      parameters: T.nilable(T.any(Prism::BlockParametersNode, Prism::NumberedParametersNode, Prism::ItParametersNode)),
      body: T.nilable(T.any(Prism::StatementsNode, Prism::BeginNode)),
      opening_loc: Prism::Location,
      closing_loc: Prism::Location
    ).void
  end
  def initialize(source, node_id, location, flags, locals, parameters, body, opening_loc, closing_loc); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#1714
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#1629
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # attr_reader body: StatementsNode | BeginNode | nil
  #
  # source://prism//lib/prism/node.rb#1671
  sig { returns(T.nilable(T.any(Prism::StatementsNode, Prism::BeginNode))) }
  def body; end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#1634
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def closing: () -> String
  #
  # source://prism//lib/prism/node.rb#1693
  sig { returns(String) }
  def closing; end

  # attr_reader closing_loc: Location
  #
  # source://prism//lib/prism/node.rb#1681
  sig { returns(Prism::Location) }
  def closing_loc; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#1647
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#1639
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?locals: Array[Symbol], ?parameters: BlockParametersNode | NumberedParametersNode | ItParametersNode | nil, ?body: StatementsNode | BeginNode | nil, ?opening_loc: Location, ?closing_loc: Location) -> BlockNode
  #
  # source://prism//lib/prism/node.rb#1652
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      locals: T::Array[Symbol],
      parameters: T.nilable(T.any(Prism::BlockParametersNode, Prism::NumberedParametersNode, Prism::ItParametersNode)),
      body: T.nilable(T.any(Prism::StatementsNode, Prism::BeginNode)),
      opening_loc: Prism::Location,
      closing_loc: Prism::Location
    ).returns(Prism::BlockNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), locals: T.unsafe(nil), parameters: T.unsafe(nil), body: T.unsafe(nil), opening_loc: T.unsafe(nil), closing_loc: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#1634
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, locals: Array[Symbol], parameters: BlockParametersNode | NumberedParametersNode | ItParametersNode | nil, body: StatementsNode | BeginNode | nil, opening_loc: Location, closing_loc: Location }
  #
  # source://prism//lib/prism/node.rb#1660
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#1698
  sig { override.returns(String) }
  def inspect; end

  # attr_reader locals: Array[Symbol]
  #
  # source://prism//lib/prism/node.rb#1665
  sig { returns(T::Array[Symbol]) }
  def locals; end

  # def opening: () -> String
  #
  # source://prism//lib/prism/node.rb#1688
  sig { returns(String) }
  def opening; end

  # attr_reader opening_loc: Location
  #
  # source://prism//lib/prism/node.rb#1674
  sig { returns(Prism::Location) }
  def opening_loc; end

  # attr_reader parameters: BlockParametersNode | NumberedParametersNode | ItParametersNode | nil
  #
  # source://prism//lib/prism/node.rb#1668
  sig { returns(T.nilable(T.any(Prism::BlockParametersNode, Prism::NumberedParametersNode, Prism::ItParametersNode))) }
  def parameters; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#1703
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#1708
    def type; end
  end
end

# Represents a block parameter of a method, block, or lambda definition.
#
#     def a(&b)
#           ^^
#     end
#
# source://prism//lib/prism/node.rb#1730
class Prism::BlockParameterNode < ::Prism::Node
  # Initialize a new BlockParameterNode node.
  #
  # @return [BlockParameterNode] a new instance of BlockParameterNode
  #
  # source://prism//lib/prism/node.rb#1732
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: T.nilable(Symbol),
      name_loc: T.nilable(Prism::Location),
      operator_loc: Prism::Location
    ).void
  end
  def initialize(source, node_id, location, flags, name, name_loc, operator_loc); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#1825
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#1743
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#1748
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#1758
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#1753
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?name: Symbol?, ?name_loc: Location?, ?operator_loc: Location) -> BlockParameterNode
  #
  # source://prism//lib/prism/node.rb#1763
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: T.nilable(Symbol),
      name_loc: T.nilable(Prism::Location),
      operator_loc: Prism::Location
    ).returns(Prism::BlockParameterNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil), name_loc: T.unsafe(nil), operator_loc: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#1748
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, name: Symbol?, name_loc: Location?, operator_loc: Location }
  #
  # source://prism//lib/prism/node.rb#1771
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#1809
  sig { override.returns(String) }
  def inspect; end

  # attr_reader name: Symbol?
  #
  # source://prism//lib/prism/node.rb#1781
  sig { returns(T.nilable(Symbol)) }
  def name; end

  # attr_reader name_loc: Location?
  #
  # source://prism//lib/prism/node.rb#1784
  sig { returns(T.nilable(Prism::Location)) }
  def name_loc; end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#1804
  sig { returns(String) }
  def operator; end

  # attr_reader operator_loc: Location
  #
  # source://prism//lib/prism/node.rb#1797
  sig { returns(Prism::Location) }
  def operator_loc; end

  # def repeated_parameter?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#1776
  sig { returns(T::Boolean) }
  def repeated_parameter?; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#1814
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#1819
    def type; end
  end
end

# Represents a block's parameters declaration.
#
#     -> (a, b = 1; local) { }
#        ^^^^^^^^^^^^^^^^^
#
#     foo do |a, b = 1; local|
#            ^^^^^^^^^^^^^^^^^
#     end
#
# source://prism//lib/prism/node.rb#1842
class Prism::BlockParametersNode < ::Prism::Node
  # Initialize a new BlockParametersNode node.
  #
  # @return [BlockParametersNode] a new instance of BlockParametersNode
  #
  # source://prism//lib/prism/node.rb#1844
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      parameters: T.nilable(Prism::ParametersNode),
      locals: T::Array[Prism::BlockLocalVariableNode],
      opening_loc: T.nilable(Prism::Location),
      closing_loc: T.nilable(Prism::Location)
    ).void
  end
  def initialize(source, node_id, location, flags, parameters, locals, opening_loc, closing_loc); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#1950
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#1856
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#1861
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def closing: () -> String?
  #
  # source://prism//lib/prism/node.rb#1929
  sig { returns(T.nilable(String)) }
  def closing; end

  # attr_reader closing_loc: Location?
  #
  # source://prism//lib/prism/node.rb#1911
  sig { returns(T.nilable(Prism::Location)) }
  def closing_loc; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#1874
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#1866
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?parameters: ParametersNode?, ?locals: Array[BlockLocalVariableNode], ?opening_loc: Location?, ?closing_loc: Location?) -> BlockParametersNode
  #
  # source://prism//lib/prism/node.rb#1879
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      parameters: T.nilable(Prism::ParametersNode),
      locals: T::Array[Prism::BlockLocalVariableNode],
      opening_loc: T.nilable(Prism::Location),
      closing_loc: T.nilable(Prism::Location)
    ).returns(Prism::BlockParametersNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), parameters: T.unsafe(nil), locals: T.unsafe(nil), opening_loc: T.unsafe(nil), closing_loc: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#1861
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, parameters: ParametersNode?, locals: Array[BlockLocalVariableNode], opening_loc: Location?, closing_loc: Location? }
  #
  # source://prism//lib/prism/node.rb#1887
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#1934
  sig { override.returns(String) }
  def inspect; end

  # attr_reader locals: Array[BlockLocalVariableNode]
  #
  # source://prism//lib/prism/node.rb#1895
  sig { returns(T::Array[Prism::BlockLocalVariableNode]) }
  def locals; end

  # def opening: () -> String?
  #
  # source://prism//lib/prism/node.rb#1924
  sig { returns(T.nilable(String)) }
  def opening; end

  # attr_reader opening_loc: Location?
  #
  # source://prism//lib/prism/node.rb#1898
  sig { returns(T.nilable(Prism::Location)) }
  def opening_loc; end

  # attr_reader parameters: ParametersNode?
  #
  # source://prism//lib/prism/node.rb#1892
  sig { returns(T.nilable(Prism::ParametersNode)) }
  def parameters; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#1939
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#1944
    def type; end
  end
end

# Represents the use of the `break` keyword.
#
#     break foo
#     ^^^^^^^^^
#
# source://prism//lib/prism/node.rb#1964
class Prism::BreakNode < ::Prism::Node
  # Initialize a new BreakNode node.
  #
  # @return [BreakNode] a new instance of BreakNode
  #
  # source://prism//lib/prism/node.rb#1966
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      arguments: T.nilable(Prism::ArgumentsNode),
      keyword_loc: Prism::Location
    ).void
  end
  def initialize(source, node_id, location, flags, arguments, keyword_loc); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#2048
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#1976
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # The arguments to the break statement, if present. These can be any [non-void expressions](https://github.com/ruby/prism/blob/main/docs/parsing_rules.md#non-void-expression).
  #
  #     break foo
  #           ^^^
  #
  # source://prism//lib/prism/node.rb#2014
  sig { returns(T.nilable(Prism::ArgumentsNode)) }
  def arguments; end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#1981
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#1993
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#1986
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?arguments: ArgumentsNode?, ?keyword_loc: Location) -> BreakNode
  #
  # source://prism//lib/prism/node.rb#1998
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      arguments: T.nilable(Prism::ArgumentsNode),
      keyword_loc: Prism::Location
    ).returns(Prism::BreakNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), arguments: T.unsafe(nil), keyword_loc: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#1981
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, arguments: ArgumentsNode?, keyword_loc: Location }
  #
  # source://prism//lib/prism/node.rb#2006
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#2032
  sig { override.returns(String) }
  def inspect; end

  # def keyword: () -> String
  #
  # source://prism//lib/prism/node.rb#2027
  sig { returns(String) }
  def keyword; end

  # The location of the `break` keyword.
  #
  #     break foo
  #     ^^^^^
  #
  # source://prism//lib/prism/node.rb#2020
  sig { returns(Prism::Location) }
  def keyword_loc; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#2037
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#2042
    def type; end
  end
end

# Represents the use of the `&&=` operator on a call.
#
#     foo.bar &&= value
#     ^^^^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#2059
class Prism::CallAndWriteNode < ::Prism::Node
  # Initialize a new CallAndWriteNode node.
  #
  # @return [CallAndWriteNode] a new instance of CallAndWriteNode
  #
  # source://prism//lib/prism/node.rb#2061
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      receiver: T.nilable(Prism::Node),
      call_operator_loc: T.nilable(Prism::Location),
      message_loc: T.nilable(Prism::Location),
      read_name: Symbol,
      write_name: Symbol,
      operator_loc: Prism::Location,
      value: Prism::Node
    ).void
  end
  def initialize(source, node_id, location, flags, receiver, call_operator_loc, message_loc, read_name, write_name, operator_loc, value); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#2208
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#2076
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def attribute_write?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#2122
  sig { returns(T::Boolean) }
  def attribute_write?; end

  # def call_operator: () -> String?
  #
  # source://prism//lib/prism/node.rb#2177
  sig { returns(T.nilable(String)) }
  def call_operator; end

  # attr_reader call_operator_loc: Location?
  #
  # source://prism//lib/prism/node.rb#2135
  sig { returns(T.nilable(Prism::Location)) }
  def call_operator_loc; end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#2081
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#2094
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#2086
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?receiver: Prism::node?, ?call_operator_loc: Location?, ?message_loc: Location?, ?read_name: Symbol, ?write_name: Symbol, ?operator_loc: Location, ?value: Prism::node) -> CallAndWriteNode
  #
  # source://prism//lib/prism/node.rb#2099
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      receiver: T.nilable(Prism::Node),
      call_operator_loc: T.nilable(Prism::Location),
      message_loc: T.nilable(Prism::Location),
      read_name: Symbol,
      write_name: Symbol,
      operator_loc: Prism::Location,
      value: Prism::Node
    ).returns(Prism::CallAndWriteNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), receiver: T.unsafe(nil), call_operator_loc: T.unsafe(nil), message_loc: T.unsafe(nil), read_name: T.unsafe(nil), write_name: T.unsafe(nil), operator_loc: T.unsafe(nil), value: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#2081
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, receiver: Prism::node?, call_operator_loc: Location?, message_loc: Location?, read_name: Symbol, write_name: Symbol, operator_loc: Location, value: Prism::node }
  #
  # source://prism//lib/prism/node.rb#2107
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def ignore_visibility?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#2127
  sig { returns(T::Boolean) }
  def ignore_visibility?; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#2192
  sig { override.returns(String) }
  def inspect; end

  # def message: () -> String?
  #
  # source://prism//lib/prism/node.rb#2182
  sig { returns(T.nilable(String)) }
  def message; end

  # attr_reader message_loc: Location?
  #
  # source://prism//lib/prism/node.rb#2148
  sig { returns(T.nilable(Prism::Location)) }
  def message_loc; end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#2187
  sig { returns(String) }
  def operator; end

  # attr_reader operator_loc: Location
  #
  # source://prism//lib/prism/node.rb#2167
  sig { returns(Prism::Location) }
  def operator_loc; end

  # attr_reader read_name: Symbol
  #
  # source://prism//lib/prism/node.rb#2161
  sig { returns(Symbol) }
  def read_name; end

  # attr_reader receiver: Prism::node?
  #
  # source://prism//lib/prism/node.rb#2132
  sig { returns(T.nilable(Prism::Node)) }
  def receiver; end

  # def safe_navigation?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#2112
  sig { returns(T::Boolean) }
  def safe_navigation?; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#2197
  sig { override.returns(Symbol) }
  def type; end

  # attr_reader value: Prism::node
  #
  # source://prism//lib/prism/node.rb#2174
  sig { returns(Prism::Node) }
  def value; end

  # def variable_call?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#2117
  sig { returns(T::Boolean) }
  def variable_call?; end

  # attr_reader write_name: Symbol
  #
  # source://prism//lib/prism/node.rb#2164
  sig { returns(Symbol) }
  def write_name; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#2202
    def type; end
  end
end

# Represents a method call, in all of the various forms that can take.
#
#     foo
#     ^^^
#
#     foo()
#     ^^^^^
#
#     +foo
#     ^^^^
#
#     foo + bar
#     ^^^^^^^^^
#
#     foo.bar
#     ^^^^^^^
#
#     foo&.bar
#     ^^^^^^^^
#
# source://prism//lib/prism/node.rb#2240
class Prism::CallNode < ::Prism::Node
  # Initialize a new CallNode node.
  #
  # @return [CallNode] a new instance of CallNode
  #
  # source://prism//lib/prism/node.rb#2242
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      receiver: T.nilable(Prism::Node),
      call_operator_loc: T.nilable(Prism::Location),
      name: Symbol,
      message_loc: T.nilable(Prism::Location),
      opening_loc: T.nilable(Prism::Location),
      arguments: T.nilable(Prism::ArgumentsNode),
      closing_loc: T.nilable(Prism::Location),
      block: T.nilable(T.any(Prism::BlockNode, Prism::BlockArgumentNode))
    ).void
  end
  def initialize(source, node_id, location, flags, receiver, call_operator_loc, name, message_loc, opening_loc, arguments, closing_loc, block); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#2424
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#2258
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # attr_reader arguments: ArgumentsNode?
  #
  # source://prism//lib/prism/node.rb#2369
  sig { returns(T.nilable(Prism::ArgumentsNode)) }
  def arguments; end

  # def attribute_write?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#2305
  sig { returns(T::Boolean) }
  def attribute_write?; end

  # attr_reader block: BlockNode | BlockArgumentNode | nil
  #
  # source://prism//lib/prism/node.rb#2385
  sig { returns(T.nilable(T.any(Prism::BlockNode, Prism::BlockArgumentNode))) }
  def block; end

  # def call_operator: () -> String?
  #
  # source://prism//lib/prism/node.rb#2388
  sig { returns(T.nilable(String)) }
  def call_operator; end

  # attr_reader call_operator_loc: Location?
  #
  # source://prism//lib/prism/node.rb#2327
  sig { returns(T.nilable(Prism::Location)) }
  def call_operator_loc; end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#2263
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def closing: () -> String?
  #
  # source://prism//lib/prism/node.rb#2403
  sig { returns(T.nilable(String)) }
  def closing; end

  # attr_reader closing_loc: Location?
  #
  # source://prism//lib/prism/node.rb#2372
  sig { returns(T.nilable(Prism::Location)) }
  def closing_loc; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#2277
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#2268
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?receiver: Prism::node?, ?call_operator_loc: Location?, ?name: Symbol, ?message_loc: Location?, ?opening_loc: Location?, ?arguments: ArgumentsNode?, ?closing_loc: Location?, ?block: BlockNode | BlockArgumentNode | nil) -> CallNode
  #
  # source://prism//lib/prism/node.rb#2282
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      receiver: T.nilable(Prism::Node),
      call_operator_loc: T.nilable(Prism::Location),
      name: Symbol,
      message_loc: T.nilable(Prism::Location),
      opening_loc: T.nilable(Prism::Location),
      arguments: T.nilable(Prism::ArgumentsNode),
      closing_loc: T.nilable(Prism::Location),
      block: T.nilable(T.any(Prism::BlockNode, Prism::BlockArgumentNode))
    ).returns(Prism::CallNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), receiver: T.unsafe(nil), call_operator_loc: T.unsafe(nil), name: T.unsafe(nil), message_loc: T.unsafe(nil), opening_loc: T.unsafe(nil), arguments: T.unsafe(nil), closing_loc: T.unsafe(nil), block: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#2263
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, receiver: Prism::node?, call_operator_loc: Location?, name: Symbol, message_loc: Location?, opening_loc: Location?, arguments: ArgumentsNode?, closing_loc: Location?, block: BlockNode | BlockArgumentNode | nil }
  #
  # source://prism//lib/prism/node.rb#2290
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # When a call node has the attribute_write flag set, it means that the call
  # is using the attribute write syntax. This is either a method call to []=
  # or a method call to a method that ends with =. Either way, the = sign is
  # present in the source.
  #
  # Prism returns the message_loc _without_ the = sign attached, because there
  # can be any amount of space between the message and the = sign. However,
  # sometimes you want the location of the full message including the inner
  # space and the = sign. This method provides that.
  #
  # source://prism//lib/prism/node_ext.rb#331
  sig { returns(T.nilable(Prism::Location)) }
  def full_message_loc; end

  # def ignore_visibility?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#2310
  sig { returns(T::Boolean) }
  def ignore_visibility?; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#2408
  sig { override.returns(String) }
  def inspect; end

  # def message: () -> String?
  #
  # source://prism//lib/prism/node.rb#2393
  sig { returns(T.nilable(String)) }
  def message; end

  # attr_reader message_loc: Location?
  #
  # source://prism//lib/prism/node.rb#2343
  sig { returns(T.nilable(Prism::Location)) }
  def message_loc; end

  # attr_reader name: Symbol
  #
  # source://prism//lib/prism/node.rb#2340
  sig { returns(Symbol) }
  def name; end

  # def opening: () -> String?
  #
  # source://prism//lib/prism/node.rb#2398
  sig { returns(T.nilable(String)) }
  def opening; end

  # attr_reader opening_loc: Location?
  #
  # source://prism//lib/prism/node.rb#2356
  sig { returns(T.nilable(Prism::Location)) }
  def opening_loc; end

  # The object that the method is being called on. This can be either `nil` or any [non-void expression](https://github.com/ruby/prism/blob/main/docs/parsing_rules.md#non-void-expression).
  #
  #     foo.bar
  #     ^^^
  #
  #     +foo
  #      ^^^
  #
  #     foo + bar
  #     ^^^
  #
  # source://prism//lib/prism/node.rb#2324
  sig { returns(T.nilable(Prism::Node)) }
  def receiver; end

  # def safe_navigation?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#2295
  sig { returns(T::Boolean) }
  def safe_navigation?; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#2413
  sig { override.returns(Symbol) }
  def type; end

  # def variable_call?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#2300
  sig { returns(T::Boolean) }
  def variable_call?; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#2418
    def type; end
  end
end

# Flags for call nodes.
#
# source://prism//lib/prism/node.rb#16708
module Prism::CallNodeFlags; end

# a call that is an attribute write, so the value being written should be returned
#
# source://prism//lib/prism/node.rb#16716
Prism::CallNodeFlags::ATTRIBUTE_WRITE = T.let(T.unsafe(nil), Integer)

# a call that ignores method visibility
#
# source://prism//lib/prism/node.rb#16719
Prism::CallNodeFlags::IGNORE_VISIBILITY = T.let(T.unsafe(nil), Integer)

# &. operator
#
# source://prism//lib/prism/node.rb#16710
Prism::CallNodeFlags::SAFE_NAVIGATION = T.let(T.unsafe(nil), Integer)

# a call that could have been a local variable
#
# source://prism//lib/prism/node.rb#16713
Prism::CallNodeFlags::VARIABLE_CALL = T.let(T.unsafe(nil), Integer)

# Represents the use of an assignment operator on a call.
#
#     foo.bar += baz
#     ^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#2442
class Prism::CallOperatorWriteNode < ::Prism::Node
  # Initialize a new CallOperatorWriteNode node.
  #
  # @return [CallOperatorWriteNode] a new instance of CallOperatorWriteNode
  #
  # source://prism//lib/prism/node.rb#2444
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      receiver: T.nilable(Prism::Node),
      call_operator_loc: T.nilable(Prism::Location),
      message_loc: T.nilable(Prism::Location),
      read_name: Symbol,
      write_name: Symbol,
      binary_operator: Symbol,
      binary_operator_loc: Prism::Location,
      value: Prism::Node
    ).void
  end
  def initialize(source, node_id, location, flags, receiver, call_operator_loc, message_loc, read_name, write_name, binary_operator, binary_operator_loc, value); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#2590
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#2460
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def attribute_write?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#2506
  sig { returns(T::Boolean) }
  def attribute_write?; end

  # attr_reader binary_operator: Symbol
  #
  # source://prism//lib/prism/node.rb#2551
  sig { returns(Symbol) }
  def binary_operator; end

  # attr_reader binary_operator_loc: Location
  #
  # source://prism//lib/prism/node.rb#2554
  sig { returns(Prism::Location) }
  def binary_operator_loc; end

  # def call_operator: () -> String?
  #
  # source://prism//lib/prism/node.rb#2564
  sig { returns(T.nilable(String)) }
  def call_operator; end

  # attr_reader call_operator_loc: Location?
  #
  # source://prism//lib/prism/node.rb#2519
  sig { returns(T.nilable(Prism::Location)) }
  def call_operator_loc; end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#2465
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#2478
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#2470
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?receiver: Prism::node?, ?call_operator_loc: Location?, ?message_loc: Location?, ?read_name: Symbol, ?write_name: Symbol, ?binary_operator: Symbol, ?binary_operator_loc: Location, ?value: Prism::node) -> CallOperatorWriteNode
  #
  # source://prism//lib/prism/node.rb#2483
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      receiver: T.nilable(Prism::Node),
      call_operator_loc: T.nilable(Prism::Location),
      message_loc: T.nilable(Prism::Location),
      read_name: Symbol,
      write_name: Symbol,
      binary_operator: Symbol,
      binary_operator_loc: Prism::Location,
      value: Prism::Node
    ).returns(Prism::CallOperatorWriteNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), receiver: T.unsafe(nil), call_operator_loc: T.unsafe(nil), message_loc: T.unsafe(nil), read_name: T.unsafe(nil), write_name: T.unsafe(nil), binary_operator: T.unsafe(nil), binary_operator_loc: T.unsafe(nil), value: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#2465
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, receiver: Prism::node?, call_operator_loc: Location?, message_loc: Location?, read_name: Symbol, write_name: Symbol, binary_operator: Symbol, binary_operator_loc: Location, value: Prism::node }
  #
  # source://prism//lib/prism/node.rb#2491
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def ignore_visibility?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#2511
  sig { returns(T::Boolean) }
  def ignore_visibility?; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#2574
  sig { override.returns(String) }
  def inspect; end

  # def message: () -> String?
  #
  # source://prism//lib/prism/node.rb#2569
  sig { returns(T.nilable(String)) }
  def message; end

  # attr_reader message_loc: Location?
  #
  # source://prism//lib/prism/node.rb#2532
  sig { returns(T.nilable(Prism::Location)) }
  def message_loc; end

  # Returns the binary operator used to modify the receiver. This method is
  # deprecated in favor of #binary_operator.
  #
  # source://prism//lib/prism/node_ext.rb#339
  def operator; end

  # Returns the location of the binary operator used to modify the receiver.
  # This method is deprecated in favor of #binary_operator_loc.
  #
  # source://prism//lib/prism/node_ext.rb#346
  def operator_loc; end

  # attr_reader read_name: Symbol
  #
  # source://prism//lib/prism/node.rb#2545
  sig { returns(Symbol) }
  def read_name; end

  # attr_reader receiver: Prism::node?
  #
  # source://prism//lib/prism/node.rb#2516
  sig { returns(T.nilable(Prism::Node)) }
  def receiver; end

  # def safe_navigation?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#2496
  sig { returns(T::Boolean) }
  def safe_navigation?; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#2579
  sig { override.returns(Symbol) }
  def type; end

  # attr_reader value: Prism::node
  #
  # source://prism//lib/prism/node.rb#2561
  sig { returns(Prism::Node) }
  def value; end

  # def variable_call?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#2501
  sig { returns(T::Boolean) }
  def variable_call?; end

  # attr_reader write_name: Symbol
  #
  # source://prism//lib/prism/node.rb#2548
  sig { returns(Symbol) }
  def write_name; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#2584
    def type; end
  end
end

# Represents the use of the `||=` operator on a call.
#
#     foo.bar ||= value
#     ^^^^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#2608
class Prism::CallOrWriteNode < ::Prism::Node
  # Initialize a new CallOrWriteNode node.
  #
  # @return [CallOrWriteNode] a new instance of CallOrWriteNode
  #
  # source://prism//lib/prism/node.rb#2610
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      receiver: T.nilable(Prism::Node),
      call_operator_loc: T.nilable(Prism::Location),
      message_loc: T.nilable(Prism::Location),
      read_name: Symbol,
      write_name: Symbol,
      operator_loc: Prism::Location,
      value: Prism::Node
    ).void
  end
  def initialize(source, node_id, location, flags, receiver, call_operator_loc, message_loc, read_name, write_name, operator_loc, value); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#2757
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#2625
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def attribute_write?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#2671
  sig { returns(T::Boolean) }
  def attribute_write?; end

  # def call_operator: () -> String?
  #
  # source://prism//lib/prism/node.rb#2726
  sig { returns(T.nilable(String)) }
  def call_operator; end

  # attr_reader call_operator_loc: Location?
  #
  # source://prism//lib/prism/node.rb#2684
  sig { returns(T.nilable(Prism::Location)) }
  def call_operator_loc; end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#2630
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#2643
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#2635
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?receiver: Prism::node?, ?call_operator_loc: Location?, ?message_loc: Location?, ?read_name: Symbol, ?write_name: Symbol, ?operator_loc: Location, ?value: Prism::node) -> CallOrWriteNode
  #
  # source://prism//lib/prism/node.rb#2648
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      receiver: T.nilable(Prism::Node),
      call_operator_loc: T.nilable(Prism::Location),
      message_loc: T.nilable(Prism::Location),
      read_name: Symbol,
      write_name: Symbol,
      operator_loc: Prism::Location,
      value: Prism::Node
    ).returns(Prism::CallOrWriteNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), receiver: T.unsafe(nil), call_operator_loc: T.unsafe(nil), message_loc: T.unsafe(nil), read_name: T.unsafe(nil), write_name: T.unsafe(nil), operator_loc: T.unsafe(nil), value: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#2630
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, receiver: Prism::node?, call_operator_loc: Location?, message_loc: Location?, read_name: Symbol, write_name: Symbol, operator_loc: Location, value: Prism::node }
  #
  # source://prism//lib/prism/node.rb#2656
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def ignore_visibility?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#2676
  sig { returns(T::Boolean) }
  def ignore_visibility?; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#2741
  sig { override.returns(String) }
  def inspect; end

  # def message: () -> String?
  #
  # source://prism//lib/prism/node.rb#2731
  sig { returns(T.nilable(String)) }
  def message; end

  # attr_reader message_loc: Location?
  #
  # source://prism//lib/prism/node.rb#2697
  sig { returns(T.nilable(Prism::Location)) }
  def message_loc; end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#2736
  sig { returns(String) }
  def operator; end

  # attr_reader operator_loc: Location
  #
  # source://prism//lib/prism/node.rb#2716
  sig { returns(Prism::Location) }
  def operator_loc; end

  # attr_reader read_name: Symbol
  #
  # source://prism//lib/prism/node.rb#2710
  sig { returns(Symbol) }
  def read_name; end

  # attr_reader receiver: Prism::node?
  #
  # source://prism//lib/prism/node.rb#2681
  sig { returns(T.nilable(Prism::Node)) }
  def receiver; end

  # def safe_navigation?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#2661
  sig { returns(T::Boolean) }
  def safe_navigation?; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#2746
  sig { override.returns(Symbol) }
  def type; end

  # attr_reader value: Prism::node
  #
  # source://prism//lib/prism/node.rb#2723
  sig { returns(Prism::Node) }
  def value; end

  # def variable_call?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#2666
  sig { returns(T::Boolean) }
  def variable_call?; end

  # attr_reader write_name: Symbol
  #
  # source://prism//lib/prism/node.rb#2713
  sig { returns(Symbol) }
  def write_name; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#2751
    def type; end
  end
end

# Represents assigning to a method call.
#
#     foo.bar, = 1
#     ^^^^^^^
#
#     begin
#     rescue => foo.bar
#               ^^^^^^^
#     end
#
#     for foo.bar in baz do end
#         ^^^^^^^
#
# source://prism//lib/prism/node.rb#2782
class Prism::CallTargetNode < ::Prism::Node
  # Initialize a new CallTargetNode node.
  #
  # @return [CallTargetNode] a new instance of CallTargetNode
  #
  # source://prism//lib/prism/node.rb#2784
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      receiver: Prism::Node,
      call_operator_loc: Prism::Location,
      name: Symbol,
      message_loc: Prism::Location
    ).void
  end
  def initialize(source, node_id, location, flags, receiver, call_operator_loc, name, message_loc); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#2895
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#2796
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def attribute_write?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#2839
  sig { returns(T::Boolean) }
  def attribute_write?; end

  # def call_operator: () -> String
  #
  # source://prism//lib/prism/node.rb#2869
  sig { returns(String) }
  def call_operator; end

  # attr_reader call_operator_loc: Location
  #
  # source://prism//lib/prism/node.rb#2852
  sig { returns(Prism::Location) }
  def call_operator_loc; end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#2801
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#2811
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#2806
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?receiver: Prism::node, ?call_operator_loc: Location, ?name: Symbol, ?message_loc: Location) -> CallTargetNode
  #
  # source://prism//lib/prism/node.rb#2816
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      receiver: Prism::Node,
      call_operator_loc: Prism::Location,
      name: Symbol,
      message_loc: Prism::Location
    ).returns(Prism::CallTargetNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), receiver: T.unsafe(nil), call_operator_loc: T.unsafe(nil), name: T.unsafe(nil), message_loc: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#2801
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, receiver: Prism::node, call_operator_loc: Location, name: Symbol, message_loc: Location }
  #
  # source://prism//lib/prism/node.rb#2824
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def ignore_visibility?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#2844
  sig { returns(T::Boolean) }
  def ignore_visibility?; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#2879
  sig { override.returns(String) }
  def inspect; end

  # def message: () -> String
  #
  # source://prism//lib/prism/node.rb#2874
  sig { returns(String) }
  def message; end

  # attr_reader message_loc: Location
  #
  # source://prism//lib/prism/node.rb#2862
  sig { returns(Prism::Location) }
  def message_loc; end

  # attr_reader name: Symbol
  #
  # source://prism//lib/prism/node.rb#2859
  sig { returns(Symbol) }
  def name; end

  # attr_reader receiver: Prism::node
  #
  # source://prism//lib/prism/node.rb#2849
  sig { returns(Prism::Node) }
  def receiver; end

  # def safe_navigation?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#2829
  sig { returns(T::Boolean) }
  def safe_navigation?; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#2884
  sig { override.returns(Symbol) }
  def type; end

  # def variable_call?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#2834
  sig { returns(T::Boolean) }
  def variable_call?; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#2889
    def type; end
  end
end

# Represents assigning to a local variable in pattern matching.
#
#     foo => [bar => baz]
#            ^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#2909
class Prism::CapturePatternNode < ::Prism::Node
  # Initialize a new CapturePatternNode node.
  #
  # @return [CapturePatternNode] a new instance of CapturePatternNode
  #
  # source://prism//lib/prism/node.rb#2911
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      value: Prism::Node,
      target: Prism::LocalVariableTargetNode,
      operator_loc: Prism::Location
    ).void
  end
  def initialize(source, node_id, location, flags, value, target, operator_loc); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#2989
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#2922
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#2927
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#2937
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#2932
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?value: Prism::node, ?target: LocalVariableTargetNode, ?operator_loc: Location) -> CapturePatternNode
  #
  # source://prism//lib/prism/node.rb#2942
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      value: Prism::Node,
      target: Prism::LocalVariableTargetNode,
      operator_loc: Prism::Location
    ).returns(Prism::CapturePatternNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), value: T.unsafe(nil), target: T.unsafe(nil), operator_loc: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#2927
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, value: Prism::node, target: LocalVariableTargetNode, operator_loc: Location }
  #
  # source://prism//lib/prism/node.rb#2950
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#2973
  sig { override.returns(String) }
  def inspect; end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#2968
  sig { returns(String) }
  def operator; end

  # attr_reader operator_loc: Location
  #
  # source://prism//lib/prism/node.rb#2961
  sig { returns(Prism::Location) }
  def operator_loc; end

  # attr_reader target: LocalVariableTargetNode
  #
  # source://prism//lib/prism/node.rb#2958
  sig { returns(Prism::LocalVariableTargetNode) }
  def target; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#2978
  sig { override.returns(Symbol) }
  def type; end

  # attr_reader value: Prism::node
  #
  # source://prism//lib/prism/node.rb#2955
  sig { returns(Prism::Node) }
  def value; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#2983
    def type; end
  end
end

# Represents the use of a case statement for pattern matching.
#
#     case true
#     in false
#     end
#     ^^^^^^^^^
#
# source://prism//lib/prism/node.rb#3003
class Prism::CaseMatchNode < ::Prism::Node
  # Initialize a new CaseMatchNode node.
  #
  # @return [CaseMatchNode] a new instance of CaseMatchNode
  #
  # source://prism//lib/prism/node.rb#3005
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      predicate: T.nilable(Prism::Node),
      conditions: T::Array[Prism::InNode],
      else_clause: T.nilable(Prism::ElseNode),
      case_keyword_loc: Prism::Location,
      end_keyword_loc: Prism::Location
    ).void
  end
  def initialize(source, node_id, location, flags, predicate, conditions, else_clause, case_keyword_loc, end_keyword_loc); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#3104
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#3018
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def case_keyword: () -> String
  #
  # source://prism//lib/prism/node.rb#3078
  sig { returns(String) }
  def case_keyword; end

  # attr_reader case_keyword_loc: Location
  #
  # source://prism//lib/prism/node.rb#3064
  sig { returns(Prism::Location) }
  def case_keyword_loc; end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#3023
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#3037
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#3028
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # attr_reader conditions: Array[InNode]
  #
  # source://prism//lib/prism/node.rb#3058
  sig { returns(T::Array[Prism::InNode]) }
  def conditions; end

  # Returns the else clause of the case match node. This method is deprecated
  # in favor of #else_clause.
  #
  # source://prism//lib/prism/node_ext.rb#467
  def consequent; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?predicate: Prism::node?, ?conditions: Array[InNode], ?else_clause: ElseNode?, ?case_keyword_loc: Location, ?end_keyword_loc: Location) -> CaseMatchNode
  #
  # source://prism//lib/prism/node.rb#3042
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      predicate: T.nilable(Prism::Node),
      conditions: T::Array[Prism::InNode],
      else_clause: T.nilable(Prism::ElseNode),
      case_keyword_loc: Prism::Location,
      end_keyword_loc: Prism::Location
    ).returns(Prism::CaseMatchNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), predicate: T.unsafe(nil), conditions: T.unsafe(nil), else_clause: T.unsafe(nil), case_keyword_loc: T.unsafe(nil), end_keyword_loc: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#3023
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, predicate: Prism::node?, conditions: Array[InNode], else_clause: ElseNode?, case_keyword_loc: Location, end_keyword_loc: Location }
  #
  # source://prism//lib/prism/node.rb#3050
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # attr_reader else_clause: ElseNode?
  #
  # source://prism//lib/prism/node.rb#3061
  sig { returns(T.nilable(Prism::ElseNode)) }
  def else_clause; end

  # def end_keyword: () -> String
  #
  # source://prism//lib/prism/node.rb#3083
  sig { returns(String) }
  def end_keyword; end

  # attr_reader end_keyword_loc: Location
  #
  # source://prism//lib/prism/node.rb#3071
  sig { returns(Prism::Location) }
  def end_keyword_loc; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#3088
  sig { override.returns(String) }
  def inspect; end

  # attr_reader predicate: Prism::node?
  #
  # source://prism//lib/prism/node.rb#3055
  sig { returns(T.nilable(Prism::Node)) }
  def predicate; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#3093
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#3098
    def type; end
  end
end

# Represents the use of a case statement.
#
#     case true
#     when false
#     end
#     ^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#3121
class Prism::CaseNode < ::Prism::Node
  # Initialize a new CaseNode node.
  #
  # @return [CaseNode] a new instance of CaseNode
  #
  # source://prism//lib/prism/node.rb#3123
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      predicate: T.nilable(Prism::Node),
      conditions: T::Array[Prism::WhenNode],
      else_clause: T.nilable(Prism::ElseNode),
      case_keyword_loc: Prism::Location,
      end_keyword_loc: Prism::Location
    ).void
  end
  def initialize(source, node_id, location, flags, predicate, conditions, else_clause, case_keyword_loc, end_keyword_loc); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#3222
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#3136
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def case_keyword: () -> String
  #
  # source://prism//lib/prism/node.rb#3196
  sig { returns(String) }
  def case_keyword; end

  # attr_reader case_keyword_loc: Location
  #
  # source://prism//lib/prism/node.rb#3182
  sig { returns(Prism::Location) }
  def case_keyword_loc; end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#3141
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#3155
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#3146
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # attr_reader conditions: Array[WhenNode]
  #
  # source://prism//lib/prism/node.rb#3176
  sig { returns(T::Array[Prism::WhenNode]) }
  def conditions; end

  # Returns the else clause of the case node. This method is deprecated in
  # favor of #else_clause.
  #
  # source://prism//lib/prism/node_ext.rb#476
  def consequent; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?predicate: Prism::node?, ?conditions: Array[WhenNode], ?else_clause: ElseNode?, ?case_keyword_loc: Location, ?end_keyword_loc: Location) -> CaseNode
  #
  # source://prism//lib/prism/node.rb#3160
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      predicate: T.nilable(Prism::Node),
      conditions: T::Array[Prism::WhenNode],
      else_clause: T.nilable(Prism::ElseNode),
      case_keyword_loc: Prism::Location,
      end_keyword_loc: Prism::Location
    ).returns(Prism::CaseNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), predicate: T.unsafe(nil), conditions: T.unsafe(nil), else_clause: T.unsafe(nil), case_keyword_loc: T.unsafe(nil), end_keyword_loc: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#3141
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, predicate: Prism::node?, conditions: Array[WhenNode], else_clause: ElseNode?, case_keyword_loc: Location, end_keyword_loc: Location }
  #
  # source://prism//lib/prism/node.rb#3168
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # attr_reader else_clause: ElseNode?
  #
  # source://prism//lib/prism/node.rb#3179
  sig { returns(T.nilable(Prism::ElseNode)) }
  def else_clause; end

  # def end_keyword: () -> String
  #
  # source://prism//lib/prism/node.rb#3201
  sig { returns(String) }
  def end_keyword; end

  # attr_reader end_keyword_loc: Location
  #
  # source://prism//lib/prism/node.rb#3189
  sig { returns(Prism::Location) }
  def end_keyword_loc; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#3206
  sig { override.returns(String) }
  def inspect; end

  # attr_reader predicate: Prism::node?
  #
  # source://prism//lib/prism/node.rb#3173
  sig { returns(T.nilable(Prism::Node)) }
  def predicate; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#3211
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#3216
    def type; end
  end
end

# Represents a class declaration involving the `class` keyword.
#
#     class Foo end
#     ^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#3237
class Prism::ClassNode < ::Prism::Node
  # Initialize a new ClassNode node.
  #
  # @return [ClassNode] a new instance of ClassNode
  #
  # source://prism//lib/prism/node.rb#3239
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      locals: T::Array[Symbol],
      class_keyword_loc: Prism::Location,
      constant_path: T.any(Prism::ConstantReadNode, Prism::ConstantPathNode, Prism::CallNode),
      inheritance_operator_loc: T.nilable(Prism::Location),
      superclass: T.nilable(Prism::Node),
      body: T.nilable(T.any(Prism::StatementsNode, Prism::BeginNode)),
      end_keyword_loc: Prism::Location,
      name: Symbol
    ).void
  end
  def initialize(source, node_id, location, flags, locals, class_keyword_loc, constant_path, inheritance_operator_loc, superclass, body, end_keyword_loc, name); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#3365
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#3255
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # attr_reader body: StatementsNode | BeginNode | nil
  #
  # source://prism//lib/prism/node.rb#3321
  sig { returns(T.nilable(T.any(Prism::StatementsNode, Prism::BeginNode))) }
  def body; end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#3260
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def class_keyword: () -> String
  #
  # source://prism//lib/prism/node.rb#3334
  sig { returns(String) }
  def class_keyword; end

  # attr_reader class_keyword_loc: Location
  #
  # source://prism//lib/prism/node.rb#3295
  sig { returns(Prism::Location) }
  def class_keyword_loc; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#3274
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#3265
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # attr_reader constant_path: ConstantReadNode | ConstantPathNode | CallNode
  #
  # source://prism//lib/prism/node.rb#3302
  sig { returns(T.any(Prism::ConstantReadNode, Prism::ConstantPathNode, Prism::CallNode)) }
  def constant_path; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?locals: Array[Symbol], ?class_keyword_loc: Location, ?constant_path: ConstantReadNode | ConstantPathNode | CallNode, ?inheritance_operator_loc: Location?, ?superclass: Prism::node?, ?body: StatementsNode | BeginNode | nil, ?end_keyword_loc: Location, ?name: Symbol) -> ClassNode
  #
  # source://prism//lib/prism/node.rb#3279
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      locals: T::Array[Symbol],
      class_keyword_loc: Prism::Location,
      constant_path: T.any(Prism::ConstantReadNode, Prism::ConstantPathNode, Prism::CallNode),
      inheritance_operator_loc: T.nilable(Prism::Location),
      superclass: T.nilable(Prism::Node),
      body: T.nilable(T.any(Prism::StatementsNode, Prism::BeginNode)),
      end_keyword_loc: Prism::Location,
      name: Symbol
    ).returns(Prism::ClassNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), locals: T.unsafe(nil), class_keyword_loc: T.unsafe(nil), constant_path: T.unsafe(nil), inheritance_operator_loc: T.unsafe(nil), superclass: T.unsafe(nil), body: T.unsafe(nil), end_keyword_loc: T.unsafe(nil), name: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#3260
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, locals: Array[Symbol], class_keyword_loc: Location, constant_path: ConstantReadNode | ConstantPathNode | CallNode, inheritance_operator_loc: Location?, superclass: Prism::node?, body: StatementsNode | BeginNode | nil, end_keyword_loc: Location, name: Symbol }
  #
  # source://prism//lib/prism/node.rb#3287
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def end_keyword: () -> String
  #
  # source://prism//lib/prism/node.rb#3344
  sig { returns(String) }
  def end_keyword; end

  # attr_reader end_keyword_loc: Location
  #
  # source://prism//lib/prism/node.rb#3324
  sig { returns(Prism::Location) }
  def end_keyword_loc; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inheritance_operator: () -> String?
  #
  # source://prism//lib/prism/node.rb#3339
  sig { returns(T.nilable(String)) }
  def inheritance_operator; end

  # attr_reader inheritance_operator_loc: Location?
  #
  # source://prism//lib/prism/node.rb#3305
  sig { returns(T.nilable(Prism::Location)) }
  def inheritance_operator_loc; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#3349
  sig { override.returns(String) }
  def inspect; end

  # attr_reader locals: Array[Symbol]
  #
  # source://prism//lib/prism/node.rb#3292
  sig { returns(T::Array[Symbol]) }
  def locals; end

  # attr_reader name: Symbol
  #
  # source://prism//lib/prism/node.rb#3331
  sig { returns(Symbol) }
  def name; end

  # attr_reader superclass: Prism::node?
  #
  # source://prism//lib/prism/node.rb#3318
  sig { returns(T.nilable(Prism::Node)) }
  def superclass; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#3354
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#3359
    def type; end
  end
end

# Represents the use of the `&&=` operator for assignment to a class variable.
#
#     @@target &&= value
#     ^^^^^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#3383
class Prism::ClassVariableAndWriteNode < ::Prism::Node
  # Initialize a new ClassVariableAndWriteNode node.
  #
  # @return [ClassVariableAndWriteNode] a new instance of ClassVariableAndWriteNode
  #
  # source://prism//lib/prism/node.rb#3385
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      name_loc: Prism::Location,
      operator_loc: Prism::Location,
      value: Prism::Node
    ).void
  end
  def initialize(source, node_id, location, flags, name, name_loc, operator_loc, value); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#3471
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#3397
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#3402
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#3412
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#3407
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?name: Symbol, ?name_loc: Location, ?operator_loc: Location, ?value: Prism::node) -> ClassVariableAndWriteNode
  #
  # source://prism//lib/prism/node.rb#3417
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      name_loc: Prism::Location,
      operator_loc: Prism::Location,
      value: Prism::Node
    ).returns(Prism::ClassVariableAndWriteNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil), name_loc: T.unsafe(nil), operator_loc: T.unsafe(nil), value: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#3402
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, name: Symbol, name_loc: Location, operator_loc: Location, value: Prism::node }
  #
  # source://prism//lib/prism/node.rb#3425
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # source://prism//lib/prism/desugar_compiler.rb#164
  def desugar; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#3455
  sig { override.returns(String) }
  def inspect; end

  # attr_reader name: Symbol
  #
  # source://prism//lib/prism/node.rb#3430
  sig { returns(Symbol) }
  def name; end

  # attr_reader name_loc: Location
  #
  # source://prism//lib/prism/node.rb#3433
  sig { returns(Prism::Location) }
  def name_loc; end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#3450
  sig { returns(String) }
  def operator; end

  # attr_reader operator_loc: Location
  #
  # source://prism//lib/prism/node.rb#3440
  sig { returns(Prism::Location) }
  def operator_loc; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#3460
  sig { override.returns(Symbol) }
  def type; end

  # attr_reader value: Prism::node
  #
  # source://prism//lib/prism/node.rb#3447
  sig { returns(Prism::Node) }
  def value; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#3465
    def type; end
  end
end

# Represents assigning to a class variable using an operator that isn't `=`.
#
#     @@target += value
#     ^^^^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#3484
class Prism::ClassVariableOperatorWriteNode < ::Prism::Node
  # Initialize a new ClassVariableOperatorWriteNode node.
  #
  # @return [ClassVariableOperatorWriteNode] a new instance of ClassVariableOperatorWriteNode
  #
  # source://prism//lib/prism/node.rb#3486
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      name_loc: Prism::Location,
      binary_operator_loc: Prism::Location,
      value: Prism::Node,
      binary_operator: Symbol
    ).void
  end
  def initialize(source, node_id, location, flags, name, name_loc, binary_operator_loc, value, binary_operator); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#3571
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#3499
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # attr_reader binary_operator: Symbol
  #
  # source://prism//lib/prism/node.rb#3552
  sig { returns(Symbol) }
  def binary_operator; end

  # attr_reader binary_operator_loc: Location
  #
  # source://prism//lib/prism/node.rb#3542
  sig { returns(Prism::Location) }
  def binary_operator_loc; end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#3504
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#3514
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#3509
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?name: Symbol, ?name_loc: Location, ?binary_operator_loc: Location, ?value: Prism::node, ?binary_operator: Symbol) -> ClassVariableOperatorWriteNode
  #
  # source://prism//lib/prism/node.rb#3519
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      name_loc: Prism::Location,
      binary_operator_loc: Prism::Location,
      value: Prism::Node,
      binary_operator: Symbol
    ).returns(Prism::ClassVariableOperatorWriteNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil), name_loc: T.unsafe(nil), binary_operator_loc: T.unsafe(nil), value: T.unsafe(nil), binary_operator: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#3504
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, name: Symbol, name_loc: Location, binary_operator_loc: Location, value: Prism::node, binary_operator: Symbol }
  #
  # source://prism//lib/prism/node.rb#3527
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # source://prism//lib/prism/desugar_compiler.rb#176
  def desugar; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#3555
  sig { override.returns(String) }
  def inspect; end

  # attr_reader name: Symbol
  #
  # source://prism//lib/prism/node.rb#3532
  sig { returns(Symbol) }
  def name; end

  # attr_reader name_loc: Location
  #
  # source://prism//lib/prism/node.rb#3535
  sig { returns(Prism::Location) }
  def name_loc; end

  # Returns the binary operator used to modify the receiver. This method is
  # deprecated in favor of #binary_operator.
  #
  # source://prism//lib/prism/node_ext.rb#355
  def operator; end

  # Returns the location of the binary operator used to modify the receiver.
  # This method is deprecated in favor of #binary_operator_loc.
  #
  # source://prism//lib/prism/node_ext.rb#362
  def operator_loc; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#3560
  sig { override.returns(Symbol) }
  def type; end

  # attr_reader value: Prism::node
  #
  # source://prism//lib/prism/node.rb#3549
  sig { returns(Prism::Node) }
  def value; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#3565
    def type; end
  end
end

# Represents the use of the `||=` operator for assignment to a class variable.
#
#     @@target ||= value
#     ^^^^^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#3585
class Prism::ClassVariableOrWriteNode < ::Prism::Node
  # Initialize a new ClassVariableOrWriteNode node.
  #
  # @return [ClassVariableOrWriteNode] a new instance of ClassVariableOrWriteNode
  #
  # source://prism//lib/prism/node.rb#3587
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      name_loc: Prism::Location,
      operator_loc: Prism::Location,
      value: Prism::Node
    ).void
  end
  def initialize(source, node_id, location, flags, name, name_loc, operator_loc, value); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#3673
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#3599
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#3604
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#3614
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#3609
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?name: Symbol, ?name_loc: Location, ?operator_loc: Location, ?value: Prism::node) -> ClassVariableOrWriteNode
  #
  # source://prism//lib/prism/node.rb#3619
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      name_loc: Prism::Location,
      operator_loc: Prism::Location,
      value: Prism::Node
    ).returns(Prism::ClassVariableOrWriteNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil), name_loc: T.unsafe(nil), operator_loc: T.unsafe(nil), value: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#3604
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, name: Symbol, name_loc: Location, operator_loc: Location, value: Prism::node }
  #
  # source://prism//lib/prism/node.rb#3627
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # source://prism//lib/prism/desugar_compiler.rb#170
  def desugar; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#3657
  sig { override.returns(String) }
  def inspect; end

  # attr_reader name: Symbol
  #
  # source://prism//lib/prism/node.rb#3632
  sig { returns(Symbol) }
  def name; end

  # attr_reader name_loc: Location
  #
  # source://prism//lib/prism/node.rb#3635
  sig { returns(Prism::Location) }
  def name_loc; end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#3652
  sig { returns(String) }
  def operator; end

  # attr_reader operator_loc: Location
  #
  # source://prism//lib/prism/node.rb#3642
  sig { returns(Prism::Location) }
  def operator_loc; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#3662
  sig { override.returns(Symbol) }
  def type; end

  # attr_reader value: Prism::node
  #
  # source://prism//lib/prism/node.rb#3649
  sig { returns(Prism::Node) }
  def value; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#3667
    def type; end
  end
end

# Represents referencing a class variable.
#
#     @@foo
#     ^^^^^
#
# source://prism//lib/prism/node.rb#3686
class Prism::ClassVariableReadNode < ::Prism::Node
  # Initialize a new ClassVariableReadNode node.
  #
  # @return [ClassVariableReadNode] a new instance of ClassVariableReadNode
  #
  # source://prism//lib/prism/node.rb#3688
  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol).void }
  def initialize(source, node_id, location, flags, name); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#3753
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#3697
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#3702
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#3712
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#3707
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?name: Symbol) -> ClassVariableReadNode
  #
  # source://prism//lib/prism/node.rb#3717
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol
    ).returns(Prism::ClassVariableReadNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#3702
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, name: Symbol }
  #
  # source://prism//lib/prism/node.rb#3725
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#3737
  sig { override.returns(String) }
  def inspect; end

  # The name of the class variable, which is a `@@` followed by an [identifier](https://github.com/ruby/prism/blob/main/docs/parsing_rules.md#identifiers).
  #
  #     @@abc   # name `:@@abc`
  #
  #     @@_test # name `:@@_test`
  #
  # source://prism//lib/prism/node.rb#3734
  sig { returns(Symbol) }
  def name; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#3742
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#3747
    def type; end
  end
end

# Represents writing to a class variable in a context that doesn't have an explicit value.
#
#     @@foo, @@bar = baz
#     ^^^^^  ^^^^^
#
# source://prism//lib/prism/node.rb#3763
class Prism::ClassVariableTargetNode < ::Prism::Node
  # Initialize a new ClassVariableTargetNode node.
  #
  # @return [ClassVariableTargetNode] a new instance of ClassVariableTargetNode
  #
  # source://prism//lib/prism/node.rb#3765
  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol).void }
  def initialize(source, node_id, location, flags, name); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#3826
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#3774
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#3779
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#3789
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#3784
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?name: Symbol) -> ClassVariableTargetNode
  #
  # source://prism//lib/prism/node.rb#3794
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol
    ).returns(Prism::ClassVariableTargetNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#3779
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, name: Symbol }
  #
  # source://prism//lib/prism/node.rb#3802
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#3810
  sig { override.returns(String) }
  def inspect; end

  # attr_reader name: Symbol
  #
  # source://prism//lib/prism/node.rb#3807
  sig { returns(Symbol) }
  def name; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#3815
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#3820
    def type; end
  end
end

# Represents writing to a class variable.
#
#     @@foo = 1
#     ^^^^^^^^^
#
# source://prism//lib/prism/node.rb#3836
class Prism::ClassVariableWriteNode < ::Prism::Node
  # Initialize a new ClassVariableWriteNode node.
  #
  # @return [ClassVariableWriteNode] a new instance of ClassVariableWriteNode
  #
  # source://prism//lib/prism/node.rb#3838
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      name_loc: Prism::Location,
      value: Prism::Node,
      operator_loc: Prism::Location
    ).void
  end
  def initialize(source, node_id, location, flags, name, name_loc, value, operator_loc); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#3940
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#3850
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#3855
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#3865
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#3860
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?name: Symbol, ?name_loc: Location, ?value: Prism::node, ?operator_loc: Location) -> ClassVariableWriteNode
  #
  # source://prism//lib/prism/node.rb#3870
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      name_loc: Prism::Location,
      value: Prism::Node,
      operator_loc: Prism::Location
    ).returns(Prism::ClassVariableWriteNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil), name_loc: T.unsafe(nil), value: T.unsafe(nil), operator_loc: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#3855
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, name: Symbol, name_loc: Location, value: Prism::node, operator_loc: Location }
  #
  # source://prism//lib/prism/node.rb#3878
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#3924
  sig { override.returns(String) }
  def inspect; end

  # The name of the class variable, which is a `@@` followed by an [identifier](https://github.com/ruby/prism/blob/main/docs/parsing_rules.md#identifiers).
  #
  #     @@abc = 123     # name `@@abc`
  #
  #     @@_test = :test # name `@@_test`
  #
  # source://prism//lib/prism/node.rb#3887
  sig { returns(Symbol) }
  def name; end

  # The location of the variable name.
  #
  #     @@foo = :bar
  #     ^^^^^
  #
  # source://prism//lib/prism/node.rb#3893
  sig { returns(Prism::Location) }
  def name_loc; end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#3919
  sig { returns(String) }
  def operator; end

  # The location of the `=` operator.
  #
  #     @@foo = :bar
  #           ^
  #
  # source://prism//lib/prism/node.rb#3912
  sig { returns(Prism::Location) }
  def operator_loc; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#3929
  sig { override.returns(Symbol) }
  def type; end

  # The value to write to the class variable. This can be any [non-void expression](https://github.com/ruby/prism/blob/main/docs/parsing_rules.md#non-void-expression).
  #
  #     @@foo = :bar
  #             ^^^^
  #
  #     @@_xyz = 123
  #              ^^^
  #
  # source://prism//lib/prism/node.rb#3906
  sig { returns(Prism::Node) }
  def value; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#3934
    def type; end
  end
end

# A cache that can be used to quickly compute code unit offsets from byte
# offsets. It purposefully provides only a single #[] method to access the
# cache in order to minimize surface area.
#
# Note that there are some known issues here that may or may not be addressed
# in the future:
#
# * The first is that there are issues when the cache computes values that are
#   not on character boundaries. This can result in subsequent computations
#   being off by one or more code units.
# * The second is that this cache is currently unbounded. In theory we could
#   introduce some kind of LRU cache to limit the number of entries, but this
#   has not yet been implemented.
#
# source://prism//lib/prism/parse_result.rb#172
class Prism::CodeUnitsCache
  # Initialize a new cache with the given source and encoding.
  #
  # @return [CodeUnitsCache] a new instance of CodeUnitsCache
  #
  # source://prism//lib/prism/parse_result.rb#198
  sig { params(source: String, encoding: Encoding).void }
  def initialize(source, encoding); end

  # Retrieve the code units offset from the given byte offset.
  #
  # source://prism//lib/prism/parse_result.rb#212
  sig { params(byte_offset: Integer).returns(Integer) }
  def [](byte_offset); end
end

# source://prism//lib/prism/parse_result.rb#184
class Prism::CodeUnitsCache::LengthCounter
  # @return [LengthCounter] a new instance of LengthCounter
  #
  # source://prism//lib/prism/parse_result.rb#185
  def initialize(source, encoding); end

  # source://prism//lib/prism/parse_result.rb#190
  def count(byte_offset, byte_length); end
end

# source://prism//lib/prism/parse_result.rb#173
class Prism::CodeUnitsCache::UTF16Counter
  # @return [UTF16Counter] a new instance of UTF16Counter
  #
  # source://prism//lib/prism/parse_result.rb#174
  def initialize(source, encoding); end

  # source://prism//lib/prism/parse_result.rb#179
  def count(byte_offset, byte_length); end
end

# This represents a comment that was encountered during parsing. It is the
# base class for all comment types.
#
# source://prism//lib/prism/parse_result.rb#507
class Prism::Comment
  abstract!

  # Create a new comment object with the given location.
  #
  # @return [Comment] a new instance of Comment
  #
  # source://prism//lib/prism/parse_result.rb#512
  sig { params(location: Prism::Location).void }
  def initialize(location); end

  # Implement the hash pattern matching interface for Comment.
  #
  # source://prism//lib/prism/parse_result.rb#517
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # The location of this comment in the source.
  #
  # source://prism//lib/prism/parse_result.rb#509
  sig { returns(Prism::Location) }
  def location; end

  # Returns the content of the comment by slicing it from the source code.
  #
  # source://prism//lib/prism/parse_result.rb#522
  sig { returns(String) }
  def slice; end

  sig { abstract.returns(T::Boolean) }
  def trailing?; end
end

# A compiler is a visitor that returns the value of each node as it visits.
# This is as opposed to a visitor which will only walk the tree. This can be
# useful when you are trying to compile a tree into a different format.
#
# For example, to build a representation of the tree as s-expressions, you
# could write:
#
#     class SExpressions < Prism::Compiler
#       def visit_arguments_node(node) = [:arguments, super]
#       def visit_call_node(node) = [:call, super]
#       def visit_integer_node(node) = [:integer]
#       def visit_program_node(node) = [:program, super]
#     end
#
#     Prism.parse("1 + 2").value.accept(SExpressions.new)
#     # => [:program, [[[:call, [[:integer], [:arguments, [[:integer]]]]]]]]
#
# source://prism//lib/prism/compiler.rb#27
class Prism::Compiler < ::Prism::Visitor
  # Visit an individual node.
  #
  # source://prism//lib/prism/compiler.rb#29
  sig { params(node: T.nilable(Prism::Node)).returns(T.untyped) }
  def visit(node); end

  # Visit the child nodes of the given node.
  # Compile a AliasGlobalVariableNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_alias_global_variable_node(node); end

  # Visit the child nodes of the given node.
  # Compile a AliasMethodNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_alias_method_node(node); end

  # Visit a list of nodes.
  #
  # source://prism//lib/prism/compiler.rb#34
  sig { params(nodes: T::Array[T.nilable(Prism::Node)]).returns(T::Array[T.untyped]) }
  def visit_all(nodes); end

  # Visit the child nodes of the given node.
  # Compile a AlternationPatternNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_alternation_pattern_node(node); end

  # Visit the child nodes of the given node.
  # Compile a AndNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_and_node(node); end

  # Visit the child nodes of the given node.
  # Compile a ArgumentsNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_arguments_node(node); end

  # Visit the child nodes of the given node.
  # Compile a ArrayNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_array_node(node); end

  # Visit the child nodes of the given node.
  # Compile a ArrayPatternNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_array_pattern_node(node); end

  # Visit the child nodes of the given node.
  # Compile a AssocNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_assoc_node(node); end

  # Visit the child nodes of the given node.
  # Compile a AssocSplatNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_assoc_splat_node(node); end

  # Visit the child nodes of the given node.
  # Compile a BackReferenceReadNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_back_reference_read_node(node); end

  # Visit the child nodes of the given node.
  # Compile a BeginNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_begin_node(node); end

  # Visit the child nodes of the given node.
  # Compile a BlockArgumentNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_block_argument_node(node); end

  # Visit the child nodes of the given node.
  # Compile a BlockLocalVariableNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_block_local_variable_node(node); end

  # Visit the child nodes of the given node.
  # Compile a BlockNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_block_node(node); end

  # Visit the child nodes of the given node.
  # Compile a BlockParameterNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_block_parameter_node(node); end

  # Visit the child nodes of the given node.
  # Compile a BlockParametersNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_block_parameters_node(node); end

  # Visit the child nodes of the given node.
  # Compile a BreakNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_break_node(node); end

  # Visit the child nodes of the given node.
  # Compile a CallAndWriteNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_call_and_write_node(node); end

  # Visit the child nodes of the given node.
  # Compile a CallNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_call_node(node); end

  # Visit the child nodes of the given node.
  # Compile a CallOperatorWriteNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_call_operator_write_node(node); end

  # Visit the child nodes of the given node.
  # Compile a CallOrWriteNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_call_or_write_node(node); end

  # Visit the child nodes of the given node.
  # Compile a CallTargetNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_call_target_node(node); end

  # Visit the child nodes of the given node.
  # Compile a CapturePatternNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_capture_pattern_node(node); end

  # Visit the child nodes of the given node.
  # Compile a CaseMatchNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_case_match_node(node); end

  # Visit the child nodes of the given node.
  # Compile a CaseNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_case_node(node); end

  # Visit the child nodes of the given node.
  #
  # source://prism//lib/prism/compiler.rb#39
  sig { params(node: Prism::Node).returns(T::Array[T.untyped]) }
  def visit_child_nodes(node); end

  # Visit the child nodes of the given node.
  # Compile a ClassNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_class_node(node); end

  # Visit the child nodes of the given node.
  # Compile a ClassVariableAndWriteNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_class_variable_and_write_node(node); end

  # Visit the child nodes of the given node.
  # Compile a ClassVariableOperatorWriteNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_class_variable_operator_write_node(node); end

  # Visit the child nodes of the given node.
  # Compile a ClassVariableOrWriteNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_class_variable_or_write_node(node); end

  # Visit the child nodes of the given node.
  # Compile a ClassVariableReadNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_class_variable_read_node(node); end

  # Visit the child nodes of the given node.
  # Compile a ClassVariableTargetNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_class_variable_target_node(node); end

  # Visit the child nodes of the given node.
  # Compile a ClassVariableWriteNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_class_variable_write_node(node); end

  # Visit the child nodes of the given node.
  # Compile a ConstantAndWriteNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_constant_and_write_node(node); end

  # Visit the child nodes of the given node.
  # Compile a ConstantOperatorWriteNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_constant_operator_write_node(node); end

  # Visit the child nodes of the given node.
  # Compile a ConstantOrWriteNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_constant_or_write_node(node); end

  # Visit the child nodes of the given node.
  # Compile a ConstantPathAndWriteNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_constant_path_and_write_node(node); end

  # Visit the child nodes of the given node.
  # Compile a ConstantPathNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_constant_path_node(node); end

  # Visit the child nodes of the given node.
  # Compile a ConstantPathOperatorWriteNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_constant_path_operator_write_node(node); end

  # Visit the child nodes of the given node.
  # Compile a ConstantPathOrWriteNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_constant_path_or_write_node(node); end

  # Visit the child nodes of the given node.
  # Compile a ConstantPathTargetNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_constant_path_target_node(node); end

  # Visit the child nodes of the given node.
  # Compile a ConstantPathWriteNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_constant_path_write_node(node); end

  # Visit the child nodes of the given node.
  # Compile a ConstantReadNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_constant_read_node(node); end

  # Visit the child nodes of the given node.
  # Compile a ConstantTargetNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_constant_target_node(node); end

  # Visit the child nodes of the given node.
  # Compile a ConstantWriteNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_constant_write_node(node); end

  # Visit the child nodes of the given node.
  # Compile a DefNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_def_node(node); end

  # Visit the child nodes of the given node.
  # Compile a DefinedNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_defined_node(node); end

  # Visit the child nodes of the given node.
  # Compile a ElseNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_else_node(node); end

  # Visit the child nodes of the given node.
  # Compile a EmbeddedStatementsNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_embedded_statements_node(node); end

  # Visit the child nodes of the given node.
  # Compile a EmbeddedVariableNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_embedded_variable_node(node); end

  # Visit the child nodes of the given node.
  # Compile a EnsureNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_ensure_node(node); end

  # Visit the child nodes of the given node.
  # Compile a FalseNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_false_node(node); end

  # Visit the child nodes of the given node.
  # Compile a FindPatternNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_find_pattern_node(node); end

  # Visit the child nodes of the given node.
  # Compile a FlipFlopNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_flip_flop_node(node); end

  # Visit the child nodes of the given node.
  # Compile a FloatNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_float_node(node); end

  # Visit the child nodes of the given node.
  # Compile a ForNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_for_node(node); end

  # Visit the child nodes of the given node.
  # Compile a ForwardingArgumentsNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_forwarding_arguments_node(node); end

  # Visit the child nodes of the given node.
  # Compile a ForwardingParameterNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_forwarding_parameter_node(node); end

  # Visit the child nodes of the given node.
  # Compile a ForwardingSuperNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_forwarding_super_node(node); end

  # Visit the child nodes of the given node.
  # Compile a GlobalVariableAndWriteNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_global_variable_and_write_node(node); end

  # Visit the child nodes of the given node.
  # Compile a GlobalVariableOperatorWriteNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_global_variable_operator_write_node(node); end

  # Visit the child nodes of the given node.
  # Compile a GlobalVariableOrWriteNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_global_variable_or_write_node(node); end

  # Visit the child nodes of the given node.
  # Compile a GlobalVariableReadNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_global_variable_read_node(node); end

  # Visit the child nodes of the given node.
  # Compile a GlobalVariableTargetNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_global_variable_target_node(node); end

  # Visit the child nodes of the given node.
  # Compile a GlobalVariableWriteNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_global_variable_write_node(node); end

  # Visit the child nodes of the given node.
  # Compile a HashNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_hash_node(node); end

  # Visit the child nodes of the given node.
  # Compile a HashPatternNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_hash_pattern_node(node); end

  # Visit the child nodes of the given node.
  # Compile a IfNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_if_node(node); end

  # Visit the child nodes of the given node.
  # Compile a ImaginaryNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_imaginary_node(node); end

  # Visit the child nodes of the given node.
  # Compile a ImplicitNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_implicit_node(node); end

  # Visit the child nodes of the given node.
  # Compile a ImplicitRestNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_implicit_rest_node(node); end

  # Visit the child nodes of the given node.
  # Compile a InNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_in_node(node); end

  # Visit the child nodes of the given node.
  # Compile a IndexAndWriteNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_index_and_write_node(node); end

  # Visit the child nodes of the given node.
  # Compile a IndexOperatorWriteNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_index_operator_write_node(node); end

  # Visit the child nodes of the given node.
  # Compile a IndexOrWriteNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_index_or_write_node(node); end

  # Visit the child nodes of the given node.
  # Compile a IndexTargetNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_index_target_node(node); end

  # Visit the child nodes of the given node.
  # Compile a InstanceVariableAndWriteNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_instance_variable_and_write_node(node); end

  # Visit the child nodes of the given node.
  # Compile a InstanceVariableOperatorWriteNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_instance_variable_operator_write_node(node); end

  # Visit the child nodes of the given node.
  # Compile a InstanceVariableOrWriteNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_instance_variable_or_write_node(node); end

  # Visit the child nodes of the given node.
  # Compile a InstanceVariableReadNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_instance_variable_read_node(node); end

  # Visit the child nodes of the given node.
  # Compile a InstanceVariableTargetNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_instance_variable_target_node(node); end

  # Visit the child nodes of the given node.
  # Compile a InstanceVariableWriteNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_instance_variable_write_node(node); end

  # Visit the child nodes of the given node.
  # Compile a IntegerNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_integer_node(node); end

  # Visit the child nodes of the given node.
  # Compile a InterpolatedMatchLastLineNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_interpolated_match_last_line_node(node); end

  # Visit the child nodes of the given node.
  # Compile a InterpolatedRegularExpressionNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_interpolated_regular_expression_node(node); end

  # Visit the child nodes of the given node.
  # Compile a InterpolatedStringNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_interpolated_string_node(node); end

  # Visit the child nodes of the given node.
  # Compile a InterpolatedSymbolNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_interpolated_symbol_node(node); end

  # Visit the child nodes of the given node.
  # Compile a InterpolatedXStringNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_interpolated_x_string_node(node); end

  # Visit the child nodes of the given node.
  # Compile a ItLocalVariableReadNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_it_local_variable_read_node(node); end

  # Visit the child nodes of the given node.
  # Compile a ItParametersNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_it_parameters_node(node); end

  # Visit the child nodes of the given node.
  # Compile a KeywordHashNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_keyword_hash_node(node); end

  # Visit the child nodes of the given node.
  # Compile a KeywordRestParameterNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_keyword_rest_parameter_node(node); end

  # Visit the child nodes of the given node.
  # Compile a LambdaNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_lambda_node(node); end

  # Visit the child nodes of the given node.
  # Compile a LocalVariableAndWriteNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_local_variable_and_write_node(node); end

  # Visit the child nodes of the given node.
  # Compile a LocalVariableOperatorWriteNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_local_variable_operator_write_node(node); end

  # Visit the child nodes of the given node.
  # Compile a LocalVariableOrWriteNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_local_variable_or_write_node(node); end

  # Visit the child nodes of the given node.
  # Compile a LocalVariableReadNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_local_variable_read_node(node); end

  # Visit the child nodes of the given node.
  # Compile a LocalVariableTargetNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_local_variable_target_node(node); end

  # Visit the child nodes of the given node.
  # Compile a LocalVariableWriteNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_local_variable_write_node(node); end

  # Visit the child nodes of the given node.
  # Compile a MatchLastLineNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_match_last_line_node(node); end

  # Visit the child nodes of the given node.
  # Compile a MatchPredicateNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_match_predicate_node(node); end

  # Visit the child nodes of the given node.
  # Compile a MatchRequiredNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_match_required_node(node); end

  # Visit the child nodes of the given node.
  # Compile a MatchWriteNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_match_write_node(node); end

  # Visit the child nodes of the given node.
  # Compile a MissingNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_missing_node(node); end

  # Visit the child nodes of the given node.
  # Compile a ModuleNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_module_node(node); end

  # Visit the child nodes of the given node.
  # Compile a MultiTargetNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_multi_target_node(node); end

  # Visit the child nodes of the given node.
  # Compile a MultiWriteNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_multi_write_node(node); end

  # Visit the child nodes of the given node.
  # Compile a NextNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_next_node(node); end

  # Visit the child nodes of the given node.
  # Compile a NilNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_nil_node(node); end

  # Visit the child nodes of the given node.
  # Compile a NoKeywordsParameterNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_no_keywords_parameter_node(node); end

  # Visit the child nodes of the given node.
  # Compile a NumberedParametersNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_numbered_parameters_node(node); end

  # Visit the child nodes of the given node.
  # Compile a NumberedReferenceReadNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_numbered_reference_read_node(node); end

  # Visit the child nodes of the given node.
  # Compile a OptionalKeywordParameterNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_optional_keyword_parameter_node(node); end

  # Visit the child nodes of the given node.
  # Compile a OptionalParameterNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_optional_parameter_node(node); end

  # Visit the child nodes of the given node.
  # Compile a OrNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_or_node(node); end

  # Visit the child nodes of the given node.
  # Compile a ParametersNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_parameters_node(node); end

  # Visit the child nodes of the given node.
  # Compile a ParenthesesNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_parentheses_node(node); end

  # Visit the child nodes of the given node.
  # Compile a PinnedExpressionNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_pinned_expression_node(node); end

  # Visit the child nodes of the given node.
  # Compile a PinnedVariableNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_pinned_variable_node(node); end

  # Visit the child nodes of the given node.
  # Compile a PostExecutionNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_post_execution_node(node); end

  # Visit the child nodes of the given node.
  # Compile a PreExecutionNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_pre_execution_node(node); end

  # Visit the child nodes of the given node.
  # Compile a ProgramNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_program_node(node); end

  # Visit the child nodes of the given node.
  # Compile a RangeNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_range_node(node); end

  # Visit the child nodes of the given node.
  # Compile a RationalNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_rational_node(node); end

  # Visit the child nodes of the given node.
  # Compile a RedoNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_redo_node(node); end

  # Visit the child nodes of the given node.
  # Compile a RegularExpressionNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_regular_expression_node(node); end

  # Visit the child nodes of the given node.
  # Compile a RequiredKeywordParameterNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_required_keyword_parameter_node(node); end

  # Visit the child nodes of the given node.
  # Compile a RequiredParameterNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_required_parameter_node(node); end

  # Visit the child nodes of the given node.
  # Compile a RescueModifierNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_rescue_modifier_node(node); end

  # Visit the child nodes of the given node.
  # Compile a RescueNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_rescue_node(node); end

  # Visit the child nodes of the given node.
  # Compile a RestParameterNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_rest_parameter_node(node); end

  # Visit the child nodes of the given node.
  # Compile a RetryNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_retry_node(node); end

  # Visit the child nodes of the given node.
  # Compile a ReturnNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_return_node(node); end

  # Visit the child nodes of the given node.
  # Compile a SelfNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_self_node(node); end

  # Visit the child nodes of the given node.
  # Compile a ShareableConstantNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_shareable_constant_node(node); end

  # Visit the child nodes of the given node.
  # Compile a SingletonClassNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_singleton_class_node(node); end

  # Visit the child nodes of the given node.
  # Compile a SourceEncodingNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_source_encoding_node(node); end

  # Visit the child nodes of the given node.
  # Compile a SourceFileNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_source_file_node(node); end

  # Visit the child nodes of the given node.
  # Compile a SourceLineNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_source_line_node(node); end

  # Visit the child nodes of the given node.
  # Compile a SplatNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_splat_node(node); end

  # Visit the child nodes of the given node.
  # Compile a StatementsNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_statements_node(node); end

  # Visit the child nodes of the given node.
  # Compile a StringNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_string_node(node); end

  # Visit the child nodes of the given node.
  # Compile a SuperNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_super_node(node); end

  # Visit the child nodes of the given node.
  # Compile a SymbolNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_symbol_node(node); end

  # Visit the child nodes of the given node.
  # Compile a TrueNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_true_node(node); end

  # Visit the child nodes of the given node.
  # Compile a UndefNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_undef_node(node); end

  # Visit the child nodes of the given node.
  # Compile a UnlessNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_unless_node(node); end

  # Visit the child nodes of the given node.
  # Compile a UntilNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_until_node(node); end

  # Visit the child nodes of the given node.
  # Compile a WhenNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_when_node(node); end

  # Visit the child nodes of the given node.
  # Compile a WhileNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_while_node(node); end

  # Visit the child nodes of the given node.
  # Compile a XStringNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_x_string_node(node); end

  # Visit the child nodes of the given node.
  # Compile a YieldNode node
  #
  # source://prism//lib/prism/compiler.rb#39
  def visit_yield_node(node); end
end

# Represents the use of the `&&=` operator for assignment to a constant.
#
#     Target &&= value
#     ^^^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#3953
class Prism::ConstantAndWriteNode < ::Prism::Node
  # Initialize a new ConstantAndWriteNode node.
  #
  # @return [ConstantAndWriteNode] a new instance of ConstantAndWriteNode
  #
  # source://prism//lib/prism/node.rb#3955
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      name_loc: Prism::Location,
      operator_loc: Prism::Location,
      value: Prism::Node
    ).void
  end
  def initialize(source, node_id, location, flags, name, name_loc, operator_loc, value); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#4041
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#3967
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#3972
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#3982
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#3977
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?name: Symbol, ?name_loc: Location, ?operator_loc: Location, ?value: Prism::node) -> ConstantAndWriteNode
  #
  # source://prism//lib/prism/node.rb#3987
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      name_loc: Prism::Location,
      operator_loc: Prism::Location,
      value: Prism::Node
    ).returns(Prism::ConstantAndWriteNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil), name_loc: T.unsafe(nil), operator_loc: T.unsafe(nil), value: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#3972
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, name: Symbol, name_loc: Location, operator_loc: Location, value: Prism::node }
  #
  # source://prism//lib/prism/node.rb#3995
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # source://prism//lib/prism/desugar_compiler.rb#182
  def desugar; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#4025
  sig { override.returns(String) }
  def inspect; end

  # attr_reader name: Symbol
  #
  # source://prism//lib/prism/node.rb#4000
  sig { returns(Symbol) }
  def name; end

  # attr_reader name_loc: Location
  #
  # source://prism//lib/prism/node.rb#4003
  sig { returns(Prism::Location) }
  def name_loc; end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#4020
  sig { returns(String) }
  def operator; end

  # attr_reader operator_loc: Location
  #
  # source://prism//lib/prism/node.rb#4010
  sig { returns(Prism::Location) }
  def operator_loc; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#4030
  sig { override.returns(Symbol) }
  def type; end

  # attr_reader value: Prism::node
  #
  # source://prism//lib/prism/node.rb#4017
  sig { returns(Prism::Node) }
  def value; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#4035
    def type; end
  end
end

# Represents assigning to a constant using an operator that isn't `=`.
#
#     Target += value
#     ^^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#4054
class Prism::ConstantOperatorWriteNode < ::Prism::Node
  # Initialize a new ConstantOperatorWriteNode node.
  #
  # @return [ConstantOperatorWriteNode] a new instance of ConstantOperatorWriteNode
  #
  # source://prism//lib/prism/node.rb#4056
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      name_loc: Prism::Location,
      binary_operator_loc: Prism::Location,
      value: Prism::Node,
      binary_operator: Symbol
    ).void
  end
  def initialize(source, node_id, location, flags, name, name_loc, binary_operator_loc, value, binary_operator); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#4141
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#4069
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # attr_reader binary_operator: Symbol
  #
  # source://prism//lib/prism/node.rb#4122
  sig { returns(Symbol) }
  def binary_operator; end

  # attr_reader binary_operator_loc: Location
  #
  # source://prism//lib/prism/node.rb#4112
  sig { returns(Prism::Location) }
  def binary_operator_loc; end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#4074
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#4084
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#4079
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?name: Symbol, ?name_loc: Location, ?binary_operator_loc: Location, ?value: Prism::node, ?binary_operator: Symbol) -> ConstantOperatorWriteNode
  #
  # source://prism//lib/prism/node.rb#4089
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      name_loc: Prism::Location,
      binary_operator_loc: Prism::Location,
      value: Prism::Node,
      binary_operator: Symbol
    ).returns(Prism::ConstantOperatorWriteNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil), name_loc: T.unsafe(nil), binary_operator_loc: T.unsafe(nil), value: T.unsafe(nil), binary_operator: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#4074
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, name: Symbol, name_loc: Location, binary_operator_loc: Location, value: Prism::node, binary_operator: Symbol }
  #
  # source://prism//lib/prism/node.rb#4097
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # source://prism//lib/prism/desugar_compiler.rb#194
  def desugar; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#4125
  sig { override.returns(String) }
  def inspect; end

  # attr_reader name: Symbol
  #
  # source://prism//lib/prism/node.rb#4102
  sig { returns(Symbol) }
  def name; end

  # attr_reader name_loc: Location
  #
  # source://prism//lib/prism/node.rb#4105
  sig { returns(Prism::Location) }
  def name_loc; end

  # Returns the binary operator used to modify the receiver. This method is
  # deprecated in favor of #binary_operator.
  #
  # source://prism//lib/prism/node_ext.rb#371
  def operator; end

  # Returns the location of the binary operator used to modify the receiver.
  # This method is deprecated in favor of #binary_operator_loc.
  #
  # source://prism//lib/prism/node_ext.rb#378
  def operator_loc; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#4130
  sig { override.returns(Symbol) }
  def type; end

  # attr_reader value: Prism::node
  #
  # source://prism//lib/prism/node.rb#4119
  sig { returns(Prism::Node) }
  def value; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#4135
    def type; end
  end
end

# Represents the use of the `||=` operator for assignment to a constant.
#
#     Target ||= value
#     ^^^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#4155
class Prism::ConstantOrWriteNode < ::Prism::Node
  # Initialize a new ConstantOrWriteNode node.
  #
  # @return [ConstantOrWriteNode] a new instance of ConstantOrWriteNode
  #
  # source://prism//lib/prism/node.rb#4157
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      name_loc: Prism::Location,
      operator_loc: Prism::Location,
      value: Prism::Node
    ).void
  end
  def initialize(source, node_id, location, flags, name, name_loc, operator_loc, value); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#4243
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#4169
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#4174
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#4184
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#4179
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?name: Symbol, ?name_loc: Location, ?operator_loc: Location, ?value: Prism::node) -> ConstantOrWriteNode
  #
  # source://prism//lib/prism/node.rb#4189
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      name_loc: Prism::Location,
      operator_loc: Prism::Location,
      value: Prism::Node
    ).returns(Prism::ConstantOrWriteNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil), name_loc: T.unsafe(nil), operator_loc: T.unsafe(nil), value: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#4174
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, name: Symbol, name_loc: Location, operator_loc: Location, value: Prism::node }
  #
  # source://prism//lib/prism/node.rb#4197
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # source://prism//lib/prism/desugar_compiler.rb#188
  def desugar; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#4227
  sig { override.returns(String) }
  def inspect; end

  # attr_reader name: Symbol
  #
  # source://prism//lib/prism/node.rb#4202
  sig { returns(Symbol) }
  def name; end

  # attr_reader name_loc: Location
  #
  # source://prism//lib/prism/node.rb#4205
  sig { returns(Prism::Location) }
  def name_loc; end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#4222
  sig { returns(String) }
  def operator; end

  # attr_reader operator_loc: Location
  #
  # source://prism//lib/prism/node.rb#4212
  sig { returns(Prism::Location) }
  def operator_loc; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#4232
  sig { override.returns(Symbol) }
  def type; end

  # attr_reader value: Prism::node
  #
  # source://prism//lib/prism/node.rb#4219
  sig { returns(Prism::Node) }
  def value; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#4237
    def type; end
  end
end

# Represents the use of the `&&=` operator for assignment to a constant path.
#
#     Parent::Child &&= value
#     ^^^^^^^^^^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#4256
class Prism::ConstantPathAndWriteNode < ::Prism::Node
  # Initialize a new ConstantPathAndWriteNode node.
  #
  # @return [ConstantPathAndWriteNode] a new instance of ConstantPathAndWriteNode
  #
  # source://prism//lib/prism/node.rb#4258
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      target: Prism::ConstantPathNode,
      operator_loc: Prism::Location,
      value: Prism::Node
    ).void
  end
  def initialize(source, node_id, location, flags, target, operator_loc, value); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#4336
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#4269
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#4274
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#4284
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#4279
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?target: ConstantPathNode, ?operator_loc: Location, ?value: Prism::node) -> ConstantPathAndWriteNode
  #
  # source://prism//lib/prism/node.rb#4289
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      target: Prism::ConstantPathNode,
      operator_loc: Prism::Location,
      value: Prism::Node
    ).returns(Prism::ConstantPathAndWriteNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), target: T.unsafe(nil), operator_loc: T.unsafe(nil), value: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#4274
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, target: ConstantPathNode, operator_loc: Location, value: Prism::node }
  #
  # source://prism//lib/prism/node.rb#4297
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#4320
  sig { override.returns(String) }
  def inspect; end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#4315
  sig { returns(String) }
  def operator; end

  # attr_reader operator_loc: Location
  #
  # source://prism//lib/prism/node.rb#4305
  sig { returns(Prism::Location) }
  def operator_loc; end

  # attr_reader target: ConstantPathNode
  #
  # source://prism//lib/prism/node.rb#4302
  sig { returns(Prism::ConstantPathNode) }
  def target; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#4325
  sig { override.returns(Symbol) }
  def type; end

  # attr_reader value: Prism::node
  #
  # source://prism//lib/prism/node.rb#4312
  sig { returns(Prism::Node) }
  def value; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#4330
    def type; end
  end
end

# Represents accessing a constant through a path of `::` operators.
#
#     Foo::Bar
#     ^^^^^^^^
#
# source://prism//lib/prism/node.rb#4348
class Prism::ConstantPathNode < ::Prism::Node
  # Initialize a new ConstantPathNode node.
  #
  # @return [ConstantPathNode] a new instance of ConstantPathNode
  #
  # source://prism//lib/prism/node.rb#4350
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      parent: T.nilable(Prism::Node),
      name: T.nilable(Symbol),
      delimiter_loc: Prism::Location,
      name_loc: Prism::Location
    ).void
  end
  def initialize(source, node_id, location, flags, parent, name, delimiter_loc, name_loc); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#4459
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#4362
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # Previously, we had a child node on this class that contained either a
  # constant read or a missing node. To not cause a breaking change, we
  # continue to supply that API.
  #
  # source://prism//lib/prism/node_ext.rb#202
  def child; end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#4367
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#4379
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#4372
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?parent: Prism::node?, ?name: Symbol?, ?delimiter_loc: Location, ?name_loc: Location) -> ConstantPathNode
  #
  # source://prism//lib/prism/node.rb#4384
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      parent: T.nilable(Prism::Node),
      name: T.nilable(Symbol),
      delimiter_loc: Prism::Location,
      name_loc: Prism::Location
    ).returns(Prism::ConstantPathNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), parent: T.unsafe(nil), name: T.unsafe(nil), delimiter_loc: T.unsafe(nil), name_loc: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#4367
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, parent: Prism::node?, name: Symbol?, delimiter_loc: Location, name_loc: Location }
  #
  # source://prism//lib/prism/node.rb#4392
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def delimiter: () -> String
  #
  # source://prism//lib/prism/node.rb#4438
  sig { returns(String) }
  def delimiter; end

  # The location of the `::` delimiter.
  #
  #     ::Foo
  #     ^^
  #
  #     One::Two
  #        ^^
  #
  # source://prism//lib/prism/node.rb#4418
  sig { returns(Prism::Location) }
  def delimiter_loc; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # Returns the full name of this constant path. For example: "Foo::Bar"
  #
  # source://prism//lib/prism/node_ext.rb#195
  sig { returns(String) }
  def full_name; end

  # Returns the list of parts for the full name of this constant path.
  # For example: [:Foo, :Bar]
  #
  # source://prism//lib/prism/node_ext.rb#173
  sig { returns(T::Array[Symbol]) }
  def full_name_parts; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#4443
  sig { override.returns(String) }
  def inspect; end

  # The name of the constant being accessed. This could be `nil` in the event of a syntax error.
  #
  # source://prism//lib/prism/node.rb#4409
  sig { returns(T.nilable(Symbol)) }
  def name; end

  # The location of the name of the constant.
  #
  #     ::Foo
  #       ^^^
  #
  #     One::Two
  #          ^^^
  #
  # source://prism//lib/prism/node.rb#4431
  sig { returns(Prism::Location) }
  def name_loc; end

  # The left-hand node of the path, if present. It can be `nil` or any [non-void expression](https://github.com/ruby/prism/blob/main/docs/parsing_rules.md#non-void-expression). It will be `nil` when the constant lookup is at the root of the module tree.
  #
  #     Foo::Bar
  #     ^^^
  #
  #     self::Test
  #     ^^^^
  #
  #     a.b::C
  #     ^^^
  #
  # source://prism//lib/prism/node.rb#4406
  sig { returns(T.nilable(Prism::Node)) }
  def parent; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#4448
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#4453
    def type; end
  end
end

# An error class raised when dynamic parts are found while computing a
# constant path's full name. For example:
# Foo::Bar::Baz -> does not raise because all parts of the constant path are
# simple constants
# var::Bar::Baz -> raises because the first part of the constant path is a
# local variable
#
# source://prism//lib/prism/node_ext.rb#164
class Prism::ConstantPathNode::DynamicPartsInConstantPathError < ::StandardError; end

# An error class raised when missing nodes are found while computing a
# constant path's full name. For example:
# Foo:: -> raises because the constant path is missing the last part
#
# source://prism//lib/prism/node_ext.rb#169
class Prism::ConstantPathNode::MissingNodesInConstantPathError < ::StandardError; end

# Represents assigning to a constant path using an operator that isn't `=`.
#
#     Parent::Child += value
#     ^^^^^^^^^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#4472
class Prism::ConstantPathOperatorWriteNode < ::Prism::Node
  # Initialize a new ConstantPathOperatorWriteNode node.
  #
  # @return [ConstantPathOperatorWriteNode] a new instance of ConstantPathOperatorWriteNode
  #
  # source://prism//lib/prism/node.rb#4474
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      target: Prism::ConstantPathNode,
      binary_operator_loc: Prism::Location,
      value: Prism::Node,
      binary_operator: Symbol
    ).void
  end
  def initialize(source, node_id, location, flags, target, binary_operator_loc, value, binary_operator); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#4551
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#4486
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # attr_reader binary_operator: Symbol
  #
  # source://prism//lib/prism/node.rb#4532
  sig { returns(Symbol) }
  def binary_operator; end

  # attr_reader binary_operator_loc: Location
  #
  # source://prism//lib/prism/node.rb#4522
  sig { returns(Prism::Location) }
  def binary_operator_loc; end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#4491
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#4501
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#4496
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?target: ConstantPathNode, ?binary_operator_loc: Location, ?value: Prism::node, ?binary_operator: Symbol) -> ConstantPathOperatorWriteNode
  #
  # source://prism//lib/prism/node.rb#4506
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      target: Prism::ConstantPathNode,
      binary_operator_loc: Prism::Location,
      value: Prism::Node,
      binary_operator: Symbol
    ).returns(Prism::ConstantPathOperatorWriteNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), target: T.unsafe(nil), binary_operator_loc: T.unsafe(nil), value: T.unsafe(nil), binary_operator: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#4491
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, target: ConstantPathNode, binary_operator_loc: Location, value: Prism::node, binary_operator: Symbol }
  #
  # source://prism//lib/prism/node.rb#4514
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#4535
  sig { override.returns(String) }
  def inspect; end

  # Returns the binary operator used to modify the receiver. This method is
  # deprecated in favor of #binary_operator.
  #
  # source://prism//lib/prism/node_ext.rb#387
  def operator; end

  # Returns the location of the binary operator used to modify the receiver.
  # This method is deprecated in favor of #binary_operator_loc.
  #
  # source://prism//lib/prism/node_ext.rb#394
  def operator_loc; end

  # attr_reader target: ConstantPathNode
  #
  # source://prism//lib/prism/node.rb#4519
  sig { returns(Prism::ConstantPathNode) }
  def target; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#4540
  sig { override.returns(Symbol) }
  def type; end

  # attr_reader value: Prism::node
  #
  # source://prism//lib/prism/node.rb#4529
  sig { returns(Prism::Node) }
  def value; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#4545
    def type; end
  end
end

# Represents the use of the `||=` operator for assignment to a constant path.
#
#     Parent::Child ||= value
#     ^^^^^^^^^^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#4564
class Prism::ConstantPathOrWriteNode < ::Prism::Node
  # Initialize a new ConstantPathOrWriteNode node.
  #
  # @return [ConstantPathOrWriteNode] a new instance of ConstantPathOrWriteNode
  #
  # source://prism//lib/prism/node.rb#4566
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      target: Prism::ConstantPathNode,
      operator_loc: Prism::Location,
      value: Prism::Node
    ).void
  end
  def initialize(source, node_id, location, flags, target, operator_loc, value); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#4644
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#4577
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#4582
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#4592
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#4587
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?target: ConstantPathNode, ?operator_loc: Location, ?value: Prism::node) -> ConstantPathOrWriteNode
  #
  # source://prism//lib/prism/node.rb#4597
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      target: Prism::ConstantPathNode,
      operator_loc: Prism::Location,
      value: Prism::Node
    ).returns(Prism::ConstantPathOrWriteNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), target: T.unsafe(nil), operator_loc: T.unsafe(nil), value: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#4582
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, target: ConstantPathNode, operator_loc: Location, value: Prism::node }
  #
  # source://prism//lib/prism/node.rb#4605
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#4628
  sig { override.returns(String) }
  def inspect; end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#4623
  sig { returns(String) }
  def operator; end

  # attr_reader operator_loc: Location
  #
  # source://prism//lib/prism/node.rb#4613
  sig { returns(Prism::Location) }
  def operator_loc; end

  # attr_reader target: ConstantPathNode
  #
  # source://prism//lib/prism/node.rb#4610
  sig { returns(Prism::ConstantPathNode) }
  def target; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#4633
  sig { override.returns(Symbol) }
  def type; end

  # attr_reader value: Prism::node
  #
  # source://prism//lib/prism/node.rb#4620
  sig { returns(Prism::Node) }
  def value; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#4638
    def type; end
  end
end

# Represents writing to a constant path in a context that doesn't have an explicit value.
#
#     Foo::Foo, Bar::Bar = baz
#     ^^^^^^^^  ^^^^^^^^
#
# source://prism//lib/prism/node.rb#4656
class Prism::ConstantPathTargetNode < ::Prism::Node
  # Initialize a new ConstantPathTargetNode node.
  #
  # @return [ConstantPathTargetNode] a new instance of ConstantPathTargetNode
  #
  # source://prism//lib/prism/node.rb#4658
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      parent: T.nilable(Prism::Node),
      name: T.nilable(Symbol),
      delimiter_loc: Prism::Location,
      name_loc: Prism::Location
    ).void
  end
  def initialize(source, node_id, location, flags, parent, name, delimiter_loc, name_loc); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#4746
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#4670
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # Previously, we had a child node on this class that contained either a
  # constant read or a missing node. To not cause a breaking change, we
  # continue to supply that API.
  #
  # source://prism//lib/prism/node_ext.rb#243
  def child; end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#4675
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#4687
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#4680
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?parent: Prism::node?, ?name: Symbol?, ?delimiter_loc: Location, ?name_loc: Location) -> ConstantPathTargetNode
  #
  # source://prism//lib/prism/node.rb#4692
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      parent: T.nilable(Prism::Node),
      name: T.nilable(Symbol),
      delimiter_loc: Prism::Location,
      name_loc: Prism::Location
    ).returns(Prism::ConstantPathTargetNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), parent: T.unsafe(nil), name: T.unsafe(nil), delimiter_loc: T.unsafe(nil), name_loc: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#4675
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, parent: Prism::node?, name: Symbol?, delimiter_loc: Location, name_loc: Location }
  #
  # source://prism//lib/prism/node.rb#4700
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def delimiter: () -> String
  #
  # source://prism//lib/prism/node.rb#4725
  sig { returns(String) }
  def delimiter; end

  # attr_reader delimiter_loc: Location
  #
  # source://prism//lib/prism/node.rb#4711
  sig { returns(Prism::Location) }
  def delimiter_loc; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # Returns the full name of this constant path. For example: "Foo::Bar"
  #
  # source://prism//lib/prism/node_ext.rb#236
  sig { returns(String) }
  def full_name; end

  # Returns the list of parts for the full name of this constant path.
  # For example: [:Foo, :Bar]
  #
  # source://prism//lib/prism/node_ext.rb#216
  sig { returns(T::Array[Symbol]) }
  def full_name_parts; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#4730
  sig { override.returns(String) }
  def inspect; end

  # attr_reader name: Symbol?
  #
  # source://prism//lib/prism/node.rb#4708
  sig { returns(T.nilable(Symbol)) }
  def name; end

  # attr_reader name_loc: Location
  #
  # source://prism//lib/prism/node.rb#4718
  sig { returns(Prism::Location) }
  def name_loc; end

  # attr_reader parent: Prism::node?
  #
  # source://prism//lib/prism/node.rb#4705
  sig { returns(T.nilable(Prism::Node)) }
  def parent; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#4735
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#4740
    def type; end
  end
end

# Represents writing to a constant path.
#
#     ::Foo = 1
#     ^^^^^^^^^
#
#     Foo::Bar = 1
#     ^^^^^^^^^^^^
#
#     ::Foo::Bar = 1
#     ^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#4765
class Prism::ConstantPathWriteNode < ::Prism::Node
  # Initialize a new ConstantPathWriteNode node.
  #
  # @return [ConstantPathWriteNode] a new instance of ConstantPathWriteNode
  #
  # source://prism//lib/prism/node.rb#4767
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      target: Prism::ConstantPathNode,
      operator_loc: Prism::Location,
      value: Prism::Node
    ).void
  end
  def initialize(source, node_id, location, flags, target, operator_loc, value); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#4857
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#4778
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#4783
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#4793
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#4788
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?target: ConstantPathNode, ?operator_loc: Location, ?value: Prism::node) -> ConstantPathWriteNode
  #
  # source://prism//lib/prism/node.rb#4798
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      target: Prism::ConstantPathNode,
      operator_loc: Prism::Location,
      value: Prism::Node
    ).returns(Prism::ConstantPathWriteNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), target: T.unsafe(nil), operator_loc: T.unsafe(nil), value: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#4783
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, target: ConstantPathNode, operator_loc: Location, value: Prism::node }
  #
  # source://prism//lib/prism/node.rb#4806
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#4841
  sig { override.returns(String) }
  def inspect; end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#4836
  sig { returns(String) }
  def operator; end

  # The location of the `=` operator.
  #
  #     ::ABC = 123
  #           ^
  #
  # source://prism//lib/prism/node.rb#4823
  sig { returns(Prism::Location) }
  def operator_loc; end

  # A node representing the constant path being written to.
  #
  #     Foo::Bar = 1
  #     ^^^^^^^^
  #
  #     ::Foo = :abc
  #     ^^^^^
  #
  # source://prism//lib/prism/node.rb#4817
  sig { returns(Prism::ConstantPathNode) }
  def target; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#4846
  sig { override.returns(Symbol) }
  def type; end

  # The value to write to the constant path. It can be any [non-void expression](https://github.com/ruby/prism/blob/main/docs/parsing_rules.md#non-void-expression).
  #
  #     FOO::BAR = :abc
  #                ^^^^
  #
  # source://prism//lib/prism/node.rb#4833
  sig { returns(Prism::Node) }
  def value; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#4851
    def type; end
  end
end

# Represents referencing a constant.
#
#     Foo
#     ^^^
#
# source://prism//lib/prism/node.rb#4869
class Prism::ConstantReadNode < ::Prism::Node
  # Initialize a new ConstantReadNode node.
  #
  # @return [ConstantReadNode] a new instance of ConstantReadNode
  #
  # source://prism//lib/prism/node.rb#4871
  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol).void }
  def initialize(source, node_id, location, flags, name); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#4936
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#4880
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#4885
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#4895
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#4890
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?name: Symbol) -> ConstantReadNode
  #
  # source://prism//lib/prism/node.rb#4900
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol
    ).returns(Prism::ConstantReadNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#4885
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, name: Symbol }
  #
  # source://prism//lib/prism/node.rb#4908
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # Returns the full name of this constant. For example: "Foo"
  #
  # source://prism//lib/prism/node_ext.rb#139
  sig { returns(String) }
  def full_name; end

  # Returns the list of parts for the full name of this constant.
  # For example: [:Foo]
  #
  # source://prism//lib/prism/node_ext.rb#134
  sig { returns(T::Array[Symbol]) }
  def full_name_parts; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#4920
  sig { override.returns(String) }
  def inspect; end

  # The name of the [constant](https://github.com/ruby/prism/blob/main/docs/parsing_rules.md#constants).
  #
  #     X              # name `:X`
  #
  #     SOME_CONSTANT  # name `:SOME_CONSTANT`
  #
  # source://prism//lib/prism/node.rb#4917
  sig { returns(Symbol) }
  def name; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#4925
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#4930
    def type; end
  end
end

# Represents writing to a constant in a context that doesn't have an explicit value.
#
#     Foo, Bar = baz
#     ^^^  ^^^
#
# source://prism//lib/prism/node.rb#4946
class Prism::ConstantTargetNode < ::Prism::Node
  # Initialize a new ConstantTargetNode node.
  #
  # @return [ConstantTargetNode] a new instance of ConstantTargetNode
  #
  # source://prism//lib/prism/node.rb#4948
  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol).void }
  def initialize(source, node_id, location, flags, name); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#5009
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#4957
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#4962
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#4972
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#4967
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?name: Symbol) -> ConstantTargetNode
  #
  # source://prism//lib/prism/node.rb#4977
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol
    ).returns(Prism::ConstantTargetNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#4962
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, name: Symbol }
  #
  # source://prism//lib/prism/node.rb#4985
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # Returns the full name of this constant. For example: "Foo"
  #
  # source://prism//lib/prism/node_ext.rb#262
  sig { returns(String) }
  def full_name; end

  # Returns the list of parts for the full name of this constant.
  # For example: [:Foo]
  #
  # source://prism//lib/prism/node_ext.rb#257
  sig { returns(T::Array[Symbol]) }
  def full_name_parts; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#4993
  sig { override.returns(String) }
  def inspect; end

  # attr_reader name: Symbol
  #
  # source://prism//lib/prism/node.rb#4990
  sig { returns(Symbol) }
  def name; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#4998
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#5003
    def type; end
  end
end

# Represents writing to a constant.
#
#     Foo = 1
#     ^^^^^^^
#
# source://prism//lib/prism/node.rb#5019
class Prism::ConstantWriteNode < ::Prism::Node
  # Initialize a new ConstantWriteNode node.
  #
  # @return [ConstantWriteNode] a new instance of ConstantWriteNode
  #
  # source://prism//lib/prism/node.rb#5021
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      name_loc: Prism::Location,
      value: Prism::Node,
      operator_loc: Prism::Location
    ).void
  end
  def initialize(source, node_id, location, flags, name, name_loc, value, operator_loc); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#5123
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#5033
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#5038
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#5048
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#5043
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?name: Symbol, ?name_loc: Location, ?value: Prism::node, ?operator_loc: Location) -> ConstantWriteNode
  #
  # source://prism//lib/prism/node.rb#5053
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      name_loc: Prism::Location,
      value: Prism::Node,
      operator_loc: Prism::Location
    ).returns(Prism::ConstantWriteNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil), name_loc: T.unsafe(nil), value: T.unsafe(nil), operator_loc: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#5038
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, name: Symbol, name_loc: Location, value: Prism::node, operator_loc: Location }
  #
  # source://prism//lib/prism/node.rb#5061
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # Returns the full name of this constant. For example: "Foo"
  #
  # source://prism//lib/prism/node_ext.rb#152
  sig { returns(String) }
  def full_name; end

  # Returns the list of parts for the full name of this constant.
  # For example: [:Foo]
  #
  # source://prism//lib/prism/node_ext.rb#147
  sig { returns(T::Array[Symbol]) }
  def full_name_parts; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#5107
  sig { override.returns(String) }
  def inspect; end

  # The name of the [constant](https://github.com/ruby/prism/blob/main/docs/parsing_rules.md#constants).
  #
  #     Foo = :bar # name `:Foo`
  #
  #     XYZ = 1    # name `:XYZ`
  #
  # source://prism//lib/prism/node.rb#5070
  sig { returns(Symbol) }
  def name; end

  # The location of the constant name.
  #
  #     FOO = 1
  #     ^^^
  #
  # source://prism//lib/prism/node.rb#5076
  sig { returns(Prism::Location) }
  def name_loc; end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#5102
  sig { returns(String) }
  def operator; end

  # The location of the `=` operator.
  #
  #     FOO = :bar
  #         ^
  #
  # source://prism//lib/prism/node.rb#5095
  sig { returns(Prism::Location) }
  def operator_loc; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#5112
  sig { override.returns(Symbol) }
  def type; end

  # The value to write to the constant. It can be any [non-void expression](https://github.com/ruby/prism/blob/main/docs/parsing_rules.md#non-void-expression).
  #
  #     FOO = :bar
  #           ^^^^
  #
  #     MyClass = Class.new
  #               ^^^^^^^^^
  #
  # source://prism//lib/prism/node.rb#5089
  sig { returns(Prism::Node) }
  def value; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#5117
    def type; end
  end
end

# The DSL module provides a set of methods that can be used to create prism
# nodes in a more concise manner. For example, instead of writing:
#
#     source = Prism::Source.for("[1]")
#
#     Prism::ArrayNode.new(
#       source,
#       0,
#       Prism::Location.new(source, 0, 3),
#       0,
#       [
#         Prism::IntegerNode.new(
#           source,
#           0,
#           Prism::Location.new(source, 1, 1),
#           Prism::IntegerBaseFlags::DECIMAL,
#           1
#         )
#       ],
#       Prism::Location.new(source, 0, 1),
#       Prism::Location.new(source, 2, 1)
#     )
#
# you could instead write:
#
#     class Builder
#       include Prism::DSL
#
#       attr_reader :default_source
#
#       def initialize
#         @default_source = source("[1]")
#       end
#
#       def build
#         array_node(
#           location: location(start_offset: 0, length: 3),
#           elements: [
#             integer_node(
#               location: location(start_offset: 1, length: 1),
#               flags: integer_base_flag(:decimal),
#               value: 1
#             )
#           ],
#           opening_loc: location(start_offset: 0, length: 1),
#           closing_loc: location(start_offset: 2, length: 1)
#         )
#       end
#     end
#
# This is mostly helpful in the context of generating trees programmatically.
#
# source://prism//lib/prism/dsl.rb#61
module Prism::DSL
  extend ::Prism::DSL

  # Create a new AliasGlobalVariableNode node.
  #
  # source://prism//lib/prism/dsl.rb#77
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      new_name: T.any(Prism::GlobalVariableReadNode, Prism::BackReferenceReadNode, Prism::NumberedReferenceReadNode),
      old_name: T.any(Prism::GlobalVariableReadNode, Prism::BackReferenceReadNode, Prism::NumberedReferenceReadNode, Prism::SymbolNode, Prism::MissingNode),
      keyword_loc: Prism::Location
    ).returns(Prism::AliasGlobalVariableNode)
  end
  def alias_global_variable_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), new_name: T.unsafe(nil), old_name: T.unsafe(nil), keyword_loc: T.unsafe(nil)); end

  # Create a new AliasMethodNode node.
  #
  # source://prism//lib/prism/dsl.rb#82
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      new_name: T.any(Prism::SymbolNode, Prism::InterpolatedSymbolNode),
      old_name: T.any(Prism::SymbolNode, Prism::InterpolatedSymbolNode, Prism::GlobalVariableReadNode, Prism::MissingNode),
      keyword_loc: Prism::Location
    ).returns(Prism::AliasMethodNode)
  end
  def alias_method_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), new_name: T.unsafe(nil), old_name: T.unsafe(nil), keyword_loc: T.unsafe(nil)); end

  # Create a new AlternationPatternNode node.
  #
  # source://prism//lib/prism/dsl.rb#87
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      left: Prism::Node,
      right: Prism::Node,
      operator_loc: Prism::Location
    ).returns(Prism::AlternationPatternNode)
  end
  def alternation_pattern_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), left: T.unsafe(nil), right: T.unsafe(nil), operator_loc: T.unsafe(nil)); end

  # Create a new AndNode node.
  #
  # source://prism//lib/prism/dsl.rb#92
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      left: Prism::Node,
      right: Prism::Node,
      operator_loc: Prism::Location
    ).returns(Prism::AndNode)
  end
  def and_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), left: T.unsafe(nil), right: T.unsafe(nil), operator_loc: T.unsafe(nil)); end

  # Create a new ArgumentsNode node.
  #
  # source://prism//lib/prism/dsl.rb#97
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      arguments: T::Array[Prism::Node]
    ).returns(Prism::ArgumentsNode)
  end
  def arguments_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), arguments: T.unsafe(nil)); end

  # Retrieve the value of one of the ArgumentsNodeFlags flags.
  #
  # source://prism//lib/prism/dsl.rb#832
  sig { params(name: Symbol).returns(Integer) }
  def arguments_node_flag(name); end

  # Create a new ArrayNode node.
  #
  # source://prism//lib/prism/dsl.rb#102
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      elements: T::Array[Prism::Node],
      opening_loc: T.nilable(Prism::Location),
      closing_loc: T.nilable(Prism::Location)
    ).returns(Prism::ArrayNode)
  end
  def array_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), elements: T.unsafe(nil), opening_loc: T.unsafe(nil), closing_loc: T.unsafe(nil)); end

  # Retrieve the value of one of the ArrayNodeFlags flags.
  #
  # source://prism//lib/prism/dsl.rb#844
  sig { params(name: Symbol).returns(Integer) }
  def array_node_flag(name); end

  # Create a new ArrayPatternNode node.
  #
  # source://prism//lib/prism/dsl.rb#107
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      constant: T.nilable(T.any(Prism::ConstantReadNode, Prism::ConstantPathNode)),
      requireds: T::Array[Prism::Node],
      rest: T.nilable(Prism::Node),
      posts: T::Array[Prism::Node],
      opening_loc: T.nilable(Prism::Location),
      closing_loc: T.nilable(Prism::Location)
    ).returns(Prism::ArrayPatternNode)
  end
  def array_pattern_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), constant: T.unsafe(nil), requireds: T.unsafe(nil), rest: T.unsafe(nil), posts: T.unsafe(nil), opening_loc: T.unsafe(nil), closing_loc: T.unsafe(nil)); end

  # Create a new AssocNode node.
  #
  # source://prism//lib/prism/dsl.rb#112
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      key: Prism::Node,
      value: Prism::Node,
      operator_loc: T.nilable(Prism::Location)
    ).returns(Prism::AssocNode)
  end
  def assoc_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), key: T.unsafe(nil), value: T.unsafe(nil), operator_loc: T.unsafe(nil)); end

  # Create a new AssocSplatNode node.
  #
  # source://prism//lib/prism/dsl.rb#117
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      value: T.nilable(Prism::Node),
      operator_loc: Prism::Location
    ).returns(Prism::AssocSplatNode)
  end
  def assoc_splat_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), value: T.unsafe(nil), operator_loc: T.unsafe(nil)); end

  # Create a new BackReferenceReadNode node.
  #
  # source://prism//lib/prism/dsl.rb#122
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol
    ).returns(Prism::BackReferenceReadNode)
  end
  def back_reference_read_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil)); end

  # Create a new BeginNode node.
  #
  # source://prism//lib/prism/dsl.rb#127
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      begin_keyword_loc: T.nilable(Prism::Location),
      statements: T.nilable(Prism::StatementsNode),
      rescue_clause: T.nilable(Prism::RescueNode),
      else_clause: T.nilable(Prism::ElseNode),
      ensure_clause: T.nilable(Prism::EnsureNode),
      end_keyword_loc: T.nilable(Prism::Location)
    ).returns(Prism::BeginNode)
  end
  def begin_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), begin_keyword_loc: T.unsafe(nil), statements: T.unsafe(nil), rescue_clause: T.unsafe(nil), else_clause: T.unsafe(nil), ensure_clause: T.unsafe(nil), end_keyword_loc: T.unsafe(nil)); end

  # Create a new BlockArgumentNode node.
  #
  # source://prism//lib/prism/dsl.rb#132
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      expression: T.nilable(Prism::Node),
      operator_loc: Prism::Location
    ).returns(Prism::BlockArgumentNode)
  end
  def block_argument_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), expression: T.unsafe(nil), operator_loc: T.unsafe(nil)); end

  # Create a new BlockLocalVariableNode node.
  #
  # source://prism//lib/prism/dsl.rb#137
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol
    ).returns(Prism::BlockLocalVariableNode)
  end
  def block_local_variable_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil)); end

  # Create a new BlockNode node.
  #
  # source://prism//lib/prism/dsl.rb#142
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      locals: T::Array[Symbol],
      parameters: T.nilable(T.any(Prism::BlockParametersNode, Prism::NumberedParametersNode, Prism::ItParametersNode)),
      body: T.nilable(T.any(Prism::StatementsNode, Prism::BeginNode)),
      opening_loc: Prism::Location,
      closing_loc: Prism::Location
    ).returns(Prism::BlockNode)
  end
  def block_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), locals: T.unsafe(nil), parameters: T.unsafe(nil), body: T.unsafe(nil), opening_loc: T.unsafe(nil), closing_loc: T.unsafe(nil)); end

  # Create a new BlockParameterNode node.
  #
  # source://prism//lib/prism/dsl.rb#147
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: T.nilable(Symbol),
      name_loc: T.nilable(Prism::Location),
      operator_loc: Prism::Location
    ).returns(Prism::BlockParameterNode)
  end
  def block_parameter_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil), name_loc: T.unsafe(nil), operator_loc: T.unsafe(nil)); end

  # Create a new BlockParametersNode node.
  #
  # source://prism//lib/prism/dsl.rb#152
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      parameters: T.nilable(Prism::ParametersNode),
      locals: T::Array[Prism::BlockLocalVariableNode],
      opening_loc: T.nilable(Prism::Location),
      closing_loc: T.nilable(Prism::Location)
    ).returns(Prism::BlockParametersNode)
  end
  def block_parameters_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), parameters: T.unsafe(nil), locals: T.unsafe(nil), opening_loc: T.unsafe(nil), closing_loc: T.unsafe(nil)); end

  # Create a new BreakNode node.
  #
  # source://prism//lib/prism/dsl.rb#157
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      arguments: T.nilable(Prism::ArgumentsNode),
      keyword_loc: Prism::Location
    ).returns(Prism::BreakNode)
  end
  def break_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), arguments: T.unsafe(nil), keyword_loc: T.unsafe(nil)); end

  # Create a new CallAndWriteNode node.
  #
  # source://prism//lib/prism/dsl.rb#162
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      receiver: T.nilable(Prism::Node),
      call_operator_loc: T.nilable(Prism::Location),
      message_loc: T.nilable(Prism::Location),
      read_name: Symbol,
      write_name: Symbol,
      operator_loc: Prism::Location,
      value: Prism::Node
    ).returns(Prism::CallAndWriteNode)
  end
  def call_and_write_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), receiver: T.unsafe(nil), call_operator_loc: T.unsafe(nil), message_loc: T.unsafe(nil), read_name: T.unsafe(nil), write_name: T.unsafe(nil), operator_loc: T.unsafe(nil), value: T.unsafe(nil)); end

  # Create a new CallNode node.
  #
  # source://prism//lib/prism/dsl.rb#167
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      receiver: T.nilable(Prism::Node),
      call_operator_loc: T.nilable(Prism::Location),
      name: Symbol,
      message_loc: T.nilable(Prism::Location),
      opening_loc: T.nilable(Prism::Location),
      arguments: T.nilable(Prism::ArgumentsNode),
      closing_loc: T.nilable(Prism::Location),
      block: T.nilable(T.any(Prism::BlockNode, Prism::BlockArgumentNode))
    ).returns(Prism::CallNode)
  end
  def call_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), receiver: T.unsafe(nil), call_operator_loc: T.unsafe(nil), name: T.unsafe(nil), message_loc: T.unsafe(nil), opening_loc: T.unsafe(nil), arguments: T.unsafe(nil), closing_loc: T.unsafe(nil), block: T.unsafe(nil)); end

  # Retrieve the value of one of the CallNodeFlags flags.
  #
  # source://prism//lib/prism/dsl.rb#852
  sig { params(name: Symbol).returns(Integer) }
  def call_node_flag(name); end

  # Create a new CallOperatorWriteNode node.
  #
  # source://prism//lib/prism/dsl.rb#172
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      receiver: T.nilable(Prism::Node),
      call_operator_loc: T.nilable(Prism::Location),
      message_loc: T.nilable(Prism::Location),
      read_name: Symbol,
      write_name: Symbol,
      binary_operator: Symbol,
      binary_operator_loc: Prism::Location,
      value: Prism::Node
    ).returns(Prism::CallOperatorWriteNode)
  end
  def call_operator_write_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), receiver: T.unsafe(nil), call_operator_loc: T.unsafe(nil), message_loc: T.unsafe(nil), read_name: T.unsafe(nil), write_name: T.unsafe(nil), binary_operator: T.unsafe(nil), binary_operator_loc: T.unsafe(nil), value: T.unsafe(nil)); end

  # Create a new CallOrWriteNode node.
  #
  # source://prism//lib/prism/dsl.rb#177
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      receiver: T.nilable(Prism::Node),
      call_operator_loc: T.nilable(Prism::Location),
      message_loc: T.nilable(Prism::Location),
      read_name: Symbol,
      write_name: Symbol,
      operator_loc: Prism::Location,
      value: Prism::Node
    ).returns(Prism::CallOrWriteNode)
  end
  def call_or_write_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), receiver: T.unsafe(nil), call_operator_loc: T.unsafe(nil), message_loc: T.unsafe(nil), read_name: T.unsafe(nil), write_name: T.unsafe(nil), operator_loc: T.unsafe(nil), value: T.unsafe(nil)); end

  # Create a new CallTargetNode node.
  #
  # source://prism//lib/prism/dsl.rb#182
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      receiver: Prism::Node,
      call_operator_loc: Prism::Location,
      name: Symbol,
      message_loc: Prism::Location
    ).returns(Prism::CallTargetNode)
  end
  def call_target_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), receiver: T.unsafe(nil), call_operator_loc: T.unsafe(nil), name: T.unsafe(nil), message_loc: T.unsafe(nil)); end

  # Create a new CapturePatternNode node.
  #
  # source://prism//lib/prism/dsl.rb#187
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      value: Prism::Node,
      target: Prism::LocalVariableTargetNode,
      operator_loc: Prism::Location
    ).returns(Prism::CapturePatternNode)
  end
  def capture_pattern_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), value: T.unsafe(nil), target: T.unsafe(nil), operator_loc: T.unsafe(nil)); end

  # Create a new CaseMatchNode node.
  #
  # source://prism//lib/prism/dsl.rb#192
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      predicate: T.nilable(Prism::Node),
      conditions: T::Array[Prism::InNode],
      else_clause: T.nilable(Prism::ElseNode),
      case_keyword_loc: Prism::Location,
      end_keyword_loc: Prism::Location
    ).returns(Prism::CaseMatchNode)
  end
  def case_match_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), predicate: T.unsafe(nil), conditions: T.unsafe(nil), else_clause: T.unsafe(nil), case_keyword_loc: T.unsafe(nil), end_keyword_loc: T.unsafe(nil)); end

  # Create a new CaseNode node.
  #
  # source://prism//lib/prism/dsl.rb#197
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      predicate: T.nilable(Prism::Node),
      conditions: T::Array[Prism::WhenNode],
      else_clause: T.nilable(Prism::ElseNode),
      case_keyword_loc: Prism::Location,
      end_keyword_loc: Prism::Location
    ).returns(Prism::CaseNode)
  end
  def case_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), predicate: T.unsafe(nil), conditions: T.unsafe(nil), else_clause: T.unsafe(nil), case_keyword_loc: T.unsafe(nil), end_keyword_loc: T.unsafe(nil)); end

  # Create a new ClassNode node.
  #
  # source://prism//lib/prism/dsl.rb#202
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      locals: T::Array[Symbol],
      class_keyword_loc: Prism::Location,
      constant_path: T.any(Prism::ConstantReadNode, Prism::ConstantPathNode, Prism::CallNode),
      inheritance_operator_loc: T.nilable(Prism::Location),
      superclass: T.nilable(Prism::Node),
      body: T.nilable(T.any(Prism::StatementsNode, Prism::BeginNode)),
      end_keyword_loc: Prism::Location,
      name: Symbol
    ).returns(Prism::ClassNode)
  end
  def class_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), locals: T.unsafe(nil), class_keyword_loc: T.unsafe(nil), constant_path: T.unsafe(nil), inheritance_operator_loc: T.unsafe(nil), superclass: T.unsafe(nil), body: T.unsafe(nil), end_keyword_loc: T.unsafe(nil), name: T.unsafe(nil)); end

  # Create a new ClassVariableAndWriteNode node.
  #
  # source://prism//lib/prism/dsl.rb#207
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      name_loc: Prism::Location,
      operator_loc: Prism::Location,
      value: Prism::Node
    ).returns(Prism::ClassVariableAndWriteNode)
  end
  def class_variable_and_write_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil), name_loc: T.unsafe(nil), operator_loc: T.unsafe(nil), value: T.unsafe(nil)); end

  # Create a new ClassVariableOperatorWriteNode node.
  #
  # source://prism//lib/prism/dsl.rb#212
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      name_loc: Prism::Location,
      binary_operator_loc: Prism::Location,
      value: Prism::Node,
      binary_operator: Symbol
    ).returns(Prism::ClassVariableOperatorWriteNode)
  end
  def class_variable_operator_write_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil), name_loc: T.unsafe(nil), binary_operator_loc: T.unsafe(nil), value: T.unsafe(nil), binary_operator: T.unsafe(nil)); end

  # Create a new ClassVariableOrWriteNode node.
  #
  # source://prism//lib/prism/dsl.rb#217
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      name_loc: Prism::Location,
      operator_loc: Prism::Location,
      value: Prism::Node
    ).returns(Prism::ClassVariableOrWriteNode)
  end
  def class_variable_or_write_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil), name_loc: T.unsafe(nil), operator_loc: T.unsafe(nil), value: T.unsafe(nil)); end

  # Create a new ClassVariableReadNode node.
  #
  # source://prism//lib/prism/dsl.rb#222
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol
    ).returns(Prism::ClassVariableReadNode)
  end
  def class_variable_read_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil)); end

  # Create a new ClassVariableTargetNode node.
  #
  # source://prism//lib/prism/dsl.rb#227
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol
    ).returns(Prism::ClassVariableTargetNode)
  end
  def class_variable_target_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil)); end

  # Create a new ClassVariableWriteNode node.
  #
  # source://prism//lib/prism/dsl.rb#232
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      name_loc: Prism::Location,
      value: Prism::Node,
      operator_loc: Prism::Location
    ).returns(Prism::ClassVariableWriteNode)
  end
  def class_variable_write_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil), name_loc: T.unsafe(nil), value: T.unsafe(nil), operator_loc: T.unsafe(nil)); end

  # Create a new ConstantAndWriteNode node.
  #
  # source://prism//lib/prism/dsl.rb#237
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      name_loc: Prism::Location,
      operator_loc: Prism::Location,
      value: Prism::Node
    ).returns(Prism::ConstantAndWriteNode)
  end
  def constant_and_write_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil), name_loc: T.unsafe(nil), operator_loc: T.unsafe(nil), value: T.unsafe(nil)); end

  # Create a new ConstantOperatorWriteNode node.
  #
  # source://prism//lib/prism/dsl.rb#242
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      name_loc: Prism::Location,
      binary_operator_loc: Prism::Location,
      value: Prism::Node,
      binary_operator: Symbol
    ).returns(Prism::ConstantOperatorWriteNode)
  end
  def constant_operator_write_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil), name_loc: T.unsafe(nil), binary_operator_loc: T.unsafe(nil), value: T.unsafe(nil), binary_operator: T.unsafe(nil)); end

  # Create a new ConstantOrWriteNode node.
  #
  # source://prism//lib/prism/dsl.rb#247
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      name_loc: Prism::Location,
      operator_loc: Prism::Location,
      value: Prism::Node
    ).returns(Prism::ConstantOrWriteNode)
  end
  def constant_or_write_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil), name_loc: T.unsafe(nil), operator_loc: T.unsafe(nil), value: T.unsafe(nil)); end

  # Create a new ConstantPathAndWriteNode node.
  #
  # source://prism//lib/prism/dsl.rb#252
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      target: Prism::ConstantPathNode,
      operator_loc: Prism::Location,
      value: Prism::Node
    ).returns(Prism::ConstantPathAndWriteNode)
  end
  def constant_path_and_write_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), target: T.unsafe(nil), operator_loc: T.unsafe(nil), value: T.unsafe(nil)); end

  # Create a new ConstantPathNode node.
  #
  # source://prism//lib/prism/dsl.rb#257
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      parent: T.nilable(Prism::Node),
      name: T.nilable(Symbol),
      delimiter_loc: Prism::Location,
      name_loc: Prism::Location
    ).returns(Prism::ConstantPathNode)
  end
  def constant_path_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), parent: T.unsafe(nil), name: T.unsafe(nil), delimiter_loc: T.unsafe(nil), name_loc: T.unsafe(nil)); end

  # Create a new ConstantPathOperatorWriteNode node.
  #
  # source://prism//lib/prism/dsl.rb#262
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      target: Prism::ConstantPathNode,
      binary_operator_loc: Prism::Location,
      value: Prism::Node,
      binary_operator: Symbol
    ).returns(Prism::ConstantPathOperatorWriteNode)
  end
  def constant_path_operator_write_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), target: T.unsafe(nil), binary_operator_loc: T.unsafe(nil), value: T.unsafe(nil), binary_operator: T.unsafe(nil)); end

  # Create a new ConstantPathOrWriteNode node.
  #
  # source://prism//lib/prism/dsl.rb#267
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      target: Prism::ConstantPathNode,
      operator_loc: Prism::Location,
      value: Prism::Node
    ).returns(Prism::ConstantPathOrWriteNode)
  end
  def constant_path_or_write_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), target: T.unsafe(nil), operator_loc: T.unsafe(nil), value: T.unsafe(nil)); end

  # Create a new ConstantPathTargetNode node.
  #
  # source://prism//lib/prism/dsl.rb#272
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      parent: T.nilable(Prism::Node),
      name: T.nilable(Symbol),
      delimiter_loc: Prism::Location,
      name_loc: Prism::Location
    ).returns(Prism::ConstantPathTargetNode)
  end
  def constant_path_target_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), parent: T.unsafe(nil), name: T.unsafe(nil), delimiter_loc: T.unsafe(nil), name_loc: T.unsafe(nil)); end

  # Create a new ConstantPathWriteNode node.
  #
  # source://prism//lib/prism/dsl.rb#277
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      target: Prism::ConstantPathNode,
      operator_loc: Prism::Location,
      value: Prism::Node
    ).returns(Prism::ConstantPathWriteNode)
  end
  def constant_path_write_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), target: T.unsafe(nil), operator_loc: T.unsafe(nil), value: T.unsafe(nil)); end

  # Create a new ConstantReadNode node.
  #
  # source://prism//lib/prism/dsl.rb#282
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol
    ).returns(Prism::ConstantReadNode)
  end
  def constant_read_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil)); end

  # Create a new ConstantTargetNode node.
  #
  # source://prism//lib/prism/dsl.rb#287
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol
    ).returns(Prism::ConstantTargetNode)
  end
  def constant_target_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil)); end

  # Create a new ConstantWriteNode node.
  #
  # source://prism//lib/prism/dsl.rb#292
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      name_loc: Prism::Location,
      value: Prism::Node,
      operator_loc: Prism::Location
    ).returns(Prism::ConstantWriteNode)
  end
  def constant_write_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil), name_loc: T.unsafe(nil), value: T.unsafe(nil), operator_loc: T.unsafe(nil)); end

  # Create a new DefNode node.
  #
  # source://prism//lib/prism/dsl.rb#297
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      name_loc: Prism::Location,
      receiver: T.nilable(Prism::Node),
      parameters: T.nilable(Prism::ParametersNode),
      body: T.nilable(T.any(Prism::StatementsNode, Prism::BeginNode)),
      locals: T::Array[Symbol],
      def_keyword_loc: Prism::Location,
      operator_loc: T.nilable(Prism::Location),
      lparen_loc: T.nilable(Prism::Location),
      rparen_loc: T.nilable(Prism::Location),
      equal_loc: T.nilable(Prism::Location),
      end_keyword_loc: T.nilable(Prism::Location)
    ).returns(Prism::DefNode)
  end
  def def_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil), name_loc: T.unsafe(nil), receiver: T.unsafe(nil), parameters: T.unsafe(nil), body: T.unsafe(nil), locals: T.unsafe(nil), def_keyword_loc: T.unsafe(nil), operator_loc: T.unsafe(nil), lparen_loc: T.unsafe(nil), rparen_loc: T.unsafe(nil), equal_loc: T.unsafe(nil), end_keyword_loc: T.unsafe(nil)); end

  # Create a new DefinedNode node.
  #
  # source://prism//lib/prism/dsl.rb#302
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      lparen_loc: T.nilable(Prism::Location),
      value: Prism::Node,
      rparen_loc: T.nilable(Prism::Location),
      keyword_loc: Prism::Location
    ).returns(Prism::DefinedNode)
  end
  def defined_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), lparen_loc: T.unsafe(nil), value: T.unsafe(nil), rparen_loc: T.unsafe(nil), keyword_loc: T.unsafe(nil)); end

  # Create a new ElseNode node.
  #
  # source://prism//lib/prism/dsl.rb#307
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      else_keyword_loc: Prism::Location,
      statements: T.nilable(Prism::StatementsNode),
      end_keyword_loc: T.nilable(Prism::Location)
    ).returns(Prism::ElseNode)
  end
  def else_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), else_keyword_loc: T.unsafe(nil), statements: T.unsafe(nil), end_keyword_loc: T.unsafe(nil)); end

  # Create a new EmbeddedStatementsNode node.
  #
  # source://prism//lib/prism/dsl.rb#312
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      opening_loc: Prism::Location,
      statements: T.nilable(Prism::StatementsNode),
      closing_loc: Prism::Location
    ).returns(Prism::EmbeddedStatementsNode)
  end
  def embedded_statements_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), opening_loc: T.unsafe(nil), statements: T.unsafe(nil), closing_loc: T.unsafe(nil)); end

  # Create a new EmbeddedVariableNode node.
  #
  # source://prism//lib/prism/dsl.rb#317
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      operator_loc: Prism::Location,
      variable: T.any(Prism::InstanceVariableReadNode, Prism::ClassVariableReadNode, Prism::GlobalVariableReadNode, Prism::BackReferenceReadNode, Prism::NumberedReferenceReadNode)
    ).returns(Prism::EmbeddedVariableNode)
  end
  def embedded_variable_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), operator_loc: T.unsafe(nil), variable: T.unsafe(nil)); end

  # Retrieve the value of one of the EncodingFlags flags.
  #
  # source://prism//lib/prism/dsl.rb#863
  sig { params(name: Symbol).returns(Integer) }
  def encoding_flag(name); end

  # Create a new EnsureNode node.
  #
  # source://prism//lib/prism/dsl.rb#322
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      ensure_keyword_loc: Prism::Location,
      statements: T.nilable(Prism::StatementsNode),
      end_keyword_loc: Prism::Location
    ).returns(Prism::EnsureNode)
  end
  def ensure_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), ensure_keyword_loc: T.unsafe(nil), statements: T.unsafe(nil), end_keyword_loc: T.unsafe(nil)); end

  # Create a new FalseNode node.
  #
  # source://prism//lib/prism/dsl.rb#327
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer
    ).returns(Prism::FalseNode)
  end
  def false_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil)); end

  # Create a new FindPatternNode node.
  #
  # source://prism//lib/prism/dsl.rb#332
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      constant: T.nilable(T.any(Prism::ConstantReadNode, Prism::ConstantPathNode)),
      left: Prism::SplatNode,
      requireds: T::Array[Prism::Node],
      right: T.any(Prism::SplatNode, Prism::MissingNode),
      opening_loc: T.nilable(Prism::Location),
      closing_loc: T.nilable(Prism::Location)
    ).returns(Prism::FindPatternNode)
  end
  def find_pattern_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), constant: T.unsafe(nil), left: T.unsafe(nil), requireds: T.unsafe(nil), right: T.unsafe(nil), opening_loc: T.unsafe(nil), closing_loc: T.unsafe(nil)); end

  # Create a new FlipFlopNode node.
  #
  # source://prism//lib/prism/dsl.rb#337
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      left: T.nilable(Prism::Node),
      right: T.nilable(Prism::Node),
      operator_loc: Prism::Location
    ).returns(Prism::FlipFlopNode)
  end
  def flip_flop_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), left: T.unsafe(nil), right: T.unsafe(nil), operator_loc: T.unsafe(nil)); end

  # Create a new FloatNode node.
  #
  # source://prism//lib/prism/dsl.rb#342
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      value: Float
    ).returns(Prism::FloatNode)
  end
  def float_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), value: T.unsafe(nil)); end

  # Create a new ForNode node.
  #
  # source://prism//lib/prism/dsl.rb#347
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      index: T.any(Prism::LocalVariableTargetNode, Prism::InstanceVariableTargetNode, Prism::ClassVariableTargetNode, Prism::GlobalVariableTargetNode, Prism::ConstantTargetNode, Prism::ConstantPathTargetNode, Prism::CallTargetNode, Prism::IndexTargetNode, Prism::MultiTargetNode, Prism::BackReferenceReadNode, Prism::NumberedReferenceReadNode, Prism::MissingNode),
      collection: Prism::Node,
      statements: T.nilable(Prism::StatementsNode),
      for_keyword_loc: Prism::Location,
      in_keyword_loc: Prism::Location,
      do_keyword_loc: T.nilable(Prism::Location),
      end_keyword_loc: Prism::Location
    ).returns(Prism::ForNode)
  end
  def for_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), index: T.unsafe(nil), collection: T.unsafe(nil), statements: T.unsafe(nil), for_keyword_loc: T.unsafe(nil), in_keyword_loc: T.unsafe(nil), do_keyword_loc: T.unsafe(nil), end_keyword_loc: T.unsafe(nil)); end

  # Create a new ForwardingArgumentsNode node.
  #
  # source://prism//lib/prism/dsl.rb#352
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer
    ).returns(Prism::ForwardingArgumentsNode)
  end
  def forwarding_arguments_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil)); end

  # Create a new ForwardingParameterNode node.
  #
  # source://prism//lib/prism/dsl.rb#357
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer
    ).returns(Prism::ForwardingParameterNode)
  end
  def forwarding_parameter_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil)); end

  # Create a new ForwardingSuperNode node.
  #
  # source://prism//lib/prism/dsl.rb#362
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      block: T.nilable(Prism::BlockNode)
    ).returns(Prism::ForwardingSuperNode)
  end
  def forwarding_super_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), block: T.unsafe(nil)); end

  # Create a new GlobalVariableAndWriteNode node.
  #
  # source://prism//lib/prism/dsl.rb#367
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      name_loc: Prism::Location,
      operator_loc: Prism::Location,
      value: Prism::Node
    ).returns(Prism::GlobalVariableAndWriteNode)
  end
  def global_variable_and_write_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil), name_loc: T.unsafe(nil), operator_loc: T.unsafe(nil), value: T.unsafe(nil)); end

  # Create a new GlobalVariableOperatorWriteNode node.
  #
  # source://prism//lib/prism/dsl.rb#372
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      name_loc: Prism::Location,
      binary_operator_loc: Prism::Location,
      value: Prism::Node,
      binary_operator: Symbol
    ).returns(Prism::GlobalVariableOperatorWriteNode)
  end
  def global_variable_operator_write_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil), name_loc: T.unsafe(nil), binary_operator_loc: T.unsafe(nil), value: T.unsafe(nil), binary_operator: T.unsafe(nil)); end

  # Create a new GlobalVariableOrWriteNode node.
  #
  # source://prism//lib/prism/dsl.rb#377
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      name_loc: Prism::Location,
      operator_loc: Prism::Location,
      value: Prism::Node
    ).returns(Prism::GlobalVariableOrWriteNode)
  end
  def global_variable_or_write_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil), name_loc: T.unsafe(nil), operator_loc: T.unsafe(nil), value: T.unsafe(nil)); end

  # Create a new GlobalVariableReadNode node.
  #
  # source://prism//lib/prism/dsl.rb#382
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol
    ).returns(Prism::GlobalVariableReadNode)
  end
  def global_variable_read_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil)); end

  # Create a new GlobalVariableTargetNode node.
  #
  # source://prism//lib/prism/dsl.rb#387
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol
    ).returns(Prism::GlobalVariableTargetNode)
  end
  def global_variable_target_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil)); end

  # Create a new GlobalVariableWriteNode node.
  #
  # source://prism//lib/prism/dsl.rb#392
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      name_loc: Prism::Location,
      value: Prism::Node,
      operator_loc: Prism::Location
    ).returns(Prism::GlobalVariableWriteNode)
  end
  def global_variable_write_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil), name_loc: T.unsafe(nil), value: T.unsafe(nil), operator_loc: T.unsafe(nil)); end

  # Create a new HashNode node.
  #
  # source://prism//lib/prism/dsl.rb#397
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      opening_loc: Prism::Location,
      elements: T::Array[T.any(Prism::AssocNode, Prism::AssocSplatNode)],
      closing_loc: Prism::Location
    ).returns(Prism::HashNode)
  end
  def hash_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), opening_loc: T.unsafe(nil), elements: T.unsafe(nil), closing_loc: T.unsafe(nil)); end

  # Create a new HashPatternNode node.
  #
  # source://prism//lib/prism/dsl.rb#402
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      constant: T.nilable(T.any(Prism::ConstantReadNode, Prism::ConstantPathNode)),
      elements: T::Array[Prism::AssocNode],
      rest: T.nilable(T.any(Prism::AssocSplatNode, Prism::NoKeywordsParameterNode)),
      opening_loc: T.nilable(Prism::Location),
      closing_loc: T.nilable(Prism::Location)
    ).returns(Prism::HashPatternNode)
  end
  def hash_pattern_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), constant: T.unsafe(nil), elements: T.unsafe(nil), rest: T.unsafe(nil), opening_loc: T.unsafe(nil), closing_loc: T.unsafe(nil)); end

  # Create a new IfNode node.
  #
  # source://prism//lib/prism/dsl.rb#407
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      if_keyword_loc: T.nilable(Prism::Location),
      predicate: Prism::Node,
      then_keyword_loc: T.nilable(Prism::Location),
      statements: T.nilable(Prism::StatementsNode),
      subsequent: T.nilable(T.any(Prism::ElseNode, Prism::IfNode)),
      end_keyword_loc: T.nilable(Prism::Location)
    ).returns(Prism::IfNode)
  end
  def if_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), if_keyword_loc: T.unsafe(nil), predicate: T.unsafe(nil), then_keyword_loc: T.unsafe(nil), statements: T.unsafe(nil), subsequent: T.unsafe(nil), end_keyword_loc: T.unsafe(nil)); end

  # Create a new ImaginaryNode node.
  #
  # source://prism//lib/prism/dsl.rb#412
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      numeric: T.any(Prism::FloatNode, Prism::IntegerNode, Prism::RationalNode)
    ).returns(Prism::ImaginaryNode)
  end
  def imaginary_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), numeric: T.unsafe(nil)); end

  # Create a new ImplicitNode node.
  #
  # source://prism//lib/prism/dsl.rb#417
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      value: T.any(Prism::LocalVariableReadNode, Prism::CallNode, Prism::ConstantReadNode, Prism::LocalVariableTargetNode)
    ).returns(Prism::ImplicitNode)
  end
  def implicit_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), value: T.unsafe(nil)); end

  # Create a new ImplicitRestNode node.
  #
  # source://prism//lib/prism/dsl.rb#422
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer
    ).returns(Prism::ImplicitRestNode)
  end
  def implicit_rest_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil)); end

  # Create a new InNode node.
  #
  # source://prism//lib/prism/dsl.rb#427
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      pattern: Prism::Node,
      statements: T.nilable(Prism::StatementsNode),
      in_loc: Prism::Location,
      then_loc: T.nilable(Prism::Location)
    ).returns(Prism::InNode)
  end
  def in_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), pattern: T.unsafe(nil), statements: T.unsafe(nil), in_loc: T.unsafe(nil), then_loc: T.unsafe(nil)); end

  # Create a new IndexAndWriteNode node.
  #
  # source://prism//lib/prism/dsl.rb#432
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      receiver: T.nilable(Prism::Node),
      call_operator_loc: T.nilable(Prism::Location),
      opening_loc: Prism::Location,
      arguments: T.nilable(Prism::ArgumentsNode),
      closing_loc: Prism::Location,
      block: T.nilable(Prism::BlockArgumentNode),
      operator_loc: Prism::Location,
      value: Prism::Node
    ).returns(Prism::IndexAndWriteNode)
  end
  def index_and_write_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), receiver: T.unsafe(nil), call_operator_loc: T.unsafe(nil), opening_loc: T.unsafe(nil), arguments: T.unsafe(nil), closing_loc: T.unsafe(nil), block: T.unsafe(nil), operator_loc: T.unsafe(nil), value: T.unsafe(nil)); end

  # Create a new IndexOperatorWriteNode node.
  #
  # source://prism//lib/prism/dsl.rb#437
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      receiver: T.nilable(Prism::Node),
      call_operator_loc: T.nilable(Prism::Location),
      opening_loc: Prism::Location,
      arguments: T.nilable(Prism::ArgumentsNode),
      closing_loc: Prism::Location,
      block: T.nilable(Prism::BlockArgumentNode),
      binary_operator: Symbol,
      binary_operator_loc: Prism::Location,
      value: Prism::Node
    ).returns(Prism::IndexOperatorWriteNode)
  end
  def index_operator_write_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), receiver: T.unsafe(nil), call_operator_loc: T.unsafe(nil), opening_loc: T.unsafe(nil), arguments: T.unsafe(nil), closing_loc: T.unsafe(nil), block: T.unsafe(nil), binary_operator: T.unsafe(nil), binary_operator_loc: T.unsafe(nil), value: T.unsafe(nil)); end

  # Create a new IndexOrWriteNode node.
  #
  # source://prism//lib/prism/dsl.rb#442
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      receiver: T.nilable(Prism::Node),
      call_operator_loc: T.nilable(Prism::Location),
      opening_loc: Prism::Location,
      arguments: T.nilable(Prism::ArgumentsNode),
      closing_loc: Prism::Location,
      block: T.nilable(Prism::BlockArgumentNode),
      operator_loc: Prism::Location,
      value: Prism::Node
    ).returns(Prism::IndexOrWriteNode)
  end
  def index_or_write_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), receiver: T.unsafe(nil), call_operator_loc: T.unsafe(nil), opening_loc: T.unsafe(nil), arguments: T.unsafe(nil), closing_loc: T.unsafe(nil), block: T.unsafe(nil), operator_loc: T.unsafe(nil), value: T.unsafe(nil)); end

  # Create a new IndexTargetNode node.
  #
  # source://prism//lib/prism/dsl.rb#447
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      receiver: Prism::Node,
      opening_loc: Prism::Location,
      arguments: T.nilable(Prism::ArgumentsNode),
      closing_loc: Prism::Location,
      block: T.nilable(Prism::BlockArgumentNode)
    ).returns(Prism::IndexTargetNode)
  end
  def index_target_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), receiver: T.unsafe(nil), opening_loc: T.unsafe(nil), arguments: T.unsafe(nil), closing_loc: T.unsafe(nil), block: T.unsafe(nil)); end

  # Create a new InstanceVariableAndWriteNode node.
  #
  # source://prism//lib/prism/dsl.rb#452
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      name_loc: Prism::Location,
      operator_loc: Prism::Location,
      value: Prism::Node
    ).returns(Prism::InstanceVariableAndWriteNode)
  end
  def instance_variable_and_write_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil), name_loc: T.unsafe(nil), operator_loc: T.unsafe(nil), value: T.unsafe(nil)); end

  # Create a new InstanceVariableOperatorWriteNode node.
  #
  # source://prism//lib/prism/dsl.rb#457
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      name_loc: Prism::Location,
      binary_operator_loc: Prism::Location,
      value: Prism::Node,
      binary_operator: Symbol
    ).returns(Prism::InstanceVariableOperatorWriteNode)
  end
  def instance_variable_operator_write_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil), name_loc: T.unsafe(nil), binary_operator_loc: T.unsafe(nil), value: T.unsafe(nil), binary_operator: T.unsafe(nil)); end

  # Create a new InstanceVariableOrWriteNode node.
  #
  # source://prism//lib/prism/dsl.rb#462
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      name_loc: Prism::Location,
      operator_loc: Prism::Location,
      value: Prism::Node
    ).returns(Prism::InstanceVariableOrWriteNode)
  end
  def instance_variable_or_write_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil), name_loc: T.unsafe(nil), operator_loc: T.unsafe(nil), value: T.unsafe(nil)); end

  # Create a new InstanceVariableReadNode node.
  #
  # source://prism//lib/prism/dsl.rb#467
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol
    ).returns(Prism::InstanceVariableReadNode)
  end
  def instance_variable_read_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil)); end

  # Create a new InstanceVariableTargetNode node.
  #
  # source://prism//lib/prism/dsl.rb#472
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol
    ).returns(Prism::InstanceVariableTargetNode)
  end
  def instance_variable_target_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil)); end

  # Create a new InstanceVariableWriteNode node.
  #
  # source://prism//lib/prism/dsl.rb#477
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      name_loc: Prism::Location,
      value: Prism::Node,
      operator_loc: Prism::Location
    ).returns(Prism::InstanceVariableWriteNode)
  end
  def instance_variable_write_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil), name_loc: T.unsafe(nil), value: T.unsafe(nil), operator_loc: T.unsafe(nil)); end

  # Retrieve the value of one of the IntegerBaseFlags flags.
  #
  # source://prism//lib/prism/dsl.rb#872
  sig { params(name: Symbol).returns(Integer) }
  def integer_base_flag(name); end

  # Create a new IntegerNode node.
  #
  # source://prism//lib/prism/dsl.rb#482
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      value: Integer
    ).returns(Prism::IntegerNode)
  end
  def integer_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), value: T.unsafe(nil)); end

  # Create a new InterpolatedMatchLastLineNode node.
  #
  # source://prism//lib/prism/dsl.rb#487
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      opening_loc: Prism::Location,
      parts: T::Array[T.any(Prism::StringNode, Prism::EmbeddedStatementsNode, Prism::EmbeddedVariableNode)],
      closing_loc: Prism::Location
    ).returns(Prism::InterpolatedMatchLastLineNode)
  end
  def interpolated_match_last_line_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), opening_loc: T.unsafe(nil), parts: T.unsafe(nil), closing_loc: T.unsafe(nil)); end

  # Create a new InterpolatedRegularExpressionNode node.
  #
  # source://prism//lib/prism/dsl.rb#492
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      opening_loc: Prism::Location,
      parts: T::Array[T.any(Prism::StringNode, Prism::EmbeddedStatementsNode, Prism::EmbeddedVariableNode)],
      closing_loc: Prism::Location
    ).returns(Prism::InterpolatedRegularExpressionNode)
  end
  def interpolated_regular_expression_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), opening_loc: T.unsafe(nil), parts: T.unsafe(nil), closing_loc: T.unsafe(nil)); end

  # Create a new InterpolatedStringNode node.
  #
  # source://prism//lib/prism/dsl.rb#497
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      opening_loc: T.nilable(Prism::Location),
      parts: T::Array[T.any(Prism::StringNode, Prism::EmbeddedStatementsNode, Prism::EmbeddedVariableNode, Prism::InterpolatedStringNode)],
      closing_loc: T.nilable(Prism::Location)
    ).returns(Prism::InterpolatedStringNode)
  end
  def interpolated_string_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), opening_loc: T.unsafe(nil), parts: T.unsafe(nil), closing_loc: T.unsafe(nil)); end

  # Retrieve the value of one of the InterpolatedStringNodeFlags flags.
  #
  # source://prism//lib/prism/dsl.rb#883
  sig { params(name: Symbol).returns(Integer) }
  def interpolated_string_node_flag(name); end

  # Create a new InterpolatedSymbolNode node.
  #
  # source://prism//lib/prism/dsl.rb#502
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      opening_loc: T.nilable(Prism::Location),
      parts: T::Array[T.any(Prism::StringNode, Prism::EmbeddedStatementsNode, Prism::EmbeddedVariableNode)],
      closing_loc: T.nilable(Prism::Location)
    ).returns(Prism::InterpolatedSymbolNode)
  end
  def interpolated_symbol_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), opening_loc: T.unsafe(nil), parts: T.unsafe(nil), closing_loc: T.unsafe(nil)); end

  # Create a new InterpolatedXStringNode node.
  #
  # source://prism//lib/prism/dsl.rb#507
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      opening_loc: Prism::Location,
      parts: T::Array[T.any(Prism::StringNode, Prism::EmbeddedStatementsNode, Prism::EmbeddedVariableNode)],
      closing_loc: Prism::Location
    ).returns(Prism::InterpolatedXStringNode)
  end
  def interpolated_x_string_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), opening_loc: T.unsafe(nil), parts: T.unsafe(nil), closing_loc: T.unsafe(nil)); end

  # Create a new ItLocalVariableReadNode node.
  #
  # source://prism//lib/prism/dsl.rb#512
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer
    ).returns(Prism::ItLocalVariableReadNode)
  end
  def it_local_variable_read_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil)); end

  # Create a new ItParametersNode node.
  #
  # source://prism//lib/prism/dsl.rb#517
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer
    ).returns(Prism::ItParametersNode)
  end
  def it_parameters_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil)); end

  # Create a new KeywordHashNode node.
  #
  # source://prism//lib/prism/dsl.rb#522
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      elements: T::Array[T.any(Prism::AssocNode, Prism::AssocSplatNode)]
    ).returns(Prism::KeywordHashNode)
  end
  def keyword_hash_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), elements: T.unsafe(nil)); end

  # Retrieve the value of one of the KeywordHashNodeFlags flags.
  #
  # source://prism//lib/prism/dsl.rb#892
  sig { params(name: Symbol).returns(Integer) }
  def keyword_hash_node_flag(name); end

  # Create a new KeywordRestParameterNode node.
  #
  # source://prism//lib/prism/dsl.rb#527
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: T.nilable(Symbol),
      name_loc: T.nilable(Prism::Location),
      operator_loc: Prism::Location
    ).returns(Prism::KeywordRestParameterNode)
  end
  def keyword_rest_parameter_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil), name_loc: T.unsafe(nil), operator_loc: T.unsafe(nil)); end

  # Create a new LambdaNode node.
  #
  # source://prism//lib/prism/dsl.rb#532
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      locals: T::Array[Symbol],
      operator_loc: Prism::Location,
      opening_loc: Prism::Location,
      closing_loc: Prism::Location,
      parameters: T.nilable(T.any(Prism::BlockParametersNode, Prism::NumberedParametersNode, Prism::ItParametersNode)),
      body: T.nilable(T.any(Prism::StatementsNode, Prism::BeginNode))
    ).returns(Prism::LambdaNode)
  end
  def lambda_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), locals: T.unsafe(nil), operator_loc: T.unsafe(nil), opening_loc: T.unsafe(nil), closing_loc: T.unsafe(nil), parameters: T.unsafe(nil), body: T.unsafe(nil)); end

  # Create a new LocalVariableAndWriteNode node.
  #
  # source://prism//lib/prism/dsl.rb#537
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name_loc: Prism::Location,
      operator_loc: Prism::Location,
      value: Prism::Node,
      name: Symbol,
      depth: Integer
    ).returns(Prism::LocalVariableAndWriteNode)
  end
  def local_variable_and_write_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name_loc: T.unsafe(nil), operator_loc: T.unsafe(nil), value: T.unsafe(nil), name: T.unsafe(nil), depth: T.unsafe(nil)); end

  # Create a new LocalVariableOperatorWriteNode node.
  #
  # source://prism//lib/prism/dsl.rb#542
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name_loc: Prism::Location,
      binary_operator_loc: Prism::Location,
      value: Prism::Node,
      name: Symbol,
      binary_operator: Symbol,
      depth: Integer
    ).returns(Prism::LocalVariableOperatorWriteNode)
  end
  def local_variable_operator_write_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name_loc: T.unsafe(nil), binary_operator_loc: T.unsafe(nil), value: T.unsafe(nil), name: T.unsafe(nil), binary_operator: T.unsafe(nil), depth: T.unsafe(nil)); end

  # Create a new LocalVariableOrWriteNode node.
  #
  # source://prism//lib/prism/dsl.rb#547
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name_loc: Prism::Location,
      operator_loc: Prism::Location,
      value: Prism::Node,
      name: Symbol,
      depth: Integer
    ).returns(Prism::LocalVariableOrWriteNode)
  end
  def local_variable_or_write_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name_loc: T.unsafe(nil), operator_loc: T.unsafe(nil), value: T.unsafe(nil), name: T.unsafe(nil), depth: T.unsafe(nil)); end

  # Create a new LocalVariableReadNode node.
  #
  # source://prism//lib/prism/dsl.rb#552
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      depth: Integer
    ).returns(Prism::LocalVariableReadNode)
  end
  def local_variable_read_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil), depth: T.unsafe(nil)); end

  # Create a new LocalVariableTargetNode node.
  #
  # source://prism//lib/prism/dsl.rb#557
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      depth: Integer
    ).returns(Prism::LocalVariableTargetNode)
  end
  def local_variable_target_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil), depth: T.unsafe(nil)); end

  # Create a new LocalVariableWriteNode node.
  #
  # source://prism//lib/prism/dsl.rb#562
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      depth: Integer,
      name_loc: Prism::Location,
      value: Prism::Node,
      operator_loc: Prism::Location
    ).returns(Prism::LocalVariableWriteNode)
  end
  def local_variable_write_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil), depth: T.unsafe(nil), name_loc: T.unsafe(nil), value: T.unsafe(nil), operator_loc: T.unsafe(nil)); end

  # Create a new Location object.
  #
  # source://prism//lib/prism/dsl.rb#72
  sig { params(source: Prism::Source, start_offset: Integer, length: Integer).returns(Prism::Location) }
  def location(source: T.unsafe(nil), start_offset: T.unsafe(nil), length: T.unsafe(nil)); end

  # Retrieve the value of one of the LoopFlags flags.
  #
  # source://prism//lib/prism/dsl.rb#900
  sig { params(name: Symbol).returns(Integer) }
  def loop_flag(name); end

  # Create a new MatchLastLineNode node.
  #
  # source://prism//lib/prism/dsl.rb#567
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      opening_loc: Prism::Location,
      content_loc: Prism::Location,
      closing_loc: Prism::Location,
      unescaped: String
    ).returns(Prism::MatchLastLineNode)
  end
  def match_last_line_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), opening_loc: T.unsafe(nil), content_loc: T.unsafe(nil), closing_loc: T.unsafe(nil), unescaped: T.unsafe(nil)); end

  # Create a new MatchPredicateNode node.
  #
  # source://prism//lib/prism/dsl.rb#572
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      value: Prism::Node,
      pattern: Prism::Node,
      operator_loc: Prism::Location
    ).returns(Prism::MatchPredicateNode)
  end
  def match_predicate_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), value: T.unsafe(nil), pattern: T.unsafe(nil), operator_loc: T.unsafe(nil)); end

  # Create a new MatchRequiredNode node.
  #
  # source://prism//lib/prism/dsl.rb#577
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      value: Prism::Node,
      pattern: Prism::Node,
      operator_loc: Prism::Location
    ).returns(Prism::MatchRequiredNode)
  end
  def match_required_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), value: T.unsafe(nil), pattern: T.unsafe(nil), operator_loc: T.unsafe(nil)); end

  # Create a new MatchWriteNode node.
  #
  # source://prism//lib/prism/dsl.rb#582
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      call: Prism::CallNode,
      targets: T::Array[Prism::LocalVariableTargetNode]
    ).returns(Prism::MatchWriteNode)
  end
  def match_write_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), call: T.unsafe(nil), targets: T.unsafe(nil)); end

  # Create a new MissingNode node.
  #
  # source://prism//lib/prism/dsl.rb#587
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer
    ).returns(Prism::MissingNode)
  end
  def missing_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil)); end

  # Create a new ModuleNode node.
  #
  # source://prism//lib/prism/dsl.rb#592
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      locals: T::Array[Symbol],
      module_keyword_loc: Prism::Location,
      constant_path: T.any(Prism::ConstantReadNode, Prism::ConstantPathNode, Prism::MissingNode),
      body: T.nilable(T.any(Prism::StatementsNode, Prism::BeginNode)),
      end_keyword_loc: Prism::Location,
      name: Symbol
    ).returns(Prism::ModuleNode)
  end
  def module_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), locals: T.unsafe(nil), module_keyword_loc: T.unsafe(nil), constant_path: T.unsafe(nil), body: T.unsafe(nil), end_keyword_loc: T.unsafe(nil), name: T.unsafe(nil)); end

  # Create a new MultiTargetNode node.
  #
  # source://prism//lib/prism/dsl.rb#597
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      lefts: T::Array[T.any(Prism::LocalVariableTargetNode, Prism::InstanceVariableTargetNode, Prism::ClassVariableTargetNode, Prism::GlobalVariableTargetNode, Prism::ConstantTargetNode, Prism::ConstantPathTargetNode, Prism::CallTargetNode, Prism::IndexTargetNode, Prism::MultiTargetNode, Prism::RequiredParameterNode, Prism::BackReferenceReadNode, Prism::NumberedReferenceReadNode)],
      rest: T.nilable(T.any(Prism::ImplicitRestNode, Prism::SplatNode)),
      rights: T::Array[T.any(Prism::LocalVariableTargetNode, Prism::InstanceVariableTargetNode, Prism::ClassVariableTargetNode, Prism::GlobalVariableTargetNode, Prism::ConstantTargetNode, Prism::ConstantPathTargetNode, Prism::CallTargetNode, Prism::IndexTargetNode, Prism::MultiTargetNode, Prism::RequiredParameterNode, Prism::BackReferenceReadNode, Prism::NumberedReferenceReadNode)],
      lparen_loc: T.nilable(Prism::Location),
      rparen_loc: T.nilable(Prism::Location)
    ).returns(Prism::MultiTargetNode)
  end
  def multi_target_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), lefts: T.unsafe(nil), rest: T.unsafe(nil), rights: T.unsafe(nil), lparen_loc: T.unsafe(nil), rparen_loc: T.unsafe(nil)); end

  # Create a new MultiWriteNode node.
  #
  # source://prism//lib/prism/dsl.rb#602
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      lefts: T::Array[T.any(Prism::LocalVariableTargetNode, Prism::InstanceVariableTargetNode, Prism::ClassVariableTargetNode, Prism::GlobalVariableTargetNode, Prism::ConstantTargetNode, Prism::ConstantPathTargetNode, Prism::CallTargetNode, Prism::IndexTargetNode, Prism::MultiTargetNode, Prism::BackReferenceReadNode, Prism::NumberedReferenceReadNode)],
      rest: T.nilable(T.any(Prism::ImplicitRestNode, Prism::SplatNode)),
      rights: T::Array[T.any(Prism::LocalVariableTargetNode, Prism::InstanceVariableTargetNode, Prism::ClassVariableTargetNode, Prism::GlobalVariableTargetNode, Prism::ConstantTargetNode, Prism::ConstantPathTargetNode, Prism::CallTargetNode, Prism::IndexTargetNode, Prism::MultiTargetNode, Prism::BackReferenceReadNode, Prism::NumberedReferenceReadNode)],
      lparen_loc: T.nilable(Prism::Location),
      rparen_loc: T.nilable(Prism::Location),
      operator_loc: Prism::Location,
      value: Prism::Node
    ).returns(Prism::MultiWriteNode)
  end
  def multi_write_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), lefts: T.unsafe(nil), rest: T.unsafe(nil), rights: T.unsafe(nil), lparen_loc: T.unsafe(nil), rparen_loc: T.unsafe(nil), operator_loc: T.unsafe(nil), value: T.unsafe(nil)); end

  # Create a new NextNode node.
  #
  # source://prism//lib/prism/dsl.rb#607
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      arguments: T.nilable(Prism::ArgumentsNode),
      keyword_loc: Prism::Location
    ).returns(Prism::NextNode)
  end
  def next_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), arguments: T.unsafe(nil), keyword_loc: T.unsafe(nil)); end

  # Create a new NilNode node.
  #
  # source://prism//lib/prism/dsl.rb#612
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer
    ).returns(Prism::NilNode)
  end
  def nil_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil)); end

  # Create a new NoKeywordsParameterNode node.
  #
  # source://prism//lib/prism/dsl.rb#617
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      operator_loc: Prism::Location,
      keyword_loc: Prism::Location
    ).returns(Prism::NoKeywordsParameterNode)
  end
  def no_keywords_parameter_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), operator_loc: T.unsafe(nil), keyword_loc: T.unsafe(nil)); end

  # Create a new NumberedParametersNode node.
  #
  # source://prism//lib/prism/dsl.rb#622
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      maximum: Integer
    ).returns(Prism::NumberedParametersNode)
  end
  def numbered_parameters_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), maximum: T.unsafe(nil)); end

  # Create a new NumberedReferenceReadNode node.
  #
  # source://prism//lib/prism/dsl.rb#627
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      number: Integer
    ).returns(Prism::NumberedReferenceReadNode)
  end
  def numbered_reference_read_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), number: T.unsafe(nil)); end

  # Create a new OptionalKeywordParameterNode node.
  #
  # source://prism//lib/prism/dsl.rb#632
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      name_loc: Prism::Location,
      value: Prism::Node
    ).returns(Prism::OptionalKeywordParameterNode)
  end
  def optional_keyword_parameter_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil), name_loc: T.unsafe(nil), value: T.unsafe(nil)); end

  # Create a new OptionalParameterNode node.
  #
  # source://prism//lib/prism/dsl.rb#637
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      name_loc: Prism::Location,
      operator_loc: Prism::Location,
      value: Prism::Node
    ).returns(Prism::OptionalParameterNode)
  end
  def optional_parameter_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil), name_loc: T.unsafe(nil), operator_loc: T.unsafe(nil), value: T.unsafe(nil)); end

  # Create a new OrNode node.
  #
  # source://prism//lib/prism/dsl.rb#642
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      left: Prism::Node,
      right: Prism::Node,
      operator_loc: Prism::Location
    ).returns(Prism::OrNode)
  end
  def or_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), left: T.unsafe(nil), right: T.unsafe(nil), operator_loc: T.unsafe(nil)); end

  # Retrieve the value of one of the ParameterFlags flags.
  #
  # source://prism//lib/prism/dsl.rb#908
  sig { params(name: Symbol).returns(Integer) }
  def parameter_flag(name); end

  # Create a new ParametersNode node.
  #
  # source://prism//lib/prism/dsl.rb#647
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      requireds: T::Array[T.any(Prism::RequiredParameterNode, Prism::MultiTargetNode)],
      optionals: T::Array[Prism::OptionalParameterNode],
      rest: T.nilable(T.any(Prism::RestParameterNode, Prism::ImplicitRestNode)),
      posts: T::Array[T.any(Prism::RequiredParameterNode, Prism::MultiTargetNode, Prism::KeywordRestParameterNode, Prism::NoKeywordsParameterNode, Prism::ForwardingParameterNode)],
      keywords: T::Array[T.any(Prism::RequiredKeywordParameterNode, Prism::OptionalKeywordParameterNode)],
      keyword_rest: T.nilable(T.any(Prism::KeywordRestParameterNode, Prism::ForwardingParameterNode, Prism::NoKeywordsParameterNode)),
      block: T.nilable(Prism::BlockParameterNode)
    ).returns(Prism::ParametersNode)
  end
  def parameters_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), requireds: T.unsafe(nil), optionals: T.unsafe(nil), rest: T.unsafe(nil), posts: T.unsafe(nil), keywords: T.unsafe(nil), keyword_rest: T.unsafe(nil), block: T.unsafe(nil)); end

  # Create a new ParenthesesNode node.
  #
  # source://prism//lib/prism/dsl.rb#652
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      body: T.nilable(Prism::Node),
      opening_loc: Prism::Location,
      closing_loc: Prism::Location
    ).returns(Prism::ParenthesesNode)
  end
  def parentheses_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), body: T.unsafe(nil), opening_loc: T.unsafe(nil), closing_loc: T.unsafe(nil)); end

  # Create a new PinnedExpressionNode node.
  #
  # source://prism//lib/prism/dsl.rb#657
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      expression: Prism::Node,
      operator_loc: Prism::Location,
      lparen_loc: Prism::Location,
      rparen_loc: Prism::Location
    ).returns(Prism::PinnedExpressionNode)
  end
  def pinned_expression_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), expression: T.unsafe(nil), operator_loc: T.unsafe(nil), lparen_loc: T.unsafe(nil), rparen_loc: T.unsafe(nil)); end

  # Create a new PinnedVariableNode node.
  #
  # source://prism//lib/prism/dsl.rb#662
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      variable: T.any(Prism::LocalVariableReadNode, Prism::InstanceVariableReadNode, Prism::ClassVariableReadNode, Prism::GlobalVariableReadNode, Prism::BackReferenceReadNode, Prism::NumberedReferenceReadNode, Prism::ItLocalVariableReadNode, Prism::MissingNode),
      operator_loc: Prism::Location
    ).returns(Prism::PinnedVariableNode)
  end
  def pinned_variable_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), variable: T.unsafe(nil), operator_loc: T.unsafe(nil)); end

  # Create a new PostExecutionNode node.
  #
  # source://prism//lib/prism/dsl.rb#667
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      statements: T.nilable(Prism::StatementsNode),
      keyword_loc: Prism::Location,
      opening_loc: Prism::Location,
      closing_loc: Prism::Location
    ).returns(Prism::PostExecutionNode)
  end
  def post_execution_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), statements: T.unsafe(nil), keyword_loc: T.unsafe(nil), opening_loc: T.unsafe(nil), closing_loc: T.unsafe(nil)); end

  # Create a new PreExecutionNode node.
  #
  # source://prism//lib/prism/dsl.rb#672
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      statements: T.nilable(Prism::StatementsNode),
      keyword_loc: Prism::Location,
      opening_loc: Prism::Location,
      closing_loc: Prism::Location
    ).returns(Prism::PreExecutionNode)
  end
  def pre_execution_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), statements: T.unsafe(nil), keyword_loc: T.unsafe(nil), opening_loc: T.unsafe(nil), closing_loc: T.unsafe(nil)); end

  # Create a new ProgramNode node.
  #
  # source://prism//lib/prism/dsl.rb#677
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      locals: T::Array[Symbol],
      statements: Prism::StatementsNode
    ).returns(Prism::ProgramNode)
  end
  def program_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), locals: T.unsafe(nil), statements: T.unsafe(nil)); end

  # Retrieve the value of one of the RangeFlags flags.
  #
  # source://prism//lib/prism/dsl.rb#916
  sig { params(name: Symbol).returns(Integer) }
  def range_flag(name); end

  # Create a new RangeNode node.
  #
  # source://prism//lib/prism/dsl.rb#682
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      left: T.nilable(Prism::Node),
      right: T.nilable(Prism::Node),
      operator_loc: Prism::Location
    ).returns(Prism::RangeNode)
  end
  def range_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), left: T.unsafe(nil), right: T.unsafe(nil), operator_loc: T.unsafe(nil)); end

  # Create a new RationalNode node.
  #
  # source://prism//lib/prism/dsl.rb#687
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      numerator: Integer,
      denominator: Integer
    ).returns(Prism::RationalNode)
  end
  def rational_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), numerator: T.unsafe(nil), denominator: T.unsafe(nil)); end

  # Create a new RedoNode node.
  #
  # source://prism//lib/prism/dsl.rb#692
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer
    ).returns(Prism::RedoNode)
  end
  def redo_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil)); end

  # Retrieve the value of one of the RegularExpressionFlags flags.
  #
  # source://prism//lib/prism/dsl.rb#924
  sig { params(name: Symbol).returns(Integer) }
  def regular_expression_flag(name); end

  # Create a new RegularExpressionNode node.
  #
  # source://prism//lib/prism/dsl.rb#697
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      opening_loc: Prism::Location,
      content_loc: Prism::Location,
      closing_loc: Prism::Location,
      unescaped: String
    ).returns(Prism::RegularExpressionNode)
  end
  def regular_expression_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), opening_loc: T.unsafe(nil), content_loc: T.unsafe(nil), closing_loc: T.unsafe(nil), unescaped: T.unsafe(nil)); end

  # Create a new RequiredKeywordParameterNode node.
  #
  # source://prism//lib/prism/dsl.rb#702
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      name_loc: Prism::Location
    ).returns(Prism::RequiredKeywordParameterNode)
  end
  def required_keyword_parameter_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil), name_loc: T.unsafe(nil)); end

  # Create a new RequiredParameterNode node.
  #
  # source://prism//lib/prism/dsl.rb#707
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol
    ).returns(Prism::RequiredParameterNode)
  end
  def required_parameter_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil)); end

  # Create a new RescueModifierNode node.
  #
  # source://prism//lib/prism/dsl.rb#712
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      expression: Prism::Node,
      keyword_loc: Prism::Location,
      rescue_expression: Prism::Node
    ).returns(Prism::RescueModifierNode)
  end
  def rescue_modifier_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), expression: T.unsafe(nil), keyword_loc: T.unsafe(nil), rescue_expression: T.unsafe(nil)); end

  # Create a new RescueNode node.
  #
  # source://prism//lib/prism/dsl.rb#717
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      keyword_loc: Prism::Location,
      exceptions: T::Array[Prism::Node],
      operator_loc: T.nilable(Prism::Location),
      reference: T.nilable(T.any(Prism::LocalVariableTargetNode, Prism::InstanceVariableTargetNode, Prism::ClassVariableTargetNode, Prism::GlobalVariableTargetNode, Prism::ConstantTargetNode, Prism::ConstantPathTargetNode, Prism::CallTargetNode, Prism::IndexTargetNode, Prism::BackReferenceReadNode, Prism::NumberedReferenceReadNode, Prism::MissingNode)),
      statements: T.nilable(Prism::StatementsNode),
      subsequent: T.nilable(Prism::RescueNode)
    ).returns(Prism::RescueNode)
  end
  def rescue_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), keyword_loc: T.unsafe(nil), exceptions: T.unsafe(nil), operator_loc: T.unsafe(nil), reference: T.unsafe(nil), statements: T.unsafe(nil), subsequent: T.unsafe(nil)); end

  # Create a new RestParameterNode node.
  #
  # source://prism//lib/prism/dsl.rb#722
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: T.nilable(Symbol),
      name_loc: T.nilable(Prism::Location),
      operator_loc: Prism::Location
    ).returns(Prism::RestParameterNode)
  end
  def rest_parameter_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil), name_loc: T.unsafe(nil), operator_loc: T.unsafe(nil)); end

  # Create a new RetryNode node.
  #
  # source://prism//lib/prism/dsl.rb#727
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer
    ).returns(Prism::RetryNode)
  end
  def retry_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil)); end

  # Create a new ReturnNode node.
  #
  # source://prism//lib/prism/dsl.rb#732
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      keyword_loc: Prism::Location,
      arguments: T.nilable(Prism::ArgumentsNode)
    ).returns(Prism::ReturnNode)
  end
  def return_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), keyword_loc: T.unsafe(nil), arguments: T.unsafe(nil)); end

  # Create a new SelfNode node.
  #
  # source://prism//lib/prism/dsl.rb#737
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer
    ).returns(Prism::SelfNode)
  end
  def self_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil)); end

  # Create a new ShareableConstantNode node.
  #
  # source://prism//lib/prism/dsl.rb#742
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      write: T.any(Prism::ConstantWriteNode, Prism::ConstantAndWriteNode, Prism::ConstantOrWriteNode, Prism::ConstantOperatorWriteNode, Prism::ConstantPathWriteNode, Prism::ConstantPathAndWriteNode, Prism::ConstantPathOrWriteNode, Prism::ConstantPathOperatorWriteNode)
    ).returns(Prism::ShareableConstantNode)
  end
  def shareable_constant_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), write: T.unsafe(nil)); end

  # Retrieve the value of one of the ShareableConstantNodeFlags flags.
  #
  # source://prism//lib/prism/dsl.rb#942
  sig { params(name: Symbol).returns(Integer) }
  def shareable_constant_node_flag(name); end

  # Create a new SingletonClassNode node.
  #
  # source://prism//lib/prism/dsl.rb#747
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      locals: T::Array[Symbol],
      class_keyword_loc: Prism::Location,
      operator_loc: Prism::Location,
      expression: Prism::Node,
      body: T.nilable(T.any(Prism::StatementsNode, Prism::BeginNode)),
      end_keyword_loc: Prism::Location
    ).returns(Prism::SingletonClassNode)
  end
  def singleton_class_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), locals: T.unsafe(nil), class_keyword_loc: T.unsafe(nil), operator_loc: T.unsafe(nil), expression: T.unsafe(nil), body: T.unsafe(nil), end_keyword_loc: T.unsafe(nil)); end

  # Create a new Source object.
  #
  # source://prism//lib/prism/dsl.rb#67
  sig { params(string: String).returns(Prism::Source) }
  def source(string); end

  # Create a new SourceEncodingNode node.
  #
  # source://prism//lib/prism/dsl.rb#752
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer
    ).returns(Prism::SourceEncodingNode)
  end
  def source_encoding_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil)); end

  # Create a new SourceFileNode node.
  #
  # source://prism//lib/prism/dsl.rb#757
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      filepath: String
    ).returns(Prism::SourceFileNode)
  end
  def source_file_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), filepath: T.unsafe(nil)); end

  # Create a new SourceLineNode node.
  #
  # source://prism//lib/prism/dsl.rb#762
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer
    ).returns(Prism::SourceLineNode)
  end
  def source_line_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil)); end

  # Create a new SplatNode node.
  #
  # source://prism//lib/prism/dsl.rb#767
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      operator_loc: Prism::Location,
      expression: T.nilable(Prism::Node)
    ).returns(Prism::SplatNode)
  end
  def splat_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), operator_loc: T.unsafe(nil), expression: T.unsafe(nil)); end

  # Create a new StatementsNode node.
  #
  # source://prism//lib/prism/dsl.rb#772
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      body: T::Array[Prism::Node]
    ).returns(Prism::StatementsNode)
  end
  def statements_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), body: T.unsafe(nil)); end

  # Retrieve the value of one of the StringFlags flags.
  #
  # source://prism//lib/prism/dsl.rb#952
  sig { params(name: Symbol).returns(Integer) }
  def string_flag(name); end

  # Create a new StringNode node.
  #
  # source://prism//lib/prism/dsl.rb#777
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      opening_loc: T.nilable(Prism::Location),
      content_loc: Prism::Location,
      closing_loc: T.nilable(Prism::Location),
      unescaped: String
    ).returns(Prism::StringNode)
  end
  def string_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), opening_loc: T.unsafe(nil), content_loc: T.unsafe(nil), closing_loc: T.unsafe(nil), unescaped: T.unsafe(nil)); end

  # Create a new SuperNode node.
  #
  # source://prism//lib/prism/dsl.rb#782
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      keyword_loc: Prism::Location,
      lparen_loc: T.nilable(Prism::Location),
      arguments: T.nilable(Prism::ArgumentsNode),
      rparen_loc: T.nilable(Prism::Location),
      block: T.nilable(T.any(Prism::BlockNode, Prism::BlockArgumentNode))
    ).returns(Prism::SuperNode)
  end
  def super_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), keyword_loc: T.unsafe(nil), lparen_loc: T.unsafe(nil), arguments: T.unsafe(nil), rparen_loc: T.unsafe(nil), block: T.unsafe(nil)); end

  # Retrieve the value of one of the SymbolFlags flags.
  #
  # source://prism//lib/prism/dsl.rb#963
  sig { params(name: Symbol).returns(Integer) }
  def symbol_flag(name); end

  # Create a new SymbolNode node.
  #
  # source://prism//lib/prism/dsl.rb#787
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      opening_loc: T.nilable(Prism::Location),
      value_loc: T.nilable(Prism::Location),
      closing_loc: T.nilable(Prism::Location),
      unescaped: String
    ).returns(Prism::SymbolNode)
  end
  def symbol_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), opening_loc: T.unsafe(nil), value_loc: T.unsafe(nil), closing_loc: T.unsafe(nil), unescaped: T.unsafe(nil)); end

  # Create a new TrueNode node.
  #
  # source://prism//lib/prism/dsl.rb#792
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer
    ).returns(Prism::TrueNode)
  end
  def true_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil)); end

  # Create a new UndefNode node.
  #
  # source://prism//lib/prism/dsl.rb#797
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      names: T::Array[T.any(Prism::SymbolNode, Prism::InterpolatedSymbolNode)],
      keyword_loc: Prism::Location
    ).returns(Prism::UndefNode)
  end
  def undef_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), names: T.unsafe(nil), keyword_loc: T.unsafe(nil)); end

  # Create a new UnlessNode node.
  #
  # source://prism//lib/prism/dsl.rb#802
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      keyword_loc: Prism::Location,
      predicate: Prism::Node,
      then_keyword_loc: T.nilable(Prism::Location),
      statements: T.nilable(Prism::StatementsNode),
      else_clause: T.nilable(Prism::ElseNode),
      end_keyword_loc: T.nilable(Prism::Location)
    ).returns(Prism::UnlessNode)
  end
  def unless_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), keyword_loc: T.unsafe(nil), predicate: T.unsafe(nil), then_keyword_loc: T.unsafe(nil), statements: T.unsafe(nil), else_clause: T.unsafe(nil), end_keyword_loc: T.unsafe(nil)); end

  # Create a new UntilNode node.
  #
  # source://prism//lib/prism/dsl.rb#807
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      keyword_loc: Prism::Location,
      closing_loc: T.nilable(Prism::Location),
      predicate: Prism::Node,
      statements: T.nilable(Prism::StatementsNode)
    ).returns(Prism::UntilNode)
  end
  def until_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), keyword_loc: T.unsafe(nil), closing_loc: T.unsafe(nil), predicate: T.unsafe(nil), statements: T.unsafe(nil)); end

  # Create a new WhenNode node.
  #
  # source://prism//lib/prism/dsl.rb#812
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      keyword_loc: Prism::Location,
      conditions: T::Array[Prism::Node],
      then_keyword_loc: T.nilable(Prism::Location),
      statements: T.nilable(Prism::StatementsNode)
    ).returns(Prism::WhenNode)
  end
  def when_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), keyword_loc: T.unsafe(nil), conditions: T.unsafe(nil), then_keyword_loc: T.unsafe(nil), statements: T.unsafe(nil)); end

  # Create a new WhileNode node.
  #
  # source://prism//lib/prism/dsl.rb#817
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      keyword_loc: Prism::Location,
      closing_loc: T.nilable(Prism::Location),
      predicate: Prism::Node,
      statements: T.nilable(Prism::StatementsNode)
    ).returns(Prism::WhileNode)
  end
  def while_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), keyword_loc: T.unsafe(nil), closing_loc: T.unsafe(nil), predicate: T.unsafe(nil), statements: T.unsafe(nil)); end

  # Create a new XStringNode node.
  #
  # source://prism//lib/prism/dsl.rb#822
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      opening_loc: Prism::Location,
      content_loc: Prism::Location,
      closing_loc: Prism::Location,
      unescaped: String
    ).returns(Prism::XStringNode)
  end
  def x_string_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), opening_loc: T.unsafe(nil), content_loc: T.unsafe(nil), closing_loc: T.unsafe(nil), unescaped: T.unsafe(nil)); end

  # Create a new YieldNode node.
  #
  # source://prism//lib/prism/dsl.rb#827
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      keyword_loc: Prism::Location,
      lparen_loc: T.nilable(Prism::Location),
      arguments: T.nilable(Prism::ArgumentsNode),
      rparen_loc: T.nilable(Prism::Location)
    ).returns(Prism::YieldNode)
  end
  def yield_node(source: T.unsafe(nil), node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), keyword_loc: T.unsafe(nil), lparen_loc: T.unsafe(nil), arguments: T.unsafe(nil), rparen_loc: T.unsafe(nil)); end

  private

  # The default location object that gets attached to nodes if no location is
  # specified, which uses the given source.
  #
  # source://prism//lib/prism/dsl.rb#982
  sig { returns(Prism::Location) }
  def default_location; end

  # The default node that gets attached to nodes if no node is specified for a
  # required node field.
  #
  # source://prism//lib/prism/dsl.rb#988
  sig { params(source: Prism::Source, location: Prism::Location).returns(Prism::Node) }
  def default_node(source, location); end

  # The default source object that gets attached to nodes and locations if no
  # source is specified.
  #
  # source://prism//lib/prism/dsl.rb#976
  sig { returns(Prism::Source) }
  def default_source; end
end

# Represents a method definition.
#
#     def method
#     end
#     ^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#5137
class Prism::DefNode < ::Prism::Node
  # Initialize a new DefNode node.
  #
  # @return [DefNode] a new instance of DefNode
  #
  # source://prism//lib/prism/node.rb#5139
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      name_loc: Prism::Location,
      receiver: T.nilable(Prism::Node),
      parameters: T.nilable(Prism::ParametersNode),
      body: T.nilable(T.any(Prism::StatementsNode, Prism::BeginNode)),
      locals: T::Array[Symbol],
      def_keyword_loc: Prism::Location,
      operator_loc: T.nilable(Prism::Location),
      lparen_loc: T.nilable(Prism::Location),
      rparen_loc: T.nilable(Prism::Location),
      equal_loc: T.nilable(Prism::Location),
      end_keyword_loc: T.nilable(Prism::Location)
    ).void
  end
  def initialize(source, node_id, location, flags, name, name_loc, receiver, parameters, body, locals, def_keyword_loc, operator_loc, lparen_loc, rparen_loc, equal_loc, end_keyword_loc); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#5336
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#5159
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # attr_reader body: StatementsNode | BeginNode | nil
  #
  # source://prism//lib/prism/node.rb#5212
  sig { returns(T.nilable(T.any(Prism::StatementsNode, Prism::BeginNode))) }
  def body; end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#5164
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#5178
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#5169
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?name: Symbol, ?name_loc: Location, ?receiver: Prism::node?, ?parameters: ParametersNode?, ?body: StatementsNode | BeginNode | nil, ?locals: Array[Symbol], ?def_keyword_loc: Location, ?operator_loc: Location?, ?lparen_loc: Location?, ?rparen_loc: Location?, ?equal_loc: Location?, ?end_keyword_loc: Location?) -> DefNode
  #
  # source://prism//lib/prism/node.rb#5183
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      name_loc: Prism::Location,
      receiver: T.nilable(Prism::Node),
      parameters: T.nilable(Prism::ParametersNode),
      body: T.nilable(T.any(Prism::StatementsNode, Prism::BeginNode)),
      locals: T::Array[Symbol],
      def_keyword_loc: Prism::Location,
      operator_loc: T.nilable(Prism::Location),
      lparen_loc: T.nilable(Prism::Location),
      rparen_loc: T.nilable(Prism::Location),
      equal_loc: T.nilable(Prism::Location),
      end_keyword_loc: T.nilable(Prism::Location)
    ).returns(Prism::DefNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil), name_loc: T.unsafe(nil), receiver: T.unsafe(nil), parameters: T.unsafe(nil), body: T.unsafe(nil), locals: T.unsafe(nil), def_keyword_loc: T.unsafe(nil), operator_loc: T.unsafe(nil), lparen_loc: T.unsafe(nil), rparen_loc: T.unsafe(nil), equal_loc: T.unsafe(nil), end_keyword_loc: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#5164
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, name: Symbol, name_loc: Location, receiver: Prism::node?, parameters: ParametersNode?, body: StatementsNode | BeginNode | nil, locals: Array[Symbol], def_keyword_loc: Location, operator_loc: Location?, lparen_loc: Location?, rparen_loc: Location?, equal_loc: Location?, end_keyword_loc: Location? }
  #
  # source://prism//lib/prism/node.rb#5191
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def def_keyword: () -> String
  #
  # source://prism//lib/prism/node.rb#5290
  sig { returns(String) }
  def def_keyword; end

  # attr_reader def_keyword_loc: Location
  #
  # source://prism//lib/prism/node.rb#5218
  sig { returns(Prism::Location) }
  def def_keyword_loc; end

  # def end_keyword: () -> String?
  #
  # source://prism//lib/prism/node.rb#5315
  sig { returns(T.nilable(String)) }
  def end_keyword; end

  # attr_reader end_keyword_loc: Location?
  #
  # source://prism//lib/prism/node.rb#5277
  sig { returns(T.nilable(Prism::Location)) }
  def end_keyword_loc; end

  # def equal: () -> String?
  #
  # source://prism//lib/prism/node.rb#5310
  sig { returns(T.nilable(String)) }
  def equal; end

  # attr_reader equal_loc: Location?
  #
  # source://prism//lib/prism/node.rb#5264
  sig { returns(T.nilable(Prism::Location)) }
  def equal_loc; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#5320
  sig { override.returns(String) }
  def inspect; end

  # attr_reader locals: Array[Symbol]
  #
  # source://prism//lib/prism/node.rb#5215
  sig { returns(T::Array[Symbol]) }
  def locals; end

  # def lparen: () -> String?
  #
  # source://prism//lib/prism/node.rb#5300
  sig { returns(T.nilable(String)) }
  def lparen; end

  # attr_reader lparen_loc: Location?
  #
  # source://prism//lib/prism/node.rb#5238
  sig { returns(T.nilable(Prism::Location)) }
  def lparen_loc; end

  # attr_reader name: Symbol
  #
  # source://prism//lib/prism/node.rb#5196
  sig { returns(Symbol) }
  def name; end

  # attr_reader name_loc: Location
  #
  # source://prism//lib/prism/node.rb#5199
  sig { returns(Prism::Location) }
  def name_loc; end

  # def operator: () -> String?
  #
  # source://prism//lib/prism/node.rb#5295
  sig { returns(T.nilable(String)) }
  def operator; end

  # attr_reader operator_loc: Location?
  #
  # source://prism//lib/prism/node.rb#5225
  sig { returns(T.nilable(Prism::Location)) }
  def operator_loc; end

  # attr_reader parameters: ParametersNode?
  #
  # source://prism//lib/prism/node.rb#5209
  sig { returns(T.nilable(Prism::ParametersNode)) }
  def parameters; end

  # attr_reader receiver: Prism::node?
  #
  # source://prism//lib/prism/node.rb#5206
  sig { returns(T.nilable(Prism::Node)) }
  def receiver; end

  # def rparen: () -> String?
  #
  # source://prism//lib/prism/node.rb#5305
  sig { returns(T.nilable(String)) }
  def rparen; end

  # attr_reader rparen_loc: Location?
  #
  # source://prism//lib/prism/node.rb#5251
  sig { returns(T.nilable(Prism::Location)) }
  def rparen_loc; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#5325
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#5330
    def type; end
  end
end

# Represents the use of the `defined?` keyword.
#
#     defined?(a)
#     ^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#5358
class Prism::DefinedNode < ::Prism::Node
  # Initialize a new DefinedNode node.
  #
  # @return [DefinedNode] a new instance of DefinedNode
  #
  # source://prism//lib/prism/node.rb#5360
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      lparen_loc: T.nilable(Prism::Location),
      value: Prism::Node,
      rparen_loc: T.nilable(Prism::Location),
      keyword_loc: Prism::Location
    ).void
  end
  def initialize(source, node_id, location, flags, lparen_loc, value, rparen_loc, keyword_loc); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#5472
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#5372
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#5377
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#5387
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#5382
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?lparen_loc: Location?, ?value: Prism::node, ?rparen_loc: Location?, ?keyword_loc: Location) -> DefinedNode
  #
  # source://prism//lib/prism/node.rb#5392
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      lparen_loc: T.nilable(Prism::Location),
      value: Prism::Node,
      rparen_loc: T.nilable(Prism::Location),
      keyword_loc: Prism::Location
    ).returns(Prism::DefinedNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), lparen_loc: T.unsafe(nil), value: T.unsafe(nil), rparen_loc: T.unsafe(nil), keyword_loc: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#5377
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, lparen_loc: Location?, value: Prism::node, rparen_loc: Location?, keyword_loc: Location }
  #
  # source://prism//lib/prism/node.rb#5400
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#5456
  sig { override.returns(String) }
  def inspect; end

  # def keyword: () -> String
  #
  # source://prism//lib/prism/node.rb#5451
  sig { returns(String) }
  def keyword; end

  # attr_reader keyword_loc: Location
  #
  # source://prism//lib/prism/node.rb#5434
  sig { returns(Prism::Location) }
  def keyword_loc; end

  # def lparen: () -> String?
  #
  # source://prism//lib/prism/node.rb#5441
  sig { returns(T.nilable(String)) }
  def lparen; end

  # attr_reader lparen_loc: Location?
  #
  # source://prism//lib/prism/node.rb#5405
  sig { returns(T.nilable(Prism::Location)) }
  def lparen_loc; end

  # def rparen: () -> String?
  #
  # source://prism//lib/prism/node.rb#5446
  sig { returns(T.nilable(String)) }
  def rparen; end

  # attr_reader rparen_loc: Location?
  #
  # source://prism//lib/prism/node.rb#5421
  sig { returns(T.nilable(Prism::Location)) }
  def rparen_loc; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#5461
  sig { override.returns(Symbol) }
  def type; end

  # attr_reader value: Prism::node
  #
  # source://prism//lib/prism/node.rb#5418
  sig { returns(Prism::Node) }
  def value; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#5466
    def type; end
  end
end

# source://prism//lib/prism/desugar_compiler.rb#4
class Prism::DesugarAndWriteNode
  include ::Prism::DSL

  # @return [DesugarAndWriteNode] a new instance of DesugarAndWriteNode
  #
  # source://prism//lib/prism/desugar_compiler.rb#9
  def initialize(node, default_source, read_class, write_class, **arguments); end

  # Returns the value of attribute arguments.
  #
  # source://prism//lib/prism/desugar_compiler.rb#7
  def arguments; end

  # Desugar `x &&= y` to `x && x = y`
  #
  # source://prism//lib/prism/desugar_compiler.rb#18
  def compile; end

  # Returns the value of attribute default_source.
  #
  # source://prism//lib/prism/desugar_compiler.rb#7
  def default_source; end

  # Returns the value of attribute node.
  #
  # source://prism//lib/prism/desugar_compiler.rb#7
  def node; end

  # Returns the value of attribute read_class.
  #
  # source://prism//lib/prism/desugar_compiler.rb#7
  def read_class; end

  # Returns the value of attribute write_class.
  #
  # source://prism//lib/prism/desugar_compiler.rb#7
  def write_class; end
end

# DesugarCompiler is a compiler that desugars Ruby code into a more primitive
# form. This is useful for consumers that want to deal with fewer node types.
#
# source://prism//lib/prism/desugar_compiler.rb#255
class Prism::DesugarCompiler < ::Prism::MutationCompiler
  # @@foo &&= bar
  #
  # becomes
  #
  # @@foo && @@foo = bar
  #
  # source://prism//lib/prism/desugar_compiler.rb#261
  def visit_class_variable_and_write_node(node); end

  # @@foo += bar
  #
  # becomes
  #
  # @@foo = @@foo + bar
  #
  # source://prism//lib/prism/desugar_compiler.rb#279
  def visit_class_variable_operator_write_node(node); end

  # @@foo ||= bar
  #
  # becomes
  #
  # defined?(@@foo) ? @@foo : @@foo = bar
  #
  # source://prism//lib/prism/desugar_compiler.rb#270
  def visit_class_variable_or_write_node(node); end

  # Foo &&= bar
  #
  # becomes
  #
  # Foo && Foo = bar
  #
  # source://prism//lib/prism/desugar_compiler.rb#288
  def visit_constant_and_write_node(node); end

  # Foo += bar
  #
  # becomes
  #
  # Foo = Foo + bar
  #
  # source://prism//lib/prism/desugar_compiler.rb#306
  def visit_constant_operator_write_node(node); end

  # Foo ||= bar
  #
  # becomes
  #
  # defined?(Foo) ? Foo : Foo = bar
  #
  # source://prism//lib/prism/desugar_compiler.rb#297
  def visit_constant_or_write_node(node); end

  # $foo &&= bar
  #
  # becomes
  #
  # $foo && $foo = bar
  #
  # source://prism//lib/prism/desugar_compiler.rb#315
  def visit_global_variable_and_write_node(node); end

  # $foo += bar
  #
  # becomes
  #
  # $foo = $foo + bar
  #
  # source://prism//lib/prism/desugar_compiler.rb#333
  def visit_global_variable_operator_write_node(node); end

  # $foo ||= bar
  #
  # becomes
  #
  # defined?($foo) ? $foo : $foo = bar
  #
  # source://prism//lib/prism/desugar_compiler.rb#324
  def visit_global_variable_or_write_node(node); end

  # becomes
  #
  # source://prism//lib/prism/desugar_compiler.rb#342
  def visit_instance_variable_and_write_node(node); end

  # becomes
  #
  # source://prism//lib/prism/desugar_compiler.rb#360
  def visit_instance_variable_operator_write_node(node); end

  # becomes
  #
  # source://prism//lib/prism/desugar_compiler.rb#351
  def visit_instance_variable_or_write_node(node); end

  # foo &&= bar
  #
  # becomes
  #
  # foo && foo = bar
  #
  # source://prism//lib/prism/desugar_compiler.rb#369
  def visit_local_variable_and_write_node(node); end

  # foo += bar
  #
  # becomes
  #
  # foo = foo + bar
  #
  # source://prism//lib/prism/desugar_compiler.rb#387
  def visit_local_variable_operator_write_node(node); end

  # foo ||= bar
  #
  # becomes
  #
  # foo || foo = bar
  #
  # source://prism//lib/prism/desugar_compiler.rb#378
  def visit_local_variable_or_write_node(node); end
end

# source://prism//lib/prism/desugar_compiler.rb#86
class Prism::DesugarOperatorWriteNode
  include ::Prism::DSL

  # @return [DesugarOperatorWriteNode] a new instance of DesugarOperatorWriteNode
  #
  # source://prism//lib/prism/desugar_compiler.rb#91
  def initialize(node, default_source, read_class, write_class, **arguments); end

  # Returns the value of attribute arguments.
  #
  # source://prism//lib/prism/desugar_compiler.rb#89
  def arguments; end

  # Desugar `x += y` to `x = x + y`
  #
  # source://prism//lib/prism/desugar_compiler.rb#100
  def compile; end

  # Returns the value of attribute default_source.
  #
  # source://prism//lib/prism/desugar_compiler.rb#89
  def default_source; end

  # Returns the value of attribute node.
  #
  # source://prism//lib/prism/desugar_compiler.rb#89
  def node; end

  # Returns the value of attribute read_class.
  #
  # source://prism//lib/prism/desugar_compiler.rb#89
  def read_class; end

  # Returns the value of attribute write_class.
  #
  # source://prism//lib/prism/desugar_compiler.rb#89
  def write_class; end
end

# source://prism//lib/prism/desugar_compiler.rb#35
class Prism::DesugarOrWriteDefinedNode
  include ::Prism::DSL

  # @return [DesugarOrWriteDefinedNode] a new instance of DesugarOrWriteDefinedNode
  #
  # source://prism//lib/prism/desugar_compiler.rb#40
  def initialize(node, default_source, read_class, write_class, **arguments); end

  # Returns the value of attribute arguments.
  #
  # source://prism//lib/prism/desugar_compiler.rb#38
  def arguments; end

  # Desugar `x ||= y` to `defined?(x) ? x : x = y`
  #
  # source://prism//lib/prism/desugar_compiler.rb#49
  def compile; end

  # Returns the value of attribute default_source.
  #
  # source://prism//lib/prism/desugar_compiler.rb#38
  def default_source; end

  # Returns the value of attribute node.
  #
  # source://prism//lib/prism/desugar_compiler.rb#38
  def node; end

  # Returns the value of attribute read_class.
  #
  # source://prism//lib/prism/desugar_compiler.rb#38
  def read_class; end

  # Returns the value of attribute write_class.
  #
  # source://prism//lib/prism/desugar_compiler.rb#38
  def write_class; end
end

# source://prism//lib/prism/desugar_compiler.rb#130
class Prism::DesugarOrWriteNode
  include ::Prism::DSL

  # @return [DesugarOrWriteNode] a new instance of DesugarOrWriteNode
  #
  # source://prism//lib/prism/desugar_compiler.rb#135
  def initialize(node, default_source, read_class, write_class, **arguments); end

  # Returns the value of attribute arguments.
  #
  # source://prism//lib/prism/desugar_compiler.rb#133
  def arguments; end

  # Desugar `x ||= y` to `x || x = y`
  #
  # source://prism//lib/prism/desugar_compiler.rb#144
  def compile; end

  # Returns the value of attribute default_source.
  #
  # source://prism//lib/prism/desugar_compiler.rb#133
  def default_source; end

  # Returns the value of attribute node.
  #
  # source://prism//lib/prism/desugar_compiler.rb#133
  def node; end

  # Returns the value of attribute read_class.
  #
  # source://prism//lib/prism/desugar_compiler.rb#133
  def read_class; end

  # Returns the value of attribute write_class.
  #
  # source://prism//lib/prism/desugar_compiler.rb#133
  def write_class; end
end

# The dispatcher class fires events for nodes that are found while walking an
# AST to all registered listeners. It's useful for performing different types
# of analysis on the AST while only having to walk the tree once.
#
# To use the dispatcher, you would first instantiate it and register listeners
# for the events you're interested in:
#
#     class OctalListener
#       def on_integer_node_enter(node)
#         if node.octal? && !node.slice.start_with?("0o")
#           warn("Octal integers should be written with the 0o prefix")
#         end
#       end
#     end
#
#     listener = OctalListener.new
#     dispatcher = Prism::Dispatcher.new
#     dispatcher.register(listener, :on_integer_node_enter)
#
# Then, you can walk any number of trees and dispatch events to the listeners:
#
#     result = Prism.parse("001 + 002 + 003")
#     dispatcher.dispatch(result.value)
#
# Optionally, you can also use `#dispatch_once` to dispatch enter and leave
# events for a single node without recursing further down the tree. This can
# be useful in circumstances where you want to reuse the listeners you already
# have registers but want to stop walking the tree at a certain point.
#
#     integer = result.value.statements.body.first.receiver.receiver
#     dispatcher.dispatch_once(integer)
#
# source://prism//lib/prism/dispatcher.rb#42
class Prism::Dispatcher < ::Prism::Visitor
  # Initialize a new dispatcher.
  #
  # @return [Dispatcher] a new instance of Dispatcher
  #
  # source://prism//lib/prism/dispatcher.rb#47
  def initialize; end

  # Walks `root` dispatching events to all registered listeners.
  #
  # def dispatch: (Node) -> void
  #
  # source://prism//lib/prism/visitor.rb#17
  def dispatch(node); end

  # Dispatches a single event for `node` to all registered listeners.
  #
  # def dispatch_once: (Node) -> void
  #
  # source://prism//lib/prism/dispatcher.rb#66
  def dispatch_once(node); end

  # attr_reader listeners: Hash[Symbol, Array[Listener]]
  #
  # source://prism//lib/prism/dispatcher.rb#44
  def listeners; end

  # Register a listener for one or more events.
  #
  # def register: (Listener, *Symbol) -> void
  #
  # source://prism//lib/prism/dispatcher.rb#54
  def register(listener, *events); end

  # Dispatch enter and leave events for AliasGlobalVariableNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#72
  def visit_alias_global_variable_node(node); end

  # Dispatch enter and leave events for AliasMethodNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#80
  def visit_alias_method_node(node); end

  # Dispatch enter and leave events for AlternationPatternNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#88
  def visit_alternation_pattern_node(node); end

  # Dispatch enter and leave events for AndNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#96
  def visit_and_node(node); end

  # Dispatch enter and leave events for ArgumentsNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#104
  def visit_arguments_node(node); end

  # Dispatch enter and leave events for ArrayNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#112
  def visit_array_node(node); end

  # Dispatch enter and leave events for ArrayPatternNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#120
  def visit_array_pattern_node(node); end

  # Dispatch enter and leave events for AssocNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#128
  def visit_assoc_node(node); end

  # Dispatch enter and leave events for AssocSplatNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#136
  def visit_assoc_splat_node(node); end

  # Dispatch enter and leave events for BackReferenceReadNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#144
  def visit_back_reference_read_node(node); end

  # Dispatch enter and leave events for BeginNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#152
  def visit_begin_node(node); end

  # Dispatch enter and leave events for BlockArgumentNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#160
  def visit_block_argument_node(node); end

  # Dispatch enter and leave events for BlockLocalVariableNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#168
  def visit_block_local_variable_node(node); end

  # Dispatch enter and leave events for BlockNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#176
  def visit_block_node(node); end

  # Dispatch enter and leave events for BlockParameterNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#184
  def visit_block_parameter_node(node); end

  # Dispatch enter and leave events for BlockParametersNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#192
  def visit_block_parameters_node(node); end

  # Dispatch enter and leave events for BreakNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#200
  def visit_break_node(node); end

  # Dispatch enter and leave events for CallAndWriteNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#208
  def visit_call_and_write_node(node); end

  # Dispatch enter and leave events for CallNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#216
  def visit_call_node(node); end

  # Dispatch enter and leave events for CallOperatorWriteNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#224
  def visit_call_operator_write_node(node); end

  # Dispatch enter and leave events for CallOrWriteNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#232
  def visit_call_or_write_node(node); end

  # Dispatch enter and leave events for CallTargetNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#240
  def visit_call_target_node(node); end

  # Dispatch enter and leave events for CapturePatternNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#248
  def visit_capture_pattern_node(node); end

  # Dispatch enter and leave events for CaseMatchNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#256
  def visit_case_match_node(node); end

  # Dispatch enter and leave events for CaseNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#264
  def visit_case_node(node); end

  # Dispatch enter and leave events for ClassNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#272
  def visit_class_node(node); end

  # Dispatch enter and leave events for ClassVariableAndWriteNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#280
  def visit_class_variable_and_write_node(node); end

  # Dispatch enter and leave events for ClassVariableOperatorWriteNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#288
  def visit_class_variable_operator_write_node(node); end

  # Dispatch enter and leave events for ClassVariableOrWriteNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#296
  def visit_class_variable_or_write_node(node); end

  # Dispatch enter and leave events for ClassVariableReadNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#304
  def visit_class_variable_read_node(node); end

  # Dispatch enter and leave events for ClassVariableTargetNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#312
  def visit_class_variable_target_node(node); end

  # Dispatch enter and leave events for ClassVariableWriteNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#320
  def visit_class_variable_write_node(node); end

  # Dispatch enter and leave events for ConstantAndWriteNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#328
  def visit_constant_and_write_node(node); end

  # Dispatch enter and leave events for ConstantOperatorWriteNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#336
  def visit_constant_operator_write_node(node); end

  # Dispatch enter and leave events for ConstantOrWriteNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#344
  def visit_constant_or_write_node(node); end

  # Dispatch enter and leave events for ConstantPathAndWriteNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#352
  def visit_constant_path_and_write_node(node); end

  # Dispatch enter and leave events for ConstantPathNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#360
  def visit_constant_path_node(node); end

  # Dispatch enter and leave events for ConstantPathOperatorWriteNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#368
  def visit_constant_path_operator_write_node(node); end

  # Dispatch enter and leave events for ConstantPathOrWriteNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#376
  def visit_constant_path_or_write_node(node); end

  # Dispatch enter and leave events for ConstantPathTargetNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#384
  def visit_constant_path_target_node(node); end

  # Dispatch enter and leave events for ConstantPathWriteNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#392
  def visit_constant_path_write_node(node); end

  # Dispatch enter and leave events for ConstantReadNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#400
  def visit_constant_read_node(node); end

  # Dispatch enter and leave events for ConstantTargetNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#408
  def visit_constant_target_node(node); end

  # Dispatch enter and leave events for ConstantWriteNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#416
  def visit_constant_write_node(node); end

  # Dispatch enter and leave events for DefNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#424
  def visit_def_node(node); end

  # Dispatch enter and leave events for DefinedNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#432
  def visit_defined_node(node); end

  # Dispatch enter and leave events for ElseNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#440
  def visit_else_node(node); end

  # Dispatch enter and leave events for EmbeddedStatementsNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#448
  def visit_embedded_statements_node(node); end

  # Dispatch enter and leave events for EmbeddedVariableNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#456
  def visit_embedded_variable_node(node); end

  # Dispatch enter and leave events for EnsureNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#464
  def visit_ensure_node(node); end

  # Dispatch enter and leave events for FalseNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#472
  def visit_false_node(node); end

  # Dispatch enter and leave events for FindPatternNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#480
  def visit_find_pattern_node(node); end

  # Dispatch enter and leave events for FlipFlopNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#488
  def visit_flip_flop_node(node); end

  # Dispatch enter and leave events for FloatNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#496
  def visit_float_node(node); end

  # Dispatch enter and leave events for ForNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#504
  def visit_for_node(node); end

  # Dispatch enter and leave events for ForwardingArgumentsNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#512
  def visit_forwarding_arguments_node(node); end

  # Dispatch enter and leave events for ForwardingParameterNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#520
  def visit_forwarding_parameter_node(node); end

  # Dispatch enter and leave events for ForwardingSuperNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#528
  def visit_forwarding_super_node(node); end

  # Dispatch enter and leave events for GlobalVariableAndWriteNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#536
  def visit_global_variable_and_write_node(node); end

  # Dispatch enter and leave events for GlobalVariableOperatorWriteNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#544
  def visit_global_variable_operator_write_node(node); end

  # Dispatch enter and leave events for GlobalVariableOrWriteNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#552
  def visit_global_variable_or_write_node(node); end

  # Dispatch enter and leave events for GlobalVariableReadNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#560
  def visit_global_variable_read_node(node); end

  # Dispatch enter and leave events for GlobalVariableTargetNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#568
  def visit_global_variable_target_node(node); end

  # Dispatch enter and leave events for GlobalVariableWriteNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#576
  def visit_global_variable_write_node(node); end

  # Dispatch enter and leave events for HashNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#584
  def visit_hash_node(node); end

  # Dispatch enter and leave events for HashPatternNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#592
  def visit_hash_pattern_node(node); end

  # Dispatch enter and leave events for IfNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#600
  def visit_if_node(node); end

  # Dispatch enter and leave events for ImaginaryNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#608
  def visit_imaginary_node(node); end

  # Dispatch enter and leave events for ImplicitNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#616
  def visit_implicit_node(node); end

  # Dispatch enter and leave events for ImplicitRestNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#624
  def visit_implicit_rest_node(node); end

  # Dispatch enter and leave events for InNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#632
  def visit_in_node(node); end

  # Dispatch enter and leave events for IndexAndWriteNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#640
  def visit_index_and_write_node(node); end

  # Dispatch enter and leave events for IndexOperatorWriteNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#648
  def visit_index_operator_write_node(node); end

  # Dispatch enter and leave events for IndexOrWriteNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#656
  def visit_index_or_write_node(node); end

  # Dispatch enter and leave events for IndexTargetNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#664
  def visit_index_target_node(node); end

  # Dispatch enter and leave events for InstanceVariableAndWriteNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#672
  def visit_instance_variable_and_write_node(node); end

  # Dispatch enter and leave events for InstanceVariableOperatorWriteNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#680
  def visit_instance_variable_operator_write_node(node); end

  # Dispatch enter and leave events for InstanceVariableOrWriteNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#688
  def visit_instance_variable_or_write_node(node); end

  # Dispatch enter and leave events for InstanceVariableReadNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#696
  def visit_instance_variable_read_node(node); end

  # Dispatch enter and leave events for InstanceVariableTargetNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#704
  def visit_instance_variable_target_node(node); end

  # Dispatch enter and leave events for InstanceVariableWriteNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#712
  def visit_instance_variable_write_node(node); end

  # Dispatch enter and leave events for IntegerNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#720
  def visit_integer_node(node); end

  # Dispatch enter and leave events for InterpolatedMatchLastLineNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#728
  def visit_interpolated_match_last_line_node(node); end

  # Dispatch enter and leave events for InterpolatedRegularExpressionNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#736
  def visit_interpolated_regular_expression_node(node); end

  # Dispatch enter and leave events for InterpolatedStringNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#744
  def visit_interpolated_string_node(node); end

  # Dispatch enter and leave events for InterpolatedSymbolNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#752
  def visit_interpolated_symbol_node(node); end

  # Dispatch enter and leave events for InterpolatedXStringNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#760
  def visit_interpolated_x_string_node(node); end

  # Dispatch enter and leave events for ItLocalVariableReadNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#768
  def visit_it_local_variable_read_node(node); end

  # Dispatch enter and leave events for ItParametersNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#776
  def visit_it_parameters_node(node); end

  # Dispatch enter and leave events for KeywordHashNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#784
  def visit_keyword_hash_node(node); end

  # Dispatch enter and leave events for KeywordRestParameterNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#792
  def visit_keyword_rest_parameter_node(node); end

  # Dispatch enter and leave events for LambdaNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#800
  def visit_lambda_node(node); end

  # Dispatch enter and leave events for LocalVariableAndWriteNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#808
  def visit_local_variable_and_write_node(node); end

  # Dispatch enter and leave events for LocalVariableOperatorWriteNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#816
  def visit_local_variable_operator_write_node(node); end

  # Dispatch enter and leave events for LocalVariableOrWriteNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#824
  def visit_local_variable_or_write_node(node); end

  # Dispatch enter and leave events for LocalVariableReadNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#832
  def visit_local_variable_read_node(node); end

  # Dispatch enter and leave events for LocalVariableTargetNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#840
  def visit_local_variable_target_node(node); end

  # Dispatch enter and leave events for LocalVariableWriteNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#848
  def visit_local_variable_write_node(node); end

  # Dispatch enter and leave events for MatchLastLineNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#856
  def visit_match_last_line_node(node); end

  # Dispatch enter and leave events for MatchPredicateNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#864
  def visit_match_predicate_node(node); end

  # Dispatch enter and leave events for MatchRequiredNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#872
  def visit_match_required_node(node); end

  # Dispatch enter and leave events for MatchWriteNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#880
  def visit_match_write_node(node); end

  # Dispatch enter and leave events for MissingNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#888
  def visit_missing_node(node); end

  # Dispatch enter and leave events for ModuleNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#896
  def visit_module_node(node); end

  # Dispatch enter and leave events for MultiTargetNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#904
  def visit_multi_target_node(node); end

  # Dispatch enter and leave events for MultiWriteNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#912
  def visit_multi_write_node(node); end

  # Dispatch enter and leave events for NextNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#920
  def visit_next_node(node); end

  # Dispatch enter and leave events for NilNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#928
  def visit_nil_node(node); end

  # Dispatch enter and leave events for NoKeywordsParameterNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#936
  def visit_no_keywords_parameter_node(node); end

  # Dispatch enter and leave events for NumberedParametersNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#944
  def visit_numbered_parameters_node(node); end

  # Dispatch enter and leave events for NumberedReferenceReadNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#952
  def visit_numbered_reference_read_node(node); end

  # Dispatch enter and leave events for OptionalKeywordParameterNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#960
  def visit_optional_keyword_parameter_node(node); end

  # Dispatch enter and leave events for OptionalParameterNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#968
  def visit_optional_parameter_node(node); end

  # Dispatch enter and leave events for OrNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#976
  def visit_or_node(node); end

  # Dispatch enter and leave events for ParametersNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#984
  def visit_parameters_node(node); end

  # Dispatch enter and leave events for ParenthesesNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#992
  def visit_parentheses_node(node); end

  # Dispatch enter and leave events for PinnedExpressionNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#1000
  def visit_pinned_expression_node(node); end

  # Dispatch enter and leave events for PinnedVariableNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#1008
  def visit_pinned_variable_node(node); end

  # Dispatch enter and leave events for PostExecutionNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#1016
  def visit_post_execution_node(node); end

  # Dispatch enter and leave events for PreExecutionNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#1024
  def visit_pre_execution_node(node); end

  # Dispatch enter and leave events for ProgramNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#1032
  def visit_program_node(node); end

  # Dispatch enter and leave events for RangeNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#1040
  def visit_range_node(node); end

  # Dispatch enter and leave events for RationalNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#1048
  def visit_rational_node(node); end

  # Dispatch enter and leave events for RedoNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#1056
  def visit_redo_node(node); end

  # Dispatch enter and leave events for RegularExpressionNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#1064
  def visit_regular_expression_node(node); end

  # Dispatch enter and leave events for RequiredKeywordParameterNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#1072
  def visit_required_keyword_parameter_node(node); end

  # Dispatch enter and leave events for RequiredParameterNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#1080
  def visit_required_parameter_node(node); end

  # Dispatch enter and leave events for RescueModifierNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#1088
  def visit_rescue_modifier_node(node); end

  # Dispatch enter and leave events for RescueNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#1096
  def visit_rescue_node(node); end

  # Dispatch enter and leave events for RestParameterNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#1104
  def visit_rest_parameter_node(node); end

  # Dispatch enter and leave events for RetryNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#1112
  def visit_retry_node(node); end

  # Dispatch enter and leave events for ReturnNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#1120
  def visit_return_node(node); end

  # Dispatch enter and leave events for SelfNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#1128
  def visit_self_node(node); end

  # Dispatch enter and leave events for ShareableConstantNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#1136
  def visit_shareable_constant_node(node); end

  # Dispatch enter and leave events for SingletonClassNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#1144
  def visit_singleton_class_node(node); end

  # Dispatch enter and leave events for SourceEncodingNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#1152
  def visit_source_encoding_node(node); end

  # Dispatch enter and leave events for SourceFileNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#1160
  def visit_source_file_node(node); end

  # Dispatch enter and leave events for SourceLineNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#1168
  def visit_source_line_node(node); end

  # Dispatch enter and leave events for SplatNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#1176
  def visit_splat_node(node); end

  # Dispatch enter and leave events for StatementsNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#1184
  def visit_statements_node(node); end

  # Dispatch enter and leave events for StringNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#1192
  def visit_string_node(node); end

  # Dispatch enter and leave events for SuperNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#1200
  def visit_super_node(node); end

  # Dispatch enter and leave events for SymbolNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#1208
  def visit_symbol_node(node); end

  # Dispatch enter and leave events for TrueNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#1216
  def visit_true_node(node); end

  # Dispatch enter and leave events for UndefNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#1224
  def visit_undef_node(node); end

  # Dispatch enter and leave events for UnlessNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#1232
  def visit_unless_node(node); end

  # Dispatch enter and leave events for UntilNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#1240
  def visit_until_node(node); end

  # Dispatch enter and leave events for WhenNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#1248
  def visit_when_node(node); end

  # Dispatch enter and leave events for WhileNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#1256
  def visit_while_node(node); end

  # Dispatch enter and leave events for XStringNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#1264
  def visit_x_string_node(node); end

  # Dispatch enter and leave events for YieldNode nodes and continue
  # walking the tree.
  #
  # source://prism//lib/prism/dispatcher.rb#1272
  def visit_yield_node(node); end
end

# source://prism//lib/prism/dispatcher.rb#1278
class Prism::Dispatcher::DispatchOnce < ::Prism::Visitor
  # @return [DispatchOnce] a new instance of DispatchOnce
  #
  # source://prism//lib/prism/dispatcher.rb#1281
  def initialize(listeners); end

  # Returns the value of attribute listeners.
  #
  # source://prism//lib/prism/dispatcher.rb#1279
  def listeners; end

  # Dispatch enter and leave events for AliasGlobalVariableNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1286
  def visit_alias_global_variable_node(node); end

  # Dispatch enter and leave events for AliasMethodNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1292
  def visit_alias_method_node(node); end

  # Dispatch enter and leave events for AlternationPatternNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1298
  def visit_alternation_pattern_node(node); end

  # Dispatch enter and leave events for AndNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1304
  def visit_and_node(node); end

  # Dispatch enter and leave events for ArgumentsNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1310
  def visit_arguments_node(node); end

  # Dispatch enter and leave events for ArrayNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1316
  def visit_array_node(node); end

  # Dispatch enter and leave events for ArrayPatternNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1322
  def visit_array_pattern_node(node); end

  # Dispatch enter and leave events for AssocNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1328
  def visit_assoc_node(node); end

  # Dispatch enter and leave events for AssocSplatNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1334
  def visit_assoc_splat_node(node); end

  # Dispatch enter and leave events for BackReferenceReadNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1340
  def visit_back_reference_read_node(node); end

  # Dispatch enter and leave events for BeginNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1346
  def visit_begin_node(node); end

  # Dispatch enter and leave events for BlockArgumentNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1352
  def visit_block_argument_node(node); end

  # Dispatch enter and leave events for BlockLocalVariableNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1358
  def visit_block_local_variable_node(node); end

  # Dispatch enter and leave events for BlockNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1364
  def visit_block_node(node); end

  # Dispatch enter and leave events for BlockParameterNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1370
  def visit_block_parameter_node(node); end

  # Dispatch enter and leave events for BlockParametersNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1376
  def visit_block_parameters_node(node); end

  # Dispatch enter and leave events for BreakNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1382
  def visit_break_node(node); end

  # Dispatch enter and leave events for CallAndWriteNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1388
  def visit_call_and_write_node(node); end

  # Dispatch enter and leave events for CallNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1394
  def visit_call_node(node); end

  # Dispatch enter and leave events for CallOperatorWriteNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1400
  def visit_call_operator_write_node(node); end

  # Dispatch enter and leave events for CallOrWriteNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1406
  def visit_call_or_write_node(node); end

  # Dispatch enter and leave events for CallTargetNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1412
  def visit_call_target_node(node); end

  # Dispatch enter and leave events for CapturePatternNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1418
  def visit_capture_pattern_node(node); end

  # Dispatch enter and leave events for CaseMatchNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1424
  def visit_case_match_node(node); end

  # Dispatch enter and leave events for CaseNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1430
  def visit_case_node(node); end

  # Dispatch enter and leave events for ClassNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1436
  def visit_class_node(node); end

  # Dispatch enter and leave events for ClassVariableAndWriteNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1442
  def visit_class_variable_and_write_node(node); end

  # Dispatch enter and leave events for ClassVariableOperatorWriteNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1448
  def visit_class_variable_operator_write_node(node); end

  # Dispatch enter and leave events for ClassVariableOrWriteNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1454
  def visit_class_variable_or_write_node(node); end

  # Dispatch enter and leave events for ClassVariableReadNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1460
  def visit_class_variable_read_node(node); end

  # Dispatch enter and leave events for ClassVariableTargetNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1466
  def visit_class_variable_target_node(node); end

  # Dispatch enter and leave events for ClassVariableWriteNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1472
  def visit_class_variable_write_node(node); end

  # Dispatch enter and leave events for ConstantAndWriteNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1478
  def visit_constant_and_write_node(node); end

  # Dispatch enter and leave events for ConstantOperatorWriteNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1484
  def visit_constant_operator_write_node(node); end

  # Dispatch enter and leave events for ConstantOrWriteNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1490
  def visit_constant_or_write_node(node); end

  # Dispatch enter and leave events for ConstantPathAndWriteNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1496
  def visit_constant_path_and_write_node(node); end

  # Dispatch enter and leave events for ConstantPathNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1502
  def visit_constant_path_node(node); end

  # Dispatch enter and leave events for ConstantPathOperatorWriteNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1508
  def visit_constant_path_operator_write_node(node); end

  # Dispatch enter and leave events for ConstantPathOrWriteNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1514
  def visit_constant_path_or_write_node(node); end

  # Dispatch enter and leave events for ConstantPathTargetNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1520
  def visit_constant_path_target_node(node); end

  # Dispatch enter and leave events for ConstantPathWriteNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1526
  def visit_constant_path_write_node(node); end

  # Dispatch enter and leave events for ConstantReadNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1532
  def visit_constant_read_node(node); end

  # Dispatch enter and leave events for ConstantTargetNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1538
  def visit_constant_target_node(node); end

  # Dispatch enter and leave events for ConstantWriteNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1544
  def visit_constant_write_node(node); end

  # Dispatch enter and leave events for DefNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1550
  def visit_def_node(node); end

  # Dispatch enter and leave events for DefinedNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1556
  def visit_defined_node(node); end

  # Dispatch enter and leave events for ElseNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1562
  def visit_else_node(node); end

  # Dispatch enter and leave events for EmbeddedStatementsNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1568
  def visit_embedded_statements_node(node); end

  # Dispatch enter and leave events for EmbeddedVariableNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1574
  def visit_embedded_variable_node(node); end

  # Dispatch enter and leave events for EnsureNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1580
  def visit_ensure_node(node); end

  # Dispatch enter and leave events for FalseNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1586
  def visit_false_node(node); end

  # Dispatch enter and leave events for FindPatternNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1592
  def visit_find_pattern_node(node); end

  # Dispatch enter and leave events for FlipFlopNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1598
  def visit_flip_flop_node(node); end

  # Dispatch enter and leave events for FloatNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1604
  def visit_float_node(node); end

  # Dispatch enter and leave events for ForNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1610
  def visit_for_node(node); end

  # Dispatch enter and leave events for ForwardingArgumentsNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1616
  def visit_forwarding_arguments_node(node); end

  # Dispatch enter and leave events for ForwardingParameterNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1622
  def visit_forwarding_parameter_node(node); end

  # Dispatch enter and leave events for ForwardingSuperNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1628
  def visit_forwarding_super_node(node); end

  # Dispatch enter and leave events for GlobalVariableAndWriteNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1634
  def visit_global_variable_and_write_node(node); end

  # Dispatch enter and leave events for GlobalVariableOperatorWriteNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1640
  def visit_global_variable_operator_write_node(node); end

  # Dispatch enter and leave events for GlobalVariableOrWriteNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1646
  def visit_global_variable_or_write_node(node); end

  # Dispatch enter and leave events for GlobalVariableReadNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1652
  def visit_global_variable_read_node(node); end

  # Dispatch enter and leave events for GlobalVariableTargetNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1658
  def visit_global_variable_target_node(node); end

  # Dispatch enter and leave events for GlobalVariableWriteNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1664
  def visit_global_variable_write_node(node); end

  # Dispatch enter and leave events for HashNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1670
  def visit_hash_node(node); end

  # Dispatch enter and leave events for HashPatternNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1676
  def visit_hash_pattern_node(node); end

  # Dispatch enter and leave events for IfNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1682
  def visit_if_node(node); end

  # Dispatch enter and leave events for ImaginaryNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1688
  def visit_imaginary_node(node); end

  # Dispatch enter and leave events for ImplicitNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1694
  def visit_implicit_node(node); end

  # Dispatch enter and leave events for ImplicitRestNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1700
  def visit_implicit_rest_node(node); end

  # Dispatch enter and leave events for InNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1706
  def visit_in_node(node); end

  # Dispatch enter and leave events for IndexAndWriteNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1712
  def visit_index_and_write_node(node); end

  # Dispatch enter and leave events for IndexOperatorWriteNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1718
  def visit_index_operator_write_node(node); end

  # Dispatch enter and leave events for IndexOrWriteNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1724
  def visit_index_or_write_node(node); end

  # Dispatch enter and leave events for IndexTargetNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1730
  def visit_index_target_node(node); end

  # Dispatch enter and leave events for InstanceVariableAndWriteNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1736
  def visit_instance_variable_and_write_node(node); end

  # Dispatch enter and leave events for InstanceVariableOperatorWriteNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1742
  def visit_instance_variable_operator_write_node(node); end

  # Dispatch enter and leave events for InstanceVariableOrWriteNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1748
  def visit_instance_variable_or_write_node(node); end

  # Dispatch enter and leave events for InstanceVariableReadNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1754
  def visit_instance_variable_read_node(node); end

  # Dispatch enter and leave events for InstanceVariableTargetNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1760
  def visit_instance_variable_target_node(node); end

  # Dispatch enter and leave events for InstanceVariableWriteNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1766
  def visit_instance_variable_write_node(node); end

  # Dispatch enter and leave events for IntegerNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1772
  def visit_integer_node(node); end

  # Dispatch enter and leave events for InterpolatedMatchLastLineNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1778
  def visit_interpolated_match_last_line_node(node); end

  # Dispatch enter and leave events for InterpolatedRegularExpressionNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1784
  def visit_interpolated_regular_expression_node(node); end

  # Dispatch enter and leave events for InterpolatedStringNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1790
  def visit_interpolated_string_node(node); end

  # Dispatch enter and leave events for InterpolatedSymbolNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1796
  def visit_interpolated_symbol_node(node); end

  # Dispatch enter and leave events for InterpolatedXStringNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1802
  def visit_interpolated_x_string_node(node); end

  # Dispatch enter and leave events for ItLocalVariableReadNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1808
  def visit_it_local_variable_read_node(node); end

  # Dispatch enter and leave events for ItParametersNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1814
  def visit_it_parameters_node(node); end

  # Dispatch enter and leave events for KeywordHashNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1820
  def visit_keyword_hash_node(node); end

  # Dispatch enter and leave events for KeywordRestParameterNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1826
  def visit_keyword_rest_parameter_node(node); end

  # Dispatch enter and leave events for LambdaNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1832
  def visit_lambda_node(node); end

  # Dispatch enter and leave events for LocalVariableAndWriteNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1838
  def visit_local_variable_and_write_node(node); end

  # Dispatch enter and leave events for LocalVariableOperatorWriteNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1844
  def visit_local_variable_operator_write_node(node); end

  # Dispatch enter and leave events for LocalVariableOrWriteNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1850
  def visit_local_variable_or_write_node(node); end

  # Dispatch enter and leave events for LocalVariableReadNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1856
  def visit_local_variable_read_node(node); end

  # Dispatch enter and leave events for LocalVariableTargetNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1862
  def visit_local_variable_target_node(node); end

  # Dispatch enter and leave events for LocalVariableWriteNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1868
  def visit_local_variable_write_node(node); end

  # Dispatch enter and leave events for MatchLastLineNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1874
  def visit_match_last_line_node(node); end

  # Dispatch enter and leave events for MatchPredicateNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1880
  def visit_match_predicate_node(node); end

  # Dispatch enter and leave events for MatchRequiredNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1886
  def visit_match_required_node(node); end

  # Dispatch enter and leave events for MatchWriteNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1892
  def visit_match_write_node(node); end

  # Dispatch enter and leave events for MissingNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1898
  def visit_missing_node(node); end

  # Dispatch enter and leave events for ModuleNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1904
  def visit_module_node(node); end

  # Dispatch enter and leave events for MultiTargetNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1910
  def visit_multi_target_node(node); end

  # Dispatch enter and leave events for MultiWriteNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1916
  def visit_multi_write_node(node); end

  # Dispatch enter and leave events for NextNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1922
  def visit_next_node(node); end

  # Dispatch enter and leave events for NilNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1928
  def visit_nil_node(node); end

  # Dispatch enter and leave events for NoKeywordsParameterNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1934
  def visit_no_keywords_parameter_node(node); end

  # Dispatch enter and leave events for NumberedParametersNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1940
  def visit_numbered_parameters_node(node); end

  # Dispatch enter and leave events for NumberedReferenceReadNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1946
  def visit_numbered_reference_read_node(node); end

  # Dispatch enter and leave events for OptionalKeywordParameterNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1952
  def visit_optional_keyword_parameter_node(node); end

  # Dispatch enter and leave events for OptionalParameterNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1958
  def visit_optional_parameter_node(node); end

  # Dispatch enter and leave events for OrNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1964
  def visit_or_node(node); end

  # Dispatch enter and leave events for ParametersNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1970
  def visit_parameters_node(node); end

  # Dispatch enter and leave events for ParenthesesNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1976
  def visit_parentheses_node(node); end

  # Dispatch enter and leave events for PinnedExpressionNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1982
  def visit_pinned_expression_node(node); end

  # Dispatch enter and leave events for PinnedVariableNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1988
  def visit_pinned_variable_node(node); end

  # Dispatch enter and leave events for PostExecutionNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#1994
  def visit_post_execution_node(node); end

  # Dispatch enter and leave events for PreExecutionNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#2000
  def visit_pre_execution_node(node); end

  # Dispatch enter and leave events for ProgramNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#2006
  def visit_program_node(node); end

  # Dispatch enter and leave events for RangeNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#2012
  def visit_range_node(node); end

  # Dispatch enter and leave events for RationalNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#2018
  def visit_rational_node(node); end

  # Dispatch enter and leave events for RedoNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#2024
  def visit_redo_node(node); end

  # Dispatch enter and leave events for RegularExpressionNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#2030
  def visit_regular_expression_node(node); end

  # Dispatch enter and leave events for RequiredKeywordParameterNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#2036
  def visit_required_keyword_parameter_node(node); end

  # Dispatch enter and leave events for RequiredParameterNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#2042
  def visit_required_parameter_node(node); end

  # Dispatch enter and leave events for RescueModifierNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#2048
  def visit_rescue_modifier_node(node); end

  # Dispatch enter and leave events for RescueNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#2054
  def visit_rescue_node(node); end

  # Dispatch enter and leave events for RestParameterNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#2060
  def visit_rest_parameter_node(node); end

  # Dispatch enter and leave events for RetryNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#2066
  def visit_retry_node(node); end

  # Dispatch enter and leave events for ReturnNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#2072
  def visit_return_node(node); end

  # Dispatch enter and leave events for SelfNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#2078
  def visit_self_node(node); end

  # Dispatch enter and leave events for ShareableConstantNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#2084
  def visit_shareable_constant_node(node); end

  # Dispatch enter and leave events for SingletonClassNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#2090
  def visit_singleton_class_node(node); end

  # Dispatch enter and leave events for SourceEncodingNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#2096
  def visit_source_encoding_node(node); end

  # Dispatch enter and leave events for SourceFileNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#2102
  def visit_source_file_node(node); end

  # Dispatch enter and leave events for SourceLineNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#2108
  def visit_source_line_node(node); end

  # Dispatch enter and leave events for SplatNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#2114
  def visit_splat_node(node); end

  # Dispatch enter and leave events for StatementsNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#2120
  def visit_statements_node(node); end

  # Dispatch enter and leave events for StringNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#2126
  def visit_string_node(node); end

  # Dispatch enter and leave events for SuperNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#2132
  def visit_super_node(node); end

  # Dispatch enter and leave events for SymbolNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#2138
  def visit_symbol_node(node); end

  # Dispatch enter and leave events for TrueNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#2144
  def visit_true_node(node); end

  # Dispatch enter and leave events for UndefNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#2150
  def visit_undef_node(node); end

  # Dispatch enter and leave events for UnlessNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#2156
  def visit_unless_node(node); end

  # Dispatch enter and leave events for UntilNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#2162
  def visit_until_node(node); end

  # Dispatch enter and leave events for WhenNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#2168
  def visit_when_node(node); end

  # Dispatch enter and leave events for WhileNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#2174
  def visit_while_node(node); end

  # Dispatch enter and leave events for XStringNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#2180
  def visit_x_string_node(node); end

  # Dispatch enter and leave events for YieldNode nodes.
  #
  # source://prism//lib/prism/dispatcher.rb#2186
  def visit_yield_node(node); end
end

# This visitor provides the ability to call Node#to_dot, which converts a
# subtree into a graphviz dot graph.
#
# source://prism//lib/prism/dot_visitor.rb#14
class Prism::DotVisitor < ::Prism::Visitor
  # Initialize a new dot visitor.
  #
  # @return [DotVisitor] a new instance of DotVisitor
  #
  # source://prism//lib/prism/dot_visitor.rb#106
  def initialize; end

  # The digraph that is being built.
  #
  # source://prism//lib/prism/dot_visitor.rb#103
  def digraph; end

  # Convert this visitor into a graphviz dot graph string.
  #
  # source://prism//lib/prism/dot_visitor.rb#111
  def to_dot; end

  # Visit a AliasGlobalVariableNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#116
  def visit_alias_global_variable_node(node); end

  # Visit a AliasMethodNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#141
  def visit_alias_method_node(node); end

  # Visit a AlternationPatternNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#166
  def visit_alternation_pattern_node(node); end

  # Visit a AndNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#191
  def visit_and_node(node); end

  # Visit a ArgumentsNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#216
  def visit_arguments_node(node); end

  # Visit a ArrayNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#246
  def visit_array_node(node); end

  # Visit a ArrayPatternNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#286
  def visit_array_pattern_node(node); end

  # Visit a AssocNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#348
  def visit_assoc_node(node); end

  # Visit a AssocSplatNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#375
  def visit_assoc_splat_node(node); end

  # Visit a BackReferenceReadNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#398
  def visit_back_reference_read_node(node); end

  # Visit a BeginNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#415
  def visit_begin_node(node); end

  # Visit a BlockArgumentNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#463
  def visit_block_argument_node(node); end

  # Visit a BlockLocalVariableNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#486
  def visit_block_local_variable_node(node); end

  # Visit a BlockNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#506
  def visit_block_node(node); end

  # Visit a BlockParameterNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#541
  def visit_block_parameter_node(node); end

  # Visit a BlockParametersNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#569
  def visit_block_parameters_node(node); end

  # Visit a BreakNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#612
  def visit_break_node(node); end

  # Visit a CallAndWriteNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#635
  def visit_call_and_write_node(node); end

  # Visit a CallNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#681
  def visit_call_node(node); end

  # Visit a CallOperatorWriteNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#739
  def visit_call_operator_write_node(node); end

  # Visit a CallOrWriteNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#788
  def visit_call_or_write_node(node); end

  # Visit a CallTargetNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#834
  def visit_call_target_node(node); end

  # Visit a CapturePatternNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#864
  def visit_capture_pattern_node(node); end

  # Visit a CaseMatchNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#889
  def visit_case_match_node(node); end

  # Visit a CaseNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#934
  def visit_case_node(node); end

  # Visit a ClassNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#979
  def visit_class_node(node); end

  # Visit a ClassVariableAndWriteNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#1026
  def visit_class_variable_and_write_node(node); end

  # Visit a ClassVariableOperatorWriteNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#1053
  def visit_class_variable_operator_write_node(node); end

  # Visit a ClassVariableOrWriteNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#1083
  def visit_class_variable_or_write_node(node); end

  # Visit a ClassVariableReadNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#1110
  def visit_class_variable_read_node(node); end

  # Visit a ClassVariableTargetNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#1127
  def visit_class_variable_target_node(node); end

  # Visit a ClassVariableWriteNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#1144
  def visit_class_variable_write_node(node); end

  # Visit a ConstantAndWriteNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#1171
  def visit_constant_and_write_node(node); end

  # Visit a ConstantOperatorWriteNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#1198
  def visit_constant_operator_write_node(node); end

  # Visit a ConstantOrWriteNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#1228
  def visit_constant_or_write_node(node); end

  # Visit a ConstantPathAndWriteNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#1255
  def visit_constant_path_and_write_node(node); end

  # Visit a ConstantPathNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#1280
  def visit_constant_path_node(node); end

  # Visit a ConstantPathOperatorWriteNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#1309
  def visit_constant_path_operator_write_node(node); end

  # Visit a ConstantPathOrWriteNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#1337
  def visit_constant_path_or_write_node(node); end

  # Visit a ConstantPathTargetNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#1362
  def visit_constant_path_target_node(node); end

  # Visit a ConstantPathWriteNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#1391
  def visit_constant_path_write_node(node); end

  # Visit a ConstantReadNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#1416
  def visit_constant_read_node(node); end

  # Visit a ConstantTargetNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#1433
  def visit_constant_target_node(node); end

  # Visit a ConstantWriteNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#1450
  def visit_constant_write_node(node); end

  # Visit a DefNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#1477
  def visit_def_node(node); end

  # Visit a DefinedNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#1546
  def visit_defined_node(node); end

  # Visit a ElseNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#1577
  def visit_else_node(node); end

  # Visit a EmbeddedStatementsNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#1605
  def visit_embedded_statements_node(node); end

  # Visit a EmbeddedVariableNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#1631
  def visit_embedded_variable_node(node); end

  # Visit a EnsureNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#1652
  def visit_ensure_node(node); end

  # Visit a FalseNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#1678
  def visit_false_node(node); end

  # Visit a FindPatternNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#1692
  def visit_find_pattern_node(node); end

  # Visit a FlipFlopNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#1743
  def visit_flip_flop_node(node); end

  # Visit a FloatNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#1775
  def visit_float_node(node); end

  # Visit a ForNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#1792
  def visit_for_node(node); end

  # Visit a ForwardingArgumentsNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#1834
  def visit_forwarding_arguments_node(node); end

  # Visit a ForwardingParameterNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#1848
  def visit_forwarding_parameter_node(node); end

  # Visit a ForwardingSuperNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#1862
  def visit_forwarding_super_node(node); end

  # Visit a GlobalVariableAndWriteNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#1882
  def visit_global_variable_and_write_node(node); end

  # Visit a GlobalVariableOperatorWriteNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#1909
  def visit_global_variable_operator_write_node(node); end

  # Visit a GlobalVariableOrWriteNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#1939
  def visit_global_variable_or_write_node(node); end

  # Visit a GlobalVariableReadNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#1966
  def visit_global_variable_read_node(node); end

  # Visit a GlobalVariableTargetNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#1983
  def visit_global_variable_target_node(node); end

  # Visit a GlobalVariableWriteNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#2000
  def visit_global_variable_write_node(node); end

  # Visit a HashNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#2027
  def visit_hash_node(node); end

  # Visit a HashPatternNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#2060
  def visit_hash_pattern_node(node); end

  # Visit a IfNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#2109
  def visit_if_node(node); end

  # Visit a ImaginaryNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#2154
  def visit_imaginary_node(node); end

  # Visit a ImplicitNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#2172
  def visit_implicit_node(node); end

  # Visit a ImplicitRestNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#2190
  def visit_implicit_rest_node(node); end

  # Visit a InNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#2204
  def visit_in_node(node); end

  # Visit a IndexAndWriteNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#2236
  def visit_index_and_write_node(node); end

  # Visit a IndexOperatorWriteNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#2289
  def visit_index_operator_write_node(node); end

  # Visit a IndexOrWriteNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#2345
  def visit_index_or_write_node(node); end

  # Visit a IndexTargetNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#2398
  def visit_index_target_node(node); end

  # Visit a InstanceVariableAndWriteNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#2437
  def visit_instance_variable_and_write_node(node); end

  # Visit a InstanceVariableOperatorWriteNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#2464
  def visit_instance_variable_operator_write_node(node); end

  # Visit a InstanceVariableOrWriteNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#2494
  def visit_instance_variable_or_write_node(node); end

  # Visit a InstanceVariableReadNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#2521
  def visit_instance_variable_read_node(node); end

  # Visit a InstanceVariableTargetNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#2538
  def visit_instance_variable_target_node(node); end

  # Visit a InstanceVariableWriteNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#2555
  def visit_instance_variable_write_node(node); end

  # Visit a IntegerNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#2582
  def visit_integer_node(node); end

  # Visit a InterpolatedMatchLastLineNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#2602
  def visit_interpolated_match_last_line_node(node); end

  # Visit a InterpolatedRegularExpressionNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#2638
  def visit_interpolated_regular_expression_node(node); end

  # Visit a InterpolatedStringNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#2674
  def visit_interpolated_string_node(node); end

  # Visit a InterpolatedSymbolNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#2714
  def visit_interpolated_symbol_node(node); end

  # Visit a InterpolatedXStringNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#2751
  def visit_interpolated_x_string_node(node); end

  # Visit a ItLocalVariableReadNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#2784
  def visit_it_local_variable_read_node(node); end

  # Visit a ItParametersNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#2798
  def visit_it_parameters_node(node); end

  # Visit a KeywordHashNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#2812
  def visit_keyword_hash_node(node); end

  # Visit a KeywordRestParameterNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#2842
  def visit_keyword_rest_parameter_node(node); end

  # Visit a LambdaNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#2870
  def visit_lambda_node(node); end

  # Visit a LocalVariableAndWriteNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#2908
  def visit_local_variable_and_write_node(node); end

  # Visit a LocalVariableOperatorWriteNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#2938
  def visit_local_variable_operator_write_node(node); end

  # Visit a LocalVariableOrWriteNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#2971
  def visit_local_variable_or_write_node(node); end

  # Visit a LocalVariableReadNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#3001
  def visit_local_variable_read_node(node); end

  # Visit a LocalVariableTargetNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#3021
  def visit_local_variable_target_node(node); end

  # Visit a LocalVariableWriteNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#3041
  def visit_local_variable_write_node(node); end

  # Visit a MatchLastLineNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#3071
  def visit_match_last_line_node(node); end

  # Visit a MatchPredicateNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#3100
  def visit_match_predicate_node(node); end

  # Visit a MatchRequiredNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#3125
  def visit_match_required_node(node); end

  # Visit a MatchWriteNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#3150
  def visit_match_write_node(node); end

  # Visit a MissingNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#3181
  def visit_missing_node(node); end

  # Visit a ModuleNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#3195
  def visit_module_node(node); end

  # Visit a MultiTargetNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#3231
  def visit_multi_target_node(node); end

  # Visit a MultiWriteNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#3287
  def visit_multi_write_node(node); end

  # Visit a NextNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#3350
  def visit_next_node(node); end

  # Visit a NilNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#3373
  def visit_nil_node(node); end

  # Visit a NoKeywordsParameterNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#3387
  def visit_no_keywords_parameter_node(node); end

  # Visit a NumberedParametersNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#3407
  def visit_numbered_parameters_node(node); end

  # Visit a NumberedReferenceReadNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#3424
  def visit_numbered_reference_read_node(node); end

  # Visit a OptionalKeywordParameterNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#3441
  def visit_optional_keyword_parameter_node(node); end

  # Visit a OptionalParameterNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#3468
  def visit_optional_parameter_node(node); end

  # Visit a OrNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#3498
  def visit_or_node(node); end

  # Visit a ParametersNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#3523
  def visit_parameters_node(node); end

  # Visit a ParenthesesNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#3607
  def visit_parentheses_node(node); end

  # Visit a PinnedExpressionNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#3633
  def visit_pinned_expression_node(node); end

  # Visit a PinnedVariableNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#3660
  def visit_pinned_variable_node(node); end

  # Visit a PostExecutionNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#3681
  def visit_post_execution_node(node); end

  # Visit a PreExecutionNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#3710
  def visit_pre_execution_node(node); end

  # Visit a ProgramNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#3739
  def visit_program_node(node); end

  # Visit a RangeNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#3760
  def visit_range_node(node); end

  # Visit a RationalNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#3792
  def visit_rational_node(node); end

  # Visit a RedoNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#3815
  def visit_redo_node(node); end

  # Visit a RegularExpressionNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#3829
  def visit_regular_expression_node(node); end

  # Visit a RequiredKeywordParameterNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#3858
  def visit_required_keyword_parameter_node(node); end

  # Visit a RequiredParameterNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#3881
  def visit_required_parameter_node(node); end

  # Visit a RescueModifierNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#3901
  def visit_rescue_modifier_node(node); end

  # Visit a RescueNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#3926
  def visit_rescue_node(node); end

  # Visit a RestParameterNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#3979
  def visit_rest_parameter_node(node); end

  # Visit a RetryNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#4007
  def visit_retry_node(node); end

  # Visit a ReturnNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#4021
  def visit_return_node(node); end

  # Visit a SelfNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#4044
  def visit_self_node(node); end

  # Visit a ShareableConstantNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#4058
  def visit_shareable_constant_node(node); end

  # Visit a SingletonClassNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#4079
  def visit_singleton_class_node(node); end

  # Visit a SourceEncodingNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#4115
  def visit_source_encoding_node(node); end

  # Visit a SourceFileNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#4129
  def visit_source_file_node(node); end

  # Visit a SourceLineNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#4149
  def visit_source_line_node(node); end

  # Visit a SplatNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#4163
  def visit_splat_node(node); end

  # Visit a StatementsNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#4186
  def visit_statements_node(node); end

  # Visit a StringNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#4213
  def visit_string_node(node); end

  # Visit a SuperNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#4246
  def visit_super_node(node); end

  # Visit a SymbolNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#4285
  def visit_symbol_node(node); end

  # Visit a TrueNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#4320
  def visit_true_node(node); end

  # Visit a UndefNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#4334
  def visit_undef_node(node); end

  # Visit a UnlessNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#4364
  def visit_unless_node(node); end

  # Visit a UntilNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#4407
  def visit_until_node(node); end

  # Visit a WhenNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#4442
  def visit_when_node(node); end

  # Visit a WhileNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#4483
  def visit_while_node(node); end

  # Visit a XStringNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#4518
  def visit_x_string_node(node); end

  # Visit a YieldNode node.
  #
  # source://prism//lib/prism/dot_visitor.rb#4547
  def visit_yield_node(node); end

  private

  # Inspect a node that has arguments_node_flags flags to display the flags as a
  # comma-separated list.
  #
  # source://prism//lib/prism/dot_visitor.rb#4593
  def arguments_node_flags_inspect(node); end

  # Inspect a node that has array_node_flags flags to display the flags as a
  # comma-separated list.
  #
  # source://prism//lib/prism/dot_visitor.rb#4605
  def array_node_flags_inspect(node); end

  # Inspect a node that has call_node_flags flags to display the flags as a
  # comma-separated list.
  #
  # source://prism//lib/prism/dot_visitor.rb#4613
  def call_node_flags_inspect(node); end

  # Inspect a node that has encoding_flags flags to display the flags as a
  # comma-separated list.
  #
  # source://prism//lib/prism/dot_visitor.rb#4624
  def encoding_flags_inspect(node); end

  # Inspect a node that has integer_base_flags flags to display the flags as a
  # comma-separated list.
  #
  # source://prism//lib/prism/dot_visitor.rb#4633
  def integer_base_flags_inspect(node); end

  # Inspect a node that has interpolated_string_node_flags flags to display the flags as a
  # comma-separated list.
  #
  # source://prism//lib/prism/dot_visitor.rb#4644
  def interpolated_string_node_flags_inspect(node); end

  # Inspect a node that has keyword_hash_node_flags flags to display the flags as a
  # comma-separated list.
  #
  # source://prism//lib/prism/dot_visitor.rb#4653
  def keyword_hash_node_flags_inspect(node); end

  # Inspect a location to display the start and end line and column numbers.
  #
  # source://prism//lib/prism/dot_visitor.rb#4587
  def location_inspect(location); end

  # Inspect a node that has loop_flags flags to display the flags as a
  # comma-separated list.
  #
  # source://prism//lib/prism/dot_visitor.rb#4661
  def loop_flags_inspect(node); end

  # Generate a unique node ID for a node throughout the digraph.
  #
  # source://prism//lib/prism/dot_visitor.rb#4582
  def node_id(node); end

  # Inspect a node that has parameter_flags flags to display the flags as a
  # comma-separated list.
  #
  # source://prism//lib/prism/dot_visitor.rb#4669
  def parameter_flags_inspect(node); end

  # Inspect a node that has range_flags flags to display the flags as a
  # comma-separated list.
  #
  # source://prism//lib/prism/dot_visitor.rb#4677
  def range_flags_inspect(node); end

  # Inspect a node that has regular_expression_flags flags to display the flags as a
  # comma-separated list.
  #
  # source://prism//lib/prism/dot_visitor.rb#4685
  def regular_expression_flags_inspect(node); end

  # Inspect a node that has shareable_constant_node_flags flags to display the flags as a
  # comma-separated list.
  #
  # source://prism//lib/prism/dot_visitor.rb#4703
  def shareable_constant_node_flags_inspect(node); end

  # Inspect a node that has string_flags flags to display the flags as a
  # comma-separated list.
  #
  # source://prism//lib/prism/dot_visitor.rb#4713
  def string_flags_inspect(node); end

  # Inspect a node that has symbol_flags flags to display the flags as a
  # comma-separated list.
  #
  # source://prism//lib/prism/dot_visitor.rb#4724
  def symbol_flags_inspect(node); end
end

# source://prism//lib/prism/dot_visitor.rb#59
class Prism::DotVisitor::Digraph
  # @return [Digraph] a new instance of Digraph
  #
  # source://prism//lib/prism/dot_visitor.rb#62
  def initialize; end

  # source://prism//lib/prism/dot_visitor.rb#76
  def edge(value); end

  # Returns the value of attribute edges.
  #
  # source://prism//lib/prism/dot_visitor.rb#60
  def edges; end

  # source://prism//lib/prism/dot_visitor.rb#68
  def node(value); end

  # Returns the value of attribute nodes.
  #
  # source://prism//lib/prism/dot_visitor.rb#60
  def nodes; end

  # source://prism//lib/prism/dot_visitor.rb#80
  def to_dot; end

  # source://prism//lib/prism/dot_visitor.rb#72
  def waypoint(value); end

  # Returns the value of attribute waypoints.
  #
  # source://prism//lib/prism/dot_visitor.rb#60
  def waypoints; end
end

# source://prism//lib/prism/dot_visitor.rb#15
class Prism::DotVisitor::Field
  # @return [Field] a new instance of Field
  #
  # source://prism//lib/prism/dot_visitor.rb#18
  def initialize(name, value, port); end

  # Returns the value of attribute name.
  #
  # source://prism//lib/prism/dot_visitor.rb#16
  def name; end

  # Returns the value of attribute port.
  #
  # source://prism//lib/prism/dot_visitor.rb#16
  def port; end

  # source://prism//lib/prism/dot_visitor.rb#24
  def to_dot; end

  # Returns the value of attribute value.
  #
  # source://prism//lib/prism/dot_visitor.rb#16
  def value; end
end

# source://prism//lib/prism/dot_visitor.rb#33
class Prism::DotVisitor::Table
  # @return [Table] a new instance of Table
  #
  # source://prism//lib/prism/dot_visitor.rb#36
  def initialize(name); end

  # source://prism//lib/prism/dot_visitor.rb#41
  def field(name, value = T.unsafe(nil), port: T.unsafe(nil)); end

  # Returns the value of attribute fields.
  #
  # source://prism//lib/prism/dot_visitor.rb#34
  def fields; end

  # Returns the value of attribute name.
  #
  # source://prism//lib/prism/dot_visitor.rb#34
  def name; end

  # source://prism//lib/prism/dot_visitor.rb#45
  def to_dot; end
end

# Represents an `else` clause in a `case`, `if`, or `unless` statement.
#
#     if a then b else c end
#                 ^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#5485
class Prism::ElseNode < ::Prism::Node
  # Initialize a new ElseNode node.
  #
  # @return [ElseNode] a new instance of ElseNode
  #
  # source://prism//lib/prism/node.rb#5487
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      else_keyword_loc: Prism::Location,
      statements: T.nilable(Prism::StatementsNode),
      end_keyword_loc: T.nilable(Prism::Location)
    ).void
  end
  def initialize(source, node_id, location, flags, else_keyword_loc, statements, end_keyword_loc); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#5582
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#5498
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#5503
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#5515
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#5508
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?else_keyword_loc: Location, ?statements: StatementsNode?, ?end_keyword_loc: Location?) -> ElseNode
  #
  # source://prism//lib/prism/node.rb#5520
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      else_keyword_loc: Prism::Location,
      statements: T.nilable(Prism::StatementsNode),
      end_keyword_loc: T.nilable(Prism::Location)
    ).returns(Prism::ElseNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), else_keyword_loc: T.unsafe(nil), statements: T.unsafe(nil), end_keyword_loc: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#5503
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, else_keyword_loc: Location, statements: StatementsNode?, end_keyword_loc: Location? }
  #
  # source://prism//lib/prism/node.rb#5528
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def else_keyword: () -> String
  #
  # source://prism//lib/prism/node.rb#5556
  sig { returns(String) }
  def else_keyword; end

  # attr_reader else_keyword_loc: Location
  #
  # source://prism//lib/prism/node.rb#5533
  sig { returns(Prism::Location) }
  def else_keyword_loc; end

  # def end_keyword: () -> String?
  #
  # source://prism//lib/prism/node.rb#5561
  sig { returns(T.nilable(String)) }
  def end_keyword; end

  # attr_reader end_keyword_loc: Location?
  #
  # source://prism//lib/prism/node.rb#5543
  sig { returns(T.nilable(Prism::Location)) }
  def end_keyword_loc; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#5566
  sig { override.returns(String) }
  def inspect; end

  # attr_reader statements: StatementsNode?
  #
  # source://prism//lib/prism/node.rb#5540
  sig { returns(T.nilable(Prism::StatementsNode)) }
  def statements; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#5571
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#5576
    def type; end
  end
end

# EmbDocComment objects correspond to comments that are surrounded by =begin
# and =end.
#
# source://prism//lib/prism/parse_result.rb#544
class Prism::EmbDocComment < ::Prism::Comment
  # Returns a string representation of this comment.
  #
  # source://prism//lib/prism/parse_result.rb#551
  sig { returns(String) }
  def inspect; end

  # This can only be true for inline comments.
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/parse_result.rb#546
  sig { override.returns(T::Boolean) }
  def trailing?; end
end

# Represents an interpolated set of statements.
#
#     "foo #{bar}"
#          ^^^^^^
#
# source://prism//lib/prism/node.rb#5594
class Prism::EmbeddedStatementsNode < ::Prism::Node
  # Initialize a new EmbeddedStatementsNode node.
  #
  # @return [EmbeddedStatementsNode] a new instance of EmbeddedStatementsNode
  #
  # source://prism//lib/prism/node.rb#5596
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      opening_loc: Prism::Location,
      statements: T.nilable(Prism::StatementsNode),
      closing_loc: Prism::Location
    ).void
  end
  def initialize(source, node_id, location, flags, opening_loc, statements, closing_loc); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#5685
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#5607
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#5612
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def closing: () -> String
  #
  # source://prism//lib/prism/node.rb#5664
  sig { returns(String) }
  def closing; end

  # attr_reader closing_loc: Location
  #
  # source://prism//lib/prism/node.rb#5652
  sig { returns(Prism::Location) }
  def closing_loc; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#5624
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#5617
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?opening_loc: Location, ?statements: StatementsNode?, ?closing_loc: Location) -> EmbeddedStatementsNode
  #
  # source://prism//lib/prism/node.rb#5629
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      opening_loc: Prism::Location,
      statements: T.nilable(Prism::StatementsNode),
      closing_loc: Prism::Location
    ).returns(Prism::EmbeddedStatementsNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), opening_loc: T.unsafe(nil), statements: T.unsafe(nil), closing_loc: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#5612
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, opening_loc: Location, statements: StatementsNode?, closing_loc: Location }
  #
  # source://prism//lib/prism/node.rb#5637
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#5669
  sig { override.returns(String) }
  def inspect; end

  # def opening: () -> String
  #
  # source://prism//lib/prism/node.rb#5659
  sig { returns(String) }
  def opening; end

  # attr_reader opening_loc: Location
  #
  # source://prism//lib/prism/node.rb#5642
  sig { returns(Prism::Location) }
  def opening_loc; end

  # attr_reader statements: StatementsNode?
  #
  # source://prism//lib/prism/node.rb#5649
  sig { returns(T.nilable(Prism::StatementsNode)) }
  def statements; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#5674
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#5679
    def type; end
  end
end

# Represents an interpolated variable.
#
#     "foo #@bar"
#          ^^^^^
#
# source://prism//lib/prism/node.rb#5697
class Prism::EmbeddedVariableNode < ::Prism::Node
  # Initialize a new EmbeddedVariableNode node.
  #
  # @return [EmbeddedVariableNode] a new instance of EmbeddedVariableNode
  #
  # source://prism//lib/prism/node.rb#5699
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      operator_loc: Prism::Location,
      variable: T.any(Prism::InstanceVariableReadNode, Prism::ClassVariableReadNode, Prism::GlobalVariableReadNode, Prism::BackReferenceReadNode, Prism::NumberedReferenceReadNode)
    ).void
  end
  def initialize(source, node_id, location, flags, operator_loc, variable); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#5773
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#5709
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#5714
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#5724
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#5719
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?operator_loc: Location, ?variable: InstanceVariableReadNode | ClassVariableReadNode | GlobalVariableReadNode | BackReferenceReadNode | NumberedReferenceReadNode) -> EmbeddedVariableNode
  #
  # source://prism//lib/prism/node.rb#5729
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      operator_loc: Prism::Location,
      variable: T.any(Prism::InstanceVariableReadNode, Prism::ClassVariableReadNode, Prism::GlobalVariableReadNode, Prism::BackReferenceReadNode, Prism::NumberedReferenceReadNode)
    ).returns(Prism::EmbeddedVariableNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), operator_loc: T.unsafe(nil), variable: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#5714
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, operator_loc: Location, variable: InstanceVariableReadNode | ClassVariableReadNode | GlobalVariableReadNode | BackReferenceReadNode | NumberedReferenceReadNode }
  #
  # source://prism//lib/prism/node.rb#5737
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#5757
  sig { override.returns(String) }
  def inspect; end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#5752
  sig { returns(String) }
  def operator; end

  # attr_reader operator_loc: Location
  #
  # source://prism//lib/prism/node.rb#5742
  sig { returns(Prism::Location) }
  def operator_loc; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#5762
  sig { override.returns(Symbol) }
  def type; end

  # attr_reader variable: InstanceVariableReadNode | ClassVariableReadNode | GlobalVariableReadNode | BackReferenceReadNode | NumberedReferenceReadNode
  #
  # source://prism//lib/prism/node.rb#5749
  sig do
    returns(T.any(Prism::InstanceVariableReadNode, Prism::ClassVariableReadNode, Prism::GlobalVariableReadNode, Prism::BackReferenceReadNode, Prism::NumberedReferenceReadNode))
  end
  def variable; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#5767
    def type; end
  end
end

# Flags for nodes that have unescaped content.
#
# source://prism//lib/prism/node.rb#16723
module Prism::EncodingFlags; end

# internal bytes forced the encoding to binary
#
# source://prism//lib/prism/node.rb#16728
Prism::EncodingFlags::FORCED_BINARY_ENCODING = T.let(T.unsafe(nil), Integer)

# internal bytes forced the encoding to UTF-8
#
# source://prism//lib/prism/node.rb#16725
Prism::EncodingFlags::FORCED_UTF8_ENCODING = T.let(T.unsafe(nil), Integer)

# Represents an `ensure` clause in a `begin` statement.
#
#     begin
#       foo
#     ensure
#     ^^^^^^
#       bar
#     end
#
# source://prism//lib/prism/node.rb#5788
class Prism::EnsureNode < ::Prism::Node
  # Initialize a new EnsureNode node.
  #
  # @return [EnsureNode] a new instance of EnsureNode
  #
  # source://prism//lib/prism/node.rb#5790
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      ensure_keyword_loc: Prism::Location,
      statements: T.nilable(Prism::StatementsNode),
      end_keyword_loc: Prism::Location
    ).void
  end
  def initialize(source, node_id, location, flags, ensure_keyword_loc, statements, end_keyword_loc); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#5879
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#5801
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#5806
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#5818
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#5811
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?ensure_keyword_loc: Location, ?statements: StatementsNode?, ?end_keyword_loc: Location) -> EnsureNode
  #
  # source://prism//lib/prism/node.rb#5823
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      ensure_keyword_loc: Prism::Location,
      statements: T.nilable(Prism::StatementsNode),
      end_keyword_loc: Prism::Location
    ).returns(Prism::EnsureNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), ensure_keyword_loc: T.unsafe(nil), statements: T.unsafe(nil), end_keyword_loc: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#5806
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, ensure_keyword_loc: Location, statements: StatementsNode?, end_keyword_loc: Location }
  #
  # source://prism//lib/prism/node.rb#5831
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def end_keyword: () -> String
  #
  # source://prism//lib/prism/node.rb#5858
  sig { returns(String) }
  def end_keyword; end

  # attr_reader end_keyword_loc: Location
  #
  # source://prism//lib/prism/node.rb#5846
  sig { returns(Prism::Location) }
  def end_keyword_loc; end

  # def ensure_keyword: () -> String
  #
  # source://prism//lib/prism/node.rb#5853
  sig { returns(String) }
  def ensure_keyword; end

  # attr_reader ensure_keyword_loc: Location
  #
  # source://prism//lib/prism/node.rb#5836
  sig { returns(Prism::Location) }
  def ensure_keyword_loc; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#5863
  sig { override.returns(String) }
  def inspect; end

  # attr_reader statements: StatementsNode?
  #
  # source://prism//lib/prism/node.rb#5843
  sig { returns(T.nilable(Prism::StatementsNode)) }
  def statements; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#5868
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#5873
    def type; end
  end
end

# Represents the use of the literal `false` keyword.
#
#     false
#     ^^^^^
#
# source://prism//lib/prism/node.rb#5891
class Prism::FalseNode < ::Prism::Node
  # Initialize a new FalseNode node.
  #
  # @return [FalseNode] a new instance of FalseNode
  #
  # source://prism//lib/prism/node.rb#5893
  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer).void }
  def initialize(source, node_id, location, flags); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#5950
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#5901
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#5906
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#5916
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#5911
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer) -> FalseNode
  #
  # source://prism//lib/prism/node.rb#5921
  sig { params(node_id: Integer, location: Prism::Location, flags: Integer).returns(Prism::FalseNode) }
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#5906
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location }
  #
  # source://prism//lib/prism/node.rb#5929
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#5934
  sig { override.returns(String) }
  def inspect; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#5939
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#5944
    def type; end
  end
end

# Represents a find pattern in pattern matching.
#
#     foo in *bar, baz, *qux
#            ^^^^^^^^^^^^^^^
#
#     foo in [*bar, baz, *qux]
#            ^^^^^^^^^^^^^^^^^
#
#     foo in Foo(*bar, baz, *qux)
#            ^^^^^^^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#5965
class Prism::FindPatternNode < ::Prism::Node
  # Initialize a new FindPatternNode node.
  #
  # @return [FindPatternNode] a new instance of FindPatternNode
  #
  # source://prism//lib/prism/node.rb#5967
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      constant: T.nilable(T.any(Prism::ConstantReadNode, Prism::ConstantPathNode)),
      left: Prism::SplatNode,
      requireds: T::Array[Prism::Node],
      right: T.any(Prism::SplatNode, Prism::MissingNode),
      opening_loc: T.nilable(Prism::Location),
      closing_loc: T.nilable(Prism::Location)
    ).void
  end
  def initialize(source, node_id, location, flags, constant, left, requireds, right, opening_loc, closing_loc); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#6083
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#5981
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#5986
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def closing: () -> String?
  #
  # source://prism//lib/prism/node.rb#6062
  sig { returns(T.nilable(String)) }
  def closing; end

  # attr_reader closing_loc: Location?
  #
  # source://prism//lib/prism/node.rb#6044
  sig { returns(T.nilable(Prism::Location)) }
  def closing_loc; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#6001
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#5991
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # attr_reader constant: ConstantReadNode | ConstantPathNode | nil
  #
  # source://prism//lib/prism/node.rb#6019
  sig { returns(T.nilable(T.any(Prism::ConstantReadNode, Prism::ConstantPathNode))) }
  def constant; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?constant: ConstantReadNode | ConstantPathNode | nil, ?left: SplatNode, ?requireds: Array[Prism::node], ?right: SplatNode | MissingNode, ?opening_loc: Location?, ?closing_loc: Location?) -> FindPatternNode
  #
  # source://prism//lib/prism/node.rb#6006
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      constant: T.nilable(T.any(Prism::ConstantReadNode, Prism::ConstantPathNode)),
      left: Prism::SplatNode,
      requireds: T::Array[Prism::Node],
      right: T.any(Prism::SplatNode, Prism::MissingNode),
      opening_loc: T.nilable(Prism::Location),
      closing_loc: T.nilable(Prism::Location)
    ).returns(Prism::FindPatternNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), constant: T.unsafe(nil), left: T.unsafe(nil), requireds: T.unsafe(nil), right: T.unsafe(nil), opening_loc: T.unsafe(nil), closing_loc: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#5986
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, constant: ConstantReadNode | ConstantPathNode | nil, left: SplatNode, requireds: Array[Prism::node], right: SplatNode | MissingNode, opening_loc: Location?, closing_loc: Location? }
  #
  # source://prism//lib/prism/node.rb#6014
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#6067
  sig { override.returns(String) }
  def inspect; end

  # attr_reader left: SplatNode
  #
  # source://prism//lib/prism/node.rb#6022
  sig { returns(Prism::SplatNode) }
  def left; end

  # def opening: () -> String?
  #
  # source://prism//lib/prism/node.rb#6057
  sig { returns(T.nilable(String)) }
  def opening; end

  # attr_reader opening_loc: Location?
  #
  # source://prism//lib/prism/node.rb#6031
  sig { returns(T.nilable(Prism::Location)) }
  def opening_loc; end

  # attr_reader requireds: Array[Prism::node]
  #
  # source://prism//lib/prism/node.rb#6025
  sig { returns(T::Array[Prism::Node]) }
  def requireds; end

  # attr_reader right: SplatNode | MissingNode
  #
  # source://prism//lib/prism/node.rb#6028
  sig { returns(T.any(Prism::SplatNode, Prism::MissingNode)) }
  def right; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#6072
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#6077
    def type; end
  end
end

# Represents the use of the `..` or `...` operators to create flip flops.
#
#     baz if foo .. bar
#            ^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#6099
class Prism::FlipFlopNode < ::Prism::Node
  # Initialize a new FlipFlopNode node.
  #
  # @return [FlipFlopNode] a new instance of FlipFlopNode
  #
  # source://prism//lib/prism/node.rb#6101
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      left: T.nilable(Prism::Node),
      right: T.nilable(Prism::Node),
      operator_loc: Prism::Location
    ).void
  end
  def initialize(source, node_id, location, flags, left, right, operator_loc); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#6187
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#6112
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#6117
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#6130
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#6122
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?left: Prism::node?, ?right: Prism::node?, ?operator_loc: Location) -> FlipFlopNode
  #
  # source://prism//lib/prism/node.rb#6135
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      left: T.nilable(Prism::Node),
      right: T.nilable(Prism::Node),
      operator_loc: Prism::Location
    ).returns(Prism::FlipFlopNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), left: T.unsafe(nil), right: T.unsafe(nil), operator_loc: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#6117
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, left: Prism::node?, right: Prism::node?, operator_loc: Location }
  #
  # source://prism//lib/prism/node.rb#6143
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def exclude_end?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#6148
  sig { returns(T::Boolean) }
  def exclude_end?; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#6171
  sig { override.returns(String) }
  def inspect; end

  # attr_reader left: Prism::node?
  #
  # source://prism//lib/prism/node.rb#6153
  sig { returns(T.nilable(Prism::Node)) }
  def left; end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#6166
  sig { returns(String) }
  def operator; end

  # attr_reader operator_loc: Location
  #
  # source://prism//lib/prism/node.rb#6159
  sig { returns(Prism::Location) }
  def operator_loc; end

  # attr_reader right: Prism::node?
  #
  # source://prism//lib/prism/node.rb#6156
  sig { returns(T.nilable(Prism::Node)) }
  def right; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#6176
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#6181
    def type; end
  end
end

# Represents a floating point number literal.
#
#     1.0
#     ^^^
#
# source://prism//lib/prism/node.rb#6200
class Prism::FloatNode < ::Prism::Node
  # Initialize a new FloatNode node.
  #
  # @return [FloatNode] a new instance of FloatNode
  #
  # source://prism//lib/prism/node.rb#6202
  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, value: Float).void }
  def initialize(source, node_id, location, flags, value); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#6263
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#6211
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#6216
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#6226
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#6221
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?value: Float) -> FloatNode
  #
  # source://prism//lib/prism/node.rb#6231
  sig { params(node_id: Integer, location: Prism::Location, flags: Integer, value: Float).returns(Prism::FloatNode) }
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), value: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#6216
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, value: Float }
  #
  # source://prism//lib/prism/node.rb#6239
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#6247
  sig { override.returns(String) }
  def inspect; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#6252
  sig { override.returns(Symbol) }
  def type; end

  # The value of the floating point number as a Float.
  #
  # source://prism//lib/prism/node.rb#6244
  sig { returns(Float) }
  def value; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#6257
    def type; end
  end
end

# Represents the use of the `for` keyword.
#
#     for i in a end
#     ^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#6273
class Prism::ForNode < ::Prism::Node
  # Initialize a new ForNode node.
  #
  # @return [ForNode] a new instance of ForNode
  #
  # source://prism//lib/prism/node.rb#6275
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      index: T.any(Prism::LocalVariableTargetNode, Prism::InstanceVariableTargetNode, Prism::ClassVariableTargetNode, Prism::GlobalVariableTargetNode, Prism::ConstantTargetNode, Prism::ConstantPathTargetNode, Prism::CallTargetNode, Prism::IndexTargetNode, Prism::MultiTargetNode, Prism::BackReferenceReadNode, Prism::NumberedReferenceReadNode, Prism::MissingNode),
      collection: Prism::Node,
      statements: T.nilable(Prism::StatementsNode),
      for_keyword_loc: Prism::Location,
      in_keyword_loc: Prism::Location,
      do_keyword_loc: T.nilable(Prism::Location),
      end_keyword_loc: Prism::Location
    ).void
  end
  def initialize(source, node_id, location, flags, index, collection, statements, for_keyword_loc, in_keyword_loc, do_keyword_loc, end_keyword_loc); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#6429
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#6290
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#6295
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # The collection to iterate over.
  #
  #     for i in a end
  #              ^
  #
  # source://prism//lib/prism/node.rb#6336
  sig { returns(Prism::Node) }
  def collection; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#6309
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#6300
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?index: LocalVariableTargetNode | InstanceVariableTargetNode | ClassVariableTargetNode | GlobalVariableTargetNode | ConstantTargetNode | ConstantPathTargetNode | CallTargetNode | IndexTargetNode | MultiTargetNode | BackReferenceReadNode | NumberedReferenceReadNode | MissingNode, ?collection: Prism::node, ?statements: StatementsNode?, ?for_keyword_loc: Location, ?in_keyword_loc: Location, ?do_keyword_loc: Location?, ?end_keyword_loc: Location) -> ForNode
  #
  # source://prism//lib/prism/node.rb#6314
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      index: T.any(Prism::LocalVariableTargetNode, Prism::InstanceVariableTargetNode, Prism::ClassVariableTargetNode, Prism::GlobalVariableTargetNode, Prism::ConstantTargetNode, Prism::ConstantPathTargetNode, Prism::CallTargetNode, Prism::IndexTargetNode, Prism::MultiTargetNode, Prism::BackReferenceReadNode, Prism::NumberedReferenceReadNode, Prism::MissingNode),
      collection: Prism::Node,
      statements: T.nilable(Prism::StatementsNode),
      for_keyword_loc: Prism::Location,
      in_keyword_loc: Prism::Location,
      do_keyword_loc: T.nilable(Prism::Location),
      end_keyword_loc: Prism::Location
    ).returns(Prism::ForNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), index: T.unsafe(nil), collection: T.unsafe(nil), statements: T.unsafe(nil), for_keyword_loc: T.unsafe(nil), in_keyword_loc: T.unsafe(nil), do_keyword_loc: T.unsafe(nil), end_keyword_loc: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#6295
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, index: LocalVariableTargetNode | InstanceVariableTargetNode | ClassVariableTargetNode | GlobalVariableTargetNode | ConstantTargetNode | ConstantPathTargetNode | CallTargetNode | IndexTargetNode | MultiTargetNode | BackReferenceReadNode | NumberedReferenceReadNode | MissingNode, collection: Prism::node, statements: StatementsNode?, for_keyword_loc: Location, in_keyword_loc: Location, do_keyword_loc: Location?, end_keyword_loc: Location }
  #
  # source://prism//lib/prism/node.rb#6322
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def do_keyword: () -> String?
  #
  # source://prism//lib/prism/node.rb#6403
  sig { returns(T.nilable(String)) }
  def do_keyword; end

  # The location of the `do` keyword, if present.
  #
  #     for i in a do end
  #                ^^
  #
  # source://prism//lib/prism/node.rb#6370
  sig { returns(T.nilable(Prism::Location)) }
  def do_keyword_loc; end

  # def end_keyword: () -> String
  #
  # source://prism//lib/prism/node.rb#6408
  sig { returns(String) }
  def end_keyword; end

  # The location of the `end` keyword.
  #
  #     for i in a end
  #                ^^^
  #
  # source://prism//lib/prism/node.rb#6386
  sig { returns(Prism::Location) }
  def end_keyword_loc; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def for_keyword: () -> String
  #
  # source://prism//lib/prism/node.rb#6393
  sig { returns(String) }
  def for_keyword; end

  # The location of the `for` keyword.
  #
  #     for i in a end
  #     ^^^
  #
  # source://prism//lib/prism/node.rb#6350
  sig { returns(Prism::Location) }
  def for_keyword_loc; end

  # def in_keyword: () -> String
  #
  # source://prism//lib/prism/node.rb#6398
  sig { returns(String) }
  def in_keyword; end

  # The location of the `in` keyword.
  #
  #     for i in a end
  #           ^^
  #
  # source://prism//lib/prism/node.rb#6360
  sig { returns(Prism::Location) }
  def in_keyword_loc; end

  # The index expression for `for` loops.
  #
  #     for i in a end
  #         ^
  #
  # source://prism//lib/prism/node.rb#6330
  sig do
    returns(T.any(Prism::LocalVariableTargetNode, Prism::InstanceVariableTargetNode, Prism::ClassVariableTargetNode, Prism::GlobalVariableTargetNode, Prism::ConstantTargetNode, Prism::ConstantPathTargetNode, Prism::CallTargetNode, Prism::IndexTargetNode, Prism::MultiTargetNode, Prism::BackReferenceReadNode, Prism::NumberedReferenceReadNode, Prism::MissingNode))
  end
  def index; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#6413
  sig { override.returns(String) }
  def inspect; end

  # Represents the body of statements to execute for each iteration of the loop.
  #
  #     for i in a
  #       foo(i)
  #       ^^^^^^
  #     end
  #
  # source://prism//lib/prism/node.rb#6344
  sig { returns(T.nilable(Prism::StatementsNode)) }
  def statements; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#6418
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#6423
    def type; end
  end
end

# Represents forwarding all arguments to this method to another method.
#
#     def foo(...)
#       bar(...)
#           ^^^
#     end
#
# source://prism//lib/prism/node.rb#6447
class Prism::ForwardingArgumentsNode < ::Prism::Node
  # Initialize a new ForwardingArgumentsNode node.
  #
  # @return [ForwardingArgumentsNode] a new instance of ForwardingArgumentsNode
  #
  # source://prism//lib/prism/node.rb#6449
  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer).void }
  def initialize(source, node_id, location, flags); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#6506
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#6457
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#6462
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#6472
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#6467
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer) -> ForwardingArgumentsNode
  #
  # source://prism//lib/prism/node.rb#6477
  sig { params(node_id: Integer, location: Prism::Location, flags: Integer).returns(Prism::ForwardingArgumentsNode) }
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#6462
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location }
  #
  # source://prism//lib/prism/node.rb#6485
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#6490
  sig { override.returns(String) }
  def inspect; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#6495
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#6500
    def type; end
  end
end

# Represents the use of the forwarding parameter in a method, block, or lambda declaration.
#
#     def foo(...)
#             ^^^
#     end
#
# source://prism//lib/prism/node.rb#6516
class Prism::ForwardingParameterNode < ::Prism::Node
  # Initialize a new ForwardingParameterNode node.
  #
  # @return [ForwardingParameterNode] a new instance of ForwardingParameterNode
  #
  # source://prism//lib/prism/node.rb#6518
  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer).void }
  def initialize(source, node_id, location, flags); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#6575
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#6526
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#6531
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#6541
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#6536
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer) -> ForwardingParameterNode
  #
  # source://prism//lib/prism/node.rb#6546
  sig { params(node_id: Integer, location: Prism::Location, flags: Integer).returns(Prism::ForwardingParameterNode) }
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#6531
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location }
  #
  # source://prism//lib/prism/node.rb#6554
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#6559
  sig { override.returns(String) }
  def inspect; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#6564
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#6569
    def type; end
  end
end

# Represents the use of the `super` keyword without parentheses or arguments.
#
#     super
#     ^^^^^
#
# source://prism//lib/prism/node.rb#6584
class Prism::ForwardingSuperNode < ::Prism::Node
  # Initialize a new ForwardingSuperNode node.
  #
  # @return [ForwardingSuperNode] a new instance of ForwardingSuperNode
  #
  # source://prism//lib/prism/node.rb#6586
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      block: T.nilable(Prism::BlockNode)
    ).void
  end
  def initialize(source, node_id, location, flags, block); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#6649
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#6595
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # attr_reader block: BlockNode?
  #
  # source://prism//lib/prism/node.rb#6630
  sig { returns(T.nilable(Prism::BlockNode)) }
  def block; end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#6600
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#6612
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#6605
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?block: BlockNode?) -> ForwardingSuperNode
  #
  # source://prism//lib/prism/node.rb#6617
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      block: T.nilable(Prism::BlockNode)
    ).returns(Prism::ForwardingSuperNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), block: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#6600
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, block: BlockNode? }
  #
  # source://prism//lib/prism/node.rb#6625
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#6633
  sig { override.returns(String) }
  def inspect; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#6638
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#6643
    def type; end
  end
end

# Represents the use of the `&&=` operator for assignment to a global variable.
#
#     $target &&= value
#     ^^^^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#6659
class Prism::GlobalVariableAndWriteNode < ::Prism::Node
  # Initialize a new GlobalVariableAndWriteNode node.
  #
  # @return [GlobalVariableAndWriteNode] a new instance of GlobalVariableAndWriteNode
  #
  # source://prism//lib/prism/node.rb#6661
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      name_loc: Prism::Location,
      operator_loc: Prism::Location,
      value: Prism::Node
    ).void
  end
  def initialize(source, node_id, location, flags, name, name_loc, operator_loc, value); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#6747
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#6673
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#6678
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#6688
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#6683
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?name: Symbol, ?name_loc: Location, ?operator_loc: Location, ?value: Prism::node) -> GlobalVariableAndWriteNode
  #
  # source://prism//lib/prism/node.rb#6693
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      name_loc: Prism::Location,
      operator_loc: Prism::Location,
      value: Prism::Node
    ).returns(Prism::GlobalVariableAndWriteNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil), name_loc: T.unsafe(nil), operator_loc: T.unsafe(nil), value: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#6678
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, name: Symbol, name_loc: Location, operator_loc: Location, value: Prism::node }
  #
  # source://prism//lib/prism/node.rb#6701
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # source://prism//lib/prism/desugar_compiler.rb#200
  def desugar; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#6731
  sig { override.returns(String) }
  def inspect; end

  # attr_reader name: Symbol
  #
  # source://prism//lib/prism/node.rb#6706
  sig { returns(Symbol) }
  def name; end

  # attr_reader name_loc: Location
  #
  # source://prism//lib/prism/node.rb#6709
  sig { returns(Prism::Location) }
  def name_loc; end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#6726
  sig { returns(String) }
  def operator; end

  # attr_reader operator_loc: Location
  #
  # source://prism//lib/prism/node.rb#6716
  sig { returns(Prism::Location) }
  def operator_loc; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#6736
  sig { override.returns(Symbol) }
  def type; end

  # attr_reader value: Prism::node
  #
  # source://prism//lib/prism/node.rb#6723
  sig { returns(Prism::Node) }
  def value; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#6741
    def type; end
  end
end

# Represents assigning to a global variable using an operator that isn't `=`.
#
#     $target += value
#     ^^^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#6760
class Prism::GlobalVariableOperatorWriteNode < ::Prism::Node
  # Initialize a new GlobalVariableOperatorWriteNode node.
  #
  # @return [GlobalVariableOperatorWriteNode] a new instance of GlobalVariableOperatorWriteNode
  #
  # source://prism//lib/prism/node.rb#6762
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      name_loc: Prism::Location,
      binary_operator_loc: Prism::Location,
      value: Prism::Node,
      binary_operator: Symbol
    ).void
  end
  def initialize(source, node_id, location, flags, name, name_loc, binary_operator_loc, value, binary_operator); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#6847
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#6775
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # attr_reader binary_operator: Symbol
  #
  # source://prism//lib/prism/node.rb#6828
  sig { returns(Symbol) }
  def binary_operator; end

  # attr_reader binary_operator_loc: Location
  #
  # source://prism//lib/prism/node.rb#6818
  sig { returns(Prism::Location) }
  def binary_operator_loc; end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#6780
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#6790
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#6785
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?name: Symbol, ?name_loc: Location, ?binary_operator_loc: Location, ?value: Prism::node, ?binary_operator: Symbol) -> GlobalVariableOperatorWriteNode
  #
  # source://prism//lib/prism/node.rb#6795
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      name_loc: Prism::Location,
      binary_operator_loc: Prism::Location,
      value: Prism::Node,
      binary_operator: Symbol
    ).returns(Prism::GlobalVariableOperatorWriteNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil), name_loc: T.unsafe(nil), binary_operator_loc: T.unsafe(nil), value: T.unsafe(nil), binary_operator: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#6780
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, name: Symbol, name_loc: Location, binary_operator_loc: Location, value: Prism::node, binary_operator: Symbol }
  #
  # source://prism//lib/prism/node.rb#6803
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # source://prism//lib/prism/desugar_compiler.rb#212
  def desugar; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#6831
  sig { override.returns(String) }
  def inspect; end

  # attr_reader name: Symbol
  #
  # source://prism//lib/prism/node.rb#6808
  sig { returns(Symbol) }
  def name; end

  # attr_reader name_loc: Location
  #
  # source://prism//lib/prism/node.rb#6811
  sig { returns(Prism::Location) }
  def name_loc; end

  # Returns the binary operator used to modify the receiver. This method is
  # deprecated in favor of #binary_operator.
  #
  # source://prism//lib/prism/node_ext.rb#403
  def operator; end

  # Returns the location of the binary operator used to modify the receiver.
  # This method is deprecated in favor of #binary_operator_loc.
  #
  # source://prism//lib/prism/node_ext.rb#410
  def operator_loc; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#6836
  sig { override.returns(Symbol) }
  def type; end

  # attr_reader value: Prism::node
  #
  # source://prism//lib/prism/node.rb#6825
  sig { returns(Prism::Node) }
  def value; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#6841
    def type; end
  end
end

# Represents the use of the `||=` operator for assignment to a global variable.
#
#     $target ||= value
#     ^^^^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#6861
class Prism::GlobalVariableOrWriteNode < ::Prism::Node
  # Initialize a new GlobalVariableOrWriteNode node.
  #
  # @return [GlobalVariableOrWriteNode] a new instance of GlobalVariableOrWriteNode
  #
  # source://prism//lib/prism/node.rb#6863
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      name_loc: Prism::Location,
      operator_loc: Prism::Location,
      value: Prism::Node
    ).void
  end
  def initialize(source, node_id, location, flags, name, name_loc, operator_loc, value); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#6949
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#6875
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#6880
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#6890
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#6885
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?name: Symbol, ?name_loc: Location, ?operator_loc: Location, ?value: Prism::node) -> GlobalVariableOrWriteNode
  #
  # source://prism//lib/prism/node.rb#6895
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      name_loc: Prism::Location,
      operator_loc: Prism::Location,
      value: Prism::Node
    ).returns(Prism::GlobalVariableOrWriteNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil), name_loc: T.unsafe(nil), operator_loc: T.unsafe(nil), value: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#6880
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, name: Symbol, name_loc: Location, operator_loc: Location, value: Prism::node }
  #
  # source://prism//lib/prism/node.rb#6903
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # source://prism//lib/prism/desugar_compiler.rb#206
  def desugar; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#6933
  sig { override.returns(String) }
  def inspect; end

  # attr_reader name: Symbol
  #
  # source://prism//lib/prism/node.rb#6908
  sig { returns(Symbol) }
  def name; end

  # attr_reader name_loc: Location
  #
  # source://prism//lib/prism/node.rb#6911
  sig { returns(Prism::Location) }
  def name_loc; end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#6928
  sig { returns(String) }
  def operator; end

  # attr_reader operator_loc: Location
  #
  # source://prism//lib/prism/node.rb#6918
  sig { returns(Prism::Location) }
  def operator_loc; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#6938
  sig { override.returns(Symbol) }
  def type; end

  # attr_reader value: Prism::node
  #
  # source://prism//lib/prism/node.rb#6925
  sig { returns(Prism::Node) }
  def value; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#6943
    def type; end
  end
end

# Represents referencing a global variable.
#
#     $foo
#     ^^^^
#
# source://prism//lib/prism/node.rb#6962
class Prism::GlobalVariableReadNode < ::Prism::Node
  # Initialize a new GlobalVariableReadNode node.
  #
  # @return [GlobalVariableReadNode] a new instance of GlobalVariableReadNode
  #
  # source://prism//lib/prism/node.rb#6964
  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol).void }
  def initialize(source, node_id, location, flags, name); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#7029
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#6973
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#6978
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#6988
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#6983
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?name: Symbol) -> GlobalVariableReadNode
  #
  # source://prism//lib/prism/node.rb#6993
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol
    ).returns(Prism::GlobalVariableReadNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#6978
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, name: Symbol }
  #
  # source://prism//lib/prism/node.rb#7001
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#7013
  sig { override.returns(String) }
  def inspect; end

  # The name of the global variable, which is a `$` followed by an [identifier](https://github.com/ruby/prism/blob/main/docs/parsing_rules.md#identifier). Alternatively, it can be one of the special global variables designated by a symbol.
  #
  #     $foo   # name `:$foo`
  #
  #     $_Test # name `:$_Test`
  #
  # source://prism//lib/prism/node.rb#7010
  sig { returns(Symbol) }
  def name; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#7018
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#7023
    def type; end
  end
end

# Represents writing to a global variable in a context that doesn't have an explicit value.
#
#     $foo, $bar = baz
#     ^^^^  ^^^^
#
# source://prism//lib/prism/node.rb#7039
class Prism::GlobalVariableTargetNode < ::Prism::Node
  # Initialize a new GlobalVariableTargetNode node.
  #
  # @return [GlobalVariableTargetNode] a new instance of GlobalVariableTargetNode
  #
  # source://prism//lib/prism/node.rb#7041
  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol).void }
  def initialize(source, node_id, location, flags, name); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#7102
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#7050
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#7055
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#7065
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#7060
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?name: Symbol) -> GlobalVariableTargetNode
  #
  # source://prism//lib/prism/node.rb#7070
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol
    ).returns(Prism::GlobalVariableTargetNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#7055
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, name: Symbol }
  #
  # source://prism//lib/prism/node.rb#7078
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#7086
  sig { override.returns(String) }
  def inspect; end

  # attr_reader name: Symbol
  #
  # source://prism//lib/prism/node.rb#7083
  sig { returns(Symbol) }
  def name; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#7091
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#7096
    def type; end
  end
end

# Represents writing to a global variable.
#
#     $foo = 1
#     ^^^^^^^^
#
# source://prism//lib/prism/node.rb#7112
class Prism::GlobalVariableWriteNode < ::Prism::Node
  # Initialize a new GlobalVariableWriteNode node.
  #
  # @return [GlobalVariableWriteNode] a new instance of GlobalVariableWriteNode
  #
  # source://prism//lib/prism/node.rb#7114
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      name_loc: Prism::Location,
      value: Prism::Node,
      operator_loc: Prism::Location
    ).void
  end
  def initialize(source, node_id, location, flags, name, name_loc, value, operator_loc); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#7216
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#7126
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#7131
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#7141
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#7136
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?name: Symbol, ?name_loc: Location, ?value: Prism::node, ?operator_loc: Location) -> GlobalVariableWriteNode
  #
  # source://prism//lib/prism/node.rb#7146
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      name_loc: Prism::Location,
      value: Prism::Node,
      operator_loc: Prism::Location
    ).returns(Prism::GlobalVariableWriteNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil), name_loc: T.unsafe(nil), value: T.unsafe(nil), operator_loc: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#7131
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, name: Symbol, name_loc: Location, value: Prism::node, operator_loc: Location }
  #
  # source://prism//lib/prism/node.rb#7154
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#7200
  sig { override.returns(String) }
  def inspect; end

  # The name of the global variable, which is a `$` followed by an [identifier](https://github.com/ruby/prism/blob/main/docs/parsing_rules.md#identifier). Alternatively, it can be one of the special global variables designated by a symbol.
  #
  #     $foo = :bar  # name `:$foo`
  #
  #     $_Test = 123 # name `:$_Test`
  #
  # source://prism//lib/prism/node.rb#7163
  sig { returns(Symbol) }
  def name; end

  # The location of the global variable's name.
  #
  #     $foo = :bar
  #     ^^^^
  #
  # source://prism//lib/prism/node.rb#7169
  sig { returns(Prism::Location) }
  def name_loc; end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#7195
  sig { returns(String) }
  def operator; end

  # The location of the `=` operator.
  #
  #     $foo = :bar
  #          ^
  #
  # source://prism//lib/prism/node.rb#7188
  sig { returns(Prism::Location) }
  def operator_loc; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#7205
  sig { override.returns(Symbol) }
  def type; end

  # The value to write to the global variable. It can be any [non-void expression](https://github.com/ruby/prism/blob/main/docs/parsing_rules.md#non-void-expression).
  #
  #     $foo = :bar
  #            ^^^^
  #
  #     $-xyz = 123
  #             ^^^
  #
  # source://prism//lib/prism/node.rb#7182
  sig { returns(Prism::Node) }
  def value; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#7210
    def type; end
  end
end

# Represents a hash literal.
#
#     { a => b }
#     ^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#7229
class Prism::HashNode < ::Prism::Node
  # Initialize a new HashNode node.
  #
  # @return [HashNode] a new instance of HashNode
  #
  # source://prism//lib/prism/node.rb#7231
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      opening_loc: Prism::Location,
      elements: T::Array[T.any(Prism::AssocNode, Prism::AssocSplatNode)],
      closing_loc: Prism::Location
    ).void
  end
  def initialize(source, node_id, location, flags, opening_loc, elements, closing_loc); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#7330
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#7242
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#7247
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def closing: () -> String
  #
  # source://prism//lib/prism/node.rb#7309
  sig { returns(String) }
  def closing; end

  # The location of the closing brace.
  #
  #     { a => b }
  #              ^
  #
  # source://prism//lib/prism/node.rb#7297
  sig { returns(Prism::Location) }
  def closing_loc; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#7257
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#7252
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?opening_loc: Location, ?elements: Array[AssocNode | AssocSplatNode], ?closing_loc: Location) -> HashNode
  #
  # source://prism//lib/prism/node.rb#7262
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      opening_loc: Prism::Location,
      elements: T::Array[T.any(Prism::AssocNode, Prism::AssocSplatNode)],
      closing_loc: Prism::Location
    ).returns(Prism::HashNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), opening_loc: T.unsafe(nil), elements: T.unsafe(nil), closing_loc: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#7247
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, opening_loc: Location, elements: Array[AssocNode | AssocSplatNode], closing_loc: Location }
  #
  # source://prism//lib/prism/node.rb#7270
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # The elements of the hash. These can be either `AssocNode`s or `AssocSplatNode`s.
  #
  #     { a: b }
  #       ^^^^
  #
  #     { **foo }
  #       ^^^^^
  #
  # source://prism//lib/prism/node.rb#7291
  sig { returns(T::Array[T.any(Prism::AssocNode, Prism::AssocSplatNode)]) }
  def elements; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#7314
  sig { override.returns(String) }
  def inspect; end

  # def opening: () -> String
  #
  # source://prism//lib/prism/node.rb#7304
  sig { returns(String) }
  def opening; end

  # The location of the opening brace.
  #
  #     { a => b }
  #     ^
  #
  # source://prism//lib/prism/node.rb#7278
  sig { returns(Prism::Location) }
  def opening_loc; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#7319
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#7324
    def type; end
  end
end

# Represents a hash pattern in pattern matching.
#
#     foo => { a: 1, b: 2 }
#            ^^^^^^^^^^^^^^
#
#     foo => { a: 1, b: 2, **c }
#            ^^^^^^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#7346
class Prism::HashPatternNode < ::Prism::Node
  # Initialize a new HashPatternNode node.
  #
  # @return [HashPatternNode] a new instance of HashPatternNode
  #
  # source://prism//lib/prism/node.rb#7348
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      constant: T.nilable(T.any(Prism::ConstantReadNode, Prism::ConstantPathNode)),
      elements: T::Array[Prism::AssocNode],
      rest: T.nilable(T.any(Prism::AssocSplatNode, Prism::NoKeywordsParameterNode)),
      opening_loc: T.nilable(Prism::Location),
      closing_loc: T.nilable(Prism::Location)
    ).void
  end
  def initialize(source, node_id, location, flags, constant, elements, rest, opening_loc, closing_loc); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#7459
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#7361
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#7366
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def closing: () -> String?
  #
  # source://prism//lib/prism/node.rb#7438
  sig { returns(T.nilable(String)) }
  def closing; end

  # attr_reader closing_loc: Location?
  #
  # source://prism//lib/prism/node.rb#7420
  sig { returns(T.nilable(Prism::Location)) }
  def closing_loc; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#7380
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#7371
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # attr_reader constant: ConstantReadNode | ConstantPathNode | nil
  #
  # source://prism//lib/prism/node.rb#7398
  sig { returns(T.nilable(T.any(Prism::ConstantReadNode, Prism::ConstantPathNode))) }
  def constant; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?constant: ConstantReadNode | ConstantPathNode | nil, ?elements: Array[AssocNode], ?rest: AssocSplatNode | NoKeywordsParameterNode | nil, ?opening_loc: Location?, ?closing_loc: Location?) -> HashPatternNode
  #
  # source://prism//lib/prism/node.rb#7385
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      constant: T.nilable(T.any(Prism::ConstantReadNode, Prism::ConstantPathNode)),
      elements: T::Array[Prism::AssocNode],
      rest: T.nilable(T.any(Prism::AssocSplatNode, Prism::NoKeywordsParameterNode)),
      opening_loc: T.nilable(Prism::Location),
      closing_loc: T.nilable(Prism::Location)
    ).returns(Prism::HashPatternNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), constant: T.unsafe(nil), elements: T.unsafe(nil), rest: T.unsafe(nil), opening_loc: T.unsafe(nil), closing_loc: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#7366
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, constant: ConstantReadNode | ConstantPathNode | nil, elements: Array[AssocNode], rest: AssocSplatNode | NoKeywordsParameterNode | nil, opening_loc: Location?, closing_loc: Location? }
  #
  # source://prism//lib/prism/node.rb#7393
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # attr_reader elements: Array[AssocNode]
  #
  # source://prism//lib/prism/node.rb#7401
  sig { returns(T::Array[Prism::AssocNode]) }
  def elements; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#7443
  sig { override.returns(String) }
  def inspect; end

  # def opening: () -> String?
  #
  # source://prism//lib/prism/node.rb#7433
  sig { returns(T.nilable(String)) }
  def opening; end

  # attr_reader opening_loc: Location?
  #
  # source://prism//lib/prism/node.rb#7407
  sig { returns(T.nilable(Prism::Location)) }
  def opening_loc; end

  # attr_reader rest: AssocSplatNode | NoKeywordsParameterNode | nil
  #
  # source://prism//lib/prism/node.rb#7404
  sig { returns(T.nilable(T.any(Prism::AssocSplatNode, Prism::NoKeywordsParameterNode))) }
  def rest; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#7448
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#7453
    def type; end
  end
end

# source://prism//lib/prism/node_ext.rb#52
module Prism::HeredocQuery
  # Returns true if this node was represented as a heredoc in the source code.
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node_ext.rb#54
  def heredoc?; end
end

# Represents the use of the `if` keyword, either in the block form or the modifier form, or a ternary expression.
#
#     bar if foo
#     ^^^^^^^^^^
#
#     if foo then bar end
#     ^^^^^^^^^^^^^^^^^^^
#
#     foo ? bar : baz
#     ^^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#7480
class Prism::IfNode < ::Prism::Node
  # Initialize a new IfNode node.
  #
  # @return [IfNode] a new instance of IfNode
  #
  # source://prism//lib/prism/node.rb#7482
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      if_keyword_loc: T.nilable(Prism::Location),
      predicate: Prism::Node,
      then_keyword_loc: T.nilable(Prism::Location),
      statements: T.nilable(Prism::StatementsNode),
      subsequent: T.nilable(T.any(Prism::ElseNode, Prism::IfNode)),
      end_keyword_loc: T.nilable(Prism::Location)
    ).void
  end
  def initialize(source, node_id, location, flags, if_keyword_loc, predicate, then_keyword_loc, statements, subsequent, end_keyword_loc); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#7658
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#7496
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#7501
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#7515
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#7506
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # Returns the subsequent if/elsif/else clause of the if node. This method is
  # deprecated in favor of #subsequent.
  #
  # source://prism//lib/prism/node_ext.rb#485
  def consequent; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?if_keyword_loc: Location?, ?predicate: Prism::node, ?then_keyword_loc: Location?, ?statements: StatementsNode?, ?subsequent: ElseNode | IfNode | nil, ?end_keyword_loc: Location?) -> IfNode
  #
  # source://prism//lib/prism/node.rb#7520
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      if_keyword_loc: T.nilable(Prism::Location),
      predicate: Prism::Node,
      then_keyword_loc: T.nilable(Prism::Location),
      statements: T.nilable(Prism::StatementsNode),
      subsequent: T.nilable(T.any(Prism::ElseNode, Prism::IfNode)),
      end_keyword_loc: T.nilable(Prism::Location)
    ).returns(Prism::IfNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), if_keyword_loc: T.unsafe(nil), predicate: T.unsafe(nil), then_keyword_loc: T.unsafe(nil), statements: T.unsafe(nil), subsequent: T.unsafe(nil), end_keyword_loc: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#7501
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, if_keyword_loc: Location?, predicate: Prism::node, then_keyword_loc: Location?, statements: StatementsNode?, subsequent: ElseNode | IfNode | nil, end_keyword_loc: Location? }
  #
  # source://prism//lib/prism/node.rb#7528
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def end_keyword: () -> String?
  #
  # source://prism//lib/prism/node.rb#7637
  sig { returns(T.nilable(String)) }
  def end_keyword; end

  # The location of the `end` keyword if present, `nil` otherwise.
  #
  #     if foo
  #       bar
  #     end
  #     ^^^
  #
  # source://prism//lib/prism/node.rb#7614
  sig { returns(T.nilable(Prism::Location)) }
  def end_keyword_loc; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def if_keyword: () -> String?
  #
  # source://prism//lib/prism/node.rb#7627
  sig { returns(T.nilable(String)) }
  def if_keyword; end

  # The location of the `if` keyword if present.
  #
  #     bar if foo
  #         ^^
  #
  # The `if_keyword_loc` field will be `nil` when the `IfNode` represents a ternary expression.
  #
  # source://prism//lib/prism/node.rb#7538
  sig { returns(T.nilable(Prism::Location)) }
  def if_keyword_loc; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#7642
  sig { override.returns(String) }
  def inspect; end

  # source://prism//lib/prism/parse_result/newlines.rb#91
  def newline_flag!(lines); end

  # The node for the condition the `IfNode` is testing.
  #
  #     if foo
  #        ^^^
  #       bar
  #     end
  #
  #     bar if foo
  #            ^^^
  #
  #     foo ? bar : baz
  #     ^^^
  #
  # source://prism//lib/prism/node.rb#7562
  sig { returns(Prism::Node) }
  def predicate; end

  # Represents the body of statements that will be executed when the predicate is evaluated as truthy. Will be `nil` when no body is provided.
  #
  #     if foo
  #       bar
  #       ^^^
  #       baz
  #       ^^^
  #     end
  #
  # source://prism//lib/prism/node.rb#7591
  sig { returns(T.nilable(Prism::StatementsNode)) }
  def statements; end

  # Represents an `ElseNode` or an `IfNode` when there is an `else` or an `elsif` in the `if` statement.
  #
  #     if foo
  #       bar
  #     elsif baz
  #     ^^^^^^^^^
  #       qux
  #       ^^^
  #     end
  #     ^^^
  #
  #     if foo then bar else baz end
  #                     ^^^^^^^^^^^^
  #
  # source://prism//lib/prism/node.rb#7606
  sig { returns(T.nilable(T.any(Prism::ElseNode, Prism::IfNode))) }
  def subsequent; end

  # def then_keyword: () -> String?
  #
  # source://prism//lib/prism/node.rb#7632
  sig { returns(T.nilable(String)) }
  def then_keyword; end

  # The location of the `then` keyword (if present) or the `?` in a ternary expression, `nil` otherwise.
  #
  #     if foo then bar end
  #            ^^^^
  #
  #     a ? b : c
  #       ^
  #
  # source://prism//lib/prism/node.rb#7571
  sig { returns(T.nilable(Prism::Location)) }
  def then_keyword_loc; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#7647
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#7652
    def type; end
  end
end

# Represents an imaginary number literal.
#
#     1.0i
#     ^^^^
#
# source://prism//lib/prism/node.rb#7673
class Prism::ImaginaryNode < ::Prism::Node
  # Initialize a new ImaginaryNode node.
  #
  # @return [ImaginaryNode] a new instance of ImaginaryNode
  #
  # source://prism//lib/prism/node.rb#7675
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      numeric: T.any(Prism::FloatNode, Prism::IntegerNode, Prism::RationalNode)
    ).void
  end
  def initialize(source, node_id, location, flags, numeric); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#7736
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#7684
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#7689
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#7699
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#7694
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?numeric: FloatNode | IntegerNode | RationalNode) -> ImaginaryNode
  #
  # source://prism//lib/prism/node.rb#7704
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      numeric: T.any(Prism::FloatNode, Prism::IntegerNode, Prism::RationalNode)
    ).returns(Prism::ImaginaryNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), numeric: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#7689
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, numeric: FloatNode | IntegerNode | RationalNode }
  #
  # source://prism//lib/prism/node.rb#7712
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#7720
  sig { override.returns(String) }
  def inspect; end

  # attr_reader numeric: FloatNode | IntegerNode | RationalNode
  #
  # source://prism//lib/prism/node.rb#7717
  sig { returns(T.any(Prism::FloatNode, Prism::IntegerNode, Prism::RationalNode)) }
  def numeric; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#7725
  sig { override.returns(Symbol) }
  def type; end

  # Returns the value of the node as a Ruby Complex.
  #
  # source://prism//lib/prism/node_ext.rb#107
  sig { returns(Complex) }
  def value; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#7730
    def type; end
  end
end

# Represents a node that is implicitly being added to the tree but doesn't correspond directly to a node in the source.
#
#     { foo: }
#       ^^^^
#
#     { Foo: }
#       ^^^^
#
#     foo in { bar: }
#              ^^^^
#
# source://prism//lib/prism/node.rb#7752
class Prism::ImplicitNode < ::Prism::Node
  # Initialize a new ImplicitNode node.
  #
  # @return [ImplicitNode] a new instance of ImplicitNode
  #
  # source://prism//lib/prism/node.rb#7754
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      value: T.any(Prism::LocalVariableReadNode, Prism::CallNode, Prism::ConstantReadNode, Prism::LocalVariableTargetNode)
    ).void
  end
  def initialize(source, node_id, location, flags, value); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#7815
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#7763
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#7768
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#7778
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#7773
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?value: LocalVariableReadNode | CallNode | ConstantReadNode | LocalVariableTargetNode) -> ImplicitNode
  #
  # source://prism//lib/prism/node.rb#7783
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      value: T.any(Prism::LocalVariableReadNode, Prism::CallNode, Prism::ConstantReadNode, Prism::LocalVariableTargetNode)
    ).returns(Prism::ImplicitNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), value: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#7768
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, value: LocalVariableReadNode | CallNode | ConstantReadNode | LocalVariableTargetNode }
  #
  # source://prism//lib/prism/node.rb#7791
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#7799
  sig { override.returns(String) }
  def inspect; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#7804
  sig { override.returns(Symbol) }
  def type; end

  # attr_reader value: LocalVariableReadNode | CallNode | ConstantReadNode | LocalVariableTargetNode
  #
  # source://prism//lib/prism/node.rb#7796
  sig do
    returns(T.any(Prism::LocalVariableReadNode, Prism::CallNode, Prism::ConstantReadNode, Prism::LocalVariableTargetNode))
  end
  def value; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#7809
    def type; end
  end
end

# Represents using a trailing comma to indicate an implicit rest parameter.
#
#     foo { |bar,| }
#               ^
#
#     foo in [bar,]
#                ^
#
#     for foo, in bar do end
#            ^
#
#     foo, = bar
#        ^
#
# source://prism//lib/prism/node.rb#7834
class Prism::ImplicitRestNode < ::Prism::Node
  # Initialize a new ImplicitRestNode node.
  #
  # @return [ImplicitRestNode] a new instance of ImplicitRestNode
  #
  # source://prism//lib/prism/node.rb#7836
  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer).void }
  def initialize(source, node_id, location, flags); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#7893
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#7844
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#7849
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#7859
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#7854
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer) -> ImplicitRestNode
  #
  # source://prism//lib/prism/node.rb#7864
  sig { params(node_id: Integer, location: Prism::Location, flags: Integer).returns(Prism::ImplicitRestNode) }
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#7849
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location }
  #
  # source://prism//lib/prism/node.rb#7872
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#7877
  sig { override.returns(String) }
  def inspect; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#7882
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#7887
    def type; end
  end
end

# Represents the use of the `in` keyword in a case statement.
#
#     case a; in b then c end
#             ^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#7902
class Prism::InNode < ::Prism::Node
  # Initialize a new InNode node.
  #
  # @return [InNode] a new instance of InNode
  #
  # source://prism//lib/prism/node.rb#7904
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      pattern: Prism::Node,
      statements: T.nilable(Prism::StatementsNode),
      in_loc: Prism::Location,
      then_loc: T.nilable(Prism::Location)
    ).void
  end
  def initialize(source, node_id, location, flags, pattern, statements, in_loc, then_loc); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#8004
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#7916
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#7921
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#7934
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#7926
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?pattern: Prism::node, ?statements: StatementsNode?, ?in_loc: Location, ?then_loc: Location?) -> InNode
  #
  # source://prism//lib/prism/node.rb#7939
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      pattern: Prism::Node,
      statements: T.nilable(Prism::StatementsNode),
      in_loc: Prism::Location,
      then_loc: T.nilable(Prism::Location)
    ).returns(Prism::InNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), pattern: T.unsafe(nil), statements: T.unsafe(nil), in_loc: T.unsafe(nil), then_loc: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#7921
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, pattern: Prism::node, statements: StatementsNode?, in_loc: Location, then_loc: Location? }
  #
  # source://prism//lib/prism/node.rb#7947
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def in: () -> String
  #
  # source://prism//lib/prism/node.rb#7978
  sig { returns(String) }
  def in; end

  # attr_reader in_loc: Location
  #
  # source://prism//lib/prism/node.rb#7958
  sig { returns(Prism::Location) }
  def in_loc; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#7988
  sig { override.returns(String) }
  def inspect; end

  # attr_reader pattern: Prism::node
  #
  # source://prism//lib/prism/node.rb#7952
  sig { returns(Prism::Node) }
  def pattern; end

  # attr_reader statements: StatementsNode?
  #
  # source://prism//lib/prism/node.rb#7955
  sig { returns(T.nilable(Prism::StatementsNode)) }
  def statements; end

  # def then: () -> String?
  #
  # source://prism//lib/prism/node.rb#7983
  sig { returns(T.nilable(String)) }
  def then; end

  # attr_reader then_loc: Location?
  #
  # source://prism//lib/prism/node.rb#7965
  sig { returns(T.nilable(Prism::Location)) }
  def then_loc; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#7993
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#7998
    def type; end
  end
end

# Represents the use of the `&&=` operator on a call to the `[]` method.
#
#     foo.bar[baz] &&= value
#     ^^^^^^^^^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#8017
class Prism::IndexAndWriteNode < ::Prism::Node
  # Initialize a new IndexAndWriteNode node.
  #
  # @return [IndexAndWriteNode] a new instance of IndexAndWriteNode
  #
  # source://prism//lib/prism/node.rb#8019
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      receiver: T.nilable(Prism::Node),
      call_operator_loc: T.nilable(Prism::Location),
      opening_loc: Prism::Location,
      arguments: T.nilable(Prism::ArgumentsNode),
      closing_loc: Prism::Location,
      block: T.nilable(Prism::BlockArgumentNode),
      operator_loc: Prism::Location,
      value: Prism::Node
    ).void
  end
  def initialize(source, node_id, location, flags, receiver, call_operator_loc, opening_loc, arguments, closing_loc, block, operator_loc, value); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#8175
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#8035
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # attr_reader arguments: ArgumentsNode?
  #
  # source://prism//lib/prism/node.rb#8116
  sig { returns(T.nilable(Prism::ArgumentsNode)) }
  def arguments; end

  # def attribute_write?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#8083
  sig { returns(T::Boolean) }
  def attribute_write?; end

  # attr_reader block: BlockArgumentNode?
  #
  # source://prism//lib/prism/node.rb#8126
  sig { returns(T.nilable(Prism::BlockArgumentNode)) }
  def block; end

  # def call_operator: () -> String?
  #
  # source://prism//lib/prism/node.rb#8139
  sig { returns(T.nilable(String)) }
  def call_operator; end

  # attr_reader call_operator_loc: Location?
  #
  # source://prism//lib/prism/node.rb#8096
  sig { returns(T.nilable(Prism::Location)) }
  def call_operator_loc; end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#8040
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def closing: () -> String
  #
  # source://prism//lib/prism/node.rb#8149
  sig { returns(String) }
  def closing; end

  # attr_reader closing_loc: Location
  #
  # source://prism//lib/prism/node.rb#8119
  sig { returns(Prism::Location) }
  def closing_loc; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#8055
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#8045
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?receiver: Prism::node?, ?call_operator_loc: Location?, ?opening_loc: Location, ?arguments: ArgumentsNode?, ?closing_loc: Location, ?block: BlockArgumentNode?, ?operator_loc: Location, ?value: Prism::node) -> IndexAndWriteNode
  #
  # source://prism//lib/prism/node.rb#8060
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      receiver: T.nilable(Prism::Node),
      call_operator_loc: T.nilable(Prism::Location),
      opening_loc: Prism::Location,
      arguments: T.nilable(Prism::ArgumentsNode),
      closing_loc: Prism::Location,
      block: T.nilable(Prism::BlockArgumentNode),
      operator_loc: Prism::Location,
      value: Prism::Node
    ).returns(Prism::IndexAndWriteNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), receiver: T.unsafe(nil), call_operator_loc: T.unsafe(nil), opening_loc: T.unsafe(nil), arguments: T.unsafe(nil), closing_loc: T.unsafe(nil), block: T.unsafe(nil), operator_loc: T.unsafe(nil), value: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#8040
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, receiver: Prism::node?, call_operator_loc: Location?, opening_loc: Location, arguments: ArgumentsNode?, closing_loc: Location, block: BlockArgumentNode?, operator_loc: Location, value: Prism::node }
  #
  # source://prism//lib/prism/node.rb#8068
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def ignore_visibility?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#8088
  sig { returns(T::Boolean) }
  def ignore_visibility?; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#8159
  sig { override.returns(String) }
  def inspect; end

  # def opening: () -> String
  #
  # source://prism//lib/prism/node.rb#8144
  sig { returns(String) }
  def opening; end

  # attr_reader opening_loc: Location
  #
  # source://prism//lib/prism/node.rb#8109
  sig { returns(Prism::Location) }
  def opening_loc; end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#8154
  sig { returns(String) }
  def operator; end

  # attr_reader operator_loc: Location
  #
  # source://prism//lib/prism/node.rb#8129
  sig { returns(Prism::Location) }
  def operator_loc; end

  # attr_reader receiver: Prism::node?
  #
  # source://prism//lib/prism/node.rb#8093
  sig { returns(T.nilable(Prism::Node)) }
  def receiver; end

  # def safe_navigation?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#8073
  sig { returns(T::Boolean) }
  def safe_navigation?; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#8164
  sig { override.returns(Symbol) }
  def type; end

  # attr_reader value: Prism::node
  #
  # source://prism//lib/prism/node.rb#8136
  sig { returns(Prism::Node) }
  def value; end

  # def variable_call?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#8078
  sig { returns(T::Boolean) }
  def variable_call?; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#8169
    def type; end
  end
end

# Represents the use of an assignment operator on a call to `[]`.
#
#     foo.bar[baz] += value
#     ^^^^^^^^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#8193
class Prism::IndexOperatorWriteNode < ::Prism::Node
  # Initialize a new IndexOperatorWriteNode node.
  #
  # @return [IndexOperatorWriteNode] a new instance of IndexOperatorWriteNode
  #
  # source://prism//lib/prism/node.rb#8195
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      receiver: T.nilable(Prism::Node),
      call_operator_loc: T.nilable(Prism::Location),
      opening_loc: Prism::Location,
      arguments: T.nilable(Prism::ArgumentsNode),
      closing_loc: Prism::Location,
      block: T.nilable(Prism::BlockArgumentNode),
      binary_operator: Symbol,
      binary_operator_loc: Prism::Location,
      value: Prism::Node
    ).void
  end
  def initialize(source, node_id, location, flags, receiver, call_operator_loc, opening_loc, arguments, closing_loc, block, binary_operator, binary_operator_loc, value); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#8350
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#8212
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # attr_reader arguments: ArgumentsNode?
  #
  # source://prism//lib/prism/node.rb#8293
  sig { returns(T.nilable(Prism::ArgumentsNode)) }
  def arguments; end

  # def attribute_write?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#8260
  sig { returns(T::Boolean) }
  def attribute_write?; end

  # attr_reader binary_operator: Symbol
  #
  # source://prism//lib/prism/node.rb#8306
  sig { returns(Symbol) }
  def binary_operator; end

  # attr_reader binary_operator_loc: Location
  #
  # source://prism//lib/prism/node.rb#8309
  sig { returns(Prism::Location) }
  def binary_operator_loc; end

  # attr_reader block: BlockArgumentNode?
  #
  # source://prism//lib/prism/node.rb#8303
  sig { returns(T.nilable(Prism::BlockArgumentNode)) }
  def block; end

  # def call_operator: () -> String?
  #
  # source://prism//lib/prism/node.rb#8319
  sig { returns(T.nilable(String)) }
  def call_operator; end

  # attr_reader call_operator_loc: Location?
  #
  # source://prism//lib/prism/node.rb#8273
  sig { returns(T.nilable(Prism::Location)) }
  def call_operator_loc; end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#8217
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def closing: () -> String
  #
  # source://prism//lib/prism/node.rb#8329
  sig { returns(String) }
  def closing; end

  # attr_reader closing_loc: Location
  #
  # source://prism//lib/prism/node.rb#8296
  sig { returns(Prism::Location) }
  def closing_loc; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#8232
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#8222
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?receiver: Prism::node?, ?call_operator_loc: Location?, ?opening_loc: Location, ?arguments: ArgumentsNode?, ?closing_loc: Location, ?block: BlockArgumentNode?, ?binary_operator: Symbol, ?binary_operator_loc: Location, ?value: Prism::node) -> IndexOperatorWriteNode
  #
  # source://prism//lib/prism/node.rb#8237
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      receiver: T.nilable(Prism::Node),
      call_operator_loc: T.nilable(Prism::Location),
      opening_loc: Prism::Location,
      arguments: T.nilable(Prism::ArgumentsNode),
      closing_loc: Prism::Location,
      block: T.nilable(Prism::BlockArgumentNode),
      binary_operator: Symbol,
      binary_operator_loc: Prism::Location,
      value: Prism::Node
    ).returns(Prism::IndexOperatorWriteNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), receiver: T.unsafe(nil), call_operator_loc: T.unsafe(nil), opening_loc: T.unsafe(nil), arguments: T.unsafe(nil), closing_loc: T.unsafe(nil), block: T.unsafe(nil), binary_operator: T.unsafe(nil), binary_operator_loc: T.unsafe(nil), value: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#8217
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, receiver: Prism::node?, call_operator_loc: Location?, opening_loc: Location, arguments: ArgumentsNode?, closing_loc: Location, block: BlockArgumentNode?, binary_operator: Symbol, binary_operator_loc: Location, value: Prism::node }
  #
  # source://prism//lib/prism/node.rb#8245
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def ignore_visibility?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#8265
  sig { returns(T::Boolean) }
  def ignore_visibility?; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#8334
  sig { override.returns(String) }
  def inspect; end

  # def opening: () -> String
  #
  # source://prism//lib/prism/node.rb#8324
  sig { returns(String) }
  def opening; end

  # attr_reader opening_loc: Location
  #
  # source://prism//lib/prism/node.rb#8286
  sig { returns(Prism::Location) }
  def opening_loc; end

  # Returns the binary operator used to modify the receiver. This method is
  # deprecated in favor of #binary_operator.
  #
  # source://prism//lib/prism/node_ext.rb#419
  def operator; end

  # Returns the location of the binary operator used to modify the receiver.
  # This method is deprecated in favor of #binary_operator_loc.
  #
  # source://prism//lib/prism/node_ext.rb#426
  def operator_loc; end

  # attr_reader receiver: Prism::node?
  #
  # source://prism//lib/prism/node.rb#8270
  sig { returns(T.nilable(Prism::Node)) }
  def receiver; end

  # def safe_navigation?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#8250
  sig { returns(T::Boolean) }
  def safe_navigation?; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#8339
  sig { override.returns(Symbol) }
  def type; end

  # attr_reader value: Prism::node
  #
  # source://prism//lib/prism/node.rb#8316
  sig { returns(Prism::Node) }
  def value; end

  # def variable_call?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#8255
  sig { returns(T::Boolean) }
  def variable_call?; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#8344
    def type; end
  end
end

# Represents the use of the `||=` operator on a call to `[]`.
#
#     foo.bar[baz] ||= value
#     ^^^^^^^^^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#8369
class Prism::IndexOrWriteNode < ::Prism::Node
  # Initialize a new IndexOrWriteNode node.
  #
  # @return [IndexOrWriteNode] a new instance of IndexOrWriteNode
  #
  # source://prism//lib/prism/node.rb#8371
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      receiver: T.nilable(Prism::Node),
      call_operator_loc: T.nilable(Prism::Location),
      opening_loc: Prism::Location,
      arguments: T.nilable(Prism::ArgumentsNode),
      closing_loc: Prism::Location,
      block: T.nilable(Prism::BlockArgumentNode),
      operator_loc: Prism::Location,
      value: Prism::Node
    ).void
  end
  def initialize(source, node_id, location, flags, receiver, call_operator_loc, opening_loc, arguments, closing_loc, block, operator_loc, value); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#8527
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#8387
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # attr_reader arguments: ArgumentsNode?
  #
  # source://prism//lib/prism/node.rb#8468
  sig { returns(T.nilable(Prism::ArgumentsNode)) }
  def arguments; end

  # def attribute_write?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#8435
  sig { returns(T::Boolean) }
  def attribute_write?; end

  # attr_reader block: BlockArgumentNode?
  #
  # source://prism//lib/prism/node.rb#8478
  sig { returns(T.nilable(Prism::BlockArgumentNode)) }
  def block; end

  # def call_operator: () -> String?
  #
  # source://prism//lib/prism/node.rb#8491
  sig { returns(T.nilable(String)) }
  def call_operator; end

  # attr_reader call_operator_loc: Location?
  #
  # source://prism//lib/prism/node.rb#8448
  sig { returns(T.nilable(Prism::Location)) }
  def call_operator_loc; end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#8392
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def closing: () -> String
  #
  # source://prism//lib/prism/node.rb#8501
  sig { returns(String) }
  def closing; end

  # attr_reader closing_loc: Location
  #
  # source://prism//lib/prism/node.rb#8471
  sig { returns(Prism::Location) }
  def closing_loc; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#8407
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#8397
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?receiver: Prism::node?, ?call_operator_loc: Location?, ?opening_loc: Location, ?arguments: ArgumentsNode?, ?closing_loc: Location, ?block: BlockArgumentNode?, ?operator_loc: Location, ?value: Prism::node) -> IndexOrWriteNode
  #
  # source://prism//lib/prism/node.rb#8412
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      receiver: T.nilable(Prism::Node),
      call_operator_loc: T.nilable(Prism::Location),
      opening_loc: Prism::Location,
      arguments: T.nilable(Prism::ArgumentsNode),
      closing_loc: Prism::Location,
      block: T.nilable(Prism::BlockArgumentNode),
      operator_loc: Prism::Location,
      value: Prism::Node
    ).returns(Prism::IndexOrWriteNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), receiver: T.unsafe(nil), call_operator_loc: T.unsafe(nil), opening_loc: T.unsafe(nil), arguments: T.unsafe(nil), closing_loc: T.unsafe(nil), block: T.unsafe(nil), operator_loc: T.unsafe(nil), value: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#8392
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, receiver: Prism::node?, call_operator_loc: Location?, opening_loc: Location, arguments: ArgumentsNode?, closing_loc: Location, block: BlockArgumentNode?, operator_loc: Location, value: Prism::node }
  #
  # source://prism//lib/prism/node.rb#8420
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def ignore_visibility?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#8440
  sig { returns(T::Boolean) }
  def ignore_visibility?; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#8511
  sig { override.returns(String) }
  def inspect; end

  # def opening: () -> String
  #
  # source://prism//lib/prism/node.rb#8496
  sig { returns(String) }
  def opening; end

  # attr_reader opening_loc: Location
  #
  # source://prism//lib/prism/node.rb#8461
  sig { returns(Prism::Location) }
  def opening_loc; end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#8506
  sig { returns(String) }
  def operator; end

  # attr_reader operator_loc: Location
  #
  # source://prism//lib/prism/node.rb#8481
  sig { returns(Prism::Location) }
  def operator_loc; end

  # attr_reader receiver: Prism::node?
  #
  # source://prism//lib/prism/node.rb#8445
  sig { returns(T.nilable(Prism::Node)) }
  def receiver; end

  # def safe_navigation?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#8425
  sig { returns(T::Boolean) }
  def safe_navigation?; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#8516
  sig { override.returns(Symbol) }
  def type; end

  # attr_reader value: Prism::node
  #
  # source://prism//lib/prism/node.rb#8488
  sig { returns(Prism::Node) }
  def value; end

  # def variable_call?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#8430
  sig { returns(T::Boolean) }
  def variable_call?; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#8521
    def type; end
  end
end

# Represents assigning to an index.
#
#     foo[bar], = 1
#     ^^^^^^^^
#
#     begin
#     rescue => foo[bar]
#               ^^^^^^^^
#     end
#
#     for foo[bar] in baz do end
#         ^^^^^^^^
#
# source://prism//lib/prism/node.rb#8553
class Prism::IndexTargetNode < ::Prism::Node
  # Initialize a new IndexTargetNode node.
  #
  # @return [IndexTargetNode] a new instance of IndexTargetNode
  #
  # source://prism//lib/prism/node.rb#8555
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      receiver: Prism::Node,
      opening_loc: Prism::Location,
      arguments: T.nilable(Prism::ArgumentsNode),
      closing_loc: Prism::Location,
      block: T.nilable(Prism::BlockArgumentNode)
    ).void
  end
  def initialize(source, node_id, location, flags, receiver, opening_loc, arguments, closing_loc, block); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#8674
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#8568
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # attr_reader arguments: ArgumentsNode?
  #
  # source://prism//lib/prism/node.rb#8635
  sig { returns(T.nilable(Prism::ArgumentsNode)) }
  def arguments; end

  # def attribute_write?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#8615
  sig { returns(T::Boolean) }
  def attribute_write?; end

  # attr_reader block: BlockArgumentNode?
  #
  # source://prism//lib/prism/node.rb#8645
  sig { returns(T.nilable(Prism::BlockArgumentNode)) }
  def block; end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#8573
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def closing: () -> String
  #
  # source://prism//lib/prism/node.rb#8653
  sig { returns(String) }
  def closing; end

  # attr_reader closing_loc: Location
  #
  # source://prism//lib/prism/node.rb#8638
  sig { returns(Prism::Location) }
  def closing_loc; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#8587
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#8578
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?receiver: Prism::node, ?opening_loc: Location, ?arguments: ArgumentsNode?, ?closing_loc: Location, ?block: BlockArgumentNode?) -> IndexTargetNode
  #
  # source://prism//lib/prism/node.rb#8592
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      receiver: Prism::Node,
      opening_loc: Prism::Location,
      arguments: T.nilable(Prism::ArgumentsNode),
      closing_loc: Prism::Location,
      block: T.nilable(Prism::BlockArgumentNode)
    ).returns(Prism::IndexTargetNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), receiver: T.unsafe(nil), opening_loc: T.unsafe(nil), arguments: T.unsafe(nil), closing_loc: T.unsafe(nil), block: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#8573
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, receiver: Prism::node, opening_loc: Location, arguments: ArgumentsNode?, closing_loc: Location, block: BlockArgumentNode? }
  #
  # source://prism//lib/prism/node.rb#8600
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def ignore_visibility?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#8620
  sig { returns(T::Boolean) }
  def ignore_visibility?; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#8658
  sig { override.returns(String) }
  def inspect; end

  # def opening: () -> String
  #
  # source://prism//lib/prism/node.rb#8648
  sig { returns(String) }
  def opening; end

  # attr_reader opening_loc: Location
  #
  # source://prism//lib/prism/node.rb#8628
  sig { returns(Prism::Location) }
  def opening_loc; end

  # attr_reader receiver: Prism::node
  #
  # source://prism//lib/prism/node.rb#8625
  sig { returns(Prism::Node) }
  def receiver; end

  # def safe_navigation?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#8605
  sig { returns(T::Boolean) }
  def safe_navigation?; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#8663
  sig { override.returns(Symbol) }
  def type; end

  # def variable_call?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#8610
  sig { returns(T::Boolean) }
  def variable_call?; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#8668
    def type; end
  end
end

# InlineComment objects are the most common. They correspond to comments in
# the source file like this one that start with #.
#
# source://prism//lib/prism/parse_result.rb#529
class Prism::InlineComment < ::Prism::Comment
  # Returns a string representation of this comment.
  #
  # source://prism//lib/prism/parse_result.rb#537
  sig { returns(String) }
  def inspect; end

  # Returns true if this comment happens on the same line as other code and
  # false if the comment is by itself.
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/parse_result.rb#532
  sig { override.returns(T::Boolean) }
  def trailing?; end
end

# This visitor is responsible for composing the strings that get returned by
# the various #inspect methods defined on each of the nodes.
#
# source://prism//lib/prism/inspect_visitor.rb#12
class Prism::InspectVisitor < ::Prism::Visitor
  # Initializes a new instance of the InspectVisitor.
  #
  # @return [InspectVisitor] a new instance of InspectVisitor
  #
  # source://prism//lib/prism/inspect_visitor.rb#35
  sig { params(indent: String).void }
  def initialize(indent = T.unsafe(nil)); end

  # The list of commands that we need to execute in order to compose the
  # final string.
  #
  # source://prism//lib/prism/inspect_visitor.rb#32
  def commands; end

  # Compose the final string.
  #
  # source://prism//lib/prism/inspect_visitor.rb#48
  sig { returns(String) }
  def compose; end

  # The current prefix string.
  #
  # source://prism//lib/prism/inspect_visitor.rb#28
  def indent; end

  # Inspect a AliasGlobalVariableNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#77
  def visit_alias_global_variable_node(node); end

  # Inspect a AliasMethodNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#89
  def visit_alias_method_node(node); end

  # Inspect a AlternationPatternNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#101
  def visit_alternation_pattern_node(node); end

  # Inspect a AndNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#113
  def visit_and_node(node); end

  # Inspect a ArgumentsNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#125
  def visit_arguments_node(node); end

  # Inspect a ArrayNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#141
  def visit_array_node(node); end

  # Inspect a ArrayPatternNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#159
  def visit_array_pattern_node(node); end

  # Inspect a AssocNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#198
  def visit_assoc_node(node); end

  # Inspect a AssocSplatNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#210
  def visit_assoc_splat_node(node); end

  # Inspect a BackReferenceReadNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#224
  def visit_back_reference_read_node(node); end

  # Inspect a BeginNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#232
  def visit_begin_node(node); end

  # Inspect a BlockArgumentNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#265
  def visit_block_argument_node(node); end

  # Inspect a BlockLocalVariableNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#279
  def visit_block_local_variable_node(node); end

  # Inspect a BlockNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#287
  def visit_block_node(node); end

  # Inspect a BlockParameterNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#309
  def visit_block_parameter_node(node); end

  # Inspect a BlockParametersNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#323
  def visit_block_parameters_node(node); end

  # Inspect a BreakNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#347
  def visit_break_node(node); end

  # Inspect a CallAndWriteNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#361
  def visit_call_and_write_node(node); end

  # Inspect a CallNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#381
  def visit_call_node(node); end

  # Inspect a CallOperatorWriteNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#411
  def visit_call_operator_write_node(node); end

  # Inspect a CallOrWriteNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#432
  def visit_call_or_write_node(node); end

  # Inspect a CallTargetNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#452
  def visit_call_target_node(node); end

  # Inspect a CapturePatternNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#464
  def visit_capture_pattern_node(node); end

  # Inspect a CaseMatchNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#476
  def visit_case_match_node(node); end

  # Inspect a CaseNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#506
  def visit_case_node(node); end

  # Inspect a ClassNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#536
  def visit_class_node(node); end

  # Inspect a ClassVariableAndWriteNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#562
  def visit_class_variable_and_write_node(node); end

  # Inspect a ClassVariableOperatorWriteNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#574
  def visit_class_variable_operator_write_node(node); end

  # Inspect a ClassVariableOrWriteNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#587
  def visit_class_variable_or_write_node(node); end

  # Inspect a ClassVariableReadNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#599
  def visit_class_variable_read_node(node); end

  # Inspect a ClassVariableTargetNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#607
  def visit_class_variable_target_node(node); end

  # Inspect a ClassVariableWriteNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#615
  def visit_class_variable_write_node(node); end

  # Inspect a ConstantAndWriteNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#627
  def visit_constant_and_write_node(node); end

  # Inspect a ConstantOperatorWriteNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#639
  def visit_constant_operator_write_node(node); end

  # Inspect a ConstantOrWriteNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#652
  def visit_constant_or_write_node(node); end

  # Inspect a ConstantPathAndWriteNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#664
  def visit_constant_path_and_write_node(node); end

  # Inspect a ConstantPathNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#676
  def visit_constant_path_node(node); end

  # Inspect a ConstantPathOperatorWriteNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#696
  def visit_constant_path_operator_write_node(node); end

  # Inspect a ConstantPathOrWriteNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#709
  def visit_constant_path_or_write_node(node); end

  # Inspect a ConstantPathTargetNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#721
  def visit_constant_path_target_node(node); end

  # Inspect a ConstantPathWriteNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#741
  def visit_constant_path_write_node(node); end

  # Inspect a ConstantReadNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#753
  def visit_constant_read_node(node); end

  # Inspect a ConstantTargetNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#761
  def visit_constant_target_node(node); end

  # Inspect a ConstantWriteNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#769
  def visit_constant_write_node(node); end

  # Inspect a DefNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#781
  def visit_def_node(node); end

  # Inspect a DefinedNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#815
  def visit_defined_node(node); end

  # Inspect a ElseNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#827
  def visit_else_node(node); end

  # Inspect a EmbeddedStatementsNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#842
  def visit_embedded_statements_node(node); end

  # Inspect a EmbeddedVariableNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#857
  def visit_embedded_variable_node(node); end

  # Inspect a EnsureNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#867
  def visit_ensure_node(node); end

  # Inspect a FalseNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#882
  def visit_false_node(node); end

  # Inspect a FindPatternNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#889
  def visit_find_pattern_node(node); end

  # Inspect a FlipFlopNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#917
  def visit_flip_flop_node(node); end

  # Inspect a FloatNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#937
  def visit_float_node(node); end

  # Inspect a ForNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#945
  def visit_for_node(node); end

  # Inspect a ForwardingArgumentsNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#966
  def visit_forwarding_arguments_node(node); end

  # Inspect a ForwardingParameterNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#973
  def visit_forwarding_parameter_node(node); end

  # Inspect a ForwardingSuperNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#980
  def visit_forwarding_super_node(node); end

  # Inspect a GlobalVariableAndWriteNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#993
  def visit_global_variable_and_write_node(node); end

  # Inspect a GlobalVariableOperatorWriteNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1005
  def visit_global_variable_operator_write_node(node); end

  # Inspect a GlobalVariableOrWriteNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1018
  def visit_global_variable_or_write_node(node); end

  # Inspect a GlobalVariableReadNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1030
  def visit_global_variable_read_node(node); end

  # Inspect a GlobalVariableTargetNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1038
  def visit_global_variable_target_node(node); end

  # Inspect a GlobalVariableWriteNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1046
  def visit_global_variable_write_node(node); end

  # Inspect a HashNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1058
  def visit_hash_node(node); end

  # Inspect a HashPatternNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1076
  def visit_hash_pattern_node(node); end

  # Inspect a IfNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1106
  def visit_if_node(node); end

  # Inspect a ImaginaryNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1130
  def visit_imaginary_node(node); end

  # Inspect a ImplicitNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1139
  def visit_implicit_node(node); end

  # Inspect a ImplicitRestNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1148
  def visit_implicit_rest_node(node); end

  # Inspect a InNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1155
  def visit_in_node(node); end

  # Inspect a IndexAndWriteNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1172
  def visit_index_and_write_node(node); end

  # Inspect a IndexOperatorWriteNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1203
  def visit_index_operator_write_node(node); end

  # Inspect a IndexOrWriteNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1235
  def visit_index_or_write_node(node); end

  # Inspect a IndexTargetNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1266
  def visit_index_target_node(node); end

  # Inspect a InstanceVariableAndWriteNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1289
  def visit_instance_variable_and_write_node(node); end

  # Inspect a InstanceVariableOperatorWriteNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1301
  def visit_instance_variable_operator_write_node(node); end

  # Inspect a InstanceVariableOrWriteNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1314
  def visit_instance_variable_or_write_node(node); end

  # Inspect a InstanceVariableReadNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1326
  def visit_instance_variable_read_node(node); end

  # Inspect a InstanceVariableTargetNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1334
  def visit_instance_variable_target_node(node); end

  # Inspect a InstanceVariableWriteNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1342
  def visit_instance_variable_write_node(node); end

  # Inspect a IntegerNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1354
  def visit_integer_node(node); end

  # Inspect a InterpolatedMatchLastLineNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1362
  def visit_interpolated_match_last_line_node(node); end

  # Inspect a InterpolatedRegularExpressionNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1380
  def visit_interpolated_regular_expression_node(node); end

  # Inspect a InterpolatedStringNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1398
  def visit_interpolated_string_node(node); end

  # Inspect a InterpolatedSymbolNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1416
  def visit_interpolated_symbol_node(node); end

  # Inspect a InterpolatedXStringNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1434
  def visit_interpolated_x_string_node(node); end

  # Inspect a ItLocalVariableReadNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1452
  def visit_it_local_variable_read_node(node); end

  # Inspect a ItParametersNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1459
  def visit_it_parameters_node(node); end

  # Inspect a KeywordHashNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1466
  def visit_keyword_hash_node(node); end

  # Inspect a KeywordRestParameterNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1482
  def visit_keyword_rest_parameter_node(node); end

  # Inspect a LambdaNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1496
  def visit_lambda_node(node); end

  # Inspect a LocalVariableAndWriteNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1519
  def visit_local_variable_and_write_node(node); end

  # Inspect a LocalVariableOperatorWriteNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1532
  def visit_local_variable_operator_write_node(node); end

  # Inspect a LocalVariableOrWriteNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1546
  def visit_local_variable_or_write_node(node); end

  # Inspect a LocalVariableReadNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1559
  def visit_local_variable_read_node(node); end

  # Inspect a LocalVariableTargetNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1568
  def visit_local_variable_target_node(node); end

  # Inspect a LocalVariableWriteNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1577
  def visit_local_variable_write_node(node); end

  # Inspect a MatchLastLineNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1590
  def visit_match_last_line_node(node); end

  # Inspect a MatchPredicateNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1601
  def visit_match_predicate_node(node); end

  # Inspect a MatchRequiredNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1613
  def visit_match_required_node(node); end

  # Inspect a MatchWriteNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1625
  def visit_match_write_node(node); end

  # Inspect a MissingNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1643
  def visit_missing_node(node); end

  # Inspect a ModuleNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1650
  def visit_module_node(node); end

  # Inspect a MultiTargetNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1669
  def visit_multi_target_node(node); end

  # Inspect a MultiWriteNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1702
  def visit_multi_write_node(node); end

  # Inspect a NextNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1738
  def visit_next_node(node); end

  # Inspect a NilNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1752
  def visit_nil_node(node); end

  # Inspect a NoKeywordsParameterNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1759
  def visit_no_keywords_parameter_node(node); end

  # Inspect a NumberedParametersNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1768
  def visit_numbered_parameters_node(node); end

  # Inspect a NumberedReferenceReadNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1776
  def visit_numbered_reference_read_node(node); end

  # Inspect a OptionalKeywordParameterNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1784
  def visit_optional_keyword_parameter_node(node); end

  # Inspect a OptionalParameterNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1795
  def visit_optional_parameter_node(node); end

  # Inspect a OrNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1807
  def visit_or_node(node); end

  # Inspect a ParametersNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1819
  def visit_parameters_node(node); end

  # Inspect a ParenthesesNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1880
  def visit_parentheses_node(node); end

  # Inspect a PinnedExpressionNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1895
  def visit_pinned_expression_node(node); end

  # Inspect a PinnedVariableNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1907
  def visit_pinned_variable_node(node); end

  # Inspect a PostExecutionNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1917
  def visit_post_execution_node(node); end

  # Inspect a PreExecutionNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1933
  def visit_pre_execution_node(node); end

  # Inspect a ProgramNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1949
  def visit_program_node(node); end

  # Inspect a RangeNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1959
  def visit_range_node(node); end

  # Inspect a RationalNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1979
  def visit_rational_node(node); end

  # Inspect a RedoNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1988
  def visit_redo_node(node); end

  # Inspect a RegularExpressionNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#1995
  def visit_regular_expression_node(node); end

  # Inspect a RequiredKeywordParameterNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#2006
  def visit_required_keyword_parameter_node(node); end

  # Inspect a RequiredParameterNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#2015
  def visit_required_parameter_node(node); end

  # Inspect a RescueModifierNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#2023
  def visit_rescue_modifier_node(node); end

  # Inspect a RescueNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#2035
  def visit_rescue_node(node); end

  # Inspect a RestParameterNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#2071
  def visit_rest_parameter_node(node); end

  # Inspect a RetryNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#2085
  def visit_retry_node(node); end

  # Inspect a ReturnNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#2092
  def visit_return_node(node); end

  # Inspect a SelfNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#2106
  def visit_self_node(node); end

  # Inspect a ShareableConstantNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#2113
  def visit_shareable_constant_node(node); end

  # Inspect a SingletonClassNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#2122
  def visit_singleton_class_node(node); end

  # Inspect a SourceEncodingNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#2141
  def visit_source_encoding_node(node); end

  # Inspect a SourceFileNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#2148
  def visit_source_file_node(node); end

  # Inspect a SourceLineNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#2156
  def visit_source_line_node(node); end

  # Inspect a SplatNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#2163
  def visit_splat_node(node); end

  # Inspect a StatementsNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#2177
  def visit_statements_node(node); end

  # Inspect a StringNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#2193
  def visit_string_node(node); end

  # Inspect a SuperNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#2204
  def visit_super_node(node); end

  # Inspect a SymbolNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#2226
  def visit_symbol_node(node); end

  # Inspect a TrueNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#2237
  def visit_true_node(node); end

  # Inspect a UndefNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#2244
  def visit_undef_node(node); end

  # Inspect a UnlessNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#2261
  def visit_unless_node(node); end

  # Inspect a UntilNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#2285
  def visit_until_node(node); end

  # Inspect a WhenNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#2302
  def visit_when_node(node); end

  # Inspect a WhileNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#2326
  def visit_while_node(node); end

  # Inspect a XStringNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#2343
  def visit_x_string_node(node); end

  # Inspect a YieldNode node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#2354
  def visit_yield_node(node); end

  private

  # Compose a string representing the given inner location field.
  #
  # source://prism//lib/prism/inspect_visitor.rb#2378
  def inspect_location(location); end

  # Compose a header for the given node.
  #
  # source://prism//lib/prism/inspect_visitor.rb#2372
  def inspect_node(name, node); end

  class << self
    # Compose an inspect string for the given node.
    #
    # source://prism//lib/prism/inspect_visitor.rb#41
    sig { params(node: Prism::Node).returns(String) }
    def compose(node); end
  end
end

# Most of the time, we can simply pass down the indent to the next node.
# However, when we are inside a list we want some extra special formatting
# when we hit an element in that list. In this case, we have a special
# command that replaces the subsequent indent with the given value.
#
# source://prism//lib/prism/inspect_visitor.rb#17
class Prism::InspectVisitor::Replace
  # @return [Replace] a new instance of Replace
  #
  # source://prism//lib/prism/inspect_visitor.rb#20
  def initialize(value); end

  # source://prism//lib/prism/inspect_visitor.rb#18
  def value; end
end

# Represents the use of the `&&=` operator for assignment to an instance variable.
#
#     @target &&= value
#     ^^^^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#8689
class Prism::InstanceVariableAndWriteNode < ::Prism::Node
  # Initialize a new InstanceVariableAndWriteNode node.
  #
  # @return [InstanceVariableAndWriteNode] a new instance of InstanceVariableAndWriteNode
  #
  # source://prism//lib/prism/node.rb#8691
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      name_loc: Prism::Location,
      operator_loc: Prism::Location,
      value: Prism::Node
    ).void
  end
  def initialize(source, node_id, location, flags, name, name_loc, operator_loc, value); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#8777
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#8703
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#8708
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#8718
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#8713
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?name: Symbol, ?name_loc: Location, ?operator_loc: Location, ?value: Prism::node) -> InstanceVariableAndWriteNode
  #
  # source://prism//lib/prism/node.rb#8723
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      name_loc: Prism::Location,
      operator_loc: Prism::Location,
      value: Prism::Node
    ).returns(Prism::InstanceVariableAndWriteNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil), name_loc: T.unsafe(nil), operator_loc: T.unsafe(nil), value: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#8708
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, name: Symbol, name_loc: Location, operator_loc: Location, value: Prism::node }
  #
  # source://prism//lib/prism/node.rb#8731
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # source://prism//lib/prism/desugar_compiler.rb#218
  def desugar; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#8761
  sig { override.returns(String) }
  def inspect; end

  # attr_reader name: Symbol
  #
  # source://prism//lib/prism/node.rb#8736
  sig { returns(Symbol) }
  def name; end

  # attr_reader name_loc: Location
  #
  # source://prism//lib/prism/node.rb#8739
  sig { returns(Prism::Location) }
  def name_loc; end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#8756
  sig { returns(String) }
  def operator; end

  # attr_reader operator_loc: Location
  #
  # source://prism//lib/prism/node.rb#8746
  sig { returns(Prism::Location) }
  def operator_loc; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#8766
  sig { override.returns(Symbol) }
  def type; end

  # attr_reader value: Prism::node
  #
  # source://prism//lib/prism/node.rb#8753
  sig { returns(Prism::Node) }
  def value; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#8771
    def type; end
  end
end

# Represents assigning to an instance variable using an operator that isn't `=`.
#
#     @target += value
#     ^^^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#8790
class Prism::InstanceVariableOperatorWriteNode < ::Prism::Node
  # Initialize a new InstanceVariableOperatorWriteNode node.
  #
  # @return [InstanceVariableOperatorWriteNode] a new instance of InstanceVariableOperatorWriteNode
  #
  # source://prism//lib/prism/node.rb#8792
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      name_loc: Prism::Location,
      binary_operator_loc: Prism::Location,
      value: Prism::Node,
      binary_operator: Symbol
    ).void
  end
  def initialize(source, node_id, location, flags, name, name_loc, binary_operator_loc, value, binary_operator); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#8877
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#8805
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # attr_reader binary_operator: Symbol
  #
  # source://prism//lib/prism/node.rb#8858
  sig { returns(Symbol) }
  def binary_operator; end

  # attr_reader binary_operator_loc: Location
  #
  # source://prism//lib/prism/node.rb#8848
  sig { returns(Prism::Location) }
  def binary_operator_loc; end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#8810
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#8820
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#8815
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?name: Symbol, ?name_loc: Location, ?binary_operator_loc: Location, ?value: Prism::node, ?binary_operator: Symbol) -> InstanceVariableOperatorWriteNode
  #
  # source://prism//lib/prism/node.rb#8825
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      name_loc: Prism::Location,
      binary_operator_loc: Prism::Location,
      value: Prism::Node,
      binary_operator: Symbol
    ).returns(Prism::InstanceVariableOperatorWriteNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil), name_loc: T.unsafe(nil), binary_operator_loc: T.unsafe(nil), value: T.unsafe(nil), binary_operator: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#8810
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, name: Symbol, name_loc: Location, binary_operator_loc: Location, value: Prism::node, binary_operator: Symbol }
  #
  # source://prism//lib/prism/node.rb#8833
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # source://prism//lib/prism/desugar_compiler.rb#230
  def desugar; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#8861
  sig { override.returns(String) }
  def inspect; end

  # attr_reader name: Symbol
  #
  # source://prism//lib/prism/node.rb#8838
  sig { returns(Symbol) }
  def name; end

  # attr_reader name_loc: Location
  #
  # source://prism//lib/prism/node.rb#8841
  sig { returns(Prism::Location) }
  def name_loc; end

  # Returns the binary operator used to modify the receiver. This method is
  # deprecated in favor of #binary_operator.
  #
  # source://prism//lib/prism/node_ext.rb#435
  def operator; end

  # Returns the location of the binary operator used to modify the receiver.
  # This method is deprecated in favor of #binary_operator_loc.
  #
  # source://prism//lib/prism/node_ext.rb#442
  def operator_loc; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#8866
  sig { override.returns(Symbol) }
  def type; end

  # attr_reader value: Prism::node
  #
  # source://prism//lib/prism/node.rb#8855
  sig { returns(Prism::Node) }
  def value; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#8871
    def type; end
  end
end

# Represents the use of the `||=` operator for assignment to an instance variable.
#
#     @target ||= value
#     ^^^^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#8891
class Prism::InstanceVariableOrWriteNode < ::Prism::Node
  # Initialize a new InstanceVariableOrWriteNode node.
  #
  # @return [InstanceVariableOrWriteNode] a new instance of InstanceVariableOrWriteNode
  #
  # source://prism//lib/prism/node.rb#8893
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      name_loc: Prism::Location,
      operator_loc: Prism::Location,
      value: Prism::Node
    ).void
  end
  def initialize(source, node_id, location, flags, name, name_loc, operator_loc, value); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#8979
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#8905
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#8910
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#8920
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#8915
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?name: Symbol, ?name_loc: Location, ?operator_loc: Location, ?value: Prism::node) -> InstanceVariableOrWriteNode
  #
  # source://prism//lib/prism/node.rb#8925
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      name_loc: Prism::Location,
      operator_loc: Prism::Location,
      value: Prism::Node
    ).returns(Prism::InstanceVariableOrWriteNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil), name_loc: T.unsafe(nil), operator_loc: T.unsafe(nil), value: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#8910
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, name: Symbol, name_loc: Location, operator_loc: Location, value: Prism::node }
  #
  # source://prism//lib/prism/node.rb#8933
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # source://prism//lib/prism/desugar_compiler.rb#224
  def desugar; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#8963
  sig { override.returns(String) }
  def inspect; end

  # attr_reader name: Symbol
  #
  # source://prism//lib/prism/node.rb#8938
  sig { returns(Symbol) }
  def name; end

  # attr_reader name_loc: Location
  #
  # source://prism//lib/prism/node.rb#8941
  sig { returns(Prism::Location) }
  def name_loc; end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#8958
  sig { returns(String) }
  def operator; end

  # attr_reader operator_loc: Location
  #
  # source://prism//lib/prism/node.rb#8948
  sig { returns(Prism::Location) }
  def operator_loc; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#8968
  sig { override.returns(Symbol) }
  def type; end

  # attr_reader value: Prism::node
  #
  # source://prism//lib/prism/node.rb#8955
  sig { returns(Prism::Node) }
  def value; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#8973
    def type; end
  end
end

# Represents referencing an instance variable.
#
#     @foo
#     ^^^^
#
# source://prism//lib/prism/node.rb#8992
class Prism::InstanceVariableReadNode < ::Prism::Node
  # Initialize a new InstanceVariableReadNode node.
  #
  # @return [InstanceVariableReadNode] a new instance of InstanceVariableReadNode
  #
  # source://prism//lib/prism/node.rb#8994
  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol).void }
  def initialize(source, node_id, location, flags, name); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#9059
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#9003
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#9008
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#9018
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#9013
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?name: Symbol) -> InstanceVariableReadNode
  #
  # source://prism//lib/prism/node.rb#9023
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol
    ).returns(Prism::InstanceVariableReadNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#9008
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, name: Symbol }
  #
  # source://prism//lib/prism/node.rb#9031
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#9043
  sig { override.returns(String) }
  def inspect; end

  # The name of the instance variable, which is a `@` followed by an [identifier](https://github.com/ruby/prism/blob/main/docs/parsing_rules.md#identifiers).
  #
  #     @x     # name `:@x`
  #
  #     @_test # name `:@_test`
  #
  # source://prism//lib/prism/node.rb#9040
  sig { returns(Symbol) }
  def name; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#9048
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#9053
    def type; end
  end
end

# Represents writing to an instance variable in a context that doesn't have an explicit value.
#
#     @foo, @bar = baz
#     ^^^^  ^^^^
#
# source://prism//lib/prism/node.rb#9069
class Prism::InstanceVariableTargetNode < ::Prism::Node
  # Initialize a new InstanceVariableTargetNode node.
  #
  # @return [InstanceVariableTargetNode] a new instance of InstanceVariableTargetNode
  #
  # source://prism//lib/prism/node.rb#9071
  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol).void }
  def initialize(source, node_id, location, flags, name); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#9132
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#9080
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#9085
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#9095
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#9090
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?name: Symbol) -> InstanceVariableTargetNode
  #
  # source://prism//lib/prism/node.rb#9100
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol
    ).returns(Prism::InstanceVariableTargetNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#9085
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, name: Symbol }
  #
  # source://prism//lib/prism/node.rb#9108
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#9116
  sig { override.returns(String) }
  def inspect; end

  # attr_reader name: Symbol
  #
  # source://prism//lib/prism/node.rb#9113
  sig { returns(Symbol) }
  def name; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#9121
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#9126
    def type; end
  end
end

# Represents writing to an instance variable.
#
#     @foo = 1
#     ^^^^^^^^
#
# source://prism//lib/prism/node.rb#9142
class Prism::InstanceVariableWriteNode < ::Prism::Node
  # Initialize a new InstanceVariableWriteNode node.
  #
  # @return [InstanceVariableWriteNode] a new instance of InstanceVariableWriteNode
  #
  # source://prism//lib/prism/node.rb#9144
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      name_loc: Prism::Location,
      value: Prism::Node,
      operator_loc: Prism::Location
    ).void
  end
  def initialize(source, node_id, location, flags, name, name_loc, value, operator_loc); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#9246
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#9156
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#9161
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#9171
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#9166
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?name: Symbol, ?name_loc: Location, ?value: Prism::node, ?operator_loc: Location) -> InstanceVariableWriteNode
  #
  # source://prism//lib/prism/node.rb#9176
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      name_loc: Prism::Location,
      value: Prism::Node,
      operator_loc: Prism::Location
    ).returns(Prism::InstanceVariableWriteNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil), name_loc: T.unsafe(nil), value: T.unsafe(nil), operator_loc: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#9161
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, name: Symbol, name_loc: Location, value: Prism::node, operator_loc: Location }
  #
  # source://prism//lib/prism/node.rb#9184
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#9230
  sig { override.returns(String) }
  def inspect; end

  # The name of the instance variable, which is a `@` followed by an [identifier](https://github.com/ruby/prism/blob/main/docs/parsing_rules.md#identifiers).
  #
  #     @x = :y       # name `:@x`
  #
  #     @_foo = "bar" # name `@_foo`
  #
  # source://prism//lib/prism/node.rb#9193
  sig { returns(Symbol) }
  def name; end

  # The location of the variable name.
  #
  #     @_x = 1
  #     ^^^
  #
  # source://prism//lib/prism/node.rb#9199
  sig { returns(Prism::Location) }
  def name_loc; end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#9225
  sig { returns(String) }
  def operator; end

  # The location of the `=` operator.
  #
  #     @x = y
  #        ^
  #
  # source://prism//lib/prism/node.rb#9218
  sig { returns(Prism::Location) }
  def operator_loc; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#9235
  sig { override.returns(Symbol) }
  def type; end

  # The value to write to the instance variable. It can be any [non-void expression](https://github.com/ruby/prism/blob/main/docs/parsing_rules.md#non-void-expression).
  #
  #     @foo = :bar
  #            ^^^^
  #
  #     @_x = 1234
  #           ^^^^
  #
  # source://prism//lib/prism/node.rb#9212
  sig { returns(Prism::Node) }
  def value; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#9240
    def type; end
  end
end

# Flags for integer nodes that correspond to the base of the integer.
#
# source://prism//lib/prism/node.rb#16732
module Prism::IntegerBaseFlags; end

# 0b prefix
#
# source://prism//lib/prism/node.rb#16734
Prism::IntegerBaseFlags::BINARY = T.let(T.unsafe(nil), Integer)

# 0d or no prefix
#
# source://prism//lib/prism/node.rb#16737
Prism::IntegerBaseFlags::DECIMAL = T.let(T.unsafe(nil), Integer)

# 0x prefix
#
# source://prism//lib/prism/node.rb#16743
Prism::IntegerBaseFlags::HEXADECIMAL = T.let(T.unsafe(nil), Integer)

# 0o or 0 prefix
#
# source://prism//lib/prism/node.rb#16740
Prism::IntegerBaseFlags::OCTAL = T.let(T.unsafe(nil), Integer)

# Represents an integer number literal.
#
#     1
#     ^
#
# source://prism//lib/prism/node.rb#9259
class Prism::IntegerNode < ::Prism::Node
  # Initialize a new IntegerNode node.
  #
  # @return [IntegerNode] a new instance of IntegerNode
  #
  # source://prism//lib/prism/node.rb#9261
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      value: Integer
    ).void
  end
  def initialize(source, node_id, location, flags, value); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#9342
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#9270
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def binary?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#9303
  sig { returns(T::Boolean) }
  def binary?; end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#9275
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#9285
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#9280
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?value: Integer) -> IntegerNode
  #
  # source://prism//lib/prism/node.rb#9290
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      value: Integer
    ).returns(Prism::IntegerNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), value: T.unsafe(nil)); end

  # def decimal?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#9308
  sig { returns(T::Boolean) }
  def decimal?; end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#9275
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, value: Integer }
  #
  # source://prism//lib/prism/node.rb#9298
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def hexadecimal?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#9318
  sig { returns(T::Boolean) }
  def hexadecimal?; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#9326
  sig { override.returns(String) }
  def inspect; end

  # def octal?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#9313
  sig { returns(T::Boolean) }
  def octal?; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#9331
  sig { override.returns(Symbol) }
  def type; end

  # The value of the integer literal as a number.
  #
  # source://prism//lib/prism/node.rb#9323
  sig { returns(Integer) }
  def value; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#9336
    def type; end
  end
end

# Represents a regular expression literal that contains interpolation that is being used in the predicate of a conditional to implicitly match against the last line read by an IO object.
#
#     if /foo #{bar} baz/ then end
#        ^^^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#9353
class Prism::InterpolatedMatchLastLineNode < ::Prism::Node
  include ::Prism::RegularExpressionOptions

  # Initialize a new InterpolatedMatchLastLineNode node.
  #
  # @return [InterpolatedMatchLastLineNode] a new instance of InterpolatedMatchLastLineNode
  #
  # source://prism//lib/prism/node.rb#9355
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      opening_loc: Prism::Location,
      parts: T::Array[T.any(Prism::StringNode, Prism::EmbeddedStatementsNode, Prism::EmbeddedVariableNode)],
      closing_loc: Prism::Location
    ).void
  end
  def initialize(source, node_id, location, flags, opening_loc, parts, closing_loc); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#9497
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#9366
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def ascii_8bit?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#9424
  sig { returns(T::Boolean) }
  def ascii_8bit?; end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#9371
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def closing: () -> String
  #
  # source://prism//lib/prism/node.rb#9476
  sig { returns(String) }
  def closing; end

  # attr_reader closing_loc: Location
  #
  # source://prism//lib/prism/node.rb#9464
  sig { returns(Prism::Location) }
  def closing_loc; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#9381
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#9376
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?opening_loc: Location, ?parts: Array[StringNode | EmbeddedStatementsNode | EmbeddedVariableNode], ?closing_loc: Location) -> InterpolatedMatchLastLineNode
  #
  # source://prism//lib/prism/node.rb#9386
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      opening_loc: Prism::Location,
      parts: T::Array[T.any(Prism::StringNode, Prism::EmbeddedStatementsNode, Prism::EmbeddedVariableNode)],
      closing_loc: Prism::Location
    ).returns(Prism::InterpolatedMatchLastLineNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), opening_loc: T.unsafe(nil), parts: T.unsafe(nil), closing_loc: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#9371
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, opening_loc: Location, parts: Array[StringNode | EmbeddedStatementsNode | EmbeddedVariableNode], closing_loc: Location }
  #
  # source://prism//lib/prism/node.rb#9394
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def euc_jp?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#9419
  sig { returns(T::Boolean) }
  def euc_jp?; end

  # def extended?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#9404
  sig { returns(T::Boolean) }
  def extended?; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def forced_binary_encoding?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#9444
  sig { returns(T::Boolean) }
  def forced_binary_encoding?; end

  # def forced_us_ascii_encoding?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#9449
  sig { returns(T::Boolean) }
  def forced_us_ascii_encoding?; end

  # def forced_utf8_encoding?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#9439
  sig { returns(T::Boolean) }
  def forced_utf8_encoding?; end

  # def ignore_case?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#9399
  sig { returns(T::Boolean) }
  def ignore_case?; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#9481
  sig { override.returns(String) }
  def inspect; end

  # def multi_line?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#9409
  sig { returns(T::Boolean) }
  def multi_line?; end

  # source://prism//lib/prism/parse_result/newlines.rb#121
  def newline_flag!(lines); end

  # def once?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#9414
  sig { returns(T::Boolean) }
  def once?; end

  # def opening: () -> String
  #
  # source://prism//lib/prism/node.rb#9471
  sig { returns(String) }
  def opening; end

  # attr_reader opening_loc: Location
  #
  # source://prism//lib/prism/node.rb#9454
  sig { returns(Prism::Location) }
  def opening_loc; end

  sig { returns(Integer) }
  def options; end

  # attr_reader parts: Array[StringNode | EmbeddedStatementsNode | EmbeddedVariableNode]
  #
  # source://prism//lib/prism/node.rb#9461
  sig { returns(T::Array[T.any(Prism::StringNode, Prism::EmbeddedStatementsNode, Prism::EmbeddedVariableNode)]) }
  def parts; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#9486
  sig { override.returns(Symbol) }
  def type; end

  # def utf_8?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#9434
  sig { returns(T::Boolean) }
  def utf_8?; end

  # def windows_31j?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#9429
  sig { returns(T::Boolean) }
  def windows_31j?; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#9491
    def type; end
  end
end

# Represents a regular expression literal that contains interpolation.
#
#     /foo #{bar} baz/
#     ^^^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#9511
class Prism::InterpolatedRegularExpressionNode < ::Prism::Node
  include ::Prism::RegularExpressionOptions

  # Initialize a new InterpolatedRegularExpressionNode node.
  #
  # @return [InterpolatedRegularExpressionNode] a new instance of InterpolatedRegularExpressionNode
  #
  # source://prism//lib/prism/node.rb#9513
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      opening_loc: Prism::Location,
      parts: T::Array[T.any(Prism::StringNode, Prism::EmbeddedStatementsNode, Prism::EmbeddedVariableNode)],
      closing_loc: Prism::Location
    ).void
  end
  def initialize(source, node_id, location, flags, opening_loc, parts, closing_loc); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#9655
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#9524
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def ascii_8bit?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#9582
  sig { returns(T::Boolean) }
  def ascii_8bit?; end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#9529
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def closing: () -> String
  #
  # source://prism//lib/prism/node.rb#9634
  sig { returns(String) }
  def closing; end

  # attr_reader closing_loc: Location
  #
  # source://prism//lib/prism/node.rb#9622
  sig { returns(Prism::Location) }
  def closing_loc; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#9539
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#9534
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?opening_loc: Location, ?parts: Array[StringNode | EmbeddedStatementsNode | EmbeddedVariableNode], ?closing_loc: Location) -> InterpolatedRegularExpressionNode
  #
  # source://prism//lib/prism/node.rb#9544
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      opening_loc: Prism::Location,
      parts: T::Array[T.any(Prism::StringNode, Prism::EmbeddedStatementsNode, Prism::EmbeddedVariableNode)],
      closing_loc: Prism::Location
    ).returns(Prism::InterpolatedRegularExpressionNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), opening_loc: T.unsafe(nil), parts: T.unsafe(nil), closing_loc: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#9529
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, opening_loc: Location, parts: Array[StringNode | EmbeddedStatementsNode | EmbeddedVariableNode], closing_loc: Location }
  #
  # source://prism//lib/prism/node.rb#9552
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def euc_jp?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#9577
  sig { returns(T::Boolean) }
  def euc_jp?; end

  # def extended?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#9562
  sig { returns(T::Boolean) }
  def extended?; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def forced_binary_encoding?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#9602
  sig { returns(T::Boolean) }
  def forced_binary_encoding?; end

  # def forced_us_ascii_encoding?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#9607
  sig { returns(T::Boolean) }
  def forced_us_ascii_encoding?; end

  # def forced_utf8_encoding?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#9597
  sig { returns(T::Boolean) }
  def forced_utf8_encoding?; end

  # def ignore_case?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#9557
  sig { returns(T::Boolean) }
  def ignore_case?; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#9639
  sig { override.returns(String) }
  def inspect; end

  # def multi_line?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#9567
  sig { returns(T::Boolean) }
  def multi_line?; end

  # source://prism//lib/prism/parse_result/newlines.rb#128
  def newline_flag!(lines); end

  # def once?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#9572
  sig { returns(T::Boolean) }
  def once?; end

  # def opening: () -> String
  #
  # source://prism//lib/prism/node.rb#9629
  sig { returns(String) }
  def opening; end

  # attr_reader opening_loc: Location
  #
  # source://prism//lib/prism/node.rb#9612
  sig { returns(Prism::Location) }
  def opening_loc; end

  sig { returns(Integer) }
  def options; end

  # attr_reader parts: Array[StringNode | EmbeddedStatementsNode | EmbeddedVariableNode]
  #
  # source://prism//lib/prism/node.rb#9619
  sig { returns(T::Array[T.any(Prism::StringNode, Prism::EmbeddedStatementsNode, Prism::EmbeddedVariableNode)]) }
  def parts; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#9644
  sig { override.returns(Symbol) }
  def type; end

  # def utf_8?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#9592
  sig { returns(T::Boolean) }
  def utf_8?; end

  # def windows_31j?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#9587
  sig { returns(T::Boolean) }
  def windows_31j?; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#9649
    def type; end
  end
end

# Represents a string literal that contains interpolation.
#
#     "foo #{bar} baz"
#     ^^^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#9669
class Prism::InterpolatedStringNode < ::Prism::Node
  include ::Prism::HeredocQuery

  # Initialize a new InterpolatedStringNode node.
  #
  # @return [InterpolatedStringNode] a new instance of InterpolatedStringNode
  #
  # source://prism//lib/prism/node.rb#9671
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      opening_loc: T.nilable(Prism::Location),
      parts: T::Array[T.any(Prism::StringNode, Prism::EmbeddedStatementsNode, Prism::EmbeddedVariableNode, Prism::InterpolatedStringNode)],
      closing_loc: T.nilable(Prism::Location)
    ).void
  end
  def initialize(source, node_id, location, flags, opening_loc, parts, closing_loc); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#9780
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#9682
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#9687
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def closing: () -> String?
  #
  # source://prism//lib/prism/node.rb#9759
  sig { returns(T.nilable(String)) }
  def closing; end

  # attr_reader closing_loc: Location?
  #
  # source://prism//lib/prism/node.rb#9741
  sig { returns(T.nilable(Prism::Location)) }
  def closing_loc; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#9697
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#9692
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?opening_loc: Location?, ?parts: Array[StringNode | EmbeddedStatementsNode | EmbeddedVariableNode | InterpolatedStringNode], ?closing_loc: Location?) -> InterpolatedStringNode
  #
  # source://prism//lib/prism/node.rb#9702
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      opening_loc: T.nilable(Prism::Location),
      parts: T::Array[T.any(Prism::StringNode, Prism::EmbeddedStatementsNode, Prism::EmbeddedVariableNode, Prism::InterpolatedStringNode)],
      closing_loc: T.nilable(Prism::Location)
    ).returns(Prism::InterpolatedStringNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), opening_loc: T.unsafe(nil), parts: T.unsafe(nil), closing_loc: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#9687
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, opening_loc: Location?, parts: Array[StringNode | EmbeddedStatementsNode | EmbeddedVariableNode | InterpolatedStringNode], closing_loc: Location? }
  #
  # source://prism//lib/prism/node.rb#9710
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def frozen?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#9715
  sig { returns(T::Boolean) }
  def frozen?; end

  sig { returns(T::Boolean) }
  def heredoc?; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#9764
  sig { override.returns(String) }
  def inspect; end

  # def mutable?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#9720
  sig { returns(T::Boolean) }
  def mutable?; end

  # source://prism//lib/prism/parse_result/newlines.rb#135
  def newline_flag!(lines); end

  # def opening: () -> String?
  #
  # source://prism//lib/prism/node.rb#9754
  sig { returns(T.nilable(String)) }
  def opening; end

  # attr_reader opening_loc: Location?
  #
  # source://prism//lib/prism/node.rb#9725
  sig { returns(T.nilable(Prism::Location)) }
  def opening_loc; end

  # attr_reader parts: Array[StringNode | EmbeddedStatementsNode | EmbeddedVariableNode | InterpolatedStringNode]
  #
  # source://prism//lib/prism/node.rb#9738
  sig do
    returns(T::Array[T.any(Prism::StringNode, Prism::EmbeddedStatementsNode, Prism::EmbeddedVariableNode, Prism::InterpolatedStringNode)])
  end
  def parts; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#9769
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#9774
    def type; end
  end
end

# Flags for interpolated string nodes that indicated mutability if they are also marked as literals.
#
# source://prism//lib/prism/node.rb#16747
module Prism::InterpolatedStringNodeFlags; end

# source://prism//lib/prism/node.rb#16749
Prism::InterpolatedStringNodeFlags::FROZEN = T.let(T.unsafe(nil), Integer)

# source://prism//lib/prism/node.rb#16752
Prism::InterpolatedStringNodeFlags::MUTABLE = T.let(T.unsafe(nil), Integer)

# Represents a symbol literal that contains interpolation.
#
#     :"foo #{bar} baz"
#     ^^^^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#9794
class Prism::InterpolatedSymbolNode < ::Prism::Node
  # Initialize a new InterpolatedSymbolNode node.
  #
  # @return [InterpolatedSymbolNode] a new instance of InterpolatedSymbolNode
  #
  # source://prism//lib/prism/node.rb#9796
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      opening_loc: T.nilable(Prism::Location),
      parts: T::Array[T.any(Prism::StringNode, Prism::EmbeddedStatementsNode, Prism::EmbeddedVariableNode)],
      closing_loc: T.nilable(Prism::Location)
    ).void
  end
  def initialize(source, node_id, location, flags, opening_loc, parts, closing_loc); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#9895
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#9807
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#9812
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def closing: () -> String?
  #
  # source://prism//lib/prism/node.rb#9874
  sig { returns(T.nilable(String)) }
  def closing; end

  # attr_reader closing_loc: Location?
  #
  # source://prism//lib/prism/node.rb#9856
  sig { returns(T.nilable(Prism::Location)) }
  def closing_loc; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#9822
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#9817
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?opening_loc: Location?, ?parts: Array[StringNode | EmbeddedStatementsNode | EmbeddedVariableNode], ?closing_loc: Location?) -> InterpolatedSymbolNode
  #
  # source://prism//lib/prism/node.rb#9827
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      opening_loc: T.nilable(Prism::Location),
      parts: T::Array[T.any(Prism::StringNode, Prism::EmbeddedStatementsNode, Prism::EmbeddedVariableNode)],
      closing_loc: T.nilable(Prism::Location)
    ).returns(Prism::InterpolatedSymbolNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), opening_loc: T.unsafe(nil), parts: T.unsafe(nil), closing_loc: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#9812
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, opening_loc: Location?, parts: Array[StringNode | EmbeddedStatementsNode | EmbeddedVariableNode], closing_loc: Location? }
  #
  # source://prism//lib/prism/node.rb#9835
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#9879
  sig { override.returns(String) }
  def inspect; end

  # source://prism//lib/prism/parse_result/newlines.rb#142
  def newline_flag!(lines); end

  # def opening: () -> String?
  #
  # source://prism//lib/prism/node.rb#9869
  sig { returns(T.nilable(String)) }
  def opening; end

  # attr_reader opening_loc: Location?
  #
  # source://prism//lib/prism/node.rb#9840
  sig { returns(T.nilable(Prism::Location)) }
  def opening_loc; end

  # attr_reader parts: Array[StringNode | EmbeddedStatementsNode | EmbeddedVariableNode]
  #
  # source://prism//lib/prism/node.rb#9853
  sig { returns(T::Array[T.any(Prism::StringNode, Prism::EmbeddedStatementsNode, Prism::EmbeddedVariableNode)]) }
  def parts; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#9884
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#9889
    def type; end
  end
end

# Represents an xstring literal that contains interpolation.
#
#     `foo #{bar} baz`
#     ^^^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#9908
class Prism::InterpolatedXStringNode < ::Prism::Node
  include ::Prism::HeredocQuery

  # Initialize a new InterpolatedXStringNode node.
  #
  # @return [InterpolatedXStringNode] a new instance of InterpolatedXStringNode
  #
  # source://prism//lib/prism/node.rb#9910
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      opening_loc: Prism::Location,
      parts: T::Array[T.any(Prism::StringNode, Prism::EmbeddedStatementsNode, Prism::EmbeddedVariableNode)],
      closing_loc: Prism::Location
    ).void
  end
  def initialize(source, node_id, location, flags, opening_loc, parts, closing_loc); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#9997
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#9921
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#9926
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def closing: () -> String
  #
  # source://prism//lib/prism/node.rb#9976
  sig { returns(String) }
  def closing; end

  # attr_reader closing_loc: Location
  #
  # source://prism//lib/prism/node.rb#9964
  sig { returns(Prism::Location) }
  def closing_loc; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#9936
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#9931
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?opening_loc: Location, ?parts: Array[StringNode | EmbeddedStatementsNode | EmbeddedVariableNode], ?closing_loc: Location) -> InterpolatedXStringNode
  #
  # source://prism//lib/prism/node.rb#9941
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      opening_loc: Prism::Location,
      parts: T::Array[T.any(Prism::StringNode, Prism::EmbeddedStatementsNode, Prism::EmbeddedVariableNode)],
      closing_loc: Prism::Location
    ).returns(Prism::InterpolatedXStringNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), opening_loc: T.unsafe(nil), parts: T.unsafe(nil), closing_loc: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#9926
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, opening_loc: Location, parts: Array[StringNode | EmbeddedStatementsNode | EmbeddedVariableNode], closing_loc: Location }
  #
  # source://prism//lib/prism/node.rb#9949
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  sig { returns(T::Boolean) }
  def heredoc?; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#9981
  sig { override.returns(String) }
  def inspect; end

  # source://prism//lib/prism/parse_result/newlines.rb#149
  def newline_flag!(lines); end

  # def opening: () -> String
  #
  # source://prism//lib/prism/node.rb#9971
  sig { returns(String) }
  def opening; end

  # attr_reader opening_loc: Location
  #
  # source://prism//lib/prism/node.rb#9954
  sig { returns(Prism::Location) }
  def opening_loc; end

  # attr_reader parts: Array[StringNode | EmbeddedStatementsNode | EmbeddedVariableNode]
  #
  # source://prism//lib/prism/node.rb#9961
  sig { returns(T::Array[T.any(Prism::StringNode, Prism::EmbeddedStatementsNode, Prism::EmbeddedVariableNode)]) }
  def parts; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#9986
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#9991
    def type; end
  end
end

# Represents reading from the implicit `it` local variable.
#
#     -> { it }
#          ^^
#
# source://prism//lib/prism/node.rb#10010
class Prism::ItLocalVariableReadNode < ::Prism::Node
  # Initialize a new ItLocalVariableReadNode node.
  #
  # @return [ItLocalVariableReadNode] a new instance of ItLocalVariableReadNode
  #
  # source://prism//lib/prism/node.rb#10012
  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer).void }
  def initialize(source, node_id, location, flags); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#10069
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#10020
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#10025
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#10035
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#10030
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer) -> ItLocalVariableReadNode
  #
  # source://prism//lib/prism/node.rb#10040
  sig { params(node_id: Integer, location: Prism::Location, flags: Integer).returns(Prism::ItLocalVariableReadNode) }
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#10025
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location }
  #
  # source://prism//lib/prism/node.rb#10048
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#10053
  sig { override.returns(String) }
  def inspect; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#10058
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#10063
    def type; end
  end
end

# Represents an implicit set of parameters through the use of the `it` keyword within a block or lambda.
#
#     -> { it + it }
#     ^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#10078
class Prism::ItParametersNode < ::Prism::Node
  # Initialize a new ItParametersNode node.
  #
  # @return [ItParametersNode] a new instance of ItParametersNode
  #
  # source://prism//lib/prism/node.rb#10080
  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer).void }
  def initialize(source, node_id, location, flags); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#10137
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#10088
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#10093
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#10103
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#10098
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer) -> ItParametersNode
  #
  # source://prism//lib/prism/node.rb#10108
  sig { params(node_id: Integer, location: Prism::Location, flags: Integer).returns(Prism::ItParametersNode) }
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#10093
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location }
  #
  # source://prism//lib/prism/node.rb#10116
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#10121
  sig { override.returns(String) }
  def inspect; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#10126
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#10131
    def type; end
  end
end

# Represents a hash literal without opening and closing braces.
#
#     foo(a: b)
#         ^^^^
#
# source://prism//lib/prism/node.rb#10146
class Prism::KeywordHashNode < ::Prism::Node
  # Initialize a new KeywordHashNode node.
  #
  # @return [KeywordHashNode] a new instance of KeywordHashNode
  #
  # source://prism//lib/prism/node.rb#10148
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      elements: T::Array[T.any(Prism::AssocNode, Prism::AssocSplatNode)]
    ).void
  end
  def initialize(source, node_id, location, flags, elements); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#10214
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#10157
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#10162
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#10172
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#10167
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?elements: Array[AssocNode | AssocSplatNode]) -> KeywordHashNode
  #
  # source://prism//lib/prism/node.rb#10177
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      elements: T::Array[T.any(Prism::AssocNode, Prism::AssocSplatNode)]
    ).returns(Prism::KeywordHashNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), elements: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#10162
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, elements: Array[AssocNode | AssocSplatNode] }
  #
  # source://prism//lib/prism/node.rb#10185
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # attr_reader elements: Array[AssocNode | AssocSplatNode]
  #
  # source://prism//lib/prism/node.rb#10195
  sig { returns(T::Array[T.any(Prism::AssocNode, Prism::AssocSplatNode)]) }
  def elements; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#10198
  sig { override.returns(String) }
  def inspect; end

  # def symbol_keys?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#10190
  sig { returns(T::Boolean) }
  def symbol_keys?; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#10203
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#10208
    def type; end
  end
end

# Flags for keyword hash nodes.
#
# source://prism//lib/prism/node.rb#16756
module Prism::KeywordHashNodeFlags; end

# a keyword hash which only has `AssocNode` elements all with symbol keys, which means the elements can be treated as keyword arguments
#
# source://prism//lib/prism/node.rb#16758
Prism::KeywordHashNodeFlags::SYMBOL_KEYS = T.let(T.unsafe(nil), Integer)

# Represents a keyword rest parameter to a method, block, or lambda definition.
#
#     def a(**b)
#           ^^^
#     end
#
# source://prism//lib/prism/node.rb#10227
class Prism::KeywordRestParameterNode < ::Prism::Node
  # Initialize a new KeywordRestParameterNode node.
  #
  # @return [KeywordRestParameterNode] a new instance of KeywordRestParameterNode
  #
  # source://prism//lib/prism/node.rb#10229
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: T.nilable(Symbol),
      name_loc: T.nilable(Prism::Location),
      operator_loc: Prism::Location
    ).void
  end
  def initialize(source, node_id, location, flags, name, name_loc, operator_loc); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#10322
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#10240
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#10245
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#10255
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#10250
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?name: Symbol?, ?name_loc: Location?, ?operator_loc: Location) -> KeywordRestParameterNode
  #
  # source://prism//lib/prism/node.rb#10260
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: T.nilable(Symbol),
      name_loc: T.nilable(Prism::Location),
      operator_loc: Prism::Location
    ).returns(Prism::KeywordRestParameterNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil), name_loc: T.unsafe(nil), operator_loc: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#10245
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, name: Symbol?, name_loc: Location?, operator_loc: Location }
  #
  # source://prism//lib/prism/node.rb#10268
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#10306
  sig { override.returns(String) }
  def inspect; end

  # attr_reader name: Symbol?
  #
  # source://prism//lib/prism/node.rb#10278
  sig { returns(T.nilable(Symbol)) }
  def name; end

  # attr_reader name_loc: Location?
  #
  # source://prism//lib/prism/node.rb#10281
  sig { returns(T.nilable(Prism::Location)) }
  def name_loc; end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#10301
  sig { returns(String) }
  def operator; end

  # attr_reader operator_loc: Location
  #
  # source://prism//lib/prism/node.rb#10294
  sig { returns(Prism::Location) }
  def operator_loc; end

  # def repeated_parameter?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#10273
  sig { returns(T::Boolean) }
  def repeated_parameter?; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#10311
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#10316
    def type; end
  end
end

# Represents using a lambda literal (not the lambda method call).
#
#     ->(value) { value * 2 }
#     ^^^^^^^^^^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#10335
class Prism::LambdaNode < ::Prism::Node
  # Initialize a new LambdaNode node.
  #
  # @return [LambdaNode] a new instance of LambdaNode
  #
  # source://prism//lib/prism/node.rb#10337
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      locals: T::Array[Symbol],
      operator_loc: Prism::Location,
      opening_loc: Prism::Location,
      closing_loc: Prism::Location,
      parameters: T.nilable(T.any(Prism::BlockParametersNode, Prism::NumberedParametersNode, Prism::ItParametersNode)),
      body: T.nilable(T.any(Prism::StatementsNode, Prism::BeginNode))
    ).void
  end
  def initialize(source, node_id, location, flags, locals, operator_loc, opening_loc, closing_loc, parameters, body); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#10448
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#10351
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # attr_reader body: StatementsNode | BeginNode | nil
  #
  # source://prism//lib/prism/node.rb#10414
  sig { returns(T.nilable(T.any(Prism::StatementsNode, Prism::BeginNode))) }
  def body; end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#10356
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def closing: () -> String
  #
  # source://prism//lib/prism/node.rb#10427
  sig { returns(String) }
  def closing; end

  # attr_reader closing_loc: Location
  #
  # source://prism//lib/prism/node.rb#10404
  sig { returns(Prism::Location) }
  def closing_loc; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#10369
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#10361
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?locals: Array[Symbol], ?operator_loc: Location, ?opening_loc: Location, ?closing_loc: Location, ?parameters: BlockParametersNode | NumberedParametersNode | ItParametersNode | nil, ?body: StatementsNode | BeginNode | nil) -> LambdaNode
  #
  # source://prism//lib/prism/node.rb#10374
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      locals: T::Array[Symbol],
      operator_loc: Prism::Location,
      opening_loc: Prism::Location,
      closing_loc: Prism::Location,
      parameters: T.nilable(T.any(Prism::BlockParametersNode, Prism::NumberedParametersNode, Prism::ItParametersNode)),
      body: T.nilable(T.any(Prism::StatementsNode, Prism::BeginNode))
    ).returns(Prism::LambdaNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), locals: T.unsafe(nil), operator_loc: T.unsafe(nil), opening_loc: T.unsafe(nil), closing_loc: T.unsafe(nil), parameters: T.unsafe(nil), body: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#10356
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, locals: Array[Symbol], operator_loc: Location, opening_loc: Location, closing_loc: Location, parameters: BlockParametersNode | NumberedParametersNode | ItParametersNode | nil, body: StatementsNode | BeginNode | nil }
  #
  # source://prism//lib/prism/node.rb#10382
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#10432
  sig { override.returns(String) }
  def inspect; end

  # attr_reader locals: Array[Symbol]
  #
  # source://prism//lib/prism/node.rb#10387
  sig { returns(T::Array[Symbol]) }
  def locals; end

  # def opening: () -> String
  #
  # source://prism//lib/prism/node.rb#10422
  sig { returns(String) }
  def opening; end

  # attr_reader opening_loc: Location
  #
  # source://prism//lib/prism/node.rb#10397
  sig { returns(Prism::Location) }
  def opening_loc; end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#10417
  sig { returns(String) }
  def operator; end

  # attr_reader operator_loc: Location
  #
  # source://prism//lib/prism/node.rb#10390
  sig { returns(Prism::Location) }
  def operator_loc; end

  # attr_reader parameters: BlockParametersNode | NumberedParametersNode | ItParametersNode | nil
  #
  # source://prism//lib/prism/node.rb#10411
  sig { returns(T.nilable(T.any(Prism::BlockParametersNode, Prism::NumberedParametersNode, Prism::ItParametersNode))) }
  def parameters; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#10437
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#10442
    def type; end
  end
end

# This class is responsible for lexing the source using prism and then
# converting those tokens to be compatible with Ripper. In the vast majority
# of cases, this is a one-to-one mapping of the token type. Everything else
# generally lines up. However, there are a few cases that require special
# handling.
#
# source://prism//lib/prism/lex_compat.rb#12
class Prism::LexCompat
  # @return [LexCompat] a new instance of LexCompat
  #
  # source://prism//lib/prism/lex_compat.rb#619
  def initialize(source, **options); end

  # Returns the value of attribute options.
  #
  # source://prism//lib/prism/lex_compat.rb#617
  def options; end

  # source://prism//lib/prism/lex_compat.rb#624
  def result; end

  # Returns the value of attribute source.
  #
  # source://prism//lib/prism/lex_compat.rb#617
  def source; end
end

# Ripper doesn't include the rest of the token in the event, so we need to
# trim it down to just the content on the first line when comparing.
#
# source://prism//lib/prism/lex_compat.rb#230
class Prism::LexCompat::EndContentToken < ::Prism::LexCompat::Token
  # source://prism//lib/prism/lex_compat.rb#231
  def ==(other); end
end

# A heredoc in this case is a list of tokens that belong to the body of the
# heredoc that should be appended onto the list of tokens when the heredoc
# closes.
#
# source://prism//lib/prism/lex_compat.rb#291
module Prism::LexCompat::Heredoc
  class << self
    # Here we will split between the two types of heredocs and return the
    # object that will store their tokens.
    #
    # source://prism//lib/prism/lex_compat.rb#603
    def build(opening); end
  end
end

# Dash heredocs are a little more complicated. They are a list of tokens
# that need to be split on "\\\n" to mimic Ripper's behavior. We also need
# to keep track of the state that the heredoc was opened in.
#
# source://prism//lib/prism/lex_compat.rb#315
class Prism::LexCompat::Heredoc::DashHeredoc
  # @return [DashHeredoc] a new instance of DashHeredoc
  #
  # source://prism//lib/prism/lex_compat.rb#318
  def initialize(split); end

  # source://prism//lib/prism/lex_compat.rb#323
  def <<(token); end

  # source://prism//lib/prism/lex_compat.rb#316
  def split; end

  # source://prism//lib/prism/lex_compat.rb#327
  def to_a; end

  # source://prism//lib/prism/lex_compat.rb#316
  def tokens; end
end

# Heredocs that are dedenting heredocs are a little more complicated.
# Ripper outputs on_ignored_sp tokens for the whitespace that is being
# removed from the output. prism only modifies the node itself and keeps
# the token the same. This simplifies prism, but makes comparing against
# Ripper much harder because there is a length mismatch.
#
# Fortunately, we already have to pull out the heredoc tokens in order to
# insert them into the stream in the correct order. As such, we can do
# some extra manipulation on the tokens to make them match Ripper's
# output by mirroring the dedent logic that Ripper uses.
#
# source://prism//lib/prism/lex_compat.rb#374
class Prism::LexCompat::Heredoc::DedentingHeredoc
  # @return [DedentingHeredoc] a new instance of DedentingHeredoc
  #
  # source://prism//lib/prism/lex_compat.rb#379
  def initialize; end

  # As tokens are coming in, we track the minimum amount of common leading
  # whitespace on plain string content tokens. This allows us to later
  # remove that amount of whitespace from the beginning of each line.
  #
  # source://prism//lib/prism/lex_compat.rb#390
  def <<(token); end

  # Returns the value of attribute dedent.
  #
  # source://prism//lib/prism/lex_compat.rb#377
  def dedent; end

  # Returns the value of attribute dedent_next.
  #
  # source://prism//lib/prism/lex_compat.rb#377
  def dedent_next; end

  # Returns the value of attribute embexpr_balance.
  #
  # source://prism//lib/prism/lex_compat.rb#377
  def embexpr_balance; end

  # source://prism//lib/prism/lex_compat.rb#427
  def to_a; end

  # Returns the value of attribute tokens.
  #
  # source://prism//lib/prism/lex_compat.rb#377
  def tokens; end
end

# source://prism//lib/prism/lex_compat.rb#375
Prism::LexCompat::Heredoc::DedentingHeredoc::TAB_WIDTH = T.let(T.unsafe(nil), Integer)

# Heredocs that are no dash or tilde heredocs are just a list of tokens.
# We need to keep them around so that we can insert them in the correct
# order back into the token stream and set the state of the last token to
# the state that the heredoc was opened in.
#
# source://prism//lib/prism/lex_compat.rb#296
class Prism::LexCompat::Heredoc::PlainHeredoc
  # @return [PlainHeredoc] a new instance of PlainHeredoc
  #
  # source://prism//lib/prism/lex_compat.rb#299
  def initialize; end

  # source://prism//lib/prism/lex_compat.rb#303
  def <<(token); end

  # source://prism//lib/prism/lex_compat.rb#307
  def to_a; end

  # source://prism//lib/prism/lex_compat.rb#297
  def tokens; end
end

# Ident tokens for the most part are exactly the same, except sometimes we
# know an ident is a local when ripper doesn't (when they are introduced
# through named captures in regular expressions). In that case we don't
# compare the state.
#
# source://prism//lib/prism/lex_compat.rb#248
class Prism::LexCompat::IdentToken < ::Prism::LexCompat::Token
  # source://prism//lib/prism/lex_compat.rb#249
  def ==(other); end
end

# Tokens where state should be ignored
# used for :on_comment, :on_heredoc_end, :on_embexpr_end
#
# source://prism//lib/prism/lex_compat.rb#238
class Prism::LexCompat::IgnoreStateToken < ::Prism::LexCompat::Token
  # source://prism//lib/prism/lex_compat.rb#239
  def ==(other); end
end

# Ignored newlines can occasionally have a LABEL state attached to them, so
# we compare the state differently here.
#
# source://prism//lib/prism/lex_compat.rb#259
class Prism::LexCompat::IgnoredNewlineToken < ::Prism::LexCompat::Token
  # source://prism//lib/prism/lex_compat.rb#260
  def ==(other); end
end

# If we have an identifier that follows a method name like:
#
#     def foo bar
#
# then Ripper will mark bar as END|LABEL if there is a local in a parent
# scope named bar because it hasn't pushed the local table yet. We do this
# more accurately, so we need to allow comparing against both END and
# END|LABEL.
#
# source://prism//lib/prism/lex_compat.rb#279
class Prism::LexCompat::ParamToken < ::Prism::LexCompat::Token
  # source://prism//lib/prism/lex_compat.rb#280
  def ==(other); end
end

# This is a mapping of prism token types to Ripper token types. This is a
# many-to-one mapping because we split up our token types, whereas Ripper
# tends to group them.
#
# source://prism//lib/prism/lex_compat.rb#33
Prism::LexCompat::RIPPER = T.let(T.unsafe(nil), Hash)

# A result class specialized for holding tokens produced by the lexer.
#
# source://prism//lib/prism/lex_compat.rb#14
class Prism::LexCompat::Result < ::Prism::Result
  # Create a new lex compat result object with the given values.
  #
  # @return [Result] a new instance of Result
  #
  # source://prism//lib/prism/lex_compat.rb#19
  def initialize(value, comments, magic_comments, data_loc, errors, warnings, source); end

  # Implement the hash pattern matching interface for Result.
  #
  # source://prism//lib/prism/lex_compat.rb#25
  def deconstruct_keys(keys); end

  # The list of tokens that were produced by the lexer.
  #
  # source://prism//lib/prism/lex_compat.rb#16
  def value; end
end

# When we produce tokens, we produce the same arrays that Ripper does.
# However, we add a couple of convenience methods onto them to make them a
# little easier to work with. We delegate all other methods to the array.
#
# source://prism//lib/prism/lex_compat.rb#204
class Prism::LexCompat::Token < ::SimpleDelegator
  # The type of the token.
  #
  # source://prism//lib/prism/lex_compat.rb#213
  def event; end

  # The location of the token in the source.
  #
  # source://prism//lib/prism/lex_compat.rb#208
  def location; end

  # The state of the lexer when this token was produced.
  #
  # source://prism//lib/prism/lex_compat.rb#223
  def state; end

  # The slice of the source that this token represents.
  #
  # source://prism//lib/prism/lex_compat.rb#218
  def value; end
end

# This is a result specific to the `lex` and `lex_file` methods.
#
# source://prism//lib/prism/parse_result.rb#764
class Prism::LexResult < ::Prism::Result
  # Create a new lex result object with the given values.
  #
  # @return [LexResult] a new instance of LexResult
  #
  # source://prism//lib/prism/parse_result.rb#769
  sig do
    params(
      value: T::Array[T.untyped],
      comments: T::Array[Prism::Comment],
      magic_comments: T::Array[Prism::MagicComment],
      data_loc: T.nilable(Prism::Location),
      errors: T::Array[Prism::ParseError],
      warnings: T::Array[Prism::ParseWarning],
      source: Prism::Source
    ).void
  end
  def initialize(value, comments, magic_comments, data_loc, errors, warnings, source); end

  # Implement the hash pattern matching interface for LexResult.
  #
  # source://prism//lib/prism/parse_result.rb#775
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # The list of tokens that were parsed from the source code.
  #
  # source://prism//lib/prism/parse_result.rb#766
  sig { returns(T::Array[T.untyped]) }
  def value; end
end

# This is a class that wraps the Ripper lexer to produce almost exactly the
# same tokens.
#
# source://prism//lib/prism/lex_compat.rb#872
class Prism::LexRipper
  # @return [LexRipper] a new instance of LexRipper
  #
  # source://prism//lib/prism/lex_compat.rb#875
  def initialize(source); end

  # source://prism//lib/prism/lex_compat.rb#879
  def result; end

  # source://prism//lib/prism/lex_compat.rb#873
  def source; end

  private

  # source://prism//lib/prism/lex_compat.rb#913
  def lex(source); end
end

# Represents the use of the `&&=` operator for assignment to a local variable.
#
#     target &&= value
#     ^^^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#10464
class Prism::LocalVariableAndWriteNode < ::Prism::Node
  # Initialize a new LocalVariableAndWriteNode node.
  #
  # @return [LocalVariableAndWriteNode] a new instance of LocalVariableAndWriteNode
  #
  # source://prism//lib/prism/node.rb#10466
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name_loc: Prism::Location,
      operator_loc: Prism::Location,
      value: Prism::Node,
      name: Symbol,
      depth: Integer
    ).void
  end
  def initialize(source, node_id, location, flags, name_loc, operator_loc, value, name, depth); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#10556
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#10479
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#10484
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#10494
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#10489
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?name_loc: Location, ?operator_loc: Location, ?value: Prism::node, ?name: Symbol, ?depth: Integer) -> LocalVariableAndWriteNode
  #
  # source://prism//lib/prism/node.rb#10499
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name_loc: Prism::Location,
      operator_loc: Prism::Location,
      value: Prism::Node,
      name: Symbol,
      depth: Integer
    ).returns(Prism::LocalVariableAndWriteNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name_loc: T.unsafe(nil), operator_loc: T.unsafe(nil), value: T.unsafe(nil), name: T.unsafe(nil), depth: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#10484
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, name_loc: Location, operator_loc: Location, value: Prism::node, name: Symbol, depth: Integer }
  #
  # source://prism//lib/prism/node.rb#10507
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # attr_reader depth: Integer
  #
  # source://prism//lib/prism/node.rb#10532
  sig { returns(Integer) }
  def depth; end

  # source://prism//lib/prism/desugar_compiler.rb#236
  def desugar; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#10540
  sig { override.returns(String) }
  def inspect; end

  # attr_reader name: Symbol
  #
  # source://prism//lib/prism/node.rb#10529
  sig { returns(Symbol) }
  def name; end

  # attr_reader name_loc: Location
  #
  # source://prism//lib/prism/node.rb#10512
  sig { returns(Prism::Location) }
  def name_loc; end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#10535
  sig { returns(String) }
  def operator; end

  # attr_reader operator_loc: Location
  #
  # source://prism//lib/prism/node.rb#10519
  sig { returns(Prism::Location) }
  def operator_loc; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#10545
  sig { override.returns(Symbol) }
  def type; end

  # attr_reader value: Prism::node
  #
  # source://prism//lib/prism/node.rb#10526
  sig { returns(Prism::Node) }
  def value; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#10550
    def type; end
  end
end

# Represents assigning to a local variable using an operator that isn't `=`.
#
#     target += value
#     ^^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#10570
class Prism::LocalVariableOperatorWriteNode < ::Prism::Node
  # Initialize a new LocalVariableOperatorWriteNode node.
  #
  # @return [LocalVariableOperatorWriteNode] a new instance of LocalVariableOperatorWriteNode
  #
  # source://prism//lib/prism/node.rb#10572
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name_loc: Prism::Location,
      binary_operator_loc: Prism::Location,
      value: Prism::Node,
      name: Symbol,
      binary_operator: Symbol,
      depth: Integer
    ).void
  end
  def initialize(source, node_id, location, flags, name_loc, binary_operator_loc, value, name, binary_operator, depth); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#10661
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#10586
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # attr_reader binary_operator: Symbol
  #
  # source://prism//lib/prism/node.rb#10639
  sig { returns(Symbol) }
  def binary_operator; end

  # attr_reader binary_operator_loc: Location
  #
  # source://prism//lib/prism/node.rb#10626
  sig { returns(Prism::Location) }
  def binary_operator_loc; end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#10591
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#10601
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#10596
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?name_loc: Location, ?binary_operator_loc: Location, ?value: Prism::node, ?name: Symbol, ?binary_operator: Symbol, ?depth: Integer) -> LocalVariableOperatorWriteNode
  #
  # source://prism//lib/prism/node.rb#10606
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name_loc: Prism::Location,
      binary_operator_loc: Prism::Location,
      value: Prism::Node,
      name: Symbol,
      binary_operator: Symbol,
      depth: Integer
    ).returns(Prism::LocalVariableOperatorWriteNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name_loc: T.unsafe(nil), binary_operator_loc: T.unsafe(nil), value: T.unsafe(nil), name: T.unsafe(nil), binary_operator: T.unsafe(nil), depth: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#10591
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, name_loc: Location, binary_operator_loc: Location, value: Prism::node, name: Symbol, binary_operator: Symbol, depth: Integer }
  #
  # source://prism//lib/prism/node.rb#10614
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # attr_reader depth: Integer
  #
  # source://prism//lib/prism/node.rb#10642
  sig { returns(Integer) }
  def depth; end

  # source://prism//lib/prism/desugar_compiler.rb#248
  def desugar; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#10645
  sig { override.returns(String) }
  def inspect; end

  # attr_reader name: Symbol
  #
  # source://prism//lib/prism/node.rb#10636
  sig { returns(Symbol) }
  def name; end

  # attr_reader name_loc: Location
  #
  # source://prism//lib/prism/node.rb#10619
  sig { returns(Prism::Location) }
  def name_loc; end

  # Returns the binary operator used to modify the receiver. This method is
  # deprecated in favor of #binary_operator.
  #
  # source://prism//lib/prism/node_ext.rb#451
  def operator; end

  # Returns the location of the binary operator used to modify the receiver.
  # This method is deprecated in favor of #binary_operator_loc.
  #
  # source://prism//lib/prism/node_ext.rb#458
  def operator_loc; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#10650
  sig { override.returns(Symbol) }
  def type; end

  # attr_reader value: Prism::node
  #
  # source://prism//lib/prism/node.rb#10633
  sig { returns(Prism::Node) }
  def value; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#10655
    def type; end
  end
end

# Represents the use of the `||=` operator for assignment to a local variable.
#
#     target ||= value
#     ^^^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#10676
class Prism::LocalVariableOrWriteNode < ::Prism::Node
  # Initialize a new LocalVariableOrWriteNode node.
  #
  # @return [LocalVariableOrWriteNode] a new instance of LocalVariableOrWriteNode
  #
  # source://prism//lib/prism/node.rb#10678
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name_loc: Prism::Location,
      operator_loc: Prism::Location,
      value: Prism::Node,
      name: Symbol,
      depth: Integer
    ).void
  end
  def initialize(source, node_id, location, flags, name_loc, operator_loc, value, name, depth); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#10768
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#10691
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#10696
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#10706
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#10701
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?name_loc: Location, ?operator_loc: Location, ?value: Prism::node, ?name: Symbol, ?depth: Integer) -> LocalVariableOrWriteNode
  #
  # source://prism//lib/prism/node.rb#10711
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name_loc: Prism::Location,
      operator_loc: Prism::Location,
      value: Prism::Node,
      name: Symbol,
      depth: Integer
    ).returns(Prism::LocalVariableOrWriteNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name_loc: T.unsafe(nil), operator_loc: T.unsafe(nil), value: T.unsafe(nil), name: T.unsafe(nil), depth: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#10696
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, name_loc: Location, operator_loc: Location, value: Prism::node, name: Symbol, depth: Integer }
  #
  # source://prism//lib/prism/node.rb#10719
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # attr_reader depth: Integer
  #
  # source://prism//lib/prism/node.rb#10744
  sig { returns(Integer) }
  def depth; end

  # source://prism//lib/prism/desugar_compiler.rb#242
  def desugar; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#10752
  sig { override.returns(String) }
  def inspect; end

  # attr_reader name: Symbol
  #
  # source://prism//lib/prism/node.rb#10741
  sig { returns(Symbol) }
  def name; end

  # attr_reader name_loc: Location
  #
  # source://prism//lib/prism/node.rb#10724
  sig { returns(Prism::Location) }
  def name_loc; end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#10747
  sig { returns(String) }
  def operator; end

  # attr_reader operator_loc: Location
  #
  # source://prism//lib/prism/node.rb#10731
  sig { returns(Prism::Location) }
  def operator_loc; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#10757
  sig { override.returns(Symbol) }
  def type; end

  # attr_reader value: Prism::node
  #
  # source://prism//lib/prism/node.rb#10738
  sig { returns(Prism::Node) }
  def value; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#10762
    def type; end
  end
end

# Represents reading a local variable. Note that this requires that a local variable of the same name has already been written to in the same scope, otherwise it is parsed as a method call.
#
#     foo
#     ^^^
#
# source://prism//lib/prism/node.rb#10782
class Prism::LocalVariableReadNode < ::Prism::Node
  # Initialize a new LocalVariableReadNode node.
  #
  # @return [LocalVariableReadNode] a new instance of LocalVariableReadNode
  #
  # source://prism//lib/prism/node.rb#10784
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      depth: Integer
    ).void
  end
  def initialize(source, node_id, location, flags, name, depth); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#10863
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#10794
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#10799
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#10809
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#10804
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?name: Symbol, ?depth: Integer) -> LocalVariableReadNode
  #
  # source://prism//lib/prism/node.rb#10814
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      depth: Integer
    ).returns(Prism::LocalVariableReadNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil), depth: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#10799
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, name: Symbol, depth: Integer }
  #
  # source://prism//lib/prism/node.rb#10822
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # The number of visible scopes that should be searched to find the origin of this local variable.
  #
  #     foo = 1; foo # depth 0
  #
  #     bar = 2; tap { bar } # depth 1
  #
  # The specific rules for calculating the depth may differ from individual Ruby implementations, as they are not specified by the language. For more information, see [the Prism documentation](https://github.com/ruby/prism/blob/main/docs/local_variable_depth.md).
  #
  # source://prism//lib/prism/node.rb#10844
  sig { returns(Integer) }
  def depth; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#10847
  sig { override.returns(String) }
  def inspect; end

  # The name of the local variable, which is an [identifier](https://github.com/ruby/prism/blob/main/docs/parsing_rules.md#identifiers).
  #
  #     x      # name `:x`
  #
  #     _Test  # name `:_Test`
  #
  # Note that this can also be an underscore followed by a number for the default block parameters.
  #
  #     _1     # name `:_1`
  #
  # source://prism//lib/prism/node.rb#10835
  sig { returns(Symbol) }
  def name; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#10852
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#10857
    def type; end
  end
end

# Represents writing to a local variable in a context that doesn't have an explicit value.
#
#     foo, bar = baz
#     ^^^  ^^^
#
# source://prism//lib/prism/node.rb#10874
class Prism::LocalVariableTargetNode < ::Prism::Node
  # Initialize a new LocalVariableTargetNode node.
  #
  # @return [LocalVariableTargetNode] a new instance of LocalVariableTargetNode
  #
  # source://prism//lib/prism/node.rb#10876
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      depth: Integer
    ).void
  end
  def initialize(source, node_id, location, flags, name, depth); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#10941
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#10886
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#10891
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#10901
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#10896
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?name: Symbol, ?depth: Integer) -> LocalVariableTargetNode
  #
  # source://prism//lib/prism/node.rb#10906
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      depth: Integer
    ).returns(Prism::LocalVariableTargetNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil), depth: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#10891
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, name: Symbol, depth: Integer }
  #
  # source://prism//lib/prism/node.rb#10914
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # attr_reader depth: Integer
  #
  # source://prism//lib/prism/node.rb#10922
  sig { returns(Integer) }
  def depth; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#10925
  sig { override.returns(String) }
  def inspect; end

  # attr_reader name: Symbol
  #
  # source://prism//lib/prism/node.rb#10919
  sig { returns(Symbol) }
  def name; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#10930
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#10935
    def type; end
  end
end

# Represents writing to a local variable.
#
#     foo = 1
#     ^^^^^^^
#
# source://prism//lib/prism/node.rb#10952
class Prism::LocalVariableWriteNode < ::Prism::Node
  # Initialize a new LocalVariableWriteNode node.
  #
  # @return [LocalVariableWriteNode] a new instance of LocalVariableWriteNode
  #
  # source://prism//lib/prism/node.rb#10954
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      depth: Integer,
      name_loc: Prism::Location,
      value: Prism::Node,
      operator_loc: Prism::Location
    ).void
  end
  def initialize(source, node_id, location, flags, name, depth, name_loc, value, operator_loc); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#11070
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#10967
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#10972
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#10982
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#10977
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?name: Symbol, ?depth: Integer, ?name_loc: Location, ?value: Prism::node, ?operator_loc: Location) -> LocalVariableWriteNode
  #
  # source://prism//lib/prism/node.rb#10987
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      depth: Integer,
      name_loc: Prism::Location,
      value: Prism::Node,
      operator_loc: Prism::Location
    ).returns(Prism::LocalVariableWriteNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil), depth: T.unsafe(nil), name_loc: T.unsafe(nil), value: T.unsafe(nil), operator_loc: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#10972
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, name: Symbol, depth: Integer, name_loc: Location, value: Prism::node, operator_loc: Location }
  #
  # source://prism//lib/prism/node.rb#10995
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # The number of semantic scopes we have to traverse to find the declaration of this variable.
  #
  #     foo = 1         # depth 0
  #
  #     tap { foo = 1 } # depth 1
  #
  # The specific rules for calculating the depth may differ from individual Ruby implementations, as they are not specified by the language. For more information, see [the Prism documentation](https://github.com/ruby/prism/blob/main/docs/local_variable_depth.md).
  #
  # source://prism//lib/prism/node.rb#11013
  sig { returns(Integer) }
  def depth; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#11054
  sig { override.returns(String) }
  def inspect; end

  # The name of the local variable, which is an [identifier](https://github.com/ruby/prism/blob/main/docs/parsing_rules.md#identifiers).
  #
  #     foo = :bar # name `:foo`
  #
  #     abc = 123  # name `:abc`
  #
  # source://prism//lib/prism/node.rb#11004
  sig { returns(Symbol) }
  def name; end

  # The location of the variable name.
  #
  #     foo = :bar
  #     ^^^
  #
  # source://prism//lib/prism/node.rb#11019
  sig { returns(Prism::Location) }
  def name_loc; end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#11049
  sig { returns(String) }
  def operator; end

  # The location of the `=` operator.
  #
  #     x = :y
  #       ^
  #
  # source://prism//lib/prism/node.rb#11042
  sig { returns(Prism::Location) }
  def operator_loc; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#11059
  sig { override.returns(Symbol) }
  def type; end

  # The value to write to the local variable. It can be any [non-void expression](https://github.com/ruby/prism/blob/main/docs/parsing_rules.md#non-void-expression).
  #
  #     foo = :bar
  #           ^^^^
  #
  #     abc = 1234
  #           ^^^^
  #
  # Note that since the name of a local variable is known before the value is parsed, it is valid for a local variable to appear within the value of its own write.
  #
  #     foo = foo
  #
  # source://prism//lib/prism/node.rb#11036
  sig { returns(Prism::Node) }
  def value; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#11064
    def type; end
  end
end

# This represents a location in the source.
#
# source://prism//lib/prism/parse_result.rb#273
class Prism::Location
  # Create a new location object with the given source, start byte offset, and
  # byte length.
  #
  # @return [Location] a new instance of Location
  #
  # source://prism//lib/prism/parse_result.rb#288
  sig { params(source: Prism::Source, start_offset: Integer, length: Integer).void }
  def initialize(source, start_offset, length); end

  # Returns true if the given other location is equal to this location.
  #
  # source://prism//lib/prism/parse_result.rb#476
  sig { params(other: T.untyped).returns(T::Boolean) }
  def ==(other); end

  # Join this location with the first occurrence of the string in the source
  # that occurs after this location on the same line, and return the new
  # location. This will raise an error if the string does not exist.
  #
  # source://prism//lib/prism/parse_result.rb#495
  sig { params(string: String).returns(Prism::Location) }
  def adjoin(string); end

  # The end column in code units using the given cache to fetch or calculate
  # the value.
  #
  # source://prism//lib/prism/parse_result.rb#461
  sig do
    params(
      cache: T.any(Prism::CodeUnitsCache, T.proc.params(byte_offset: Integer).returns(Integer))
    ).returns(Integer)
  end
  def cached_end_code_units_column(cache); end

  # The end offset from the start of the file in code units using the given
  # cache to fetch or calculate the value.
  #
  # source://prism//lib/prism/parse_result.rb#397
  sig do
    params(
      cache: T.any(Prism::CodeUnitsCache, T.proc.params(byte_offset: Integer).returns(Integer))
    ).returns(Integer)
  end
  def cached_end_code_units_offset(cache); end

  # The start column in code units using the given cache to fetch or calculate
  # the value.
  #
  # source://prism//lib/prism/parse_result.rb#437
  sig do
    params(
      cache: T.any(Prism::CodeUnitsCache, T.proc.params(byte_offset: Integer).returns(Integer))
    ).returns(Integer)
  end
  def cached_start_code_units_column(cache); end

  # The start offset from the start of the file in code units using the given
  # cache to fetch or calculate the value.
  #
  # source://prism//lib/prism/parse_result.rb#375
  sig do
    params(
      cache: T.any(Prism::CodeUnitsCache, T.proc.params(byte_offset: Integer).returns(Integer))
    ).returns(Integer)
  end
  def cached_start_code_units_offset(cache); end

  # Returns a new location that is the result of chopping off the last byte.
  #
  # source://prism//lib/prism/parse_result.rb#334
  sig { returns(Prism::Location) }
  def chop; end

  # Returns all comments that are associated with this location (both leading
  # and trailing comments).
  #
  # source://prism//lib/prism/parse_result.rb#324
  sig { returns(T::Array[Prism::Comment]) }
  def comments; end

  # Create a new location object with the given options.
  #
  # source://prism//lib/prism/parse_result.rb#329
  sig { params(source: Prism::Source, start_offset: Integer, length: Integer).returns(Prism::Location) }
  def copy(source: T.unsafe(nil), start_offset: T.unsafe(nil), length: T.unsafe(nil)); end

  # Implement the hash pattern matching interface for Location.
  #
  # source://prism//lib/prism/parse_result.rb#466
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # The column number in characters where this location ends from the start of
  # the line.
  #
  # source://prism//lib/prism/parse_result.rb#449
  sig { returns(Integer) }
  def end_character_column; end

  # The character offset from the beginning of the source where this location
  # ends.
  #
  # source://prism//lib/prism/parse_result.rb#386
  sig { returns(Integer) }
  def end_character_offset; end

  # The column number in code units of the given encoding where this location
  # ends from the start of the line.
  #
  # source://prism//lib/prism/parse_result.rb#455
  sig { params(encoding: Encoding).returns(Integer) }
  def end_code_units_column(encoding = T.unsafe(nil)); end

  # The offset from the start of the file in code units of the given encoding.
  #
  # source://prism//lib/prism/parse_result.rb#391
  sig { params(encoding: Encoding).returns(Integer) }
  def end_code_units_offset(encoding = T.unsafe(nil)); end

  # The column number in bytes where this location ends from the start of the
  # line.
  #
  # source://prism//lib/prism/parse_result.rb#443
  sig { returns(Integer) }
  def end_column; end

  # The line number where this location ends.
  #
  # source://prism//lib/prism/parse_result.rb#413
  sig { returns(Integer) }
  def end_line; end

  # The byte offset from the beginning of the source where this location ends.
  #
  # source://prism//lib/prism/parse_result.rb#380
  sig { returns(Integer) }
  def end_offset; end

  # Returns a string representation of this location.
  #
  # source://prism//lib/prism/parse_result.rb#339
  sig { returns(String) }
  def inspect; end

  # Returns a new location that stretches from this location to the given
  # other location. Raises an error if this location is not before the other
  # location or if they don't share the same source.
  #
  # source://prism//lib/prism/parse_result.rb#485
  sig { params(other: Prism::Location).returns(Prism::Location) }
  def join(other); end

  # Attach a comment to the leading comments of this location.
  #
  # source://prism//lib/prism/parse_result.rb#307
  sig { params(comment: Prism::Comment).void }
  def leading_comment(comment); end

  # These are the comments that are associated with this location that exist
  # before the start of this location.
  #
  # source://prism//lib/prism/parse_result.rb#302
  sig { returns(T::Array[Prism::Comment]) }
  def leading_comments; end

  # The length of this location in bytes.
  #
  # source://prism//lib/prism/parse_result.rb#284
  sig { returns(Integer) }
  def length; end

  # Implement the pretty print interface for Location.
  #
  # source://prism//lib/prism/parse_result.rb#471
  sig { params(q: T.untyped).void }
  def pretty_print(q); end

  # The source code that this location represents.
  #
  # source://prism//lib/prism/parse_result.rb#349
  sig { returns(String) }
  def slice; end

  # The source code that this location represents starting from the beginning
  # of the line that this location starts on to the end of the line that this
  # location ends on.
  #
  # source://prism//lib/prism/parse_result.rb#356
  def slice_lines; end

  # Returns all of the lines of the source code associated with this location.
  #
  # source://prism//lib/prism/parse_result.rb#344
  sig { returns(T::Array[String]) }
  def source_lines; end

  # The column number in characters where this location ends from the start of
  # the line.
  #
  # source://prism//lib/prism/parse_result.rb#425
  sig { returns(Integer) }
  def start_character_column; end

  # The character offset from the beginning of the source where this location
  # starts.
  #
  # source://prism//lib/prism/parse_result.rb#364
  sig { returns(Integer) }
  def start_character_offset; end

  # The column number in code units of the given encoding where this location
  # starts from the start of the line.
  #
  # source://prism//lib/prism/parse_result.rb#431
  sig { params(encoding: Encoding).returns(Integer) }
  def start_code_units_column(encoding = T.unsafe(nil)); end

  # The offset from the start of the file in code units of the given encoding.
  #
  # source://prism//lib/prism/parse_result.rb#369
  sig { params(encoding: Encoding).returns(Integer) }
  def start_code_units_offset(encoding = T.unsafe(nil)); end

  # The column number in bytes where this location starts from the start of
  # the line.
  #
  # source://prism//lib/prism/parse_result.rb#419
  sig { returns(Integer) }
  def start_column; end

  # The line number where this location starts.
  #
  # source://prism//lib/prism/parse_result.rb#402
  sig { returns(Integer) }
  def start_line; end

  # The content of the line where this location starts before this location.
  #
  # source://prism//lib/prism/parse_result.rb#407
  sig { returns(String) }
  def start_line_slice; end

  # The byte offset from the beginning of the source where this location
  # starts.
  #
  # source://prism//lib/prism/parse_result.rb#281
  sig { returns(Integer) }
  def start_offset; end

  # Attach a comment to the trailing comments of this location.
  #
  # source://prism//lib/prism/parse_result.rb#318
  sig { params(comment: Prism::Comment).void }
  def trailing_comment(comment); end

  # These are the comments that are associated with this location that exist
  # after the end of this location.
  #
  # source://prism//lib/prism/parse_result.rb#313
  sig { returns(T::Array[Prism::Comment]) }
  def trailing_comments; end

  protected

  # A Source object that is used to determine more information from the given
  # offset and length.
  #
  # source://prism//lib/prism/parse_result.rb#276
  sig { returns(Prism::Source) }
  def source; end
end

# Flags for while and until loop nodes.
#
# source://prism//lib/prism/node.rb#16762
module Prism::LoopFlags; end

# a loop after a begin statement, so the body is executed first before the condition
#
# source://prism//lib/prism/node.rb#16764
Prism::LoopFlags::BEGIN_MODIFIER = T.let(T.unsafe(nil), Integer)

# This represents a magic comment that was encountered during parsing.
#
# source://prism//lib/prism/parse_result.rb#557
class Prism::MagicComment
  # Create a new magic comment object with the given key and value locations.
  #
  # @return [MagicComment] a new instance of MagicComment
  #
  # source://prism//lib/prism/parse_result.rb#565
  sig { params(key_loc: Prism::Location, value_loc: Prism::Location).void }
  def initialize(key_loc, value_loc); end

  # Implement the hash pattern matching interface for MagicComment.
  #
  # source://prism//lib/prism/parse_result.rb#581
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # Returns a string representation of this magic comment.
  #
  # source://prism//lib/prism/parse_result.rb#586
  sig { returns(String) }
  def inspect; end

  # Returns the key of the magic comment by slicing it from the source code.
  #
  # source://prism//lib/prism/parse_result.rb#571
  sig { returns(String) }
  def key; end

  # A Location object representing the location of the key in the source.
  #
  # source://prism//lib/prism/parse_result.rb#559
  sig { returns(Prism::Location) }
  def key_loc; end

  # Returns the value of the magic comment by slicing it from the source code.
  #
  # source://prism//lib/prism/parse_result.rb#576
  sig { returns(String) }
  def value; end

  # A Location object representing the location of the value in the source.
  #
  # source://prism//lib/prism/parse_result.rb#562
  sig { returns(Prism::Location) }
  def value_loc; end
end

# Represents a regular expression literal used in the predicate of a conditional to implicitly match against the last line read by an IO object.
#
#     if /foo/i then end
#        ^^^^^^
#
# source://prism//lib/prism/node.rb#11084
class Prism::MatchLastLineNode < ::Prism::Node
  include ::Prism::RegularExpressionOptions

  # Initialize a new MatchLastLineNode node.
  #
  # @return [MatchLastLineNode] a new instance of MatchLastLineNode
  #
  # source://prism//lib/prism/node.rb#11086
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      opening_loc: Prism::Location,
      content_loc: Prism::Location,
      closing_loc: Prism::Location,
      unescaped: String
    ).void
  end
  def initialize(source, node_id, location, flags, opening_loc, content_loc, closing_loc, unescaped); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#11241
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#11098
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def ascii_8bit?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#11156
  sig { returns(T::Boolean) }
  def ascii_8bit?; end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#11103
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def closing: () -> String
  #
  # source://prism//lib/prism/node.rb#11220
  sig { returns(String) }
  def closing; end

  # attr_reader closing_loc: Location
  #
  # source://prism//lib/prism/node.rb#11200
  sig { returns(Prism::Location) }
  def closing_loc; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#11113
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#11108
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def content: () -> String
  #
  # source://prism//lib/prism/node.rb#11215
  sig { returns(String) }
  def content; end

  # attr_reader content_loc: Location
  #
  # source://prism//lib/prism/node.rb#11193
  sig { returns(Prism::Location) }
  def content_loc; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?opening_loc: Location, ?content_loc: Location, ?closing_loc: Location, ?unescaped: String) -> MatchLastLineNode
  #
  # source://prism//lib/prism/node.rb#11118
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      opening_loc: Prism::Location,
      content_loc: Prism::Location,
      closing_loc: Prism::Location,
      unescaped: String
    ).returns(Prism::MatchLastLineNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), opening_loc: T.unsafe(nil), content_loc: T.unsafe(nil), closing_loc: T.unsafe(nil), unescaped: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#11103
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, opening_loc: Location, content_loc: Location, closing_loc: Location, unescaped: String }
  #
  # source://prism//lib/prism/node.rb#11126
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def euc_jp?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#11151
  sig { returns(T::Boolean) }
  def euc_jp?; end

  # def extended?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#11136
  sig { returns(T::Boolean) }
  def extended?; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def forced_binary_encoding?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#11176
  sig { returns(T::Boolean) }
  def forced_binary_encoding?; end

  # def forced_us_ascii_encoding?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#11181
  sig { returns(T::Boolean) }
  def forced_us_ascii_encoding?; end

  # def forced_utf8_encoding?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#11171
  sig { returns(T::Boolean) }
  def forced_utf8_encoding?; end

  # def ignore_case?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#11131
  sig { returns(T::Boolean) }
  def ignore_case?; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#11225
  sig { override.returns(String) }
  def inspect; end

  # def multi_line?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#11141
  sig { returns(T::Boolean) }
  def multi_line?; end

  # def once?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#11146
  sig { returns(T::Boolean) }
  def once?; end

  # def opening: () -> String
  #
  # source://prism//lib/prism/node.rb#11210
  sig { returns(String) }
  def opening; end

  # attr_reader opening_loc: Location
  #
  # source://prism//lib/prism/node.rb#11186
  sig { returns(Prism::Location) }
  def opening_loc; end

  sig { returns(Integer) }
  def options; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#11230
  sig { override.returns(Symbol) }
  def type; end

  # attr_reader unescaped: String
  #
  # source://prism//lib/prism/node.rb#11207
  sig { returns(String) }
  def unescaped; end

  # def utf_8?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#11166
  sig { returns(T::Boolean) }
  def utf_8?; end

  # def windows_31j?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#11161
  sig { returns(T::Boolean) }
  def windows_31j?; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#11235
    def type; end
  end
end

# Represents the use of the modifier `in` operator.
#
#     foo in bar
#     ^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#11255
class Prism::MatchPredicateNode < ::Prism::Node
  # Initialize a new MatchPredicateNode node.
  #
  # @return [MatchPredicateNode] a new instance of MatchPredicateNode
  #
  # source://prism//lib/prism/node.rb#11257
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      value: Prism::Node,
      pattern: Prism::Node,
      operator_loc: Prism::Location
    ).void
  end
  def initialize(source, node_id, location, flags, value, pattern, operator_loc); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#11335
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#11268
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#11273
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#11283
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#11278
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?value: Prism::node, ?pattern: Prism::node, ?operator_loc: Location) -> MatchPredicateNode
  #
  # source://prism//lib/prism/node.rb#11288
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      value: Prism::Node,
      pattern: Prism::Node,
      operator_loc: Prism::Location
    ).returns(Prism::MatchPredicateNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), value: T.unsafe(nil), pattern: T.unsafe(nil), operator_loc: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#11273
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, value: Prism::node, pattern: Prism::node, operator_loc: Location }
  #
  # source://prism//lib/prism/node.rb#11296
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#11319
  sig { override.returns(String) }
  def inspect; end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#11314
  sig { returns(String) }
  def operator; end

  # attr_reader operator_loc: Location
  #
  # source://prism//lib/prism/node.rb#11307
  sig { returns(Prism::Location) }
  def operator_loc; end

  # attr_reader pattern: Prism::node
  #
  # source://prism//lib/prism/node.rb#11304
  sig { returns(Prism::Node) }
  def pattern; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#11324
  sig { override.returns(Symbol) }
  def type; end

  # attr_reader value: Prism::node
  #
  # source://prism//lib/prism/node.rb#11301
  sig { returns(Prism::Node) }
  def value; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#11329
    def type; end
  end
end

# Represents the use of the `=>` operator.
#
#     foo => bar
#     ^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#11347
class Prism::MatchRequiredNode < ::Prism::Node
  # Initialize a new MatchRequiredNode node.
  #
  # @return [MatchRequiredNode] a new instance of MatchRequiredNode
  #
  # source://prism//lib/prism/node.rb#11349
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      value: Prism::Node,
      pattern: Prism::Node,
      operator_loc: Prism::Location
    ).void
  end
  def initialize(source, node_id, location, flags, value, pattern, operator_loc); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#11427
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#11360
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#11365
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#11375
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#11370
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?value: Prism::node, ?pattern: Prism::node, ?operator_loc: Location) -> MatchRequiredNode
  #
  # source://prism//lib/prism/node.rb#11380
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      value: Prism::Node,
      pattern: Prism::Node,
      operator_loc: Prism::Location
    ).returns(Prism::MatchRequiredNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), value: T.unsafe(nil), pattern: T.unsafe(nil), operator_loc: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#11365
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, value: Prism::node, pattern: Prism::node, operator_loc: Location }
  #
  # source://prism//lib/prism/node.rb#11388
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#11411
  sig { override.returns(String) }
  def inspect; end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#11406
  sig { returns(String) }
  def operator; end

  # attr_reader operator_loc: Location
  #
  # source://prism//lib/prism/node.rb#11399
  sig { returns(Prism::Location) }
  def operator_loc; end

  # attr_reader pattern: Prism::node
  #
  # source://prism//lib/prism/node.rb#11396
  sig { returns(Prism::Node) }
  def pattern; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#11416
  sig { override.returns(Symbol) }
  def type; end

  # attr_reader value: Prism::node
  #
  # source://prism//lib/prism/node.rb#11393
  sig { returns(Prism::Node) }
  def value; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#11421
    def type; end
  end
end

# Represents writing local variables using a regular expression match with named capture groups.
#
#     /(?<foo>bar)/ =~ baz
#     ^^^^^^^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#11439
class Prism::MatchWriteNode < ::Prism::Node
  # Initialize a new MatchWriteNode node.
  #
  # @return [MatchWriteNode] a new instance of MatchWriteNode
  #
  # source://prism//lib/prism/node.rb#11441
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      call: Prism::CallNode,
      targets: T::Array[Prism::LocalVariableTargetNode]
    ).void
  end
  def initialize(source, node_id, location, flags, call, targets); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#11506
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#11451
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # attr_reader call: CallNode
  #
  # source://prism//lib/prism/node.rb#11484
  sig { returns(Prism::CallNode) }
  def call; end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#11456
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#11466
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#11461
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?call: CallNode, ?targets: Array[LocalVariableTargetNode]) -> MatchWriteNode
  #
  # source://prism//lib/prism/node.rb#11471
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      call: Prism::CallNode,
      targets: T::Array[Prism::LocalVariableTargetNode]
    ).returns(Prism::MatchWriteNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), call: T.unsafe(nil), targets: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#11456
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, call: CallNode, targets: Array[LocalVariableTargetNode] }
  #
  # source://prism//lib/prism/node.rb#11479
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#11490
  sig { override.returns(String) }
  def inspect; end

  # attr_reader targets: Array[LocalVariableTargetNode]
  #
  # source://prism//lib/prism/node.rb#11487
  sig { returns(T::Array[Prism::LocalVariableTargetNode]) }
  def targets; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#11495
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#11500
    def type; end
  end
end

# Represents a node that is missing from the source and results in a syntax error.
#
# source://prism//lib/prism/node.rb#11515
class Prism::MissingNode < ::Prism::Node
  # Initialize a new MissingNode node.
  #
  # @return [MissingNode] a new instance of MissingNode
  #
  # source://prism//lib/prism/node.rb#11517
  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer).void }
  def initialize(source, node_id, location, flags); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#11574
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#11525
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#11530
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#11540
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#11535
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer) -> MissingNode
  #
  # source://prism//lib/prism/node.rb#11545
  sig { params(node_id: Integer, location: Prism::Location, flags: Integer).returns(Prism::MissingNode) }
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#11530
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location }
  #
  # source://prism//lib/prism/node.rb#11553
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#11558
  sig { override.returns(String) }
  def inspect; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#11563
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#11568
    def type; end
  end
end

# Represents a module declaration involving the `module` keyword.
#
#     module Foo end
#     ^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#11583
class Prism::ModuleNode < ::Prism::Node
  # Initialize a new ModuleNode node.
  #
  # @return [ModuleNode] a new instance of ModuleNode
  #
  # source://prism//lib/prism/node.rb#11585
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      locals: T::Array[Symbol],
      module_keyword_loc: Prism::Location,
      constant_path: T.any(Prism::ConstantReadNode, Prism::ConstantPathNode, Prism::MissingNode),
      body: T.nilable(T.any(Prism::StatementsNode, Prism::BeginNode)),
      end_keyword_loc: Prism::Location,
      name: Symbol
    ).void
  end
  def initialize(source, node_id, location, flags, locals, module_keyword_loc, constant_path, body, end_keyword_loc, name); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#11687
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#11599
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # attr_reader body: StatementsNode | BeginNode | nil
  #
  # source://prism//lib/prism/node.rb#11648
  sig { returns(T.nilable(T.any(Prism::StatementsNode, Prism::BeginNode))) }
  def body; end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#11604
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#11617
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#11609
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # attr_reader constant_path: ConstantReadNode | ConstantPathNode | MissingNode
  #
  # source://prism//lib/prism/node.rb#11645
  sig { returns(T.any(Prism::ConstantReadNode, Prism::ConstantPathNode, Prism::MissingNode)) }
  def constant_path; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?locals: Array[Symbol], ?module_keyword_loc: Location, ?constant_path: ConstantReadNode | ConstantPathNode | MissingNode, ?body: StatementsNode | BeginNode | nil, ?end_keyword_loc: Location, ?name: Symbol) -> ModuleNode
  #
  # source://prism//lib/prism/node.rb#11622
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      locals: T::Array[Symbol],
      module_keyword_loc: Prism::Location,
      constant_path: T.any(Prism::ConstantReadNode, Prism::ConstantPathNode, Prism::MissingNode),
      body: T.nilable(T.any(Prism::StatementsNode, Prism::BeginNode)),
      end_keyword_loc: Prism::Location,
      name: Symbol
    ).returns(Prism::ModuleNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), locals: T.unsafe(nil), module_keyword_loc: T.unsafe(nil), constant_path: T.unsafe(nil), body: T.unsafe(nil), end_keyword_loc: T.unsafe(nil), name: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#11604
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, locals: Array[Symbol], module_keyword_loc: Location, constant_path: ConstantReadNode | ConstantPathNode | MissingNode, body: StatementsNode | BeginNode | nil, end_keyword_loc: Location, name: Symbol }
  #
  # source://prism//lib/prism/node.rb#11630
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def end_keyword: () -> String
  #
  # source://prism//lib/prism/node.rb#11666
  sig { returns(String) }
  def end_keyword; end

  # attr_reader end_keyword_loc: Location
  #
  # source://prism//lib/prism/node.rb#11651
  sig { returns(Prism::Location) }
  def end_keyword_loc; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#11671
  sig { override.returns(String) }
  def inspect; end

  # attr_reader locals: Array[Symbol]
  #
  # source://prism//lib/prism/node.rb#11635
  sig { returns(T::Array[Symbol]) }
  def locals; end

  # def module_keyword: () -> String
  #
  # source://prism//lib/prism/node.rb#11661
  sig { returns(String) }
  def module_keyword; end

  # attr_reader module_keyword_loc: Location
  #
  # source://prism//lib/prism/node.rb#11638
  sig { returns(Prism::Location) }
  def module_keyword_loc; end

  # attr_reader name: Symbol
  #
  # source://prism//lib/prism/node.rb#11658
  sig { returns(Symbol) }
  def name; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#11676
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#11681
    def type; end
  end
end

# Represents a multi-target expression.
#
#     a, (b, c) = 1, 2, 3
#        ^^^^^^
#
# This can be a part of `MultiWriteNode` as above, or the target of a `for` loop
#
#     for a, b in [[1, 2], [3, 4]]
#         ^^^^
#
# source://prism//lib/prism/node.rb#11708
class Prism::MultiTargetNode < ::Prism::Node
  # Initialize a new MultiTargetNode node.
  #
  # @return [MultiTargetNode] a new instance of MultiTargetNode
  #
  # source://prism//lib/prism/node.rb#11710
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      lefts: T::Array[T.any(Prism::LocalVariableTargetNode, Prism::InstanceVariableTargetNode, Prism::ClassVariableTargetNode, Prism::GlobalVariableTargetNode, Prism::ConstantTargetNode, Prism::ConstantPathTargetNode, Prism::CallTargetNode, Prism::IndexTargetNode, Prism::MultiTargetNode, Prism::RequiredParameterNode, Prism::BackReferenceReadNode, Prism::NumberedReferenceReadNode)],
      rest: T.nilable(T.any(Prism::ImplicitRestNode, Prism::SplatNode)),
      rights: T::Array[T.any(Prism::LocalVariableTargetNode, Prism::InstanceVariableTargetNode, Prism::ClassVariableTargetNode, Prism::GlobalVariableTargetNode, Prism::ConstantTargetNode, Prism::ConstantPathTargetNode, Prism::CallTargetNode, Prism::IndexTargetNode, Prism::MultiTargetNode, Prism::RequiredParameterNode, Prism::BackReferenceReadNode, Prism::NumberedReferenceReadNode)],
      lparen_loc: T.nilable(Prism::Location),
      rparen_loc: T.nilable(Prism::Location)
    ).void
  end
  def initialize(source, node_id, location, flags, lefts, rest, rights, lparen_loc, rparen_loc); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#11851
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#11723
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#11728
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#11742
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#11733
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?lefts: Array[LocalVariableTargetNode | InstanceVariableTargetNode | ClassVariableTargetNode | GlobalVariableTargetNode | ConstantTargetNode | ConstantPathTargetNode | CallTargetNode | IndexTargetNode | MultiTargetNode | RequiredParameterNode | BackReferenceReadNode | NumberedReferenceReadNode], ?rest: ImplicitRestNode | SplatNode | nil, ?rights: Array[LocalVariableTargetNode | InstanceVariableTargetNode | ClassVariableTargetNode | GlobalVariableTargetNode | ConstantTargetNode | ConstantPathTargetNode | CallTargetNode | IndexTargetNode | MultiTargetNode | RequiredParameterNode | BackReferenceReadNode | NumberedReferenceReadNode], ?lparen_loc: Location?, ?rparen_loc: Location?) -> MultiTargetNode
  #
  # source://prism//lib/prism/node.rb#11747
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      lefts: T::Array[T.any(Prism::LocalVariableTargetNode, Prism::InstanceVariableTargetNode, Prism::ClassVariableTargetNode, Prism::GlobalVariableTargetNode, Prism::ConstantTargetNode, Prism::ConstantPathTargetNode, Prism::CallTargetNode, Prism::IndexTargetNode, Prism::MultiTargetNode, Prism::RequiredParameterNode, Prism::BackReferenceReadNode, Prism::NumberedReferenceReadNode)],
      rest: T.nilable(T.any(Prism::ImplicitRestNode, Prism::SplatNode)),
      rights: T::Array[T.any(Prism::LocalVariableTargetNode, Prism::InstanceVariableTargetNode, Prism::ClassVariableTargetNode, Prism::GlobalVariableTargetNode, Prism::ConstantTargetNode, Prism::ConstantPathTargetNode, Prism::CallTargetNode, Prism::IndexTargetNode, Prism::MultiTargetNode, Prism::RequiredParameterNode, Prism::BackReferenceReadNode, Prism::NumberedReferenceReadNode)],
      lparen_loc: T.nilable(Prism::Location),
      rparen_loc: T.nilable(Prism::Location)
    ).returns(Prism::MultiTargetNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), lefts: T.unsafe(nil), rest: T.unsafe(nil), rights: T.unsafe(nil), lparen_loc: T.unsafe(nil), rparen_loc: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#11728
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, lefts: Array[LocalVariableTargetNode | InstanceVariableTargetNode | ClassVariableTargetNode | GlobalVariableTargetNode | ConstantTargetNode | ConstantPathTargetNode | CallTargetNode | IndexTargetNode | MultiTargetNode | RequiredParameterNode | BackReferenceReadNode | NumberedReferenceReadNode], rest: ImplicitRestNode | SplatNode | nil, rights: Array[LocalVariableTargetNode | InstanceVariableTargetNode | ClassVariableTargetNode | GlobalVariableTargetNode | ConstantTargetNode | ConstantPathTargetNode | CallTargetNode | IndexTargetNode | MultiTargetNode | RequiredParameterNode | BackReferenceReadNode | NumberedReferenceReadNode], lparen_loc: Location?, rparen_loc: Location? }
  #
  # source://prism//lib/prism/node.rb#11755
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#11835
  sig { override.returns(String) }
  def inspect; end

  # Represents the targets expressions before a splat node.
  #
  #     a, (b, c, *) = 1, 2, 3, 4, 5
  #         ^^^^
  #
  # The splat node can be absent, in that case all target expressions are in the left field.
  #
  #     a, (b, c) = 1, 2, 3, 4, 5
  #         ^^^^
  #
  # source://prism//lib/prism/node.rb#11768
  sig do
    returns(T::Array[T.any(Prism::LocalVariableTargetNode, Prism::InstanceVariableTargetNode, Prism::ClassVariableTargetNode, Prism::GlobalVariableTargetNode, Prism::ConstantTargetNode, Prism::ConstantPathTargetNode, Prism::CallTargetNode, Prism::IndexTargetNode, Prism::MultiTargetNode, Prism::RequiredParameterNode, Prism::BackReferenceReadNode, Prism::NumberedReferenceReadNode)])
  end
  def lefts; end

  # def lparen: () -> String?
  #
  # source://prism//lib/prism/node.rb#11825
  sig { returns(T.nilable(String)) }
  def lparen; end

  # The location of the opening parenthesis.
  #
  #     a, (b, c) = 1, 2, 3
  #        ^
  #
  # source://prism//lib/prism/node.rb#11796
  sig { returns(T.nilable(Prism::Location)) }
  def lparen_loc; end

  # Represents a splat node in the target expression.
  #
  #     a, (b, *c) = 1, 2, 3, 4
  #            ^^
  #
  # The variable can be empty, this results in a `SplatNode` with a `nil` expression field.
  #
  #     a, (b, *) = 1, 2, 3, 4
  #            ^
  #
  # If the `*` is omitted, this field will contain an `ImplicitRestNode`
  #
  #     a, (b,) = 1, 2, 3, 4
  #          ^
  #
  # source://prism//lib/prism/node.rb#11784
  sig { returns(T.nilable(T.any(Prism::ImplicitRestNode, Prism::SplatNode))) }
  def rest; end

  # Represents the targets expressions after a splat node.
  #
  #     a, (*, b, c) = 1, 2, 3, 4, 5
  #            ^^^^
  #
  # source://prism//lib/prism/node.rb#11790
  sig do
    returns(T::Array[T.any(Prism::LocalVariableTargetNode, Prism::InstanceVariableTargetNode, Prism::ClassVariableTargetNode, Prism::GlobalVariableTargetNode, Prism::ConstantTargetNode, Prism::ConstantPathTargetNode, Prism::CallTargetNode, Prism::IndexTargetNode, Prism::MultiTargetNode, Prism::RequiredParameterNode, Prism::BackReferenceReadNode, Prism::NumberedReferenceReadNode)])
  end
  def rights; end

  # def rparen: () -> String?
  #
  # source://prism//lib/prism/node.rb#11830
  sig { returns(T.nilable(String)) }
  def rparen; end

  # The location of the closing parenthesis.
  #
  #     a, (b, c) = 1, 2, 3
  #             ^
  #
  # source://prism//lib/prism/node.rb#11812
  sig { returns(T.nilable(Prism::Location)) }
  def rparen_loc; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#11840
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#11845
    def type; end
  end
end

# Represents a write to a multi-target expression.
#
#     a, b, c = 1, 2, 3
#     ^^^^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#11867
class Prism::MultiWriteNode < ::Prism::Node
  # Initialize a new MultiWriteNode node.
  #
  # @return [MultiWriteNode] a new instance of MultiWriteNode
  #
  # source://prism//lib/prism/node.rb#11869
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      lefts: T::Array[T.any(Prism::LocalVariableTargetNode, Prism::InstanceVariableTargetNode, Prism::ClassVariableTargetNode, Prism::GlobalVariableTargetNode, Prism::ConstantTargetNode, Prism::ConstantPathTargetNode, Prism::CallTargetNode, Prism::IndexTargetNode, Prism::MultiTargetNode, Prism::BackReferenceReadNode, Prism::NumberedReferenceReadNode)],
      rest: T.nilable(T.any(Prism::ImplicitRestNode, Prism::SplatNode)),
      rights: T::Array[T.any(Prism::LocalVariableTargetNode, Prism::InstanceVariableTargetNode, Prism::ClassVariableTargetNode, Prism::GlobalVariableTargetNode, Prism::ConstantTargetNode, Prism::ConstantPathTargetNode, Prism::CallTargetNode, Prism::IndexTargetNode, Prism::MultiTargetNode, Prism::BackReferenceReadNode, Prism::NumberedReferenceReadNode)],
      lparen_loc: T.nilable(Prism::Location),
      rparen_loc: T.nilable(Prism::Location),
      operator_loc: Prism::Location,
      value: Prism::Node
    ).void
  end
  def initialize(source, node_id, location, flags, lefts, rest, rights, lparen_loc, rparen_loc, operator_loc, value); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#12034
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#11884
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#11889
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#11904
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#11894
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?lefts: Array[LocalVariableTargetNode | InstanceVariableTargetNode | ClassVariableTargetNode | GlobalVariableTargetNode | ConstantTargetNode | ConstantPathTargetNode | CallTargetNode | IndexTargetNode | MultiTargetNode | BackReferenceReadNode | NumberedReferenceReadNode], ?rest: ImplicitRestNode | SplatNode | nil, ?rights: Array[LocalVariableTargetNode | InstanceVariableTargetNode | ClassVariableTargetNode | GlobalVariableTargetNode | ConstantTargetNode | ConstantPathTargetNode | CallTargetNode | IndexTargetNode | MultiTargetNode | BackReferenceReadNode | NumberedReferenceReadNode], ?lparen_loc: Location?, ?rparen_loc: Location?, ?operator_loc: Location, ?value: Prism::node) -> MultiWriteNode
  #
  # source://prism//lib/prism/node.rb#11909
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      lefts: T::Array[T.any(Prism::LocalVariableTargetNode, Prism::InstanceVariableTargetNode, Prism::ClassVariableTargetNode, Prism::GlobalVariableTargetNode, Prism::ConstantTargetNode, Prism::ConstantPathTargetNode, Prism::CallTargetNode, Prism::IndexTargetNode, Prism::MultiTargetNode, Prism::BackReferenceReadNode, Prism::NumberedReferenceReadNode)],
      rest: T.nilable(T.any(Prism::ImplicitRestNode, Prism::SplatNode)),
      rights: T::Array[T.any(Prism::LocalVariableTargetNode, Prism::InstanceVariableTargetNode, Prism::ClassVariableTargetNode, Prism::GlobalVariableTargetNode, Prism::ConstantTargetNode, Prism::ConstantPathTargetNode, Prism::CallTargetNode, Prism::IndexTargetNode, Prism::MultiTargetNode, Prism::BackReferenceReadNode, Prism::NumberedReferenceReadNode)],
      lparen_loc: T.nilable(Prism::Location),
      rparen_loc: T.nilable(Prism::Location),
      operator_loc: Prism::Location,
      value: Prism::Node
    ).returns(Prism::MultiWriteNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), lefts: T.unsafe(nil), rest: T.unsafe(nil), rights: T.unsafe(nil), lparen_loc: T.unsafe(nil), rparen_loc: T.unsafe(nil), operator_loc: T.unsafe(nil), value: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#11889
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, lefts: Array[LocalVariableTargetNode | InstanceVariableTargetNode | ClassVariableTargetNode | GlobalVariableTargetNode | ConstantTargetNode | ConstantPathTargetNode | CallTargetNode | IndexTargetNode | MultiTargetNode | BackReferenceReadNode | NumberedReferenceReadNode], rest: ImplicitRestNode | SplatNode | nil, rights: Array[LocalVariableTargetNode | InstanceVariableTargetNode | ClassVariableTargetNode | GlobalVariableTargetNode | ConstantTargetNode | ConstantPathTargetNode | CallTargetNode | IndexTargetNode | MultiTargetNode | BackReferenceReadNode | NumberedReferenceReadNode], lparen_loc: Location?, rparen_loc: Location?, operator_loc: Location, value: Prism::node }
  #
  # source://prism//lib/prism/node.rb#11917
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#12018
  sig { override.returns(String) }
  def inspect; end

  # Represents the targets expressions before a splat node.
  #
  #     a, b, * = 1, 2, 3, 4, 5
  #     ^^^^
  #
  # The splat node can be absent, in that case all target expressions are in the left field.
  #
  #     a, b, c = 1, 2, 3, 4, 5
  #     ^^^^^^^
  #
  # source://prism//lib/prism/node.rb#11930
  sig do
    returns(T::Array[T.any(Prism::LocalVariableTargetNode, Prism::InstanceVariableTargetNode, Prism::ClassVariableTargetNode, Prism::GlobalVariableTargetNode, Prism::ConstantTargetNode, Prism::ConstantPathTargetNode, Prism::CallTargetNode, Prism::IndexTargetNode, Prism::MultiTargetNode, Prism::BackReferenceReadNode, Prism::NumberedReferenceReadNode)])
  end
  def lefts; end

  # def lparen: () -> String?
  #
  # source://prism//lib/prism/node.rb#12003
  sig { returns(T.nilable(String)) }
  def lparen; end

  # The location of the opening parenthesis.
  #
  #     (a, b, c) = 1, 2, 3
  #     ^
  #
  # source://prism//lib/prism/node.rb#11958
  sig { returns(T.nilable(Prism::Location)) }
  def lparen_loc; end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#12013
  sig { returns(String) }
  def operator; end

  # The location of the operator.
  #
  #     a, b, c = 1, 2, 3
  #             ^
  #
  # source://prism//lib/prism/node.rb#11990
  sig { returns(Prism::Location) }
  def operator_loc; end

  # Represents a splat node in the target expression.
  #
  #     a, b, *c = 1, 2, 3, 4
  #           ^^
  #
  # The variable can be empty, this results in a `SplatNode` with a `nil` expression field.
  #
  #     a, b, * = 1, 2, 3, 4
  #           ^
  #
  # If the `*` is omitted, this field will contain an `ImplicitRestNode`
  #
  #     a, b, = 1, 2, 3, 4
  #         ^
  #
  # source://prism//lib/prism/node.rb#11946
  sig { returns(T.nilable(T.any(Prism::ImplicitRestNode, Prism::SplatNode))) }
  def rest; end

  # Represents the targets expressions after a splat node.
  #
  #     a, *, b, c = 1, 2, 3, 4, 5
  #           ^^^^
  #
  # source://prism//lib/prism/node.rb#11952
  sig do
    returns(T::Array[T.any(Prism::LocalVariableTargetNode, Prism::InstanceVariableTargetNode, Prism::ClassVariableTargetNode, Prism::GlobalVariableTargetNode, Prism::ConstantTargetNode, Prism::ConstantPathTargetNode, Prism::CallTargetNode, Prism::IndexTargetNode, Prism::MultiTargetNode, Prism::BackReferenceReadNode, Prism::NumberedReferenceReadNode)])
  end
  def rights; end

  # def rparen: () -> String?
  #
  # source://prism//lib/prism/node.rb#12008
  sig { returns(T.nilable(String)) }
  def rparen; end

  # The location of the closing parenthesis.
  #
  #     (a, b, c) = 1, 2, 3
  #             ^
  #
  # source://prism//lib/prism/node.rb#11974
  sig { returns(T.nilable(Prism::Location)) }
  def rparen_loc; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#12023
  sig { override.returns(Symbol) }
  def type; end

  # The value to write to the targets. It can be any [non-void expression](https://github.com/ruby/prism/blob/main/docs/parsing_rules.md#non-void-expression).
  #
  #     a, b, c = 1, 2, 3
  #               ^^^^^^^
  #
  # source://prism//lib/prism/node.rb#12000
  sig { returns(Prism::Node) }
  def value; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#12028
    def type; end
  end
end

# This visitor walks through the tree and copies each node as it is being
# visited. This is useful for consumers that want to mutate the tree, as you
# can change subtrees in place without effecting the rest of the tree.
#
# source://prism//lib/prism/mutation_compiler.rb#13
class Prism::MutationCompiler < ::Prism::Compiler
  # Copy a AliasGlobalVariableNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#15
  def visit_alias_global_variable_node(node); end

  # Copy a AliasMethodNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#20
  def visit_alias_method_node(node); end

  # Copy a AlternationPatternNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#25
  def visit_alternation_pattern_node(node); end

  # Copy a AndNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#30
  def visit_and_node(node); end

  # Copy a ArgumentsNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#35
  def visit_arguments_node(node); end

  # Copy a ArrayNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#40
  def visit_array_node(node); end

  # Copy a ArrayPatternNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#45
  def visit_array_pattern_node(node); end

  # Copy a AssocNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#50
  def visit_assoc_node(node); end

  # Copy a AssocSplatNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#55
  def visit_assoc_splat_node(node); end

  # Copy a BackReferenceReadNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#60
  def visit_back_reference_read_node(node); end

  # Copy a BeginNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#65
  def visit_begin_node(node); end

  # Copy a BlockArgumentNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#70
  def visit_block_argument_node(node); end

  # Copy a BlockLocalVariableNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#75
  def visit_block_local_variable_node(node); end

  # Copy a BlockNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#80
  def visit_block_node(node); end

  # Copy a BlockParameterNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#85
  def visit_block_parameter_node(node); end

  # Copy a BlockParametersNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#90
  def visit_block_parameters_node(node); end

  # Copy a BreakNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#95
  def visit_break_node(node); end

  # Copy a CallAndWriteNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#100
  def visit_call_and_write_node(node); end

  # Copy a CallNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#105
  def visit_call_node(node); end

  # Copy a CallOperatorWriteNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#110
  def visit_call_operator_write_node(node); end

  # Copy a CallOrWriteNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#115
  def visit_call_or_write_node(node); end

  # Copy a CallTargetNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#120
  def visit_call_target_node(node); end

  # Copy a CapturePatternNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#125
  def visit_capture_pattern_node(node); end

  # Copy a CaseMatchNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#130
  def visit_case_match_node(node); end

  # Copy a CaseNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#135
  def visit_case_node(node); end

  # Copy a ClassNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#140
  def visit_class_node(node); end

  # Copy a ClassVariableAndWriteNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#145
  def visit_class_variable_and_write_node(node); end

  # Copy a ClassVariableOperatorWriteNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#150
  def visit_class_variable_operator_write_node(node); end

  # Copy a ClassVariableOrWriteNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#155
  def visit_class_variable_or_write_node(node); end

  # Copy a ClassVariableReadNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#160
  def visit_class_variable_read_node(node); end

  # Copy a ClassVariableTargetNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#165
  def visit_class_variable_target_node(node); end

  # Copy a ClassVariableWriteNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#170
  def visit_class_variable_write_node(node); end

  # Copy a ConstantAndWriteNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#175
  def visit_constant_and_write_node(node); end

  # Copy a ConstantOperatorWriteNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#180
  def visit_constant_operator_write_node(node); end

  # Copy a ConstantOrWriteNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#185
  def visit_constant_or_write_node(node); end

  # Copy a ConstantPathAndWriteNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#190
  def visit_constant_path_and_write_node(node); end

  # Copy a ConstantPathNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#195
  def visit_constant_path_node(node); end

  # Copy a ConstantPathOperatorWriteNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#200
  def visit_constant_path_operator_write_node(node); end

  # Copy a ConstantPathOrWriteNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#205
  def visit_constant_path_or_write_node(node); end

  # Copy a ConstantPathTargetNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#210
  def visit_constant_path_target_node(node); end

  # Copy a ConstantPathWriteNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#215
  def visit_constant_path_write_node(node); end

  # Copy a ConstantReadNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#220
  def visit_constant_read_node(node); end

  # Copy a ConstantTargetNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#225
  def visit_constant_target_node(node); end

  # Copy a ConstantWriteNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#230
  def visit_constant_write_node(node); end

  # Copy a DefNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#235
  def visit_def_node(node); end

  # Copy a DefinedNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#240
  def visit_defined_node(node); end

  # Copy a ElseNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#245
  def visit_else_node(node); end

  # Copy a EmbeddedStatementsNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#250
  def visit_embedded_statements_node(node); end

  # Copy a EmbeddedVariableNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#255
  def visit_embedded_variable_node(node); end

  # Copy a EnsureNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#260
  def visit_ensure_node(node); end

  # Copy a FalseNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#265
  def visit_false_node(node); end

  # Copy a FindPatternNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#270
  def visit_find_pattern_node(node); end

  # Copy a FlipFlopNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#275
  def visit_flip_flop_node(node); end

  # Copy a FloatNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#280
  def visit_float_node(node); end

  # Copy a ForNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#285
  def visit_for_node(node); end

  # Copy a ForwardingArgumentsNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#290
  def visit_forwarding_arguments_node(node); end

  # Copy a ForwardingParameterNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#295
  def visit_forwarding_parameter_node(node); end

  # Copy a ForwardingSuperNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#300
  def visit_forwarding_super_node(node); end

  # Copy a GlobalVariableAndWriteNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#305
  def visit_global_variable_and_write_node(node); end

  # Copy a GlobalVariableOperatorWriteNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#310
  def visit_global_variable_operator_write_node(node); end

  # Copy a GlobalVariableOrWriteNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#315
  def visit_global_variable_or_write_node(node); end

  # Copy a GlobalVariableReadNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#320
  def visit_global_variable_read_node(node); end

  # Copy a GlobalVariableTargetNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#325
  def visit_global_variable_target_node(node); end

  # Copy a GlobalVariableWriteNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#330
  def visit_global_variable_write_node(node); end

  # Copy a HashNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#335
  def visit_hash_node(node); end

  # Copy a HashPatternNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#340
  def visit_hash_pattern_node(node); end

  # Copy a IfNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#345
  def visit_if_node(node); end

  # Copy a ImaginaryNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#350
  def visit_imaginary_node(node); end

  # Copy a ImplicitNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#355
  def visit_implicit_node(node); end

  # Copy a ImplicitRestNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#360
  def visit_implicit_rest_node(node); end

  # Copy a InNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#365
  def visit_in_node(node); end

  # Copy a IndexAndWriteNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#370
  def visit_index_and_write_node(node); end

  # Copy a IndexOperatorWriteNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#375
  def visit_index_operator_write_node(node); end

  # Copy a IndexOrWriteNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#380
  def visit_index_or_write_node(node); end

  # Copy a IndexTargetNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#385
  def visit_index_target_node(node); end

  # Copy a InstanceVariableAndWriteNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#390
  def visit_instance_variable_and_write_node(node); end

  # Copy a InstanceVariableOperatorWriteNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#395
  def visit_instance_variable_operator_write_node(node); end

  # Copy a InstanceVariableOrWriteNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#400
  def visit_instance_variable_or_write_node(node); end

  # Copy a InstanceVariableReadNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#405
  def visit_instance_variable_read_node(node); end

  # Copy a InstanceVariableTargetNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#410
  def visit_instance_variable_target_node(node); end

  # Copy a InstanceVariableWriteNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#415
  def visit_instance_variable_write_node(node); end

  # Copy a IntegerNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#420
  def visit_integer_node(node); end

  # Copy a InterpolatedMatchLastLineNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#425
  def visit_interpolated_match_last_line_node(node); end

  # Copy a InterpolatedRegularExpressionNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#430
  def visit_interpolated_regular_expression_node(node); end

  # Copy a InterpolatedStringNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#435
  def visit_interpolated_string_node(node); end

  # Copy a InterpolatedSymbolNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#440
  def visit_interpolated_symbol_node(node); end

  # Copy a InterpolatedXStringNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#445
  def visit_interpolated_x_string_node(node); end

  # Copy a ItLocalVariableReadNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#450
  def visit_it_local_variable_read_node(node); end

  # Copy a ItParametersNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#455
  def visit_it_parameters_node(node); end

  # Copy a KeywordHashNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#460
  def visit_keyword_hash_node(node); end

  # Copy a KeywordRestParameterNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#465
  def visit_keyword_rest_parameter_node(node); end

  # Copy a LambdaNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#470
  def visit_lambda_node(node); end

  # Copy a LocalVariableAndWriteNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#475
  def visit_local_variable_and_write_node(node); end

  # Copy a LocalVariableOperatorWriteNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#480
  def visit_local_variable_operator_write_node(node); end

  # Copy a LocalVariableOrWriteNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#485
  def visit_local_variable_or_write_node(node); end

  # Copy a LocalVariableReadNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#490
  def visit_local_variable_read_node(node); end

  # Copy a LocalVariableTargetNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#495
  def visit_local_variable_target_node(node); end

  # Copy a LocalVariableWriteNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#500
  def visit_local_variable_write_node(node); end

  # Copy a MatchLastLineNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#505
  def visit_match_last_line_node(node); end

  # Copy a MatchPredicateNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#510
  def visit_match_predicate_node(node); end

  # Copy a MatchRequiredNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#515
  def visit_match_required_node(node); end

  # Copy a MatchWriteNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#520
  def visit_match_write_node(node); end

  # Copy a MissingNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#525
  def visit_missing_node(node); end

  # Copy a ModuleNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#530
  def visit_module_node(node); end

  # Copy a MultiTargetNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#535
  def visit_multi_target_node(node); end

  # Copy a MultiWriteNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#540
  def visit_multi_write_node(node); end

  # Copy a NextNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#545
  def visit_next_node(node); end

  # Copy a NilNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#550
  def visit_nil_node(node); end

  # Copy a NoKeywordsParameterNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#555
  def visit_no_keywords_parameter_node(node); end

  # Copy a NumberedParametersNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#560
  def visit_numbered_parameters_node(node); end

  # Copy a NumberedReferenceReadNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#565
  def visit_numbered_reference_read_node(node); end

  # Copy a OptionalKeywordParameterNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#570
  def visit_optional_keyword_parameter_node(node); end

  # Copy a OptionalParameterNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#575
  def visit_optional_parameter_node(node); end

  # Copy a OrNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#580
  def visit_or_node(node); end

  # Copy a ParametersNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#585
  def visit_parameters_node(node); end

  # Copy a ParenthesesNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#590
  def visit_parentheses_node(node); end

  # Copy a PinnedExpressionNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#595
  def visit_pinned_expression_node(node); end

  # Copy a PinnedVariableNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#600
  def visit_pinned_variable_node(node); end

  # Copy a PostExecutionNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#605
  def visit_post_execution_node(node); end

  # Copy a PreExecutionNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#610
  def visit_pre_execution_node(node); end

  # Copy a ProgramNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#615
  def visit_program_node(node); end

  # Copy a RangeNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#620
  def visit_range_node(node); end

  # Copy a RationalNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#625
  def visit_rational_node(node); end

  # Copy a RedoNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#630
  def visit_redo_node(node); end

  # Copy a RegularExpressionNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#635
  def visit_regular_expression_node(node); end

  # Copy a RequiredKeywordParameterNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#640
  def visit_required_keyword_parameter_node(node); end

  # Copy a RequiredParameterNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#645
  def visit_required_parameter_node(node); end

  # Copy a RescueModifierNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#650
  def visit_rescue_modifier_node(node); end

  # Copy a RescueNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#655
  def visit_rescue_node(node); end

  # Copy a RestParameterNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#660
  def visit_rest_parameter_node(node); end

  # Copy a RetryNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#665
  def visit_retry_node(node); end

  # Copy a ReturnNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#670
  def visit_return_node(node); end

  # Copy a SelfNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#675
  def visit_self_node(node); end

  # Copy a ShareableConstantNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#680
  def visit_shareable_constant_node(node); end

  # Copy a SingletonClassNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#685
  def visit_singleton_class_node(node); end

  # Copy a SourceEncodingNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#690
  def visit_source_encoding_node(node); end

  # Copy a SourceFileNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#695
  def visit_source_file_node(node); end

  # Copy a SourceLineNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#700
  def visit_source_line_node(node); end

  # Copy a SplatNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#705
  def visit_splat_node(node); end

  # Copy a StatementsNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#710
  def visit_statements_node(node); end

  # Copy a StringNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#715
  def visit_string_node(node); end

  # Copy a SuperNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#720
  def visit_super_node(node); end

  # Copy a SymbolNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#725
  def visit_symbol_node(node); end

  # Copy a TrueNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#730
  def visit_true_node(node); end

  # Copy a UndefNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#735
  def visit_undef_node(node); end

  # Copy a UnlessNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#740
  def visit_unless_node(node); end

  # Copy a UntilNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#745
  def visit_until_node(node); end

  # Copy a WhenNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#750
  def visit_when_node(node); end

  # Copy a WhileNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#755
  def visit_while_node(node); end

  # Copy a XStringNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#760
  def visit_x_string_node(node); end

  # Copy a YieldNode node
  #
  # source://prism//lib/prism/mutation_compiler.rb#765
  def visit_yield_node(node); end
end

# Represents the use of the `next` keyword.
#
#     next 1
#     ^^^^^^
#
# source://prism//lib/prism/node.rb#12052
class Prism::NextNode < ::Prism::Node
  # Initialize a new NextNode node.
  #
  # @return [NextNode] a new instance of NextNode
  #
  # source://prism//lib/prism/node.rb#12054
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      arguments: T.nilable(Prism::ArgumentsNode),
      keyword_loc: Prism::Location
    ).void
  end
  def initialize(source, node_id, location, flags, arguments, keyword_loc); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#12130
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#12064
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # attr_reader arguments: ArgumentsNode?
  #
  # source://prism//lib/prism/node.rb#12099
  sig { returns(T.nilable(Prism::ArgumentsNode)) }
  def arguments; end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#12069
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#12081
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#12074
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?arguments: ArgumentsNode?, ?keyword_loc: Location) -> NextNode
  #
  # source://prism//lib/prism/node.rb#12086
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      arguments: T.nilable(Prism::ArgumentsNode),
      keyword_loc: Prism::Location
    ).returns(Prism::NextNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), arguments: T.unsafe(nil), keyword_loc: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#12069
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, arguments: ArgumentsNode?, keyword_loc: Location }
  #
  # source://prism//lib/prism/node.rb#12094
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#12114
  sig { override.returns(String) }
  def inspect; end

  # def keyword: () -> String
  #
  # source://prism//lib/prism/node.rb#12109
  sig { returns(String) }
  def keyword; end

  # attr_reader keyword_loc: Location
  #
  # source://prism//lib/prism/node.rb#12102
  sig { returns(Prism::Location) }
  def keyword_loc; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#12119
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#12124
    def type; end
  end
end

# Represents the use of the `nil` keyword.
#
#     nil
#     ^^^
#
# source://prism//lib/prism/node.rb#12141
class Prism::NilNode < ::Prism::Node
  # Initialize a new NilNode node.
  #
  # @return [NilNode] a new instance of NilNode
  #
  # source://prism//lib/prism/node.rb#12143
  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer).void }
  def initialize(source, node_id, location, flags); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#12200
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#12151
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#12156
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#12166
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#12161
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer) -> NilNode
  #
  # source://prism//lib/prism/node.rb#12171
  sig { params(node_id: Integer, location: Prism::Location, flags: Integer).returns(Prism::NilNode) }
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#12156
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location }
  #
  # source://prism//lib/prism/node.rb#12179
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#12184
  sig { override.returns(String) }
  def inspect; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#12189
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#12194
    def type; end
  end
end

# Represents the use of `**nil` inside method arguments.
#
#     def a(**nil)
#           ^^^^^
#     end
#
# source://prism//lib/prism/node.rb#12210
class Prism::NoKeywordsParameterNode < ::Prism::Node
  # Initialize a new NoKeywordsParameterNode node.
  #
  # @return [NoKeywordsParameterNode] a new instance of NoKeywordsParameterNode
  #
  # source://prism//lib/prism/node.rb#12212
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      operator_loc: Prism::Location,
      keyword_loc: Prism::Location
    ).void
  end
  def initialize(source, node_id, location, flags, operator_loc, keyword_loc); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#12295
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#12222
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#12227
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#12237
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#12232
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?operator_loc: Location, ?keyword_loc: Location) -> NoKeywordsParameterNode
  #
  # source://prism//lib/prism/node.rb#12242
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      operator_loc: Prism::Location,
      keyword_loc: Prism::Location
    ).returns(Prism::NoKeywordsParameterNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), operator_loc: T.unsafe(nil), keyword_loc: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#12227
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, operator_loc: Location, keyword_loc: Location }
  #
  # source://prism//lib/prism/node.rb#12250
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#12279
  sig { override.returns(String) }
  def inspect; end

  # def keyword: () -> String
  #
  # source://prism//lib/prism/node.rb#12274
  sig { returns(String) }
  def keyword; end

  # attr_reader keyword_loc: Location
  #
  # source://prism//lib/prism/node.rb#12262
  sig { returns(Prism::Location) }
  def keyword_loc; end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#12269
  sig { returns(String) }
  def operator; end

  # attr_reader operator_loc: Location
  #
  # source://prism//lib/prism/node.rb#12255
  sig { returns(Prism::Location) }
  def operator_loc; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#12284
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#12289
    def type; end
  end
end

# This represents a node in the tree. It is the parent class of all of the
# various node types.
#
# source://prism//lib/prism/node.rb#12
class Prism::Node
  abstract!

  # Accepts a visitor and calls back into the specialized visit function.
  #
  # @raise [NoMethodError]
  #
  # source://prism//lib/prism/node.rb#169
  sig { abstract.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # Returns the first node that matches the given block when visited in a
  # depth-first search. This is useful for finding a node that matches a
  # particular condition.
  #
  #     node.breadth_first_search { |node| node.node_id == node_id }
  #
  # source://prism//lib/prism/node.rb#139
  sig { params(block: T.proc.params(node: Prism::Node).returns(T::Boolean)).returns(T.nilable(Prism::Node)) }
  def breadth_first_search(&block); end

  # Returns an array of child nodes, including `nil`s in the place of optional
  # nodes that were not present.
  #
  # @raise [NoMethodError]
  #
  # source://prism//lib/prism/node.rb#175
  sig { abstract.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # Returns an array of child nodes and locations that could potentially have
  # comments attached to them.
  #
  # @raise [NoMethodError]
  #
  # source://prism//lib/prism/node.rb#189
  sig { abstract.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # Returns an array of child nodes, excluding any `nil`s in the place of
  # optional nodes that were not present.
  #
  # @raise [NoMethodError]
  #
  # source://prism//lib/prism/node.rb#183
  sig { abstract.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # Returns an array of child nodes, including `nil`s in the place of optional
  # nodes that were not present.
  #
  # @raise [NoMethodError]
  #
  # source://prism//lib/prism/node.rb#175
  sig { abstract.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # source://prism//lib/prism/node_ext.rb#7
  def deprecated(*replacements); end

  # The end offset of the node in the source. This method is effectively a
  # delegate method to the location object.
  #
  # source://prism//lib/prism/node.rb#40
  sig { returns(Integer) }
  def end_offset; end

  sig { abstract.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # Returns a string representation of the node.
  #
  # @raise [NoMethodError]
  #
  # source://prism//lib/prism/node.rb#194
  sig { abstract.returns(String) }
  def inspect; end

  # A Location instance that represents the location of this node in the
  # source.
  #
  # source://prism//lib/prism/node.rb#25
  sig { returns(Prism::Location) }
  def location; end

  # Returns true if the node has the newline flag set.
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#72
  sig { returns(T::Boolean) }
  def newline?; end

  # source://prism//lib/prism/parse_result/newlines.rb#69
  def newline_flag!(lines); end

  # @return [Boolean]
  #
  # source://prism//lib/prism/parse_result/newlines.rb#65
  def newline_flag?; end

  # A unique identifier for this node. This is used in a very specific
  # use case where you want to keep around a reference to a node without
  # having to keep around the syntax tree in memory. This unique identifier
  # will be consistent across multiple parses of the same source code.
  #
  # source://prism//lib/prism/node.rb#21
  sig { returns(Integer) }
  def node_id; end

  # Similar to inspect, but respects the current level of indentation given by
  # the pretty print object.
  #
  # source://prism//lib/prism/node.rb#83
  sig { params(q: T.untyped).void }
  def pretty_print(q); end

  # Returns all of the lines of the source code associated with this node.
  # An alias for source_lines, used to mimic the API from
  # RubyVM::AbstractSyntaxTree to make it easier to migrate.
  #
  # source://prism//lib/prism/node.rb#46
  sig { returns(T::Array[String]) }
  def script_lines; end

  # Slice the location of the node from the source.
  #
  # source://prism//lib/prism/node.rb#55
  sig { returns(String) }
  def slice; end

  # Slice the location of the node from the source, starting at the beginning
  # of the line that the location starts on, ending at the end of the line
  # that the location ends on.
  #
  # source://prism//lib/prism/node.rb#62
  sig { returns(String) }
  def slice_lines; end

  # Returns all of the lines of the source code associated with this node.
  #
  # source://prism//lib/prism/node.rb#46
  sig { returns(T::Array[String]) }
  def source_lines; end

  # The start offset of the node in the source. This method is effectively a
  # delegate method to the location object.
  #
  # source://prism//lib/prism/node.rb#33
  sig { returns(Integer) }
  def start_offset; end

  # Returns true if the node has the static literal flag set.
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#77
  sig { returns(T::Boolean) }
  def static_literal?; end

  # Convert this node into a graphviz dot graph string.
  #
  # source://prism//lib/prism/node.rb#91
  sig { returns(String) }
  def to_dot; end

  # Returns a list of nodes that are descendants of this node that contain the
  # given line and column. This is useful for locating a node that is selected
  # based on the line and column of the source code.
  #
  # Important to note is that the column given to this method should be in
  # bytes, as opposed to characters or code units.
  #
  # source://prism//lib/prism/node.rb#102
  sig { params(line: Integer, column: Integer).returns(T::Array[Prism::Node]) }
  def tunnel(line, column); end

  # Sometimes you want to check an instance of a node against a list of
  # classes to see what kind of behavior to perform. Usually this is done by
  # calling `[cls1, cls2].include?(node.class)` or putting the node into a
  # case statement and doing `case node; when cls1; when cls2; end`. Both of
  # these approaches are relatively slow because of the constant lookups,
  # method calls, and/or array allocations.
  #
  # Instead, you can call #type, which will return to you a symbol that you
  # can use for comparison. This is faster than the other approaches because
  # it uses a single integer comparison, but also because if you're on CRuby
  # you can take advantage of the fact that case statements with all symbol
  # keys will use a jump table.
  #
  # @raise [NoMethodError]
  #
  # source://prism//lib/prism/node.rb#210
  sig { abstract.returns(Symbol) }
  def type; end

  protected

  # An bitset of flags for this node. There are certain flags that are common
  # for all nodes, and then some nodes have specific flags.
  #
  # source://prism//lib/prism/node.rb#68
  sig { returns(Integer) }
  def flags; end

  private

  # A pointer to the source that this node was created from.
  #
  # source://prism//lib/prism/node.rb#14
  sig { returns(Prism::Source) }
  def source; end

  class << self
    # Returns a list of the fields that exist for this node class. Fields
    # describe the structure of the node. This kind of reflection is useful for
    # things like recursively visiting each node _and_ field in the tree.
    #
    # @raise [NoMethodError]
    #
    # source://prism//lib/prism/node.rb#153
    def fields; end

    # Similar to #type, this method returns a symbol that you can use for
    # splitting on the type of the node without having to do a long === chain.
    # Note that like #type, it will still be slower than using == for a single
    # class, but should be faster in a case statement or an array comparison.
    #
    # @raise [NoMethodError]
    #
    # source://prism//lib/prism/node.rb#218
    def type; end
  end
end

# The flags that are common to all nodes.
#
# source://prism//lib/prism/node.rb#16855
module Prism::NodeFlags; end

# A flag to indicate that the node is a candidate to emit a :line event
# through tracepoint when compiled.
#
# source://prism//lib/prism/node.rb#16858
Prism::NodeFlags::NEWLINE = T.let(T.unsafe(nil), Integer)

# A flag to indicate that the value that the node represents is a value that
# can be determined at parse-time.
#
# source://prism//lib/prism/node.rb#16862
Prism::NodeFlags::STATIC_LITERAL = T.let(T.unsafe(nil), Integer)

# Represents an implicit set of parameters through the use of numbered parameters within a block or lambda.
#
#     -> { _1 + _2 }
#     ^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#12306
class Prism::NumberedParametersNode < ::Prism::Node
  # Initialize a new NumberedParametersNode node.
  #
  # @return [NumberedParametersNode] a new instance of NumberedParametersNode
  #
  # source://prism//lib/prism/node.rb#12308
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      maximum: Integer
    ).void
  end
  def initialize(source, node_id, location, flags, maximum); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#12369
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#12317
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#12322
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#12332
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#12327
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?maximum: Integer) -> NumberedParametersNode
  #
  # source://prism//lib/prism/node.rb#12337
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      maximum: Integer
    ).returns(Prism::NumberedParametersNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), maximum: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#12322
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, maximum: Integer }
  #
  # source://prism//lib/prism/node.rb#12345
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#12353
  sig { override.returns(String) }
  def inspect; end

  # attr_reader maximum: Integer
  #
  # source://prism//lib/prism/node.rb#12350
  sig { returns(Integer) }
  def maximum; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#12358
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#12363
    def type; end
  end
end

# Represents reading a numbered reference to a capture in the previous match.
#
#     $1
#     ^^
#
# source://prism//lib/prism/node.rb#12379
class Prism::NumberedReferenceReadNode < ::Prism::Node
  # Initialize a new NumberedReferenceReadNode node.
  #
  # @return [NumberedReferenceReadNode] a new instance of NumberedReferenceReadNode
  #
  # source://prism//lib/prism/node.rb#12381
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      number: Integer
    ).void
  end
  def initialize(source, node_id, location, flags, number); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#12448
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#12390
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#12395
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#12405
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#12400
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?number: Integer) -> NumberedReferenceReadNode
  #
  # source://prism//lib/prism/node.rb#12410
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      number: Integer
    ).returns(Prism::NumberedReferenceReadNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), number: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#12395
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, number: Integer }
  #
  # source://prism//lib/prism/node.rb#12418
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#12432
  sig { override.returns(String) }
  def inspect; end

  # The (1-indexed, from the left) number of the capture group. Numbered references that are too large result in this value being `0`.
  #
  #     $1          # number `1`
  #
  #     $5432       # number `5432`
  #
  #     $4294967296 # number `0`
  #
  # source://prism//lib/prism/node.rb#12429
  sig { returns(Integer) }
  def number; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#12437
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#12442
    def type; end
  end
end

# Represents an optional keyword parameter to a method, block, or lambda definition.
#
#     def a(b: 1)
#           ^^^^
#     end
#
# source://prism//lib/prism/node.rb#12459
class Prism::OptionalKeywordParameterNode < ::Prism::Node
  # Initialize a new OptionalKeywordParameterNode node.
  #
  # @return [OptionalKeywordParameterNode] a new instance of OptionalKeywordParameterNode
  #
  # source://prism//lib/prism/node.rb#12461
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      name_loc: Prism::Location,
      value: Prism::Node
    ).void
  end
  def initialize(source, node_id, location, flags, name, name_loc, value); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#12539
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#12472
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#12477
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#12487
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#12482
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?name: Symbol, ?name_loc: Location, ?value: Prism::node) -> OptionalKeywordParameterNode
  #
  # source://prism//lib/prism/node.rb#12492
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      name_loc: Prism::Location,
      value: Prism::Node
    ).returns(Prism::OptionalKeywordParameterNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil), name_loc: T.unsafe(nil), value: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#12477
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, name: Symbol, name_loc: Location, value: Prism::node }
  #
  # source://prism//lib/prism/node.rb#12500
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#12523
  sig { override.returns(String) }
  def inspect; end

  # attr_reader name: Symbol
  #
  # source://prism//lib/prism/node.rb#12510
  sig { returns(Symbol) }
  def name; end

  # attr_reader name_loc: Location
  #
  # source://prism//lib/prism/node.rb#12513
  sig { returns(Prism::Location) }
  def name_loc; end

  # def repeated_parameter?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#12505
  sig { returns(T::Boolean) }
  def repeated_parameter?; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#12528
  sig { override.returns(Symbol) }
  def type; end

  # attr_reader value: Prism::node
  #
  # source://prism//lib/prism/node.rb#12520
  sig { returns(Prism::Node) }
  def value; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#12533
    def type; end
  end
end

# Represents an optional parameter to a method, block, or lambda definition.
#
#     def a(b = 1)
#           ^^^^^
#     end
#
# source://prism//lib/prism/node.rb#12553
class Prism::OptionalParameterNode < ::Prism::Node
  # Initialize a new OptionalParameterNode node.
  #
  # @return [OptionalParameterNode] a new instance of OptionalParameterNode
  #
  # source://prism//lib/prism/node.rb#12555
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      name_loc: Prism::Location,
      operator_loc: Prism::Location,
      value: Prism::Node
    ).void
  end
  def initialize(source, node_id, location, flags, name, name_loc, operator_loc, value); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#12646
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#12567
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#12572
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#12582
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#12577
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?name: Symbol, ?name_loc: Location, ?operator_loc: Location, ?value: Prism::node) -> OptionalParameterNode
  #
  # source://prism//lib/prism/node.rb#12587
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      name_loc: Prism::Location,
      operator_loc: Prism::Location,
      value: Prism::Node
    ).returns(Prism::OptionalParameterNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil), name_loc: T.unsafe(nil), operator_loc: T.unsafe(nil), value: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#12572
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, name: Symbol, name_loc: Location, operator_loc: Location, value: Prism::node }
  #
  # source://prism//lib/prism/node.rb#12595
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#12630
  sig { override.returns(String) }
  def inspect; end

  # attr_reader name: Symbol
  #
  # source://prism//lib/prism/node.rb#12605
  sig { returns(Symbol) }
  def name; end

  # attr_reader name_loc: Location
  #
  # source://prism//lib/prism/node.rb#12608
  sig { returns(Prism::Location) }
  def name_loc; end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#12625
  sig { returns(String) }
  def operator; end

  # attr_reader operator_loc: Location
  #
  # source://prism//lib/prism/node.rb#12615
  sig { returns(Prism::Location) }
  def operator_loc; end

  # def repeated_parameter?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#12600
  sig { returns(T::Boolean) }
  def repeated_parameter?; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#12635
  sig { override.returns(Symbol) }
  def type; end

  # attr_reader value: Prism::node
  #
  # source://prism//lib/prism/node.rb#12622
  sig { returns(Prism::Node) }
  def value; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#12640
    def type; end
  end
end

# Represents the use of the `||` operator or the `or` keyword.
#
#     left or right
#     ^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#12660
class Prism::OrNode < ::Prism::Node
  # Initialize a new OrNode node.
  #
  # @return [OrNode] a new instance of OrNode
  #
  # source://prism//lib/prism/node.rb#12662
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      left: Prism::Node,
      right: Prism::Node,
      operator_loc: Prism::Location
    ).void
  end
  def initialize(source, node_id, location, flags, left, right, operator_loc); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#12755
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#12673
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#12678
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#12688
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#12683
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?left: Prism::node, ?right: Prism::node, ?operator_loc: Location) -> OrNode
  #
  # source://prism//lib/prism/node.rb#12693
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      left: Prism::Node,
      right: Prism::Node,
      operator_loc: Prism::Location
    ).returns(Prism::OrNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), left: T.unsafe(nil), right: T.unsafe(nil), operator_loc: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#12678
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, left: Prism::node, right: Prism::node, operator_loc: Location }
  #
  # source://prism//lib/prism/node.rb#12701
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#12739
  sig { override.returns(String) }
  def inspect; end

  # Represents the left side of the expression. It can be any [non-void expression](https://github.com/ruby/prism/blob/main/docs/parsing_rules.md#non-void-expression).
  #
  #     left or right
  #     ^^^^
  #
  #     1 || 2
  #     ^
  #
  # source://prism//lib/prism/node.rb#12712
  sig { returns(Prism::Node) }
  def left; end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#12734
  sig { returns(String) }
  def operator; end

  # The location of the `or` keyword or the `||` operator.
  #
  #     left or right
  #          ^^
  #
  # source://prism//lib/prism/node.rb#12727
  sig { returns(Prism::Location) }
  def operator_loc; end

  # Represents the right side of the expression.
  #
  #     left || right
  #             ^^^^^
  #
  #     1 or 2
  #          ^
  #
  # source://prism//lib/prism/node.rb#12721
  sig { returns(Prism::Node) }
  def right; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#12744
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#12749
    def type; end
  end
end

# A parser for the pack template language.
#
# source://prism//lib/prism/pack.rb#6
module Prism::Pack
  class << self
    def parse(_arg0, _arg1, _arg2); end
  end
end

# source://prism//lib/prism/pack.rb#56
Prism::Pack::AGNOSTIC_ENDIAN = T.let(T.unsafe(nil), Symbol)

# source://prism//lib/prism/pack.rb#56
Prism::Pack::BACK = T.let(T.unsafe(nil), Symbol)

# source://prism//lib/prism/pack.rb#56
Prism::Pack::BER = T.let(T.unsafe(nil), Symbol)

# source://prism//lib/prism/pack.rb#56
Prism::Pack::BIG_ENDIAN = T.let(T.unsafe(nil), Symbol)

# source://prism//lib/prism/pack.rb#56
Prism::Pack::COMMENT = T.let(T.unsafe(nil), Symbol)

# A directive in the pack template language.
#
# source://prism//lib/prism/pack.rb#60
class Prism::Pack::Directive
  # Initialize a new directive with the given values.
  #
  # @return [Directive] a new instance of Directive
  #
  # source://prism//lib/prism/pack.rb#89
  def initialize(version, variant, source, type, signed, endian, size, length_type, length); end

  # Provide a human-readable description of the directive.
  #
  # source://prism//lib/prism/pack.rb#131
  def describe; end

  # The type of endianness of the directive.
  #
  # source://prism//lib/prism/pack.rb#77
  def endian; end

  # The length of this directive (used for integers).
  #
  # source://prism//lib/prism/pack.rb#86
  def length; end

  # The length type of this directive (used for integers).
  #
  # source://prism//lib/prism/pack.rb#83
  def length_type; end

  # The type of signedness of the directive.
  #
  # source://prism//lib/prism/pack.rb#74
  def signed; end

  # The size of the directive.
  #
  # source://prism//lib/prism/pack.rb#80
  def size; end

  # A byteslice of the source string that this directive represents.
  #
  # source://prism//lib/prism/pack.rb#68
  def source; end

  # The type of the directive.
  #
  # source://prism//lib/prism/pack.rb#71
  def type; end

  # A symbol representing whether or not we are packing or unpacking.
  #
  # source://prism//lib/prism/pack.rb#65
  def variant; end

  # A symbol representing the version of Ruby.
  #
  # source://prism//lib/prism/pack.rb#62
  def version; end
end

# The descriptions of the various types of endianness.
#
# source://prism//lib/prism/pack.rb#102
Prism::Pack::Directive::ENDIAN_DESCRIPTIONS = T.let(T.unsafe(nil), Hash)

# The descriptions of the various types of signedness.
#
# source://prism//lib/prism/pack.rb#111
Prism::Pack::Directive::SIGNED_DESCRIPTIONS = T.let(T.unsafe(nil), Hash)

# The descriptions of the various types of sizes.
#
# source://prism//lib/prism/pack.rb#118
Prism::Pack::Directive::SIZE_DESCRIPTIONS = T.let(T.unsafe(nil), Hash)

# source://prism//lib/prism/pack.rb#56
Prism::Pack::ENDIAN_NA = T.let(T.unsafe(nil), Symbol)

# source://prism//lib/prism/pack.rb#56
Prism::Pack::FLOAT = T.let(T.unsafe(nil), Symbol)

# The result of parsing a pack template.
#
# source://prism//lib/prism/pack.rb#198
class Prism::Pack::Format
  # Create a new Format with the given directives and encoding.
  #
  # @return [Format] a new instance of Format
  #
  # source://prism//lib/prism/pack.rb#206
  def initialize(directives, encoding); end

  # Provide a human-readable description of the format.
  #
  # source://prism//lib/prism/pack.rb#212
  def describe; end

  # A list of the directives in the template.
  #
  # source://prism//lib/prism/pack.rb#200
  def directives; end

  # The encoding of the template.
  #
  # source://prism//lib/prism/pack.rb#203
  def encoding; end
end

# source://prism//lib/prism/pack.rb#56
Prism::Pack::INTEGER = T.let(T.unsafe(nil), Symbol)

# source://prism//lib/prism/pack.rb#56
Prism::Pack::LENGTH_FIXED = T.let(T.unsafe(nil), Symbol)

# source://prism//lib/prism/pack.rb#56
Prism::Pack::LENGTH_MAX = T.let(T.unsafe(nil), Symbol)

# source://prism//lib/prism/pack.rb#56
Prism::Pack::LENGTH_NA = T.let(T.unsafe(nil), Symbol)

# source://prism//lib/prism/pack.rb#56
Prism::Pack::LENGTH_RELATIVE = T.let(T.unsafe(nil), Symbol)

# source://prism//lib/prism/pack.rb#56
Prism::Pack::LITTLE_ENDIAN = T.let(T.unsafe(nil), Symbol)

# source://prism//lib/prism/pack.rb#56
Prism::Pack::MOVE = T.let(T.unsafe(nil), Symbol)

# source://prism//lib/prism/pack.rb#56
Prism::Pack::NATIVE_ENDIAN = T.let(T.unsafe(nil), Symbol)

# source://prism//lib/prism/pack.rb#56
Prism::Pack::NULL = T.let(T.unsafe(nil), Symbol)

# source://prism//lib/prism/pack.rb#56
Prism::Pack::SIGNED = T.let(T.unsafe(nil), Symbol)

# source://prism//lib/prism/pack.rb#56
Prism::Pack::SIGNED_NA = T.let(T.unsafe(nil), Symbol)

# source://prism//lib/prism/pack.rb#56
Prism::Pack::SIZE_16 = T.let(T.unsafe(nil), Symbol)

# source://prism//lib/prism/pack.rb#56
Prism::Pack::SIZE_32 = T.let(T.unsafe(nil), Symbol)

# source://prism//lib/prism/pack.rb#56
Prism::Pack::SIZE_64 = T.let(T.unsafe(nil), Symbol)

# source://prism//lib/prism/pack.rb#56
Prism::Pack::SIZE_8 = T.let(T.unsafe(nil), Symbol)

# source://prism//lib/prism/pack.rb#56
Prism::Pack::SIZE_INT = T.let(T.unsafe(nil), Symbol)

# source://prism//lib/prism/pack.rb#56
Prism::Pack::SIZE_LONG = T.let(T.unsafe(nil), Symbol)

# source://prism//lib/prism/pack.rb#56
Prism::Pack::SIZE_LONG_LONG = T.let(T.unsafe(nil), Symbol)

# source://prism//lib/prism/pack.rb#56
Prism::Pack::SIZE_NA = T.let(T.unsafe(nil), Symbol)

# source://prism//lib/prism/pack.rb#56
Prism::Pack::SIZE_P = T.let(T.unsafe(nil), Symbol)

# source://prism//lib/prism/pack.rb#56
Prism::Pack::SIZE_SHORT = T.let(T.unsafe(nil), Symbol)

# source://prism//lib/prism/pack.rb#56
Prism::Pack::SPACE = T.let(T.unsafe(nil), Symbol)

# source://prism//lib/prism/pack.rb#56
Prism::Pack::STRING_BASE64 = T.let(T.unsafe(nil), Symbol)

# source://prism//lib/prism/pack.rb#56
Prism::Pack::STRING_FIXED = T.let(T.unsafe(nil), Symbol)

# source://prism//lib/prism/pack.rb#56
Prism::Pack::STRING_HEX_HIGH = T.let(T.unsafe(nil), Symbol)

# source://prism//lib/prism/pack.rb#56
Prism::Pack::STRING_HEX_LOW = T.let(T.unsafe(nil), Symbol)

# source://prism//lib/prism/pack.rb#56
Prism::Pack::STRING_LSB = T.let(T.unsafe(nil), Symbol)

# source://prism//lib/prism/pack.rb#56
Prism::Pack::STRING_MIME = T.let(T.unsafe(nil), Symbol)

# source://prism//lib/prism/pack.rb#56
Prism::Pack::STRING_MSB = T.let(T.unsafe(nil), Symbol)

# source://prism//lib/prism/pack.rb#56
Prism::Pack::STRING_NULL_PADDED = T.let(T.unsafe(nil), Symbol)

# source://prism//lib/prism/pack.rb#56
Prism::Pack::STRING_NULL_TERMINATED = T.let(T.unsafe(nil), Symbol)

# source://prism//lib/prism/pack.rb#56
Prism::Pack::STRING_POINTER = T.let(T.unsafe(nil), Symbol)

# source://prism//lib/prism/pack.rb#56
Prism::Pack::STRING_SPACE_PADDED = T.let(T.unsafe(nil), Symbol)

# source://prism//lib/prism/pack.rb#56
Prism::Pack::STRING_UU = T.let(T.unsafe(nil), Symbol)

# source://prism//lib/prism/pack.rb#56
Prism::Pack::UNSIGNED = T.let(T.unsafe(nil), Symbol)

# source://prism//lib/prism/pack.rb#56
Prism::Pack::UTF8 = T.let(T.unsafe(nil), Symbol)

# Flags for parameter nodes.
#
# source://prism//lib/prism/node.rb#16768
module Prism::ParameterFlags; end

# a parameter name that has been repeated in the method signature
#
# source://prism//lib/prism/node.rb#16770
Prism::ParameterFlags::REPEATED_PARAMETER = T.let(T.unsafe(nil), Integer)

# Represents the list of parameters on a method, block, or lambda definition.
#
#     def a(b, c, d)
#           ^^^^^^^
#     end
#
# source://prism//lib/prism/node.rb#12768
class Prism::ParametersNode < ::Prism::Node
  # Initialize a new ParametersNode node.
  #
  # @return [ParametersNode] a new instance of ParametersNode
  #
  # source://prism//lib/prism/node.rb#12770
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      requireds: T::Array[T.any(Prism::RequiredParameterNode, Prism::MultiTargetNode)],
      optionals: T::Array[Prism::OptionalParameterNode],
      rest: T.nilable(T.any(Prism::RestParameterNode, Prism::ImplicitRestNode)),
      posts: T::Array[T.any(Prism::RequiredParameterNode, Prism::MultiTargetNode, Prism::KeywordRestParameterNode, Prism::NoKeywordsParameterNode, Prism::ForwardingParameterNode)],
      keywords: T::Array[T.any(Prism::RequiredKeywordParameterNode, Prism::OptionalKeywordParameterNode)],
      keyword_rest: T.nilable(T.any(Prism::KeywordRestParameterNode, Prism::ForwardingParameterNode, Prism::NoKeywordsParameterNode)),
      block: T.nilable(Prism::BlockParameterNode)
    ).void
  end
  def initialize(source, node_id, location, flags, requireds, optionals, rest, posts, keywords, keyword_rest, block); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#12863
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#12785
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # attr_reader block: BlockParameterNode?
  #
  # source://prism//lib/prism/node.rb#12844
  sig { returns(T.nilable(Prism::BlockParameterNode)) }
  def block; end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#12790
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#12808
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#12795
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?requireds: Array[RequiredParameterNode | MultiTargetNode], ?optionals: Array[OptionalParameterNode], ?rest: RestParameterNode | ImplicitRestNode | nil, ?posts: Array[RequiredParameterNode | MultiTargetNode | KeywordRestParameterNode | NoKeywordsParameterNode | ForwardingParameterNode], ?keywords: Array[RequiredKeywordParameterNode | OptionalKeywordParameterNode], ?keyword_rest: KeywordRestParameterNode | ForwardingParameterNode | NoKeywordsParameterNode | nil, ?block: BlockParameterNode?) -> ParametersNode
  #
  # source://prism//lib/prism/node.rb#12813
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      requireds: T::Array[T.any(Prism::RequiredParameterNode, Prism::MultiTargetNode)],
      optionals: T::Array[Prism::OptionalParameterNode],
      rest: T.nilable(T.any(Prism::RestParameterNode, Prism::ImplicitRestNode)),
      posts: T::Array[T.any(Prism::RequiredParameterNode, Prism::MultiTargetNode, Prism::KeywordRestParameterNode, Prism::NoKeywordsParameterNode, Prism::ForwardingParameterNode)],
      keywords: T::Array[T.any(Prism::RequiredKeywordParameterNode, Prism::OptionalKeywordParameterNode)],
      keyword_rest: T.nilable(T.any(Prism::KeywordRestParameterNode, Prism::ForwardingParameterNode, Prism::NoKeywordsParameterNode)),
      block: T.nilable(Prism::BlockParameterNode)
    ).returns(Prism::ParametersNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), requireds: T.unsafe(nil), optionals: T.unsafe(nil), rest: T.unsafe(nil), posts: T.unsafe(nil), keywords: T.unsafe(nil), keyword_rest: T.unsafe(nil), block: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#12790
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, requireds: Array[RequiredParameterNode | MultiTargetNode], optionals: Array[OptionalParameterNode], rest: RestParameterNode | ImplicitRestNode | nil, posts: Array[RequiredParameterNode | MultiTargetNode | KeywordRestParameterNode | NoKeywordsParameterNode | ForwardingParameterNode], keywords: Array[RequiredKeywordParameterNode | OptionalKeywordParameterNode], keyword_rest: KeywordRestParameterNode | ForwardingParameterNode | NoKeywordsParameterNode | nil, block: BlockParameterNode? }
  #
  # source://prism//lib/prism/node.rb#12821
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#12847
  sig { override.returns(String) }
  def inspect; end

  # attr_reader keyword_rest: KeywordRestParameterNode | ForwardingParameterNode | NoKeywordsParameterNode | nil
  #
  # source://prism//lib/prism/node.rb#12841
  sig do
    returns(T.nilable(T.any(Prism::KeywordRestParameterNode, Prism::ForwardingParameterNode, Prism::NoKeywordsParameterNode)))
  end
  def keyword_rest; end

  # attr_reader keywords: Array[RequiredKeywordParameterNode | OptionalKeywordParameterNode]
  #
  # source://prism//lib/prism/node.rb#12838
  sig { returns(T::Array[T.any(Prism::RequiredKeywordParameterNode, Prism::OptionalKeywordParameterNode)]) }
  def keywords; end

  # attr_reader optionals: Array[OptionalParameterNode]
  #
  # source://prism//lib/prism/node.rb#12829
  sig { returns(T::Array[Prism::OptionalParameterNode]) }
  def optionals; end

  # attr_reader posts: Array[RequiredParameterNode | MultiTargetNode | KeywordRestParameterNode | NoKeywordsParameterNode | ForwardingParameterNode]
  #
  # source://prism//lib/prism/node.rb#12835
  sig do
    returns(T::Array[T.any(Prism::RequiredParameterNode, Prism::MultiTargetNode, Prism::KeywordRestParameterNode, Prism::NoKeywordsParameterNode, Prism::ForwardingParameterNode)])
  end
  def posts; end

  # attr_reader requireds: Array[RequiredParameterNode | MultiTargetNode]
  #
  # source://prism//lib/prism/node.rb#12826
  sig { returns(T::Array[T.any(Prism::RequiredParameterNode, Prism::MultiTargetNode)]) }
  def requireds; end

  # attr_reader rest: RestParameterNode | ImplicitRestNode | nil
  #
  # source://prism//lib/prism/node.rb#12832
  sig { returns(T.nilable(T.any(Prism::RestParameterNode, Prism::ImplicitRestNode))) }
  def rest; end

  # Mirrors the Method#parameters method.
  #
  # source://prism//lib/prism/node_ext.rb#269
  sig { returns(T::Array[T.any([Symbol, Symbol], [Symbol])]) }
  def signature; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#12852
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#12857
    def type; end
  end
end

# Represents a parenthesized expression
#
#     (10 + 34)
#     ^^^^^^^^^
#
# source://prism//lib/prism/node.rb#12883
class Prism::ParenthesesNode < ::Prism::Node
  # Initialize a new ParenthesesNode node.
  #
  # @return [ParenthesesNode] a new instance of ParenthesesNode
  #
  # source://prism//lib/prism/node.rb#12885
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      body: T.nilable(Prism::Node),
      opening_loc: Prism::Location,
      closing_loc: Prism::Location
    ).void
  end
  def initialize(source, node_id, location, flags, body, opening_loc, closing_loc); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#12974
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#12896
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # attr_reader body: Prism::node?
  #
  # source://prism//lib/prism/node.rb#12931
  sig { returns(T.nilable(Prism::Node)) }
  def body; end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#12901
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def closing: () -> String
  #
  # source://prism//lib/prism/node.rb#12953
  sig { returns(String) }
  def closing; end

  # attr_reader closing_loc: Location
  #
  # source://prism//lib/prism/node.rb#12941
  sig { returns(Prism::Location) }
  def closing_loc; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#12913
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#12906
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?body: Prism::node?, ?opening_loc: Location, ?closing_loc: Location) -> ParenthesesNode
  #
  # source://prism//lib/prism/node.rb#12918
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      body: T.nilable(Prism::Node),
      opening_loc: Prism::Location,
      closing_loc: Prism::Location
    ).returns(Prism::ParenthesesNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), body: T.unsafe(nil), opening_loc: T.unsafe(nil), closing_loc: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#12901
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, body: Prism::node?, opening_loc: Location, closing_loc: Location }
  #
  # source://prism//lib/prism/node.rb#12926
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#12958
  sig { override.returns(String) }
  def inspect; end

  # source://prism//lib/prism/parse_result/newlines.rb#85
  def newline_flag!(lines); end

  # def opening: () -> String
  #
  # source://prism//lib/prism/node.rb#12948
  sig { returns(String) }
  def opening; end

  # attr_reader opening_loc: Location
  #
  # source://prism//lib/prism/node.rb#12934
  sig { returns(Prism::Location) }
  def opening_loc; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#12963
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#12968
    def type; end
  end
end

# This represents an error that was encountered during parsing.
#
# source://prism//lib/prism/parse_result.rb#592
class Prism::ParseError
  # Create a new error object with the given message and location.
  #
  # @return [ParseError] a new instance of ParseError
  #
  # source://prism//lib/prism/parse_result.rb#607
  sig { params(type: Symbol, message: String, location: Prism::Location, level: Symbol).void }
  def initialize(type, message, location, level); end

  # Implement the hash pattern matching interface for ParseError.
  #
  # source://prism//lib/prism/parse_result.rb#615
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # Returns a string representation of this error.
  #
  # source://prism//lib/prism/parse_result.rb#620
  sig { returns(String) }
  def inspect; end

  # The level of this error.
  #
  # source://prism//lib/prism/parse_result.rb#604
  sig { returns(Symbol) }
  def level; end

  # A Location object representing the location of this error in the source.
  #
  # source://prism//lib/prism/parse_result.rb#601
  sig { returns(Prism::Location) }
  def location; end

  # The message associated with this error.
  #
  # source://prism//lib/prism/parse_result.rb#598
  sig { returns(String) }
  def message; end

  # The type of error. This is an _internal_ symbol that is used for
  # communicating with translation layers. It is not meant to be public API.
  #
  # source://prism//lib/prism/parse_result.rb#595
  sig { returns(Symbol) }
  def type; end
end

# This is a result specific to the `parse_lex` and `parse_lex_file` methods.
#
# source://prism//lib/prism/parse_result.rb#781
class Prism::ParseLexResult < ::Prism::Result
  # Create a new parse lex result object with the given values.
  #
  # @return [ParseLexResult] a new instance of ParseLexResult
  #
  # source://prism//lib/prism/parse_result.rb#787
  sig do
    params(
      value: [Prism::ProgramNode, T::Array[T.untyped]],
      comments: T::Array[Prism::Comment],
      magic_comments: T::Array[Prism::MagicComment],
      data_loc: T.nilable(Prism::Location),
      errors: T::Array[Prism::ParseError],
      warnings: T::Array[Prism::ParseWarning],
      source: Prism::Source
    ).void
  end
  def initialize(value, comments, magic_comments, data_loc, errors, warnings, source); end

  # Implement the hash pattern matching interface for ParseLexResult.
  #
  # source://prism//lib/prism/parse_result.rb#793
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # A tuple of the syntax tree and the list of tokens that were parsed from
  # the source code.
  #
  # source://prism//lib/prism/parse_result.rb#784
  sig { returns([Prism::ProgramNode, T::Array[T.untyped]]) }
  def value; end
end

# This is a result specific to the `parse` and `parse_file` methods.
#
# source://prism//lib/prism/parse_result.rb#722
class Prism::ParseResult < ::Prism::Result
  # Create a new parse result object with the given values.
  #
  # @return [ParseResult] a new instance of ParseResult
  #
  # source://prism//lib/prism/parse_result.rb#735
  sig do
    params(
      value: Prism::ProgramNode,
      comments: T::Array[Prism::Comment],
      magic_comments: T::Array[Prism::MagicComment],
      data_loc: T.nilable(Prism::Location),
      errors: T::Array[Prism::ParseError],
      warnings: T::Array[Prism::ParseWarning],
      source: Prism::Source
    ).void
  end
  def initialize(value, comments, magic_comments, data_loc, errors, warnings, source); end

  # Attach the list of comments to their respective locations in the tree.
  #
  # source://prism//lib/prism/parse_result.rb#746
  def attach_comments!; end

  # Implement the hash pattern matching interface for ParseResult.
  #
  # source://prism//lib/prism/parse_result.rb#741
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # Returns a string representation of the syntax tree with the errors
  # displayed inline.
  #
  # source://prism//lib/prism/parse_result.rb#758
  def errors_format; end

  # Walk the tree and mark nodes that are on a new line, loosely emulating
  # the behavior of CRuby's `:line` tracepoint event.
  #
  # source://prism//lib/prism/parse_result.rb#752
  def mark_newlines!; end

  # The syntax tree that was parsed from the source code.
  #
  # source://prism//lib/prism/parse_result.rb#732
  sig { returns(Prism::ProgramNode) }
  def value; end
end

# When we've parsed the source, we have both the syntax tree and the list of
# comments that we found in the source. This class is responsible for
# walking the tree and finding the nearest location to attach each comment.
#
# It does this by first finding the nearest locations to each comment.
# Locations can either come from nodes directly or from location fields on
# nodes. For example, a `ClassNode` has an overall location encompassing the
# entire class, but it also has a location for the `class` keyword.
#
# Once the nearest locations are found, it determines which one to attach
# to. If it's a trailing comment (a comment on the same line as other source
# code), it will favor attaching to the nearest location that occurs before
# the comment. Otherwise it will favor attaching to the nearest location
# that is after the comment.
#
# source://prism//lib/prism/parse_result/comments.rb#19
class Prism::ParseResult::Comments
  # Create a new Comments object that will attach comments to the given
  # parse result.
  #
  # @return [Comments] a new instance of Comments
  #
  # source://prism//lib/prism/parse_result/comments.rb#86
  def initialize(parse_result); end

  # Attach the comments to their respective locations in the tree by
  # mutating the parse result.
  #
  # source://prism//lib/prism/parse_result/comments.rb#92
  def attach!; end

  # The parse result that we are attaching comments to.
  #
  # source://prism//lib/prism/parse_result/comments.rb#82
  def parse_result; end

  private

  # Responsible for finding the nearest targets to the given comment within
  # the context of the given encapsulating node.
  #
  # source://prism//lib/prism/parse_result/comments.rb#119
  def nearest_targets(node, comment); end
end

# A target for attaching comments that is based on a location field on a
# node. For example, the `end` token of a ClassNode.
#
# source://prism//lib/prism/parse_result/comments.rb#53
class Prism::ParseResult::Comments::LocationTarget
  # @return [LocationTarget] a new instance of LocationTarget
  #
  # source://prism//lib/prism/parse_result/comments.rb#56
  def initialize(location); end

  # @return [Boolean]
  #
  # source://prism//lib/prism/parse_result/comments.rb#68
  def encloses?(comment); end

  # source://prism//lib/prism/parse_result/comments.rb#64
  def end_offset; end

  # source://prism//lib/prism/parse_result/comments.rb#72
  def leading_comment(comment); end

  # source://prism//lib/prism/parse_result/comments.rb#54
  def location; end

  # source://prism//lib/prism/parse_result/comments.rb#60
  def start_offset; end

  # source://prism//lib/prism/parse_result/comments.rb#76
  def trailing_comment(comment); end
end

# A target for attaching comments that is based on a specific node's
# location.
#
# source://prism//lib/prism/parse_result/comments.rb#22
class Prism::ParseResult::Comments::NodeTarget
  # @return [NodeTarget] a new instance of NodeTarget
  #
  # source://prism//lib/prism/parse_result/comments.rb#25
  def initialize(node); end

  # @return [Boolean]
  #
  # source://prism//lib/prism/parse_result/comments.rb#37
  def encloses?(comment); end

  # source://prism//lib/prism/parse_result/comments.rb#33
  def end_offset; end

  # source://prism//lib/prism/parse_result/comments.rb#42
  def leading_comment(comment); end

  # source://prism//lib/prism/parse_result/comments.rb#23
  def node; end

  # source://prism//lib/prism/parse_result/comments.rb#29
  def start_offset; end

  # source://prism//lib/prism/parse_result/comments.rb#46
  def trailing_comment(comment); end
end

# An object to represent the set of errors on a parse result. This object
# can be used to format the errors in a human-readable way.
#
# source://prism//lib/prism/parse_result/errors.rb#9
class Prism::ParseResult::Errors
  # Initialize a new set of errors from the given parse result.
  #
  # @return [Errors] a new instance of Errors
  #
  # source://prism//lib/prism/parse_result/errors.rb#14
  def initialize(parse_result); end

  # Formats the errors in a human-readable way and return them as a string.
  #
  # source://prism//lib/prism/parse_result/errors.rb#19
  def format; end

  # The parse result that contains the errors.
  #
  # source://prism//lib/prism/parse_result/errors.rb#11
  def parse_result; end
end

# The :line tracepoint event gets fired whenever the Ruby VM encounters an
# expression on a new line. The types of expressions that can trigger this
# event are:
#
# * if statements
# * unless statements
# * nodes that are children of statements lists
#
# In order to keep track of the newlines, we have a list of offsets that
# come back from the parser. We assign these offsets to the first nodes that
# we find in the tree that are on those lines.
#
# Note that the logic in this file should be kept in sync with the Java
# MarkNewlinesVisitor, since that visitor is responsible for marking the
# newlines for JRuby/TruffleRuby.
#
# This file is autoloaded only when `mark_newlines!` is called, so the
# re-opening of the various nodes in this file will only be performed in
# that case. We do that to avoid storing the extra `@newline` instance
# variable on every node if we don't need it.
#
# source://prism//lib/prism/parse_result/newlines.rb#25
class Prism::ParseResult::Newlines < ::Prism::Visitor
  # Create a new Newlines visitor with the given newline offsets.
  #
  # @return [Newlines] a new instance of Newlines
  #
  # source://prism//lib/prism/parse_result/newlines.rb#27
  def initialize(lines); end

  # Permit block/lambda nodes to mark newlines within themselves.
  #
  # source://prism//lib/prism/parse_result/newlines.rb#33
  def visit_block_node(node); end

  # Mark if/unless nodes as newlines.
  #
  # source://prism//lib/prism/parse_result/newlines.rb#47
  def visit_if_node(node); end

  # Permit block/lambda nodes to mark newlines within themselves.
  #
  # source://prism//lib/prism/parse_result/newlines.rb#33
  def visit_lambda_node(node); end

  # Permit statements lists to mark newlines within themselves.
  #
  # source://prism//lib/prism/parse_result/newlines.rb#55
  def visit_statements_node(node); end

  # Mark if/unless nodes as newlines.
  #
  # source://prism//lib/prism/parse_result/newlines.rb#47
  def visit_unless_node(node); end
end

# This represents a warning that was encountered during parsing.
#
# source://prism//lib/prism/parse_result.rb#626
class Prism::ParseWarning
  # Create a new warning object with the given message and location.
  #
  # @return [ParseWarning] a new instance of ParseWarning
  #
  # source://prism//lib/prism/parse_result.rb#641
  sig { params(type: Symbol, message: String, location: Prism::Location, level: Symbol).void }
  def initialize(type, message, location, level); end

  # Implement the hash pattern matching interface for ParseWarning.
  #
  # source://prism//lib/prism/parse_result.rb#649
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # Returns a string representation of this warning.
  #
  # source://prism//lib/prism/parse_result.rb#654
  sig { returns(String) }
  def inspect; end

  # The level of this warning.
  #
  # source://prism//lib/prism/parse_result.rb#638
  sig { returns(Symbol) }
  def level; end

  # A Location object representing the location of this warning in the source.
  #
  # source://prism//lib/prism/parse_result.rb#635
  sig { returns(Prism::Location) }
  def location; end

  # The message associated with this warning.
  #
  # source://prism//lib/prism/parse_result.rb#632
  sig { returns(String) }
  def message; end

  # The type of warning. This is an _internal_ symbol that is used for
  # communicating with translation layers. It is not meant to be public API.
  #
  # source://prism//lib/prism/parse_result.rb#629
  sig { returns(Symbol) }
  def type; end
end

# A pattern is an object that wraps a Ruby pattern matching expression. The
# expression would normally be passed to an `in` clause within a `case`
# expression or a rightward assignment expression. For example, in the
# following snippet:
#
#     case node
#     in ConstantPathNode[ConstantReadNode[name: :Prism], ConstantReadNode[name: :Pattern]]
#     end
#
# the pattern is the <tt>ConstantPathNode[...]</tt> expression.
#
# The pattern gets compiled into an object that responds to #call by running
# the #compile method. This method itself will run back through Prism to
# parse the expression into a tree, then walk the tree to generate the
# necessary callable objects. For example, if you wanted to compile the
# expression above into a callable, you would:
#
#     callable = Prism::Pattern.new("ConstantPathNode[ConstantReadNode[name: :Prism], ConstantReadNode[name: :Pattern]]").compile
#     callable.call(node)
#
# The callable object returned by #compile is guaranteed to respond to #call
# with a single argument, which is the node to match against. It also is
# guaranteed to respond to #===, which means it itself can be used in a `case`
# expression, as in:
#
#     case node
#     when callable
#     end
#
# If the query given to the initializer cannot be compiled into a valid
# matcher (either because of a syntax error or because it is using syntax we
# do not yet support) then a Prism::Pattern::CompilationError will be
# raised.
#
# source://prism//lib/prism/pattern.rb#37
class Prism::Pattern
  # Create a new pattern with the given query. The query should be a string
  # containing a Ruby pattern matching expression.
  #
  # @return [Pattern] a new instance of Pattern
  #
  # source://prism//lib/prism/pattern.rb#63
  def initialize(query); end

  # Compile the query into a callable object that can be used to match against
  # nodes.
  #
  # @raise [CompilationError]
  #
  # source://prism//lib/prism/pattern.rb#70
  def compile; end

  # The query that this pattern was initialized with.
  #
  # source://prism//lib/prism/pattern.rb#59
  def query; end

  # Scan the given node and all of its children for nodes that match the
  # pattern. If a block is given, it will be called with each node that
  # matches the pattern. If no block is given, an enumerator will be returned
  # that will yield each node that matches the pattern.
  #
  # source://prism//lib/prism/pattern.rb#86
  def scan(root); end

  private

  # Shortcut for combining two procs into one that returns true if both return
  # true.
  #
  # source://prism//lib/prism/pattern.rb#102
  def combine_and(left, right); end

  # Shortcut for combining two procs into one that returns true if either
  # returns true.
  #
  # source://prism//lib/prism/pattern.rb#108
  def combine_or(left, right); end

  # in foo | bar
  #
  # source://prism//lib/prism/pattern.rb#143
  def compile_alternation_pattern_node(node); end

  # in [foo, bar, baz]
  #
  # source://prism//lib/prism/pattern.rb#118
  def compile_array_pattern_node(node); end

  # Compile a name associated with a constant.
  #
  # source://prism//lib/prism/pattern.rb#168
  def compile_constant_name(node, name); end

  # in Prism::ConstantReadNode
  #
  # source://prism//lib/prism/pattern.rb#148
  def compile_constant_path_node(node); end

  # in ConstantReadNode
  # in String
  #
  # source://prism//lib/prism/pattern.rb#163
  def compile_constant_read_node(node); end

  # Raise an error because the given node is not supported.
  #
  # @raise [CompilationError]
  #
  # source://prism//lib/prism/pattern.rb#113
  def compile_error(node); end

  # in InstanceVariableReadNode[name: Symbol]
  # in { name: Symbol }
  #
  # source://prism//lib/prism/pattern.rb#184
  def compile_hash_pattern_node(node); end

  # in nil
  #
  # source://prism//lib/prism/pattern.rb#214
  def compile_nil_node(node); end

  # Compile any kind of node. Dispatch out to the individual compilation
  # methods based on the type of node.
  #
  # source://prism//lib/prism/pattern.rb#243
  def compile_node(node); end

  # in /foo/
  #
  # source://prism//lib/prism/pattern.rb#219
  def compile_regular_expression_node(node); end

  # in ""
  # in "foo"
  #
  # source://prism//lib/prism/pattern.rb#227
  def compile_string_node(node); end

  # in :+
  # in :foo
  #
  # source://prism//lib/prism/pattern.rb#235
  def compile_symbol_node(node); end
end

# Raised when the query given to a pattern is either invalid Ruby syntax or
# is using syntax that we don't yet support.
#
# source://prism//lib/prism/pattern.rb#40
class Prism::Pattern::CompilationError < ::StandardError
  # Create a new CompilationError with the given representation of the node
  # that caused the error.
  #
  # @return [CompilationError] a new instance of CompilationError
  #
  # source://prism//lib/prism/pattern.rb#43
  def initialize(repr); end
end

# Represents the use of the `^` operator for pinning an expression in a pattern matching expression.
#
#     foo in ^(bar)
#            ^^^^^^
#
# source://prism//lib/prism/node.rb#12986
class Prism::PinnedExpressionNode < ::Prism::Node
  # Initialize a new PinnedExpressionNode node.
  #
  # @return [PinnedExpressionNode] a new instance of PinnedExpressionNode
  #
  # source://prism//lib/prism/node.rb#12988
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      expression: Prism::Node,
      operator_loc: Prism::Location,
      lparen_loc: Prism::Location,
      rparen_loc: Prism::Location
    ).void
  end
  def initialize(source, node_id, location, flags, expression, operator_loc, lparen_loc, rparen_loc); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#13088
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#13000
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#13005
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#13015
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#13010
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?expression: Prism::node, ?operator_loc: Location, ?lparen_loc: Location, ?rparen_loc: Location) -> PinnedExpressionNode
  #
  # source://prism//lib/prism/node.rb#13020
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      expression: Prism::Node,
      operator_loc: Prism::Location,
      lparen_loc: Prism::Location,
      rparen_loc: Prism::Location
    ).returns(Prism::PinnedExpressionNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), expression: T.unsafe(nil), operator_loc: T.unsafe(nil), lparen_loc: T.unsafe(nil), rparen_loc: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#13005
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, expression: Prism::node, operator_loc: Location, lparen_loc: Location, rparen_loc: Location }
  #
  # source://prism//lib/prism/node.rb#13028
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # attr_reader expression: Prism::node
  #
  # source://prism//lib/prism/node.rb#13033
  sig { returns(Prism::Node) }
  def expression; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#13072
  sig { override.returns(String) }
  def inspect; end

  # def lparen: () -> String
  #
  # source://prism//lib/prism/node.rb#13062
  sig { returns(String) }
  def lparen; end

  # attr_reader lparen_loc: Location
  #
  # source://prism//lib/prism/node.rb#13043
  sig { returns(Prism::Location) }
  def lparen_loc; end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#13057
  sig { returns(String) }
  def operator; end

  # attr_reader operator_loc: Location
  #
  # source://prism//lib/prism/node.rb#13036
  sig { returns(Prism::Location) }
  def operator_loc; end

  # def rparen: () -> String
  #
  # source://prism//lib/prism/node.rb#13067
  sig { returns(String) }
  def rparen; end

  # attr_reader rparen_loc: Location
  #
  # source://prism//lib/prism/node.rb#13050
  sig { returns(Prism::Location) }
  def rparen_loc; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#13077
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#13082
    def type; end
  end
end

# Represents the use of the `^` operator for pinning a variable in a pattern matching expression.
#
#     foo in ^bar
#            ^^^^
#
# source://prism//lib/prism/node.rb#13101
class Prism::PinnedVariableNode < ::Prism::Node
  # Initialize a new PinnedVariableNode node.
  #
  # @return [PinnedVariableNode] a new instance of PinnedVariableNode
  #
  # source://prism//lib/prism/node.rb#13103
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      variable: T.any(Prism::LocalVariableReadNode, Prism::InstanceVariableReadNode, Prism::ClassVariableReadNode, Prism::GlobalVariableReadNode, Prism::BackReferenceReadNode, Prism::NumberedReferenceReadNode, Prism::ItLocalVariableReadNode, Prism::MissingNode),
      operator_loc: Prism::Location
    ).void
  end
  def initialize(source, node_id, location, flags, variable, operator_loc); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#13177
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#13113
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#13118
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#13128
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#13123
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?variable: LocalVariableReadNode | InstanceVariableReadNode | ClassVariableReadNode | GlobalVariableReadNode | BackReferenceReadNode | NumberedReferenceReadNode | ItLocalVariableReadNode | MissingNode, ?operator_loc: Location) -> PinnedVariableNode
  #
  # source://prism//lib/prism/node.rb#13133
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      variable: T.any(Prism::LocalVariableReadNode, Prism::InstanceVariableReadNode, Prism::ClassVariableReadNode, Prism::GlobalVariableReadNode, Prism::BackReferenceReadNode, Prism::NumberedReferenceReadNode, Prism::ItLocalVariableReadNode, Prism::MissingNode),
      operator_loc: Prism::Location
    ).returns(Prism::PinnedVariableNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), variable: T.unsafe(nil), operator_loc: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#13118
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, variable: LocalVariableReadNode | InstanceVariableReadNode | ClassVariableReadNode | GlobalVariableReadNode | BackReferenceReadNode | NumberedReferenceReadNode | ItLocalVariableReadNode | MissingNode, operator_loc: Location }
  #
  # source://prism//lib/prism/node.rb#13141
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#13161
  sig { override.returns(String) }
  def inspect; end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#13156
  sig { returns(String) }
  def operator; end

  # attr_reader operator_loc: Location
  #
  # source://prism//lib/prism/node.rb#13149
  sig { returns(Prism::Location) }
  def operator_loc; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#13166
  sig { override.returns(Symbol) }
  def type; end

  # attr_reader variable: LocalVariableReadNode | InstanceVariableReadNode | ClassVariableReadNode | GlobalVariableReadNode | BackReferenceReadNode | NumberedReferenceReadNode | ItLocalVariableReadNode | MissingNode
  #
  # source://prism//lib/prism/node.rb#13146
  sig do
    returns(T.any(Prism::LocalVariableReadNode, Prism::InstanceVariableReadNode, Prism::ClassVariableReadNode, Prism::GlobalVariableReadNode, Prism::BackReferenceReadNode, Prism::NumberedReferenceReadNode, Prism::ItLocalVariableReadNode, Prism::MissingNode))
  end
  def variable; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#13171
    def type; end
  end
end

# Represents the use of the `END` keyword.
#
#     END { foo }
#     ^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#13188
class Prism::PostExecutionNode < ::Prism::Node
  # Initialize a new PostExecutionNode node.
  #
  # @return [PostExecutionNode] a new instance of PostExecutionNode
  #
  # source://prism//lib/prism/node.rb#13190
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      statements: T.nilable(Prism::StatementsNode),
      keyword_loc: Prism::Location,
      opening_loc: Prism::Location,
      closing_loc: Prism::Location
    ).void
  end
  def initialize(source, node_id, location, flags, statements, keyword_loc, opening_loc, closing_loc); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#13292
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#13202
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#13207
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def closing: () -> String
  #
  # source://prism//lib/prism/node.rb#13271
  sig { returns(String) }
  def closing; end

  # attr_reader closing_loc: Location
  #
  # source://prism//lib/prism/node.rb#13254
  sig { returns(Prism::Location) }
  def closing_loc; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#13219
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#13212
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?statements: StatementsNode?, ?keyword_loc: Location, ?opening_loc: Location, ?closing_loc: Location) -> PostExecutionNode
  #
  # source://prism//lib/prism/node.rb#13224
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      statements: T.nilable(Prism::StatementsNode),
      keyword_loc: Prism::Location,
      opening_loc: Prism::Location,
      closing_loc: Prism::Location
    ).returns(Prism::PostExecutionNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), statements: T.unsafe(nil), keyword_loc: T.unsafe(nil), opening_loc: T.unsafe(nil), closing_loc: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#13207
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, statements: StatementsNode?, keyword_loc: Location, opening_loc: Location, closing_loc: Location }
  #
  # source://prism//lib/prism/node.rb#13232
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#13276
  sig { override.returns(String) }
  def inspect; end

  # def keyword: () -> String
  #
  # source://prism//lib/prism/node.rb#13261
  sig { returns(String) }
  def keyword; end

  # attr_reader keyword_loc: Location
  #
  # source://prism//lib/prism/node.rb#13240
  sig { returns(Prism::Location) }
  def keyword_loc; end

  # def opening: () -> String
  #
  # source://prism//lib/prism/node.rb#13266
  sig { returns(String) }
  def opening; end

  # attr_reader opening_loc: Location
  #
  # source://prism//lib/prism/node.rb#13247
  sig { returns(Prism::Location) }
  def opening_loc; end

  # attr_reader statements: StatementsNode?
  #
  # source://prism//lib/prism/node.rb#13237
  sig { returns(T.nilable(Prism::StatementsNode)) }
  def statements; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#13281
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#13286
    def type; end
  end
end

# Represents the use of the `BEGIN` keyword.
#
#     BEGIN { foo }
#     ^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#13305
class Prism::PreExecutionNode < ::Prism::Node
  # Initialize a new PreExecutionNode node.
  #
  # @return [PreExecutionNode] a new instance of PreExecutionNode
  #
  # source://prism//lib/prism/node.rb#13307
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      statements: T.nilable(Prism::StatementsNode),
      keyword_loc: Prism::Location,
      opening_loc: Prism::Location,
      closing_loc: Prism::Location
    ).void
  end
  def initialize(source, node_id, location, flags, statements, keyword_loc, opening_loc, closing_loc); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#13409
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#13319
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#13324
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def closing: () -> String
  #
  # source://prism//lib/prism/node.rb#13388
  sig { returns(String) }
  def closing; end

  # attr_reader closing_loc: Location
  #
  # source://prism//lib/prism/node.rb#13371
  sig { returns(Prism::Location) }
  def closing_loc; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#13336
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#13329
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?statements: StatementsNode?, ?keyword_loc: Location, ?opening_loc: Location, ?closing_loc: Location) -> PreExecutionNode
  #
  # source://prism//lib/prism/node.rb#13341
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      statements: T.nilable(Prism::StatementsNode),
      keyword_loc: Prism::Location,
      opening_loc: Prism::Location,
      closing_loc: Prism::Location
    ).returns(Prism::PreExecutionNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), statements: T.unsafe(nil), keyword_loc: T.unsafe(nil), opening_loc: T.unsafe(nil), closing_loc: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#13324
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, statements: StatementsNode?, keyword_loc: Location, opening_loc: Location, closing_loc: Location }
  #
  # source://prism//lib/prism/node.rb#13349
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#13393
  sig { override.returns(String) }
  def inspect; end

  # def keyword: () -> String
  #
  # source://prism//lib/prism/node.rb#13378
  sig { returns(String) }
  def keyword; end

  # attr_reader keyword_loc: Location
  #
  # source://prism//lib/prism/node.rb#13357
  sig { returns(Prism::Location) }
  def keyword_loc; end

  # def opening: () -> String
  #
  # source://prism//lib/prism/node.rb#13383
  sig { returns(String) }
  def opening; end

  # attr_reader opening_loc: Location
  #
  # source://prism//lib/prism/node.rb#13364
  sig { returns(Prism::Location) }
  def opening_loc; end

  # attr_reader statements: StatementsNode?
  #
  # source://prism//lib/prism/node.rb#13354
  sig { returns(T.nilable(Prism::StatementsNode)) }
  def statements; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#13398
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#13403
    def type; end
  end
end

# The top level node of any parse tree.
#
# source://prism//lib/prism/node.rb#13419
class Prism::ProgramNode < ::Prism::Node
  # Initialize a new ProgramNode node.
  #
  # @return [ProgramNode] a new instance of ProgramNode
  #
  # source://prism//lib/prism/node.rb#13421
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      locals: T::Array[Symbol],
      statements: Prism::StatementsNode
    ).void
  end
  def initialize(source, node_id, location, flags, locals, statements); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#13486
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#13431
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#13436
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#13446
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#13441
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?locals: Array[Symbol], ?statements: StatementsNode) -> ProgramNode
  #
  # source://prism//lib/prism/node.rb#13451
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      locals: T::Array[Symbol],
      statements: Prism::StatementsNode
    ).returns(Prism::ProgramNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), locals: T.unsafe(nil), statements: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#13436
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, locals: Array[Symbol], statements: StatementsNode }
  #
  # source://prism//lib/prism/node.rb#13459
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#13470
  sig { override.returns(String) }
  def inspect; end

  # attr_reader locals: Array[Symbol]
  #
  # source://prism//lib/prism/node.rb#13464
  sig { returns(T::Array[Symbol]) }
  def locals; end

  # attr_reader statements: StatementsNode
  #
  # source://prism//lib/prism/node.rb#13467
  sig { returns(Prism::StatementsNode) }
  def statements; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#13475
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#13480
    def type; end
  end
end

# Flags for range and flip-flop nodes.
#
# source://prism//lib/prism/node.rb#16774
module Prism::RangeFlags; end

# ... operator
#
# source://prism//lib/prism/node.rb#16776
Prism::RangeFlags::EXCLUDE_END = T.let(T.unsafe(nil), Integer)

# Represents the use of the `..` or `...` operators.
#
#     1..2
#     ^^^^
#
#     c if a =~ /left/ ... b =~ /right/
#          ^^^^^^^^^^^^^^^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#13501
class Prism::RangeNode < ::Prism::Node
  # Initialize a new RangeNode node.
  #
  # @return [RangeNode] a new instance of RangeNode
  #
  # source://prism//lib/prism/node.rb#13503
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      left: T.nilable(Prism::Node),
      right: T.nilable(Prism::Node),
      operator_loc: Prism::Location
    ).void
  end
  def initialize(source, node_id, location, flags, left, right, operator_loc); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#13602
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#13514
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#13519
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#13532
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#13524
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?left: Prism::node?, ?right: Prism::node?, ?operator_loc: Location) -> RangeNode
  #
  # source://prism//lib/prism/node.rb#13537
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      left: T.nilable(Prism::Node),
      right: T.nilable(Prism::Node),
      operator_loc: Prism::Location
    ).returns(Prism::RangeNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), left: T.unsafe(nil), right: T.unsafe(nil), operator_loc: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#13519
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, left: Prism::node?, right: Prism::node?, operator_loc: Location }
  #
  # source://prism//lib/prism/node.rb#13545
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def exclude_end?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#13550
  sig { returns(T::Boolean) }
  def exclude_end?; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#13586
  sig { override.returns(String) }
  def inspect; end

  # The left-hand side of the range, if present. It can be either `nil` or any [non-void expression](https://github.com/ruby/prism/blob/main/docs/parsing_rules.md#non-void-expression).
  #
  #     1...
  #     ^
  #
  #     hello...goodbye
  #     ^^^^^
  #
  # source://prism//lib/prism/node.rb#13561
  sig { returns(T.nilable(Prism::Node)) }
  def left; end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#13581
  sig { returns(String) }
  def operator; end

  # The location of the `..` or `...` operator.
  #
  # source://prism//lib/prism/node.rb#13574
  sig { returns(Prism::Location) }
  def operator_loc; end

  # The right-hand side of the range, if present. It can be either `nil` or any [non-void expression](https://github.com/ruby/prism/blob/main/docs/parsing_rules.md#non-void-expression).
  #
  #     ..5
  #       ^
  #
  #     1...foo
  #         ^^^
  # If neither right-hand or left-hand side was included, this will be a MissingNode.
  #
  # source://prism//lib/prism/node.rb#13571
  sig { returns(T.nilable(Prism::Node)) }
  def right; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#13591
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#13596
    def type; end
  end
end

# Represents a rational number literal.
#
#     1.0r
#     ^^^^
#
# source://prism//lib/prism/node.rb#13615
class Prism::RationalNode < ::Prism::Node
  # Initialize a new RationalNode node.
  #
  # @return [RationalNode] a new instance of RationalNode
  #
  # source://prism//lib/prism/node.rb#13617
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      numerator: Integer,
      denominator: Integer
    ).void
  end
  def initialize(source, node_id, location, flags, numerator, denominator); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#13706
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#13627
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def binary?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#13660
  sig { returns(T::Boolean) }
  def binary?; end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#13632
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#13642
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#13637
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?numerator: Integer, ?denominator: Integer) -> RationalNode
  #
  # source://prism//lib/prism/node.rb#13647
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      numerator: Integer,
      denominator: Integer
    ).returns(Prism::RationalNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), numerator: T.unsafe(nil), denominator: T.unsafe(nil)); end

  # def decimal?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#13665
  sig { returns(T::Boolean) }
  def decimal?; end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#13632
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, numerator: Integer, denominator: Integer }
  #
  # source://prism//lib/prism/node.rb#13655
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # The denominator of the rational number.
  #
  #     1.5r # denominator 2
  #
  # source://prism//lib/prism/node.rb#13687
  sig { returns(Integer) }
  def denominator; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def hexadecimal?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#13675
  sig { returns(T::Boolean) }
  def hexadecimal?; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#13690
  sig { override.returns(String) }
  def inspect; end

  # The numerator of the rational number.
  #
  #     1.5r # numerator 3
  #
  # source://prism//lib/prism/node.rb#13682
  sig { returns(Integer) }
  def numerator; end

  # Returns the value of the node as an IntegerNode or a FloatNode. This
  # method is deprecated in favor of #value or #numerator/#denominator.
  #
  # source://prism//lib/prism/node_ext.rb#120
  def numeric; end

  # def octal?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#13670
  sig { returns(T::Boolean) }
  def octal?; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#13695
  sig { override.returns(Symbol) }
  def type; end

  # Returns the value of the node as a Ruby Rational.
  #
  # source://prism//lib/prism/node_ext.rb#114
  sig { returns(Rational) }
  def value; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#13700
    def type; end
  end
end

# Represents the use of the `redo` keyword.
#
#     redo
#     ^^^^
#
# source://prism//lib/prism/node.rb#13718
class Prism::RedoNode < ::Prism::Node
  # Initialize a new RedoNode node.
  #
  # @return [RedoNode] a new instance of RedoNode
  #
  # source://prism//lib/prism/node.rb#13720
  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer).void }
  def initialize(source, node_id, location, flags); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#13777
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#13728
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#13733
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#13743
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#13738
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer) -> RedoNode
  #
  # source://prism//lib/prism/node.rb#13748
  sig { params(node_id: Integer, location: Prism::Location, flags: Integer).returns(Prism::RedoNode) }
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#13733
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location }
  #
  # source://prism//lib/prism/node.rb#13756
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#13761
  sig { override.returns(String) }
  def inspect; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#13766
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#13771
    def type; end
  end
end

# The Reflection module provides the ability to reflect on the structure of
# the syntax tree itself, as opposed to looking at a single syntax tree. This
# is useful in metaprogramming contexts.
#
# source://prism//lib/prism/reflection.rb#13
module Prism::Reflection
  class << self
    # Returns the fields for the given node.
    #
    # source://prism//lib/prism/reflection.rb#104
    sig { params(node: T.class_of(Prism::Node)).returns(T::Array[Prism::Reflection::Field]) }
    def fields_for(node); end
  end
end

# A constant field represents a constant value on a node. Effectively, it
# represents an identifier found within the source. It resolves to a symbol
# in Ruby.
#
# source://prism//lib/prism/reflection.rb#45
class Prism::Reflection::ConstantField < ::Prism::Reflection::Field; end

# A constant list field represents a list of constant values on a node. It
# resolves to an array of symbols in Ruby.
#
# source://prism//lib/prism/reflection.rb#55
class Prism::Reflection::ConstantListField < ::Prism::Reflection::Field; end

# A field represents a single piece of data on a node. It is the base class
# for all other field types.
#
# source://prism//lib/prism/reflection.rb#16
class Prism::Reflection::Field
  # Initializes the field with the given name.
  #
  # @return [Field] a new instance of Field
  #
  # source://prism//lib/prism/reflection.rb#21
  sig { params(name: Symbol).void }
  def initialize(name); end

  # The name of the field.
  #
  # source://prism//lib/prism/reflection.rb#18
  sig { returns(Symbol) }
  def name; end
end

# A flags field represents a bitset of flags on a node. It resolves to an
# integer in Ruby. Note that the flags cannot be accessed directly on the
# node because the integer is kept private. Instead, the various flags in
# the bitset should be accessed through their query methods.
#
# source://prism//lib/prism/reflection.rb#92
class Prism::Reflection::FlagsField < ::Prism::Reflection::Field
  # Initializes the flags field with the given name and flags.
  #
  # @return [FlagsField] a new instance of FlagsField
  #
  # source://prism//lib/prism/reflection.rb#97
  sig { params(name: Symbol, flags: T::Array[Symbol]).void }
  def initialize(name, flags); end

  # The names of the flags in the bitset.
  #
  # source://prism//lib/prism/reflection.rb#94
  sig { returns(T::Array[Symbol]) }
  def flags; end
end

# A float field represents a double-precision floating point value. It is
# used exclusively to represent the value of a floating point literal. It
# resolves to a Float in Ruby.
#
# source://prism//lib/prism/reflection.rb#85
class Prism::Reflection::FloatField < ::Prism::Reflection::Field; end

# An integer field represents an integer value. It is used to represent the
# value of an integer literal, the depth of local variables, and the number
# of a numbered reference. It resolves to an Integer in Ruby.
#
# source://prism//lib/prism/reflection.rb#79
class Prism::Reflection::IntegerField < ::Prism::Reflection::Field; end

# A location field represents the location of some part of the node in the
# source code. For example, the location of a keyword or an operator. It
# resolves to a Prism::Location in Ruby.
#
# source://prism//lib/prism/reflection.rb#67
class Prism::Reflection::LocationField < ::Prism::Reflection::Field; end

# A node field represents a single child node in the syntax tree. It
# resolves to a Prism::Node in Ruby.
#
# source://prism//lib/prism/reflection.rb#28
class Prism::Reflection::NodeField < ::Prism::Reflection::Field; end

# A node list field represents a list of child nodes in the syntax tree. It
# resolves to an array of Prism::Node instances in Ruby.
#
# source://prism//lib/prism/reflection.rb#39
class Prism::Reflection::NodeListField < ::Prism::Reflection::Field; end

# An optional constant field represents a constant value on a node that may
# or may not be present. It resolves to either a symbol or nil in Ruby.
#
# source://prism//lib/prism/reflection.rb#50
class Prism::Reflection::OptionalConstantField < ::Prism::Reflection::Field; end

# An optional location field represents the location of some part of the
# node in the source code that may or may not be present. It resolves to
# either a Prism::Location or nil in Ruby.
#
# source://prism//lib/prism/reflection.rb#73
class Prism::Reflection::OptionalLocationField < ::Prism::Reflection::Field; end

# An optional node field represents a single child node in the syntax tree
# that may or may not be present. It resolves to either a Prism::Node or nil
# in Ruby.
#
# source://prism//lib/prism/reflection.rb#34
class Prism::Reflection::OptionalNodeField < ::Prism::Reflection::Field; end

# A string field represents a string value on a node. It almost always
# represents the unescaped value of a string-like literal. It resolves to a
# string in Ruby.
#
# source://prism//lib/prism/reflection.rb#61
class Prism::Reflection::StringField < ::Prism::Reflection::Field; end

# Flags for regular expression and match last line nodes.
#
# source://prism//lib/prism/node.rb#16780
module Prism::RegularExpressionFlags; end

# n - forces the ASCII-8BIT encoding
#
# source://prism//lib/prism/node.rb#16797
Prism::RegularExpressionFlags::ASCII_8BIT = T.let(T.unsafe(nil), Integer)

# e - forces the EUC-JP encoding
#
# source://prism//lib/prism/node.rb#16794
Prism::RegularExpressionFlags::EUC_JP = T.let(T.unsafe(nil), Integer)

# x - ignores whitespace and allows comments in regular expressions
#
# source://prism//lib/prism/node.rb#16785
Prism::RegularExpressionFlags::EXTENDED = T.let(T.unsafe(nil), Integer)

# internal bytes forced the encoding to binary
#
# source://prism//lib/prism/node.rb#16809
Prism::RegularExpressionFlags::FORCED_BINARY_ENCODING = T.let(T.unsafe(nil), Integer)

# internal bytes forced the encoding to US-ASCII
#
# source://prism//lib/prism/node.rb#16812
Prism::RegularExpressionFlags::FORCED_US_ASCII_ENCODING = T.let(T.unsafe(nil), Integer)

# internal bytes forced the encoding to UTF-8
#
# source://prism//lib/prism/node.rb#16806
Prism::RegularExpressionFlags::FORCED_UTF8_ENCODING = T.let(T.unsafe(nil), Integer)

# i - ignores the case of characters when matching
#
# source://prism//lib/prism/node.rb#16782
Prism::RegularExpressionFlags::IGNORE_CASE = T.let(T.unsafe(nil), Integer)

# m - allows $ to match the end of lines within strings
#
# source://prism//lib/prism/node.rb#16788
Prism::RegularExpressionFlags::MULTI_LINE = T.let(T.unsafe(nil), Integer)

# o - only interpolates values into the regular expression once
#
# source://prism//lib/prism/node.rb#16791
Prism::RegularExpressionFlags::ONCE = T.let(T.unsafe(nil), Integer)

# u - forces the UTF-8 encoding
#
# source://prism//lib/prism/node.rb#16803
Prism::RegularExpressionFlags::UTF_8 = T.let(T.unsafe(nil), Integer)

# s - forces the Windows-31J encoding
#
# source://prism//lib/prism/node.rb#16800
Prism::RegularExpressionFlags::WINDOWS_31J = T.let(T.unsafe(nil), Integer)

# Represents a regular expression literal with no interpolation.
#
#     /foo/i
#     ^^^^^^
#
# source://prism//lib/prism/node.rb#13786
class Prism::RegularExpressionNode < ::Prism::Node
  include ::Prism::RegularExpressionOptions

  # Initialize a new RegularExpressionNode node.
  #
  # @return [RegularExpressionNode] a new instance of RegularExpressionNode
  #
  # source://prism//lib/prism/node.rb#13788
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      opening_loc: Prism::Location,
      content_loc: Prism::Location,
      closing_loc: Prism::Location,
      unescaped: String
    ).void
  end
  def initialize(source, node_id, location, flags, opening_loc, content_loc, closing_loc, unescaped); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#13943
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#13800
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def ascii_8bit?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#13858
  sig { returns(T::Boolean) }
  def ascii_8bit?; end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#13805
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def closing: () -> String
  #
  # source://prism//lib/prism/node.rb#13922
  sig { returns(String) }
  def closing; end

  # attr_reader closing_loc: Location
  #
  # source://prism//lib/prism/node.rb#13902
  sig { returns(Prism::Location) }
  def closing_loc; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#13815
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#13810
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def content: () -> String
  #
  # source://prism//lib/prism/node.rb#13917
  sig { returns(String) }
  def content; end

  # attr_reader content_loc: Location
  #
  # source://prism//lib/prism/node.rb#13895
  sig { returns(Prism::Location) }
  def content_loc; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?opening_loc: Location, ?content_loc: Location, ?closing_loc: Location, ?unescaped: String) -> RegularExpressionNode
  #
  # source://prism//lib/prism/node.rb#13820
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      opening_loc: Prism::Location,
      content_loc: Prism::Location,
      closing_loc: Prism::Location,
      unescaped: String
    ).returns(Prism::RegularExpressionNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), opening_loc: T.unsafe(nil), content_loc: T.unsafe(nil), closing_loc: T.unsafe(nil), unescaped: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#13805
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, opening_loc: Location, content_loc: Location, closing_loc: Location, unescaped: String }
  #
  # source://prism//lib/prism/node.rb#13828
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def euc_jp?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#13853
  sig { returns(T::Boolean) }
  def euc_jp?; end

  # def extended?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#13838
  sig { returns(T::Boolean) }
  def extended?; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def forced_binary_encoding?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#13878
  sig { returns(T::Boolean) }
  def forced_binary_encoding?; end

  # def forced_us_ascii_encoding?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#13883
  sig { returns(T::Boolean) }
  def forced_us_ascii_encoding?; end

  # def forced_utf8_encoding?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#13873
  sig { returns(T::Boolean) }
  def forced_utf8_encoding?; end

  # def ignore_case?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#13833
  sig { returns(T::Boolean) }
  def ignore_case?; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#13927
  sig { override.returns(String) }
  def inspect; end

  # def multi_line?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#13843
  sig { returns(T::Boolean) }
  def multi_line?; end

  # def once?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#13848
  sig { returns(T::Boolean) }
  def once?; end

  # def opening: () -> String
  #
  # source://prism//lib/prism/node.rb#13912
  sig { returns(String) }
  def opening; end

  # attr_reader opening_loc: Location
  #
  # source://prism//lib/prism/node.rb#13888
  sig { returns(Prism::Location) }
  def opening_loc; end

  sig { returns(Integer) }
  def options; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#13932
  sig { override.returns(Symbol) }
  def type; end

  # attr_reader unescaped: String
  #
  # source://prism//lib/prism/node.rb#13909
  sig { returns(String) }
  def unescaped; end

  # def utf_8?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#13868
  sig { returns(T::Boolean) }
  def utf_8?; end

  # def windows_31j?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#13863
  sig { returns(T::Boolean) }
  def windows_31j?; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#13937
    def type; end
  end
end

# source://prism//lib/prism/node_ext.rb#20
module Prism::RegularExpressionOptions
  # Returns a numeric value that represents the flags that were used to create
  # the regular expression.
  #
  # source://prism//lib/prism/node_ext.rb#23
  def options; end
end

# Represents a required keyword parameter to a method, block, or lambda definition.
#
#     def a(b: )
#           ^^
#     end
#
# source://prism//lib/prism/node.rb#13958
class Prism::RequiredKeywordParameterNode < ::Prism::Node
  # Initialize a new RequiredKeywordParameterNode node.
  #
  # @return [RequiredKeywordParameterNode] a new instance of RequiredKeywordParameterNode
  #
  # source://prism//lib/prism/node.rb#13960
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      name_loc: Prism::Location
    ).void
  end
  def initialize(source, node_id, location, flags, name, name_loc); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#14034
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#13970
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#13975
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#13985
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#13980
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?name: Symbol, ?name_loc: Location) -> RequiredKeywordParameterNode
  #
  # source://prism//lib/prism/node.rb#13990
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol,
      name_loc: Prism::Location
    ).returns(Prism::RequiredKeywordParameterNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil), name_loc: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#13975
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, name: Symbol, name_loc: Location }
  #
  # source://prism//lib/prism/node.rb#13998
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#14018
  sig { override.returns(String) }
  def inspect; end

  # attr_reader name: Symbol
  #
  # source://prism//lib/prism/node.rb#14008
  sig { returns(Symbol) }
  def name; end

  # attr_reader name_loc: Location
  #
  # source://prism//lib/prism/node.rb#14011
  sig { returns(Prism::Location) }
  def name_loc; end

  # def repeated_parameter?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#14003
  sig { returns(T::Boolean) }
  def repeated_parameter?; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#14023
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#14028
    def type; end
  end
end

# Represents a required parameter to a method, block, or lambda definition.
#
#     def a(b)
#           ^
#     end
#
# source://prism//lib/prism/node.rb#14047
class Prism::RequiredParameterNode < ::Prism::Node
  # Initialize a new RequiredParameterNode node.
  #
  # @return [RequiredParameterNode] a new instance of RequiredParameterNode
  #
  # source://prism//lib/prism/node.rb#14049
  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol).void }
  def initialize(source, node_id, location, flags, name); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#14115
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#14058
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#14063
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#14073
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#14068
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?name: Symbol) -> RequiredParameterNode
  #
  # source://prism//lib/prism/node.rb#14078
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: Symbol
    ).returns(Prism::RequiredParameterNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#14063
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, name: Symbol }
  #
  # source://prism//lib/prism/node.rb#14086
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#14099
  sig { override.returns(String) }
  def inspect; end

  # attr_reader name: Symbol
  #
  # source://prism//lib/prism/node.rb#14096
  sig { returns(Symbol) }
  def name; end

  # def repeated_parameter?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#14091
  sig { returns(T::Boolean) }
  def repeated_parameter?; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#14104
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#14109
    def type; end
  end
end

# Represents an expression modified with a rescue.
#
#     foo rescue nil
#     ^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#14126
class Prism::RescueModifierNode < ::Prism::Node
  # Initialize a new RescueModifierNode node.
  #
  # @return [RescueModifierNode] a new instance of RescueModifierNode
  #
  # source://prism//lib/prism/node.rb#14128
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      expression: Prism::Node,
      keyword_loc: Prism::Location,
      rescue_expression: Prism::Node
    ).void
  end
  def initialize(source, node_id, location, flags, expression, keyword_loc, rescue_expression); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#14206
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#14139
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#14144
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#14154
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#14149
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?expression: Prism::node, ?keyword_loc: Location, ?rescue_expression: Prism::node) -> RescueModifierNode
  #
  # source://prism//lib/prism/node.rb#14159
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      expression: Prism::Node,
      keyword_loc: Prism::Location,
      rescue_expression: Prism::Node
    ).returns(Prism::RescueModifierNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), expression: T.unsafe(nil), keyword_loc: T.unsafe(nil), rescue_expression: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#14144
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, expression: Prism::node, keyword_loc: Location, rescue_expression: Prism::node }
  #
  # source://prism//lib/prism/node.rb#14167
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # attr_reader expression: Prism::node
  #
  # source://prism//lib/prism/node.rb#14172
  sig { returns(Prism::Node) }
  def expression; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#14190
  sig { override.returns(String) }
  def inspect; end

  # def keyword: () -> String
  #
  # source://prism//lib/prism/node.rb#14185
  sig { returns(String) }
  def keyword; end

  # attr_reader keyword_loc: Location
  #
  # source://prism//lib/prism/node.rb#14175
  sig { returns(Prism::Location) }
  def keyword_loc; end

  # source://prism//lib/prism/parse_result/newlines.rb#115
  def newline_flag!(lines); end

  # attr_reader rescue_expression: Prism::node
  #
  # source://prism//lib/prism/node.rb#14182
  sig { returns(Prism::Node) }
  def rescue_expression; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#14195
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#14200
    def type; end
  end
end

# Represents a rescue statement.
#
#     begin
#     rescue Foo, *splat, Bar => ex
#       foo
#     ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
#     end
#
# `Foo, *splat, Bar` are in the `exceptions` field. `ex` is in the `reference` field.
#
# source://prism//lib/prism/node.rb#14223
class Prism::RescueNode < ::Prism::Node
  # Initialize a new RescueNode node.
  #
  # @return [RescueNode] a new instance of RescueNode
  #
  # source://prism//lib/prism/node.rb#14225
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      keyword_loc: Prism::Location,
      exceptions: T::Array[Prism::Node],
      operator_loc: T.nilable(Prism::Location),
      reference: T.nilable(T.any(Prism::LocalVariableTargetNode, Prism::InstanceVariableTargetNode, Prism::ClassVariableTargetNode, Prism::GlobalVariableTargetNode, Prism::ConstantTargetNode, Prism::ConstantPathTargetNode, Prism::CallTargetNode, Prism::IndexTargetNode, Prism::BackReferenceReadNode, Prism::NumberedReferenceReadNode, Prism::MissingNode)),
      statements: T.nilable(Prism::StatementsNode),
      subsequent: T.nilable(Prism::RescueNode)
    ).void
  end
  def initialize(source, node_id, location, flags, keyword_loc, exceptions, operator_loc, reference, statements, subsequent); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#14335
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#14239
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#14244
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#14259
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#14249
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # Returns the subsequent rescue clause of the rescue node. This method is
  # deprecated in favor of #subsequent.
  #
  # source://prism//lib/prism/node_ext.rb#494
  def consequent; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?keyword_loc: Location, ?exceptions: Array[Prism::node], ?operator_loc: Location?, ?reference: LocalVariableTargetNode | InstanceVariableTargetNode | ClassVariableTargetNode | GlobalVariableTargetNode | ConstantTargetNode | ConstantPathTargetNode | CallTargetNode | IndexTargetNode | BackReferenceReadNode | NumberedReferenceReadNode | MissingNode | nil, ?statements: StatementsNode?, ?subsequent: RescueNode?) -> RescueNode
  #
  # source://prism//lib/prism/node.rb#14264
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      keyword_loc: Prism::Location,
      exceptions: T::Array[Prism::Node],
      operator_loc: T.nilable(Prism::Location),
      reference: T.nilable(T.any(Prism::LocalVariableTargetNode, Prism::InstanceVariableTargetNode, Prism::ClassVariableTargetNode, Prism::GlobalVariableTargetNode, Prism::ConstantTargetNode, Prism::ConstantPathTargetNode, Prism::CallTargetNode, Prism::IndexTargetNode, Prism::BackReferenceReadNode, Prism::NumberedReferenceReadNode, Prism::MissingNode)),
      statements: T.nilable(Prism::StatementsNode),
      subsequent: T.nilable(Prism::RescueNode)
    ).returns(Prism::RescueNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), keyword_loc: T.unsafe(nil), exceptions: T.unsafe(nil), operator_loc: T.unsafe(nil), reference: T.unsafe(nil), statements: T.unsafe(nil), subsequent: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#14244
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, keyword_loc: Location, exceptions: Array[Prism::node], operator_loc: Location?, reference: LocalVariableTargetNode | InstanceVariableTargetNode | ClassVariableTargetNode | GlobalVariableTargetNode | ConstantTargetNode | ConstantPathTargetNode | CallTargetNode | IndexTargetNode | BackReferenceReadNode | NumberedReferenceReadNode | MissingNode | nil, statements: StatementsNode?, subsequent: RescueNode? }
  #
  # source://prism//lib/prism/node.rb#14272
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # attr_reader exceptions: Array[Prism::node]
  #
  # source://prism//lib/prism/node.rb#14284
  sig { returns(T::Array[Prism::Node]) }
  def exceptions; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#14319
  sig { override.returns(String) }
  def inspect; end

  # def keyword: () -> String
  #
  # source://prism//lib/prism/node.rb#14309
  sig { returns(String) }
  def keyword; end

  # attr_reader keyword_loc: Location
  #
  # source://prism//lib/prism/node.rb#14277
  sig { returns(Prism::Location) }
  def keyword_loc; end

  # def operator: () -> String?
  #
  # source://prism//lib/prism/node.rb#14314
  sig { returns(T.nilable(String)) }
  def operator; end

  # attr_reader operator_loc: Location?
  #
  # source://prism//lib/prism/node.rb#14287
  sig { returns(T.nilable(Prism::Location)) }
  def operator_loc; end

  # attr_reader reference: LocalVariableTargetNode | InstanceVariableTargetNode | ClassVariableTargetNode | GlobalVariableTargetNode | ConstantTargetNode | ConstantPathTargetNode | CallTargetNode | IndexTargetNode | BackReferenceReadNode | NumberedReferenceReadNode | MissingNode | nil
  #
  # source://prism//lib/prism/node.rb#14300
  sig do
    returns(T.nilable(T.any(Prism::LocalVariableTargetNode, Prism::InstanceVariableTargetNode, Prism::ClassVariableTargetNode, Prism::GlobalVariableTargetNode, Prism::ConstantTargetNode, Prism::ConstantPathTargetNode, Prism::CallTargetNode, Prism::IndexTargetNode, Prism::BackReferenceReadNode, Prism::NumberedReferenceReadNode, Prism::MissingNode)))
  end
  def reference; end

  # attr_reader statements: StatementsNode?
  #
  # source://prism//lib/prism/node.rb#14303
  sig { returns(T.nilable(Prism::StatementsNode)) }
  def statements; end

  # attr_reader subsequent: RescueNode?
  #
  # source://prism//lib/prism/node.rb#14306
  sig { returns(T.nilable(Prism::RescueNode)) }
  def subsequent; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#14324
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#14329
    def type; end
  end
end

# Represents a rest parameter to a method, block, or lambda definition.
#
#     def a(*b)
#           ^^
#     end
#
# source://prism//lib/prism/node.rb#14352
class Prism::RestParameterNode < ::Prism::Node
  # Initialize a new RestParameterNode node.
  #
  # @return [RestParameterNode] a new instance of RestParameterNode
  #
  # source://prism//lib/prism/node.rb#14354
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: T.nilable(Symbol),
      name_loc: T.nilable(Prism::Location),
      operator_loc: Prism::Location
    ).void
  end
  def initialize(source, node_id, location, flags, name, name_loc, operator_loc); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#14447
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#14365
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#14370
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#14380
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#14375
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?name: Symbol?, ?name_loc: Location?, ?operator_loc: Location) -> RestParameterNode
  #
  # source://prism//lib/prism/node.rb#14385
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      name: T.nilable(Symbol),
      name_loc: T.nilable(Prism::Location),
      operator_loc: Prism::Location
    ).returns(Prism::RestParameterNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), name: T.unsafe(nil), name_loc: T.unsafe(nil), operator_loc: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#14370
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, name: Symbol?, name_loc: Location?, operator_loc: Location }
  #
  # source://prism//lib/prism/node.rb#14393
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#14431
  sig { override.returns(String) }
  def inspect; end

  # attr_reader name: Symbol?
  #
  # source://prism//lib/prism/node.rb#14403
  sig { returns(T.nilable(Symbol)) }
  def name; end

  # attr_reader name_loc: Location?
  #
  # source://prism//lib/prism/node.rb#14406
  sig { returns(T.nilable(Prism::Location)) }
  def name_loc; end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#14426
  sig { returns(String) }
  def operator; end

  # attr_reader operator_loc: Location
  #
  # source://prism//lib/prism/node.rb#14419
  sig { returns(Prism::Location) }
  def operator_loc; end

  # def repeated_parameter?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#14398
  sig { returns(T::Boolean) }
  def repeated_parameter?; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#14436
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#14441
    def type; end
  end
end

# This represents the result of a call to ::parse or ::parse_file. It contains
# the requested structure, any comments that were encounters, and any errors
# that were encountered.
#
# source://prism//lib/prism/parse_result.rb#662
class Prism::Result
  # Create a new result object with the given values.
  #
  # @return [Result] a new instance of Result
  #
  # source://prism//lib/prism/parse_result.rb#684
  sig do
    params(
      comments: T::Array[Prism::Comment],
      magic_comments: T::Array[Prism::MagicComment],
      data_loc: T.nilable(Prism::Location),
      errors: T::Array[Prism::ParseError],
      warnings: T::Array[Prism::ParseWarning],
      source: Prism::Source
    ).void
  end
  def initialize(comments, magic_comments, data_loc, errors, warnings, source); end

  # Create a code units cache for the given encoding.
  #
  # source://prism//lib/prism/parse_result.rb#716
  sig do
    params(
      encoding: Encoding
    ).returns(T.any(Prism::CodeUnitsCache, T.proc.params(byte_offset: Integer).returns(Integer)))
  end
  def code_units_cache(encoding); end

  # The list of comments that were encountered during parsing.
  #
  # source://prism//lib/prism/parse_result.rb#664
  sig { returns(T::Array[Prism::Comment]) }
  def comments; end

  # An optional location that represents the location of the __END__ marker
  # and the rest of the content of the file. This content is loaded into the
  # DATA constant when the file being parsed is the main file being executed.
  #
  # source://prism//lib/prism/parse_result.rb#672
  sig { returns(T.nilable(Prism::Location)) }
  def data_loc; end

  # Implement the hash pattern matching interface for Result.
  #
  # source://prism//lib/prism/parse_result.rb#694
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # Returns the encoding of the source code that was parsed.
  #
  # source://prism//lib/prism/parse_result.rb#699
  sig { returns(Encoding) }
  def encoding; end

  # The list of errors that were generated during parsing.
  #
  # source://prism//lib/prism/parse_result.rb#675
  sig { returns(T::Array[Prism::ParseError]) }
  def errors; end

  # Returns true if there were errors during parsing and false if there were
  # not.
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/parse_result.rb#711
  sig { returns(T::Boolean) }
  def failure?; end

  # The list of magic comments that were encountered during parsing.
  #
  # source://prism//lib/prism/parse_result.rb#667
  sig { returns(T::Array[Prism::MagicComment]) }
  def magic_comments; end

  # A Source instance that represents the source code that was parsed.
  #
  # source://prism//lib/prism/parse_result.rb#681
  sig { returns(Prism::Source) }
  def source; end

  # Returns true if there were no errors during parsing and false if there
  # were.
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/parse_result.rb#705
  sig { returns(T::Boolean) }
  def success?; end

  # The list of warnings that were generated during parsing.
  #
  # source://prism//lib/prism/parse_result.rb#678
  sig { returns(T::Array[Prism::ParseWarning]) }
  def warnings; end
end

# Represents the use of the `retry` keyword.
#
#     retry
#     ^^^^^
#
# source://prism//lib/prism/node.rb#14460
class Prism::RetryNode < ::Prism::Node
  # Initialize a new RetryNode node.
  #
  # @return [RetryNode] a new instance of RetryNode
  #
  # source://prism//lib/prism/node.rb#14462
  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer).void }
  def initialize(source, node_id, location, flags); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#14519
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#14470
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#14475
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#14485
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#14480
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer) -> RetryNode
  #
  # source://prism//lib/prism/node.rb#14490
  sig { params(node_id: Integer, location: Prism::Location, flags: Integer).returns(Prism::RetryNode) }
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#14475
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location }
  #
  # source://prism//lib/prism/node.rb#14498
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#14503
  sig { override.returns(String) }
  def inspect; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#14508
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#14513
    def type; end
  end
end

# Represents the use of the `return` keyword.
#
#     return 1
#     ^^^^^^^^
#
# source://prism//lib/prism/node.rb#14528
class Prism::ReturnNode < ::Prism::Node
  # Initialize a new ReturnNode node.
  #
  # @return [ReturnNode] a new instance of ReturnNode
  #
  # source://prism//lib/prism/node.rb#14530
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      keyword_loc: Prism::Location,
      arguments: T.nilable(Prism::ArgumentsNode)
    ).void
  end
  def initialize(source, node_id, location, flags, keyword_loc, arguments); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#14606
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#14540
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # attr_reader arguments: ArgumentsNode?
  #
  # source://prism//lib/prism/node.rb#14582
  sig { returns(T.nilable(Prism::ArgumentsNode)) }
  def arguments; end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#14545
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#14557
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#14550
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?keyword_loc: Location, ?arguments: ArgumentsNode?) -> ReturnNode
  #
  # source://prism//lib/prism/node.rb#14562
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      keyword_loc: Prism::Location,
      arguments: T.nilable(Prism::ArgumentsNode)
    ).returns(Prism::ReturnNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), keyword_loc: T.unsafe(nil), arguments: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#14545
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, keyword_loc: Location, arguments: ArgumentsNode? }
  #
  # source://prism//lib/prism/node.rb#14570
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#14590
  sig { override.returns(String) }
  def inspect; end

  # def keyword: () -> String
  #
  # source://prism//lib/prism/node.rb#14585
  sig { returns(String) }
  def keyword; end

  # attr_reader keyword_loc: Location
  #
  # source://prism//lib/prism/node.rb#14575
  sig { returns(Prism::Location) }
  def keyword_loc; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#14595
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#14600
    def type; end
  end
end

# Represents the `self` keyword.
#
#     self
#     ^^^^
#
# source://prism//lib/prism/node.rb#14617
class Prism::SelfNode < ::Prism::Node
  # Initialize a new SelfNode node.
  #
  # @return [SelfNode] a new instance of SelfNode
  #
  # source://prism//lib/prism/node.rb#14619
  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer).void }
  def initialize(source, node_id, location, flags); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#14676
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#14627
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#14632
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#14642
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#14637
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer) -> SelfNode
  #
  # source://prism//lib/prism/node.rb#14647
  sig { params(node_id: Integer, location: Prism::Location, flags: Integer).returns(Prism::SelfNode) }
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#14632
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location }
  #
  # source://prism//lib/prism/node.rb#14655
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#14660
  sig { override.returns(String) }
  def inspect; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#14665
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#14670
    def type; end
  end
end

# A module responsible for deserializing parse results.
#
# source://prism//lib/prism/serialize.rb#14
module Prism::Serialize
  class << self
    # Deserialize the AST represented by the given string into a parse result.
    #
    # source://prism//lib/prism/serialize.rb#28
    def load(input, serialized); end

    # Deserialize the tokens represented by the given string into a parse
    # result.
    #
    # source://prism//lib/prism/serialize.rb#51
    def load_tokens(source, serialized); end
  end
end

# source://prism//lib/prism/serialize.rb#55
class Prism::Serialize::Loader
  # @return [Loader] a new instance of Loader
  #
  # source://prism//lib/prism/serialize.rb#91
  def initialize(source, serialized); end

  # Returns the value of attribute constant_pool.
  #
  # source://prism//lib/prism/serialize.rb#88
  def constant_pool; end

  # Returns the value of attribute constant_pool_offset.
  #
  # source://prism//lib/prism/serialize.rb#88
  def constant_pool_offset; end

  # Returns the value of attribute encoding.
  #
  # source://prism//lib/prism/serialize.rb#87
  def encoding; end

  # Returns the value of attribute input.
  #
  # source://prism//lib/prism/serialize.rb#87
  def input; end

  # Returns the value of attribute io.
  #
  # source://prism//lib/prism/serialize.rb#87
  def io; end

  # source://prism//lib/prism/serialize.rb#129
  def load_comments; end

  # source://prism//lib/prism/serialize.rb#115
  def load_encoding; end

  # source://prism//lib/prism/serialize.rb#106
  def load_header; end

  # source://prism//lib/prism/serialize.rb#125
  def load_line_offsets; end

  # source://prism//lib/prism/serialize.rb#462
  def load_metadata; end

  # source://prism//lib/prism/serialize.rb#496
  def load_nodes; end

  # source://prism//lib/prism/serialize.rb#510
  def load_result; end

  # source://prism//lib/prism/serialize.rb#121
  def load_start_line; end

  # source://prism//lib/prism/serialize.rb#471
  def load_tokens; end

  # source://prism//lib/prism/serialize.rb#484
  def load_tokens_result; end

  # Returns the value of attribute serialized.
  #
  # source://prism//lib/prism/serialize.rb#87
  def serialized; end

  # Returns the value of attribute source.
  #
  # source://prism//lib/prism/serialize.rb#88
  def source; end

  # Returns the value of attribute start_line.
  #
  # source://prism//lib/prism/serialize.rb#89
  def start_line; end

  private

  # source://prism//lib/prism/serialize.rb#596
  def load_constant(index); end

  # source://prism//lib/prism/serialize.rb#549
  def load_double; end

  # source://prism//lib/prism/serialize.rb#564
  def load_embedded_string; end

  # source://prism//lib/prism/serialize.rb#626
  def load_error_level; end

  # source://prism//lib/prism/serialize.rb#538
  def load_integer; end

  # source://prism//lib/prism/serialize.rb#580
  def load_location; end

  # source://prism//lib/prism/serialize.rb#584
  def load_location_object; end

  # source://prism//lib/prism/serialize.rb#655
  def load_node; end

  # source://prism//lib/prism/serialize.rb#621
  def load_optional_constant; end

  # source://prism//lib/prism/serialize.rb#588
  def load_optional_location; end

  # source://prism//lib/prism/serialize.rb#592
  def load_optional_location_object; end

  # source://prism//lib/prism/serialize.rb#557
  def load_optional_node; end

  # source://prism//lib/prism/serialize.rb#617
  def load_required_constant; end

  # source://prism//lib/prism/serialize.rb#568
  def load_string; end

  # source://prism//lib/prism/serialize.rb#553
  def load_uint32; end

  # source://prism//lib/prism/serialize.rb#533
  def load_varsint; end

  # variable-length integer using https://en.wikipedia.org/wiki/LEB128
  # This is also what protobuf uses: https://protobuf.dev/programming-guides/encoding/#varints
  #
  # source://prism//lib/prism/serialize.rb#519
  def load_varuint; end

  # source://prism//lib/prism/serialize.rb#641
  def load_warning_level; end
end

# source://prism//lib/prism/serialize.rb#138
Prism::Serialize::Loader::DIAGNOSTIC_TYPES = T.let(T.unsafe(nil), Array)

# StringIO is synchronized and that adds a high overhead on TruffleRuby.
#
# source://prism//lib/prism/serialize.rb#83
Prism::Serialize::Loader::FastStringIO = StringIO

# The major version of prism that we are expecting to find in the serialized
# strings.
#
# source://prism//lib/prism/serialize.rb#17
Prism::Serialize::MAJOR_VERSION = T.let(T.unsafe(nil), Integer)

# The minor version of prism that we are expecting to find in the serialized
# strings.
#
# source://prism//lib/prism/serialize.rb#21
Prism::Serialize::MINOR_VERSION = T.let(T.unsafe(nil), Integer)

# The patch version of prism that we are expecting to find in the serialized
# strings.
#
# source://prism//lib/prism/serialize.rb#25
Prism::Serialize::PATCH_VERSION = T.let(T.unsafe(nil), Integer)

# The token types that can be indexed by their enum values.
#
# source://prism//lib/prism/serialize.rb#1737
Prism::Serialize::TOKEN_TYPES = T.let(T.unsafe(nil), Array)

# This node wraps a constant write to indicate that when the value is written, it should have its shareability state modified.
#
#     C = { a: 1 }
#     ^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#14686
class Prism::ShareableConstantNode < ::Prism::Node
  # Initialize a new ShareableConstantNode node.
  #
  # @return [ShareableConstantNode] a new instance of ShareableConstantNode
  #
  # source://prism//lib/prism/node.rb#14688
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      write: T.any(Prism::ConstantWriteNode, Prism::ConstantAndWriteNode, Prism::ConstantOrWriteNode, Prism::ConstantOperatorWriteNode, Prism::ConstantPathWriteNode, Prism::ConstantPathAndWriteNode, Prism::ConstantPathOrWriteNode, Prism::ConstantPathOperatorWriteNode)
    ).void
  end
  def initialize(source, node_id, location, flags, write); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#14764
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#14697
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#14702
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#14712
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#14707
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?write: ConstantWriteNode | ConstantAndWriteNode | ConstantOrWriteNode | ConstantOperatorWriteNode | ConstantPathWriteNode | ConstantPathAndWriteNode | ConstantPathOrWriteNode | ConstantPathOperatorWriteNode) -> ShareableConstantNode
  #
  # source://prism//lib/prism/node.rb#14717
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      write: T.any(Prism::ConstantWriteNode, Prism::ConstantAndWriteNode, Prism::ConstantOrWriteNode, Prism::ConstantOperatorWriteNode, Prism::ConstantPathWriteNode, Prism::ConstantPathAndWriteNode, Prism::ConstantPathOrWriteNode, Prism::ConstantPathOperatorWriteNode)
    ).returns(Prism::ShareableConstantNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), write: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#14702
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, write: ConstantWriteNode | ConstantAndWriteNode | ConstantOrWriteNode | ConstantOperatorWriteNode | ConstantPathWriteNode | ConstantPathAndWriteNode | ConstantPathOrWriteNode | ConstantPathOperatorWriteNode }
  #
  # source://prism//lib/prism/node.rb#14725
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def experimental_copy?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#14740
  sig { returns(T::Boolean) }
  def experimental_copy?; end

  # def experimental_everything?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#14735
  sig { returns(T::Boolean) }
  def experimental_everything?; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#14748
  sig { override.returns(String) }
  def inspect; end

  # def literal?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#14730
  sig { returns(T::Boolean) }
  def literal?; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#14753
  sig { override.returns(Symbol) }
  def type; end

  # The constant write that should be modified with the shareability state.
  #
  # source://prism//lib/prism/node.rb#14745
  sig do
    returns(T.any(Prism::ConstantWriteNode, Prism::ConstantAndWriteNode, Prism::ConstantOrWriteNode, Prism::ConstantOperatorWriteNode, Prism::ConstantPathWriteNode, Prism::ConstantPathAndWriteNode, Prism::ConstantPathOrWriteNode, Prism::ConstantPathOperatorWriteNode))
  end
  def write; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#14758
    def type; end
  end
end

# Flags for shareable constant nodes.
#
# source://prism//lib/prism/node.rb#16816
module Prism::ShareableConstantNodeFlags; end

# constant writes that should be modified with shareable constant value experimental copy
#
# source://prism//lib/prism/node.rb#16824
Prism::ShareableConstantNodeFlags::EXPERIMENTAL_COPY = T.let(T.unsafe(nil), Integer)

# constant writes that should be modified with shareable constant value experimental everything
#
# source://prism//lib/prism/node.rb#16821
Prism::ShareableConstantNodeFlags::EXPERIMENTAL_EVERYTHING = T.let(T.unsafe(nil), Integer)

# constant writes that should be modified with shareable constant value literal
#
# source://prism//lib/prism/node.rb#16818
Prism::ShareableConstantNodeFlags::LITERAL = T.let(T.unsafe(nil), Integer)

# Represents a singleton class declaration involving the `class` keyword.
#
#     class << self end
#     ^^^^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#14775
class Prism::SingletonClassNode < ::Prism::Node
  # Initialize a new SingletonClassNode node.
  #
  # @return [SingletonClassNode] a new instance of SingletonClassNode
  #
  # source://prism//lib/prism/node.rb#14777
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      locals: T::Array[Symbol],
      class_keyword_loc: Prism::Location,
      operator_loc: Prism::Location,
      expression: Prism::Node,
      body: T.nilable(T.any(Prism::StatementsNode, Prism::BeginNode)),
      end_keyword_loc: Prism::Location
    ).void
  end
  def initialize(source, node_id, location, flags, locals, class_keyword_loc, operator_loc, expression, body, end_keyword_loc); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#14888
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#14791
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # attr_reader body: StatementsNode | BeginNode | nil
  #
  # source://prism//lib/prism/node.rb#14847
  sig { returns(T.nilable(T.any(Prism::StatementsNode, Prism::BeginNode))) }
  def body; end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#14796
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def class_keyword: () -> String
  #
  # source://prism//lib/prism/node.rb#14857
  sig { returns(String) }
  def class_keyword; end

  # attr_reader class_keyword_loc: Location
  #
  # source://prism//lib/prism/node.rb#14830
  sig { returns(Prism::Location) }
  def class_keyword_loc; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#14809
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#14801
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?locals: Array[Symbol], ?class_keyword_loc: Location, ?operator_loc: Location, ?expression: Prism::node, ?body: StatementsNode | BeginNode | nil, ?end_keyword_loc: Location) -> SingletonClassNode
  #
  # source://prism//lib/prism/node.rb#14814
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      locals: T::Array[Symbol],
      class_keyword_loc: Prism::Location,
      operator_loc: Prism::Location,
      expression: Prism::Node,
      body: T.nilable(T.any(Prism::StatementsNode, Prism::BeginNode)),
      end_keyword_loc: Prism::Location
    ).returns(Prism::SingletonClassNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), locals: T.unsafe(nil), class_keyword_loc: T.unsafe(nil), operator_loc: T.unsafe(nil), expression: T.unsafe(nil), body: T.unsafe(nil), end_keyword_loc: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#14796
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, locals: Array[Symbol], class_keyword_loc: Location, operator_loc: Location, expression: Prism::node, body: StatementsNode | BeginNode | nil, end_keyword_loc: Location }
  #
  # source://prism//lib/prism/node.rb#14822
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # def end_keyword: () -> String
  #
  # source://prism//lib/prism/node.rb#14867
  sig { returns(String) }
  def end_keyword; end

  # attr_reader end_keyword_loc: Location
  #
  # source://prism//lib/prism/node.rb#14850
  sig { returns(Prism::Location) }
  def end_keyword_loc; end

  # attr_reader expression: Prism::node
  #
  # source://prism//lib/prism/node.rb#14844
  sig { returns(Prism::Node) }
  def expression; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#14872
  sig { override.returns(String) }
  def inspect; end

  # attr_reader locals: Array[Symbol]
  #
  # source://prism//lib/prism/node.rb#14827
  sig { returns(T::Array[Symbol]) }
  def locals; end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#14862
  sig { returns(String) }
  def operator; end

  # attr_reader operator_loc: Location
  #
  # source://prism//lib/prism/node.rb#14837
  sig { returns(Prism::Location) }
  def operator_loc; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#14877
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#14882
    def type; end
  end
end

# This represents a source of Ruby code that has been parsed. It is used in
# conjunction with locations to allow them to resolve line numbers and source
# ranges.
#
# source://prism//lib/prism/parse_result.rb#7
class Prism::Source
  # Create a new source object with the given source code.
  #
  # @return [Source] a new instance of Source
  #
  # source://prism//lib/prism/parse_result.rb#45
  sig { params(source: String, start_line: Integer, offsets: T::Array[Integer]).void }
  def initialize(source, start_line = T.unsafe(nil), offsets = T.unsafe(nil)); end

  # Return the column number in characters for the given byte offset.
  #
  # source://prism//lib/prism/parse_result.rb#97
  sig { params(byte_offset: Integer).returns(Integer) }
  def character_column(byte_offset); end

  # Return the character offset for the given byte offset.
  #
  # source://prism//lib/prism/parse_result.rb#92
  sig { params(byte_offset: Integer).returns(Integer) }
  def character_offset(byte_offset); end

  # Generate a cache that targets a specific encoding for calculating code
  # unit offsets.
  #
  # source://prism//lib/prism/parse_result.rb#125
  sig do
    params(
      encoding: Encoding
    ).returns(T.any(Prism::CodeUnitsCache, T.proc.params(byte_offset: Integer).returns(Integer)))
  end
  def code_units_cache(encoding); end

  # Returns the column number in code units for the given encoding for the
  # given byte offset.
  #
  # source://prism//lib/prism/parse_result.rb#131
  sig { params(byte_offset: Integer, encoding: Encoding).returns(Integer) }
  def code_units_column(byte_offset, encoding); end

  # Returns the offset from the start of the file for the given byte offset
  # counting in code units for the given encoding.
  #
  # This method is tested with UTF-8, UTF-16, and UTF-32. If there is the
  # concept of code units that differs from the number of characters in other
  # encodings, it is not captured here.
  #
  # We purposefully replace invalid and undefined characters with replacement
  # characters in this conversion. This happens for two reasons. First, it's
  # possible that the given byte offset will not occur on a character
  # boundary. Second, it's possible that the source code will contain a
  # character that has no equivalent in the given encoding.
  #
  # source://prism//lib/prism/parse_result.rb#113
  sig { params(byte_offset: Integer, encoding: Encoding).returns(Integer) }
  def code_units_offset(byte_offset, encoding); end

  # Return the column number for the given byte offset.
  #
  # source://prism//lib/prism/parse_result.rb#87
  sig { params(byte_offset: Integer).returns(Integer) }
  def column(byte_offset); end

  # Returns the encoding of the source code, which is set by parameters to the
  # parser or by the encoding magic comment.
  #
  # source://prism//lib/prism/parse_result.rb#53
  sig { returns(Encoding) }
  def encoding; end

  # Binary search through the offsets to find the line number for the given
  # byte offset.
  #
  # source://prism//lib/prism/parse_result.rb#70
  sig { params(byte_offset: Integer).returns(Integer) }
  def line(byte_offset); end

  # Returns the byte offset of the end of the line corresponding to the given
  # byte offset.
  #
  # source://prism//lib/prism/parse_result.rb#82
  def line_end(byte_offset); end

  # Return the byte offset of the start of the line corresponding to the given
  # byte offset.
  #
  # source://prism//lib/prism/parse_result.rb#76
  sig { params(byte_offset: Integer).returns(Integer) }
  def line_start(byte_offset); end

  # Returns the lines of the source code as an array of strings.
  #
  # source://prism//lib/prism/parse_result.rb#58
  sig { returns(T::Array[String]) }
  def lines; end

  # The list of newline byte offsets in the source code.
  #
  # source://prism//lib/prism/parse_result.rb#42
  sig { returns(T::Array[Integer]) }
  def offsets; end

  # Perform a byteslice on the source code using the given byte offset and
  # byte length.
  #
  # source://prism//lib/prism/parse_result.rb#64
  sig { params(byte_offset: Integer, length: Integer).returns(String) }
  def slice(byte_offset, length); end

  # The source code that this source object represents.
  #
  # source://prism//lib/prism/parse_result.rb#36
  sig { returns(String) }
  def source; end

  # The line number where this source starts.
  #
  # source://prism//lib/prism/parse_result.rb#39
  sig { returns(Integer) }
  def start_line; end

  private

  # Binary search through the offsets to find the line number for the given
  # byte offset.
  #
  # source://prism//lib/prism/parse_result.rb#139
  def find_line(byte_offset); end

  class << self
    # Create a new source object with the given source code. This method should
    # be used instead of `new` and it will return either a `Source` or a
    # specialized and more performant `ASCIISource` if no multibyte characters
    # are present in the source code.
    #
    # source://prism//lib/prism/parse_result.rb#12
    def for(source, start_line = T.unsafe(nil), offsets = T.unsafe(nil)); end
  end
end

# Represents the use of the `__ENCODING__` keyword.
#
#     __ENCODING__
#     ^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#14904
class Prism::SourceEncodingNode < ::Prism::Node
  # Initialize a new SourceEncodingNode node.
  #
  # @return [SourceEncodingNode] a new instance of SourceEncodingNode
  #
  # source://prism//lib/prism/node.rb#14906
  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer).void }
  def initialize(source, node_id, location, flags); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#14963
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#14914
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#14919
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#14929
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#14924
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer) -> SourceEncodingNode
  #
  # source://prism//lib/prism/node.rb#14934
  sig { params(node_id: Integer, location: Prism::Location, flags: Integer).returns(Prism::SourceEncodingNode) }
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#14919
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location }
  #
  # source://prism//lib/prism/node.rb#14942
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#14947
  sig { override.returns(String) }
  def inspect; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#14952
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#14957
    def type; end
  end
end

# Represents the use of the `__FILE__` keyword.
#
#     __FILE__
#     ^^^^^^^^
#
# source://prism//lib/prism/node.rb#14972
class Prism::SourceFileNode < ::Prism::Node
  # Initialize a new SourceFileNode node.
  #
  # @return [SourceFileNode] a new instance of SourceFileNode
  #
  # source://prism//lib/prism/node.rb#14974
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      filepath: String
    ).void
  end
  def initialize(source, node_id, location, flags, filepath); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#15055
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#14983
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#14988
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#14998
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#14993
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?filepath: String) -> SourceFileNode
  #
  # source://prism//lib/prism/node.rb#15003
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      filepath: String
    ).returns(Prism::SourceFileNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), filepath: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#14988
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, filepath: String }
  #
  # source://prism//lib/prism/node.rb#15011
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # Represents the file path being parsed. This corresponds directly to the `filepath` option given to the various `Prism::parse*` APIs.
  #
  # source://prism//lib/prism/node.rb#15036
  sig { returns(String) }
  def filepath; end

  # def forced_binary_encoding?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#15021
  sig { returns(T::Boolean) }
  def forced_binary_encoding?; end

  # def forced_utf8_encoding?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#15016
  sig { returns(T::Boolean) }
  def forced_utf8_encoding?; end

  # def frozen?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#15026
  sig { returns(T::Boolean) }
  def frozen?; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#15039
  sig { override.returns(String) }
  def inspect; end

  # def mutable?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#15031
  sig { returns(T::Boolean) }
  def mutable?; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#15044
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#15049
    def type; end
  end
end

# Represents the use of the `__LINE__` keyword.
#
#     __LINE__
#     ^^^^^^^^
#
# source://prism//lib/prism/node.rb#15066
class Prism::SourceLineNode < ::Prism::Node
  # Initialize a new SourceLineNode node.
  #
  # @return [SourceLineNode] a new instance of SourceLineNode
  #
  # source://prism//lib/prism/node.rb#15068
  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer).void }
  def initialize(source, node_id, location, flags); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#15125
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#15076
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#15081
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#15091
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#15086
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer) -> SourceLineNode
  #
  # source://prism//lib/prism/node.rb#15096
  sig { params(node_id: Integer, location: Prism::Location, flags: Integer).returns(Prism::SourceLineNode) }
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#15081
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location }
  #
  # source://prism//lib/prism/node.rb#15104
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#15109
  sig { override.returns(String) }
  def inspect; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#15114
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#15119
    def type; end
  end
end

# Represents the use of the splat operator.
#
#     [*a]
#      ^^
#
# source://prism//lib/prism/node.rb#15134
class Prism::SplatNode < ::Prism::Node
  # Initialize a new SplatNode node.
  #
  # @return [SplatNode] a new instance of SplatNode
  #
  # source://prism//lib/prism/node.rb#15136
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      operator_loc: Prism::Location,
      expression: T.nilable(Prism::Node)
    ).void
  end
  def initialize(source, node_id, location, flags, operator_loc, expression); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#15212
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#15146
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#15151
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#15163
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#15156
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?operator_loc: Location, ?expression: Prism::node?) -> SplatNode
  #
  # source://prism//lib/prism/node.rb#15168
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      operator_loc: Prism::Location,
      expression: T.nilable(Prism::Node)
    ).returns(Prism::SplatNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), operator_loc: T.unsafe(nil), expression: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#15151
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, operator_loc: Location, expression: Prism::node? }
  #
  # source://prism//lib/prism/node.rb#15176
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  # attr_reader expression: Prism::node?
  #
  # source://prism//lib/prism/node.rb#15188
  sig { returns(T.nilable(Prism::Node)) }
  def expression; end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#15196
  sig { override.returns(String) }
  def inspect; end

  # def operator: () -> String
  #
  # source://prism//lib/prism/node.rb#15191
  sig { returns(String) }
  def operator; end

  # attr_reader operator_loc: Location
  #
  # source://prism//lib/prism/node.rb#15181
  sig { returns(Prism::Location) }
  def operator_loc; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#15201
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#15206
    def type; end
  end
end

# Represents a set of statements contained within some scope.
#
#     foo; bar; baz
#     ^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#15223
class Prism::StatementsNode < ::Prism::Node
  # Initialize a new StatementsNode node.
  #
  # @return [StatementsNode] a new instance of StatementsNode
  #
  # source://prism//lib/prism/node.rb#15225
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      body: T::Array[Prism::Node]
    ).void
  end
  def initialize(source, node_id, location, flags, body); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#15286
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#15234
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # attr_reader body: Array[Prism::node]
  #
  # source://prism//lib/prism/node.rb#15267
  sig { returns(T::Array[Prism::Node]) }
  def body; end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#15239
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#15249
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#15244
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?body: Array[Prism::node]) -> StatementsNode
  #
  # source://prism//lib/prism/node.rb#15254
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      body: T::Array[Prism::Node]
    ).returns(Prism::StatementsNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), body: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#15239
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, body: Array[Prism::node] }
  #
  # source://prism//lib/prism/node.rb#15262
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#15270
  sig { override.returns(String) }
  def inspect; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#15275
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#15280
    def type; end
  end
end

# Flags for string nodes.
#
# source://prism//lib/prism/node.rb#16828
module Prism::StringFlags; end

# internal bytes forced the encoding to binary
#
# source://prism//lib/prism/node.rb#16833
Prism::StringFlags::FORCED_BINARY_ENCODING = T.let(T.unsafe(nil), Integer)

# internal bytes forced the encoding to UTF-8
#
# source://prism//lib/prism/node.rb#16830
Prism::StringFlags::FORCED_UTF8_ENCODING = T.let(T.unsafe(nil), Integer)

# source://prism//lib/prism/node.rb#16836
Prism::StringFlags::FROZEN = T.let(T.unsafe(nil), Integer)

# source://prism//lib/prism/node.rb#16839
Prism::StringFlags::MUTABLE = T.let(T.unsafe(nil), Integer)

# Represents a string literal, a string contained within a `%w` list, or plain string content within an interpolated string.
#
#     "foo"
#     ^^^^^
#
#     %w[foo]
#        ^^^
#
#     "foo #{bar} baz"
#      ^^^^      ^^^^
#
# source://prism//lib/prism/node.rb#15303
class Prism::StringNode < ::Prism::Node
  include ::Prism::HeredocQuery

  # Initialize a new StringNode node.
  #
  # @return [StringNode] a new instance of StringNode
  #
  # source://prism//lib/prism/node.rb#15305
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      opening_loc: T.nilable(Prism::Location),
      content_loc: Prism::Location,
      closing_loc: T.nilable(Prism::Location),
      unescaped: String
    ).void
  end
  def initialize(source, node_id, location, flags, opening_loc, content_loc, closing_loc, unescaped); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#15437
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#15317
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#15322
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def closing: () -> String?
  #
  # source://prism//lib/prism/node.rb#15416
  sig { returns(T.nilable(String)) }
  def closing; end

  # attr_reader closing_loc: Location?
  #
  # source://prism//lib/prism/node.rb#15390
  sig { returns(T.nilable(Prism::Location)) }
  def closing_loc; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#15332
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#15327
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def content: () -> String
  #
  # source://prism//lib/prism/node.rb#15411
  sig { returns(String) }
  def content; end

  # attr_reader content_loc: Location
  #
  # source://prism//lib/prism/node.rb#15383
  sig { returns(Prism::Location) }
  def content_loc; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?opening_loc: Location?, ?content_loc: Location, ?closing_loc: Location?, ?unescaped: String) -> StringNode
  #
  # source://prism//lib/prism/node.rb#15337
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      opening_loc: T.nilable(Prism::Location),
      content_loc: Prism::Location,
      closing_loc: T.nilable(Prism::Location),
      unescaped: String
    ).returns(Prism::StringNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), opening_loc: T.unsafe(nil), content_loc: T.unsafe(nil), closing_loc: T.unsafe(nil), unescaped: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#15322
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, opening_loc: Location?, content_loc: Location, closing_loc: Location?, unescaped: String }
  #
  # source://prism//lib/prism/node.rb#15345
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def forced_binary_encoding?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#15355
  sig { returns(T::Boolean) }
  def forced_binary_encoding?; end

  # def forced_utf8_encoding?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#15350
  sig { returns(T::Boolean) }
  def forced_utf8_encoding?; end

  # def frozen?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#15360
  sig { returns(T::Boolean) }
  def frozen?; end

  sig { returns(T::Boolean) }
  def heredoc?; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#15421
  sig { override.returns(String) }
  def inspect; end

  # def mutable?: () -> bool
  #
  # @return [Boolean]
  #
  # source://prism//lib/prism/node.rb#15365
  sig { returns(T::Boolean) }
  def mutable?; end

  # def opening: () -> String?
  #
  # source://prism//lib/prism/node.rb#15406
  sig { returns(T.nilable(String)) }
  def opening; end

  # attr_reader opening_loc: Location?
  #
  # source://prism//lib/prism/node.rb#15370
  sig { returns(T.nilable(Prism::Location)) }
  def opening_loc; end

  # Occasionally it's helpful to treat a string as if it were interpolated so
  # that there's a consistent interface for working with strings.
  #
  # source://prism//lib/prism/node_ext.rb#72
  sig { returns(Prism::InterpolatedStringNode) }
  def to_interpolated; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#15426
  sig { override.returns(Symbol) }
  def type; end

  # attr_reader unescaped: String
  #
  # source://prism//lib/prism/node.rb#15403
  sig { returns(String) }
  def unescaped; end

  class << self
    # Return a symbol representation of this node type. See `Node::type`.
    #
    # source://prism//lib/prism/node.rb#15431
    def type; end
  end
end

# Represents the use of the `super` keyword with parentheses or arguments.
#
#     super()
#     ^^^^^^^
#
#     super foo, bar
#     ^^^^^^^^^^^^^^
#
# source://prism//lib/prism/node.rb#15454
class Prism::SuperNode < ::Prism::Node
  # Initialize a new SuperNode node.
  #
  # @return [SuperNode] a new instance of SuperNode
  #
  # source://prism//lib/prism/node.rb#15456
  sig do
    params(
      source: Prism::Source,
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      keyword_loc: Prism::Location,
      lparen_loc: T.nilable(Prism::Location),
      arguments: T.nilable(Prism::ArgumentsNode),
      rparen_loc: T.nilable(Prism::Location),
      block: T.nilable(T.any(Prism::BlockNode, Prism::BlockArgumentNode))
    ).void
  end
  def initialize(source, node_id, location, flags, keyword_loc, lparen_loc, arguments, rparen_loc, block); end

  # Implements case-equality for the node. This is effectively == but without
  # comparing the value of locations. Locations are checked only for presence.
  #
  # source://prism//lib/prism/node.rb#15575
  def ===(other); end

  # def accept: (Visitor visitor) -> void
  #
  # source://prism//lib/prism/node.rb#15469
  sig { override.params(visitor: Prism::Visitor).returns(T.untyped) }
  def accept(visitor); end

  # attr_reader arguments: ArgumentsNode?
  #
  # source://prism//lib/prism/node.rb#15525
  sig { returns(T.nilable(Prism::ArgumentsNode)) }
  def arguments; end

  # attr_reader block: BlockNode | BlockArgumentNode | nil
  #
  # source://prism//lib/prism/node.rb#15541
  sig { returns(T.nilable(T.any(Prism::BlockNode, Prism::BlockArgumentNode))) }
  def block; end

  # def child_nodes: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#15474
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def child_nodes; end

  # def comment_targets: () -> Array[Node | Location]
  #
  # source://prism//lib/prism/node.rb#15487
  sig { override.returns(T::Array[T.any(Prism::Node, Prism::Location)]) }
  def comment_targets; end

  # def compact_child_nodes: () -> Array[Node]
  #
  # source://prism//lib/prism/node.rb#15479
  sig { override.returns(T::Array[Prism::Node]) }
  def compact_child_nodes; end

  # def copy: (?node_id: Integer, ?location: Location, ?flags: Integer, ?keyword_loc: Location, ?lparen_loc: Location?, ?arguments: ArgumentsNode?, ?rparen_loc: Location?, ?block: BlockNode | BlockArgumentNode | nil) -> SuperNode
  #
  # source://prism//lib/prism/node.rb#15492
  sig do
    params(
      node_id: Integer,
      location: Prism::Location,
      flags: Integer,
      keyword_loc: Prism::Location,
      lparen_loc: T.nilable(Prism::Location),
      arguments: T.nilable(Prism::ArgumentsNode),
      rparen_loc: T.nilable(Prism::Location),
      block: T.nilable(T.any(Prism::BlockNode, Prism::BlockArgumentNode))
    ).returns(Prism::SuperNode)
  end
  def copy(node_id: T.unsafe(nil), location: T.unsafe(nil), flags: T.unsafe(nil), keyword_loc: T.unsafe(nil), lparen_loc: T.unsafe(nil), arguments: T.unsafe(nil), rparen_loc: T.unsafe(nil), block: T.unsafe(nil)); end

  # def child_nodes: () -> Array[nil | Node]
  # def deconstruct: () -> Array[nil | Node]
  #
  # source://prism//lib/prism/node.rb#15474
  sig { override.returns(T::Array[T.nilable(Prism::Node)]) }
  def deconstruct; end

  # def deconstruct_keys: (Array[Symbol] keys) -> { node_id: Integer, location: Location, keyword_loc: Location, lparen_loc: Location?, arguments: ArgumentsNode?, rparen_loc: Location?, block: BlockNode | BlockArgumentNode | nil }
  #
  # source://prism//lib/prism/node.rb#15500
  sig { params(keys: T.nilable(T::Array[Symbol])).returns(T::Hash[Symbol, T.untyped]) }
  def deconstruct_keys(keys); end

  sig { override.returns(T::Array[Prism::Reflection::Field]) }
  def fields; end

  # def inspect -> String
  #
  # source://prism//lib/prism/node.rb#15559
  sig { override.returns(String) }
  def inspect; end

  # def keyword: () -> String
  #
  # source://prism//lib/prism/node.rb#15544
  sig { returns(String) }
  def keyword; end

  # attr_reader keyword_loc: Location
  #
  # source://prism//lib/prism/node.rb#15505
  sig { returns(Prism::Location) }
  def keyword_loc; end

  # def lparen: () -> String?
  #
  # source://prism//lib/prism/node.rb#15549
  sig { returns(T.nilable(String)) }
  def lparen; end

  # attr_reader lparen_loc: Location?
  #
  # source://prism//lib/prism/node.rb#15512
  sig { returns(T.nilable(Prism::Location)) }
  def lparen_loc; end

  # def rparen: () -> String?
  #
  # source://prism//lib/prism/node.rb#15554
  sig { returns(T.nilable(String)) }
  def rparen; end

  # attr_reader rparen_loc: Location?
  #
  # source://prism//lib/prism/node.rb#15528
  sig { returns(T.nilable(Prism::Location)) }
  def rparen_loc; end

  # Return a symbol representation of this node type. See `Node#type`.
  #
  # source://prism//lib/prism/node.rb#15564
  sig { override.returns(Symbol) }
  def type; end

  class << self
    # Return a symbol representation of this node type. See `