# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `kramdown` gem.
# Please instead update this file by running `bin/tapioca gem kramdown`.

# source://kramdown//lib/kramdown/version.rb#10
module Kramdown
  class << self
    # Return the data directory for kramdown.
    #
    # source://kramdown//lib/kramdown/document.rb#49
    def data_dir; end
  end
end

# This module contains all available converters, i.e. classes that take a root Element and convert
# it to a specific output format. The result is normally a string. For example, the
# Converter::Html module converts an element tree into valid HTML.
#
# Converters use the Base class for common functionality (like applying a template to the output)
# \- see its API documentation for how to create a custom converter class.
#
# source://kramdown//lib/kramdown/converter.rb#20
module Kramdown::Converter
  extend ::Kramdown::Utils::Configurable

  class << self
    # source://kramdown//lib/kramdown/utils/configurable.rb#37
    def add_math_engine(data, *args, &block); end

    # source://kramdown//lib/kramdown/utils/configurable.rb#37
    def add_syntax_highlighter(data, *args, &block); end

    # source://kramdown//lib/kramdown/utils/configurable.rb#30
    def configurables; end

    # source://kramdown//lib/kramdown/utils/configurable.rb#34
    def math_engine(data); end

    # source://kramdown//lib/kramdown/utils/configurable.rb#34
    def syntax_highlighter(data); end
  end
end

# == \Base class for converters
#
# This class serves as base class for all converters. It provides methods that can/should be
# used by all converters (like #generate_id) as well as common functionality that is
# automatically applied to the result (for example, embedding the output into a template).
#
# A converter object is used as a throw-away object, i.e. it is only used for storing the needed
# state information during conversion. Therefore one can't instantiate a converter object
# directly but only use the Base::convert method.
#
# == Implementing a converter
#
# Implementing a new converter is rather easy: just derive a new class from this class and put
# it in the Kramdown::Converter module (the latter is only needed if auto-detection should work
# properly). Then you need to implement the #convert method which has to contain the conversion
# code for converting an element and has to return the conversion result.
#
# The actual transformation of the document tree can be done in any way. However, writing one
# method per element type is a straight forward way to do it - this is how the Html and Latex
# converters do the transformation.
#
# Have a look at the Base::convert method for additional information!
#
# source://kramdown//lib/kramdown/converter/base.rb#40
class Kramdown::Converter::Base
  # Initialize the converter with the given +root+ element and +options+ hash.
  #
  # @return [Base] a new instance of Base
  #
  # source://kramdown//lib/kramdown/converter/base.rb#55
  def initialize(root, options); end

  # Returns whether the template should be applied after the conversion of the tree.
  #
  # Defaults to true.
  #
  # @return [Boolean]
  #
  # source://kramdown//lib/kramdown/converter/base.rb#73
  def apply_template_after?; end

  # Returns whether the template should be applied before the conversion of the tree.
  #
  # Defaults to false.
  #
  # @return [Boolean]
  #
  # source://kramdown//lib/kramdown/converter/base.rb#66
  def apply_template_before?; end

  # The basic version of the ID generator, without any special provisions for empty or unique
  # IDs.
  #
  # source://kramdown//lib/kramdown/converter/base.rb#237
  def basic_generate_id(str); end

  # Convert the element +el+ and return the resulting object.
  #
  # This is the only method that has to be implemented by sub-classes!
  #
  # @raise [NotImplementedError]
  #
  # source://kramdown//lib/kramdown/converter/base.rb#122
  def convert(_el); end

  # Can be used by a converter for storing arbitrary information during the conversion process.
  #
  # source://kramdown//lib/kramdown/converter/base.rb#43
  def data; end

  # Extract the code block/span language from the attributes.
  #
  # source://kramdown//lib/kramdown/converter/base.rb#174
  def extract_code_language(attr); end

  # See #extract_code_language
  #
  # *Warning*: This version will modify the given attributes if a language is present.
  #
  # source://kramdown//lib/kramdown/converter/base.rb#183
  def extract_code_language!(attr); end

  # Format the given math element with the math engine configured through the option
  # 'math_engine'.
  #
  # source://kramdown//lib/kramdown/converter/base.rb#206
  def format_math(el, opts = T.unsafe(nil)); end

  # Generate an unique alpha-numeric ID from the the string +str+ for use as a header ID.
  #
  # Uses the option +auto_id_prefix+: the value of this option is prepended to every generated
  # ID.
  #
  # source://kramdown//lib/kramdown/converter/base.rb#222
  def generate_id(str); end

  # Highlight the given +text+ in the language +lang+ with the syntax highlighter configured
  # through the option 'syntax_highlighter'.
  #
  # source://kramdown//lib/kramdown/converter/base.rb#192
  def highlight_code(text, lang, type, opts = T.unsafe(nil)); end

  # Return +true+ if the header element +el+ should be used for the table of contents (as
  # specified by the +toc_levels+ option).
  #
  # @return [Boolean]
  #
  # source://kramdown//lib/kramdown/converter/base.rb#162
  def in_toc?(el); end

  # The hash with the conversion options.
  #
  # source://kramdown//lib/kramdown/converter/base.rb#46
  def options; end

  # Return the output header level given a level.
  #
  # Uses the +header_offset+ option for adjusting the header level.
  #
  # source://kramdown//lib/kramdown/converter/base.rb#169
  def output_header_level(level); end

  # The root element that is converted.
  #
  # source://kramdown//lib/kramdown/converter/base.rb#49
  def root; end

  # Return the entity that represents the given smart_quote element.
  #
  # source://kramdown//lib/kramdown/converter/base.rb#248
  def smart_quote_entity(el); end

  # Add the given warning +text+ to the warning array.
  #
  # source://kramdown//lib/kramdown/converter/base.rb#156
  def warning(text); end

  # The warnings array.
  #
  # source://kramdown//lib/kramdown/converter/base.rb#52
  def warnings; end

  class << self
    # Apply the +template+ using +body+ as the body string.
    #
    # The template is evaluated using ERB and the body is available in the @body instance variable
    # and the converter object in the @converter instance variable.
    #
    # source://kramdown//lib/kramdown/converter/base.rb#130
    def apply_template(converter, body); end

    # Convert the element tree +tree+ and return the resulting conversion object (normally a
    # string) and an array with warning messages. The parameter +options+ specifies the conversion
    # options that should be used.
    #
    # Initializes a new instance of the calling class and then calls the #convert method with
    # +tree+ as parameter.
    #
    # If the +template+ option is specified and non-empty, the template is evaluate with ERB
    # before and/or after the tree conversion depending on the result of #apply_template_before?
    # and #apply_template_after?. If the template is evaluated before, an empty string is used for
    # the body; if evaluated after, the result is used as body. See ::apply_template.
    #
    # The template resolution is done in the following way (for the converter ConverterName):
    #
    # 1. Look in the current working directory for the template.
    #
    # 2. Append +.converter_name+ (e.g. +.html+) to the template name and look for the resulting
    #    file in the current working directory (the form +.convertername+ is deprecated).
    #
    # 3. Append +.converter_name+ to the template name and look for it in the kramdown data
    #    directory (the form +.convertername+ is deprecated).
    #
    # 4. Check if the template name starts with 'string://' and if so, strip this prefix away and
    #    use the rest as template.
    #
    # source://kramdown//lib/kramdown/converter/base.rb#101
    def convert(tree, options = T.unsafe(nil)); end

    # Return the template specified by +template+.
    #
    # source://kramdown//lib/kramdown/converter/base.rb#139
    def get_template(template); end

    private

    def allocate; end
    def new(*_arg0); end
  end
end

# source://kramdown//lib/kramdown/converter/base.rb#245
Kramdown::Converter::Base::SMART_QUOTE_INDICES = T.let(T.unsafe(nil), Hash)

# Converts a Kramdown::Document to a nested hash for further processing or debug output.
#
# source://kramdown//lib/kramdown/converter/hash_ast.rb#19
class Kramdown::Converter::HashAST < ::Kramdown::Converter::Base
  # source://kramdown//lib/kramdown/converter/hash_ast.rb#21
  def convert(el); end
end

# source://kramdown//lib/kramdown/converter/hash_ast.rb#35
Kramdown::Converter::HashAst = Kramdown::Converter::HashAST

# Converts a Kramdown::Document to HTML.
#
# You can customize the HTML converter by sub-classing it and overriding the +convert_NAME+
# methods. Each such method takes the following parameters:
#
# [+el+] The element of type +NAME+ to be converted.
#
# [+indent+] A number representing the current amount of spaces for indent (only used for
#            block-level elements).
#
# The return value of such a method has to be a string containing the element +el+ formatted as
# HTML element.
#
# source://kramdown//lib/kramdown/converter/html.rb#30
class Kramdown::Converter::Html < ::Kramdown::Converter::Base
  include ::Kramdown::Utils::Html
  include ::Kramdown::Parser::Html::Constants

  # Initialize the HTML converter with the given Kramdown document +doc+.
  #
  # @return [Html] a new instance of Html
  #
  # source://kramdown//lib/kramdown/converter/html.rb#39
  def initialize(root, options); end

  # Add the syntax highlighter name to the 'class' attribute of the given attribute hash. And
  # overwrites or add a "language-LANG" part using the +lang+ parameter if +lang+ is not nil.
  #
  # source://kramdown//lib/kramdown/converter/html.rb#409
  def add_syntax_highlighter_to_class_attr(attr, lang = T.unsafe(nil)); end

  # Dispatch the conversion of the element +el+ to a +convert_TYPE+ method using the +type+ of
  # the element.
  #
  # source://kramdown//lib/kramdown/converter/html.rb#57
  def convert(el, indent = T.unsafe(nil)); end

  # source://kramdown//lib/kramdown/converter/html.rb#272
  def convert_a(el, indent); end

  # source://kramdown//lib/kramdown/converter/html.rb#365
  def convert_abbreviation(el, _indent); end

  # source://kramdown//lib/kramdown/converter/html.rb#77
  def convert_blank(_el, _indent); end

  # source://kramdown//lib/kramdown/converter/html.rb#141
  def convert_blockquote(el, indent); end

  # source://kramdown//lib/kramdown/converter/html.rb#268
  def convert_br(_el, _indent); end

  # source://kramdown//lib/kramdown/converter/html.rb#111
  def convert_codeblock(el, indent); end

  # source://kramdown//lib/kramdown/converter/html.rb#280
  def convert_codespan(el, _indent); end

  # source://kramdown//lib/kramdown/converter/html.rb#260
  def convert_comment(el, indent); end

  # source://kramdown//lib/kramdown/converter/html.rb#178
  def convert_dd(el, indent); end

  # source://kramdown//lib/kramdown/converter/html.rb#174
  def convert_dl(el, indent); end

  # source://kramdown//lib/kramdown/converter/html.rb#190
  def convert_dt(el, indent); end

  # source://kramdown//lib/kramdown/converter/html.rb#319
  def convert_em(el, indent); end

  # source://kramdown//lib/kramdown/converter/html.rb#324
  def convert_entity(el, _indent); end

  # source://kramdown//lib/kramdown/converter/html.rb#294
  def convert_footnote(el, _indent); end

  # source://kramdown//lib/kramdown/converter/html.rb#145
  def convert_header(el, indent); end

  # source://kramdown//lib/kramdown/converter/html.rb#155
  def convert_hr(el, indent); end

  # source://kramdown//lib/kramdown/converter/html.rb#201
  def convert_html_element(el, indent); end

  # source://kramdown//lib/kramdown/converter/html.rb#276
  def convert_img(el, _indent); end

  # source://kramdown//lib/kramdown/converter/html.rb#178
  def convert_li(el, indent); end

  # source://kramdown//lib/kramdown/converter/html.rb#351
  def convert_math(el, indent); end

  # source://kramdown//lib/kramdown/converter/html.rb#162
  def convert_ol(el, indent); end

  # source://kramdown//lib/kramdown/converter/html.rb#86
  def convert_p(el, indent); end

  # source://kramdown//lib/kramdown/converter/html.rb#311
  def convert_raw(el, _indent); end

  # source://kramdown//lib/kramdown/converter/html.rb#372
  def convert_root(el, indent); end

  # source://kramdown//lib/kramdown/converter/html.rb#347
  def convert_smart_quote(el, _indent); end

  # Helper method used by +convert_p+ to convert a paragraph that only contains a single :img
  # element.
  #
  # source://kramdown//lib/kramdown/converter/html.rb#99
  def convert_standalone_image(el, indent); end

  # source://kramdown//lib/kramdown/converter/html.rb#319
  def convert_strong(el, indent); end

  # source://kramdown//lib/kramdown/converter/html.rb#238
  def convert_table(el, indent); end

  # source://kramdown//lib/kramdown/converter/html.rb#238
  def convert_tbody(el, indent); end

  # source://kramdown//lib/kramdown/converter/html.rb#248
  def convert_td(el, indent); end

  # source://kramdown//lib/kramdown/converter/html.rb#81
  def convert_text(el, _indent); end

  # source://kramdown//lib/kramdown/converter/html.rb#238
  def convert_tfoot(el, indent); end

  # source://kramdown//lib/kramdown/converter/html.rb#238
  def convert_thead(el, indent); end

  # source://kramdown//lib/kramdown/converter/html.rb#238
  def convert_tr(el, indent); end

  # source://kramdown//lib/kramdown/converter/html.rb#339
  def convert_typographic_sym(el, _indent); end

  # source://kramdown//lib/kramdown/converter/html.rb#162
  def convert_ul(el, indent); end

  # source://kramdown//lib/kramdown/converter/html.rb#228
  def convert_xml_comment(el, indent); end

  # source://kramdown//lib/kramdown/converter/html.rb#228
  def convert_xml_pi(el, indent); end

  # Fixes the elements for use in a TOC entry.
  #
  # source://kramdown//lib/kramdown/converter/html.rb#453
  def fix_for_toc_entry(elements); end

  # Return an HTML ordered list with the footnote content for the used footnotes.
  #
  # source://kramdown//lib/kramdown/converter/html.rb#488
  def footnote_content; end

  # Format the given element as block HTML.
  #
  # source://kramdown//lib/kramdown/converter/html.rb#397
  def format_as_block_html(name, attr, body, indent); end

  # Format the given element as block HTML with a newline after the start tag and indentation
  # before the end tag.
  #
  # source://kramdown//lib/kramdown/converter/html.rb#403
  def format_as_indented_block_html(name, attr, body, indent); end

  # Format the given element as span HTML.
  #
  # source://kramdown//lib/kramdown/converter/html.rb#392
  def format_as_span_html(name, attr, body); end

  # Generate and return an element tree for the table of contents.
  #
  # source://kramdown//lib/kramdown/converter/html.rb#415
  def generate_toc_tree(toc, type, attr); end

  # The amount of indentation used when nesting HTML tags.
  #
  # source://kramdown//lib/kramdown/converter/html.rb#36
  def indent; end

  # The amount of indentation used when nesting HTML tags.
  #
  # source://kramdown//lib/kramdown/converter/html.rb#36
  def indent=(_arg0); end

  # Return the converted content of the children of +el+ as a string. The parameter +indent+ has
  # to be the amount of indentation used for the element +el+.
  #
  # Pushes +el+ onto the @stack before converting the child elements and pops it from the stack
  # afterwards.
  #
  # source://kramdown//lib/kramdown/converter/html.rb#66
  def inner(el, indent); end

  # Obfuscate the +text+ by using HTML entities.
  #
  # source://kramdown//lib/kramdown/converter/html.rb#476
  def obfuscate(text); end

  # Remove all footnotes from the given elements.
  #
  # source://kramdown//lib/kramdown/converter/html.rb#468
  def remove_footnotes(elements); end

  # Remove all link elements by unwrapping them.
  #
  # source://kramdown//lib/kramdown/converter/html.rb#460
  def unwrap_links(elements); end
end

# source://kramdown//lib/kramdown/converter/html.rb#246
Kramdown::Converter::Html::ENTITY_NBSP = T.let(T.unsafe(nil), Kramdown::Utils::Entities::Entity)

# source://kramdown//lib/kramdown/converter/html.rb#485
Kramdown::Converter::Html::FOOTNOTE_BACKLINK_FMT = T.let(T.unsafe(nil), String)

# source://kramdown//lib/kramdown/converter/html.rb#328
Kramdown::Converter::Html::TYPOGRAPHIC_SYMS = T.let(T.unsafe(nil), Hash)

# source://kramdown//lib/kramdown/converter/html.rb#159
Kramdown::Converter::Html::ZERO_TO_ONETWENTYEIGHT = T.let(T.unsafe(nil), Array)

# Converts an element tree to the kramdown format.
#
# source://kramdown//lib/kramdown/converter/kramdown.rb#18
class Kramdown::Converter::Kramdown < ::Kramdown::Converter::Base
  include ::Kramdown::Utils::Html

  # @return [Kramdown] a new instance of Kramdown
  #
  # source://kramdown//lib/kramdown/converter/kramdown.rb#24
  def initialize(root, options); end

  # source://kramdown//lib/kramdown/converter/kramdown.rb#34
  def convert(el, opts = T.unsafe(nil)); end

  # source://kramdown//lib/kramdown/converter/kramdown.rb#291
  def convert_a(el, opts); end

  # source://kramdown//lib/kramdown/converter/kramdown.rb#377
  def convert_abbreviation(el, _opts); end

  # source://kramdown//lib/kramdown/converter/kramdown.rb#70
  def convert_blank(_el, _opts); end

  # source://kramdown//lib/kramdown/converter/kramdown.rb#107
  def convert_blockquote(el, opts); end

  # source://kramdown//lib/kramdown/converter/kramdown.rb#287
  def convert_br(_el, _opts); end

  # source://kramdown//lib/kramdown/converter/kramdown.rb#103
  def convert_codeblock(el, _opts); end

  # source://kramdown//lib/kramdown/converter/kramdown.rb#324
  def convert_codespan(el, _opts); end

  # source://kramdown//lib/kramdown/converter/kramdown.rb#279
  def convert_comment(el, _opts); end

  # source://kramdown//lib/kramdown/converter/kramdown.rb#158
  def convert_dd(el, opts); end

  # source://kramdown//lib/kramdown/converter/kramdown.rb#124
  def convert_dl(el, opts); end

  # source://kramdown//lib/kramdown/converter/kramdown.rb#182
  def convert_dt(el, opts); end

  # source://kramdown//lib/kramdown/converter/kramdown.rb#346
  def convert_em(el, opts); end

  # source://kramdown//lib/kramdown/converter/kramdown.rb#356
  def convert_entity(el, _opts); end

  # source://kramdown//lib/kramdown/converter/kramdown.rb#329
  def convert_footnote(el, _opts); end

  # source://kramdown//lib/kramdown/converter/kramdown.rb#112
  def convert_header(el, opts); end

  # source://kramdown//lib/kramdown/converter/kramdown.rb#120
  def convert_hr(_el, _opts); end

  # source://kramdown//lib/kramdown/converter/kramdown.rb#195
  def convert_html_element(el, opts); end

  # source://kramdown//lib/kramdown/converter/kramdown.rb#308
  def convert_img(el, _opts); end

  # source://kramdown//lib/kramdown/converter/kramdown.rb#130
  def convert_li(el, opts); end

  # source://kramdown//lib/kramdown/converter/kramdown.rb#373
  def convert_math(el, _opts); end

  # source://kramdown//lib/kramdown/converter/kramdown.rb#124
  def convert_ol(el, opts); end

  # source://kramdown//lib/kramdown/converter/kramdown.rb#88
  def convert_p(el, opts); end

  # source://kramdown//lib/kramdown/converter/kramdown.rb#334
  def convert_raw(el, _opts); end

  # source://kramdown//lib/kramdown/converter/kramdown.rb#381
  def convert_root(el, opts); end

  # source://kramdown//lib/kramdown/converter/kramdown.rb#369
  def convert_smart_quote(el, _opts); end

  # source://kramdown//lib/kramdown/converter/kramdown.rb#351
  def convert_strong(el, opts); end

  # source://kramdown//lib/kramdown/converter/kramdown.rb#239
  def convert_table(el, opts); end

  # source://kramdown//lib/kramdown/converter/kramdown.rb#260
  def convert_tbody(el, opts); end

  # source://kramdown//lib/kramdown/converter/kramdown.rb#275
  def convert_td(el, opts); end

  # source://kramdown//lib/kramdown/converter/kramdown.rb#76
  def convert_text(el, opts); end

  # source://kramdown//lib/kramdown/converter/kramdown.rb#267
  def convert_tfoot(el, opts); end

  # source://kramdown//lib/kramdown/converter/kramdown.rb#244
  def convert_thead(el, opts); end

  # source://kramdown//lib/kramdown/converter/kramdown.rb#271
  def convert_tr(el, opts); end

  # source://kramdown//lib/kramdown/converter/kramdown.rb#365
  def convert_typographic_sym(el, _opts); end

  # source://kramdown//lib/kramdown/converter/kramdown.rb#124
  def convert_ul(el, opts); end

  # source://kramdown//lib/kramdown/converter/kramdown.rb#229
  def convert_xml_comment(el, _opts); end

  # source://kramdown//lib/kramdown/converter/kramdown.rb#229
  def convert_xml_pi(el, _opts); end

  # source://kramdown//lib/kramdown/converter/kramdown.rb#408
  def create_abbrev_defs; end

  # source://kramdown//lib/kramdown/converter/kramdown.rb#399
  def create_footnote_defs; end

  # source://kramdown//lib/kramdown/converter/kramdown.rb#389
  def create_link_defs; end

  # Return the IAL containing the attributes of the element +el+.
  #
  # source://kramdown//lib/kramdown/converter/kramdown.rb#419
  def ial_for_element(el); end

  # source://kramdown//lib/kramdown/converter/kramdown.rb#54
  def inner(el, opts = T.unsafe(nil)); end

  # source://kramdown//lib/kramdown/converter/kramdown.rb#444
  def parse_title(attr); end
end

# source://kramdown//lib/kramdown/converter/kramdown.rb#74
Kramdown::Converter::Kramdown::ESCAPED_CHAR_RE = T.let(T.unsafe(nil), Regexp)

# source://kramdown//lib/kramdown/converter/kramdown.rb#192
Kramdown::Converter::Kramdown::HTML_ELEMENT_TYPES = T.let(T.unsafe(nil), Array)

# source://kramdown//lib/kramdown/converter/kramdown.rb#190
Kramdown::Converter::Kramdown::HTML_TAGS_WITH_BODY = T.let(T.unsafe(nil), Array)

# source://kramdown//lib/kramdown/converter/kramdown.rb#360
Kramdown::Converter::Kramdown::TYPOGRAPHIC_SYMS = T.let(T.unsafe(nil), Hash)

# Converts an element tree to LaTeX.
#
# This converter uses ideas from other Markdown-to-LaTeX converters like Pandoc and Maruku.
#
# You can customize this converter by sub-classing it and overriding the +convert_NAME+ methods.
# Each such method takes the following parameters:
#
# [+el+] The element of type +NAME+ to be converted.
#
# [+opts+] A hash containing processing options that are passed down from parent elements. The
#          key :parent is always set and contains the parent element as value.
#
# The return value of such a method has to be a string containing the element +el+ formatted
# correctly as LaTeX markup.
#
# source://kramdown//lib/kramdown/converter/latex.rb#31
class Kramdown::Converter::Latex < ::Kramdown::Converter::Base
  # Initialize the LaTeX converter with the +root+ element and the conversion +options+.
  #
  # @return [Latex] a new instance of Latex
  #
  # source://kramdown//lib/kramdown/converter/latex.rb#34
  def initialize(root, options); end

  # Return a LaTeX comment containing all attributes as 'key="value"' pairs.
  #
  # source://kramdown//lib/kramdown/converter/latex.rb#599
  def attribute_list(el); end

  # Dispatch the conversion of the element +el+ to a +convert_TYPE+ method using the +type+ of
  # the element.
  #
  # source://kramdown//lib/kramdown/converter/latex.rb#41
  def convert(el, opts = T.unsafe(nil)); end

  # source://kramdown//lib/kramdown/converter/latex.rb#216
  def convert_a(el, opts); end

  # source://kramdown//lib/kramdown/converter/latex.rb#569
  def convert_abbreviation(el, _opts); end

  # source://kramdown//lib/kramdown/converter/latex.rb#61
  def convert_blank(_el, opts); end

  # source://kramdown//lib/kramdown/converter/latex.rb#110
  def convert_blockquote(el, opts); end

  # source://kramdown//lib/kramdown/converter/latex.rb#209
  def convert_br(_el, opts); end

  # source://kramdown//lib/kramdown/converter/latex.rb#87
  def convert_codeblock(el, _opts); end

  # source://kramdown//lib/kramdown/converter/latex.rb#239
  def convert_codespan(el, _opts); end

  # source://kramdown//lib/kramdown/converter/latex.rb#205
  def convert_comment(el, _opts); end

  # source://kramdown//lib/kramdown/converter/latex.rb#151
  def convert_dd(el, opts); end

  # source://kramdown//lib/kramdown/converter/latex.rb#139
  def convert_dl(el, opts); end

  # source://kramdown//lib/kramdown/converter/latex.rb#147
  def convert_dt(el, opts); end

  # source://kramdown//lib/kramdown/converter/latex.rb#263
  def convert_em(el, opts); end

  # source://kramdown//lib/kramdown/converter/latex.rb#533
  def convert_entity(el, _opts); end

  # source://kramdown//lib/kramdown/converter/latex.rb#250
  def convert_footnote(el, opts); end

  # source://kramdown//lib/kramdown/converter/latex.rb#114
  def convert_header(el, opts); end

  # source://kramdown//lib/kramdown/converter/latex.rb#124
  def convert_hr(el, _opts); end

  # source://kramdown//lib/kramdown/converter/latex.rb#155
  def convert_html_element(el, opts); end

  # source://kramdown//lib/kramdown/converter/latex.rb#225
  def convert_img(el, _opts); end

  # source://kramdown//lib/kramdown/converter/latex.rb#143
  def convert_li(el, opts); end

  # source://kramdown//lib/kramdown/converter/latex.rb#556
  def convert_math(el, _opts); end

  # source://kramdown//lib/kramdown/converter/latex.rb#129
  def convert_ol(el, opts); end

  # source://kramdown//lib/kramdown/converter/latex.rb#69
  def convert_p(el, opts); end

  # source://kramdown//lib/kramdown/converter/latex.rb#255
  def convert_raw(el, _opts); end

  # source://kramdown//lib/kramdown/converter/latex.rb#57
  def convert_root(el, opts); end

  # source://kramdown//lib/kramdown/converter/latex.rb#550
  def convert_smart_quote(el, opts); end

  # Helper method used by +convert_p+ to convert a paragraph that only contains a single :img
  # element.
  #
  # source://kramdown//lib/kramdown/converter/latex.rb#80
  def convert_standalone_image(el, _opts, img); end

  # source://kramdown//lib/kramdown/converter/latex.rb#267
  def convert_strong(el, opts); end

  # source://kramdown//lib/kramdown/converter/latex.rb#177
  def convert_table(el, opts); end

  # source://kramdown//lib/kramdown/converter/latex.rb#189
  def convert_tbody(el, opts); end

  # source://kramdown//lib/kramdown/converter/latex.rb#201
  def convert_td(el, opts); end

  # source://kramdown//lib/kramdown/converter/latex.rb#65
  def convert_text(el, _opts); end

  # source://kramdown//lib/kramdown/converter/latex.rb#193
  def convert_tfoot(el, opts); end

  # source://kramdown//lib/kramdown/converter/latex.rb#185
  def convert_thead(el, opts); end

  # source://kramdown//lib/kramdown/converter/latex.rb#197
  def convert_tr(el, opts); end

  # source://kramdown//lib/kramdown/converter/latex.rb#542
  def convert_typographic_sym(el, _opts); end

  # source://kramdown//lib/kramdown/converter/latex.rb#129
  def convert_ul(el, opts); end

  # source://kramdown//lib/kramdown/converter/latex.rb#166
  def convert_xml_comment(el, _opts); end

  # source://kramdown//lib/kramdown/converter/latex.rb#170
  def convert_xml_pi(_el, _opts); end

  # source://kramdown//lib/kramdown/converter/latex.rb#522
  def entity_to_latex(entity); end

  # Escape the special LaTeX characters in the string +str+.
  #
  # source://kramdown//lib/kramdown/converter/latex.rb#618
  def escape(str); end

  # Return the converted content of the children of +el+ as a string.
  #
  # source://kramdown//lib/kramdown/converter/latex.rb#46
  def inner(el, opts); end

  # Wrap the +text+ inside a LaTeX environment of type +type+. The element +el+ is passed on to
  # the method #attribute_list -- the resulting string is appended to both the \\begin and the
  # \\end lines of the LaTeX environment for easier post-processing of LaTeX environments.
  #
  # source://kramdown//lib/kramdown/converter/latex.rb#582
  def latex_environment(type, el, text); end

  # Return a string containing a valid \hypertarget command if the element has an ID defined, or
  # +nil+ otherwise. If the parameter +add_label+ is +true+, a \label command will also be used
  # additionally to the \hypertarget command.
  #
  # source://kramdown//lib/kramdown/converter/latex.rb#590
  def latex_link_target(el, add_label = T.unsafe(nil)); end

  # Normalize the abbreviation key so that it only contains allowed ASCII character
  #
  # source://kramdown//lib/kramdown/converter/latex.rb#575
  def normalize_abbreviation_key(key); end
end

# Inspired by Maruku: entity conversion table based on the one from htmltolatex
# (http://sourceforge.net/projects/htmltolatex/), with some small adjustments/additions
#
# source://kramdown//lib/kramdown/converter/latex.rb#273
Kramdown::Converter::Latex::ENTITY_CONV_TABLE = T.let(T.unsafe(nil), Hash)

# source://kramdown//lib/kramdown/converter/latex.rb#605
Kramdown::Converter::Latex::ESCAPE_MAP = T.let(T.unsafe(nil), Hash)

# source://kramdown//lib/kramdown/converter/latex.rb#615
Kramdown::Converter::Latex::ESCAPE_RE = T.let(T.unsafe(nil), Regexp)

# source://kramdown//lib/kramdown/converter/latex.rb#175
Kramdown::Converter::Latex::TABLE_ALIGNMENT_CHAR = T.let(T.unsafe(nil), Hash)

# source://kramdown//lib/kramdown/converter/latex.rb#537
Kramdown::Converter::Latex::TYPOGRAPHIC_SYMS = T.let(T.unsafe(nil), Hash)

# Converts a Kramdown::Document to a manpage in groff format. See man(7), groff_man(7) and
# man-pages(7) for information regarding the output.
#
# source://kramdown//lib/kramdown/converter/man.rb#18
class Kramdown::Converter::Man < ::Kramdown::Converter::Base
  # source://kramdown//lib/kramdown/converter/man.rb#20
  def convert(el, opts = T.unsafe(nil)); end

  private

  # source://kramdown//lib/kramdown/converter/man.rb#191
  def convert_a(el, opts); end

  # source://kramdown//lib/kramdown/converter/man.rb#229
  def convert_abbreviation(el, opts); end

  # source://kramdown//lib/kramdown/converter/man.rb#47
  def convert_blank(*_arg0); end

  # source://kramdown//lib/kramdown/converter/man.rb#95
  def convert_blockquote(el, opts); end

  # source://kramdown//lib/kramdown/converter/man.rb#225
  def convert_br(_el, opts); end

  # source://kramdown//lib/kramdown/converter/man.rb#89
  def convert_codeblock(el, opts); end

  # source://kramdown//lib/kramdown/converter/man.rb#221
  def convert_codespan(el, opts); end

  # source://kramdown//lib/kramdown/converter/man.rb#186
  def convert_comment(el, opts); end

  # source://kramdown//lib/kramdown/converter/man.rb#127
  def convert_dd(el, opts); end

  # source://kramdown//lib/kramdown/converter/man.rb#101
  def convert_dl(el, opts); end

  # source://kramdown//lib/kramdown/converter/man.rb#121
  def convert_dt(el, opts); end

  # source://kramdown//lib/kramdown/converter/man.rb#209
  def convert_em(el, opts); end

  # source://kramdown//lib/kramdown/converter/man.rb#255
  def convert_entity(el, opts); end

  # source://kramdown//lib/kramdown/converter/man.rb#241
  def convert_footnote(*_arg0); end

  # source://kramdown//lib/kramdown/converter/man.rb#61
  def convert_header(el, opts); end

  # source://kramdown//lib/kramdown/converter/man.rb#47
  def convert_hr(*_arg0); end

  # source://kramdown//lib/kramdown/converter/man.rb#182
  def convert_html_element(*_arg0); end

  # source://kramdown//lib/kramdown/converter/man.rb#205
  def convert_img(_el, _opts); end

  # source://kramdown//lib/kramdown/converter/man.rb#110
  def convert_li(el, opts); end

  # source://kramdown//lib/kramdown/converter/man.rb#233
  def convert_math(el, opts); end

  # source://kramdown//lib/kramdown/converter/man.rb#101
  def convert_ol(el, opts); end

  # source://kramdown//lib/kramdown/converter/man.rb#52
  def convert_p(el, opts); end

  # source://kramdown//lib/kramdown/converter/man.rb#245
  def convert_raw(*_arg0); end

  # source://kramdown//lib/kramdown/converter/man.rb#40
  def convert_root(el, opts); end

  # source://kramdown//lib/kramdown/converter/man.rb#259
  def convert_smart_quote(el, opts); end

  # source://kramdown//lib/kramdown/converter/man.rb#215
  def convert_strong(el, opts); end

  # source://kramdown//lib/kramdown/converter/man.rb#139
  def convert_table(el, opts); end

  # source://kramdown//lib/kramdown/converter/man.rb#154
  def convert_tbody(el, opts); end

  # source://kramdown//lib/kramdown/converter/man.rb#170
  def convert_td(el, opts); end

  # source://kramdown//lib/kramdown/converter/man.rb#249
  def convert_text(el, opts); end

  # source://kramdown//lib/kramdown/converter/man.rb#161
  def convert_tfoot(el, opts); end

  # source://kramdown//lib/kramdown/converter/man.rb#148
  def convert_thead(el, opts); end

  # source://kramdown//lib/kramdown/converter/man.rb#165
  def convert_tr(el, opts); end

  # source://kramdown//lib/kramdown/converter/man.rb#268
  def convert_typographic_sym(el, opts); end

  # source://kramdown//lib/kramdown/converter/man.rb#101
  def convert_ul(el, opts); end

  # source://kramdown//lib/kramdown/converter/man.rb#186
  def convert_xml_comment(el, opts); end

  # source://kramdown//lib/kramdown/converter/man.rb#47
  def convert_xml_pi(*_arg0); end

  # source://kramdown//lib/kramdown/converter/man.rb#285
  def escape(text, preserve_whitespace = T.unsafe(nil)); end

  # source://kramdown//lib/kramdown/converter/man.rb#26
  def inner(el, opts, use = T.unsafe(nil)); end

  # source://kramdown//lib/kramdown/converter/man.rb#272
  def macro(name, *args); end

  # source://kramdown//lib/kramdown/converter/man.rb#276
  def newline(text); end

  # source://kramdown//lib/kramdown/converter/man.rb#281
  def quote(text); end

  # source://kramdown//lib/kramdown/converter/man.rb#293
  def unicode_char(codepoint); end
end

# source://kramdown//lib/kramdown/converter/man.rb#137
Kramdown::Converter::Man::TABLE_CELL_ALIGNMENT = T.let(T.unsafe(nil), Hash)

# source://kramdown//lib/kramdown/converter/man.rb#263
Kramdown::Converter::Man::TYPOGRAPHIC_SYMS_MAP = T.let(T.unsafe(nil), Hash)

# Removes all block (and optionally span) level HTML tags from the element tree.
#
# This converter can be used on parsed HTML documents to get an element tree that will only
# contain native kramdown elements.
#
# *Note* that the returned element tree may not be fully conformant (i.e. the content models of
# *some elements may be violated)!
#
# This converter modifies the given tree in-place and returns it.
#
# source://kramdown//lib/kramdown/converter/remove_html_tags.rb#25
class Kramdown::Converter::RemoveHtmlTags < ::Kramdown::Converter::Base
  # @return [RemoveHtmlTags] a new instance of RemoveHtmlTags
  #
  # source://kramdown//lib/kramdown/converter/remove_html_tags.rb#27
  def initialize(root, options); end

  # source://kramdown//lib/kramdown/converter/remove_html_tags.rb#32
  def convert(el); end
end

# Converts a Kramdown::Document to an element tree that represents the table of contents.
#
# The returned tree consists of Element objects of type :toc where the root element is just used
# as container object. Each :toc element contains as value the wrapped :header element and under
# the attribute key :id the header ID that should be used (note that this ID may not exist in
# the wrapped element).
#
# Since the TOC tree consists of special :toc elements, one cannot directly feed this tree to
# other converters!
#
# source://kramdown//lib/kramdown/converter/toc.rb#25
class Kramdown::Converter::Toc < ::Kramdown::Converter::Base
  # @return [Toc] a new instance of Toc
  #
  # source://kramdown//lib/kramdown/converter/toc.rb#27
  def initialize(root, options); end

  # source://kramdown//lib/kramdown/converter/toc.rb#34
  def convert(el); end

  private

  # source://kramdown//lib/kramdown/converter/toc.rb#47
  def add_to_toc(el, id); end
end

# The main interface to kramdown.
#
# This class provides a one-stop-shop for using kramdown to convert text into various output
# formats. Use it like this:
#
#   require 'kramdown'
#   doc = Kramdown::Document.new('This *is* some kramdown text')
#   puts doc.to_html
#
# The #to_html method is a shortcut for using the Converter::Html class. See #method_missing for
# more information.
#
# The second argument to the ::new method is an options hash for customizing the behaviour of the
# used parser and the converter. See ::new for more information!
#
# source://kramdown//lib/kramdown/document.rb#73
class Kramdown::Document
  # Create a new Kramdown document from the string +source+ and use the provided +options+. The
  # options that can be used are defined in the Options module.
  #
  # The special options key :input can be used to select the parser that should parse the
  # +source+. It has to be the name of a class in the Kramdown::Parser module. For example, to
  # select the kramdown parser, one would set the :input key to +Kramdown+. If this key is not
  # set, it defaults to +Kramdown+.
  #
  # The +source+ is immediately parsed by the selected parser so that the root element is
  # immediately available and the output can be generated.
  #
  # @return [Document] a new instance of Document
  #
  # source://kramdown//lib/kramdown/document.rb#96
  def initialize(source, options = T.unsafe(nil)); end

  # source://kramdown//lib/kramdown/document.rb#124
  def inspect; end

  # Check if a method is invoked that begins with +to_+ and if so, try to instantiate a converter
  # class (i.e. a class in the Kramdown::Converter module) and use it for converting the document.
  #
  # For example, +to_html+ would instantiate the Kramdown::Converter::Html class.
  #
  # source://kramdown//lib/kramdown/document.rb#113
  def method_missing(id, *attr, &block); end

  # The options hash which holds the options for parsing/converting the Kramdown document.
  #
  # source://kramdown//lib/kramdown/document.rb#80
  def options; end

  # The root Element of the element tree. It is immediately available after the ::new method has
  # been called.
  #
  # source://kramdown//lib/kramdown/document.rb#77
  def root; end

  # The root Element of the element tree. It is immediately available after the ::new method has
  # been called.
  #
  # source://kramdown//lib/kramdown/document.rb#77
  def root=(_arg0); end

  # An array of warning messages. It is filled with warnings during the parsing phase (i.e. in
  # ::new) and the conversion phase.
  #
  # source://kramdown//lib/kramdown/document.rb#84
  def warnings; end

  protected

  # Try requiring a parser or converter class and don't raise an error if the file is not found.
  #
  # source://kramdown//lib/kramdown/document.rb#129
  def try_require(type, name); end
end

# Represents all elements in the element tree.
#
# kramdown only uses this one class for representing all available elements in an element tree
# (paragraphs, headers, emphasis, ...). The type of element can be set via the #type accessor.
#
# The root of a kramdown element tree has to be an element of type :root. It needs to have certain
# option keys set so that conversions work correctly. If only a part of a tree should be
# converted, duplicate the root node and assign the #children appropriately, e.g:
#
#   root = doc.root
#   new_root = root.dup
#   new_root.children = [root.children[0]]  # assign new array with elements to convert
#
# Following is a description of all supported element types.
#
# Note that the option :location may contain the start line number of an element in the source
# document.
#
# == Structural Elements
#
# === :root
#
# [Category] None
# [Usage context] As the root element of a document
# [Content model] Block-level elements
#
# Represents the root of a kramdown document.
#
# The root element contains the following option keys:
#
#             parts of the kramdown document.
#
# :abbrev_defs:: This key may be used to store the mapping of abbreviation to abbreviation
#                definition.
#
# :abbrev_attr:: This key may be used to store the mapping of abbreviation to abbreviation
#                attributes.
#
# :options:: This key may be used to store options that were set during parsing of the document.
#
# :footnote_count:: This key stores the number of actually referenced footnotes of the document.
#
# === :blank
#
# [Category] Block-level element
# [Usage context] Where block-level elements are expected
# [Content model] Empty
#
# Represents one or more blank lines. It is not allowed to have two or more consecutive blank
# elements.
#
# The +value+ field may contain the original content of the blank lines.
#
#
# === :p
#
# [Category] Block-level element
# [Usage context] Where block-level elements are expected
# [Content model] Span-level elements
#
# Represents a paragraph.
#
# If the option :transparent is +true+, this element just represents a block of text. I.e. this
# element just functions as a container for span-level elements.
#
#
# === :header
#
# [Category] Block-level element
# [Usage context] Where block-level elements are expected
# [Content model] Span-level elements
#
# Represents a header.
#
# The option :level specifies the header level and has to contain a number between 1 and \6. The
# option :raw_text has to contain the raw header text.
#
#
# === :blockquote
#
# [Category] Block-level element
# [Usage context] Where block-level elements are expected
# [Content model] Block-level elements
#
# Represents a blockquote.
#
#
# === :codeblock
#
# [Category] Block-level element
# [Usage context] Where block-level elements are expected
# [Content model] Empty
#
# Represents a code block, i.e. a block of text that should be used as-is.
#
# The +value+ field has to contain the content of the code block.
#
# The option :lang specifies a highlighting language with possible HTML style options (e.g.
# php?start_inline=1) and should be used instead of a possibly also available language embedded in
# a class name of the form 'language-LANG'.
#
#
# === :ul
#
# [Category] Block-level element
# [Usage context] Where block-level elements are expected
# [Content model] One or more :li elements
#
# Represents an unordered list.
#
#
# === :ol
#
# [Category] Block-level element
# [Usage context] Where block-level elements are expected
# [Content model] One or more :li elements
#
# Represents an ordered list.
#
#
# === :li
#
# [Category] Block-level element
# [Usage context] Inside :ol and :ul elements
# [Content model] Block-level elements
#
# Represents a list item of an ordered or unordered list.
#
# Note that the first child of a list item must not be a :blank element!
#
#
# === :dl
#
# [Category] Block-level element
# [Usage context] Where block-level elements are expected
# [Content model] One or more groups each consisting of one or more :dt elements followed by one
#                 or more :dd elements.
#
# Represents a definition list which contains groups consisting of terms and definitions for them.
#
#
# === :dt
#
# [Category] Block-level element
# [Usage context] Before :dt or :dd elements inside a :dl elment
# [Content model] Span-level elements
#
# Represents the term part of a term-definition group in a definition list.
#
#
# === :dd
#
# [Category] Block-level element
# [Usage context] After :dt or :dd elements inside a :dl elment
# [Content model] Block-level elements
#
# Represents the definition part of a term-definition group in a definition list.
#
#
# === :hr
#
# [Category] Block-level element
# [Usage context] Where block-level elements are expected
# [Content model] None
#
# Represents a horizontal line.
#
#
# === :table
#
# [Category] Block-level element
# [Usage context] Where block-level elements are expected
# [Content model] Zero or one :thead elements, one or more :tbody elements, zero or one :tfoot
#                 elements
#
# Represents a table. Each table row (i.e. :tr element) of the table has to contain the same
# number of :td elements.
#
# The option :alignment has to be an array containing the alignment values, exactly one for each
# column of the table. The possible alignment values are :left, :center, :right and :default.
#
#
# === :thead
#
# [Category] None
# [Usage context] As first element inside a :table element
# [Content model] One or more :tr elements
#
# Represents the table header.
#
#
# === :tbody
#
# [Category] None
# [Usage context] After a :thead element but before a :tfoot element inside a :table element
# [Content model] One or more :tr elements
#
# Represents a table body.
#
#
# === :tfoot
#
# [Category] None
# [Usage context] As last element inside a :table element
# [Content model] One or more :tr elements
#
# Represents the table footer.
#
#
# === :tr
#
# [Category] None
# [Usage context] Inside :thead, :tbody and :tfoot elements
# [Content model] One or more :td elements
#
# Represents a table row.
#
#
# === :td
#
# [Category] Block-level element
# [Usage context] Inside :tr elements
# [Content model] As child of :thead/:tr span-level elements, as child of :tbody/:tr and
#                 :tfoot/:tr block-level elements
#
# Represents a table cell.
#
#
# === :math
#
# [Category] Block/span-level element
# [Usage context] Where block/span-level elements are expected
# [Content model] None
#
# Represents mathematical text that is written in LaTeX.
#
# The +value+ field has to contain the actual mathematical text.
#
# The option :category has to be set to either :span or :block depending on the context where the
# element is used.
#
#
# == Text Markup Elements
#
# === :text
#
# [Category] Span-level element
# [Usage context] Where span-level elements are expected
# [Content model] None
#
# Represents text.
#
# The +value+ field has to contain the text itself.
#
#
# === :br
#
# [Category] Span-level element
# [Usage context] Where span-level elements are expected
# [Content model] None
#
# Represents a hard line break.
#
#
# === :a
#
# [Category] Span-level element
# [Usage context] Where span-level elements are expected
# [Content model] Span-level elements
#
# Represents a link to an URL.
#
# The attribute +href+ has to be set to the URL to which the link points. The attribute +title+
# optionally contains the title of the link.
#
#
# === :img
#
# [Category] Span-level element
# [Usage context] Where span-level elements are expected
# [Content model] None
#
# Represents an image.
#
# The attribute +src+ has to be set to the URL of the image. The attribute +alt+ has to contain a
# text description of the image. The attribute +title+ optionally contains the title of the image.
#
#
# === :codespan
#
# [Category] Span-level element
# [Usage context] Where span-level elements are expected
# [Content model] None
#
# Represents verbatim text.
#
# The +value+ field has to contain the content of the code span.
#
#
# === :footnote
#
# [Category] Span-level element
# [Usage context] Where span-level elements are expected
# [Content model] None
#
# Represents a footnote marker.
#
# The +value+ field has to contain an element whose children are the content of the footnote. The
# option :name has to contain a valid and unique footnote name. A valid footnote name consists of
# a word character or a digit and then optionally followed by other word characters, digits or
# dashes.
#
#
# === :em
#
# [Category] Span-level element
# [Usage context] Where span-level elements are expected
# [Content model] Span-level elements
#
# Represents emphasis of its contents.
#
#
# === :strong
#
# [Category] Span-level element
# [Usage context] Where span-level elements are expected
# [Content model] Span-level elements
#
# Represents strong importance for its contents.
#
#
# === :entity
#
# [Category] Span-level element
# [Usage context] Where span-level elements are expected
# [Content model] None
#
# Represents an HTML entity.
#
# The +value+ field has to contain an instance of Kramdown::Utils::Entities::Entity. The option
# :original can be used to store the original representation of the entity.
#
#
# === :typographic_sym
#
# [Category] Span-level element
# [Usage context] Where span-level elements are expected
# [Content model] None
#
# Represents a typographic symbol.
#
# The +value+ field needs to contain a Symbol representing the specific typographic symbol from
# the following list:
#
# :mdash:: An mdash character (---)
# :ndash:: An ndash character (--)
# :hellip:: An ellipsis (...)
# :laquo:: A left guillemet (<<)
# :raquo:: A right guillemet (>>)
# :laquo_space:: A left guillemet with a space (<< )
# :raquo_space:: A right guillemet with a space ( >>)
#
#
# === :smart_quote
#
# [Category] Span-level element
# [Usage context] Where span-level elements are expected
# [Content model] None
#
# Represents a quotation character.
#
# The +value+ field needs to contain a Symbol representing the specific quotation character:
#
# :lsquo:: Left single quote
# :rsquo:: Right single quote
# :ldquo:: Left double quote
# :rdquo:: Right double quote
#
#
# === :abbreviation
#
# [Category] Span-level element
# [Usage context] Where span-level elements are expected
# [Content model] None
#
# Represents a text part that is an abbreviation.
#
# The +value+ field has to contain the text part that is the abbreviation. The definition of the
# abbreviation is stored in the :root element of the document.
#
#
# == Other Elements
#
# === :html_element
#
# [Category] Block/span-level element
# [Usage context] Where block/span-level elements or raw HTML elements are expected
# [Content model] Depends on the element
#
# Represents an HTML element.
#
# The +value+ field has to contain the name of the HTML element the element is representing.
#
# The option :category has to be set to either :span or :block depending on the whether the
# element is a block-level or a span-level element. The option :content_model has to be set to the
# content model for the element (either :block if it contains block-level elements, :span if it
# contains span-level elements or :raw if it contains raw content).
#
#
# === :xml_comment
#
# [Category] Block/span-level element
# [Usage context] Where block/span-level elements are expected or in raw HTML elements
# [Content model] None
#
# Represents an XML/HTML comment.
#
# The +value+ field has to contain the whole XML/HTML comment including the delimiters.
#
# The option :category has to be set to either :span or :block depending on the context where the
# element is used.
#
#
# === :xml_pi
#
# [Category] Block/span-level element
# [Usage context] Where block/span-level elements are expected or in raw HTML elements
# [Content model] None
#
# Represents an XML/HTML processing instruction.
#
# The +value+ field has to contain the whole XML/HTML processing instruction including the
# delimiters.
#
# The option :category has to be set to either :span or :block depending on the context where the
# element is used.
#
#
# === :comment
#
# [Category] Block/span-level element
# [Usage context] Where block/span-level elements are expected
# [Content model] None
#
# Represents a comment.
#
# The +value+ field has to contain the comment.
#
# The option :category has to be set to either :span or :block depending on the context where the
# element is used. If it is set to :span, then no blank lines are allowed in the comment.
#
#
# === :raw
#
# [Category] Block/span-level element
# [Usage context] Where block/span-level elements are expected
# [Content model] None
#
# Represents a raw string that should not be modified. For example, the element could contain some
# HTML code that should be output as-is without modification and escaping.
#
# The +value+ field has to contain the actual raw text.
#
# The option :category has to be set to either :span or :block depending on the context where the
# element is used. If it is set to :span, then no blank lines are allowed in the raw text.
#
# The option :type can be set to an array of strings to define for which converters the raw string
# is valid.
#
# source://kramdown//lib/kramdown/element.rb#482
class Kramdown::Element
  # Create a new Element object of type +type+. The optional parameters +value+, +attr+ and
  # +options+ can also be set in this constructor for convenience.
  #
  # @return [Element] a new instance of Element
  #
  # source://kramdown//lib/kramdown/element.rb#496
  def initialize(type, value = T.unsafe(nil), attr = T.unsafe(nil), options = T.unsafe(nil)); end

  # The attributes of the element.
  #
  # source://kramdown//lib/kramdown/element.rb#502
  def attr; end

  # syntactic sugar to simplify calls such as +Kramdown::Element.category(el) == :block+ with
  # +el.block?+.
  #
  # Returns boolean true or false.
  #
  # @return [Boolean]
  #
  # source://kramdown//lib/kramdown/element.rb#537
  def block?; end

  # The child elements of this element.
  #
  # source://kramdown//lib/kramdown/element.rb#492
  def children; end

  # The child elements of this element.
  #
  # source://kramdown//lib/kramdown/element.rb#492
  def children=(_arg0); end

  # source://kramdown//lib/kramdown/element.rb#511
  def inspect; end

  # The options hash for the element. It is used for storing arbitray options.
  #
  # source://kramdown//lib/kramdown/element.rb#507
  def options; end

  # syntactic sugar to simplify calls such as +Kramdown::Element.category(el) == :span+ with
  # +el.span?+.
  #
  # Returns boolean true or false.
  #
  # @return [Boolean]
  #
  # source://kramdown//lib/kramdown/element.rb#545
  def span?; end

  # A symbol representing the element type. For example, :p or :blockquote.
  #
  # source://kramdown//lib/kramdown/element.rb#485
  def type; end

  # A symbol representing the element type. For example, :p or :blockquote.
  #
  # source://kramdown//lib/kramdown/element.rb#485
  def type=(_arg0); end

  # The value of the element. The interpretation of this field depends on the type of the element.
  # Many elements don't use this field.
  #
  # source://kramdown//lib/kramdown/element.rb#489
  def value; end

  # The value of the element. The interpretation of this field depends on the type of the element.
  # Many elements don't use this field.
  #
  # source://kramdown//lib/kramdown/element.rb#489
  def value=(_arg0); end

  class << self
    # Return the category of +el+ which can be :block, :span or +nil+.
    #
    # Most elements have a fixed category, however, some elements can either appear in a block-level
    # or a span-level context. These elements need to have the option :category correctly set.
    #
    # source://kramdown//lib/kramdown/element.rb#529
    def category(el); end
  end
end

# source://kramdown//lib/kramdown/element.rb#519
Kramdown::Element::CATEGORY = T.let(T.unsafe(nil), Hash)

# This error is raised when an error condition is encountered.
#
# *Note* that this error is only raised by the support framework for the parsers and converters.
#
# source://kramdown//lib/kramdown/error.rb#15
class Kramdown::Error < ::RuntimeError; end

# This module defines all options that are used by parsers and/or converters as well as providing
# methods to deal with the options.
#
# source://kramdown//lib/kramdown/options.rb#16
module Kramdown::Options
  class << self
    # Return a Hash with the default values for all options.
    #
    # source://kramdown//lib/kramdown/options.rb#72
    def defaults; end

    # Define a new option called +name+ (a Symbol) with the given +type+ (String, Integer, Float,
    # Symbol, Boolean, Object), default value +default+ and the description +desc+. If a block is
    # specified, it should validate the value and either raise an error or return a valid value.
    #
    # The type 'Object' should only be used for complex types for which none of the other types
    # suffices. A block needs to be specified when using type 'Object' and it has to cope with
    # a value given as string and as the opaque type.
    #
    # @raise [ArgumentError]
    #
    # source://kramdown//lib/kramdown/options.rb#51
    def define(name, type, default, desc, &block); end

    # Return +true+ if an option called +name+ is defined.
    #
    # @return [Boolean]
    #
    # source://kramdown//lib/kramdown/options.rb#67
    def defined?(name); end

    # Return all option definitions.
    #
    # source://kramdown//lib/kramdown/options.rb#62
    def definitions; end

    # Merge the #defaults Hash with the *parsed* options from the given Hash, i.e. only valid option
    # names are considered and their value is run through the #parse method.
    #
    # source://kramdown//lib/kramdown/options.rb#82
    def merge(hash); end

    # Parse the given value +data+ as if it was a value for the option +name+ and return the parsed
    # value with the correct type.
    #
    # If +data+ already has the correct type, it is just returned. Otherwise it is converted to a
    # String and then to the correct type.
    #
    # @raise [ArgumentError]
    #
    # source://kramdown//lib/kramdown/options.rb#96
    def parse(name, data); end

    # Ensures that the option value +val+ for the option called +name+ is a valid array. The
    # parameter +val+ can be
    #
    # - a comma separated string which is split into an array of values
    # - or an array.
    #
    # Optionally, the array is checked for the correct size.
    #
    # source://kramdown//lib/kramdown/options.rb#141
    def simple_array_validator(val, name, size = T.unsafe(nil)); end

    # Ensures that the option value +val+ for the option called +name+ is a valid hash. The
    # parameter +val+ can be
    #
    # - a hash in YAML format
    # - or a Ruby Hash object.
    #
    # @raise [Kramdown::Error]
    #
    # source://kramdown//lib/kramdown/options.rb#158
    def simple_hash_validator(val, name); end

    # Converts the given String +data+ into a Symbol or +nil+ with the
    # following provisions:
    #
    # - A leading colon is stripped from the string.
    # - An empty value or a value equal to "nil" results in +nil+.
    #
    # source://kramdown//lib/kramdown/options.rb#122
    def str_to_sym(data); end
  end
end

# Allowed option types.
#
# source://kramdown//lib/kramdown/options.rb#39
Kramdown::Options::ALLOWED_TYPES = T.let(T.unsafe(nil), Array)

# Helper class introducing a boolean type for specifying boolean values (+true+ and +false+) as
# option types.
#
# source://kramdown//lib/kramdown/options.rb#20
class Kramdown::Options::Boolean
  class << self
    # Return +true+ if +other+ is either +true+ or +false+
    #
    # source://kramdown//lib/kramdown/options.rb#23
    def ===(other); end
  end
end

# Struct class for storing the definition of an option.
#
# source://kramdown//lib/kramdown/options.rb#36
class Kramdown::Options::Definition < ::Struct
  # Returns the value of attribute default
  #
  # @return [Object] the current value of default
  def default; end

  # Sets the attribute default
  #
  # @param value [Object] the value to set the attribute default to.
  # @return [Object] the newly set value
  def default=(_); end

  # Returns the value of attribute desc
  #
  # @return [Object] the current value of desc
  def desc; end

  # Sets the attribute desc
  #
  # @param value [Object] the value to set the attribute desc to.
  # @return [Object] the newly set value
  def desc=(_); end

  # Returns the value of attribute name
  #
  # @return [Object] the current value of name
  def name; end

  # Sets the attribute name
  #
  # @param value [Object] the value to set the attribute name to.
  # @return [Object] the newly set value
  def name=(_); end

  # Returns the value of attribute type
  #
  # @return [Object] the current value of type
  def type; end

  # Sets the attribute type
  #
  # @param value [Object] the value to set the attribute type to.
  # @return [Object] the newly set value
  def type=(_); end

  # Returns the value of attribute validator
  #
  # @return [Object] the current value of validator
  def validator; end

  # Sets the attribute validator
  #
  # @param value [Object] the value to set the attribute validator to.
  # @return [Object] the newly set value
  def validator=(_); end

  class << self
    def [](*_arg0); end
    def inspect; end
    def keyword_init?; end
    def members; end
    def new(*_arg0); end
  end
end

# source://kramdown//lib/kramdown/options.rb#396
Kramdown::Options::SMART_QUOTES_ENTITIES = T.let(T.unsafe(nil), Array)

# source://kramdown//lib/kramdown/options.rb#397
Kramdown::Options::SMART_QUOTES_STR = T.let(T.unsafe(nil), String)

# source://kramdown//lib/kramdown/options.rb#336
Kramdown::Options::TOC_LEVELS_ARRAY = T.let(T.unsafe(nil), Array)

# source://kramdown//lib/kramdown/options.rb#335
Kramdown::Options::TOC_LEVELS_RANGE = T.let(T.unsafe(nil), Range)

# This module contains all available parsers. A parser takes an input string and converts the
# string to an element tree.
#
# New parsers should be derived from the Base class which provides common functionality - see its
# API documentation for how to create a custom converter class.
#
# source://kramdown//lib/kramdown/parser.rb#17
module Kramdown::Parser; end

# == \Base class for parsers
#
# This class serves as base class for parsers. It provides common methods that can/should be
# used by all parsers, especially by those using StringScanner(Kramdown) for parsing.
#
# A parser object is used as a throw-away object, i.e. it is only used for storing the needed
# state information during parsing. Therefore one can't instantiate a parser object directly but
# only use the Base::parse method.
#
# == Implementing a parser
#
# Implementing a new parser is rather easy: just derive a new class from this class and put it
# in the Kramdown::Parser module -- the latter is needed so that the auto-detection of the new
# parser works correctly. Then you need to implement the +#parse+ method which has to contain
# the parsing code.
#
# Have a look at the Base::parse, Base::new and Base#parse methods for additional information!
#
# source://kramdown//lib/kramdown/parser/base.rb#34
class Kramdown::Parser::Base
  # Initialize the parser object with the +source+ string and the parsing +options+.
  #
  # The @root element, the @warnings array and @text_type (specifies the default type for newly
  # created text nodes) are automatically initialized.
  #
  # @return [Base] a new instance of Base
  #
  # source://kramdown//lib/kramdown/parser/base.rb#52
  def initialize(source, options); end

  # Modify the string +source+ to be usable by the parser (unifies line ending characters to
  # +\n+ and makes sure +source+ ends with a new line character).
  #
  # source://kramdown//lib/kramdown/parser/base.rb#91
  def adapt_source(source); end

  # This helper method adds the given +text+ either to the last element in the +tree+ if it is a
  # +type+ element or creates a new text element with the given +type+.
  #
  # source://kramdown//lib/kramdown/parser/base.rb#103
  def add_text(text, tree = T.unsafe(nil), type = T.unsafe(nil)); end

  # Extract the part of the StringScanner +strscan+ backed string specified by the +range+. This
  # method works correctly under Ruby 1.8 and Ruby 1.9.
  #
  # source://kramdown//lib/kramdown/parser/base.rb#115
  def extract_string(range, strscan); end

  # The hash with the parsing options.
  #
  # source://kramdown//lib/kramdown/parser/base.rb#37
  def options; end

  # Parse the source string into an element tree.
  #
  # The parsing code should parse the source provided in @source and build an element tree the
  # root of which should be @root.
  #
  # This is the only method that has to be implemented by sub-classes!
  #
  # @raise [NotImplementedError]
  #
  # source://kramdown//lib/kramdown/parser/base.rb#79
  def parse; end

  # The root element of element tree that is created from the source string.
  #
  # source://kramdown//lib/kramdown/parser/base.rb#46
  def root; end

  # The original source string.
  #
  # source://kramdown//lib/kramdown/parser/base.rb#43
  def source; end

  # Add the given warning +text+ to the warning array.
  #
  # source://kramdown//lib/kramdown/parser/base.rb#84
  def warning(text); end

  # The array with the parser warnings.
  #
  # source://kramdown//lib/kramdown/parser/base.rb#40
  def warnings; end

  class << self
    # Parse the +source+ string into an element tree, possibly using the parsing +options+, and
    # return the root element of the element tree and an array with warning messages.
    #
    # Initializes a new instance of the calling class and then calls the +#parse+ method that must
    # be implemented by each subclass.
    #
    # source://kramdown//lib/kramdown/parser/base.rb#67
    def parse(source, options = T.unsafe(nil)); end

    private

    def allocate; end
    def new(*_arg0); end
  end
end

# Used for parsing an HTML document.
#
# The parsing code is in the Parser module that can also be used by other parsers.
#
# source://kramdown//lib/kramdown/parser/html.rb#22
class Kramdown::Parser::Html < ::Kramdown::Parser::Base
  include ::Kramdown::Parser::Html::Constants
  include ::Kramdown::Parser::Html::Parser

  # Parse the source string provided on initialization as HTML document.
  #
  # source://kramdown//lib/kramdown/parser/html.rb#586
  def parse; end
end

# Contains all constants that are used when parsing.
#
# source://kramdown//lib/kramdown/parser/html.rb#25
module Kramdown::Parser::Html::Constants; end

# source://kramdown//lib/kramdown/parser/html.rb#32
Kramdown::Parser::Html::Constants::HTML_ATTRIBUTE_RE = T.let(T.unsafe(nil), Regexp)

# source://kramdown//lib/kramdown/parser/html.rb#59
Kramdown::Parser::Html::Constants::HTML_BLOCK_ELEMENTS = T.let(T.unsafe(nil), Array)

# source://kramdown//lib/kramdown/parser/html.rb#30
Kramdown::Parser::Html::Constants::HTML_COMMENT_RE = T.let(T.unsafe(nil), Regexp)

# The following elements are also parsed as raw since they need child elements that cannot
# be expressed using kramdown syntax: colgroup table tbody thead tfoot tr ul ol
#
# source://kramdown//lib/kramdown/parser/html.rb#48
Kramdown::Parser::Html::Constants::HTML_CONTENT_MODEL = T.let(T.unsafe(nil), Hash)

# source://kramdown//lib/kramdown/parser/html.rb#37
Kramdown::Parser::Html::Constants::HTML_CONTENT_MODEL_BLOCK = T.let(T.unsafe(nil), Array)

# source://kramdown//lib/kramdown/parser/html.rb#44
Kramdown::Parser::Html::Constants::HTML_CONTENT_MODEL_RAW = T.let(T.unsafe(nil), Array)

# source://kramdown//lib/kramdown/parser/html.rb#41
Kramdown::Parser::Html::Constants::HTML_CONTENT_MODEL_SPAN = T.let(T.unsafe(nil), Array)

# :stopdoc:
# The following regexps are based on the ones used by REXML, with some slight modifications.
#
# source://kramdown//lib/kramdown/parser/html.rb#29
Kramdown::Parser::Html::Constants::HTML_DOCTYPE_RE = T.let(T.unsafe(nil), Regexp)

# source://kramdown//lib/kramdown/parser/html.rb#66
Kramdown::Parser::Html::Constants::HTML_ELEMENT = T.let(T.unsafe(nil), Hash)

# source://kramdown//lib/kramdown/parser/html.rb#63
Kramdown::Parser::Html::Constants::HTML_ELEMENTS_WITHOUT_BODY = T.let(T.unsafe(nil), Array)

# source://kramdown//lib/kramdown/parser/html.rb#35
Kramdown::Parser::Html::Constants::HTML_ENTITY_RE = T.let(T.unsafe(nil), Regexp)

# source://kramdown//lib/kramdown/parser/html.rb#31
Kramdown::Parser::Html::Constants::HTML_INSTRUCTION_RE = T.let(T.unsafe(nil), Regexp)

# Some HTML elements like script belong to both categories (i.e. are valid in block and
# span HTML) and don't appear therefore!
# script, textarea
#
# source://kramdown//lib/kramdown/parser/html.rb#56
Kramdown::Parser::Html::Constants::HTML_SPAN_ELEMENTS = T.let(T.unsafe(nil), Array)

# source://kramdown//lib/kramdown/parser/html.rb#34
Kramdown::Parser::Html::Constants::HTML_TAG_CLOSE_RE = T.let(T.unsafe(nil), Regexp)

# source://kramdown//lib/kramdown/parser/html.rb#33
Kramdown::Parser::Html::Constants::HTML_TAG_RE = T.let(T.unsafe(nil), Regexp)

# Converts HTML elements to native elements if possible.
#
# source://kramdown//lib/kramdown/parser/html.rb#197
class Kramdown::Parser::Html::ElementConverter
  include ::Kramdown::Parser::Html::Constants
  include ::Kramdown::Utils::Entities

  # @return [ElementConverter] a new instance of ElementConverter
  #
  # source://kramdown//lib/kramdown/parser/html.rb#216
  def initialize(root); end

  # source://kramdown//lib/kramdown/parser/html.rb#384
  def convert_a(el); end

  # source://kramdown//lib/kramdown/parser/html.rb#394
  def convert_b(el); end

  # source://kramdown//lib/kramdown/parser/html.rb#417
  def convert_code(el); end

  # source://kramdown//lib/kramdown/parser/html.rb#394
  def convert_em(el); end

  # source://kramdown//lib/kramdown/parser/html.rb#408
  def convert_h1(el); end

  # source://kramdown//lib/kramdown/parser/html.rb#408
  def convert_h2(el); end

  # source://kramdown//lib/kramdown/parser/html.rb#408
  def convert_h3(el); end

  # source://kramdown//lib/kramdown/parser/html.rb#408
  def convert_h4(el); end

  # source://kramdown//lib/kramdown/parser/html.rb#408
  def convert_h5(el); end

  # source://kramdown//lib/kramdown/parser/html.rb#408
  def convert_h6(el); end

  # source://kramdown//lib/kramdown/parser/html.rb#394
  def convert_i(el); end

  # source://kramdown//lib/kramdown/parser/html.rb#417
  def convert_pre(el); end

  # source://kramdown//lib/kramdown/parser/html.rb#563
  def convert_script(el); end

  # source://kramdown//lib/kramdown/parser/html.rb#394
  def convert_strong(el); end

  # source://kramdown//lib/kramdown/parser/html.rb#460
  def convert_table(el); end

  # source://kramdown//lib/kramdown/parser/html.rb#380
  def convert_textarea(el); end

  # source://kramdown//lib/kramdown/parser/html.rb#375
  def extract_text(el, raw); end

  # source://kramdown//lib/kramdown/parser/html.rb#575
  def handle_math_tag(el); end

  # @return [Boolean]
  #
  # source://kramdown//lib/kramdown/parser/html.rb#571
  def is_math_tag?(el); end

  # @return [Boolean]
  #
  # source://kramdown//lib/kramdown/parser/html.rb#503
  def is_simple_table?(el); end

  # Convert the element +el+ and its children.
  #
  # source://kramdown//lib/kramdown/parser/html.rb#225
  def process(el, do_conversion = T.unsafe(nil), preserve_text = T.unsafe(nil), parent = T.unsafe(nil)); end

  # source://kramdown//lib/kramdown/parser/html.rb#278
  def process_children(el, do_conversion = T.unsafe(nil), preserve_text = T.unsafe(nil)); end

  # source://kramdown//lib/kramdown/parser/html.rb#320
  def process_html_element(el, do_conversion = T.unsafe(nil), preserve_text = T.unsafe(nil)); end

  # Process the HTML text +raw+: compress whitespace (if +preserve+ is +false+) and convert
  # entities in entity elements.
  #
  # source://kramdown//lib/kramdown/parser/html.rb#291
  def process_text(raw, preserve = T.unsafe(nil)); end

  # source://kramdown//lib/kramdown/parser/html.rb#326
  def remove_text_children(el); end

  # source://kramdown//lib/kramdown/parser/html.rb#359
  def remove_whitespace_children(el); end

  # source://kramdown//lib/kramdown/parser/html.rb#369
  def set_basics(el, type, opts = T.unsafe(nil)); end

  # source://kramdown//lib/kramdown/parser/html.rb#349
  def strip_whitespace(el); end

  # source://kramdown//lib/kramdown/parser/html.rb#330
  def wrap_text_children(el); end

  class << self
    # source://kramdown//lib/kramdown/parser/html.rb#220
    def convert(root, el = T.unsafe(nil)); end
  end
end

# source://kramdown//lib/kramdown/parser/html.rb#393
Kramdown::Parser::Html::ElementConverter::EMPHASIS_TYPE_MAP = T.let(T.unsafe(nil), Hash)

# source://kramdown//lib/kramdown/parser/html.rb#204
Kramdown::Parser::Html::ElementConverter::REMOVE_TEXT_CHILDREN = T.let(T.unsafe(nil), Array)

# source://kramdown//lib/kramdown/parser/html.rb#208
Kramdown::Parser::Html::ElementConverter::REMOVE_WHITESPACE_CHILDREN = T.let(T.unsafe(nil), Array)

# source://kramdown//lib/kramdown/parser/html.rb#213
Kramdown::Parser::Html::ElementConverter::SIMPLE_ELEMENTS = T.let(T.unsafe(nil), Array)

# source://kramdown//lib/kramdown/parser/html.rb#210
Kramdown::Parser::Html::ElementConverter::STRIP_WHITESPACE = T.let(T.unsafe(nil), Array)

# source://kramdown//lib/kramdown/parser/html.rb#206
Kramdown::Parser::Html::ElementConverter::WRAP_TEXT_CHILDREN = T.let(T.unsafe(nil), Array)

# Contains the parsing methods. This module can be mixed into any parser to get HTML parsing
# functionality. The only thing that must be provided by the class are instance variable
# parsing.
#
# source://kramdown//lib/kramdown/parser/html.rb#77
module Kramdown::Parser::Html::Parser
  include ::Kramdown::Parser::Html::Constants

  # Process the HTML start tag that has already be scanned/checked via @src.
  #
  # Does the common processing steps and then yields to the caller for further processing
  # (first parameter is the created element; the second parameter is +true+ if the HTML
  # element is already closed, ie. contains no body; the third parameter specifies whether the
  # body - and the end tag - need to be handled in case closed=false).
  #
  # source://kramdown//lib/kramdown/parser/html.rb#87
  def handle_html_start_tag(line = T.unsafe(nil)); end

  # Handle the raw HTML tag at the current position.
  #
  # source://kramdown//lib/kramdown/parser/html.rb#127
  def handle_raw_html_tag(name); end

  # Parses the given string for HTML attributes and returns the resulting hash.
  #
  # If the optional +line+ parameter is supplied, it is used in warning messages.
  #
  # If the optional +in_html_tag+ parameter is set to +false+, attributes are not modified to
  # contain only lowercase letters.
  #
  # source://kramdown//lib/kramdown/parser/html.rb#114
  def parse_html_attributes(str, line = T.unsafe(nil), in_html_tag = T.unsafe(nil)); end

  # Parse raw HTML from the current source position, storing the found elements in +el+.
  # Parsing continues until one of the following criteria are fulfilled:
  #
  # - The end of the document is reached.
  # - The matching end tag for the element +el+ is found (only used if +el+ is an HTML
  #   element).
  #
  # When an HTML start tag is found, processing is deferred to #handle_html_start_tag,
  # providing the block given to this method.
  #
  # source://kramdown//lib/kramdown/parser/html.rb#150
  def parse_raw_html(el, &block); end
end

# source://kramdown//lib/kramdown/parser/html.rb#139
Kramdown::Parser::Html::Parser::HTML_RAW_START = T.let(T.unsafe(nil), Regexp)

# Used for parsing a document in kramdown format.
#
# If you want to extend the functionality of the parser, you need to do the following:
#
# * Create a new subclass
# * add the needed parser methods
# * modify the @block_parsers and @span_parsers variables and add the names of your parser
#   methods
#
# Here is a small example for an extended parser class that parses ERB style tags as raw text if
# they are used as span-level elements (an equivalent block-level parser should probably also be
# made to handle the block case):
#
#   require 'kramdown/parser/kramdown'
#
#   class Kramdown::Parser::ERBKramdown < Kramdown::Parser::Kramdown
#
#      def initialize(source, options)
#        super
#        @span_parsers.unshift(:erb_tags)
#      end
#
#      ERB_TAGS_START = /<%.*?%>/
#
#      def parse_erb_tags
#        @src.pos += @src.matched_size
#        @tree.children << Element.new(:raw, @src.matched)
#      end
#      define_parser(:erb_tags, ERB_TAGS_START, '<%')
#
#   end
#
# The new parser can be used like this:
#
#   require 'kramdown/document'
#   # require the file with the above parser class
#
#   Kramdown::Document.new(input_text, :input => 'ERBKramdown').to_html
#
# source://kramdown//lib/kramdown/parser/kramdown.rb#60
class Kramdown::Parser::Kramdown < ::Kramdown::Parser::Base
  include ::Kramdown
  include ::Kramdown::Parser::Html::Constants
  include ::Kramdown::Parser::Html::Parser

  # Create a new Kramdown parser object with the given +options+.
  #
  # @return [Kramdown] a new instance of Kramdown
  #
  # source://kramdown//lib/kramdown/parser/kramdown.rb#65
  def initialize(source, options); end

  # This helper methods adds the approriate attributes to the element +el+ of type +a+ or +img+
  # and the element itself to the @tree.
  #
  # source://kramdown//lib/kramdown/parser/kramdown/link.rb#39
  def add_link(el, href, title, alt_text = T.unsafe(nil), ial = T.unsafe(nil)); end

  # Return +true+ if we are after a block boundary.
  #
  # @return [Boolean]
  #
  # source://kramdown//lib/kramdown/parser/kramdown/block_boundary.rb#21
  def after_block_boundary?; end

  # Return +true+ if we are before a block boundary.
  #
  # @return [Boolean]
  #
  # source://kramdown//lib/kramdown/parser/kramdown/block_boundary.rb#28
  def before_block_boundary?; end

  # Correct abbreviation attributes.
  #
  # source://kramdown//lib/kramdown/parser/kramdown/abbreviation.rb#34
  def correct_abbreviations_attributes; end

  # source://kramdown//lib/kramdown/parser/kramdown/extensions.rb#96
  def handle_extension(name, opts, body, type, line_no = T.unsafe(nil)); end

  # source://kramdown//lib/kramdown/parser/kramdown/html.rb#25
  def handle_kramdown_html_tag(el, closed, handle_body); end

  # Normalize the link identifier.
  #
  # source://kramdown//lib/kramdown/parser/kramdown/link.rb#17
  def normalize_link_id(id); end

  # source://kramdown//lib/kramdown/parser/kramdown/paragraph.rb#56
  def paragraph_end; end

  # The source string provided on initialization is parsed into the @root element.
  #
  # source://kramdown//lib/kramdown/parser/kramdown.rb#88
  def parse; end

  # Parse the link definition at the current location.
  #
  # source://kramdown//lib/kramdown/parser/kramdown/abbreviation.rb#17
  def parse_abbrev_definition; end

  # Parse the string +str+ and extract all attributes and add all found attributes to the hash
  # +opts+.
  #
  # source://kramdown//lib/kramdown/parser/kramdown/extensions.rb#18
  def parse_attribute_list(str, opts); end

  # Parse the Atx header at the current location.
  #
  # source://kramdown//lib/kramdown/parser/kramdown/header.rb#32
  def parse_atx_header; end

  # Parse the autolink at the current location.
  #
  # source://kramdown//lib/kramdown/parser/kramdown/autolink.rb#19
  def parse_autolink; end

  # Parse the blank line at the current postition.
  #
  # source://kramdown//lib/kramdown/parser/kramdown/blank_line.rb#17
  def parse_blank_line; end

  # Parse one of the block extensions (ALD, block IAL or generic extension) at the current
  # location.
  #
  # source://kramdown//lib/kramdown/parser/kramdown/extensions.rb#164
  def parse_block_extensions; end

  # Parse the HTML at the current position as block-level HTML.
  #
  # source://kramdown//lib/kramdown/parser/kramdown/html.rb#71
  def parse_block_html; end

  # Parse the math block at the current location.
  #
  # source://kramdown//lib/kramdown/parser/kramdown/math.rb#19
  def parse_block_math; end

  # Parse the blockquote at the current location.
  #
  # source://kramdown//lib/kramdown/parser/kramdown/blockquote.rb#21
  def parse_blockquote; end

  # Parse the indented codeblock at the current location.
  #
  # source://kramdown//lib/kramdown/parser/kramdown/codeblock.rb#23
  def parse_codeblock; end

  # Parse the fenced codeblock at the current location.
  #
  # source://kramdown//lib/kramdown/parser/kramdown/codeblock.rb#37
  def parse_codeblock_fenced; end

  # Parse the codespan at the current scanner location.
  #
  # source://kramdown//lib/kramdown/parser/kramdown/codespan.rb#17
  def parse_codespan; end

  # Parse the ordered or unordered list at the current location.
  #
  # source://kramdown//lib/kramdown/parser/kramdown/list.rb#153
  def parse_definition_list; end

  # Parse the emphasis at the current location.
  #
  # source://kramdown//lib/kramdown/parser/kramdown/emphasis.rb#17
  def parse_emphasis; end

  # Parse the EOB marker at the current location.
  #
  # source://kramdown//lib/kramdown/parser/kramdown/eob.rb#17
  def parse_eob_marker; end

  # Parse the backslash-escaped character at the current location.
  #
  # source://kramdown//lib/kramdown/parser/kramdown/escaped_chars.rb#17
  def parse_escaped_chars; end

  # Parse the generic extension at the current point. The parameter +type+ can either be :block
  # or :span depending whether we parse a block or span extension tag.
  #
  # source://kramdown//lib/kramdown/parser/kramdown/extensions.rb#54
  def parse_extension_start_tag(type); end

  # Used for parsing the first line of a list item or a definition, i.e. the line with list item
  # marker or the definition marker.
  #
  # source://kramdown//lib/kramdown/parser/kramdown/list.rb#32
  def parse_first_list_line(indentation, content); end

  # Parse the foot note definition at the current location.
  #
  # source://kramdown//lib/kramdown/parser/kramdown/footnote.rb#21
  def parse_footnote_definition; end

  # Parse the footnote marker at the current location.
  #
  # source://kramdown//lib/kramdown/parser/kramdown/footnote.rb#40
  def parse_footnote_marker; end

  # Parse the horizontal rule at the current location.
  #
  # source://kramdown//lib/kramdown/parser/kramdown/horizontal_rule.rb#17
  def parse_horizontal_rule; end

  # Parse the HTML entity at the current location.
  #
  # source://kramdown//lib/kramdown/parser/kramdown/html_entity.rb#17
  def parse_html_entity; end

  # Parse the inline math at the current location.
  #
  # source://kramdown//lib/kramdown/parser/kramdown/math.rb#44
  def parse_inline_math; end

  # Parse the line break at the current location.
  #
  # source://kramdown//lib/kramdown/parser/kramdown/line_break.rb#17
  def parse_line_break; end

  # Parse the link at the current scanner position. This method is used to parse normal links as
  # well as image links.
  #
  # source://kramdown//lib/kramdown/parser/kramdown/link.rb#61
  def parse_link; end

  # Parse the link definition at the current location.
  #
  # source://kramdown//lib/kramdown/parser/kramdown/link.rb#24
  def parse_link_definition; end

  # Parse the ordered or unordered list at the current location.
  #
  # source://kramdown//lib/kramdown/parser/kramdown/list.rb#54
  def parse_list; end

  # Parse the paragraph at the current location.
  #
  # source://kramdown//lib/kramdown/parser/kramdown/paragraph.rb#31
  def parse_paragraph; end

  # Parse the Setext header at the current location.
  #
  # source://kramdown//lib/kramdown/parser/kramdown/header.rb#20
  def parse_setext_header; end

  # Parse the smart quotes at current location.
  #
  # source://kramdown//lib/kramdown/parser/kramdown/smart_quotes.rb#158
  def parse_smart_quotes; end

  # Parse the extension span at the current location.
  #
  # source://kramdown//lib/kramdown/parser/kramdown/extensions.rb#192
  def parse_span_extensions; end

  # Parse the HTML at the current position as span-level HTML.
  #
  # source://kramdown//lib/kramdown/parser/kramdown/html.rb#102
  def parse_span_html; end

  # Parse the table at the current location.
  #
  # source://kramdown//lib/kramdown/parser/kramdown/table.rb#25
  def parse_table; end

  # Parse the typographic symbols at the current location.
  #
  # source://kramdown//lib/kramdown/parser/kramdown/typographic_symbol.rb#22
  def parse_typographic_syms; end

  # Replace the abbreviation text with elements.
  #
  # source://kramdown//lib/kramdown/parser/kramdown/abbreviation.rb#41
  def replace_abbreviations(el, regexps = T.unsafe(nil)); end

  # Update the +ial+ with the information from the inline attribute list +opts+.
  #
  # source://kramdown//lib/kramdown/parser/kramdown/extensions.rb#41
  def update_ial_with_ial(ial, opts); end

  protected

  # source://kramdown//lib/kramdown/parser/kramdown/header.rb#59
  def add_header(level, text, id); end

  # Adapt the object to allow parsing like specified in the options.
  #
  # source://kramdown//lib/kramdown/parser/kramdown.rb#121
  def configure_parser; end

  # Create a new block-level element, taking care of applying a preceding block IAL if it
  # exists. This method should always be used for creating a block-level element!
  #
  # source://kramdown//lib/kramdown/parser/kramdown.rb#305
  def new_block_el(*args); end

  # Parse all block-level elements in +text+ into the element +el+.
  #
  # source://kramdown//lib/kramdown/parser/kramdown.rb#140
  def parse_blocks(el, text = T.unsafe(nil)); end

  # Returns header text and optional ID.
  #
  # source://kramdown//lib/kramdown/parser/kramdown/header.rb#47
  def parse_header_contents; end

  # Parse all span-level elements in the source string of @src into +el+.
  #
  # If the parameter +stop_re+ (a regexp) is used, parsing is immediately stopped if the regexp
  # matches and if no block is given or if a block is given and it returns +true+.
  #
  # The parameter +parsers+ can be used to specify the (span-level) parsing methods that should
  # be used for parsing.
  #
  # The parameter +text_type+ specifies the type which should be used for created text nodes.
  #
  # source://kramdown//lib/kramdown/parser/kramdown.rb#214
  def parse_spans(el, stop_re = T.unsafe(nil), parsers = T.unsafe(nil), text_type = T.unsafe(nil)); end

  # Reset the current parsing environment. The parameter +env+ can be used to set initial
  # values for one or more environment variables.
  #
  # source://kramdown//lib/kramdown/parser/kramdown.rb#253
  def reset_env(opts = T.unsafe(nil)); end

  # Restore the current parsing environment.
  #
  # source://kramdown//lib/kramdown/parser/kramdown.rb#268
  def restore_env(env); end

  # Return the current parsing environment.
  #
  # source://kramdown//lib/kramdown/parser/kramdown.rb#263
  def save_env; end

  # Create the needed span parser regexps.
  #
  # source://kramdown//lib/kramdown/parser/kramdown.rb#134
  def span_parser_regexps(parsers = T.unsafe(nil)); end

  # Update the given attributes hash +attr+ with the information from the inline attribute list
  # +ial+ and all referenced ALDs.
  #
  # source://kramdown//lib/kramdown/parser/kramdown.rb#274
  def update_attr_with_ial(attr, ial); end

  #
  # Update the parser specific link definitions with the data from +link_defs+ (the value of the
  # :link_defs option).
  #
  # The parameter +link_defs+ is a hash where the keys are possibly unnormalized link IDs and
  # the values are two element arrays consisting of the link target and a title (can be +nil+).
  #
  # source://kramdown//lib/kramdown/parser/kramdown.rb#116
  def update_link_definitions(link_defs); end

  # Update the raw text for automatic ID generation.
  #
  # source://kramdown//lib/kramdown/parser/kramdown.rb#288
  def update_raw_text(item); end

  # Update the tree by parsing all :+raw_text+ elements with the span-level parser (resets the
  # environment) and by updating the attributes from the IALs.
  #
  # source://kramdown//lib/kramdown/parser/kramdown.rb#166
  def update_tree(element); end

  private

  # precomputed patterns for indentations 1..4 and fallback expression
  # to compute pattern when indentation is outside the 1..4 range.
  #
  # source://kramdown//lib/kramdown/parser/kramdown/list.rb#258
  def fetch_pattern(type, indentation); end

  # source://kramdown//lib/kramdown/parser/kramdown.rb#200
  def span_pattern_cache(stop_re, span_start); end

  class << self
    # Add a parser method
    #
    # * with the given +name+,
    # * using +start_re+ as start regexp
    # * and, for span parsers, +span_start+ as a String that can be used in a regexp and
    #   which identifies the starting character(s)
    #
    # to the registry. The method name is automatically derived from the +name+ or can explicitly
    # be set by using the +meth_name+ parameter.
    #
    # source://kramdown//lib/kramdown/parser/kramdown.rb#328
    def define_parser(name, start_re, span_start = T.unsafe(nil), meth_name = T.unsafe(nil)); end

    # Return +true+ if there is a parser called +name+.
    #
    # @return [Boolean]
    #
    # source://kramdown//lib/kramdown/parser/kramdown.rb#339
    def has_parser?(name); end

    # Return the Data structure for the parser +name+.
    #
    # source://kramdown//lib/kramdown/parser/kramdown.rb#334
    def parser(name = T.unsafe(nil)); end
  end
end

# source://kramdown//lib/kramdown/parser/kramdown/abbreviation.rb#14
Kramdown::Parser::Kramdown::ABBREV_DEFINITION_START = T.let(T.unsafe(nil), Regexp)

# source://kramdown//lib/kramdown/parser/kramdown/autolink.rb#14
Kramdown::Parser::Kramdown::ACHARS = T.let(T.unsafe(nil), String)

# source://kramdown//lib/kramdown/parser/kramdown/extensions.rb#140
Kramdown::Parser::Kramdown::ALD_ANY_CHARS = T.let(T.unsafe(nil), Regexp)

# source://kramdown//lib/kramdown/parser/kramdown/extensions.rb#142
Kramdown::Parser::Kramdown::ALD_CLASS_NAME = T.let(T.unsafe(nil), Regexp)

# source://kramdown//lib/kramdown/parser/kramdown/extensions.rb#139
Kramdown::Parser::Kramdown::ALD_ID_CHARS = T.let(T.unsafe(nil), Regexp)

# source://kramdown//lib/kramdown/parser/kramdown/extensions.rb#141
Kramdown::Parser::Kramdown::ALD_ID_NAME = T.let(T.unsafe(nil), Regexp)

# source://kramdown//lib/kramdown/parser/kramdown/extensions.rb#150
Kramdown::Parser::Kramdown::ALD_START = T.let(T.unsafe(nil), Regexp)

# source://kramdown//lib/kramdown/parser/kramdown/extensions.rb#149
Kramdown::Parser::Kramdown::ALD_TYPE_ANY = T.let(T.unsafe(nil), Regexp)

# source://kramdown//lib/kramdown/parser/kramdown/extensions.rb#144
Kramdown::Parser::Kramdown::ALD_TYPE_CLASS_NAME = T.let(T.unsafe(nil), Regexp)

# source://kramdown//lib/kramdown/parser/kramdown/extensions.rb#145
Kramdown::Parser::Kramdown::ALD_TYPE_ID_NAME = T.let(T.unsafe(nil), Regexp)

# source://kramdown//lib/kramdown/parser/kramdown/extensions.rb#146
Kramdown::Parser::Kramdown::ALD_TYPE_ID_OR_CLASS = T.let(T.unsafe(nil), Regexp)

# source://kramdown//lib/kramdown/parser/kramdown/extensions.rb#147
Kramdown::Parser::Kramdown::ALD_TYPE_ID_OR_CLASS_MULTI = T.let(T.unsafe(nil), Regexp)

# source://kramdown//lib/kramdown/parser/kramdown/extensions.rb#143
Kramdown::Parser::Kramdown::ALD_TYPE_KEY_VALUE_PAIR = T.let(T.unsafe(nil), Regexp)

# source://kramdown//lib/kramdown/parser/kramdown/extensions.rb#148
Kramdown::Parser::Kramdown::ALD_TYPE_REF = T.let(T.unsafe(nil), Regexp)

# source://kramdown//lib/kramdown/parser/kramdown/header.rb#29
Kramdown::Parser::Kramdown::ATX_HEADER_START = T.let(T.unsafe(nil), Regexp)

# source://kramdown//lib/kramdown/parser/kramdown/autolink.rb#16
Kramdown::Parser::Kramdown::AUTOLINK_START = T.let(T.unsafe(nil), Regexp)

# source://kramdown//lib/kramdown/parser/kramdown/autolink.rb#15
Kramdown::Parser::Kramdown::AUTOLINK_START_STR = T.let(T.unsafe(nil), String)

# source://kramdown//lib/kramdown/parser/kramdown/blank_line.rb#14
Kramdown::Parser::Kramdown::BLANK_LINE = T.let(T.unsafe(nil), Regexp)

# source://kramdown//lib/kramdown/parser/kramdown/blockquote.rb#18
Kramdown::Parser::Kramdown::BLOCKQUOTE_START = T.let(T.unsafe(nil), Regexp)

# source://kramdown//lib/kramdown/parser/kramdown/block_boundary.rb#18
Kramdown::Parser::Kramdown::BLOCK_BOUNDARY = T.let(T.unsafe(nil), Regexp)

# source://kramdown//lib/kramdown/parser/kramdown/extensions.rb#160
Kramdown::Parser::Kramdown::BLOCK_EXTENSIONS_START = T.let(T.unsafe(nil), Regexp)

# source://kramdown//lib/kramdown/parser/kramdown/math.rb#16
Kramdown::Parser::Kramdown::BLOCK_MATH_START = T.let(T.unsafe(nil), Regexp)

# source://kramdown//lib/kramdown/parser/kramdown/codeblock.rb#20
Kramdown::Parser::Kramdown::CODEBLOCK_MATCH = T.let(T.unsafe(nil), Regexp)

# source://kramdown//lib/kramdown/parser/kramdown/codeblock.rb#19
Kramdown::Parser::Kramdown::CODEBLOCK_START = T.let(T.unsafe(nil), Regexp)

# source://kramdown//lib/kramdown/parser/kramdown/codespan.rb#14
Kramdown::Parser::Kramdown::CODESPAN_DELIMITER = T.let(T.unsafe(nil), Regexp)

# source://kramdown//lib/kramdown/parser/kramdown/list.rb#150
Kramdown::Parser::Kramdown::DEFINITION_LIST_START = T.let(T.unsafe(nil), Regexp)

# Struct class holding all the needed data for one block/span-level parser method.
#
# source://kramdown//lib/kramdown/parser/kramdown.rb#317
class Kramdown::Parser::Kramdown::Data < ::Struct
  # Returns the value of attribute method
  #
  # @return [Object] the current value of method
  def method; end

  # Sets the attribute method
  #
  # @param value [Object] the value to set the attribute method to.
  # @return [Object] the newly set value
  def method=(_); end

  # Returns the value of attribute name
  #
  # @return [Object] the current value of name
  def name; end

  # Sets the attribute name
  #
  # @param value [Object] the value to set the attribute name to.
  # @return [Object] the newly set value
  def name=(_); end

  # Returns the value of attribute span_start
  #
  # @return [Object] the current value of span_start
  def span_start; end

  # Sets the attribute span_start
  #
  # @param value [Object] the value to set the attribute span_start to.
  # @return [Object] the newly set value
  def span_start=(_); end

  # Returns the value of attribute start_re
  #
  # @return [Object] the current value of start_re
  def start_re; end

  # Sets the attribute start_re
  #
  # @param value [Object] the value to set the attribute start_re to.
  # @return [Object] the newly set value
  def start_re=(_); end

  class << self
    def [](*_arg0); end
    def inspect; end
    def keyword_init?; end
    def members; end
    def new(*_arg0); end
  end
end

# source://kramdown//lib/kramdown/parser/kramdown/emphasis.rb#14
Kramdown::Parser::Kramdown::EMPHASIS_START = T.let(T.unsafe(nil), Regexp)

# source://kramdown//lib/kramdown/parser/kramdown/eob.rb#14
Kramdown::Parser::Kramdown::EOB_MARKER = T.let(T.unsafe(nil), Regexp)

# source://kramdown//lib/kramdown/parser/kramdown/escaped_chars.rb#14
Kramdown::Parser::Kramdown::ESCAPED_CHARS = T.let(T.unsafe(nil), Regexp)

# source://kramdown//lib/kramdown/parser/kramdown/extensions.rb#154
Kramdown::Parser::Kramdown::EXT_BLOCK_START = T.let(T.unsafe(nil), Regexp)

# source://kramdown//lib/kramdown/parser/kramdown/extensions.rb#155
Kramdown::Parser::Kramdown::EXT_BLOCK_STOP_STR = T.let(T.unsafe(nil), String)

# source://kramdown//lib/kramdown/parser/kramdown/extensions.rb#187
Kramdown::Parser::Kramdown::EXT_SPAN_START = T.let(T.unsafe(nil), Regexp)

# source://kramdown//lib/kramdown/parser/kramdown/extensions.rb#153
Kramdown::Parser::Kramdown::EXT_START_STR = T.let(T.unsafe(nil), String)

# source://kramdown//lib/kramdown/parser/kramdown/extensions.rb#152
Kramdown::Parser::Kramdown::EXT_STOP_STR = T.let(T.unsafe(nil), String)

# source://kramdown//lib/kramdown/parser/kramdown/codeblock.rb#34
Kramdown::Parser::Kramdown::FENCED_CODEBLOCK_MATCH = T.let(T.unsafe(nil), Regexp)

# source://kramdown//lib/kramdown/parser/kramdown/codeblock.rb#33
Kramdown::Parser::Kramdown::FENCED_CODEBLOCK_START = T.let(T.unsafe(nil), Regexp)

# source://kramdown//lib/kramdown/parser/kramdown/footnote.rb#18
Kramdown::Parser::Kramdown::FOOTNOTE_DEFINITION_START = T.let(T.unsafe(nil), Regexp)

# source://kramdown//lib/kramdown/parser/kramdown/footnote.rb#37
Kramdown::Parser::Kramdown::FOOTNOTE_MARKER_START = T.let(T.unsafe(nil), Regexp)

# source://kramdown//lib/kramdown/parser/kramdown/header.rb#44
Kramdown::Parser::Kramdown::HEADER_ID = T.let(T.unsafe(nil), Regexp)

# source://kramdown//lib/kramdown/parser/kramdown/horizontal_rule.rb#14
Kramdown::Parser::Kramdown::HR_START = T.let(T.unsafe(nil), Regexp)

# source://kramdown//lib/kramdown/parser/kramdown/html.rb#68
Kramdown::Parser::Kramdown::HTML_BLOCK_START = T.let(T.unsafe(nil), Regexp)

# Mapping of markdown attribute value to content model. I.e. :raw when "0", :default when "1"
# (use default content model for the HTML element), :span when "span", :block when block and
# for everything else +nil+ is returned.
#
# source://kramdown//lib/kramdown/parser/kramdown/html.rb#21
Kramdown::Parser::Kramdown::HTML_MARKDOWN_ATTR_MAP = T.let(T.unsafe(nil), Hash)

# source://kramdown//lib/kramdown/parser/kramdown/html.rb#99
Kramdown::Parser::Kramdown::HTML_SPAN_START = T.let(T.unsafe(nil), Regexp)

# source://kramdown//lib/kramdown/parser/kramdown/extensions.rb#157
Kramdown::Parser::Kramdown::IAL_BLOCK = T.let(T.unsafe(nil), Regexp)

# source://kramdown//lib/kramdown/parser/kramdown/extensions.rb#158
Kramdown::Parser::Kramdown::IAL_BLOCK_START = T.let(T.unsafe(nil), Regexp)

# source://kramdown//lib/kramdown/parser/kramdown/extensions.rb#14
Kramdown::Parser::Kramdown::IAL_CLASS_ATTR = T.let(T.unsafe(nil), String)

# source://kramdown//lib/kramdown/parser/kramdown/extensions.rb#188
Kramdown::Parser::Kramdown::IAL_SPAN_START = T.let(T.unsafe(nil), Regexp)

# Regexp for matching indentation (one tab or four spaces)
#
# source://kramdown//lib/kramdown/parser/kramdown.rb#344
Kramdown::Parser::Kramdown::INDENT = T.let(T.unsafe(nil), Regexp)

# source://kramdown//lib/kramdown/parser/kramdown/math.rb#41
Kramdown::Parser::Kramdown::INLINE_MATH_START = T.let(T.unsafe(nil), Regexp)

# source://kramdown//lib/kramdown/parser/kramdown/paragraph.rb#24
Kramdown::Parser::Kramdown::LAZY_END = T.let(T.unsafe(nil), Regexp)

# source://kramdown//lib/kramdown/parser/kramdown/paragraph.rb#20
Kramdown::Parser::Kramdown::LAZY_END_HTML_SPAN_ELEMENTS = T.let(T.unsafe(nil), Array)

# source://kramdown//lib/kramdown/parser/kramdown/paragraph.rb#21
Kramdown::Parser::Kramdown::LAZY_END_HTML_START = T.let(T.unsafe(nil), Regexp)

# source://kramdown//lib/kramdown/parser/kramdown/paragraph.rb#22
Kramdown::Parser::Kramdown::LAZY_END_HTML_STOP = T.let(T.unsafe(nil), Regexp)

# source://kramdown//lib/kramdown/parser/kramdown/line_break.rb#14
Kramdown::Parser::Kramdown::LINE_BREAK = T.let(T.unsafe(nil), Regexp)

# source://kramdown//lib/kramdown/parser/kramdown/link.rb#53
Kramdown::Parser::Kramdown::LINK_BRACKET_STOP_RE = T.let(T.unsafe(nil), Regexp)

# source://kramdown//lib/kramdown/parser/kramdown/link.rb#21
Kramdown::Parser::Kramdown::LINK_DEFINITION_START = T.let(T.unsafe(nil), Regexp)

# source://kramdown//lib/kramdown/parser/kramdown/link.rb#55
Kramdown::Parser::Kramdown::LINK_INLINE_ID_RE = T.let(T.unsafe(nil), Regexp)

# source://kramdown//lib/kramdown/parser/kramdown/link.rb#56
Kramdown::Parser::Kramdown::LINK_INLINE_TITLE_RE = T.let(T.unsafe(nil), Regexp)

# source://kramdown//lib/kramdown/parser/kramdown/link.rb#54
Kramdown::Parser::Kramdown::LINK_PAREN_STOP_RE = T.let(T.unsafe(nil), Regexp)

# source://kramdown//lib/kramdown/parser/kramdown/link.rb#57
Kramdown::Parser::Kramdown::LINK_START = T.let(T.unsafe(nil), Regexp)

# source://kramdown//lib/kramdown/parser/kramdown/list.rb#19
Kramdown::Parser::Kramdown::LIST_ITEM_IAL = T.let(T.unsafe(nil), Regexp)

# source://kramdown//lib/kramdown/parser/kramdown/list.rb#20
Kramdown::Parser::Kramdown::LIST_ITEM_IAL_CHECK = T.let(T.unsafe(nil), Regexp)

# source://kramdown//lib/kramdown/parser/kramdown/list.rb#51
Kramdown::Parser::Kramdown::LIST_START = T.let(T.unsafe(nil), Regexp)

# source://kramdown//lib/kramdown/parser/kramdown/list.rb#50
Kramdown::Parser::Kramdown::LIST_START_OL = T.let(T.unsafe(nil), Regexp)

# source://kramdown//lib/kramdown/parser/kramdown/list.rb#49
Kramdown::Parser::Kramdown::LIST_START_UL = T.let(T.unsafe(nil), Regexp)

# Regexp for matching the optional space (zero or up to three spaces)
#
# source://kramdown//lib/kramdown/parser/kramdown.rb#346
Kramdown::Parser::Kramdown::OPT_SPACE = T.let(T.unsafe(nil), Regexp)

# source://kramdown//lib/kramdown/parser/kramdown/paragraph.rb#28
Kramdown::Parser::Kramdown::PARAGRAPH_END = T.let(T.unsafe(nil), Regexp)

# source://kramdown//lib/kramdown/parser/kramdown/paragraph.rb#27
Kramdown::Parser::Kramdown::PARAGRAPH_MATCH = T.let(T.unsafe(nil), Regexp)

# source://kramdown//lib/kramdown/parser/kramdown/paragraph.rb#26
Kramdown::Parser::Kramdown::PARAGRAPH_START = T.let(T.unsafe(nil), Regexp)

# source://kramdown//lib/kramdown/parser/kramdown/list.rb#22
Kramdown::Parser::Kramdown::PARSE_FIRST_LIST_LINE_REGEXP_CACHE = T.let(T.unsafe(nil), Hash)

# source://kramdown//lib/kramdown/parser/kramdown/list.rb#47
Kramdown::Parser::Kramdown::PATTERN_TAIL = T.let(T.unsafe(nil), Regexp)

# source://kramdown//lib/kramdown/parser/kramdown/header.rb#17
Kramdown::Parser::Kramdown::SETEXT_HEADER_START = T.let(T.unsafe(nil), Regexp)

# source://kramdown//lib/kramdown/parser/kramdown/smart_quotes.rb#155
Kramdown::Parser::Kramdown::SMART_QUOTES_RE = T.let(T.unsafe(nil), Regexp)

# source://kramdown//lib/kramdown/parser/kramdown/extensions.rb#189
Kramdown::Parser::Kramdown::SPAN_EXTENSIONS_START = T.let(T.unsafe(nil), Regexp)

# source://kramdown//lib/kramdown/parser/kramdown/smart_quotes.rb#122
Kramdown::Parser::Kramdown::SQ_CLOSE = T.let(T.unsafe(nil), String)

# source://kramdown//lib/kramdown/parser/kramdown/smart_quotes.rb#121
Kramdown::Parser::Kramdown::SQ_PUNCT = T.let(T.unsafe(nil), String)

# source://kramdown//lib/kramdown/parser/kramdown/smart_quotes.rb#124
Kramdown::Parser::Kramdown::SQ_RULES = T.let(T.unsafe(nil), Array)

# '"
#
# source://kramdown//lib/kramdown/parser/kramdown/smart_quotes.rb#145
Kramdown::Parser::Kramdown::SQ_SUBSTS = T.let(T.unsafe(nil), Hash)

# source://kramdown//lib/kramdown/parser/kramdown/table.rb#18
Kramdown::Parser::Kramdown::TABLE_FSEP_LINE = T.let(T.unsafe(nil), Regexp)

# source://kramdown//lib/kramdown/parser/kramdown/table.rb#17
Kramdown::Parser::Kramdown::TABLE_HSEP_ALIGN = T.let(T.unsafe(nil), Regexp)

# source://kramdown//lib/kramdown/parser/kramdown/table.rb#21
Kramdown::Parser::Kramdown::TABLE_LINE = T.let(T.unsafe(nil), Regexp)

# source://kramdown//lib/kramdown/parser/kramdown/table.rb#20
Kramdown::Parser::Kramdown::TABLE_PIPE_CHECK = T.let(T.unsafe(nil), Regexp)

# source://kramdown//lib/kramdown/parser/kramdown/table.rb#19
Kramdown::Parser::Kramdown::TABLE_ROW_LINE = T.let(T.unsafe(nil), Regexp)

# source://kramdown//lib/kramdown/parser/kramdown/table.rb#16
Kramdown::Parser::Kramdown::TABLE_SEP_LINE = T.let(T.unsafe(nil), Regexp)

# source://kramdown//lib/kramdown/parser/kramdown/table.rb#22
Kramdown::Parser::Kramdown::TABLE_START = T.let(T.unsafe(nil), Regexp)

# source://kramdown//lib/kramdown/parser/kramdown/html.rb#23
Kramdown::Parser::Kramdown::TRAILING_WHITESPACE = T.let(T.unsafe(nil), Regexp)

# source://kramdown//lib/kramdown/parser/kramdown/typographic_symbol.rb#14
Kramdown::Parser::Kramdown::TYPOGRAPHIC_SYMS = T.let(T.unsafe(nil), Array)

# source://kramdown//lib/kramdown/parser/kramdown/typographic_symbol.rb#19
Kramdown::Parser::Kramdown::TYPOGRAPHIC_SYMS_RE = T.let(T.unsafe(nil), Regexp)

# source://kramdown//lib/kramdown/parser/kramdown/typographic_symbol.rb#18
Kramdown::Parser::Kramdown::TYPOGRAPHIC_SYMS_SUBST = T.let(T.unsafe(nil), Hash)

# Used for parsing a document in Markdown format.
#
# This parser is based on the kramdown parser and removes the parser methods for the additional
# non-Markdown features. However, since some things are handled differently by the kramdown
# parser methods (like deciding when a list item contains just text), this parser differs from
# real Markdown parsers in some respects.
#
# Note, though, that the parser basically fails just one of the Markdown test cases (some others
# also fail but those failures are negligible).
#
# source://kramdown//lib/kramdown/parser/markdown.rb#25
class Kramdown::Parser::Markdown < ::Kramdown::Parser::Kramdown
  # @return [Markdown] a new instance of Markdown
  #
  # source://kramdown//lib/kramdown/parser/markdown.rb#32
  def initialize(source, options); end
end

# :stopdoc:
#
# source://kramdown//lib/kramdown/parser/markdown.rb#40
Kramdown::Parser::Markdown::BLOCK_BOUNDARY = T.let(T.unsafe(nil), Regexp)

# source://kramdown//lib/kramdown/parser/markdown.rb#43
Kramdown::Parser::Markdown::CODEBLOCK_MATCH = T.let(T.unsafe(nil), Regexp)

# Array with all the parsing methods that should be removed from the standard kramdown parser.
#
# source://kramdown//lib/kramdown/parser/markdown.rb#28
Kramdown::Parser::Markdown::EXTENDED = T.let(T.unsafe(nil), Array)

# source://kramdown//lib/kramdown/parser/markdown.rb#46
Kramdown::Parser::Markdown::IAL_RAND_CHARS = T.let(T.unsafe(nil), Array)

# source://kramdown//lib/kramdown/parser/markdown.rb#47
Kramdown::Parser::Markdown::IAL_RAND_STRING = T.let(T.unsafe(nil), String)

# source://kramdown//lib/kramdown/parser/markdown.rb#49
Kramdown::Parser::Markdown::IAL_SPAN_START = T.let(T.unsafe(nil), Regexp)

# source://kramdown//lib/kramdown/parser/markdown.rb#41
Kramdown::Parser::Markdown::LAZY_END = T.let(T.unsafe(nil), Regexp)

# source://kramdown//lib/kramdown/parser/markdown.rb#48
Kramdown::Parser::Markdown::LIST_ITEM_IAL = T.let(T.unsafe(nil), Regexp)

# source://kramdown//lib/kramdown/parser/markdown.rb#44
Kramdown::Parser::Markdown::PARAGRAPH_END = T.let(T.unsafe(nil), Regexp)

# == \Utils Module
#
# This module contains utility class/modules/methods that can be used by both parsers and
# converters.
#
# source://kramdown//lib/kramdown/utils.rb#16
module Kramdown::Utils
  class << self
    # Treat +name+ as if it were snake cased (e.g. snake_case) and camelize it (e.g. SnakeCase).
    #
    # source://kramdown//lib/kramdown/utils.rb#26
    def camelize(name); end

    # source://kramdown//lib/kramdown/utils.rb#39
    def deep_const_get(str); end

    # Treat +name+ as if it were camelized (e.g. CamelizedName) and snake-case it (e.g. camelized_name).
    #
    # source://kramdown//lib/kramdown/utils.rb#31
    def snake_case(name); end
  end
end

# Methods for registering configurable extensions.
#
# source://kramdown//lib/kramdown/utils/configurable.rb#14
module Kramdown::Utils::Configurable
  # Create a new configurable extension called +name+.
  #
  # Three methods will be defined on the calling object which allow to use this configurable
  # extension:
  #
  # configurables:: Returns a hash of hashes that is used to store all configurables of the
  #                 object.
  #
  # <name>(ext_name):: Return the configured extension +ext_name+.
  #
  # add_<name>(ext_name, data=nil, &block):: Define an extension +ext_name+ by specifying either
  #                                          the data as argument or by using a block.
  #
  # source://kramdown//lib/kramdown/utils/configurable.rb#28
  def configurable(name); end
end

# Provides convenience methods for handling named and numeric entities.
#
# source://kramdown//lib/kramdown/utils/entities.rb#15
module Kramdown::Utils::Entities
  private

  # Return the entity for the given code point or name +point_or_name+.
  #
  # source://kramdown//lib/kramdown/utils/entities.rb#334
  def entity(point_or_name); end

  class << self
    # Return the entity for the given code point or name +point_or_name+.
    #
    # source://kramdown//lib/kramdown/utils/entities.rb#334
    def entity(point_or_name); end
  end
end

# Contains the mapping of code point (or name) to the actual Entity object.
#
# source://kramdown//lib/kramdown/utils/entities.rb#317
Kramdown::Utils::Entities::ENTITY_MAP = T.let(T.unsafe(nil), Hash)

# Array of arrays. Each sub-array specifies a code point and the associated name.
#
# This table is not used directly -- Entity objects are automatically created from it and put
# into a Hash map when this file is loaded.
#
# source://kramdown//lib/kramdown/utils/entities.rb#29
Kramdown::Utils::Entities::ENTITY_TABLE = T.let(T.unsafe(nil), Array)

# Represents an entity that has a +code_point+ and +name+.
#
# source://kramdown//lib/kramdown/utils/entities.rb#18
class Kramdown::Utils::Entities::Entity < ::Struct
  # Return the UTF8 representation of the entity.
  #
  # source://kramdown//lib/kramdown/utils/entities.rb#20
  def char; end

  # Returns the value of attribute code_point
  #
  # @return [Object] the current value of code_point
  def code_point; end

  # Sets the attribute code_point
  #
  # @param value [Object] the value to set the attribute code_point to.
  # @return [Object] the newly set value
  def code_point=(_); end

  # Returns the value of attribute name
  #
  # @return [Object] the current value of name
  def name; end

  # Sets the attribute name
  #
  # @param value [Object] the value to set the attribute name to.
  # @return [Object] the newly set value
  def name=(_); end

  class << self
    def [](*_arg0); end
    def inspect; end
    def keyword_init?; end
    def members; end
    def new(*_arg0); end
  end
end

# Provides convenience methods for HTML related tasks.
#
# *Note* that this module has to be mixed into a class that has a @root (containing an element
# of type :root) and an @options (containing an options hash) instance variable so that some of
# the methods can work correctly.
#
# source://kramdown//lib/kramdown/utils/html.rb#21
module Kramdown::Utils::Html
  # Convert the entity +e+ to a string. The optional parameter +original+ may contain the
  # original representation of the entity.
  #
  # This method uses the option +entity_output+ to determine the output form for the entity.
  #
  # source://kramdown//lib/kramdown/utils/html.rb#27
  def entity_to_str(e, original = T.unsafe(nil)); end

  # Escape the special HTML characters in the string +str+. The parameter +type+ specifies what
  # is escaped: :all - all special HTML characters except the quotation mark as well as
  # entities, :text - all special HTML characters except the quotation mark but no entities and
  # :attribute - all special HTML characters including the quotation mark but no entities.
  #
  # source://kramdown//lib/kramdown/utils/html.rb#69
  def escape_html(str, type = T.unsafe(nil)); end

  # source://kramdown//lib/kramdown/utils/html.rb#74
  def fix_cjk_line_break(str); end

  # Return the HTML representation of the attributes +attr+.
  #
  # source://kramdown//lib/kramdown/utils/html.rb#44
  def html_attributes(attr); end
end

# source://kramdown//lib/kramdown/utils/html.rb#59
Kramdown::Utils::Html::ESCAPE_ALL_RE = T.let(T.unsafe(nil), Regexp)

# source://kramdown//lib/kramdown/utils/html.rb#61
Kramdown::Utils::Html::ESCAPE_ATTRIBUTE_RE = T.let(T.unsafe(nil), Regexp)

# :stopdoc:
#
# source://kramdown//lib/kramdown/utils/html.rb#53
Kramdown::Utils::Html::ESCAPE_MAP = T.let(T.unsafe(nil), Hash)

# source://kramdown//lib/kramdown/utils/html.rb#62
Kramdown::Utils::Html::ESCAPE_RE_FROM_TYPE = T.let(T.unsafe(nil), Hash)

# source://kramdown//lib/kramdown/utils/html.rb#60
Kramdown::Utils::Html::ESCAPE_TEXT_RE = T.let(T.unsafe(nil), Regexp)

# source://kramdown//lib/kramdown/utils/html.rb#73
Kramdown::Utils::Html::REDUNDANT_LINE_BREAK_REGEX = T.let(T.unsafe(nil), Regexp)

# A simple least recently used (LRU) cache.
#
# The cache relies on the fact that Ruby's Hash class maintains insertion order. So deleting
# and re-inserting a key-value pair on access moves the key to the last position. When an
# entry is added and the cache is full, the first entry is removed.
#
# source://kramdown//lib/kramdown/utils/lru_cache.rb#18
class Kramdown::Utils::LRUCache
  # Creates a new LRUCache that can hold +size+ entries.
  #
  # @return [LRUCache] a new instance of LRUCache
  #
  # source://kramdown//lib/kramdown/utils/lru_cache.rb#21
  def initialize(size); end

  # Returns the stored value for +key+ or +nil+ if no value was stored under the key.
  #
  # source://kramdown//lib/kramdown/utils/lru_cache.rb#27
  def [](key); end

  # Stores the +value+ under the +key+.
  #
  # source://kramdown//lib/kramdown/utils/lru_cache.rb#32
  def []=(key, value); end
end

# This patched StringScanner adds line number information for current scan position and a
# start_line_number override for nested StringScanners.
#
# source://kramdown//lib/kramdown/utils/string_scanner.rb#17
class Kramdown::Utils::StringScanner < ::StringScanner
  # Takes the start line number as optional second argument.
  #
  # Note: The original second argument is no longer used so this should be safe.
  #
  # @return [StringScanner] a new instance of StringScanner
  #
  # source://kramdown//lib/kramdown/utils/string_scanner.rb#26
  def initialize(string, start_line_number = T.unsafe(nil)); end

  # Returns the line number for current charpos.
  #
  # NOTE: Requires that all line endings are normalized to '\n'
  #
  # NOTE: Normally we'd have to add one to the count of newlines to get the correct line number.
  # However we add the one indirectly by using a one-based start_line_number.
  #
  # source://kramdown//lib/kramdown/utils/string_scanner.rb#67
  def current_line_number; end

  # Sets the byte position of the scan pointer.
  #
  # Note: This also resets some internal variables, so always use pos= when setting the position
  # and don't use any other method for that!
  #
  # source://kramdown//lib/kramdown/utils/string_scanner.rb#37
  def pos=(pos); end

  # Revert the position to one saved by #save_pos.
  #
  # source://kramdown//lib/kramdown/utils/string_scanner.rb#56
  def revert_pos(data); end

  # Return information needed to revert the byte position of the string scanner in a performant
  # way.
  #
  # The returned data can be fed to #revert_pos to revert the position to the saved one.
  #
  # Note: Just saving #pos won't be enough.
  #
  # source://kramdown//lib/kramdown/utils/string_scanner.rb#51
  def save_pos; end

  # The start line number. Used for nested StringScanners that scan a sub-string of the source
  # document. The kramdown parser uses this, e.g., for span level parsers.
  #
  # source://kramdown//lib/kramdown/utils/string_scanner.rb#21
  def start_line_number; end
end

# The kramdown version.
#
# source://kramdown//lib/kramdown/version.rb#13
Kramdown::VERSION = T.let(T.unsafe(nil), String)
