# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `bindata` gem.
# Please instead update this file by running `bin/tapioca gem bindata`.

# source://bindata//lib/bindata/version.rb#1
module BinData
  extend ::BinData::BitFieldFactory
  extend ::BinData::IntFactory

  private

  # @yield [@tracer]
  #
  # source://bindata//lib/bindata/trace.rb#41
  def trace_message; end

  # Turn on trace information when reading a BinData object.
  # If +block+ is given then the tracing only occurs for that block.
  # This is useful for debugging a BinData declaration.
  #
  # source://bindata//lib/bindata/trace.rb#6
  def trace_reading(io = T.unsafe(nil)); end

  class << self
    # @yield [@tracer]
    #
    # source://bindata//lib/bindata/trace.rb#41
    def trace_message; end

    # Turn on trace information when reading a BinData object.
    # If +block+ is given then the tracing only occurs for that block.
    # This is useful for debugging a BinData declaration.
    #
    # source://bindata//lib/bindata/trace.rb#6
    def trace_reading(io = T.unsafe(nil)); end
  end
end

# source://bindata//lib/bindata/params.rb#4
module BinData::AcceptedParametersPlugin
  # source://bindata//lib/bindata/params.rb#30
  def accepted_parameters; end

  # Default parameters can be overridden when instantiating a data object.
  #
  # source://bindata//lib/bindata/params.rb#16
  def default_parameter(*args); end

  # Default parameters can be overridden when instantiating a data object.
  #
  # source://bindata//lib/bindata/params.rb#16
  def default_parameters(*args); end

  # Mandatory parameters must be present when instantiating a data object.
  #
  # source://bindata//lib/bindata/params.rb#6
  def mandatory_parameter(*args); end

  # Mandatory parameters must be present when instantiating a data object.
  #
  # source://bindata//lib/bindata/params.rb#6
  def mandatory_parameters(*args); end

  # Mutually exclusive parameters may not all be present when
  # instantiating a data object.
  #
  # source://bindata//lib/bindata/params.rb#22
  def mutually_exclusive_parameters(*args); end

  # Optional parameters may be present when instantiating a data object.
  #
  # source://bindata//lib/bindata/params.rb#11
  def optional_parameter(*args); end

  # Optional parameters may be present when instantiating a data object.
  #
  # source://bindata//lib/bindata/params.rb#11
  def optional_parameters(*args); end
end

# BinData objects accept parameters when initializing.  AcceptedParameters
# allow a BinData class to declaratively identify accepted parameters as
# mandatory, optional, default or mutually exclusive.
#
# source://bindata//lib/bindata/params.rb#41
class BinData::AcceptedParametersPlugin::AcceptedParameters
  # @return [AcceptedParameters] a new instance of AcceptedParameters
  #
  # source://bindata//lib/bindata/params.rb#42
  def initialize(ancestor_parameters = T.unsafe(nil)); end

  # source://bindata//lib/bindata/params.rb#94
  def all; end

  # source://bindata//lib/bindata/params.rb#72
  def default(args = T.unsafe(nil)); end

  # source://bindata//lib/bindata/params.rb#56
  def mandatory(*args); end

  # source://bindata//lib/bindata/params.rb#82
  def mutually_exclusive(*args); end

  # source://bindata//lib/bindata/params.rb#64
  def optional(*args); end

  private

  # source://bindata//lib/bindata/params.rb#107
  def ensure_valid_names(names); end

  # source://bindata//lib/bindata/params.rb#101
  def to_syms(args); end

  class << self
    # source://bindata//lib/bindata/params.rb#118
    def invalid_parameter_names; end
  end
end

# An Array is a list of data objects of the same type.
#
#   require 'bindata'
#
#   data = "\x03\x04\x05\x06\x07\x08\x09"
#
#   obj = BinData::Array.new(type: :int8, initial_length: 6)
#   obj.read(data) #=> [3, 4, 5, 6, 7, 8]
#
#   obj = BinData::Array.new(type: :int8,
#                            read_until: -> { index == 1 })
#   obj.read(data) #=> [3, 4]
#
#   obj = BinData::Array.new(type: :int8,
#                            read_until: -> { element >= 6 })
#   obj.read(data) #=> [3, 4, 5, 6]
#
#   obj = BinData::Array.new(type: :int8,
#           read_until: -> { array[index] + array[index - 1] == 13 })
#   obj.read(data) #=> [3, 4, 5, 6, 7]
#
#   obj = BinData::Array.new(type: :int8, read_until: :eof)
#   obj.read(data) #=> [3, 4, 5, 6, 7, 8, 9]
#
# == Parameters
#
# Parameters may be provided at initialisation to control the behaviour of
# an object.  These params are:
#
# <tt>:type</tt>::           The symbol representing the data type of the
#                            array elements.  If the type is to have params
#                            passed to it, then it should be provided as
#                            <tt>[type_symbol, hash_params]</tt>.
# <tt>:initial_length</tt>:: The initial length of the array.
# <tt>:read_until</tt>::     While reading, elements are read until this
#                            condition is true.  This is typically used to
#                            read an array until a sentinel value is found.
#                            The variables +index+, +element+ and +array+
#                            are made available to any lambda assigned to
#                            this parameter.  If the value of this parameter
#                            is the symbol :eof, then the array will read
#                            as much data from the stream as possible.
#
# Each data object in an array has the variable +index+ made available
# to any lambda evaluated as a parameter of that data object.
#
# source://bindata//lib/bindata/array.rb#50
class BinData::Array < ::BinData::Base
  include ::Enumerable
  extend ::BinData::DSLMixin

  # source://bindata//lib/bindata/array.rb#106
  def <<(*args); end

  # Returns the element at +index+.
  #
  # source://bindata//lib/bindata/array.rb#139
  def [](arg1, arg2 = T.unsafe(nil)); end

  # Sets the element at +index+.
  #
  # source://bindata//lib/bindata/array.rb#174
  def []=(index, value); end

  # @raise [ArgumentError]
  #
  # source://bindata//lib/bindata/array.rb#82
  def assign(array); end

  # Returns the element at +index+.  Unlike +slice+, if +index+ is out
  # of range the array will not be automatically extended.
  #
  # source://bindata//lib/bindata/array.rb#169
  def at(index); end

  # @return [Boolean]
  #
  # source://bindata//lib/bindata/array.rb#78
  def clear?; end

  # source://bindata//lib/bindata/array.rb#117
  def concat(array); end

  # source://bindata//lib/bindata/array.rb#223
  def debug_name_of(child); end

  # source://bindata//lib/bindata/array.rb#239
  def do_num_bytes; end

  # source://bindata//lib/bindata/array.rb#235
  def do_write(io); end

  # source://bindata//lib/bindata/array.rb#219
  def each; end

  # @return [Boolean]
  #
  # source://bindata//lib/bindata/array.rb#210
  def empty?; end

  # source://bindata//lib/bindata/array.rb#94
  def find_index(obj); end

  # Returns the first index of +obj+ in self.
  #
  # Uses equal? for the comparator.
  #
  # source://bindata//lib/bindata/array.rb#102
  def find_index_of(obj); end

  # Returns the first element, or the first +n+ elements, of the array.
  # If the array is empty, the first form returns nil, and the second
  # form returns an empty array.
  #
  # source://bindata//lib/bindata/array.rb#182
  def first(n = T.unsafe(nil)); end

  # source://bindata//lib/bindata/array.rb#94
  def index(obj); end

  # source://bindata//lib/bindata/array.rb#74
  def initialize_instance; end

  # source://bindata//lib/bindata/array.rb#61
  def initialize_shared_instance; end

  # source://bindata//lib/bindata/array.rb#122
  def insert(index, *objs); end

  # Returns the last element, or the last +n+ elements, of the array.
  # If the array is empty, the first form returns nil, and the second
  # form returns an empty array.
  #
  # source://bindata//lib/bindata/array.rb#196
  def last(n = T.unsafe(nil)); end

  # source://bindata//lib/bindata/array.rb#205
  def length; end

  # source://bindata//lib/bindata/array.rb#228
  def offset_of(child); end

  # source://bindata//lib/bindata/array.rb#106
  def push(*args); end

  # source://bindata//lib/bindata/array.rb#205
  def size; end

  # Returns the element at +index+.
  #
  # source://bindata//lib/bindata/array.rb#139
  def slice(arg1, arg2 = T.unsafe(nil)); end

  # source://bindata//lib/bindata/array.rb#90
  def snapshot; end

  # Allow this object to be used in array context.
  #
  # source://bindata//lib/bindata/array.rb#215
  def to_ary; end

  # source://bindata//lib/bindata/array.rb#112
  def unshift(*args); end

  private

  # source://bindata//lib/bindata/array.rb#257
  def append_new_element; end

  # source://bindata//lib/bindata/array.rb#253
  def elements; end

  # source://bindata//lib/bindata/array.rb#246
  def extend_array(max_index); end

  # source://bindata//lib/bindata/array.rb#263
  def new_element; end

  # source://bindata//lib/bindata/array.rb#153
  def slice_index(index); end

  # source://bindata//lib/bindata/array.rb#162
  def slice_range(range); end

  # source://bindata//lib/bindata/array.rb#158
  def slice_start_length(start, length); end

  # source://bindata//lib/bindata/array.rb#271
  def sum_num_bytes_below_index(index); end

  # source://bindata//lib/bindata/array.rb#267
  def sum_num_bytes_for_all_elements; end
end

# Logic for the :initial_length parameter
#
# source://bindata//lib/bindata/array.rb#311
module BinData::Array::InitialLengthPlugin
  # source://bindata//lib/bindata/array.rb#312
  def do_read(io); end

  # source://bindata//lib/bindata/array.rb#316
  def elements; end
end

# Logic for the read_until: :eof parameter
#
# source://bindata//lib/bindata/array.rb#296
module BinData::Array::ReadUntilEOFPlugin
  # source://bindata//lib/bindata/array.rb#297
  def do_read(io); end
end

# Logic for the :read_until parameter
#
# source://bindata//lib/bindata/array.rb#284
module BinData::Array::ReadUntilPlugin
  # source://bindata//lib/bindata/array.rb#285
  def do_read(io); end
end

# source://bindata//lib/bindata/array.rb#329
class BinData::ArrayArgProcessor < ::BinData::BaseArgProcessor
  # source://bindata//lib/bindata/array.rb#330
  def sanitize_parameters!(obj_class, params); end
end

# This is the abstract base class for all data objects.
#
# source://bindata//lib/bindata/base.rb#11
class BinData::Base
  include ::BinData::Framework
  include ::BinData::RegisterNamePlugin
  extend ::BinData::AcceptedParametersPlugin

  # source://bindata//lib/bindata/warnings.rb#12
  def initialize(*args); end

  # source://bindata//lib/bindata/base.rb#221
  def ==(other); end

  # Override and delegate =~ as it is defined in Object.
  #
  # source://bindata//lib/bindata/base.rb#201
  def =~(other); end

  # Returns the offset (in bytes) of this object with respect to its most
  # distant ancestor.
  #
  # source://bindata//lib/bindata/base.rb#212
  def abs_offset; end

  def base_respond_to?(*_arg0); end

  # Resets the internal state to that of a newly created object.
  #
  # source://bindata//lib/bindata/base.rb#139
  def clear; end

  # Returns a user friendly name of this object for debugging purposes.
  #
  # source://bindata//lib/bindata/base.rb#206
  def debug_name; end

  # Returns the result of evaluating the parameter identified by +key+.
  #
  # +overrides+ is an optional +parameters+ like hash that allow the
  # parameters given at object construction to be overridden.
  #
  # Returns nil if +key+ does not refer to any parameter.
  #
  # source://bindata//lib/bindata/base.rb#112
  def eval_parameter(key, overrides = T.unsafe(nil)); end

  # Returns the parameter referenced by +key+.
  # Use this method if you are sure the parameter is not to be evaluated.
  # You most likely want #eval_parameter.
  #
  # source://bindata//lib/bindata/base.rb#129
  def get_parameter(key); end

  # Returns whether +key+ exists in the +parameters+ hash.
  #
  # @return [Boolean]
  #
  # source://bindata//lib/bindata/base.rb#134
  def has_parameter?(key); end

  # source://bindata//lib/bindata/warnings.rb#25
  def initialize_instance(*args); end

  # source://bindata//lib/bindata/warnings.rb#12
  def initialize_with_warning(*args); end

  # Return a human readable representation of this data object.
  #
  # source://bindata//lib/bindata/base.rb#186
  def inspect; end

  # Returns a lazy evaluator for this object.
  #
  # source://bindata//lib/bindata/base.rb#122
  def lazy_evaluator; end

  # Creates a new data object based on this instance.
  #
  # This implements the prototype design pattern.
  #
  # All parameters will be be duplicated.  Use this method
  # when creating multiple objects with the same parameters.
  #
  # source://bindata//lib/bindata/base.rb#97
  def new(value = T.unsafe(nil), parent = T.unsafe(nil)); end

  # Returns the number of bytes it will take to write this data object.
  #
  # source://bindata//lib/bindata/base.rb#169
  def num_bytes; end

  # Returns the value of attribute parent.
  #
  # source://bindata//lib/bindata/base.rb#88
  def parent; end

  # Work with Ruby's pretty-printer library.
  #
  # source://bindata//lib/bindata/base.rb#196
  def pretty_print(pp); end

  # Reads data into this data object.
  #
  # source://bindata//lib/bindata/base.rb#144
  def read(io, &block); end

  # Returns the offset (in bytes) of this object with respect to its parent.
  #
  # source://bindata//lib/bindata/base.rb#217
  def rel_offset; end

  # A version of +respond_to?+ used by the lazy evaluator.  It doesn't
  # reinvoke the evaluator so as to avoid infinite evaluation loops.
  #
  # @return [Boolean]
  #
  # source://bindata//lib/bindata/base.rb#228
  def safe_respond_to?(symbol, include_private = T.unsafe(nil)); end

  # Returns the string representation of this data object.
  #
  # source://bindata//lib/bindata/base.rb#174
  def to_binary_s(&block); end

  # Returns the hexadecimal string representation of this data object.
  #
  # source://bindata//lib/bindata/base.rb#181
  def to_hex(&block); end

  # Return a string representing this data object.
  #
  # source://bindata//lib/bindata/base.rb#191
  def to_s; end

  # Writes the value for this data object to +io+.
  #
  # source://bindata//lib/bindata/base.rb#157
  def write(io, &block); end

  protected

  # Sets the attribute parent
  #
  # @param value the value to set the attribute parent to.
  #
  # source://bindata//lib/bindata/base.rb#88
  def parent=(_arg0); end

  private

  # source://bindata//lib/bindata/base.rb#274
  def binary_string(str); end

  # source://bindata//lib/bindata/base.rb#237
  def extract_args(args); end

  # Creates a new data object.
  #
  # Args are optional, but if present, must be in the following order.
  #
  # +value+ is a value that is +assign+ed immediately after initialization.
  #
  # +parameters+ is a hash containing symbol keys.  Some parameters may
  # reference callable objects (methods or procs).
  #
  # +parent+ is the parent data object (e.g. struct, array, choice) this
  # object resides under.
  # Don't override initialize.  If you are defining a new kind of datatype
  # (list, array, choice etc) then put your initialization code in
  # #initialize_instance.  BinData objects might be initialized as prototypes
  # and your initialization code may not be called.
  #
  # If you're subclassing BinData::Record, you are definitely doing the wrong
  # thing.  Read the documentation on how to use BinData.
  # http://github.com/dmendel/bindata/wiki/Records
  #
  # @return [Base] a new instance of Base
  #
  # source://bindata//lib/bindata/base.rb#80
  def initialize_without_warning(*args); end

  # Is this object tree currently being read?  Used by BasePrimitive.
  #
  # @return [Boolean]
  #
  # source://bindata//lib/bindata/base.rb#249
  def reading?; end

  # source://bindata//lib/bindata/base.rb#241
  def start_read; end

  # source://bindata//lib/bindata/base.rb#263
  def top_level; end

  # source://bindata//lib/bindata/base.rb#257
  def top_level_get(sym); end

  # source://bindata//lib/bindata/base.rb#253
  def top_level_set(sym, value); end

  class << self
    # The arg processor for this class.
    #
    # source://bindata//lib/bindata/base.rb#26
    def arg_processor(name = T.unsafe(nil)); end

    # The +auto_call_delayed_io+ keyword sets a data object tree to perform
    # multi pass I/O automatically.
    #
    # source://bindata//lib/bindata/delayed_io.rb#161
    def auto_call_delayed_io; end

    # The name of this class as used by Records, Arrays etc.
    #
    # source://bindata//lib/bindata/base.rb#41
    def bindata_name; end

    # source://bindata//lib/bindata/base.rb#53
    def inherited(subclass); end

    # Instantiates this class and reads from +io+, returning the newly
    # created data object.  +args+ will be used when instantiating.
    #
    # source://bindata//lib/bindata/base.rb#19
    def read(io, *args, &block); end

    private

    # Registers all subclasses of this class for use
    #
    # source://bindata//lib/bindata/base.rb#51
    def register_subclasses; end

    # Call this method if this class is abstract and not to be used.
    #
    # source://bindata//lib/bindata/base.rb#46
    def unregister_self; end
  end
end

# source://bindata//lib/bindata/delayed_io.rb#179
module BinData::Base::AutoCallDelayedIO
  # source://bindata//lib/bindata/delayed_io.rb#180
  def initialize_shared_instance; end

  # source://bindata//lib/bindata/delayed_io.rb#193
  def num_bytes; end

  # source://bindata//lib/bindata/delayed_io.rb#185
  def read(io); end

  # source://bindata//lib/bindata/delayed_io.rb#189
  def write(io, *_); end
end

# ArgProcessors process the arguments passed to BinData::Base.new into
# the form required to initialise the BinData object.
#
# Any passed parameters are sanitized so the BinData object doesn't
# need to perform error checking on the parameters.
#
# source://bindata//lib/bindata/base.rb#284
class BinData::BaseArgProcessor
  # Takes the arguments passed to BinData::Base.new and
  # extracts [value, sanitized_parameters, parent].
  #
  # source://bindata//lib/bindata/base.rb#289
  def extract_args(obj_class, obj_args); end

  # Performs sanity checks on the given parameters.
  # This method converts the parameters to the form expected
  # by the data object.
  #
  # source://bindata//lib/bindata/base.rb#322
  def sanitize_parameters!(obj_class, obj_params); end

  # Separates the arguments passed to BinData::Base.new into
  # [value, parameters, parent].  Called by #extract_args.
  #
  # source://bindata//lib/bindata/base.rb#298
  def separate_args(_obj_class, obj_args); end
end

# A BinData::BasePrimitive object is a container for a value that has a
# particular binary representation.  A value corresponds to a primitive type
# such as as integer, float or string.  Only one value can be contained by
# this object.  This value can be read from or written to an IO stream.
#
#   require 'bindata'
#
#   obj = BinData::Uint8.new(initial_value: 42)
#   obj #=> 42
#   obj.assign(5)
#   obj #=> 5
#   obj.clear
#   obj #=> 42
#
#   obj = BinData::Uint8.new(value: 42)
#   obj #=> 42
#   obj.assign(5)
#   obj #=> 42
#
#   obj = BinData::Uint8.new(assert: 3)
#   obj.read("\005") #=> BinData::ValidityError: value is '5' but expected '3'
#
#   obj = BinData::Uint8.new(assert: -> { value < 5 })
#   obj.read("\007") #=> BinData::ValidityError: value not as expected
#
# == Parameters
#
# Parameters may be provided at initialisation to control the behaviour of
# an object.  These params include those for BinData::Base as well as:
#
# [<tt>:initial_value</tt>]  This is the initial value to use before one is
#                            either #read or explicitly set with #value=.
# [<tt>:value</tt>]          The object will always have this value.
#                            Calls to #value= are ignored when
#                            using this param.  While reading, #value
#                            will return the value of the data read from the
#                            IO, not the result of the <tt>:value</tt> param.
# [<tt>:assert</tt>]         Raise an error unless the value read or assigned
#                            meets this criteria.  The variable +value+ is
#                            made available to any lambda assigned to this
#                            parameter.  A boolean return indicates success
#                            or failure.  Any other return is compared to
#                            the value just read in.
# [<tt>:asserted_value</tt>] Equivalent to <tt>:assert</tt> and <tt>:value</tt>.
#
# source://bindata//lib/bindata/base_primitive.rb#49
class BinData::BasePrimitive < ::BinData::Base
  extend ::BinData::TraceHook

  # source://bindata//lib/bindata/base_primitive.rb#110
  def <=>(other); end

  # @raise [ArgumentError]
  #
  # source://bindata//lib/bindata/base_primitive.rb#72
  def assign(val); end

  # @return [Boolean]
  #
  # source://bindata//lib/bindata/base_primitive.rb#68
  def clear?; end

  # source://bindata//lib/bindata/base_primitive.rb#131
  def do_num_bytes; end

  # source://bindata//lib/bindata/base_primitive.rb#123
  def do_read(io); end

  # source://bindata//lib/bindata/trace.rb#66
  def do_read_with_hook(io); end

  # source://bindata//lib/bindata/base_primitive.rb#127
  def do_write(io); end

  # @return [Boolean]
  #
  # source://bindata//lib/bindata/base_primitive.rb#114
  def eql?(other); end

  # source://bindata//lib/bindata/base_primitive.rb#119
  def hash; end

  # source://bindata//lib/bindata/base_primitive.rb#64
  def initialize_instance; end

  # source://bindata//lib/bindata/base_primitive.rb#56
  def initialize_shared_instance; end

  # source://bindata//lib/bindata/base_primitive.rb#96
  def method_missing(symbol, *args, &block); end

  # source://bindata//lib/bindata/base_primitive.rb#79
  def snapshot; end

  # source://bindata//lib/bindata/base_primitive.rb#83
  def value; end

  # source://bindata//lib/bindata/base_primitive.rb#87
  def value=(val); end

  private

  # The unmodified value of this data object.  Note that #snapshot calls this
  # method.  This indirection is so that #snapshot can be overridden in
  # subclasses to modify the presentation value.
  #
  # source://bindata//lib/bindata/base_primitive.rb#141
  def _value; end

  # Read a number of bytes from +io+ and return the value they represent.
  #
  # @raise [NotImplementedError]
  #
  # source://bindata//lib/bindata/base_primitive.rb#240
  def read_and_return_value(io); end

  # @return [Boolean]
  #
  # source://bindata//lib/bindata/base_primitive.rb#91
  def respond_to_missing?(symbol, include_all = T.unsafe(nil)); end

  # Return a sensible default for this data.
  #
  # @raise [NotImplementedError]
  #
  # source://bindata//lib/bindata/base_primitive.rb#245
  def sensible_default; end

  # Return the string representation that +val+ will take when written.
  #
  # @raise [NotImplementedError]
  #
  # source://bindata//lib/bindata/base_primitive.rb#235
  def value_to_binary_string(val); end

  class << self
    # source://bindata//lib/bindata/alignment.rb#80
    def bit_aligned; end

    # source://bindata//lib/bindata/base.rb#53
    def inherited(subclass); end
  end
end

# Logic for the :assert parameter
#
# source://bindata//lib/bindata/base_primitive.rb#164
module BinData::BasePrimitive::AssertPlugin
  # @raise [ValidityError]
  #
  # source://bindata//lib/bindata/base_primitive.rb#175
  def assert!; end

  # source://bindata//lib/bindata/base_primitive.rb#165
  def assign(val); end

  # source://bindata//lib/bindata/base_primitive.rb#170
  def do_read(io); end
end

# Logic for the :asserted_value parameter
#
# source://bindata//lib/bindata/base_primitive.rb#193
module BinData::BasePrimitive::AssertedValuePlugin
  # source://bindata//lib/bindata/base_primitive.rb#199
  def _value; end

  # source://bindata//lib/bindata/base_primitive.rb#217
  def assert!; end

  # source://bindata//lib/bindata/base_primitive.rb#221
  def assert_value(current_value); end

  # The asserted value as a binary string.
  #
  # Rationale: while reading, +#to_binary_s+ will use the
  # value read in, rather than the +:asserted_value+.
  # This feature is used by Skip.
  #
  # source://bindata//lib/bindata/base_primitive.rb#208
  def asserted_binary_s; end

  # source://bindata//lib/bindata/base_primitive.rb#194
  def assign(val); end

  # source://bindata//lib/bindata/base_primitive.rb#212
  def do_read(io); end
end

# Logic for the :initial_value parameter
#
# source://bindata//lib/bindata/base_primitive.rb#157
module BinData::BasePrimitive::InitialValuePlugin
  # source://bindata//lib/bindata/base_primitive.rb#158
  def _value; end
end

# Logic for the :value parameter
#
# source://bindata//lib/bindata/base_primitive.rb#146
module BinData::BasePrimitive::ValuePlugin
  # source://bindata//lib/bindata/base_primitive.rb#151
  def _value; end

  # source://bindata//lib/bindata/base_primitive.rb#147
  def assign(val); end
end

# source://bindata//lib/bindata/bits.rb#15
class BinData::Bit < ::BinData::BasePrimitive
  def assign(val); end
  def bit_aligned?; end
  def do_num_bytes; end
  def do_write(io); end

  private

  def read_and_return_value(io); end
  def sensible_default; end
end

# A monkey patch to force byte-aligned primitives to
# become bit-aligned.  This allows them to be used at
# non byte based boundaries.
#
#     class BitString < BinData::String
#       bit_aligned
#     end
#
#     class MyRecord < BinData::Record
#       bit4       :preamble
#       bit_string :str, length: 2
#     end
#
# source://bindata//lib/bindata/alignment.rb#43
module BinData::BitAligned
  # @return [Boolean]
  #
  # source://bindata//lib/bindata/alignment.rb#63
  def bit_aligned?; end

  # source://bindata//lib/bindata/alignment.rb#71
  def do_num_bytes; end

  # source://bindata//lib/bindata/alignment.rb#67
  def do_read(io); end

  # source://bindata//lib/bindata/alignment.rb#75
  def do_write(io); end
end

# source://bindata//lib/bindata/alignment.rb#44
class BinData::BitAligned::BitAlignedIO
  # @return [BitAlignedIO] a new instance of BitAlignedIO
  #
  # source://bindata//lib/bindata/alignment.rb#45
  def initialize(io); end

  # source://bindata//lib/bindata/alignment.rb#49
  def binary_string(str); end

  # source://bindata//lib/bindata/alignment.rb#53
  def readbytes(n); end

  # source://bindata//lib/bindata/alignment.rb#58
  def writebytes(str); end
end

# Defines a number of classes that contain a bit based integer.
# The integer is defined by endian and number of bits.
#
# source://bindata//lib/bindata/bits.rb#8
module BinData::BitField
  class << self
    # source://bindata//lib/bindata/bits.rb#92
    def create_clamp_code(nbits, signed); end

    # source://bindata//lib/bindata/bits.rb#84
    def create_do_num_bytes_code(nbits); end

    # source://bindata//lib/bindata/bits.rb#100
    def create_dynamic_clamp_code(signed); end

    # source://bindata//lib/bindata/bits.rb#112
    def create_fixed_clamp_code(nbits, signed); end

    # source://bindata//lib/bindata/bits.rb#135
    def create_int2uint_code(nbits, signed); end

    # source://bindata//lib/bindata/bits.rb#76
    def create_nbits_code(nbits); end

    # source://bindata//lib/bindata/bits.rb#68
    def create_params_code(nbits); end

    # source://bindata//lib/bindata/bits.rb#145
    def create_uint2int_code(nbits, signed); end

    # source://bindata//lib/bindata/bits.rb#12
    def define_class(name, nbits, endian, signed = T.unsafe(nil)); end

    # source://bindata//lib/bindata/bits.rb#26
    def define_methods(bit_class, nbits, endian, signed); end
  end
end

# Create classes on demand
#
# source://bindata//lib/bindata/bits.rb#166
module BinData::BitFieldFactory
  # source://bindata//lib/bindata/bits.rb#167
  def const_missing(name); end
end

# source://bindata//lib/bindata/bits.rb#15
class BinData::BitLe < ::BinData::BasePrimitive
  def assign(val); end
  def bit_aligned?; end
  def do_num_bytes; end
  def do_write(io); end

  private

  def read_and_return_value(io); end
  def sensible_default; end
end

# A Buffer is conceptually a substream within a data stream.  It has a
# defined size and it will always read or write the exact number of bytes to
# fill the buffer.  Short reads will skip over unused bytes and short writes
# will pad the substream with "\0" bytes.
#
#   require 'bindata'
#
#   obj = BinData::Buffer.new(length: 5, type: [:string, {value: "abc"}])
#   obj.to_binary_s #=> "abc\000\000"
#
#
#   class MyBuffer < BinData::Buffer
#     default_parameter length: 8
#
#     endian :little
#
#     uint16 :num1
#     uint16 :num2
#     # padding occurs here
#   end
#
#   obj = MyBuffer.read("\001\000\002\000\000\000\000\000")
#   obj.num1 #=> 1
#   obj.num1 #=> 2
#   obj.raw_num_bytes #=> 4
#   obj.num_bytes #=> 8
#
#
#   class StringTable < BinData::Record
#     endian :little
#
#     uint16 :table_size_in_bytes
#     buffer :strings, length: :table_size_in_bytes do
#       array read_until: :eof do
#         uint8 :len
#         string :str, length: :len
#       end
#     end
#   end
#
#
# == Parameters
#
# Parameters may be provided at initialisation to control the behaviour of
# an object.  These params are:
#
# <tt>:length</tt>::   The number of bytes in the buffer.
# <tt>:type</tt>::     The single type inside the buffer.  Use a struct if
#                      multiple fields are required.
#
# source://bindata//lib/bindata/buffer.rb#54
class BinData::Buffer < ::BinData::Base
  extend ::BinData::DSLMixin

  # source://bindata//lib/bindata/buffer.rb#75
  def assign(val); end

  # @return [Boolean]
  #
  # source://bindata//lib/bindata/buffer.rb#71
  def clear?; end

  # source://bindata//lib/bindata/buffer.rb#105
  def do_num_bytes; end

  # source://bindata//lib/bindata/buffer.rb#91
  def do_read(io); end

  # source://bindata//lib/bindata/buffer.rb#98
  def do_write(io); end

  # source://bindata//lib/bindata/buffer.rb#62
  def initialize_instance; end

  # source://bindata//lib/bindata/buffer.rb#87
  def method_missing(symbol, *args, &block); end

  # The number of bytes used, ignoring the padding imposed by the buffer.
  #
  # source://bindata//lib/bindata/buffer.rb#67
  def raw_num_bytes; end

  # source://bindata//lib/bindata/buffer.rb#79
  def snapshot; end

  private

  # @return [Boolean]
  #
  # source://bindata//lib/bindata/buffer.rb#83
  def respond_to_missing?(symbol, include_all = T.unsafe(nil)); end
end

# Transforms the IO stream to restrict access inside
# a buffer of specified length.
#
# source://bindata//lib/bindata/buffer.rb#111
class BinData::Buffer::BufferIO < ::BinData::IO::Transform
  # @return [BufferIO] a new instance of BufferIO
  #
  # source://bindata//lib/bindata/buffer.rb#112
  def initialize(length); end

  # source://bindata//lib/bindata/buffer.rb#161
  def after_read_transform; end

  # source://bindata//lib/bindata/buffer.rb#165
  def after_write_transform; end

  # source://bindata//lib/bindata/buffer.rb#117
  def before_transform; end

  # source://bindata//lib/bindata/buffer.rb#169
  def buffer_limited_n(n); end

  # source://bindata//lib/bindata/buffer.rb#122
  def num_bytes_remaining; end

  # source://bindata//lib/bindata/buffer.rb#144
  def read(n); end

  # source://bindata//lib/bindata/buffer.rb#135
  def seek_abs(n); end

  # source://bindata//lib/bindata/buffer.rb#128
  def skip(n); end

  # source://bindata//lib/bindata/buffer.rb#151
  def write(data); end
end

# source://bindata//lib/bindata/buffer.rb#186
class BinData::BufferArgProcessor < ::BinData::BaseArgProcessor
  include ::BinData::MultiFieldArgSeparator

  # source://bindata//lib/bindata/buffer.rb#189
  def sanitize_parameters!(obj_class, params); end
end

# A Choice is a collection of data objects of which only one is active
# at any particular time.  Method calls will be delegated to the active
# choice.
#
#   require 'bindata'
#
#   type1 = [:string, {value: "Type1"}]
#   type2 = [:string, {value: "Type2"}]
#
#   choices = {5 => type1, 17 => type2}
#   a = BinData::Choice.new(choices: choices, selection: 5)
#   a # => "Type1"
#
#   choices = [ type1, type2 ]
#   a = BinData::Choice.new(choices: choices, selection: 1)
#   a # => "Type2"
#
#   choices = [ nil, nil, nil, type1, nil, type2 ]
#   a = BinData::Choice.new(choices: choices, selection: 3)
#   a # => "Type1"
#
#
#   Chooser = Struct.new(:choice)
#   mychoice = Chooser.new
#   mychoice.choice = 'big'
#
#   choices = {'big' => :uint16be, 'little' => :uint16le}
#   a = BinData::Choice.new(choices: choices, copy_on_change: true,
#                           selection: -> { mychoice.choice })
#   a.assign(256)
#   a.to_binary_s #=> "\001\000"
#
#   mychoice.choice = 'little'
#   a.to_binary_s #=> "\000\001"
#
# == Parameters
#
# Parameters may be provided at initialisation to control the behaviour of
# an object.  These params are:
#
# <tt>:choices</tt>::        Either an array or a hash specifying the possible
#                            data objects.  The format of the
#                            array/hash.values is a list of symbols
#                            representing the data object type.  If a choice
#                            is to have params passed to it, then it should
#                            be provided as [type_symbol, hash_params].  An
#                            implementation constraint is that the hash may
#                            not contain symbols as keys, with the exception
#                            of :default.  :default is to be used when then
#                            :selection does not exist in the :choices hash.
# <tt>:selection</tt>::      An index/key into the :choices array/hash which
#                            specifies the currently active choice.
# <tt>:copy_on_change</tt>:: If set to true, copy the value of the previous
#                            selection to the current selection whenever the
#                            selection changes.  Default is false.
#
# source://bindata//lib/bindata/choice.rb#60
class BinData::Choice < ::BinData::Base
  extend ::BinData::DSLMixin
  extend ::BinData::TraceHook

  def assign(*args); end
  def clear?(*args); end
  def do_num_bytes(*args); end
  def do_read(*args); end

  # source://bindata//lib/bindata/trace.rb#79
  def do_read_with_hook(io); end

  def do_write(*args); end

  # source://bindata//lib/bindata/choice.rb#74
  def initialize_instance; end

  # source://bindata//lib/bindata/choice.rb#69
  def initialize_shared_instance; end

  # source://bindata//lib/bindata/choice.rb#93
  def method_missing(symbol, *args, &block); end

  # @return [Boolean]
  #
  # source://bindata//lib/bindata/choice.rb#89
  def respond_to?(symbol, include_all = T.unsafe(nil)); end

  # Returns the current selection.
  #
  # source://bindata//lib/bindata/choice.rb#80
  def selection; end

  def snapshot(*args); end

  private

  # source://bindata//lib/bindata/choice.rb#108
  def current_choice; end

  # source://bindata//lib/bindata/choice.rb#113
  def instantiate_choice(selection); end
end

# source://bindata//lib/bindata/choice.rb#124
class BinData::ChoiceArgProcessor < ::BinData::BaseArgProcessor
  # source://bindata//lib/bindata/choice.rb#125
  def sanitize_parameters!(obj_class, params); end

  private

  # source://bindata//lib/bindata/choice.rb#138
  def choices_as_hash(choices); end

  # source://bindata//lib/bindata/choice.rb#154
  def ensure_valid_keys(choices); end

  # source://bindata//lib/bindata/choice.rb#146
  def key_array_by_index(array); end
end

# Logic for the :copy_on_change parameter
#
# source://bindata//lib/bindata/choice.rb#165
module BinData::CopyOnChangePlugin
  # source://bindata//lib/bindata/choice.rb#172
  def copy_previous_value(obj); end

  # source://bindata//lib/bindata/choice.rb#166
  def current_choice; end

  # source://bindata//lib/bindata/choice.rb#179
  def get_previous_choice(selection); end

  # source://bindata//lib/bindata/choice.rb#185
  def remember_current_selection(selection); end
end

# Counts the number of bytes remaining in the input stream from the current
# position to the end of the stream.  This only makes sense for seekable
# streams.
#
#   require 'bindata'
#
#   class A < BinData::Record
#     count_bytes_remaining :bytes_remaining
#     string :all_data, read_length: :bytes_remaining
#   end
#
#   obj = A.read("abcdefghij")
#   obj.all_data #=> "abcdefghij"
#
# source://bindata//lib/bindata/count_bytes_remaining.rb#19
class BinData::CountBytesRemaining < ::BinData::BasePrimitive
  private

  # source://bindata//lib/bindata/count_bytes_remaining.rb#26
  def read_and_return_value(io); end

  # source://bindata//lib/bindata/count_bytes_remaining.rb#30
  def sensible_default; end

  # source://bindata//lib/bindata/count_bytes_remaining.rb#22
  def value_to_binary_string(val); end
end

# BinData classes that are part of the DSL must be extended by this.
#
# source://bindata//lib/bindata/dsl.rb#37
module BinData::DSLMixin
  # source://bindata//lib/bindata/dsl.rb#38
  def dsl_parser(parser_type = T.unsafe(nil)); end

  # source://bindata//lib/bindata/dsl.rb#45
  def method_missing(symbol, *args, &block); end

  # Assert object is not an array or string.
  #
  # source://bindata//lib/bindata/dsl.rb#50
  def to_ary; end

  # source://bindata//lib/bindata/dsl.rb#51
  def to_str; end
end

# Handles the :big_and_little endian option.
# This option creates two subclasses, each handling
# :big or :little endian.
#
# source://bindata//lib/bindata/dsl.rb#256
class BinData::DSLMixin::DSLBigAndLittleEndianHandler
  class << self
    # source://bindata//lib/bindata/dsl.rb#324
    def class_with_endian(class_name, endian); end

    # source://bindata//lib/bindata/dsl.rb#270
    def create_subclasses_with_endian(bnl_class); end

    # source://bindata//lib/bindata/dsl.rb#291
    def delegate_field_creation(bnl_class); end

    # source://bindata//lib/bindata/dsl.rb#304
    def fixup_subclass_hierarchy(bnl_class); end

    # source://bindata//lib/bindata/dsl.rb#258
    def handle(bnl_class); end

    # source://bindata//lib/bindata/dsl.rb#266
    def make_class_abstract(bnl_class); end

    # source://bindata//lib/bindata/dsl.rb#332
    def obj_attribute(obj, attr); end

    # source://bindata//lib/bindata/dsl.rb#275
    def override_new_in_class(bnl_class); end
  end
end

# Extracts the details from a field declaration.
#
# source://bindata//lib/bindata/dsl.rb#339
class BinData::DSLMixin::DSLFieldParser
  # @return [DSLFieldParser] a new instance of DSLFieldParser
  #
  # source://bindata//lib/bindata/dsl.rb#340
  def initialize(hints, symbol, *args, &block); end

  # Returns the value of attribute name.
  #
  # source://bindata//lib/bindata/dsl.rb#347
  def name; end

  # source://bindata//lib/bindata/dsl.rb#349
  def name_from_field_declaration(args); end

  # Returns the value of attribute params.
  #
  # source://bindata//lib/bindata/dsl.rb#347
  def params; end

  # source://bindata//lib/bindata/dsl.rb#368
  def params_from_args(args); end

  # source://bindata//lib/bindata/dsl.rb#375
  def params_from_block(&block); end

  # source://bindata//lib/bindata/dsl.rb#358
  def params_from_field_declaration(args, &block); end

  # Returns the value of attribute type.
  #
  # source://bindata//lib/bindata/dsl.rb#347
  def type; end
end

# Validates a field defined in a DSLMixin.
#
# source://bindata//lib/bindata/dsl.rb#400
class BinData::DSLMixin::DSLFieldValidator
  # @return [DSLFieldValidator] a new instance of DSLFieldValidator
  #
  # source://bindata//lib/bindata/dsl.rb#401
  def initialize(the_class, parser); end

  # @return [Boolean]
  #
  # source://bindata//lib/bindata/dsl.rb#450
  def all_or_none_names_failed?(name); end

  # @return [Boolean]
  #
  # source://bindata//lib/bindata/dsl.rb#465
  def duplicate_name?(name); end

  # source://bindata//lib/bindata/dsl.rb#422
  def ensure_valid_name(name); end

  # source://bindata//lib/bindata/dsl.rb#477
  def fields; end

  # @return [Boolean]
  #
  # source://bindata//lib/bindata/dsl.rb#461
  def malformed_name?(name); end

  # @return [Boolean]
  #
  # source://bindata//lib/bindata/dsl.rb#446
  def must_have_a_name_failed?(name); end

  # @return [Boolean]
  #
  # source://bindata//lib/bindata/dsl.rb#442
  def must_not_have_a_name_failed?(name); end

  # @return [Boolean]
  #
  # source://bindata//lib/bindata/dsl.rb#473
  def name_is_reserved?(name); end

  # @return [Boolean]
  #
  # source://bindata//lib/bindata/dsl.rb#469
  def name_shadows_method?(name); end

  # @return [Boolean]
  #
  # source://bindata//lib/bindata/dsl.rb#481
  def option?(opt); end

  # source://bindata//lib/bindata/dsl.rb#406
  def validate_field(name); end
end

# A DSLParser parses and accumulates field definitions of the form
#
#   type name, params
#
# where:
#   * +type+ is the under_scored name of a registered type
#   * +name+ is the (possible optional) name of the field
#   * +params+ is a hash containing any parameters
#
# source://bindata//lib/bindata/dsl.rb#62
class BinData::DSLMixin::DSLParser
  # @return [DSLParser] a new instance of DSLParser
  #
  # source://bindata//lib/bindata/dsl.rb#63
  def initialize(the_class, parser_type); end

  # source://bindata//lib/bindata/dsl.rb#113
  def dsl_params; end

  # source://bindata//lib/bindata/dsl.rb#74
  def endian(endian = T.unsafe(nil)); end

  # source://bindata//lib/bindata/dsl.rb#109
  def fields; end

  # source://bindata//lib/bindata/dsl.rb#98
  def hide(*args); end

  # source://bindata//lib/bindata/dsl.rb#118
  def method_missing(*args, &block); end

  # Returns the value of attribute parser_type.
  #
  # source://bindata//lib/bindata/dsl.rb#72
  def parser_type; end

  # source://bindata//lib/bindata/dsl.rb#83
  def search_prefix(*args); end

  private

  # source://bindata//lib/bindata/dsl.rb#191
  def append_field(type, name, params); end

  # @raise [exception]
  #
  # source://bindata//lib/bindata/dsl.rb#207
  def dsl_raise(exception, msg); end

  # source://bindata//lib/bindata/dsl.rb#143
  def ensure_hints; end

  # @return [Boolean]
  #
  # source://bindata//lib/bindata/dsl.rb#177
  def fields?; end

  # source://bindata//lib/bindata/dsl.rb#148
  def hints; end

  # @return [Boolean]
  #
  # source://bindata//lib/bindata/dsl.rb#139
  def option?(opt); end

  # source://bindata//lib/bindata/dsl.rb#197
  def parent_attribute(attr, default = T.unsafe(nil)); end

  # source://bindata//lib/bindata/dsl.rb#173
  def parent_fields; end

  # source://bindata//lib/bindata/dsl.rb#181
  def parse_and_append_field(*args, &block); end

  # source://bindata//lib/bindata/dsl.rb#126
  def parser_abilities; end

  # source://bindata//lib/bindata/dsl.rb#152
  def set_endian(endian); end

  # source://bindata//lib/bindata/dsl.rb#225
  def to_choice_params(key); end

  # source://bindata//lib/bindata/dsl.rb#214
  def to_object_params(key); end

  # source://bindata//lib/bindata/dsl.rb#237
  def to_struct_params(*_); end

  # @return [Boolean]
  #
  # source://bindata//lib/bindata/dsl.rb#169
  def valid_endian?(endian); end
end

# BinData declarations are evaluated in a single pass.
# However, some binary formats require multi pass processing.  A common
# reason is seeking backwards in the input stream.
#
# DelayedIO supports multi pass processing.  It works by ignoring the normal
# #read or #write calls.  The user must explicitly call the #read_now! or
# #write_now! methods to process an additional pass.  This additional pass
# must specify the abs_offset of the I/O operation.
#
#   require 'bindata'
#
#   obj = BinData::DelayedIO.new(read_abs_offset: 3, type: :uint16be)
#   obj.read("\x00\x00\x00\x11\x12")
#   obj #=> 0
#
#   obj.read_now!
#   obj #=> 0x1112
#
#   - OR -
#
#   obj.read("\x00\x00\x00\x11\x12") { obj.read_now! } #=> 0x1122
#
#   obj.to_binary_s { obj.write_now! } #=> "\x00\x00\x00\x11\x12"
#
# You can use the +auto_call_delayed_io+ keyword to cause #read and #write to
# automatically perform the extra passes.
#
#   class ReversePascalString < BinData::Record
#     auto_call_delayed_io
#
#     delayed_io :str, read_abs_offset: 0 do
#       string read_length: :len
#     end
#     count_bytes_remaining :total_size
#     skip to_abs_offset: -> { total_size - 1 }
#     uint8  :len, value: -> { str.length }
#   end
#
#   s = ReversePascalString.read("hello\x05")
#   s.to_binary_s #=> "hello\x05"
#
#
# == Parameters
#
# Parameters may be provided at initialisation to control the behaviour of
# an object.  These params are:
#
# <tt>:read_abs_offset</tt>::   The abs_offset to start reading at.
# <tt>:type</tt>::              The single type inside the delayed io.  Use
#                               a struct if multiple fields are required.
#
# source://bindata//lib/bindata/delayed_io.rb#55
class BinData::DelayedIO < ::BinData::Base
  extend ::BinData::DSLMixin

  # source://bindata//lib/bindata/delayed_io.rb#94
  def abs_offset; end

  # Sets the +abs_offset+ to use when writing this object.
  #
  # source://bindata//lib/bindata/delayed_io.rb#99
  def abs_offset=(offset); end

  # source://bindata//lib/bindata/delayed_io.rb#74
  def assign(val); end

  # @return [Boolean]
  #
  # source://bindata//lib/bindata/delayed_io.rb#70
  def clear?; end

  # source://bindata//lib/bindata/delayed_io.rb#115
  def do_num_bytes; end

  # source://bindata//lib/bindata/delayed_io.rb#107
  def do_read(io); end

  # source://bindata//lib/bindata/delayed_io.rb#111
  def do_write(io); end

  # @return [Boolean]
  #
  # source://bindata//lib/bindata/delayed_io.rb#119
  def include_obj?; end

  # source://bindata//lib/bindata/delayed_io.rb#63
  def initialize_instance; end

  # source://bindata//lib/bindata/delayed_io.rb#90
  def method_missing(symbol, *args, &block); end

  # source://bindata//lib/bindata/delayed_io.rb#82
  def num_bytes; end

  # DelayedIO objects aren't read when #read is called.
  # The reading is delayed until this method is called.
  #
  # @raise [IOError]
  #
  # source://bindata//lib/bindata/delayed_io.rb#125
  def read_now!; end

  # source://bindata//lib/bindata/delayed_io.rb#103
  def rel_offset; end

  # source://bindata//lib/bindata/delayed_io.rb#78
  def snapshot; end

  # DelayedIO objects aren't written when #write is called.
  # The writing is delayed until this method is called.
  #
  # @raise [IOError]
  #
  # source://bindata//lib/bindata/delayed_io.rb#137
  def write_now!; end

  private

  # @return [Boolean]
  #
  # source://bindata//lib/bindata/delayed_io.rb#86
  def respond_to_missing?(symbol, include_all = T.unsafe(nil)); end
end

# source://bindata//lib/bindata/delayed_io.rb#146
class BinData::DelayedIoArgProcessor < ::BinData::BaseArgProcessor
  include ::BinData::MultiFieldArgSeparator

  # source://bindata//lib/bindata/delayed_io.rb#149
  def sanitize_parameters!(obj_class, params); end
end

# Double precision floating point number in big endian format
#
# source://bindata//lib/bindata/float.rb#80
class BinData::DoubleBe < ::BinData::BasePrimitive
  def do_num_bytes; end

  private

  def read_and_return_value(io); end
  def sensible_default; end
  def value_to_binary_string(val); end
end

# Double precision floating point number in little endian format
#
# source://bindata//lib/bindata/float.rb#75
class BinData::DoubleLe < ::BinData::BasePrimitive
  def do_num_bytes; end

  private

  def read_and_return_value(io); end
  def sensible_default; end
  def value_to_binary_string(val); end
end

# Single precision floating point number in big endian format
#
# source://bindata//lib/bindata/float.rb#70
class BinData::FloatBe < ::BinData::BasePrimitive
  def do_num_bytes; end

  private

  def read_and_return_value(io); end
  def sensible_default; end
  def value_to_binary_string(val); end
end

# Single precision floating point number in little endian format
#
# source://bindata//lib/bindata/float.rb#65
class BinData::FloatLe < ::BinData::BasePrimitive
  def do_num_bytes; end

  private

  def read_and_return_value(io); end
  def sensible_default; end
  def value_to_binary_string(val); end
end

# Defines a number of classes that contain a floating point number.
# The float is defined by precision and endian.
#
# source://bindata//lib/bindata/float.rb#7
module BinData::FloatingPoint
  class << self
    # source://bindata//lib/bindata/float.rb#44
    def create_num_bytes_code(precision); end

    # source://bindata//lib/bindata/float.rb#48
    def create_read_code(precision, endian); end

    # source://bindata//lib/bindata/float.rb#55
    def create_to_binary_s_code(precision, endian); end

    # source://bindata//lib/bindata/float.rb#21
    def define_methods(float_class, precision, endian); end
  end
end

# All methods provided by the framework are to be implemented or overridden
# by subclasses of BinData::Base.
#
# source://bindata//lib/bindata/framework.rb#7
module BinData::Framework
  # Assigns the value of +val+ to this data object.  Note that +val+ must
  # always be deep copied to ensure no aliasing problems can occur.
  #
  # @raise [NotImplementedError]
  #
  # source://bindata//lib/bindata/framework.rb#27
  def assign(val); end

  # Is this object aligned on non-byte boundaries?
  #
  # @return [Boolean]
  #
  # source://bindata//lib/bindata/framework.rb#49
  def bit_aligned?; end

  # Returns true if the object has not been changed since creation.
  #
  # @raise [NotImplementedError]
  # @return [Boolean]
  #
  # source://bindata//lib/bindata/framework.rb#21
  def clear?; end

  # Returns the debug name of +child+.  This only needs to be implemented
  # by objects that contain child objects.
  #
  # source://bindata//lib/bindata/framework.rb#38
  def debug_name_of(child); end

  # Returns the offset of +child+.  This only needs to be implemented
  # by objects that contain child objects.
  #
  # source://bindata//lib/bindata/framework.rb#44
  def offset_of(child); end

  # Returns a snapshot of this data object.
  #
  # @raise [NotImplementedError]
  #
  # source://bindata//lib/bindata/framework.rb#32
  def snapshot; end

  protected

  # Returns the number of bytes it will take to write this data.
  #
  # @raise [NotImplementedError]
  #
  # source://bindata//lib/bindata/framework.rb#64
  def do_num_bytes; end

  # Reads the data for this data object from +io+.
  #
  # @raise [NotImplementedError]
  #
  # source://bindata//lib/bindata/framework.rb#54
  def do_read(io); end

  # Writes the value for this data to +io+.
  #
  # @raise [NotImplementedError]
  #
  # source://bindata//lib/bindata/framework.rb#59
  def do_write(io); end

  # Initializes the state of the object.  All instance variables that
  # are used by the object must be initialized here.
  #
  # source://bindata//lib/bindata/framework.rb#10
  def initialize_instance; end

  # Initialises state that is shared by objects with the same parameters.
  #
  # This should only be used when optimising for performance.  Instance
  # variables set here, and changes to the singleton class will be shared
  # between all objects that are initialized with the same parameters.
  # This method is called only once for a particular set of parameters.
  #
  # source://bindata//lib/bindata/framework.rb#18
  def initialize_shared_instance; end
end

# A wrapper around an IO object.  The wrapper provides a consistent
# interface for BinData objects to use when accessing the IO.
#
# source://bindata//lib/bindata/io.rb#6
module BinData::IO
  class << self
    # Creates a StringIO around +str+.
    #
    # source://bindata//lib/bindata/io.rb#9
    def create_string_io(str = T.unsafe(nil)); end
  end
end

# API used to access the raw data stream.
#
# source://bindata//lib/bindata/io.rb#315
class BinData::IO::RawIO
  # @return [RawIO] a new instance of RawIO
  #
  # source://bindata//lib/bindata/io.rb#316
  def initialize(io); end

  # @return [Boolean]
  #
  # source://bindata//lib/bindata/io.rb#327
  def is_seekable?(io); end

  # source://bindata//lib/bindata/io.rb#337
  def num_bytes_remaining; end

  # source://bindata//lib/bindata/io.rb#346
  def offset; end

  # source://bindata//lib/bindata/io.rb#361
  def read(n); end

  # source://bindata//lib/bindata/io.rb#356
  def seek_abs(n); end

  # @return [Boolean]
  #
  # source://bindata//lib/bindata/io.rb#333
  def seekable?; end

  # @raise [IOError]
  #
  # source://bindata//lib/bindata/io.rb#350
  def skip(n); end

  # source://bindata//lib/bindata/io.rb#365
  def write(data); end
end

# Create a new IO Read wrapper around +io+.  +io+ must provide #read,
# #pos if reading the current stream position and #seek if setting the
# current stream position.  If +io+ is a string it will be automatically
# wrapped in an StringIO object.
#
# The IO can handle bitstreams in either big or little endian format.
#
#      M  byte1   L      M  byte2   L
#      S 76543210 S      S fedcba98 S
#      B          B      B          B
#
# In big endian format:
#   readbits(6), readbits(5) #=> [765432, 10fed]
#
# In little endian format:
#   readbits(6), readbits(5) #=> [543210, a9876]
#
# source://bindata//lib/bindata/io.rb#31
class BinData::IO::Read
  # @return [Read] a new instance of Read
  #
  # source://bindata//lib/bindata/io.rb#32
  def initialize(io); end

  # The number of bytes remaining in the io steam.
  #
  # source://bindata//lib/bindata/io.rb#68
  def num_bytes_remaining; end

  # Reads all remaining bytes from the stream.
  #
  # source://bindata//lib/bindata/io.rb#95
  def read_all_bytes; end

  # Reads exactly +nbits+ bits from the stream. +endian+ specifies whether
  # the bits are stored in +:big+ or +:little+ endian format.
  #
  # source://bindata//lib/bindata/io.rb#102
  def readbits(nbits, endian); end

  # Reads exactly +n+ bytes from +io+.
  #
  # If the data read is nil an EOFError is raised.
  #
  # If the data read is too short an IOError is raised.
  #
  # source://bindata//lib/bindata/io.rb#89
  def readbytes(n); end

  # Discards any read bits so the stream becomes aligned at the
  # next byte boundary.
  #
  # source://bindata//lib/bindata/io.rb#118
  def reset_read_bits; end

  # Seek to an absolute offset within the io stream.
  #
  # source://bindata//lib/bindata/io.rb#79
  def seek_to_abs_offset(n); end

  # Seek +n+ bytes from the current position in the io stream.
  #
  # source://bindata//lib/bindata/io.rb#73
  def skipbytes(n); end

  # Allow transforming data in the input stream.
  # See +BinData::Buffer+ as an example.
  #
  # +io+ must be an instance of +Transform+.
  #
  # yields +self+ and +io+ to the given block
  #
  # source://bindata//lib/bindata/io.rb#56
  def transform(io); end

  private

  # source://bindata//lib/bindata/io.rb#147
  def accumulate_big_endian_bits; end

  # source://bindata//lib/bindata/io.rb#165
  def accumulate_little_endian_bits; end

  # source://bindata//lib/bindata/io.rb#171
  def mask(nbits); end

  # source://bindata//lib/bindata/io.rb#126
  def read(n = T.unsafe(nil)); end

  # source://bindata//lib/bindata/io.rb#135
  def read_big_endian_bits(nbits); end

  # source://bindata//lib/bindata/io.rb#153
  def read_little_endian_bits(nbits); end
end

# An IO stream may be transformed before processing.
# e.g. encoding, compression, buffered.
#
# Multiple transforms can be chained together.
#
# To create a new transform layer, subclass +Transform+.
# Override the public methods +#read+ and +#write+ at a minimum.
# Additionally the hook, +#before_transform+, +#after_read_transform+
# and +#after_write_transform+ are available as well.
#
# IMPORTANT!  If your transform changes the size of the underlying
# data stream (e.g. compression), then call
# +::transform_changes_stream_length!+ in your subclass.
#
# source://bindata//lib/bindata/io.rb#383
class BinData::IO::Transform
  # @return [Transform] a new instance of Transform
  #
  # source://bindata//lib/bindata/io.rb#392
  def initialize; end

  # Flushes the input stream.
  #
  # Called after the final read operation.
  #
  # source://bindata//lib/bindata/io.rb#404
  def after_read_transform; end

  # Flushes the output stream.
  #
  # Called after the final write operation.
  #
  # source://bindata//lib/bindata/io.rb#409
  def after_write_transform; end

  # Initialises this transform.
  #
  # Called before any IO operations.
  #
  # source://bindata//lib/bindata/io.rb#399
  def before_transform; end

  # How many bytes are available for reading?
  #
  # source://bindata//lib/bindata/io.rb#426
  def num_bytes_remaining; end

  # The current offset within the stream.
  #
  # source://bindata//lib/bindata/io.rb#431
  def offset; end

  # Prepends this transform to the given +chain+.
  #
  # Returns self (the new head of chain).
  #
  # source://bindata//lib/bindata/io.rb#414
  def prepend_to_chain(chain); end

  # Reads +n+ bytes from the stream.
  #
  # source://bindata//lib/bindata/io.rb#446
  def read(n); end

  # Seeks to the given absolute position.
  #
  # source://bindata//lib/bindata/io.rb#441
  def seek_abs(n); end

  # Is the IO seekable?
  #
  # @return [Boolean]
  #
  # source://bindata//lib/bindata/io.rb#421
  def seekable?; end

  # Skips forward +n+ bytes in the input stream.
  #
  # source://bindata//lib/bindata/io.rb#436
  def skip(n); end

  # Writes +data+ to the stream.
  #
  # source://bindata//lib/bindata/io.rb#451
  def write(data); end

  private

  # source://bindata//lib/bindata/io.rb#466
  def chain_num_bytes_remaining; end

  # source://bindata//lib/bindata/io.rb#470
  def chain_offset; end

  # source://bindata//lib/bindata/io.rb#482
  def chain_read(n); end

  # source://bindata//lib/bindata/io.rb#478
  def chain_seek_abs(n); end

  # @return [Boolean]
  #
  # source://bindata//lib/bindata/io.rb#462
  def chain_seekable?; end

  # source://bindata//lib/bindata/io.rb#474
  def chain_skip(n); end

  # source://bindata//lib/bindata/io.rb#486
  def chain_write(data); end

  # source://bindata//lib/bindata/io.rb#458
  def create_empty_binary_string; end

  class << self
    # Indicates that this transform changes the length of the
    # underlying data. e.g. performs compression or error correction
    #
    # source://bindata//lib/bindata/io.rb#387
    def transform_changes_stream_length!; end
  end
end

# A module to be prepended to +RawIO+ or +Transform+ when the data
# stream is not seekable.  This is either due to underlying stream
# being unseekable or the transform changes the number of bytes.
#
# source://bindata//lib/bindata/io.rb#494
module BinData::IO::UnSeekableIO
  # @raise [IOError]
  #
  # source://bindata//lib/bindata/io.rb#499
  def num_bytes_remaining; end

  # source://bindata//lib/bindata/io.rb#514
  def seek_abs(n); end

  # @return [Boolean]
  #
  # source://bindata//lib/bindata/io.rb#495
  def seekable?; end

  # @raise [IOError]
  #
  # source://bindata//lib/bindata/io.rb#503
  def skip(n); end
end

# Create a new IO Write wrapper around +io+.  +io+ must provide #write.
# If +io+ is a string it will be automatically wrapped in an StringIO
# object.
#
# The IO can handle bitstreams in either big or little endian format.
#
# See IO::Read for more information.
#
# source://bindata//lib/bindata/io.rb#183
class BinData::IO::Write
  # @return [Write] a new instance of Write
  #
  # source://bindata//lib/bindata/io.rb#184
  def initialize(io); end

  # To be called after all +writebits+ have been applied.
  #
  # source://bindata//lib/bindata/io.rb#251
  def flush; end

  # To be called after all +writebits+ have been applied.
  #
  # source://bindata//lib/bindata/io.rb#251
  def flushbits; end

  # Seek to an absolute offset within the io stream.
  #
  # @raise [IOError]
  #
  # source://bindata//lib/bindata/io.rb#219
  def seek_to_abs_offset(n); end

  # Allow transforming data in the output stream.
  # See +BinData::Buffer+ as an example.
  #
  # +io+ must be an instance of +Transform+.
  #
  # yields +self+ and +io+ to the given block
  #
  # source://bindata//lib/bindata/io.rb#207
  def transform(io); end

  # Writes +nbits+ bits from +val+ to the stream. +endian+ specifies whether
  # the bits are to be stored in +:big+ or +:little+ endian format.
  #
  # source://bindata//lib/bindata/io.rb#234
  def writebits(val, nbits, endian); end

  # Writes the given string of bytes to the io stream.
  #
  # source://bindata//lib/bindata/io.rb#227
  def writebytes(str); end

  private

  # source://bindata//lib/bindata/io.rb#309
  def mask(nbits); end

  # source://bindata//lib/bindata/io.rb#263
  def write(data); end

  # source://bindata//lib/bindata/io.rb#267
  def write_big_endian_bits(val, nbits); end

  # source://bindata//lib/bindata/io.rb#288
  def write_little_endian_bits(val, nbits); end
end

# Defines a number of classes that contain an integer.  The integer
# is defined by endian, signedness and number of bytes.
#
# source://bindata//lib/bindata/int.rb#8
module BinData::Int
  class << self
    # source://bindata//lib/bindata/int.rb#12
    def define_class(name, nbits, endian, signed); end

    # source://bindata//lib/bindata/int.rb#26
    def define_methods(int_class, nbits, endian, signed); end

    private

    # source://bindata//lib/bindata/int.rb#150
    def bits_per_word(nbits); end

    # source://bindata//lib/bindata/int.rb#60
    def create_clamp_code(nbits, signed); end

    # source://bindata//lib/bindata/int.rb#142
    def create_int2uint_code(nbits); end

    # source://bindata//lib/bindata/int.rb#82
    def create_raw_read_code(nbits, endian, signed); end

    # source://bindata//lib/bindata/int.rb#101
    def create_read_assemble_code(nbits, endian); end

    # source://bindata//lib/bindata/int.rb#72
    def create_read_code(nbits, endian, signed); end

    # source://bindata//lib/bindata/int.rb#94
    def create_read_unpack_code(nbits, endian, signed); end

    # source://bindata//lib/bindata/int.rb#115
    def create_to_binary_s_code(nbits, endian, signed); end

    # source://bindata//lib/bindata/int.rb#146
    def create_uint2int_code(nbits); end

    # @return [Boolean]
    #
    # source://bindata//lib/bindata/int.rb#172
    def need_signed_conversion_code?(nbits, signed); end

    # source://bindata//lib/bindata/int.rb#157
    def pack_directive(nbits, endian, signed); end

    # source://bindata//lib/bindata/int.rb#130
    def val_as_packed_words(nbits, endian); end
  end
end

# Signed 1 byte integer.
#
# source://bindata//lib/bindata/int.rb#185
class BinData::Int8 < ::BinData::BasePrimitive
  def assign(val); end
  def do_num_bytes; end

  private

  def read_and_return_value(io); end
  def sensible_default; end
  def value_to_binary_string(val); end
end

# Create classes on demand
#
# source://bindata//lib/bindata/int.rb#190
module BinData::IntFactory
  # source://bindata//lib/bindata/int.rb#191
  def const_missing(name); end
end

# A LazyEvaluator is bound to a data object.  The evaluator will evaluate
# lambdas in the context of this data object.  These lambdas
# are those that are passed to data objects as parameters, e.g.:
#
#    BinData::String.new(value: -> { %w(a test message).join(" ") })
#
# As a shortcut, :foo is the equivalent of lambda { foo }.
#
# When evaluating lambdas, unknown methods are resolved in the context of the
# parent of the bound data object.  Resolution is attempted firstly as keys
# in #parameters, and secondly as methods in this parent.  This
# resolution propagates up the chain of parent data objects.
#
# An evaluation will recurse until it returns a result that is not
# a lambda or a symbol.
#
# This resolution process makes the lambda easier to read as we just write
# <tt>field</tt> instead of <tt>obj.field</tt>.
#
# source://bindata//lib/bindata/lazy.rb#20
class BinData::LazyEvaluator
  # Creates a new evaluator.  All lazy evaluation is performed in the
  # context of +obj+.
  #
  # @return [LazyEvaluator] a new instance of LazyEvaluator
  #
  # source://bindata//lib/bindata/lazy.rb#24
  def initialize(obj); end

  # Returns the index of this data object inside it's nearest container
  # array.
  #
  # @raise [NoMethodError]
  #
  # source://bindata//lib/bindata/lazy.rb#50
  def index; end

  # source://bindata//lib/bindata/lazy.rb#28
  def lazy_eval(val, overrides = T.unsafe(nil)); end

  # source://bindata//lib/bindata/lazy.rb#65
  def method_missing(symbol, *args); end

  # Returns a LazyEvaluator for the parent of this data object.
  #
  # source://bindata//lib/bindata/lazy.rb#40
  def parent; end

  private

  # @return [Boolean]
  #
  # source://bindata//lib/bindata/lazy.rb#105
  def callable?(obj); end

  # source://bindata//lib/bindata/lazy.rb#78
  def eval_symbol_in_parent_context(symbol, args); end

  # source://bindata//lib/bindata/lazy.rb#95
  def recursively_eval(val, args); end

  # source://bindata//lib/bindata/lazy.rb#83
  def resolve_symbol_in_parent_context(symbol, args); end
end

# Extracts args for Records and Buffers.
#
# Foo.new(bar: "baz) is ambiguous as to whether :bar is a value or parameter.
#
# BaseArgExtractor always assumes :bar is parameter.  This extractor correctly
# identifies it as value or parameter.
#
# source://bindata//lib/bindata/dsl.rb#8
module BinData::MultiFieldArgSeparator
  # @return [Boolean]
  #
  # source://bindata//lib/bindata/dsl.rb#28
  def field_names_in_parameters?(obj_class, parameters); end

  # @return [Boolean]
  #
  # source://bindata//lib/bindata/dsl.rb#20
  def parameters_is_value?(obj_class, value, parameters); end

  # source://bindata//lib/bindata/dsl.rb#9
  def separate_args(obj_class, obj_args); end
end

# A Primitive is a declarative way to define a new BinData data type.
# The data type must contain a primitive value only, i.e numbers or strings.
# For new data types that contain multiple values see BinData::Record.
#
# To define a new data type, set fields as if for Record and add a
# #get and #set method to extract / convert the data between the fields
# and the #value of the object.
#
#    require 'bindata'
#
#    class PascalString < BinData::Primitive
#      uint8  :len,  value: -> { data.length }
#      string :data, read_length: :len
#
#      def get
#        self.data
#      end
#
#      def set(v)
#        self.data = v
#      end
#    end
#
#    ps = PascalString.new(initial_value: "hello")
#    ps.to_binary_s #=> "\005hello"
#    ps.read("\003abcde")
#    ps #=> "abc"
#
#    # Unsigned 24 bit big endian integer
#    class Uint24be < BinData::Primitive
#      uint8 :byte1
#      uint8 :byte2
#      uint8 :byte3
#
#      def get
#        (self.byte1 << 16) | (self.byte2 << 8) | self.byte3
#      end
#
#      def set(v)
#        v = 0 if v < 0
#        v = 0xffffff if v > 0xffffff
#
#        self.byte1 = (v >> 16) & 0xff
#        self.byte2 = (v >>  8) & 0xff
#        self.byte3 =  v        & 0xff
#      end
#    end
#
#    u24 = Uint24be.new
#    u24.read("\x12\x34\x56")
#    "0x%x" % u24 #=> 0x123456
#
# == Parameters
#
# Primitive objects accept all the parameters that BinData::BasePrimitive do.
#
# source://bindata//lib/bindata/primitive.rb#62
class BinData::Primitive < ::BinData::BasePrimitive
  extend ::BinData::DSLMixin

  # source://bindata//lib/bindata/primitive.rb#88
  def assign(val); end

  # source://bindata//lib/bindata/primitive.rb#94
  def debug_name_of(child); end

  # source://bindata//lib/bindata/primitive.rb#103
  def do_num_bytes; end

  # source://bindata//lib/bindata/primitive.rb#98
  def do_write(io); end

  # source://bindata//lib/bindata/primitive.rb#71
  def initialize_instance; end

  # source://bindata//lib/bindata/primitive.rb#80
  def method_missing(symbol, *args, &block); end

  # @return [Boolean]
  #
  # source://bindata//lib/bindata/primitive.rb#76
  def respond_to?(symbol, include_private = T.unsafe(nil)); end

  private

  # Extracts the value for this data object from the fields of the
  # internal struct.
  #
  # @raise [NotImplementedError]
  #
  # source://bindata//lib/bindata/primitive.rb#125
  def get; end

  # source://bindata//lib/bindata/primitive.rb#115
  def read_and_return_value(io); end

  # source://bindata//lib/bindata/primitive.rb#111
  def sensible_default; end

  # Sets the fields of the internal struct to represent +v+.
  #
  # @raise [NotImplementedError]
  #
  # source://bindata//lib/bindata/primitive.rb#130
  def set(v); end

  class << self
    # source://bindata//lib/bindata/alignment.rb#84
    def bit_aligned; end
  end
end

# source://bindata//lib/bindata/primitive.rb#138
class BinData::PrimitiveArgProcessor < ::BinData::BaseArgProcessor
  # source://bindata//lib/bindata/primitive.rb#139
  def sanitize_parameters!(obj_class, params); end
end

# A Record is a declarative wrapper around Struct.
#
# See +Struct+ for more info.
#
# source://bindata//lib/bindata/record.rb#8
class BinData::Record < ::BinData::Struct
  extend ::BinData::DSLMixin

  class << self
    # source://bindata//lib/bindata/base.rb#53
    def inherited(subclass); end
  end
end

# source://bindata//lib/bindata/record.rb#16
class BinData::RecordArgProcessor < ::BinData::StructArgProcessor
  include ::BinData::MultiFieldArgSeparator

  # source://bindata//lib/bindata/record.rb#19
  def sanitize_parameters!(obj_class, params); end
end

# == Parameters
#
# Parameters may be provided at initialisation to control the behaviour of
# an object.  These parameters are:
#
# <tt>:name</tt>:: The name that this object can be referred to may be
#                  set explicitly.  This is only useful when dynamically
#                  generating types.
#                  <code><pre>
#                    BinData::Struct.new(name: :my_struct, fields: ...)
#                    array = BinData::Array.new(type: :my_struct)
#                  </pre></code>
#
# source://bindata//lib/bindata/name.rb#14
module BinData::RegisterNamePlugin
  # source://bindata//lib/bindata/name.rb#21
  def initialize_shared_instance; end

  class << self
    # source://bindata//lib/bindata/name.rb#16
    def included(base); end
  end
end

# A singleton registry of all registered classes.
#
# source://bindata//lib/bindata/registry.rb#133
BinData::RegisteredClasses = T.let(T.unsafe(nil), BinData::Registry)

# This registry contains a register of name -> class mappings.
#
# Numerics (integers and floating point numbers) have an endian property as
# part of their name (e.g. int32be, float_le).
#
# Classes can be looked up based on their full name or an abbreviated +name+
# with +hints+.
#
# There are two hints supported, :endian and :search_prefix.
#
#   #lookup("int32", { endian: :big }) will return Int32Be.
#
#   #lookup("my_type", { search_prefix: :ns }) will return NsMyType.
#
# Names are stored in under_score_style, not camelCase.
#
# source://bindata//lib/bindata/registry.rb#20
class BinData::Registry
  # @return [Registry] a new instance of Registry
  #
  # source://bindata//lib/bindata/registry.rb#21
  def initialize; end

  # source://bindata//lib/bindata/registry.rb#38
  def lookup(name, hints = T.unsafe(nil)); end

  # source://bindata//lib/bindata/registry.rb#25
  def register(name, class_to_register); end

  # Convert CamelCase +name+ to underscore style.
  #
  # source://bindata//lib/bindata/registry.rb#50
  def underscore_name(name); end

  # source://bindata//lib/bindata/registry.rb#34
  def unregister(name); end

  private

  # source://bindata//lib/bindata/registry.rb#95
  def name_with_endian(name, endian); end

  # source://bindata//lib/bindata/registry.rb#86
  def name_with_prefix(name, prefix); end

  # source://bindata//lib/bindata/registry.rb#63
  def normalize_name(name, hints); end

  # source://bindata//lib/bindata/registry.rb#112
  def register_dynamic_class(name); end

  # @return [Boolean]
  #
  # source://bindata//lib/bindata/registry.rb#106
  def registered?(name); end

  # source://bindata//lib/bindata/registry.rb#123
  def warn_if_name_is_already_registered(name, class_to_register); end
end

# Rest will consume the input stream from the current position to the end of
# the stream.  This will mainly be useful for debugging and developing.
#
#   require 'bindata'
#
#   class A < BinData::Record
#     string :a, read_length: 5
#     rest   :rest
#   end
#
#   obj = A.read("abcdefghij")
#   obj.a #=> "abcde"
#   obj.rest #=" "fghij"
#
# source://bindata//lib/bindata/rest.rb#19
class BinData::Rest < ::BinData::BasePrimitive
  private

  # source://bindata//lib/bindata/rest.rb#26
  def read_and_return_value(io); end

  # source://bindata//lib/bindata/rest.rb#30
  def sensible_default; end

  # source://bindata//lib/bindata/rest.rb#22
  def value_to_binary_string(val); end
end

# Resets the stream alignment to the next byte.  This is
# only useful when using bit-based primitives.
#
#    class MyRec < BinData::Record
#      bit4 :a
#      resume_byte_alignment
#      bit4 :b
#    end
#
#    MyRec.read("\x12\x34") #=> {"a" => 1, "b" => 3}
#
# source://bindata//lib/bindata/alignment.rb#15
class BinData::ResumeByteAlignment < ::BinData::Base
  # source://bindata//lib/bindata/alignment.rb#17
  def assign(val); end

  # @return [Boolean]
  #
  # source://bindata//lib/bindata/alignment.rb#16
  def clear?; end

  # source://bindata//lib/bindata/alignment.rb#19
  def do_num_bytes; end

  # source://bindata//lib/bindata/alignment.rb#21
  def do_read(io); end

  # source://bindata//lib/bindata/alignment.rb#25
  def do_write(io); end

  # source://bindata//lib/bindata/alignment.rb#18
  def snapshot; end
end

# ----------------------------------------------------------------------------
#
# source://bindata//lib/bindata/sanitize.rb#149
class BinData::SanitizedBigEndian < ::BinData::SanitizedParameter
  # source://bindata//lib/bindata/sanitize.rb#150
  def endian; end
end

# ----------------------------------------------------------------------------
#
# source://bindata//lib/bindata/sanitize.rb#124
class BinData::SanitizedChoices < ::BinData::SanitizedParameter
  # @return [SanitizedChoices] a new instance of SanitizedChoices
  #
  # source://bindata//lib/bindata/sanitize.rb#125
  def initialize(choices, hints); end

  # source://bindata//lib/bindata/sanitize.rb#143
  def [](key); end
end

# ----------------------------------------------------------------------------
#
# source://bindata//lib/bindata/sanitize.rb#46
class BinData::SanitizedField < ::BinData::SanitizedParameter
  # @return [SanitizedField] a new instance of SanitizedField
  #
  # source://bindata//lib/bindata/sanitize.rb#47
  def initialize(name, field_type, field_params, hints); end

  # @return [Boolean]
  #
  # source://bindata//lib/bindata/sanitize.rb#58
  def has_parameter?(param); end

  # source://bindata//lib/bindata/sanitize.rb#62
  def instantiate(value = T.unsafe(nil), parent = T.unsafe(nil)); end

  # Returns the value of attribute name.
  #
  # source://bindata//lib/bindata/sanitize.rb#52
  def name; end

  # source://bindata//lib/bindata/sanitize.rb#54
  def name_as_sym; end

  # Returns the value of attribute prototype.
  #
  # source://bindata//lib/bindata/sanitize.rb#52
  def prototype; end
end

# ----------------------------------------------------------------------------
#
# source://bindata//lib/bindata/sanitize.rb#68
class BinData::SanitizedFields < ::BinData::SanitizedParameter
  include ::Enumerable

  # @return [SanitizedFields] a new instance of SanitizedFields
  #
  # source://bindata//lib/bindata/sanitize.rb#71
  def initialize(hints, base_fields = T.unsafe(nil)); end

  # source://bindata//lib/bindata/sanitize.rb#86
  def [](idx); end

  # source://bindata//lib/bindata/sanitize.rb#76
  def add_field(type, name, params); end

  # @return [Boolean]
  #
  # source://bindata//lib/bindata/sanitize.rb#110
  def all_field_names_blank?; end

  # @return [Boolean]
  #
  # source://bindata//lib/bindata/sanitize.rb#118
  def any_field_has_parameter?(parameter); end

  # source://bindata//lib/bindata/sanitize.rb#98
  def each(&block); end

  # @return [Boolean]
  #
  # source://bindata//lib/bindata/sanitize.rb#90
  def empty?; end

  # @return [Boolean]
  #
  # source://bindata//lib/bindata/sanitize.rb#106
  def field_name?(name); end

  # source://bindata//lib/bindata/sanitize.rb#102
  def field_names; end

  # source://bindata//lib/bindata/sanitize.rb#94
  def length; end

  # @return [Boolean]
  #
  # source://bindata//lib/bindata/sanitize.rb#114
  def no_field_names_blank?; end

  # source://bindata//lib/bindata/sanitize.rb#82
  def raw_fields; end
end

# source://bindata//lib/bindata/sanitize.rb#155
class BinData::SanitizedLittleEndian < ::BinData::SanitizedParameter
  # source://bindata//lib/bindata/sanitize.rb#156
  def endian; end
end

# Subclasses of this are sanitized
#
# source://bindata//lib/bindata/sanitize.rb#6
class BinData::SanitizedParameter; end

# BinData objects are instantiated with parameters to determine their
# behaviour.  These parameters must be sanitized to ensure their values
# are valid.  When instantiating many objects with identical parameters,
# such as an array of records, there is much duplicated sanitizing.
#
# The purpose of the sanitizing code is to eliminate the duplicated
# validation.
#
# SanitizedParameters is a hash-like collection of parameters.  Its purpose
# is to recursively sanitize the parameters of an entire BinData object chain
# at a single time.
#
# source://bindata//lib/bindata/sanitize.rb#174
class BinData::SanitizedParameters < ::Hash
  # @return [SanitizedParameters] a new instance of SanitizedParameters
  #
  # source://bindata//lib/bindata/sanitize.rb#188
  def initialize(parameters, the_class, hints); end

  # source://bindata//lib/bindata/sanitize.rb#280
  def create_sanitized_params(params, the_class); end

  # @return [Boolean]
  #
  # source://bindata//lib/bindata/sanitize.rb#206
  def has_at_least_one_of?(*keys); end

  def has_parameter?(_arg0); end

  # source://bindata//lib/bindata/sanitize.rb#284
  def hints; end

  # def warn_renamed_parameter(old_key, new_key)
  #      val = delete(old_key)
  #      if val
  #        self[new_key] = val
  #        Kernel.warn ":#{old_key} has been renamed to :#{new_key} in #{@the_class}.  " \
  #        "Using :#{old_key} is now deprecated and will be removed in the future"
  #      end
  #    end
  #
  # source://bindata//lib/bindata/sanitize.rb#230
  def must_be_integer(*keys); end

  # source://bindata//lib/bindata/sanitize.rb#244
  def rename_parameter(old_key, new_key); end

  # source://bindata//lib/bindata/sanitize.rb#274
  def sanitize(key, &block); end

  # source://bindata//lib/bindata/sanitize.rb#264
  def sanitize_choices(key, &block); end

  # source://bindata//lib/bindata/sanitize.rb#270
  def sanitize_endian(key); end

  # source://bindata//lib/bindata/sanitize.rb#256
  def sanitize_fields(key, &block); end

  # source://bindata//lib/bindata/sanitize.rb#250
  def sanitize_object_prototype(key); end

  # source://bindata//lib/bindata/sanitize.rb#214
  def warn_replacement_parameter(bad_key, suggested_key); end

  private

  # source://bindata//lib/bindata/sanitize.rb#352
  def create_sanitized_choices(choices); end

  # source://bindata//lib/bindata/sanitize.rb#340
  def create_sanitized_endian(endian); end

  # source://bindata//lib/bindata/sanitize.rb#356
  def create_sanitized_fields; end

  # source://bindata//lib/bindata/sanitize.rb#360
  def create_sanitized_object_prototype(obj_type, obj_params); end

  # source://bindata//lib/bindata/sanitize.rb#320
  def ensure_mandatory_parameters_exist; end

  # source://bindata//lib/bindata/sanitize.rb#329
  def ensure_mutual_exclusion_of_parameters; end

  # source://bindata//lib/bindata/sanitize.rb#305
  def ensure_no_nil_values; end

  # source://bindata//lib/bindata/sanitize.rb#314
  def merge_default_parameters!; end

  # @return [Boolean]
  #
  # source://bindata//lib/bindata/sanitize.rb#301
  def needs_sanitizing?(key); end

  # source://bindata//lib/bindata/sanitize.rb#291
  def sanitize!; end

  class << self
    # source://bindata//lib/bindata/sanitize.rb#179
    def sanitize(parameters, the_class); end
  end
end

# Memoized constants
#
# source://bindata//lib/bindata/sanitize.rb#175
BinData::SanitizedParameters::BIG_ENDIAN = T.let(T.unsafe(nil), BinData::SanitizedBigEndian)

# source://bindata//lib/bindata/sanitize.rb#176
BinData::SanitizedParameters::LITTLE_ENDIAN = T.let(T.unsafe(nil), BinData::SanitizedLittleEndian)

# source://bindata//lib/bindata/sanitize.rb#8
class BinData::SanitizedPrototype < ::BinData::SanitizedParameter
  # @return [SanitizedPrototype] a new instance of SanitizedPrototype
  #
  # source://bindata//lib/bindata/sanitize.rb#9
  def initialize(obj_type, obj_params, hints); end

  # @return [Boolean]
  #
  # source://bindata//lib/bindata/sanitize.rb#30
  def has_parameter?(param); end

  # source://bindata//lib/bindata/sanitize.rb#38
  def instantiate(value = T.unsafe(nil), parent = T.unsafe(nil)); end
end

# source://bindata//lib/bindata/bits.rb#15
class BinData::Sbit < ::BinData::BasePrimitive
  def assign(val); end
  def bit_aligned?; end
  def do_num_bytes; end
  def do_write(io); end

  private

  def read_and_return_value(io); end
  def sensible_default; end
end

# source://bindata//lib/bindata/bits.rb#15
class BinData::SbitLe < ::BinData::BasePrimitive
  def assign(val); end
  def bit_aligned?; end
  def do_num_bytes; end
  def do_write(io); end

  private

  def read_and_return_value(io); end
  def sensible_default; end
end

# A Section is a layer on top of a stream that transforms the underlying
# data.  This allows BinData to process a stream that has multiple
# encodings.  e.g.  Some data data is compressed or encrypted.
#
#   require 'bindata'
#
#   class XorTransform < BinData::IO::Transform
#      def initialize(xor)
#        super()
#        @xor = xor
#      end
#
#      def read(n)
#        chain_read(n).bytes.map { |byte| (byte ^ @xor).chr }.join
#      end
#
#      def write(data)
#        chain_write(data.bytes.map { |byte| (byte ^ @xor).chr }.join)
#      end
#   end
#
#   obj = BinData::Section.new(transform: -> { XorTransform.new(0xff) },
#                              type: [:string, read_length: 5])
#
#   obj.read("\x97\x9A\x93\x93\x90") #=> "hello"
#
#
# == Parameters
#
# Parameters may be provided at initialisation to control the behaviour of
# an object.  These params are:
#
# <tt>:transform</tt>:: A callable that returns a new BinData::IO::Transform.
# <tt>:type</tt>::      The single type inside the buffer.  Use a struct if
#                       multiple fields are required.
#
# source://bindata//lib/bindata/section.rb#40
class BinData::Section < ::BinData::Base
  extend ::BinData::DSLMixin

  # source://bindata//lib/bindata/section.rb#56
  def assign(val); end

  # @return [Boolean]
  #
  # source://bindata//lib/bindata/section.rb#52
  def clear?; end

  # source://bindata//lib/bindata/section.rb#84
  def do_num_bytes; end

  # source://bindata//lib/bindata/section.rb#72
  def do_read(io); end

  # source://bindata//lib/bindata/section.rb#78
  def do_write(io); end

  # source://bindata//lib/bindata/section.rb#48
  def initialize_instance; end

  # source://bindata//lib/bindata/section.rb#68
  def method_missing(symbol, *args, &block); end

  # source://bindata//lib/bindata/section.rb#60
  def snapshot; end

  private

  # @return [Boolean]
  #
  # source://bindata//lib/bindata/section.rb#64
  def respond_to_missing?(symbol, include_all = T.unsafe(nil)); end
end

# source://bindata//lib/bindata/section.rb#89
class BinData::SectionArgProcessor < ::BinData::BaseArgProcessor
  include ::BinData::MultiFieldArgSeparator

  # source://bindata//lib/bindata/section.rb#92
  def sanitize_parameters!(obj_class, params); end
end

# Skip will skip over bytes from the input stream.  If the stream is not
# seekable, then the bytes are consumed and discarded.
#
# When writing, skip will write the appropriate number of zero bytes.
#
#   require 'bindata'
#
#   class A < BinData::Record
#     skip length: 5
#     string :a, read_length: 5
#   end
#
#   obj = A.read("abcdefghij")
#   obj.a #=> "fghij"
#
#
#   class B < BinData::Record
#     skip do
#       string read_length: 2, assert: 'ef'
#     end
#     string :s, read_length: 5
#   end
#
#   obj = B.read("abcdefghij")
#   obj.s #=> "efghi"
#
#
# == Parameters
#
# Skip objects accept all the params that BinData::BasePrimitive
# does, as well as the following:
#
# <tt>:length</tt>::        The number of bytes to skip.
# <tt>:to_abs_offset</tt>:: Skips to the given absolute offset.
# <tt>:until_valid</tt>::   Skips until a given byte pattern is matched.
#                           This parameter contains a type that will raise
#                           a BinData::ValidityError unless an acceptable byte
#                           sequence is found.  The type is represented by a
#                           Symbol, or if the type is to have params
#                           passed to it, then it should be provided as
#                           <tt>[type_symbol, hash_params]</tt>.
#
# source://bindata//lib/bindata/skip.rb#47
class BinData::Skip < ::BinData::BasePrimitive
  extend ::BinData::DSLMixin

  # source://bindata//lib/bindata/skip.rb#56
  def initialize_shared_instance; end

  private

  # source://bindata//lib/bindata/skip.rb#76
  def read_and_return_value(io); end

  # source://bindata//lib/bindata/skip.rb#87
  def sensible_default; end

  # source://bindata//lib/bindata/skip.rb#66
  def value_to_binary_string(_); end
end

# Logic for the :length parameter
#
# source://bindata//lib/bindata/skip.rb#92
module BinData::Skip::SkipLengthPlugin
  # source://bindata//lib/bindata/skip.rb#93
  def skip_length; end
end

# Logic for the :to_abs_offset parameter
#
# source://bindata//lib/bindata/skip.rb#99
module BinData::Skip::SkipToAbsOffsetPlugin
  # source://bindata//lib/bindata/skip.rb#100
  def skip_length; end
end

# Logic for the :until_valid parameter
#
# source://bindata//lib/bindata/skip.rb#106
module BinData::Skip::SkipUntilValidPlugin
  # source://bindata//lib/bindata/skip.rb#145
  def fast_search_for(obj); end

  # If a search object has an +asserted_value+ field then we
  # perform a faster search for a valid object.
  #
  # source://bindata//lib/bindata/skip.rb#155
  def fast_search_for_obj(obj); end

  # source://bindata//lib/bindata/skip.rb#170
  def next_search_index(io, fs); end

  # source://bindata//lib/bindata/skip.rb#111
  def read_and_return_value(io); end

  # source://bindata//lib/bindata/skip.rb#137
  def seek_to_pos(pos, io); end

  # source://bindata//lib/bindata/skip.rb#107
  def skip_length; end
end

# A fast search has a pattern string at a specific offset.
#
# source://bindata//lib/bindata/skip.rb#143
BinData::Skip::SkipUntilValidPlugin::FastSearch = Struct

# source://bindata//lib/bindata/skip.rb#193
class BinData::Skip::SkipUntilValidPlugin::ReadaheadIO < ::BinData::IO::Transform
  # source://bindata//lib/bindata/skip.rb#194
  def before_transform; end

  # source://bindata//lib/bindata/skip.rb#202
  def rollback; end
end

# source://bindata//lib/bindata/skip.rb#168
BinData::Skip::SkipUntilValidPlugin::SEARCH_SIZE = T.let(T.unsafe(nil), Integer)

# source://bindata//lib/bindata/skip.rb#209
class BinData::SkipArgProcessor < ::BinData::BaseArgProcessor
  # source://bindata//lib/bindata/skip.rb#210
  def sanitize_parameters!(obj_class, params); end
end

# A String is a sequence of bytes.  This is the same as strings in Ruby 1.8.
# The issue of character encoding is ignored by this class.
#
#   require 'bindata'
#
#   data = "abcdefghij"
#
#   obj = BinData::String.new(read_length: 5)
#   obj.read(data)
#   obj #=> "abcde"
#
#   obj = BinData::String.new(length: 6)
#   obj.read(data)
#   obj #=> "abcdef"
#   obj.assign("abcdefghij")
#   obj #=> "abcdef"
#   obj.assign("abcd")
#   obj #=> "abcd\000\000"
#
#   obj = BinData::String.new(length: 6, trim_padding: true)
#   obj.assign("abcd")
#   obj #=> "abcd"
#   obj.to_binary_s #=> "abcd\000\000"
#
#   obj = BinData::String.new(length: 6, pad_byte: 'A')
#   obj.assign("abcd")
#   obj #=> "abcdAA"
#   obj.to_binary_s #=> "abcdAA"
#
# == Parameters
#
# String objects accept all the params that BinData::BasePrimitive
# does, as well as the following:
#
# <tt>:read_length</tt>::    The length in bytes to use when reading a value.
# <tt>:length</tt>::         The fixed length of the string.  If a shorter
#                            string is set, it will be padded to this length.
# <tt>:pad_byte</tt>::       The byte to use when padding a string to a
#                            set length.  Valid values are Integers and
#                            Strings of length 1.  "\0" is the default.
# <tt>:pad_front</tt>::      Signifies that the padding occurs at the front
#                            of the string rather than the end.  Default
#                            is false.
# <tt>:trim_padding</tt>::   Boolean, default false.  If set, #value will
#                            return the value with all pad_bytes trimmed
#                            from the end of the string.  The value will
#                            not be trimmed when writing.
#
# source://bindata//lib/bindata/string.rb#51
class BinData::String < ::BinData::BasePrimitive
  # source://bindata//lib/bindata/string.rb#67
  def assign(val); end

  # source://bindata//lib/bindata/string.rb#59
  def initialize_shared_instance; end

  # source://bindata//lib/bindata/string.rb#71
  def snapshot; end

  private

  # source://bindata//lib/bindata/string.rb#86
  def clamp_to_length(str); end

  # source://bindata//lib/bindata/string.rb#116
  def read_and_return_value(io); end

  # source://bindata//lib/bindata/string.rb#121
  def sensible_default; end

  # source://bindata//lib/bindata/string.rb#104
  def trim_padding(str); end

  # source://bindata//lib/bindata/string.rb#112
  def value_to_binary_string(val); end
end

# Warns when reading if :value && no :read_length
#
# source://bindata//lib/bindata/string.rb#126
module BinData::String::WarnNoReadLengthPlugin
  # source://bindata//lib/bindata/string.rb#127
  def read_and_return_value(io); end
end

# source://bindata//lib/bindata/string.rb#134
class BinData::StringArgProcessor < ::BinData::BaseArgProcessor
  # source://bindata//lib/bindata/string.rb#135
  def sanitize_parameters!(obj_class, params); end

  private

  # source://bindata//lib/bindata/string.rb#145
  def sanitized_pad_byte(byte); end
end

# A BinData::Stringz object is a container for a zero ("\0") terminated
# string.
#
# For convenience, the zero terminator is not necessary when setting the
# value.  Likewise, the returned value will not be zero terminated.
#
#   require 'bindata'
#
#   data = "abcd\x00efgh"
#
#   obj = BinData::Stringz.new
#   obj.read(data)
#   obj.snapshot #=> "abcd"
#   obj.num_bytes #=> 5
#   obj.to_binary_s #=> "abcd\000"
#
# == Parameters
#
# Stringz objects accept all the params that BinData::BasePrimitive
# does, as well as the following:
#
# <tt>:max_length</tt>:: The maximum length of the string including the zero
#                        byte.
#
# source://bindata//lib/bindata/stringz.rb#27
class BinData::Stringz < ::BinData::BasePrimitive
  # source://bindata//lib/bindata/stringz.rb#30
  def assign(val); end

  # source://bindata//lib/bindata/stringz.rb#34
  def snapshot; end

  private

  # source://bindata//lib/bindata/stringz.rb#92
  def append_zero_byte_if_needed!(str); end

  # source://bindata//lib/bindata/stringz.rb#47
  def read_and_return_value(io); end

  # source://bindata//lib/bindata/stringz.rb#63
  def sensible_default; end

  # source://bindata//lib/bindata/stringz.rb#67
  def trim_and_zero_terminate(str); end

  # source://bindata//lib/bindata/stringz.rb#85
  def trim_to!(str, max_length = T.unsafe(nil)); end

  # source://bindata//lib/bindata/stringz.rb#81
  def truncate_after_first_zero_byte!(str); end

  # source://bindata//lib/bindata/stringz.rb#43
  def value_to_binary_string(val); end
end

# A Struct is an ordered collection of named data objects.
#
#    require 'bindata'
#
#    class Tuple < BinData::Record
#      int8  :x
#      int8  :y
#      int8  :z
#    end
#
#    obj = BinData::Struct.new(hide: :a,
#                              fields: [ [:int32le, :a],
#                                        [:int16le, :b],
#                                        [:tuple, :s] ])
#    obj.field_names   =># [:b, :s]
#
#
# == Parameters
#
# Parameters may be provided at initialisation to control the behaviour of
# an object.  These params are:
#
# <tt>:fields</tt>::   An array specifying the fields for this struct.
#                      Each element of the array is of the form [type, name,
#                      params].  Type is a symbol representing a registered
#                      type.  Name is the name of this field.  Params is an
#                      optional hash of parameters to pass to this field
#                      when instantiating it.  If name is "" or nil, then
#                      that field is anonymous and behaves as a hidden field.
# <tt>:hide</tt>::     A list of the names of fields that are to be hidden
#                      from the outside world.  Hidden fields don't appear
#                      in #snapshot or #field_names but are still accessible
#                      by name.
# <tt>:endian</tt>::   Either :little or :big.  This specifies the default
#                      endian of any numerics in this struct, or in any
#                      nested data objects.
# <tt>:search_prefix</tt>::  Allows abbreviated type names.  If a type is
#                            unrecognised, then each prefix is applied until
#                            a match is found.
#
# == Field Parameters
#
# Fields may have have extra parameters as listed below:
#
# [<tt>:onlyif</tt>]     Used to indicate a data object is optional.
#                        if +false+, this object will not be included in any
#                        calls to #read, #write, #num_bytes or #snapshot.
# [<tt>:byte_align</tt>] This field's rel_offset must be a multiple of
#                        <tt>:byte_align</tt>.
#
# source://bindata//lib/bindata/struct.rb#58
class BinData::Struct < ::BinData::Base
  # source://bindata//lib/bindata/struct.rb#154
  def [](key); end

  # source://bindata//lib/bindata/struct.rb#158
  def []=(key, value); end

  # source://bindata//lib/bindata/struct.rb#102
  def assign(val); end

  # source://bindata//lib/bindata/struct.rb#94
  def clear; end

  # @return [Boolean]
  #
  # source://bindata//lib/bindata/struct.rb#98
  def clear?; end

  # source://bindata//lib/bindata/struct.rb#128
  def debug_name_of(child); end

  # source://bindata//lib/bindata/struct.rb#149
  def do_num_bytes; end

  # source://bindata//lib/bindata/struct.rb#139
  def do_read(io); end

  # source://bindata//lib/bindata/struct.rb#144
  def do_write(io); end

  # Calls the given block for each field_name-field_obj pair.
  #
  # Does not include anonymous or hidden fields unless
  # +include_all+ is true.
  #
  # source://bindata//lib/bindata/struct.rb#170
  def each_pair(include_all = T.unsafe(nil)); end

  # Returns a list of the names of all fields accessible through this
  # object.  +include_hidden+ specifies whether to include hidden names
  # in the listing.
  #
  # source://bindata//lib/bindata/struct.rb#119
  def field_names(include_hidden = T.unsafe(nil)); end

  # has_key? is deprecated
  #
  # @return [Boolean]
  #
  # source://bindata//lib/bindata/struct.rb#162
  def has_key?(key); end

  # source://bindata//lib/bindata/struct.rb#90
  def initialize_instance; end

  # source://bindata//lib/bindata/struct.rb#82
  def initialize_shared_instance; end

  # @return [Boolean]
  #
  # source://bindata//lib/bindata/struct.rb#162
  def key?(key); end

  # source://bindata//lib/bindata/struct.rb#133
  def offset_of(child); end

  # source://bindata//lib/bindata/struct.rb#107
  def snapshot; end

  private

  # source://bindata//lib/bindata/struct.rb#247
  def as_stringified_hash(val); end

  # source://bindata//lib/bindata/struct.rb#236
  def assign_fields(val); end

  # source://bindata//lib/bindata/struct.rb#221
  def base_field_name(name); end

  # source://bindata//lib/bindata/struct.rb#187
  def define_field_accessors; end

  # source://bindata//lib/bindata/struct.rb#194
  def define_field_accessors_for(name, index); end

  # source://bindata//lib/bindata/struct.rb#209
  def find_index_of(obj); end

  # source://bindata//lib/bindata/struct.rb#213
  def find_obj_for_name(name); end

  # @return [Boolean]
  #
  # source://bindata//lib/bindata/struct.rb#281
  def include_obj?(obj); end

  # @return [Boolean]
  #
  # source://bindata//lib/bindata/struct.rb#275
  def include_obj_for_io?(obj); end

  # source://bindata//lib/bindata/struct.rb#225
  def instantiate_all_objs; end

  # source://bindata//lib/bindata/struct.rb#229
  def instantiate_obj_at(index); end

  # source://bindata//lib/bindata/struct.rb#263
  def sum_num_bytes_below_index(index); end

  # source://bindata//lib/bindata/struct.rb#259
  def sum_num_bytes_for_all_fields; end

  class << self
    # source://bindata//lib/bindata/base.rb#53
    def inherited(subclass); end
  end
end

# Align fields to a multiple of :byte_align
#
# source://bindata//lib/bindata/struct.rb#301
module BinData::Struct::ByteAlignPlugin
  # @return [Boolean]
  #
  # source://bindata//lib/bindata/struct.rb#361
  def align_obj?(obj); end

  # source://bindata//lib/bindata/struct.rb#356
  def bytes_to_align(obj, rel_offset); end

  # source://bindata//lib/bindata/struct.rb#302
  def do_read(io); end

  # source://bindata//lib/bindata/struct.rb#320
  def do_write(io); end

  # source://bindata//lib/bindata/struct.rb#338
  def sum_num_bytes_below_index(index); end
end

# These reserved words may not be used as field names
#
# source://bindata//lib/bindata/struct.rb#65
BinData::Struct::RESERVED = T.let(T.unsafe(nil), Hash)

# A hash that can be accessed via attributes.
#
# source://bindata//lib/bindata/struct.rb#286
class BinData::Struct::Snapshot < ::Hash
  # source://bindata//lib/bindata/struct.rb#287
  def []=(key, value); end

  # source://bindata//lib/bindata/struct.rb#295
  def method_missing(symbol, *args); end

  private

  # @return [Boolean]
  #
  # source://bindata//lib/bindata/struct.rb#291
  def respond_to_missing?(symbol, include_all = T.unsafe(nil)); end
end

# source://bindata//lib/bindata/struct.rb#367
class BinData::StructArgProcessor < ::BinData::BaseArgProcessor
  # source://bindata//lib/bindata/struct.rb#368
  def sanitize_parameters!(obj_class, params); end

  private

  # source://bindata//lib/bindata/struct.rb#420
  def ensure_field_names_are_valid(obj_class, field_names); end

  # source://bindata//lib/bindata/struct.rb#416
  def hidden_field_names(hidden); end

  # source://bindata//lib/bindata/struct.rb#378
  def sanitize_endian(params); end

  # source://bindata//lib/bindata/struct.rb#392
  def sanitize_fields(obj_class, params); end

  # source://bindata//lib/bindata/struct.rb#403
  def sanitize_hide(params); end

  # source://bindata//lib/bindata/struct.rb#382
  def sanitize_search_prefix(params); end

  # source://bindata//lib/bindata/struct.rb#412
  def sanitized_field_names(sanitized_fields); end
end

# source://bindata//lib/bindata/trace.rb#47
module BinData::TraceHook
  # source://bindata//lib/bindata/trace.rb#55
  def turn_off_tracing; end

  # source://bindata//lib/bindata/trace.rb#48
  def turn_on_tracing; end
end

# source://bindata//lib/bindata/trace.rb#23
class BinData::Tracer
  # @return [Tracer] a new instance of Tracer
  #
  # source://bindata//lib/bindata/trace.rb#24
  def initialize(io); end

  # source://bindata//lib/bindata/trace.rb#28
  def trace(msg); end

  # source://bindata//lib/bindata/trace.rb#32
  def trace_obj(obj_name, val); end
end

# Unsigned 1 byte integer.
#
# source://bindata//lib/bindata/int.rb#180
class BinData::Uint8 < ::BinData::BasePrimitive
  def assign(val); end
  def do_num_bytes; end

  private

  def read_and_return_value(io); end
  def sensible_default; end
  def value_to_binary_string(val); end
end

# Uint8Array is a specialised type of array that only contains
# bytes (Uint8).  It is a faster and more memory efficient version
# of `BinData::Array.new(:type => :uint8)`.
#
#   require 'bindata'
#
#   obj = BinData::Uint8Array.new(initial_length: 5)
#   obj.read("abcdefg") #=> [97, 98, 99, 100, 101]
#   obj[2] #=> 99
#   obj.collect { |x| x.chr }.join #=> "abcde"
#
# == Parameters
#
# Parameters may be provided at initialisation to control the behaviour of
# an object.  These params are:
#
# <tt>:initial_length</tt>:: The initial length of the array.
# <tt>:read_until</tt>::     May only have a value of `:eof`.  This parameter
#                            instructs the array to read as much data from
#                            the stream as possible.
#
# source://bindata//lib/bindata/uint8_array.rb#24
class BinData::Uint8Array < ::BinData::BasePrimitive
  private

  # source://bindata//lib/bindata/uint8_array.rb#36
  def read_and_return_value(io); end

  # source://bindata//lib/bindata/uint8_array.rb#46
  def sensible_default; end

  # source://bindata//lib/bindata/uint8_array.rb#32
  def value_to_binary_string(val); end
end

# source://bindata//lib/bindata/uint8_array.rb#51
class BinData::Uint8ArrayArgProcessor < ::BinData::BaseArgProcessor
  # source://bindata//lib/bindata/uint8_array.rb#52
  def sanitize_parameters!(obj_class, params); end
end

# Raised when #lookup fails.
#
# source://bindata//lib/bindata/registry.rb#3
class BinData::UnRegisteredTypeError < ::StandardError; end

# source://bindata//lib/bindata/version.rb#2
BinData::VERSION = T.let(T.unsafe(nil), String)

# Error raised when unexpected results occur when reading data from IO.
#
# source://bindata//lib/bindata/framework.rb#3
class BinData::ValidityError < ::StandardError; end

# A virtual field is one that is neither read, written nor occupies space in
# the data stream.  It is used to make assertions or as a convenient label
# for determining offsets or storing values.
#
#   require 'bindata'
#
#   class A < BinData::Record
#     string  :a, read_length: 5
#     string  :b, read_length: 5
#     virtual :c, assert: -> { a == b }
#   end
#
#   obj = A.read("abcdeabcde")
#   obj.a #=> "abcde"
#   obj.c.rel_offset #=> 10
#
#   obj = A.read("abcdeABCDE") #=> BinData::ValidityError: assertion failed for obj.c
#
# == Parameters
#
# Parameters may be provided at initialisation to control the behaviour of
# an object.  These params include those for BinData::Base as well as:
#
# [<tt>:assert</tt>]    Raise an error when reading or assigning if the value
#                       of this evaluated parameter is false.
# [<tt>:value</tt>]     The virtual object will always have this value.
#
# source://bindata//lib/bindata/virtual.rb#31
class BinData::Virtual < ::BinData::BasePrimitive
  # source://bindata//lib/bindata/virtual.rb#36
  def do_num_bytes; end

  # source://bindata//lib/bindata/virtual.rb#32
  def do_read(io); end

  # source://bindata//lib/bindata/virtual.rb#34
  def do_write(io); end

  # source://bindata//lib/bindata/virtual.rb#40
  def sensible_default; end
end
