# typed: strict

# This file contains global args as defined in `Homebrew::CLI::Parser.global_options`
# `Command`-specific args are defined in the commands themselves, with type signatures
# generated by the `Tapioca::Compilers::Args` compiler.

class Homebrew::CLI::Args
  sig { returns(T::Boolean) }
  def debug?; end

  sig { returns(T::Boolean) }
  def help?; end

  sig { returns(T::Boolean) }
  def quiet?; end

  sig { returns(T::Array[String]) }
  def remaining; end

  sig { returns(T::Boolean) }
  def verbose?; end

  # FIXME: The methods below are not defined by Args, but are valid because Args inherits from OpenStruct
  # We should instead be using type guards to check if the method is defined on the object before calling it

  sig { returns(T.nilable(String)) }
  def arch; end

  sig { returns(T::Boolean) }
  def build_from_source?; end

  sig { returns(T::Boolean) }
  def cask?; end

  sig { returns(T::Boolean) }
  def formula?; end

  sig { returns(T::Boolean) }
  def include_test?; end

  sig { returns(T.nilable(String)) }
  def os; end
end
