# typed: strict
# frozen_string_literal: true

# This module provides methods to define specialized attributes.
# Method stubs are generated by the {Tapioca::Compilers::Attrables} compiler.
# @note The compiler is fragile, and must be updated if the filename changes, if methods are added or removed,
#   or if a method's arity changes.
module Attrable
  extend T::Helpers

  requires_ancestor { Module }

  sig { params(attrs: Symbol).void }
  def attr_predicate(*attrs)
    attrs.each do |attr|
      define_method attr do
        instance_variable_get("@#{attr.to_s.sub(/\?$/, "")}") == true
      end
    end
  end

  sig { params(attrs: Symbol).void }
  def attr_rw(*attrs)
    attrs.each do |attr|
      define_method attr do |val = nil|
        val.nil? ? instance_variable_get(:"@#{attr}") : instance_variable_set(:"@#{attr}", val)
      end
    end
  end
end
