# Contributing to kubernetes-validation-tools

👋 Hey, thanks for taking the time to contribute! Your help is appreciated.

## How can I contribute?

### Reporting bugs

Bug reports are always welcome, and should be reported as a [GitHub issue](https://github.com/HighwayofLife/kubernetes-validation-tools/issues/new).


### Feature requests

Feature requests are always welcome, this should also be done as a [GitHub issue](https://github.com/HighwayofLife/kubernetes-validation-tools/issues/new).

Describe the feature that you would like to see as clearly as possible.

### Contributing code

Code contributions are welcome as [GitHub Pull Requests](https://github.com/HighwayofLife/kubernetes-validation-tools/pulls).

#### Good commit messages

We try to use the same commit message format as [the Go programming language](https://golang.org/doc/contribute.html#commit_messages).

Example of a good commit message:

```
kube-score: Update kube-score project to v1.2.3

Fixes #79
```

The first line of the commit message should contain a short description of the change, prefixed by the primary affected package.

Additional lines can be used if a longer explanation of the change is needed.

Issues should be referenced with the syntax `Fixes #123` or `Updates #123` to track that this change is related to an issue.

Make a change to the [CHANGELOG](CHANGELOG.md) to include a line item about your change, fix, or addition/feature.
