# Security Policy

At Hexabot, we take security very seriously and are committed to ensuring the safety and integrity of our project and its users. If you discover a vulnerability in our GitHub repository or any of our related services, we encourage you to report it as soon as possible.

## Supported Versions

| Version | Supported          |
| ------- | ------------------ |
| 2.x.x   | :white_check_mark: |

## Reporting a Vulnerability


To report a vulnerability, please send an email to community@hexabot.ai with the following details:

- A clear description of the vulnerability, including the affected version, component, or code.
- Steps to reproduce the vulnerability.
- Potential impact of the vulnerability.
- If applicable, any recommended mitigation steps.

## Response and Updates
Upon receiving your report, we will:

- Acknowledge receipt of your report within 48 hours.
- Conduct an initial review and provide you with an update on the status of your report within 7 business days. During this period, we may request additional information or clarification.
- Provide regular updates, at least every 14 days, regarding the progress of our investigation and any steps being taken.

## What to Expect After Reporting
If the vulnerability is accepted:

- We will begin working on a fix and notify you once the issue has been resolved.
- You will be credited for your discovery (if desired) in our public changelog or relevant security disclosures.
- The timeline for public disclosure will be discussed with you, but we aim to resolve most vulnerabilities within 30 days of acknowledgment.

If the vulnerability is declined:

- We will provide a detailed explanation as to why the issue does not qualify as a vulnerability or why it is not actionable at this time.
- You may still be acknowledged for your report, depending on the circumstances.

## Responsible Disclosure
We ask that you allow us sufficient time to investigate and patch the vulnerability before sharing any details publicly. We believe in responsible disclosure and appreciate your efforts in helping keep Hexabot secure.

Thank you for contributing to the security of Hexabot.

If you have any questions about this policy, feel free to reach out to us in our [Discord Server](https://discord.gg/rNb9t2MFkG).
