## How to contribute to Hexabot

#### **Did you find a bug?**

* **Do not open up a GitHub issue if the bug is a security vulnerability
  in Hexabot**, and instead send us an email to community@hexabot.ai.

* **Ensure the bug was not already reported** by searching on GitHub under [Issues](https://github.com/hexastack/hexabot/issues).

* If you're unable to find an open issue addressing the problem, [open a new one](https://github.com/hexastack/hexabot/issues/new). Be sure to include a **title and clear description**, as much relevant information as possible, and a **code sample** or an **executable test case** demonstrating the expected behavior that is not occurring.

#### **Did you write a patch that fixes a bug?**

* Open a new GitHub pull request with the patch.

* Ensure the PR description clearly describes the problem and solution. Include the relevant issue number if applicable.

#### **Did you fix whitespace, format code, or make a purely cosmetic patch?**

Changes that are cosmetic in nature and do not add anything substantial to the stability, functionality, or testability of Hexabot will generally not be accepted. Why ?
- Someone need to spend the time to review the patch. However trivial the changes might seem, there might be some subtle reasons the original code are written this way and any tiny changes have the possibility of altering behaviour and introducing bugs.
- It creates noise. Many poeple could be watching this repo at the time of writing – these people will get an email from github everytime someone opens a new issue, comment on a ticket, etc. They do this (probably) because they want to watch out for PRs and issues that they care about, and these PRs will further lower the signal-to-noise ratio in these notification emails.
- It pollutes the git history. When someone need to investigate a bug and git blame these lines in the future, they'll hit this "refactor" commit which is not very useful.
- It makes backporting bug fixes harder.
Theses are just some examples of the hidden costs that are not so apparent from the surface.

#### **Do you intend to add a new feature or change an existing one?**

* Suggest your change in our [Discord Channel](https://discord.gg/rNb9t2MFkG) and start writing code.

* Do not open an issue on GitHub until you have collected positive feedback about the change. GitHub issues are primarily intended for bug reports and fixes.

#### **Do you have questions about the source code?**

* Ask any question about how to use Hexabot in our [Discord Channel](https://discord.gg/rNb9t2MFkG).


Hexabot's Community Edition is a volunteer effort. We encourage you to pitch in and join us!

Thanks! :heart:

Hexastack Team
