﻿unit VK.Errors;

interface

uses
  System.Generics.Collections;

type
  TVkErrors = class(TDictionary<Integer, string>)
    procedure Fill;
    function Get(const Code: Integer; const Default: string = ''): string;
  end;

const
  //Error Codes
  VK_ERROR_UNKNOWN = 1;
  VK_ERROR_APP_OFF = 2;
  VK_ERROR_INVALID_METHOD = 3;
  VK_ERROR_INVALID_SIGNATURE = 4;
  VK_ERROR_INVALID_TOKEN = 5;
  VK_ERROR_REQUESTLIMIT = 6;
  VK_ERROR_APP_PERMISSIONS = 7;
  VK_ERROR_INVALID_QUERY = 8;
  VK_ERROR_TOO_MANY_SIMILAR_ACTIONS = 9;
  VK_ERROR_INTERNAL_SERVER = 10;
  VK_ERROR_TEST_MODE = 11;
  VK_ERROR_CAPTCHA = 14;
  VK_ERROR_ACCESS_DENIED = 15;
  VK_ERROR_ACCESS_DENIED_POST = 214;
  VK_ERROR_HTTPS_NEEDED = 16;
  VK_ERROR_VALIDATION_REQUIRED = 17;
  VK_ERROR_CONFIRM = 24;
  VK_ERROR_TOKEN_CONFIRM = 25;
  VK_ERROR_MORE_CONFIRM = 26;

var
  VkErrors: TVkErrors;

implementation

uses
  System.SysUtils, System.StrUtils;

{ TVkErrors }

procedure TVkErrors.Fill;
begin
  Add(VK_ERROR_UNKNOWN, 'Произошла неизвестная ошибка. Попробуйте повторить запрос позже');
  Add(VK_ERROR_APP_OFF, 'Приложение выключено. Необходимо включить приложение в настройках https://vk.com/editapp?id={Ваш API_ID} или использовать тестовый режим (test_mode=1)');
  Add(VK_ERROR_INVALID_METHOD, 'Передан неизвестный метод. Проверьте, правильно ли указано название вызываемого метода: https://vk.com/dev/methods');
  Add(VK_ERROR_INVALID_SIGNATURE, 'Неверная подпись');
  Add(VK_ERROR_INVALID_TOKEN, 'Авторизация пользователя не удалась. Убедитесь, что Вы используете верную схему авторизации');
  Add(VK_ERROR_REQUESTLIMIT, 'Слишком много запросов в секунду. Задайте больший интервал между вызовами или используйте метод execute. Подробнее об ограничениях на частоту вызовов см. на странице https://vk.com/dev/api_requests');
  Add(VK_ERROR_APP_PERMISSIONS, 'Нет прав для выполнения этого действия. Проверьте, получены ли нужные права доступа при авторизации. Это можно сделать с помощью метода account.getAppPermissions');
  Add(VK_ERROR_INVALID_QUERY, 'Неверный запрос. Проверьте синтаксис запроса и список используемых параметров (его можно найти на странице с описанием метода)');
  Add(VK_ERROR_TOO_MANY_SIMILAR_ACTIONS, 'Слишком много однотипных действий. Нужно сократить число однотипных обращений. Для более эффективной работы Вы можете использовать execute или JSONP');
  Add(VK_ERROR_INTERNAL_SERVER, 'Произошла внутренняя ошибка сервера. Попробуйте повторить запрос позже');
  Add(VK_ERROR_TEST_MODE, 'В тестовом режиме приложение должно быть выключено или пользователь должен быть залогинен. Выключите приложение в настройках https://vk.com/editapp?id={Ваш API_ID}');
  Add(VK_ERROR_CAPTCHA, 'Требуется ввод кода с картинки (Captcha)');
  Add(VK_ERROR_ACCESS_DENIED, 'Доступ запрещён. Убедитесь, что Вы используете верные идентификаторы, и доступ к контенту для текущего пользователя есть в полной версии сайта');
  Add(VK_ERROR_HTTPS_NEEDED, 'Требуется выполнение запросов по протоколу HTTPS, т.к. пользователь включил настройку, требующую работу через безопасное соединение'#13#10 +
    'Чтобы избежать появления такой ошибки, в Standalone-приложении Вы можете предварительно проверять состояние этой настройки у пользователя методом account.getInfo');
  Add(VK_ERROR_VALIDATION_REQUIRED, 'Требуется валидация пользователя. Действие требует подтверждения — необходимо перенаправить пользователя на служебную страницу для валидации');
  Add(18, 'Страница удалена или заблокирована. Страница пользователя была удалена или заблокирована');
  Add(19, 'Контент недоступен/Для сообщества заблокирована загрузка историй');
  Add(20, 'Данное действие запрещено для не Standalone приложений. Если ошибка возникает несмотря на то, что Ваше приложение имеет тип Standalone, убедитесь, что при авторизации Вы используете redirect_uri=https://oauth.vk.com/blank.html');
  Add(21, 'Данное действие разрешено только для Standalone и Open API приложений');
  Add(22, 'Ошибка загрузки');
  Add(23, 'Метод был выключен. Все актуальные методы ВК API, которые доступны в настоящий момент, перечислены здесь: https://vk.com/dev/methods');
  Add(VK_ERROR_CONFIRM, 'Требуется подтверждение со стороны пользователя');
  Add(27, 'Ключ доступа сообщества недействителен');
  Add(28, 'Ключ доступа приложения недействителен');
  Add(29, 'Достигнут количественный лимит на вызов метода Подробнее об ограничениях на количество вызовов см. на странице https://vk.com/dev/data_limits');
  Add(30, 'Профиль является приватным. Информация, запрашиваемая о профиле, недоступна с используемым ключом доступа');
  Add(33, 'Not implemented yet');
  Add(100, 'Один из необходимых параметров был не передан или неверен. Проверьте список требуемых параметров и их формат на странице с описанием метода');
  Add(101, 'Неверный API ID приложения. Найдите приложение в списке администрируемых на странице https://vk.com/apps?act=settings и укажите в запросе верный API_ID (идентификатор приложения)');
  Add(103, 'Превышено ограничение');
  Add(104, 'Not found');
  Add(113, 'Неверный идентификатор пользователя. Убедитесь, что Вы используете верный идентификатор. Получить ID по короткому имени можно методом utils.resolveScreenName');
  Add(114, 'Недопустимый идентификатор альбома');
  Add(118, 'Недопустимый сервер');
  Add(119, 'Недопустимое название');
  Add(121, 'Неверный хэш');
  Add(122, 'Неверные идентификаторы фотографий');
  Add(125, 'Неверный идентификатор группы');
  Add(129, 'Недопустимый формат фотографии');
  Add(140, 'Страница не найдена');
  Add(141, 'Нет доступа к странице');
  Add(148, 'Пользователь не установил приложение в левое меню');
  Add(150, 'Неверный timestamp. Получить актуальное значение Вы можете методом utils.getServerTime');
  Add(180, 'Заметка не найдена');
  Add(181, 'Нет доступа к заметке');
  Add(182, 'Вы не можете оставлять комментарии к этой заметке');
  Add(183, 'Нет доступа к комментарию');
  Add(200, 'Доступ к альбому запрещён. Убедитесь, что Вы используете верные идентификаторы (для пользователей owner_idположительный, для сообществ — отрицательный), и доступ к запрашиваемому контенту для текущего пользователя есть в полной версии сайта');
  Add(201, 'Доступ к аудио запрещён. Убедитесь, что Вы используете верные идентификаторы (для пользователей owner_idположительный, для сообществ — отрицательный), и доступ к запрашиваемому контенту для текущего пользователя есть в полной версии сайта');
  Add(203, 'Доступ к группе запрещён. Убедитесь, что текущий пользователь является участником или руководителем сообщества (для закрытых и частных групп и встреч)');
  Add(204, 'Нет доступа');
  Add(210, 'Нет доступа к записи');
  Add(211, 'Нет доступа к комментариям на этой стене');
  Add(212, 'Access to post comments denied');
  Add(214, 'Нет прав на добавление поста. Превышен лимит на число публикаций в сутки, либо на указанное время уже запланирована другая запись, либо для текущего пользователя недоступно размещение записи на этой стене');
  Add(219, 'Рекламный пост уже недавно добавлялся');
  Add(220, 'Слишком много получателей');
  Add(221, 'Пользователь выключил трансляцию названий аудио в статус');
  Add(222, 'Запрещено размещать ссылки');
  Add(224, 'Слишком много рекламных постов');
  Add(225, 'Донат отключен');
  Add(250, 'Нет доступа к опросу');
  Add(251, 'Недопустимый идентификатор опроса');
  Add(252, 'Недопустимый идентификатор ответа');
  Add(253, 'Access denied, please vote first');
  Add(260, 'Access to the groups list is denied due to the user''s privacy settings');
  Add(300, 'Альбом переполнен. Перед продолжением работы нужно удалить лишние объекты из альбома или использовать другой альбом');
  Add(302, 'Создано максимальное количество альбомов');
  Add(500, 'Действие запрещено. Вы должны включить переводы голосов в настройках приложения. Проверьте настройки приложения: https://vk.com/editapp?id={Ваш API_ID}&section=payments');
  Add(504, 'Not enough money on owner''s balance');
  Add(600, 'Нет прав на выполнение данных операций с рекламным кабинетом');
  Add(603, 'Произошла ошибка при работе с рекламным кабинетом');
  Add(700, 'Невозможно изменить полномочия создателя');
  Add(701, 'Пользователь должен состоять в сообществе');
  Add(702, 'Достигнут лимит на количество руководителей в сообществе');
  Add(703, 'You need to enable 2FA for this action');
  Add(704, 'Вы не можете назначить пользователя руководителем, если у Вас не подключена функция подтверждения входа');
  Add(706, 'Too many addresses in club');
  Add(711, 'Application is not installed in community');
  Add(800, 'Это видео уже добавлено');
  Add(801, 'Comments for this video are closed');
  Add(900, 'Нельзя отправлять сообщение пользователю из черного списка');
  Add(901, 'Пользователь не давал разрешения на отправку сообщений');
  Add(902, 'Нельзя отправлять сообщения этому пользователю в связи с настройками приватности');
  Add(907, 'Значение ts или pts слишком маленькое, получите новое значение');
  Add(908, 'Значение ts или pts слишком большое, получите новое значение');
  Add(909, 'Невозможно отредактировать сообщение после 24 часов');
  Add(910, 'Невозможно отредактировать сообщение, поскольку оно слишком большое');
  Add(911, 'Keyboard format is invalid');
  Add(912, 'This is a chat bot feature, change this status in settings');
  Add(913, 'Слишком много пересланных сообщений');
  Add(914, 'Сообщение слишком длинное');
  Add(917, 'У вас нет доступа в эту беседу');
  Add(919, 'Вам недоступны ссылки для приглашения в этот чат');
  Add(920, 'Невозможно отредактировать сообщение такого типа');
  Add(921, 'Невозможно переслать выбранные сообщения');
  Add(924, 'Невозможно удалить сообщение для получателей');
  Add(925, 'You are not admin of this chat');
  Add(931, 'You can''t change invite link for this chat');
  Add(932, 'Your community can''t interact with this peer');
  Add(935, 'Такого пользователя в чате нет');
  Add(936, 'Contact not found');
  Add(940, 'Too many posts in messages');
  Add(942, 'Cannot pin one-time story');
  Add(943, 'Cannot use this intent');
  Add(944, 'Limits overflow for this intent');
  Add(945, 'Chat was disabled');
  Add(946, 'Chat not supported');
  Add(949, 'Can''t edit pinned message yet');
  Add(950, 'Can''t send message, reply timed out');
  Add(1160, 'Оригинал фотографии был изменен');
  Add(1170, 'Слишком много списков новостей (максимум 10)');
  Add(1251, 'This achievement is already unlocked');
  Add(1260, 'Invalid screen name');
  Add(1310, 'Каталог не доступен для пользователя');
  Add(1311, 'Категории каталога не доступны для пользователя');
  Add(1400, 'Товар невозможно восстановить, прошло слишком много времени с момента удаления');
  Add(1401, 'Comments for this market are closed');
  Add(1402, 'Подборка с заданным идентификатором не найдена');
  Add(1403, 'Товар с заданным идентификатором не найден');
  Add(1404, 'Товар уже добавлен в выбранную подборку');
  Add(1405, 'Превышен лимит на количество товаров (15000)');
  Add(1406, 'Превышен лимит на количество товаров в подборке');
  Add(1407, 'Превышен лимит на количество подборок');
  Add(1408, 'Недопустимые ссылки в описании товара');
  Add(1409, 'Магазин не включен');
  Add(1416, 'Вариант не найден');
  Add(1417, 'Свойство не найдено');
  Add(1425, 'Grouping must have two or more items');
  Add(1426, 'Item must have distinct properties');
  Add(1427, 'Корзина пуста');
  Add(1429, 'Specify width, length, height and weight all together');
  Add(1430, 'VK Pay status can not be changed');
  Add(1431, 'Market was already enabled in this group');
  Add(1432, 'Market was already disabled in this group');
  Add(1600, 'Срок хранения истории истёк');
  Add(1602, 'Нельзя ответить на историю в связи с настройками приватности');
  Add(2000, 'Нельзя добавить больше 10 серверов');
  Add(3102, 'Specified link is incorrect (can''t find source)');
  Add(3300, 'Recaptcha needed');
  Add(3301, 'Phone validation needed');
  Add(3302, 'Password validation needed');
  Add(3303, 'Otp app validation needed');
  Add(3304, 'Требуется подтверждение Email');
  Add(3305, 'Assert votes');
  Add(7701, 'Total audio duration limit reached');
  Add(7702, 'Audio file is too big');
  Add(7703, 'Invalid hash');
  Add(7704, 'Task not found');
end;

function TVkErrors.Get(const Code: Integer; const Default: string): string;
begin
  if not TryGetValue(Code, Result) then
    Result := IfThen(Default.IsEmpty, 'Неизвестная ошибка', Default);
end;

initialization
  VkErrors := TVkErrors.Create;
  VkErrors.Fill;

finalization
  VkErrors.Free;

end.

