## I. Introduction

Are you already overwhelmed by the endless CRUD operations in your code? Frustrated with the need to install dependencies and set up environments just to build a simple webpage, followed by the never-ending updates?

OneFile is a single-file coding challenge designed to reignite your interest and joy in programming!

Write the code you want, using the simplest approach: **just one file**. Rediscover the original fun of programming.

## II. Requirements

When you step away from modern frameworks and libraries, your talent gets a chance to shine! If you have an idea, write it down—maybe all you need is just one file.

The **OneFile** programming challenge requires:

- A single, uncompressed file smaller than 1 MB
- Clear code structure with comments, under 5000 lines
- Any programming language (Markdown-only files are not allowed)
- No external files (images, videos, CSS, etc.)
- Complete functionality with educational or practical value
- (Optional) Can depend on at most one open-source library or framework

Accepted projects will be promoted through HelloGitHub's social media accounts (200,000+ followers), helping your project reach and be loved by more people.

In addition to submitting your own work, you can also share projects found online, but remember to credit the author and source.

## III. Submission

**Method 1**: Submit through the form: [Click Here](https://hellogithub.yuque.com/forms/share/4f0bf06b-2991-4f7e-a860-5b76337b7b5b)

**Method 2**: Submit via GitHub Pull Request:

1. Fork this project
2. Place your work in the `src/appropriate directory` directory according to the programming language
3. Submit a PR
4. Fill in the relevant information in the PR description
5. You'll receive a response within three days regarding whether your project has been accepted

Tips: [Click Here](https://docs.github.com/cn/pull-requests/collaborating-with-pull-requests/proposing-changes-to-your-work-with-pull-requests/creating-a-pull-request-from-a-fork) to learn how to create a PR.

## IV. Conclusion

Every project starts with a single file, evolving through iterations to become what you see today. The file you submit today is a seed.

> The best time to plant a tree was ten years ago. The second-best time is now.
