const fs = require('fs')
const render = require('json-templater/string')
const uppercamelcase = require('uppercamelcase')
const path = require('path')
const endOfLine = require('os').EOL

const components = fs.readdirSync(path.resolve(__dirname, '../../packages'))

const OUTPUT_PATH = path.join(__dirname, '../../src/index.js')
const IMPORT_TEMPLATE = 'import {{name}} from \'../packages/{{package}}/index\''
const INSTALL_COMPONENT_TEMPLATE = '  {{name}}'

const MAIN_TEMPLATE = `/**
 * Automatically generated by '/build/bin/build-entry.js'
 * CopyRight (C) HDVON.
 * Created by weibin on 2019/03/26
 */
import '@babel/polyfill'
{{include}}

const components = [
{{install}}
]

const install = function(Vue, opts = {}) {
  components.forEach(component => {
    // 使用vue-property-decorator后无法直接读取component.name，改用Vue.use
    // Vue.component(component.name, component)
    Vue.use(component)
  })
}

if (typeof window !== 'undefined' && window.Vue) {
  install(window.Vue)
} else if (typeof global !== 'undefined' && global.Vue) {
  install(global.Vue)
}

export default {
  install,
{{list}}
}
`
/**
 * 暂停自动生成d.ts文件的功能
 * @type {string}
 */
// const DECLARATION_IMPORT = 'import {{name}} from \'./{{package}}\''
// const DECLARATION_EXPORT = 'export class {{noPrefixName}} extends {{name}} {}'

// const DECLARATION_TEMPLATE = `/**
//  * Automatically generated by '/build/bin/build-entry.js'
//  * CopyRight (C) HDVON.
//  * Created by weibin on 2019/09/09
//  */
// import Vue from 'vue'
// import { HdCmpsComponent } from './component'
// {{importPath}}
//
// /**
//  * Install all hd-cmps components into Vue.
//  * Please do not invoke this method directly.
//  * Call \`Vue.use(HdCmps)\` to install.
//  */
// export function install (vue: typeof Vue, options: any): void
//
// /** HdCmps component common definition */
// export type Component = HdCmpsComponent
//
// {{exportPath}}
// `
//
// const OUTPUT_PATH_DECLARATION = path.join(__dirname, '../../types/hd-cmps.d.ts')

const OUTPUT_PATH_JSON = path.join(__dirname, '../../components.json')
const COMPONENT_JSON_TEMPLATE = `{
{{path}}
}
`

const includeComponentTemplate = []
const installTemplate = []
const listTemplate = []
const jsonTemplate = []
// const declarationImportTemplate = []
// const declarationExportTemplate = []

components.forEach(name => {
  const componentName = uppercamelcase(name)
  includeComponentTemplate.push(render(IMPORT_TEMPLATE, {
    name: componentName,
    package: name
  }))
  installTemplate.push(render(INSTALL_COMPONENT_TEMPLATE, {
    name: componentName
  }))
  listTemplate.push(`  ${componentName}`)
  jsonTemplate.push(`  "${name}": "./packages/${name}/index"`)
  // declarationImportTemplate.push(render(DECLARATION_IMPORT, {
  //   name: componentName,
  //   package: name
  // }))
  // declarationExportTemplate.push(render(DECLARATION_EXPORT, {
  //   noPrefixName: componentName.slice(2),
  //   name: componentName
  // }))
})

const template = render(MAIN_TEMPLATE, {
  include: includeComponentTemplate.join(endOfLine),
  install: installTemplate.join(',' + endOfLine),
  list: listTemplate.join(',' + endOfLine)
})

// const declarationTemplate = render(DECLARATION_TEMPLATE, {
//   importPath: declarationImportTemplate.join(endOfLine),
//   exportPath: declarationExportTemplate.join(endOfLine)
// })

// 创建单入口文件
fs.writeFileSync(OUTPUT_PATH, template)

// 创建component.json文件
fs.writeFileSync(OUTPUT_PATH_JSON, render(COMPONENT_JSON_TEMPLATE, {
  path: jsonTemplate.join(',' + endOfLine)
}))

// 创建d.ts文件
// fs.writeFileSync(OUTPUT_PATH_DECLARATION, declarationTemplate)
