<html>
<head>
	<script type="text/javascript">
	    var host = "kevingleason.me";
	    if ((host == window.location.host) && (window.location.protocol != "https:"))
	        window.location.protocol = "https";
	</script>
	<style>
		#vid-box{
			width: 100%;
			height: 100%;
			text-align: center;
		}
		
		#vid-box video{
			width: 100%;
			height: 100%;
		}
		
		#stream-info{
			position: absolute;
			bottom: 3vh;
			right: 5vw;
		}
		
		#stream-info img, #stream-info span {
			height: 30px;
			font-size: 30px;
			font-family: sans-serif;
			color: #777;
		}
	</style>
</head>
<body>
	<div id="vid-box"></div>
	<div id="stream-info"><img src="<?=base_url('resources/user/simplertc/');?>img/person_dark.png"/><span id="here-now">0</span></div>
</body>

<script src="https://cdn.pubnub.com/pubnub-3.7.14.min.js"></script>
<script src="<?=base_url('resources/user/simplertc/');?>js/webrtc.js"></script>
<script src="https://cdn.pubnub.com/webrtc/rtc-controller.js"></script>
<script>	
	
(function(){

var urlargs     = urlparams();
var video_out   = document.getElementById("vid-box");
var stream_info = document.getElementById("stream-info");
var here_now    = document.getElementById("here-now"); 

// Handle error if stream is not in urlargs.
if (!('stream' in urlargs)) {
	handleNoStream();
    return;
}
var stream = urlargs.stream;

var phone = window.phone = PHONE({
    number        : "EmbedViewer" + Math.floor(Math.random()*100), // listen on username line else random
    publish_key   : 'pub-c-561a7378-fa06-4c50-a331-5c0056d0163c', // Your Pub Key
    subscribe_key : 'sub-c-17b7db8a-3915-11e4-9868-02ee2ddab7fe', // Your Sub Key
    oneway        : true,
});
var ctrl = window.ctrl = CONTROLLER(phone);
ctrl.ready(function(){
	ctrl.isStreaming(stream, function(isOn){
		if (isOn) ctrl.joinStream(stream);
		else handleNoStream();
	}); 
});
ctrl.receive(function(session){
    session.connected(function(session){ stream_info.hidden=false; video_out.appendChild(session.video); });
    session.ended(function(session){ handleNoStream(); });
});
ctrl.streamPresence(function(m){
	here_now.innerHTML = m.occupancy;
});
ctrl.unable(function(){ handleNoStream(); });

// Get URL params
function urlparams() {
    var params = {};
    if (location.href.indexOf('?') < 0) return params;
    PUBNUB.each(
        location.href.split('?')[1].split('&'),
        function(data) { var d = data.split('='); params[d[0]] = d[1]; }
    );
    return params;
}

function handleNoStream(){
	video_out.innerHTML="<h2>That stream no longer exists!</h2>";
	stream_info.hidden=true;
}

}());

</script>
<script>
	(function(i,s,o,g,r,a,m){i['GoogleAnalyticsObject']=r;i[r]=i[r]||function(){
			(i[r].q=i[r].q||[]).push(arguments)},i[r].l=1*new
		Date();a=s.createElement(o),
		m=s.getElementsByTagName(o)[0];a.async=1;a.src=g;m.parentNode.insertBefore(a,m)
	})(window,document,'script','//www.google-analytics.com/analytics.js','ga');

	ga('create', 'UA-46933211-3', 'auto');
	ga('send', 'pageview');

</script>
