import i18n from 'i18next';
import { initReactI18next } from 'react-i18next';
import en from './en/en.json';
import ru from './ru/ru.json';

const resources = {
    en: {
        translation: en,
    },
    ru: {
        translation: ru,
    },
};

i18n.use(initReactI18next).init({
    resources,
    lng: 'en', // default language
    fallbackLng: 'en', // fallback language
    interpolation: {
        escapeValue: false, // react already escapes by default
    },
});

export default i18n;
