AST Metrisc report

## Overview

{% set mi="🔴" -%}
{%- if projectAggregated.Combined.MaintainabilityIndex.Avg > 84 -%}
    {% set mi="🟢" %}
{%- elif projectAggregated.Combined.MaintainabilityIndex.Avg > 64 -%}
    {% set mi="🟡" -%}
{%- endif -%}

> Maintainability index: {{ mi }} {{ projectAggregated.Combined.MaintainabilityIndex.Avg|floatformat:0 }}

| Language | LOC | Maintainability | Complexity per method | Average lines per method |
| --- | --- | --- | --- | --- |
{% for languageName,language in projectAggregated.ByProgrammingLanguage -%}
{%- set mi="🔴" -%}
{%- if language.MaintainabilityIndex.Avg > 84 -%}
    {% set mi="🟢" %}
{%- elif language.MaintainabilityIndex.Avg > 64 -%}
    {% set mi="🟡" -%}
{%- endif -%}
| **{{ languageName }}** | {{ language.Loc.Sum|stringifyNumber }} | {{ mi }} {{ language.MaintainabilityIndex.Avg | floatformat:0 }} | {{ language.CyclomaticComplexityPerMethod.Avg | floatformat:2 }} | {{ language.LocPerMethod.Avg | floatformat:0 }} |
{%- endfor %}

> 💡 Help
>
> - **LOC**: The number of lines of code.
> - **Complexity per method**: The average complexity of the code, measured by the number of possible execution paths. Lower is better.
> - **Average lines per method**: Long methods are hard to maintain and understand. Ideally, should be lower than 20.
> - **Maintainability**: Based on the volume, the complexity of operators and the complexity of the code. Ideally, should be higher than 85.

## Candidates for refactoring

These components have a low maintainability index and have been recently modified. They are good candidates for refactoring.

| File | Risk | Maintainability | Commits |
| --- | --- | --- | --- |
{%- set files = projectAggregated.Combined.ConcernedFiles|sortRisk -%}
{%- if files|length == 0 -%}
| No component with high risk found |
{%- else -%}
    {%- for file in files -%}
        {%- if len(file.Stmts.StmtClass) == 0 %}
| {{ file.Path }} | {{ file.Stmts.Analyze.Risk.Score|floatformat:2 }} | {{ file.Stmts.Analyze.Maintainability.MaintainabilityIndex|floatformat:0 }} | {{ file.Commits.Count }} |
        {%- else -%}
            {%- for class in file.Stmts.StmtClass %}
| {{ class.Name.Qualified }} | {{ class.Stmts.Analyze.Risk.Score|floatformat:2 }} | {{ class.Stmts.Analyze.Maintainability.MaintainabilityIndex|floatformat:0 }} | {{ file.Commits.Count }} |
            {%- endfor -%}
        {%- endif -%}
    {%- endfor -%}
{%- endif %}

## Activity

| Languages |Commits | Bus Factor | Top contributors |
| --- | --- | --- | --- |
{% for languageName,language in projectAggregated.ByProgrammingLanguage -%}
| **{{ languageName }}** | {{ language.CommitCountForPeriod }} | {{ language.BusFactor }} | {% for contributor in language.TopCommitters -%}
{{ contributor.Name }} ({{ contributor.Count }}) {% if not loop.last %}, {% endif %} |
{%- endfor %}
{%- endfor %}

> 
> 💡 Help
>
> - **Bus Factor**: The bus factor is the number of developers that would need to be incapacitated before a project would stall due to insufficient knowledge or skills.Ideally, should be higher than 3.
> - **Top contributors**: The developers that have contributed the most to the project. It's important to have a diverse group of contributors to avoid the bus factor.
> - **Commits**: The number of commits in the last 12 months. A high number of commits can indicate a high level of activity, but it can also indicate a high level of churn.


## Improve this report

This report is generated by [AST Metrics](https://github.com/Halleck45/ast-metrics/), a tool that analyzes the maintainability of your code, created by [Jean-François Lépine](https://blog.lepine.pro/).

Feel free to contribute to the project, report issues or suggest new features. The source code is available on [GitHub](https://github.com/Halleck45/ast-metrics/).

Thank you for using AST Metrics! 
