# `datepicker` (component)

General datepicker component.

| name                         | type                           | default value   | description                                                                                                                                                                                                                                                                                                          |
| ---------------------------- | ------------------------------ | --------------- | -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| `allowSameDay`               | `bool`                         | `false`         |                                                                                                                                                                                                                                                                                                                      |
| `ariaDescribedBy`            | `string`                       | `null`          |                                                                                                                                                                                                                                                                                                                      |
| `ariaInvalid`                | `string`                       | `null`          |                                                                                                                                                                                                                                                                                                                      |
| `ariaLabelledBy`             | `string`                       | `null`          |                                                                                                                                                                                                                                                                                                                      |
| `ariaRequired`               | `string`                       | `null`          |                                                                                                                                                                                                                                                                                                                      |
| `autoComplete`               | `string`                       |                 |                                                                                                                                                                                                                                                                                                                      |
| `autoFocus`                  | `bool`                         |                 |                                                                                                                                                                                                                                                                                                                      |
| `calendarClassName`          | `string`                       |                 |                                                                                                                                                                                                                                                                                                                      |
| `children`                   | `node`                         |                 |                                                                                                                                                                                                                                                                                                                      |
| `className`                  | `string`                       |                 |                                                                                                                                                                                                                                                                                                                      |
| `clearButtonTitle`           | `string`                       |                 |                                                                                                                                                                                                                                                                                                                      |
| `clearButtonClassName`       | `string`                       |                 | Customize the clear button                                                                                                                                                                                                                                                                                           |
| `customInput`                | `element`                      |                 |                                                                                                                                                                                                                                                                                                                      |
| `customInputRef`             | `string`                       | `'ref'`         | The property used to pass the ref callback                                                                                                                                                                                                                                                                           |
| `dateFormat`                 | `union(string\|array)`         | `'MM/dd/yyyy'`  |                                                                                                                                                                                                                                                                                                                      |
| `dateFormatCalendar`         | `string`                       | `'LLLL yyyy'`   |                                                                                                                                                                                                                                                                                                                      |
| `dayClassName`               | `func`                         |                 |                                                                                                                                                                                                                                                                                                                      |
| `weekDayClassName`           | `func`                         |                 |                                                                                                                                                                                                                                                                                                                      |
| `yearClassName`              | `func`                         |                 |                                                                                                                                                                                                                                                                                                                      |
| `disabled`                   | `bool`                         | `false`         |                                                                                                                                                                                                                                                                                                                      |
| `disabledKeyboardNavigation` | `bool`                         | `false`         |                                                                                                                                                                                                                                                                                                                      |
| `dropdownMode` (required)    | `enum('scroll'\|'select')`     | `'scroll'`      |                                                                                                                                                                                                                                                                                                                      |
| `endDate`                    | `instanceOf(Date)`             |                 |                                                                                                                                                                                                                                                                                                                      |
| `excludeDates`               | `array`                        |                 |                                                                                                                                                                                                                                                                                                                      |
| `excludeDateIntervals`       | `array`                        |                 |                                                                                                                                                                                                                                                                                                                      |
| `excludeTimes`               | `array`                        |                 |                                                                                                                                                                                                                                                                                                                      |
| `excludeScrollbar`           | `array`                        |                 |                                                                                                                                                                                                                                                                                                                      |
| `filterDate`                 | `func`                         |                 |                                                                                                                                                                                                                                                                                                                      |
| `filterTime`                 | `func`                         |                 |                                                                                                                                                                                                                                                                                                                      |
| `fixedHeight`                | `bool`                         |                 |                                                                                                                                                                                                                                                                                                                      |
| `focusSelectedMonth`         | `bool`                         | `false`         |                                                                                                                                                                                                                                                                                                                      |
| `forceShowMonthNavigation`   | `bool`                         |                 |                                                                                                                                                                                                                                                                                                                      |
| `formatWeekNumber`           | `func`                         |                 |                                                                                                                                                                                                                                                                                                                      |
| `highlightDates`             | `array`                        |                 |                                                                                                                                                                                                                                                                                                                      |
| `holidays`                   | `array`                        |                 | The list of holidays. An array consisting of `date(yyyy-mm-dd)` and `holidayName`, For example: holidays={[{date: '2023-08-15',holidayName:"Holiday 1"},{date: '2023-12-31',holidayName:"Holiday 2"}]}. If multiple unique holiday names are provided for same date, it will display both in comma separated string. |
| `id`                         | `string`                       |                 |                                                                                                                                                                                                                                                                                                                      |
| `includeDates`               | `array`                        |                 |                                                                                                                                                                                                                                                                                                                      |
| `includeDateIntervals`       | `array`                        |                 |                                                                                                                                                                                                                                                                                                                      |
| `includeTimes`               | `array`                        |                 |                                                                                                                                                                                                                                                                                                                      |
| `injectTimes`                | `array`                        |                 |                                                                                                                                                                                                                                                                                                                      |
| `inline`                     | `bool`                         |                 |                                                                                                                                                                                                                                                                                                                      |
| `isClearable`                | `bool`                         |                 |                                                                                                                                                                                                                                                                                                                      |
| `locale`                     | `string`                       |                 |                                                                                                                                                                                                                                                                                                                      |
| `maxDate`                    | `instanceOf(Date)`             |                 |                                                                                                                                                                                                                                                                                                                      |
| `maxTime`                    | `instanceOf(Date)`             |                 |                                                                                                                                                                                                                                                                                                                      |
| `minDate`                    | `instanceOf(Date)`             |                 |                                                                                                                                                                                                                                                                                                                      |
| `minTime`                    | `instanceOf(Date)`             |                 |                                                                                                                                                                                                                                                                                                                      |
| `monthsShown`                | `number`                       | `1`             |                                                                                                                                                                                                                                                                                                                      |
| `name`                       | `string`                       |                 |                                                                                                                                                                                                                                                                                                                      |
| `onBlur`                     | `func`                         | `function() {}` |                                                                                                                                                                                                                                                                                                                      |
| `onCalendarClose`            | `func`                         |                 |                                                                                                                                                                                                                                                                                                                      |
| `onCalendarOpen`             | `func`                         |                 |                                                                                                                                                                                                                                                                                                                      |
| `onChange` (required)        | `func`                         | `function() {}` |                                                                                                                                                                                                                                                                                                                      |
| `onChangeRaw`                | `func`                         |                 |                                                                                                                                                                                                                                                                                                                      |
| `onClickOutside`             | `func`                         | `function() {}` |                                                                                                                                                                                                                                                                                                                      |
| `onFocus`                    | `func`                         | `function() {}` |                                                                                                                                                                                                                                                                                                                      |
| `onKeyDown`                  | `func`                         | `function() {}` |                                                                                                                                                                                                                                                                                                                      |
| `onMonthChange`              | `func`                         | `function() {}` |                                                                                                                                                                                                                                                                                                                      |
| `onSelect`                   | `func`                         | `function() {}` |                                                                                                                                                                                                                                                                                                                      |
| `onWeekSelect`               | `func`                         |                 |                                                                                                                                                                                                                                                                                                                      |
| `onYearChange`               | `func`                         | `function() {}` |                                                                                                                                                                                                                                                                                                                      |
| `openToDate`                 | `instanceOf(Date)`             |                 |                                                                                                                                                                                                                                                                                                                      |
| `peekNextMonth`              | `bool`                         |                 |                                                                                                                                                                                                                                                                                                                      |
| `placeholderText`            | `string`                       |                 |                                                                                                                                                                                                                                                                                                                      |
| `popperClassName`            | `string`                       |                 |                                                                                                                                                                                                                                                                                                                      |
| `popperContainer`            | `func`                         |                 |
|                              |
| `popperModifiers`            | `object`                       |                 |                                                                                                                                                                                                                                                                                                                      |
| `popperPlacement`            | `enumpopperPlacementPositions` |                 |                                                                                                                                                                                                                                                                                                                      |
| `preventOpenOnFocus`         | `bool`                         | false           | When this is true, the datepicker will not automatically open when the date field is focused                                                                                                                                                                                                                        |
| `readOnly`                   | `bool`                         |                 |                                                                                                                                                                                                                                                                                                                      |
| `required`                   | `bool`                         |                 |                                                                                                                                                                                                                                                                                                                      |
| `scrollableYearDropdown`     | `bool`                         |                 |                                                                                                                                                                                                                                                                                                                      |
| `selected`                   | `instanceOf(Date)`             |                 |                                                                                                                                                                                                                                                                                                                      |
| `selectsEnd`                 | `bool`                         |                 |                                                                                                                                                                                                                                                                                                                      |
| `selectsStart`               | `bool`                         |                 |                                                                                                                                                                                                                                                                                                                      |
| `shouldCloseOnSelect`        | `bool`                         | `true`          |                                                                                                                                                                                                                                                                                                                      |
| `showMonthDropdown`          | `bool`                         |                 |                                                                                                                                                                                                                                                                                                                      |
| `showTimeSelect`             | `bool`                         | `false`         |                                                                                                                                                                                                                                                                                                                      |
| `showWeekNumbers`            | `bool`                         |                 |                                                                                                                                                                                                                                                                                                                      |
| `showYearDropdown`           | `bool`                         |                 |                                                                                                                                                                                                                                                                                                                      |
| `startDate`                  | `instanceOf(Date)`             |                 |                                                                                                                                                                                                                                                                                                                      |
| `startOpen`                  | `bool`                         |                 |                                                                                                                                                                                                                                                                                                                      |
| `tabIndex`                   | `number`                       |                 |                                                                                                                                                                                                                                                                                                                      |
| `timeClassName`              | `func`                         |                 |                                                                                                                                                                                                                                                                                                                      |
| `timeFormat`                 | `string`                       |                 |                                                                                                                                                                                                                                                                                                                      |
| `timeIntervals`              | `number`                       | `30`            |                                                                                                                                                                                                                                                                                                                      |
| `title`                      | `string`                       |                 |                                                                                                                                                                                                                                                                                                                      |
| `todayButton`                | `node`                         |                 |                                                                                                                                                                                                                                                                                                                      |
| `useWeekdaysShort`           | `bool`                         |                 |                                                                                                                                                                                                                                                                                                                      |
| `utcOffset`                  | `union(number\|string)`        |                 |                                                                                                                                                                                                                                                                                                                      |
| `value`                      | `string`                       |                 |                                                                                                                                                                                                                                                                                                                      |
| `weekLabel`                  | `string`                       |                 |                                                                                                                                                                                                                                                                                                                      |
| `withPortal`                 | `bool`                         | `false`         |                                                                                                                                                                                                                                                                                                                      |
| `portalId`                   | `string`                       |                 |                                                                                                                                                                                                                                                                                                                      |
| `portalHost`                 | `instanceOf(ShadowRoot)`       |                 | When set, portals will be attached to this ShadowRoot instead of the document body.                                                                                                                                                                                                                                  |
| `wrapperClassName`           | `string`                       |
|                              |
| `yearItemNumber`             | `number`                       | `12`            |                                                                                                                                                                                                                                                                                                                      |
| `yearDropdownItemNumber`     | `number`                       |                 |                                                                                                                                                                                                                                                                                                                      |
| `icon`                       | `string` or `element`          |                 | Allows using a custom calendar icon. Accepts a string (icon class name) or a React component (e.g., custom SVG). If a string is passed, an `<i>` element is rendered with that string as its class name. If a React component is passed, it is rendered as-is.                                                       |
| `calendarIconClassname`      | `string`                       |                 | this props is deprecated. should use calendarIconClassName props.                                                                                                                                                                                                                                                    |
| `calendarIconClassName`      | `string`                       |                 | Accepts a string that will be added as an additional CSS class to the calendar icon, allowing further styling customization.                                                                                                                                                                                         |
| `showIcon`                   | `bool`                         | `true`          | Determines whether the calendar icon is displayed. Set to `true` to display the icon, and `false` to hide it. If `icon` prop is also provided, the custom icon will be displayed when `showIcon` is `true`.                                                                                                          |
| `usePointerEvent`            | `bool`                         | false           | True if Pointer Events (e.g, onPointerEnter, onPointerLeave) are used internally instead of Mouse Events (e.g, onMouseEnter, onMouseLeave).                                                                                                                                                                          |
