# 更多示例

## 顺序

伪代码：

```
first;
second;
third;
```

流程图：

```
 +-----------+ 
 |   first   | 
 +-----------+ 
       |       
       V       
+-------------+
|    second   |
+-------------+
       |       
       V       
 +-----------+ 
 |   third   | 
 +-----------+ 
```

## 分支

伪代码：

```
if (cond) {
    do this;
}
```

流程图：

```
 /-----------\ N   
 |    cond   |----+
 \-----------/    |
       | Y        |
       V          |
+-------------+   |
|   do this   |   |
+-------------+   |
       |          |
       V          |
       O<---------+
```

伪代码：

```
if (cond) {
    ok;
}
else {
    no;
}
```

流程图：

```
       Y /-----------\ N       
     +---|    cond   |---+     
     |   \-----------/   |     
     |                   |     
     V                   V     
+---------+         +---------+
|    ok   |         |    no   |
+---------+         +---------+
     |                   |     
     +-------->O<--------+     
```

## 循环

伪代码：

```
while (at home) {
    sleep;
}
```

流程图：

```
  N /-------------\    
+---|   at home   |<--+
|   \-------------/   |
|          | Y        |
|          V          |
|    +-----------+    |
|    |   sleep   |----+
|    +-----------+     
|                      
|                      
+--------->O           
```

