# **Data Guardian**

**Data Guardian** is a backup tool designed specifically for **Linux users**. It continuously monitors your files for any new updates and immediately backs them up while maintaining previous versions for easy recovery. This ensures that your important files are always up to date and securely stored.

## **Features**
- **Version Backup:** Keep multiple versions of your files, allowing for easy restoration of previous states.  
- **Continuous File Monitoring:** Automatically scans for new or updated files and performs immediate backups, ensuring that your data is always protected.  
- **Real-Time Backup:** As files are modified or added, backups are performed immediately, ensuring the most current data is always protected.  
- **Backup Resumption:** If a backup is interrupted by user action, shutdown, restart, sleep, etc., the backup state is saved and will continue the next time the PC is powered on.  

## **How It Works**
- **Data Processing:** The tool continuously monitors file changes (hours, folders accessed, and file sizes) to identify new or updated files.  
- **Version Management:** Automatically keeps track of file versions, allowing users to restore previous versions easily.  
- **Saving and Adjusting:** Continuously saves backup data in the database, ensuring that all changes are reflected in the backup history.  

## **Progress**
- **Backup**: ⬛⬛⬛⬛⬛⬛⬛⬛⬛⬜ (90% complete)  
- **Restore**: ⬛⬛⬛⬛⬜⬜⬜⬜⬜⬜ (40% complete)  
- **Version Management**: ⬛⬛⬛⬛⬛⬛⬛⬛⬜⬜ (80% complete)  
- **UI Enhancements**: ⬛⬛⬛⬛⬛⬛⬛⬜⬜⬜ (70% complete)
- **Restore Files UI**: ⬜⬜⬜⬜⬜⬜⬜⬜⬜⬜ (0% complete)
- **Migration Assistant**: ⬜⬜⬜⬜⬜⬜⬜⬜⬜⬜ (0% complete)

## **Installation**
$ flatpak-builder --force-clean --user --install repo com.gnome.dataguardian.yaml 
