"""
Read the explanation: http://stackoverflow.com/a/44078249/7982356
Both running time and space usage are linear, O(n).
"""

def find_max_recursively(S, n):
    """Find the maximum element in a sequence S, of n elements."""
    if n == 1:  # reached the left most item
        return S[n-1]
    else:
        previous = find_max_recursively(S, n-1)
        current = S[n-1]
        if previous > current:
            return previous
        else:
            return current


if __name__ == '__main__':
    print(find_max_recursively([5, 10, 20, 11, 3], 5))
