<?php
        /*
		 * Note that `is_user_logged_in()` will return false immediately after logging in
		 * as the current user is not set, see gc-includes/pluggable.php.
		 * However this action runs on a redirect after logging in.
		 */
		if ( ! is_user_logged_in() ) {
			gc_safe_redirect( gc_login_url() );
			exit;
		}

		if ( ! empty( $_REQUEST['redirect_to'] ) ) {
			$redirect_to = $_REQUEST['redirect_to'];
		} else {
			$redirect_to = admin_url();
		}

		if ( current_user_can( 'manage_options' ) ) {
			$admin_email = get_option( 'admin_email' );
		} else {
			gc_safe_redirect( $redirect_to );
			exit;
		}

		/**
		 * Filters the interval for dismissing the admin email confirmation screen.
		 *
		 * If `0` (zero) is returned, the "Remind me later" link will not be displayed.
		 *
		 * @param int $interval Interval time (in seconds). Default is 3 days.
		 */
		$remind_interval = (int) apply_filters( 'admin_email_remind_interval', 3 * DAY_IN_SECONDS );

		if ( ! empty( $_GET['remind_me_later'] ) ) {
			if ( ! gc_verify_nonce( $_GET['remind_me_later'], 'remind_me_later_nonce' ) ) {
				gc_safe_redirect( gc_login_url() );
				exit;
			}

			if ( $remind_interval > 0 ) {
				update_option( 'admin_email_lifespan', time() + $remind_interval );
			}

			$redirect_to = add_query_arg( 'admin_email_remind_later', 1, $redirect_to );
			gc_safe_redirect( $redirect_to );
			exit;
		}

		if ( ! empty( $_POST['correct-admin-email'] ) ) {
			if ( ! check_admin_referer( 'confirm_admin_email', 'confirm_admin_email_nonce' ) ) {
				gc_safe_redirect( gc_login_url() );
				exit;
			}

			/**
			 * Filters the interval for redirecting the user to the admin email confirmation screen.
			 *
			 * If `0` (zero) is returned, the user will not be redirected.
			 *
		
			 *
			 * @param int $interval Interval time (in seconds). Default is 6 months.
			 */
			$admin_email_check_interval = (int) apply_filters( 'admin_email_check_interval', 6 * MONTH_IN_SECONDS );

			if ( $admin_email_check_interval > 0 ) {
				update_option( 'admin_email_lifespan', time() + $admin_email_check_interval );
			}

			gc_safe_redirect( $redirect_to );
			exit;
		}

		login_header( __( '确认您的管理员电子邮箱' ), '', $errors );

		/**
		 * Fires before the admin email confirm form.
		 *
		 * @param GC_Error $errors A `GC_Error` object containing any errors generated by using invalid
		 *                         credentials. Note that the error object may not contain any errors.
		 */
		do_action( 'admin_email_confirm', $errors );

		?>

		<form class="admin-email-confirm-form" name="admin-email-confirm-form" action="<?php echo esc_url( site_url( 'gc-login.php?action=confirm_admin_email', 'login_post' ) ); ?>" method="post">
			<?php
			/**
			 * Fires inside the admin-email-confirm-form form tags, before the hidden fields.
			 *
		
			 */
			do_action( 'admin_email_confirm_form' );

			gc_nonce_field( 'confirm_admin_email', 'confirm_admin_email_nonce' );

			?>
			<input type="hidden" name="redirect_to" value="<?php echo esc_attr( $redirect_to ); ?>" />

			<h1 class="admin-email__heading">
				<?php _e( '管理员邮件确认' ); ?>
			</h1>
			<p class="admin-email__details">
				<?php _e( '请确认此系统的<strong>管理员电子邮箱</strong>仍然正确。' ); ?>
				<?php

				/* translators: URL to the GeChiUI help section about admin email. */
				$admin_email_help_url = __( 'https://www.gechiui.com/support/settings-general-screen/#email-address' );

				/* translators: Accessibility text. */
				$accessibility_text = sprintf( '<span class="screen-reader-text"> %s</span>', __( '（在新窗口中打开）' ) );

				printf(
					'<a href="%s" rel="noopener" target="_blank">%s%s</a>',
					esc_url( $admin_email_help_url ),
					__( '为什么这很重要？' ),
					$accessibility_text
				);

				?>
			</p>
			<p class="admin-email__details">
				<?php

				printf(
					/* translators: %s: Admin email address. */
					__( '当前的管理员电子邮箱为：%s' ),
					'<strong>' . esc_html( $admin_email ) . '</strong>'
				);

				?>
			</p>
			<p class="admin-email__details">
				<?php _e( '此电子邮箱可能和您个人的电子邮箱不同。' ); ?>
			</p>

			<div class="admin-email__actions">
				<div class="admin-email__actions-primary">
					<?php

					$change_link = admin_url( 'options-general.php' );
					$change_link = add_query_arg( 'highlight', 'confirm_admin_email', $change_link );

					?>
					<a class="btn btn-primary btn-sm" href="<?php echo esc_url( $change_link ); ?>"><?php _e( '更新' ); ?></a>
					<input type="submit" name="correct-admin-email" id="correct-admin-email" class="btn btn-primary button-large" value="<?php esc_attr_e( '此电子邮箱正确' ); ?>" />
				</div>
				<?php if ( $remind_interval > 0 ) : ?>
					<div class="admin-email__actions-secondary">
						<?php

						$remind_me_link = gc_login_url( $redirect_to );
						$remind_me_link = add_query_arg(
							array(
								'action'          => 'confirm_admin_email',
								'remind_me_later' => gc_create_nonce( 'remind_me_later_nonce' ),
							),
							$remind_me_link
						);

						?>
						<a href="<?php echo esc_url( $remind_me_link ); ?>"><?php _e( '稍后提醒我' ); ?></a>
					</div>
				<?php endif; ?>
			</div>
		</form>

		<?php