
<?php
/**
 * Title: 卡片 Cards
 * Slug: gcoa/cards
 * Categories: ui-elements
 * Keywords: 卡片 Cards
 * Block Types: core/html
 */
?>
<!-- gc:html -->
<div class="page-header">
    <h2 class="header-title">卡片</h2>
    <div class="header-sub-title">
        <nav class="breadcrumb breadcrumb-dash">
            <a href="#" class="breadcrumb-item"><i class="anticon anticon-home m-r-5"></i>首页</a>
            <a class="breadcrumb-item" href="#">UI元素</a>
            <span class="breadcrumb-item active">卡片</span>
        </nav>
    </div>
</div>
<div class="card">
    <div class="card-body">
        <h4>基础卡片</h4>
        <p>卡片的class样式是 <code>.card-body</code>. 在这个卡片里充填内容.</p>
        <div class="m-t-25">
            <div class="card" style="max-width: 300px">
                <div class="card-body">
                    <p>格尺AI的智能营销系统是基于AI驱动，以大数据为中心的平台，该平台可在您所有面向客户的营销团队中收集，同步和管理数据，从而获得可带来收入的见解。换句话说，收入情报。</p>
                    <p>格尺AI自动执行手动数据输入，提高销售效率，并在我们所有的管理工具中提供可行的情报。</p>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="card">
    <div class="card-body">
        <h4>卡片添加标题</h4>
        <div class="m-t-25">
            <div class="card" style="max-width: 350px">
                <div class="card-header">
                    <h4 class="card-title">卡片标题</h4>
                </div>
                <div class="card-body">
                    <p>格尺AI的智能营销系统是基于AI驱动，以大数据为中心的平台，该平台可在您所有面向客户的营销团队中收集，同步和管理数据，从而获得可带来收入的见解。换句话说，收入情报。</p>
                    <p>格尺AI自动执行手动数据输入，提高销售效率，并在我们所有的管理工具中提供可行的情报。</p>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="card">
    <div class="card-body">
        <h4>卡片添加内部标题</h4>
        <div class="m-t-25">
            <div class="card" style="max-width: 350px">
                <div class="card-body">
                    <h4>卡片标题</h4>
                    <p>格尺AI的智能营销系统是基于AI驱动，以大数据为中心的平台，该平台可在您所有面向客户的营销团队中收集，同步和管理数据，从而获得可带来收入的见解。换句话说，收入情报。</p>
                    <p>格尺AI自动执行手动数据输入，提高销售效率，并在我们所有的管理工具中提供可行的情报。</p>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="card">
    <div class="card-body">
        <h4>卡片添加页脚</h4>
        <div class="m-t-25">
            <div class="card" style="max-width: 350px">
                <div class="card-body">
                    <h4>卡片标题</h4>
                    <p>格尺AI的智能营销系统是基于AI驱动，以大数据为中心的平台，该平台可在您所有面向客户的营销团队中收集，同步和管理数据，从而获得可带来收入的见解。换句话说，收入情报。</p>
                    <p>格尺AI自动执行手动数据输入，提高销售效率，并在我们所有的管理工具中提供可行的情报。</p>
                </div>
                <div class="card-footer">
                    <div class="text-right">
                        <button class="btn btn-default m-r-5">取消</button>
                        <button class="btn btn-primary">接受</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="card">
    <div class="card-body">
        <h4>卡片添加工具条</h4>
        <div class="m-t-25">
            <div class="card" style="max-width: 500px">
                <div class="card-body">
                    <div class="d-flex align-items-center justify-content-between m-b-15">
                        <h4 class="m-b-0">卡片标题</h4>
                        <div class="card-toolbar">
                            <ul>
                                <li>
                                    <a class="text-gray" href="javascript:void(0)">
                                        <i class="anticon anticon-reload font-size-20"></i>
                                    </a>
                                </li>
                                <li>
                                    <a class="text-gray" href="javascript:void(0)">
                                        <i class="anticon anticon-book font-size-20"></i>
                                    </a>
                                </li>
                                <li>
                                    <a class="text-gray" href="javascript:void(0)">
                                        <i class="anticon anticon-ellipsis font-size-20"></i>
                                    </a>
                                </li>
                            </ul>
                        </div>
                    </div>
                    <p>Put toy mouse in food bowl run out of litter box at full speed drool but pee in the shoe purr when being pet but chew foot.</p>
                    <p>Scratch the postman wake up lick paw wake up owner meow meow lick plastic bags so cat not kitten around meow all night having their mate disturbing sleeping humans.</p>
                    <p>Try to jump onto window and fall while scratching at wall ignore the squirrels, you'll never catch them anyway cat snacks. Cough furball cat not kitten around chew iPad power cord.</p>                                  
                </div>
            </div>
        </div>
    </div>
</div>
<div class="card">
    <div class="card-body">
        <h4>卡片添加列表</h4>
        <div class="m-t-25">
            <div class="card" style="max-width: 350px">
                <div class="card-header border-bottom">
                    <h4 class="card-title">卡片标题</h4>
                </div>
                <div class="card-body p-0">
                    <ul class="list-group list-group-flush">
                        <li class="list-group-item">
                            <div class="d-flex align-items-center">
                                <div class="avatar avatar-image">
                                    <img src="<?php echo get_template_directory_uri(); ?>/assets/images/avatars/thumb-1.jpg" alt="">
                                </div>
                                <div class="m-l-10">
                                    <div class="m-b-0 text-dark font-weight-semibold">安子轩</div>
                                    <div class="m-b-0 opacity-07 font-size-13">commented on your post's</div>
                                </div>
                            </div>
                        </li>
                        <li class="list-group-item">
                            <div class="d-flex align-items-center">
                                <div class="avatar avatar-image">
                                    <img src="<?php echo get_template_directory_uri(); ?>/assets/images/avatars/thumb-2.jpg" alt="">
                                </div>
                                <div class="m-l-10">
                                    <div class="m-b-0 text-dark font-weight-semibold">达里尔</div>
                                    <div class="m-b-0 opacity-07 font-size-13">commented on your post's</div>
                                </div>
                            </div>
                        </li>
                        <li class="list-group-item">
                            <div class="d-flex align-items-center">
                                <div class="avatar avatar-image">
                                    <img src="<?php echo get_template_directory_uri(); ?>/assets/images/avatars/thumb-3.jpg" alt="">
                                </div>
                                <div class="m-l-10">
                                    <div class="m-b-0 text-dark font-weight-semibold">阿七</div>
                                    <div class="m-b-0 opacity-07 font-size-13">commented on your post's</div>
                                </div>
                            </div>
                        </li>
                    </ul>
                    <div class="card-footer">
                        <div class="text-center m-t-5">
                            <a href="" class="text-gray">查看更多</a>
                        </div>
                    </div>          
                </div>
            </div>
        </div>
    </div>
</div>
<div class="card">
    <div class="card-body">
        <h4>多媒体卡片</h4>
        <div class="m-t-25">
            <div class="card" style="max-width: 370px">
                <img class="card-img-top" src="<?php echo get_template_directory_uri(); ?>/assets/images/others/img-5.jpg" alt="">
                <div class="card-body">
                    <h4 class="m-t-10">卡片标题</h4>
                    <p class="card-text">Put toy mouse in food bowl run out of litter box at full speed drool but pee in the shoe purr when being pet but chew foot. </p>
                    <div class="m-t-20">
                        <a href="" class="btn btn-primary">动作 1</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="card">
    <div class="card-body">
        <h4>多媒体卡片添加工具条</h4>
        <div class="m-t-25">
            <div class="card" style="max-width: 370px">
                <div class="bg-overlay">
                    <div class="card-toolbar">
                        <ul>
                            <li>
                                <a class="text-white" href="javascript:void(0)">
                                    <i class="anticon anticon-reload font-size-20"></i>
                                </a>
                            </li>
                            <li>
                                <a class="text-white" href="javascript:void(0)">
                                    <i class="anticon anticon-book font-size-20"></i>
                                </a>
                            </li>
                            <li>
                                <a class="text-white" href="javascript:void(0)">
                                    <i class="anticon anticon-ellipsis font-size-20"></i>
                                </a>
                            </li>
                        </ul>
                    </div>
                    <img class="card-img-top" src="<?php echo get_template_directory_uri(); ?>/assets/images/others/img-4.jpg" alt="">
                </div>
                <div class="card-body">
                    <h4 class="m-t-10">卡片标题</h4>
                    <p class="card-text">Put toy mouse in food bowl run out of litter box at full speed drool but pee in the shoe purr when being pet but chew foot. </p>
                    <div class="m-t-20">
                        <a href="" class="btn btn-primary">动作 1</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="card">
    <div class="card-body">
        <h4>卡片添加背景图</h4>
        <div class="m-t-25">
            <div class="card" style="max-width: 550px">
                <div class="bg-overlay bg" style="background-image: url('assets/images/others/img-2.jpg')">  
                    <div class="card-body">
                        <div class="m-t-150 m-b-20">
                            <h4>卡片添加背景图</h4>
                            <div class="row">
                                <div class="col-md-9">
                                    <p>Hopped up on catnip ask to go outside and ask to come inside and ask to go outside and ask to come inside. Sleep stare at ceiling light for lick butt.</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="card">
    <div class="card-body">
        <h4>卡片-横版布局</h4>
        <div class="m-t-25">
            <div class="card" style="max-width: 800px">
                <div class="row no-gutters">
                    <div class="col-md-5">
                        <img class="img-fluid" src="<?php echo get_template_directory_uri(); ?>/assets/images/others/img-11.jpg" alt="">
                    </div>
                    <div class="col-md-7">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-10 ml-auto mr-auto">
                                    <div class="m-t-30">
                                        <h4>卡片标题</h4>
                                        <p>Put toy mouse in food bowl run out of litter box at full speed drool but pee in the shoe purr when being pet but chew foot.</p>
                                        <p>Scratch the postman wake up lick paw wake up owner meow meow lick plastic bags so cat not kitten around meow all night having their mate disturbing sleeping humans.</p>
                                        <div class="m-t-25">
                                            <a href="" class="btn btn-default">动作 1</a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="card">
    <div class="card-body">
        <h4>卡片组 card-group</h4>
        <p>使用卡片组将卡片渲染为具有相同宽度和高度列的单个附着元素。卡片组使用display:flex；来实现统一的大小。</p>
        <div class="m-t-25">
            <div style="max-width: 1000px">
                <div class="card-group">
                    <div class="card">
                        <img src="<?php echo get_template_directory_uri(); ?>/assets/images/others/img-2.jpg" class="card-img-top" alt="">
                        <div class="card-body">
                            <h4>卡片标题</h4>
                            <p class="card-text">This is a wider card with supporting text below as a natural lead-in to additional content. This content is a little bit longer.</p>
                            <p class="card-text"><small class="text-muted">Last updated 3 mins ago</small></p>
                        </div>
                    </div>
                    <div class="card">
                        <img src="<?php echo get_template_directory_uri(); ?>/assets/images/others/img-5.jpg" class="card-img-top" alt="">
                        <div class="card-body">
                            <h4>卡片标题</h4>
                            <p class="card-text">This card has supporting text below as a natural lead-in to additional content.</p>
                            <p class="card-text"><small class="text-muted">Last updated 3 mins ago</small></p>
                        </div>
                    </div>
                    <div class="card">
                        <img src="<?php echo get_template_directory_uri(); ?>/assets/images/others/img-6.jpg" class="card-img-top" alt="">
                        <div class="card-body">
                            <h4>卡片标题</h4>
                            <p class="card-text">This is a wider card with supporting text below as a natural lead-in to additional content. This card has even longer content than the first to show that equal height action.</p>
                            <p class="card-text"><small class="text-muted">Last updated 3 mins ago</small></p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="card">
    <div class="card-body">
        <h4>卡片组 card-deck</h4>
        <p>需要一套等宽和等高的卡片，而不是彼此相连？使用.card-deck</p>
        <div class="m-t-25">
            <div style="max-width: 1000px">
                <div class="card-deck">
                    <div class="card">
                        <img src="<?php echo get_template_directory_uri(); ?>/assets/images/others/img-2.jpg" class="card-img-top" alt="">
                        <div class="card-body">
                            <h4>卡片标题</h4>
                            <p class="card-text">This is a longer card with supporting text below as a natural lead-in to additional content. This content is a little bit longer.</p>
                            <p class="card-text"><small class="text-muted">Last updated 3 mins ago</small></p>
                        </div>
                    </div>
                    <div class="card">
                        <img src="<?php echo get_template_directory_uri(); ?>/assets/images/others/img-5.jpg" class="card-img-top" alt="">
                        <div class="card-body">
                            <h4>卡片标题</h4>
                            <p class="card-text">This card has supporting text below as a natural lead-in to additional content.</p>
                            <p class="card-text"><small class="text-muted">Last updated 3 mins ago</small></p>
                        </div>
                    </div>
                    <div class="card">
                        <img src="<?php echo get_template_directory_uri(); ?>/assets/images/others/img-6.jpg" class="card-img-top" alt="">
                        <div class="card-body">
                            <h4>卡片标题</h4>
                            <p class="card-text">This is a wider card with supporting text below as a natural lead-in to additional content. This card has even longer content than the first to show that equal height action.</p>
                            <p class="card-text"><small class="text-muted">Last updated 3 mins ago</small></p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="card">
    <div class="card-body">
        <h4>卡片瀑布流</h4>
        <p>通过将卡片包装在<code>.card-columns</code>中，可以用CSS将卡片组织成瀑布流。卡片是用CSS<code>column</code>属性而不是flexbox来构建的，以便于对齐。卡片从上到下，从左到右排列。</p>
        <div class="m-t-25">
            <div style="max-width: 1000px">
                <div class="card-columns">
                    <div class="card">
                        <img src="<?php echo get_template_directory_uri(); ?>/assets/images/others/img-2.jpg" class="card-img-top" alt="">
                        <div class="card-body">
                            <h5 class="card-title">Card title that wraps to a new line</h5>
                            <p class="card-text">This is a longer card with supporting text below as a natural lead-in to additional content. This content is a little bit longer.</p>
                        </div>
                    </div>
                    <div class="card p-3">
                        <blockquote class="blockquote mb-0 card-body">
                            <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer posuere erat a ante.</p>
                            <footer class="blockquote-footer">
                            <small class="text-muted">
                                Someone famous in <cite title="Source Title">Source Title</cite>
                            </small>
                            </footer>
                        </blockquote>
                    </div>
                    <div class="card">
                        <img src="<?php echo get_template_directory_uri(); ?>/assets/images/others/img-5.jpg" class="card-img-top" alt="">
                        <div class="card-body">
                            <h5 class="card-title">卡片标题</h5>
                            <p class="card-text">This card has supporting text below as a natural lead-in to additional content.</p>
                            <p class="card-text"><small class="text-muted">Last updated 3 mins ago</small></p>
                        </div>
                    </div>
                    <div class="card text-center p-3">
                        <blockquote class="blockquote mb-0">
                            <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer posuere erat.</p>
                            <footer class="blockquote-footer text-white">
                                <small>
                                    Someone famous in <cite title="Source Title">Source Title</cite>
                                </small>
                            </footer>
                        </blockquote>
                    </div>
                    <div class="card text-center">
                        <div class="card-body">
                            <h5 class="card-title">卡片标题</h5>
                            <p class="card-text">This card has a regular title and short paragraphy of text below it.</p>
                            <p class="card-text"><small class="text-muted">Last updated 3 mins ago</small></p>
                        </div>
                    </div>
                    <div class="card">
                        <img src="<?php echo get_template_directory_uri(); ?>/assets/images/others/img-6.jpg" class="card-img-top" alt="">
                    </div>
                    <div class="card p-3 text-right">
                        <blockquote class="blockquote mb-0">
                            <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer posuere erat a ante.</p>
                            <footer class="blockquote-footer">
                            <small class="text-muted">
                                Someone famous in <cite title="Source Title">Source Title</cite>
                            </small>
                            </footer>
                        </blockquote>
                    </div>
                    <div class="card">
                        <div class="card-body">
                            <h5 class="card-title">卡片标题</h5>
                            <p class="card-text">This is another card with title and supporting text below. This card has some additional content to make it slightly taller overall.</p>
                            <p class="card-text"><small class="text-muted">Last updated 3 mins ago</small></p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- /gc:html -->