
<?php
/**
 * Title: 博客文章
 * Slug: gcoa/blog-post
 * Categories: pages
 * Keywords: 博客文章
 * Block Types: core/html
 */
?>
<!-- gc:html -->
<div class="page-header">
    <h2 class="header-title">博客文章</h2>
    <div class="header-sub-title">
        <nav class="breadcrumb breadcrumb-dash">
            <a href="#" class="breadcrumb-item"><i class="anticon anticon-home m-r-5"></i>首页</a>
            <a class="breadcrumb-item" href="#">页面</a>
            <span class="breadcrumb-item active">博客文章</span>
        </nav>
    </div>
</div>
<div class="card">
    <div class="card-body">
        <div class="container">
            <h2 class="font-weight-normal m-b-10">我喜欢格尺AI</h2>
            <div class="d-flex m-b-30">
                <div class="avatar avatar-cyan avatar-img">
                    <img src="<?php echo get_template_directory_uri(); ?>/assets/images/avatars/thumb-6.jpg" alt="">
                </div>
                <div class="m-l-15">
                    <a href="javascript:void(0);" class="text-dark m-b-0 font-weight-semibold">风一样的男人</a>
                    <p class="m-b-0 text-muted font-size-13">2020-06-20</p>
                </div>
            </div>
            <img alt="" class="img-fluid w-100" src="<?php echo get_template_directory_uri(); ?>/assets/images/others/img-8.jpg">
            <div class="m-t-30">
                <p style="line-height:2.7em;"><span style="font-size:24px;">我看过很多“销售分析”软件</span></p><p>作为众多初创公司的顾问，以及最近担任天九云的运营主管，我看到了很多东西。大多数都糟透了。我们也使用了CRM工具，很难使用的工具，或者是说糟透了，因此无论您要获得什么见解，都不值得。</p><p><br></p><p style="line-height:2.7em;"><span style="font-size:24px;">现在让我告诉你为什么我喜欢格尺AI</span></p><p>数据是当今销售中最大的问题之一，。什么？你说。“诺亚，您还没有听说过“大数据”以及我们都淹没在大量数据中吗？” 我有，但是，要借用一个短语，这与大小无关，而是如何使用它。问题是双重的：作为销售主管，我们经常不知道要检查哪些，即使我们这样做，数据通常也是如此薄弱，以至于基本上是无用的。</p><p><br></p><p>“ 格尺AI就像一副眼镜-它使您可以清晰地看到团队的工作以及他们的活动与收入相关。”</p><p><br></p><p>销售人员讨厌在Salesforce中更新数据，而并不总是这样做。结合以下事实：您的平均企业销售代表只能坚持18个月左右，然后再进行下一次演出（并带走他们的全部知识），然后您开始发现问题所在。作为销售经理，您是盲目的。</p><p><br></p><p>和参加的会议会自动收集并存储在您的CRM中。我可以快速，轻松地分析团队的数据并提供反馈。您的团队很高兴，因为他们不必手动输入数据，而您很高兴，因为您可以清楚，准确地了解销售现场的实际情况。但这只是故事的一部分。</p><p><br></p><p>鲍勃·迪伦（Bob Dylan）曾唱歌道：“您不需要气象员就能知道风向。” 我可以走进办公室，告诉推销员，他所有的时间都花在乒乓球桌旁没有达成交易。但是我对他应该怎么做还不太清楚。因为格尺AI允许我深入了解每个团队成员的工作方式，所以我可以快速了解高绩效团队的表现，而其他团队则没有。</p><p><br></p><p>“作为销售经理，您的头等大事是帮助您的销售代表提高自己的游戏水平。”</p><p>作为销售经理，我想看看我的销售代表如何度过他们的一天。他们花了多少小时向潜在客户发送电子邮件？他们花了多长时间在面向客户的例如阅读客户电子邮件或参加会议？然后，我希望能够对我的销售代表进行排名，并按帐户划分其活动-这将有助于我发现销售渠道中的瓶颈。格尺AI让我做到了。</p><p><br></p><p>例如，在Smartling，我注意到某些销售代表将大量时间花在即将关闭的大型帐户上。说得通。但是我发现，在一定水平上，我们正面临着收益递减的点–更多的时间并不一定会帮助推动这些潜在客户更快地通过采购流程。相反，对于我们的销售代表来说，花一些时间并用它来开拓新的客户群会更有意义。这种信息是无价的。在 您的头等大事是帮助您的销售代表提升自己的游戏水平。使用格尺AI，您可以在几分钟之内提供有价值的反馈。</p><p><br></p><p>我很高兴能作为一个潜在客户的参考客户，他简直不敢相信格尺AI可以提供声称的一切。我向前景保证了它实际上看似简单– 格尺AI为您提供了提出正确问题所需的所有信息。这就是使其成为如此强大的产品以及每个销售经理急需的东西的原因。几乎一半的销售代表。这意味着每个销售组织都会把钱留在桌子上，每个销售组织都可以做得更好。格尺AI不能为您做到这一点，但可以为您指明道路。</p><p><br></p><p>想更多地了解格尺AI如何提升您的销售团队？，或阅读我们的其余部分，以了解我们还在做些什么！</p><p style="line-height:1.5em;"><br></p>
                <blockquote class="blockquote">
                    <p class="mb-0">使用格尺AI平台转变您的业务</p>
                </blockquote>
                <p>我们会自动捕获所有联系人和客户活动数据，动态更新您的CRM，并提供可操作的情报，以实现面向客户团队的全部潜力。</p>
            </div>
            <div class="d-flex m-t-40 align-items-center">
                <span class="m-r-15">分享: </span>
                <ul class="list-inline m-b-0">
                    <li class="list-inline-item">
                        <button class="font-size-16 btn btn-hover btn-icon btn-rounded">
                            <i class="anticon anticon-facebook"></i>
                        </button>
                    </li>
                    <li class="list-inline-item">
                        <button class="font-size-16 btn btn-hover btn-icon btn-rounded">
                            <i class="anticon anticon-twitter"></i>
                        </button>
                    </li>
                    <li class="list-inline-item">
                        <button class="font-size-16 btn btn-hover btn-icon btn-rounded">
                            <i class="anticon anticon-instagram"></i>
                        </button>
                    </li>
                </ul>
            </div>
            <hr>
            <h5>评论 (28)</h5>
            <div class="m-t-20">
                <ul class="list-group list-group-flush">
                    <li class="list-group-item p-h-0">
                        <div class="media m-b-15">
                            <div class="avatar avatar-image">
                                <img src="<?php echo get_template_directory_uri(); ?>/assets/images/avatars/thumb-8.jpg" alt="">
                            </div>
                            <div class="media-body m-l-20">
                                <h6 class="m-b-0">
                                    <a href="" class="text-dark">有奶便是娘</a>
                                </h6>
                                <span class="font-size-13 text-gray">2020-11-12</span>
                            </div>
                        </div>
                        <span>爱上你不是我的错，都是你胸大腰细惹的祸。</span>
                        <div class="m-t-15">
                            <ul class="list-inline text-right">
                                <li class="d-inline-block m-r-20">
                                    <a class="text-dark" href="javascript:void(0)">
                                        <i class="anticon m-r-5 anticon-like"></i>
                                        <span>43</span>
                                    </a>
                                </li>
                                <li class="d-inline-block m-r-30">
                                    <a class="text-dark" href="javascript:void(0)">
                                        <i class="anticon m-r-5 anticon-message"></i>
                                        <span>回复</span>
                                    </a>
                                </li>
                            </ul>
                        </div>
                    </li>
                    <li class="list-group-item p-h-0">
                        <div class="media m-b-15">
                            <div class="avatar avatar-image">
                                <img src="<?php echo get_template_directory_uri(); ?>/assets/images/avatars/thumb-9.jpg" alt="">
                            </div>
                            <div class="media-body m-l-20">
                                <h6 class="m-b-0">
                                    <a href="" class="text-dark">大米</a>
                                </h6>
                                <span class="font-size-13 text-gray">2020-11-12</span>
                            </div>
                        </div>
                        <span>爱上你不是我的错，都是你胸大腰细惹的祸。</span>
                        <div class="m-t-15">
                            <ul class="list-inline text-right">
                                <li class="d-inline-block m-r-20">
                                    <a class="text-dark" href="javascript:void(0)">
                                        <i class="anticon m-r-5 anticon-like"></i>
                                        <span>18</span>
                                    </a>
                                </li>
                                <li class="d-inline-block m-r-30">
                                    <a class="text-dark" href="javascript:void(0)">
                                        <i class="anticon m-r-5 anticon-message"></i>
                                        <span>回复</span>
                                    </a>
                                </li>
                            </ul>
                        </div>
                    </li>
                    <li class="list-group-item p-h-0">
                        <div class="media m-b-15">
                            <div class="avatar avatar-image">
                                <img src="<?php echo get_template_directory_uri(); ?>/assets/images/avatars/thumb-10.jpg" alt="">
                            </div>
                            <div class="media-body m-l-20">
                                <h6 class="m-b-0">
                                    <a href="" class="text-dark">已成灰</a>
                                </h6>
                                <span class="font-size-13 text-gray">2020-11-12</span>
                            </div>
                        </div>
                        <span>爱上你不是我的错，都是你胸大腰细惹的祸。</span>
                        <div class="m-t-15">
                            <ul class="list-inline text-right">
                                <li class="d-inline-block m-r-20">
                                    <a class="text-dark" href="javascript:void(0)">
                                        <i class="anticon m-r-5 anticon-like"></i>
                                        <span>95</span>
                                    </a>
                                </li>
                                <li class="d-inline-block m-r-30">
                                    <a class="text-dark" href="javascript:void(0)">
                                        <i class="anticon m-r-5 anticon-message"></i>
                                        <span>回复</span>
                                    </a>
                                </li>
                            </ul>
                        </div>
                    </li>
                </ul> 
            </div> 
            <div class="m-t-30">
                <nav>
                    <ul class="pagination justify-content-end">
                        <li class="page-item"><a class="page-link" href="#">上一页</a></li>
                        <li class="page-item active"><a class="page-link" href="#">1</a></li>
                        <li class="page-item"><a class="page-link" href="#">2</a></li>
                        <li class="page-item"><a class="page-link" href="#">3</a></li>
                        <li class="page-item"><a class="page-link" href="#">下一页</a></li>
                    </ul>
                </nav>
            </div>           
        </div>
    </div>
</div>
<!-- /gc:html -->