<?php
/**
 * @package Ancient_Poetry
 * @version 1.0.0
 */
/*
Plugin Name: 经典诗词
Plugin URI: http://www.gechiui.com/plugins/ancient-poetry/
Description: 这是一个样板插件，激活后，您将在每个页面的管理屏幕右上角随机看到经典诗词。
Version: 1.0.0
*/

function hello_dolly_get_lyric() {
	/** 这是古诗词名句 */
	$lyrics = "相思本是无凭语，莫向花笺费泪行。——晏几道《鹧鸪天三首其二》
芳菲歇去何须恨，夏木阳阴正可人。——秦观《三月晦日偶题》
清江一曲抱村流，长夏江村事事幽。——杜甫《江村》
人皆苦炎热，我爱夏日长。——李昂《夏日联句》
春种一粒粟，秋收万颗子。——李绅《悯农》
直缘感君恩爱一回顾，使我双泪长珊珊。——卢仝《楼上女儿曲》
明月不谙离恨苦，斜光到晓穿朱户。——晏殊《鹊踏枝》
仲夏苦夜短，开轩纳微凉。——杜甫《夏夜叹》
南邻更可念，布破冬未赎。——陆游《十月二十八日风雨大作》
无情不似多情苦，一寸还成千万缕。——晏殊《玉楼春》
不知近水花先发，疑是经冬雪未销。——张谓《早梅》
邯郸驿里逢冬至，抱膝灯前影伴身。——白居易《冬至夜思家》
解落三秋叶，能开二月花。——李峤《风》
春花秋月何时了，往事知多少。——李煜《虞美人》
冬尽今宵促，年开明日长。——董思恭《守岁》
好雨知时节，当春乃发生。——杜甫《春夜喜雨》
残云收夏暑，新雨带秋岚。——岑参《水亭送华阴王少府还县》
常恐秋节至，焜黄华叶衰。——《汉乐府·长歌行》
相思一夜梅花发，忽到窗前疑是君。——卢仝《有所思》
夜月一帘幽梦，春风十里柔情。——秦观《八六子》
离恨却如春草，更行更远还生。——李煜《清平乐》
秋月扬明恽，冬岭秀寒松。——陶渊明《四时》
泪纵能乾终有迹，语多难寄反无词。——陈端生《寄外》
银烛秋光冷画屏，轻罗小扇扑流萤。——杜牧《秋夕》
千山鸟飞绝，万径人踪灭。——柳宗元《江雪》
首夏犹清和，芳草亦未歇。——谢灵运《游赤石进帆海》
天时人事日相催，冬至阳生春又来。——杜甫《小至》
欲寄彩笺兼尺素，山长水阔知何处。——晏殊《鹊踏枝》
国破山河在，城春草木深。——杜甫《春望》
春色满园关不住，一枝红杏出墙来。——叶绍翁《游园不值》
1野火烧不尽，春风吹又生。——白居易《赋得古原草送别》
隆冬到来时，百花即已绝。——陈毅《梅》
深居俯夹城，春去夏犹清。——李商隐《晚晴》
落红不是无情物，化作春泥更护花。——龚自珍《己亥杂诗》
不知细叶谁裁出，二月春风似剪刀。——贺知章《咏柳》
临别殷勤重寄词，词中有誓两心知。——白居易《长恨歌》
欲说还休，却道天凉好个秋。——辛弃疾《丑奴儿·书博山道中》
儿童冬学闹比邻，据岸愚儒却子珍。——陆游《秋日郊居》
终日两相思，为君憔悴尽，百花时。——温庭筠《南歌子四首其二》
离愁渐远渐无穷，迢迢不断如春水。——欧阳修《踏莎行》
1谁言寸草心，报得三春晖。——孟郊《游子吟》
秋风萧瑟，洪波涌起。——曹操《观沧海》
连雨不知春去，一晴方觉夏深。——范成大《喜晴》
力尽不知热，但惜夏日长。——白居易《观刈麦》
红豆生南国，春来发几枝？——王维《相思》
从别后，忆相逢，几回魂梦与君同。——晏几道《鹧鸪天三首其一》
鸿雁在云鱼在水，惆怅此情难寄。——晏殊《清平乐二首其二》
开辟鸿蒙，谁为情种？都只为风月情浓。——曹雪芹《红楼梦引子》
且如今年冬，未休关西卒。——杜甫《兵车行》
农夫方夏耘，安坐吾敢食。——戴复古《大热》
1还卿一钵无情泪，恨不相逢未剃时。——苏曼殊《本事诗》
鸣笙起秋风，置酒飞冬雪。——王微《四气诗》
别来半岁音书绝，一寸离肠千万结。——韦庄《应天长》
自古逢秋悲寂寥，我言秋日胜春朝。——刘禹锡《秋词》
窗含西岭千秋雪，门泊东吴万里船。——杜甫《绝句》
春眠不觉晓，处处闻啼鸟。——孟浩然《春晓》
唯将终夜长开眼，报答平生未展眉。——元稹《遣悲怀三首其三》
多情自古伤离别。更那堪，冷落清秋节。——柳永《雨霖铃》
湖光秋月两相和，潭面无风镜未磨。——刘禹锡《望洞庭》
若教眼底无离恨，不信人间有白头。——辛弃疾《鹧鸪天》";

	// 这里我们把它分成几行。
	$lyrics = explode( "\n", $lyrics );

	// 然后随机选择一行。
	return gctexturize( $lyrics[ mt_rand( 0, count( $lyrics ) - 1 ) ] );
}

// 这只是回显所选的行，稍后我们将定位它。
function hello_dolly() {
	$chosen = hello_dolly_get_lyric();
	$lang   = '';
	if ( 'en_' !== substr( get_user_locale(), 0, 3 ) ) {
		$lang = ' lang="en"';
	}

	printf(
		'<p id="dolly"><span class="screen-reader-text">%s </span><span dir="ltr"%s>%s</span></p>',
		__( '古诗词:' ),
		$lang,
		$chosen
	);
}

// 现在我们将该函数设置为在调用admin_notices操作时执行。
add_action( 'admin_notices', 'hello_dolly' );

// 我们需要一些CSS来定位段落。
function dolly_css() {
	echo "
	<style type='text/css'>
	#dolly {
		float: right;
		padding: 5px 10px;
		margin: 0;
		font-size: 12px;
		line-height: 1.6666;
	}
	.rtl #dolly {
		float: left;
	}
	.block-editor-page #dolly {
		display: none;
	}
	@media screen and (max-width: 782px) {
		#dolly,
		.rtl #dolly {
			float: none;
			padding-left: 0;
			padding-right: 0;
		}
	}
	</style>
	";
}

add_action( 'admin_head', 'dolly_css' );
