<h1 align="center">Contributing Guidelines</h1>

## Generalities
<p align="justify">
As part of the open source community, we strongly think that contributing makes us to grow as a project, but also makes us more humans and makes each of us grow as a developer. 
Moreover, contributing makes us able to progress to the future, helping each other to help others.
Therefore, we are very glad that you want to contribute to this project and we want you to contribute on it.
Because of this, and to make the environment more enjoyable for everyone, we implore you to read this document carefully.
</p>

<p align="justify">
To contribute, you must follow our <!-- ProjectDependant --> <a href="https://github.com/GaryNLOL/Supple-Crystal/blob/main/docs/CODE_OF_CONDUCT.md">Code of Conduct</a><!-- /ProjectDependant -->.
Please be sure you have read it.
Additionally, if you're going to contribute with code, please follow the <a href="https://github.com/GaryNLOL/Style-Guides">corresponding style guide</a> of the language you will use.
If there is not a style guide language of the language you want to use, please let it know in the Discord server and we will answer you as soon as possible.
</p>

## Scope
Changes should be focused on the scope and purpose of the project.

<!-- ProjectDependant -->
Contributions in Supple Crystal should relate to:
- Image Display.
<!-- /ProjectDependant -->

Any contribution out of this scope should be strongly discussed and approved in the Discord server.

## Ways to contribute
### Pull requests
We encourage you to make pull requests. To do so, follow those steps:
1. Think about one issue or feature you want to work on or go to the issues sections of GitHub and pick one.
2. Clone the repository.
3. Start the repository in your local computer.
4. Solve the issue or add the feature you choosed.
5. Commit the changes you've made.
6. Push your changes to your fork.
7. Create a pull request.
That's it!

### Feature requests
If you want to request a feature, please do it in the Issues section. Additionally, mark it clearly as a feature request and then provide the maximum details you can. Follow this format:
```markdown
## Description:
Describe your feature clearly.

## Example outputs:
Explain what is supposed to happen (e. g. what your function should return when is called).
Post as many examples as you can.

## Notes:
If there is something you must add do it here.
```

### Issues
You're welcome to posts issues. Just use the following format:
```markdown
## Description:
Describe your problem clearly.

## Minimal reproducible example:
Post the minimal piece of code that can reproduce the problem.

## Expected VS actual output:
A clear explanation about the output that you expected to obtain and the output you obtained.

## Platform:
Include your OS.

## Notes:
If there is something you must add do it here.
```

### Assets, design and miscellaneous
You can also contribute in other aspects of the project. To do so, follow these steps:
1. Discuss your change in the channel of the Discord server that corresponds to the change you want to make.
2. Create the change.
3. Upload it either in the Discord server or add it to the repository by a Pull Request (see Pull Requests section).
