// =================================================================================================
//
//	Starling Framework
//	Copyright Gamua GmbH. All Rights Reserved.
//
//	This program is free software. You can redistribute and/or modify it
//	in accordance with the terms of the accompanying license agreement.
//
// =================================================================================================

package starling.text
{
    import flash.display.BitmapData;
    import flash.display3D.Context3DTextureFormat;
    import flash.geom.Rectangle;
    import flash.utils.ByteArray;

    import starling.textures.Texture;

    /** @private
     *  This class contains constants for the 'MINI' bitmap font. It's done that way to avoid
     *  a dependency on the 'mx.core' library (which is required for the 'Embed' statement).
     * 
     *  <p>The font is based on "uni05_53.ttf" from Craig Kroeger (http://www.miniml.com) and was
     *  converted to a Bitmap Font with "GlyphDesigner" from 71squared (http://www.71squared.com).
     *  </p>
     *
     *  <p>You can download a zip-file containing the bitmap font (with both XML and PNG files)
     *  <a href="http://gamua.com/media/starling/misc/bitmapfont-mini.zip">here</a>.</p>
     */
    internal class MiniBitmapFont
    {
        private static const BITMAP_WIDTH:int = 128;
        private static const BITMAP_HEIGHT:int = 64;
        private static const BITMAP_DATA:Vector.<uint> = new <uint>[
            2027613533, 3413039936,  202148514, 2266925598, 4206886452, 4286853117,    2034947,
            3202703399,  352977282, 2957757964, 3113652880, 2158068882, 1468709156, 2268063717,
            2779310143, 2101025806, 3416509055, 4215794539, 3602168838, 1038056207, 1932393374,
            3182285627, 3086802234, 1741291262, 2017257123, 3395280843,  984074419, 3049693147,
            3986077023, 1055013549, 1806563255, 1754714962, 1577746187, 1124058786, 3888759258,
            2482229043, 2916583666, 3743065328,  866060213, 1695195001, 2401582068, 3113347901,
            2616521596, 1053798161, 2093370968, 4229025683,  560451479,  854767518, 2610241322,
            4279041348, 4181572480, 4031244973,  587139110, 1081376765,  962217926,  783603325,
            3605526425, 4102001916,  289204733, 2635140255, 3453981695, 3487854373, 2132197241,
            3164775074, 4257640328,  770238970,  144664537,  707141570, 2934433071,  871272893,
             512964596,  808491899,  481894297, 3095982481, 3598364156, 1710636358, 2904016319,
            1751040139,  596966466, 1363963692,  465815609,  315567311, 4290666159, 4086022551,
             179721458, 2221734970, 3942224988, 1519355876, 3292323782, 3933427230, 3314199893,
            3736227348, 3846038425,  603088884, 2677349227, 3207069327, 3555275967, 3063054283,
            3064577213, 3412044179,  693642210, 4280513949,  762928717, 1802215333, 3774849674,
            4221155330,  970959395,  557220237, 2107226136, 3509822982, 3403284788, 4265820019,
             898597576,  991077243, 2091615904, 3334716888,  633599866, 4218780109, 2216000376,
             834870947, 2118009742, 1362731961,  236280636, 1274945142, 1458729366,  797960805,
            3289369720, 2103717340, 3946406003, 2676522889, 1624104606, 1156993903, 3186170404,
            2254499071, 1204911924, 1314218830, 3307086392, 2824275959, 3839865679, 2073394964,
            1873329433, 1754205930, 1528429545, 1631106062, 2263272465, 4220497047, 3522893765,
            3641376303,  707451487, 3452496787, 1390653868, 2620555793, 1027328684, 3419683476,
            3662193703,  765701986, 3808279132,  786403271, 3824435837,  713234896, 4261856399,
            3471930731, 3993492879, 1447960461, 1398434593, 1914230187, 2398643285, 4156374464,
            3859339207, 3220700061, 3373248762, 3186030434, 1315917060, 2809852481, 4008553903,
            4105611953, 1599499652, 3513857591,  877854499, 4198259455, 3648560077, 2838035419,
            3255594190, 2465578457, 4263505201,  534904657, 2889261598, 1358214576, 1069250354,
            3870010557, 2628896583, 3448610878,  442343309, 1024736866, 4015119133, 3250867279,
            1513359261, 2442089596, 1944476762,  735490552,  426990058, 4234106111, 1204305707,
            3330995265, 2398649368, 4221048123, 1724669255, 3801115709, 3489328790, 3896402933,
            3696936939, 2836983295, 3656750393, 3349724512, 3810416287, 3654997608, 4284455103,
            2294939563, 4207697932,  642748805, 2476981639, 2319419898,  572956615, 3833238940,
             964924880, 2081600351, 3572458416, 2056247513, 1951368808, 2133449703, 2783728628,
             512866577,  913279200, 1678129016, 3488578991, 3373952929, 2562996951, 3666058925,
            1664169178, 1943591935,  750675303,  154399903, 2571590890,  852654952, 4117307766,
            1971649621, 4180195820, 1222535348, 4283953215, 2880662236, 2717410980, 1175907705,
            1157322027,  505963121, 2631540616, 3661227656, 3591803353, 2624126821, 1948662907,
            3596065103, 1147387734,  256773959, 1173572460, 2361957471, 4210876076, 3080180620,
            3464801210, 3821654259, 1465302035, 2851185457, 3143266144, 3793180414, 3368833103,
            4274670712, 3473819108, 3487569332,  773123355, 1618635668, 2570176190, 2075248691,
            1740805534,  288646743, 1837597401,  603556968, 3182536872,  673184603, 3088757053,
            2897054404, 3192651316, 2885335802, 1057233368, 1118437241, 4182126463, 3110464775,
            3313191614, 2360987274,  735505357, 2992631425, 2360928811, 4187834527,  279183208,
            1586420003, 1174008423, 4062987589, 1162167621, 1162167621, 1162167621, 1162167621,
            1174119799,  787274608
        ];
        
        private static const XML_DATA:Vector.<uint> = new <uint>[
            2027597212, 3413252919,  272990085, 3317550056, 3334163186, 3257663297, 3591128409,
            2890425386, 2761111647,  527618147,   52430618, 2364524198, 1760684058, 2369863585,
            3474923166, 2408051623, 2281562617, 3095060076, 2005920695, 4251041630, 2650210141,
            1585968618, 4158909395, 3814370647, 4227065461, 3206373022, 3733899251, 3421889991,
            1326439395, 3688624560, 2061311862, 1601633199,  803730609, 3454661241, 2147081965,
            3866490843, 3818535112,  392109783, 3467401087, 1858006606, 2549591983, 3061836958,
            1188875238, 2949868155, 4235638912,  684866237, 3050979165, 3216305109, 3217254334,
             260046515, 2142956216, 3170574911,  979287777, 4177296602, 2634524127, 3352764408,
            4061109159, 3208087531, 4291923263, 1774236298,   64390065, 2761120269, 3864715718,
            2322325223, 2853989163, 1817861174, 1345078606, 3627597066, 1634342248, 2048207014,
            1439700685,  889444112, 2599097303, 1673112788, 3233094349, 2781121896, 1859784462,
            1815586484,  245289180, 3020824173,  927656720, 3497436084, 3473070702,  335965828,
            3677167038, 2765129315,  305200265, 1930001523, 2968255456,  728531660,  366545081,
            2530000716,  382716266,  509201668, 1805089764, 3144412199, 2966275026, 3843995915,
            2874857560, 2028220014,  864036925,  843722579, 3658443969, 1548642213,  640956393,
            3577181747, 2648451636, 3786701581, 2746855152, 3375918650, 2200787631, 1312736162,
            4125799551,  492597210,  252620343, 3976695766, 1800036239, 3817516935, 3947722251,
            1891486062,  296630233,  767751566,  822368944, 1432685697,   55275586, 1891980552,
            3506824774,  516416227, 4165382638, 4109739522,  390692164, 1637719233, 1479322500,
            2368975173, 2225514211,  672826186, 1568913875, 1824186394, 3653266945, 2518308906,
              35525686,  653048005, 1616403844, 1361587273, 3094588780, 2505882319, 2776202028,
            2757087402, 3328627097, 3952038601, 1237697581, 3770057333, 4018923532, 2790774465,
            2214943965, 3762992238, 1305294237, 3706356884, 2363377204, 1470247860, 1581879325,
            1521437675, 3768051941, 1448385834,  276728158, 1785811956,  269260971, 2846409888,
            3600278860, 2406006054, 3114305630, 1607144004, 3239524360, 3102051805, 2486660692,
             896281643, 1014447558,  752047569, 3277336169, 4209190282, 1501241799,   93461344,
            2317421519, 2928258400, 3813649565, 4080047018, 3088226780, 2151884600, 2530096045,
            2211756338, 2901394566, 3390670300, 3607345457, 2009739438, 1008387796, 1490520565,
            3587808834,  508254254, 2879706886,  741828625,  753731096, 3625260424,  208354225,
            1701634724, 3994665048, 2675652636, 1448739338, 2353893188, 1951968343, 1167130823,
             502991968, 2742645147,   79075887, 1526806702, 3474769333, 2726863238, 2886959267,
             378339352,  916995117, 3328260559, 1601263773, 1996583128, 2718531779, 1242497133,
             845742496, 1294401036, 1840428143,  500720658, 2335813833, 2759518913,  647223977,
             127618258, 2483041945, 1290486960, 3383021083, 3508966148, 1168207334, 2337541574,
             898800912, 3630843636,  853044242, 2383033762, 2657078941,  613038758, 2484767541,
            1169366183, 3591786002, 2794851111, 2311229988,  282764217, 2976944944, 2922874271,
            2222007734, 2975904561, 3116520386, 3094491192, 2967299193, 4253931852,  666250385,
            4179795844, 1638213140, 3228191078,  423837811, 3310994165, 1244860588, 1462137215,
             945886295,  440427430, 2321254216, 1170019334, 1713271776, 2147913693, 1827968672,
            2082532922, 4017118097, 2659527947, 3343803853, 1813812659, 1580633162, 1671513475,
            3113396937, 1677954251,  985222302, 1806934566, 3484262014, 2444715872, 3994311733,
            3747831434, 2254536017,  248033492, 2309838657,  572362214, 2264662528, 2351674224,
            3671049426, 3168085287, 1576925355, 1919659723, 4012572823, 3070764083, 1859557424,
            1935302741, 3276007101,  761379244, 1440644487, 1902318063, 1700320137, 2904729752,
            4144980056, 1388643363, 2385229611,   39497692, 2919788733,  916414468, 1920818806,
              24265681, 2629861817, 2623538306, 3113771140, 2170113095,   72797283, 2911429019,
             573565656, 3145961894, 2136506532, 4116780896, 2615237068, 2721979478, 3941798645,
            1700588260, 2524858588,  652061762, 2523917061, 1130418869, 1665299237, 3874687928,
            2790598641, 2031355348, 3958550756, 4269199613, 3678480072, 3448593534,  535537315,
             489382669, 2930887156, 1148245624, 3569761183, 2714134023,   63949312, 3940116119,
            1607367711, 1022608529, 2064987700, 2361851206, 2472236914,  233094865, 2017560618,
            1834051537, 1553591560,  196640410,  737779879, 3324437502, 2471243439, 4225110860,
            1943295493, 1788573635, 4000264602, 1944081486, 1305624985,  432107877, 1747235854,
             479892319, 3581570398, 3816529723, 4146099065, 3229056819, 3499918252, 1253025017,
             518193838, 1768206194, 3141161437,  262863433, 1431520128, 2096843900,  478027203,
            3857703383, 1157369823, 1528368128
       ];

        public static function get texture():Texture
        {
            var bitmapData:BitmapData = getBitmapData();
            var format:String = Context3DTextureFormat.BGRA_PACKED;
            var texture:Texture = Texture.fromBitmapData(bitmapData, false, false, 1, format);
            bitmapData.dispose();
            bitmapData = null;

            texture.root.onRestore = function():void
            {
                bitmapData = getBitmapData();
                texture.root.uploadBitmapData(bitmapData);
                bitmapData.dispose();
                bitmapData = null;
            };

            return texture;
        }

        private static function getBitmapData():BitmapData
        {
            var bmpData:BitmapData = new BitmapData(BITMAP_WIDTH, BITMAP_HEIGHT);
            var bmpBytes:ByteArray = new ByteArray();
            var length:uint = BITMAP_DATA.length;

            for (var i:uint=0; i<length; ++i)
                bmpBytes.writeUnsignedInt(BITMAP_DATA[i]);

            bmpBytes.uncompress();
            bmpData.setPixels(new Rectangle(0, 0, BITMAP_WIDTH, BITMAP_HEIGHT), bmpBytes);
            bmpBytes.clear();

            return bmpData;
        }
        
        public static function get xml():XML
        {
            var xml:XML;
            var xmlBytes:ByteArray = new ByteArray();
            var length:uint = XML_DATA.length;

            for (var i:uint=0; i<length; ++i)
                xmlBytes.writeUnsignedInt(XML_DATA[i]);

            xmlBytes.uncompress();
            xml = XML(xmlBytes.readUTF());
            xmlBytes.clear();

            return xml;
        }
    }
}