# Starling Framework

The Cross Platform Game Engine
------------------------------

The Starling Framework allows you to create hardware accelerated apps in ActionScript 3. The main target is the creation of 2D games, but Starling may be used for any graphical application. Thanks to Adobe AIR, Starling-based applications can be deployed to mobile devices (iOS, Android) and the desktop (Windows, macOS).

While Starling mimics the classic display tree architecture of Adobe AIR/Flash, it provides a much better performance: all objects are rendered directly by the GPU (using the Stage3D API). The complete architecture was designed for working well with the GPU; common game development tasks were built right into its core. Starling hides Stage3D internals from developers, but makes it easy to access them for those who need full performance and flexibility.

Starling aims to be as lightweight and easy to use as possible. As an Open Source project, much care was taken to make the source code easy to read, understand and extend. With under 20k lines of code, experienced developers can easily grasp it in its entirety, or modify it to their needs.

Quick Links
-----------

* [Official Homepage](http://www.starling-framework.org)
* [Instruction Manual](http://manual.starling-framework.org)
* [API Reference](http://doc.starling-framework.org)
* [Support Forum](http://forum.starling-framework.org)
* [Starling Wiki](http://wiki.starling-framework.org)
  * [Showcase](http://wiki.starling-framework.org/games/start)
  * [Extensions](http://wiki.starling-framework.org/extensions/start)

News and Updates
----------------

* [Twitter](https://twitter.com/gamua)
* [Facebook](https://facebook.com/gamua.co)
* [LinkedIn](https://www.linkedin.com/company/gamua)

Adobe AIR – Provided by HARMAN
------------------------------

* Get the latest AIR SDK [here](https://airsdk.harman.com).
