---
layout: default
updated: "January 29, 2018"
roman: "XVI"
dates: "May 17-20, 2018"
---
Genetic Programming Theory & Practice is a small, invitation-only workshop hosted annually by the [Center for the Study of Complex Systems](http://www.lsa.umich.edu/cscs/) at the University of Michigan in Ann Arbor, MI. This year's conference will be held {{page.dates}}.

_Note that this year's workshop will extend an additional day compared to earlier sessions, including full days on Thursday, Friday and Saturday, plus a half-day Sunday._

## Important Dates

- **May 17-20, 2018:** Workshop, presentations, and discussions

## Contacts

### Organizers for GPTP

(alphabetical order)

- [Wolfgang Banzhaf](http://www.cse.msu.edu/~banzhafw/)
    - [Slack](https://gptp-workshops.slack.com/messages/@wolfgang/)
- [Leigh Sheneman](http://leighsheneman.com/)
    - [Twitter](https://twitter.com/ag_shen)
    - [Slack](https://gptp-workshops.slack.com/messages/@leighs/)
- [Lee Spector](http://faculty.hampshire.edu/lspector/)
    - [Twitter](https://twitter.com/leespector)
    - [Slack](https://gptp-workshops.slack.com/messages/@lspector/)
- [Bill Tozier](http://vaguery.github.io/)
    - [Twitter](https://twitter.com/vaguery)
    - [Slack](https://gptp-workshops.slack.com/messages/@bill_tozier/)

### Center for the Study of Complex Systems

- [Linda Wood](https://lsa.umich.edu/cscs/people/staff/linmwood.html)

### Social Media

- An invitation-only [Slack channel](http://gptp-workshops.slack.com) has been set up for simplifying and consolidating shared and private communication among participants and organizers.
- Twitter hashtag: [`#gptp2018`](https://twitter.com/search?f=tweets&q=%23gptp2018) (click to search for recent items)

## Food

A light breakfast of pastries, fresh fruit, meats, cheeses, yoghurt and coffee will provided each day of the workshop. Mid-day, a lunch will be provided on-site. After the last session each day, attendees typically self-organize for visits to local restaurants. We will convene for a formal dinner and organizational meeting (all attendees are welcome) one of the nights of the workshop. Please let us know if you have any dietary restrictions for catered meals.

## Accommodations

[A list of bed-and-breakfast inns, hotels and motels](accommodations.html) will been provided. There are several other options available, including a number of local [AirBnB](https://www.airbnb.com) providers.

## Meeting Location

The 2018 meeting location will be in the [10th Floor Meeting Space of Weiser Hall](https://sites.lsa.umich.edu/weiserhall/) on the University of Michigan Central Campus. Note: _The meeting space cannot be accessed outside of meeting hours._

A (for-fee) parking garage is available nearby (see below).

## Transportation

Flights should be scheduled to the [Detroit Metro Airport](http://www.metroairport.com) (`DTW`). From there, a taxi or [Michigan Flyer/AirRide](http://www.michiganflyer.com) shuttle can be arranged. The Michigan Flyer, in particular, is affordable and convenient.

Unless you are staying directly in Downtown Ann Arbor or the University of Michigan campus area, you will want to to arrange transportation. Rental cars can obtained from the airport, but all major brands also have Ann Arbor locations for pick up and drop off. Several taxi services are available. If you're near a route you can also ride the [excellent local bus service](http://www.theride.org).

There is very little chance of street parking on weekdays on the University campus, but there is a [public parking structure](https://pts.umich.edu/parking/structureforest.php) nearby on Forest Street.

## Information for Speakers and Authors

See the [contributions page](contributions.html) for information on preparing presentations and publications, and the [schedule page](schedule.html) for the detailed workshop schedule.

