#ifndef D3D9SHADER_H
#define D3D9SHADER_H

#if 0
// fxc.exe /Tps_2_0 shader.hlsl /Fhshader.h
/*
uniform sampler2D SurfaceTex;
uniform sampler2D PaletteTex;

float4 main(float2 texCoords : TEXCOORD) : COLOR
{
    float pIndex = tex2D(SurfaceTex, texCoords).r;
    return tex2D(PaletteTex, float2(pIndex * (255./256) + (0.5/256), 0));
}
*/
#endif

const BYTE D3D9_PALETTE_SHADER[] =
{
      0,   2, 255, 255, 254, 255, 
     44,   0,  67,  84,  65,  66, 
     28,   0,   0,   0, 131,   0, 
      0,   0,   0,   2, 255, 255, 
      2,   0,   0,   0,  28,   0, 
      0,   0,   0,   1,   0,   0, 
    124,   0,   0,   0,  68,   0, 
      0,   0,   3,   0,   1,   0, 
      1,   0,   0,   0,  80,   0, 
      0,   0,   0,   0,   0,   0, 
     96,   0,   0,   0,   3,   0, 
      0,   0,   1,   0,   0,   0, 
    108,   0,   0,   0,   0,   0, 
      0,   0,  80,  97, 108, 101, 
    116, 116, 101,  84, 101, 120, 
      0, 171,   4,   0,  12,   0, 
      1,   0,   1,   0,   1,   0, 
      0,   0,   0,   0,   0,   0, 
     83, 117, 114, 102,  97,  99, 
    101,  84, 101, 120,   0, 171, 
      4,   0,  12,   0,   1,   0, 
      1,   0,   1,   0,   0,   0, 
      0,   0,   0,   0, 112, 115, 
     95,  50,  95,  48,   0,  77, 
    105,  99, 114, 111, 115, 111, 
    102, 116,  32,  40,  82,  41, 
     32,  72,  76,  83,  76,  32, 
     83, 104,  97, 100, 101, 114, 
     32,  67, 111, 109, 112, 105, 
    108, 101, 114,  32,  49,  48, 
     46,  49,   0, 171,  81,   0, 
      0,   5,   0,   0,  15, 160, 
      0,   0, 127,  63,   0,   0, 
      0,  59,   0,   0,   0,   0, 
      0,   0,   0,   0,  31,   0, 
      0,   2,   0,   0,   0, 128, 
      0,   0,   3, 176,  31,   0, 
      0,   2,   0,   0,   0, 144, 
      0,   8,  15, 160,  31,   0, 
      0,   2,   0,   0,   0, 144, 
      1,   8,  15, 160,  66,   0, 
      0,   3,   0,   0,  15, 128, 
      0,   0, 228, 176,   0,   8, 
    228, 160,   4,   0,   0,   4, 
      0,   0,   1, 128,   0,   0, 
      0, 128,   0,   0,   0, 160, 
      0,   0,  85, 160,   1,   0, 
      0,   2,   0,   0,   2, 128, 
      0,   0, 170, 160,  66,   0, 
      0,   3,   0,   0,  15, 128, 
      0,   0, 228, 128,   1,   8, 
    228, 160,   1,   0,   0,   2, 
      0,   8,  15, 128,   0,   0, 
    228, 128, 255, 255,   0,   0
};


/* bilinear upscaling */

#if 0
// fxc.exe /Tps_2_0 shader.hlsl /Fhshader.h
/*
uniform sampler2D SurfaceTex;
uniform sampler2D PaletteTex;

float4 TextureSize : register(c0);

#define SourceSize float4(TextureSize.xy, 1.0 / TextureSize.xy)

float4 bilinear(float2 coord)
{
    float2 samplePos = coord * SourceSize.xy;
    float2 texPos1 = floor(samplePos - 0.5f) + 0.5f;
    float2 texPos2 = texPos1 + 1.0f;

    float2 f = samplePos - texPos1;

    texPos1 *= SourceSize.zw;
    texPos2 *= SourceSize.zw;

    float tli = tex2D(SurfaceTex, float2(texPos1.x, texPos1.y)).r;
    float tri = tex2D(SurfaceTex, float2(texPos2.x, texPos1.y)).r;
    float bli = tex2D(SurfaceTex, float2(texPos1.x, texPos2.y)).r;
    float bri = tex2D(SurfaceTex, float2(texPos2.x, texPos2.y)).r;

    float4 tl = tex2D(PaletteTex, float2(tli * (255./256) + (0.5/256), 0));
    float4 tr = tex2D(PaletteTex, float2(tri * (255./256) + (0.5/256), 0));
    float4 bl = tex2D(PaletteTex, float2(bli * (255./256) + (0.5/256), 0));
    float4 br = tex2D(PaletteTex, float2(bri * (255./256) + (0.5/256), 0));

    float4 top = lerp(tl, tr, f.x);
    float4 bot = lerp(bl, br, f.x);

    return lerp(top, bot, f.y);
}

float4 main(float2 texCoords : TEXCOORD) : COLOR
{
    return bilinear(texCoords);
}
*/
#endif

const BYTE D3D9_PALETTE_SHADER_BILINEAR[] =
    {
      0,   2, 255, 255, 254, 255,
     56,   0,  67,  84,  65,  66,
     28,   0,   0,   0, 179,   0,
      0,   0,   0,   2, 255, 255,
      3,   0,   0,   0,  28,   0,
      0,   0,   0,   1,   0,   0,
    172,   0,   0,   0,  88,   0,
      0,   0,   3,   0,   1,   0,
      1,   0,   0,   0, 100,   0,
      0,   0,   0,   0,   0,   0,
    116,   0,   0,   0,   3,   0,
      0,   0,   1,   0,   0,   0,
    128,   0,   0,   0,   0,   0,
      0,   0, 144,   0,   0,   0,
      2,   0,   0,   0,   1,   0,
      2,   0, 156,   0,   0,   0,
      0,   0,   0,   0,  80,  97,
    108, 101, 116, 116, 101,  84,
    101, 120,   0, 171,   4,   0,
     12,   0,   1,   0,   1,   0,
      1,   0,   0,   0,   0,   0,
      0,   0,  83, 117, 114, 102,
     97,  99, 101,  84, 101, 120,
      0, 171,   4,   0,  12,   0,
      1,   0,   1,   0,   1,   0,
      0,   0,   0,   0,   0,   0,
     84, 101, 120, 116, 117, 114,
    101,  83, 105, 122, 101,   0,
      1,   0,   3,   0,   1,   0,
      4,   0,   1,   0,   0,   0,
      0,   0,   0,   0, 112, 115,
     95,  50,  95,  48,   0,  77,
    105,  99, 114, 111, 115, 111,
    102, 116,  32,  40,  82,  41,
     32,  72,  76,  83,  76,  32,
     83, 104,  97, 100, 101, 114,
     32,  67, 111, 109, 112, 105,
    108, 101, 114,  32,  49,  48,
     46,  49,   0, 171,  81,   0,
      0,   5,   1,   0,  15, 160,
      0,   0,   0, 191,   0,   0,
      0,  63,   0,   0, 192,  63,
      0,   0,   0,   0,  81,   0,
      0,   5,   2,   0,  15, 160,
      0,   0, 127,  63,   0,   0,
      0,  59,   0,   0,   0,   0,
      0,   0,   0,   0,  31,   0,
      0,   2,   0,   0,   0, 128,
      0,   0,   3, 176,  31,   0,
      0,   2,   0,   0,   0, 144,
      0,   8,  15, 160,  31,   0,
      0,   2,   0,   0,   0, 144,
      1,   8,  15, 160,   1,   0,
      0,   2,   0,   0,   8, 128,
      1,   0,   0, 160,   4,   0,
      0,   4,   0,   0,   3, 128,
      0,   0, 228, 176,   0,   0,
    228, 160,   0,   0, 255, 128,
     19,   0,   0,   2,   0,   0,
     12, 128,   0,   0,  27, 128,
      2,   0,   0,   3,   0,   0,
      3, 128,   0,   0,  27, 129,
      0,   0, 228, 128,   2,   0,
      0,   3,   0,   0,  12, 128,
      0,   0,  27, 128,   1,   0,
    170, 160,   2,   0,   0,   3,
      0,   0,   3, 128,   0,   0,
    228, 128,   1,   0,  85, 160,
      6,   0,   0,   2,   1,   0,
      1, 128,   0,   0,   0, 160,
      6,   0,   0,   2,   1,   0,
      2, 128,   0,   0,  85, 160,
      5,   0,   0,   3,   2,   0,
      3, 128,   0,   0,  27, 128,
      1,   0, 228, 128,   5,   0,
      0,   3,   1,   0,   3, 128,
      0,   0, 228, 128,   1,   0,
    228, 128,   4,   0,   0,   4,
      0,   0,   3, 128,   0,   0,
    228, 176,   0,   0, 228, 160,
      0,   0, 228, 129,   1,   0,
      0,   2,   3,   0,   1, 128,
      2,   0,   0, 128,   1,   0,
      0,   2,   3,   0,   2, 128,
      1,   0,  85, 128,   1,   0,
      0,   2,   4,   0,   1, 128,
      1,   0,   0, 128,   1,   0,
      0,   2,   4,   0,   2, 128,
      2,   0,  85, 128,  66,   0,
      0,   3,   3,   0,  15, 128,
      3,   0, 228, 128,   0,   8,
    228, 160,  66,   0,   0,   3,
      1,   0,  15, 128,   1,   0,
    228, 128,   0,   8, 228, 160,
     66,   0,   0,   3,   2,   0,
     15, 128,   2,   0, 228, 128,
      0,   8, 228, 160,  66,   0,
      0,   3,   4,   0,  15, 128,
      4,   0, 228, 128,   0,   8,
    228, 160,   4,   0,   0,   4,
      3,   0,   1, 128,   3,   0,
      0, 128,   2,   0,   0, 160,
      2,   0,  85, 160,   1,   0,
      0,   2,   3,   0,   2, 128,
      1,   0, 255, 160,   4,   0,
      0,   4,   1,   0,   1, 128,
      1,   0,   0, 128,   2,   0,
      0, 160,   2,   0,  85, 160,
      1,   0,   0,   2,   1,   0,
      2, 128,   1,   0, 255, 160,
      4,   0,   0,   4,   2,   0,
      1, 128,   2,   0,   0, 128,
      2,   0,   0, 160,   2,   0,
     85, 160,   4,   0,   0,   4,
      4,   0,   1, 128,   4,   0,
      0, 128,   2,   0,   0, 160,
      2,   0,  85, 160,   1,   0,
      0,   2,   4,   0,   2, 128,
      1,   0, 255, 160,   1,   0,
      0,   2,   2,   0,   2, 128,
      1,   0, 255, 160,  66,   0,
      0,   3,   3,   0,  15, 128,
      3,   0, 228, 128,   1,   8,
    228, 160,  66,   0,   0,   3,
      1,   0,  15, 128,   1,   0,
    228, 128,   1,   8, 228, 160,
     66,   0,   0,   3,   4,   0,
     15, 128,   4,   0, 228, 128,
      1,   8, 228, 160,  66,   0,
      0,   3,   2,   0,  15, 128,
      2,   0, 228, 128,   1,   8,
    228, 160,  18,   0,   0,   4,
      5,   0,  15, 128,   0,   0,
      0, 128,   3,   0, 228, 128,
      1,   0, 228, 128,  18,   0,
      0,   4,   1,   0,  15, 128,
      0,   0,   0, 128,   2,   0,
    228, 128,   4,   0, 228, 128,
     18,   0,   0,   4,   2,   0,
     15, 128,   0,   0,  85, 128,
      1,   0, 228, 128,   5,   0,
    228, 128,   1,   0,   0,   2,
      0,   8,  15, 128,   2,   0,
    228, 128, 255, 255,   0,   0
    };


/* catmull rom upscaling */

#if 0
// fxc.exe /Tps_2_0 shader.hlsl /Fhshader.h
/*
// The following code is licensed under the MIT license: https://gist.github.com/TheRealMJP/bc503b0b87b643d3505d41eab8b332ae
// Ported from code: https://gist.github.com/TheRealMJP/c83b8c0f46b63f3a88a5986f4fa982b1
// Samples a texture with Catmull-Rom filtering, using 9 texture fetches instead of 16.
// See http://vec3.ca/bicubic-filtering-in-fewer-taps/ for more details

// Modified to use 5 texture fetches

uniform sampler2D SurfaceTex;

float4 TextureSize : register(c0);

#define SourceSize float4(TextureSize.xy, 1.0 / TextureSize.xy)

float4 catmull_rom(float2 coord)
{
    float2 samplePos = coord * SourceSize.xy;
    float2 texPos1 = floor(samplePos - 0.5f) + 0.5f;

    float2 f = samplePos - texPos1;

    float2 w0 = f * (-0.5f + f * (1.0f - 0.5f * f));
    float2 w1 = 1.0f + f * f * (-2.5f + 1.5f * f);
    float2 w2 = f * (0.5f + f * (2.0f - 1.5f * f));
    float2 w3 = f * f * (-0.5f + 0.5f * f);

    float2 w12 = w1 + w2;
    float2 offset12 = w2 / (w1 + w2);

    float2 texPos0 = texPos1 - 1;
    float2 texPos3 = texPos1 + 2;
    float2 texPos12 = texPos1 + offset12;

    texPos0  *= SourceSize.zw;
    texPos3  *= SourceSize.zw;
    texPos12 *= SourceSize.zw;

    float wtm = w12.x * w0.y;
    float wml = w0.x * w12.y;
    float wmm = w12.x * w12.y;
    float wmr = w3.x * w12.y;
    float wbm = w12.x * w3.y;

    float3 result = 0.0f;

    result += tex2D(SurfaceTex, float2(texPos12.x, texPos0.y)).rgb * wtm;
    result += tex2D(SurfaceTex, float2(texPos0.x, texPos12.y)).rgb * wml;
    result += tex2D(SurfaceTex, float2(texPos12.x, texPos12.y)).rgb * wmm;
    result += tex2D(SurfaceTex, float2(texPos3.x, texPos12.y)).rgb * wmr;
    result += tex2D(SurfaceTex, float2(texPos12.x, texPos3.y)).rgb * wbm;

    return float4(result * (1./(wtm+wml+wmm+wmr+wbm)), 1.0);
}

float4 main(float2 texCoords : TEXCOORD) : COLOR
{
    return catmull_rom(texCoords);
}

*/
#endif

const BYTE D3D9_CATMULL_ROM_SHADER[] =
    {
      0,   2, 255, 255, 254, 255,
     44,   0,  67,  84,  65,  66,
     28,   0,   0,   0, 131,   0,
      0,   0,   0,   2, 255, 255,
      2,   0,   0,   0,  28,   0,
      0,   0,   0,   1,   0,   0,
    124,   0,   0,   0,  68,   0,
      0,   0,   3,   0,   0,   0,
      1,   0,   0,   0,  80,   0,
      0,   0,   0,   0,   0,   0,
     96,   0,   0,   0,   2,   0,
      0,   0,   1,   0,   2,   0,
    108,   0,   0,   0,   0,   0,
      0,   0,  83, 117, 114, 102,
     97,  99, 101,  84, 101, 120,
      0, 171,   4,   0,  12,   0,
      1,   0,   1,   0,   1,   0,
      0,   0,   0,   0,   0,   0,
     84, 101, 120, 116, 117, 114,
    101,  83, 105, 122, 101,   0,
      1,   0,   3,   0,   1,   0,
      4,   0,   1,   0,   0,   0,
      0,   0,   0,   0, 112, 115,
     95,  50,  95,  48,   0,  77,
    105,  99, 114, 111, 115, 111,
    102, 116,  32,  40,  82,  41,
     32,  72,  76,  83,  76,  32,
     83, 104,  97, 100, 101, 114,
     32,  67, 111, 109, 112, 105,
    108, 101, 114,  32,  49,  48,
     46,  49,   0, 171,  81,   0,
      0,   5,   1,   0,  15, 160,
      0,   0,   0, 191,   0,   0,
      0,  63,   0,   0, 128,  63,
      0,   0,  32,  64,  81,   0,
      0,   5,   2,   0,  15, 160,
      0,   0, 192,  63,   0,   0,
     32, 192,   0,   0,   0,  64,
      0,   0,   0,   0,  31,   0,
      0,   2,   0,   0,   0, 128,
      0,   0,   3, 176,  31,   0,
      0,   2,   0,   0,   0, 144,
      0,   8,  15, 160,   1,   0,
      0,   2,   0,   0,   8, 128,
      1,   0,   0, 160,   4,   0,
      0,   4,   0,   0,   3, 128,
      0,   0, 228, 176,   0,   0,
    228, 160,   0,   0, 255, 128,
     19,   0,   0,   2,   0,   0,
     12, 128,   0,   0,  27, 128,
      2,   0,   0,   3,   0,   0,
      3, 128,   0,   0,  27, 129,
      0,   0, 228, 128,   2,   0,
      0,   3,   0,   0,  12, 128,
      0,   0,  27, 128,   1,   0,
      0, 160,   6,   0,   0,   2,
      1,   0,   1, 128,   0,   0,
      0, 160,   6,   0,   0,   2,
      1,   0,   2, 128,   0,   0,
     85, 160,   5,   0,   0,   3,
      2,   0,   3, 128,   0,   0,
     27, 128,   1,   0, 228, 128,
      1,   0,   0,   2,   3,   0,
      1, 128,   2,   0,   0, 128,
      2,   0,   0,   3,   0,   0,
     12, 128,   0,   0,  27, 128,
      1,   0,  85, 160,   2,   0,
      0,   3,   0,   0,   3, 128,
      0,   0, 228, 128,   1,   0,
    255, 160,   5,   0,   0,   3,
      0,   0,   3, 128,   1,   0,
    228, 128,   0,   0, 228, 128,
      4,   0,   0,   4,   1,   0,
     12, 128,   0,   0,  27, 176,
      0,   0,  27, 160,   0,   0,
    228, 129,   4,   0,   0,   4,
      2,   0,  12, 128,   1,   0,
    228, 128,   2,   0,   0, 161,
      2,   0, 170, 160,   4,   0,
      0,   4,   2,   0,  12, 128,
      1,   0, 228, 128,   2,   0,
    228, 128,   1,   0,  85, 160,
      5,   0,   0,   3,   3,   0,
     12, 128,   1,   0, 228, 128,
      2,   0, 228, 128,   4,   0,
      0,   4,   4,   0,   3, 128,
      1,   0,  27, 128,   2,   0,
      0, 160,   2,   0,  85, 160,
      5,   0,   0,   3,   4,   0,
     12, 128,   1,   0, 228, 128,
      1,   0, 228, 128,   4,   0,
      0,   4,   4,   0,   3, 128,
      4,   0,  27, 128,   4,   0,
    228, 128,   1,   0, 170, 160,
      4,   0,   0,   4,   2,   0,
     12, 128,   1,   0, 228, 128,
      2,   0, 228, 128,   4,   0,
     27, 128,   6,   0,   0,   2,
      4,   0,   1, 128,   2,   0,
    255, 128,   6,   0,   0,   2,
      4,   0,   2, 128,   2,   0,
    170, 128,   4,   0,   0,   4,
      0,   0,  12, 128,   3,   0,
    228, 128,   4,   0,  27, 128,
      0,   0, 228, 128,   5,   0,
      0,   3,   1,   0,   3, 128,
      1,   0, 228, 128,   0,   0,
     27, 128,   1,   0,   0,   2,
      3,   0,   2, 128,   1,   0,
     85, 128,   1,   0,   0,   2,
      4,   0,   2, 128,   3,   0,
     85, 128,   1,   0,   0,   2,
      2,   0,   1, 128,   1,   0,
      0, 128,   1,   0,   0,   2,
      5,   0,   1, 128,   2,   0,
      0, 128,   1,   0,   0,   2,
      4,   0,   1, 128,   0,   0,
      0, 128,   1,   0,   0,   2,
      5,   0,   2, 128,   0,   0,
     85, 128,  66,   0,   0,   3,
      0,   0,  15, 128,   3,   0,
    228, 128,   0,   8, 228, 160,
     66,   0,   0,   3,   3,   0,
     15, 128,   1,   0, 228, 128,
      0,   8, 228, 160,  66,   0,
      0,   3,   6,   0,  15, 128,
      2,   0, 228, 128,   0,   8,
    228, 160,  66,   0,   0,   3,
      5,   0,  15, 128,   5,   0,
    228, 128,   0,   8, 228, 160,
     66,   0,   0,   3,   7,   0,
     15, 128,   4,   0, 228, 128,
      0,   8, 228, 160,   4,   0,
      0,   4,   1,   0,   3, 128,
      1,   0,  27, 128,   1,   0,
     85, 161,   1,   0, 170, 160,
      4,   0,   0,   4,   1,   0,
      3, 128,   1,   0,  27, 128,
      1,   0, 228, 128,   1,   0,
      0, 160,   5,   0,   0,   3,
      1,   0,   3, 128,   1,   0,
    228, 128,   1,   0,  27, 128,
      4,   0,   0,   4,   1,   0,
     12, 128,   1,   0, 228, 128,
      1,   0,  85, 160,   1,   0,
      0, 160,   5,   0,   0,   3,
      1,   0,  12, 128,   1,   0,
    228, 128,   4,   0, 228, 128,
      5,   0,   0,   3,   0,   0,
      8, 128,   2,   0, 170, 128,
      1,   0,   0, 128,   5,   0,
      0,   3,   0,   0,   7, 128,
      0,   0, 255, 128,   0,   0,
    228, 128,   4,   0,   0,   4,
      0,   0,   8, 128,   2,   0,
    255, 128,   1,   0,  85, 128,
      0,   0, 255, 128,   5,   0,
      0,   3,   3,   0,   8, 128,
      1,   0,  85, 128,   2,   0,
    255, 128,   4,   0,   0,   4,
      0,   0,   8, 128,   2,   0,
    255, 128,   2,   0, 170, 128,
      0,   0, 255, 128,   4,   0,
      0,   4,   0,   0,   8, 128,
      1,   0, 255, 128,   2,   0,
    170, 128,   0,   0, 255, 128,
      4,   0,   0,   4,   0,   0,
      8, 128,   2,   0, 255, 128,
      1,   0, 170, 128,   0,   0,
    255, 128,   6,   0,   0,   2,
      0,   0,   8, 128,   0,   0,
    255, 128,   4,   0,   0,   4,
      0,   0,   7, 128,   6,   0,
    228, 128,   3,   0, 255, 128,
      0,   0, 228, 128,   5,   0,
      0,   3,   3,   0,   8, 128,
      2,   0, 170, 128,   2,   0,
    255, 128,   4,   0,   0,   4,
      0,   0,   7, 128,   3,   0,
    228, 128,   3,   0, 255, 128,
      0,   0, 228, 128,   5,   0,
      0,   3,   5,   0,   8, 128,
      2,   0, 170, 128,   1,   0,
    255, 128,   5,   0,   0,   3,
      7,   0,   8, 128,   1,   0,
    170, 128,   2,   0, 255, 128,
      4,   0,   0,   4,   0,   0,
      7, 128,   7,   0, 228, 128,
      5,   0, 255, 128,   0,   0,
    228, 128,   4,   0,   0,   4,
      0,   0,   7, 128,   5,   0,
    228, 128,   7,   0, 255, 128,
      0,   0, 228, 128,   5,   0,
      0,   3,   0,   0,   7, 128,
      0,   0, 255, 128,   0,   0,
    228, 128,   1,   0,   0,   2,
      0,   0,   8, 128,   1,   0,
    170, 160,   1,   0,   0,   2,
      0,   8,  15, 128,   0,   0,
    228, 128, 255, 255,   0,   0
    };


/* lanczos2 upscaling */

#if 0
// fxc.exe /Tps_3_0 shader.hlsl /Fhshader.h
/*
// The following code is licensed under the MIT license:
// Hyllian's jinc windowed-jinc 2-lobe sharper with anti-ringing Shader
// Copyright (C) 2011-2016 Hyllian/Jararaca - sergiogdb@gmail.com
// Ported from: https://github.com/libretro/glsl-shaders/blob/09e2942efbab2f51b60ff0b93b7761b0b0570910/windowed/shaders/lanczos2-sharp.glsl

uniform sampler2D SurfaceTex;

float4 TextureSize : register(c0);

#define JINC2_WINDOW_SINC 0.5
#define JINC2_SINC 1.0
#define JINC2_AR_STRENGTH 0.8

static const float pi = 3.1415926535897932384626433832795;
static const float wa = JINC2_WINDOW_SINC*pi;
static const float wb = JINC2_SINC*pi;

// Calculates the distance between two points
float d(float2 pt1, float2 pt2)
{
  float2 v = pt2 - pt1;
  return sqrt(dot(v,v));
}

float3 min4(float3 a, float3 b, float3 c, float3 d)
{
    return min(a, min(b, min(c, d)));
}

float3 max4(float3 a, float3 b, float3 c, float3 d)
{
    return max(a, max(b, max(c, d)));
}

float4 resampler(float4 x)
{
   float4 res;

   res.x = (x.x==0.0) ?  wa*wb  :  sin(x.x*wa)*sin(x.x*wb)/(x.x*x.x);
   res.y = (x.y==0.0) ?  wa*wb  :  sin(x.y*wa)*sin(x.y*wb)/(x.y*x.y);
   res.z = (x.z==0.0) ?  wa*wb  :  sin(x.z*wa)*sin(x.z*wb)/(x.z*x.z);
   res.w = (x.w==0.0) ?  wa*wb  :  sin(x.w*wa)*sin(x.w*wb)/(x.w*x.w);

   return res;
}

float4 lanczos2(float2 coord)
{
    float3 color;
    float4 weights[4];

    float2 dx = float2(1.0, 0.0);
    float2 dy = float2(0.0, 1.0);

    float2 pc = coord*TextureSize.xy;

    float2 tc = (floor(pc-float2(0.5,0.5))+float2(0.5,0.5));

    weights[0] = resampler(float4(d(pc, tc    -dx    -dy), d(pc, tc           -dy), d(pc, tc    +dx    -dy), d(pc, tc+2.0*dx    -dy)));
    weights[1] = resampler(float4(d(pc, tc    -dx       ), d(pc, tc              ), d(pc, tc    +dx       ), d(pc, tc+2.0*dx       )));
    weights[2] = resampler(float4(d(pc, tc    -dx    +dy), d(pc, tc           +dy), d(pc, tc    +dx    +dy), d(pc, tc+2.0*dx    +dy)));
    weights[3] = resampler(float4(d(pc, tc    -dx+2.0*dy), d(pc, tc       +2.0*dy), d(pc, tc    +dx+2.0*dy), d(pc, tc+2.0*dx+2.0*dy)));

    dx = dx/TextureSize.xy;
    dy = dy/TextureSize.xy;
    tc = tc/TextureSize.xy;

    float3 c00 = tex2D(SurfaceTex, tc    -dx    -dy).xyz;
    float3 c10 = tex2D(SurfaceTex, tc           -dy).xyz;
    float3 c20 = tex2D(SurfaceTex, tc    +dx    -dy).xyz;
    float3 c30 = tex2D(SurfaceTex, tc+2.0*dx    -dy).xyz;
    float3 c01 = tex2D(SurfaceTex, tc    -dx       ).xyz;
    float3 c11 = tex2D(SurfaceTex, tc              ).xyz;
    float3 c21 = tex2D(SurfaceTex, tc    +dx       ).xyz;
    float3 c31 = tex2D(SurfaceTex, tc+2.0*dx       ).xyz;
    float3 c02 = tex2D(SurfaceTex, tc    -dx    +dy).xyz;
    float3 c12 = tex2D(SurfaceTex, tc           +dy).xyz;
    float3 c22 = tex2D(SurfaceTex, tc    +dx    +dy).xyz;
    float3 c32 = tex2D(SurfaceTex, tc+2.0*dx    +dy).xyz;
    float3 c03 = tex2D(SurfaceTex, tc    -dx+2.0*dy).xyz;
    float3 c13 = tex2D(SurfaceTex, tc       +2.0*dy).xyz;
    float3 c23 = tex2D(SurfaceTex, tc    +dx+2.0*dy).xyz;
    float3 c33 = tex2D(SurfaceTex, tc+2.0*dx+2.0*dy).xyz;

    color = tex2D(SurfaceTex, coord).xyz;

    //  Get min/max samples
    float3 min_sample = min4(c11, c21, c12, c22);
    float3 max_sample = max4(c11, c21, c12, c22);

    color = float3(dot(weights[0], float4(c00.x, c10.x, c20.x, c30.x)), dot(weights[0], float4(c00.y, c10.y, c20.y, c30.y)), dot(weights[0], float4(c00.z, c10.z, c20.z, c30.z)));
    color+= float3(dot(weights[1], float4(c01.x, c11.x, c21.x, c31.x)), dot(weights[1], float4(c01.y, c11.y, c21.y, c31.y)), dot(weights[1], float4(c01.z, c11.z, c21.z, c31.z)));
    color+= float3(dot(weights[2], float4(c02.x, c12.x, c22.x, c32.x)), dot(weights[2], float4(c02.y, c12.y, c22.y, c32.y)), dot(weights[2], float4(c02.z, c12.z, c22.z, c32.z)));
    color+= float3(dot(weights[3], float4(c03.x, c13.x, c23.x, c33.x)), dot(weights[3], float4(c03.y, c13.y, c23.y, c33.y)), dot(weights[3], float4(c03.z, c13.z, c23.z, c33.z)));
    color = color/(dot(weights[0], float4(1,1,1,1)) + dot(weights[1], float4(1,1,1,1)) + dot(weights[2], float4(1,1,1,1)) + dot(weights[3], float4(1,1,1,1)));

    // Anti-ringing
    float3 aux = color;
    color = clamp(color, min_sample, max_sample);
    color = lerp(aux, color, JINC2_AR_STRENGTH);

    // final sum and weight normalization
    return float4(color, 1.0);
}

float4 main(float2 texCoords : TEXCOORD) : COLOR
{
    return lanczos2(texCoords);
}

*/
#endif

const BYTE D3D9_LANCZOS2_SHADER[] =
    {
      0,   3, 255, 255, 254, 255,
     44,   0,  67,  84,  65,  66,
     28,   0,   0,   0, 131,   0,
      0,   0,   0,   3, 255, 255,
      2,   0,   0,   0,  28,   0,
      0,   0,   0,   1,   0,   0,
    124,   0,   0,   0,  68,   0,
      0,   0,   3,   0,   0,   0,
      1,   0,   0,   0,  80,   0,
      0,   0,   0,   0,   0,   0,
     96,   0,   0,   0,   2,   0,
      0,   0,   1,   0,   2,   0,
    108,   0,   0,   0,   0,   0,
      0,   0,  83, 117, 114, 102,
     97,  99, 101,  84, 101, 120,
      0, 171,   4,   0,  12,   0,
      1,   0,   1,   0,   1,   0,
      0,   0,   0,   0,   0,   0,
     84, 101, 120, 116, 117, 114,
    101,  83, 105, 122, 101,   0,
      1,   0,   3,   0,   1,   0,
      4,   0,   1,   0,   0,   0,
      0,   0,   0,   0, 112, 115,
     95,  51,  95,  48,   0,  77,
    105,  99, 114, 111, 115, 111,
    102, 116,  32,  40,  82,  41,
     32,  72,  76,  83,  76,  32,
     83, 104,  97, 100, 101, 114,
     32,  67, 111, 109, 112, 105,
    108, 101, 114,  32,  49,  48,
     46,  49,   0, 171,  81,   0,
      0,   5,   1,   0,  15, 160,
    230, 233, 157,  64,   0,   0,
      0,   0,   0,   0, 128,  63,
      0,   0,   0,  64,  81,   0,
      0,   5,   2,   0,  15, 160,
      0,   0, 128,  62,   0,   0,
      0,  63, 219,  15, 201,  64,
    219,  15,  73, 192,  81,   0,
      0,   5,   3,   0,  15, 160,
      0,   0,   0, 191,   0,   0,
      0,  63,   0,   0,   0,   0,
      0,   0, 192,  63,  81,   0,
      0,   5,   4,   0,  15, 160,
      0,   0,  32,  64,   0,   0,
      0, 191,   0,   0, 192,  63,
      0,   0,   0,  63,  81,   0,
      0,   5,   5,   0,  15, 160,
    205, 204,  76,  63,   0,   0,
      0,   0,   0,   0,   0,   0,
      0,   0,   0,   0,  31,   0,
      0,   2,   5,   0,   0, 128,
      0,   0,   3, 144,  31,   0,
      0,   2,   0,   0,   0, 144,
      0,   8,  15, 160,   1,   0,
      0,   2,   0,   0,   1, 128,
      3,   0,   0, 160,   4,   0,
      0,   4,   0,   0,   3, 128,
      0,   0, 228, 144,   0,   0,
    228, 160,   0,   0,   0, 128,
     19,   0,   0,   2,   0,   0,
     12, 128,   0,   0,  68, 128,
      2,   0,   0,   3,   0,   0,
      3, 128,   0,   0, 238, 129,
      0,   0, 228, 128,   2,   0,
      0,   3,   0,   0,  12, 128,
      0,   0,  68, 128,   3,   0,
      0, 160,   4,   0,   0,   4,
      0,   0,  12, 128,   0,   0,
     68, 144,   0,   0,  68, 161,
      0,   0, 228, 128,  90,   0,
      0,   4,   0,   0,   4, 128,
      0,   0, 238, 128,   0,   0,
    238, 128,   3,   0, 170, 160,
      7,   0,   0,   2,   0,   0,
      4, 128,   0,   0, 170, 128,
      6,   0,   0,   2,   0,   0,
      4, 128,   0,   0, 170, 128,
      4,   0,   0,   4,   1,   0,
      3, 128,   0,   0, 170, 128,
      2,   0, 228, 160,   2,   0,
     85, 160,  19,   0,   0,   2,
      1,   0,   3, 128,   1,   0,
    228, 128,   4,   0,   0,   4,
      1,   0,   3, 128,   1,   0,
    228, 128,   2,   0, 170, 160,
      2,   0, 255, 160,  37,   0,
      0,   2,   2,   0,   2, 128,
      1,   0,   0, 128,  37,   0,
      0,   2,   3,   0,   2, 128,
      1,   0,  85, 128,   5,   0,
      0,   3,   0,   0,   8, 128,
      2,   0,  85, 128,   3,   0,
     85, 128,   5,   0,   0,   3,
      1,   0,   1, 128,   0,   0,
    170, 128,   0,   0, 170, 128,
      6,   0,   0,   2,   1,   0,
      1, 128,   1,   0,   0, 128,
      5,   0,   0,   3,   0,   0,
      8, 128,   0,   0, 255, 128,
      1,   0,   0, 128,  88,   0,
      0,   4,   1,   0,   1, 128,
      0,   0, 170, 129,   1,   0,
      0, 160,   0,   0, 255, 128,
      4,   0,   0,   4,   0,   0,
     12, 128,   0,   0,  68, 144,
      0,   0,  68, 161,   0,   0,
     68, 128,   2,   0,   0,   3,
      2,   0,  15, 128,   0,   0,
     68, 128,   3,   0,  84, 160,
      2,   0,   0,   3,   3,   0,
     15, 128,   0,   0, 238, 128,
      3,   0,  49, 160,  90,   0,
      0,   4,   0,   0,   1, 128,
      3,   0, 228, 128,   3,   0,
    228, 128,   3,   0, 170, 160,
     90,   0,   0,   4,   0,   0,
      2, 128,   3,   0, 238, 128,
      3,   0, 238, 128,   3,   0,
    170, 160,   7,   0,   0,   2,
      0,   0,   2, 128,   0,   0,
     85, 128,   6,   0,   0,   2,
      0,   0,   2, 128,   0,   0,
     85, 128,   7,   0,   0,   2,
      0,   0,   1, 128,   0,   0,
      0, 128,   6,   0,   0,   2,
      0,   0,   1, 128,   0,   0,
      0, 128,   4,   0,   0,   4,
      3,   0,   3, 128,   0,   0,
      0, 128,   2,   0, 228, 160,
      2,   0,  85, 160,  19,   0,
      0,   2,   3,   0,   3, 128,
      3,   0, 228, 128,   4,   0,
      0,   4,   3,   0,   3, 128,
      3,   0, 228, 128,   2,   0,
    170, 160,   2,   0, 255, 160,
     37,   0,   0,   2,   4,   0,
      2, 128,   3,   0,   0, 128,
     37,   0,   0,   2,   5,   0,
      2, 128,   3,   0,  85, 128,
      5,   0,   0,   3,   3,   0,
      1, 128,   4,   0,  85, 128,
      5,   0,  85, 128,   5,   0,
      0,   3,   3,   0,   2, 128,
      0,   0,   0, 128,   0,   0,
      0, 128,   6,   0,   0,   2,
      3,   0,   2, 128,   3,   0,
     85, 128,   5,   0,   0,   3,
      3,   0,   1, 128,   3,   0,
     85, 128,   3,   0,   0, 128,
     88,   0,   0,   4,   1,   0,
      2, 128,   0,   0,   0, 129,
      1,   0,   0, 160,   3,   0,
      0, 128,   4,   0,   0,   4,
      3,   0,   3, 128,   0,   0,
     85, 128,   2,   0, 228, 160,
      2,   0,  85, 160,  19,   0,
      0,   2,   3,   0,   3, 128,
      3,   0, 228, 128,   4,   0,
      0,   4,   3,   0,   3, 128,
      3,   0, 228, 128,   2,   0,
    170, 160,   2,   0, 255, 160,
     37,   0,   0,   2,   4,   0,
      2, 128,   3,   0,   0, 128,
     37,   0,   0,   2,   5,   0,
      2, 128,   3,   0,  85, 128,
      5,   0,   0,   3,   0,   0,
      1, 128,   4,   0,  85, 128,
      5,   0,  85, 128,   5,   0,
      0,   3,   3,   0,   1, 128,
      0,   0,  85, 128,   0,   0,
     85, 128,   6,   0,   0,   2,
      3,   0,   1, 128,   3,   0,
      0, 128,   5,   0,   0,   3,
      0,   0,   1, 128,   0,   0,
      0, 128,   3,   0,   0, 128,
     88,   0,   0,   4,   1,   0,
      4, 128,   0,   0,  85, 129,
      1,   0,   0, 160,   0,   0,
      0, 128,   2,   0,   0,   3,
      3,   0,  15, 128,   0,   0,
    238, 128,   4,   0, 228, 160,
     90,   0,   0,   4,   0,   0,
      1, 128,   3,   0, 228, 128,
      3,   0, 228, 128,   3,   0,
    170, 160,  90,   0,   0,   4,
      0,   0,   2, 128,   3,   0,
    238, 128,   3,   0, 238, 128,
      3,   0, 170, 160,   7,   0,
      0,   2,   0,   0,   2, 128,
      0,   0,  85, 128,   6,   0,
      0,   2,   0,   0,   2, 128,
      0,   0,  85, 128,   7,   0,
      0,   2,   0,   0,   1, 128,
      0,   0,   0, 128,   6,   0,
      0,   2,   0,   0,   1, 128,
      0,   0,   0, 128,   4,   0,
      0,   4,   3,   0,   3, 128,
      0,   0,   0, 128,   2,   0,
    228, 160,   2,   0,  85, 160,
     19,   0,   0,   2,   3,   0,
      3, 128,   3,   0, 228, 128,
      4,   0,   0,   4,   3,   0,
      3, 128,   3,   0, 228, 128,
      2,   0, 170, 160,   2,   0,
    255, 160,  37,   0,   0,   2,
      4,   0,   2, 128,   3,   0,
      0, 128,  37,   0,   0,   2,
      5,   0,   2, 128,   3,   0,
     85, 128,   5,   0,   0,   3,
      3,   0,   1, 128,   4,   0,
     85, 128,   5,   0,  85, 128,
      5,   0,   0,   3,   3,   0,
      2, 128,   0,   0,   0, 128,
      0,   0,   0, 128,   6,   0,
      0,   2,   3,   0,   2, 128,
      3,   0,  85, 128,   5,   0,
      0,   3,   3,   0,   1, 128,
      3,   0,  85, 128,   3,   0,
      0, 128,  88,   0,   0,   4,
      1,   0,   8, 128,   0,   0,
      0, 129,   1,   0,   0, 160,
      3,   0,   0, 128,   1,   0,
      0,   2,   3,   0,   2, 128,
      3,   0, 170, 160,   6,   0,
      0,   2,   4,   0,   1, 128,
      0,   0,   0, 160,   1,   0,
      0,   2,   3,   0,   1, 128,
      4,   0,   0, 128,   6,   0,
      0,   2,   4,   0,   2, 128,
      0,   0,  85, 160,   4,   0,
      0,   4,   3,   0,  12, 128,
      2,   0, 228, 128,   4,   0,
     68, 128,   3,   0,  68, 129,
      4,   0,   0,   4,   3,   0,
      3, 128,   2,   0, 238, 128,
      4,   0, 228, 128,   3,   0,
    228, 128,   4,   0,   0,   4,
      4,   0,  12, 128,   4,   0,
     68, 128,   1,   0, 148, 161,
      3,   0, 228, 128,  66,   0,
      0,   3,   5,   0,  15, 128,
      4,   0, 238, 128,   0,   8,
    228, 160,   1,   0,   0,   2,
      6,   0,   1, 128,   5,   0,
      0, 128,   4,   0,   0,   4,
      4,   0,  12, 128,   4,   0,
     68, 128,   1,   0, 148, 161,
      3,   0,  68, 128,  66,   0,
      0,   3,   7,   0,  15, 128,
      4,   0, 238, 128,   0,   8,
    228, 160,   1,   0,   0,   2,
      6,   0,   4, 128,   7,   0,
      0, 128,   5,   0,   0,   3,
      4,   0,  12, 128,   2,   0,
    228, 128,   4,   0,  68, 128,
      4,   0,   0,   4,   5,   0,
      9, 128,   4,   0, 100, 128,
      1,   0, 103, 160,   4,   0,
    230, 128,  66,   0,   0,   3,
      8,   0,  15, 128,   4,   0,
    238, 128,   0,   8, 228, 160,
      4,   0,   0,   4,   4,   0,
     12, 128,   4,   0,  68, 128,
      1,   0, 148, 161,   5,   0,
    196, 128,  66,   0,   0,   3,
      9,   0,  15, 128,   4,   0,
    238, 128,   0,   8, 228, 160,
      1,   0,   0,   2,   6,   0,
      8, 128,   9,   0,   0, 128,
      5,   0,   0,   3,   4,   0,
     12, 128,   4,   0,  68, 128,
      1,   0, 148, 160,   4,   0,
      0,   4,   9,   0,   9, 128,
      2,   0, 230, 128,   4,   0,
    100, 128,   4,   0, 230, 129,
      4,   0,   0,   4,   4,   0,
     12, 128,   2,   0, 228, 128,
      4,   0,  68, 128,   4,   0,
    228, 128,  66,   0,   0,   3,
     10,   0,  15, 128,   4,   0,
    238, 128,   0,   8, 228, 160,
     66,   0,   0,   3,  11,   0,
     15, 128,   9,   0, 236, 128,
      0,   8, 228, 160,   1,   0,
      0,   2,   6,   0,   2, 128,
     11,   0,   0, 128,   9,   0,
      0,   3,   6,   0,   1, 128,
      1,   0, 228, 128,   6,   0,
    228, 128,   1,   0,   0,   2,
     12,   0,   1, 128,   5,   0,
     85, 128,   1,   0,   0,   2,
      7,   0,   1, 128,   5,   0,
    170, 128,   1,   0,   0,   2,
     12,   0,   4, 128,   7,   0,
     85, 128,   1,   0,   0,   2,
     12,   0,   2, 128,  11,   0,
     85, 128,   1,   0,   0,   2,
      7,   0,   2, 128,  11,   0,
    170, 128,   1,   0,   0,   2,
     12,   0,   8, 128,   9,   0,
     85, 128,   1,   0,   0,   2,
      7,   0,   8, 128,   9,   0,
    170, 128,   9,   0,   0,   3,
      6,   0,   4, 128,   1,   0,
    228, 128,   7,   0, 228, 128,
      9,   0,   0,   3,   6,   0,
      2, 128,   1,   0, 228, 128,
     12,   0, 228, 128,   9,   0,
      0,   3,   0,   0,   1, 128,
      1,   0, 228, 128,   1,   0,
    170, 160,   4,   0,   0,   4,
      1,   0,  15, 128,   0,   0,
     68, 144,   0,   0,  68, 161,
      2,   0, 228, 128,  90,   0,
      0,   4,   1,   0,   1, 128,
      1,   0, 228, 128,   1,   0,
    228, 128,   3,   0, 170, 160,
     90,   0,   0,   4,   1,   0,
      2, 128,   1,   0, 238, 128,
      1,   0, 238, 128,   3,   0,
    170, 160,   7,   0,   0,   2,
      1,   0,   2, 128,   1,   0,
     85, 128,   6,   0,   0,   2,
      1,   0,   2, 128,   1,   0,
     85, 128,   7,   0,   0,   2,
      1,   0,   1, 128,   1,   0,
      0, 128,   6,   0,   0,   2,
      1,   0,   1, 128,   1,   0,
      0, 128,   4,   0,   0,   4,
      1,   0,  12, 128,   1,   0,
      0, 128,   2,   0,  68, 160,
      2,   0,  85, 160,  19,   0,
      0,   2,   1,   0,  12, 128,
      1,   0, 228, 128,   4,   0,
      0,   4,   1,   0,  12, 128,
      1,   0, 228, 128,   2,   0,
    170, 160,   2,   0, 255, 160,
     37,   0,   0,   2,   7,   0,
      2, 128,   1,   0, 170, 128,
     37,   0,   0,   2,   9,   0,
      2, 128,   1,   0, 255, 128,
      5,   0,   0,   3,   1,   0,
      4, 128,   7,   0,  85, 128,
      9,   0,  85, 128,   5,   0,
      0,   3,   1,   0,   8, 128,
      1,   0,   0, 128,   1,   0,
      0, 128,   6,   0,   0,   2,
      1,   0,   8, 128,   1,   0,
    255, 128,   5,   0,   0,   3,
      1,   0,   4, 128,   1,   0,
    255, 128,   1,   0, 170, 128,
     88,   0,   0,   4,   7,   0,
      1, 128,   1,   0,   0, 129,
      1,   0,   0, 160,   1,   0,
    170, 128,   4,   0,   0,   4,
      1,   0,   5, 128,   1,   0,
     85, 128,   2,   0, 212, 160,
      2,   0,  85, 160,  19,   0,
      0,   2,   1,   0,   5, 128,
      1,   0, 228, 128,   4,   0,
      0,   4,   1,   0,   5, 128,
      1,   0, 228, 128,   2,   0,
    170, 160,   2,   0, 255, 160,
     37,   0,   0,   2,   9,   0,
      2, 128,   1,   0,   0, 128,
     37,   0,   0,   2,  11,   0,
      2, 128,   1,   0, 170, 128,
      5,   0,   0,   3,   1,   0,
      1, 128,   9,   0,  85, 128,
     11,   0,  85, 128,   5,   0,
      0,   3,   1,   0,   4, 128,
      1,   0,  85, 128,   1,   0,
     85, 128,   6,   0,   0,   2,
      1,   0,   4, 128,   1,   0,
    170, 128,   5,   0,   0,   3,
      1,   0,   1, 128,   1,   0,
    170, 128,   1,   0,   0, 128,
     88,   0,   0,   4,   7,   0,
      2, 128,   1,   0,  85, 129,
      1,   0,   0, 160,   1,   0,
      0, 128,   4,   0,   0,   4,
      1,   0,   3, 128,   0,   0,
     85, 128,   2,   0, 228, 160,
      2,   0,  85, 160,  19,   0,
      0,   2,   1,   0,   3, 128,
      1,   0, 228, 128,   4,   0,
      0,   4,   1,   0,   3, 128,
      1,   0, 228, 128,   2,   0,
    170, 160,   2,   0, 255, 160,
     37,   0,   0,   2,   9,   0,
      2, 128,   1,   0,   0, 128,
     37,   0,   0,   2,  11,   0,
      2, 128,   1,   0,  85, 128,
      5,   0,   0,   3,   1,   0,
      1, 128,   9,   0,  85, 128,
     11,   0,  85, 128,   5,   0,
      0,   3,   1,   0,   2, 128,
      0,   0,  85, 128,   0,   0,
     85, 128,   6,   0,   0,   2,
      1,   0,   2, 128,   1,   0,
     85, 128,   5,   0,   0,   3,
      1,   0,   1, 128,   1,   0,
     85, 128,   1,   0,   0, 128,
     88,   0,   0,   4,   7,   0,
      4, 128,   0,   0,  85, 129,
      1,   0,   0, 160,   1,   0,
      0, 128,   2,   0,   0,   3,
      1,   0,  15, 128,   0,   0,
    238, 128,   4,   0, 156, 160,
     90,   0,   0,   4,   0,   0,
      2, 128,   1,   0, 228, 128,
      1,   0, 228, 128,   3,   0,
    170, 160,  90,   0,   0,   4,
      1,   0,   1, 128,   1,   0,
    238, 128,   1,   0, 238, 128,
      3,   0, 170, 160,   7,   0,
      0,   2,   1,   0,   1, 128,
      1,   0,   0, 128,   6,   0,
      0,   2,   1,   0,   1, 128,
      1,   0,   0, 128,   7,   0,
      0,   2,   0,   0,   2, 128,
      0,   0,  85, 128,   6,   0,
      0,   2,   0,   0,   2, 128,
      0,   0,  85, 128,   4,   0,
      0,   4,   1,   0,   6, 128,
      0,   0,  85, 128,   2,   0,
    208, 160,   2,   0,  85, 160,
     19,   0,   0,   2,   1,   0,
      6, 128,   1,   0, 228, 128,
      4,   0,   0,   4,   1,   0,
      6, 128,   1,   0, 228, 128,
      2,   0, 170, 160,   2,   0,
    255, 160,  37,   0,   0,   2,
      9,   0,   2, 128,   1,   0,
     85, 128,  37,   0,   0,   2,
     11,   0,   2, 128,   1,   0,
    170, 128,   5,   0,   0,   3,
      1,   0,   2, 128,   9,   0,
     85, 128,  11,   0,  85, 128,
      5,   0,   0,   3,   1,   0,
      4, 128,   0,   0,  85, 128,
      0,   0,  85, 128,   6,   0,
      0,   2,   1,   0,   4, 128,
      1,   0, 170, 128,   5,   0,
      0,   3,   1,   0,   2, 128,
      1,   0, 170, 128,   1,   0,
     85, 128,  88,   0,   0,   4,
      7,   0,   8, 128,   0,   0,
     85, 129,   1,   0,   0, 160,
      1,   0,  85, 128,  66,   0,
      0,   3,   9,   0,  15, 128,
      3,   0, 238, 128,   0,   8,
    228, 160,   1,   0,   0,   2,
     11,   0,   1, 128,   9,   0,
      0, 128,  66,   0,   0,   3,
     12,   0,  15, 128,   3,   0,
    228, 128,   0,   8, 228, 160,
      1,   0,   0,   2,  11,   0,
      4, 128,  12,   0,   0, 128,
     66,   0,   0,   3,  13,   0,
     15, 128,   5,   0, 236, 128,
      0,   8, 228, 160,   1,   0,
      0,   2,  11,   0,   8, 128,
     13,   0,   0, 128,   1,   0,
      0,   2,  11,   0,   2, 128,
      8,   0,   0, 128,   9,   0,
      0,   3,  11,   0,   1, 128,
      7,   0, 228, 128,  11,   0,
    228, 128,   1,   0,   0,   2,
     14,   0,   1, 128,   9,   0,
     85, 128,   1,   0,   0,   2,
      9,   0,   1, 128,   9,   0,
    170, 128,   1,   0,   0,   2,
     14,   0,   8, 128,  13,   0,
     85, 128,   1,   0,   0,   2,
      9,   0,   8, 128,  13,   0,
    170, 128,   1,   0,   0,   2,
     14,   0,   4, 128,  12,   0,
     85, 128,   1,   0,   0,   2,
     14,   0,   2, 128,   8,   0,
     85, 128,   9,   0,   0,   3,
     11,   0,   2, 128,   7,   0,
    228, 128,  14,   0, 228, 128,
      1,   0,   0,   2,   9,   0,
      4, 128,  12,   0, 170, 128,
      1,   0,   0,   2,   9,   0,
      2, 128,   8,   0, 170, 128,
      9,   0,   0,   3,  11,   0,
      4, 128,   7,   0, 228, 128,
      9,   0, 228, 128,   9,   0,
      0,   3,   0,   0,   2, 128,
      7,   0, 228, 128,   1,   0,
    170, 160,   2,   0,   0,   3,
      0,   0,   1, 128,   0,   0,
     85, 128,   0,   0,   0, 128,
      2,   0,   0,   3,   1,   0,
     14, 128,   6,   0, 144, 128,
     11,   0, 144, 128,   4,   0,
      0,   4,   2,   0,   3, 128,
      1,   0,   0, 128,   2,   0,
    228, 160,   2,   0,  85, 160,
     19,   0,   0,   2,   2,   0,
      3, 128,   2,   0, 228, 128,
      4,   0,   0,   4,   2,   0,
      3, 128,   2,   0, 228, 128,
      2,   0, 170, 160,   2,   0,
    255, 160,  37,   0,   0,   2,
      6,   0,   2, 128,   2,   0,
      0, 128,  37,   0,   0,   2,
      7,   0,   2, 128,   2,   0,
     85, 128,   5,   0,   0,   3,
      0,   0,   2, 128,   6,   0,
     85, 128,   7,   0,  85, 128,
      5,   0,   0,   3,   2,   0,
      1, 128,   1,   0,   0, 128,
      1,   0,   0, 128,   6,   0,
      0,   2,   2,   0,   1, 128,
      2,   0,   0, 128,   5,   0,
      0,   3,   0,   0,   2, 128,
      0,   0,  85, 128,   2,   0,
      0, 128,  88,   0,   0,   4,
      6,   0,   1, 128,   1,   0,
      0, 129,   1,   0,   0, 160,
      0,   0,  85, 128,   2,   0,
      0,   3,   7,   0,  15, 128,
      0,   0, 238, 128,   3,   0,
    253, 160,  90,   0,   0,   4,
      0,   0,   2, 128,   7,   0,
    228, 128,   7,   0, 228, 128,
      3,   0, 170, 160,  90,   0,
      0,   4,   1,   0,   1, 128,
      7,   0, 238, 128,   7,   0,
    238, 128,   3,   0, 170, 160,
      7,   0,   0,   2,   1,   0,
      1, 128,   1,   0,   0, 128,
      6,   0,   0,   2,   1,   0,
      1, 128,   1,   0,   0, 128,
      7,   0,   0,   2,   0,   0,
      2, 128,   0,   0,  85, 128,
      6,   0,   0,   2,   0,   0,
      2, 128,   0,   0,  85, 128,
      4,   0,   0,   4,   2,   0,
      3, 128,   0,   0,  85, 128,
      2,   0, 228, 160,   2,   0,
     85, 160,  19,   0,   0,   2,
      2,   0,   3, 128,   2,   0,
    228, 128,   4,   0,   0,   4,
      2,   0,   3, 128,   2,   0,
    228, 128,   2,   0, 170, 160,
      2,   0, 255, 160,  37,   0,
      0,   2,   7,   0,   2, 128,
      2,   0,   0, 128,  37,   0,
      0,   2,   9,   0,   2, 128,
      2,   0,  85, 128,   5,   0,
      0,   3,   2,   0,   1, 128,
      7,   0,  85, 128,   9,   0,
     85, 128,   5,   0,   0,   3,
      2,   0,   2, 128,   0,   0,
     85, 128,   0,   0,  85, 128,
      6,   0,   0,   2,   2,   0,
      2, 128,   2,   0,  85, 128,
      5,   0,   0,   3,   2,   0,
      1, 128,   2,   0,  85, 128,
      2,   0,   0, 128,  88,   0,
      0,   4,   6,   0,   2, 128,
      0,   0,  85, 129,   1,   0,
      0, 160,   2,   0,   0, 128,
      4,   0,   0,   4,   2,   0,
      3, 128,   1,   0,   0, 128,
      2,   0, 228, 160,   2,   0,
     85, 160,  19,   0,   0,   2,
      2,   0,   3, 128,   2,   0,
    228, 128,   4,   0,   0,   4,
      2,   0,   3, 128,   2,   0,
    228, 128,   2,   0, 170, 160,
      2,   0, 255, 160,  37,   0,
      0,   2,   7,   0,   2, 128,
      2,   0,   0, 128,  37,   0,
      0,   2,   9,   0,   2, 128,
      2,   0,  85, 128,   5,   0,
      0,   3,   0,   0,   2, 128,
      7,   0,  85, 128,   9,   0,
     85, 128,   5,   0,   0,   3,
      2,   0,   1, 128,   1,   0,
      0, 128,   1,   0,   0, 128,
      6,   0,   0,   2,   2,   0,
      1, 128,   2,   0,   0, 128,
      5,   0,   0,   3,   0,   0,
      2, 128,   0,   0,  85, 128,
      2,   0,   0, 128,  88,   0,
      0,   4,   6,   0,   4, 128,
      1,   0,   0, 129,   1,   0,
      0, 160,   0,   0,  85, 128,
      2,   0,   0,   3,   7,   0,
     15, 128,   0,   0, 238, 128,
      4,   0,  24, 160,  90,   0,
      0,   4,   0,   0,   2, 128,
      7,   0, 228, 128,   7,   0,
    228, 128,   3,   0, 170, 160,
     90,   0,   0,   4,   1,   0,
      1, 128,   7,   0, 238, 128,
      7,   0, 238, 128,   3,   0,
    170, 160,   7,   0,   0,   2,
      1,   0,   1, 128,   1,   0,
      0, 128,   6,   0,   0,   2,
      1,   0,   1, 128,   1,   0,
      0, 128,   7,   0,   0,   2,
      0,   0,   2, 128,   0,   0,
     85, 128,   6,   0,   0,   2,
      0,   0,   2, 128,   0,   0,
     85, 128,   4,   0,   0,   4,
      2,   0,   3, 128,   0,   0,
     85, 128,   2,   0, 228, 160,
      2,   0,  85, 160,  19,   0,
      0,   2,   2,   0,   3, 128,
      2,   0, 228, 128,   4,   0,
      0,   4,   2,   0,   3, 128,
      2,   0, 228, 128,   2,   0,
    170, 160,   2,   0, 255, 160,
     37,   0,   0,   2,   7,   0,
      2, 128,   2,   0,   0, 128,
     37,   0,   0,   2,   9,   0,
      2, 128,   2,   0,  85, 128,
      5,   0,   0,   3,   2,   0,
      1, 128,   7,   0,  85, 128,
      9,   0,  85, 128,   5,   0,
      0,   3,   2,   0,   2, 128,
      0,   0,  85, 128,   0,   0,
     85, 128,   6,   0,   0,   2,
      2,   0,   2, 128,   2,   0,
     85, 128,   5,   0,   0,   3,
      2,   0,   1, 128,   2,   0,
     85, 128,   2,   0,   0, 128,
     88,   0,   0,   4,   6,   0,
      8, 128,   0,   0,  85, 129,
      1,   0,   0, 160,   2,   0,
      0, 128,   4,   0,   0,   4,
      2,   0,   3, 128,   4,   0,
    228, 128,   1,   0, 233, 160,
      3,   0, 238, 128,   4,   0,
      0,   4,   3,   0,  12, 128,
      4,   0,  68, 128,   1,   0,
    212, 160,   3,   0, 228, 128,
     66,   0,   0,   3,   7,   0,
     15, 128,   3,   0, 238, 128,
      0,   8, 228, 160,  66,   0,
      0,   3,   9,   0,  15, 128,
      2,   0, 228, 128,   0,   8,
    228, 160,   1,   0,   0,   2,
     11,   0,   1, 128,   9,   0,
      0, 128,   4,   0,   0,   4,
      2,   0,   3, 128,   4,   0,
    228, 128,   1,   0, 233, 160,
      5,   0, 236, 128,   4,   0,
      0,   4,   3,   0,  12, 128,
      4,   0,  68, 128,   1,   0,
    212, 160,   5,   0, 196, 128,
     66,   0,   0,   3,   5,   0,
     15, 128,   3,   0, 238, 128,
      0,   8, 228, 160,  66,   0,
      0,   3,  13,   0,  15, 128,
      2,   0, 228, 128,   0,   8,
    228, 160,   1,   0,   0,   2,
     11,   0,   8, 128,  13,   0,
      0, 128,   4,   0,   0,   4,
      2,   0,   3, 128,   4,   0,
    228, 128,   1,   0, 233, 160,
      3,   0, 228, 128,   4,   0,
      0,   4,   3,   0,   3, 128,
      4,   0, 228, 128,   1,   0,
    237, 160,   3,   0, 228, 128,
     66,   0,   0,   3,   3,   0,
     15, 128,   3,   0, 228, 128,
      0,   8, 228, 160,  66,   0,
      0,   3,  14,   0,  15, 128,
      2,   0, 228, 128,   0,   8,
    228, 160,   1,   0,   0,   2,
     11,   0,   4, 128,  14,   0,
      0, 128,   1,   0,   0,   2,
     11,   0,   2, 128,  10,   0,
      0, 128,   9,   0,   0,   3,
     11,   0,   1, 128,   6,   0,
    228, 128,  11,   0, 228, 128,
      1,   0,   0,   2,  15,   0,
      1, 128,   9,   0,  85, 128,
      1,   0,   0,   2,   9,   0,
      1, 128,   9,   0, 170, 128,
      1,   0,   0,   2,  15,   0,
      8, 128,  13,   0,  85, 128,
      1,   0,   0,   2,   9,   0,
      8, 128,  13,   0, 170, 128,
      1,   0,   0,   2,  15,   0,
      4, 128,  14,   0,  85, 128,
      1,   0,   0,   2,  15,   0,
      2, 128,  10,   0,  85, 128,
      9,   0,   0,   3,  11,   0,
      2, 128,   6,   0, 228, 128,
     15,   0, 228, 128,   1,   0,
      0,   2,   9,   0,   4, 128,
     14,   0, 170, 128,   1,   0,
      0,   2,   9,   0,   2, 128,
     10,   0, 170, 128,   9,   0,
      0,   3,  11,   0,   4, 128,
      6,   0, 228, 128,   9,   0,
    228, 128,   9,   0,   0,   3,
      0,   0,   2, 128,   6,   0,
    228, 128,   1,   0, 170, 160,
      2,   0,   0,   3,   0,   0,
      1, 128,   0,   0,  85, 128,
      0,   0,   0, 128,   2,   0,
      0,   3,   1,   0,  14, 128,
      1,   0, 228, 128,  11,   0,
    144, 128,   5,   0,   0,   3,
      2,   0,   3, 128,   4,   0,
    228, 128,   1,   0, 237, 160,
      4,   0,   0,   4,   2,   0,
      3, 128,   2,   0, 238, 128,
      4,   0, 228, 128,   2,   0,
    228, 128,  66,   0,   0,   3,
      2,   0,  15, 128,   2,   0,
    228, 128,   0,   8, 228, 160,
      1,   0,   0,   2,   4,   0,
      2, 128,   2,   0,   0, 128,
      4,   0,   0,   4,   2,   0,
      9, 128,   1,   0,   0, 128,
      2,   0, 100, 160,   2,   0,
     85, 160,  19,   0,   0,   2,
      2,   0,   9, 128,   2,   0,
    228, 128,   4,   0,   0,   4,
      2,   0,   9, 128,   2,   0,
    228, 128,   2,   0, 170, 160,
      2,   0, 255, 160,  37,   0,
      0,   2,   6,   0,   2, 128,
      2,   0,   0, 128,  37,   0,
      0,   2,   9,   0,   2, 128,
      2,   0, 255, 128,   5,   0,
      0,   3,   0,   0,   2, 128,
      6,   0,  85, 128,   9,   0,
     85, 128,   5,   0,   0,   3,
      2,   0,   1, 128,   1,   0,
      0, 128,   1,   0,   0, 128,
      6,   0,   0,   2,   2,   0,
      1, 128,   2,   0,   0, 128,
      5,   0,   0,   3,   0,   0,
      2, 128,   0,   0,  85, 128,
      2,   0,   0, 128,  88,   0,
      0,   4,   6,   0,   1, 128,
      1,   0,   0, 129,   1,   0,
      0, 160,   0,   0,  85, 128,
      2,   0,   0,   3,   2,   0,
      9, 128,   0,   0, 230, 128,
      4,   0,   0, 160,   2,   0,
      0,   3,   9,   0,  15, 128,
      0,   0, 238, 128,   4,   0,
     35, 160,  90,   0,   0,   4,
      0,   0,   2, 128,   2,   0,
    236, 128,   2,   0, 236, 128,
      3,   0, 170, 160,   7,   0,
      0,   2,   0,   0,   2, 128,
      0,   0,  85, 128,   6,   0,
      0,   2,   0,   0,   2, 128,
      0,   0,  85, 128,   4,   0,
      0,   4,   0,   0,  12, 128,
      0,   0,  85, 128,   2,   0,
     68, 160,   2,   0,  85, 160,
     19,   0,   0,   2,   0,   0,
     12, 128,   0,   0, 228, 128,
      4,   0,   0,   4,   0,   0,
     12, 128,   0,   0, 228, 128,
      2,   0, 170, 160,   2,   0,
    255, 160,  37,   0,   0,   2,
     11,   0,   2, 128,   0,   0,
    170, 128,  37,   0,   0,   2,
     13,   0,   2, 128,   0,   0,
    255, 128,   5,   0,   0,   3,
      0,   0,   4, 128,  11,   0,
     85, 128,  13,   0,  85, 128,
      5,   0,   0,   3,   0,   0,
      8, 128,   0,   0,  85, 128,
      0,   0,  85, 128,   6,   0,
      0,   2,   0,   0,   8, 128,
      0,   0, 255, 128,   5,   0,
      0,   3,   0,   0,   4, 128,
      0,   0, 255, 128,   0,   0,
    170, 128,  88,   0,   0,   4,
      6,   0,   8, 128,   0,   0,
     85, 129,   1,   0,   0, 160,
      0,   0, 170, 128,  90,   0,
      0,   4,   0,   0,   2, 128,
      9,   0, 228, 128,   9,   0,
    228, 128,   3,   0, 170, 160,
     90,   0,   0,   4,   0,   0,
      4, 128,   9,   0, 238, 128,
      9,   0, 238, 128,   3,   0,
    170, 160,   7,   0,   0,   2,
      0,   0,   4, 128,   0,   0,
    170, 128,   6,   0,   0,   2,
      0,   0,   4, 128,   0,   0,
    170, 128,   7,   0,   0,   2,
      0,   0,   2, 128,   0,   0,
     85, 128,   6,   0,   0,   2,
      0,   0,   2, 128,   0,   0,
     85, 128,   4,   0,   0,   4,
      2,   0,   9, 128,   0,   0,
     85, 128,   2,   0, 100, 160,
      2,   0,  85, 160,  19,   0,
      0,   2,   2,   0,   9, 128,
      2,   0, 228, 128,   4,   0,
      0,   4,   2,   0,   9, 128,
      2,   0, 228, 128,   2,   0,
    170, 160,   2,   0, 255, 160,
     37,   0,   0,   2,   9,   0,
      2, 128,   2,   0,   0, 128,
     37,   0,   0,   2,  11,   0,
      2, 128,   2,   0, 255, 128,
      5,   0,   0,   3,   0,   0,
      8, 128,   9,   0,  85, 128,
     11,   0,  85, 128,   5,   0,
      0,   3,   1,   0,   1, 128,
      0,   0,  85, 128,   0,   0,
     85, 128,   6,   0,   0,   2,
      1,   0,   1, 128,   1,   0,
      0, 128,   5,   0,   0,   3,
      0,   0,   8, 128,   0,   0,
    255, 128,   1,   0,   0, 128,
     88,   0,   0,   4,   6,   0,
      2, 128,   0,   0,  85, 129,
      1,   0,   0, 160,   0,   0,
    255, 128,   4,   0,   0,   4,
      0,   0,  10, 128,   0,   0,
    170, 128,   2,   0,  96, 160,
      2,   0,  85, 160,  19,   0,
      0,   2,   0,   0,  10, 128,
      0,   0, 228, 128,   4,   0,
      0,   4,   0,   0,  10, 128,
      0,   0, 228, 128,   2,   0,
    170, 160,   2,   0, 255, 160,
     37,   0,   0,   2,   9,   0,
      2, 128,   0,   0,  85, 128,
     37,   0,   0,   2,  11,   0,
      2, 128,   0,   0, 255, 128,
      5,   0,   0,   3,   0,   0,
      2, 128,   9,   0,  85, 128,
     11,   0,  85, 128,   5,   0,
      0,   3,   0,   0,   8, 128,
      0,   0, 170, 128,   0,   0,
    170, 128,   6,   0,   0,   2,
      0,   0,   8, 128,   0,   0,
    255, 128,   5,   0,   0,   3,
      0,   0,   2, 128,   0,   0,
    255, 128,   0,   0,  85, 128,
     88,   0,   0,   4,   6,   0,
      4, 128,   0,   0, 170, 129,
      1,   0,   0, 160,   0,   0,
     85, 128,   1,   0,   0,   2,
      4,   0,   1, 128,   7,   0,
      0, 128,   1,   0,   0,   2,
      4,   0,   4, 128,   3,   0,
      0, 128,   1,   0,   0,   2,
      4,   0,   8, 128,   5,   0,
      0, 128,   9,   0,   0,   3,
      4,   0,   1, 128,   6,   0,
    228, 128,   4,   0, 228, 128,
      1,   0,   0,   2,   9,   0,
      1, 128,   7,   0,  85, 128,
      1,   0,   0,   2,   3,   0,
      1, 128,   7,   0, 170, 128,
      1,   0,   0,   2,   9,   0,
      4, 128,   3,   0,  85, 128,
      1,   0,   0,   2,   9,   0,
      8, 128,   5,   0,  85, 128,
      1,   0,   0,   2,   3,   0,
      8, 128,   5,   0, 170, 128,
      1,   0,   0,   2,   9,   0,
      2, 128,   2,   0,  85, 128,
      1,   0,   0,   2,   3,   0,
      2, 128,   2,   0, 170, 128,
      9,   0,   0,   3,   4,   0,
      4, 128,   6,   0, 228, 128,
      3,   0, 228, 128,   9,   0,
      0,   3,   4,   0,   2, 128,
      6,   0, 228, 128,   9,   0,
    228, 128,   9,   0,   0,   3,
      0,   0,   2, 128,   6,   0,
    228, 128,   1,   0, 170, 160,
      2,   0,   0,   3,   0,   0,
      1, 128,   0,   0,  85, 128,
      0,   0,   0, 128,   6,   0,
      0,   2,   0,   0,   1, 128,
      0,   0,   0, 128,   2,   0,
      0,   3,   0,   0,  14, 128,
      1,   0, 228, 128,   4,   0,
    144, 128,   5,   0,   0,   3,
      1,   0,   7, 128,   0,   0,
      0, 128,   0,   0, 249, 128,
     10,   0,   0,   3,   2,   0,
      7, 128,  14,   0, 228, 128,
     10,   0, 228, 128,  11,   0,
      0,   3,   3,   0,   7, 128,
     10,   0, 228, 128,  14,   0,
    228, 128,  11,   0,   0,   3,
      4,   0,   7, 128,  12,   0,
    228, 128,   3,   0, 228, 128,
     10,   0,   0,   3,   3,   0,
      7, 128,   2,   0, 228, 128,
     12,   0, 228, 128,  10,   0,
      0,   3,   2,   0,   7, 128,
      3,   0, 228, 128,   8,   0,
    228, 128,  11,   0,   0,   3,
      3,   0,   7, 128,   8,   0,
    228, 128,   4,   0, 228, 128,
     11,   0,   0,   3,   4,   0,
      7, 128,   1,   0, 228, 128,
      2,   0, 228, 128,  10,   0,
      0,   3,   2,   0,   7, 128,
      3,   0, 228, 128,   4,   0,
    228, 128,   4,   0,   0,   4,
      0,   0,   7, 128,   0,   0,
    249, 128,   0,   0,   0, 129,
      2,   0, 228, 128,   4,   0,
      0,   4,   0,   8,   7, 128,
      0,   0, 228, 128,   5,   0,
      0, 160,   1,   0, 228, 128,
      1,   0,   0,   2,   0,   8,
      8, 128,   1,   0, 170, 160,
    255, 255,   0,   0
    };




#endif
