<?php
/**
 * FunAdmin
 * ============================================================================
 * 版权所有 2017-2028 FunAdmin，并保留所有权利。
 * 网站地址: http://www.FunAdmin.com
 * ----------------------------------------------------------------------------
 * 采用最新Thinkphp6实现
 * ============================================================================
 * Author: yuege
 * Date: 2019/9/21
 */

namespace app\common\controller;
use app\backend\service\AuthService;
use think\App;
use think\facade\Config;
use think\facade\Lang;
use think\facade\Request;
use think\facade\View;

class AddonsFrontend extends AddonsController
{
    /**
     * 模板布局, false取消
     * @var string|bool
     */
    protected $layout = false;

    /**
     * 允许修改的字段
     */
    protected $allowModifyFields = [
        'status',
        'sort',
        'title',
    ];
    public function __construct(App $app)
    {
        parent::__construct($app);
        $this->request = Request::instance();
        //过滤参数
        $this->pageSize = input('limit', 15);
        //加载语言包
        $this->loadlang(strtolower($this->controller));
        $this->_initialize();
        $this->theme();
        View::assign('addon',$this->addon);
    }
    public function theme(){
        $theme = cache($this->addon.'_theme');
        if($theme){
            $this->theme = $theme;
        }else{
            $view_config_file = $this->addon_path.'frontend'.DIRECTORY_SEPARATOR.'config'.DIRECTORY_SEPARATOR.'view.php';
            if(file_exists($view_config_file)){
                $view_config = include($this->addon_path.'frontend'.DIRECTORY_SEPARATOR.'config'.DIRECTORY_SEPARATOR.'view.php');
                $this->prefix = Config::get('database.connections.mysql.prefix');
                $theme = isset($view_config['view_base']) && $view_config['view_base']?$view_config['view_base']:'';
                $addonsconfig = get_addons_config($this->addon);
                if(isset($addonsconfig['theme']) && $addonsconfig['theme']['value']){
                    $theme = $addonsconfig['theme']['value'];
                }
                $this->theme = $theme?$theme.DS:'';
                $view_config = Config::get('view');
                $view_config = array_merge($view_config,['view_path' => $this->addon_path .'view'.DS.$this->module.DS.$this->theme]);
                View::engine('Think')->config($view_config);
                cache($this->addon.'_theme',$this->theme,3600);
            }
        }

    }

    public function _initialize()
    {
        parent::_initialize(); // TODO: Change the autogenerated stub
        $this->entrance = '';
        [$modulename, $controllername, $actionname] = [$this->module, $this->controller, $this->action];
        $controllername = str_replace('\\','.',$controllername);
        $controllers = explode('.', $controllername);
        $jsname = '';
        foreach ($controllers as $vo) {
            empty($jsname) ? $jsname = strtolower(parse_name($vo,1)) : $jsname .= '/' . strtolower(parse_name($vo,1));
        }
        $controllername = strtolower(parse_name($controllername,1));
        $actionname = strtolower(parse_name($actionname));
        $requesturl = "addons/$modulename/{$controllername}/{$actionname}";
        $autojs = file_exists(app()->getRootPath()."public".DS."static".DS.'addons'.DS."{$this->addon}".DS."{$modulename}".DS."js".DS."{$jsname}.js") ? true : false;
        $jspath ="addons/{$this->addon}/{$modulename}/js/{$jsname}.js";
        $auth = new AuthService();
        $config = [
            'entrance'    => $this->entrance,//入口
            'modulename'    => $modulename,
            'addonname'    => $this->addon,
            'moduleurl'    => rtrim(url("/{$modulename}", [], false), '/'),
            'controllername'       =>$controllername,
            'actionname'           => $actionname,
            'requesturl'          => $requesturl,
            'jspath' => "{$jspath}",
            'autojs'           => $autojs,
            'superAdmin'           => session('member.id')==1,
            'lang'           =>  strip_tags( Lang::getLangset()),
            'site'           =>  syscfg('site'),
            'upload'           =>  syscfg('upload'),
            'editor'           =>  syscfg('editor'),

        ];
        View::assign('config',$config);
    }


}