<?php declare(strict_types = 1);
/**
 * This file is part of the SqlFtw library (https://github.com/sqlftw)
 *
 * Copyright (c) 2017 Vlasta Neubauer (@paranoiq)
 *
 * For the full copyright and license information read the file 'license.md', distributed with this source code
 */

namespace SqlFtw\Sql;

class Keyword extends SqlEnum
{

    public const A = 'A';
    public const ABORT = 'ABORT';
    public const ABS = 'ABS';
    public const ABSOLUTE = 'ABSOLUTE';
    public const ACCESS = 'ACCESS';
    public const ACCESSIBLE = 'ACCESSIBLE';
    public const ACCOUNT = 'ACCOUNT';
    public const ACTION = 'ACTION';
    public const ACTIVE = 'ACTIVE';
    public const ADA = 'ADA';
    public const ADD = 'ADD';
    public const ADMIN = 'ADMIN';
    public const AFTER = 'AFTER';
    public const AGAINST = 'AGAINST';
    public const AGGREGATE = 'AGGREGATE';
    public const ALGORITHM = 'ALGORITHM';
    public const ALIAS = 'ALIAS';
    public const ALL = 'ALL';
    public const ALLOCATE = 'ALLOCATE';
    public const ALSO = 'ALSO';
    public const ALTER = 'ALTER';
    public const ALWAYS = 'ALWAYS';
    public const ANALYSE = 'ANALYSE';
    public const ANALYZE = 'ANALYZE';
    public const AND = 'AND';
    public const ANY = 'ANY';
    public const ARE = 'ARE';
    public const ARRAY = 'ARRAY';
    public const ARRAY_AGG = 'ARRAY_AGG';
    public const ARRAY_MAX_CARDINALITY = 'ARRAY_MAX_CARDINALITY';
    public const AS = 'AS';
    public const ASC = 'ASC';
    public const ASCII = 'ASCII';
    public const ASENSITIVE = 'ASENSITIVE';
    public const ASSERTION = 'ASSERTION';
    public const ASSIGN_GTIDS_TO_ANONYMOUS_TRANSACTIONS = 'ASSIGN_GTIDS_TO_ANONYMOUS_TRANSACTIONS';
    public const ASSIGNMENT = 'ASSIGNMENT';
    public const ASYMMETRIC = 'ASYMMETRIC';
    public const AT = 'AT';
    public const ATOMIC = 'ATOMIC';
    public const ATTACH = 'ATTACH';
    public const ATTRIBUTE = 'ATTRIBUTE';
    public const ATTRIBUTES = 'ATTRIBUTES';
    public const AUTHENTICATION = 'AUTHENTICATION';
    public const AUTHORIZATION = 'AUTHORIZATION';
    public const AUTHORS = 'AUTHORS';
    public const AUTO_INCREMENT = 'AUTO_INCREMENT';
    public const AUTOEXTEND_SIZE = 'AUTOEXTEND_SIZE';
    public const AUTOINCREMENT = 'AUTOINCREMENT';
    public const AVG = 'AVG';
    public const AVG_ROW_LENGTH = 'AVG_ROW_LENGTH';
    public const BACKUP = 'BACKUP';
    public const BACKWARD = 'BACKWARD';
    public const BDB = 'BDB';
    public const BEFORE = 'BEFORE';
    public const BEGIN = 'BEGIN';
    public const BEGIN_FRAME = 'BEGIN_FRAME';
    public const BEGIN_PARTITION = 'BEGIN_PARTITION';
    public const BERKELEYDB = 'BERKELEYDB';
    public const BERNOULLI = 'BERNOULLI';
    public const BETWEEN = 'BETWEEN';
    public const BIGINT = 'BIGINT';
    public const BINARY = 'BINARY';
    public const BINLOG = 'BINLOG';
    public const BIT = 'BIT';
    public const BIT_LENGTH = 'BIT_LENGTH';
    public const BITVAR = 'BITVAR';
    public const BLOB = 'BLOB';
    public const BLOCK = 'BLOCK';
    public const BOOL = 'BOOL';
    public const BOOLEAN = 'BOOLEAN';
    public const BOTH = 'BOTH';
    public const BREADTH = 'BREADTH';
    public const BTREE = 'BTREE';
    public const BUCKETS = 'BUCKETS';
    public const BULK = 'BULK';
    public const BY = 'BY';
    public const BYTE = 'BYTE';
    public const C = 'C';
    public const CACHE = 'CACHE';
    public const CALL = 'CALL';
    public const CALLED = 'CALLED';
    public const CARDINALITY = 'CARDINALITY';
    public const CASCADE = 'CASCADE';
    public const CASCADED = 'CASCADED';
    public const CASE = 'CASE';
    public const CAST = 'CAST';
    public const CATALOG = 'CATALOG';
    public const CATALOG_NAME = 'CATALOG_NAME';
    public const CEIL = 'CEIL';
    public const CEILING = 'CEILING';
    public const CHAIN = 'CHAIN';
    public const CHALLENGE_RESPONSE = 'CHALLENGE_RESPONSE';
    public const CHANGE = 'CHANGE';
    public const CHANGED = 'CHANGED';
    public const CHANNEL = 'CHANNEL';
    public const CHAR = 'CHAR';
    public const CHAR_LENGTH = 'CHAR_LENGTH';
    public const CHARACTER = 'CHARACTER';
    public const CHARACTER_LENGTH = 'CHARACTER_LENGTH';
    public const CHARACTER_SET_CATALOG = 'CHARACTER_SET_CATALOG';
    public const CHARACTER_SET_NAME = 'CHARACTER_SET_NAME';
    public const CHARACTER_SET_SCHEMA = 'CHARACTER_SET_SCHEMA';
    public const CHARACTERISTICS = 'CHARACTERISTICS';
    public const CHARACTERS = 'CHARACTERS';
    public const CHARSET = 'CHARSET';
    public const CHECK = 'CHECK';
    public const CHECKED = 'CHECKED';
    public const CHECKPOINT = 'CHECKPOINT';
    public const CHECKSUM = 'CHECKSUM';
    public const CIPHER = 'CIPHER';
    public const CLASS_KEYWORD = 'CLASS';
    public const CLASS_ORIGIN = 'CLASS_ORIGIN';
    public const CLIENT = 'CLIENT';
    public const CLOB = 'CLOB';
    public const CLONE = 'CLONE';
    public const CLOSE = 'CLOSE';
    public const CLUSTER = 'CLUSTER';
    public const COALESCE = 'COALESCE';
    public const COBOL = 'COBOL';
    public const CODE = 'CODE';
    public const COLLATE = 'COLLATE';
    public const COLLATION = 'COLLATION';
    public const COLLATION_CATALOG = 'COLLATION_CATALOG';
    public const COLLATION_NAME = 'COLLATION_NAME';
    public const COLLATION_SCHEMA = 'COLLATION_SCHEMA';
    public const COLLECT = 'COLLECT';
    public const COLUMN = 'COLUMN';
    public const COLUMN_FORMAT = 'COLUMN_FORMAT';
    public const COLUMN_NAME = 'COLUMN_NAME';
    public const COLUMNS = 'COLUMNS';
    public const COMMAND_FUNCTION = 'COMMAND_FUNCTION';
    public const COMMAND_FUNCTION_CODE = 'COMMAND_FUNCTION_CODE';
    public const COMMENT = 'COMMENT';
    public const COMMENTS = 'COMMENTS';
    public const COMMIT = 'COMMIT';
    public const COMMITTED = 'COMMITTED';
    public const COMPACT = 'COMPACT';
    public const COMPLETION = 'COMPLETION';
    public const COMPONENT = 'COMPONENT';
    public const COMPRESSED = 'COMPRESSED';
    public const COMPRESSION = 'COMPRESSION';
    public const CONCURRENT = 'CONCURRENT';
    public const CONCURRENTLY = 'CONCURRENTLY';
    public const CONDITION = 'CONDITION';
    public const CONDITION_NUMBER = 'CONDITION_NUMBER';
    public const CONFIGURATION = 'CONFIGURATION';
    public const CONFLICT = 'CONFLICT';
    public const CONNECT = 'CONNECT';
    public const CONNECTION = 'CONNECTION';
    public const CONNECTION_NAME = 'CONNECTION_NAME';
    public const CONSISTENT = 'CONSISTENT';
    public const CONSTRAINT = 'CONSTRAINT';
    public const CONSTRAINT_CATALOG = 'CONSTRAINT_CATALOG';
    public const CONSTRAINT_NAME = 'CONSTRAINT_NAME';
    public const CONSTRAINT_SCHEMA = 'CONSTRAINT_SCHEMA';
    public const CONSTRAINTS = 'CONSTRAINTS';
    public const CONSTRUCTOR = 'CONSTRUCTOR';
    public const CONTAINS = 'CONTAINS';
    public const CONTENT = 'CONTENT';
    public const CONTEXT = 'CONTEXT';
    public const CONTINUE = 'CONTINUE';
    public const CONTRIBUTORS = 'CONTRIBUTORS';
    public const CONVERSION = 'CONVERSION';
    public const CONVERT = 'CONVERT';
    public const COPY = 'COPY';
    public const CORR = 'CORR';
    public const CORRESPONDING = 'CORRESPONDING';
    public const COST = 'COST';
    public const COUNT = 'COUNT';
    public const COVAR_POP = 'COVAR_POP';
    public const COVAR_SAMP = 'COVAR_SAMP';
    public const CPU = 'CPU';
    public const CREATE = 'CREATE';
    public const CROSS = 'CROSS';
    public const CSV = 'CSV';
    public const CUBE = 'CUBE';
    public const CUME_DIST = 'CUME_DIST';
    public const CURRENT = 'CURRENT';
    public const CURRENT_CATALOG = 'CURRENT_CATALOG';
    public const CURRENT_DATE = 'CURRENT_DATE';
    public const CURRENT_DEFAULT_TRANSFORM_GROUP = 'CURRENT_DEFAULT_TRANSFORM_GROUP';
    public const CURRENT_PATH = 'CURRENT_PATH';
    public const CURRENT_ROLE = 'CURRENT_ROLE';
    public const CURRENT_ROW = 'CURRENT_ROW';
    public const CURRENT_SCHEMA = 'CURRENT_SCHEMA';
    public const CURRENT_TIME = 'CURRENT_TIME';
    public const CURRENT_TIMESTAMP = 'CURRENT_TIMESTAMP';
    public const CURRENT_TRANSFORM_GROUP_FOR_TYPE = 'CURRENT_TRANSFORM_GROUP_FOR_TYPE';
    public const CURRENT_USER = 'CURRENT_USER';
    public const CURSOR = 'CURSOR';
    public const CURSOR_NAME = 'CURSOR_NAME';
    public const CYCLE = 'CYCLE';
    public const DATA = 'DATA';
    public const DATABASE = 'DATABASE';
    public const DATABASES = 'DATABASES';
    public const DATAFILE = 'DATAFILE';
    public const DATE = 'DATE';
    public const DATETIME = 'DATETIME';
    public const DATETIME_INTERVAL_CODE = 'DATETIME_INTERVAL_CODE';
    public const DATETIME_INTERVAL_PRECISION = 'DATETIME_INTERVAL_PRECISION';
    public const DAY = 'DAY';
    public const DAY_HOUR = 'DAY_HOUR';
    public const DAY_MICROSECOND = 'DAY_MICROSECOND';
    public const DAY_MINUTE = 'DAY_MINUTE';
    public const DAY_SECOND = 'DAY_SECOND';
    public const DEALLOCATE = 'DEALLOCATE';
    public const DEC = 'DEC';
    public const DECIMAL = 'DECIMAL';
    public const DECLARE = 'DECLARE';
    public const DEFAULT = 'DEFAULT';
    public const DEFAULT_AUTH = 'DEFAULT_AUTH';
    public const DEFAULTS = 'DEFAULTS';
    public const DEFERRABLE = 'DEFERRABLE';
    public const DEFERRED = 'DEFERRED';
    public const DEFINED = 'DEFINED';
    public const DEFINER = 'DEFINER';
    public const DEFINITION = 'DEFINITION';
    public const DEGREE = 'DEGREE';
    public const DELAY_KEY_WRITE = 'DELAY_KEY_WRITE';
    public const DELAYED = 'DELAYED';
    public const DELETE = 'DELETE';
    public const DELIMITER = 'DELIMITER';
    public const DELIMITERS = 'DELIMITERS';
    public const DENSE_RANK = 'DENSE_RANK';
    public const DEPENDS = 'DEPENDS';
    public const DEPTH = 'DEPTH';
    public const DEREF = 'DEREF';
    public const DERIVED = 'DERIVED';
    public const DES_KEY_FILE = 'DES_KEY_FILE';
    public const DESC = 'DESC';
    public const DESCRIBE = 'DESCRIBE';
    public const DESCRIPTION = 'DESCRIPTION';
    public const DESCRIPTOR = 'DESCRIPTOR';
    public const DESTROY = 'DESTROY';
    public const DESTRUCTOR = 'DESTRUCTOR';
    public const DETACH = 'DETACH';
    public const DETERMINISTIC = 'DETERMINISTIC';
    public const DIAGNOSTICS = 'DIAGNOSTICS';
    public const DICTIONARY = 'DICTIONARY';
    public const DIRECTORY = 'DIRECTORY';
    public const DISABLE = 'DISABLE';
    public const DISCARD = 'DISCARD';
    public const DISCONNECT = 'DISCONNECT';
    public const DISK = 'DISK';
    public const DISPATCH = 'DISPATCH';
    public const DISTINCT = 'DISTINCT';
    public const DISTINCTROW = 'DISTINCTROW';
    public const DIV = 'DIV';
    public const DO = 'DO';
    public const DOCUMENT = 'DOCUMENT';
    public const DOMAIN = 'DOMAIN';
    public const DOUBLE = 'DOUBLE';
    public const DROP = 'DROP';
    public const DUAL = 'DUAL';
    public const DUMPFILE = 'DUMPFILE';
    public const DUPLICATE = 'DUPLICATE';
    public const DYNAMIC = 'DYNAMIC';
    public const DYNAMIC_FUNCTION = 'DYNAMIC_FUNCTION';
    public const DYNAMIC_FUNCTION_CODE = 'DYNAMIC_FUNCTION_CODE';
    public const EACH = 'EACH';
    public const ELEMENT = 'ELEMENT';
    public const ELSE = 'ELSE';
    public const ELSEIF = 'ELSEIF';
    public const EMPTY = 'EMPTY';
    public const ENABLE = 'ENABLE';
    public const ENCLOSED = 'ENCLOSED';
    public const ENCODING = 'ENCODING';
    public const ENCRYPTED = 'ENCRYPTED';
    public const ENCRYPTION = 'ENCRYPTION';
    public const END = 'END';
    public const END_FRAME = 'END_FRAME';
    public const END_PARTITION = 'END_PARTITION';
    public const END_EXEC = 'END-EXEC';
    public const ENDS = 'ENDS';
    public const ENFORCED = 'ENFORCED';
    public const ENGINE = 'ENGINE';
    public const ENGINE_ATTRIBUTE = 'ENGINE_ATTRIBUTE';
    public const ENGINES = 'ENGINES';
    public const ENUM = 'ENUM';
    public const EQUALS = 'EQUALS';
    public const ERROR = 'ERROR';
    public const ERRORS = 'ERRORS';
    public const ESCAPE = 'ESCAPE';
    public const ESCAPED = 'ESCAPED';
    public const EVENT = 'EVENT';
    public const EVENTS = 'EVENTS';
    public const EVERY = 'EVERY';
    public const EXCEPT = 'EXCEPT';
    public const EXCEPTION = 'EXCEPTION';
    public const EXCLUDE = 'EXCLUDE';
    public const EXCLUDING = 'EXCLUDING';
    public const EXCLUSIVE = 'EXCLUSIVE';
    public const EXEC = 'EXEC';
    public const EXECUTE = 'EXECUTE';
    public const EXCHANGE = 'EXCHANGE';
    public const EXISTING = 'EXISTING';
    public const EXISTS = 'EXISTS';
    public const EXIT = 'EXIT';
    public const EXP = 'EXP';
    public const EXPANSION = 'EXPANSION';
    public const EXPIRE = 'EXPIRE';
    public const EXPLAIN = 'EXPLAIN';
    public const EXPORT = 'EXPORT';
    public const EXPRESSION = 'EXPRESSION';
    public const EXTENDED = 'EXTENDED';
    public const EXTENSION = 'EXTENSION';
    public const EXTENT_SIZE = 'EXTENT_SIZE';
    public const EXTERNAL = 'EXTERNAL';
    public const EXTRACT = 'EXTRACT';
    public const FACTOR = 'FACTOR';
    public const FAIL = 'FAIL';
    public const FAILED_LOGIN_ATTEMPTS = 'FAILED_LOGIN_ATTEMPTS';
    public const FALSE = 'FALSE';
    public const FAMILY = 'FAMILY';
    public const FAST = 'FAST';
    public const FAULTS = 'FAULTS';
    public const FETCH = 'FETCH';
    public const FIELDS = 'FIELDS';
    public const FILE = 'FILE';
    public const FILE_BLOCK_SIZE = 'FILE_BLOCK_SIZE';
    public const FILTER = 'FILTER';
    public const FINAL = 'FINAL';
    public const FINISH = 'FINISH';
    public const FIRST = 'FIRST';
    public const FIRST_VALUE = 'FIRST_VALUE';
    public const FIXED = 'FIXED';
    public const FLAG = 'FLAG';
    public const FLOAT = 'FLOAT';
    public const FLOAT4 = 'FLOAT4';
    public const FLOAT8 = 'FLOAT8';
    public const FLOOR = 'FLOOR';
    public const FLUSH = 'FLUSH';
    public const FOLLOWING = 'FOLLOWING';
    public const FOLLOWS = 'FOLLOWS';
    public const FOR = 'FOR';
    public const FORCE = 'FORCE';
    public const FOREIGN = 'FOREIGN';
    public const FORMAT = 'FORMAT';
    public const FORTRAN = 'FORTRAN';
    public const FORWARD = 'FORWARD';
    public const FOUND = 'FOUND';
    public const FRAC_SECOND = 'FRAC_SECOND';
    public const FRAME_ROW = 'FRAME_ROW';
    public const FREE = 'FREE';
    public const FREEZE = 'FREEZE';
    public const FROM = 'FROM';
    public const FULL = 'FULL';
    public const FULLTEXT = 'FULLTEXT';
    public const FUNCTION = 'FUNCTION';
    public const FUNCTIONS = 'FUNCTIONS';
    public const FUSION = 'FUSION';
    public const G = 'G';
    public const GENERAL = 'GENERAL';
    public const GENERATE = 'GENERATE';
    public const GENERATED = 'GENERATED';
    public const GEOMCOLLECTION = 'GEOMCOLLECTION';
    public const GEOMETRY = 'GEOMETRY';
    public const GEOMETRYCOLLECTION = 'GEOMETRYCOLLECTION';
    public const GET = 'GET';
    public const GET_FORMAT = 'GET_FORMAT';
    public const GET_MASTER_PUBLIC_KEY = 'GET_MASTER_PUBLIC_KEY';
    public const GET_SOURCE_PUBLIC_KEY = 'GET_SOURCE_PUBLIC_KEY';
    public const GLOB = 'GLOB';
    public const GLOBAL = 'GLOBAL';
    public const GO = 'GO';
    public const GOTO = 'GOTO';
    public const GRANT = 'GRANT';
    public const GRANTED = 'GRANTED';
    public const GRANTS = 'GRANTS';
    public const GREATEST = 'GREATEST';
    public const GROUP = 'GROUP';
    public const GROUP_REPLICATION = 'GROUP_REPLICATION';
    public const GROUPING = 'GROUPING';
    public const GROUPS = 'GROUPS';
    public const GTID_ONLY = 'GTID_ONLY';
    public const HANDLER = 'HANDLER';
    public const HASH = 'HASH';
    public const HAVING = 'HAVING';
    public const HEADER = 'HEADER';
    public const HELP = 'HELP';
    public const HIERARCHY = 'HIERARCHY';
    public const HIGH_PRIORITY = 'HIGH_PRIORITY';
    public const HISTOGRAM = 'HISTOGRAM';
    public const HISTORY = 'HISTORY';
    public const HOLD = 'HOLD';
    public const HOST = 'HOST';
    public const HOSTS = 'HOSTS';
    public const HOUR = 'HOUR';
    public const HOUR_MICROSECOND = 'HOUR_MICROSECOND';
    public const HOUR_MINUTE = 'HOUR_MINUTE';
    public const HOUR_SECOND = 'HOUR_SECOND';
    public const IDENTIFIED = 'IDENTIFIED';
    public const IDENTITY = 'IDENTITY';
    public const IF = 'IF';
    public const IGNORE = 'IGNORE';
    public const IGNORE_SERVER_IDS = 'IGNORE_SERVER_IDS';
    public const ILIKE = 'ILIKE';
    public const IMMEDIATE = 'IMMEDIATE';
    public const IMMEDIATELY = 'IMMEDIATELY';
    public const IMMUTABLE = 'IMMUTABLE';
    public const IMPLEMENTATION = 'IMPLEMENTATION';
    public const IMPLICIT = 'IMPLICIT';
    public const IMPORT = 'IMPORT';
    public const IN = 'IN';
    public const INACTIVE = 'INACTIVE';
    public const INCLUDING = 'INCLUDING';
    public const INCREMENT = 'INCREMENT';
    public const INDEX = 'INDEX';
    public const INDEXED = 'INDEXED';
    public const INDEXES = 'INDEXES';
    public const INDICATOR = 'INDICATOR';
    public const INFILE = 'INFILE';
    public const INFIX = 'INFIX';
    public const INHERIT = 'INHERIT';
    public const INHERITS = 'INHERITS';
    public const INITIAL_SIZE = 'INITIAL_SIZE';
    public const INITIALIZE = 'INITIALIZE';
    public const INITIAL = 'INITIAL';
    public const INITIALLY = 'INITIALLY';
    public const INITIATE = 'INITIATE';
    public const INLINE = 'INLINE';
    public const INNER = 'INNER';
    public const INNOBASE = 'INNOBASE';
    public const INNODB = 'INNODB';
    public const INOUT = 'INOUT';
    public const INPUT = 'INPUT';
    public const INSENSITIVE = 'INSENSITIVE';
    public const INSERT = 'INSERT';
    public const INSERT_METHOD = 'INSERT_METHOD';
    public const INSTALL = 'INSTALL';
    public const INSTANCE = 'INSTANCE';
    public const INSTANT = 'INSTANT';
    public const INSTANTIABLE = 'INSTANTIABLE';
    public const INSTEAD = 'INSTEAD';
    public const INT = 'INT';
    public const INT1 = 'INT1';
    public const INT2 = 'INT2';
    public const INT3 = 'INT3';
    public const INT4 = 'INT4';
    public const INT8 = 'INT8';
    public const INTEGER = 'INTEGER';
    public const INTERSECT = 'INTERSECT';
    public const INTERSECTION = 'INTERSECTION';
    public const INTERVAL = 'INTERVAL';
    public const INTO = 'INTO';
    public const INVISIBLE = 'INVISIBLE';
    public const INVOKER = 'INVOKER';
    public const IO = 'IO';
    public const IO_AFTER_GTIDS = 'IO_AFTER_GTIDS';
    public const IO_BEFORE_GTIDS = 'IO_BEFORE_GTIDS';
    public const IO_THREAD = 'IO_THREAD';
    public const IPC = 'IPC';
    public const IS = 'IS';
    public const ISNULL = 'ISNULL';
    public const ISOLATION = 'ISOLATION';
    public const ISSUER = 'ISSUER';
    public const ITERATE = 'ITERATE';
    public const JOIN = 'JOIN';
    public const JSON = 'JSON';
    public const JSON_TABLE = 'JSON_TABLE';
    public const JSON_VALUE = 'JSON_VALUE';
    public const K = 'K';
    public const KEY = 'KEY';
    public const KEY_BLOCK_SIZE = 'KEY_BLOCK_SIZE';
    public const KEY_MEMBER = 'KEY_MEMBER';
    public const KEY_TYPE = 'KEY_TYPE';
    public const KEYRING = 'KEYRING';
    public const KEYS = 'KEYS';
    public const KILL = 'KILL';
    public const LABEL = 'LABEL';
    public const LAG = 'LAG';
    public const LANGUAGE = 'LANGUAGE';
    public const LARGE = 'LARGE';
    public const LAST = 'LAST';
    public const LAST_VALUE = 'LAST_VALUE';
    public const LATERAL = 'LATERAL';
    public const LEAD = 'LEAD';
    public const LEADING = 'LEADING';
    public const LEAKPROOF = 'LEAKPROOF';
    public const LEAST = 'LEAST';
    public const LEAVE = 'LEAVE';
    public const LEAVES = 'LEAVES';
    public const LEFT = 'LEFT';
    public const LENGTH = 'LENGTH';
    public const LESS = 'LESS';
    public const LEVEL = 'LEVEL';
    public const LIKE = 'LIKE';
    public const LIKE_REGEX = 'LIKE_REGEX';
    public const LIMIT = 'LIMIT';
    public const LINEAR = 'LINEAR';
    public const LINES = 'LINES';
    public const LINESTRING = 'LINESTRING';
    public const LIST = 'LIST';
    public const LISTEN = 'LISTEN';
    public const LN = 'LN';
    public const LOAD = 'LOAD';
    public const LOCAL = 'LOCAL';
    public const LOCALTIME = 'LOCALTIME';
    public const LOCALTIMESTAMP = 'LOCALTIMESTAMP';
    public const LOCATION = 'LOCATION';
    public const LOCATOR = 'LOCATOR';
    public const LOCK = 'LOCK';
    public const LOCKED = 'LOCKED';
    public const LOCKS = 'LOCKS';
    public const LOGFILE = 'LOGFILE';
    public const LOGGED = 'LOGGED';
    public const LOGS = 'LOGS';
    public const LONG = 'LONG';
    public const LONGBLOB = 'LONGBLOB';
    public const LONGTEXT = 'LONGTEXT';
    public const LOOP = 'LOOP';
    public const LOW_PRIORITY = 'LOW_PRIORITY';
    public const LOWER = 'LOWER';
    public const M = 'M';
    public const MAP = 'MAP';
    public const MAPPING = 'MAPPING';
    public const MASTER = 'MASTER';
    public const MASTER_AUTO_POSITION = 'MASTER_AUTO_POSITION';
    public const MASTER_BIND = 'MASTER_BIND';
    public const MASTER_COMPRESSION_ALGORITHMS = 'MASTER_COMPRESSION_ALGORITHMS';
    public const MASTER_CONNECT_RETRY = 'MASTER_CONNECT_RETRY';
    public const MASTER_DELAY = 'MASTER_DELAY';
    public const MASTER_GET_PUBLIC_KEY = 'MASTER_GET_PUBLIC_KEY';
    public const MASTER_HEARTBEAT_PERIOD = 'MASTER_HEARTBEAT_PERIOD';
    public const MASTER_HOST = 'MASTER_HOST';
    public const MASTER_LOG_FILE = 'MASTER_LOG_FILE';
    public const MASTER_LOG_POS = 'MASTER_LOG_POS';
    public const MASTER_PASSWORD = 'MASTER_PASSWORD';
    public const MASTER_PORT = 'MASTER_PORT';
    public const MASTER_PUBLIC_KEY_PATH = 'MASTER_PUBLIC_KEY_PATH';
    public const MASTER_RETRY_COUNT = 'MASTER_RETRY_COUNT';
    public const MASTER_SERVER_ID = 'MASTER_SERVER_ID';
    public const MASTER_SSL = 'MASTER_SSL';
    public const MASTER_SSL_CA = 'MASTER_SSL_CA';
    public const MASTER_SSL_CAPATH = 'MASTER_SSL_CAPATH';
    public const MASTER_SSL_CERT = 'MASTER_SSL_CERT';
    public const MASTER_SSL_CIPHER = 'MASTER_SSL_CIPHER';
    public const MASTER_SSL_CRL = 'MASTER_SSL_CRL';
    public const MASTER_SSL_CRLPATH = 'MASTER_SSL_CRLPATH';
    public const MASTER_SSL_KEY = 'MASTER_SSL_KEY';
    public const MASTER_SSL_VERIFY_SERVER_CERT = 'MASTER_SSL_VERIFY_SERVER_CERT';
    public const MASTER_TLS_VERSION = 'MASTER_TLS_VERSION';
    public const MASTER_TLS_CIPHERSUITES = 'MASTER_TLS_CIPHERSUITES';
    public const MASTER_USER = 'MASTER_USER';
    public const MASTER_ZSTD_COMPRESSION_LEVEL = 'MASTER_ZSTD_COMPRESSION_LEVEL';
    public const MATERIALIZED = 'MATERIALIZED';
    public const MATCH = 'MATCH';
    public const MATCHED = 'MATCHED';
    public const MAX = 'MAX';
    public const MAX_CONNECTIONS_PER_HOUR = 'MAX_CONNECTIONS_PER_HOUR';
    public const MAX_QUERIES_PER_HOUR = 'MAX_QUERIES_PER_HOUR';
    public const MAX_ROWS = 'MAX_ROWS';
    public const MAX_SIZE = 'MAX_SIZE';
    public const MAX_STATEMENT_TIME = 'MAX_STATEMENT_TIME';
    public const MAX_UPDATES_PER_HOUR = 'MAX_UPDATES_PER_HOUR';
    public const MAX_USER_CONNECTIONS = 'MAX_USER_CONNECTIONS';
    public const MAXVALUE = 'MAXVALUE';
    public const MEDIUM = 'MEDIUM';
    public const MEDIUMBLOB = 'MEDIUMBLOB';
    public const MEDIUMINT = 'MEDIUMINT';
    public const MEDIUMTEXT = 'MEDIUMTEXT';
    public const MEMBER = 'MEMBER';
    public const MEMORY = 'MEMORY';
    public const MERGE = 'MERGE';
    public const MESSAGE_LENGTH = 'MESSAGE_LENGTH';
    public const MESSAGE_OCTET_LENGTH = 'MESSAGE_OCTET_LENGTH';
    public const MESSAGE_TEXT = 'MESSAGE_TEXT';
    public const METHOD = 'METHOD';
    public const MICROSECOND = 'MICROSECOND';
    public const MIDDLEINT = 'MIDDLEINT';
    public const MIGRATE = 'MIGRATE';
    public const MIN = 'MIN';
    public const MIN_ROWS = 'MIN_ROWS';
    public const MINUTE = 'MINUTE';
    public const MINUTE_MICROSECOND = 'MINUTE_MICROSECOND';
    public const MINUTE_SECOND = 'MINUTE_SECOND';
    public const MINVALUE = 'MINVALUE';
    public const MOD = 'MOD';
    public const MODE = 'MODE';
    public const MODIFIES = 'MODIFIES';
    public const MODIFY = 'MODIFY';
    public const MODULE = 'MODULE';
    public const MONTH = 'MONTH';
    public const MORE = 'MORE';
    public const MOVE = 'MOVE';
    public const MULTILINESTRING = 'MULTILINESTRING';
    public const MULTIPOINT = 'MULTIPOINT';
    public const MULTIPOLYGON = 'MULTIPOLYGON';
    public const MULTISET = 'MULTISET';
    public const MUMPS = 'MUMPS';
    public const MUTEX = 'MUTEX';
    public const MYSQL_ERRNO = 'MYSQL_ERRNO';
    public const NAME = 'NAME';
    public const NAMES = 'NAMES';
    public const NATIONAL = 'NATIONAL';
    public const NATURAL = 'NATURAL';
    public const NCLOB = 'NCLOB';
    public const NDB = 'NDB';
    public const NDBCLUSTER = 'NDBCLUSTER';
    public const NESTED = 'NESTED';
    public const NESTING = 'NESTING';
    public const NETWORK_NAMESPACE = 'NETWORK_NAMESPACE';
    public const NEVER = 'NEVER';
    public const NEW = 'NEW';
    public const NEXT = 'NEXT';
    public const NFC = 'NFC';
    public const NFD = 'NFD';
    public const NFKC = 'NFKC';
    public const NFKD = 'NFKD';
    public const NCHAR = 'NCHAR';
    public const NO = 'NO';
    public const NO_WAIT = 'NO_WAIT';
    public const NO_WRITE_TO_BINLOG = 'NO_WRITE_TO_BINLOG';
    public const NODEGROUP = 'NODEGROUP';
    public const NONBLOCKING = 'NONBLOCKING';
    public const NONE = 'NONE';
    public const NORMALIZE = 'NORMALIZE';
    public const NORMALIZED = 'NORMALIZED';
    public const NOT = 'NOT';
    public const NOTHING = 'NOTHING';
    public const NOTIFY = 'NOTIFY';
    public const NOTNULL = 'NOTNULL';
    public const NOWAIT = 'NOWAIT';
    public const NTH_VALUE = 'NTH_VALUE';
    public const NTILE = 'NTILE';
    public const NULL = 'NULL';
    public const NULLABLE = 'NULLABLE';
    public const NULLIF = 'NULLIF';
    public const NULLS = 'NULLS';
    public const NUMBER = 'NUMBER';
    public const NUMERIC = 'NUMERIC';
    public const NVARCHAR = 'NVARCHAR';
    public const OBJECT = 'OBJECT';
    public const OCCURRENCES_REGEX = 'OCCURRENCES_REGEX';
    public const OCTET_LENGTH = 'OCTET_LENGTH';
    public const OCTETS = 'OCTETS';
    public const OF = 'OF';
    public const OFF = 'OFF';
    public const OFFSET = 'OFFSET';
    public const OIDS = 'OIDS';
    public const OJ = 'OJ';
    public const OLD = 'OLD';
    public const OLD_PASSWORD = 'OLD_PASSWORD';
    public const ON = 'ON';
    public const ONE = 'ONE';
    public const ONE_SHOT = 'ONE_SHOT';
    public const ONLY = 'ONLY';
    public const OPEN = 'OPEN';
    public const OPERATION = 'OPERATION';
    public const OPERATOR = 'OPERATOR';
    public const OPTIMIZE = 'OPTIMIZE';
    public const OPTIMIZER_COSTS = 'OPTIMIZER_COSTS';
    public const OPTION = 'OPTION';
    public const OPTIONAL = 'OPTIONAL';
    public const OPTIONALLY = 'OPTIONALLY';
    public const OPTIONS = 'OPTIONS';
    public const OR = 'OR';
    public const ORDER = 'ORDER';
    public const ORDERING = 'ORDERING';
    public const ORDINALITY = 'ORDINALITY';
    public const ORGANIZATION = 'ORGANIZATION';
    public const OTHERS = 'OTHERS';
    public const OUT = 'OUT';
    public const OUTER = 'OUTER';
    public const OUTFILE = 'OUTFILE';
    public const OUTPUT = 'OUTPUT';
    public const OVER = 'OVER';
    public const OVERLAPS = 'OVERLAPS';
    public const OVERLAY = 'OVERLAY';
    public const OVERRIDING = 'OVERRIDING';
    public const OWNED = 'OWNED';
    public const OWNER = 'OWNER';
    public const P = 'P';
    public const PACK_KEYS = 'PACK_KEYS';
    public const PAD = 'PAD';
    public const PAGE = 'PAGE';
    public const PAGE_CHECKSUM = 'PAGE_CHECKSUM';
    public const PARALLEL = 'PARALLEL';
    public const PARAMETER = 'PARAMETER';
    public const PARAMETER_MODE = 'PARAMETER_MODE';
    public const PARAMETER_NAME = 'PARAMETER_NAME';
    public const PARAMETER_ORDINAL_POSITION = 'PARAMETER_ORDINAL_POSITION';
    public const PARAMETER_SPECIFIC_CATALOG = 'PARAMETER_SPECIFIC_CATALOG';
    public const PARAMETER_SPECIFIC_NAME = 'PARAMETER_SPECIFIC_NAME';
    public const PARAMETER_SPECIFIC_SCHEMA = 'PARAMETER_SPECIFIC_SCHEMA';
    public const PARAMETERS = 'PARAMETERS';
    public const PARSE_GCOL_EXPR = 'PARSE_GCOL_EXPR';
    public const PARSER = 'PARSER';
    public const PARTIAL = 'PARTIAL';
    public const PARTITION = 'PARTITION';
    public const PARTITIONING = 'PARTITIONING';
    public const PARTITIONS = 'PARTITIONS';
    public const PASCAL = 'PASCAL';
    public const PASSING = 'PASSING';
    public const PASSWORD = 'PASSWORD';
    public const PASSWORD_LOCK_TIME = 'PASSWORD_LOCK_TIME';
    public const PATH = 'PATH';
    public const PERCENT = 'PERCENT';
    public const PERCENT_RANK = 'PERCENT_RANK';
    public const PERCENTILE_CONT = 'PERCENTILE_CONT';
    public const PERCENTILE_DISC = 'PERCENTILE_DISC';
    public const PERIOD = 'PERIOD';
    public const PERSIST = 'PERSIST';
    public const PERSIST_ONLY = 'PERSIST_ONLY';
    public const PHASE = 'PHASE';
    public const PLACING = 'PLACING';
    public const PLAN = 'PLAN';
    public const PLANS = 'PLANS';
    public const PLI = 'PLI';
    public const PLUGIN = 'PLUGIN';
    public const PLUGIN_DIR = 'PLUGIN_DIR';
    public const PLUGINS = 'PLUGINS';
    public const POINT = 'POINT';
    public const POLICY = 'POLICY';
    public const POLYGON = 'POLYGON';
    public const PORT = 'PORT';
    public const PORTION = 'PORTION';
    public const POSITION = 'POSITION';
    public const POSITION_REGEX = 'POSITION_REGEX';
    public const POSTFIX = 'POSTFIX';
    public const POWER = 'POWER';
    public const PRAGMA = 'PRAGMA';
    public const PRECEDES = 'PRECEDES';
    public const PRECEDING = 'PRECEDING';
    public const PRECISION = 'PRECISION';
    public const PREFIX = 'PREFIX';
    public const PREORDER = 'PREORDER';
    public const PREPARE = 'PREPARE';
    public const PREPARED = 'PREPARED';
    public const PRESERVE = 'PRESERVE';
    public const PREV = 'PREV';
    public const PRIMARY = 'PRIMARY';
    public const PRIOR = 'PRIOR';
    public const PRIVILEGE_CHECKS_USER = 'PRIVILEGE_CHECKS_USER';
    public const PRIVILEGES = 'PRIVILEGES';
    public const PROCEDURAL = 'PROCEDURAL';
    public const PROCEDURE = 'PROCEDURE';
    public const PROCESSLIST = 'PROCESSLIST';
    public const PROFILE = 'PROFILE';
    public const PROFILES = 'PROFILES';
    public const PROGRAM = 'PROGRAM';
    public const PROXY = 'PROXY';
    public const PUBLIC = 'PUBLIC';
    public const PURGE = 'PURGE';
    public const QUARTER = 'QUARTER';
    public const QUERY = 'QUERY';
    public const QUICK = 'QUICK';
    public const QUOTE = 'QUOTE';
    public const RAID_CHUNKS = 'RAID_CHUNKS';
    public const RAID_CHUNKSIZE = 'RAID_CHUNKSIZE';
    public const RAID_TYPE = 'RAID_TYPE';
    public const RAID0 = 'RAID0';
    public const RAISE = 'RAISE';
    public const RANDOM = 'RANDOM';
    public const RANGE = 'RANGE';
    public const RANK = 'RANK';
    public const READ = 'READ';
    public const READ_ONLY = 'READ_ONLY';
    public const READ_WRITE = 'READ_WRITE';
    public const READS = 'READS';
    public const REAL = 'REAL';
    public const REASSIGN = 'REASSIGN';
    public const REBUILD = 'REBUILD';
    public const RECOVER = 'RECOVER';
    public const RECURSIVE = 'RECURSIVE';
    public const REDO_BUFFER_SIZE = 'REDO_BUFFER_SIZE';
    public const REDOFILE = 'REDOFILE';
    public const REDUNDANT = 'REDUNDANT';
    public const REFERENCE = 'REFERENCE';
    public const REF = 'REF';
    public const REFERENCES = 'REFERENCES';
    public const REFERENCING = 'REFERENCING';
    public const REFRESH = 'REFRESH';
    public const REGEXP = 'REGEXP';
    public const REGISTRATION = 'REGISTRATION';
    public const REGR_AVGX = 'REGR_AVGX';
    public const REGR_AVGY = 'REGR_AVGY';
    public const REGR_COUNT = 'REGR_COUNT';
    public const REGR_INTERCEPT = 'REGR_INTERCEPT';
    public const REGR_R2 = 'REGR_R2';
    public const REGR_SLOPE = 'REGR_SLOPE';
    public const REGR_SXX = 'REGR_SXX';
    public const REGR_SXY = 'REGR_SXY';
    public const REGR_SYY = 'REGR_SYY';
    public const RECHECK = 'RECHECK';
    public const REINDEX = 'REINDEX';
    public const RELATIVE = 'RELATIVE';
    public const RELAY = 'RELAY';
    public const RELAY_LOG_FILE = 'RELAY_LOG_FILE';
    public const RELAY_LOG_POS = 'RELAY_LOG_POS';
    public const RELAY_THREAD = 'RELAY_THREAD';
    public const RELAYLOG = 'RELAYLOG';
    public const RELEASE = 'RELEASE';
    public const RELOAD = 'RELOAD';
    public const REMOTE = 'REMOTE';
    public const REMOVE = 'REMOVE';
    public const RENAME = 'RENAME';
    public const REORGANISE = 'REORGANISE';
    public const REORGANIZE = 'REORGANIZE';
    public const REPAIR = 'REPAIR';
    public const REPEAT = 'REPEAT';
    public const REPEATABLE = 'REPEATABLE';
    public const REPLACE = 'REPLACE';
    public const REPLICA = 'REPLICA';
    public const REPLICAS = 'REPLICAS';
    public const REPLICATE_DO_DB = 'REPLICATE_DO_DB';
    public const REPLICATE_DO_TABLE = 'REPLICATE_DO_TABLE';
    public const REPLICATE_IGNORE_DB = 'REPLICATE_IGNORE_DB';
    public const REPLICATE_IGNORE_TABLE = 'REPLICATE_IGNORE_TABLE';
    public const REPLICATE_REWRITE_DB = 'REPLICATE_REWRITE_DB';
    public const REPLICATE_WILD_DO_TABLE = 'REPLICATE_WILD_DO_TABLE';
    public const REPLICATE_WILD_IGNORE_TABLE = 'REPLICATE_WILD_IGNORE_TABLE';
    public const REPLICATION = 'REPLICATION';
    public const REQUIRE = 'REQUIRE';
    public const REQUIRE_ROW_FORMAT = 'REQUIRE_ROW_FORMAT';
    public const REQUIRE_TABLE_PRIMARY_KEY_CHECK = 'REQUIRE_TABLE_PRIMARY_KEY_CHECK';
    public const RESET = 'RESET';
    public const RESOURCE = 'RESOURCE';
    public const RESIGNAL = 'RESIGNAL';
    public const RESPECT = 'RESPECT';
    public const RESTART = 'RESTART';
    public const RESTORE = 'RESTORE';
    public const RESTRICT = 'RESTRICT';
    public const RESULT = 'RESULT';
    public const RESUME = 'RESUME';
    public const RETAIN = 'RETAIN';
    public const RETURN = 'RETURN';
    public const RETURNED_CARDINALITY = 'RETURNED_CARDINALITY';
    public const RETURNED_LENGTH = 'RETURNED_LENGTH';
    public const RETURNED_OCTET_LENGTH = 'RETURNED_OCTET_LENGTH';
    public const RETURNED_SQLSTATE = 'RETURNED_SQLSTATE';
    public const RETURNING = 'RETURNING';
    public const RETURNS = 'RETURNS';
    public const REUSE = 'REUSE';
    public const REVERSE = 'REVERSE';
    public const REVOKE = 'REVOKE';
    public const RIGHT = 'RIGHT';
    public const RLIKE = 'RLIKE';
    public const ROLE = 'ROLE';
    public const ROLLBACK = 'ROLLBACK';
    public const ROLLUP = 'ROLLUP';
    public const ROTATE = 'ROTATE';
    public const ROUTINE = 'ROUTINE';
    public const ROUTINE_CATALOG = 'ROUTINE_CATALOG';
    public const ROUTINE_NAME = 'ROUTINE_NAME';
    public const ROUTINE_SCHEMA = 'ROUTINE_SCHEMA';
    public const ROW = 'ROW';
    public const ROW_COUNT = 'ROW_COUNT';
    public const ROW_FORMAT = 'ROW_FORMAT';
    public const ROW_NUMBER = 'ROW_NUMBER';
    public const ROWS = 'ROWS';
    public const RTREE = 'RTREE';
    public const RULE = 'RULE';
    public const SAVEPOINT = 'SAVEPOINT';
    public const SCALE = 'SCALE';
    public const SCOPE = 'SCOPE';
    public const SCOPE_CATALOG = 'SCOPE_CATALOG';
    public const SCOPE_NAME = 'SCOPE_NAME';
    public const SCOPE_SCHEMA = 'SCOPE_SCHEMA';
    public const SCROLL = 'SCROLL';
    public const SEARCH = 'SEARCH';
    public const SECOND = 'SECOND';
    public const SECOND_MICROSECOND = 'SECOND_MICROSECOND';
    public const SECONDARY = 'SECONDARY';
    public const SECONDARY_ENGINE = 'SECONDARY_ENGINE';
    public const SECONDARY_ENGINE_ATTRIBUTE = 'SECONDARY_ENGINE_ATTRIBUTE';
    public const SECONDARY_LOAD = 'SECONDARY_LOAD';
    public const SECONDARY_UNLOAD = 'SECONDARY_UNLOAD';
    public const SECTION = 'SECTION';
    public const SECURITY = 'SECURITY';
    public const SELECT = 'SELECT';
    public const SELF = 'SELF';
    public const SENSITIVE = 'SENSITIVE';
    public const SEPARATOR = 'SEPARATOR';
    public const SEQUENCE = 'SEQUENCE';
    public const SEQUENCES = 'SEQUENCES';
    public const SERIAL = 'SERIAL';
    public const SERIALIZABLE = 'SERIALIZABLE';
    public const SERVER = 'SERVER';
    public const SERVER_NAME = 'SERVER_NAME';
    public const SESSION = 'SESSION';
    public const SESSION_USER = 'SESSION_USER';
    public const SET = 'SET';
    public const SETOF = 'SETOF';
    public const SETS = 'SETS';
    public const SHARE = 'SHARE';
    public const SHOW = 'SHOW';
    public const SHUTDOWN = 'SHUTDOWN';
    public const SCHEDULE = 'SCHEDULE';
    public const SCHEDULER = 'SCHEDULER';
    public const SCHEMA = 'SCHEMA';
    public const SCHEMA_NAME = 'SCHEMA_NAME';
    public const SCHEMAS = 'SCHEMAS';
    public const SIGNAL = 'SIGNAL';
    public const SIGNED = 'SIGNED';
    public const SIMILAR = 'SIMILAR';
    public const SIMPLE = 'SIMPLE';
    public const SIZE = 'SIZE';
    public const SKIP = 'SKIP';
    public const SLAVE = 'SLAVE';
    public const SLOW = 'SLOW';
    public const SMALLINT = 'SMALLINT';
    public const SNAPSHOT = 'SNAPSHOT';
    public const SOCKET = 'SOCKET';
    public const SOME = 'SOME';
    public const SONAME = 'SONAME';
    public const SOUNDS = 'SOUNDS';
    public const SOURCE = 'SOURCE';
    public const SOURCE_AUTO_POSITION = 'SOURCE_AUTO_POSITION';
    public const SOURCE_BIND = 'SOURCE_BIND';
    public const SOURCE_COMPRESSION_ALGORITHMS = 'SOURCE_COMPRESSION_ALGORITHMS';
    public const SOURCE_CONNECTION_AUTO_FAILOVER = 'SOURCE_CONNECTION_AUTO_FAILOVER';
    public const SOURCE_CONNECT_RETRY = 'SOURCE_CONNECT_RETRY';
    public const SOURCE_DELAY = 'SOURCE_DELAY';
    public const SOURCE_GET_PUBLIC_KEY = 'SOURCE_GET_PUBLIC_KEY';
    public const SOURCE_HEARTBEAT_PERIOD = 'SOURCE_HEARTBEAT_PERIOD';
    public const SOURCE_HOST = 'SOURCE_HOST';
    public const SOURCE_LOG_FILE = 'SOURCE_LOG_FILE';
    public const SOURCE_LOG_POS = 'SOURCE_LOG_POS';
    public const SOURCE_PASSWORD = 'SOURCE_PASSWORD';
    public const SOURCE_PORT = 'SOURCE_PORT';
    public const SOURCE_PUBLIC_KEY_PATH = 'SOURCE_PUBLIC_KEY_PATH';
    public const SOURCE_RETRY_COUNT = 'SOURCE_RETRY_COUNT';
    public const SOURCE_SSL = 'SOURCE_SSL';
    public const SOURCE_SSL_CA = 'SOURCE_SSL_CA';
    public const SOURCE_SSL_CAPATH = 'SOURCE_SSL_CAPATH';
    public const SOURCE_SSL_CERT = 'SOURCE_SSL_CERT';
    public const SOURCE_SSL_CRL = 'SOURCE_SSL_CRL';
    public const SOURCE_SSL_CRLPATH = 'SOURCE_SSL_CRLPATH';
    public const SOURCE_SSL_KEY = 'SOURCE_SSL_KEY';
    public const SOURCE_SSL_CIPHER = 'SOURCE_SSL_CIPHER';
    public const SOURCE_SSL_VERIFY_SERVER_CERT = 'SOURCE_SSL_VERIFY_SERVER_CERT';
    public const SOURCE_TLS_CIPHERSUITES = 'SOURCE_TLS_CIPHERSUITES';
    public const SOURCE_TLS_VERSION = 'SOURCE_TLS_VERSION';
    public const SOURCE_USER = 'SOURCE_USER';
    public const SOURCE_ZSTD_COMPRESSION_LEVEL = 'SOURCE_ZSTD_COMPRESSION_LEVEL';
    public const SPACE = 'SPACE';
    public const SPATIAL = 'SPATIAL';
    public const SPECIFIC = 'SPECIFIC';
    public const SPECIFIC_NAME = 'SPECIFIC_NAME';
    public const SPECIFICTYPE = 'SPECIFICTYPE';
    public const SQL = 'SQL';
    public const SQL_AFTER_GTIDS = 'SQL_AFTER_GTIDS';
    public const SQL_AFTER_MTS_GAPS = 'SQL_AFTER_MTS_GAPS';
    public const SQL_BEFORE_GTIDS = 'SQL_BEFORE_GTIDS';
    public const SQL_BIG_RESULT = 'SQL_BIG_RESULT';
    public const SQL_BUFFER_RESULT = 'SQL_BUFFER_RESULT';
    public const SQL_CACHE = 'SQL_CACHE';
    public const SQL_CALC_FOUND_ROWS = 'SQL_CALC_FOUND_ROWS';
    public const SQL_NO_CACHE = 'SQL_NO_CACHE';
    public const SQL_SMALL_RESULT = 'SQL_SMALL_RESULT';
    public const SQL_THREAD = 'SQL_THREAD';
    public const SQL_TSI_DAY = 'SQL_TSI_DAY';
    public const SQL_TSI_FRAC_SECOND = 'SQL_TSI_FRAC_SECOND';
    public const SQL_TSI_HOUR = 'SQL_TSI_HOUR';
    public const SQL_TSI_MINUTE = 'SQL_TSI_MINUTE';
    public const SQL_TSI_MONTH = 'SQL_TSI_MONTH';
    public const SQL_TSI_QUARTER = 'SQL_TSI_QUARTER';
    public const SQL_TSI_SECOND = 'SQL_TSI_SECOND';
    public const SQL_TSI_WEEK = 'SQL_TSI_WEEK';
    public const SQL_TSI_YEAR = 'SQL_TSI_YEAR';
    public const SQLCODE = 'SQLCODE';
    public const SQLERROR = 'SQLERROR';
    public const SQLEXCEPTION = 'SQLEXCEPTION';
    public const SQLSTATE = 'SQLSTATE';
    public const SQLWARNING = 'SQLWARNING';
    public const SQRT = 'SQRT';
    public const SRID = 'SRID';
    public const SSL = 'SSL';
    public const STABLE = 'STABLE';
    public const STACKED = 'STACKED';
    public const STANDALONE = 'STANDALONE';
    public const START = 'START';
    public const STARTING = 'STARTING';
    public const STARTS = 'STARTS';
    public const STATE = 'STATE';
    public const STATEMENT = 'STATEMENT';
    public const STATIC = 'STATIC';
    public const STATISTICS = 'STATISTICS';
    public const STATS_AUTO_RECALC = 'STATS_AUTO_RECALC';
    public const STATS_PERSISTENT = 'STATS_PERSISTENT';
    public const STATS_SAMPLE_PAGES = 'STATS_SAMPLE_PAGES';
    public const STATUS = 'STATUS';
    public const STDDEV_POP = 'STDDEV_POP';
    public const STDDEV_SAMP = 'STDDEV_SAMP';
    public const STDIN = 'STDIN';
    public const STDOUT = 'STDOUT';
    public const STOP = 'STOP';
    public const STORAGE = 'STORAGE';
    public const STORED = 'STORED';
    public const STRAIGHT_JOIN = 'STRAIGHT_JOIN';
    public const STREAM = 'STREAM';
    public const STRICT = 'STRICT';
    public const STRING = 'STRING';
    public const STRIP = 'STRIP';
    public const STRIPED = 'STRIPED';
    public const STRUCTURE = 'STRUCTURE';
    public const STYLE = 'STYLE';
    public const SUBCLASS_ORIGIN = 'SUBCLASS_ORIGIN';
    public const SUBJECT = 'SUBJECT';
    public const SUBLIST = 'SUBLIST';
    public const SUBMULTISET = 'SUBMULTISET';
    public const SUBPARTITION = 'SUBPARTITION';
    public const SUBPARTITIONS = 'SUBPARTITIONS';
    public const SUBSTRING = 'SUBSTRING';
    public const SUBSTRING_REGEX = 'SUBSTRING_REGEX';
    public const SUCCEEDS = 'SUCCEEDS';
    public const SUM = 'SUM';
    public const SUPER = 'SUPER';
    public const SUSPEND = 'SUSPEND';
    public const SWAPS = 'SWAPS';
    public const SWITCHES = 'SWITCHES';
    public const SYMMETRIC = 'SYMMETRIC';
    public const SYSID = 'SYSID';
    public const SYSTEM = 'SYSTEM';
    public const SYSTEM_TIME = 'SYSTEM_TIME';
    public const SYSTEM_USER = 'SYSTEM_USER';
    public const T = 'T';
    public const TABLE = 'TABLE';
    public const TABLE_CHECKSUM = 'TABLE_CHECKSUM';
    public const TABLE_NAME = 'TABLE_NAME';
    public const TABLES = 'TABLES';
    public const TABLESAMPLE = 'TABLESAMPLE';
    public const TABLESPACE = 'TABLESPACE';
    public const TEMP = 'TEMP';
    public const TEMPLATE = 'TEMPLATE';
    public const TEMPORARY = 'TEMPORARY';
    public const TEMPTABLE = 'TEMPTABLE';
    public const TERMINATE = 'TERMINATE';
    public const TERMINATED = 'TERMINATED';
    public const TEXT = 'TEXT';
    public const THAN = 'THAN';
    public const THEN = 'THEN';
    public const THREAD_PRIORITY = 'THREAD_PRIORITY';
    public const TIES = 'TIES';
    public const TIME = 'TIME';
    public const TIMESTAMP = 'TIMESTAMP';
    public const TIMESTAMPADD = 'TIMESTAMPADD';
    public const TIMESTAMPDIFF = 'TIMESTAMPDIFF';
    public const TIMEZONE_HOUR = 'TIMEZONE_HOUR';
    public const TIMEZONE_MINUTE = 'TIMEZONE_MINUTE';
    public const TINYBLOB = 'TINYBLOB';
    public const TINYINT = 'TINYINT';
    public const TINYTEXT = 'TINYTEXT';
    public const TLS = 'TLS';
    public const TO = 'TO';
    public const TOP_LEVEL_COUNT = 'TOP_LEVEL_COUNT';
    public const TRAILING = 'TRAILING';
    public const TRANSACTION = 'TRANSACTION';
    public const TRANSACTION_ACTIVE = 'TRANSACTION_ACTIVE';
    public const TRANSACTIONAL = 'TRANSACTIONAL';
    public const TRANSACTIONS_COMMITTED = 'TRANSACTIONS_COMMITTED';
    public const TRANSACTIONS_ROLLED_BACK = 'TRANSACTIONS_ROLLED_BACK';
    public const TRANSFORM = 'TRANSFORM';
    public const TRANSFORMS = 'TRANSFORMS';
    public const TRANSLATE = 'TRANSLATE';
    public const TRANSLATE_REGEX = 'TRANSLATE_REGEX';
    public const TRANSLATION = 'TRANSLATION';
    public const TREAT = 'TREAT';
    public const TRIGGER = 'TRIGGER';
    public const TRIGGER_CATALOG = 'TRIGGER_CATALOG';
    public const TRIGGER_NAME = 'TRIGGER_NAME';
    public const TRIGGER_SCHEMA = 'TRIGGER_SCHEMA';
    public const TRIGGERS = 'TRIGGERS';
    public const TRIM = 'TRIM';
    public const TRIM_ARRAY = 'TRIM_ARRAY';
    public const TRUE = 'TRUE';
    public const TRUNCATE = 'TRUNCATE';
    public const TRUSTED = 'TRUSTED';
    public const TYPE = 'TYPE';
    public const TYPES = 'TYPES';
    public const UESCAPE = 'UESCAPE';
    public const UNBOUNDED = 'UNBOUNDED';
    public const UNCOMMITTED = 'UNCOMMITTED';
    public const UNDEFINED = 'UNDEFINED';
    public const UNDER = 'UNDER';
    public const UNDO = 'UNDO';
    public const UNDO_BUFFER_SIZE = 'UNDO_BUFFER_SIZE';
    public const UNDOFILE = 'UNDOFILE';
    public const UNENCRYPTED = 'UNENCRYPTED';
    public const UNICODE = 'UNICODE';
    public const UNINSTALL = 'UNINSTALL';
    public const UNION = 'UNION';
    public const UNIQUE = 'UNIQUE';
    public const UNKNOWN = 'UNKNOWN';
    public const UNLISTEN = 'UNLISTEN';
    public const UNLOCK = 'UNLOCK';
    public const UNLOGGED = 'UNLOGGED';
    public const UNNAMED = 'UNNAMED';
    public const UNNEST = 'UNNEST';
    public const UNREGISTER = 'UNREGISTER';
    public const UNSIGNED = 'UNSIGNED';
    public const UNTIL = 'UNTIL';
    public const UPDATE = 'UPDATE';
    public const UPGRADE = 'UPGRADE';
    public const UPPER = 'UPPER';
    public const URL = 'URL';
    public const USAGE = 'USAGE';
    public const USE = 'USE';
    public const USE_FRM = 'USE_FRM';
    public const USER = 'USER';
    public const USER_DEFINED_TYPE_CATALOG = 'USER_DEFINED_TYPE_CATALOG';
    public const USER_DEFINED_TYPE_CODE = 'USER_DEFINED_TYPE_CODE';
    public const USER_DEFINED_TYPE_NAME = 'USER_DEFINED_TYPE_NAME';
    public const USER_DEFINED_TYPE_SCHEMA = 'USER_DEFINED_TYPE_SCHEMA';
    public const USER_RESOURCES = 'USER_RESOURCES';
    public const USING = 'USING';
    public const UTC_DATE = 'UTC_DATE';
    public const UTC_TIME = 'UTC_TIME';
    public const UTC_TIMESTAMP = 'UTC_TIMESTAMP';
    public const VACUUM = 'VACUUM';
    public const VALID = 'VALID';
    public const VALIDATE = 'VALIDATE';
    public const VALIDATION = 'VALIDATION';
    public const VALIDATOR = 'VALIDATOR';
    public const VALUE = 'VALUE';
    public const VALUE_OF = 'VALUE_OF';
    public const VALUES = 'VALUES';
    public const VAR_POP = 'VAR_POP';
    public const VAR_SAMP = 'VAR_SAMP';
    public const VARBINARY = 'VARBINARY';
    public const VARCHAR = 'VARCHAR';
    public const VARCHARACTER = 'VARCHARACTER';
    public const VARIABLE = 'VARIABLE';
    public const VARIABLES = 'VARIABLES';
    public const VARIADIC = 'VARIADIC';
    public const VARYING = 'VARYING';
    public const VCPU = 'VCPU';
    public const VERBOSE = 'VERBOSE';
    public const VERSION = 'VERSION';
    public const VERSIONING = 'VERSIONING';
    public const VIEW = 'VIEW';
    public const VIEWS = 'VIEWS';
    public const VIRTUAL = 'VIRTUAL';
    public const VISIBLE = 'VISIBLE';
    public const VOLATILE = 'VOLATILE';
    public const WAIT = 'WAIT';
    public const WARNINGS = 'WARNINGS';
    public const WEEK = 'WEEK';
    public const WEIGHT_STRING = 'WEIGHT_STRING';
    public const WHEN = 'WHEN';
    public const WHENEVER = 'WHENEVER';
    public const WHERE = 'WHERE';
    public const WHILE = 'WHILE';
    public const WHITESPACE = 'WHITESPACE';
    public const WIDTH_BUCKET = 'WIDTH_BUCKET';
    public const WINDOW = 'WINDOW';
    public const WITH = 'WITH';
    public const WITHIN = 'WITHIN';
    public const WITHOUT = 'WITHOUT';
    public const WORK = 'WORK';
    public const WRAPPER = 'WRAPPER';
    public const WRITE = 'WRITE';
    public const X509 = 'X509';
    public const XA = 'XA';
    public const XID = 'XID';
    public const XML = 'XML';
    public const XMLATTRIBUTES = 'XMLATTRIBUTES';
    public const XMLCONCAT = 'XMLCONCAT';
    public const XMLELEMENT = 'XMLELEMENT';
    public const XMLEXISTS = 'XMLEXISTS';
    public const XMLFOREST = 'XMLFOREST';
    public const XMLPARSE = 'XMLPARSE';
    public const XMLPI = 'XMLPI';
    public const XMLROOT = 'XMLROOT';
    public const XMLSERIALIZE = 'XMLSERIALIZE';
    public const XOR = 'XOR';
    public const YEAR = 'YEAR';
    public const YEAR_MONTH = 'YEAR_MONTH';
    public const YES = 'YES';
    public const ZEROFILL = 'ZEROFILL';
    public const ZONE = 'ZONE';

    // not a keyword by official MySQL doc
    public const INPLACE = 'INPLACE'; // alter algorithm
    public const PREFERENCES = 'PREFERENCES'; // privileges
    public const PROCESS = 'PROCESS'; // privileges
    public const SHARED = 'SHARED'; // lock
    public const TRADITIONAL = 'TRADITIONAL'; // sql mode
    public const REDO_LOG = 'REDO_LOG';
    public const ONLINE = 'ONLINE'; // NDB cluster

}
