<?php declare(strict_types = 1);
/**
 * This file is part of the SqlFtw library (https://github.com/sqlftw)
 *
 * Copyright (c) 2017 Vlasta Neubauer (@paranoiq)
 *
 * For the full copyright and license information read the file 'license.md', distributed with this source code
 */

namespace SqlFtw\Platform\Features;

use SqlFtw\Sql\Command;
use SqlFtw\Sql\Dal\Cache\CacheIndexCommand;
use SqlFtw\Sql\Dal\Cache\LoadIndexIntoCacheCommand;
use SqlFtw\Sql\Dal\Flush\FlushCommand;
use SqlFtw\Sql\Dal\Flush\FlushTablesCommand;
use SqlFtw\Sql\Dal\Kill\KillCommand;
use SqlFtw\Sql\Dal\Plugin\InstallPluginCommand;
use SqlFtw\Sql\Dal\Plugin\UninstallPluginCommand;
use SqlFtw\Sql\Dal\Replication\ChangeMasterToCommand;
use SqlFtw\Sql\Dal\Replication\ResetMasterCommand;
use SqlFtw\Sql\Dal\Replication\ResetReplicaCommand;
use SqlFtw\Sql\Dal\Replication\ResetSlaveCommand;
use SqlFtw\Sql\Dal\Replication\StartReplicaCommand;
use SqlFtw\Sql\Dal\Replication\StartSlaveCommand;
use SqlFtw\Sql\Dal\Replication\StopReplicaCommand;
use SqlFtw\Sql\Dal\Replication\StopSlaveCommand;
use SqlFtw\Sql\Dal\Set\SetNamesCommand;
use SqlFtw\Sql\Dal\Set\SetVariablesCommand;
use SqlFtw\Sql\Dal\Show\ShowBinaryLogsCommand;
use SqlFtw\Sql\Dal\Show\ShowBinlogEventsCommand;
use SqlFtw\Sql\Dal\Show\ShowCharacterSetCommand;
use SqlFtw\Sql\Dal\Show\ShowCollationCommand;
use SqlFtw\Sql\Dal\Show\ShowColumnsCommand;
use SqlFtw\Sql\Dal\Show\ShowCreateEventCommand;
use SqlFtw\Sql\Dal\Show\ShowCreateFunctionCommand;
use SqlFtw\Sql\Dal\Show\ShowCreateProcedureCommand;
use SqlFtw\Sql\Dal\Show\ShowCreateSchemaCommand;
use SqlFtw\Sql\Dal\Show\ShowCreateTableCommand;
use SqlFtw\Sql\Dal\Show\ShowCreateTriggerCommand;
use SqlFtw\Sql\Dal\Show\ShowCreateViewCommand;
use SqlFtw\Sql\Dal\Show\ShowEngineCommand;
use SqlFtw\Sql\Dal\Show\ShowEnginesCommand;
use SqlFtw\Sql\Dal\Show\ShowEventsCommand;
use SqlFtw\Sql\Dal\Show\ShowFunctionStatusCommand;
use SqlFtw\Sql\Dal\Show\ShowGrantsCommand;
use SqlFtw\Sql\Dal\Show\ShowIndexesCommand;
use SqlFtw\Sql\Dal\Show\ShowMasterStatusCommand;
use SqlFtw\Sql\Dal\Show\ShowOpenTablesCommand;
use SqlFtw\Sql\Dal\Show\ShowProcedureStatusCommand;
use SqlFtw\Sql\Dal\Show\ShowProcessListCommand;
use SqlFtw\Sql\Dal\Show\ShowProfileCommand;
use SqlFtw\Sql\Dal\Show\ShowReplicaStatusCommand;
use SqlFtw\Sql\Dal\Show\ShowSchemasCommand;
use SqlFtw\Sql\Dal\Show\ShowSlaveStatusCommand;
use SqlFtw\Sql\Dal\Show\ShowStatusCommand;
use SqlFtw\Sql\Dal\Show\ShowTablesCommand;
use SqlFtw\Sql\Dal\Show\ShowTableStatusCommand;
use SqlFtw\Sql\Dal\Show\ShowTriggersCommand;
use SqlFtw\Sql\Dal\Show\ShowVariablesCommand;
use SqlFtw\Sql\Dal\Table\AnalyzeTableCommand;
use SqlFtw\Sql\Dal\Table\AnalyzeTableDropHistogramCommand;
use SqlFtw\Sql\Dal\Table\AnalyzeTableUpdateHistogramCommand;
use SqlFtw\Sql\Dal\Table\ChecksumTableCommand;
use SqlFtw\Sql\Dal\Table\OptimizeTableCommand;
use SqlFtw\Sql\Dal\Table\RepairTableCommand;
use SqlFtw\Sql\Dal\User\AlterUserCommand;
use SqlFtw\Sql\Dal\User\CreateUserCommand;
use SqlFtw\Sql\Dal\User\DropUserCommand;
use SqlFtw\Sql\Dal\User\GrantCommand;
use SqlFtw\Sql\Dal\User\RenameUserCommand;
use SqlFtw\Sql\Dal\User\RevokeAllCommand;
use SqlFtw\Sql\Dal\User\RevokeCommand;
use SqlFtw\Sql\Dal\User\RevokeProxyCommand;
use SqlFtw\Sql\Dal\User\RevokeRoleCommand;
use SqlFtw\Sql\Dal\User\SetPasswordCommand;
use SqlFtw\Sql\Dal\User\SetRoleCommand;
use SqlFtw\Sql\Ddl\Index\CreateIndexCommand;
use SqlFtw\Sql\Ddl\Index\DropIndexCommand;
use SqlFtw\Sql\Ddl\Schema\CreateSchemaCommand;
use SqlFtw\Sql\Ddl\Schema\DropSchemaCommand;
use SqlFtw\Sql\Ddl\Table\AlterTableCommand;
use SqlFtw\Sql\Ddl\Table\CreateTableCommand;
use SqlFtw\Sql\Ddl\Table\CreateTableLikeCommand;
use SqlFtw\Sql\Ddl\Table\DropTableCommand;
use SqlFtw\Sql\Ddl\Table\RenameTableCommand;
use SqlFtw\Sql\Ddl\Table\TruncateTableCommand;
use SqlFtw\Sql\Ddl\View\CreateViewCommand;
use SqlFtw\Sql\Ddl\View\DropViewCommand;
use SqlFtw\Sql\Dml\Call\CallCommand;
use SqlFtw\Sql\Dml\Delete\DeleteCommand;
use SqlFtw\Sql\Dml\DoCommand\DoCommand;
use SqlFtw\Sql\Dml\Insert\InsertCommand;
use SqlFtw\Sql\Dml\Insert\InsertSelectCommand;
use SqlFtw\Sql\Dml\Insert\InsertSetCommand;
use SqlFtw\Sql\Dml\Insert\InsertValuesCommand;
use SqlFtw\Sql\Dml\Insert\ReplaceSelectCommand;
use SqlFtw\Sql\Dml\Insert\ReplaceSetCommand;
use SqlFtw\Sql\Dml\Insert\ReplaceValuesCommand;
use SqlFtw\Sql\Dml\Query\ParenthesizedQueryExpression;
use SqlFtw\Sql\Dml\Query\QueryExpression;
use SqlFtw\Sql\Dml\Query\SelectCommand;
use SqlFtw\Sql\Dml\Query\TableCommand;
use SqlFtw\Sql\Dml\Query\ValuesCommand;
use SqlFtw\Sql\Dml\Transaction\CommitCommand;
use SqlFtw\Sql\Dml\Transaction\RollbackCommand;
use SqlFtw\Sql\Dml\Update\UpdateCommand;
use SqlFtw\Sql\Dml\Utility\DescribeTableCommand;
use SqlFtw\Sql\Dml\Utility\ExplainStatementCommand;
use SqlFtw\Sql\EntityType;
use SqlFtw\Sql\Expression\BaseType;
use SqlFtw\Sql\Expression\BuiltInFunction;
use SqlFtw\Sql\Expression\Operator;
use SqlFtw\Sql\Keyword;
use SqlFtw\Sql\MysqlVariable;

class MysqlFeatures extends FeaturesList
{

    /** @var list<array{Feature::*, int, int}> */
    public array $features = [
        [Feature::OPTIMIZER_HINTS, self::MIN, self::MAX],
        [Feature::OLD_NULL_LITERAL, self::MIN, 79999],
        [Feature::UNQUOTED_NAMES_CAN_START_WITH_DOLLAR_SIGN, self::MIN, 80031],
    ];

    /** @var list<array{Keyword::*, int, int}> */
    public array $reserved = [
        // https://dev.mysql.com/doc/refman/8.0/en/keywords.html
        [Keyword::ACCESSIBLE, 50106, self::MAX],
        [Keyword::ADD, self::MIN, self::MAX],
        [Keyword::ADMIN, 80000, 80012],
        [Keyword::ALL, self::MIN, self::MAX],
        [Keyword::ALTER, self::MIN, self::MAX],
        [Keyword::ANALYZE, self::MIN, self::MAX],
        [Keyword::AND, self::MIN, self::MAX],
        [Keyword::ARRAY, 80017, 80019],
        [Keyword::AS, self::MIN, self::MAX],
        [Keyword::ASC, self::MIN, self::MAX],
        [Keyword::ASENSITIVE, 50000, self::MAX],
        [Keyword::BEFORE, self::MIN, self::MAX],
        [Keyword::BETWEEN, self::MIN, self::MAX],
        [Keyword::BIGINT, self::MIN, self::MAX],
        [Keyword::BINARY, self::MIN, self::MAX],
        [Keyword::BLOB, self::MIN, self::MAX],
        [Keyword::BOTH, self::MIN, self::MAX],
        [Keyword::BY, self::MIN, self::MAX],
        [Keyword::CALL, 50000, self::MAX],
        [Keyword::CASCADE, self::MIN, self::MAX],
        [Keyword::CASE, self::MIN, self::MAX],
        [Keyword::CHANGE, self::MIN, self::MAX],
        [Keyword::CHAR, self::MIN, self::MAX],
        [Keyword::CHARACTER, self::MIN, self::MAX],
        [Keyword::CHECK, self::MIN, self::MAX],
        [Keyword::COLLATE, self::MIN, self::MAX],
        [Keyword::COLUMN, self::MIN, self::MAX],
        [Keyword::CONDITION, 50000, self::MAX],
        [Keyword::CONSTRAINT, self::MIN, self::MAX],
        [Keyword::CONTINUE, 50000, self::MAX],
        [Keyword::CONVERT, self::MIN, self::MAX],
        [Keyword::CREATE, self::MIN, self::MAX],
        [Keyword::CROSS, self::MIN, self::MAX],
        [Keyword::CUBE, 80001, self::MAX],
        [Keyword::CUME_DIST, 80002, self::MAX],
        [Keyword::CURRENT_DATE, self::MIN, self::MAX],
        [Keyword::CURRENT_TIME, self::MIN, self::MAX],
        [Keyword::CURRENT_TIMESTAMP, self::MIN, self::MAX],
        [Keyword::CURRENT_USER, self::MIN, self::MAX],
        [Keyword::CURSOR, 50000, self::MAX],
        [Keyword::DATABASE, self::MIN, self::MAX],
        [Keyword::DATABASES, self::MIN, self::MAX],
        [Keyword::DAY_HOUR, self::MIN, self::MAX],
        [Keyword::DAY_MICROSECOND, self::MIN, self::MAX],
        [Keyword::DAY_MINUTE, self::MIN, self::MAX],
        [Keyword::DAY_SECOND, self::MIN, self::MAX],
        [Keyword::DEC, self::MIN, self::MAX],
        [Keyword::DECIMAL, self::MIN, self::MAX],
        [Keyword::DECLARE, 50000, self::MAX],
        [Keyword::DEFAULT, self::MIN, self::MAX],
        [Keyword::DELAYED, self::MIN, self::MAX],
        [Keyword::DELETE, self::MIN, self::MAX],
        [Keyword::DENSE_RANK, 80002, self::MAX],
        [Keyword::DESC, self::MIN, self::MAX],
        [Keyword::DESCRIBE, self::MIN, self::MAX],
        [Keyword::DETERMINISTIC, 50000, self::MAX],
        [Keyword::DISTINCT, self::MIN, self::MAX],
        [Keyword::DISTINCTROW, self::MIN, self::MAX],
        [Keyword::DIV, self::MIN, self::MAX],
        [Keyword::DOUBLE, self::MIN, self::MAX],
        [Keyword::DROP, self::MIN, self::MAX],
        [Keyword::DUAL, self::MIN, self::MAX],
        [Keyword::EACH, 50000, self::MAX],
        [Keyword::ELSE, self::MIN, self::MAX],
        [Keyword::ELSEIF, 50000, self::MAX],
        [Keyword::EMPTY, 80004, self::MAX],
        [Keyword::ENCLOSED, self::MIN, self::MAX],
        [Keyword::ESCAPED, self::MIN, self::MAX],
        [Keyword::EXCEPT, 80031, self::MAX],
        [Keyword::EXISTS, self::MIN, self::MAX],
        [Keyword::EXIT, 50000, self::MAX],
        [Keyword::EXPLAIN, self::MIN, self::MAX],
        [Keyword::FALSE, self::MIN, self::MAX],
        [Keyword::FETCH, 50000, self::MAX],
        [Keyword::FIRST_VALUE, 80002, self::MAX],
        [Keyword::FLOAT, self::MIN, self::MAX],
        [Keyword::FLOAT4, self::MIN, self::MAX],
        [Keyword::FLOAT8, self::MIN, self::MAX],
        [Keyword::FOR, self::MIN, self::MAX],
        [Keyword::FORCE, self::MIN, self::MAX],
        [Keyword::FOREIGN, self::MIN, self::MAX],
        [Keyword::FROM, self::MIN, self::MAX],
        [Keyword::FULLTEXT, self::MIN, self::MAX],
        [Keyword::FUNCTION, 80001, self::MAX],
        [Keyword::GENERAL, 50503, 50508],
        [Keyword::GENERAL, 50600, 50601],
        [Keyword::GENERATED, 50706, self::MAX],
        [Keyword::GET, 50604, self::MAX],
        [Keyword::GET_MASTER_PUBLIC_KEY, 80004, 80011],
        [Keyword::GRANT, self::MIN, self::MAX],
        [Keyword::GROUP, self::MIN, self::MAX],
        [Keyword::GROUPING, 80001, self::MAX],
        [Keyword::GROUPS, 80002, self::MAX],
        [Keyword::HAVING, self::MIN, self::MAX],
        [Keyword::HIGH_PRIORITY, self::MIN, self::MAX],
        [Keyword::HOUR_MICROSECOND, self::MIN, self::MAX],
        [Keyword::HOUR_MINUTE, self::MIN, self::MAX],
        [Keyword::HOUR_SECOND, self::MIN, self::MAX],
        [Keyword::IF, self::MIN, self::MAX],
        [Keyword::IGNORE, self::MIN, self::MAX],
        [Keyword::IGNORE_SERVER_IDS, 50500, 50508],
        [Keyword::IGNORE_SERVER_IDS, 50600, 50601],
        [Keyword::IN, self::MIN, self::MAX],
        [Keyword::INDEX, self::MIN, self::MAX],
        [Keyword::INFILE, self::MIN, self::MAX],
        [Keyword::INNER, self::MIN, self::MAX],
        [Keyword::INOUT, 50000, self::MAX],
        [Keyword::INSENSITIVE, 50000, self::MAX],
        [Keyword::INSERT, self::MIN, self::MAX],
        [Keyword::INT, self::MIN, self::MAX],
        [Keyword::INT1, self::MIN, self::MAX],
        [Keyword::INT2, self::MIN, self::MAX],
        [Keyword::INT3, self::MIN, self::MAX],
        [Keyword::INT4, self::MIN, self::MAX],
        [Keyword::INT8, self::MIN, self::MAX],
        [Keyword::INTEGER, self::MIN, self::MAX],
        [Keyword::INTERVAL, self::MIN, self::MAX],
        [Keyword::INTERSECT, 80031, self::MAX],
        [Keyword::INTO, self::MIN, self::MAX],
        [Keyword::IO_AFTER_GTIDS, 50605, self::MAX],
        [Keyword::IO_BEFORE_GTIDS, 50605, self::MAX],
        [Keyword::IS, self::MIN, self::MAX],
        [Keyword::ITERATE, 50000, self::MAX],
        [Keyword::JOIN, self::MIN, self::MAX],
        [Keyword::JSON_TABLE, 80004, self::MAX],
        [Keyword::KEY, self::MIN, self::MAX],
        [Keyword::KEYS, self::MIN, self::MAX],
        [Keyword::KILL, self::MIN, self::MAX],
        [Keyword::LAG, 80002, self::MAX],
        [Keyword::LAST_VALUE, 80002, self::MAX],
        [Keyword::LATERAL, 80014, self::MAX],
        [Keyword::LEAD, 80002, self::MAX],
        [Keyword::LEADING, self::MIN, self::MAX],
        [Keyword::LEAVE, 50000, self::MAX],
        [Keyword::LEFT, self::MIN, self::MAX],
        [Keyword::LIKE, self::MIN, self::MAX],
        [Keyword::LIMIT, self::MIN, self::MAX],
        [Keyword::LINEAR, 50100, self::MAX],
        [Keyword::LINES, self::MIN, self::MAX],
        [Keyword::LOAD, self::MIN, self::MAX],
        [Keyword::LOCALTIME, self::MIN, self::MAX],
        [Keyword::LOCALTIMESTAMP, self::MIN, self::MAX],
        [Keyword::LOCK, self::MIN, self::MAX],
        [Keyword::LONG, self::MIN, self::MAX],
        [Keyword::LONGBLOB, self::MIN, self::MAX],
        [Keyword::LONGTEXT, self::MIN, self::MAX],
        [Keyword::LOOP, 50000, self::MAX],
        [Keyword::LOW_PRIORITY, self::MIN, self::MAX],
        [Keyword::MASTER_BIND, 50601, self::MAX],
        [Keyword::MASTER_HEARTBEAT_PERIOD, 50500, 50508],
        [Keyword::MASTER_HEARTBEAT_PERIOD, 50600, 50601],
        [Keyword::MASTER_SSL_VERIFY_SERVER_CERT, 50118, self::MAX],
        [Keyword::MATCH, self::MIN, self::MAX],
        [Keyword::MEDIUMBLOB, self::MIN, self::MAX],
        [Keyword::MEDIUMINT, self::MIN, self::MAX],
        [Keyword::MEDIUMTEXT, self::MIN, self::MAX],
        [Keyword::MEMBER, 80017, 80019],
        [Keyword::MIDDLEINT, self::MIN, self::MAX],
        [Keyword::MINUTE_MICROSECOND, self::MIN, self::MAX],
        [Keyword::MINUTE_SECOND, self::MIN, self::MAX],
        [Keyword::MOD, self::MIN, self::MAX],
        [Keyword::MODIFIES, 50000, self::MAX],
        [Keyword::NATURAL, self::MIN, self::MAX],
        [Keyword::NO_WRITE_TO_BINLOG, self::MIN, self::MAX],
        [Keyword::NOT, self::MIN, self::MAX],
        [Keyword::NTH_VALUE, 80002, self::MAX],
        [Keyword::NTILE, 80002, self::MAX],
        [Keyword::NULL, self::MIN, self::MAX],
        [Keyword::NUMERIC, self::MIN, self::MAX],
        [Keyword::OF, 80001, self::MAX],
        [Keyword::ON, self::MIN, self::MAX],
        [Keyword::OPTIMIZE, self::MIN, self::MAX],
        [Keyword::OPTIMIZER_COSTS, 50705, self::MAX],
        [Keyword::OPTION, self::MIN, self::MAX],
        [Keyword::OPTIONALLY, self::MIN, self::MAX],
        [Keyword::OR, self::MIN, self::MAX],
        [Keyword::ORDER, self::MIN, self::MAX],
        [Keyword::OUT, 50000, self::MAX],
        [Keyword::OUTER, self::MIN, self::MAX],
        [Keyword::OUTFILE, self::MIN, self::MAX],
        [Keyword::OVER, 80002, self::MAX],
        [Keyword::PARSE_GCOL_EXPR, 50706, 50708],
        [Keyword::PARTITION, 50100, self::MAX],
        [Keyword::PERCENT_RANK, 80002, self::MAX],
        [Keyword::PERSIST, 80000, 80016],
        [Keyword::PERSIST_ONLY, 80002, 80016],
        [Keyword::PRECISION, self::MIN, self::MAX],
        [Keyword::PRIMARY, self::MIN, self::MAX],
        [Keyword::PROCEDURE, self::MIN, self::MAX],
        [Keyword::PURGE, self::MIN, self::MAX],
        [Keyword::RANGE, 50100, self::MAX],
        [Keyword::RANK, 80002, self::MAX],
        [Keyword::READ, self::MIN, self::MAX],
        [Keyword::READ_ONLY, 50106, 50124],
        [Keyword::READ_WRITE, 50106, self::MAX],
        [Keyword::READS, 50000, self::MAX],
        [Keyword::REAL, self::MIN, self::MAX],
        [Keyword::RECURSIVE, 80001, self::MAX],
        [Keyword::REFERENCES, self::MIN, self::MAX],
        [Keyword::REGEXP, self::MIN, self::MAX],
        [Keyword::RELEASE, 50000, self::MAX],
        [Keyword::RENAME, self::MIN, self::MAX],
        [Keyword::REPEAT, 50000, self::MAX],
        [Keyword::REPLACE, self::MIN, self::MAX],
        [Keyword::REQUIRE, self::MIN, self::MAX],
        [Keyword::RESIGNAL, 50500, self::MAX],
        [Keyword::RESTRICT, self::MIN, self::MAX],
        [Keyword::RETURN, 50000, self::MAX],
        [Keyword::REVOKE, self::MIN, self::MAX],
        [Keyword::RIGHT, self::MIN, self::MAX],
        [Keyword::RLIKE, self::MIN, self::MAX],
        [Keyword::ROLE, 80000, 80001],
        [Keyword::ROW, 80002, self::MAX],
        [Keyword::ROW_NUMBER, 80002, self::MAX],
        [Keyword::ROWS, 80002, self::MAX],
        [Keyword::SECOND_MICROSECOND, self::MIN, self::MAX],
        [Keyword::SECOND_MICROSECOND, 80000, self::MAX],
        [Keyword::SELECT, self::MIN, self::MAX],
        [Keyword::SENSITIVE, 50000, self::MAX],
        [Keyword::SEPARATOR, self::MIN, self::MAX],
        [Keyword::SET, self::MIN, self::MAX],
        [Keyword::SHOW, self::MIN, self::MAX],
        [Keyword::SCHEMA, 50000, self::MAX],
        [Keyword::SCHEMAS, 50000, self::MAX],
        [Keyword::SIGNAL, 50500, self::MAX],
        [Keyword::SLOW, 50503, 50508],
        [Keyword::SLOW, 50600, 50601],
        [Keyword::SMALLINT, self::MIN, self::MAX],
        [Keyword::SPATIAL, self::MIN, self::MAX],
        [Keyword::SPECIFIC, 50000, self::MAX],
        [Keyword::SQL, 50000, self::MAX],
        [Keyword::SQL_AFTER_GTIDS, 50605, 50606],
        [Keyword::SQL_BEFORE_GTIDS, 50605, 50606],
        [Keyword::SQL_BIG_RESULT, self::MIN, self::MAX],
        [Keyword::SQL_CALC_FOUND_ROWS, self::MIN, self::MAX],
        [Keyword::SQL_SMALL_RESULT, self::MIN, self::MAX],
        [Keyword::SQLEXCEPTION, 50000, self::MAX],
        [Keyword::SQLSTATE, 50000, self::MAX],
        [Keyword::SQLWARNING, 50000, self::MAX],
        [Keyword::SSL, self::MIN, self::MAX],
        [Keyword::STARTING, self::MIN, self::MAX],
        [Keyword::STORED, 50706, self::MAX],
        [Keyword::STRAIGHT_JOIN, self::MIN, self::MAX],
        [Keyword::SYSTEM, 80003, self::MAX],
        [Keyword::TABLE, self::MIN, self::MAX],
        [Keyword::TERMINATED, self::MIN, self::MAX],
        [Keyword::THEN, self::MIN, self::MAX],
        [Keyword::TINYBLOB, self::MIN, self::MAX],
        [Keyword::TINYINT, self::MIN, self::MAX],
        [Keyword::TINYTEXT, self::MIN, self::MAX],
        [Keyword::TO, self::MIN, self::MAX],
        [Keyword::TRAILING, self::MIN, self::MAX],
        [Keyword::TRIGGER, 50000, self::MAX],
        [Keyword::TRUE, self::MIN, self::MAX],
        [Keyword::UNDO, 50000, self::MAX],
        [Keyword::UNION, self::MIN, self::MAX],
        [Keyword::UNIQUE, self::MIN, self::MAX],
        [Keyword::UNLOCK, self::MIN, self::MAX],
        [Keyword::UNSIGNED, self::MIN, self::MAX],
        [Keyword::UPDATE, self::MIN, self::MAX],
        [Keyword::UPGRADE, 50107, 50112],
        [Keyword::USAGE, self::MIN, self::MAX],
        [Keyword::USE, self::MIN, self::MAX],
        [Keyword::USING, self::MIN, self::MAX],
        [Keyword::UTC_DATE, self::MIN, self::MAX],
        [Keyword::UTC_TIME, self::MIN, self::MAX],
        [Keyword::UTC_TIMESTAMP, self::MIN, self::MAX],
        [Keyword::VALUES, self::MIN, self::MAX],
        [Keyword::VARBINARY, self::MIN, self::MAX],
        [Keyword::VARCHAR, self::MIN, self::MAX],
        [Keyword::VARCHARACTER, self::MIN, self::MAX],
        [Keyword::VARYING, self::MIN, self::MAX],
        [Keyword::VIRTUAL, 50706, self::MAX],
        [Keyword::WHEN, self::MIN, self::MAX],
        [Keyword::WHERE, self::MIN, self::MAX],
        [Keyword::WHILE, 50000, self::MAX],
        [Keyword::WINDOW, 80002, self::MAX],
        [Keyword::WITH, self::MIN, self::MAX],
        [Keyword::WRITE, self::MIN, self::MAX],
        [Keyword::XOR, self::MIN, self::MAX],
        [Keyword::YEAR_MONTH, self::MIN, self::MAX],
        [Keyword::ZEROFILL, self::MIN, self::MAX],
    ];

    /** @var list<array{Keyword::*, int, int}> */
    public array $nonReserved = [
        [Keyword::ACCOUNT, 50706, self::MAX],
        [Keyword::ACTION, self::MIN, self::MAX],
        [Keyword::ACTIVE, 80014, self::MAX],
        [Keyword::ADMIN, 80012, self::MAX],
        [Keyword::AFTER, self::MIN, self::MAX],
        [Keyword::AGAINST, self::MIN, self::MAX],
        [Keyword::AGGREGATE, self::MIN, self::MAX],
        [Keyword::ALGORITHM, 50000, self::MAX],
        [Keyword::ALWAYS, 50706, self::MAX],
        [Keyword::ANALYSE, 50600, 80001],
        [Keyword::ANY, self::MIN, self::MAX],
        [Keyword::ARRAY, 80019, self::MAX],
        [Keyword::ASCII, self::MIN, self::MAX],
        [Keyword::ASSIGN_GTIDS_TO_ANONYMOUS_TRANSACTIONS, 80023, self::MAX], // not listed
        [Keyword::AT, 50106, self::MAX],
        [Keyword::ATTRIBUTE, 80021, self::MAX],
        [Keyword::AUTHENTICATION, 80027, self::MAX],
        [Keyword::AUTHORS, 50100, 50608],
        [Keyword::AUTO_INCREMENT, self::MIN, self::MAX],
        [Keyword::AUTOEXTEND_SIZE, 50106, self::MAX],
        [Keyword::AVG, self::MIN, self::MAX],
        [Keyword::AVG_ROW_LENGTH, self::MIN, self::MAX],
        [Keyword::BACKUP, self::MIN, self::MAX],
        [Keyword::BDB, self::MIN, 50112],
        [Keyword::BEGIN, self::MIN, self::MAX],
        [Keyword::BERKELEYDB, self::MIN, 50112],
        [Keyword::BINLOG, self::MIN, self::MAX],
        [Keyword::BIT, self::MIN, self::MAX],
        [Keyword::BLOCK, 50000, self::MAX],
        [Keyword::BOOL, self::MIN, self::MAX],
        [Keyword::BOOLEAN, self::MIN, self::MAX],
        [Keyword::BTREE, self::MIN, self::MAX],
        [Keyword::BUCKETS, 80002, self::MAX],
        [Keyword::BULK, 80032, self::MAX],
        [Keyword::BYTE, self::MIN, self::MAX],
        [Keyword::CACHE, self::MIN, self::MAX],
        [Keyword::CASCADED, 50000, self::MAX],
        [Keyword::CATALOG_NAME, 50500, self::MAX],
        [Keyword::CHAIN, 50000, self::MAX],
        [Keyword::CHALLENGE_RESPONSE, 80027, self::MAX],
        [Keyword::CHANGED, self::MIN, self::MAX],
        [Keyword::CHANNEL, 50706, self::MAX],
        [Keyword::CHARSET, self::MIN, self::MAX],
        [Keyword::CHECKSUM, self::MIN, self::MAX],
        [Keyword::CIPHER, self::MIN, self::MAX],
        [Keyword::CLASS_ORIGIN, 50500, self::MAX],
        [Keyword::CLIENT, self::MIN, self::MAX],
        [Keyword::CLONE, 80003, self::MAX],
        [Keyword::CLOSE, self::MIN, self::MAX],
        [Keyword::COALESCE, 50100, self::MAX],
        [Keyword::CODE, 50000, self::MAX],
        [Keyword::COLLATION, self::MIN, self::MAX],
        [Keyword::COLUMN_FORMAT, 50606, self::MAX],
        [Keyword::COLUMN_NAME, 50500, self::MAX],
        [Keyword::COLUMNS, self::MIN, self::MAX],
        [Keyword::COMMENT, self::MIN, self::MAX],
        [Keyword::COMMIT, self::MIN, self::MAX],
        [Keyword::COMMITTED, self::MIN, self::MAX],
        [Keyword::COMPACT, 50000, self::MAX],
        [Keyword::COMPLETION, 50106, self::MAX],
        [Keyword::COMPONENT, 80000, self::MAX],
        [Keyword::COMPRESSED, self::MIN, self::MAX],
        [Keyword::COMPRESSION, 50708, self::MAX],
        [Keyword::CONCURRENT, self::MIN, self::MAX],
        [Keyword::CONNECTION, 50000, self::MAX],
        [Keyword::CONSISTENT, self::MIN, self::MAX],
        [Keyword::CONSTRAINT_CATALOG, 50500, self::MAX],
        [Keyword::CONSTRAINT_NAME, 50500, self::MAX],
        [Keyword::CONSTRAINT_SCHEMA, 50500, self::MAX],
        [Keyword::CONTAINS, 50000, self::MAX],
        [Keyword::CONTEXT, 50000, self::MAX],
        [Keyword::CONTRIBUTORS, 50112, 50608],
        [Keyword::CPU, 50000, self::MAX],
        [Keyword::CUBE, self::MIN, 80001],
        [Keyword::CURRENT, 50604, self::MAX],
        [Keyword::CURSOR_NAME, 50500, self::MAX],
        [Keyword::DATA, self::MIN, self::MAX],
        [Keyword::DATAFILE, 50106, self::MAX],
        [Keyword::DATE, self::MIN, self::MAX],
        [Keyword::DATETIME, self::MIN, self::MAX],
        [Keyword::DAY, self::MIN, self::MAX],
        [Keyword::DEALLOCATE, self::MIN, self::MAX],
        [Keyword::DEFAULT_AUTH, 50604, self::MAX],
        [Keyword::DEFINER, 50000, self::MAX],
        [Keyword::DEFINITION, 80004, self::MAX],
        [Keyword::DELAY_KEY_WRITE, self::MIN, self::MAX],
        [Keyword::DES_KEY_FILE, self::MIN, self::MAX],
        [Keyword::DESCRIPTION, 80004, self::MAX],
        [Keyword::DES_KEY_FILE, 80000, 80003],
        [Keyword::DIAGNOSTICS, 50604, self::MAX],
        [Keyword::DIRECTORY, self::MIN, self::MAX],
        [Keyword::DISABLE, self::MIN, self::MAX],
        [Keyword::DISCARD, self::MIN, self::MAX],
        [Keyword::DISK, 50106, self::MAX],
        [Keyword::DO, self::MIN, self::MAX],
        [Keyword::DUMPFILE, self::MIN, self::MAX],
        [Keyword::DUPLICATE, self::MIN, self::MAX],
        [Keyword::DYNAMIC, self::MIN, self::MAX],
        [Keyword::ENABLE, self::MIN, self::MAX],
        [Keyword::ENCRYPTION, 50711, self::MAX],
        [Keyword::END, self::MIN, self::MAX],
        [Keyword::ENDS, 50106, self::MAX],
        [Keyword::ENFORCED, 80016, self::MAX],
        [Keyword::ENGINE, self::MIN, self::MAX],
        [Keyword::ENGINE_ATTRIBUTE, 80021, self::MAX],
        [Keyword::ENGINES, self::MIN, self::MAX],
        [Keyword::ENUM, self::MIN, self::MAX],
        [Keyword::ERROR, 50500, self::MAX],
        [Keyword::ERRORS, self::MIN, self::MAX],
        [Keyword::ESCAPE, self::MIN, self::MAX],
        [Keyword::EVENT, self::MIN, self::MAX],
        [Keyword::EVENTS, 50106, self::MAX],
        [Keyword::EVERY, 50106, self::MAX],
        [Keyword::EXCEPT, 80000, 80030],
        [Keyword::EXCHANGE, 50600, self::MAX],
        [Keyword::EXCLUDE, 80002, self::MAX],
        [Keyword::EXECUTE, self::MIN, self::MAX],
        [Keyword::EXPANSION, self::MIN, self::MAX],
        [Keyword::EXPIRE, 50606, self::MAX],
        [Keyword::EXPORT, 50606, self::MAX],
        [Keyword::EXTENDED, self::MIN, self::MAX],
        [Keyword::EXTENT_SIZE, 50106, self::MAX],
        [Keyword::FACTOR, 80027, self::MAX],
        [Keyword::FAILED_LOGIN_ATTEMPTS, 80019, self::MAX],
        [Keyword::FAST, self::MIN, self::MAX],
        [Keyword::FAULTS, 50000, self::MAX],
        [Keyword::FIELDS, self::MIN, self::MAX],
        [Keyword::FILE, self::MIN, self::MAX],
        [Keyword::FILE_BLOCK_SIZE, 50706, self::MAX],
        [Keyword::FILTER, 50703, self::MAX],
        [Keyword::FINISH, 80027, self::MAX],
        [Keyword::FIRST, self::MIN, self::MAX],
        [Keyword::FIXED, self::MIN, self::MAX],
        [Keyword::FLUSH, self::MIN, self::MAX],
        [Keyword::FOLLOWING, 80002, self::MAX],
        [Keyword::FOLLOWS, 50702, self::MAX],
        [Keyword::FORMAT, 50605, self::MAX],
        [Keyword::FOUND, 50000, self::MAX],
        [Keyword::FRAC_SECOND, 50000, 50503],
        [Keyword::FULL, self::MIN, self::MAX],
        [Keyword::FUNCTION, self::MIN, 80001],
        [Keyword::GENERAL, 50508, self::MAX],
        [Keyword::GENERAL, 50601, self::MAX],
        [Keyword::GENERATE, 80032, self::MAX],
        [Keyword::GEOMCOLLECTION, 80011, self::MAX],
        [Keyword::GEOMETRY, self::MIN, self::MAX],
        [Keyword::GEOMETRYCOLLECTION, self::MIN, self::MAX],
        [Keyword::GET_FORMAT, self::MIN, self::MAX],
        [Keyword::GET_MASTER_PUBLIC_KEY, 80011, self::MAX],
        [Keyword::GET_SOURCE_PUBLIC_KEY, 80023, self::MAX],
        [Keyword::GLOBAL, self::MIN, self::MAX],
        [Keyword::GOTO, self::MIN, 50111],
        [Keyword::GRANTS, self::MIN, self::MAX],
        [Keyword::GROUP_REPLICATION, 50706, self::MAX],
        [Keyword::GTID_ONLY, 80027, self::MAX],
        [Keyword::HANDLER, self::MIN, self::MAX],
        [Keyword::HASH, self::MIN, self::MAX],
        [Keyword::HELP, self::MIN, self::MAX],
        [Keyword::HISTOGRAM, 80002, self::MAX],
        [Keyword::HISTORY, 80003, self::MAX],
        [Keyword::HOST, 50115, self::MAX],
        [Keyword::HOSTS, self::MIN, self::MAX],
        [Keyword::HOUR, self::MIN, self::MAX],
        [Keyword::IDENTIFIED, self::MIN, self::MAX],
        [Keyword::IGNORE_SERVER_IDS, 50500, self::MAX],
        [Keyword::IGNORE_SERVER_IDS, 50508, self::MAX],
        [Keyword::IGNORE_SERVER_IDS, 50601, self::MAX],
        [Keyword::IMPORT, self::MIN, self::MAX],
        [Keyword::INACTIVE, 80014, self::MAX],
        [Keyword::INDEXES, self::MIN, self::MAX],
        [Keyword::INITIAL, 80027, self::MAX],
        [Keyword::INITIAL_SIZE, 50106, self::MAX],
        [Keyword::INITIATE, 80027, self::MAX],
        [Keyword::INNOBASE, self::MIN, 50503],
        [Keyword::INNODB, self::MIN, self::MAX], // removed in 50503, but used e.g. in ROTATE INNODB MASTER KEY
        [Keyword::INSERT_METHOD, self::MIN, self::MAX],
        [Keyword::INSTALL, 50100, self::MAX],
        [Keyword::INSTANCE, 50711, self::MAX],
        [Keyword::INVISIBLE, 80000, self::MAX],
        [Keyword::INVOKER, 50000, self::MAX],
        [Keyword::IO, 50000, self::MAX],
        [Keyword::IO_THREAD, self::MIN, self::MAX],
        [Keyword::IPC, 50000, self::MAX],
        [Keyword::ISOLATION, self::MIN, self::MAX],
        [Keyword::ISSUER, self::MIN, self::MAX],
        [Keyword::JSON, 50708, self::MAX],
        [Keyword::JSON_VALUE, 80021, self::MAX],
        [Keyword::KEY_BLOCK_SIZE, 50111, self::MAX],
        [Keyword::KEYRING, 80024, self::MAX],
        [Keyword::LABEL, self::MIN, 50111],
        [Keyword::LANGUAGE, 50000, self::MAX],
        [Keyword::LAST, self::MIN, self::MAX],
        [Keyword::LEAVES, self::MIN, self::MAX],
        [Keyword::LESS, 50100, self::MAX],
        [Keyword::LEVEL, self::MIN, self::MAX],
        [Keyword::LINESTRING, self::MIN, self::MAX],
        [Keyword::LIST, 50100, self::MAX],
        [Keyword::LOCAL, self::MIN, self::MAX],
        [Keyword::LOCKED, 80001, self::MAX], // 80002, but unit tests say otherwise
        [Keyword::LOCKS, self::MIN, self::MAX],
        [Keyword::LOGFILE, 50106, self::MAX],
        [Keyword::LOGS, self::MIN, self::MAX],
        [Keyword::MASTER, self::MIN, self::MAX],
        [Keyword::MASTER_AUTO_POSITION, 50605, self::MAX],
        [Keyword::MASTER_COMPRESSION_ALGORITHMS, 80018, self::MAX],
        [Keyword::MASTER_CONNECT_RETRY, self::MIN, self::MAX],
        [Keyword::MASTER_DELAY, 50600, self::MAX],
        [Keyword::MASTER_HEARTBEAT_PERIOD, 50508, 50599],
        [Keyword::MASTER_HEARTBEAT_PERIOD, 50601, self::MAX],
        [Keyword::MASTER_HOST, self::MIN, self::MAX],
        [Keyword::MASTER_LOG_FILE, self::MIN, self::MAX],
        [Keyword::MASTER_LOG_POS, self::MIN, self::MAX],
        [Keyword::MASTER_PASSWORD, self::MIN, self::MAX],
        [Keyword::MASTER_PORT, self::MIN, self::MAX],
        [Keyword::MASTER_PUBLIC_KEY_PATH, 80004, self::MAX],
        [Keyword::MASTER_RETRY_COUNT, 50601, self::MAX],
        [Keyword::MASTER_SERVER_ID, self::MIN, 80023],
        [Keyword::MASTER_SSL, self::MIN, self::MAX],
        [Keyword::MASTER_SSL_CA, self::MIN, self::MAX],
        [Keyword::MASTER_SSL_CAPATH, self::MIN, self::MAX],
        [Keyword::MASTER_SSL_CERT, self::MIN, self::MAX],
        [Keyword::MASTER_SSL_CIPHER, self::MIN, self::MAX],
        [Keyword::MASTER_SSL_CRL, 50603, self::MAX],
        [Keyword::MASTER_SSL_CRLPATH, 50603, self::MAX],
        [Keyword::MASTER_SSL_KEY, self::MIN, self::MAX],
        [Keyword::MASTER_TLS_CIPHERSUITES, 80019, self::MAX],
        [Keyword::MASTER_TLS_VERSION, 50710, self::MAX],
        [Keyword::MASTER_USER, self::MIN, self::MAX],
        [Keyword::MASTER_ZSTD_COMPRESSION_LEVEL, 80018, self::MAX],
        [Keyword::MAX_CONNECTIONS_PER_HOUR, self::MIN, self::MAX],
        [Keyword::MAX_QUERIES_PER_HOUR, self::MIN, self::MAX],
        [Keyword::MAX_ROWS, self::MIN, self::MAX],
        [Keyword::MAX_SIZE, 50106, self::MAX],
        [Keyword::MAX_STATEMENT_TIME, 50704, 50708],
        [Keyword::MAX_UPDATES_PER_HOUR, self::MIN, self::MAX],
        [Keyword::MAX_USER_CONNECTIONS, 50000, self::MAX],
        [Keyword::MAXVALUE, 50100, self::MAX],
        [Keyword::MEDIUM, self::MIN, self::MAX],
        [Keyword::MEMBER, 80019, self::MAX],
        [Keyword::MEMORY, 50000, self::MAX],
        [Keyword::MERGE, 50000, self::MAX],
        [Keyword::MESSAGE_TEXT, 50500, self::MAX],
        [Keyword::MICROSECOND, self::MIN, self::MAX],
        [Keyword::MIGRATE, 50000, self::MAX],
        [Keyword::MIN_ROWS, self::MIN, self::MAX],
        [Keyword::MINUTE, self::MIN, self::MAX],
        [Keyword::MODE, self::MIN, self::MAX],
        [Keyword::MODIFY, self::MIN, self::MAX],
        [Keyword::MONTH, self::MIN, self::MAX],
        [Keyword::MULTILINESTRING, self::MIN, self::MAX],
        [Keyword::MULTIPOINT, self::MIN, self::MAX],
        [Keyword::MULTIPOLYGON, self::MIN, self::MAX],
        [Keyword::MUTEX, 50000, self::MAX],
        [Keyword::MYSQL_ERRNO, 50500, self::MAX],
        [Keyword::NAME, 50000, self::MAX],
        [Keyword::NAMES, self::MIN, self::MAX],
        [Keyword::NATIONAL, self::MIN, self::MAX],
        [Keyword::NDB, self::MIN, self::MAX],
        [Keyword::NDBCLUSTER, self::MIN, self::MAX],
        [Keyword::NESTED, 80004, self::MAX],
        [Keyword::NETWORK_NAMESPACE, 80016, self::MAX],
        [Keyword::NEVER, 50704, self::MAX],
        [Keyword::NEW, self::MIN, self::MAX],
        [Keyword::NEXT, self::MIN, self::MAX],
        [Keyword::NCHAR, self::MIN, self::MAX],
        [Keyword::NO, self::MIN, self::MAX],
        [Keyword::NO_WAIT, 50106, self::MAX],
        [Keyword::NODEGROUP, 50100, self::MAX],
        [Keyword::NONBLOCKING, 50706, self::MAX],
        [Keyword::NONE, self::MIN, self::MAX],
        [Keyword::NOWAIT, 80001, self::MAX],
        [Keyword::NULLS, 80002, self::MAX],
        [Keyword::NUMBER, 50604, self::MAX],
        [Keyword::NVARCHAR, self::MIN, self::MAX],
        [Keyword::OFF, 80020, self::MAX],
        [Keyword::OFFSET, self::MIN, self::MAX],
        [Keyword::OJ, 80016, self::MAX],
        [Keyword::OLD, 80014, self::MAX],
        [Keyword::OLD_PASSWORD, self::MIN, 50705],
        [Keyword::ONE, 50000, self::MAX],
        [Keyword::ONE_SHOT, self::MIN, 50605],
        [Keyword::ONLINE, 50500, self::MAX], // not listed, but mentioned in NDB docs since 5.5
        [Keyword::ONLY, 50605, self::MAX],
        [Keyword::OPEN, self::MIN, self::MAX],
        [Keyword::OPTIONAL, 80013, self::MAX],
        [Keyword::OPTIONS, 50115, self::MAX],
        [Keyword::ORDINALITY, 80004, self::MAX],
        [Keyword::ORGANIZATION, 80004, self::MAX],
        [Keyword::OTHERS, 80002, self::MAX],
        [Keyword::OWNER, 50115, self::MAX],
        [Keyword::PACK_KEYS, self::MIN, self::MAX],
        [Keyword::PAGE, 50000, self::MAX],
        [Keyword::PAGE_CHECKSUM, 50124, 50138],
        [Keyword::PARSE_GCOL_EXPR, 50708, self::MAX],
        [Keyword::PARSER, 50100, self::MAX],
        [Keyword::PARTIAL, self::MIN, self::MAX],
        [Keyword::PARTITIONING, 50119, self::MAX],
        [Keyword::PARTITIONS, 50100, self::MAX],
        [Keyword::PASSWORD, self::MIN, self::MAX],
        [Keyword::PASSWORD_LOCK_TIME, 80019, self::MAX],
        [Keyword::PATH, 80004, self::MAX],
        [Keyword::PERSIST, 80016, self::MAX],
        [Keyword::PERSIST_ONLY, 80016, self::MAX],
        [Keyword::PHASE, 50000, self::MAX],
        [Keyword::PLUGIN, 50100, self::MAX],
        [Keyword::PLUGIN_DIR, 50604, self::MAX],
        [Keyword::PLUGINS, 50119, self::MAX],
        [Keyword::POINT, self::MIN, self::MAX],
        [Keyword::POLYGON, self::MIN, self::MAX],
        [Keyword::PORT, 50115, self::MAX],
        [Keyword::PRECEDES, 50702, self::MAX],
        [Keyword::PRECEDING, 80002, self::MAX],
        [Keyword::PREPARE, self::MIN, self::MAX],
        [Keyword::PRESERVE, 50106, self::MAX],
        [Keyword::PREV, self::MIN, self::MAX],
        [Keyword::PRIVILEGE_CHECKS_USER, 80018, self::MAX],
        [Keyword::PRIVILEGES, self::MIN, self::MAX],
        [Keyword::PROCESS, 80011, self::MAX],
        [Keyword::PROCESSLIST, self::MIN, self::MAX],
        [Keyword::PROFILE, 50000, self::MAX],
        [Keyword::PROFILES, 50000, self::MAX],
        [Keyword::PROXY, 50507, self::MAX],
        [Keyword::PROXY, 50601, self::MAX],
        [Keyword::QUARTER, 50000, self::MAX],
        [Keyword::QUERY, self::MIN, self::MAX],
        [Keyword::QUICK, self::MIN, self::MAX],
        [Keyword::RAID_CHUNKS, self::MIN, 50107],
        [Keyword::RAID_CHUNKSIZE, self::MIN, 50107],
        [Keyword::RAID_TYPE, self::MIN, 50107],
        [Keyword::RAID0, self::MIN, 50107],
        [Keyword::RANDOM, 80018, self::MAX],
        [Keyword::READ_ONLY, 50124, self::MAX],
        [Keyword::REBUILD, 50106, self::MAX],
        [Keyword::RECOVER, 50000, self::MAX],
        [Keyword::REDO_BUFFER_SIZE, 50106, self::MAX],
        [Keyword::REDO_LOG, 80021, self::MAX], // not documented as keyword. used in ENABLE INNODB REDO_LOG
        [Keyword::REDOFILE, 50106, 80003],
        [Keyword::REDUNDANT, 50000, self::MAX],
        [Keyword::REFERENCE, 80004, self::MAX],
        [Keyword::REGISTRATION, 80027, self::MAX],
        [Keyword::RELAY, 50503, self::MAX],
        [Keyword::RELAY_LOG_FILE, self::MIN, self::MAX],
        [Keyword::RELAY_LOG_POS, self::MIN, self::MAX],
        [Keyword::RELAY_THREAD, self::MIN, self::MAX],
        [Keyword::RELAYLOG, 50500, self::MAX],
        [Keyword::RELOAD, self::MIN, self::MAX],
        [Keyword::REMOVE, 50109, self::MAX],
        [Keyword::REMOTE, 80003, 80014],
        [Keyword::REORGANISE, self::MIN, 50106],
        [Keyword::REORGANIZE, 50106, self::MAX],
        [Keyword::REPAIR, self::MIN, self::MAX],
        [Keyword::REPEATABLE, self::MIN, self::MAX],
        [Keyword::REPLICA, 80022, self::MAX],
        [Keyword::REPLICAS, 80022, self::MAX],
        [Keyword::REPLICATE_DO_DB, 50703, self::MAX],
        [Keyword::REPLICATE_DO_TABLE, 50703, self::MAX],
        [Keyword::REPLICATE_IGNORE_DB, 50703, self::MAX],
        [Keyword::REPLICATE_IGNORE_TABLE, 50703, self::MAX],
        [Keyword::REPLICATE_REWRITE_DB, 50703, self::MAX],
        [Keyword::REPLICATE_WILD_DO_TABLE, 50703, self::MAX],
        [Keyword::REPLICATE_WILD_IGNORE_TABLE, 50703, self::MAX],
        [Keyword::REPLICATION, self::MIN, self::MAX],
        [Keyword::REQUIRE_ROW_FORMAT, 80019, self::MAX],
        [Keyword::REQUIRE_TABLE_PRIMARY_KEY_CHECK, 80020, self::MAX], // not listed
        [Keyword::RESET, self::MIN, self::MAX],
        [Keyword::RESOURCE, 80003, self::MAX],
        [Keyword::RESPECT, 80002, self::MAX],
        [Keyword::RESTART, 80004, self::MAX],
        [Keyword::RESTORE, self::MIN, self::MAX],
        [Keyword::RESUME, 50000, self::MAX],
        [Keyword::RETAIN, 80014, self::MAX],
        [Keyword::RETURNED_SQLSTATE, 50604, self::MAX],
        [Keyword::RETURNING, 80021, self::MAX],
        [Keyword::RETURNS, self::MIN, self::MAX],
        [Keyword::REUSE, 80003, self::MAX],
        [Keyword::REVERSE, 50600, self::MAX],
        [Keyword::ROLE, 80001, self::MAX],
        [Keyword::ROLLBACK, self::MIN, self::MAX],
        [Keyword::ROLLUP, self::MIN, self::MAX],
        [Keyword::ROTATE, 50711, self::MAX],
        [Keyword::ROUTINE, 50000, self::MAX],
        [Keyword::ROW, self::MIN, 80002],
        [Keyword::ROW_COUNT, 50604, self::MAX],
        [Keyword::ROW_FORMAT, self::MIN, self::MAX],
        [Keyword::ROWS, self::MIN, 80002],
        [Keyword::RTREE, self::MIN, self::MAX],
        [Keyword::SAVEPOINT, self::MIN, self::MAX],
        [Keyword::SECOND, self::MIN, self::MAX],
        [Keyword::SECONDARY, 80016, self::MAX],
        [Keyword::SECONDARY_ENGINE, 80013, self::MAX],
        [Keyword::SECONDARY_ENGINE_ATTRIBUTE, 80021, self::MAX],
        [Keyword::SECONDARY_LOAD, 80013, self::MAX],
        [Keyword::SECONDARY_UNLOAD, 80013, self::MAX],
        [Keyword::SECURITY, 50000, self::MAX],
        [Keyword::SERIAL, self::MIN, self::MAX],
        [Keyword::SERIALIZABLE, self::MIN, self::MAX],
        [Keyword::SERVER, 50115, self::MAX],
        [Keyword::SESSION, self::MIN, self::MAX],
        [Keyword::SHARE, self::MIN, self::MAX],
        [Keyword::SHUTDOWN, self::MIN, self::MAX],
        [Keyword::SCHEDULE, 50106, self::MAX],
        [Keyword::SCHEDULER, 50111, 50112],
        [Keyword::SCHEMA_NAME, 50500, self::MAX],
        [Keyword::SIGNED, self::MIN, self::MAX],
        [Keyword::SIMPLE, self::MIN, self::MAX],
        [Keyword::SKIP, 80001, self::MAX],
        [Keyword::SLAVE, self::MIN, self::MAX],
        [Keyword::SLOW, 50508, self::MAX],
        [Keyword::SLOW, 50601, self::MAX],
        [Keyword::SNAPSHOT, self::MIN, self::MAX],
        [Keyword::SOCKET, 50115, self::MAX],
        [Keyword::SOME, self::MIN, self::MAX],
        [Keyword::SONAME, self::MIN, self::MAX],
        [Keyword::SOUNDS, self::MIN, self::MAX],
        [Keyword::SOURCE, 50000, 50124],
        [Keyword::SOURCE, 80023, self::MAX],
        [Keyword::SOURCE_AUTO_POSITION, 80023, self::MAX],
        [Keyword::SOURCE_BIND, 80023, self::MAX],
        [Keyword::SOURCE_COMPRESSION_ALGORITHMS, 80023, self::MAX],
        [Keyword::SOURCE_CONNECT_RETRY, 80023, self::MAX],
        [Keyword::SOURCE_CONNECTION_AUTO_FAILOVER, 80022, self::MAX], // not documented as keyword
        [Keyword::SOURCE_DELAY, 80023, self::MAX],
        [Keyword::SOURCE_HEARTBEAT_PERIOD, 80023, self::MAX],
        [Keyword::SOURCE_HOST, 80023, self::MAX],
        [Keyword::SOURCE_LOG_FILE, 80023, self::MAX],
        [Keyword::SOURCE_LOG_POS, 80023, self::MAX],
        [Keyword::SOURCE_PASSWORD, 80023, self::MAX],
        [Keyword::SOURCE_PORT, 80023, self::MAX],
        [Keyword::SOURCE_PUBLIC_KEY_PATH, 80023, self::MAX],
        [Keyword::SOURCE_RETRY_COUNT, 80023, self::MAX],
        [Keyword::SOURCE_SSL, 80023, self::MAX],
        [Keyword::SOURCE_SSL_CA, 80023, self::MAX],
        [Keyword::SOURCE_SSL_CAPATH, 80023, self::MAX],
        [Keyword::SOURCE_SSL_CERT, 80023, self::MAX],
        [Keyword::SOURCE_SSL_CIPHER, 80023, self::MAX],
        [Keyword::SOURCE_SSL_CRL, 80023, self::MAX],
        [Keyword::SOURCE_SSL_CRLPATH, 80023, self::MAX],
        [Keyword::SOURCE_SSL_KEY, 80023, self::MAX],
        [Keyword::SOURCE_SSL_VERIFY_SERVER_CERT, 80023, self::MAX],
        [Keyword::SOURCE_TLS_CIPHERSUITES, 80023, self::MAX],
        [Keyword::SOURCE_TLS_VERSION, 80023, self::MAX],
        [Keyword::SOURCE_USER, 80023, self::MAX],
        [Keyword::SOURCE_ZSTD_COMPRESSION_LEVEL, 80023, self::MAX],
        [Keyword::SQL_AFTER_GTIDS, 50606, self::MAX],
        [Keyword::SQL_AFTER_MTS_GAPS, 50606, self::MAX],
        [Keyword::SQL_BEFORE_GTIDS, 50606, self::MAX],
        [Keyword::SQL_BUFFER_RESULT, self::MIN, self::MAX],
        [Keyword::SQL_CACHE, self::MIN, 80003],
        [Keyword::SQL_NO_CACHE, self::MIN, self::MAX],
        [Keyword::SQL_THREAD, self::MIN, self::MAX],
        [Keyword::SQL_TSI_DAY, 50000, self::MAX],
        [Keyword::SQL_TSI_FRAC_SECOND, 50000, 50503],
        [Keyword::SQL_TSI_HOUR, 50000, self::MAX],
        [Keyword::SQL_TSI_MINUTE, 50000, self::MAX],
        [Keyword::SQL_TSI_MONTH, 50000, self::MAX],
        [Keyword::SQL_TSI_QUARTER, 50000, self::MAX],
        [Keyword::SQL_TSI_SECOND, 50000, self::MAX],
        [Keyword::SQL_TSI_WEEK, 50000, self::MAX],
        [Keyword::SQL_TSI_YEAR, 50000, self::MAX],
        [Keyword::SRID, 80003, self::MAX],
        [Keyword::STACKED, 50700, self::MAX],
        [Keyword::START, self::MIN, self::MAX],
        [Keyword::STARTS, 50106, self::MAX],
        [Keyword::STATS_AUTO_RECALC, 50606, self::MAX],
        [Keyword::STATS_PERSISTENT, 50606, self::MAX],
        [Keyword::STATS_SAMPLE_PAGES, 50606, self::MAX],
        [Keyword::STATUS, self::MIN, self::MAX],
        [Keyword::STOP, self::MIN, self::MAX],
        [Keyword::STORAGE, self::MIN, self::MAX],
        [Keyword::STREAM, 80020, self::MAX],
        [Keyword::STRING, self::MIN, self::MAX],
        [Keyword::STRIPED, self::MIN, 50107],
        [Keyword::SUBCLASS_ORIGIN, 50500, self::MAX],
        [Keyword::SUBJECT, self::MIN, self::MAX],
        [Keyword::SUBPARTITION, 50100, self::MAX],
        [Keyword::SUBPARTITIONS, 50100, self::MAX],
        [Keyword::SUPER, self::MIN, self::MAX],
        [Keyword::SUSPEND, 50000, self::MAX],
        [Keyword::SWAPS, 50000, self::MAX],
        [Keyword::SWITCHES, 50000, self::MAX],
        [Keyword::TABLE_CHECKSUM, 50124, self::MAX],
        [Keyword::TABLE_NAME, 50500, self::MAX],
        [Keyword::TABLES, self::MIN, self::MAX],
        [Keyword::TABLESPACE, self::MIN, self::MAX],
        [Keyword::TEMPORARY, self::MIN, self::MAX],
        [Keyword::TEMPTABLE, 50000, self::MAX],
        [Keyword::TEXT, self::MIN, self::MAX],
        [Keyword::THAN, 50100, self::MAX],
        [Keyword::THREAD_PRIORITY, 80003, self::MAX],
        [Keyword::TIES, 80002, self::MAX],
        [Keyword::TIME, self::MIN, self::MAX],
        [Keyword::TIMESTAMP, self::MIN, self::MAX],
        [Keyword::TIMESTAMPADD, 50000, self::MAX],
        [Keyword::TIMESTAMPDIFF, 50000, self::MAX],
        [Keyword::TLS, 80021, self::MAX],
        [Keyword::TRANSACTION, self::MIN, self::MAX],
        [Keyword::TRANSACTIONAL, 50124, 50138],
        [Keyword::TRIGGERS, 50000, self::MAX],
        [Keyword::TRUNCATE, self::MIN, self::MAX],
        [Keyword::TYPE, self::MIN, self::MAX],
        [Keyword::TYPES, self::MIN, self::MAX],
        [Keyword::UNBOUNDED, 80002, self::MAX],
        [Keyword::UNCOMMITTED, self::MIN, self::MAX],
        [Keyword::UNDEFINED, 50000, self::MAX],
        [Keyword::UNDO_BUFFER_SIZE, 50106, self::MAX],
        [Keyword::UNDOFILE, 50106, self::MAX],
        [Keyword::UNICODE, self::MIN, self::MAX],
        [Keyword::UNINSTALL, 50100, self::MAX],
        [Keyword::UNKNOWN, 50000, self::MAX],
        [Keyword::UNREGISTER, 80027, self::MAX],
        [Keyword::UNTIL, self::MIN, self::MAX],
        [Keyword::UPGRADE, 50000, self::MAX],
        [Keyword::URL, 80032, self::MAX],
        [Keyword::USE_FRM, self::MIN, self::MAX],
        [Keyword::USER, self::MIN, self::MAX],
        [Keyword::USER_RESOURCES, self::MIN, self::MAX],
        [Keyword::VALIDATION, 50705, self::MAX],
        [Keyword::VALUE, self::MIN, self::MAX],
        [Keyword::VARIABLES, self::MIN, self::MAX],
        [Keyword::VCPU, 80003, self::MAX],
        [Keyword::VIEW, 50000, self::MAX],
        [Keyword::VISIBLE, 80000, self::MAX],
        [Keyword::WAIT, 50106, self::MAX],
        [Keyword::WARNINGS, self::MIN, self::MAX],
        [Keyword::WEEK, 50000, self::MAX],
        [Keyword::WEIGHT_STRING, 50600, self::MAX],
        [Keyword::WITHOUT, 50705, self::MAX],
        [Keyword::WORK, self::MIN, self::MAX],
        [Keyword::WRAPPER, 50115, self::MAX],
        [Keyword::X509, self::MIN, self::MAX],
        [Keyword::XA, 50000, self::MAX],
        [Keyword::XID, 50705, self::MAX],
        [Keyword::XML, 50500, self::MAX],
        [Keyword::YEAR, self::MIN, self::MAX],
        [Keyword::ZONE, 80022, self::MAX],
    ];

    /** @var list<array{Operator::*, int, int}> */
    public array $operators = [
        // assign
        [Operator::ASSIGN, self::MIN, self::MAX],

        // boolean
        [Operator::AND, self::MIN, self::MAX],
        [Operator::OR, self::MIN, self::MAX],
        [Operator::XOR, self::MIN, self::MAX],
        [Operator::NOT, self::MIN, self::MAX],
        [Operator::AMPERSANDS, self::MIN, self::MAX],
        [Operator::PIPES, self::MIN, self::MAX],
        [Operator::EXCLAMATION, self::MIN, self::MAX],

        // comparison
        [Operator::EQUAL, self::MIN, self::MAX],
        [Operator::NOT_EQUAL, self::MIN, self::MAX],
        [Operator::GREATER, self::MIN, self::MAX],
        [Operator::GREATER_OR_EQUAL, self::MIN, self::MAX],
        [Operator::LESS, self::MIN, self::MAX],
        [Operator::LESS_OR_EQUAL, self::MIN, self::MAX],
        [Operator::LESS_OR_GREATER, self::MIN, self::MAX],
        [Operator::SAFE_EQUAL, self::MIN, self::MAX],
        [Operator::BETWEEN, self::MIN, self::MAX],
        [Operator::NOT_BETWEEN, self::MIN, self::MAX],

        // arithmetic
        [Operator::PLUS, self::MIN, self::MAX],
        [Operator::MINUS, self::MIN, self::MAX],
        [Operator::MULTIPLY, self::MIN, self::MAX],
        [Operator::DIVIDE, self::MIN, self::MAX],
        [Operator::DIV, self::MIN, self::MAX],
        [Operator::MOD, self::MIN, self::MAX],
        [Operator::MODULO, self::MIN, self::MAX],

        // binary
        [Operator::BIT_AND, self::MIN, self::MAX],
        [Operator::BIT_INVERT, self::MIN, self::MAX],
        [Operator::BIT_OR, self::MIN, self::MAX],
        [Operator::BIT_XOR, self::MIN, self::MAX],
        [Operator::LEFT_SHIFT, self::MIN, self::MAX],
        [Operator::RIGHT_SHIFT, self::MIN, self::MAX],

        // test
        [Operator::IS, self::MIN, self::MAX],
        [Operator::IS_NOT, self::MIN, self::MAX],
        [Operator::LIKE, self::MIN, self::MAX],
        [Operator::NOT_LIKE, self::MIN, self::MAX],
        [Operator::ESCAPE, self::MIN, self::MAX],
        [Operator::REGEXP, self::MIN, self::MAX],
        [Operator::NOT_REGEXP, self::MIN, self::MAX],
        [Operator::RLIKE, self::MIN, self::MAX],
        [Operator::NOT_RLIKE, self::MIN, self::MAX],
        [Operator::SOUNDS_LIKE, self::MIN, self::MAX],

        // case
        [Operator::CASE, self::MIN, self::MAX],
        [Operator::WHEN, self::MIN, self::MAX],
        [Operator::THEN, self::MIN, self::MAX],
        [Operator::ELSE, self::MIN, self::MAX],
        [Operator::END, self::MIN, self::MAX],

        // set & quantifiers
        [Operator::IN, self::MIN, self::MAX],
        [Operator::NOT_IN, self::MIN, self::MAX],
        [Operator::ALL, self::MIN, self::MAX],
        [Operator::ANY, self::MIN, self::MAX],
        [Operator::EXISTS, self::MIN, self::MAX],
        [Operator::SOME, self::MIN, self::MAX],

        // collation
        [Operator::BINARY, self::MIN, self::MAX], // todo: removed in 80027, but fails tests on 80099 ^_^

        // JSON
        [Operator::JSON_EXTRACT, 50709, self::MAX],
        [Operator::JSON_EXTRACT_UNQUOTE, 50713, self::MAX],
        [Operator::MEMBER_OF, 80017, self::MAX],
    ];

    /** @var list<array{BaseType::*, int, int}> */
    public array $types = [
        // bitwise
        [BaseType::BIT, self::MIN, self::MAX],

        // integers
        [BaseType::TINYINT, self::MIN, self::MAX],
        [BaseType::SMALLINT, self::MIN, self::MAX],
        [BaseType::MEDIUMINT, self::MIN, self::MAX],
        [BaseType::INT, self::MIN, self::MAX],
        [BaseType::BIGINT, self::MIN, self::MAX],
        [BaseType::SERIAL, self::MIN, self::MAX],
        [BaseType::BOOL, self::MIN, self::MAX], // TINYINT
        [BaseType::BOOLEAN, self::MIN, self::MAX], // TINYINT
        [BaseType::MIDDLEINT, self::MIN, self::MAX], // MEDIUMINT
        [BaseType::INTEGER, self::MIN, self::MAX], // INT
        [BaseType::INT1, self::MIN, self::MAX], // TINYINT
        [BaseType::INT2, self::MIN, self::MAX], // SMALLINT
        [BaseType::INT3, self::MIN, self::MAX], // MEDIUMINT
        [BaseType::INT4, self::MIN, self::MAX], // INT
        [BaseType::INT8, self::MIN, self::MAX], // BIGINT

        // floats
        [BaseType::FLOAT, self::MIN, self::MAX],
        [BaseType::DOUBLE, self::MIN, self::MAX],
        [BaseType::REAL, self::MIN, self::MAX], // FLOAT/DOUBLE
        [BaseType::FLOAT4, self::MIN, self::MAX], // FLOAT
        [BaseType::FLOAT8, self::MIN, self::MAX], // DOUBLE

        // decimal
        [BaseType::DECIMAL, self::MIN, self::MAX],
        [BaseType::DEC, self::MIN, self::MAX], // DECIMAL
        [BaseType::NUMERIC, self::MIN, self::MAX], // DECIMAL
        [BaseType::FIXED, self::MIN, self::MAX], // DECIMAL

        // time
        [BaseType::YEAR, self::MIN, self::MAX],
        [BaseType::DATE, self::MIN, self::MAX],
        [BaseType::DATETIME, self::MIN, self::MAX],
        [BaseType::TIME, self::MIN, self::MAX],
        [BaseType::TIMESTAMP, self::MIN, self::MAX],

        // texts
        [BaseType::CHAR, self::MIN, self::MAX],
        [BaseType::VARCHAR, self::MIN, self::MAX],
        [BaseType::TINYTEXT, self::MIN, self::MAX],
        [BaseType::TEXT, self::MIN, self::MAX],
        [BaseType::MEDIUMTEXT, self::MIN, self::MAX],
        [BaseType::LONGTEXT, self::MIN, self::MAX],
        [BaseType::CHARACTER, self::MIN, self::MAX], // CHAR
        [BaseType::NCHAR, self::MIN, self::MAX], // CHAR
        [BaseType::NATIONAL_CHAR, self::MIN, self::MAX], // CHAR
        [BaseType::CHARACTER_VARYING, self::MIN, self::MAX], // VARCHAR
        [BaseType::NVARCHAR, self::MIN, self::MAX], // VARCHAR
        [BaseType::NATIONAL_VARCHAR, self::MIN, self::MAX], // VARCHAR
        [BaseType::LONG, self::MIN, self::MAX], // MEDIUMTEXT
        [BaseType::LONG_VARCHAR, self::MIN, self::MAX], // MEDIUMTEXT

        // binary
        [BaseType::BINARY, self::MIN, self::MAX],
        [BaseType::VARBINARY, self::MIN, self::MAX],
        [BaseType::TINYBLOB, self::MIN, self::MAX],
        [BaseType::BLOB, self::MIN, self::MAX],
        [BaseType::MEDIUMBLOB, self::MIN, self::MAX],
        [BaseType::LONGBLOB, self::MIN, self::MAX],
        [BaseType::CHAR_BYTE, self::MIN, self::MAX], // BINARY
        [BaseType::LONG_VARBINARY, self::MIN, self::MAX], // MEDIUMBLOB

        // sets
        [BaseType::ENUM, self::MIN, self::MAX],
        [BaseType::SET, self::MIN, self::MAX],

        // json
        [BaseType::JSON, self::MIN, self::MAX],

        // geometry
        [BaseType::GEOMETRY, self::MIN, self::MAX],
        [BaseType::POINT, self::MIN, self::MAX],
        [BaseType::LINESTRING, self::MIN, self::MAX],
        [BaseType::POLYGON, self::MIN, self::MAX],
        [BaseType::GEOMETRYCOLLECTION, self::MIN, self::MAX],
        [BaseType::MULTIPOINT, self::MIN, self::MAX],
        [BaseType::MULTILINESTRING, self::MIN, self::MAX],
        [BaseType::MULTIPOLYGON, self::MIN, self::MAX],
    ];

    /** @var list<array{BuiltInFunction::*, int, int, 3?: int}> */
    public array $functions = [
        // comparison
        [BuiltInFunction::COALESCE, self::MIN, self::MAX],
        [BuiltInFunction::GREATEST, self::MIN, self::MAX],
        [BuiltInFunction::INTERVAL, self::MIN, self::MAX],
        [BuiltInFunction::ISNULL, self::MIN, self::MAX],
        [BuiltInFunction::LEAST, self::MIN, self::MAX],
        [BuiltInFunction::STRCMP, self::MIN, self::MAX],

        // flow control
        [BuiltInFunction::IF, self::MIN, self::MAX],
        [BuiltInFunction::IFNULL, self::MIN, self::MAX],
        [BuiltInFunction::NULLIF, self::MIN, self::MAX],

        // type
        [BuiltInFunction::CAST, self::MIN, self::MAX],
        [BuiltInFunction::CONVERT, self::MIN, self::MAX],

        // strings
        [BuiltInFunction::ASCII, self::MIN, self::MAX],
        [BuiltInFunction::BIN, self::MIN, self::MAX],
        [BuiltInFunction::BIT_LENGTH, self::MIN, self::MAX],
        [BuiltInFunction::CHAR, self::MIN, self::MAX],
        [BuiltInFunction::CHAR_LENGTH, self::MIN, self::MAX],
        [BuiltInFunction::CHARACTER_LENGTH, self::MIN, self::MAX],
        [BuiltInFunction::CONCAT, self::MIN, self::MAX],
        [BuiltInFunction::CONCAT_WS, self::MIN, self::MAX],
        [BuiltInFunction::ELT, self::MIN, self::MAX],
        [BuiltInFunction::EXPORT_SET, self::MIN, self::MAX],
        [BuiltInFunction::FIELD, self::MIN, self::MAX],
        [BuiltInFunction::FIND_IN_SET, self::MIN, self::MAX],
        [BuiltInFunction::FORMAT, self::MIN, self::MAX],
        [BuiltInFunction::FROM_BASE64, self::MIN, self::MAX],
        [BuiltInFunction::HEX, self::MIN, self::MAX],
        [BuiltInFunction::INSERT, self::MIN, self::MAX],
        [BuiltInFunction::INSTR, self::MIN, self::MAX],
        [BuiltInFunction::LCASE, self::MIN, self::MAX],
        [BuiltInFunction::LEFT, self::MIN, self::MAX],
        [BuiltInFunction::LENGTH, self::MIN, self::MAX],
        [BuiltInFunction::LOAD_FILE, self::MIN, self::MAX],
        [BuiltInFunction::LOCATE, self::MIN, self::MAX],
        [BuiltInFunction::LOWER, self::MIN, self::MAX],
        [BuiltInFunction::LPAD, self::MIN, self::MAX],
        [BuiltInFunction::LTRIM, self::MIN, self::MAX],
        [BuiltInFunction::MAKE_SET, self::MIN, self::MAX],
        [BuiltInFunction::MID, self::MIN, self::MAX],
        [BuiltInFunction::OCT, self::MIN, self::MAX],
        [BuiltInFunction::OCTET_LENGTH, self::MIN, self::MAX],
        [BuiltInFunction::ORD, self::MIN, self::MAX],
        [BuiltInFunction::POSITION, self::MIN, self::MAX],
        [BuiltInFunction::QUOTE, self::MIN, self::MAX],
        [BuiltInFunction::REGEXP_INSTR, 80000, self::MAX],
        [BuiltInFunction::REGEXP_LIKE, 80000, self::MAX],
        [BuiltInFunction::REGEXP_REPLACE, 80000, self::MAX],
        [BuiltInFunction::REGEXP_SUBSTR, 80000, self::MAX],
        [BuiltInFunction::REPEAT, self::MIN, self::MAX],
        [BuiltInFunction::REPLACE, self::MIN, self::MAX],
        [BuiltInFunction::REVERSE, self::MIN, self::MAX],
        [BuiltInFunction::RIGHT, self::MIN, self::MAX],
        [BuiltInFunction::RPAD, self::MIN, self::MAX],
        [BuiltInFunction::RTRIM, self::MIN, self::MAX],
        [BuiltInFunction::SOUNDEX, self::MIN, self::MAX],
        [BuiltInFunction::SPACE, self::MIN, self::MAX],
        [BuiltInFunction::SUBSTR, self::MIN, self::MAX],
        [BuiltInFunction::SUBSTRING, self::MIN, self::MAX],
        [BuiltInFunction::SUBSTRING_INDEX, self::MIN, self::MAX],
        [BuiltInFunction::TO_BASE64, self::MIN, self::MAX],
        [BuiltInFunction::TRIM, self::MIN, self::MAX],
        [BuiltInFunction::UCASE, self::MIN, self::MAX],
        [BuiltInFunction::UNHEX, self::MIN, self::MAX],
        [BuiltInFunction::UPPER, self::MIN, self::MAX],
        [BuiltInFunction::WEIGHT_STRING, self::MIN, self::MAX],

        // XML
        [BuiltInFunction::ExtractValue, self::MIN, self::MAX],
        [BuiltInFunction::UpdateXML, self::MIN, self::MAX],

        // numeric
        [BuiltInFunction::ABS, self::MIN, self::MAX],
        [BuiltInFunction::ACOS, self::MIN, self::MAX],
        [BuiltInFunction::ASIN, self::MIN, self::MAX],
        [BuiltInFunction::ATAN, self::MIN, self::MAX],
        [BuiltInFunction::ATAN2, self::MIN, self::MAX],
        [BuiltInFunction::BIT_COUNT, self::MIN, self::MAX],
        [BuiltInFunction::CEIL, self::MIN, self::MAX],
        [BuiltInFunction::CEILING, self::MIN, self::MAX],
        [BuiltInFunction::CONV, self::MIN, self::MAX],
        [BuiltInFunction::COS, self::MIN, self::MAX],
        [BuiltInFunction::COT, self::MIN, self::MAX],
        [BuiltInFunction::CRC32, self::MIN, self::MAX],
        [BuiltInFunction::DEGREES, self::MIN, self::MAX],
        [BuiltInFunction::EXP, self::MIN, self::MAX],
        [BuiltInFunction::FLOOR, self::MIN, self::MAX],
        [BuiltInFunction::LN, self::MIN, self::MAX],
        [BuiltInFunction::LOG, self::MIN, self::MAX],
        [BuiltInFunction::LOG10, self::MIN, self::MAX],
        [BuiltInFunction::LOG2, self::MIN, self::MAX],
        [BuiltInFunction::MOD, self::MIN, self::MAX],
        [BuiltInFunction::PI, self::MIN, self::MAX],
        [BuiltInFunction::POW, self::MIN, self::MAX],
        [BuiltInFunction::POWER, self::MIN, self::MAX],
        [BuiltInFunction::RADIANS, self::MIN, self::MAX],
        [BuiltInFunction::RAND, self::MIN, self::MAX],
        [BuiltInFunction::ROUND, self::MIN, self::MAX],
        [BuiltInFunction::SIGN, self::MIN, self::MAX],
        [BuiltInFunction::SIN, self::MIN, self::MAX],
        [BuiltInFunction::SQRT, self::MIN, self::MAX],
        [BuiltInFunction::TAN, self::MIN, self::MAX],
        [BuiltInFunction::TRUNCATE, self::MIN, self::MAX],

        // date/time
        [BuiltInFunction::ADDDATE, self::MIN, self::MAX],
        [BuiltInFunction::ADDTIME, self::MIN, self::MAX],
        [BuiltInFunction::CONVERT_TZ, self::MIN, self::MAX],
        [BuiltInFunction::CURDATE, self::MIN, self::MAX],
        [BuiltInFunction::CURRENT_DATE, self::MIN, self::MAX],
        [BuiltInFunction::CURRENT_ROLE, self::MIN, self::MAX],
        [BuiltInFunction::CURRENT_TIME, self::MIN, self::MAX],
        [BuiltInFunction::CURRENT_TIMESTAMP, self::MIN, self::MAX],
        [BuiltInFunction::CURTIME, self::MIN, self::MAX],
        [BuiltInFunction::DATE, self::MIN, self::MAX],
        [BuiltInFunction::DATEDIFF, self::MIN, self::MAX],
        [BuiltInFunction::DATE_ADD, self::MIN, self::MAX],
        [BuiltInFunction::DATE_FORMAT, self::MIN, self::MAX],
        [BuiltInFunction::DATE_SUB, self::MIN, self::MAX],
        [BuiltInFunction::DAY, self::MIN, self::MAX],
        [BuiltInFunction::DAYNAME, self::MIN, self::MAX],
        [BuiltInFunction::DAYOFMONTH, self::MIN, self::MAX],
        [BuiltInFunction::DAYOFWEEK, self::MIN, self::MAX],
        [BuiltInFunction::DAYOFYEAR, self::MIN, self::MAX],
        [BuiltInFunction::EXTRACT, self::MIN, self::MAX],
        [BuiltInFunction::FROM_DAYS, self::MIN, self::MAX],
        [BuiltInFunction::FROM_UNIXTIME, self::MIN, self::MAX],
        [BuiltInFunction::GET_FORMAT, self::MIN, self::MAX],
        [BuiltInFunction::HOUR, self::MIN, self::MAX],
        [BuiltInFunction::LAST_DAY, self::MIN, self::MAX],
        [BuiltInFunction::LOCALTIME, self::MIN, self::MAX],
        [BuiltInFunction::LOCALTIMESTAMP, self::MIN, self::MAX],
        [BuiltInFunction::MAKEDATE, self::MIN, self::MAX],
        [BuiltInFunction::MAKETIME, self::MIN, self::MAX],
        [BuiltInFunction::MICROSECOND, self::MIN, self::MAX],
        [BuiltInFunction::MINUTE, self::MIN, self::MAX],
        [BuiltInFunction::MONTH, self::MIN, self::MAX],
        [BuiltInFunction::MONTHNAME, self::MIN, self::MAX],
        [BuiltInFunction::NOW, self::MIN, self::MAX],
        [BuiltInFunction::PERIOD_ADD, self::MIN, self::MAX],
        [BuiltInFunction::PERIOD_DIFF, self::MIN, self::MAX],
        [BuiltInFunction::QUARTER, self::MIN, self::MAX],
        [BuiltInFunction::SECOND, self::MIN, self::MAX],
        [BuiltInFunction::SEC_TO_TIME, self::MIN, self::MAX],
        [BuiltInFunction::STR_TO_DATE, self::MIN, self::MAX],
        [BuiltInFunction::SUBDATE, self::MIN, self::MAX],
        [BuiltInFunction::SUBTIME, self::MIN, self::MAX],
        [BuiltInFunction::SYSDATE, self::MIN, self::MAX],
        [BuiltInFunction::TIME, self::MIN, self::MAX],
        [BuiltInFunction::TIMEDIFF, self::MIN, self::MAX],
        [BuiltInFunction::TIMESTAMP, self::MIN, self::MAX],
        [BuiltInFunction::TIMESTAMPADD, self::MIN, self::MAX],
        [BuiltInFunction::TIMESTAMPDIFF, self::MIN, self::MAX],
        [BuiltInFunction::TIME_FORMAT, self::MIN, self::MAX],
        [BuiltInFunction::TIME_TO_SEC, self::MIN, self::MAX],
        [BuiltInFunction::TO_DAYS, self::MIN, self::MAX],
        [BuiltInFunction::TO_SECONDS, self::MIN, self::MAX],
        [BuiltInFunction::UNIX_TIMESTAMP, self::MIN, self::MAX],
        [BuiltInFunction::UTC_DATE, self::MIN, self::MAX],
        [BuiltInFunction::UTC_TIME, self::MIN, self::MAX],
        [BuiltInFunction::UTC_TIMESTAMP, self::MIN, self::MAX],
        [BuiltInFunction::WEEK, self::MIN, self::MAX],
        [BuiltInFunction::WEEKDAY, self::MIN, self::MAX],
        [BuiltInFunction::WEEKOFYEAR, self::MIN, self::MAX],
        [BuiltInFunction::YEAR, self::MIN, self::MAX],
        [BuiltInFunction::YEARWEEK, self::MIN, self::MAX],

        // encryption & compression
        [BuiltInFunction::AES_DECRYPT, self::MIN, self::MAX],
        [BuiltInFunction::AES_ENCRYPT, self::MIN, self::MAX],
        [BuiltInFunction::ASYMMETRIC_DECRYPT, self::MIN, self::MAX],
        [BuiltInFunction::ASYMMETRIC_DERIVE, self::MIN, self::MAX],
        [BuiltInFunction::ASYMMETRIC_ENCRYPT, self::MIN, self::MAX],
        [BuiltInFunction::ASYMMETRIC_SIGN, self::MIN, self::MAX],
        [BuiltInFunction::ASYMMETRIC_VERIFY, self::MIN, self::MAX],
        [BuiltInFunction::COMPRESS, self::MIN, self::MAX],
        [BuiltInFunction::CREATE_ASYMMETRIC_PRIV_KEY, self::MIN, self::MAX],
        [BuiltInFunction::CREATE_ASYMMETRIC_PUB_KEY, self::MIN, self::MAX],
        [BuiltInFunction::CREATE_DH_PARAMETERS, self::MIN, self::MAX],
        [BuiltInFunction::CREATE_DIGEST, self::MIN, self::MAX],
        [BuiltInFunction::DECODE, self::MIN, self::MAX, 50700],
        [BuiltInFunction::DES_DECRYPT, self::MIN, 80000, 50700],
        [BuiltInFunction::DES_ENCRYPT, self::MIN, 80000, 50700],
        [BuiltInFunction::ENCODE, self::MIN, self::MAX, 50700],
        [BuiltInFunction::ENCRYPT, self::MIN, 80000, 50700],
        [BuiltInFunction::MD5, self::MIN, self::MAX],
        [BuiltInFunction::PASSWORD, self::MIN, 80001, 50700],
        [BuiltInFunction::RANDOM_BYTES, 50617, self::MAX],
        [BuiltInFunction::SHA, self::MIN, self::MAX],
        [BuiltInFunction::SHA1, self::MIN, self::MAX],
        [BuiltInFunction::SHA2, self::MIN, self::MAX],
        [BuiltInFunction::UNCOMPRESS, self::MIN, self::MAX],
        [BuiltInFunction::UNCOMPRESSED_LENGTH, self::MIN, self::MAX],
        [BuiltInFunction::VALIDATE_PASSWORD_STRENGTH, self::MIN, self::MAX],

        // information
        [BuiltInFunction::BENCHMARK, self::MIN, self::MAX],
        [BuiltInFunction::CHARSET, self::MIN, self::MAX],
        [BuiltInFunction::COERCIBILITY, self::MIN, self::MAX],
        [BuiltInFunction::COLLATION, self::MIN, self::MAX],
        [BuiltInFunction::CONNECTION_ID, self::MIN, self::MAX],
        [BuiltInFunction::CURRENT_ROLE, 80000, self::MAX],
        [BuiltInFunction::CURRENT_USER, self::MIN, self::MAX],
        [BuiltInFunction::DATABASE, self::MIN, self::MAX],
        [BuiltInFunction::FOUND_ROWS, self::MIN, self::MAX],
        [BuiltInFunction::LAST_INSERT_ID, self::MIN, self::MAX],
        [BuiltInFunction::ROLES_GRAPHML, self::MIN, self::MAX],
        [BuiltInFunction::ROW_COUNT, self::MIN, self::MAX],
        [BuiltInFunction::SCHEMA, self::MIN, self::MAX],
        [BuiltInFunction::SESSION_USER, self::MIN, self::MAX],
        [BuiltInFunction::SYSTEM_USER, self::MIN, self::MAX],
        [BuiltInFunction::USER, self::MIN, self::MAX],
        [BuiltInFunction::VERSION, self::MIN, self::MAX],

        // GTID
        [BuiltInFunction::GTID_SUBSET, self::MIN, self::MAX],
        [BuiltInFunction::GTID_SUBTRACT, self::MIN, self::MAX],
        [BuiltInFunction::WAIT_FOR_EXECUTED_GTID_SET, self::MIN, self::MAX],
        [BuiltInFunction::WAIT_UNTIL_SQL_THREAD_AFTER_GTIDS, 80018, self::MAX],

        // performance_schema
        [BuiltInFunction::FORMAT_BYTES, 80016, self::MAX],
        [BuiltInFunction::FORMAT_PICO_TIME, 80016, self::MAX],
        [BuiltInFunction::PS_CURRENT_THREAD_ID, 80016, self::MAX],
        [BuiltInFunction::PS_THREAD_ID, 80016, self::MAX],

        // misc
        [BuiltInFunction::BIN_TO_UUID, self::MIN, self::MAX],
        [BuiltInFunction::DEFAULT, self::MIN, self::MAX],
        [BuiltInFunction::GET_LOCK, self::MIN, self::MAX],
        [BuiltInFunction::GROUPING, self::MIN, self::MAX],
        [BuiltInFunction::ICU_VERSION, 80000, self::MAX],
        [BuiltInFunction::INET6_ATON, self::MIN, self::MAX],
        [BuiltInFunction::INET6_NTOA, self::MIN, self::MAX],
        [BuiltInFunction::INET_ATON, self::MIN, self::MAX],
        [BuiltInFunction::INET_NTOA, self::MIN, self::MAX],
        [BuiltInFunction::IS_FREE_LOCK, self::MIN, self::MAX],
        [BuiltInFunction::IS_IPV4, self::MIN, self::MAX],
        [BuiltInFunction::IS_IPV4_COMPAT, self::MIN, self::MAX],
        [BuiltInFunction::IS_IPV4_MAPPED, self::MIN, self::MAX],
        [BuiltInFunction::IS_IPV6, self::MIN, self::MAX],
        [BuiltInFunction::IS_USED_LOCK, self::MIN, self::MAX],
        [BuiltInFunction::IS_UUID, self::MIN, self::MAX],
        [BuiltInFunction::MASTER_POS_WAIT, self::MIN, self::MAX, 80026],
        [BuiltInFunction::NAME_CONST, self::MIN, self::MAX],
        [BuiltInFunction::RELEASE_ALL_LOCKS, self::MIN, self::MAX],
        [BuiltInFunction::RELEASE_LOCK, self::MIN, self::MAX],
        [BuiltInFunction::SLEEP, self::MIN, self::MAX],
        [BuiltInFunction::SOURCE_POS_WAIT, 80026, self::MAX],
        [BuiltInFunction::STATEMENT_DIGEST, 80000, self::MAX],
        [BuiltInFunction::STATEMENT_DIGEST_NEXT, 80000, self::MAX],
        [BuiltInFunction::UUID, self::MIN, self::MAX],
        [BuiltInFunction::UUID_SHORT, self::MIN, self::MAX],
        [BuiltInFunction::UUID_TO_BIN, self::MIN, self::MAX],
        [BuiltInFunction::VALUES, self::MIN, self::MAX],

        // aggregate functions
        [BuiltInFunction::ANY_VALUE, self::MIN, self::MAX],
        [BuiltInFunction::AVG, self::MIN, self::MAX],
        [BuiltInFunction::BIT_AND, self::MIN, self::MAX],
        [BuiltInFunction::BIT_OR, self::MIN, self::MAX],
        [BuiltInFunction::BIT_XOR, self::MIN, self::MAX],
        [BuiltInFunction::COUNT, self::MIN, self::MAX],
        [BuiltInFunction::COUNT_DISTINCT, self::MIN, self::MAX],
        [BuiltInFunction::GROUP_CONCAT, self::MIN, self::MAX],
        [BuiltInFunction::JSON_ARRAYAGG, 50722, self::MAX],
        [BuiltInFunction::JSON_OBJECTAGG, 50722, self::MAX],
        [BuiltInFunction::MAX, self::MIN, self::MAX],
        [BuiltInFunction::MIN, self::MIN, self::MAX],
        [BuiltInFunction::STD, self::MIN, self::MAX],
        [BuiltInFunction::STDDEV, self::MIN, self::MAX],
        [BuiltInFunction::STDDEV_POP, self::MIN, self::MAX],
        [BuiltInFunction::STDDEV_SAMP, self::MIN, self::MAX],
        [BuiltInFunction::SUM, self::MIN, self::MAX],
        [BuiltInFunction::VAR_POP, self::MIN, self::MAX],
        [BuiltInFunction::VAR_SAMP, self::MIN, self::MAX],
        [BuiltInFunction::VARIANCE, self::MIN, self::MAX],

        // window functions
        [BuiltInFunction::CUME_DIST, self::MIN, self::MAX],
        [BuiltInFunction::DENSE_RANK, self::MIN, self::MAX],
        [BuiltInFunction::FIRST_VALUE, self::MIN, self::MAX],
        [BuiltInFunction::LAG, self::MIN, self::MAX],
        [BuiltInFunction::LAST_VALUE, self::MIN, self::MAX],
        [BuiltInFunction::LEAD, self::MIN, self::MAX],
        [BuiltInFunction::NTH_VALUE, self::MIN, self::MAX],
        [BuiltInFunction::NTILE, self::MIN, self::MAX],
        [BuiltInFunction::PERCENT_RANK, self::MIN, self::MAX],
        [BuiltInFunction::RANK, self::MIN, self::MAX],
        [BuiltInFunction::ROW_NUMBER, self::MIN, self::MAX],

        // JSON
        [BuiltInFunction::JSON_APPEND, 50700, 80000, 50700],
        [BuiltInFunction::JSON_ARRAY, 50700, self::MAX],
        [BuiltInFunction::JSON_ARRAY_APPEND, 50709, self::MAX],
        [BuiltInFunction::JSON_ARRAY_INSERT, 50700, self::MAX],
        [BuiltInFunction::JSON_CONTAINS, 50700, self::MAX],
        [BuiltInFunction::JSON_CONTAINS_PATH, 50700, self::MAX],
        [BuiltInFunction::JSON_DEPTH, 50700, self::MAX],
        [BuiltInFunction::JSON_EXTRACT, 50700, self::MAX],
        [BuiltInFunction::JSON_INSERT, 50700, self::MAX],
        [BuiltInFunction::JSON_KEYS, 50700, self::MAX],
        [BuiltInFunction::JSON_LENGTH, 50700, self::MAX],
        [BuiltInFunction::JSON_MERGE, 50700, self::MAX, 50722],
        [BuiltInFunction::JSON_MERGE_PATCH, 50722, self::MAX],
        [BuiltInFunction::JSON_MERGE_PRESERVE, 50722, self::MAX],
        [BuiltInFunction::JSON_OBJECT, 50700, self::MAX],
        [BuiltInFunction::JSON_OVERLAPS, 80017, self::MAX],
        [BuiltInFunction::JSON_PRETTY, 50722, self::MAX],
        [BuiltInFunction::JSON_QUOTE, 50700, self::MAX],
        [BuiltInFunction::JSON_REMOVE, 50700, self::MAX],
        [BuiltInFunction::JSON_REPLACE, 50700, self::MAX],
        [BuiltInFunction::JSON_SCHEMA_VALID, 80017, self::MAX],
        [BuiltInFunction::JSON_SCHEMA_VALIDATION_REPORT, 80017, self::MAX],
        [BuiltInFunction::JSON_SEARCH, 50700, self::MAX],
        [BuiltInFunction::JSON_SET, 50700, self::MAX],
        [BuiltInFunction::JSON_STORAGE_FREE, 80000, self::MAX],
        [BuiltInFunction::JSON_STORAGE_SIZE, 50722, self::MAX],
        [BuiltInFunction::JSON_TABLE, 80000, self::MAX],
        [BuiltInFunction::JSON_TYPE, 50700, self::MAX],
        [BuiltInFunction::JSON_UNQUOTE, 50700, self::MAX],
        [BuiltInFunction::JSON_VALID, 50700, self::MAX],
        [BuiltInFunction::JSON_VALUE, 80021, self::MAX],

        // spatial
        [BuiltInFunction::GeometryCollection, self::MIN, self::MAX],
        [BuiltInFunction::LineString, self::MIN, self::MAX],
        [BuiltInFunction::MBRContains, self::MIN, self::MAX],
        [BuiltInFunction::MBRCoveredBy, self::MIN, self::MAX],
        [BuiltInFunction::MBRCovers, self::MIN, self::MAX],
        [BuiltInFunction::MBRDisjoint, self::MIN, self::MAX],
        [BuiltInFunction::MBREquals, self::MIN, self::MAX],
        [BuiltInFunction::MBRIntersects, self::MIN, self::MAX],
        [BuiltInFunction::MBROverlaps, self::MIN, self::MAX],
        [BuiltInFunction::MBRTouches, self::MIN, self::MAX],
        [BuiltInFunction::MBRWithin, self::MIN, self::MAX],
        [BuiltInFunction::MultiLineString, self::MIN, self::MAX],
        [BuiltInFunction::MultiPoint, self::MIN, self::MAX],
        [BuiltInFunction::MultiPolygon, self::MIN, self::MAX],
        [BuiltInFunction::Point, self::MIN, self::MAX],
        [BuiltInFunction::Polygon, self::MIN, self::MAX],
        [BuiltInFunction::ST_Area, self::MIN, self::MAX],
        [BuiltInFunction::ST_AsBinary, self::MIN, self::MAX],
        [BuiltInFunction::ST_AsGeoJSON, self::MIN, self::MAX],
        [BuiltInFunction::ST_AsText, self::MIN, self::MAX],
        [BuiltInFunction::ST_AsWKT, self::MIN, self::MAX],
        [BuiltInFunction::ST_Buffer, self::MIN, self::MAX],
        [BuiltInFunction::ST_Buffer_Strategy, self::MIN, self::MAX],
        [BuiltInFunction::ST_Centroid, self::MIN, self::MAX],
        [BuiltInFunction::ST_Collect, 80024, self::MAX],
        [BuiltInFunction::ST_Contains, self::MIN, self::MAX],
        [BuiltInFunction::ST_ConvexHull, self::MIN, self::MAX],
        [BuiltInFunction::ST_Crosses, self::MIN, self::MAX],
        [BuiltInFunction::ST_Difference, self::MIN, self::MAX],
        [BuiltInFunction::ST_Dimension, self::MIN, self::MAX],
        [BuiltInFunction::ST_Disjoint, self::MIN, self::MAX],
        [BuiltInFunction::ST_Distance, self::MIN, self::MAX],
        [BuiltInFunction::ST_Distance_Sphere, self::MIN, self::MAX],
        [BuiltInFunction::ST_EndPoint, self::MIN, self::MAX],
        [BuiltInFunction::ST_Envelope, self::MIN, self::MAX],
        [BuiltInFunction::ST_Equals, self::MIN, self::MAX],
        [BuiltInFunction::ST_ExteriorRing, self::MIN, self::MAX],
        [BuiltInFunction::ST_FrechetDistance, 80023, self::MAX],
        [BuiltInFunction::ST_GeoHash, self::MIN, self::MAX],
        [BuiltInFunction::ST_GeomCollFromText, self::MIN, self::MAX],
        [BuiltInFunction::ST_GeomCollFromTxt, self::MIN, self::MAX],
        [BuiltInFunction::ST_GeomCollFromWKB, self::MIN, self::MAX],
        [BuiltInFunction::ST_GeomFromGeoJSON, self::MIN, self::MAX],
        [BuiltInFunction::ST_GeomFromText, self::MIN, self::MAX],
        [BuiltInFunction::ST_GeomFromWKB, self::MIN, self::MAX],
        [BuiltInFunction::ST_GeometryCollectionFromText, self::MIN, self::MAX],
        [BuiltInFunction::ST_GeometryCollectionFromWKB, self::MIN, self::MAX],
        [BuiltInFunction::ST_GeometryFromText, self::MIN, self::MAX],
        [BuiltInFunction::ST_GeometryFromWKB, self::MIN, self::MAX],
        [BuiltInFunction::ST_GeometryN, self::MIN, self::MAX],
        [BuiltInFunction::ST_GeometryType, self::MIN, self::MAX],
        [BuiltInFunction::ST_HausdorffDistance, 80023, self::MAX],
        [BuiltInFunction::ST_InteriorRingN, self::MIN, self::MAX],
        [BuiltInFunction::ST_Intersection, self::MIN, self::MAX],
        [BuiltInFunction::ST_Intersects, self::MIN, self::MAX],
        [BuiltInFunction::ST_IsClosed, self::MIN, self::MAX],
        [BuiltInFunction::ST_IsEmpty, self::MIN, self::MAX],
        [BuiltInFunction::ST_IsSimple, self::MIN, self::MAX],
        [BuiltInFunction::ST_IsValid, self::MIN, self::MAX],
        [BuiltInFunction::ST_LatFromGeoHash, self::MIN, self::MAX],
        [BuiltInFunction::ST_Latitude, 80012, self::MAX],
        [BuiltInFunction::ST_Length, self::MIN, self::MAX],
        [BuiltInFunction::ST_LineFromText, self::MIN, self::MAX],
        [BuiltInFunction::ST_LineFromWKB, self::MIN, self::MAX],
        [BuiltInFunction::ST_LineInterpolatePoint, 80024, self::MAX],
        [BuiltInFunction::ST_LineInterpolatePoints, 80024, self::MAX],
        [BuiltInFunction::ST_LineStringFromText, self::MIN, self::MAX],
        [BuiltInFunction::ST_LineStringFromWKB, self::MIN, self::MAX],
        [BuiltInFunction::ST_LongFromGeoHash, self::MIN, self::MAX],
        [BuiltInFunction::ST_Longitude, 80012, self::MAX],
        [BuiltInFunction::ST_MLineFromText, self::MIN, self::MAX],
        [BuiltInFunction::ST_MLineFromWKB, self::MIN, self::MAX],
        [BuiltInFunction::ST_MPointFromText, self::MIN, self::MAX],
        [BuiltInFunction::ST_MPointFromWKB, self::MIN, self::MAX],
        [BuiltInFunction::ST_MPolyFromText, self::MIN, self::MAX],
        [BuiltInFunction::ST_MPolyFromWKB, self::MIN, self::MAX],
        [BuiltInFunction::ST_MakeEnvelope, self::MIN, self::MAX],
        [BuiltInFunction::ST_MultiLineStringFromText, self::MIN, self::MAX],
        [BuiltInFunction::ST_MultiLineStringFromWKB, self::MIN, self::MAX],
        [BuiltInFunction::ST_MultiPointFromText, self::MIN, self::MAX],
        [BuiltInFunction::ST_MultiPointFromWKB, self::MIN, self::MAX],
        [BuiltInFunction::ST_MultiPolygonFromText, self::MIN, self::MAX],
        [BuiltInFunction::ST_MultiPolygonFromWKB, self::MIN, self::MAX],
        [BuiltInFunction::ST_NumGeometries, self::MIN, self::MAX],
        [BuiltInFunction::ST_NumInteriorRing, self::MIN, self::MAX],
        [BuiltInFunction::ST_NumInteriorRings, self::MIN, self::MAX],
        [BuiltInFunction::ST_NumPoints, self::MIN, self::MAX],
        [BuiltInFunction::ST_Overlaps, self::MIN, self::MAX],
        [BuiltInFunction::ST_PointAtDistance, 80024, self::MAX],
        [BuiltInFunction::ST_PointFromGeoHash, self::MIN, self::MAX],
        [BuiltInFunction::ST_PointFromText, self::MIN, self::MAX],
        [BuiltInFunction::ST_PointFromWKB, self::MIN, self::MAX],
        [BuiltInFunction::ST_PointN, self::MIN, self::MAX],
        [BuiltInFunction::ST_PolyFromText, self::MIN, self::MAX],
        [BuiltInFunction::ST_PolyFromWKB, self::MIN, self::MAX],
        [BuiltInFunction::ST_PolygonFromText, self::MIN, self::MAX],
        [BuiltInFunction::ST_PolygonFromWKB, self::MIN, self::MAX],
        [BuiltInFunction::ST_SRID, self::MIN, self::MAX],
        [BuiltInFunction::ST_Simplify, self::MIN, self::MAX],
        [BuiltInFunction::ST_StartPoint, self::MIN, self::MAX],
        [BuiltInFunction::ST_SwapXY, self::MIN, self::MAX],
        [BuiltInFunction::ST_SymDifference, self::MIN, self::MAX],
        [BuiltInFunction::ST_Touches, self::MIN, self::MAX],
        [BuiltInFunction::ST_Transform, 80013, self::MAX],
        [BuiltInFunction::ST_Union, self::MIN, self::MAX],
        [BuiltInFunction::ST_Validate, self::MIN, self::MAX],
        [BuiltInFunction::ST_Within, self::MIN, self::MAX],
        [BuiltInFunction::ST_X, self::MIN, self::MAX],
        [BuiltInFunction::ST_Y, self::MIN, self::MAX],

        // old spatial
        [BuiltInFunction::Area, self::MIN, 80000, 50700],
        [BuiltInFunction::AsBinary, self::MIN, 80000, 50700],
        [BuiltInFunction::AsText, self::MIN, 80000, 50700],
        [BuiltInFunction::AsWKB, self::MIN, 80000, 50700],
        [BuiltInFunction::AsWKT, self::MIN, 80000, 50700],
        [BuiltInFunction::Buffer, self::MIN, 80000, 50700],
        [BuiltInFunction::Centroid, self::MIN, 80000, 50700],
        [BuiltInFunction::Contains, self::MIN, 80000, 50700],
        [BuiltInFunction::ConvexHull, self::MIN, 80000, 50700],
        [BuiltInFunction::Crosses, self::MIN, 80000, 50700],
        [BuiltInFunction::Dimension, self::MIN, 80000, 50700],
        [BuiltInFunction::Disjoint, self::MIN, 80000, 50700],
        [BuiltInFunction::Distance, self::MIN, 80000, 50700],
        [BuiltInFunction::EndPoint, self::MIN, 80000, 50700],
        [BuiltInFunction::Envelope, self::MIN, 80000, 50700],
        [BuiltInFunction::Equals, self::MIN, 80000, 50700],
        [BuiltInFunction::ExteriorRing, self::MIN, 80000, 50700],
        [BuiltInFunction::GeomCollFromText, self::MIN, 80000, 50700],
        [BuiltInFunction::GeomCollFromWKB, self::MIN, 80000, 50700],
        [BuiltInFunction::GeometryCollectionFromText, self::MIN, 80000, 50700],
        [BuiltInFunction::GeometryCollectionFromWKB, self::MIN, 80000, 50700],
        [BuiltInFunction::GeometryFromText, self::MIN, 80000, 50700],
        [BuiltInFunction::GeometryFromWKB, self::MIN, 80000, 50700],
        [BuiltInFunction::GeometryN, self::MIN, 80000, 50700],
        [BuiltInFunction::GeometryType, self::MIN, 80000, 50700],
        [BuiltInFunction::GeomFromText, self::MIN, 80000, 50700],
        [BuiltInFunction::GeomFromWKB, self::MIN, 80000, 50700],
        [BuiltInFunction::GLength, self::MIN, 80000, 50700],
        [BuiltInFunction::InteriorRingN, self::MIN, 80000, 50700],
        [BuiltInFunction::Intersects, self::MIN, 80000, 50700],
        [BuiltInFunction::IsClosed, self::MIN, 80000, 50700],
        [BuiltInFunction::IsEmpty, self::MIN, 80000, 50700],
        [BuiltInFunction::IsSimple, self::MIN, 80000, 50700],
        [BuiltInFunction::LineFromText, self::MIN, 80000, 50700],
        [BuiltInFunction::LineFromWKB, self::MIN, 80000, 50700],
        [BuiltInFunction::LineStringFromText, self::MIN, 80000, 50700],
        [BuiltInFunction::LineStringFromWKB, self::MIN, 80000, 50700],
        [BuiltInFunction::MLineFromText, self::MIN, 80000, 50700],
        [BuiltInFunction::MLineFromWKB, self::MIN, 80000, 50700],
        [BuiltInFunction::MPointFromText, self::MIN, 80000, 50700],
        [BuiltInFunction::MPointFromWKB, self::MIN, 80000, 50700],
        [BuiltInFunction::MPolyFromText, self::MIN, 80000, 50700],
        [BuiltInFunction::MPolyFromWKB, self::MIN, 80000, 50700],
        [BuiltInFunction::MultiLineStringFromText, self::MIN, 80000, 50700],
        [BuiltInFunction::MultiLineStringFromWKB, self::MIN, 80000, 50700],
        [BuiltInFunction::MultiPointFromText, self::MIN, 80000, 50700],
        [BuiltInFunction::MultiPointFromWKB, self::MIN, 80000, 50700],
        [BuiltInFunction::MultiPolygonFromText, self::MIN, 80000, 50700],
        [BuiltInFunction::MultiPolygonFromWKB, self::MIN, 80000, 50700],
        [BuiltInFunction::NumGeometries, self::MIN, 80000, 50700],
        [BuiltInFunction::NumInteriorRings, self::MIN, 80000, 50700],
        [BuiltInFunction::NumPoints, self::MIN, 80000, 50700],
        [BuiltInFunction::Overlaps, self::MIN, 80000, 50700],
        [BuiltInFunction::PointFromText, self::MIN, 80000, 50700],
        [BuiltInFunction::PointFromWKB, self::MIN, 80000, 50700],
        [BuiltInFunction::PointN, self::MIN, 80000, 50700],
        [BuiltInFunction::PolyFromText, self::MIN, 80000, 50700],
        [BuiltInFunction::PolyFromWKB, self::MIN, 80000, 50700],
        [BuiltInFunction::PolygonFromText, self::MIN, 80000, 50700],
        [BuiltInFunction::PolygonFromWKB, self::MIN, 80000, 50700],
        [BuiltInFunction::SRID, self::MIN, 80000, 50700],
        [BuiltInFunction::StartPoint, self::MIN, 80000, 50700],
        [BuiltInFunction::Touches, self::MIN, 80000, 50700],
        [BuiltInFunction::Within, self::MIN, 80000, 50700],
        [BuiltInFunction::X, self::MIN, 80000, 50700],
        [BuiltInFunction::Y, self::MIN, 80000, 50700],
    ];

    /** @var list<array{MysqlVariable::*, int, int}> */
    public array $variables = [
        // https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html
        [MysqlVariable::ACTIVATE_ALL_ROLES_ON_LOGIN, self::MIN, self::MAX],
        [MysqlVariable::ADMIN_ADDRESS, 80014, self::MAX],
        [MysqlVariable::ADMIN_PORT, 80014, self::MAX],
        [MysqlVariable::ADMIN_SSL_CA, 80021, self::MAX],
        [MysqlVariable::ADMIN_SSL_CAPATH, 80021, self::MAX],
        [MysqlVariable::ADMIN_SSL_CERT, 80021, self::MAX],
        [MysqlVariable::ADMIN_SSL_CIPHER, 80021, self::MAX],
        [MysqlVariable::ADMIN_SSL_CRL, 80021, self::MAX],
        [MysqlVariable::ADMIN_SSL_CRLPATH, 80021, self::MAX],
        [MysqlVariable::ADMIN_SSL_KEY, 80021, self::MAX],
        [MysqlVariable::ADMIN_TLS_CIPHERSUITES, 80021, self::MAX],
        [MysqlVariable::ADMIN_TLS_VERSION, 80021, self::MAX],
        [MysqlVariable::AUTHENTICATION_POLICY, 80027, self::MAX],
        [MysqlVariable::AUTHENTICATION_WINDOWS_LOG_LEVEL, self::MIN, self::MAX],
        [MysqlVariable::AUTHENTICATION_WINDOWS_USE_PRINCIPAL_NAME, self::MIN, self::MAX],
        [MysqlVariable::AUTOCOMMIT, self::MIN, self::MAX],
        [MysqlVariable::AUTOMATIC_SP_PRIVILEGES, self::MIN, self::MAX],
        [MysqlVariable::AUTO_GENERATE_CERTS, self::MIN, self::MAX],
        [MysqlVariable::AVOID_TEMPORAL_UPGRADE, 50624, self::MAX],
        [MysqlVariable::BACK_LOG, self::MIN, self::MAX],
        [MysqlVariable::BASEDIR, self::MIN, self::MAX],
        [MysqlVariable::BIG_TABLES, self::MIN, self::MAX],
        [MysqlVariable::BIND_ADDRESS, self::MIN, self::MAX],
        [MysqlVariable::BLOCK_ENCRYPTION_MODE, 50617, self::MAX],
        [MysqlVariable::BUILD_ID, 80031, self::MAX],
        [MysqlVariable::BULK_INSERT_BUFFER_SIZE, self::MIN, self::MAX],
        [MysqlVariable::CACHING_SHA2_PASSWORD_DIGEST_ROUNDS, 80024, self::MAX],
        [MysqlVariable::CACHING_SHA2_PASSWORD_AUTO_GENERATE_RSA_KEYS, self::MIN, self::MAX],
        [MysqlVariable::CACHING_SHA2_PASSWORD_PRIVATE_KEY_PATH, self::MIN, self::MAX],
        [MysqlVariable::CACHING_SHA2_PASSWORD_PUBLIC_KEY_PATH, self::MIN, self::MAX],
        [MysqlVariable::CHARACTER_SET_CLIENT, self::MIN, self::MAX],
        [MysqlVariable::CHARACTER_SET_CONNECTION, self::MIN, self::MAX],
        [MysqlVariable::CHARACTER_SET_DATABASE, self::MIN, self::MAX],
        [MysqlVariable::CHARACTER_SET_FILESYSTEM, self::MIN, self::MAX],
        [MysqlVariable::CHARACTER_SET_RESULTS, self::MIN, self::MAX],
        [MysqlVariable::CHARACTER_SET_SERVER, self::MIN, self::MAX],
        [MysqlVariable::CHARACTER_SET_SYSTEM, self::MIN, self::MAX],
        [MysqlVariable::CHARACTER_SETS_DIR, self::MIN, self::MAX],
        [MysqlVariable::CHECK_PROXY_USERS, self::MIN, self::MAX],
        [MysqlVariable::COLLATION_CONNECTION, self::MIN, self::MAX],
        [MysqlVariable::COLLATION_DATABASE, self::MIN, self::MAX],
        [MysqlVariable::COLLATION_SERVER, self::MIN, self::MAX],
        [MysqlVariable::COMPLETION_TYPE, self::MIN, self::MAX],
        [MysqlVariable::CONCURRENT_INSERT, self::MIN, self::MAX],
        [MysqlVariable::CONNECT_TIMEOUT, self::MIN, self::MAX],
        [MysqlVariable::CONNECTION_MEMORY_CHUNK_SIZE, 80028, self::MAX],
        [MysqlVariable::CONNECTION_MEMORY_LIMIT, 80028, self::MAX],
        [MysqlVariable::CORE_FILE, self::MIN, self::MAX],
        [MysqlVariable::CREATE_ADMIN_LISTENER_THREAD, 80014, self::MAX],
        [MysqlVariable::CTE_MAX_RECURSION_DEPTH, self::MIN, self::MAX],
        [MysqlVariable::DATADIR, self::MIN, self::MAX],
        [MysqlVariable::DEBUG, self::MIN, self::MAX],
        [MysqlVariable::DEBUG_SYNC, self::MIN, self::MAX],
        [MysqlVariable::DEFAULT_AUTHENTICATION_PLUGIN, 80027, self::MAX],
        [MysqlVariable::DEFAULT_COLLATION_FOR_UTF8MB4, self::MIN, self::MAX],
        [MysqlVariable::DEFAULT_PASSWORD_LIFETIME, self::MIN, self::MAX],
        [MysqlVariable::DEFAULT_STORAGE_ENGINE, self::MIN, self::MAX],
        [MysqlVariable::DEFAULT_TABLE_ENCRYPTION, 80016, self::MAX],
        [MysqlVariable::DEFAULT_TMP_STORAGE_ENGINE, self::MIN, self::MAX],
        [MysqlVariable::DEFAULT_WEEK_FORMAT, self::MIN, self::MAX],
        [MysqlVariable::DELAY_KEY_WRITE, self::MIN, self::MAX],
        [MysqlVariable::DELAYED_INSERT_LIMIT, self::MIN, self::MAX],
        [MysqlVariable::DELAYED_INSERT_TIMEOUT, self::MIN, self::MAX],
        [MysqlVariable::DELAYED_QUEUE_SIZE, self::MIN, self::MAX],
        [MysqlVariable::DISABLED_STORAGE_ENGINES, self::MIN, self::MAX],
        [MysqlVariable::DISCONNECT_ON_EXPIRED_PASSWORD, self::MIN, self::MAX],
        [MysqlVariable::DIV_PRECISION_INCREMENT, self::MIN, self::MAX],
        [MysqlVariable::DRAGNET__LOG_ERROR_FILTER_RULES, self::MIN, self::MAX],
        [MysqlVariable::ENTERPRISE_ENCRYPTION__MAXIMUM_RSA_KEY_SIZE, 80030, self::MAX],
        [MysqlVariable::ENTERPRISE_ENCRYPTION__RSA_SUPPORT_LEGACY_PADDING, 80030, self::MAX],
        [MysqlVariable::END_MARKERS_IN_JSON, self::MIN, self::MAX],
        [MysqlVariable::EQ_RANGE_INDEX_DIVE_LIMIT, self::MIN, self::MAX],
        [MysqlVariable::ERROR_COUNT, self::MIN, self::MAX],
        [MysqlVariable::EVENT_SCHEDULER, self::MIN, self::MAX],
        [MysqlVariable::EXPLAIN_FORMAT, 80032, self::MAX],
        [MysqlVariable::EXPLICIT_DEFAULTS_FOR_TIMESTAMP, self::MIN, self::MAX],
        [MysqlVariable::EXTERNAL_USER, self::MIN, self::MAX],
        [MysqlVariable::FLUSH, self::MIN, self::MAX],
        [MysqlVariable::FLUSH_TIME, self::MIN, self::MAX],
        [MysqlVariable::FOREIGN_KEY_CHECKS, self::MIN, self::MAX],
        [MysqlVariable::FT_BOOLEAN_SYNTAX, self::MIN, self::MAX],
        [MysqlVariable::FT_MAX_WORD_LEN, self::MIN, self::MAX],
        [MysqlVariable::FT_MIN_WORD_LEN, self::MIN, self::MAX],
        [MysqlVariable::FT_QUERY_EXPANSION_LIMIT, self::MIN, self::MAX],
        [MysqlVariable::FT_STOPWORD_FILE, self::MIN, self::MAX],
        [MysqlVariable::GENERAL_LOG, self::MIN, self::MAX],
        [MysqlVariable::GENERAL_LOG_FILE, self::MIN, self::MAX],
        [MysqlVariable::GENERATED_RANDOM_PASSWORD_LENGTH, 80018, self::MAX],
        [MysqlVariable::GLOBAL_CONNECTION_MEMORY_LIMIT, 80028, self::MAX],
        [MysqlVariable::GLOBAL_CONNECTION_MEMORY_TRACKING, 80028, self::MAX],
        [MysqlVariable::GROUP_CONCAT_MAX_LEN, self::MIN, self::MAX],
        [MysqlVariable::HAVE_COMPRESS, self::MIN, self::MAX],
        [MysqlVariable::HAVE_CRYPT, self::MIN, self::MAX],
        [MysqlVariable::HAVE_DYNAMIC_LOADING, self::MIN, self::MAX],
        [MysqlVariable::HAVE_GEOMETRY, self::MIN, self::MAX],
        [MysqlVariable::HAVE_OPENSSL, self::MIN, self::MAX],
        [MysqlVariable::HAVE_PROFILING, self::MIN, self::MAX],
        [MysqlVariable::HAVE_QUERY_CACHE, self::MIN, self::MAX],
        [MysqlVariable::HAVE_RTREE_KEYS, self::MIN, self::MAX],
        [MysqlVariable::HAVE_SSL, self::MIN, self::MAX],
        [MysqlVariable::HAVE_STATEMENT_TIMEOUT, self::MIN, self::MAX],
        [MysqlVariable::HAVE_SYMLINK, self::MIN, self::MAX],
        [MysqlVariable::HISTOGRAM_GENERATION_MAX_MEM_SIZE, self::MIN, self::MAX],
        [MysqlVariable::HOST_CACHE_SIZE, self::MIN, self::MAX],
        [MysqlVariable::HOSTNAME, self::MIN, self::MAX],
        [MysqlVariable::IDENTITY, self::MIN, self::MAX],
        [MysqlVariable::IGNORE_DB_DIRS, self::MIN, 80000],
        [MysqlVariable::INIT_CONNECT, self::MIN, self::MAX],
        [MysqlVariable::INFORMATION_SCHEMA_STATS_EXPIRY, self::MIN, self::MAX],
        [MysqlVariable::INIT_FILE, self::MIN, self::MAX],
        [MysqlVariable::INSERT_ID, self::MIN, self::MAX],
        [MysqlVariable::INTERACTIVE_TIMEOUT, self::MIN, self::MAX],
        [MysqlVariable::INTERNAL_TMP_DISK_STORAGE_ENGINE, self::MIN, 80016],
        [MysqlVariable::INTERNAL_TMP_MEM_STORAGE_ENGINE, self::MIN, self::MAX],
        [MysqlVariable::JOIN_BUFFER_SIZE, self::MIN, self::MAX],
        [MysqlVariable::KEEP_FILES_ON_CREATE, self::MIN, self::MAX],
        [MysqlVariable::KEY_BUFFER_SIZE, self::MIN, self::MAX],
        [MysqlVariable::KEY_CACHE_AGE_THRESHOLD, self::MIN, self::MAX],
        [MysqlVariable::KEY_CACHE_BLOCK_SIZE, self::MIN, self::MAX],
        [MysqlVariable::KEY_CACHE_DIVISION_LIMIT, self::MIN, self::MAX],
        [MysqlVariable::LARGE_FILES_SUPPORT, self::MIN, self::MAX],
        [MysqlVariable::LARGE_PAGES, self::MIN, self::MAX],
        [MysqlVariable::LARGE_PAGE_SIZE, self::MIN, self::MAX],
        [MysqlVariable::LAST_INSERT_ID, self::MIN, self::MAX],
        [MysqlVariable::LC_MESSAGES, self::MIN, self::MAX],
        [MysqlVariable::LC_MESSAGES_DIR, self::MIN, self::MAX],
        [MysqlVariable::LC_TIME_NAMES, self::MIN, self::MAX],
        [MysqlVariable::LICENSE, self::MIN, self::MAX],
        [MysqlVariable::LOCAL_INFILE, self::MIN, self::MAX],
        [MysqlVariable::LOCK_WAIT_TIMEOUT, self::MIN, self::MAX],
        [MysqlVariable::LOCKED_IN_MEMORY, self::MIN, self::MAX],
        [MysqlVariable::LOG_ERROR, self::MIN, self::MAX],
        [MysqlVariable::LOG_ERROR_SERVICES, self::MIN, self::MAX],
        [MysqlVariable::LOG_ERROR_SUPPRESSION_LIST, 80013, self::MAX],
        [MysqlVariable::LOG_ERROR_VERBOSITY, self::MIN, self::MAX],
        [MysqlVariable::LOG_OUTPUT, self::MIN, self::MAX],
        [MysqlVariable::LOG_QUERIES_NOT_USING_INDEXES, self::MIN, self::MAX],
        [MysqlVariable::LOG_RAW, self::MIN, self::MAX],
        [MysqlVariable::LOG_SLOW_ADMIN_STATEMENTS, 50611, self::MAX],
        [MysqlVariable::LOG_SLOW_EXTRA, 80014, self::MAX],
        [MysqlVariable::LOG_SYSLOG, self::MIN, 80013],
        [MysqlVariable::LOG_SYSLOG_FACILITY, self::MIN, 80013],
        [MysqlVariable::LOG_SYSLOG_INCLUDE_PID, self::MIN, 80013],
        [MysqlVariable::LOG_SYSLOG_TAG, self::MIN, 80013],
        [MysqlVariable::LOG_TIMESTAMPS, self::MIN, self::MAX],
        [MysqlVariable::LOG_THROTTLE_QUERIES_NOT_USING_INDEXES, self::MIN, self::MAX],
        [MysqlVariable::LONG_QUERY_TIME, self::MIN, self::MAX],
        [MysqlVariable::LOW_PRIORITY_UPDATES, self::MIN, self::MAX],
        [MysqlVariable::LOWER_CASE_FILE_SYSTEM, self::MIN, self::MAX],
        [MysqlVariable::LOWER_CASE_TABLE_NAMES, self::MIN, self::MAX],
        [MysqlVariable::MANDATORY_ROLES, self::MIN, self::MAX],
        [MysqlVariable::MAX_ALLOWED_PACKET, self::MIN, self::MAX],
        [MysqlVariable::MAX_CONNECT_ERRORS, self::MIN, self::MAX],
        [MysqlVariable::MAX_CONNECTIONS, self::MIN, self::MAX],
        [MysqlVariable::MAX_DELAYED_THREADS, self::MIN, self::MAX],
        [MysqlVariable::MAX_DIGEST_LENGTH, 50624, self::MAX],
        [MysqlVariable::MAX_ERROR_COUNT, self::MIN, self::MAX],
        [MysqlVariable::MAX_EXECUTION_TIME, self::MIN, self::MAX],
        [MysqlVariable::MAX_HEAP_TABLE_SIZE, self::MIN, self::MAX],
        [MysqlVariable::MAX_INSERT_DELAYED_THREADS, self::MIN, self::MAX],
        [MysqlVariable::MAX_JOIN_SIZE, self::MIN, self::MAX],
        [MysqlVariable::MAX_LENGTH_FOR_SORT_DATA, self::MIN, self::MAX],
        [MysqlVariable::MAX_POINTS_IN_GEOMETRY, self::MIN, self::MAX],
        [MysqlVariable::MAX_PREPARED_STMT_COUNT, self::MIN, self::MAX],
        [MysqlVariable::MAX_SEEKS_FOR_KEY, self::MIN, self::MAX],
        [MysqlVariable::MAX_SORT_LENGTH, self::MIN, self::MAX],
        [MysqlVariable::MAX_SP_RECURSION_DEPTH, self::MIN, self::MAX],
        [MysqlVariable::MAX_USER_CONNECTIONS, self::MIN, self::MAX],
        [MysqlVariable::MAX_WRITE_LOCK_COUNT, self::MIN, self::MAX],
        [MysqlVariable::MECAB_RC_FILE, self::MIN, self::MAX],
        [MysqlVariable::METADATA_LOCKS_CACHE_SIZE, self::MIN, 80013],
        [MysqlVariable::METADATA_LOCKS_HASH_INSTANCES, self::MIN, 80013],
        [MysqlVariable::MIN_EXAMINED_ROW_LIMIT, self::MIN, self::MAX],
        [MysqlVariable::MYISAM_DATA_POINTER_SIZE, self::MIN, self::MAX],
        [MysqlVariable::MYISAM_MAX_SORT_FILE_SIZE, self::MIN, self::MAX],
        [MysqlVariable::MYISAM_MMAP_SIZE, self::MIN, self::MAX],
        [MysqlVariable::MYISAM_RECOVER_OPTIONS, self::MIN, self::MAX],
        [MysqlVariable::MYISAM_REPAIR_THREADS, self::MIN, 80030],
        [MysqlVariable::MYISAM_SORT_BUFFER_SIZE, self::MIN, self::MAX],
        [MysqlVariable::MYISAM_STATS_METHOD, self::MIN, self::MAX],
        [MysqlVariable::MYISAM_USE_MMAP, self::MIN, self::MAX],
        [MysqlVariable::MYSQL_NATIVE_PASSWORD_PROXY_USERS, self::MIN, self::MAX],
        [MysqlVariable::NAMED_PIPE, self::MIN, self::MAX],
        [MysqlVariable::NAMED_PIPE_FULL_ACCESS_GROUP, 50643, 50699],
        [MysqlVariable::NAMED_PIPE_FULL_ACCESS_GROUP, 50725, 50799],
        [MysqlVariable::NAMED_PIPE_FULL_ACCESS_GROUP, 80014, self::MAX],
        [MysqlVariable::NET_BUFFER_LENGTH, self::MIN, self::MAX],
        [MysqlVariable::NET_READ_TIMEOUT, self::MIN, self::MAX],
        [MysqlVariable::NET_RETRY_COUNT, self::MIN, self::MAX],
        [MysqlVariable::NET_WRITE_TIMEOUT, self::MIN, self::MAX],
        [MysqlVariable::NEW, self::MIN, self::MAX],
        [MysqlVariable::NGRAM_TOKEN_SIZE, self::MIN, self::MAX],
        [MysqlVariable::OFFLINE_MODE, self::MIN, self::MAX],
        [MysqlVariable::OLD, self::MIN, self::MAX],
        [MysqlVariable::OLD_ALTER_TABLE, self::MIN, self::MAX],
        [MysqlVariable::OPEN_FILES_LIMIT, self::MIN, self::MAX],
        [MysqlVariable::OPTIMIZER_PRUNE_LEVEL, self::MIN, self::MAX],
        [MysqlVariable::OPTIMIZER_SEARCH_DEPTH, self::MIN, self::MAX],
        [MysqlVariable::OPTIMIZER_SWITCH, self::MIN, self::MAX],
        [MysqlVariable::OPTIMIZER_TRACE, self::MIN, self::MAX],
        [MysqlVariable::OPTIMIZER_TRACE_FEATURES, self::MIN, self::MAX],
        [MysqlVariable::OPTIMIZER_TRACE_LIMIT, self::MIN, self::MAX],
        [MysqlVariable::OPTIMIZER_TRACE_MAX_MEM_SIZE, self::MIN, self::MAX],
        [MysqlVariable::OPTIMIZER_TRACE_OFFSET, self::MIN, self::MAX],
        [MysqlVariable::PARSER_MAX_MEM_SIZE, 50712, self::MAX],
        [MysqlVariable::PARTIAL_REVOKES, 80016, self::MAX],
        [MysqlVariable::PASSWORD_HISTORY, self::MIN, self::MAX],
        [MysqlVariable::PASSWORD_REQUIRE_CURRENT, 80013, self::MAX],
        [MysqlVariable::PASSWORD_REUSE_INTERVAL, self::MIN, self::MAX],
        [MysqlVariable::PERSISTED_GLOBALS_LOAD, self::MIN, self::MAX],
        [MysqlVariable::PERSIST_ONLY_ADMIN_X509_SUBJECT, 80014, self::MAX],
        [MysqlVariable::PERSIST_SENSITIVE_VARIABLES_IN_PLAINTEXT, 80029, self::MAX],
        [MysqlVariable::PID_FILE, self::MIN, self::MAX],
        [MysqlVariable::PLUGIN_DIR, self::MIN, self::MAX],
        [MysqlVariable::PORT, self::MIN, self::MAX],
        [MysqlVariable::PRELOAD_BUFFER_SIZE, self::MIN, self::MAX],
        [MysqlVariable::PRINT_IDENTIFIED_WITH_AS_HEX, 80017, self::MAX],
        [MysqlVariable::PROFILING, self::MIN, self::MAX],
        [MysqlVariable::PROFILING_HISTORY_SIZE, self::MIN, self::MAX],
        [MysqlVariable::PROTOCOL_COMPRESSION_ALGORITHMS, 80018, self::MAX],
        [MysqlVariable::PROTOCOL_VERSION, self::MIN, self::MAX],
        [MysqlVariable::PROXY_USER, self::MIN, self::MAX],
        [MysqlVariable::PSEUDO_REPLICA_MODE, 80026, self::MAX],
        [MysqlVariable::PSEUDO_SLAVE_MODE, 80026, self::MAX],
        [MysqlVariable::PSEUDO_THREAD_ID, self::MIN, self::MAX],
        [MysqlVariable::QUERY_ALLOC_BLOCK_SIZE, self::MIN, self::MAX],
        [MysqlVariable::QUERY_PREALLOC_SIZE, self::MIN, self::MAX],
        [MysqlVariable::RAND_SEED1, self::MIN, self::MAX],
        [MysqlVariable::RAND_SEED2, self::MIN, self::MAX],
        [MysqlVariable::RANGE_ALLOC_BLOCK_SIZE, self::MIN, self::MAX],
        [MysqlVariable::RANGE_OPTIMIZER_MAX_MEM_SIZE, self::MIN, self::MAX],
        [MysqlVariable::RBR_EXEC_MODE, self::MIN, self::MAX],
        [MysqlVariable::READ_BUFFER_SIZE, self::MIN, self::MAX],
        [MysqlVariable::READ_ONLY, self::MIN, self::MAX],
        [MysqlVariable::READ_RND_BUFFER_SIZE, self::MIN, self::MAX],
        [MysqlVariable::REGEXP_STACK_LIMIT, self::MIN, self::MAX],
        [MysqlVariable::REGEXP_TIME_LIMIT, self::MIN, self::MAX],
        [MysqlVariable::REQUIRE_ROW_FORMAT, 80019, self::MAX],
        [MysqlVariable::REQUIRE_SECURE_TRANSPORT, self::MIN, self::MAX],
        [MysqlVariable::RESULTSET_METADATA, self::MIN, self::MAX],
        [MysqlVariable::SECONDARY_ENGINE_COST_THRESHOLD, 80016, self::MAX],
        [MysqlVariable::SCHEMA_DEFINITION_CACHE, self::MIN, self::MAX],
        [MysqlVariable::SECURE_FILE_PRIV, self::MIN, self::MAX],
        [MysqlVariable::SELECT_INTO_BUFFER_SIZE, 80022, self::MAX],
        [MysqlVariable::SELECT_INTO_DISK_SYNC, 80022, self::MAX],
        [MysqlVariable::SELECT_INTO_DISK_SYNC_DELAY, 80022, self::MAX],
        [MysqlVariable::SESSION_TRACK_GTIDS, self::MIN, self::MAX],
        [MysqlVariable::SESSION_TRACK_SCHEMA, self::MIN, self::MAX],
        [MysqlVariable::SESSION_TRACK_STATE_CHANGE, self::MIN, self::MAX],
        [MysqlVariable::SESSION_TRACK_SYSTEM_VARIABLES, self::MIN, self::MAX],
        [MysqlVariable::SESSION_TRACK_TRANSACTION_INFO, self::MIN, self::MAX],
        [MysqlVariable::SHA256_PASSWORD_AUTO_GENERATE_RSA_KEYS, self::MIN, self::MAX],
        [MysqlVariable::SHA256_PASSWORD_PRIVATE_KEY_PATH, self::MIN, self::MAX],
        [MysqlVariable::SHA256_PASSWORD_PROXY_USERS, self::MIN, self::MAX],
        [MysqlVariable::SHA256_PASSWORD_PUBLIC_KEY_PATH, self::MIN, self::MAX],
        [MysqlVariable::SHARED_MEMORY, self::MIN, self::MAX],
        [MysqlVariable::SHARED_MEMORY_BASE_NAME, self::MIN, self::MAX],
        [MysqlVariable::SHOW_CREATE_TABLE_SKIP_SECONDARY_ENGINE, 80018, self::MAX],
        [MysqlVariable::SHOW_CREATE_TABLE_VERBOSITY, 50722, self::MAX],
        [MysqlVariable::SHOW_GIPK_IN_CREATE_TABLE_AND_INFORMATION_SCHEMA, 80030, self::MAX],
        [MysqlVariable::SHOW_OLD_TEMPORALS, 50624, self::MAX],
        [MysqlVariable::SKIP_EXTERNAL_LOCKING, self::MIN, self::MAX],
        [MysqlVariable::SKIP_NAME_RESOLVE, self::MIN, self::MAX],
        [MysqlVariable::SKIP_NETWORKING, self::MIN, self::MAX],
        [MysqlVariable::SKIP_SHOW_DATABASE, self::MIN, self::MAX],
        [MysqlVariable::SLOW_LAUNCH_TIME, self::MIN, self::MAX],
        [MysqlVariable::SLOW_QUERY_LOG, self::MIN, self::MAX],
        [MysqlVariable::SOCKET, self::MIN, self::MAX],
        [MysqlVariable::SORT_BUFFER_SIZE, self::MIN, self::MAX],
        [MysqlVariable::SQL_AUTO_IS_NULL, self::MIN, self::MAX],
        [MysqlVariable::SQL_BIG_SELECTS, self::MIN, self::MAX],
        [MysqlVariable::SQL_BUFFER_RESULT, self::MIN, self::MAX],
        [MysqlVariable::SQL_GENERATE_INVISIBLE_PRIMARY_KEY, 80030, self::MAX],
        [MysqlVariable::SQL_LOG_OFF, self::MIN, self::MAX],
        [MysqlVariable::SQL_MODE, self::MIN, self::MAX],
        [MysqlVariable::SQL_NOTES, self::MIN, self::MAX],
        [MysqlVariable::SQL_QUOTE_SHOW_CREATE, self::MIN, self::MAX],
        [MysqlVariable::SQL_REQUIRE_PRIMARY_KEY, 80013, self::MAX],
        [MysqlVariable::SQL_SAFE_UPDATES, self::MIN, self::MAX],
        [MysqlVariable::SQL_SELECT_LIMIT, self::MIN, self::MAX],
        [MysqlVariable::SQL_WARNINGS, self::MIN, self::MAX],
        [MysqlVariable::SSL_CA, self::MIN, self::MAX],
        [MysqlVariable::SSL_CAPATH, self::MIN, self::MAX],
        [MysqlVariable::SSL_CERT, self::MIN, self::MAX],
        [MysqlVariable::SSL_CIPHER, self::MIN, self::MAX],
        [MysqlVariable::SSL_CRL, self::MIN, self::MAX],
        [MysqlVariable::SSL_CRLPATH, self::MIN, self::MAX],
        [MysqlVariable::SSL_FIPS_MODE, self::MIN, self::MAX],
        [MysqlVariable::SSL_KEY, self::MIN, self::MAX],
        [MysqlVariable::SSL_SESSION_CACHE_MODE, 80029, self::MAX],
        [MysqlVariable::SSL_SESSION_CACHE_TIMEOUT, 80029, self::MAX],
        [MysqlVariable::STORED_PROGRAM_CACHE, self::MIN, self::MAX],
        [MysqlVariable::STORED_PROGRAM_DEFINITION_CACHE, self::MIN, self::MAX],
        [MysqlVariable::SUPER_READ_ONLY, self::MIN, self::MAX],
        [MysqlVariable::SYSEVENTLOG__FACILITY, 80013, self::MAX],
        [MysqlVariable::SYSEVENTLOG__INCLUDE_PID, 80013, self::MAX],
        [MysqlVariable::SYSEVENTLOG__TAG, 80013, self::MAX],
        [MysqlVariable::SYSTEM_TIME_ZONE, self::MIN, self::MAX],
        [MysqlVariable::TABLE_DEFINITION_CACHE, self::MIN, self::MAX],
        [MysqlVariable::TABLE_ENCRYPTION_PRIVILEGE_CHECK, 80016, self::MAX],
        [MysqlVariable::TABLE_OPEN_CACHE, self::MIN, self::MAX],
        [MysqlVariable::TABLE_OPEN_CACHE_INSTANCES, self::MIN, self::MAX],
        [MysqlVariable::TABLESPACE_DEFINITION_CACHE, self::MIN, self::MAX],
        [MysqlVariable::TEMPTABLE_MAX_MMAP, 80023, self::MAX],
        [MysqlVariable::TEMPTABLE_MAX_RAM, self::MIN, self::MAX],
        [MysqlVariable::TEMPTABLE_USE_MMAP, 80016, self::MAX],
        [MysqlVariable::THREAD_CACHE_SIZE, self::MIN, self::MAX],
        [MysqlVariable::THREAD_HANDLING, self::MIN, self::MAX],
        [MysqlVariable::THREAD_POOL_ALGORITHM, self::MIN, self::MAX],
        [MysqlVariable::THREAD_POOL_HIGH_PRIORITY_CONNECTION, self::MIN, self::MAX],
        [MysqlVariable::THREAD_POOL_MAX_ACTIVE_QUERY_THREADS, 80019, self::MAX],
        [MysqlVariable::THREAD_POOL_MAX_UNUSED_THREADS, self::MIN, self::MAX],
        [MysqlVariable::THREAD_POOL_PRIO_KICKUP_TIMER, self::MIN, self::MAX],
        [MysqlVariable::THREAD_POOL_SIZE, self::MIN, self::MAX],
        [MysqlVariable::THREAD_POOL_STALL_LIMIT, self::MIN, self::MAX],
        [MysqlVariable::THREAD_STACK, self::MIN, self::MAX],
        [MysqlVariable::TIME_ZONE, self::MIN, self::MAX],
        [MysqlVariable::TIMESTAMP, self::MIN, self::MAX],
        [MysqlVariable::TLS_CIPHERSUITES, 80016, self::MAX],
        [MysqlVariable::TLS_VERSION, 50710, self::MAX],
        [MysqlVariable::TMP_TABLE_SIZE, self::MIN, self::MAX],
        [MysqlVariable::TMPDIR, self::MIN, self::MAX],
        [MysqlVariable::TRANSACTION_ALLOC_BLOCK_SIZE, self::MIN, self::MAX],
        [MysqlVariable::TRANSACTION_ISOLATION, self::MIN, self::MAX],
        [MysqlVariable::TRANSACTION_PREALLOC_SIZE, self::MIN, self::MAX],
        [MysqlVariable::TRANSACTION_READ_ONLY, self::MIN, self::MAX],
        [MysqlVariable::UNIQUE_CHECKS, self::MIN, self::MAX],
        [MysqlVariable::UPDATABLE_VIEWS_WITH_LIMIT, self::MIN, self::MAX],
        [MysqlVariable::USE_SECONDARY_ENGINE, 80013, self::MAX],
        [MysqlVariable::VERSION, self::MIN, self::MAX],
        [MysqlVariable::VERSION_COMMENT, self::MIN, self::MAX],
        [MysqlVariable::VERSION_COMPILE_MACHINE, self::MIN, self::MAX],
        [MysqlVariable::VERSION_COMPILE_OS, self::MIN, self::MAX],
        [MysqlVariable::VERSION_COMPILE_ZLIB, self::MIN, self::MAX],
        [MysqlVariable::WAIT_TIMEOUT, self::MIN, self::MAX],
        [MysqlVariable::WARNING_COUNT, self::MIN, self::MAX],
        [MysqlVariable::WINDOWING_USE_HIGH_PRECISION, self::MIN, self::MAX],
        [MysqlVariable::XA_DETACH_ON_PREPARE, 80029, self::MAX],

        // https://dev.mysql.com/doc/refman/8.0/en/replication-options-binary-log.html
        [MysqlVariable::BINLOG_CACHE_SIZE, self::MIN, self::MAX],
        [MysqlVariable::BINLOG_CHECKSUM, self::MIN, self::MAX],
        [MysqlVariable::BINLOG_DIRECT_NON_TRANSACTIONAL_UPDATES, self::MIN, self::MAX],
        [MysqlVariable::BINLOG_ENCRYPTION, 80014, self::MAX],
        [MysqlVariable::BINLOG_ERROR_ACTION, 50622, self::MAX],
        [MysqlVariable::BINLOG_EXPIRE_LOGS_SECONDS, self::MIN, self::MAX],
        [MysqlVariable::BINLOG_EXPIRE_LOGS_AUTO_PURGE, 80029, self::MAX],
        [MysqlVariable::BINLOG_FORMAT, self::MIN, self::MAX],
        [MysqlVariable::BINLOG_GROUP_COMMIT_SYNC_DELAY, self::MIN, self::MAX],
        [MysqlVariable::BINLOG_GROUP_COMMIT_SYNC_NO_DELAY_COUNT, self::MIN, self::MAX],
        [MysqlVariable::BINLOG_MAX_FLUSH_QUEUE_TIME, self::MIN, self::MAX],
        [MysqlVariable::BINLOG_ORDER_COMMITS, self::MIN, self::MAX],
        [MysqlVariable::BINLOG_ROTATE_ENCRYPTION_MASTER_KEY_AT_STARTUP, 80014, self::MAX],
        [MysqlVariable::BINLOG_ROW_EVENT_MAX_SIZE, self::MIN, self::MAX],
        [MysqlVariable::BINLOG_ROW_IMAGE, self::MIN, self::MAX],
        [MysqlVariable::BINLOG_ROW_METADATA, self::MIN, self::MAX],
        [MysqlVariable::BINLOG_ROW_VALUE_OPTIONS, self::MIN, self::MAX],
        [MysqlVariable::BINLOG_ROWS_QUERY_LOG_EVENTS, self::MIN, self::MAX],
        [MysqlVariable::BINLOG_STMT_CACHE_SIZE, self::MIN, self::MAX],
        [MysqlVariable::BINLOG_TRANSACTION_COMPRESSION, 80020, self::MAX],
        [MysqlVariable::BINLOG_TRANSACTION_COMPRESSION_LEVEL_ZSTD, 80020, self::MAX],
        [MysqlVariable::BINLOG_TRANSACTION_DEPENDENCY_TRACKING, 50722, self::MAX],
        [MysqlVariable::BINLOG_TRANSACTION_DEPENDENCY_HISTORY_SIZE, 50722, self::MAX],
        [MysqlVariable::BINLOGGING_IMPOSSIBLE_MODE, 50620, self::MAX, 50622],
        [MysqlVariable::EXPIRE_LOGS_DAYS, self::MIN, self::MAX],
        [MysqlVariable::LOG_BIN, self::MIN, self::MAX],
        [MysqlVariable::LOG_BIN_BASENAME, self::MIN, self::MAX],
        [MysqlVariable::LOG_BIN_INDEX, self::MIN, self::MAX],
        [MysqlVariable::LOG_BIN_USE_V1_ROW_EVENTS, self::MIN, self::MAX],
        [MysqlVariable::LOG_REPLICA_UPDATES, 80026, self::MAX],
        [MysqlVariable::LOG_SLAVE_UPDATES, self::MIN, self::MAX],
        [MysqlVariable::LOG_STATEMENTS_UNSAFE_FOR_BINLOG, 50711, self::MAX],
        [MysqlVariable::MASTER_VERIFY_CHECKSUM, self::MIN, self::MAX],
        [MysqlVariable::MAX_BINLOG_CACHE_SIZE, self::MIN, self::MAX],
        [MysqlVariable::MAX_BINLOG_SIZE, self::MIN, self::MAX],
        [MysqlVariable::MAX_BINLOG_STMT_CACHE_SIZE, self::MIN, self::MAX],
        [MysqlVariable::ORIGINAL_COMMIT_TIMESTAMP, self::MIN, self::MAX],
        [MysqlVariable::SOURCE_VERIFY_CHECKSUM, 80026, self::MAX],
        [MysqlVariable::SQL_LOG_BIN, self::MIN, self::MAX],
        [MysqlVariable::SYNC_BINLOG, self::MIN, self::MAX],
        [MysqlVariable::TRANSACTION_WRITE_SET_EXTRACTION, self::MIN, self::MAX],

        // https://dev.mysql.com/doc/refman/8.0/en/clone-plugin-options-variables.html
        [MysqlVariable::CLONE_AUTOTUNE_CONCURRENCY, 80017, self::MAX],
        [MysqlVariable::CLONE_BUFFER_SIZE, 80017, self::MAX],
        [MysqlVariable::CLONE_BLOCK_DDL, 80027, self::MAX],
        [MysqlVariable::CLONE_DELAY_AFTER_DATA_DROP, 80029, self::MAX],
        [MysqlVariable::CLONE_DDL_TIMEOUT, 80017, self::MAX],
        [MysqlVariable::CLONE_DONOR_TIMEOUT_AFTER_NETWORK_FAILURE, 80024, self::MAX],
        [MysqlVariable::CLONE_ENABLE_COMPRESSION, 80017, self::MAX],
        [MysqlVariable::CLONE_MAX_CONCURRENCY, 80017, self::MAX],
        [MysqlVariable::CLONE_MAX_DATA_BANDWIDTH, 80017, self::MAX],
        [MysqlVariable::CLONE_MAX_NETWORK_BANDWIDTH, 80017, self::MAX],
        [MysqlVariable::CLONE_SSL_CA, 80014, self::MAX],
        [MysqlVariable::CLONE_SSL_CERT, 80014, self::MAX],
        [MysqlVariable::CLONE_SSL_KEY, 80014, self::MAX],
        [MysqlVariable::CLONE_VALID_DONOR_LIST, 80017, self::MAX],

        // https://dev.mysql.com/doc/refman/8.0/en/connection-control-variables.html
        [MysqlVariable::CONNECTION_CONTROL_FAILED_CONNECTIONS_THRESHOLD, 50635, self::MAX],
        [MysqlVariable::CONNECTION_CONTROL_FAILED_CONNECTIONS_THRESHOLD, 50717, self::MAX],
        [MysqlVariable::CONNECTION_CONTROL_MAX_CONNECTION_DELAY, 50635, self::MAX],
        [MysqlVariable::CONNECTION_CONTROL_MAX_CONNECTION_DELAY, 50717, self::MAX],
        [MysqlVariable::CONNECTION_CONTROL_MIN_CONNECTION_DELAY, 50635, self::MAX],
        [MysqlVariable::CONNECTION_CONTROL_MIN_CONNECTION_DELAY, 50717, self::MAX],

        // https://dev.mysql.com/doc/refman/8.0/en/replication-options-gtids.html
        [MysqlVariable::SIMPLIFIED_BINLOG_GTID_RECOVERY, 50623, self::MAX],
        [MysqlVariable::BINLOG_GTID_SIMPLE_RECOVERY, 50623, self::MAX],
        [MysqlVariable::ENFORCE_GTID_CONSISTENCY, self::MIN, self::MAX],
        [MysqlVariable::GTID_EXECUTED, self::MIN, self::MAX],
        [MysqlVariable::GTID_EXECUTED_COMPRESSION_PERIOD, self::MIN, self::MAX],
        [MysqlVariable::GTID_MODE, self::MIN, self::MAX],
        [MysqlVariable::GTID_NEXT, self::MIN, self::MAX],
        [MysqlVariable::GTID_OWNED, self::MIN, self::MAX],
        [MysqlVariable::GTID_PURGED, self::MIN, self::MAX],

        // https://dev.mysql.com/doc/refman/8.0/en/group-replication-options.html
        [MysqlVariable::GROUP_REPLICATION_ADVERTISE_RECOVERY_ENDPOINTS, 80021, self::MAX],
        [MysqlVariable::GROUP_REPLICATION_ALLOW_LOCAL_DISJOINT_GTIDS_JOIN, 50717, 80000, 50721],
        [MysqlVariable::GROUP_REPLICATION_ALLOW_LOCAL_LOWER_VERSION_JOIN, 50717, self::MAX],
        [MysqlVariable::GROUP_REPLICATION_AUTO_INCREMENT_INCREMENT, 50717, self::MAX],
        [MysqlVariable::GROUP_REPLICATION_AUTOREJOIN_TRIES, 80016, self::MAX],
        [MysqlVariable::GROUP_REPLICATION_BOOTSTRAP_GROUP, 50717, self::MAX],
        [MysqlVariable::GROUP_REPLICATION_CLONE_THRESHOLD, 80017, self::MAX],
        [MysqlVariable::GROUP_REPLICATION_COMMUNICATION_DEBUG_OPTIONS, self::MIN, self::MAX],
        [MysqlVariable::GROUP_REPLICATION_COMMUNICATION_MAX_MESSAGE_SIZE, 80016, self::MAX],
        [MysqlVariable::GROUP_REPLICATION_COMMUNICATION_STACK, 80027, self::MAX],
        [MysqlVariable::GROUP_REPLICATION_COMPONENTS_STOP_TIMEOUT, 50717, self::MAX],
        [MysqlVariable::GROUP_REPLICATION_COMPRESSION_THRESHOLD, 50717, self::MAX],
        [MysqlVariable::GROUP_REPLICATION_CONSISTENCY, 80014, self::MAX],
        [MysqlVariable::GROUP_REPLICATION_ENFORCE_UPDATE_EVERYWHERE_CHECKS, 50717, self::MAX],
        [MysqlVariable::GROUP_REPLICATION_EXIT_STATE_ACTION, 50724, 59999],
        [MysqlVariable::GROUP_REPLICATION_EXIT_STATE_ACTION, 80012, self::MAX],
        [MysqlVariable::GROUP_REPLICATION_FLOW_CONTROL_APPLIER_THRESHOLD, 50717, self::MAX],
        [MysqlVariable::GROUP_REPLICATION_FLOW_CONTROL_CERTIFIER_THRESHOLD, 50717, self::MAX],
        [MysqlVariable::GROUP_REPLICATION_FLOW_CONTROL_HOLD_PERCENT, self::MIN, self::MAX],
        [MysqlVariable::GROUP_REPLICATION_FLOW_CONTROL_MAX_QUOTA, self::MIN, self::MAX],
        [MysqlVariable::GROUP_REPLICATION_FLOW_CONTROL_MEMBER_QUOTA_PERCENT, self::MIN, self::MAX],
        [MysqlVariable::GROUP_REPLICATION_FLOW_CONTROL_MIN_QUOTA, self::MIN, self::MAX],
        [MysqlVariable::GROUP_REPLICATION_FLOW_CONTROL_MIN_RECOVERY_QUOTA, self::MIN, self::MAX],
        [MysqlVariable::GROUP_REPLICATION_FLOW_CONTROL_MODE, 50717, self::MAX],
        [MysqlVariable::GROUP_REPLICATION_FLOW_CONTROL_PERIOD, self::MIN, self::MAX],
        [MysqlVariable::GROUP_REPLICATION_FLOW_CONTROL_RELEASE_PERCENT, self::MIN, self::MAX],
        [MysqlVariable::GROUP_REPLICATION_FORCE_MEMBERS, 50717, self::MAX],
        [MysqlVariable::GROUP_REPLICATION_GROUP_NAME, 50717, self::MAX],
        [MysqlVariable::GROUP_REPLICATION_GROUP_SEEDS, 50717, self::MAX],
        [MysqlVariable::GROUP_REPLICATION_GTID_ASSIGNMENT_BLOCK_SIZE, 50717, self::MAX],
        [MysqlVariable::GROUP_REPLICATION_IP_ALLOWLIST, 80022, self::MAX],
        [MysqlVariable::GROUP_REPLICATION_IP_WHITELIST, 50717, self::MAX],
        [MysqlVariable::GROUP_REPLICATION_LOCAL_ADDRESS, 50717, self::MAX],
        [MysqlVariable::GROUP_REPLICATION_MEMBER_EXPEL_TIMEOUT, 80013, self::MAX],
        [MysqlVariable::GROUP_REPLICATION_MEMBER_WEIGHT, 50720, self::MAX],
        [MysqlVariable::GROUP_REPLICATION_MESSAGE_CACHE_SIZE, 80016, self::MAX],
        [MysqlVariable::GROUP_REPLICATION_PAXOS_SINGLE_LEADER, 80027, self::MAX],
        [MysqlVariable::GROUP_REPLICATION_POLL_SPIN_LOOPS, 50717, self::MAX],
        [MysqlVariable::GROUP_REPLICATION_RECOVERY_COMPLETE_AT, 50717, self::MAX],
        [MysqlVariable::GROUP_REPLICATION_RECOVERY_COMPRESSION_ALGORITHMS, 80018, self::MAX],
        [MysqlVariable::GROUP_REPLICATION_RECOVERY_GET_PUBLIC_KEY, self::MIN, self::MAX],
        [MysqlVariable::GROUP_REPLICATION_RECOVERY_PUBLIC_KEY_PATH, self::MIN, self::MAX],
        [MysqlVariable::GROUP_REPLICATION_RECOVERY_RECONNECT_INTERVAL, 50717, self::MAX],
        [MysqlVariable::GROUP_REPLICATION_RECOVERY_RETRY_COUNT, 50717, self::MAX],
        [MysqlVariable::GROUP_REPLICATION_RECOVERY_SSL_CA, 50717, self::MAX],
        [MysqlVariable::GROUP_REPLICATION_RECOVERY_SSL_CAPATH, 50717, self::MAX],
        [MysqlVariable::GROUP_REPLICATION_RECOVERY_SSL_CERT, 50717, self::MAX],
        [MysqlVariable::GROUP_REPLICATION_RECOVERY_SSL_CIPHER, 50717, self::MAX],
        [MysqlVariable::GROUP_REPLICATION_RECOVERY_SSL_CRL, 50717, self::MAX],
        [MysqlVariable::GROUP_REPLICATION_RECOVERY_SSL_CRLPATH, 50717, self::MAX],
        [MysqlVariable::GROUP_REPLICATION_RECOVERY_SSL_KEY, 50717, self::MAX],
        [MysqlVariable::GROUP_REPLICATION_RECOVERY_SSL_VERIFY_SERVER_CERT, 50717, self::MAX],
        [MysqlVariable::GROUP_REPLICATION_RECOVERY_TLS_CIPHERSUITES, 80019, self::MAX],
        [MysqlVariable::GROUP_REPLICATION_RECOVERY_TLS_VERSION, 80019, self::MAX],
        [MysqlVariable::GROUP_REPLICATION_RECOVERY_USE_SSL, 50717, self::MAX],
        [MysqlVariable::GROUP_REPLICATION_RECOVERY_ZSTD_COMPRESSION_LEVEL, 80018, self::MAX],
        [MysqlVariable::GROUP_REPLICATION_SINGLE_PRIMARY_MODE, 50717, self::MAX],
        [MysqlVariable::GROUP_REPLICATION_SSL_MODE, 50717, self::MAX],
        [MysqlVariable::GROUP_REPLICATION_START_ON_BOOT, 50717, self::MAX],
        [MysqlVariable::GROUP_REPLICATION_TLS_SOURCE, 80021, self::MAX],
        [MysqlVariable::GROUP_REPLICATION_TRANSACTION_SIZE_LIMIT, 50719, self::MAX],
        [MysqlVariable::GROUP_REPLICATION_UNREACHABLE_MAJORITY_TIMEOUT, 50719, self::MAX],
        [MysqlVariable::GROUP_REPLICATION_VIEW_CHANGE_UUID, 80026, self::MAX],

        // https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html
        [MysqlVariable::DAEMON_MEMCACHED_ENABLE_BINLOG, self::MIN, self::MAX],
        [MysqlVariable::DAEMON_MEMCACHED_ENGINE_LIB_NAME, self::MIN, self::MAX],
        [MysqlVariable::DAEMON_MEMCACHED_ENGINE_LIB_PATH, self::MIN, self::MAX],
        [MysqlVariable::DAEMON_MEMCACHED_OPTION, self::MIN, self::MAX],
        [MysqlVariable::DAEMON_MEMCACHED_R_BATCH_SIZE, self::MIN, self::MAX],
        [MysqlVariable::DAEMON_MEMCACHED_W_BATCH_SIZE, self::MIN, self::MAX],
        [MysqlVariable::INNODB_ADAPTIVE_FLUSHING, self::MIN, self::MAX],
        [MysqlVariable::INNODB_ADAPTIVE_FLUSHING_LWM, self::MIN, self::MAX],
        [MysqlVariable::INNODB_ADAPTIVE_HASH_INDEX, self::MIN, self::MAX],
        [MysqlVariable::INNODB_ADAPTIVE_HASH_INDEX_PARTS, self::MIN, self::MAX],
        [MysqlVariable::INNODB_ADAPTIVE_MAX_SLEEP_DELAY, self::MIN, self::MAX],
        [MysqlVariable::INNODB_API_BK_COMMIT_INTERVAL, self::MIN, self::MAX],
        [MysqlVariable::INNODB_API_DISABLE_ROWLOCK, self::MIN, self::MAX],
        [MysqlVariable::INNODB_API_ENABLE_BINLOG, self::MIN, self::MAX],
        [MysqlVariable::INNODB_API_ENABLE_MDL, self::MIN, self::MAX],
        [MysqlVariable::INNODB_API_TRX_LEVEL, self::MIN, self::MAX],
        [MysqlVariable::INNODB_AUTOEXTEND_INCREMENT, self::MIN, self::MAX],
        [MysqlVariable::INNODB_AUTOINC_LOCK_MODE, self::MIN, self::MAX],
        [MysqlVariable::INNODB_BACKGROUND_DROP_LIST_EMPTY, 50710, self::MAX],
        [MysqlVariable::INNODB_BUFFER_POOL_CHUNK_SIZE, self::MIN, self::MAX],
        [MysqlVariable::INNODB_BUFFER_POOL_DEBUG, self::MIN, self::MAX],
        [MysqlVariable::INNODB_BUFFER_POOL_DUMP_AT_SHUTDOWN, self::MIN, self::MAX],
        [MysqlVariable::INNODB_BUFFER_POOL_DUMP_NOW, self::MIN, self::MAX],
        [MysqlVariable::INNODB_BUFFER_POOL_DUMP_PCT, self::MIN, self::MAX],
        [MysqlVariable::INNODB_BUFFER_POOL_FILENAME, self::MIN, self::MAX],
        [MysqlVariable::INNODB_BUFFER_POOL_IN_CORE_FILE, 80014, self::MAX],
        [MysqlVariable::INNODB_BUFFER_POOL_INSTANCES, self::MIN, self::MAX],
        [MysqlVariable::INNODB_BUFFER_POOL_LOAD_ABORT, self::MIN, self::MAX],
        [MysqlVariable::INNODB_BUFFER_POOL_LOAD_AT_STARTUP, self::MIN, self::MAX],
        [MysqlVariable::INNODB_BUFFER_POOL_LOAD_NOW, self::MIN, self::MAX],
        [MysqlVariable::INNODB_BUFFER_POOL_SIZE, self::MIN, self::MAX],
        [MysqlVariable::INNODB_CHANGE_BUFFER_MAX_SIZE, self::MIN, self::MAX],
        [MysqlVariable::INNODB_CHANGE_BUFFERING, self::MIN, self::MAX],
        [MysqlVariable::INNODB_CHANGE_BUFFERING_DEBUG, self::MIN, self::MAX],
        [MysqlVariable::INNODB_CHECKPOINT_DISABLED, self::MIN, self::MAX],
        [MysqlVariable::INNODB_CHECKSUM_ALGORITHM, self::MIN, self::MAX],
        [MysqlVariable::INNODB_CMP_PER_INDEX_ENABLED, self::MIN, self::MAX],
        [MysqlVariable::INNODB_COMMIT_CONCURRENCY, self::MIN, self::MAX],
        [MysqlVariable::INNODB_COMPRESS_DEBUG, self::MIN, self::MAX],
        [MysqlVariable::INNODB_COMPRESSION_FAILURE_THRESHOLD_PCT, self::MIN, self::MAX],
        [MysqlVariable::INNODB_COMPRESSION_LEVEL, self::MIN, self::MAX],
        [MysqlVariable::INNODB_COMPRESSION_PAD_PCT_MAX, self::MIN, self::MAX],
        [MysqlVariable::INNODB_CONCURRENCY_TICKETS, self::MIN, self::MAX],
        [MysqlVariable::INNODB_DATA_FILE_PATH, self::MIN, self::MAX],
        [MysqlVariable::INNODB_DATA_HOME_DIR, self::MIN, self::MAX],
        [MysqlVariable::INNODB_DDL_BUFFER_SIZE, 80027, self::MAX],
        [MysqlVariable::INNODB_DDL_LOG_CRASH_RESET_DEBUG, self::MIN, self::MAX],
        [MysqlVariable::INNODB_DDL_THREADS, 80027, self::MAX],
        [MysqlVariable::INNODB_DEADLOCK_DETECT, 50715, self::MAX],
        [MysqlVariable::INNODB_DEDICATED_SERVER, self::MIN, self::MAX],
        [MysqlVariable::INNODB_DEFAULT_ROW_FORMAT, self::MIN, self::MAX],
        [MysqlVariable::INNODB_DIRECTORIES, self::MIN, self::MAX],
        [MysqlVariable::INNODB_DISABLE_SORT_FILE_CACHE, self::MIN, self::MAX],
        [MysqlVariable::INNODB_DOUBLEWRITE, self::MIN, self::MAX],
        [MysqlVariable::INNODB_DOUBLEWRITE_BATCH_SIZE, 80020, self::MAX],
        [MysqlVariable::INNODB_DOUBLEWRITE_DIR, 80020, self::MAX],
        [MysqlVariable::INNODB_DOUBLEWRITE_FILES, 80020, self::MAX],
        [MysqlVariable::INNODB_DOUBLEWRITE_PAGES, 80020, self::MAX],
        [MysqlVariable::INNODB_EXTEND_AND_INITIALIZE, 80022, self::MAX],
        [MysqlVariable::INNODB_FAST_SHUTDOWN, self::MIN, self::MAX],
        [MysqlVariable::INNODB_FIL_MAKE_PAGE_DIRTY_DEBUG, 50617, self::MAX],
        [MysqlVariable::INNODB_FILE_PER_TABLE, self::MIN, self::MAX],
        [MysqlVariable::INNODB_FILL_FACTOR, self::MIN, self::MAX],
        [MysqlVariable::INNODB_FLUSH_LOG_AT_TIMEOUT, self::MIN, self::MAX],
        [MysqlVariable::INNODB_FLUSH_LOG_AT_TRX_COMMIT, self::MIN, self::MAX],
        [MysqlVariable::INNODB_FLUSH_METHOD, self::MIN, self::MAX],
        [MysqlVariable::INNODB_FLUSH_NEIGHBORS, self::MIN, self::MAX],
        [MysqlVariable::INNODB_FLUSH_SYNC, self::MIN, self::MAX],
        [MysqlVariable::INNODB_FLUSHING_AVG_LOOPS, self::MIN, self::MAX],
        [MysqlVariable::INNODB_FORCE_LOAD_CORRUPTED, self::MIN, self::MAX],
        [MysqlVariable::INNODB_FORCE_RECOVERY, self::MIN, self::MAX],
        [MysqlVariable::INNODB_FSYNC_THRESHOLD, 80013, self::MAX],
        [MysqlVariable::INNODB_FT_AUX_TABLE, self::MIN, self::MAX],
        [MysqlVariable::INNODB_FT_CACHE_SIZE, self::MIN, self::MAX],
        [MysqlVariable::INNODB_FT_ENABLE_DIAG_PRINT, self::MIN, self::MAX],
        [MysqlVariable::INNODB_FT_ENABLE_STOPWORD, self::MIN, self::MAX],
        [MysqlVariable::INNODB_FT_MAX_TOKEN_SIZE, self::MIN, self::MAX],
        [MysqlVariable::INNODB_FT_MIN_TOKEN_SIZE, self::MIN, self::MAX],
        [MysqlVariable::INNODB_FT_NUM_WORD_OPTIMIZE, self::MIN, self::MAX],
        [MysqlVariable::INNODB_FT_RESULT_CACHE_LIMIT, 50613, self::MAX],
        [MysqlVariable::INNODB_FT_SERVER_STOPWORD_TABLE, self::MIN, self::MAX],
        [MysqlVariable::INNODB_FT_SORT_PLL_DEGREE, self::MIN, self::MAX],
        [MysqlVariable::INNODB_FT_TOTAL_CACHE_SIZE, 50613, self::MAX],
        [MysqlVariable::INNODB_FT_USER_STOPWORD_TABLE, self::MIN, self::MAX],
        [MysqlVariable::INNODB_IDLE_FLUSH_PCT, 80018, self::MAX],
        [MysqlVariable::INNODB_IO_CAPACITY, self::MIN, self::MAX],
        [MysqlVariable::INNODB_IO_CAPACITY_MAX, self::MIN, self::MAX],
        [MysqlVariable::INNODB_LIMIT_OPTIMISTIC_INSERT_DEBUG, self::MIN, self::MAX],
        [MysqlVariable::INNODB_LOCK_WAIT_TIMEOUT, self::MIN, self::MAX],
        [MysqlVariable::INNODB_LOG_BUFFER_SIZE, self::MIN, self::MAX],
        [MysqlVariable::INNODB_LOG_CHECKPOINT_FUZZY_NOW, 80013, self::MAX],
        [MysqlVariable::INNODB_LOG_CHECKPOINT_NOW, 50612, self::MAX],
        [MysqlVariable::INNODB_LOG_CHECKSUMS, self::MIN, self::MAX],
        [MysqlVariable::INNODB_LOG_COMPRESSED_PAGES, 50611, self::MAX],
        [MysqlVariable::INNODB_LOG_FILE_SIZE, self::MIN, self::MAX],
        [MysqlVariable::INNODB_LOG_FILES_IN_GROUP, self::MIN, self::MAX],
        [MysqlVariable::INNODB_LOG_GROUP_HOME_DIR, self::MIN, self::MAX],
        [MysqlVariable::INNODB_LOG_SPIN_CPU_PCT_HWM, self::MIN, self::MAX],
        [MysqlVariable::INNODB_LOG_WAIT_FOR_FLUSH_SPIN_HWM, self::MIN, self::MAX],
        [MysqlVariable::INNODB_LOG_WRITE_AHEAD_SIZE, self::MIN, self::MAX],
        [MysqlVariable::INNODB_LOG_WRITER_THREADS, 80022, self::MAX],
        [MysqlVariable::INNODB_LRU_SCAN_DEPTH, self::MIN, self::MAX],
        [MysqlVariable::INNODB_MAX_DIRTY_PAGES_PCT, self::MIN, self::MAX],
        [MysqlVariable::INNODB_MAX_DIRTY_PAGES_PCT_LWM, self::MIN, self::MAX],
        [MysqlVariable::INNODB_MAX_PURGE_LAG, self::MIN, self::MAX],
        [MysqlVariable::INNODB_MAX_PURGE_LAG_DELAY, self::MIN, self::MAX],
        [MysqlVariable::INNODB_MAX_UNDO_LOG_SIZE, self::MIN, self::MAX],
        [MysqlVariable::INNODB_MERGE_THRESHOLD_SET_ALL_DEBUG, self::MIN, self::MAX],
        [MysqlVariable::INNODB_MONITOR_DISABLE, self::MIN, self::MAX],
        [MysqlVariable::INNODB_MONITOR_ENABLE, self::MIN, self::MAX],
        [MysqlVariable::INNODB_MONITOR_RESET, self::MIN, self::MAX],
        [MysqlVariable::INNODB_MONITOR_RESET_ALL, self::MIN, self::MAX],
        [MysqlVariable::INNODB_NUMA_INTERLEAVE, 50627, self::MAX],
        [MysqlVariable::INNODB_OLD_BLOCKS_PCT, self::MIN, self::MAX],
        [MysqlVariable::INNODB_OLD_BLOCKS_TIME, self::MIN, self::MAX],
        [MysqlVariable::INNODB_ONLINE_ALTER_LOG_MAX_SIZE, self::MIN, self::MAX],
        [MysqlVariable::INNODB_OPEN_FILES, self::MIN, self::MAX],
        [MysqlVariable::INNODB_OPTIMIZE_FULLTEXT_ONLY, self::MIN, self::MAX],
        [MysqlVariable::INNODB_PAGE_CLEANERS, 50700, self::MAX],
        [MysqlVariable::INNODB_PAGE_SIZE, self::MIN, self::MAX],
        [MysqlVariable::INNODB_PARALLEL_READ_THREADS, 80014, self::MAX],
        [MysqlVariable::INNODB_PRINT_ALL_DEADLOCKS, self::MIN, self::MAX],
        [MysqlVariable::INNODB_PRINT_DDL_LOGS, self::MIN, self::MAX],
        [MysqlVariable::INNODB_PURGE_BATCH_SIZE, self::MIN, self::MAX],
        [MysqlVariable::INNODB_PURGE_THREADS, self::MIN, self::MAX],
        [MysqlVariable::INNODB_PURGE_RSEG_TRUNCATE_FREQUENCY, self::MIN, self::MAX],
        [MysqlVariable::INNODB_RANDOM_READ_AHEAD, self::MIN, self::MAX],
        [MysqlVariable::INNODB_READ_AHEAD_THRESHOLD, self::MIN, self::MAX],
        [MysqlVariable::INNODB_READ_IO_THREADS, self::MIN, self::MAX],
        [MysqlVariable::INNODB_READ_ONLY, self::MIN, self::MAX],
        [MysqlVariable::INNODB_REDO_LOG_ARCHIVE_DIRS, 80017, self::MAX],
        [MysqlVariable::INNODB_REDO_LOG_CAPACITY, 80030, self::MAX],
        [MysqlVariable::INNODB_REDO_LOG_ENCRYPT, self::MIN, self::MAX],
        [MysqlVariable::INNODB_REPLICATION_DELAY, self::MIN, self::MAX],
        [MysqlVariable::INNODB_ROLLBACK_ON_TIMEOUT, self::MIN, self::MAX],
        [MysqlVariable::INNODB_ROLLBACK_SEGMENTS, self::MIN, self::MAX],
        [MysqlVariable::INNODB_SAVED_PAGE_NUMBER_DEBUG, 50617, self::MAX],
        [MysqlVariable::INNODB_SEGMENT_RESERVE_FACTOR, 80026, self::MAX],
        [MysqlVariable::INNODB_SORT_BUFFER_SIZE, self::MIN, self::MAX],
        [MysqlVariable::INNODB_SPIN_WAIT_DELAY, self::MIN, self::MAX],
        [MysqlVariable::INNODB_SPIN_WAIT_PAUSE_MULTIPLIER, 80016, self::MAX],
        [MysqlVariable::INNODB_STATS_AUTO_RECALC, self::MIN, self::MAX],
        [MysqlVariable::INNODB_STATS_INCLUDE_DELETE_MARKED, 50635, 50699],
        [MysqlVariable::INNODB_STATS_INCLUDE_DELETE_MARKED, 50717, self::MAX],
        [MysqlVariable::INNODB_STATS_METHOD, self::MIN, self::MAX],
        [MysqlVariable::INNODB_STATS_ON_METADATA, self::MIN, self::MAX],
        [MysqlVariable::INNODB_STATS_PERSISTENT, self::MIN, self::MAX],
        [MysqlVariable::INNODB_STATS_PERSISTENT_SAMPLE_PAGES, self::MIN, self::MAX],
        [MysqlVariable::INNODB_STATS_TRANSIENT_SAMPLE_PAGES, self::MIN, self::MAX],
        [MysqlVariable::INNODB_STATUS_OUTPUT, 50616, self::MAX],
        [MysqlVariable::INNODB_STATUS_OUTPUT_LOCKS, 50616, self::MAX],
        [MysqlVariable::INNODB_STRICT_MODE, self::MIN, self::MAX],
        [MysqlVariable::INNODB_SYNC_ARRAY_SIZE, self::MIN, self::MAX],
        [MysqlVariable::INNODB_SYNC_SPIN_LOOPS, self::MIN, self::MAX],
        [MysqlVariable::INNODB_SYNC_DEBUG, self::MIN, self::MAX],
        [MysqlVariable::INNODB_TABLE_LOCKS, self::MIN, self::MAX],
        [MysqlVariable::INNODB_TEMP_DATA_FILE_PATH, self::MIN, self::MAX],
        [MysqlVariable::INNODB_TEMP_TABLESPACES_DIR, 80013, self::MAX],
        [MysqlVariable::INNODB_THREAD_CONCURRENCY, self::MIN, self::MAX],
        [MysqlVariable::INNODB_THREAD_SLEEP_DELAY, self::MIN, self::MAX],
        [MysqlVariable::INNODB_TMPDIR, 50629, 50699],
        [MysqlVariable::INNODB_TMPDIR, 50711, self::MAX],
        [MysqlVariable::INNODB_TRX_PURGE_VIEW_UPDATE_ONLY_DEBUG, self::MIN, self::MAX],
        [MysqlVariable::INNODB_TRX_RSEG_N_SLOTS_DEBUG, self::MIN, self::MAX],
        [MysqlVariable::INNODB_UNDO_DIRECTORY, self::MIN, self::MAX],
        [MysqlVariable::INNODB_UNDO_LOG_ENCRYPT, self::MIN, self::MAX],
        [MysqlVariable::INNODB_UNDO_LOG_TRUNCATE, self::MIN, self::MAX],
        [MysqlVariable::INNODB_UNDO_TABLESPACES, self::MIN, self::MAX],
        [MysqlVariable::INNODB_USE_FDATASYNC, self::MIN, self::MAX],
        [MysqlVariable::INNODB_USE_NATIVE_AIO, self::MIN, self::MAX],
        [MysqlVariable::INNODB_VALIDATE_TABLESPACE_PATHS, 80021, self::MAX],
        [MysqlVariable::INNODB_VERSION, self::MIN, self::MAX],
        [MysqlVariable::INNODB_WRITE_IO_THREADS, self::MIN, self::MAX],

        // https://dev.mysql.com/doc/refman/8.0/en/keyring-system-variables.html
        [MysqlVariable::KEYRING_AWS_CMK_ID, 50719, self::MAX],
        [MysqlVariable::KEYRING_AWS_CONF_FILE, 50719, self::MAX],
        [MysqlVariable::KEYRING_AWS_DATA_FILE, 50719, self::MAX],
        [MysqlVariable::KEYRING_AWS_REGION, 50719, self::MAX],
        [MysqlVariable::KEYRING_ENCRYPTED_FILE_DATA, 50721, self::MAX],
        [MysqlVariable::KEYRING_ENCRYPTED_FILE_PASSWORD, 50721, self::MAX],
        [MysqlVariable::KEYRING_FILE_DATA, 50711, self::MAX],
        [MysqlVariable::KEYRING_HASHICORP_AUTH_PATH, 80018, self::MAX],
        [MysqlVariable::KEYRING_HASHICORP_CA_PATH, 80018, self::MAX],
        [MysqlVariable::KEYRING_HASHICORP_CACHING, 80018, self::MAX],
        [MysqlVariable::KEYRING_HASHICORP_COMMIT_AUTH_PATH, 80018, self::MAX],
        [MysqlVariable::KEYRING_HASHICORP_COMMIT_CA_PATH, 80018, self::MAX],
        [MysqlVariable::KEYRING_HASHICORP_COMMIT_CACHING, 80018, self::MAX],
        [MysqlVariable::KEYRING_HASHICORP_COMMIT_ROLE_ID, 80018, self::MAX],
        [MysqlVariable::KEYRING_HASHICORP_COMMIT_SERVER_URL, 80018, self::MAX],
        [MysqlVariable::KEYRING_HASHICORP_COMMIT_STORE_PATH, 80018, self::MAX],
        [MysqlVariable::KEYRING_HASHICORP_ROLE_ID, 80018, self::MAX],
        [MysqlVariable::KEYRING_HASHICORP_SECRET_ID, 80018, self::MAX],
        [MysqlVariable::KEYRING_HASHICORP_SERVER_URL, 80018, self::MAX],
        [MysqlVariable::KEYRING_HASHICORP_STORE_PATH, 80018, self::MAX],
        [MysqlVariable::KEYRING_OCI_CA_CERTIFICATE, 80022, self::MAX],
        [MysqlVariable::KEYRING_OCI_COMPARTMENT, 80022, self::MAX],
        [MysqlVariable::KEYRING_OCI_ENCRYPTION_ENDPOINT, 80022, self::MAX],
        [MysqlVariable::KEYRING_OCI_KEY_FILE, 80022, self::MAX],
        [MysqlVariable::KEYRING_OCI_KEY_FINGERPRINT, 80022, self::MAX],
        [MysqlVariable::KEYRING_OCI_MANAGEMENT_ENDPOINT, 80022, self::MAX],
        [MysqlVariable::KEYRING_OCI_MASTER_KEY, 80022, self::MAX],
        [MysqlVariable::KEYRING_OCI_SECRETS_ENDPOINT, 80022, self::MAX],
        [MysqlVariable::KEYRING_OCI_TENANCY, 80022, self::MAX],
        [MysqlVariable::KEYRING_OCI_USER, 80022, self::MAX],
        [MysqlVariable::KEYRING_OCI_VAULTS_ENDPOINT, 80022, self::MAX],
        [MysqlVariable::KEYRING_OCI_VIRTUAL_VAULT, 80022, self::MAX],
        [MysqlVariable::KEYRING_OKV_CONF_DIR, 50712, self::MAX],
        [MysqlVariable::KEYRING_OPERATIONS, 50721, self::MAX],

        // https://dev.mysql.com/doc/refman/8.0/en/lock-order-tool.html
        [MysqlVariable::LOCK_ORDER, 80017, self::MAX],
        [MysqlVariable::LOCK_ORDER_DEBUG_LOOP, 80017, self::MAX],
        [MysqlVariable::LOCK_ORDER_DEBUG_MISSING_ARC, 80017, self::MAX],
        [MysqlVariable::LOCK_ORDER_DEBUG_MISSING_KEY, 80017, self::MAX],
        [MysqlVariable::LOCK_ORDER_DEBUG_MISSING_UNLOCK, 80017, self::MAX],
        [MysqlVariable::LOCK_ORDER_DEPENDENCIES, 80017, self::MAX],
        [MysqlVariable::LOCK_ORDER_EXTRA_DEPENDENCIES, 80017, self::MAX],
        [MysqlVariable::LOCK_ORDER_OUTPUT_DIRECTORY, 80017, self::MAX],
        [MysqlVariable::LOCK_ORDER_PRINT_TXT, 80017, self::MAX],
        [MysqlVariable::LOCK_ORDER_TRACE_LOOP, 80017, self::MAX],
        [MysqlVariable::LOCK_ORDER_TRACE_MISSING_ARC, 80017, self::MAX],
        [MysqlVariable::LOCK_ORDER_TRACE_MISSING_KEY, 80017, self::MAX],
        [MysqlVariable::LOCK_ORDER_TRACE_MISSING_UNLOCK, 80017, self::MAX],

        // https://dev.mysql.com/doc/refman/8.0/en/mysql-cluster-options-variables.html
        [MysqlVariable::CREATE_OLD_TEMPORALS, 50625, 50699, 50625],
        [MysqlVariable::NDBINFO_DATABASE, self::MIN, self::MAX],
        [MysqlVariable::NDBINFO_MAX_BYTES, self::MIN, self::MAX],
        [MysqlVariable::NDBINFO_MAX_ROWS, self::MIN, self::MAX],
        [MysqlVariable::NDBINFO_OFFLINE, self::MIN, self::MAX],
        [MysqlVariable::NDBINFO_SHOW_HIDDEN, self::MIN, self::MAX],
        [MysqlVariable::NDBINFO_TABLE_PREFIX, self::MIN, self::MAX],
        [MysqlVariable::NDBINFO_VERSION, self::MIN, self::MAX],
        [MysqlVariable::NDB_ALLOW_COPYING_ALTER_TABLE, 50710, self::MAX],
        [MysqlVariable::NDB_APPLIER_ALLOW_SKIP_EPOCH, 80028, self::MAX],
        [MysqlVariable::NDB_AUTOINCREMENT_PREFETCH_SZ, self::MIN, self::MAX],
        [MysqlVariable::NDB_BATCH_SIZE, self::MIN, self::MAX],
        [MysqlVariable::NDB_BLOB_READ_BATCH_BYTES, self::MIN, self::MAX],
        [MysqlVariable::NDB_BLOB_WRITE_BATCH_BYTES, self::MIN, self::MAX],
        [MysqlVariable::NDB_CACHE_CHECK_TIME, self::MIN, 80000],
        [MysqlVariable::NDB_CLEAR_APPLY_STATUS, 50628, self::MAX],
        [MysqlVariable::NDB_CLUSTER_CONNECTION_POOL, self::MIN, self::MAX],
        [MysqlVariable::NDB_CLUSTER_CONNECTION_POOL_NODEIDS, 50710, self::MAX],
        [MysqlVariable::NDB_CONFLICT_ROLE, 80023, self::MAX],
        [MysqlVariable::NDB_DATA_NODE_NEIGHBOUR, 50712, self::MAX],
        [MysqlVariable::NDB_DBG_CHECK_SHARES, 80013, self::MAX],
        [MysqlVariable::NDB_DEFAULT_COLUMN_FORMAT, 50711, self::MAX],
        [MysqlVariable::NDB_DEFERRED_CONSTRAINTS, self::MIN, self::MAX],
        [MysqlVariable::NDB_DISTRIBUTION, self::MIN, self::MAX],
        [MysqlVariable::NDB_EVENTBUFFER_FREE_PERCENT, 50622, self::MAX],
        [MysqlVariable::NDB_EVENTBUFFER_MAX_ALLOC, 50614, self::MAX],
        [MysqlVariable::NDB_EXTRA_LOGGING, self::MIN, self::MAX],
        [MysqlVariable::NDB_FORCE_SEND, self::MIN, self::MAX],
        [MysqlVariable::NDB_FULLY_REPLICATED, 50712, self::MAX],
        [MysqlVariable::NDB_INDEX_STAT_ENABLE, self::MIN, self::MAX],
        [MysqlVariable::NDB_INDEX_STAT_OPTION, self::MIN, self::MAX],
        [MysqlVariable::NDB_JOIN_PUSHDOWN, self::MIN, self::MAX],
        [MysqlVariable::NDB_LOG_APPLY_STATUS, self::MIN, self::MAX],
        [MysqlVariable::NDB_LOG_BIN, self::MIN, self::MAX],
        [MysqlVariable::NDB_LOG_BINLOG_INDEX, self::MIN, self::MAX],
        [MysqlVariable::NDB_LOG_EMPTY_EPOCHS, self::MIN, self::MAX],
        [MysqlVariable::NDB_LOG_EMPTY_UPDATE, self::MIN, self::MAX],
        [MysqlVariable::NDB_LOG_EXCLUSIVE_READS, 50620, self::MAX],
        [MysqlVariable::NDB_LOG_FAIL_TERMINATE, 50647, 50699],
        [MysqlVariable::NDB_LOG_FAIL_TERMINATE, 50729, 50799],
        [MysqlVariable::NDB_LOG_FAIL_TERMINATE, 80021, self::MAX],
        [MysqlVariable::NDB_LOG_ORIG, self::MIN, self::MAX],
        [MysqlVariable::NDB_LOG_TRANSACTION_COMPRESSION, 80031, self::MAX],
        [MysqlVariable::NDB_LOG_TRANSACTION_COMPRESSION_LEVEL_ZSTD, 80031, self::MAX],
        [MysqlVariable::NDB_LOG_TRANSACTION_DEPENDENCY, 80033, self::MAX],
        [MysqlVariable::NDB_LOG_TRANSACTION_ID, self::MIN, self::MAX],
        [MysqlVariable::NDB_LOG_UPDATE_AS_WRITE, self::MIN, self::MAX],
        [MysqlVariable::NDB_LOG_UPDATE_MINIMAL, 50636, 50699],
        [MysqlVariable::NDB_LOG_UPDATE_MINIMAL, 50718, self::MAX],
        [MysqlVariable::NDB_LOG_UPDATED_ONLY, self::MIN, self::MAX],
        [MysqlVariable::NDB_METADATA_CHECK, 80016, self::MAX],
        [MysqlVariable::NDB_METADATA_CHECK_INTERVAL, 80016, self::MAX],
        [MysqlVariable::NDB_METADATA_SYNC, 80019, self::MAX],
        [MysqlVariable::NDB_OPTIMIZATION_DELAY, self::MIN, self::MAX],
        [MysqlVariable::NDB_OPTIMIZED_NODE_SELECTION, self::MIN, self::MAX],
        [MysqlVariable::NDB_READ_BACKUP, 50712, self::MAX],
        [MysqlVariable::NDB_RECV_THREAD_ACTIVATION_THRESHOLD, 50610, self::MAX],
        [MysqlVariable::NDB_RECV_THREAD_CPU_MASK, 50610, self::MAX],
        [MysqlVariable::NDB_REPLICA_BATCH_SIZE, 80030, self::MAX],
        [MysqlVariable::NDB_REPLICA_BLOB_WRITE_BATCH_BYTES, 80030, self::MAX],
        [MysqlVariable::NDB_REPORT_THRESH_BINLOG_EPOCH_SLIP, self::MIN, self::MAX],
        [MysqlVariable::NDB_REPORT_THRESH_BINLOG_MEM_USAGE, self::MIN, self::MAX],
        [MysqlVariable::NDB_ROW_CHECKSUM, 50723, self::MAX],
        [MysqlVariable::NDB_SCHEMA_DIST_LOCK_WAIT_TIMEOUT, 80018, self::MAX],
        [MysqlVariable::NDB_SCHEMA_DIST_TIMEOUT, 80016, self::MAX],
        [MysqlVariable::NDB_SCHEMA_DIST_UPGRADE_ALLOWED, 80017, self::MAX],
        [MysqlVariable::NDB_SHOW_FOREIGN_KEY_MOCK_TABLES, 50611, self::MAX],
        [MysqlVariable::NDB_SLAVE_CONFLICT_ROLE, 50620, self::MAX],
        [MysqlVariable::NDB_TABLE_NO_LOGGING, self::MIN, self::MAX],
        [MysqlVariable::NDB_TABLE_TEMPORARY, self::MIN, self::MAX],
        [MysqlVariable::NDB_USE_COPYING_ALTER_TABLE, self::MIN, self::MAX],
        [MysqlVariable::NDB_USE_EXACT_COUNT, self::MIN, self::MAX],
        [MysqlVariable::NDB_USE_TRANSACTIONS, self::MIN, self::MAX],
        [MysqlVariable::NDB_VERSION, self::MIN, self::MAX],
        [MysqlVariable::NDB_VERSION_STRING, self::MIN, self::MAX],
        [MysqlVariable::NDB_WAIT_CONNECTED, self::MIN, self::MAX],
        [MysqlVariable::NDB_WAIT_SETUP, self::MIN, self::MAX],
        [MysqlVariable::REPLICA_ALLOW_BATCHING, 80026, self::MAX],
        [MysqlVariable::SERVER_ID_BITS, self::MIN, self::MAX],
        [MysqlVariable::SLAVE_ALLOW_BATCHING, self::MIN, self::MAX],
        [MysqlVariable::TRANSACTION_ALLOW_BATCHING, self::MIN, self::MAX],

        // https://dev.mysql.com/doc/refman/8.0/en/replication-options-source.html
        [MysqlVariable::AUTO_INCREMENT_INCREMENT, self::MIN, self::MAX],
        [MysqlVariable::AUTO_INCREMENT_OFFSET, self::MIN, self::MAX],
        [MysqlVariable::IMMEDIATE_SERVER_VERSION, 80014, self::MAX],
        [MysqlVariable::ORIGINAL_SERVER_VERSION, 80014, self::MAX],
        [MysqlVariable::RPL_SEMI_SYNC_MASTER_ENABLED, self::MIN, self::MAX],
        [MysqlVariable::RPL_SEMI_SYNC_MASTER_TIMEOUT, self::MIN, self::MAX],
        [MysqlVariable::RPL_SEMI_SYNC_MASTER_TRACE_LEVEL, self::MIN, self::MAX],
        [MysqlVariable::RPL_SEMI_SYNC_MASTER_WAIT_FOR_SLAVE_COUNT, self::MIN, self::MAX],
        [MysqlVariable::RPL_SEMI_SYNC_MASTER_WAIT_NO_SLAVE, self::MIN, self::MAX],
        [MysqlVariable::RPL_SEMI_SYNC_MASTER_WAIT_POINT, self::MIN, self::MAX],
        [MysqlVariable::RPL_SEMI_SYNC_SOURCE_ENABLED, 80026, self::MAX],
        [MysqlVariable::RPL_SEMI_SYNC_SOURCE_TIMEOUT, 80026, self::MAX],
        [MysqlVariable::RPL_SEMI_SYNC_SOURCE_TRACE_LEVEL, 80026, self::MAX],
        [MysqlVariable::RPL_SEMI_SYNC_SOURCE_WAIT_FOR_REPLICA_COUNT, 80026, self::MAX],
        [MysqlVariable::RPL_SEMI_SYNC_SOURCE_WAIT_NO_REPLICA, 80026, self::MAX],
        [MysqlVariable::RPL_SEMI_SYNC_SOURCE_WAIT_POINT, 80026, self::MAX],

        // https://dev.mysql.com/doc/refman/8.0/en/replication-options-replica.html
        [MysqlVariable::INIT_REPLICA, 80026, self::MAX],
        [MysqlVariable::INIT_SLAVE, self::MIN, self::MAX],
        [MysqlVariable::LOG_SLOW_REPLICA_STATEMENTS, 80026, self::MAX],
        [MysqlVariable::LOG_SLOW_SLAVE_STATEMENTS, 50611, self::MAX],
        [MysqlVariable::MASTER_INFO_REPOSITORY, self::MIN, self::MAX],
        [MysqlVariable::MAX_RELAY_LOG_SIZE, self::MIN, self::MAX],
        [MysqlVariable::RELAY_LOG, self::MIN, self::MAX],
        [MysqlVariable::RELAY_LOG_BASENAME, self::MIN, self::MAX],
        [MysqlVariable::RELAY_LOG_INDEX, self::MIN, self::MAX],
        [MysqlVariable::RELAY_LOG_INFO_FILE, self::MIN, self::MAX],
        [MysqlVariable::RELAY_LOG_INFO_REPOSITORY, self::MIN, self::MAX],
        [MysqlVariable::RELAY_LOG_PURGE, self::MIN, self::MAX],
        [MysqlVariable::RELAY_LOG_RECOVERY, self::MIN, self::MAX],
        [MysqlVariable::RELAY_LOG_SPACE_LIMIT, self::MIN, self::MAX],
        [MysqlVariable::REPLICA_CHECKPOINT_GROUP, 80026, self::MAX],
        [MysqlVariable::REPLICA_CHECKPOINT_PERIOD, 80026, self::MAX],
        [MysqlVariable::REPLICA_COMPRESSED_PROTOCOL, 80026, self::MAX],
        [MysqlVariable::REPLICA_EXEC_MODE, 80026, self::MAX],
        [MysqlVariable::REPLICA_LOAD_TMPDIR, 80026, self::MAX],
        [MysqlVariable::REPLICA_MAX_ALLOWED_PACKET, 80026, self::MAX],
        [MysqlVariable::REPLICA_NET_TIMEOUT, 80026, self::MAX],
        [MysqlVariable::REPLICA_PARALLEL_TYPE, 80026, self::MAX],
        [MysqlVariable::REPLICA_PARALLEL_WORKERS, 80026, self::MAX],
        [MysqlVariable::REPLICA_PENDING_JOBS_SIZE_MAX, 80026, self::MAX],
        [MysqlVariable::REPLICA_PRESERVE_COMMIT_ORDER, 80026, self::MAX],
        [MysqlVariable::REPLICA_SKIP_ERRORS, 80026, self::MAX],
        [MysqlVariable::REPLICA_SQL_VERIFY_CHECKSUM, 80026, self::MAX],
        [MysqlVariable::REPLICA_TRANSACTION_RETRIES, 80026, self::MAX],
        [MysqlVariable::REPLICA_TYPE_CONVERSIONS, 80026, self::MAX],
        [MysqlVariable::REPLICATION_OPTIMIZE_FOR_STATIC_PLUGIN_CONFIG, 50733, 50799],
        [MysqlVariable::REPLICATION_OPTIMIZE_FOR_STATIC_PLUGIN_CONFIG, 80023, self::MAX],
        [MysqlVariable::REPLICATION_SENDER_OBSERVE_COMMIT_ONLY, 50733, 50799],
        [MysqlVariable::REPLICATION_SENDER_OBSERVE_COMMIT_ONLY, 80023, self::MAX],
        [MysqlVariable::REPORT_HOST, self::MIN, self::MAX],
        [MysqlVariable::REPORT_PASSWORD, self::MIN, self::MAX],
        [MysqlVariable::REPORT_PORT, self::MIN, self::MAX],
        [MysqlVariable::REPORT_USER, self::MIN, self::MAX],
        [MysqlVariable::RPL_READ_SIZE, self::MIN, self::MAX],
        [MysqlVariable::RPL_SEMI_SYNC_REPLICA_ENABLED, 80026, self::MAX],
        [MysqlVariable::RPL_SEMI_SYNC_REPLICA_TRACE_LEVEL, 80026, self::MAX],
        [MysqlVariable::RPL_SEMI_SYNC_SLAVE_ENABLED, self::MIN, self::MAX],
        [MysqlVariable::RPL_SEMI_SYNC_SLAVE_TRACE_LEVEL, self::MIN, self::MAX],
        [MysqlVariable::RPL_STOP_REPLICA_TIMEOUT, 80026, self::MAX],
        [MysqlVariable::RPL_STOP_SLAVE_TIMEOUT, 50611, self::MAX],
        [MysqlVariable::SKIP_REPLICA_START, 80026, self::MAX],
        [MysqlVariable::SKIP_SLAVE_START, self::MIN, self::MAX],
        [MysqlVariable::SLAVE_CHECKPOINT_GROUP, self::MIN, self::MAX],
        [MysqlVariable::SLAVE_CHECKPOINT_PERIOD, self::MIN, self::MAX],
        [MysqlVariable::SLAVE_COMPRESSED_PROTOCOL, self::MIN, self::MAX],
        [MysqlVariable::SLAVE_EXEC_MODE, self::MIN, self::MAX],
        [MysqlVariable::SLAVE_LOAD_TMPDIR, self::MIN, self::MAX],
        [MysqlVariable::SLAVE_MAX_ALLOWED_PACKET, self::MIN, self::MAX],
        [MysqlVariable::SLAVE_NET_TIMEOUT, self::MIN, self::MAX],
        [MysqlVariable::SLAVE_PARALLEL_TYPE, self::MIN, self::MAX],
        [MysqlVariable::SLAVE_PARALLEL_WORKERS, self::MIN, self::MAX],
        [MysqlVariable::SLAVE_PENDING_JOBS_SIZE_MAX, self::MIN, self::MAX],
        [MysqlVariable::SLAVE_PRESERVE_COMMIT_ORDER, self::MIN, self::MAX],
        [MysqlVariable::SLAVE_ROWS_SEARCH_ALGORITHMS, self::MIN, self::MAX],
        [MysqlVariable::SLAVE_SKIP_ERRORS, self::MIN, self::MAX],
        [MysqlVariable::SLAVE_SQL_VERIFY_CHECKSUM, self::MIN, self::MAX],
        [MysqlVariable::SLAVE_TRANSACTION_RETRIES, self::MIN, self::MAX],
        [MysqlVariable::SLAVE_TYPE_CONVERSIONS, self::MIN, self::MAX],
        [MysqlVariable::SQL_REPLICA_SKIP_COUNTER, 80026, self::MAX],
        [MysqlVariable::SQL_SLAVE_SKIP_COUNTER, self::MIN, self::MAX],
        [MysqlVariable::SYNC_MASTER_INFO, self::MIN, self::MAX],
        [MysqlVariable::SYNC_RELAY_LOG, self::MIN, self::MAX],
        [MysqlVariable::SYNC_RELAY_LOG_INFO, self::MIN, self::MAX],
        [MysqlVariable::SYNC_SOURCE_INFO, 80026, self::MAX],
        [MysqlVariable::TERMINOLOGY_USE_PREVIOUS, 80026, self::MAX],

        // https://dev.mysql.com/doc/refman/8.0/en/performance-schema-system-variables.html
        [MysqlVariable::PERFORMANCE_SCHEMA, self::MIN, self::MAX],
        [MysqlVariable::PERFORMANCE_SCHEMA_ACCOUNTS_SIZE, self::MIN, self::MAX],
        [MysqlVariable::PERFORMANCE_SCHEMA_DIGESTS_SIZE, self::MIN, self::MAX],
        [MysqlVariable::PERFORMANCE_SCHEMA_ERROR_SIZE, self::MIN, self::MAX],
        [MysqlVariable::PERFORMANCE_SCHEMA_EVENTS_STAGES_HISTORY_LONG_SIZE, self::MIN, self::MAX],
        [MysqlVariable::PERFORMANCE_SCHEMA_EVENTS_STAGES_HISTORY_SIZE, self::MIN, self::MAX],
        [MysqlVariable::PERFORMANCE_SCHEMA_EVENTS_STATEMENTS_HISTORY_LONG_SIZE, self::MIN, self::MAX],
        [MysqlVariable::PERFORMANCE_SCHEMA_EVENTS_STATEMENTS_HISTORY_SIZE, self::MIN, self::MAX],
        [MysqlVariable::PERFORMANCE_SCHEMA_EVENTS_TRANSACTIONS_HISTORY_LONG_SIZE, self::MIN, self::MAX],
        [MysqlVariable::PERFORMANCE_SCHEMA_EVENTS_TRANSACTIONS_HISTORY_SIZE, self::MIN, self::MAX],
        [MysqlVariable::PERFORMANCE_SCHEMA_EVENTS_WAITS_HISTORY_LONG_SIZE, self::MIN, self::MAX],
        [MysqlVariable::PERFORMANCE_SCHEMA_EVENTS_WAITS_HISTORY_SIZE, self::MIN, self::MAX],
        [MysqlVariable::PERFORMANCE_SCHEMA_HOSTS_SIZE, self::MIN, self::MAX],
        [MysqlVariable::PERFORMANCE_SCHEMA_MAX_COND_CLASSES, self::MIN, self::MAX],
        [MysqlVariable::PERFORMANCE_SCHEMA_MAX_COND_INSTANCES, self::MIN, self::MAX],
        [MysqlVariable::PERFORMANCE_SCHEMA_MAX_DIGEST_LENGTH, self::MIN, self::MAX],
        [MysqlVariable::PERFORMANCE_SCHEMA_MAX_DIGEST_SAMPLE_AGE, self::MIN, self::MAX],
        [MysqlVariable::PERFORMANCE_SCHEMA_MAX_FILE_CLASSES, self::MIN, self::MAX],
        [MysqlVariable::PERFORMANCE_SCHEMA_MAX_FILE_HANDLES, self::MIN, self::MAX],
        [MysqlVariable::PERFORMANCE_SCHEMA_MAX_FILE_INSTANCES, self::MIN, self::MAX],
        [MysqlVariable::PERFORMANCE_SCHEMA_MAX_INDEX_STAT, self::MIN, self::MAX],
        [MysqlVariable::PERFORMANCE_SCHEMA_MAX_MEMORY_CLASSES, self::MIN, self::MAX],
        [MysqlVariable::PERFORMANCE_SCHEMA_MAX_METADATA_LOCKS, self::MIN, self::MAX],
        [MysqlVariable::PERFORMANCE_SCHEMA_MAX_MUTEX_CLASSES, self::MIN, self::MAX],
        [MysqlVariable::PERFORMANCE_SCHEMA_MAX_MUTEX_INSTANCES, self::MIN, self::MAX],
        [MysqlVariable::PERFORMANCE_SCHEMA_MAX_PREPARED_STATEMENTS_INSTANCES, self::MIN, self::MAX],
        [MysqlVariable::PERFORMANCE_SCHEMA_MAX_RWLOCK_CLASSES, self::MIN, self::MAX],
        [MysqlVariable::PERFORMANCE_SCHEMA_MAX_RWLOCK_INSTANCES, self::MIN, self::MAX],
        [MysqlVariable::PERFORMANCE_SCHEMA_MAX_PROGRAM_INSTANCES, self::MIN, self::MAX],
        [MysqlVariable::PERFORMANCE_SCHEMA_MAX_SOCKET_CLASSES, self::MIN, self::MAX],
        [MysqlVariable::PERFORMANCE_SCHEMA_MAX_SOCKET_INSTANCES, self::MIN, self::MAX],
        [MysqlVariable::PERFORMANCE_SCHEMA_MAX_SQL_TEXT_LENGTH, self::MIN, self::MAX],
        [MysqlVariable::PERFORMANCE_SCHEMA_MAX_STAGE_CLASSES, self::MIN, self::MAX],
        [MysqlVariable::PERFORMANCE_SCHEMA_MAX_STATEMENT_CLASSES, self::MIN, self::MAX],
        [MysqlVariable::PERFORMANCE_SCHEMA_MAX_STATEMENT_STACK, self::MIN, self::MAX],
        [MysqlVariable::PERFORMANCE_SCHEMA_MAX_TABLE_HANDLES, self::MIN, self::MAX],
        [MysqlVariable::PERFORMANCE_SCHEMA_MAX_TABLE_INSTANCES, self::MIN, self::MAX],
        [MysqlVariable::PERFORMANCE_SCHEMA_MAX_TABLE_LOCK_STAT, self::MIN, self::MAX],
        [MysqlVariable::PERFORMANCE_SCHEMA_MAX_THREAD_CLASSES, self::MIN, self::MAX],
        [MysqlVariable::PERFORMANCE_SCHEMA_MAX_THREAD_INSTANCES, self::MIN, self::MAX],
        [MysqlVariable::PERFORMANCE_SCHEMA_SESSION_CONNECT_ATTRS_SIZE, self::MIN, self::MAX],
        [MysqlVariable::PERFORMANCE_SCHEMA_SETUP_ACTORS_SIZE, self::MIN, self::MAX],
        [MysqlVariable::PERFORMANCE_SCHEMA_SETUP_OBJECTS_SIZE, self::MIN, self::MAX],
        [MysqlVariable::PERFORMANCE_SCHEMA_SHOW_PROCESSLIST, 50739, 50799],
        [MysqlVariable::PERFORMANCE_SCHEMA_SHOW_PROCESSLIST, 80022, self::MAX],
        [MysqlVariable::PERFORMANCE_SCHEMA_USERS_SIZE, self::MIN, self::MAX],

        // https://dev.mysql.com/doc/refman/8.0/en/validate-password-options-variables.html
        [MysqlVariable::VALIDATE_PASSWORD__CHECK_USER_NAME, self::MIN, self::MAX],
        [MysqlVariable::VALIDATE_PASSWORD__DICTIONARY_FILE, self::MIN, self::MAX],
        [MysqlVariable::VALIDATE_PASSWORD__LENGTH, self::MIN, self::MAX],
        [MysqlVariable::VALIDATE_PASSWORD__MIXED_CASE_COUNT, self::MIN, self::MAX],
        [MysqlVariable::VALIDATE_PASSWORD__NUMBER_COUNT, self::MIN, self::MAX],
        [MysqlVariable::VALIDATE_PASSWORD__POLICY, self::MIN, self::MAX],
        [MysqlVariable::VALIDATE_PASSWORD__SPECIAL_CHAR_COUNT, self::MIN, self::MAX],
        [MysqlVariable::VALIDATE_PASSWORD_CHECK_USER_NAME, 50715, self::MAX],
        [MysqlVariable::VALIDATE_PASSWORD_DICTIONARY_FILE, self::MIN, self::MAX],
        [MysqlVariable::VALIDATE_PASSWORD_LENGTH, self::MIN, self::MAX],
        [MysqlVariable::VALIDATE_PASSWORD_MIXED_CASE_COUNT, self::MIN, self::MAX],
        [MysqlVariable::VALIDATE_PASSWORD_NUMBER_COUNT, self::MIN, self::MAX],
        [MysqlVariable::VALIDATE_PASSWORD_POLICY, self::MIN, self::MAX],
        [MysqlVariable::VALIDATE_PASSWORD_SPECIAL_CHAR_COUNT, self::MIN, self::MAX],

        // https://dev.mysql.com/doc/refman/8.0/en/version-tokens-reference.html
        [MysqlVariable::VERSION_TOKENS_SESSION, 50700, self::MAX],
        [MysqlVariable::VERSION_TOKENS_SESSION_NUMBER, 50700, self::MAX],

        // https://dev.mysql.com/doc/refman/8.0/en/x-plugin-options-system-variables.html
        [MysqlVariable::MYSQLX_BIND_ADDRESS, 50717, self::MAX],
        [MysqlVariable::MYSQLX_COMPRESSION_ALGORITHMS, 80019, self::MAX],
        [MysqlVariable::MYSQLX_CONNECT_TIMEOUT, 50712, self::MAX],
        [MysqlVariable::MYSQLX_DEFLATE_DEFAULT_COMPRESSION_LEVEL, 80020, self::MAX],
        [MysqlVariable::MYSQLX_DEFLATE_MAX_CLIENT_COMPRESSION_LEVEL, 80020, self::MAX],
        [MysqlVariable::MYSQLX_DOCUMENT_ID_UNIQUE_PREFIX, self::MIN, self::MAX],
        [MysqlVariable::MYSQLX_ENABLE_HELLO_NOTICE, self::MIN, self::MAX],
        [MysqlVariable::MYSQLX_IDLE_WORKER_THREAD_TIMEOUT, 50712, self::MAX],
        [MysqlVariable::MYSQLX_INTERACTIVE_TIMEOUT, self::MIN, self::MAX],
        [MysqlVariable::MYSQLX_LZ4_DEFAULT_COMPRESSION_LEVEL, 80020, self::MAX],
        [MysqlVariable::MYSQLX_LZ4_MAX_CLIENT_COMPRESSION_LEVEL, 80020, self::MAX],
        [MysqlVariable::MYSQLX_MAX_ALLOWED_PACKET, 50712, self::MAX],
        [MysqlVariable::MYSQLX_MAX_CONNECTIONS, 50712, self::MAX],
        [MysqlVariable::MYSQLX_MIN_WORKER_THREADS, 50712, self::MAX],
        [MysqlVariable::MYSQLX_PORT, 50712, self::MAX],
        [MysqlVariable::MYSQLX_PORT_OPEN_TIMEOUT, 50717, self::MAX],
        [MysqlVariable::MYSQLX_READ_TIMEOUT, self::MIN, self::MAX],
        [MysqlVariable::MYSQLX_SOCKET, 50715, self::MAX],
        [MysqlVariable::MYSQLX_SSL_CA, 50712, self::MAX],
        [MysqlVariable::MYSQLX_SSL_CAPATH, 50712, self::MAX],
        [MysqlVariable::MYSQLX_SSL_CERT, 50712, self::MAX],
        [MysqlVariable::MYSQLX_SSL_CIPHER, 50712, self::MAX],
        [MysqlVariable::MYSQLX_SSL_CRL, 50712, self::MAX],
        [MysqlVariable::MYSQLX_SSL_CRLPATH, 50712, self::MAX],
        [MysqlVariable::MYSQLX_SSL_KEY, 50712, self::MAX],
        [MysqlVariable::MYSQLX_WAIT_TIMEOUT, self::MIN, self::MAX],
        [MysqlVariable::MYSQLX_WRITE_TIMEOUT, self::MIN, self::MAX],
        [MysqlVariable::MYSQLX_ZSTD_DEFAULT_COMPRESSION_LEVEL, 80020, self::MAX],
        [MysqlVariable::MYSQLX_ZSTD_MAX_CLIENT_COMPRESSION_LEVEL, 80020, self::MAX],
    ];

    /** @var list<array{class-string<Command>, int, int}> */
    public array $preparableCommands = [
        // https://dev.mysql.com/doc/refman/8.0/en/sql-prepared-statements.html (terribly incomplete)
        [AlterTableCommand::class, self::MIN, self::MAX],
        [AlterUserCommand::class, self::MIN, self::MAX],
        [AnalyzeTableCommand::class, self::MIN, self::MAX],
        [AnalyzeTableDropHistogramCommand::class, self::MIN, self::MAX],
        [AnalyzeTableUpdateHistogramCommand::class, self::MIN, self::MAX],
        [CacheIndexCommand::class, self::MIN, self::MAX],
        [CallCommand::class, self::MIN, self::MAX],
        [ChangeMasterToCommand::class, self::MIN, self::MAX],
        [ChecksumTableCommand::class, self::MIN, self::MAX],
        [CommitCommand::class, self::MIN, self::MAX],
        [CreateIndexCommand::class, self::MIN, self::MAX],
        [CreateSchemaCommand::class, self::MIN, self::MAX],
        [CreateTableCommand::class, self::MIN, self::MAX],
        [CreateTableLikeCommand::class, self::MIN, self::MAX],
        [CreateUserCommand::class, self::MIN, self::MAX],
        [CreateViewCommand::class, self::MIN, self::MAX],
        [DeleteCommand::class, self::MIN, self::MAX],
        [DescribeTableCommand::class, self::MIN, self::MAX],
        [DoCommand::class, self::MIN, self::MAX],
        [DropIndexCommand::class, self::MIN, self::MAX],
        [DropSchemaCommand::class, self::MIN, self::MAX],
        [DropTableCommand::class, self::MIN, self::MAX],
        [DropUserCommand::class, self::MIN, self::MAX],
        [DropViewCommand::class, self::MIN, self::MAX],
        [ExplainStatementCommand::class, self::MIN, self::MAX],
        [FlushCommand::class, self::MIN, self::MAX],
        [FlushTablesCommand::class, self::MIN, self::MAX],
        [GrantCommand::class, self::MIN, self::MAX],
        [InsertCommand::class, self::MIN, self::MAX],
        [InsertSelectCommand::class, self::MIN, self::MAX],
        [InsertSetCommand::class, self::MIN, self::MAX],
        [InsertValuesCommand::class, self::MIN, self::MAX],
        [InstallPluginCommand::class, self::MIN, self::MAX],
        [KillCommand::class, self::MIN, self::MAX],
        [LoadIndexIntoCacheCommand::class, self::MIN, self::MAX],
        [OptimizeTableCommand::class, self::MIN, self::MAX],
        [ParenthesizedQueryExpression::class, self::MIN, self::MAX],
        [RenameTableCommand::class, self::MIN, self::MAX],
        [RenameUserCommand::class, self::MIN, self::MAX],
        [RepairTableCommand::class, self::MIN, self::MAX],
        [ReplaceSelectCommand::class, self::MIN, self::MAX],
        [ReplaceSetCommand::class, self::MIN, self::MAX],
        [ReplaceValuesCommand::class, self::MIN, self::MAX],
        [ResetMasterCommand::class, self::MIN, self::MAX],
        [ResetReplicaCommand::class, self::MIN, self::MAX],
        [ResetSlaveCommand::class, self::MIN, self::MAX],
        [RevokeAllCommand::class, self::MIN, self::MAX],
        [RevokeCommand::class, self::MIN, self::MAX],
        [RevokeProxyCommand::class, self::MIN, self::MAX],
        [RevokeRoleCommand::class, self::MIN, self::MAX],
        [RollbackCommand::class, self::MIN, self::MAX],
        [SelectCommand::class, self::MIN, self::MAX],
        [SetVariablesCommand::class, self::MIN, self::MAX],
        [SetNamesCommand::class, self::MIN, self::MAX],
        [SetPasswordCommand::class, self::MIN, self::MAX],
        [SetRoleCommand::class, self::MIN, self::MAX],
        [ShowBinaryLogsCommand::class, self::MIN, self::MAX],
        [ShowBinlogEventsCommand::class, self::MIN, self::MAX],
        [ShowCharacterSetCommand::class, self::MIN, self::MAX],
        [ShowCollationCommand::class, self::MIN, self::MAX],
        [ShowColumnsCommand::class, self::MIN, self::MAX],
        [ShowCreateEventCommand::class, self::MIN, self::MAX],
        [ShowCreateFunctionCommand::class, self::MIN, self::MAX],
        [ShowCreateProcedureCommand::class, self::MIN, self::MAX],
        [ShowProcessListCommand::class, self::MIN, self::MAX],
        [ShowCreateSchemaCommand::class, self::MIN, self::MAX],
        [ShowCreateTableCommand::class, self::MIN, self::MAX],
        [ShowCreateTriggerCommand::class, self::MIN, self::MAX],
        [ShowCreateViewCommand::class, self::MIN, self::MAX],
        [ShowEngineCommand::class, self::MIN, self::MAX],
        [ShowEnginesCommand::class, self::MIN, self::MAX],
        [ShowEventsCommand::class, self::MIN, self::MAX],
        [ShowFunctionStatusCommand::class, self::MIN, self::MAX],
        [ShowGrantsCommand::class, self::MIN, self::MAX],
        [ShowIndexesCommand::class, self::MIN, self::MAX],
        [ShowMasterStatusCommand::class, self::MIN, self::MAX],
        [ShowOpenTablesCommand::class, self::MIN, self::MAX],
        [ShowProcedureStatusCommand::class, self::MIN, self::MAX],
        [ShowProfileCommand::class, self::MIN, self::MAX],
        [ShowReplicaStatusCommand::class, self::MIN, self::MAX],
        [ShowSchemasCommand::class, self::MIN, self::MAX],
        [ShowSlaveStatusCommand::class, self::MIN, self::MAX],
        [ShowStatusCommand::class, self::MIN, self::MAX],
        [ShowTablesCommand::class, self::MIN, self::MAX],
        [ShowTableStatusCommand::class, self::MIN, self::MAX],
        [ShowTriggersCommand::class, self::MIN, self::MAX],
        [ShowVariablesCommand::class, self::MIN, self::MAX],
        [StartReplicaCommand::class, self::MIN, self::MAX],
        [StartSlaveCommand::class, self::MIN, self::MAX],
        [StopReplicaCommand::class, self::MIN, self::MAX],
        [StopSlaveCommand::class, self::MIN, self::MAX],
        [TableCommand::class, self::MIN, self::MAX],
        [TruncateTableCommand::class, self::MIN, self::MAX],
        [QueryExpression::class, self::MIN, self::MAX],
        [UninstallPluginCommand::class, self::MIN, self::MAX],
        [UpdateCommand::class, self::MIN, self::MAX],
        [ValuesCommand::class, self::MIN, self::MAX],
    ];

    /** @var array<EntityType::*, int> */
    public array $maxLengths = [
        EntityType::GENERAL => 65535, // limit unknown, but bigger than 64
        EntityType::SCHEMA => 64,
        EntityType::TABLE => 64,
        EntityType::VIEW => 64,
        EntityType::COLUMN => 64,
        EntityType::INDEX => 64,
        EntityType::INDEX_PART => 64, // not documented
        EntityType::INDEX_CACHE => 64, // not documented
        EntityType::INDEX_PARSER => 64, // not documented
        EntityType::CONSTRAINT => 64,
        EntityType::TRIGGER => 64, // not documented
        EntityType::ROUTINE => 64,
        EntityType::EVENT => 64, // not documented
        EntityType::TABLESPACE => 64,
        EntityType::PARTITION => 64, // not documented
        EntityType::SERVER => 64,
        EntityType::PLUGIN => 64, // not documented
        EntityType::LOG_FILE_GROUP => 64,
        EntityType::RESOURCE_GROUP => 64,
        EntityType::SYSTEM_VARIABLE => 64, // not documented
        EntityType::USER => 32,
        EntityType::HOST => 255,
        EntityType::CHANNEL => 64,
        EntityType::SRS => 80,
        EntityType::CHARACTER_SET => 64, // not documented
        EntityType::ENUM_VALUE => 255,
        EntityType::FIELD_COMMENT => 1024,
        EntityType::TABLE_COMMENT => 2048,
        EntityType::INDEX_COMMENT => 1024,

        EntityType::USER_VARIABLE => 64,
        EntityType::USER_LOCK => 64, // not documented
        EntityType::PREPARED_STATEMENT => 64, // not documented
        EntityType::SAVEPOINT => 64, // not documented
        EntityType::XA_TRANSACTION => 64,

        EntityType::PARAMETER => 64, // not documented
        EntityType::LOCAL_VARIABLE => 64, // not documented
        EntityType::CURSOR => 64, // not documented
        EntityType::CONDITION => 64, // not documented

        EntityType::WINDOW => 64, // not documented
        EntityType::CTE => 64, // not documented
        EntityType::QUERY_BLOCK => 64,
        EntityType::ALIAS => 256,
        EntityType::LABEL => 256, // doc says 16, but DB parses anything
        EntityType::ODBC_EXPRESSION_IDENTIFIER => 64, // not documented
    ];

}
