<?php declare(strict_types = 1);
/**
 * This file is part of the SqlFtw library (https://github.com/sqlftw)
 *
 * Copyright (c) 2017 Vlasta Neubauer (@paranoiq)
 *
 * For the full copyright and license information read the file 'license.md', distributed with this source code
 */

namespace SqlFtw\Platform\Features;

use SqlFtw\Sql\Keyword;

class FeaturesSql99 //extends FeaturesList
{

    public const RESERVED_WORDS = [
        Keyword::ABSOLUTE,
        Keyword::ACTION,
        Keyword::ADD,
        Keyword::ADMIN,
        Keyword::AFTER,
        Keyword::AGGREGATE,
        Keyword::ALIAS,
        Keyword::ALL,
        Keyword::ALLOCATE,
        Keyword::ALTER,
        Keyword::AND,
        Keyword::ANY,
        Keyword::ARE,
        Keyword::ARRAY,
        Keyword::AS,
        Keyword::ASC,
        Keyword::ASSERTION,
        Keyword::AT,
        Keyword::AUTHORIZATION,
        Keyword::BEFORE,
        Keyword::BEGIN,
        Keyword::BINARY,
        Keyword::BIT,
        Keyword::BLOB,
        Keyword::BOOLEAN,
        Keyword::BOTH,
        Keyword::BREADTH,
        Keyword::BY,
        Keyword::CALL,
        Keyword::CASCADE,
        Keyword::CASCADED,
        Keyword::CASE,
        Keyword::CAST,
        Keyword::CATALOG,
        Keyword::CHAR,
        Keyword::CHARACTER,
        Keyword::CHECK,
        Keyword::CLASS_KEYWORD,
        Keyword::CLOB,
        Keyword::CLOSE,
        Keyword::COLLATE,
        Keyword::COLLATION,
        Keyword::COLUMN,
        Keyword::COMMIT,
        Keyword::COMPLETION,
        Keyword::CONNECT,
        Keyword::CONNECTION,
        Keyword::CONSTRAINT,
        Keyword::CONSTRAINTS,
        Keyword::CONSTRUCTOR,
        Keyword::CONTINUE,
        Keyword::CORRESPONDING,
        Keyword::CREATE,
        Keyword::CROSS,
        Keyword::CUBE,
        Keyword::CURRENT,
        Keyword::CURRENT_DATE,
        Keyword::CURRENT_PATH,
        Keyword::CURRENT_ROLE,
        Keyword::CURRENT_TIME,
        Keyword::CURRENT_TIMESTAMP,
        Keyword::CURRENT_USER,
        Keyword::CURSOR,
        Keyword::CYCLE,
        Keyword::DATA,
        Keyword::DATE,
        Keyword::DAY,
        Keyword::DEALLOCATE,
        Keyword::DEC,
        Keyword::DECIMAL,
        Keyword::DECLARE,
        Keyword::DEFAULT,
        Keyword::DEFERRABLE,
        Keyword::DEFERRED,
        Keyword::DELETE,
        Keyword::DEPTH,
        Keyword::DEREF,
        Keyword::DESC,
        Keyword::DESCRIBE,
        Keyword::DESCRIPTOR,
        Keyword::DESTROY,
        Keyword::DESTRUCTOR,
        Keyword::DETERMINISTIC,
        Keyword::DICTIONARY,
        Keyword::DIAGNOSTICS,
        Keyword::DISCONNECT,
        Keyword::DISTINCT,
        Keyword::DOMAIN,
        Keyword::DOUBLE,
        Keyword::DROP,
        Keyword::DYNAMIC,
        Keyword::EACH,
        Keyword::ELSE,
        Keyword::END,
        Keyword::END_EXEC,
        Keyword::EQUALS,
        Keyword::ESCAPE,
        Keyword::EVERY,
        Keyword::EXCEPT,
        Keyword::EXCEPTION,
        Keyword::EXEC,
        Keyword::EXECUTE,
        Keyword::EXTERNAL,
        Keyword::FALSE,
        Keyword::FETCH,
        Keyword::FIRST,
        Keyword::FLOAT,
        Keyword::FOR,
        Keyword::FOREIGN,
        Keyword::FOUND,
        Keyword::FROM,
        Keyword::FREE,
        Keyword::FULL,
        Keyword::FUNCTION,
        Keyword::GENERAL,
        Keyword::GET,
        Keyword::GLOBAL,
        Keyword::GO,
        Keyword::GOTO,
        Keyword::GRANT,
        Keyword::GROUP,
        Keyword::GROUPING,
        Keyword::HAVING,
        Keyword::HOST,
        Keyword::HOUR,
        Keyword::IDENTITY,
        Keyword::IGNORE,
        Keyword::IMMEDIATE,
        Keyword::IN,
        Keyword::INDICATOR,
        Keyword::INITIALIZE,
        Keyword::INITIALLY,
        Keyword::INNER,
        Keyword::INOUT,
        Keyword::INPUT,
        Keyword::INSERT,
        Keyword::INT,
        Keyword::INTEGER,
        Keyword::INTERSECT,
        Keyword::INTERVAL,
        Keyword::INTO,
        Keyword::IS,
        Keyword::ISOLATION,
        Keyword::ITERATE,
        Keyword::JOIN,
        Keyword::KEY,
        Keyword::LANGUAGE,
        Keyword::LARGE,
        Keyword::LAST,
        Keyword::LATERAL,
        Keyword::LEADING,
        Keyword::LEFT,
        Keyword::LESS,
        Keyword::LEVEL,
        Keyword::LIKE,
        Keyword::LIMIT,
        Keyword::LOCAL,
        Keyword::LOCALTIME,
        Keyword::LOCALTIMESTAMP,
        Keyword::LOCATOR,
        Keyword::MAP,
        Keyword::MATCH,
        Keyword::MINUTE,
        Keyword::MODIFIES,
        Keyword::MODIFY,
        Keyword::MODULE,
        Keyword::MONTH,
        Keyword::NAMES,
        Keyword::NATIONAL,
        Keyword::NATURAL,
        Keyword::NCHAR,
        Keyword::NCLOB,
        Keyword::NEW,
        Keyword::NEXT,
        Keyword::NO,
        Keyword::NONE,
        Keyword::NOT,
        Keyword::NULL,
        Keyword::NUMERIC,
        Keyword::OBJECT,
        Keyword::OF,
        Keyword::OFF,
        Keyword::OLD,
        Keyword::ON,
        Keyword::ONLY,
        Keyword::OPEN,
        Keyword::OPERATION,
        Keyword::OPTION,
        Keyword::OR,
        Keyword::ORDER,
        Keyword::ORDINALITY,
        Keyword::OUT,
        Keyword::OUTER,
        Keyword::OUTPUT,
        Keyword::PAD,
        Keyword::PARAMETER,
        Keyword::PARAMETERS,
        Keyword::PARTIAL,
        Keyword::PATH,
        Keyword::POSTFIX,
        Keyword::PRECISION,
        Keyword::PREFIX,
        Keyword::PREORDER,
        Keyword::PREPARE,
        Keyword::PRESERVE,
        Keyword::PRIMARY,
        Keyword::PRIOR,
        Keyword::PRIVILEGES,
        Keyword::PROCEDURE,
        Keyword::PUBLIC,
        Keyword::READ,
        Keyword::READS,
        Keyword::REAL,
        Keyword::RECURSIVE,
        Keyword::REF,
        Keyword::REFERENCES,
        Keyword::REFERENCING,
        Keyword::RELATIVE,
        Keyword::RESTRICT,
        Keyword::RESULT,
        Keyword::RETURN,
        Keyword::RETURNS,
        Keyword::REVOKE,
        Keyword::RIGHT,
        Keyword::ROLE,
        Keyword::ROLLBACK,
        Keyword::ROLLUP,
        Keyword::ROUTINE,
        Keyword::ROW,
        Keyword::ROWS,
        Keyword::SAVEPOINT,
        Keyword::SCHEMA,
        Keyword::SCROLL,
        Keyword::SCOPE,
        Keyword::SEARCH,
        Keyword::SECOND,
        Keyword::SECTION,
        Keyword::SELECT,
        Keyword::SEQUENCE,
        Keyword::SESSION,
        Keyword::SESSION_USER,
        Keyword::SET,
        Keyword::SETS,
        Keyword::SIZE,
        Keyword::SMALLINT,
        Keyword::SOME,
        Keyword::SPACE,
        Keyword::SPECIFIC,
        Keyword::SPECIFICTYPE,
        Keyword::SQL,
        Keyword::SQLEXCEPTION,
        Keyword::SQLSTATE,
        Keyword::SQLWARNING,
        Keyword::START,
        Keyword::STATE,
        Keyword::STATEMENT,
        Keyword::STATIC,
        Keyword::STRUCTURE,
        Keyword::SYSTEM_USER,
        Keyword::TABLE,
        Keyword::TEMPORARY,
        Keyword::TERMINATE,
        Keyword::THAN,
        Keyword::THEN,
        Keyword::TIME,
        Keyword::TIMESTAMP,
        Keyword::TIMEZONE_HOUR,
        Keyword::TIMEZONE_MINUTE,
        Keyword::TO,
        Keyword::TRAILING,
        Keyword::TRANSACTION,
        Keyword::TRANSLATION,
        Keyword::TREAT,
        Keyword::TRIGGER,
        Keyword::TRUE,
        Keyword::UNDER,
        Keyword::UNION,
        Keyword::UNIQUE,
        Keyword::UNKNOWN,
        Keyword::UNNEST,
        Keyword::UPDATE,
        Keyword::USAGE,
        Keyword::USER,
        Keyword::USING,
        Keyword::VALUE,
        Keyword::VALUES,
        Keyword::VARCHAR,
        Keyword::VARIABLE,
        Keyword::VARYING,
        Keyword::VIEW,
        Keyword::WHEN,
        Keyword::WHENEVER,
        Keyword::WHERE,
        Keyword::WITH,
        Keyword::WITHOUT,
        Keyword::WORK,
        Keyword::WRITE,
        Keyword::YEAR,
        Keyword::ZONE,
    ];

    public const NON_RESERVED_WORDS = [
        Keyword::ABS,
        Keyword::ADA,
        Keyword::ASENSITIVE,
        Keyword::ASSIGNMENT,
        Keyword::ASYMMETRIC,
        Keyword::ATOMIC,
        Keyword::AVG,
        Keyword::BETWEEN,
        Keyword::BIT_LENGTH,
        Keyword::BITVAR,
        Keyword::C,
        Keyword::CALLED,
        Keyword::CARDINALITY,
        Keyword::CATALOG_NAME,
        Keyword::CHAIN,
        Keyword::CHAR_LENGTH,
        Keyword::CHARACTER_LENGTH,
        Keyword::CHARACTER_SET_CATALOG,
        Keyword::CHARACTER_SET_NAME,
        Keyword::CHARACTER_SET_SCHEMA,
        Keyword::CHECKED,
        Keyword::CLASS_ORIGIN,
        Keyword::COALESCE,
        Keyword::COBOL,
        Keyword::COLLATION_CATALOG,
        Keyword::COLLATION_NAME,
        Keyword::COLLATION_SCHEMA,
        Keyword::COLUMN_NAME,
        Keyword::COMMAND_FUNCTION,
        Keyword::COMMAND_FUNCTION_CODE,
        Keyword::COMMITTED,
        Keyword::CONDITION_NUMBER,
        Keyword::CONNECTION_NAME,
        Keyword::CONSTRAINT_CATALOG,
        Keyword::CONSTRAINT_NAME,
        Keyword::CONSTRAINT_SCHEMA,
        Keyword::CONTAINS,
        Keyword::CONVERT,
        Keyword::COUNT,
        Keyword::CURSOR_NAME,
        Keyword::DATETIME_INTERVAL_CODE,
        Keyword::DATETIME_INTERVAL_PRECISION,
        Keyword::DEFINED,
        Keyword::DEFINER,
        Keyword::DISPATCH,
        Keyword::DYNAMIC_FUNCTION,
        Keyword::DYNAMIC_FUNCTION_CODE,
        Keyword::EXISTING,
        Keyword::EXISTS,
        Keyword::EXTRACT,
        Keyword::FINAL,
        Keyword::FORTRAN,
        Keyword::G,
        Keyword::GENERATED,
        Keyword::GRANTED,
        Keyword::HIERARCHY,
        Keyword::HOLD,
        Keyword::IMPLEMENTATION,
        Keyword::INFIX,
        Keyword::INSENSITIVE,
        Keyword::INSTANCE,
        Keyword::INSTANTIABLE,
        Keyword::INVOKER,
        Keyword::K,
        Keyword::KEY_MEMBER,
        Keyword::KEY_TYPE,
        Keyword::LENGTH,
        Keyword::LOWER,
        Keyword::M,
        Keyword::MAX,
        Keyword::MIN,
        Keyword::MESSAGE_LENGTH,
        Keyword::MESSAGE_OCTET_LENGTH,
        Keyword::MESSAGE_TEXT,
        Keyword::METHOD,
        Keyword::MOD,
        Keyword::MORE,
        Keyword::MUMPS,
        Keyword::NAME,
        Keyword::NULLABLE,
        Keyword::NUMBER,
        Keyword::NULLIF,
        Keyword::OCTET_LENGTH,
        Keyword::OPTIONS,
        Keyword::OVERLAPS,
        Keyword::OVERLAY,
        Keyword::OVERRIDING,
        Keyword::PASCAL,
        Keyword::PARAMETER_MODE,
        Keyword::PARAMETER_NAME,
        Keyword::PARAMETER_ORDINAL_POSITION,
        Keyword::PARAMETER_SPECIFIC_CATALOG,
        Keyword::PARAMETER_SPECIFIC_NAME,
        Keyword::PARAMETER_SPECIFIC_SCHEMA,
        Keyword::PLI,
        Keyword::POSITION,
        Keyword::REPEATABLE,
        Keyword::RETURNED_LENGTH,
        Keyword::RETURNED_OCTET_LENGTH,
        Keyword::RETURNED_SQLSTATE,
        Keyword::ROUTINE_CATALOG,
        Keyword::ROUTINE_NAME,
        Keyword::ROUTINE_SCHEMA,
        Keyword::ROW_COUNT,
        Keyword::SCALE,
        Keyword::SCHEMA_NAME,
        Keyword::SECURITY,
        Keyword::SELF,
        Keyword::SENSITIVE,
        Keyword::SERIALIZABLE,
        Keyword::SERVER_NAME,
        Keyword::SIMPLE,
        Keyword::SOURCE,
        Keyword::SPECIFIC_NAME,
        Keyword::SIMILAR,
        Keyword::SUBLIST,
        Keyword::SUBSTRING,
        Keyword::SUM,
        Keyword::STYLE,
        Keyword::SUBCLASS_ORIGIN,
        Keyword::SYMMETRIC,
        Keyword::SYSTEM,
        Keyword::TABLE_NAME,
        Keyword::TRANSACTIONS_COMMITTED,
        Keyword::TRANSACTIONS_ROLLED_BACK,
        Keyword::TRANSACTION_ACTIVE,
        Keyword::TRANSFORM,
        Keyword::TRANSFORMS,
        Keyword::TRANSLATE,
        Keyword::TRIGGER_CATALOG,
        Keyword::TRIGGER_SCHEMA,
        Keyword::TRIGGER_NAME,
        Keyword::TRIM,
        Keyword::TYPE,
        Keyword::UNCOMMITTED,
        Keyword::UNNAMED,
        Keyword::UPPER,
        Keyword::USER_DEFINED_TYPE_CATALOG,
        Keyword::USER_DEFINED_TYPE_NAME,
        Keyword::USER_DEFINED_TYPE_SCHEMA,
    ];

    /**
     * @return list<string>
     */
    public function getReservedWords(): array
    {
        return self::RESERVED_WORDS;
    }

    /**
     * @return list<string>
     */
    public function getNonReservedWords(): array
    {
        return self::NON_RESERVED_WORDS;
    }

    /**
     * @return list<string>
     */
    public function getOperators(): array
    {
        // todo
        return [];
    }

    /**
     * @return list<string>
     */
    public function getTypes(): array
    {
        // todo
        return [];
    }

    /**
     * @return list<string>
     */
    public function getTypeAliases(): array
    {
        // todo
        return [];
    }

    /**
     * @return list<string>
     */
    public function getBuiltInFunctions(): array
    {
        // todo
        return [];
    }

    /**
     * @return list<string>
     */
    public function getSystemVariables(): array
    {
        // todo
        return [];
    }

}
