<?php declare(strict_types = 1);
/**
 * This file is part of the Dogma library (https://github.com/paranoiq/dogma)
 *
 * Copyright (c) 2012 Vlasta Neubauer (@paranoiq)
 *
 * For the full copyright and license information read the file 'license.md', distributed with this source code
 */

namespace Dogma\Web;

use Dogma\Enum\PartialStringEnum;

class UriScheme extends PartialStringEnum
{

    // IETF
    public const AAA = 'aaa';
    public const AAAS = 'aaas';
    public const ABOUT = 'about';
    public const ACAP = 'acap';
    public const ACCT = 'acct';
    public const ACR = 'acr';
    public const ADIUMXTRA = 'adiumxtra';
    public const AFP = 'afp';
    public const AFS = 'afs';
    public const AIM = 'aim';
    public const APPDATA = 'appdata';
    public const APT = 'apt';
    public const ATTACHMENT = 'attachment';
    public const AW = 'aw';
    public const BARION = 'barion';
    public const BESHARE = 'beshare';
    public const BITCOIN = 'bitcoin';
    public const BLOB = 'blob';
    public const BOLO = 'bolo';
    public const BROWSEREXT = 'browserext';
    public const CALLTO = 'callto';
    public const CAP = 'cap';
    public const CHROME = 'chrome';
    public const CHROME_EXTENSION = 'chrome-extension';
    public const CID = 'cid';
    public const COAP = 'coap';
    public const COAPS = 'coaps';
    public const COM_EVENTBRITE_ATTENDEE = 'com-eventbrite-attendee';
    public const CONTENT = 'content';
    public const CRID = 'crid';
    public const CVS = 'cvs';
    public const DATA = 'data';
    public const DAV = 'dav';
    public const DICT = 'dict';
    public const DIS = 'dis';
    public const DLNA_PLAYCONTAINER = 'dlna-playcontainer';
    public const DLNA_PLAYSINGLE = 'dlna-playsingle';
    public const DNS = 'dns';
    public const DNTP = 'dntp';
    public const DTN = 'dtn';
    public const DVB = 'dvb';
    public const ED2K = 'ed2k';
    public const EXAMPLE = 'example';
    public const FACETIME = 'facetime';
    public const FAX = 'fax';
    public const FEED = 'feed';
    public const FEEDREADY = 'feedready';
    public const FILE = 'file';
    public const FILESYSTEM = 'filesystem';
    public const FINGER = 'finger';
    public const FISH = 'fish';
    public const FTP = 'ftp';
    public const GEO = 'geo';
    public const GG = 'gg';
    public const GIT = 'git';
    public const GIZMOPROJECT = 'gizmoproject';
    public const GO = 'go';
    public const GOPHER = 'gopher';
    public const GTALK = 'gtalk';
    public const H323 = 'h323';
    public const HAM = 'ham';
    public const HCP = 'hcp';
    public const HTTP = 'http';
    public const HTTPS = 'https';
    public const IAX = 'iax';
    public const ICAP = 'icap';
    public const ICON = 'icon';
    public const IM = 'im';
    public const IMAP = 'imap';
    public const INFO = 'info';
    public const IOTDISCO = 'iotdisco';
    public const IPN = 'ipn';
    public const IPP = 'ipp';
    public const IPPS = 'ipps';
    public const IRC = 'irc';
    public const IRC6 = 'irc6';
    public const IRCS = 'ircs';
    public const IRIS = 'iris';
    public const IRIS_BEEP = 'iris.beep';
    public const IRIS_LWZ = 'iris.lwz';
    public const IRIS_XPC = 'iris.xpc';
    public const IRIS_XPCS = 'iris.xpcs';
    public const ISOSTORE = 'isostore';
    public const ITMS = 'itms';
    public const JABBER = 'jabber';
    public const JAR = 'jar';
    public const JMS = 'jms';
    public const KEYPARC = 'keyparc';
    public const LASTFM = 'lastfm';
    public const LDAP = 'ldap';
    public const LDAPS = 'ldaps';
    public const LVLT = 'lvlt';
    public const MAGNET = 'magnet';
    public const MAILSERVER = 'mailserver';
    public const MAILTO = 'mailto';
    public const MAPS = 'maps';
    public const MARKET = 'market';
    public const MESSAGE = 'message';
    public const MID = 'mid';
    public const MMS = 'mms';
    public const MODEM = 'modem';
    public const MOZ = 'moz';
    public const MS_ACCESS = 'ms-access';
    public const MS_BROWSER_EXTENSION = 'ms-browser-extension';
    public const MS_DRIVE_TO = 'ms-drive-to';
    public const MS_ENROLLMENT = 'ms-enrollment';
    public const MS_EXCEL = 'ms-excel';
    public const MS_GAMEBARSERVICES = 'ms-gamebarservices';
    public const MS_GETOFFICE = 'ms-getoffice';
    public const MS_HELP = 'ms-help';
    public const MS_INFOPATH = 'ms-infopath';
    public const MS_MEDIA_STREAM_ID = 'ms-media-stream-id';
    public const MS_PROJECT = 'ms-project';
    public const MS_POWERPOINT = 'ms-powerpoint';
    public const MS_PUBLISHER = 'ms-publisher';
    public const MS_SEARCH_REPAIR = 'ms-search-repair';
    public const MS_SECONDARY_SCREEN_CONTROLLER = 'ms-secondary-screen-controller';
    public const MS_SECONDARY_SCREEN_SETUP = 'ms-secondary-screen-setup';
    public const MS_SETTINGS = 'ms-settings';
    public const MS_SETTINGS_AIRPLANEMODE = 'ms-settings-airplanemode';
    public const MS_SETTINGS_BLUETOOTH = 'ms-settings-bluetooth';
    public const MS_SETTINGS_CAMERA = 'ms-settings-camera';
    public const MS_SETTINGS_CELLULAR = 'ms-settings-cellular';
    public const MS_SETTINGS_CLOUDSTORAGE = 'ms-settings-cloudstorage';
    public const MS_SETTINGS_CONNECTABLEDEVICES = 'ms-settings-connectabledevices';
    public const MS_SETTINGS_DISPLAYS_TOPOLOGY = 'ms-settings-displays-topology';
    public const MS_SETTINGS_EMAILANDACCOUNTS = 'ms-settings-emailandaccounts';
    public const MS_SETTINGS_LANGUAGE = 'ms-settings-language';
    public const MS_SETTINGS_LOCATION = 'ms-settings-location';
    public const MS_SETTINGS_LOCK = 'ms-settings-lock';
    public const MS_SETTINGS_NFCTRANSACTIONS = 'ms-settings-nfctransactions';
    public const MS_SETTINGS_NOTIFICATIONS = 'ms-settings-notifications';
    public const MS_SETTINGS_POWER = 'ms-settings-power';
    public const MS_SETTINGS_PRIVACY = 'ms-settings-privacy';
    public const MS_SETTINGS_PROXIMITY = 'ms-settings-proximity';
    public const MS_SETTINGS_SCREENROTATION = 'ms-settings-screenrotation';
    public const MS_SETTINGS_WIFI = 'ms-settings-wifi';
    public const MS_SETTINGS_WORKPLACE = 'ms-settings-workplace';
    public const MS_SPD = 'ms-spd';
    public const MS_STTOVERLAY = 'ms-sttoverlay';
    public const MS_TRANSIT_TO = 'ms-transit-to';
    public const MS_VIRTUALTOUCHPAD = 'ms-virtualtouchpad';
    public const MS_VISIO = 'ms-visio';
    public const MS_WALK_TO = 'ms-walk-to';
    public const MS_WORD = 'ms-word';
    public const MSNIM = 'msnim';
    public const MSRP = 'msrp';
    public const MSRPS = 'msrps';
    public const MTQP = 'mtqp';
    public const MUMBLE = 'mumble';
    public const MUPDATE = 'mupdate';
    public const MVN = 'mvn';
    public const NEWS = 'news';
    public const NFS = 'nfs';
    public const NI = 'ni';
    public const NIH = 'nih';
    public const NNTP = 'nntp';
    public const NOTES = 'notes';
    public const OCF = 'ocf';
    public const OID = 'oid';
    public const OPAQUELOCKTOKEN = 'opaquelocktoken';
    public const PACK = 'pack';
    public const PALM = 'palm';
    public const PAPARAZZI = 'paparazzi';
    public const PKCS11 = 'pkcs11';
    public const PLATFORM = 'platform';
    public const POP = 'pop';
    public const PRES = 'pres';
    public const PROSPERO = 'prospero';
    public const PROXY = 'proxy';
    public const PWID = 'pwid';
    public const PSYC = 'psyc';
    public const QB = 'qb';
    public const QUERY = 'query';
    public const REDIS = 'redis';
    public const REDISS = 'rediss';
    public const RELOAD = 'reload';
    public const RES = 'res';
    public const RESOURCE = 'resource';
    public const RMI = 'rmi';
    public const RSYNC = 'rsync';
    public const RTMFP = 'rtmfp';
    public const RTMP = 'rtmp';
    public const RTSP = 'rtsp';
    public const RTSPS = 'rtsps';
    public const RTSPU = 'rtspu';
    public const SECONDLIFE = 'secondlife';
    public const SERVICE = 'service';
    public const SESSION = 'session';
    public const SFTP = 'sftp';
    public const SGN = 'sgn';
    public const SHTTP = 'shttp';
    public const SIEVE = 'sieve';
    public const SIP = 'sip';
    public const SIPS = 'sips';
    public const SKYPE = 'skype';
    public const SMB = 'smb';
    public const SMS = 'sms';
    public const SMTP = 'smtp';
    public const SNEWS = 'snews';
    public const SNMP = 'snmp';
    public const SOAP_BEEP = 'soap.beep';
    public const SOAP_BEEPS = 'soap.beeps';
    public const SOLDAT = 'soldat';
    public const SPOTIFY = 'spotify';
    public const SSH = 'ssh';
    public const STEAM = 'steam';
    public const STUN = 'stun';
    public const STUNS = 'stuns';
    public const SUBMIT = 'submit';
    public const SVN = 'svn';
    public const TAG = 'tag';
    public const TEAMSPEAK = 'teamspeak';
    public const TEL = 'tel';
    public const TELIAEID = 'teliaeid';
    public const TELNET = 'telnet';
    public const TFTP = 'tftp';
    public const THINGS = 'things';
    public const THISMESSAGE = 'thismessage';
    public const TIP = 'tip';
    public const TN3270 = 'tn3270';
    public const TOOL = 'tool';
    public const TURN = 'turn';
    public const TURNS = 'turns';
    public const TV = 'tv';
    public const UDP = 'udp';
    public const UNREAL = 'unreal';
    public const URN = 'urn';
    public const UT2004 = 'ut2004';
    public const V_EVENT = 'v-event';
    public const VEMMI = 'vemmi';
    public const VENTRILO = 'ventrilo';
    public const VIDEOTEX = 'videotex';
    public const VNC = 'vnc';
    public const VIEW_SOURCE = 'view-source';
    public const WAIS = 'wais';
    public const WEBCAL = 'webcal';
    public const WPID = 'wpid';
    public const WS = 'ws';
    public const WSS = 'wss';
    public const WTAI = 'wtai';
    public const WYCIWYG = 'wyciwyg';
    public const XCON = 'xcon';
    public const XCON_USERID = 'xcon-userid';
    public const XFIRE = 'xfire';
    public const XMLRPC_BEEP = 'xmlrpc.beep';
    public const XMLRPC_BEEPS = 'xmlrpc.beeps';
    public const XMPP = 'xmpp';
    public const XRI = 'xri';
    public const YMSGR = 'ymsgr';
    public const Z39_50 = 'z39.50';
    public const Z39_50R = 'z39.50r';
    public const Z39_50S = 'z39.50s';

}
