<?php declare(strict_types = 1);
/**
 * This file is part of the Dogma library (https://github.com/paranoiq/dogma)
 *
 * Copyright (c) 2012 Vlasta Neubauer (@paranoiq)
 *
 * For the full copyright and license information read the file 'license.md', distributed with this source code
 */

namespace Dogma\System;

use Dogma\Enum\PartialIntEnum;

/**
 * IANA RFC6335 assigned port numbers
 */
class Port extends PartialIntEnum
{

    public const TCPMUX = 1;
    public const COMPRESSNET = 2;
    public const COMPRESSNET_2 = 3;
    public const RJE = 5;
    public const ECHO = 7;
    public const DISCARD = 9;
    public const SYSTAT = 11;
    public const DAYTIME = 13;
    public const QOTD = 17;
    public const MSP = 18;
    public const CHARGEN = 19;
    public const FTP_DATA = 20;
    public const FTP = 21;
    public const SSH = 22;
    public const TELNET = 23;
    public const SMTP = 25;
    public const NSW_FE = 27;
    public const MSG_ICP = 29;
    public const MSG_AUTH = 31;
    public const DSP = 33;
    public const TIME = 37;
    public const RAP = 38;
    public const RLP = 39;
    public const GRAPHICS = 41;
    public const NAMESERVER = 42;
    public const NICNAME = 43;
    public const MPM_FLAGS = 44;
    public const MPM = 45;
    public const MPM_SND = 46;
    public const AUDITD = 48;
    public const TACACS = 49;
    public const RE_MAIL_CK = 50;
    public const XNS_TIME = 52;
    public const DOMAIN = 53;
    public const XNS_CH = 54;
    public const ISI_GL = 55;
    public const XNS_AUTH = 56;
    public const XNS_MAIL = 58;
    public const ACAS = 62;
    public const WHOISPP = 63;
    public const COVIA = 64;
    public const TACACS_DS = 65;
    public const SQL_NET = 66;
    public const BOOTPS = 67;
    public const BOOTPC = 68;
    public const TFTP = 69;
    public const GOPHER = 70;
    public const NETRJS_1 = 71;
    public const NETRJS_2 = 72;
    public const NETRJS_3 = 73;
    public const NETRJS_4 = 74;
    public const DEOS = 76;
    public const VETTCP = 78;
    public const FINGER = 79;
    public const HTTP = 80;
    public const XFER = 82;
    public const MIT_ML_DEV = 83;
    public const CTF = 84;
    public const MIT_ML_DEV_2 = 85;
    public const MFCOBOL = 86;
    public const KERBEROS = 88;
    public const SU_MIT_TG = 89;
    public const DNSIX = 90;
    public const MIT_DOV = 91;
    public const NPP = 92;
    public const DCP = 93;
    public const OBJCALL = 94;
    public const SUPDUP = 95;
    public const DIXIE = 96;
    public const SWIFT_RVF = 97;
    public const TACNEWS = 98;
    public const METAGRAM = 99;
    public const HOSTNAME = 101;
    public const ISO_TSAP = 102;
    public const GPPITNP = 103;
    public const ACR_NEMA = 104;
    public const CSNET_NS = 105;
    public const _3COM_TSMUX = 106;
    public const RTELNET = 107;
    public const SNAGAS = 108;
    public const POP2 = 109;
    public const POP3 = 110;
    public const SUNRPC = 111;
    public const MCIDAS = 112;
    public const AUTH = 113;
    public const SFTP = 115;
    public const ANSANOTIFY = 116;
    public const UUCP_PATH = 117;
    public const SQLSERV = 118;
    public const NNTP = 119;
    public const CFDPTKT = 120;
    public const ERPC = 121;
    public const SMAKYNET = 122;
    public const NTP = 123;
    public const ANSATRADER = 124;
    public const LOCUS_MAP = 125;
    public const NXEDIT = 126;
    public const LOCUS_CON = 127;
    public const GSS_XLICEN = 128;
    public const PWDGEN = 129;
    public const CISCO_FNA = 130;
    public const CISCO_TNA = 131;
    public const CISCO_SYS = 132;
    public const STATSRV = 133;
    public const INGRES_NET = 134;
    public const EPMAP = 135;
    public const PROFILE = 136;
    public const NETBIOS_NS = 137;
    public const NETBIOS_DGM = 138;
    public const NETBIOS_SSN = 139;
    public const EMFIS_DATA = 140;
    public const EMFIS_CNTL = 141;
    public const BL_IDM = 142;
    public const IMAP = 143;
    public const UMA = 144;
    public const UAAC = 145;
    public const ISO_TP0 = 146;
    public const ISO_IP = 147;
    public const JARGON = 148;
    public const AED_512 = 149;
    public const SQL_NET_2 = 150;
    public const HEMS = 151;
    public const BFTP = 152;
    public const SGMP = 153;
    public const NETSC_PROD = 154;
    public const NETSC_DEV = 155;
    public const SQLSRV = 156;
    public const KNET_CMP = 157;
    public const PCMAIL_SRV = 158;
    public const NSS_ROUTING = 159;
    public const SGMP_TRAPS = 160;
    public const SNMP = 161;
    public const SNMPTRAP = 162;
    public const CMIP_MAN = 163;
    public const CMIP_AGENT = 164;
    public const XNS_COURIER = 165;
    public const S_NET = 166;
    public const NAMP = 167;
    public const RSVD = 168;
    public const SEND = 169;
    public const PRINT_SRV = 170;
    public const MULTIPLEX = 171;
    public const CL_1 = 172;
    public const XYPLEX_MUX = 173;
    public const MAILQ = 174;
    public const VMNET = 175;
    public const GENRAD_MUX = 176;
    public const XDMCP = 177;
    public const NEXTSTEP = 178;
    public const BGP = 179;
    public const RIS = 180;
    public const UNIFY = 181;
    public const AUDIT = 182;
    public const OCBINDER = 183;
    public const OCSERVER = 184;
    public const REMOTE_KIS = 185;
    public const KIS = 186;
    public const ACI = 187;
    public const MUMPS = 188;
    public const QFT = 189;
    public const GACP = 190;
    public const PROSPERO = 191;
    public const OSU_NMS = 192;
    public const SRMP = 193;
    public const IRC = 194;
    public const DN6_NLM_AUD = 195;
    public const DN6_SMM_RED = 196;
    public const DLS = 197;
    public const DLS_MON = 198;
    public const SMUX = 199;
    public const SRC = 200;
    public const AT_RTMP = 201;
    public const AT_NBP = 202;
    public const AT_3 = 203;
    public const AT_ECHO = 204;
    public const AT_5 = 205;
    public const AT_ZIS = 206;
    public const AT_7 = 207;
    public const AT_8 = 208;
    public const QMTP = 209;
    public const Z39_50 = 210;
    public const _914C_G = 211;
    public const ANET = 212;
    public const IPX = 213;
    public const VMPWSCS = 214;
    public const SOFTPC = 215;
    public const CAILIC = 216;
    public const DBASE = 217;
    public const MPP = 218;
    public const UARPS = 219;
    public const IMAP3 = 220;
    public const FLN_SPX = 221;
    public const RSH_SPX = 222;
    public const CDC = 223;
    public const MASQDIALER = 224;
    public const DIRECT = 242;
    public const SUR_MEAS = 243;
    public const INBUSINESS = 244;
    public const LINK = 245;
    public const DSP3270 = 246;
    public const SUBNTBCST_TFTP = 247;
    public const BHFHS = 248;
    public const RAP_2 = 256;
    public const SET = 257;
    public const ESRO_GEN = 259;
    public const OPENPORT = 260;
    public const NSIIOPS = 261;
    public const ARCISDMS = 262;
    public const HDAP = 263;
    public const BGMP = 264;
    public const X_BONE_CTL = 265;
    public const SST = 266;
    public const TD_SERVICE = 267;
    public const TD_REPLICA = 268;
    public const MANET = 269;
    public const PT_TLS = 271;
    public const HTTP_MGMT = 280;
    public const PERSONAL_LINK = 281;
    public const CABLEPORT_AX = 282;
    public const RESCAP = 283;
    public const CORERJD = 284;
    public const FXP = 286;
    public const K_BLOCK = 287;
    public const NOVASTORBAKCUP = 308;
    public const ENTRUSTTIME = 309;
    public const BHMDS = 310;
    public const ASIP_WEBADMIN = 311;
    public const VSLMP = 312;
    public const MAGENTA_LOGIC = 313;
    public const OPALIS_ROBOT = 314;
    public const DPSI = 315;
    public const DECAUTH = 316;
    public const ZANNET = 317;
    public const PKIX_TIMESTAMP = 318;
    public const PTP_EVENT = 319;
    public const PTP_GENERAL = 320;
    public const PIP = 321;
    public const RTSPS = 322;
    public const RPKI_RTR = 323;
    public const RPKI_RTR_TLS = 324;
    public const TEXAR = 333;
    public const PDAP = 344;
    public const PAWSERV = 345;
    public const ZSERV = 346;
    public const FATSERV = 347;
    public const CSI_SGWP = 348;
    public const MFTP = 349;
    public const MATIP_TYPE_A = 350;
    public const MATIP_TYPE_B = 351;
    public const DTAG_STE_SB = 352;
    public const NDSAUTH = 353;
    public const BH611 = 354;
    public const DATEX_ASN = 355;
    public const CLOANTO_NET_1 = 356;
    public const BHEVENT = 357;
    public const SHRINKWRAP = 358;
    public const NSRMP = 359;
    public const SCOI2ODIALOG = 360;
    public const SEMANTIX = 361;
    public const SRSSEND = 362;
    public const RSVP_TUNNEL = 363;
    public const AURORA_CMGR = 364;
    public const DTK = 365;
    public const ODMR = 366;
    public const MORTGAGEWARE = 367;
    public const QBIKGDP = 368;
    public const RPC2PORTMAP = 369;
    public const CODAAUTH2 = 370;
    public const CLEARCASE = 371;
    public const ULISTPROC = 372;
    public const LEGENT_1 = 373;
    public const LEGENT_2 = 374;
    public const HASSLE = 375;
    public const NIP = 376;
    public const TNETOS = 377;
    public const DSETOS = 378;
    public const IS99C = 379;
    public const IS99S = 380;
    public const HP_COLLECTOR = 381;
    public const HP_MANAGED_NODE = 382;
    public const HP_ALARM_MGR = 383;
    public const ARNS = 384;
    public const IBM_APP = 385;
    public const ASA = 386;
    public const AURP = 387;
    public const UNIDATA_LDM = 388;
    public const LDAP = 389;
    public const UIS = 390;
    public const SYNOTICS_RELAY = 391;
    public const SYNOTICS_BROKER = 392;
    public const META5 = 393;
    public const EMBL_NDT = 394;
    public const NETCP = 395;
    public const NETWARE_IP = 396;
    public const MPTN = 397;
    public const KRYPTOLAN = 398;
    public const ISO_TSAP_C2 = 399;
    public const OSB_SD = 400;
    public const UPS = 401;
    public const GENIE = 402;
    public const DECAP = 403;
    public const NCED = 404;
    public const NCLD = 405;
    public const IMSP = 406;
    public const TIMBUKTU = 407;
    public const PRM_SM = 408;
    public const PRM_NM = 409;
    public const DECLADEBUG = 410;
    public const RMT = 411;
    public const SYNOPTICS_TRAP = 412;
    public const SMSP = 413;
    public const INFOSEEK = 414;
    public const BNET = 415;
    public const SILVERPLATTER = 416;
    public const ONMUX = 417;
    public const HYPER_G = 418;
    public const ARIEL1 = 419;
    public const SMPTE = 420;
    public const ARIEL2 = 421;
    public const ARIEL3 = 422;
    public const OPC_JOB_START = 423;
    public const OPC_JOB_TRACK = 424;
    public const ICAD_EL = 425;
    public const SMARTSDP = 426;
    public const SVRLOC = 427;
    public const OCS_CMU = 428;
    public const OCS_AMU = 429;
    public const UTMPSD = 430;
    public const UTMPCD = 431;
    public const IASD = 432;
    public const NNSP = 433;
    public const MOBILEIP_AGENT = 434;
    public const MOBILIP_MN = 435;
    public const DNA_CML = 436;
    public const COMSCM = 437;
    public const DSFGW = 438;
    public const DASP = 439;
    public const SGCP = 440;
    public const DECVMS_SYSMGT = 441;
    public const CVC_HOSTD = 442;
    public const HTTPS = 443;
    public const SNPP = 444;
    public const MICROSOFT_DS = 445;
    public const DDM_RDB = 446;
    public const DDM_DFM = 447;
    public const DDM_SSL = 448;
    public const AS_SERVERMAP = 449;
    public const TSERVER = 450;
    public const SFS_SMP_NET = 451;
    public const SFS_CONFIG = 452;
    public const CREATIVESERVER = 453;
    public const CONTENTSERVER = 454;
    public const CREATIVEPARTNR = 455;
    public const MACON_TCP = 456;
    public const SCOHELP = 457;
    public const APPLEQTC = 458;
    public const AMPR_RCMD = 459;
    public const SKRONK = 460;
    public const DATASURFSRV = 461;
    public const DATASURFSRVSEC = 462;
    public const ALPES = 463;
    public const KPASSWD = 464;
    public const URD = 465;
    public const DIGITAL_VRC = 466;
    public const MYLEX_MAPD = 467;
    public const PHOTURIS = 468;
    public const RCP = 469;
    public const SCX_PROXY = 470;
    public const MONDEX = 471;
    public const LJK_LOGIN = 472;
    public const HYBRID_POP = 473;
    public const TN_TL_W1 = 474;
    public const TCPNETHASPSRV = 475;
    public const TN_TL_FD1 = 476;
    public const SS7NS = 477;
    public const SPSC = 478;
    public const IAFSERVER = 479;
    public const IAFDBASE = 480;
    public const PH = 481;
    public const BGS_NSI = 482;
    public const ULPNET = 483;
    public const INTEGRA_SME = 484;
    public const POWERBURST = 485;
    public const AVIAN = 486;
    public const SAFT = 487;
    public const GSS_HTTP = 488;
    public const NEST_PROTOCOL = 489;
    public const MICOM_PFS = 490;
    public const GO_LOGIN = 491;
    public const TICF_1 = 492;
    public const TICF_2 = 493;
    public const POV_RAY = 494;
    public const INTECOURIER = 495;
    public const PIM_RP_DISC = 496;
    public const RETROSPECT = 497;
    public const SIAM = 498;
    public const ISO_ILL = 499;
    public const ISAKMP = 500;
    public const STMF = 501;
    public const MBAP = 502;
    public const INTRINSA = 503;
    public const CITADEL = 504;
    public const MAILBOX_LM = 505;
    public const OHIMSRV = 506;
    public const CRS = 507;
    public const XVTTP = 508;
    public const SNARE = 509;
    public const FCP = 510;
    public const PASSGO = 511;
    public const EXEC = 512;
    public const LOGIN = 513;
    public const SHELL = 514;
    public const PRINTER = 515;
    public const VIDEOTEX = 516;
    public const TALK = 517;
    public const NTALK = 518;
    public const UTIME = 519;
    public const EFS = 520;
    public const RIPNG = 521;
    public const ULP = 522;
    public const IBM_DB2 = 523;
    public const NCP = 524;
    public const TIMED = 525;
    public const TEMPO = 526;
    public const STX = 527;
    public const CUSTIX = 528;
    public const IRC_SERV = 529;
    public const COURIER = 530;
    public const CONFERENCE = 531;
    public const NETNEWS = 532;
    public const NETWALL = 533;
    public const WINDREAM = 534;
    public const IIOP = 535;
    public const OPALIS_RDV = 536;
    public const NMSP = 537;
    public const GDOMAP = 538;
    public const APERTUS_LDP = 539;
    public const UUCP = 540;
    public const UUCP_RLOGIN = 541;
    public const COMMERCE = 542;
    public const KLOGIN = 543;
    public const KSHELL = 544;
    public const APPLEQTCSRVR = 545;
    public const DHCPV6_CLIENT = 546;
    public const DHCPV6_SERVER = 547;
    public const AFPOVERTCP = 548;
    public const IDFP = 549;
    public const NEW_RWHO = 550;
    public const CYBERCASH = 551;
    public const DEVSHR_NTS = 552;
    public const PIRP = 553;
    public const RTSP = 554;
    public const DSF = 555;
    public const REMOTEFS = 556;
    public const OPENVMS_SYSIPC = 557;
    public const SDNSKMP = 558;
    public const TEEDTAP = 559;
    public const RMONITOR = 560;
    public const MONITOR = 561;
    public const CHSHELL = 562;
    public const NNTPS = 563;
    public const _9PFS = 564;
    public const WHOAMI = 565;
    public const STREETTALK = 566;
    public const BANYAN_RPC = 567;
    public const MS_SHUTTLE = 568;
    public const MS_ROME = 569;
    public const METER = 570;
    public const METER_2 = 571;
    public const SONAR = 572;
    public const BANYAN_VIP = 573;
    public const FTP_AGENT = 574;
    public const VEMMI = 575;
    public const IPCD = 576;
    public const VNAS = 577;
    public const IPDD = 578;
    public const DECBSRV = 579;
    public const SNTP_HEARTBEAT = 580;
    public const BDP = 581;
    public const SCC_SECURITY = 582;
    public const PHILIPS_VC = 583;
    public const KEYSERVER = 584;
    public const PASSWORD_CHG = 586;
    public const SUBMISSION = 587;
    public const CAL = 588;
    public const EYELINK = 589;
    public const TNS_CML = 590;
    public const HTTP_ALT = 591;
    public const EUDORA_SET = 592;
    public const HTTP_RPC_EPMAP = 593;
    public const TPIP = 594;
    public const CAB_PROTOCOL = 595;
    public const SMSD = 596;
    public const PTCNAMESERVICE = 597;
    public const SCO_WEBSRVRMG3 = 598;
    public const ACP = 599;
    public const IPCSERVER = 600;
    public const SYSLOG_CONN = 601;
    public const XMLRPC_BEEP = 602;
    public const IDXP = 603;
    public const TUNNEL = 604;
    public const SOAP_BEEP = 605;
    public const URM = 606;
    public const NQS = 607;
    public const SIFT_UFT = 608;
    public const NPMP_TRAP = 609;
    public const NPMP_LOCAL = 610;
    public const NPMP_GUI = 611;
    public const HMMP_IND = 612;
    public const HMMP_OP = 613;
    public const SSHELL = 614;
    public const SCO_INETMGR = 615;
    public const SCO_SYSMGR = 616;
    public const SCO_DTMGR = 617;
    public const DEI_ICDA = 618;
    public const COMPAQ_EVM = 619;
    public const SCO_WEBSRVRMGR = 620;
    public const ESCP_IP = 621;
    public const COLLABORATOR = 622;
    public const OOB_WS_HTTP = 623;
    public const CRYPTOADMIN = 624;
    public const DEC_DLM = 625;
    public const ASIA = 626;
    public const PASSGO_TIVOLI = 627;
    public const QMQP = 628;
    public const _3COM_AMP3 = 629;
    public const RDA = 630;
    public const IPP = 631;
    public const BMPP = 632;
    public const SERVSTAT = 633;
    public const GINAD = 634;
    public const RLZDBASE = 635;
    public const LDAPS = 636;
    public const LANSERVER = 637;
    public const MCNS_SEC = 638;
    public const MSDP = 639;
    public const ENTRUST_SPS = 640;
    public const REPCMD = 641;
    public const ESRO_EMSDP = 642;
    public const SANITY = 643;
    public const DWR = 644;
    public const PSSC = 645;
    public const LDP = 646;
    public const DHCP_FAILOVER = 647;
    public const RRP = 648;
    public const CADVIEW_3D = 649;
    public const OBEX = 650;
    public const IEEE_MMS = 651;
    public const HELLO_PORT = 652;
    public const REPSCMD = 653;
    public const AODV = 654;
    public const TINC = 655;
    public const SPMP = 656;
    public const RMC = 657;
    public const TENFOLD = 658;
    public const MAC_SRVR_ADMIN = 660;
    public const HAP = 661;
    public const PFTP = 662;
    public const PURENOISE = 663;
    public const OOB_WS_HTTPS = 664;
    public const SUN_DR = 665;
    public const MDQS = 666;
    public const DISCLOSE = 667;
    public const MECOMM = 668;
    public const MEREGISTER = 669;
    public const VACDSM_SWS = 670;
    public const VACDSM_APP = 671;
    public const VPPS_QUA = 672;
    public const CIMPLEX = 673;
    public const ACAP = 674;
    public const DCTP = 675;
    public const VPPS_VIA = 676;
    public const VPP = 677;
    public const GGF_NCP = 678;
    public const MRM = 679;
    public const ENTRUST_AAAS = 680;
    public const ENTRUST_AAMS = 681;
    public const XFR = 682;
    public const CORBA_IIOP = 683;
    public const CORBA_IIOP_SSL = 684;
    public const MDC_PORTMAPPER = 685;
    public const HCP_WISMAR = 686;
    public const ASIPREGISTRY = 687;
    public const REALM_RUSD = 688;
    public const NMAP = 689;
    public const VATP = 690;
    public const MSEXCH_ROUTING = 691;
    public const HYPERWAVE_ISP = 692;
    public const CONNENDP = 693;
    public const HA_CLUSTER = 694;
    public const IEEE_MMS_SSL = 695;
    public const RUSHD = 696;
    public const UUIDGEN = 697;
    public const OLSR = 698;
    public const ACCESSNETWORK = 699;
    public const EPP = 700;
    public const LMP = 701;
    public const IRIS_BEEP = 702;
    public const ELCSD = 704;
    public const AGENTX = 705;
    public const SILC = 706;
    public const BORLAND_DSJ = 707;
    public const ENTRUST_KMSH = 709;
    public const ENTRUST_ASH = 710;
    public const CISCO_TDP = 711;
    public const TBRPF = 712;
    public const IRIS_XPC = 713;
    public const IRIS_XPCS = 714;
    public const IRIS_LWZ = 715;
    public const NETVIEWDM1 = 729;
    public const NETVIEWDM2 = 730;
    public const NETVIEWDM3 = 731;
    public const NETGW = 741;
    public const NETRCS = 742;
    public const FLEXLM = 744;
    public const FUJITSU_DEV = 747;
    public const RIS_CM = 748;
    public const KERBEROS_ADM = 749;
    public const RFILE = 750;
    public const PUMP = 751;
    public const QRH = 752;
    public const RRH = 753;
    public const TELL = 754;
    public const NLOGIN = 758;
    public const CON = 759;
    public const NS = 760;
    public const RXE = 761;
    public const QUOTAD = 762;
    public const CYCLESERV = 763;
    public const OMSERV = 764;
    public const WEBSTER = 765;
    public const PHONEBOOK = 767;
    public const VID = 769;
    public const CADLOCK = 770;
    public const RTIP = 771;
    public const CYCLESERV2 = 772;
    public const SUBMIT = 773;
    public const RPASSWD = 774;
    public const ENTOMB = 775;
    public const WPAGES = 776;
    public const MULTILING_HTTP = 777;
    public const WPGS = 780;
    public const MDBS_DAEMON = 800;
    public const DEVICE = 801;
    public const MBAP_S = 802;
    public const FCP_UDP = 810;
    public const ITM_MCELL_S = 828;
    public const PKIX_3_CA_RA = 829;
    public const NETCONF_SSH = 830;
    public const NETCONF_BEEP = 831;
    public const NETCONFSOAPHTTP = 832;
    public const NETCONFSOAPBEEP = 833;
    public const DHCP_FAILOVER2 = 847;
    public const GDOI = 848;
    public const DOMAIN_S = 853;
    public const DLEP = 854;
    public const ISCSI = 860;
    public const OWAMP_CONTROL = 861;
    public const TWAMP_CONTROL = 862;
    public const RSYNC = 873;
    public const ICLCNET_LOCATE = 886;
    public const ICLCNET_SVINFO = 887;
    public const ACCESSBUILDER = 888;
    public const OMGINITIALREFS = 900;
    public const SMPNAMERES = 901;
    public const IDEAFARM_DOOR = 902;
    public const IDEAFARM_PANIC = 903;
    public const KINK = 910;
    public const XACT_BACKUP = 911;
    public const APEX_MESH = 912;
    public const APEX_EDGE = 913;
    public const RNDC = 953;
    public const FTPS_DATA = 989;
    public const FTPS = 990;
    public const NAS = 991;
    public const TELNETS = 992;
    public const IMAPS = 993;
    public const POP3S = 995;
    public const VSINET = 996;
    public const MAITRD = 997;
    public const BUSBOY = 998;
    public const GARCON = 999;
    public const CADLOCK2 = 1000;
    public const WEBPUSH = 1001;
    public const SURF = 1010;
    public const EXP1 = 1021;
    public const EXP2 = 1022;
    public const BLACKJACK = 1025;
    public const CAP = 1026;
    public const SOLID_MUX = 1029;
    public const NETINFO_LOCAL = 1033;
    public const ACTIVESYNC = 1034;
    public const MXXRLOGIN = 1035;
    public const NSSTP = 1036;
    public const AMS = 1037;
    public const MTQP = 1038;
    public const SBL = 1039;
    public const NETARX = 1040;
    public const DANF_AK2 = 1041;
    public const AFROG = 1042;
    public const BOINC_CLIENT = 1043;
    public const DCUTILITY = 1044;
    public const FPITP = 1045;
    public const WFREMOTERTM = 1046;
    public const NEOD1 = 1047;
    public const NEOD2 = 1048;
    public const TD_POSTMAN = 1049;
    public const CMA = 1050;
    public const OPTIMA_VNET = 1051;
    public const DDT = 1052;
    public const REMOTE_AS = 1053;
    public const BRVREAD = 1054;
    public const ANSYSLMD = 1055;
    public const VFO = 1056;
    public const STARTRON = 1057;
    public const NIM = 1058;
    public const NIMREG = 1059;
    public const POLESTAR = 1060;
    public const KIOSK = 1061;
    public const VERACITY = 1062;
    public const KYOCERANETDEV = 1063;
    public const JSTEL = 1064;
    public const SYSCOMLAN = 1065;
    public const FPO_FNS = 1066;
    public const INSTL_BOOTS = 1067;
    public const INSTL_BOOTC = 1068;
    public const COGNEX_INSIGHT = 1069;
    public const GMRUPDATESERV = 1070;
    public const BSQUARE_VOIP = 1071;
    public const CARDAX = 1072;
    public const BRIDGECONTROL = 1073;
    public const WARMSPOTMGMT = 1074;
    public const RDRMSHC = 1075;
    public const DAB_STI_C = 1076;
    public const IMGAMES = 1077;
    public const AVOCENT_PROXY = 1078;
    public const ASPROVATALK = 1079;
    public const SOCKS = 1080;
    public const PVUNIWIEN = 1081;
    public const AMT_ESD_PROT = 1082;
    public const ANSOFT_LM_1 = 1083;
    public const ANSOFT_LM_2 = 1084;
    public const WEBOBJECTS = 1085;
    public const CPLSCRAMBLER_LG = 1086;
    public const CPLSCRAMBLER_IN = 1087;
    public const CPLSCRAMBLER_AL = 1088;
    public const FF_ANNUNC = 1089;
    public const FF_FMS = 1090;
    public const FF_SM = 1091;
    public const OBRPD = 1092;
    public const PROOFD = 1093;
    public const ROOTD = 1094;
    public const NICELINK = 1095;
    public const CNRPROTOCOL = 1096;
    public const SUNCLUSTERMGR = 1097;
    public const RMIACTIVATION = 1098;
    public const RMIREGISTRY = 1099;
    public const MCTP = 1100;
    public const PT2_DISCOVER = 1101;
    public const ADOBESERVER_1 = 1102;
    public const ADOBESERVER_2 = 1103;
    public const XRL = 1104;
    public const FTRANHC = 1105;
    public const ISOIPSIGPORT_1 = 1106;
    public const ISOIPSIGPORT_2 = 1107;
    public const RATIO_ADP = 1108;
    public const WEBADMSTART = 1110;
    public const LMSOCIALSERVER = 1111;
    public const ICP = 1112;
    public const LTP_DEEPSPACE = 1113;
    public const MINI_SQL = 1114;
    public const ARDUS_TRNS = 1115;
    public const ARDUS_CNTL = 1116;
    public const ARDUS_MTRNS = 1117;
    public const SACRED = 1118;
    public const BNETGAME = 1119;
    public const BNETFILE = 1120;
    public const RMPP = 1121;
    public const AVAILANT_MGR = 1122;
    public const MURRAY = 1123;
    public const HPVMMCONTROL = 1124;
    public const HPVMMAGENT = 1125;
    public const HPVMMDATA = 1126;
    public const KWDB_COMMN = 1127;
    public const SAPHOSTCTRL = 1128;
    public const SAPHOSTCTRLS = 1129;
    public const CASP = 1130;
    public const CASPSSL = 1131;
    public const KVM_VIA_IP = 1132;
    public const DFN = 1133;
    public const APLX = 1134;
    public const OMNIVISION = 1135;
    public const HHB_GATEWAY = 1136;
    public const TRIM = 1137;
    public const ENCRYPTED_ADMIN = 1138;
    public const EVM = 1139;
    public const AUTONOC = 1140;
    public const MXOMSS = 1141;
    public const EDTOOLS = 1142;
    public const IMYX = 1143;
    public const FUSCRIPT = 1144;
    public const X9_ICUE = 1145;
    public const AUDIT_TRANSFER = 1146;
    public const CAPIOVERLAN = 1147;
    public const ELFIQ_REPL = 1148;
    public const BVTSONAR = 1149;
    public const BLAZE = 1150;
    public const UNIZENSUS = 1151;
    public const WINPOPLANMESS = 1152;
    public const C1222_ACSE = 1153;
    public const RESACOMMUNITY = 1154;
    public const NFA = 1155;
    public const IASCONTROL_OMS = 1156;
    public const IASCONTROL = 1157;
    public const DBCONTROL_OMS = 1158;
    public const ORACLE_OMS = 1159;
    public const OLSV = 1160;
    public const HEALTH_POLLING = 1161;
    public const HEALTH_TRAP = 1162;
    public const SDDP = 1163;
    public const QSM_PROXY = 1164;
    public const QSM_GUI = 1165;
    public const QSM_REMOTE = 1166;
    public const CISCO_IPSLA = 1167;
    public const VCHAT = 1168;
    public const TRIPWIRE = 1169;
    public const ATC_LM = 1170;
    public const ATC_APPSERVER = 1171;
    public const DNAP = 1172;
    public const D_CINEMA_RRP = 1173;
    public const FNET_REMOTE_UI = 1174;
    public const DOSSIER = 1175;
    public const INDIGO_SERVER = 1176;
    public const DKMESSENGER = 1177;
    public const SGI_STORMAN = 1178;
    public const B2N = 1179;
    public const MC_CLIENT = 1180;
    public const _3COMNETMAN = 1181;
    public const ACCELENET = 1182;
    public const LLSURFUP_HTTP = 1183;
    public const LLSURFUP_HTTPS = 1184;
    public const CATCHPOLE = 1185;
    public const MYSQL_CLUSTER = 1186;
    public const ALIAS = 1187;
    public const HP_WEBADMIN = 1188;
    public const UNET = 1189;
    public const COMMLINX_AVL = 1190;
    public const GPFS = 1191;
    public const CAIDS_SENSOR = 1192;
    public const FIVEACROSS = 1193;
    public const OPENVPN = 1194;
    public const RSF_1 = 1195;
    public const NETMAGIC = 1196;
    public const CARRIUS_RSHELL = 1197;
    public const CAJO_DISCOVERY = 1198;
    public const DMIDI = 1199;
    public const SCOL = 1200;
    public const NUCLEUS_SAND = 1201;
    public const CAICCIPC = 1202;
    public const SSSLIC_MGR = 1203;
    public const SSSLOG_MGR = 1204;
    public const ACCORD_MGC = 1205;
    public const ANTHONY_DATA = 1206;
    public const METASAGE = 1207;
    public const SEAGULL_AIS = 1208;
    public const IPCD3 = 1209;
    public const EOSS = 1210;
    public const GROOVE_DPP = 1211;
    public const LUPA = 1212;
    public const MPC_LIFENET = 1213;
    public const KAZAA = 1214;
    public const SCANSTAT_1 = 1215;
    public const ETEBAC5 = 1216;
    public const HPSS_NDAPI = 1217;
    public const AEROFLIGHT_ADS = 1218;
    public const AEROFLIGHT_RET = 1219;
    public const QT_SERVERADMIN = 1220;
    public const SWEETWARE_APPS = 1221;
    public const NERV = 1222;
    public const TGP = 1223;
    public const VPNZ = 1224;
    public const SLINKYSEARCH = 1225;
    public const STGXFWS = 1226;
    public const DNS2GO = 1227;
    public const FLORENCE = 1228;
    public const ZENTED = 1229;
    public const PERISCOPE = 1230;
    public const MENANDMICE_LPM = 1231;
    public const FIRST_DEFENSE = 1232;
    public const UNIV_APPSERVER = 1233;
    public const SEARCH_AGENT = 1234;
    public const MOSAICSYSSVC1 = 1235;
    public const BVCONTROL = 1236;
    public const TSDOS390 = 1237;
    public const HACL_QS = 1238;
    public const NMSD = 1239;
    public const INSTANTIA = 1240;
    public const NESSUS = 1241;
    public const NMASOVERIP = 1242;
    public const SERIALGATEWAY = 1243;
    public const ISBCONFERENCE1 = 1244;
    public const ISBCONFERENCE2 = 1245;
    public const PAYROUTER = 1246;
    public const VISIONPYRAMID = 1247;
    public const HERMES = 1248;
    public const MESAVISTACO = 1249;
    public const SWLDY_SIAS = 1250;
    public const SERVERGRAPH = 1251;
    public const BSPNE_PCC = 1252;
    public const Q55_PCC = 1253;
    public const DE_NOC = 1254;
    public const DE_CACHE_QUERY = 1255;
    public const DE_SERVER = 1256;
    public const SHOCKWAVE2 = 1257;
    public const OPENNL = 1258;
    public const OPENNL_VOICE = 1259;
    public const IBM_SSD = 1260;
    public const MPSHRSV = 1261;
    public const QNTS_ORB = 1262;
    public const DKA = 1263;
    public const PRAT = 1264;
    public const DSSIAPI = 1265;
    public const DELLPWRAPPKS = 1266;
    public const EPC = 1267;
    public const PROPEL_MSGSYS = 1268;
    public const WATILAPP = 1269;
    public const OPSMGR = 1270;
    public const EXCW = 1271;
    public const CSPMLOCKMGR = 1272;
    public const EMC_GATEWAY = 1273;
    public const T1DISTPROC = 1274;
    public const IVCOLLECTOR = 1275;
    public const MIVA_MQS = 1277;
    public const DELLWEBADMIN_1 = 1278;
    public const DELLWEBADMIN_2 = 1279;
    public const PICTROGRAPHY = 1280;
    public const HEALTHD = 1281;
    public const EMPERION = 1282;
    public const PRODUCTINFO = 1283;
    public const IEE_QFX = 1284;
    public const NEOIFACE = 1285;
    public const NETUITIVE = 1286;
    public const ROUTEMATCH = 1287;
    public const NAVBUDDY = 1288;
    public const JWALKSERVER = 1289;
    public const WINJASERVER = 1290;
    public const SEAGULLLMS = 1291;
    public const DSDN = 1292;
    public const PKT_KRB_IPSEC = 1293;
    public const CMMDRIVER = 1294;
    public const EHTP = 1295;
    public const DPROXY = 1296;
    public const SDPROXY = 1297;
    public const LPCP = 1298;
    public const HP_SCI = 1299;
    public const H323HOSTCALLSC = 1300;
    public const CI3_SOFTWARE_1 = 1301;
    public const CI3_SOFTWARE_2 = 1302;
    public const SFTSRV = 1303;
    public const BOOMERANG = 1304;
    public const PE_MIKE = 1305;
    public const RE_CONN_PROTO = 1306;
    public const PACMAND = 1307;
    public const ODSI = 1308;
    public const JTAG_SERVER = 1309;
    public const HUSKY = 1310;
    public const RXMON = 1311;
    public const STI_ENVISION = 1312;
    public const BMC_PATROLDB = 1313;
    public const PDPS = 1314;
    public const ELS = 1315;
    public const EXBIT_ESCP = 1316;
    public const VRTS_IPCSERVER = 1317;
    public const KRB5GATEKEEPER = 1318;
    public const AMX_ICSP = 1319;
    public const AMX_AXBNET = 1320;
    public const PIP_2 = 1321;
    public const NOVATION = 1322;
    public const BRCD = 1323;
    public const DELTA_MCP = 1324;
    public const DX_INSTRUMENT = 1325;
    public const WIMSIC = 1326;
    public const ULTREX = 1327;
    public const EWALL = 1328;
    public const NETDB_EXPORT = 1329;
    public const STREETPERFECT = 1330;
    public const INTERSAN = 1331;
    public const PCIA_RXP_B = 1332;
    public const PASSWRD_POLICY = 1333;
    public const WRITESRV = 1334;
    public const DIGITAL_NOTARY = 1335;
    public const ISCHAT = 1336;
    public const MENANDMICE_DNS = 1337;
    public const WMC_LOG_SVC = 1338;
    public const KJTSITESERVER = 1339;
    public const NAAP = 1340;
    public const QUBES = 1341;
    public const ESBROKER = 1342;
    public const RE101 = 1343;
    public const ICAP = 1344;
    public const VPJP = 1345;
    public const ALTA_ANA_LM = 1346;
    public const BBN_MMC = 1347;
    public const BBN_MMX = 1348;
    public const SBOOK = 1349;
    public const EDITBENCH = 1350;
    public const EQUATIONBUILDER = 1351;
    public const LOTUSNOTE = 1352;
    public const RELIEF = 1353;
    public const XSIP_NETWORK = 1354;
    public const INTUITIVE_EDGE = 1355;
    public const CUILLAMARTIN = 1356;
    public const PEGBOARD = 1357;
    public const CONNLCLI = 1358;
    public const FTSRV = 1359;
    public const MIMER = 1360;
    public const LINX = 1361;
    public const TIMEFLIES = 1362;
    public const NDM_REQUESTER = 1363;
    public const NDM_SERVER = 1364;
    public const ADAPT_SNA = 1365;
    public const NETWARE_CSP = 1366;
    public const DCS = 1367;
    public const SCREENCAST = 1368;
    public const GV_US = 1369;
    public const US_GV = 1370;
    public const FC_CLI = 1371;
    public const FC_SER = 1372;
    public const CHROMAGRAFX = 1373;
    public const MOLLY = 1374;
    public const BYTEX = 1375;
    public const IBM_PPS = 1376;
    public const CICHLID = 1377;
    public const ELAN = 1378;
    public const DBREPORTER = 1379;
    public const TELESIS_LICMAN = 1380;
    public const APPLE_LICMAN = 1381;
    public const UDT_OS = 1382;
    public const GWHA = 1383;
    public const OS_LICMAN = 1384;
    public const ATEX_ELMD = 1385;
    public const CHECKSUM = 1386;
    public const CADSI_LM = 1387;
    public const OBJECTIVE_DBC = 1388;
    public const ICLPV_DM = 1389;
    public const ICLPV_SC = 1390;
    public const ICLPV_SAS = 1391;
    public const ICLPV_PM = 1392;
    public const ICLPV_NLS = 1393;
    public const ICLPV_NLC = 1394;
    public const ICLPV_WSM = 1395;
    public const DVL_ACTIVEMAIL = 1396;
    public const AUDIO_ACTIVMAIL = 1397;
    public const VIDEO_ACTIVMAIL = 1398;
    public const CADKEY_LICMAN = 1399;
    public const CADKEY_TABLET = 1400;
    public const GOLDLEAF_LICMAN = 1401;
    public const PRM_SM_NP = 1402;
    public const PRM_NM_NP = 1403;
    public const IGI_LM = 1404;
    public const IBM_RES = 1405;
    public const NETLABS_LM = 1406;
    public const TIBET_SERVER = 1407;
    public const SOPHIA_LM = 1408;
    public const HERE_LM = 1409;
    public const HIQ = 1410;
    public const AF = 1411;
    public const INNOSYS = 1412;
    public const INNOSYS_ACL = 1413;
    public const IBM_MQSERIES = 1414;
    public const DBSTAR = 1415;
    public const NOVELL_LU6_2 = 1416;
    public const TIMBUKTU_SRV1 = 1417;
    public const TIMBUKTU_SRV2 = 1418;
    public const TIMBUKTU_SRV3 = 1419;
    public const TIMBUKTU_SRV4 = 1420;
    public const GANDALF_LM = 1421;
    public const AUTODESK_LM = 1422;
    public const ESSBASE = 1423;
    public const HYBRID = 1424;
    public const ZION_LM = 1425;
    public const SAIS = 1426;
    public const MLOADD = 1427;
    public const INFORMATIK_LM = 1428;
    public const NMS = 1429;
    public const TPDU = 1430;
    public const RGTP = 1431;
    public const BLUEBERRY_LM = 1432;
    public const MS_SQL_S = 1433;
    public const MS_SQL_M = 1434;
    public const IBM_CICS = 1435;
    public const SAISM = 1436;
    public const TABULA = 1437;
    public const EICON_SERVER = 1438;
    public const EICON_X25 = 1439;
    public const EICON_SLP = 1440;
    public const CADIS_1 = 1441;
    public const CADIS_2 = 1442;
    public const IES_LM = 1443;
    public const MARCAM_LM = 1444;
    public const PROXIMA_LM = 1445;
    public const ORA_LM = 1446;
    public const APRI_LM = 1447;
    public const OC_LM = 1448;
    public const PEPORT = 1449;
    public const DWF = 1450;
    public const INFOMAN = 1451;
    public const GTEGSC_LM = 1452;
    public const GENIE_LM = 1453;
    public const INTERHDL_ELMD = 1454;
    public const ESL_LM = 1455;
    public const DCA = 1456;
    public const VALISYS_LM = 1457;
    public const NRCABQ_LM = 1458;
    public const PROSHARE1 = 1459;
    public const PROSHARE2 = 1460;
    public const IBM_WRLESS_LAN = 1461;
    public const WORLD_LM = 1462;
    public const NUCLEUS = 1463;
    public const MSL_LMD = 1464;
    public const PIPES = 1465;
    public const OCEANSOFT_LM = 1466;
    public const CSDMBASE = 1467;
    public const CSDM = 1468;
    public const AAL_LM = 1469;
    public const UAIACT = 1470;
    public const CSDMBASE_2 = 1471;
    public const CSDM_2 = 1472;
    public const OPENMATH = 1473;
    public const TELEFINDER = 1474;
    public const TALIGENT_LM = 1475;
    public const CLVM_CFG = 1476;
    public const MS_SNA_SERVER = 1477;
    public const MS_SNA_BASE = 1478;
    public const DBEREGISTER = 1479;
    public const PACERFORUM = 1480;
    public const AIRS = 1481;
    public const MITEKSYS_LM = 1482;
    public const AFS = 1483;
    public const CONFLUENT = 1484;
    public const LANSOURCE = 1485;
    public const NMS_TOPO_SERV = 1486;
    public const LOCALINFOSRVR = 1487;
    public const DOCSTOR = 1488;
    public const DMDOCBROKER = 1489;
    public const INSITU_CONF = 1490;
    public const STONE_DESIGN_1 = 1492;
    public const NETMAP_LM = 1493;
    public const ICA = 1494;
    public const CVC = 1495;
    public const LIBERTY_LM = 1496;
    public const RFX_LM = 1497;
    public const SYBASE_SQLANY = 1498;
    public const FHC = 1499;
    public const VLSI_LM = 1500;
    public const SAISCM = 1501;
    public const SHIVADISCOVERY = 1502;
    public const IMTC_MCS = 1503;
    public const EVB_ELM = 1504;
    public const FUNKPROXY = 1505;
    public const UTCD = 1506;
    public const SYMPLEX = 1507;
    public const DIAGMOND = 1508;
    public const ROBCAD_LM = 1509;
    public const MVX_LM = 1510;
    public const _3L_L1 = 1511;
    public const WINS = 1512;
    public const FUJITSU_DTC = 1513;
    public const FUJITSU_DTCNS = 1514;
    public const IFOR_PROTOCOL = 1515;
    public const VPAD = 1516;
    public const VPAC = 1517;
    public const VPVD = 1518;
    public const VPVC = 1519;
    public const ATM_ZIP_OFFICE = 1520;
    public const NCUBE_LM = 1521;
    public const RICARDO_LM = 1522;
    public const CICHILD_LM = 1523;
    public const INGRESLOCK = 1524;
    public const ORASRV = 1525;
    public const PDAP_NP = 1526;
    public const TLISRV = 1527;
    public const COAUTHOR = 1529;
    public const RAP_SERVICE = 1530;
    public const RAP_LISTEN = 1531;
    public const MIROCONNECT = 1532;
    public const VIRTUAL_PLACES = 1533;
    public const MICROMUSE_LM = 1534;
    public const AMPR_INFO = 1535;
    public const AMPR_INTER = 1536;
    public const SDSC_LM = 1537;
    public const _3DS_LM = 1538;
    public const INTELLISTOR_LM = 1539;
    public const RDS = 1540;
    public const RDS2 = 1541;
    public const GRIDGEN_ELMD = 1542;
    public const SIMBA_CS = 1543;
    public const ASPECLMD = 1544;
    public const VISTIUM_SHARE = 1545;
    public const ABBACCURAY = 1546;
    public const LAPLINK = 1547;
    public const AXON_LM = 1548;
    public const SHIVAHOSE = 1549;
    public const _3M_IMAGE_LM = 1550;
    public const HECMTL_DB = 1551;
    public const PCIARRAY = 1552;
    public const SNA_CS = 1553;
    public const CACI_LM = 1554;
    public const LIVELAN = 1555;
    public const VERITAS_PBX = 1556;
    public const ARBORTEXT_LM = 1557;
    public const XINGMPEG = 1558;
    public const WEB2HOST = 1559;
    public const ASCI_VAL = 1560;
    public const FACILITYVIEW = 1561;
    public const PCONNECTMGR = 1562;
    public const CADABRA_LM = 1563;
    public const PAY_PER_VIEW = 1564;
    public const WINDDLB = 1565;
    public const CORELVIDEO = 1566;
    public const JLICELMD = 1567;
    public const TSSPMAP = 1568;
    public const ETS = 1569;
    public const ORBIXD = 1570;
    public const RDB_DBS_DISP = 1571;
    public const CHIP_LM = 1572;
    public const ITSCOMM_NS = 1573;
    public const MVEL_LM = 1574;
    public const ORACLENAMES = 1575;
    public const MOLDFLOW_LM = 1576;
    public const HYPERCUBE_LM = 1577;
    public const JACOBUS_LM = 1578;
    public const IOC_SEA_LM = 1579;
    public const TN_TL_R1 = 1580;
    public const MIL_2045_47001 = 1581;
    public const MSIMS = 1582;
    public const SIMBAEXPRESS = 1583;
    public const TN_TL_FD2 = 1584;
    public const INTV = 1585;
    public const IBM_ABTACT = 1586;
    public const PRA_ELMD = 1587;
    public const TRIQUEST_LM = 1588;
    public const VQP = 1589;
    public const GEMINI_LM = 1590;
    public const NCPM_PM = 1591;
    public const COMMONSPACE = 1592;
    public const MAINSOFT_LM = 1593;
    public const SIXTRAK = 1594;
    public const RADIO = 1595;
    public const RADIO_SM = 1596;
    public const ORBPLUS_IIOP = 1597;
    public const PICKNFS = 1598;
    public const SIMBASERVICES = 1599;
    public const ISSD = 1600;
    public const AAS = 1601;
    public const INSPECT = 1602;
    public const PICODBC = 1603;
    public const ICABROWSER = 1604;
    public const SLP = 1605;
    public const SLM_API = 1606;
    public const STT = 1607;
    public const SMART_LM = 1608;
    public const ISYSG_LM = 1609;
    public const TAURUS_WH = 1610;
    public const ILL = 1611;
    public const NETBILL_TRANS = 1612;
    public const NETBILL_KEYREP = 1613;
    public const NETBILL_CRED = 1614;
    public const NETBILL_AUTH = 1615;
    public const NETBILL_PROD = 1616;
    public const NIMROD_AGENT = 1617;
    public const SKYTELNET = 1618;
    public const XS_OPENSTORAGE = 1619;
    public const FAXPORTWINPORT = 1620;
    public const SOFTDATAPHONE = 1621;
    public const ONTIME = 1622;
    public const JALEOSND = 1623;
    public const UDP_SR_PORT = 1624;
    public const SVS_OMAGENT = 1625;
    public const SHOCKWAVE = 1626;
    public const T128_GATEWAY = 1627;
    public const LONTALK_NORM = 1628;
    public const LONTALK_URGNT = 1629;
    public const ORACLENET8CMAN = 1630;
    public const VISITVIEW = 1631;
    public const PAMMRATC = 1632;
    public const PAMMRPC = 1633;
    public const LOAPROBE = 1634;
    public const EDB_SERVER1 = 1635;
    public const ISDC = 1636;
    public const ISLC = 1637;
    public const ISMC = 1638;
    public const CERT_INITIATOR = 1639;
    public const CERT_RESPONDER = 1640;
    public const INVISION = 1641;
    public const ISIS_AM = 1642;
    public const ISIS_AMBC = 1643;
    public const SAISEH = 1644;
    public const SIGHTLINE = 1645;
    public const SA_MSG_PORT = 1646;
    public const RSAP = 1647;
    public const CONCURRENT_LM = 1648;
    public const KERMIT = 1649;
    public const NKD = 1650;
    public const SHIVA_CONFSRVR = 1651;
    public const XNMP = 1652;
    public const ALPHATECH_LM = 1653;
    public const STARGATEALERTS = 1654;
    public const DEC_MBADMIN = 1655;
    public const DEC_MBADMIN_H = 1656;
    public const FUJITSU_MMPDC = 1657;
    public const SIXNETUDR = 1658;
    public const SG_LM = 1659;
    public const SKIP_MC_GIKREQ = 1660;
    public const NETVIEW_AIX_1 = 1661;
    public const NETVIEW_AIX_2 = 1662;
    public const NETVIEW_AIX_3 = 1663;
    public const NETVIEW_AIX_4 = 1664;
    public const NETVIEW_AIX_5 = 1665;
    public const NETVIEW_AIX_6 = 1666;
    public const NETVIEW_AIX_7 = 1667;
    public const NETVIEW_AIX_8 = 1668;
    public const NETVIEW_AIX_9 = 1669;
    public const NETVIEW_AIX_10 = 1670;
    public const NETVIEW_AIX_11 = 1671;
    public const NETVIEW_AIX_12 = 1672;
    public const PROSHARE_MC_1 = 1673;
    public const PROSHARE_MC_2 = 1674;
    public const PDP = 1675;
    public const NETCOMM1 = 1676;
    public const GROUPWISE = 1677;
    public const PROLINK = 1678;
    public const DARCORP_LM = 1679;
    public const MICROCOM_SBP = 1680;
    public const SD_ELMD = 1681;
    public const LANYON_LANTERN = 1682;
    public const NCPM_HIP = 1683;
    public const SNARESECURE = 1684;
    public const N2NREMOTE = 1685;
    public const CVMON = 1686;
    public const NSJTP_CTRL = 1687;
    public const NSJTP_DATA = 1688;
    public const FIREFOX = 1689;
    public const NG_UMDS = 1690;
    public const EMPIRE_EMPUMA = 1691;
    public const SSTSYS_LM = 1692;
    public const RRIRTR = 1693;
    public const RRIMWM = 1694;
    public const RRILWM = 1695;
    public const RRIFMM = 1696;
    public const RRISAT = 1697;
    public const RSVP_ENCAP_1 = 1698;
    public const RSVP_ENCAP_2 = 1699;
    public const MPS_RAFT = 1700;
    public const L2F = 1701;
    public const DESKSHARE = 1702;
    public const HB_ENGINE = 1703;
    public const BCS_BROKER = 1704;
    public const SLINGSHOT = 1705;
    public const JETFORM = 1706;
    public const VDMPLAY = 1707;
    public const GAT_LMD = 1708;
    public const CENTRA = 1709;
    public const IMPERA = 1710;
    public const PPTCONFERENCE = 1711;
    public const REGISTRAR = 1712;
    public const CONFERENCETALK = 1713;
    public const SESI_LM = 1714;
    public const HOUDINI_LM = 1715;
    public const XMSG = 1716;
    public const FJ_HDNET = 1717;
    public const H323GATEDISC = 1718;
    public const H323GATESTAT = 1719;
    public const H323HOSTCALL = 1720;
    public const CAICCI = 1721;
    public const HKS_LM = 1722;
    public const PPTP = 1723;
    public const CSBPHONEMASTER = 1724;
    public const IDEN_RALP = 1725;
    public const IBERIAGAMES = 1726;
    public const WINDDX = 1727;
    public const TELINDUS = 1728;
    public const CITYNL = 1729;
    public const ROKETZ = 1730;
    public const MSICCP = 1731;
    public const PROXIM = 1732;
    public const SIIPAT = 1733;
    public const CAMBERTX_LM = 1734;
    public const PRIVATECHAT = 1735;
    public const STREET_STREAM = 1736;
    public const ULTIMAD = 1737;
    public const GAMEGEN1 = 1738;
    public const WEBACCESS = 1739;
    public const ENCORE = 1740;
    public const CISCO_NET_MGMT = 1741;
    public const _3COM_NSD = 1742;
    public const CINEGRFX_LM = 1743;
    public const NCPM_FT = 1744;
    public const REMOTE_WINSOCK = 1745;
    public const FTRAPID_1 = 1746;
    public const FTRAPID_2 = 1747;
    public const ORACLE_EM1 = 1748;
    public const ASPEN_SERVICES = 1749;
    public const SSLP = 1750;
    public const SWIFTNET = 1751;
    public const LOFR_LM = 1752;
    public const PREDATAR_COMMS = 1753;
    public const ORACLE_EM2 = 1754;
    public const MS_STREAMING = 1755;
    public const CAPFAST_LMD = 1756;
    public const CNHRP = 1757;
    public const TFTP_MCAST = 1758;
    public const SPSS_LM = 1759;
    public const WWW_LDAP_GW = 1760;
    public const CFT_0 = 1761;
    public const CFT_1 = 1762;
    public const CFT_2 = 1763;
    public const CFT_3 = 1764;
    public const CFT_4 = 1765;
    public const CFT_5 = 1766;
    public const CFT_6 = 1767;
    public const CFT_7 = 1768;
    public const BMC_NET_ADM = 1769;
    public const BMC_NET_SVC = 1770;
    public const VAULTBASE = 1771;
    public const ESSWEB_GW = 1772;
    public const KMSCONTROL = 1773;
    public const GLOBAL_DTSERV = 1774;
    public const VDAB = 1775;
    public const FEMIS = 1776;
    public const POWERGUARDIAN = 1777;
    public const PRODIGY_INTRNET = 1778;
    public const PHARMASOFT = 1779;
    public const DPKEYSERV = 1780;
    public const ANSWERSOFT_LM = 1781;
    public const HP_HCIP = 1782;
    public const FINLE_LM = 1784;
    public const WINDLM = 1785;
    public const FUNK_LOGGER = 1786;
    public const FUNK_LICENSE = 1787;
    public const PSMOND = 1788;
    public const HELLO = 1789;
    public const NMSP_2 = 1790;
    public const EA1 = 1791;
    public const IBM_DT_2 = 1792;
    public const RSC_ROBOT = 1793;
    public const CERA_BCM = 1794;
    public const DPI_PROXY = 1795;
    public const VOCALTEC_ADMIN = 1796;
    public const UMA_2 = 1797;
    public const ETP = 1798;
    public const NETRISK = 1799;
    public const ANSYS_LM = 1800;
    public const MSMQ = 1801;
    public const CONCOMP1 = 1802;
    public const HP_HCIP_GWY = 1803;
    public const ENL = 1804;
    public const ENL_NAME = 1805;
    public const MUSICONLINE = 1806;
    public const FHSP = 1807;
    public const ORACLE_VP2 = 1808;
    public const ORACLE_VP1 = 1809;
    public const JERAND_LM = 1810;
    public const SCIENTIA_SDB = 1811;
    public const RADIUS = 1812;
    public const RADIUS_ACCT = 1813;
    public const TDP_SUITE = 1814;
    public const MMPFT = 1815;
    public const HARP = 1816;
    public const RKB_OSCS = 1817;
    public const ETFTP = 1818;
    public const PLATO_LM = 1819;
    public const MCAGENT = 1820;
    public const DONNYWORLD = 1821;
    public const ES_ELMD = 1822;
    public const UNISYS_LM = 1823;
    public const METRICS_PAS = 1824;
    public const DIRECPC_VIDEO = 1825;
    public const ARDT = 1826;
    public const ASI = 1827;
    public const ITM_MCELL_U = 1828;
    public const OPTIKA_EMEDIA = 1829;
    public const NET8_CMAN = 1830;
    public const MYRTLE = 1831;
    public const THT_TREASURE = 1832;
    public const UDPRADIO = 1833;
    public const ARDUSUNI = 1834;
    public const ARDUSMUL = 1835;
    public const STE_SMSC = 1836;
    public const CSOFT1 = 1837;
    public const TALNET = 1838;
    public const NETOPIA_VO1 = 1839;
    public const NETOPIA_VO2 = 1840;
    public const NETOPIA_VO3 = 1841;
    public const NETOPIA_VO4 = 1842;
    public const NETOPIA_VO5 = 1843;
    public const DIRECPC_DLL = 1844;
    public const ALTALINK = 1845;
    public const TUNSTALL_PNC = 1846;
    public const SLP_NOTIFY = 1847;
    public const FJDOCDIST = 1848;
    public const ALPHA_SMS = 1849;
    public const GSI = 1850;
    public const CTCD = 1851;
    public const VIRTUAL_TIME = 1852;
    public const VIDS_AVTP = 1853;
    public const BUDDY_DRAW = 1854;
    public const FIORANO_RTRSVC = 1855;
    public const FIORANO_MSGSVC = 1856;
    public const DATACAPTOR = 1857;
    public const PRIVATEARK = 1858;
    public const GAMMAFETCHSVR = 1859;
    public const SUNSCALAR_SVC = 1860;
    public const LECROY_VICP = 1861;
    public const MYSQL_CM_AGENT = 1862;
    public const MSNP = 1863;
    public const PARADYM_31PORT = 1864;
    public const ENTP = 1865;
    public const SWRMI = 1866;
    public const UDRIVE = 1867;
    public const VIZIBLEBROWSER = 1868;
    public const TRANSACT = 1869;
    public const SUNSCALAR_DNS = 1870;
    public const CANOCENTRAL0 = 1871;
    public const CANOCENTRAL1 = 1872;
    public const FJMPJPS = 1873;
    public const FJSWAPSNP = 1874;
    public const WESTELL_STATS = 1875;
    public const EWCAPPSRV = 1876;
    public const HP_WEBQOSDB = 1877;
    public const DRMSMC = 1878;
    public const NETTGAIN_NMS = 1879;
    public const VSAT_CONTROL = 1880;
    public const IBM_MQSERIES2 = 1881;
    public const ECSQDMN = 1882;
    public const MQTT = 1883;
    public const IDMAPS = 1884;
    public const VRTSTRAPSERVER = 1885;
    public const LEOIP = 1886;
    public const FILEX_LPORT = 1887;
    public const NCCONFIG = 1888;
    public const UNIFY_ADAPTER = 1889;
    public const WILKENLISTENER = 1890;
    public const CHILDKEY_NOTIF = 1891;
    public const CHILDKEY_CTRL = 1892;
    public const ELAD = 1893;
    public const O2SERVER_PORT = 1894;
    public const B_NOVATIVE_LS = 1896;
    public const METAAGENT = 1897;
    public const CYMTEC_PORT = 1898;
    public const MC2STUDIOS = 1899;
    public const SSDP = 1900;
    public const FJICL_TEP_A = 1901;
    public const FJICL_TEP_B = 1902;
    public const LINKNAME = 1903;
    public const FJICL_TEP_C = 1904;
    public const SUGP = 1905;
    public const TPMD = 1906;
    public const INTRASTAR = 1907;
    public const DAWN = 1908;
    public const GLOBAL_WLINK = 1909;
    public const ULTRABAC = 1910;
    public const MTP = 1911;
    public const RHP_IIBP = 1912;
    public const ARMADP = 1913;
    public const ELM_MOMENTUM = 1914;
    public const FACELINK = 1915;
    public const PERSONA = 1916;
    public const NOAGENT = 1917;
    public const CAN_NDS = 1918;
    public const CAN_DCH = 1919;
    public const CAN_FERRET = 1920;
    public const NOADMIN = 1921;
    public const TAPESTRY = 1922;
    public const SPICE = 1923;
    public const XIIP = 1924;
    public const DISCOVERY_PORT = 1925;
    public const EGS = 1926;
    public const VIDETE_CIPC = 1927;
    public const EMSD_PORT = 1928;
    public const BANDWIZ_SYSTEM = 1929;
    public const DRIVEAPPSERVER = 1930;
    public const AMDSCHED = 1931;
    public const CTT_BROKER = 1932;
    public const XMAPI = 1933;
    public const XAAPI = 1934;
    public const MACROMEDIA_FCS = 1935;
    public const JETCMESERVER = 1936;
    public const JWSERVER = 1937;
    public const JWCLIENT = 1938;
    public const JVSERVER = 1939;
    public const JVCLIENT = 1940;
    public const DIC_AIDA = 1941;
    public const RES = 1942;
    public const BEEYOND_MEDIA = 1943;
    public const CLOSE_COMBAT = 1944;
    public const DIALOGIC_ELMD = 1945;
    public const TEKPLS = 1946;
    public const SENTINELSRM = 1947;
    public const EYE2EYE = 1948;
    public const ISMAEASDAQLIVE = 1949;
    public const ISMAEASDAQTEST = 1950;
    public const BCS_LMSERVER = 1951;
    public const MPNJSC = 1952;
    public const RAPIDBASE = 1953;
    public const ABR_API = 1954;
    public const ABR_SECURE = 1955;
    public const VRTL_VMF_DS = 1956;
    public const UNIX_STATUS = 1957;
    public const DXADMIND = 1958;
    public const SIMP_ALL = 1959;
    public const NASMANAGER = 1960;
    public const BTS_APPSERVER = 1961;
    public const BIAP_MP = 1962;
    public const WEBMACHINE = 1963;
    public const SOLID_E_ENGINE = 1964;
    public const TIVOLI_NPM = 1965;
    public const SLUSH = 1966;
    public const SNS_QUOTE = 1967;
    public const LIPSINC = 1968;
    public const LIPSINC1 = 1969;
    public const NETOP_RC = 1970;
    public const NETOP_SCHOOL = 1971;
    public const INTERSYS_CACHE = 1972;
    public const DLSRAP = 1973;
    public const DRP = 1974;
    public const TCOFLASHAGENT = 1975;
    public const TCOREGAGENT = 1976;
    public const TCOADDRESSBOOK = 1977;
    public const UNISQL = 1978;
    public const UNISQL_JAVA = 1979;
    public const PEARLDOC_XACT = 1980;
    public const P2PQ = 1981;
    public const ESTAMP = 1982;
    public const LHTP = 1983;
    public const BB = 1984;
    public const HSRP = 1985;
    public const LICENSEDAEMON = 1986;
    public const TR_RSRB_P1 = 1987;
    public const TR_RSRB_P2 = 1988;
    public const TR_RSRB_P3 = 1989;
    public const STUN_P1 = 1990;
    public const STUN_P2 = 1991;
    public const STUN_P3 = 1992;
    public const SNMP_TCP_PORT = 1993;
    public const STUN_PORT = 1994;
    public const PERF_PORT = 1995;
    public const TR_RSRB_PORT = 1996;
    public const GDP_PORT = 1997;
    public const X25_SVC_PORT = 1998;
    public const TCP_ID_PORT = 1999;
    public const CISCO_SCCP = 2000;
    public const DC = 2001;
    public const GLOBE = 2002;
    public const BRUTUS = 2003;
    public const MAILBOX = 2004;
    public const BERKNET = 2005;
    public const INVOKATOR = 2006;
    public const DECTALK = 2007;
    public const CONF = 2008;
    public const NEWS = 2009;
    public const SEARCH = 2010;
    public const RAID_CC = 2011;
    public const TTYINFO = 2012;
    public const RAID_AM = 2013;
    public const TROFF = 2014;
    public const CYPRESS = 2015;
    public const BOOTSERVER = 2016;
    public const CYPRESS_STAT = 2017;
    public const TERMINALDB = 2018;
    public const WHOSOCKAMI = 2019;
    public const XINUPAGESERVER = 2020;
    public const SERVEXEC = 2021;
    public const DOWN = 2022;
    public const XINUEXPANSION3 = 2023;
    public const XINUEXPANSION4 = 2024;
    public const ELLPACK = 2025;
    public const SCRABBLE = 2026;
    public const SHADOWSERVER = 2027;
    public const SUBMITSERVER = 2028;
    public const HSRPV6 = 2029;
    public const DEVICE2 = 2030;
    public const MOBRIEN_CHAT = 2031;
    public const BLACKBOARD = 2032;
    public const GLOGGER = 2033;
    public const SCOREMGR = 2034;
    public const IMSLDOC = 2035;
    public const E_DPNET = 2036;
    public const APPLUS = 2037;
    public const OBJECTMANAGER = 2038;
    public const PRIZMA = 2039;
    public const LAM = 2040;
    public const INTERBASE = 2041;
    public const ISIS = 2042;
    public const ISIS_BCAST = 2043;
    public const RIMSL = 2044;
    public const CDFUNC = 2045;
    public const SDFUNC = 2046;
    public const DLS_2 = 2047;
    public const DLS_MONITOR = 2048;
    public const NFS = 2049;
    public const AV_EMB_CONFIG = 2050;
    public const EPNSDP = 2051;
    public const CLEARVISN = 2052;
    public const LOT105_DS_UPD = 2053;
    public const WEBLOGIN = 2054;
    public const IOP = 2055;
    public const OMNISKY = 2056;
    public const RICH_CP = 2057;
    public const NEWWAVESEARCH = 2058;
    public const BMC_MESSAGING = 2059;
    public const TELENIUMDAEMON = 2060;
    public const NETMOUNT = 2061;
    public const ICG_SWP = 2062;
    public const ICG_BRIDGE = 2063;
    public const ICG_IPRELAY = 2064;
    public const DLSRPN = 2065;
    public const AURA = 2066;
    public const DLSWPN = 2067;
    public const AVAUTHSRVPRTCL = 2068;
    public const EVENT_PORT = 2069;
    public const AH_ESP_ENCAP = 2070;
    public const ACP_PORT = 2071;
    public const MSYNC = 2072;
    public const GXS_DATA_PORT = 2073;
    public const VRTL_VMF_SA = 2074;
    public const NEWLIXENGINE = 2075;
    public const NEWLIXCONFIG = 2076;
    public const TSRMAGT = 2077;
    public const TPCSRVR = 2078;
    public const IDWARE_ROUTER = 2079;
    public const AUTODESK_NLM = 2080;
    public const KME_TRAP_PORT = 2081;
    public const INFOWAVE = 2082;
    public const RADSEC = 2083;
    public const SUNCLUSTERGEO = 2084;
    public const ADA_CIP = 2085;
    public const GNUNET = 2086;
    public const ELI = 2087;
    public const IP_BLF = 2088;
    public const SEP = 2089;
    public const LRP = 2090;
    public const PRP = 2091;
    public const DESCENT3 = 2092;
    public const NBX_CC = 2093;
    public const NBX_AU = 2094;
    public const NBX_SER = 2095;
    public const NBX_DIR = 2096;
    public const JETFORMPREVIEW = 2097;
    public const DIALOG_PORT = 2098;
    public const H2250_ANNEX_G = 2099;
    public const AMIGANETFS = 2100;
    public const RTCM_SC104 = 2101;
    public const ZEPHYR_SRV = 2102;
    public const ZEPHYR_CLT = 2103;
    public const ZEPHYR_HM = 2104;
    public const MINIPAY = 2105;
    public const MZAP = 2106;
    public const BINTEC_ADMIN = 2107;
    public const COMCAM = 2108;
    public const ERGOLIGHT = 2109;
    public const UMSP = 2110;
    public const DSATP = 2111;
    public const IDONIX_METANET = 2112;
    public const HSL_STORM = 2113;
    public const ARIASCRIBE = 2114;
    public const KDM = 2115;
    public const CCOWCMR = 2116;
    public const MENTACLIENT = 2117;
    public const MENTASERVER = 2118;
    public const GSIGATEKEEPER = 2119;
    public const QENCP = 2120;
    public const SCIENTIA_SSDB = 2121;
    public const CAUPC_REMOTE = 2122;
    public const GTP_CONTROL = 2123;
    public const ELATELINK = 2124;
    public const LOCKSTEP = 2125;
    public const PKTCABLE_COPS = 2126;
    public const INDEX_PC_WB = 2127;
    public const NET_STEWARD = 2128;
    public const CS_LIVE = 2129;
    public const XDS = 2130;
    public const AVANTAGEB2B = 2131;
    public const SOLERA_EPMAP = 2132;
    public const ZYMED_ZPP = 2133;
    public const AVENUE = 2134;
    public const GRIS = 2135;
    public const APPWORXSRV = 2136;
    public const CONNECT = 2137;
    public const UNBIND_CLUSTER = 2138;
    public const IAS_AUTH = 2139;
    public const IAS_REG = 2140;
    public const IAS_ADMIND = 2141;
    public const TDMOIP = 2142;
    public const LV_JC = 2143;
    public const LV_FFX = 2144;
    public const LV_PICI = 2145;
    public const LV_NOT = 2146;
    public const LV_AUTH = 2147;
    public const VERITAS_UCL = 2148;
    public const ACPTSYS = 2149;
    public const DYNAMIC3D = 2150;
    public const DOCENT = 2151;
    public const GTP_USER = 2152;
    public const CTLPTC = 2153;
    public const STDPTC = 2154;
    public const BRDPTC = 2155;
    public const TRP = 2156;
    public const XNDS = 2157;
    public const TOUCHNETPLUS = 2158;
    public const GDBREMOTE = 2159;
    public const APC_2160 = 2160;
    public const APC_2161 = 2161;
    public const NAVISPHERE = 2162;
    public const NAVISPHERE_SEC = 2163;
    public const DDNS_V3 = 2164;
    public const X_BONE_API = 2165;
    public const IWSERVER = 2166;
    public const RAW_SERIAL = 2167;
    public const EASY_SOFT_MUX = 2168;
    public const BRAIN = 2169;
    public const EYETV = 2170;
    public const MSFW_STORAGE = 2171;
    public const MSFW_S_STORAGE = 2172;
    public const MSFW_REPLICA = 2173;
    public const MSFW_ARRAY = 2174;
    public const AIRSYNC = 2175;
    public const RAPI = 2176;
    public const QWAVE = 2177;
    public const BITSPEER = 2178;
    public const VMRDP = 2179;
    public const MC_GT_SRV = 2180;
    public const EFORWARD = 2181;
    public const CGN_STAT = 2182;
    public const CGN_CONFIG = 2183;
    public const NVD = 2184;
    public const ONBASE_DDS = 2185;
    public const GTAUA = 2186;
    public const SSMC = 2187;
    public const RADWARE_RPM = 2188;
    public const RADWARE_RPM_S = 2189;
    public const TIVOCONNECT = 2190;
    public const TVBUS = 2191;
    public const ASDIS = 2192;
    public const DRWCS = 2193;
    public const MNP_EXCHANGE = 2197;
    public const ONEHOME_REMOTE = 2198;
    public const ONEHOME_HELP = 2199;
    public const ICI = 2200;
    public const ATS = 2201;
    public const IMTC_MAP = 2202;
    public const B2_RUNTIME = 2203;
    public const B2_LICENSE = 2204;
    public const JPS = 2205;
    public const HPOCBUS = 2206;
    public const HPSSD = 2207;
    public const HPIOD = 2208;
    public const RIMF_PS = 2209;
    public const NOAAPORT = 2210;
    public const EMWIN = 2211;
    public const LEECOPOSSERVER = 2212;
    public const KALI = 2213;
    public const RPI = 2214;
    public const IPCORE = 2215;
    public const VTU_COMMS = 2216;
    public const GOTODEVICE = 2217;
    public const BOUNZZA = 2218;
    public const NETIQ_NCAP = 2219;
    public const NETIQ = 2220;
    public const ETHERNET_IP_S = 2221;
    public const ETHERNET_IP_1 = 2222;
    public const ROCKWELL_CSP2 = 2223;
    public const EFI_MG = 2224;
    public const RCIP_ITU = 2225;
    public const DI_DRM = 2226;
    public const DI_MSG = 2227;
    public const EHOME_MS = 2228;
    public const DATALENS = 2229;
    public const QUEUEADM = 2230;
    public const WIMAXASNCP = 2231;
    public const IVS_VIDEO = 2232;
    public const INFOCRYPT = 2233;
    public const DIRECTPLAY = 2234;
    public const SERCOMM_WLINK = 2235;
    public const NANI = 2236;
    public const OPTECH_PORT1_LM = 2237;
    public const AVIVA_SNA = 2238;
    public const IMAGEQUERY = 2239;
    public const RECIPE = 2240;
    public const IVSD = 2241;
    public const FOLIOCORP = 2242;
    public const MAGICOM = 2243;
    public const NMSSERVER = 2244;
    public const HAO = 2245;
    public const PC_MTA_ADDRMAP = 2246;
    public const ANTIDOTEMGRSVR = 2247;
    public const UMS = 2248;
    public const RFMP = 2249;
    public const REMOTE_COLLAB = 2250;
    public const DIF_PORT = 2251;
    public const NJENET_SSL = 2252;
    public const DTV_CHAN_REQ = 2253;
    public const SEISPOC = 2254;
    public const VRTP = 2255;
    public const PCC_MFP = 2256;
    public const SIMPLE_TX_RX = 2257;
    public const RCTS = 2258;
    public const APC_2260 = 2260;
    public const COMOTIONMASTER = 2261;
    public const COMOTIONBACK = 2262;
    public const ECWCFG = 2263;
    public const APX500API_1 = 2264;
    public const APX500API_2 = 2265;
    public const MFSERVER = 2266;
    public const ONTOBROKER = 2267;
    public const AMT = 2268;
    public const MIKEY = 2269;
    public const STARSCHOOL = 2270;
    public const MMCALS = 2271;
    public const MMCAL = 2272;
    public const MYSQL_IM = 2273;
    public const PCTTUNNELL = 2274;
    public const IBRIDGE_DATA = 2275;
    public const IBRIDGE_MGMT = 2276;
    public const BLUECTRLPROXY = 2277;
    public const S3DB = 2278;
    public const XMQUERY = 2279;
    public const LNVPOLLER = 2280;
    public const LNVCONSOLE = 2281;
    public const LNVALARM = 2282;
    public const LNVSTATUS = 2283;
    public const LNVMAPS = 2284;
    public const LNVMAILMON = 2285;
    public const NAS_METERING = 2286;
    public const DNA = 2287;
    public const NETML = 2288;
    public const DICT_LOOKUP = 2289;
    public const SONUS_LOGGING = 2290;
    public const EAPSP = 2291;
    public const MIB_STREAMING = 2292;
    public const NPDBGMNGR = 2293;
    public const KONSHUS_LM = 2294;
    public const ADVANT_LM = 2295;
    public const THETA_LM = 2296;
    public const D2K_DATAMOVER1 = 2297;
    public const D2K_DATAMOVER2 = 2298;
    public const PC_TELECOMMUTE = 2299;
    public const CVMMON = 2300;
    public const CPQ_WBEM = 2301;
    public const BINDERYSUPPORT = 2302;
    public const PROXY_GATEWAY = 2303;
    public const ATTACHMATE_UTS = 2304;
    public const MT_SCALESERVER = 2305;
    public const TAPPI_BOXNET = 2306;
    public const PEHELP = 2307;
    public const SDHELP = 2308;
    public const SDSERVER = 2309;
    public const SDCLIENT = 2310;
    public const MESSAGESERVICE = 2311;
    public const WANSCALER = 2312;
    public const IAPP = 2313;
    public const CR_WEBSYSTEMS = 2314;
    public const PRECISE_SFT = 2315;
    public const SENT_LM = 2316;
    public const ATTACHMATE_G32 = 2317;
    public const CADENCECONTROL = 2318;
    public const INFOLIBRIA = 2319;
    public const SIEBEL_NS = 2320;
    public const RDLAP = 2321;
    public const OFSD = 2322;
    public const _3D_NFSD = 2323;
    public const COSMOCALL = 2324;
    public const ANSYSLI = 2325;
    public const IDCP = 2326;
    public const XINGCSM = 2327;
    public const NETRIX_SFTM = 2328;
    public const NVD_2 = 2329;
    public const TSCCHAT = 2330;
    public const AGENTVIEW = 2331;
    public const RCC_HOST = 2332;
    public const SNAPP = 2333;
    public const ACE_CLIENT = 2334;
    public const ACE_PROXY = 2335;
    public const APPLEUGCONTROL = 2336;
    public const IDEESRV = 2337;
    public const NORTON_LAMBERT = 2338;
    public const _3COM_WEBVIEW = 2339;
    public const WRS_REGISTRY = 2340;
    public const XIOSTATUS = 2341;
    public const MANAGE_EXEC = 2342;
    public const NATI_LOGOS = 2343;
    public const FCMSYS = 2344;
    public const DBM = 2345;
    public const REDSTORM_JOIN = 2346;
    public const REDSTORM_FIND = 2347;
    public const REDSTORM_INFO = 2348;
    public const REDSTORM_DIAG = 2349;
    public const PSBSERVER = 2350;
    public const PSRSERVER = 2351;
    public const PSLSERVER = 2352;
    public const PSPSERVER = 2353;
    public const PSPRSERVER = 2354;
    public const PSDBSERVER = 2355;
    public const GXTELMD = 2356;
    public const UNIHUB_SERVER = 2357;
    public const FUTRIX = 2358;
    public const FLUKESERVER = 2359;
    public const NEXSTORINDLTD = 2360;
    public const TL1 = 2361;
    public const DIGIMAN = 2362;
    public const MEDIACNTRLNFSD = 2363;
    public const OI_2000 = 2364;
    public const DBREF = 2365;
    public const QIP_LOGIN = 2366;
    public const SERVICE_CTRL = 2367;
    public const OPENTABLE = 2368;
    public const L3_HBMON = 2370;
    public const HP_RDA = 2371;
    public const LANMESSENGER = 2372;
    public const REMOGRAPHLM = 2373;
    public const HYDRA = 2374;
    public const DOCKER = 2375;
    public const DOCKER_S = 2376;
    public const SWARM = 2377;
    public const ETCD_CLIENT = 2379;
    public const ETCD_SERVER = 2380;
    public const COMPAQ_HTTPS = 2381;
    public const MS_OLAP3 = 2382;
    public const MS_OLAP4 = 2383;
    public const SD_REQUEST = 2384;
    public const SD_DATA = 2385;
    public const VIRTUALTAPE = 2386;
    public const VSAMREDIRECTOR = 2387;
    public const MYNAHAUTOSTART = 2388;
    public const OVSESSIONMGR = 2389;
    public const RSMTP = 2390;
    public const _3COM_NET_MGMT = 2391;
    public const TACTICALAUTH = 2392;
    public const MS_OLAP1 = 2393;
    public const MS_OLAP2 = 2394;
    public const LAN900_REMOTE = 2395;
    public const WUSAGE = 2396;
    public const NCL = 2397;
    public const ORBITER = 2398;
    public const FMPRO_FDAL = 2399;
    public const OPEQUUS_SERVER = 2400;
    public const CVSPSERVER = 2401;
    public const TASKMASTER2000 = 2402;
    public const TASKMASTER2000_2 = 2403;
    public const IEC_104 = 2404;
    public const TRC_NETPOLL = 2405;
    public const JEDISERVER = 2406;
    public const ORION = 2407;
    public const RAILGUN_WEBACCL = 2408;
    public const SNS_PROTOCOL = 2409;
    public const VRTS_REGISTRY = 2410;
    public const NETWAVE_AP_MGMT = 2411;
    public const CDN = 2412;
    public const ORION_RMI_REG = 2413;
    public const BEEYOND = 2414;
    public const CODIMA_RTP = 2415;
    public const RMTSERVER = 2416;
    public const COMPOSIT_SERVER = 2417;
    public const CAS = 2418;
    public const ATTACHMATE_S2S = 2419;
    public const DSLREMOTE_MGMT = 2420;
    public const G_TALK = 2421;
    public const CRMSBITS = 2422;
    public const RNRP = 2423;
    public const KOFAX_SVR = 2424;
    public const FJITSUAPPMGR = 2425;
    public const VCMP = 2426;
    public const MGCP_GATEWAY = 2427;
    public const OTT = 2428;
    public const FT_ROLE = 2429;
    public const VENUS = 2430;
    public const VENUS_SE = 2431;
    public const CODASRV = 2432;
    public const CODASRV_SE = 2433;
    public const PXC_EPMAP = 2434;
    public const OPTILOGIC = 2435;
    public const TOPX = 2436;
    public const UNICONTROL = 2437;
    public const MSP_2 = 2438;
    public const SYBASEDBSYNCH = 2439;
    public const SPEARWAY = 2440;
    public const PVSW_INET = 2441;
    public const NETANGEL = 2442;
    public const POWERCLIENTCSF = 2443;
    public const BTPP2SECTRANS = 2444;
    public const DTN1 = 2445;
    public const BUES_SERVICE = 2446;
    public const OVWDB = 2447;
    public const HPPPSSVR = 2448;
    public const RATL = 2449;
    public const NETADMIN = 2450;
    public const NETCHAT = 2451;
    public const SNIFFERCLIENT = 2452;
    public const MADGE_LTD = 2453;
    public const INDX_DDS = 2454;
    public const WAGO_IO_SYSTEM = 2455;
    public const ALTAV_REMMGT = 2456;
    public const RAPIDO_IP = 2457;
    public const GRIFFIN = 2458;
    public const COMMUNITY = 2459;
    public const MS_THEATER = 2460;
    public const QADMIFOPER = 2461;
    public const QADMIFEVENT = 2462;
    public const LSI_RAID_MGMT = 2463;
    public const DIRECPC_SI = 2464;
    public const LBM = 2465;
    public const LBF = 2466;
    public const HIGH_CRITERIA = 2467;
    public const QIP_MSGD = 2468;
    public const MTI_TCS_COMM = 2469;
    public const TASKMAN_PORT = 2470;
    public const SEAODBC = 2471;
    public const C3 = 2472;
    public const AKER_CDP = 2473;
    public const VITALANALYSIS = 2474;
    public const ACE_SERVER = 2475;
    public const ACE_SVR_PROP = 2476;
    public const SSM_CVS = 2477;
    public const SSM_CSSPS = 2478;
    public const SSM_ELS = 2479;
    public const POWEREXCHANGE = 2480;
    public const GIOP = 2481;
    public const GIOP_SSL = 2482;
    public const TTC = 2483;
    public const TTC_SSL = 2484;
    public const NETOBJECTS1 = 2485;
    public const NETOBJECTS2 = 2486;
    public const PNS = 2487;
    public const MOY_CORP = 2488;
    public const TSILB = 2489;
    public const QIP_QDHCP = 2490;
    public const CONCLAVE_CPP = 2491;
    public const GROOVE = 2492;
    public const TALARIAN_MQS = 2493;
    public const BMC_AR = 2494;
    public const FAST_REM_SERV = 2495;
    public const DIRGIS = 2496;
    public const QUADDB = 2497;
    public const ODN_CASTRAQ = 2498;
    public const UNICONTROL_2 = 2499;
    public const RTSSERV = 2500;
    public const RTSCLIENT = 2501;
    public const KENTROX_PROT = 2502;
    public const NMS_DPNSS = 2503;
    public const WLBS = 2504;
    public const PPCONTROL = 2505;
    public const JBROKER = 2506;
    public const SPOCK = 2507;
    public const JDATASTORE = 2508;
    public const FJMPSS = 2509;
    public const FJAPPMGRBULK = 2510;
    public const METASTORM = 2511;
    public const CITRIXIMA = 2512;
    public const CITRIXADMIN = 2513;
    public const FACSYS_NTP = 2514;
    public const FACSYS_ROUTER = 2515;
    public const MAINCONTROL = 2516;
    public const CALL_SIG_TRANS = 2517;
    public const WILLY = 2518;
    public const GLOBMSGSVC = 2519;
    public const PVSW = 2520;
    public const ADAPTECMGR = 2521;
    public const WINDB = 2522;
    public const QKE_LLC_V3 = 2523;
    public const OPTIWAVE_LM = 2524;
    public const MS_V_WORLDS = 2525;
    public const EMA_SENT_LM = 2526;
    public const IQSERVER = 2527;
    public const NCR_CCL = 2528;
    public const UTSFTP = 2529;
    public const VRCOMMERCE = 2530;
    public const ITO_E_GUI = 2531;
    public const OVTOPMD = 2532;
    public const SNIFFERSERVER = 2533;
    public const COMBOX_WEB_ACC = 2534;
    public const MADCAP = 2535;
    public const BTPP2AUDCTR1 = 2536;
    public const UPGRADE = 2537;
    public const VNWK_PRAPI = 2538;
    public const VSIADMIN = 2539;
    public const LONWORKS = 2540;
    public const LONWORKS2 = 2541;
    public const UDRAWGRAPH = 2542;
    public const REFTEK = 2543;
    public const NOVELL_ZEN = 2544;
    public const SIS_EMT = 2545;
    public const VYTALVAULTBRTP = 2546;
    public const VYTALVAULTVSMP = 2547;
    public const VYTALVAULTPIPE = 2548;
    public const IPASS = 2549;
    public const ADS = 2550;
    public const ISG_UDA_SERVER = 2551;
    public const CALL_LOGGING = 2552;
    public const EFIDININGPORT = 2553;
    public const VCNET_LINK_V10 = 2554;
    public const COMPAQ_WCP = 2555;
    public const NICETEC_NMSVC = 2556;
    public const NICETEC_MGMT = 2557;
    public const PCLEMULTIMEDIA = 2558;
    public const LSTP = 2559;
    public const LABRAT = 2560;
    public const MOSAIXCC = 2561;
    public const DELIBO = 2562;
    public const CTI_REDWOOD = 2563;
    public const HP_3000_TELNET = 2564;
    public const COORD_SVR = 2565;
    public const PCS_PCW = 2566;
    public const CLP = 2567;
    public const SPAMTRAP = 2568;
    public const SONUSCALLSIG = 2569;
    public const HS_PORT = 2570;
    public const CECSVC = 2571;
    public const IBP = 2572;
    public const TRUSTESTABLISH = 2573;
    public const BLOCKADE_BPSP = 2574;
    public const HL7 = 2575;
    public const TCLPRODEBUGGER = 2576;
    public const SCIPTICSLSRVR = 2577;
    public const RVS_ISDN_DCP = 2578;
    public const MPFONCL = 2579;
    public const TRIBUTARY = 2580;
    public const ARGIS_TE = 2581;
    public const ARGIS_DS = 2582;
    public const MON = 2583;
    public const CYASERV = 2584;
    public const NETX_SERVER = 2585;
    public const NETX_AGENT = 2586;
    public const MASC = 2587;
    public const PRIVILEGE = 2588;
    public const QUARTUS_TCL = 2589;
    public const IDOTDIST = 2590;
    public const MAYTAGSHUFFLE = 2591;
    public const NETREK = 2592;
    public const MNS_MAIL = 2593;
    public const DTS = 2594;
    public const WORLDFUSION1 = 2595;
    public const WORLDFUSION2 = 2596;
    public const HOMESTEADGLORY = 2597;
    public const CITRIXIMACLIENT = 2598;
    public const SNAPD = 2599;
    public const HPSTGMGR = 2600;
    public const DISCP_CLIENT = 2601;
    public const DISCP_SERVER = 2602;
    public const SERVICEMETER = 2603;
    public const NSC_CCS = 2604;
    public const NSC_POSA = 2605;
    public const NETMON = 2606;
    public const CONNECTION = 2607;
    public const WAG_SERVICE = 2608;
    public const SYSTEM_MONITOR = 2609;
    public const VERSA_TEK = 2610;
    public const LIONHEAD = 2611;
    public const QPASA_AGENT = 2612;
    public const SMNTUBOOTSTRAP = 2613;
    public const NEVEROFFLINE = 2614;
    public const FIREPOWER = 2615;
    public const APPSWITCH_EMP = 2616;
    public const CMADMIN = 2617;
    public const PRIORITY_E_COM = 2618;
    public const BRUCE = 2619;
    public const LPSRECOMMENDER = 2620;
    public const MILES_APART = 2621;
    public const METRICADBC = 2622;
    public const LMDP = 2623;
    public const ARIA = 2624;
    public const BLWNKL_PORT = 2625;
    public const GBJD816 = 2626;
    public const MOSHEBEERI = 2627;
    public const DICT = 2628;
    public const SITARASERVER = 2629;
    public const SITARAMGMT = 2630;
    public const SITARADIR = 2631;
    public const IRDG_POST = 2632;
    public const INTERINTELLI = 2633;
    public const PK_ELECTRONICS = 2634;
    public const BACKBURNER = 2635;
    public const SOLVE = 2636;
    public const IMDOCSVC = 2637;
    public const SYBASEANYWHERE = 2638;
    public const AMINET = 2639;
    public const AMI_CONTROL = 2640;
    public const HDL_SRV = 2641;
    public const TRAGIC = 2642;
    public const GTE_SAMP = 2643;
    public const TRAVSOFT_IPX_T = 2644;
    public const NOVELL_IPX_CMD = 2645;
    public const AND_LM = 2646;
    public const SYNCSERVER = 2647;
    public const UPSNOTIFYPROT = 2648;
    public const VPSIPPORT = 2649;
    public const ERISTWOGUNS = 2650;
    public const EBINSITE = 2651;
    public const INTERPATHPANEL = 2652;
    public const SONUS = 2653;
    public const COREL_VNCADMIN = 2654;
    public const UNGLUE = 2655;
    public const KANA = 2656;
    public const SNS_DISPATCHER = 2657;
    public const SNS_ADMIN = 2658;
    public const SNS_QUERY = 2659;
    public const GCMONITOR = 2660;
    public const OLHOST = 2661;
    public const BINTEC_CAPI = 2662;
    public const BINTEC_TAPI = 2663;
    public const PATROL_MQ_GM = 2664;
    public const PATROL_MQ_NM = 2665;
    public const EXTENSIS = 2666;
    public const ALARM_CLOCK_S = 2667;
    public const ALARM_CLOCK_C = 2668;
    public const TOAD = 2669;
    public const TVE_ANNOUNCE = 2670;
    public const NEWLIXREG = 2671;
    public const NHSERVER = 2672;
    public const FIRSTCALL42 = 2673;
    public const EWNN = 2674;
    public const TTC_ETAP = 2675;
    public const SIMSLINK = 2676;
    public const GADGETGATE1WAY = 2677;
    public const GADGETGATE2WAY = 2678;
    public const SYNCSERVERSSL = 2679;
    public const PXC_SAPXOM = 2680;
    public const MPNJSOMB = 2681;
    public const NCDLOADBALANCE = 2683;
    public const MPNJSOSV = 2684;
    public const MPNJSOCL = 2685;
    public const MPNJSOMG = 2686;
    public const PQ_LIC_MGMT = 2687;
    public const MD_CG_HTTP = 2688;
    public const FASTLYNX = 2689;
    public const HP_NNM_DATA = 2690;
    public const ITINTERNET = 2691;
    public const ADMINS_LMS = 2692;
    public const PWRSEVENT = 2694;
    public const VSPREAD = 2695;
    public const UNIFYADMIN = 2696;
    public const OCE_SNMP_TRAP = 2697;
    public const MCK_IVPIP = 2698;
    public const CSOFT_PLUSCLNT = 2699;
    public const TQDATA = 2700;
    public const SMS_RCINFO = 2701;
    public const SMS_XFER = 2702;
    public const SMS_CHAT = 2703;
    public const SMS_REMCTRL = 2704;
    public const SDS_ADMIN = 2705;
    public const NCDMIRRORING = 2706;
    public const EMCSYMAPIPORT = 2707;
    public const BANYAN_NET = 2708;
    public const SUPERMON = 2709;
    public const SSO_SERVICE = 2710;
    public const SSO_CONTROL = 2711;
    public const AOCP = 2712;
    public const RAVENTBS = 2713;
    public const RAVENTDM = 2714;
    public const HPSTGMGR2 = 2715;
    public const INOVA_IP_DISCO = 2716;
    public const PN_REQUESTER = 2717;
    public const PN_REQUESTER2 = 2718;
    public const SCAN_CHANGE = 2719;
    public const WKARS = 2720;
    public const SMART_DIAGNOSE = 2721;
    public const PROACTIVESRVR = 2722;
    public const WATCHDOG_NT = 2723;
    public const QOTPS = 2724;
    public const MSOLAP_PTP2 = 2725;
    public const TAMS = 2726;
    public const MGCP_CALLAGENT = 2727;
    public const SQDR = 2728;
    public const TCIM_CONTROL = 2729;
    public const NEC_RAIDPLUS = 2730;
    public const FYRE_MESSANGER = 2731;
    public const G5M = 2732;
    public const SIGNET_CTF = 2733;
    public const CCS_SOFTWARE = 2734;
    public const NETIQ_MC = 2735;
    public const RADWIZ_NMS_SRV = 2736;
    public const SRP_FEEDBACK = 2737;
    public const NDL_TCP_OIS_GW = 2738;
    public const TN_TIMING = 2739;
    public const ALARM = 2740;
    public const TSB = 2741;
    public const TSB2 = 2742;
    public const MURX = 2743;
    public const HONYAKU = 2744;
    public const URBISNET = 2745;
    public const CPUDPENCAP = 2746;
    public const FJIPPOL_SWRLY = 2747;
    public const FJIPPOL_POLSVR = 2748;
    public const FJIPPOL_CNSL = 2749;
    public const FJIPPOL_PORT1 = 2750;
    public const FJIPPOL_PORT2 = 2751;
    public const RSISYSACCESS = 2752;
    public const DE_SPOT = 2753;
    public const APOLLO_CC = 2754;
    public const EXPRESSPAY = 2755;
    public const SIMPLEMENT_TIE = 2756;
    public const CNRP = 2757;
    public const APOLLO_STATUS = 2758;
    public const APOLLO_GMS = 2759;
    public const SABAMS = 2760;
    public const DICOM_ISCL = 2761;
    public const DICOM_TLS = 2762;
    public const DESKTOP_DNA = 2763;
    public const DATA_INSURANCE = 2764;
    public const QIP_AUDUP = 2765;
    public const COMPAQ_SCP = 2766;
    public const UADTC = 2767;
    public const UACS = 2768;
    public const EXCE = 2769;
    public const VERONICA = 2770;
    public const VERGENCECM = 2771;
    public const AURIS = 2772;
    public const RBAKCUP1 = 2773;
    public const RBAKCUP2 = 2774;
    public const SMPP = 2775;
    public const RIDGEWAY1 = 2776;
    public const RIDGEWAY2 = 2777;
    public const GWEN_SONYA = 2778;
    public const LBC_SYNC = 2779;
    public const LBC_CONTROL = 2780;
    public const WHOSELLS = 2781;
    public const EVERYDAYRC = 2782;
    public const AISES = 2783;
    public const WWW_DEV = 2784;
    public const AIC_NP = 2785;
    public const AIC_ONCRPC = 2786;
    public const PICCOLO = 2787;
    public const FRYESERV = 2788;
    public const MEDIA_AGENT = 2789;
    public const PLGPROXY = 2790;
    public const MTPORT_REGIST = 2791;
    public const F5_GLOBALSITE = 2792;
    public const INITLSMSAD = 2793;
    public const LIVESTATS = 2795;
    public const AC_TECH = 2796;
    public const ESP_ENCAP = 2797;
    public const TMESIS_UPSHOT = 2798;
    public const ICON_DISCOVER = 2799;
    public const ACC_RAID = 2800;
    public const IGCP = 2801;
    public const VERITAS_TCP1 = 2802;
    public const BTPRJCTRL = 2803;
    public const DVR_ESM = 2804;
    public const WTA_WSP_S = 2805;
    public const CSPUNI = 2806;
    public const CSPMULTI = 2807;
    public const J_LAN_P = 2808;
    public const CORBALOC = 2809;
    public const NETSTEWARD = 2810;
    public const GSIFTP = 2811;
    public const ATMTCP = 2812;
    public const LLM_PASS = 2813;
    public const LLM_CSV = 2814;
    public const LBC_MEASURE = 2815;
    public const LBC_WATCHDOG = 2816;
    public const NMSIGPORT = 2817;
    public const RMLNK = 2818;
    public const FC_FAULTNOTIFY = 2819;
    public const UNIVISION = 2820;
    public const VRTS_AT_PORT = 2821;
    public const KA0WUC = 2822;
    public const CQG_NETLAN = 2823;
    public const CQG_NETLAN_1 = 2824;
    public const SLC_SYSTEMLOG = 2826;
    public const SLC_CTRLRLOOPS = 2827;
    public const ITM_LM = 2828;
    public const SILKP1 = 2829;
    public const SILKP2 = 2830;
    public const SILKP3 = 2831;
    public const SILKP4 = 2832;
    public const GLISHD = 2833;
    public const EVTP = 2834;
    public const EVTP_DATA = 2835;
    public const CATALYST = 2836;
    public const REPLIWEB = 2837;
    public const STARBOT = 2838;
    public const NMSIGPORT_2 = 2839;
    public const L3_EXPRT = 2840;
    public const L3_RANGER = 2841;
    public const L3_HAWK = 2842;
    public const PDNET = 2843;
    public const BPCP_POLL = 2844;
    public const BPCP_TRAP = 2845;
    public const AIMPP_HELLO = 2846;
    public const AIMPP_PORT_REQ = 2847;
    public const AMT_BLC_PORT = 2848;
    public const FXP_2 = 2849;
    public const METACONSOLE = 2850;
    public const WEBEMSHTTP = 2851;
    public const BEARS_01 = 2852;
    public const ISPIPES = 2853;
    public const INFOMOVER = 2854;
    public const MSRP = 2855;
    public const CESDINV = 2856;
    public const SIMCTLP = 2857;
    public const ECNP = 2858;
    public const ACTIVEMEMORY = 2859;
    public const DIALPAD_VOICE1 = 2860;
    public const DIALPAD_VOICE2 = 2861;
    public const TTG_PROTOCOL = 2862;
    public const SONARDATA = 2863;
    public const ASTROMED_MAIN = 2864;
    public const PIT_VPN = 2865;
    public const IWLISTENER = 2866;
    public const ESPS_PORTAL = 2867;
    public const NPEP_MESSAGING = 2868;
    public const ICSLAP = 2869;
    public const DAISHI = 2870;
    public const MSI_SELECTPLAY = 2871;
    public const RADIX = 2872;
    public const DXMESSAGEBASE1 = 2874;
    public const DXMESSAGEBASE2 = 2875;
    public const SPS_TUNNEL = 2876;
    public const BLUELANCE = 2877;
    public const AAP = 2878;
    public const UCENTRIC_DS = 2879;
    public const SYNAPSE = 2880;
    public const NDSP = 2881;
    public const NDTP = 2882;
    public const NDNP = 2883;
    public const FLASHMSG = 2884;
    public const TOPFLOW = 2885;
    public const RESPONSELOGIC = 2886;
    public const AIRONETDDP = 2887;
    public const SPCSDLOBBY = 2888;
    public const RSOM = 2889;
    public const CSPCLMULTI = 2890;
    public const CINEGRFX_ELMD = 2891;
    public const SNIFFERDATA = 2892;
    public const VSECONNECTOR = 2893;
    public const ABACUS_REMOTE = 2894;
    public const NATUSLINK = 2895;
    public const ECOVISIONG6_1 = 2896;
    public const CITRIX_RTMP = 2897;
    public const APPLIANCE_CFG = 2898;
    public const POWERGEMPLUS = 2899;
    public const QUICKSUITE = 2900;
    public const ALLSTORCNS = 2901;
    public const NETASPI = 2902;
    public const SUITCASE = 2903;
    public const M2UA = 2904;
    public const M3UA = 2905;
    public const CALLER9 = 2906;
    public const WEBMETHODS_B2B = 2907;
    public const MAO = 2908;
    public const FUNK_DIALOUT = 2909;
    public const TDACCESS = 2910;
    public const BLOCKADE = 2911;
    public const EPICON = 2912;
    public const BOOSTERWARE = 2913;
    public const GAMELOBBY = 2914;
    public const TKSOCKET = 2915;
    public const ELVIN_SERVER = 2916;
    public const ELVIN_CLIENT = 2917;
    public const KASTENCHASEPAD = 2918;
    public const ROBOER = 2919;
    public const ROBOEDA = 2920;
    public const CESDCDMAN = 2921;
    public const CESDCDTRN = 2922;
    public const WTA_WSP_WTP_S = 2923;
    public const PRECISE_VIP = 2924;
    public const MOBILE_FILE_DL = 2926;
    public const UNIMOBILECTRL = 2927;
    public const REDSTONE_CPSS = 2928;
    public const AMX_WEBADMIN = 2929;
    public const AMX_WEBLINX = 2930;
    public const CIRCLE_X = 2931;
    public const INCP = 2932;
    public const _4_TIEROPMGW = 2933;
    public const _4_TIEROPMCLI = 2934;
    public const QTP = 2935;
    public const OTPATCH = 2936;
    public const PNACONSULT_LM = 2937;
    public const SM_PAS_1 = 2938;
    public const SM_PAS_2 = 2939;
    public const SM_PAS_3 = 2940;
    public const SM_PAS_4 = 2941;
    public const SM_PAS_5 = 2942;
    public const TTNREPOSITORY = 2943;
    public const MEGACO_H248 = 2944;
    public const H248_BINARY = 2945;
    public const FJSVMPOR = 2946;
    public const GPSD = 2947;
    public const WAP_PUSH = 2948;
    public const WAP_PUSHSECURE = 2949;
    public const ESIP = 2950;
    public const OTTP = 2951;
    public const MPFWSAS = 2952;
    public const OVALARMSRV = 2953;
    public const OVALARMSRV_CMD = 2954;
    public const CSNOTIFY = 2955;
    public const OVRIMOSDBMAN = 2956;
    public const JMACT5 = 2957;
    public const JMACT6 = 2958;
    public const RMOPAGT = 2959;
    public const DFOXSERVER = 2960;
    public const BOLDSOFT_LM = 2961;
    public const IPH_POLICY_CLI = 2962;
    public const IPH_POLICY_ADM = 2963;
    public const BULLANT_SRAP = 2964;
    public const BULLANT_RAP = 2965;
    public const IDP_INFOTRIEVE = 2966;
    public const SSC_AGENT = 2967;
    public const ENPP = 2968;
    public const ESSP = 2969;
    public const INDEX_NET = 2970;
    public const NETCLIP = 2971;
    public const PMSM_WEBRCTL = 2972;
    public const SVNETWORKS = 2973;
    public const SIGNAL = 2974;
    public const FJMPCM = 2975;
    public const CNS_SRV_PORT = 2976;
    public const TTC_ETAP_NS = 2977;
    public const TTC_ETAP_DS = 2978;
    public const H263_VIDEO = 2979;
    public const WIMD = 2980;
    public const MYLXAMPORT = 2981;
    public const IWB_WHITEBOARD = 2982;
    public const NETPLAN = 2983;
    public const HPIDSADMIN = 2984;
    public const HPIDSAGENT = 2985;
    public const STONEFALLS = 2986;
    public const IDENTIFY = 2987;
    public const HIPPAD = 2988;
    public const ZARKOV = 2989;
    public const BOSCAP = 2990;
    public const WKSTN_MON = 2991;
    public const AVENYO = 2992;
    public const VERITAS_VIS1 = 2993;
    public const VERITAS_VIS2 = 2994;
    public const IDRS = 2995;
    public const VSIXML = 2996;
    public const REBOL = 2997;
    public const REALSECURE = 2998;
    public const REMOTEWARE_UN = 2999;
    public const HBCI = 3000;
    public const ORIGO_NATIVE = 3001;
    public const EXLM_AGENT = 3002;
    public const CGMS = 3003;
    public const CSOFTRAGENT = 3004;
    public const GENIUSLM = 3005;
    public const II_ADMIN = 3006;
    public const LOTUSMTAP = 3007;
    public const MIDNIGHT_TECH = 3008;
    public const PXC_NTFY = 3009;
    public const GW = 3010;
    public const TRUSTED_WEB = 3011;
    public const TWSDSS = 3012;
    public const GILATSKYSURFER = 3013;
    public const BROKER_SERVICE = 3014;
    public const NATI_DSTP = 3015;
    public const NOTIFY_SRVR = 3016;
    public const EVENT_LISTENER = 3017;
    public const SRVC_REGISTRY = 3018;
    public const RESOURCE_MGR = 3019;
    public const CIFS = 3020;
    public const AGRISERVER = 3021;
    public const CSREGAGENT = 3022;
    public const MAGICNOTES = 3023;
    public const NDS_SSO = 3024;
    public const AREPA_RAFT = 3025;
    public const AGRI_GATEWAY = 3026;
    public const LIEBDEVMGMT_C = 3027;
    public const LIEBDEVMGMT_DM = 3028;
    public const LIEBDEVMGMT_A = 3029;
    public const AREPA_CAS = 3030;
    public const EPPC = 3031;
    public const REDWOOD_CHAT = 3032;
    public const PDB = 3033;
    public const OSMOSIS_AEEA = 3034;
    public const FJSV_GSSAGT = 3035;
    public const HAGEL_DUMP = 3036;
    public const HP_SAN_MGMT = 3037;
    public const SANTAK_UPS = 3038;
    public const COGITATE = 3039;
    public const TOMATO_SPRINGS = 3040;
    public const DI_TRACEWARE = 3041;
    public const JOURNEE = 3042;
    public const BRP = 3043;
    public const EPP_2 = 3044;
    public const RESPONSENET = 3045;
    public const DI_ASE = 3046;
    public const HLSERVER = 3047;
    public const PCTRADER = 3048;
    public const NSWS = 3049;
    public const GDS_DB = 3050;
    public const GALAXY_SERVER = 3051;
    public const APC_3052 = 3052;
    public const DSOM_SERVER = 3053;
    public const AMT_CNF_PROT = 3054;
    public const POLICYSERVER = 3055;
    public const CDL_SERVER = 3056;
    public const GOAHEAD_FLDUP = 3057;
    public const VIDEOBEANS = 3058;
    public const QSOFT = 3059;
    public const INTERSERVER = 3060;
    public const CAUTCPD = 3061;
    public const NCACN_IP_TCP = 3062;
    public const NCADG_IP_UDP = 3063;
    public const RPRT = 3064;
    public const SLINTERBASE = 3065;
    public const NETATTACHSDMP = 3066;
    public const FJHPJP = 3067;
    public const LS3BCAST = 3068;
    public const LS3 = 3069;
    public const MGXSWITCH = 3070;
    public const XPLAT_REPLICATE = 3071;
    public const CSD_MONITOR = 3072;
    public const VCRP = 3073;
    public const XBOX = 3074;
    public const ORBIX_LOCATOR = 3075;
    public const ORBIX_CONFIG = 3076;
    public const ORBIX_LOC_SSL = 3077;
    public const ORBIX_CFG_SSL = 3078;
    public const LV_FRONTPANEL = 3079;
    public const STM_PPROC = 3080;
    public const TL1_LV = 3081;
    public const TL1_RAW = 3082;
    public const TL1_TELNET = 3083;
    public const ITM_MCCS = 3084;
    public const PCIHREQ = 3085;
    public const JDL_DBKITCHEN = 3086;
    public const ASOKI_SMA = 3087;
    public const XDTP = 3088;
    public const PTK_ALINK = 3089;
    public const STSS = 3090;
    public const _1CI_SMCS = 3091;
    public const RAPIDMQ_CENTER = 3093;
    public const RAPIDMQ_REG = 3094;
    public const PANASAS = 3095;
    public const NDL_APS = 3096;
    public const UMM_PORT = 3098;
    public const CHMD = 3099;
    public const OPCON_XPS = 3100;
    public const HP_PXPIB = 3101;
    public const SLSLAVEMON = 3102;
    public const AUTOCUESMI = 3103;
    public const AUTOCUELOG = 3104;
    public const CARDBOX = 3105;
    public const CARDBOX_HTTP = 3106;
    public const BUSINESS = 3107;
    public const GEOLOCATE = 3108;
    public const PERSONNEL = 3109;
    public const SIM_CONTROL = 3110;
    public const WSYNCH = 3111;
    public const KSYSGUARD = 3112;
    public const CS_AUTH_SVR = 3113;
    public const CCMAD = 3114;
    public const MCTET_MASTER = 3115;
    public const MCTET_GATEWAY = 3116;
    public const MCTET_JSERV = 3117;
    public const PKAGENT = 3118;
    public const D2000KERNEL = 3119;
    public const D2000WEBSERVER = 3120;
    public const PCMK_REMOTE = 3121;
    public const VTR_EMULATOR = 3122;
    public const EDIX = 3123;
    public const BEACON_PORT = 3124;
    public const A13_AN = 3125;
    public const CTX_BRIDGE = 3127;
    public const NDL_AAS = 3128;
    public const NETPORT_ID = 3129;
    public const ICPV2 = 3130;
    public const NETBOOKMARK = 3131;
    public const MS_RULE_ENGINE = 3132;
    public const PRISM_DEPLOY = 3133;
    public const ECP = 3134;
    public const PEERBOOK_PORT = 3135;
    public const GRUBD = 3136;
    public const RTNT_1 = 3137;
    public const RTNT_2 = 3138;
    public const INCOGNITORV = 3139;
    public const ARILIAMULTI = 3140;
    public const VMODEM = 3141;
    public const RDC_WH_EOS = 3142;
    public const SEAVIEW = 3143;
    public const TARANTELLA = 3144;
    public const CSI_LFAP = 3145;
    public const BEARS_02 = 3146;
    public const RFIO = 3147;
    public const NM_GAME_ADMIN = 3148;
    public const NM_GAME_SERVER = 3149;
    public const NM_ASSES_ADMIN = 3150;
    public const NM_ASSESSOR = 3151;
    public const FEITIANROCKEY = 3152;
    public const S8_CLIENT_PORT = 3153;
    public const CCMRMI = 3154;
    public const JPEGMPEG = 3155;
    public const INDURA = 3156;
    public const E3CONSULTANTS = 3157;
    public const STVP = 3158;
    public const NAVEGAWEB_PORT = 3159;
    public const TIP_APP_SERVER = 3160;
    public const DOC1LM = 3161;
    public const SFLM = 3162;
    public const RES_SAP = 3163;
    public const IMPRS = 3164;
    public const NEWGENPAY = 3165;
    public const SOSSECOLLECTOR = 3166;
    public const NOWCONTACT = 3167;
    public const POWERONNUD = 3168;
    public const SERVERVIEW_AS = 3169;
    public const SERVERVIEW_ASN = 3170;
    public const SERVERVIEW_GF = 3171;
    public const SERVERVIEW_RM = 3172;
    public const SERVERVIEW_ICC = 3173;
    public const ARMI_SERVER = 3174;
    public const T1_E1_OVER_IP = 3175;
    public const ARS_MASTER = 3176;
    public const PHONEX_PORT = 3177;
    public const RADCLIENTPORT = 3178;
    public const H2GF_W_2M = 3179;
    public const MC_BRK_SRV = 3180;
    public const BMCPATROLAGENT = 3181;
    public const BMCPATROLRNVU = 3182;
    public const COPS_TLS = 3183;
    public const APOGEEX_PORT = 3184;
    public const SMPPPD = 3185;
    public const IIW_PORT = 3186;
    public const ODI_PORT = 3187;
    public const BRCM_COMM_PORT = 3188;
    public const PCLE_INFEX = 3189;
    public const CSVR_PROXY = 3190;
    public const CSVR_SSLPROXY = 3191;
    public const FIREMONRCC = 3192;
    public const SPANDATAPORT = 3193;
    public const MAGBIND = 3194;
    public const NCU_1 = 3195;
    public const NCU_2 = 3196;
    public const EMBRACE_DP_S = 3197;
    public const EMBRACE_DP_C = 3198;
    public const DMOD_WORKSPACE = 3199;
    public const TICK_PORT = 3200;
    public const CPQ_TASKSMART = 3201;
    public const INTRAINTRA = 3202;
    public const NETWATCHER_MON = 3203;
    public const NETWATCHER_DB = 3204;
    public const ISNS = 3205;
    public const IRONMAIL = 3206;
    public const VX_AUTH_PORT = 3207;
    public const PFU_PRCALLBACK = 3208;
    public const NETWKPATHENGINE = 3209;
    public const FLAMENCO_PROXY = 3210;
    public const AVSECUREMGMT = 3211;
    public const SURVEYINST = 3212;
    public const NEON24X7 = 3213;
    public const JMQ_DAEMON_1 = 3214;
    public const JMQ_DAEMON_2 = 3215;
    public const FERRARI_FOAM = 3216;
    public const UNITE = 3217;
    public const SMARTPACKETS = 3218;
    public const WMS_MESSENGER = 3219;
    public const XNM_SSL = 3220;
    public const XNM_CLEAR_TEXT = 3221;
    public const GLBP = 3222;
    public const DIGIVOTE = 3223;
    public const AES_DISCOVERY = 3224;
    public const FCIP_PORT = 3225;
    public const ISI_IRP = 3226;
    public const DWNMSHTTP = 3227;
    public const DWMSGSERVER = 3228;
    public const GLOBAL_CD_PORT = 3229;
    public const SFTDST_PORT = 3230;
    public const VIDIGO = 3231;
    public const MDTP = 3232;
    public const WHISKER = 3233;
    public const ALCHEMY = 3234;
    public const MDAP_PORT = 3235;
    public const APPARENET_TS = 3236;
    public const APPARENET_TPS = 3237;
    public const APPARENET_AS = 3238;
    public const APPARENET_UI = 3239;
    public const TRIOMOTION = 3240;
    public const SYSORB = 3241;
    public const SDP_ID_PORT = 3242;
    public const TIMELOT = 3243;
    public const ONESAF = 3244;
    public const VIEO_FE = 3245;
    public const DVT_SYSTEM = 3246;
    public const DVT_DATA = 3247;
    public const PROCOS_LM = 3248;
    public const SSP = 3249;
    public const HICP = 3250;
    public const SYSSCANNER = 3251;
    public const DHE = 3252;
    public const PDA_DATA = 3253;
    public const PDA_SYS = 3254;
    public const SEMAPHORE = 3255;
    public const CPQRPM_AGENT = 3256;
    public const CPQRPM_SERVER = 3257;
    public const IVECON_PORT = 3258;
    public const EPNCDP2 = 3259;
    public const ISCSI_TARGET = 3260;
    public const WINSHADOW = 3261;
    public const NECP = 3262;
    public const ECOLOR_IMAGER = 3263;
    public const CCMAIL = 3264;
    public const ALTAV_TUNNEL = 3265;
    public const NS_CFG_SERVER = 3266;
    public const IBM_DIAL_OUT = 3267;
    public const MSFT_GC = 3268;
    public const MSFT_GC_SSL = 3269;
    public const VERISMART = 3270;
    public const CSOFT_PREV = 3271;
    public const USER_MANAGER = 3272;
    public const SXMP = 3273;
    public const ORDINOX_SERVER = 3274;
    public const SAMD = 3275;
    public const MAXIM_ASICS = 3276;
    public const AWG_PROXY = 3277;
    public const LKCMSERVER = 3278;
    public const ADMIND = 3279;
    public const VS_SERVER = 3280;
    public const SYSOPT = 3281;
    public const DATUSORB = 3282;
    public const APPLE_REMOTE_DESKTOP = 3283;
    public const _4TALK = 3284;
    public const PLATO = 3285;
    public const E_NET = 3286;
    public const DIRECTVDATA = 3287;
    public const COPS = 3288;
    public const ENPC = 3289;
    public const CAPS_LM = 3290;
    public const SAH_LM = 3291;
    public const CART_O_RAMA = 3292;
    public const FG_FPS = 3293;
    public const FG_GIP = 3294;
    public const DYNIPLOOKUP = 3295;
    public const RIB_SLM = 3296;
    public const CYTEL_LM = 3297;
    public const DESKVIEW = 3298;
    public const PDRNCS = 3299;
    public const CEPH = 3300;
    public const MCS_FASTMAIL = 3302;
    public const OPSESSION_CLNT = 3303;
    public const OPSESSION_SRVR = 3304;
    public const ODETTE_FTP = 3305;
    public const MYSQL = 3306;
    public const OPSESSION_PRXY = 3307;
    public const TNS_SERVER = 3308;
    public const TNS_ADV = 3309;
    public const DYNA_ACCESS = 3310;
    public const MCNS_TEL_RET = 3311;
    public const APPMAN_SERVER = 3312;
    public const UORB = 3313;
    public const UOHOST = 3314;
    public const CDID = 3315;
    public const AICC_CMI = 3316;
    public const VSAIPORT = 3317;
    public const SSRIP = 3318;
    public const SDT_LMD = 3319;
    public const OFFICELINK2000 = 3320;
    public const VNSSTR = 3321;
    public const ACTIVE_NET = 3322;
    public const ACTIVE_NET_2 = 3323;
    public const ACTIVE_NET_3 = 3324;
    public const ACTIVE_NET_4 = 3325;
    public const SFTU = 3326;
    public const BBARS = 3327;
    public const EGPTLM = 3328;
    public const HP_DEVICE_DISC = 3329;
    public const MCS_CALYPSOICF = 3330;
    public const MCS_MESSAGING = 3331;
    public const MCS_MAILSVR = 3332;
    public const DEC_NOTES = 3333;
    public const DIRECTV_WEB = 3334;
    public const DIRECTV_SOFT = 3335;
    public const DIRECTV_TICK = 3336;
    public const DIRECTV_CATLG = 3337;
    public const ANET_B = 3338;
    public const ANET_L = 3339;
    public const ANET_M = 3340;
    public const ANET_H = 3341;
    public const WEBTIE = 3342;
    public const MS_CLUSTER_NET = 3343;
    public const BNT_MANAGER = 3344;
    public const INFLUENCE = 3345;
    public const TRNSPRNTPROXY = 3346;
    public const PHOENIX_RPC = 3347;
    public const PANGOLIN_LASER = 3348;
    public const CHEVINSERVICES = 3349;
    public const FINDVIATV = 3350;
    public const BTRIEVE = 3351;
    public const SSQL = 3352;
    public const FATPIPE = 3353;
    public const SUITJD = 3354;
    public const ORDINOX_DBASE = 3355;
    public const UPNOTIFYPS = 3356;
    public const ADTECH_TEST = 3357;
    public const MPSYSRMSVR = 3358;
    public const WG_NETFORCE = 3359;
    public const KV_SERVER = 3360;
    public const KV_AGENT = 3361;
    public const DJ_ILM = 3362;
    public const NATI_VI_SERVER = 3363;
    public const CREATIVESERVER_2 = 3364;
    public const CONTENTSERVER_2 = 3365;
    public const CREATIVEPARTNR_2 = 3366;
    public const SATVID_DATALNK = 3367;
    public const SATVID_DATALNK_2 = 3368;
    public const SATVID_DATALNK_3 = 3369;
    public const SATVID_DATALNK_4 = 3370;
    public const SATVID_DATALNK_5 = 3371;
    public const TIP2 = 3372;
    public const LAVENIR_LM = 3373;
    public const CLUSTER_DISC = 3374;
    public const VSNM_AGENT = 3375;
    public const CDBROKER = 3376;
    public const COGSYS_LM = 3377;
    public const WSICOPY = 3378;
    public const SOCORFS = 3379;
    public const SNS_CHANNELS = 3380;
    public const GENEOUS = 3381;
    public const FUJITSU_NEAT = 3382;
    public const ESP_LM = 3383;
    public const HP_CLIC = 3384;
    public const QNXNETMAN = 3385;
    public const GPRS_DATA = 3386;
    public const BACKROOMNET = 3387;
    public const CBSERVER = 3388;
    public const MS_WBT_SERVER = 3389;
    public const DSC = 3390;
    public const SAVANT = 3391;
    public const EFI_LM = 3392;
    public const D2K_TAPESTRY1 = 3393;
    public const D2K_TAPESTRY2 = 3394;
    public const DYNA_LM = 3395;
    public const PRINTER_AGENT = 3396;
    public const CLOANTO_LM = 3397;
    public const MERCANTILE = 3398;
    public const CSMS = 3399;
    public const CSMS2 = 3400;
    public const FILECAST = 3401;
    public const FXAENGINE_NET = 3402;
    public const NOKIA_ANN_CH1 = 3405;
    public const NOKIA_ANN_CH2 = 3406;
    public const LDAP_ADMIN = 3407;
    public const BESAPI = 3408;
    public const NETWORKLENS = 3409;
    public const NETWORKLENSS = 3410;
    public const BIOLINK_AUTH = 3411;
    public const XMLBLASTER = 3412;
    public const SVNET = 3413;
    public const WIP_PORT = 3414;
    public const BCINAMESERVICE = 3415;
    public const COMMANDPORT = 3416;
    public const CSVR = 3417;
    public const RNMAP = 3418;
    public const SOFTAUDIT = 3419;
    public const IFCP_PORT = 3420;
    public const BMAP = 3421;
    public const RUSB_SYS_PORT = 3422;
    public const XTRM = 3423;
    public const XTRMS = 3424;
    public const AGPS_PORT = 3425;
    public const ARKIVIO = 3426;
    public const WEBSPHERE_SNMP = 3427;
    public const TWCSS = 3428;
    public const GCSP = 3429;
    public const SSDISPATCH = 3430;
    public const NDL_ALS = 3431;
    public const OSDCP = 3432;
    public const OPNET_SMP = 3433;
    public const OPENCM = 3434;
    public const PACOM = 3435;
    public const GC_CONFIG = 3436;
    public const AUTOCUEDS = 3437;
    public const SPIRAL_ADMIN = 3438;
    public const HRI_PORT = 3439;
    public const ANS_CONSOLE = 3440;
    public const CONNECT_CLIENT = 3441;
    public const CONNECT_SERVER = 3442;
    public const OV_NNM_WEBSRV = 3443;
    public const DENALI_SERVER = 3444;
    public const MONP = 3445;
    public const _3COMFAXRPC = 3446;
    public const DIRECTNET = 3447;
    public const DNC_PORT = 3448;
    public const HOTU_CHAT = 3449;
    public const CASTORPROXY = 3450;
    public const ASAM = 3451;
    public const SABP_SIGNAL = 3452;
    public const PSCUPD = 3453;
    public const MIRA = 3454;
    public const PRSVP = 3455;
    public const VAT = 3456;
    public const VAT_CONTROL = 3457;
    public const D3WINOSFI = 3458;
    public const INTEGRAL = 3459;
    public const EDM_MANAGER = 3460;
    public const EDM_STAGER = 3461;
    public const EDM_STD_NOTIFY = 3462;
    public const EDM_ADM_NOTIFY = 3463;
    public const EDM_MGR_SYNC = 3464;
    public const EDM_MGR_CNTRL = 3465;
    public const WORKFLOW = 3466;
    public const RCST = 3467;
    public const TTCMREMOTECTRL = 3468;
    public const PLURIBUS = 3469;
    public const JT400 = 3470;
    public const JT400_SSL = 3471;
    public const JAUGSREMOTEC_1 = 3472;
    public const JAUGSREMOTEC_2 = 3473;
    public const TTNTSPAUTO = 3474;
    public const GENISAR_PORT = 3475;
    public const NPPMP = 3476;
    public const ECOMM = 3477;
    public const STUN = 3478;
    public const TWRPC = 3479;
    public const PLETHORA = 3480;
    public const CLEANERLIVERC = 3481;
    public const VULTURE = 3482;
    public const SLIM_DEVICES = 3483;
    public const GBS_STP = 3484;
    public const CELATALK = 3485;
    public const IFSF_HB_PORT = 3486;
    public const LTCTCP = 3487;
    public const FS_RH_SRV = 3488;
    public const DTP_DIA = 3489;
    public const COLUBRIS = 3490;
    public const SWR_PORT = 3491;
    public const TVDUMTRAY_PORT = 3492;
    public const NUT = 3493;
    public const IBM3494 = 3494;
    public const SECLAYER_TCP = 3495;
    public const SECLAYER_TLS = 3496;
    public const IPETHER232PORT = 3497;
    public const DASHPAS_PORT = 3498;
    public const SCCIP_MEDIA = 3499;
    public const RTMP_PORT = 3500;
    public const ISOFT_P2P = 3501;
    public const AVINSTALLDISC = 3502;
    public const LSP_PING = 3503;
    public const IRONSTORM = 3504;
    public const CCMCOMM = 3505;
    public const APC_3506 = 3506;
    public const NESH_BROKER = 3507;
    public const INTERACTIONWEB = 3508;
    public const VT_SSL = 3509;
    public const XSS_PORT = 3510;
    public const WEBMAIL_2 = 3511;
    public const AZTEC = 3512;
    public const ARCPD = 3513;
    public const MUST_P2P = 3514;
    public const MUST_BACKPLANE = 3515;
    public const SMARTCARD_PORT = 3516;
    public const _802_11_IAPP = 3517;
    public const ARTIFACT_MSG = 3518;
    public const NVMSGD = 3519;
    public const GALILEOLOG = 3520;
    public const MC3SS = 3521;
    public const NSSOCKETPORT = 3522;
    public const ODEUMSERVLINK = 3523;
    public const ECMPORT = 3524;
    public const EISPORT = 3525;
    public const STARQUIZ_PORT = 3526;
    public const BESERVER_MSG_Q = 3527;
    public const JBOSS_IIOP = 3528;
    public const JBOSS_IIOP_SSL = 3529;
    public const GF = 3530;
    public const JOLTID = 3531;
    public const RAVEN_RMP = 3532;
    public const RAVEN_RDP = 3533;
    public const URLD_PORT = 3534;
    public const MS_LA = 3535;
    public const SNAC = 3536;
    public const NI_VISA_REMOTE = 3537;
    public const IBM_DIRADM = 3538;
    public const IBM_DIRADM_SSL = 3539;
    public const PNRP_PORT = 3540;
    public const VOISPEED_PORT = 3541;
    public const HACL_MONITOR = 3542;
    public const QFTEST_LOOKUP = 3543;
    public const TEREDO = 3544;
    public const CAMAC = 3545;
    public const SYMANTEC_SIM = 3547;
    public const INTERWORLD = 3548;
    public const TELLUMAT_NMS = 3549;
    public const SSMPP = 3550;
    public const APCUPSD = 3551;
    public const TASERVER = 3552;
    public const RBR_DISCOVERY = 3553;
    public const QUESTNOTIFY = 3554;
    public const RAZOR = 3555;
    public const SKY_TRANSPORT = 3556;
    public const PERSONALOS_001 = 3557;
    public const MCP_PORT = 3558;
    public const CCTV_PORT = 3559;
    public const INISERVE_PORT = 3560;
    public const BMC_ONEKEY = 3561;
    public const SDBPROXY = 3562;
    public const WATCOMDEBUG = 3563;
    public const ESIMPORT = 3564;
    public const M2PA = 3565;
    public const QUEST_DATA_HUB = 3566;
    public const DOF_EPS = 3567;
    public const DOF_TUNNEL_SEC = 3568;
    public const MBG_CTRL = 3569;
    public const MCCWEBSVR_PORT = 3570;
    public const MEGARDSVR_PORT = 3571;
    public const MEGAREGSVRPORT = 3572;
    public const TAG_UPS_1 = 3573;
    public const DMAF_SERVER = 3574;
    public const CCM_PORT = 3575;
    public const CMC_PORT = 3576;
    public const CONFIG_PORT = 3577;
    public const DATA_PORT = 3578;
    public const TTAT3LB = 3579;
    public const NATI_SVRLOC = 3580;
    public const KFXACLICENSING = 3581;
    public const PRESS = 3582;
    public const CANEX_WATCH = 3583;
    public const U_DBAP = 3584;
    public const EMPRISE_LLS = 3585;
    public const EMPRISE_LSC = 3586;
    public const P2PGROUP = 3587;
    public const SENTINEL = 3588;
    public const ISOMAIR = 3589;
    public const WV_CSP_SMS = 3590;
    public const GTRACK_SERVER = 3591;
    public const GTRACK_NE = 3592;
    public const BPMD = 3593;
    public const MEDIASPACE = 3594;
    public const SHAREAPP = 3595;
    public const IW_MMOGAME = 3596;
    public const A14 = 3597;
    public const A15 = 3598;
    public const QUASAR_SERVER = 3599;
    public const TRAP_DAEMON = 3600;
    public const VISINET_GUI = 3601;
    public const INFINISWITCHCL = 3602;
    public const INT_RCV_CNTRL = 3603;
    public const BMC_JMX_PORT = 3604;
    public const COMCAM_IO = 3605;
    public const SPLITLOCK = 3606;
    public const PRECISE_I3 = 3607;
    public const TRENDCHIP_DCP = 3608;
    public const CPDI_PIDAS_CM = 3609;
    public const ECHONET = 3610;
    public const SIX_DEGREES = 3611;
    public const HP_DATAPROTECT = 3612;
    public const ALARIS_DISC = 3613;
    public const SIGMA_PORT = 3614;
    public const START_NETWORK = 3615;
    public const CD3O_PROTOCOL = 3616;
    public const SHARP_SERVER = 3617;
    public const AAIRNET_1 = 3618;
    public const AAIRNET_2 = 3619;
    public const EP_PCP = 3620;
    public const EP_NSP = 3621;
    public const FF_LR_PORT = 3622;
    public const HAIPE_DISCOVER = 3623;
    public const DIST_UPGRADE = 3624;
    public const VOLLEY = 3625;
    public const BVCDAEMON_PORT = 3626;
    public const JAMSERVERPORT = 3627;
    public const EPT_MACHINE = 3628;
    public const ESCVPNET = 3629;
    public const CS_REMOTE_DB = 3630;
    public const CS_SERVICES = 3631;
    public const DISTCC = 3632;
    public const WACP = 3633;
    public const HLIBMGR = 3634;
    public const SDO = 3635;
    public const SERVISTAITSM = 3636;
    public const SCSERVP = 3637;
    public const EHP_BACKUP = 3638;
    public const XAP_HA = 3639;
    public const NETPLAY_PORT1 = 3640;
    public const NETPLAY_PORT2 = 3641;
    public const JUXML_PORT = 3642;
    public const AUDIOJUGGLER = 3643;
    public const SSOWATCH = 3644;
    public const CYC = 3645;
    public const XSS_SRV_PORT = 3646;
    public const SPLITLOCK_GW = 3647;
    public const FJCP = 3648;
    public const NMMP = 3649;
    public const PRISMIQ_PLUGIN = 3650;
    public const XRPC_REGISTRY = 3651;
    public const VXCRNBUPORT = 3652;
    public const TSP = 3653;
    public const VAPRTM = 3654;
    public const ABATEMGR = 3655;
    public const ABATJSS = 3656;
    public const IMMEDIANET_BCN = 3657;
    public const PS_AMS = 3658;
    public const APPLE_SASL = 3659;
    public const CAN_NDS_SSL = 3660;
    public const CAN_FERRET_SSL = 3661;
    public const PSERVER = 3662;
    public const DTP = 3663;
    public const UPS_ENGINE = 3664;
    public const ENT_ENGINE = 3665;
    public const ESERVER_PAP = 3666;
    public const INFOEXCH = 3667;
    public const DELL_RM_PORT = 3668;
    public const CASANSWMGMT = 3669;
    public const SMILE = 3670;
    public const EFCP = 3671;
    public const LISPWORKS_ORB = 3672;
    public const MEDIAVAULT_GUI = 3673;
    public const WININSTALL_IPC = 3674;
    public const CALLTRAX = 3675;
    public const VA_PACBASE = 3676;
    public const ROVERLOG = 3677;
    public const IPR_DGLT = 3678;
    public const ESCALE = 3679;
    public const NPDS_TRACKER = 3680;
    public const BTS_X73 = 3681;
    public const CAS_MAPI = 3682;
    public const BMC_EA = 3683;
    public const FAXSTFX_PORT = 3684;
    public const DSX_AGENT = 3685;
    public const TNMPV2 = 3686;
    public const SIMPLE_PUSH = 3687;
    public const SIMPLE_PUSH_S = 3688;
    public const DAAP = 3689;
    public const SVN = 3690;
    public const MAGAYA_NETWORK = 3691;
    public const INTELSYNC = 3692;
    public const EASL = 3693;
    public const BMC_DATA_COLL = 3695;
    public const TELNETCPCD = 3696;
    public const NW_LICENSE = 3697;
    public const SAGECTLPANEL = 3698;
    public const KPN_ICW = 3699;
    public const LRS_PAGING = 3700;
    public const NETCELERA = 3701;
    public const WS_DISCOVERY = 3702;
    public const ADOBESERVER_3 = 3703;
    public const ADOBESERVER_4 = 3704;
    public const ADOBESERVER_5 = 3705;
    public const RT_EVENT = 3706;
    public const RT_EVENT_S = 3707;
    public const SUN_AS_IIOPS = 3708;
    public const CA_IDMS = 3709;
    public const PORTGATE_AUTH = 3710;
    public const EDB_SERVER2 = 3711;
    public const SENTINEL_ENT = 3712;
    public const TFTPS = 3713;
    public const DELOS_DMS = 3714;
    public const ANOTO_RENDEZV = 3715;
    public const WV_CSP_SMS_CIR = 3716;
    public const WV_CSP_UDP_CIR = 3717;
    public const OPUS_SERVICES = 3718;
    public const ITELSERVERPORT = 3719;
    public const UFASTRO_INSTR = 3720;
    public const XSYNC = 3721;
    public const XSERVERAID = 3722;
    public const SYCHROND = 3723;
    public const BLIZWOW = 3724;
    public const NA_ER_TIP = 3725;
    public const ARRAY_MANAGER = 3726;
    public const E_MDU = 3727;
    public const E_WOA = 3728;
    public const FKSP_AUDIT = 3729;
    public const CLIENT_CTRL = 3730;
    public const SMAP = 3731;
    public const M_WNN = 3732;
    public const MULTIP_MSG = 3733;
    public const SYNEL_DATA = 3734;
    public const PWDIS = 3735;
    public const RS_RMI = 3736;
    public const XPANEL = 3737;
    public const VERSATALK = 3738;
    public const LAUNCHBIRD_LM = 3739;
    public const HEARTBEAT = 3740;
    public const WYSDMA = 3741;
    public const CST_PORT = 3742;
    public const IPCS_COMMAND = 3743;
    public const SASG = 3744;
    public const GW_CALL_PORT = 3745;
    public const LINKTEST = 3746;
    public const LINKTEST_S = 3747;
    public const WEBDATA = 3748;
    public const CIMTRAK = 3749;
    public const CBOS_IP_PORT = 3750;
    public const GPRS_CUBE = 3751;
    public const VIPREMOTEAGENT = 3752;
    public const NATTYSERVER = 3753;
    public const TIMESTENBROKER = 3754;
    public const SAS_REMOTE_HLP = 3755;
    public const CANON_CAPT = 3756;
    public const GRF_PORT = 3757;
    public const APW_REGISTRY = 3758;
    public const EXAPT_LMGR = 3759;
    public const ADTEMPUSCLIENT = 3760;
    public const GSAKMP = 3761;
    public const GBS_SMP = 3762;
    public const XO_WAVE = 3763;
    public const MNI_PROT_ROUT = 3764;
    public const RTRACEROUTE = 3765;
    public const SITEWATCH_S = 3766;
    public const LISTMGR_PORT = 3767;
    public const RBLCHECKD = 3768;
    public const HAIPE_OTNK = 3769;
    public const CINDYCOLLAB = 3770;
    public const PAGING_PORT = 3771;
    public const CTP = 3772;
    public const CTDHERCULES = 3773;
    public const ZICOM = 3774;
    public const ISPMMGR = 3775;
    public const DVCPROV_PORT = 3776;
    public const JIBE_EB = 3777;
    public const C_H_IT_PORT = 3778;
    public const COGNIMA = 3779;
    public const NNP = 3780;
    public const ABCVOICE_PORT = 3781;
    public const ISO_TP0S = 3782;
    public const BIM_PEM = 3783;
    public const BFD_CONTROL = 3784;
    public const BFD_ECHO = 3785;
    public const UPSTRIGGERVSW = 3786;
    public const FINTRX = 3787;
    public const ISRP_PORT = 3788;
    public const REMOTEDEPLOY = 3789;
    public const QUICKBOOKSRDS = 3790;
    public const TVNETWORKVIDEO = 3791;
    public const SITEWATCH = 3792;
    public const DCSOFTWARE = 3793;
    public const JAUS = 3794;
    public const MYBLAST = 3795;
    public const SPW_DIALER = 3796;
    public const IDPS = 3797;
    public const MINILOCK = 3798;
    public const RADIUS_DYNAUTH = 3799;
    public const PWGPSI = 3800;
    public const IBM_MGR = 3801;
    public const VHD = 3802;
    public const SONIQSYNC = 3803;
    public const IQNET_PORT = 3804;
    public const TCPDATASERVER = 3805;
    public const WSMLB = 3806;
    public const SPUGNA = 3807;
    public const SUN_AS_IIOPS_CA = 3808;
    public const APOCD = 3809;
    public const WLANAUTH = 3810;
    public const AMP = 3811;
    public const NETO_WOL_SERVER = 3812;
    public const RAP_IP = 3813;
    public const NETO_DCS = 3814;
    public const LANSURVEYORXML = 3815;
    public const SUNLPS_HTTP = 3816;
    public const TAPEWARE = 3817;
    public const CRINIS_HB = 3818;
    public const EPL_SLP = 3819;
    public const SCP = 3820;
    public const PMCP = 3821;
    public const ACP_DISCOVERY = 3822;
    public const ACP_CONDUIT = 3823;
    public const ACP_POLICY = 3824;
    public const FFSERVER = 3825;
    public const WARMUX = 3826;
    public const NETMPI = 3827;
    public const NETEH = 3828;
    public const NETEH_EXT = 3829;
    public const CERNSYSMGMTAGT = 3830;
    public const DVAPPS = 3831;
    public const XXNETSERVER = 3832;
    public const AIPN_AUTH = 3833;
    public const SPECTARDATA = 3834;
    public const SPECTARDB = 3835;
    public const MARKEM_DCP = 3836;
    public const MKM_DISCOVERY = 3837;
    public const SOS = 3838;
    public const AMX_RMS = 3839;
    public const FLIRTMITMIR = 3840;
    public const SHIPRUSH_DB_SVR = 3841;
    public const NHCI = 3842;
    public const QUEST_AGENT = 3843;
    public const RNM = 3844;
    public const V_ONE_SPP = 3845;
    public const AN_PCP = 3846;
    public const MSFW_CONTROL = 3847;
    public const ITEM = 3848;
    public const SPW_DNSPRELOAD = 3849;
    public const QTMS_BOOTSTRAP = 3850;
    public const SPECTRAPORT = 3851;
    public const SSE_APP_CONFIG = 3852;
    public const SSCAN = 3853;
    public const STRYKER_COM = 3854;
    public const OPENTRAC = 3855;
    public const INFORMER = 3856;
    public const TRAP_PORT = 3857;
    public const TRAP_PORT_MOM = 3858;
    public const NAV_PORT = 3859;
    public const SASP = 3860;
    public const WINSHADOW_HD = 3861;
    public const GIGA_POCKET = 3862;
    public const ASAP_TCP = 3863;
    public const ASAP_TCP_TLS = 3864;
    public const XPL = 3865;
    public const DZDAEMON = 3866;
    public const DZOGLSERVER = 3867;
    public const DIAMETER = 3868;
    public const OVSAM_MGMT = 3869;
    public const OVSAM_D_AGENT = 3870;
    public const AVOCENT_ADSAP = 3871;
    public const OEM_AGENT = 3872;
    public const FAGORDNC = 3873;
    public const SIXXSCONFIG = 3874;
    public const PNBSCADA = 3875;
    public const DL_AGENT = 3876;
    public const XMPCR_INTERFACE = 3877;
    public const FOTOGCAD = 3878;
    public const APPSS_LM = 3879;
    public const IGRS = 3880;
    public const IDAC = 3881;
    public const MSDTS1 = 3882;
    public const VRPN = 3883;
    public const SOFTRACK_METER = 3884;
    public const TOPFLOW_SSL = 3885;
    public const NEI_MANAGEMENT = 3886;
    public const CIPHIRE_DATA = 3887;
    public const CIPHIRE_SERV = 3888;
    public const DANDV_TESTER = 3889;
    public const NDSCONNECT = 3890;
    public const RTC_PM_PORT = 3891;
    public const PCC_IMAGE_PORT = 3892;
    public const CGI_STARAPI = 3893;
    public const SYAM_AGENT = 3894;
    public const SYAM_SMC = 3895;
    public const SDO_TLS = 3896;
    public const SDO_SSH = 3897;
    public const SENIP = 3898;
    public const ITV_CONTROL = 3899;
    public const UDT_OS_2 = 3900;
    public const NIMSH = 3901;
    public const NIMAUX = 3902;
    public const CHARSETMGR = 3903;
    public const OMNILINK_PORT = 3904;
    public const MUPDATE = 3905;
    public const TOPOVISTA_DATA = 3906;
    public const IMOGUIA_PORT = 3907;
    public const HPPRONETMAN = 3908;
    public const SURFCONTROLCPA = 3909;
    public const PRNREQUEST = 3910;
    public const PRNSTATUS = 3911;
    public const GBMT_STARS = 3912;
    public const LISTCRT_PORT = 3913;
    public const LISTCRT_PORT_2 = 3914;
    public const AGCAT = 3915;
    public const WYSDMC = 3916;
    public const AFTMUX = 3917;
    public const PKTCABLEMMCOPS = 3918;
    public const HYPERIP = 3919;
    public const EXASOFTPORT1 = 3920;
    public const HERODOTUS_NET = 3921;
    public const SOR_UPDATE = 3922;
    public const SYMB_SB_PORT = 3923;
    public const MPL_GPRS_PORT = 3924;
    public const ZMP = 3925;
    public const WINPORT = 3926;
    public const NATDATASERVICE = 3927;
    public const NETBOOT_PXE = 3928;
    public const SMAUTH_PORT = 3929;
    public const SYAM_WEBSERVER = 3930;
    public const MSR_PLUGIN_PORT = 3931;
    public const DYN_SITE = 3932;
    public const PLBSERVE_PORT = 3933;
    public const SUNFM_PORT = 3934;
    public const SDP_PORTMAPPER = 3935;
    public const MAILPROX = 3936;
    public const DVBSERVDSC = 3937;
    public const DBCONTROL_AGENT = 3938;
    public const AAMP = 3939;
    public const XECP_NODE = 3940;
    public const HOMEPORTAL_WEB = 3941;
    public const SRDP = 3942;
    public const TIG = 3943;
    public const SOPS = 3944;
    public const EMCADS = 3945;
    public const BACKUPEDGE = 3946;
    public const CCP = 3947;
    public const APDAP = 3948;
    public const DRIP = 3949;
    public const NAMEMUNGE = 3950;
    public const PWGIPPFAX = 3951;
    public const I3_SESSIONMGR = 3952;
    public const XMLINK_CONNECT = 3953;
    public const ADREP = 3954;
    public const P2PCOMMUNITY = 3955;
    public const GVCP = 3956;
    public const MQE_BROKER = 3957;
    public const MQE_AGENT = 3958;
    public const TREEHOPPER = 3959;
    public const BESS = 3960;
    public const PROAXESS = 3961;
    public const SBI_AGENT = 3962;
    public const THRP = 3963;
    public const SASGGPRS = 3964;
    public const ATI_IP_TO_NCPE = 3965;
    public const BFLCKMGR = 3966;
    public const PPSMS = 3967;
    public const IANYWHERE_DBNS = 3968;
    public const LANDMARKS = 3969;
    public const LANREVAGENT = 3970;
    public const LANREVSERVER = 3971;
    public const ICONP = 3972;
    public const PROGISTICS = 3973;
    public const CITYSEARCH = 3974;
    public const AIRSHOT = 3975;
    public const OPSWAGENT = 3976;
    public const OPSWMANAGER = 3977;
    public const SECURE_CFG_SVR = 3978;
    public const SMWAN = 3979;
    public const ACMS = 3980;
    public const STARFISH = 3981;
    public const EIS = 3982;
    public const EISP = 3983;
    public const MAPPER_NODEMGR = 3984;
    public const MAPPER_MAPETHD = 3985;
    public const MAPPER_WS_ETHD = 3986;
    public const CENTERLINE = 3987;
    public const DCS_CONFIG = 3988;
    public const BV_QUERYENGINE = 3989;
    public const BV_IS = 3990;
    public const BV_SMCSRV = 3991;
    public const BV_DS = 3992;
    public const BV_AGENT = 3993;
    public const ISS_MGMT_SSL = 3995;
    public const ABCSOFTWARE = 3996;
    public const AGENTSEASE_DB = 3997;
    public const DNX = 3998;
    public const NVCNET = 3999;
    public const TERABASE = 4000;
    public const NEWOAK = 4001;
    public const PXC_SPVR_FT = 4002;
    public const PXC_SPLR_FT = 4003;
    public const PXC_ROID = 4004;
    public const PXC_PIN = 4005;
    public const PXC_SPVR = 4006;
    public const PXC_SPLR = 4007;
    public const NETCHEQUE = 4008;
    public const CHIMERA_HWM = 4009;
    public const SAMSUNG_UNIDEX = 4010;
    public const ALTSERVICEBOOT = 4011;
    public const PDA_GATE = 4012;
    public const ACL_MANAGER = 4013;
    public const TAICLOCK = 4014;
    public const TALARIAN_MCAST1 = 4015;
    public const TALARIAN_MCAST2 = 4016;
    public const TALARIAN_MCAST3 = 4017;
    public const TALARIAN_MCAST4 = 4018;
    public const TALARIAN_MCAST5 = 4019;
    public const TRAP = 4020;
    public const NEXUS_PORTAL = 4021;
    public const DNOX = 4022;
    public const ESNM_ZONING = 4023;
    public const TNP1_PORT = 4024;
    public const PARTIMAGE = 4025;
    public const AS_DEBUG = 4026;
    public const BXP = 4027;
    public const DTSERVER_PORT = 4028;
    public const IP_QSIG = 4029;
    public const JDMN_PORT = 4030;
    public const SUUCP = 4031;
    public const VRTS_AUTH_PORT = 4032;
    public const SANAVIGATOR = 4033;
    public const UBXD = 4034;
    public const WAP_PUSH_HTTP = 4035;
    public const WAP_PUSH_HTTPS = 4036;
    public const RAVEHD = 4037;
    public const FAZZT_PTP = 4038;
    public const FAZZT_ADMIN = 4039;
    public const YO_MAIN = 4040;
    public const HOUSTON = 4041;
    public const LDXP = 4042;
    public const NIRP = 4043;
    public const LTP = 4044;
    public const NPP_2 = 4045;
    public const ACP_PROTO = 4046;
    public const CTP_STATE = 4047;
    public const WAFS = 4049;
    public const CISCO_WAFS = 4050;
    public const CPPDP = 4051;
    public const INTERACT = 4052;
    public const CCU_COMM_1 = 4053;
    public const CCU_COMM_2 = 4054;
    public const CCU_COMM_3 = 4055;
    public const LMS = 4056;
    public const WFM = 4057;
    public const KINGFISHER = 4058;
    public const DLMS_COSEM = 4059;
    public const DSMETER_IATC = 4060;
    public const ICE_LOCATION = 4061;
    public const ICE_SLOCATION = 4062;
    public const ICE_ROUTER = 4063;
    public const ICE_SROUTER = 4064;
    public const AVANTI_CDP = 4065;
    public const PMAS = 4066;
    public const IDP = 4067;
    public const IPFLTBCST = 4068;
    public const MINGER = 4069;
    public const TRIPE = 4070;
    public const AIBKUP = 4071;
    public const ZIETO_SOCK = 4072;
    public const IRAPP = 4073;
    public const CEQUINT_CITYID = 4074;
    public const PERIMLAN = 4075;
    public const SERAPH = 4076;
    public const CSSP = 4078;
    public const SANTOOLS = 4079;
    public const LORICA_IN = 4080;
    public const LORICA_IN_SEC = 4081;
    public const LORICA_OUT = 4082;
    public const LORICA_OUT_SEC = 4083;
    public const EZMESSAGESRV = 4085;
    public const APPLUSSERVICE = 4087;
    public const NPSP = 4088;
    public const OPENCORE = 4089;
    public const OMASGPORT = 4090;
    public const EWINSTALLER = 4091;
    public const EWDGS = 4092;
    public const PVXPLUSCS = 4093;
    public const SYSRQD = 4094;
    public const XTGUI = 4095;
    public const BRE = 4096;
    public const PATROLVIEW = 4097;
    public const DRMSFSD = 4098;
    public const DPCP = 4099;
    public const IGO_INCOGNITO = 4100;
    public const BRLP_0 = 4101;
    public const BRLP_1 = 4102;
    public const BRLP_2 = 4103;
    public const BRLP_3 = 4104;
    public const SHOFAR = 4105;
    public const SYNCHRONITE = 4106;
    public const J_AC = 4107;
    public const ACCEL = 4108;
    public const IZM = 4109;
    public const G2TAG = 4110;
    public const XGRID = 4111;
    public const APPLE_VPNS_RP = 4112;
    public const AIPN_REG = 4113;
    public const JOMAMQMONITOR = 4114;
    public const CDS = 4115;
    public const SMARTCARD_TLS = 4116;
    public const HILLRSERV = 4117;
    public const NETSCRIPT = 4118;
    public const ASSURIA_SLM = 4119;
    public const MINIREM = 4120;
    public const E_BUILDER = 4121;
    public const FPRAMS = 4122;
    public const Z_WAVE = 4123;
    public const TIGV2 = 4124;
    public const OPSVIEW_ENVOY = 4125;
    public const DDREPL = 4126;
    public const UNIKEYPRO = 4127;
    public const NUFW = 4128;
    public const NUAUTH = 4129;
    public const FRONET = 4130;
    public const STARS = 4131;
    public const NUTS_DEM = 4132;
    public const NUTS_BOOTP = 4133;
    public const NIFTY_HMI = 4134;
    public const CL_DB_ATTACH = 4135;
    public const CL_DB_REQUEST = 4136;
    public const CL_DB_REMOTE = 4137;
    public const NETTEST = 4138;
    public const THRTX = 4139;
    public const CEDROS_FDS = 4140;
    public const OIRTGSVC = 4141;
    public const OIDOCSVC = 4142;
    public const OIDSR = 4143;
    public const VVR_CONTROL = 4145;
    public const TGCCONNECT = 4146;
    public const VRXPSERVMAN = 4147;
    public const HHB_HANDHELD = 4148;
    public const AGSLB = 4149;
    public const POWERALERT_NSA = 4150;
    public const MENANDMICE_NOH = 4151;
    public const IDIG_MUX = 4152;
    public const MBL_BATTD = 4153;
    public const ATLINKS = 4154;
    public const BZR = 4155;
    public const STAT_RESULTS = 4156;
    public const STAT_SCANNER = 4157;
    public const STAT_CC = 4158;
    public const NSS = 4159;
    public const JINI_DISCOVERY = 4160;
    public const OMSCONTACT = 4161;
    public const OMSTOPOLOGY = 4162;
    public const SILVERPEAKPEER = 4163;
    public const SILVERPEAKCOMM = 4164;
    public const ALTCP = 4165;
    public const JOOST = 4166;
    public const DDGN = 4167;
    public const PSLICSER = 4168;
    public const IADT = 4169;
    public const D_CINEMA_CSP = 4170;
    public const ML_SVNET = 4171;
    public const PCOIP = 4172;
    public const SMCLUSTER = 4174;
    public const BCCP = 4175;
    public const TL_IPCPROXY = 4176;
    public const WELLO = 4177;
    public const STORMAN = 4178;
    public const MAXUMSP = 4179;
    public const HTTPX = 4180;
    public const MACBAK = 4181;
    public const PCPTCPSERVICE = 4182;
    public const CYBORGNET = 4183;
    public const UNIVERSE_SUITE = 4184;
    public const WCPP = 4185;
    public const BOXBACKUPSTORE = 4186;
    public const CSC_PROXY = 4187;
    public const VATATA = 4188;
    public const PCEP = 4189;
    public const SIEVE = 4190;
    public const AZETI = 4192;
    public const PVXPLUSIO = 4193;
    public const HCTL = 4197;
    public const EIMS_ADMIN = 4199;
    public const VRML_MULTI_USE = 4200; // 4200-4299
    public const CORELCCAM = 4300;
    public const D_DATA = 4301;
    public const D_DATA_CONTROL = 4302;
    public const SRCP = 4303;
    public const OWSERVER = 4304;
    public const BATMAN = 4305;
    public const PINGHGL = 4306;
    public const TRUECONF = 4307;
    public const COMPX_LOCKVIEW = 4308;
    public const DSERVER = 4309;
    public const MIRRTEX = 4310;
    public const P6SSMC = 4311;
    public const PSCL_MGT = 4312;
    public const PERRLA = 4313;
    public const CHOICEVIEW_AGT = 4314;
    public const CHOICEVIEW_CLT = 4316;
    public const FDT_RCATP = 4320;
    public const RWHOIS = 4321;
    public const TRIM_EVENT = 4322;
    public const TRIM_ICE = 4323;
    public const GEOGNOSISMAN = 4325;
    public const GEOGNOSIS = 4326;
    public const JAXER_WEB = 4327;
    public const JAXER_MANAGER = 4328;
    public const PUBLIQARE_SYNC = 4329;
    public const DEY_SAPI = 4330;
    public const KTICKETS_REST = 4331;
    public const AHSP = 4333;
    public const NETCONF_CH_SSH = 4334;
    public const NETCONF_CH_TLS = 4335;
    public const RESTCONF_CH_TLS = 4336;
    public const GAIA = 4340;
    public const LISP_DATA = 4341;
    public const LISP_CONS = 4342;
    public const UNICALL = 4343;
    public const VINAINSTALL = 4344;
    public const M4_NETWORK_AS = 4345;
    public const ELANLM = 4346;
    public const LANSURVEYOR = 4347;
    public const ITOSE = 4348;
    public const FSPORTMAP = 4349;
    public const NET_DEVICE = 4350;
    public const PLCY_NET_SVCS = 4351;
    public const PJLINK = 4352;
    public const F5_IQUERY = 4353;
    public const QSNET_TRANS = 4354;
    public const QSNET_WORKST = 4355;
    public const QSNET_ASSIST = 4356;
    public const QSNET_COND = 4357;
    public const QSNET_NUCL = 4358;
    public const OMABCASTLTKM = 4359;
    public const MATRIX_VNET = 4360;
    public const WXBRIEF = 4368;
    public const EPMD = 4369;
    public const ELPRO_TUNNEL = 4370;
    public const L2C_CONTROL = 4371;
    public const L2C_DATA = 4372;
    public const REMCTL = 4373;
    public const PSI_PTT = 4374;
    public const TOLTECES = 4375;
    public const BIP = 4376;
    public const CP_SPXSVR = 4377;
    public const CP_SPXDPY = 4378;
    public const CTDB = 4379;
    public const XANDROS_CMS = 4389;
    public const WIEGAND = 4390;
    public const APWI_IMSERVER = 4391;
    public const APWI_RXSERVER = 4392;
    public const APWI_RXSPOOLER = 4393;
    public const OMNIVISIONESX = 4395;
    public const FLY = 4396;
    public const DS_SRV = 4400;
    public const DS_SRVR = 4401;
    public const DS_CLNT = 4402;
    public const DS_USER = 4403;
    public const DS_ADMIN = 4404;
    public const DS_MAIL = 4405;
    public const DS_SLP = 4406;
    public const NACAGENT = 4407;
    public const SLSCC = 4408;
    public const NETCABINET_COM = 4409;
    public const ITWO_SERVER = 4410;
    public const FOUND = 4411;
    public const AVI_NMS = 4413;
    public const UPDOG = 4414;
    public const BRCD_VR_REQ = 4415;
    public const PJJ_PLAYER = 4416;
    public const WORKFLOWDIR = 4417;
    public const CBP = 4419;
    public const NVM_EXPRESS = 4420;
    public const SCALEFT = 4421;
    public const TSEPISP = 4422;
    public const THINGKIT = 4423;
    public const NETROCKEY6 = 4425;
    public const BEACON_PORT_2 = 4426;
    public const DRIZZLE = 4427;
    public const OMVISERVER = 4428;
    public const OMVIAGENT = 4429;
    public const RSQLSERVER = 4430;
    public const WSPIPE = 4431;
    public const L_ACOUSTICS = 4432;
    public const VOP = 4433;
    public const SARIS = 4442;
    public const PHAROS = 4443;
    public const KRB524 = 4444;
    public const UPNOTIFYP = 4445;
    public const N1_FWP = 4446;
    public const N1_RMGMT = 4447;
    public const ASC_SLMD = 4448;
    public const PRIVATEWIRE = 4449;
    public const CAMP = 4450;
    public const CTISYSTEMMSG = 4451;
    public const CTIPROGRAMLOAD = 4452;
    public const NSSALERTMGR = 4453;
    public const NSSAGENTMGR = 4454;
    public const PRCHAT_USER = 4455;
    public const PRCHAT_SERVER = 4456;
    public const PRREGISTER = 4457;
    public const MCP = 4458;
    public const HPSSMGMT = 4484;
    public const ASSYST_DR = 4485;
    public const ICMS = 4486;
    public const PREX_TCP = 4487;
    public const AWACS_ICE = 4488;
    public const IPSEC_NAT_T = 4500;
    public const EHS = 4535;
    public const EHS_SSL = 4536;
    public const WSSAUTHSVC = 4537;
    public const SWX_GATE = 4538;
    public const WORLDSCORES = 4545;
    public const SF_LM = 4546;
    public const LANNER_LM = 4547;
    public const SYNCHROMESH = 4548;
    public const AEGATE = 4549;
    public const GDS_ADPPIW_DB = 4550;
    public const IEEE_MIH = 4551;
    public const MENANDMICE_MON = 4552;
    public const ICSHOSTSVC = 4553;
    public const MSFRS = 4554;
    public const RSIP = 4555;
    public const DTN_BUNDLE = 4556;
    public const HYLAFAX = 4559;
    public const AMAHI_ANYWHERE = 4563;
    public const KWTC = 4566;
    public const TRAM = 4567;
    public const BMC_REPORTING = 4568;
    public const IAX = 4569;
    public const DEPLOYMENTMAP = 4570;
    public const CARDIFFTEC_BACK = 4573;
    public const RID = 4590;
    public const L3T_AT_AN = 4591;
    public const IPT_ANRI_ANRI = 4593;
    public const IAS_SESSION = 4594;
    public const IAS_PAGING = 4595;
    public const IAS_NEIGHBOR = 4596;
    public const A21_AN_1XBS = 4597;
    public const A16_AN_AN = 4598;
    public const A17_AN_AN = 4599;
    public const PIRANHA1 = 4600;
    public const PIRANHA2 = 4601;
    public const MTSSERVER = 4602;
    public const MENANDMICE_UPG = 4603;
    public const IRP = 4604;
    public const SIXCHAT = 4605;
    public const PLAYSTA2_APP = 4658;
    public const PLAYSTA2_LOB = 4659;
    public const SMACLMGR = 4660;
    public const KAR2OUCHE = 4661;
    public const OMS = 4662;
    public const NOTEIT = 4663;
    public const EMS = 4664;
    public const CONTCLIENTMS = 4665;
    public const EPORTCOMM = 4666;
    public const MMACOMM = 4667;
    public const MMAEDS = 4668;
    public const EPORTCOMMDATA = 4669;
    public const LIGHT = 4670;
    public const ACTER = 4671;
    public const RFA = 4672;
    public const CXWS = 4673;
    public const APPIQ_MGMT = 4674;
    public const DHCT_STATUS = 4675;
    public const DHCT_ALERTS = 4676;
    public const BCS = 4677;
    public const TRAVERSAL = 4678;
    public const MGESUPERVISION = 4679;
    public const MGEMANAGEMENT = 4680;
    public const PARLIANT = 4681;
    public const FINISAR = 4682;
    public const SPIKE = 4683;
    public const RFID_RP1 = 4684;
    public const AUTOPAC = 4685;
    public const MSP_OS = 4686;
    public const NST = 4687;
    public const MOBILE_P2P = 4688;
    public const ALTOVACENTRAL = 4689;
    public const PRELUDE = 4690;
    public const MTN = 4691;
    public const CONSPIRACY = 4692;
    public const NETXMS_AGENT = 4700;
    public const NETXMS_MGMT = 4701;
    public const NETXMS_SYNC = 4702;
    public const NPQES_TEST = 4703;
    public const ASSURIA_INS = 4704;
    public const TRINITY_DIST = 4711;
    public const TRUCKSTAR = 4725;
    public const FCIS = 4727;
    public const CAPMUX = 4728;
    public const GEARMAN = 4730;
    public const REMCAP = 4731;
    public const RESORCS = 4733;
    public const IPDR_SP = 4737;
    public const SOLERA_LPN = 4738;
    public const IPFIX = 4739;
    public const IPFIXS = 4740;
    public const LUMIMGRD = 4741;
    public const SICCT = 4742;
    public const OPENHPID = 4743;
    public const IFSP = 4744;
    public const FMP = 4745;
    public const PROFILEMAC = 4749;
    public const SSAD = 4750;
    public const SPOCP = 4751;
    public const SNAP = 4752;
    public const SIMON = 4753;
    public const RDCENTER = 4756;
    public const CONVERGE = 4774;
    public const BFD_MULTI_CTL = 4784;
    public const SMART_INSTALL = 4786;
    public const SIA_CTRL_PLANE = 4787;
    public const XMCP = 4788;
    public const IIMS = 4800;
    public const IWEC = 4801;
    public const ILSS = 4802;
    public const NOTATEIT = 4803;
    public const HTCP = 4827;
    public const VARADERO_0 = 4837;
    public const VARADERO_1 = 4838;
    public const VARADERO_2 = 4839;
    public const OPCUA_TCP = 4840;
    public const QUOSA = 4841;
    public const GW_ASV = 4842;
    public const OPCUA_TLS = 4843;
    public const GW_LOG = 4844;
    public const WCR_REMLIB = 4845;
    public const CONTAMAC_ICM = 4846;
    public const WFC = 4847;
    public const APPSERV_HTTP = 4848;
    public const APPSERV_HTTPS = 4849;
    public const SUN_AS_NODEAGT = 4850;
    public const DERBY_REPLI = 4851;
    public const UNIFY_DEBUG = 4867;
    public const PHRELAY = 4868;
    public const PHRELAYDBG = 4869;
    public const CC_TRACKING = 4870;
    public const WIRED = 4871;
    public const TRITIUM_CAN = 4876;
    public const LMCS = 4877;
    public const WSDL_EVENT = 4879;
    public const HISLIP = 4880;
    public const WMLSERVER = 4883;
    public const HIVESTOR = 4884;
    public const ABBS = 4885;
    public const LYSKOM = 4894;
    public const RADMIN_PORT = 4899;
    public const HFCS = 4900;
    public const FLR_AGENT = 4901;
    public const MAGICCONTROL = 4902;
    public const LUTAP = 4912;
    public const LUTCP = 4913;
    public const BONES = 4914;
    public const FRCS = 4915;
    public const EQ_OFFICE_4940 = 4940;
    public const EQ_OFFICE_4941 = 4941;
    public const EQ_OFFICE_4942 = 4942;
    public const MUNIN = 4949;
    public const SYBASESRVMON = 4950;
    public const PWGWIMS = 4951;
    public const SAGXTSDS = 4952;
    public const DBSYNCARBITER = 4953;
    public const CCSS_QMM = 4969;
    public const CCSS_QSM = 4970;
    public const BURP = 4971;
    public const WEBYAST = 4984;
    public const GERHCS = 4985;
    public const MRIP = 4986;
    public const SMAR_SE_PORT1 = 4987;
    public const SMAR_SE_PORT2 = 4988;
    public const PARALLEL = 4989;
    public const BUSYCAL = 4990;
    public const VRT = 4991;
    public const HFCS_MANAGER = 4999;
    public const COMMPLEX_MAIN = 5000;
    public const COMMPLEX_LINK = 5001;
    public const RFE = 5002;
    public const FMPRO_INTERNAL = 5003;
    public const AVT_PROFILE_1 = 5004;
    public const AVT_PROFILE_2 = 5005;
    public const WSM_SERVER = 5006;
    public const WSM_SERVER_SSL = 5007;
    public const SYNAPSIS_EDGE = 5008;
    public const WINFS = 5009;
    public const TELELPATHSTART = 5010;
    public const TELELPATHATTACK = 5011;
    public const NSP = 5012;
    public const FMPRO_V6 = 5013;
    public const FMWP = 5015;
    public const ZENGINKYO_1 = 5020;
    public const ZENGINKYO_2 = 5021;
    public const MICE = 5022;
    public const HTUILSRV = 5023;
    public const SCPI_TELNET = 5024;
    public const SCPI_RAW = 5025;
    public const STREXEC_D = 5026;
    public const STREXEC_S = 5027;
    public const QVR = 5028;
    public const INFOBRIGHT = 5029;
    public const SURFPASS = 5030;
    public const SIGNACERT_AGENT = 5032;
    public const JTNETD_SERVER = 5033;
    public const JTNETD_STATUS = 5034;
    public const ASNAACCELER8DB = 5042;
    public const SWXADMIN = 5043;
    public const LXI_EVNTSVC = 5044;
    public const OSP = 5045;
    public const TEXAI = 5048;
    public const IVOCALIZE = 5049;
    public const MMCC = 5050;
    public const ITA_AGENT = 5051;
    public const ITA_MANAGER = 5052;
    public const RLM = 5053;
    public const RLM_ADMIN = 5054;
    public const UNOT = 5055;
    public const INTECOM_PS1 = 5056;
    public const INTECOM_PS2 = 5057;
    public const SDS = 5059;
    public const SIP = 5060;
    public const SIPS = 5061;
    public const NA_LOCALISE = 5062;
    public const CSRPC = 5063;
    public const CA_1 = 5064;
    public const CA_2 = 5065;
    public const STANAG_5066 = 5066;
    public const AUTHENTX = 5067;
    public const BITFORESTSRV = 5068;
    public const I_NET_2000_NPR = 5069;
    public const VTSAS = 5070;
    public const POWERSCHOOL = 5071;
    public const AYIYA = 5072;
    public const TAG_PM = 5073;
    public const ALESQUERY = 5074;
    public const PVACCESS = 5075;
    public const ONSCREEN = 5080;
    public const SDL_ETS = 5081;
    public const QCP = 5082;
    public const QFP = 5083;
    public const LLRP = 5084;
    public const ENCRYPTED_LLRP = 5085;
    public const APRIGO_CS = 5086;
    public const BIOTIC = 5087;
    public const SENTINEL_LM = 5093;
    public const HART_IP = 5094;
    public const SENTLM_SRV2SRV = 5099;
    public const SOCALIA = 5100;
    public const TALARIAN_TCP = 5101;
    public const OMS_NONSECURE = 5102;
    public const ACTIFIO_C2C = 5103;
    public const ACTIFIOUDSAGENT = 5106;
    public const ACTIFIOREPLIC = 5107;
    public const TAEP_AS_SVC = 5111;
    public const PM_CMDSVR = 5112;
    public const EV_SERVICES = 5114;
    public const AUTOBUILD = 5115;
    public const GRADECAM = 5117;
    public const BARRACUDA_BBS = 5120;
    public const NBT_PC = 5133;
    public const PPACTIVATION = 5134;
    public const ERP_SCALE = 5135;
    public const CTSD = 5137;
    public const RMONITOR_SECURE = 5145;
    public const SOCIAL_ALARM = 5146;
    public const ATMP = 5150;
    public const ESRI_SDE = 5151;
    public const SDE_DISCOVERY = 5152;
    public const TORUXSERVER = 5153;
    public const BZFLAG = 5154;
    public const ASCTRL_AGENT = 5155;
    public const RUGAMEONLINE = 5156;
    public const MEDIAT = 5157;
    public const SNMPSSH = 5161;
    public const SNMPSSH_TRAP = 5162;
    public const SBACKUP = 5163;
    public const VPA = 5164;
    public const IFE_ICORP = 5165;
    public const WINPCS = 5166;
    public const SCTE104 = 5167;
    public const SCTE30 = 5168;
    public const PCOIP_MGMT = 5172;
    public const AOL = 5190;
    public const AOL_1 = 5191;
    public const AOL_2 = 5192;
    public const AOL_3 = 5193;
    public const CPSCOMM = 5194;
    public const AMPL_LIC = 5195;
    public const AMPL_TABLEPROXY = 5196;
    public const TUNSTALL_LWP = 5197;
    public const TARGUS_GETDATA = 5200;
    public const TARGUS_GETDATA1 = 5201;
    public const TARGUS_GETDATA2 = 5202;
    public const TARGUS_GETDATA3 = 5203;
    public const NOMAD = 5209;
    public const NOTEZA = 5215;
    public const _3EXMP = 5221;
    public const XMPP_CLIENT = 5222;
    public const HPVIRTGRP = 5223;
    public const HPVIRTCTRL = 5224;
    public const HP_SERVER = 5225;
    public const HP_STATUS = 5226;
    public const PERFD = 5227;
    public const HPVROOM = 5228;
    public const JAXFLOW = 5229;
    public const JAXFLOW_DATA = 5230;
    public const CRUSECONTROL = 5231;
    public const CSEDAEMON = 5232;
    public const ENFS = 5233;
    public const EENET = 5234;
    public const GALAXY_NETWORK = 5235;
    public const PADL2SIM = 5236;
    public const MNET_DISCOVERY = 5237;
    public const DOWNTOOLS = 5245;
    public const CAACWS = 5248;
    public const CAACLANG2 = 5249;
    public const SOAGATEWAY = 5250;
    public const CAEVMS = 5251;
    public const MOVAZ_SSC = 5252;
    public const KPDP = 5253;
    public const LOGCABIN = 5254;
    public const _3COM_NJACK_1 = 5264;
    public const _3COM_NJACK_2 = 5265;
    public const XMPP_SERVER = 5269;
    public const CARTOGRAPHERXMP = 5270;
    public const CUELINK = 5271;
    public const PK = 5272;
    public const XMPP_BOSH = 5280;
    public const UNDO_LM = 5281;
    public const TRANSMIT_PORT = 5282;
    public const PRESENCE = 5298;
    public const NLG_DATA = 5299;
    public const HACL_HB = 5300;
    public const HACL_GS = 5301;
    public const HACL_CFG = 5302;
    public const HACL_PROBE = 5303;
    public const HACL_LOCAL = 5304;
    public const HACL_TEST = 5305;
    public const SUN_MC_GRP = 5306;
    public const SCO_AIP = 5307;
    public const CFENGINE = 5308;
    public const JPRINTER = 5309;
    public const OUTLAWS = 5310;
    public const PERMABIT_CS = 5312;
    public const RRDP = 5313;
    public const OPALIS_RBT_IPC = 5314;
    public const HACL_POLL = 5315;
    public const HPBLADEMS = 5316;
    public const HPDEVMS = 5317;
    public const PKIX_CMC = 5318;
    public const BSFSERVER_ZN = 5320;
    public const BSFSVR_ZN_SSL = 5321;
    public const KFSERVER = 5343;
    public const XKOTODRCP = 5344;
    public const STUNS = 5349;
    public const DNS_LLQ = 5352;
    public const MDNS = 5353;
    public const MDNSRESPONDER = 5354;
    public const LLMNR = 5355;
    public const MS_SMLBIZ = 5356;
    public const WSDAPI = 5357;
    public const WSDAPI_S = 5358;
    public const MS_ALERTER = 5359;
    public const MS_SIDESHOW = 5360;
    public const MS_S_SIDESHOW = 5361;
    public const SERVERWSD2 = 5362;
    public const NET_PROJECTION = 5363;
    public const STRESSTESTER = 5397;
    public const ELEKTRON_ADMIN = 5398;
    public const SECURITYCHASE = 5399;
    public const EXCERPT = 5400;
    public const EXCERPTS = 5401;
    public const _MFTP = 5402;
    public const HPOMS_CI_LSTN = 5403;
    public const HPOMS_DPS_LSTN = 5404;
    public const NETSUPPORT = 5405;
    public const SYSTEMICS_SOX = 5406;
    public const FORESYTE_CLEAR = 5407;
    public const FORESYTE_SEC = 5408;
    public const SALIENT_DTASRV = 5409;
    public const SALIENT_USRMGR = 5410;
    public const ACTNET = 5411;
    public const CONTINUUS = 5412;
    public const WWIOTALK = 5413;
    public const STATUSD = 5414;
    public const NS_SERVER = 5415;
    public const SNS_GATEWAY = 5416;
    public const SNS_AGENT = 5417;
    public const MCNTP = 5418;
    public const DJ_ICE = 5419;
    public const CYLINK_C = 5420;
    public const NETSUPPORT2 = 5421;
    public const SALIENT_MUX = 5422;
    public const VIRTUALUSER = 5423;
    public const BEYOND_REMOTE = 5424;
    public const BR_CHANNEL = 5425;
    public const DEVBASIC = 5426;
    public const SCO_PEER_TTA = 5427;
    public const TELACONSOLE = 5428;
    public const BASE = 5429;
    public const RADEC_CORP = 5430;
    public const PARK_AGENT = 5431;
    public const POSTGRESQL = 5432;
    public const PYRRHO = 5433;
    public const SGI_ARRAYD = 5434;
    public const SCEANICS = 5435;
    public const SPSS = 5443;
    public const SMBDIRECT = 5445;
    public const TIEPIE = 5450;
    public const SUREBOX = 5453;
    public const APC_5454 = 5454;
    public const APC_5455 = 5455;
    public const APC_5456 = 5456;
    public const SILKMETER = 5461;
    public const TTL_PUBLISHER = 5462;
    public const TTLPRICEPROXY = 5463;
    public const QUAILNET = 5464;
    public const NETOPS_BROKER = 5465;
    public const APSOLAB_COL = 5470;
    public const APSOLAB_COLS = 5471;
    public const APSOLAB_TAG = 5472;
    public const APSOLAB_TAGS = 5473;
    public const APSOLAB_DATA = 5475;
    public const FCP_ADDR_SRVR1 = 5500;
    public const FCP_ADDR_SRVR2 = 5501;
    public const FCP_SRVR_INST1 = 5502;
    public const FCP_SRVR_INST2 = 5503;
    public const FCP_CICS_GW1 = 5504;
    public const CHECKOUTDB = 5505;
    public const AMC = 5506;
    public const PSL_MANAGEMENT = 5507;
    public const CBUS = 5550;
    public const SGI_EVENTMOND = 5553;
    public const SGI_ESPHTTP = 5554;
    public const PERSONAL_AGENT = 5555;
    public const FREECIV = 5556;
    public const FARENET = 5557;
    public const HPE_DP_BURA = 5565;
    public const WESTEC_CONNECT = 5566;
    public const DOF_DPS_MC_SEC = 5567;
    public const SDT = 5568;
    public const RDMNET_CTRL = 5569;
    public const SDMMP = 5573;
    public const LSI_BOBCAT = 5574;
    public const ORA_OAP = 5575;
    public const FDTRACKS = 5579;
    public const TMOSMS0 = 5580;
    public const TMOSMS1 = 5581;
    public const FAC_RESTORE = 5582;
    public const TMO_ICON_SYNC = 5583;
    public const BIS_WEB = 5584;
    public const BIS_SYNC = 5585;
    public const ATT_MT_SMS = 5586;
    public const ININMESSAGING = 5597;
    public const MCTFEED = 5598;
    public const ESINSTALL = 5599;
    public const ESMMANAGER = 5600;
    public const ESMAGENT = 5601;
    public const A1_MSC = 5602;
    public const A1_BS = 5603;
    public const A3_SDUNODE = 5604;
    public const A4_SDUNODE = 5605;
    public const EFR = 5618;
    public const NINAF = 5627;
    public const HTRUST = 5628;
    public const SYMANTEC_SFDB = 5629;
    public const PRECISE_COMM = 5630;
    public const PCANYWHEREDATA = 5631;
    public const PCANYWHERESTAT = 5632;
    public const BEORL = 5633;
    public const XPRTLD = 5634;
    public const SFMSSO = 5635;
    public const SFM_DB_SERVER = 5636;
    public const CSSC = 5637;
    public const FLCRS = 5638;
    public const ICS = 5639;
    public const VFMOBILE = 5646;
    public const NRPE = 5666;
    public const FILEMQ = 5670;
    public const AMQPS = 5671;
    public const AMQP = 5672;
    public const JMS = 5673;
    public const HYPERSCSI_PORT = 5674;
    public const V5UA = 5675;
    public const RAADMIN = 5676;
    public const QUESTDB2_LNCHR = 5677;
    public const RRAC = 5678;
    public const DCCM = 5679;
    public const AURIGA_ROUTER = 5680;
    public const NCXCP = 5681;
    public const COAP = 5683;
    public const COAPS = 5684;
    public const GGZ = 5688;
    public const QMVIDEO = 5689;
    public const RBSYSTEM = 5693;
    public const KMIP = 5696;
    public const SUPPORTASSIST = 5700;
    public const STORAGEOS = 5705;
    public const PROSHAREAUDIO = 5713;
    public const PROSHAREVIDEO = 5714;
    public const PROSHAREDATA = 5715;
    public const PROSHAREREQUEST = 5716;
    public const PROSHARENOTIFY = 5717;
    public const DPM = 5718;
    public const DPM_AGENT = 5719;
    public const MS_LICENSING = 5720;
    public const DTPT = 5721;
    public const MSDFSR = 5722;
    public const OMHS = 5723;
    public const OMSDK = 5724;
    public const MS_ILM = 5725;
    public const MS_ILM_STS = 5726;
    public const ASGENF = 5727;
    public const IO_DIST_DATA = 5728;
    public const OPENMAIL = 5729;
    public const UNIENG = 5730;
    public const IDA_DISCOVER1 = 5741;
    public const IDA_DISCOVER2 = 5742;
    public const WATCHDOC_POD = 5743;
    public const WATCHDOC = 5744;
    public const FCOPY_SERVER = 5745;
    public const FCOPYS_SERVER = 5746;
    public const TUNATIC = 5747;
    public const TUNALYZER = 5748;
    public const RSCD = 5750;
    public const OPENMAILG = 5755;
    public const X500MS = 5757;
    public const OPENMAILNS = 5766;
    public const S_OPENMAIL = 5767;
    public const OPENMAILPXY = 5768;
    public const SPRAMSCA = 5769;
    public const SPRAMSD = 5770;
    public const NETAGENT = 5771;
    public const DALI_PORT = 5777;
    public const VTS_RPC = 5780;
    public const _3PAR_EVTS = 5781;
    public const _3PAR_MGMT = 5782;
    public const _3PAR_MGMT_SSL = 5783;
    public const _3PAR_RCOPY = 5785;
    public const XTREAMX = 5793;
    public const ICMPD = 5813;
    public const SPT_AUTOMATION = 5814;
    public const SHIPRUSH_D_CH = 5841;
    public const REVERSION = 5842;
    public const WHEREHOO = 5859;
    public const PPSUITEMSG = 5863;
    public const DIAMETERS = 5868;
    public const JUTE = 5883;
    public const RFB = 5900;
    public const CM = 5910;
    public const CPDLC = 5911;
    public const FIS = 5912;
    public const ADS_C = 5913;
    public const INDY = 5963;
    public const MPPOLICY_V5 = 5968;
    public const MPPOLICY_MGR = 5969;
    public const COUCHDB = 5984;
    public const WSMAN = 5985;
    public const WSMANS = 5986;
    public const WBEM_RMI = 5987;
    public const WBEM_HTTP = 5988;
    public const WBEM_HTTPS = 5989;
    public const WBEM_EXP_HTTPS = 5990;
    public const NUXSL = 5991;
    public const CONSUL_INSIGHT = 5992;
    public const CIM_RS = 5993;
    public const CVSUP = 5999;
    public const X11 = 6000; // 6000-6063
    public const NDL_AHP_SVC = 6064;
    public const WINPHARAOH = 6065;
    public const EWCTSP = 6066;
    public const GSMP_ANCP = 6068;
    public const TRIP = 6069;
    public const MESSAGEASAP = 6070;
    public const SSDTP = 6071;
    public const DIAGNOSE_PROC = 6072;
    public const DIRECTPLAY8 = 6073;
    public const MAX = 6074;
    public const DPM_ACM = 6075;
    public const MSFT_DPM_CERT = 6076;
    public const ICONSTRUCTSRV = 6077;
    public const RELOAD_CONFIG = 6084;
    public const KONSPIRE2B = 6085;
    public const PDTP = 6086;
    public const LDSS = 6087;
    public const DOGLMS = 6088;
    public const RAXA_MGMT = 6099;
    public const SYNCHRONET_DB = 6100;
    public const SYNCHRONET_RTC = 6101;
    public const SYNCHRONET_UPD = 6102;
    public const RETS = 6103;
    public const DBDB = 6104;
    public const PRIMASERVER = 6105;
    public const MPSSERVER = 6106;
    public const ETC_CONTROL = 6107;
    public const SERCOMM_SCADMIN = 6108;
    public const GLOBECAST_ID = 6109;
    public const SOFTCM = 6110;
    public const SPC = 6111;
    public const DTSPCD = 6112;
    public const DAYLITESERVER = 6113;
    public const WRSPICE = 6114;
    public const XIC = 6115;
    public const XTLSERV = 6116;
    public const DAYLITETOUCH = 6117;
    public const SPDY = 6121;
    public const BEX_WEBADMIN = 6122;
    public const BACKUP_EXPRESS = 6123;
    public const PNBS = 6124;
    public const DAMEWAREMOBGTWY = 6130;
    public const NBT_WOL = 6133;
    public const PULSONIXNLS = 6140;
    public const META_CORP = 6141;
    public const ASPENTEC_LM = 6142;
    public const WATERSHED_LM = 6143;
    public const STATSCI1_LM = 6144;
    public const STATSCI2_LM = 6145;
    public const LONEWOLF_LM = 6146;
    public const MONTAGE_LM = 6147;
    public const RICARDO_LM_2 = 6148;
    public const TAL_POD = 6149;
    public const EFB_ACI = 6159;
    public const ECMP = 6160;
    public const PATROL_ISM = 6161;
    public const PATROL_COLL = 6162;
    public const PSCRIBE = 6163;
    public const LM_X = 6200;
    public const QMTPS = 6209;
    public const RADMIND = 6222;
    public const JEOL_NSDTP_1 = 6241;
    public const JEOL_NSDTP_2 = 6242;
    public const JEOL_NSDTP_3 = 6243;
    public const JEOL_NSDTP_4 = 6244;
    public const TL1_RAW_SSL = 6251;
    public const TL1_SSH = 6252;
    public const CRIP = 6253;
    public const GLD = 6267;
    public const GRID = 6268;
    public const GRID_ALT = 6269;
    public const BMC_GRX = 6300;
    public const BMC_CTD_LDAP = 6301;
    public const UFMP = 6306;
    public const SCUP = 6315;
    public const ABB_ESCP = 6316;
    public const NAV_DATA_CMD = 6317;
    public const REPSVC = 6320;
    public const EMP_SERVER1 = 6321;
    public const EMP_SERVER2 = 6322;
    public const HRD_NCS = 6324;
    public const DT_MGMTSVC = 6325;
    public const DT_VRA = 6326;
    public const SFLOW = 6343;
    public const STRELETZ = 6344;
    public const GNUTELLA_SVC = 6346;
    public const GNUTELLA_RTR = 6347;
    public const ADAP = 6350;
    public const PMCS = 6355;
    public const METAEDIT_MU = 6360;
    public const METAEDIT_SE = 6370;
    public const REDIS = 6379;
    public const METATUDE_MDS = 6382;
    public const CLARIION_EVR01 = 6389;
    public const METAEDIT_WS = 6390;
    public const BOE_CMS = 6400;
    public const BOE_WAS = 6401;
    public const BOE_EVENTSRV = 6402;
    public const BOE_CACHESVR = 6403;
    public const BOE_FILESVR = 6404;
    public const BOE_PAGESVR = 6405;
    public const BOE_PROCESSSVR = 6406;
    public const BOE_RESSSVR1 = 6407;
    public const BOE_RESSSVR2 = 6408;
    public const BOE_RESSSVR3 = 6409;
    public const BOE_RESSSVR4 = 6410;
    public const FAXCOMSERVICE = 6417;
    public const SYSERVERREMOTE = 6418;
    public const SVDRP = 6419;
    public const NIM_VDRSHELL = 6420;
    public const NIM_WAN = 6421;
    public const PGBOUNCER = 6432;
    public const TARP = 6442;
    public const SUN_SR_HTTPS = 6443;
    public const SGE_QMASTER = 6444;
    public const SGE_EXECD = 6445;
    public const MYSQL_PROXY = 6446;
    public const SKIP_CERT_RECV = 6455;
    public const SKIP_CERT_SEND = 6456;
    public const IEEE11073_20701 = 6464;
    public const LVISION_LM = 6471;
    public const SUN_SR_HTTP = 6480;
    public const SERVICETAGS = 6481;
    public const LDOMS_MGMT = 6482;
    public const SUNVTS_RMI = 6483;
    public const SUN_SR_JMS = 6484;
    public const SUN_SR_IIOP = 6485;
    public const SUN_SR_IIOPS = 6486;
    public const SUN_SR_IIOP_AUT = 6487;
    public const SUN_SR_JMX = 6488;
    public const SUN_SR_ADMIN = 6489;
    public const BOKS = 6500;
    public const BOKS_SERVC = 6501;
    public const BOKS_SERVM = 6502;
    public const BOKS_CLNTD = 6503;
    public const BADM_PRIV = 6505;
    public const BADM_PUB = 6506;
    public const BDIR_PRIV = 6507;
    public const BDIR_PUB = 6508;
    public const MGCS_MFP_PORT = 6509;
    public const MCER_PORT = 6510;
    public const NETCONF_TLS = 6513;
    public const SYSLOG_TLS = 6514;
    public const ELIPSE_REC = 6515;
    public const LDS_DISTRIB = 6543;
    public const LDS_DUMP = 6544;
    public const APC_6547 = 6547;
    public const APC_6548 = 6548;
    public const APC_6549 = 6549;
    public const FG_SYSUPDATE = 6550;
    public const SUM = 6551;
    public const XDSXDM = 6558;
    public const SANE_PORT = 6566;
    public const CANIT_STORE = 6568;
    public const AFFILIATE = 6579;
    public const PARSEC_MASTER = 6580;
    public const PARSEC_PEER = 6581;
    public const PARSEC_GAME = 6582;
    public const JOAJEWELSUITE = 6583;
    public const MSHVLM = 6600;
    public const MSTMG_SSTP = 6601;
    public const WSSCOMFRMWK = 6602;
    public const ODETTE_FTPS = 6619;
    public const KFTP_DATA = 6620;
    public const KFTP = 6621;
    public const MCFTP = 6622;
    public const KTELNET = 6623;
    public const DATASCALER_DB = 6624;
    public const DATASCALER_CTL = 6625;
    public const WAGO_SERVICE = 6626;
    public const NEXGEN = 6627;
    public const AFESC_MC = 6628;
    public const NEXGEN_AUX = 6629;
    public const MXODBC_CONNECT = 6632;
    public const OVSDB = 6640;
    public const OPENFLOW = 6653;
    public const PCS_SF_UI_MAN = 6655;
    public const EMGMSG = 6656;
    public const IRCU = 6665;
    public const IRCU_2 = 6666;
    public const IRCU_3 = 6667;
    public const IRCU_4 = 6668;
    public const IRCU_5 = 6669;
    public const VOCALTEC_GOLD = 6670;
    public const P4P_PORTAL = 6671;
    public const VISION_SERVER = 6672;
    public const VISION_ELMD = 6673;
    public const VFBP = 6678;
    public const OSAUT = 6679;
    public const CLEVER_CTRACE = 6687;
    public const CLEVER_TCPIP = 6688;
    public const TSA = 6689;
    public const CLEVERDETECT = 6690;
    public const IRCS_U = 6697;
    public const KTI_ICAD_SRVR = 6701;
    public const E_DESIGN_NET = 6702;
    public const E_DESIGN_WEB = 6703;
    public const IBPROTOCOL = 6714;
    public const FIBOTRADER_COM = 6715;
    public const PRINCITY_AGENT = 6716;
    public const BMC_PERF_AGENT = 6767;
    public const BMC_PERF_MGRD = 6768;
    public const ADI_GXP_SRVPRT = 6769;
    public const PLYSRV_HTTP = 6770;
    public const PLYSRV_HTTPS = 6771;
    public const NTZ_TRACKER = 6777;
    public const NTZ_P2P_STORAGE = 6778;
    public const DGPF_EXCHG = 6785;
    public const SMC_JMX = 6786;
    public const SMC_ADMIN = 6787;
    public const SMC_HTTP = 6788;
    public const RADG = 6789;
    public const HNMP = 6790;
    public const HNM = 6791;
    public const ACNET = 6801;
    public const PENTBOX_SIM = 6817;
    public const AMBIT_LM = 6831;
    public const NETMO_DEFAULT = 6841;
    public const NETMO_HTTP = 6842;
    public const ICCRUSHMORE = 6850;
    public const ACCTOPUS_CC = 6868;
    public const MUSE = 6888;
    public const RTIMEVIEWER = 6900;
    public const JETSTREAM = 6901;
    public const ETHOSCAN = 6935;
    public const XSMSVC = 6936;
    public const BIOSERVER = 6946;
    public const OTLP = 6951;
    public const JMACT3 = 6961;
    public const JMEVT2 = 6962;
    public const SWISMGR1 = 6963;
    public const SWISMGR2 = 6964;
    public const SWISTRAP = 6965;
    public const SWISPOL = 6966;
    public const ACMSODA = 6969;
    public const CONDUCTOR = 6970;
    public const MOBILITYSRV = 6997;
    public const IATP_HIGHPRI = 6998;
    public const IATP_NORMALPRI = 6999;
    public const AFS3_FILESERVER = 7000;
    public const AFS3_CALLBACK = 7001;
    public const AFS3_PRSERVER = 7002;
    public const AFS3_VLSERVER = 7003;
    public const AFS3_KASERVER = 7004;
    public const AFS3_VOLSER = 7005;
    public const AFS3_ERRORS = 7006;
    public const AFS3_BOS = 7007;
    public const AFS3_UPDATE = 7008;
    public const AFS3_RMTSYS = 7009;
    public const UPS_ONLINET = 7010;
    public const TALON_DISC = 7011;
    public const TALON_ENGINE = 7012;
    public const MICROTALON_DIS = 7013;
    public const MICROTALON_COM = 7014;
    public const TALON_WEBSERVER = 7015;
    public const SPG = 7016;
    public const GRASP = 7017;
    public const FISA_SVC = 7018;
    public const DOCERI_CTL = 7019;
    public const DPSERVE = 7020;
    public const DPSERVEADMIN = 7021;
    public const CTDP = 7022;
    public const CT2NMCS = 7023;
    public const VMSVC = 7024;
    public const VMSVC_2 = 7025;
    public const OP_PROBE = 7030;
    public const IPOSPLANET = 7031;
    public const ARCP = 7070;
    public const IWG1 = 7071;
    public const IBA_CFG = 7072;
    public const MARTALK = 7073;
    public const EMPOWERID = 7080;
    public const LAZY_PTOP = 7099;
    public const FONT_SERVICE = 7100;
    public const ELCN = 7101;
    public const ROTHAGA = 7117;
    public const VIRPROT_LM = 7121;
    public const SCENIDM = 7128;
    public const SCENCCS = 7129;
    public const CABSM_COMM = 7161;
    public const CAISTORAGEMGR = 7162;
    public const CACSAMBROKER = 7163;
    public const FSR = 7164;
    public const DOC_SERVER = 7165;
    public const ARUBA_SERVER = 7166;
    public const CASRMAGENT = 7167;
    public const CNCKADSERVER = 7168;
    public const CCAG_PIB = 7169;
    public const NSRP = 7170;
    public const DRM_PRODUCTION = 7171;
    public const METALBEND = 7172;
    public const ZSECURE = 7173;
    public const CLUTILD = 7174;
    public const FODMS = 7200;
    public const DLIP = 7201;
    public const PON_ICTP = 7202;
    public const PS_SERVER = 7215;
    public const PS_CAPTURE_PRO = 7216;
    public const RAMP = 7227;
    public const CITRIXUPP = 7228;
    public const CITRIXUPPG = 7229;
    public const DISPLAY = 7236;
    public const PADS = 7237;
    public const FRC_HICP = 7244;
    public const CNAP = 7262;
    public const WATCHME_7272 = 7272;
    public const OMA_RLP = 7273;
    public const OMA_RLP_S = 7274;
    public const OMA_ULP = 7275;
    public const OMA_ILP = 7276;
    public const OMA_ILP_S = 7277;
    public const OMA_DCDOCBS = 7278;
    public const CTXLIC = 7279;
    public const ITACTIONSERVER1 = 7280;
    public const ITACTIONSERVER2 = 7281;
    public const MZCA_ACTION = 7282;
    public const GENSTAT = 7283;
    public const SWX = 7300; // 7300-7359
    public const LCM_SERVER = 7365;
    public const MINDFILESYS = 7391;
    public const MRSSRENDEZVOUS = 7392;
    public const NFOLDMAN = 7393;
    public const FSE = 7394;
    public const WINQEDIT = 7395;
    public const HEXARC = 7397;
    public const RTPS_DISCOVERY = 7400;
    public const RTPS_DD_UT = 7401;
    public const RTPS_DD_MT = 7402;
    public const IONIXNETMON = 7410;
    public const DAQSTREAM = 7411;
    public const MTPORTMON = 7421;
    public const PMDMGR = 7426;
    public const OVEADMGR = 7427;
    public const OVLADMGR = 7428;
    public const OPI_SOCK = 7429;
    public const XMPV7 = 7430;
    public const PMD = 7431;
    public const FAXIMUM = 7437;
    public const ORACLEAS_HTTPS = 7443;
    public const STTUNNEL = 7471;
    public const RISE = 7473;
    public const NEO4J = 7474;
    public const OPENIT = 7478;
    public const TELOPS_LMD = 7491;
    public const SILHOUETTE = 7500;
    public const OVBUS = 7501;
    public const ADCP = 7508;
    public const ACPLT = 7509;
    public const OVHPAS = 7510;
    public const PAFEC_LM = 7511;
    public const SARATOGA = 7542;
    public const ATUL = 7543;
    public const NTA_DS = 7544;
    public const NTA_US = 7545;
    public const CFS = 7546;
    public const CWMP = 7547;
    public const TIDP = 7548;
    public const NLS_TL = 7549;
    public const CONTROLONE_CON = 7551;
    public const SNCP = 7560;
    public const CFW = 7563;
    public const VSI_OMEGA = 7566;
    public const DELL_EQL_ASM = 7569;
    public const ARIES_KFINDER = 7570;
    public const COHERENCE = 7574;
    public const SUN_LM = 7588;
    public const MIPI_DEBUG = 7606;
    public const INDI = 7624;
    public const SIMCO = 7626;
    public const SOAP_HTTP = 7627;
    public const ZEN_PAWN = 7628;
    public const XDAS = 7629;
    public const HAWK = 7630;
    public const TESLA_SYS_MSG = 7631;
    public const PMDFMGT = 7633;
    public const CUSEEME = 7648;
    public const ROME = 7663;
    public const IMQSTOMP = 7672;
    public const IMQSTOMPS = 7673;
    public const IMQTUNNELS = 7674;
    public const IMQTUNNEL = 7675;
    public const IMQBROKERD = 7676;
    public const SUN_USER_HTTPS = 7677;
    public const PANDO_PUB = 7680;
    public const DMT = 7683;
    public const BOLT = 7687;
    public const COLLABER = 7689;
    public const KLIO = 7697;
    public const EM7_SECOM = 7700;
    public const SYNC_EM7 = 7707;
    public const SCINET = 7708;
    public const MEDIMAGEPORTAL = 7720;
    public const NSDEEPFREEZECTL = 7724;
    public const NITROGEN = 7725;
    public const FREEZEXSERVICE = 7726;
    public const TRIDENT_DATA = 7727;
    public const OSVR = 7728;
    public const SMIP = 7734;
    public const AIAGENT = 7738;
    public const SCRIPTVIEW = 7741;
    public const MSSS = 7742;
    public const SSTP_1 = 7743;
    public const RAQMON_PDU = 7744;
    public const PRGP = 7747;
    public const INETFS = 7775;
    public const CBT = 7777;
    public const INTERWISE = 7778;
    public const VSTAT = 7779;
    public const ACCU_LMGR = 7781;
    public const MINIVEND = 7786;
    public const POPUP_REMINDERS = 7787;
    public const OFFICE_TOOLS = 7789;
    public const Q3ADE = 7794;
    public const PNET_CONN = 7797;
    public const PNET_ENC = 7798;
    public const ALTBSDP = 7799;
    public const ASR = 7800;
    public const SSP_CLIENT = 7801;
    public const RBT_WANOPT = 7810;
    public const APC_7845 = 7845;
    public const APC_7846 = 7846;
    public const CSOAUTH = 7847;
    public const MOBILEANALYZER = 7869;
    public const RBT_SMC = 7870;
    public const MDM = 7871;
    public const OWMS = 7878;
    public const PSS = 7880;
    public const UBROKER = 7887;
    public const MEVENT = 7900;
    public const TNOS_SP = 7901;
    public const TNOS_DP = 7902;
    public const TNOS_DPS = 7903;
    public const QO_SECURE = 7913;
    public const T2_DRM = 7932;
    public const T2_BRM = 7933;
    public const GENERALSYNC = 7962;
    public const SUPERCELL = 7967;
    public const MICROMUSE_NCPS = 7979;
    public const QUEST_VISTA = 7980;
    public const SOSSD_COLLECT = 7981;
    public const SOSSD_AGENT = 7982;
    public const PUSHNS = 7997;
    public const IRDMI2 = 7999;
    public const IRDMI = 8000;
    public const VCOM_TUNNEL = 8001;
    public const TERADATAORDBMS = 8002;
    public const MCREPORT = 8003;
    public const P2PEVOLVENET = 8004;
    public const MXI = 8005;
    public const WPL_ANALYTICS = 8006;
    public const WARPPIPE = 8007;
    public const HTTP_ALT_2 = 8008;
    public const QBDB = 8019;
    public const INTU_EC_SVCDISC = 8020;
    public const INTU_EC_CLIENT = 8021;
    public const OA_SYSTEM = 8022;
    public const CA_AUDIT_DA = 8025;
    public const CA_AUDIT_DS = 8026;
    public const PRO_ED = 8032;
    public const MINDPRINT = 8033;
    public const VANTRONIX_MGMT = 8034;
    public const AMPIFY = 8040;
    public const ENGUITY_XCCETP = 8041;
    public const FS_AGENT = 8042;
    public const FS_SERVER = 8043;
    public const FS_MGMT = 8044;
    public const ROCRAIL = 8051;
    public const SENOMIX01 = 8052;
    public const SENOMIX02 = 8053;
    public const SENOMIX03 = 8054;
    public const SENOMIX04 = 8055;
    public const SENOMIX05 = 8056;
    public const SENOMIX06 = 8057;
    public const SENOMIX07 = 8058;
    public const SENOMIX08 = 8059;
    public const TOAD_BI_APPSRVR = 8066;
    public const INFI_ASYNC = 8067;
    public const UCS_ISC = 8070;
    public const GADUGADU = 8074;
    public const MLES = 8077;
    public const HTTP_ALT_3 = 8080;
    public const SUNPROXYADMIN = 8081;
    public const US_CLI = 8082;
    public const US_SRV = 8083;
    public const D_S_N = 8086;
    public const SIMPLIFYMEDIA = 8087;
    public const RADAN_HTTP = 8088;
    public const OPSMESSAGING = 8090;
    public const JAMLINK = 8091;
    public const SAC = 8097;
    public const XPRINT_SERVER = 8100;
    public const LDOMS_MIGR = 8101;
    public const KZ_MIGR = 8102;
    public const MTL8000_MATRIX = 8115;
    public const CP_CLUSTER = 8116;
    public const PURITYRPC = 8117;
    public const PRIVOXY = 8118;
    public const APOLLO_DATA = 8121;
    public const APOLLO_ADMIN = 8122;
    public const PAYCASH_ONLINE = 8128;
    public const PAYCASH_WBP = 8129;
    public const INDIGO_VRMI = 8130;
    public const INDIGO_VBCP = 8131;
    public const DBABBLE = 8132;
    public const PUPPET = 8140;
    public const ISDD = 8148;
    public const QUANTASTOR = 8153;
    public const PATROL = 8160;
    public const PATROL_SNMP = 8161;
    public const LPAR2RRD = 8162;
    public const INTERMAPPER = 8181;
    public const VMWARE_FDM = 8182;
    public const PROREMOTE = 8183;
    public const ITACH = 8184;
    public const GCP_RPHY = 8190;
    public const LIMNERPRESSURE = 8191;
    public const SPYTECHPHONE = 8192;
    public const BLP1 = 8194;
    public const BLP2 = 8195;
    public const VVR_DATA = 8199;
    public const TRIVNET1 = 8200;
    public const TRIVNET2 = 8201;
    public const LM_PERFWORKS = 8204;
    public const LM_INSTMGR = 8205;
    public const LM_DTA = 8206;
    public const LM_SSERVER = 8207;
    public const LM_WEBWATCHER = 8208;
    public const REXECJ = 8230;
    public const SYNAPSE_NHTTPS = 8243;
    public const ROBOT_REMOTE = 8270;
    public const PANDO_SEC = 8276;
    public const SYNAPSE_NHTTP = 8280;
    public const LIBELLE = 8282;
    public const BLP3 = 8292;
    public const HIPERSCAN_ID = 8293;
    public const BLP4 = 8294;
    public const TMI = 8300;
    public const AMBERON = 8301;
    public const HUB_OPEN_NET = 8313;
    public const TNP_DISCOVER = 8320;
    public const TNP = 8321;
    public const GARMIN_MARINE = 8322;
    public const SERVER_FIND = 8351;
    public const CRUISE_ENUM = 8376;
    public const CRUISE_SWROUTE = 8377;
    public const CRUISE_CONFIG = 8378;
    public const CRUISE_DIAGS = 8379;
    public const CRUISE_UPDATE = 8380;
    public const M2MSERVICES = 8383;
    public const CVD = 8400;
    public const SABARSD = 8401;
    public const ABARSD = 8402;
    public const ADMIND_2 = 8403;
    public const SVCLOUD = 8404;
    public const SVBACKUP = 8405;
    public const DLPX_SP = 8415;
    public const ESPEECH = 8416;
    public const ESPEECH_RTP = 8417;
    public const ARITTS = 8423;
    public const CYBRO_A_BUS = 8442;
    public const PCSYNC_HTTPS = 8443;
    public const PCSYNC_HTTP = 8444;
    public const COPY = 8445;
    public const NPMP = 8450;
    public const NEXENTAMV = 8457;
    public const CISCO_AVP = 8470;
    public const PIM_PORT = 8471;
    public const OTV = 8472;
    public const VP2P = 8473;
    public const NOTESHARE = 8474;
    public const FMTP = 8500;
    public const CMTP_MGT = 8501;
    public const FTNMTP = 8502;
    public const RTSP_ALT = 8554;
    public const D_FENCE = 8555;
    public const DOF_TUNNEL = 8567;
    public const ASTERIX = 8600;
    public const CANON_MFNP = 8610;
    public const CANON_BJNP1 = 8611;
    public const CANON_BJNP2 = 8612;
    public const CANON_BJNP3 = 8613;
    public const CANON_BJNP4 = 8614;
    public const IMINK = 8615;
    public const MONETRA = 8665;
    public const MONETRA_ADMIN = 8666;
    public const MSI_CPS_RM = 8675;
    public const SUN_AS_JMXRMI = 8686;
    public const OPENREMOTE_CTRL = 8688;
    public const VNYX = 8699;
    public const NVC = 8711;
    public const IBUS = 8733;
    public const DEY_KEYNEG = 8750;
    public const MC_APPSERVER = 8763;
    public const OPENQUEUE = 8764;
    public const ULTRASEEK_HTTP = 8765;
    public const AMCS = 8766;
    public const DPAP = 8770;
    public const UEC = 8778;
    public const MSGCLNT = 8786;
    public const MSGSRVR = 8787;
    public const ACD_PM = 8793;
    public const SUNWEBADMIN = 8800;
    public const TRUECM = 8804;
    public const DXSPIDER = 8873;
    public const CDDBP_ALT = 8880;
    public const GALAXY4D = 8881;
    public const SECURE_MQTT = 8883;
    public const DDI_TCP_1 = 8888;
    public const DDI_TCP_2 = 8889;
    public const DDI_TCP_3 = 8890;
    public const DDI_TCP_4 = 8891;
    public const DDI_TCP_5 = 8892;
    public const DDI_TCP_6 = 8893;
    public const DDI_TCP_7 = 8894;
    public const OSPF_LITE = 8899;
    public const JMB_CDS1 = 8900;
    public const JMB_CDS2 = 8901;
    public const MANYONE_HTTP = 8910;
    public const MANYONE_XML = 8911;
    public const WCBACKUP = 8912;
    public const DRAGONFLY = 8913;
    public const TWDS = 8937;
    public const UB_DNS_CONTROL = 8953;
    public const CUMULUS_ADMIN = 8954;
    public const NOD_PROVIDER = 8980;
    public const SUNWEBADMINS = 8989;
    public const HTTP_WMAP = 8990;
    public const HTTPS_WMAP = 8991;
    public const ORACLE_MS_ENS = 8997;
    public const CANTO_ROBOFLOW = 8998;
    public const BCTP = 8999;
    public const CSLISTENER = 9000;
    public const ETLSERVICEMGR = 9001;
    public const DYNAMID = 9002;
    public const GOLEM = 9005;
    public const OGS_SERVER = 9008;
    public const PICHAT = 9009;
    public const SDR = 9010;
    public const TAMBORA = 9020;
    public const PANAGOLIN_IDENT = 9021;
    public const PARAGENT = 9022;
    public const SWA_1 = 9023;
    public const SWA_2 = 9024;
    public const SWA_3 = 9025;
    public const SWA_4 = 9026;
    public const VERSIERA = 9050;
    public const FIO_CMGMT = 9051;
    public const CARDWEB_IO = 9060;
    public const GLRPC = 9080;
    public const EMC_PP_MGMTSVC = 9083;
    public const AURORA = 9084;
    public const IBM_RSYSCON = 9085;
    public const NET2DISPLAY = 9086;
    public const CLASSIC = 9087;
    public const SQLEXEC = 9088;
    public const SQLEXEC_SSL = 9089;
    public const WEBSM = 9090;
    public const XMLTEC_XMLMAIL = 9091;
    public const XMLIPCREGSVC = 9092;
    public const COPYCAT = 9093;
    public const PDL_DATASTREAM = 9100;
    public const BACULA_DIR = 9101;
    public const BACULA_FD = 9102;
    public const BACULA_SD = 9103;
    public const PEERWIRE = 9104;
    public const XADMIN = 9105;
    public const ASTERGATE = 9106;
    public const ASTERGATEFAX = 9107;
    public const MXIT = 9119;
    public const GRCMP = 9122;
    public const GRCP = 9123;
    public const DDDP = 9131;
    public const APANI1 = 9160;
    public const APANI2 = 9161;
    public const APANI3 = 9162;
    public const APANI4 = 9163;
    public const APANI5 = 9164;
    public const SUN_AS_JPDA = 9191;
    public const WAP_WSP = 9200;
    public const WAP_WSP_WTP = 9201;
    public const WAP_WSP_S = 9202;
    public const WAP_WSP_WTP_S = 9203;
    public const WAP_VCARD = 9204;
    public const WAP_VCAL = 9205;
    public const WAP_VCARD_S = 9206;
    public const WAP_VCAL_S = 9207;
    public const RJCDB_VCARDS = 9208;
    public const ALMOBILE_SYSTEM = 9209;
    public const OMA_MLP = 9210;
    public const OMA_MLP_S = 9211;
    public const SERVERVIEWDBMS = 9212;
    public const SERVERSTART = 9213;
    public const IPDCESGBS = 9214;
    public const INSIS = 9215;
    public const ACME = 9216;
    public const FSC_PORT = 9217;
    public const TEAMCOHERENCE = 9222;
    public const MON_2 = 9255;
    public const PEGASUS = 9278;
    public const PEGASUS_CTL = 9279;
    public const PGPS = 9280;
    public const SWTP_PORT1 = 9281;
    public const SWTP_PORT2 = 9282;
    public const CALLWAVEIAM = 9283;
    public const VISD = 9284;
    public const N2H2SERVER = 9285;
    public const CUMULUS = 9287;
    public const ARMTECHDAEMON = 9292;
    public const STORVIEW = 9293;
    public const ARMCENTERHTTP = 9294;
    public const ARMCENTERHTTPS = 9295;
    public const VRACE = 9300;
    public const SPHINXQL = 9306;
    public const SPHINXAPI = 9312;
    public const SECURE_TS = 9318;
    public const GUIBASE = 9321;
    public const MPIDCMGR = 9343;
    public const MPHLPDMC = 9344;
    public const RANCHER = 9345;
    public const CTECHLICENSING = 9346;
    public const FJDMIMGR = 9374;
    public const BOXP = 9380;
    public const D2DCONFIG = 9387;
    public const D2DDATATRANS = 9388;
    public const ADWS = 9389;
    public const OTP = 9390;
    public const FJINVMGR = 9396;
    public const MPIDCAGT = 9397;
    public const SEC_T4NET_SRV = 9400;
    public const SEC_T4NET_CLT = 9401;
    public const SEC_PC2FAX_SRV = 9402;
    public const GIT = 9418;
    public const TUNGSTEN_HTTPS = 9443;
    public const WSO2ESB_CONSOLE = 9444;
    public const MINDARRAY_CA = 9445;
    public const SNTLKEYSSRVR = 9450;
    public const ISMSERVER = 9500;
    public const MNGSUITE = 9535;
    public const LAES_BF = 9536;
    public const TRISPEN_SRA = 9555;
    public const LDGATEWAY = 9592;
    public const CBA8 = 9593;
    public const MSGSYS = 9594;
    public const PDS = 9595;
    public const MERCURY_DISC = 9596;
    public const PD_ADMIN = 9597;
    public const VSCP = 9598;
    public const ROBIX = 9599;
    public const MICROMUSE_NCPW = 9600;
    public const STREAMCOMM_DS = 9612;
    public const IADT_TLS = 9614;
    public const ERUNBOOK_AGENT = 9616;
    public const ERUNBOOK_SERVER = 9617;
    public const CONDOR = 9618;
    public const ODBCPATHWAY = 9628;
    public const UNIPORT = 9629;
    public const PEOCTLR = 9630;
    public const PEOCOLL = 9631;
    public const PQSFLOWS = 9640;
    public const ZOOMCP = 9666;
    public const XMMS2 = 9667;
    public const TEC5_SDCTP = 9668;
    public const CLIENT_WAKEUP = 9694;
    public const CCNX = 9695;
    public const BOARD_ROAR = 9700;
    public const L5NAS_PARCHAN = 9747;
    public const BOARD_VOIP = 9750;
    public const RASADV = 9753;
    public const TUNGSTEN_HTTP = 9762;
    public const DAVSRC = 9800;
    public const SSTP_2 = 9801;
    public const DAVSRCS = 9802;
    public const SAPV1 = 9875;
    public const SD = 9876;
    public const CYBORG_SYSTEMS = 9888;
    public const GT_PROXY = 9889;
    public const MONKEYCOM = 9898;
    public const IUA = 9900;
    public const DOMAINTIME = 9909;
    public const SYPE_TRANSPORT = 9911;
    public const XYBRID_CLOUD = 9925;
    public const APC_9950 = 9950;
    public const APC_9951 = 9951;
    public const APC_9952 = 9952;
    public const ACIS = 9953;
    public const HINP = 9954;
    public const ALLJOYN_STM = 9955;
    public const ODNSP = 9966;
    public const XYBRID_RT = 9978;
    public const VISWEATHER = 9979;
    public const PUMPKINDB = 9981;
    public const DSM_SCM_TARGET = 9987;
    public const NSESRVR = 9988;
    public const OSM_APPSRVR = 9990;
    public const OSM_OEV = 9991;
    public const PALACE_1 = 9992;
    public const PALACE_2 = 9993;
    public const PALACE_3 = 9994;
    public const PALACE_4 = 9995;
    public const PALACE_5 = 9996;
    public const PALACE_6 = 9997;
    public const DISTINCT32 = 9998;
    public const DISTINCT = 9999;
    public const NDMP = 10000;
    public const SCP_CONFIG = 10001;
    public const DOCUMENTUM = 10002;
    public const DOCUMENTUM_S = 10003;
    public const EMCRMIRCCD = 10004;
    public const EMCRMIRD = 10005;
    public const NETAPP_SYNC = 10006;
    public const MVS_CAPACITY = 10007;
    public const OCTOPUS = 10008;
    public const SWDTP_SV = 10009;
    public const RXAPI = 10010;
    public const ABB_HW = 10020;
    public const ZABBIX_AGENT = 10050;
    public const ZABBIX_TRAPPER = 10051;
    public const QPTLMD = 10055;
    public const AMANDA = 10080;
    public const FAMDC = 10081;
    public const ITAP_DDTP = 10100;
    public const EZMEETING_2 = 10101;
    public const EZPROXY_2 = 10102;
    public const EZRELAY = 10103;
    public const SWDTP = 10104;
    public const BCTP_SERVER = 10107;
    public const NMEA_0183 = 10110;
    public const NETIQ_ENDPOINT = 10113;
    public const NETIQ_QCHECK = 10114;
    public const NETIQ_ENDPT = 10115;
    public const NETIQ_VOIPA = 10116;
    public const IQRM = 10117;
    public const CIMPLE = 10125;
    public const BMC_PERF_SD = 10128;
    public const BMC_GMS = 10129;
    public const QB_DB_SERVER = 10160;
    public const SNMPTLS = 10161;
    public const SNMPTLS_TRAP = 10162;
    public const TRISOAP = 10200;
    public const RSMS = 10201;
    public const APOLLO_RELAY = 10252;
    public const AXIS_WIMP_PORT = 10260;
    public const TILE_ML = 10261;
    public const BLOCKS = 10288;
    public const COSIR = 10321;
    public const MOS_LOWER = 10540;
    public const MOS_UPPER = 10541;
    public const MOS_AUX = 10542;
    public const MOS_SOAP = 10543;
    public const MOS_SOAP_OPT = 10544;
    public const SERVERDOCS = 10548;
    public const PRINTOPIA = 10631;
    public const GAP = 10800;
    public const LPDG = 10805;
    public const NBD = 10809;
    public const HELIX = 10860;
    public const BVEAPI = 10880;
    public const OCTOPUSTENTACLE = 10933;
    public const RMIAUX = 10990;
    public const IRISA = 11000;
    public const METASYS = 11001;
    public const WEAVE = 11095;
    public const ORIGO_SYNC = 11103;
    public const NETAPP_ICMGMT = 11104;
    public const NETAPP_ICDATA = 11105;
    public const SGI_LK = 11106;
    public const SGI_DMFMGR = 11109;
    public const SGI_SOAP = 11110;
    public const VCE = 11111;
    public const DICOM = 11112;
    public const SUNCACAO_SNMP = 11161;
    public const SUNCACAO_JMXMP = 11162;
    public const SUNCACAO_RMI = 11163;
    public const SUNCACAO_CSA = 11164;
    public const SUNCACAO_WEBSVC = 11165;
    public const OEMCACAO_JMXMP = 11172;
    public const T5_STRATON = 11173;
    public const OEMCACAO_RMI = 11174;
    public const OEMCACAO_WEBSVC = 11175;
    public const SMSQP = 11201;
    public const DCSL_BACKUP = 11202;
    public const WIFREE = 11208;
    public const MEMCACHE = 11211;
    public const IMIP = 11319;
    public const IMIP_CHANNELS = 11320;
    public const ARENA_SERVER = 11321;
    public const ATM_UHAS = 11367;
    public const HKP = 11371;
    public const ASGCYPRESSTCPS = 11489;
    public const TEMPEST_PORT = 11600;
    public const EMC_XSW_DCONFIG = 11623;
    public const H323CALLSIGALT = 11720;
    public const EMC_XSW_DCACHE = 11723;
    public const INTREPID_SSL = 11751;
    public const LANSCHOOL = 11796;
    public const XORAYA = 11876;
    public const SYSINFO_SP = 11967;
    public const ENTEXTXID = 12000;
    public const ENTEXTNETWK = 12001;
    public const ENTEXTHIGH = 12002;
    public const ENTEXTMED = 12003;
    public const ENTEXTLOW = 12004;
    public const DBISAMSERVER1 = 12005;
    public const DBISAMSERVER2 = 12006;
    public const ACCURACER = 12007;
    public const ACCURACER_DBMS = 12008;
    public const EDBSRVR = 12010;
    public const VIPERA = 12012;
    public const VIPERA_SSL = 12013;
    public const RETS_SSL = 12109;
    public const NUPAPER_SS = 12121;
    public const CAWAS = 12168;
    public const HIVEP = 12172;
    public const LINOGRIDENGINE = 12300;
    public const RADS = 12302;
    public const WAREHOUSE_SSS = 12321;
    public const WAREHOUSE = 12322;
    public const ITALK = 12345;
    public const TSAF = 12753;
    public const NETPERF = 12865;
    public const I_ZIPQD = 13160;
    public const BCSLOGC = 13216;
    public const RS_PIAS = 13217;
    public const EMC_VCAS_TCP = 13218;
    public const POWWOW_CLIENT = 13223;
    public const POWWOW_SERVER = 13224;
    public const DOIP_DATA = 13400;
    public const BPRD = 13720;
    public const BPDBM = 13721;
    public const BPJAVA_MSVC = 13722;
    public const VNETD = 13724;
    public const BPCD = 13782;
    public const VOPIED = 13783;
    public const NBDB = 13785;
    public const NOMDB = 13786;
    public const DSMCC_CONFIG = 13818;
    public const DSMCC_SESSION = 13819;
    public const DSMCC_PASSTHRU = 13820;
    public const DSMCC_DOWNLOAD = 13821;
    public const DSMCC_CCP = 13822;
    public const BMDSS = 13823;
    public const UCONTROL = 13894;
    public const DTA_SYSTEMS = 13929;
    public const MEDEVOLVE = 13930;
    public const SCOTTY_FT = 14000;
    public const SUA = 14001;
    public const SAGE_BEST_COM1 = 14033;
    public const SAGE_BEST_COM2 = 14034;
    public const VCS_APP = 14141;
    public const ICPP = 14142;
    public const ICPPS = 14143;
    public const GCM_APP = 14145;
    public const VRTS_TDD = 14149;
    public const VCSCMD = 14150;
    public const VAD = 14154;
    public const CPS = 14250;
    public const CA_WEB_UPDATE = 14414;
    public const XPRA = 14500;
    public const HDE_LCESRVR_1 = 14936;
    public const HDE_LCESRVR_2 = 14937;
    public const HYDAP = 15000;
    public const ONEP_TLS = 15002;
    public const XPILOT = 15345;
    public const _3LINK = 15363;
    public const CISCO_SNAT = 15555;
    public const BEX_XR = 15660;
    public const PTP = 15740;
    public const PROGRAMMAR = 15999;
    public const FMSAS = 16000;
    public const FMSASCON = 16001;
    public const GSMS = 16002;
    public const JWPC = 16020;
    public const JWPC_BIN = 16021;
    public const SUN_SEA_PORT = 16161;
    public const SOLARIS_AUDIT = 16162;
    public const ETB4J = 16309;
    public const PDUNCS = 16310;
    public const PDEFMNS = 16311;
    public const NETSERIALEXT1 = 16360;
    public const NETSERIALEXT2 = 16361;
    public const NETSERIALEXT3 = 16367;
    public const NETSERIALEXT4 = 16368;
    public const CONNECTED = 16384;
    public const RDGS = 16385;
    public const XOMS = 16619;
    public const AXON_TUNNEL = 16665;
    public const CADSISVR = 16789;
    public const NEWBAY_SNC_MC = 16900;
    public const SGCIP = 16950;
    public const INTEL_RCI_MP = 16991;
    public const AMT_SOAP_HTTP = 16992;
    public const AMT_SOAP_HTTPS = 16993;
    public const AMT_REDIR_TCP = 16994;
    public const AMT_REDIR_TLS = 16995;
    public const ISODE_DUA = 17007;
    public const VESTASDLP = 17184;
    public const SOUNDSVIRTUAL = 17185;
    public const CHIPPER = 17219;
    public const AVTP = 17220;
    public const AVDECC = 17221;
    public const ISA100_GCI = 17223;
    public const TRDP_MD = 17225;
    public const INTEGRIUS_STP = 17234;
    public const SSH_MGMT = 17235;
    public const DB_LSP = 17500;
    public const AILITH = 17555;
    public const EA = 17729;
    public const ZEP = 17754;
    public const ZIGBEE_IP = 17755;
    public const ZIGBEE_IPS = 17756;
    public const SW_ORION = 17777;
    public const BIIMENU = 18000;
    public const RADPDF = 18104;
    public const RACF = 18136;
    public const OPSEC_CVP = 18181;
    public const OPSEC_UFP = 18182;
    public const OPSEC_SAM = 18183;
    public const OPSEC_LEA = 18184;
    public const OPSEC_OMI = 18185;
    public const OHSC = 18186;
    public const OPSEC_ELA = 18187;
    public const CHECKPOINT_RTM = 18241;
    public const ICLID = 18242;
    public const CLUSTERXL = 18243;
    public const GV_PF = 18262;
    public const AC_CLUSTER = 18463;
    public const RDS_IB = 18634;
    public const RDS_IP = 18635;
    public const VDMMESH = 18668;
    public const IQUE = 18769;
    public const INFOTOS = 18881;
    public const APC_NECMP = 18888;
    public const IGRID = 19000;
    public const SCINTILLA = 19007;
    public const J_LINK = 19020;
    public const OPSEC_UAA = 19191;
    public const UA_SECUREAGENT = 19194;
    public const CORA = 19220;
    public const KEYSRVR = 19283;
    public const KEYSHADOW = 19315;
    public const MTRGTRANS = 19398;
    public const HP_SCO = 19410;
    public const HP_SCA = 19411;
    public const HP_SESSMON = 19412;
    public const FXUPTP = 19539;
    public const SXUPTP = 19540;
    public const JCP = 19541;
    public const IEC_104_SEC = 19998;
    public const DNP_SEC = 19999;
    public const DNP = 20000;
    public const MICROSAN = 20001;
    public const COMMTACT_HTTP = 20002;
    public const COMMTACT_HTTPS = 20003;
    public const OPENWEBNET = 20005;
    public const SS_IDI = 20013;
    public const OPENDEPLOY = 20014;
    public const NBURN_ID = 20034;
    public const TMOPHL7MTS = 20046;
    public const MOUNTD = 20048;
    public const NFSRDMA = 20049;
    public const AVESTERRA = 20057;
    public const TOLFAB = 20167;
    public const IPDTP_PORT = 20202;
    public const IPULSE_ICS = 20222;
    public const EMWAVEMSG = 20480;
    public const TRACK = 20670;
    public const ATHAND_MMP = 20999;
    public const IRTRANS = 21000;
    public const NOTEZILLA_LAN = 21010;
    public const TRINKET_AGENT = 21212;
    public const AIGAIRSERVER = 21221;
    public const RDM_TFS = 21553;
    public const DFSERVER = 21554;
    public const VOFR_GATEWAY = 21590;
    public const TVPM = 21800;
    public const WEBPHONE = 21845;
    public const NETSPEAK_IS = 21846;
    public const NETSPEAK_CS = 21847;
    public const NETSPEAK_ACD = 21848;
    public const NETSPEAK_CPS = 21849;
    public const SNAPENETIO = 22000;
    public const OPTOCONTROL = 22001;
    public const OPTOHOST002 = 22002;
    public const OPTOHOST003 = 22003;
    public const OPTOHOST004 = 22004;
    public const OPTOHOST004_2 = 22005;
    public const DCAP = 22125;
    public const GSIDCAP = 22128;
    public const EASYENGINE = 22222;
    public const WNN6 = 22273;
    public const CIS = 22305;
    public const SHREWD_CONTROL = 22335;
    public const CIS_SECURE = 22343;
    public const WIBUKEY = 22347;
    public const CODEMETER = 22350;
    public const CODEMETER_CMWAN = 22351;
    public const CALDSOFT_BACKUP = 22537;
    public const VOCALTEC_WCONF = 22555;
    public const TALIKASERVER = 22763;
    public const AWS_BRF = 22800;
    public const BRF_GW = 22951;
    public const INOVAPORT1 = 23000;
    public const INOVAPORT2 = 23001;
    public const INOVAPORT3 = 23002;
    public const INOVAPORT4 = 23003;
    public const INOVAPORT5 = 23004;
    public const INOVAPORT6 = 23005;
    public const GNTP = 23053;
    public const _5AFE_DIR = 23294;
    public const ELXMGMT = 23333;
    public const NOVAR_DBASE = 23400;
    public const NOVAR_ALARM = 23401;
    public const NOVAR_GLOBAL = 23402;
    public const AEQUUS = 23456;
    public const AEQUUS_ALT = 23457;
    public const AREAGUARD_NEO = 23546;
    public const MED_LTP = 24000;
    public const MED_FSP_RX = 24001;
    public const MED_FSP_TX = 24002;
    public const MED_SUPP = 24003;
    public const MED_OVW = 24004;
    public const MED_CI = 24005;
    public const MED_NET_SVC = 24006;
    public const FILESPHERE = 24242;
    public const VISTA_4GL = 24249;
    public const ILD = 24321;
    public const INTEL_RCI = 24386;
    public const TONIDODS = 24465;
    public const BINKP = 24554;
    public const BILOBIT = 24577;
    public const SDTVWCAM = 24666;
    public const CANDITV = 24676;
    public const FLASHFILER = 24677;
    public const PROACTIVATE = 24678;
    public const TCC_HTTP = 24680;
    public const CSLG = 24754;
    public const FIND = 24922;
    public const ICL_TWOBASE1 = 25000;
    public const ICL_TWOBASE2 = 25001;
    public const ICL_TWOBASE3 = 25002;
    public const ICL_TWOBASE4 = 25003;
    public const ICL_TWOBASE5 = 25004;
    public const ICL_TWOBASE6 = 25005;
    public const ICL_TWOBASE7 = 25006;
    public const ICL_TWOBASE8 = 25007;
    public const ICL_TWOBASE9 = 25008;
    public const ICL_TWOBASE10 = 25009;
    public const SAUTERDONGLE = 25576;
    public const IDTP = 25604;
    public const VOCALTEC_HOS = 25793;
    public const TASP_NET = 25900;
    public const NIOBSERVER = 25901;
    public const NILINKANALYST = 25902;
    public const NIPROBE = 25903;
    public const QUAKE = 26000;
    public const SCSCP = 26133;
    public const WNN6_DS = 26208;
    public const COCKROACH = 26257;
    public const EZPROXY = 26260;
    public const EZMEETING = 26261;
    public const K3SOFTWARE_SVR = 26262;
    public const K3SOFTWARE_CLI = 26263;
    public const EXOLINE_TCP = 26486;
    public const EXOCONFIG = 26487;
    public const EXONET = 26489;
    public const FLEX_LM = 27000;
    public const FLEX_LM_2 = 27001;
    public const FLEX_LM_3 = 27002;
    public const FLEX_LM_4 = 27003;
    public const FLEX_LM_5 = 27004;
    public const FLEX_LM_6 = 27005;
    public const FLEX_LM_7 = 27006;
    public const FLEX_LM_8 = 27007;
    public const FLEX_LM_9 = 27008;
    public const FLEX_LM_10 = 27009;
    public const IMAGEPUMP = 27345;
    public const JESMSJC = 27442;
    public const KOPEK_HTTPHEAD = 27504;
    public const ARS_VISTA = 27782;
    public const ASTROLINK = 27876;
    public const TW_AUTH_KEY = 27999;
    public const NXLMD = 28000;
    public const PQSP = 28001;
    public const VOXELSTORM = 28200;
    public const SIEMENSGSM = 28240;
    public const BOSSWAVE = 28589;
    public const OTMP = 29167;
    public const BINGBANG = 29999;
    public const NDMPS = 30000;
    public const PAGO_SERVICES1 = 30001;
    public const PAGO_SERVICES2 = 30002;
    public const AMICON_FPSU_RA = 30003;
    public const RWP = 30100;
    public const KINGDOMSONLINE = 30260;
    public const GS_REALTIME = 30400;
    public const OVOBS = 30999;
    public const KA_SDDP = 31016;
    public const AUTOTRAC_ACP = 31020;
    public const PACE_LICENSED = 31400;
    public const XQOSD = 31416;
    public const TETRINET = 31457;
    public const LM_MON = 31620;
    public const DSX_MONITOR = 31685;
    public const GAMESMITH_PORT = 31765;
    public const ICEEDCP_TX = 31948;
    public const ICEEDCP_RX = 31949;
    public const IRACINGHELPER = 32034;
    public const T1DISTPROC60 = 32249;
    public const PLEX = 32400;
    public const APM_LINK = 32483;
    public const SEC_NTB_CLNT = 32635;
    public const DMEXPRESS = 32636;
    public const FILENET_POWSRM = 32767;
    public const FILENET_TMS = 32768;
    public const FILENET_RPC = 32769;
    public const FILENET_NCH = 32770;
    public const FILENET_RMI = 32771;
    public const FILENET_PA = 32772;
    public const FILENET_CM = 32773;
    public const FILENET_RE = 32774;
    public const FILENET_PCH = 32775;
    public const FILENET_PEIOR = 32776;
    public const FILENET_OBROK = 32777;
    public const MLSN = 32801;
    public const RETP = 32811;
    public const IDMGRATM = 32896;
    public const MYSQLX = 33060;
    public const AURORA_BALAENA = 33123;
    public const DIAMONDPORT = 33331;
    public const DGI_SERV = 33333;
    public const SPEEDTRACE = 33334;
    public const TRACEROUTE = 33434;
    public const SNIP_SLAVE = 33656;
    public const TURBONOTE_2 = 34249;
    public const P_NET_LOCAL = 34378;
    public const P_NET_REMOTE = 34379;
    public const DHANALAKSHMI = 34567;
    public const PROFINET_RT = 34962;
    public const PROFINET_RTM = 34963;
    public const PROFINET_CM = 34964;
    public const ETHERCAT = 34980;
    public const HEATHVIEW = 35000;
    public const RT_VIEWER = 35001;
    public const RT_SOUND = 35002;
    public const RT_DEVICEMAPPER = 35003;
    public const RT_CLASSMANAGER = 35004;
    public const RT_LABTRACKER = 35005;
    public const RT_HELPER = 35006;
    public const AXIO_DISC = 35100;
    public const KITIM = 35354;
    public const ALTOVA_LM = 35355;
    public const GUTTERSNEX = 35356;
    public const OPENSTACK_ID = 35357;
    public const ALLPEERS = 36001;
    public const FEBOOTI_AW = 36524;
    public const OBSERVIUM_AGENT = 36602;
    public const MAPX = 36700;
    public const KASTENXPIPE = 36865;
    public const NECKAR = 37475;
    public const GDRIVE_SYNC = 37483;
    public const EFTP = 37601;
    public const UNISYS_EPORTAL = 37654;
    public const IVS_DATABASE = 38000;
    public const IVS_INSERTION = 38001;
    public const CRESCO_CONTROL = 38002;
    public const GALAXY7_DATA = 38201;
    public const FAIRVIEW = 38202;
    public const AGPOLICY = 38203;
    public const SRUTH = 38800;
    public const SECRMMSAFECOPYA = 38865;
    public const TURBONOTE_1 = 39681;
    public const SAFETYNETP = 40000;
    public const SPTX = 40404;
    public const CSCP = 40841;
    public const CSCCREDIR = 40842;
    public const CSCCFIREWALL = 40843;
    public const FS_QOS = 41111;
    public const TENTACLE = 41121;
    public const Z_WAVE_S = 41230;
    public const CRESTRON_CIP = 41794;
    public const CRESTRON_CTP = 41795;
    public const CRESTRON_CIPS = 41796;
    public const CRESTRON_CTPS = 41797;
    public const CANDP = 42508;
    public const CANDRP = 42509;
    public const CAERPC = 42510;
    public const RECVR_RC = 43000;
    public const REACHOUT = 43188;
    public const NDM_AGENT_PORT = 43189;
    public const IP_PROVISION = 43190;
    public const NOIT_TRANSPORT = 43191;
    public const SHAPERAI = 43210;
    public const EQ3_UPDATE = 43439;
    public const EW_MGMT = 43440;
    public const CISCOCSDB = 43441;
    public const Z_WAVE_TUNNEL = 44123;
    public const PMCD = 44321;
    public const PMCDPROXY = 44322;
    public const PMWEBAPI = 44323;
    public const COGNEX_DATAMAN = 44444;
    public const RBR_DEBUG = 44553;
    public const ETHERNET_IP_2 = 44818;
    public const M3DA = 44900;
    public const ASMP = 45000;
    public const ASMPS = 45001;
    public const RS_STATUS = 45002;
    public const SYNCTEST = 45045;
    public const INVISION_AG = 45054;
    public const CLOUDCHECK = 45514;
    public const EBA = 45678;
    public const DAI_SHELL = 45824;
    public const QDB2SERVICE = 45825;
    public const SSR_SERVERMGR = 45966;
    public const INEDO = 46336;
    public const SPREMOTETABLET = 46998;
    public const MEDIABOX = 46999;
    public const MBUS = 47000;
    public const WINRM = 47001;
    public const DBBROWSE = 47557;
    public const DIRECTPLAYSRVR = 47624;
    public const AP = 47806;
    public const BACNET = 47808;
    public const NIMCONTROLLER = 48000;
    public const NIMSPOOLER = 48001;
    public const NIMHUB = 48002;
    public const NIMGTW = 48003;
    public const NIMBUSDB = 48004;
    public const NIMBUSDBCTRL = 48005;
    public const _3GPP_CBSP = 48049;
    public const WEANDSF = 48050;
    public const ISNETSERV = 48128;
    public const BLP5 = 48129;
    public const COM_BARDAC_DW = 48556;
    public const IQOBJECT = 48619;
    public const ROBOTRACONTEUR = 48653;
    public const MATAHARI = 49000;
    public const NUSRP = 49001;
    public const INSPIDER = 49150;

}
