<?php declare(strict_types = 1);
/**
 * This file is part of the Dogma library (https://github.com/paranoiq/dogma)
 *
 * Copyright (c) 2012 Vlasta Neubauer (@paranoiq)
 *
 * For the full copyright and license information read the file 'license.md', distributed with this source code
 */

namespace Dogma\System\Error;

use Dogma\Enum\IntEnum;
use Dogma\Re;
use function str_replace;
use function strtolower;
use function ucfirst;

/**
 * Windows system errors (@see http://msdn.microsoft.com/en-us/library/windows/desktop/ms681382(v=vs.85).aspx)
 */
class WindowsError extends IntEnum implements SystemError
{

    public const ERROR_SUCCESS = 0;
    public const ERROR_INVALID_FUNCTION = 1;
    public const ERROR_FILE_NOT_FOUND = 2;
    public const ERROR_PATH_NOT_FOUND = 3;
    public const ERROR_TOO_MANY_OPEN_FILES = 4;
    public const ERROR_ACCESS_DENIED = 5;
    public const ERROR_INVALID_HANDLE = 6;
    public const ERROR_ARENA_TRASHED = 7;
    public const ERROR_NOT_ENOUGH_MEMORY = 8;
    public const ERROR_INVALID_BLOCK = 9;
    public const ERROR_BAD_ENVIRONMENT = 10;
    public const ERROR_BAD_FORMAT = 11;
    public const ERROR_INVALID_ACCESS = 12;
    public const ERROR_INVALID_DATA = 13;
    public const ERROR_OUT_OF_MEMORY = 14;
    public const ERROR_INVALID_DRIVE = 15;
    public const ERROR_CURRENT_DIRECTORY = 16;
    public const ERROR_NOT_SAME_DEVICE = 17;
    public const ERROR_NO_MORE_FILES = 18;
    public const ERROR_WRITE_PROTECT = 19;
    public const ERROR_BAD_UNIT = 20;
    public const ERROR_NOT_READY = 21;
    public const ERROR_BAD_COMMAND = 22;
    public const ERROR_CRC = 23;
    public const ERROR_BAD_LENGTH = 24;
    public const ERROR_SEEK = 25;
    public const ERROR_NOT_DOS_DISK = 26;
    public const ERROR_SECTOR_NOT_FOUND = 27;
    public const ERROR_OUT_OF_PAPER = 28;
    public const ERROR_WRITE_FAULT = 29;
    public const ERROR_READ_FAULT = 30;
    public const ERROR_GEN_FAILURE = 31;
    public const ERROR_SHARING_VIOLATION = 32;
    public const ERROR_LOCK_VIOLATION = 33;
    public const ERROR_WRONG_DISK = 34;
    public const ERROR_SHARING_BUFFER_EXCEEDED = 36;
    public const ERROR_HANDLE_EOF = 38;
    public const ERROR_HANDLE_DISK_FULL = 39;
    public const ERROR_NOT_SUPPORTED = 50;
    public const ERROR_REM_NOT_LIST = 51;
    public const ERROR_DUP_NAME = 52;
    public const ERROR_BAD_NETPATH = 53;
    public const ERROR_NETWORK_BUSY = 54;
    public const ERROR_DEV_NOT_EXIST = 55;
    public const ERROR_TOO_MANY_CMDS = 56;
    public const ERROR_ADAP_HDW_ERR = 57;
    public const ERROR_BAD_NET_RESP = 58;
    public const ERROR_UNEXP_NET_ERR = 59;
    public const ERROR_BAD_REM_ADAP = 60;
    public const ERROR_PRINTQ_FULL = 61;
    public const ERROR_NO_SPOOL_SPACE = 62;
    public const ERROR_PRINT_CANCELLED = 63;
    public const ERROR_NETNAME_DELETED = 64;
    public const ERROR_NETWORK_ACCESS_DENIED = 65;
    public const ERROR_BAD_DEV_TYPE = 66;
    public const ERROR_BAD_NET_NAME = 67;
    public const ERROR_TOO_MANY_NAMES = 68;
    public const ERROR_TOO_MANY_SESS = 69;
    public const ERROR_SHARING_PAUSED = 70;
    public const ERROR_REQ_NOT_ACCEP = 71;
    public const ERROR_REDIR_PAUSED = 72;
    public const ERROR_FILE_EXISTS = 80;
    public const ERROR_CANNOT_MAKE = 82;
    public const ERROR_FAIL_I24 = 83;
    public const ERROR_OUT_OF_STRUCTURES = 84;
    public const ERROR_ALREADY_ASSIGNED = 85;
    public const ERROR_INVALID_PASSWORD = 86;
    public const ERROR_INVALID_PARAMETER = 87;
    public const ERROR_NET_WRITE_FAULT = 88;
    public const ERROR_NO_PROC_SLOTS = 89;
    public const ERROR_TOO_MANY_SEMAPHORES = 100;
    public const ERROR_EXCL_SEM_ALREADY_OWNED = 101;
    public const ERROR_SEM_IS_SET = 102;
    public const ERROR_TOO_MANY_SEM_REQUESTS = 103;
    public const ERROR_INVALID_AT_INTERRUPT_TIME = 104;
    public const ERROR_SEM_OWNER_DIED = 105;
    public const ERROR_SEM_USER_LIMIT = 106;
    public const ERROR_DISK_CHANGE = 107;
    public const ERROR_DRIVE_LOCKED = 108;
    public const ERROR_BROKEN_PIPE = 109;
    public const ERROR_OPEN_FAILED = 110;
    public const ERROR_BUFFER_OVERFLOW = 111;
    public const ERROR_DISK_FULL = 112;
    public const ERROR_NO_MORE_SEARCH_HANDLES = 113;
    public const ERROR_INVALID_TARGET_HANDLE = 114;
    public const ERROR_INVALID_CATEGORY = 117;
    public const ERROR_INVALID_VERIFY_SWITCH = 118;
    public const ERROR_BAD_DRIVER_LEVEL = 119;
    public const ERROR_CALL_NOT_IMPLEMENTED = 120;
    public const ERROR_SEM_TIMEOUT = 121;
    public const ERROR_INSUFFICIENT_BUFFER = 122;
    public const ERROR_INVALID_NAME = 123;
    public const ERROR_INVALID_LEVEL = 124;
    public const ERROR_NO_VOLUME_LABEL = 125;
    public const ERROR_MOD_NOT_FOUND = 126;
    public const ERROR_PROC_NOT_FOUND = 127;
    public const ERROR_WAIT_NO_CHILDREN = 128;
    public const ERROR_CHILD_NOT_COMPLETE = 129;
    public const ERROR_DIRECT_ACCESS_HANDLE = 130;
    public const ERROR_NEGATIVE_SEEK = 131;
    public const ERROR_SEEK_ON_DEVICE = 132;
    public const ERROR_IS_JOIN_TARGET = 133;
    public const ERROR_IS_JOINED = 134;
    public const ERROR_IS_SUBSTED = 135;
    public const ERROR_NOT_JOINED = 136;
    public const ERROR_NOT_SUBSTED = 137;
    public const ERROR_JOIN_TO_JOIN = 138;
    public const ERROR_SUBST_TO_SUBST = 139;
    public const ERROR_JOIN_TO_SUBST = 140;
    public const ERROR_SUBST_TO_JOIN = 141;
    public const ERROR_BUSY_DRIVE = 142;
    public const ERROR_SAME_DRIVE = 143;
    public const ERROR_DIR_NOT_ROOT = 144;
    public const ERROR_DIR_NOT_EMPTY = 145;
    public const ERROR_IS_SUBST_PATH = 146;
    public const ERROR_IS_JOIN_PATH = 147;
    public const ERROR_PATH_BUSY = 148;
    public const ERROR_IS_SUBST_TARGET = 149;
    public const ERROR_SYSTEM_TRACE = 150;
    public const ERROR_INVALID_EVENT_COUNT = 151;
    public const ERROR_TOO_MANY_MUXWAITERS = 152;
    public const ERROR_INVALID_LIST_FORMAT = 153;
    public const ERROR_LABEL_TOO_LONG = 154;
    public const ERROR_TOO_MANY_TCBS = 155;
    public const ERROR_SIGNAL_REFUSED = 156;
    public const ERROR_DISCARDED = 157;
    public const ERROR_NOT_LOCKED = 158;
    public const ERROR_BAD_THREADID_ADDR = 159;
    public const ERROR_BAD_ARGUMENTS = 160;
    public const ERROR_BAD_PATHNAME = 161;
    public const ERROR_SIGNAL_PENDING = 162;
    public const ERROR_MAX_THRDS_REACHED = 164;
    public const ERROR_LOCK_FAILED = 167;
    public const ERROR_BUSY = 170;
    public const ERROR_DEVICE_SUPPORT_IN_PROGRESS = 171;
    public const ERROR_CANCEL_VIOLATION = 173;
    public const ERROR_ATOMIC_LOCKS_NOT_SUPPORTED = 174;
    public const ERROR_INVALID_SEGMENT_NUMBER = 180;
    public const ERROR_INVALID_ORDINAL = 182;
    public const ERROR_ALREADY_EXISTS = 183;
    public const ERROR_INVALID_FLAG_NUMBER = 186;
    public const ERROR_SEM_NOT_FOUND = 187;
    public const ERROR_INVALID_STARTING_CODESEG = 188;
    public const ERROR_INVALID_STACKSEG = 189;
    public const ERROR_INVALID_MODULETYPE = 190;
    public const ERROR_INVALID_EXE_SIGNATURE = 191;
    public const ERROR_EXE_MARKED_INVALID = 192;
    public const ERROR_BAD_EXE_FORMAT = 193;
    public const ERROR_ITERATED_DATA_EXCEEDS_64K = 194;
    public const ERROR_INVALID_MINALLOCSIZE = 195;
    public const ERROR_DYNLINK_FROM_INVALID_RING = 196;
    public const ERROR_IOPL_NOT_ENABLED = 197;
    public const ERROR_INVALID_SEGDPL = 198;
    public const ERROR_AUTODATASEG_EXCEEDS_64K = 199;
    public const ERROR_RING2SEG_MUST_BE_MOVABLE = 200;
    public const ERROR_RELOC_CHAIN_XEEDS_SEGLIM = 201;
    public const ERROR_INFLOOP_IN_RELOC_CHAIN = 202;
    public const ERROR_ENVVAR_NOT_FOUND = 203;
    public const ERROR_NO_SIGNAL_SENT = 205;
    public const ERROR_FILENAME_EXCED_RANGE = 206;
    public const ERROR_RING2_STACK_IN_USE = 207;
    public const ERROR_META_EXPANSION_TOO_LONG = 208;
    public const ERROR_INVALID_SIGNAL_NUMBER = 209;
    public const ERROR_THREAD_1_INACTIVE = 210;
    public const ERROR_LOCKED = 212;
    public const ERROR_TOO_MANY_MODULES = 214;
    public const ERROR_NESTING_NOT_ALLOWED = 215;
    public const ERROR_EXE_MACHINE_TYPE_MISMATCH = 216;
    public const ERROR_EXE_CANNOT_MODIFY_SIGNED_BINARY = 217;
    public const ERROR_EXE_CANNOT_MODIFY_STRONG_SIGNED_BINARY = 218;
    public const ERROR_FILE_CHECKED_OUT = 220;
    public const ERROR_CHECKOUT_REQUIRED = 221;
    public const ERROR_BAD_FILE_TYPE = 222;
    public const ERROR_FILE_TOO_LARGE = 223;
    public const ERROR_FORMS_AUTH_REQUIRED = 224;
    public const ERROR_VIRUS_INFECTED = 225;
    public const ERROR_VIRUS_DELETED = 226;
    public const ERROR_PIPE_LOCAL = 229;
    public const ERROR_BAD_PIPE = 230;
    public const ERROR_PIPE_BUSY = 231;
    public const ERROR_NO_DATA = 232;
    public const ERROR_PIPE_NOT_CONNECTED = 233;
    public const ERROR_MORE_DATA = 234;
    public const ERROR_VC_DISCONNECTED = 240;
    public const ERROR_INVALID_EA_NAME = 254;
    public const ERROR_EA_LIST_INCONSISTENT = 255;
    public const WAIT_TIMEOUT = 258;
    public const ERROR_NO_MORE_ITEMS = 259;
    public const ERROR_CANNOT_COPY = 266;
    public const ERROR_DIRECTORY = 267;
    public const ERROR_EAS_DIDNT_FIT = 275;
    public const ERROR_EA_FILE_CORRUPT = 276;
    public const ERROR_EA_TABLE_FULL = 277;
    public const ERROR_INVALID_EA_HANDLE = 278;
    public const ERROR_EAS_NOT_SUPPORTED = 282;
    public const ERROR_NOT_OWNER = 288;
    public const ERROR_TOO_MANY_POSTS = 298;
    public const ERROR_PARTIAL_COPY = 299;
    public const ERROR_OPLOCK_NOT_GRANTED = 300;
    public const ERROR_INVALID_OPLOCK_PROTOCOL = 301;
    public const ERROR_DISK_TOO_FRAGMENTED = 302;
    public const ERROR_DELETE_PENDING = 303;
    public const ERROR_INCOMPATIBLE_WITH_GLOBAL_SHORT_NAME_REGISTRY_SETTING = 304;
    public const ERROR_SHORT_NAMES_NOT_ENABLED_ON_VOLUME = 305;
    public const ERROR_SECURITY_STREAM_IS_INCONSISTENT = 306;
    public const ERROR_INVALID_LOCK_RANGE = 307;
    public const ERROR_IMAGE_SUBSYSTEM_NOT_PRESENT = 308;
    public const ERROR_NOTIFICATION_GUID_ALREADY_DEFINED = 309;
    public const ERROR_INVALID_EXCEPTION_HANDLER = 310;
    public const ERROR_DUPLICATE_PRIVILEGES = 311;
    public const ERROR_NO_RANGES_PROCESSED = 312;
    public const ERROR_NOT_ALLOWED_ON_SYSTEM_FILE = 313;
    public const ERROR_DISK_RESOURCES_EXHAUSTED = 314;
    public const ERROR_INVALID_TOKEN = 315;
    public const ERROR_DEVICE_FEATURE_NOT_SUPPORTED = 316;
    public const ERROR_MR_MID_NOT_FOUND = 317;
    public const ERROR_SCOPE_NOT_FOUND = 318;
    public const ERROR_UNDEFINED_SCOPE = 319;
    public const ERROR_INVALID_CAP = 320;
    public const ERROR_DEVICE_UNREACHABLE = 321;
    public const ERROR_DEVICE_NO_RESOURCES = 322;
    public const ERROR_DATA_CHECKSUM_ERROR = 323;
    public const ERROR_INTERMIXED_KERNEL_EA_OPERATION = 324;
    public const ERROR_FILE_LEVEL_TRIM_NOT_SUPPORTED = 326;
    public const ERROR_OFFSET_ALIGNMENT_VIOLATION = 327;
    public const ERROR_INVALID_FIELD_IN_PARAMETER_LIST = 328;
    public const ERROR_OPERATION_IN_PROGRESS = 329;
    public const ERROR_BAD_DEVICE_PATH = 330;
    public const ERROR_TOO_MANY_DESCRIPTORS = 331;
    public const ERROR_SCRUB_DATA_DISABLED = 332;
    public const ERROR_NOT_REDUNDANT_STORAGE = 333;
    public const ERROR_RESIDENT_FILE_NOT_SUPPORTED = 334;
    public const ERROR_COMPRESSED_FILE_NOT_SUPPORTED = 335;
    public const ERROR_DIRECTORY_NOT_SUPPORTED = 336;
    public const ERROR_NOT_READ_FROM_COPY = 337;
    public const ERROR_FAIL_NOACTION_REBOOT = 350;
    public const ERROR_FAIL_SHUTDOWN = 351;
    public const ERROR_FAIL_RESTART = 352;
    public const ERROR_MAX_SESSIONS_REACHED = 353;
    public const ERROR_THREAD_MODE_ALREADY_BACKGROUND = 400;
    public const ERROR_THREAD_MODE_NOT_BACKGROUND = 401;
    public const ERROR_PROCESS_MODE_ALREADY_BACKGROUND = 402;
    public const ERROR_PROCESS_MODE_NOT_BACKGROUND = 403;
    public const ERROR_INVALID_ADDRESS = 487;
    public const ERROR_USER_PROFILE_LOAD = 500;
    public const ERROR_ARITHMETIC_OVERFLOW = 534;
    public const ERROR_PIPE_CONNECTED = 535;
    public const ERROR_PIPE_LISTENING = 536;
    public const ERROR_VERIFIER_STOP = 537;
    public const ERROR_ABIOS_ERROR = 538;
    public const ERROR_WX86_WARNING = 539;
    public const ERROR_WX86_ERROR = 540;
    public const ERROR_TIMER_NOT_CANCELED = 541;
    public const ERROR_UNWIND = 542;
    public const ERROR_BAD_STACK = 543;
    public const ERROR_INVALID_UNWIND_TARGET = 544;
    public const ERROR_INVALID_PORT_ATTRIBUTES = 545;
    public const ERROR_PORT_MESSAGE_TOO_LONG = 546;
    public const ERROR_INVALID_QUOTA_LOWER = 547;
    public const ERROR_DEVICE_ALREADY_ATTACHED = 548;
    public const ERROR_INSTRUCTION_MISALIGNMENT = 549;
    public const ERROR_PROFILING_NOT_STARTED = 550;
    public const ERROR_PROFILING_NOT_STOPPED = 551;
    public const ERROR_COULD_NOT_INTERPRET = 552;
    public const ERROR_PROFILING_AT_LIMIT = 553;
    public const ERROR_CANT_WAIT = 554;
    public const ERROR_CANT_TERMINATE_SELF = 555;
    public const ERROR_UNEXPECTED_MM_CREATE_ERR = 556;
    public const ERROR_UNEXPECTED_MM_MAP_ERROR = 557;
    public const ERROR_UNEXPECTED_MM_EXTEND_ERR = 558;
    public const ERROR_BAD_FUNCTION_TABLE = 559;
    public const ERROR_NO_GUID_TRANSLATION = 560;
    public const ERROR_INVALID_LDT_SIZE = 561;
    public const ERROR_INVALID_LDT_OFFSET = 563;
    public const ERROR_INVALID_LDT_DESCRIPTOR = 564;
    public const ERROR_TOO_MANY_THREADS = 565;
    public const ERROR_THREAD_NOT_IN_PROCESS = 566;
    public const ERROR_PAGEFILE_QUOTA_EXCEEDED = 567;
    public const ERROR_LOGON_SERVER_CONFLICT = 568;
    public const ERROR_SYNCHRONIZATION_REQUIRED = 569;
    public const ERROR_NET_OPEN_FAILED = 570;
    public const ERROR_IO_PRIVILEGE_FAILED = 571;
    public const ERROR_CONTROL_C_EXIT = 572;
    public const ERROR_MISSING_SYSTEMFILE = 573;
    public const ERROR_UNHANDLED_EXCEPTION = 574;
    public const ERROR_APP_INIT_FAILURE = 575;
    public const ERROR_PAGEFILE_CREATE_FAILED = 576;
    public const ERROR_INVALID_IMAGE_HASH = 577;
    public const ERROR_NO_PAGEFILE = 578;
    public const ERROR_ILLEGAL_FLOAT_CONTEXT = 579;
    public const ERROR_NO_EVENT_PAIR = 580;
    public const ERROR_DOMAIN_CTRLR_CONFIG_ERROR = 581;
    public const ERROR_ILLEGAL_CHARACTER = 582;
    public const ERROR_UNDEFINED_CHARACTER = 583;
    public const ERROR_FLOPPY_VOLUME = 584;
    public const ERROR_BIOS_FAILED_TO_CONNECT_INTERRUPT = 585;
    public const ERROR_BACKUP_CONTROLLER = 586;
    public const ERROR_MUTANT_LIMIT_EXCEEDED = 587;
    public const ERROR_FS_DRIVER_REQUIRED = 588;
    public const ERROR_CANNOT_LOAD_REGISTRY_FILE = 589;
    public const ERROR_DEBUG_ATTACH_FAILED = 590;
    public const ERROR_SYSTEM_PROCESS_TERMINATED = 591;
    public const ERROR_DATA_NOT_ACCEPTED = 592;
    public const ERROR_VDM_HARD_ERROR = 593;
    public const ERROR_DRIVER_CANCEL_TIMEOUT = 594;
    public const ERROR_REPLY_MESSAGE_MISMATCH = 595;
    public const ERROR_LOST_WRITEBEHIND_DATA = 596;
    public const ERROR_CLIENT_SERVER_PARAMETERS_INVALID = 597;
    public const ERROR_NOT_TINY_STREAM = 598;
    public const ERROR_STACK_OVERFLOW_READ = 599;
    public const ERROR_CONVERT_TO_LARGE = 600;
    public const ERROR_FOUND_OUT_OF_SCOPE = 601;
    public const ERROR_ALLOCATE_BUCKET = 602;
    public const ERROR_MARSHALL_OVERFLOW = 603;
    public const ERROR_INVALID_VARIANT = 604;
    public const ERROR_BAD_COMPRESSION_BUFFER = 605;
    public const ERROR_AUDIT_FAILED = 606;
    public const ERROR_TIMER_RESOLUTION_NOT_SET = 607;
    public const ERROR_INSUFFICIENT_LOGON_INFO = 608;
    public const ERROR_BAD_DLL_ENTRYPOINT = 609;
    public const ERROR_BAD_SERVICE_ENTRYPOINT = 610;
    public const ERROR_IP_ADDRESS_CONFLICT1 = 611;
    public const ERROR_IP_ADDRESS_CONFLICT2 = 612;
    public const ERROR_REGISTRY_QUOTA_LIMIT = 613;
    public const ERROR_NO_CALLBACK_ACTIVE = 614;
    public const ERROR_PWD_TOO_SHORT = 615;
    public const ERROR_PWD_TOO_RECENT = 616;
    public const ERROR_PWD_HISTORY_CONFLICT = 617;
    public const ERROR_UNSUPPORTED_COMPRESSION = 618;
    public const ERROR_INVALID_HW_PROFILE = 619;
    public const ERROR_INVALID_PLUGPLAY_DEVICE_PATH = 620;
    public const ERROR_QUOTA_LIST_INCONSISTENT = 621;
    public const ERROR_EVALUATION_EXPIRATION = 622;
    public const ERROR_ILLEGAL_DLL_RELOCATION = 623;
    public const ERROR_DLL_INIT_FAILED_LOGOFF = 624;
    public const ERROR_VALIDATE_CONTINUE = 625;
    public const ERROR_NO_MORE_MATCHES = 626;
    public const ERROR_RANGE_LIST_CONFLICT = 627;
    public const ERROR_SERVER_SID_MISMATCH = 628;
    public const ERROR_CANT_ENABLE_DENY_ONLY = 629;
    public const ERROR_FLOAT_MULTIPLE_FAULTS = 630;
    public const ERROR_FLOAT_MULTIPLE_TRAPS = 631;
    public const ERROR_NOINTERFACE = 632;
    public const ERROR_DRIVER_FAILED_SLEEP = 633;
    public const ERROR_CORRUPT_SYSTEM_FILE = 634;
    public const ERROR_COMMITMENT_MINIMUM = 635;
    public const ERROR_PNP_RESTART_ENUMERATION = 636;
    public const ERROR_SYSTEM_IMAGE_BAD_SIGNATURE = 637;
    public const ERROR_PNP_REBOOT_REQUIRED = 638;
    public const ERROR_INSUFFICIENT_POWER = 639;
    public const ERROR_MULTIPLE_FAULT_VIOLATION = 640;
    public const ERROR_SYSTEM_SHUTDOWN = 641;
    public const ERROR_PORT_NOT_SET = 642;
    public const ERROR_DS_VERSION_CHECK_FAILURE = 643;
    public const ERROR_RANGE_NOT_FOUND = 644;
    public const ERROR_NOT_SAFE_MODE_DRIVER = 646;
    public const ERROR_FAILED_DRIVER_ENTRY = 647;
    public const ERROR_DEVICE_ENUMERATION_ERROR = 648;
    public const ERROR_MOUNT_POINT_NOT_RESOLVED = 649;
    public const ERROR_INVALID_DEVICE_OBJECT_PARAMETER = 650;
    public const ERROR_MCA_OCCURED = 651;
    public const ERROR_DRIVER_DATABASE_ERROR = 652;
    public const ERROR_SYSTEM_HIVE_TOO_LARGE = 653;
    public const ERROR_DRIVER_FAILED_PRIOR_UNLOAD = 654;
    public const ERROR_VOLSNAP_PREPARE_HIBERNATE = 655;
    public const ERROR_HIBERNATION_FAILURE = 656;
    public const ERROR_PWD_TOO_LONG = 657;
    public const ERROR_FILE_SYSTEM_LIMITATION = 665;
    public const ERROR_ASSERTION_FAILURE = 668;
    public const ERROR_ACPI_ERROR = 669;
    public const ERROR_WOW_ASSERTION = 670;
    public const ERROR_PNP_BAD_MPS_TABLE = 671;
    public const ERROR_PNP_TRANSLATION_FAILED = 672;
    public const ERROR_PNP_IRQ_TRANSLATION_FAILED = 673;
    public const ERROR_PNP_INVALID_ID = 674;
    public const ERROR_WAKE_SYSTEM_DEBUGGER = 675;
    public const ERROR_HANDLES_CLOSED = 676;
    public const ERROR_EXTRANEOUS_INFORMATION = 677;
    public const ERROR_RXACT_COMMIT_NECESSARY = 678;
    public const ERROR_MEDIA_CHECK = 679;
    public const ERROR_GUID_SUBSTITUTION_MADE = 680;
    public const ERROR_STOPPED_ON_SYMLINK = 681;
    public const ERROR_LONGJUMP = 682;
    public const ERROR_PLUGPLAY_QUERY_VETOED = 683;
    public const ERROR_UNWIND_CONSOLIDATE = 684;
    public const ERROR_REGISTRY_HIVE_RECOVERED = 685;
    public const ERROR_DLL_MIGHT_BE_INSECURE = 686;
    public const ERROR_DLL_MIGHT_BE_INCOMPATIBLE = 687;
    public const ERROR_DBG_EXCEPTION_NOT_HANDLED = 688;
    public const ERROR_DBG_REPLY_LATER = 689;
    public const ERROR_DBG_UNABLE_TO_PROVIDE_HANDLE = 690;
    public const ERROR_DBG_TERMINATE_THREAD = 691;
    public const ERROR_DBG_TERMINATE_PROCESS = 692;
    public const ERROR_DBG_CONTROL_C = 693;
    public const ERROR_DBG_PRINTEXCEPTION_C = 694;
    public const ERROR_DBG_RIPEXCEPTION = 695;
    public const ERROR_DBG_CONTROL_BREAK = 696;
    public const ERROR_DBG_COMMAND_EXCEPTION = 697;
    public const ERROR_OBJECT_NAME_EXISTS = 698;
    public const ERROR_THREAD_WAS_SUSPENDED = 699;
    public const ERROR_IMAGE_NOT_AT_BASE = 700;
    public const ERROR_RXACT_STATE_CREATED = 701;
    public const ERROR_SEGMENT_NOTIFICATION = 702;
    public const ERROR_BAD_CURRENT_DIRECTORY = 703;
    public const ERROR_FT_READ_RECOVERY_FROM_BACKUP = 704;
    public const ERROR_FT_WRITE_RECOVERY = 705;
    public const ERROR_IMAGE_MACHINE_TYPE_MISMATCH = 706;
    public const ERROR_RECEIVE_PARTIAL = 707;
    public const ERROR_RECEIVE_EXPEDITED = 708;
    public const ERROR_RECEIVE_PARTIAL_EXPEDITED = 709;
    public const ERROR_EVENT_DONE = 710;
    public const ERROR_EVENT_PENDING = 711;
    public const ERROR_CHECKING_FILE_SYSTEM = 712;
    public const ERROR_FATAL_APP_EXIT = 713;
    public const ERROR_PREDEFINED_HANDLE = 714;
    public const ERROR_WAS_UNLOCKED = 715;
    public const ERROR_SERVICE_NOTIFICATION = 716;
    public const ERROR_WAS_LOCKED = 717;
    public const ERROR_LOG_HARD_ERROR = 718;
    public const ERROR_ALREADY_WIN32 = 719;
    public const ERROR_IMAGE_MACHINE_TYPE_MISMATCH_EXE = 720;
    public const ERROR_NO_YIELD_PERFORMED = 721;
    public const ERROR_TIMER_RESUME_IGNORED = 722;
    public const ERROR_ARBITRATION_UNHANDLED = 723;
    public const ERROR_CARDBUS_NOT_SUPPORTED = 724;
    public const ERROR_MP_PROCESSOR_MISMATCH = 725;
    public const ERROR_HIBERNATED = 726;
    public const ERROR_RESUME_HIBERNATION = 727;
    public const ERROR_FIRMWARE_UPDATED = 728;
    public const ERROR_DRIVERS_LEAKING_LOCKED_PAGES = 729;
    public const ERROR_WAKE_SYSTEM = 730;
    public const ERROR_WAIT_1 = 731;
    public const ERROR_WAIT_2 = 732;
    public const ERROR_WAIT_3 = 733;
    public const ERROR_WAIT_63 = 734;
    public const ERROR_ABANDONED_WAIT_0 = 735;
    public const ERROR_ABANDONED_WAIT_63 = 736;
    public const ERROR_USER_APC = 737;
    public const ERROR_KERNEL_APC = 738;
    public const ERROR_ALERTED = 739;
    public const ERROR_ELEVATION_REQUIRED = 740;
    public const ERROR_REPARSE = 741;
    public const ERROR_OPLOCK_BREAK_IN_PROGRESS = 742;
    public const ERROR_VOLUME_MOUNTED = 743;
    public const ERROR_RXACT_COMMITTED = 744;
    public const ERROR_NOTIFY_CLEANUP = 745;
    public const ERROR_PRIMARY_TRANSPORT_CONNECT_FAILED = 746;
    public const ERROR_PAGE_FAULT_TRANSITION = 747;
    public const ERROR_PAGE_FAULT_DEMAND_ZERO = 748;
    public const ERROR_PAGE_FAULT_COPY_ON_WRITE = 749;
    public const ERROR_PAGE_FAULT_GUARD_PAGE = 750;
    public const ERROR_PAGE_FAULT_PAGING_FILE = 751;
    public const ERROR_CACHE_PAGE_LOCKED = 752;
    public const ERROR_CRASH_DUMP = 753;
    public const ERROR_BUFFER_ALL_ZEROS = 754;
    public const ERROR_REPARSE_OBJECT = 755;
    public const ERROR_RESOURCE_REQUIREMENTS_CHANGED = 756;
    public const ERROR_TRANSLATION_COMPLETE = 757;
    public const ERROR_NOTHING_TO_TERMINATE = 758;
    public const ERROR_PROCESS_NOT_IN_JOB = 759;
    public const ERROR_PROCESS_IN_JOB = 760;
    public const ERROR_VOLSNAP_HIBERNATE_READY = 761;
    public const ERROR_FSFILTER_OP_COMPLETED_SUCCESSFULLY = 762;
    public const ERROR_INTERRUPT_VECTOR_ALREADY_CONNECTED = 763;
    public const ERROR_INTERRUPT_STILL_CONNECTED = 764;
    public const ERROR_WAIT_FOR_OPLOCK = 765;
    public const ERROR_DBG_EXCEPTION_HANDLED = 766;
    public const ERROR_DBG_CONTINUE = 767;
    public const ERROR_CALLBACK_POP_STACK = 768;
    public const ERROR_COMPRESSION_DISABLED = 769;
    public const ERROR_CANTFETCHBACKWARDS = 770;
    public const ERROR_CANTSCROLLBACKWARDS = 771;
    public const ERROR_ROWSNOTRELEASED = 772;
    public const ERROR_BAD_ACCESSOR_FLAGS = 773;
    public const ERROR_ERRORS_ENCOUNTERED = 774;
    public const ERROR_NOT_CAPABLE = 775;
    public const ERROR_REQUEST_OUT_OF_SEQUENCE = 776;
    public const ERROR_VERSION_PARSE_ERROR = 777;
    public const ERROR_BADSTARTPOSITION = 778;
    public const ERROR_MEMORY_HARDWARE = 779;
    public const ERROR_DISK_REPAIR_DISABLED = 780;
    public const ERROR_INSUFFICIENT_RESOURCE_FOR_SPECIFIED_SHARED_SECTION_SIZE = 781;
    public const ERROR_SYSTEM_POWERSTATE_TRANSITION = 782;
    public const ERROR_SYSTEM_POWERSTATE_COMPLEX_TRANSITION = 783;
    public const ERROR_MCA_EXCEPTION = 784;
    public const ERROR_ACCESS_AUDIT_BY_POLICY = 785;
    public const ERROR_ACCESS_DISABLED_NO_SAFER_UI_BY_POLICY = 786;
    public const ERROR_ABANDON_HIBERFILE = 787;
    public const ERROR_LOST_WRITEBEHIND_DATA_NETWORK_DISCONNECTED = 788;
    public const ERROR_LOST_WRITEBEHIND_DATA_NETWORK_SERVER_ERROR = 789;
    public const ERROR_LOST_WRITEBEHIND_DATA_LOCAL_DISK_ERROR = 790;
    public const ERROR_BAD_MCFG_TABLE = 791;
    public const ERROR_DISK_REPAIR_REDIRECTED = 792;
    public const ERROR_DISK_REPAIR_UNSUCCESSFUL = 793;
    public const ERROR_CORRUPT_LOG_OVERFULL = 794;
    public const ERROR_CORRUPT_LOG_CORRUPTED = 795;
    public const ERROR_CORRUPT_LOG_UNAVAILABLE = 796;
    public const ERROR_CORRUPT_LOG_DELETED_FULL = 797;
    public const ERROR_CORRUPT_LOG_CLEARED = 798;
    public const ERROR_ORPHAN_NAME_EXHAUSTED = 799;
    public const ERROR_OPLOCK_SWITCHED_TO_NEW_HANDLE = 800;
    public const ERROR_CANNOT_GRANT_REQUESTED_OPLOCK = 801;
    public const ERROR_CANNOT_BREAK_OPLOCK = 802;
    public const ERROR_OPLOCK_HANDLE_CLOSED = 803;
    public const ERROR_NO_ACE_CONDITION = 804;
    public const ERROR_INVALID_ACE_CONDITION = 805;
    public const ERROR_FILE_HANDLE_REVOKED = 806;
    public const ERROR_IMAGE_AT_DIFFERENT_BASE = 807;
    public const ERROR_EA_ACCESS_DENIED = 994;
    public const ERROR_OPERATION_ABORTED = 995;
    public const ERROR_IO_INCOMPLETE = 996;
    public const ERROR_IO_PENDING = 997;
    public const ERROR_NOACCESS = 998;
    public const ERROR_SWAPERROR = 999;
    public const ERROR_STACK_OVERFLOW = 1001;
    public const ERROR_INVALID_MESSAGE = 1002;
    public const ERROR_CAN_NOT_COMPLETE = 1003;
    public const ERROR_INVALID_FLAGS = 1004;
    public const ERROR_UNRECOGNIZED_VOLUME = 1005;
    public const ERROR_FILE_INVALID = 1006;
    public const ERROR_FULLSCREEN_MODE = 1007;
    public const ERROR_NO_TOKEN = 1008;
    public const ERROR_BADDB = 1009;
    public const ERROR_BADKEY = 1010;
    public const ERROR_CANTOPEN = 1011;
    public const ERROR_CANTREAD = 1012;
    public const ERROR_CANTWRITE = 1013;
    public const ERROR_REGISTRY_RECOVERED = 1014;
    public const ERROR_REGISTRY_CORRUPT = 1015;
    public const ERROR_REGISTRY_IO_FAILED = 1016;
    public const ERROR_NOT_REGISTRY_FILE = 1017;
    public const ERROR_KEY_DELETED = 1018;
    public const ERROR_NO_LOG_SPACE = 1019;
    public const ERROR_KEY_HAS_CHILDREN = 1020;
    public const ERROR_CHILD_MUST_BE_VOLATILE = 1021;
    public const ERROR_NOTIFY_ENUM_DIR = 1022;
    public const ERROR_DEPENDENT_SERVICES_RUNNING = 1051;
    public const ERROR_INVALID_SERVICE_CONTROL = 1052;
    public const ERROR_SERVICE_REQUEST_TIMEOUT = 1053;
    public const ERROR_SERVICE_NO_THREAD = 1054;
    public const ERROR_SERVICE_DATABASE_LOCKED = 1055;
    public const ERROR_SERVICE_ALREADY_RUNNING = 1056;
    public const ERROR_INVALID_SERVICE_ACCOUNT = 1057;
    public const ERROR_SERVICE_DISABLED = 1058;
    public const ERROR_CIRCULAR_DEPENDENCY = 1059;
    public const ERROR_SERVICE_DOES_NOT_EXIST = 1060;
    public const ERROR_SERVICE_CANNOT_ACCEPT_CTRL = 1061;
    public const ERROR_SERVICE_NOT_ACTIVE = 1062;
    public const ERROR_FAILED_SERVICE_CONTROLLER_CONNECT = 1063;
    public const ERROR_EXCEPTION_IN_SERVICE = 1064;
    public const ERROR_DATABASE_DOES_NOT_EXIST = 1065;
    public const ERROR_SERVICE_SPECIFIC_ERROR = 1066;
    public const ERROR_PROCESS_ABORTED = 1067;
    public const ERROR_SERVICE_DEPENDENCY_FAIL = 1068;
    public const ERROR_SERVICE_LOGON_FAILED = 1069;
    public const ERROR_SERVICE_START_HANG = 1070;
    public const ERROR_INVALID_SERVICE_LOCK = 1071;
    public const ERROR_SERVICE_MARKED_FOR_DELETE = 1072;
    public const ERROR_SERVICE_EXISTS = 1073;
    public const ERROR_ALREADY_RUNNING_LKG = 1074;
    public const ERROR_SERVICE_DEPENDENCY_DELETED = 1075;
    public const ERROR_BOOT_ALREADY_ACCEPTED = 1076;
    public const ERROR_SERVICE_NEVER_STARTED = 1077;
    public const ERROR_DUPLICATE_SERVICE_NAME = 1078;
    public const ERROR_DIFFERENT_SERVICE_ACCOUNT = 1079;
    public const ERROR_CANNOT_DETECT_DRIVER_FAILURE = 1080;
    public const ERROR_CANNOT_DETECT_PROCESS_ABORT = 1081;
    public const ERROR_NO_RECOVERY_PROGRAM = 1082;
    public const ERROR_SERVICE_NOT_IN_EXE = 1083;
    public const ERROR_NOT_SAFEBOOT_SERVICE = 1084;
    public const ERROR_END_OF_MEDIA = 1100;
    public const ERROR_FILEMARK_DETECTED = 1101;
    public const ERROR_BEGINNING_OF_MEDIA = 1102;
    public const ERROR_SETMARK_DETECTED = 1103;
    public const ERROR_NO_DATA_DETECTED = 1104;
    public const ERROR_PARTITION_FAILURE = 1105;
    public const ERROR_INVALID_BLOCK_LENGTH = 1106;
    public const ERROR_DEVICE_NOT_PARTITIONED = 1107;
    public const ERROR_UNABLE_TO_LOCK_MEDIA = 1108;
    public const ERROR_UNABLE_TO_UNLOAD_MEDIA = 1109;
    public const ERROR_MEDIA_CHANGED = 1110;
    public const ERROR_BUS_RESET = 1111;
    public const ERROR_NO_MEDIA_IN_DRIVE = 1112;
    public const ERROR_NO_UNICODE_TRANSLATION = 1113;
    public const ERROR_DLL_INIT_FAILED = 1114;
    public const ERROR_SHUTDOWN_IN_PROGRESS = 1115;
    public const ERROR_NO_SHUTDOWN_IN_PROGRESS = 1116;
    public const ERROR_IO_DEVICE = 1117;
    public const ERROR_SERIAL_NO_DEVICE = 1118;
    public const ERROR_IRQ_BUSY = 1119;
    public const ERROR_MORE_WRITES = 1120;
    public const ERROR_COUNTER_TIMEOUT = 1121;
    public const ERROR_FLOPPY_ID_MARK_NOT_FOUND = 1122;
    public const ERROR_FLOPPY_WRONG_CYLINDER = 1123;
    public const ERROR_FLOPPY_UNKNOWN_ERROR = 1124;
    public const ERROR_FLOPPY_BAD_REGISTERS = 1125;
    public const ERROR_DISK_RECALIBRATE_FAILED = 1126;
    public const ERROR_DISK_OPERATION_FAILED = 1127;
    public const ERROR_DISK_RESET_FAILED = 1128;
    public const ERROR_EOM_OVERFLOW = 1129;
    public const ERROR_NOT_ENOUGH_SERVER_MEMORY = 1130;
    public const ERROR_POSSIBLE_DEADLOCK = 1131;
    public const ERROR_MAPPED_ALIGNMENT = 1132;
    public const ERROR_SET_POWER_STATE_VETOED = 1140;
    public const ERROR_SET_POWER_STATE_FAILED = 1141;
    public const ERROR_TOO_MANY_LINKS = 1142;
    public const ERROR_OLD_WIN_VERSION = 1150;
    public const ERROR_APP_WRONG_OS = 1151;
    public const ERROR_SINGLE_INSTANCE_APP = 1152;
    public const ERROR_RMODE_APP = 1153;
    public const ERROR_INVALID_DLL = 1154;
    public const ERROR_NO_ASSOCIATION = 1155;
    public const ERROR_DDE_FAIL = 1156;
    public const ERROR_DLL_NOT_FOUND = 1157;
    public const ERROR_NO_MORE_USER_HANDLES = 1158;
    public const ERROR_MESSAGE_SYNC_ONLY = 1159;
    public const ERROR_SOURCE_ELEMENT_EMPTY = 1160;
    public const ERROR_DESTINATION_ELEMENT_FULL = 1161;
    public const ERROR_ILLEGAL_ELEMENT_ADDRESS = 1162;
    public const ERROR_MAGAZINE_NOT_PRESENT = 1163;
    public const ERROR_DEVICE_REINITIALIZATION_NEEDED = 1164;
    public const ERROR_DEVICE_REQUIRES_CLEANING = 1165;
    public const ERROR_DEVICE_DOOR_OPEN = 1166;
    public const ERROR_DEVICE_NOT_CONNECTED = 1167;
    public const ERROR_NOT_FOUND = 1168;
    public const ERROR_NO_MATCH = 1169;
    public const ERROR_SET_NOT_FOUND = 1170;
    public const ERROR_POINT_NOT_FOUND = 1171;
    public const ERROR_NO_TRACKING_SERVICE = 1172;
    public const ERROR_NO_VOLUME_ID = 1173;
    public const ERROR_UNABLE_TO_REMOVE_REPLACED = 1175;
    public const ERROR_UNABLE_TO_MOVE_REPLACEMENT = 1176;
    public const ERROR_UNABLE_TO_MOVE_REPLACEMENT_2 = 1177;
    public const ERROR_JOURNAL_DELETE_IN_PROGRESS = 1178;
    public const ERROR_JOURNAL_NOT_ACTIVE = 1179;
    public const ERROR_POTENTIAL_FILE_FOUND = 1180;
    public const ERROR_JOURNAL_ENTRY_DELETED = 1181;
    public const ERROR_SHUTDOWN_IS_SCHEDULED = 1190;
    public const ERROR_SHUTDOWN_USERS_LOGGED_ON = 1191;
    public const ERROR_BAD_DEVICE = 1200;
    public const ERROR_CONNECTION_UNAVAIL = 1201;
    public const ERROR_DEVICE_ALREADY_REMEMBERED = 1202;
    public const ERROR_NO_NET_OR_BAD_PATH = 1203;
    public const ERROR_BAD_PROVIDER = 1204;
    public const ERROR_CANNOT_OPEN_PROFILE = 1205;
    public const ERROR_BAD_PROFILE = 1206;
    public const ERROR_NOT_CONTAINER = 1207;
    public const ERROR_EXTENDED_ERROR = 1208;
    public const ERROR_INVALID_GROUPNAME = 1209;
    public const ERROR_INVALID_COMPUTERNAME = 1210;
    public const ERROR_INVALID_EVENTNAME = 1211;
    public const ERROR_INVALID_DOMAINNAME = 1212;
    public const ERROR_INVALID_SERVICENAME = 1213;
    public const ERROR_INVALID_NETNAME = 1214;
    public const ERROR_INVALID_SHARENAME = 1215;
    public const ERROR_INVALID_PASSWORDNAME = 1216;
    public const ERROR_INVALID_MESSAGENAME = 1217;
    public const ERROR_INVALID_MESSAGEDEST = 1218;
    public const ERROR_SESSION_CREDENTIAL_CONFLICT = 1219;
    public const ERROR_REMOTE_SESSION_LIMIT_EXCEEDED = 1220;
    public const ERROR_DUP_DOMAINNAME = 1221;
    public const ERROR_NO_NETWORK = 1222;
    public const ERROR_CANCELLED = 1223;
    public const ERROR_USER_MAPPED_FILE = 1224;
    public const ERROR_CONNECTION_REFUSED = 1225;
    public const ERROR_GRACEFUL_DISCONNECT = 1226;
    public const ERROR_ADDRESS_ALREADY_ASSOCIATED = 1227;
    public const ERROR_ADDRESS_NOT_ASSOCIATED = 1228;
    public const ERROR_CONNECTION_INVALID = 1229;
    public const ERROR_CONNECTION_ACTIVE = 1230;
    public const ERROR_NETWORK_UNREACHABLE = 1231;
    public const ERROR_HOST_UNREACHABLE = 1232;
    public const ERROR_PROTOCOL_UNREACHABLE = 1233;
    public const ERROR_PORT_UNREACHABLE = 1234;
    public const ERROR_REQUEST_ABORTED = 1235;
    public const ERROR_CONNECTION_ABORTED = 1236;
    public const ERROR_RETRY = 1237;
    public const ERROR_CONNECTION_COUNT_LIMIT = 1238;
    public const ERROR_LOGIN_TIME_RESTRICTION = 1239;
    public const ERROR_LOGIN_WKSTA_RESTRICTION = 1240;
    public const ERROR_INCORRECT_ADDRESS = 1241;
    public const ERROR_ALREADY_REGISTERED = 1242;
    public const ERROR_SERVICE_NOT_FOUND = 1243;
    public const ERROR_NOT_AUTHENTICATED = 1244;
    public const ERROR_NOT_LOGGED_ON = 1245;
    public const ERROR_CONTINUE = 1246;
    public const ERROR_ALREADY_INITIALIZED = 1247;
    public const ERROR_NO_MORE_DEVICES = 1248;
    public const ERROR_NO_SUCH_SITE = 1249;
    public const ERROR_DOMAIN_CONTROLLER_EXISTS = 1250;
    public const ERROR_ONLY_IF_CONNECTED = 1251;
    public const ERROR_OVERRIDE_NOCHANGES = 1252;
    public const ERROR_BAD_USER_PROFILE = 1253;
    public const ERROR_NOT_SUPPORTED_ON_SBS = 1254;
    public const ERROR_SERVER_SHUTDOWN_IN_PROGRESS = 1255;
    public const ERROR_HOST_DOWN = 1256;
    public const ERROR_NON_ACCOUNT_SID = 1257;
    public const ERROR_NON_DOMAIN_SID = 1258;
    public const ERROR_APPHELP_BLOCK = 1259;
    public const ERROR_ACCESS_DISABLED_BY_POLICY = 1260;
    public const ERROR_REG_NAT_CONSUMPTION = 1261;
    public const ERROR_CSCSHARE_OFFLINE = 1262;
    public const ERROR_PKINIT_FAILURE = 1263;
    public const ERROR_SMARTCARD_SUBSYSTEM_FAILURE = 1264;
    public const ERROR_DOWNGRADE_DETECTED = 1265;
    public const ERROR_MACHINE_LOCKED = 1271;
    public const ERROR_CALLBACK_SUPPLIED_INVALID_DATA = 1273;
    public const ERROR_SYNC_FOREGROUND_REFRESH_REQUIRED = 1274;
    public const ERROR_DRIVER_BLOCKED = 1275;
    public const ERROR_INVALID_IMPORT_OF_NON_DLL = 1276;
    public const ERROR_ACCESS_DISABLED_WEBBLADE = 1277;
    public const ERROR_ACCESS_DISABLED_WEBBLADE_TAMPER = 1278;
    public const ERROR_RECOVERY_FAILURE = 1279;
    public const ERROR_ALREADY_FIBER = 1280;
    public const ERROR_ALREADY_THREAD = 1281;
    public const ERROR_STACK_BUFFER_OVERRUN = 1282;
    public const ERROR_PARAMETER_QUOTA_EXCEEDED = 1283;
    public const ERROR_DEBUGGER_INACTIVE = 1284;
    public const ERROR_DELAY_LOAD_FAILED = 1285;
    public const ERROR_VDM_DISALLOWED = 1286;
    public const ERROR_UNIDENTIFIED_ERROR = 1287;
    public const ERROR_INVALID_CRUNTIME_PARAMETER = 1288;
    public const ERROR_BEYOND_VDL = 1289;
    public const ERROR_INCOMPATIBLE_SERVICE_SID_TYPE = 1290;
    public const ERROR_DRIVER_PROCESS_TERMINATED = 1291;
    public const ERROR_IMPLEMENTATION_LIMIT = 1292;
    public const ERROR_PROCESS_IS_PROTECTED = 1293;
    public const ERROR_SERVICE_NOTIFY_CLIENT_LAGGING = 1294;
    public const ERROR_DISK_QUOTA_EXCEEDED = 1295;
    public const ERROR_CONTENT_BLOCKED = 1296;
    public const ERROR_INCOMPATIBLE_SERVICE_PRIVILEGE = 1297;
    public const ERROR_APP_HANG = 1298;
    public const ERROR_INVALID_LABEL = 1299;
    public const ERROR_NOT_ALL_ASSIGNED = 1300;
    public const ERROR_SOME_NOT_MAPPED = 1301;
    public const ERROR_NO_QUOTAS_FOR_ACCOUNT = 1302;
    public const ERROR_LOCAL_USER_SESSION_KEY = 1303;
    public const ERROR_NULL_LM_PASSWORD = 1304;
    public const ERROR_UNKNOWN_REVISION = 1305;
    public const ERROR_REVISION_MISMATCH = 1306;
    public const ERROR_INVALID_OWNER = 1307;
    public const ERROR_INVALID_PRIMARY_GROUP = 1308;
    public const ERROR_NO_IMPERSONATION_TOKEN = 1309;
    public const ERROR_CANT_DISABLE_MANDATORY = 1310;
    public const ERROR_NO_LOGON_SERVERS = 1311;
    public const ERROR_NO_SUCH_LOGON_SESSION = 1312;
    public const ERROR_NO_SUCH_PRIVILEGE = 1313;
    public const ERROR_PRIVILEGE_NOT_HELD = 1314;
    public const ERROR_INVALID_ACCOUNT_NAME = 1315;
    public const ERROR_USER_EXISTS = 1316;
    public const ERROR_NO_SUCH_USER = 1317;
    public const ERROR_GROUP_EXISTS = 1318;
    public const ERROR_NO_SUCH_GROUP = 1319;
    public const ERROR_MEMBER_IN_GROUP = 1320;
    public const ERROR_MEMBER_NOT_IN_GROUP = 1321;
    public const ERROR_LAST_ADMIN = 1322;
    public const ERROR_WRONG_PASSWORD = 1323;
    public const ERROR_ILL_FORMED_PASSWORD = 1324;
    public const ERROR_PASSWORD_RESTRICTION = 1325;
    public const ERROR_LOGON_FAILURE = 1326;
    public const ERROR_ACCOUNT_RESTRICTION = 1327;
    public const ERROR_INVALID_LOGON_HOURS = 1328;
    public const ERROR_INVALID_WORKSTATION = 1329;
    public const ERROR_PASSWORD_EXPIRED = 1330;
    public const ERROR_ACCOUNT_DISABLED = 1331;
    public const ERROR_NONE_MAPPED = 1332;
    public const ERROR_TOO_MANY_LUIDS_REQUESTED = 1333;
    public const ERROR_LUIDS_EXHAUSTED = 1334;
    public const ERROR_INVALID_SUB_AUTHORITY = 1335;
    public const ERROR_INVALID_ACL = 1336;
    public const ERROR_INVALID_SID = 1337;
    public const ERROR_INVALID_SECURITY_DESCR = 1338;
    public const ERROR_BAD_INHERITANCE_ACL = 1340;
    public const ERROR_SERVER_DISABLED = 1341;
    public const ERROR_SERVER_NOT_DISABLED = 1342;
    public const ERROR_INVALID_ID_AUTHORITY = 1343;
    public const ERROR_ALLOTTED_SPACE_EXCEEDED = 1344;
    public const ERROR_INVALID_GROUP_ATTRIBUTES = 1345;
    public const ERROR_BAD_IMPERSONATION_LEVEL = 1346;
    public const ERROR_CANT_OPEN_ANONYMOUS = 1347;
    public const ERROR_BAD_VALIDATION_CLASS = 1348;
    public const ERROR_BAD_TOKEN_TYPE = 1349;
    public const ERROR_NO_SECURITY_ON_OBJECT = 1350;
    public const ERROR_CANT_ACCESS_DOMAIN_INFO = 1351;
    public const ERROR_INVALID_SERVER_STATE = 1352;
    public const ERROR_INVALID_DOMAIN_STATE = 1353;
    public const ERROR_INVALID_DOMAIN_ROLE = 1354;
    public const ERROR_NO_SUCH_DOMAIN = 1355;
    public const ERROR_DOMAIN_EXISTS = 1356;
    public const ERROR_DOMAIN_LIMIT_EXCEEDED = 1357;
    public const ERROR_INTERNAL_DB_CORRUPTION = 1358;
    public const ERROR_INTERNAL_ERROR = 1359;
    public const ERROR_GENERIC_NOT_MAPPED = 1360;
    public const ERROR_BAD_DESCRIPTOR_FORMAT = 1361;
    public const ERROR_NOT_LOGON_PROCESS = 1362;
    public const ERROR_LOGON_SESSION_EXISTS = 1363;
    public const ERROR_NO_SUCH_PACKAGE = 1364;
    public const ERROR_BAD_LOGON_SESSION_STATE = 1365;
    public const ERROR_LOGON_SESSION_COLLISION = 1366;
    public const ERROR_INVALID_LOGON_TYPE = 1367;
    public const ERROR_CANNOT_IMPERSONATE = 1368;
    public const ERROR_RXACT_INVALID_STATE = 1369;
    public const ERROR_RXACT_COMMIT_FAILURE = 1370;
    public const ERROR_SPECIAL_ACCOUNT = 1371;
    public const ERROR_SPECIAL_GROUP = 1372;
    public const ERROR_SPECIAL_USER = 1373;
    public const ERROR_MEMBERS_PRIMARY_GROUP = 1374;
    public const ERROR_TOKEN_ALREADY_IN_USE = 1375;
    public const ERROR_NO_SUCH_ALIAS = 1376;
    public const ERROR_MEMBER_NOT_IN_ALIAS = 1377;
    public const ERROR_MEMBER_IN_ALIAS = 1378;
    public const ERROR_ALIAS_EXISTS = 1379;
    public const ERROR_LOGON_NOT_GRANTED = 1380;
    public const ERROR_TOO_MANY_SECRETS = 1381;
    public const ERROR_SECRET_TOO_LONG = 1382;
    public const ERROR_INTERNAL_DB_ERROR = 1383;
    public const ERROR_TOO_MANY_CONTEXT_IDS = 1384;
    public const ERROR_LOGON_TYPE_NOT_GRANTED = 1385;
    public const ERROR_NT_CROSS_ENCRYPTION_REQUIRED = 1386;
    public const ERROR_NO_SUCH_MEMBER = 1387;
    public const ERROR_INVALID_MEMBER = 1388;
    public const ERROR_TOO_MANY_SIDS = 1389;
    public const ERROR_LM_CROSS_ENCRYPTION_REQUIRED = 1390;
    public const ERROR_NO_INHERITANCE = 1391;
    public const ERROR_FILE_CORRUPT = 1392;
    public const ERROR_DISK_CORRUPT = 1393;
    public const ERROR_NO_USER_SESSION_KEY = 1394;
    public const ERROR_LICENSE_QUOTA_EXCEEDED = 1395;
    public const ERROR_WRONG_TARGET_NAME = 1396;
    public const ERROR_MUTUAL_AUTH_FAILED = 1397;
    public const ERROR_TIME_SKEW = 1398;
    public const ERROR_CURRENT_DOMAIN_NOT_ALLOWED = 1399;
    public const ERROR_INVALID_WINDOW_HANDLE = 1400;
    public const ERROR_INVALID_MENU_HANDLE = 1401;
    public const ERROR_INVALID_CURSOR_HANDLE = 1402;
    public const ERROR_INVALID_ACCEL_HANDLE = 1403;
    public const ERROR_INVALID_HOOK_HANDLE = 1404;
    public const ERROR_INVALID_DWP_HANDLE = 1405;
    public const ERROR_TLW_WITH_WSCHILD = 1406;
    public const ERROR_CANNOT_FIND_WND_CLASS = 1407;
    public const ERROR_WINDOW_OF_OTHER_THREAD = 1408;
    public const ERROR_HOTKEY_ALREADY_REGISTERED = 1409;
    public const ERROR_CLASS_ALREADY_EXISTS = 1410;
    public const ERROR_CLASS_DOES_NOT_EXIST = 1411;
    public const ERROR_CLASS_HAS_WINDOWS = 1412;
    public const ERROR_INVALID_INDEX = 1413;
    public const ERROR_INVALID_ICON_HANDLE = 1414;
    public const ERROR_PRIVATE_DIALOG_INDEX = 1415;
    public const ERROR_LISTBOX_ID_NOT_FOUND = 1416;
    public const ERROR_NO_WILDCARD_CHARACTERS = 1417;
    public const ERROR_CLIPBOARD_NOT_OPEN = 1418;
    public const ERROR_HOTKEY_NOT_REGISTERED = 1419;
    public const ERROR_WINDOW_NOT_DIALOG = 1420;
    public const ERROR_CONTROL_ID_NOT_FOUND = 1421;
    public const ERROR_INVALID_COMBOBOX_MESSAGE = 1422;
    public const ERROR_WINDOW_NOT_COMBOBOX = 1423;
    public const ERROR_INVALID_EDIT_HEIGHT = 1424;
    public const ERROR_DC_NOT_FOUND = 1425;
    public const ERROR_INVALID_HOOK_FILTER = 1426;
    public const ERROR_INVALID_FILTER_PROC = 1427;
    public const ERROR_HOOK_NEEDS_HMOD = 1428;
    public const ERROR_GLOBAL_ONLY_HOOK = 1429;
    public const ERROR_JOURNAL_HOOK_SET = 1430;
    public const ERROR_HOOK_NOT_INSTALLED = 1431;
    public const ERROR_INVALID_LB_MESSAGE = 1432;
    public const ERROR_SETCOUNT_ON_BAD_LB = 1433;
    public const ERROR_LB_WITHOUT_TABSTOPS = 1434;
    public const ERROR_DESTROY_OBJECT_OF_OTHER_THREAD = 1435;
    public const ERROR_CHILD_WINDOW_MENU = 1436;
    public const ERROR_NO_SYSTEM_MENU = 1437;
    public const ERROR_INVALID_MSGBOX_STYLE = 1438;
    public const ERROR_INVALID_SPI_VALUE = 1439;
    public const ERROR_SCREEN_ALREADY_LOCKED = 1440;
    public const ERROR_HWNDS_HAVE_DIFF_PARENT = 1441;
    public const ERROR_NOT_CHILD_WINDOW = 1442;
    public const ERROR_INVALID_GW_COMMAND = 1443;
    public const ERROR_INVALID_THREAD_ID = 1444;
    public const ERROR_NON_MDICHILD_WINDOW = 1445;
    public const ERROR_POPUP_ALREADY_ACTIVE = 1446;
    public const ERROR_NO_SCROLLBARS = 1447;
    public const ERROR_INVALID_SCROLLBAR_RANGE = 1448;
    public const ERROR_INVALID_SHOWWIN_COMMAND = 1449;
    public const ERROR_NO_SYSTEM_RESOURCES = 1450;
    public const ERROR_NONPAGED_SYSTEM_RESOURCES = 1451;
    public const ERROR_PAGED_SYSTEM_RESOURCES = 1452;
    public const ERROR_WORKING_SET_QUOTA = 1453;
    public const ERROR_PAGEFILE_QUOTA = 1454;
    public const ERROR_COMMITMENT_LIMIT = 1455;
    public const ERROR_MENU_ITEM_NOT_FOUND = 1456;
    public const ERROR_INVALID_KEYBOARD_HANDLE = 1457;
    public const ERROR_HOOK_TYPE_NOT_ALLOWED = 1458;
    public const ERROR_REQUIRES_INTERACTIVE_WINDOWSTATION = 1459;
    public const ERROR_TIMEOUT = 1460;
    public const ERROR_INVALID_MONITOR_HANDLE = 1461;
    public const ERROR_INCORRECT_SIZE = 1462;
    public const ERROR_SYMLINK_CLASS_DISABLED = 1463;
    public const ERROR_SYMLINK_NOT_SUPPORTED = 1464;
    public const ERROR_XML_PARSE_ERROR = 1465;
    public const ERROR_XMLDSIG_ERROR = 1466;
    public const ERROR_RESTART_APPLICATION = 1467;
    public const ERROR_WRONG_COMPARTMENT = 1468;
    public const ERROR_AUTHIP_FAILURE = 1469;
    public const ERROR_NO_NVRAM_RESOURCES = 1470;
    public const ERROR_NOT_GUI_PROCESS = 1471;
    public const ERROR_EVENTLOG_FILE_CORRUPT = 1500;
    public const ERROR_EVENTLOG_CANT_START = 1501;
    public const ERROR_LOG_FILE_FULL = 1502;
    public const ERROR_EVENTLOG_FILE_CHANGED = 1503;
    public const ERROR_INVALID_TASK_NAME = 1550;
    public const ERROR_INVALID_TASK_INDEX = 1551;
    public const ERROR_THREAD_ALREADY_IN_TASK = 1552;
    public const ERROR_INSTALL_SERVICE_FAILURE = 1601;
    public const ERROR_INSTALL_USEREXIT = 1602;
    public const ERROR_INSTALL_FAILURE = 1603;
    public const ERROR_INSTALL_SUSPEND = 1604;
    public const ERROR_UNKNOWN_PRODUCT = 1605;
    public const ERROR_UNKNOWN_FEATURE = 1606;
    public const ERROR_UNKNOWN_COMPONENT = 1607;
    public const ERROR_UNKNOWN_PROPERTY = 1608;
    public const ERROR_INVALID_HANDLE_STATE = 1609;
    public const ERROR_BAD_CONFIGURATION = 1610;
    public const ERROR_INDEX_ABSENT = 1611;
    public const ERROR_INSTALL_SOURCE_ABSENT = 1612;
    public const ERROR_INSTALL_PACKAGE_VERSION = 1613;
    public const ERROR_PRODUCT_UNINSTALLED = 1614;
    public const ERROR_BAD_QUERY_SYNTAX = 1615;
    public const ERROR_INVALID_FIELD = 1616;
    public const ERROR_DEVICE_REMOVED = 1617;
    public const ERROR_INSTALL_ALREADY_RUNNING = 1618;
    public const ERROR_INSTALL_PACKAGE_OPEN_FAILED = 1619;
    public const ERROR_INSTALL_PACKAGE_INVALID = 1620;
    public const ERROR_INSTALL_UI_FAILURE = 1621;
    public const ERROR_INSTALL_LOG_FAILURE = 1622;
    public const ERROR_INSTALL_LANGUAGE_UNSUPPORTED = 1623;
    public const ERROR_INSTALL_TRANSFORM_FAILURE = 1624;
    public const ERROR_INSTALL_PACKAGE_REJECTED = 1625;
    public const ERROR_FUNCTION_NOT_CALLED = 1626;
    public const ERROR_FUNCTION_FAILED = 1627;
    public const ERROR_INVALID_TABLE = 1628;
    public const ERROR_DATATYPE_MISMATCH = 1629;
    public const ERROR_UNSUPPORTED_TYPE = 1630;
    public const ERROR_CREATE_FAILED = 1631;
    public const ERROR_INSTALL_TEMP_UNWRITABLE = 1632;
    public const ERROR_INSTALL_PLATFORM_UNSUPPORTED = 1633;
    public const ERROR_INSTALL_NOTUSED = 1634;
    public const ERROR_PATCH_PACKAGE_OPEN_FAILED = 1635;
    public const ERROR_PATCH_PACKAGE_INVALID = 1636;
    public const ERROR_PATCH_PACKAGE_UNSUPPORTED = 1637;
    public const ERROR_PRODUCT_VERSION = 1638;
    public const ERROR_INVALID_COMMAND_LINE = 1639;
    public const ERROR_INSTALL_REMOTE_DISALLOWED = 1640;
    public const ERROR_SUCCESS_REBOOT_INITIATED = 1641;
    public const ERROR_PATCH_TARGET_NOT_FOUND = 1642;
    public const ERROR_PATCH_PACKAGE_REJECTED = 1643;
    public const ERROR_INSTALL_TRANSFORM_REJECTED = 1644;
    public const ERROR_INSTALL_REMOTE_PROHIBITED = 1645;
    public const ERROR_PATCH_REMOVAL_UNSUPPORTED = 1646;
    public const ERROR_UNKNOWN_PATCH = 1647;
    public const ERROR_PATCH_NO_SEQUENCE = 1648;
    public const ERROR_PATCH_REMOVAL_DISALLOWED = 1649;
    public const ERROR_INVALID_PATCH_XML = 1650;
    public const ERROR_PATCH_MANAGED_ADVERTISED_PRODUCT = 1651;
    public const ERROR_INSTALL_SERVICE_SAFEBOOT = 1652;
    public const ERROR_FAIL_FAST_EXCEPTION = 1653;
    public const ERROR_INSTALL_REJECTED = 1654;

    public const RPC_S_INVALID_STRING_BINDING = 1700;
    public const RPC_S_WRONG_KIND_OF_BINDING = 1701;
    public const RPC_S_INVALID_BINDING = 1702;
    public const RPC_S_PROTSEQ_NOT_SUPPORTED = 1703;
    public const RPC_S_INVALID_RPC_PROTSEQ = 1704;
    public const RPC_S_INVALID_STRING_UUID = 1705;
    public const RPC_S_INVALID_ENDPOINT_FORMAT = 1706;
    public const RPC_S_INVALID_NET_ADDR = 1707;
    public const RPC_S_NO_ENDPOINT_FOUND = 1708;
    public const RPC_S_INVALID_TIMEOUT = 1709;
    public const RPC_S_OBJECT_NOT_FOUND = 1710;
    public const RPC_S_ALREADY_REGISTERED = 1711;
    public const RPC_S_TYPE_ALREADY_REGISTERED = 1712;
    public const RPC_S_ALREADY_LISTENING = 1713;
    public const RPC_S_NO_PROTSEQS_REGISTERED = 1714;
    public const RPC_S_NOT_LISTENING = 1715;
    public const RPC_S_UNKNOWN_MGR_TYPE = 1716;
    public const RPC_S_UNKNOWN_IF = 1717;
    public const RPC_S_NO_BINDINGS = 1718;
    public const RPC_S_NO_PROTSEQS = 1719;
    public const RPC_S_CANT_CREATE_ENDPOINT = 1720;
    public const RPC_S_OUT_OF_RESOURCES = 1721;
    public const RPC_S_SERVER_UNAVAILABLE = 1722;
    public const RPC_S_SERVER_TOO_BUSY = 1723;
    public const RPC_S_INVALID_NETWORK_OPTIONS = 1724;
    public const RPC_S_NO_CALL_ACTIVE = 1725;
    public const RPC_S_CALL_FAILED = 1726;
    public const RPC_S_CALL_FAILED_DNE = 1727;
    public const RPC_S_PROTOCOL_ERROR = 1728;
    public const RPC_S_PROXY_ACCESS_DENIED = 1729;
    public const RPC_S_UNSUPPORTED_TRANS_SYN = 1730;
    public const RPC_S_UNSUPPORTED_TYPE = 1732;
    public const RPC_S_INVALID_TAG = 1733;
    public const RPC_S_INVALID_BOUND = 1734;
    public const RPC_S_NO_ENTRY_NAME = 1735;
    public const RPC_S_INVALID_NAME_SYNTAX = 1736;
    public const RPC_S_UNSUPPORTED_NAME_SYNTAX = 1737;
    public const RPC_S_UUID_NO_ADDRESS = 1739;
    public const RPC_S_DUPLICATE_ENDPOINT = 1740;
    public const RPC_S_UNKNOWN_AUTHN_TYPE = 1741;
    public const RPC_S_MAX_CALLS_TOO_SMALL = 1742;
    public const RPC_S_STRING_TOO_LONG = 1743;
    public const RPC_S_PROTSEQ_NOT_FOUND = 1744;
    public const RPC_S_PROCNUM_OUT_OF_RANGE = 1745;
    public const RPC_S_BINDING_HAS_NO_AUTH = 1746;
    public const RPC_S_UNKNOWN_AUTHN_SERVICE = 1747;
    public const RPC_S_UNKNOWN_AUTHN_LEVEL = 1748;
    public const RPC_S_INVALID_AUTH_IDENTITY = 1749;
    public const RPC_S_UNKNOWN_AUTHZ_SERVICE = 1750;
    public const EPT_S_INVALID_ENTRY = 1751;
    public const EPT_S_CANT_PERFORM_OP = 1752;
    public const EPT_S_NOT_REGISTERED = 1753;
    public const RPC_S_NOTHING_TO_EXPORT = 1754;
    public const RPC_S_INCOMPLETE_NAME = 1755;
    public const RPC_S_INVALID_VERS_OPTION = 1756;
    public const RPC_S_NO_MORE_MEMBERS = 1757;
    public const RPC_S_NOT_ALL_OBJS_UNEXPORTED = 1758;
    public const RPC_S_INTERFACE_NOT_FOUND = 1759;
    public const RPC_S_ENTRY_ALREADY_EXISTS = 1760;
    public const RPC_S_ENTRY_NOT_FOUND = 1761;
    public const RPC_S_NAME_SERVICE_UNAVAILABLE = 1762;
    public const RPC_S_INVALID_NAF_ID = 1763;
    public const RPC_S_CANNOT_SUPPORT = 1764;
    public const RPC_S_NO_CONTEXT_AVAILABLE = 1765;
    public const RPC_S_INTERNAL_ERROR = 1766;
    public const RPC_S_ZERO_DIVIDE = 1767;
    public const RPC_S_ADDRESS_ERROR = 1768;
    public const RPC_S_FP_DIV_ZERO = 1769;
    public const RPC_S_FP_UNDERFLOW = 1770;
    public const RPC_S_FP_OVERFLOW = 1771;
    public const RPC_X_NO_MORE_ENTRIES = 1772;
    public const RPC_X_SS_CHAR_TRANS_OPEN_FAIL = 1773;
    public const RPC_X_SS_CHAR_TRANS_SHORT_FILE = 1774;
    public const RPC_X_SS_IN_NULL_CONTEXT = 1775;
    public const RPC_X_SS_CONTEXT_DAMAGED = 1777;
    public const RPC_X_SS_HANDLES_MISMATCH = 1778;
    public const RPC_X_SS_CANNOT_GET_CALL_HANDLE = 1779;
    public const RPC_X_NULL_REF_POINTER = 1780;
    public const RPC_X_ENUM_VALUE_OUT_OF_RANGE = 1781;
    public const RPC_X_BYTE_COUNT_TOO_SMALL = 1782;
    public const RPC_X_BAD_STUB_DATA = 1783;
    public const ERROR_INVALID_USER_BUFFER = 1784;
    public const ERROR_UNRECOGNIZED_MEDIA = 1785;
    public const ERROR_NO_TRUST_LSA_SECRET = 1786;
    public const ERROR_NO_TRUST_SAM_ACCOUNT = 1787;
    public const ERROR_TRUSTED_DOMAIN_FAILURE = 1788;
    public const ERROR_TRUSTED_RELATIONSHIP_FAILURE = 1789;
    public const ERROR_TRUST_FAILURE = 1790;
    public const RPC_S_CALL_IN_PROGRESS = 1791;
    public const ERROR_NETLOGON_NOT_STARTED = 1792;
    public const ERROR_ACCOUNT_EXPIRED = 1793;
    public const ERROR_REDIRECTOR_HAS_OPEN_HANDLES = 1794;
    public const ERROR_PRINTER_DRIVER_ALREADY_INSTALLED = 1795;
    public const ERROR_UNKNOWN_PORT = 1796;
    public const ERROR_UNKNOWN_PRINTER_DRIVER = 1797;
    public const ERROR_UNKNOWN_PRINTPROCESSOR = 1798;
    public const ERROR_INVALID_SEPARATOR_FILE = 1799;
    public const ERROR_INVALID_PRIORITY = 1800;
    public const ERROR_INVALID_PRINTER_NAME = 1801;
    public const ERROR_PRINTER_ALREADY_EXISTS = 1802;
    public const ERROR_INVALID_PRINTER_COMMAND = 1803;
    public const ERROR_INVALID_DATATYPE = 1804;
    public const ERROR_INVALID_ENVIRONMENT = 1805;
    public const RPC_S_NO_MORE_BINDINGS = 1806;
    public const ERROR_NOLOGON_INTERDOMAIN_TRUST_ACCOUNT = 1807;
    public const ERROR_NOLOGON_WORKSTATION_TRUST_ACCOUNT = 1808;
    public const ERROR_NOLOGON_SERVER_TRUST_ACCOUNT = 1809;
    public const ERROR_DOMAIN_TRUST_INCONSISTENT = 1810;
    public const ERROR_SERVER_HAS_OPEN_HANDLES = 1811;
    public const ERROR_RESOURCE_DATA_NOT_FOUND = 1812;
    public const ERROR_RESOURCE_TYPE_NOT_FOUND = 1813;
    public const ERROR_RESOURCE_NAME_NOT_FOUND = 1814;
    public const ERROR_RESOURCE_LANG_NOT_FOUND = 1815;
    public const ERROR_NOT_ENOUGH_QUOTA = 1816;
    public const RPC_S_NO_INTERFACES = 1817;
    public const RPC_S_CALL_CANCELLED = 1818;
    public const RPC_S_BINDING_INCOMPLETE = 1819;
    public const RPC_S_COMM_FAILURE = 1820;
    public const RPC_S_UNSUPPORTED_AUTHN_LEVEL = 1821;
    public const RPC_S_NO_PRINC_NAME = 1822;
    public const RPC_S_NOT_RPC_ERROR = 1823;
    public const RPC_S_UUID_LOCAL_ONLY = 1824;
    public const RPC_S_SEC_PKG_ERROR = 1825;
    public const RPC_S_NOT_CANCELLED = 1826;
    public const RPC_X_INVALID_ES_ACTION = 1827;
    public const RPC_X_WRONG_ES_VERSION = 1828;
    public const RPC_X_WRONG_STUB_VERSION = 1829;
    public const RPC_X_INVALID_PIPE_OBJECT = 1830;
    public const RPC_X_WRONG_PIPE_ORDER = 1831;
    public const RPC_X_WRONG_PIPE_VERSION = 1832;
    public const RPC_S_COOKIE_AUTH_FAILED = 1833;
    public const RPC_S_GROUP_MEMBER_NOT_FOUND = 1898;
    public const EPT_S_CANT_CREATE = 1899;
    public const RPC_S_INVALID_OBJECT = 1900;
    public const ERROR_INVALID_TIME = 1901;
    public const ERROR_INVALID_FORM_NAME = 1902;
    public const ERROR_INVALID_FORM_SIZE = 1903;
    public const ERROR_ALREADY_WAITING = 1904;
    public const ERROR_PRINTER_DELETED = 1905;
    public const ERROR_INVALID_PRINTER_STATE = 1906;
    public const ERROR_PASSWORD_MUST_CHANGE = 1907;
    public const ERROR_DOMAIN_CONTROLLER_NOT_FOUND = 1908;
    public const ERROR_ACCOUNT_LOCKED_OUT = 1909;
    public const OR_INVALID_OXID = 1910;
    public const OR_INVALID_OID = 1911;
    public const OR_INVALID_SET = 1912;
    public const RPC_S_SEND_INCOMPLETE = 1913;
    public const RPC_S_INVALID_ASYNC_HANDLE = 1914;
    public const RPC_S_INVALID_ASYNC_CALL = 1915;
    public const RPC_X_PIPE_CLOSED = 1916;
    public const RPC_X_PIPE_DISCIPLINE_ERROR = 1917;
    public const RPC_X_PIPE_EMPTY = 1918;
    public const ERROR_NO_SITENAME = 1919;
    public const ERROR_CANT_ACCESS_FILE = 1920;
    public const ERROR_CANT_RESOLVE_FILENAME = 1921;
    public const RPC_S_ENTRY_TYPE_MISMATCH = 1922;
    public const RPC_S_NOT_ALL_OBJS_EXPORTED = 1923;
    public const RPC_S_INTERFACE_NOT_EXPORTED = 1924;
    public const RPC_S_PROFILE_NOT_ADDED = 1925;
    public const RPC_S_PRF_ELT_NOT_ADDED = 1926;
    public const RPC_S_PRF_ELT_NOT_REMOVED = 1927;
    public const RPC_S_GRP_ELT_NOT_ADDED = 1928;
    public const RPC_S_GRP_ELT_NOT_REMOVED = 1929;
    public const ERROR_KM_DRIVER_BLOCKED = 1930;
    public const ERROR_CONTEXT_EXPIRED = 1931;
    public const ERROR_PER_USER_TRUST_QUOTA_EXCEEDED = 1932;
    public const ERROR_ALL_USER_TRUST_QUOTA_EXCEEDED = 1933;
    public const ERROR_USER_DELETE_TRUST_QUOTA_EXCEEDED = 1934;
    public const ERROR_AUTHENTICATION_FIREWALL_FAILED = 1935;
    public const ERROR_REMOTE_PRINT_CONNECTIONS_BLOCKED = 1936;
    public const ERROR_NTLM_BLOCKED = 1937;
    public const ERROR_PASSWORD_CHANGE_REQUIRED = 1938;
    public const ERROR_INVALID_PIXEL_FORMAT = 2000;
    public const ERROR_BAD_DRIVER = 2001;
    public const ERROR_INVALID_WINDOW_STYLE = 2002;
    public const ERROR_METAFILE_NOT_SUPPORTED = 2003;
    public const ERROR_TRANSFORM_NOT_SUPPORTED = 2004;
    public const ERROR_CLIPPING_NOT_SUPPORTED = 2005;
    public const ERROR_INVALID_CMM = 2010;
    public const ERROR_INVALID_PROFILE = 2011;
    public const ERROR_TAG_NOT_FOUND = 2012;
    public const ERROR_TAG_NOT_PRESENT = 2013;
    public const ERROR_DUPLICATE_TAG = 2014;
    public const ERROR_PROFILE_NOT_ASSOCIATED_WITH_DEVICE = 2015;
    public const ERROR_PROFILE_NOT_FOUND = 2016;
    public const ERROR_INVALID_COLORSPACE = 2017;
    public const ERROR_ICM_NOT_ENABLED = 2018;
    public const ERROR_DELETING_ICM_XFORM = 2019;
    public const ERROR_INVALID_TRANSFORM = 2020;
    public const ERROR_COLORSPACE_MISMATCH = 2021;
    public const ERROR_INVALID_COLORINDEX = 2022;
    public const ERROR_PROFILE_DOES_NOT_MATCH_DEVICE = 2023;
    public const ERROR_CONNECTED_OTHER_PASSWORD = 2108;
    public const ERROR_CONNECTED_OTHER_PASSWORD_DEFAULT = 2109;
    public const ERROR_BAD_USERNAME = 2202;
    public const ERROR_NOT_CONNECTED = 2250;
    public const ERROR_OPEN_FILES = 2401;
    public const ERROR_ACTIVE_CONNECTIONS = 2402;
    public const ERROR_DEVICE_IN_USE = 2404;
    public const ERROR_UNKNOWN_PRINT_MONITOR = 3000;
    public const ERROR_PRINTER_DRIVER_IN_USE = 3001;
    public const ERROR_SPOOL_FILE_NOT_FOUND = 3002;
    public const ERROR_SPL_NO_STARTDOC = 3003;
    public const ERROR_SPL_NO_ADDJOB = 3004;
    public const ERROR_PRINT_PROCESSOR_ALREADY_INSTALLED = 3005;
    public const ERROR_PRINT_MONITOR_ALREADY_INSTALLED = 3006;
    public const ERROR_INVALID_PRINT_MONITOR = 3007;
    public const ERROR_PRINT_MONITOR_IN_USE = 3008;
    public const ERROR_PRINTER_HAS_JOBS_QUEUED = 3009;
    public const ERROR_SUCCESS_REBOOT_REQUIRED = 3010;
    public const ERROR_SUCCESS_RESTART_REQUIRED = 3011;
    public const ERROR_PRINTER_NOT_FOUND = 3012;
    public const ERROR_PRINTER_DRIVER_WARNED = 3013;
    public const ERROR_PRINTER_DRIVER_BLOCKED = 3014;
    public const ERROR_PRINTER_DRIVER_PACKAGE_IN_USE = 3015;
    public const ERROR_CORE_DRIVER_PACKAGE_NOT_FOUND = 3016;
    public const ERROR_FAIL_REBOOT_REQUIRED = 3017;
    public const ERROR_FAIL_REBOOT_INITIATED = 3018;
    public const ERROR_PRINTER_DRIVER_DOWNLOAD_NEEDED = 3019;
    public const ERROR_PRINT_JOB_RESTART_REQUIRED = 3020;
    public const ERROR_INVALID_PRINTER_DRIVER_MANIFEST = 3021;
    public const ERROR_PRINTER_NOT_SHAREABLE = 3022;
    public const ERROR_REQUEST_PAUSED = 3050;
    public const ERROR_IO_REISSUE_AS_CACHED = 3950;
    public const ERROR_WINS_INTERNAL = 4000;
    public const ERROR_CAN_NOT_DEL_LOCAL_WINS = 4001;
    public const ERROR_STATIC_INIT = 4002;
    public const ERROR_INC_BACKUP = 4003;
    public const ERROR_FULL_BACKUP = 4004;
    public const ERROR_REC_NON_EXISTENT = 4005;
    public const ERROR_RPL_NOT_ALLOWED = 4006;
    public const PEERDIST_ERROR_CONTENTINFO_VERSION_UNSUPPORTED = 4050;
    public const PEERDIST_ERROR_CANNOT_PARSE_CONTENTINFO = 4051;
    public const PEERDIST_ERROR_MISSING_DATA = 4052;
    public const PEERDIST_ERROR_NO_MORE = 4053;
    public const PEERDIST_ERROR_NOT_INITIALIZED = 4054;
    public const PEERDIST_ERROR_ALREADY_INITIALIZED = 4055;
    public const PEERDIST_ERROR_SHUTDOWN_IN_PROGRESS = 4056;
    public const PEERDIST_ERROR_INVALIDATED = 4057;
    public const PEERDIST_ERROR_ALREADY_EXISTS = 4058;
    public const PEERDIST_ERROR_OPERATION_NOTFOUND = 4059;
    public const PEERDIST_ERROR_ALREADY_COMPLETED = 4060;
    public const PEERDIST_ERROR_OUT_OF_BOUNDS = 4061;
    public const PEERDIST_ERROR_VERSION_UNSUPPORTED = 4062;
    public const PEERDIST_ERROR_INVALID_CONFIGURATION = 4063;
    public const PEERDIST_ERROR_NOT_LICENSED = 4064;
    public const PEERDIST_ERROR_SERVICE_UNAVAILABLE = 4065;
    public const PEERDIST_ERROR_TRUST_FAILURE = 4066;
    public const ERROR_DHCP_ADDRESS_CONFLICT = 4100;
    public const ERROR_WMI_GUID_NOT_FOUND = 4200;
    public const ERROR_WMI_INSTANCE_NOT_FOUND = 4201;
    public const ERROR_WMI_ITEMID_NOT_FOUND = 4202;
    public const ERROR_WMI_TRY_AGAIN = 4203;
    public const ERROR_WMI_DP_NOT_FOUND = 4204;
    public const ERROR_WMI_UNRESOLVED_INSTANCE_REF = 4205;
    public const ERROR_WMI_ALREADY_ENABLED = 4206;
    public const ERROR_WMI_GUID_DISCONNECTED = 4207;
    public const ERROR_WMI_SERVER_UNAVAILABLE = 4208;
    public const ERROR_WMI_DP_FAILED = 4209;
    public const ERROR_WMI_INVALID_MOF = 4210;
    public const ERROR_WMI_INVALID_REGINFO = 4211;
    public const ERROR_WMI_ALREADY_DISABLED = 4212;
    public const ERROR_WMI_READ_ONLY = 4213;
    public const ERROR_WMI_SET_FAILURE = 4214;
    public const ERROR_NOT_APPCONTAINER = 4250;
    public const ERROR_APPCONTAINER_REQUIRED = 4251;
    public const ERROR_NOT_SUPPORTED_IN_APPCONTAINER = 4252;
    public const ERROR_INVALID_PACKAGE_SID_LENGTH = 4253;
    public const ERROR_INVALID_MEDIA = 4300;
    public const ERROR_INVALID_LIBRARY = 4301;
    public const ERROR_INVALID_MEDIA_POOL = 4302;
    public const ERROR_DRIVE_MEDIA_MISMATCH = 4303;
    public const ERROR_MEDIA_OFFLINE = 4304;
    public const ERROR_LIBRARY_OFFLINE = 4305;
    public const ERROR_EMPTY = 4306;
    public const ERROR_NOT_EMPTY = 4307;
    public const ERROR_MEDIA_UNAVAILABLE = 4308;
    public const ERROR_RESOURCE_DISABLED = 4309;
    public const ERROR_INVALID_CLEANER = 4310;
    public const ERROR_UNABLE_TO_CLEAN = 4311;
    public const ERROR_OBJECT_NOT_FOUND = 4312;
    public const ERROR_DATABASE_FAILURE = 4313;
    public const ERROR_DATABASE_FULL = 4314;
    public const ERROR_MEDIA_INCOMPATIBLE = 4315;
    public const ERROR_RESOURCE_NOT_PRESENT = 4316;
    public const ERROR_INVALID_OPERATION = 4317;
    public const ERROR_MEDIA_NOT_AVAILABLE = 4318;
    public const ERROR_DEVICE_NOT_AVAILABLE = 4319;
    public const ERROR_REQUEST_REFUSED = 4320;
    public const ERROR_INVALID_DRIVE_OBJECT = 4321;
    public const ERROR_LIBRARY_FULL = 4322;
    public const ERROR_MEDIUM_NOT_ACCESSIBLE = 4323;
    public const ERROR_UNABLE_TO_LOAD_MEDIUM = 4324;
    public const ERROR_UNABLE_TO_INVENTORY_DRIVE = 4325;
    public const ERROR_UNABLE_TO_INVENTORY_SLOT = 4326;
    public const ERROR_UNABLE_TO_INVENTORY_TRANSPORT = 4327;
    public const ERROR_TRANSPORT_FULL = 4328;
    public const ERROR_CONTROLLING_IEPORT = 4329;
    public const ERROR_UNABLE_TO_EJECT_MOUNTED_MEDIA = 4330;
    public const ERROR_CLEANER_SLOT_SET = 4331;
    public const ERROR_CLEANER_SLOT_NOT_SET = 4332;
    public const ERROR_CLEANER_CARTRIDGE_SPENT = 4333;
    public const ERROR_UNEXPECTED_OMID = 4334;
    public const ERROR_CANT_DELETE_LAST_ITEM = 4335;
    public const ERROR_MESSAGE_EXCEEDS_MAX_SIZE = 4336;
    public const ERROR_VOLUME_CONTAINS_SYS_FILES = 4337;
    public const ERROR_INDIGENOUS_TYPE = 4338;
    public const ERROR_NO_SUPPORTING_DRIVES = 4339;
    public const ERROR_CLEANER_CARTRIDGE_INSTALLED = 4340;
    public const ERROR_IEPORT_FULL = 4341;
    public const ERROR_FILE_OFFLINE = 4350;
    public const ERROR_REMOTE_STORAGE_NOT_ACTIVE = 4351;
    public const ERROR_REMOTE_STORAGE_MEDIA_ERROR = 4352;
    public const ERROR_NOT_A_REPARSE_POINT = 4390;
    public const ERROR_REPARSE_ATTRIBUTE_CONFLICT = 4391;
    public const ERROR_INVALID_REPARSE_DATA = 4392;
    public const ERROR_REPARSE_TAG_INVALID = 4393;
    public const ERROR_REPARSE_TAG_MISMATCH = 4394;
    public const ERROR_APP_DATA_NOT_FOUND = 4400;
    public const ERROR_APP_DATA_EXPIRED = 4401;
    public const ERROR_APP_DATA_CORRUPT = 4402;
    public const ERROR_APP_DATA_LIMIT_EXCEEDED = 4403;
    public const ERROR_APP_DATA_REBOOT_REQUIRED = 4404;
    public const ERROR_SECUREBOOT_ROLLBACK_DETECTED = 4420;
    public const ERROR_SECUREBOOT_POLICY_VIOLATION = 4421;
    public const ERROR_SECUREBOOT_INVALID_POLICY = 4422;
    public const ERROR_SECUREBOOT_POLICY_PUBLISHER_NOT_FOUND = 4423;
    public const ERROR_SECUREBOOT_POLICY_NOT_SIGNED = 4424;
    public const ERROR_SECUREBOOT_NOT_ENABLED = 4425;
    public const ERROR_SECUREBOOT_FILE_REPLACED = 4426;
    public const ERROR_OFFLOAD_READ_FLT_NOT_SUPPORTED = 4440;
    public const ERROR_OFFLOAD_WRITE_FLT_NOT_SUPPORTED = 4441;
    public const ERROR_OFFLOAD_READ_FILE_NOT_SUPPORTED = 4442;
    public const ERROR_OFFLOAD_WRITE_FILE_NOT_SUPPORTED = 4443;
    public const ERROR_VOLUME_NOT_SIS_ENABLED = 4500;
    public const ERROR_DEPENDENT_RESOURCE_EXISTS = 5001;
    public const ERROR_DEPENDENCY_NOT_FOUND = 5002;
    public const ERROR_DEPENDENCY_ALREADY_EXISTS = 5003;
    public const ERROR_RESOURCE_NOT_ONLINE = 5004;
    public const ERROR_HOST_NODE_NOT_AVAILABLE = 5005;
    public const ERROR_RESOURCE_NOT_AVAILABLE = 5006;
    public const ERROR_RESOURCE_NOT_FOUND = 5007;
    public const ERROR_SHUTDOWN_CLUSTER = 5008;
    public const ERROR_CANT_EVICT_ACTIVE_NODE = 5009;
    public const ERROR_OBJECT_ALREADY_EXISTS = 5010;
    public const ERROR_OBJECT_IN_LIST = 5011;
    public const ERROR_GROUP_NOT_AVAILABLE = 5012;
    public const ERROR_GROUP_NOT_FOUND = 5013;
    public const ERROR_GROUP_NOT_ONLINE = 5014;
    public const ERROR_HOST_NODE_NOT_RESOURCE_OWNER = 5015;
    public const ERROR_HOST_NODE_NOT_GROUP_OWNER = 5016;
    public const ERROR_RESMON_CREATE_FAILED = 5017;
    public const ERROR_RESMON_ONLINE_FAILED = 5018;
    public const ERROR_RESOURCE_ONLINE = 5019;
    public const ERROR_QUORUM_RESOURCE = 5020;
    public const ERROR_NOT_QUORUM_CAPABLE = 5021;
    public const ERROR_CLUSTER_SHUTTING_DOWN = 5022;
    public const ERROR_INVALID_STATE = 5023;
    public const ERROR_RESOURCE_PROPERTIES_STORED = 5024;
    public const ERROR_NOT_QUORUM_CLASS = 5025;
    public const ERROR_CORE_RESOURCE = 5026;
    public const ERROR_QUORUM_RESOURCE_ONLINE_FAILED = 5027;
    public const ERROR_QUORUMLOG_OPEN_FAILED = 5028;
    public const ERROR_CLUSTERLOG_CORRUPT = 5029;
    public const ERROR_CLUSTERLOG_RECORD_EXCEEDS_MAXSIZE = 5030;
    public const ERROR_CLUSTERLOG_EXCEEDS_MAXSIZE = 5031;
    public const ERROR_CLUSTERLOG_CHKPOINT_NOT_FOUND = 5032;
    public const ERROR_CLUSTERLOG_NOT_ENOUGH_SPACE = 5033;
    public const ERROR_QUORUM_OWNER_ALIVE = 5034;
    public const ERROR_NETWORK_NOT_AVAILABLE = 5035;
    public const ERROR_NODE_NOT_AVAILABLE = 5036;
    public const ERROR_ALL_NODES_NOT_AVAILABLE = 5037;
    public const ERROR_RESOURCE_FAILED = 5038;
    public const ERROR_CLUSTER_INVALID_NODE = 5039;
    public const ERROR_CLUSTER_NODE_EXISTS = 5040;
    public const ERROR_CLUSTER_JOIN_IN_PROGRESS = 5041;
    public const ERROR_CLUSTER_NODE_NOT_FOUND = 5042;
    public const ERROR_CLUSTER_LOCAL_NODE_NOT_FOUND = 5043;
    public const ERROR_CLUSTER_NETWORK_EXISTS = 5044;
    public const ERROR_CLUSTER_NETWORK_NOT_FOUND = 5045;
    public const ERROR_CLUSTER_NETINTERFACE_EXISTS = 5046;
    public const ERROR_CLUSTER_NETINTERFACE_NOT_FOUND = 5047;
    public const ERROR_CLUSTER_INVALID_REQUEST = 5048;
    public const ERROR_CLUSTER_INVALID_NETWORK_PROVIDER = 5049;
    public const ERROR_CLUSTER_NODE_DOWN = 5050;
    public const ERROR_CLUSTER_NODE_UNREACHABLE = 5051;
    public const ERROR_CLUSTER_NODE_NOT_MEMBER = 5052;
    public const ERROR_CLUSTER_JOIN_NOT_IN_PROGRESS = 5053;
    public const ERROR_CLUSTER_INVALID_NETWORK = 5054;
    public const ERROR_CLUSTER_NODE_UP = 5056;
    public const ERROR_CLUSTER_IPADDR_IN_USE = 5057;
    public const ERROR_CLUSTER_NODE_NOT_PAUSED = 5058;
    public const ERROR_CLUSTER_NO_SECURITY_CONTEXT = 5059;
    public const ERROR_CLUSTER_NETWORK_NOT_INTERNAL = 5060;
    public const ERROR_CLUSTER_NODE_ALREADY_UP = 5061;
    public const ERROR_CLUSTER_NODE_ALREADY_DOWN = 5062;
    public const ERROR_CLUSTER_NETWORK_ALREADY_ONLINE = 5063;
    public const ERROR_CLUSTER_NETWORK_ALREADY_OFFLINE = 5064;
    public const ERROR_CLUSTER_NODE_ALREADY_MEMBER = 5065;
    public const ERROR_CLUSTER_LAST_INTERNAL_NETWORK = 5066;
    public const ERROR_CLUSTER_NETWORK_HAS_DEPENDENTS = 5067;
    public const ERROR_INVALID_OPERATION_ON_QUORUM = 5068;
    public const ERROR_DEPENDENCY_NOT_ALLOWED = 5069;
    public const ERROR_CLUSTER_NODE_PAUSED = 5070;
    public const ERROR_NODE_CANT_HOST_RESOURCE = 5071;
    public const ERROR_CLUSTER_NODE_NOT_READY = 5072;
    public const ERROR_CLUSTER_NODE_SHUTTING_DOWN = 5073;
    public const ERROR_CLUSTER_JOIN_ABORTED = 5074;
    public const ERROR_CLUSTER_INCOMPATIBLE_VERSIONS = 5075;
    public const ERROR_CLUSTER_MAXNUM_OF_RESOURCES_EXCEEDED = 5076;
    public const ERROR_CLUSTER_SYSTEM_CONFIG_CHANGED = 5077;
    public const ERROR_CLUSTER_RESOURCE_TYPE_NOT_FOUND = 5078;
    public const ERROR_CLUSTER_RESTYPE_NOT_SUPPORTED = 5079;
    public const ERROR_CLUSTER_RESNAME_NOT_FOUND = 5080;
    public const ERROR_CLUSTER_NO_RPC_PACKAGES_REGISTERED = 5081;
    public const ERROR_CLUSTER_OWNER_NOT_IN_PREFLIST = 5082;
    public const ERROR_CLUSTER_DATABASE_SEQMISMATCH = 5083;
    public const ERROR_RESMON_INVALID_STATE = 5084;
    public const ERROR_CLUSTER_GUM_NOT_LOCKER = 5085;
    public const ERROR_QUORUM_DISK_NOT_FOUND = 5086;
    public const ERROR_DATABASE_BACKUP_CORRUPT = 5087;
    public const ERROR_CLUSTER_NODE_ALREADY_HAS_DFS_ROOT = 5088;
    public const ERROR_RESOURCE_PROPERTY_UNCHANGEABLE = 5089;
    public const ERROR_CLUSTER_MEMBERSHIP_INVALID_STATE = 5890;
    public const ERROR_CLUSTER_QUORUMLOG_NOT_FOUND = 5891;
    public const ERROR_CLUSTER_MEMBERSHIP_HALT = 5892;
    public const ERROR_CLUSTER_INSTANCE_ID_MISMATCH = 5893;
    public const ERROR_CLUSTER_NETWORK_NOT_FOUND_FOR_IP = 5894;
    public const ERROR_CLUSTER_PROPERTY_DATA_TYPE_MISMATCH = 5895;
    public const ERROR_CLUSTER_EVICT_WITHOUT_CLEANUP = 5896;
    public const ERROR_CLUSTER_PARAMETER_MISMATCH = 5897;
    public const ERROR_NODE_CANNOT_BE_CLUSTERED = 5898;
    public const ERROR_CLUSTER_WRONG_OS_VERSION = 5899;
    public const ERROR_CLUSTER_CANT_CREATE_DUP_CLUSTER_NAME = 5900;
    public const ERROR_CLUSCFG_ALREADY_COMMITTED = 5901;
    public const ERROR_CLUSCFG_ROLLBACK_FAILED = 5902;
    public const ERROR_CLUSCFG_SYSTEM_DISK_DRIVE_LETTER_CONFLICT = 5903;
    public const ERROR_CLUSTER_OLD_VERSION = 5904;
    public const ERROR_CLUSTER_MISMATCHED_COMPUTER_ACCT_NAME = 5905;
    public const ERROR_CLUSTER_NO_NET_ADAPTERS = 5906;
    public const ERROR_CLUSTER_POISONED = 5907;
    public const ERROR_CLUSTER_GROUP_MOVING = 5908;
    public const ERROR_CLUSTER_RESOURCE_TYPE_BUSY = 5909;
    public const ERROR_RESOURCE_CALL_TIMED_OUT = 5910;
    public const ERROR_INVALID_CLUSTER_IPV6_ADDRESS = 5911;
    public const ERROR_CLUSTER_INTERNAL_INVALID_FUNCTION = 5912;
    public const ERROR_CLUSTER_PARAMETER_OUT_OF_BOUNDS = 5913;
    public const ERROR_CLUSTER_PARTIAL_SEND = 5914;
    public const ERROR_CLUSTER_REGISTRY_INVALID_FUNCTION = 5915;
    public const ERROR_CLUSTER_INVALID_STRING_TERMINATION = 5916;
    public const ERROR_CLUSTER_INVALID_STRING_FORMAT = 5917;
    public const ERROR_CLUSTER_DATABASE_TRANSACTION_IN_PROGRESS = 5918;
    public const ERROR_CLUSTER_DATABASE_TRANSACTION_NOT_IN_PROGRESS = 5919;
    public const ERROR_CLUSTER_NULL_DATA = 5920;
    public const ERROR_CLUSTER_PARTIAL_READ = 5921;
    public const ERROR_CLUSTER_PARTIAL_WRITE = 5922;
    public const ERROR_CLUSTER_CANT_DESERIALIZE_DATA = 5923;
    public const ERROR_DEPENDENT_RESOURCE_PROPERTY_CONFLICT = 5924;
    public const ERROR_CLUSTER_NO_QUORUM = 5925;
    public const ERROR_CLUSTER_INVALID_IPV6_NETWORK = 5926;
    public const ERROR_CLUSTER_INVALID_IPV6_TUNNEL_NETWORK = 5927;
    public const ERROR_QUORUM_NOT_ALLOWED_IN_THIS_GROUP = 5928;
    public const ERROR_DEPENDENCY_TREE_TOO_COMPLEX = 5929;
    public const ERROR_EXCEPTION_IN_RESOURCE_CALL = 5930;
    public const ERROR_CLUSTER_RHS_FAILED_INITIALIZATION = 5931;
    public const ERROR_CLUSTER_NOT_INSTALLED = 5932;
    public const ERROR_CLUSTER_RESOURCES_MUST_BE_ONLINE_ON_THE_SAME_NODE = 5933;
    public const ERROR_CLUSTER_MAX_NODES_IN_CLUSTER = 5934;
    public const ERROR_CLUSTER_TOO_MANY_NODES = 5935;
    public const ERROR_CLUSTER_OBJECT_ALREADY_USED = 5936;
    public const ERROR_NONCORE_GROUPS_FOUND = 5937;
    public const ERROR_FILE_SHARE_RESOURCE_CONFLICT = 5938;
    public const ERROR_CLUSTER_EVICT_INVALID_REQUEST = 5939;
    public const ERROR_CLUSTER_SINGLETON_RESOURCE = 5940;
    public const ERROR_CLUSTER_GROUP_SINGLETON_RESOURCE = 5941;
    public const ERROR_CLUSTER_RESOURCE_PROVIDER_FAILED = 5942;
    public const ERROR_CLUSTER_RESOURCE_CONFIGURATION_ERROR = 5943;
    public const ERROR_CLUSTER_GROUP_BUSY = 5944;
    public const ERROR_CLUSTER_NOT_SHARED_VOLUME = 5945;
    public const ERROR_CLUSTER_INVALID_SECURITY_DESCRIPTOR = 5946;
    public const ERROR_CLUSTER_SHARED_VOLUMES_IN_USE = 5947;
    public const ERROR_CLUSTER_USE_SHARED_VOLUMES_API = 5948;
    public const ERROR_CLUSTER_BACKUP_IN_PROGRESS = 5949;
    public const ERROR_NON_CSV_PATH = 5950;
    public const ERROR_CSV_VOLUME_NOT_LOCAL = 5951;
    public const ERROR_CLUSTER_WATCHDOG_TERMINATING = 5952;
    public const ERROR_CLUSTER_RESOURCE_VETOED_MOVE_INCOMPATIBLE_NODES = 5953;
    public const ERROR_CLUSTER_INVALID_NODE_WEIGHT = 5954;
    public const ERROR_CLUSTER_RESOURCE_VETOED_CALL = 5955;
    public const ERROR_RESMON_SYSTEM_RESOURCES_LACKING = 5956;
    public const ERROR_CLUSTER_RESOURCE_VETOED_MOVE_NOT_ENOUGH_RESOURCES_ON_DESTINATION = 5957;
    public const ERROR_CLUSTER_RESOURCE_VETOED_MOVE_NOT_ENOUGH_RESOURCES_ON_SOURCE = 5958;
    public const ERROR_CLUSTER_GROUP_QUEUED = 5959;
    public const ERROR_CLUSTER_RESOURCE_LOCKED_STATUS = 5960;
    public const ERROR_CLUSTER_SHARED_VOLUME_FAILOVER_NOT_ALLOWED = 5961;
    public const ERROR_CLUSTER_NODE_DRAIN_IN_PROGRESS = 5962;
    public const ERROR_CLUSTER_DISK_NOT_CONNECTED = 5963;
    public const ERROR_DISK_NOT_CSV_CAPABLE = 5964;
    public const ERROR_RESOURCE_NOT_IN_AVAILABLE_STORAGE = 5965;
    public const ERROR_CLUSTER_SHARED_VOLUME_REDIRECTED = 5966;
    public const ERROR_CLUSTER_SHARED_VOLUME_NOT_REDIRECTED = 5967;
    public const ERROR_CLUSTER_CANNOT_RETURN_PROPERTIES = 5968;
    public const ERROR_CLUSTER_RESOURCE_CONTAINS_UNSUPPORTED_DIFF_AREA_FOR_SHARED_VOLUMES = 5969;
    public const ERROR_CLUSTER_RESOURCE_IS_IN_MAINTENANCE_MODE = 5970;
    public const ERROR_CLUSTER_AFFINITY_CONFLICT = 5971;
    public const ERROR_CLUSTER_RESOURCE_IS_REPLICA_VIRTUAL_MACHINE = 5972;
    public const ERROR_ENCRYPTION_FAILED = 6000;
    public const ERROR_DECRYPTION_FAILED = 6001;
    public const ERROR_FILE_ENCRYPTED = 6002;
    public const ERROR_NO_RECOVERY_POLICY = 6003;
    public const ERROR_NO_EFS = 6004;
    public const ERROR_WRONG_EFS = 6005;
    public const ERROR_NO_USER_KEYS = 6006;
    public const ERROR_FILE_NOT_ENCRYPTED = 6007;
    public const ERROR_NOT_EXPORT_FORMAT = 6008;
    public const ERROR_FILE_READ_ONLY = 6009;
    public const ERROR_DIR_EFS_DISALLOWED = 6010;
    public const ERROR_EFS_SERVER_NOT_TRUSTED = 6011;
    public const ERROR_BAD_RECOVERY_POLICY = 6012;
    public const ERROR_EFS_ALG_BLOB_TOO_BIG = 6013;
    public const ERROR_VOLUME_NOT_SUPPORT_EFS = 6014;
    public const ERROR_EFS_DISABLED = 6015;
    public const ERROR_EFS_VERSION_NOT_SUPPORT = 6016;
    public const ERROR_CS_ENCRYPTION_INVALID_SERVER_RESPONSE = 6017;
    public const ERROR_CS_ENCRYPTION_UNSUPPORTED_SERVER = 6018;
    public const ERROR_CS_ENCRYPTION_EXISTING_ENCRYPTED_FILE = 6019;
    public const ERROR_CS_ENCRYPTION_NEW_ENCRYPTED_FILE = 6020;
    public const ERROR_CS_ENCRYPTION_FILE_NOT_CSE = 6021;
    public const ERROR_ENCRYPTION_POLICY_DENIES_OPERATION = 6022;
    public const ERROR_NO_BROWSER_SERVERS_FOUND = 6118;
    public const SCHED_E_SERVICE_NOT_LOCALSYSTEM = 6200;
    public const ERROR_LOG_SECTOR_INVALID = 6600;
    public const ERROR_LOG_SECTOR_PARITY_INVALID = 6601;
    public const ERROR_LOG_SECTOR_REMAPPED = 6602;
    public const ERROR_LOG_BLOCK_INCOMPLETE = 6603;
    public const ERROR_LOG_INVALID_RANGE = 6604;
    public const ERROR_LOG_BLOCKS_EXHAUSTED = 6605;
    public const ERROR_LOG_READ_CONTEXT_INVALID = 6606;
    public const ERROR_LOG_RESTART_INVALID = 6607;
    public const ERROR_LOG_BLOCK_VERSION = 6608;
    public const ERROR_LOG_BLOCK_INVALID = 6609;
    public const ERROR_LOG_READ_MODE_INVALID = 6610;
    public const ERROR_LOG_NO_RESTART = 6611;
    public const ERROR_LOG_METADATA_CORRUPT = 6612;
    public const ERROR_LOG_METADATA_INVALID = 6613;
    public const ERROR_LOG_METADATA_INCONSISTENT = 6614;
    public const ERROR_LOG_RESERVATION_INVALID = 6615;
    public const ERROR_LOG_CANT_DELETE = 6616;
    public const ERROR_LOG_CONTAINER_LIMIT_EXCEEDED = 6617;
    public const ERROR_LOG_START_OF_LOG = 6618;
    public const ERROR_LOG_POLICY_ALREADY_INSTALLED = 6619;
    public const ERROR_LOG_POLICY_NOT_INSTALLED = 6620;
    public const ERROR_LOG_POLICY_INVALID = 6621;
    public const ERROR_LOG_POLICY_CONFLICT = 6622;
    public const ERROR_LOG_PINNED_ARCHIVE_TAIL = 6623;
    public const ERROR_LOG_RECORD_NONEXISTENT = 6624;
    public const ERROR_LOG_RECORDS_RESERVED_INVALID = 6625;
    public const ERROR_LOG_SPACE_RESERVED_INVALID = 6626;
    public const ERROR_LOG_TAIL_INVALID = 6627;
    public const ERROR_LOG_FULL = 6628;
    public const ERROR_COULD_NOT_RESIZE_LOG = 6629;
    public const ERROR_LOG_MULTIPLEXED = 6630;
    public const ERROR_LOG_DEDICATED = 6631;
    public const ERROR_LOG_ARCHIVE_NOT_IN_PROGRESS = 6632;
    public const ERROR_LOG_ARCHIVE_IN_PROGRESS = 6633;
    public const ERROR_LOG_EPHEMERAL = 6634;
    public const ERROR_LOG_NOT_ENOUGH_CONTAINERS = 6635;
    public const ERROR_LOG_CLIENT_ALREADY_REGISTERED = 6636;
    public const ERROR_LOG_CLIENT_NOT_REGISTERED = 6637;
    public const ERROR_LOG_FULL_HANDLER_IN_PROGRESS = 6638;
    public const ERROR_LOG_CONTAINER_READ_FAILED = 6639;
    public const ERROR_LOG_CONTAINER_WRITE_FAILED = 6640;
    public const ERROR_LOG_CONTAINER_OPEN_FAILED = 6641;
    public const ERROR_LOG_CONTAINER_STATE_INVALID = 6642;
    public const ERROR_LOG_STATE_INVALID = 6643;
    public const ERROR_LOG_PINNED = 6644;
    public const ERROR_LOG_METADATA_FLUSH_FAILED = 6645;
    public const ERROR_LOG_INCONSISTENT_SECURITY = 6646;
    public const ERROR_LOG_APPENDED_FLUSH_FAILED = 6647;
    public const ERROR_LOG_PINNED_RESERVATION = 6648;
    public const ERROR_INVALID_TRANSACTION = 6700;
    public const ERROR_TRANSACTION_NOT_ACTIVE = 6701;
    public const ERROR_TRANSACTION_REQUEST_NOT_VALID = 6702;
    public const ERROR_TRANSACTION_NOT_REQUESTED = 6703;
    public const ERROR_TRANSACTION_ALREADY_ABORTED = 6704;
    public const ERROR_TRANSACTION_ALREADY_COMMITTED = 6705;
    public const ERROR_TM_INITIALIZATION_FAILED = 6706;
    public const ERROR_RESOURCEMANAGER_READ_ONLY = 6707;
    public const ERROR_TRANSACTION_NOT_JOINED = 6708;
    public const ERROR_TRANSACTION_SUPERIOR_EXISTS = 6709;
    public const ERROR_CRM_PROTOCOL_ALREADY_EXISTS = 6710;
    public const ERROR_TRANSACTION_PROPAGATION_FAILED = 6711;
    public const ERROR_CRM_PROTOCOL_NOT_FOUND = 6712;
    public const ERROR_TRANSACTION_INVALID_MARSHALL_BUFFER = 6713;
    public const ERROR_CURRENT_TRANSACTION_NOT_VALID = 6714;
    public const ERROR_TRANSACTION_NOT_FOUND = 6715;
    public const ERROR_RESOURCEMANAGER_NOT_FOUND = 6716;
    public const ERROR_ENLISTMENT_NOT_FOUND = 6717;
    public const ERROR_TRANSACTIONMANAGER_NOT_FOUND = 6718;
    public const ERROR_TRANSACTIONMANAGER_NOT_ONLINE = 6719;
    public const ERROR_TRANSACTIONMANAGER_RECOVERY_NAME_COLLISION = 6720;
    public const ERROR_TRANSACTION_NOT_ROOT = 6721;
    public const ERROR_TRANSACTION_OBJECT_EXPIRED = 6722;
    public const ERROR_TRANSACTION_RESPONSE_NOT_ENLISTED = 6723;
    public const ERROR_TRANSACTION_RECORD_TOO_LONG = 6724;
    public const ERROR_IMPLICIT_TRANSACTION_NOT_SUPPORTED = 6725;
    public const ERROR_TRANSACTION_INTEGRITY_VIOLATED = 6726;
    public const ERROR_TRANSACTIONMANAGER_IDENTITY_MISMATCH = 6727;
    public const ERROR_RM_CANNOT_BE_FROZEN_FOR_SNAPSHOT = 6728;
    public const ERROR_TRANSACTION_MUST_WRITETHROUGH = 6729;
    public const ERROR_TRANSACTION_NO_SUPERIOR = 6730;
    public const ERROR_HEURISTIC_DAMAGE_POSSIBLE = 6731;
    public const ERROR_TRANSACTIONAL_CONFLICT = 6800;
    public const ERROR_RM_NOT_ACTIVE = 6801;
    public const ERROR_RM_METADATA_CORRUPT = 6802;
    public const ERROR_DIRECTORY_NOT_RM = 6803;
    public const ERROR_TRANSACTIONS_UNSUPPORTED_REMOTE = 6805;
    public const ERROR_LOG_RESIZE_INVALID_SIZE = 6806;
    public const ERROR_OBJECT_NO_LONGER_EXISTS = 6807;
    public const ERROR_STREAM_MINIVERSION_NOT_FOUND = 6808;
    public const ERROR_STREAM_MINIVERSION_NOT_VALID = 6809;
    public const ERROR_MINIVERSION_INACCESSIBLE_FROM_SPECIFIED_TRANSACTION = 6810;
    public const ERROR_CANT_OPEN_MINIVERSION_WITH_MODIFY_INTENT = 6811;
    public const ERROR_CANT_CREATE_MORE_STREAM_MINIVERSIONS = 6812;
    public const ERROR_REMOTE_FILE_VERSION_MISMATCH = 6814;
    public const ERROR_HANDLE_NO_LONGER_VALID = 6815;
    public const ERROR_NO_TXF_METADATA = 6816;
    public const ERROR_LOG_CORRUPTION_DETECTED = 6817;
    public const ERROR_CANT_RECOVER_WITH_HANDLE_OPEN = 6818;
    public const ERROR_RM_DISCONNECTED = 6819;
    public const ERROR_ENLISTMENT_NOT_SUPERIOR = 6820;
    public const ERROR_RECOVERY_NOT_NEEDED = 6821;
    public const ERROR_RM_ALREADY_STARTED = 6822;
    public const ERROR_FILE_IDENTITY_NOT_PERSISTENT = 6823;
    public const ERROR_CANT_BREAK_TRANSACTIONAL_DEPENDENCY = 6824;
    public const ERROR_CANT_CROSS_RM_BOUNDARY = 6825;
    public const ERROR_TXF_DIR_NOT_EMPTY = 6826;
    public const ERROR_INDOUBT_TRANSACTIONS_EXIST = 6827;
    public const ERROR_TM_VOLATILE = 6828;
    public const ERROR_ROLLBACK_TIMER_EXPIRED = 6829;
    public const ERROR_TXF_ATTRIBUTE_CORRUPT = 6830;
    public const ERROR_EFS_NOT_ALLOWED_IN_TRANSACTION = 6831;
    public const ERROR_TRANSACTIONAL_OPEN_NOT_ALLOWED = 6832;
    public const ERROR_LOG_GROWTH_FAILED = 6833;
    public const ERROR_TRANSACTED_MAPPING_UNSUPPORTED_REMOTE = 6834;
    public const ERROR_TXF_METADATA_ALREADY_PRESENT = 6835;
    public const ERROR_TRANSACTION_SCOPE_CALLBACKS_NOT_SET = 6836;
    public const ERROR_TRANSACTION_REQUIRED_PROMOTION = 6837;
    public const ERROR_CANNOT_EXECUTE_FILE_IN_TRANSACTION = 6838;
    public const ERROR_TRANSACTIONS_NOT_FROZEN = 6839;
    public const ERROR_TRANSACTION_FREEZE_IN_PROGRESS = 6840;
    public const ERROR_NOT_SNAPSHOT_VOLUME = 6841;
    public const ERROR_NO_SAVEPOINT_WITH_OPEN_FILES = 6842;
    public const ERROR_DATA_LOST_REPAIR = 6843;
    public const ERROR_SPARSE_NOT_ALLOWED_IN_TRANSACTION = 6844;
    public const ERROR_TM_IDENTITY_MISMATCH = 6845;
    public const ERROR_FLOATED_SECTION = 6846;
    public const ERROR_CANNOT_ACCEPT_TRANSACTED_WORK = 6847;
    public const ERROR_CANNOT_ABORT_TRANSACTIONS = 6848;
    public const ERROR_BAD_CLUSTERS = 6849;
    public const ERROR_COMPRESSION_NOT_ALLOWED_IN_TRANSACTION = 6850;
    public const ERROR_VOLUME_DIRTY = 6851;
    public const ERROR_NO_LINK_TRACKING_IN_TRANSACTION = 6852;
    public const ERROR_OPERATION_NOT_SUPPORTED_IN_TRANSACTION = 6853;
    public const ERROR_EXPIRED_HANDLE = 6854;
    public const ERROR_TRANSACTION_NOT_ENLISTED = 6855;
    public const ERROR_CTX_WINSTATION_NAME_INVALID = 7001;
    public const ERROR_CTX_INVALID_PD = 7002;
    public const ERROR_CTX_PD_NOT_FOUND = 7003;
    public const ERROR_CTX_WD_NOT_FOUND = 7004;
    public const ERROR_CTX_CANNOT_MAKE_EVENTLOG_ENTRY = 7005;
    public const ERROR_CTX_SERVICE_NAME_COLLISION = 7006;
    public const ERROR_CTX_CLOSE_PENDING = 7007;
    public const ERROR_CTX_NO_OUTBUF = 7008;
    public const ERROR_CTX_MODEM_INF_NOT_FOUND = 7009;
    public const ERROR_CTX_INVALID_MODEMNAME = 7010;
    public const ERROR_CTX_MODEM_RESPONSE_ERROR = 7011;
    public const ERROR_CTX_MODEM_RESPONSE_TIMEOUT = 7012;
    public const ERROR_CTX_MODEM_RESPONSE_NO_CARRIER = 7013;
    public const ERROR_CTX_MODEM_RESPONSE_NO_DIALTONE = 7014;
    public const ERROR_CTX_MODEM_RESPONSE_BUSY = 7015;
    public const ERROR_CTX_MODEM_RESPONSE_VOICE = 7016;
    public const ERROR_CTX_TD_ERROR = 7017;
    public const ERROR_CTX_WINSTATION_NOT_FOUND = 7022;
    public const ERROR_CTX_WINSTATION_ALREADY_EXISTS = 7023;
    public const ERROR_CTX_WINSTATION_BUSY = 7024;
    public const ERROR_CTX_BAD_VIDEO_MODE = 7025;
    public const ERROR_CTX_GRAPHICS_INVALID = 7035;
    public const ERROR_CTX_LOGON_DISABLED = 7037;
    public const ERROR_CTX_NOT_CONSOLE = 7038;
    public const ERROR_CTX_CLIENT_QUERY_TIMEOUT = 7040;
    public const ERROR_CTX_CONSOLE_DISCONNECT = 7041;
    public const ERROR_CTX_CONSOLE_CONNECT = 7042;
    public const ERROR_CTX_SHADOW_DENIED = 7044;
    public const ERROR_CTX_WINSTATION_ACCESS_DENIED = 7045;
    public const ERROR_CTX_INVALID_WD = 7049;
    public const ERROR_CTX_SHADOW_INVALID = 7050;
    public const ERROR_CTX_SHADOW_DISABLED = 7051;
    public const ERROR_CTX_CLIENT_LICENSE_IN_USE = 7052;
    public const ERROR_CTX_CLIENT_LICENSE_NOT_SET = 7053;
    public const ERROR_CTX_LICENSE_NOT_AVAILABLE = 7054;
    public const ERROR_CTX_LICENSE_CLIENT_INVALID = 7055;
    public const ERROR_CTX_LICENSE_EXPIRED = 7056;
    public const ERROR_CTX_SHADOW_NOT_RUNNING = 7057;
    public const ERROR_CTX_SHADOW_ENDED_BY_MODE_CHANGE = 7058;
    public const ERROR_ACTIVATION_COUNT_EXCEEDED = 7059;
    public const ERROR_CTX_WINSTATIONS_DISABLED = 7060;
    public const ERROR_CTX_ENCRYPTION_LEVEL_REQUIRED = 7061;
    public const ERROR_CTX_SESSION_IN_USE = 7062;
    public const ERROR_CTX_NO_FORCE_LOGOFF = 7063;
    public const ERROR_CTX_ACCOUNT_RESTRICTION = 7064;
    public const ERROR_RDP_PROTOCOL_ERROR = 7065;
    public const ERROR_CTX_CDM_CONNECT = 7066;
    public const ERROR_CTX_CDM_DISCONNECT = 7067;
    public const ERROR_CTX_SECURITY_LAYER_ERROR = 7068;
    public const ERROR_TS_INCOMPATIBLE_SESSIONS = 7069;
    public const ERROR_TS_VIDEO_SUBSYSTEM_ERROR = 7070;
    public const FRS_ERR_INVALID_API_SEQUENCE = 8001;
    public const FRS_ERR_STARTING_SERVICE = 8002;
    public const FRS_ERR_STOPPING_SERVICE = 8003;
    public const FRS_ERR_INTERNAL_API = 8004;
    public const FRS_ERR_INTERNAL = 8005;
    public const FRS_ERR_SERVICE_COMM = 8006;
    public const FRS_ERR_INSUFFICIENT_PRIV = 8007;
    public const FRS_ERR_AUTHENTICATION = 8008;
    public const FRS_ERR_PARENT_INSUFFICIENT_PRIV = 8009;
    public const FRS_ERR_PARENT_AUTHENTICATION = 8010;
    public const FRS_ERR_CHILD_TO_PARENT_COMM = 8011;
    public const FRS_ERR_PARENT_TO_CHILD_COMM = 8012;
    public const FRS_ERR_SYSVOL_POPULATE = 8013;
    public const FRS_ERR_SYSVOL_POPULATE_TIMEOUT = 8014;
    public const FRS_ERR_SYSVOL_IS_BUSY = 8015;
    public const FRS_ERR_SYSVOL_DEMOTE = 8016;
    public const FRS_ERR_INVALID_SERVICE_PARAMETER = 8017;
    public const ERROR_DS_NOT_INSTALLED = 8200;
    public const ERROR_DS_MEMBERSHIP_EVALUATED_LOCALLY = 8201;
    public const ERROR_DS_NO_ATTRIBUTE_OR_VALUE = 8202;
    public const ERROR_DS_INVALID_ATTRIBUTE_SYNTAX = 8203;
    public const ERROR_DS_ATTRIBUTE_TYPE_UNDEFINED = 8204;
    public const ERROR_DS_ATTRIBUTE_OR_VALUE_EXISTS = 8205;
    public const ERROR_DS_BUSY = 8206;
    public const ERROR_DS_UNAVAILABLE = 8207;
    public const ERROR_DS_NO_RIDS_ALLOCATED = 8208;
    public const ERROR_DS_NO_MORE_RIDS = 8209;
    public const ERROR_DS_INCORRECT_ROLE_OWNER = 8210;
    public const ERROR_DS_RIDMGR_INIT_ERROR = 8211;
    public const ERROR_DS_OBJ_CLASS_VIOLATION = 8212;
    public const ERROR_DS_CANT_ON_NON_LEAF = 8213;
    public const ERROR_DS_CANT_ON_RDN = 8214;
    public const ERROR_DS_CANT_MOD_OBJ_CLASS = 8215;
    public const ERROR_DS_CROSS_DOM_MOVE_ERROR = 8216;
    public const ERROR_DS_GC_NOT_AVAILABLE = 8217;
    public const ERROR_SHARED_POLICY = 8218;
    public const ERROR_POLICY_OBJECT_NOT_FOUND = 8219;
    public const ERROR_POLICY_ONLY_IN_DS = 8220;
    public const ERROR_PROMOTION_ACTIVE = 8221;
    public const ERROR_NO_PROMOTION_ACTIVE = 8222;
    public const ERROR_DS_OPERATIONS_ERROR = 8224;
    public const ERROR_DS_PROTOCOL_ERROR = 8225;
    public const ERROR_DS_TIMELIMIT_EXCEEDED = 8226;
    public const ERROR_DS_SIZELIMIT_EXCEEDED = 8227;
    public const ERROR_DS_ADMIN_LIMIT_EXCEEDED = 8228;
    public const ERROR_DS_COMPARE_FALSE = 8229;
    public const ERROR_DS_COMPARE_TRUE = 8230;
    public const ERROR_DS_AUTH_METHOD_NOT_SUPPORTED = 8231;
    public const ERROR_DS_STRONG_AUTH_REQUIRED = 8232;
    public const ERROR_DS_INAPPROPRIATE_AUTH = 8233;
    public const ERROR_DS_AUTH_UNKNOWN = 8234;
    public const ERROR_DS_REFERRAL = 8235;
    public const ERROR_DS_UNAVAILABLE_CRIT_EXTENSION = 8236;
    public const ERROR_DS_CONFIDENTIALITY_REQUIRED = 8237;
    public const ERROR_DS_INAPPROPRIATE_MATCHING = 8238;
    public const ERROR_DS_CONSTRAINT_VIOLATION = 8239;
    public const ERROR_DS_NO_SUCH_OBJECT = 8240;
    public const ERROR_DS_ALIAS_PROBLEM = 8241;
    public const ERROR_DS_INVALID_DN_SYNTAX = 8242;
    public const ERROR_DS_IS_LEAF = 8243;
    public const ERROR_DS_ALIAS_DEREF_PROBLEM = 8244;
    public const ERROR_DS_UNWILLING_TO_PERFORM = 8245;
    public const ERROR_DS_LOOP_DETECT = 8246;
    public const ERROR_DS_NAMING_VIOLATION = 8247;
    public const ERROR_DS_OBJECT_RESULTS_TOO_LARGE = 8248;
    public const ERROR_DS_AFFECTS_MULTIPLE_DSAS = 8249;
    public const ERROR_DS_SERVER_DOWN = 8250;
    public const ERROR_DS_LOCAL_ERROR = 8251;
    public const ERROR_DS_ENCODING_ERROR = 8252;
    public const ERROR_DS_DECODING_ERROR = 8253;
    public const ERROR_DS_FILTER_UNKNOWN = 8254;
    public const ERROR_DS_PARAM_ERROR = 8255;
    public const ERROR_DS_NOT_SUPPORTED = 8256;
    public const ERROR_DS_NO_RESULTS_RETURNED = 8257;
    public const ERROR_DS_CONTROL_NOT_FOUND = 8258;
    public const ERROR_DS_CLIENT_LOOP = 8259;
    public const ERROR_DS_REFERRAL_LIMIT_EXCEEDED = 8260;
    public const ERROR_DS_SORT_CONTROL_MISSING = 8261;
    public const ERROR_DS_OFFSET_RANGE_ERROR = 8262;
    public const ERROR_DS_RIDMGR_DISABLED = 8263;
    public const ERROR_DS_ROOT_MUST_BE_NC = 8301;
    public const ERROR_DS_ADD_REPLICA_INHIBITED = 8302;
    public const ERROR_DS_ATT_NOT_DEF_IN_SCHEMA = 8303;
    public const ERROR_DS_MAX_OBJ_SIZE_EXCEEDED = 8304;
    public const ERROR_DS_OBJ_STRING_NAME_EXISTS = 8305;
    public const ERROR_DS_NO_RDN_DEFINED_IN_SCHEMA = 8306;
    public const ERROR_DS_RDN_DOESNT_MATCH_SCHEMA = 8307;
    public const ERROR_DS_NO_REQUESTED_ATTS_FOUND = 8308;
    public const ERROR_DS_USER_BUFFER_TO_SMALL = 8309;
    public const ERROR_DS_ATT_IS_NOT_ON_OBJ = 8310;
    public const ERROR_DS_ILLEGAL_MOD_OPERATION = 8311;
    public const ERROR_DS_OBJ_TOO_LARGE = 8312;
    public const ERROR_DS_BAD_INSTANCE_TYPE = 8313;
    public const ERROR_DS_MASTERDSA_REQUIRED = 8314;
    public const ERROR_DS_OBJECT_CLASS_REQUIRED = 8315;
    public const ERROR_DS_MISSING_REQUIRED_ATT = 8316;
    public const ERROR_DS_ATT_NOT_DEF_FOR_CLASS = 8317;
    public const ERROR_DS_ATT_ALREADY_EXISTS = 8318;
    public const ERROR_DS_CANT_ADD_ATT_VALUES = 8320;
    public const ERROR_DS_SINGLE_VALUE_CONSTRAINT = 8321;
    public const ERROR_DS_RANGE_CONSTRAINT = 8322;
    public const ERROR_DS_ATT_VAL_ALREADY_EXISTS = 8323;
    public const ERROR_DS_CANT_REM_MISSING_ATT = 8324;
    public const ERROR_DS_CANT_REM_MISSING_ATT_VAL = 8325;
    public const ERROR_DS_ROOT_CANT_BE_SUBREF = 8326;
    public const ERROR_DS_NO_CHAINING = 8327;
    public const ERROR_DS_NO_CHAINED_EVAL = 8328;
    public const ERROR_DS_NO_PARENT_OBJECT = 8329;
    public const ERROR_DS_PARENT_IS_AN_ALIAS = 8330;
    public const ERROR_DS_CANT_MIX_MASTER_AND_REPS = 8331;
    public const ERROR_DS_CHILDREN_EXIST = 8332;
    public const ERROR_DS_OBJ_NOT_FOUND = 8333;
    public const ERROR_DS_ALIASED_OBJ_MISSING = 8334;
    public const ERROR_DS_BAD_NAME_SYNTAX = 8335;
    public const ERROR_DS_ALIAS_POINTS_TO_ALIAS = 8336;
    public const ERROR_DS_CANT_DEREF_ALIAS = 8337;
    public const ERROR_DS_OUT_OF_SCOPE = 8338;
    public const ERROR_DS_OBJECT_BEING_REMOVED = 8339;
    public const ERROR_DS_CANT_DELETE_DSA_OBJ = 8340;
    public const ERROR_DS_GENERIC_ERROR = 8341;
    public const ERROR_DS_DSA_MUST_BE_INT_MASTER = 8342;
    public const ERROR_DS_CLASS_NOT_DSA = 8343;
    public const ERROR_DS_INSUFF_ACCESS_RIGHTS = 8344;
    public const ERROR_DS_ILLEGAL_SUPERIOR = 8345;
    public const ERROR_DS_ATTRIBUTE_OWNED_BY_SAM = 8346;
    public const ERROR_DS_NAME_TOO_MANY_PARTS = 8347;
    public const ERROR_DS_NAME_TOO_LONG = 8348;
    public const ERROR_DS_NAME_VALUE_TOO_LONG = 8349;
    public const ERROR_DS_NAME_UNPARSEABLE = 8350;
    public const ERROR_DS_NAME_TYPE_UNKNOWN = 8351;
    public const ERROR_DS_NOT_AN_OBJECT = 8352;
    public const ERROR_DS_SEC_DESC_TOO_SHORT = 8353;
    public const ERROR_DS_SEC_DESC_INVALID = 8354;
    public const ERROR_DS_NO_DELETED_NAME = 8355;
    public const ERROR_DS_SUBREF_MUST_HAVE_PARENT = 8356;
    public const ERROR_DS_NCNAME_MUST_BE_NC = 8357;
    public const ERROR_DS_CANT_ADD_SYSTEM_ONLY = 8358;
    public const ERROR_DS_CLASS_MUST_BE_CONCRETE = 8359;
    public const ERROR_DS_INVALID_DMD = 8360;
    public const ERROR_DS_OBJ_GUID_EXISTS = 8361;
    public const ERROR_DS_NOT_ON_BACKLINK = 8362;
    public const ERROR_DS_NO_CROSSREF_FOR_NC = 8363;
    public const ERROR_DS_SHUTTING_DOWN = 8364;
    public const ERROR_DS_UNKNOWN_OPERATION = 8365;
    public const ERROR_DS_INVALID_ROLE_OWNER = 8366;
    public const ERROR_DS_COULDNT_CONTACT_FSMO = 8367;
    public const ERROR_DS_CROSS_NC_DN_RENAME = 8368;
    public const ERROR_DS_CANT_MOD_SYSTEM_ONLY = 8369;
    public const ERROR_DS_REPLICATOR_ONLY = 8370;
    public const ERROR_DS_OBJ_CLASS_NOT_DEFINED = 8371;
    public const ERROR_DS_OBJ_CLASS_NOT_SUBCLASS = 8372;
    public const ERROR_DS_NAME_REFERENCE_INVALID = 8373;
    public const ERROR_DS_CROSS_REF_EXISTS = 8374;
    public const ERROR_DS_CANT_DEL_MASTER_CROSSREF = 8375;
    public const ERROR_DS_SUBTREE_NOTIFY_NOT_NC_HEAD = 8376;
    public const ERROR_DS_NOTIFY_FILTER_TOO_COMPLEX = 8377;
    public const ERROR_DS_DUP_RDN = 8378;
    public const ERROR_DS_DUP_OID = 8379;
    public const ERROR_DS_DUP_MAPI_ID = 8380;
    public const ERROR_DS_DUP_SCHEMA_ID_GUID = 8381;
    public const ERROR_DS_DUP_LDAP_DISPLAY_NAME = 8382;
    public const ERROR_DS_SEMANTIC_ATT_TEST = 8383;
    public const ERROR_DS_SYNTAX_MISMATCH = 8384;
    public const ERROR_DS_EXISTS_IN_MUST_HAVE = 8385;
    public const ERROR_DS_EXISTS_IN_MAY_HAVE = 8386;
    public const ERROR_DS_NONEXISTENT_MAY_HAVE = 8387;
    public const ERROR_DS_NONEXISTENT_MUST_HAVE = 8388;
    public const ERROR_DS_AUX_CLS_TEST_FAIL = 8389;
    public const ERROR_DS_NONEXISTENT_POSS_SUP = 8390;
    public const ERROR_DS_SUB_CLS_TEST_FAIL = 8391;
    public const ERROR_DS_BAD_RDN_ATT_ID_SYNTAX = 8392;
    public const ERROR_DS_EXISTS_IN_AUX_CLS = 8393;
    public const ERROR_DS_EXISTS_IN_SUB_CLS = 8394;
    public const ERROR_DS_EXISTS_IN_POSS_SUP = 8395;
    public const ERROR_DS_RECALCSCHEMA_FAILED = 8396;
    public const ERROR_DS_TREE_DELETE_NOT_FINISHED = 8397;
    public const ERROR_DS_CANT_DELETE = 8398;
    public const ERROR_DS_ATT_SCHEMA_REQ_ID = 8399;
    public const ERROR_DS_BAD_ATT_SCHEMA_SYNTAX = 8400;
    public const ERROR_DS_CANT_CACHE_ATT = 8401;
    public const ERROR_DS_CANT_CACHE_CLASS = 8402;
    public const ERROR_DS_CANT_REMOVE_ATT_CACHE = 8403;
    public const ERROR_DS_CANT_REMOVE_CLASS_CACHE = 8404;
    public const ERROR_DS_CANT_RETRIEVE_DN = 8405;
    public const ERROR_DS_MISSING_SUPREF = 8406;
    public const ERROR_DS_CANT_RETRIEVE_INSTANCE = 8407;
    public const ERROR_DS_CODE_INCONSISTENCY = 8408;
    public const ERROR_DS_DATABASE_ERROR = 8409;
    public const ERROR_DS_GOVERNSID_MISSING = 8410;
    public const ERROR_DS_MISSING_EXPECTED_ATT = 8411;
    public const ERROR_DS_NCNAME_MISSING_CR_REF = 8412;
    public const ERROR_DS_SECURITY_CHECKING_ERROR = 8413;
    public const ERROR_DS_SCHEMA_NOT_LOADED = 8414;
    public const ERROR_DS_SCHEMA_ALLOC_FAILED = 8415;
    public const ERROR_DS_ATT_SCHEMA_REQ_SYNTAX = 8416;
    public const ERROR_DS_GCVERIFY_ERROR = 8417;
    public const ERROR_DS_DRA_SCHEMA_MISMATCH = 8418;
    public const ERROR_DS_CANT_FIND_DSA_OBJ = 8419;
    public const ERROR_DS_CANT_FIND_EXPECTED_NC = 8420;
    public const ERROR_DS_CANT_FIND_NC_IN_CACHE = 8421;
    public const ERROR_DS_CANT_RETRIEVE_CHILD = 8422;
    public const ERROR_DS_SECURITY_ILLEGAL_MODIFY = 8423;
    public const ERROR_DS_CANT_REPLACE_HIDDEN_REC = 8424;
    public const ERROR_DS_BAD_HIERARCHY_FILE = 8425;
    public const ERROR_DS_BUILD_HIERARCHY_TABLE_FAILED = 8426;
    public const ERROR_DS_CONFIG_PARAM_MISSING = 8427;
    public const ERROR_DS_COUNTING_AB_INDICES_FAILED = 8428;
    public const ERROR_DS_HIERARCHY_TABLE_MALLOC_FAILED = 8429;
    public const ERROR_DS_INTERNAL_FAILURE = 8430;
    public const ERROR_DS_UNKNOWN_ERROR = 8431;
    public const ERROR_DS_ROOT_REQUIRES_CLASS_TOP = 8432;
    public const ERROR_DS_REFUSING_FSMO_ROLES = 8433;
    public const ERROR_DS_MISSING_FSMO_SETTINGS = 8434;
    public const ERROR_DS_UNABLE_TO_SURRENDER_ROLES = 8435;
    public const ERROR_DS_DRA_GENERIC = 8436;
    public const ERROR_DS_DRA_INVALID_PARAMETER = 8437;
    public const ERROR_DS_DRA_BUSY = 8438;
    public const ERROR_DS_DRA_BAD_DN = 8439;
    public const ERROR_DS_DRA_BAD_NC = 8440;
    public const ERROR_DS_DRA_DN_EXISTS = 8441;
    public const ERROR_DS_DRA_INTERNAL_ERROR = 8442;
    public const ERROR_DS_DRA_INCONSISTENT_DIT = 8443;
    public const ERROR_DS_DRA_CONNECTION_FAILED = 8444;
    public const ERROR_DS_DRA_BAD_INSTANCE_TYPE = 8445;
    public const ERROR_DS_DRA_OUT_OF_MEM = 8446;
    public const ERROR_DS_DRA_MAIL_PROBLEM = 8447;
    public const ERROR_DS_DRA_REF_ALREADY_EXISTS = 8448;
    public const ERROR_DS_DRA_REF_NOT_FOUND = 8449;
    public const ERROR_DS_DRA_OBJ_IS_REP_SOURCE = 8450;
    public const ERROR_DS_DRA_DB_ERROR = 8451;
    public const ERROR_DS_DRA_NO_REPLICA = 8452;
    public const ERROR_DS_DRA_ACCESS_DENIED = 8453;
    public const ERROR_DS_DRA_NOT_SUPPORTED = 8454;
    public const ERROR_DS_DRA_RPC_CANCELLED = 8455;
    public const ERROR_DS_DRA_SOURCE_DISABLED = 8456;
    public const ERROR_DS_DRA_SINK_DISABLED = 8457;
    public const ERROR_DS_DRA_NAME_COLLISION = 8458;
    public const ERROR_DS_DRA_SOURCE_REINSTALLED = 8459;
    public const ERROR_DS_DRA_MISSING_PARENT = 8460;
    public const ERROR_DS_DRA_PREEMPTED = 8461;
    public const ERROR_DS_DRA_ABANDON_SYNC = 8462;
    public const ERROR_DS_DRA_SHUTDOWN = 8463;
    public const ERROR_DS_DRA_INCOMPATIBLE_PARTIAL_SET = 8464;
    public const ERROR_DS_DRA_SOURCE_IS_PARTIAL_REPLICA = 8465;
    public const ERROR_DS_DRA_EXTN_CONNECTION_FAILED = 8466;
    public const ERROR_DS_INSTALL_SCHEMA_MISMATCH = 8467;
    public const ERROR_DS_DUP_LINK_ID = 8468;
    public const ERROR_DS_NAME_ERROR_RESOLVING = 8469;
    public const ERROR_DS_NAME_ERROR_NOT_FOUND = 8470;
    public const ERROR_DS_NAME_ERROR_NOT_UNIQUE = 8471;
    public const ERROR_DS_NAME_ERROR_NO_MAPPING = 8472;
    public const ERROR_DS_NAME_ERROR_DOMAIN_ONLY = 8473;
    public const ERROR_DS_NAME_ERROR_NO_SYNTACTICAL_MAPPING = 8474;
    public const ERROR_DS_CONSTRUCTED_ATT_MOD = 8475;
    public const ERROR_DS_WRONG_OM_OBJ_CLASS = 8476;
    public const ERROR_DS_DRA_REPL_PENDING = 8477;
    public const ERROR_DS_DS_REQUIRED = 8478;
    public const ERROR_DS_INVALID_LDAP_DISPLAY_NAME = 8479;
    public const ERROR_DS_NON_BASE_SEARCH = 8480;
    public const ERROR_DS_CANT_RETRIEVE_ATTS = 8481;
    public const ERROR_DS_BACKLINK_WITHOUT_LINK = 8482;
    public const ERROR_DS_EPOCH_MISMATCH = 8483;
    public const ERROR_DS_SRC_NAME_MISMATCH = 8484;
    public const ERROR_DS_SRC_AND_DST_NC_IDENTICAL = 8485;
    public const ERROR_DS_DST_NC_MISMATCH = 8486;
    public const ERROR_DS_NOT_AUTHORITIVE_FOR_DST_NC = 8487;
    public const ERROR_DS_SRC_GUID_MISMATCH = 8488;
    public const ERROR_DS_CANT_MOVE_DELETED_OBJECT = 8489;
    public const ERROR_DS_PDC_OPERATION_IN_PROGRESS = 8490;
    public const ERROR_DS_CROSS_DOMAIN_CLEANUP_REQD = 8491;
    public const ERROR_DS_ILLEGAL_XDOM_MOVE_OPERATION = 8492;
    public const ERROR_DS_CANT_WITH_ACCT_GROUP_MEMBERSHPS = 8493;
    public const ERROR_DS_NC_MUST_HAVE_NC_PARENT = 8494;
    public const ERROR_DS_CR_IMPOSSIBLE_TO_VALIDATE = 8495;
    public const ERROR_DS_DST_DOMAIN_NOT_NATIVE = 8496;
    public const ERROR_DS_MISSING_INFRASTRUCTURE_CONTAINER = 8497;
    public const ERROR_DS_CANT_MOVE_ACCOUNT_GROUP = 8498;
    public const ERROR_DS_CANT_MOVE_RESOURCE_GROUP = 8499;
    public const ERROR_DS_INVALID_SEARCH_FLAG = 8500;
    public const ERROR_DS_NO_TREE_DELETE_ABOVE_NC = 8501;
    public const ERROR_DS_COULDNT_LOCK_TREE_FOR_DELETE = 8502;
    public const ERROR_DS_COULDNT_IDENTIFY_OBJECTS_FOR_TREE_DELETE = 8503;
    public const ERROR_DS_SAM_INIT_FAILURE = 8504;
    public const ERROR_DS_SENSITIVE_GROUP_VIOLATION = 8505;
    public const ERROR_DS_CANT_MOD_PRIMARYGROUPID = 8506;
    public const ERROR_DS_ILLEGAL_BASE_SCHEMA_MOD = 8507;
    public const ERROR_DS_NONSAFE_SCHEMA_CHANGE = 8508;
    public const ERROR_DS_SCHEMA_UPDATE_DISALLOWED = 8509;
    public const ERROR_DS_CANT_CREATE_UNDER_SCHEMA = 8510;
    public const ERROR_DS_INSTALL_NO_SRC_SCH_VERSION = 8511;
    public const ERROR_DS_INSTALL_NO_SCH_VERSION_IN_INIFILE = 8512;
    public const ERROR_DS_INVALID_GROUP_TYPE = 8513;
    public const ERROR_DS_NO_NEST_GLOBALGROUP_IN_MIXEDDOMAIN = 8514;
    public const ERROR_DS_NO_NEST_LOCALGROUP_IN_MIXEDDOMAIN = 8515;
    public const ERROR_DS_GLOBAL_CANT_HAVE_LOCAL_MEMBER = 8516;
    public const ERROR_DS_GLOBAL_CANT_HAVE_UNIVERSAL_MEMBER = 8517;
    public const ERROR_DS_UNIVERSAL_CANT_HAVE_LOCAL_MEMBER = 8518;
    public const ERROR_DS_GLOBAL_CANT_HAVE_CROSSDOMAIN_MEMBER = 8519;
    public const ERROR_DS_LOCAL_CANT_HAVE_CROSSDOMAIN_LOCAL_MEMBER = 8520;
    public const ERROR_DS_HAVE_PRIMARY_MEMBERS = 8521;
    public const ERROR_DS_STRING_SD_CONVERSION_FAILED = 8522;
    public const ERROR_DS_NAMING_MASTER_GC = 8523;
    public const ERROR_DS_DNS_LOOKUP_FAILURE = 8524;
    public const ERROR_DS_COULDNT_UPDATE_SPNS = 8525;
    public const ERROR_DS_CANT_RETRIEVE_SD = 8526;
    public const ERROR_DS_KEY_NOT_UNIQUE = 8527;
    public const ERROR_DS_WRONG_LINKED_ATT_SYNTAX = 8528;
    public const ERROR_DS_SAM_NEED_BOOTKEY_PASSWORD = 8529;
    public const ERROR_DS_SAM_NEED_BOOTKEY_FLOPPY = 8530;
    public const ERROR_DS_CANT_START = 8531;
    public const ERROR_DS_INIT_FAILURE = 8532;
    public const ERROR_DS_NO_PKT_PRIVACY_ON_CONNECTION = 8533;
    public const ERROR_DS_SOURCE_DOMAIN_IN_FOREST = 8534;
    public const ERROR_DS_DESTINATION_DOMAIN_NOT_IN_FOREST = 8535;
    public const ERROR_DS_DESTINATION_AUDITING_NOT_ENABLED = 8536;
    public const ERROR_DS_CANT_FIND_DC_FOR_SRC_DOMAIN = 8537;
    public const ERROR_DS_SRC_OBJ_NOT_GROUP_OR_USER = 8538;
    public const ERROR_DS_SRC_SID_EXISTS_IN_FOREST = 8539;
    public const ERROR_DS_SRC_AND_DST_OBJECT_CLASS_MISMATCH = 8540;
    public const ERROR_SAM_INIT_FAILURE = 8541;
    public const ERROR_DS_DRA_SCHEMA_INFO_SHIP = 8542;
    public const ERROR_DS_DRA_SCHEMA_CONFLICT = 8543;
    public const ERROR_DS_DRA_EARLIER_SCHEMA_CONFLICT = 8544;
    public const ERROR_DS_DRA_OBJ_NC_MISMATCH = 8545;
    public const ERROR_DS_NC_STILL_HAS_DSAS = 8546;
    public const ERROR_DS_GC_REQUIRED = 8547;
    public const ERROR_DS_LOCAL_MEMBER_OF_LOCAL_ONLY = 8548;
    public const ERROR_DS_NO_FPO_IN_UNIVERSAL_GROUPS = 8549;
    public const ERROR_DS_CANT_ADD_TO_GC = 8550;
    public const ERROR_DS_NO_CHECKPOINT_WITH_PDC = 8551;
    public const ERROR_DS_SOURCE_AUDITING_NOT_ENABLED = 8552;
    public const ERROR_DS_CANT_CREATE_IN_NONDOMAIN_NC = 8553;
    public const ERROR_DS_INVALID_NAME_FOR_SPN = 8554;
    public const ERROR_DS_FILTER_USES_CONTRUCTED_ATTRS = 8555;
    public const ERROR_DS_UNICODEPWD_NOT_IN_QUOTES = 8556;
    public const ERROR_DS_MACHINE_ACCOUNT_QUOTA_EXCEEDED = 8557;
    public const ERROR_DS_MUST_BE_RUN_ON_DST_DC = 8558;
    public const ERROR_DS_SRC_DC_MUST_BE_SP4_OR_GREATER = 8559;
    public const ERROR_DS_CANT_TREE_DELETE_CRITICAL_OBJ = 8560;
    public const ERROR_DS_INIT_FAILURE_CONSOLE = 8561;
    public const ERROR_DS_SAM_INIT_FAILURE_CONSOLE = 8562;
    public const ERROR_DS_FOREST_VERSION_TOO_HIGH = 8563;
    public const ERROR_DS_DOMAIN_VERSION_TOO_HIGH = 8564;
    public const ERROR_DS_FOREST_VERSION_TOO_LOW = 8565;
    public const ERROR_DS_DOMAIN_VERSION_TOO_LOW = 8566;
    public const ERROR_DS_INCOMPATIBLE_VERSION = 8567;
    public const ERROR_DS_LOW_DSA_VERSION = 8568;
    public const ERROR_DS_NO_BEHAVIOR_VERSION_IN_MIXEDDOMAIN = 8569;
    public const ERROR_DS_NOT_SUPPORTED_SORT_ORDER = 8570;
    public const ERROR_DS_NAME_NOT_UNIQUE = 8571;
    public const ERROR_DS_MACHINE_ACCOUNT_CREATED_PRENT4 = 8572;
    public const ERROR_DS_OUT_OF_VERSION_STORE = 8573;
    public const ERROR_DS_INCOMPATIBLE_CONTROLS_USED = 8574;
    public const ERROR_DS_NO_REF_DOMAIN = 8575;
    public const ERROR_DS_RESERVED_LINK_ID = 8576;
    public const ERROR_DS_LINK_ID_NOT_AVAILABLE = 8577;
    public const ERROR_DS_AG_CANT_HAVE_UNIVERSAL_MEMBER = 8578;
    public const ERROR_DS_MODIFYDN_DISALLOWED_BY_INSTANCE_TYPE = 8579;
    public const ERROR_DS_NO_OBJECT_MOVE_IN_SCHEMA_NC = 8580;
    public const ERROR_DS_MODIFYDN_DISALLOWED_BY_FLAG = 8581;
    public const ERROR_DS_MODIFYDN_WRONG_GRANDPARENT = 8582;
    public const ERROR_DS_NAME_ERROR_TRUST_REFERRAL = 8583;
    public const ERROR_NOT_SUPPORTED_ON_STANDARD_SERVER = 8584;
    public const ERROR_DS_CANT_ACCESS_REMOTE_PART_OF_AD = 8585;
    public const ERROR_DS_CR_IMPOSSIBLE_TO_VALIDATE_V2 = 8586;
    public const ERROR_DS_THREAD_LIMIT_EXCEEDED = 8587;
    public const ERROR_DS_NOT_CLOSEST = 8588;
    public const ERROR_DS_CANT_DERIVE_SPN_WITHOUT_SERVER_REF = 8589;
    public const ERROR_DS_SINGLE_USER_MODE_FAILED = 8590;
    public const ERROR_DS_NTDSCRIPT_SYNTAX_ERROR = 8591;
    public const ERROR_DS_NTDSCRIPT_PROCESS_ERROR = 8592;
    public const ERROR_DS_DIFFERENT_REPL_EPOCHS = 8593;
    public const ERROR_DS_DRS_EXTENSIONS_CHANGED = 8594;
    public const ERROR_DS_REPLICA_SET_CHANGE_NOT_ALLOWED_ON_DISABLED_CR = 8595;
    public const ERROR_DS_NO_MSDS_INTID = 8596;
    public const ERROR_DS_DUP_MSDS_INTID = 8597;
    public const ERROR_DS_EXISTS_IN_RDNATTID = 8598;
    public const ERROR_DS_AUTHORIZATION_FAILED = 8599;
    public const ERROR_DS_INVALID_SCRIPT = 8600;
    public const ERROR_DS_REMOTE_CROSSREF_OP_FAILED = 8601;
    public const ERROR_DS_CROSS_REF_BUSY = 8602;
    public const ERROR_DS_CANT_DERIVE_SPN_FOR_DELETED_DOMAIN = 8603;
    public const ERROR_DS_CANT_DEMOTE_WITH_WRITEABLE_NC = 8604;
    public const ERROR_DS_DUPLICATE_ID_FOUND = 8605;
    public const ERROR_DS_INSUFFICIENT_ATTR_TO_CREATE_OBJECT = 8606;
    public const ERROR_DS_GROUP_CONVERSION_ERROR = 8607;
    public const ERROR_DS_CANT_MOVE_APP_BASIC_GROUP = 8608;
    public const ERROR_DS_CANT_MOVE_APP_QUERY_GROUP = 8609;
    public const ERROR_DS_ROLE_NOT_VERIFIED = 8610;
    public const ERROR_DS_WKO_CONTAINER_CANNOT_BE_SPECIAL = 8611;
    public const ERROR_DS_DOMAIN_RENAME_IN_PROGRESS = 8612;
    public const ERROR_DS_EXISTING_AD_CHILD_NC = 8613;
    public const ERROR_DS_REPL_LIFETIME_EXCEEDED = 8614;
    public const ERROR_DS_DISALLOWED_IN_SYSTEM_CONTAINER = 8615;
    public const ERROR_DS_LDAP_SEND_QUEUE_FULL = 8616;
    public const ERROR_DS_DRA_OUT_SCHEDULE_WINDOW = 8617;
    public const ERROR_DS_POLICY_NOT_KNOWN = 8618;
    public const ERROR_NO_SITE_SETTINGS_OBJECT = 8619;
    public const ERROR_NO_SECRETS = 8620;
    public const ERROR_NO_WRITABLE_DC_FOUND = 8621;
    public const ERROR_DS_NO_SERVER_OBJECT = 8622;
    public const ERROR_DS_NO_NTDSA_OBJECT = 8623;
    public const ERROR_DS_NON_ASQ_SEARCH = 8624;
    public const ERROR_DS_AUDIT_FAILURE = 8625;
    public const ERROR_DS_INVALID_SEARCH_FLAG_SUBTREE = 8626;
    public const ERROR_DS_INVALID_SEARCH_FLAG_TUPLE = 8627;
    public const ERROR_DS_HIERARCHY_TABLE_TOO_DEEP = 8628;
    public const ERROR_DS_DRA_CORRUPT_UTD_VECTOR = 8629;
    public const ERROR_DS_DRA_SECRETS_DENIED = 8630;
    public const ERROR_DS_RESERVED_MAPI_ID = 8631;
    public const ERROR_DS_MAPI_ID_NOT_AVAILABLE = 8632;
    public const ERROR_DS_DRA_MISSING_KRBTGT_SECRET = 8633;
    public const ERROR_DS_DOMAIN_NAME_EXISTS_IN_FOREST = 8634;
    public const ERROR_DS_FLAT_NAME_EXISTS_IN_FOREST = 8635;
    public const ERROR_INVALID_USER_PRINCIPAL_NAME = 8636;
    public const ERROR_DS_OID_MAPPED_GROUP_CANT_HAVE_MEMBERS = 8637;
    public const ERROR_DS_OID_NOT_FOUND = 8638;
    public const ERROR_DS_DRA_RECYCLED_TARGET = 8639;
    public const ERROR_DS_DISALLOWED_NC_REDIRECT = 8640;
    public const ERROR_DS_HIGH_ADLDS_FFL = 8641;
    public const ERROR_DS_HIGH_DSA_VERSION = 8642;
    public const ERROR_DS_LOW_ADLDS_FFL = 8643;
    public const ERROR_DOMAIN_SID_SAME_AS_LOCAL_WORKSTATION = 8644;
    public const ERROR_DS_UNDELETE_SAM_VALIDATION_FAILED = 8645;
    public const ERROR_INCORRECT_ACCOUNT_TYPE = 8646;
    public const DNS_ERROR_RCODE_FORMAT_ERROR = 9001;
    public const DNS_ERROR_RCODE_SERVER_FAILURE = 9002;
    public const DNS_ERROR_RCODE_NAME_ERROR = 9003;
    public const DNS_ERROR_RCODE_NOT_IMPLEMENTED = 9004;
    public const DNS_ERROR_RCODE_REFUSED = 9005;
    public const DNS_ERROR_RCODE_YXDOMAIN = 9006;
    public const DNS_ERROR_RCODE_YXRRSET = 9007;
    public const DNS_ERROR_RCODE_NXRRSET = 9008;
    public const DNS_ERROR_RCODE_NOTAUTH = 9009;
    public const DNS_ERROR_RCODE_NOTZONE = 9010;
    public const DNS_ERROR_RCODE_BADSIG = 9016;
    public const DNS_ERROR_RCODE_BADKEY = 9017;
    public const DNS_ERROR_RCODE_BADTIME = 9018;
    public const DNS_ERROR_KEYMASTER_REQUIRED = 9101;
    public const DNS_ERROR_NOT_ALLOWED_ON_SIGNED_ZONE = 9102;
    public const DNS_ERROR_NSEC3_INCOMPATIBLE_WITH_RSA_SHA1 = 9103;
    public const DNS_ERROR_NOT_ENOUGH_SIGNING_KEY_DESCRIPTORS = 9104;
    public const DNS_ERROR_UNSUPPORTED_ALGORITHM = 9105;
    public const DNS_ERROR_INVALID_KEY_SIZE = 9106;
    public const DNS_ERROR_SIGNING_KEY_NOT_ACCESSIBLE = 9107;
    public const DNS_ERROR_KSP_DOES_NOT_SUPPORT_PROTECTION = 9108;
    public const DNS_ERROR_UNEXPECTED_DATA_PROTECTION_ERROR = 9109;
    public const DNS_ERROR_UNEXPECTED_CNG_ERROR = 9110;
    public const DNS_ERROR_UNKNOWN_SIGNING_PARAMETER_VERSION = 9111;
    public const DNS_ERROR_KSP_NOT_ACCESSIBLE = 9112;
    public const DNS_ERROR_TOO_MANY_SKDS = 9113;
    public const DNS_ERROR_INVALID_ROLLOVER_PERIOD = 9114;
    public const DNS_ERROR_INVALID_INITIAL_ROLLOVER_OFFSET = 9115;
    public const DNS_ERROR_ROLLOVER_IN_PROGRESS = 9116;
    public const DNS_ERROR_STANDBY_KEY_NOT_PRESENT = 9117;
    public const DNS_ERROR_NOT_ALLOWED_ON_ZSK = 9118;
    public const DNS_ERROR_NOT_ALLOWED_ON_ACTIVE_SKD = 9119;
    public const DNS_ERROR_ROLLOVER_ALREADY_QUEUED = 9120;
    public const DNS_ERROR_NOT_ALLOWED_ON_UNSIGNED_ZONE = 9121;
    public const DNS_ERROR_BAD_KEYMASTER = 9122;
    public const DNS_ERROR_INVALID_SIGNATURE_VALIDITY_PERIOD = 9123;
    public const DNS_ERROR_INVALID_NSEC3_ITERATION_COUNT = 9124;
    public const DNS_ERROR_DNSSEC_IS_DISABLED = 9125;
    public const DNS_ERROR_INVALID_XML = 9126;
    public const DNS_ERROR_NO_VALID_TRUST_ANCHORS = 9127;
    public const DNS_ERROR_ROLLOVER_NOT_POKEABLE = 9128;
    public const DNS_ERROR_NSEC3_NAME_COLLISION = 9129;
    public const DNS_ERROR_NSEC_INCOMPATIBLE_WITH_NSEC3_RSA_SHA1 = 9130;
    public const DNS_INFO_NO_RECORDS = 9501;
    public const DNS_ERROR_BAD_PACKET = 9502;
    public const DNS_ERROR_NO_PACKET = 9503;
    public const DNS_ERROR_RCODE = 9504;
    public const DNS_ERROR_UNSECURE_PACKET = 9505;
    public const DNS_REQUEST_PENDING = 9506;
    public const DNS_ERROR_INVALID_TYPE = 9551;
    public const DNS_ERROR_INVALID_IP_ADDRESS = 9552;
    public const DNS_ERROR_INVALID_PROPERTY = 9553;
    public const DNS_ERROR_TRY_AGAIN_LATER = 9554;
    public const DNS_ERROR_NOT_UNIQUE = 9555;
    public const DNS_ERROR_NON_RFC_NAME = 9556;
    public const DNS_STATUS_FQDN = 9557;
    public const DNS_STATUS_DOTTED_NAME = 9558;
    public const DNS_STATUS_SINGLE_PART_NAME = 9559;
    public const DNS_ERROR_INVALID_NAME_CHAR = 9560;
    public const DNS_ERROR_NUMERIC_NAME = 9561;
    public const DNS_ERROR_NOT_ALLOWED_ON_ROOT_SERVER = 9562;
    public const DNS_ERROR_NOT_ALLOWED_UNDER_DELEGATION = 9563;
    public const DNS_ERROR_CANNOT_FIND_ROOT_HINTS = 9564;
    public const DNS_ERROR_INCONSISTENT_ROOT_HINTS = 9565;
    public const DNS_ERROR_DWORD_VALUE_TOO_SMALL = 9566;
    public const DNS_ERROR_DWORD_VALUE_TOO_LARGE = 9567;
    public const DNS_ERROR_BACKGROUND_LOADING = 9568;
    public const DNS_ERROR_NOT_ALLOWED_ON_RODC = 9569;
    public const DNS_ERROR_NOT_ALLOWED_UNDER_DNAME = 9570;
    public const DNS_ERROR_DELEGATION_REQUIRED = 9571;
    public const DNS_ERROR_INVALID_POLICY_TABLE = 9572;
    public const DNS_ERROR_ZONE_DOES_NOT_EXIST = 9601;
    public const DNS_ERROR_NO_ZONE_INFO = 9602;
    public const DNS_ERROR_INVALID_ZONE_OPERATION = 9603;
    public const DNS_ERROR_ZONE_CONFIGURATION_ERROR = 9604;
    public const DNS_ERROR_ZONE_HAS_NO_SOA_RECORD = 9605;
    public const DNS_ERROR_ZONE_HAS_NO_NS_RECORDS = 9606;
    public const DNS_ERROR_ZONE_LOCKED = 9607;
    public const DNS_ERROR_ZONE_CREATION_FAILED = 9608;
    public const DNS_ERROR_ZONE_ALREADY_EXISTS = 9609;
    public const DNS_ERROR_AUTOZONE_ALREADY_EXISTS = 9610;
    public const DNS_ERROR_INVALID_ZONE_TYPE = 9611;
    public const DNS_ERROR_SECONDARY_REQUIRES_MASTER_IP = 9612;
    public const DNS_ERROR_ZONE_NOT_SECONDARY = 9613;
    public const DNS_ERROR_NEED_SECONDARY_ADDRESSES = 9614;
    public const DNS_ERROR_WINS_INIT_FAILED = 9615;
    public const DNS_ERROR_NEED_WINS_SERVERS = 9616;
    public const DNS_ERROR_NBSTAT_INIT_FAILED = 9617;
    public const DNS_ERROR_SOA_DELETE_INVALID = 9618;
    public const DNS_ERROR_FORWARDER_ALREADY_EXISTS = 9619;
    public const DNS_ERROR_ZONE_REQUIRES_MASTER_IP = 9620;
    public const DNS_ERROR_ZONE_IS_SHUTDOWN = 9621;
    public const DNS_ERROR_ZONE_LOCKED_FOR_SIGNING = 9622;
    public const DNS_ERROR_PRIMARY_REQUIRES_DATAFILE = 9651;
    public const DNS_ERROR_INVALID_DATAFILE_NAME = 9652;
    public const DNS_ERROR_DATAFILE_OPEN_FAILURE = 9653;
    public const DNS_ERROR_FILE_WRITEBACK_FAILED = 9654;
    public const DNS_ERROR_DATAFILE_PARSING = 9655;
    public const DNS_ERROR_RECORD_DOES_NOT_EXIST = 9701;
    public const DNS_ERROR_RECORD_FORMAT = 9702;
    public const DNS_ERROR_NODE_CREATION_FAILED = 9703;
    public const DNS_ERROR_UNKNOWN_RECORD_TYPE = 9704;
    public const DNS_ERROR_RECORD_TIMED_OUT = 9705;
    public const DNS_ERROR_NAME_NOT_IN_ZONE = 9706;
    public const DNS_ERROR_CNAME_LOOP = 9707;
    public const DNS_ERROR_NODE_IS_CNAME = 9708;
    public const DNS_ERROR_CNAME_COLLISION = 9709;
    public const DNS_ERROR_RECORD_ONLY_AT_ZONE_ROOT = 9710;
    public const DNS_ERROR_RECORD_ALREADY_EXISTS = 9711;
    public const DNS_ERROR_SECONDARY_DATA = 9712;
    public const DNS_ERROR_NO_CREATE_CACHE_DATA = 9713;
    public const DNS_ERROR_NAME_DOES_NOT_EXIST = 9714;
    public const DNS_WARNING_PTR_CREATE_FAILED = 9715;
    public const DNS_WARNING_DOMAIN_UNDELETED = 9716;
    public const DNS_ERROR_DS_UNAVAILABLE = 9717;
    public const DNS_ERROR_DS_ZONE_ALREADY_EXISTS = 9718;
    public const DNS_ERROR_NO_BOOTFILE_IF_DS_ZONE = 9719;
    public const DNS_ERROR_NODE_IS_DNAME = 9720;
    public const DNS_ERROR_DNAME_COLLISION = 9721;
    public const DNS_ERROR_ALIAS_LOOP = 9722;
    public const DNS_INFO_AXFR_COMPLETE = 9751;
    public const DNS_ERROR_AXFR = 9752;
    public const DNS_INFO_ADDED_LOCAL_WINS = 9753;
    public const DNS_STATUS_CONTINUE_NEEDED = 9801;
    public const DNS_ERROR_NO_TCPIP = 9851;
    public const DNS_ERROR_NO_DNS_SERVERS = 9852;
    public const DNS_ERROR_DP_DOES_NOT_EXIST = 9901;
    public const DNS_ERROR_DP_ALREADY_EXISTS = 9902;
    public const DNS_ERROR_DP_NOT_ENLISTED = 9903;
    public const DNS_ERROR_DP_ALREADY_ENLISTED = 9904;
    public const DNS_ERROR_DP_NOT_AVAILABLE = 9905;
    public const DNS_ERROR_DP_FSMO_ERROR = 9906;
    public const WSAEINTR = 10004;
    public const WSAEBADF = 10009;
    public const WSAEACCES = 10013;
    public const WSAEFAULT = 10014;
    public const WSAEINVAL = 10022;
    public const WSAEMFILE = 10024;
    public const WSAEWOULDBLOCK = 10035;
    public const WSAEINPROGRESS = 10036;
    public const WSAEALREADY = 10037;
    public const WSAENOTSOCK = 10038;
    public const WSAEDESTADDRREQ = 10039;
    public const WSAEMSGSIZE = 10040;
    public const WSAEPROTOTYPE = 10041;
    public const WSAENOPROTOOPT = 10042;
    public const WSAEPROTONOSUPPORT = 10043;
    public const WSAESOCKTNOSUPPORT = 10044;
    public const WSAEOPNOTSUPP = 10045;
    public const WSAEPFNOSUPPORT = 10046;
    public const WSAEAFNOSUPPORT = 10047;
    public const WSAEADDRINUSE = 10048;
    public const WSAEADDRNOTAVAIL = 10049;
    public const WSAENETDOWN = 10050;
    public const WSAENETUNREACH = 10051;
    public const WSAENETRESET = 10052;
    public const WSAECONNABORTED = 10053;
    public const WSAECONNRESET = 10054;
    public const WSAENOBUFS = 10055;
    public const WSAEISCONN = 10056;
    public const WSAENOTCONN = 10057;
    public const WSAESHUTDOWN = 10058;
    public const WSAETOOMANYREFS = 10059;
    public const WSAETIMEDOUT = 10060;
    public const WSAECONNREFUSED = 10061;
    public const WSAELOOP = 10062;
    public const WSAENAMETOOLONG = 10063;
    public const WSAEHOSTDOWN = 10064;
    public const WSAEHOSTUNREACH = 10065;
    public const WSAENOTEMPTY = 10066;
    public const WSAEPROCLIM = 10067;
    public const WSAEUSERS = 10068;
    public const WSAEDQUOT = 10069;
    public const WSAESTALE = 10070;
    public const WSAEREMOTE = 10071;
    public const WSASYSNOTREADY = 10091;
    public const WSAVERNOTSUPPORTED = 10092;
    public const WSANOTINITIALISED = 10093;
    public const WSAEDISCON = 10101;
    public const WSAENOMORE = 10102;
    public const WSAECANCELLED = 10103;
    public const WSAEINVALIDPROCTABLE = 10104;
    public const WSAEINVALIDPROVIDER = 10105;
    public const WSAEPROVIDERFAILEDINIT = 10106;
    public const WSASYSCALLFAILURE = 10107;
    public const WSASERVICE_NOT_FOUND = 10108;
    public const WSATYPE_NOT_FOUND = 10109;
    public const WSA_E_NO_MORE = 10110;
    public const WSA_E_CANCELLED = 10111;
    public const WSAEREFUSED = 10112;
    public const WSAHOST_NOT_FOUND = 11001;
    public const WSATRY_AGAIN = 11002;
    public const WSANO_RECOVERY = 11003;
    public const WSANO_DATA = 11004;
    public const WSA_QOS_RECEIVERS = 11005;
    public const WSA_QOS_SENDERS = 11006;
    public const WSA_QOS_NO_SENDERS = 11007;
    public const WSA_QOS_NO_RECEIVERS = 11008;
    public const WSA_QOS_REQUEST_CONFIRMED = 11009;
    public const WSA_QOS_ADMISSION_FAILURE = 11010;
    public const WSA_QOS_POLICY_FAILURE = 11011;
    public const WSA_QOS_BAD_STYLE = 11012;
    public const WSA_QOS_BAD_OBJECT = 11013;
    public const WSA_QOS_TRAFFIC_CTRL_ERROR = 11014;
    public const WSA_QOS_GENERIC_ERROR = 11015;
    public const WSA_QOS_ESERVICETYPE = 11016;
    public const WSA_QOS_EFLOWSPEC = 11017;
    public const WSA_QOS_EPROVSPECBUF = 11018;
    public const WSA_QOS_EFILTERSTYLE = 11019;
    public const WSA_QOS_EFILTERTYPE = 11020;
    public const WSA_QOS_EFILTERCOUNT = 11021;
    public const WSA_QOS_EOBJLENGTH = 11022;
    public const WSA_QOS_EFLOWCOUNT = 11023;
    public const WSA_QOS_EUNKOWNPSOBJ = 11024;
    public const WSA_QOS_EPOLICYOBJ = 11025;
    public const WSA_QOS_EFLOWDESC = 11026;
    public const WSA_QOS_EPSFLOWSPEC = 11027;
    public const WSA_QOS_EPSFILTERSPEC = 11028;
    public const WSA_QOS_ESDMODEOBJ = 11029;
    public const WSA_QOS_ESHAPERATEOBJ = 11030;
    public const WSA_QOS_RESERVED_PETYPE = 11031;
    public const WSA_SECURE_HOST_NOT_FOUND = 11032;
    public const WSA_IPSEC_NAME_POLICY_ERROR = 11033;
    public const ERROR_IPSEC_QM_POLICY_EXISTS = 13000;
    public const ERROR_IPSEC_QM_POLICY_NOT_FOUND = 13001;
    public const ERROR_IPSEC_QM_POLICY_IN_USE = 13002;
    public const ERROR_IPSEC_MM_POLICY_EXISTS = 13003;
    public const ERROR_IPSEC_MM_POLICY_NOT_FOUND = 13004;
    public const ERROR_IPSEC_MM_POLICY_IN_USE = 13005;
    public const ERROR_IPSEC_MM_FILTER_EXISTS = 13006;
    public const ERROR_IPSEC_MM_FILTER_NOT_FOUND = 13007;
    public const ERROR_IPSEC_TRANSPORT_FILTER_EXISTS = 13008;
    public const ERROR_IPSEC_TRANSPORT_FILTER_NOT_FOUND = 13009;
    public const ERROR_IPSEC_MM_AUTH_EXISTS = 13010;
    public const ERROR_IPSEC_MM_AUTH_NOT_FOUND = 13011;
    public const ERROR_IPSEC_MM_AUTH_IN_USE = 13012;
    public const ERROR_IPSEC_DEFAULT_MM_POLICY_NOT_FOUND = 13013;
    public const ERROR_IPSEC_DEFAULT_MM_AUTH_NOT_FOUND = 13014;
    public const ERROR_IPSEC_DEFAULT_QM_POLICY_NOT_FOUND = 13015;
    public const ERROR_IPSEC_TUNNEL_FILTER_EXISTS = 13016;
    public const ERROR_IPSEC_TUNNEL_FILTER_NOT_FOUND = 13017;
    public const ERROR_IPSEC_MM_FILTER_PENDING_DELETION = 13018;
    public const ERROR_IPSEC_TRANSPORT_FILTER_PENDING_DELETION = 13019;
    public const ERROR_IPSEC_TUNNEL_FILTER_PENDING_DELETION = 13020;
    public const ERROR_IPSEC_MM_POLICY_PENDING_DELETION = 13021;
    public const ERROR_IPSEC_MM_AUTH_PENDING_DELETION = 13022;
    public const ERROR_IPSEC_QM_POLICY_PENDING_DELETION = 13023;
    public const WARNING_IPSEC_MM_POLICY_PRUNED = 13024;
    public const WARNING_IPSEC_QM_POLICY_PRUNED = 13025;
    public const ERROR_IPSEC_IKE_NEG_STATUS_BEGIN = 13800;
    public const ERROR_IPSEC_IKE_AUTH_FAIL = 13801;
    public const ERROR_IPSEC_IKE_ATTRIB_FAIL = 13802;
    public const ERROR_IPSEC_IKE_NEGOTIATION_PENDING = 13803;
    public const ERROR_IPSEC_IKE_GENERAL_PROCESSING_ERROR = 13804;
    public const ERROR_IPSEC_IKE_TIMED_OUT = 13805;
    public const ERROR_IPSEC_IKE_NO_CERT = 13806;
    public const ERROR_IPSEC_IKE_SA_DELETED = 13807;
    public const ERROR_IPSEC_IKE_SA_REAPED = 13808;
    public const ERROR_IPSEC_IKE_MM_ACQUIRE_DROP = 13809;
    public const ERROR_IPSEC_IKE_QM_ACQUIRE_DROP = 13810;
    public const ERROR_IPSEC_IKE_QUEUE_DROP_MM = 13811;
    public const ERROR_IPSEC_IKE_QUEUE_DROP_NO_MM = 13812;
    public const ERROR_IPSEC_IKE_DROP_NO_RESPONSE = 13813;
    public const ERROR_IPSEC_IKE_MM_DELAY_DROP = 13814;
    public const ERROR_IPSEC_IKE_QM_DELAY_DROP = 13815;
    public const ERROR_IPSEC_IKE_ERROR = 13816;
    public const ERROR_IPSEC_IKE_CRL_FAILED = 13817;
    public const ERROR_IPSEC_IKE_INVALID_KEY_USAGE = 13818;
    public const ERROR_IPSEC_IKE_INVALID_CERT_TYPE = 13819;
    public const ERROR_IPSEC_IKE_NO_PRIVATE_KEY = 13820;
    public const ERROR_IPSEC_IKE_SIMULTANEOUS_REKEY = 13821;
    public const ERROR_IPSEC_IKE_DH_FAIL = 13822;
    public const ERROR_IPSEC_IKE_CRITICAL_PAYLOAD_NOT_RECOGNIZED = 13823;
    public const ERROR_IPSEC_IKE_INVALID_HEADER = 13824;
    public const ERROR_IPSEC_IKE_NO_POLICY = 13825;
    public const ERROR_IPSEC_IKE_INVALID_SIGNATURE = 13826;
    public const ERROR_IPSEC_IKE_KERBEROS_ERROR = 13827;
    public const ERROR_IPSEC_IKE_NO_PUBLIC_KEY = 13828;
    public const ERROR_IPSEC_IKE_PROCESS_ERR = 13829;
    public const ERROR_IPSEC_IKE_PROCESS_ERR_SA = 13830;
    public const ERROR_IPSEC_IKE_PROCESS_ERR_PROP = 13831;
    public const ERROR_IPSEC_IKE_PROCESS_ERR_TRANS = 13832;
    public const ERROR_IPSEC_IKE_PROCESS_ERR_KE = 13833;
    public const ERROR_IPSEC_IKE_PROCESS_ERR_ID = 13834;
    public const ERROR_IPSEC_IKE_PROCESS_ERR_CERT = 13835;
    public const ERROR_IPSEC_IKE_PROCESS_ERR_CERT_REQ = 13836;
    public const ERROR_IPSEC_IKE_PROCESS_ERR_HASH = 13837;
    public const ERROR_IPSEC_IKE_PROCESS_ERR_SIG = 13838;
    public const ERROR_IPSEC_IKE_PROCESS_ERR_NONCE = 13839;
    public const ERROR_IPSEC_IKE_PROCESS_ERR_NOTIFY = 13840;
    public const ERROR_IPSEC_IKE_PROCESS_ERR_DELETE = 13841;
    public const ERROR_IPSEC_IKE_PROCESS_ERR_VENDOR = 13842;
    public const ERROR_IPSEC_IKE_INVALID_PAYLOAD = 13843;
    public const ERROR_IPSEC_IKE_LOAD_SOFT_SA = 13844;
    public const ERROR_IPSEC_IKE_SOFT_SA_TORN_DOWN = 13845;
    public const ERROR_IPSEC_IKE_INVALID_COOKIE = 13846;
    public const ERROR_IPSEC_IKE_NO_PEER_CERT = 13847;
    public const ERROR_IPSEC_IKE_PEER_CRL_FAILED = 13848;
    public const ERROR_IPSEC_IKE_POLICY_CHANGE = 13849;
    public const ERROR_IPSEC_IKE_NO_MM_POLICY = 13850;
    public const ERROR_IPSEC_IKE_NOTCBPRIV = 13851;
    public const ERROR_IPSEC_IKE_SECLOADFAIL = 13852;
    public const ERROR_IPSEC_IKE_FAILSSPINIT = 13853;
    public const ERROR_IPSEC_IKE_FAILQUERYSSP = 13854;
    public const ERROR_IPSEC_IKE_SRVACQFAIL = 13855;
    public const ERROR_IPSEC_IKE_SRVQUERYCRED = 13856;
    public const ERROR_IPSEC_IKE_GETSPIFAIL = 13857;
    public const ERROR_IPSEC_IKE_INVALID_FILTER = 13858;
    public const ERROR_IPSEC_IKE_OUT_OF_MEMORY = 13859;
    public const ERROR_IPSEC_IKE_ADD_UPDATE_KEY_FAILED = 13860;
    public const ERROR_IPSEC_IKE_INVALID_POLICY = 13861;
    public const ERROR_IPSEC_IKE_UNKNOWN_DOI = 13862;
    public const ERROR_IPSEC_IKE_INVALID_SITUATION = 13863;
    public const ERROR_IPSEC_IKE_DH_FAILURE = 13864;
    public const ERROR_IPSEC_IKE_INVALID_GROUP = 13865;
    public const ERROR_IPSEC_IKE_ENCRYPT = 13866;
    public const ERROR_IPSEC_IKE_DECRYPT = 13867;
    public const ERROR_IPSEC_IKE_POLICY_MATCH = 13868;
    public const ERROR_IPSEC_IKE_UNSUPPORTED_ID = 13869;
    public const ERROR_IPSEC_IKE_INVALID_HASH = 13870;
    public const ERROR_IPSEC_IKE_INVALID_HASH_ALG = 13871;
    public const ERROR_IPSEC_IKE_INVALID_HASH_SIZE = 13872;
    public const ERROR_IPSEC_IKE_INVALID_ENCRYPT_ALG = 13873;
    public const ERROR_IPSEC_IKE_INVALID_AUTH_ALG = 13874;
    public const ERROR_IPSEC_IKE_INVALID_SIG = 13875;
    public const ERROR_IPSEC_IKE_LOAD_FAILED = 13876;
    public const ERROR_IPSEC_IKE_RPC_DELETE = 13877;
    public const ERROR_IPSEC_IKE_BENIGN_REINIT = 13878;
    public const ERROR_IPSEC_IKE_INVALID_RESPONDER_LIFETIME_NOTIFY = 13879;
    public const ERROR_IPSEC_IKE_INVALID_MAJOR_VERSION = 13880;
    public const ERROR_IPSEC_IKE_INVALID_CERT_KEYLEN = 13881;
    public const ERROR_IPSEC_IKE_MM_LIMIT = 13882;
    public const ERROR_IPSEC_IKE_NEGOTIATION_DISABLED = 13883;
    public const ERROR_IPSEC_IKE_QM_LIMIT = 13884;
    public const ERROR_IPSEC_IKE_MM_EXPIRED = 13885;
    public const ERROR_IPSEC_IKE_PEER_MM_ASSUMED_INVALID = 13886;
    public const ERROR_IPSEC_IKE_CERT_CHAIN_POLICY_MISMATCH = 13887;
    public const ERROR_IPSEC_IKE_UNEXPECTED_MESSAGE_ID = 13888;
    public const ERROR_IPSEC_IKE_INVALID_AUTH_PAYLOAD = 13889;
    public const ERROR_IPSEC_IKE_DOS_COOKIE_SENT = 13890;
    public const ERROR_IPSEC_IKE_SHUTTING_DOWN = 13891;
    public const ERROR_IPSEC_IKE_CGA_AUTH_FAILED = 13892;
    public const ERROR_IPSEC_IKE_PROCESS_ERR_NATOA = 13893;
    public const ERROR_IPSEC_IKE_INVALID_MM_FOR_QM = 13894;
    public const ERROR_IPSEC_IKE_QM_EXPIRED = 13895;
    public const ERROR_IPSEC_IKE_TOO_MANY_FILTERS = 13896;
    public const ERROR_IPSEC_IKE_NEG_STATUS_END = 13897;
    public const ERROR_IPSEC_IKE_KILL_DUMMY_NAP_TUNNEL = 13898;
    public const ERROR_IPSEC_IKE_INNER_IP_ASSIGNMENT_FAILURE = 13899;
    public const ERROR_IPSEC_IKE_REQUIRE_CP_PAYLOAD_MISSING = 13900;
    public const ERROR_IPSEC_KEY_MODULE_IMPERSONATION_NEGOTIATION_PENDING = 13901;
    public const ERROR_IPSEC_IKE_COEXISTENCE_SUPPRESS = 13902;
    public const ERROR_IPSEC_IKE_RATELIMIT_DROP = 13903;
    public const ERROR_IPSEC_IKE_PEER_DOESNT_SUPPORT_MOBIKE = 13904;
    public const ERROR_IPSEC_IKE_AUTHORIZATION_FAILURE = 13905;
    public const ERROR_IPSEC_IKE_STRONG_CRED_AUTHORIZATION_FAILURE = 13906;
    public const ERROR_IPSEC_IKE_AUTHORIZATION_FAILURE_WITH_OPTIONAL_RETRY = 13907;
    public const ERROR_IPSEC_IKE_STRONG_CRED_AUTHORIZATION_AND_CERTMAP_FAILURE = 13908;
    public const ERROR_IPSEC_IKE_NEG_STATUS_EXTENDED_END = 13909;
    public const ERROR_IPSEC_BAD_SPI = 13910;
    public const ERROR_IPSEC_SA_LIFETIME_EXPIRED = 13911;
    public const ERROR_IPSEC_WRONG_SA = 13912;
    public const ERROR_IPSEC_REPLAY_CHECK_FAILED = 13913;
    public const ERROR_IPSEC_INVALID_PACKET = 13914;
    public const ERROR_IPSEC_INTEGRITY_CHECK_FAILED = 13915;
    public const ERROR_IPSEC_CLEAR_TEXT_DROP = 13916;
    public const ERROR_IPSEC_AUTH_FIREWALL_DROP = 13917;
    public const ERROR_IPSEC_THROTTLE_DROP = 13918;
    public const ERROR_IPSEC_DOSP_BLOCK = 13925;
    public const ERROR_IPSEC_DOSP_RECEIVED_MULTICAST = 13926;
    public const ERROR_IPSEC_DOSP_INVALID_PACKET = 13927;
    public const ERROR_IPSEC_DOSP_STATE_LOOKUP_FAILED = 13928;
    public const ERROR_IPSEC_DOSP_MAX_ENTRIES = 13929;
    public const ERROR_IPSEC_DOSP_KEYMOD_NOT_ALLOWED = 13930;
    public const ERROR_IPSEC_DOSP_NOT_INSTALLED = 13931;
    public const ERROR_IPSEC_DOSP_MAX_PER_IP_RATELIMIT_QUEUES = 13932;
    public const ERROR_SXS_SECTION_NOT_FOUND = 14000;
    public const ERROR_SXS_CANT_GEN_ACTCTX = 14001;
    public const ERROR_SXS_INVALID_ACTCTXDATA_FORMAT = 14002;
    public const ERROR_SXS_ASSEMBLY_NOT_FOUND = 14003;
    public const ERROR_SXS_MANIFEST_FORMAT_ERROR = 14004;
    public const ERROR_SXS_MANIFEST_PARSE_ERROR = 14005;
    public const ERROR_SXS_ACTIVATION_CONTEXT_DISABLED = 14006;
    public const ERROR_SXS_KEY_NOT_FOUND = 14007;
    public const ERROR_SXS_VERSION_CONFLICT = 14008;
    public const ERROR_SXS_WRONG_SECTION_TYPE = 14009;
    public const ERROR_SXS_THREAD_QUERIES_DISABLED = 14010;
    public const ERROR_SXS_PROCESS_DEFAULT_ALREADY_SET = 14011;
    public const ERROR_SXS_UNKNOWN_ENCODING_GROUP = 14012;
    public const ERROR_SXS_UNKNOWN_ENCODING = 14013;
    public const ERROR_SXS_INVALID_XML_NAMESPACE_URI = 14014;
    public const ERROR_SXS_ROOT_MANIFEST_DEPENDENCY_NOT_INSTALLED = 14015;
    public const ERROR_SXS_LEAF_MANIFEST_DEPENDENCY_NOT_INSTALLED = 14016;
    public const ERROR_SXS_INVALID_ASSEMBLY_IDENTITY_ATTRIBUTE = 14017;
    public const ERROR_SXS_MANIFEST_MISSING_REQUIRED_DEFAULT_NAMESPACE = 14018;
    public const ERROR_SXS_MANIFEST_INVALID_REQUIRED_DEFAULT_NAMESPACE = 14019;
    public const ERROR_SXS_PRIVATE_MANIFEST_CROSS_PATH_WITH_REPARSE_POINT = 14020;
    public const ERROR_SXS_DUPLICATE_DLL_NAME = 14021;
    public const ERROR_SXS_DUPLICATE_WINDOWCLASS_NAME = 14022;
    public const ERROR_SXS_DUPLICATE_CLSID = 14023;
    public const ERROR_SXS_DUPLICATE_IID = 14024;
    public const ERROR_SXS_DUPLICATE_TLBID = 14025;
    public const ERROR_SXS_DUPLICATE_PROGID = 14026;
    public const ERROR_SXS_DUPLICATE_ASSEMBLY_NAME = 14027;
    public const ERROR_SXS_FILE_HASH_MISMATCH = 14028;
    public const ERROR_SXS_POLICY_PARSE_ERROR = 14029;
    public const ERROR_SXS_XML_E_MISSINGQUOTE = 14030;
    public const ERROR_SXS_XML_E_COMMENTSYNTAX = 14031;
    public const ERROR_SXS_XML_E_BADSTARTNAMECHAR = 14032;
    public const ERROR_SXS_XML_E_BADNAMECHAR = 14033;
    public const ERROR_SXS_XML_E_BADCHARINSTRING = 14034;
    public const ERROR_SXS_XML_E_XMLDECLSYNTAX = 14035;
    public const ERROR_SXS_XML_E_BADCHARDATA = 14036;
    public const ERROR_SXS_XML_E_MISSINGWHITESPACE = 14037;
    public const ERROR_SXS_XML_E_EXPECTINGTAGEND = 14038;
    public const ERROR_SXS_XML_E_MISSINGSEMICOLON = 14039;
    public const ERROR_SXS_XML_E_UNBALANCEDPAREN = 14040;
    public const ERROR_SXS_XML_E_INTERNALERROR = 14041;
    public const ERROR_SXS_XML_E_UNEXPECTED_WHITESPACE = 14042;
    public const ERROR_SXS_XML_E_INCOMPLETE_ENCODING = 14043;
    public const ERROR_SXS_XML_E_MISSING_PAREN = 14044;
    public const ERROR_SXS_XML_E_EXPECTINGCLOSEQUOTE = 14045;
    public const ERROR_SXS_XML_E_MULTIPLE_COLONS = 14046;
    public const ERROR_SXS_XML_E_INVALID_DECIMAL = 14047;
    public const ERROR_SXS_XML_E_INVALID_HEXIDECIMAL = 14048;
    public const ERROR_SXS_XML_E_INVALID_UNICODE = 14049;
    public const ERROR_SXS_XML_E_WHITESPACEORQUESTIONMARK = 14050;
    public const ERROR_SXS_XML_E_UNEXPECTEDENDTAG = 14051;
    public const ERROR_SXS_XML_E_UNCLOSEDTAG = 14052;
    public const ERROR_SXS_XML_E_DUPLICATEATTRIBUTE = 14053;
    public const ERROR_SXS_XML_E_MULTIPLEROOTS = 14054;
    public const ERROR_SXS_XML_E_INVALIDATROOTLEVEL = 14055;
    public const ERROR_SXS_XML_E_BADXMLDECL = 14056;
    public const ERROR_SXS_XML_E_MISSINGROOT = 14057;
    public const ERROR_SXS_XML_E_UNEXPECTEDEOF = 14058;
    public const ERROR_SXS_XML_E_BADPEREFINSUBSET = 14059;
    public const ERROR_SXS_XML_E_UNCLOSEDSTARTTAG = 14060;
    public const ERROR_SXS_XML_E_UNCLOSEDENDTAG = 14061;
    public const ERROR_SXS_XML_E_UNCLOSEDSTRING = 14062;
    public const ERROR_SXS_XML_E_UNCLOSEDCOMMENT = 14063;
    public const ERROR_SXS_XML_E_UNCLOSEDDECL = 14064;
    public const ERROR_SXS_XML_E_UNCLOSEDCDATA = 14065;
    public const ERROR_SXS_XML_E_RESERVEDNAMESPACE = 14066;
    public const ERROR_SXS_XML_E_INVALIDENCODING = 14067;
    public const ERROR_SXS_XML_E_INVALIDSWITCH = 14068;
    public const ERROR_SXS_XML_E_BADXMLCASE = 14069;
    public const ERROR_SXS_XML_E_INVALID_STANDALONE = 14070;
    public const ERROR_SXS_XML_E_UNEXPECTED_STANDALONE = 14071;
    public const ERROR_SXS_XML_E_INVALID_VERSION = 14072;
    public const ERROR_SXS_XML_E_MISSINGEQUALS = 14073;
    public const ERROR_SXS_PROTECTION_RECOVERY_FAILED = 14074;
    public const ERROR_SXS_PROTECTION_PUBLIC_KEY_TOO_SHORT = 14075;
    public const ERROR_SXS_PROTECTION_CATALOG_NOT_VALID = 14076;
    public const ERROR_SXS_UNTRANSLATABLE_HRESULT = 14077;
    public const ERROR_SXS_PROTECTION_CATALOG_FILE_MISSING = 14078;
    public const ERROR_SXS_MISSING_ASSEMBLY_IDENTITY_ATTRIBUTE = 14079;
    public const ERROR_SXS_INVALID_ASSEMBLY_IDENTITY_ATTRIBUTE_NAME = 14080;
    public const ERROR_SXS_ASSEMBLY_MISSING = 14081;
    public const ERROR_SXS_CORRUPT_ACTIVATION_STACK = 14082;
    public const ERROR_SXS_CORRUPTION = 14083;
    public const ERROR_SXS_EARLY_DEACTIVATION = 14084;
    public const ERROR_SXS_INVALID_DEACTIVATION = 14085;
    public const ERROR_SXS_MULTIPLE_DEACTIVATION = 14086;
    public const ERROR_SXS_PROCESS_TERMINATION_REQUESTED = 14087;
    public const ERROR_SXS_RELEASE_ACTIVATION_CONTEXT = 14088;
    public const ERROR_SXS_SYSTEM_DEFAULT_ACTIVATION_CONTEXT_EMPTY = 14089;
    public const ERROR_SXS_INVALID_IDENTITY_ATTRIBUTE_VALUE = 14090;
    public const ERROR_SXS_INVALID_IDENTITY_ATTRIBUTE_NAME = 14091;
    public const ERROR_SXS_IDENTITY_DUPLICATE_ATTRIBUTE = 14092;
    public const ERROR_SXS_IDENTITY_PARSE_ERROR = 14093;
    public const ERROR_MALFORMED_SUBSTITUTION_STRING = 14094;
    public const ERROR_SXS_INCORRECT_PUBLIC_KEY_TOKEN = 14095;
    public const ERROR_UNMAPPED_SUBSTITUTION_STRING = 14096;
    public const ERROR_SXS_ASSEMBLY_NOT_LOCKED = 14097;
    public const ERROR_SXS_COMPONENT_STORE_CORRUPT = 14098;
    public const ERROR_ADVANCED_INSTALLER_FAILED = 14099;
    public const ERROR_XML_ENCODING_MISMATCH = 14100;
    public const ERROR_SXS_MANIFEST_IDENTITY_SAME_BUT_CONTENTS_DIFFERENT = 14101;
    public const ERROR_SXS_IDENTITIES_DIFFERENT = 14102;
    public const ERROR_SXS_ASSEMBLY_IS_NOT_A_DEPLOYMENT = 14103;
    public const ERROR_SXS_FILE_NOT_PART_OF_ASSEMBLY = 14104;
    public const ERROR_SXS_MANIFEST_TOO_BIG = 14105;
    public const ERROR_SXS_SETTING_NOT_REGISTERED = 14106;
    public const ERROR_SXS_TRANSACTION_CLOSURE_INCOMPLETE = 14107;
    public const ERROR_SMI_PRIMITIVE_INSTALLER_FAILED = 14108;
    public const ERROR_GENERIC_COMMAND_FAILED = 14109;
    public const ERROR_SXS_FILE_HASH_MISSING = 14110;
    public const ERROR_EVT_INVALID_CHANNEL_PATH = 15000;
    public const ERROR_EVT_INVALID_QUERY = 15001;
    public const ERROR_EVT_PUBLISHER_METADATA_NOT_FOUND = 15002;
    public const ERROR_EVT_EVENT_TEMPLATE_NOT_FOUND = 15003;
    public const ERROR_EVT_INVALID_PUBLISHER_NAME = 15004;
    public const ERROR_EVT_INVALID_EVENT_DATA = 15005;
    public const ERROR_EVT_CHANNEL_NOT_FOUND = 15007;
    public const ERROR_EVT_MALFORMED_XML_TEXT = 15008;
    public const ERROR_EVT_SUBSCRIPTION_TO_DIRECT_CHANNEL = 15009;
    public const ERROR_EVT_CONFIGURATION_ERROR = 15010;
    public const ERROR_EVT_QUERY_RESULT_STALE = 15011;
    public const ERROR_EVT_QUERY_RESULT_INVALID_POSITION = 15012;
    public const ERROR_EVT_NON_VALIDATING_MSXML = 15013;
    public const ERROR_EVT_FILTER_ALREADYSCOPED = 15014;
    public const ERROR_EVT_FILTER_NOTELTSET = 15015;
    public const ERROR_EVT_FILTER_INVARG = 15016;
    public const ERROR_EVT_FILTER_INVTEST = 15017;
    public const ERROR_EVT_FILTER_INVTYPE = 15018;
    public const ERROR_EVT_FILTER_PARSEERR = 15019;
    public const ERROR_EVT_FILTER_UNSUPPORTEDOP = 15020;
    public const ERROR_EVT_FILTER_UNEXPECTEDTOKEN = 15021;
    public const ERROR_EVT_INVALID_OPERATION_OVER_ENABLED_DIRECT_CHANNEL = 15022;
    public const ERROR_EVT_INVALID_CHANNEL_PROPERTY_VALUE = 15023;
    public const ERROR_EVT_INVALID_PUBLISHER_PROPERTY_VALUE = 15024;
    public const ERROR_EVT_CHANNEL_CANNOT_ACTIVATE = 15025;
    public const ERROR_EVT_FILTER_TOO_COMPLEX = 15026;
    public const ERROR_EVT_MESSAGE_NOT_FOUND = 15027;
    public const ERROR_EVT_MESSAGE_ID_NOT_FOUND = 15028;
    public const ERROR_EVT_UNRESOLVED_VALUE_INSERT = 15029;
    public const ERROR_EVT_UNRESOLVED_PARAMETER_INSERT = 15030;
    public const ERROR_EVT_MAX_INSERTS_REACHED = 15031;
    public const ERROR_EVT_EVENT_DEFINITION_NOT_FOUND = 15032;
    public const ERROR_EVT_MESSAGE_LOCALE_NOT_FOUND = 15033;
    public const ERROR_EVT_VERSION_TOO_OLD = 15034;
    public const ERROR_EVT_VERSION_TOO_NEW = 15035;
    public const ERROR_EVT_CANNOT_OPEN_CHANNEL_OF_QUERY = 15036;
    public const ERROR_EVT_PUBLISHER_DISABLED = 15037;
    public const ERROR_EVT_FILTER_OUT_OF_RANGE = 15038;
    public const ERROR_EC_SUBSCRIPTION_CANNOT_ACTIVATE = 15080;
    public const ERROR_EC_LOG_DISABLED = 15081;
    public const ERROR_EC_CIRCULAR_FORWARDING = 15082;
    public const ERROR_EC_CREDSTORE_FULL = 15083;
    public const ERROR_EC_CRED_NOT_FOUND = 15084;
    public const ERROR_EC_NO_ACTIVE_CHANNEL = 15085;
    public const ERROR_MUI_FILE_NOT_FOUND = 15100;
    public const ERROR_MUI_INVALID_FILE = 15101;
    public const ERROR_MUI_INVALID_RC_CONFIG = 15102;
    public const ERROR_MUI_INVALID_LOCALE_NAME = 15103;
    public const ERROR_MUI_INVALID_ULTIMATEFALLBACK_NAME = 15104;
    public const ERROR_MUI_FILE_NOT_LOADED = 15105;
    public const ERROR_RESOURCE_ENUM_USER_STOP = 15106;
    public const ERROR_MUI_INTLSETTINGS_UILANG_NOT_INSTALLED = 15107;
    public const ERROR_MUI_INTLSETTINGS_INVALID_LOCALE_NAME = 15108;
    public const ERROR_MRM_RUNTIME_NO_DEFAULT_OR_NEUTRAL_RESOURCE = 15110;
    public const ERROR_MRM_INVALID_PRICONFIG = 15111;
    public const ERROR_MRM_INVALID_FILE_TYPE = 15112;
    public const ERROR_MRM_UNKNOWN_QUALIFIER = 15113;
    public const ERROR_MRM_INVALID_QUALIFIER_VALUE = 15114;
    public const ERROR_MRM_NO_CANDIDATE = 15115;
    public const ERROR_MRM_NO_MATCH_OR_DEFAULT_CANDIDATE = 15116;
    public const ERROR_MRM_RESOURCE_TYPE_MISMATCH = 15117;
    public const ERROR_MRM_DUPLICATE_MAP_NAME = 15118;
    public const ERROR_MRM_DUPLICATE_ENTRY = 15119;
    public const ERROR_MRM_INVALID_RESOURCE_IDENTIFIER = 15120;
    public const ERROR_MRM_FILEPATH_TOO_LONG = 15121;
    public const ERROR_MRM_UNSUPPORTED_DIRECTORY_TYPE = 15122;
    public const ERROR_MRM_INVALID_PRI_FILE = 15126;
    public const ERROR_MRM_NAMED_RESOURCE_NOT_FOUND = 15127;
    public const ERROR_MRM_MAP_NOT_FOUND = 15135;
    public const ERROR_MRM_UNSUPPORTED_PROFILE_TYPE = 15136;
    public const ERROR_MRM_INVALID_QUALIFIER_OPERATOR = 15137;
    public const ERROR_MRM_INDETERMINATE_QUALIFIER_VALUE = 15138;
    public const ERROR_MRM_AUTOMERGE_ENABLED = 15139;
    public const ERROR_MRM_TOO_MANY_RESOURCES = 15140;
    public const ERROR_MCA_INVALID_CAPABILITIES_STRING = 15200;
    public const ERROR_MCA_INVALID_VCP_VERSION = 15201;
    public const ERROR_MCA_MONITOR_VIOLATES_MCCS_SPECIFICATION = 15202;
    public const ERROR_MCA_MCCS_VERSION_MISMATCH = 15203;
    public const ERROR_MCA_UNSUPPORTED_MCCS_VERSION = 15204;
    public const ERROR_MCA_INTERNAL_ERROR = 15205;
    public const ERROR_MCA_INVALID_TECHNOLOGY_TYPE_RETURNED = 15206;
    public const ERROR_MCA_UNSUPPORTED_COLOR_TEMPERATURE = 15207;
    public const ERROR_AMBIGUOUS_SYSTEM_DEVICE = 15250;
    public const ERROR_SYSTEM_DEVICE_NOT_FOUND = 15299;
    public const ERROR_HASH_NOT_SUPPORTED = 15300;
    public const ERROR_HASH_NOT_PRESENT = 15301;
    public const ERROR_SECONDARY_IC_PROVIDER_NOT_REGISTERED = 15321;
    public const ERROR_GPIO_CLIENT_INFORMATION_INVALID = 15322;
    public const ERROR_GPIO_VERSION_NOT_SUPPORTED = 15323;
    public const ERROR_GPIO_INVALID_REGISTRATION_PACKET = 15324;
    public const ERROR_GPIO_OPERATION_DENIED = 15325;
    public const ERROR_GPIO_INCOMPATIBLE_CONNECT_MODE = 15326;
    public const ERROR_GPIO_INTERRUPT_ALREADY_UNMASKED = 15327;
    public const ERROR_CANNOT_SWITCH_RUNLEVEL = 15400;
    public const ERROR_INVALID_RUNLEVEL_SETTING = 15401;
    public const ERROR_RUNLEVEL_SWITCH_TIMEOUT = 15402;
    public const ERROR_RUNLEVEL_SWITCH_AGENT_TIMEOUT = 15403;
    public const ERROR_RUNLEVEL_SWITCH_IN_PROGRESS = 15404;
    public const ERROR_SERVICES_FAILED_AUTOSTART = 15405;
    public const ERROR_COM_TASK_STOP_PENDING = 15501;
    public const ERROR_INSTALL_OPEN_PACKAGE_FAILED = 15600;
    public const ERROR_INSTALL_PACKAGE_NOT_FOUND = 15601;
    public const ERROR_INSTALL_INVALID_PACKAGE = 15602;
    public const ERROR_INSTALL_RESOLVE_DEPENDENCY_FAILED = 15603;
    public const ERROR_INSTALL_OUT_OF_DISK_SPACE = 15604;
    public const ERROR_INSTALL_NETWORK_FAILURE = 15605;
    public const ERROR_INSTALL_REGISTRATION_FAILURE = 15606;
    public const ERROR_INSTALL_DEREGISTRATION_FAILURE = 15607;
    public const ERROR_INSTALL_CANCEL = 15608;
    public const ERROR_INSTALL_FAILED = 15609;
    public const ERROR_REMOVE_FAILED = 15610;
    public const ERROR_PACKAGE_ALREADY_EXISTS = 15611;
    public const ERROR_NEEDS_REMEDIATION = 15612;
    public const ERROR_INSTALL_PREREQUISITE_FAILED = 15613;
    public const ERROR_PACKAGE_REPOSITORY_CORRUPTED = 15614;
    public const ERROR_INSTALL_POLICY_FAILURE = 15615;
    public const ERROR_PACKAGE_UPDATING = 15616;
    public const ERROR_DEPLOYMENT_BLOCKED_BY_POLICY = 15617;
    public const ERROR_PACKAGES_IN_USE = 15618;
    public const ERROR_RECOVERY_FILE_CORRUPT = 15619;
    public const ERROR_INVALID_STAGED_SIGNATURE = 15620;
    public const ERROR_DELETING_EXISTING_APPLICATIONDATA_STORE_FAILED = 15621;
    public const ERROR_INSTALL_PACKAGE_DOWNGRADE = 15622;
    public const ERROR_SYSTEM_NEEDS_REMEDIATION = 15623;
    public const ERROR_APPX_INTEGRITY_FAILURE_CLR_NGEN = 15624;
    public const ERROR_RESILIENCY_FILE_CORRUPT = 15625;
    public const ERROR_INSTALL_FIREWALL_SERVICE_NOT_RUNNING = 15626;
    public const APPMODEL_ERROR_NO_PACKAGE = 15700;
    public const APPMODEL_ERROR_PACKAGE_RUNTIME_CORRUPT = 15701;
    public const APPMODEL_ERROR_PACKAGE_IDENTITY_CORRUPT = 15702;
    public const APPMODEL_ERROR_NO_APPLICATION = 15703;
    public const ERROR_STATE_LOAD_STORE_FAILED = 15800;
    public const ERROR_STATE_GET_VERSION_FAILED = 15801;
    public const ERROR_STATE_SET_VERSION_FAILED = 15802;
    public const ERROR_STATE_STRUCTURED_RESET_FAILED = 15803;
    public const ERROR_STATE_OPEN_CONTAINER_FAILED = 15804;
    public const ERROR_STATE_CREATE_CONTAINER_FAILED = 15805;
    public const ERROR_STATE_DELETE_CONTAINER_FAILED = 15806;
    public const ERROR_STATE_READ_SETTING_FAILED = 15807;
    public const ERROR_STATE_WRITE_SETTING_FAILED = 15808;
    public const ERROR_STATE_DELETE_SETTING_FAILED = 15809;
    public const ERROR_STATE_QUERY_SETTING_FAILED = 15810;
    public const ERROR_STATE_READ_COMPOSITE_SETTING_FAILED = 15811;
    public const ERROR_STATE_WRITE_COMPOSITE_SETTING_FAILED = 15812;
    public const ERROR_STATE_ENUMERATE_CONTAINER_FAILED = 15813;
    public const ERROR_STATE_ENUMERATE_SETTINGS_FAILED = 15814;
    public const ERROR_STATE_COMPOSITE_SETTING_VALUE_SIZE_LIMIT_EXCEEDED = 15815;
    public const ERROR_STATE_SETTING_VALUE_SIZE_LIMIT_EXCEEDED = 15816;
    public const ERROR_STATE_SETTING_NAME_SIZE_LIMIT_EXCEEDED = 15817;
    public const ERROR_STATE_CONTAINER_NAME_SIZE_LIMIT_EXCEEDED = 15818;
    public const ERROR_API_UNAVAILABLE = 15841;

    public function getDescription(): string
    {
        return ucfirst(Re::replace(str_replace(
            ['crc', 'dos', 'eof', 'sem_', 'iopl', 'eas', 'ea_', 'rpc', 'dns', 'frs', '_'],
            ['CRC', 'DOS', 'EOF', 'SEM ', 'IOPL', 'EAS', 'EA ', 'RPC', 'DNS', 'FRS', ' '],
            strtolower($this->getConstantName())
        ), '/^error /', ''));
    }

}
