<?php declare(strict_types = 1);
/**
 * This file is part of the Dogma library (https://github.com/paranoiq/dogma)
 *
 * Copyright (c) 2012 Vlasta Neubauer (@paranoiq)
 *
 * For the full copyright and license information read the file 'license.md', distributed with this source code
 */

namespace Dogma\Math;

use Dogma\StaticClassMixin;

class PowersOfTwo
{
    use StaticClassMixin;

    public const _1 = 1; // 0
    public const _2 = 2;
    public const _4 = 4;
    public const _8 = 8;
    public const _16 = 16;
    public const _32 = 32;
    public const _64 = 64;
    public const _128 = 128;
    public const _256 = 256; // 8
    public const _512 = 512;
    public const _1K = 1024;
    public const _2K = 2048;
    public const _4K = 4096;
    public const _8K = 8192;
    public const _16K = 16384;
    public const _32K = 32768;
    public const _64K = 65536; // 16
    public const _128K = 131072;
    public const _256K = 262144;
    public const _512K = 524288;
    public const _1M = 1048576;
    public const _2M = 2097152;
    public const _4M = 4194304;
    public const _8M = 8388608;
    public const _16M = 16777216; // 24
    public const _32M = 33554432;
    public const _64M = 67108864;
    public const _128M = 134217728;
    public const _256M = 268435456;
    public const _512M = 536870912;
    public const _1G = 1073741824;
    public const _2G = 2147483648;
    public const _4G = 4294967296; // 32
    public const _8G = 8589934592;
    public const _16G = 17179869184;
    public const _32G = 34359738368;
    public const _64G = 68719476736;
    public const _128G = 137438953472;
    public const _256G = 274877906944;
    public const _512G = 549755813888;
    public const _1T = 1099511627776; // 40
    public const _2T = 2199023255552;
    public const _4T = 4398046511104;
    public const _8T = 8796093022208;
    public const _16T = 17592186044416;
    public const _32T = 35184372088832;
    public const _64T = 70368744177664;
    public const _128T = 140737488355328;
    public const _256T = 281474976710656; // 48
    public const _512T = 562949953421312;
    public const _1P = 1125899906842624;
    public const _2P = 2251799813685248;
    public const _4P = 4503599627370496;
    public const _8P = 9007199254740992;
    public const _16P = 18014398509481984;
    public const _32P = 36028797018963968;
    public const _64P = 72057594037927936; // 56
    public const _128P = 144115188075855872;
    public const _256P = 288230376151711744;
    public const _512P = 576460752303423488;
    public const _1E = 1152921504606846976;
    public const _2E = 2305843009213693952;
    public const _4E = 4611686018427387904;
    public const _8E = '9223372036854775808';
    public const _16E = '18446744073709551616'; // 64

}
