<?php declare(strict_types = 1);
/**
 * This file is part of the Dogma library (https://github.com/paranoiq/dogma)
 *
 * Copyright (c) 2012 Vlasta Neubauer (@paranoiq)
 *
 * For the full copyright and license information read the file 'license.md', distributed with this source code
 */

namespace Dogma\Io\ContentType;

use Dogma\Enum\PartialStringEnum;
use Dogma\Str;
use function array_search;

class ContentType extends PartialStringEnum
{

    public const APPLICATION_1D_INTERLEAVED_PARITYFEC = 'application/1d-interleaved-parityfec';
    public const APPLICATION_3GPDASH_QOE_REPORT_XML = 'application/3gpdash-qoe-report+xml';
    public const APPLICATION_3GPP_IMS_XML = 'application/3gpp-ims+xml';
    public const APPLICATION_A2L = 'application/A2L';
    public const APPLICATION_ACTIVEMESSAGE = 'application/activemessage';
    public const APPLICATION_ALTO_COSTMAP_JSON = 'application/alto-costmap+json';
    public const APPLICATION_ALTO_COSTMAPFILTER_JSON = 'application/alto-costmapfilter+json';
    public const APPLICATION_ALTO_DIRECTORY_JSON = 'application/alto-directory+json';
    public const APPLICATION_ALTO_ENDPOINTCOST_JSON = 'application/alto-endpointcost+json';
    public const APPLICATION_ALTO_ENDPOINTCOSTPARAMS_JSON = 'application/alto-endpointcostparams+json';
    public const APPLICATION_ALTO_ENDPOINTPROP_JSON = 'application/alto-endpointprop+json';
    public const APPLICATION_ALTO_ENDPOINTPROPPARAMS_JSON = 'application/alto-endpointpropparams+json';
    public const APPLICATION_ALTO_ERROR_JSON = 'application/alto-error+json';
    public const APPLICATION_ALTO_NETWORKMAP_JSON = 'application/alto-networkmap+json';
    public const APPLICATION_ALTO_NETWORKMAPFILTER_JSON = 'application/alto-networkmapfilter+json';
    public const APPLICATION_AML = 'application/AML';
    public const APPLICATION_ANDREW_INSET = 'application/andrew-inset';
    public const APPLICATION_APPLEFILE = 'application/applefile';
    public const APPLICATION_APPLIXWARE = 'application/applixware';
    public const APPLICATION_ATF = 'application/ATF';
    public const APPLICATION_ATFX = 'application/ATFX';
    public const APPLICATION_ATOM_XML = 'application/atom+xml';
    public const APPLICATION_ATOMCAT_XML = 'application/atomcat+xml';
    public const APPLICATION_ATOMDELETED_XML = 'application/atomdeleted+xml';
    public const APPLICATION_ATOMICMAIL = 'application/atomicmail';
    public const APPLICATION_ATOMSVC_XML = 'application/atomsvc+xml';
    public const APPLICATION_ATXML = 'application/ATXML';
    public const APPLICATION_AUTH_POLICY_XML = 'application/auth-policy+xml';
    public const APPLICATION_BACNET_XDD_ZIP = 'application/bacnet-xdd+zip';
    public const APPLICATION_BATCH_SMTP = 'application/batch-SMTP';
    public const APPLICATION_BEEP_XML = 'application/beep+xml';
    public const APPLICATION_CALENDAR_JSON = 'application/calendar+json';
    public const APPLICATION_CALENDAR_XML = 'application/calendar+xml';
    public const APPLICATION_CALL_COMPLETION = 'application/call-completion';
    public const APPLICATION_CALS_1840 = 'application/CALS-1840';
    public const APPLICATION_CBOR = 'application/cbor';
    public const APPLICATION_CCMP_XML = 'application/ccmp+xml';
    public const APPLICATION_CCXML_XML = 'application/ccxml+xml';
    public const APPLICATION_CDFX_XML = 'application/CDFX+XML';
    public const APPLICATION_CDMI_CAPABILITY = 'application/cdmi-capability';
    public const APPLICATION_CDMI_CONTAINER = 'application/cdmi-container';
    public const APPLICATION_CDMI_DOMAIN = 'application/cdmi-domain';
    public const APPLICATION_CDMI_OBJECT = 'application/cdmi-object';
    public const APPLICATION_CDMI_QUEUE = 'application/cdmi-queue';
    public const APPLICATION_CDNI = 'application/cdni';
    public const APPLICATION_CEA = 'application/CEA';
    public const APPLICATION_CEA_2018_XML = 'application/cea-2018+xml';
    public const APPLICATION_CELLML_XML = 'application/cellml+xml';
    public const APPLICATION_CFW = 'application/cfw';
    public const APPLICATION_CLUE_INFO_XML = 'application/clue_info+xml';
    public const APPLICATION_CMS = 'application/cms';
    public const APPLICATION_CNRP_XML = 'application/cnrp+xml';
    public const APPLICATION_COAP_GROUP_JSON = 'application/coap-group+json';
    public const APPLICATION_COAP_PAYLOAD = 'application/coap-payload';
    public const APPLICATION_COMMONGROUND = 'application/commonground';
    public const APPLICATION_CONFERENCE_INFO_XML = 'application/conference-info+xml';
    public const APPLICATION_COSE = 'application/cose';
    public const APPLICATION_COSE_KEY = 'application/cose-key';
    public const APPLICATION_COSE_KEY_SET = 'application/cose-key-set';
    public const APPLICATION_CPL_XML = 'application/cpl+xml';
    public const APPLICATION_CSRATTRS = 'application/csrattrs';
    public const APPLICATION_CSTA_XML = 'application/csta+xml';
    public const APPLICATION_CSTADATA_XML = 'application/CSTAdata+xml';
    public const APPLICATION_CSVM_JSON = 'application/csvm+json';
    public const APPLICATION_CU_SEEME = 'application/cu-seeme';
    public const APPLICATION_CYBERCASH = 'application/cybercash';
    public const APPLICATION_DASH_XML = 'application/dash+xml';
    public const APPLICATION_DASHDELTA = 'application/dashdelta';
    public const APPLICATION_DAVMOUNT_XML = 'application/davmount+xml';
    public const APPLICATION_DCA_RFT = 'application/dca-rft';
    public const APPLICATION_DCD = 'application/DCD';
    public const APPLICATION_DEC_DX = 'application/dec-dx';
    public const APPLICATION_DIALOG_INFO_XML = 'application/dialog-info+xml';
    public const APPLICATION_DICOM = 'application/dicom';
    public const APPLICATION_DICOM_JSON = 'application/dicom+json';
    public const APPLICATION_DICOM_XML = 'application/dicom+xml';
    public const APPLICATION_DII = 'application/DII';
    public const APPLICATION_DIT = 'application/DIT';
    public const APPLICATION_DNS = 'application/dns';
    public const APPLICATION_DSKPP_XML = 'application/dskpp+xml';
    public const APPLICATION_DSSC_DER = 'application/dssc+der';
    public const APPLICATION_DSSC_XML = 'application/dssc+xml';
    public const APPLICATION_DVCS = 'application/dvcs';
    public const APPLICATION_ECMASCRIPT = 'application/ecmascript';
    public const APPLICATION_EDI_CONSENT = 'application/EDI-consent';
    public const APPLICATION_EDI_X12 = 'application/EDI-X12';
    public const APPLICATION_EDIFACT = 'application/EDIFACT';
    public const APPLICATION_EFI = 'application/efi';
    public const APPLICATION_EMERGENCYCALLDATA_COMMENT_XML = 'application/EmergencyCallData.Comment+xml';
    public const APPLICATION_EMERGENCYCALLDATA_DEVICEINFO_XML = 'application/EmergencyCallData.DeviceInfo+xml';
    public const APPLICATION_EMERGENCYCALLDATA_PROVIDERINFO_XML = 'application/EmergencyCallData.ProviderInfo+xml';
    public const APPLICATION_EMERGENCYCALLDATA_SERVICEINFO_XML = 'application/EmergencyCallData.ServiceInfo+xml';
    public const APPLICATION_EMERGENCYCALLDATA_SUBSCRIBERINFO_XML = 'application/EmergencyCallData.SubscriberInfo+xml';
    public const APPLICATION_EMMA_XML = 'application/emma+xml';
    public const APPLICATION_EMOTIONML_XML = 'application/emotionml+xml';
    public const APPLICATION_ENCAPRTP = 'application/encaprtp';
    public const APPLICATION_EPP_XML = 'application/epp+xml';
    public const APPLICATION_EPUB_ZIP = 'application/epub+zip';
    public const APPLICATION_ESHOP = 'application/eshop';
    public const APPLICATION_EXAMPLE = 'application/example';
    public const APPLICATION_EXI = 'application/exi';
    public const APPLICATION_FASTINFOSET = 'application/fastinfoset';
    public const APPLICATION_FASTSOAP = 'application/fastsoap';
    public const APPLICATION_FDT_XML = 'application/fdt+xml';
    public const APPLICATION_FITS = 'application/fits';
    public const APPLICATION_FONT_SFNT = 'application/font-sfnt';
    public const APPLICATION_FONT_TDPFR = 'application/font-tdpfr';
    public const APPLICATION_FONT_WOFF = 'application/font-woff';
    public const APPLICATION_FRAMEWORK_ATTRIBUTES_XML = 'application/framework-attributes+xml';
    public const APPLICATION_GEO_JSON = 'application/geo+json';
    public const APPLICATION_GML_XML = 'application/gml+xml';
    public const APPLICATION_GZIP = 'application/gzip';
    public const APPLICATION_H224 = 'application/H224';
    public const APPLICATION_HELD_XML = 'application/held+xml';
    public const APPLICATION_HTTP = 'application/http';
    public const APPLICATION_HYPERSTUDIO = 'application/hyperstudio';
    public const APPLICATION_IBE_KEY_REQUEST_XML = 'application/ibe-key-request+xml';
    public const APPLICATION_IBE_PKG_REPLY_XML = 'application/ibe-pkg-reply+xml';
    public const APPLICATION_IBE_PP_DATA = 'application/ibe-pp-data';
    public const APPLICATION_IGES = 'application/iges';
    public const APPLICATION_IM_ISCOMPOSING_XML = 'application/im-iscomposing+xml';
    public const APPLICATION_INDEX = 'application/index';
    public const APPLICATION_INDEX_CMD = 'application/index.cmd';
    public const APPLICATION_INDEX_OBJ = 'application/index-obj';
    public const APPLICATION_INDEX_RESPONSE = 'application/index.response';
    public const APPLICATION_INDEX_VND = 'application/index.vnd';
    public const APPLICATION_INKML_XML = 'application/inkml+xml';
    public const APPLICATION_IOTP = 'application/IOTP';
    public const APPLICATION_IPFIX = 'application/ipfix';
    public const APPLICATION_IPP = 'application/ipp';
    public const APPLICATION_ISUP = 'application/ISUP';
    public const APPLICATION_ITS_XML = 'application/its+xml';
    public const APPLICATION_JAVA_ARCHIVE = 'application/java-archive';
    public const APPLICATION_JAVA_SERIALIZED_OBJECT = 'application/java-serialized-object';
    public const APPLICATION_JAVA_VM = 'application/java-vm';
    public const APPLICATION_JAVASCRIPT = 'application/javascript';
    public const APPLICATION_JOSE = 'application/jose';
    public const APPLICATION_JOSE_JSON = 'application/jose+json';
    public const APPLICATION_JRD_JSON = 'application/jrd+json';
    public const APPLICATION_JSON = 'application/json';
    public const APPLICATION_JSON_PATCH_JSON = 'application/json-patch+json';
    public const APPLICATION_JSON_SEQ = 'application/json-seq';
    public const APPLICATION_JWK_JSON = 'application/jwk+json';
    public const APPLICATION_JWK_SET_JSON = 'application/jwk-set+json';
    public const APPLICATION_JWT = 'application/jwt';
    public const APPLICATION_KPML_REQUEST_XML = 'application/kpml-request+xml';
    public const APPLICATION_KPML_RESPONSE_XML = 'application/kpml-response+xml';
    public const APPLICATION_LD_JSON = 'application/ld+json';
    public const APPLICATION_LGR_XML = 'application/lgr+xml';
    public const APPLICATION_LINK_FORMAT = 'application/link-format';
    public const APPLICATION_LOAD_CONTROL_XML = 'application/load-control+xml';
    public const APPLICATION_LOST_XML = 'application/lost+xml';
    public const APPLICATION_LOSTSYNC_XML = 'application/lostsync+xml';
    public const APPLICATION_LXF = 'application/LXF';
    public const APPLICATION_MAC_BINHEX40 = 'application/mac-binhex40';
    public const APPLICATION_MAC_COMPACTPRO = 'application/mac-compactpro';
    public const APPLICATION_MACWRITEII = 'application/macwriteii';
    public const APPLICATION_MADS_XML = 'application/mads+xml';
    public const APPLICATION_MARC = 'application/marc';
    public const APPLICATION_MARCXML_XML = 'application/marcxml+xml';
    public const APPLICATION_MATHEMATICA = 'application/mathematica';
    public const APPLICATION_MATHML_XML = 'application/mathml+xml';
    public const APPLICATION_MBMS_ASSOCIATED_PROCEDURE_DESCRIPTION_XML = 'application/mbms-associated-procedure-description+xml';
    public const APPLICATION_MBMS_DEREGISTER_XML = 'application/mbms-deregister+xml';
    public const APPLICATION_MBMS_ENVELOPE_XML = 'application/mbms-envelope+xml';
    public const APPLICATION_MBMS_MSK_RESPONSE_XML = 'application/mbms-msk-response+xml';
    public const APPLICATION_MBMS_MSK_XML = 'application/mbms-msk+xml';
    public const APPLICATION_MBMS_PROTECTION_DESCRIPTION_XML = 'application/mbms-protection-description+xml';
    public const APPLICATION_MBMS_RECEPTION_REPORT_XML = 'application/mbms-reception-report+xml';
    public const APPLICATION_MBMS_REGISTER_RESPONSE_XML = 'application/mbms-register-response+xml';
    public const APPLICATION_MBMS_REGISTER_XML = 'application/mbms-register+xml';
    public const APPLICATION_MBMS_SCHEDULE_XML = 'application/mbms-schedule+xml';
    public const APPLICATION_MBMS_USER_SERVICE_DESCRIPTION_XML = 'application/mbms-user-service-description+xml';
    public const APPLICATION_MBOX = 'application/mbox';
    public const APPLICATION_MEDIA_CONTROL_XML = 'application/media_control+xml';
    public const APPLICATION_MEDIA_POLICY_DATASET_XML = 'application/media-policy-dataset+xml';
    public const APPLICATION_MEDIASERVERCONTROL_XML = 'application/mediaservercontrol+xml';
    public const APPLICATION_MERGE_PATCH_JSON = 'application/merge-patch+json';
    public const APPLICATION_METALINK4_XML = 'application/metalink4+xml';
    public const APPLICATION_METS_XML = 'application/mets+xml';
    public const APPLICATION_MF4 = 'application/MF4';
    public const APPLICATION_MIKEY = 'application/mikey';
    public const APPLICATION_MODS_XML = 'application/mods+xml';
    public const APPLICATION_MOSS_KEYS = 'application/moss-keys';
    public const APPLICATION_MOSS_SIGNATURE = 'application/moss-signature';
    public const APPLICATION_MOSSKEY_DATA = 'application/mosskey-data';
    public const APPLICATION_MOSSKEY_REQUEST = 'application/mosskey-request';
    public const APPLICATION_MP21 = 'application/mp21';
    public const APPLICATION_MP4 = 'application/mp4';
    public const APPLICATION_MPEG4_GENERIC = 'application/mpeg4-generic';
    public const APPLICATION_MPEG4_IOD = 'application/mpeg4-iod';
    public const APPLICATION_MPEG4_IOD_XMT = 'application/mpeg4-iod-xmt';
    public const APPLICATION_MRB_CONSUMER_XML = 'application/mrb-consumer+xml';
    public const APPLICATION_MRB_PUBLISH_XML = 'application/mrb-publish+xml';
    public const APPLICATION_MSC_IVR_XML = 'application/msc-ivr+xml';
    public const APPLICATION_MSC_MIXER_XML = 'application/msc-mixer+xml';
    public const APPLICATION_MSWORD = 'application/msword';
    public const APPLICATION_MUD_JSON = 'application/mud+json';
    public const APPLICATION_MXF = 'application/mxf';
    public const APPLICATION_NASDATA = 'application/nasdata';
    public const APPLICATION_NEWS_CHECKGROUPS = 'application/news-checkgroups';
    public const APPLICATION_NEWS_GROUPINFO = 'application/news-groupinfo';
    public const APPLICATION_NEWS_TRANSMISSION = 'application/news-transmission';
    public const APPLICATION_NLSML_XML = 'application/nlsml+xml';
    public const APPLICATION_NSS = 'application/nss';
    public const APPLICATION_OCSP_REQUEST = 'application/ocsp-request';
    public const APPLICATION_OCSP_RESPONSE = 'application/ocsp-response';
    public const APPLICATION_OCTET_STREAM = 'application/octet-stream';
    public const APPLICATION_ODA = 'application/ODA';
    public const APPLICATION_ODX = 'application/ODX';
    public const APPLICATION_OEBPS_PACKAGE_XML = 'application/oebps-package+xml';
    public const APPLICATION_OGG = 'application/ogg';
    public const APPLICATION_ONENOTE = 'application/onenote';
    public const APPLICATION_OXPS = 'application/oxps';
    public const APPLICATION_P2P_OVERLAY_XML = 'application/p2p-overlay+xml';
    public const APPLICATION_PATCH_OPS_ERROR_XML = 'application/patch-ops-error+xml';
    public const APPLICATION_PDF = 'application/pdf';
    public const APPLICATION_PDX = 'application/pdx';
    public const APPLICATION_PGP_ENCRYPTED = 'application/pgp-encrypted';
    public const APPLICATION_PGP_SIGNATURE = 'application/pgp-signature';
    public const APPLICATION_PICS_RULES = 'application/pics-rules';
    public const APPLICATION_PIDF_DIFF_XML = 'application/pidf-diff+xml';
    public const APPLICATION_PIDF_XML = 'application/pidf+xml';
    public const APPLICATION_PKCS10 = 'application/pkcs10';
    public const APPLICATION_PKCS12 = 'application/pkcs12';
    public const APPLICATION_PKCS7_MIME = 'application/pkcs7-mime';
    public const APPLICATION_PKCS7_SIGNATURE = 'application/pkcs7-signature';
    public const APPLICATION_PKCS8 = 'application/pkcs8';
    public const APPLICATION_PKIX_ATTR_CERT = 'application/pkix-attr-cert';
    public const APPLICATION_PKIX_CERT = 'application/pkix-cert';
    public const APPLICATION_PKIX_CRL = 'application/pkix-crl';
    public const APPLICATION_PKIX_PKIPATH = 'application/pkix-pkipath';
    public const APPLICATION_PKIXCMP = 'application/pkixcmp';
    public const APPLICATION_PLS_XML = 'application/pls+xml';
    public const APPLICATION_POC_SETTINGS_XML = 'application/poc-settings+xml';
    public const APPLICATION_POSTSCRIPT = 'application/postscript';
    public const APPLICATION_PPSP_TRACKER_JSON = 'application/ppsp-tracker+json';
    public const APPLICATION_PROBLEM_JSON = 'application/problem+json';
    public const APPLICATION_PROBLEM_XML = 'application/problem+xml';
    public const APPLICATION_PROVENANCE_XML = 'application/provenance+xml';
    public const APPLICATION_PRS_ALVESTRAND_TITRAX_SHEET = 'application/prs.alvestrand.titrax-sheet';
    public const APPLICATION_PRS_CWW = 'application/prs.cww';
    public const APPLICATION_PRS_HPUB_ZIP = 'application/prs.hpub+zip';
    public const APPLICATION_PRS_NPREND = 'application/prs.nprend';
    public const APPLICATION_PRS_PLUCKER = 'application/prs.plucker';
    public const APPLICATION_PRS_RDF_XML_CRYPT = 'application/prs.rdf-xml-crypt';
    public const APPLICATION_PRS_XSF_XML = 'application/prs.xsf+xml';
    public const APPLICATION_PSKC_XML = 'application/pskc+xml';
    public const APPLICATION_QSIG = 'application/QSIG';
    public const APPLICATION_RAPTORFEC = 'application/raptorfec';
    public const APPLICATION_RDAP_JSON = 'application/rdap+json';
    public const APPLICATION_RDF_XML = 'application/rdf+xml';
    public const APPLICATION_REGINFO_XML = 'application/reginfo+xml';
    public const APPLICATION_RELAX_NG_COMPACT_SYNTAX = 'application/relax-ng-compact-syntax';
    public const APPLICATION_REMOTE_PRINTING = 'application/remote-printing';
    public const APPLICATION_REPUTON_JSON = 'application/reputon+json';
    public const APPLICATION_RESOURCE_LISTS_DIFF_XML = 'application/resource-lists-diff+xml';
    public const APPLICATION_RESOURCE_LISTS_XML = 'application/resource-lists+xml';
    public const APPLICATION_RFC_XML = 'application/rfc+xml';
    public const APPLICATION_RISCOS = 'application/riscos';
    public const APPLICATION_RLMI_XML = 'application/rlmi+xml';
    public const APPLICATION_RLS_SERVICES_XML = 'application/rls-services+xml';
    public const APPLICATION_RPKI_GHOSTBUSTERS = 'application/rpki-ghostbusters';
    public const APPLICATION_RPKI_MANIFEST = 'application/rpki-manifest';
    public const APPLICATION_RPKI_ROA = 'application/rpki-roa';
    public const APPLICATION_RPKI_UPDOWN = 'application/rpki-updown';
    public const APPLICATION_RSD_XML = 'application/rsd+xml';
    public const APPLICATION_RSS_XML = 'application/rss+xml';
    public const APPLICATION_RTF = 'application/rtf';
    public const APPLICATION_RTPLOOPBACK = 'application/rtploopback';
    public const APPLICATION_RTX = 'application/rtx';
    public const APPLICATION_SAMLASSERTION_XML = 'application/samlassertion+xml';
    public const APPLICATION_SAMLMETADATA_XML = 'application/samlmetadata+xml';
    public const APPLICATION_SBML_XML = 'application/sbml+xml';
    public const APPLICATION_SCAIP_XML = 'application/scaip+xml';
    public const APPLICATION_SCIM_JSON = 'application/scim+json';
    public const APPLICATION_SCVP_CV_REQUEST = 'application/scvp-cv-request';
    public const APPLICATION_SCVP_CV_RESPONSE = 'application/scvp-cv-response';
    public const APPLICATION_SCVP_VP_REQUEST = 'application/scvp-vp-request';
    public const APPLICATION_SCVP_VP_RESPONSE = 'application/scvp-vp-response';
    public const APPLICATION_SDP = 'application/sdp';
    public const APPLICATION_SEP_EXI = 'application/sep-exi';
    public const APPLICATION_SEP_XML = 'application/sep+xml';
    public const APPLICATION_SESSION_INFO = 'application/session-info';
    public const APPLICATION_SET_PAYMENT = 'application/set-payment';
    public const APPLICATION_SET_PAYMENT_INITIATION = 'application/set-payment-initiation';
    public const APPLICATION_SET_REGISTRATION = 'application/set-registration';
    public const APPLICATION_SET_REGISTRATION_INITIATION = 'application/set-registration-initiation';
    public const APPLICATION_SGML = 'application/SGML';
    public const APPLICATION_SGML_OPEN_CATALOG = 'application/sgml-open-catalog';
    public const APPLICATION_SHF_XML = 'application/shf+xml';
    public const APPLICATION_SIEVE = 'application/sieve';
    public const APPLICATION_SIMPLE_FILTER_XML = 'application/simple-filter+xml';
    public const APPLICATION_SIMPLE_MESSAGE_SUMMARY = 'application/simple-message-summary';
    public const APPLICATION_SIMPLESYMBOLCONTAINER = 'application/simpleSymbolContainer';
    public const APPLICATION_SLATE = 'application/slate';
    public const APPLICATION_SMIL = 'application/smil';
    public const APPLICATION_SMIL_XML = 'application/smil+xml';
    public const APPLICATION_SMPTE336M = 'application/smpte336m';
    public const APPLICATION_SOAP_FASTINFOSET = 'application/soap+fastinfoset';
    public const APPLICATION_SOAP_XML = 'application/soap+xml';
    public const APPLICATION_SPARQL_QUERY = 'application/sparql-query';
    public const APPLICATION_SPARQL_RESULTS_XML = 'application/sparql-results+xml';
    public const APPLICATION_SPIRITS_EVENT_XML = 'application/spirits-event+xml';
    public const APPLICATION_SQL = 'application/sql';
    public const APPLICATION_SRGS = 'application/srgs';
    public const APPLICATION_SRGS_XML = 'application/srgs+xml';
    public const APPLICATION_SRU_XML = 'application/sru+xml';
    public const APPLICATION_SSML_XML = 'application/ssml+xml';
    public const APPLICATION_TAMP_APEX_UPDATE = 'application/tamp-apex-update';
    public const APPLICATION_TAMP_APEX_UPDATE_CONFIRM = 'application/tamp-apex-update-confirm';
    public const APPLICATION_TAMP_COMMUNITY_UPDATE = 'application/tamp-community-update';
    public const APPLICATION_TAMP_COMMUNITY_UPDATE_CONFIRM = 'application/tamp-community-update-confirm';
    public const APPLICATION_TAMP_ERROR = 'application/tamp-error';
    public const APPLICATION_TAMP_SEQUENCE_ADJUST = 'application/tamp-sequence-adjust';
    public const APPLICATION_TAMP_SEQUENCE_ADJUST_CONFIRM = 'application/tamp-sequence-adjust-confirm';
    public const APPLICATION_TAMP_STATUS_QUERY = 'application/tamp-status-query';
    public const APPLICATION_TAMP_STATUS_RESPONSE = 'application/tamp-status-response';
    public const APPLICATION_TAMP_UPDATE = 'application/tamp-update';
    public const APPLICATION_TAMP_UPDATE_CONFIRM = 'application/tamp-update-confirm';
    public const APPLICATION_TEI_XML = 'application/tei+xml';
    public const APPLICATION_THRAUD_XML = 'application/thraud+xml';
    public const APPLICATION_TIMESTAMP_QUERY = 'application/timestamp-query';
    public const APPLICATION_TIMESTAMP_REPLY = 'application/timestamp-reply';
    public const APPLICATION_TIMESTAMPED_DATA = 'application/timestamped-data';
    public const APPLICATION_TRIG = 'application/trig';
    public const APPLICATION_TTML_XML = 'application/ttml+xml';
    public const APPLICATION_TVE_TRIGGER = 'application/tve-trigger';
    public const APPLICATION_ULPFEC = 'application/ulpfec';
    public const APPLICATION_URC_GRPSHEET_XML = 'application/urc-grpsheet+xml';
    public const APPLICATION_URC_RESSHEET_XML = 'application/urc-ressheet+xml';
    public const APPLICATION_URC_TARGETDESC_XML = 'application/urc-targetdesc+xml';
    public const APPLICATION_URC_UISOCKETDESC_XML = 'application/urc-uisocketdesc+xml';
    public const APPLICATION_VCARD_JSON = 'application/vcard+json';
    public const APPLICATION_VCARD_XML = 'application/vcard+xml';
    public const APPLICATION_VEMMI = 'application/vemmi';
    public const APPLICATION_VND_3GPP2_BCMCSINFO_XML = 'application/vnd.3gpp2.bcmcsinfo+xml';
    public const APPLICATION_VND_3GPP2_SMS = 'application/vnd.3gpp2.sms';
    public const APPLICATION_VND_3GPP2_TCAP = 'application/vnd.3gpp2.tcap';
    public const APPLICATION_VND_3GPP_ACCESS_TRANSFER_EVENTS_XML = 'application/vnd.3gpp.access-transfer-events+xml';
    public const APPLICATION_VND_3GPP_BSF_XML = 'application/vnd.3gpp.bsf+xml';
    public const APPLICATION_VND_3GPP_MID_CALL_XML = 'application/vnd.3gpp.mid-call+xml';
    public const APPLICATION_VND_3GPP_PIC_BW_LARGE = 'application/vnd.3gpp.pic-bw-large';
    public const APPLICATION_VND_3GPP_PIC_BW_SMALL = 'application/vnd.3gpp.pic-bw-small';
    public const APPLICATION_VND_3GPP_PIC_BW_VAR = 'application/vnd.3gpp.pic-bw-var';
    public const APPLICATION_VND_3GPP_PROSE_PC3CH_XML = 'application/vnd.3gpp-prose-pc3ch+xml';
    public const APPLICATION_VND_3GPP_PROSE_XML = 'application/vnd.3gpp-prose+xml';
    public const APPLICATION_VND_3GPP_SMS = 'application/vnd.3gpp.sms';
    public const APPLICATION_VND_3GPP_SMS_XML = 'application/vnd.3gpp.sms+xml';
    public const APPLICATION_VND_3GPP_SRVCC_EXT_XML = 'application/vnd.3gpp.srvcc-ext+xml';
    public const APPLICATION_VND_3GPP_SRVCC_INFO_XML = 'application/vnd.3gpp.SRVCC-info+xml';
    public const APPLICATION_VND_3GPP_STATE_AND_EVENT_INFO_XML = 'application/vnd.3gpp.state-and-event-info+xml';
    public const APPLICATION_VND_3GPP_USSD_XML = 'application/vnd.3gpp.ussd+xml';
    public const APPLICATION_VND_3LIGHTSSOFTWARE_IMAGESCAL = 'application/vnd.3lightssoftware.imagescal';
    public const APPLICATION_VND_3M_POST_IT_NOTES = 'application/vnd.3M.Post-it-Notes';
    public const APPLICATION_VND_ACCPAC_SIMPLY_ASO = 'application/vnd.accpac.simply.aso';
    public const APPLICATION_VND_ACCPAC_SIMPLY_IMP = 'application/vnd.accpac.simply.imp';
    public const APPLICATION_VND_ACUCOBOL = 'application/vnd-acucobol';
    public const APPLICATION_VND_ACUCORP = 'application/vnd.acucorp';
    public const APPLICATION_VND_ADOBE_AIR_APPLICATION_INSTALLER_PACKAGE_ZIP = 'application/vnd.adobe.air-application-installer-package+zip';
    public const APPLICATION_VND_ADOBE_FLASH_MOVIE = 'application/vnd.adobe.flash-movie';
    public const APPLICATION_VND_ADOBE_FORMSCENTRAL_FCDT = 'application/vnd.adobe.formscentral.fcdt';
    public const APPLICATION_VND_ADOBE_FXP = 'application/vnd.adobe.fxp';
    public const APPLICATION_VND_ADOBE_PARTIAL_UPLOAD = 'application/vnd.adobe.partial-upload';
    public const APPLICATION_VND_ADOBE_XDP_XML = 'application/vnd.adobe.xdp+xml';
    public const APPLICATION_VND_ADOBE_XFDF = 'application/vnd.adobe.xfdf';
    public const APPLICATION_VND_AETHER_IMP = 'application/vnd.aether.imp';
    public const APPLICATION_VND_AH_BARCODE = 'application/vnd.ah-barcode';
    public const APPLICATION_VND_AHEAD_SPACE = 'application/vnd.ahead.space';
    public const APPLICATION_VND_AIRZIP_FILESECURE_AZF = 'application/vnd.airzip.filesecure.azf';
    public const APPLICATION_VND_AIRZIP_FILESECURE_AZS = 'application/vnd.airzip.filesecure.azs';
    public const APPLICATION_VND_AMAZON_EBOOK = 'application/vnd.amazon.ebook';
    public const APPLICATION_VND_AMAZON_MOBI8_EBOOK = 'application/vnd.amazon.mobi8-ebook';
    public const APPLICATION_VND_AMERICANDYNAMICS_ACC = 'application/vnd.americandynamics.acc';
    public const APPLICATION_VND_AMIGA_AMI = 'application/vnd.amiga.ami';
    public const APPLICATION_VND_AMUNDSEN_MAZE_XML = 'application/vnd.amundsen.maze+xml';
    public const APPLICATION_VND_ANDROID_PACKAGE_ARCHIVE = 'application/vnd.android.package-archive';
    public const APPLICATION_VND_ANKI = 'application/vnd.anki';
    public const APPLICATION_VND_ANSER_WEB_CERTIFICATE_ISSUE_INITIATION = 'application/vnd.anser-web-certificate-issue-initiation';
    public const APPLICATION_VND_ANSER_WEB_FUNDS_TRANSFER_INITIATION = 'application/vnd.anser-web-funds-transfer-initiation';
    public const APPLICATION_VND_ANTIX_GAME_COMPONENT = 'application/vnd.antix.game-component';
    public const APPLICATION_VND_APACHE_THRIFT_BINARY = 'application/vnd.apache.thrift.binary';
    public const APPLICATION_VND_APACHE_THRIFT_COMPACT = 'application/vnd.apache.thrift.compact';
    public const APPLICATION_VND_APACHE_THRIFT_JSON = 'application/vnd.apache.thrift.json';
    public const APPLICATION_VND_API_JSON = 'application/vnd.api+json';
    public const APPLICATION_VND_APPLE_INSTALLER_XML = 'application/vnd.apple.installer+xml';
    public const APPLICATION_VND_APPLE_MPEGURL = 'application/vnd.apple.mpegurl';
    public const APPLICATION_VND_ARASTRA_SWI = 'application/vnd.arastra.swi';
    public const APPLICATION_VND_ARISTANETWORKS_SWI = 'application/vnd.aristanetworks.swi';
    public const APPLICATION_VND_ARTSQUARE = 'application/vnd.artsquare';
    public const APPLICATION_VND_ASTRAEA_SOFTWARE_IOTA = 'application/vnd.astraea-software.iota';
    public const APPLICATION_VND_AUDIOGRAPH = 'application/vnd.audiograph';
    public const APPLICATION_VND_AUTOPACKAGE = 'application/vnd.autopackage';
    public const APPLICATION_VND_AVISTAR_XML = 'application/vnd.avistar+xml';
    public const APPLICATION_VND_BALSAMIQ_BMML_XML = 'application/vnd.balsamiq.bmml+xml';
    public const APPLICATION_VND_BALSAMIQ_BMPR = 'application/vnd.balsamiq.bmpr';
    public const APPLICATION_VND_BEKITZUR_STECH_JSON = 'application/vnd.bekitzur-stech+json';
    public const APPLICATION_VND_BIOPAX_RDF_XML = 'application/vnd.biopax.rdf+xml';
    public const APPLICATION_VND_BLUEICE_MULTIPASS = 'application/vnd.blueice.multipass';
    public const APPLICATION_VND_BLUETOOTH_EP_OOB = 'application/vnd.bluetooth.ep.oob';
    public const APPLICATION_VND_BLUETOOTH_LE_OOB = 'application/vnd.bluetooth.le.oob';
    public const APPLICATION_VND_BMI = 'application/vnd.bmi';
    public const APPLICATION_VND_BUSINESSOBJECTS = 'application/vnd.businessobjects';
    public const APPLICATION_VND_CAB_JSCRIPT = 'application/vnd.cab-jscript';
    public const APPLICATION_VND_CANON_CPDL = 'application/vnd.canon-cpdl';
    public const APPLICATION_VND_CANON_LIPS = 'application/vnd.canon-lips';
    public const APPLICATION_VND_CENDIO_THINLINC_CLIENTCONF = 'application/vnd.cendio.thinlinc.clientconf';
    public const APPLICATION_VND_CENTURY_SYSTEMS_TCP_STREAM = 'application/vnd.century-systems.tcp_stream';
    public const APPLICATION_VND_CHEMDRAW_XML = 'application/vnd.chemdraw+xml';
    public const APPLICATION_VND_CHESS_PGN = 'application/vnd.chess-pgn';
    public const APPLICATION_VND_CHIPNUTS_KARAOKE_MMD = 'application/vnd.chipnuts.karaoke-mmd';
    public const APPLICATION_VND_CINDERELLA = 'application/vnd.cinderella';
    public const APPLICATION_VND_CIRPACK_ISDN_EXT = 'application/vnd.cirpack.isdn-ext';
    public const APPLICATION_VND_CITATIONSTYLES_STYLE_XML = 'application/vnd.citationstyles.style+xml';
    public const APPLICATION_VND_CLAYMORE = 'application/vnd.claymore';
    public const APPLICATION_VND_CLOANTO_RP9 = 'application/vnd.cloanto.rp9';
    public const APPLICATION_VND_CLONK_C4GROUP = 'application/vnd.clonk.c4group';
    public const APPLICATION_VND_CLUETRUST_CARTOMOBILE_CONFIG = 'application/vnd.cluetrust.cartomobile-config';
    public const APPLICATION_VND_CLUETRUST_CARTOMOBILE_CONFIG_PKG = 'application/vnd.cluetrust.cartomobile-config-pkg';
    public const APPLICATION_VND_COFFEESCRIPT = 'application/vnd.coffeescript';
    public const APPLICATION_VND_COLLECTION_DOC_JSON = 'application/vnd.collection.doc+json';
    public const APPLICATION_VND_COLLECTION_JSON = 'application/vnd.collection+json';
    public const APPLICATION_VND_COLLECTION_NEXT_JSON = 'application/vnd.collection.next+json';
    public const APPLICATION_VND_COMICBOOK_ZIP = 'application/vnd.comicbook+zip';
    public const APPLICATION_VND_COMMERCE_BATTELLE = 'application/vnd.commerce-battelle';
    public const APPLICATION_VND_COMMONSPACE = 'application/vnd.commonspace';
    public const APPLICATION_VND_CONTACT_CMSG = 'application/vnd.contact.cmsg';
    public const APPLICATION_VND_COREOS_IGNITION_JSON = 'application/vnd.coreos.ignition+json';
    public const APPLICATION_VND_COSMOCALLER = 'application/vnd.cosmocaller';
    public const APPLICATION_VND_CRICK_CLICKER = 'application/vnd.crick.clicker';
    public const APPLICATION_VND_CRICK_CLICKER_KEYBOARD = 'application/vnd.crick.clicker.keyboard';
    public const APPLICATION_VND_CRICK_CLICKER_PALETTE = 'application/vnd.crick.clicker.palette';
    public const APPLICATION_VND_CRICK_CLICKER_TEMPLATE = 'application/vnd.crick.clicker.template';
    public const APPLICATION_VND_CRICK_CLICKER_WORDBANK = 'application/vnd.crick.clicker.wordbank';
    public const APPLICATION_VND_CRITICALTOOLS_WBS_XML = 'application/vnd.criticaltools.wbs+xml';
    public const APPLICATION_VND_CTC_POSML = 'application/vnd.ctc-posml';
    public const APPLICATION_VND_CTCT_WS_XML = 'application/vnd.ctct.ws+xml';
    public const APPLICATION_VND_CUPS_PDF = 'application/vnd.cups-pdf';
    public const APPLICATION_VND_CUPS_POSTSCRIPT = 'application/vnd.cups-postscript';
    public const APPLICATION_VND_CUPS_PPD = 'application/vnd.cups-ppd';
    public const APPLICATION_VND_CUPS_RASTER = 'application/vnd.cups-raster';
    public const APPLICATION_VND_CUPS_RAW = 'application/vnd.cups-raw';
    public const APPLICATION_VND_CURL = 'application/vnd-curl';
    public const APPLICATION_VND_CURL_CAR = 'application/vnd.curl.car';
    public const APPLICATION_VND_CURL_PCURL = 'application/vnd.curl.pcurl';
    public const APPLICATION_VND_CYAN_DEAN_ROOT_XML = 'application/vnd.cyan.dean.root+xml';
    public const APPLICATION_VND_CYBANK = 'application/vnd.cybank';
    public const APPLICATION_VND_D2L_COURSEPACKAGE1P0_ZIP = 'application/vnd.d2l.coursepackage1p0+zip';
    public const APPLICATION_VND_DART = 'application/vnd-dart';
    public const APPLICATION_VND_DATA_VISION_RDZ = 'application/vnd.data-vision.rdz';
    public const APPLICATION_VND_DATARESOURCE_JSON = 'application/vnd.dataresource+json';
    public const APPLICATION_VND_DEBIAN_BINARY_PACKAGE = 'application/vnd.debian.binary-package';
    public const APPLICATION_VND_DECE_DATA = 'application/vnd.dece.data';
    public const APPLICATION_VND_DECE_TTML_XML = 'application/vnd.dece.ttml+xml';
    public const APPLICATION_VND_DECE_UNSPECIFIED = 'application/vnd.dece.unspecified';
    public const APPLICATION_VND_DECE_ZIP = 'application/vnd.dece-zip';
    public const APPLICATION_VND_DENOVO_FCSELAYOUT_LINK = 'application/vnd.denovo.fcselayout-link';
    public const APPLICATION_VND_DESMUME_MOVIE = 'application/vnd.desmume-movie';
    public const APPLICATION_VND_DIR_BI_PLATE_DL_NOSUFFIX = 'application/vnd.dir-bi.plate-dl-nosuffix';
    public const APPLICATION_VND_DM_DELEGATION_XML = 'application/vnd.dm.delegation+xml';
    public const APPLICATION_VND_DNA = 'application/vnd.dna';
    public const APPLICATION_VND_DOCUMENT_JSON = 'application/vnd.document+json';
    public const APPLICATION_VND_DOLBY_MLP = 'application/vnd.dolby.mlp';
    public const APPLICATION_VND_DOLBY_MOBILE_1 = 'application/vnd.dolby.mobile.1';
    public const APPLICATION_VND_DOLBY_MOBILE_2 = 'application/vnd.dolby.mobile.2';
    public const APPLICATION_VND_DOREMIR_SCORECLOUD_BINARY_DOCUMENT = 'application/vnd.doremir.scorecloud-binary-document';
    public const APPLICATION_VND_DPGRAPH = 'application/vnd.dpgraph';
    public const APPLICATION_VND_DREAMFACTORY = 'application/vnd.dreamfactory';
    public const APPLICATION_VND_DRIVE_JSON = 'application/vnd.drive+json';
    public const APPLICATION_VND_DTG_LOCAL = 'application/vnd.dtg.local';
    public const APPLICATION_VND_DTG_LOCAL_FLASH = 'application/vnd.dtg.local.flash';
    public const APPLICATION_VND_DTG_LOCAL_HTML = 'application/vnd.dtg.local-html';
    public const APPLICATION_VND_DVB_AIT = 'application/vnd.dvb.ait';
    public const APPLICATION_VND_DVB_DVBJ = 'application/vnd.dvb.dvbj';
    public const APPLICATION_VND_DVB_ESGCONTAINER = 'application/vnd.dvb.esgcontainer';
    public const APPLICATION_VND_DVB_IPDCDFTNOTIFACCESS = 'application/vnd.dvb.ipdcdftnotifaccess';
    public const APPLICATION_VND_DVB_IPDCESGACCESS = 'application/vnd.dvb.ipdcesgaccess';
    public const APPLICATION_VND_DVB_IPDCESGACCESS2 = 'application/vnd.dvb.ipdcesgaccess2';
    public const APPLICATION_VND_DVB_IPDCESGPDD = 'application/vnd.dvb.ipdcesgpdd';
    public const APPLICATION_VND_DVB_IPDCROAMING = 'application/vnd.dvb.ipdcroaming';
    public const APPLICATION_VND_DVB_IPTV_ALFEC_BASE = 'application/vnd.dvb.iptv.alfec-base';
    public const APPLICATION_VND_DVB_IPTV_ALFEC_ENHANCEMENT = 'application/vnd.dvb.iptv.alfec-enhancement';
    public const APPLICATION_VND_DVB_NOTIF_AGGREGATE_ROOT_XML = 'application/vnd.dvb.notif-aggregate-root+xml';
    public const APPLICATION_VND_DVB_NOTIF_CONTAINER_XML = 'application/vnd.dvb.notif-container+xml';
    public const APPLICATION_VND_DVB_NOTIF_GENERIC_XML = 'application/vnd.dvb.notif-generic+xml';
    public const APPLICATION_VND_DVB_NOTIF_IA_MSGLIST_XML = 'application/vnd.dvb.notif-ia-msglist+xml';
    public const APPLICATION_VND_DVB_NOTIF_IA_REGISTRATION_REQUEST_XML = 'application/vnd.dvb.notif-ia-registration-request+xml';
    public const APPLICATION_VND_DVB_NOTIF_IA_REGISTRATION_RESPONSE_XML = 'application/vnd.dvb.notif-ia-registration-response+xml';
    public const APPLICATION_VND_DVB_NOTIF_INIT_XML = 'application/vnd.dvb.notif-init+xml';
    public const APPLICATION_VND_DVB_PFR = 'application/vnd.dvb.pfr';
    public const APPLICATION_VND_DVB_SERVICE = 'application/vnd.dvb_service';
    public const APPLICATION_VND_DXR = 'application/vnd-dxr';
    public const APPLICATION_VND_DYNAGEO = 'application/vnd.dynageo';
    public const APPLICATION_VND_DZR = 'application/vnd.dzr';
    public const APPLICATION_VND_EASYKARAOKE_CDGDOWNLOAD = 'application/vnd.easykaraoke.cdgdownload';
    public const APPLICATION_VND_ECDIS_UPDATE = 'application/vnd.ecdis-update';
    public const APPLICATION_VND_ECOWIN_CHART = 'application/vnd.ecowin.chart';
    public const APPLICATION_VND_ECOWIN_FILEREQUEST = 'application/vnd.ecowin.filerequest';
    public const APPLICATION_VND_ECOWIN_FILEUPDATE = 'application/vnd.ecowin.fileupdate';
    public const APPLICATION_VND_ECOWIN_SERIES = 'application/vnd.ecowin.series';
    public const APPLICATION_VND_ECOWIN_SERIESREQUEST = 'application/vnd.ecowin.seriesrequest';
    public const APPLICATION_VND_ECOWIN_SERIESUPDATE = 'application/vnd.ecowin.seriesupdate';
    public const APPLICATION_VND_EFI_ISO = 'application/vnd.efi-iso';
    public const APPLICATION_VND_EMCLIENT_ACCESSREQUEST_XML = 'application/vnd.emclient.accessrequest+xml';
    public const APPLICATION_VND_ENLIVEN = 'application/vnd.enliven';
    public const APPLICATION_VND_ENPHASE_ENVOY = 'application/vnd.enphase.envoy';
    public const APPLICATION_VND_EPRINTS_DATA_XML = 'application/vnd.eprints.data+xml';
    public const APPLICATION_VND_EPSON_ESF = 'application/vnd.epson.esf';
    public const APPLICATION_VND_EPSON_MSF = 'application/vnd.epson.msf';
    public const APPLICATION_VND_EPSON_QUICKANIME = 'application/vnd.epson.quickanime';
    public const APPLICATION_VND_EPSON_SALT = 'application/vnd.epson.salt';
    public const APPLICATION_VND_EPSON_SSF = 'application/vnd.epson.ssf';
    public const APPLICATION_VND_ERICSSON_QUICKCALL = 'application/vnd.ericsson.quickcall';
    public const APPLICATION_VND_ESPASS_ESPASS_ZIP = 'application/vnd.espass-espass+zip';
    public const APPLICATION_VND_ESZIGNO3_XML = 'application/vnd.eszigno3+xml';
    public const APPLICATION_VND_ETSI_AOC_XML = 'application/vnd.etsi.aoc+xml';
    public const APPLICATION_VND_ETSI_ASIC_E_ZIP = 'application/vnd.etsi.asic-e+zip';
    public const APPLICATION_VND_ETSI_ASIC_S_ZIP = 'application/vnd.etsi.asic-s+zip';
    public const APPLICATION_VND_ETSI_CUG_XML = 'application/vnd.etsi.cug+xml';
    public const APPLICATION_VND_ETSI_IPTVCOMMAND_XML = 'application/vnd.etsi.iptvcommand+xml';
    public const APPLICATION_VND_ETSI_IPTVDISCOVERY_XML = 'application/vnd.etsi.iptvdiscovery+xml';
    public const APPLICATION_VND_ETSI_IPTVPROFILE_XML = 'application/vnd.etsi.iptvprofile+xml';
    public const APPLICATION_VND_ETSI_IPTVSAD_BC_XML = 'application/vnd.etsi.iptvsad-bc+xml';
    public const APPLICATION_VND_ETSI_IPTVSAD_COD_XML = 'application/vnd.etsi.iptvsad-cod+xml';
    public const APPLICATION_VND_ETSI_IPTVSAD_NPVR_XML = 'application/vnd.etsi.iptvsad-npvr+xml';
    public const APPLICATION_VND_ETSI_IPTVSERVICE_XML = 'application/vnd.etsi.iptvservice+xml';
    public const APPLICATION_VND_ETSI_IPTVSYNC_XML = 'application/vnd.etsi.iptvsync+xml';
    public const APPLICATION_VND_ETSI_IPTVUEPROFILE_XML = 'application/vnd.etsi.iptvueprofile+xml';
    public const APPLICATION_VND_ETSI_MCID_XML = 'application/vnd.etsi.mcid+xml';
    public const APPLICATION_VND_ETSI_MHEG5 = 'application/vnd.etsi.mheg5';
    public const APPLICATION_VND_ETSI_OVERLOAD_CONTROL_POLICY_DATASET_XML = 'application/vnd.etsi.overload-control-policy-dataset+xml';
    public const APPLICATION_VND_ETSI_PSTN_XML = 'application/vnd.etsi.pstn+xml';
    public const APPLICATION_VND_ETSI_SCI_XML = 'application/vnd.etsi.sci+xml';
    public const APPLICATION_VND_ETSI_SIMSERVS_XML = 'application/vnd.etsi.simservs+xml';
    public const APPLICATION_VND_ETSI_TIMESTAMP_TOKEN = 'application/vnd.etsi.timestamp-token';
    public const APPLICATION_VND_ETSI_TSL_DER = 'application/vnd.etsi.tsl.der';
    public const APPLICATION_VND_ETSI_TSL_XML = 'application/vnd.etsi.tsl+xml';
    public const APPLICATION_VND_EUDORA_DATA = 'application/vnd.eudora.data';
    public const APPLICATION_VND_EZPIX_ALBUM = 'application/vnd.ezpix-album';
    public const APPLICATION_VND_EZPIX_PACKAGE = 'application/vnd.ezpix-package';
    public const APPLICATION_VND_F_SECURE_MOBILE = 'application/vnd.f-secure.mobile';
    public const APPLICATION_VND_FASTCOPY_DISK_IMAGE = 'application/vnd.fastcopy-disk-image';
    public const APPLICATION_VND_FDF = 'application/vnd-fdf';
    public const APPLICATION_VND_FDSN_MSEED = 'application/vnd.fdsn.mseed';
    public const APPLICATION_VND_FDSN_SEED = 'application/vnd.fdsn.seed';
    public const APPLICATION_VND_FFSNS = 'application/vnd.ffsns';
    public const APPLICATION_VND_FILMIT_ZFC = 'application/vnd.filmit.zfc';
    public const APPLICATION_VND_FINTS = 'application/vnd.fints';
    public const APPLICATION_VND_FIREMONKEYS_CLOUDCELL = 'application/vnd.firemonkeys.cloudcell';
    public const APPLICATION_VND_FLOGRAPHIT = 'application/vnd.FloGraphIt';
    public const APPLICATION_VND_FLUXTIME_CLIP = 'application/vnd.fluxtime.clip';
    public const APPLICATION_VND_FONT_FONTFORGE_SFD = 'application/vnd.font-fontforge-sfd';
    public const APPLICATION_VND_FRAMEMAKER = 'application/vnd.framemaker';
    public const APPLICATION_VND_FROGANS_FNC = 'application/vnd.frogans.fnc';
    public const APPLICATION_VND_FROGANS_LTF = 'application/vnd.frogans.ltf';
    public const APPLICATION_VND_FSC_WEBLAUNCH = 'application/vnd.fsc.weblaunch';
    public const APPLICATION_VND_FUJITSU_OASYS = 'application/vnd.fujitsu.oasys';
    public const APPLICATION_VND_FUJITSU_OASYS2 = 'application/vnd.fujitsu.oasys2';
    public const APPLICATION_VND_FUJITSU_OASYS3 = 'application/vnd.fujitsu.oasys3';
    public const APPLICATION_VND_FUJITSU_OASYSGP = 'application/vnd.fujitsu.oasysgp';
    public const APPLICATION_VND_FUJITSU_OASYSPRS = 'application/vnd.fujitsu.oasysprs';
    public const APPLICATION_VND_FUJIXEROX_ART4 = 'application/vnd.fujixerox.ART4';
    public const APPLICATION_VND_FUJIXEROX_ART_EX = 'application/vnd.fujixerox.ART-EX';
    public const APPLICATION_VND_FUJIXEROX_DDD = 'application/vnd.fujixerox.ddd';
    public const APPLICATION_VND_FUJIXEROX_DOCUWORKS = 'application/vnd.fujixerox.docuworks';
    public const APPLICATION_VND_FUJIXEROX_DOCUWORKS_BINDER = 'application/vnd.fujixerox.docuworks.binder';
    public const APPLICATION_VND_FUJIXEROX_DOCUWORKS_CONTAINER = 'application/vnd.fujixerox.docuworks.container';
    public const APPLICATION_VND_FUJIXEROX_HBPL = 'application/vnd.fujixerox.HBPL';
    public const APPLICATION_VND_FUT_MISNET = 'application/vnd.fut-misnet';
    public const APPLICATION_VND_FUZZYSHEET = 'application/vnd.fuzzysheet';
    public const APPLICATION_VND_GENOMATIX_TUXEDO = 'application/vnd.genomatix.tuxedo';
    public const APPLICATION_VND_GEO_JSON = 'application/vnd.geo+json';
    public const APPLICATION_VND_GEOCUBE_XML = 'application/vnd.geocube+xml';
    public const APPLICATION_VND_GEOGEBRA_FILE = 'application/vnd.geogebra.file';
    public const APPLICATION_VND_GEOGEBRA_TOOL = 'application/vnd.geogebra.tool';
    public const APPLICATION_VND_GEOMETRY_EXPLORER = 'application/vnd.geometry-explorer';
    public const APPLICATION_VND_GEONEXT = 'application/vnd.geonext';
    public const APPLICATION_VND_GEOPLAN = 'application/vnd.geoplan';
    public const APPLICATION_VND_GEOSPACE = 'application/vnd.geospace';
    public const APPLICATION_VND_GERBER = 'application/vnd.gerber';
    public const APPLICATION_VND_GLOBALPLATFORM_CARD_CONTENT_MGT = 'application/vnd.globalplatform.card-content-mgt';
    public const APPLICATION_VND_GLOBALPLATFORM_CARD_CONTENT_MGT_RESPONSE = 'application/vnd.globalplatform.card-content-mgt-response';
    public const APPLICATION_VND_GMX = 'application/vnd.gmx';
    public const APPLICATION_VND_GOOGLE_EARTH_KML_XML = 'application/vnd.google-earth.kml+xml';
    public const APPLICATION_VND_GOOGLE_EARTH_KMZ = 'application/vnd.google-earth.kmz';
    public const APPLICATION_VND_GOV_SK_E_FORM_XML = 'application/vnd.gov.sk.e-form+xml';
    public const APPLICATION_VND_GOV_SK_E_FORM_ZIP = 'application/vnd.gov.sk.e-form+zip';
    public const APPLICATION_VND_GOV_SK_XMLDATACONTAINER_XML = 'application/vnd.gov.sk.xmldatacontainer+xml';
    public const APPLICATION_VND_GRAFEQ = 'application/vnd.grafeq';
    public const APPLICATION_VND_GRIDMP = 'application/vnd.gridmp';
    public const APPLICATION_VND_GROOVE_ACCOUNT = 'application/vnd.groove-account';
    public const APPLICATION_VND_GROOVE_HELP = 'application/vnd.groove-help';
    public const APPLICATION_VND_GROOVE_IDENTITY_MESSAGE = 'application/vnd.groove-identity-message';
    public const APPLICATION_VND_GROOVE_INJECTOR = 'application/vnd.groove-injector';
    public const APPLICATION_VND_GROOVE_TOOL_MESSAGE = 'application/vnd.groove-tool-message';
    public const APPLICATION_VND_GROOVE_TOOL_TEMPLATE = 'application/vnd.groove-tool-template';
    public const APPLICATION_VND_GROOVE_VCARD = 'application/vnd.groove-vcard';
    public const APPLICATION_VND_HAL_JSON = 'application/vnd.hal+json';
    public const APPLICATION_VND_HAL_XML = 'application/vnd.hal+xml';
    public const APPLICATION_VND_HANDHELD_ENTERTAINMENT_XML = 'application/vnd.HandHeld-Entertainment+xml';
    public const APPLICATION_VND_HBCI = 'application/vnd.hbci';
    public const APPLICATION_VND_HC_JSON = 'application/vnd.hc+json';
    public const APPLICATION_VND_HCL_BIREPORTS = 'application/vnd.hcl-bireports';
    public const APPLICATION_VND_HDT = 'application/vnd.hdt';
    public const APPLICATION_VND_HEROKU_JSON = 'application/vnd.heroku+json';
    public const APPLICATION_VND_HHE_LESSON_PLAYER = 'application/vnd.hhe.lesson-player';
    public const APPLICATION_VND_HP_HPGL = 'application/vnd.hp-HPGL';
    public const APPLICATION_VND_HP_HPID = 'application/vnd.hp-hpid';
    public const APPLICATION_VND_HP_HPS = 'application/vnd.hp-hps';
    public const APPLICATION_VND_HP_JLYT = 'application/vnd.hp-jlyt';
    public const APPLICATION_VND_HP_PCL = 'application/vnd.hp-PCL';
    public const APPLICATION_VND_HP_PCLXL = 'application/vnd.hp-PCLXL';
    public const APPLICATION_VND_HTTPHONE = 'application/vnd.httphone';
    public const APPLICATION_VND_HYDROSTATIX_SOF_DATA = 'application/vnd.hydrostatix.sof-data';
    public const APPLICATION_VND_HYPERDRIVE_JSON = 'application/vnd.hyperdrive+json';
    public const APPLICATION_VND_HZN_3D_CROSSWORD = 'application/vnd.hzn-3d-crossword';
    public const APPLICATION_VND_IBM_AFPLINEDATA = 'application/vnd.ibm.afplinedata';
    public const APPLICATION_VND_IBM_ELECTRONIC_MEDIA = 'application/vnd.ibm.electronic-media';
    public const APPLICATION_VND_IBM_MINIPAY = 'application/vnd.ibm.MiniPay';
    public const APPLICATION_VND_IBM_MODCAP = 'application/vnd.ibm.modcap';
    public const APPLICATION_VND_IBM_RIGHTS_MANAGEMENT = 'application/vnd.ibm.rights-management';
    public const APPLICATION_VND_IBM_SECURE_CONTAINER = 'application/vnd.ibm.secure-container';
    public const APPLICATION_VND_ICCPROFILE = 'application/vnd.iccprofile';
    public const APPLICATION_VND_IEEE_1905 = 'application/vnd.ieee.1905';
    public const APPLICATION_VND_IGLOADER = 'application/vnd.igloader';
    public const APPLICATION_VND_IMMERVISION_IVP = 'application/vnd.immervision-ivp';
    public const APPLICATION_VND_IMMERVISION_IVU = 'application/vnd.immervision-ivu';
    public const APPLICATION_VND_IMS_IMSCCV1P1 = 'application/vnd.ims.imsccv1p1';
    public const APPLICATION_VND_IMS_IMSCCV1P2 = 'application/vnd.ims.imsccv1p2';
    public const APPLICATION_VND_IMS_IMSCCV1P3 = 'application/vnd.ims.imsccv1p3';
    public const APPLICATION_VND_IMS_LIS_V2_RESULT_JSON = 'application/vnd.ims.lis.v2.result+json';
    public const APPLICATION_VND_IMS_LTI_V2_TOOLCONSUMERPROFILE_JSON = 'application/vnd.ims.lti.v2.toolconsumerprofile+json';
    public const APPLICATION_VND_IMS_LTI_V2_TOOLPROXY_ID_JSON = 'application/vnd.ims.lti.v2.toolproxy.id+json';
    public const APPLICATION_VND_IMS_LTI_V2_TOOLPROXY_JSON = 'application/vnd.ims.lti.v2.toolproxy+json';
    public const APPLICATION_VND_IMS_LTI_V2_TOOLSETTINGS_JSON = 'application/vnd.ims.lti.v2.toolsettings+json';
    public const APPLICATION_VND_IMS_LTI_V2_TOOLSETTINGS_SIMPLE_JSON = 'application/vnd.ims.lti.v2.toolsettings.simple+json';
    public const APPLICATION_VND_INFORMEDCONTROL_RMS_XML = 'application/vnd.informedcontrol.rms+xml';
    public const APPLICATION_VND_INFORMIX_VISIONARY = 'application/vnd.informix-visionary';
    public const APPLICATION_VND_INFOTECH_PROJECT = 'application/vnd.infotech.project';
    public const APPLICATION_VND_INFOTECH_PROJECT_XML = 'application/vnd.infotech.project+xml';
    public const APPLICATION_VND_INNOPATH_WAMP_NOTIFICATION = 'application/vnd.innopath.wamp.notification';
    public const APPLICATION_VND_INSORS_IGM = 'application/vnd.insors.igm';
    public const APPLICATION_VND_INTERCON_FORMNET = 'application/vnd.intercon.formnet';
    public const APPLICATION_VND_INTERGEO = 'application/vnd.intergeo';
    public const APPLICATION_VND_INTERTRUST_DIGIBOX = 'application/vnd.intertrust.digibox';
    public const APPLICATION_VND_INTERTRUST_NNCP = 'application/vnd.intertrust.nncp';
    public const APPLICATION_VND_INTU_QBO = 'application/vnd.intu.qbo';
    public const APPLICATION_VND_INTU_QFX = 'application/vnd.intu.qfx';
    public const APPLICATION_VND_IPTC_G2_CATALOGITEM_XML = 'application/vnd.iptc.g2.catalogitem+xml';
    public const APPLICATION_VND_IPTC_G2_CONCEPTITEM_XML = 'application/vnd.iptc.g2.conceptitem+xml';
    public const APPLICATION_VND_IPTC_G2_KNOWLEDGEITEM_XML = 'application/vnd.iptc.g2.knowledgeitem+xml';
    public const APPLICATION_VND_IPTC_G2_NEWSITEM_XML = 'application/vnd.iptc.g2.newsitem+xml';
    public const APPLICATION_VND_IPTC_G2_NEWSMESSAGE_XML = 'application/vnd.iptc.g2.newsmessage+xml';
    public const APPLICATION_VND_IPTC_G2_PACKAGEITEM_XML = 'application/vnd.iptc.g2.packageitem+xml';
    public const APPLICATION_VND_IPTC_G2_PLANNINGITEM_XML = 'application/vnd.iptc.g2.planningitem+xml';
    public const APPLICATION_VND_IPUNPLUGGED_RCPROFILE = 'application/vnd.ipunplugged.rcprofile';
    public const APPLICATION_VND_IREPOSITORY_PACKAGE_XML = 'application/vnd.irepository.package+xml';
    public const APPLICATION_VND_IS_XPR = 'application/vnd.is-xpr';
    public const APPLICATION_VND_ISAC_FCS = 'application/vnd.isac.fcs';
    public const APPLICATION_VND_JAM = 'application/vnd.jam';
    public const APPLICATION_VND_JAPANNET_DIRECTORY_SERVICE = 'application/vnd.japannet-directory-service';
    public const APPLICATION_VND_JAPANNET_JPNSTORE_WAKEUP = 'application/vnd.japannet-jpnstore-wakeup';
    public const APPLICATION_VND_JAPANNET_PAYMENT_WAKEUP = 'application/vnd.japannet-payment-wakeup';
    public const APPLICATION_VND_JAPANNET_REGISTRATION = 'application/vnd.japannet-registration';
    public const APPLICATION_VND_JAPANNET_REGISTRATION_WAKEUP = 'application/vnd.japannet-registration-wakeup';
    public const APPLICATION_VND_JAPANNET_SETSTORE_WAKEUP = 'application/vnd.japannet-setstore-wakeup';
    public const APPLICATION_VND_JAPANNET_VERIFICATION = 'application/vnd.japannet-verification';
    public const APPLICATION_VND_JAPANNET_VERIFICATION_WAKEUP = 'application/vnd.japannet-verification-wakeup';
    public const APPLICATION_VND_JCP_JAVAME_MIDLET_RMS = 'application/vnd.jcp.javame.midlet-rms';
    public const APPLICATION_VND_JISP = 'application/vnd.jisp';
    public const APPLICATION_VND_JOOST_JODA_ARCHIVE = 'application/vnd.joost.joda-archive';
    public const APPLICATION_VND_JSK_ISDN_NGN = 'application/vnd.jsk.isdn-ngn';
    public const APPLICATION_VND_KAHOOTZ = 'application/vnd.kahootz';
    public const APPLICATION_VND_KDE_KARBON = 'application/vnd.kde.karbon';
    public const APPLICATION_VND_KDE_KCHART = 'application/vnd.kde.kchart';
    public const APPLICATION_VND_KDE_KFORMULA = 'application/vnd.kde.kformula';
    public const APPLICATION_VND_KDE_KIVIO = 'application/vnd.kde.kivio';
    public const APPLICATION_VND_KDE_KONTOUR = 'application/vnd.kde.kontour';
    public const APPLICATION_VND_KDE_KPRESENTER = 'application/vnd.kde.kpresenter';
    public const APPLICATION_VND_KDE_KSPREAD = 'application/vnd.kde.kspread';
    public const APPLICATION_VND_KDE_KWORD = 'application/vnd.kde.kword';
    public const APPLICATION_VND_KENAMEAAPP = 'application/vnd.kenameaapp';
    public const APPLICATION_VND_KIDSPIRATION = 'application/vnd.kidspiration';
    public const APPLICATION_VND_KINAR = 'application/vnd.Kinar';
    public const APPLICATION_VND_KOAN = 'application/vnd.koan';
    public const APPLICATION_VND_KODAK_DESCRIPTOR = 'application/vnd.kodak-descriptor';
    public const APPLICATION_VND_LAS_LAS_XML = 'application/vnd.las.las+xml';
    public const APPLICATION_VND_LIBERTY_REQUEST_XML = 'application/vnd.liberty-request+xml';
    public const APPLICATION_VND_LLAMAGRAPHICS_LIFE_BALANCE_DESKTOP = 'application/vnd.llamagraphics.life-balance.desktop';
    public const APPLICATION_VND_LLAMAGRAPHICS_LIFE_BALANCE_EXCHANGE_XML = 'application/vnd.llamagraphics.life-balance.exchange+xml';
    public const APPLICATION_VND_LOTUS_1_2_3 = 'application/vnd.lotus-1-2-3';
    public const APPLICATION_VND_LOTUS_APPROACH = 'application/vnd.lotus-approach';
    public const APPLICATION_VND_LOTUS_FREELANCE = 'application/vnd.lotus-freelance';
    public const APPLICATION_VND_LOTUS_NOTES = 'application/vnd.lotus-notes';
    public const APPLICATION_VND_LOTUS_ORGANIZER = 'application/vnd.lotus-organizer';
    public const APPLICATION_VND_LOTUS_SCREENCAM = 'application/vnd.lotus-screencam';
    public const APPLICATION_VND_LOTUS_WORDPRO = 'application/vnd.lotus-wordpro';
    public const APPLICATION_VND_MACPORTS_PORTPKG = 'application/vnd.macports.portpkg';
    public const APPLICATION_VND_MAPBOX_VECTOR_TILE = 'application/vnd.mapbox-vector-tile';
    public const APPLICATION_VND_MARLIN_DRM_ACTIONTOKEN_XML = 'application/vnd.marlin.drm.actiontoken+xml';
    public const APPLICATION_VND_MARLIN_DRM_CONFTOKEN_XML = 'application/vnd.marlin.drm.conftoken+xml';
    public const APPLICATION_VND_MARLIN_DRM_LICENSE_XML = 'application/vnd.marlin.drm.license+xml';
    public const APPLICATION_VND_MARLIN_DRM_MDCF = 'application/vnd.marlin.drm.mdcf';
    public const APPLICATION_VND_MASON_JSON = 'application/vnd.mason+json';
    public const APPLICATION_VND_MAXMIND_MAXMIND_DB = 'application/vnd.maxmind.maxmind-db';
    public const APPLICATION_VND_MCD = 'application/vnd.mcd';
    public const APPLICATION_VND_MEDCALCDATA = 'application/vnd.medcalcdata';
    public const APPLICATION_VND_MEDIASTATION_CDKEY = 'application/vnd.mediastation.cdkey';
    public const APPLICATION_VND_MERIDIAN_SLINGSHOT = 'application/vnd.meridian-slingshot';
    public const APPLICATION_VND_MFER = 'application/vnd.MFER';
    public const APPLICATION_VND_MFMP = 'application/vnd.mfmp';
    public const APPLICATION_VND_MICRO_JSON = 'application/vnd.micro+json';
    public const APPLICATION_VND_MICROGRAFX_FLO = 'application/vnd.micrografx.flo';
    public const APPLICATION_VND_MICROGRAFX_IGX = 'application/vnd.micrografx-igx';
    public const APPLICATION_VND_MICROSOFT_PORTABLE_EXECUTABLE = 'application/vnd.microsoft.portable-executable';
    public const APPLICATION_VND_MIELE_JSON = 'application/vnd.miele+json';
    public const APPLICATION_VND_MIF = 'application/vnd-mif';
    public const APPLICATION_VND_MINISOFT_HP3000_SAVE = 'application/vnd.minisoft-hp3000-save';
    public const APPLICATION_VND_MITSUBISHI_MISTY_GUARD_TRUSTWEB = 'application/vnd.mitsubishi.misty-guard.trustweb';
    public const APPLICATION_VND_MOBIUS_DAF = 'application/vnd.Mobius.DAF';
    public const APPLICATION_VND_MOBIUS_DIS = 'application/vnd.Mobius.DIS';
    public const APPLICATION_VND_MOBIUS_MBK = 'application/vnd.Mobius.MBK';
    public const APPLICATION_VND_MOBIUS_MQY = 'application/vnd.Mobius.MQY';
    public const APPLICATION_VND_MOBIUS_MSL = 'application/vnd.Mobius.MSL';
    public const APPLICATION_VND_MOBIUS_PLC = 'application/vnd.Mobius.PLC';
    public const APPLICATION_VND_MOBIUS_TXF = 'application/vnd.Mobius.TXF';
    public const APPLICATION_VND_MOPHUN_APPLICATION = 'application/vnd.mophun.application';
    public const APPLICATION_VND_MOPHUN_CERTIFICATE = 'application/vnd.mophun.certificate';
    public const APPLICATION_VND_MOTOROLA_FLEXSUITE = 'application/vnd.motorola.flexsuite';
    public const APPLICATION_VND_MOTOROLA_FLEXSUITE_ADSI = 'application/vnd.motorola.flexsuite.adsi';
    public const APPLICATION_VND_MOTOROLA_FLEXSUITE_FIS = 'application/vnd.motorola.flexsuite.fis';
    public const APPLICATION_VND_MOTOROLA_FLEXSUITE_GOTAP = 'application/vnd.motorola.flexsuite.gotap';
    public const APPLICATION_VND_MOTOROLA_FLEXSUITE_KMR = 'application/vnd.motorola.flexsuite.kmr';
    public const APPLICATION_VND_MOTOROLA_FLEXSUITE_TTC = 'application/vnd.motorola.flexsuite.ttc';
    public const APPLICATION_VND_MOTOROLA_FLEXSUITE_WEM = 'application/vnd.motorola.flexsuite.wem';
    public const APPLICATION_VND_MOTOROLA_IPRM = 'application/vnd.motorola.iprm';
    public const APPLICATION_VND_MOZILLA_XUL_XML = 'application/vnd.mozilla.xul+xml';
    public const APPLICATION_VND_MS_3MFDOCUMENT = 'application/vnd.ms-3mfdocument';
    public const APPLICATION_VND_MS_ARTGALRY = 'application/vnd.ms-artgalry';
    public const APPLICATION_VND_MS_ASF = 'application/vnd.ms-asf';
    public const APPLICATION_VND_MS_CAB_COMPRESSED = 'application/vnd.ms-cab-compressed';
    public const APPLICATION_VND_MS_EXCEL = 'application/vnd.ms-excel';
    public const APPLICATION_VND_MS_EXCEL_ADDIN_MACROENABLED_12 = 'application/vnd.ms-excel.addin.macroEnabled.12';
    public const APPLICATION_VND_MS_EXCEL_SHEET_BINARY_MACROENABLED_12 = 'application/vnd.ms-excel.sheet.binary.macroEnabled.12';
    public const APPLICATION_VND_MS_EXCEL_SHEET_MACROENABLED_12 = 'application/vnd.ms-excel.sheet.macroEnabled.12';
    public const APPLICATION_VND_MS_EXCEL_TEMPLATE_MACROENABLED_12 = 'application/vnd.ms-excel.template.macroEnabled.12';
    public const APPLICATION_VND_MS_FONTOBJECT = 'application/vnd.ms-fontobject';
    public const APPLICATION_VND_MS_HTMLHELP = 'application/vnd.ms-htmlhelp';
    public const APPLICATION_VND_MS_IMS = 'application/vnd.ms-ims';
    public const APPLICATION_VND_MS_LRM = 'application/vnd.ms-lrm';
    public const APPLICATION_VND_MS_OFFICE_ACTIVEX_XML = 'application/vnd.ms-office.activeX+xml';
    public const APPLICATION_VND_MS_OFFICETHEME = 'application/vnd.ms-officetheme';
    public const APPLICATION_VND_MS_PKI_SECCAT = 'application/vnd.ms-pki.seccat';
    public const APPLICATION_VND_MS_PKI_STL = 'application/vnd.ms-pki.stl';
    public const APPLICATION_VND_MS_PLAYREADY_INITIATOR_XML = 'application/vnd.ms-playready.initiator+xml';
    public const APPLICATION_VND_MS_POWERPOINT = 'application/vnd.ms-powerpoint';
    public const APPLICATION_VND_MS_POWERPOINT_ADDIN_MACROENABLED_12 = 'application/vnd.ms-powerpoint.addin.macroEnabled.12';
    public const APPLICATION_VND_MS_POWERPOINT_PRESENTATION_MACROENABLED_12 = 'application/vnd.ms-powerpoint.presentation.macroEnabled.12';
    public const APPLICATION_VND_MS_POWERPOINT_SLIDE_MACROENABLED_12 = 'application/vnd.ms-powerpoint.slide.macroEnabled.12';
    public const APPLICATION_VND_MS_POWERPOINT_SLIDESHOW_MACROENABLED_12 = 'application/vnd.ms-powerpoint.slideshow.macroEnabled.12';
    public const APPLICATION_VND_MS_POWERPOINT_TEMPLATE_MACROENABLED_12 = 'application/vnd.ms-powerpoint.template.macroEnabled.12';
    public const APPLICATION_VND_MS_PRINTDEVICECAPABILITIES_XML = 'application/vnd.ms-PrintDeviceCapabilities+xml';
    public const APPLICATION_VND_MS_PRINTSCHEMATICKET_XML = 'application/vnd.ms-PrintSchemaTicket+xml';
    public const APPLICATION_VND_MS_PROJECT = 'application/vnd.ms-project';
    public const APPLICATION_VND_MS_TNEF = 'application/vnd.ms-tnef';
    public const APPLICATION_VND_MS_WINDOWS_DEVICEPAIRING = 'application/vnd.ms-windows.devicepairing';
    public const APPLICATION_VND_MS_WINDOWS_NWPRINTING_OOB = 'application/vnd.ms-windows.nwprinting.oob';
    public const APPLICATION_VND_MS_WINDOWS_PRINTERPAIRING = 'application/vnd.ms-windows.printerpairing';
    public const APPLICATION_VND_MS_WINDOWS_WSD_OOB = 'application/vnd.ms-windows.wsd.oob';
    public const APPLICATION_VND_MS_WMDRM_LIC_CHLG_REQ = 'application/vnd.ms-wmdrm.lic-chlg-req';
    public const APPLICATION_VND_MS_WMDRM_LIC_RESP = 'application/vnd.ms-wmdrm.lic-resp';
    public const APPLICATION_VND_MS_WMDRM_METER_CHLG_REQ = 'application/vnd.ms-wmdrm.meter-chlg-req';
    public const APPLICATION_VND_MS_WMDRM_METER_RESP = 'application/vnd.ms-wmdrm.meter-resp';
    public const APPLICATION_VND_MS_WORD_DOCUMENT_MACROENABLED_12 = 'application/vnd.ms-word.document.macroEnabled.12';
    public const APPLICATION_VND_MS_WORD_TEMPLATE_MACROENABLED_12 = 'application/vnd.ms-word.template.macroEnabled.12';
    public const APPLICATION_VND_MS_WORKS = 'application/vnd.ms-works';
    public const APPLICATION_VND_MS_WPL = 'application/vnd.ms-wpl';
    public const APPLICATION_VND_MS_XPSDOCUMENT = 'application/vnd.ms-xpsdocument';
    public const APPLICATION_VND_MSA_DISK_IMAGE = 'application/vnd.msa-disk-image';
    public const APPLICATION_VND_MSEQ = 'application/vnd.mseq';
    public const APPLICATION_VND_MSIGN = 'application/vnd.msign';
    public const APPLICATION_VND_MULTIAD_CREATOR = 'application/vnd.multiad.creator';
    public const APPLICATION_VND_MULTIAD_CREATOR_CIF = 'application/vnd.multiad.creator.cif';
    public const APPLICATION_VND_MUSIC_NIFF = 'application/vnd.music-niff';
    public const APPLICATION_VND_MUSICIAN = 'application/vnd.musician';
    public const APPLICATION_VND_MUVEE_STYLE = 'application/vnd.muvee.style';
    public const APPLICATION_VND_MYNFC = 'application/vnd.mynfc';
    public const APPLICATION_VND_NCD_CONTROL = 'application/vnd.ncd.control';
    public const APPLICATION_VND_NCD_REFERENCE = 'application/vnd.ncd.reference';
    public const APPLICATION_VND_NEARST_INV_JSON = 'application/vnd.nearst.inv+json';
    public const APPLICATION_VND_NERVANA = 'application/vnd.nervana';
    public const APPLICATION_VND_NETFPX = 'application/vnd.netfpx';
    public const APPLICATION_VND_NEUROLANGUAGE_NLU = 'application/vnd.neurolanguage.nlu';
    public const APPLICATION_VND_NINTENDO_NITRO_ROM = 'application/vnd.nintendo.nitro.rom';
    public const APPLICATION_VND_NINTENDO_SNES_ROM = 'application/vnd.nintendo.snes.rom';
    public const APPLICATION_VND_NITF = 'application/vnd.nitf';
    public const APPLICATION_VND_NOBLENET_DIRECTORY = 'application/vnd.noblenet-directory';
    public const APPLICATION_VND_NOBLENET_SEALER = 'application/vnd.noblenet-sealer';
    public const APPLICATION_VND_NOBLENET_WEB = 'application/vnd.noblenet-web';
    public const APPLICATION_VND_NOKIA_CATALOGS = 'application/vnd.nokia.catalogs';
    public const APPLICATION_VND_NOKIA_CONML_WBXML = 'application/vnd.nokia.conml+wbxml';
    public const APPLICATION_VND_NOKIA_CONML_XML = 'application/vnd.nokia.conml+xml';
    public const APPLICATION_VND_NOKIA_IPTV_CONFIG_XML = 'application/vnd.nokia.iptv.config+xml';
    public const APPLICATION_VND_NOKIA_ISDS_RADIO_PRESETS = 'application/vnd.nokia.iSDS-radio-presets';
    public const APPLICATION_VND_NOKIA_LANDMARK_WBXML = 'application/vnd.nokia.landmark+wbxml';
    public const APPLICATION_VND_NOKIA_LANDMARK_XML = 'application/vnd.nokia.landmark+xml';
    public const APPLICATION_VND_NOKIA_LANDMARKCOLLECTION_XML = 'application/vnd.nokia.landmarkcollection+xml';
    public const APPLICATION_VND_NOKIA_N_GAGE_AC_XML = 'application/vnd.nokia.n-gage.ac+xml';
    public const APPLICATION_VND_NOKIA_N_GAGE_DATA = 'application/vnd.nokia.n-gage.data';
    public const APPLICATION_VND_NOKIA_N_GAGE_SYMBIAN_INSTALL = 'application/vnd.nokia.n-gage.symbian.install';
    public const APPLICATION_VND_NOKIA_NCD = 'application/vnd.nokia.ncd';
    public const APPLICATION_VND_NOKIA_PCD_WBXML = 'application/vnd.nokia.pcd+wbxml';
    public const APPLICATION_VND_NOKIA_PCD_XML = 'application/vnd.nokia.pcd+xml';
    public const APPLICATION_VND_NOKIA_RADIO_PRESET = 'application/vnd.nokia.radio-preset';
    public const APPLICATION_VND_NOKIA_RADIO_PRESETS = 'application/vnd.nokia.radio-presets';
    public const APPLICATION_VND_NOVADIGM_EDM = 'application/vnd.novadigm.EDM';
    public const APPLICATION_VND_NOVADIGM_EDX = 'application/vnd.novadigm.EDX';
    public const APPLICATION_VND_NOVADIGM_EXT = 'application/vnd.novadigm.EXT';
    public const APPLICATION_VND_NTT_LOCAL_CONTENT_SHARE = 'application/vnd.ntt-local.content-share';
    public const APPLICATION_VND_NTT_LOCAL_FILE_TRANSFER = 'application/vnd.ntt-local.file-transfer';
    public const APPLICATION_VND_NTT_LOCAL_OGW_REMOTE_ACCESS = 'application/vnd.ntt-local.ogw_remote-access';
    public const APPLICATION_VND_NTT_LOCAL_SIP_TA_REMOTE = 'application/vnd.ntt-local.sip-ta_remote';
    public const APPLICATION_VND_NTT_LOCAL_SIP_TA_TCP_STREAM = 'application/vnd.ntt-local.sip-ta_tcp_stream';
    public const APPLICATION_VND_OASIS_OPENDOCUMENT_CHART = 'application/vnd.oasis.opendocument.chart';
    public const APPLICATION_VND_OASIS_OPENDOCUMENT_CHART_TEMPLATE = 'application/vnd.oasis.opendocument.chart-template';
    public const APPLICATION_VND_OASIS_OPENDOCUMENT_DATABASE = 'application/vnd.oasis.opendocument.database';
    public const APPLICATION_VND_OASIS_OPENDOCUMENT_FORMULA = 'application/vnd.oasis.opendocument.formula';
    public const APPLICATION_VND_OASIS_OPENDOCUMENT_FORMULA_TEMPLATE = 'application/vnd.oasis.opendocument.formula-template';
    public const APPLICATION_VND_OASIS_OPENDOCUMENT_GRAPHICS = 'application/vnd.oasis.opendocument.graphics';
    public const APPLICATION_VND_OASIS_OPENDOCUMENT_GRAPHICS_TEMPLATE = 'application/vnd.oasis.opendocument.graphics-template';
    public const APPLICATION_VND_OASIS_OPENDOCUMENT_IMAGE = 'application/vnd.oasis.opendocument.image';
    public const APPLICATION_VND_OASIS_OPENDOCUMENT_IMAGE_TEMPLATE = 'application/vnd.oasis.opendocument.image-template';
    public const APPLICATION_VND_OASIS_OPENDOCUMENT_PRESENTATION = 'application/vnd.oasis.opendocument.presentation';
    public const APPLICATION_VND_OASIS_OPENDOCUMENT_PRESENTATION_TEMPLATE = 'application/vnd.oasis.opendocument.presentation-template';
    public const APPLICATION_VND_OASIS_OPENDOCUMENT_SPREADSHEET = 'application/vnd.oasis.opendocument.spreadsheet';
    public const APPLICATION_VND_OASIS_OPENDOCUMENT_SPREADSHEET_TEMPLATE = 'application/vnd.oasis.opendocument.spreadsheet-template';
    public const APPLICATION_VND_OASIS_OPENDOCUMENT_TEXT = 'application/vnd.oasis.opendocument.text';
    public const APPLICATION_VND_OASIS_OPENDOCUMENT_TEXT_MASTER = 'application/vnd.oasis.opendocument.text-master';
    public const APPLICATION_VND_OASIS_OPENDOCUMENT_TEXT_TEMPLATE = 'application/vnd.oasis.opendocument.text-template';
    public const APPLICATION_VND_OASIS_OPENDOCUMENT_TEXT_WEB = 'application/vnd.oasis.opendocument.text-web';
    public const APPLICATION_VND_OBN = 'application/vnd.obn';
    public const APPLICATION_VND_OFTN_L10N_JSON = 'application/vnd.oftn.l10n+json';
    public const APPLICATION_VND_OIPF_CONTENTACCESSDOWNLOAD_XML = 'application/vnd.oipf.contentaccessdownload+xml';
    public const APPLICATION_VND_OIPF_CONTENTACCESSSTREAMING_XML = 'application/vnd.oipf.contentaccessstreaming+xml';
    public const APPLICATION_VND_OIPF_CSPG_HEXBINARY = 'application/vnd.oipf.cspg-hexbinary';
    public const APPLICATION_VND_OIPF_DAE_SVG_XML = 'application/vnd.oipf.dae.svg+xml';
    public const APPLICATION_VND_OIPF_DAE_XHTML_XML = 'application/vnd.oipf.dae.xhtml+xml';
    public const APPLICATION_VND_OIPF_MIPPVCONTROLMESSAGE_XML = 'application/vnd.oipf.mippvcontrolmessage+xml';
    public const APPLICATION_VND_OIPF_PAE_GEM = 'application/vnd.oipf.pae.gem';
    public const APPLICATION_VND_OIPF_SPDISCOVERY_XML = 'application/vnd.oipf.spdiscovery+xml';
    public const APPLICATION_VND_OIPF_SPDLIST_XML = 'application/vnd.oipf.spdlist+xml';
    public const APPLICATION_VND_OIPF_UEPROFILE_XML = 'application/vnd.oipf.ueprofile+xml';
    public const APPLICATION_VND_OIPF_USERPROFILE_XML = 'application/vnd.oipf.userprofile+xml';
    public const APPLICATION_VND_OLPC_SUGAR = 'application/vnd.olpc-sugar';
    public const APPLICATION_VND_OMA_BCAST_ASSOCIATED_PROCEDURE_PARAMETER_XML = 'application/vnd.oma.bcast.associated-procedure-parameter+xml';
    public const APPLICATION_VND_OMA_BCAST_DRM_TRIGGER_XML = 'application/vnd.oma.bcast.drm-trigger+xml';
    public const APPLICATION_VND_OMA_BCAST_IMD_XML = 'application/vnd.oma.bcast.imd+xml';
    public const APPLICATION_VND_OMA_BCAST_LTKM = 'application/vnd.oma.bcast.ltkm';
    public const APPLICATION_VND_OMA_BCAST_NOTIFICATION_XML = 'application/vnd.oma.bcast.notification+xml';
    public const APPLICATION_VND_OMA_BCAST_PROVISIONINGTRIGGER = 'application/vnd.oma.bcast.provisioningtrigger';
    public const APPLICATION_VND_OMA_BCAST_SGBOOT = 'application/vnd.oma.bcast.sgboot';
    public const APPLICATION_VND_OMA_BCAST_SGDD_XML = 'application/vnd.oma.bcast.sgdd+xml';
    public const APPLICATION_VND_OMA_BCAST_SGDU = 'application/vnd.oma.bcast.sgdu';
    public const APPLICATION_VND_OMA_BCAST_SIMPLE_SYMBOL_CONTAINER = 'application/vnd.oma.bcast.simple-symbol-container';
    public const APPLICATION_VND_OMA_BCAST_SMARTCARD_TRIGGER_XML = 'application/vnd.oma.bcast.smartcard-trigger+xml';
    public const APPLICATION_VND_OMA_BCAST_SPROV_XML = 'application/vnd.oma.bcast.sprov+xml';
    public const APPLICATION_VND_OMA_BCAST_STKM = 'application/vnd.oma.bcast.stkm';
    public const APPLICATION_VND_OMA_CAB_ADDRESS_BOOK_XML = 'application/vnd.oma.cab-address-book+xml';
    public const APPLICATION_VND_OMA_CAB_FEATURE_HANDLER_XML = 'application/vnd.oma.cab-feature-handler+xml';
    public const APPLICATION_VND_OMA_CAB_PCC_XML = 'application/vnd.oma.cab-pcc+xml';
    public const APPLICATION_VND_OMA_CAB_SUBS_INVITE_XML = 'application/vnd.oma.cab-subs-invite+xml';
    public const APPLICATION_VND_OMA_CAB_USER_PREFS_XML = 'application/vnd.oma.cab-user-prefs+xml';
    public const APPLICATION_VND_OMA_DCD = 'application/vnd.oma.dcd';
    public const APPLICATION_VND_OMA_DCDC = 'application/vnd.oma.dcdc';
    public const APPLICATION_VND_OMA_DD2_XML = 'application/vnd.oma.dd2+xml';
    public const APPLICATION_VND_OMA_DRM_RISD_XML = 'application/vnd.oma.drm.risd+xml';
    public const APPLICATION_VND_OMA_GROUP_USAGE_LIST_XML = 'application/vnd.oma.group-usage-list+xml';
    public const APPLICATION_VND_OMA_LWM2M_JSON = 'application/vnd.oma.lwm2m+json';
    public const APPLICATION_VND_OMA_LWM2M_TLV = 'application/vnd.oma.lwm2m+tlv';
    public const APPLICATION_VND_OMA_PAL_XML = 'application/vnd.oma.pal+xml';
    public const APPLICATION_VND_OMA_POC_DETAILED_PROGRESS_REPORT_XML = 'application/vnd.oma.poc.detailed-progress-report+xml';
    public const APPLICATION_VND_OMA_POC_FINAL_REPORT_XML = 'application/vnd.oma.poc.final-report+xml';
    public const APPLICATION_VND_OMA_POC_GROUPS_XML = 'application/vnd.oma.poc.groups+xml';
    public const APPLICATION_VND_OMA_POC_INVOCATION_DESCRIPTOR_XML = 'application/vnd.oma.poc.invocation-descriptor+xml';
    public const APPLICATION_VND_OMA_POC_OPTIMIZED_PROGRESS_REPORT_XML = 'application/vnd.oma.poc.optimized-progress-report+xml';
    public const APPLICATION_VND_OMA_PUSH = 'application/vnd.oma.push';
    public const APPLICATION_VND_OMA_SCIDM_MESSAGES_XML = 'application/vnd.oma.scidm.messages+xml';
    public const APPLICATION_VND_OMA_SCWS_CONFIG = 'application/vnd.oma-scws-config';
    public const APPLICATION_VND_OMA_SCWS_HTTP_REQUEST = 'application/vnd.oma-scws-http-request';
    public const APPLICATION_VND_OMA_SCWS_HTTP_RESPONSE = 'application/vnd.oma-scws-http-response';
    public const APPLICATION_VND_OMA_XCAP_DIRECTORY_XML = 'application/vnd.oma.xcap-directory+xml';
    public const APPLICATION_VND_OMADS_EMAIL_XML = 'application/vnd.omads-email+xml';
    public const APPLICATION_VND_OMADS_FILE_XML = 'application/vnd.omads-file+xml';
    public const APPLICATION_VND_OMADS_FOLDER_XML = 'application/vnd.omads-folder+xml';
    public const APPLICATION_VND_OMALOC_SUPL_INIT = 'application/vnd.omaloc-supl-init';
    public const APPLICATION_VND_ONEPAGER = 'application/vnd.onepager';
    public const APPLICATION_VND_OPENBLOX_GAME_BINARY = 'application/vnd.openblox.game-binary';
    public const APPLICATION_VND_OPENBLOX_GAME_XML = 'application/vnd.openblox.game+xml';
    public const APPLICATION_VND_OPENEYE_OEB = 'application/vnd.openeye.oeb';
    public const APPLICATION_VND_OPENOFFICEORG_EXTENSION = 'application/vnd.openofficeorg.extension';
    public const APPLICATION_VND_OPENSTREETMAP_DATA_XML = 'application/vnd.openstreetmap.data+xml';
    public const APPLICATION_VND_OPENXMLFORMATS_OFFICEDOCUMENT_CUSTOM_PROPERTIES_XML = 'application/vnd.openxmlformats-officedocument.custom-properties+xml';
    public const APPLICATION_VND_OPENXMLFORMATS_OFFICEDOCUMENT_CUSTOMXMLPROPERTIES_XML = 'application/vnd.openxmlformats-officedocument.customXmlProperties+xml';
    public const APPLICATION_VND_OPENXMLFORMATS_OFFICEDOCUMENT_DRAWING_XML = 'application/vnd.openxmlformats-officedocument.drawing+xml';
    public const APPLICATION_VND_OPENXMLFORMATS_OFFICEDOCUMENT_DRAWINGML_CHART_XML = 'application/vnd.openxmlformats-officedocument.drawingml.chart+xml';
    public const APPLICATION_VND_OPENXMLFORMATS_OFFICEDOCUMENT_DRAWINGML_CHARTSHAPES_XML = 'application/vnd.openxmlformats-officedocument.drawingml.chartshapes+xml';
    public const APPLICATION_VND_OPENXMLFORMATS_OFFICEDOCUMENT_DRAWINGML_DIAGRAMCOLORS_XML = 'application/vnd.openxmlformats-officedocument.drawingml.diagramColors+xml';
    public const APPLICATION_VND_OPENXMLFORMATS_OFFICEDOCUMENT_DRAWINGML_DIAGRAMDATA_XML = 'application/vnd.openxmlformats-officedocument.drawingml.diagramData+xml';
    public const APPLICATION_VND_OPENXMLFORMATS_OFFICEDOCUMENT_DRAWINGML_DIAGRAMLAYOUT_XML = 'application/vnd.openxmlformats-officedocument.drawingml.diagramLayout+xml';
    public const APPLICATION_VND_OPENXMLFORMATS_OFFICEDOCUMENT_DRAWINGML_DIAGRAMSTYLE_XML = 'application/vnd.openxmlformats-officedocument.drawingml.diagramStyle+xml';
    public const APPLICATION_VND_OPENXMLFORMATS_OFFICEDOCUMENT_EXTENDED_PROPERTIES_XML = 'application/vnd.openxmlformats-officedocument.extended-properties+xml';
    public const APPLICATION_VND_OPENXMLFORMATS_OFFICEDOCUMENT_PRESENTATIONML_COMMENTAUTHORS_XML = 'application/vnd.openxmlformats-officedocument.presentationml.commentAuthors+xml';
    public const APPLICATION_VND_OPENXMLFORMATS_OFFICEDOCUMENT_PRESENTATIONML_COMMENTS_XML = 'application/vnd.openxmlformats-officedocument.presentationml.comments+xml';
    public const APPLICATION_VND_OPENXMLFORMATS_OFFICEDOCUMENT_PRESENTATIONML_HANDOUTMASTER_XML = 'application/vnd.openxmlformats-officedocument.presentationml.handoutMaster+xml';
    public const APPLICATION_VND_OPENXMLFORMATS_OFFICEDOCUMENT_PRESENTATIONML_NOTESMASTER_XML = 'application/vnd.openxmlformats-officedocument.presentationml.notesMaster+xml';
    public const APPLICATION_VND_OPENXMLFORMATS_OFFICEDOCUMENT_PRESENTATIONML_NOTESSLIDE_XML = 'application/vnd.openxmlformats-officedocument.presentationml.notesSlide+xml';
    public const APPLICATION_VND_OPENXMLFORMATS_OFFICEDOCUMENT_PRESENTATIONML_PRESENTATION = 'application/vnd.openxmlformats-officedocument.presentationml.presentation';
    public const APPLICATION_VND_OPENXMLFORMATS_OFFICEDOCUMENT_PRESENTATIONML_PRESENTATION_MAIN_XML = 'application/vnd.openxmlformats-officedocument.presentationml.presentation.main+xml';
    public const APPLICATION_VND_OPENXMLFORMATS_OFFICEDOCUMENT_PRESENTATIONML_PRESPROPS_XML = 'application/vnd.openxmlformats-officedocument.presentationml.presProps+xml';
    public const APPLICATION_VND_OPENXMLFORMATS_OFFICEDOCUMENT_PRESENTATIONML_SLIDE = 'application/vnd.openxmlformats-officedocument.presentationml.slide';
    public const APPLICATION_VND_OPENXMLFORMATS_OFFICEDOCUMENT_PRESENTATIONML_SLIDE_XML = 'application/vnd.openxmlformats-officedocument.presentationml.slide+xml';
    public const APPLICATION_VND_OPENXMLFORMATS_OFFICEDOCUMENT_PRESENTATIONML_SLIDELAYOUT_XML = 'application/vnd.openxmlformats-officedocument.presentationml.slideLayout+xml';
    public const APPLICATION_VND_OPENXMLFORMATS_OFFICEDOCUMENT_PRESENTATIONML_SLIDEMASTER_XML = 'application/vnd.openxmlformats-officedocument.presentationml.slideMaster+xml';
    public const APPLICATION_VND_OPENXMLFORMATS_OFFICEDOCUMENT_PRESENTATIONML_SLIDESHOW = 'application/vnd.openxmlformats-officedocument.presentationml.slideshow';
    public const APPLICATION_VND_OPENXMLFORMATS_OFFICEDOCUMENT_PRESENTATIONML_SLIDESHOW_MAIN_XML = 'application/vnd.openxmlformats-officedocument.presentationml.slideshow.main+xml';
    public const APPLICATION_VND_OPENXMLFORMATS_OFFICEDOCUMENT_PRESENTATIONML_SLIDEUPDATEINFO_XML = 'application/vnd.openxmlformats-officedocument.presentationml.slideUpdateInfo+xml';
    public const APPLICATION_VND_OPENXMLFORMATS_OFFICEDOCUMENT_PRESENTATIONML_TABLESTYLES_XML = 'application/vnd.openxmlformats-officedocument.presentationml.tableStyles+xml';
    public const APPLICATION_VND_OPENXMLFORMATS_OFFICEDOCUMENT_PRESENTATIONML_TAGS_XML = 'application/vnd.openxmlformats-officedocument.presentationml.tags+xml';
    public const APPLICATION_VND_OPENXMLFORMATS_OFFICEDOCUMENT_PRESENTATIONML_TEMPLATE = 'application/vnd.openxmlformats-officedocument.presentationml-template';
    public const APPLICATION_VND_OPENXMLFORMATS_OFFICEDOCUMENT_PRESENTATIONML_TEMPLATE_MAIN_XML = 'application/vnd.openxmlformats-officedocument.presentationml.template.main+xml';
    public const APPLICATION_VND_OPENXMLFORMATS_OFFICEDOCUMENT_PRESENTATIONML_VIEWPROPS_XML = 'application/vnd.openxmlformats-officedocument.presentationml.viewProps+xml';
    public const APPLICATION_VND_OPENXMLFORMATS_OFFICEDOCUMENT_SPREADSHEETML_CALCCHAIN_XML = 'application/vnd.openxmlformats-officedocument.spreadsheetml.calcChain+xml';
    public const APPLICATION_VND_OPENXMLFORMATS_OFFICEDOCUMENT_SPREADSHEETML_CHARTSHEET_XML = 'application/vnd.openxmlformats-officedocument.spreadsheetml.chartsheet+xml';
    public const APPLICATION_VND_OPENXMLFORMATS_OFFICEDOCUMENT_SPREADSHEETML_COMMENTS_XML = 'application/vnd.openxmlformats-officedocument.spreadsheetml.comments+xml';
    public const APPLICATION_VND_OPENXMLFORMATS_OFFICEDOCUMENT_SPREADSHEETML_CONNECTIONS_XML = 'application/vnd.openxmlformats-officedocument.spreadsheetml.connections+xml';
    public const APPLICATION_VND_OPENXMLFORMATS_OFFICEDOCUMENT_SPREADSHEETML_DIALOGSHEET_XML = 'application/vnd.openxmlformats-officedocument.spreadsheetml.dialogsheet+xml';
    public const APPLICATION_VND_OPENXMLFORMATS_OFFICEDOCUMENT_SPREADSHEETML_EXTERNALLINK_XML = 'application/vnd.openxmlformats-officedocument.spreadsheetml.externalLink+xml';
    public const APPLICATION_VND_OPENXMLFORMATS_OFFICEDOCUMENT_SPREADSHEETML_PIVOTCACHEDEFINITION_XML = 'application/vnd.openxmlformats-officedocument.spreadsheetml.pivotCacheDefinition+xml';
    public const APPLICATION_VND_OPENXMLFORMATS_OFFICEDOCUMENT_SPREADSHEETML_PIVOTCACHERECORDS_XML = 'application/vnd.openxmlformats-officedocument.spreadsheetml.pivotCacheRecords+xml';
    public const APPLICATION_VND_OPENXMLFORMATS_OFFICEDOCUMENT_SPREADSHEETML_PIVOTTABLE_XML = 'application/vnd.openxmlformats-officedocument.spreadsheetml.pivotTable+xml';
    public const APPLICATION_VND_OPENXMLFORMATS_OFFICEDOCUMENT_SPREADSHEETML_QUERYTABLE_XML = 'application/vnd.openxmlformats-officedocument.spreadsheetml.queryTable+xml';
    public const APPLICATION_VND_OPENXMLFORMATS_OFFICEDOCUMENT_SPREADSHEETML_REVISIONHEADERS_XML = 'application/vnd.openxmlformats-officedocument.spreadsheetml.revisionHeaders+xml';
    public const APPLICATION_VND_OPENXMLFORMATS_OFFICEDOCUMENT_SPREADSHEETML_REVISIONLOG_XML = 'application/vnd.openxmlformats-officedocument.spreadsheetml.revisionLog+xml';
    public const APPLICATION_VND_OPENXMLFORMATS_OFFICEDOCUMENT_SPREADSHEETML_SHAREDSTRINGS_XML = 'application/vnd.openxmlformats-officedocument.spreadsheetml.sharedStrings+xml';
    public const APPLICATION_VND_OPENXMLFORMATS_OFFICEDOCUMENT_SPREADSHEETML_SHEET = 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet';
    public const APPLICATION_VND_OPENXMLFORMATS_OFFICEDOCUMENT_SPREADSHEETML_SHEET_MAIN_XML = 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet.main+xml';
    public const APPLICATION_VND_OPENXMLFORMATS_OFFICEDOCUMENT_SPREADSHEETML_SHEETMETADATA_XML = 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheetMetadata+xml';
    public const APPLICATION_VND_OPENXMLFORMATS_OFFICEDOCUMENT_SPREADSHEETML_STYLES_XML = 'application/vnd.openxmlformats-officedocument.spreadsheetml.styles+xml';
    public const APPLICATION_VND_OPENXMLFORMATS_OFFICEDOCUMENT_SPREADSHEETML_TABLE_XML = 'application/vnd.openxmlformats-officedocument.spreadsheetml.table+xml';
    public const APPLICATION_VND_OPENXMLFORMATS_OFFICEDOCUMENT_SPREADSHEETML_TABLESINGLECELLS_XML = 'application/vnd.openxmlformats-officedocument.spreadsheetml.tableSingleCells+xml';
    public const APPLICATION_VND_OPENXMLFORMATS_OFFICEDOCUMENT_SPREADSHEETML_TEMPLATE = 'application/vnd.openxmlformats-officedocument.spreadsheetml-template';
    public const APPLICATION_VND_OPENXMLFORMATS_OFFICEDOCUMENT_SPREADSHEETML_TEMPLATE_MAIN_XML = 'application/vnd.openxmlformats-officedocument.spreadsheetml.template.main+xml';
    public const APPLICATION_VND_OPENXMLFORMATS_OFFICEDOCUMENT_SPREADSHEETML_USERNAMES_XML = 'application/vnd.openxmlformats-officedocument.spreadsheetml.userNames+xml';
    public const APPLICATION_VND_OPENXMLFORMATS_OFFICEDOCUMENT_SPREADSHEETML_VOLATILEDEPENDENCIES_XML = 'application/vnd.openxmlformats-officedocument.spreadsheetml.volatileDependencies+xml';
    public const APPLICATION_VND_OPENXMLFORMATS_OFFICEDOCUMENT_SPREADSHEETML_WORKSHEET_XML = 'application/vnd.openxmlformats-officedocument.spreadsheetml.worksheet+xml';
    public const APPLICATION_VND_OPENXMLFORMATS_OFFICEDOCUMENT_THEME_XML = 'application/vnd.openxmlformats-officedocument.theme+xml';
    public const APPLICATION_VND_OPENXMLFORMATS_OFFICEDOCUMENT_THEMEOVERRIDE_XML = 'application/vnd.openxmlformats-officedocument.themeOverride+xml';
    public const APPLICATION_VND_OPENXMLFORMATS_OFFICEDOCUMENT_VMLDRAWING = 'application/vnd.openxmlformats-officedocument.vmlDrawing';
    public const APPLICATION_VND_OPENXMLFORMATS_OFFICEDOCUMENT_WORDPROCESSINGML_COMMENTS_XML = 'application/vnd.openxmlformats-officedocument.wordprocessingml.comments+xml';
    public const APPLICATION_VND_OPENXMLFORMATS_OFFICEDOCUMENT_WORDPROCESSINGML_DOCUMENT = 'application/vnd.openxmlformats-officedocument.wordprocessingml.document';
    public const APPLICATION_VND_OPENXMLFORMATS_OFFICEDOCUMENT_WORDPROCESSINGML_DOCUMENT_GLOSSARY_XML = 'application/vnd.openxmlformats-officedocument.wordprocessingml.document.glossary+xml';
    public const APPLICATION_VND_OPENXMLFORMATS_OFFICEDOCUMENT_WORDPROCESSINGML_DOCUMENT_MAIN_XML = 'application/vnd.openxmlformats-officedocument.wordprocessingml.document.main+xml';
    public const APPLICATION_VND_OPENXMLFORMATS_OFFICEDOCUMENT_WORDPROCESSINGML_ENDNOTES_XML = 'application/vnd.openxmlformats-officedocument.wordprocessingml.endnotes+xml';
    public const APPLICATION_VND_OPENXMLFORMATS_OFFICEDOCUMENT_WORDPROCESSINGML_FONTTABLE_XML = 'application/vnd.openxmlformats-officedocument.wordprocessingml.fontTable+xml';
    public const APPLICATION_VND_OPENXMLFORMATS_OFFICEDOCUMENT_WORDPROCESSINGML_FOOTER_XML = 'application/vnd.openxmlformats-officedocument.wordprocessingml.footer+xml';
    public const APPLICATION_VND_OPENXMLFORMATS_OFFICEDOCUMENT_WORDPROCESSINGML_FOOTNOTES_XML = 'application/vnd.openxmlformats-officedocument.wordprocessingml.footnotes+xml';
    public const APPLICATION_VND_OPENXMLFORMATS_OFFICEDOCUMENT_WORDPROCESSINGML_NUMBERING_XML = 'application/vnd.openxmlformats-officedocument.wordprocessingml.numbering+xml';
    public const APPLICATION_VND_OPENXMLFORMATS_OFFICEDOCUMENT_WORDPROCESSINGML_SETTINGS_XML = 'application/vnd.openxmlformats-officedocument.wordprocessingml.settings+xml';
    public const APPLICATION_VND_OPENXMLFORMATS_OFFICEDOCUMENT_WORDPROCESSINGML_STYLES_XML = 'application/vnd.openxmlformats-officedocument.wordprocessingml.styles+xml';
    public const APPLICATION_VND_OPENXMLFORMATS_OFFICEDOCUMENT_WORDPROCESSINGML_TEMPLATE = 'application/vnd.openxmlformats-officedocument.wordprocessingml-template';
    public const APPLICATION_VND_OPENXMLFORMATS_OFFICEDOCUMENT_WORDPROCESSINGML_TEMPLATE_MAIN_XML = 'application/vnd.openxmlformats-officedocument.wordprocessingml.template.main+xml';
    public const APPLICATION_VND_OPENXMLFORMATS_OFFICEDOCUMENT_WORDPROCESSINGML_WEBSETTINGS_XML = 'application/vnd.openxmlformats-officedocument.wordprocessingml.webSettings+xml';
    public const APPLICATION_VND_OPENXMLFORMATS_PACKAGE_CORE_PROPERTIES_XML = 'application/vnd.openxmlformats-package.core-properties+xml';
    public const APPLICATION_VND_OPENXMLFORMATS_PACKAGE_DIGITAL_SIGNATURE_XMLSIGNATURE_XML = 'application/vnd.openxmlformats-package.digital-signature-xmlsignature+xml';
    public const APPLICATION_VND_OPENXMLFORMATS_PACKAGE_RELATIONSHIPS_XML = 'application/vnd.openxmlformats-package.relationships+xml';
    public const APPLICATION_VND_ORACLE_RESOURCE_JSON = 'application/vnd.oracle.resource+json';
    public const APPLICATION_VND_ORANGE_INDATA = 'application/vnd.orange.indata';
    public const APPLICATION_VND_OSA_NETDEPLOY = 'application/vnd.osa.netdeploy';
    public const APPLICATION_VND_OSGEO_MAPGUIDE_PACKAGE = 'application/vnd.osgeo.mapguide.package';
    public const APPLICATION_VND_OSGI_BUNDLE = 'application/vnd.osgi.bundle';
    public const APPLICATION_VND_OSGI_DP = 'application/vnd.osgi.dp';
    public const APPLICATION_VND_OSGI_SUBSYSTEM = 'application/vnd.osgi.subsystem';
    public const APPLICATION_VND_OTPS_CT_KIP_XML = 'application/vnd.otps.ct-kip+xml';
    public const APPLICATION_VND_OXLI_COUNTGRAPH = 'application/vnd.oxli.countgraph';
    public const APPLICATION_VND_PAGERDUTY_JSON = 'application/vnd.pagerduty+json';
    public const APPLICATION_VND_PALM = 'application/vnd.palm';
    public const APPLICATION_VND_PANOPLY = 'application/vnd.panoply';
    public const APPLICATION_VND_PAOS_XML = 'application/vnd.paos+xml';
    public const APPLICATION_VND_PAWAAFILE = 'application/vnd.pawaafile';
    public const APPLICATION_VND_PCOS = 'application/vnd.pcos';
    public const APPLICATION_VND_PG_FORMAT = 'application/vnd.pg.format';
    public const APPLICATION_VND_PG_OSASLI = 'application/vnd.pg.osasli';
    public const APPLICATION_VND_PIACCESS_APPLICATION_LICENCE = 'application/vnd.piaccess.application-licence';
    public const APPLICATION_VND_PICSEL = 'application/vnd.picsel';
    public const APPLICATION_VND_PMI_WIDGET = 'application/vnd.pmi.widget';
    public const APPLICATION_VND_POC_GROUP_ADVERTISEMENT_XML = 'application/vnd.poc.group-advertisement+xml';
    public const APPLICATION_VND_POCKETLEARN = 'application/vnd.pocketlearn';
    public const APPLICATION_VND_POWERBUILDER6 = 'application/vnd.powerbuilder6';
    public const APPLICATION_VND_POWERBUILDER6_S = 'application/vnd.powerbuilder6-s';
    public const APPLICATION_VND_POWERBUILDER7 = 'application/vnd.powerbuilder7';
    public const APPLICATION_VND_POWERBUILDER75 = 'application/vnd.powerbuilder75';
    public const APPLICATION_VND_POWERBUILDER75_S = 'application/vnd.powerbuilder75-s';
    public const APPLICATION_VND_POWERBUILDER7_S = 'application/vnd.powerbuilder7-s';
    public const APPLICATION_VND_PREMINET = 'application/vnd.preminet';
    public const APPLICATION_VND_PREVIEWSYSTEMS_BOX = 'application/vnd.previewsystems.box';
    public const APPLICATION_VND_PROTEUS_MAGAZINE = 'application/vnd.proteus.magazine';
    public const APPLICATION_VND_PUBLISHARE_DELTA_TREE = 'application/vnd.publishare-delta-tree';
    public const APPLICATION_VND_PVI_PTID1 = 'application/vnd.pvi.ptid1';
    public const APPLICATION_VND_PWG_MULTIPLEXED = 'application/vnd.pwg-multiplexed';
    public const APPLICATION_VND_PWG_XHTML_PRINT_XML = 'application/vnd.pwg-xhtml-print+xml';
    public const APPLICATION_VND_QUALCOMM_BREW_APP_RES = 'application/vnd.qualcomm.brew-app-res';
    public const APPLICATION_VND_QUARANTAINENET = 'application/vnd.quarantainenet';
    public const APPLICATION_VND_QUARK_QUARKXPRESS = 'application/vnd.Quark.QuarkXPress';
    public const APPLICATION_VND_QUOBJECT_QUOXDOCUMENT = 'application/vnd.quobject-quoxdocument';
    public const APPLICATION_VND_RADISYS_MOML_XML = 'application/vnd.radisys.moml+xml';
    public const APPLICATION_VND_RADISYS_MSML_AUDIT_CONF_XML = 'application/vnd.radisys.msml-audit-conf+xml';
    public const APPLICATION_VND_RADISYS_MSML_AUDIT_CONN_XML = 'application/vnd.radisys.msml-audit-conn+xml';
    public const APPLICATION_VND_RADISYS_MSML_AUDIT_DIALOG_XML = 'application/vnd.radisys.msml-audit-dialog+xml';
    public const APPLICATION_VND_RADISYS_MSML_AUDIT_STREAM_XML = 'application/vnd.radisys.msml-audit-stream+xml';
    public const APPLICATION_VND_RADISYS_MSML_AUDIT_XML = 'application/vnd.radisys.msml-audit+xml';
    public const APPLICATION_VND_RADISYS_MSML_CONF_XML = 'application/vnd.radisys.msml-conf+xml';
    public const APPLICATION_VND_RADISYS_MSML_DIALOG_BASE_XML = 'application/vnd.radisys.msml-dialog-base+xml';
    public const APPLICATION_VND_RADISYS_MSML_DIALOG_FAX_DETECT_XML = 'application/vnd.radisys.msml-dialog-fax-detect+xml';
    public const APPLICATION_VND_RADISYS_MSML_DIALOG_FAX_SENDRECV_XML = 'application/vnd.radisys.msml-dialog-fax-sendrecv+xml';
    public const APPLICATION_VND_RADISYS_MSML_DIALOG_GROUP_XML = 'application/vnd.radisys.msml-dialog-group+xml';
    public const APPLICATION_VND_RADISYS_MSML_DIALOG_SPEECH_XML = 'application/vnd.radisys.msml-dialog-speech+xml';
    public const APPLICATION_VND_RADISYS_MSML_DIALOG_TRANSFORM_XML = 'application/vnd.radisys.msml-dialog-transform+xml';
    public const APPLICATION_VND_RADISYS_MSML_DIALOG_XML = 'application/vnd.radisys.msml-dialog+xml';
    public const APPLICATION_VND_RADISYS_MSML_XML = 'application/vnd.radisys.msml+xml';
    public const APPLICATION_VND_RAINSTOR_DATA = 'application/vnd.rainstor.data';
    public const APPLICATION_VND_RAPID = 'application/vnd.rapid';
    public const APPLICATION_VND_RAR = 'application/vnd.rar';
    public const APPLICATION_VND_REALVNC_BED = 'application/vnd.realvnc.bed';
    public const APPLICATION_VND_RECORDARE_MUSICXML = 'application/vnd.recordare.musicxml';
    public const APPLICATION_VND_RECORDARE_MUSICXML_XML = 'application/vnd.recordare.musicxml+xml';
    public const APPLICATION_VND_RENLEARN_RLPRINT = 'application/vnd.renlearn.rlprint';
    public const APPLICATION_VND_RIG_CRYPTONOTE = 'application/vnd.rig.cryptonote';
    public const APPLICATION_VND_RIM_COD = 'application/vnd.rim.cod';
    public const APPLICATION_VND_RN_REALMEDIA = 'application/vnd.rn-realmedia';
    public const APPLICATION_VND_ROUTE66_LINK66_XML = 'application/vnd.route66.link66+xml';
    public const APPLICATION_VND_RS_274X = 'application/vnd.rs-274x';
    public const APPLICATION_VND_RUCKUS_DOWNLOAD = 'application/vnd.ruckus.download';
    public const APPLICATION_VND_S3SMS = 'application/vnd.s3sms';
    public const APPLICATION_VND_SAILINGTRACKER_TRACK = 'application/vnd.sailingtracker.track';
    public const APPLICATION_VND_SBM_CID = 'application/vnd.sbm.cid';
    public const APPLICATION_VND_SBM_MID2 = 'application/vnd.sbm.mid2';
    public const APPLICATION_VND_SCRIBUS = 'application/vnd.scribus';
    public const APPLICATION_VND_SEALED_3DF = 'application/vnd.sealed.3df';
    public const APPLICATION_VND_SEALED_CSF = 'application/vnd.sealed.csf';
    public const APPLICATION_VND_SEALED_DOC = 'application/vnd.sealed-doc';
    public const APPLICATION_VND_SEALED_EML = 'application/vnd.sealed-eml';
    public const APPLICATION_VND_SEALED_MHT = 'application/vnd.sealed-mht';
    public const APPLICATION_VND_SEALED_NET = 'application/vnd.sealed.net';
    public const APPLICATION_VND_SEALED_PPT = 'application/vnd.sealed-ppt';
    public const APPLICATION_VND_SEALED_TIFF = 'application/vnd.sealed-tiff';
    public const APPLICATION_VND_SEALED_XLS = 'application/vnd.sealed-xls';
    public const APPLICATION_VND_SEALEDMEDIA_SOFTSEAL_HTML = 'application/vnd.sealedmedia.softseal-html';
    public const APPLICATION_VND_SEALEDMEDIA_SOFTSEAL_PDF = 'application/vnd.sealedmedia.softseal-pdf';
    public const APPLICATION_VND_SEEMAIL = 'application/vnd.seemail';
    public const APPLICATION_VND_SEMA = 'application/vnd-sema';
    public const APPLICATION_VND_SEMD = 'application/vnd.semd';
    public const APPLICATION_VND_SEMF = 'application/vnd.semf';
    public const APPLICATION_VND_SHANA_INFORMED_FORMDATA = 'application/vnd.shana.informed.formdata';
    public const APPLICATION_VND_SHANA_INFORMED_FORMTEMPLATE = 'application/vnd.shana.informed.formtemplate';
    public const APPLICATION_VND_SHANA_INFORMED_INTERCHANGE = 'application/vnd.shana.informed.interchange';
    public const APPLICATION_VND_SHANA_INFORMED_PACKAGE = 'application/vnd.shana.informed.package';
    public const APPLICATION_VND_SIMTECH_MINDMAPPER = 'application/vnd.SimTech-MindMapper';
    public const APPLICATION_VND_SIREN_JSON = 'application/vnd.siren+json';
    public const APPLICATION_VND_SMAF = 'application/vnd.smaf';
    public const APPLICATION_VND_SMART_NOTEBOOK = 'application/vnd.smart.notebook';
    public const APPLICATION_VND_SMART_TEACHER = 'application/vnd.smart.teacher';
    public const APPLICATION_VND_SOFTWARE602_FILLER_FORM_XML = 'application/vnd.software602.filler.form+xml';
    public const APPLICATION_VND_SOFTWARE602_FILLER_FORM_XML_ZIP = 'application/vnd.software602.filler.form-xml-zip';
    public const APPLICATION_VND_SOLENT_SDKM_XML = 'application/vnd.solent.sdkm+xml';
    public const APPLICATION_VND_SPOTFIRE_DXP = 'application/vnd.spotfire.dxp';
    public const APPLICATION_VND_SPOTFIRE_SFS = 'application/vnd.spotfire.sfs';
    public const APPLICATION_VND_SSS_COD = 'application/vnd.sss-cod';
    public const APPLICATION_VND_SSS_DTF = 'application/vnd.sss-dtf';
    public const APPLICATION_VND_SSS_NTF = 'application/vnd.sss-ntf';
    public const APPLICATION_VND_STARDIVISION_CALC = 'application/vnd.stardivision.calc';
    public const APPLICATION_VND_STARDIVISION_DRAW = 'application/vnd.stardivision.draw';
    public const APPLICATION_VND_STARDIVISION_IMPRESS = 'application/vnd.stardivision.impress';
    public const APPLICATION_VND_STARDIVISION_MATH = 'application/vnd.stardivision.math';
    public const APPLICATION_VND_STARDIVISION_WRITER = 'application/vnd.stardivision.writer';
    public const APPLICATION_VND_STARDIVISION_WRITER_GLOBAL = 'application/vnd.stardivision.writer-global';
    public const APPLICATION_VND_STEPMANIA_PACKAGE = 'application/vnd.stepmania.package';
    public const APPLICATION_VND_STEPMANIA_STEPCHART = 'application/vnd.stepmania.stepchart';
    public const APPLICATION_VND_STREET_STREAM = 'application/vnd.street-stream';
    public const APPLICATION_VND_SUN_WADL_XML = 'application/vnd.sun.wadl+xml';
    public const APPLICATION_VND_SUN_XML_CALC = 'application/vnd.sun.xml.calc';
    public const APPLICATION_VND_SUN_XML_CALC_TEMPLATE = 'application/vnd.sun.xml.calc.template';
    public const APPLICATION_VND_SUN_XML_DRAW = 'application/vnd.sun.xml.draw';
    public const APPLICATION_VND_SUN_XML_DRAW_TEMPLATE = 'application/vnd.sun.xml.draw.template';
    public const APPLICATION_VND_SUN_XML_IMPRESS = 'application/vnd.sun.xml.impress';
    public const APPLICATION_VND_SUN_XML_IMPRESS_TEMPLATE = 'application/vnd.sun.xml.impress.template';
    public const APPLICATION_VND_SUN_XML_MATH = 'application/vnd.sun.xml.math';
    public const APPLICATION_VND_SUN_XML_WRITER = 'application/vnd.sun.xml.writer';
    public const APPLICATION_VND_SUN_XML_WRITER_GLOBAL = 'application/vnd.sun.xml.writer.global';
    public const APPLICATION_VND_SUN_XML_WRITER_TEMPLATE = 'application/vnd.sun.xml.writer.template';
    public const APPLICATION_VND_SUS_CALENDAR = 'application/vnd.sus-calendar';
    public const APPLICATION_VND_SVD = 'application/vnd.svd';
    public const APPLICATION_VND_SWIFTVIEW_ICS = 'application/vnd.swiftview-ics';
    public const APPLICATION_VND_SYMBIAN_INSTALL = 'application/vnd.symbian.install';
    public const APPLICATION_VND_SYNCML_DM_NOTIFICATION = 'application/vnd.syncml.dm.notification';
    public const APPLICATION_VND_SYNCML_DM_WBXML = 'application/vnd.syncml.dm+wbxml';
    public const APPLICATION_VND_SYNCML_DM_XML = 'application/vnd.syncml.dm+xml';
    public const APPLICATION_VND_SYNCML_DMDDF_WBXML = 'application/vnd.syncml.dmddf+wbxml';
    public const APPLICATION_VND_SYNCML_DMDDF_XML = 'application/vnd.syncml.dmddf+xml';
    public const APPLICATION_VND_SYNCML_DMTNDS_WBXML = 'application/vnd.syncml.dmtnds+wbxml';
    public const APPLICATION_VND_SYNCML_DMTNDS_XML = 'application/vnd.syncml.dmtnds+xml';
    public const APPLICATION_VND_SYNCML_DS_NOTIFICATION = 'application/vnd.syncml.ds.notification';
    public const APPLICATION_VND_SYNCML_XML = 'application/vnd.syncml+xml';
    public const APPLICATION_VND_TABLESCHEMA_JSON = 'application/vnd.tableschema+json';
    public const APPLICATION_VND_TAO_INTENT_MODULE_ARCHIVE = 'application/vnd.tao.intent-module-archive';
    public const APPLICATION_VND_TCPDUMP_PCAP = 'application/vnd.tcpdump.pcap';
    public const APPLICATION_VND_TMD_MEDIAFLEX_API_XML = 'application/vnd.tmd.mediaflex.api+xml';
    public const APPLICATION_VND_TML = 'application/vnd.tml';
    public const APPLICATION_VND_TMOBILE_LIVETV = 'application/vnd.tmobile-livetv';
    public const APPLICATION_VND_TRI_ONESOURCE = 'application/vnd.tri.onesource';
    public const APPLICATION_VND_TRID_TPT = 'application/vnd.trid.tpt';
    public const APPLICATION_VND_TRISCAPE_MXS = 'application/vnd.triscape.mxs';
    public const APPLICATION_VND_TRUEAPP = 'application/vnd.trueapp';
    public const APPLICATION_VND_TRUEDOC = 'application/vnd.truedoc';
    public const APPLICATION_VND_UBISOFT_WEBPLAYER = 'application/vnd.ubisoft.webplayer';
    public const APPLICATION_VND_UFDL = 'application/vnd.ufdl';
    public const APPLICATION_VND_UIQ_THEME = 'application/vnd.uiq.theme';
    public const APPLICATION_VND_UMAJIN = 'application/vnd.umajin';
    public const APPLICATION_VND_UNITY = 'application/vnd.unity';
    public const APPLICATION_VND_UOML_XML = 'application/vnd.uoml+xml';
    public const APPLICATION_VND_UPLANET_ALERT = 'application/vnd.uplanet.alert';
    public const APPLICATION_VND_UPLANET_ALERT_WBXML = 'application/vnd.uplanet.alert-wbxml';
    public const APPLICATION_VND_UPLANET_BEARER_CHOICE = 'application/vnd.uplanet.bearer-choice';
    public const APPLICATION_VND_UPLANET_BEARER_CHOICE_WBXML = 'application/vnd.uplanet.bearer-choice-wbxml';
    public const APPLICATION_VND_UPLANET_CACHEOP = 'application/vnd.uplanet.cacheop';
    public const APPLICATION_VND_UPLANET_CACHEOP_WBXML = 'application/vnd.uplanet.cacheop-wbxml';
    public const APPLICATION_VND_UPLANET_CHANNEL = 'application/vnd.uplanet.channel';
    public const APPLICATION_VND_UPLANET_CHANNEL_WBXML = 'application/vnd.uplanet.channel-wbxml';
    public const APPLICATION_VND_UPLANET_LIST = 'application/vnd.uplanet.list';
    public const APPLICATION_VND_UPLANET_LIST_WBXML = 'application/vnd.uplanet.list-wbxml';
    public const APPLICATION_VND_UPLANET_LISTCMD = 'application/vnd.uplanet.listcmd';
    public const APPLICATION_VND_UPLANET_LISTCMD_WBXML = 'application/vnd.uplanet.listcmd-wbxml';
    public const APPLICATION_VND_UPLANET_SIGNAL = 'application/vnd.uplanet.signal';
    public const APPLICATION_VND_URI_MAP = 'application/vnd.uri-map';
    public const APPLICATION_VND_VALVE_SOURCE_MATERIAL = 'application/vnd.valve.source.material';
    public const APPLICATION_VND_VCX = 'application/vnd.vcx';
    public const APPLICATION_VND_VD_STUDY = 'application/vnd.vd-study';
    public const APPLICATION_VND_VECTORWORKS = 'application/vnd.vectorworks';
    public const APPLICATION_VND_VEL_JSON = 'application/vnd.vel+json';
    public const APPLICATION_VND_VERIMATRIX_VCAS = 'application/vnd.verimatrix.vcas';
    public const APPLICATION_VND_VIDSOFT_VIDCONFERENCE = 'application/vnd.vidsoft.vidconference';
    public const APPLICATION_VND_VISIO = 'application/vnd.visio';
    public const APPLICATION_VND_VISIO2013 = 'application/vnd.visio2013';
    public const APPLICATION_VND_VISIONARY = 'application/vnd.visionary';
    public const APPLICATION_VND_VIVIDENCE_SCRIPTFILE = 'application/vnd.vividence.scriptfile';
    public const APPLICATION_VND_VSF = 'application/vnd.vsf';
    public const APPLICATION_VND_WAP_SIC = 'application/vnd.wap.sic';
    public const APPLICATION_VND_WAP_SLC = 'application/vnd.wap-slc';
    public const APPLICATION_VND_WAP_WBXML = 'application/vnd.wap-wbxml';
    public const APPLICATION_VND_WAP_WMLC = 'application/vnd-wap-wmlc';
    public const APPLICATION_VND_WAP_WMLSCRIPTC = 'application/vnd.wap.wmlscriptc';
    public const APPLICATION_VND_WEBTURBO = 'application/vnd.webturbo';
    public const APPLICATION_VND_WFA_P2P = 'application/vnd.wfa.p2p';
    public const APPLICATION_VND_WFA_WSC = 'application/vnd.wfa.wsc';
    public const APPLICATION_VND_WINDOWS_DEVICEPAIRING = 'application/vnd.windows.devicepairing';
    public const APPLICATION_VND_WMC = 'application/vnd.wmc';
    public const APPLICATION_VND_WMF_BOOTSTRAP = 'application/vnd.wmf.bootstrap';
    public const APPLICATION_VND_WOLFRAM_MATHEMATICA = 'application/vnd.wolfram.mathematica';
    public const APPLICATION_VND_WOLFRAM_MATHEMATICA_PACKAGE = 'application/vnd.wolfram.mathematica.package';
    public const APPLICATION_VND_WOLFRAM_PLAYER = 'application/vnd.wolfram.player';
    public const APPLICATION_VND_WORDPERFECT = 'application/vnd.wordperfect';
    public const APPLICATION_VND_WQD = 'application/vnd.wqd';
    public const APPLICATION_VND_WRQ_HP3000_LABELLED = 'application/vnd.wrq-hp3000-labelled';
    public const APPLICATION_VND_WT_STF = 'application/vnd.wt.stf';
    public const APPLICATION_VND_WV_CSP_WBXML = 'application/vnd.wv.csp+wbxml';
    public const APPLICATION_VND_WV_CSP_XML = 'application/vnd.wv.csp+xml';
    public const APPLICATION_VND_WV_SSP_XML = 'application/vnd.wv.ssp+xml';
    public const APPLICATION_VND_XACML_JSON = 'application/vnd.xacml+json';
    public const APPLICATION_VND_XARA = 'application/vnd.xara';
    public const APPLICATION_VND_XFDL = 'application/vnd.xfdl';
    public const APPLICATION_VND_XFDL_WEBFORM = 'application/vnd.xfdl.webform';
    public const APPLICATION_VND_XMI_XML = 'application/vnd.xmi+xml';
    public const APPLICATION_VND_XMPIE_CPKG = 'application/vnd.xmpie.cpkg';
    public const APPLICATION_VND_XMPIE_DPKG = 'application/vnd.xmpie.dpkg';
    public const APPLICATION_VND_XMPIE_PLAN = 'application/vnd.xmpie.plan';
    public const APPLICATION_VND_XMPIE_PPKG = 'application/vnd.xmpie.ppkg';
    public const APPLICATION_VND_XMPIE_XLIM = 'application/vnd.xmpie.xlim';
    public const APPLICATION_VND_YAMAHA_HV_DIC = 'application/vnd.yamaha.hv-dic';
    public const APPLICATION_VND_YAMAHA_HV_SCRIPT = 'application/vnd.yamaha.hv-script';
    public const APPLICATION_VND_YAMAHA_HV_VOICE = 'application/vnd.yamaha.hv-voice';
    public const APPLICATION_VND_YAMAHA_OPENSCOREFORMAT = 'application/vnd.yamaha.openscoreformat';
    public const APPLICATION_VND_YAMAHA_OPENSCOREFORMAT_OSFPVG_XML = 'application/vnd.yamaha.openscoreformat.osfpvg+xml';
    public const APPLICATION_VND_YAMAHA_REMOTE_SETUP = 'application/vnd.yamaha.remote-setup';
    public const APPLICATION_VND_YAMAHA_SMAF_AUDIO = 'application/vnd.yamaha.smaf-audio';
    public const APPLICATION_VND_YAMAHA_SMAF_PHRASE = 'application/vnd.yamaha.smaf-phrase';
    public const APPLICATION_VND_YAMAHA_THROUGH_NGN = 'application/vnd.yamaha.through-ngn';
    public const APPLICATION_VND_YAMAHA_TUNNEL_UDPENCAP = 'application/vnd.yamaha.tunnel-udpencap';
    public const APPLICATION_VND_YAOWEME = 'application/vnd.yaoweme';
    public const APPLICATION_VND_YELLOWRIVER_CUSTOM_MENU = 'application/vnd.yellowriver-custom-menu';
    public const APPLICATION_VND_ZUL = 'application/vnd.zul';
    public const APPLICATION_VND_ZZAZZ_DECK_XML = 'application/vnd.zzazz.deck+xml';
    public const APPLICATION_VOICEXML_XML = 'application/voicexml+xml';
    public const APPLICATION_VQ_RTCPXR = 'application/vq-rtcpxr';
    public const APPLICATION_WATCHERINFO_XML = 'application/watcherinfo+xml';
    public const APPLICATION_WHOISPP_QUERY = 'application/whoispp-query';
    public const APPLICATION_WHOISPP_RESPONSE = 'application/whoispp-response';
    public const APPLICATION_WIDGET = 'application/widget';
    public const APPLICATION_WINHLP = 'application/winhlp';
    public const APPLICATION_WITA = 'application/wita';
    public const APPLICATION_WORDPERFECT5_1 = 'application/wordperfect5.1';
    public const APPLICATION_WSDL_XML = 'application/wsdl+xml';
    public const APPLICATION_WSPOLICY_XML = 'application/wspolicy+xml';
    public const APPLICATION_X400_BP = 'application/x400-bp';
    public const APPLICATION_X_7Z_COMPRESSED = 'application/x-7z-compressed';
    public const APPLICATION_X_ABIWORD = 'application/x-abiword';
    public const APPLICATION_X_ACE_COMPRESSED = 'application/x-ace-compressed';
    public const APPLICATION_X_ALZ_COMPRESSED = 'application/x-alz-compressed';
    public const APPLICATION_X_APPLE_DISKIMAGE = 'application/x-apple-diskimage';
    public const APPLICATION_X_ARJ = 'application/x-arj';
    public const APPLICATION_X_ASTROTITE_AFA = 'application/x-astrotite-afa';
    public const APPLICATION_X_AUTHORWARE_BIN = 'application/x-authorware-bin';
    public const APPLICATION_X_AUTHORWARE_MAP = 'application/x-authorware-map';
    public const APPLICATION_X_AUTHORWARE_SEG = 'application/x-authorware-seg';
    public const APPLICATION_X_B1 = 'application/x-b1';
    public const APPLICATION_X_BCPIO = 'application/x-bcpio';
    public const APPLICATION_X_BITTORRENT = 'application/x-bittorrent';
    public const APPLICATION_X_BZIP = 'application/x-bzip';
    public const APPLICATION_X_BZIP2 = 'application/x-bzip2';
    public const APPLICATION_X_CDLINK = 'application/x-cdlink';
    public const APPLICATION_X_CFS_COMPRESSED = 'application/x-cfs-compressed';
    public const APPLICATION_X_CHAT = 'application/x-chat';
    public const APPLICATION_X_CHESS_PGN = 'application/x-chess-pgn';
    public const APPLICATION_X_COMPRESS = 'application/x-compress';
    public const APPLICATION_X_CPIO = 'application/x-cpio';
    public const APPLICATION_X_CSH = 'application/x-csh';
    public const APPLICATION_X_DAR = 'application/x-dar';
    public const APPLICATION_X_DEBIAN_PACKAGE = 'application/x-debian-package';
    public const APPLICATION_X_DGC_COMPRESSED = 'application/x-dgc-compressed';
    public const APPLICATION_X_DIRECTOR = 'application/x-director';
    public const APPLICATION_X_DOOM = 'application/x-doom';
    public const APPLICATION_X_DTBNCX_XML = 'application/x-dtbncx+xml';
    public const APPLICATION_X_DTBOOK_XML = 'application/x-dtbook+xml';
    public const APPLICATION_X_DTBRESOURCE_XML = 'application/x-dtbresource+xml';
    public const APPLICATION_X_DVI = 'application/x-dvi';
    public const APPLICATION_X_FONT_BDF = 'application/x-font-bdf';
    public const APPLICATION_X_FONT_GHOSTSCRIPT = 'application/x-font-ghostscript';
    public const APPLICATION_X_FONT_LINUX_PSF = 'application/x-font-linux-psf';
    public const APPLICATION_X_FONT_OTF = 'application/x-font-otf';
    public const APPLICATION_X_FONT_PCF = 'application/x-font-pcf';
    public const APPLICATION_X_FONT_SNF = 'application/x-font-snf';
    public const APPLICATION_X_FONT_TTF = 'application/x-font-ttf';
    public const APPLICATION_X_FONT_TYPE1 = 'application/x-font-type1';
    public const APPLICATION_X_FONT_WOFF = 'application/x-font-woff';
    public const APPLICATION_X_FUTURESPLASH = 'application/x-futuresplash';
    public const APPLICATION_X_GCA_COMPRESSED = 'application/x-gca-compressed';
    public const APPLICATION_X_GNUMERIC = 'application/x-gnumeric';
    public const APPLICATION_X_GTAR = 'application/x-gtar';
    public const APPLICATION_X_HDF = 'application/x-hdf';
    public const APPLICATION_X_JAVA_JNLP_FILE = 'application/x-java-jnlp-file';
    public const APPLICATION_X_LATEX = 'application/x-latex';
    public const APPLICATION_X_LZH = 'application/x-lzh';
    public const APPLICATION_X_LZIP = 'application/x-lzip';
    public const APPLICATION_X_LZMA = 'application/x-lzma';
    public const APPLICATION_X_LZOP = 'application/x-lzop';
    public const APPLICATION_X_LZX = 'application/x-lzx';
    public const APPLICATION_X_MOBIPOCKET_EBOOK = 'application/x-mobipocket-ebook';
    public const APPLICATION_X_MS_APPLICATION = 'application/x-ms-application';
    public const APPLICATION_X_MS_WMD = 'application/x-ms-wmd';
    public const APPLICATION_X_MS_WMZ = 'application/x-ms-wmz';
    public const APPLICATION_X_MS_XBAP = 'application/x-ms-xbap';
    public const APPLICATION_X_MSACCESS = 'application/x-msaccess';
    public const APPLICATION_X_MSBINDER = 'application/x-msbinder';
    public const APPLICATION_X_MSCARDFILE = 'application/x-mscardfile';
    public const APPLICATION_X_MSCLIP = 'application/x-msclip';
    public const APPLICATION_X_MSDOWNLOAD = 'application/x-msdownload';
    public const APPLICATION_X_MSMEDIAVIEW = 'application/x-msmediaview';
    public const APPLICATION_X_MSMETAFILE = 'application/x-msmetafile';
    public const APPLICATION_X_MSMONEY = 'application/x-msmoney';
    public const APPLICATION_X_MSPUBLISHER = 'application/x-mspublisher';
    public const APPLICATION_X_MSSCHEDULE = 'application/x-msschedule';
    public const APPLICATION_X_MSTERMINAL = 'application/x-msterminal';
    public const APPLICATION_X_MSWRITE = 'application/x-mswrite';
    public const APPLICATION_X_NETCDF = 'application/x-netcdf';
    public const APPLICATION_X_PKCS12 = 'application/x-pkcs12';
    public const APPLICATION_X_PKCS7_CERTIFICATES = 'application/x-pkcs7-certificates';
    public const APPLICATION_X_PKCS7_CERTREQRESP = 'application/x-pkcs7-certreqresp';
    public const APPLICATION_X_RAR_COMPRESSED = 'application/x-rar-compressed';
    public const APPLICATION_X_SH = 'application/x-sh';
    public const APPLICATION_X_SHAR = 'application/x-shar';
    public const APPLICATION_X_SHOCKWAVE_FLASH = 'application/x-shockwave-flash';
    public const APPLICATION_X_SILVERLIGHT_APP = 'application/x-silverlight-app';
    public const APPLICATION_X_SNAPPY_FRAMED = 'application/x-snappy-framed';
    public const APPLICATION_X_STUFFIT = 'application/x-stuffit';
    public const APPLICATION_X_STUFFITX = 'application/x-stuffitx';
    public const APPLICATION_X_SV4CPIO = 'application/x-sv4cpio';
    public const APPLICATION_X_SV4CRC = 'application/x-sv4crc';
    public const APPLICATION_X_TAR = 'application/x-tar';
    public const APPLICATION_X_TCL = 'application/x-tcl';
    public const APPLICATION_X_TEX = 'application/x-tex';
    public const APPLICATION_X_TEX_TFM = 'application/x-tex-tfm';
    public const APPLICATION_X_TEXINFO = 'application/x-texinfo';
    public const APPLICATION_X_USTAR = 'application/x-ustar';
    public const APPLICATION_X_WAIS_SOURCE = 'application/x-wais-source';
    public const APPLICATION_X_WWW_FORM_URLENCODED = 'application/x-www-form-urlencoded';
    public const APPLICATION_X_X509_CA_CERT = 'application/x-x509-ca-cert';
    public const APPLICATION_X_XFIG = 'application/x-xfig';
    public const APPLICATION_X_XPINSTALL = 'application/x-xpinstall';
    public const APPLICATION_X_XZ = 'application/x-xz';
    public const APPLICATION_X_ZOO = 'application/x-zoo';
    public const APPLICATION_XACML_XML = 'application/xacml+xml';
    public const APPLICATION_XCAP_ATT_XML = 'application/xcap-att+xml';
    public const APPLICATION_XCAP_CAPS_XML = 'application/xcap-caps+xml';
    public const APPLICATION_XCAP_DIFF_XML = 'application/xcap-diff+xml';
    public const APPLICATION_XCAP_EL_XML = 'application/xcap-el+xml';
    public const APPLICATION_XCAP_ERROR_XML = 'application/xcap-error+xml';
    public const APPLICATION_XCAP_NS_XML = 'application/xcap-ns+xml';
    public const APPLICATION_XCON_CONFERENCE_INFO_DIFF_XML = 'application/xcon-conference-info-diff+xml';
    public const APPLICATION_XCON_CONFERENCE_INFO_XML = 'application/xcon-conference-info+xml';
    public const APPLICATION_XENC_XML = 'application/xenc+xml';
    public const APPLICATION_XHTML_XML = 'application/xhtml+xml';
    public const APPLICATION_XML = 'application/xml';
    public const APPLICATION_XML_DTD = 'application/xml-dtd';
    public const APPLICATION_XML_EXTERNAL_PARSED_ENTITY = 'application/xml-external-parsed-entity';
    public const APPLICATION_XML_PATCH_XML = 'application/xml-patch+xml';
    public const APPLICATION_XMPP_XML = 'application/xmpp+xml';
    public const APPLICATION_XOP_XML = 'application/xop+xml';
    public const APPLICATION_XSLT_XML = 'application/xslt+xml';
    public const APPLICATION_XSPF_XML = 'application/xspf+xml';
    public const APPLICATION_XV_XML = 'application/xv+xml';
    public const APPLICATION_YANG = 'application/yang';
    public const APPLICATION_YANG_DATA_JSON = 'application/yang-data+json';
    public const APPLICATION_YANG_DATA_XML = 'application/yang-data+xml';
    public const APPLICATION_YANG_PATCH_JSON = 'application/yang-patch+json';
    public const APPLICATION_YANG_PATCH_XML = 'application/yang-patch+xml';
    public const APPLICATION_YIN_XML = 'application/yin+xml';
    public const APPLICATION_ZIP = 'application/zip';
    public const APPLICATION_ZLIB = 'application/zlib';
    public const AUDIO_1D_INTERLEAVED_PARITYFEC = 'audio/1d-interleaved-parityfec';
    public const AUDIO_32KADPCM = 'audio/32kadpcm';
    public const AUDIO_3GPP = 'audio/3gpp';
    public const AUDIO_3GPP2 = 'audio/3gpp2';
    public const AUDIO_AC3 = 'audio/ac3';
    public const AUDIO_ADPCM = 'audio/adpcm';
    public const AUDIO_AMR = 'audio/AMR';
    public const AUDIO_AMR_WB = 'audio/AMR-WB';
    public const AUDIO_AMR_WB_ = 'audio/amr-wb+';
    public const AUDIO_APTX = 'audio/aptx';
    public const AUDIO_ASC = 'audio/asc';
    public const AUDIO_ATRAC3 = 'audio/ATRAC3';
    public const AUDIO_ATRAC_ADVANCED_LOSSLESS = 'audio/ATRAC-ADVANCED-LOSSLESS';
    public const AUDIO_ATRAC_X = 'audio/ATRAC-X';
    public const AUDIO_BASIC = 'audio/basic';
    public const AUDIO_BV16 = 'audio/BV16';
    public const AUDIO_BV32 = 'audio/BV32';
    public const AUDIO_CLEARMODE = 'audio/clearmode';
    public const AUDIO_CN = 'audio/CN';
    public const AUDIO_DAT12 = 'audio/DAT12';
    public const AUDIO_DLS = 'audio/dls';
    public const AUDIO_DSR_ES201108 = 'audio/dsr-es201108';
    public const AUDIO_DSR_ES202050 = 'audio/dsr-es202050';
    public const AUDIO_DSR_ES202211 = 'audio/dsr-es202211';
    public const AUDIO_DSR_ES202212 = 'audio/dsr-es202212';
    public const AUDIO_DV = 'audio/DV';
    public const AUDIO_DVI4 = 'audio/DVI4';
    public const AUDIO_EAC3 = 'audio/eac3';
    public const AUDIO_ENCAPRTP = 'audio/encaprtp';
    public const AUDIO_EVRC = 'audio/EVRC';
    public const AUDIO_EVRC0 = 'audio/EVRC0';
    public const AUDIO_EVRC1 = 'audio/EVRC1';
    public const AUDIO_EVRC_QCP = 'audio/EVRC-QCP';
    public const AUDIO_EVRCB = 'audio/EVRCB';
    public const AUDIO_EVRCB0 = 'audio/EVRCB0';
    public const AUDIO_EVRCB1 = 'audio/EVRCB1';
    public const AUDIO_EVRCNW = 'audio/EVRCNW';
    public const AUDIO_EVRCNW0 = 'audio/EVRCNW0';
    public const AUDIO_EVRCNW1 = 'audio/EVRCNW1';
    public const AUDIO_EVRCWB = 'audio/EVRCWB';
    public const AUDIO_EVRCWB0 = 'audio/EVRCWB0';
    public const AUDIO_EVRCWB1 = 'audio/EVRCWB1';
    public const AUDIO_EVS = 'audio/EVS';
    public const AUDIO_EXAMPLE = 'audio/example';
    public const AUDIO_FWDRED = 'audio/fwdred';
    public const AUDIO_G711_0 = 'audio/G711-0';
    public const AUDIO_G719 = 'audio/G719';
    public const AUDIO_G722 = 'audio/G722';
    public const AUDIO_G7221 = 'audio/G7221';
    public const AUDIO_G723 = 'audio/G723';
    public const AUDIO_G726_16 = 'audio/G726-16';
    public const AUDIO_G726_24 = 'audio/G726-24';
    public const AUDIO_G726_32 = 'audio/G726-32';
    public const AUDIO_G726_40 = 'audio/G726-40';
    public const AUDIO_G728 = 'audio/G728';
    public const AUDIO_G729 = 'audio/G729';
    public const AUDIO_G729D = 'audio/G729D';
    public const AUDIO_G729E = 'audio/G729E';
    public const AUDIO_GSM = 'audio/GSM';
    public const AUDIO_GSM_EFR = 'audio/GSM-EFR';
    public const AUDIO_GSM_HR_08 = 'audio/GSM-HR-08';
    public const AUDIO_ILBC = 'audio/iLBC';
    public const AUDIO_IP_MR_V2_5 = 'audio/ip-mr_v2.5';
    public const AUDIO_L16 = 'audio/L16';
    public const AUDIO_L20 = 'audio/L20';
    public const AUDIO_L24 = 'audio/L24';
    public const AUDIO_L8 = 'audio/L8';
    public const AUDIO_LPC = 'audio/LPC';
    public const AUDIO_MIDI = 'audio/midi';
    public const AUDIO_MOBILE_XMF = 'audio/mobile-xmf';
    public const AUDIO_MP4 = 'audio/mp4';
    public const AUDIO_MP4A_LATM = 'audio/MP4A-LATM';
    public const AUDIO_MPA = 'audio/MPA';
    public const AUDIO_MPA_ROBUST = 'audio/mpa-robust';
    public const AUDIO_MPEG = 'audio/mpeg';
    public const AUDIO_MPEG4_GENERIC = 'audio/mpeg4-generic';
    public const AUDIO_OGG = 'audio/ogg';
    public const AUDIO_OPUS = 'audio/opus';
    public const AUDIO_PCMA = 'audio/PCMA';
    public const AUDIO_PCMA_WB = 'audio/PCMA-WB';
    public const AUDIO_PCMU = 'audio/PCMU';
    public const AUDIO_PCMU_WB = 'audio/PCMU-WB';
    public const AUDIO_PRS_SID = 'audio/prs.sid';
    public const AUDIO_RAPTORFEC = 'audio/raptorfec';
    public const AUDIO_RED = 'audio/RED';
    public const AUDIO_RTP_ENC_AESCM128 = 'audio/rtp-enc-aescm128';
    public const AUDIO_RTP_MIDI = 'audio/rtp-midi';
    public const AUDIO_RTPLOOPBACK = 'audio/rtploopback';
    public const AUDIO_RTX = 'audio/rtx';
    public const AUDIO_SMV = 'audio/SMV';
    public const AUDIO_SMV0 = 'audio/SMV0';
    public const AUDIO_SMV_QCP = 'audio/SMV-QCP';
    public const AUDIO_SP_MIDI = 'audio/sp-midi';
    public const AUDIO_SPEEX = 'audio/speex';
    public const AUDIO_T140C = 'audio/t140c';
    public const AUDIO_T38 = 'audio/t38';
    public const AUDIO_TELEPHONE_EVENT = 'audio/telephone-event';
    public const AUDIO_TONE = 'audio/tone';
    public const AUDIO_UEMCLIP = 'audio/UEMCLIP';
    public const AUDIO_ULPFEC = 'audio/ulpfec';
    public const AUDIO_VDVI = 'audio/VDVI';
    public const AUDIO_VMR_WB = 'audio/VMR-WB';
    public const AUDIO_VND_3GPP_IUFP = 'audio/vnd.3gpp.iufp';
    public const AUDIO_VND_4SB = 'audio/vnd.4SB';
    public const AUDIO_VND_AUDIOKOZ = 'audio/vnd.audiokoz';
    public const AUDIO_VND_CELP = 'audio/vnd.CELP';
    public const AUDIO_VND_CISCO_NSE = 'audio/vnd.cisco.nse';
    public const AUDIO_VND_CMLES_RADIO_EVENTS = 'audio/vnd.cmles.radio-events';
    public const AUDIO_VND_CNS_ANP1 = 'audio/vnd.cns.anp1';
    public const AUDIO_VND_CNS_INF1 = 'audio/vnd.cns.inf1';
    public const AUDIO_VND_DECE_AUDIO = 'audio/vnd.dece.audio';
    public const AUDIO_VND_DIGITAL_WINDS = 'audio/vnd.digital-winds';
    public const AUDIO_VND_DLNA_ADTS = 'audio/vnd.dlna.adts';
    public const AUDIO_VND_DOLBY_HEAAC_1 = 'audio/vnd.dolby.heaac.1';
    public const AUDIO_VND_DOLBY_HEAAC_2 = 'audio/vnd.dolby.heaac.2';
    public const AUDIO_VND_DOLBY_MLP = 'audio/vnd.dolby.mlp';
    public const AUDIO_VND_DOLBY_MPS = 'audio/vnd.dolby.mps';
    public const AUDIO_VND_DOLBY_PL2 = 'audio/vnd.dolby.pl2';
    public const AUDIO_VND_DOLBY_PL2X = 'audio/vnd.dolby.pl2x';
    public const AUDIO_VND_DOLBY_PL2Z = 'audio/vnd.dolby.pl2z';
    public const AUDIO_VND_DOLBY_PULSE_1 = 'audio/vnd.dolby.pulse.1';
    public const AUDIO_VND_DRA = 'audio/vnd.dra';
    public const AUDIO_VND_DTS = 'audio/vnd.dts';
    public const AUDIO_VND_DTS_HD = 'audio/vnd.dts.hd';
    public const AUDIO_VND_DVB_FILE = 'audio/vnd.dvb.file';
    public const AUDIO_VND_EVERAD_PLJ = 'audio/vnd.everad.plj';
    public const AUDIO_VND_HNS_AUDIO = 'audio/vnd.hns.audio';
    public const AUDIO_VND_LUCENT_VOICE = 'audio/vnd.lucent.voice';
    public const AUDIO_VND_MS_PLAYREADY_MEDIA_PYA = 'audio/vnd.ms-playready.media.pya';
    public const AUDIO_VND_NOKIA_MOBILE_XMF = 'audio/vnd.nokia.mobile-xmf';
    public const AUDIO_VND_NORTEL_VBK = 'audio/vnd.nortel.vbk';
    public const AUDIO_VND_NUERA_ECELP4800 = 'audio/vnd.nuera.ecelp4800';
    public const AUDIO_VND_NUERA_ECELP7470 = 'audio/vnd.nuera.ecelp7470';
    public const AUDIO_VND_NUERA_ECELP9600 = 'audio/vnd.nuera.ecelp9600';
    public const AUDIO_VND_OCTEL_SBC = 'audio/vnd.octel.sbc';
    public const AUDIO_VND_QCELP = 'audio/vnd.qcelp';
    public const AUDIO_VND_RHETOREX_32KADPCM = 'audio/vnd.rhetorex.32kadpcm';
    public const AUDIO_VND_RIP = 'audio/vnd.rip';
    public const AUDIO_VND_SEALEDMEDIA_SOFTSEAL_MPEG = 'audio/vnd.sealedmedia.softseal-mpeg';
    public const AUDIO_VND_VMX_CVSD = 'audio/vnd.vmx.cvsd';
    public const AUDIO_VORBIS = 'audio/vorbis';
    public const AUDIO_VORBIS_CONFIG = 'audio/vorbis-config';
    public const AUDIO_WEBM = 'audio/webm';
    public const AUDIO_X_AAC = 'audio/x-aac';
    public const AUDIO_X_AIFF = 'audio/x-aiff';
    public const AUDIO_X_MPEGURL = 'audio/x-mpegurl';
    public const AUDIO_X_MS_WAX = 'audio/x-ms-wax';
    public const AUDIO_X_MS_WMA = 'audio/x-ms-wma';
    public const AUDIO_X_PN_REALAUDIO = 'audio/x-pn-realaudio';
    public const AUDIO_X_PN_REALAUDIO_PLUGIN = 'audio/x-pn-realaudio-plugin';
    public const AUDIO_X_WAV = 'audio/x-wav';
    public const CHEMICAL_X_CDX = 'chemical/x-cdx';
    public const CHEMICAL_X_CIF = 'chemical/x-cif';
    public const CHEMICAL_X_CMDF = 'chemical/x-cmdf';
    public const CHEMICAL_X_CML = 'chemical/x-cml';
    public const CHEMICAL_X_CSML = 'chemical/x-csml';
    public const CHEMICAL_X_XYZ = 'chemical/x-xyz';
    public const FONT_COLLECTION = 'font/collection';
    public const FONT_OTF = 'font/otf';
    public const FONT_SFNT = 'font/sfnt';
    public const FONT_TTF = 'font/ttf';
    public const FONT_WOFF = 'font/woff';
    public const FONT_WOFF2 = 'font/woff2';
    public const IMAGE_BMP = 'image/bmp';
    public const IMAGE_CGM = 'image/cgm';
    public const IMAGE_DICOM_RLE = 'image/dicom-rle';
    public const IMAGE_EMF = 'image/emf';
    public const IMAGE_EXAMPLE = 'image/example';
    public const IMAGE_FITS = 'image/fits';
    public const IMAGE_G3FAX = 'image/g3fax';
    public const IMAGE_GIF = 'image/gif';
    public const IMAGE_IEF = 'image/ief';
    public const IMAGE_JLS = 'image/jls';
    public const IMAGE_JP2 = 'image/jp2';
    public const IMAGE_JPEG = 'image/jpeg';
    public const IMAGE_JPM = 'image/jpm';
    public const IMAGE_JPX = 'image/jpx';
    public const IMAGE_KTX = 'image/ktx';
    public const IMAGE_NAPLPS = 'image/naplps';
    public const IMAGE_PJPEG = 'image/pjpeg';
    public const IMAGE_PNG = 'image/png';
    public const IMAGE_PRS_BTIF = 'image/prs.btif';
    public const IMAGE_PRS_PTI = 'image/prs.pti';
    public const IMAGE_PWG_RASTER = 'image/pwg-raster';
    public const IMAGE_SVG_XML = 'image/svg+xml';
    public const IMAGE_T38 = 'image/t38';
    public const IMAGE_TIFF = 'image/tiff';
    public const IMAGE_TIFF_FX = 'image/tiff-fx';
    public const IMAGE_VND_ADOBE_PHOTOSHOP = 'image/vnd.adobe.photoshop';
    public const IMAGE_VND_AIRZIP_ACCELERATOR_AZV = 'image/vnd.airzip.accelerator.azv';
    public const IMAGE_VND_CNS_INF2 = 'image/vnd.cns.inf2';
    public const IMAGE_VND_DECE_GRAPHIC = 'image/vnd.dece.graphic';
    public const IMAGE_VND_DJVU = 'image/vnd-djvu';
    public const IMAGE_VND_DVB_SUBTITLE = 'image/vnd.dvb.subtitle';
    public const IMAGE_VND_DWG = 'image/vnd.dwg';
    public const IMAGE_VND_DXF = 'image/vnd.dxf';
    public const IMAGE_VND_FASTBIDSHEET = 'image/vnd.fastbidsheet';
    public const IMAGE_VND_FPX = 'image/vnd.fpx';
    public const IMAGE_VND_FST = 'image/vnd.fst';
    public const IMAGE_VND_FUJIXEROX_EDMICS_MMR = 'image/vnd.fujixerox.edmics-mmr';
    public const IMAGE_VND_FUJIXEROX_EDMICS_RLC = 'image/vnd.fujixerox.edmics-rlc';
    public const IMAGE_VND_GLOBALGRAPHICS_PGB = 'image/vnd.globalgraphics.pgb';
    public const IMAGE_VND_MICROSOFT_ICON = 'image/vnd.microsoft.icon';
    public const IMAGE_VND_MIX = 'image/vnd.mix';
    public const IMAGE_VND_MOZILLA_APNG = 'image/vnd.mozilla.apng';
    public const IMAGE_VND_MS_MODI = 'image/vnd.ms-modi';
    public const IMAGE_VND_NET_FPX = 'image/vnd.net-fpx';
    public const IMAGE_VND_RADIANCE = 'image/vnd.radiance';
    public const IMAGE_VND_SEALED_PNG = 'image/vnd.sealed-png';
    public const IMAGE_VND_SEALEDMEDIA_SOFTSEAL_GIF = 'image/vnd.sealedmedia.softseal-gif';
    public const IMAGE_VND_SEALEDMEDIA_SOFTSEAL_JPG = 'image/vnd.sealedmedia.softseal-jpg';
    public const IMAGE_VND_SVF = 'image/vnd-svf';
    public const IMAGE_VND_TENCENT_TAP = 'image/vnd.tencent.tap';
    public const IMAGE_VND_VALVE_SOURCE_TEXTURE = 'image/vnd.valve.source.texture';
    public const IMAGE_VND_WAP_WBMP = 'image/vnd-wap-wbmp';
    public const IMAGE_VND_XIFF = 'image/vnd.xiff';
    public const IMAGE_VND_ZBRUSH_PCX = 'image/vnd.zbrush.pcx';
    public const IMAGE_WEBP = 'image/webp';
    public const IMAGE_WMF = 'image/wmf';
    public const IMAGE_X_CITRIX_JPEG = 'image/x-citrix-jpeg';
    public const IMAGE_X_CITRIX_PNG = 'image/x-citrix-png';
    public const IMAGE_X_CMU_RASTER = 'image/x-cmu-raster';
    public const IMAGE_X_CMX = 'image/x-cmx';
    public const IMAGE_X_FREEHAND = 'image/x-freehand';
    public const IMAGE_X_ICON = 'image/x-icon';
    public const IMAGE_X_PCX = 'image/x-pcx';
    public const IMAGE_X_PICT = 'image/x-pict';
    public const IMAGE_X_PNG = 'image/x-png';
    public const IMAGE_X_PORTABLE_ANYMAP = 'image/x-portable-anymap';
    public const IMAGE_X_PORTABLE_BITMAP = 'image/x-portable-bitmap';
    public const IMAGE_X_PORTABLE_GRAYMAP = 'image/x-portable-graymap';
    public const IMAGE_X_PORTABLE_PIXMAP = 'image/x-portable-pixmap';
    public const IMAGE_X_RGB = 'image/x-rgb';
    public const IMAGE_X_XBITMAP = 'image/x-xbitmap';
    public const IMAGE_X_XPIXMAP = 'image/x-xpixmap';
    public const IMAGE_X_XWINDOWDUMP = 'image/x-xwindowdump';
    public const MESSAGE_CPIM = 'message/CPIM';
    public const MESSAGE_DELIVERY_STATUS = 'message/delivery-status';
    public const MESSAGE_DISPOSITION_NOTIFICATION = 'message/disposition-notification';
    public const MESSAGE_EXAMPLE = 'message/example';
    public const MESSAGE_FEEDBACK_REPORT = 'message/feedback-report';
    public const MESSAGE_GLOBAL = 'message/global';
    public const MESSAGE_GLOBAL_DELIVERY_STATUS = 'message/global-delivery-status';
    public const MESSAGE_GLOBAL_DISPOSITION_NOTIFICATION = 'message/global-disposition-notification';
    public const MESSAGE_GLOBAL_HEADERS = 'message/global-headers';
    public const MESSAGE_HTTP = 'message/http';
    public const MESSAGE_IMDN_XML = 'message/imdn+xml';
    public const MESSAGE_NEWS = 'message/news';
    public const MESSAGE_RFC822 = 'message/rfc822';
    public const MESSAGE_S_HTTP = 'message/s-http';
    public const MESSAGE_SIP = 'message/sip';
    public const MESSAGE_SIPFRAG = 'message/sipfrag';
    public const MESSAGE_TRACKING_STATUS = 'message/tracking-status';
    public const MESSAGE_VND_SI_SIMP = 'message/vnd.si.simp';
    public const MESSAGE_VND_WFA_WSC = 'message/vnd.wfa.wsc';
    public const MODEL_EXAMPLE = 'model/example';
    public const MODEL_GLTF_JSON = 'model/gltf+json';
    public const MODEL_IGES = 'model/iges';
    public const MODEL_MESH = 'model/mesh';
    public const MODEL_VND_COLLADA_XML = 'model/vnd.collada+xml';
    public const MODEL_VND_DWF = 'model/vnd-dwf';
    public const MODEL_VND_FLATLAND_3DML = 'model/vnd.flatland.3dml';
    public const MODEL_VND_GDL = 'model/vnd.gdl';
    public const MODEL_VND_GS_GDL = 'model/vnd.gs-gdl';
    public const MODEL_VND_GTW = 'model/vnd.gtw';
    public const MODEL_VND_MOML_XML = 'model/vnd.moml+xml';
    public const MODEL_VND_MTS = 'model/vnd.mts';
    public const MODEL_VND_OPENGEX = 'model/vnd.opengex';
    public const MODEL_VND_PARASOLID_TRANSMIT_BINARY = 'model/vnd.parasolid.transmit-binary';
    public const MODEL_VND_PARASOLID_TRANSMIT_TEXT = 'model/vnd.parasolid.transmit-text';
    public const MODEL_VND_ROSETTE_ANNOTATED_DATA_MODEL = 'model/vnd.rosette.annotated-data-model';
    public const MODEL_VND_VALVE_SOURCE_COMPILED_MAP = 'model/vnd.valve.source.compiled-map';
    public const MODEL_VND_VTU = 'model/vnd.vtu';
    public const MODEL_VRML = 'model/vrml';
    public const MODEL_X3D_FASTINFOSET = 'model/x3d+fastinfoset';
    public const MODEL_X3D_VRML = 'model/x3d-vrml';
    public const MODEL_X3D_XML = 'model/x3d+xml';
    public const MULTIPART_APPLEDOUBLE = 'multipart/appledouble';
    public const MULTIPART_BYTERANGES = 'multipart/byteranges';
    public const MULTIPART_ENCRYPTED = 'multipart/encrypted';
    public const MULTIPART_EXAMPLE = 'multipart/example';
    public const MULTIPART_FORM_DATA = 'multipart/form-data';
    public const MULTIPART_HEADER_SET = 'multipart/header-set';
    public const MULTIPART_RELATED = 'multipart/related';
    public const MULTIPART_REPORT = 'multipart/report';
    public const MULTIPART_SIGNED = 'multipart/signed';
    public const MULTIPART_VOICE_MESSAGE = 'multipart/voice-message';
    public const MULTIPART_X_MIXED_REPLACE = 'multipart/x-mixed-replace';
    public const TEXT_1D_INTERLEAVED_PARITYFEC = 'text/1d-interleaved-parityfec';
    public const TEXT_CACHE_MANIFEST = 'text/cache-manifest';
    public const TEXT_CALENDAR = 'text/calendar';
    public const TEXT_CSS = 'text/css';
    public const TEXT_CSV = 'text/csv';
    public const TEXT_CSV_SCHEMA = 'text/csv-schema';
    public const TEXT_DIRECTORY = 'text/directory';
    public const TEXT_DNS = 'text/dns';
    public const TEXT_ECMASCRIPT = 'text/ecmascript';
    public const TEXT_ENCAPRTP = 'text/encaprtp';
    public const TEXT_EXAMPLE = 'text/example';
    public const TEXT_FWDRED = 'text/fwdred';
    public const TEXT_GRAMMAR_REF_LIST = 'text/grammar-ref-list';
    public const TEXT_HTML = 'text/html';
    public const TEXT_JAVASCRIPT = 'text/javascript';
    public const TEXT_JCR_CND = 'text/jcr-cnd';
    public const TEXT_MARKDOWN = 'text/markdown';
    public const TEXT_MIZAR = 'text/mizar';
    public const TEXT_N3 = 'text/n3';
    public const TEXT_PARAMETERS = 'text/parameters';
    public const TEXT_PLAIN = 'text/plain';
    public const TEXT_PLAIN_BAS = 'text/plain-bas';
    public const TEXT_PROVENANCE_NOTATION = 'text/provenance-notation';
    public const TEXT_PRS_FALLENSTEIN_RST = 'text/prs.fallenstein.rst';
    public const TEXT_PRS_LINES_TAG = 'text/prs.lines.tag';
    public const TEXT_PRS_PROP_LOGIC = 'text/prs.prop.logic';
    public const TEXT_RAPTORFEC = 'text/raptorfec';
    public const TEXT_RED = 'text/RED';
    public const TEXT_RFC822_HEADERS = 'text/rfc822-headers';
    public const TEXT_RICHTEXT = 'text/richtext';
    public const TEXT_RTF = 'text/rtf';
    public const TEXT_RTP_ENC_AESCM128 = 'text/rtp-enc-aescm128';
    public const TEXT_RTPLOOPBACK = 'text/rtploopback';
    public const TEXT_RTX = 'text/rtx';
    public const TEXT_SGML = 'text/SGML';
    public const TEXT_T140 = 'text/t140';
    public const TEXT_TAB_SEPARATED_VALUES = 'text/tab-separated-values';
    public const TEXT_TROFF = 'text/troff';
    public const TEXT_TURTLE = 'text/turtle';
    public const TEXT_ULPFEC = 'text/ulpfec';
    public const TEXT_URI_LIST = 'text/uri-list';
    public const TEXT_VCARD = 'text/vcard';
    public const TEXT_VND_A = 'text/vnd-a';
    public const TEXT_VND_ABC = 'text/vnd.abc';
    public const TEXT_VND_ASCII_ART = 'text/vnd.ascii-art';
    public const TEXT_VND_CURL = 'text/vnd-curl';
    public const TEXT_VND_CURL_DCURL = 'text/vnd.curl.dcurl';
    public const TEXT_VND_CURL_MCURL = 'text/vnd.curl.mcurl';
    public const TEXT_VND_CURL_SCURL = 'text/vnd.curl.scurl';
    public const TEXT_VND_DEBIAN_COPYRIGHT = 'text/vnd.debian.copyright';
    public const TEXT_VND_DMCLIENTSCRIPT = 'text/vnd.DMClientScript';
    public const TEXT_VND_DVB_SUBTITLE = 'text/vnd.dvb.subtitle';
    public const TEXT_VND_ESMERTEC_THEME_DESCRIPTOR = 'text/vnd.esmertec.theme-descriptor';
    public const TEXT_VND_FLY = 'text/vnd.fly';
    public const TEXT_VND_FMI_FLEXSTOR = 'text/vnd.fmi.flexstor';
    public const TEXT_VND_GRAPHVIZ = 'text/vnd.graphviz';
    public const TEXT_VND_IN3D_3DML = 'text/vnd.in3d.3dml';
    public const TEXT_VND_IN3D_SPOT = 'text/vnd.in3d.spot';
    public const TEXT_VND_IPTC_NEWSML = 'text/vnd.IPTC.NewsML';
    public const TEXT_VND_IPTC_NITF = 'text/vnd.IPTC.NITF';
    public const TEXT_VND_LATEX_Z = 'text/vnd.latex-z';
    public const TEXT_VND_MOTOROLA_REFLEX = 'text/vnd.motorola.reflex';
    public const TEXT_VND_MS_MEDIAPACKAGE = 'text/vnd.ms-mediapackage';
    public const TEXT_VND_NET2PHONE_COMMCENTER_COMMAND = 'text/vnd.net2phone.commcenter.command';
    public const TEXT_VND_RADISYS_MSML_BASIC_LAYOUT = 'text/vnd.radisys.msml-basic-layout';
    public const TEXT_VND_SI_URICATALOGUE = 'text/vnd.si.uricatalogue';
    public const TEXT_VND_SUN_J2ME_APP_DESCRIPTOR = 'text/vnd.sun.j2me.app-descriptor';
    public const TEXT_VND_TROLLTECH_LINGUIST = 'text/vnd.trolltech.linguist';
    public const TEXT_VND_WAP_SI = 'text/vnd.wap.si';
    public const TEXT_VND_WAP_SL = 'text/vnd.wap.sl';
    public const TEXT_VND_WAP_WML = 'text/vnd.wap-wml';
    public const TEXT_VND_WAP_WMLSCRIPT = 'text/vnd.wap.wmlscript';
    public const TEXT_X_ASM = 'text/x-asm';
    public const TEXT_X_C = 'text/x-c';
    public const TEXT_X_FORTRAN = 'text/x-fortran';
    public const TEXT_X_JAVA_SOURCE_JAVA = 'text/x-java-source,java';
    public const TEXT_X_PASCAL = 'text/x-pascal';
    public const TEXT_X_SETEXT = 'text/x-setext';
    public const TEXT_X_UUENCODE = 'text/x-uuencode';
    public const TEXT_X_VCALENDAR = 'text/x-vcalendar';
    public const TEXT_X_VCARD = 'text/x-vcard';
    public const TEXT_XML = 'text/xml';
    public const TEXT_XML_EXTERNAL_PARSED_ENTITY = 'text/xml-external-parsed-entity';
    public const TEXT_YAML = 'text/yaml';
    public const VIDEO_1D_INTERLEAVED_PARITYFEC = 'video/1d-interleaved-parityfec';
    public const VIDEO_3GPP = 'video/3gpp';
    public const VIDEO_3GPP2 = 'video/3gpp2';
    public const VIDEO_3GPP_TT = 'video/3gpp-tt';
    public const VIDEO_BMPEG = 'video/BMPEG';
    public const VIDEO_BT656 = 'video/BT656';
    public const VIDEO_CELB = 'video/CelB';
    public const VIDEO_DV = 'video/DV';
    public const VIDEO_ENCAPRTP = 'video/encaprtp';
    public const VIDEO_EXAMPLE = 'video/example';
    public const VIDEO_H261 = 'video/H261';
    public const VIDEO_H263 = 'video/H263';
    public const VIDEO_H263_1998 = 'video/H263-1998';
    public const VIDEO_H263_2000 = 'video/H263-2000';
    public const VIDEO_H264 = 'video/H264';
    public const VIDEO_H264_RCDO = 'video/H264-RCDO';
    public const VIDEO_H264_SVC = 'video/H264-SVC';
    public const VIDEO_H265 = 'video/H265';
    public const VIDEO_ISO_SEGMENT = 'video/iso.segment';
    public const VIDEO_JPEG = 'video/JPEG';
    public const VIDEO_JPEG2000 = 'video/jpeg2000';
    public const VIDEO_JPM = 'video/jpm';
    public const VIDEO_MJ2 = 'video/mj2';
    public const VIDEO_MP1S = 'video/MP1S';
    public const VIDEO_MP2P = 'video/MP2P';
    public const VIDEO_MP2T = 'video/MP2T';
    public const VIDEO_MP4 = 'video/mp4';
    public const VIDEO_MP4V_ES = 'video/MP4V-ES';
    public const VIDEO_MPEG = 'video/mpeg';
    public const VIDEO_MPEG4_GENERIC = 'video/mpeg4-generic';
    public const VIDEO_MPV = 'video/MPV';
    public const VIDEO_NV = 'video/nv';
    public const VIDEO_OGG = 'video/ogg';
    public const VIDEO_POINTER = 'video/pointer';
    public const VIDEO_QUICKTIME = 'video/quicktime';
    public const VIDEO_RAPTORFEC = 'video/raptorfec';
    public const VIDEO_RTP_ENC_AESCM128 = 'video/rtp-enc-aescm128';
    public const VIDEO_RTPLOOPBACK = 'video/rtploopback';
    public const VIDEO_RTX = 'video/rtx';
    public const VIDEO_SMPTE292M = 'video/SMPTE292M';
    public const VIDEO_ULPFEC = 'video/ulpfec';
    public const VIDEO_VC1 = 'video/vc1';
    public const VIDEO_VND_CCTV = 'video/vnd.CCTV';
    public const VIDEO_VND_DECE_HD = 'video/vnd.dece.hd';
    public const VIDEO_VND_DECE_MOBILE = 'video/vnd.dece.mobile';
    public const VIDEO_VND_DECE_MP4 = 'video/vnd.dece-mp4';
    public const VIDEO_VND_DECE_PD = 'video/vnd.dece.pd';
    public const VIDEO_VND_DECE_SD = 'video/vnd.dece.sd';
    public const VIDEO_VND_DECE_VIDEO = 'video/vnd.dece.video';
    public const VIDEO_VND_DIRECTV_MPEG = 'video/vnd.directv-mpeg';
    public const VIDEO_VND_DIRECTV_MPEG_TTS = 'video/vnd.directv.mpeg-tts';
    public const VIDEO_VND_DLNA_MPEG_TTS = 'video/vnd.dlna.mpeg-tts';
    public const VIDEO_VND_DVB_FILE = 'video/vnd.dvb.file';
    public const VIDEO_VND_FVT = 'video/vnd.fvt';
    public const VIDEO_VND_HNS_VIDEO = 'video/vnd.hns.video';
    public const VIDEO_VND_IPTVFORUM_1DPARITYFEC_1010 = 'video/vnd.iptvforum.1dparityfec-1010';
    public const VIDEO_VND_IPTVFORUM_1DPARITYFEC_2005 = 'video/vnd.iptvforum.1dparityfec-2005';
    public const VIDEO_VND_IPTVFORUM_2DPARITYFEC_1010 = 'video/vnd.iptvforum.2dparityfec-1010';
    public const VIDEO_VND_IPTVFORUM_2DPARITYFEC_2005 = 'video/vnd.iptvforum.2dparityfec-2005';
    public const VIDEO_VND_IPTVFORUM_TTSAVC = 'video/vnd.iptvforum.ttsavc';
    public const VIDEO_VND_IPTVFORUM_TTSMPEG2 = 'video/vnd.iptvforum.ttsmpeg2';
    public const VIDEO_VND_MOTOROLA_VIDEO = 'video/vnd.motorola.video';
    public const VIDEO_VND_MOTOROLA_VIDEOP = 'video/vnd.motorola.videop';
    public const VIDEO_VND_MPEGURL = 'video/vnd-mpegurl';
    public const VIDEO_VND_MS_PLAYREADY_MEDIA_PYV = 'video/vnd.ms-playready.media.pyv';
    public const VIDEO_VND_NOKIA_INTERLEAVED_MULTIMEDIA = 'video/vnd.nokia.interleaved-multimedia';
    public const VIDEO_VND_NOKIA_VIDEOVOIP = 'video/vnd.nokia.videovoip';
    public const VIDEO_VND_OBJECTVIDEO = 'video/vnd.objectvideo';
    public const VIDEO_VND_RADGAMETTOOLS_BINK = 'video/vnd.radgamettools.bink';
    public const VIDEO_VND_RADGAMETTOOLS_SMACKER = 'video/vnd.radgamettools.smacker';
    public const VIDEO_VND_SEALED_MPEG1 = 'video/vnd.sealed.mpeg1';
    public const VIDEO_VND_SEALED_MPEG4 = 'video/vnd.sealed.mpeg4';
    public const VIDEO_VND_SEALED_SWF = 'video/vnd.sealed-swf';
    public const VIDEO_VND_SEALEDMEDIA_SOFTSEAL_MOV = 'video/vnd.sealedmedia.softseal-mov';
    public const VIDEO_VND_UVVU_MP4 = 'video/vnd.uvvu-mp4';
    public const VIDEO_VND_VIVO = 'video/vnd-vivo';
    public const VIDEO_VP8 = 'video/VP8';
    public const VIDEO_WEBM = 'video/webm';
    public const VIDEO_X_F4V = 'video/x-f4v';
    public const VIDEO_X_FLI = 'video/x-fli';
    public const VIDEO_X_FLV = 'video/x-flv';
    public const VIDEO_X_M4V = 'video/x-m4v';
    public const VIDEO_X_MS_ASF = 'video/x-ms-asf';
    public const VIDEO_X_MS_WM = 'video/x-ms-wm';
    public const VIDEO_X_MS_WMV = 'video/x-ms-wmv';
    public const VIDEO_X_MS_WMX = 'video/x-ms-wmx';
    public const VIDEO_X_MS_WVX = 'video/x-ms-wvx';
    public const VIDEO_X_MSVIDEO = 'video/x-msvideo';
    public const VIDEO_X_SGI_MOVIE = 'video/x-sgi-movie';
    public const X_CONFERENCE_X_COOLTALK = 'x-conference/x-cooltalk';

    /** @var string[] */
    private static $extensions = [
        '123' => self::APPLICATION_VND_LOTUS_1_2_3,
        '3dml' => self::TEXT_VND_IN3D_3DML,
        '3g2' => self::VIDEO_3GPP2,
        '3gp' => self::VIDEO_3GPP,
        '7z' => self::APPLICATION_X_7Z_COMPRESSED,
        'aab' => self::APPLICATION_X_AUTHORWARE_BIN,
        'aac' => self::AUDIO_X_AAC,
        'aam' => self::APPLICATION_X_AUTHORWARE_MAP,
        'aas' => self::APPLICATION_X_AUTHORWARE_SEG,
        'abw' => self::APPLICATION_X_ABIWORD,
        'ac' => self::APPLICATION_PKIX_ATTR_CERT,
        'acc' => self::APPLICATION_VND_AMERICANDYNAMICS_ACC,
        'ace' => self::APPLICATION_X_ACE_COMPRESSED,
        'acu' => self::APPLICATION_VND_ACUCOBOL,
        'adp' => self::AUDIO_ADPCM,
        'aep' => self::APPLICATION_VND_AUDIOGRAPH,
        'afa' => self::APPLICATION_X_ASTROTITE_AFA,
        'afp' => self::APPLICATION_VND_IBM_MODCAP,
        'ahead' => self::APPLICATION_VND_AHEAD_SPACE,
        'ai' => self::APPLICATION_POSTSCRIPT,
        'aif' => self::AUDIO_X_AIFF,
        'air' => self::APPLICATION_VND_ADOBE_AIR_APPLICATION_INSTALLER_PACKAGE_ZIP,
        'ait' => self::APPLICATION_VND_DVB_AIT,
        'alz' => self::APPLICATION_X_ALZ_COMPRESSED,
        'ami' => self::APPLICATION_VND_AMIGA_AMI,
        'apk' => self::APPLICATION_VND_ANDROID_PACKAGE_ARCHIVE,
        'application' => self::APPLICATION_X_MS_APPLICATION,
        'apr' => self::APPLICATION_VND_LOTUS_APPROACH,
        'arj' => self::APPLICATION_X_ARJ,
        'asf' => self::VIDEO_X_MS_ASF,
        'aso' => self::APPLICATION_VND_ACCPAC_SIMPLY_ASO,
        'atc' => self::APPLICATION_VND_ACUCORP,
        'atom' => self::APPLICATION_ATOM_XML,
        'atomcat' => self::APPLICATION_ATOMCAT_XML,
        'atomsvc' => self::APPLICATION_ATOMSVC_XML,
        'atx' => self::APPLICATION_VND_ANTIX_GAME_COMPONENT,
        'au' => self::AUDIO_BASIC,
        'avi' => self::VIDEO_X_MSVIDEO,
        'aw' => self::APPLICATION_APPLIXWARE,
        'azf' => self::APPLICATION_VND_AIRZIP_FILESECURE_AZF,
        'azs' => self::APPLICATION_VND_AIRZIP_FILESECURE_AZS,
        'azw' => self::APPLICATION_VND_AMAZON_EBOOK,
        'b1' => self::APPLICATION_X_B1,
        'bcpio' => self::APPLICATION_X_BCPIO,
        'bdf' => self::APPLICATION_X_FONT_BDF,
        'bdm' => self::APPLICATION_VND_SYNCML_DM_WBXML,
        'bed' => self::APPLICATION_VND_REALVNC_BED,
        'bh2' => self::APPLICATION_VND_FUJITSU_OASYSPRS,
        'bin' => self::APPLICATION_OCTET_STREAM,
        'bmi' => self::APPLICATION_VND_BMI,
        'bmp' => self::IMAGE_BMP,
        'box' => self::APPLICATION_VND_PREVIEWSYSTEMS_BOX,
        'btif' => self::IMAGE_PRS_BTIF,
        'bz' => self::APPLICATION_X_BZIP,
        'bz2' => self::APPLICATION_X_BZIP2,
        'c' => self::TEXT_X_C,
        'c11amc' => self::APPLICATION_VND_CLUETRUST_CARTOMOBILE_CONFIG,
        'c11amz' => self::APPLICATION_VND_CLUETRUST_CARTOMOBILE_CONFIG_PKG,
        'c4g' => self::APPLICATION_VND_CLONK_C4GROUP,
        'cab' => self::APPLICATION_VND_MS_CAB_COMPRESSED,
        'car' => self::APPLICATION_VND_CURL_CAR,
        'cat' => self::APPLICATION_VND_MS_PKI_SECCAT,
        'ccxml' => self::APPLICATION_CCXML_XML,
        'cdbcmsg' => self::APPLICATION_VND_CONTACT_CMSG,
        'cdkey' => self::APPLICATION_VND_MEDIASTATION_CDKEY,
        'cdmia' => self::APPLICATION_CDMI_CAPABILITY,
        'cdmic' => self::APPLICATION_CDMI_CONTAINER,
        'cdmid' => self::APPLICATION_CDMI_DOMAIN,
        'cdmio' => self::APPLICATION_CDMI_OBJECT,
        'cdmiq' => self::APPLICATION_CDMI_QUEUE,
        'cdx' => self::CHEMICAL_X_CDX,
        'cdxml' => self::APPLICATION_VND_CHEMDRAW_XML,
        'cdy' => self::APPLICATION_VND_CINDERELLA,
        'cer' => self::APPLICATION_PKIX_CERT,
        'cfs' => self::APPLICATION_X_CFS_COMPRESSED,
        'cgm' => self::IMAGE_CGM,
        'chat' => self::APPLICATION_X_CHAT,
        'chm' => self::APPLICATION_VND_MS_HTMLHELP,
        'chrt' => self::APPLICATION_VND_KDE_KCHART,
        'cif' => self::CHEMICAL_X_CIF,
        'cii' => self::APPLICATION_VND_ANSER_WEB_CERTIFICATE_ISSUE_INITIATION,
        'cil' => self::APPLICATION_VND_MS_ARTGALRY,
        'cla' => self::APPLICATION_VND_CLAYMORE,
        'class' => self::APPLICATION_JAVA_VM,
        'clkk' => self::APPLICATION_VND_CRICK_CLICKER_KEYBOARD,
        'clkp' => self::APPLICATION_VND_CRICK_CLICKER_PALETTE,
        'clkt' => self::APPLICATION_VND_CRICK_CLICKER_TEMPLATE,
        'clkw' => self::APPLICATION_VND_CRICK_CLICKER_WORDBANK,
        'clkx' => self::APPLICATION_VND_CRICK_CLICKER,
        'clp' => self::APPLICATION_X_MSCLIP,
        'cmc' => self::APPLICATION_VND_COSMOCALLER,
        'cmdf' => self::CHEMICAL_X_CMDF,
        'cml' => self::CHEMICAL_X_CML,
        'cmp' => self::APPLICATION_VND_YELLOWRIVER_CUSTOM_MENU,
        'cmx' => self::IMAGE_X_CMX,
        'cod' => self::APPLICATION_VND_RIM_COD,
        'cpio' => self::APPLICATION_X_CPIO,
        'cpt' => self::APPLICATION_MAC_COMPACTPRO,
        'crd' => self::APPLICATION_X_MSCARDFILE,
        'crl' => self::APPLICATION_PKIX_CRL,
        'cryptonote' => self::APPLICATION_VND_RIG_CRYPTONOTE,
        'csh' => self::APPLICATION_X_CSH,
        'csml' => self::CHEMICAL_X_CSML,
        'csp' => self::APPLICATION_VND_COMMONSPACE,
        'css' => self::TEXT_CSS,
        'csv' => self::TEXT_CSV,
        'cu' => self::APPLICATION_CU_SEEME,
        'curl' => self::TEXT_VND_CURL,
        'cww' => self::APPLICATION_PRS_CWW,
        'dae' => self::MODEL_VND_COLLADA_XML,
        'daf' => self::APPLICATION_VND_MOBIUS_DAF,
        'dar' => self::APPLICATION_X_DAR,
        'davmount' => self::APPLICATION_DAVMOUNT_XML,
        'dcurl' => self::TEXT_VND_CURL_DCURL,
        'dd2' => self::APPLICATION_VND_OMA_DD2_XML,
        'ddd' => self::APPLICATION_VND_FUJIXEROX_DDD,
        'deb' => self::APPLICATION_X_DEBIAN_PACKAGE,
        'der' => self::APPLICATION_X_X509_CA_CERT,
        'dfac' => self::APPLICATION_VND_DREAMFACTORY,
        'dgc' => self::APPLICATION_X_DGC_COMPRESSED,
        'dir' => self::APPLICATION_X_DIRECTOR,
        'dis' => self::APPLICATION_VND_MOBIUS_DIS,
        'djvu' => self::IMAGE_VND_DJVU,
        'dmg' => self::APPLICATION_X_APPLE_DISKIMAGE,
        'dna' => self::APPLICATION_VND_DNA,
        'doc' => self::APPLICATION_MSWORD,
        'docm' => self::APPLICATION_VND_MS_WORD_DOCUMENT_MACROENABLED_12,
        'docx' => self::APPLICATION_VND_OPENXMLFORMATS_OFFICEDOCUMENT_WORDPROCESSINGML_DOCUMENT,
        'dotm' => self::APPLICATION_VND_MS_WORD_TEMPLATE_MACROENABLED_12,
        'dotx' => self::APPLICATION_VND_OPENXMLFORMATS_OFFICEDOCUMENT_WORDPROCESSINGML_TEMPLATE,
        'dp' => self::APPLICATION_VND_OSGI_DP,
        'dpg' => self::APPLICATION_VND_DPGRAPH,
        'dra' => self::AUDIO_VND_DRA,
        'dsc' => self::TEXT_PRS_LINES_TAG,
        'dssc' => self::APPLICATION_DSSC_DER,
        'dtb' => self::APPLICATION_X_DTBOOK_XML,
        'dtd' => self::APPLICATION_XML_DTD,
        'dts' => self::AUDIO_VND_DTS,
        'dtshd' => self::AUDIO_VND_DTS_HD,
        'dvi' => self::APPLICATION_X_DVI,
        'dwf' => self::MODEL_VND_DWF,
        'dwg' => self::IMAGE_VND_DWG,
        'dxf' => self::IMAGE_VND_DXF,
        'dxp' => self::APPLICATION_VND_SPOTFIRE_DXP,
        'ecelp4800' => self::AUDIO_VND_NUERA_ECELP4800,
        'ecelp7470' => self::AUDIO_VND_NUERA_ECELP7470,
        'ecelp9600' => self::AUDIO_VND_NUERA_ECELP9600,
        'edm' => self::APPLICATION_VND_NOVADIGM_EDM,
        'edx' => self::APPLICATION_VND_NOVADIGM_EDX,
        'efif' => self::APPLICATION_VND_PICSEL,
        'ei6' => self::APPLICATION_VND_PG_OSASLI,
        'eml' => self::MESSAGE_RFC822,
        'emma' => self::APPLICATION_EMMA_XML,
        'eol' => self::AUDIO_VND_DIGITAL_WINDS,
        'eot' => self::APPLICATION_VND_MS_FONTOBJECT,
        'epub' => self::APPLICATION_EPUB_ZIP,
        'es' => self::APPLICATION_ECMASCRIPT,
        'es3' => self::APPLICATION_VND_ESZIGNO3_XML,
        'esf' => self::APPLICATION_VND_EPSON_ESF,
        'etx' => self::TEXT_X_SETEXT,
        'exe' => self::APPLICATION_X_MSDOWNLOAD,
        'exi' => self::APPLICATION_EXI,
        'ext' => self::APPLICATION_VND_NOVADIGM_EXT,
        'ez2' => self::APPLICATION_VND_EZPIX_ALBUM,
        'ez3' => self::APPLICATION_VND_EZPIX_PACKAGE,
        'f' => self::TEXT_X_FORTRAN,
        'f4v' => self::VIDEO_X_F4V,
        'fbs' => self::IMAGE_VND_FASTBIDSHEET,
        'fcs' => self::APPLICATION_VND_ISAC_FCS,
        'fdf' => self::APPLICATION_VND_FDF,
        'fe_launch' => self::APPLICATION_VND_DENOVO_FCSELAYOUT_LINK,
        'fg5' => self::APPLICATION_VND_FUJITSU_OASYSGP,
        'fh' => self::IMAGE_X_FREEHAND,
        'fig' => self::APPLICATION_X_XFIG,
        'fli' => self::VIDEO_X_FLI,
        'flo' => self::APPLICATION_VND_MICROGRAFX_FLO,
        'flv' => self::VIDEO_X_FLV,
        'flw' => self::APPLICATION_VND_KDE_KIVIO,
        'flx' => self::TEXT_VND_FMI_FLEXSTOR,
        'fly' => self::TEXT_VND_FLY,
        'fm' => self::APPLICATION_VND_FRAMEMAKER,
        'fnc' => self::APPLICATION_VND_FROGANS_FNC,
        'fpx' => self::IMAGE_VND_FPX,
        'fsc' => self::APPLICATION_VND_FSC_WEBLAUNCH,
        'fst' => self::IMAGE_VND_FST,
        'ftc' => self::APPLICATION_VND_FLUXTIME_CLIP,
        'fti' => self::APPLICATION_VND_ANSER_WEB_FUNDS_TRANSFER_INITIATION,
        'fvt' => self::VIDEO_VND_FVT,
        'fxp' => self::APPLICATION_VND_ADOBE_FXP,
        'fzs' => self::APPLICATION_VND_FUZZYSHEET,
        'g2w' => self::APPLICATION_VND_GEOPLAN,
        'g3' => self::IMAGE_G3FAX,
        'g3w' => self::APPLICATION_VND_GEOSPACE,
        'gac' => self::APPLICATION_VND_GROOVE_ACCOUNT,
        'gca' => self::APPLICATION_X_GCA_COMPRESSED,
        'gdl' => self::MODEL_VND_GDL,
        'geo' => self::APPLICATION_VND_DYNAGEO,
        'gex' => self::APPLICATION_VND_GEOMETRY_EXPLORER,
        'ggb' => self::APPLICATION_VND_GEOGEBRA_FILE,
        'ggt' => self::APPLICATION_VND_GEOGEBRA_TOOL,
        'ghf' => self::APPLICATION_VND_GROOVE_HELP,
        'gif' => self::IMAGE_GIF,
        'gim' => self::APPLICATION_VND_GROOVE_IDENTITY_MESSAGE,
        'gmx' => self::APPLICATION_VND_GMX,
        'gnumeric' => self::APPLICATION_X_GNUMERIC,
        'gph' => self::APPLICATION_VND_FLOGRAPHIT,
        'gqf' => self::APPLICATION_VND_GRAFEQ,
        'gram' => self::APPLICATION_SRGS,
        'grv' => self::APPLICATION_VND_GROOVE_INJECTOR,
        'grxml' => self::APPLICATION_SRGS_XML,
        'gsf' => self::APPLICATION_X_FONT_GHOSTSCRIPT,
        'gtar' => self::APPLICATION_X_GTAR,
        'gtm' => self::APPLICATION_VND_GROOVE_TOOL_MESSAGE,
        'gtw' => self::MODEL_VND_GTW,
        'gv' => self::TEXT_VND_GRAPHVIZ,
        'gxt' => self::APPLICATION_VND_GEONEXT,
        'h261' => self::VIDEO_H261,
        'h263' => self::VIDEO_H263,
        'h264' => self::VIDEO_H264,
        'hal' => self::APPLICATION_VND_HAL_XML,
        'hbci' => self::APPLICATION_VND_HBCI,
        'hdf' => self::APPLICATION_X_HDF,
        'hlp' => self::APPLICATION_WINHLP,
        'hpgl' => self::APPLICATION_VND_HP_HPGL,
        'hpid' => self::APPLICATION_VND_HP_HPID,
        'hps' => self::APPLICATION_VND_HP_HPS,
        'hqx' => self::APPLICATION_MAC_BINHEX40,
        'htke' => self::APPLICATION_VND_KENAMEAAPP,
        'html' => self::TEXT_HTML,
        'hvd' => self::APPLICATION_VND_YAMAHA_HV_DIC,
        'hvp' => self::APPLICATION_VND_YAMAHA_HV_VOICE,
        'hvs' => self::APPLICATION_VND_YAMAHA_HV_SCRIPT,
        'i2g' => self::APPLICATION_VND_INTERGEO,
        'icc' => self::APPLICATION_VND_ICCPROFILE,
        'ice' => self::X_CONFERENCE_X_COOLTALK,
        'ico' => self::IMAGE_X_ICON,
        'ics' => self::TEXT_CALENDAR,
        'ief' => self::IMAGE_IEF,
        'ifm' => self::APPLICATION_VND_SHANA_INFORMED_FORMDATA,
        'igl' => self::APPLICATION_VND_IGLOADER,
        'igm' => self::APPLICATION_VND_INSORS_IGM,
        'igs' => self::MODEL_IGES,
        'igx' => self::APPLICATION_VND_MICROGRAFX_IGX,
        'iif' => self::APPLICATION_VND_SHANA_INFORMED_INTERCHANGE,
        'imp' => self::APPLICATION_VND_ACCPAC_SIMPLY_IMP,
        'ims' => self::APPLICATION_VND_MS_IMS,
        'ipfix' => self::APPLICATION_IPFIX,
        'ipk' => self::APPLICATION_VND_SHANA_INFORMED_PACKAGE,
        'irm' => self::APPLICATION_VND_IBM_RIGHTS_MANAGEMENT,
        'irp' => self::APPLICATION_VND_IREPOSITORY_PACKAGE_XML,
        'itp' => self::APPLICATION_VND_SHANA_INFORMED_FORMTEMPLATE,
        'ivp' => self::APPLICATION_VND_IMMERVISION_IVP,
        'ivu' => self::APPLICATION_VND_IMMERVISION_IVU,
        'jad' => self::TEXT_VND_SUN_J2ME_APP_DESCRIPTOR,
        'jam' => self::APPLICATION_VND_JAM,
        'jar' => self::APPLICATION_JAVA_ARCHIVE,
        'java' => self::TEXT_X_JAVA_SOURCE_JAVA,
        'jisp' => self::APPLICATION_VND_JISP,
        'jlt' => self::APPLICATION_VND_HP_JLYT,
        'jnlp' => self::APPLICATION_X_JAVA_JNLP_FILE,
        'joda' => self::APPLICATION_VND_JOOST_JODA_ARCHIVE,
        'jpg' => self::IMAGE_JPEG,
        'jpeg' => self::IMAGE_JPEG,
        'jpgv' => self::VIDEO_JPEG,
        'jpm' => self::VIDEO_JPM,
        'js' => self::APPLICATION_JAVASCRIPT,
        'json' => self::APPLICATION_JSON,
        'karbon' => self::APPLICATION_VND_KDE_KARBON,
        'kfo' => self::APPLICATION_VND_KDE_KFORMULA,
        'kia' => self::APPLICATION_VND_KIDSPIRATION,
        'kml' => self::APPLICATION_VND_GOOGLE_EARTH_KML_XML,
        'kmz' => self::APPLICATION_VND_GOOGLE_EARTH_KMZ,
        'kne' => self::APPLICATION_VND_KINAR,
        'kon' => self::APPLICATION_VND_KDE_KONTOUR,
        'kpr' => self::APPLICATION_VND_KDE_KPRESENTER,
        'ksp' => self::APPLICATION_VND_KDE_KSPREAD,
        'ktx' => self::IMAGE_KTX,
        'ktz' => self::APPLICATION_VND_KAHOOTZ,
        'kwd' => self::APPLICATION_VND_KDE_KWORD,
        'lasxml' => self::APPLICATION_VND_LAS_LAS_XML,
        'latex' => self::APPLICATION_X_LATEX,
        'lbd' => self::APPLICATION_VND_LLAMAGRAPHICS_LIFE_BALANCE_DESKTOP,
        'lbe' => self::APPLICATION_VND_LLAMAGRAPHICS_LIFE_BALANCE_EXCHANGE_XML,
        'les' => self::APPLICATION_VND_HHE_LESSON_PLAYER,
        'link66' => self::APPLICATION_VND_ROUTE66_LINK66_XML,
        'lrm' => self::APPLICATION_VND_MS_LRM,
        'ltf' => self::APPLICATION_VND_FROGANS_LTF,
        'lvp' => self::AUDIO_VND_LUCENT_VOICE,
        'lwp' => self::APPLICATION_VND_LOTUS_WORDPRO,
        'lz' => self::APPLICATION_X_LZIP,
        'lzh' => self::APPLICATION_X_LZH,
        'lzma' => self::APPLICATION_X_LZMA,
        'lzo' => self::APPLICATION_X_LZOP,
        'lzx' => self::APPLICATION_X_LZX,
        'm21' => self::APPLICATION_MP21,
        'm3u' => self::AUDIO_X_MPEGURL,
        'm3u8' => self::APPLICATION_VND_APPLE_MPEGURL,
        'm4v' => self::VIDEO_X_M4V,
        'ma' => self::APPLICATION_MATHEMATICA,
        'mads' => self::APPLICATION_MADS_XML,
        'mag' => self::APPLICATION_VND_ECOWIN_CHART,
        'mathml' => self::APPLICATION_MATHML_XML,
        'mbk' => self::APPLICATION_VND_MOBIUS_MBK,
        'mbox' => self::APPLICATION_MBOX,
        'mc1' => self::APPLICATION_VND_MEDCALCDATA,
        'mcd' => self::APPLICATION_VND_MCD,
        'mcurl' => self::TEXT_VND_CURL_MCURL,
        'mdb' => self::APPLICATION_X_MSACCESS,
        'mdi' => self::IMAGE_VND_MS_MODI,
        'meta4' => self::APPLICATION_METALINK4_XML,
        'mets' => self::APPLICATION_METS_XML,
        'mfm' => self::APPLICATION_VND_MFMP,
        'mgp' => self::APPLICATION_VND_OSGEO_MAPGUIDE_PACKAGE,
        'mgz' => self::APPLICATION_VND_PROTEUS_MAGAZINE,
        'mid' => self::AUDIO_MIDI,
        'mif' => self::APPLICATION_VND_MIF,
        'mj2' => self::VIDEO_MJ2,
        'mlp' => self::APPLICATION_VND_DOLBY_MLP,
        'mmd' => self::APPLICATION_VND_CHIPNUTS_KARAOKE_MMD,
        'mmf' => self::APPLICATION_VND_SMAF,
        'mmr' => self::IMAGE_VND_FUJIXEROX_EDMICS_MMR,
        'mny' => self::APPLICATION_X_MSMONEY,
        'mods' => self::APPLICATION_MODS_XML,
        'movie' => self::VIDEO_X_SGI_MOVIE,
        'mp4' => self::VIDEO_MP4,
        'mp4a' => self::AUDIO_MP4,
        'mpc' => self::APPLICATION_VND_MOPHUN_CERTIFICATE,
        'mpeg' => self::VIDEO_MPEG,
        'mpga' => self::AUDIO_MPEG,
        'mpkg' => self::APPLICATION_VND_APPLE_INSTALLER_XML,
        'mpm' => self::APPLICATION_VND_BLUEICE_MULTIPASS,
        'mpn' => self::APPLICATION_VND_MOPHUN_APPLICATION,
        'mpp' => self::APPLICATION_VND_MS_PROJECT,
        'mpy' => self::APPLICATION_VND_IBM_MINIPAY,
        'mqy' => self::APPLICATION_VND_MOBIUS_MQY,
        'mrc' => self::APPLICATION_MARC,
        'mrcx' => self::APPLICATION_MARCXML_XML,
        'mscml' => self::APPLICATION_MEDIASERVERCONTROL_XML,
        'mseq' => self::APPLICATION_VND_MSEQ,
        'msf' => self::APPLICATION_VND_EPSON_MSF,
        'msh' => self::MODEL_MESH,
        'msl' => self::APPLICATION_VND_MOBIUS_MSL,
        'msty' => self::APPLICATION_VND_MUVEE_STYLE,
        'mts' => self::MODEL_VND_MTS,
        'mus' => self::APPLICATION_VND_MUSICIAN,
        'musicxml' => self::APPLICATION_VND_RECORDARE_MUSICXML_XML,
        'mvb' => self::APPLICATION_X_MSMEDIAVIEW,
        'mwf' => self::APPLICATION_VND_MFER,
        'mxf' => self::APPLICATION_MXF,
        'mxl' => self::APPLICATION_VND_RECORDARE_MUSICXML,
        'mxml' => self::APPLICATION_XV_XML,
        'mxs' => self::APPLICATION_VND_TRISCAPE_MXS,
        'mxu' => self::VIDEO_VND_MPEGURL,
        'n3' => self::TEXT_N3,
        'n_gage' => self::APPLICATION_VND_NOKIA_N_GAGE_SYMBIAN_INSTALL,
        'nbp' => self::APPLICATION_VND_WOLFRAM_PLAYER,
        'nc' => self::APPLICATION_X_NETCDF,
        'ncx' => self::APPLICATION_X_DTBNCX_XML,
        'ngdat' => self::APPLICATION_VND_NOKIA_N_GAGE_DATA,
        'nlu' => self::APPLICATION_VND_NEUROLANGUAGE_NLU,
        'nml' => self::APPLICATION_VND_ENLIVEN,
        'nnd' => self::APPLICATION_VND_NOBLENET_DIRECTORY,
        'nns' => self::APPLICATION_VND_NOBLENET_SEALER,
        'nnw' => self::APPLICATION_VND_NOBLENET_WEB,
        'npx' => self::IMAGE_VND_NET_FPX,
        'nsf' => self::APPLICATION_VND_LOTUS_NOTES,
        'oa2' => self::APPLICATION_VND_FUJITSU_OASYS2,
        'oa3' => self::APPLICATION_VND_FUJITSU_OASYS3,
        'oas' => self::APPLICATION_VND_FUJITSU_OASYS,
        'obd' => self::APPLICATION_X_MSBINDER,
        'oda' => self::APPLICATION_ODA,
        'odb' => self::APPLICATION_VND_OASIS_OPENDOCUMENT_DATABASE,
        'odc' => self::APPLICATION_VND_OASIS_OPENDOCUMENT_CHART,
        'odf' => self::APPLICATION_VND_OASIS_OPENDOCUMENT_FORMULA,
        'odft' => self::APPLICATION_VND_OASIS_OPENDOCUMENT_FORMULA_TEMPLATE,
        'odg' => self::APPLICATION_VND_OASIS_OPENDOCUMENT_GRAPHICS,
        'odi' => self::APPLICATION_VND_OASIS_OPENDOCUMENT_IMAGE,
        'odm' => self::APPLICATION_VND_OASIS_OPENDOCUMENT_TEXT_MASTER,
        'odp' => self::APPLICATION_VND_OASIS_OPENDOCUMENT_PRESENTATION,
        'ods' => self::APPLICATION_VND_OASIS_OPENDOCUMENT_SPREADSHEET,
        'odt' => self::APPLICATION_VND_OASIS_OPENDOCUMENT_TEXT,
        'oga' => self::AUDIO_OGG,
        'ogv' => self::VIDEO_OGG,
        'ogx' => self::APPLICATION_OGG,
        'onetoc' => self::APPLICATION_ONENOTE,
        'opf' => self::APPLICATION_OEBPS_PACKAGE_XML,
        'org' => self::APPLICATION_VND_LOTUS_ORGANIZER,
        'osf' => self::APPLICATION_VND_YAMAHA_OPENSCOREFORMAT,
        'osfpvg' => self::APPLICATION_VND_YAMAHA_OPENSCOREFORMAT_OSFPVG_XML,
        'otc' => self::APPLICATION_VND_OASIS_OPENDOCUMENT_CHART_TEMPLATE,
        'otf' => self::APPLICATION_X_FONT_OTF,
        'otg' => self::APPLICATION_VND_OASIS_OPENDOCUMENT_GRAPHICS_TEMPLATE,
        'oth' => self::APPLICATION_VND_OASIS_OPENDOCUMENT_TEXT_WEB,
        'oti' => self::APPLICATION_VND_OASIS_OPENDOCUMENT_IMAGE_TEMPLATE,
        'otp' => self::APPLICATION_VND_OASIS_OPENDOCUMENT_PRESENTATION_TEMPLATE,
        'ots' => self::APPLICATION_VND_OASIS_OPENDOCUMENT_SPREADSHEET_TEMPLATE,
        'ott' => self::APPLICATION_VND_OASIS_OPENDOCUMENT_TEXT_TEMPLATE,
        'oxt' => self::APPLICATION_VND_OPENOFFICEORG_EXTENSION,
        'p' => self::TEXT_X_PASCAL,
        'p10' => self::APPLICATION_PKCS10,
        'p12' => self::APPLICATION_X_PKCS12,
        'p7b' => self::APPLICATION_X_PKCS7_CERTIFICATES,
        'p7m' => self::APPLICATION_PKCS7_MIME,
        'p7r' => self::APPLICATION_X_PKCS7_CERTREQRESP,
        'p7s' => self::APPLICATION_PKCS7_SIGNATURE,
        'p8' => self::APPLICATION_PKCS8,
        'par' => self::TEXT_PLAIN_BAS,
        'paw' => self::APPLICATION_VND_PAWAAFILE,
        'pbd' => self::APPLICATION_VND_POWERBUILDER6,
        'pbm' => self::IMAGE_X_PORTABLE_BITMAP,
        'pcf' => self::APPLICATION_X_FONT_PCF,
        'pcl' => self::APPLICATION_VND_HP_PCL,
        'pclxl' => self::APPLICATION_VND_HP_PCLXL,
        'pcurl' => self::APPLICATION_VND_CURL_PCURL,
        'pcx' => self::IMAGE_X_PCX,
        'pdb' => self::APPLICATION_VND_PALM,
        'pdf' => self::APPLICATION_PDF,
        'pfa' => self::APPLICATION_X_FONT_TYPE1,
        'pfr' => self::APPLICATION_FONT_TDPFR,
        'pgm' => self::IMAGE_X_PORTABLE_GRAYMAP,
        'pgn' => self::APPLICATION_X_CHESS_PGN,
        'pgp' => self::APPLICATION_PGP_SIGNATURE,
        'pic' => self::IMAGE_X_PICT,
        'pjpeg' => self::IMAGE_PJPEG,
        'pki' => self::APPLICATION_PKIXCMP,
        'pkipath' => self::APPLICATION_PKIX_PKIPATH,
        'plb' => self::APPLICATION_VND_3GPP_PIC_BW_LARGE,
        'plc' => self::APPLICATION_VND_MOBIUS_PLC,
        'plf' => self::APPLICATION_VND_POCKETLEARN,
        'pls' => self::APPLICATION_PLS_XML,
        'pml' => self::APPLICATION_VND_CTC_POSML,
        'png' => self::IMAGE_PNG,
        'pnm' => self::IMAGE_X_PORTABLE_ANYMAP,
        'portpkg' => self::APPLICATION_VND_MACPORTS_PORTPKG,
        'potm' => self::APPLICATION_VND_MS_POWERPOINT_TEMPLATE_MACROENABLED_12,
        'potx' => self::APPLICATION_VND_OPENXMLFORMATS_OFFICEDOCUMENT_PRESENTATIONML_TEMPLATE,
        'ppam' => self::APPLICATION_VND_MS_POWERPOINT_ADDIN_MACROENABLED_12,
        'ppd' => self::APPLICATION_VND_CUPS_PPD,
        'ppm' => self::IMAGE_X_PORTABLE_PIXMAP,
        'ppsm' => self::APPLICATION_VND_MS_POWERPOINT_SLIDESHOW_MACROENABLED_12,
        'ppsx' => self::APPLICATION_VND_OPENXMLFORMATS_OFFICEDOCUMENT_PRESENTATIONML_SLIDESHOW,
        'ppt' => self::APPLICATION_VND_MS_POWERPOINT,
        'pptm' => self::APPLICATION_VND_MS_POWERPOINT_PRESENTATION_MACROENABLED_12,
        'pptx' => self::APPLICATION_VND_OPENXMLFORMATS_OFFICEDOCUMENT_PRESENTATIONML_PRESENTATION,
        'prc' => self::APPLICATION_X_MOBIPOCKET_EBOOK,
        'pre' => self::APPLICATION_VND_LOTUS_FREELANCE,
        'prf' => self::APPLICATION_PICS_RULES,
        'psb' => self::APPLICATION_VND_3GPP_PIC_BW_SMALL,
        'psd' => self::IMAGE_VND_ADOBE_PHOTOSHOP,
        'psf' => self::APPLICATION_X_FONT_LINUX_PSF,
        'pskcxml' => self::APPLICATION_PSKC_XML,
        'ptid' => self::APPLICATION_VND_PVI_PTID1,
        'pub' => self::APPLICATION_X_MSPUBLISHER,
        'pvb' => self::APPLICATION_VND_3GPP_PIC_BW_VAR,
        'pwn' => self::APPLICATION_VND_3M_POST_IT_NOTES,
        'pya' => self::AUDIO_VND_MS_PLAYREADY_MEDIA_PYA,
        'pyv' => self::VIDEO_VND_MS_PLAYREADY_MEDIA_PYV,
        'qam' => self::APPLICATION_VND_EPSON_QUICKANIME,
        'qbo' => self::APPLICATION_VND_INTU_QBO,
        'qfx' => self::APPLICATION_VND_INTU_QFX,
        'qps' => self::APPLICATION_VND_PUBLISHARE_DELTA_TREE,
        'qt' => self::VIDEO_QUICKTIME,
        'qxd' => self::APPLICATION_VND_QUARK_QUARKXPRESS,
        'ram' => self::AUDIO_X_PN_REALAUDIO,
        'rar' => self::APPLICATION_X_RAR_COMPRESSED,
        'ras' => self::IMAGE_X_CMU_RASTER,
        'rcprofile' => self::APPLICATION_VND_IPUNPLUGGED_RCPROFILE,
        'rdf' => self::APPLICATION_RDF_XML,
        'rdz' => self::APPLICATION_VND_DATA_VISION_RDZ,
        'rep' => self::APPLICATION_VND_BUSINESSOBJECTS,
        'res' => self::APPLICATION_X_DTBRESOURCE_XML,
        'rgb' => self::IMAGE_X_RGB,
        'rif' => self::APPLICATION_REGINFO_XML,
        'rip' => self::AUDIO_VND_RIP,
        'rl' => self::APPLICATION_RESOURCE_LISTS_XML,
        'rlc' => self::IMAGE_VND_FUJIXEROX_EDMICS_RLC,
        'rld' => self::APPLICATION_RESOURCE_LISTS_DIFF_XML,
        'rm' => self::APPLICATION_VND_RN_REALMEDIA,
        'rmp' => self::AUDIO_X_PN_REALAUDIO_PLUGIN,
        'rms' => self::APPLICATION_VND_JCP_JAVAME_MIDLET_RMS,
        'rnc' => self::APPLICATION_RELAX_NG_COMPACT_SYNTAX,
        'rp9' => self::APPLICATION_VND_CLOANTO_RP9,
        'rpss' => self::APPLICATION_VND_NOKIA_RADIO_PRESETS,
        'rpst' => self::APPLICATION_VND_NOKIA_RADIO_PRESET,
        'rq' => self::APPLICATION_SPARQL_QUERY,
        'rs' => self::APPLICATION_RLS_SERVICES_XML,
        'rsd' => self::APPLICATION_RSD_XML,
        'rss' => self::APPLICATION_RSS_XML,
        'rtf' => self::APPLICATION_RTF,
        'rtx' => self::TEXT_RICHTEXT,
        's' => self::TEXT_X_ASM,
        'saf' => self::APPLICATION_VND_YAMAHA_SMAF_AUDIO,
        'sbml' => self::APPLICATION_SBML_XML,
        'sc' => self::APPLICATION_VND_IBM_SECURE_CONTAINER,
        'scd' => self::APPLICATION_X_MSSCHEDULE,
        'scm' => self::APPLICATION_VND_LOTUS_SCREENCAM,
        'scq' => self::APPLICATION_SCVP_CV_REQUEST,
        'scs' => self::APPLICATION_SCVP_CV_RESPONSE,
        'scurl' => self::TEXT_VND_CURL_SCURL,
        'sda' => self::APPLICATION_VND_STARDIVISION_DRAW,
        'sdc' => self::APPLICATION_VND_STARDIVISION_CALC,
        'sdd' => self::APPLICATION_VND_STARDIVISION_IMPRESS,
        'sdkm' => self::APPLICATION_VND_SOLENT_SDKM_XML,
        'sdp' => self::APPLICATION_SDP,
        'sdw' => self::APPLICATION_VND_STARDIVISION_WRITER,
        'see' => self::APPLICATION_VND_SEEMAIL,
        'seed' => self::APPLICATION_VND_FDSN_SEED,
        'sema' => self::APPLICATION_VND_SEMA,
        'semd' => self::APPLICATION_VND_SEMD,
        'semf' => self::APPLICATION_VND_SEMF,
        'ser' => self::APPLICATION_JAVA_SERIALIZED_OBJECT,
        'setpay' => self::APPLICATION_SET_PAYMENT_INITIATION,
        'setreg' => self::APPLICATION_SET_REGISTRATION_INITIATION,
        'sfd_hdstx' => self::APPLICATION_VND_HYDROSTATIX_SOF_DATA,
        'sfs' => self::APPLICATION_VND_SPOTFIRE_SFS,
        'sgl' => self::APPLICATION_VND_STARDIVISION_WRITER_GLOBAL,
        'sgml' => self::TEXT_SGML,
        'sh' => self::APPLICATION_X_SH,
        'shar' => self::APPLICATION_X_SHAR,
        'shf' => self::APPLICATION_SHF_XML,
        'sis' => self::APPLICATION_VND_SYMBIAN_INSTALL,
        'sit' => self::APPLICATION_X_STUFFIT,
        'sitx' => self::APPLICATION_X_STUFFITX,
        'skp' => self::APPLICATION_VND_KOAN,
        'sldm' => self::APPLICATION_VND_MS_POWERPOINT_SLIDE_MACROENABLED_12,
        'sldx' => self::APPLICATION_VND_OPENXMLFORMATS_OFFICEDOCUMENT_PRESENTATIONML_SLIDE,
        'slt' => self::APPLICATION_VND_EPSON_SALT,
        'sm' => self::APPLICATION_VND_STEPMANIA_STEPCHART,
        'smf' => self::APPLICATION_VND_STARDIVISION_MATH,
        'smi' => self::APPLICATION_SMIL_XML,
        'snf' => self::APPLICATION_X_FONT_SNF,
        'spf' => self::APPLICATION_VND_YAMAHA_SMAF_PHRASE,
        'spl' => self::APPLICATION_X_FUTURESPLASH,
        'spot' => self::TEXT_VND_IN3D_SPOT,
        'spp' => self::APPLICATION_SCVP_VP_RESPONSE,
        'spq' => self::APPLICATION_SCVP_VP_REQUEST,
        'src' => self::APPLICATION_X_WAIS_SOURCE,
        'sru' => self::APPLICATION_SRU_XML,
        'srx' => self::APPLICATION_SPARQL_RESULTS_XML,
        'sse' => self::APPLICATION_VND_KODAK_DESCRIPTOR,
        'ssf' => self::APPLICATION_VND_EPSON_SSF,
        'ssml' => self::APPLICATION_SSML_XML,
        'st' => self::APPLICATION_VND_SAILINGTRACKER_TRACK,
        'stc' => self::APPLICATION_VND_SUN_XML_CALC_TEMPLATE,
        'std' => self::APPLICATION_VND_SUN_XML_DRAW_TEMPLATE,
        'stf' => self::APPLICATION_VND_WT_STF,
        'sti' => self::APPLICATION_VND_SUN_XML_IMPRESS_TEMPLATE,
        'stk' => self::APPLICATION_HYPERSTUDIO,
        'stl' => self::APPLICATION_VND_MS_PKI_STL,
        'str' => self::APPLICATION_VND_PG_FORMAT,
        'stw' => self::APPLICATION_VND_SUN_XML_WRITER_TEMPLATE,
        'sub' => self::IMAGE_VND_DVB_SUBTITLE,
        'sus' => self::APPLICATION_VND_SUS_CALENDAR,
        'sv4cpio' => self::APPLICATION_X_SV4CPIO,
        'sv4crc' => self::APPLICATION_X_SV4CRC,
        'svc' => self::APPLICATION_VND_DVB_SERVICE,
        'svd' => self::APPLICATION_VND_SVD,
        'svg' => self::IMAGE_SVG_XML,
        'swf' => self::APPLICATION_X_SHOCKWAVE_FLASH,
        'swi' => self::APPLICATION_VND_ARISTANETWORKS_SWI,
        'sxc' => self::APPLICATION_VND_SUN_XML_CALC,
        'sxd' => self::APPLICATION_VND_SUN_XML_DRAW,
        'sxg' => self::APPLICATION_VND_SUN_XML_WRITER_GLOBAL,
        'sxi' => self::APPLICATION_VND_SUN_XML_IMPRESS,
        'sxm' => self::APPLICATION_VND_SUN_XML_MATH,
        'sxw' => self::APPLICATION_VND_SUN_XML_WRITER,
        'sz' => self::APPLICATION_X_SNAPPY_FRAMED,
        't' => self::TEXT_TROFF,
        'tao' => self::APPLICATION_VND_TAO_INTENT_MODULE_ARCHIVE,
        'tar' => self::APPLICATION_X_TAR,
        'tcap' => self::APPLICATION_VND_3GPP2_TCAP,
        'tcl' => self::APPLICATION_X_TCL,
        'teacher' => self::APPLICATION_VND_SMART_TEACHER,
        'tei' => self::APPLICATION_TEI_XML,
        'tex' => self::APPLICATION_X_TEX,
        'texinfo' => self::APPLICATION_X_TEXINFO,
        'tfi' => self::APPLICATION_THRAUD_XML,
        'tfm' => self::APPLICATION_X_TEX_TFM,
        'thmx' => self::APPLICATION_VND_MS_OFFICETHEME,
        'tiff' => self::IMAGE_TIFF,
        'tmo' => self::APPLICATION_VND_TMOBILE_LIVETV,
        'torrent' => self::APPLICATION_X_BITTORRENT,
        'tpl' => self::APPLICATION_VND_GROOVE_TOOL_TEMPLATE,
        'tpt' => self::APPLICATION_VND_TRID_TPT,
        'tra' => self::APPLICATION_VND_TRUEAPP,
        'trm' => self::APPLICATION_X_MSTERMINAL,
        'tsd' => self::APPLICATION_TIMESTAMPED_DATA,
        'tsv' => self::TEXT_TAB_SEPARATED_VALUES,
        'ttf' => self::APPLICATION_X_FONT_TTF,
        'ttl' => self::TEXT_TURTLE,
        'twd' => self::APPLICATION_VND_SIMTECH_MINDMAPPER,
        'txd' => self::APPLICATION_VND_GENOMATIX_TUXEDO,
        'txf' => self::APPLICATION_VND_MOBIUS_TXF,
        'txt' => self::TEXT_PLAIN,
        'ufd' => self::APPLICATION_VND_UFDL,
        'umj' => self::APPLICATION_VND_UMAJIN,
        'unityweb' => self::APPLICATION_VND_UNITY,
        'uoml' => self::APPLICATION_VND_UOML_XML,
        'uri' => self::TEXT_URI_LIST,
        'ustar' => self::APPLICATION_X_USTAR,
        'utz' => self::APPLICATION_VND_UIQ_THEME,
        'uu' => self::TEXT_X_UUENCODE,
        'uva' => self::AUDIO_VND_DECE_AUDIO,
        'uvh' => self::VIDEO_VND_DECE_HD,
        'uvi' => self::IMAGE_VND_DECE_GRAPHIC,
        'uvm' => self::VIDEO_VND_DECE_MOBILE,
        'uvp' => self::VIDEO_VND_DECE_PD,
        'uvs' => self::VIDEO_VND_DECE_SD,
        'uvu' => self::VIDEO_VND_UVVU_MP4,
        'uvv' => self::VIDEO_VND_DECE_VIDEO,
        'vcd' => self::APPLICATION_X_CDLINK,
        'vcf' => self::TEXT_X_VCARD,
        'vcg' => self::APPLICATION_VND_GROOVE_VCARD,
        'vcs' => self::TEXT_X_VCALENDAR,
        'vcx' => self::APPLICATION_VND_VCX,
        'vis' => self::APPLICATION_VND_VISIONARY,
        'viv' => self::VIDEO_VND_VIVO,
        'vsd' => self::APPLICATION_VND_VISIO,
        'vsdx' => self::APPLICATION_VND_VISIO2013,
        'vsf' => self::APPLICATION_VND_VSF,
        'vtu' => self::MODEL_VND_VTU,
        'vxml' => self::APPLICATION_VOICEXML_XML,
        'wad' => self::APPLICATION_X_DOOM,
        'wav' => self::AUDIO_X_WAV,
        'wax' => self::AUDIO_X_MS_WAX,
        'wbmp' => self::IMAGE_VND_WAP_WBMP,
        'wbs' => self::APPLICATION_VND_CRITICALTOOLS_WBS_XML,
        'wbxml' => self::APPLICATION_VND_WAP_WBXML,
        'weba' => self::AUDIO_WEBM,
        'webm' => self::VIDEO_WEBM,
        'webp' => self::IMAGE_WEBP,
        'wg' => self::APPLICATION_VND_PMI_WIDGET,
        'wgt' => self::APPLICATION_WIDGET,
        'wm' => self::VIDEO_X_MS_WM,
        'wma' => self::AUDIO_X_MS_WMA,
        'wmd' => self::APPLICATION_X_MS_WMD,
        'wmf' => self::APPLICATION_X_MSMETAFILE,
        'wml' => self::TEXT_VND_WAP_WML,
        'wmlc' => self::APPLICATION_VND_WAP_WMLC,
        'wmls' => self::TEXT_VND_WAP_WMLSCRIPT,
        'wmlsc' => self::APPLICATION_VND_WAP_WMLSCRIPTC,
        'wmv' => self::VIDEO_X_MS_WMV,
        'wmx' => self::VIDEO_X_MS_WMX,
        'wmz' => self::APPLICATION_X_MS_WMZ,
        'woff' => self::APPLICATION_X_FONT_WOFF,
        'wpd' => self::APPLICATION_VND_WORDPERFECT,
        'wpl' => self::APPLICATION_VND_MS_WPL,
        'wps' => self::APPLICATION_VND_MS_WORKS,
        'wqd' => self::APPLICATION_VND_WQD,
        'wri' => self::APPLICATION_X_MSWRITE,
        'wrl' => self::MODEL_VRML,
        'wsdl' => self::APPLICATION_WSDL_XML,
        'wspolicy' => self::APPLICATION_WSPOLICY_XML,
        'wtb' => self::APPLICATION_VND_WEBTURBO,
        'wvx' => self::VIDEO_X_MS_WVX,
        'x3d' => self::APPLICATION_VND_HZN_3D_CROSSWORD,
        'xap' => self::APPLICATION_X_SILVERLIGHT_APP,
        'xar' => self::APPLICATION_VND_XARA,
        'xbap' => self::APPLICATION_X_MS_XBAP,
        'xbd' => self::APPLICATION_VND_FUJIXEROX_DOCUWORKS_BINDER,
        'xbm' => self::IMAGE_X_XBITMAP,
        'xdf' => self::APPLICATION_XCAP_DIFF_XML,
        'xdm' => self::APPLICATION_VND_SYNCML_DM_XML,
        'xdp' => self::APPLICATION_VND_ADOBE_XDP_XML,
        'xdssc' => self::APPLICATION_DSSC_XML,
        'xdw' => self::APPLICATION_VND_FUJIXEROX_DOCUWORKS,
        'xenc' => self::APPLICATION_XENC_XML,
        'xer' => self::APPLICATION_PATCH_OPS_ERROR_XML,
        'xfdf' => self::APPLICATION_VND_ADOBE_XFDF,
        'xfdl' => self::APPLICATION_VND_XFDL,
        'xhtml' => self::APPLICATION_XHTML_XML,
        'xif' => self::IMAGE_VND_XIFF,
        'xlam' => self::APPLICATION_VND_MS_EXCEL_ADDIN_MACROENABLED_12,
        'xls' => self::APPLICATION_VND_MS_EXCEL,
        'xlsb' => self::APPLICATION_VND_MS_EXCEL_SHEET_BINARY_MACROENABLED_12,
        'xlsm' => self::APPLICATION_VND_MS_EXCEL_SHEET_MACROENABLED_12,
        'xlsx' => self::APPLICATION_VND_OPENXMLFORMATS_OFFICEDOCUMENT_SPREADSHEETML_SHEET,
        'xltm' => self::APPLICATION_VND_MS_EXCEL_TEMPLATE_MACROENABLED_12,
        'xltx' => self::APPLICATION_VND_OPENXMLFORMATS_OFFICEDOCUMENT_SPREADSHEETML_TEMPLATE,
        'xml' => self::APPLICATION_XML,
        'xo' => self::APPLICATION_VND_OLPC_SUGAR,
        'xop' => self::APPLICATION_XOP_XML,
        'xpi' => self::APPLICATION_X_XPINSTALL,
        'xpm' => self::IMAGE_X_XPIXMAP,
        'xpr' => self::APPLICATION_VND_IS_XPR,
        'xps' => self::APPLICATION_VND_MS_XPSDOCUMENT,
        'xpw' => self::APPLICATION_VND_INTERCON_FORMNET,
        'xslt' => self::APPLICATION_XSLT_XML,
        'xsm' => self::APPLICATION_VND_SYNCML_XML,
        'xspf' => self::APPLICATION_XSPF_XML,
        'xul' => self::APPLICATION_VND_MOZILLA_XUL_XML,
        'xwd' => self::IMAGE_X_XWINDOWDUMP,
        'xyz' => self::CHEMICAL_X_XYZ,
        'xz' => self::APPLICATION_X_XZ,
        'yaml' => self::TEXT_YAML,
        'yang' => self::APPLICATION_YANG,
        'yin' => self::APPLICATION_YIN_XML,
        'z' => self::APPLICATION_X_COMPRESS,
        'zaz' => self::APPLICATION_VND_ZZAZZ_DECK_XML,
        'zip' => self::APPLICATION_ZIP,
        'zir' => self::APPLICATION_VND_ZUL,
        'zmm' => self::APPLICATION_VND_HANDHELD_ENTERTAINMENT_XML,
        'zoo' => self::APPLICATION_X_ZOO,
    ];

    /** @var bool[] */
    private static $compressed = [
        self::APPLICATION_GZIP => true,
        self::APPLICATION_X_BZIP => true,
        self::APPLICATION_X_BZIP2 => true,
        self::APPLICATION_X_COMPRESS => true,
        self::APPLICATION_X_LZIP => true,
        self::APPLICATION_X_LZMA => true,
        self::APPLICATION_X_LZOP => true,
        self::APPLICATION_X_SNAPPY_FRAMED => true,
        self::APPLICATION_X_XZ => true,
    ];

    /** @var bool[] */
    private static $archive = [
        // uncompressed
        self::APPLICATION_VND_EFI_ISO => false,
        self::APPLICATION_X_CPIO => false,
        self::APPLICATION_X_SV4CPIO => false,
        self::APPLICATION_X_SHAR => false,
        self::APPLICATION_X_TAR => false,

        // compressed
        self::APPLICATION_VND_ANDROID_PACKAGE_ARCHIVE => true,
        self::APPLICATION_VND_MS_CAB_COMPRESSED => true,
        self::APPLICATION_X_7Z_COMPRESSED => true,
        self::APPLICATION_X_ACE_COMPRESSED => true,
        self::APPLICATION_X_ASTROTITE_AFA => true,
        self::APPLICATION_X_ALZ_COMPRESSED => true,
        self::APPLICATION_X_ARJ => true,
        self::APPLICATION_X_B1 => true,
        self::APPLICATION_X_CFS_COMPRESSED => true,
        self::APPLICATION_X_DAR => true,
        self::APPLICATION_X_DGC_COMPRESSED => true,
        self::APPLICATION_X_APPLE_DISKIMAGE => true,
        self::APPLICATION_X_GCA_COMPRESSED => true,
        self::APPLICATION_X_GTAR => true,
        self::APPLICATION_X_LZH => true,
        self::APPLICATION_X_LZX => true,
        self::APPLICATION_X_RAR_COMPRESSED => true,
        self::APPLICATION_X_STUFFIT => true,
        self::APPLICATION_X_STUFFITX => true,
        self::APPLICATION_X_ZOO => true,
        self::APPLICATION_ZIP => true,
    ];

    public static function getValueRegexp(): string
    {
        return BaseContentType::getValueRegexp() . '\\/[0-9a-z.+-]+';
    }

    public static function findByExtension(string $extension): ?self
    {
        if (isset(self::$extensions[$extension])) {
            return self::get(self::$extensions[$extension]);
        } else {
            return null;
        }
    }

    public function getBaseType(): BaseContentType
    {
        return BaseContentType::get(Str::toFirst($this->getValue(), '/'));
    }

    public function getExtension(): ?string
    {
        /** @var string|null $extension */
        $extension = array_search($this->getValue(), self::$extensions, true) ?: null;

        return $extension;
    }

    public function isAudio(): bool
    {
        return Str::toFirst($this->getValue(), '/') === BaseContentType::AUDIO;
    }

    public function isArchive(): bool
    {
        return isset(self::$archive[$this->getValue()]);
    }

    public function isCompressed(): bool
    {
        return isset(self::$compressed[$this->getValue()]);
    }

    public function isCsv(): bool
    {
        return $this->getValue() === self::TEXT_CSV;
    }

    public function isFont(): bool
    {
        return Str::toFirst($this->getValue(), '/') === BaseContentType::FONT;
    }

    public function isHtml(): bool
    {
        return Str::contains(Str::fromFirst($this->getValue(), '/'), 'html');
    }

    public function isImage(): bool
    {
        return Str::toFirst($this->getValue(), '/') === BaseContentType::IMAGE;
    }

    public function isJson(): bool
    {
        return Str::contains(Str::fromFirst($this->getValue(), '/'), 'json');
    }

    public function isPdf(): bool
    {
        return $this->getValue() === self::APPLICATION_PDF;
    }

    public function isText(): bool
    {
        return Str::toFirst($this->getValue(), '/') === BaseContentType::TEXT;
    }

    public function isVideo(): bool
    {
        return Str::toFirst($this->getValue(), '/') === BaseContentType::VIDEO;
    }

    public function isXml(): bool
    {
        return Str::contains(Str::fromFirst($this->getValue(), '/'), 'xml');
    }

}
