<?php declare(strict_types = 1);
/**
 * This file is part of the Dogma library (https://github.com/paranoiq/dogma)
 *
 * Copyright (c) 2012 Vlasta Neubauer (@paranoiq)
 *
 * For the full copyright and license information read the file 'license.md', distributed with this source code
 */

// phpcs:disable SlevomatCodingStandard.Classes.ConstantSpacing.IncorrectCountOfBlankLinesAfterConstant

namespace Dogma\Country;

/**
 * 2-letter country code by ISO-3166-1
 */
class CountryEurope extends Country
{

    public const ALAND_ISLANDS = 'AX';
    public const ALBANIA = 'AL';
    public const ANDORRA = 'AD';
    public const ARMENIA = 'AM';
    public const AUSTRIA = 'AT';
    public const AZERBAIJAN = 'AZ';
    public const BELARUS = 'BY';
    public const BELGIUM = 'BE';
    public const BOSNIA_AND_HERZEGOVINA = 'BA';
    public const BULGARIA = 'BG';
    public const CROATIA = 'HR';
    public const CYPRUS = 'CY';
    public const CZECHIA = 'CZ';
    public const DENMARK = 'DK';
    public const ESTONIA = 'EE';
    public const FAROE_ISLANDS = 'FO';
    public const FINLAND = 'FI';
    public const FRANCE = 'FR';
    public const GEORGIA = 'GE';
    public const GERMANY = 'DE';
    public const GIBRALTAR = 'GI';
    public const GREECE = 'GR';
    public const GREENLAND = 'GL';
    public const GUERNSEY = 'GG';
    public const HUNGARY = 'HU';
    public const ICELAND = 'IS';
    public const IRELAND = 'IE';
    public const ITALY = 'IT';
    public const ISLE_OF_MAN = 'IM';
    public const JERSEY = 'JE';
    public const KAZAKHSTAN = 'KZ';
    public const KOSOVO = 'XK';
    public const LATVIA = 'LV';
    public const LIECHTENSTEIN = 'LI';
    public const LITHUANIA = 'LT';
    public const LUXEMBOURG = 'LU';
    public const MACEDONIA = 'MK';
    public const MALTA = 'MT';
    public const MOLDOVA = 'MD';
    public const MONACO = 'MC';
    public const MONTENEGRO = 'ME';
    public const NETHERLANDS = 'NL';
    public const NORWAY = 'NO';
    public const POLAND = 'PL';
    public const PORTUGAL = 'PT';
    public const ROMANIA = 'RO';
    public const RUSSIA = 'RU';
    public const SAN_MARINO = 'SM';
    public const SERBIA = 'RS';
    public const SLOVAKIA = 'SK';
    public const SLOVENIA = 'SI';
    public const SPAIN = 'ES';
    public const SVALBARD_AND_JAN_MAYEN = 'SJ';
    public const SWEDEN = 'SE';
    public const SWITZERLAND = 'CH';
    public const TURKEY = 'TR';
    public const UKRAINE = 'UA';
    public const UNITED_KINGDOM = 'GB';
    public const VATICAN = 'VA';

    /** @deprecated @removed */
    public const AFGHANISTAN = 'AF';
    /** @deprecated @removed */
    public const ALGERIA = 'DZ';
    /** @deprecated @removed */
    public const AMERICAN_SAMOA = 'AS';
    /** @deprecated @removed */
    public const ANGOLA = 'AO';
    /** @deprecated @removed */
    public const ANGUILLA = 'AI';
    /** @deprecated @removed */
    public const ANTARCTICA = 'AQ';
    /** @deprecated @removed */
    public const ANTIGUA_AND_BARBUDA = 'AG';
    /** @deprecated @removed */
    public const ARGENTINA = 'AR';
    /** @deprecated @removed */
    public const ARUBA = 'AW';
    /** @deprecated @removed */
    public const AUSTRALIA = 'AU';
    /** @deprecated @removed */
    public const BAHAMAS = 'BS';
    /** @deprecated @removed */
    public const BAHRAIN = 'BH';
    /** @deprecated @removed */
    public const BANGLADESH = 'BD';
    /** @deprecated @removed */
    public const BARBADOS = 'BB';
    /** @deprecated @removed */
    public const BELIZE = 'BZ';
    /** @deprecated @removed */
    public const BENIN = 'BJ';
    /** @deprecated @removed */
    public const BERMUDA = 'BM';
    /** @deprecated @removed */
    public const BHUTAN = 'BT';
    /** @deprecated @removed */
    public const BOLIVIA = 'BO';
    /** @deprecated @removed */
    public const BOTSWANA = 'BW';
    /** @deprecated @removed */
    public const BOUVET_ISLAND = 'BV';
    /** @deprecated @removed */
    public const BRAZIL = 'BR';
    /** @deprecated @removed */
    public const BRITISH_INDIAN_OCEAN_TERRITORY = 'IO';
    /** @deprecated @removed */
    public const BRUNEI_DARUSSALAM = 'BN';
    /** @deprecated @removed */
    public const BURKINA_FASO = 'BF';
    /** @deprecated @removed */
    public const BURUNDI = 'BI';
    /** @deprecated @removed */
    public const CAMBODIA = 'KH';
    /** @deprecated @removed */
    public const CAMEROON = 'CM';
    /** @deprecated @removed */
    public const CANADA = 'CA';
    /** @deprecated @removed */
    public const CAPE_VERDE = 'CV';
    /** @deprecated @removed */
    public const CAYMAN_ISLANDS = 'KY';
    /** @deprecated @removed */
    public const CENTRAL_AFRICAN_REPUBLIC = 'CF';
    /** @deprecated @removed */
    public const CHAD = 'TD';
    /** @deprecated @removed */
    public const CHILE = 'CL';
    /** @deprecated @removed */
    public const CHINA = 'CN';
    /** @deprecated @removed */
    public const CHRISTMAS_ISLAND = 'CX';
    /** @deprecated @removed */
    public const COCOS_ISLANDS = 'CC';
    /** @deprecated @removed */
    public const COLOMBIA = 'CO';
    /** @deprecated @removed */
    public const COMOROS = 'KM';
    /** @deprecated @removed */
    public const CONGO = 'CG';
    /** @deprecated @removed */
    public const COOK_ISLANDS = 'CK';
    /** @deprecated @removed */
    public const COSTA_RICA = 'CR';
    /** @deprecated @removed */
    public const COTE_D_IVOIRE = 'CI';
    /** @deprecated @removed */
    public const CUBA = 'CU';
    /** @deprecated @removed */
    public const DEMOCRATIC_REPUBLIC_OF_THE_CONGO = 'CD';
    /** @deprecated @removed */
    public const DJIBOUTI = 'DJ';
    /** @deprecated @removed */
    public const DOMINICA = 'DM';
    /** @deprecated @removed */
    public const DOMINICAN_REPUBLIC = 'DO';
    /** @deprecated @removed */
    public const ECUADOR = 'EC';
    /** @deprecated @removed */
    public const EGYPT = 'EG';
    /** @deprecated @removed */
    public const EL_SALVADOR = 'SV';
    /** @deprecated @removed */
    public const EQUATORIAL_GUINEA = 'GQ';
    /** @deprecated @removed */
    public const ERITREA = 'ER';
    /** @deprecated @removed */
    public const ETHIOPIA = 'ET';
    /** @deprecated @removed */
    public const FALKLAND_ISLANDS = 'FK';
    /** @deprecated @removed */
    public const FIJI = 'FJ';
    /** @deprecated @removed */
    public const FRENCH_GUIANA = 'GF';
    /** @deprecated @removed */
    public const FRENCH_POLYNESIA = 'PF';
    /** @deprecated @removed */
    public const FRENCH_SOUTHERN_TERRITORIES = 'TF';
    /** @deprecated @removed */
    public const GABON = 'GA';
    /** @deprecated @removed */
    public const GAMBIA = 'GM';
    /** @deprecated @removed */
    public const GHANA = 'GH';
    /** @deprecated @removed */
    public const GRENADA = 'GD';
    /** @deprecated @removed */
    public const GUADELOUPE = 'GP';
    /** @deprecated @removed */
    public const GUAM = 'GU';
    /** @deprecated @removed */
    public const GUATEMALA = 'GT';
    /** @deprecated @removed */
    public const GUINEA = 'GN';
    /** @deprecated @removed */
    public const GUINEA_BISSAU = 'GW';
    /** @deprecated @removed */
    public const GUYANA = 'GY';
    /** @deprecated @removed */
    public const HAITI = 'HT';
    /** @deprecated @removed */
    public const HEARD_ISLAND_AND_MCDONALD_ISLANDS = 'HM';
    /** @deprecated @removed */
    public const HONDURAS = 'HN';
    /** @deprecated @removed */
    public const HONG_KONG = 'HK';
    /** @deprecated @removed */
    public const INDIA = 'IN';
    /** @deprecated @removed */
    public const INDONESIA = 'ID';
    /** @deprecated @removed */
    public const IRAQ = 'IQ';
    /** @deprecated @removed */
    public const ISLAMIC_REPUBLIC_OF_IRAN = 'IR';
    /** @deprecated @removed */
    public const ISRAEL = 'IL';
    /** @deprecated @removed */
    public const JAMAICA = 'JM';
    /** @deprecated @removed */
    public const JAPAN = 'JP';
    /** @deprecated @removed */
    public const JORDAN = 'JO';
    /** @deprecated @removed */
    public const KENYA = 'KE';
    /** @deprecated @removed */
    public const KIRIBATI = 'KI';
    /** @deprecated @removed */
    public const KUWAIT = 'KW';
    /** @deprecated @removed */
    public const KYRGYZSTAN = 'KG';
    /** @deprecated @removed */
    public const LAOS = 'LA';
    /** @deprecated @removed */
    public const LEBANON = 'LB';
    /** @deprecated @removed */
    public const LESOTHO = 'LS';
    /** @deprecated @removed */
    public const LIBERIA = 'LR';
    /** @deprecated @removed */
    public const LIBYA = 'LY';
    /** @deprecated @removed */
    public const MACAO = 'MO';
    /** @deprecated @removed */
    public const MADAGASCAR = 'MG';
    /** @deprecated @removed */
    public const MALAWI = 'MW';
    /** @deprecated @removed */
    public const MALAYSIA = 'MY';
    /** @deprecated @removed */
    public const MALDIVES = 'MV';
    /** @deprecated @removed */
    public const MALI = 'ML';
    /** @deprecated @removed */
    public const MARSHALL_ISLANDS = 'MH';
    /** @deprecated @removed */
    public const MARTINIQUE = 'MQ';
    /** @deprecated @removed */
    public const MAURITANIA = 'MR';
    /** @deprecated @removed */
    public const MAURITIUS = 'MU';
    /** @deprecated @removed */
    public const MAYOTTE = 'YT';
    /** @deprecated @removed */
    public const MEXICO = 'MX';
    /** @deprecated @removed */
    public const MICRONESIA = 'FM';
    /** @deprecated @removed */
    public const MONGOLIA = 'MN';
    /** @deprecated @removed */
    public const MONTSERRAT = 'MS';
    /** @deprecated @removed */
    public const MOROCCO = 'MA';
    /** @deprecated @removed */
    public const MOZAMBIQUE = 'MZ';
    /** @deprecated @removed */
    public const MYANMAR = 'MM';
    /** @deprecated @removed */
    public const NAMIBIA = 'NA';
    /** @deprecated @removed */
    public const NAURU = 'NR';
    /** @deprecated @removed */
    public const NEPAL = 'NP';
    /** @deprecated @removed */
    public const NETHERLANDS_ANTILLES = 'AN';
    /** @deprecated @removed */
    public const NEW_CALEDONIA = 'NC';
    /** @deprecated @removed */
    public const NEW_ZEALAND = 'NZ';
    /** @deprecated @removed */
    public const NICARAGUA = 'NI';
    /** @deprecated @removed */
    public const NIGER = 'NE';
    /** @deprecated @removed */
    public const NIGERIA = 'NG';
    /** @deprecated @removed */
    public const NIUE = 'NU';
    /** @deprecated @removed */
    public const NORFOLK_ISLAND = 'NF';
    /** @deprecated @removed */
    public const NORTHERN_MARIANA_ISLANDS = 'MP';
    /** @deprecated @removed */
    public const NORTH_KOREA = 'KP';
    /** @deprecated @removed */
    public const OMAN = 'OM';
    /** @deprecated @removed */
    public const PAKISTAN = 'PK';
    /** @deprecated @removed */
    public const PALAU = 'PW';
    /** @deprecated @removed */
    public const PALESTINE = 'PS';
    /** @deprecated @removed */
    public const PANAMA = 'PA';
    /** @deprecated @removed */
    public const PAPUA_NEW_GUINEA = 'PG';
    /** @deprecated @removed */
    public const PARAGUAY = 'PY';
    /** @deprecated @removed */
    public const PERU = 'PE';
    /** @deprecated @removed */
    public const PHILIPPINES = 'PH';
    /** @deprecated @removed */
    public const PITCAIRN = 'PN';
    /** @deprecated @removed */
    public const PUERTO_RICO = 'PR';
    /** @deprecated @removed */
    public const QATAR = 'QA';
    /** @deprecated @removed */
    public const REUNION = 'RE';
    /** @deprecated @removed */
    public const RWANDA = 'RW';
    /** @deprecated @removed */
    public const SAINT_HELENA = 'SH';
    /** @deprecated @removed */
    public const SAINT_KITTS_AND_NEVIS = 'KN';
    /** @deprecated @removed */
    public const SAINT_LUCIA = 'LC';
    /** @deprecated @removed */
    public const SAINT_MARTIN_DUTCH = 'SX';
    /** @deprecated @removed */
    public const SAINT_MARTIN_FRENCH = 'MF';
    /** @deprecated @removed */
    public const SAINT_PIERRE_AND_MIQUELON = 'PM';
    /** @deprecated @removed */
    public const SAINT_VINCENT_AND_THE_GRENADINES = 'VC';
    /** @deprecated @removed */
    public const SAMOA = 'WS';
    /** @deprecated @removed */
    public const SAO_TOME_AND_PRINCIPE = 'ST';
    /** @deprecated @removed */
    public const SAUDI_ARABIA = 'SA';
    /** @deprecated @removed */
    public const SENEGAL = 'SN';
    /** @deprecated @removed */
    public const SEYCHELLES = 'SC';
    /** @deprecated @removed */
    public const SIERRA_LEONE = 'SL';
    /** @deprecated @removed */
    public const SINGAPORE = 'SG';
    /** @deprecated @removed */
    public const SOLOMON_ISLANDS = 'SB';
    /** @deprecated @removed */
    public const SOMALIA = 'SO';
    /** @deprecated @removed */
    public const SOUTH_AFRICA = 'ZA';
    /** @deprecated @removed */
    public const SOUTH_GEORGIA_AND_THE_SOUTH_SANDWICH = 'GS';
    /** @deprecated @removed */
    public const SOUTH_KOREA = 'KR';
    /** @deprecated @removed */
    public const SOUTH_SUDAN = 'SS';
    /** @deprecated @removed */
    public const SRI_LANKA = 'LK';
    /** @deprecated @removed */
    public const SUDAN = 'SD';
    /** @deprecated @removed */
    public const SURINAME = 'SR';
    /** @deprecated @removed */
    public const SWAZILAND = 'SZ';
    /** @deprecated @removed */
    public const SYRIA = 'SY';
    /** @deprecated @removed */
    public const TAIWAN = 'TW';
    /** @deprecated @removed */
    public const TAJIKISTAN = 'TJ';
    /** @deprecated @removed */
    public const TANZANIA = 'TZ';
    /** @deprecated @removed */
    public const THAILAND = 'TH';
    /** @deprecated @removed */
    public const TIMOR_LESTE = 'TL';
    /** @deprecated @removed */
    public const TOGO = 'TG';
    /** @deprecated @removed */
    public const TOKELAU = 'TK';
    /** @deprecated @removed */
    public const TONGA = 'TO';
    /** @deprecated @removed */
    public const TRINIDAD_AND_TOBAGO = 'TT';
    /** @deprecated @removed */
    public const TUNISIA = 'TN';
    /** @deprecated @removed */
    public const TURKMENISTAN = 'TM';
    /** @deprecated @removed */
    public const TURKS_AND_CAICOS_ISLANDS = 'TC';
    /** @deprecated @removed */
    public const TUVALU = 'TV';
    /** @deprecated @removed */
    public const UGANDA = 'UG';
    /** @deprecated @removed */
    public const UNITED_ARAB_EMIRATES = 'AE';
    /** @deprecated @removed */
    public const UNITED_STATES = 'US';
    /** @deprecated @removed */
    public const UNITED_STATES_MINOR_OUTLYING_ISLANDS = 'UM';
    /** @deprecated @removed */
    public const URUGUAY = 'UY';
    /** @deprecated @removed */
    public const UZBEKISTAN = 'UZ';
    /** @deprecated @removed */
    public const VANUATU = 'VU';
    /** @deprecated @removed */
    public const VENEZUELA = 'VE';
    /** @deprecated @removed */
    public const VIETNAM = 'VN';
    /** @deprecated @removed */
    public const VIRGIN_ISLANDS_BRITISH = 'VG';
    /** @deprecated @removed */
    public const VIRGIN_ISLANDS_US = 'VI';
    /** @deprecated @removed */
    public const WALLIS_AND_FUTUNA = 'WF';
    /** @deprecated @removed */
    public const WESTERN_SAHARA = 'EH';
    /** @deprecated @removed */
    public const YEMEN = 'YE';
    /** @deprecated @removed */
    public const ZAMBIA = 'ZM';
    /** @deprecated @removed */
    public const ZIMBABWE = 'ZW';

}
