<?php declare(strict_types = 1);
/**
 * This file is part of the Dogma library (https://github.com/paranoiq/dogma)
 *
 * Copyright (c) 2012 Vlasta Neubauer (@paranoiq)
 *
 * For the full copyright and license information read the file 'license.md', distributed with this source code
 */

// phpcs:disable SlevomatCodingStandard.Classes.ConstantSpacing.IncorrectCountOfBlankLinesAfterConstant

namespace Dogma\Country;

/**
 * 2-letter country code by ISO-3166-1
 */
class CountryEu extends CountryEurope
{

    public const AUSTRIA = 'AT';
    public const BELGIUM = 'BE';
    public const BULGARIA = 'BG';
    public const CROATIA = 'HR';
    public const CYPRUS = 'CY';
    public const CZECHIA = 'CZ';
    public const DENMARK = 'DK';
    public const ESTONIA = 'EE';
    public const FINLAND = 'FI';
    public const FRANCE = 'FR';
    public const GERMANY = 'DE';
    public const GREECE = 'GR';
    public const HUNGARY = 'HU';
    public const IRELAND = 'IE';
    public const ITALY = 'IT';
    public const LATVIA = 'LV';
    public const LITHUANIA = 'LT';
    public const LUXEMBOURG = 'LU';
    public const MALTA = 'MT';
    public const NETHERLANDS = 'NL';
    public const POLAND = 'PL';
    public const PORTUGAL = 'PT';
    public const ROMANIA = 'RO';
    public const SLOVAKIA = 'SK';
    public const SLOVENIA = 'SI';
    public const SPAIN = 'ES';
    public const SWEDEN = 'SE';

    /** @deprecated @removed*/
    public const ALAND_ISLANDS = 'AX';
    /** @deprecated @removed */
    public const ALBANIA = 'AL';
    /** @deprecated @removed */
    public const ANDORRA = 'AD';
    /** @deprecated @removed */
    public const ARMENIA = 'AM';
    /** @deprecated @removed */
    public const AZERBAIJAN = 'AZ';
    /** @deprecated @removed */
    public const BELARUS = 'BY';
    /** @deprecated @removed */
    public const BOSNIA_AND_HERZEGOVINA = 'BA';
    /** @deprecated @removed */
    public const FAROE_ISLANDS = 'FO';
    /** @deprecated @removed */
    public const GEORGIA = 'GE';
    /** @deprecated @removed */
    public const GIBRALTAR = 'GI';
    /** @deprecated @removed */
    public const GREENLAND = 'GL';
    /** @deprecated @removed */
    public const GUERNSEY = 'GG';
    /** @deprecated @removed */
    public const ICELAND = 'IS';
    /** @deprecated @removed */
    public const ISLE_OF_MAN = 'IM';
    /** @deprecated @removed */
    public const JERSEY = 'JE';
    /** @deprecated @removed */
    public const KAZAKHSTAN = 'KZ';
    /** @deprecated @removed */
    public const KOSOVO = 'XK';
    /** @deprecated @removed */
    public const LIECHTENSTEIN = 'LI';
    /** @deprecated @removed */
    public const MOLDOVA = 'MD';
    /** @deprecated @removed */
    public const MONACO = 'MC';
    /** @deprecated @removed */
    public const MONTENEGRO = 'ME';
    /** @deprecated @removed */
    public const MACEDONIA = 'MK';
    /** @deprecated @removed */
    public const NORWAY = 'NO';
    /** @deprecated @removed */
    public const RUSSIA = 'RU';
    /** @deprecated @removed */
    public const SAN_MARINO = 'SM';
    /** @deprecated @removed */
    public const SERBIA = 'RS';
    /** @deprecated @removed */
    public const SVALBARD_AND_JAN_MAYEN = 'SJ';
    /** @deprecated @removed */
    public const SWITZERLAND = 'CH';
    /** @deprecated @removed */
    public const TURKEY = 'TR';
    /** @deprecated @removed */
    public const UKRAINE = 'UA';
    /** @deprecated @removed */
    public const UNITED_KINGDOM = 'GB';
    /** @deprecated @removed */
    public const VATICAN = 'VA';

}
