import { css, unsafeCSS } from 'lit';
import componentStyles from '../../styles/components.styles';
import { Variables as Var } from '../../styles/global-variables';

export default [
  componentStyles,
  css`
    :host {
      position: fixed;
      display: flex;
      left: 0;
      top: 0;
      right: 0;
      bottom: 0;
      background: var(--banana-overlay-background, rgba(0, 0, 0, 0.5));
      visibility: hidden;
      opacity: 0;
      transition: all ${unsafeCSS(Var.TransitionNormal)};
    }

    :host([open]) {
      opacity: 1;
      visibility: visible;
    }

    .overlay__mask {
      position: fixed;
      left: 0;
      top: 0;
      right: 0;
      bottom: 0;
      background: transparent;
      z-index: -1;
    }

    .overlay__container {
      position: relative;
      margin: auto;
      display: flex;
      align-items: center;
      justify-content: center;
    }
  `,
];
