/**
 * title: 自定义icon
 * debug: true
 */

import { Select, SelectOption } from '@banana-ui/react';

export default function CustomIcons() {
  return (
    <Select placeholder="Choose a fruit" style={{ width: '100%' }} clearable filter>
      <svg slot="selector-icon-expand" width="12" height="12" viewBox="0 0 1024 1024">
        <path
          d="M731.733333 480l-384-341.333333c-17.066667-14.933333-44.8-14.933333-59.733333 4.266666-14.933333 17.066667-14.933333 44.8 4.266667 59.733334L640 512 292.266667 821.333333c-17.066667 14.933333-19.2 42.666667-4.266667 59.733334 8.533333 8.533333 19.2 14.933333 32 14.933333 10.666667 0 19.2-4.266667 27.733333-10.666667l384-341.333333c8.533333-8.533333 14.933333-19.2 14.933334-32s-4.266667-23.466667-14.933334-32z"
          fill="red"
        ></path>
      </svg>

      <svg slot="selector-icon-clear" viewBox="0 0 1024 1024" width="12" height="12">
        <path
          d="M512 949.333333C270.933333 949.333333 74.666667 753.066667 74.666667 512S270.933333 74.666667 512 74.666667 949.333333 270.933333 949.333333 512 753.066667 949.333333 512 949.333333z m-151.466667-292.266666c10.666667 10.666667 29.866667 12.8 42.666667 2.133333l2.133333-2.133333 104.533334-102.4 102.4 102.4 2.133333 2.133333c12.8 10.666667 32 8.533333 42.666667-2.133333 12.8-12.8 12.8-32 0-44.8L554.666667 509.866667l102.4-102.4 2.133333-2.133334c10.666667-12.8 8.533333-32-2.133333-42.666666s-29.866667-12.8-42.666667-2.133334l-2.133333 2.133334-102.4 102.4-102.4-102.4-2.133334-2.133334c-12.8-10.666667-32-8.533333-42.666666 2.133334-12.8 12.8-12.8 32 0 44.8l102.4 102.4-102.4 102.4-2.133334 2.133333c-10.666667 12.8-10.666667 32 0 42.666667z"
          fill="blue"
        ></path>
      </svg>

      <svg width="12" height="12" viewBox="0 0 16 16" fill="none" slot="selector-icon-search">
        <path
          d="M10.3345 11.7488C9.25957 12.5354 7.93402 12.9999 6.49995 12.9999C2.91014 12.9999 0 10.0897 0 6.49995C0 2.91014 2.91014 0 6.49995 0C10.0897 0 12.9999 2.91014 12.9999 6.49995C12.9999 7.93402 12.5354 9.25957 11.7488 10.3345L15.7071 14.2927C16.0976 14.6834 16.0976 15.3164 15.7071 15.7071C15.3164 16.0976 14.6834 16.0976 14.2927 15.7071L10.3345 11.7488ZM6.49996 10.9999C8.98517 10.9999 10.9999 8.98517 10.9999 6.49996C10.9999 4.01475 8.98517 2 6.49996 2C4.01469 2 2 4.01475 2 6.49996C2 8.98517 4.01469 10.9999 6.49996 10.9999Z"
          fill="green"
        ></path>
      </svg>

      <SelectOption value="apple">Apple</SelectOption>
      <SelectOption value="banana">Banana</SelectOption>
      <SelectOption value="orange">Orange</SelectOption>
      <SelectOption value="pear">Pear</SelectOption>
      <SelectOption value="grape">Grape</SelectOption>
    </Select>
  );
}
