# Banana UI

[![NPM version](https://img.shields.io/npm/v/@banana-ui/banana.svg?style=flat)](https://www.npmjs.com/package/@banana-ui/banana)
[![NPM downloads](http://img.shields.io/npm/dm/@banana-ui/banana.svg?style=flat)](https://www.npmjs.com/package/@banana-ui/banana)
[![Jsdelivr](https://data.jsdelivr.com/v1/package/npm/@banana-ui/banana/badge)](https://www.npmjs.com/package/@banana-ui/banana)
[![Bundle size](https://img.shields.io/bundlephobia/minzip/@banana-ui/banana)](https://www.npmjs.com/package/@banana-ui/banana?activeTab=code)
![License](https://img.shields.io/github/license/FriedRiceNoodles/banana-ui)

`Banana UI` 是一套底层基于 `Web Components` 的组件库，它提供了一套常用的组件。

<img height="160" src="https://cdn.shopify.com/s/files/1/2710/8782/files/QSHJ5M-thshxN3_4oxrNa.png?v=1713521360" />

官方文档:

- https://banana-ui.com/
- 国内镜像: https://banana.youniverse.cc/ （没开启科学上网的用户可以访问这里）

## ⭐️ 特性

- 🧩 **可用于几乎任何 Web 框架（React、Vue、以及其他...）**
- 🌐 **可用于原生环境（无框架）**
- 🚀 **支持 SSR（甚至能用于 worker 环境）**
- 🛡 良好的 TypeScript 支持
- 📱 适用于 PC 端，移动端也可用
- 🧪 完善的单元测试

## Banana 解决了什么问题？

Banana 最大的特点是它是一个基于 Web Components 的组件库，这意味着它可以在几乎所有的前端框架中使用，也可以在原生环境（无框架）中使用；并且它还**支持服务端渲染（SSR）**，甚至可以用于 worker 环境。这意味着你几乎可以在任何地方使用它。

> Banana 似乎是现在国内唯一一个支持服务端渲染的 Web Components 组件库。

基于这点，Banana 适合这些场景：

- 你正在开发一个需要支持多种框架的组件/插件/工具。
- 你有多个项目，它们使用不同的前端框架，你希望能够在这些项目中使用相同的组件库。
- 你开发的项目正在使用模板引擎，而不是前端框架（比如 Shopify、Wordpress 等）。
- 你开发的项目没有使用前端框架，而是原生环境。
- React 用户，我们提供了一个 React 版本，它对 React 做了专门的适配，可以更好地和 React 配合使用。
- 当然，Vue 项目或其他 Web 框架也可以使用 Banana。

## 寻求帮助 & 参与贡献

欢迎任何形式的提问和贡献，你可以在 [Issues 区](https://github.com/FriedRiceNoodles/banana-ui/issues) 上提出问题或寻求帮助。
如果你想参与贡献，希望可以先查看 [贡献指南](/docs/guide/contributing.md)。

## Q & A

### 我可以把它用于生产环境吗？

可以。Banana UI 已经在一些项目中使用。但是请注意，它仍然处于早期阶段，可能会有一些问题。如果你在使用过程中遇到了问题，欢迎在 [Issues 区](https://github.com/FriedRiceNoodles/banana-ui/issues) 上提出问题或寻求帮助。

> 作者注：我目前在一个跨境电商公司工作，公司最大的 C 端项目以及它的一些内部系统都在使用 Banana UI。

## LICENSE

MIT
