# FormationFlight  

![GitHub release (with filter)](https://img.shields.io/github/v/release/FormationFlight/FormationFlight?logo=github)
[![Build](https://github.com/FormationFlight/FormationFlight/actions/workflows/build.yml/badge.svg)](https://github.com/FormationFlight/FormationFlight/actions/workflows/build.yml)
![License](https://img.shields.io/github/license/FormationFlight/FormationFlight)
[![Chat](https://img.shields.io/discord/1120104184725905443?logo=discord)](https://discord.gg/npaX3VxQjh)

FormationFlight provides FPV pilots with inter-UAS positioning & telemetry, enabling formation flights, chase footage, and ground station coordination with ease. Spiritual successor to the [iNav Radar](https://github.com/OlivierC-FR/ESP32-INAV-Radar) project, FormationFlight adds many improvements including faster update rates, more users, encryption, and smaller, lighter hardware originally developed for the [ExpressLRS project](https://github.com/ExpressLRS/ExpressLRS).

## Getting Started

Visit the [FormationFlight Getting Started](https://formationflight.org/getting-started/) page!

## Issues

GitHub issues are open for bug reports / feature requests - feel free to drop by the [FormationFlight Discord](https://discord.gg/s6vEaN3Ucj) and chat with the development team before submitting an issue if you're not sure.

## Website

Please visit [https://formationflight.org](https://formationflight.org) for documentation and project information.

## Discord

We use the [FormationFlight Discord](https://discord.gg/s6vEaN3Ucj) to discuss project development & support new users. 

## Development Information

### Builds:
We run [automated builds on GitHub actions](https://github.com/FormationFlight/FormationFlight/actions) against the master branch and upload artifacts of all built targets as a zip file. Tagged versions are released periodically, and follow semver convention.

### Building manually:
Visual Studio Code with PlatformIO is required; all dependencies are managed by PlatformIO so it should be as simple as installing VSCode, installing PlatformIO, cloning the repo, and building! If you have any questions, please join our Discord and ask in #development.
