using System.Collections.Generic;

namespace CubeKit.UI.Icons
{

    public partial class FluentSymbolIcon
    {
        /// <summary>
        /// A lookup table containing the paths representing each available Fluent System Icon symbol
        /// </summary>
        public static Dictionary<FluentSymbol, string> AllFluentIcons { get; } = new Dictionary<FluentSymbol, string>
        {
            { FluentSymbol.AccessTime24Filled, "M22 12C22 6.47715 17.5228 2 12 2C6.47715 2 2 6.47715 2 12C2 17.5228 6.47715 22 12 22C17.5228 22 22 17.5228 22 12ZM7.49956 8.74427C7.84708 8.36181 8.41524 7.99994 9.24996 7.99994C10.4023 7.99994 11.1442 8.792 11.4045 9.66118C11.6581 10.5078 11.5043 11.5564 10.785 12.279C10.5378 12.5274 10.2468 12.7521 9.99212 12.9487L9.9514 12.9802C9.67221 13.196 9.42286 13.3916 9.20288 13.6109C8.94689 13.8663 8.73824 14.1454 8.61656 14.4999H10.75C11.1642 14.4999 11.5 14.8357 11.5 15.2499C11.5 15.6642 11.1642 15.9999 10.75 15.9999H7.74996C7.55104 15.9999 7.36027 15.9209 7.21962 15.7803C7.07897 15.6396 6.99995 15.4488 6.99996 15.2499C6.99998 14.003 7.52397 13.1669 8.14363 12.5489C8.44003 12.2533 8.7618 12.0038 9.03412 11.7934L9.03711 11.791C9.32312 11.57 9.54503 11.3985 9.72185 11.2208C9.99417 10.9473 10.0887 10.4958 9.96757 10.0915C9.85324 9.70976 9.59759 9.49994 9.24996 9.49994C8.89717 9.49994 8.71534 9.63676 8.60973 9.753C8.55037 9.81832 8.50976 9.88475 8.48499 9.93316C8.47292 9.95674 8.46562 9.97407 8.46245 9.98203L8.46139 9.98474C8.33241 10.3717 7.91657 10.5855 7.52572 10.463C7.13045 10.3392 6.91042 9.91835 7.03426 9.52308L7.06895 9.42691C7.08751 9.38032 7.1139 9.31973 7.14969 9.24981C7.22062 9.1112 7.33236 8.92829 7.49956 8.74427ZM13.25 8.00003C13.6642 8.00003 14 8.33582 14 8.75003V11.4993H15.5V8.75003C15.5 8.33582 15.8358 8.00003 16.25 8.00003C16.6642 8.00003 17 8.33582 17 8.75003V15.2204C17 15.6346 16.6642 15.9704 16.25 15.9704C15.8358 15.9704 15.5 15.6346 15.5 15.2204V12.9993H13.25C12.8358 12.9993 12.5 12.6635 12.5 12.2493V8.75003C12.5 8.33582 12.8358 8.00003 13.25 8.00003Z " },
            { FluentSymbol.AccessTime24, "M7.49956 8.74427C7.84708 8.36181 8.41524 7.99994 9.24996 7.99994C10.4023 7.99994 11.1442 8.792 11.4045 9.66118C11.6581 10.5078 11.5043 11.5564 10.785 12.279C10.5378 12.5274 10.2468 12.7521 9.99212 12.9487L9.9514 12.9802C9.67221 13.196 9.42286 13.3916 9.20288 13.6109C8.94689 13.8663 8.73824 14.1454 8.61656 14.4999H10.75C11.1642 14.4999 11.5 14.8357 11.5 15.2499C11.5 15.6642 11.1642 15.9999 10.75 15.9999H7.74996C7.55104 15.9999 7.36027 15.9209 7.21962 15.7803C7.07897 15.6396 6.99995 15.4488 6.99996 15.2499C6.99998 14.003 7.52397 13.1669 8.14363 12.5489C8.44003 12.2533 8.7618 12.0038 9.03412 11.7934L9.03711 11.791C9.32312 11.57 9.54503 11.3985 9.72185 11.2208C9.99417 10.9473 10.0887 10.4958 9.96757 10.0915C9.85324 9.70976 9.59759 9.49994 9.24996 9.49994C8.89717 9.49994 8.71534 9.63676 8.60973 9.753C8.55037 9.81832 8.50976 9.88475 8.48499 9.93316C8.47292 9.95674 8.46562 9.97407 8.46245 9.98203L8.46139 9.98474C8.33241 10.3717 7.91657 10.5855 7.52572 10.463C7.13045 10.3392 6.91042 9.91835 7.03426 9.52308L7.06895 9.42691C7.08751 9.38032 7.1139 9.31973 7.14969 9.24981C7.22062 9.1112 7.33236 8.92829 7.49956 8.74427Z M13.25 8.00003C13.6642 8.00003 14 8.33582 14 8.75003V11.4993H15.5V8.75003C15.5 8.33582 15.8358 8.00003 16.25 8.00003C16.6642 8.00003 17 8.33582 17 8.75003V15.2204C17 15.6346 16.6642 15.9704 16.25 15.9704C15.8358 15.9704 15.5 15.6346 15.5 15.2204V12.9993H13.25C12.8358 12.9993 12.5 12.6635 12.5 12.2493V8.75003C12.5 8.33582 12.8358 8.00003 13.25 8.00003Z M22 12C22 6.47715 17.5228 2 12 2C6.47715 2 2 6.47715 2 12C2 17.5228 6.47715 22 12 22C17.5228 22 22 17.5228 22 12ZM3.5 12C3.5 7.30558 7.30558 3.5 12 3.5C16.6944 3.5 20.5 7.30558 20.5 12C20.5 16.6944 16.6944 20.5 12 20.5C7.30558 20.5 3.5 16.6944 3.5 12Z " },
            { FluentSymbol.Accessibility16Filled, "M8.00024 1C6.89567 1 6.00024 1.89543 6.00024 3C6.00024 4.10457 6.89567 5 8.00024 5C9.10481 5 10.0002 4.10457 10.0002 3C10.0002 1.89543 9.10481 1 8.00024 1ZM14.0087 4.14452C13.702 3.46475 12.9213 3.13862 12.2222 3.3983L11.328 3.73048C11.1874 3.78271 11.0777 3.89532 11.0291 4.03724C10.598 5.29638 9.40407 6.20048 8.00027 6.20048C6.59648 6.20048 5.40255 5.29638 4.97147 4.03724C4.92289 3.89532 4.81315 3.78272 4.67254 3.73048L3.80205 3.40713C3.08745 3.14168 2.29142 3.49343 2.00657 4.20052C1.72278 4.90498 2.04911 5.70754 2.74399 6.01406L5.00027 7.00932L5.00027 9.91251L3.79036 13.1249C3.54719 13.7705 3.85147 14.4936 4.4831 14.771C5.13961 15.0594 5.90561 14.761 6.1939 14.1044L7.71183 10.6475C7.81321 10.4166 8.14177 10.4194 8.23911 10.652L9.67617 14.086C9.98465 14.8232 10.8623 15.1327 11.5649 14.7521C12.157 14.4314 12.4223 13.7235 12.1869 13.0926L11.0003 9.91329L11.0003 7.00834L13.2759 6.03048C14.0046 5.71735 14.3348 4.86748 14.0087 4.14452Z " },
            { FluentSymbol.Accessibility16, "M7.99976 1C6.75712 1 5.74976 2.00736 5.74976 3.25C5.74976 3.43775 5.77275 3.62013 5.81608 3.79447L3.97712 3.09862C3.17757 2.79607 2.28121 3.17334 1.93864 3.95657C1.57937 4.778 1.96272 5.73448 2.78986 6.08041L4.99971 7.0046V9.39628L3.84141 12.8756C3.5756 13.6741 3.97123 14.5423 4.74819 14.8656C5.59009 15.2159 6.55439 14.7958 6.87114 13.9407L7.99229 10.9141L9.11715 13.938C9.44501 14.8194 10.457 15.2314 11.3072 14.8296C12.0396 14.4834 12.3992 13.6458 12.1458 12.8764L10.9997 9.39709V7.00128L13.184 6.09541C13.9622 5.77267 14.3606 4.90511 14.0982 4.10453C13.812 3.23102 12.8544 2.77335 11.9949 3.09926L10.1857 3.78532C10.2276 3.61375 10.2498 3.43447 10.2498 3.25C10.2498 2.00736 9.2424 1 7.99976 1ZM6.74976 3.25C6.74976 2.55964 7.3094 2 7.99976 2C8.69011 2 9.24976 2.55964 9.24976 3.25C9.24976 3.94036 8.69011 4.5 7.99976 4.5C7.3094 4.5 6.74976 3.94036 6.74976 3.25ZM12.3495 4.03429C12.6758 3.91057 13.0393 4.08431 13.148 4.41591C13.2475 4.71983 13.0963 5.04918 12.8009 5.1717L10.3082 6.20549C10.1214 6.28293 9.99971 6.46519 9.99971 6.66734V9.47732C9.99971 9.53046 10.0082 9.58327 10.0248 9.63375L11.196 13.1892C11.2915 13.4792 11.156 13.795 10.8799 13.9254C10.5594 14.0769 10.178 13.9216 10.0544 13.5894L8.8631 10.3868C8.56267 9.57919 7.42008 9.57998 7.12076 10.388L5.93341 13.5934C5.81389 13.916 5.45004 14.0745 5.13237 13.9424C4.8392 13.8204 4.68992 13.4928 4.79022 13.1915L5.97411 9.63525C5.99106 9.58432 5.99971 9.53099 5.99971 9.47732V6.67174C5.99971 6.47013 5.87862 6.28824 5.69262 6.21046L3.1757 5.15784C2.86392 5.02745 2.71942 4.66692 2.85484 4.35729C2.98397 4.06206 3.32184 3.91986 3.62321 4.0339L7.19511 5.38548C7.70824 5.57965 8.27467 5.57945 8.78767 5.38492L12.3495 4.03429Z " },
            { FluentSymbol.Accessibility20Filled, "M9.99976 2C8.75712 2 7.74976 3.00736 7.74976 4.25C7.74976 5.49264 8.75712 6.5 9.99976 6.5C11.2424 6.5 12.2498 5.49264 12.2498 4.25C12.2498 3.00736 11.2424 2 9.99976 2ZM4.84801 4.82715C4.14054 4.56536 3.35102 4.89465 3.03922 5.58155C2.69721 6.33501 3.05992 7.22096 3.83212 7.51826L6.99966 8.73778V11.138L5.28425 15.8677C5.0077 16.6302 5.37225 17.4762 6.1164 17.7989C6.92231 18.1484 7.85659 17.7514 8.16437 16.9287L9.67583 12.8883C9.78878 12.5864 10.2157 12.5858 10.3294 12.8875L11.8435 16.9033C12.1592 17.7404 13.123 18.1287 13.9309 17.7442C14.6419 17.4058 14.9794 16.5826 14.7108 15.8424L12.9997 11.1279V8.73463L16.1442 7.54243C16.8667 7.2685 17.2426 6.47172 16.9947 5.73989C16.736 4.97637 15.8994 4.57563 15.1423 4.85262L13.1944 5.56529C13.0786 5.60766 12.9825 5.69135 12.9246 5.80026C12.368 6.84799 11.2666 7.55966 9.99966 7.55966C8.72667 7.55966 7.6207 6.84111 7.0667 5.78514C7.00928 5.67569 6.91336 5.59139 6.79745 5.5485L4.84801 4.82715Z " },
            { FluentSymbol.Accessibility20, "M10.0002 2C8.61953 2 7.50024 3.11929 7.50024 4.5C7.50024 4.74818 7.53641 4.98791 7.60375 5.21422L5.36496 4.36707C4.49533 4.03801 3.52039 4.44834 3.1478 5.30023C2.74917 6.21165 3.19161 7.27142 4.11996 7.62884L7.00025 8.73776V11.138L5.35901 15.6632C5.04073 16.5407 5.46847 17.5135 6.33032 17.8721C7.24854 18.2542 8.30004 17.7938 8.64219 16.86L10.0015 13.15L11.3654 16.8532C11.7196 17.8148 12.8221 18.2656 13.7485 17.8278C14.5629 17.4429 14.9506 16.5014 14.6433 15.6547L13.0003 11.1278V8.73462L15.8685 7.64715C16.7451 7.3148 17.2054 6.35189 16.9135 5.46104C16.602 4.51061 15.5601 4.01263 14.6249 4.36724L12.3974 5.2119C12.4643 4.98627 12.5002 4.74733 12.5002 4.5C12.5002 3.11929 11.381 2 10.0002 2ZM8.50024 4.5C8.50024 3.67157 9.17182 3 10.0002 3C10.8287 3 11.5002 3.67157 11.5002 4.5C11.5002 5.32843 10.8287 6 10.0002 6C9.17182 6 8.50024 5.32843 8.50024 4.5ZM14.9795 5.30228C15.3814 5.14985 15.8293 5.3639 15.9632 5.77243C16.0886 6.15535 15.8908 6.56924 15.514 6.71209L12.323 7.92194C12.1287 7.99559 12.0003 8.1817 12.0003 8.38946V11.2158C12.0003 11.2739 12.0104 11.3317 12.0303 11.3864L13.7033 15.9959C13.8345 16.3574 13.669 16.7594 13.3213 16.9237C12.9257 17.1106 12.455 16.9181 12.3038 16.5076L10.9337 12.7877C10.6142 11.9201 9.38671 11.9212 9.06863 12.7893L7.70323 16.516C7.5569 16.9154 7.1072 17.1122 6.7145 16.9488C6.3459 16.7954 6.16297 16.3794 6.29909 16.0041L7.97029 11.3963C7.99011 11.3417 8.00025 11.284 8.00025 11.2258V8.39449C8.00025 8.18767 7.87291 8.00219 7.6799 7.92788L4.47926 6.69562C4.08271 6.54294 3.89372 6.09026 4.064 5.70095C4.22315 5.33707 4.6396 5.16179 5.01106 5.30235L9.11474 6.85516C9.68542 7.0711 10.3154 7.07088 10.8859 6.85454L14.9795 5.30228Z " },
            { FluentSymbol.Accessibility24Filled, "M11.9998 1.9978C10.619 1.9978 9.49976 3.11709 9.49976 4.4978C9.49976 5.87851 10.619 6.9978 11.9998 6.9978C13.3805 6.9978 14.4998 5.87851 14.4998 4.4978C14.4998 3.11709 13.3805 1.9978 11.9998 1.9978ZM20.3437 6.51646C19.9872 5.4324 18.8008 4.86219 17.7317 5.26104L16.1251 5.86037C15.942 5.92866 15.7928 6.0657 15.7093 6.24233C15.054 7.62738 13.6449 8.58293 12.0141 8.58293C10.3871 8.58293 8.98075 7.63183 8.3235 6.25196C8.23976 6.07616 8.09093 5.93982 7.90848 5.87177L6.2795 5.2642C5.20486 4.86339 4.01349 5.4433 3.666 6.53634C3.34966 7.53136 3.84923 8.6027 4.8148 8.99997L7.9997 10.3103V13.4582L6.02829 19.1714C5.67699 20.1895 6.21467 21.3001 7.23118 21.6559C8.2368 22.008 9.3392 21.4905 9.71091 20.492L11.5567 15.5336C11.7119 15.1169 12.301 15.116 12.4574 15.5322L14.3394 20.541C14.7377 21.6008 15.9548 22.0962 16.9799 21.6156C17.8781 21.1946 18.3142 20.1641 17.9911 19.2262L15.9997 13.4458V10.3115L19.195 9.00481C20.1717 8.60541 20.6733 7.51882 20.3437 6.51646Z " },
            { FluentSymbol.Accessibility24, "M9.04088 5.49274C9.01415 5.33173 9.00024 5.16639 9.00024 4.9978C9.00024 3.34095 10.3434 1.9978 12.0002 1.9978C13.6571 1.9978 15.0002 3.34095 15.0002 4.9978C15.0002 5.16692 14.9862 5.33277 14.9594 5.49426L17.3909 4.58718C18.6464 4.11884 20.0394 4.78922 20.4566 6.06257C20.8355 7.21879 20.2727 8.47347 19.1572 8.95935L16.0002 10.3345V13.4458L17.8833 18.9116C18.2679 20.0281 17.7509 21.2553 16.6832 21.7599C15.4514 22.342 13.9857 21.7403 13.5182 20.4606L12.0032 16.3134L10.4906 20.4632C10.0379 21.7052 8.64046 22.3183 7.41999 21.8105C6.28873 21.3397 5.71865 20.0704 6.11833 18.9121L8.00024 13.4582V10.3386L4.6935 8.88273C3.50787 8.36072 2.96841 6.97758 3.48753 5.79067C3.98732 4.64795 5.29285 4.09483 6.46145 4.53069L9.04088 5.49274ZM10.5002 4.9978C10.5002 5.61126 10.8685 6.13871 11.396 6.37114C11.7787 6.51245 12.1985 6.51556 12.5828 6.38047C13.1219 6.15306 13.5002 5.61961 13.5002 4.9978C13.5002 4.16938 12.8287 3.4978 12.0002 3.4978C11.1718 3.4978 10.5002 4.16938 10.5002 4.9978ZM10.8297 7.76087L5.93726 5.93612C5.51467 5.7785 5.04257 5.97852 4.86183 6.39175C4.67411 6.82096 4.86919 7.32113 5.29794 7.50991L9.05246 9.16296C9.32459 9.28278 9.50024 9.55204 9.50024 9.84938V13.584C9.50024 13.6672 9.48638 13.7499 9.45922 13.8286L7.53628 19.4014C7.39505 19.8107 7.5965 20.2592 7.99626 20.4256C8.42754 20.605 8.92136 20.3884 9.08134 19.9495L10.7312 15.4231C11.1637 14.2367 12.8413 14.2361 13.2746 15.4222L14.9271 19.946C15.0918 20.3968 15.6083 20.6088 16.0422 20.4037C16.4184 20.2259 16.6006 19.7936 16.4651 19.4002L14.5411 13.8157C14.5141 13.7371 14.5002 13.6545 14.5002 13.5714V9.84309C14.5002 9.54468 14.6772 9.27466 14.9507 9.15549L18.5582 7.58415C18.9642 7.40728 19.1691 6.95055 19.0312 6.52965C18.8793 6.06612 18.3722 5.82209 17.9152 5.99258L13.1342 7.77607C12.7844 7.91902 12.4015 7.9978 12.0002 7.9978C11.585 7.9978 11.1894 7.91342 10.8297 7.76087Z " },
            { FluentSymbol.Accessibility28Filled, "M14 2C12.3429 2 10.9995 3.34337 10.9995 5.00049C10.9995 6.65762 12.3429 8.00099 14 8.00099C15.6571 8.00099 17.0005 6.65762 17.0005 5.00049C17.0005 3.34337 15.6571 2 14 2ZM24.5337 7.06482C24.1533 5.86234 22.8409 5.22618 21.6613 5.6724L18.3942 6.90822C18.229 6.97072 18.0911 7.0895 18.0048 7.24366C17.2192 8.64743 15.7195 9.59365 13.9999 9.59365C12.3038 9.59365 10.8218 8.67326 10.0276 7.30109C9.93959 7.14895 9.80092 7.03254 9.63582 6.97217L6.20529 5.71783C5.13789 5.32754 3.95163 5.83996 3.50408 6.88464C3.02657 7.99922 3.56991 9.28747 4.70138 9.72345L9.49939 11.5722V15.7162L6.91853 22.8445C6.51016 23.9725 7.04568 25.2239 8.14355 25.7072C9.3364 26.2324 10.726 25.6525 11.1916 24.4351L13.1521 19.3096C13.4588 18.5076 14.5914 18.502 14.906 19.301L16.958 24.5118C17.459 25.7842 18.9759 26.3113 20.1579 25.6236C21.0922 25.0801 21.5029 23.9455 21.1331 22.9299L18.5004 15.7004V11.568L23.2166 9.78271C24.3074 9.36984 24.8855 8.17676 24.5337 7.06482Z " },
            { FluentSymbol.Accessibility28, "M10.6051 6.35708C10.5361 6.08297 10.4995 5.79601 10.4995 5.50049C10.4995 3.56722 12.0667 2 14 2C15.9333 2 17.5005 3.56722 17.5005 5.50049C17.5005 5.79722 17.4636 6.08532 17.3941 6.36045L20.9499 5.01209C22.3534 4.47991 23.917 5.22724 24.3844 6.65357C24.8226 7.991 24.1312 9.43655 22.815 9.93479L18.5005 11.5679V15.7004L20.9747 22.4945C21.4375 23.7655 20.8561 25.1798 19.6331 25.7578C18.243 26.4147 16.5887 25.7382 16.0573 24.2954L14.0097 18.7361L11.9696 24.3042C11.456 25.7061 9.8774 26.3972 8.4989 25.8236C7.20554 25.2854 6.5633 23.826 7.0402 22.5088L9.4995 15.7162V11.5722L5.18104 9.90822C3.78786 9.37141 3.12407 7.78081 3.72235 6.41291C4.28166 5.1341 5.74519 4.51813 7.05063 5.0121L10.6051 6.35708ZM12.0005 5.50049C12.0005 6.36399 12.5479 7.09965 13.3146 7.37942C13.7276 7.5129 14.1698 7.52384 14.5876 7.41225C15.4052 7.16126 15.9995 6.40029 15.9995 5.50049C15.9995 4.3962 15.1043 3.50099 14 3.50099C12.8957 3.50099 12.0005 4.3962 12.0005 5.50049ZM12.8092 8.79323C12.7655 8.77851 12.722 8.76297 12.6788 8.7466L6.51943 6.41595C5.96173 6.20492 5.3365 6.46807 5.09755 7.01439C4.84196 7.59876 5.12554 8.27828 5.72072 8.50761L10.5198 10.3568C10.8094 10.4684 11.0005 10.7468 11.0005 11.0571V15.8479C11.0005 15.935 10.9853 16.0214 10.9557 16.1034L8.45153 23.0198C8.24752 23.5833 8.52226 24.2076 9.07554 24.4378C9.66525 24.6832 10.3405 24.3876 10.5603 23.7878L12.6096 18.1947C13.087 16.8916 14.9294 16.89 15.409 18.1923L17.4658 23.7766C17.6926 24.3923 18.3986 24.6811 18.9918 24.4007C19.5137 24.1541 19.7618 23.5505 19.5643 23.0081L17.0448 16.0896C17.0148 16.0073 16.9995 15.9204 16.9995 15.8328V11.0496C16.9995 10.7376 17.1925 10.4581 17.4843 10.3477L22.2836 8.531C22.8492 8.31689 23.1464 7.6957 22.958 7.12096C22.7572 6.50802 22.0852 6.18687 21.4821 6.41556L15.3373 8.74567C15.2323 8.78546 15.126 8.82038 15.0188 8.85043C14.6964 8.94834 14.3544 9.00099 14 9.00099C13.5819 9.00099 13.1809 8.92768 12.8092 8.79323Z " },
            { FluentSymbol.Accessibility32Filled, "M16 2C13.7909 2 12 3.79086 12 6C12 8.20914 13.7909 10 16 10C18.2091 10 20 8.20914 20 6C20 3.79086 18.2091 2 16 2ZM28.0169 8.28906C27.4036 6.92952 25.8421 6.27726 24.444 6.79662L22.6556 7.46094C22.3744 7.56541 22.1549 7.79062 22.0577 8.07445C21.1956 10.5927 18.8077 12.4009 16.0001 12.4009C13.1926 12.4009 10.8047 10.5928 9.94257 8.07452C9.8454 7.7907 9.62593 7.56549 9.3447 7.46102L7.60361 6.81427C6.17442 6.28337 4.58235 6.98688 4.01265 8.40105C3.44506 9.80997 4.09774 11.4151 5.48749 12.0281L10.0001 14.0186L10.0001 19.825L7.58022 26.2498C7.09389 27.541 7.70245 28.9871 8.96571 29.5421C10.2787 30.1189 11.8107 29.5219 12.3873 28.2088L15.4232 21.2949C15.6259 20.8331 16.283 20.8389 16.4777 21.3041L19.3519 28.1721C19.9688 29.6464 21.724 30.2654 23.1293 29.5042C24.3135 28.8628 24.8441 27.447 24.3732 26.1853L22.0001 19.8266L22.0001 14.0167L26.5513 12.061C28.0087 11.4347 28.6691 9.73497 28.0169 8.28906Z " },
            { FluentSymbol.Accessibility32, "M16 2C13.5147 2 11.5 4.01472 11.5 6.5C11.5 6.8755 11.546 7.24025 11.6326 7.58894L7.95473 6.19723C6.35563 5.59215 4.5629 6.34667 3.87777 7.91314C3.15923 9.55601 3.92593 11.469 5.58022 12.1608L9.9999 14.0092V18.7926L7.68332 25.7512C7.15169 27.3482 7.94295 29.0846 9.49688 29.7312C11.1807 30.4319 13.1093 29.5917 13.7428 27.8815L15.9851 21.8282L18.2348 27.8761C18.8905 29.6389 20.9144 30.4627 22.6149 29.6591C24.0797 28.9668 24.799 27.2915 24.2921 25.7527L21.9999 18.7942V14.0026L26.3684 12.1908C27.9248 11.5453 28.7216 9.81022 28.197 8.20905C27.6245 6.46205 25.7093 5.5467 23.9904 6.19852L20.3719 7.57064C20.4556 7.2275 20.5 6.86893 20.5 6.5C20.5 4.01472 18.4853 2 16 2ZM13.5 6.5C13.5 5.11929 14.6193 4 16 4C17.3807 4 18.5 5.11929 18.5 6.5C18.5 7.88071 17.3807 9 16 9C14.6193 9 13.5 7.88071 13.5 6.5ZM24.6995 8.06859C25.352 7.82114 26.0791 8.16863 26.2964 8.83183C26.4956 9.43966 26.1931 10.0984 25.6022 10.3434L20.6168 12.411C20.2434 12.5659 19.9999 12.9304 19.9999 13.3347V18.9546C19.9999 19.0609 20.0168 19.1665 20.0501 19.2675L22.3925 26.3784C22.5835 26.9585 22.3124 27.5899 21.7603 27.8509C21.1193 28.1538 20.3565 27.8433 20.1093 27.1788L17.7267 20.7736C17.1258 19.1584 14.8406 19.16 14.242 20.776L11.8673 27.1868C11.6283 27.832 10.9006 28.1491 10.2652 27.8847C9.67889 27.6407 9.38033 26.9855 9.58093 26.383L11.9487 19.2705C11.9826 19.1686 11.9999 19.062 11.9999 18.9546V13.3435C11.9999 12.9403 11.7577 12.5765 11.3857 12.4209L6.35188 10.3157C5.72833 10.0549 5.43933 9.33383 5.71017 8.71458C5.96842 8.12412 6.64416 7.83972 7.24692 8.0678L14.3907 10.771C15.417 11.1593 16.5498 11.1589 17.5758 10.7698L24.6995 8.06859Z " },
            { FluentSymbol.Add12Filled, "M5.89823 2.00685L6 2C6.3797 2 6.69349 2.28215 6.74315 2.64823L6.75 2.75V5.249L9.25 5.25C9.6297 5.25 9.94349 5.53215 9.99315 5.89823L10 6C10 6.3797 9.71785 6.69349 9.35177 6.74315L9.25 6.75L6.75 6.749V9.25C6.75 9.6297 6.46785 9.94349 6.10177 9.99315L6 10C5.6203 10 5.30651 9.71785 5.25685 9.35177L5.25 9.25V6.749L2.75 6.75C2.3703 6.75 2.05651 6.46785 2.00685 6.10177L2 6C2 5.6203 2.28215 5.30651 2.64823 5.25685L2.75 5.25L5.25 5.249V2.75C5.25 2.3703 5.53215 2.05651 5.89823 2.00685L6 2L5.89823 2.00685Z " },
            { FluentSymbol.Add12, "M5.91012 2.00806L6 2C6.24546 2 6.44961 2.17688 6.49194 2.41012L6.5 2.5V5.5H9.5C9.74546 5.5 9.94961 5.67688 9.99194 5.91012L10 6C10 6.24546 9.82312 6.44961 9.58988 6.49194L9.5 6.5H6.5V9.5C6.5 9.74546 6.32312 9.94961 6.08988 9.99194L6 10C5.75454 10 5.55039 9.82312 5.50806 9.58988L5.5 9.5V6.5H2.5C2.25454 6.5 2.05039 6.32312 2.00806 6.08988L2 6C2 5.75454 2.17688 5.55039 2.41012 5.50806L2.5 5.5H5.5V2.5C5.5 2.25454 5.67688 2.05039 5.91012 2.00806Z " },
            { FluentSymbol.Add16Filled, "M7.89823 3.00685L8 3C8.3797 3 8.69349 3.28215 8.74315 3.64823L8.75 3.75V7.25H12.25C12.6297 7.25 12.9435 7.53215 12.9932 7.89823L13 8C13 8.3797 12.7178 8.69349 12.3518 8.74315L12.25 8.75H8.75V12.25C8.75 12.6297 8.46785 12.9435 8.10177 12.9932L8 13C7.6203 13 7.30651 12.7178 7.25685 12.3518L7.25 12.25V8.75H3.75C3.3703 8.75 3.05651 8.46785 3.00685 8.10177L3 8C3 7.6203 3.28215 7.30651 3.64823 7.25685L3.75 7.25H7.25V3.75C7.25 3.3703 7.53215 3.05651 7.89823 3.00685L8 3L7.89823 3.00685Z " },
            { FluentSymbol.Add16, "M7.91012 3.00806L8 3C8.24546 3 8.44961 3.17688 8.49194 3.41012L8.5 3.5V7.5H12.5C12.7455 7.5 12.9496 7.67688 12.9919 7.91012L13 8C13 8.24546 12.8231 8.44961 12.5899 8.49194L12.5 8.5H8.5V12.5C8.5 12.7455 8.32312 12.9496 8.08988 12.9919L8 13C7.75454 13 7.55039 12.8231 7.50806 12.5899L7.5 12.5V8.5H3.5C3.25454 8.5 3.05039 8.32312 3.00806 8.08988L3 8C3 7.75454 3.17688 7.55039 3.41012 7.50806L3.5 7.5H7.5V3.5C7.5 3.25454 7.67688 3.05039 7.91012 3.00806L8 3L7.91012 3.00806Z " },
            { FluentSymbol.Add20Filled, "M9.25 16.25C9.25 16.6642 9.58579 17 10 17C10.4142 17 10.75 16.6642 10.75 16.25V10.75H16.25C16.6642 10.75 17 10.4142 17 10C17 9.58579 16.6642 9.25 16.25 9.25H10.75V3.75C10.75 3.33579 10.4142 3 10 3C9.58579 3 9.25 3.33579 9.25 3.75V9.25H3.75C3.33579 9.25 3 9.58579 3 10C3 10.4142 3.33579 10.75 3.75 10.75H9.25V16.25Z " },
            { FluentSymbol.Add20, "M9.5 16.5C9.5 16.7761 9.72386 17 10 17C10.2761 17 10.5 16.7761 10.5 16.5V10.5H16.5C16.7761 10.5 17 10.2761 17 10C17 9.72386 16.7761 9.5 16.5 9.5H10.5V3.5C10.5 3.22386 10.2761 3 10 3C9.72386 3 9.5 3.22386 9.5 3.5V9.5H3.5C3.22386 9.5 3 9.72386 3 10C3 10.2761 3.22386 10.5 3.5 10.5H9.5V16.5Z " },
            { FluentSymbol.Add24Filled, "M11.8834 3.00673L12 3C12.5128 3 12.9355 3.38604 12.9933 3.88338L13 4V11H20C20.5128 11 20.9355 11.386 20.9933 11.8834L21 12C21 12.5128 20.614 12.9355 20.1166 12.9933L20 13H13V20C13 20.5128 12.614 20.9355 12.1166 20.9933L12 21C11.4872 21 11.0645 20.614 11.0067 20.1166L11 20V13H4C3.48716 13 3.06449 12.614 3.00673 12.1166L3 12C3 11.4872 3.38604 11.0645 3.88338 11.0067L4 11H11V4C11 3.48716 11.386 3.06449 11.8834 3.00673L12 3L11.8834 3.00673Z " },
            { FluentSymbol.Add24, "M11.7498 3C12.1295 3 12.4434 3.28201 12.4931 3.64808L12.5 3.74985L12.5012 11H19.7543C20.1685 11 20.5043 11.3358 20.5043 11.75C20.5043 12.1297 20.2221 12.4435 19.8561 12.4932L19.7543 12.5H12.5012L12.5032 19.7491C12.5033 20.1633 12.1676 20.4993 11.7534 20.4993C11.3737 20.4993 11.0598 20.2173 11.0101 19.8512L11.0032 19.7494L11.0012 12.5H3.7522C3.33798 12.5 3.0022 12.1642 3.0022 11.75C3.0022 11.3703 3.28435 11.0565 3.65043 11.0068L3.7522 11H11.0012L11 3.75015C10.9999 3.33594 11.3356 3 11.7498 3Z " },
            { FluentSymbol.Add28Filled, "M24 13H15V4C15 3.447 14.553 3 14 3C13.447 3 13 3.447 13 4V13H4C3.447 13 3 13.447 3 14C3 14.553 3.447 15 4 15H13V24C13 24.553 13.447 25 14 25C14.553 25 15 24.553 15 24V15H24C24.553 15 25 14.553 25 14C25 13.447 24.553 13 24 13Z " },
            { FluentSymbol.Add28, "M14.5 13.0001V3.75391C14.5 3.33991 14.164 3.00391 13.75 3.00391C13.336 3.00391 13 3.33991 13 3.75391V13.0001H3.75388C3.33988 13.0001 3.00388 13.3361 3.00388 13.7501C3.00388 14.1641 3.33988 14.5001 3.75388 14.5001H13V23.7525C13 24.1665 13.336 24.5025 13.75 24.5025C14.164 24.5025 14.5 24.1665 14.5 23.7525V14.5001L23.7498 14.5032C24.1638 14.5032 24.4998 14.1672 24.4998 13.7532C24.4998 13.3392 24.1638 13.0032 23.7498 13.0032L14.5 13.0001Z " },
            { FluentSymbol.AddCircle16Filled, "M2 8C2 4.68629 4.68629 2 8 2C11.3137 2 14 4.68629 14 8C14 11.3137 11.3137 14 8 14C4.68629 14 2 11.3137 2 8ZM8 5C7.72386 5 7.5 5.22386 7.5 5.5V7.5H5.5C5.22386 7.5 5 7.72386 5 8C5 8.27614 5.22386 8.5 5.5 8.5H7.5V10.5C7.5 10.7761 7.72386 11 8 11C8.27614 11 8.5 10.7761 8.5 10.5V8.5H10.5C10.7761 8.5 11 8.27614 11 8C11 7.72386 10.7761 7.5 10.5 7.5H8.5V5.5C8.5 5.22386 8.27614 5 8 5Z " },
            { FluentSymbol.AddCircle16, "M8 5C8.27614 5 8.5 5.22386 8.5 5.5V7.5H10.5C10.7761 7.5 11 7.72386 11 8C11 8.27614 10.7761 8.5 10.5 8.5H8.5V10.5C8.5 10.7761 8.27614 11 8 11C7.72386 11 7.5 10.7761 7.5 10.5V8.5H5.5C5.22386 8.5 5 8.27614 5 8C5 7.72386 5.22386 7.5 5.5 7.5H7.5V5.5C7.5 5.22386 7.72386 5 8 5ZM2 8C2 4.68629 4.68629 2 8 2C11.3137 2 14 4.68629 14 8C14 11.3137 11.3137 14 8 14C4.68629 14 2 11.3137 2 8ZM8 3C5.23858 3 3 5.23858 3 8C3 10.7614 5.23858 13 8 13C10.7614 13 13 10.7614 13 8C13 5.23858 10.7614 3 8 3Z " },
            { FluentSymbol.AddCircle20Filled, "M18 10C18 14.4183 14.4183 18 10 18C5.58172 18 2 14.4183 2 10C2 5.58172 5.58172 2 10 2C14.4183 2 18 5.58172 18 10ZM6 10C6 10.2761 6.22386 10.5 6.5 10.5H9.5V13.5C9.5 13.7761 9.72386 14 10 14C10.2761 14 10.5 13.7761 10.5 13.5V10.5H13.5C13.7761 10.5 14 10.2761 14 10C14 9.72386 13.7761 9.5 13.5 9.5H10.5V6.5C10.5 6.22386 10.2761 6 10 6C9.72386 6 9.5 6.22386 9.5 6.5V9.5H6.5C6.22386 9.5 6 9.72386 6 10Z " },
            { FluentSymbol.AddCircle20, "M6 10C6 9.72386 6.22386 9.5 6.5 9.5H9.5V6.5C9.5 6.22386 9.72386 6 10 6C10.2761 6 10.5 6.22386 10.5 6.5V9.5H13.5C13.7761 9.5 14 9.72386 14 10C14 10.2761 13.7761 10.5 13.5 10.5H10.5V13.5C10.5 13.7761 10.2761 14 10 14C9.72386 14 9.5 13.7761 9.5 13.5V10.5H6.5C6.22386 10.5 6 10.2761 6 10Z M10 18C14.4183 18 18 14.4183 18 10C18 5.58172 14.4183 2 10 2C5.58172 2 2 5.58172 2 10C2 14.4183 5.58172 18 10 18ZM10 17C6.13401 17 3 13.866 3 10C3 6.13401 6.13401 3 10 3C13.866 3 17 6.13401 17 10C17 13.866 13.866 17 10 17Z " },
            { FluentSymbol.AddCircle24Filled, "M12 2C17.5228 2 22 6.47715 22 12C22 17.5228 17.5228 22 12 22C6.47715 22 2 17.5228 2 12C2 6.47715 6.47715 2 12 2ZM12 7C11.6203 7 11.3065 7.28215 11.2568 7.64823L11.25 7.75V11.25H7.75C7.33579 11.25 7 11.5858 7 12C7 12.3797 7.28215 12.6935 7.64823 12.7432L7.75 12.75H11.25V16.25C11.25 16.6642 11.5858 17 12 17C12.3797 17 12.6935 16.7178 12.7432 16.3518L12.75 16.25V12.75H16.25C16.6642 12.75 17 12.4142 17 12C17 11.6203 16.7178 11.3065 16.3518 11.2568L16.25 11.25H12.75V7.75C12.75 7.33579 12.4142 7 12 7Z " },
            { FluentSymbol.AddCircle24, "M12 2C17.5228 2 22 6.47715 22 12C22 17.5228 17.5228 22 12 22C6.47715 22 2 17.5228 2 12C2 6.47715 6.47715 2 12 2ZM12 3.5C7.30558 3.5 3.5 7.30558 3.5 12C3.5 16.6944 7.30558 20.5 12 20.5C16.6944 20.5 20.5 16.6944 20.5 12C20.5 7.30558 16.6944 3.5 12 3.5ZM12 7C12.4142 7 12.75 7.33579 12.75 7.75V11.25H16.25C16.6642 11.25 17 11.5858 17 12C17 12.4142 16.6642 12.75 16.25 12.75H12.75V16.25C12.75 16.6642 12.4142 17 12 17C11.5858 17 11.25 16.6642 11.25 16.25V12.75H7.75C7.33579 12.75 7 12.4142 7 12C7 11.5858 7.33579 11.25 7.75 11.25H11.25V7.75C11.25 7.33579 11.5858 7 12 7Z " },
            { FluentSymbol.AddCircle28Filled, "M14 2C20.6274 2 26 7.37258 26 14C26 20.6274 20.6274 26 14 26C7.37258 26 2 20.6274 2 14C2 7.37258 7.37258 2 14 2ZM14 8C13.6203 8 13.3065 8.28215 13.2568 8.64823L13.25 8.75V13.25H8.75C8.33579 13.25 8 13.5858 8 14C8 14.3797 8.28215 14.6935 8.64823 14.7432L8.75 14.75H13.25V19.25C13.25 19.6642 13.5858 20 14 20C14.3797 20 14.6935 19.7178 14.7432 19.3518L14.75 19.25V14.75H19.25C19.6642 14.75 20 14.4142 20 14C20 13.6203 19.7178 13.3065 19.3518 13.2568L19.25 13.25H14.75V8.75C14.75 8.33579 14.4142 8 14 8Z " },
            { FluentSymbol.AddCircle28, "M14 2C20.6274 2 26 7.37258 26 14C26 20.6274 20.6274 26 14 26C7.37258 26 2 20.6274 2 14C2 7.37258 7.37258 2 14 2ZM14 3.5C8.20101 3.5 3.5 8.20101 3.5 14C3.5 19.799 8.20101 24.5 14 24.5C19.799 24.5 24.5 19.799 24.5 14C24.5 8.20101 19.799 3.5 14 3.5ZM14 8C14.4142 8 14.75 8.33579 14.75 8.75V13.25H19.25C19.6642 13.25 20 13.5858 20 14C20 14.4142 19.6642 14.75 19.25 14.75H14.75V19.25C14.75 19.6642 14.4142 20 14 20C13.5858 20 13.25 19.6642 13.25 19.25V14.75H8.75C8.33579 14.75 8 14.4142 8 14C8 13.5858 8.33579 13.25 8.75 13.25H13.25V8.75C13.25 8.33579 13.5858 8 14 8Z " },
            { FluentSymbol.AddCircle32Filled, "M16 30C23.732 30 30 23.732 30 16C30 8.26801 23.732 2 16 2C8.26801 2 2 8.26801 2 16C2 23.732 8.26801 30 16 30ZM15 11C15 10.4477 15.4477 10 16 10C16.5523 10 17 10.4477 17 11V15H21C21.5523 15 22 15.4477 22 16C22 16.5523 21.5523 17 21 17H17V21C17 21.5523 16.5523 22 16 22C15.4477 22 15 21.5523 15 21V17H11C10.4477 17 10 16.5523 10 16C10 15.4477 10.4477 15 11 15H15V11Z " },
            { FluentSymbol.AddCircle32, "M15 11C15 10.4477 15.4477 10 16 10C16.5523 10 17 10.4477 17 11V15H21C21.5523 15 22 15.4477 22 16C22 16.5523 21.5523 17 21 17H17V21C17 21.5523 16.5523 22 16 22C15.4477 22 15 21.5523 15 21V17H11C10.4477 17 10 16.5523 10 16C10 15.4477 10.4477 15 11 15H15V11ZM30 16C30 23.732 23.732 30 16 30C8.26801 30 2 23.732 2 16C2 8.26801 8.26801 2 16 2C23.732 2 30 8.26801 30 16ZM28 16C28 9.37258 22.6274 4 16 4C9.37258 4 4 9.37258 4 16C4 22.6274 9.37258 28 16 28C22.6274 28 28 22.6274 28 16Z " },
            { FluentSymbol.AddSquare24Filled, "M3 6.25C3 4.45507 4.45507 3 6.25 3H17.75C19.5449 3 21 4.45507 21 6.25V17.75C21 19.5449 19.5449 21 17.75 21H6.25C4.45507 21 3 19.5449 3 17.75V6.25ZM12.75 7.75C12.75 7.33579 12.4142 7 12 7C11.5858 7 11.25 7.33579 11.25 7.75V11.25H7.75C7.33579 11.25 7 11.5858 7 12C7 12.4142 7.33579 12.75 7.75 12.75H11.25V16.25C11.25 16.6642 11.5858 17 12 17C12.4142 17 12.75 16.6642 12.75 16.25V12.75H16.25C16.6642 12.75 17 12.4142 17 12C17 11.5858 16.6642 11.25 16.25 11.25H12.75V7.75Z " },
            { FluentSymbol.AddSquare24, "M12 7C12.4142 7 12.75 7.33579 12.75 7.75V11.25H16.25C16.6642 11.25 17 11.5858 17 12C17 12.4142 16.6642 12.75 16.25 12.75H12.75V16.25C12.75 16.6642 12.4142 17 12 17C11.5858 17 11.25 16.6642 11.25 16.25V12.75H7.75C7.33579 12.75 7 12.4142 7 12C7 11.5858 7.33579 11.25 7.75 11.25H11.25V7.75C11.25 7.33579 11.5858 7 12 7Z M3 6.25C3 4.45507 4.45507 3 6.25 3H17.75C19.5449 3 21 4.45507 21 6.25V17.75C21 19.5449 19.5449 21 17.75 21H6.25C4.45507 21 3 19.5449 3 17.75V6.25ZM6.25 4.5C5.2835 4.5 4.5 5.2835 4.5 6.25V17.75C4.5 18.7165 5.2835 19.5 6.25 19.5H17.75C18.7165 19.5 19.5 18.7165 19.5 17.75V6.25C19.5 5.2835 18.7165 4.5 17.75 4.5H6.25Z " },
            { FluentSymbol.Airplane20Filled, "M9 2C9.60747 2 10.1573 2.35961 10.4008 2.91616L12.768 8.326L16.0039 8.12476C17.0396 8.06003 17.9316 8.84713 17.9963 9.8828L18 10C18 11.0377 17.1588 11.8789 16.1211 11.8789L16.0039 11.8752L12.768 11.673L10.4008 17.0838C10.1573 17.6404 9.60747 18 9 18C8.51245 18 8.11722 17.6048 8.11722 17.1172L8.11892 17.0624L8.822 11.426L6.364 11.272L5.22361 13.5528C5.08657 13.8269 4.80643 14 4.5 14C4.22386 14 4 13.7761 4 13.5V11.124L2.93762 11.0586C2.41059 11.0257 2 10.5886 2 10.0605V9.93945C2 9.41139 2.41059 8.97434 2.93762 8.9414L4 8.875V6.5C4 6.22386 4.22386 6 4.5 6C4.80643 6 5.08657 6.17313 5.22361 6.44721L6.363 8.727L8.822 8.573L8.12403 2.99228C8.06356 2.5085 8.40672 2.06729 8.8905 2.00682C8.92683 2.00228 8.9634 2 9 2Z " },
            { FluentSymbol.Airplane20, "M8.78197 8.28958L8.09689 2.80623C8.01728 2.16938 8.46901 1.58858 9.10586 1.50897L9.17779 1.50225L9.34598 1.5C9.94193 1.5 10.4814 1.85279 10.7202 2.39879L13.2322 8.14109L15.9842 8.05025C17.012 8.01599 17.8807 8.7833 17.9887 9.78967L17.9989 9.93501L18 10C18 11.0774 17.1266 11.9508 16.0408 11.9508L13.2332 11.858L10.7202 17.6012C10.4814 18.1472 9.94193 18.5 9.34598 18.5H9.25C8.6082 18.5 8.08791 17.9797 8.08791 17.3379C8.08791 17.2897 8.09091 17.2416 8.09688 17.1938L8.78198 11.7094L6.63962 11.6378L5.68219 13.3139C5.43977 13.7382 4.98862 14 4.5 14C3.94772 14 3.5 13.5523 3.5 13V11.5336L3.33875 11.5215C2.58109 11.4252 2 10.7786 2 10C2 9.22141 2.58109 8.57483 3.33792 8.47851L3.5 8.46635V7C3.5 6.44772 3.94772 6 4.5 6C4.98862 6 5.43977 6.26181 5.68218 6.68603L6.63955 8.36121L8.78197 8.28958ZM9.34598 2.5L9.2299 2.50125C9.14107 2.51236 9.07806 2.59336 9.08917 2.68222L9.91004 9.25242L6.07045 9.38079L4.81395 7.18219C4.74957 7.06953 4.62976 7 4.5 7V9.43165L3.5161 9.46641C3.22833 9.476 3 9.71206 3 10C3 10.2879 3.22833 10.524 3.5161 10.5336L4.5 10.5664V13L4.5763 12.9919C4.67546 12.9705 4.76244 12.908 4.81391 12.8179L6.07038 10.6182L9.91002 10.7466L9.08791 17.3379C9.08791 17.4274 9.16048 17.5 9.25 17.5H9.34598C9.54463 17.5 9.72444 17.3824 9.80407 17.2004L12.5888 10.836L16.0492 10.9508C16.5743 10.9508 17 10.5251 17 10L16.9995 9.96832C16.982 9.44348 16.5423 9.0322 16.0173 9.0497L12.5878 9.16291L9.80406 2.79959C9.72444 2.6176 9.54463 2.5 9.34598 2.5Z " },
            { FluentSymbol.Airplane24Filled, "M21.989 11.9463C21.989 13.0461 21.0974 13.9376 19.9977 13.9376C19.9783 13.9376 19.9589 13.9373 19.9395 13.9367L15.2007 13.7972L11.7473 20.9398C11.4696 21.5144 10.8876 21.8794 10.2494 21.8794C9.73798 21.8794 9.32339 21.4648 9.32339 20.9534C9.32339 20.9166 9.32559 20.8798 9.32998 20.8432L10.1922 13.6505L6.42663 13.5406L5.9366 14.8813C5.75076 15.3896 5.26715 15.7277 4.72591 15.7277C4.22816 15.7277 3.82466 15.3242 3.82466 14.8265L3.82536 13.3498L3.01461 13.181C2.42995 13.059 2.01105 12.5436 2.01105 11.9463C2.01105 11.3492 2.43013 10.834 3.01477 10.7124L3.82536 10.5437L3.82466 9.06617C3.82466 8.60672 4.16847 8.22756 4.61286 8.17195L4.72591 8.16493C5.26715 8.16493 5.75076 8.50304 5.9366 9.01138L6.42771 10.3518L10.1792 10.2418L9.32998 3.15735C9.32779 3.13906 9.32614 3.12071 9.32504 3.10233L9.32339 3.04711C9.32339 2.53568 9.73798 2.12109 10.2494 2.12109C10.8344 2.12109 11.3722 2.42784 11.6717 2.92154L11.7473 3.06073L15.15 10.0963L19.9395 9.95613C21.0386 9.92385 21.9558 10.7887 21.9881 11.8879L21.989 11.9463Z " },
            { FluentSymbol.Airplane24, "M9.46921 9.64329L8.76898 3.76852L8.76712 3.69493C8.76712 2.80631 9.48749 2.08594 10.3761 2.08594C11.1789 2.08594 11.9218 2.5056 12.3545 3.22035L12.4408 3.38102L15.3857 9.47005L19.3428 9.35423C20.7765 9.31213 21.9728 10.4402 22.0151 11.8848L22.016 11.9501C22.016 13.3844 20.8532 14.5472 19.3969 14.5469L15.4327 14.4308L12.4409 20.6191C12.058 21.4111 11.2558 21.9142 10.3761 21.9142C9.48749 21.9142 8.76712 21.1939 8.76745 20.2829L8.77396 20.1649L9.48083 14.2567L7.34875 14.1944L7.07985 14.9301C6.79933 15.6974 6.06936 16.2078 5.25238 16.2078C4.37644 16.2078 3.66636 15.4977 3.66636 14.6214L3.66672 13.8618L3.51168 13.8295C2.62169 13.6438 1.98401 12.8592 1.98401 11.9501C1.98401 11.0408 2.62216 10.2563 3.51223 10.0712L3.66672 10.0391L3.66636 9.27836C3.66636 8.47633 4.26448 7.80351 5.10101 7.7003L5.25238 7.69234C5.99732 7.69234 6.67525 8.11751 7.01684 8.81938L7.07966 8.96952L7.34929 9.70542L9.46921 9.64329ZM10.3761 3.58594C10.3159 3.58594 10.2671 3.63473 10.2668 3.67256L11.1532 11.0946L6.31273 11.2365L5.68532 9.52118L5.65277 9.44211C5.57841 9.28982 5.42298 9.19234 5.29887 9.1909L5.24064 9.19305C5.19905 9.19826 5.16636 9.23502 5.16636 9.278L5.1673 11.2588L3.81776 11.5398C3.62336 11.5802 3.48401 11.7515 3.48401 11.9501C3.48401 12.1489 3.6235 12.3206 3.81779 12.3611L5.1673 12.642L5.16636 14.6217C5.16636 14.6693 5.20487 14.7078 5.25238 14.7078C5.43954 14.7078 5.60677 14.5908 5.67102 14.4151L6.31127 12.6635L11.1652 12.8052L10.2683 20.2764L10.2671 20.3053C10.2671 20.3655 10.3159 20.4142 10.3761 20.4142C10.6804 20.4142 10.9579 20.2402 11.0904 19.9662L14.5053 12.903L19.4189 13.0472C20.0248 13.0472 20.5161 12.556 20.5161 11.9611L20.5155 11.9178C20.4978 11.3123 19.9924 10.8358 19.3868 10.8536L14.4583 10.9978L11.1066 4.06567L11.0542 3.96747C10.9109 3.73117 10.6538 3.58594 10.3761 3.58594Z " },
            { FluentSymbol.AirplaneTakeOff16Filled, "M8.30224 4.1498C8.38736 4.02083 8.48383 3.8829 8.59134 3.74151L8.60803 3.71965C8.85559 3.3967 9.16036 3.05727 9.51848 2.76655C9.91142 2.44756 10.3867 2.17308 10.9332 2.05789C11.1154 2.0195 11.3055 1.9988 11.5032 2.00005C12.8541 2.00862 13.875 2.93089 14.5013 3.70429C14.5796 3.80097 14.6517 3.89532 14.7175 3.98527L14.7454 4.02354C14.8124 4.11641 14.8654 4.21192 14.9052 4.30865L14.913 4.32802C15.1775 4.9998 14.8181 5.72586 14.2001 6.03338C14.1526 6.05704 14.1035 6.07821 14.0531 6.0967L11.8207 6.91501L8.71466 11.3959C7.77709 12.7484 5.66058 11.8225 6.01759 10.2159L6.33043 8.80818L3.22469 9.68343C2.10814 9.9981 1 9.15908 1 7.99904V5.16008C1 3.94928 2.63829 3.57347 3.16602 4.66321L3.77067 5.91179L7.20332 5.00846C7.63508 4.89484 8.01865 4.57951 8.30224 4.1498Z M4.34422 4.57319L4.44311 4.70079L6.94882 4.04139C7.08122 4.00655 7.28002 3.88323 7.46762 3.59897C7.55892 3.46063 7.66382 3.31007 7.78224 3.15346L6.50776 2.27963C6.2421 2.09748 5.92754 2 5.60543 2C4.27885 2 3.53156 3.52466 4.34422 4.57319Z M1.75 13.5C1.33579 13.5 1 13.8358 1 14.25C1 14.6642 1.33579 15 1.75 15H14.25C14.6642 15 15 14.6642 15 14.25C15 13.8358 14.6642 13.5 14.25 13.5H1.75Z " },
            { FluentSymbol.AirplaneTakeOff16, "M5.10878 5.55966L4.34422 4.57319C3.53156 3.52466 4.27885 2 5.60543 2C5.92754 2 6.2421 2.09748 6.50776 2.27963L8.60803 3.71965C8.85559 3.3967 9.16036 3.05727 9.51848 2.76654C10.0424 2.34123 10.7126 1.99504 11.5032 2.00005C13.0471 2.00984 14.16 3.21304 14.7454 4.02354C15.3177 4.81602 14.86 5.8009 14.0531 6.0967L11.8207 6.91501L8.71466 11.3959C7.77709 12.7484 5.66058 11.8225 6.01759 10.2159L6.33043 8.80818L3.22469 9.68343C2.10814 9.99809 1 9.15908 1 7.99904V5.16008C1 3.94928 2.63829 3.57347 3.16602 4.66321L3.77067 5.91179L5.10878 5.55966ZM5.13461 3.96059L6.15964 5.28312L7.20332 5.00846C7.49899 4.93065 7.77207 4.75825 8.00591 4.5193L5.94228 3.10439C5.84311 3.03639 5.72568 3 5.60543 3C5.11021 3 4.83124 3.56917 5.13461 3.96059ZM9.13686 4.70062C8.75774 5.27508 8.18958 5.78297 7.45781 5.97554L3.62725 6.98358C3.39607 7.04442 3.15418 6.93311 3.04999 6.71797L2.266 5.09907C2.24377 5.05316 2.21935 5.03727 2.20157 5.02954C2.17879 5.01962 2.14583 5.01511 2.1087 5.02363C2.07156 5.03215 2.04387 5.05057 2.02768 5.06943C2.01505 5.08413 2 5.10908 2 5.16008V7.99904C2 8.4962 2.47492 8.85578 2.95344 8.72092L6.05918 7.84567C6.78724 7.64049 7.47071 8.2867 7.30662 9.02511L6.99378 10.4329C6.87478 10.9684 7.58028 11.277 7.8928 10.8262L11.0891 6.2152C11.1478 6.13052 11.2312 6.06605 11.3279 6.03059L13.7089 5.1578C13.8498 5.10613 13.94 5.00476 13.9772 4.90302C14.0123 4.80717 14.0043 4.70545 13.9347 4.60904C13.3728 3.83112 12.5199 3.00652 11.4968 3.00003C11.0144 2.99698 10.5627 3.20688 10.1488 3.54292C9.73427 3.8794 9.38995 4.31713 9.13686 4.70062Z M1.5 14C1.22386 14 1 14.2239 1 14.5C1 14.7761 1.22386 15 1.5 15H14.5C14.7761 15 15 14.7761 15 14.5C15 14.2239 14.7761 14 14.5 14H1.5Z " },
            { FluentSymbol.AirplaneTakeOff20Filled, "M11.2987 5.48742C11.4033 5.39002 11.5301 5.27764 11.6762 5.15917C12.2594 4.68629 13.1501 4.11648 14.168 4.01563C14.2785 4.00468 14.3904 3.99926 14.5036 4.00008C14.6938 4.00146 14.8773 4.02092 15.0542 4.05548C16.2922 4.29746 17.2006 5.27993 17.7173 5.9855C18.3116 6.79722 17.8176 7.80548 16.9796 8.07653L12.801 9.42822L9.70311 13.434C8.73343 14.6879 6.73479 13.7766 7.04566 12.2223L7.3386 10.7575L4.3214 11.7998C3.18482 12.1925 2 11.3482 2 10.1457V7.16011C2 7.08443 2.0064 7.01202 2.01853 6.94302C2.17619 6.04605 3.30197 5.72632 3.92143 6.32205C4.01674 6.4137 4.10005 6.52702 4.16602 6.66324L4.75857 7.88683L10.5639 5.95172C10.8215 5.86587 11.0666 5.70345 11.2987 5.48742Z M5.38387 6.62431L9.11402 5.38092L7.5078 4.27963C7.24214 4.09748 6.92757 4 6.60546 4C5.27888 4 4.53159 5.52466 5.34425 6.57319L5.38387 6.62431Z M2.75 16.5C2.33579 16.5 2 16.8358 2 17.25C2 17.6642 2.33579 18 2.75 18H17.25C17.6642 18 18 17.6642 18 17.25C18 16.8358 17.6642 16.5 17.25 16.5H2.75Z " },
            { FluentSymbol.AirplaneTakeOff20, "M14.5036 4.00008C13.0856 3.98981 11.8664 4.95905 11.2987 5.48742C11.0666 5.70345 10.8215 5.86587 10.5639 5.95172L10.1485 6.09019L7.5078 4.27963C7.24214 4.09748 6.92757 4 6.60546 4C5.27888 4 4.53159 5.52466 5.34425 6.57319L6.03311 7.46198L4.75857 7.88683L4.16602 6.66324C3.63829 5.5735 2 5.9493 2 7.16011V10.1457C2 11.3482 3.18482 12.1925 4.3214 11.7998L7.3386 10.7575L7.04566 12.2223C6.73479 13.7766 8.73343 14.6879 9.70311 13.434L12.801 9.42822L16.9796 8.07653C17.8176 7.80548 18.3116 6.79722 17.7173 5.9855C17.1268 5.17913 16.0247 4.0111 14.5036 4.00008ZM7.03855 7.12684L6.13464 5.96059C5.83127 5.56917 6.11024 5 6.60546 5C6.72571 5 6.84314 5.03639 6.94231 5.10439L8.95858 6.48683L7.03855 7.12684ZM11.98 6.21944C12.5275 5.70984 13.4948 4.9928 14.4964 5.00005C15.5038 5.00735 16.3467 5.80639 16.9104 6.57628C16.9827 6.67494 16.9895 6.77797 16.9525 6.87396C16.9131 6.97629 16.8185 7.07763 16.6718 7.12507L12.3461 8.52434C12.2503 8.55533 12.1661 8.61453 12.1045 8.69419L8.91206 12.8223C8.58883 13.2403 7.92262 12.9365 8.02624 12.4184L8.31918 10.9537C8.47071 10.196 7.7424 9.56006 7.01209 9.81235L3.99489 10.8546C3.50778 11.0229 3 10.6611 3 10.1457V7.16011C3 7.1091 3.01505 7.08416 3.02768 7.06945C3.04387 7.0506 3.07156 7.03217 3.1087 7.02365C3.14583 7.01513 3.17879 7.01965 3.20157 7.02956C3.21935 7.03729 3.24377 7.05318 3.266 7.09909L4.04999 8.71799C4.15949 8.94411 4.41977 9.05386 4.65811 8.97441L10.8801 6.9004C11.3134 6.75597 11.679 6.49952 11.98 6.21944Z M2.5 17C2.22386 17 2 17.2239 2 17.5C2 17.7761 2.22386 18 2.5 18H17.5C17.7761 18 18 17.7761 18 17.5C18 17.2239 17.7761 17 17.5 17H2.5Z " },
            { FluentSymbol.AirplaneTakeOff24Filled, "M12.3937 5.92516L10.5225 4.41035C10.1945 4.14486 9.78533 4 9.36338 4C7.956 4 7.06844 5.51429 7.75609 6.74223L8.13761 7.42352L11.6014 6.7019C11.6567 6.69037 11.7711 6.64122 11.8952 6.49173C12.0355 6.32272 12.2028 6.1297 12.3937 5.92516Z M3 20C3 19.4477 3.44772 19 4 19H20C20.5523 19 21 19.4477 21 20C21 20.5523 20.5523 21 20 21H4C3.44772 21 3 20.5523 3 20Z M21.547 6.82934C20.6017 5.74617 18.9302 4.33032 16.6924 4.50263C15.7632 4.57418 14.9221 5.0518 14.2634 5.55966C13.5935 6.07622 13.0355 6.68399 12.6647 7.13069C12.4221 7.42283 12.1192 7.61572 11.8053 7.68112L7.14191 8.65266L6.17598 6.8818C5.87962 6.33847 5.31015 6.00041 4.69125 6.00041C3.7572 6.00041 3 6.75761 3 7.69166V11.3815C3 12.822 4.31234 13.906 5.72694 13.6339L9.02764 12.999L8.51953 14.2331C7.97639 15.5522 8.94626 17.0004 10.3728 17.0004C11.0037 17.0004 11.5978 16.7034 11.9763 16.1987L15.212 11.8842L20.5827 10.0324C21.2312 9.80882 21.7201 9.31405 21.9247 8.71216C22.1337 8.09735 22.0357 7.38933 21.547 6.82934Z " },
            { FluentSymbol.AirplaneTakeOff24, "M8.31551 8.40816L7.54364 7.28135C6.59057 5.89 7.58682 4 9.27329 4C9.75351 4 10.2192 4.16486 10.5924 4.46701L13.1732 6.55618C13.4827 6.22856 13.852 5.87691 14.2634 5.55966C14.9221 5.0518 15.7632 4.57418 16.6924 4.50263C18.9302 4.33032 20.6017 5.7461 21.547 6.82923C22.0357 7.38921 22.1337 8.09723 21.9247 8.71205C21.7201 9.31393 21.2312 9.80871 20.5828 10.0323L15.212 11.8842L12.0496 16.1009C11.6249 16.6672 10.9584 17.0004 10.2506 17.0004C8.83529 17.0004 7.77186 15.7086 8.04385 14.3196L8.29513 13.0364L5.7653 13.5826C4.34291 13.8897 3 12.8058 3 11.3506V7.69166C3 6.75761 3.7572 6.00041 4.69125 6.00041C5.31015 6.00041 5.87962 6.33847 6.17598 6.8818L7.14191 8.65266L8.31551 8.40816ZM8.78114 6.43365L9.90662 8.07668L11.8053 7.68112C11.8953 7.66237 11.9844 7.63316 12.0714 7.59414L9.64863 5.63288C9.54243 5.54691 9.40993 5.5 9.27329 5.5C8.79343 5.5 8.50996 6.03777 8.78114 6.43365ZM16.8076 5.9982C16.3011 6.0372 15.7399 6.31535 15.1793 6.74757C14.63 7.17109 14.1517 7.68771 13.8188 8.08877C13.3987 8.5949 12.813 9.00339 12.1113 9.14959L6.90297 10.2346C6.5794 10.3021 6.24985 10.1497 6.09158 9.85955L4.85914 7.60008C4.82563 7.53864 4.76123 7.50041 4.69125 7.50041C4.58562 7.50041 4.5 7.58604 4.5 7.69166V11.3506C4.5 11.8498 4.96073 12.2217 5.44873 12.1164L9.09172 11.3298C9.33829 11.2766 9.59511 11.3509 9.7752 11.5275C9.95528 11.7041 10.0345 11.9595 9.98602 12.207L9.51589 14.6078C9.42534 15.0703 9.7794 15.5004 10.2506 15.5004C10.4863 15.5004 10.7082 15.3895 10.8496 15.2009L14.15 10.8002C14.2399 10.6802 14.3638 10.59 14.5055 10.5411L20.0938 8.61424C20.3174 8.53712 20.4536 8.37897 20.5045 8.22935C20.5509 8.09266 20.5347 7.95059 20.4168 7.81553C19.5642 6.83853 18.3185 5.88186 16.8076 5.9982Z M3.75 19.5C3.33579 19.5 3 19.8358 3 20.25C3 20.6642 3.33579 21 3.75 21H20.25C20.6642 21 21 20.6642 21 20.25C21 19.8358 20.6642 19.5 20.25 19.5H3.75Z " },
            { FluentSymbol.Alert16Filled, "M3.50001 6.5C3.50001 4.01472 5.51473 2 8.00001 2C10.4853 2 12.5 4.01472 12.5 6.5V8.40371L13.4642 10.8143C13.5259 10.9684 13.5071 11.1429 13.414 11.2803C13.321 11.4177 13.1659 11.5 13 11.5H3C2.83409 11.5 2.67898 11.4177 2.58597 11.2803C2.49295 11.1429 2.47415 10.9683 2.53576 10.8143L3.50001 8.40371V6.5Z M6.06245 12.5C6.28327 13.3647 7.06443 14 8 14C8.93557 14 9.71673 13.3647 9.93755 12.5H6.06245Z " },
            { FluentSymbol.Alert16, "M8.00001 2C5.51473 2 3.50001 4.01472 3.50001 6.5V8.9014L2.5357 11.3145C2.47415 11.4685 2.49299 11.643 2.58601 11.7804C2.67904 11.9177 2.83412 12 3 12H6C6 13.1084 6.89164 14 8 14C9.10836 14 10 13.1084 10 12H13C13.1659 12 13.321 11.9177 13.414 11.7804C13.507 11.643 13.5259 11.4685 13.4643 11.3145L12.5 8.9014V6.5C12.5 4.01472 10.4853 2 8.00001 2ZM9 12C9 12.5561 8.55607 13 8 13C7.44393 13 7 12.5561 7 12H9ZM4.50001 6.5C4.50001 4.567 6.06701 3 8.00001 3C9.933 3 11.5 4.567 11.5 6.5V8.9976C11.5 9.06116 11.5121 9.12413 11.5357 9.18315L12.2617 11H3.73826L4.46431 9.18315C4.48789 9.12413 4.50001 9.06116 4.50001 8.9976V6.5Z " },
            { FluentSymbol.Alert20Filled, "M12.4496 16.0016C12.2174 17.1419 11.2089 18 9.99995 18C8.79102 18 7.78251 17.1419 7.55027 16.0016H12.4496ZM9.99759 2C13.1465 2 15.7415 4.33488 15.9821 7.3554L15.9954 7.57762L15.9999 7.80214L15.9989 11.408L16.9527 13.9951L16.9783 14.0796L16.9938 14.1664L16.999 14.2546C16.999 14.5697 16.8033 14.845 16.477 14.9618L16.3635 14.9947L16.249 15.0046H3.7513C3.6628 15.0046 3.575 14.9889 3.49197 14.9583C3.20507 14.8526 3.0163 14.5865 3.00952 14.2422L3.01412 14.1247L3.04756 13.9952L3.99895 11.411L4.00003 7.79281L4.00433 7.56824C4.12695 4.45115 6.77097 2 9.99759 2Z " },
            { FluentSymbol.Alert20, "M9.99766 2C13.1466 2 15.7416 4.33488 15.9821 7.3554L15.9955 7.57762L16 7.80214L15.999 11.398L16.9244 13.6202C16.947 13.6743 16.9647 13.7302 16.9774 13.7871L16.9926 13.8733L17.0013 14.0046C17.0013 14.4526 16.7048 14.8387 16.2521 14.9677L16.1358 14.9945L16.0013 15.0046L12.4996 15.004L12.4946 15.1653C12.4095 16.469 11.3252 17.5 10 17.5C8.67453 17.5 7.58998 16.4685 7.50533 15.1644L7.49962 15.004L3.99891 15.0046C3.91096 15.0046 3.82358 14.993 3.73902 14.9702L3.61456 14.9277C3.20378 14.7567 2.96181 14.3392 3.01221 13.8757L3.0333 13.7483L3.07572 13.6202L3.99902 11.401L4.0001 7.79281L4.0044 7.56824C4.12702 4.45115 6.77104 2 9.99766 2ZM11.4996 15.004H8.49962L8.50697 15.1454C8.57552 15.8581 9.14275 16.425 9.85556 16.4931L10 16.5C10.7797 16.5 11.4205 15.9051 11.4931 15.1445L11.4996 15.004ZM9.99766 3C7.37511 3 5.22717 4.92372 5.01715 7.38498L5.00393 7.59723L5.00002 7.80214V11.5L4.96161 11.6922L3.9989 14.0046L15.9566 14.0066L16.0019 14.0045L15.0384 11.6922L15 11.5L15.0001 7.81241L14.996 7.60831C14.8909 5.0349 12.6947 3 9.99766 3Z " },
            { FluentSymbol.Alert24Filled, "M9.04173 19.003H14.9583C14.7196 20.4211 13.486 21.5015 12 21.5015C10.514 21.5015 9.28037 20.4211 9.04173 19.003ZM12 2.00391C16.1421 2.00391 19.5 5.36177 19.5 9.50391V13.5024L20.9183 16.6625C20.9732 16.7848 21.0016 16.9174 21.0016 17.0515C21.0016 17.5762 20.5763 18.0015 20.0516 18.0015H3.95219C3.8184 18.0015 3.68613 17.9733 3.56402 17.9186C3.08515 17.7042 2.87073 17.1422 3.08511 16.6633L4.50001 13.5028L4.50011 9.49099L4.50453 9.24107C4.6436 5.21035 7.95588 2.00391 12 2.00391Z " },
            { FluentSymbol.Alert24, "M12 1.99609C16.0499 1.99609 19.3567 5.19084 19.4958 9.24515L19.5 9.49609V13.5931L20.88 16.7491C20.949 16.907 20.9847 17.0775 20.9847 17.2499C20.9847 17.9402 20.425 18.4999 19.7347 18.4999L15 18.5014C15 20.1582 13.6568 21.5014 12 21.5014C10.4023 21.5014 9.09633 20.2524 9.00508 18.6776L8.99954 18.4991L4.27485 18.4999C4.10351 18.4999 3.93401 18.4646 3.77685 18.3964C3.14365 18.1213 2.8533 17.3851 3.12834 16.7519L4.49999 13.594V9.49599C4.50059 5.3412 7.85208 1.99609 12 1.99609ZM13.4995 18.4991L10.5 18.5014C10.5 19.3298 11.1716 20.0014 12 20.0014C12.7797 20.0014 13.4204 19.4065 13.4931 18.6458L13.4995 18.4991ZM12 3.49609C8.67983 3.49609 6.00047 6.17035 5.99999 9.49609V13.9057L4.65601 16.9999H19.3525L18 13.9067L18.0001 9.50895L17.9964 9.28375C17.8853 6.05027 15.2416 3.49609 12 3.49609Z " },
            { FluentSymbol.Alert28Filled, "M17.4656 22.0024C17.2225 23.6987 15.7635 25.0025 13.9999 25.0025C12.2364 25.0025 10.7774 23.6987 10.5343 22.0024H17.4656ZM13.9999 3C18.6097 3 22.3625 6.66899 22.4974 11.246V11.5012H22.5012L22.5009 15.613L23.915 19.2573C23.9531 19.3557 23.9789 19.4583 23.9919 19.5627L24.0016 19.7203C24.0016 20.383 23.4979 20.9281 22.8525 20.9937L22.7216 21.0003H5.27473C5.11602 21.0003 4.9587 20.9708 4.81078 20.9133C4.19311 20.673 3.86764 20.006 4.04049 19.3807L4.08177 19.2563L5.49794 15.612L5.4987 11.5012C5.4987 6.80614 9.30483 3 13.9999 3Z " },
            { FluentSymbol.Alert28, "M13.9999 3C18.6097 3 22.3625 6.66899 22.4974 11.246L22.5012 11.5012L22.5009 16.113L23.915 19.757C23.9531 19.8554 23.9789 19.958 23.9919 20.0624L24.0016 20.22C24.0016 20.8827 23.4979 21.4278 22.8525 21.4934L22.7216 21.5L17.5014 21.5011C17.5014 23.4348 15.9337 25.0025 13.9999 25.0025C12.1306 25.0025 10.6034 23.5376 10.5037 21.6932L10.4984 21.499L5.27473 21.5C5.11602 21.5 4.9587 21.4705 4.81078 21.413C4.19311 21.1727 3.86764 20.5057 4.04049 19.8804L4.08177 19.7561L5.49794 16.112L5.4987 11.5012C5.4987 6.80614 9.30483 3 13.9999 3ZM15.9959 21.6504L16.0004 21.499L11.9985 21.5011C11.9985 22.6064 12.8946 23.5025 13.9999 23.5025C15.0551 23.5025 15.9195 22.686 15.9959 21.6504ZM13.9999 4.5C10.2138 4.5 7.12962 7.50532 7.00276 11.2606L6.9987 11.5012V16.2534C6.9987 16.3154 6.99101 16.377 6.9759 16.4369L6.9477 16.5252L5.59594 19.999H22.3999L21.052 16.5246C21.0296 16.467 21.0145 16.4069 21.0069 16.3457L21.0012 16.2534V11.5012C21.0012 7.63456 17.8666 4.5 13.9999 4.5Z " },
            { FluentSymbol.Alert32Filled, "M7.00001 13C7.00001 8.02944 11.0295 4 16 4C20.9706 4 25 8.02944 25 13V16.8074L26.9285 21.6286C27.0517 21.9367 27.0141 22.2859 26.8281 22.5606C26.642 22.8354 26.3318 23 26 23H6C5.66818 23 5.35797 22.8354 5.17194 22.5606C4.98591 22.2859 4.94829 21.9367 5.07153 21.6286L7.00001 16.8074V13ZM12.1249 25C12.5665 26.7294 14.1289 28 16 28C17.8711 28 19.4335 26.7294 19.8751 25H12.1249Z " },
            { FluentSymbol.Alert32, "M16 4C11.0295 4 7.00001 8.02944 7.00001 13V17.8028L5.07141 22.6289C4.94829 22.937 4.98599 23.2861 5.17203 23.5608C5.35807 23.8355 5.66824 24 6 24H12C12 26.2167 13.7833 28 16 28C18.2167 28 20 26.2167 20 24H26C26.3318 24 26.6419 23.8355 26.828 23.5608C27.014 23.2861 27.0517 22.937 26.9286 22.6289L25 17.8028V13C25 8.02944 20.9706 4 16 4ZM18 24C18 25.1121 17.1121 26 16 26C14.8879 26 14 25.1121 14 24H18ZM9.00001 13C9.00001 9.13401 12.134 6 16 6C19.866 6 23 9.13401 23 13V17.9952C23 18.1223 23.0242 18.2483 23.0714 18.3663L24.5235 22H7.47651L8.92861 18.3663C8.97578 18.2483 9.00001 18.1223 9.00001 17.9952V13Z " },
            { FluentSymbol.AlertOff16Filled, "M10.7929 11.5L14.1464 14.8536C14.3417 15.0488 14.6583 15.0488 14.8536 14.8536C15.0488 14.6583 15.0488 14.3417 14.8536 14.1464L1.85355 1.14645C1.65829 0.951184 1.34171 0.951184 1.14645 1.14645C0.951184 1.34171 0.951184 1.65829 1.14645 1.85355L3.91116 4.61827C3.64723 5.19081 3.50001 5.82823 3.50001 6.50005V8.40375L2.53576 10.8144C2.47415 10.9684 2.49295 11.143 2.58597 11.2804C2.67898 11.4177 2.83409 11.5 3 11.5H10.7929Z M13.409 11.2877L13.414 11.2804C13.5071 11.143 13.5259 10.9684 13.4642 10.8144L12.5 8.40375V6.50005C12.5 4.01476 10.4853 2.00005 8.00001 2.00005C6.91559 2.00005 5.92076 2.38363 5.1438 3.02251L13.409 11.2877Z M6.06245 12.5C6.28327 13.3647 7.06443 14 8 14C8.93557 14 9.71673 13.3647 9.93755 12.5H6.06245Z " },
            { FluentSymbol.AlertOff16, "M11.2929 12L14.1464 14.8536C14.3417 15.0488 14.6583 15.0488 14.8536 14.8536C15.0488 14.6583 15.0488 14.3417 14.8536 14.1464L1.85355 1.14645C1.65829 0.951184 1.34171 0.951184 1.14645 1.14645C0.951184 1.34171 0.951184 1.65829 1.14645 1.85355L3.91116 4.61827C3.64722 5.19081 3.50001 5.82823 3.50001 6.50005V8.90144L2.5357 11.3145C2.47415 11.4685 2.49299 11.6431 2.58601 11.7804C2.67904 11.9178 2.83412 12 3 12H6C6 13.1084 6.89164 14 8 14C9.10835 14 10 13.1084 10 12H11.2929ZM10.2929 11H3.73826L4.46431 9.18319C4.48789 9.12418 4.50001 9.0612 4.50001 8.99765V6.50005C4.50001 6.11116 4.56343 5.73709 4.6805 5.38761L10.2929 11ZM8 13C7.44393 13 7 12.5561 7 12H9C9 12.5561 8.55607 13 8 13Z M11.6896 9.56832L11.5357 9.18319C11.5121 9.12418 11.5 9.0612 11.5 8.99765V6.50005C11.5 4.56705 9.933 3.00005 8.00001 3.00005C7.19186 3.00005 6.44769 3.27394 5.85526 3.73397L5.1438 3.02251C5.92076 2.38363 6.91559 2.00005 8.00001 2.00005C10.4853 2.00005 12.5 4.01476 12.5 6.50005V8.90144L13.4643 11.3145C13.4701 11.3289 13.4751 11.3435 13.4795 11.3582L11.6896 9.56832Z " },
            { FluentSymbol.AlertOff20Filled, "M4.00433 7.56824C4.03641 6.7528 4.24104 5.98294 4.58352 5.29061L2.14645 2.85355C1.95118 2.65829 1.95118 2.34171 2.14645 2.14645C2.34171 1.95118 2.65829 1.95118 2.85355 2.14645L17.8536 17.1464C18.0488 17.3417 18.0488 17.6583 17.8536 17.8536C17.6583 18.0488 17.3417 18.0488 17.1464 17.8536L14.2975 15.0046H3.7513C3.6628 15.0046 3.575 14.9889 3.49197 14.9583C3.20507 14.8526 3.0163 14.5865 3.00952 14.2422L3.01412 14.1247L3.04756 13.9952L3.99895 11.411L4.00003 7.79281L4.00433 7.56824Z M16.999 14.2546C16.999 14.426 16.9411 14.5856 16.8357 14.7144L5.78519 3.66386C6.86947 2.63265 8.35835 2 9.99759 2C13.1465 2 15.7415 4.33488 15.9821 7.3554L15.9954 7.57762L15.9999 7.80214L15.9989 11.408L16.9527 13.9951L16.9783 14.0796L16.9938 14.1664L16.999 14.2546Z M12.4496 16.0016C12.2174 17.1419 11.2089 18 9.99995 18C8.79102 18 7.78251 17.1419 7.55027 16.0016H12.4496Z " },
            { FluentSymbol.AlertOff20, "M4.0044 7.56824C4.03648 6.75282 4.2411 5.98297 4.58356 5.29065L2.14645 2.85355C1.95118 2.65829 1.95118 2.34171 2.14645 2.14645C2.34171 1.95118 2.65829 1.95118 2.85355 2.14645L17.8536 17.1464C18.0488 17.3417 18.0488 17.6583 17.8536 17.8536C17.6583 18.0488 17.3417 18.0488 17.1464 17.8536L14.2972 15.0043L12.4996 15.004L12.4946 15.1653C12.4095 16.469 11.3252 17.5 10 17.5C8.67453 17.5 7.58998 16.4685 7.50533 15.1644L7.49962 15.004L3.99891 15.0046C3.91096 15.0046 3.82358 14.993 3.73902 14.9702L3.61456 14.9277C3.20378 14.7567 2.96181 14.3392 3.01221 13.8757L3.0333 13.7483L3.07572 13.6202L3.99902 11.401L4.0001 7.79281L4.0044 7.56824ZM13.299 14.0061L5.33843 6.04552C5.16766 6.46607 5.05719 6.91575 5.01715 7.38498L5.00393 7.59723L5.00002 7.80214V11.5L4.96161 11.6922L3.9989 14.0046L13.299 14.0061ZM11.4996 15.004H8.49962L8.50697 15.1454C8.57552 15.8581 9.14275 16.425 9.85556 16.4931L10 16.5C10.7797 16.5 11.4205 15.9051 11.4931 15.1445L11.4996 15.004Z M15.0384 11.6922L15.9133 13.7919L16.7653 14.644C16.9153 14.4691 17.0013 14.2458 17.0013 14.0046L16.9926 13.8733L16.9774 13.7871C16.9647 13.7302 16.947 13.6743 16.9244 13.6202L15.999 11.398L16 7.80214L15.9955 7.57762L15.9821 7.3554C15.7416 4.33488 13.1466 2 9.99766 2C8.3584 2 6.86951 2.63266 5.78523 3.66389L6.49193 4.3706C7.39369 3.52222 8.63126 3 9.99766 3C12.6947 3 14.8909 5.0349 14.996 7.60831L15.0001 7.81241L15 11.5L15.0384 11.6922Z " },
            { FluentSymbol.AlertOff24Filled, "M3.28034 2.21968C2.98745 1.92678 2.51257 1.92677 2.21968 2.21966C1.92678 2.51255 1.92677 2.98743 2.21966 3.28032L5.22385 6.28457C4.7954 7.18486 4.54098 8.18466 4.50453 9.24108L4.50011 9.491L4.50001 13.5028L3.08511 16.6633C2.87073 17.1422 3.08515 17.7042 3.56402 17.9186C3.68613 17.9733 3.8184 18.0015 3.95219 18.0015H16.9406L20.7194 21.7805C21.0123 22.0734 21.4872 22.0734 21.7801 21.7805C22.073 21.4876 22.073 21.0127 21.7801 20.7198L3.28034 2.21968Z M21.0016 17.0515C21.0016 17.2676 20.9295 17.4668 20.808 17.6264L7.05071 3.86876C8.37284 2.70708 10.1062 2.00392 12 2.00392C16.1421 2.00392 19.5 5.36178 19.5 9.50392V13.5024L20.9183 16.6625C20.9732 16.7849 21.0016 16.9174 21.0016 17.0515Z M14.9583 19.003C14.7196 20.4211 13.486 21.5015 12 21.5015C10.514 21.5015 9.28037 20.4211 9.04173 19.003H14.9583Z " },
            { FluentSymbol.AlertOff28Filled, "M3.28033 2.21967C2.98744 1.92678 2.51257 1.92677 2.21967 2.21967C1.92678 2.51256 1.92677 2.98743 2.21967 3.28033L6.47717 7.5379C5.8524 8.72131 5.4987 10.07 5.4987 11.5013L5.49794 15.612L4.08177 19.2564L4.04049 19.3807C3.86764 20.006 4.19311 20.673 4.81078 20.9133C4.9587 20.9708 5.11602 21.0003 5.27473 21.0003H19.9394L24.7194 25.7805C25.0123 26.0734 25.4872 26.0734 25.7801 25.7805C26.073 25.4876 26.073 25.0127 25.7801 24.7198L3.28033 2.21967Z M8.33987 5.15805L23.7124 20.5308C23.8931 20.3101 24.0016 20.0279 24.0016 19.7203L23.9919 19.5627C23.9789 19.4583 23.9531 19.3558 23.915 19.2573L22.5009 15.613L22.5012 11.5013H22.4974V11.2461C22.3625 6.669 18.6097 3.00001 13.9999 3.00001C11.8262 3.00001 9.84301 3.81586 8.33987 5.15805Z M17.4656 22.0024C17.2225 23.6987 15.7635 25.0025 13.9999 25.0025C12.2364 25.0025 10.7774 23.6987 10.5343 22.0024H17.4656Z " },
            { FluentSymbol.AlertOff28, "M3.28033 2.21967C2.98744 1.92678 2.51257 1.92677 2.21967 2.21967C1.92678 2.51256 1.92677 2.98743 2.21967 3.28033L6.47717 7.5379C5.8524 8.72131 5.4987 10.07 5.4987 11.5013L5.49794 16.112L4.08177 19.7561L4.04049 19.8804C3.86764 20.5057 4.19311 21.1728 4.81078 21.413C4.9587 21.4705 5.11602 21.5 5.27473 21.5L10.4984 21.499L10.5037 21.6932C10.6034 23.5376 12.1306 25.0025 13.9999 25.0025C15.9337 25.0025 17.5014 23.4349 17.5014 21.5011L20.4395 21.5005L24.7194 25.7805C25.0123 26.0734 25.4872 26.0734 25.7801 25.7805C26.073 25.4876 26.073 25.0127 25.7801 24.7198L3.28033 2.21967ZM18.9381 19.999H5.59594L6.9477 16.5252L6.9759 16.4369C6.99101 16.377 6.9987 16.3154 6.9987 16.2534V11.5013L7.00276 11.2606C7.03395 10.3372 7.24395 9.45914 7.59923 8.65998L18.9381 19.999ZM15.9959 21.6504C15.9195 22.686 15.0551 23.5025 13.9999 23.5025C12.8946 23.5025 11.9985 22.6064 11.9985 21.5011L16.0004 21.499L15.9959 21.6504Z M8.33987 5.15805L9.40259 6.22079C10.6325 5.14906 12.2404 4.50001 13.9999 4.50001C17.8666 4.50001 21.0012 7.63457 21.0012 11.5013V16.2534L21.0069 16.3457C21.0145 16.4069 21.0296 16.467 21.052 16.5246L21.9051 18.7235L23.9007 20.7191C23.9657 20.5657 24.0016 20.3971 24.0016 20.22L23.9919 20.0624C23.9789 19.958 23.9531 19.8555 23.915 19.757L22.5009 16.113L22.5012 11.5013L22.4974 11.2461C22.3625 6.669 18.6097 3.00001 13.9999 3.00001C11.8262 3.00001 9.84301 3.81586 8.33987 5.15805Z " },
            { FluentSymbol.AlertOff24, "M5.21938 6.27997L2.21966 3.28019C1.92677 2.9873 1.92678 2.51242 2.21968 2.21953C2.51257 1.92664 2.98745 1.92665 3.28034 2.21954L21.7801 20.7197C22.073 21.0126 22.073 21.4875 21.7801 21.7804C21.4872 22.0732 21.0123 22.0732 20.7194 21.7803L17.4398 18.5006L15.0001 18.5014C15.0001 20.1582 13.657 21.5014 12.0001 21.5014C10.4024 21.5014 9.09645 20.2524 9.0052 18.6776L8.99966 18.4991L4.27498 18.4999C4.10364 18.4999 3.93413 18.4646 3.77697 18.3964C3.14377 18.1213 2.85342 17.3851 3.12846 16.7519L4.50011 13.594V9.49599C4.50028 8.34367 4.7582 7.25363 5.21938 6.27997ZM15.9391 16.9999L6.36473 7.42534C6.1289 8.07014 6.00022 8.76748 6.00011 9.49609V13.9057L4.65613 16.9999H15.9391ZM13.4997 18.4991L10.5001 18.5014C10.5001 19.3298 11.1717 20.0014 12.0001 20.0014C12.7798 20.0014 13.4206 19.4065 13.4932 18.6458L13.4997 18.4991Z M18.0001 13.9067L18.7084 15.5266L20.8958 17.714C20.9532 17.5705 20.9848 17.4139 20.9848 17.2499C20.9848 17.0775 20.9492 16.907 20.8801 16.7491L19.5001 13.5931V9.49609L19.4959 9.24515C19.3568 5.19084 16.05 1.99609 12.0001 1.99609C10.0984 1.99609 8.36403 2.69926 7.0433 3.86123L8.10667 4.92462C9.15366 4.03291 10.5126 3.49609 12.0001 3.49609C15.2417 3.49609 17.8854 6.05027 17.9965 9.28375L18.0002 9.50895L18.0001 13.9067Z " },
            { FluentSymbol.AlertOn24Filled, "M9.04173 19.003H14.9583C14.7196 20.4211 13.486 21.5015 12 21.5015C10.514 21.5015 9.28037 20.4211 9.04173 19.003ZM12 2.00391C16.1421 2.00391 19.5 5.36177 19.5 9.50391V13.5024L20.9183 16.6625C20.9732 16.7848 21.0016 16.9174 21.0016 17.0515C21.0016 17.5762 20.5763 18.0015 20.0516 18.0015H3.95219C3.8184 18.0015 3.68612 17.9733 3.56402 17.9186C3.08514 17.7042 2.87073 17.1422 3.08511 16.6633L4.5 13.5028L4.50011 9.49099L4.50453 9.24107C4.6436 5.21035 7.95587 2.00391 12 2.00391ZM23 8.25001C23.4142 8.25001 23.75 8.5858 23.75 9.00001C23.75 9.37971 23.4678 9.6935 23.1018 9.74317L23 9.75001H21C20.5858 9.75001 20.25 9.41423 20.25 9.00001C20.25 8.62032 20.5322 8.30652 20.8982 8.25686L21 8.25001H23ZM3 8.25001C3.41421 8.25001 3.75 8.5858 3.75 9.00001C3.75 9.37971 3.46785 9.6935 3.10177 9.74317L3 9.75001H1C0.585786 9.75001 0.25 9.41423 0.25 9.00001C0.25 8.62032 0.532154 8.30652 0.898229 8.25686L1 8.25001H3ZM22.6 2.55001C22.8259 2.85126 22.791 3.26716 22.5338 3.52701L22.45 3.60001L20.45 5.10001C20.1186 5.34854 19.6485 5.28138 19.4 4.95001C19.1741 4.64877 19.209 4.23287 19.4662 3.97302L19.55 3.90001L21.55 2.40001C21.8814 2.15148 22.3515 2.21864 22.6 2.55001ZM2.45 2.40001L4.45 3.90001C4.78137 4.14854 4.84853 4.61864 4.6 4.95001C4.35147 5.28138 3.88137 5.34854 3.55 5.10001L1.55 3.60001C1.21863 3.35148 1.15147 2.88138 1.4 2.55001C1.64853 2.21864 2.11863 2.15148 2.45 2.40001Z " },
            { FluentSymbol.AlertOn24, "M12 1.99609C16.0499 1.99609 19.3567 5.19084 19.4958 9.24515L19.5 9.49609V13.5931L20.88 16.7491C20.9491 16.907 20.9847 17.0775 20.9847 17.2499C20.9847 17.9402 20.4251 18.4999 19.7347 18.4999L15 18.5014C15 20.1582 13.6569 21.5014 12 21.5014C10.4023 21.5014 9.09634 20.2524 9.00509 18.6776L8.99955 18.4991L4.27486 18.4999C4.10353 18.4999 3.93402 18.4646 3.77686 18.3964C3.14366 18.1213 2.85331 17.3851 3.12835 16.7519L4.5 13.594V9.49599C4.5006 5.3412 7.85209 1.99609 12 1.99609ZM13.4995 18.4991L10.5 18.5014C10.5 19.3298 11.1716 20.0014 12 20.0014C12.7797 20.0014 13.4204 19.4065 13.4931 18.6458L13.4995 18.4991ZM12 3.49609C8.67984 3.49609 6.00048 6.17035 6 9.49609V13.9057L4.65602 16.9999H19.3525L18 13.9067L18.0001 9.50895L17.9964 9.28375C17.8853 6.05027 15.2416 3.49609 12 3.49609ZM21 8.24987H23C23.4142 8.24987 23.75 8.58566 23.75 8.99987C23.75 9.37957 23.4678 9.69336 23.1018 9.74302L23 9.74987H21C20.5858 9.74987 20.25 9.41408 20.25 8.99987C20.25 8.62017 20.5322 8.30638 20.8982 8.25672L21 8.24987ZM1 8.24987H3C3.41421 8.24987 3.75 8.58566 3.75 8.99987C3.75 9.37957 3.46785 9.69336 3.10177 9.74302L3 9.74987H1C0.585786 9.74987 0.25 9.41408 0.25 8.99987C0.25 8.62017 0.532154 8.30638 0.898229 8.25672L1 8.24987ZM22.6 2.54987C22.8259 2.85112 22.791 3.26702 22.5338 3.52687L22.45 3.59987L20.45 5.09987C20.1186 5.3484 19.6485 5.28124 19.4 4.94987C19.1741 4.64862 19.209 4.23272 19.4662 3.97287L19.55 3.89987L21.55 2.39987C21.8814 2.15134 22.3515 2.2185 22.6 2.54987ZM2.45 2.39987L4.45 3.89987C4.78137 4.1484 4.84853 4.6185 4.6 4.94987C4.35147 5.28124 3.88137 5.3484 3.55 5.09987L1.55 3.59987C1.21863 3.35134 1.15147 2.88124 1.4 2.54987C1.64853 2.2185 2.11863 2.15134 2.45 2.39987Z " },
            { FluentSymbol.AlertSnooze20Filled, "M9.99783 2C10.8892 2 11.7362 2.18709 12.498 2.52387C12.5107 3.34129 13.1773 4 13.9978 4C14.0873 4 14.6294 4 14.625 4L13.3386 5.82597C13.1022 5.35178 12.6209 5 11.9988 5H9.45411L9.27476 5.01608L9.23037 5.02413C8.52999 5.15126 7.99884 5.76256 7.99884 6.5C7.99884 7.11551 8.36956 7.64443 8.8999 7.87565L8.32161 8.56959L8.2284 8.70098L8.20801 8.73521C7.63006 9.70513 8.30539 11 9.49884 11H12.0436L12.2229 10.9839L12.2673 10.9759C12.9677 10.8487 13.4988 10.2374 13.4988 9.5C13.4988 9.27082 13.4474 9.05365 13.3555 8.85938C13.5461 8.94895 13.7623 9 13.9978 9H15.9999L15.9992 11.408L16.9529 13.9951L16.9786 14.0796L16.994 14.1664L16.9992 14.2546C16.9992 14.5697 16.8035 14.845 16.4773 14.9618L16.3638 14.9947L16.2492 15.0046H3.75154C3.66305 15.0046 3.57525 14.9889 3.49221 14.9583C3.20531 14.8526 3.01655 14.5865 3.00977 14.2422L3.01436 14.1247L3.04781 13.9952L3.99919 11.411L4.00028 7.79281L4.00458 7.56824C4.12719 4.45115 6.77122 2 9.99783 2Z M12.4499 16.0016C12.2176 17.1419 11.2091 18 10.0002 18C8.79126 18 7.78275 17.1419 7.55052 16.0016H12.4499Z M13.9979 2H17.4979C17.8736 2 18.1048 2.39262 17.9502 2.71403L17.9076 2.78673L14.9583 7H17.4979C17.7741 7 17.9979 7.22386 17.9979 7.5C17.9979 7.74546 17.8211 7.94961 17.5878 7.99194L17.4979 8H13.9979C13.6223 8 13.3911 7.60738 13.5457 7.28597L13.5883 7.21327L16.5376 3H13.9979C13.7218 3 13.4979 2.77614 13.4979 2.5C13.4979 2.25454 13.6748 2.05039 13.9081 2.00806L13.9979 2Z M9.499 6H11.999C12.3947 6 12.6228 6.4307 12.4308 6.75291L12.3831 6.82009L10.5665 9H11.999C12.2751 9 12.499 9.22386 12.499 9.5C12.499 9.74546 12.3221 9.94961 12.0889 9.99194L11.999 10H9.499C9.10334 10 8.87524 9.5693 9.06723 9.24709L9.11489 9.17991L10.9315 7H9.499C9.22286 7 8.999 6.77614 8.999 6.5C8.999 6.25454 9.17588 6.05039 9.40913 6.00806L9.499 6Z " },
            { FluentSymbol.AlertSnooze24Filled, "M15.2503 7H12.7503L12.6486 7.00685C12.2825 7.05651 12.0003 7.3703 12.0003 7.75C12.0003 8.16421 12.3361 8.5 12.7503 8.5H13.793L12.14 10.8141L12.0847 10.9035C11.8281 11.3892 12.1762 12 12.7503 12H15.2503L15.3521 11.9932C15.7182 11.9435 16.0003 11.6297 16.0003 11.25C16.0003 10.8358 15.6646 10.5 15.2503 10.5H14.2077L15.8606 8.18593L15.9159 8.0965C16.1726 7.61079 15.8245 7 15.2503 7Z M21.2503 2H17.7503L17.6486 2.00685C17.2825 2.05651 17.0003 2.3703 17.0003 2.75C17.0003 3.16421 17.3361 3.5 17.7503 3.5H19.8841L17.1176 7.84734L17.0685 7.93689C16.8429 8.42124 17.1933 9 17.7503 9H21.2503L21.3521 8.99315C21.7182 8.94349 22.0003 8.6297 22.0003 8.25C22.0003 7.83579 21.6646 7.5 21.2503 7.5H19.1166L21.8831 3.15266L21.9322 3.06311C22.1578 2.57876 21.8074 2 21.2503 2Z M12.6992 5.5H15.2496C15.7577 5.5 16.2059 5.65842 16.5659 5.91925L17.1948 4.93106C16.2579 4.69344 15.5554 3.86808 15.5028 2.87044C14.4573 2.3172 13.2652 2.00391 12 2.00391C7.95588 2.00391 4.6436 5.21035 4.50453 9.24107L4.50011 9.49099L4.50001 13.5028L3.08511 16.6633C2.87073 17.1422 3.08515 17.7042 3.56402 17.9186C3.68613 17.9733 3.8184 18.0015 3.95219 18.0015H20.0516C20.5763 18.0015 21.0016 17.5762 21.0016 17.0515C21.0016 16.9174 20.9732 16.7848 20.9183 16.6625L19.5 13.5024V10.5H17.7496C17.6155 10.5 17.4854 10.4889 17.3599 10.4677C17.4503 10.7113 17.4996 10.9749 17.4996 11.25C17.4996 12.3903 16.6528 13.3304 15.5531 13.4795L15.5028 13.4864L15.3 13.5H12.7496C11.0204 13.5 9.98519 11.6649 10.7578 10.2027L10.7815 10.1578L10.8898 9.98276L11.2724 9.44714C10.7989 9.03466 10.4996 8.42727 10.4996 7.75C10.4996 6.60969 11.3465 5.66965 12.4462 5.52046L12.4965 5.51364L12.6992 5.5Z M14.9583 19.003C14.7196 20.4211 13.486 21.5015 12 21.5015C10.514 21.5015 9.28037 20.4211 9.04173 19.003H14.9583Z " },
            { FluentSymbol.AlertSnooze24, "M11.9994 3.5C8.89563 3.5 5.99929 5.93202 5.99929 9.75V13.9028L4.68294 17H19.3525L17.9993 13.9069V11.75C17.9993 11.3358 18.3351 11 18.7493 11C19.1635 11 19.4993 11.3358 19.4993 11.75V13.5931L20.88 16.749C21.2413 17.5748 20.6362 18.5 19.7348 18.5H15.0012C15.0004 20.157 13.6568 21.5 11.9996 21.5C10.3424 21.5 8.9989 20.157 8.99805 18.5H4.30504C3.40926 18.5 2.80425 17.5855 3.15463 16.7611L4.49929 13.5972V9.75C4.49929 5.06798 8.10327 2 11.9994 2C12.8589 2 13.7043 2.14907 14.4999 2.43197C14.8902 2.57074 15.094 2.99962 14.9553 3.38989C14.8165 3.78017 14.3876 3.98405 13.9973 3.84528C13.3609 3.61898 12.6854 3.5 11.9994 3.5ZM11.9996 20C12.8284 20 13.5004 19.3286 13.5012 18.5H10.498C10.4989 19.3286 11.1709 20 11.9996 20Z M15.2503 7H12.7503L12.6486 7.00685C12.2825 7.05651 12.0003 7.3703 12.0003 7.75C12.0003 8.16421 12.3361 8.5 12.7503 8.5H13.793L12.14 10.8141L12.0847 10.9035C11.8281 11.3892 12.1762 12 12.7503 12H15.2503L15.3521 11.9932C15.7182 11.9435 16.0003 11.6297 16.0003 11.25C16.0003 10.8358 15.6646 10.5 15.2503 10.5H14.2077L15.8606 8.18593L15.9159 8.0965C16.1726 7.61079 15.8245 7 15.2503 7Z M21.2503 2H17.7503L17.6486 2.00685C17.2825 2.05651 17.0003 2.3703 17.0003 2.75C17.0003 3.16421 17.3361 3.5 17.7503 3.5H19.8841L17.1176 7.84734L17.0685 7.93689C16.8429 8.42124 17.1933 9 17.7503 9H21.2503L21.3521 8.99315C21.7182 8.94349 22.0003 8.6297 22.0003 8.25C22.0003 7.83579 21.6646 7.5 21.2503 7.5H19.1166L21.8831 3.15266L21.9322 3.06311C22.1578 2.57876 21.8074 2 21.2503 2Z " },
            { FluentSymbol.AlertSnooze20, "M5.00006 11.5001V8.05456C5.002 8.03668 5.00299 8.01851 5.00299 8.00012C5.00299 5.23863 7.24162 3 10.0031 3C10.4753 3 10.9313 3.06531 11.3632 3.18707C11.629 3.26201 11.9052 3.10731 11.9801 2.84153C12.0551 2.57575 11.9004 2.29954 11.6346 2.2246C11.1153 2.07818 10.5679 2 10.0031 2C6.7091 2 4.03506 4.6544 4.00328 7.9409C4.00115 7.95961 4.00006 7.97864 4.00006 7.99792V11.4001L3.07699 13.6155C2.80253 14.2742 3.28649 15.0001 4.00006 15.0001H7.5C7.5 16.3808 8.61929 17.5001 10 17.5001C11.3807 17.5001 12.5 16.3808 12.5 15.0001L16.0001 15.0001C16.7136 15.0001 17.1976 14.2742 16.9231 13.6155L16.0001 11.4001V9.99792C16.0001 9.72178 15.7762 9.49792 15.5001 9.49792C15.2239 9.49792 15.0001 9.72178 15.0001 9.99792V11.5001C15.0001 11.5661 15.0131 11.6315 15.0385 11.6924L16.0001 14.0001H4.00006L4.9616 11.6924C4.98699 11.6315 5.00006 11.5661 5.00006 11.5001ZM8.5 15.0001H11.5C11.5 15.8285 10.8284 16.5001 10 16.5001C9.17157 16.5001 8.5 15.8285 8.5 15.0001Z M13.9999 2.00012H17.4999C17.8755 2.00012 18.1068 2.39274 17.9521 2.71416L17.9095 2.78685L14.9602 7.00012H17.4999C17.776 7.00012 17.9999 7.22398 17.9999 7.50012C17.9999 7.74558 17.823 7.94973 17.5898 7.99207L17.4999 8.00012H13.9999C13.6243 8.00012 13.393 7.60751 13.5476 7.28609L13.5903 7.21339L16.5396 3.00012H13.9999C13.7238 3.00012 13.4999 2.77626 13.4999 2.50012C13.4999 2.25466 13.6768 2.05051 13.91 2.00818L13.9999 2.00012Z M9.50096 6.00012H12.001C12.3966 6.00012 12.6247 6.43082 12.4327 6.75303L12.3851 6.82021L10.5685 9.00012H12.001C12.2771 9.00012 12.501 9.22398 12.501 9.50012C12.501 9.74558 12.3241 9.94973 12.0908 9.99207L12.001 10.0001H9.50096C9.1053 10.0001 8.87719 9.56942 9.06918 9.24722L9.11684 9.18003L10.9334 7.00012H9.50096C9.22481 7.00012 9.00096 6.77626 9.00096 6.50012C9.00096 6.25466 9.17783 6.05051 9.41108 6.00818L9.50096 6.00012Z " },
            { FluentSymbol.AlertUrgent16Filled, "M10.0432 1.29706C10.1554 1.04471 10.4509 0.931067 10.7032 1.04322C10.8188 1.0946 12.6805 1.9816 13.9295 4.07385C14.5613 5.13229 14.8269 6.2181 14.9361 7.04622C14.9908 7.46155 15.0068 7.81582 15.0089 8.07478C15.01 8.20442 15.0077 8.31013 15.005 8.3874C15.0037 8.42595 15.0023 8.45718 15.0013 8.47947L15.0001 8.50524L15.0001 8.50108C14.9996 8.77678 14.7759 9.00012 14.5001 9.00012C14.224 9.00012 14.0001 8.77627 14.0001 8.50012C14.0001 8.49111 14.0008 8.47438 14.0018 8.45046C14.0159 8.10818 14.0907 6.29497 13.0708 4.5864C12.5238 3.67005 11.8393 3.01529 11.2812 2.58552C11.0027 2.37106 10.7577 2.21419 10.5804 2.1102C10.4098 2.01007 10.3049 1.9607 10.2971 1.95703C10.0447 1.84488 9.93107 1.5494 10.0432 1.29706Z M10.0948 3.71029C10.2565 3.48647 10.5691 3.43615 10.7929 3.59789C10.7896 3.59553 11.0285 3.74616 11.3136 4.00773C11.5998 4.27037 11.9534 4.66095 12.2353 5.18515C12.5154 5.70587 12.6495 6.20426 12.714 6.57927C12.7463 6.7673 12.7614 6.926 12.7684 7.04332C12.7719 7.10207 12.7734 7.15046 12.774 7.18696C12.7745 7.22202 12.7742 7.24987 12.7742 7.24987C12.7742 7.52601 12.5503 7.74987 12.2742 7.74987C11.9981 7.74987 11.7742 7.52601 11.7742 7.24987L11.7742 7.24663C11.7748 7.18585 11.7816 6.45284 11.3546 5.6588C10.9494 4.90537 10.349 4.50354 10.2262 4.42136C10.2172 4.41532 10.2108 4.411 10.2072 4.40841C9.98336 4.24666 9.93304 3.93411 10.0948 3.71029Z M2.53652 10.707C1.43204 8.79398 2.08749 6.34782 4.00051 5.24334C5.91352 4.13886 8.35968 4.79431 9.46416 6.70732L10.2849 8.12761L12.1901 9.51374C12.327 9.61332 12.4042 9.77537 12.3953 9.94439C12.3863 10.1134 12.2925 10.2664 12.146 10.3511L9.61623 11.8116L9.61972 11.814L6.88163 13.3948L6.88129 13.3906L4.35172 14.8511C4.20514 14.9357 4.0257 14.9404 3.87487 14.8636C3.72404 14.7868 3.6223 14.639 3.6045 14.4706L3.35668 12.1276L2.53652 10.707Z M10.2497 12.605L7.25167 14.3359C7.78058 15.0084 8.7369 15.2077 9.49948 14.7674C10.262 14.3272 10.5676 13.3993 10.2497 12.605Z " },
            { FluentSymbol.AlertUrgent16, "M10.7032 1.04322C10.4509 0.931067 10.1554 1.04471 10.0432 1.29706C9.93107 1.5494 10.0447 1.84488 10.2971 1.95703C10.3049 1.9607 10.4098 2.01007 10.5804 2.1102C10.7577 2.21419 11.0027 2.37106 11.2812 2.58552C11.8393 3.01529 12.5238 3.67005 13.0708 4.5864C14.0907 6.29497 14.0159 8.10818 14.0018 8.45046C14.0008 8.47438 14.0001 8.49111 14.0001 8.50012C14.0001 8.77627 14.224 9.00012 14.5001 9.00012C14.7759 9.00012 14.9996 8.77678 15.0001 8.50108L15.0001 8.50524L15.0013 8.47947C15.0023 8.45718 15.0037 8.42595 15.005 8.3874C15.0077 8.31013 15.01 8.20442 15.0089 8.07478C15.0068 7.81582 14.9908 7.46155 14.9361 7.04622C14.8269 6.2181 14.5613 5.13229 13.9295 4.07385C12.6805 1.9816 10.8188 1.0946 10.7032 1.04322Z M10.7929 3.59789C10.5691 3.43615 10.2565 3.48647 10.0948 3.71029C9.93304 3.93411 9.98336 4.24666 10.2072 4.40841C10.2108 4.411 10.2172 4.41532 10.2262 4.42136C10.349 4.50354 10.9494 4.90537 11.3546 5.6588C11.7816 6.45284 11.7748 7.18585 11.7742 7.24663L11.7742 7.24987C11.7742 7.52601 11.9981 7.74987 12.2742 7.74987C12.5503 7.74987 12.7742 7.52601 12.7742 7.24987C12.7742 7.24987 12.7745 7.22202 12.774 7.18696C12.7734 7.15046 12.7719 7.10207 12.7684 7.04332C12.7614 6.926 12.7463 6.7673 12.714 6.57927C12.6495 6.20426 12.5154 5.70587 12.2353 5.18515C11.9534 4.66095 11.5998 4.27037 11.3136 4.00773C11.0285 3.74616 10.7896 3.59553 10.7929 3.59789Z M2.5375 10.7063C1.43302 8.79328 2.08847 6.34712 4.00148 5.24264C5.9145 4.13816 8.36066 4.79361 9.46514 6.70662L10.2859 8.12691L12.1911 9.51304C12.3279 9.61261 12.4051 9.77467 12.3962 9.94369C12.3873 10.1127 12.2935 10.2657 12.1469 10.3504L9.61653 11.8113L9.61972 11.8135L6.88163 13.3943L6.88132 13.3905L4.3527 14.8504C4.20612 14.935 4.02668 14.9397 3.87585 14.8629C3.72502 14.7861 3.62327 14.6383 3.60547 14.4699L3.35766 12.1269L2.5375 10.7063ZM3.40352 10.2063L4.27674 11.7188C4.31172 11.7794 4.33359 11.8466 4.34095 11.9162L4.519 13.5997L10.9806 9.86903L9.61174 8.87312C9.55517 8.83196 9.50787 8.77939 9.47289 8.7188L8.59911 7.20662C7.77078 5.7719 5.9362 5.28033 4.50148 6.10866C3.06676 6.937 2.57519 8.77157 3.40352 10.2063Z M7.25167 14.3354C7.78058 15.0079 8.7369 15.2072 9.49948 14.7669C10.262 14.3266 10.5676 13.3988 10.2497 12.6045L7.25167 14.3354Z " },
            { FluentSymbol.AlertUrgent20Filled, "M2.46554 12.2481C1.30685 9.64564 2.47725 6.59664 5.0797 5.43796C7.68215 4.27927 10.7311 5.44968 11.8898 8.05212L13.1137 10.8011L14.7782 12.4196C15.1586 12.7895 15.0451 13.4266 14.5604 13.6424L4.83302 17.9733C4.34829 18.1892 3.79887 17.8472 3.77852 17.317L3.68945 14.997L2.46554 12.2481Z M8.82976 17.336C9.22367 17.9335 10.0031 18.176 10.6784 17.8753C11.3537 17.5746 11.6951 16.8332 11.5146 16.1406L8.82976 17.336Z M12.0857 4.72704C12.2403 4.4982 12.5511 4.43799 12.7799 4.59256C14.3875 5.67835 15.4952 7.23056 15.668 9.01702C15.6836 9.17779 15.6915 9.34008 15.6915 9.50364C15.6915 9.77978 15.4677 10.0036 15.1915 10.0036C14.9154 10.0036 14.6915 9.77978 14.6915 9.50364C14.6915 9.37234 14.6852 9.2422 14.6727 9.11334C14.5356 7.69633 13.6481 6.38572 12.2202 5.42124C11.9914 5.26667 11.9311 4.95587 12.0857 4.72704Z M12.5763 2.24174C12.7206 2.00629 13.0284 1.9324 13.2639 2.07669C15.7221 3.58319 17.8432 5.88228 17.9997 9.98058C18.0102 10.2565 17.7951 10.4888 17.5191 10.4993C17.2432 10.5098 17.0109 10.2947 17.0004 10.0187C16.86 6.34257 14.9988 4.31277 12.7413 2.92931C12.5059 2.78502 12.432 2.47719 12.5763 2.24174Z " },
            { FluentSymbol.AlertUrgent20, "M13.2639 2.07669C13.0284 1.9324 12.7206 2.00629 12.5763 2.24174C12.432 2.47719 12.5059 2.78502 12.7414 2.92931C14.9988 4.31277 16.8601 6.34257 17.0004 10.0187C17.011 10.2947 17.2432 10.5098 17.5191 10.4993C17.7951 10.4888 18.0102 10.2565 17.9997 9.98058C17.8432 5.88228 15.7221 3.58319 13.2639 2.07669Z M12.0857 4.72703C12.2403 4.49819 12.5511 4.43798 12.7799 4.59255C14.3874 5.67834 15.4952 7.23055 15.668 9.01701C15.6836 9.17778 15.6915 9.34007 15.6915 9.50363C15.6915 9.77977 15.4676 10.0036 15.1915 10.0036C14.9153 10.0036 14.6915 9.77977 14.6915 9.50363C14.6915 9.37233 14.6851 9.24219 14.6727 9.11333C14.5356 7.69632 13.6481 6.38571 12.2202 5.42123C11.9913 5.26666 11.9311 4.95586 12.0857 4.72703Z M5.0797 5.43789C2.47725 6.59657 1.30685 9.64557 2.46554 12.248L3.68945 14.997L3.77852 17.3169C3.79887 17.8471 4.34829 18.1891 4.83302 17.9733L14.5604 13.6424C15.0451 13.4266 15.1586 12.7894 14.7782 12.4195L13.1137 10.801L11.8898 8.05205C10.7311 5.44961 7.68215 4.27921 5.0797 5.43789ZM3.37908 11.8413C2.44503 9.74337 3.38853 7.28549 5.48644 6.35144C7.58435 5.41739 10.0422 6.36088 10.9763 8.45879L12.2785 11.3837L13.8163 12.879L4.76362 16.9095L4.68132 14.7662L3.37908 11.8413Z M10.6784 17.8752C10.0031 18.1759 9.22366 17.9335 8.82975 17.3359L11.5146 16.1406C11.6951 16.8331 11.3537 17.5746 10.6784 17.8752Z " },
            { FluentSymbol.AlertUrgent24Filled, "M10.4286 19.9244L13.9911 18.4123C14.1244 19.2925 13.6531 20.185 12.7958 20.5489C11.9385 20.9128 10.9692 20.6318 10.4286 19.9244ZM15.8613 2.09392C17.947 3.23347 19.5128 4.69659 20.543 6.48101C21.5732 8.26543 22.0575 10.353 22.0015 12.7291C21.9917 13.1432 21.6481 13.4709 21.234 13.4612C20.8199 13.4514 20.4921 13.1078 20.5019 12.6937C20.5516 10.5824 20.1304 8.76635 19.244 7.23101C18.3575 5.69566 16.9954 4.42285 15.1421 3.41027C14.7786 3.21167 14.6449 2.756 14.8435 2.3925C15.0421 2.029 15.4978 1.89532 15.8613 2.09392ZM6.71144 6.51547C9.57319 5.24134 12.9156 6.4461 14.3109 9.26099L14.4092 9.47041L15.6966 12.3623L17.3949 13.832C17.4876 13.9123 17.5679 14.0057 17.661 14.1568L17.7197 14.2711C17.9991 14.9024 17.7138 15.6407 17.0825 15.9201L6.75588 20.4902C6.59655 20.5607 6.42424 20.5972 6.25 20.5972C5.55964 20.5972 5 20.0375 5 19.3475L4.99892 17.0046L3.75654 14.2132C2.44304 11.2631 3.76572 7.82699 6.71144 6.51547ZM15.6237 5.69457C16.5907 6.22184 17.3657 6.9892 17.94 7.98387C18.5142 8.97855 18.7913 10.0334 18.7644 11.1345C18.7543 11.5486 18.4105 11.8761 17.9964 11.866C17.5823 11.8559 17.2548 11.512 17.2649 11.0979C17.2849 10.2763 17.0792 9.49294 16.6409 8.73387C16.2027 7.97481 15.6272 7.40494 14.9056 7.01151C14.542 6.81321 14.4079 6.35765 14.6062 5.99399C14.8045 5.63033 15.2601 5.49627 15.6237 5.69457Z " },
            { FluentSymbol.AlertUrgent24, "M10.4286 19.9244L13.9911 18.4123C14.1244 19.2925 13.6531 20.185 12.7958 20.5489C11.9385 20.9128 10.9692 20.6318 10.4286 19.9244ZM15.8613 2.09392C17.947 3.23347 19.5128 4.69659 20.543 6.48101C21.5732 8.26543 22.0575 10.353 22.0015 12.7291C21.9917 13.1432 21.6481 13.4709 21.234 13.4612C20.8199 13.4514 20.4921 13.1078 20.5019 12.6937C20.5516 10.5824 20.1304 8.76635 19.244 7.23101C18.3575 5.69566 16.9954 4.42285 15.1421 3.41027C14.7786 3.21167 14.6449 2.756 14.8435 2.3925C15.0421 2.029 15.4978 1.89532 15.8613 2.09392ZM6.71144 6.51547C9.57319 5.24134 12.9156 6.4461 14.3109 9.26099L14.4092 9.47041L15.6966 12.3623L17.3949 13.832C17.4876 13.9123 17.5679 14.0057 17.661 14.1568L17.7197 14.2711C17.9991 14.9024 17.7138 15.6407 17.0825 15.9201L6.75588 20.4902C6.59655 20.5607 6.42424 20.5972 6.25 20.5972C5.55964 20.5972 5 20.0375 5 19.3475L4.99892 17.0046L3.75654 14.2132C2.44304 11.2631 3.76572 7.82699 6.71144 6.51547ZM5.1269 13.6032L6.49877 16.6855L6.49982 18.9632L16.1149 14.708L14.4622 13.2777L13.0453 10.0946L12.9603 9.91326C11.9289 7.83289 9.44847 6.93882 7.32154 7.88579C5.13205 8.86061 4.15056 11.4103 5.1269 13.6032ZM15.6237 5.69457C16.5907 6.22184 17.3657 6.9892 17.94 7.98387C18.5142 8.97855 18.7913 10.0334 18.7644 11.1345C18.7543 11.5486 18.4105 11.8761 17.9964 11.866C17.5823 11.8559 17.2548 11.512 17.2649 11.0979C17.2849 10.2763 17.0792 9.49294 16.6409 8.73387C16.2027 7.97481 15.6272 7.40494 14.9056 7.01151C14.542 6.81321 14.4079 6.35765 14.6062 5.99399C14.8045 5.63033 15.2601 5.49627 15.6237 5.69457Z " },
            { FluentSymbol.AnimalDog20Filled, "M12 2C11.67 2 11.1861 2.09489 10.7703 2.39423C10.3291 2.71193 10 3.23704 10 4V5.25315C10 5.3813 10.0426 5.58501 10.1556 5.74197C10.2502 5.87343 10.4124 6.00249 10.749 6.00249C11.0856 6.00249 11.2478 5.87343 11.3424 5.74197C11.4554 5.58501 11.498 5.38165 11.498 5.2535C11.498 4.97735 11.7218 4.7535 11.998 4.7535C12.2741 4.7535 12.498 4.97735 12.498 5.2535C12.498 5.54167 12.4156 5.96281 12.154 6.32627C11.8739 6.71523 11.4116 7.00249 10.749 7.00249C10.4283 7.00249 10.1544 6.93517 9.92549 6.82158C9.78246 7.93408 9.36497 9.42793 8.14645 10.6464C7.05951 11.7334 6.52746 13.0786 6.26493 14.1287C6.13295 14.6567 6.06689 15.1186 6.03373 15.4502C6.01713 15.6163 6.0087 15.7504 6.00442 15.8445C6.00228 15.8916 6.00118 15.9287 6.00061 15.955L6.00009 15.986L6.00001 15.9952L6.00001 15.9971L5.99991 16.0002C5.99974 16.0053 5.99933 16.0151 5.99834 16.0288C5.99636 16.0566 5.99216 16.0994 5.98337 16.1522C5.96539 16.2601 5.93036 16.3963 5.86529 16.5264C5.80119 16.6546 5.71291 16.7676 5.58984 16.8496C5.4699 16.9296 5.28751 17 5 17C3.89543 17 3 16.1046 3 15C3 14.3462 3.31314 13.7658 3.79972 13.4C4.02046 13.2341 4.06489 12.9207 3.89897 12.6999C3.73305 12.4792 3.4196 12.4347 3.19886 12.6007C2.4718 13.1472 2 14.0186 2 15C2 16.6569 3.34315 18 5 18H13V17.5C13 17.0951 12.8115 16.4542 12.2672 16.1678C12.0815 16.07 11.8338 16 11.5 16H10.5C10.2239 16 10 15.7761 10 15.5C10 15.2239 10.2239 15 10.5 15H11.5C11.6759 15 11.8425 15.0138 12 15.0401V12.5C12 12.2239 12.2239 12 12.5 12C12.7761 12 13 12.2239 13 12.5V15.4481C13.7896 16.0174 14 16.9661 14 17.5V18H16.5C16.7761 18 17 17.7761 17 17.5C17 16.6298 16.7041 15.9775 16.1951 15.5534C15.8427 15.2597 15.4214 15.1031 15 15.0377V7H15.5C16.3284 7 17 6.32843 17 5.5V4.2831C17 3.93183 16.8157 3.60633 16.5145 3.4256L14.7323 2.35627C14.3437 2.12314 13.8991 2 13.446 2H12Z " },
            { FluentSymbol.AnimalDog20, "M10.7703 2.39423C11.1861 2.09489 11.67 2 12 2H13.446C13.8991 2 14.3437 2.12314 14.7323 2.35627L16.5145 3.4256C16.8157 3.60633 17 3.93183 17 4.2831V5.5C17 6.32843 16.3284 7 15.5 7H15V15.0377C15.4214 15.1031 15.8427 15.2597 16.1951 15.5534C16.7041 15.9775 17 16.6298 17 17.5C17 17.7761 16.7761 18 16.5 18H13.5008H5C3.34315 18 2 16.6569 2 15C2 14.0194 2.47097 13.1487 3.19692 12.6021C3.41753 12.436 3.73101 12.4802 3.89711 12.7008C4.06321 12.9214 4.01903 13.2349 3.79843 13.401C3.31258 13.7668 3 14.3468 3 15C3 16.1046 3.89543 17 5 17C5.28751 17 5.4699 16.9296 5.58984 16.8496C5.71291 16.7676 5.80119 16.6546 5.86529 16.5264C5.93036 16.3963 5.96539 16.2601 5.98337 16.1522C5.99216 16.0994 5.99636 16.0566 5.99834 16.0288C5.99933 16.0151 5.99974 16.0053 5.99991 16.0002L6.00001 15.9971L6.00001 15.9952L6.00009 15.986L6.00061 15.955C6.00118 15.9287 6.00228 15.8916 6.00442 15.8445C6.0087 15.7504 6.01713 15.6163 6.03373 15.4502C6.06689 15.1186 6.13295 14.6567 6.26493 14.1287C6.52746 13.0786 7.05951 11.7334 8.14645 10.6464C9.98945 8.80344 10 6.33059 10 5.5V4C10 3.23704 10.3291 2.71193 10.7703 2.39423ZM10.924 6.90034C10.7686 8.15605 10.2952 9.91192 8.85355 11.3536C7.94049 12.2666 7.47254 13.4214 7.23507 14.3713C7.11705 14.8433 7.05811 15.2564 7.02877 15.5498C7.01412 15.6962 7.00692 15.8121 7.00339 15.8899C7.00162 15.9287 7.00078 15.958 7.00037 15.9767L7.00003 15.9967L7 16.001L7 16.0022L6.99998 16.0051L6.99989 16.0124L6.99936 16.0335C6.99879 16.0504 6.99775 16.0728 6.9958 16.1001C6.99192 16.1544 6.9844 16.2287 6.96976 16.3166C6.94086 16.4899 6.88214 16.7287 6.75971 16.9736C6.75532 16.9824 6.75085 16.9912 6.74628 17H12.9194C12.8188 16.6806 12.6161 16.3513 12.2672 16.1678C12.0815 16.07 11.833 16 11.4992 16H10.5C10.2239 16 10 15.7761 10 15.5C10 15.2239 10.2239 15 10.5 15H11.5C11.6759 15 11.8425 15.0138 12 15.0401V12.5C12 12.2239 12.2239 12 12.5 12C12.7761 12 13 12.2239 13 12.5V15.4481C13.5792 15.8657 13.8468 16.4875 13.9482 17H15.9481C15.8725 16.6723 15.7226 16.4614 15.5549 16.3216C15.2979 16.1074 14.9257 16 14.5 16C14.2239 16 14 15.7761 14 15.5V6.5C14 6.22386 14.2239 6 14.5 6H15.5C15.7761 6 16 5.77614 16 5.5V4.2831L14.2178 3.21376C13.9847 3.07389 13.7179 3 13.446 3H12C11.83 3 11.5639 3.05511 11.3547 3.20577C11.1709 3.33807 11 3.56296 11 4V5.5C11 5.58666 11.0301 5.72777 11.1058 5.83285C11.1631 5.91243 11.263 6 11.5 6C11.737 6 11.8369 5.91243 11.8942 5.83285C11.9699 5.72777 12 5.58666 12 5.5C12 5.22386 12.2239 5 12.5 5C12.7761 5 13 5.22386 13 5.5C13 5.74668 12.9301 6.10557 12.7058 6.41715C12.4631 6.75423 12.063 7 11.5 7C11.2842 7 11.0923 6.96388 10.924 6.90034Z " },
            { FluentSymbol.AnimalDog24Filled, "M10.8755 8.66109C11.2633 8.87708 11.7237 8.99978 12.246 8.99978C13.0932 8.99978 13.8013 8.69298 14.2926 8.15625C14.7742 7.63006 14.996 6.93974 14.996 6.25C14.996 5.83579 14.6602 5.5 14.246 5.5C13.8318 5.5 13.496 5.83579 13.496 6.25C13.496 6.6269 13.3756 6.93646 13.1861 7.14351C13.0062 7.34 12.7144 7.49978 12.246 7.49978C11.7974 7.49978 11.5155 7.33774 11.332 7.12921C11.1473 6.9194 11.0279 6.62077 11 6.2896V4.25002C11 3.00796 12.0059 2.00003 13.2491 2.00002L16.4346 2C16.9438 2 17.442 2.14136 17.8752 2.40794L20.6431 4.11126C20.8649 4.24776 21 4.48955 21 4.75V6.25C21 7.49264 19.9926 8.5 18.75 8.5H18.5V18.0329C19.4194 18.1215 20.1183 18.3993 20.5471 18.9975C20.8038 19.3557 20.9075 19.7575 20.9548 20.1257C21.0001 20.4778 21 20.862 21 21.2162V21.25C21 21.6642 20.6642 22 20.25 22H16.9983L16.9983 21.2256C16.9986 20.6541 16.9996 19.0178 15.4983 18.0572V15.2527C15.4983 14.8385 15.1625 14.5027 14.7483 14.5027C14.334 14.5027 13.9983 14.8385 13.9983 15.2527V17.5189C13.8358 17.5012 13.6688 17.493 13.4983 17.493C13.4248 17.493 13.3528 17.495 13.301 17.497C13.2747 17.4979 13.2525 17.4989 13.2366 17.4996L13.2176 17.5006L13.212 17.5009L13.2093 17.501C12.7957 17.5235 12.4786 17.877 12.5011 18.2906C12.5236 18.7042 12.8774 19.0213 13.291 18.9988L13.2938 18.9986L13.3069 18.998L13.3562 18.9959C13.3982 18.9944 13.4503 18.993 13.4983 18.993C13.93 18.993 14.2134 19.0659 14.399 19.1636C14.4098 19.1693 14.4207 19.1747 14.4317 19.1798C15.4709 19.6636 15.4983 20.6188 15.4983 21.2499V22H5.83333C3.71624 22 2 20.2838 2 18.1667C2 16.7686 2.74891 15.5462 3.86385 14.8774C4.21907 14.6644 4.67975 14.7796 4.89281 15.1348C5.10587 15.49 4.99062 15.9507 4.63541 16.1638C3.95359 16.5727 3.5 17.3171 3.5 18.1667C3.5 19.4553 4.54467 20.5 5.83333 20.5C6.15188 20.5 6.34997 20.4168 6.48162 20.3242C6.62082 20.2262 6.72963 20.086 6.81348 19.9168C6.89798 19.7464 6.94675 19.5671 6.97352 19.4243C6.98658 19.3546 6.99358 19.2981 6.9972 19.2618C6.99876 19.246 6.99967 19.2343 7.00015 19.2273L7.00059 19.1925C7.00115 19.1586 7.00224 19.1104 7.00436 19.0493C7.00859 18.9273 7.01695 18.7535 7.03348 18.5397C7.06646 18.1132 7.13235 17.5223 7.26464 16.8627C7.52372 15.5707 8.06051 13.8945 9.21612 12.7232C10.0641 11.8638 10.525 10.6045 10.7634 9.35924C10.809 9.12116 10.8458 8.88724 10.8755 8.66109Z " },
            { FluentSymbol.AnimalDog24, "M13.2491 2.00002L16.4346 2C16.9438 2 17.442 2.14135 17.8752 2.40794L20.6431 4.11125C20.8649 4.24775 21 4.48955 21 4.75V6.25C21 7.49264 19.9926 8.5 18.75 8.5H18.5V17.5469C19.497 17.6807 20.1945 18.1015 20.5946 18.8224C20.8179 19.2247 20.9126 19.6625 20.9569 20.0651C21.0001 20.4561 21 20.8643 21 21.2247V21.25C21 21.6642 20.6642 22 20.25 22H16.2508H5.83333C3.71624 22 2 20.2838 2 18.1667C2 16.7686 2.74891 15.5462 3.86385 14.8774C4.21907 14.6644 4.67975 14.7796 4.89281 15.1348C5.10587 15.49 4.99062 15.9507 4.63541 16.1638C3.95359 16.5727 3.5 17.3171 3.5 18.1667C3.5 19.4553 4.54467 20.5 5.83333 20.5C6.15188 20.5 6.34997 20.4168 6.48162 20.3242C6.62082 20.2262 6.72963 20.0859 6.81348 19.9168C6.89798 19.7464 6.94675 19.5671 6.97352 19.4243C6.98658 19.3546 6.99358 19.2981 6.9972 19.2617C6.99876 19.246 6.99967 19.2343 7.00015 19.2273L7.00059 19.1925C7.00115 19.1586 7.00224 19.1104 7.00436 19.0493C7.00859 18.9273 7.01695 18.7535 7.03348 18.5397C7.06646 18.1132 7.13235 17.5223 7.26464 16.8627C7.52372 15.5707 8.06051 13.8945 9.21612 12.7232C10.0641 11.8638 10.525 10.6045 10.7634 9.35923C10.9991 8.12815 11 7.00801 11 6.5V4.25002C11 3.00796 12.0059 2.00003 13.2491 2.00002ZM7.75 19.25C8.49958 19.275 8.49956 19.2757 8.49956 19.2757L8.49948 19.2781L8.49932 19.2819L8.49888 19.2919L8.49726 19.3205C8.4958 19.3433 8.49348 19.3735 8.48984 19.4101C8.48259 19.4831 8.46993 19.5829 8.44783 19.7007C8.40796 19.9134 8.33458 20.2001 8.19703 20.5H15.4473C15.3561 20.0064 15.1078 19.4939 14.4335 19.1799C14.4224 19.1748 14.4115 19.1694 14.4008 19.1637C14.3486 19.1363 14.1994 19.0871 13.9516 19.0479C13.7216 19.0116 13.4674 18.9931 13.25 18.9931C13.1964 18.9931 13.0783 18.9947 12.9672 18.9965L12.8256 18.9988L12.7665 18.9999L12.7655 18.9999C12.3513 19.0075 12.0095 18.6779 12.0019 18.2637C11.9943 17.8496 12.3239 17.5077 12.738 17.5001L12.7995 17.499L12.9435 17.4966C13.0511 17.4949 13.1822 17.4931 13.25 17.4931C13.4846 17.4931 13.7453 17.5086 14 17.5402V15.2528C14 14.8386 14.3358 14.5028 14.75 14.5028C15.1642 14.5028 15.5 14.8386 15.5 15.2528V18.0573C16.5648 18.7386 16.8739 19.7599 16.9635 20.5H19.4875C19.4825 20.407 19.4756 20.317 19.466 20.2294C19.4328 19.9286 19.3719 19.7103 19.2831 19.5504C19.153 19.3159 18.8498 19 17.75 19C17.3358 19 17 18.6642 17 18.25V7.75C17 7.33579 17.3358 7 17.75 7H18.75C19.1642 7 19.5 6.66421 19.5 6.25V5.16909L17.089 3.68543C16.8918 3.56405 16.6657 3.5 16.4346 3.5L13.2491 3.50002C12.8355 3.50002 12.5 3.83523 12.5 4.25002V6.48171C12.5128 6.71048 12.592 6.90709 12.7051 7.03567C12.8062 7.15046 12.9658 7.25 13.25 7.25C13.5368 7.25 13.7027 7.14866 13.8057 7.031C13.9206 6.89967 14 6.69587 14 6.45C14 6.03579 14.3358 5.7 14.75 5.7C15.1642 5.7 15.5 6.03579 15.5 6.45C15.5 7.00412 15.3227 7.57533 14.9343 8.01899C14.534 8.47634 13.9499 8.75 13.25 8.75C12.938 8.75 12.6513 8.69566 12.3945 8.59601C12.3568 8.92795 12.3058 9.27987 12.2366 9.64132C11.975 11.0074 11.4359 12.6092 10.2839 13.7768C9.43949 14.6326 8.97628 15.9563 8.73536 17.1576C8.61765 17.7446 8.55854 18.2736 8.52902 18.6554C8.5143 18.8458 8.50703 18.9982 8.50346 19.1013C8.50167 19.1529 8.5008 19.192 8.50039 19.2173L8.50004 19.2446L8.5 19.25C8.5 19.2582 8.49983 19.2675 8.49956 19.2757L7.75 19.25Z " },
            { FluentSymbol.AppFolder20Filled, "M2 4.5C2 3.11929 3.11929 2 4.5 2H15.5C16.8807 2 18 3.11929 18 4.5V15.5C18 16.8807 16.8807 18 15.5 18H4.5C3.11929 18 2 16.8807 2 15.5V4.5ZM4.5 3C3.67157 3 3 3.67157 3 4.5V15.5C3 16.3284 3.67157 17 4.5 17H15.5C16.3284 17 17 16.3284 17 15.5V4.5C17 3.67157 16.3284 3 15.5 3H4.5Z M11 12C11 11.4477 11.4477 11 12 11H14C14.5523 11 15 11.4477 15 12V14C15 14.5523 14.5523 15 14 15H12C11.4477 15 11 14.5523 11 14V12Z M11 6C11 5.44772 11.4477 5 12 5H14C14.5523 5 15 5.44772 15 6V8C15 8.55228 14.5523 9 14 9H12C11.4477 9 11 8.55228 11 8V6Z M5 12C5 11.4477 5.44772 11 6 11H8C8.55228 11 9 11.4477 9 12V14C9 14.5523 8.55228 15 8 15H6C5.44772 15 5 14.5523 5 14V12Z M5 6C5 5.44772 5.44772 5 6 5H8C8.55228 5 9 5.44772 9 6V8C9 8.55228 8.55228 9 8 9H6C5.44772 9 5 8.55228 5 8V6Z " },
            { FluentSymbol.AppFolder20, "M2 4.5C2 3.11929 3.11929 2 4.5 2H15.5C16.8807 2 18 3.11929 18 4.5V15.5C18 16.8807 16.8807 18 15.5 18H4.5C3.11929 18 2 16.8807 2 15.5V4.5ZM4.5 3C3.67157 3 3 3.67157 3 4.5V15.5C3 16.3284 3.67157 17 4.5 17H15.5C16.3284 17 17 16.3284 17 15.5V4.5C17 3.67157 16.3284 3 15.5 3H4.5Z M5 6C5 5.44772 5.44772 5 6 5H8C8.55228 5 9 5.44772 9 6V8C9 8.55228 8.55228 9 8 9H6C5.44772 9 5 8.55228 5 8V6ZM8 6H6V8H8V6Z M5 12C5 11.4477 5.44772 11 6 11H8C8.55228 11 9 11.4477 9 12V14C9 14.5523 8.55228 15 8 15H6C5.44772 15 5 14.5523 5 14V12ZM8 12H6V14H8V12Z M11 6C11 5.44772 11.4477 5 12 5H14C14.5523 5 15 5.44772 15 6V8C15 8.55228 14.5523 9 14 9H12C11.4477 9 11 8.55228 11 8V6ZM14 6H12V8H14V6Z M11 12C11 11.4477 11.4477 11 12 11H14C14.5523 11 15 11.4477 15 12V14C15 14.5523 14.5523 15 14 15H12C11.4477 15 11 14.5523 11 14V12ZM14 12H12V14H14V12Z " },
            { FluentSymbol.AppFolder24Filled, "M18.25 3C19.7688 3 21 4.23122 21 5.75V18.25C21 19.7688 19.7688 21 18.25 21H5.75C4.23122 21 3 19.7688 3 18.25V5.75C3 4.23122 4.23122 3 5.75 3H18.25ZM18.25 4.5H5.75C5.05964 4.5 4.5 5.05964 4.5 5.75V18.25C4.5 18.9404 5.05964 19.5 5.75 19.5H18.25C18.9404 19.5 19.5 18.9404 19.5 18.25V5.75C19.5 5.05964 18.9404 4.5 18.25 4.5ZM9.7519 12.5C10.7184 12.5 11.5019 13.2835 11.5019 14.25V16.25C11.5019 17.2165 10.7184 18 9.7519 18H7.7519C6.7854 18 6.0019 17.2165 6.0019 16.25V14.25C6.0019 13.2835 6.7854 12.5 7.7519 12.5H9.7519ZM16.2494 12.5C17.2159 12.5 17.9994 13.2835 17.9994 14.25V16.25C17.9994 17.2165 17.2159 18 16.2494 18H14.2494C13.2829 18 12.4994 17.2165 12.4994 16.25V14.25C12.4994 13.2835 13.2829 12.5 14.2494 12.5H16.2494ZM9.75063 6C10.7171 6 11.5006 6.7835 11.5006 7.75V9.75C11.5006 10.7165 10.7171 11.5 9.75063 11.5H7.75063C6.78413 11.5 6.00063 10.7165 6.00063 9.75V7.75C6.00063 6.7835 6.78413 6 7.75063 6H9.75063ZM16.2481 6C17.2146 6 17.9981 6.7835 17.9981 7.75V9.75C17.9981 10.7165 17.2146 11.5 16.2481 11.5H14.2481C13.2816 11.5 12.4981 10.7165 12.4981 9.75V7.75C12.4981 6.7835 13.2816 6 14.2481 6H16.2481Z " },
            { FluentSymbol.AppFolder24, "M18.25 3C19.7688 3 21 4.23122 21 5.75V18.25C21 19.7688 19.7688 21 18.25 21H5.75C4.23122 21 3 19.7688 3 18.25V5.75C3 4.23122 4.23122 3 5.75 3H18.25ZM18.25 4.5H5.75C5.05964 4.5 4.5 5.05964 4.5 5.75V18.25C4.5 18.9404 5.05964 19.5 5.75 19.5H18.25C18.9404 19.5 19.5 18.9404 19.5 18.25V5.75C19.5 5.05964 18.9404 4.5 18.25 4.5ZM9.7519 12.5C10.7184 12.5 11.5019 13.2835 11.5019 14.25V16.25C11.5019 17.2165 10.7184 18 9.7519 18H7.7519C6.7854 18 6.0019 17.2165 6.0019 16.25V14.25C6.0019 13.2835 6.7854 12.5 7.7519 12.5H9.7519ZM16.2494 12.5C17.2159 12.5 17.9994 13.2835 17.9994 14.25V16.25C17.9994 17.2165 17.2159 18 16.2494 18H14.2494C13.2829 18 12.4994 17.2165 12.4994 16.25V14.25C12.4994 13.2835 13.2829 12.5 14.2494 12.5H16.2494ZM9.7519 14H7.7519C7.61383 14 7.5019 14.1119 7.5019 14.25V16.25C7.5019 16.3881 7.61383 16.5 7.7519 16.5H9.7519C9.88997 16.5 10.0019 16.3881 10.0019 16.25V14.25C10.0019 14.1119 9.88997 14 9.7519 14ZM16.2494 14H14.2494C14.1113 14 13.9994 14.1119 13.9994 14.25V16.25C13.9994 16.3881 14.1113 16.5 14.2494 16.5H16.2494C16.3874 16.5 16.4994 16.3881 16.4994 16.25V14.25C16.4994 14.1119 16.3874 14 16.2494 14ZM9.75063 6C10.7171 6 11.5006 6.7835 11.5006 7.75V9.75C11.5006 10.7165 10.7171 11.5 9.75063 11.5H7.75063C6.78413 11.5 6.00063 10.7165 6.00063 9.75V7.75C6.00063 6.7835 6.78413 6 7.75063 6H9.75063ZM16.2481 6C17.2146 6 17.9981 6.7835 17.9981 7.75V9.75C17.9981 10.7165 17.2146 11.5 16.2481 11.5H14.2481C13.2816 11.5 12.4981 10.7165 12.4981 9.75V7.75C12.4981 6.7835 13.2816 6 14.2481 6H16.2481ZM9.75063 7.5H7.75063C7.61256 7.5 7.50063 7.61193 7.50063 7.75V9.75C7.50063 9.88807 7.61256 10 7.75063 10H9.75063C9.8887 10 10.0006 9.88807 10.0006 9.75V7.75C10.0006 7.61193 9.8887 7.5 9.75063 7.5ZM16.2481 7.5H14.2481C14.11 7.5 13.9981 7.61193 13.9981 7.75V9.75C13.9981 9.88807 14.11 10 14.2481 10H16.2481C16.3862 10 16.4981 9.88807 16.4981 9.75V7.75C16.4981 7.61193 16.3862 7.5 16.2481 7.5Z " },
            { FluentSymbol.AppGeneric24Filled, "M17.75 3L17.9344 3.00514C19.5837 3.09734 20.9039 4.4175 20.9961 6.06558L21.0012 6.25V17.75L20.9961 17.9344C20.9039 19.5825 19.5837 20.9027 17.9356 20.9949L17.7512 21H6.25C4.51697 21 3.10075 19.6435 3.00514 17.9344L3 17.75V6.25C3 4.51697 4.35645 3.10075 6.06558 3.00514L6.25 3H17.75ZM19 8H5.0012L5 17.75C5 18.3972 5.49187 18.9295 6.12219 18.9935L6.25 19H17.7512L17.879 18.9935C18.4673 18.9338 18.935 18.4661 18.9947 17.8778L19.0012 17.75L19 8ZM10.25 9.5C10.6297 9.5 10.9435 9.78215 10.9932 10.1482L11 10.25V17.25C11 17.6297 10.7178 17.9435 10.3518 17.9932L10.25 18H6.75C6.3703 18 6.05651 17.7178 6.00685 17.3518L6 17.25V10.25C6 9.8703 6.28215 9.55651 6.64823 9.50685L6.75 9.5H10.25ZM9.5 11H7.5V16.5H9.5V11ZM16.25 12.503C16.6642 12.503 17 12.8388 17 13.253C17 13.6327 16.7178 13.9465 16.3518 13.9961L16.25 14.003H12.7544C12.3402 14.003 12.0044 13.6672 12.0044 13.253C12.0044 12.8733 12.2866 12.5595 12.6526 12.5098L12.7544 12.503H16.25ZM17.25 9.5C17.6642 9.5 18 9.83579 18 10.25C18 10.6297 17.7178 10.9435 17.3518 10.9932L17.25 11H12.7544C12.3402 11 12.0044 10.6642 12.0044 10.25C12.0044 9.8703 12.2866 9.55651 12.6526 9.50685L12.7544 9.5H17.25Z " },
            { FluentSymbol.AppGeneric24, "M17.7512 3L17.9356 3.00514C19.5837 3.09734 20.9039 4.4175 20.9961 6.06558L21.0012 6.25V17.75L20.9961 17.9344C20.9004 19.6435 19.4842 21 17.7512 21H6.25C4.51697 21 3.10075 19.6435 3.00514 17.9344L3 17.75V6.25C3 4.51697 4.35645 3.10075 6.06558 3.00514L6.25 3H17.7512ZM19.5 8H4.5012L4.5 17.75C4.5 18.6682 5.20711 19.4212 6.10647 19.4942L6.25 19.5H17.7512L17.8947 19.4942C18.7441 19.4253 19.422 18.7498 19.4947 17.9014L19.5012 17.75L19.5 8ZM10.25 9.5C10.6297 9.5 10.9435 9.78215 10.9932 10.1482L11 10.25V17.25C11 17.6297 10.7178 17.9435 10.3518 17.9932L10.25 18H6.75C6.3703 18 6.05651 17.7178 6.00685 17.3518L6 17.25V10.25C6 9.8703 6.28215 9.55651 6.64823 9.50685L6.75 9.5H10.25ZM9.5 11H7.5V16.5H9.5V11ZM16.25 12.503C16.6642 12.503 17 12.8388 17 13.253C17 13.6327 16.7178 13.9465 16.3518 13.9961L16.25 14.003H12.7544C12.3402 14.003 12.0044 13.6672 12.0044 13.253C12.0044 12.8733 12.2866 12.5595 12.6526 12.5098L12.7544 12.503H16.25ZM17.25 9.5C17.6642 9.5 18 9.83579 18 10.25C18 10.6297 17.7178 10.9435 17.3518 10.9932L17.25 11H12.7544C12.3402 11 12.0044 10.6642 12.0044 10.25C12.0044 9.8703 12.2866 9.55651 12.6526 9.50685L12.7544 9.5H17.25Z " },
            { FluentSymbol.AppRecent24Filled, "M18 19.75C18 20.9409 17.0748 21.9156 15.904 21.9948L15.75 22H8.25C7.05914 22 6.08436 21.0748 6.00519 19.904L6 19.75V4.25C6 3.05914 6.92516 2.08436 8.09595 2.00519L8.25 2H15.75C16.9409 2 17.9156 2.92516 17.9948 4.09595L18 4.25V19.75ZM19 5H19.75C20.9409 5 21.9156 5.92516 21.9948 7.09595L22 7.25V16.75C22 17.9409 21.0748 18.9156 19.904 18.9948L19.75 19H19V5ZM5 19H4.25C3.05914 19 2.08436 18.0748 2.00519 16.904L2 16.75V7.25C2 6.05914 2.92516 5.08436 4.09595 5.00519L4.25 5H5V19Z " },
            { FluentSymbol.AppRecent24, "M15.75 2C16.9409 2 17.9156 2.92516 17.9948 4.09595L18 4.25V4.999L19.75 5C20.9409 5 21.9156 5.92516 21.9948 7.09595L22 7.25V16.75C22 17.9409 21.0748 18.9157 19.904 18.9949L19.75 19L18 19V19.75C18 20.9409 17.0748 21.9156 15.904 21.9948L15.75 22H8.25C7.05914 22 6.08436 21.0748 6.00519 19.904L6 19.75V19L4.25 19C3.05914 19 2.08436 18.0749 2.00519 16.9041L2 16.75V7.25C2 6.05914 2.92516 5.08436 4.09595 5.00519L4.25 5L6 4.999V4.25C6 3.05914 6.92516 2.08436 8.09595 2.00519L8.25 2H15.75ZM15.75 3.5H8.25C7.8703 3.5 7.55651 3.78215 7.50685 4.14823L7.5 4.25V19.75C7.5 20.1297 7.78215 20.4435 8.14823 20.4932L8.25 20.5H15.75C16.1297 20.5 16.4435 20.2178 16.4932 19.8518L16.5 19.75V4.25C16.5 3.8703 16.2178 3.55651 15.8518 3.50685L15.75 3.5ZM6 6.499L4.25 6.5C3.8703 6.5 3.55651 6.78215 3.50685 7.14823L3.5 7.25V16.75C3.5 17.1297 3.78215 17.4435 4.14823 17.4932L4.25 17.5H6V6.499ZM19.75 6.5L18 6.499V17.5H19.75C20.1297 17.5 20.4435 17.2179 20.4932 16.8518L20.5 16.75V7.25C20.5 6.83579 20.1642 6.5 19.75 6.5Z " },
            { FluentSymbol.AppStore24Filled, "M17.75 3C19.5449 3 21 4.45507 21 6.25V17.75C21 19.5449 19.5449 21 17.75 21H6.25C4.45507 21 3 19.5449 3 17.75V6.25C3 4.45507 4.45507 3 6.25 3H17.75ZM9.36867 15.2541H7.63067L7.5642 15.3697L7.51877 15.461C7.377 15.8022 7.50562 16.2041 7.83346 16.3956C8.16132 16.5871 8.5746 16.5018 8.80214 16.2108L8.85939 16.1264L9.36867 15.2541ZM13.2926 10.0241L12.4216 11.5161L15.0796 16.1238L15.1364 16.2085C15.3624 16.5008 15.7752 16.5884 16.104 16.3986C16.4329 16.2089 16.5637 15.8077 16.4238 15.4658L16.3789 15.3742L15.8766 14.5041L16.7519 14.5049L16.8537 14.4981C17.1865 14.453 17.4499 14.1895 17.495 13.8567L17.5019 13.7549L17.495 13.6532C17.4499 13.3204 17.1865 13.0569 16.8537 13.0118L16.7519 13.0049L15.0116 13.0041L13.2926 10.0241ZM13.2631 7.10146C12.9353 6.90993 12.522 6.99527 12.2945 7.28631L12.2372 7.37073L11.9965 7.77993L11.7634 7.37425L11.7066 7.28952C11.5033 7.02648 11.1485 6.92924 10.8399 7.05074L10.739 7.09942L10.6542 7.15621C10.3912 7.35957 10.294 7.71428 10.4155 8.02294L10.4641 8.12385L11.1265 9.27093L8.94558 13.0049L7.25158 13.0049L7.14981 13.0118C6.78373 13.0615 6.50158 13.3752 6.50158 13.7549C6.50158 14.1346 6.78373 14.4484 7.14981 14.4981L7.25158 14.5049L13.279 14.5048L12.414 13.0048L10.6826 13.0039L13.5324 8.12738L13.5778 8.03605C13.7196 7.69491 13.591 7.29299 13.2631 7.10146Z " },
            { FluentSymbol.AppStore24, "M17.75 3C19.5449 3 21 4.45507 21 6.25V17.75C21 19.5449 19.5449 21 17.75 21H6.25C4.45507 21 3 19.5449 3 17.75V6.25C3 4.45507 4.45507 3 6.25 3H17.75ZM17.75 4.5H6.25C5.2835 4.5 4.5 5.2835 4.5 6.25V17.75C4.5 18.7165 5.2835 19.5 6.25 19.5H17.75C18.7165 19.5 19.5 18.7165 19.5 17.75V6.25C19.5 5.2835 18.7165 4.5 17.75 4.5ZM9.36867 15.2541L8.85939 16.1264C8.65044 16.484 8.19113 16.6046 7.83346 16.3956C7.50562 16.2041 7.377 15.8022 7.51877 15.461L7.5642 15.3697L7.63067 15.2541H9.36867ZM13.2926 10.0241L15.0116 13.0041L16.7519 13.0049C17.1316 13.0049 17.4454 13.2871 17.495 13.6532L17.5019 13.7549C17.5019 14.1346 17.2197 14.4484 16.8537 14.4981L16.7519 14.5049L15.8766 14.5041L16.3789 15.3742C16.5859 15.733 16.4628 16.1916 16.104 16.3986C15.7752 16.5884 15.3624 16.5008 15.1364 16.2085L15.0796 16.1238L12.4216 11.5161L13.2926 10.0241ZM13.2631 7.10146C13.591 7.29299 13.7196 7.69491 13.5778 8.03605L13.5324 8.12738L10.6826 13.0039L12.414 13.0048L13.279 14.5048L7.25158 14.5049C6.83736 14.5049 6.50158 14.1692 6.50158 13.7549C6.50158 13.3752 6.78373 13.0615 7.14981 13.0118L7.25158 13.0049L8.94558 13.0049L11.1265 9.27093L10.4641 8.12385C10.2744 7.79497 10.362 7.38216 10.6542 7.15621L10.739 7.09942C11.0679 6.90967 11.4807 6.99725 11.7066 7.28952L11.7634 7.37425L11.9965 7.77993L12.2372 7.37073C12.4461 7.01308 12.9055 6.89252 13.2631 7.10146Z " },
            { FluentSymbol.AppTitle24Filled, "M4.75 20.5H19.25C19.6642 20.5 20 20.8358 20 21.25C20 21.6297 19.7178 21.9435 19.3518 21.9932L19.25 22H4.75C4.33579 22 4 21.6642 4 21.25C4 20.8703 4.28215 20.5565 4.64823 20.5068L4.75 20.5H19.25H4.75ZM16.25 3C18.3211 3 20 4.67893 20 6.75V15.25C20 17.3211 18.3211 19 16.25 19H7.75C5.67893 19 4 17.3211 4 15.25V6.75C4 4.67893 5.67893 3 7.75 3H16.25Z " },
            { FluentSymbol.AppTitle24, "M4.75 20.5H19.25C19.6642 20.5 20 20.8358 20 21.25C20 21.6297 19.7178 21.9435 19.3518 21.9932L19.25 22H4.75C4.33579 22 4 21.6642 4 21.25C4 20.8703 4.28215 20.5565 4.64823 20.5068L4.75 20.5H19.25H4.75ZM16.25 3C18.3211 3 20 4.67893 20 6.75V15.25C20 17.3211 18.3211 19 16.25 19H7.75C5.67893 19 4 17.3211 4 15.25V6.75C4 4.67893 5.67893 3 7.75 3H16.25ZM16.25 4.5H7.75C6.50736 4.5 5.5 5.50736 5.5 6.75V15.25C5.5 16.4926 6.50736 17.5 7.75 17.5H16.25C17.4926 17.5 18.5 16.4926 18.5 15.25V6.75C18.5 5.50736 17.4926 4.5 16.25 4.5Z " },
            { FluentSymbol.ApprovalsApp20Filled, "M9.78033 0.71967C9.48744 0.426777 9.01256 0.426777 8.71967 0.71967C8.42678 1.01256 8.42678 1.48744 8.71967 1.78033L9.93934 3H9.5C5.35786 3 2 6.35786 2 10.5C2 14.6421 5.35786 18 9.5 18C13.6421 18 17 14.6421 17 10.5C17 10.0858 16.6642 9.75 16.25 9.75C15.8358 9.75 15.5 10.0858 15.5 10.5C15.5 13.8137 12.8137 16.5 9.5 16.5C6.18629 16.5 3.5 13.8137 3.5 10.5C3.5 7.20664 6.15341 4.53301 9.43904 4.5003L8.71967 5.21967C8.42678 5.51256 8.42678 5.98744 8.71967 6.28033C9.01256 6.57322 9.48744 6.57322 9.78033 6.28033L12.0303 4.03033C12.3232 3.73744 12.3232 3.26256 12.0303 2.96967L9.78033 0.71967Z M13.5201 6.95963C13.8185 7.24688 13.8276 7.72166 13.5404 8.0201L9.69039 12.0201C9.549 12.167 9.35391 12.25 9.15002 12.25C8.94613 12.25 8.75104 12.167 8.60965 12.0201L6.95963 10.3057C6.67239 10.0073 6.68147 9.53249 6.97991 9.24525C7.27835 8.95801 7.75314 8.96709 8.04038 9.26553L9.15003 10.4185L12.4596 6.9799C12.7469 6.68146 13.2217 6.67239 13.5201 6.95963Z " },
            { FluentSymbol.ApprovalsApp20, "M9.85355 1.14645C9.65829 0.951184 9.34171 0.951184 9.14645 1.14645C8.95118 1.34171 8.95118 1.65829 9.14645 1.85355L10.2929 3H9.5C5.35786 3 2 6.35786 2 10.5C2 14.6421 5.35786 18 9.5 18C13.6421 18 17 14.6421 17 10.5C17 10.2239 16.7761 10 16.5 10C16.2239 10 16 10.2239 16 10.5C16 14.0899 13.0899 17 9.5 17C5.91015 17 3 14.0899 3 10.5C3 6.91015 5.91015 4 9.5 4H10.2929L9.14645 5.14645C8.95118 5.34171 8.95118 5.65829 9.14645 5.85355C9.34171 6.04882 9.65829 6.04882 9.85355 5.85355L11.8536 3.85355C12.0488 3.65829 12.0488 3.34171 11.8536 3.14645L9.85355 1.14645Z M13.3467 7.13976C13.5457 7.33125 13.5517 7.64778 13.3602 7.84673L9.51027 11.8467C9.41601 11.9447 9.28595 12 9.15002 12C9.0141 12 8.88403 11.9447 8.78978 11.8467L7.13975 10.1324C6.94826 9.93339 6.95431 9.61687 7.15327 9.42537C7.35223 9.23388 7.66876 9.23993 7.86025 9.4389L9.15003 10.779L12.6398 7.15327C12.8313 6.95431 13.1478 6.94826 13.3467 7.13976Z " },
            { FluentSymbol.ApprovalsApp24Filled, "M10.5429 1.79289C10.9334 1.40237 11.5666 1.40237 11.9571 1.79289L14.457 4.29277C14.6445 4.4803 14.7499 4.73466 14.7499 4.99987C14.7499 5.26509 14.6445 5.51945 14.457 5.70698L11.9571 8.20686C11.5666 8.59738 10.9334 8.59738 10.5429 8.20686C10.1524 7.81633 10.1524 7.18317 10.5429 6.79264L11.3011 6.03445C7.76324 6.38516 5 9.36988 5 13C5 16.866 8.13401 20 12 20C15.5689 20 18.5153 17.3283 18.9458 13.8763C19.0141 13.3282 19.5138 12.9393 20.0618 13.0077C20.6099 13.076 20.9988 13.5757 20.9304 14.1237C20.3767 18.5644 16.5903 22 12 22C7.02944 22 3 17.9706 3 13C3 8.24519 6.68723 4.35157 11.3583 4.02252L10.5429 3.20711C10.1524 2.81658 10.1524 2.18342 10.5429 1.79289Z M16.2071 9.79289C16.5976 10.1834 16.5976 10.8166 16.2071 11.2071L11.7071 15.7071C11.3166 16.0976 10.6834 16.0976 10.2929 15.7071L8.29289 13.7071C7.90237 13.3166 7.90237 12.6834 8.29289 12.2929C8.68342 11.9024 9.31658 11.9024 9.70711 12.2929L11 13.5858L14.7929 9.79289C15.1834 9.40237 15.8166 9.40237 16.2071 9.79289Z " },
            { FluentSymbol.ApprovalsApp24, "M11.7803 1.71966C11.4874 1.42677 11.0125 1.42678 10.7197 1.71968C10.4268 2.01258 10.4268 2.48746 10.7197 2.78034L11.9396 4.0002C6.99683 4.03268 3 8.04959 3 13C3 17.9706 7.02944 22 12 22C16.6942 22 20.5483 18.4068 20.9631 13.8202C21.0004 13.4077 20.6962 13.043 20.2837 13.0057C19.8712 12.9684 19.5065 13.2726 19.4692 13.6851C19.1236 17.5058 15.9111 20.5 12 20.5C7.85786 20.5 4.5 17.1421 4.5 13C4.5 8.87822 7.82493 5.53303 11.939 5.50024L10.7197 6.71955C10.4268 7.01244 10.4268 7.48732 10.7197 7.78021C11.0126 8.0731 11.4874 8.0731 11.7803 7.78021L14.2803 5.28021C14.421 5.13955 14.5 4.94878 14.5 4.74987C14.5 4.55095 14.421 4.36019 14.2803 4.21954L11.7803 1.71966Z M15.7837 10.2197C16.0766 10.5126 16.0766 10.9874 15.7837 11.2803L11.2803 15.7838C11.1397 15.9244 10.9489 16.0034 10.75 16.0034C10.5511 16.0035 10.3603 15.9244 10.2197 15.7838L8.21967 13.7838C7.92678 13.4909 7.92678 13.016 8.21967 12.7231C8.51256 12.4302 8.98744 12.4302 9.28033 12.7231L10.75 14.1928L14.723 10.2197C15.0159 9.92678 15.4908 9.92677 15.7837 10.2197Z " },
            { FluentSymbol.ApprovalsApp28Filled, "M12.2926 2.29317C12.683 1.90249 13.3162 1.90225 13.7068 2.29262L16.7115 5.29492C16.8993 5.48257 17.0047 5.7372 17.0046 6.00269C17.0045 6.26817 16.8989 6.52272 16.7109 6.71023L13.7063 9.70792C13.3153 10.098 12.6821 10.0973 12.2921 9.70629C11.902 9.31531 11.9027 8.68215 12.2937 8.29208L13.5785 7.01027C9.07988 7.22996 5.5 10.9469 5.5 15.5C5.5 20.1944 9.30558 24 14 24C18.5429 24 22.254 20.4356 22.4882 15.9515C22.517 15.3999 22.9875 14.9762 23.539 15.005C24.0906 15.0338 24.5143 15.5043 24.4855 16.0558C24.1961 21.5969 19.6126 26 14 26C8.20101 26 3.5 21.299 3.5 15.5C3.5 9.8368 7.98343 5.22075 13.5945 5.00769L12.2932 3.70738C11.9025 3.31701 11.9023 2.68384 12.2926 2.29317Z M18.2071 12.2929C18.5976 12.6834 18.5976 13.3166 18.2071 13.7071L13.2071 18.7071C13.0196 18.8946 12.7652 19 12.5 19C12.2348 19 11.9804 18.8946 11.7929 18.7071L9.79289 16.7071C9.40237 16.3166 9.40237 15.6834 9.79289 15.2929C10.1834 14.9024 10.8166 14.9024 11.2071 15.2929L12.5 16.5858L16.7929 12.2929C17.1834 11.9024 17.8166 11.9024 18.2071 12.2929Z " },
            { FluentSymbol.ApprovalsApp16Filled, "M8.31444 0.256132C8.04168 -0.0555957 7.56786 -0.0871838 7.25613 0.185578C6.9444 0.458339 6.91282 0.932161 7.18558 1.24389L7.87327 2.02983C4.57747 2.34513 2 5.12157 2 8.5C2 12.0899 4.91015 15 8.5 15C12.0899 15 15 12.0899 15 8.5C15 8.45486 15 8.36197 15 8.25019C15 7.83598 14.6642 7.5 14.25 7.5C13.8358 7.5 13.5 7.83598 13.5 8.25019C13.5 8.36189 13.5 8.45476 13.5 8.5C13.5 11.2614 11.2614 13.5 8.5 13.5C5.73858 13.5 3.5 11.2614 3.5 8.5C3.5 5.97431 5.37269 3.88601 7.80531 3.54787L7.18558 4.25613C6.91282 4.56786 6.9444 5.04168 7.25613 5.31444C7.56786 5.5872 8.04168 5.55562 8.31444 5.24389L10.0644 3.24389C10.3119 2.96112 10.3119 2.5389 10.0644 2.25613L8.31444 0.256132ZM11.805 6.2455C12.0836 6.55199 12.061 7.02633 11.7545 7.30496L9.0045 9.80496C8.70827 10.0743 8.25276 10.0634 7.96967 9.78034L6.71967 8.53034C6.42678 8.23744 6.42678 7.76257 6.71967 7.46968C7.01256 7.17678 7.48744 7.17678 7.78033 7.46968L8.52465 8.214L10.7455 6.19505C11.052 5.91642 11.5263 5.93901 11.805 6.2455Z " },
            { FluentSymbol.ApprovalsApp16, "M7.85355 0.146447C7.65829 -0.0488155 7.34171 -0.0488155 7.14645 0.146447C6.95118 0.341709 6.95118 0.658291 7.14645 0.853553L8.29603 2.00314C4.80056 2.11088 2 4.97839 2 8.5C2 12.0899 4.91015 15 8.5 15C12.0899 15 15 12.0899 15 8.5C15 8.48656 15 8.47313 14.9999 8.45971C14.9983 8.2001 14.7805 8 14.5209 8H14.4782C14.2093 8 14 8.23107 14 8.5C14 11.5376 11.5376 14 8.5 14C5.46243 14 3 11.5376 3 8.5C3 5.53311 5.34917 3.11491 8.28892 3.00398L7.14645 4.14645C6.95118 4.34171 6.95118 4.65829 7.14645 4.85355C7.34171 5.04882 7.65829 5.04882 7.85355 4.85355L9.85355 2.85355C10.0488 2.65829 10.0488 2.34171 9.85355 2.14645L7.85355 0.146447ZM11.8536 6.14645C12.0488 6.34171 12.0488 6.65829 11.8536 6.85355L8.85355 9.85355C8.65829 10.0488 8.34171 10.0488 8.14645 9.85355L6.64645 8.35355C6.45118 8.15829 6.45118 7.84171 6.64645 7.64645C6.84171 7.45118 7.15829 7.45118 7.35355 7.64645L8.5 8.79289L11.1464 6.14645C11.3417 5.95118 11.6583 5.95118 11.8536 6.14645Z " },
            { FluentSymbol.ApprovalsApp28, "M13.2804 2.2188C12.9876 1.92585 12.5127 1.92575 12.2198 2.21859C11.9268 2.51142 11.9267 2.98629 12.2196 3.27925L13.9276 4.98797C8.15437 5.02616 3.48608 9.71803 3.48608 15.5002C3.48608 21.3061 8.1927 26.0128 13.9986 26.0128C19.7146 26.0128 24.3649 21.451 24.5077 15.7692C24.5181 15.3551 24.1909 15.011 23.7768 15.0006C23.3627 14.9902 23.0186 15.3174 23.0082 15.7315C22.8857 20.6019 18.8988 24.5128 13.9986 24.5128C9.02112 24.5128 4.98608 20.4777 4.98608 15.5002C4.98608 10.5384 8.99582 6.51308 13.9517 6.48785L12.2197 8.21991C11.9268 8.51281 11.9268 8.98768 12.2197 9.28057C12.5126 9.57347 12.9874 9.57347 13.2803 9.28057L16.2803 6.28057C16.5732 5.98772 16.5732 5.51293 16.2804 5.22002L13.2804 2.2188Z M18.2805 12.22C18.5733 12.5129 18.5733 12.9878 18.2803 13.2806L13.0304 18.5294C12.7376 18.8221 12.263 18.8222 11.9701 18.5296L9.71802 16.2802C9.42496 15.9874 9.42469 15.5126 9.71741 15.2195C10.0101 14.9264 10.485 14.9262 10.7781 15.2189L12.4998 16.9387L17.2198 12.2199C17.5127 11.927 17.9876 11.927 18.2805 12.22Z " },
            { FluentSymbol.Apps16Filled, "M11.8105 2.44911C11.2248 1.86332 10.275 1.86332 9.68922 2.44911L7.96197 4.17636C7.81383 3.50372 7.21422 3.00044 6.49707 3.00044H3.49707C2.66864 3.00044 1.99707 3.67202 1.99707 4.50044V12.4985C1.99707 13.0088 2.25188 13.4595 2.64121 13.7305C2.88446 13.9006 3.18051 14.0004 3.49988 14.0004H11.4999C12.3283 14.0004 12.9999 13.3289 12.9999 12.5004V9.50044C12.9999 8.80142 12.5217 8.21408 11.8746 8.04764L13.5812 6.34109C14.167 5.7553 14.167 4.80555 13.5812 4.21977L11.8105 2.44911ZM7.99707 6.4196L9.57791 8.00044H7.99707V6.4196ZM6.99707 8.00044L2.99707 8.00044V4.50044C2.99707 4.2243 3.22093 4.00044 3.49707 4.00044H6.49707C6.77321 4.00044 6.99707 4.2243 6.99707 4.50044V8.00044ZM3.21149 12.9089C3.08346 12.8184 2.99988 12.6692 2.99988 12.5004L2.99988 9.00044H6.99707V12.9985H3.49707C3.3909 12.9985 3.29245 12.9654 3.21149 12.9089ZM7.99707 13.0004V9.00044H11.4999C11.776 9.00044 11.9999 9.2243 11.9999 9.50044V12.5004C11.9999 12.7766 11.776 13.0004 11.4999 13.0004H7.99707Z " },
            { FluentSymbol.Apps16, "M11.8105 2.44911C11.2248 1.86332 10.275 1.86332 9.68922 2.44911L7.96197 4.17636C7.81383 3.50372 7.21422 3.00044 6.49707 3.00044H3.49707C2.66864 3.00044 1.99707 3.67202 1.99707 4.50044V12.4985C1.99707 13.0088 2.25188 13.4595 2.64121 13.7305C2.88446 13.9006 3.18051 14.0004 3.49988 14.0004H11.4999C12.3283 14.0004 12.9999 13.3289 12.9999 12.5004V9.50044C12.9999 8.80142 12.5217 8.21408 11.8746 8.04764L13.5812 6.34109C14.167 5.7553 14.167 4.80555 13.5812 4.21977L11.8105 2.44911ZM9.57791 8.00044H7.99707V6.4196L9.57791 8.00044ZM10.3963 3.15621C10.5916 2.96095 10.9082 2.96095 11.1034 3.15621L12.8741 4.92687C13.0694 5.12214 13.0694 5.43872 12.8741 5.63398L11.1034 7.40464C10.9082 7.59991 10.5916 7.59991 10.3963 7.40464L8.62566 5.63398C8.4304 5.43872 8.4304 5.12214 8.62566 4.92687L10.3963 3.15621ZM6.99707 4.50044V8.00044L2.99707 8.00044V4.50044C2.99707 4.2243 3.22093 4.00044 3.49707 4.00044H6.49707C6.77321 4.00044 6.99707 4.2243 6.99707 4.50044ZM2.99988 12.5004L2.99988 9.00044H6.99707V12.9985H3.49707C3.3909 12.9985 3.29245 12.9654 3.21149 12.9089C3.08346 12.8184 2.99988 12.6692 2.99988 12.5004ZM7.99707 9.00044H11.4999C11.776 9.00044 11.9999 9.2243 11.9999 9.50044V12.5004C11.9999 12.7766 11.776 13.0004 11.4999 13.0004H7.99707V9.00044Z " },
            { FluentSymbol.Apps20Filled, "M4.5 16.9999C3.7203 16.9999 3.07955 16.4051 3.00687 15.6444L3 15.4999V4.49994C3 3.72024 3.59489 3.07949 4.35554 3.00681L4.5 2.99994H9C9.7797 2.99994 10.4204 3.59483 10.4931 4.35548L10.5 4.49994V4.75437L12.6886 2.48512C13.2276 1.92593 14.0959 1.87562 14.6956 2.347L14.8118 2.44824L17.5694 5.17289C18.1219 5.71878 18.1614 6.58763 17.68 7.18407L17.5767 7.29955L15.266 9.49937L15.5 9.49994C16.2797 9.49994 16.9204 10.0948 16.9931 10.8555L17 10.9999V15.4999C17 16.2796 16.4051 16.9204 15.6445 16.9931L15.5 16.9999H4.5ZM9.5 10.4999H4V15.4999C4 15.7147 4.13542 15.8979 4.32553 15.9687L4.41012 15.9919L4.5 15.9999H9.5V10.4999ZM15.5 10.4999H10.5V15.9999H15.5C15.7455 15.9999 15.9496 15.8231 15.9919 15.5898L16 15.4999V10.9999C16 10.7545 15.8231 10.5503 15.5899 10.508L15.5 10.4999ZM10.5 7.70937V9.49937H12.29L10.5 7.70937ZM9 3.99994H4.5C4.25454 3.99994 4.05039 4.17681 4.00806 4.41006L4 4.49994V9.49994H9.5V4.49994C9.5 4.28516 9.36458 4.10201 9.17447 4.03122L9.08988 4.008L9 3.99994Z " },
            { FluentSymbol.Apps20, "M4.5 16.9999C3.7203 16.9999 3.07955 16.4051 3.00687 15.6444L3 15.4999V4.49994C3 3.72024 3.59489 3.07949 4.35554 3.00681L4.5 2.99994H9C9.7797 2.99994 10.4204 3.59483 10.4931 4.35548L10.5 4.49994V4.75437L12.6886 2.48512C13.2276 1.92593 14.0959 1.87562 14.6956 2.347L14.8118 2.44824L17.5694 5.17289C18.1219 5.71878 18.1614 6.58763 17.68 7.18407L17.5767 7.29955L15.266 9.49937L15.5 9.49994C16.2797 9.49994 16.9204 10.0948 16.9931 10.8555L17 10.9999V15.4999C17 16.2796 16.4051 16.9204 15.6445 16.9931L15.5 16.9999H4.5ZM9.5 10.4999H4V15.4999C4 15.7147 4.13542 15.8979 4.32553 15.9687L4.41012 15.9919L4.5 15.9999H9.5V10.4999ZM15.5 10.4999H10.5V15.9999H15.5C15.7455 15.9999 15.9496 15.8231 15.9919 15.5898L16 15.4999V10.9999C16 10.7545 15.8231 10.5503 15.5899 10.508L15.5 10.4999ZM10.5 7.70937V9.49937H12.29L10.5 7.70937ZM9 3.99994H4.5C4.25454 3.99994 4.05039 4.17681 4.00806 4.41006L4 4.49994V9.49994H9.5V4.49994C9.5 4.28516 9.36458 4.10201 9.17447 4.03122L9.08988 4.008L9 3.99994ZM14.1222 3.17259C13.9396 2.99646 13.6692 2.98149 13.4768 3.11998L13.4086 3.17909L10.7926 5.89323C10.6271 6.06494 10.6086 6.32495 10.7356 6.51638L10.799 6.59377L13.4147 9.20949C13.5826 9.3774 13.8409 9.40129 14.0345 9.27924L14.1131 9.218L16.8708 6.59133C17.0433 6.41673 17.061 6.14719 16.9248 5.95313L16.8665 5.88423L14.1222 3.17259Z " },
            { FluentSymbol.Apps24Filled, "M18.4923 2.32991L21.671 5.50868C22.5497 6.38736 22.5497 7.81198 21.671 8.69066L19.2476 11.1133C20.2631 11.4311 21 12.3793 21 13.4996V18.4996C21 19.8803 19.8807 20.9996 18.5 20.9996H5.5C4.11929 20.9996 3 19.8803 3 18.4996V5.49958C3 4.11887 4.11929 2.99958 5.5 2.99958H10.5C11.621 2.99958 12.5697 3.73743 12.8869 4.75398L15.3103 2.32991C16.189 1.45123 17.6136 1.45123 18.4923 2.32991ZM11 12.9996H5V18.4996C5 18.7757 5.22386 18.9996 5.5 18.9996H11V12.9996ZM18.5 12.9996H13V18.9996H18.5C18.7761 18.9996 19 18.7757 19 18.4996V13.4996C19 13.2234 18.7761 12.9996 18.5 12.9996ZM14.44 10.9989L13 9.5589V10.9996L14.44 10.9989ZM10.5 4.99958H5.5C5.22386 4.99958 5 5.22344 5 5.49958V10.9996H11V5.49958C11 5.22344 10.7761 4.99958 10.5 4.99958Z " },
            { FluentSymbol.Apps24, "M18.4923 2.32991L21.671 5.50868C22.5497 6.38736 22.5497 7.81198 21.671 8.69066L19.0866 11.2746C20.1696 11.437 21 12.3713 21 13.4996V18.7496C21 19.9922 19.9926 20.9996 18.75 20.9996H5.25C4.00736 20.9996 3 19.9922 3 18.7496V5.24958C3 4.00694 4.00736 2.99958 5.25 2.99958H10.5C11.6289 2.99958 12.5637 3.83103 12.7253 4.91498L15.3103 2.32991C16.189 1.45123 17.6136 1.45123 18.4923 2.32991ZM4.5 18.7496C4.5 19.1638 4.83579 19.4996 5.25 19.4996L11.249 19.4989L11.25 12.7496L4.5 12.7489V18.7496ZM12.749 19.4989L18.75 19.4996C19.1642 19.4996 19.5 19.1638 19.5 18.7496V13.4996C19.5 13.0854 19.1642 12.7496 18.75 12.7496L12.749 12.7489V19.4989ZM10.5 4.49958H5.25C4.83579 4.49958 4.5 4.83536 4.5 5.24958V11.2489H11.25V5.24958C11.25 4.83536 10.9142 4.49958 10.5 4.49958ZM12.75 9.3089V11.2496L14.69 11.2489L12.75 9.3089ZM16.3709 3.39057L13.1922 6.56934C12.8993 6.86223 12.8993 7.33711 13.1922 7.63L16.3709 10.8088C16.6638 11.1017 17.1387 11.1017 17.4316 10.8088L20.6104 7.63C20.9033 7.33711 20.9033 6.86223 20.6104 6.56934L17.4316 3.39057C17.1387 3.09768 16.6638 3.09768 16.3709 3.39057Z " },
            { FluentSymbol.Apps28Filled, "M20.841 2.6551C19.9623 1.77642 18.5377 1.77643 17.659 2.6551L13.5 6.81411V6.25393C13.5 5.01129 12.4926 4.00393 11.25 4.00393H4.25C3.00736 4.00393 2 5.01129 2 6.25393V24.254C2 25.2205 2.7835 26.004 3.75 26.004H21.75C22.9926 26.004 24 24.9966 24 23.754V16.7499C24 15.5073 22.9926 14.4999 21.75 14.4999H21.1941L25.349 10.3451C26.2277 9.46639 26.2277 8.04177 25.349 7.16309L20.841 2.6551ZM13.5 10.694L17.3059 14.4999H13.5V10.694ZM12 14.4999H3.5V6.25393C3.5 5.83972 3.83579 5.50393 4.25 5.50393H11.25C11.6642 5.50393 12 5.83972 12 6.25393V14.4999ZM3.5 15.9999H12V24.5039H4.25C3.83579 24.5039 3.5 24.1681 3.5 23.7539L3.5 15.9999ZM13.5 24.504V15.9999H21.75C22.1642 15.9999 22.5 16.3357 22.5 16.7499V23.754C22.5 24.1682 22.1642 24.504 21.75 24.504H13.5Z " },
            { FluentSymbol.Apps28, "M20.841 2.6551C19.9623 1.77642 18.5377 1.77643 17.659 2.6551L13.5 6.81411V6.25393C13.5 5.01129 12.4926 4.00393 11.25 4.00393H4.25C3.00736 4.00393 2 5.01129 2 6.25393V24.2539C2 25.2204 2.7835 26.0039 3.75 26.0039H21.75C22.9926 26.0039 24 24.9966 24 23.7539V16.7498C24 15.5072 22.9926 14.4998 21.75 14.4998H21.1942L25.349 10.3451C26.2277 9.46639 26.2277 8.04177 25.349 7.16309L20.841 2.6551ZM17.3058 14.4998H13.5V10.694L17.3058 14.4998ZM18.7197 3.71576C19.0126 3.42287 19.4874 3.42287 19.7803 3.71576L24.2883 8.22375C24.5812 8.51664 24.5812 8.99152 24.2883 9.28441L19.7803 13.7924C19.4874 14.0853 19.0126 14.0853 18.7197 13.7924L14.2117 9.28441C13.9188 8.99152 13.9188 8.51664 14.2117 8.22375L18.7197 3.71576ZM12 6.25393V14.4998H3.5V6.25393C3.5 5.83972 3.83579 5.50393 4.25 5.50393H11.25C11.6642 5.50393 12 5.83972 12 6.25393ZM3.5 23.7539L3.5 15.9998H12V24.5039H4.25C3.83579 24.5039 3.5 24.1681 3.5 23.7539ZM13.5 15.9998H21.75C22.1642 15.9998 22.5 16.3356 22.5 16.7498V23.7539C22.5 24.1681 22.1642 24.5039 21.75 24.5039H13.5V15.9998Z " },
            { FluentSymbol.AppsAddIn20Filled, "M15 2.5C15.4142 2.5 15.75 2.83579 15.75 3.25V4.75L17.25 4.75C17.6642 4.75 18 5.08579 18 5.5C18 5.91421 17.6642 6.25 17.25 6.25H15.75V7.75C15.75 8.16421 15.4142 8.5 15 8.5C14.5858 8.5 14.25 8.16421 14.25 7.75V6.25H12.75C12.3358 6.25 12 5.91421 12 5.5C12 5.08579 12.3358 4.75 12.75 4.75H14.25V3.25C14.25 2.83579 14.5858 2.5 15 2.5Z M4.75 3C3.7835 3 3 3.7835 3 4.75V15.25C3 16.2165 3.7835 17 4.75 17H15.25C16.2165 17 17 16.2165 17 15.25V10.75C17 9.7835 16.2165 9 15.25 9H11.25C11.1119 9 11 8.88807 11 8.75V4.75C11 3.7835 10.2165 3 9.25 3H4.75ZM4.5 4.75C4.5 4.61193 4.61193 4.5 4.75 4.5H9.25C9.38807 4.5 9.5 4.61193 9.5 4.75V8.75C9.5 8.83488 9.50604 8.91835 9.51772 9H4.5V4.75ZM9.5 10.5V15.5H4.75C4.61193 15.5 4.5 15.3881 4.5 15.25V10.5H9.5ZM11 15.5V10.4823C11.0817 10.494 11.1651 10.5 11.25 10.5H15.25C15.3881 10.5 15.5 10.6119 15.5 10.75V15.25C15.5 15.3881 15.3881 15.5 15.25 15.5H11Z " },
            { FluentSymbol.AppsAddIn20, "M15 3C15 2.72386 14.7761 2.5 14.5 2.5C14.2239 2.5 14 2.72386 14 3V5H12C11.7239 5 11.5 5.22386 11.5 5.5C11.5 5.77614 11.7239 6 12 6H14V8C14 8.27614 14.2239 8.5 14.5 8.5C14.7761 8.5 15 8.27614 15 8V6H17C17.2761 6 17.5 5.77614 17.5 5.5C17.5 5.22386 17.2761 5 17 5L15 5V3Z M4.5 17C3.67157 17 3 16.3284 3 15.5V4.5C3 3.67157 3.67157 3 4.5 3H9C9.82843 3 10.5 3.67157 10.5 4.5V9.5H15.5C16.3284 9.5 17 10.1716 17 11V15.5C17 16.3284 16.3284 17 15.5 17H4.5ZM10.5 10.5V16H15.5C15.7761 16 16 15.7761 16 15.5V11C16 10.7239 15.7761 10.5 15.5 10.5H10.5ZM9.5 16V10.5H4V15.5C4 15.7589 4.19675 15.9718 4.44888 15.9974C4.46569 15.9991 4.48274 16 4.5 16H9.5ZM9.5 4.5C9.5 4.22386 9.27614 4 9 4H4.5C4.22386 4 4 4.22386 4 4.5V9.5H9.5V4.5Z " },
            { FluentSymbol.AppsAddIn16Filled, "M13.25 1.75C13.25 1.33579 12.9142 1 12.5 1C12.0858 1 11.75 1.33579 11.75 1.75V2.75H10.75C10.3358 2.75 10 3.08579 10 3.5C10 3.91421 10.3358 4.25 10.75 4.25H11.75V5.25C11.75 5.66421 12.0858 6 12.5 6C12.9142 6 13.25 5.66421 13.25 5.25V4.25H14.25C14.6642 4.25 15 3.91421 15 3.5C15 3.08579 14.6642 2.75 14.25 2.75H13.25V1.75ZM4 2C2.89543 2 2 2.89543 2 4V11.75C2 12.8546 2.89543 13.75 4 13.75H12C13.1046 13.75 14 12.8546 14 11.75V9.25C14 8.14543 13.1046 7.25 12 7.25H8.75V4C8.75 2.89543 7.85457 2 6.75 2H4ZM7.25 8.75V12.25H4C3.72386 12.25 3.5 12.0261 3.5 11.75V8.75H7.25ZM7.25 4V7.25H3.5V4C3.5 3.72386 3.72386 3.5 4 3.5H6.75C7.02614 3.5 7.25 3.72386 7.25 4ZM12 12.25H8.75V8.75H12C12.2761 8.75 12.5 8.97386 12.5 9.25V11.75C12.5 12.0261 12.2761 12.25 12 12.25Z " },
            { FluentSymbol.AppsAddIn16, "M13 1.5C13 1.22386 12.7761 1 12.5 1C12.2239 1 12 1.22386 12 1.5V3H10.5C10.2239 3 10 3.22386 10 3.5C10 3.77614 10.2239 4 10.5 4H12V5.5C12 5.77614 12.2239 6 12.5 6C12.7761 6 13 5.77614 13 5.5V4H14.5C14.7761 4 15 3.77614 15 3.5C15 3.22386 14.7761 3 14.5 3H13V1.5ZM3.75 2C2.7835 2 2 2.7835 2 3.75V12.25C2 13.2165 2.7835 14 3.75 14H12.25C13.2165 14 14 13.2165 14 12.25V9.25C14 8.2835 13.2165 7.5 12.25 7.5H8.5V3.75C8.5 2.7835 7.7165 2 6.75 2H3.75ZM7.5 8.5V13H3.75C3.33579 13 3 12.6642 3 12.25V8.5H7.5ZM7.5 3.75V7.5H3V3.75C3 3.33579 3.33579 3 3.75 3H6.75C7.16421 3 7.5 3.33579 7.5 3.75ZM12.25 13H8.5V8.5H12.25C12.6642 8.5 13 8.83579 13 9.25V12.25C13 12.6642 12.6642 13 12.25 13Z " },
            { FluentSymbol.AppsAddIn24Filled, "M10.5 3C11.8807 3 13 4.11929 13 5.5V11H18.5C19.8807 11 21 12.1193 21 13.5V18.5C21 19.8807 19.8807 21 18.5 21H5.5C4.11929 21 3 19.8807 3 18.5V5.5C3 4.11929 4.11929 3 5.5 3H10.5ZM11 13H5V18.5C5 18.7761 5.22386 19 5.5 19H11V13ZM18.5 13H13V19H18.5C18.7761 19 19 18.7761 19 18.5V13.5C19 13.2239 18.7761 13 18.5 13ZM10.5 5H5.5C5.22386 5 5 5.22386 5 5.5V11H11V5.5C11 5.22386 10.7761 5 10.5 5ZM17.8834 2.00673L18 2C18.5128 2 18.9355 2.38604 18.9933 2.88338L19 3V5H21C21.5128 5 21.9355 5.38604 21.9933 5.88338L22 6C22 6.51284 21.614 6.93551 21.1166 6.99327L21 7H19V9C19 9.51284 18.614 9.93551 18.1166 9.99327L18 10C17.4872 10 17.0645 9.61396 17.0067 9.11662L17 9V7H15C14.4872 7 14.0645 6.61396 14.0067 6.11662L14 6C14 5.48716 14.386 5.06449 14.8834 5.00673L15 5H17V3C17 2.48716 17.386 2.06449 17.8834 2.00673L18 2L17.8834 2.00673Z " },
            { FluentSymbol.AppsAddIn24, "M10.5 3C11.7426 3 12.75 4.00736 12.75 5.25V11.25H18.75C19.9926 11.25 21 12.2574 21 13.5V18.75C21 19.9926 19.9926 21 18.75 21H5.25C4.00736 21 3 19.9926 3 18.75V5.25C3 4.00736 4.00736 3 5.25 3H10.5ZM11.25 12.75H4.5V18.75C4.5 19.1642 4.83579 19.5 5.25 19.5H11.249L11.25 12.75ZM18.75 12.75H12.749V19.5H18.75C19.1642 19.5 19.5 19.1642 19.5 18.75V13.5C19.5 13.0858 19.1642 12.75 18.75 12.75ZM10.5 4.5H5.25C4.83579 4.5 4.5 4.83579 4.5 5.25V11.25H11.25V5.25C11.25 4.83579 10.9142 4.5 10.5 4.5ZM17.8982 2.00685L18 2C18.3797 2 18.6935 2.28215 18.7432 2.64823L18.75 2.75V5.25H21.25C21.6297 5.25 21.9435 5.53215 21.9932 5.89823L22 6C22 6.3797 21.7178 6.69349 21.3518 6.74315L21.25 6.75H18.75V9.25C18.75 9.6297 18.4678 9.94349 18.1018 9.99315L18 10C17.6203 10 17.3065 9.71785 17.2568 9.35177L17.25 9.25V6.75H14.75C14.3703 6.75 14.0565 6.46785 14.0068 6.10177L14 6C14 5.6203 14.2822 5.30651 14.6482 5.25685L14.75 5.25H17.25V2.75C17.25 2.3703 17.5322 2.05651 17.8982 2.00685Z " },
            { FluentSymbol.AppsAddIn28Filled, "M21 2C21.5523 2 22 2.44772 22 3V6H25C25.5523 6 26 6.44772 26 7C26 7.55228 25.5523 8 25 8H22V11C22 11.5523 21.5523 12 21 12C20.4477 12 20 11.5523 20 11V8H17C16.4477 8 16 7.55228 16 7C16 6.44772 16.4477 6 17 6H20V3C20 2.44772 20.4477 2 21 2ZM6 3C4.34315 3 3 4.34315 3 6V22C3 23.6569 4.34315 25 6 25H22C23.6569 25 25 23.6569 25 22V16C25 14.3431 23.6569 13 22 13H15V6C15 4.34315 13.6569 3 12 3H6ZM13 13H5V6C5 5.44772 5.44772 5 6 5H12C12.5523 5 13 5.44772 13 6V13ZM15 23V15H22C22.5523 15 23 15.4477 23 16V22C23 22.5523 22.5523 23 22 23H15ZM13 23H6C5.44772 23 5 22.5523 5 22V15H13V23Z " },
            { FluentSymbol.AppsAddIn28, "M21.25 2C21.6642 2 22 2.33579 22 2.75V6H25.25C25.6642 6 26 6.33579 26 6.75C26 7.16421 25.6642 7.5 25.25 7.5H22V10.75C22 11.1642 21.6642 11.5 21.25 11.5C20.8358 11.5 20.5 11.1642 20.5 10.75V7.5H17.25C16.8358 7.5 16.5 7.16421 16.5 6.75C16.5 6.33579 16.8358 6 17.25 6H20.5V2.75C20.5 2.33579 20.8358 2 21.25 2ZM5.75 3C4.23122 3 3 4.23122 3 5.75V22.25C3 23.7688 4.23122 25 5.75 25H22.25C23.7688 25 25 23.7688 25 22.25V16C25 14.4812 23.7688 13.25 22.25 13.25H14.75V5.75C14.75 4.23122 13.5188 3 12 3H5.75ZM13.25 13.25H4.5V5.75C4.5 5.05964 5.05964 4.5 5.75 4.5H12C12.6904 4.5 13.25 5.05964 13.25 5.75V13.25ZM14.75 23.5V14.75H22.25C22.9404 14.75 23.5 15.3096 23.5 16V22.25C23.5 22.9404 22.9404 23.5 22.25 23.5H14.75ZM13.25 23.5H5.75C5.05964 23.5 4.5 22.9404 4.5 22.25V14.75H13.25V23.5Z " },
            { FluentSymbol.AppsList20Filled, "M8 4.5C8 4.22386 8.22386 4 8.5 4H17.5C17.7761 4 18 4.22386 18 4.5C18 4.77614 17.7761 5 17.5 5H8.5C8.22386 5 8 4.77614 8 4.5Z M8 10.5C8 10.2239 8.22386 10 8.5 10H17.5C17.7761 10 18 10.2239 18 10.5C18 10.7761 17.7761 11 17.5 11H8.5C8.22386 11 8 10.7761 8 10.5Z M8 16.5C8 16.2239 8.22386 16 8.5 16H17.5C17.7761 16 18 16.2239 18 16.5C18 16.7761 17.7761 17 17.5 17H8.5C8.22386 17 8 16.7761 8 16.5Z M2 15.5C2 14.6716 2.67157 14 3.5 14H4.5C5.32843 14 6 14.6716 6 15.5V16.5C6 17.3284 5.32843 18 4.5 18H3.5C2.67157 18 2 17.3284 2 16.5V15.5Z M2 9.5C2 8.67157 2.67157 8 3.5 8H4.5C5.32843 8 6 8.67157 6 9.5V10.5C6 11.3284 5.32843 12 4.5 12H3.5C2.67157 12 2 11.3284 2 10.5V9.5Z M2 3.5C2 2.67157 2.67157 2 3.5 2H4.5C5.32843 2 6 2.67157 6 3.5V4.5C6 5.32843 5.32843 6 4.5 6H3.5C2.67157 6 2 5.32843 2 4.5V3.5Z " },
            { FluentSymbol.AppsList20, "M2 3.5C2 2.67157 2.67157 2 3.5 2H4.5C5.32843 2 6 2.67157 6 3.5V4.5C6 5.32843 5.32843 6 4.5 6H3.5C2.67157 6 2 5.32843 2 4.5V3.5ZM3.5 3C3.22386 3 3 3.22386 3 3.5V4.5C3 4.77614 3.22386 5 3.5 5H4.5C4.77614 5 5 4.77614 5 4.5V3.5C5 3.22386 4.77614 3 4.5 3H3.5Z M2 9.5C2 8.67157 2.67157 8 3.5 8H4.5C5.32843 8 6 8.67157 6 9.5V10.5C6 11.3284 5.32843 12 4.5 12H3.5C2.67157 12 2 11.3284 2 10.5V9.5ZM3.5 9C3.22386 9 3 9.22386 3 9.5V10.5C3 10.7761 3.22386 11 3.5 11H4.5C4.77614 11 5 10.7761 5 10.5V9.5C5 9.22386 4.77614 9 4.5 9H3.5Z M2 15.5C2 14.6716 2.67157 14 3.5 14H4.5C5.32843 14 6 14.6716 6 15.5V16.5C6 17.3284 5.32843 18 4.5 18H3.5C2.67157 18 2 17.3284 2 16.5V15.5ZM3.5 15C3.22386 15 3 15.2239 3 15.5V16.5C3 16.7761 3.22386 17 3.5 17H4.5C4.77614 17 5 16.7761 5 16.5V15.5C5 15.2239 4.77614 15 4.5 15H3.5Z M8 4.5C8 4.22386 8.22386 4 8.5 4H17.5C17.7761 4 18 4.22386 18 4.5C18 4.77614 17.7761 5 17.5 5H8.5C8.22386 5 8 4.77614 8 4.5Z M8 10.5C8 10.2239 8.22386 10 8.5 10H17.5C17.7761 10 18 10.2239 18 10.5C18 10.7761 17.7761 11 17.5 11H8.5C8.22386 11 8 10.7761 8 10.5Z M8 16.5C8 16.2239 8.22386 16 8.5 16H17.5C17.7761 16 18 16.2239 18 16.5C18 16.7761 17.7761 17 17.5 17H8.5C8.22386 17 8 16.7761 8 16.5Z " },
            { FluentSymbol.AppsList24Filled, "M6.24788 16.0021C7.21437 16.0021 7.99788 16.7856 7.99788 17.7521V20.25C7.99788 21.2165 7.21437 22 6.24788 22H3.75C2.7835 22 2 21.2165 2 20.25V17.7521C2 16.7856 2.7835 16.0021 3.75 16.0021H6.24788ZM9.74809 18H21.2529C21.6671 18 22.0029 18.3358 22.0029 18.75C22.0029 19.1297 21.7207 19.4435 21.3547 19.4932L21.2529 19.5H9.74809C9.33388 19.5 8.99809 19.1642 8.99809 18.75C8.99809 18.3703 9.28025 18.0565 9.64632 18.0068L9.74809 18H21.2529H9.74809ZM6.24788 9.00106C7.21437 9.00106 7.99788 9.78456 7.99788 10.7511V13.2489C7.99788 14.2154 7.21437 14.9989 6.24788 14.9989H3.75C2.7835 14.9989 2 14.2154 2 13.2489V10.7511C2 9.78456 2.7835 9.00106 3.75 9.00106H6.24788ZM9.74809 11H21.2529C21.6671 11 22.0029 11.3358 22.0029 11.75C22.0029 12.1297 21.7207 12.4435 21.3547 12.4932L21.2529 12.5H9.74809C9.33388 12.5 8.99809 12.1642 8.99809 11.75C8.99809 11.3703 9.28025 11.0565 9.64632 11.0068L9.74809 11H21.2529H9.74809ZM6.24788 2C7.21437 2 7.99788 2.7835 7.99788 3.75V6.24788C7.99788 7.21437 7.21437 7.99788 6.24788 7.99788H3.75C2.7835 7.99788 2 7.21437 2 6.24788V3.75C2 2.7835 2.7835 2 3.75 2H6.24788ZM9.74809 4H21.2529C21.6671 4 22.0029 4.33579 22.0029 4.75C22.0029 5.1297 21.7207 5.44349 21.3547 5.49315L21.2529 5.5H9.74809C9.33388 5.5 8.99809 5.16421 8.99809 4.75C8.99809 4.3703 9.28025 4.05651 9.64632 4.00685L9.74809 4H21.2529H9.74809Z " },
            { FluentSymbol.AppsList24, "M6.24788 16.0021C7.21437 16.0021 7.99788 16.7856 7.99788 17.7521V20.25C7.99788 21.2165 7.21437 22 6.24788 22H3.75C2.7835 22 2 21.2165 2 20.25V17.7521C2 16.7856 2.7835 16.0021 3.75 16.0021H6.24788ZM6.24788 17.5021H3.75C3.61193 17.5021 3.5 17.6141 3.5 17.7521V20.25C3.5 20.3881 3.61193 20.5 3.75 20.5H6.24788C6.38595 20.5 6.49788 20.3881 6.49788 20.25V17.7521C6.49788 17.6141 6.38595 17.5021 6.24788 17.5021ZM9.74809 18H21.2529C21.6671 18 22.0029 18.3358 22.0029 18.75C22.0029 19.1297 21.7207 19.4435 21.3547 19.4932L21.2529 19.5H9.74809C9.33388 19.5 8.99809 19.1642 8.99809 18.75C8.99809 18.3703 9.28025 18.0565 9.64632 18.0068L9.74809 18H21.2529H9.74809ZM6.24788 9.00106C7.21437 9.00106 7.99788 9.78456 7.99788 10.7511V13.2489C7.99788 14.2154 7.21437 14.9989 6.24788 14.9989H3.75C2.7835 14.9989 2 14.2154 2 13.2489V10.7511C2 9.78456 2.7835 9.00106 3.75 9.00106H6.24788ZM6.24788 10.5011H3.75C3.61193 10.5011 3.5 10.613 3.5 10.7511V13.2489C3.5 13.387 3.61193 13.4989 3.75 13.4989H6.24788C6.38595 13.4989 6.49788 13.387 6.49788 13.2489V10.7511C6.49788 10.613 6.38595 10.5011 6.24788 10.5011ZM9.74809 11H21.2529C21.6671 11 22.0029 11.3358 22.0029 11.75C22.0029 12.1297 21.7207 12.4435 21.3547 12.4932L21.2529 12.5H9.74809C9.33388 12.5 8.99809 12.1642 8.99809 11.75C8.99809 11.3703 9.28025 11.0565 9.64632 11.0068L9.74809 11H21.2529H9.74809ZM6.24788 2C7.21437 2 7.99788 2.7835 7.99788 3.75V6.24788C7.99788 7.21437 7.21437 7.99788 6.24788 7.99788H3.75C2.7835 7.99788 2 7.21437 2 6.24788V3.75C2 2.7835 2.7835 2 3.75 2H6.24788ZM6.24788 3.5H3.75C3.61193 3.5 3.5 3.61193 3.5 3.75V6.24788C3.5 6.38595 3.61193 6.49788 3.75 6.49788H6.24788C6.38595 6.49788 6.49788 6.38595 6.49788 6.24788V3.75C6.49788 3.61193 6.38595 3.5 6.24788 3.5ZM9.74809 4H21.2529C21.6671 4 22.0029 4.33579 22.0029 4.75C22.0029 5.1297 21.7207 5.44349 21.3547 5.49315L21.2529 5.5H9.74809C9.33388 5.5 8.99809 5.16421 8.99809 4.75C8.99809 4.3703 9.28025 4.05651 9.64632 4.00685L9.74809 4H21.2529H9.74809Z " },
            { FluentSymbol.Archive16Filled, "M2 3C2 2.44772 2.44772 2 3 2H13C13.5523 2 14 2.44772 14 3V4C14 4.55228 13.5523 5 13 5H3C2.44772 5 2 4.55228 2 4V3Z M3 6V12C3 13.1046 3.89543 14 5 14H11C12.1046 14 13 13.1046 13 12V6H3ZM7 7H9C9.27614 7 9.5 7.22386 9.5 7.5C9.5 7.77614 9.27614 8 9 8H7C6.72386 8 6.5 7.77614 6.5 7.5C6.5 7.22386 6.72386 7 7 7Z " },
            { FluentSymbol.Archive16, "M7 7C6.72386 7 6.5 7.22386 6.5 7.5C6.5 7.77614 6.72386 8 7 8H9C9.27614 8 9.5 7.77614 9.5 7.5C9.5 7.22386 9.27614 7 9 7H7Z M2 5C2 5.55228 2.44772 6 3 6L3 12C3 13.1046 3.89543 14 5 14H11C12.1046 14 13 13.1046 13 12V6C13.5523 6 14 5.55228 14 5V3C14 2.44772 13.5523 2 13 2H3C2.44772 2 2 2.44772 2 3V5ZM13 3L13 5H3L3 3H13ZM4 6H12V12C12 12.5523 11.5523 13 11 13H5C4.44772 13 4 12.5523 4 12V6Z " },
            { FluentSymbol.Archive20Filled, "M17 7V15C17 16.6569 15.6569 18 14 18H6C4.34315 18 3 16.6569 3 15V7H17ZM11.5 9H8.5C8.22386 9 8 9.22386 8 9.5C8 9.77614 8.22386 10 8.5 10H11.5C11.7761 10 12 9.77614 12 9.5C12 9.22386 11.7761 9 11.5 9ZM17 2C17.5523 2 18 2.44772 18 3V5C18 5.55228 17.5523 6 17 6H3C2.44772 6 2 5.55228 2 5V3C2 2.44772 2.44772 2 3 2H17Z " },
            { FluentSymbol.Archive20, "M16.5 2C17.3284 2 18 2.67157 18 3.5V5.5C18 6.15285 17.5829 6.70828 17.0007 6.9144L17 14.5C17 16.433 15.433 18 13.5 18H6.5C4.567 18 3 16.433 3 14.5L3.00029 6.91475C2.41754 6.70891 2 6.15322 2 5.5V3.5C2 2.67157 2.67157 2 3.5 2H16.5ZM16 7H4V14.5C4 15.8807 5.11929 17 6.5 17H13.5C14.8807 17 16 15.8807 16 14.5V7ZM8.5 9H11.5C11.7761 9 12 9.22386 12 9.5C12 9.74546 11.8231 9.94961 11.5899 9.99194L11.5 10H8.5C8.22386 10 8 9.77614 8 9.5C8 9.25454 8.17688 9.05039 8.41012 9.00806L8.5 9H11.5H8.5ZM16.5 3H3.5C3.22386 3 3 3.22386 3 3.5V5.5C3 5.77614 3.22386 6 3.5 6H16.5C16.7761 6 17 5.77614 17 5.5V3.5C17 3.22386 16.7761 3 16.5 3Z " },
            { FluentSymbol.Archive24Filled, "M20 8V19.5C20 20.8807 18.8807 22 17.5 22H6.5C5.11929 22 4 20.8807 4 19.5V8H20ZM14 11.5H10C9.58579 11.5 9.25 11.8358 9.25 12.25C9.25 12.6642 9.58579 13 10 13H14C14.4142 13 14.75 12.6642 14.75 12.25C14.75 11.8358 14.4142 11.5 14 11.5ZM20 3C20.5523 3 21 3.44772 21 4V6C21 6.55228 20.5523 7 20 7H4C3.44772 7 3 6.55228 3 6V4C3 3.44772 3.44772 3 4 3H20Z " },
            { FluentSymbol.Archive24, "M19.25 3C20.2165 3 21 3.7835 21 4.75V6.75C21 7.44776 20.5916 8.05015 20.0008 8.33119L20 18.25C20 20.3211 18.3211 22 16.25 22H7.75C5.67893 22 4 20.3211 4 18.25L4.00015 8.33166C3.40883 8.05083 3 7.44816 3 6.75V4.75C3 3.7835 3.7835 3 4.75 3H19.25ZM18.5 8.5H5.5V18.25C5.5 19.4926 6.50736 20.5 7.75 20.5H16.25C17.4926 20.5 18.5 19.4926 18.5 18.25V8.5ZM10 11.5H14C14.4142 11.5 14.75 11.8358 14.75 12.25C14.75 12.6297 14.4678 12.9435 14.1018 12.9932L14 13H10C9.58579 13 9.25 12.6642 9.25 12.25C9.25 11.8703 9.53215 11.5565 9.89823 11.5068L10 11.5H14H10ZM19.25 4.5H4.75C4.61193 4.5 4.5 4.61193 4.5 4.75V6.75C4.5 6.88807 4.61193 7 4.75 7H19.25C19.3881 7 19.5 6.88807 19.5 6.75V4.75C19.5 4.61193 19.3881 4.5 19.25 4.5Z " },
            { FluentSymbol.Archive28Filled, "M23 10V21.25C23 23.3211 21.3211 25 19.25 25H8.75C6.67893 25 5 23.3211 5 21.25V10H23ZM16.25 13.5H11.75C11.3358 13.5 11 13.8358 11 14.25C11 14.6642 11.3358 15 11.75 15H16.25C16.6642 15 17 14.6642 17 14.25C17 13.8358 16.6642 13.5 16.25 13.5ZM22.25 3C23.2165 3 24 3.7835 24 4.75V7.25C24 8.2165 23.2165 9 22.25 9H5.75C4.7835 9 4 8.2165 4 7.25V4.75C4 3.7835 4.7835 3 5.75 3H22.25Z " },
            { FluentSymbol.Archive28, "M22.25 3C23.2165 3 24 3.7835 24 4.75V8.25C24 8.94776 23.5916 9.55015 23.0008 9.83119L23 21.25C23 23.2543 21.4276 24.8913 19.4492 24.9948L19.25 25H8.75C6.74574 25 5.10873 23.4276 5.0052 21.4492L5 21.25L5.00015 9.83166C4.40883 9.55083 4 8.94816 4 8.25V4.75C4 3.7835 4.7835 3 5.75 3H22.25ZM21.5 9.999H6.5V21.25C6.5 22.4409 7.42516 23.4156 8.59595 23.4948L8.75 23.5H19.25C20.4409 23.5 21.4156 22.5748 21.4948 21.404L21.5 21.25V9.999ZM11.75 13.5H16.25C16.6642 13.5 17 13.8358 17 14.25C17 14.6297 16.7178 14.9435 16.3518 14.9932L16.25 15H11.75C11.3358 15 11 14.6642 11 14.25C11 13.8703 11.2822 13.5565 11.6482 13.5068L11.75 13.5H16.25H11.75ZM22.25 4.5H5.75C5.61193 4.5 5.5 4.61193 5.5 4.75V8.25C5.5 8.38807 5.61193 8.5 5.75 8.5H22.25C22.3881 8.5 22.5 8.38807 22.5 8.25V4.75C22.5 4.61193 22.3881 4.5 22.25 4.5Z " },
            { FluentSymbol.Archive48Filled, "M38 18V36C38 38.2091 36.2091 40 34 40H14C11.7909 40 10 38.2091 10 36V18H38ZM26.75 22.5H20.25C19.5596 22.5 19 23.0596 19 23.75C19 24.4404 19.5596 25 20.25 25H26.75C27.4404 25 28 24.4404 28 23.75C28 23.0596 27.4404 22.5 26.75 22.5ZM38 8C39.1046 8 40 8.89543 40 10V14C40 15.1046 39.1046 16 38 16H10C8.89543 16 8 15.1046 8 14V10C8 8.89543 8.89543 8 10 8H38Z " },
            { FluentSymbol.Archive48, "M37.75 8C38.9926 8 40 9.00736 40 10.25V15.75C40 16.9079 39.1253 17.8616 38.0006 17.9862L38 35.75C38 38.0282 36.2075 39.8877 33.9559 39.9951L33.75 40H14.25C11.9718 40 10.1123 38.2075 10.0049 35.9559L10 35.75L10.0004 17.9863C8.87524 17.8622 8 16.9083 8 15.75V10.25C8 9.00736 9.00736 8 10.25 8H37.75ZM35.5 18H12.5V35.75C12.5 36.6682 13.2071 37.4212 14.1065 37.4942L14.25 37.5H33.75C34.6682 37.5 35.4212 36.7929 35.4942 35.8935L35.5 35.75V18ZM20.25 22.5H26.75C27.4404 22.5 28 23.0596 28 23.75C28 24.3972 27.5081 24.9295 26.8778 24.9935L26.75 25H20.25C19.5596 25 19 24.4404 19 23.75C19 23.1028 19.4919 22.5705 20.1222 22.5065L20.25 22.5H26.75H20.25ZM37.5 10.5H10.5V15.5H37.5V10.5Z " },
            { FluentSymbol.ArrowAutofitHeight24Filled, "M12.9518 5.89823L13.0364 5.80024L15.3905 3.44343C15.5696 3.16991 15.8949 3 16.2509 3C16.5739 3 16.8697 3.13942 17.0558 3.3679L17.0614 3.37469L17.1068 3.43924L19.4653 5.80024L19.5498 5.89823L19.5553 5.90564C19.8138 6.25403 19.817 6.73134 19.5649 7.08288L19.5589 7.09122L19.46 7.20774L19.3542 7.29904L19.3468 7.30454C18.9984 7.56304 18.5211 7.56619 18.1696 7.31411L18.1612 7.30813L18.0517 7.21513L17.25 6.4135V9.60344L17.2416 9.71169L17.2402 9.72122C17.1682 10.1853 16.7292 10.5 16.2499 10.5C15.7705 10.5 15.3317 10.1851 15.2598 9.72099L15.2583 9.71146L15.25 9.60325V6.41407L14.4507 7.21435L14.3526 7.29904L14.3452 7.30454C13.9535 7.59515 13.3981 7.56311 13.0429 7.20793C12.6877 6.85275 12.6557 6.29731 12.9463 5.90564L12.9518 5.89823Z M4 6.49219C4 5.11148 5.11929 3.99219 6.5 3.99219H10.5C11.0523 3.99219 11.5 4.4399 11.5 4.99219C11.5 5.54447 11.0523 5.99219 10.5 5.99219H6.5C6.22386 5.99219 6 6.21604 6 6.49219V17.4922C6 17.7683 6.22386 17.9922 6.5 17.9922H10.5C11.0523 17.9922 11.5 18.4399 11.5 18.9922C11.5 19.5445 11.0523 19.9922 10.5 19.9922H6.5C5.11929 19.9922 4 18.8729 4 17.4922V6.49219Z M14.4526 16.7856L14.3545 16.701L14.3471 16.6955C13.9554 16.4049 13.4 16.4369 13.0448 16.7921C12.6543 17.1826 12.6544 17.8158 13.0448 18.2063L15.3924 20.5566C15.5715 20.8301 15.8968 21 16.2528 21C16.6089 21 16.9343 20.8299 17.1133 20.5562L19.4672 18.1998L19.5518 18.1018L19.5573 18.0944C19.8479 17.7027 19.8158 17.1473 19.4607 16.7921L19.4542 16.7856L19.3561 16.701L19.3487 16.6955C18.9571 16.4049 18.4016 16.4369 18.0464 16.7921L17.2519 17.5865V14.3966L17.2436 14.2883L17.2421 14.2788C17.1701 13.8147 16.7312 13.5 16.2518 13.5C15.7319 13.5 15.2519 13.8756 15.2519 14.4064V17.5859L14.4526 16.7856Z " },
            { FluentSymbol.ArrowAutofitHeight24, "M13.2197 6.78115C12.9534 6.51488 12.9292 6.09822 13.1471 5.80461L13.2197 5.72049L15.5871 3.35039C15.7128 3.14201 15.9629 3 16.2509 3C16.503 3 16.726 3.10886 16.862 3.27578L16.9148 3.35073L19.282 5.72049L19.3546 5.80461C19.5482 6.0656 19.5506 6.42381 19.3618 6.6872L19.282 6.78115L19.1979 6.85377C18.9369 7.04742 18.5787 7.04981 18.3153 6.86094L18.2213 6.78115L17 5.56V9.34383L16.9931 9.43288C16.9434 9.75319 16.6296 10 16.2499 10C15.8702 10 15.5565 9.75305 15.5068 9.43272L15.5 9.34367V5.56L14.2803 6.78115L14.1962 6.85377C13.9026 7.07162 13.4859 7.04742 13.2197 6.78115Z M13.2226 17.2188C13.4889 16.9526 13.9055 16.9284 14.1991 17.1462L14.2832 17.2188L15.5029 18.44V14.6563C15.5029 14.2939 15.8386 14 16.2528 14C16.6325 14 16.9464 14.2468 16.9961 14.5671L17.0029 14.6562V18.44L18.2242 17.2188C18.4905 16.9526 18.9072 16.9284 19.2008 17.1462L19.2849 17.2188C19.5512 17.4851 19.5754 17.9018 19.3575 18.1954L19.2849 18.2795L16.9177 20.6493C16.7921 20.8578 16.5419 21 16.2538 21C15.9658 21 15.7157 20.858 15.59 20.6496L13.2226 18.2795C12.9297 17.9866 12.9297 17.5117 13.2226 17.2188Z M6.25 3.99219C5.00736 3.99219 4 4.99955 4 6.24219V17.7422C4 18.9848 5.00736 19.9922 6.25 19.9922H10.25C10.6642 19.9922 11 19.6564 11 19.2422C11 18.828 10.6642 18.4922 10.25 18.4922H6.25C5.83579 18.4922 5.5 18.1564 5.5 17.7422V6.24219C5.5 5.82797 5.83579 5.49219 6.25 5.49219H10.25C10.6642 5.49219 11 5.1564 11 4.74219C11 4.32797 10.6642 3.99219 10.25 3.99219H6.25Z " },
            { FluentSymbol.ArrowAutofitWidth24Filled, "M17.5 3.99219C18.8807 3.99219 20 5.11148 20 6.49219V10.4922C20 11.0445 19.5523 11.4922 19 11.4922C18.4477 11.4922 18 11.0445 18 10.4922V6.49219C18 6.21605 17.7761 5.99219 17.5 5.99219H6.5C6.22386 5.99219 6 6.21605 6 6.49219V10.4922C6 11.0445 5.55229 11.4922 5 11.4922C4.44771 11.4922 4 11.0445 4 10.4922V6.49219C4 5.11148 5.11929 3.99219 6.5 3.99219H17.5Z M18.1998 13.0364L18.1018 12.9518L18.0944 12.9463C17.7027 12.6557 17.1473 12.6877 16.7921 13.0429C16.4369 13.3981 16.4049 13.9535 16.6955 14.3452L16.701 14.3526L16.7856 14.4507L17.5859 15.25H14.3968L14.2885 15.2583L14.279 15.2598C13.8149 15.3317 13.5 15.7705 13.5 16.2499C13.5 16.7292 13.8147 17.1682 14.2788 17.2402L14.2883 17.2416L14.3966 17.25H17.5865L16.7849 18.0517L16.6919 18.1612L16.6859 18.1696C16.4338 18.5211 16.437 18.9984 16.6955 19.3468L16.701 19.3542L16.7923 19.46L16.9088 19.5589L16.9171 19.5649C17.2687 19.817 17.746 19.8138 18.0944 19.5553L18.1018 19.5498L18.1998 19.4653L20.5608 17.1068L20.6253 17.0614L20.6321 17.0558C20.8606 16.8697 21 16.5739 21 16.2509C21 15.8949 20.8301 15.5696 20.5566 15.3905L18.1998 13.0364Z M7.27365 14.3555L7.18896 14.4536L6.38868 15.2529H9.56824C10.099 15.2528 10.4746 15.7329 10.4746 16.2528C10.4746 16.7321 10.1599 17.171 9.69583 17.2431L9.6863 17.2445L9.57806 17.2529H6.38811L7.18254 18.0474C7.5377 18.4026 7.56975 18.958 7.27915 19.3497L7.27365 19.3571L7.18901 19.4552L7.18254 19.4616C6.82736 19.8168 6.27192 19.8488 5.88025 19.5582L5.87284 19.5527L5.77485 19.4681L3.41844 17.1143C3.14473 16.9353 2.97461 16.6099 2.97461 16.2538C2.97461 15.8978 3.14451 15.5725 3.41804 15.3934L5.76832 13.0458C6.15886 12.6553 6.79205 12.6553 7.18254 13.0458C7.53772 13.401 7.56976 13.9564 7.27915 14.3481L7.27365 14.3555Z " },
            { FluentSymbol.ArrowAutofitWidth24, "M20 6.24219C20 4.99955 18.9926 3.99219 17.75 3.99219H6.25C5.00736 3.99219 4 4.99955 4 6.24219V10.2422C4 10.6564 4.33579 10.9922 4.75 10.9922C5.16421 10.9922 5.5 10.6564 5.5 10.2422V6.24219C5.5 5.82797 5.83579 5.49219 6.25 5.49219H17.75C18.1642 5.49219 18.5 5.82797 18.5 6.24219V10.2422C18.5 10.6564 18.8358 10.9922 19.25 10.9922C19.6642 10.9922 20 10.6564 20 10.2422V6.24219Z M17.2188 13.2197C17.4851 12.9534 17.9018 12.9292 18.1954 13.1471L18.2795 13.2197L20.6496 15.5871C20.858 15.7128 21 15.9629 21 16.2509C21 16.503 20.8911 16.726 20.7242 16.862L20.6493 16.9148L18.2795 19.282L18.1954 19.3546C17.9344 19.5482 17.5762 19.5506 17.3128 19.3618L17.2188 19.282L17.1462 19.1979C16.9526 18.9369 16.9502 18.5787 17.1391 18.3153L17.2188 18.2213L18.44 17H14.6562L14.5671 16.9931C14.2468 16.9434 14 16.6296 14 16.2499C14 15.8702 14.247 15.5565 14.5673 15.5068L14.6563 15.5H18.44L17.2188 14.2803L17.1462 14.1962C16.9284 13.9026 16.9526 13.4859 17.2188 13.2197Z M6.78115 13.2226C7.04742 13.4889 7.07162 13.9055 6.85377 14.1991L6.78115 14.2832L5.56 15.5029H9.34367C9.7061 15.5029 10 15.8386 10 16.2528C10 16.6325 9.75319 16.9464 9.43288 16.9961L9.34383 17.0029H5.56L6.78115 18.2242C7.04742 18.4905 7.07162 18.9072 6.85377 19.2008L6.78115 19.2849C6.51488 19.5512 6.09822 19.5754 5.80461 19.3575L5.72049 19.2849L3.35072 16.9177C3.14219 16.7921 3 16.5419 3 16.2538C3 15.9658 3.14201 15.7157 3.35039 15.59L5.72049 13.2226C6.01338 12.9297 6.48826 12.9297 6.78115 13.2226Z " },
            { FluentSymbol.ArrowBounce16Filled, "M8.00248 4.75C8.00248 4.33579 7.6667 4 7.25248 4H1.75195C1.33774 4 1.00195 4.33579 1.00195 4.75V10.25C1.00195 10.6642 1.33774 11 1.75195 11C2.16617 11 2.50195 10.6642 2.50195 10.25V6.56098L8.21982 12.2803C8.36047 12.4209 8.55125 12.5 8.75018 12.5C8.94911 12.5 9.13989 12.421 9.28056 12.2803L14.7804 6.78032C15.0733 6.48742 15.0733 6.01255 14.7804 5.71966C14.4875 5.42677 14.0126 5.42678 13.7197 5.71968L8.75027 10.6893L3.5623 5.5H7.25248C7.6667 5.5 8.00248 5.16421 8.00248 4.75Z " },
            { FluentSymbol.ArrowBounce16, "M8 4.5C8 4.22386 7.77614 4 7.5 4H1.5C1.22386 4 1 4.22386 1 4.5V10.5C1 10.7761 1.22386 11 1.5 11C1.77614 11 2 10.7761 2 10.5V5.70709L8.39664 12.1036C8.5919 12.2988 8.90848 12.2988 9.10374 12.1036L14.8536 6.35374C15.0488 6.15848 15.0488 5.8419 14.8536 5.64663C14.6583 5.45137 14.3417 5.45137 14.1464 5.64663L8.75018 11.0429L2.70713 5H7.5C7.77614 5 8 4.77614 8 4.5Z " },
            { FluentSymbol.ArrowBounce24Filled, "M11 7C11 6.44772 10.5523 6 10 6H3C2.44772 6 2 6.44772 2 7V14C2 14.5523 2.44772 15 3 15C3.55228 15 4 14.5523 4 14V9.41418L12.0431 17.4571C12.2306 17.6446 12.485 17.75 12.7502 17.75C13.0154 17.75 13.2698 17.6446 13.4573 17.4571L21.7071 9.2071C22.0976 8.81657 22.0976 8.1834 21.7071 7.79289C21.3166 7.40237 20.6834 7.40237 20.2929 7.7929L12.7502 15.3358L5.41425 8H10C10.5523 8 11 7.55228 11 7Z " },
            { FluentSymbol.ArrowBounce24, "M11.0025 6.75C11.0025 6.33579 10.6667 6 10.2525 6H2.75195C2.33774 6 2.00195 6.33579 2.00195 6.75V14.25C2.00195 14.6642 2.33774 15 2.75195 15C3.16617 15 3.50195 14.6642 3.50195 14.25V8.56088L12.2198 17.2803C12.3605 17.421 12.5513 17.5 12.7502 17.5C12.9491 17.5 13.1399 17.421 13.2806 17.2803L21.7804 8.78032C22.0733 8.48743 22.0733 8.01255 21.7804 7.71966C21.4875 7.42677 21.0126 7.42678 20.7197 7.71968L12.7503 15.6893L4.56239 7.5H10.2525C10.6667 7.5 11.0025 7.16421 11.0025 6.75Z " },
            { FluentSymbol.ArrowClockwise20Filled, "M10.6276 2.02507C6.22292 1.67841 2.37123 4.96807 2.02457 9.37273C1.67792 13.7774 4.96758 17.6291 9.37224 17.9757C13.7769 18.3224 17.6286 15.0327 17.9752 10.6281C17.9976 10.3446 18.0038 10.04 17.9948 9.73892C17.9824 9.3249 17.6367 8.99932 17.2227 9.01173C16.8086 9.02414 16.4831 9.36984 16.4955 9.78387C16.5029 10.0325 16.4978 10.283 16.4799 10.5104C16.1982 14.0892 13.0687 16.762 9.48993 16.4804C5.91114 16.1987 3.23829 13.0692 3.51995 9.49042C3.8016 5.91164 6.93111 3.23879 10.5099 3.52044C12.2462 3.65709 13.8156 4.4709 14.9222 5.75512L15.1258 6.003L12.747 6.00387L12.6452 6.01072C12.2791 6.06038 11.997 6.37417 11.997 6.75387C11.997 7.13356 12.2791 7.44736 12.6452 7.49702L12.747 7.50387H16.7469L16.8487 7.49702C17.1815 7.45187 17.4449 7.18844 17.4901 6.85564L17.4969 6.75387V2.75387L17.4901 2.6521C17.4449 2.3193 17.1815 2.05586 16.8487 2.01072L16.7469 2.00387L16.6451 2.01072C16.3124 2.05586 16.0489 2.3193 16.0038 2.6521L15.9969 2.75387L15.9981 4.70662C14.6402 3.16672 12.7322 2.1907 10.6276 2.02507Z " },
            { FluentSymbol.ArrowClockwise20, "M3.06573 9.04998C3.5904 5.21975 7.12074 2.54007 10.951 3.06475C12.8937 3.33087 14.5398 4.36951 15.6231 5.82964L15.7494 5.99997H12.5001C12.2239 5.99997 12.0001 6.22383 12.0001 6.49997C12.0001 6.77611 12.2239 6.99997 12.5001 6.99997H16.5001C16.7762 6.99997 17.0001 6.77611 17.0001 6.49997V2.49997C17.0001 2.22383 16.7762 1.99997 16.5001 1.99997C16.2239 1.99997 16.0001 2.22383 16.0001 2.49997V4.70729C14.7758 3.31847 13.0653 2.34504 11.0867 2.074C6.70929 1.47437 2.67461 4.53686 2.07498 8.91426C1.47535 13.2917 4.53784 17.3263 8.91524 17.926C13.2926 18.5256 17.3273 15.4631 17.9269 11.0857C18.0011 10.5444 18.0192 10.0079 17.9857 9.48208C17.9681 9.2065 17.7304 8.99737 17.4548 9.01497C17.1792 9.03258 16.9701 9.27025 16.9877 9.54583C17.017 10.0054 17.0012 10.4752 16.9362 10.95C16.4115 14.7802 12.8812 17.4599 9.05095 16.9352C5.22073 16.4105 2.54105 12.8802 3.06573 9.04998Z " },
            { FluentSymbol.ArrowClockwise24Filled, "M12 4.75C7.99594 4.75 4.75 7.99594 4.75 12C4.75 16.0041 7.99594 19.25 12 19.25C16.0041 19.25 19.25 16.0041 19.25 12C19.25 11.7144 19.2335 11.4326 19.2014 11.1556C19.1333 10.5685 19.5593 10 20.1504 10C20.666 10 21.1193 10.3581 21.1817 10.8699C21.2268 11.2403 21.25 11.6174 21.25 12C21.25 17.1086 17.1086 21.25 12 21.25C6.89137 21.25 2.75 17.1086 2.75 12C2.75 6.89137 6.89137 2.75 12 2.75C14.1731 2.75 16.1712 3.49939 17.75 4.75385V4.25C17.75 3.69772 18.1977 3.25 18.75 3.25C19.3023 3.25 19.75 3.69772 19.75 4.25V6.94829C19.7612 6.96549 19.7724 6.98272 19.7835 7H19.75V7.25C19.75 7.80228 19.3023 8.25 18.75 8.25H15.75C15.1977 8.25 14.75 7.80228 14.75 7.25C14.75 6.69772 15.1977 6.25 15.75 6.25H16.4165C15.1936 5.30932 13.6621 4.75 12 4.75Z " },
            { FluentSymbol.ArrowClockwise24, "M12 4.5C7.85786 4.5 4.5 7.85786 4.5 12C4.5 16.1421 7.85786 19.5 12 19.5C16.1421 19.5 19.5 16.1421 19.5 12C19.5 11.6236 19.4723 11.2538 19.4188 10.8923C19.3515 10.4382 19.6839 10 20.1429 10C20.5138 10 20.839 10.2562 20.8953 10.6228C20.9642 11.0718 21 11.5317 21 12C21 16.9706 16.9706 21 12 21C7.02944 21 3 16.9706 3 12C3 7.02944 7.02944 3 12 3C14.3051 3 16.4077 3.86656 18 5.29168V4.25C18 3.83579 18.3358 3.5 18.75 3.5C19.1642 3.5 19.5 3.83579 19.5 4.25V7.25C19.5 7.66421 19.1642 8 18.75 8H15.75C15.3358 8 15 7.66421 15 7.25C15 6.83579 15.3358 6.5 15.75 6.5H17.0991C15.7609 5.25883 13.9691 4.5 12 4.5Z " },
            { FluentSymbol.ArrowCounterclockwise28Filled, "M8.34247 7C9.88875 5.74851 11.8569 5 14 5C18.9706 5 23 9.02944 23 14C23 18.9706 18.9706 23 14 23C9.02944 23 5 18.9706 5 14C5 13.6955 5.01508 13.3949 5.04448 13.0988C5.09905 12.5492 4.69776 12.0595 4.14818 12.0049C3.59859 11.9503 3.10883 12.3516 3.05427 12.9012C3.01836 13.2629 3 13.6295 3 14C3 20.0751 7.92487 25 14 25C20.0751 25 25 20.0751 25 14C25 7.92487 20.0751 3 14 3C11.3405 3 8.90133 3.94442 7 5.51448V4C7 3.44772 6.55228 3 6 3C5.44772 3 5 3.44772 5 4V7.98746C4.99985 8.00129 4.99999 8.01511 5.00041 8.02892C5.01571 8.56783 5.45739 9 6 9H10C10.5523 9 11 8.55228 11 8C11 7.44772 10.5523 7 10 7H8.34247Z " },
            { FluentSymbol.ArrowCounterclockwise28, "M8.16821 6.5C9.77826 5.24608 11.8017 4.5 14 4.5C19.2467 4.5 23.5 8.75329 23.5 14C23.5 19.2467 19.2467 23.5 14 23.5C8.75329 23.5 4.5 19.2467 4.5 14C4.5 13.5479 4.53032 13.3411 4.60072 12.861L4.60104 12.8588C4.66114 12.449 4.37762 12.068 3.96779 12.0079C3.55796 11.9478 3.17701 12.2314 3.11691 12.6412L3.11512 12.6534C3.04323 13.1436 3 13.4384 3 14C3 20.0751 7.92487 25 14 25C20.0751 25 25 20.0751 25 14C25 7.92487 20.0751 3 14 3C11.3408 3 8.90147 3.94423 7 5.5144V3.75C7 3.33579 6.66421 3 6.25 3C5.83579 3 5.5 3.33579 5.5 3.75V7.25C5.5 7.66421 5.83579 8 6.25 8H9.75C10.1642 8 10.5 7.66421 10.5 7.25C10.5 6.83579 10.1642 6.5 9.75 6.5H8.16821Z " },
            { FluentSymbol.ArrowCounterclockwise20Filled, "M9.37242 2.02507C13.7771 1.67841 17.6288 4.96807 17.9754 9.37273C18.3221 13.7774 15.0324 17.6291 10.6278 17.9757C6.22311 18.3224 2.37141 15.0327 2.02475 10.6281C2.00244 10.3446 1.99617 10.04 2.0052 9.73892C2.01761 9.3249 2.3633 8.99932 2.77733 9.01173C3.19136 9.02414 3.51693 9.36984 3.50452 9.78387C3.49707 10.0325 3.50223 10.283 3.52013 10.5104C3.80178 14.0892 6.93129 16.762 10.5101 16.4804C14.0889 16.1987 16.7617 13.0692 16.4801 9.49042C16.1984 5.91164 13.0689 3.23879 9.49011 3.52044C7.75383 3.65709 6.18438 4.4709 5.07776 5.75512L4.87422 6.003L7.25302 6.00387L7.35479 6.01072C7.72086 6.06038 8.00302 6.37417 8.00302 6.75387C8.00302 7.13356 7.72086 7.44736 7.35479 7.49702L7.25302 7.50387H3.25308L3.15131 7.49702C2.81851 7.45187 2.55507 7.18844 2.50993 6.85564L2.50308 6.75387V2.75387L2.50993 2.6521C2.55507 2.3193 2.81851 2.05586 3.15131 2.01072L3.25308 2.00387L3.35485 2.01072C3.68765 2.05586 3.95109 2.3193 3.99623 2.6521L4.00308 2.75387L4.00188 4.70662C5.35978 3.16672 7.26778 2.1907 9.37242 2.02507Z " },
            { FluentSymbol.ArrowCounterclockwise20, "M16.9342 9.04998C16.4095 5.21975 12.8792 2.54007 9.04894 3.06475C7.10618 3.33087 5.46008 4.36951 4.37682 5.82964L4.25046 5.99997H7.49985C7.77599 5.99997 7.99985 6.22383 7.99985 6.49997C7.99985 6.77611 7.77599 6.99997 7.49985 6.99997H3.49985C3.22371 6.99997 2.99985 6.77611 2.99985 6.49997V2.49997C2.99985 2.22383 3.22371 1.99997 3.49985 1.99997C3.77599 1.99997 3.99985 2.22383 3.99985 2.49997V4.70729C5.22416 3.31847 6.93463 2.34504 8.91322 2.074C13.2906 1.47437 17.3253 4.53686 17.9249 8.91426C18.5246 13.2917 15.4621 17.3263 11.0847 17.926C6.70727 18.5256 2.67259 15.4631 2.07296 11.0857C1.99882 10.5444 1.98067 10.0079 2.01426 9.48208C2.03186 9.2065 2.26953 8.99737 2.54511 9.01497C2.82069 9.03258 3.02982 9.27025 3.01222 9.54583C2.98287 10.0054 2.99867 10.4752 3.06371 10.95C3.58839 14.7802 7.11873 17.4599 10.949 16.9352C14.7792 16.4105 17.4589 12.8802 16.9342 9.04998Z " },
            { FluentSymbol.ArrowCounterclockwise24Filled, "M12 4.75C16.0041 4.75 19.25 7.99594 19.25 12C19.25 16.0041 16.0041 19.25 12 19.25C7.99594 19.25 4.75 16.0041 4.75 12C4.75 11.7144 4.76652 11.4326 4.79864 11.1556C4.86674 10.5685 4.44068 10 3.8496 10C3.33398 10 2.88069 10.3581 2.81834 10.8699C2.77322 11.2403 2.75 11.6174 2.75 12C2.75 17.1086 6.89137 21.25 12 21.25C17.1086 21.25 21.25 17.1086 21.25 12C21.25 6.89137 17.1086 2.75 12 2.75C9.82686 2.75 7.82875 3.49939 6.25 4.75385V4.25C6.25 3.69772 5.80228 3.25 5.25 3.25C4.69772 3.25 4.25 3.69772 4.25 4.25V6.94829C4.23877 6.96549 4.22759 6.98272 4.21647 7H4.25V7.25C4.25 7.80228 4.69772 8.25 5.25 8.25H8.25C8.80228 8.25 9.25 7.80228 9.25 7.25C9.25 6.69772 8.80228 6.25 8.25 6.25H7.58352C8.80642 5.30932 10.3379 4.75 12 4.75Z " },
            { FluentSymbol.ArrowCounterclockwise24, "M12 4.5C16.1421 4.5 19.5 7.85786 19.5 12C19.5 16.1421 16.1421 19.5 12 19.5C7.85786 19.5 4.5 16.1421 4.5 12C4.5 11.6236 4.52772 11.2538 4.58123 10.8923C4.64845 10.4382 4.31609 10 3.85708 10C3.48623 10 3.161 10.2562 3.10471 10.6228C3.03576 11.0718 3 11.5317 3 12C3 16.9706 7.02944 21 12 21C16.9706 21 21 16.9706 21 12C21 7.02944 16.9706 3 12 3C9.69494 3 7.59227 3.86656 6 5.29168V4.25C6 3.83579 5.66421 3.5 5.25 3.5C4.83579 3.5 4.5 3.83579 4.5 4.25V7.25C4.5 7.66421 4.83579 8 5.25 8H8.25C8.66421 8 9 7.66421 9 7.25C9 6.83579 8.66421 6.5 8.25 6.5H6.90093C8.23907 5.25883 10.0309 4.5 12 4.5Z " },
            { FluentSymbol.ArrowCurveDownLeft16Filled, "M11.1512 1.37802C11.3567 1.73766 11.2317 2.19579 10.8721 2.4013C8.45801 3.78077 8.25 6.02905 8.25 8.00006L8.25003 12.4394L10.4697 10.2197C10.7626 9.92683 11.2374 9.92682 11.5303 10.2197C11.8232 10.5126 11.8232 10.9875 11.5303 11.2804L8.03038 14.7803C7.88973 14.921 7.69897 15 7.50005 15C7.30114 15 7.11038 14.921 6.96972 14.7803L3.46967 11.2804C3.17678 10.9875 3.17678 10.5126 3.46967 10.2197C3.76256 9.92683 4.23743 9.92682 4.53033 10.2197L6.75003 12.4394L6.75 8.00006C6.75 5.97112 6.94199 2.91945 10.1279 1.09895C10.4875 0.89344 10.9457 1.01839 11.1512 1.37802Z " },
            { FluentSymbol.ArrowCurveDownLeft16, "M10.9341 1.25201C11.0711 1.49177 10.9878 1.7972 10.7481 1.9342C8.21284 3.38289 8 6.00221 8 8.00004L8.00004 13.2929L10.6464 10.6465C10.8417 10.4512 11.1583 10.4512 11.3536 10.6465C11.5488 10.8417 11.5488 11.1583 11.3536 11.3536L7.8536 14.8536C7.75984 14.9473 7.63266 15 7.50005 15C7.36744 15 7.24027 14.9473 7.1465 14.8536L3.64645 11.3536C3.45119 11.1583 3.45118 10.8417 3.64644 10.6465C3.8417 10.4512 4.15829 10.4512 4.35355 10.6465L7.00004 13.2929L7 8.00004C7 5.9979 7.18716 2.81725 10.2519 1.06596C10.4917 0.928959 10.7971 1.01226 10.9341 1.25201Z " },
            { FluentSymbol.ArrowCurveDownLeft20Filled, "M13.3859 3.14323C13.7411 2.93012 13.8562 2.46943 13.6431 2.11424C13.43 1.75906 12.9693 1.64388 12.6141 1.85699C11.2671 2.6652 10.2741 3.6418 9.6347 4.99155C9.00478 6.32136 8.75 7.94741 8.75 10.0001V15.4395L6.03033 12.7198C5.73744 12.4269 5.26256 12.4269 4.96967 12.7198C4.67678 13.0127 4.67678 13.4876 4.96967 13.7805L8.96967 17.7805C9.26256 18.0733 9.73744 18.0733 10.0303 17.7805L14.0303 13.7805C14.3232 13.4876 14.3232 13.0127 14.0303 12.7198C13.7374 12.4269 13.2626 12.4269 12.9697 12.7198L10.25 15.4395V10.0001C10.25 8.05282 10.4952 6.67886 10.9903 5.63368C11.4759 4.60842 12.2329 3.83503 13.3859 3.14323Z " },
            { FluentSymbol.ArrowCurveDownLeft20, "M13.2572 2.92882C13.494 2.78675 13.5708 2.47962 13.4287 2.24283C13.2867 2.00604 12.9795 1.92926 12.7428 2.07133C11.4281 2.86013 10.4744 3.80287 9.86063 5.09853C9.25319 6.38091 9 7.96494 9 10.0001V16.293L5.85355 13.1465C5.65829 12.9512 5.34171 12.9512 5.14645 13.1465C4.95118 13.3418 4.95118 13.6584 5.14645 13.8536L9.14645 17.8536C9.34171 18.0489 9.65829 18.0489 9.85355 17.8536L13.8536 13.8536C14.0488 13.6584 14.0488 13.3418 13.8536 13.1465C13.6583 12.9512 13.3417 12.9512 13.1464 13.1465L10 16.293V10.0001C10 8.03521 10.2468 6.61924 10.7644 5.52662C11.2756 4.44728 12.0719 3.64002 13.2572 2.92882Z " },
            { FluentSymbol.ArrowCurveDownLeft24Filled, "M16.8682 3.25403C17.1423 3.73354 16.9757 4.34439 16.4961 4.6184C14.6213 5.68974 13.7845 6.98078 13.3824 8.31386C12.9937 9.60288 12.9965 10.957 12.9995 12.3757C12.9997 12.5 13 12.6248 13 12.7501V17.8358L16.2929 14.543C16.6834 14.1524 17.3166 14.1524 17.7071 14.543C18.0976 14.9335 18.0976 15.5666 17.7071 15.9572L12.7071 20.9571C12.3166 21.3476 11.6834 21.3476 11.2929 20.9571L6.29289 15.9572C5.90237 15.5666 5.90237 14.9335 6.29289 14.543C6.68342 14.1524 7.31658 14.1524 7.70711 14.543L11 17.8358V12.7501C11 12.6196 10.9995 12.4861 10.999 12.3498C10.994 10.9771 10.988 9.32655 11.4676 7.73638C12.0155 5.9195 13.1787 4.21056 15.5039 2.88193C15.9834 2.60792 16.5942 2.77451 16.8682 3.25403Z " },
            { FluentSymbol.ArrowCurveDownLeft24, "M16.4012 3.37802C16.1957 3.01839 15.7375 2.89344 15.3779 3.09895C13.109 4.39542 11.9867 6.05212 11.4569 7.80854C10.9888 9.36083 10.9943 10.9741 10.9991 12.3513C10.9995 12.4866 11 12.6196 11 12.7501V18.4394L7.28033 14.7197C6.98744 14.4268 6.51256 14.4268 6.21967 14.7197C5.92678 15.0126 5.92678 15.4875 6.21967 15.7804L11.2197 20.7803C11.5126 21.0732 11.9874 21.0732 12.2803 20.7803L17.2803 15.7804C17.5732 15.4875 17.5732 15.0126 17.2803 14.7197C16.9874 14.4268 16.5126 14.4268 16.2197 14.7197L12.5 18.4394V12.7501C12.5 12.6234 12.4997 12.4968 12.4994 12.3704C12.4962 10.9589 12.493 9.56807 12.8931 8.24165C13.3133 6.84808 14.191 5.50481 16.1221 4.4013C16.4817 4.19579 16.6067 3.73766 16.4012 3.37802Z " },
            { FluentSymbol.ArrowCurveDownLeft28Filled, "M19.8682 3.50403C20.1423 3.98354 19.9757 4.59439 19.4961 4.8684C15.1375 7.35903 15 11.4757 15 15.0001V22.0858L19.2929 17.793C19.6834 17.4024 20.3166 17.4024 20.7071 17.793C21.0976 18.1835 21.0976 18.8166 20.7071 19.2072L14.7071 25.2071C14.3166 25.5976 13.6834 25.5976 13.2929 25.2071L7.29289 19.2072C6.90237 18.8166 6.90237 18.1835 7.29289 17.793C7.68342 17.4024 8.31658 17.4024 8.70711 17.793L13 22.0858V15.0001C13 11.5246 13.0625 6.24125 18.5039 3.13193C18.9834 2.85792 19.5942 3.02451 19.8682 3.50403Z " },
            { FluentSymbol.ArrowCurveDownLeft28, "M19.4012 3.37802C19.1957 3.01839 18.7375 2.89344 18.3779 3.09895C13.0719 6.13094 13 11.2684 13 14.7501V22.4394L8.28033 17.7197C7.98744 17.4268 7.51256 17.4268 7.21967 17.7197C6.92678 18.0126 6.92678 18.4875 7.21967 18.7804L13.2197 24.7803C13.5126 25.0732 13.9874 25.0732 14.2803 24.7803L20.2803 18.7804C20.5732 18.4875 20.5732 18.0126 20.2803 17.7197C19.9874 17.4268 19.5126 17.4268 19.2197 17.7197L14.5 22.4394V14.7501C14.5 11.2317 14.6281 6.96928 19.1221 4.4013C19.4817 4.1958 19.6067 3.73766 19.4012 3.37802Z " },
            { FluentSymbol.ArrowCurveDownRight20Filled, "M6.61413 3.14323C6.25894 2.93012 6.14377 2.46943 6.35688 2.11424C6.56999 1.75906 7.03069 1.64388 7.38587 1.85699C8.73287 2.6652 9.72595 3.6418 10.3653 4.99155C10.9952 6.32136 11.25 7.94741 11.25 10.0001V15.4395L13.9697 12.7198C14.2626 12.4269 14.7374 12.4269 15.0303 12.7198C15.3232 13.0127 15.3232 13.4876 15.0303 13.7805L11.0303 17.7805C10.7374 18.0733 10.2626 18.0733 9.96967 17.7805L5.96967 13.7805C5.67678 13.4876 5.67678 13.0127 5.96967 12.7198C6.26256 12.4269 6.73744 12.4269 7.03033 12.7198L9.75 15.4395V10.0001C9.75 8.05282 9.50478 6.67886 9.0097 5.63368C8.52405 4.60842 7.76713 3.83503 6.61413 3.14323Z " },
            { FluentSymbol.ArrowCurveDownRight20, "M6.74275 2.92882C6.50596 2.78675 6.42918 2.47962 6.57125 2.24283C6.71333 2.00604 7.02046 1.92926 7.25725 2.07133C8.57192 2.86013 9.52563 3.80287 10.1394 5.09853C10.7468 6.38091 11 7.96494 11 10.0001V16.293L14.1464 13.1465C14.3417 12.9512 14.6583 12.9512 14.8536 13.1465C15.0488 13.3418 15.0488 13.6584 14.8536 13.8536L10.8536 17.8536C10.6583 18.0489 10.3417 18.0489 10.1464 17.8536L6.14645 13.8536C5.95118 13.6584 5.95118 13.3418 6.14645 13.1465C6.34171 12.9512 6.65829 12.9512 6.85355 13.1465L10 16.293V10.0001C10 8.03521 9.75319 6.61924 9.23563 5.52662C8.72437 4.44728 7.92808 3.64002 6.74275 2.92882Z " },
            { FluentSymbol.ArrowCurveUpLeft20Filled, "M6.03033 7.03033C5.73744 7.32322 5.26256 7.32322 4.96967 7.03033C4.67678 6.73744 4.67678 6.26256 4.96967 5.96967L8.96967 1.96967C9.26256 1.67678 9.73744 1.67678 10.0303 1.96967L14.0303 5.96967C14.3232 6.26256 14.3232 6.73744 14.0303 7.03033C13.7374 7.32322 13.2626 7.32322 12.9697 7.03033L10.25 4.31066L10.25 9.75001C10.25 11.6973 10.4952 13.0713 10.9903 14.1164C11.4759 15.1417 12.2329 15.9151 13.3859 16.6069C13.7411 16.82 13.8562 17.2807 13.6431 17.6359C13.43 17.9911 12.9693 18.1062 12.6141 17.8931C11.2671 17.0849 10.2741 16.1083 9.6347 14.7586C9.00478 13.4288 8.75 11.8027 8.75 9.75001L8.75 4.31066L6.03033 7.03033Z " },
            { FluentSymbol.ArrowCurveUpLeft20, "M5.85355 6.85355C5.65829 7.04882 5.34171 7.04882 5.14645 6.85355C4.95118 6.65829 4.95118 6.34171 5.14645 6.14645L9.14645 2.14645C9.34171 1.95118 9.65829 1.95118 9.85355 2.14645L13.8536 6.14645C14.0488 6.34171 14.0488 6.65829 13.8536 6.85355C13.6583 7.04882 13.3417 7.04882 13.1464 6.85355L10 3.70711L10 9.99999C10 11.9648 10.2468 13.3808 10.7644 14.4734C11.2756 15.5528 12.0719 16.36 13.2572 17.0712C13.494 17.2133 13.5708 17.5204 13.4287 17.7572C13.2867 17.994 12.9795 18.0708 12.7428 17.9287C11.4281 17.1399 10.4744 16.1972 9.86063 14.9015C9.25319 13.6192 9 12.0351 9 9.99999L9 3.70711L5.85355 6.85355Z " },
            { FluentSymbol.ArrowCurveUpRight20Filled, "M13.9697 7.03033C14.2626 7.32322 14.7374 7.32322 15.0303 7.03033C15.3232 6.73744 15.3232 6.26256 15.0303 5.96967L11.0303 1.96967C10.7374 1.67678 10.2626 1.67678 9.96967 1.96967L5.96967 5.96967C5.67678 6.26256 5.67678 6.73744 5.96967 7.03033C6.26256 7.32322 6.73744 7.32322 7.03033 7.03033L9.75 4.31066L9.75 9.75001C9.75 11.6973 9.50478 13.0713 9.0097 14.1164C8.52405 15.1417 7.76713 15.9151 6.61413 16.6069C6.25894 16.82 6.14377 17.2807 6.35688 17.6359C6.56999 17.9911 7.03069 18.1062 7.38587 17.8931C8.73287 17.0849 9.72595 16.1083 10.3653 14.7586C10.9952 13.4288 11.25 11.8027 11.25 9.75001L11.25 4.31066L13.9697 7.03033Z " },
            { FluentSymbol.ArrowCurveUpRight20, "M14.1464 6.85355C14.3417 7.04882 14.6583 7.04882 14.8536 6.85355C15.0488 6.65829 15.0488 6.34171 14.8536 6.14645L10.8536 2.14645C10.6583 1.95118 10.3417 1.95118 10.1464 2.14645L6.14645 6.14645C5.95118 6.34171 5.95118 6.65829 6.14645 6.85355C6.34171 7.04882 6.65829 7.04882 6.85355 6.85355L10 3.70711L10 9.99999C10 11.9648 9.75319 13.3808 9.23563 14.4734C8.72437 15.5528 7.92808 16.36 6.74275 17.0712C6.50596 17.2133 6.42918 17.5204 6.57125 17.7572C6.71333 17.994 7.02046 18.0708 7.25725 17.9287C8.57192 17.1399 9.52563 16.1972 10.1394 14.9015C10.7468 13.6192 11 12.0351 11 9.99999L11 3.7071L14.1464 6.85355Z " },
            { FluentSymbol.ArrowDown12Filled, "M5.99995 1.5C6.41417 1.5 6.74995 1.83579 6.74995 2.25V8.18934L8.71962 6.21967C9.01252 5.92678 9.48739 5.92678 9.78028 6.21967C10.0732 6.51256 10.0732 6.98744 9.78028 7.28033L6.53028 10.5303C6.2374 10.8232 5.76254 10.8232 5.46964 10.5303L2.21944 7.28035C1.92654 6.98746 1.92653 6.51259 2.21941 6.21969C2.51229 5.92678 2.98717 5.92677 3.28007 6.21965L5.24995 8.18942V2.25C5.24995 1.83579 5.58574 1.5 5.99995 1.5Z " },
            { FluentSymbol.ArrowDown12, "M6 1.5C6.27614 1.5 6.5 1.72386 6.5 2V8.79289L9.14645 6.14645C9.34171 5.95118 9.65829 5.95118 9.85355 6.14645C10.0488 6.34171 10.0488 6.65829 9.85355 6.85355L6.35355 10.3536C6.15829 10.5488 5.84171 10.5488 5.64645 10.3536L2.14645 6.85355C1.95118 6.65829 1.95118 6.34171 2.14645 6.14645C2.34171 5.95118 2.65829 5.95118 2.85355 6.14645L5.5 8.79289V2C5.5 1.72386 5.72386 1.5 6 1.5Z " },
            { FluentSymbol.ArrowDown16Filled, "M8.00001 2C8.41422 2 8.75001 2.33579 8.75001 2.75V11.537L11.6911 8.24991C11.9673 7.94122 12.4414 7.91488 12.7501 8.19107C13.0588 8.46727 13.0851 8.94141 12.8089 9.2501L8.55894 14.0001C8.41666 14.1591 8.21339 14.25 8.00001 14.25C7.78663 14.25 7.58336 14.1591 7.44108 14.0001L3.19108 9.2501C2.91488 8.94141 2.94122 8.46727 3.24991 8.19107C3.5586 7.91488 4.03274 7.94122 4.30894 8.24991L7.25001 11.537V2.75C7.25001 2.33579 7.5858 2 8.00001 2Z " },
            { FluentSymbol.ArrowDown16, "M8.5 2.5C8.5 2.22386 8.27615 2 8 2C7.72386 2 7.5 2.22386 7.5 2.5V12.197L3.87165 8.16552C3.68692 7.96026 3.37078 7.94362 3.16552 8.12835C2.96027 8.31308 2.94363 8.62923 3.12836 8.83448L7.62836 13.8345C7.72318 13.9398 7.85826 14 8 14C8.14175 14 8.27683 13.9398 8.37165 13.8345L12.8717 8.83448C13.0564 8.62923 13.0397 8.31308 12.8345 8.12835C12.6292 7.94362 12.3131 7.96026 12.1284 8.16552L8.5 12.197V2.5Z " },
            { FluentSymbol.ArrowDown20Filled, "M16.7919 11.2654C17.0765 10.9644 17.0633 10.4897 16.7624 10.2051C16.4614 9.92049 15.9868 9.93371 15.7021 10.2346L10.747 15.4737V2.75C10.747 2.33579 10.4112 2 9.99702 2C9.58281 2 9.24702 2.33579 9.24702 2.75V15.476L4.28976 10.2346C4.00514 9.93371 3.53045 9.92049 3.22952 10.2051C2.92858 10.4897 2.91536 10.9644 3.19999 11.2654L9.26943 17.6826C9.42671 17.8489 9.62682 17.9489 9.83561 17.9826C9.8876 17.994 9.94161 18 9.99702 18C10.0546 18 10.1107 17.9935 10.1646 17.9812C10.3704 17.9462 10.5673 17.8467 10.7225 17.6826L16.7919 11.2654Z " },
            { FluentSymbol.ArrowDown20, "M16.8664 10.8371C17.0526 10.6332 17.0382 10.3169 16.8342 10.1307C16.6303 9.94456 16.314 9.95895 16.1278 10.1629L10.4971 16.3307V2.5C10.4971 2.22386 10.2733 2 9.99712 2C9.72097 2 9.49712 2.22386 9.49712 2.5V16.3279L3.86903 10.1629C3.68285 9.95895 3.36659 9.94456 3.16265 10.1307C2.95871 10.3169 2.94431 10.6332 3.13049 10.8371L9.44454 17.7535C9.5723 17.8934 9.73984 17.9732 9.91298 17.993C9.94033 17.9976 9.96844 18 9.99712 18C10.024 18 10.0504 17.9979 10.0761 17.9938C10.252 17.9756 10.4227 17.8955 10.5523 17.7535L16.8664 10.8371Z " },
            { FluentSymbol.ArrowDown24Filled, "M19.7159 13.7045C20.1036 13.3111 20.0989 12.678 19.7055 12.2903C19.3121 11.9027 18.6789 11.9074 18.2913 12.3008L13 17.6711V4C13 3.44771 12.5522 3 12 3C11.4477 3 11 3.44772 11 4V17.6646L5.71501 12.3008C5.32739 11.9074 4.69424 11.9027 4.30083 12.2903C3.90743 12.678 3.90274 13.3111 4.29036 13.7045L11.1127 20.6287C11.6024 21.1256 12.4039 21.1256 12.8936 20.6287L19.7159 13.7045Z " },
            { FluentSymbol.ArrowDown24, "M19.7905 13.2673C20.0762 12.9674 20.0646 12.4926 19.7647 12.2069C19.4648 11.9213 18.99 11.9328 18.7043 12.2327L12.7498 18.484V3.75C12.7498 3.33579 12.4141 3 11.9998 3C11.5856 3 11.2498 3.33579 11.2498 3.75V18.4844L5.29502 12.2327C5.00933 11.9328 4.5346 11.9213 4.23467 12.2069C3.93475 12.4926 3.9232 12.9674 4.20889 13.2673L11.2756 20.6862C11.4366 20.8553 11.642 20.9552 11.8556 20.9861C11.9023 20.9952 11.9505 21 11.9998 21C12.0495 21 12.0981 20.9952 12.1451 20.9859C12.3582 20.9548 12.5631 20.8549 12.7238 20.6862L19.7905 13.2673Z " },
            { FluentSymbol.ArrowDown28Filled, "M23.7117 15.7019C24.0999 15.309 24.0962 14.6759 23.7033 14.2877C23.3105 13.8995 22.6773 13.9033 22.2891 14.2962L15.0004 21.6724L15.0004 3.99707C15.0004 3.44479 14.5527 2.99707 14.0004 2.99707C13.4481 2.99707 13.0004 3.44479 13.0004 3.99707L13.0004 21.6701L5.714 14.2962C5.32581 13.9033 4.69266 13.8995 4.29981 14.2877C3.90696 14.6759 3.90318 15.309 4.29137 15.7019L13.1124 24.6289C13.6017 25.1241 14.4014 25.1241 14.8907 24.6289L23.7117 15.7019Z " },
            { FluentSymbol.ArrowDown28, "M23.7915 15.2665C24.0787 14.968 24.0695 14.4932 23.771 14.2061C23.4724 13.9189 22.9977 13.9281 22.7105 14.2266L14.751 22.5009L14.751 3.74805C14.751 3.33383 14.4152 2.99805 14.001 2.99805C13.5868 2.99805 13.251 3.33383 13.251 3.74805L13.251 22.4999L5.29246 14.2266C5.00531 13.9281 4.53052 13.9189 4.232 14.2061C3.93349 14.4932 3.92428 14.968 4.21144 15.2665L13.2808 24.6945C13.6742 25.1035 14.3287 25.1035 14.7222 24.6945L23.7915 15.2665Z " },
            { FluentSymbol.ArrowDownLeft16Filled, "M9.00025 13.25C9.00025 13.6642 8.66446 14 8.25025 14H2.75024C2.33603 14 2.00024 13.6642 2.00024 13.25V7.75C2.00024 7.33579 2.33603 7 2.75024 7C3.16446 7 3.50024 7.33579 3.50024 7.75V11.4393L12.7196 2.21968C13.0125 1.92678 13.4874 1.92677 13.7802 2.21966C14.0731 2.51255 14.0732 2.98742 13.7803 3.28032L4.56087 12.5H8.25025C8.66446 12.5 9.00025 12.8358 9.00025 13.25Z " },
            { FluentSymbol.ArrowDownLeft16, "M8.5 13C8.77614 13 9 13.2239 9 13.5C9 13.7761 8.77614 14 8.5 14H2.5C2.22386 14 2 13.7761 2 13.5V7.5C2 7.22386 2.22386 7 2.5 7C2.77614 7 3 7.22386 3 7.5V12.2929L13.1465 2.14645C13.3418 1.95118 13.6584 1.95118 13.8536 2.14645C14.0489 2.34171 14.0489 2.65829 13.8536 2.85355L3.70711 13H8.5Z " },
            { FluentSymbol.ArrowDownLeft20Filled, "M12.0007 16.2499C12.0007 16.6642 11.6649 17 11.2506 17H3.75006C3.33581 17 3 16.6642 3 16.2499V8.74927C3 8.33502 3.33581 7.9992 3.75006 7.9992C4.1643 7.9992 4.50011 8.33502 4.50011 8.74927V14.4391L15.7196 3.21969C16.0125 2.92677 16.4874 2.92677 16.7803 3.21969C17.0732 3.51261 17.0732 3.98753 16.7803 4.28045L5.56087 15.4999H11.2506C11.6649 15.4999 12.0007 15.8357 12.0007 16.2499Z " },
            { FluentSymbol.ArrowDownLeft20, "M11.5 16C11.7761 16 12 16.2239 12 16.5C12 16.7761 11.7761 17 11.5 17H3.5C3.22386 17 3 16.7761 3 16.5V8.5C3 8.22386 3.22386 8 3.5 8C3.77614 8 3.99999 8.22386 3.99999 8.5V15.2929L16.1465 3.14645C16.3417 2.95118 16.6583 2.95119 16.8536 3.14645C17.0488 3.34171 17.0488 3.65829 16.8536 3.85355L4.7071 16H11.5Z " },
            { FluentSymbol.ArrowDownLeft24Filled, "M4.99902 17.585L19.2912 3.29483C19.6817 2.90431 20.3149 2.90433 20.7054 3.29486C21.0659 3.65535 21.0936 4.22259 20.7886 4.61487L20.7054 4.70908L6.41302 19L11.5006 19.0005C12.0134 19.0005 12.4361 19.3865 12.4938 19.8839L12.5006 20.0005C12.5006 20.5133 12.1145 20.936 11.6172 20.9938L11.5006 21.0005L3.93962 20.9987L3.84404 20.9885L3.76739 20.9735L3.6899 20.9517L3.62087 20.9265L3.53078 20.8843L3.44123 20.8306L3.34976 20.7611L3.38227 20.7877C3.32046 20.7392 3.2645 20.6836 3.21563 20.6221L3.16451 20.5517L3.12575 20.4882L3.09275 20.4237L3.05896 20.3423L3.03384 20.2627L3.01034 20.1509L3.00299 20.0897L2.99902 20.0005V12.4966C2.99902 11.9443 3.44674 11.4966 3.99902 11.4966C4.51186 11.4966 4.93453 11.8826 4.9923 12.38L4.99902 12.4966V17.585L19.2912 3.29483L4.99902 17.585Z " },
            { FluentSymbol.ArrowDownLeft24, "M3.39449 20.9154C3.18657 20.8038 3.03898 20.6001 3.00534 20.3601L2.99805 20.2552V12.7513C2.99805 12.3371 3.33383 12.0013 3.74805 12.0013C4.12774 12.0013 4.44154 12.2835 4.4912 12.6495L4.49805 12.7513L4.49705 18.445L19.7192 3.21973C19.9854 2.95343 20.4021 2.92918 20.6957 3.147L20.7798 3.21961C21.0461 3.48584 21.0704 3.9025 20.8526 4.19614L20.78 4.28027L5.55805 19.505L11.2496 19.5052C11.6293 19.5052 11.9431 19.7873 11.9927 20.1534L11.9996 20.2552C11.9996 20.6349 11.7174 20.9487 11.3513 20.9983L11.2496 21.0052L3.6898 21.002C3.60705 20.9965 3.52867 20.9769 3.45611 20.9462L3.39449 20.9154Z " },
            { FluentSymbol.ArrowDownload16Filled, "M3.5 13H12.5C12.9142 13 13.25 13.3358 13.25 13.75C13.25 14.1297 12.9678 14.4435 12.6018 14.4932L12.5 14.5H3.5C3.08579 14.5 2.75 14.1642 2.75 13.75C2.75 13.3703 3.03215 13.0565 3.39823 13.0068L3.5 13H12.5H3.5ZM7.89823 1.00685L8 1C8.3797 1 8.69349 1.28215 8.74315 1.64823L8.75 1.75V9.438L11.0052 7.18414C11.2715 6.91787 11.6881 6.89366 11.9817 7.11152L12.0659 7.18414C12.3321 7.4504 12.3563 7.86707 12.1385 8.16068L12.0659 8.2448L8.53033 11.7803C8.26406 12.0466 7.8474 12.0708 7.55379 11.8529L7.46967 11.7803L3.93414 8.2448C3.64124 7.9519 3.64124 7.47703 3.93414 7.18414C4.2004 6.91787 4.61707 6.89366 4.91068 7.11152L4.9948 7.18414L7.25 9.44V1.75C7.25 1.3703 7.53215 1.05651 7.89823 1.00685L8 1L7.89823 1.00685Z " },
            { FluentSymbol.ArrowDownload16, "M3.5 13H12.5C12.7761 13 13 13.2239 13 13.5C13 13.7455 12.8231 13.9496 12.5899 13.9919L12.5 14H3.5C3.22386 14 3 13.7761 3 13.5C3 13.2545 3.17688 13.0504 3.41012 13.0081L3.5 13H12.5H3.5ZM7.91012 1.00806L8 1C8.24546 1 8.44961 1.17688 8.49194 1.41012L8.5 1.5V10.292L11.182 7.61091C11.3555 7.43735 11.625 7.41806 11.8198 7.55306L11.8891 7.61091C12.0627 7.78448 12.0819 8.0539 11.9469 8.24877L11.8891 8.31802L8.35355 11.8536C8.17999 12.0271 7.91056 12.0464 7.71569 11.9114L7.64645 11.8536L4.11091 8.31802C3.91565 8.12276 3.91565 7.80617 4.11091 7.61091C4.28448 7.43735 4.5539 7.41806 4.74877 7.55306L4.81802 7.61091L7.5 10.292V1.5C7.5 1.25454 7.67688 1.05039 7.91012 1.00806L8 1L7.91012 1.00806Z " },
            { FluentSymbol.ArrowDownload20Filled, "M15.2444 16.4972C15.6586 16.4972 15.9944 16.833 15.9944 17.2472C15.9944 17.6269 15.7123 17.9407 15.3462 17.9904L15.2444 17.9972H4.74976C4.33554 17.9972 3.99976 17.6614 3.99976 17.2472C3.99976 16.8675 4.28191 16.5537 4.64799 16.5041L4.74976 16.4972H15.2444ZM10.0034 1.99902C10.3831 1.99902 10.6969 2.28118 10.7465 2.64725L10.7534 2.74902L10.7528 12.942L13.719 9.97144C13.985 9.70493 14.4016 9.68034 14.6955 9.89792L14.7796 9.97046C15.0461 10.2365 15.0707 10.6531 14.8532 10.9469L14.7806 11.0311L10.5378 15.2818L10.4671 15.3443L10.3762 15.4029L10.3397 15.424L10.2486 15.462L10.1281 15.4921L10.0588 15.5L9.99876 15.5019C9.94864 15.5019 9.89776 15.4964 9.84804 15.4859L9.76716 15.4627C9.67115 15.4317 9.58404 15.3815 9.50989 15.3167L5.22032 11.032C4.92721 10.7393 4.92688 10.2644 5.21956 9.97133C5.48564 9.70487 5.90228 9.68037 6.19605 9.89802L6.28022 9.97057L9.25276 12.938L9.25338 2.74902C9.25338 2.33481 9.58917 1.99902 10.0034 1.99902Z " },
            { FluentSymbol.ArrowDownload20, "M15.5 16.9988C15.7761 16.9988 16 17.2226 16 17.4988C16 17.7442 15.8231 17.9484 15.5899 17.9907L15.5 17.9988H4.5C4.22386 17.9988 4 17.7749 4 17.4988C4 17.2533 4.17688 17.0492 4.41012 17.0068L4.5 16.9988H15.5ZM10.0001 2.00098C10.2456 2.00098 10.4497 2.17798 10.492 2.41124L10.5 2.50112L10.496 14.295L14.1414 10.6466C14.3148 10.4729 14.5842 10.4534 14.7792 10.5882L14.8485 10.646C15.0222 10.8194 15.0418 11.0888 14.907 11.2838L14.8492 11.3531L10.3574 15.8531C10.285 15.9257 10.1957 15.9714 10.1021 15.9901L9.99608 15.9999C9.83511 15.9999 9.69192 15.9237 9.60051 15.8056L5.14386 11.3537C4.94846 11.1586 4.94823 10.842 5.14336 10.6466C5.3168 10.4729 5.58621 10.4534 5.78117 10.5883L5.85046 10.6461L9.496 14.287L9.5 2.50083C9.50008 2.22469 9.724 2.00098 10.0001 2.00098Z " },
            { FluentSymbol.ArrowDownload24Filled, "M5.25 20.4995H18.7477C19.1619 20.4995 19.4977 20.8353 19.4977 21.2495C19.4977 21.6292 19.2155 21.943 18.8494 21.9927L18.7477 21.9995H5.25C4.83579 21.9995 4.5 21.6637 4.5 21.2495C4.5 20.8698 4.78215 20.556 5.14823 20.5064L5.25 20.4995H18.7477H5.25ZM11.8834 2.00185L12 1.99512C12.5128 1.99512 12.9355 2.38116 12.9933 2.8785L13 2.99512V15.5851L16.2941 12.2923C16.6546 11.9319 17.2218 11.9042 17.6141 12.2093L17.7083 12.2925C18.0687 12.653 18.0964 13.2202 17.7913 13.6125L17.7081 13.7067L12.7105 18.7033C12.3502 19.0636 11.7833 19.0914 11.391 18.7868L11.2968 18.7037L6.29338 13.7071C5.90259 13.3168 5.90215 12.6837 6.29241 12.2929C6.65265 11.9322 7.21986 11.904 7.61236 12.2088L7.70662 12.2919L11 15.5801V2.99512C11 2.48228 11.386 2.05961 11.8834 2.00185L12 1.99512L11.8834 2.00185Z " },
            { FluentSymbol.ArrowDownload24, "M18.2498 20.4999C18.664 20.4998 19 20.8355 19 21.2497C19 21.6639 18.6644 21.9998 18.2502 21.9999L5.25022 22.0037C4.836 22.0038 4.5 21.6681 4.5 21.2539C4.5 20.8397 4.83557 20.5038 5.24978 20.5037L18.2498 20.4999ZM11.6482 2.01173L11.75 2.00488C12.1297 2.00488 12.4435 2.28704 12.4932 2.65311L12.5 2.75488L12.499 16.4399L16.2208 12.7196C16.4871 12.4533 16.9038 12.4291 17.1974 12.647L17.2815 12.7197C17.5477 12.986 17.5719 13.4026 17.354 13.6962L17.2814 13.7803L12.2837 18.7769C12.0176 19.043 11.6012 19.0673 11.3076 18.8498L11.2235 18.7772L6.22003 13.7806C5.92694 13.4879 5.92661 13.0131 6.21931 12.72C6.48539 12.4535 6.90204 12.429 7.1958 12.6467L7.27997 12.7192L10.999 16.4329L11 2.75488C11 2.37519 11.2822 2.06139 11.6482 2.01173L11.75 2.00488L11.6482 2.01173Z " },
            { FluentSymbol.ArrowDownload48Filled, "M12.25 38.5H35.75C36.7165 38.5 37.5 39.2835 37.5 40.25C37.5 41.1682 36.7929 41.9212 35.8935 41.9942L35.75 42H12.25C11.2835 42 10.5 41.2165 10.5 40.25C10.5 39.3318 11.2071 38.5788 12.1065 38.5058L12.25 38.5H35.75H12.25ZM23.6065 6.2558L23.75 6.25C24.6682 6.25 25.4212 6.95711 25.4942 7.85647L25.5 8V29.333L30.2931 24.5407C30.9765 23.8573 32.0846 23.8573 32.768 24.5407C33.4514 25.2242 33.4514 26.3322 32.768 27.0156L24.9898 34.7938C24.3064 35.4772 23.1984 35.4772 22.515 34.7938L14.7368 27.0156C14.0534 26.3322 14.0534 25.2242 14.7368 24.5407C15.4202 23.8573 16.5282 23.8573 17.2117 24.5407L22 29.329V8C22 7.08183 22.7071 6.32881 23.6065 6.2558L23.75 6.25L23.6065 6.2558Z " },
            { FluentSymbol.ArrowDownload48, "M12.25 39.5H35.75C36.4404 39.5 37 40.0596 37 40.75C37 41.3972 36.5081 41.9295 35.8778 41.9935L35.75 42H12.25C11.5596 42 11 41.4404 11 40.75C11 40.1028 11.4919 39.5705 12.1222 39.5065L12.25 39.5H35.75H12.25ZM23.6222 6.00645L23.75 6C24.3972 6 24.9295 6.49187 24.9935 7.12219L25 7.25V31.54L30.6467 25.8943C31.1348 25.4061 31.9263 25.4061 32.4144 25.8943C32.9026 26.3824 32.9026 27.1739 32.4144 27.6621L24.6363 35.4402C24.1481 35.9284 23.3567 35.9284 22.8685 35.4402L15.0903 27.6621C14.6022 27.1739 14.6022 26.3824 15.0903 25.8943C15.5785 25.4061 16.3699 25.4061 16.8581 25.8943L22.5 31.536V7.25C22.5 6.60279 22.9919 6.07047 23.6222 6.00645L23.75 6L23.6222 6.00645Z " },
            { FluentSymbol.ArrowEnterUp20Filled, "M8.79615 2.23598C8.65442 2.08539 8.4568 2 8.25 2C8.0432 2 7.84558 2.08539 7.70385 2.23598L3.70385 6.48598C3.41996 6.78761 3.43435 7.26226 3.73598 7.54615C4.03761 7.83004 4.51226 7.81565 4.79615 7.51402L7.5 4.64119V14.75C7.5 16.5449 8.95507 18 10.75 18H15.25C15.6642 18 16 17.6642 16 17.25C16 16.8358 15.6642 16.5 15.25 16.5H10.75C9.7835 16.5 9 15.7165 9 14.75V4.64118L11.7039 7.51402C11.9877 7.81565 12.4624 7.83004 12.764 7.54615C13.0657 7.26226 13.08 6.78761 12.7962 6.48598L8.79615 2.23598Z " },
            { FluentSymbol.ArrowEnterUp20, "M8.86417 2.15732C8.76968 2.05693 8.63794 2 8.50007 2C8.36221 2 8.23046 2.05692 8.13597 2.15731L4.1359 6.40731C3.94664 6.6084 3.95623 6.92484 4.15732 7.1141C4.3584 7.30336 4.67484 7.29377 4.8641 7.09269L8 3.76085V15C8 16.6569 9.34315 18 11 18H15.5C15.7761 18 16 17.7761 16 17.5C16 17.2239 15.7761 17 15.5 17H11C9.89543 17 9 16.1046 9 15V3.76073L12.1359 7.09268C12.3252 7.29377 12.6416 7.30336 12.8427 7.1141C13.0438 6.92485 13.0534 6.60841 12.8641 6.40732L8.86417 2.15732Z " },
            { FluentSymbol.ArrowEnterUp24Filled, "M20 21C20 21.5128 19.614 21.9355 19.1166 21.9933L19 22L12.5 22C10.6314 22 9.10487 20.5357 9.00518 18.692L9 18.5L9 5.415L5.70711 8.70711C5.34662 9.06759 4.77939 9.09532 4.3871 8.79029L4.29289 8.70711C3.93241 8.34662 3.90468 7.77939 4.20971 7.3871L4.29289 7.29289L9.29289 2.29289C9.32829 2.2575 9.36567 2.22531 9.40469 2.19633L9.51594 2.12467L9.62866 2.07122L9.73401 2.03584L9.85153 2.01102L9.9102 2.00398L10 2L10.0752 2.00279L10.2007 2.02024L10.3121 2.04974L10.4232 2.09367L10.5207 2.14599L10.6129 2.2097L10.7071 2.29289L15.7071 7.29289C16.0976 7.68342 16.0976 8.31658 15.7071 8.70711C15.3466 9.06759 14.7794 9.09532 14.3871 8.7903L14.2929 8.70711L11 5.415L11 18.5C11 19.2797 11.5949 19.9204 12.3555 19.9931L12.5 20L19 20C19.5523 20 20 20.4477 20 21Z " },
            { FluentSymbol.ArrowEnterUp24, "M20 21.2496C20 21.6638 19.6642 21.9996 19.25 21.9996L12.75 21.9996C10.6789 21.9996 9 20.3206 9 18.2496L9 4.58541L5.28033 8.30474C5.01406 8.57101 4.5974 8.59522 4.30379 8.37736L4.21967 8.30474C3.9534 8.03848 3.9292 7.62181 4.14705 7.3282L4.21967 7.24408L9.21967 2.24408C9.48594 1.97782 9.9026 1.95361 10.1962 2.17147L10.2803 2.24408L15.2803 7.24408C15.5732 7.53698 15.5732 8.01185 15.2803 8.30474C15.0141 8.57101 14.5974 8.59522 14.3038 8.37736L14.2197 8.30474L10.5 4.58541L10.5 18.2496C10.5 19.4404 11.4252 20.4152 12.596 20.4944L12.75 20.4996L19.25 20.4996C19.6642 20.4996 20 20.8354 20 21.2496Z " },
            { FluentSymbol.ArrowExpand24Filled, "M7.66873 14.9229C8.05925 14.5324 8.69242 14.5324 9.08294 14.9229C9.47347 15.3134 9.47347 15.9466 9.08294 16.3371L6.415 19.0042H8C8.51284 19.0042 8.93551 19.3903 8.99327 19.8876L9 20.0042C9 20.5565 8.55228 21.0042 8 21.0042H4C3.44772 21.0042 3 20.5565 3 20.0042V16.0042C3 15.4519 3.44772 15.0042 4 15.0042C4.55228 15.0042 5 15.4519 5 16.0042V17.5912L7.66873 14.9229ZM16.005 21.0042C15.4527 21.0042 15.005 20.5565 15.005 20.0042C15.005 19.4519 15.4527 19.0042 16.005 19.0042H17.588L14.9226 16.3368C14.5623 15.9762 14.5348 15.409 14.8399 15.0168L14.9232 14.9226C15.3138 14.5322 15.947 14.5325 16.3374 14.9232L19.005 17.5932V16.0042C19.005 15.4914 19.3911 15.0687 19.8884 15.0109L20.005 15.0042C20.5573 15.0042 21.005 15.4519 21.005 16.0042V20.0042C21.005 20.5565 20.5573 21.0042 20.005 21.0042H16.005ZM8 3C8.55228 3 9 3.44772 9 4C9 4.55228 8.55228 5 8 5H6.417L9.08239 7.66817C9.44273 8.0288 9.47023 8.59604 9.16505 8.98821L9.08183 9.08239C8.69115 9.47276 8.05799 9.47251 7.66762 9.08183L5 6.412V8C5 8.51284 4.61396 8.93551 4.11662 8.99327L4 9C3.44772 9 3 8.55228 3 8V4C3 3.44772 3.44772 3 4 3H8ZM20.005 3C20.5573 3 21.005 3.44772 21.005 4V8C21.005 8.55228 20.5573 9 20.005 9C19.4527 9 19.005 8.55228 19.005 8V6.412L16.3372 9.08196C15.9768 9.44252 15.4096 9.47037 15.0173 9.16542L14.923 9.08225C14.5324 8.6918 14.5323 8.05864 14.9228 7.66804L17.589 5H16.005C15.4922 5 15.0695 4.61396 15.0117 4.11662L15.005 4C15.005 3.44772 15.4527 3 16.005 3H20.005Z " },
            { FluentSymbol.ArrowExpand24, "M7.59551 15.3497C7.8884 15.0568 8.36327 15.0568 8.65617 15.3497C8.94906 15.6426 8.94906 16.1174 8.65617 16.4103L5.561 19.5042H7.75C8.1297 19.5042 8.44349 19.7864 8.49315 20.1524L8.5 20.2542C8.5 20.6684 8.16421 21.0042 7.75 21.0042H3.75C3.33579 21.0042 3 20.6684 3 20.2542V16.2542C3 15.84 3.33579 15.5042 3.75 15.5042C4.16421 15.5042 4.5 15.84 4.5 16.2542V18.4432L7.59551 15.3497ZM16.255 21.0042C15.8408 21.0042 15.505 20.6684 15.505 20.2542C15.505 19.84 15.8408 19.5042 16.255 19.5042H18.441L15.3495 16.4101C15.0833 16.1438 15.0593 15.7271 15.2772 15.4336L15.3499 15.3495C15.6429 15.0567 16.1178 15.0569 16.4105 15.3499L19.505 18.4462V16.2542C19.505 15.8745 19.7872 15.5607 20.1532 15.5111L20.255 15.5042C20.6692 15.5042 21.005 15.84 21.005 16.2542V20.2542C21.005 20.6684 20.6692 21.0042 20.255 21.0042H16.255ZM7.75 3C8.16421 3 8.5 3.33579 8.5 3.75C8.5 4.16421 8.16421 4.5 7.75 4.5H5.563L8.65554 7.59488C8.9217 7.86125 8.94574 8.27792 8.72777 8.57145L8.65512 8.65554C8.36211 8.94832 7.88724 8.94813 7.59446 8.65512L4.5 5.558V7.75C4.5 8.1297 4.21785 8.44349 3.85177 8.49315L3.75 8.5C3.33579 8.5 3 8.16421 3 7.75V3.75C3 3.33579 3.33579 3 3.75 3H7.75ZM20.255 3C20.6692 3 21.005 3.33579 21.005 3.75V7.75C21.005 8.16421 20.6692 8.5 20.255 8.5C19.8408 8.5 19.505 8.16421 19.505 7.75V5.559L16.4104 8.65522C16.1442 8.92154 15.7276 8.94583 15.4339 8.72804L15.3498 8.65544C15.0568 8.3626 15.0567 7.88773 15.3496 7.59478L18.442 4.5H16.255C15.8753 4.5 15.5615 4.21785 15.5118 3.85177L15.505 3.75C15.505 3.33579 15.8408 3 16.255 3H20.255Z " },
            { FluentSymbol.ArrowExportRTL20Filled, "M17.25 3.75C16.8358 3.75 16.5 4.08579 16.5 4.5V15.5C16.5 15.9142 16.8358 16.25 17.25 16.25C17.6642 16.25 18 15.9142 18 15.5V4.5C18 4.08579 17.6642 3.75 17.25 3.75Z M15 10C15 9.58579 14.6642 9.25 14.25 9.25H4.06068L6.7803 6.53033C7.0732 6.23744 7.0732 5.76256 6.7803 5.46967C6.4874 5.17678 6.0126 5.17678 5.7197 5.46967L1.72302 9.46634C1.71086 9.47836 1.6991 9.49079 1.68777 9.50361C1.63743 9.56051 1.59722 9.62323 1.56713 9.68943C1.52402 9.78406 1.5 9.88923 1.5 10C1.5 10.1122 1.52465 10.2187 1.56884 10.3143C1.59812 10.3778 1.63674 10.438 1.68471 10.4929C1.69709 10.5071 1.70999 10.5208 1.72339 10.534L5.7197 14.5303C6.0126 14.8232 6.4874 14.8232 6.7803 14.5303C7.0732 14.2374 7.0732 13.7626 6.7803 13.4697L4.06068 10.75H14.25C14.6642 10.75 15 10.4142 15 10Z " },
            { FluentSymbol.ArrowExportRTL20, "M17.5 4C17.2239 4 17 4.22386 17 4.5V15.5C17 15.7761 17.2239 16 17.5 16C17.7761 16 18 15.7761 18 15.5V4.5C18 4.22386 17.7761 4 17.5 4Z M15 10C15 9.72386 14.7761 9.5 14.5 9.5H3.70711L6.8536 6.35355C7.0488 6.15829 7.0488 5.84171 6.8536 5.64645C6.6583 5.45118 6.3417 5.45118 6.1464 5.64645L2.1464 9.64645C2.09389 9.69898 2.05551 9.76028 2.03125 9.82563C2.01104 9.87992 2 9.93867 2 10C2 10.0613 2.01104 10.1201 2.03125 10.1744C2.05551 10.2397 2.09389 10.301 2.1464 10.3536L6.1464 14.3536C6.3417 14.5488 6.6583 14.5488 6.8536 14.3536C7.0488 14.1583 7.0488 13.8417 6.8536 13.6465L3.7071 10.5H14.5C14.7761 10.5 15 10.2761 15 10Z " },
            { FluentSymbol.ArrowForward16Filled, "M10.2459 3.68451L13.7814 7.22005C14.0743 7.51294 14.0743 7.98781 13.7814 8.28071L10.2459 11.8162C9.95297 12.1091 9.4781 12.1091 9.1852 11.8162C8.89231 11.5233 8.89231 11.0485 9.1852 10.7556L11.44 8.49984L2.75 8.50038C2.3703 8.50038 2.05651 8.21822 2.00685 7.85215L2 7.75038C2 7.33616 2.33579 7.00038 2.75 7.00038L11.44 6.99984L9.1852 4.74517C8.89231 4.45228 8.89231 3.97741 9.1852 3.68451C9.4781 3.39162 9.95297 3.39162 10.2459 3.68451Z " },
            { FluentSymbol.ArrowForward16, "M10.318 3.61129L13.8536 7.14682C14.0488 7.34209 14.0488 7.65867 13.8536 7.85393L10.318 11.3895C10.1228 11.5847 9.80617 11.5847 9.61091 11.3895C9.41565 11.1942 9.41565 10.8776 9.61091 10.6824L12.292 7.99984L2.5 8.00038C2.25454 8.00038 2.05039 7.8235 2.00806 7.59025L2 7.50038C2 7.25492 2.17688 7.05077 2.41012 7.00843L2.5 7.00038L12.292 6.99984L9.61091 4.3184C9.41565 4.12313 9.41565 3.80655 9.61091 3.61129C9.80617 3.41603 10.1228 3.41603 10.318 3.61129Z " },
            { FluentSymbol.ArrowForward20Filled, "M12.3997 5.3116L12.4723 5.22748C12.7386 4.96122 13.1552 4.93701 13.4489 5.15486L13.533 5.22748L17.7756 9.47012C18.0419 9.73639 18.0661 10.1531 17.8482 10.4467L17.7756 10.5308L13.533 14.7734C13.2401 15.0663 12.7652 15.0663 12.4723 14.7734C12.206 14.5072 12.1818 14.0905 12.3997 13.7969L12.4723 13.7128L15.434 10.7498L2.75 10.7505C2.3703 10.7505 2.05651 10.4683 2.00685 10.1022L2 10.0005C2 9.62076 2.28215 9.30696 2.64823 9.2573L2.75 9.25045L15.434 9.24981L12.4723 6.28814C12.206 6.02188 12.1818 5.60521 12.3997 5.3116L12.4723 5.22748L12.3997 5.3116Z " },
            { FluentSymbol.ArrowForward20, "M12.846 5.47351L12.9038 5.40426C13.0774 5.23069 13.3468 5.21141 13.5417 5.3464L13.6109 5.40426L17.8824 9.67833L17.9112 9.71579L17.9533 9.78916L17.9762 9.84755L17.9889 9.89521L18 10.0005L17.9921 10.0893L17.9695 10.1729L17.9458 10.2271L17.9207 10.2708L17.8836 10.3212L17.8536 10.354L13.6109 14.5966C13.4157 14.7919 13.0991 14.7919 12.9038 14.5966C12.7302 14.4231 12.711 14.1537 12.846 13.9588L12.9038 13.8895L16.292 10.4998L2.5 10.5005C2.25454 10.5005 2.05039 10.3236 2.00806 10.0903L2 10.0005C2 9.75499 2.17688 9.55084 2.41012 9.50851L2.5 9.50045L16.292 9.49981L12.9038 6.11137C12.7302 5.9378 12.711 5.66838 12.846 5.47351L12.9038 5.40426L12.846 5.47351Z " },
            { FluentSymbol.ArrowForward24Filled, "M14.2098 6.38702L14.293 6.29282C14.6535 5.93237 15.2207 5.9047 15.613 6.20977L15.7072 6.29297L20.7038 11.2906C21.064 11.6509 21.0919 12.2178 20.7873 12.6101L20.7042 12.7043L15.7076 17.7077C15.3173 18.0985 14.6842 18.0989 14.2934 17.7087C13.9327 17.3484 13.9045 16.7812 14.2093 16.3887L14.2924 16.2945L17.581 13H4C3.48716 13 3.06449 12.614 3.00673 12.1166L3 12C3 11.4872 3.38604 11.0645 3.88338 11.0067L4 11H17.584L14.2928 7.70703C13.9324 7.34651 13.9047 6.77928 14.2098 6.38702L14.293 6.29282L14.2098 6.38702Z " },
            { FluentSymbol.ArrowForward24, "M14.6469 6.30373L14.7195 6.21961C14.9858 5.95338 15.4025 5.92921 15.6961 6.1471L15.7802 6.21972L20.7768 11.2174C21.0429 11.4835 21.0672 11.8999 20.8496 12.1935L20.7771 12.2776L15.7805 17.2811C15.4878 17.5742 15.0129 17.5745 14.7198 17.2818C14.4534 17.0157 14.4289 16.5991 14.6465 16.3053L14.7191 16.2211L18.43 12.504L3.75 12.5049C3.3703 12.5049 3.05651 12.2228 3.00685 11.8567L3 11.7549C3 11.3752 3.28215 11.0615 3.64823 11.0118L3.75 11.0049L18.443 11.004L14.7194 7.28028C14.4532 7.01398 14.429 6.59732 14.6469 6.30373L14.7195 6.21961L14.6469 6.30373Z " },
            { FluentSymbol.ArrowHookDownLeft16Filled, "M5 4.75C5 4.33579 5.33579 4 5.75 4H8.74999C9.93183 4 10.8831 4.4115 11.5384 5.08727C12.1852 5.75422 12.5 6.63406 12.5 7.5C12.5 8.36594 12.1852 9.24578 11.5384 9.91273C10.8831 10.5885 9.93183 11 8.75 11H5.56066L6.28033 11.7197C6.57322 12.0126 6.57322 12.4874 6.28033 12.7803C5.98744 13.0732 5.51256 13.0732 5.21967 12.7803L3.21967 10.7803C2.92678 10.4874 2.92678 10.0126 3.21967 9.71967L5.21967 7.71967C5.51256 7.42678 5.98744 7.42678 6.28033 7.71967C6.57322 8.01256 6.57322 8.48744 6.28033 8.78033L5.56066 9.5H8.75C9.56817 9.5 10.1169 9.224 10.4616 8.86852C10.8148 8.50422 11 8.00906 11 7.5C11 6.99094 10.8148 6.49578 10.4616 6.13148C10.1169 5.776 9.56816 5.5 8.74999 5.5H5.75C5.33579 5.5 5 5.16421 5 4.75Z " },
            { FluentSymbol.ArrowHookDownLeft16, "M5 4.5C5 4.22386 5.22386 4 5.5 4H8.5C9.63568 4 10.5242 4.43085 11.1237 5.10532C11.7151 5.77058 12 6.64346 12 7.5C12 8.35653 11.7151 9.22942 11.1237 9.89468C10.5242 10.5691 9.63568 11 8.50001 11H4.70711L5.85355 12.1464C6.04882 12.3417 6.04882 12.6583 5.85355 12.8536C5.65829 13.0488 5.34171 13.0488 5.14645 12.8536L3.14645 10.8536C2.95118 10.6583 2.95118 10.3417 3.14645 10.1464L5.14645 8.14645C5.34171 7.95118 5.65829 7.95118 5.85355 8.14645C6.04882 8.34171 6.04882 8.65829 5.85355 8.85355L4.70711 10H8.50001C9.36433 10 9.97582 9.68085 10.3763 9.23032C10.785 8.77058 11 8.14347 11 7.5C11 6.85654 10.7849 6.22942 10.3763 5.76968C9.97582 5.31915 9.36432 5 8.5 5H5.5C5.22386 5 5 4.77614 5 4.5Z " },
            { FluentSymbol.ArrowHookDownLeft20, "M6 4.5C6 4.22386 6.22386 4 6.5 4H11C12.6357 4 13.8992 4.61835 14.7487 5.57407C15.5901 6.52058 16 7.76846 16 9C16 10.2315 15.5901 11.4794 14.7487 12.4259C13.8992 13.3816 12.6357 14 11 14H5.70711L8.35355 16.6464C8.54882 16.8417 8.54882 17.1583 8.35355 17.3536C8.15829 17.5488 7.84171 17.5488 7.64645 17.3536L4.14645 13.8536C3.95118 13.6583 3.95118 13.3417 4.14645 13.1464L7.64645 9.64645C7.84171 9.45118 8.15829 9.45118 8.35355 9.64645C8.54882 9.84171 8.54882 10.1583 8.35355 10.3536L5.70711 13H11C12.3643 13 13.3508 12.4934 14.0013 11.7616C14.6599 11.0206 15 10.0185 15 9C15 7.98153 14.6599 6.97942 14.0013 6.23843C13.3508 5.50665 12.3643 5 11 5H6.5C6.22386 5 6 4.77614 6 4.5Z " },
            { FluentSymbol.ArrowHookDownLeft24Filled, "M7 5C7 4.44772 7.44772 4 8 4H13C15.2424 4 17.0109 4.77783 18.2179 6.0226C19.4136 7.25563 20 8.88708 20 10.5C20 12.1129 19.4136 13.7444 18.2179 14.9774C17.0109 16.2222 15.2424 17 13 17H8.41421L10.4571 19.0429C10.8476 19.4334 10.8476 20.0666 10.4571 20.4571C10.0666 20.8476 9.43342 20.8476 9.04289 20.4571L5.29289 16.7071C4.90237 16.3166 4.90237 15.6834 5.29289 15.2929L9.04289 11.5429C9.43342 11.1524 10.0666 11.1524 10.4571 11.5429C10.8476 11.9334 10.8476 12.5666 10.4571 12.9571L8.41421 15H13C14.7576 15 15.9892 14.4028 16.7821 13.5851C17.5864 12.7556 18 11.6371 18 10.5C18 9.36292 17.5864 8.24437 16.7821 7.4149C15.9891 6.59717 14.7576 6 13 6H8C7.44772 6 7 5.55228 7 5Z " },
            { FluentSymbol.ArrowHookDownLeft24, "M7 4.75C7 4.33579 7.33579 4 7.75 4H14C15.9786 4 17.5041 4.82266 18.5198 6.07425C19.5207 7.30739 20 8.9201 20 10.5C20 12.0799 19.5207 13.6926 18.5198 14.9258C17.5041 16.1773 15.9786 17 14 17H7.56066L10.0303 19.4697C10.3232 19.7626 10.3232 20.2374 10.0303 20.5303C9.73744 20.8232 9.26256 20.8232 8.96967 20.5303L5.21967 16.7803C4.92678 16.4874 4.92678 16.0126 5.21967 15.7197L8.96967 11.9697C9.26256 11.6768 9.73744 11.6768 10.0303 11.9697C10.3232 12.2626 10.3232 12.7374 10.0303 13.0303L7.56066 15.5H14C15.5214 15.5 16.6209 14.8852 17.3552 13.9805C18.1043 13.0574 18.5 11.7951 18.5 10.5C18.5 9.2049 18.1043 7.94261 17.3552 7.0195C16.6209 6.11484 15.5214 5.5 14 5.5H7.75C7.33579 5.5 7 5.16421 7 4.75Z " },
            { FluentSymbol.ArrowHookDownLeft28, "M8 6.75C8 6.33579 8.33578 6 8.75 6H15.75C18.0865 6 20.0117 6.78107 21.25 8.01578C22.4814 9.2436 23 10.8763 23 12.5C23 14.1237 22.4814 15.7564 21.25 16.9842C20.0117 18.2189 18.0865 19 15.75 19H7.56066L10.7803 22.2197C11.0732 22.5126 11.0732 22.9874 10.7803 23.2803C10.4874 23.5732 10.0126 23.5732 9.71967 23.2803L5.21967 18.7803C5.07902 18.6397 5 18.4489 5 18.25C5 18.0511 5.07902 17.8603 5.21967 17.7197L9.71967 13.2197C10.0126 12.9268 10.4874 12.9268 10.7803 13.2197C11.0732 13.5126 11.0732 13.9874 10.7803 14.2803L7.56066 17.5H15.75C17.7385 17.5 19.1758 16.8436 20.1 15.922C21.0311 14.9936 21.5 13.7513 21.5 12.5C21.5 11.2487 21.0311 10.0064 20.1 9.07797C19.1758 8.15643 17.7385 7.5 15.75 7.5H8.75C8.33578 7.5 8 7.16421 8 6.75Z " },
            { FluentSymbol.ArrowHookDownLeft20Filled, "M6 4.75C6 4.33579 6.33579 4 6.75 4H11.25C12.8365 4 13.9458 4.62123 14.78 5.5882C15.6009 6.53973 16 7.78364 16 9C16 10.2164 15.7009 11.4603 14.88 12.4118C14.0458 13.3788 12.8365 14 11.25 14H6.56066L8.78033 16.2197C9.07322 16.5126 9.07322 16.9874 8.78033 17.2803C8.48744 17.5732 8.01256 17.5732 7.71967 17.2803L4.21967 13.7803C4.07561 13.6363 3.99636 13.4398 4.00013 13.2361C4.0039 13.0324 4.09037 12.839 4.23966 12.7004L7.73966 9.4504C8.04319 9.16855 8.51774 9.18613 8.7996 9.48966C9.08145 9.79319 9.06387 10.2677 8.76034 10.5496L6.6599 12.5H11.25C12.4135 12.5 13.1092 12.0587 13.65 11.432C14.2041 10.7897 14.5 9.90864 14.5 9C14.5 8.09136 14.2041 7.21027 13.65 6.56805C13.1092 5.94127 12.4135 5.5 11.25 5.5H6.75C6.33579 5.5 6 5.16421 6 4.75Z " },
            { FluentSymbol.ArrowHookDownLeft28Filled, "M21.2179 8.02261C20.0109 6.77783 18.2425 6 16 6H9.00002C8.44773 6 8.00002 6.44772 8.00002 7C8.00002 7.55228 8.44773 8 9.00002 8H16C17.7576 8 18.9892 8.59717 19.7821 9.41489C20.5864 10.2444 21 11.3629 21 12.5C21 13.6371 20.5864 14.7556 19.7821 15.5851C18.9892 16.4028 17.7576 17 16 17H8.41422L11.7071 13.7071C12.0977 13.3166 12.0977 12.6834 11.7071 12.2929C11.3166 11.9024 10.6834 11.9024 10.2929 12.2929L5.29289 17.2929C5.10536 17.4804 5 17.7348 5 18C5 18.2652 5.10536 18.5196 5.29289 18.7071L10.2929 23.7071C10.6834 24.0976 11.3166 24.0976 11.7071 23.7071C12.0977 23.3166 12.0977 22.6834 11.7071 22.2929L8.41422 19H16C18.2425 19 20.0109 18.2222 21.2179 16.9774C22.4136 15.7444 23 14.1129 23 12.5C23 10.8871 22.4136 9.25563 21.2179 8.02261Z " },
            { FluentSymbol.ArrowHookDownRight16Filled, "M4.46157 5.08727C5.11686 4.4115 6.06816 4 7.24999 4H10.25C10.6642 4 11 4.33579 11 4.75C11 5.16421 10.6642 5.5 10.25 5.5H7.24999C6.43183 5.5 5.88313 5.776 5.53842 6.13148C5.18517 6.49578 5 6.99094 5 7.5C5 8.00906 5.18517 8.50422 5.53843 8.86852C5.88314 9.224 6.43183 9.5 7.24999 9.5H10.4393L9.71967 8.78033C9.42678 8.48744 9.42678 8.01256 9.71967 7.71967C10.0126 7.42678 10.4874 7.42678 10.7803 7.71967L12.7803 9.71967C13.0732 10.0126 13.0732 10.4874 12.7803 10.7803L10.7803 12.7803C10.4874 13.0732 10.0126 13.0732 9.71967 12.7803C9.42678 12.4874 9.42678 12.0126 9.71967 11.7197L10.4393 11H7.24999C6.06816 11 5.11686 10.5885 4.46157 9.91273C3.81483 9.24578 3.5 8.36594 3.5 7.5C3.5 6.63406 3.81483 5.75422 4.46157 5.08727Z " },
            { FluentSymbol.ArrowHookDownRight16, "M4.87629 5.10532C5.47582 4.43085 6.36432 4 7.49999 4H10.5C10.7761 4 11 4.22386 11 4.5C11 4.77614 10.7761 5 10.5 5H7.49999C6.63567 5 6.02418 5.31915 5.6237 5.76968C5.21505 6.22942 5 6.85653 5 7.5C5 8.14346 5.21505 8.77058 5.62371 9.23032C6.02418 9.68085 6.63569 10 7.50001 10H11.2929L10.1465 8.85355C9.95121 8.65829 9.95122 8.3417 10.1465 8.14644C10.3417 7.95118 10.6583 7.95119 10.8536 8.14645L12.8536 10.1464C13.0488 10.3417 13.0488 10.6583 12.8536 10.8536L10.8536 12.8536C10.6583 13.0488 10.3417 13.0488 10.1465 12.8536C9.95122 12.6583 9.95121 12.3417 10.1465 12.1465L11.2929 11H7.50001C6.36433 11 5.47583 10.5691 4.8763 9.89468C4.28495 9.22942 4 8.35654 4 7.5C4 6.64347 4.28495 5.77058 4.87629 5.10532Z " },
            { FluentSymbol.ArrowHookDownRight20Filled, "M9 14C9.06037 14 8.94015 14.0021 9 14C9.02294 14.0021 9.22651 14 9.25 14H13.6434L11.3754 16.268C11.0825 16.5609 11.0825 17.0357 11.3754 17.3286C11.6683 17.6215 12.1432 17.6215 12.4361 17.3286L15.789 13.9757C15.963 13.8017 16.0337 13.5634 16.0009 13.3372C15.9821 13.1751 15.9106 13.0179 15.7862 12.8935L12.5391 9.64643C12.2462 9.35353 11.7714 9.35353 11.4785 9.64643C11.1856 9.93932 11.1856 10.4142 11.4785 10.7071L13.2714 12.5H9C7.067 12.5 5.5 10.933 5.5 9C5.5 7.067 7.067 5.5 9 5.5H13.25C13.6642 5.5 14 5.16421 14 4.75C14 4.33579 13.6642 4 13.25 4H9.25C9.22651 4 9 4 9 4C6.23858 4 4 6.23858 4 9C4 11.7614 6.23858 14 9 14Z " },
            { FluentSymbol.ArrowHookDownRight20, "M4 9C4 6.23858 6.23858 4 9 4H13.5C13.7761 4 14 4.22386 14 4.5C14 4.77614 13.7761 5 13.5 5H9C6.79086 5 5 6.79086 5 9C5 11.2091 6.79086 13 9 13H14.293L11.5938 10.3008C11.3985 10.1056 11.3985 9.78897 11.5938 9.59371C11.7891 9.39845 12.1056 9.39845 12.3009 9.59371L15.8399 13.1327C15.9744 13.2673 16.0163 13.4594 15.9654 13.6298C15.9457 13.7203 15.9007 13.8064 15.8304 13.8768L12.297 17.4102C12.1017 17.6054 11.7851 17.6054 11.5899 17.4102C11.3946 17.2149 11.3946 16.8983 11.5899 16.703L14.2929 14H9C6.23858 14 4 11.7614 4 9Z " },
            { FluentSymbol.ArrowHookDownRight24Filled, "M10.5 6H16C16.5523 6 17 5.55228 17 5C17 4.44772 16.5523 4 16 4H10.5C6.91015 4 4 6.91015 4 10.5C4 14.0899 6.91015 17 10.5 17H15.6401L13.7072 18.9329C13.3167 19.3234 13.3167 19.9566 13.7072 20.3471C14.0977 20.7376 14.7309 20.7376 15.1214 20.3471L18.6502 16.8183C18.7418 16.7267 18.812 16.6217 18.8606 16.5096C18.9492 16.3604 19 16.1861 19 16C19 15.7103 18.8768 15.4494 18.68 15.2668C18.6711 15.2572 18.662 15.2477 18.6526 15.2383L15.1215 11.7072C14.731 11.3167 14.0978 11.3167 13.7073 11.7072C13.3168 12.0977 13.3168 12.7309 13.7073 13.1214L15.5859 15H10.5C8.01472 15 6 12.9853 6 10.5C6 8.01472 8.01472 6 10.5 6Z " },
            { FluentSymbol.ArrowHookDownRight24, "M10.5 5.5H16C16.4142 5.5 16.75 5.16421 16.75 4.75C16.75 4.33579 16.4142 4 16 4H10.5C6.91015 4 4 6.91015 4 10.5C4 14.0899 6.91015 17 10.5 17H16.4503L13.8336 19.6168C13.5407 19.9097 13.5407 20.3845 13.8336 20.6774C14.1264 20.9703 14.6013 20.9703 14.8942 20.6774L18.7765 16.7951C18.8762 16.6955 18.9419 16.5748 18.9738 16.4473C18.9909 16.3845 19 16.3183 19 16.25C19 16.0371 18.9113 15.8449 18.7688 15.7084L14.8887 11.8283C14.5958 11.5354 14.121 11.5354 13.8281 11.8283C13.5352 12.1212 13.5352 12.5961 13.8281 12.889L16.4391 15.5H10.5C7.73858 15.5 5.5 13.2614 5.5 10.5C5.5 7.73858 7.73858 5.5 10.5 5.5Z " },
            { FluentSymbol.ArrowHookDownRight28, "M6.84 8.01578C8.07829 6.78107 9.91348 6 12.25 6H19.25C19.6642 6 20 6.33579 20 6.75C20 7.16421 19.6642 7.5 19.25 7.5H12.25C10.2615 7.5 8.82421 8.15643 7.9 9.07797C6.96888 10.0064 6.5 11.2487 6.5 12.5C6.5 13.7513 6.96888 14.9936 7.9 15.922C8.82421 16.8436 10.2615 17.5 12.25 17.5H20.4393L17.2197 14.2803C16.9268 13.9874 16.9268 13.5126 17.2197 13.2197C17.5126 12.9268 17.9874 12.9268 18.2803 13.2197L22.7803 17.7197C22.921 17.8603 23 18.0511 23 18.25C23 18.4489 22.921 18.6397 22.7803 18.7803L18.2803 23.2803C17.9874 23.5732 17.5126 23.5732 17.2197 23.2803C16.9268 22.9874 16.9268 22.5126 17.2197 22.2197L20.4393 19H12.25C9.91348 19 8.07829 18.2189 6.84 16.9842C5.60862 15.7564 5 14.1237 5 12.5C5 10.8763 5.60862 9.2436 6.84 8.01578Z " },
            { FluentSymbol.ArrowHookDownRight28Filled, "M6.78209 8.02261C7.98914 6.77783 9.75754 6 12 6H19C19.5523 6 20 6.44772 20 7C20 7.55228 19.5523 8 19 8H12C10.2424 8 9.01084 8.59717 8.2179 9.41489C7.41356 10.2444 7 11.3629 7 12.5C7 13.6371 7.41356 14.7556 8.2179 15.5851C9.01085 16.4028 10.2424 17 12 17H19.5858L16.2929 13.7071C15.9023 13.3166 15.9023 12.6834 16.2929 12.2929C16.6834 11.9024 17.3166 11.9024 17.7071 12.2929L22.7071 17.2929C22.8946 17.4804 23 17.7348 23 18C23 18.2652 22.8946 18.5196 22.7071 18.7071L17.7071 23.7071C17.3166 24.0976 16.6834 24.0976 16.2929 23.7071C15.9023 23.3166 15.9023 22.6834 16.2929 22.2929L19.5858 19H12C9.75755 19 7.98915 18.2222 6.7821 16.9774C5.58644 15.7444 5 14.1129 5 12.5C5 10.8871 5.58644 9.25563 6.78209 8.02261Z " },
            { FluentSymbol.ArrowHookUpLeft16Filled, "M5 11.25C5 11.6642 5.33579 12 5.75 12H8.74999C9.93183 12 10.8831 11.5885 11.5384 10.9127C12.1852 10.2458 12.5 9.36594 12.5 8.5C12.5 7.63406 12.1852 6.75422 11.5384 6.08727C10.8831 5.4115 9.93183 5 8.75 5H5.56066L6.28033 4.28033C6.57322 3.98744 6.57322 3.51256 6.28033 3.21967C5.98744 2.92678 5.51256 2.92678 5.21967 3.21967L3.21967 5.21967C2.92678 5.51256 2.92678 5.98744 3.21967 6.28033L5.21967 8.28033C5.51256 8.57322 5.98744 8.57322 6.28033 8.28033C6.57322 7.98744 6.57322 7.51256 6.28033 7.21967L5.56066 6.5H8.75C9.56817 6.5 10.1169 6.776 10.4616 7.13148C10.8148 7.49578 11 7.99094 11 8.5C11 9.00906 10.8148 9.50422 10.4616 9.86852C10.1169 10.224 9.56816 10.5 8.74999 10.5H5.75C5.33579 10.5 5 10.8358 5 11.25Z " },
            { FluentSymbol.ArrowHookUpLeft16, "M5 11.5C5 11.7761 5.22386 12 5.5 12H8.5C9.63568 12 10.5242 11.5691 11.1237 10.8947C11.7151 10.2294 12 9.35654 12 8.5C12 7.64347 11.7151 6.77058 11.1237 6.10532C10.5242 5.43085 9.63568 5 8.50001 5H4.70711L5.85355 3.85355C6.04882 3.65829 6.04882 3.34171 5.85355 3.14645C5.65829 2.95118 5.34171 2.95118 5.14645 3.14645L3.14645 5.14645C2.95118 5.34171 2.95118 5.65829 3.14645 5.85355L5.14645 7.85355C5.34171 8.04882 5.65829 8.04882 5.85355 7.85355C6.04882 7.65829 6.04882 7.34171 5.85355 7.14645L4.70711 6H8.50001C9.36433 6 9.97582 6.31915 10.3763 6.76968C10.785 7.22942 11 7.85653 11 8.5C11 9.14346 10.7849 9.77058 10.3763 10.2303C9.97582 10.6809 9.36432 11 8.5 11H5.5C5.22386 11 5 11.2239 5 11.5Z " },
            { FluentSymbol.ArrowHookUpLeft20, "M6 15.5C6 15.7761 6.22386 16 6.5 16H11C12.6357 16 13.8992 15.3816 14.7487 14.4259C15.5901 13.4794 16 12.2315 16 11C16 9.76847 15.5901 8.52058 14.7487 7.57407C13.8992 6.61835 12.6357 6 11 6H5.70711L8.35355 3.35355C8.54882 3.15829 8.54882 2.84171 8.35355 2.64645C8.15829 2.45118 7.84171 2.45118 7.64645 2.64645L4.14645 6.14645C3.95118 6.34171 3.95118 6.65829 4.14645 6.85355L7.64645 10.3536C7.84171 10.5488 8.15829 10.5488 8.35355 10.3536C8.54882 10.1583 8.54882 9.84171 8.35355 9.64645L5.70711 7H11C12.3643 7 13.3508 7.50665 14.0013 8.23843C14.6599 8.97942 15 9.98154 15 11C15 12.0185 14.6599 13.0206 14.0013 13.7616C13.3508 14.4934 12.3643 15 11 15H6.5C6.22386 15 6 15.2239 6 15.5Z " },
            { FluentSymbol.ArrowHookUpLeft24Filled, "M7 19C7 19.5523 7.44772 20 8 20H13C15.2424 20 17.0109 19.2222 18.2179 17.9774C19.4136 16.7444 20 15.1129 20 13.5C20 11.8871 19.4136 10.2556 18.2179 9.0226C17.0109 7.77783 15.2424 7 13 7H8.41421L10.4571 4.95711C10.8476 4.56658 10.8476 3.93342 10.4571 3.54289C10.0666 3.15237 9.43342 3.15237 9.04289 3.54289L5.29289 7.29289C4.90237 7.68342 4.90237 8.31658 5.29289 8.70711L9.04289 12.4571C9.43342 12.8476 10.0666 12.8476 10.4571 12.4571C10.8476 12.0666 10.8476 11.4334 10.4571 11.0429L8.41421 9H13C14.7576 9 15.9892 9.59717 16.7821 10.4149C17.5864 11.2444 18 12.3629 18 13.5C18 14.6371 17.5864 15.7556 16.7821 16.5851C15.9891 17.4028 14.7576 18 13 18H8C7.44772 18 7 18.4477 7 19Z " },
            { FluentSymbol.ArrowHookUpLeft24, "M7 19.25C7 19.6642 7.33579 20 7.75 20H14C15.9786 20 17.5041 19.1773 18.5198 17.9258C19.5207 16.6926 20 15.0799 20 13.5C20 11.9201 19.5207 10.3074 18.5198 9.07425C17.5041 7.82266 15.9786 7 14 7H7.56066L10.0303 4.53033C10.3232 4.23744 10.3232 3.76256 10.0303 3.46967C9.73744 3.17678 9.26256 3.17678 8.96967 3.46967L5.21967 7.21967C4.92678 7.51256 4.92678 7.98744 5.21967 8.28033L8.96967 12.0303C9.26256 12.3232 9.73744 12.3232 10.0303 12.0303C10.3232 11.7374 10.3232 11.2626 10.0303 10.9697L7.56066 8.5H14C15.5214 8.5 16.6209 9.11484 17.3552 10.0195C18.1043 10.9426 18.5 12.2049 18.5 13.5C18.5 14.7951 18.1043 16.0574 17.3552 16.9805C16.6209 17.8852 15.5214 18.5 14 18.5H7.75C7.33579 18.5 7 18.8358 7 19.25Z " },
            { FluentSymbol.ArrowHookUpLeft28, "M8 21.25C8 21.6642 8.33578 22 8.75 22H15.75C18.0865 22 20.0117 21.2189 21.25 19.9842C22.4814 18.7564 23 17.1237 23 15.5C23 13.8763 22.4814 12.2436 21.25 11.0158C20.0117 9.78107 18.0865 9 15.75 9H7.56066L10.7803 5.78033C11.0732 5.48744 11.0732 5.01256 10.7803 4.71967C10.4874 4.42678 10.0126 4.42678 9.71967 4.71967L5.21967 9.21967C5.07902 9.36032 5 9.55109 5 9.75C5 9.94891 5.07902 10.1397 5.21967 10.2803L9.71967 14.7803C10.0126 15.0732 10.4874 15.0732 10.7803 14.7803C11.0732 14.4874 11.0732 14.0126 10.7803 13.7197L7.56066 10.5H15.75C17.7385 10.5 19.1758 11.1564 20.1 12.078C21.0311 13.0064 21.5 14.2487 21.5 15.5C21.5 16.7513 21.0311 17.9936 20.1 18.922C19.1758 19.8436 17.7385 20.5 15.75 20.5H8.75C8.33578 20.5 8 20.8358 8 21.25Z " },
            { FluentSymbol.ArrowHookUpLeft20Filled, "M6 15.25C6 15.6642 6.33579 16 6.75 16H11.25C12.8365 16 13.9458 15.3788 14.78 14.4118C15.6009 13.4603 16 12.2164 16 11C16 9.78364 15.7009 8.53973 14.88 7.5882C14.0458 6.62123 12.8365 6 11.25 6H6.56066L8.78033 3.78033C9.07322 3.48744 9.07322 3.01256 8.78033 2.71967C8.48744 2.42678 8.01256 2.42678 7.71967 2.71967L4.21967 6.21967C4.07561 6.36373 3.99636 6.56019 4.00013 6.76388C4.0039 6.96757 4.09037 7.16097 4.23966 7.29959L7.73966 10.5496C8.04319 10.8314 8.51774 10.8139 8.7996 10.5103C9.08145 10.2068 9.06387 9.73226 8.76034 9.4504L6.6599 7.5H11.25C12.4135 7.5 13.1092 7.94127 13.65 8.56805C14.2041 9.21027 14.5 10.0914 14.5 11C14.5 11.9086 14.2041 12.7897 13.65 13.432C13.1092 14.0587 12.4135 14.5 11.25 14.5H6.75C6.33579 14.5 6 14.8358 6 15.25Z " },
            { FluentSymbol.ArrowHookUpLeft28Filled, "M21.2179 19.9774C20.0109 21.2222 18.2425 22 16 22H9.00002C8.44773 22 8.00002 21.5523 8.00002 21C8.00002 20.4477 8.44773 20 9.00002 20H16C17.7576 20 18.9892 19.4028 19.7821 18.5851C20.5864 17.7556 21 16.6371 21 15.5C21 14.3629 20.5864 13.2444 19.7821 12.4149C18.9892 11.5972 17.7576 11 16 11H8.41422L11.7071 14.2929C12.0977 14.6834 12.0977 15.3166 11.7071 15.7071C11.3166 16.0976 10.6834 16.0976 10.2929 15.7071L5.29289 10.7071C5.10536 10.5196 5 10.2652 5 10C5 9.73478 5.10536 9.48043 5.29289 9.29289L10.2929 4.29289C10.6834 3.90237 11.3166 3.90237 11.7071 4.29289C12.0977 4.68342 12.0977 5.31659 11.7071 5.70711L8.41422 9H16C18.2425 9 20.0109 9.77783 21.2179 11.0226C22.4136 12.2556 23 13.8871 23 15.5C23 17.1129 22.4136 18.7444 21.2179 19.9774Z " },
            { FluentSymbol.ArrowHookUpRight16Filled, "M4.46157 10.9127C5.11686 11.5885 6.06816 12 7.24999 12H10.25C10.6642 12 11 11.6642 11 11.25C11 10.8358 10.6642 10.5 10.25 10.5H7.24999C6.43183 10.5 5.88313 10.224 5.53842 9.86852C5.18517 9.50422 5 9.00906 5 8.5C5 7.99094 5.18517 7.49578 5.53843 7.13148C5.88314 6.776 6.43183 6.5 7.24999 6.5H10.4393L9.71967 7.21967C9.42678 7.51256 9.42678 7.98744 9.71967 8.28033C10.0126 8.57322 10.4874 8.57322 10.7803 8.28033L12.7803 6.28033C13.0732 5.98744 13.0732 5.51256 12.7803 5.21967L10.7803 3.21967C10.4874 2.92678 10.0126 2.92678 9.71967 3.21967C9.42678 3.51256 9.42678 3.98744 9.71967 4.28033L10.4393 5H7.24999C6.06816 5 5.11686 5.4115 4.46157 6.08727C3.81483 6.75422 3.5 7.63406 3.5 8.5C3.5 9.36594 3.81483 10.2458 4.46157 10.9127Z " },
            { FluentSymbol.ArrowHookUpRight16, "M4.87629 10.8947C5.47582 11.5691 6.36432 12 7.49999 12H10.5C10.7761 12 11 11.7761 11 11.5C11 11.2239 10.7761 11 10.5 11H7.49999C6.63567 11 6.02418 10.6809 5.6237 10.2303C5.21505 9.77058 5 9.14347 5 8.5C5 7.85654 5.21505 7.22942 5.62371 6.76968C6.02418 6.31915 6.63569 6 7.50001 6H11.2929L10.1465 7.14645C9.95121 7.34171 9.95122 7.6583 10.1465 7.85356C10.3417 8.04882 10.6583 8.04881 10.8536 7.85355L12.8536 5.85355C13.0488 5.65829 13.0488 5.34171 12.8536 5.14645L10.8536 3.14645C10.6583 2.95119 10.3417 2.95118 10.1465 3.14644C9.95122 3.3417 9.95121 3.65829 10.1465 3.85355L11.2929 5H7.50001C6.36433 5 5.47583 5.43085 4.8763 6.10532C4.28495 6.77058 4 7.64346 4 8.5C4 9.35653 4.28495 10.2294 4.87629 10.8947Z " },
            { FluentSymbol.ArrowHookUpRight20Filled, "M9 6C9.06037 6 8.94015 5.99788 9 6C9.02294 5.99789 9.22651 6 9.25 6H13.6434L11.3754 3.73202C11.0825 3.43913 11.0825 2.96425 11.3754 2.67136C11.6683 2.37847 12.1432 2.37847 12.4361 2.67136L15.789 6.02427C15.963 6.19831 16.0337 6.43661 16.0009 6.6628C15.9821 6.82493 15.9106 6.98212 15.7862 7.10649L12.5391 10.3536C12.2462 10.6465 11.7714 10.6465 11.4785 10.3536C11.1856 10.0607 11.1856 9.5858 11.4785 9.29291L13.2714 7.5H9C7.067 7.5 5.5 9.067 5.5 11C5.5 12.933 7.067 14.5 9 14.5H13.25C13.6642 14.5 14 14.8358 14 15.25C14 15.6642 13.6642 16 13.25 16H9.25C9.22651 16 9 16 9 16C6.23858 16 4 13.7614 4 11C4 8.23858 6.23858 6 9 6Z " },
            { FluentSymbol.ArrowHookUpRight20, "M4 11C4 13.7614 6.23858 16 9 16H13.5C13.7761 16 14 15.7761 14 15.5C14 15.2239 13.7761 15 13.5 15H9C6.79086 15 5 13.2091 5 11C5 8.79086 6.79086 7 9 7H14.293L11.5938 9.69918C11.3985 9.89444 11.3985 10.211 11.5938 10.4063C11.7891 10.6016 12.1056 10.6016 12.3009 10.4063L15.8399 6.8673C15.9744 6.73274 16.0163 6.54057 15.9654 6.37019C15.9457 6.27969 15.9007 6.19357 15.8304 6.12322L12.297 2.58985C12.1017 2.39458 11.7851 2.39458 11.5899 2.58985C11.3946 2.78511 11.3946 3.10169 11.5899 3.29695L14.2929 6H9C6.23858 6 4 8.23858 4 11Z " },
            { FluentSymbol.ArrowHookUpRight24Filled, "M10.5 18H16C16.5523 18 17 18.4477 17 19C17 19.5523 16.5523 20 16 20H10.5C6.91015 20 4 17.0899 4 13.5C4 9.91015 6.91015 7 10.5 7H15.6401L13.7072 5.06712C13.3167 4.6766 13.3167 4.04343 13.7072 3.65291C14.0977 3.26238 14.7309 3.26238 15.1214 3.65291L18.6502 7.18169C18.7418 7.27332 18.812 7.37831 18.8606 7.4904C18.9492 7.63963 19 7.81388 19 8C19 8.28967 18.8768 8.55056 18.68 8.73319C18.6711 8.74283 18.662 8.75234 18.6526 8.7617L15.1215 12.2928C14.731 12.6833 14.0978 12.6833 13.7073 12.2928C13.3168 11.9023 13.3168 11.2691 13.7073 10.8786L15.5859 9H10.5C8.01472 9 6 11.0147 6 13.5C6 15.9853 8.01472 18 10.5 18Z " },
            { FluentSymbol.ArrowHookUpRight24, "M10.5 18.5H16.25C16.6642 18.5 17 18.8358 17 19.25C17 19.6642 16.6642 20 16.25 20H10.5C6.91015 20 4 17.0899 4 13.5C4 9.91015 6.91015 7 10.5 7H16.4503L13.8336 4.38323C13.5407 4.09033 13.5407 3.61546 13.8336 3.32257C14.1264 3.02967 14.6013 3.02967 14.8942 3.32257L18.7765 7.2049C18.8762 7.30454 18.9419 7.42524 18.9738 7.55267C18.9909 7.61554 19 7.68171 19 7.75C19 7.96292 18.9113 8.15511 18.7688 8.29163L14.8887 12.1717C14.5958 12.4646 14.121 12.4646 13.8281 12.1717C13.5352 11.8788 13.5352 11.4039 13.8281 11.111L16.4391 8.5H10.5C7.73858 8.5 5.5 10.7386 5.5 13.5C5.5 16.2614 7.73858 18.5 10.5 18.5Z " },
            { FluentSymbol.ArrowHookUpRight28Filled, "M6.78209 19.9774C7.98914 21.2222 9.75754 22 12 22H19C19.5523 22 20 21.5523 20 21C20 20.4477 19.5523 20 19 20H12C10.2424 20 9.01084 19.4028 8.2179 18.5851C7.41356 17.7556 7 16.6371 7 15.5C7 14.3629 7.41356 13.2444 8.2179 12.4149C9.01085 11.5972 10.2424 11 12 11H19.5858L16.2929 14.2929C15.9023 14.6834 15.9023 15.3166 16.2929 15.7071C16.6834 16.0976 17.3166 16.0976 17.7071 15.7071L22.7071 10.7071C22.8946 10.5196 23 10.2652 23 10C23 9.73478 22.8946 9.48043 22.7071 9.29289L17.7071 4.29289C17.3166 3.90237 16.6834 3.90237 16.2929 4.29289C15.9023 4.68342 15.9023 5.31658 16.2929 5.70711L19.5858 9H12C9.75755 9 7.98914 9.77783 6.7821 11.0226C5.58644 12.2556 5 13.8871 5 15.5C5 17.1129 5.58644 18.7444 6.78209 19.9774Z " },
            { FluentSymbol.ArrowHookUpRight28, "M6.84 19.9842C8.07829 21.2189 9.91348 22 12.25 22H19.25C19.6642 22 20 21.6642 20 21.25C20 20.8358 19.6642 20.5 19.25 20.5H12.25C10.2615 20.5 8.82421 19.8436 7.9 18.922C6.96888 17.9936 6.5 16.7513 6.5 15.5C6.5 14.2487 6.96888 13.0064 7.9 12.078C8.82421 11.1564 10.2615 10.5 12.25 10.5H20.4393L17.2197 13.7197C16.9268 14.0126 16.9268 14.4874 17.2197 14.7803C17.5126 15.0732 17.9874 15.0732 18.2803 14.7803L22.7803 10.2803C22.921 10.1397 23 9.94891 23 9.75C23 9.55109 22.921 9.36032 22.7803 9.21967L18.2803 4.71967C17.9874 4.42678 17.5126 4.42678 17.2197 4.71967C16.9268 5.01256 16.9268 5.48744 17.2197 5.78033L20.4393 9H12.25C9.91348 9 8.07829 9.78107 6.84 11.0158C5.60862 12.2436 5 13.8763 5 15.5C5 17.1237 5.60862 18.7564 6.84 19.9842Z " },
            { FluentSymbol.ArrowImport20Filled, "M17.25 3.75C17.6642 3.75 18 4.08579 18 4.5V15.5C18 15.9142 17.6642 16.25 17.25 16.25C16.8358 16.25 16.5 15.9142 16.5 15.5V4.5C16.5 4.08579 16.8358 3.75 17.25 3.75Z M2 10C2 9.58579 2.33579 9.25 2.75 9.25H12.9393L10.2197 6.53033C9.92678 6.23744 9.92678 5.76256 10.2197 5.46967C10.5126 5.17678 10.9874 5.17678 11.2803 5.46967L15.277 9.46634C15.2891 9.47836 15.3009 9.49079 15.3122 9.50361C15.3626 9.56051 15.4028 9.62323 15.4329 9.68943C15.476 9.78406 15.5 9.88923 15.5 10C15.5 10.1122 15.4753 10.2187 15.4312 10.3143C15.4019 10.3778 15.3633 10.438 15.3153 10.4929C15.3029 10.5071 15.29 10.5208 15.2766 10.534L11.2803 14.5303C10.9874 14.8232 10.5126 14.8232 10.2197 14.5303C9.92678 14.2374 9.92678 13.7626 10.2197 13.4697L12.9393 10.75H2.75C2.33579 10.75 2 10.4142 2 10Z " },
            { FluentSymbol.ArrowImport20, "M17.5 4C17.7761 4 18 4.22386 18 4.5V15.5C18 15.7761 17.7761 16 17.5 16C17.2239 16 17 15.7761 17 15.5V4.5C17 4.22386 17.2239 4 17.5 4Z M2 10C2 9.72386 2.22386 9.5 2.5 9.5H13.2929L10.1464 6.35355C9.95118 6.15829 9.95118 5.84171 10.1464 5.64645C10.3417 5.45118 10.6583 5.45118 10.8536 5.64645L14.8536 9.64645C14.9015 9.69439 14.9377 9.74964 14.9621 9.80861C14.9861 9.86669 14.9996 9.9303 15 9.997L15 10L15 10.003C14.9992 10.13 14.9504 10.2567 14.8536 10.3536L10.8536 14.3536C10.6583 14.5488 10.3417 14.5488 10.1464 14.3536C9.95118 14.1583 9.95118 13.8417 10.1464 13.6464L13.2929 10.5H2.5C2.22386 10.5 2 10.2761 2 10Z " },
            { FluentSymbol.ArrowImport24Filled, "M21.25 4.5C21.6297 4.5 21.9435 4.78215 21.9932 5.14823L22 5.25V18.75C22 19.1642 21.6642 19.5 21.25 19.5C20.8703 19.5 20.5565 19.2178 20.5069 18.8518L20.5 18.75V5.25C20.5 4.83579 20.8358 4.5 21.25 4.5ZM12.2098 6.38702L12.293 6.29282C12.6535 5.93237 13.2207 5.9047 13.613 6.20977L13.7072 6.29297L18.7038 11.2906C19.064 11.6509 19.0919 12.2178 18.7873 12.6101L18.7042 12.7043L13.7076 17.7077C13.3173 18.0985 12.6842 18.0989 12.2934 17.7087C11.9327 17.3484 11.9045 16.7812 12.2093 16.3887L12.2924 16.2945L15.581 13H3C2.48716 13 2.06449 12.614 2.00673 12.1166L2 12C2 11.4872 2.38604 11.0645 2.88338 11.0067L3 11H15.584L12.2928 7.70703C11.9324 7.34651 11.9047 6.77928 12.2098 6.38702L12.293 6.29282L12.2098 6.38702Z " },
            { FluentSymbol.ArrowImport24, "M21.2503 4.5C21.63 4.5 21.9438 4.78215 21.9934 5.14823L22.0003 5.25V18.2541C22.0003 18.6683 21.6645 19.0041 21.2503 19.0041C20.8706 19.0041 20.5568 18.7219 20.5071 18.3558L20.5003 18.2541V5.25C20.5003 4.83579 20.8361 4.5 21.2503 4.5ZM12.6474 6.30373L12.72 6.21961C12.9863 5.95338 13.403 5.92921 13.6966 6.1471L13.7807 6.21972L18.7773 11.2174C19.0434 11.4835 19.0677 11.8999 18.8501 12.1935L18.7776 12.2776L13.781 17.2811C13.4883 17.5742 13.0134 17.5745 12.7203 17.2818C12.4539 17.0157 12.4294 16.5991 12.647 16.3053L12.7196 16.2211L16.4305 12.504L2.75049 12.5049C2.37079 12.5049 2.057 12.2228 2.00733 11.8567L2.00049 11.7549C2.00049 11.3752 2.28264 11.0615 2.64872 11.0118L2.75049 11.0049L16.4435 11.004L12.7199 7.28028C12.4537 7.01398 12.4295 6.59732 12.6474 6.30373L12.72 6.21961L12.6474 6.30373Z " },
            { FluentSymbol.ArrowLeft20, "M9.15898 16.3666C9.36292 16.5528 9.67918 16.5384 9.86536 16.3345C10.0515 16.1305 10.0371 15.8143 9.8332 15.6281L3.66535 9.99736H17.4961C17.7722 9.99736 17.9961 9.7735 17.9961 9.49736C17.9961 9.22122 17.7722 8.99736 17.4961 8.99736H3.66824L9.8332 3.36927C10.0371 3.18309 10.0515 2.86684 9.86536 2.66289C9.67918 2.45895 9.36292 2.44456 9.15898 2.63074L2.24263 8.94478C2.10268 9.07254 2.02285 9.24008 2.00314 9.41323C1.99851 9.44058 1.99609 9.46869 1.99609 9.49736C1.99609 9.52423 1.99821 9.55061 2.00229 9.57633C2.02047 9.75224 2.10058 9.9229 2.24263 10.0526L9.15898 16.3666Z " },
            { FluentSymbol.ArrowLeft20Filled, "M8.73171 16.7951C9.03264 17.0797 9.50733 17.0665 9.79196 16.7656C10.0766 16.4646 10.0634 15.9899 9.76243 15.7053L4.52339 10.7502H17.2471C17.6613 10.7502 17.9971 10.4144 17.9971 10.0002C17.9971 9.58598 17.6613 9.25019 17.2471 9.25019H4.52112L9.76243 4.29294C10.0634 4.00831 10.0766 3.53362 9.79196 3.23269C9.50733 2.93175 9.03264 2.91853 8.73171 3.20316L2.31449 9.2726C2.14819 9.42989 2.04819 9.63 2.01448 9.83879C2.00308 9.89077 1.99707 9.94478 1.99707 10.0002C1.99707 10.0578 2.00356 10.1139 2.01585 10.1677C2.05084 10.3735 2.15039 10.5704 2.31449 10.7256L8.73171 16.7951Z " },
            { FluentSymbol.ArrowLeft24Filled, "M10.2954 19.7162C10.6888 20.1038 11.322 20.0991 11.7096 19.7057C12.0972 19.3123 12.0925 18.6792 11.6991 18.2915L6.32876 13.0001H19.9999C20.5522 13.0001 20.9999 12.5524 20.9999 12.0001C20.9999 11.4479 20.5522 11.0001 19.9999 11.0001H6.33536L11.6991 5.71525C12.0925 5.32763 12.0972 4.69448 11.7096 4.30108C11.322 3.90767 10.6888 3.90298 10.2954 4.29061L3.37122 11.113C2.87431 11.6026 2.87431 12.4042 3.37122 12.8938L10.2954 19.7162Z " },
            { FluentSymbol.ArrowLeft24, "M10.7327 19.7905C11.0326 20.0762 11.5074 20.0646 11.7931 19.7647C12.0787 19.4648 12.0672 18.99 11.7673 18.7043L5.51587 12.7497L20.25 12.7497C20.6642 12.7497 21 12.4139 21 11.9997C21 11.5855 20.6642 11.2497 20.25 11.2497L5.51577 11.2497L11.7673 5.29502C12.0672 5.00933 12.0787 4.5346 11.7931 4.23467C11.5074 3.93475 11.0326 3.9232 10.7327 4.20889L3.31379 11.2756C3.14486 11.4365 3.04491 11.6417 3.01393 11.8551C3.00479 11.9019 3 11.9503 3 11.9997C3 12.0493 3.00481 12.0977 3.01398 12.1446C3.04502 12.3579 3.14496 12.563 3.31379 12.7238L10.7327 19.7905Z " },
            { FluentSymbol.ArrowLeft28Filled, "M12.2984 4.28868C12.6913 3.9005 13.3244 3.90428 13.7126 4.29713C14.1008 4.68998 14.097 5.32313 13.7042 5.71132L6.32792 13H24.0032C24.5555 13 25.0032 13.4477 25.0032 14C25.0032 14.5523 24.5555 15 24.0032 15H6.3302L13.7042 22.2864C14.097 22.6746 14.1008 23.3078 13.7126 23.7006C13.3244 24.0935 12.6913 24.0972 12.2984 23.7091L3.37141 14.888C2.8762 14.3987 2.8762 13.5991 3.37141 13.1097L12.2984 4.28868Z " },
            { FluentSymbol.ArrowLeft28, "M12.7347 4.20949C13.0332 3.92233 13.508 3.93153 13.7952 4.23005C14.0823 4.52857 14.0731 5.00335 13.7746 5.29051L5.50039 13.25H24.2532C24.6674 13.25 25.0032 13.5858 25.0032 14C25.0032 14.4142 24.6674 14.75 24.2532 14.75H5.50137L13.7746 22.7085C14.0731 22.9957 14.0823 23.4705 13.7952 23.769C13.508 24.0675 13.0332 24.0767 12.7347 23.7896L3.30673 14.7202C2.89776 14.3268 2.89776 13.6723 3.30673 13.2788L12.7347 4.20949Z " },
            { FluentSymbol.ArrowMaximize16Filled, "M8.47727 2C8.06306 2 7.72727 2.33579 7.72727 2.75C7.72727 3.16421 8.06306 3.5 8.47727 3.5H11.4393L3.5 11.4393V8.47727C3.5 8.06306 3.16421 7.72727 2.75 7.72727C2.33579 7.72727 2 8.06306 2 8.47727V13.15C2 13.6194 2.38056 14 2.85 14H7.52273C7.93694 14 8.27273 13.6642 8.27273 13.25C8.27273 12.8358 7.93694 12.5 7.52273 12.5H4.56066L12.5 4.56066V7.52273C12.5 7.93694 12.8358 8.27273 13.25 8.27273C13.6642 8.27273 14 7.93694 14 7.52273V2.85C14 2.38056 13.6194 2 13.15 2H8.47727Z " },
            { FluentSymbol.ArrowMaximize16, "M8.5 2C8.22386 2 8 2.22386 8 2.5C8 2.77614 8.22386 3 8.5 3H12.2929L3 12.2929V8.5C3 8.22386 2.77614 8 2.5 8C2.22386 8 2 8.22386 2 8.5V13.4C2 13.7314 2.26863 14 2.6 14H7.5C7.77614 14 8 13.7761 8 13.5C8 13.2239 7.77614 13 7.5 13H3.70711L13 3.70711V7.5C13 7.77614 13.2239 8 13.5 8C13.7761 8 14 7.77614 14 7.5V2.6C14 2.26863 13.7314 2 13.4 2H8.5Z " },
            { FluentSymbol.ArrowMaximize20Filled, "M16 3C16.5523 3 17 3.44772 17 4V9.25C17 9.66421 16.6642 10 16.25 10C15.8358 10 15.5 9.66421 15.5 9.25V5.559L5.559 15.5H9.25C9.66421 15.5 10 15.8358 10 16.25C10 16.6642 9.66421 17 9.25 17H4C3.44772 17 3 16.5523 3 16V10.75C3 10.3358 3.33579 10 3.75 10C4.16421 10 4.5 10.3358 4.5 10.75V14.439L14.439 4.5H10.75C10.3358 4.5 10 4.16421 10 3.75C10 3.33579 10.3358 3 10.75 3H16Z " },
            { FluentSymbol.ArrowMaximize20, "M10.5 3L16.5428 3.00182L16.6281 3.01661L16.691 3.03779L16.767 3.07719L16.8221 3.11759L16.8824 3.17788L16.9112 3.21534L16.9533 3.2886L16.9834 3.37186L16.9979 3.45421L17 3.5V9.5C17 9.77614 16.7761 10 16.5 10C16.2545 10 16.0504 9.82312 16.0081 9.58988L16 9.5V4.706L4.706 16H9.5C9.74546 16 9.94961 16.1769 9.99194 16.4101L10 16.5C10 16.7455 9.82312 16.9496 9.58988 16.9919L9.5 17L3.47964 16.9996L3.4112 16.9921L3.30896 16.9622L3.23299 16.9228L3.17786 16.8824L3.11758 16.8221L3.08884 16.7847L3.04674 16.7114L3.01661 16.6281L3.01109 16.605C3.00383 16.5713 3 16.5361 3 16.5L3.00546 16.5739L3.00182 16.5428L3 10.5C3 10.2239 3.22386 10 3.5 10C3.74546 10 3.94961 10.1769 3.99194 10.4101L4 10.5V15.292L15.292 4H10.5C10.2545 4 10.0504 3.82312 10.0081 3.58988L10 3.5C10 3.22386 10.2239 3 10.5 3Z " },
            { FluentSymbol.ArrowMaximize24Filled, "M12.4968 3.00195L20.0525 3.00341L20.1734 3.01731L20.2611 3.03685L20.365 3.07133L20.4541 3.11166L20.5179 3.14728L20.5805 3.1888L20.6445 3.2387L20.7076 3.29703L20.802 3.40667L20.8736 3.51791L20.9271 3.63064L20.9624 3.73598L20.9781 3.80116L20.9873 3.85351L20.9983 4.00195V11.5058C20.9983 12.0581 20.5506 12.5058 19.9983 12.5058C19.4854 12.5058 19.0628 12.1198 19.005 11.6225L18.9983 11.5058L18.998 6.41595L6.41302 19L11.5006 19.0005C12.0134 19.0005 12.4361 19.3865 12.4938 19.8839L12.5006 20.0005C12.5006 20.5133 12.1145 20.936 11.6172 20.9938L11.5006 21.0005L3.93962 20.9987L3.84404 20.9885L3.76739 20.9735L3.6899 20.9517L3.62087 20.9265L3.53078 20.8843L3.44123 20.8306L3.34976 20.7611L3.38227 20.7877C3.32046 20.7392 3.2645 20.6836 3.21563 20.6221L3.16451 20.5517L3.12575 20.4882L3.09275 20.4237L3.05896 20.3423L3.03384 20.2627L3.01034 20.1509L3.00299 20.0897L2.99902 20.0005V12.4966C2.99902 11.9443 3.44674 11.4966 3.99902 11.4966C4.51186 11.4966 4.93453 11.8826 4.9923 12.38L4.99902 12.4966V17.585L17.583 5.00195H12.4968C11.9839 5.00195 11.5612 4.61591 11.5035 4.11857L11.4968 4.00195C11.4968 3.44967 11.9445 3.00195 12.4968 3.00195Z " },
            { FluentSymbol.ArrowMaximize24, "M12.748 3.00098L20.3018 3.00149L20.402 3.01541L20.5009 3.043L20.562 3.06894C20.641 3.10383 20.7149 3.15436 20.7798 3.21929L20.8206 3.26333L20.8811 3.34481L20.9183 3.40983L20.957 3.50015L20.9761 3.56427L20.9897 3.62822L20.999 3.72141L20.9996 11.2549C20.9996 11.6691 20.6638 12.0049 20.2496 12.0049C19.8699 12.0049 19.5561 11.7227 19.5064 11.3566L19.4996 11.2549L19.499 5.55898L5.55905 19.504L11.2496 19.5049C11.6293 19.5049 11.9431 19.787 11.9927 20.1531L11.9996 20.2549C11.9996 20.6346 11.7174 20.9484 11.3513 20.998L11.2496 21.0049L3.71372 21.0041L3.68473 21.0012C3.61867 20.9966 3.55596 20.9828 3.49668 20.9617L3.40655 20.9228L3.38936 20.9123C3.18516 20.8019 3.03871 20.5988 3.00529 20.3595L2.99805 20.2549V12.751C2.99805 12.3368 3.33383 12.001 3.74805 12.001C4.12774 12.001 4.44154 12.2831 4.4912 12.6492L4.49805 12.751V18.443L18.438 4.49998L12.748 4.50098C12.3684 4.50098 12.0546 4.21882 12.0049 3.85275L11.998 3.75098C11.998 3.37128 12.2802 3.05749 12.6463 3.00782L12.748 3.00098Z " },
            { FluentSymbol.ArrowMaximize28Filled, "M16.5 3H24C24.5128 3 24.9355 3.38604 24.9933 3.88338L25 4V11.5C25 12.0523 24.5523 12.5 24 12.5C23.4872 12.5 23.0645 12.114 23.0067 11.6166L23 11.5V6.414L6.414 23H11.5C12.0128 23 12.4355 23.386 12.4933 23.8834L12.5 24C12.5 24.5128 12.114 24.9355 11.6166 24.9933L11.5 25H4C3.48716 25 3.06449 24.614 3.00673 24.1166L3 24V16.5C3 15.9477 3.44772 15.5 4 15.5C4.51284 15.5 4.93551 15.886 4.99327 16.3834L5 16.5V21.585L21.585 5H16.5C15.9872 5 15.5645 4.61396 15.5067 4.11662L15.5 4C15.5 3.48716 15.886 3.06449 16.3834 3.00673L16.5 3H24H16.5Z " },
            { FluentSymbol.ArrowMaximize28, "M16.25 3H24.25C24.6297 3 24.9435 3.28215 24.9932 3.64823L25 3.75V11.75C25 12.1642 24.6642 12.5 24.25 12.5C23.8703 12.5 23.5565 12.2178 23.5068 11.8518L23.5 11.75V5.56L5.56 23.5H11.75C12.1297 23.5 12.4435 23.7822 12.4932 24.1482L12.5 24.25C12.5 24.6297 12.2178 24.9435 11.8518 24.9932L11.75 25H3.75C3.3703 25 3.05651 24.7178 3.00685 24.3518L3 24.25V16.25C3 15.8358 3.33579 15.5 3.75 15.5C4.1297 15.5 4.44349 15.7822 4.49315 16.1482L4.5 16.25V22.438L22.438 4.5H16.25C15.8703 4.5 15.5565 4.21785 15.5068 3.85177L15.5 3.75C15.5 3.3703 15.7822 3.05651 16.1482 3.00685L16.25 3H24.25H16.25Z " },
            { FluentSymbol.ArrowMaximizeVertical24, "M13.7197 5.78033C14.0126 6.07322 14.4874 6.07322 14.7803 5.78033C15.0732 5.48744 15.0732 5.01256 14.7803 4.71967L12.2803 2.21967C11.9874 1.92678 11.5126 1.92678 11.2197 2.21967L8.71967 4.71967C8.42678 5.01256 8.42678 5.48744 8.71967 5.78033C9.01256 6.07322 9.48744 6.07322 9.78033 5.78033L11 4.56066L11 8.75C11 9.16421 11.3358 9.5 11.75 9.5C12.1642 9.5 12.5 9.16421 12.5 8.75V4.56066L13.7197 5.78033Z M4 11.75C4 11.3358 4.33579 11 4.75 11H19.25C19.6642 11 20 11.3358 20 11.75C20 12.1642 19.6642 12.5 19.25 12.5H4.75C4.33579 12.5 4 12.1642 4 11.75Z M12.5 14.75C12.5 14.3358 12.1642 14 11.75 14C11.3358 14 11 14.3358 11 14.75V19.4393L9.78033 18.2197C9.48744 17.9268 9.01256 17.9268 8.71967 18.2197C8.42678 18.5126 8.42678 18.9874 8.71967 19.2803L11.2197 21.7803C11.5126 22.0732 11.9874 22.0732 12.2803 21.7803L14.7803 19.2803C15.0732 18.9874 15.0732 18.5126 14.7803 18.2197C14.4874 17.9268 14.0126 17.9268 13.7197 18.2197L12.5 19.4393V14.75Z " },
            { FluentSymbol.ArrowMaximizeVertical20Filled, "M9.57574 1.33296C9.81005 1.09865 10.1899 1.09865 10.4243 1.33296L12.5456 3.45428C12.7799 3.6886 12.7799 4.0685 12.5456 4.30281C12.3113 4.53713 11.9314 4.53713 11.6971 4.30281L10.6001 3.20585V7.49985C10.6001 7.83122 10.3315 8.09985 10.0001 8.09985C9.66873 8.09985 9.4001 7.83122 9.4001 7.49985V3.20566L8.30294 4.30281C8.06863 4.53713 7.68873 4.53713 7.45442 4.30281C7.2201 4.0685 7.2201 3.6886 7.45442 3.45428L9.57574 1.33296Z M3.8999 9.99985C3.8999 9.66848 4.16853 9.39985 4.4999 9.39985H15.4999C15.8313 9.39985 16.0999 9.66848 16.0999 9.99985C16.0999 10.3312 15.8313 10.5998 15.4999 10.5998H4.4999C4.16853 10.5998 3.8999 10.3312 3.8999 9.99985Z M10.5999 16.7941L10.5999 12.4999C10.5999 12.1685 10.3313 11.8999 9.9999 11.8999C9.66853 11.8999 9.3999 12.1685 9.3999 12.4999L9.3999 16.7939L8.30294 15.6969C8.06863 15.4626 7.68873 15.4626 7.45442 15.6969C7.2201 15.9312 7.2201 16.3111 7.45442 16.5454L9.57574 18.6667C9.81005 18.9011 10.1899 18.9011 10.4243 18.6667L12.5456 16.5454C12.7799 16.3111 12.7799 15.9312 12.5456 15.6969C12.3113 15.4626 11.9314 15.4626 11.6971 15.6969L10.5999 16.7941Z " },
            { FluentSymbol.ArrowMaximizeVertical20, "M9.64645 1.40426C9.84171 1.209 10.1583 1.209 10.3536 1.40426L12.4749 3.52558C12.6701 3.72084 12.6701 4.03742 12.4749 4.23269C12.2796 4.42795 11.963 4.42795 11.7678 4.23269L10.5 2.96492V7.50044C10.5 7.77659 10.2761 8.00044 10 8.00044C9.72386 8.00044 9.5 7.77659 9.5 7.50044V2.96492L8.23223 4.23269C8.03697 4.42795 7.72039 4.42795 7.52513 4.23269C7.32986 4.03742 7.32986 3.72084 7.52513 3.52558L9.64645 1.40426Z M4 10.0004C4 9.7243 4.22386 9.50044 4.5 9.50044H15.5C15.7761 9.50044 16 9.7243 16 10.0004C16 10.2766 15.7761 10.5004 15.5 10.5004H4.5C4.22386 10.5004 4 10.2766 4 10.0004Z M10.5 17.036L10.5 12.5004C10.5 12.2243 10.2761 12.0004 10 12.0004C9.72386 12.0004 9.5 12.2243 9.5 12.5004L9.5 17.036L8.23223 15.7682C8.03697 15.5729 7.72039 15.5729 7.52513 15.7682C7.32986 15.9635 7.32986 16.28 7.52513 16.4753L9.64645 18.5966C9.84171 18.7919 10.1583 18.7919 10.3536 18.5966L12.4749 16.4753C12.6701 16.28 12.6701 15.9635 12.4749 15.7682C12.2796 15.5729 11.963 15.5729 11.7678 15.7682L10.5 17.036Z " },
            { FluentSymbol.ArrowMaximizeVertical24Filled, "M15.2071 6.20711C14.8166 6.59763 14.1834 6.59763 13.7929 6.20711L13 5.41421V9C13 9.55228 12.5523 10 12 10C11.4477 10 11 9.55228 11 9L11 5.41421L10.2071 6.20711C9.81658 6.59763 9.18342 6.59763 8.79289 6.20711C8.40237 5.81658 8.40237 5.18342 8.79289 4.79289L11.2929 2.29289C11.3888 2.19702 11.4993 2.12468 11.6172 2.07588C11.7343 2.02735 11.8625 2.0004 11.997 2L12 2L12.003 2C12.2579 2.00076 12.5126 2.09839 12.7071 2.29289L15.2071 4.79289C15.5976 5.18342 15.5976 5.81658 15.2071 6.20711ZM5 11C4.44772 11 4 11.4477 4 12C4 12.5523 4.44772 13 5 13H19C19.5523 13 20 12.5523 20 12C20 11.4477 19.5523 11 19 11H5ZM12.0092 22C12.1415 21.9988 12.2676 21.9719 12.3828 21.9241C12.5007 21.8753 12.6112 21.803 12.7071 21.7071L15.2071 19.2071C15.5976 18.8166 15.5976 18.1834 15.2071 17.7929C14.8166 17.4024 14.1834 17.4024 13.7929 17.7929L13 18.5858V15C13 14.4477 12.5523 14 12 14C11.4477 14 11 14.4477 11 15L11 18.5858L10.2071 17.7929C9.81658 17.4024 9.18342 17.4024 8.79289 17.7929C8.40237 18.1834 8.40237 18.8166 8.79289 19.2071L11.2929 21.7071C11.4858 21.9 11.7379 21.9976 11.9908 22 " },
            { FluentSymbol.ArrowMinimize16Filled, "M13.7803 3.28033C14.0732 2.98744 14.0732 2.51256 13.7803 2.21967C13.4874 1.92678 13.0126 1.92678 12.7197 2.21967L10.5 4.43934V3.25C10.5 2.83579 10.1642 2.5 9.75 2.5C9.33579 2.5 9 2.83579 9 3.25V6.15C9 6.16736 9.00052 6.1846 9.00155 6.20171C8.98823 6.40941 9.06093 6.62159 9.21967 6.78033C9.37841 6.93907 9.59059 7.01177 9.79829 6.99845C9.8154 6.99948 9.83264 7 9.85 7H12.75C13.1642 7 13.5 6.66421 13.5 6.25C13.5 5.83579 13.1642 5.5 12.75 5.5H11.5607L13.7803 3.28033Z M6.25 13.5C5.83579 13.5 5.5 13.1642 5.5 12.75V11.5607L3.28033 13.7803C2.98744 14.0732 2.51256 14.0732 2.21967 13.7803C1.92678 13.4874 1.92678 13.0126 2.21967 12.7197L4.43934 10.5H3.25C2.83579 10.5 2.5 10.1642 2.5 9.75C2.5 9.33579 2.83579 9 3.25 9H6.15C6.16736 9 6.1846 9.00052 6.20171 9.00155C6.40941 8.98823 6.62159 9.06093 6.78033 9.21967C6.93907 9.37841 7.01177 9.59059 6.99845 9.79829C6.99948 9.8154 7 9.83264 7 9.85V12.75C7 13.1642 6.66421 13.5 6.25 13.5Z " },
            { FluentSymbol.ArrowMinimize16, "M13.8536 2.85355C14.0488 2.65829 14.0488 2.34171 13.8536 2.14645C13.6583 1.95118 13.3417 1.95118 13.1464 2.14645L10 5.29289V3.5C10 3.22386 9.77614 3 9.5 3C9.22386 3 9 3.22386 9 3.5V6.4C9 6.73137 9.26863 7 9.6 7H12.5C12.7761 7 13 6.77614 13 6.5C13 6.22386 12.7761 6 12.5 6H10.7071L13.8536 2.85355Z M6.5 13C6.22386 13 6 12.7761 6 12.5V10.7071L2.85355 13.8536C2.65829 14.0488 2.34171 14.0488 2.14645 13.8536C1.95118 13.6583 1.95118 13.3417 2.14645 13.1464L5.29289 10H3.5C3.22386 10 3 9.77614 3 9.5C3 9.22386 3.22386 9 3.5 9H6.4C6.73137 9 7 9.26863 7 9.6V12.5C7 12.7761 6.77614 13 6.5 13Z " },
            { FluentSymbol.ArrowMinimize20Filled, "M3.75 11H8.25C8.6297 11 8.94349 11.2822 8.99315 11.6482L9 11.75V16.25C9 16.6642 8.66421 17 8.25 17C7.8703 17 7.55651 16.7178 7.50685 16.3518L7.5 16.25V13.56L3.03033 18.0303C2.73744 18.3232 2.26256 18.3232 1.96967 18.0303C1.7034 17.7641 1.6792 17.3474 1.89705 17.0538L1.96967 16.9697L6.438 12.5H3.75C3.3703 12.5 3.05651 12.2178 3.00685 11.8518L3 11.75C3 11.3703 3.28215 11.0565 3.64823 11.0068L3.75 11H8.25H3.75ZM18.0303 1.96967C18.2966 2.23594 18.3208 2.6526 18.1029 2.94621L18.0303 3.03033L13.06 8H16.25C16.6297 8 16.9435 8.28215 16.9932 8.64823L17 8.75C17 9.1297 16.7178 9.44349 16.3518 9.49315L16.25 9.5H11.25C10.8703 9.5 10.5565 9.21785 10.5068 8.85177L10.5 8.75V3.75C10.5 3.33579 10.8358 3 11.25 3C11.6297 3 11.9435 3.28215 11.9932 3.64823L12 3.75V6.938L16.9697 1.96967C17.2626 1.67678 17.7374 1.67678 18.0303 1.96967Z " },
            { FluentSymbol.ArrowMinimize20, "M3.5 11H8.5C8.74546 11 8.94961 11.1769 8.99194 11.4101L9 11.5V16.5C9 16.7761 8.77614 17 8.5 17C8.25454 17 8.05039 16.8231 8.00806 16.5899L8 16.5V12.706L2.85355 17.8536C2.65829 18.0488 2.34171 18.0488 2.14645 17.8536C1.97288 17.68 1.9536 17.4106 2.08859 17.2157L2.14645 17.1464L7.292 12H3.5C3.25454 12 3.05039 11.8231 3.00806 11.5899L3 11.5C3 11.2545 3.17688 11.0504 3.41012 11.0081L3.5 11H8.5H3.5ZM17.8536 2.14645C18.0271 2.32001 18.0464 2.58944 17.9114 2.78431L17.8536 2.85355L12.706 8H16.5C16.7455 8 16.9496 8.17688 16.9919 8.41012L17 8.5C17 8.74546 16.8231 8.94961 16.5899 8.99194L16.5 9L11.4796 8.99959L11.4112 8.99213L11.309 8.96221L11.233 8.92281L11.1779 8.88242L11.1464 8.85355L11.109 8.81166L11.0667 8.74977L11.0376 8.69059L11.0166 8.62814L11.0111 8.60499C11.0038 8.5713 11 8.5361 11 8.5L11.0055 8.57392L11.0018 8.5428L11 3.5C11 3.22386 11.2239 3 11.5 3C11.7455 3 11.9496 3.17687 11.9919 3.41012L12 3.5V7.292L17.1464 2.14645C17.3417 1.95118 17.6583 1.95118 17.8536 2.14645Z " },
            { FluentSymbol.ArrowMinimize24Filled, "M10.4981 12.5042C11.0109 12.5042 11.4336 12.8903 11.4914 13.3876L11.4981 13.5042V21.0081C11.4981 21.5604 11.0504 22.0081 10.4981 22.0081C9.98527 22.0081 9.5626 21.6221 9.50484 21.1247L9.49811 21.0081L9.49758 15.915L3.70711 21.7067C3.34663 22.0672 2.7794 22.0949 2.38711 21.7899L2.2929 21.7067C1.93242 21.3462 1.90469 20.779 2.20971 20.3867L2.2929 20.2925L8.08058 14.504L2.99658 14.5042C2.4443 14.5042 1.99658 14.0565 1.99658 13.5042C1.99658 12.9914 2.38262 12.5687 2.87996 12.511L2.99658 12.5042H10.4981ZM13.4991 1.99902C14.0119 1.99902 14.4346 2.38506 14.4924 2.8824L14.4991 2.99902L14.4986 8.08602L20.2929 2.2925C20.6534 1.93202 21.2206 1.90429 21.6129 2.20931L21.7071 2.2925C22.0676 2.65299 22.0953 3.22022 21.7903 3.61251L21.7071 3.70672L15.9106 9.50202L21.0006 9.50291C21.5529 9.50291 22.0006 9.95063 22.0006 10.5029C22.0006 11.0157 21.6146 11.4384 21.1173 11.4962L21.0006 11.5029H13.4991C12.9863 11.5029 12.5636 11.1169 12.5058 10.6195L12.4991 10.5029V2.99902C12.4991 2.44674 12.9468 1.99902 13.4991 1.99902Z " },
            { FluentSymbol.ArrowMinimize24, "M21.7776 2.22254C22.0437 2.48877 22.0679 2.90543 21.8503 3.19907L21.7778 3.2832L15.555 9.50693L21.2476 9.50788C21.6273 9.50788 21.9411 9.79003 21.9908 10.1561L21.9976 10.2579C21.9976 10.6376 21.7155 10.9514 21.3494 11.001L21.2476 11.0079L13.6973 11.0055L13.6824 11.0043C13.6141 10.9991 13.5486 10.9845 13.487 10.9619L13.3892 10.9164C13.1842 10.8063 13.037 10.6028 13.0034 10.3628L12.9961 10.2579V2.75399C12.9961 2.33977 13.3319 2.00399 13.7461 2.00399C14.1258 2.00399 14.4396 2.28614 14.4893 2.65222L14.4961 2.75399L14.496 8.44493L20.7178 2.22266C21.0104 1.92973 21.4849 1.92968 21.7776 2.22254ZM11.0025 13.7552V21.2591C11.0025 21.6733 10.6667 22.0091 10.2525 22.0091C9.8728 22.0091 9.55901 21.727 9.50935 21.3609L9.5025 21.2591L9.502 15.5639L3.28039 21.7799C2.98753 22.0728 2.51266 22.0729 2.21973 21.78C1.95343 21.5138 1.92918 21.0971 2.147 20.8035L2.21961 20.7194L8.44 14.5049L2.75097 14.5052C2.37128 14.5052 2.05748 14.2231 2.00782 13.857L2.00097 13.7552C2.00097 13.341 2.33676 13.0052 2.75097 13.0052L10.3053 13.0071L10.3788 13.0158L10.4763 13.0392L10.5291 13.0579L10.6154 13.0987L10.7039 13.1561C10.7598 13.1984 10.8095 13.2482 10.8517 13.304L10.9185 13.41L10.9592 13.5035L10.9806 13.5744L10.9919 13.6291L10.998 13.6869L10.9986 13.6785L11.0025 13.7552Z " },
            { FluentSymbol.ArrowMinimize28Filled, "M4 15H12C12.5128 15 12.9355 15.386 12.9933 15.8834L13 16V24C13 24.5523 12.5523 25 12 25C11.4872 25 11.0645 24.614 11.0067 24.1166L11 24V18.413L3.70711 25.7071C3.31658 26.0976 2.68342 26.0976 2.29289 25.7071C1.93241 25.3466 1.90468 24.7794 2.2097 24.3871L2.29289 24.2929L9.585 17H4C3.48716 17 3.06449 16.614 3.00673 16.1166L3 16C3 15.4872 3.38604 15.0645 3.88338 15.0067L4 15H12H4ZM25.7071 2.29289C26.0676 2.65338 26.0953 3.22061 25.7903 3.6129L25.7071 3.70711L18.413 11H24C24.5128 11 24.9355 11.386 24.9933 11.8834L25 12C25 12.5128 24.614 12.9355 24.1166 12.9933L24 13H16C15.4872 13 15.0645 12.614 15.0067 12.1166L15 12V4C15 3.44772 15.4477 3 16 3C16.5128 3 16.9355 3.38604 16.9933 3.88338L17 4V9.585L24.2929 2.29289C24.6834 1.90237 25.3166 1.90237 25.7071 2.29289Z " },
            { FluentSymbol.ArrowMinimize28, "M4.25 15H12.25C12.6297 15 12.9435 15.2822 12.9932 15.6482L13 15.75V23.75C13 24.1642 12.6642 24.5 12.25 24.5C11.8703 24.5 11.5565 24.2178 11.5068 23.8518L11.5 23.75V17.56L3.53033 25.5303C3.23744 25.8232 2.76256 25.8232 2.46967 25.5303C2.2034 25.2641 2.1792 24.8474 2.39705 24.5538L2.46967 24.4697L10.438 16.5H4.25C3.8703 16.5 3.55651 16.2178 3.50685 15.8518L3.5 15.75C3.5 15.3703 3.78215 15.0565 4.14823 15.0068L4.25 15H12.25H4.25ZM25.5303 2.46967C25.7966 2.73594 25.8208 3.1526 25.6029 3.44621L25.5303 3.53033L17.56 11.5H23.75C24.1297 11.5 24.4435 11.7822 24.4932 12.1482L24.5 12.25C24.5 12.6297 24.2178 12.9435 23.8518 12.9932L23.75 13H15.75C15.3703 13 15.0565 12.7178 15.0068 12.3518L15 12.25V4.25C15 3.83579 15.3358 3.5 15.75 3.5C16.1297 3.5 16.4435 3.78215 16.4932 4.14823L16.5 4.25V10.438L24.4697 2.46967C24.7626 2.17678 25.2374 2.17678 25.5303 2.46967Z " },
            { FluentSymbol.ArrowMinimizeVertical24Filled, "M13.7929 18.7071C14.1834 19.0977 14.8166 19.0977 15.2071 18.7071C15.5976 18.3166 15.5976 17.6834 15.2071 17.2929L12.7071 14.7929C12.3166 14.4024 11.6834 14.4024 11.2929 14.7929L8.79289 17.2929C8.40237 17.6834 8.40237 18.3166 8.79289 18.7071C9.18342 19.0977 9.81658 19.0977 10.2071 18.7071L11 17.9142L11 21C11 21.5523 11.4477 22 12 22C12.5523 22 13 21.5523 13 21V17.9142L13.7929 18.7071Z M4 12C4 11.4477 4.44772 11 5 11H19C19.5523 11 20 11.4477 20 12C20 12.5523 19.5523 13 19 13H5C4.44772 13 4 12.5523 4 12Z M13 3C13 2.44772 12.5523 2 12 2C11.4477 2 11 2.44772 11 3L11 6.08579L10.2071 5.29289C9.81658 4.90237 9.18342 4.90237 8.79289 5.29289C8.40237 5.68342 8.40237 6.31658 8.79289 6.70711L11.2929 9.20711C11.6834 9.59763 12.3166 9.59763 12.7071 9.20711L15.2071 6.70711C15.5976 6.31658 15.5976 5.68342 15.2071 5.29289C14.8166 4.90237 14.1834 4.90237 13.7929 5.29289L13 6.08579V3Z " },
            { FluentSymbol.ArrowMinimizeVertical24, "M11.75 2C12.1642 2 12.5 2.33579 12.5 2.75V6.93934L13.7197 5.71967C14.0126 5.42678 14.4874 5.42678 14.7803 5.71967C15.0732 6.01256 15.0732 6.48744 14.7803 6.78033L12.2803 9.28033C11.9874 9.57322 11.5126 9.57322 11.2197 9.28033L8.71967 6.78033C8.42678 6.48744 8.42678 6.01256 8.71967 5.71967C9.01256 5.42678 9.48744 5.42678 9.78033 5.71967L11 6.93934V2.75C11 2.33579 11.3358 2 11.75 2ZM4 11.75C4 11.3358 4.33579 11 4.75 11H19.25C19.6642 11 20 11.3358 20 11.75C20 12.1642 19.6642 12.5 19.25 12.5H4.75C4.33579 12.5 4 12.1642 4 11.75ZM13.7197 17.7803C14.0126 18.0732 14.4874 18.0732 14.7803 17.7803C15.0732 17.4874 15.0732 17.0126 14.7803 16.7197L12.2803 14.2197C11.9874 13.9268 11.5126 13.9268 11.2197 14.2197L8.71967 16.7197C8.42678 17.0126 8.42678 17.4874 8.71967 17.7803C9.01256 18.0732 9.48744 18.0732 9.78033 17.7803L11 16.5607L11 21.25C11 21.6642 11.3358 22 11.75 22C12.1642 22 12.5 21.6642 12.5 21.25V16.5607L13.7197 17.7803Z " },
            { FluentSymbol.ArrowMove20Filled, "M6.96967 4.78033C7.26256 5.07322 7.73744 5.07322 8.03033 4.78033L9.25 3.56066V6.75C9.25 7.16421 9.58579 7.5 10 7.5C10.4142 7.5 10.75 7.16421 10.75 6.75V3.56066L11.9697 4.78033C12.2626 5.07322 12.7374 5.07322 13.0303 4.78033C13.3232 4.48744 13.3232 4.01256 13.0303 3.71967L10.5303 1.21967C10.2374 0.926777 9.76256 0.926777 9.46967 1.21967L6.96967 3.71967C6.67678 4.01256 6.67678 4.48744 6.96967 4.78033Z M4.78033 8.03033C5.07322 7.73744 5.07322 7.26256 4.78033 6.96967C4.48744 6.67678 4.01256 6.67678 3.71967 6.96967L1.21967 9.46967C0.926777 9.76256 0.926777 10.2374 1.21967 10.5303L3.71967 13.0303C4.01256 13.3232 4.48744 13.3232 4.78033 13.0303C5.07322 12.7374 5.07322 12.2626 4.78033 11.9697L3.56066 10.75H6.75C7.16421 10.75 7.5 10.4142 7.5 10C7.5 9.58579 7.16421 9.25 6.75 9.25H3.56066L4.78033 8.03033Z M15.2197 6.96967C15.5126 6.67678 15.9874 6.67678 16.2803 6.96967L18.7803 9.46967C19.0732 9.76256 19.0732 10.2374 18.7803 10.5303L16.2803 13.0303C15.9874 13.3232 15.5126 13.3232 15.2197 13.0303C14.9268 12.7374 14.9268 12.2626 15.2197 11.9697L16.4393 10.75H13.25C12.8358 10.75 12.5 10.4142 12.5 10C12.5 9.58579 12.8358 9.25 13.25 9.25H16.4393L15.2197 8.03033C14.9268 7.73744 14.9268 7.26256 15.2197 6.96967Z M9.25 16.4393L8.03033 15.2197C7.73744 14.9268 7.26256 14.9268 6.96967 15.2197C6.67678 15.5126 6.67678 15.9874 6.96967 16.2803L9.46967 18.7803C9.76256 19.0732 10.2374 19.0732 10.5303 18.7803L13.0303 16.2803C13.3232 15.9874 13.3232 15.5126 13.0303 15.2197C12.7374 14.9268 12.2626 14.9268 11.9697 15.2197L10.75 16.4393V13.25C10.75 12.8358 10.4142 12.5 10 12.5C9.58579 12.5 9.25 12.8358 9.25 13.25V16.4393Z " },
            { FluentSymbol.ArrowMove20, "M7.14645 4.35355C7.34171 4.54882 7.65829 4.54882 7.85355 4.35355L9.5 2.70711V6.5C9.5 6.77614 9.72386 7 10 7C10.2761 7 10.5 6.77614 10.5 6.5V2.70711L12.1464 4.35355C12.3417 4.54882 12.6583 4.54882 12.8536 4.35355C13.0488 4.15829 13.0488 3.84171 12.8536 3.64645L10.3536 1.14645C10.1583 0.951184 9.84171 0.951184 9.64645 1.14645L7.14645 3.64645C6.95118 3.84171 6.95118 4.15829 7.14645 4.35355Z M4.35355 7.85355C4.54882 7.65829 4.54882 7.34171 4.35355 7.14645C4.15829 6.95118 3.84171 6.95118 3.64645 7.14645L1.14645 9.64645C0.951184 9.84171 0.951184 10.1583 1.14645 10.3536L3.64645 12.8536C3.84171 13.0488 4.15829 13.0488 4.35355 12.8536C4.54882 12.6583 4.54882 12.3417 4.35355 12.1464L2.70711 10.5H6.5C6.77614 10.5 7 10.2761 7 10C7 9.72386 6.77614 9.5 6.5 9.5H2.70711L4.35355 7.85355Z M15.6464 7.85355C15.4512 7.65829 15.4512 7.34171 15.6464 7.14645C15.8417 6.95118 16.1583 6.95118 16.3536 7.14645L18.8536 9.64645C19.0488 9.84171 19.0488 10.1583 18.8536 10.3536L16.3536 12.8536C16.1583 13.0488 15.8417 13.0488 15.6464 12.8536C15.4512 12.6583 15.4512 12.3417 15.6464 12.1464L17.2929 10.5H13.5C13.2239 10.5 13 10.2761 13 10C13 9.72386 13.2239 9.5 13.5 9.5H17.2929L15.6464 7.85355Z M7.85355 15.6464C7.65829 15.4512 7.34171 15.4512 7.14645 15.6464C6.95118 15.8417 6.95118 16.1583 7.14645 16.3536L9.64645 18.8536C9.84171 19.0488 10.1583 19.0488 10.3536 18.8536L12.8536 16.3536C13.0488 16.1583 13.0488 15.8417 12.8536 15.6464C12.6583 15.4512 12.3417 15.4512 12.1464 15.6464L10.5 17.2929V13.5C10.5 13.2239 10.2761 13 10 13C9.72386 13 9.5 13.2239 9.5 13.5V17.2929L7.85355 15.6464Z " },
            { FluentSymbol.ArrowMove24Filled, "M15.4571 6.45711C15.0666 6.84763 14.4334 6.84763 14.0429 6.45711L13 5.41421L13 8.25C13 8.80228 12.5523 9.25 12 9.25C11.4477 9.25 11 8.80228 11 8.25L11 5.41421L9.95711 6.45711C9.56658 6.84763 8.93342 6.84763 8.54289 6.45711C8.15237 6.06658 8.15237 5.43342 8.54289 5.04289L11.2929 2.29289C11.4804 2.10536 11.7348 2 12 2C12.2652 2 12.5196 2.10536 12.7071 2.29289L15.4571 5.04289C15.8476 5.43342 15.8476 6.06658 15.4571 6.45711Z M6.45711 14.0429C6.84763 14.4334 6.84763 15.0666 6.45711 15.4571C6.06658 15.8476 5.43342 15.8476 5.04289 15.4571L2.29289 12.7071C2.10536 12.5196 2 12.2652 2 12C2 11.7348 2.10536 11.4804 2.29289 11.2929L5.04289 8.54289C5.43342 8.15237 6.06658 8.15237 6.45711 8.54289C6.84763 8.93342 6.84763 9.56658 6.45711 9.95711L5.41421 11H8.25C8.80228 11 9.25 11.4477 9.25 12C9.25 12.5523 8.80228 13 8.25 13H5.41421L6.45711 14.0429Z M18.9571 15.4571C18.5666 15.8476 17.9334 15.8476 17.5429 15.4571C17.1524 15.0666 17.1524 14.4334 17.5429 14.0429L18.5858 13H15.75C15.1977 13 14.75 12.5523 14.75 12C14.75 11.4477 15.1977 11 15.75 11H18.5858L17.5429 9.95711C17.1524 9.56658 17.1524 8.93342 17.5429 8.54289C17.9334 8.15237 18.5666 8.15237 18.9571 8.54289L21.7071 11.2929C21.8946 11.4804 22 11.7348 22 12C22 12.2652 21.8946 12.5196 21.7071 12.7071L18.9571 15.4571Z M11 18.5858L11 15.75C11 15.1977 11.4477 14.75 12 14.75C12.5523 14.75 13 15.1977 13 15.75L13 18.5858L14.0429 17.5429C14.4334 17.1524 15.0666 17.1524 15.4571 17.5429C15.8476 17.9334 15.8476 18.5666 15.4571 18.9571L12.7071 21.7071C12.5196 21.8946 12.2652 22 12 22C11.7348 22 11.4804 21.8946 11.2929 21.7071L8.54289 18.9571C8.15237 18.5666 8.15237 17.9334 8.54289 17.5429C8.93342 17.1524 9.56658 17.1524 9.95711 17.5429L11 18.5858Z " },
            { FluentSymbol.ArrowMove24, "M15.2803 6.03033C14.9874 6.32322 14.5126 6.32322 14.2197 6.03033L12.75 4.56066L12.75 8.25C12.75 8.66421 12.4142 9 12 9C11.5858 9 11.25 8.66421 11.25 8.25L11.25 4.56066L9.78033 6.03033C9.48744 6.32322 9.01256 6.32322 8.71967 6.03033C8.42678 5.73744 8.42678 5.26256 8.71967 4.96967L11.4697 2.21967C11.6103 2.07902 11.8011 2 12 2C12.1989 2 12.3897 2.07902 12.5303 2.21967L15.2803 4.96967C15.5732 5.26256 15.5732 5.73744 15.2803 6.03033Z M6.03033 14.2197C6.32322 14.5126 6.32322 14.9874 6.03033 15.2803C5.73744 15.5732 5.26256 15.5732 4.96967 15.2803L2.21967 12.5303C2.07902 12.3897 2 12.1989 2 12C2 11.8011 2.07902 11.6103 2.21967 11.4697L4.96967 8.71967C5.26256 8.42678 5.73744 8.42678 6.03033 8.71967C6.32322 9.01256 6.32322 9.48744 6.03033 9.78033L4.56066 11.25H8.25C8.66421 11.25 9 11.5858 9 12C9 12.4142 8.66421 12.75 8.25 12.75H4.56066L6.03033 14.2197Z M17.9697 15.2803C17.6768 14.9874 17.6768 14.5126 17.9697 14.2197L19.4393 12.75H15.75C15.3358 12.75 15 12.4142 15 12C15 11.5858 15.3358 11.25 15.75 11.25H19.4393L17.9697 9.78033C17.6768 9.48744 17.6768 9.01256 17.9697 8.71967C18.2626 8.42678 18.7374 8.42678 19.0303 8.71967L21.7803 11.4697C21.921 11.6103 22 11.8011 22 12C22 12.1989 21.921 12.3897 21.7803 12.5303L19.0303 15.2803C18.7374 15.5732 18.2626 15.5732 17.9697 15.2803Z M15.2803 17.9697C14.9874 17.6768 14.5126 17.6768 14.2197 17.9697L12.75 19.4393L12.75 15.75C12.75 15.3358 12.4142 15 12 15C11.5858 15 11.25 15.3358 11.25 15.75L11.25 19.4393L9.78033 17.9697C9.48744 17.6768 9.01256 17.6768 8.71967 17.9697C8.42678 18.2626 8.42678 18.7374 8.71967 19.0303L11.4697 21.7803C11.6103 21.921 11.8011 22 12 22C12.1989 22 12.3897 21.921 12.5303 21.7803L15.2803 19.0303C15.5732 18.7374 15.5732 18.2626 15.2803 17.9697Z " },
            { FluentSymbol.ArrowNext20Filled, "M13.75 4.75C14.1297 4.75 14.4435 5.03215 14.4932 5.39823L14.5 5.5V14.5C14.5 14.9142 14.1642 15.25 13.75 15.25C13.3703 15.25 13.0565 14.9678 13.0068 14.6018L13 14.5V5.5C13 5.08579 13.3358 4.75 13.75 4.75ZM5.46967 4.96967C5.73594 4.7034 6.1526 4.6792 6.44621 4.89705L6.53033 4.96967L11.0303 9.46967C11.2966 9.73594 11.3208 10.1526 11.1029 10.4462L11.0303 10.5303L6.53033 15.0303C6.23744 15.3232 5.76256 15.3232 5.46967 15.0303C5.2034 14.7641 5.1792 14.3474 5.39705 14.0538L5.46967 13.9697L9.43934 10L5.46967 6.03033C5.17678 5.73744 5.17678 5.26256 5.46967 4.96967Z " },
            { FluentSymbol.ArrowNext20, "M13.5 5C13.7455 5 13.9496 5.17688 13.9919 5.41012L14 5.5V14.5C14 14.7761 13.7761 15 13.5 15C13.2545 15 13.0504 14.8231 13.0081 14.5899L13 14.5V5.5C13 5.22386 13.2239 5 13.5 5ZM5.64645 5.14645C5.82001 4.97288 6.08944 4.9536 6.28431 5.08859L6.35355 5.14645L10.8536 9.64645C11.0271 9.82001 11.0464 10.0894 10.9114 10.2843L10.8536 10.3536L6.35355 14.8536C6.15829 15.0488 5.84171 15.0488 5.64645 14.8536C5.47288 14.68 5.4536 14.4106 5.58859 14.2157L5.64645 14.1464L9.79289 10L5.64645 5.85355C5.45118 5.65829 5.45118 5.34171 5.64645 5.14645Z " },
            { FluentSymbol.ArrowNext24Filled, "M18 3C18.5128 3 18.9355 3.38604 18.9933 3.88338L19 4V20C19 20.5523 18.5523 21 18 21C17.4872 21 17.0645 20.614 17.0067 20.1166L17 20V4C17 3.44772 17.4477 3 18 3ZM5.29289 3.29289C5.65338 2.93241 6.22061 2.90468 6.6129 3.2097L6.70711 3.29289L14.7071 11.2929C15.0676 11.6534 15.0953 12.2206 14.7903 12.6129L14.7071 12.7071L6.70711 20.7071C6.31658 21.0976 5.68342 21.0976 5.29289 20.7071C4.93241 20.3466 4.90468 19.7794 5.2097 19.3871L5.29289 19.2929L12.5858 12L5.29289 4.70711C4.90237 4.31658 4.90237 3.68342 5.29289 3.29289Z " },
            { FluentSymbol.ArrowNext24, "M18.25 3C18.6297 3 18.9435 3.28215 18.9932 3.64823L19 3.75V20.25C19 20.6642 18.6642 21 18.25 21C17.8703 21 17.5565 20.7178 17.5068 20.3518L17.5 20.25V3.75C17.5 3.33579 17.8358 3 18.25 3ZM5.21967 3.21967C5.48594 2.9534 5.9026 2.9292 6.19621 3.14705L6.28033 3.21967L14.5303 11.4697C14.7966 11.7359 14.8208 12.1526 14.6029 12.4462L14.5303 12.5303L6.28033 20.7803C5.98744 21.0732 5.51256 21.0732 5.21967 20.7803C4.9534 20.5141 4.9292 20.0974 5.14705 19.8038L5.21967 19.7197L12.9393 12L5.21967 4.28033C4.92678 3.98744 4.92678 3.51256 5.21967 3.21967Z " },
            { FluentSymbol.ArrowPrevious20Filled, "M6 4.75C5.6203 4.75 5.30651 5.03215 5.25685 5.39823L5.25 5.5V14.5C5.25 14.9142 5.58579 15.25 6 15.25C6.3797 15.25 6.69349 14.9678 6.74315 14.6018L6.75 14.5V5.5C6.75 5.08579 6.41421 4.75 6 4.75ZM14.2803 4.96967C14.0141 4.7034 13.5974 4.6792 13.3038 4.89705L13.2197 4.96967L8.71967 9.46967C8.4534 9.73594 8.4292 10.1526 8.64705 10.4462L8.71967 10.5303L13.2197 15.0303C13.5126 15.3232 13.9874 15.3232 14.2803 15.0303C14.5466 14.7641 14.5708 14.3474 14.3529 14.0538L14.2803 13.9697L10.3107 10L14.2803 6.03033C14.5732 5.73744 14.5732 5.26256 14.2803 4.96967Z " },
            { FluentSymbol.ArrowPrevious20, "M6 5C5.75454 5 5.55039 5.17688 5.50806 5.41012L5.5 5.5V14.5C5.5 14.7761 5.72386 15 6 15C6.24546 15 6.44961 14.8231 6.49194 14.5899L6.5 14.5V5.5C6.5 5.22386 6.27614 5 6 5ZM13.8536 5.14645C13.68 4.97288 13.4106 4.9536 13.2157 5.08859L13.1464 5.14645L8.64645 9.64645C8.47288 9.82001 8.4536 10.0894 8.58859 10.2843L8.64645 10.3536L13.1464 14.8536C13.3417 15.0488 13.6583 15.0488 13.8536 14.8536C14.0271 14.68 14.0464 14.4106 13.9114 14.2157L13.8536 14.1464L9.70711 10L13.8536 5.85355C14.0488 5.65829 14.0488 5.34171 13.8536 5.14645Z " },
            { FluentSymbol.ArrowPrevious24Filled, "M6 3C5.48716 3 5.06449 3.38604 5.00673 3.88338L5 4V20C5 20.5523 5.44772 21 6 21C6.51284 21 6.93551 20.614 6.99327 20.1166L7 20V4C7 3.44772 6.55228 3 6 3ZM18.7071 3.29289C18.3466 2.93241 17.7794 2.90468 17.3871 3.2097L17.2929 3.29289L9.29289 11.2929C8.93241 11.6534 8.90468 12.2206 9.2097 12.6129L9.29289 12.7071L17.2929 20.7071C17.6834 21.0976 18.3166 21.0976 18.7071 20.7071C19.0676 20.3466 19.0953 19.7794 18.7903 19.3871L18.7071 19.2929L11.4142 12L18.7071 4.70711C19.0976 4.31658 19.0976 3.68342 18.7071 3.29289Z " },
            { FluentSymbol.ArrowPrevious24, "M5.75 3C5.3703 3 5.05651 3.28215 5.00685 3.64823L5 3.75V20.25C5 20.6642 5.33579 21 5.75 21C6.1297 21 6.44349 20.7178 6.49315 20.3518L6.5 20.25V3.75C6.5 3.33579 6.16421 3 5.75 3ZM18.7803 3.21967C18.5141 2.9534 18.0974 2.9292 17.8038 3.14705L17.7197 3.21967L9.46967 11.4697C9.2034 11.7359 9.1792 12.1526 9.39705 12.4462L9.46967 12.5303L17.7197 20.7803C18.0126 21.0732 18.4874 21.0732 18.7803 20.7803C19.0466 20.5141 19.0708 20.0974 18.8529 19.8038L18.7803 19.7197L11.0607 12L18.7803 4.28033C19.0732 3.98744 19.0732 3.51256 18.7803 3.21967Z " },
            { FluentSymbol.ArrowRedo20Filled, "M13.1408 6.5H10.7532C10.3389 6.5 10.0032 6.83579 10.0032 7.25C10.0032 7.66422 10.3389 8 10.7532 8H15.1532C15.6226 8 16.0032 7.61945 16.0032 7.15V2.75C16.0032 2.33579 15.6674 2 15.2532 2C14.8389 2 14.5032 2.33579 14.5032 2.75V5.6968L11.4444 3.03785C9.25611 1.13561 5.94009 1.36749 4.03785 3.55577C2.13561 5.74405 2.36749 9.06006 4.55577 10.9623L12.7277 18.066C13.0403 18.3378 13.514 18.3047 13.7858 17.992C14.0575 17.6794 14.0244 17.2057 13.7118 16.934L5.53986 9.83024C3.9768 8.4715 3.81118 6.10291 5.16992 4.53986C6.52866 2.9768 8.89725 2.81118 10.4603 4.16992L13.1408 6.5Z " },
            { FluentSymbol.ArrowRedo20, "M15.003 2.5C15.003 2.22386 15.2269 2 15.503 2C15.7792 2 16.003 2.22386 16.003 2.5V7.4C16.003 7.73137 15.7344 8 15.403 8H10.503C10.2269 8 10.003 7.77614 10.003 7.5C10.003 7.22386 10.2269 7 10.503 7H14.097L10.6243 3.98124C8.95706 2.53191 6.43056 2.70858 4.98124 4.37584C3.53191 6.0431 3.70858 8.56959 5.37584 10.0189L13.5477 17.1226C13.7562 17.3038 13.7782 17.6196 13.5971 17.828C13.4159 18.0364 13.1001 18.0585 12.8917 17.8774L4.71978 10.7736C2.63571 8.96197 2.41487 5.80385 4.22653 3.71978C6.03818 1.63571 9.1963 1.41487 11.2804 3.22653L15.003 6.46259V2.5Z " },
            { FluentSymbol.ArrowRedo24Filled, "M18.0001 7.586L14.359 3.95091C11.7578 1.3497 7.54042 1.3497 4.9392 3.95091C2.33798 6.55213 2.33798 10.7695 4.9392 13.3708L13.2777 21.7078C13.6683 22.0982 14.3014 22.098 14.6919 21.7075C15.0824 21.317 15.0822 20.6838 14.6916 20.2933L6.35341 11.9565C4.53324 10.1364 4.53324 7.1853 6.35341 5.36513C8.1167 3.60184 10.9413 3.54674 12.7714 5.20025L12.9453 5.36561L16.5851 8.999L12.0001 8.99954C11.4873 8.99954 11.0646 9.38558 11.0069 9.88291L11.0001 9.99954C11.0001 10.5124 11.3862 10.935 11.8835 10.9928L12.0001 10.9995H19.0001C19.513 10.9995 19.9356 10.6135 19.9934 10.1162L20.0001 9.99954V3.00235C20.0001 2.45007 19.5524 2.00235 19.0001 2.00235C18.4873 2.00235 18.0646 2.38839 18.0069 2.88573L18.0001 3.00235V7.586L14.359 3.95091L18.0001 7.586Z " },
            { FluentSymbol.ArrowRedo24, "M19.2501 2C18.8704 2 18.5566 2.28215 18.507 2.64823L18.5001 2.75V8.44L13.9258 3.88014C11.4838 1.43819 7.56165 1.37863 5.0475 3.70146L4.86162 3.88014C2.35863 6.38313 2.35863 10.4413 4.86162 12.9443L13.7068 21.7835C13.9998 22.0762 14.4745 22.0759 14.7674 21.783C15.0603 21.4901 15.06 21.0151 14.767 20.7223L5.92228 11.8836C4.00507 9.96641 4.00507 6.85801 5.92228 4.9408C7.78139 3.08169 10.7606 3.02535 12.6883 4.77248L12.8659 4.94156L17.4381 9.5L11.7501 9.50018C11.3704 9.50018 11.0566 9.78234 11.007 10.1484L11.0001 10.2502C11.0001 10.6299 11.2823 10.9437 11.6483 10.9933L11.7501 11.0002H19.2501C19.6298 11.0002 19.9436 10.718 19.9933 10.352L20.0001 10.2502V2.75C20.0001 2.33579 19.6643 2 19.2501 2Z " },
            { FluentSymbol.ArrowRedo32Filled, "M27.0021 4.25488C27.0021 3.56453 26.4425 3.00488 25.7521 3.00488C25.0617 3.00488 24.5021 3.56453 24.5021 4.25488V10.4361L19.9056 5.63859C18.6842 4.34538 16.6534 3.31303 14.4245 3.0965C12.1452 2.87508 9.60776 3.50425 7.4959 5.61609C5.34673 7.76525 4.78354 10.2757 4.99505 12.4468C5.20007 14.5513 6.13808 16.4048 7.11396 17.3819L7.11591 17.3839L18.3224 28.6803C18.8086 29.1704 19.6 29.1736 20.0901 28.6874C20.5802 28.2012 20.5834 27.4097 20.0972 26.9196L8.8872 15.6196L8.88367 15.6161C8.36024 15.0927 7.63853 13.7981 7.48327 12.2044C7.33437 10.6759 7.71119 8.93633 9.26366 7.38386C10.7888 5.85871 12.5613 5.42727 14.1828 5.58479C15.8525 5.74699 17.3113 6.53129 18.0903 7.35748L18.0972 7.36473L23.0363 12.5199H16.5997C15.9093 12.5199 15.3497 13.0796 15.3497 13.7699C15.3497 14.4603 15.9093 15.0199 16.5997 15.0199H25.7521C26.4425 15.0199 27.0021 14.4603 27.0021 13.7699V4.25488Z " },
            { FluentSymbol.ArrowRedo32, "M8.62617 7.04596C9.90571 5.60136 11.5617 4.90163 13.2421 4.94851C14.9202 4.99533 16.7127 5.791 18.2406 7.51073L23.6156 14.0001H14.9999C14.4476 14.0001 13.9999 14.4478 13.9999 15.0001C13.9999 15.5524 14.4476 16.0001 14.9999 16.0001H25.9999C26.5522 16.0001 26.9999 15.5524 26.9999 15.0001V4.00013C26.9999 3.44784 26.5522 3.00013 25.9999 3.00013C25.4476 3.00013 24.9999 3.44784 24.9999 4.00013V12.5361L19.7595 6.20924L19.7486 6.19689C17.898 4.107 15.5991 3.01349 13.2978 2.94928C10.9948 2.88503 8.78008 3.85582 7.12901 5.71987C3.7959 9.48296 4.82567 14.3848 7.13997 16.913L7.14728 16.921L12.7244 22.7548L12.7284 22.7589L18.1617 28.3774L18.1652 28.3809L18.4757 28.6988C18.8615 29.0939 19.4947 29.1014 19.8898 28.7155C20.2849 28.3297 20.2924 27.6965 19.9065 27.3014L19.5994 26.9871L19.596 26.9835L14.1701 21.3727L14.1661 21.3686L8.60823 15.555C6.85346 13.6303 6.10143 9.8964 8.62617 7.04596Z " },
            { FluentSymbol.ArrowRedo48Filled, "M41.002 5.5C41.002 4.67157 40.3304 4 39.502 4C38.6736 4 38.002 4.67157 38.002 5.5V16.9849L30.1008 8.9227C24.5288 2.62347 15.1507 2.76198 10.1713 8.2524C5.17037 13.7666 6.79466 21.5619 10.1426 25.4751L10.1515 25.4855L12.4098 28.0291L14.9467 30.5661L19.1939 34.7265L27.4357 43.0551L27.4412 43.0606L27.9375 43.5569C28.5233 44.1427 29.473 44.1427 30.0588 43.5569C30.6446 42.9711 30.6446 42.0213 30.0588 41.4355L29.5681 40.9449L29.5625 40.9393L21.3099 32.5997L17.057 28.4337L14.5941 25.9708L12.4136 23.5148C9.77888 20.425 8.67196 14.3713 12.3935 10.2678C16.1324 6.14511 23.4442 5.89718 27.8756 10.9352L27.9023 10.9655L35.7763 19H24.502C23.6736 19 23.002 19.6716 23.002 20.5C23.002 21.3284 23.6736 22 24.502 22H39.502C40.3304 22 41.002 21.3284 41.002 20.5V5.5Z " },
            { FluentSymbol.ArrowRedo48, "M12.1497 9.83982C16.3233 5.23784 23.4524 5.33466 28.0048 10.5101L28.0217 10.5294L36.5802 19.4882H24.2007C23.5103 19.4882 22.9507 20.0478 22.9507 20.7382C22.9507 21.4285 23.5103 21.9882 24.2007 21.9882H39.7455C40.4359 21.9882 40.9955 21.4285 40.9955 20.7382V5.26886C40.9955 4.5785 40.4359 4.01886 39.7455 4.01886C39.0551 4.01886 38.4955 4.5785 38.4955 5.26886V17.8739L29.8646 8.83922C24.4154 2.66488 15.5577 2.36064 10.2979 8.16035C5.05798 13.9381 6.67587 21.4757 10.3118 25.3549L10.3211 25.3648L19.3001 34.5376L19.3051 34.5428L28.0551 43.3796L28.0594 43.384L28.3104 43.6349C28.7985 44.1231 29.59 44.1231 30.0782 43.6349C30.5663 43.1468 30.5663 42.3553 30.0782 41.8672L29.8316 41.6206L29.8272 41.6162L21.0866 32.7889L21.0816 32.7837L12.1269 23.6357C9.20821 20.5121 7.95489 14.4652 12.1497 9.83982Z " },
            { FluentSymbol.ArrowRepeatAll16Filled, "M12.75 5.51475C13.0059 5.51475 13.2318 5.64287 13.3672 5.83846L13.4076 5.9038C13.7833 6.51359 14 7.23137 14 7.99975C14 10.1419 12.316 11.8908 10.1996 11.9949L10 11.9997L7.555 11.999L8.27742 12.7211C8.54369 12.9874 8.56789 13.404 8.35004 13.6977L8.27742 13.7818C8.01115 14.048 7.59449 14.0723 7.30088 13.8544L7.21676 13.7818L5.21506 11.7801C4.94879 11.5138 4.92459 11.0971 5.14244 10.8035L5.21506 10.7194L7.21676 8.71772C7.50965 8.42482 7.98453 8.42482 8.27742 8.71772C8.54369 8.98398 8.56789 9.40065 8.35004 9.69426L8.27742 9.77838L7.556 10.499L10 10.4997C11.3255 10.4997 12.41 9.46821 12.4947 8.16412L12.5 7.99975C12.5 7.5052 12.3564 7.04419 12.1086 6.65615C12.0404 6.54267 12 6.40843 12 6.26475C12 5.85053 12.3358 5.51475 12.75 5.51475ZM7.71967 2.21772C7.98594 1.95145 8.4026 1.92724 8.69621 2.1451L8.78033 2.21772L10.782 4.21942L10.8546 4.30354C11.0483 4.56452 11.0507 4.92274 10.8618 5.18613L10.782 5.28008L8.78033 7.28178L8.69621 7.3544C8.43522 7.54804 8.07701 7.55044 7.81362 7.36157L7.71967 7.28178L7.64705 7.19766C7.4534 6.93667 7.45101 6.57846 7.63988 6.31507L7.71967 6.22112L8.441 5.49905L6 5.49975C4.67452 5.49975 3.58996 6.53128 3.50532 7.83537L3.5 7.99975C3.5 8.42117 3.60427 8.81823 3.78842 9.16656L3.8976 9.35121C3.96269 9.46232 4 9.59168 4 9.72975C4 10.144 3.66421 10.4798 3.25 10.4798C2.98206 10.4798 2.74693 10.3392 2.61428 10.1279C2.22529 9.5142 2 8.78328 2 7.99975C2 5.85755 3.68397 4.10867 5.80036 4.00464L6 3.99975L8.44 3.99905L7.71967 3.27838L7.64705 3.19426C7.4292 2.90065 7.4534 2.48398 7.71967 2.21772Z " },
            { FluentSymbol.ArrowRepeatAll16, "M12.8935 5.23788C13.579 5.95588 14 6.92865 14 7.99975C14 10.1419 12.316 11.8908 10.1996 11.9949L10 11.9997L6.707 11.999L7.85525 13.1479C8.02882 13.3215 8.0481 13.5909 7.91311 13.7858L7.85525 13.855C7.68169 14.0286 7.41226 14.0479 7.21739 13.9129L7.14815 13.855L5.14645 11.8533C4.97288 11.6797 4.9536 11.4103 5.08859 11.2154L5.14645 11.1462L7.14815 9.14449C7.34341 8.94923 7.65999 8.94923 7.85525 9.14449C8.02882 9.31806 8.0481 9.58748 7.91311 9.78235L7.85525 9.8516L6.707 10.999L10 10.9997C11.5977 10.9997 12.9037 9.75083 12.9949 8.17602L13 7.99975C13 7.17778 12.6694 6.43303 12.134 5.89117C12.0522 5.80305 12 5.68194 12 5.54865C12 5.2725 12.2239 5.04865 12.5 5.04865C12.6227 5.04865 12.7351 5.09286 12.8221 5.16624L12.8935 5.23788ZM8.78431 2.08664L8.85355 2.14449L10.8553 4.14619L10.9131 4.21544C11.0312 4.38595 11.0312 4.61354 10.9131 4.78405L10.8553 4.8533L8.85355 6.855L8.78431 6.91286C8.6138 7.03098 8.3862 7.03098 8.21569 6.91286L8.14645 6.855L8.08859 6.78575C7.97047 6.61524 7.97047 6.38765 8.08859 6.21714L8.14645 6.14789L9.294 4.99905L6 4.99975C4.40232 4.99975 3.09634 6.24867 3.00509 7.82347L3 7.99975C3 8.8193 3.32863 9.56209 3.8613 10.1035C3.94745 10.1919 4 10.3134 4 10.4472C4 10.7234 3.77614 10.9472 3.5 10.9472C3.36244 10.9472 3.23785 10.8917 3.14745 10.8018C2.4379 10.0823 2 9.09214 2 7.99975C2 5.85755 3.68397 4.10867 5.80036 4.00464L6 3.99975L9.294 3.99905L8.14645 2.8516L8.08859 2.78235C7.9536 2.58748 7.97288 2.31806 8.14645 2.14449C8.32001 1.97093 8.58944 1.95164 8.78431 2.08664Z " },
            { FluentSymbol.ArrowRepeatAll20Filled, "M15.75 6.01C15.9293 6.01 16.0939 6.07292 16.2229 6.17788C17.3108 7.09184 18.0024 8.46516 18.0024 10C18.0024 12.6888 15.8801 14.8818 13.2193 14.9954L13.0024 15H8.56056L9.78031 16.2197C10.0466 16.4859 10.0708 16.9026 9.85293 17.1962L9.78031 17.2803C9.51404 17.5466 9.09738 17.5708 8.80377 17.3529L8.71965 17.2803L6.21965 14.7803C5.95338 14.5141 5.92917 14.0974 6.14703 13.8038L6.21965 13.7197L8.71965 11.2197C9.01254 10.9268 9.48741 10.9268 9.78031 11.2197C10.0466 11.4859 10.0708 11.9026 9.85293 12.1962L9.78031 12.2803L8.56056 13.5H13.0024C14.871 13.5 16.3975 12.0357 16.4972 10.192L16.5024 10C16.5024 8.91885 16.0122 7.95219 15.2419 7.31017C15.0935 7.17538 15 6.97861 15 6.76C15 6.34579 15.3358 6.01 15.75 6.01ZM10.2196 2.71967C10.4859 2.4534 10.9026 2.4292 11.1962 2.64705L11.2803 2.71967L13.7803 5.21967L13.8529 5.30379C14.0466 5.56478 14.049 5.92299 13.8601 6.18638L13.7803 6.28033L11.2803 8.78033L11.1962 8.85295C10.9352 9.0466 10.577 9.04899 10.3136 8.86012L10.2196 8.78033L10.147 8.69621C9.95338 8.43522 9.95099 8.07701 10.1399 7.81362L10.2196 7.71967L11.4386 6.5H6.99756C5.129 6.5 3.60243 7.96428 3.50274 9.80796L3.49756 10C3.49756 11.0831 3.98957 12.0514 4.76229 12.6934C4.90848 12.8289 4.99998 13.0238 4.99998 13.24C4.99998 13.6542 4.66419 13.99 4.24998 13.99C4.05869 13.99 3.88413 13.9184 3.75164 13.8005C2.67864 12.8872 1.99756 11.5232 1.99756 10C1.99756 7.31124 4.11987 5.11818 6.78067 5.00462L6.99756 5H11.4386L10.2196 3.78033L10.147 3.69621C9.92918 3.4026 9.95338 2.98594 10.2196 2.71967Z " },
            { FluentSymbol.ArrowRepeatAll20, "M16.5 6.67122C16.6163 6.67122 16.7233 6.71092 16.8082 6.77751L16.8755 6.84057L16.8918 6.86057C17.5849 7.71877 18 8.81091 18 10C18 12.6888 15.8777 14.8818 13.2169 14.9954L13 15H7C6.89826 15 6.79724 14.997 6.697 14.991L8.35355 16.6464C8.52712 16.82 8.5464 17.0894 8.41141 17.2843L8.35355 17.3536C8.17999 17.5271 7.91056 17.5464 7.71569 17.4114L7.64645 17.3536L5.14645 14.8536C4.97288 14.68 4.9536 14.4106 5.08859 14.2157L5.14645 14.1464L7.64645 11.6464C7.84171 11.4512 8.15829 11.4512 8.35355 11.6464C8.52712 11.82 8.5464 12.0894 8.41141 12.2843L8.35355 12.3536L6.71699 13.9901L6.85787 13.9975L7 14H13C15.2091 14 17 12.2091 17 10C17 9.04652 16.6664 8.17096 16.1095 7.48367C16.0414 7.39911 16 7.29 16 7.17122C16 6.89508 16.2239 6.67122 16.5 6.67122ZM11.6464 2.64645C11.82 2.47288 12.0894 2.4536 12.2843 2.58859L12.3536 2.64645L14.8536 5.14645L14.9114 5.21569C15.0295 5.3862 15.0295 5.6138 14.9114 5.78431L14.8536 5.85355L12.3536 8.35355L12.2843 8.41141C12.1138 8.52953 11.8862 8.52953 11.7157 8.41141L11.6464 8.35355L11.5886 8.28431C11.4705 8.1138 11.4705 7.8862 11.5886 7.71569L11.6464 7.64645L13.283 6.00986L13.1421 6.00248L13 6H7C4.79086 6 3 7.79086 3 10C3 10.9563 3.33557 11.8342 3.89537 12.5224C3.95954 12.606 4 12.7139 4 12.8313C4 13.1074 3.77614 13.3313 3.5 13.3313C3.333 13.3313 3.18512 13.2494 3.09432 13.1236C2.40993 12.2676 2 11.1817 2 10C2 7.31124 4.12231 5.11818 6.78311 5.00462L7 5H13C13.1017 5 13.2028 5.00304 13.303 5.00903L11.6464 3.35355L11.5886 3.28431C11.4536 3.08944 11.4729 2.82001 11.6464 2.64645Z " },
            { FluentSymbol.ArrowRepeatAll24Filled, "M14.7123 2.28878L14.6251 2.21113C14.2326 1.90052 13.6607 1.92641 13.2981 2.28878L13.2204 2.37594C12.9096 2.76818 12.9355 3.33963 13.2981 3.702L14.597 4.99899L8.99921 4.99919L8.75859 5.00325C5.00445 5.12998 2 8.21112 2 11.9935C2 13.4382 2.43833 14.7806 3.18863 15.8918C3.37024 16.1432 3.666 16.3068 4 16.3068C4.55228 16.3068 5 15.8594 5 15.3075C5 15.0914 4.93132 14.8912 4.81525 14.7288L4.68008 14.5107C4.24775 13.7716 4 12.9114 4 11.9935C4 9.23444 6.23822 6.99779 8.99921 6.99779L14.595 6.99758L13.2981 8.29497L13.2204 8.38213C12.9096 8.77438 12.9355 9.34582 13.2981 9.7082C13.6886 10.0984 14.3218 10.0984 14.7123 9.7082L17.7175 6.7051L17.7952 6.61794C18.106 6.2257 18.0801 5.65425 17.7175 5.29188L14.7123 2.28878ZM20.7865 8.06013C20.6034 7.82751 20.3191 7.67811 20 7.67811C19.4477 7.67811 19 8.12551 19 8.67741C19 8.88559 19.0637 9.0789 19.1717 9.23841C19.6952 10.0282 20 10.9753 20 11.9935C20 14.7525 17.7618 16.9892 15.0008 16.9892L9.415 16.9886L10.7087 15.6972L10.7923 15.6025C11.0733 15.2408 11.0713 14.7307 10.7864 14.3712L10.7087 14.284L10.6139 14.2004C10.252 13.9196 9.7415 13.9216 9.38169 14.2063L9.29447 14.284L6.28926 17.2871L6.20562 17.3818C5.92465 17.7435 5.92663 18.2536 6.21156 18.6132L6.28926 18.7003L9.29447 21.7034L9.38867 21.7865C9.78097 22.0913 10.3482 22.0636 10.7087 21.7034C11.0713 21.341 11.0972 20.7696 10.7864 20.3773L10.7087 20.2902L9.405 18.9872L15.0008 18.9878L15.2414 18.9837C18.9956 18.857 22 15.7759 22 11.9935C22 10.5336 21.5524 9.17809 20.7868 8.05666L20.7865 8.06013Z " },
            { FluentSymbol.ArrowRepeatAll24, "M14.6102 2.47047L14.5334 2.4031C14.2394 2.17855 13.818 2.20101 13.5495 2.47047L13.4824 2.54755C13.2587 2.84259 13.281 3.26552 13.5495 3.53498L15.521 5.5118H8.5L8.26687 5.51592C4.785 5.63911 2 8.51085 2 12.0354C2 13.7259 2.6407 15.2663 3.6917 16.4252L3.76407 16.4947C3.89496 16.6065 4.06463 16.674 4.25 16.674C4.66421 16.674 5 16.337 5 15.9213C5 15.7481 4.9417 15.5885 4.84373 15.4613L4.64439 15.2306C3.92953 14.3627 3.5 13.2494 3.5 12.0354C3.5 9.26396 5.73858 7.01725 8.5 7.01725H15.381L13.5495 8.85754L13.4824 8.93463C13.2587 9.22967 13.281 9.6526 13.5495 9.92206C13.8424 10.216 14.3173 10.216 14.6102 9.92206L17.7922 6.72852L17.8593 6.65144C18.083 6.3564 18.0606 5.93347 17.7922 5.66401L14.6102 2.47047ZM20.23 7.57108C20.0999 7.46224 19.9326 7.39677 19.75 7.39677C19.3358 7.39677 19 7.73378 19 8.14949C19 8.33618 19.0677 8.507 19.1791 8.63722C19.9992 9.53109 20.5 10.7246 20.5 12.0354C20.5 14.8069 18.2614 17.0536 15.5 17.0536H8.558L10.4634 15.1425L10.5365 15.0573C10.7339 14.7897 10.7319 14.4206 10.5305 14.155L10.4634 14.0779L10.3785 14.0045C10.1119 13.8065 9.74409 13.8085 9.47951 14.0106L9.40271 14.0779L6.22073 17.2715L6.14756 17.3566C5.95023 17.6242 5.95224 17.9934 6.15361 18.2589L6.22073 18.336L9.40271 21.5295L9.48683 21.6024C9.78044 21.8211 10.1971 21.7968 10.4634 21.5295C10.7319 21.2601 10.7542 20.8371 10.5305 20.5421L10.4634 20.465L8.564 18.559H15.5L15.7331 18.5549C19.215 18.4317 22 15.56 22 12.0354C22 10.342 21.3571 8.79923 20.3029 7.63965L20.23 7.57108Z " },
            { FluentSymbol.ArrowRepeatAllOff16Filled, "M2.21674 2.21942C2.48301 1.95315 2.89967 1.92894 3.19328 2.1468L3.2774 2.21942L13.7774 12.7194L13.85 12.8035C14.0679 13.0971 14.0437 13.5138 13.7774 13.7801C13.5111 14.0463 13.0945 14.0705 12.8009 13.8527L12.7167 13.7801L10.8458 11.9101C10.6641 11.9493 10.4777 11.9761 10.2877 11.9896L9.99998 11.9997L7.55507 11.999L8.2774 12.7211C8.54367 12.9874 8.56787 13.404 8.35002 13.6977L8.2774 13.7818C8.01113 14.048 7.59447 14.0723 7.30086 13.8544L7.21674 13.7818L5.21504 11.7801C4.94877 11.5138 4.92457 11.0971 5.14242 10.8035L5.21504 10.7194L7.21674 8.71772C7.2947 8.63976 7.38555 8.58255 7.48243 8.54609L4.76353 5.82642C4.00881 6.25672 3.49998 7.06881 3.49998 7.99975C3.49998 8.42117 3.60425 8.81823 3.7884 9.16656L3.89758 9.35121C3.96267 9.46232 3.99998 9.59168 3.99998 9.72975C3.99998 10.144 3.66419 10.4798 3.24998 10.4798C2.98204 10.4798 2.74691 10.3392 2.61426 10.1279C2.22527 9.5142 1.99998 8.78328 1.99998 7.99975C1.99998 6.65609 2.66249 5.46718 3.67866 4.74183L2.21674 3.28008L2.14412 3.19596C1.92627 2.90235 1.95047 2.48568 2.21674 2.21942ZM12.75 5.51475C13.0058 5.51475 13.2318 5.64287 13.3671 5.83846L13.4065 5.90183C13.7829 6.51202 14 7.23053 14 7.99975C14 8.98798 13.6416 9.89252 13.0477 10.5905L11.9817 9.52398C12.3067 9.10208 12.5 8.57348 12.5 7.99975C12.5 7.5052 12.3564 7.04419 12.1086 6.65615C12.0404 6.54267 12 6.40843 12 6.26475C12 5.85053 12.3358 5.51475 12.75 5.51475ZM8.35002 9.69426L8.2774 9.77838L7.55607 10.499H9.43507L8.44936 9.5118C8.42533 9.57591 8.39221 9.63739 8.35002 9.69426ZM7.72256 2.21772C7.98883 1.95145 8.40549 1.92724 8.6991 2.1451L8.78322 2.21772L10.7849 4.21942L10.8575 4.30354C11.0512 4.56452 11.0536 4.92274 10.8647 5.18613L10.7849 5.28008L9.26007 6.80405L8.20007 5.74305L8.44407 5.49905H7.95507L6.45507 3.99905H8.44307L7.72256 3.27838L7.64994 3.19426C7.43209 2.90065 7.45629 2.48398 7.72256 2.21772Z " },
            { FluentSymbol.ArrowRepeatAllOff16, "M2.78431 2.08834L2.85355 2.14619L13.8536 13.1462C14.0488 13.3415 14.0488 13.658 13.8536 13.8533C13.68 14.0269 13.4106 14.0462 13.2157 13.9112L13.1464 13.8533L11.1305 11.8378C10.8437 11.9221 10.5435 11.9752 10.2339 11.993L10 11.9997L6.707 11.999L7.85525 13.1479C8.02882 13.3215 8.0481 13.5909 7.91311 13.7858L7.85525 13.855C7.68169 14.0286 7.41226 14.0479 7.21739 13.9129L7.14815 13.855L5.14645 11.8533C4.97288 11.6797 4.9536 11.4103 5.08859 11.2154L5.14645 11.1462L7.14815 9.14449C7.34341 8.94923 7.65999 8.94923 7.85525 9.14449C8.02882 9.31806 8.0481 9.58748 7.91311 9.78235L7.85525 9.8516L6.707 10.999L10 10.9997C10.0941 10.9997 10.1871 10.9954 10.279 10.9869L4.62614 5.33211C3.66034 5.83052 3 6.83802 3 7.99975C3 8.8193 3.32863 9.56209 3.8613 10.1035C3.94745 10.1919 4 10.3134 4 10.4472C4 10.7234 3.77614 10.9472 3.5 10.9472C3.36244 10.9472 3.23785 10.8917 3.14745 10.8018C2.4379 10.0823 2 9.09214 2 7.99975C2 6.56381 2.75664 5.30459 3.89297 4.59904L2.14645 2.8533C1.95118 2.65804 1.95118 2.34146 2.14645 2.14619C2.32001 1.97263 2.58944 1.95334 2.78431 2.08834ZM12.5 5.04865C12.6227 5.04865 12.7351 5.09286 12.8221 5.16624L12.8935 5.23788C13.579 5.95588 14 6.92865 14 7.99975C14 9.07744 13.5738 10.0556 12.8808 10.7748L12.174 10.0671C12.6858 9.52898 13 8.80105 13 7.99975C13 7.17778 12.6694 6.43303 12.134 5.89117C12.0522 5.80305 12 5.68194 12 5.54865C12 5.2725 12.2239 5.04865 12.5 5.04865ZM8.14645 2.14449C8.32001 1.97093 8.58944 1.95164 8.78431 2.08664L8.85355 2.14449L10.8553 4.14619L10.9131 4.21544C11.0312 4.38595 11.0312 4.61354 10.9131 4.78405L10.8553 4.8533L8.907 6.80005L8.2 6.09305L9.294 4.99905H7.105L6.105 3.99905H9.294L8.14645 2.8516L8.08859 2.78235C7.9536 2.58748 7.97288 2.31806 8.14645 2.14449Z " },
            { FluentSymbol.ArrowRepeatAllOff20Filled, "M2.2218 2.22162C2.48807 1.95536 2.90473 1.93115 3.19834 2.149L3.28246 2.22162L17.7782 16.7173L17.8508 16.8014C18.0686 17.095 18.0444 17.5117 17.7782 17.778C17.5119 18.0442 17.0952 18.0684 16.8016 17.8506L16.7175 17.778L13.8641 14.9258C13.6775 14.9582 13.4873 14.9803 13.2942 14.9914L13.0024 14.9998L8.56056 14.999L9.78031 16.2195C10.0466 16.4857 10.0708 16.9024 9.85293 17.196L9.78031 17.2801C9.51404 17.5464 9.09738 17.5706 8.80377 17.3527L8.71965 17.2801L6.21965 14.7801C5.95338 14.5139 5.92917 14.0972 6.14703 13.8036L6.21965 13.7195L8.71965 11.2195C9.01254 10.9266 9.48741 10.9266 9.78031 11.2195C10.0466 11.4857 10.0708 11.9024 9.85293 12.196L9.78031 12.2801L8.56056 13.499H12.4376L5.69111 6.75177C4.46155 7.2468 3.57779 8.41976 3.50274 9.80776L3.49756 9.9998C3.49756 11.0829 3.98957 12.0512 4.76229 12.6932C4.90848 12.8287 4.99998 13.0236 4.99998 13.2398C4.99998 13.654 4.66419 13.9898 4.24998 13.9898C4.05869 13.9898 3.88413 13.9182 3.75164 13.8003C2.67864 12.887 1.99756 11.523 1.99756 9.9998C1.99756 8.12031 3.03457 6.48303 4.56763 5.62892L2.2218 3.28228L2.14918 3.19816C1.93133 2.90455 1.95554 2.48789 2.2218 2.22162ZM15.75 6.0098C15.9293 6.0098 16.0939 6.07272 16.2229 6.17768C17.3108 7.09163 18.0024 8.46495 18.0024 9.9998C18.0024 11.5196 17.3243 12.881 16.2542 13.798L15.1888 12.733C15.9896 12.0916 16.5024 11.1056 16.5024 9.9998C16.5024 8.91912 16.0126 7.95284 15.2429 7.31081C15.0935 7.17518 15 6.97841 15 6.7598C15 6.34558 15.3358 6.0098 15.75 6.0098ZM10.2196 2.71947C10.4859 2.4532 10.9026 2.42899 11.1962 2.64685L11.2803 2.71947L13.7803 5.21947L13.8529 5.30359C14.0466 5.56457 14.049 5.92279 13.8601 6.18618L13.7803 6.28013L11.2803 8.78013L11.2556 8.80095L10.1986 7.74395L10.2196 7.71947L11.4386 6.49895H8.95256L7.45156 4.99895H11.4386L10.2196 3.78013L10.147 3.69601C9.92918 3.4024 9.95338 2.98573 10.2196 2.71947Z " },
            { FluentSymbol.ArrowRepeatAllOff20, "M2.14645 2.14645C2.32001 1.97288 2.58944 1.9536 2.78431 2.08859L2.85355 2.14645L17.8536 17.1464L17.9114 17.2157C18.0464 17.4106 18.0271 17.68 17.8536 17.8536C17.68 18.0271 17.4106 18.0464 17.2157 17.9114L17.1464 17.8536L14.158 14.8652C13.8792 14.9313 13.5915 14.9741 13.2968 14.9913L13 15H7C6.89793 15 6.79657 14.9969 6.69601 14.9909L8.35355 16.6464C8.52712 16.82 8.5464 17.0894 8.41141 17.2843L8.35355 17.3536C8.17999 17.5271 7.91056 17.5464 7.71569 17.4114L7.64645 17.3536L5.14645 14.8536C4.97288 14.68 4.9536 14.4106 5.08859 14.2157L5.14645 14.1464L7.64645 11.6464C7.84171 11.4512 8.15829 11.4512 8.35355 11.6464C8.52712 11.82 8.5464 12.0894 8.41141 12.2843L8.35355 12.3536L6.71799 13.9902L6.85838 13.9975L7 14H13C13.0951 14 13.1895 13.9967 13.283 13.9901L5.5602 6.26696C4.06248 6.845 3 8.29842 3 10C3 10.9563 3.33557 11.8342 3.89537 12.5224C3.95954 12.606 4 12.7139 4 12.8313C4 13.1074 3.77614 13.3313 3.5 13.3313C3.333 13.3313 3.18512 13.2494 3.09432 13.1236C2.40993 12.2676 2 11.1817 2 10C2 8.02733 3.14239 6.32148 4.80169 5.50793L2.14645 2.85355L2.08859 2.78431C1.9536 2.58944 1.97288 2.32001 2.14645 2.14645ZM16.5 6.67122C16.6163 6.67122 16.7233 6.71092 16.8082 6.77751L16.8755 6.84057L16.8918 6.86057C17.5849 7.71877 18 8.81091 18 10C18 11.6082 17.2408 13.0391 16.0611 13.9537L15.3465 13.2398C16.3484 12.5129 17 11.3325 17 10C17 9.04652 16.6664 8.17096 16.1095 7.48367C16.0414 7.39911 16 7.29 16 7.17122C16 6.89508 16.2239 6.67122 16.5 6.67122ZM12.2843 2.58859L12.3536 2.64645L14.8536 5.14645C15.0271 5.32001 15.0464 5.58944 14.9114 5.78431L14.8536 5.85355L12.3536 8.35355C12.1583 8.54882 11.8417 8.54882 11.6464 8.35355C11.4729 8.17999 11.4536 7.91056 11.5886 7.71569L11.6464 7.64645L13.283 6.00986L13.1421 6.00248L13 6H8.106L7.106 5H13C13.1021 5 13.2034 5.00306 13.304 5.00909L11.6464 3.35355C11.4729 3.17999 11.4536 2.91056 11.5886 2.71569L11.6464 2.64645C11.82 2.47288 12.0894 2.4536 12.2843 2.58859Z " },
            { FluentSymbol.ArrowRepeatAllOff24Filled, "M3.6129 2.20943L3.70711 2.29262L21.7071 20.2926C22.0976 20.6831 22.0976 21.3163 21.7071 21.7068C21.3466 22.0673 20.7794 22.095 20.3871 21.79L20.2929 21.7068L17.2249 18.639C16.626 18.8395 15.991 18.9613 15.3321 18.992L15.0008 18.9997L9.405 18.9991L10.7087 20.303L10.7864 20.3902C11.0972 20.7828 11.0713 21.3546 10.7087 21.7172C10.3482 22.0777 9.78097 22.1055 9.38867 21.8004L9.29447 21.7172L6.28926 18.712L6.21156 18.6248C5.92663 18.265 5.92465 17.7545 6.20562 17.3926L6.28926 17.2978L9.29447 14.2926L9.38169 14.2149C9.7415 13.93 10.252 13.928 10.6139 14.209L10.7087 14.2926L10.7864 14.3798C11.0713 14.7396 11.0733 15.2501 10.7923 15.612L10.7087 15.7068L9.415 16.9991L15.0008 16.9997C15.1879 16.9997 15.3726 16.9894 15.5544 16.9694L6.34801 7.76142C4.93774 8.64529 4 10.2134 4 12.0005C4 12.9191 4.24775 13.7798 4.68008 14.5195L4.81525 14.7377C4.93132 14.9003 5 15.1006 5 15.3169C5 15.8692 4.55228 16.3169 4 16.3169C3.666 16.3169 3.37024 16.1531 3.18863 15.9015C2.43833 14.7896 2 13.4462 2 12.0005C2 9.66244 3.14641 7.59213 4.90779 6.32103L2.29289 3.70683C1.90237 3.31631 1.90237 2.68314 2.29289 2.29262C2.65338 1.93213 3.22061 1.9044 3.6129 2.20943ZM20 7.6821C20.3191 7.6821 20.6034 7.8316 20.7865 8.06438L20.84 8.13937L20.8569 8.1663C21.5797 9.2672 22 10.5848 22 12.0005C22 13.9776 21.1803 15.7632 19.8621 17.036L18.447 15.6221C19.4037 14.7114 20 13.4256 20 12.0005C20 11.0746 19.7483 10.2075 19.3095 9.46383L19.1724 9.24451C19.064 9.0847 19 8.89087 19 8.6821C19 8.12982 19.4477 7.6821 20 7.6821ZM14.6251 2.21128L14.7123 2.28899L17.7175 5.29419C18.0801 5.65682 18.106 6.22867 17.7952 6.62118L17.7175 6.7084L14.7123 9.71361C14.3218 10.1041 13.6886 10.1041 13.2981 9.71361C12.9355 9.35098 12.9096 8.77913 13.2204 8.38662L13.2981 8.2994L14.595 7.00109H9.826L7.91134 5.08534C8.1887 5.04205 8.47145 5.01506 8.75859 5.00536L8.99921 5.0013L14.597 5.00109L13.2981 3.7032C12.9355 3.34057 12.9096 2.76873 13.2204 2.37621L13.2981 2.28899C13.6607 1.92636 14.2326 1.90046 14.6251 2.21128Z " },
            { FluentSymbol.ArrowRepeatAllOff24, "M3.19621 2.14705L3.28033 2.21967L21.7803 20.7197C22.0732 21.0126 22.0732 21.4874 21.7803 21.7803C21.5141 22.0466 21.0974 22.0708 20.8038 21.8529L20.7197 21.7803L17.211 18.2725C16.7749 18.3911 16.3205 18.4656 15.853 18.4906L15.5 18.5H8.564L10.4634 20.3991L10.5305 20.4759C10.7542 20.7699 10.7319 21.1913 10.4634 21.4598C10.1971 21.726 9.78044 21.7502 9.48683 21.5324L9.40271 21.4598L6.22073 18.2778L6.15361 18.201C5.95224 17.9364 5.95023 17.5686 6.14756 17.302L6.22073 17.2171L9.40271 14.0351L9.47951 13.968C9.74409 13.7667 10.1119 13.7646 10.3785 13.962L10.4634 14.0351L10.5305 14.1119C10.7319 14.3765 10.7339 14.7443 10.5365 15.0109L10.4634 15.0958L8.558 17H15.5C15.642 17 15.7825 16.9941 15.9215 16.9825L6.40042 7.46086C4.68788 8.25433 3.5 9.98844 3.5 12C3.5 13.296 3.99309 14.4769 4.80189 15.3652C4.92475 15.4972 5 15.6758 5 15.8718C5 16.286 4.66421 16.6218 4.25 16.6218C4.02803 16.6218 3.82858 16.5254 3.69126 16.3722C2.6407 15.2192 2 13.6844 2 12C2 9.57872 3.32389 7.46665 5.28729 6.34818L2.21967 3.28033C1.92678 2.98744 1.92678 2.51256 2.21967 2.21967C2.48594 1.9534 2.9026 1.9292 3.19621 2.14705ZM19.75 7.37814C19.9691 7.37814 20.1662 7.47209 20.3034 7.62189C21.3571 8.77553 22 10.3127 22 12C22 14.0566 21.0449 15.8901 19.554 17.0812L18.4851 16.0115C19.708 15.1 20.5 13.6425 20.5 12C20.5 10.6939 19.9992 9.50473 19.1791 8.61411C19.0677 8.48435 19 8.31416 19 8.12814C19 7.71393 19.3358 7.37814 19.75 7.37814ZM14.5334 2.40255L14.6102 2.46967L17.7922 5.65165C18.0606 5.92014 18.083 6.34154 17.8593 6.63551L17.7922 6.71231L14.6102 9.89429C14.3173 10.1872 13.8424 10.1872 13.5495 9.89429C13.281 9.62581 13.2587 9.20441 13.4824 8.91043L13.5495 8.83363L15.381 7H9.473L7.99365 5.51943C8.08422 5.51245 8.1753 5.50733 8.26687 5.5041L8.5 5.5L15.5211 5.50003L13.5495 3.53033C13.281 3.26184 13.2587 2.84044 13.4824 2.54647L13.5495 2.46967C13.818 2.20118 14.2394 2.17881 14.5334 2.40255Z " },
            { FluentSymbol.ArrowReply16Filled, "M4.30981 7.99984L6.56567 10.2556C6.85856 10.5485 6.85856 11.0233 6.56567 11.3162C6.2994 11.5825 5.88274 11.6067 5.58913 11.3889L5.50501 11.3162L1.96948 7.78071L1.90091 7.70191L1.86037 7.64254L1.81129 7.54827L1.77848 7.45647L1.76259 7.38866L1.75368 7.32678L1.75 7.23316L1.75368 7.17398L1.7693 7.08003L1.79975 6.98075L1.84617 6.88221L1.88098 6.82651C1.90656 6.78912 1.93612 6.7534 1.96948 6.72005L1.90091 6.79884C1.92193 6.771 1.94485 6.74467 1.96948 6.72005L5.50501 3.18451C5.7979 2.89162 6.27278 2.89162 6.56567 3.18451C6.83194 3.45078 6.85614 3.86744 6.63829 4.16106L6.56567 4.24517L4.30981 6.49984L7.99981 6.50038C11.6513 6.50038 14.1323 8.57702 14.2457 11.5374L14.2498 11.7504C14.2498 12.1646 13.914 12.5004 13.4998 12.5004C13.0856 12.5004 12.7498 12.1646 12.7498 11.7504C12.7498 9.62152 11.0578 8.09249 8.25742 8.00439L7.99981 8.00038L4.30981 7.99984L6.56567 10.2556L4.30981 7.99984Z " },
            { FluentSymbol.ArrowReply16, "M3.707 7.99984L6.38909 10.6824C6.58435 10.8776 6.58435 11.1942 6.38909 11.3895C6.21552 11.563 5.9461 11.5823 5.75123 11.4473L5.68198 11.3895L2.11603 7.82067L2.06639 7.74953L2.03875 7.69372L2.01597 7.62609L2.01109 7.60536C2.00383 7.57168 2 7.53647 2 7.50038L2.00546 7.5743L2.0018 7.54286L2.0018 7.45786L2.01679 7.37155L2.03779 7.30934L2.07719 7.23337L2.13169 7.16222L5.68198 3.61129C5.87724 3.41603 6.19383 3.41603 6.38909 3.61129C6.56265 3.78486 6.58194 4.05428 6.44694 4.24915L6.38909 4.3184L3.707 6.99984L8 7.00038C11.5218 7.00038 13.8854 8.97618 13.9959 11.7928L14 12.0004C14 12.2765 13.7761 12.5004 13.5 12.5004C13.2239 12.5004 13 12.2765 13 12.0004C13 9.72721 11.1925 8.09579 8.26152 8.00442L8 8.00038L3.707 7.99984L6.38909 10.6824L3.707 7.99984Z " },
            { FluentSymbol.ArrowReply20Filled, "M4.31 9.49981L7.27297 12.4628C7.56586 12.7557 7.56586 13.2305 7.27297 13.5234C7.0067 13.7897 6.59004 13.8139 6.29643 13.596L6.21231 13.5234L1.96967 9.28078C1.7034 9.01452 1.6792 8.59785 1.89705 8.30424L1.96967 8.22012L6.21231 3.97748C6.5052 3.68459 6.98008 3.68459 7.27297 3.97748C7.53924 4.24375 7.56344 4.66041 7.34559 4.95402L7.27297 5.03814L4.31 7.99981L10 8.00045C14.1979 8.00045 17.6162 11.3381 17.7462 15.5044L17.75 15.7505C17.75 16.1647 17.4142 16.5005 17 16.5005C16.5858 16.5005 16.25 16.1647 16.25 15.7505C16.25 12.3754 13.5748 9.62514 10.2291 9.50458L10 9.50045L4.31 9.49981L7.27297 12.4628L4.31 9.49981Z " },
            { FluentSymbol.ArrowReply20, "M3.707 8.99981L7.09619 12.3895C7.29146 12.5848 7.29146 12.9014 7.09619 13.0966C6.92263 13.2702 6.6532 13.2895 6.45834 13.1545L6.38909 13.0966L2.14645 8.85401C1.97288 8.68044 1.9536 8.41102 2.08859 8.21615L2.14645 8.1469L6.38909 3.90426C6.58435 3.709 6.90093 3.709 7.09619 3.90426C7.26976 4.07783 7.28905 4.34725 7.15405 4.54212L7.09619 4.61137L3.707 7.99981L10 8.00045C14.0609 8.00045 17.368 11.2279 17.4961 15.2577L17.5 15.5005C17.5 15.7766 17.2761 16.0005 17 16.0005C16.7239 16.0005 16.5 15.7766 16.5 15.5005C16.5 11.9886 13.715 9.1273 10.2331 9.00456L10 9.00045L3.707 8.99981L7.09619 12.3895L3.707 8.99981Z " },
            { FluentSymbol.ArrowReply24Filled, "M9.7042 16.2945C10.0945 16.6853 10.094 17.3184 9.70324 17.7087C9.31245 18.0989 8.67928 18.0985 8.28902 17.7077L3.29241 12.7043C2.90237 12.3137 2.90255 11.681 3.29282 11.2906L8.28943 6.29297C8.67992 5.9024 9.31308 5.90234 9.70365 6.29282C10.0942 6.6833 10.0943 7.31647 9.70379 7.70703L6.411 11H13C17.3349 11 20.8645 14.4478 20.9962 18.7508L21 19C21 19.5523 20.5523 20 20 20C19.4477 20 19 19.5523 19 19C19 15.7616 16.4344 13.1224 13.2249 13.0041L13 13H6.414L9.7042 16.2945Z " },
            { FluentSymbol.ArrowReply24, "M9.2773 16.2211C9.57 16.5142 9.56967 16.9891 9.27658 17.2818C8.98349 17.5745 8.50861 17.5742 8.21592 17.2811L3.21931 12.2776C2.92678 11.9847 2.92692 11.5101 3.21962 11.2174L8.21623 6.21972C8.50909 5.9268 8.98396 5.92675 9.27689 6.21962C9.56981 6.51248 9.56986 6.98735 9.277 7.28028L5.557 11H13.3988C14.9936 11 16.2099 11.242 17.2878 11.7645L17.5342 11.89C18.6427 12.4829 19.5171 13.3573 20.11 14.4658C20.7194 15.6053 21 16.8837 21 18.6012C21 19.0154 20.6642 19.3512 20.25 19.3512C19.8358 19.3512 19.5 19.0154 19.5 18.6012C19.5 17.1174 19.2723 16.0802 18.7872 15.1732C18.3342 14.3261 17.6739 13.6658 16.8268 13.2128C15.9895 12.765 15.0414 12.5365 13.7334 12.5041L13.3988 12.5H5.562L9.2773 16.2211Z " },
            { FluentSymbol.ArrowReply48Filled, "M14.222 22.9996L20.4298 29.2069C21.1132 29.8903 21.1132 30.9984 20.4298 31.6818C19.7866 32.325 18.7673 32.3628 18.0798 31.7953L17.955 31.6818L8.76256 22.4894C8.11935 21.8462 8.08151 20.8268 8.64905 20.1394L8.76256 20.0145L17.955 10.8221C18.6384 10.1387 19.7464 10.1387 20.4298 10.8221C21.073 11.4653 21.1109 12.4847 20.5433 13.1722L20.4298 13.297L14.226 19.4996H22C25.342 19.4996 28.455 20.243 31.1569 21.6667L31.5591 21.8854C34.3216 23.4342 36.5653 25.678 38.1142 28.4404C39.6804 31.2338 40.5 34.4905 40.5 37.9996C40.5 38.9661 39.7165 39.7496 38.75 39.7496C37.7835 39.7496 37 38.9661 37 37.9996C37 35.0795 36.3289 32.4129 35.0613 30.1521C33.8276 27.9516 32.0479 26.172 29.8474 24.9383C27.7123 23.7411 25.2151 23.076 22.4843 23.0058L22 22.9996H14.222L20.4298 29.2069L14.222 22.9996Z " },
            { FluentSymbol.ArrowReply48, "M13.015 22.4996L20.0763 29.5605C20.5644 30.0486 20.5644 30.8401 20.0763 31.3282C19.6207 31.7838 18.9008 31.8142 18.41 31.4194L18.3085 31.3282L9.11612 22.1358C8.66051 21.6802 8.63013 20.9604 9.02499 20.4696L9.11612 20.3681L18.3085 11.1757C18.7967 10.6875 19.5881 10.6875 20.0763 11.1757C20.5319 11.6313 20.5623 12.3511 20.1674 12.842L20.0763 12.9435L13.019 19.9996H22C25.2537 19.9996 28.2795 20.7201 30.9036 22.0984L31.3146 22.3215C33.9968 23.8253 36.1742 26.0028 37.6781 28.685C39.2016 31.4022 40 34.5746 40 37.9996C40 38.6899 39.4404 39.2496 38.75 39.2496C38.0596 39.2496 37.5 38.6899 37.5 37.9996C37.5 34.9954 36.8077 32.2445 35.4974 29.9076C34.2187 27.6268 32.3727 25.7809 30.092 24.5021C27.8849 23.2647 25.3086 22.5784 22.4983 22.506L22 22.4996H13.015L20.0763 29.5605L13.015 22.4996Z " },
            { FluentSymbol.ArrowReplyAll16Filled, "M9.31567 3.18451C9.58194 3.45078 9.60614 3.86744 9.38829 4.16106L9.31567 4.24517L7.05981 6.49984L8.24981 6.50038C11.9013 6.50038 14.3823 8.57702 14.4957 11.5374L14.4998 11.7504C14.4998 12.1646 14.164 12.5004 13.7498 12.5004C13.3356 12.5004 12.9998 12.1646 12.9998 11.7504C12.9998 9.62152 11.3078 8.09249 8.50742 8.00439L8.24981 8.00038L7.05981 7.99984L9.31567 10.2556C9.60856 10.5485 9.60856 11.0233 9.31567 11.3162C9.0494 11.5825 8.63274 11.6067 8.33913 11.3889L8.25501 11.3162L4.71948 7.78071L4.65091 7.70191L4.61037 7.64254L4.56129 7.54827L4.52848 7.45647L4.51259 7.38866L4.50368 7.32678L4.5 7.23316L4.50368 7.17398L4.5193 7.08003L4.54975 6.98075L4.59617 6.88221L4.63098 6.82651L4.65681 6.79084L4.71948 6.72005L8.25501 3.18451C8.5479 2.89162 9.02278 2.89162 9.31567 3.18451ZM1.21967 6.72005L4.71967 3.22005C5.01256 2.92715 5.48744 2.92715 5.78033 3.22005C6.0466 3.48631 6.0708 3.90298 5.85295 4.19659L5.78033 4.28071L2.81066 7.25038L5.78033 10.22C6.07322 10.5129 6.07322 10.9878 5.78033 11.2807C5.51406 11.547 5.0974 11.5712 4.80379 11.3533L4.71967 11.2807L1.21967 7.78071C0.953403 7.51444 0.929197 7.09778 1.14705 6.80417L1.21967 6.72005L4.71967 3.22005L1.21967 6.72005Z " },
            { FluentSymbol.ArrowReplyAll16, "M9.38909 3.61129C9.56265 3.78486 9.58194 4.05428 9.44694 4.24915L9.38909 4.3184L6.707 6.99984L8 7.00038C11.5218 7.00038 13.8854 8.97618 13.9959 11.7928L14 12.0004C14 12.2765 13.7761 12.5004 13.5 12.5004C13.2239 12.5004 13 12.2765 13 12.0004C13 9.72721 11.1925 8.09579 8.26152 8.00442L8 8.00038L6.707 7.99984L9.38909 10.6824C9.58435 10.8776 9.58435 11.1942 9.38909 11.3895C9.21552 11.563 8.9461 11.5823 8.75123 11.4473L8.68198 11.3895L5.11603 7.82067L5.06639 7.74953L5.03875 7.69372L5.01597 7.62609L5.005 7.56784L5.001 7.51484L5.0018 7.45786L5.01679 7.37155L5.03779 7.30934L5.07719 7.23337L5.13169 7.16222L8.68198 3.61129C8.87724 3.41603 9.19383 3.41603 9.38909 3.61129ZM2.14645 7.14682L5.64645 3.64682C5.84171 3.45156 6.15829 3.45156 6.35355 3.64682C6.52712 3.82039 6.5464 4.08981 6.41141 4.28468L6.35355 4.35393L3.20711 7.50038L6.35355 10.6468C6.54882 10.8421 6.54882 11.1587 6.35355 11.3539C6.17999 11.5275 5.91056 11.5468 5.71569 11.4118L5.64645 11.3539L2.14645 7.85393C1.97288 7.68036 1.9536 7.41094 2.08859 7.21607L2.14645 7.14682L5.64645 3.64682L2.14645 7.14682Z " },
            { FluentSymbol.ArrowReplyAll20Filled, "M11.273 3.97748C11.5392 4.24375 11.5634 4.66041 11.3456 4.95402L11.273 5.03814L8.31 7.99981L10 8.00045C14.1979 8.00045 17.6162 11.3381 17.7462 15.5044L17.75 15.7505C17.75 16.1647 17.4142 16.5005 17 16.5005C16.5858 16.5005 16.25 16.1647 16.25 15.7505C16.25 12.3754 13.5748 9.62514 10.2291 9.50458L10 9.50045L8.31 9.49981L11.273 12.4628C11.5659 12.7557 11.5659 13.2305 11.273 13.5234C11.0067 13.7897 10.59 13.8139 10.2964 13.596L10.2123 13.5234L5.96967 9.28078C5.7034 9.01452 5.6792 8.59785 5.89705 8.30424L5.96967 8.22012L10.2123 3.97748C10.5052 3.68459 10.9801 3.68459 11.273 3.97748ZM1.96967 8.22276L6.21231 3.98012C6.5052 3.68723 6.98008 3.68723 7.27297 3.98012C7.53924 4.24639 7.56344 4.66305 7.34559 4.95667L7.27297 5.04078L3.56066 8.75309L7.27297 12.4654C7.56586 12.7583 7.56586 13.2332 7.27297 13.5261C7.0067 13.7923 6.59004 13.8165 6.29643 13.5987L6.21231 13.5261L1.96967 9.28342C1.7034 9.01716 1.6792 8.60049 1.89705 8.30688L1.96967 8.22276L6.21231 3.98012L1.96967 8.22276Z " },
            { FluentSymbol.ArrowReplyAll20, "M10.0962 3.90426C10.2698 4.07783 10.289 4.34725 10.154 4.54212L10.0962 4.61137L6.707 7.99981L10 8.00045C14.0609 8.00045 17.368 11.2279 17.4961 15.2577L17.5 15.5005C17.5 15.7766 17.2761 16.0005 17 16.0005C16.7239 16.0005 16.5 15.7766 16.5 15.5005C16.5 11.9886 13.715 9.1273 10.2331 9.00456L10 9.00045L6.707 8.99981L10.0962 12.3895C10.2915 12.5848 10.2915 12.9014 10.0962 13.0966C9.92263 13.2702 9.6532 13.2895 9.45833 13.1545L9.38909 13.0966L5.14645 8.85401C4.97288 8.68044 4.9536 8.41102 5.08859 8.21615L5.14645 8.1469L9.38909 3.90426C9.58435 3.709 9.90093 3.709 10.0962 3.90426ZM2.14645 8.1469L6.38909 3.90426C6.58435 3.709 6.90093 3.709 7.09619 3.90426C7.26976 4.07783 7.28905 4.34725 7.15405 4.54212L7.09619 4.61137L3.20711 8.50045L7.09619 12.3895C7.29146 12.5848 7.29146 12.9014 7.09619 13.0966C6.92263 13.2702 6.6532 13.2895 6.45834 13.1545L6.38909 13.0966L2.14645 8.85401C1.97288 8.68044 1.9536 8.41102 2.08859 8.21615L2.14645 8.1469L6.38909 3.90426L2.14645 8.1469Z " },
            { FluentSymbol.ArrowReplyAll24Filled, "M13.7042 16.2945C14.0945 16.6853 14.094 17.3184 13.7032 17.7087C13.3124 18.0989 12.6793 18.0985 12.289 17.7077L7.29241 12.7043C6.90237 12.3137 6.90255 11.681 7.29282 11.2906L12.2894 6.29297C12.6799 5.9024 13.3131 5.90234 13.7036 6.29282C14.0942 6.6833 14.0943 7.31647 13.7038 7.70703L10.411 11H13C17.3349 11 20.8645 14.4478 20.9962 18.7508L21 19C21 19.5523 20.5523 20 20 20C19.4477 20 19 19.5523 19 19C19 15.7616 16.4344 13.1224 13.2249 13.0041L13 13H10.414L13.7042 16.2945ZM8.70365 6.29282C9.09421 6.6833 9.09428 7.31647 8.70379 7.70703L4.41366 11.9981L8.7042 16.2945C9.09446 16.6853 9.09403 17.3184 8.70324 17.7087C8.31245 18.0989 7.67928 18.0985 7.28902 17.7077L2.29241 12.7043C1.90237 12.3137 1.90255 11.681 2.29282 11.2906L7.28943 6.29297C7.67992 5.9024 8.31308 5.90234 8.70365 6.29282Z " },
            { FluentSymbol.ArrowReplyAll24, "M13.2773 16.2211C13.57 16.5142 13.5697 16.9891 13.2766 17.2818C12.9835 17.5745 12.5086 17.5742 12.2159 17.2811L7.21931 12.2776C6.92678 11.9847 6.92691 11.5101 7.21961 11.2174L12.2162 6.21972C12.5091 5.9268 12.984 5.92675 13.2769 6.21962C13.5698 6.51248 13.5699 6.98735 13.277 7.28028L9.557 11H13.3988C14.9936 11 16.2099 11.242 17.2878 11.7645L17.5342 11.89C18.6427 12.4829 19.5171 13.3573 20.11 14.4658C20.7194 15.6053 21 16.8837 21 18.6012C21 19.0154 20.6642 19.3512 20.25 19.3512C19.8358 19.3512 19.5 19.0154 19.5 18.6012C19.5 17.1174 19.2723 16.0802 18.7872 15.1732C18.3342 14.3261 17.6739 13.6658 16.8268 13.2128C15.9895 12.765 15.0414 12.5365 13.7334 12.5041L13.3988 12.5H9.562L13.2773 16.2211ZM9.27689 6.21962C9.56981 6.51248 9.56986 6.98735 9.277 7.28028L4.81024 11.748L9.2773 16.2211C9.57 16.5142 9.56967 16.9891 9.27658 17.2818C8.98349 17.5745 8.50861 17.5742 8.21592 17.2811L3.21931 12.2776C2.92678 11.9847 2.92692 11.5101 3.21962 11.2174L8.21623 6.21972C8.50909 5.9268 8.98396 5.92675 9.27689 6.21962Z " },
            { FluentSymbol.ArrowReplyAll48Filled, "M14.7868 19.9884L23.955 10.8221C24.6384 10.1387 25.7464 10.1387 26.4298 10.8221C27.073 11.4653 27.1109 12.4847 26.5433 13.1722L26.4298 13.297L20.226 19.4996H25C28.342 19.4996 31.455 20.243 34.1569 21.6667L34.5591 21.8854C37.3216 23.4342 39.5653 25.678 41.1142 28.4404C42.6804 31.2338 43.5 34.4905 43.5 37.9996C43.5 38.9661 42.7165 39.7496 41.75 39.7496C40.7835 39.7496 40 38.9661 40 37.9996C40 35.0795 39.3289 32.4129 38.0613 30.1521C36.8276 27.9516 35.0479 26.172 32.8474 24.9383C30.7123 23.7411 28.2151 23.076 25.4843 23.0058L25 22.9996H20.222L26.4298 29.2069C27.073 29.8501 27.1109 30.8695 26.5433 31.5569L26.4298 31.6818C25.7866 32.325 24.7673 32.3628 24.0798 31.7953L23.955 31.6818L14.7626 22.4894C14.7023 22.4291 14.6473 22.3655 14.5976 22.2992L14.5827 22.2763C14.4578 22.1065 14.3688 21.9188 14.3144 21.7235L14.2863 21.6076L14.2644 21.4766L14.2536 21.3652L14.2502 21.2204L14.2569 21.0939L14.2682 20.9994C14.3056 20.7356 14.4018 20.4917 14.5428 20.2801L14.5539 20.2658C14.6212 20.1649 14.6997 20.0722 14.7868 19.9884L23.955 10.8221L14.7868 19.9884ZM5.76256 20.0145L14.955 10.8221C15.6384 10.1387 16.7464 10.1387 17.4298 10.8221C18.073 11.4653 18.1109 12.4847 17.5433 13.1722L17.4298 13.297L9.47487 21.252L17.4298 29.2069C18.1132 29.8903 18.1132 30.9984 17.4298 31.6818C16.7866 32.325 15.7673 32.3628 15.0798 31.7953L14.955 31.6818L5.76256 22.4894C5.11935 21.8462 5.08151 20.8268 5.64905 20.1394L5.76256 20.0145L14.955 10.8221L5.76256 20.0145Z " },
            { FluentSymbol.ArrowReplyAll48, "M14.1161 20.3681L23.3085 11.1757C23.7967 10.6875 24.5881 10.6875 25.0763 11.1757C25.5319 11.6313 25.5623 12.3511 25.1674 12.842L25.0763 12.9435L18.019 19.9996H25C28.2537 19.9996 31.2795 20.7201 33.9036 22.0984L34.3146 22.3215C36.9968 23.8253 39.1742 26.0028 40.6781 28.685C42.2016 31.4022 43 34.5746 43 37.9996C43 38.6899 42.4404 39.2496 41.75 39.2496C41.0596 39.2496 40.5 38.6899 40.5 37.9996C40.5 34.9954 39.8077 32.2445 38.4974 29.9076C37.2187 27.6268 35.3727 25.7809 33.092 24.5021C30.8849 23.2647 28.3086 22.5784 25.4983 22.506L25 22.4996H18.015L25.0763 29.5605C25.5319 30.0161 25.5623 30.7359 25.1674 31.2267L25.0763 31.3282C24.6207 31.7838 23.9008 31.8142 23.41 31.4194L23.3085 31.3282L14.1161 22.1358C13.6605 21.6802 13.6301 20.9604 14.025 20.4696L14.1161 20.3681L23.3085 11.1757L14.1161 20.3681ZM6.11612 20.3681L15.3085 11.1757C15.7967 10.6875 16.5881 10.6875 17.0763 11.1757C17.5319 11.6313 17.5623 12.3511 17.1674 12.842L17.0763 12.9435L8.76777 21.252L17.0763 29.5605C17.5644 30.0486 17.5644 30.8401 17.0763 31.3282C16.6207 31.7838 15.9008 31.8142 15.41 31.4194L15.3085 31.3282L6.11612 22.1358C5.6605 21.6802 5.63013 20.9604 6.02499 20.4696L6.11612 20.3681L15.3085 11.1757L6.11612 20.3681Z " },
            { FluentSymbol.ArrowReplyDown24Filled, "M9.7042 8.70553C10.0945 8.31474 10.094 7.68158 9.70324 7.29132C9.31245 6.90106 8.67928 6.90149 8.28902 7.29229L3.29241 12.2957C2.90237 12.6863 2.90255 13.319 3.29282 13.7094L8.28943 18.707C8.67992 19.0976 9.31308 19.0977 9.70365 18.7072C10.0942 18.3167 10.0943 17.6835 9.70379 17.293L6.411 14H13C17.3349 14 20.8645 10.5522 20.9962 6.24918L21 6C21 5.44772 20.5523 5 20 5C19.4477 5 19 5.44772 19 6C19 9.2384 16.4344 11.8776 13.2249 11.9959L13 12H6.414L9.7042 8.70553Z " },
            { FluentSymbol.ArrowReplyDown24, "M9.2773 7.77888C9.57 7.48578 9.56967 7.01091 9.27658 6.71822C8.98349 6.42552 8.50861 6.42585 8.21592 6.71894L3.21931 11.7224C2.92678 12.0153 2.92692 12.4899 3.21962 12.7826L8.21623 17.7803C8.50909 18.0732 8.98396 18.0732 9.27689 17.7804C9.56981 17.4875 9.56986 17.0126 9.277 16.7197L5.557 13H13.3988C14.9936 13 16.2099 12.758 17.2878 12.2355L17.5342 12.11C18.6427 11.5171 19.5171 10.6427 20.11 9.53424C20.7194 8.39473 21 7.11626 21 5.39877C21 4.98456 20.6642 4.64877 20.25 4.64877C19.8358 4.64877 19.5 4.98456 19.5 5.39877C19.5 6.88263 19.2723 7.91977 18.7872 8.82684C18.3342 9.67391 17.6739 10.3342 16.8268 10.7872C15.9895 11.235 15.0414 11.4635 13.7334 11.4959L13.3988 11.5H5.562L9.2773 7.77888Z " },
            { FluentSymbol.ArrowReplyDown16Filled, "M4.30981 8.00504L6.56567 5.7493C6.85856 5.45641 6.85856 4.98153 6.56567 4.68864C6.2994 4.42237 5.88274 4.39817 5.58913 4.61602L5.50501 4.68864L1.96948 8.22417L1.90091 8.30297L1.86037 8.36234L1.81129 8.45661L1.77848 8.54841L1.76259 8.61622L1.75368 8.6781L1.75 8.77172L1.75368 8.83091L1.7693 8.92486L1.79975 9.02413L1.84617 9.12268L1.88098 9.17837C1.90656 9.21576 1.93612 9.25148 1.96948 9.28484L1.90091 9.20604C1.92193 9.23388 1.94485 9.26021 1.96948 9.28484L5.50501 12.8204C5.7979 13.1133 6.27278 13.1133 6.56567 12.8204C6.83194 12.5541 6.85614 12.1374 6.63829 11.8438L6.56567 11.7597L4.30981 9.50504L7.99981 9.50451C11.6513 9.50451 14.1323 7.42787 14.2457 4.46745L14.2498 4.25451C14.2498 3.84029 13.914 3.50451 13.4998 3.50451C13.0856 3.50451 12.7498 3.84029 12.7498 4.25451C12.7498 6.38337 11.0578 7.91239 8.25742 8.00049L7.99981 8.00451L4.30981 8.00504L6.56567 5.7493L4.30981 8.00504Z " },
            { FluentSymbol.ArrowReplyDown16, "M3.707 8.00504L6.38909 5.32253C6.58435 5.12726 6.58435 4.81068 6.38909 4.61542C6.21552 4.44185 5.9461 4.42257 5.75123 4.55756L5.68198 4.61542L2.11603 8.18421L2.06639 8.25535L2.03875 8.31116L2.01597 8.3788L2.01109 8.39952C2.00383 8.4332 2 8.46841 2 8.50451L2.00546 8.43059L2.0018 8.46202L2.0018 8.54703L2.01679 8.63334L2.03779 8.69554L2.07719 8.77152L2.13169 8.84266L5.68198 12.3936C5.87724 12.5889 6.19383 12.5889 6.38909 12.3936C6.56265 12.22 6.58194 11.9506 6.44694 11.7557L6.38909 11.6865L3.707 9.00504L8 9.00451C11.5218 9.00451 13.8854 7.0287 13.9959 4.21208L14 4.00451C14 3.72836 13.7761 3.50451 13.5 3.50451C13.2239 3.50451 13 3.72836 13 4.00451C13 6.27767 11.1925 7.90909 8.26152 8.00046L8 8.00451L3.707 8.00504L6.38909 5.32253L3.707 8.00504Z " },
            { FluentSymbol.ArrowReplyDown20Filled, "M4.31 10.4982L7.27297 7.53528C7.56586 7.24239 7.56586 6.76752 7.27297 6.47462C7.0067 6.20836 6.59004 6.18415 6.29643 6.402L6.21231 6.47462L1.96967 10.7173C1.7034 10.9835 1.6792 11.4002 1.89705 11.6938L1.96967 11.7779L6.21231 16.0206C6.5052 16.3135 6.98008 16.3135 7.27297 16.0206C7.53924 15.7543 7.56344 15.3376 7.34559 15.044L7.27297 14.9599L4.31 11.9982L10 11.9976C14.1979 11.9976 17.6162 8.65997 17.7462 4.49361L17.75 4.24759C17.75 3.83338 17.4142 3.49759 17 3.49759C16.5858 3.49759 16.25 3.83338 16.25 4.24759C16.25 7.62267 13.5748 10.3729 10.2291 10.4935L10 10.4976L4.31 10.4982L7.27297 7.53528L4.31 10.4982Z " },
            { FluentSymbol.ArrowReplyDown20, "M3.707 10.9982L7.09619 7.60851C7.29146 7.41324 7.29146 7.09666 7.09619 6.9014C6.92263 6.72783 6.6532 6.70855 6.45834 6.84354L6.38909 6.9014L2.14645 11.144C1.97288 11.3176 1.9536 11.587 2.08859 11.7819L2.14645 11.8511L6.38909 16.0938C6.58435 16.289 6.90093 16.289 7.09619 16.0938C7.26976 15.9202 7.28905 15.6508 7.15405 15.4559L7.09619 15.3867L3.707 11.9982L10 11.9976C14.0609 11.9976 17.368 8.77012 17.4961 4.74032L17.5 4.49759C17.5 4.22145 17.2761 3.99759 17 3.99759C16.7239 3.99759 16.5 4.22145 16.5 4.49759C16.5 8.0094 13.715 10.8707 10.2331 10.9935L10 10.9976L3.707 10.9982L7.09619 7.60851L3.707 10.9982Z " },
            { FluentSymbol.ArrowRight20, "M10.8371 2.63074C10.6332 2.44456 10.3169 2.45895 10.1307 2.66289C9.94456 2.86683 9.95895 3.18309 10.1629 3.36927L16.3307 9H2.5C2.22386 9 2 9.22386 2 9.5C2 9.77614 2.22386 10 2.5 10H16.3279L10.1629 15.6281C9.95895 15.8143 9.94456 16.1305 10.1307 16.3345C10.3169 16.5384 10.6332 16.5528 10.8371 16.3666L17.7535 10.0526C17.8934 9.92482 17.9732 9.75728 17.993 9.58414C17.9976 9.55678 18 9.52867 18 9.5C18 9.47313 17.9979 9.44675 17.9938 9.42103C17.9756 9.24512 17.8955 9.07446 17.7535 8.94478L10.8371 2.63074Z " },
            { FluentSymbol.ArrowRight16Filled, "M2 8.00001C2 7.58579 2.33579 7.25001 2.75 7.25001L11.537 7.25L8.24991 4.30894C7.94122 4.03274 7.91488 3.5586 8.19107 3.24991C8.46727 2.94122 8.94141 2.91488 9.2501 3.19108L14.0001 7.44107C14.1591 7.58335 14.25 7.78663 14.25 8C14.25 8.21338 14.1591 8.41666 14.0001 8.55894L9.2501 12.8089C8.94141 13.0851 8.46727 13.0588 8.19107 12.7501C7.91488 12.4414 7.94122 11.9673 8.24991 11.6911L11.537 8.75L2.75 8.75001C2.33579 8.75001 2 8.41422 2 8.00001Z " },
            { FluentSymbol.ArrowRight16, "M2.5 7.50001C2.22386 7.50001 2 7.72386 2 8.00001C2 8.27615 2.22386 8.50001 2.5 8.50001L12.197 8.5L8.16552 12.1284C7.96026 12.3131 7.94362 12.6292 8.12835 12.8345C8.31308 13.0397 8.62923 13.0564 8.83448 12.8717L13.8345 8.37165C13.9398 8.27683 14 8.14175 14 8C14 7.85826 13.9398 7.72318 13.8345 7.62836L8.83448 3.12836C8.62923 2.94363 8.31308 2.96027 8.12835 3.16552C7.94362 3.37078 7.96026 3.68692 8.16552 3.87165L12.197 7.5L2.5 7.50001Z " },
            { FluentSymbol.ArrowRight20Filled, "M11.2654 3.20511C10.9644 2.92049 10.4897 2.93371 10.2051 3.23464C9.92049 3.53558 9.93371 4.01027 10.2346 4.29489L15.4737 9.25H2.75C2.33579 9.25 2 9.58579 2 10C2 10.4142 2.33579 10.75 2.75 10.75H15.476L10.2346 15.7073C9.93371 15.9919 9.92049 16.4666 10.2051 16.7675C10.4897 17.0684 10.9644 17.0817 11.2654 16.797L17.6826 10.7276C17.8489 10.5703 17.9489 10.3702 17.9826 10.1614C17.994 10.1094 18 10.0554 18 10C18 9.94241 17.9935 9.88633 17.9812 9.83246C17.9462 9.62667 17.8467 9.42976 17.6826 9.27455L11.2654 3.20511Z " },
            { FluentSymbol.ArrowRight24Filled, "M13.7045 4.28377C13.3111 3.89615 12.678 3.90084 12.2904 4.29424C11.9027 4.68765 11.9074 5.3208 12.3008 5.70842L17.6712 10.9998H4C3.44771 10.9998 3 11.4475 3 11.9998C3 12.5521 3.44772 12.9998 4 12.9998H17.6646L12.3008 18.2847C11.9074 18.6723 11.9027 19.3055 12.2904 19.6989C12.678 20.0923 13.3111 20.097 13.7045 19.7094L20.6287 12.887C21.1256 12.3974 21.1256 11.5958 20.6287 11.1062L13.7045 4.28377Z " },
            { FluentSymbol.ArrowRight24, "M13.2673 4.20889C12.9674 3.9232 12.4926 3.93475 12.2069 4.23467C11.9213 4.5346 11.9328 5.00933 12.2327 5.29502L18.4841 11.2496H3.75C3.33579 11.2496 3 11.5854 3 11.9996C3 12.4138 3.33579 12.7496 3.75 12.7496H18.4842L12.2327 18.7043C11.9328 18.99 11.9213 19.4648 12.2069 19.7647C12.4926 20.0646 12.9674 20.0762 13.2673 19.7905L20.6862 12.7238C20.8551 12.5629 20.9551 12.3576 20.9861 12.1443C20.9952 12.0975 21 12.0491 21 11.9996C21 11.9501 20.9952 11.9016 20.986 11.8547C20.955 11.6415 20.855 11.4364 20.6862 11.2756L13.2673 4.20889Z " },
            { FluentSymbol.ArrowRight28Filled, "M15.7048 4.28868C15.312 3.9005 14.6788 3.90428 14.2906 4.29713C13.9025 4.68998 13.9062 5.32313 14.2991 5.71132L21.6753 13H4C3.44772 13 3 13.4477 3 14C3 14.5523 3.44772 15 4 15H21.673L14.2991 22.2864C13.9062 22.6746 13.9025 23.3078 14.2906 23.7006C14.6788 24.0935 15.312 24.0972 15.7048 23.7091L24.6318 14.888C25.127 14.3987 25.127 13.5991 24.6318 13.1097L15.7048 4.28868Z " },
            { FluentSymbol.ArrowRight28, "M15.2685 4.20949C14.97 3.92233 14.4952 3.93153 14.208 4.23005C13.9209 4.52857 13.9301 5.00335 14.2286 5.29051L22.5028 13.25H3.75C3.33579 13.25 3 13.5858 3 14C3 14.4142 3.33579 14.75 3.75 14.75H22.5018L14.2286 22.7085C13.9301 22.9957 13.9209 23.4705 14.208 23.769C14.4952 24.0675 14.97 24.0767 15.2685 23.7896L24.6965 14.7202C25.1054 14.3268 25.1054 13.6723 24.6965 13.2788L15.2685 4.20949Z " },
            { FluentSymbol.ArrowRotateClockwise20Filled, "M10 3.5C6.41015 3.5 3.5 6.41015 3.5 10C3.5 10.4142 3.16421 10.75 2.75 10.75C2.33579 10.75 2 10.4142 2 10C2 5.58172 5.58172 2 10 2C14.4183 2 18 5.58172 18 10C18 12.6785 16.6837 15.0485 14.6645 16.5H15.75C16.1642 16.5 16.5 16.8358 16.5 17.25C16.5 17.6642 16.1642 18 15.75 18H12.75C12.3358 18 12 17.6642 12 17.25V14.25C12 13.8358 12.3358 13.5 12.75 13.5C13.1642 13.5 13.5 13.8358 13.5 14.25V15.4784C15.3051 14.3227 16.5 12.3003 16.5 10C16.5 6.41015 13.5899 3.5 10 3.5Z M12.5 10C12.5 11.3807 11.3807 12.5 10 12.5C8.61929 12.5 7.5 11.3807 7.5 10C7.5 8.61929 8.61929 7.5 10 7.5C11.3807 7.5 12.5 8.61929 12.5 10ZM11 10C11 9.44772 10.5523 9 10 9C9.44772 9 9 9.44772 9 10C9 10.5523 9.44772 11 10 11C10.5523 11 11 10.5523 11 10Z " },
            { FluentSymbol.ArrowRotateClockwise20, "M3 10C3 6.13401 6.13401 3 10 3C13.866 3 17 6.13401 17 10C17 12.7916 15.3658 15.2026 13 16.3265V14.5C13 14.2239 12.7761 14 12.5 14C12.2239 14 12 14.2239 12 14.5V17.5C12 17.7761 12.2239 18 12.5 18H15.5C15.7761 18 16 17.7761 16 17.5C16 17.2239 15.7761 17 15.5 17H13.8758C16.3346 15.6357 18 13.0128 18 10C18 5.58172 14.4183 2 10 2C5.58172 2 2 5.58172 2 10C2 10.2761 2.22386 10.5 2.5 10.5C2.77614 10.5 3 10.2761 3 10Z M10 12C11.1046 12 12 11.1046 12 10C12 8.89543 11.1046 8 10 8C8.89543 8 8 8.89543 8 10C8 11.1046 8.89543 12 10 12ZM10 11C9.44772 11 9 10.5523 9 10C9 9.44772 9.44772 9 10 9C10.5523 9 11 9.44772 11 10C11 10.5523 10.5523 11 10 11Z " },
            { FluentSymbol.ArrowRotateClockwise24Filled, "M12 3C16.9706 3 21 7.02944 21 12C21 15.4359 19.0581 18.4885 16.1267 20.001L18 20C18.5523 20 19 20.4477 19 21C19 21.5128 18.614 21.9355 18.1166 21.9933L18 22H14C13.4872 22 13.0645 21.614 13.0067 21.1166L13 21V17C13 16.4477 13.4477 16 14 16C14.5128 16 14.9355 16.386 14.9933 16.8834L15 17L15.0014 18.3267C17.3966 17.1903 19 14.753 19 12C19 8.13401 15.866 5 12 5C8.13401 5 5 8.13401 5 12C5 12.5523 4.55228 13 4 13C3.44772 13 3 12.5523 3 12C3 7.02944 7.02944 3 12 3ZM12 9C13.6569 9 15 10.3431 15 12C15 13.6569 13.6569 15 12 15C10.3431 15 9 13.6569 9 12C9 10.3431 10.3431 9 12 9ZM12 11C11.4477 11 11 11.4477 11 12C11 12.5523 11.4477 13 12 13C12.5523 13 13 12.5523 13 12C13 11.4477 12.5523 11 12 11Z " },
            { FluentSymbol.ArrowRotateClockwise24, "M12 3C16.9706 3 21 7.02944 21 12C21 15.0777 19.4407 17.865 16.9769 19.5009L18.75 19.5C19.1642 19.5 19.5 19.8358 19.5 20.25C19.5 20.6297 19.2178 20.9435 18.8518 20.9932L18.75 21H14.75C14.3703 21 14.0565 20.7178 14.0068 20.3518L14 20.25V16.25C14 15.8358 14.3358 15.5 14.75 15.5C15.1297 15.5 15.4435 15.7822 15.4932 16.1482L15.5 16.25L15.501 18.635C17.9241 17.3557 19.5 14.8247 19.5 12C19.5 7.85786 16.1421 4.5 12 4.5C7.85786 4.5 4.5 7.85786 4.5 12C4.5 12.4142 4.16421 12.75 3.75 12.75C3.33579 12.75 3 12.4142 3 12C3 7.02944 7.02944 3 12 3ZM12 9.25C13.5188 9.25 14.75 10.4812 14.75 12C14.75 13.5188 13.5188 14.75 12 14.75C10.4812 14.75 9.25 13.5188 9.25 12C9.25 10.4812 10.4812 9.25 12 9.25ZM12 10.75C11.3096 10.75 10.75 11.3096 10.75 12C10.75 12.6904 11.3096 13.25 12 13.25C12.6904 13.25 13.25 12.6904 13.25 12C13.25 11.3096 12.6904 10.75 12 10.75Z " },
            { FluentSymbol.ArrowRotateCounterclockwise20Filled, "M10 3.5C13.5899 3.5 16.5 6.41015 16.5 10C16.5 10.4142 16.8358 10.75 17.25 10.75C17.6642 10.75 18 10.4142 18 10C18 5.58172 14.4183 2 10 2C5.58172 2 2 5.58172 2 10C2 12.6785 3.31631 15.0485 5.33552 16.5H4.25C3.83579 16.5 3.5 16.8358 3.5 17.25C3.5 17.6642 3.83579 18 4.25 18H7.25C7.66421 18 8 17.6642 8 17.25V14.25C8 13.8358 7.66421 13.5 7.25 13.5C6.83579 13.5 6.5 13.8358 6.5 14.25V15.4784C4.6949 14.3227 3.5 12.3003 3.5 10C3.5 6.41015 6.41015 3.5 10 3.5Z M7.5 10C7.5 11.3807 8.61929 12.5 10 12.5C11.3807 12.5 12.5 11.3807 12.5 10C12.5 8.61929 11.3807 7.5 10 7.5C8.61929 7.5 7.5 8.61929 7.5 10ZM9 10C9 9.44772 9.44772 9 10 9C10.5523 9 11 9.44772 11 10C11 10.5523 10.5523 11 10 11C9.44772 11 9 10.5523 9 10Z " },
            { FluentSymbol.ArrowRotateCounterclockwise20, "M17 10C17 6.13401 13.866 3 10 3C6.13401 3 3 6.13401 3 10C3 12.7916 4.63419 15.2026 7 16.3265V14.5C7 14.2239 7.22386 14 7.5 14C7.77614 14 8 14.2239 8 14.5V17.5C8 17.7761 7.77614 18 7.5 18H4.5C4.22386 18 4 17.7761 4 17.5C4 17.2239 4.22386 17 4.5 17H6.12422C3.66539 15.6357 2 13.0128 2 10C2 5.58172 5.58172 2 10 2C14.4183 2 18 5.58172 18 10C18 10.2761 17.7761 10.5 17.5 10.5C17.2239 10.5 17 10.2761 17 10Z M10 12C8.89543 12 8 11.1046 8 10C8 8.89543 8.89543 8 10 8C11.1046 8 12 8.89543 12 10C12 11.1046 11.1046 12 10 12ZM10 11C10.5523 11 11 10.5523 11 10C11 9.44772 10.5523 9 10 9C9.44772 9 9 9.44772 9 10C9 10.5523 9.44772 11 10 11Z " },
            { FluentSymbol.ArrowRotateCounterclockwise24Filled, "M12 3C7.02944 3 3 7.02944 3 12C3 15.4359 4.94187 18.4885 7.87332 20.001L6 20C5.44772 20 5 20.4477 5 21C5 21.5128 5.38604 21.9355 5.88338 21.9933L6 22H10C10.5128 22 10.9355 21.614 10.9933 21.1166L11 21V17C11 16.4477 10.5523 16 10 16C9.48716 16 9.06449 16.386 9.00673 16.8834L9 17L8.99863 18.3267C6.60341 17.1903 5 14.753 5 12C5 8.13401 8.13401 5 12 5C15.866 5 19 8.13401 19 12C19 12.5523 19.4477 13 20 13C20.5523 13 21 12.5523 21 12C21 7.02944 16.9706 3 12 3ZM12 9C10.3431 9 9 10.3431 9 12C9 13.6569 10.3431 15 12 15C13.6569 15 15 13.6569 15 12C15 10.3431 13.6569 9 12 9ZM12 11C12.5523 11 13 11.4477 13 12C13 12.5523 12.5523 13 12 13C11.4477 13 11 12.5523 11 12C11 11.4477 11.4477 11 12 11Z " },
            { FluentSymbol.ArrowRotateCounterclockwise24, "M12 3C7.02944 3 3 7.02944 3 12C3 15.0777 4.55928 17.865 7.0231 19.5009L5.25 19.5C4.83579 19.5 4.5 19.8358 4.5 20.25C4.5 20.6297 4.78215 20.9435 5.14823 20.9932L5.25 21H9.25C9.6297 21 9.94349 20.7178 9.99315 20.3518L10 20.25V16.25C10 15.8358 9.66421 15.5 9.25 15.5C8.8703 15.5 8.55651 15.7822 8.50685 16.1482L8.5 16.25L8.49903 18.635C6.07593 17.3557 4.5 14.8247 4.5 12C4.5 7.85786 7.85786 4.5 12 4.5C16.1421 4.5 19.5 7.85786 19.5 12C19.5 12.4142 19.8358 12.75 20.25 12.75C20.6642 12.75 21 12.4142 21 12C21 7.02944 16.9706 3 12 3ZM12 9.25C10.4812 9.25 9.25 10.4812 9.25 12C9.25 13.5188 10.4812 14.75 12 14.75C13.5188 14.75 14.75 13.5188 14.75 12C14.75 10.4812 13.5188 9.25 12 9.25ZM12 10.75C12.6904 10.75 13.25 11.3096 13.25 12C13.25 12.6904 12.6904 13.25 12 13.25C11.3096 13.25 10.75 12.6904 10.75 12C10.75 11.3096 11.3096 10.75 12 10.75Z " },
            { FluentSymbol.ArrowSort20Filled, "M9.29341 7.22798C9.5863 7.52087 9.5863 7.99575 9.29341 8.28864C9.00052 8.58153 8.52564 8.58153 8.23275 8.28864L6.50001 6.5559V15.25C6.50001 15.6642 6.16422 16 5.75001 16C5.3358 16 5.00001 15.6642 5.00001 15.25V6.5664L3.28228 8.28412C2.98939 8.57702 2.51452 8.57702 2.22162 8.28412C1.92873 7.99123 1.92873 7.51636 2.22162 7.22346L5.16733 4.27775C5.30484 4.1083 5.51478 4.00001 5.75001 4.00001C5.9432 3.99905 6.1377 4.07227 6.2851 4.21967L9.29341 7.22798Z M10.7086 12.772C10.4157 12.4791 10.4157 12.0043 10.7086 11.7114C11.0014 11.4185 11.4763 11.4185 11.7692 11.7114L13.502 13.4441L13.502 4.75C13.502 4.33579 13.8377 4 14.252 4C14.6662 4 15.002 4.33579 15.002 4.75L15.002 13.4336L16.7197 11.7159C17.0126 11.423 17.4874 11.423 17.7803 11.7159C18.0732 12.0088 18.0732 12.4837 17.7803 12.7765L14.8346 15.7223C14.6971 15.8917 14.4872 16 14.252 16C14.0588 16.001 13.8643 15.9277 13.7169 15.7803L10.7086 12.772Z " },
            { FluentSymbol.ArrowSort20, "M5.49988 5.70981L2.85551 8.35418C2.66024 8.54944 2.34366 8.54944 2.1484 8.35418C1.95314 8.15891 1.95314 7.84233 2.1484 7.64707L5.61673 4.17874C5.70845 4.06947 5.84605 4 5.99988 4L6.00155 4C6.08023 3.99998 6.15892 4.01841 6.23056 4.05531C6.27569 4.07847 6.31803 4.10895 6.35583 4.14675L6.36581 4.15701L9.85588 7.64709C10.0511 7.84235 10.0511 8.15893 9.85588 8.3542C9.66062 8.54946 9.34404 8.54946 9.14878 8.3542L6.49988 5.7053V15.5C6.49988 15.7761 6.27602 16 5.99988 16C5.72374 16 5.49988 15.7761 5.49988 15.5V5.70981Z M14.5044 14.2902L17.1488 11.6458C17.344 11.4506 17.6606 11.4506 17.8559 11.6458C18.0511 11.8411 18.0511 12.1577 17.8559 12.3529L14.3875 15.8213C14.2958 15.9305 14.1582 16 14.0044 16L14.0027 16C13.924 16 13.8454 15.9816 13.7737 15.9447C13.7286 15.9215 13.6862 15.8911 13.6484 15.8533L13.6385 15.843L10.1484 12.3529C9.95313 12.1577 9.95313 11.8411 10.1484 11.6458C10.3437 11.4505 10.6602 11.4505 10.8555 11.6458L13.5044 14.2947L13.5044 4.5C13.5044 4.22386 13.7283 4 14.0044 4C14.2805 4 14.5044 4.22386 14.5044 4.5L14.5044 14.2902Z " },
            { FluentSymbol.ArrowSort24Filled, "M2.29154 8.79327L6.28731 4.79327C6.64758 4.43262 7.21473 4.40456 7.60719 4.70931L7.70144 4.79243L11.7067 8.79243C12.0975 9.1827 12.0979 9.81586 11.7076 10.2066C11.3474 10.5674 10.7801 10.5955 10.3877 10.2907L10.2934 10.2076L8.00002 7.917L8.00003 18.5007C8.00003 19.0135 7.61399 19.4362 7.11666 19.4939L7.00003 19.5007C6.4872 19.5007 6.06453 19.1146 6.00676 18.6173L6.00003 18.5007L6.00002 7.91L3.7065 10.2067C3.34621 10.5674 2.77899 10.5954 2.38654 10.2906L2.29229 10.2075C1.93162 9.84719 1.90359 9.27997 2.2084 8.88752L2.29154 8.79327L6.28731 4.79327L2.29154 8.79327ZM16.8834 4.50994L17 4.50322C17.5129 4.50322 17.9355 4.88926 17.9933 5.3866L18 5.50322L18 16.087L20.2926 13.7932C20.6529 13.4326 21.2201 13.4046 21.6126 13.7094L21.7068 13.7926C22.0675 14.1529 22.0955 14.7201 21.7906 15.1125L21.7075 15.2068L17.7112 19.2068C17.3509 19.5674 16.7837 19.5954 16.3913 19.2906L16.297 19.2074L12.2933 15.2074C11.9026 14.8171 11.9023 14.1839 12.2926 13.7932C12.6529 13.4326 13.2201 13.4046 13.6126 13.7094L13.7068 13.7926L16 16.083L16 5.50322C16 4.99038 16.3861 4.56771 16.8834 4.50994L17 4.50322L16.8834 4.50994Z " },
            { FluentSymbol.ArrowSort24, "M2.21965 9.21975L6.71441 4.7247C6.98047 4.45862 7.39676 4.43421 7.69038 4.65162L7.77451 4.7241L12.2794 9.21916C12.5726 9.51173 12.5731 9.9866 12.2805 10.2798C12.0145 10.5464 11.5979 10.571 11.3041 10.3535L11.2199 10.281L7.997 7.06412L7.99766 18.76C7.99766 19.1397 7.71551 19.4534 7.34943 19.5031L7.24766 19.51C6.86797 19.51 6.55417 19.2278 6.50451 18.8617L6.49766 18.76L6.497 7.06212L3.28035 10.2804C3.01409 10.5467 2.59743 10.5709 2.30381 10.353L2.21969 10.2804C1.95341 10.0142 1.92919 9.59749 2.14704 9.30387L2.21965 9.21975L6.71441 4.7247L2.21965 9.21975ZM16.6491 4.50196L16.7509 4.49512C17.1306 4.49512 17.4444 4.77727 17.494 5.14335L17.5009 5.24512L17.5 16.9411L20.7194 13.72C20.9856 13.4536 21.4023 13.4292 21.696 13.6469L21.7801 13.7195C22.0465 13.9857 22.0709 14.4023 21.8531 14.696L21.7806 14.7802L17.2843 19.2802C17.0182 19.5465 16.6015 19.5709 16.3078 19.3532L16.2237 19.2806L11.7199 14.7806C11.4269 14.4878 11.4267 14.013 11.7194 13.72C11.9856 13.4536 12.4023 13.4292 12.696 13.6469L12.7801 13.7195L16 16.9371L16.0009 5.24512C16.0009 4.86542 16.283 4.55163 16.6491 4.50196L16.7509 4.49512L16.6491 4.50196Z " },
            { FluentSymbol.ArrowSort28Filled, "M8.35153 4.01102L8.40997 4.004L8.5 4L8.57524 4.00279L8.70073 4.02024L8.81214 4.04974L8.92322 4.09367L9.02071 4.146L9.12545 4.21969L9.20711 4.29289L14.7071 9.79289C15.0976 10.1834 15.0976 10.8166 14.7071 11.2071C14.3466 11.5676 13.7794 11.5953 13.3871 11.2903L13.2929 11.2071L9.5 7.415V23C9.5 23.5523 9.05228 24 8.5 24C7.98716 24 7.56449 23.614 7.50673 23.1166L7.5 23V7.415L3.70711 11.2071C3.34662 11.5676 2.77939 11.5953 2.3871 11.2903L2.29289 11.2071C1.93241 10.8466 1.90468 10.2794 2.2097 9.8871L2.29289 9.79289L7.79289 4.29289C7.82829 4.2575 7.86567 4.22531 7.90469 4.19633L8.01594 4.12467L8.12866 4.07123L8.23401 4.03585L8.35153 4.01102ZM19.5 4C20.0128 4 20.4355 4.38604 20.4933 4.88338L20.5 5V20.585L24.2929 16.7929L24.3871 16.7097C24.7794 16.4047 25.3466 16.4324 25.7071 16.7929C26.0676 17.1534 26.0953 17.7206 25.7903 18.1129L25.7071 18.2071L20.2071 23.7071L20.1631 23.7485L20.0953 23.8037L19.9841 23.8753L19.8713 23.9288L19.766 23.9642L19.6485 23.989L19.5593 23.9983H19.4406L19.3819 23.9931L19.2665 23.9726L19.1583 23.9401L19.0768 23.9063L18.9793 23.854L18.8832 23.7872C18.8515 23.7623 18.8214 23.7356 18.7929 23.7071L13.2929 18.2071L13.2097 18.1129C12.9301 17.7533 12.9301 17.2467 13.2097 16.8871L13.2929 16.7929L13.3871 16.7097C13.7467 16.4301 14.2533 16.4301 14.6129 16.7097L14.7071 16.7929L18.5 20.585V5L18.5067 4.88338C18.5645 4.38604 18.9872 4 19.5 4Z " },
            { FluentSymbol.ArrowSort28, "M2.21979 9.96703L7.96979 4.21955L8.055 4.146L8.11269 4.1076L8.18504 4.06911L8.28979 4.02992L8.39481 4.00737L8.44703 4.00185L8.5 4L8.55712 4.00214L8.6491 4.01489L8.75557 4.0447L8.84124 4.0819L8.89515 4.11242L8.9583 4.15627L9.03021 4.21955L14.7802 9.96703C15.0732 10.2599 15.0733 10.7347 14.7804 11.0277C14.5142 11.294 14.0976 11.3183 13.8039 11.1005L13.7198 11.0279L9.24961 6.55955L9.25 23.25C9.25 23.6642 8.91421 24 8.5 24C8.1203 24 7.80651 23.7178 7.75685 23.3518L7.75 23.25L7.74961 6.55955L3.28021 11.0279C3.01389 11.2941 2.59722 11.3182 2.30366 11.1003L2.21955 11.0277C1.95335 10.7614 1.92923 10.3447 2.14715 10.0511L2.21979 9.96703ZM19.5 4C19.8797 4 20.1935 4.28215 20.2432 4.64823L20.25 4.75V21.437L24.7198 16.9696L24.8039 16.897C25.0976 16.6792 25.5142 16.7035 25.7804 16.9698C26.0467 17.2361 26.0708 17.6528 25.8528 17.9463L25.7802 18.0304L20.0525 23.7572C19.9154 23.9065 19.7186 24 19.5 24C19.3178 24 19.1508 23.935 19.0209 23.827L18.9475 23.7572L13.2198 18.0304L13.1472 17.9463C12.9534 17.6854 12.951 17.3272 13.1398 17.0638L13.2196 16.9698L13.3037 16.8972C13.5646 16.7034 13.9228 16.701 14.1862 16.8898L14.2802 16.9696L18.75 21.439V4.75L18.7568 4.64823C18.8065 4.28215 19.1203 4 19.5 4Z " },
            { FluentSymbol.ArrowSwap20Filled, "M12.7803 3.21967C12.4874 2.92678 12.0126 2.92678 11.7197 3.21967C11.4268 3.51256 11.4268 3.98744 11.7197 4.28033L13.4393 6H4.75C4.33579 6 4 6.33579 4 6.75C4 7.16421 4.33579 7.5 4.75 7.5H13.4393L11.7197 9.21967C11.4268 9.51256 11.4268 9.98744 11.7197 10.2803C12.0126 10.5732 12.4874 10.5732 12.7803 10.2803L15.7803 7.28033C16.0732 6.98744 16.0732 6.51256 15.7803 6.21967L12.7803 3.21967Z M8.28033 10.7803C8.57322 10.4874 8.57322 10.0126 8.28033 9.71967C7.98744 9.42678 7.51256 9.42678 7.21967 9.71967L4.21967 12.7197C4.07902 12.8603 4 13.0511 4 13.25C4 13.4489 4.07902 13.6397 4.21967 13.7803L7.21967 16.7803C7.51256 17.0732 7.98744 17.0732 8.28033 16.7803C8.57322 16.4874 8.57322 16.0126 8.28033 15.7197L6.56066 14H15.25C15.6642 14 16 13.6642 16 13.25C16 12.8358 15.6642 12.5 15.25 12.5H6.56066L8.28033 10.7803Z " },
            { FluentSymbol.ArrowSwap20, "M12.1464 3.14645C12.3417 2.95118 12.6583 2.95118 12.8536 3.14645L15.8536 6.14645C16.0488 6.34171 16.0488 6.65829 15.8536 6.85355L12.8536 9.85355C12.6583 10.0488 12.3417 10.0488 12.1464 9.85355C11.9512 9.65829 11.9512 9.34171 12.1464 9.14645L14.2929 7H4.5C4.22386 7 4 6.77614 4 6.5C4 6.22386 4.22386 6 4.5 6H14.2929L12.1464 3.85355C11.9512 3.65829 11.9512 3.34171 12.1464 3.14645Z M7.85355 10.1464C8.04882 10.3417 8.04882 10.6583 7.85355 10.8536L5.70711 13H15.5C15.7761 13 16 13.2239 16 13.5C16 13.7761 15.7761 14 15.5 14H5.70711L7.85355 16.1464C8.04882 16.3417 8.04882 16.6583 7.85355 16.8536C7.65829 17.0488 7.34171 17.0488 7.14645 16.8536L4.14645 13.8536C3.95118 13.6583 3.95118 13.3417 4.14645 13.1464L7.14645 10.1464C7.34171 9.95118 7.65829 9.95118 7.85355 10.1464Z " },
            { FluentSymbol.ArrowSwap24Filled, "M15.2069 2.29154L19.2069 6.28731C19.5676 6.64758 19.5956 7.21473 19.2909 7.60719L19.2078 7.70144L15.2078 11.7067C14.8175 12.0975 14.1843 12.0979 13.7935 11.7076C13.4328 11.3474 13.4047 10.7801 13.7095 10.3877L13.7926 10.2934L16.0832 8.00002L5.49951 8.00003C4.98668 8.00003 4.56401 7.61399 4.50624 7.11666L4.49951 7.00003C4.49951 6.4872 4.88555 6.06453 5.38289 6.00676L5.49951 6.00003L16.0902 6.00002L13.7935 3.7065C13.4328 3.34621 13.4048 2.77899 13.7096 2.38654L13.7927 2.29229C14.153 1.93162 14.7202 1.90359 15.1127 2.2084L15.2069 2.29154L19.2069 6.28731L15.2069 2.29154ZM19.4902 16.8834L19.497 17C19.497 17.5129 19.1109 17.9355 18.6136 17.9933L18.497 18L7.91319 18L10.207 20.2926C10.5676 20.6529 10.5956 21.2201 10.2908 21.6126L10.2076 21.7068C9.84731 22.0675 9.2801 22.0955 8.88766 21.7906L8.79341 21.7075L4.79341 17.7112C4.43276 17.3509 4.40476 16.7837 4.70961 16.3913L4.79275 16.297L8.79275 12.2933C9.18309 11.9026 9.81626 11.9023 10.207 12.2926C10.5676 12.6529 10.5956 13.2201 10.2908 13.6126L10.2076 13.7068L7.91719 16L18.497 16C19.0098 16 19.4325 16.3861 19.4902 16.8834L19.497 17L19.4902 16.8834Z " },
            { FluentSymbol.ArrowSwap24, "M14.7829 2.21965L19.2779 6.71441C19.544 6.98047 19.5684 7.39676 19.351 7.69038L19.2785 7.77451L14.7835 12.2794C14.4909 12.5726 14.016 12.5731 13.7228 12.2805C13.4563 12.0145 13.4316 11.5979 13.6491 11.3041L13.7217 11.2199L16.9385 7.997L5.24268 7.99766C4.86298 7.99766 4.54919 7.71551 4.49952 7.34943L4.49268 7.24766C4.49268 6.86797 4.77483 6.55417 5.14091 6.50451L5.24268 6.49766L16.9405 6.497L13.7223 3.28035C13.456 3.01409 13.4318 2.59743 13.6496 2.30381L13.7222 2.21969C13.9885 1.95341 14.4051 1.92919 14.6988 2.14704L14.7829 2.21965L19.2779 6.71441L14.7829 2.21965ZM19.5007 16.6491L19.5075 16.7509C19.5075 17.1306 19.2254 17.4444 18.8593 17.494L18.7575 17.5009L7.06151 17.5L10.2827 20.7194C10.5491 20.9856 10.5734 21.4023 10.3557 21.696L10.2831 21.7801C10.017 22.0465 9.60031 22.0709 9.30661 21.8531L9.22246 21.7806L4.72246 17.2843C4.45608 17.0182 4.4317 16.6015 4.64943 16.3078L4.72202 16.2237L9.22202 11.7199C9.51479 11.4269 9.98966 11.4267 10.2827 11.7194C10.5491 11.9856 10.5734 12.4023 10.3557 12.696L10.2831 12.7801L7.06551 16L18.7575 16.0009C19.1372 16.0009 19.451 16.283 19.5007 16.6491L19.5075 16.7509L19.5007 16.6491Z " },
            { FluentSymbol.ArrowSync12Filled, "M7.42393 2.92417C7.65824 2.68985 7.65824 2.30995 7.42393 2.07564L6.17393 0.825638C5.93961 0.591324 5.55972 0.591324 5.3254 0.825638C5.09109 1.05995 5.09109 1.43985 5.3254 1.67417L5.57308 1.92185C3.50917 2.13521 1.89966 3.87961 1.89966 5.99993C1.89966 6.98259 2.24612 7.88595 2.82299 8.59216C3.03262 8.84879 3.41061 8.88689 3.66724 8.67726C3.92387 8.46763 3.96197 8.08964 3.75234 7.83301C3.34408 7.33322 3.09966 6.69592 3.09966 5.99993C3.09966 4.56521 4.14152 3.37383 5.50994 3.1411L5.3254 3.32564C5.09109 3.55995 5.09109 3.93985 5.3254 4.17417C5.55972 4.40848 5.93961 4.40848 6.17393 4.17417L7.42393 2.92417ZM8.12527 3.15543C7.88494 3.38358 7.87508 3.76335 8.10323 4.00367C8.59737 4.52417 8.89966 5.22611 8.89966 5.99993C8.89966 7.43475 7.85765 8.62619 6.48908 8.8588L6.67372 8.67417C6.90803 8.43985 6.90803 8.05995 6.67372 7.82564C6.4394 7.59132 6.05951 7.59132 5.82519 7.82564L4.57519 9.07564C4.34088 9.30995 4.34088 9.68985 4.57519 9.92417L5.82519 11.1742C6.05951 11.4085 6.43941 11.4085 6.67372 11.1742C6.90803 10.9399 6.90803 10.56 6.67372 10.3256L6.4261 10.078C8.49007 9.86472 10.0997 8.12029 10.0997 5.99993C10.0997 4.90655 9.67088 3.91204 8.97351 3.17747C8.74536 2.93715 8.36559 2.92728 8.12527 3.15543Z " },
            { FluentSymbol.ArrowSync12, "M7.35348 2.85355C7.54874 2.65829 7.54874 2.34171 7.35348 2.14645L6.10348 0.896447C5.90822 0.701184 5.59163 0.701184 5.39637 0.896447C5.20111 1.09171 5.20111 1.40829 5.39637 1.60355L5.79784 2.00502C3.68263 2.11031 2 3.85866 2 6C2 6.95878 2.33796 7.83996 2.90078 8.52897C3.07547 8.74283 3.39046 8.77458 3.60432 8.59989C3.81818 8.42519 3.84993 8.11021 3.67524 7.89635C3.25293 7.37935 3 6.71989 3 6C3 4.41535 4.22863 3.11767 5.78525 3.00757L5.39637 3.39645C5.20111 3.59171 5.20111 3.90829 5.39637 4.10355C5.59163 4.29882 5.90822 4.29882 6.10348 4.10355L7.35348 2.85355ZM8.19446 3.22803C7.99419 3.41815 7.98597 3.73463 8.17609 3.93489C8.68717 4.47323 9 5.19955 9 6C9 7.58465 7.77137 8.88233 6.21475 8.99243L6.60363 8.60355C6.79889 8.40829 6.79889 8.09171 6.60363 7.89645C6.40837 7.70118 6.09178 7.70118 5.89652 7.89645L4.64652 9.14645C4.45126 9.34171 4.45126 9.65829 4.64652 9.85355L5.89652 11.1036C6.09178 11.2988 6.40837 11.2988 6.60363 11.1036C6.79889 10.9083 6.79889 10.5917 6.60363 10.3964L6.20216 9.99498C8.31737 9.88969 10 8.14134 10 6C10 4.93326 9.58176 3.96312 8.90133 3.24639C8.7112 3.04612 8.39473 3.0379 8.19446 3.22803Z " },
            { FluentSymbol.ArrowSync20Filled, "M9.88501 3.75102C8.32299 3.77953 6.77186 4.38929 5.58059 5.58055C3.13981 8.02133 3.13981 11.9786 5.58059 14.4194C5.79547 14.6343 6.02176 14.83 6.25739 15.0066C6.5888 15.2551 6.65604 15.7252 6.40758 16.0566C6.15911 16.388 5.68902 16.4552 5.3576 16.2068C5.06528 15.9876 4.78521 15.7453 4.51993 15.48C1.49336 12.4535 1.49336 7.54645 4.51993 4.51989C5.86716 3.17266 7.58814 2.42506 9.34839 2.27728L8.76258 1.69146C8.46969 1.39857 8.46969 0.923696 8.76258 0.630803C9.05547 0.337909 9.53035 0.33791 9.82324 0.630803L11.9446 2.75212C12.2375 3.04502 12.2375 3.51989 11.9446 3.81278L9.82324 5.9341C9.53035 6.227 9.05547 6.227 8.76258 5.9341C8.46969 5.64121 8.46969 5.16634 8.76258 4.87344L9.88501 3.75102ZM10.115 16.2489C11.677 16.2204 13.2281 15.6106 14.4194 14.4193C16.8602 11.9786 16.8602 8.02129 14.4194 5.58051C14.2045 5.36563 13.9782 5.16994 13.7426 4.99328C13.4112 4.74481 13.344 4.27472 13.5924 3.9433C13.8409 3.61189 14.311 3.54465 14.6424 3.79312C14.9347 4.01228 15.2148 4.25457 15.4801 4.51985C18.5066 7.54641 18.5066 12.4534 15.4801 15.48C14.1328 16.8272 12.4119 17.5748 10.6516 17.7226L11.2374 18.3084C11.5303 18.6013 11.5303 19.0762 11.2374 19.3691C10.9445 19.662 10.4696 19.662 10.1768 19.3691L8.05543 17.2478C7.76253 16.9549 7.76253 16.48 8.05543 16.1871L10.1768 14.0658C10.4696 13.7729 10.9445 13.7729 11.2374 14.0658C11.5303 14.3587 11.5303 14.8336 11.2374 15.1264L10.115 16.2489Z " },
            { FluentSymbol.ArrowSync20, "M11.4142 3.63601C11.6095 3.44074 11.6095 3.12416 11.4142 2.9289L9.29289 0.807579C9.09763 0.612317 8.78104 0.612317 8.58578 0.807579C8.39052 1.00284 8.39052 1.31942 8.58578 1.51469L9.58264 2.51154C7.80518 2.61008 6.05488 3.33851 4.69671 4.69668C1.76776 7.62561 1.76776 12.3743 4.69671 15.3033C4.95359 15.5602 5.2247 15.7947 5.50757 16.0068C5.72852 16.1724 6.04191 16.1276 6.20756 15.9066C6.3732 15.6857 6.32838 15.3723 6.10743 15.2067C5.86235 15.0229 5.6271 14.8194 5.40382 14.5962C2.8654 12.0578 2.8654 7.94219 5.40382 5.40378C6.68997 4.11764 8.38002 3.48321 10.0664 3.50031C10.0915 3.50057 10.1162 3.49897 10.1404 3.49564L8.58578 5.05022C8.39052 5.24548 8.39052 5.56206 8.58578 5.75733C8.78104 5.95259 9.09763 5.95259 9.29289 5.75733L11.4142 3.63601ZM8.58578 16.3639C8.39052 16.5592 8.39052 16.8758 8.58578 17.071L10.7071 19.1924C10.9024 19.3876 11.219 19.3876 11.4142 19.1924C11.6095 18.9971 11.6095 18.6805 11.4142 18.4853L10.4174 17.4884C12.1948 17.3899 13.9451 16.6614 15.3033 15.3033C18.2322 12.3743 18.2322 7.6256 15.3033 4.69666C15.0464 4.43978 14.7753 4.20526 14.4924 3.99318C14.2715 3.82754 13.9581 3.87236 13.7924 4.09331C13.6268 4.31425 13.6716 4.62764 13.8926 4.79329C14.1377 4.97703 14.3729 5.18049 14.5962 5.40377C17.1346 7.94218 17.1346 12.0578 14.5962 14.5962C13.31 15.8823 11.62 16.5167 9.9336 16.4996C9.90849 16.4994 9.88379 16.501 9.85963 16.5043L11.4142 14.9497C11.6095 14.7545 11.6095 14.4379 11.4142 14.2426C11.219 14.0474 10.9024 14.0474 10.7071 14.2426L8.58578 16.3639Z " },
            { FluentSymbol.ArrowSync24Filled, "M16.0518 5.0285C15.7169 5.46765 15.8013 6.09515 16.2405 6.43007C17.9675 7.74714 19 9.78703 19 12C19 15.4973 16.4352 18.3956 13.084 18.9166L13.7929 18.2071C14.1834 17.8166 14.1834 17.1834 13.7929 16.7929C13.4024 16.4024 12.7692 16.4024 12.3787 16.7929L9.87868 19.2929C9.48816 19.6834 9.48816 20.3166 9.87868 20.7071L12.3787 23.2071C12.7692 23.5976 13.4024 23.5976 13.7929 23.2071C14.1834 22.8166 14.1834 22.1834 13.7929 21.7929L12.9497 20.9505C17.4739 20.476 21 16.6498 21 12C21 9.15644 19.6712 6.53122 17.4533 4.83978C17.0142 4.50486 16.3867 4.58936 16.0518 5.0285ZM14.1213 3.29289L11.6213 0.792893C11.2308 0.402369 10.5976 0.402369 10.2071 0.792893C9.84662 1.15338 9.81889 1.72061 10.1239 2.1129L10.2071 2.20711L11.0503 3.04951C6.52615 3.52399 3 7.35021 3 12C3 14.7198 4.21515 17.2432 6.2716 18.9419C6.6974 19.2936 7.32771 19.2335 7.67943 18.8077C8.03116 18.3819 7.97111 17.7516 7.54531 17.3999C5.94404 16.0772 5 14.1168 5 12C5 8.50269 7.56475 5.60441 10.916 5.08343L10.2071 5.79289C9.81658 6.18342 9.81658 6.81658 10.2071 7.20711C10.5676 7.56759 11.1348 7.59532 11.5271 7.2903L11.6213 7.20711L14.1213 4.70711C14.4818 4.34662 14.5095 3.77939 14.2045 3.3871L14.1213 3.29289Z " },
            { FluentSymbol.ArrowSync24, "M16.2506 5.18011C15.9994 5.50947 16.0627 5.9801 16.3921 6.23128C18.1804 7.59515 19.25 9.70821 19.25 12C19.25 15.736 16.4242 18.812 12.7933 19.2071L13.4697 18.5303C13.7626 18.2374 13.7626 17.7626 13.4697 17.4697C13.2034 17.2034 12.7867 17.1792 12.4931 17.3971L12.409 17.4697L10.409 19.4697C10.1427 19.7359 10.1185 20.1526 10.3364 20.4462L10.409 20.5303L12.409 22.5303C12.7019 22.8232 13.1768 22.8232 13.4697 22.5303C13.7359 22.2641 13.7601 21.8474 13.5423 21.5538L13.4697 21.4697L12.7194 20.7208C17.2154 20.355 20.75 16.5903 20.75 12C20.75 9.23526 19.4582 6.68321 17.3017 5.03856C16.9724 4.78738 16.5017 4.85075 16.2506 5.18011ZM10.5303 1.46967C10.2374 1.76256 10.2374 2.23744 10.5303 2.53033L11.2796 3.27923C6.78409 3.6456 3.25 7.41008 3.25 12C3.25 14.6445 4.43126 17.0974 6.43081 18.7491C6.75016 19.0129 7.22289 18.9679 7.48669 18.6485C7.75048 18.3292 7.70545 17.8564 7.3861 17.5926C5.72793 16.2229 4.75 14.1922 4.75 12C4.75 8.26436 7.57532 5.18861 11.2057 4.79301L10.5303 5.46967C10.2374 5.76256 10.2374 6.23744 10.5303 6.53033C10.8232 6.82322 11.2981 6.82322 11.591 6.53033L13.591 4.53033C13.8839 4.23744 13.8839 3.76256 13.591 3.46967L11.591 1.46967C11.2981 1.17678 10.8232 1.17678 10.5303 1.46967Z " },
            { FluentSymbol.ArrowSyncCircle16Filled, "M8 2C4.68629 2 2 4.68629 2 8C2 11.3137 4.68629 14 8 14C11.3137 14 14 11.3137 14 8C14 4.68629 11.3137 2 8 2ZM5.5 8H6.9992L7.08907 8.00806C7.32232 8.05039 7.4992 8.25454 7.4992 8.5C7.4992 8.77614 7.27534 9 6.9992 9L6.66681 9.00054C6.9743 9.40962 7.46254 9.66642 8 9.66642C8.45937 9.66642 8.88785 9.48031 9.20034 9.15592C9.39191 8.95704 9.70844 8.95112 9.90732 9.1427C10.1062 9.33427 10.1121 9.6508 9.92054 9.84968C9.42145 10.3678 8.7339 10.6664 8 10.6664C7.21392 10.6664 6.49378 10.3232 6.00009 9.7641L6 10.0013L5.99194 10.0912C5.94961 10.3244 5.74546 10.5013 5.5 10.5013C5.22386 10.5013 5 10.2774 5 10.0013V8.5L5.00806 8.41012C5.05039 8.17688 5.25454 8 5.5 8ZM8 5.33358C8.78786 5.33358 9.50771 5.6782 10.0006 6.23675L10 6.00303L10.0081 5.91315C10.0504 5.6799 10.2545 5.50303 10.5 5.50303C10.7761 5.50303 11 5.72689 11 6.00303V7.5L10.9919 7.58988C10.9496 7.82312 10.7455 8 10.5 8H9.0041L8.91423 7.99194C8.68098 7.94961 8.5041 7.74546 8.5041 7.5C8.5041 7.22386 8.72796 7 9.0041 7L9.33289 6.99906C9.02595 6.59113 8.53829 6.33358 8 6.33358C7.5387 6.33358 7.10856 6.52127 6.79583 6.84808C6.60491 7.04759 6.2884 7.05455 6.08889 6.86363C5.88938 6.67271 5.88242 6.35621 6.07334 6.1567C6.57282 5.63475 7.26301 5.33358 8 5.33358Z " },
            { FluentSymbol.ArrowSyncCircle16, "M8 2C4.68629 2 2 4.68629 2 8C2 11.3137 4.68629 14 8 14C11.3137 14 14 11.3137 14 8C14 4.68629 11.3137 2 8 2ZM8 3C10.7614 3 13 5.23858 13 8C13 10.7614 10.7614 13 8 13C5.23858 13 3 10.7614 3 8C3 5.23858 5.23858 3 8 3ZM6.9992 8H5.5C5.25454 8 5.05039 8.17688 5.00806 8.41012L5 8.5V10.0013C5 10.2774 5.22386 10.5013 5.5 10.5013C5.74546 10.5013 5.94961 10.3244 5.99194 10.0912L6 10.0013L6.00001 9.76402C6.4937 10.3231 7.21388 10.6664 8 10.6664C8.7339 10.6664 9.42145 10.3678 9.92054 9.84968C10.1121 9.6508 10.1062 9.33427 9.90732 9.1427C9.70844 8.95112 9.39191 8.95704 9.20034 9.15592C8.88785 9.48031 8.45937 9.66642 8 9.66642C7.46218 9.66642 6.97364 9.40927 6.66619 8.99972L6.9992 9C7.27534 9 7.4992 8.77614 7.4992 8.5C7.4992 8.25454 7.32232 8.05039 7.08907 8.00806L6.9992 8ZM8 5.33358C7.26301 5.33358 6.57282 5.63475 6.07334 6.1567C5.88242 6.35621 5.88938 6.67271 6.08889 6.86363C6.2884 7.05455 6.60491 7.04759 6.79583 6.84808C7.10856 6.52127 7.5387 6.33358 8 6.33358C8.53862 6.33358 9.02655 6.59144 9.33346 6.99981L9.0041 7C8.72796 7 8.5041 7.22386 8.5041 7.5C8.5041 7.74546 8.68098 7.94961 8.91423 7.99194L9.0041 8H10.5C10.7455 8 10.9496 7.82312 10.9919 7.58988L11 7.5V6.00303C11 5.72689 10.7761 5.50303 10.5 5.50303C10.2545 5.50303 10.0504 5.6799 10.0081 5.91315L10 6.00303L10.0006 6.23675C9.50771 5.6782 8.78786 5.33358 8 5.33358Z " },
            { FluentSymbol.ArrowSyncCircle20Filled, "M10 18C5.58172 18 2 14.4183 2 10C2 5.58172 5.58172 2 10 2C14.4183 2 18 5.58172 18 10C18 14.4183 14.4183 18 10 18ZM13.4999 10C13.776 10 13.9999 9.77614 13.9999 9.5V7.5C13.9999 7.22386 13.776 7 13.4999 7C13.2237 7 12.9999 7.22386 12.9999 7.5V8.19617C12.3877 7.18015 11.2737 6.5 10.0001 6.5C8.96342 6.5 8.03154 6.9513 7.39138 7.66654C7.20721 7.87231 7.22472 8.1884 7.43049 8.37257C7.63625 8.55673 7.95235 8.53922 8.13651 8.33346C8.59499 7.8212 9.25968 7.5 10.0001 7.5C11.0245 7.5 11.9062 8.11648 12.2922 9H11.4999C11.2237 9 10.9999 9.22386 10.9999 9.5C10.9999 9.77614 11.2237 10 11.4999 10H13.4999ZM6.00012 10.5V12.5C6.00012 12.7761 6.22398 13 6.50012 13C6.77626 13 7.00012 12.7761 7.00012 12.5V11.8037C7.61231 12.8198 8.7263 13.5 10.0001 13.5C11.0367 13.5 11.9686 13.0487 12.6087 12.3335C12.7929 12.1277 12.7754 11.8116 12.5696 11.6274C12.3639 11.4433 12.0478 11.4608 11.8636 11.6665C11.4051 12.1788 10.7404 12.5 10.0001 12.5C8.97557 12.5 8.09394 11.8835 7.70793 11H8.50012C8.77627 11 9.00012 10.7761 9.00012 10.5C9.00012 10.2239 8.77627 10 8.50012 10H6.50012C6.22398 10 6.00012 10.2239 6.00012 10.5Z " },
            { FluentSymbol.ArrowSyncCircle20, "M10 3C13.866 3 17 6.13401 17 10C17 13.866 13.866 17 10 17C6.13401 17 3 13.866 3 10C3 6.13401 6.13401 3 10 3ZM18 10C18 5.58172 14.4183 2 10 2C5.58172 2 2 5.58172 2 10C2 14.4183 5.58172 18 10 18C14.4183 18 18 14.4183 18 10ZM10.0001 7.5C11.0245 7.5 11.9062 8.11648 12.2922 9H11.4999C11.2237 9 10.9999 9.22386 10.9999 9.5C10.9999 9.77614 11.2237 10 11.4999 10H13.4999C13.776 10 13.9999 9.77614 13.9999 9.5V7.5C13.9999 7.22386 13.776 7 13.4999 7C13.2237 7 12.9999 7.22386 12.9999 7.5V8.19617C12.3877 7.18015 11.2737 6.5 10.0001 6.5C8.96342 6.5 8.03154 6.9513 7.39138 7.66654C7.20721 7.87231 7.22473 8.1884 7.43049 8.37257C7.63625 8.55673 7.95235 8.53922 8.13651 8.33346C8.59499 7.8212 9.25968 7.5 10.0001 7.5ZM7.00012 11.8037V12.5C7.00012 12.7761 6.77626 13 6.50012 13C6.22398 13 6.00012 12.7761 6.00012 12.5V10.5C6.00012 10.2239 6.22398 10 6.50012 10H8.50012C8.77626 10 9.00012 10.2239 9.00012 10.5C9.00012 10.7761 8.77626 11 8.50012 11H7.70793C8.09394 11.8835 8.97557 12.5 10.0001 12.5C10.7404 12.5 11.4051 12.1788 11.8636 11.6665C12.0478 11.4608 12.3639 11.4433 12.5696 11.6274C12.7754 11.8116 12.7929 12.1277 12.6087 12.3335C11.9686 13.0487 11.0367 13.5 10.0001 13.5C8.7263 13.5 7.61231 12.8198 7.00012 11.8037Z " },
            { FluentSymbol.ArrowSyncCircle24Filled, "M12 22C6.47715 22 2 17.5228 2 12C2 6.47715 6.47715 2 12 2C17.5228 2 22 6.47715 22 12C22 17.5228 17.5228 22 12 22ZM15.2705 10.75H14C13.5858 10.75 13.25 11.0858 13.25 11.5C13.25 11.9142 13.5858 12.25 14 12.25H16.75C17.1642 12.25 17.5 11.9142 17.5 11.5V8.25C17.5 7.83579 17.1642 7.5 16.75 7.5C16.3358 7.5 16 7.83579 16 8.25V8.99955C15.0879 7.78531 13.636 7 12.0001 7C10.4632 7 9.09595 7.66036 8.17321 8.77062C7.90846 9.08918 7.95208 9.56205 8.27064 9.8268C8.5892 10.0916 9.06206 10.0479 9.32682 9.72938C9.96324 8.96361 10.907 8.5 12.0001 8.5C13.4924 8.5 14.7674 9.43442 15.2705 10.75ZM8 15.75V15C8.91194 16.2143 10.3638 17 12.0001 17C13.5252 17 14.9041 16.316 15.8214 15.237C16.0897 14.9214 16.0514 14.4481 15.7358 14.1798C15.4202 13.9115 14.9469 13.9499 14.6786 14.2655C14.0368 15.0204 13.0707 15.5 12.0001 15.5C10.6047 15.5 9.39859 14.6829 8.83669 13.5H10C10.4142 13.5 10.75 13.1642 10.75 12.75C10.75 12.3358 10.4142 12 10 12H7.25C6.83579 12 6.5 12.3358 6.5 12.75V15.75C6.5 16.1642 6.83579 16.5 7.25 16.5C7.66421 16.5 8 16.1642 8 15.75Z " },
            { FluentSymbol.ArrowSyncCircle24, "M16 8.25C16 7.83579 16.3358 7.5 16.75 7.5C17.1642 7.5 17.5 7.83579 17.5 8.25V11.5C17.5 11.9142 17.1642 12.25 16.75 12.25H14C13.5858 12.25 13.25 11.9142 13.25 11.5C13.25 11.0858 13.5858 10.75 14 10.75H15.2705C14.7674 9.43442 13.4924 8.5 12.0001 8.5C10.907 8.5 9.96324 8.96361 9.32682 9.72938C9.06206 10.0479 8.5892 10.0916 8.27064 9.8268C7.95208 9.56205 7.90846 9.08918 8.17321 8.77062C9.09595 7.66036 10.4632 7 12.0001 7C13.636 7 15.0879 7.78531 16 8.99955V8.25ZM8 15V15.75C8 16.1642 7.66421 16.5 7.25 16.5C6.83579 16.5 6.5 16.1642 6.5 15.75V12.75C6.5 12.3358 6.83579 12 7.25 12H10C10.4142 12 10.75 12.3358 10.75 12.75C10.75 13.1642 10.4142 13.5 10 13.5H8.83669C9.39859 14.6829 10.6047 15.5 12.0001 15.5C13.0707 15.5 14.0368 15.0204 14.6786 14.2655C14.9469 13.9499 15.4202 13.9115 15.7358 14.1798C16.0514 14.4481 16.0897 14.9214 15.8214 15.237C14.9041 16.316 13.5252 17 12.0001 17C10.3638 17 8.91194 16.2143 8 15ZM12 2C6.47715 2 2 6.47715 2 12C2 17.5228 6.47715 22 12 22C17.5228 22 22 17.5228 22 12C22 6.47715 17.5228 2 12 2ZM20.5 12C20.5 16.6944 16.6944 20.5 12 20.5C7.30558 20.5 3.5 16.6944 3.5 12C3.5 7.30558 7.30558 3.5 12 3.5C16.6944 3.5 20.5 7.30558 20.5 12Z " },
            { FluentSymbol.ArrowSyncOff12Filled, "M2.76873 3.47584C2.22436 4.17172 1.8999 5.04793 1.8999 5.99993C1.8999 6.98259 2.24636 7.88595 2.82323 8.59216C3.03287 8.84879 3.41085 8.88689 3.66748 8.67726C3.92412 8.46763 3.96222 8.08964 3.75259 7.83301C3.34433 7.33322 3.0999 6.69592 3.0999 5.99993C3.0999 5.37967 3.29463 4.80489 3.62628 4.33339L7.66644 8.37355C7.32174 8.61601 6.92184 8.78529 6.48933 8.8588L6.67396 8.67417C6.90828 8.43985 6.90828 8.05995 6.67396 7.82564C6.43965 7.59132 6.05975 7.59132 5.82544 7.82564L4.57544 9.07564C4.34112 9.30995 4.34112 9.68985 4.57544 9.92417L5.82544 11.1742C6.05975 11.4085 6.43965 11.4085 6.67396 11.1742C6.90828 10.9399 6.90828 10.56 6.67396 10.3256L6.42634 10.078C7.21285 9.99674 7.93337 9.69312 8.52399 9.2311L10.1464 10.8536C10.3417 11.0488 10.6583 11.0488 10.8536 10.8536C11.0488 10.6583 11.0488 10.3417 10.8536 10.1464L1.85355 1.14645C1.65829 0.951184 1.34171 0.951184 1.14645 1.14645C0.951184 1.34171 0.951184 1.65829 1.14645 1.85355L2.76873 3.47584ZM8.81609 6.69491L9.75947 7.63828C9.97844 7.13649 10.0999 6.58239 10.0999 5.99993C10.0999 4.90655 9.67112 3.91204 8.97375 3.17747C8.7456 2.93715 8.36583 2.92728 8.12551 3.15543C7.88519 3.38358 7.87532 3.76335 8.10347 4.00367C8.59761 4.52417 8.8999 5.22611 8.8999 5.99993C8.8999 6.23948 8.87086 6.47225 8.81609 6.69491ZM4.36154 2.24037L6.23476 4.11358L7.42417 2.92417C7.65849 2.68985 7.65849 2.30995 7.42417 2.07564L6.17417 0.825638C5.93986 0.591324 5.55996 0.591324 5.32564 0.825638C5.09133 1.05995 5.09133 1.43985 5.32564 1.67417L5.57333 1.92185C5.14657 1.96597 4.73924 2.07554 4.36154 2.24037Z " },
            { FluentSymbol.ArrowSyncOff12, "M2.84007 3.54718C2.31354 4.22452 2 5.07564 2 6C2 6.95878 2.33796 7.83996 2.90078 8.52897C3.07547 8.74283 3.39046 8.77458 3.60432 8.59989C3.81818 8.42519 3.84993 8.11021 3.67524 7.89635C3.25293 7.37935 3 6.71989 3 6C3 5.35208 3.2054 4.75214 3.55463 4.26173L7.73827 8.44537C7.30251 8.75568 6.78028 8.95243 6.21475 8.99243L6.60363 8.60355C6.79889 8.40829 6.79889 8.09171 6.60363 7.89645C6.40837 7.70118 6.09178 7.70118 5.89652 7.89645L4.64652 9.14645C4.45126 9.34171 4.45126 9.65829 4.64652 9.85355L5.89652 11.1036C6.09178 11.2988 6.40837 11.2988 6.60363 11.1036C6.79889 10.9083 6.79889 10.5917 6.60363 10.3964L6.20216 9.99498C7.04827 9.95286 7.82516 9.64784 8.45282 9.15993L10.1464 10.8536C10.3417 11.0488 10.6583 11.0488 10.8536 10.8536C11.0488 10.6583 11.0488 10.3417 10.8536 10.1464L1.85355 1.14645C1.65829 0.951184 1.34171 0.951184 1.14645 1.14645C0.951184 1.34171 0.951184 1.65829 1.14645 1.85355L2.84007 3.54718ZM8.89834 6.77725L9.6834 7.56231C9.88724 7.08233 10 6.55434 10 6C10 4.93326 9.58176 3.96312 8.90133 3.24639C8.7112 3.04612 8.39473 3.0379 8.19446 3.22803C7.99419 3.41815 7.98597 3.73463 8.17609 3.93489C8.68717 4.47323 9 5.19955 9 6C9 6.2688 8.96465 6.52935 8.89834 6.77725ZM4.43768 2.3166L6.16406 4.04297L7.35348 2.85355C7.54874 2.65829 7.54874 2.34171 7.35348 2.14645L6.10348 0.896447C5.90822 0.701184 5.59163 0.701184 5.39637 0.896447C5.20111 1.09171 5.20111 1.40829 5.39637 1.60355L5.79784 2.00502C5.31723 2.02894 4.85896 2.13769 4.43768 2.3166Z " },
            { FluentSymbol.ArrowTrending20Filled, "M17.9431 5.46291C17.9068 5.37511 17.853 5.2928 17.7819 5.22126L17.7803 5.21967L17.7787 5.21808C17.6431 5.08329 17.4563 5 17.25 5H11.75C11.3358 5 11 5.33579 11 5.75C11 6.16421 11.3358 6.5 11.75 6.5H15.4393L10.5 11.4393L8.53033 9.46967C8.23744 9.17678 7.76256 9.17678 7.46967 9.46967L2.21967 14.7197C1.92678 15.0126 1.92678 15.4874 2.21967 15.7803C2.51256 16.0732 2.98744 16.0732 3.28033 15.7803L8 11.0607L9.96967 13.0303C10.2626 13.3232 10.7374 13.3232 11.0303 13.0303L16.5 7.56066V11.25C16.5 11.6642 16.8358 12 17.25 12C17.6642 12 18 11.6642 18 11.25V5.75C18 5.64831 17.9798 5.55134 17.9431 5.46291Z " },
            { FluentSymbol.ArrowTrending20, "M17.9621 5.30861C17.9377 5.24964 17.9015 5.19439 17.8536 5.14645C17.8056 5.09851 17.7504 5.06234 17.6914 5.03794C17.6324 5.01349 17.5678 5 17.5 5H11.5C11.2239 5 11 5.22386 11 5.5C11 5.77614 11.2239 6 11.5 6H16.2929L10.5 11.7929L8.35355 9.64645C8.15829 9.45118 7.84171 9.45118 7.64645 9.64645L2.14645 15.1464C1.95118 15.3417 1.95118 15.6583 2.14645 15.8536C2.34171 16.0488 2.65829 16.0488 2.85355 15.8536L8 10.7071L10.1464 12.8536C10.3417 13.0488 10.6583 13.0488 10.8536 12.8536L17 6.70711V11.5C17 11.7761 17.2239 12 17.5 12C17.7761 12 18 11.7761 18 11.5V5.5C18 5.43221 17.9865 5.36756 17.9621 5.30861Z " },
            { FluentSymbol.ArrowTrending16Filled, "M8.75 4L13.2982 4.00144L13.4058 4.01593L13.519 4.04911L13.6206 4.09687L13.6592 4.12035L13.7079 4.15479L13.784 4.22178L13.8682 4.32298L13.9266 4.4227L13.9681 4.52812L13.9912 4.62548L14.0015 4.75V9.25389C14.0015 9.6681 13.6657 10.0039 13.2515 10.0039C12.8718 10.0039 12.558 9.72174 12.5084 9.35566L12.5015 9.25389L12.501 6.561L8.28044 10.7841C8.01407 11.0506 7.59709 11.0747 7.30344 10.8566L7.21931 10.7839L5.74855 9.31112L3.28044 11.7802C2.9876 12.0732 2.51273 12.0733 2.21978 11.7804C1.95346 11.5142 1.92917 11.0976 2.14696 10.8039L2.21956 10.7198L5.21836 7.71978C5.48474 7.45329 5.90171 7.42916 6.19536 7.64731L6.27949 7.72003L7.75024 9.19276L11.441 5.5H8.75C8.3703 5.5 8.05651 5.21785 8.00685 4.85177L8 4.75C8 4.33579 8.33579 4 8.75 4Z " },
            { FluentSymbol.ArrowTrending16, "M8.49602 4L13.544 4.00179L13.6303 4.01676L13.6926 4.03779L13.7513 4.06673L13.8131 4.10892L13.8706 4.16267L13.9113 4.21334L13.946 4.27081L13.9783 4.3488L13.9898 4.39191L14.0011 4.47832L14.0015 9.5C14.0015 9.77614 13.7777 10 13.5015 10C13.2561 10 13.0519 9.82312 13.0096 9.58988L13.0015 9.5L13.001 5.707L7.85782 10.8535C7.68439 11.027 7.41516 11.0464 7.22027 10.9117L7.151 10.8539L5.50037 9.20674L2.85355 11.8536C2.65829 12.0488 2.34171 12.0488 2.14645 11.8536C1.97288 11.68 1.9536 11.4106 2.08859 11.2157L2.14645 11.1464L5.14645 8.14645C5.31988 7.97301 5.58907 7.95361 5.78393 8.08833L5.85318 8.14608L7.50374 9.79318L12.293 5H8.49602C8.25056 5 8.04642 4.82312 8.00408 4.58988L7.99602 4.5C7.99602 4.22386 8.21988 4 8.49602 4Z " },
            { FluentSymbol.ArrowTrending24Filled, "M14.003 5.5H20.9998C21.5126 5.5 21.9353 5.88604 21.993 6.38338L21.9998 6.5V13.5C21.9998 14.0523 21.552 14.5 20.9998 14.5C20.4869 14.5 20.0643 14.114 20.0065 13.6166L19.9998 13.5L19.999 8.914L12.7069 16.2071C12.3466 16.5674 11.7798 16.5953 11.3875 16.2908L11.2933 16.2077L8.99726 13.9157L3.70917 19.2055C3.31871 19.5961 2.68555 19.5962 2.29496 19.2057C1.93442 18.8453 1.9066 18.2781 2.21156 17.8857L2.29473 17.7915L8.28932 11.795C8.64956 11.4346 9.21645 11.4066 9.6088 11.7112L9.70303 11.7943L11.9991 14.0864L18.584 7.5H14.003C13.4902 7.5 13.0675 7.11396 13.0098 6.61662L13.003 6.5C13.003 5.98716 13.3891 5.56449 13.8864 5.50673L14.003 5.5H20.9998H14.003Z " },
            { FluentSymbol.ArrowTrending24, "M13.7479 5.5L21.3018 5.50052L21.402 5.51444L21.5008 5.54205L21.5611 5.5676C21.6403 5.60246 21.7146 5.65315 21.7798 5.71836L21.8205 5.7624L21.864 5.81878L21.9182 5.9089L21.9569 5.99922L21.976 6.0633L21.9896 6.1273L21.999 6.2215L21.9995 13.7539C21.9995 14.1681 21.6637 14.5039 21.2495 14.5039C20.8698 14.5039 20.556 14.2217 20.5063 13.8557L20.4995 13.7539L20.499 8.059L12.7802 15.7793C12.5139 16.0455 12.0973 16.0698 11.8036 15.8519L11.7195 15.7793L8.74903 12.8089L3.27935 18.2786C2.98646 18.5715 2.51159 18.5715 2.21869 18.2786C1.95243 18.0123 1.92822 17.5957 2.14608 17.3021L2.21869 17.2179L8.21869 11.2179C8.48496 10.9517 8.90161 10.9275 9.19522 11.1453L9.27934 11.2179L12.2498 14.1883L19.437 7H13.7479C13.3682 7 13.0545 6.71785 13.0048 6.35177L12.9979 6.25C12.9979 5.8703 13.2801 5.55651 13.6462 5.50685L13.7479 5.5Z " },
            { FluentSymbol.ArrowUndo16Filled, "M7.73381 3.3266C8.82163 2.23879 10.5853 2.23879 11.6731 3.32661C12.761 4.41443 12.761 6.17813 11.6731 7.26595L6.21967 12.7194C5.92678 13.0123 5.92678 13.4872 6.21967 13.7801C6.51256 14.073 6.98744 14.073 7.28033 13.7801L12.7338 8.32661C14.4074 6.653 14.4074 3.93955 12.7338 2.26595C11.0602 0.592344 8.34676 0.592339 6.67315 2.26594L4.5 4.43909V2.49976C4.5 2.08554 4.16421 1.74976 3.75 1.74976C3.33579 1.74976 3 2.08554 3 2.49976V6.24976C3 6.66397 3.33579 6.99976 3.75 6.99976H7.5C7.91421 6.99976 8.25 6.66397 8.25 6.24976C8.25 5.83554 7.91421 5.49976 7.5 5.49976H5.56065L7.73381 3.3266Z " },
            { FluentSymbol.ArrowUndo16, "M6.85499 3.85197C8.04044 2.66653 9.96243 2.66653 11.1479 3.85198C12.3333 5.03743 12.3333 6.95943 11.1479 8.14488L6.14645 13.1463C5.95118 13.3415 5.95118 13.6581 6.14645 13.8534C6.34171 14.0487 6.65829 14.0487 6.85355 13.8534L11.855 8.85198C13.431 7.27601 13.431 4.72085 11.855 3.14487C10.279 1.5689 7.72386 1.5689 6.14789 3.14486L4 5.29274V2.49985C4 2.2237 3.77614 1.99985 3.5 1.99985C3.22386 1.99985 3 2.2237 3 2.49985V6.49985C3 6.56764 3.01349 6.63228 3.03794 6.69124C3.06123 6.74753 3.09524 6.80043 3.13998 6.84681C3.14425 6.85124 3.1486 6.8556 3.15303 6.85987C3.19942 6.9046 3.25232 6.93862 3.30861 6.96191C3.36756 6.98635 3.4322 6.99985 3.5 6.99985H7.5C7.77614 6.99985 8 6.77599 8 6.49985C8 6.2237 7.77614 5.99985 7.5 5.99985H4.70711L6.85499 3.85197Z " },
            { FluentSymbol.ArrowUndo20Filled, "M6.8624 6.5H9.25C9.66421 6.5 10 6.83579 10 7.25C10 7.66422 9.66421 8 9.25 8H4.85C4.38056 8 4 7.61945 4 7.15V2.75C4 2.33579 4.33579 2 4.75 2C5.16421 2 5.5 2.33579 5.5 2.75V5.6968L8.55877 3.03785C10.747 1.13561 14.0631 1.36749 15.9653 3.55577C17.8675 5.74405 17.6357 9.06006 15.4474 10.9623L7.27548 18.066C6.96287 18.3378 6.48915 18.3047 6.21741 17.992C5.94566 17.6794 5.97878 17.2057 6.29139 16.934L14.4633 9.83024C16.0264 8.4715 16.192 6.10291 14.8332 4.53986C13.4745 2.9768 11.1059 2.81118 9.54286 4.16992L6.8624 6.5Z " },
            { FluentSymbol.ArrowUndo20, "M5 2.5C5 2.22386 4.77614 2 4.5 2C4.22386 2 4 2.22386 4 2.5V7.4C4 7.73137 4.26863 8 4.6 8H9.5C9.77614 8 10 7.77614 10 7.5C10 7.22386 9.77614 7 9.5 7H5.90603L9.37872 3.98124C11.046 2.53191 13.5725 2.70858 15.0218 4.37584C16.4711 6.0431 16.2945 8.56959 14.6272 10.0189L6.45529 17.1226C6.24688 17.3038 6.2248 17.6196 6.40596 17.828C6.58713 18.0364 6.90294 18.0585 7.11135 17.8774L15.2833 10.7736C17.3673 8.96197 17.5882 5.80385 15.7765 3.71978C13.9648 1.63571 10.8067 1.41487 8.72266 3.22653L5 6.46259V2.5Z " },
            { FluentSymbol.ArrowUndo24Filled, "M6.90735 6.6796L9.64108 3.95091C12.2423 1.3497 16.4597 1.3497 19.0609 3.95091C21.6621 6.55213 21.6621 10.7695 19.0609 13.3708L10.7225 21.7078C10.3319 22.0982 9.69877 22.098 9.30825 21.7075C8.91772 21.317 8.91789 20.6838 9.30848 20.2933L17.6467 11.9565C19.4669 10.1364 19.4669 7.1853 17.6467 5.36513C15.8834 3.60184 13.0588 3.54674 11.2286 5.20041L11.0546 5.36578L7.414 8.999L12 8.99954C12.5128 8.99954 12.9355 9.38558 12.9933 9.88291L13 9.99954C13 10.5124 12.614 10.935 12.1166 10.9928L12 10.9995L4.94043 10.9978L4.84501 10.9876L4.73315 10.9635L4.60163 10.9171L4.51971 10.8769L4.41781 10.8127C4.37406 10.7814 4.33212 10.7459 4.29267 10.7064L4.20096 10.601L4.12658 10.487L4.08093 10.3943L4.0425 10.2886L4.027 10.2313L4.01127 10.1497L4.00394 10.0885L4 9.99954V3.00235C4 2.45007 4.44772 2.00235 5 2.00235C5.51284 2.00235 5.93551 2.38839 5.99327 2.88573L6 3.00235V7.586L9.64108 3.95091L6.90735 6.6796Z " },
            { FluentSymbol.ArrowUndo24, "M4.75 2C5.1297 2 5.44349 2.28215 5.49315 2.64823L5.5 2.75V8.44L10.0743 3.88014C12.5163 1.43819 16.4385 1.37863 18.9526 3.70146L19.1385 3.88014C21.6415 6.38313 21.6415 10.4413 19.1385 12.9443L10.2933 21.7835C10.0003 22.0762 9.52558 22.0759 9.23269 21.783C8.93979 21.4901 8.94013 21.0151 9.23315 20.7223L18.0778 11.8836C19.995 9.96641 19.995 6.85801 18.0778 4.9408C16.2187 3.08169 13.2395 3.02535 11.3118 4.77248L11.1342 4.94156L6.562 9.5L12.25 9.50018C12.6297 9.50018 12.9435 9.78234 12.9932 10.1484L13 10.2502C13 10.6299 12.7178 10.9437 12.3518 10.9933L12.25 11.0002H4.75C4.3703 11.0002 4.05651 10.718 4.00685 10.352L4 10.2502V2.75C4 2.33579 4.33579 2 4.75 2Z " },
            { FluentSymbol.ArrowUndo32Filled, "M4.95361 4.25488C4.95361 3.56453 5.51326 3.00488 6.20361 3.00488C6.89397 3.00488 7.45361 3.56453 7.45361 4.25488V10.4361L12.0501 5.63859C13.2715 4.34538 15.3023 3.31303 17.5312 3.0965C19.8105 2.87508 22.348 3.50425 24.4598 5.61609C26.609 7.76525 27.1722 10.2757 26.9607 12.4468C26.7556 14.5513 25.8176 16.4048 24.8418 17.3819L24.8398 17.3839L13.6333 28.6803C13.1472 29.1704 12.3557 29.1736 11.8656 28.6874C11.3755 28.2012 11.3723 27.4097 11.8585 26.9196L23.0685 15.6196L23.072 15.6161C23.5955 15.0927 24.3172 13.7981 24.4724 12.2044C24.6213 10.6759 24.2445 8.93633 22.6921 7.38386C21.1669 5.85871 19.3944 5.42727 17.7729 5.58479C16.1032 5.74699 14.6444 6.53129 13.8654 7.35748L13.8585 7.36473L8.91938 12.5199H15.356C16.0464 12.5199 16.606 13.0796 16.606 13.7699C16.606 14.4603 16.0464 15.0199 15.356 15.0199H6.20361C5.51326 15.0199 4.95361 14.4603 4.95361 13.7699V4.25488Z " },
            { FluentSymbol.ArrowUndo32, "M23.3727 7.04596C22.0932 5.60136 20.4372 4.90163 18.7569 4.94851C17.0787 4.99533 15.2862 5.791 13.7584 7.51073L8.38336 14.0001H16.999C17.5513 14.0001 17.999 14.4478 17.999 15.0001C17.999 15.5524 17.5513 16.0001 16.999 16.0001H5.99902C5.44674 16.0001 4.99902 15.5524 4.99902 15.0001V4.00013C4.99902 3.44784 5.44674 3.00013 5.99902 3.00013C6.55131 3.00013 6.99902 3.44784 6.99902 4.00013V12.5361L12.2394 6.20924L12.2503 6.19689C14.1009 4.107 16.3998 3.01349 18.7011 2.94928C21.0041 2.88503 23.2188 3.85582 24.8699 5.71987C28.203 9.48296 27.1733 14.3848 24.859 16.913L24.8516 16.921L19.2745 22.7548L19.2705 22.7589L13.8372 28.3774L13.8337 28.3809L13.5233 28.6988C13.1374 29.0939 12.5043 29.1014 12.1091 28.7155C11.714 28.3297 11.7066 27.6965 12.0924 27.3014L12.3995 26.9871L12.4029 26.9835L17.8288 21.3727L17.8328 21.3686L23.3907 15.555C25.1455 13.6303 25.8975 9.8964 23.3727 7.04596Z " },
            { FluentSymbol.ArrowUndo48Filled, "M6.99805 5.5C6.99805 4.67157 7.66962 4 8.49805 4C9.32647 4 9.99804 4.67157 9.99804 5.5V16.9849L17.8993 8.9227C23.4712 2.62347 32.8494 2.76198 37.8287 8.2524C42.8297 13.7666 41.2054 21.5619 37.8574 25.4751L37.8485 25.4855L35.5903 28.0291L33.0533 30.5661L28.8061 34.7265L20.5643 43.0551L20.5588 43.0606L20.0625 43.5569C19.4768 44.1427 18.527 44.1427 17.9412 43.5569C17.3554 42.9711 17.3554 42.0213 17.9412 41.4355L18.4319 40.9449L18.4375 40.9393L26.6901 32.5997L30.943 28.4337L33.406 25.9708L35.5864 23.5148C38.2212 20.425 39.3281 14.3713 35.6065 10.2678C31.8676 6.14511 24.5559 5.89718 20.1244 10.9352L20.0977 10.9655L12.2237 19H23.498C24.3265 19 24.998 19.6716 24.998 20.5C24.998 21.3284 24.3265 22 23.498 22H8.49805C7.66962 22 6.99805 21.3284 6.99805 20.5V5.5Z " },
            { FluentSymbol.ArrowUndo48, "M35.7945 9.83982C31.6209 5.23784 24.4918 5.33466 19.9395 10.5101L19.9225 10.5294L11.364 19.4882H23.7436C24.4339 19.4882 24.9936 20.0478 24.9936 20.7382C24.9936 21.4285 24.4339 21.9882 23.7436 21.9882H8.19873C7.50838 21.9882 6.94873 21.4285 6.94873 20.7382V5.26886C6.94873 4.5785 7.50838 4.01886 8.19873 4.01886C8.88909 4.01886 9.44873 4.5785 9.44873 5.26886V17.8739L18.0797 8.83922C23.5289 2.66488 32.3865 2.36064 37.6464 8.16035C42.8863 13.9381 41.2684 21.4757 37.6325 25.3549L37.6232 25.3648L28.6442 34.5376L28.6392 34.5428L19.8892 43.3796L19.8848 43.384L19.6339 43.6349C19.1457 44.1231 18.3542 44.1231 17.8661 43.6349C17.3779 43.1468 17.3779 42.3553 17.8661 41.8672L18.1127 41.6206L18.117 41.6162L26.8576 32.7889L26.8627 32.7837L35.8174 23.6357C38.736 20.5121 39.9893 14.4652 35.7945 9.83982Z " },
            { FluentSymbol.ArrowUp20Filled, "M3.20218 8.73464C2.91756 9.03557 2.93078 9.51026 3.23171 9.79489C3.53265 10.0795 4.00734 10.0663 4.29196 9.76536L9.24707 4.52632V17.25C9.24707 17.6642 9.58286 18 9.99707 18C10.4113 18 10.7471 17.6642 10.7471 17.25V4.52405L15.7043 9.76536C15.989 10.0663 16.4636 10.0795 16.7646 9.79489C17.0655 9.51026 17.0787 9.03557 16.7941 8.73464L10.7247 2.31742C10.5674 2.15112 10.3673 2.05112 10.1585 2.01741C10.1065 2.00601 10.0525 2 9.99707 2C9.93948 2 9.8834 2.00649 9.82953 2.01878C9.62374 2.05377 9.42683 2.15332 9.27162 2.31742L3.20218 8.73464Z " },
            { FluentSymbol.ArrowUp20, "M3.13196 9.16191C2.94578 9.36585 2.96017 9.68211 3.16412 9.86829C3.36806 10.0545 3.68431 10.0401 3.87049 9.83613L9.50122 3.66828L9.50122 17.499C9.50122 17.7752 9.72508 17.999 10.0012 17.999C10.2774 17.999 10.5012 17.7752 10.5012 17.499L10.5012 3.67116L16.1293 9.83613C16.3155 10.0401 16.6317 10.0545 16.8357 9.86829C17.0396 9.68211 17.054 9.36585 16.8678 9.16191L10.5538 2.24556C10.426 2.10561 10.2585 2.02578 10.0854 2.00607C10.058 2.00144 10.0299 1.99902 10.0012 1.99902C9.97435 1.99902 9.94797 2.00114 9.92225 2.00522C9.74634 2.0234 9.57568 2.10351 9.446 2.24556L3.13196 9.16191Z " },
            { FluentSymbol.ArrowUp24Filled, "M4.28401 10.2959C3.89639 10.6893 3.90108 11.3225 4.29449 11.7101C4.68789 12.0977 5.32104 12.093 5.70866 11.6996L11 6.32931V20.0004C11 20.5527 11.4477 21.0004 12 21.0004C12.5523 21.0004 13 20.5527 13 20.0004V6.33579L18.2849 11.6996C18.6726 12.093 19.3057 12.0977 19.6991 11.7101C20.0925 11.3225 20.0972 10.6893 19.7096 10.2959L12.8872 3.37171C12.3976 2.8748 11.596 2.87479 11.1064 3.37171L4.28401 10.2959Z " },
            { FluentSymbol.ArrowUp24, "M4.20938 10.7327C3.92369 11.0326 3.93523 11.5074 4.23516 11.7931C4.53509 12.0787 5.00982 12.0672 5.29551 11.7673L11.25 5.516V20.25C11.25 20.6642 11.5858 21 12 21C12.4142 21 12.75 20.6642 12.75 20.25V5.51565L18.7048 11.7673C18.9905 12.0672 19.4652 12.0787 19.7652 11.7931C20.0651 11.5074 20.0766 11.0326 19.791 10.7327L12.7243 3.31379C12.5632 3.14474 12.3578 3.04477 12.1443 3.01386C12.0976 3.00477 12.0494 3 12 3C11.9503 3 11.9017 3.00483 11.8547 3.01406C11.6417 3.04518 11.4368 3.14509 11.2761 3.31379L4.20938 10.7327Z " },
            { FluentSymbol.ArrowUp28Filled, "M4.29137 12.2955C3.90318 12.6883 3.90696 13.3215 4.29981 13.7097C4.69266 14.0979 5.32582 14.0941 5.714 13.7012L13.0027 6.32499L13.0027 24.0003C13.0027 24.5526 13.4504 25.0003 14.0027 25.0003C14.555 25.0003 15.0027 24.5526 15.0027 24.0003L15.0027 6.32727L22.2891 13.7012C22.6773 14.0941 23.3105 14.0979 23.7033 13.7097C24.0962 13.3215 24.0999 12.6883 23.7117 12.2955L14.8907 3.36848C14.4014 2.87327 13.6017 2.87327 13.1124 3.36848L4.29137 12.2955Z " },
            { FluentSymbol.ArrowUp28, "M4.21144 12.7328C3.92428 13.0313 3.93349 13.5061 4.232 13.7932C4.53052 14.0804 5.0053 14.0712 5.29246 13.7727L13.252 5.49844V24.2512C13.252 24.6655 13.5877 25.0012 14.002 25.0012C14.4162 25.0012 14.752 24.6655 14.752 24.2512V5.49942L22.7105 13.7727C22.9977 14.0712 23.4724 14.0804 23.771 13.7932C24.0695 13.5061 24.0787 13.0313 23.7915 12.7328L14.7222 3.30478C14.3287 2.8958 13.6742 2.8958 13.2808 3.30478L4.21144 12.7328Z " },
            { FluentSymbol.ArrowUpLeft16Filled, "M9.00025 2.75C9.00025 2.33579 8.66446 2 8.25025 2H2.75024C2.33603 2 2.00024 2.33579 2.00024 2.75V8.25C2.00024 8.66421 2.33603 9 2.75024 9C3.16446 9 3.50024 8.66421 3.50024 8.25V4.5607L12.7196 13.7803C13.0125 14.0732 13.4874 14.0732 13.7802 13.7803C14.0731 13.4874 14.0732 13.0126 13.7803 12.7197L4.56087 3.5H8.25025C8.66446 3.5 9.00025 3.16421 9.00025 2.75Z " },
            { FluentSymbol.ArrowUpLeft16, "M8.5 3C8.77614 3 9 2.77614 9 2.5C9 2.22386 8.77614 2 8.5 2H2.5C2.22386 2 2 2.22386 2 2.5V8.5C2 8.77614 2.22386 9 2.5 9C2.77614 9 3 8.77614 3 8.5V3.7071L13.1465 13.8536C13.3418 14.0488 13.6584 14.0488 13.8536 13.8536C14.0489 13.6583 14.0489 13.3417 13.8536 13.1464L3.70711 3H8.5Z " },
            { FluentSymbol.ArrowUpLeft20Filled, "M12 3.75C12 3.33579 11.6642 3 11.25 3H3.75C3.33579 3 3 3.33579 3 3.75V11.25C3 11.6642 3.33579 12 3.75 12C4.16421 12 4.5 11.6642 4.5 11.25V5.56064L15.7186 16.7791C16.0115 17.072 16.4864 17.072 16.7793 16.7791C17.0722 16.4862 17.0722 16.0113 16.7793 15.7184L5.56068 4.5H11.25C11.6642 4.5 12 4.16421 12 3.75Z " },
            { FluentSymbol.ArrowUpLeft20, "M11.5 4C11.7761 4 12 3.77614 12 3.5C12 3.22386 11.7761 3 11.5 3H3.5C3.22386 3 3 3.22386 3 3.5V11.5C3 11.7761 3.22386 12 3.5 12C3.77614 12 4 11.7761 4 11.5V4.7071L16.1465 16.8536C16.3418 17.0488 16.6584 17.0488 16.8536 16.8536C17.0489 16.6583 17.0489 16.3417 16.8536 16.1464L4.70711 4H11.5Z " },
            { FluentSymbol.ArrowUpLeft24Filled, "M11.5006 3.00195L3.9448 3.00341L3.8239 3.01731L3.73621 3.03685L3.63232 3.07133L3.54316 3.11166L3.47941 3.14728L3.41684 3.1888L3.35284 3.2387L3.28974 3.29703L3.19534 3.40667L3.12368 3.51791L3.07024 3.63064L3.03486 3.73598L3.01919 3.80116L3.01004 3.85351L2.99902 4.00195V11.5058C2.99902 12.0581 3.44674 12.5058 3.99902 12.5058C4.51186 12.5058 4.93453 12.1198 4.9923 11.6225L4.99902 11.5058L4.99928 6.41595L19.2912 20.7076C19.6517 21.0681 20.2189 21.0958 20.6112 20.7908L20.7054 20.7076C21.0659 20.3471 21.0936 19.7798 20.7886 19.3876L20.7054 19.2934L6.41428 5.00195H11.5006C12.0134 5.00195 12.4361 4.61591 12.4938 4.11857L12.5006 4.00195C12.5006 3.44967 12.0528 3.00195 11.5006 3.00195Z " },
            { FluentSymbol.ArrowUpLeft24, "M11.2508 3.00098L3.69704 3.00149L3.59681 3.01541L3.49796 3.043L3.43766 3.06857C3.35845 3.10341 3.28422 3.15409 3.219 3.21929L3.17829 3.26333L3.11775 3.34481L3.08056 3.40983L3.04188 3.50015L3.02269 3.56427L3.00911 3.62822L2.9998 3.72141L2.99927 11.2549C2.99927 11.6691 3.33505 12.0049 3.74927 12.0049C4.12896 12.0049 4.44276 11.7227 4.49242 11.3566L4.49927 11.2549L4.49972 5.55898L19.7193 20.7843C19.9856 21.0506 20.4022 21.0748 20.6959 20.857L20.78 20.7844C21.0463 20.5181 21.0705 20.1015 20.8527 19.8078L20.7801 19.7237L5.56071 4.49998L11.2508 4.50098C11.6305 4.50098 11.9443 4.21882 11.9939 3.85275L12.0008 3.75098C12.0008 3.37128 11.7186 3.05749 11.3526 3.00782L11.2508 3.00098Z " },
            { FluentSymbol.ArrowUpRight16Filled, "M6.99993 2.75C6.99993 2.33579 7.33571 2 7.74993 2H13.2499C13.6641 2 13.9999 2.33579 13.9999 2.75V8.25C13.9999 8.66421 13.6641 9 13.2499 9C12.8357 9 12.4999 8.66421 12.4999 8.25V4.5607L3.28058 13.7803C2.98769 14.0732 2.51282 14.0732 2.21992 13.7803C1.92702 13.4874 1.92702 13.0126 2.21991 12.7197L11.4393 3.5H7.74993C7.33571 3.5 6.99993 3.16421 6.99993 2.75Z " },
            { FluentSymbol.ArrowUpRight16, "M7.50007 3C7.22393 3 7.00007 2.77614 7.00007 2.5C7.00007 2.22386 7.22393 2 7.50007 2H13.5001C13.7762 2 14.0001 2.22386 14.0001 2.5V8.5C14.0001 8.77614 13.7762 9 13.5001 9C13.2239 9 13.0001 8.77614 13.0001 8.5V3.7071L2.85355 13.8536C2.65829 14.0488 2.34171 14.0488 2.14645 13.8536C1.95118 13.6583 1.95119 13.3417 2.14645 13.1464L12.293 3H7.50007Z " },
            { FluentSymbol.ArrowUpRight20Filled, "M7.99932 3.75007C7.99932 3.33582 8.33513 3 8.74938 3H16.2499C16.6642 3 17 3.33582 17 3.75007V11.2507C17 11.665 16.6642 12.0008 16.2499 12.0008C15.8357 12.0008 15.4999 11.665 15.4999 11.2507V5.56087L4.28042 16.7803C3.9875 17.0732 3.5126 17.0732 3.21968 16.7803C2.92677 16.4874 2.92677 16.0125 3.21969 15.7196L14.4391 4.50013H8.74938C8.33513 4.50013 7.99932 4.16432 7.99932 3.75007Z " },
            { FluentSymbol.ArrowUpRight20, "M8.50005 4C8.2239 4 8.00005 3.77614 8.00005 3.5C8.00005 3.22386 8.2239 3 8.50005 3H16.5C16.7761 3 17 3.22386 17 3.5V11.5C17 11.7761 16.7761 12 16.5 12C16.2239 12 16 11.7761 16 11.5V4.7071L3.85355 16.8536C3.65829 17.0488 3.34171 17.0488 3.14645 16.8536C2.95118 16.6583 2.95119 16.3417 3.14645 16.1464L15.2929 4H8.50005Z " },
            { FluentSymbol.ArrowUpRight24Filled, "M12.4968 3.00195L20.0525 3.00341L20.1734 3.01731L20.2611 3.03685L20.365 3.07133L20.4541 3.11166L20.5179 3.14728L20.5805 3.1888L20.6445 3.2387L20.7076 3.29703L20.802 3.40667L20.8736 3.51791L20.9271 3.63064L20.9624 3.73598L20.9781 3.80116L20.9873 3.85351L20.9983 4.00195V11.5058C20.9983 12.0581 20.5506 12.5058 19.9983 12.5058C19.4854 12.5058 19.0628 12.1198 19.005 11.6225L18.9983 11.5058L18.998 6.41595L4.70611 20.7076C4.34562 21.0681 3.77839 21.0958 3.38611 20.7908L3.2919 20.7076C2.93142 20.3471 2.90371 19.7798 3.20874 19.3876L3.29193 19.2934L17.583 5.00195H12.4968C11.9839 5.00195 11.5612 4.61591 11.5035 4.11857L11.4968 4.00195C11.4968 3.44967 11.9445 3.00195 12.4968 3.00195Z " },
            { FluentSymbol.ArrowUpRight24, "M12.7482 3.00098L20.3019 3.00149L20.4022 3.01541L20.501 3.043L20.5613 3.06857C20.6405 3.10341 20.7148 3.15409 20.78 3.21929L20.8207 3.26333L20.8812 3.34481L20.9184 3.40983L20.9571 3.50015L20.9763 3.56427L20.9899 3.62822L20.9992 3.72141L20.9997 11.2549C20.9997 11.6691 20.6639 12.0049 20.2497 12.0049C19.87 12.0049 19.5562 11.7227 19.5066 11.3566L19.4997 11.2549L19.4993 5.55898L4.27966 20.7843C4.01342 21.0506 3.59676 21.0748 3.30313 20.857L3.219 20.7844C2.9527 20.5181 2.92845 20.1015 3.14627 19.8078L3.21888 19.7237L18.4383 4.49998L12.7482 4.50098C12.3685 4.50098 12.0547 4.21882 12.005 3.85275L11.9982 3.75098C11.9982 3.37128 12.2803 3.05749 12.6464 3.00782L12.7482 3.00098Z " },
            { FluentSymbol.ArrowUpload20Filled, "M4.5 2C4.08579 2 3.75 2.33579 3.75 2.75C3.75 3.16421 4.08579 3.5 4.5 3.5H15C15.4142 3.5 15.75 3.16421 15.75 2.75C15.75 2.33579 15.4142 2 15 2H4.5Z M10.4963 17.3493C10.4466 17.7154 10.1328 17.9976 9.75311 17.9976C9.3389 17.9976 9.00311 17.6618 9.00311 17.2476L9.00249 7.05856L6.02995 10.026L5.94578 10.0986C5.65202 10.3162 5.23537 10.2917 4.96929 10.0253C4.67661 9.73215 4.67695 9.25728 4.97005 8.96459L9.25962 4.67989C9.33377 4.61512 9.42089 4.56485 9.5169 4.53385L9.59777 4.51072C9.64749 4.50019 9.69837 4.4947 9.74849 4.4947L9.80855 4.49661L9.87781 4.50451L9.99828 4.53462L10.0895 4.57254L10.1259 4.59371L10.2169 4.6523L10.2875 4.71481L14.5303 8.96546L14.6029 9.04964C14.8205 9.34345 14.7959 9.7601 14.5294 10.0261L14.4452 10.0987C14.1514 10.3162 13.7347 10.2917 13.4687 10.0251L10.5025 7.05456L10.5031 17.2476L10.4963 17.3493Z " },
            { FluentSymbol.ArrowUpload16Filled, "M3.75 2C3.33579 2 3 2.33579 3 2.75C3 3.16421 3.33579 3.5 3.75 3.5H12.25C12.6642 3.5 13 3.16421 13 2.75C13 2.33579 12.6642 2 12.25 2H3.75ZM8.53033 4.71967C8.23744 4.42678 7.76256 4.42678 7.46967 4.71967L4.21967 7.96967C3.92678 8.26256 3.92678 8.73744 4.21967 9.03033C4.51256 9.32322 4.98744 9.32322 5.28033 9.03033L7.25 7.06066V13.25C7.25 13.6642 7.58579 14 8 14C8.41421 14 8.75 13.6642 8.75 13.25V7.06066L10.7197 9.03033C11.0126 9.32322 11.4874 9.32322 11.7803 9.03033C12.0732 8.73744 12.0732 8.26256 11.7803 7.96967L8.53033 4.71967Z " },
            { FluentSymbol.ArrowUpload16, "M3.5 2C3.22386 2 3 2.22386 3 2.5C3 2.77614 3.22386 3 3.5 3H12.5C12.7761 3 13 2.77614 13 2.5C13 2.22386 12.7761 2 12.5 2H3.5ZM8.35355 4.14645C8.15829 3.95118 7.84171 3.95118 7.64645 4.14645L4.14645 7.64645C3.95118 7.84171 3.95118 8.15829 4.14645 8.35355C4.34171 8.54882 4.65829 8.54882 4.85355 8.35355L7.5 5.70711V13.5C7.5 13.7761 7.72386 14 8 14C8.27614 14 8.5 13.7761 8.5 13.5V5.70711L11.1464 8.35355C11.3417 8.54882 11.6583 8.54882 11.8536 8.35355C12.0488 8.15829 12.0488 7.84171 11.8536 7.64645L8.35355 4.14645Z " },
            { FluentSymbol.ArrowUpload20, "M15 3.00098C15.2761 3.00098 15.5 2.77712 15.5 2.50098C15.5 2.25552 15.3231 2.05137 15.0899 2.00903L15 2.00098H4C3.72386 2.00098 3.5 2.22483 3.5 2.50098C3.5 2.74644 3.67688 2.95059 3.91012 2.99292L4 3.00098H15ZM9.50014 17.9988C9.7456 17.9988 9.9497 17.8218 9.99197 17.5885L10 17.4986L9.996 5.70477L13.6414 9.3531C13.8148 9.52683 14.0842 9.54636 14.2792 9.41154L14.3485 9.35375C14.5222 9.18034 14.5418 8.91094 14.407 8.71595L14.3492 8.64664L9.85745 4.14664C9.78495 4.07401 9.69568 4.02833 9.60207 4.00962L9.49608 3.99987C9.33511 3.99987 9.19192 4.076 9.10051 4.19419L4.64386 8.64607C4.44846 8.84119 4.44823 9.15777 4.64336 9.35317C4.8168 9.52686 5.08621 9.54634 5.28117 9.41148L5.35046 9.35368L8.996 5.71277L9 17.4989C9.00008 17.7751 9.224 17.9988 9.50014 17.9988Z " },
            { FluentSymbol.ArrowUpload24Filled, "M5.25 3.49512H18.7477C19.1619 3.49512 19.4977 3.15933 19.4977 2.74512C19.4977 2.36542 19.2155 2.05163 18.8494 2.00196L18.7477 1.99512H5.25C4.83579 1.99512 4.5 2.3309 4.5 2.74512C4.5 3.12481 4.78215 3.43861 5.14823 3.48827L5.25 3.49512ZM11.8834 21.9928L12 21.9995C12.5128 21.9995 12.9355 21.6135 12.9933 21.1161L13 20.9995V8.40952L16.2941 11.7023C16.6546 12.0627 17.2218 12.0904 17.6141 11.7853L17.7083 11.7022C18.0687 11.3416 18.0964 10.7744 17.7913 10.3821L17.7081 10.2879L12.7105 5.29132C12.3502 4.93108 11.7833 4.90321 11.391 5.20783L11.2968 5.29091L6.29338 10.2875C5.90259 10.6778 5.90215 11.3109 6.29241 11.7017C6.65265 12.0625 7.21986 12.0906 7.61236 11.7858L7.70662 11.7027L11 8.41452V20.9995C11 21.5124 11.386 21.935 11.8834 21.9928Z " },
            { FluentSymbol.ArrowUpload24, "M18.2498 3.50865C18.664 3.50877 19 3.17308 19 2.75886C19 2.34465 18.6644 2.00877 18.2502 2.00865L5.25022 2.00488C4.836 2.00476 4.5 2.34045 4.5 2.75467C4.5 3.16888 4.83557 3.50476 5.24978 3.50488L18.2498 3.50865ZM11.6482 21.9969L11.75 22.0037C12.1297 22.0037 12.4435 21.7215 12.4932 21.3555L12.5 21.2537L12.499 7.5687L16.2208 11.289C16.4871 11.5553 16.9038 11.5794 17.1974 11.3615L17.2815 11.2889C17.5477 11.0226 17.5719 10.606 17.354 10.3124L17.2814 10.2283L12.2837 5.23165C12.0176 4.96556 11.6012 4.94125 11.3076 5.15882L11.2235 5.23134L6.22003 10.228C5.92694 10.5206 5.92661 10.9955 6.21931 11.2886C6.48539 11.5551 6.90204 11.5796 7.1958 11.3619L7.27997 11.2893L10.999 7.5757L11 21.2537C11 21.6334 11.2822 21.9472 11.6482 21.9969Z " },
            { FluentSymbol.ArrowsBidirectional24Filled, "M15.0012 8.99871H9.00421L9.00519 6.74954C9.00519 6.08985 8.21483 5.75151 7.7375 6.20686L2.23377 11.4572C1.92402 11.7527 1.92403 12.2471 2.23379 12.5426L7.73752 17.7926L7.81978 17.8612C8.30023 18.2093 9.00519 17.8729 9.00519 17.2499L9.00421 14.9997H15.0012L15.0018 17.2499C15.0018 17.9098 15.7926 18.248 16.2698 17.7923L21.7669 12.5423C22.0763 12.2468 22.0763 11.7529 21.767 11.4575L16.2698 6.20717C15.7926 5.75139 15.0018 6.08963 15.0018 6.74954L15.0012 8.99871Z " },
            { FluentSymbol.ArrowsBidirectional24, "M15.0012 8.99871H9.00421L9.00519 6.74954C9.00519 6.08985 8.21483 5.75151 7.7375 6.20686L2.23377 11.4572C1.92402 11.7527 1.92403 12.2471 2.23379 12.5426L7.73752 17.7926L7.81978 17.8612C8.30023 18.2093 9.00519 17.8729 9.00519 17.2499L9.00421 14.9997H15.0012L15.0018 17.2499C15.0018 17.9098 15.7926 18.248 16.2698 17.7923L21.7669 12.5423C22.0763 12.2468 22.0763 11.7529 21.767 11.4575L16.2698 6.20717C15.7926 5.75139 15.0018 6.08963 15.0018 6.74954L15.0012 8.99871ZM3.83721 11.9997L7.50421 8.50071L7.50519 9.74933C7.50519 10.1635 7.84098 10.4993 8.25519 10.4993H15.7518L15.8536 10.4925C16.2196 10.4428 16.5018 10.129 16.5018 9.74933L16.5012 8.50271L20.1622 11.9997L16.5012 15.4957L16.5018 14.2504C16.5018 13.8362 16.166 13.5004 15.7518 13.5004H8.25519L8.15342 13.5073C7.78735 13.5569 7.50519 13.8707 7.50519 14.2504L7.50421 15.4977L3.83721 11.9997Z " },
            { FluentSymbol.Attach12Filled, "M8.97709 2.80597C8.30627 2.22459 7.3002 2.26047 6.6725 2.88817L3.28033 6.28034C2.98744 6.57324 2.51256 6.57324 2.21967 6.28034C1.92678 5.98745 1.92678 5.51258 2.21967 5.21968L5.61184 1.82751C6.79601 0.643346 8.69397 0.575651 9.95949 1.67244C11.3831 2.90622 11.4341 5.09808 10.0695 6.39681L5.34576 10.8926C4.59008 11.6118 3.39872 11.5971 2.66102 10.8595C1.91016 10.1087 1.91012 8.89136 2.66094 8.14054L6.90412 3.89736C7.19701 3.60447 7.67188 3.60446 7.96478 3.89736C8.25767 4.19025 8.25767 4.66512 7.96478 4.95802L3.7216 9.2012C3.55659 9.36621 3.5566 9.63375 3.72162 9.79874C3.88374 9.96085 4.14557 9.96408 4.31164 9.80602L9.03543 5.31025C9.75877 4.62182 9.73171 3.45997 8.97709 2.80597Z " },
            { FluentSymbol.Attach12, "M9.01063 2.5817C8.23002 1.80428 6.96568 1.80014 6.17994 2.57243L2.85122 5.84421C2.65468 6.03739 2.3381 6.03531 2.14413 5.83958C1.95016 5.64384 1.95224 5.32856 2.14878 5.13538L5.4775 1.8636C6.65449 0.706742 8.54841 0.712942 9.71774 1.87748C10.8925 3.04746 10.8925 4.94437 9.71774 6.11435L5.38625 10.4281C4.62061 11.1906 3.37927 11.1906 2.61362 10.4281C1.84795 9.66562 1.84794 8.42932 2.61359 7.6668L6.65312 3.6438C6.84838 3.44933 7.16496 3.44933 7.36022 3.64379C7.55549 3.83826 7.55549 4.15355 7.36022 4.34801L3.3207 8.37101C2.94557 8.74461 2.94558 9.35032 3.32071 9.72391C3.69584 10.0975 4.30403 10.0975 4.67915 9.7239L9.01063 5.41013C9.79489 4.62908 9.79489 3.36275 9.01063 2.5817Z " },
            { FluentSymbol.Attach16Filled, "M3.43414 8.88411L8.03033 4.28792C8.90901 3.40924 10.3336 3.40924 11.2123 4.28792C12.091 5.1666 12.091 6.59122 11.2123 7.4699L5.90901 12.7732C5.61612 13.0661 5.14125 13.0661 4.84835 12.7732C4.55546 12.4803 4.55546 12.0054 4.84835 11.7125L10.1517 6.40924C10.4445 6.11634 10.4445 5.64147 10.1517 5.34858C9.85876 5.05568 9.38389 5.05568 9.09099 5.34858L3.78769 10.6519C2.90901 11.5306 2.90901 12.9552 3.78769 13.8339C4.66637 14.7125 6.09099 14.7125 6.96967 13.8339L12.273 8.53056C13.7374 7.06609 13.7374 4.69172 12.273 3.22726C10.8085 1.76279 8.43414 1.76279 6.96967 3.22726L2.37348 7.82345C2.08059 8.11634 2.08059 8.59122 2.37348 8.88411C2.66637 9.177 3.14125 9.177 3.43414 8.88411Z " },
            { FluentSymbol.Attach16, "M3.25736 8.70733L7.85356 4.11114C8.82987 3.13483 10.4128 3.13483 11.3891 4.11114C12.3654 5.08745 12.3654 6.67036 11.3891 7.64667L6.08579 12.95C5.69526 13.3405 5.0621 13.3405 4.67158 12.95C4.28105 12.5595 4.28105 11.9263 4.67158 11.5358L9.97488 6.23246C10.1701 6.0372 10.1701 5.72062 9.97488 5.52535C9.77961 5.33009 9.46303 5.33009 9.26777 5.52535L3.96447 10.8287C3.18342 11.6097 3.18342 12.876 3.96447 13.6571C4.74552 14.4381 6.01185 14.4381 6.7929 13.6571L12.0962 8.35378C13.463 6.98695 13.463 4.77087 12.0962 3.40403C10.7294 2.0372 8.51328 2.0372 7.14645 3.40403L2.55026 8.00023C2.35499 8.19549 2.35499 8.51207 2.55026 8.70733C2.74552 8.9026 3.0621 8.9026 3.25736 8.70733Z " },
            { FluentSymbol.Attach20Filled, "M5.28033 10.6088L10.5836 5.30546C11.6576 4.23151 13.3988 4.23151 14.4727 5.30546C15.5467 6.3794 15.5467 8.1206 14.4727 9.19454L8.10876 15.5585C7.6206 16.0467 6.82915 16.0467 6.34099 15.5585C5.85283 15.0703 5.85283 14.2789 6.34099 13.7907L11.9978 8.13388C12.2907 7.84099 12.2907 7.36612 11.9978 7.07322C11.705 6.78033 11.2301 6.78033 10.9372 7.07322L5.28033 12.7301C4.20639 13.804 4.20639 15.5452 5.28033 16.6192C6.35427 17.6931 8.09548 17.6931 9.16942 16.6192L15.5334 10.2552C17.1931 8.59548 17.1931 5.90452 15.5334 4.2448C13.8737 2.58507 11.1827 2.58507 9.52297 4.2448L4.21967 9.5481C3.92678 9.84099 3.92678 10.3159 4.21967 10.6088C4.51256 10.9017 4.98744 10.9017 5.28033 10.6088Z " },
            { FluentSymbol.Attach20, "M4.82865 10.4857L10.4855 4.82888C11.6571 3.6573 13.5566 3.6573 14.7281 4.82888C15.8997 6.00045 15.8997 7.89994 14.7281 9.07152L8.01063 15.789C7.42485 16.3748 6.4751 16.3748 5.88931 15.789C5.30352 15.2032 5.30352 14.2535 5.88931 13.6677L11.8997 7.6573C12.095 7.46204 12.095 7.14546 11.8997 6.9502C11.7045 6.75493 11.3879 6.75493 11.1926 6.9502L5.1822 12.9606C4.20589 13.9369 4.20589 15.5198 5.1822 16.4961C6.15852 17.4724 7.74143 17.4724 8.71774 16.4961L15.4353 9.77862C16.9974 8.21653 16.9974 5.68387 15.4353 4.12177C13.8732 2.55967 11.3405 2.55967 9.7784 4.12177L4.12154 9.77862C3.92628 9.97388 3.92628 10.2905 4.12154 10.4857C4.31681 10.681 4.63339 10.681 4.82865 10.4857Z " },
            { FluentSymbol.Attach24Filled, "M15.9999 2C19.3136 2 21.9999 4.68629 21.9999 8C21.9999 9.5373 21.4178 10.9843 20.396 12.0835L20.2061 12.2784L11.479 21.0053L11.4259 21.0548L11.3702 21.0997C10.7009 21.6759 9.84594 22 8.9429 22C6.88779 22 5.22179 20.334 5.22179 18.2789C5.22179 17.3775 5.54481 16.5248 6.11735 15.8574L6.26564 15.6945L6.28072 15.6826L13.5717 8.37879C13.9619 7.98793 14.5951 7.98737 14.986 8.37755C15.3768 8.76774 15.3774 9.4009 14.9872 9.79177L7.69618 17.0956L7.68524 17.1039C7.38894 17.4208 7.22179 17.8354 7.22179 18.2789C7.22179 19.2294 7.99236 20 8.9429 20C9.32185 20 9.67979 19.8781 9.97412 19.6571L10.0962 19.5564L10.097 19.558L18.7994 10.8571L18.958 10.6927C19.6231 9.96299 19.9999 9.0125 19.9999 8C19.9999 5.79086 18.2091 4 15.9999 4C14.9383 4 13.9453 4.4146 13.2048 5.13858L13.0501 5.29842L13.0316 5.31139L3.70629 14.6403C3.31585 15.0309 2.68269 15.031 2.29207 14.6406C1.90146 14.2501 1.90132 13.617 2.29176 13.2264L11.6007 3.91324L11.6473 3.87021C12.7712 2.68577 14.3316 2 15.9999 2Z " },
            { FluentSymbol.Attach24, "M11.7717 3.7431C14.1132 1.39951 17.9121 1.39951 20.2553 3.74266C22.5384 6.02572 22.5969 9.69093 20.4309 12.0449L20.2428 12.2422L11.4427 21.0404L11.4062 21.0707C9.94492 22.3875 7.69092 22.3427 6.28355 20.9353C4.96453 19.6163 4.84241 17.5536 5.9172 16.0969C5.94054 16.0516 5.96879 16.0078 6.002 15.9667L6.05556 15.907L6.14247 15.8193L6.28355 15.6714L6.28647 15.6743L13.7222 8.21998C13.9881 7.95336 14.4047 7.9286 14.6986 8.14607L14.7829 8.21857C15.0495 8.48449 15.0742 8.90112 14.8568 9.19502L14.7843 9.27923L7.18966 16.8923C6.47202 17.7679 6.5219 19.0622 7.3393 19.8796C8.16836 20.7087 9.48801 20.7481 10.3638 19.998L19.1965 11.1676C20.952 9.40992 20.952 6.56068 19.1946 4.80332C17.4922 3.10087 14.765 3.04767 12.9986 4.64371L12.8307 4.80332L12.8181 4.81763L3.28179 14.354C2.9889 14.6468 2.51403 14.6468 2.22113 14.354C1.95487 14.0877 1.93066 13.671 2.14852 13.3774L2.22113 13.2933L11.77 3.74266L11.7717 3.7431Z " },
            { FluentSymbol.AttachArrowRight20Filled, "M5.28033 10.6088L10.5836 5.30546C11.6576 4.23151 13.3988 4.23151 14.4727 5.30546C15.4846 6.31734 15.5431 7.92161 14.6481 9.00196C15.2102 9.01682 15.7514 9.11602 16.2593 9.28738C17.141 7.67431 16.899 5.61046 15.5334 4.2448C13.8737 2.58507 11.1827 2.58507 9.52297 4.2448L4.21967 9.5481C3.92678 9.84099 3.92678 10.3159 4.21967 10.6088C4.51256 10.9017 4.98744 10.9017 5.28033 10.6088ZM8.10876 15.5585L9.00242 14.6648C9.02074 15.2872 9.14246 15.8837 9.351 16.4376L9.16942 16.6192C8.09548 17.6931 6.35427 17.6931 5.28033 16.6192C4.20639 15.5452 4.20639 13.804 5.28033 12.7301L10.9372 7.07322C11.2301 6.78033 11.705 6.78033 11.9978 7.07322C12.2907 7.36612 12.2907 7.84099 11.9978 8.13388L6.34099 13.7907C5.85283 14.2789 5.85283 15.0703 6.34099 15.5585C6.82915 16.0467 7.6206 16.0467 8.10876 15.5585ZM19 14.5C19 16.9853 16.9853 19 14.5 19C12.0147 19 10 16.9853 10 14.5C10 12.0147 12.0147 10 14.5 10C16.9853 10 19 12.0147 19 14.5ZM16.8532 14.854L16.8557 14.8514C16.9026 14.804 16.938 14.7495 16.9621 14.6914C16.9861 14.6333 16.9996 14.5697 17 14.503L17 14.5L17 14.497C16.9996 14.4303 16.9861 14.3667 16.9621 14.3086C16.9377 14.2496 16.9015 14.1944 16.8536 14.1464L14.8536 12.1464C14.6583 11.9512 14.3417 11.9512 14.1464 12.1464C13.9512 12.3417 13.9512 12.6583 14.1464 12.8536L15.2929 14H12.5C12.2239 14 12 14.2239 12 14.5C12 14.7761 12.2239 15 12.5 15H15.2929L14.1464 16.1464C13.9512 16.3417 13.9512 16.6583 14.1464 16.8536C14.3417 17.0488 14.6583 17.0488 14.8536 16.8536L16.8532 14.854Z " },
            { FluentSymbol.AttachArrowRight20, "M4.82841 10.4853L10.4853 4.82845C11.6568 3.65688 13.5563 3.65688 14.7279 4.82845C15.8785 5.97905 15.8991 7.83176 14.7897 9.0075C15.1799 9.02775 15.5594 9.08867 15.9239 9.18611C16.9752 7.6303 16.8123 5.49859 15.435 4.12134C13.8729 2.55924 11.3403 2.55924 9.77815 4.12134L4.1213 9.77819C3.92604 9.97346 3.92604 10.29 4.1213 10.4853C4.31656 10.6806 4.63315 10.6806 4.82841 10.4853ZM8.01039 15.7886L9.00759 14.7914C9.02944 15.21 9.09808 15.6162 9.2084 16.0048L8.71749 16.4957C7.74118 17.472 6.15827 17.472 5.18196 16.4957C4.20565 15.5194 4.20565 13.9365 5.18196 12.9602L11.1924 6.94977C11.3876 6.75451 11.7042 6.75451 11.8995 6.94977C12.0947 7.14503 12.0947 7.46161 11.8995 7.65687L5.88907 13.6673C5.30328 14.2531 5.30328 15.2028 5.88907 15.7886C6.47485 16.3744 7.4246 16.3744 8.01039 15.7886ZM19 14.5C19 16.9853 16.9853 19 14.5 19C12.0147 19 10 16.9853 10 14.5C10 12.0147 12.0147 10 14.5 10C16.9853 10 19 12.0147 19 14.5ZM16.8532 14.854L16.8557 14.8514C16.9026 14.804 16.938 14.7495 16.9621 14.6914C16.9861 14.6333 16.9996 14.5697 17 14.503L17 14.5L17 14.497C16.9996 14.4303 16.9861 14.3667 16.9621 14.3086C16.9377 14.2496 16.9015 14.1944 16.8536 14.1464L14.8536 12.1464C14.6583 11.9512 14.3417 11.9512 14.1464 12.1464C13.9512 12.3417 13.9512 12.6583 14.1464 12.8536L15.2929 14H12.5C12.2239 14 12 14.2239 12 14.5C12 14.7761 12.2239 15 12.5 15H15.2929L14.1464 16.1464C13.9512 16.3417 13.9512 16.6583 14.1464 16.8536C14.3417 17.0488 14.6583 17.0488 14.8536 16.8536L16.8532 14.854Z " },
            { FluentSymbol.AttachArrowRight24Filled, "M15.9999 2C19.3136 2 21.9999 4.68629 21.9999 8C21.9999 9.41133 21.5093 10.7466 20.6383 11.8064C20.0055 11.4569 19.3083 11.2098 18.569 11.0875L18.7994 10.8571L18.958 10.6927C19.6231 9.96299 19.9999 9.0125 19.9999 8C19.9999 5.79086 18.2091 4 15.9999 4C14.9383 4 13.9453 4.4146 13.2048 5.13858L13.0501 5.29842L13.0316 5.31139L3.70629 14.6403C3.31585 15.0309 2.68269 15.031 2.29207 14.6406C1.90146 14.2501 1.90132 13.617 2.29176 13.2264L11.6007 3.91324L11.6473 3.87021C12.7712 2.68577 14.3316 2 15.9999 2ZM11.0872 18.5679C11.2112 19.3176 11.4634 20.024 11.8205 20.6638L11.479 21.0053L11.4259 21.0548L11.3702 21.0997C10.7009 21.6759 9.84594 22 8.9429 22C6.88779 22 5.22179 20.334 5.22179 18.2789C5.22179 17.3775 5.54481 16.5248 6.11735 15.8574L6.26564 15.6945L6.28072 15.6826L13.5717 8.37879C13.9619 7.98793 14.5951 7.98737 14.986 8.37755C15.3768 8.76774 15.3774 9.4009 14.9872 9.79177L7.69618 17.0956L7.68524 17.1039C7.38894 17.4208 7.22179 17.8354 7.22179 18.2789C7.22179 19.2294 7.99236 20 8.9429 20C9.32185 20 9.67979 19.8781 9.97412 19.6571L10.0962 19.5564L10.097 19.558L11.0872 18.5679ZM22.9999 17.5C22.9999 20.5376 20.5375 23 17.4999 23C14.4624 23 11.9999 20.5376 11.9999 17.5C11.9999 14.4624 14.4624 12 17.4999 12C20.5375 12 22.9999 14.4624 22.9999 17.5ZM14.4999 17C14.2238 17 13.9999 17.2239 13.9999 17.5C13.9999 17.7761 14.2238 18 14.4999 18L19.2928 18L17.6464 19.6464C17.4511 19.8417 17.4511 20.1583 17.6464 20.3536C17.8416 20.5488 18.1582 20.5488 18.3535 20.3536L20.8535 17.8536C21.0488 17.6583 21.0488 17.3417 20.8535 17.1464L18.3535 14.6464C18.1582 14.4512 17.8416 14.4512 17.6464 14.6464C17.4511 14.8417 17.4511 15.1583 17.6464 15.3536L19.2928 17L14.4999 17Z " },
            { FluentSymbol.AttachArrowRight24, "M11.7717 3.74346C14.1132 1.39988 17.9121 1.39988 20.2553 3.74302C22.4626 5.95037 22.5906 9.4497 20.6391 11.8068C20.1753 11.5505 19.6768 11.3493 19.1525 11.2119L19.1965 11.1679C20.952 9.41028 20.952 6.56104 19.1946 4.80368C17.4922 3.10124 14.765 3.04804 12.9986 4.64408L12.8307 4.80368L12.8181 4.81799L3.28179 14.3543C2.9889 14.6472 2.51403 14.6472 2.22113 14.3543C1.95487 14.0881 1.93066 13.6714 2.14852 13.3778L2.22113 13.2937L11.77 3.74302L11.7717 3.74346ZM11.2116 19.1508C11.3514 19.6848 11.5574 20.1921 11.8204 20.6632L11.4427 21.0408L11.4062 21.071C9.94492 22.3878 7.69092 22.3431 6.28355 20.9357C4.96453 19.6167 4.84241 17.554 5.9172 16.0973C5.94054 16.0519 5.96879 16.0082 6.002 15.967L6.05556 15.9074L6.14247 15.8197L6.28355 15.6718L6.28647 15.6747L13.7222 8.22035C13.9881 7.95373 14.4047 7.92897 14.6986 8.14643L14.7829 8.21894C15.0495 8.48485 15.0742 8.90148 14.8568 9.19538L14.7843 9.2796L7.18966 16.8927C6.47202 17.7683 6.5219 19.0626 7.3393 19.88C8.16836 20.709 9.48801 20.7485 10.3638 19.9984L11.2116 19.1508ZM23.0001 17.5C23.0001 20.5376 20.5377 23 17.5001 23C14.4626 23 12.0001 20.5376 12.0001 17.5C12.0001 14.4624 14.4626 12 17.5001 12C20.5377 12 23.0001 14.4624 23.0001 17.5ZM14.5001 17C14.224 17 14.0001 17.2239 14.0001 17.5C14.0001 17.7761 14.224 18 14.5001 18H19.293L17.6466 19.6464C17.4513 19.8417 17.4513 20.1583 17.6466 20.3536C17.8418 20.5488 18.1584 20.5488 18.3537 20.3536L20.8537 17.8536C21.0489 17.6583 21.0489 17.3417 20.8537 17.1464L18.3537 14.6464C18.1584 14.4512 17.8418 14.4512 17.6466 14.6464C17.4513 14.8417 17.4513 15.1583 17.6466 15.3536L19.293 17L14.5001 17Z " },
            { FluentSymbol.AttachText24Filled, "M7 3C9.68876 3 11.8818 5.12231 11.9954 7.78311L12 8V19C12 20.6569 10.6569 22 9 22C7.40232 22 6.09634 20.7511 6.00509 19.1763L6 19V9C6 8.44772 6.44772 8 7 8C7.51284 8 7.93551 8.38604 7.99327 8.88338L8 9V19C8 19.5523 8.44772 20 9 20C9.51284 20 9.93551 19.614 9.99327 19.1166L10 19V8C10 6.34315 8.65685 5 7 5C5.40232 5 4.09634 6.24892 4.00509 7.82373L4 8V17C4 17.5523 3.55228 18 3 18C2.48716 18 2.06449 17.614 2.00673 17.1166L2 17V8C2 5.23858 4.23858 3 7 3ZM15 17H17C17.5523 17 18 17.4477 18 18C18 18.5128 17.614 18.9355 17.1166 18.9933L17 19H15C14.4477 19 14 18.5523 14 18C14 17.4872 14.386 17.0645 14.8834 17.0067L15 17H17H15ZM15 13H20.5C21.0523 13 21.5 13.4477 21.5 14C21.5 14.5128 21.114 14.9355 20.6166 14.9933L20.5 15H15C14.4477 15 14 14.5523 14 14C14 13.4872 14.386 13.0645 14.8834 13.0067L15 13H20.5H15ZM15 9H20.5C21.0523 9 21.5 9.44772 21.5 10C21.5 10.5128 21.114 10.9355 20.6166 10.9933L20.5 11H15C14.4477 11 14 10.5523 14 10C14 9.48716 14.386 9.06449 14.8834 9.00673L15 9H20.5H15ZM15 5H20.5C21.0523 5 21.5 5.44772 21.5 6C21.5 6.51284 21.114 6.93551 20.6166 6.99327L20.5 7H15C14.4477 7 14 6.55228 14 6C14 5.48716 14.386 5.06449 14.8834 5.00673L15 5H20.5H15Z " },
            { FluentSymbol.AttachText24, "M7.25 3.5C9.52817 3.5 11.3877 5.29251 11.4951 7.54408L11.5 7.75V18.5C11.5 19.8807 10.3807 21 9 21C7.67452 21 6.58996 19.9685 6.50532 18.6644L6.5 18.5V9C6.5 8.58579 6.83579 8.25 7.25 8.25C7.6297 8.25 7.94349 8.53215 7.99315 8.89823L8 9V18.5C8 19.0523 8.44772 19.5 9 19.5C9.51284 19.5 9.93551 19.114 9.99327 18.6166L10 18.5V7.75C10 6.23122 8.76878 5 7.25 5C5.78747 5 4.5916 6.1417 4.50502 7.58248L4.5 7.75V17C4.5 17.4142 4.16421 17.75 3.75 17.75C3.3703 17.75 3.05651 17.4678 3.00685 17.1018L3 17V7.75C3 5.40279 4.90279 3.5 7.25 3.5ZM16.25 16C16.6642 16 17 16.3358 17 16.75C17 17.1297 16.7178 17.4435 16.3518 17.4932L16.25 17.5H13.75C13.3358 17.5 13 17.1642 13 16.75C13 16.3703 13.2822 16.0565 13.6482 16.0068L13.75 16H16.25ZM20.25 13C20.6642 13 21 13.3358 21 13.75C21 14.1297 20.7178 14.4435 20.3518 14.4932L20.25 14.5H13.75C13.3358 14.5 13 14.1642 13 13.75C13 13.3703 13.2822 13.0565 13.6482 13.0068L13.75 13H20.25ZM20.25 10C20.6642 10 21 10.3358 21 10.75C21 11.1297 20.7178 11.4435 20.3518 11.4932L20.25 11.5H13.75C13.3358 11.5 13 11.1642 13 10.75C13 10.3703 13.2822 10.0565 13.6482 10.0068L13.75 10H20.25ZM20.25 7C20.6642 7 21 7.33579 21 7.75C21 8.1297 20.7178 8.44349 20.3518 8.49315L20.25 8.5H13.75C13.3358 8.5 13 8.16421 13 7.75C13 7.3703 13.2822 7.05651 13.6482 7.00685L13.75 7H20.25Z " },
            { FluentSymbol.Autocorrect24Filled, "M13.594 4.7225C13.9773 4.96289 14.3013 5.28687 14.5417 5.6702C15.6565 7.44786 16.614 8.97468 17.4142 10.2507L21.5001 10.2496C22.0524 10.2496 22.5001 10.6974 22.5001 11.2496C22.5001 11.8019 22.0524 12.2496 21.5001 12.2496L18.7496 12.2484C19.3778 13.0843 19.7501 14.1235 19.7501 15.2496C19.7501 18.0111 17.5116 20.2496 14.7501 20.2496C11.9887 20.2496 9.75013 18.0111 9.75013 15.2496C9.75013 12.4882 11.9887 10.2496 14.7501 10.2496L15.053 10.2487L14.7693 9.79664C14.1801 8.85795 13.5393 7.83621 12.8473 6.73278C12.7672 6.605 12.6592 6.49701 12.5314 6.41688C12.097 6.14441 11.5338 6.2469 11.2206 6.63755L11.1529 6.73278L3.59732 18.7809C3.3039 19.2488 2.68673 19.3903 2.21884 19.0968C1.78437 18.8244 1.63139 18.2728 1.84668 17.8207L1.90294 17.7184L9.45856 5.6702C10.3388 4.26653 12.1903 3.84223 13.594 4.7225ZM14.7501 12.2496C13.0933 12.2496 11.7501 13.5928 11.7501 15.2496C11.7501 16.9065 13.0933 18.2496 14.7501 18.2496C16.407 18.2496 17.7501 16.9065 17.7501 15.2496C17.7501 13.5928 16.407 12.2496 14.7501 12.2496Z " },
            { FluentSymbol.Autocorrect24, "M13.4611 4.93426C13.754 5.11789 14.009 5.35474 14.2134 5.63194L14.3299 5.80299L17.275 10.4987L21.5001 10.4996C21.8798 10.4996 22.1936 10.7818 22.2433 11.1478L22.2501 11.2496C22.2501 11.6638 21.9143 11.9996 21.5001 11.9996L18.216 11.9987L18.2217 12.0076L18.213 11.9987C19.0112 12.8482 19.5001 13.9918 19.5001 15.2496C19.5001 17.873 17.3735 19.9996 14.7501 19.9996C12.1267 19.9996 10.0001 17.873 10.0001 15.2496C10.0001 12.6263 12.1267 10.4996 14.7501 10.4996L15.506 10.4987L13.0591 6.59992C12.9589 6.4402 12.8239 6.30521 12.6642 6.20505C12.1183 5.86272 11.4099 5.9939 11.0197 6.48843L10.9411 6.59992L3.38549 18.6481C3.16543 18.999 2.70255 19.1051 2.35163 18.885C2.03262 18.6849 1.91595 18.2842 2.06271 17.9494L2.11471 17.8511L9.67033 5.80299C10.4772 4.51629 12.1744 4.12735 13.4611 4.93426ZM14.7501 11.9996C12.9552 11.9996 11.5001 13.4547 11.5001 15.2496C11.5001 17.0445 12.9552 18.4996 14.7501 18.4996C16.545 18.4996 18.0001 17.0445 18.0001 15.2496C18.0001 13.4547 16.545 11.9996 14.7501 11.9996Z " },
            { FluentSymbol.AutoFitContent24Filled, "M6.06443 5.24389C6.33719 4.93217 6.30561 4.45834 5.99388 4.18558C5.68216 3.91282 5.20833 3.9444 4.93557 4.25613L3.18557 6.25611C2.93815 6.53888 2.93814 6.96109 3.18557 7.24386L4.93557 9.24389C5.20833 9.55561 5.68215 9.58721 5.99388 9.31445C6.3056 9.04169 6.33719 8.56786 6.06444 8.25613L5.40281 7.49999H8.26456C8.67877 7.49999 9.01456 7.1642 9.01456 6.74999C9.01456 6.33578 8.67877 5.99999 8.26456 5.99999H5.40284L6.06443 5.24389Z M18.0208 4.18558C17.709 4.45834 17.6775 4.93217 17.9502 5.24389L18.6118 5.99999H15.7501C15.3359 5.99999 15.0001 6.33578 15.0001 6.74999C15.0001 7.1642 15.3359 7.49999 15.7501 7.49999H18.6118L17.9502 8.25613C17.6775 8.56786 17.709 9.04169 18.0208 9.31445C18.3325 9.58721 18.8063 9.55561 19.0791 9.24389L20.8291 7.24386C21.0765 6.96109 21.0765 6.53888 20.8291 6.25611L19.0791 4.25613C18.8063 3.9444 18.3325 3.91282 18.0208 4.18558Z M5.75 11C4.23122 11 3 12.2312 3 13.75V17.75C3 19.2688 4.23122 20.5 5.75 20.5H18.25C19.7688 20.5 21 19.2688 21 17.75V13.75C21 12.2312 19.7688 11 18.25 11H5.75ZM6 15.75C6 15.3358 6.33579 15 6.75 15H17.25C17.6642 15 18 15.3358 18 15.75C18 16.1642 17.6642 16.5 17.25 16.5H6.75C6.33579 16.5 6 16.1642 6 15.75Z " },
            { FluentSymbol.AutoFitContent24, "M5.99388 4.18558C6.30561 4.45834 6.33719 4.93217 6.06443 5.24389L5.40284 5.99999H8.26456C8.67877 5.99999 9.01456 6.33578 9.01456 6.74999C9.01456 7.1642 8.67877 7.49999 8.26456 7.49999H5.40281L6.06444 8.25613C6.33719 8.56786 6.3056 9.04169 5.99388 9.31445C5.68215 9.58721 5.20833 9.55561 4.93557 9.24389L3.18557 7.24386C2.93814 6.96109 2.93815 6.53888 3.18557 6.25611L4.93557 4.25613C5.20833 3.9444 5.68216 3.91282 5.99388 4.18558Z M17.9502 5.24389C17.6775 4.93217 17.709 4.45834 18.0208 4.18558C18.3325 3.91282 18.8063 3.9444 19.0791 4.25613L20.8291 6.25611C21.0765 6.53888 21.0765 6.96109 20.8291 7.24386L19.0791 9.24389C18.8063 9.55561 18.3325 9.58721 18.0208 9.31445C17.709 9.04169 17.6775 8.56786 17.9502 8.25613L18.6118 7.49999H15.7501C15.3359 7.49999 15.0001 7.1642 15.0001 6.74999C15.0001 6.33578 15.3359 5.99999 15.7501 5.99999H18.6118L17.9502 5.24389Z M6 15.75C6 15.3358 6.33579 15 6.75 15H17.25C17.6642 15 18 15.3358 18 15.75C18 16.1642 17.6642 16.5 17.25 16.5H6.75C6.33579 16.5 6 16.1642 6 15.75Z M5.75 11C4.23122 11 3 12.2312 3 13.75V17.75C3 19.2688 4.23122 20.5 5.75 20.5H18.25C19.7688 20.5 21 19.2688 21 17.75V13.75C21 12.2312 19.7688 11 18.25 11H5.75ZM4.5 13.75C4.5 13.0596 5.05964 12.5 5.75 12.5H18.25C18.9404 12.5 19.5 13.0596 19.5 13.75V17.75C19.5 18.4404 18.9404 19 18.25 19H5.75C5.05964 19 4.5 18.4404 4.5 17.75V13.75Z " },
            { FluentSymbol.AutoSum20Filled, "M3.80991 3.70633C3.92766 3.42962 4.1993 3.25 4.50002 3.25H15.5C15.9142 3.25 16.25 3.58579 16.25 4C16.25 4.41421 15.9142 4.75 15.5 4.75H6.26246L10.4077 9.05817C10.6731 9.334 10.6882 9.76544 10.4428 10.0592L6.10432 15.25H15.5C15.9142 15.25 16.25 15.5858 16.25 16C16.25 16.4142 15.9142 16.75 15.5 16.75H4.50002C4.20881 16.75 3.94392 16.5814 3.8206 16.3176C3.69727 16.0538 3.7378 15.7425 3.92455 15.519L8.86039 9.61341L3.95957 4.52001C3.75107 4.30332 3.69216 3.98303 3.80991 3.70633Z " },
            { FluentSymbol.AutoSum20, "M4.03994 3.80422C4.11844 3.61975 4.29953 3.5 4.50001 3.5H15.5C15.7762 3.5 16 3.72386 16 4C16 4.27614 15.7762 4.5 15.5 4.5H5.67498L10.2276 9.23151C10.4045 9.4154 10.4146 9.70302 10.2509 9.89883L5.56955 15.5H15.5C15.7762 15.5 16 15.7239 16 16C16 16.2761 15.7762 16.5 15.5 16.5H4.50001C4.30587 16.5 4.12928 16.3876 4.04706 16.2118C3.96485 16.0359 3.99186 15.8283 4.11637 15.6794L9.19602 9.60167L4.13971 4.34668C4.00071 4.20221 3.96144 3.98869 4.03994 3.80422Z " },
            { FluentSymbol.AutoSum24Filled, "M4.82931 4.60976C4.98599 4.24011 5.34854 4 5.75003 4H18.25C18.8023 4 19.25 4.44772 19.25 5C19.25 5.55228 18.8023 6 18.25 6H8.10936L13.0595 11.1152C13.4185 11.4862 13.4362 12.0694 13.1002 12.4614L7.92425 18.5H18.25C18.8023 18.5 19.25 18.9477 19.25 19.5C19.25 20.0523 18.8023 20.5 18.25 20.5H5.75003C5.3595 20.5 5.0047 20.2727 4.84151 19.9179C4.67833 19.5631 4.73662 19.1457 4.99077 18.8492L10.9889 11.8514L5.03142 5.69542C4.75223 5.40692 4.67264 4.97941 4.82931 4.60976Z " },
            { FluentSymbol.AutoSum24, "M5.05949 4.45732C5.17699 4.18008 5.44891 4 5.75002 4H18.25C18.6642 4 19 4.33579 19 4.75C19 5.16421 18.6642 5.5 18.25 5.5H7.51952L12.8799 11.039C13.1491 11.3173 13.1623 11.7547 12.9104 12.0487L7.38068 18.5H18.25C18.6642 18.5 19 18.8358 19 19.25C19 19.6642 18.6642 20 18.25 20H5.75002C5.45712 20 5.19102 19.8295 5.06863 19.5634C4.94625 19.2973 4.98996 18.9843 5.18058 18.7619L11.3269 11.5912L5.21107 5.27157C5.00167 5.05519 4.94198 4.73455 5.05949 4.45732Z " },
            { FluentSymbol.Backpack12Filled, "M4.062 3.5H4V2.5C4 1.67157 4.67157 1 5.5 1H6.5C7.32843 1 8 1.67157 8 2.5V3.5H7.938C9.16771 4.18236 10 5.49399 10 7V9.5C10 10.3284 9.32843 11 8.5 11H3.5C2.67157 11 2 10.3284 2 9.5V7C2 5.49399 2.83229 4.18236 4.062 3.5ZM5 2.5V3.12602C5.31962 3.04375 5.6547 3 6 3C6.3453 3 6.68038 3.04375 7 3.12602V2.5C7 2.22386 6.77614 2 6.5 2H5.5C5.22386 2 5 2.22386 5 2.5ZM5 5.5C5 5.77614 5.22386 6 5.5 6H6.5C6.77614 6 7 5.77614 7 5.5C7 5.22386 6.77614 5 6.5 5H5.5C5.22386 5 5 5.22386 5 5.5ZM4.5 8C4.22386 8 4 8.22386 4 8.5C4 8.77614 4.22386 9 4.5 9H7.5C7.77614 9 8 8.77614 8 8.5C8 8.22386 7.77614 8 7.5 8H4.5Z " },
            { FluentSymbol.Backpack12, "M5 5.5C5 5.22386 5.22386 5 5.5 5H6.5C6.77614 5 7 5.22386 7 5.5C7 5.77614 6.77614 6 6.5 6H5.5C5.22386 6 5 5.77614 5 5.5Z M4.5 8C4.22386 8 4 8.22386 4 8.5C4 8.77614 4.22386 9 4.5 9H7.5C7.77614 9 8 8.77614 8 8.5C8 8.22386 7.77614 8 7.5 8H4.5Z M4.062 3.5H4V2.5C4 1.67157 4.67157 1 5.5 1H6.5C7.32843 1 8 1.67157 8 2.5V3.5H7.938C9.16771 4.18236 10 5.49399 10 7V9.5C10 10.3284 9.32843 11 8.5 11H3.5C2.67157 11 2 10.3284 2 9.5V7C2 5.49399 2.83229 4.18236 4.062 3.5ZM5 2.5V3.12602C5.31962 3.04375 5.6547 3 6 3C6.3453 3 6.68038 3.04375 7 3.12602V2.5C7 2.22386 6.77614 2 6.5 2H5.5C5.22386 2 5 2.22386 5 2.5ZM3 7V9.5C3 9.77614 3.22386 10 3.5 10H8.5C8.77614 10 9 9.77614 9 9.5V7C9 5.34315 7.65685 4 6 4C4.34315 4 3 5.34315 3 7Z " },
            { FluentSymbol.Backpack16Filled, "M6 8C6 7.44772 6.44772 7 7 7H9C9.55228 7 10 7.44772 10 8H6Z M8 1C6.89543 1 6 1.89543 6 3V3.41604C4.2341 4.1876 3 5.94968 3 8V10H13V8C13 5.94968 11.7659 4.1876 10 3.41604V3C10 1.89543 9.10457 1 8 1ZM8 3C7.65753 3 7.32311 3.03443 7 3.10002V3C7 2.44772 7.44772 2 8 2C8.55228 2 9 2.44772 9 3V3.10002C8.67689 3.03443 8.34247 3 8 3ZM7 6H9C10.1046 6 11 6.89543 11 8C11 8.55228 10.5523 9 10 9H6C5.44772 9 5 8.55229 5 8C5 6.89543 5.89543 6 7 6Z M6 12.5V11H3V12.5C3 13.8807 4.11929 15 5.5 15H10.5C11.8807 15 13 13.8807 13 12.5V11H7V12.5C7 12.7761 6.77614 13 6.5 13C6.22386 13 6 12.7761 6 12.5Z " },
            { FluentSymbol.Backpack16, "M7 6C5.89543 6 5 6.89543 5 8C5 8.55229 5.44772 9 6 9H10C10.5523 9 11 8.55228 11 8C11 6.89543 10.1046 6 9 6H7ZM6 8C6 7.44772 6.44772 7 7 7H9C9.55228 7 10 7.44772 10 8H6Z M8 1C6.89543 1 6 1.89543 6 3V3.41604C4.2341 4.1876 3 5.94968 3 8V12.5C3 13.8807 4.11929 15 5.5 15H10.5C11.8807 15 13 13.8807 13 12.5V8C13 5.94968 11.7659 4.1876 10 3.41604V3C10 1.89543 9.10457 1 8 1ZM12 10H4V8C4 5.79086 5.79086 4 8 4C10.2091 4 12 5.79086 12 8V10ZM6 12.5C6 12.7761 6.22386 13 6.5 13C6.77614 13 7 12.7761 7 12.5V11H12V12.5C12 13.3284 11.3284 14 10.5 14H5.5C4.67157 14 4 13.3284 4 12.5V11H6V12.5ZM8 3C7.65753 3 7.32311 3.03443 7 3.10002V3C7 2.44772 7.44772 2 8 2C8.55228 2 9 2.44772 9 3V3.10002C8.67689 3.03443 8.34247 3 8 3Z " },
            { FluentSymbol.Backpack20Filled, "M8 8.7C8 8.3134 8.3134 8 8.7 8H11.3C11.6866 8 12 8.3134 12 8.7C12 8.86569 11.8657 9 11.7 9H8.3C8.13431 9 8 8.86569 8 8.7Z M10 2C8.61929 2 7.5 3.11929 7.5 4.5V4.54404C5.43447 5.49205 4 7.57851 4 10V12H16V10C16 7.57851 14.5655 5.49205 12.5 4.54404V4.5C12.5 3.11929 11.3807 2 10 2ZM10 4C10.5057 4 10.9967 4.06255 11.4659 4.18035C11.3194 3.50549 10.7187 3 10 3C9.28127 3 8.68061 3.50549 8.53413 4.18035C9.00327 4.06255 9.49433 4 10 4ZM8.7 7H11.3C12.2389 7 13 7.76112 13 8.7C13 9.41797 12.418 10 11.7 10H8.3C7.58203 10 7 9.41797 7 8.7C7 7.76112 7.76112 7 8.7 7Z M7 14.5V13H4V15C4 16.6569 5.34315 18 7 18H13C14.6569 18 16 16.6569 16 15V13H8V14.5C8 14.7761 7.77614 15 7.5 15C7.22386 15 7 14.7761 7 14.5Z " },
            { FluentSymbol.Backpack20, "M8.7 7C7.76112 7 7 7.76112 7 8.7C7 9.41797 7.58203 10 8.3 10H11.7C12.418 10 13 9.41797 13 8.7C13 7.76112 12.2389 7 11.3 7H8.7ZM8 8.7C8 8.3134 8.3134 8 8.7 8H11.3C11.6866 8 12 8.3134 12 8.7C12 8.86569 11.8657 9 11.7 9H8.3C8.13431 9 8 8.86569 8 8.7Z M10 2C8.61929 2 7.5 3.11929 7.5 4.5V4.54404C5.43447 5.49205 4 7.57851 4 10V15C4 16.6569 5.34315 18 7 18H13C14.6569 18 16 16.6569 16 15V10C16 7.57851 14.5655 5.49205 12.5 4.54404V4.5C12.5 3.11929 11.3807 2 10 2ZM15 12H5V10C5 7.23858 7.23858 5 10 5C12.7614 5 15 7.23858 15 10V12ZM7 14.5C7 14.7761 7.22386 15 7.5 15C7.77614 15 8 14.7761 8 14.5V13H15V15C15 16.1046 14.1046 17 13 17H7C5.89543 17 5 16.1046 5 15V13H7V14.5ZM10 4C9.49433 4 9.00327 4.06255 8.53413 4.18035C8.68061 3.50549 9.28127 3 10 3C10.7187 3 11.3194 3.50549 11.4659 4.18035C10.9967 4.06255 10.5057 4 10 4Z " },
            { FluentSymbol.Backpack24Filled, "M12 2C10.0387 2 8.4291 3.50566 8.26396 5.42415C5.72794 6.76594 4 9.43118 4 12.5V14H20V12.5C20 9.43118 18.2721 6.76594 15.736 5.42415C15.5709 3.50566 13.9613 2 12 2ZM20 15.7143H9.5V17.25C9.5 17.6642 9.16421 18 8.75 18C8.33579 18 8 17.6642 8 17.25V15.7143H4V18.75C4 20.5449 5.45507 22 7.25 22H16.75C18.5449 22 20 20.5449 20 18.75V15.7143ZM12 4.5C11.3023 4.5 10.6255 4.58931 9.98036 4.75712C10.3472 4.0124 11.1137 3.5 12 3.5C12.8863 3.5 13.6528 4.0124 14.0196 4.75712C13.3745 4.58931 12.6977 4.5 12 4.5ZM8 10.4167C8 9.08198 9.08198 8 10.4167 8H13.5833C14.918 8 16 9.08198 16 10.4167C16 11.2911 15.2911 12 14.4167 12H9.58333C8.70888 12 8 11.2911 8 10.4167ZM10.4167 9.5C9.91041 9.5 9.5 9.91041 9.5 10.4167C9.5 10.4627 9.53731 10.5 9.58333 10.5H14.4167C14.4627 10.5 14.5 10.4627 14.5 10.4167C14.5 9.91041 14.0896 9.5 13.5833 9.5H10.4167Z " },
            { FluentSymbol.Backpack24, "M10.4167 8C9.08198 8 8 9.08198 8 10.4167C8 11.2911 8.70888 12 9.58333 12H14.4167C15.2911 12 16 11.2911 16 10.4167C16 9.08198 14.918 8 13.5833 8H10.4167ZM9.5 10.4167C9.5 9.91041 9.91041 9.5 10.4167 9.5H13.5833C14.0896 9.5 14.5 9.91041 14.5 10.4167C14.5 10.4627 14.4627 10.5 14.4167 10.5H9.58333C9.53731 10.5 9.5 10.4627 9.5 10.4167Z M12 2C10.0387 2 8.4291 3.50566 8.26396 5.42415C5.72794 6.76594 4 9.43118 4 12.5V18.75C4 20.5449 5.45507 22 7.25 22H16.75C18.5449 22 20 20.5449 20 18.75V12.5C20 9.43118 18.2721 6.76594 15.736 5.42415C15.5709 3.50566 13.9613 2 12 2ZM18.5 14H5.5V12.5C5.5 8.91015 8.41015 6 12 6C15.5899 6 18.5 8.91015 18.5 12.5V14ZM8 17.25C8 17.6642 8.33579 18 8.75 18C9.16421 18 9.5 17.6642 9.5 17.25V15.7143H18.5V18.75C18.5 19.7165 17.7165 20.5 16.75 20.5H7.25C6.2835 20.5 5.5 19.7165 5.5 18.75V15.7143H8V17.25ZM12 4.5C11.3023 4.5 10.6255 4.58931 9.98036 4.75712C10.3472 4.0124 11.1137 3.5 12 3.5C12.8863 3.5 13.6528 4.0124 14.0196 4.75712C13.3745 4.58931 12.6977 4.5 12 4.5Z " },
            { FluentSymbol.Backpack28Filled, "M10.5 12.25C10.5 11.2835 11.2835 10.5 12.25 10.5H15.75C16.7165 10.5 17.5 11.2835 17.5 12.25C17.5 12.3881 17.3881 12.5 17.25 12.5H10.75C10.6119 12.5 10.5 12.3881 10.5 12.25Z M14 2C11.3724 2 9.19568 3.93032 8.81053 6.45023C5.92632 8.20462 4 11.3774 4 15V16H24V15C24 11.3774 22.0737 8.20462 19.1895 6.45023C18.8043 3.93032 16.6276 2 14 2ZM14 5C13.0868 5 12.2022 5.1224 11.3617 5.3517C11.9518 4.53298 12.9137 4 14 4C15.0863 4 16.0482 4.53298 16.6383 5.3517C15.7978 5.12241 14.9132 5 14 5ZM12.25 9H15.75C17.5449 9 19 10.4551 19 12.25C19 13.2165 18.2165 14 17.25 14H10.75C9.7835 14 9 13.2165 9 12.25C9 10.4551 10.4551 9 12.25 9Z M9 19.25V17.5H4V22C4 24.2091 5.79086 26 8 26H20C22.2091 26 24 24.2091 24 22V17.5H10.5V19.25C10.5 19.6642 10.1642 20 9.75 20C9.33579 20 9 19.6642 9 19.25Z " },
            { FluentSymbol.Backpack28, "M9 12.25C9 10.4551 10.4551 9 12.25 9H15.75C17.5449 9 19 10.4551 19 12.25C19 13.2165 18.2165 14 17.25 14H10.75C9.7835 14 9 13.2165 9 12.25ZM12.25 10.5C11.2835 10.5 10.5 11.2835 10.5 12.25C10.5 12.3881 10.6119 12.5 10.75 12.5H17.25C17.3881 12.5 17.5 12.3881 17.5 12.25C17.5 11.2835 16.7165 10.5 15.75 10.5H12.25Z M14 2C11.5116 2 9.44782 3.81776 9.064 6.19784C6.04581 7.85512 4 11.0636 4 14.75V22.25C4 24.3211 5.67893 26 7.75 26H20.25C22.3211 26 24 24.3211 24 22.25V14.75C24 11.0636 21.9542 7.85512 18.936 6.19784C18.5522 3.81776 16.4884 2 14 2ZM13.75 5C12.7474 5 11.7801 5.15133 10.8698 5.4324C11.4448 4.28648 12.6306 3.5 14 3.5C15.3694 3.5 16.5552 4.28648 17.1302 5.4324C16.2199 5.15133 15.2526 5 14.25 5H13.75ZM13.75 6.5H14.25C18.8063 6.5 22.5 10.1937 22.5 14.75V16H5.5V14.75C5.5 10.1937 9.19365 6.5 13.75 6.5ZM9 17.5V19.25C9 19.6642 9.33579 20 9.75 20C10.1642 20 10.5 19.6642 10.5 19.25V17.5H22.5V22.25C22.5 23.4926 21.4926 24.5 20.25 24.5H7.75C6.50736 24.5 5.5 23.4926 5.5 22.25V17.5H9Z " },
            { FluentSymbol.Backpack32Filled, "M12 16C12 14.8954 12.8954 14 14 14H18C19.1046 14 20 14.8954 20 16H12ZM16 2C13.7909 2 12 3.79086 12 6V6.83209C8.46819 8.3752 6 11.8994 6 16V20H26V16C26 11.8994 23.5318 8.3752 20 6.83209V6C20 3.79086 18.2091 2 16 2ZM16 6C15.3151 6 14.6462 6.06886 14 6.20004V6C14 4.89543 14.8954 4 16 4C17.1046 4 18 4.89543 18 6V6.20004C17.3538 6.06886 16.6849 6 16 6ZM14 12H18C20.2091 12 22 13.7909 22 16C22 17.1046 21.1046 18 20 18H12C10.8954 18 10 17.1046 10 16C10 13.7909 11.7909 12 14 12ZM12 25V22H6V25C6 27.7614 8.23858 30 11 30H21C23.7614 30 26 27.7614 26 25V22H14V25C14 25.5523 13.5523 26 13 26C12.4477 26 12 25.5523 12 25Z " },
            { FluentSymbol.Backpack32, "M14 12C11.7909 12 10 13.7909 10 16C10 17.1046 10.8954 18 12 18H20C21.1046 18 22 17.1046 22 16C22 13.7909 20.2091 12 18 12H14ZM12 16C12 14.8954 12.8954 14 14 14H18C19.1046 14 20 14.8954 20 16H12ZM16 2C13.7909 2 12 3.79086 12 6V6.83209C8.46819 8.3752 6 11.8994 6 16V25C6 27.7614 8.23858 30 11 30H21C23.7614 30 26 27.7614 26 25V16C26 11.8994 23.5318 8.3752 20 6.83209V6C20 3.79086 18.2091 2 16 2ZM24 20H8V16C8 11.5817 11.5817 8 16 8C20.4183 8 24 11.5817 24 16V20ZM12 25C12 25.5523 12.4477 26 13 26C13.5523 26 14 25.5523 14 25V22H24V25C24 26.6569 22.6569 28 21 28H11C9.34315 28 8 26.6569 8 25V22H12V25ZM16 6C15.3151 6 14.6462 6.06886 14 6.20004V6C14 4.89543 14.8954 4 16 4C17.1046 4 18 4.89543 18 6V6.20004C17.3538 6.06886 16.6849 6 16 6Z " },
            { FluentSymbol.Backpack48Filled, "M21.1786 18.5C19.6992 18.5 18.5 19.6992 18.5 21.1786C18.5 21.3561 18.6439 21.5 18.8214 21.5H29.1786C29.3561 21.5 29.5 21.3561 29.5 21.1786C29.5 19.6992 28.3008 18.5 26.8214 18.5H21.1786Z M24 4C19.8817 4 16.4902 7.11186 16.0487 11.1125C11.2394 13.872 8 19.0577 8 25V28H40V25C40 19.0577 36.7606 13.872 31.9513 11.1125C31.5098 7.11186 28.1183 4 24 4ZM24 9C22.2362 9 20.539 9.28541 18.9522 9.81256C19.798 7.86336 21.7398 6.5 24 6.5C26.2602 6.5 28.202 7.86336 29.0478 9.81256C27.461 9.28541 25.7638 9 24 9ZM16 21.1786C16 18.3185 18.3185 16 21.1786 16H26.8214C29.6815 16 32 18.3185 32 21.1786C32 22.7368 30.7368 24 29.1786 24H18.8214C17.2632 24 16 22.7368 16 21.1786Z M16 30.5V33.75C16 34.4404 16.5596 35 17.25 35C17.9404 35 18.5 34.4404 18.5 33.75V30.5H40V38.75C40 41.6495 37.6495 44 34.75 44H13.25C10.3505 44 8 41.6495 8 38.75V30.5H16Z " },
            { FluentSymbol.Backpack48, "M16 21.1786C16 22.7368 17.2632 24 18.8214 24H29.1786C30.7368 24 32 22.7368 32 21.1786C32 18.3185 29.6815 16 26.8214 16H21.1786C18.3185 16 16 18.3185 16 21.1786ZM21.1786 18.5H26.8214C28.3008 18.5 29.5 19.6992 29.5 21.1786C29.5 21.3561 29.3561 21.5 29.1786 21.5H18.8214C18.6439 21.5 18.5 21.3561 18.5 21.1786C18.5 19.6992 19.6992 18.5 21.1786 18.5Z M24 4C19.8817 4 16.4902 7.11186 16.0487 11.1125C11.2394 13.872 8 19.0577 8 25V38.75C8 41.6495 10.3505 44 13.25 44H34.75C37.6495 44 40 41.6495 40 38.75V25C40 19.0577 36.7606 13.872 31.9513 11.1125C31.5098 7.11186 28.1183 4 24 4ZM37.5 28H10.5V25C10.5 17.5442 16.5442 11.5 24 11.5C31.4558 11.5 37.5 17.5442 37.5 25V28ZM16 30.5V33.75C16 34.4404 16.5596 35 17.25 35C17.9404 35 18.5 34.4404 18.5 33.75V30.5H37.5V38.75C37.5 40.2688 36.2688 41.5 34.75 41.5H13.25C11.7312 41.5 10.5 40.2688 10.5 38.75V30.5H16ZM24 9C22.2362 9 20.539 9.28541 18.9522 9.81256C19.798 7.86336 21.7398 6.5 24 6.5C26.2602 6.5 28.202 7.86336 29.0478 9.81256C27.461 9.28541 25.7638 9 24 9Z " },
            { FluentSymbol.Backspace20Filled, "M8.28276 4C7.65369 4 7.04775 4.23716 6.5858 4.66416L2.79937 8.16416C1.72866 9.15388 1.72866 10.8461 2.79937 11.8358L6.5858 15.3358C7.04775 15.7628 7.65369 16 8.28276 16H15.5C16.8807 16 18 14.8807 18 13.5V6.5C18 5.11929 16.8807 4 15.5 4H8.28276ZM9.14645 7.14646C9.34171 6.9512 9.65829 6.9512 9.85355 7.14646L12 9.29291L14.1464 7.14646C14.3417 6.9512 14.6583 6.9512 14.8536 7.14646C15.0488 7.34172 15.0488 7.65831 14.8536 7.85357L12.7071 10L14.8536 12.1465C15.0488 12.3417 15.0488 12.6583 14.8536 12.8536C14.6583 13.0488 14.3417 13.0488 14.1464 12.8536L12 10.7071L9.85355 12.8536C9.65829 13.0488 9.34171 13.0488 9.14645 12.8536C8.95118 12.6583 8.95118 12.3417 9.14645 12.1465L11.2929 10L9.14645 7.85357C8.95118 7.65831 8.95118 7.34172 9.14645 7.14646Z " },
            { FluentSymbol.Backspace20, "M9.14645 7.14646C9.34171 6.9512 9.65829 6.9512 9.85355 7.14646L12 9.29291L14.1464 7.14646C14.3417 6.9512 14.6583 6.9512 14.8536 7.14646C15.0488 7.34172 15.0488 7.65831 14.8536 7.85357L12.7071 10L14.8536 12.1465C15.0488 12.3417 15.0488 12.6583 14.8536 12.8536C14.6583 13.0488 14.3417 13.0488 14.1464 12.8536L12 10.7071L9.85355 12.8536C9.65829 13.0488 9.34171 13.0488 9.14645 12.8536C8.95118 12.6583 8.95118 12.3417 9.14645 12.1465L11.2929 10L9.14645 7.85357C8.95118 7.65831 8.95118 7.34172 9.14645 7.14646Z M6.5858 4.66416C7.04775 4.23716 7.65369 4 8.28276 4H15.5C16.8807 4 18 5.11929 18 6.5V13.5C18 14.8807 16.8807 16 15.5 16H8.28276C7.65369 16 7.04775 15.7628 6.5858 15.3358L2.79937 11.8358C1.72866 10.8461 1.72866 9.15388 2.79937 8.16416L6.5858 4.66416ZM8.28276 5C7.90532 5 7.54175 5.14229 7.26458 5.3985L3.47816 8.8985C2.83573 9.49233 2.83573 10.5077 3.47816 11.1015L7.26458 14.6015C7.54175 14.8577 7.90532 15 8.28276 15H15.5C16.3284 15 17 14.3284 17 13.5V6.5C17 5.67157 16.3284 5 15.5 5H8.28276Z " },
            { FluentSymbol.Backspace24Filled, "M18.75 4C20.483 4 21.8992 5.35645 21.9949 7.06558L22 7.25V16.75C22 18.483 20.6435 19.8992 18.9344 19.9949L18.75 20H10.2488C9.48467 20 8.74732 19.7308 8.16441 19.2436L8.00936 19.1053L3.01367 14.3553C1.71288 13.1185 1.66102 11.0613 2.89784 9.76055L3.01367 9.64472L8.00936 4.89472C8.56313 4.36818 9.28296 4.05515 10.0412 4.00663L10.2488 4H18.75ZM11.4462 8.39705C11.1526 8.1792 10.7359 8.2034 10.4697 8.46967C10.2034 8.73594 10.1792 9.1526 10.397 9.44621L10.4697 9.53033L12.9391 12L10.4697 14.4697L10.397 14.5538C10.1792 14.8474 10.2034 15.2641 10.4697 15.5303C10.7359 15.7966 11.1526 15.8208 11.4462 15.6029L11.5303 15.5303L14.0001 13.061L16.4697 15.5303L16.5538 15.6029C16.8474 15.8208 17.2641 15.7966 17.5303 15.5303C17.7966 15.2641 17.8208 14.8474 17.6029 14.5538L17.5303 14.4697L15.0611 12L17.5303 9.53033L17.6029 9.44621C17.8208 9.1526 17.7966 8.73594 17.5303 8.46967C17.2641 8.2034 16.8474 8.1792 16.5538 8.39705L16.4697 8.46967L14.0001 10.939L11.5303 8.46967L11.4462 8.39705Z " },
            { FluentSymbol.Backspace24, "M18.75 4C20.483 4 21.8992 5.35645 21.9949 7.06558L22 7.25V16.75C22 18.483 20.6435 19.8992 18.9344 19.9949L18.75 20H10.2488C9.48467 20 8.74732 19.7308 8.16441 19.2436L8.00936 19.1053L3.01367 14.3553C1.71288 13.1185 1.66102 11.0613 2.89784 9.76055L3.01367 9.64472L8.00936 4.89472C8.56313 4.36818 9.28296 4.05515 10.0412 4.00663L10.2488 4H18.75ZM18.75 5.5H10.2488C9.85605 5.5 9.47644 5.63205 9.16975 5.87227L9.04295 5.98177L4.04726 10.7318L3.98489 10.7941C3.35809 11.4534 3.34595 12.4733 3.93064 13.1463L4.04726 13.2682L9.04295 18.0182C9.32758 18.2889 9.69368 18.4547 10.0815 18.492L10.2488 18.5H18.75C19.6682 18.5 20.4212 17.7929 20.4942 16.8935L20.5 16.75V7.25C20.5 6.33183 19.7929 5.57881 18.8935 5.5058L18.75 5.5ZM11.4462 8.39705L11.5303 8.46967L14.0001 10.939L16.4697 8.46967C16.7626 8.17678 17.2374 8.17678 17.5303 8.46967C17.7966 8.73594 17.8208 9.1526 17.6029 9.44621L17.5303 9.53033L15.0611 12L17.5303 14.4697C17.8232 14.7626 17.8232 15.2374 17.5303 15.5303C17.2641 15.7966 16.8474 15.8208 16.5538 15.6029L16.4697 15.5303L14.0001 13.061L11.5303 15.5303C11.2374 15.8232 10.7626 15.8232 10.4697 15.5303C10.2034 15.2641 10.1792 14.8474 10.397 14.5538L10.4697 14.4697L12.9391 12L10.4697 9.53033C10.1768 9.23744 10.1768 8.76256 10.4697 8.46967C10.7359 8.2034 11.1526 8.1792 11.4462 8.39705Z " },
            { FluentSymbol.Badge24Filled, "M16 4.50195C16 6.43495 17.567 8.00195 19.5 8.00195C20.0372 8.00195 20.5461 7.88092 21.001 7.66464L21 18.2503C21 19.7691 19.7688 21.0003 18.25 21.0003H5.75C4.23122 21.0003 3 19.7691 3 18.2503V5.75027C3 4.23149 4.23122 3.00027 5.75 3.00027L16.3378 2.99991C16.1212 3.45506 16 3.96435 16 4.50195ZM19.5 2.00195C20.8807 2.00195 22 3.12124 22 4.50195C22 5.88266 20.8807 7.00195 19.5 7.00195C18.1193 7.00195 17 5.88266 17 4.50195C17 3.12124 18.1193 2.00195 19.5 2.00195Z " },
            { FluentSymbol.Badge24, "M16.338 2.99956C16.1215 3.45423 16.0003 3.96294 16 4.49994L5.75 4.50027C5.05964 4.50027 4.5 5.05991 4.5 5.75027V18.2503C4.5 18.9406 5.05964 19.5003 5.75 19.5003H18.25C18.9404 19.5003 19.5 18.9406 19.5 18.2503V8.00195C20.0372 8.00195 20.5461 7.88092 21.001 7.66464L21 18.2503C21 19.7691 19.7688 21.0003 18.25 21.0003H5.75C4.23122 21.0003 3 19.7691 3 18.2503V5.75027C3 4.23149 4.23122 3.00027 5.75 3.00027L16.338 2.99956ZM19.5 2.00195C20.8807 2.00195 22 3.12124 22 4.50195C22 5.88266 20.8807 7.00195 19.5 7.00195C18.1193 7.00195 17 5.88266 17 4.50195C17 3.12124 18.1193 2.00195 19.5 2.00195Z " },
            { FluentSymbol.Balloon16Filled, "M8 1C5.18379 1 3.5 3.2657 3.5 5.5C3.5 6.87027 4.04797 8.22784 4.85927 9.24395C5.55125 10.1106 6.48408 10.786 7.5 10.9576V11C7.5 12.1046 8.39543 13 9.5 13H11C11.5523 13 12 13.4477 12 14V14.5C12 14.7761 12.2239 15 12.5 15C12.7761 15 13 14.7761 13 14.5V14C13 12.8954 12.1046 12 11 12H9.5C8.94772 12 8.5 11.5523 8.5 11V10.9576C9.51592 10.786 10.4488 10.1106 11.1407 9.24395C11.952 8.22784 12.5 6.87027 12.5 5.5C12.5 3.2657 10.8162 1 8 1ZM8 3C8.66262 3 9.28338 3.32627 9.72855 3.77145C10.1737 4.21662 10.5 4.83738 10.5 5.5C10.5 5.77614 10.2761 6 10 6C9.72386 6 9.5 5.77614 9.5 5.5C9.5 5.16262 9.32627 4.78338 9.02145 4.47855C8.71662 4.17373 8.33738 4 8 4C7.72386 4 7.5 3.77614 7.5 3.5C7.5 3.22386 7.72386 3 8 3Z " },
            { FluentSymbol.Balloon16, "M7.5 3.5C7.5 3.22386 7.72386 3 8 3C8.66262 3 9.28338 3.32627 9.72855 3.77145C10.1737 4.21662 10.5 4.83738 10.5 5.5C10.5 5.77614 10.2761 6 10 6C9.72386 6 9.5 5.77614 9.5 5.5C9.5 5.16262 9.32627 4.78338 9.02145 4.47855C8.71662 4.17373 8.33738 4 8 4C7.72386 4 7.5 3.77614 7.5 3.5Z M8.5 10.9576C9.51592 10.786 10.4488 10.1106 11.1407 9.24395C11.952 8.22784 12.5 6.87027 12.5 5.5C12.5 3.2657 10.8162 1 8 1C5.18379 1 3.5 3.2657 3.5 5.5C3.5 6.87027 4.04797 8.22784 4.85927 9.24395C5.55125 10.1106 6.48408 10.786 7.5 10.9576V11C7.5 12.1046 8.39543 13 9.5 13H11C11.5523 13 12 13.4477 12 14V14.5C12 14.7761 12.2239 15 12.5 15C12.7761 15 13 14.7761 13 14.5V14C13 12.8954 12.1046 12 11 12H9.5C8.94772 12 8.5 11.5523 8.5 11V10.9576ZM8 2C10.1838 2 11.5 3.7343 11.5 5.5C11.5 6.61501 11.048 7.75744 10.3593 8.62001C9.66343 9.4915 8.79288 10 8 10C7.20712 10 6.33656 9.4915 5.64073 8.62001C4.95203 7.75744 4.5 6.61501 4.5 5.5C4.5 3.7343 5.81621 2 8 2Z " },
            { FluentSymbol.Balloon20Filled, "M5 7C5 4.23858 7.23858 2 10 2C12.7614 2 15 4.23858 15 7C15 8.86559 14.3352 10.593 13.4025 11.8589C12.6108 12.9334 11.565 13.7507 10.5 13.9521V14C10.5 14.5523 10.9477 15 11.5 15H14C15.1046 15 16 15.8954 16 17V17.5C16 17.7761 15.7761 18 15.5 18C15.2239 18 15 17.7761 15 17.5V17C15 16.4477 14.5523 16 14 16H11.5C10.3954 16 9.5 15.1046 9.5 14V13.9522C8.43528 13.7511 7.38944 12.9351 6.59754 11.861C5.66474 10.5956 5 8.86814 5 7ZM10.5678 4.00498C10.2944 3.9661 10.0412 4.15621 10.0024 4.4296C9.96348 4.70299 10.1536 4.95614 10.427 4.99502C11.2407 5.11075 11.8857 5.7551 12.0024 6.5685C12.0417 6.84184 12.2951 7.03162 12.5684 6.9924C12.8417 6.95317 13.0315 6.69978 12.9923 6.42644C12.8124 5.17316 11.8216 4.1833 10.5678 4.00498Z " },
            { FluentSymbol.Balloon20, "M10.0024 4.4296C10.0412 4.15621 10.2944 3.9661 10.5678 4.00498C11.8216 4.1833 12.8124 5.17316 12.9923 6.42644C13.0315 6.69978 12.8417 6.95317 12.5684 6.9924C12.2951 7.03162 12.0417 6.84184 12.0024 6.5685C11.8857 5.7551 11.2407 5.11075 10.427 4.99502C10.1536 4.95614 9.96348 4.70299 10.0024 4.4296Z M5 7C5 4.23858 7.23858 2 10 2C12.7614 2 15 4.23858 15 7C15 8.86559 14.3352 10.593 13.4025 11.8589C12.6108 12.9334 11.565 13.7507 10.5 13.9521V14C10.5 14.5523 10.9477 15 11.5 15H14C15.1046 15 16 15.8954 16 17V17.5C16 17.7761 15.7761 18 15.5 18C15.2239 18 15 17.7761 15 17.5V17C15 16.4477 14.5523 16 14 16H11.5C10.3954 16 9.5 15.1046 9.5 14V13.9522C8.43528 13.7511 7.38944 12.9351 6.59754 11.861C5.66474 10.5956 5 8.86814 5 7ZM10 3C7.79086 3 6 4.79086 6 7C6 8.63657 6.58526 10.1591 7.40246 11.2676C8.23672 12.3992 9.23141 13 10 13C10.7683 13 11.763 12.3983 12.5975 11.2657C13.4148 10.1564 14 8.6338 14 7C14 4.79086 12.2091 3 10 3Z " },
            { FluentSymbol.Balloon24Filled, "M5 9C5 5.13401 8.13401 2 12 2C15.866 2 19 5.13401 19 9C19 11.025 18.3305 13.2357 17.1504 14.9556C16.1075 16.4755 14.6069 17.687 12.75 17.9479V18.25C12.75 18.6642 13.0858 19 13.5 19H16.75C17.9926 19 19 20.0074 19 21.25V22.25C19 22.6642 18.6642 23 18.25 23C17.8358 23 17.5 22.6642 17.5 22.25V21.25C17.5 20.8358 17.1642 20.5 16.75 20.5H13.5C12.2574 20.5 11.25 19.4926 11.25 18.25V17.9479C9.39312 17.687 7.89247 16.4755 6.84958 14.9556C5.66952 13.2357 5 11.025 5 9ZM12.9196 5.10638C12.5165 5.01144 12.1126 5.26132 12.0177 5.6645C11.9228 6.06769 12.1726 6.4715 12.5758 6.56644C13.4916 6.78209 14.2146 7.50369 14.4322 8.41872C14.528 8.82169 14.9324 9.07068 15.3353 8.97484C15.7383 8.87901 15.9873 8.47464 15.8915 8.07167C15.5426 6.60459 14.388 5.45214 12.9196 5.10638Z " },
            { FluentSymbol.Balloon24, "M12.0177 5.6645C12.1126 5.26132 12.5165 5.01144 12.9196 5.10638C14.388 5.45214 15.5426 6.60459 15.8915 8.07167C15.9873 8.47464 15.7383 8.87901 15.3353 8.97484C14.9324 9.07068 14.528 8.82169 14.4322 8.41872C14.2146 7.50369 13.4916 6.78209 12.5758 6.56644C12.1726 6.4715 11.9228 6.06769 12.0177 5.6645Z M5 9C5 5.13401 8.13401 2 12 2C15.866 2 19 5.13401 19 9C19 11.025 18.3305 13.2357 17.1504 14.9556C16.1075 16.4755 14.6069 17.687 12.75 17.9479V18.25C12.75 18.6642 13.0858 19 13.5 19H16.75C17.9926 19 19 20.0074 19 21.25V22.25C19 22.6642 18.6642 23 18.25 23C17.8358 23 17.5 22.6642 17.5 22.25V21.25C17.5 20.8358 17.1642 20.5 16.75 20.5H13.5C12.2574 20.5 11.25 19.4926 11.25 18.25V17.9479C9.39312 17.687 7.89247 16.4755 6.84958 14.9556C5.66952 13.2357 5 11.025 5 9ZM12 3.5C8.96243 3.5 6.5 5.96243 6.5 9C6.5 10.7251 7.0795 12.6393 8.08644 14.1069C9.09356 15.5748 10.4527 16.5 12 16.5C13.5473 16.5 14.9064 15.5748 15.9136 14.1069C16.9205 12.6393 17.5 10.7251 17.5 9C17.5 5.96243 15.0376 3.5 12 3.5Z " },
            { FluentSymbol.Battery020Filled, "M2 7.55371C2 6.173 3.11929 5.05371 4.5 5.05371H13.5C14.8807 5.05371 16 6.173 16 7.55371V8.38704L17.1667 8.38931C17.3184 8.38931 17.4608 8.4299 17.5833 8.50081C17.8324 8.6449 18 8.91423 18 9.22265V10.8893C18 11.1977 17.8324 11.4671 17.5833 11.6111C17.4608 11.6821 17.3184 11.7226 17.1667 11.7226L16 11.7204V12.5537C16 13.9345 14.8807 15.0537 13.5 15.0537H4.5C3.11929 15.0537 2 13.9345 2 12.5537V7.55371Z " },
            { FluentSymbol.Battery020, "M13.5 5.05371C14.8807 5.05371 16 6.173 16 7.55371V8.38704L17.1667 8.38931C17.3184 8.38931 17.4608 8.4299 17.5833 8.50081C17.8324 8.6449 18 8.91423 18 9.22265V10.8893C18 11.1977 17.8324 11.4671 17.5833 11.6111C17.4608 11.6821 17.3184 11.7226 17.1667 11.7226L16 11.7204V12.5537C16 13.9345 14.8807 15.0537 13.5 15.0537H4.5C3.11929 15.0537 2 13.9345 2 12.5537V7.55371C2 6.173 3.11929 5.05371 4.5 5.05371H13.5ZM13.75 5.99975H4.5C3.85025 5.99975 3.09484 6.49549 3.00822 7.12937L3 7.24975V12.7451C3 13.3922 3.49187 13.9246 4.12219 13.9886L4.25 13.9951H13.75C14.3972 13.9951 14.9295 13.5032 14.9935 12.8729L15 12.7451V7.24975C15 6.60254 14.5081 6.07022 13.8778 6.00621L13.75 5.99975Z " },
            { FluentSymbol.Battery024Filled, "M1.99969 9C1.99969 7.34315 3.34284 6 4.99969 6H17C18.6569 6 20 7.34315 20 9V10H21.0003C21.1824 10 21.3532 10.0487 21.5003 10.1338C21.7992 10.3067 22.0003 10.6299 22.0003 11V13C22.0003 13.3701 21.7992 13.6933 21.5003 13.8662C21.3532 13.9513 21.1824 14 21.0003 14H20V15C20 16.6569 18.6569 18 17 18H4.99969C3.34284 18 1.99969 16.6569 1.99969 15V9Z " },
            { FluentSymbol.Battery024, "M17 6C18.6569 6 20 7.34315 20 9V10H21.0003C21.1824 10 21.3532 10.0487 21.5003 10.1338C21.7992 10.3067 22.0003 10.6299 22.0003 11V13C22.0003 13.3701 21.7992 13.6933 21.5003 13.8662C21.3532 13.9513 21.1824 14 21.0003 14H20V15C20 16.6569 18.6569 18 17 18H4.99969C3.34284 18 1.99969 16.6569 1.99969 15V9C1.99969 7.34315 3.34284 6 4.99969 6H17ZM16.9982 7.5H4.99969C4.22 7.5 3.57925 8.09489 3.50656 8.85554L3.49969 9V15C3.49969 15.7797 4.09458 16.4204 4.85523 16.4931L4.99969 16.5H16.9982C17.7778 16.5 18.4186 15.9051 18.4913 15.1445L18.4982 15V9C18.4982 8.2203 17.9033 7.57955 17.1426 7.50687L16.9982 7.5Z " },
            { FluentSymbol.Battery120Filled, "M13.5 5.05371C14.8807 5.05371 16 6.173 16 7.55371V8.38704L17.1667 8.38931C17.3184 8.38931 17.4608 8.4299 17.5833 8.50081C17.8324 8.6449 18 8.91423 18 9.22265V10.8893C18 11.1977 17.8324 11.4671 17.5833 11.6111C17.4608 11.6821 17.3184 11.7226 17.1667 11.7226L16 11.7204V12.5537C16 13.9345 14.8807 15.0537 13.5 15.0537H4.5C3.11929 15.0537 2 13.9345 2 12.5537V7.55371C2 6.173 3.11929 5.05371 4.5 5.05371H13.5ZM4.5 6.99975C4.22386 6.99975 4 7.22361 4 7.49975V12.4998C4 12.7759 4.22386 12.9998 4.5 12.9998C4.77614 12.9998 5 12.7759 5 12.4998V7.49975C5 7.22361 4.77614 6.99975 4.5 6.99975Z " },
            { FluentSymbol.Battery120, "M13.5 5.05371C14.8807 5.05371 16 6.173 16 7.55371V8.38704L17.1667 8.38931C17.3184 8.38931 17.4608 8.4299 17.5833 8.50081C17.8324 8.6449 18 8.91423 18 9.22265V10.8893C18 11.1977 17.8324 11.4671 17.5833 11.6111C17.4608 11.6821 17.3184 11.7226 17.1667 11.7226L16 11.7204V12.5537C16 13.9345 14.8807 15.0537 13.5 15.0537H4.5C3.11929 15.0537 2 13.9345 2 12.5537V7.55371C2 6.173 3.11929 5.05371 4.5 5.05371H13.5ZM13.75 5.99975H4.5C3.85025 5.99975 3.09484 6.49549 3.00822 7.12937L3 7.24975V12.7451C3 13.3922 3.49187 13.9246 4.12219 13.9886L4.25 13.9951H13.75C14.3972 13.9951 14.9295 13.5032 14.9935 12.8729L15 12.7451V7.24975C15 6.60254 14.5081 6.07022 13.8778 6.00621L13.75 5.99975ZM4.5 6.99975C4.77614 6.99975 5 7.22361 5 7.49975V12.4998C5 12.7759 4.77614 12.9998 4.5 12.9998C4.22386 12.9998 4 12.7759 4 12.4998V7.49975C4 7.22361 4.22386 6.99975 4.5 6.99975Z " },
            { FluentSymbol.Battery124Filled, "M17 6C18.6569 6 20 7.34315 20 9V10H21.0003C21.1824 10 21.3532 10.0487 21.5003 10.1338C21.7992 10.3067 22.0003 10.6299 22.0003 11V13C22.0003 13.3701 21.7992 13.6933 21.5003 13.8662C21.3532 13.9513 21.1824 14 21.0003 14H20V15C20 16.6569 18.6569 18 17 18H4.99969C3.34284 18 1.99969 16.6569 1.99969 15V9C1.99969 7.34315 3.34284 6 4.99969 6H17ZM7.00002 9H5.9981C5.44582 9 4.9981 9.44772 4.9981 10V14C4.9981 14.5523 5.44581 15 5.9981 15H7.00002C7.5523 15 8.00002 14.5523 8.00002 14V10C8.00002 9.44772 7.55231 9 7.00002 9Z " },
            { FluentSymbol.Battery124, "M17 6C18.6569 6 20 7.34315 20 9V10H21.0003C21.1824 10 21.3532 10.0487 21.5003 10.1338C21.7992 10.3067 22.0003 10.6299 22.0003 11V13C22.0003 13.3701 21.7992 13.6933 21.5003 13.8662C21.3532 13.9513 21.1824 14 21.0003 14H20V15C20 16.6569 18.6569 18 17 18H4.99969C3.34284 18 1.99969 16.6569 1.99969 15V9C1.99969 7.34315 3.34284 6 4.99969 6H17ZM16.9982 7.5H4.99969C4.22 7.5 3.57925 8.09489 3.50656 8.85554L3.49969 9V15C3.49969 15.7797 4.09458 16.4204 4.85523 16.4931L4.99969 16.5H16.9982C17.7778 16.5 18.4186 15.9051 18.4913 15.1445L18.4982 15V9C18.4982 8.2203 17.9033 7.57955 17.1426 7.50687L16.9982 7.5ZM6.003 8.99875H7.00002C7.51286 8.99875 7.93553 9.3848 7.99329 9.88213L8.00002 9.99875V13.9988C8.00002 14.5116 7.61397 14.9343 7.11664 14.992L7.00002 14.9988H6.003C5.49016 14.9988 5.06749 14.6127 5.00973 14.1154L5.003 13.9988V9.99875C5.003 9.48592 5.38904 9.06324 5.88638 9.00548L6.003 8.99875H7.00002H6.003Z " },
            { FluentSymbol.Battery220Filled, "M4.83436 7.00239C4.373 7.00239 3.99898 7.3764 3.99898 7.83776V12.1644C3.99898 12.6258 4.37299 12.9998 4.83436 12.9998H5.16462C5.62599 12.9998 6 12.6258 6 12.1644V7.83776C6 7.3764 5.62599 7.00239 5.16462 7.00239H4.83436ZM2 7.55371C2 6.173 3.11929 5.05371 4.5 5.05371H13.5C14.8807 5.05371 16 6.173 16 7.55371V8.38704L17.1667 8.38931C17.3184 8.38931 17.4608 8.4299 17.5833 8.50081C17.8324 8.6449 18 8.91423 18 9.22265V10.8893C18 11.1977 17.8324 11.4671 17.5833 11.6111C17.4608 11.6821 17.3184 11.7226 17.1667 11.7226L16 11.7204V12.5537C16 13.9345 14.8807 15.0537 13.5 15.0537H4.5C3.11929 15.0537 2 13.9345 2 12.5537V7.55371Z " },
            { FluentSymbol.Battery220, "M13.5 5.05371C14.8807 5.05371 16 6.173 16 7.55371V8.38704L17.1667 8.38931C17.3184 8.38931 17.4608 8.4299 17.5833 8.50081C17.8324 8.6449 18 8.91423 18 9.22265V10.8893C18 11.1977 17.8324 11.4671 17.5833 11.6111C17.4608 11.6821 17.3184 11.7226 17.1667 11.7226L16 11.7204V12.5537C16 13.9345 14.8807 15.0537 13.5 15.0537H4.5C3.11929 15.0537 2 13.9345 2 12.5537V7.55371C2 6.173 3.11929 5.05371 4.5 5.05371H13.5ZM13.75 5.99975H4.5C3.85025 5.99975 3.09484 6.49549 3.00822 7.12937L3 7.24975V12.7451C3 13.3922 3.49187 13.9246 4.12219 13.9886L4.25 13.9951H13.75C14.3972 13.9951 14.9295 13.5032 14.9935 12.8729L15 12.7451V7.24975C15 6.60254 14.5081 6.07022 13.8778 6.00621L13.75 5.99975ZM4.83436 7.00239H5.16462C5.5905 7.00239 5.94194 7.32107 5.99349 7.73298L6 7.83776V12.1644C6 12.5903 5.68131 12.9417 5.26941 12.9932L5.16462 12.9998H4.83436C4.40848 12.9998 4.05704 12.6811 4.00549 12.2692L3.99898 12.1644V7.83776C3.99898 7.41189 4.31767 7.06044 4.72957 7.00889L4.83436 7.00239H5.16462H4.83436Z " },
            { FluentSymbol.Battery224Filled, "M17 6C18.6569 6 20 7.34315 20 9V10H21.0003C21.1824 10 21.3532 10.0487 21.5003 10.1338C21.7992 10.3067 22.0003 10.6299 22.0003 11V13C22.0003 13.3701 21.7992 13.6933 21.5003 13.8662C21.3532 13.9513 21.1824 14 21.0003 14H20V15C20 16.6569 18.6569 18 17 18H4.99969C3.34284 18 1.99969 16.6569 1.99969 15V9C1.99969 7.34315 3.34284 6 4.99969 6H17ZM8.00002 9H5.99798C5.4457 9 4.99798 9.44772 4.99798 10V14C4.99798 14.5523 5.44569 15 5.99798 15H8.00002C8.5523 15 9.00002 14.5523 9.00002 14V10C9.00002 9.44772 8.55231 9 8.00002 9Z " },
            { FluentSymbol.Battery224, "M17 6C18.6569 6 20 7.34315 20 9V10H21.0003C21.1824 10 21.3532 10.0487 21.5003 10.1338C21.7992 10.3067 22.0003 10.6299 22.0003 11V13C22.0003 13.3701 21.7992 13.6933 21.5003 13.8662C21.3532 13.9513 21.1824 14 21.0003 14H20V15C20 16.6569 18.6569 18 17 18H4.99969C3.34284 18 1.99969 16.6569 1.99969 15V9C1.99969 7.34315 3.34284 6 4.99969 6H17ZM16.9982 7.5H4.99969C4.22 7.5 3.57925 8.09489 3.50656 8.85554L3.49969 9V15C3.49969 15.7797 4.09458 16.4204 4.85523 16.4931L4.99969 16.5H16.9982C17.7778 16.5 18.4186 15.9051 18.4913 15.1445L18.4982 15V9C18.4982 8.2203 17.9033 7.57955 17.1426 7.50687L16.9982 7.5ZM6.00002 9.00315L8.00002 9C8.51286 9 8.93553 9.38604 8.99329 9.88338L9.00002 10V14C9.00002 14.5128 8.61397 14.9355 8.11664 14.9933L8.00002 15L6.00002 15.0031C5.48718 15.0031 5.06451 14.6171 5.00675 14.1198L5.00002 14.0031V10.0031C5.00002 9.49032 5.38606 9.06764 5.8834 9.00988L6.00002 9.00315L8.00002 9L6.00002 9.00315Z " },
            { FluentSymbol.Battery320Filled, "M4.83436 7.00239C4.373 7.00239 3.99898 7.3764 3.99898 7.83776V12.1644C3.99898 12.6258 4.37299 12.9998 4.83436 12.9998H6.16462C6.62599 12.9998 7 12.6258 7 12.1644V7.83776C7 7.3764 6.62599 7.00239 6.16462 7.00239H4.83436ZM2 7.55371C2 6.173 3.11929 5.05371 4.5 5.05371H13.5C14.8807 5.05371 16 6.173 16 7.55371V8.38704L17.1667 8.38931C17.3184 8.38931 17.4608 8.4299 17.5833 8.50081C17.8324 8.6449 18 8.91423 18 9.22265V10.8893C18 11.1977 17.8324 11.4671 17.5833 11.6111C17.4608 11.6821 17.3184 11.7226 17.1667 11.7226L16 11.7204V12.5537C16 13.9345 14.8807 15.0537 13.5 15.0537H4.5C3.11929 15.0537 2 13.9345 2 12.5537V7.55371Z " },
            { FluentSymbol.Battery320, "M13.5 5.05371C14.8807 5.05371 16 6.173 16 7.55371V8.38704L17.1667 8.38931C17.3184 8.38931 17.4608 8.4299 17.5833 8.50081C17.8324 8.6449 18 8.91423 18 9.22265V10.8893C18 11.1977 17.8324 11.4671 17.5833 11.6111C17.4608 11.6821 17.3184 11.7226 17.1667 11.7226L16 11.7204V12.5537C16 13.9345 14.8807 15.0537 13.5 15.0537H4.5C3.11929 15.0537 2 13.9345 2 12.5537V7.55371C2 6.173 3.11929 5.05371 4.5 5.05371H13.5ZM13.75 5.99975H4.5C3.85025 5.99975 3.09484 6.49549 3.00822 7.12937L3 7.24975V12.7451C3 13.3922 3.49187 13.9246 4.12219 13.9886L4.25 13.9951H13.75C14.3972 13.9951 14.9295 13.5032 14.9935 12.8729L15 12.7451V7.24975C15 6.60254 14.5081 6.07022 13.8778 6.00621L13.75 5.99975ZM4.83436 7.00239H6.16462C6.5905 7.00239 6.94194 7.32107 6.99349 7.73298L7 7.83776V12.1644C7 12.5903 6.68131 12.9417 6.26941 12.9932L6.16462 12.9998H4.83436C4.40848 12.9998 4.05704 12.6811 4.00549 12.2692L3.99898 12.1644V7.83776C3.99898 7.41189 4.31767 7.06044 4.72957 7.00889L4.83436 7.00239H6.16462H4.83436Z " },
            { FluentSymbol.Battery324Filled, "M17 6C18.6569 6 20 7.34315 20 9V10H21.0003C21.1824 10 21.3532 10.0487 21.5003 10.1338C21.7992 10.3067 22.0003 10.6299 22.0003 11V13C22.0003 13.3701 21.7992 13.6933 21.5003 13.8662C21.3532 13.9513 21.1824 14 21.0003 14H20V15C20 16.6569 18.6569 18 17 18H4.99969C3.34284 18 1.99969 16.6569 1.99969 15V9C1.99969 7.34315 3.34284 6 4.99969 6H17ZM9.00002 9H6.01667C5.4644 9 5.01667 9.44772 5.01667 10V14C5.01667 14.5523 5.4644 15 6.01667 15H9.00002C9.55231 15 10 14.5523 10 14V10C10 9.44772 9.5523 9 9.00002 9Z " },
            { FluentSymbol.Battery324, "M17 6C18.6569 6 20 7.34315 20 9V10H21.0003C21.1824 10 21.3532 10.0487 21.5003 10.1338C21.7992 10.3067 22.0003 10.6299 22.0003 11V13C22.0003 13.3701 21.7992 13.6933 21.5003 13.8662C21.3532 13.9513 21.1824 14 21.0003 14H20V15C20 16.6569 18.6569 18 17 18H4.99969C3.34284 18 1.99969 16.6569 1.99969 15V9C1.99969 7.34315 3.34284 6 4.99969 6H17ZM16.9982 7.5H4.99969C4.22 7.5 3.57925 8.09489 3.50656 8.85554L3.49969 9V15C3.49969 15.7797 4.09458 16.4204 4.85523 16.4931L4.99969 16.5H16.9982C17.7778 16.5 18.4186 15.9051 18.4913 15.1445L18.4982 15V9C18.4982 8.2203 17.9033 7.57955 17.1426 7.50687L16.9982 7.5ZM6.01667 9H9.00002C9.51285 9 9.93552 9.38604 9.99329 9.88338L10 10V14C10 14.5128 9.61398 14.9355 9.11664 14.9933L9.00002 15H6.01667C5.50384 15 5.08117 14.614 5.0234 14.1166L5.01667 14V10C5.01667 9.48717 5.40272 9.06449 5.90005 9.00673L6.01667 9H9.00002H6.01667Z " },
            { FluentSymbol.Battery420Filled, "M4.83436 7.00239C4.373 7.00239 3.99898 7.3764 3.99898 7.83776V12.1644C3.99898 12.6258 4.37299 12.9998 4.83436 12.9998H7.16462C7.62599 12.9998 8 12.6258 8 12.1644V7.83776C8 7.3764 7.62599 7.00239 7.16462 7.00239H4.83436ZM2 7.55371C2 6.173 3.11929 5.05371 4.5 5.05371H13.5C14.8807 5.05371 16 6.173 16 7.55371V8.38704L17.1667 8.38931C17.3184 8.38931 17.4608 8.4299 17.5833 8.50081C17.8324 8.6449 18 8.91423 18 9.22265V10.8893C18 11.1977 17.8324 11.4671 17.5833 11.6111C17.4608 11.6821 17.3184 11.7226 17.1667 11.7226L16 11.7204V12.5537C16 13.9345 14.8807 15.0537 13.5 15.0537H4.5C3.11929 15.0537 2 13.9345 2 12.5537V7.55371Z " },
            { FluentSymbol.Battery420, "M13.5 5.05371C14.8807 5.05371 16 6.173 16 7.55371V8.38704L17.1667 8.38931C17.3184 8.38931 17.4608 8.4299 17.5833 8.50081C17.8324 8.6449 18 8.91423 18 9.22265V10.8893C18 11.1977 17.8324 11.4671 17.5833 11.6111C17.4608 11.6821 17.3184 11.7226 17.1667 11.7226L16 11.7204V12.5537C16 13.9345 14.8807 15.0537 13.5 15.0537H4.5C3.11929 15.0537 2 13.9345 2 12.5537V7.55371C2 6.173 3.11929 5.05371 4.5 5.05371H13.5ZM13.75 5.99975H4.5C3.85025 5.99975 3.09484 6.49549 3.00822 7.12937L3 7.24975V12.7451C3 13.3922 3.49187 13.9246 4.12219 13.9886L4.25 13.9951H13.75C14.3972 13.9951 14.9295 13.5032 14.9935 12.8729L15 12.7451V7.24975C15 6.60254 14.5081 6.07022 13.8778 6.00621L13.75 5.99975ZM4.83436 7.00239H7.16462C7.5905 7.00239 7.94194 7.32107 7.99349 7.73298L8 7.83776V12.1644C8 12.5903 7.68131 12.9417 7.26941 12.9932L7.16462 12.9998H4.83436C4.40848 12.9998 4.05704 12.6811 4.00549 12.2692L3.99898 12.1644V7.83776C3.99898 7.41189 4.31767 7.06044 4.72957 7.00889L4.83436 7.00239H7.16462H4.83436Z " },
            { FluentSymbol.Battery424Filled, "M17 6C18.6569 6 20 7.34315 20 9V10H21.0003C21.1824 10 21.3532 10.0487 21.5003 10.1338C21.7992 10.3067 22.0003 10.6299 22.0003 11V13C22.0003 13.3701 21.7992 13.6933 21.5003 13.8662C21.3532 13.9513 21.1824 14 21.0003 14H20V15C20 16.6569 18.6569 18 17 18H4.99969C3.34284 18 1.99969 16.6569 1.99969 15V9C1.99969 7.34315 3.34284 6 4.99969 6H17ZM10 9H5.99969C5.44741 9 4.99969 9.44772 4.99969 10V14C4.99969 14.5523 5.4474 15 5.99969 15H10C10.5523 15 11 14.5523 11 14V10C11 9.44772 10.5523 9 10 9Z " },
            { FluentSymbol.Battery424, "M17 6C18.6569 6 20 7.34315 20 9V10H21.0003C21.1824 10 21.3532 10.0487 21.5003 10.1338C21.7992 10.3067 22.0003 10.6299 22.0003 11V13C22.0003 13.3701 21.7992 13.6933 21.5003 13.8662C21.3532 13.9513 21.1824 14 21.0003 14H20V15C20 16.6569 18.6569 18 17 18H4.99969C3.34284 18 1.99969 16.6569 1.99969 15V9C1.99969 7.34315 3.34284 6 4.99969 6H17ZM16.9982 7.5H4.99969C4.22 7.5 3.57925 8.09489 3.50656 8.85554L3.49969 9V15C3.49969 15.7797 4.09458 16.4204 4.85523 16.4931L4.99969 16.5H16.9982C17.7778 16.5 18.4186 15.9051 18.4913 15.1445L18.4982 15V9C18.4982 8.2203 17.9033 7.57955 17.1426 7.50687L16.9982 7.5ZM5.99969 9H10C10.5129 9 10.9355 9.38604 10.9933 9.88338L11 10V14C11 14.5128 10.614 14.9355 10.1166 14.9933L10 15H5.99969C5.48685 15 5.06419 14.614 5.00642 14.1166L4.99969 14V10C4.99969 9.48717 5.38574 9.06449 5.88307 9.00673L5.99969 9H10H5.99969Z " },
            { FluentSymbol.Battery520Filled, "M4.83436 7.00239C4.373 7.00239 3.99898 7.3764 3.99898 7.83776V12.1644C3.99898 12.6258 4.37299 12.9998 4.83436 12.9998H8.16462C8.62599 12.9998 9 12.6258 9 12.1644V7.83776C9 7.3764 8.62599 7.00239 8.16462 7.00239H4.83436ZM2 7.55371C2 6.173 3.11929 5.05371 4.5 5.05371H13.5C14.8807 5.05371 16 6.173 16 7.55371V8.38704L17.1667 8.38931C17.3184 8.38931 17.4608 8.4299 17.5833 8.50081C17.8324 8.6449 18 8.91423 18 9.22265V10.8893C18 11.1977 17.8324 11.4671 17.5833 11.6111C17.4608 11.6821 17.3184 11.7226 17.1667 11.7226L16 11.7204V12.5537C16 13.9345 14.8807 15.0537 13.5 15.0537H4.5C3.11929 15.0537 2 13.9345 2 12.5537V7.55371Z " },
            { FluentSymbol.Battery520, "M13.5 5.05371C14.8807 5.05371 16 6.173 16 7.55371V8.38704L17.1667 8.38931C17.3184 8.38931 17.4608 8.4299 17.5833 8.50081C17.8324 8.6449 18 8.91423 18 9.22265V10.8893C18 11.1977 17.8324 11.4671 17.5833 11.6111C17.4608 11.6821 17.3184 11.7226 17.1667 11.7226L16 11.7204V12.5537C16 13.9345 14.8807 15.0537 13.5 15.0537H4.5C3.11929 15.0537 2 13.9345 2 12.5537V7.55371C2 6.173 3.11929 5.05371 4.5 5.05371H13.5ZM13.75 5.99975H4.5C3.85025 5.99975 3.09484 6.49549 3.00822 7.12937L3 7.24975V12.7451C3 13.3922 3.49187 13.9246 4.12219 13.9886L4.25 13.9951H13.75C14.3972 13.9951 14.9295 13.5032 14.9935 12.8729L15 12.7451V7.24975C15 6.60254 14.5081 6.07022 13.8778 6.00621L13.75 5.99975ZM4.83436 7.00239H8.16462C8.5905 7.00239 8.94194 7.32107 8.99349 7.73298L9 7.83776V12.1644C9 12.5903 8.68131 12.9417 8.26941 12.9932L8.16462 12.9998H4.83436C4.40848 12.9998 4.05704 12.6811 4.00549 12.2692L3.99898 12.1644V7.83776C3.99898 7.41189 4.31767 7.06044 4.72957 7.00889L4.83436 7.00239H8.16462H4.83436Z " },
            { FluentSymbol.Battery524Filled, "M17 6C18.6569 6 20 7.34315 20 9V10H21.0003C21.1824 10 21.3532 10.0487 21.5003 10.1338C21.7992 10.3067 22.0003 10.6299 22.0003 11V13C22.0003 13.3701 21.7992 13.6933 21.5003 13.8662C21.3532 13.9513 21.1824 14 21.0003 14H20V15C20 16.6569 18.6569 18 17 18H4.99963C3.34278 18 1.99963 16.6569 1.99963 15V9C1.99963 7.34315 3.34278 6 4.99963 6H17ZM11 9H5.99963C5.44735 9 4.99963 9.44772 4.99963 10V14C4.99963 14.5523 5.44735 15 5.99963 15H11C11.5523 15 12 14.5523 12 14V10C12 9.44772 11.5523 9 11 9Z " },
            { FluentSymbol.Battery524, "M17 6C18.6569 6 20 7.34315 20 9V10H21.0003C21.1824 10 21.3532 10.0487 21.5003 10.1338C21.7992 10.3067 22.0003 10.6299 22.0003 11V13C22.0003 13.3701 21.7992 13.6933 21.5003 13.8662C21.3532 13.9513 21.1824 14 21.0003 14H20V15C20 16.6569 18.6569 18 17 18H4.99963C3.34278 18 1.99963 16.6569 1.99963 15V9C1.99963 7.34315 3.34278 6 4.99963 6H17ZM16.9981 7.5H4.99963C4.21993 7.5 3.57918 8.09489 3.5065 8.85554L3.49963 9V15C3.49963 15.7797 4.09452 16.4204 4.85517 16.4931L4.99963 16.5H16.9981C17.7778 16.5 18.4186 15.9051 18.4912 15.1445L18.4981 15V9C18.4981 8.2203 17.9032 7.57955 17.1426 7.50687L16.9981 7.5ZM5.99963 9H11C11.5128 9 11.9355 9.38604 11.9932 9.88338L12 10V14C12 14.5128 11.6139 14.9355 11.1166 14.9933L11 15H5.99963C5.4868 15 5.06413 14.614 5.00636 14.1166L4.99963 14V10C4.99963 9.48717 5.38568 9.06449 5.88301 9.00673L5.99963 9H11H5.99963Z " },
            { FluentSymbol.Battery620Filled, "M4.83436 7.00239C4.373 7.00239 3.99898 7.3764 3.99898 7.83776V12.1644C3.99898 12.6258 4.37299 12.9998 4.83436 12.9998H9.16462C9.62599 12.9998 10 12.6258 10 12.1644V7.83776C10 7.3764 9.62599 7.00239 9.16462 7.00239H4.83436ZM2 7.55371C2 6.173 3.11929 5.05371 4.5 5.05371H13.5C14.8807 5.05371 16 6.173 16 7.55371V8.38704L17.1667 8.38931C17.3184 8.38931 17.4608 8.4299 17.5833 8.50081C17.8324 8.6449 18 8.91423 18 9.22265V10.8893C18 11.1977 17.8324 11.4671 17.5833 11.6111C17.4608 11.6821 17.3184 11.7226 17.1667 11.7226L16 11.7204V12.5537C16 13.9345 14.8807 15.0537 13.5 15.0537H4.5C3.11929 15.0537 2 13.9345 2 12.5537V7.55371Z " },
            { FluentSymbol.Battery620, "M13.5 5.05371C14.8807 5.05371 16 6.173 16 7.55371V8.38704L17.1667 8.38931C17.3184 8.38931 17.4608 8.4299 17.5833 8.50081C17.8324 8.6449 18 8.91423 18 9.22265V10.8893C18 11.1977 17.8324 11.4671 17.5833 11.6111C17.4608 11.6821 17.3184 11.7226 17.1667 11.7226L16 11.7204V12.5537C16 13.9345 14.8807 15.0537 13.5 15.0537H4.5C3.11929 15.0537 2 13.9345 2 12.5537V7.55371C2 6.173 3.11929 5.05371 4.5 5.05371H13.5ZM13.75 5.99975H4.5C3.85025 5.99975 3.09484 6.49549 3.00822 7.12937L3 7.24975V12.7451C3 13.3922 3.49187 13.9246 4.12219 13.9886L4.25 13.9951H13.75C14.3972 13.9951 14.9295 13.5032 14.9935 12.8729L15 12.7451V7.24975C15 6.60254 14.5081 6.07022 13.8778 6.00621L13.75 5.99975ZM4.83436 7.00239H9.16462C9.5905 7.00239 9.94194 7.32107 9.99349 7.73298L10 7.83776V12.1644C10 12.5903 9.68131 12.9417 9.26941 12.9932L9.16462 12.9998H4.83436C4.40848 12.9998 4.05704 12.6811 4.00549 12.2692L3.99898 12.1644V7.83776C3.99898 7.41189 4.31767 7.06044 4.72957 7.00889L4.83436 7.00239H9.16462H4.83436Z " },
            { FluentSymbol.Battery624Filled, "M17 6C18.6569 6 20 7.34315 20 9V10H21.0003C21.1824 10 21.3532 10.0487 21.5003 10.1338C21.7992 10.3067 22.0003 10.6299 22.0003 11V13C22.0003 13.3701 21.7992 13.6933 21.5003 13.8662C21.3532 13.9513 21.1824 14 21.0003 14H20V15C20 16.6569 18.6569 18 17 18H4.99963C3.34278 18 1.99963 16.6569 1.99963 15V9C1.99963 7.34315 3.34278 6 4.99963 6H17ZM12 9H5.99963C5.44735 9 4.99963 9.44772 4.99963 10V14C4.99963 14.5523 5.44735 15 5.99963 15H12C12.5523 15 13 14.5523 13 14V10C13 9.44772 12.5523 9 12 9Z " },
            { FluentSymbol.Battery624, "M17 6C18.6569 6 20 7.34315 20 9V10H21.0003C21.1824 10 21.3532 10.0487 21.5003 10.1338C21.7992 10.3067 22.0003 10.6299 22.0003 11V13C22.0003 13.3701 21.7992 13.6933 21.5003 13.8662C21.3532 13.9513 21.1824 14 21.0003 14H20V15C20 16.6569 18.6569 18 17 18H4.99963C3.34278 18 1.99963 16.6569 1.99963 15V9C1.99963 7.34315 3.34278 6 4.99963 6H17ZM16.9981 7.5H4.99963C4.21993 7.5 3.57918 8.09489 3.5065 8.85554L3.49963 9V15C3.49963 15.7797 4.09452 16.4204 4.85517 16.4931L4.99963 16.5H16.9981C17.7778 16.5 18.4186 15.9051 18.4912 15.1445L18.4981 15V9C18.4981 8.2203 17.9032 7.57955 17.1426 7.50687L16.9981 7.5ZM5.99963 9H12C12.5128 9 12.9355 9.38604 12.9932 9.88338L13 10V14C13 14.5128 12.6139 14.9355 12.1166 14.9933L12 15H5.99963C5.4868 15 5.06413 14.614 5.00636 14.1166L4.99963 14V10C4.99963 9.48717 5.38568 9.06449 5.88301 9.00673L5.99963 9H12H5.99963Z " },
            { FluentSymbol.Battery720Filled, "M4.83436 7.00239C4.373 7.00239 3.99898 7.3764 3.99898 7.83776V12.1644C3.99898 12.6258 4.37299 12.9998 4.83436 12.9998H10.1646C10.626 12.9998 11 12.6258 11 12.1644V7.83776C11 7.3764 10.626 7.00239 10.1646 7.00239H4.83436ZM2 7.55371C2 6.173 3.11929 5.05371 4.5 5.05371H13.5C14.8807 5.05371 16 6.173 16 7.55371V8.38704L17.1667 8.38931C17.3184 8.38931 17.4608 8.4299 17.5833 8.50081C17.8324 8.6449 18 8.91423 18 9.22265V10.8893C18 11.1977 17.8324 11.4671 17.5833 11.6111C17.4608 11.6821 17.3184 11.7226 17.1667 11.7226L16 11.7204V12.5537C16 13.9345 14.8807 15.0537 13.5 15.0537H4.5C3.11929 15.0537 2 13.9345 2 12.5537V7.55371Z " },
            { FluentSymbol.Battery720, "M13.5 5.05371C14.8807 5.05371 16 6.173 16 7.55371V8.38704L17.1667 8.38931C17.3184 8.38931 17.4608 8.4299 17.5833 8.50081C17.8324 8.6449 18 8.91423 18 9.22265V10.8893C18 11.1977 17.8324 11.4671 17.5833 11.6111C17.4608 11.6821 17.3184 11.7226 17.1667 11.7226L16 11.7204V12.5537C16 13.9345 14.8807 15.0537 13.5 15.0537H4.5C3.11929 15.0537 2 13.9345 2 12.5537V7.55371C2 6.173 3.11929 5.05371 4.5 5.05371H13.5ZM13.75 5.99975H4.5C3.85025 5.99975 3.09484 6.49549 3.00822 7.12937L3 7.24975V12.7451C3 13.3922 3.49187 13.9246 4.12219 13.9886L4.25 13.9951H13.75C14.3972 13.9951 14.9295 13.5032 14.9935 12.8729L15 12.7451V7.24975C15 6.60254 14.5081 6.07022 13.8778 6.00621L13.75 5.99975ZM4.83436 7.00239H10.1646C10.5905 7.00239 10.9419 7.32107 10.9935 7.73298L11 7.83776V12.1644C11 12.5903 10.6813 12.9417 10.2694 12.9932L10.1646 12.9998H4.83436C4.40848 12.9998 4.05704 12.6811 4.00549 12.2692L3.99898 12.1644V7.83776C3.99898 7.41189 4.31767 7.06044 4.72957 7.00889L4.83436 7.00239H10.1646H4.83436Z " },
            { FluentSymbol.Battery724Filled, "M17 6C18.6569 6 20 7.34315 20 9V10H21.0003C21.1824 10 21.3532 10.0487 21.5003 10.1338C21.7992 10.3067 22.0003 10.6299 22.0003 11V13C22.0003 13.3701 21.7992 13.6933 21.5003 13.8662C21.3532 13.9513 21.1824 14 21.0003 14H20V15C20 16.6569 18.6569 18 17 18H4.99963C3.34278 18 1.99963 16.6569 1.99963 15V9C1.99963 7.34315 3.34278 6 4.99963 6H17ZM13 9H5.99963C5.44735 9 4.99963 9.44772 4.99963 10V14C4.99963 14.5523 5.44735 15 5.99963 15H13C13.5523 15 14 14.5523 14 14V10C14 9.44772 13.5523 9 13 9Z " },
            { FluentSymbol.Battery724, "M17 6C18.6569 6 20 7.34315 20 9V10H21.0003C21.1824 10 21.3532 10.0487 21.5003 10.1338C21.7992 10.3067 22.0003 10.6299 22.0003 11V13C22.0003 13.3701 21.7992 13.6933 21.5003 13.8662C21.3532 13.9513 21.1824 14 21.0003 14H20V15C20 16.6569 18.6569 18 17 18H4.99963C3.34278 18 1.99963 16.6569 1.99963 15V9C1.99963 7.34315 3.34278 6 4.99963 6H17ZM16.9981 7.5H4.99963C4.21993 7.5 3.57918 8.09489 3.5065 8.85554L3.49963 9V15C3.49963 15.7797 4.09452 16.4204 4.85517 16.4931L4.99963 16.5H16.9981C17.7778 16.5 18.4186 15.9051 18.4912 15.1445L18.4981 15V9C18.4981 8.2203 17.9032 7.57955 17.1426 7.50687L16.9981 7.5ZM5.99963 9H13C13.5128 9 13.9355 9.38604 13.9932 9.88338L14 10V14C14 14.5128 13.6139 14.9355 13.1166 14.9933L13 15H5.99963C5.4868 15 5.06413 14.614 5.00636 14.1166L4.99963 14V10C4.99963 9.48717 5.38568 9.06449 5.88301 9.00673L5.99963 9H13H5.99963Z " },
            { FluentSymbol.Battery820Filled, "M4.83436 7.00239C4.373 7.00239 3.99898 7.3764 3.99898 7.83776V12.1644C3.99898 12.6258 4.37299 12.9998 4.83436 12.9998H11.1646C11.626 12.9998 12 12.6258 12 12.1644V7.83776C12 7.3764 11.626 7.00239 11.1646 7.00239H4.83436ZM2 7.55371C2 6.173 3.11929 5.05371 4.5 5.05371H13.5C14.8807 5.05371 16 6.173 16 7.55371V8.38704L17.1667 8.38931C17.3184 8.38931 17.4608 8.4299 17.5833 8.50081C17.8324 8.6449 18 8.91423 18 9.22265V10.8893C18 11.1977 17.8324 11.4671 17.5833 11.6111C17.4608 11.6821 17.3184 11.7226 17.1667 11.7226L16 11.7204V12.5537C16 13.9345 14.8807 15.0537 13.5 15.0537H4.5C3.11929 15.0537 2 13.9345 2 12.5537V7.55371Z " },
            { FluentSymbol.Battery820, "M13.5 5.05371C14.8807 5.05371 16 6.173 16 7.55371V8.38704L17.1667 8.38931C17.3184 8.38931 17.4608 8.4299 17.5833 8.50081C17.8324 8.6449 18 8.91423 18 9.22265V10.8893C18 11.1977 17.8324 11.4671 17.5833 11.6111C17.4608 11.6821 17.3184 11.7226 17.1667 11.7226L16 11.7204V12.5537C16 13.9345 14.8807 15.0537 13.5 15.0537H4.5C3.11929 15.0537 2 13.9345 2 12.5537V7.55371C2 6.173 3.11929 5.05371 4.5 5.05371H13.5ZM13.75 5.99975H4.5C3.85025 5.99975 3.09484 6.49549 3.00822 7.12937L3 7.24975V12.7451C3 13.3922 3.49187 13.9246 4.12219 13.9886L4.25 13.9951H13.75C14.3972 13.9951 14.9295 13.5032 14.9935 12.8729L15 12.7451V7.24975C15 6.60254 14.5081 6.07022 13.8778 6.00621L13.75 5.99975ZM4.83436 7.00239H11.1646C11.5905 7.00239 11.9419 7.32107 11.9935 7.73298L12 7.83776V12.1644C12 12.5903 11.6813 12.9417 11.2694 12.9932L11.1646 12.9998H4.83436C4.40848 12.9998 4.05704 12.6811 4.00549 12.2692L3.99898 12.1644V7.83776C3.99898 7.41189 4.31767 7.06044 4.72957 7.00889L4.83436 7.00239H11.1646H4.83436Z " },
            { FluentSymbol.Battery824Filled, "M17 6C18.6569 6 20 7.34315 20 9V10H21.0003C21.1824 10 21.3532 10.0487 21.5003 10.1338C21.7992 10.3067 22.0003 10.6299 22.0003 11V13C22.0003 13.3701 21.7992 13.6933 21.5003 13.8662C21.3532 13.9513 21.1824 14 21.0003 14H20V15C20 16.6569 18.6569 18 17 18H4.99963C3.34278 18 1.99963 16.6569 1.99963 15V9C1.99963 7.34315 3.34278 6 4.99963 6H17ZM14 9H5.99963C5.44735 9 4.99963 9.44772 4.99963 10V14C4.99963 14.5523 5.44734 15 5.99963 15H14C14.5523 15 15 14.5523 15 14V10C15 9.44772 14.5523 9 14 9Z " },
            { FluentSymbol.Battery824, "M17 6C18.6569 6 20 7.34315 20 9V10H21.0003C21.1824 10 21.3532 10.0487 21.5003 10.1338C21.7992 10.3067 22.0003 10.6299 22.0003 11V13C22.0003 13.3701 21.7992 13.6933 21.5003 13.8662C21.3532 13.9513 21.1824 14 21.0003 14H20V15C20 16.6569 18.6569 18 17 18H4.99963C3.34278 18 1.99963 16.6569 1.99963 15V9C1.99963 7.34315 3.34278 6 4.99963 6H17ZM16.9981 7.5H4.99963C4.21993 7.5 3.57918 8.09489 3.5065 8.85554L3.49963 9V15C3.49963 15.7797 4.09452 16.4204 4.85517 16.4931L4.99963 16.5H16.9981C17.7778 16.5 18.4186 15.9051 18.4912 15.1445L18.4981 15V9C18.4981 8.2203 17.9032 7.57955 17.1426 7.50687L16.9981 7.5ZM5.99963 9H14C14.5128 9 14.9355 9.38604 14.9932 9.88338L15 10V14C15 14.5128 14.6139 14.9355 14.1166 14.9933L14 15H5.99963C5.48679 15 5.06413 14.614 5.00636 14.1166L4.99963 14V10C4.99963 9.48717 5.38568 9.06449 5.88301 9.00673L5.99963 9H14H5.99963Z " },
            { FluentSymbol.Battery920Filled, "M4.83436 7.00239C4.373 7.00239 3.99898 7.3764 3.99898 7.83776V12.1644C3.99898 12.6258 4.37299 12.9998 4.83436 12.9998H12.1646C12.626 12.9998 13 12.6258 13 12.1644V7.83776C13 7.3764 12.626 7.00239 12.1646 7.00239H4.83436ZM2 7.55371C2 6.173 3.11929 5.05371 4.5 5.05371H13.5C14.8807 5.05371 16 6.173 16 7.55371V8.38704L17.1667 8.38931C17.3184 8.38931 17.4608 8.4299 17.5833 8.50081C17.8324 8.6449 18 8.91423 18 9.22265V10.8893C18 11.1977 17.8324 11.4671 17.5833 11.6111C17.4608 11.6821 17.3184 11.7226 17.1667 11.7226L16 11.7204V12.5537C16 13.9345 14.8807 15.0537 13.5 15.0537H4.5C3.11929 15.0537 2 13.9345 2 12.5537V7.55371Z " },
            { FluentSymbol.Battery920, "M13.5 5.05371C14.8807 5.05371 16 6.173 16 7.55371V8.38704L17.1667 8.38931C17.3184 8.38931 17.4608 8.4299 17.5833 8.50081C17.8324 8.6449 18 8.91423 18 9.22265V10.8893C18 11.1977 17.8324 11.4671 17.5833 11.6111C17.4608 11.6821 17.3184 11.7226 17.1667 11.7226L16 11.7204V12.5537C16 13.9345 14.8807 15.0537 13.5 15.0537H4.5C3.11929 15.0537 2 13.9345 2 12.5537V7.55371C2 6.173 3.11929 5.05371 4.5 5.05371H13.5ZM13.75 5.99975H4.5C3.85025 5.99975 3.09484 6.49549 3.00822 7.12937L3 7.24975V12.7451C3 13.3922 3.49187 13.9246 4.12219 13.9886L4.25 13.9951H13.75C14.3972 13.9951 14.9295 13.5032 14.9935 12.8729L15 12.7451V7.24975C15 6.60254 14.5081 6.07022 13.8778 6.00621L13.75 5.99975ZM4.83436 7.00239H12.1646C12.5905 7.00239 12.9419 7.32107 12.9935 7.73298L13 7.83776V12.1644C13 12.5903 12.6813 12.9417 12.2694 12.9932L12.1646 12.9998H4.83436C4.40848 12.9998 4.05704 12.6811 4.00549 12.2692L3.99898 12.1644V7.83776C3.99898 7.41189 4.31767 7.06044 4.72957 7.00889L4.83436 7.00239H12.1646H4.83436Z " },
            { FluentSymbol.Battery924Filled, "M5.99963 9C5.44735 9 4.99963 9.44772 4.99963 10V14C4.99963 14.5523 5.44734 15 5.99963 15H15C15.5523 15 16 14.5523 16 14V10C16 9.44772 15.5523 9 15 9H5.99963ZM1.99963 9C1.99963 7.34315 3.34278 6 4.99963 6H17.5003C19.1572 6 20.5003 7.34315 20.5003 9V10H21.0003C21.1824 10 21.3532 10.0487 21.5003 10.1338C21.7992 10.3067 22.0003 10.6299 22.0003 11V13C22.0003 13.3701 21.7992 13.6933 21.5003 13.8662C21.3532 13.9513 21.1824 14 21.0003 14H20.5003V15C20.5003 16.6569 19.1572 18 17.5003 18H4.99963C3.34278 18 1.99963 16.6569 1.99963 15V9Z " },
            { FluentSymbol.Battery924, "M17 6C18.6569 6 20 7.34315 20 9V10H21.0003C21.1824 10 21.3532 10.0487 21.5003 10.1338C21.7992 10.3067 22.0003 10.6299 22.0003 11V13C22.0003 13.3701 21.7992 13.6933 21.5003 13.8662C21.3532 13.9513 21.1824 14 21.0003 14H20V15C20 16.6569 18.6569 18 17 18H4.99963C3.34278 18 1.99963 16.6569 1.99963 15V9C1.99963 7.34315 3.34278 6 4.99963 6H17ZM16.9981 7.5H4.99963C4.21993 7.5 3.57918 8.09489 3.5065 8.85554L3.49963 9V15C3.49963 15.7797 4.09452 16.4204 4.85517 16.4931L4.99963 16.5H16.9981C17.7778 16.5 18.4186 15.9051 18.4912 15.1445L18.4981 15V9C18.4981 8.2203 17.9032 7.57955 17.1426 7.50687L16.9981 7.5ZM5.99963 9H15C15.5128 9 15.9355 9.38604 15.9932 9.88338L16 10V14C16 14.5128 15.6139 14.9355 15.1166 14.9933L15 15H5.99963C5.48679 15 5.06413 14.614 5.00636 14.1166L4.99963 14V10C4.99963 9.48717 5.38568 9.06449 5.88301 9.00673L5.99963 9H15H5.99963Z " },
            { FluentSymbol.BatteryCharge20Filled, "M9.625 4.99967L13.5 5.00496C14.8314 5.00496 15.9197 6.04518 15.9958 7.35682L16 7.50364V8.33653H17.1667C17.3184 8.33653 17.4608 8.37709 17.5833 8.44797C17.8047 8.57598 17.9618 8.80289 17.9939 9.06824L18 9.16942V10.8352C18 11.1435 17.8324 11.4127 17.5833 11.5567C17.4914 11.6098 17.3883 11.6459 17.2786 11.6607L17.1667 11.6681H16V12.501C16 13.8317 14.9593 14.9194 13.6469 14.9954L13.5 14.9997L7.12061 14.9944C6.80419 14.9944 6.5427 14.7594 6.50131 14.4545L6.49561 14.3697V10.6217C6.49561 10.3055 6.73074 10.0441 7.0358 10.0027L7.12061 9.99703H7.8522C8.44882 9.99703 8.93913 9.54207 8.99475 8.96032L9 8.84984V5.62434C9 5.3081 9.23513 5.04674 9.54019 5.00538L9.625 4.99967L13.5 5.00496L9.625 4.99967ZM6.29094 3.33871L6.37575 3.33301C6.69216 3.33301 6.95366 3.56814 6.99505 3.8732L7.00075 3.95801L7 4.99967L7.375 5.00536C7.72018 5.00536 8 5.28518 8 5.63036V7.54207C8 8.34748 7.34708 9.0004 6.54167 9.0004L5.62435 8.9997L5.625 14.3747C5.625 14.6911 5.38987 14.9526 5.08481 14.994L5 14.9997C4.68359 14.9997 4.42209 14.7645 4.38071 14.4595L4.375 14.3747L4.375 8.99967L3.45833 9.0004C2.65292 9.0004 2 8.34748 2 7.54207V5.63036C2 5.28518 2.27982 5.00536 2.625 5.00536H2.99993L3 3.96369C3 3.64728 3.23513 3.38578 3.54019 3.34439L3.625 3.33869C3.94141 3.33869 4.20291 3.57382 4.24429 3.87888L4.25 3.96369L4.24993 5.00536L5.75 4.99967L5.75075 3.95801C5.75075 3.64159 5.98588 3.3801 6.29094 3.33871L6.37575 3.33301L6.29094 3.33871Z " },
            { FluentSymbol.BatteryCharge20, "M15.9958 7.35278L16 7.49967V8.33301L17.1667 8.34787C17.3184 8.34787 17.4608 8.38846 17.5833 8.45937C17.8047 8.58745 17.9618 8.81448 17.9939 9.07997L18 9.18121V10.8479C18 11.1563 17.8324 11.4256 17.5833 11.5697C17.4914 11.6229 17.3883 11.659 17.2786 11.6738L17.1667 11.6812H16V12.4997C16 13.8311 14.9593 14.9194 13.6469 14.9954L13.5 14.9997H7C6.69865 14.9954 6.49794 14.7981 6.49794 14.4952C6.49794 14.1923 6.69865 13.9997 7 13.9997H13.756C14.4057 13.9997 14.9397 13.5039 15.0003 12.8701L15.006 12.7497V7.24395C15.006 6.5942 14.5102 6.06025 13.8764 5.99967L13.756 5.99395H9.53536C9.19962 5.99395 9 5.85567 9 5.49784C9 5.14001 9.22276 4.99967 9.53536 4.99967H13.5C14.8314 4.99967 15.9197 6.04044 15.9958 7.35278ZM6.29094 3.33871L6.37575 3.33301C6.69216 3.33301 6.95366 3.56814 6.99505 3.8732L7.00075 3.95801L7 4.99967L7.375 5.00536C7.72018 5.00536 8 5.28518 8 5.63036V7.54207C8 8.34748 7.34708 9.0004 6.54167 9.0004H3.45833C2.65292 9.0004 2 8.34748 2 7.54207V5.63036C2 5.28518 2.27982 5.00536 2.625 5.00536H2.99993L3 3.96369C3 3.64728 3.23513 3.38578 3.54019 3.34439L3.625 3.33869C3.94141 3.33869 4.20291 3.57382 4.24429 3.87888L4.25 3.96369L4.24993 5.00536L5.75 4.99967L5.75075 3.95801C5.75075 3.64159 5.98588 3.3801 6.29094 3.33871ZM5.5 8.99967V14.4989C5.5 14.7751 5.27614 14.9989 5 14.9989C4.72386 14.9989 4.5 14.7751 4.5 14.4989V8.99967H5.5ZM7 5.99967V7.49967C7 7.74513 6.82312 7.94928 6.58988 7.99162L6.5 7.99967H3.5C3.25454 7.99967 3.05039 7.8228 3.00806 7.58955L3 7.49967V5.99967H7Z " },
            { FluentSymbol.BatteryCharge24Filled, "M10.75 6H17C18.5977 6 19.9037 7.24892 19.9949 8.82373L20 9V10L21.0006 10.0178C21.1827 10.0178 21.3535 10.0665 21.5006 10.1516C21.7663 10.3053 21.9548 10.5778 21.9933 10.8963L22.0006 11.0178V13.0178C22.0006 13.3879 21.7995 13.7111 21.5006 13.884C21.3903 13.9479 21.2667 13.9912 21.1349 14.0089L21.0006 14.0178L20 14V15C20 16.5977 18.7511 17.9037 17.1763 17.9949L17 18H7.99527C7.61558 18 7.30178 17.7178 7.25212 17.3518L7.24527 17.25V12.75C7.24527 12.3703 7.52743 12.0565 7.8935 12.0068L7.99527 12H8.62264C9.33859 12 9.92695 11.4537 9.9937 10.7553L10 10.6226V6.75C10 6.3703 10.2822 6.05651 10.6482 6.00685L10.75 6H17H10.75ZM6.64513 4.00685L6.7469 4C7.1266 4 7.44039 4.28215 7.49005 4.64823L7.4969 4.75L7.496 6H8.25355C8.66777 6 9.00355 6.33579 9.00355 6.75V9.24884C9.00355 10.2153 8.22005 10.9988 7.25355 10.9988L6.251 10.998L6.25178 17.2432C6.25178 17.6229 5.96962 17.9367 5.60355 17.9863L5.50178 17.9932C5.12208 17.9932 4.80829 17.711 4.75862 17.345L4.75178 17.2432L4.75178 10.998L3.75 10.9988C2.7835 10.9988 2 10.2153 2 9.24884V6.75C2 6.33579 2.33579 6 2.75 6H3.501L3.50108 4.75C3.50108 4.3703 3.78324 4.05651 4.14931 4.00685L4.25108 4C4.63078 4 4.94457 4.28215 4.99423 4.64823L5.00108 4.75L5.001 6H5.996L5.9969 4.75C5.9969 4.3703 6.27906 4.05651 6.64513 4.00685L6.7469 4L6.64513 4.00685Z " },
            { FluentSymbol.BatteryCharge24, "M10.75 6H17C18.5977 6 19.9037 7.24892 19.9949 8.82373L20 9V10L21.0006 10.0178C21.1827 10.0178 21.3535 10.0665 21.5006 10.1516C21.7663 10.3053 21.9548 10.5778 21.9933 10.8963L22.0006 11.0178V13.0178C22.0006 13.3879 21.7995 13.7111 21.5006 13.884C21.3903 13.9479 21.2667 13.9912 21.1349 14.0089L21.0006 14.0178L20 14V15C20 16.5977 18.7511 17.9037 17.1763 17.9949L17 18H7.99757C7.58336 18 7.24757 17.6642 7.24757 17.25C7.24757 16.8703 7.52973 16.5565 7.8958 16.5068L7.99757 16.5H17C17.7797 16.5 18.4204 15.9051 18.4931 15.1445L18.5 15V9C18.5 8.2203 17.9051 7.57955 17.1445 7.50687L17 7.5H10.75C10.3358 7.5 10 7.16421 10 6.75C10 6.3703 10.2822 6.05651 10.6482 6.00685L10.75 6H17H10.75ZM6.251 10.998L6.25178 17.25C6.25178 17.6642 5.91599 18 5.50178 18C5.12208 18 4.80829 17.7178 4.75862 17.3518L4.75178 17.25L4.75178 10.998L3.75 10.9988C2.7835 10.9988 2 10.2153 2 9.24884V6.75C2 6.33579 2.33579 6 2.75 6H3.501L3.50108 4.75C3.50108 4.3703 3.78324 4.05651 4.14931 4.00685L4.25108 4C4.63078 4 4.94457 4.28215 4.99423 4.64823L5.00108 4.75L5.001 6H5.996L5.9969 4.75C5.9969 4.3703 6.27906 4.05651 6.64513 4.00685L6.7469 4C7.1266 4 7.44039 4.28215 7.49005 4.64823L7.4969 4.75L7.496 6H8.25355C8.66777 6 9.00355 6.33579 9.00355 6.75V9.24884C9.00355 10.2153 8.22005 10.9988 7.25355 10.9988L6.251 10.998L6.25178 17.25L6.251 10.998ZM7.50355 7.5H3.5V9.24884C3.5 9.38692 3.61193 9.49884 3.75 9.49884H7.25355C7.39162 9.49884 7.50355 9.38692 7.50355 9.24884V7.5Z " },
            { FluentSymbol.BatteryFull20Filled, "M4.83436 7.00239C4.373 7.00239 3.99898 7.3764 3.99898 7.83776V12.1644C3.99898 12.6258 4.37299 12.9998 4.83436 12.9998H13.1646C13.626 12.9998 14 12.6258 14 12.1644V7.83776C14 7.3764 13.626 7.00239 13.1646 7.00239H4.83436ZM2 7.55371C2 6.173 3.11929 5.05371 4.5 5.05371H13.5C14.8807 5.05371 16 6.173 16 7.55371V8.38704L17.1667 8.38931C17.3184 8.38931 17.4608 8.4299 17.5833 8.50081C17.8324 8.6449 18 8.91423 18 9.22265V10.8893C18 11.1977 17.8324 11.4671 17.5833 11.6111C17.4608 11.6821 17.3184 11.7226 17.1667 11.7226L16 11.7204V12.5537C16 13.9345 14.8807 15.0537 13.5 15.0537H4.5C3.11929 15.0537 2 13.9345 2 12.5537V7.55371Z " },
            { FluentSymbol.BatteryFull20, "M13.5 5.05371C14.8807 5.05371 16 6.173 16 7.55371V8.38704L17.1667 8.38931C17.3184 8.38931 17.4608 8.4299 17.5833 8.50081C17.8324 8.6449 18 8.91423 18 9.22265V10.8893C18 11.1977 17.8324 11.4671 17.5833 11.6111C17.4608 11.6821 17.3184 11.7226 17.1667 11.7226L16 11.7204V12.5537C16 13.9345 14.8807 15.0537 13.5 15.0537H4.5C3.11929 15.0537 2 13.9345 2 12.5537V7.55371C2 6.173 3.11929 5.05371 4.5 5.05371H13.5ZM13.75 5.99975H4.5C3.85025 5.99975 3.09484 6.49549 3.00822 7.12937L3 7.24975V12.7451C3 13.3922 3.49187 13.9246 4.12219 13.9886L4.25 13.9951H13.75C14.3972 13.9951 14.9295 13.5032 14.9935 12.8729L15 12.7451V7.24975C15 6.60254 14.5081 6.07022 13.8778 6.00621L13.75 5.99975ZM4.83436 7.00239H13.1646C13.5905 7.00239 13.9419 7.32107 13.9935 7.73298L14 7.83776V12.1644C14 12.5903 13.6813 12.9417 13.2694 12.9932L13.1646 12.9998H4.83436C4.40848 12.9998 4.05704 12.6811 4.00549 12.2692L3.99898 12.1644V7.83776C3.99898 7.41189 4.31767 7.06044 4.72957 7.00889L4.83436 7.00239H13.1646H4.83436Z " },
            { FluentSymbol.BatteryFull24Filled, "M17 6C18.6569 6 20 7.34315 20 9V10H21.0003C21.1824 10 21.3532 10.0487 21.5003 10.1338C21.7992 10.3067 22.0003 10.6299 22.0003 11V13C22.0003 13.3701 21.7992 13.6933 21.5003 13.8662C21.3532 13.9513 21.1824 14 21.0003 14H20V15C20 16.6569 18.6569 18 17 18H4.99963C3.34278 18 1.99963 16.6569 1.99963 15V9C1.99963 7.34315 3.34278 6 4.99963 6H17ZM16 9H6.00052C5.44825 9 5.00052 9.44772 5.00052 10V14C5.00052 14.5523 5.44825 15 6.00052 15H16C16.5523 15 17 14.5523 17 14V10C17 9.44772 16.5523 9 16 9Z " },
            { FluentSymbol.BatteryFull24, "M17 6C18.6569 6 20 7.34315 20 9V10H21.0003C21.1824 10 21.3532 10.0487 21.5003 10.1338C21.7992 10.3067 22.0003 10.6299 22.0003 11V13C22.0003 13.3701 21.7992 13.6933 21.5003 13.8662C21.3532 13.9513 21.1824 14 21.0003 14H20V15C20 16.6569 18.6569 18 17 18H4.99963C3.34278 18 1.99963 16.6569 1.99963 15V9C1.99963 7.34315 3.34278 6 4.99963 6H17ZM16.9981 7.5H4.99963C4.21993 7.5 3.57918 8.09489 3.5065 8.85554L3.49963 9V15C3.49963 15.7797 4.09452 16.4204 4.85517 16.4931L4.99963 16.5H16.9981C17.7778 16.5 18.4186 15.9051 18.4912 15.1445L18.4981 15V9C18.4981 8.2203 17.9032 7.57955 17.1426 7.50687L16.9981 7.5ZM5.99996 9H16C16.5128 9 16.9355 9.38604 16.9932 9.88338L17 10V14C17 14.5128 16.6139 14.9355 16.1166 14.9933L16 15H5.99996C5.48713 15 5.06445 14.614 5.00669 14.1166L4.99996 14V10C4.99996 9.48717 5.386 9.06449 5.88334 9.00673L5.99996 9H16H5.99996Z " },
            { FluentSymbol.BatterySaver20Filled, "M9.58505 5L13.5 5.01486C14.8314 5.01486 15.9197 6.05563 15.9958 7.36797L16 7.51486V8.3482H17.1667C17.3184 8.3482 17.4608 8.38878 17.5833 8.4597C17.8047 8.58777 17.9618 8.81481 17.9939 9.08029L18 9.18153V10.8482C18 11.1566 17.8324 11.4259 17.5833 11.57C17.4914 11.6232 17.3883 11.6593 17.2786 11.6741L17.1667 11.6815H16V12.5149C16 13.8463 14.9593 14.9346 13.6469 15.0106L13.5 15.0149L6 15C5.82062 15 5.5011 14.8797 5.5011 14.4978C5.5011 14.116 5.79227 14 6 14H6.04462C7.3169 14 10 13.0097 10 9.71581C10 8.70183 9.54768 7.04133 9.04462 5.80285C9.0163 5.73313 9.00174 5.65859 9.00174 5.58333C9.00174 5.28802 9.22118 5.04397 9.5059 5.00533L9.58505 5ZM7.16638 4.28841C8.38247 6.5274 9 8.32725 9 9.564C9 10.8007 8.42169 11.8375 7.86035 12.328C7.81539 12.3672 7.76471 12.4029 7.70831 12.435L7.6194 12.4803C7.4419 12.5616 7.23277 12.4822 7.1523 12.3029C7.12241 12.2363 7.11375 12.1626 7.12653 12.0918L7.14647 12.0223C7.62189 10.833 7.8524 9.6636 7.8344 8.51726C7.8293 8.1921 7.56416 7.93267 7.24221 7.93783C6.93235 7.94279 6.6828 8.19101 6.66903 8.49953L6.67192 8.51767C6.67628 8.80803 6.66187 9.10134 6.62879 9.39754L6.57698 9.77179L6.54461 9.95792L6.49137 10.217L6.41239 10.541L6.37876 10.6631C6.24648 11.136 6.06903 11.6159 5.84718 12.1025C5.25386 13.404 4.23111 14.3595 2.80611 14.9551C2.50858 15.0794 2.16758 14.9367 2.04446 14.6362C1.92134 14.3357 2.06272 13.9913 2.36024 13.8669C3.11043 13.5534 3.71004 13.1301 4.16639 12.5934C2.87354 12.1814 2.12148 11.2817 2.01875 10.0261C1.90249 8.60514 2.43231 7.64361 3.77564 6.56233L4.4329 6.05483L4.72011 5.82773C5.36753 5.2992 5.85322 4.77964 6.17881 4.27307C6.41291 3.90885 6.95761 3.90403 7.16638 4.28841Z " },
            { FluentSymbol.BatterySaver20, "M7.18084 4.30888C8.38919 6.56651 9 8.30369 9 9.56335C9 10.8877 8.52493 11.9059 7.57773 12.547C7.3102 12.728 7.05429 12.6393 6.87518 12.3688C6.69607 12.0984 6.82748 11.7487 7.09501 11.5676C7.69932 11.1586 8 10.5142 8 9.56335C8 8.73143 7.62749 7.52154 6.87518 5.95728L6.59583 5.42493L6.20031 5.952C5.93344 6.2331 5.63043 6.51244 5.29145 6.79042L5.03047 6.99865L4.32087 7.54625C3.2587 8.39359 2.91727 8.95537 3 9.94562C3.07537 10.8478 3.71843 11.4502 4.77431 11.6819C5.25315 10.6159 5.55903 9.46387 5.54481 8.51627C5.53992 8.19086 5.80464 7.92881 6.12656 7.92387C6.44847 7.91893 6.66736 8.19086 6.67225 8.51627C6.68952 9.66686 6.41251 10.8637 5.84762 12.1038C5.25438 13.4062 4.23176 14.3625 2.80694 14.9585C2.50945 15.083 2.16617 14.9154 2.04539 14.6394C1.9246 14.3633 2.1021 14.0191 2.39959 13.8947C3.14883 13.5813 3.81157 13.0832 4.26768 12.547C2.97744 12.1391 2.12743 11.3018 2.01713 9.98153C1.89356 8.5025 2.43423 7.63034 3.78328 6.55331L4.43349 6.05154L4.72066 5.82427C5.368 5.29534 5.85362 4.77539 6.17917 4.26844C6.42007 3.89331 6.97031 3.91553 7.18084 4.30888ZM13.5 5C14.8314 5 15.9197 6.04077 15.9958 7.35311L16 7.5V8.33333L17.1667 8.3482C17.3184 8.3482 17.4608 8.38878 17.5833 8.4597C17.8047 8.58777 17.9618 8.81481 17.9939 9.08029L18 9.18153V10.8482C18 11.1566 17.8324 11.4259 17.5833 11.57C17.4914 11.6232 17.3883 11.6593 17.2786 11.6741L17.1667 11.6815H16V12.5C16 13.8314 14.9593 14.9197 13.6469 14.9958L13.5 15H6C5.69865 14.9958 5.49794 14.7984 5.49794 14.4955C5.49794 14.1926 5.69865 14 6 14H13.756C14.4057 14 14.9397 13.5042 15.0003 12.8704L15.006 12.75V7.24428C15.006 6.59453 14.5102 6.06057 13.8764 6L13.756 5.99428H9.53536C9.19962 5.99428 9 5.856 9 5.49817C9 5.14034 9.22276 5 9.53536 5H13.5Z " },
            { FluentSymbol.BatterySaver24Filled, "M8.64506 4.3605C10.2094 7.21227 11.0038 9.50471 11.0038 11.0799C11.0038 12.6552 10.2599 13.9757 9.53777 14.6003C9.47995 14.6504 9.41475 14.6958 9.3422 14.7366L9.22783 14.7944C8.99949 14.8979 8.73047 14.7967 8.62694 14.5684C8.58849 14.4836 8.57735 14.3897 8.5938 14.2995L8.61945 14.211C9.23103 12.6962 9.52755 11.2068 9.5044 9.74673C9.49783 9.33257 9.15676 9.00214 8.7426 9.00871C8.344 9.01503 8.02297 9.33118 8.00526 9.72414L8.00898 9.74724C8.01459 10.1171 7.99605 10.4907 7.9535 10.8679L7.88685 11.3446L7.84522 11.5817L7.77673 11.9117L7.67513 12.3243L7.63186 12.4798C7.4617 13.0821 7.23342 13.6934 6.94803 14.3132C6.18479 15.9708 4.86913 17.1879 3.036 17.9465C2.65326 18.1049 2.2146 17.923 2.05621 17.5403C1.89783 17.1575 2.0797 16.7189 2.46244 16.5605C3.42748 16.1611 4.19881 15.6221 4.78587 14.9385C3.12274 14.4136 2.1553 13.2678 2.02314 11.6685C1.87359 9.85865 2.55515 8.63397 4.28321 7.25677L4.77375 6.87945L5.1287 6.61037L5.49817 6.32112C6.33102 5.64794 6.9558 4.98618 7.37465 4.34097C7.67579 3.87707 8.37649 3.87093 8.64506 4.3605ZM17 5.99954C18.5977 5.99954 19.9037 7.24846 19.9949 8.82327L20 8.99954V9.99954L21.0007 10.0174C21.1828 10.0174 21.3536 10.0661 21.5007 10.1512C21.7663 10.3049 21.9548 10.5773 21.9934 10.8959L22.0007 11.0174V13.0174C22.0007 13.3875 21.7996 13.7107 21.5007 13.8836C21.3903 13.9474 21.2667 13.9908 21.1349 14.0084L21.0007 14.0174L20 13.9995V14.9995C20 16.5973 18.7511 17.9032 17.1763 17.9944L17 17.9995H8.24254C7.69025 17.9995 7.24254 17.5518 7.24254 16.9995C7.24254 16.4867 7.62858 16.064 8.12592 16.0063L8.24254 15.9995H8.87269L8.94828 15.9939L9.0529 15.9752C9.79577 15.8126 12 14.7724 12 11.0174C12 9.8006 11.6982 8.44913 11.0945 6.96296C11.0605 6.8793 11.043 6.78984 11.043 6.69954C11.043 6.34517 11.3064 6.0523 11.648 6.00593L11.743 5.99954H17Z " },
            { FluentSymbol.BatterySaver24, "M7.37459 4.34164C7.68451 3.86422 8.39244 3.89249 8.6633 4.39312C10.2179 7.26646 11.0038 9.47742 11.0038 11.0806C11.0038 12.7662 10.3926 14.0621 9.17392 14.8779C8.82973 15.1084 8.36389 15.0161 8.13346 14.6719C7.90302 14.3277 7.99524 13.8619 8.33944 13.6315C9.11692 13.111 9.50376 12.2908 9.50376 11.0806C9.50376 10.0218 9.02451 8.48196 8.05661 6.49109L7.88073 6.13508L7.63193 6.40383C7.28858 6.76158 6.89873 7.11711 6.46261 7.4709L6.12685 7.73593L5.2139 8.43286C3.84736 9.5113 3.40807 10.2263 3.51452 11.4866C3.61149 12.6348 4.25896 13.3179 5.61742 13.6128C6.23348 12.2561 6.52743 10.9768 6.50913 9.77074C6.50284 9.35657 6.8335 9.01573 7.24766 9.00944C7.66183 9.00316 8.00267 9.33381 8.00896 9.74797C8.03118 11.2124 7.67479 12.7355 6.94801 14.314C6.18477 15.9716 4.86911 17.1886 3.03598 17.9472C2.65324 18.1056 2.21458 17.9237 2.05619 17.541C1.89781 17.1583 2.07968 16.7196 2.46242 16.5612C3.42637 16.1623 4.19705 15.624 4.78386 14.9415C3.12388 14.4224 2.16176 13.2932 2.01984 11.6128C1.86085 9.73044 2.55647 8.62043 4.29211 7.24966L5.12864 6.61105L5.49811 6.3218C6.33096 5.64862 6.95574 4.98686 7.37459 4.34164ZM11.75 6.00027H17C18.5977 6.00027 19.9037 7.24919 19.9949 8.824L20 9.00027V10.0003L21.0006 10.0181C21.1827 10.0181 21.3535 10.0668 21.5006 10.1519C21.7663 10.3056 21.9547 10.578 21.9933 10.8966L22.0006 11.0181V13.0181C22.0006 13.3882 21.7995 13.7114 21.5006 13.8843C21.3903 13.9481 21.2667 13.9915 21.1349 14.0092L21.0006 14.0181L20 14.0003V15.0003C20 16.598 18.7511 17.9039 17.1763 17.9952L17 18.0003H6.74999C6.33577 18.0003 5.99999 17.6645 5.99999 17.2503C5.99999 16.8706 6.28214 16.5568 6.64822 16.5071L6.74999 16.5003H17C17.7797 16.5003 18.4204 15.9054 18.4931 15.1447L18.5 15.0003V9.00027C18.5 8.22057 17.9051 7.57982 17.1444 7.50714L17 7.50027H11.75C11.3358 7.50027 11 7.16448 11 6.75027C11 6.37057 11.2821 6.05678 11.6482 6.00712L11.75 6.00027H17H11.75Z " },
            { FluentSymbol.BatteryWarning24Filled, "M8.24399 11.2001C8.47542 11.3327 8.66731 11.5245 8.79989 11.756L12.8092 18.7544C13.221 19.4732 12.9721 20.3897 12.2533 20.8015C12.0263 20.9316 11.7693 21 11.5077 21H3.48901C2.66059 21 1.98901 20.3284 1.98901 19.5C1.98901 19.2384 2.05743 18.9813 2.18747 18.7544L6.1968 11.756C6.60861 11.0371 7.52517 10.7883 8.24399 11.2001ZM7.50003 18C7.22388 18 7.00003 18.2239 7.00003 18.5C7.00003 18.7761 7.22388 19 7.50003 19C7.77617 19 8.00003 18.7761 8.00003 18.5C8.00003 18.2239 7.77617 18 7.50003 18ZM17 6C18.6569 6 20 7.34315 20 9V10H21.0004C21.1825 10 21.3533 10.0487 21.5004 10.1338C21.7993 10.3067 22.0004 10.6299 22.0004 11V13C22.0004 13.3701 21.7993 13.6933 21.5004 13.8662C21.3533 13.9513 21.1825 14 21.0004 14H20V15C20 16.6569 18.6569 18 17 18H13.529L9.66758 11.2589C9.44661 10.8732 9.1268 10.5533 8.74109 10.3324C7.54305 9.64603 6.01546 10.0608 5.32911 11.2589L2.36435 16.4347C2.13184 16.0085 1.9997 15.5197 1.9997 15V9C1.9997 7.34315 3.34285 6 4.9997 6H17ZM7.49835 13C7.2222 13 6.99835 13.2239 6.99835 13.5V16.5L7.0064 16.5899C7.04874 16.8231 7.25289 17 7.49835 17C7.77449 17 7.99835 16.7761 7.99835 16.5V13.5L7.99029 13.4101C7.94796 13.1769 7.74381 13 7.49835 13Z " },
            { FluentSymbol.BatteryWarning24, "M8.24399 11.2001C8.47542 11.3327 8.66731 11.5245 8.79989 11.756L12.8092 18.7544C13.221 19.4732 12.9721 20.3897 12.2533 20.8015C12.0263 20.9316 11.7693 21 11.5077 21H3.48901C2.66059 21 1.98901 20.3284 1.98901 19.5C1.98901 19.2384 2.05743 18.9813 2.18747 18.7544L6.1968 11.756C6.60861 11.0371 7.52517 10.7883 8.24399 11.2001ZM7.50003 18C7.22388 18 7.00003 18.2239 7.00003 18.5C7.00003 18.7761 7.22388 19 7.50003 19C7.77617 19 8.00003 18.7761 8.00003 18.5C8.00003 18.2239 7.77617 18 7.50003 18ZM17 6C18.6569 6 20 7.34315 20 9V10H21.0004C21.1825 10 21.3533 10.0487 21.5004 10.1338C21.7993 10.3067 22.0004 10.6299 22.0004 11V13C22.0004 13.3701 21.7993 13.6933 21.5004 13.8662C21.3533 13.9513 21.1825 14 21.0004 14H20V15C20 16.6569 18.6569 18 17 18H13.529L12.67 16.5H16.9982C17.7779 16.5 18.4186 15.9051 18.4913 15.1445L18.4982 15V9C18.4982 8.2203 17.9033 7.57955 17.1426 7.50687L16.9982 7.5H4.9997C4.22 7.5 3.57925 8.09489 3.50657 8.85554L3.4997 9L3.49901 14.453L2.36435 16.4347C2.13184 16.0085 1.9997 15.5197 1.9997 15V9C1.9997 7.34315 3.34285 6 4.9997 6H17ZM7.49835 13C7.25289 13 7.04874 13.1769 7.0064 13.4101L6.99835 13.5V16.5L7.0064 16.5899C7.04874 16.8231 7.25289 17 7.49835 17C7.74381 17 7.94796 16.8231 7.99029 16.5899L7.99835 16.5V13.5L7.99029 13.4101C7.94796 13.1769 7.74381 13 7.49835 13Z " },
            { FluentSymbol.Beaker16Filled, "M5.99998 3V6.68895C5.99998 7.13159 5.88246 7.56629 5.65943 7.94863L5.04612 9H10.9538L10.3405 7.94863C10.1175 7.56629 9.99998 7.13159 9.99998 6.68895V3H10.5C10.7761 3 11 2.77614 11 2.5C11 2.22386 10.7761 2 10.5 2H5.49997C5.22383 2 4.99997 2.22386 4.99997 2.5C4.99997 2.77614 5.22383 3 5.49997 3H5.99998Z M11.5372 10H4.46278L3.44536 11.7441C2.86203 12.7441 3.58334 13.9999 4.74103 13.9999H11.2589C12.4166 13.9999 13.1379 12.7441 12.5546 11.7441L11.5372 10Z " },
            { FluentSymbol.Beaker16, "M5.49997 3H5.99998V6.68895C5.99998 7.13159 5.88246 7.56629 5.65943 7.94863L3.44536 11.7441C2.86203 12.7441 3.58334 13.9999 4.74103 13.9999H11.2589C12.4166 13.9999 13.1379 12.7441 12.5546 11.7441L10.3405 7.94863C10.1175 7.56629 9.99998 7.13159 9.99998 6.68895V3H10.5C10.7761 3 11 2.77614 11 2.5C11 2.22386 10.7761 2 10.5 2H5.49997C5.22383 2 4.99997 2.22386 4.99997 2.5C4.99997 2.77614 5.22383 3 5.49997 3ZM6.99998 6.68895V3H8.99998V6.68895C8.99998 7.30864 9.16452 7.91723 9.47676 8.45251L9.79614 9H6.20383L6.5232 8.45251C6.83545 7.91723 6.99998 7.30864 6.99998 6.68895ZM5.62049 10H10.3795L11.6908 12.248C11.8853 12.5813 11.6448 12.9999 11.2589 12.9999H4.74103C4.35513 12.9999 4.1147 12.5813 4.30914 12.248L5.62049 10Z " },
            { FluentSymbol.Beaker20Filled, "M7.25 4V8.74704C7.25 9.15896 7.14821 9.5645 6.95369 9.9276L6.11133 11.5H13.8887L13.0463 9.9276C12.8518 9.5645 12.75 9.15896 12.75 8.74704V4H13.5C13.7761 4 14 3.77614 14 3.5C14 3.22386 13.7761 3 13.5 3H6.5C6.22386 3 6 3.22386 6 3.5C6 3.77614 6.22386 4 6.5 4H7.25Z M14.4244 12.5H5.57561L4.34795 14.7916C3.81264 15.7909 4.53657 16.9999 5.67017 16.9999H14.3298C15.4634 16.9999 16.1874 15.7909 15.652 14.7916L14.4244 12.5Z " },
            { FluentSymbol.Beaker20, "M6.5 4H7.25V8.74704C7.25 9.15896 7.14821 9.5645 6.95369 9.9276L4.34795 14.7916C3.81264 15.7909 4.53657 16.9999 5.67017 16.9999H14.3298C15.4634 16.9999 16.1874 15.7909 15.652 14.7916L13.0463 9.9276C12.8518 9.5645 12.75 9.15896 12.75 8.74704V4H13.5C13.7761 4 14 3.77614 14 3.5C14 3.22386 13.7761 3 13.5 3H6.5C6.22386 3 6 3.22386 6 3.5C6 3.77614 6.22386 4 6.5 4ZM8.25 8.74704V4H11.75V8.74704C11.75 9.32373 11.8925 9.89149 12.1648 10.3998L12.7542 11.5H7.24579L7.83517 10.3998C8.1075 9.89149 8.25 9.32373 8.25 8.74704ZM6.71007 12.5H13.2899L14.7706 15.2638C14.949 15.5969 14.7077 15.9999 14.3298 15.9999H5.67017C5.2923 15.9999 5.05099 15.5969 5.22943 15.2638L6.71007 12.5Z " },
            { FluentSymbol.Beaker24Filled, "M8.99998 4.5V10.7382C8.99998 11.1132 8.90628 11.4822 8.72739 11.8117L7.53944 14H16.4605L15.2726 11.8117C15.0937 11.4822 15 11.1132 15 10.7382V4.5H16C16.4142 4.5 16.75 4.16421 16.75 3.75C16.75 3.33579 16.4142 3 16 3H8C7.58579 3 7.25 3.33579 7.25 3.75C7.25 4.16421 7.58579 4.5 8 4.5H8.99998Z M17.2748 15.5H6.72515L5.14269 18.415C4.50968 19.5811 5.35388 20.9999 6.68068 20.9999H17.3193C18.6461 20.9999 19.4903 19.5811 18.8573 18.415L17.2748 15.5Z " },
            { FluentSymbol.Beaker24, "M8 4.5H8.99998V10.7382C8.99998 11.1132 8.90628 11.4822 8.72739 11.8117L5.14269 18.415C4.50968 19.5811 5.35388 20.9999 6.68068 20.9999H17.3193C18.6461 20.9999 19.4903 19.5811 18.8573 18.415L15.2726 11.8117C15.0937 11.4822 15 11.1132 15 10.7382V4.5H16C16.4142 4.5 16.75 4.16421 16.75 3.75C16.75 3.33579 16.4142 3 16 3H8C7.58579 3 7.25 3.33579 7.25 3.75C7.25 4.16421 7.58579 4.5 8 4.5ZM10.5 10.7382V4.5H13.5V10.7382C13.5 11.3631 13.6561 11.9781 13.9543 12.5273L14.7537 14H9.24621L10.0457 12.5273C10.3438 11.9781 10.5 11.3631 10.5 10.7382ZM8.43192 15.5H15.568L17.539 19.1307C17.6294 19.2973 17.5088 19.4999 17.3193 19.4999H6.68068C6.49114 19.4999 6.37054 19.2973 6.46097 19.1307L8.43192 15.5Z " },
            { FluentSymbol.Bed16Filled, "M7.5 6H8.5V5.5C8.5 5.22386 8.72386 5 9 5H10.5C10.7761 5 11 5.22386 11 5.5V6H13V4C13 2.89543 12.1046 2 11 2H5C3.89543 2 3 2.89543 3 4V6H5V5.5C5 5.22386 5.22386 5 5.5 5H7C7.27614 5 7.5 5.22386 7.5 5.5V6Z M3.5 7C2.11929 7 1 8.11929 1 9.5V13.5C1 13.7761 1.22386 14 1.5 14C1.77614 14 2 13.7761 2 13.5V11H14V13.5C14 13.7761 14.2239 14 14.5 14C14.7761 14 15 13.7761 15 13.5V9.5C15 8.11929 13.8807 7 12.5 7H3.5Z " },
            { FluentSymbol.Bed16, "M3 4.5C3 3.11929 4.11929 2 5.5 2H10.5C11.8807 2 13 3.11929 13 4.5V6.05001C14.1411 6.28164 15 7.29052 15 8.5V13.5C15 13.7761 14.7761 14 14.5 14C14.2239 14 14 13.7761 14 13.5V11H2V13.5C2 13.7761 1.77614 14 1.5 14C1.22386 14 1 13.7761 1 13.5V8.5C1 7.29052 1.85888 6.28164 3 6.05001V4.5ZM2 10H14V8.5C14 7.67157 13.3284 7 12.5 7H3.5C2.67157 7 2 7.67157 2 8.5V10ZM12 4.5C12 3.67157 11.3284 3 10.5 3H5.5C4.67157 3 4 3.67157 4 4.5V6H5V5.5C5 5.22386 5.22386 5 5.5 5H7C7.27614 5 7.5 5.22386 7.5 5.5V6H8.5V5.5C8.5 5.22386 8.72386 5 9 5H10.5C10.7761 5 11 5.22386 11 5.5V6H12V4.5Z " },
            { FluentSymbol.Bed20Filled, "M15.5 9C16.8255 9 17.91 10.0315 17.9947 11.3356L18 11.5V16.5C18 16.7761 17.7761 17 17.5 17C17.2545 17 17.0504 16.8231 17.0081 16.5899L17 16.5V14H3V16.5C3 16.7761 2.77614 17 2.5 17C2.25454 17 2.05039 16.8231 2.00806 16.5899L2 16.5V11.5C2 10.1745 3.03154 9.08996 4.33562 9.00532L4.5 9H15.5ZM6.5 3H13.5C14.8255 3 15.91 4.03154 15.9947 5.33562L16 5.5V8H14V7.5C14 7.25454 13.8231 7.05039 13.5899 7.00806L13.5 7H11C10.7545 7 10.5504 7.17688 10.5081 7.41012L10.5 7.5V8H9.5V7.5C9.5 7.25454 9.32312 7.05039 9.08988 7.00806L9 7H6.5C6.25454 7 6.05039 7.17688 6.00806 7.41012L6 7.5V8H4V5.5C4 4.17452 5.03154 3.08996 6.33562 3.00532L6.5 3Z " },
            { FluentSymbol.Bed20, "M13.5 3C14.8255 3 15.91 4.03154 15.9947 5.33562L16 5.5L16.0004 8.0501C17.087 8.27086 17.9176 9.19636 17.9942 10.3287L18 10.5V16.5C18 16.7761 17.7761 17 17.5 17C17.2545 17 17.0504 16.8231 17.0081 16.5899L17 16.5V14H3V16.5C3 16.7761 2.77614 17 2.5 17C2.25454 17 2.05039 16.8231 2.00806 16.5899L2 16.5V10.5C2 9.29032 2.85917 8.28131 4.00057 8.04989L4 5.5C4 4.17452 5.03154 3.08996 6.33562 3.00532L6.5 3H13.5ZM15.5 9H4.5C3.7203 9 3.07955 9.59489 3.00687 10.3555L3 10.5V13H17V10.5C17 9.7203 16.4051 9.07955 15.6445 9.00687L15.5 9ZM13.5 4H6.5C5.7203 4 5.07955 4.59489 5.00687 5.35554L5 5.5V8H6V7.5C6 7.22386 6.22386 7 6.5 7H9C9.27614 7 9.5 7.22386 9.5 7.5V8H10.5V7.5C10.5 7.22386 10.7239 7 11 7H13.5C13.7761 7 14 7.22386 14 7.5V8H15V5.5C15 4.7203 14.4051 4.07955 13.6445 4.00687L13.5 4Z " },
            { FluentSymbol.Bed24Filled, "M19.25 11C20.7125 11 21.9084 12.1417 21.995 13.5825L22 13.75V20.25C22 20.6642 21.6642 21 21.25 21C20.8703 21 20.5565 20.7178 20.5068 20.3518L20.5 20.25V18H3.5V20.25C3.5 20.6297 3.21785 20.9435 2.85177 20.9932L2.75 21C2.3703 21 2.05651 20.7178 2.00685 20.3518L2 20.25V13.75C2 12.2875 3.1417 11.0916 4.58248 11.005L4.75 11H19.25ZM6.75 4H17.25C18.7125 4 19.9084 5.1417 19.995 6.58248L20 6.75V10H17L16.9933 9.88338C16.94 9.4243 16.5757 9.06005 16.1166 9.00673L16 9H14C13.4872 9 13.0645 9.38604 13.0067 9.88338L13 10H11L10.9933 9.88338C10.9399 9.4243 10.5757 9.06005 10.1166 9.00673L10 9H8C7.48716 9 7.06449 9.38604 7.00673 9.88338L7 10H4V6.75C4 5.28747 5.1417 4.0916 6.58248 4.00502L6.75 4Z " },
            { FluentSymbol.Bed24, "M6.75 4H17.25C18.7125 4 19.9084 5.1417 19.995 6.58248L20 6.75L20.0006 10.1037C21.0968 10.414 21.9147 11.3872 21.9937 12.5628L22 12.75V20.25C22 20.6642 21.6642 21 21.25 21C20.8703 21 20.5565 20.7178 20.5068 20.3518L20.5 20.25V18H3.5V20.25C3.5 20.6297 3.21785 20.9435 2.85177 20.9932L2.75 21C2.3703 21 2.05651 20.7178 2.00685 20.3518L2 20.25V12.75C2 11.4911 2.84596 10.4297 4.00044 10.1034L4 6.75C4 5.28747 5.1417 4.0916 6.58248 4.00502L6.75 4ZM19.25 11.5H4.75C4.10279 11.5 3.57047 11.9919 3.50645 12.6222L3.5 12.75V16.5H20.5V12.75C20.5 12.1028 20.0081 11.5705 19.3778 11.5065L19.25 11.5ZM17.25 5.5H6.75C6.10279 5.5 5.57047 5.99187 5.50645 6.62219L5.5 6.75V10H7C7 9.44772 7.44772 9 8 9H10C10.5128 9 10.9355 9.38604 10.9933 9.88338L11 10H13C13 9.44772 13.4477 9 14 9H16C16.5128 9 16.9355 9.38604 16.9933 9.88338L17 10H18.5V6.75C18.5 6.10279 18.0081 5.57047 17.3778 5.50645L17.25 5.5Z " },
            { FluentSymbol.Block16Filled, "M8 2C11.3137 2 14 4.68629 14 8C14 11.3137 11.3137 14 8 14C4.68629 14 2 11.3137 2 8C2 4.68629 4.68629 2 8 2ZM10.5015 7.5H5.5C5.22386 7.5 5 7.72386 5 8C5 8.27614 5.22386 8.5 5.5 8.5H10.5015C10.7777 8.5 11.0015 8.27614 11.0015 8C11.0015 7.72386 10.7777 7.5 10.5015 7.5Z " },
            { FluentSymbol.Block16, "M8 2C11.3137 2 14 4.68629 14 8C14 11.3137 11.3137 14 8 14C4.68629 14 2 11.3137 2 8C2 4.68629 4.68629 2 8 2ZM8 3C5.23858 3 3 5.23858 3 8C3 10.7614 5.23858 13 8 13C10.7614 13 13 10.7614 13 8C13 5.23858 10.7614 3 8 3ZM5.5 7.5H10.5015C10.7777 7.5 11.0015 7.72386 11.0015 8C11.0015 8.24546 10.8247 8.44961 10.5914 8.49194L10.5015 8.5H5.5C5.22386 8.5 5 8.27614 5 8C5 7.75454 5.17688 7.55039 5.41012 7.50806L5.5 7.5H10.5015H5.5Z " },
            { FluentSymbol.Block20Filled, "M10 2C14.4183 2 18 5.58172 18 10C18 14.4183 14.4183 18 10 18C5.58172 18 2 14.4183 2 10C2 5.58172 5.58172 2 10 2ZM13.5 9.5H6.5L6.41012 9.50806C6.17688 9.55039 6 9.75454 6 10C6 10.2761 6.22386 10.5 6.5 10.5H13.5L13.5899 10.4919C13.8231 10.4496 14 10.2455 14 10C14 9.72386 13.7761 9.5 13.5 9.5Z " },
            { FluentSymbol.Block20, "M10 2C14.4183 2 18 5.58172 18 10C18 14.4183 14.4183 18 10 18C5.58172 18 2 14.4183 2 10C2 5.58172 5.58172 2 10 2ZM10 3C6.13401 3 3 6.13401 3 10C3 13.866 6.13401 17 10 17C13.866 17 17 13.866 17 10C17 6.13401 13.866 3 10 3ZM6.5 9.5H13.5C13.7761 9.5 14 9.72386 14 10C14 10.2455 13.8231 10.4496 13.5899 10.4919L13.5 10.5H6.5C6.22386 10.5 6 10.2761 6 10C6 9.75454 6.17688 9.55039 6.41012 9.50806L6.5 9.5H13.5H6.5Z " },
            { FluentSymbol.Block24Filled, "M12.0007 2.00098C17.5236 2.00098 22.0007 6.47813 22.0007 12.001C22.0007 17.5238 17.5236 22.001 12.0007 22.001C6.47788 22.001 2.00073 17.5238 2.00073 12.001C2.00073 6.47813 6.47788 2.00098 12.0007 2.00098ZM16.25 11.2503H7.75003C7.33581 11.2503 7.00003 11.5861 7.00003 12.0003C7.00003 12.4145 7.33581 12.7503 7.75003 12.7503H16.25C16.6642 12.7503 17 12.4145 17 12.0003C17 11.5861 16.6642 11.2503 16.25 11.2503Z " },
            { FluentSymbol.Block24, "M12.0007 2.00098C17.5236 2.00098 22.0007 6.47813 22.0007 12.001C22.0007 17.5238 17.5236 22.001 12.0007 22.001C6.47788 22.001 2.00073 17.5238 2.00073 12.001C2.00073 6.47813 6.47788 2.00098 12.0007 2.00098ZM12.0007 3.50098C7.30631 3.50098 3.50073 7.30656 3.50073 12.001C3.50073 16.6954 7.30631 20.501 12.0007 20.501C16.6952 20.501 20.5007 16.6954 20.5007 12.001C20.5007 7.30656 16.6952 3.50098 12.0007 3.50098ZM7.75003 11.2503H16.25C16.6642 11.2503 17 11.5861 17 12.0003C17 12.38 16.7179 12.6938 16.3518 12.7434L16.25 12.7503H7.75003C7.33581 12.7503 7.00003 12.4145 7.00003 12.0003C7.00003 11.6206 7.28218 11.3068 7.64826 11.2571L7.75003 11.2503H16.25H7.75003Z " },
            { FluentSymbol.Bluetooth24Filled, "M16.2163 9.72003C16.656 9.35374 16.6992 8.69393 16.311 8.27347L11.7403 3.32178C11.1228 2.65288 10.0054 3.08975 10.0054 4.00006V9.09768L9.36563 8.56405C8.9415 8.2103 8.31091 8.26736 7.95717 8.69149C7.60343 9.11562 7.66049 9.74621 8.08462 10.1L10.0054 11.702V12.2916L8.08501 13.8917C7.6607 14.2452 7.60332 14.8758 7.95684 15.3001C8.31037 15.7244 8.94093 15.7818 9.36524 15.4282L10.0054 14.8948V20.0001C10.0054 20.9105 11.123 21.3473 11.7404 20.6782L16.3112 15.7242C16.699 15.3039 16.656 14.6445 16.2167 14.2782L13.4826 11.9978L16.2163 9.72003ZM12.0054 13.3701L14.1284 15.1407L12.0054 17.4416V13.3701ZM12.0054 10.6252V6.55771L14.1278 8.85693L12.0054 10.6252Z " },
            { FluentSymbol.Bluetooth24, "M11.6978 12.9737L14.3802 15.2109L11.5044 18.3278V13.1348L11.6978 12.9737ZM12.8693 11.9976L15.9462 9.43399C16.2759 9.15927 16.3083 8.66442 16.0172 8.34907L11.3055 3.24475C10.8425 2.74308 10.0044 3.07073 10.0044 3.75346V9.60811L8.88421 8.67379C8.56611 8.40848 8.09317 8.45127 7.82786 8.76937C7.56256 9.08747 7.60535 9.56041 7.92345 9.82571L10.0044 11.5614V12.4321L7.92374 14.1657C7.60551 14.4309 7.56247 14.9038 7.82762 15.222C8.09276 15.5402 8.56568 15.5833 8.88391 15.3181L10.0044 14.3845V20.2466C10.0044 20.9295 10.8426 21.2571 11.3057 20.7552L16.0173 15.6486C16.3082 15.3333 16.2759 14.8388 15.9465 14.564L12.8693 11.9976ZM11.6983 11.0208L11.5044 10.8592V5.6717L14.3798 8.78667L11.6983 11.0208Z " },
            { FluentSymbol.Bluetooth28Filled, "M12.5823 2.09144C12.9372 1.92829 13.3545 1.98667 13.651 2.24094L20.651 8.24429C20.8744 8.4359 21.0021 8.7162 21 9.01053C20.9979 9.30485 20.8662 9.5833 20.6401 9.77169L15.5632 14.001L20.6402 18.2318C20.8663 18.4202 20.998 18.6987 21 18.9931C21.002 19.2874 20.8743 19.5677 20.6508 19.7593L13.6508 25.7593C13.3543 26.0134 12.937 26.0717 12.5822 25.9085C12.2274 25.7453 12 25.3905 12 25V16.9693L8.64008 19.7683C8.21575 20.1218 7.58519 20.0644 7.2317 19.6401C6.8782 19.2157 6.93563 18.5852 7.35997 18.2317L12 14.3663V13.6351L7.35984 9.76824C6.93556 9.41467 6.87824 8.78411 7.2318 8.35983C7.58537 7.93555 8.21593 7.87823 8.64021 8.23179L12 11.0316V3.00001C12 2.60943 12.2274 2.2546 12.5823 2.09144ZM14.0011 12.6992L18.451 8.99227L14 5.17503V12.6983L14.0011 12.6992ZM14.0009 15.3025L14 15.3032V22.8258L18.4509 19.0108L14.0009 15.3025Z " },
            { FluentSymbol.Bluetooth28, "M12.9367 2.06863C13.2028 1.94624 13.5158 1.98995 13.7382 2.18057L20.7382 8.18057C20.9054 8.3239 21.0012 8.5335 21.0001 8.75375C20.999 8.974 20.9011 9.18263 20.7325 9.32429L15.1661 14L20.7325 18.6757C20.9011 18.8174 20.999 19.026 21.0001 19.2463C21.0012 19.4665 20.9054 19.6761 20.7382 19.8195L13.7382 25.8195C13.5158 26.0101 13.2028 26.0538 12.9367 25.9314C12.6706 25.8091 12.5001 25.543 12.5001 25.2501V16.2395L8.23241 19.8243C7.91524 20.0907 7.44215 20.0496 7.17574 19.7324C6.90932 19.4152 6.95046 18.9421 7.26763 18.6757L12.5001 14.2805V13.7195L7.26763 9.32429C6.95046 9.05787 6.90932 8.58478 7.17574 8.26762C7.44215 7.95045 7.91524 7.90931 8.23241 8.17573L12.5001 11.7606V2.75001C12.5001 2.45711 12.6706 2.19102 12.9367 2.06863ZM14.0001 14.9795V23.6194L19.0909 19.2558L14.0001 14.9795ZM14.0001 13.0205L19.0909 8.74423L14.0001 4.38068V13.0205Z " },
            { FluentSymbol.Bluetooth20Filled, "M9.53425 2.04346C9.23536 2.14985 9.03574 2.43278 9.03574 2.75004V8.63211L7.22128 7.16658C6.89904 6.90632 6.42684 6.95655 6.16657 7.27879C5.9063 7.60102 5.95654 8.07323 6.27877 8.3335L8.34211 10L6.27877 11.6666C5.95654 11.9269 5.9063 12.3991 6.16657 12.7213C6.42684 13.0435 6.89904 13.0938 7.22128 12.8335L9.03574 11.368V17.25C9.03574 17.5673 9.23536 17.8502 9.53425 17.9566C9.83314 18.063 10.1666 17.9698 10.3671 17.7239L13.8314 13.4739C13.9574 13.3193 14.0167 13.1208 13.996 12.9224C13.9753 12.724 13.8765 12.5419 13.7213 12.4166L10.7294 10L13.7213 7.5835C13.8765 7.45815 13.9753 7.27613 13.996 7.07771C14.0167 6.87929 13.9574 6.68081 13.8314 6.52618L10.3671 2.27618C10.1666 2.03027 9.83314 1.93708 9.53425 2.04346ZM10.5357 11.7718L12.1927 13.1101L10.5357 15.1429V11.7718ZM10.5357 8.22827V4.85719L12.1927 6.88995L10.5357 8.22827Z " },
            { FluentSymbol.Bluetooth20, "M9.32233 2.03266C9.12829 2.10643 9.00002 2.29243 9.00002 2.50002V8.82843L6.80893 7.10686C6.5918 6.93626 6.27747 6.97397 6.10686 7.19111C5.93626 7.40825 5.97397 7.72257 6.19111 7.89318L8.87254 10L6.19111 12.1069C5.97397 12.2775 5.93626 12.5918 6.10686 12.8089C6.27747 13.0261 6.5918 13.0638 6.80893 12.8932L9.00002 11.1716V17.5C9.00002 17.7076 9.12829 17.8936 9.32233 17.9674C9.51637 18.0412 9.73581 17.9874 9.87373 17.8322L13.8737 13.3322C13.9653 13.2292 14.0103 13.0929 13.998 12.9555C13.9858 12.8182 13.9173 12.692 13.8089 12.6069L10.4911 10L13.8089 7.39318C13.9173 7.308 13.9858 7.18183 13.998 7.04451C14.0103 6.90718 13.9653 6.77089 13.8737 6.66784L9.87373 2.16784C9.73581 2.01268 9.51637 1.95889 9.32233 2.03266ZM10 10.8859L12.7733 13.0649L10 16.1849V10.8859ZM10 9.11415V3.81512L12.7733 6.93511L10 9.11415Z " },
            { FluentSymbol.BluetoothConnected24Filled, "M10.0055 9.09768V4.00006C10.0055 3.12768 11.0317 2.69011 11.6607 3.24388L11.7403 3.32178L16.3111 8.27347C16.6715 8.6639 16.66 9.2607 16.3046 9.63724L16.2164 9.72003L13.4827 11.9978L16.2168 14.2782C16.6247 14.6183 16.6909 15.2112 16.3878 15.6307L16.3113 15.7242L11.7405 20.6782C11.1488 21.3194 10.0978 20.945 10.0112 20.1113L10.0055 20.0001V14.8948L9.36532 15.4282C8.94101 15.7818 8.31045 15.7244 7.95693 15.3001C7.63059 14.9084 7.65439 14.341 7.99371 13.978L8.08509 13.8917L10.0055 12.2916V11.702L8.0847 10.1C7.66057 9.74621 7.60351 9.11562 7.95725 8.69149C8.28378 8.29999 8.84621 8.22125 9.26439 8.48969L9.36571 8.56405L10.0055 9.09768V4.00006V9.09768ZM12.0055 13.3701V17.4416L14.1284 15.1407L12.0055 13.3701ZM17 11.0001C17.5523 11.0001 18 11.4478 18 12.0001C18 12.5523 17.5523 13.0001 17 13.0001C16.4477 13.0001 16 12.5523 16 12.0001C16 11.4478 16.4477 11.0001 17 11.0001ZM6 11.0001C6.55228 11.0001 7 11.4478 7 12.0001C7 12.5523 6.55228 13.0001 6 13.0001C5.44772 13.0001 5 12.5523 5 12.0001C5 11.4478 5.44772 11.0001 6 11.0001ZM12.0055 6.55771V10.6252L14.1279 8.85693L12.0055 6.55771Z " },
            { FluentSymbol.BluetoothConnected24, "M10.0043 9.60811V3.75346C10.0043 3.10666 10.7564 2.77855 11.2293 3.17236L11.3054 3.24475L16.017 8.34907C16.2839 8.63814 16.2789 9.07804 16.0223 9.36095L15.946 9.43399L12.8692 11.9976L15.9463 14.564C16.2483 14.8159 16.3006 15.2524 16.0832 15.5663L16.0172 15.6486L11.3055 20.7552C10.8668 21.2306 10.0915 20.9616 10.0111 20.3514L10.0043 20.2466V14.3845L8.88374 15.3181C8.56551 15.5833 8.09259 15.5402 7.82745 15.222C7.58641 14.9327 7.60006 14.5156 7.84363 14.2429L7.92357 14.1657L10.0043 12.4321V11.5614L7.92328 9.82572C7.60518 9.56041 7.56239 9.08747 7.82769 8.76937C8.06888 8.48019 8.48167 8.41854 8.79372 8.60904L8.88404 8.67379L10.0043 9.60811V3.75346V9.60811ZM11.6976 12.9737L11.5043 13.1348V18.3278L14.38 15.2109L11.6976 12.9737ZM17 11C17.5523 11 18 11.4478 18 12C18 12.5523 17.5523 13 17 13C16.4477 13 16 12.5523 16 12C16 11.4478 16.4477 11 17 11ZM6 11C6.55228 11 7 11.4478 7 12C7 12.5523 6.55228 13 6 13C5.44772 13 5 12.5523 5 12C5 11.4478 5.44772 11 6 11ZM11.5043 5.6717V10.8592L11.6981 11.0208L14.3796 8.78667L11.5043 5.6717Z " },
            { FluentSymbol.BluetoothDisabled24Filled, "M3.28034 2.21968C2.98745 1.92678 2.51257 1.92677 2.21968 2.21966C1.92678 2.51255 1.92677 2.98743 2.21966 3.28032L10 11.0608V11.6975L10.0054 11.702V12.2916L8.08501 13.8917C7.6607 14.2452 7.60332 14.8758 7.95684 15.3001C8.31037 15.7244 8.94093 15.7818 9.36524 15.4282L10.0054 14.8948V20.0001C10.0054 20.9105 11.123 21.3473 11.7404 20.6782L15.5204 16.5813L20.7194 21.7805C21.0123 22.0734 21.4872 22.0734 21.7801 21.7805C22.073 21.4876 22.073 21.0127 21.7801 20.7198L3.28034 2.21968ZM12.0054 13.0663L14.1051 15.166L12.0054 17.4416V13.0663Z M16.2163 9.72003L14.4083 11.2265L12.9882 9.80641L14.1278 8.85694L12.0054 6.55772V8.8236L10.0054 6.82356V4.00007C10.0054 3.08976 11.1228 2.65289 11.7403 3.32179L16.311 8.27347C16.6992 8.69394 16.656 9.35375 16.2163 9.72003Z " },
            { FluentSymbol.BluetoothDisabled24, "M3.28034 2.21968C2.98745 1.92678 2.51257 1.92677 2.21968 2.21966C1.92678 2.51255 1.92677 2.98743 2.21966 3.28032L10 11.0608V11.5577L10.0044 11.5614V12.4321L7.92374 14.1657C7.60551 14.4309 7.56247 14.9038 7.82762 15.222C8.09276 15.5403 8.56568 15.5833 8.88391 15.3181L10.0044 14.3845V20.2466C10.0044 20.9295 10.8426 21.2571 11.3057 20.7552L15.3313 16.3922L20.7194 21.7805C21.0123 22.0734 21.4872 22.0734 21.7801 21.7805C22.073 21.4876 22.073 21.0127 21.7801 20.7198L3.28034 2.21968ZM11.5022 12.5631L14.2698 15.3307L11.5044 18.3278V13.1348L11.5022 12.5631Z M15.9462 9.43399L14.1295 10.9477L13.0644 9.88261L14.3798 8.78668L11.5044 5.67171V8.32259L10.0044 6.82256V3.75347C10.0044 3.07074 10.8425 2.74309 11.3055 3.24476L16.0172 8.34907C16.3083 8.66442 16.2759 9.15928 15.9462 9.43399Z " },
            { FluentSymbol.BluetoothSearching24Filled, "M10.0054 9.09768V4.00006C10.0054 3.12768 11.0316 2.69011 11.6606 3.24388L11.7403 3.32178L16.311 8.27347C16.6714 8.6639 16.6599 9.2607 16.3045 9.63724L16.2163 9.72003L13.4826 11.9978L16.2167 14.2782C16.6246 14.6183 16.6908 15.2112 16.3877 15.6307L16.3112 15.7242L11.7404 20.6782C11.1488 21.3194 10.0977 20.945 10.0112 20.1113L10.0054 20.0001V14.8948L9.36524 15.4282C8.94093 15.7818 8.31037 15.7244 7.95684 15.3001C7.63051 14.9084 7.6543 14.341 7.99362 13.978L8.08501 13.8917L10.0054 12.2916V11.702L8.08462 10.1C7.66049 9.74621 7.60343 9.11562 7.95717 8.69149C8.2837 8.29999 8.84613 8.22125 9.26431 8.48969L9.36563 8.56405L10.0054 9.09768V4.00006V9.09768ZM12.0054 13.3701V17.4416L14.1284 15.1407L12.0054 13.3701ZM19.8817 7.23883C20.3021 6.88068 20.9333 6.93116 21.2914 7.35158C22.3872 8.63784 22.9999 10.2704 22.9999 11.995C22.9999 13.7249 22.3833 15.3623 21.2814 16.6502C20.9223 17.0698 20.2911 17.1189 19.8714 16.7599C19.4518 16.4009 19.4027 15.7696 19.7617 15.3499C20.5565 14.421 20.9999 13.2436 20.9999 11.995C20.9999 10.7503 20.5593 9.57628 19.769 8.64854C19.4108 8.22812 19.4613 7.59697 19.8817 7.23883ZM17.6166 9.23883C18.037 8.88068 18.6682 8.93116 19.0263 9.35158C19.6505 10.0843 19.9999 11.0153 19.9999 11.9975C19.9999 12.9828 19.6483 13.9165 19.0206 14.6502C18.6615 15.0698 18.0303 15.1189 17.6106 14.7599C17.191 14.4009 17.1419 13.7696 17.5009 13.3499C17.8215 12.9752 17.9999 12.5015 17.9999 11.9975C17.9999 11.4951 17.8226 11.0228 17.5038 10.6485C17.1457 10.2281 17.1962 9.59697 17.6166 9.23883ZM12.0054 6.55771V10.6252L14.1278 8.85693L12.0054 6.55771Z " },
            { FluentSymbol.BluetoothSearching24, "M10.0044 9.60811V3.75346C10.0044 3.10666 10.7566 2.77855 11.2295 3.17236L11.3055 3.24475L16.0172 8.34907C16.2841 8.63814 16.2791 9.07804 16.0224 9.36095L15.9462 9.43399L12.8693 11.9976L15.9465 14.564C16.2485 14.8159 16.3008 15.2524 16.0833 15.5663L16.0173 15.6486L11.3057 20.7552C10.867 21.2306 10.0916 20.9616 10.0112 20.3514L10.0044 20.2466V14.3845L8.88391 15.3181C8.56568 15.5833 8.09276 15.5402 7.82762 15.222C7.58658 14.9327 7.60023 14.5156 7.8438 14.2429L7.92374 14.1657L10.0044 12.4321V11.5614L7.92345 9.82572C7.60535 9.56041 7.56256 9.08747 7.82786 8.76937C8.06905 8.48019 8.48184 8.41854 8.79389 8.60904L8.88421 8.67379L10.0044 9.60811V3.75346V9.60811ZM11.6978 12.9737L11.5044 13.1348V18.3278L14.3802 15.2109L11.6978 12.9737ZM19.2701 7.37157C19.5854 7.10296 20.0588 7.14082 20.3274 7.45614C21.3985 8.71351 21.9973 10.309 21.9973 11.9949C21.9973 13.6861 21.3947 15.2862 20.3176 16.5452C20.0483 16.8599 19.5748 16.8968 19.2601 16.6275C18.9454 16.3582 18.9085 15.8848 19.1778 15.57C20.0246 14.5802 20.4973 13.3251 20.4973 11.9949C20.4973 10.6689 20.0276 9.41733 19.1855 8.42885C18.9169 8.11354 18.9548 7.64018 19.2701 7.37157ZM17.2754 9.18481C17.5907 8.9162 18.0641 8.95406 18.3327 9.26937C18.9763 10.0249 19.3364 10.9843 19.3364 11.9972C19.3364 13.0133 18.9741 13.9754 18.3268 14.732C18.0575 15.0467 17.5841 15.0835 17.2693 14.8142C16.9546 14.545 16.9177 14.0715 17.187 13.7568C17.604 13.2695 17.8364 12.6523 17.8364 11.9972C17.8364 11.3442 17.6054 10.7288 17.1908 10.2421C16.9222 9.92678 16.9601 9.45342 17.2754 9.18481ZM11.5044 5.6717V10.8592L11.6983 11.0208L14.3798 8.78667L11.5044 5.6717Z " },
            { FluentSymbol.Blur16Filled, "M8 2C4.68629 2 2 4.68629 2 8C2 11.3137 4.68629 14 8 14C9.777 14 11.3736 13.2275 12.4722 12H8V11H13.1973C13.3802 10.6838 13.5351 10.3493 13.6586 10H8V9H13.917C13.9716 8.67479 14 8.34071 14 8H8V7H13.917C13.8593 6.65585 13.7723 6.32163 13.6586 6H8V5H13.1973C12.99 4.64158 12.7466 4.3066 12.4722 4H8V3H11.3178C10.3675 2.36815 9.22674 2 8 2Z " },
            { FluentSymbol.Blur16, "M8 2C4.68629 2 2 4.68629 2 8C2 11.3137 4.68629 14 8 14C9.777 14 11.3736 13.2275 12.4722 12H8V13C5.23858 13 3 10.7614 3 8C3 5.23858 5.23858 3 8 3H11.3178C10.3675 2.36815 9.22674 2 8 2Z M8 4H12.4722C12.7466 4.3066 12.99 4.64158 13.1973 5H8V4Z M13.6586 6H8V7H13.917C13.8593 6.65585 13.7723 6.32163 13.6586 6Z M8 8H14C14 8.34071 13.9716 8.67479 13.917 9H8V8Z M13.6586 10H8V11H13.1973C13.3802 10.6838 13.5351 10.3493 13.6586 10Z " },
            { FluentSymbol.Blur20Filled, "M10 2C5.58172 2 2 5.58172 2 10C2 14.4183 5.58172 18 10 18C12.0289 18 13.8814 17.2447 15.2916 16H10V15H16.2454C16.4977 14.6853 16.7267 14.3511 16.9297 14H10V13H17.4185C17.5494 12.6766 17.6597 12.3428 17.748 12H10V11H17.9381C17.979 10.6724 18 10.3387 18 10H10V9H17.9381C17.8957 8.65956 17.8318 8.32577 17.748 8H10V7H17.4185C17.2784 6.65398 17.1148 6.31998 16.9297 6H10V5H16.2454C15.9567 4.63985 15.6375 4.30521 15.2916 4H10V3H13.876C12.7278 2.36284 11.4063 2 10 2Z " },
            { FluentSymbol.Blur20, "M10 2C5.58172 2 2 5.58172 2 10C2 14.4183 5.58172 18 10 18C12.0289 18 13.8814 17.2447 15.2916 16H10V17C6.13401 17 3 13.866 3 10C3 6.13401 6.13401 3 10 3H13.876C12.7278 2.36284 11.4063 2 10 2Z M10 4H15.2916C15.6375 4.30521 15.9567 4.63985 16.2454 5H10V4Z M16.9297 6H10V7H17.4185C17.2784 6.65398 17.1148 6.31998 16.9297 6Z M10 8H17.748C17.8318 8.32577 17.8957 8.65956 17.9381 9H10V8Z M18 10H10V11H17.9381C17.979 10.6724 18 10.3387 18 10Z M10 12H17.748C17.6597 12.3428 17.5494 12.6766 17.4185 13H10V12Z M16.9297 14H10V15H16.2454C16.4977 14.6853 16.7267 14.3511 16.9297 14Z " },
            { FluentSymbol.Blur24Filled, "M3 12C3 7.02944 7.02944 3 12 3C13.8401 3 15.5512 3.55223 16.9767 4.5H12V5.5H18.225C18.6969 5.95205 19.1196 6.45499 19.4845 7H12V8H20.0645C20.3018 8.47748 20.4979 8.97903 20.6482 9.5H12V10.5H20.8756C20.9574 10.9878 21 11.4889 21 12H12V13H20.9451C20.8882 13.5143 20.788 14.0155 20.6482 14.5H12V15.5H20.2941C20.0712 16.0276 19.7994 16.5295 19.4845 17H12V18H18.7083C17.0604 19.8412 14.6655 21 12 21C7.02944 21 3 16.9706 3 12Z " },
            { FluentSymbol.Blur24, "M3 12C3 7.02944 7.02944 3 12 3C13.8401 3 15.5512 3.55223 16.9767 4.5H12C7.85786 4.5 4.5 7.85786 4.5 12C4.5 16.1421 7.85786 19.5 12 19.5V18H18.7083C17.0604 19.8412 14.6655 21 12 21C7.02944 21 3 16.9706 3 12Z M18.225 5.5H12V7H19.4845C19.1196 6.45499 18.6969 5.95205 18.225 5.5Z M12 8H20.0645C20.3018 8.47748 20.4979 8.97903 20.6482 9.5H12V8Z M20.8756 10.5H12V12H21C21 11.4889 20.9574 10.9878 20.8756 10.5Z M12 13H20.9451C20.8882 13.5143 20.788 14.0155 20.6482 14.5H12V13Z M20.2941 15.5H12V17H19.4845C19.7994 16.5295 20.0712 16.0276 20.2941 15.5Z " },
            { FluentSymbol.Blur28Filled, "M3 14C3 7.92487 7.92487 3 14 3C16.0238 3 17.9199 3.54651 19.5488 4.5H14V5.5H20.9826C21.5305 5.95058 22.034 6.45309 22.4857 7H14V8H23.2211C23.5313 8.47578 23.8057 8.97706 24.0404 9.5H14V10.5H24.4315C24.5944 10.9858 24.7243 11.4866 24.8186 12H14V13H24.9552C24.9848 13.3294 25 13.6629 25 14C25 14.1676 24.9963 14.3343 24.9888 14.5H14V15.5H24.8986C24.8288 16.0121 24.7237 16.5129 24.5859 17H14V18H24.2501C24.0469 18.5204 23.8051 19.0216 23.5284 19.5H14V20.5H22.875C22.4792 21.0395 22.0354 21.5416 21.5499 22H14V23H20.3262C18.5368 24.2601 16.3548 25 14 25C7.92487 25 3 20.0751 3 14Z " },
            { FluentSymbol.Blur28, "M3 14C3 7.92487 7.92487 3 14 3C16.0238 3 17.9199 3.54651 19.5488 4.5H14C8.75329 4.5 4.5 8.75329 4.5 14C4.5 19.2467 8.75329 23.5 14 23.5V23H20.3262C18.5368 24.2601 16.3548 25 14 25C7.92487 25 3 20.0751 3 14Z M20.9826 5.5C21.5305 5.95058 22.034 6.45309 22.4857 7H14V5.5H20.9826Z M24.0404 9.5C23.8057 8.97706 23.5313 8.47578 23.2211 8H14V9.5H24.0404Z M24.4315 10.5C24.5944 10.9858 24.7243 11.4866 24.8186 12H14V10.5H24.4315Z M25 14C25 13.6629 24.9848 13.3294 24.9552 13H14V14.5H24.9888C24.9963 14.3343 25 14.1676 25 14Z M24.8986 15.5C24.8288 16.0121 24.7237 16.5129 24.5859 17H14V15.5H24.8986Z M23.5284 19.5C23.8051 19.0216 24.0469 18.5204 24.2501 18H14V19.5H23.5284Z M22.875 20.5C22.4792 21.0395 22.0354 21.5416 21.5499 22H14V20.5H22.875Z " },
            { FluentSymbol.Board16Filled, "M7.5 2V5H2V4.5C2 3.11929 3.11929 2 4.5 2H7.5ZM8.5 2V10H14V4.5C14 3.11929 12.8807 2 11.5 2H8.5ZM14 11H8.5V14H11.5C12.8807 14 14 12.8807 14 11.5V11ZM7.5 14V6H2V11.5C2 12.8807 3.11929 14 4.5 14H7.5Z " },
            { FluentSymbol.Board16, "M2 4.5C2 3.11929 3.11929 2 4.5 2H11.5C12.8807 2 14 3.11929 14 4.5V11.5C14 12.8807 12.8807 14 11.5 14H4.5C3.11929 14 2 12.8807 2 11.5V4.5ZM4.5 3C3.67157 3 3 3.67157 3 4.5V5H7.5V3H4.5ZM8.5 3V10H13V4.5C13 3.67157 12.3284 3 11.5 3H8.5ZM13 11H8.5V13H11.5C12.3284 13 13 12.3284 13 11.5V11ZM7.5 13V6H3V11.5C3 12.3284 3.67157 13 4.5 13H7.5Z " },
            { FluentSymbol.Board20Filled, "M9.5 3V7H3V6C3 4.34315 4.34315 3 6 3H9.5ZM10.5 3V12H17V6C17 4.34315 15.6569 3 14 3H10.5ZM17 13H10.5V17H14C15.6569 17 17 15.6569 17 14V13ZM9.5 17V8H3V14C3 15.6569 4.34315 17 6 17H9.5Z " },
            { FluentSymbol.Board20, "M3 6C3 4.34315 4.34315 3 6 3H14C15.6569 3 17 4.34315 17 6V14C17 15.6569 15.6569 17 14 17H6C4.34315 17 3 15.6569 3 14V6ZM6 4C4.89543 4 4 4.89543 4 6V7.05767L9.5 7.00478V4H6ZM10.5 4V12H16V6C16 4.89543 15.1046 4 14 4H10.5ZM16 13H10.5V16H14C15.1046 16 16 15.1046 16 14V13ZM9.5 16V8.00483L4 8.05772V14C4 15.1046 4.89543 16 6 16H9.5Z " },
            { FluentSymbol.Board24Filled, "M11.499 9.49905L11.5 21.001L6.25006 21.0017C4.51701 21.0017 3.10076 19.6454 3.00514 17.9362L3 17.7518V9.49905H11.499ZM12.999 15.499H21.5L21.5008 17.7518C21.5006 19.5466 20.0456 21.0017 18.2507 21.0017L13 21.001L12.999 15.499ZM18.2514 2.49805C19.9844 2.49805 21.4007 3.8544 21.4963 5.56354L21.5014 5.74797L21.5 13.999H12.999L13 2.49805H18.2514ZM11.5 2.49805L11.499 7.99905H3L3.0006 5.74799C3.00081 3.95316 4.45582 2.49805 6.25065 2.49805H11.5Z " },
            { FluentSymbol.Board24, "M18.2514 2.49805C19.9844 2.49805 21.4007 3.85437 21.4963 5.56352L21.5014 5.74794L21.5008 17.7518C21.5006 19.5466 20.0456 21.0017 18.2507 21.0017H6.25006C4.51701 21.0017 3.10076 19.6454 3.00514 17.9362L3 17.7518L3.0006 5.74796C3.00081 3.95313 4.45582 2.49805 6.25065 2.49805H18.2514ZM11.5 9.49805L4.5 9.49905L4.5001 17.7517L4.50728 17.9124C4.58839 18.8036 5.33765 19.5017 6.25 19.5017L11.5 19.501V9.49805ZM20 15.498L13 15.499V19.501L18.2506 19.5017C19.2172 19.5017 20.0007 18.7181 20.0008 17.7516L20 15.498ZM18.2514 3.99805L13 3.99705V13.999L20 13.998L20.0013 5.74802L19.9941 5.58729C19.913 4.69609 19.1638 3.99805 18.2514 3.99805ZM11.5 3.99705L6.25073 3.99805L6.10723 4.00386C5.20785 4.07693 4.50071 4.82994 4.5006 5.74808L4.5 7.99905L11.5 7.99805V3.99705Z " },
            { FluentSymbol.Board28Filled, "M13.5 3V9.5H3V6.75C3 4.67893 4.67893 3 6.75 3H13.5ZM15 3V16.5H25V6.75C25 4.67893 23.3211 3 21.25 3H15ZM25 18H15V25H21.25C23.3211 25 25 23.3211 25 21.25V18ZM13.5 25V11H3V21.25C3 23.3211 4.67893 25 6.75 25H13.5Z " },
            { FluentSymbol.Board28, "M6.75 3C4.67893 3 3 4.67893 3 6.75V21.25C3 23.3211 4.67893 25 6.75 25H21.25C23.3211 25 25 23.3211 25 21.25V6.75C25 4.67893 23.3211 3 21.25 3H6.75ZM4.5 6.75C4.5 5.50736 5.50736 4.5 6.75 4.5H13.5V9.5H4.5V6.75ZM4.5 11H13.5V23.5H6.75C5.50736 23.5 4.5 22.4926 4.5 21.25V11ZM15 23.5V18H23.5V21.25C23.5 22.4926 22.4926 23.5 21.25 23.5H15ZM23.5 16.5H15V4.5H21.25C22.4926 4.5 23.5 5.50736 23.5 6.75V16.5Z " },
            { FluentSymbol.Book20Filled, "M6 2C4.89543 2 4 2.89543 4 4V16C4 17.1046 4.89543 18 6 18H15.5C15.7761 18 16 17.7761 16 17.5C16 17.2239 15.7761 17 15.5 17H6C5.44772 17 5 16.5523 5 16H15C15.5523 16 16 15.5523 16 15V4C16 2.89543 15.1046 2 14 2H6ZM6.75 4.5H13.25C13.6642 4.5 14 4.83579 14 5.25C14 5.66421 13.6642 6 13.25 6H6.75C6.33579 6 6 5.66421 6 5.25C6 4.83579 6.33579 4.5 6.75 4.5Z " },
            { FluentSymbol.Book20, "M6 5C6 4.44772 6.44772 4 7 4H13C13.5523 4 14 4.44772 14 5V6C14 6.55228 13.5523 7 13 7H7C6.44772 7 6 6.55228 6 6V5ZM7 5V6H13V5H7Z M4 4V16C4 17.1046 4.89543 18 6 18H15.5C15.7761 18 16 17.7761 16 17.5C16 17.2239 15.7761 17 15.5 17H6C5.44772 17 5 16.5523 5 16H15C15.5523 16 16 15.5523 16 15V4C16 2.89543 15.1046 2 14 2H6C4.89543 2 4 2.89543 4 4ZM14 3C14.5523 3 15 3.44772 15 4V15H5V4C5 3.44772 5.44772 3 6 3H14Z " },
            { FluentSymbol.Book24Filled, "M6.5 2C5.11929 2 4 3.11929 4 4.5V19.5C4 20.8807 5.11929 22 6.5 22H19.75C20.1642 22 20.5 21.6642 20.5 21.25C20.5 20.8358 20.1642 20.5 19.75 20.5H6.5C5.94772 20.5 5.5 20.0523 5.5 19.5H19.75C20.1642 19.5 20.5 19.1642 20.5 18.75V4.5C20.5 3.11929 19.3807 2 18 2H6.5ZM8 5H16C16.5523 5 17 5.44772 17 6V7C17 7.55228 16.5523 8 16 8H8C7.44772 8 7 7.55228 7 7V6C7 5.44772 7.44772 5 8 5Z " },
            { FluentSymbol.Book24, "M7 6C7 5.44772 7.44772 5 8 5H16C16.5523 5 17 5.44772 17 6V8C17 8.55228 16.5523 9 16 9H8C7.44772 9 7 8.55228 7 8V6ZM8.5 7.5H15.5V6.5H8.5V7.5Z M4 4.5C4 3.11929 5.11929 2 6.5 2H18C19.3807 2 20.5 3.11929 20.5 4.5V18.75C20.5 19.1642 20.1642 19.5 19.75 19.5H5.5C5.5 20.0523 5.94772 20.5 6.5 20.5H19.75C20.1642 20.5 20.5 20.8358 20.5 21.25C20.5 21.6642 20.1642 22 19.75 22H6.5C5.11929 22 4 20.8807 4 19.5V4.5ZM5.5 18H19V4.5C19 3.94772 18.5523 3.5 18 3.5H6.5C5.94772 3.5 5.5 3.94772 5.5 4.5V18Z " },
            { FluentSymbol.BookAdd20Filled, "M6 2C4.89543 2 4 2.89543 4 4V16C4 17.1046 4.89543 18 6 18H10.2572C10.0035 17.6929 9.78261 17.3578 9.59971 17H6C5.44772 17 5 16.5523 5 16H9.20703C9.07217 15.5232 9 15.02 9 14.5C9 11.4624 11.4624 9 14.5 9C15.02 9 15.5232 9.07217 16 9.20703V4C16 2.89543 15.1046 2 14 2H6ZM6.75 4.5H13.25C13.6642 4.5 14 4.83579 14 5.25C14 5.66421 13.6642 6 13.25 6H6.75C6.33579 6 6 5.66421 6 5.25C6 4.83579 6.33579 4.5 6.75 4.5ZM19 14.5C19 16.9853 16.9853 19 14.5 19C12.0147 19 10 16.9853 10 14.5C10 12.0147 12.0147 10 14.5 10C16.9853 10 19 12.0147 19 14.5ZM15 12.5C15 12.2239 14.7761 12 14.5 12C14.2239 12 14 12.2239 14 12.5V14H12.5C12.2239 14 12 14.2239 12 14.5C12 14.7761 12.2239 15 12.5 15H14V16.5C14 16.7761 14.2239 17 14.5 17C14.7761 17 15 16.7761 15 16.5V15H16.5C16.7761 15 17 14.7761 17 14.5C17 14.2239 16.7761 14 16.5 14H15V12.5Z " },
            { FluentSymbol.BookAdd20, "M14 3H6C5.44772 3 5 3.44772 5 4V15H9.02242C9.05337 15.3434 9.11588 15.6777 9.20703 16H5C5 16.5523 5.44772 17 6 17H9.59971C9.78261 17.3578 10.0035 17.6929 10.2572 18H6C4.89543 18 4 17.1046 4 16V4C4 2.89543 4.89543 2 6 2H14C15.1046 2 16 2.89543 16 4V9.20703C15.6777 9.11588 15.3434 9.05337 15 9.02242V4C15 3.44772 14.5523 3 14 3ZM6 5V6C6 6.55228 6.44772 7 7 7H13C13.5523 7 14 6.55228 14 6V5C14 4.44772 13.5523 4 13 4H7C6.44772 4 6 4.44772 6 5ZM7 5H13V6H7V5ZM19 14.5C19 16.9853 16.9853 19 14.5 19C12.0147 19 10 16.9853 10 14.5C10 12.0147 12.0147 10 14.5 10C16.9853 10 19 12.0147 19 14.5ZM15 12.5C15 12.2239 14.7761 12 14.5 12C14.2239 12 14 12.2239 14 12.5V14H12.5C12.2239 14 12 14.2239 12 14.5C12 14.7761 12.2239 15 12.5 15H14V16.5C14 16.7761 14.2239 17 14.5 17C14.7761 17 15 16.7761 15 16.5V15H16.5C16.7761 15 17 14.7761 17 14.5C17 14.2239 16.7761 14 16.5 14H15V12.5Z " },
            { FluentSymbol.BookAdd24Filled, "M5.5 2C4.11929 2 3 3.11929 3 4.5V19.5C3 20.8807 4.11929 22 5.5 22H12.8096C12.3832 21.5557 12.0194 21.051 11.7322 20.5H5.5C4.94772 20.5 4.5 20.0523 4.5 19.5H11.3135C11.11 18.8699 11 18.1978 11 17.5C11 13.9101 13.9101 11 17.5 11C18.1978 11 18.8699 11.11 19.5 11.3135V4.5C19.5 3.11929 18.3807 2 17 2H5.5ZM7 5H15C15.5523 5 16 5.44772 16 6V7C16 7.55228 15.5523 8 15 8H7C6.44772 8 6 7.55228 6 7V6C6 5.44772 6.44772 5 7 5ZM23 17.5C23 14.4624 20.5376 12 17.5 12C14.4624 12 12 14.4624 12 17.5C12 20.5376 14.4624 23 17.5 23C20.5376 23 23 20.5376 23 17.5ZM18.0006 18L18.0011 20.5035C18.0011 20.7797 17.7773 21.0035 17.5011 21.0035C17.225 21.0035 17.0011 20.7797 17.0011 20.5035L17.0006 18H14.4961C14.22 18 13.9961 17.7762 13.9961 17.5C13.9961 17.2239 14.22 17 14.4961 17H17.0005L17 14.4993C17 14.2231 17.2239 13.9993 17.5 13.9993C17.7761 13.9993 18 14.2231 18 14.4993L18.0005 17H20.503C20.7792 17 21.003 17.2239 21.003 17.5C21.003 17.7762 20.7792 18 20.503 18H18.0006Z " },
            { FluentSymbol.BookAdd24, "M3 4.5C3 3.11929 4.11929 2 5.5 2H17C18.3807 2 19.5 3.11929 19.5 4.5V11.3135C19.0218 11.159 18.5195 11.0585 18 11.0189V4.5C18 3.94772 17.5523 3.5 17 3.5H5.5C4.94772 3.5 4.5 3.94772 4.5 4.5V18H11.0189C11.0585 18.5195 11.159 19.0218 11.3135 19.5H4.5C4.5 20.0523 4.94772 20.5 5.5 20.5H11.7322C12.0194 21.051 12.3832 21.5557 12.8096 22H5.5C4.11929 22 3 20.8807 3 19.5V4.5ZM17.5 12C20.5376 12 23 14.4624 23 17.5C23 20.5376 20.5376 23 17.5 23C14.4624 23 12 20.5376 12 17.5C12 14.4624 14.4624 12 17.5 12ZM18.0011 20.5035L18.0006 18H20.503C20.7792 18 21.003 17.7762 21.003 17.5C21.003 17.2239 20.7792 17 20.503 17H18.0005L18 14.4993C18 14.2231 17.7761 13.9993 17.5 13.9993C17.2239 13.9993 17 14.2231 17 14.4993L17.0005 17H14.4961C14.22 17 13.9961 17.2239 13.9961 17.5C13.9961 17.7762 14.22 18 14.4961 18H17.0006L17.0011 20.5035C17.0011 20.7797 17.225 21.0035 17.5011 21.0035C17.7773 21.0035 18.0011 20.7797 18.0011 20.5035ZM6 6C6 5.44772 6.44772 5 7 5H15C15.5523 5 16 5.44772 16 6V8C16 8.55228 15.5523 9 15 9H7C6.44772 9 6 8.55228 6 8V6ZM7.5 7.5H14.5V6.5H7.5V7.5Z " },
            { FluentSymbol.BookClock24Filled, "M11.75 11.375C11.75 11.7202 12.0298 12 12.375 12C12.3961 12 12.4169 11.999 12.4375 11.9969C12.4581 11.999 12.4789 12 12.5 12H13.75C14.0952 12 14.375 11.7202 14.375 11.375C14.375 11.0298 14.0952 10.75 13.75 10.75H13V9.125C13 8.77982 12.7202 8.5 12.375 8.5C12.0298 8.5 11.75 8.77982 11.75 9.125V11.375Z M4 4.5C4 3.11929 5.11929 2 6.5 2H18C19.3807 2 20.5 3.11929 20.5 4.5V18.75C20.5 19.1642 20.1642 19.5 19.75 19.5H5.5C5.5 20.0523 5.94772 20.5 6.5 20.5H19.75C20.1642 20.5 20.5 20.8358 20.5 21.25C20.5 21.6642 20.1642 22 19.75 22H6.5C5.11929 22 4 20.8807 4 19.5V4.5ZM12.375 6.00488C9.75165 6.00488 7.625 8.13153 7.625 10.7549C7.625 13.3782 9.75165 15.5049 12.375 15.5049C14.9984 15.5049 17.125 13.3782 17.125 10.7549C17.125 8.13153 14.9984 6.00488 12.375 6.00488Z " },
            { FluentSymbol.BookClock24, "M13 9.125V10.75H13.75C14.0952 10.75 14.375 11.0298 14.375 11.375C14.375 11.7202 14.0952 12 13.75 12H12.5C12.4789 12 12.4581 11.999 12.4375 11.9969C12.4169 11.999 12.3961 12 12.375 12C12.0298 12 11.75 11.7202 11.75 11.375V9.125C11.75 8.77982 12.0298 8.5 12.375 8.5C12.7202 8.5 13 8.77982 13 9.125Z M12.375 6.00488C9.75165 6.00488 7.625 8.13153 7.625 10.7549C7.625 13.3782 9.75165 15.5049 12.375 15.5049C14.9984 15.5049 17.125 13.3782 17.125 10.7549C17.125 8.13153 14.9984 6.00488 12.375 6.00488ZM8.875 10.7549C8.875 8.82189 10.442 7.25488 12.375 7.25488C14.308 7.25488 15.875 8.82189 15.875 10.7549C15.875 12.6879 14.308 14.2549 12.375 14.2549C10.442 14.2549 8.875 12.6879 8.875 10.7549Z M6.5 2C5.11929 2 4 3.11929 4 4.5V19.5C4 20.8807 5.11929 22 6.5 22H19.75C20.1642 22 20.5 21.6642 20.5 21.25C20.5 20.8358 20.1642 20.5 19.75 20.5H6.5C5.94772 20.5 5.5 20.0523 5.5 19.5H19.75C20.1642 19.5 20.5 19.1642 20.5 18.75V4.5C20.5 3.11929 19.3807 2 18 2H6.5ZM19 18H5.5V4.5C5.5 3.94772 5.94772 3.5 6.5 3.5H18C18.5523 3.5 19 3.94772 19 4.5V18Z " },
            { FluentSymbol.BookCoins24Filled, "M4 4.5C4 3.11929 5.11929 2 6.5 2H18C19.3807 2 20.5 3.11929 20.5 4.5V18.75C20.5 19.1642 20.1642 19.5 19.75 19.5H5.5C5.5 20.0523 5.94772 20.5 6.5 20.5H19.75C20.1642 20.5 20.5 20.8358 20.5 21.25C20.5 21.6642 20.1642 22 19.75 22H6.5C5.11929 22 4 20.8807 4 19.5V4.5ZM10.1974 7.46389C9.62154 7.73931 9 8.24137 9 9C9 9.75863 9.62154 10.2607 10.1974 10.5361C10.819 10.8334 11.6338 11 12.5 11C13.3662 11 14.181 10.8334 14.8026 10.5361C15.3785 10.2607 16 9.75863 16 9C16 8.24137 15.3785 7.73931 14.8026 7.46389C14.181 7.1666 13.3662 7 12.5 7C11.6338 7 10.819 7.1666 10.1974 7.46389ZM15.9948 10.8901C15.1697 11.5673 13.9107 12.0001 12.5 12.0001C11.0893 12.0001 9.83029 11.5673 9.00522 10.8901C9.00175 10.9266 9 10.9633 9 11.0003C9 12.1048 10.567 13.0003 12.5 13.0003C14.433 13.0003 16 12.1048 16 11.0003C16 10.9633 15.9982 10.9266 15.9948 10.8901ZM12.5 14.0001C11.0893 14.0001 9.83027 13.5673 9.0052 12.8901C9.00175 12.9265 9 12.9632 9 13.0001C9 14.1047 10.567 15.0001 12.5 15.0001C14.433 15.0001 16 14.1047 16 13.0001C16 12.9632 15.9983 12.9265 15.9948 12.8901C15.1697 13.5673 13.9107 14.0001 12.5 14.0001Z " },
            { FluentSymbol.BookCoins24, "M10.1974 7.46389C10.819 7.1666 11.6338 7 12.5 7C13.3662 7 14.181 7.1666 14.8026 7.46389C15.3785 7.73931 16 8.24137 16 9C16 9.75863 15.3785 10.2607 14.8026 10.5361C14.181 10.8334 13.3662 11 12.5 11C11.6338 11 10.819 10.8334 10.1974 10.5361C9.62154 10.2607 9 9.75863 9 9C9 8.24137 9.62154 7.73931 10.1974 7.46389ZM10.7367 8.59156C10.272 8.8138 10.25 9 10.25 9C10.25 9 10.272 9.1862 10.7367 9.40844C11.1557 9.6088 11.7783 9.75 12.5 9.75C13.2217 9.75 13.8443 9.6088 14.2633 9.40844C14.728 9.1862 14.75 9 14.75 9C14.75 9 14.728 8.8138 14.2633 8.59156C13.8443 8.3912 13.2217 8.25 12.5 8.25C11.7783 8.25 11.1557 8.3912 10.7367 8.59156Z M12.5 12.0001C13.9107 12.0001 15.1697 11.5673 15.9948 10.8901C15.9982 10.9266 16 10.9633 16 11.0003C16 12.1048 14.433 13.0003 12.5 13.0003C10.567 13.0003 9 12.1048 9 11.0003C9 10.9633 9.00175 10.9266 9.00522 10.8901C9.83029 11.5673 11.0893 12.0001 12.5 12.0001Z M12.5 14.0001C13.9107 14.0001 15.1697 13.5673 15.9948 12.8901C15.9983 12.9265 16 12.9632 16 13.0001C16 14.1047 14.433 15.0001 12.5 15.0001C10.567 15.0001 9 14.1047 9 13.0001C9 12.9632 9.00175 12.9265 9.0052 12.8901C9.83027 13.5673 11.0893 14.0001 12.5 14.0001Z M6.5 2C5.11929 2 4 3.11929 4 4.5V19.5C4 20.8807 5.11929 22 6.5 22H19.75C20.1642 22 20.5 21.6642 20.5 21.25C20.5 20.8358 20.1642 20.5 19.75 20.5H6.5C5.94772 20.5 5.5 20.0523 5.5 19.5H19.75C20.1642 19.5 20.5 19.1642 20.5 18.75V4.5C20.5 3.11929 19.3807 2 18 2H6.5ZM19 18H5.5V4.5C5.5 3.94772 5.94772 3.5 6.5 3.5H18C18.5523 3.5 19 3.94772 19 4.5V18Z " },
            { FluentSymbol.BookCompass24Filled, "M11 10C11 9.30964 11.5597 8.75 12.25 8.75C12.9404 8.75 13.5 9.30964 13.5 10C13.5 10.6904 12.9404 11.25 12.25 11.25C11.5597 11.25 11 10.6904 11 10Z M4 4.5C4 3.11929 5.11929 2 6.5 2H18C19.3807 2 20.5 3.11929 20.5 4.5V18.75C20.5 19.1642 20.1642 19.5 19.75 19.5H5.5C5.5 20.0523 5.94772 20.5 6.5 20.5H19.75C20.1642 20.5 20.5 20.8358 20.5 21.25C20.5 21.6642 20.1642 22 19.75 22H6.5C5.11929 22 4 20.8807 4 19.5V4.5ZM13 5.75C13 5.33579 12.6642 5 12.25 5C11.8358 5 11.5 5.33579 11.5 5.75V7.35352C10.3458 7.67998 9.50002 8.74122 9.50002 10C9.50002 10.7807 9.82535 11.4854 10.3478 11.986L9.05366 15.2215C8.89982 15.606 9.08689 16.0425 9.47147 16.1964C9.85606 16.3502 10.2925 16.1631 10.4464 15.7785L11.6813 12.6911C11.8648 12.7297 12.0551 12.75 12.25 12.75C12.445 12.75 12.6352 12.7297 12.8187 12.6911L14.0537 15.7785C14.2075 16.1631 14.644 16.3502 15.0286 16.1964C15.4131 16.0425 15.6002 15.606 15.4464 15.2215L14.1522 11.986C14.6747 11.4854 15 10.7807 15 10C15 8.74122 14.1543 7.67998 13 7.35352V5.75Z " },
            { FluentSymbol.BookCompass24, "M13 5.75C13 5.33579 12.6642 5 12.25 5C11.8358 5 11.5 5.33579 11.5 5.75V7.35352C10.3458 7.67998 9.50002 8.74122 9.50002 10C9.50002 10.7807 9.82535 11.4854 10.3478 11.986L9.05366 15.2215C8.89982 15.606 9.08689 16.0425 9.47147 16.1964C9.85606 16.3502 10.2925 16.1631 10.4464 15.7785L11.6813 12.6911C11.8648 12.7297 12.0551 12.75 12.25 12.75C12.445 12.75 12.6352 12.7297 12.8187 12.6911L14.0537 15.7785C14.2075 16.1631 14.644 16.3502 15.0286 16.1964C15.4131 16.0425 15.6002 15.606 15.4464 15.2215L14.1522 11.986C14.6747 11.4854 15 10.7807 15 10C15 8.74122 14.1543 7.67998 13 7.35352V5.75ZM11 10C11 9.30964 11.5597 8.75 12.25 8.75C12.9404 8.75 13.5 9.30964 13.5 10C13.5 10.6904 12.9404 11.25 12.25 11.25C11.5597 11.25 11 10.6904 11 10Z M6.5 2C5.11929 2 4 3.11929 4 4.5V19.5C4 20.8807 5.11929 22 6.5 22H19.75C20.1642 22 20.5 21.6642 20.5 21.25C20.5 20.8358 20.1642 20.5 19.75 20.5H6.5C5.94772 20.5 5.5 20.0523 5.5 19.5H19.75C20.1642 19.5 20.5 19.1642 20.5 18.75V4.5C20.5 3.11929 19.3807 2 18 2H6.5ZM19 18H5.5V4.5C5.5 3.94772 5.94772 3.5 6.5 3.5H18C18.5523 3.5 19 3.94772 19 4.5V18Z " },
            { FluentSymbol.BookDatabase24Filled, "M10.5575 8.42292C10.068 8.68646 10 8.92486 10 9C10 9.07514 10.068 9.31354 10.5575 9.57708C11.0164 9.82418 11.7018 10 12.5 10C13.2982 10 13.9836 9.82418 14.4425 9.57708C14.932 9.31354 15 9.07514 15 9C15 8.92486 14.932 8.68646 14.4425 8.42292C13.9836 8.17582 13.2982 8 12.5 8C11.7018 8 11.0164 8.17582 10.5575 8.42292Z M15 13V10.9763C14.3046 11.3132 13.427 11.5 12.5 11.5C11.573 11.5 10.6954 11.3132 10 10.9763V13C10 13.0751 10.068 13.3135 10.5575 13.5771C11.0164 13.8242 11.7018 14 12.5 14C13.2982 14 13.9836 13.8242 14.4425 13.5771C14.932 13.3135 15 13.0751 15 13Z M4 4.5C4 3.11929 5.11929 2 6.5 2H18C19.3807 2 20.5 3.11929 20.5 4.5V18.75C20.5 19.1642 20.1642 19.5 19.75 19.5H5.5C5.5 20.0523 5.94772 20.5 6.5 20.5H19.75C20.1642 20.5 20.5 20.8358 20.5 21.25C20.5 21.6642 20.1642 22 19.75 22H6.5C5.11929 22 4 20.8807 4 19.5V4.5ZM9.84633 7.10221C9.1595 7.47204 8.5 8.10864 8.5 9V13C8.5 13.8914 9.1595 14.528 9.84633 14.8978C10.5637 15.2841 11.5033 15.5 12.5 15.5C13.4967 15.5 14.4363 15.2841 15.1537 14.8978C15.8405 14.528 16.5 13.8914 16.5 13V9C16.5 8.10864 15.8405 7.47204 15.1537 7.10221C14.4363 6.71593 13.4967 6.5 12.5 6.5C11.5033 6.5 10.5637 6.71593 9.84633 7.10221Z " },
            { FluentSymbol.BookDatabase24, "M16.5 9V13C16.5 13.8914 15.8405 14.528 15.1537 14.8978C14.4363 15.2841 13.4967 15.5 12.5 15.5C11.5033 15.5 10.5637 15.2841 9.84633 14.8978C9.1595 14.528 8.5 13.8914 8.5 13V9C8.5 8.10864 9.1595 7.47204 9.84633 7.10221C10.5637 6.71593 11.5033 6.5 12.5 6.5C13.4967 6.5 14.4363 6.71593 15.1537 7.10221C15.8405 7.47204 16.5 8.10864 16.5 9ZM10.5575 8.42292C10.068 8.68646 10 8.92486 10 9C10 9.07514 10.068 9.31354 10.5575 9.57708C11.0164 9.82418 11.7018 10 12.5 10C13.2982 10 13.9836 9.82418 14.4425 9.57708C14.932 9.31354 15 9.07514 15 9C15 8.92486 14.932 8.68646 14.4425 8.42292C13.9836 8.17582 13.2982 8 12.5 8C11.7018 8 11.0164 8.17582 10.5575 8.42292ZM15 10.9763C14.3046 11.3132 13.427 11.5 12.5 11.5C11.573 11.5 10.6954 11.3132 10 10.9763V13C10 13.0751 10.068 13.3135 10.5575 13.5771C11.0164 13.8242 11.7018 14 12.5 14C13.2982 14 13.9836 13.8242 14.4425 13.5771C14.932 13.3135 15 13.0751 15 13V10.9763Z M4 4.5C4 3.11929 5.11929 2 6.5 2H18C19.3807 2 20.5 3.11929 20.5 4.5V18.75C20.5 19.1642 20.1642 19.5 19.75 19.5H5.5C5.5 20.0523 5.94772 20.5 6.5 20.5H19.75C20.1642 20.5 20.5 20.8358 20.5 21.25C20.5 21.6642 20.1642 22 19.75 22H6.5C5.11929 22 4 20.8807 4 19.5V4.5ZM5.5 18H19V4.5C19 3.94772 18.5523 3.5 18 3.5H6.5C5.94772 3.5 5.5 3.94772 5.5 4.5V18Z " },
            { FluentSymbol.BookExclamationMark24Filled, "M4 4.5V19.5C4 20.8807 5.11929 22 6.5 22H19.75C20.1642 22 20.5 21.6642 20.5 21.25C20.5 20.8358 20.1642 20.5 19.75 20.5H6.5C5.94772 20.5 5.5 20.0523 5.5 19.5H19.75C20.1642 19.5 20.5 19.1642 20.5 18.75V4.5C20.5 3.11929 19.3807 2 18 2H6.5C5.11929 2 4 3.11929 4 4.5ZM11.5 11.75L11.5 6.75C11.5 6.33579 11.8358 6 12.25 6C12.6642 6 13 6.33579 13 6.75V11.75C13 12.1642 12.6642 12.5 12.25 12.5C11.8358 12.5 11.5 12.1642 11.5 11.75ZM13.25 14.5C13.25 15.0523 12.8023 15.5 12.25 15.5C11.6977 15.5 11.25 15.0523 11.25 14.5C11.25 13.9477 11.6977 13.5 12.25 13.5C12.8023 13.5 13.25 13.9477 13.25 14.5Z " },
            { FluentSymbol.BookExclamationMark24, "M13.25 14.5C13.25 15.0523 12.8023 15.5 12.25 15.5C11.6977 15.5 11.25 15.0523 11.25 14.5C11.25 13.9477 11.6977 13.5 12.25 13.5C12.8023 13.5 13.25 13.9477 13.25 14.5Z M11.5 6.75L11.5 11.75C11.5 12.1642 11.8358 12.5 12.25 12.5C12.6642 12.5 13 12.1642 13 11.75V6.75C13 6.33579 12.6642 6 12.25 6C11.8358 6 11.5 6.33579 11.5 6.75Z M4 4.5C4 3.11929 5.11929 2 6.5 2H18C19.3807 2 20.5 3.11929 20.5 4.5V18.75C20.5 19.1642 20.1642 19.5 19.75 19.5H5.5C5.5 20.0523 5.94772 20.5 6.5 20.5H19.75C20.1642 20.5 20.5 20.8358 20.5 21.25C20.5 21.6642 20.1642 22 19.75 22H6.5C5.11929 22 4 20.8807 4 19.5V4.5ZM19 18V4.5C19 3.94772 18.5523 3.5 18 3.5H6.5C5.94772 3.5 5.5 3.94772 5.5 4.5V18H19Z " },
            { FluentSymbol.BookGlobe24Filled, "M4 4.5C4 3.11929 5.11929 2 6.5 2H18C19.3807 2 20.5 3.11929 20.5 4.5V18.75C20.5 19.1642 20.1642 19.5 19.75 19.5H5.5C5.5 20.0523 5.94772 20.5 6.5 20.5H19.75C20.1642 20.5 20.5 20.8358 20.5 21.25C20.5 21.6642 20.1642 22 19.75 22H6.5C5.11929 22 4 20.8807 4 19.5V4.5ZM10.5512 6.36764C8.98118 7.02105 7.83719 8.49262 7.65152 10.25H9.75821C9.79946 9.00044 9.99438 7.85326 10.3047 6.9667C10.3777 6.75805 10.4596 6.55669 10.5512 6.36764ZM13.8907 6.25184C14.0061 6.47362 14.1072 6.71485 14.1953 6.9667C14.5056 7.85326 14.7005 9.00044 14.7418 10.25H17.0985C16.9009 8.37956 15.6177 6.8329 13.8907 6.25184ZM13.2409 10.25C13.2001 9.13802 13.0254 8.16476 12.7795 7.46223C12.6373 7.05575 12.4851 6.78027 12.3534 6.62107C12.3078 6.56605 12.2732 6.53432 12.25 6.51645C12.2268 6.53432 12.1922 6.56605 12.1466 6.62107C12.0149 6.78027 11.8627 7.05575 11.7205 7.46223C11.4746 8.16476 11.2999 9.13802 11.2591 10.25H13.2409ZM11.287 11.75C11.355 12.6534 11.5122 13.4427 11.7205 14.0378C11.8627 14.4442 12.0149 14.7197 12.1466 14.8789C12.1922 14.934 12.2268 14.9657 12.25 14.9836C12.2732 14.9657 12.3078 14.934 12.3534 14.8789C12.4851 14.7197 12.6373 14.4442 12.7795 14.0378C12.9878 13.4427 13.145 12.6534 13.213 11.75H11.287ZM9.78322 11.75H7.7294C8.05772 13.2902 9.13258 14.554 10.5571 15.1446C10.4631 14.952 10.3793 14.7465 10.3047 14.5333C10.0363 13.7664 9.85418 12.8045 9.78322 11.75ZM13.8845 15.26C15.4611 14.732 16.669 13.3995 17.0206 11.75H14.7168C14.6458 12.8045 14.4637 13.7664 14.1953 14.5333C14.1056 14.7896 14.0025 15.035 13.8845 15.26Z " },
            { FluentSymbol.BookGlobe24, "M12.0393 6.01656C9.5726 6.18879 7.625 8.24439 7.625 10.7549C7.625 13.3782 9.75165 15.5049 12.375 15.5049C14.9984 15.5049 17.125 13.3782 17.125 10.7549C17.125 8.13153 14.9984 6.00488 12.375 6.00488C12.3717 6.00488 12.3684 6.00489 12.3651 6.00489C12.3274 6.00167 12.2891 6 12.25 6C12.1773 6 12.1071 6.00578 12.0393 6.01656ZM10.4183 7.85249C10.1924 8.52871 10.0498 9.3576 10.0108 10.25H8.91115C9.05517 9.25313 9.61933 8.3922 10.4183 7.85249ZM10.044 11.75C10.1073 12.4565 10.2372 13.1094 10.4226 13.6601C9.75575 13.2111 9.25194 12.5386 9.01849 11.75H10.044ZM14.0096 13.8505C14.0107 13.8476 14.0118 13.8447 14.0129 13.8418C14.2328 13.2554 14.3856 12.5359 14.456 11.75H15.7315C15.4623 12.6595 14.8334 13.4146 14.0096 13.8505ZM12.949 11.75C12.8843 12.3676 12.7625 12.9043 12.6084 13.3151C12.4911 13.6278 12.3696 13.8288 12.2727 13.9381C12.2645 13.9473 12.2569 13.9554 12.25 13.9626C12.2431 13.9554 12.2355 13.9473 12.2273 13.9381C12.1304 13.8288 12.0089 13.6278 11.8916 13.3151C11.7375 12.9043 11.6157 12.3676 11.551 11.75H12.949ZM12.9875 10.25H11.5125C11.5542 9.42163 11.6973 8.70308 11.8916 8.18492C12.0089 7.87219 12.1304 7.67121 12.2273 7.56189C12.2355 7.55267 12.2431 7.54456 12.25 7.53743C12.2569 7.54456 12.2645 7.55267 12.2727 7.56189C12.3696 7.67121 12.4911 7.87219 12.6084 8.18492C12.8027 8.70308 12.9458 9.42163 12.9875 10.25ZM14.4892 10.25C14.4465 9.27176 14.2792 8.36984 14.0142 7.66168C14.9796 8.17434 15.6764 9.12572 15.8389 10.25H14.4892ZM12.3075 7.48948C12.3079 7.48922 12.3075 7.48953 12.3075 7.48948C12.3075 7.48935 12.3061 7.48991 12.3034 7.49154C12.305 7.49088 12.3068 7.48985 12.3075 7.48948ZM12.194 7.49035C12.1946 7.49068 12.1955 7.49109 12.1966 7.49154C12.1939 7.48991 12.1925 7.48935 12.1925 7.48948C12.1925 7.48955 12.193 7.48987 12.194 7.49035Z M6.5 2C5.11929 2 4 3.11929 4 4.5V19.5C4 20.8807 5.11929 22 6.5 22H19.75C20.1642 22 20.5 21.6642 20.5 21.25C20.5 20.8358 20.1642 20.5 19.75 20.5H6.5C5.94772 20.5 5.5 20.0523 5.5 19.5H19.75C20.1642 19.5 20.5 19.1642 20.5 18.75V4.5C20.5 3.11929 19.3807 2 18 2H6.5ZM19 4.5V18H5.5V4.5C5.5 3.94772 5.94772 3.5 6.5 3.5H18C18.5523 3.5 19 3.94772 19 4.5Z " },
            { FluentSymbol.BookInformation24Filled, "M4 4.5C4 3.11929 5.11929 2 6.5 2H18C19.3807 2 20.5 3.11929 20.5 4.5V18.75C20.5 19.1642 20.1642 19.5 19.75 19.5H5.5C5.5 20.0523 5.94772 20.5 6.5 20.5H19.75C20.1642 20.5 20.5 20.8358 20.5 21.25C20.5 21.6642 20.1642 22 19.75 22H6.5C5.11929 22 4 20.8807 4 19.5V4.5ZM12.25 8C12.8023 8 13.25 7.55228 13.25 7C13.25 6.44772 12.8023 6 12.25 6C11.6977 6 11.25 6.44772 11.25 7C11.25 7.55228 11.6977 8 12.25 8ZM11.5 9.75L11.5 14.75C11.5 15.1642 11.8358 15.5 12.25 15.5C12.6642 15.5 13 15.1642 13 14.75V9.75C13 9.33579 12.6642 9 12.25 9C11.8358 9 11.5 9.33579 11.5 9.75Z " },
            { FluentSymbol.BookInformation24, "M13.25 7C13.25 7.55228 12.8023 8 12.25 8C11.6977 8 11.25 7.55228 11.25 7C11.25 6.44772 11.6977 6 12.25 6C12.8023 6 13.25 6.44772 13.25 7Z M11.5 9.75L11.5 14.75C11.5 15.1642 11.8358 15.5 12.25 15.5C12.6642 15.5 13 15.1642 13 14.75V9.75C13 9.33579 12.6642 9 12.25 9C11.8358 9 11.5 9.33579 11.5 9.75Z M4 4.5C4 3.11929 5.11929 2 6.5 2H18C19.3807 2 20.5 3.11929 20.5 4.5V18.75C20.5 19.1642 20.1642 19.5 19.75 19.5H5.5C5.5 20.0523 5.94772 20.5 6.5 20.5H19.75C20.1642 20.5 20.5 20.8358 20.5 21.25C20.5 21.6642 20.1642 22 19.75 22H6.5C5.11929 22 4 20.8807 4 19.5V4.5ZM19 18V4.5C19 3.94772 18.5523 3.5 18 3.5H6.5C5.94772 3.5 5.5 3.94772 5.5 4.5V18H19Z " },
            { FluentSymbol.BookLetter24Filled, "M12.5 8.74268L13.6202 11.5H11.3799L12.5 8.74268Z M4 4.5V19.5C4 20.8807 5.11929 22 6.5 22H19.75C20.1642 22 20.5 21.6642 20.5 21.25C20.5 20.8358 20.1642 20.5 19.75 20.5H6.5C5.94772 20.5 5.5 20.0523 5.5 19.5H19.75C20.1642 19.5 20.5 19.1642 20.5 18.75V4.5C20.5 3.11929 19.3807 2 18 2H6.5C5.11929 2 4 3.11929 4 4.5ZM12.5 6C12.8052 6 13.08 6.18495 13.1949 6.46772L16.4449 14.4677C16.6008 14.8515 16.4161 15.2889 16.0323 15.4448C15.6485 15.6007 15.2111 15.416 15.0552 15.0323L14.2296 13H10.7705L9.94486 15.0323C9.78896 15.416 9.35149 15.6007 8.96773 15.4448C8.58398 15.2889 8.39926 14.8515 8.55517 14.4677L11.8052 6.46772C11.92 6.18495 12.1948 6 12.5 6Z " },
            { FluentSymbol.BookLetter24, "M12.5 6C12.1948 6 11.92 6.18495 11.8052 6.46772L8.55517 14.4677C8.39926 14.8515 8.58398 15.2889 8.96773 15.4448C9.35149 15.6007 9.78896 15.416 9.94487 15.0323L10.7705 13H14.2296L15.0552 15.0323C15.2111 15.416 15.6485 15.6007 16.0323 15.4448C16.4161 15.2889 16.6008 14.8515 16.4449 14.4677L13.1949 6.46772C13.08 6.18495 12.8052 6 12.5 6ZM11.3799 11.5L12.5 8.74268L13.6202 11.5H11.3799Z M4 4.5C4 3.11929 5.11929 2 6.5 2H18C19.3807 2 20.5 3.11929 20.5 4.5V18.75C20.5 19.1642 20.1642 19.5 19.75 19.5H5.5C5.5 20.0523 5.94772 20.5 6.5 20.5H19.75C20.1642 20.5 20.5 20.8358 20.5 21.25C20.5 21.6642 20.1642 22 19.75 22H6.5C5.11929 22 4 20.8807 4 19.5V4.5ZM5.5 18H19V4.5C19 3.94772 18.5523 3.5 18 3.5H6.5C5.94772 3.5 5.5 3.94772 5.5 4.5V18Z " },
            { FluentSymbol.BookNumber16Filled, "M8.59808 5.99534L8.37383 6.99997H7.40326L7.6257 5.99534H8.59808Z M5 1H11C12.1046 1 13 1.89543 13 3V12.4969C13 12.7731 12.7761 12.9969 12.5 12.9969H4V13C4 13.5523 4.44772 14 5 14H12.5C12.7761 14 13 14.2239 13 14.5C13 14.7761 12.7761 15 12.5 15H5C3.89543 15 3 14.1046 3 13V3C3 1.89543 3.89543 1 5 1ZM7.98764 4.36064C8.04733 4.09102 7.87716 3.82407 7.60755 3.76437C7.33794 3.70468 7.07098 3.87485 7.01128 4.14446L6.82289 4.99534H6C5.72386 4.99534 5.5 5.21919 5.5 5.49534C5.5 5.77148 5.72386 5.99534 6 5.99534H6.60148L6.37904 6.99997H5.5C5.22386 6.99997 5 7.22383 5 7.49997C5 7.77612 5.22386 7.99997 5.5 7.99997H6.15763L6.01634 8.63809C5.95665 8.90771 6.12682 9.17466 6.39643 9.23436C6.66604 9.29405 6.933 9.12388 6.9927 8.85427L7.18185 7.99997H8.15061L8.00835 8.6373C7.94819 8.90681 8.1179 9.17406 8.38741 9.23422C8.65692 9.29438 8.92417 9.12467 8.98433 8.85516L9.17522 7.99997H10C10.2761 7.99997 10.5 7.77612 10.5 7.49997C10.5 7.22383 10.2761 6.99997 10 6.99997H9.39844L9.62269 5.99534H10.5C10.7761 5.99534 11 5.77148 11 5.49534C11 5.21919 10.7761 4.99534 10.5 4.99534H9.84591L9.98738 4.36153C10.0475 4.09202 9.87783 3.82477 9.60832 3.76461C9.33881 3.70445 9.07156 3.87416 9.0114 4.14367L8.8213 4.99534H7.84711L7.98764 4.36064Z " },
            { FluentSymbol.BookNumber16, "M5.5 5.49536C5.5 5.7715 5.72386 5.99536 6 5.99536H6.60148L6.37904 7H5.5C5.22386 7 5 7.22386 5 7.5C5 7.77614 5.22386 8 5.5 8H6.15763L6.01634 8.63812C5.95665 8.90773 6.12682 9.17469 6.39643 9.23438C6.66604 9.29408 6.933 9.12391 6.9927 8.85429L7.18185 8H8.15061L8.00835 8.63733C7.94819 8.90684 8.1179 9.17408 8.38741 9.23424C8.65692 9.2944 8.92417 9.12469 8.98433 8.85518L9.17522 8H10C10.2761 8 10.5 7.77614 10.5 7.5C10.5 7.22386 10.2761 7 10 7H9.39844L9.62269 5.99536H10.5C10.7761 5.99536 11 5.7715 11 5.49536C11 5.21922 10.7761 4.99536 10.5 4.99536H9.84591L9.98738 4.36155C10.0475 4.09204 9.87783 3.8248 9.60832 3.76464C9.33881 3.70448 9.07156 3.87419 9.0114 4.1437L8.8213 4.99536H7.84711L7.98764 4.36066C8.04733 4.09105 7.87716 3.82409 7.60755 3.7644C7.33794 3.7047 7.07098 3.87487 7.01128 4.14449L6.82289 4.99536H6C5.72386 4.99536 5.5 5.21922 5.5 5.49536ZM8.37383 7H7.40326L7.6257 5.99536H8.59808L8.37383 7Z M5 1H11C12.1046 1 13 1.89543 13 3V12.4969C13 12.7731 12.7761 12.9969 12.5 12.9969H4V13C4 13.5523 4.44772 14 5 14H12.5C12.7761 14 13 14.2239 13 14.5C13 14.7761 12.7761 15 12.5 15H5C3.89543 15 3 14.1046 3 13V3C3 1.89543 3.89543 1 5 1ZM4 3V11.9969H12V3C12 2.44772 11.5523 2 11 2H5C4.44771 2 4 2.44771 4 3Z " },
            { FluentSymbol.BookNumber20Filled, "M9.60989 8.00477H10.5915L10.3919 9.00477H9.40958L9.60989 8.00477Z M6 2C4.89543 2 4 2.89543 4 4V16C4 17.1046 4.89543 18 6 18H15.5036C15.7797 18 16.0036 17.7762 16.0036 17.5C16.0036 17.2239 15.7797 17 15.5036 17H6C5.44815 17 5.0007 16.553 5 16.0013H15.5036C15.7797 16.0013 16.0036 15.7775 16.0036 15.5013V4C16.0036 2.89543 15.1081 2 14.0036 2H6ZM11.5989 5.51123C11.8697 5.56527 12.0455 5.82861 11.9914 6.09941L11.8107 7.00477H12.7518C13.0279 7.00477 13.2518 7.22863 13.2518 7.50477C13.2518 7.78091 13.0279 8.00477 12.7518 8.00477H11.6112L11.4116 9.00477H12.5013C12.7775 9.00477 13.0013 9.22863 13.0013 9.50477C13.0013 9.78091 12.7775 10.0048 12.5013 10.0048H11.2121L10.9939 11.0978C10.9399 11.3686 10.6765 11.5443 10.4057 11.4903C10.1349 11.4363 9.95922 11.1729 10.0133 10.9021L10.1923 10.0048H9.20927L8.99025 11.0982C8.93601 11.369 8.67255 11.5445 8.40178 11.4903C8.13102 11.436 7.95549 11.1726 8.00973 10.9018L8.18941 10.0048H7.25183C6.97569 10.0048 6.75183 9.78091 6.75183 9.50477C6.75183 9.22863 6.97569 9.00477 7.25183 9.00477H8.38972L8.59003 8.00477H7.49963C7.22349 8.00477 6.99963 7.78091 6.99963 7.50477C6.99963 7.22863 7.22349 7.00477 7.49963 7.00477H8.79033L9.01095 5.9034C9.06518 5.63264 9.32865 5.45711 9.59941 5.51134C9.87018 5.56558 10.0457 5.82905 9.99147 6.09981L9.8102 7.00477H10.791L11.0107 5.90371C11.0648 5.63291 11.3281 5.45719 11.5989 5.51123Z " },
            { FluentSymbol.BookNumber20, "M6.99963 7.50476C6.99963 7.22862 7.22349 7.00476 7.49963 7.00476H8.79033L9.01095 5.90339C9.06518 5.63263 9.32865 5.4571 9.59941 5.51133C9.87018 5.56557 10.0457 5.82904 9.99147 6.0998L9.8102 7.00476H10.791L11.0107 5.9037C11.0648 5.6329 11.3281 5.45718 11.5989 5.51122C11.8697 5.56526 12.0455 5.8286 11.9914 6.0994L11.8107 7.00476H12.7518C13.0279 7.00476 13.2518 7.22862 13.2518 7.50476C13.2518 7.7809 13.0279 8.00476 12.7518 8.00476H11.6112L11.4116 9.00476H12.5013C12.7775 9.00476 13.0013 9.22862 13.0013 9.50476C13.0013 9.7809 12.7775 10.0048 12.5013 10.0048H11.2121L10.9939 11.0978C10.9399 11.3686 10.6765 11.5443 10.4057 11.4903C10.1349 11.4362 9.95922 11.1729 10.0133 10.9021L10.1923 10.0048H9.20927L8.99025 11.0982C8.93601 11.369 8.67255 11.5445 8.40178 11.4903C8.13102 11.436 7.95549 11.1726 8.00973 10.9018L8.18941 10.0048H7.25183C6.97569 10.0048 6.75183 9.7809 6.75183 9.50476C6.75183 9.22862 6.97569 9.00476 7.25183 9.00476H8.38972L8.59003 8.00476H7.49963C7.22349 8.00476 6.99963 7.7809 6.99963 7.50476ZM10.3919 9.00476L10.5915 8.00476H9.60989L9.40958 9.00476H10.3919Z M6 2H14.0036C15.1081 2 16.0036 2.89543 16.0036 4V15.5013C16.0036 15.7775 15.7797 16.0013 15.5036 16.0013H5C5.0007 16.553 5.44815 17 6 17H15.5036C15.7797 17 16.0036 17.2239 16.0036 17.5C16.0036 17.7762 15.7797 18 15.5036 18H6C4.89543 18 4 17.1046 4 16V4C4 2.89543 4.89543 2 6 2ZM5 15.0013H15.0036V4C15.0036 3.44772 14.5559 3 14.0036 3H6C5.44771 3 5 3.44771 5 4V15.0013Z " },
            { FluentSymbol.BookNumber24, "M11.0242 7.57051L10.8009 8.48015L9.73088 8.48029L9.62911 8.48714C9.26304 8.5368 8.98088 8.8506 8.98088 9.23029L8.98773 9.33206C9.03739 9.69814 9.35119 9.98029 9.73088 9.98029L10.4339 9.98015L10.0459 11.5662L9.25 11.5671L9.14823 11.5739C8.78215 11.6236 8.5 11.9374 8.5 12.3171L8.50685 12.4189C8.55651 12.7849 8.8703 13.0671 9.25 13.0671L9.67887 13.0662L9.55583 13.5734L9.5383 13.6739C9.49956 14.0413 9.73733 14.3899 10.1061 14.4801L10.2066 14.4976C10.574 14.5364 10.9227 14.2986 11.0129 13.9298L11.2229 13.0662H12.7619L12.6444 13.5841L12.6284 13.6848C12.595 14.0528 12.8379 14.3979 13.208 14.4827L13.3087 14.4987C13.6766 14.5321 14.0217 14.2892 14.1065 13.9191L14.3009 13.0662L15.2416 13.0671L15.3433 13.0602C15.7094 13.0106 15.9916 12.6968 15.9916 12.3171L15.9847 12.2153C15.935 11.8492 15.6212 11.5671 15.2416 11.5671L14.6449 11.5662L15.0079 9.98015L15.7279 9.98029L15.8297 9.97345C16.1958 9.92378 16.4779 9.60999 16.4779 9.23029L16.4711 9.12852C16.4214 8.76245 16.1076 8.48029 15.7279 8.48029L15.3519 8.48015L15.4818 7.9162L15.4979 7.81547C15.5312 7.44755 15.2883 7.10244 14.9182 7.01765L14.8175 7.0016C14.4496 6.96825 14.1045 7.21112 14.0197 7.58122L13.8129 8.48015H12.3449L12.4812 7.92691L12.4988 7.82643C12.5375 7.45904 12.2997 7.11041 11.9309 7.02019C11.5286 6.92177 11.1226 7.16816 11.0242 7.57051ZM11.9779 9.98015H13.4689L13.1059 11.5662H11.5899L11.9779 9.98015Z M6.5 2C5.11929 2 4 3.11929 4 4.5V19.5C4 20.8807 5.11929 22 6.5 22H19.75C20.1642 22 20.5 21.6642 20.5 21.25C20.5 20.8358 20.1642 20.5 19.75 20.5H6.5C5.94772 20.5 5.5 20.0523 5.5 19.5H19.75C20.1642 19.5 20.5 19.1642 20.5 18.75V4.5C20.5 3.11929 19.3807 2 18 2H6.5ZM19 18H5.5V4.5C5.5 3.94772 5.94772 3.5 6.5 3.5H18C18.5523 3.5 19 3.94772 19 4.5V18Z " },
            { FluentSymbol.BookNumber24Filled, "M11.9779 9.98015H13.4689L13.1059 11.5662H11.5899L11.9779 9.98015Z M4 4.5C4 3.11929 5.11929 2 6.5 2H18C19.3807 2 20.5 3.11929 20.5 4.5V18.75C20.5 19.1642 20.1642 19.5 19.75 19.5H5.5C5.5 20.0523 5.94772 20.5 6.5 20.5H19.75C20.1642 20.5 20.5 20.8358 20.5 21.25C20.5 21.6642 20.1642 22 19.75 22H6.5C5.11929 22 4 20.8807 4 19.5V4.5ZM11.0242 7.57051L10.8009 8.48015L9.73088 8.48029L9.62911 8.48714C9.26304 8.5368 8.98088 8.8506 8.98088 9.23029L8.98773 9.33206C9.03739 9.69814 9.35119 9.98029 9.73088 9.98029L10.4339 9.98015L10.0459 11.5662L9.25 11.5671L9.14823 11.5739C8.78215 11.6236 8.5 11.9374 8.5 12.3171L8.50685 12.4189C8.55651 12.7849 8.8703 13.0671 9.25 13.0671L9.67887 13.0662L9.55583 13.5734L9.5383 13.6739C9.49956 14.0413 9.73733 14.3899 10.1061 14.4801L10.2066 14.4976C10.574 14.5364 10.9227 14.2986 11.0129 13.9298L11.2229 13.0662H12.7619L12.6444 13.5841L12.6284 13.6848C12.595 14.0528 12.8379 14.3979 13.208 14.4827L13.3087 14.4987C13.6766 14.5321 14.0217 14.2892 14.1065 13.9191L14.3009 13.0662L15.2416 13.0671L15.3433 13.0602C15.7094 13.0106 15.9916 12.6968 15.9916 12.3171L15.9847 12.2153C15.935 11.8492 15.6212 11.5671 15.2416 11.5671L14.6449 11.5662L15.0079 9.98015L15.7279 9.98029L15.8297 9.97345C16.1958 9.92378 16.4779 9.60999 16.4779 9.23029L16.4711 9.12852C16.4214 8.76245 16.1076 8.48029 15.7279 8.48029L15.3519 8.48015L15.4818 7.9162L15.4979 7.81547C15.5312 7.44755 15.2883 7.10244 14.9182 7.01765L14.8175 7.0016C14.4496 6.96825 14.1045 7.21112 14.0197 7.58122L13.8129 8.48015H12.3449L12.4812 7.92691L12.4988 7.82643C12.5375 7.45904 12.2997 7.11041 11.9309 7.02019C11.5286 6.92177 11.1226 7.16816 11.0242 7.57051Z " },
            { FluentSymbol.BookOpen20Filled, "M10 16.1375C9.49862 16.6686 8.78802 17 8 17H3.75C2.7835 17 2 16.2165 2 15.25V4.75C2 3.7835 2.7835 3 3.75 3H8C8.78802 3 9.49862 3.33145 10 3.86253C10.5014 3.33145 11.212 3 12 3H16.25C17.2165 3 18 3.7835 18 4.75L18 15.25C18 16.2165 17.2165 17 16.25 17L12 17C11.212 17 10.5014 16.6686 10 16.1375ZM3.5 4.75V15.25C3.5 15.3881 3.61193 15.5 3.75 15.5H8C8.69036 15.5 9.25 14.9404 9.25 14.25V5.75C9.25 5.05964 8.69036 4.5 8 4.5H3.75C3.61193 4.5 3.5 4.61193 3.5 4.75ZM10.75 14.25C10.75 14.9404 11.3096 15.5 12 15.5L16.25 15.5C16.3881 15.5 16.5 15.3881 16.5 15.25L16.5 4.75C16.5 4.61193 16.3881 4.5 16.25 4.5L12 4.5C11.3096 4.5 10.75 5.05964 10.75 5.75V14.25Z " },
            { FluentSymbol.BookOpen20, "M10 16.0002C9.54389 16.6073 8.8178 17 8 17H3.5C2.67157 17 2 16.3284 2 15.5V4.5C2 3.67157 2.67157 3 3.5 3H8C8.8178 3 9.54389 3.39267 10 3.99976C10.4561 3.39267 11.1822 3 12 3H16.5C17.3284 3 18 3.67157 18 4.5L18 15.5C18 16.3284 17.3284 17 16.5 17L12 17C11.1822 17 10.4561 16.6073 10 16.0002ZM3 4.5V15.5C3 15.7761 3.22386 16 3.5 16H8C8.82843 16 9.5 15.3284 9.5 14.5V5.5C9.5 4.67157 8.82843 4 8 4H3.5C3.22386 4 3 4.22386 3 4.5ZM10.5 14.5C10.5 15.3284 11.1716 16 12 16L16.5 16C16.7761 16 17 15.7761 17 15.5L17 4.5C17 4.22386 16.7761 4 16.5 4L12 4C11.1716 4 10.5 4.67157 10.5 5.5V14.5Z " },
            { FluentSymbol.BookOpen24Filled, "M4 4C2.89543 4 2 4.89543 2 6V18C2 19.1046 2.89543 20 4 20H10C10.7684 20 11.4692 19.7111 12 19.2361C12.5308 19.7111 13.2316 20 14 20H20C21.1046 20 22 19.1046 22 18V6C22 4.89543 21.1046 4 20 4H14C13.2316 4 12.5308 4.28885 12 4.7639C11.4692 4.28885 10.7684 4 10 4H4ZM11 7V17C11 17.5523 10.5523 18 10 18H4V6H10C10.5523 6 11 6.44772 11 7ZM13 17V7C13 6.44772 13.4477 6 14 6H20V18H14C13.4477 18 13 17.5523 13 17Z " },
            { FluentSymbol.BookOpen24, "M12 19.1375C11.4986 19.6686 10.788 20 10 20H3.75C2.7835 20 2 19.2165 2 18.25V5.75C2 4.7835 2.7835 4 3.75 4H10C10.788 4 11.4986 4.33145 12 4.86253C12.5014 4.33145 13.212 4 14 4H20.25C21.2165 4 22 4.7835 22 5.75V18.25C22 19.2165 21.2165 20 20.25 20H14C13.212 20 12.5014 19.6686 12 19.1375ZM3.5 5.75V18.25C3.5 18.3881 3.61193 18.5 3.75 18.5H10C10.6904 18.5 11.25 17.9404 11.25 17.25V6.75C11.25 6.05964 10.6904 5.5 10 5.5H3.75C3.61193 5.5 3.5 5.61193 3.5 5.75ZM12.75 17.25C12.75 17.9404 13.3096 18.5 14 18.5H20.25C20.3881 18.5 20.5 18.3881 20.5 18.25V5.75C20.5 5.61193 20.3881 5.5 20.25 5.5H14C13.3096 5.5 12.75 6.05964 12.75 6.75V17.25Z " },
            { FluentSymbol.BookOpenGlobe20Filled, "M18 4.75L18 10.2572C17.5537 9.88857 17.0482 9.58904 16.5 9.37494V4.75C16.5 4.61193 16.3881 4.5 16.25 4.5L12 4.5C11.3096 4.5 10.75 5.05964 10.75 5.75V10.4766C10.0615 11.1186 9.53804 11.9351 9.25 12.8557V5.75C9.25 5.05964 8.69036 4.5 8 4.5H3.75C3.61193 4.5 3.5 4.61193 3.5 4.75V15.25C3.5 15.3881 3.61193 15.5 3.75 15.5H8C8.42109 15.5 8.79354 15.2918 9.02003 14.9727C9.06892 15.5471 9.2061 16.0963 9.41793 16.6067C9.00389 16.8564 8.51872 17 8 17H3.75C2.7835 17 2 16.2165 2 15.25V4.75C2 3.7835 2.7835 3 3.75 3H8C8.78802 3 9.49862 3.33145 10 3.86253C10.5014 3.33145 11.212 3 12 3H16.25C17.2165 3 18 3.7835 18 4.75ZM13.0103 14C13.057 12.8717 13.2593 11.8769 13.55 11.1502C13.717 10.7326 13.9034 10.4283 14.0848 10.2365C14.2652 10.0457 14.4056 10 14.5 10C14.5944 10 14.7348 10.0457 14.9152 10.2365C15.0966 10.4283 15.283 10.7326 15.45 11.1502C15.7407 11.8769 15.943 12.8717 15.9897 14H13.0103ZM12.6215 10.7788C12.6855 10.6189 12.7548 10.4654 12.8295 10.3202C11.3192 10.9244 10.2128 12.3234 10.0275 14H12.0095C12.0566 12.7664 12.2767 11.6409 12.6215 10.7788ZM16.3785 10.7788C16.3145 10.6189 16.2452 10.4654 16.1705 10.3202C17.6808 10.9244 18.7872 12.3234 18.9725 14H16.9905C16.9434 12.7664 16.7233 11.6409 16.3785 10.7788ZM16.9905 15H18.9725C18.7872 16.6766 17.6808 18.0756 16.1705 18.6798C16.2452 18.5346 16.3145 18.3811 16.3785 18.2212C16.7233 17.3591 16.9434 16.2336 16.9905 15ZM14.9152 18.7635C14.7348 18.9543 14.5944 19 14.5 19C14.4056 19 14.2652 18.9543 14.0848 18.7635C13.9034 18.5717 13.717 18.2674 13.55 17.8498C13.2593 17.1231 13.057 16.1283 13.0103 15H15.9897C15.943 16.1283 15.7407 17.1231 15.45 17.8498C15.283 18.2674 15.0966 18.5717 14.9152 18.7635ZM10.0275 15C10.2128 16.6766 11.3192 18.0756 12.8295 18.6798C12.7548 18.5346 12.6855 18.3811 12.6215 18.2212C12.2767 17.3591 12.0566 16.2336 12.0095 15H10.0275Z " },
            { FluentSymbol.BookOpenGlobe20, "M18 4.5L18 10.2572C17.6929 10.0035 17.3578 9.78261 17 9.59971V4.5C17 4.22386 16.7761 4 16.5 4L12 4C11.1716 4 10.5 4.67157 10.5 5.5V10.7251C10.0912 11.1581 9.75187 11.6576 9.5 12.2055V5.5C9.5 4.67157 8.82843 4 8 4H3.5C3.22386 4 3 4.22386 3 4.5V15.5C3 15.7761 3.22386 16 3.5 16H8C8.43214 16 8.82159 15.8173 9.09531 15.5248C9.16355 15.8869 9.26726 16.2364 9.40271 16.5697C9.00274 16.8413 8.5199 17 8 17H3.5C2.67157 17 2 16.3284 2 15.5V4.5C2 3.67157 2.67157 3 3.5 3H8C8.8178 3 9.54389 3.39267 10 3.99976C10.4561 3.39267 11.1822 3 12 3H16.5C17.3284 3 18 3.67157 18 4.5ZM13.0102 14C13.0568 12.8717 13.2592 11.8769 13.5499 11.1502C13.7169 10.7326 13.9033 10.4283 14.0847 10.2365C14.265 10.0457 14.4055 10 14.4999 10C14.5942 10 14.7347 10.0457 14.9151 10.2365C15.0965 10.4283 15.2828 10.7326 15.4499 11.1502C15.7405 11.8769 15.9429 12.8717 15.9896 14H13.0102ZM12.6214 10.7788C12.6854 10.6189 12.7547 10.4654 12.8294 10.3202C11.3191 10.9244 10.2127 12.3234 10.0273 14H12.0094C12.0565 12.7664 12.2766 11.6409 12.6214 10.7788ZM16.3783 10.7788C16.3144 10.6189 16.2451 10.4654 16.1703 10.3202C17.6806 10.9244 18.7871 12.3234 18.9724 14H16.9904C16.9433 12.7664 16.7232 11.6409 16.3783 10.7788ZM16.9904 15H18.9724C18.7871 16.6766 17.6806 18.0756 16.1703 18.6798C16.2451 18.5346 16.3144 18.3811 16.3783 18.2212C16.7232 17.3591 16.9433 16.2336 16.9904 15ZM14.9151 18.7635C14.7347 18.9543 14.5942 19 14.4999 19C14.4055 19 14.265 18.9543 14.0847 18.7635C13.9033 18.5717 13.7169 18.2674 13.5499 17.8498C13.2592 17.1231 13.0568 16.1283 13.0102 15H15.9896C15.9429 16.1283 15.7405 17.1231 15.4499 17.8498C15.2828 18.2674 15.0965 18.5717 14.9151 18.7635ZM10.0273 15C10.2127 16.6766 11.3191 18.0756 12.8294 18.6798C12.7547 18.5346 12.6854 18.3811 12.6214 18.2212C12.2766 17.3591 12.0565 16.2336 12.0094 15H10.0273Z " },
            { FluentSymbol.BookOpenGlobe24Filled, "M4 4C2.89543 4 2 4.89543 2 6V18C2 19.1046 2.89543 20 4 20H10C10.4939 20 10.9599 19.8807 11.3708 19.6692C11.1307 18.9908 11 18.2607 11 17.5C11 15.6566 11.7673 13.9925 13 12.8096V7C13 6.44772 13.4477 6 14 6H20V11.4982C20.7476 11.8099 21.4245 12.2573 22 12.8096V6C22 4.89543 21.1046 4 20 4H14C13.2316 4 12.5308 4.28885 12 4.7639C11.4692 4.28885 10.7684 4 10 4H4ZM11 7V17C11 17.5523 10.5523 18 10 18H4V6H10C10.5523 6 11 6.44772 11 7ZM16.0071 17C16.0471 15.5855 16.2549 14.3312 16.5602 13.4155C16.7314 12.9017 16.9243 12.522 17.1143 12.281C17.3086 12.0344 17.4428 12 17.5 12C17.5573 12 17.6915 12.0344 17.8858 12.281C18.0757 12.522 18.2687 12.9017 18.4399 13.4155C18.7452 14.3312 18.953 15.5855 18.993 17H16.0071ZM15.6115 13.0992C15.7189 12.7771 15.8413 12.4781 15.9793 12.2129C13.8357 12.8284 12.2286 14.7122 12.0225 17H15.0067C15.0468 15.4998 15.2664 14.1345 15.6115 13.0992ZM19.3886 13.0992C19.2812 12.7771 19.1588 12.4781 19.0208 12.2129C21.1644 12.8284 22.7715 14.7122 22.9776 17H19.9934C19.9532 15.4998 19.7337 14.1345 19.3886 13.0992ZM19.9934 18H22.9776C22.7715 20.2878 21.1644 22.1716 19.0208 22.7871C19.1588 22.5219 19.2812 22.2229 19.3886 21.9008C19.7337 20.8655 19.9532 19.5002 19.9934 18ZM17.8858 22.719C17.6915 22.9656 17.5573 23 17.5 23C17.4428 23 17.3086 22.9656 17.1143 22.719C16.9243 22.478 16.7314 22.0983 16.5602 21.5845C16.2549 20.6688 16.0471 19.4145 16.0071 18H18.993C18.953 19.4145 18.7452 20.6688 18.4399 21.5845C18.2687 22.0983 18.0757 22.478 17.8858 22.719ZM12.0225 18C12.2286 20.2878 13.8357 22.1716 15.9793 22.7871C15.8413 22.5219 15.7189 22.2229 15.6115 21.9008C15.2664 20.8655 15.0468 19.5002 15.0067 18H12.0225Z " },
            { FluentSymbol.BookOpenGlobe24, "M3.5 5.75C3.5 5.61193 3.61193 5.5 3.75 5.5H10C10.6904 5.5 11.25 6.05964 11.25 6.75V15.7086C11.5366 14.7067 12.0577 13.8037 12.75 13.0629V6.75C12.75 6.05964 13.3096 5.5 14 5.5H20.25C20.3881 5.5 20.5 5.61193 20.5 5.75V11.7322C21.051 12.0194 21.5557 12.3832 22 12.8096V5.75C22 4.7835 21.2165 4 20.25 4H14C13.212 4 12.5014 4.33145 12 4.86253C11.4986 4.33145 10.788 4 10 4H3.75C2.7835 4 2 4.7835 2 5.75V18.25C2 19.2165 2.7835 20 3.75 20H10C10.495 20 10.9594 19.8692 11.3606 19.6404C11.1769 19.1134 11.0592 18.5555 11.0172 17.9767C10.7905 18.2935 10.4193 18.5 10 18.5H3.75C3.61193 18.5 3.5 18.3881 3.5 18.25V5.75ZM16.0071 17C16.0471 15.5855 16.2549 14.3312 16.5602 13.4155C16.7314 12.9017 16.9243 12.522 17.1143 12.281C17.3086 12.0344 17.4428 12 17.5 12C17.5573 12 17.6915 12.0344 17.8858 12.281C18.0757 12.522 18.2687 12.9017 18.4399 13.4155C18.7452 14.3312 18.953 15.5855 18.993 17H16.0071ZM15.6115 13.0992C15.7189 12.7771 15.8413 12.4781 15.9793 12.2129C13.8357 12.8284 12.2286 14.7122 12.0225 17H15.0067C15.0468 15.4998 15.2664 14.1345 15.6115 13.0992ZM19.3886 13.0992C19.2812 12.7771 19.1588 12.4781 19.0208 12.2129C21.1644 12.8284 22.7715 14.7122 22.9776 17H19.9934C19.9532 15.4998 19.7337 14.1345 19.3886 13.0992ZM19.9934 18H22.9776C22.7715 20.2878 21.1644 22.1716 19.0208 22.7871C19.1588 22.5219 19.2812 22.2229 19.3886 21.9008C19.7337 20.8655 19.9532 19.5002 19.9934 18ZM17.8858 22.719C17.6915 22.9656 17.5573 23 17.5 23C17.4428 23 17.3086 22.9656 17.1143 22.719C16.9243 22.478 16.7314 22.0983 16.5602 21.5845C16.2549 20.6688 16.0471 19.4145 16.0071 18H18.993C18.953 19.4145 18.7452 20.6688 18.4399 21.5845C18.2687 22.0983 18.0757 22.478 17.8858 22.719ZM12.0225 18C12.2286 20.2878 13.8357 22.1716 15.9793 22.7871C15.8413 22.5219 15.7189 22.2229 15.6115 21.9008C15.2664 20.8655 15.0468 19.5002 15.0067 18H12.0225Z " },
            { FluentSymbol.BookPulse24Filled, "M4 4.5C4 3.11929 5.11929 2 6.5 2H18C19.3807 2 20.5 3.11929 20.5 4.5V18.75C20.5 19.1642 20.1642 19.5 19.75 19.5H5.5C5.5 20.0523 5.94772 20.5 6.5 20.5H19.75C20.1642 20.5 20.5 20.8358 20.5 21.25C20.5 21.6642 20.1642 22 19.75 22H6.5C5.11929 22 4 20.8807 4 19.5V4.5ZM11.6907 7.45777C11.5767 7.18824 11.3163 7.00966 11.0238 7.00038C10.7313 6.9911 10.4601 7.15283 10.3292 7.41459L8.78647 10.5H7.75C7.33579 10.5 7 10.8358 7 11.25C7 11.6642 7.33579 12 7.75 12H9.25C9.53408 12 9.79378 11.8395 9.92082 11.5854L10.9432 9.54063L13.0593 14.5422C13.1699 14.8037 13.4187 14.9803 13.7021 14.9985C13.9855 15.0166 14.2548 14.8732 14.3978 14.6279L15.9308 12H16.75C17.1642 12 17.5 11.6642 17.5 11.25C17.5 10.8358 17.1642 10.5 16.75 10.5H15.5C15.2332 10.5 14.9866 10.6417 14.8522 10.8721L13.857 12.5781L11.6907 7.45777Z " },
            { FluentSymbol.BookPulse24, "M11.6907 7.45777C11.5767 7.18824 11.3163 7.00966 11.0238 7.00038C10.7313 6.9911 10.4601 7.15283 10.3292 7.41459L8.78647 10.5H7.75C7.33579 10.5 7 10.8358 7 11.25C7 11.6642 7.33579 12 7.75 12H9.25C9.53408 12 9.79378 11.8395 9.92082 11.5854L10.9432 9.54063L13.0593 14.5422C13.1699 14.8037 13.4187 14.9803 13.7021 14.9985C13.9855 15.0166 14.2548 14.8732 14.3978 14.6279L15.9308 12H16.75C17.1642 12 17.5 11.6642 17.5 11.25C17.5 10.8358 17.1642 10.5 16.75 10.5H15.5C15.2332 10.5 14.9866 10.6417 14.8522 10.8721L13.857 12.5781L11.6907 7.45777Z M6.5 2C5.11929 2 4 3.11929 4 4.5V19.5C4 20.8807 5.11929 22 6.5 22H19.75C20.1642 22 20.5 21.6642 20.5 21.25C20.5 20.8358 20.1642 20.5 19.75 20.5H6.5C5.94772 20.5 5.5 20.0523 5.5 19.5H19.75C20.1642 19.5 20.5 19.1642 20.5 18.75V4.5C20.5 3.11929 19.3807 2 18 2H6.5ZM19 18H5.5V4.5C5.5 3.94772 5.94772 3.5 6.5 3.5H18C18.5523 3.5 19 3.94772 19 4.5V18Z " },
            { FluentSymbol.BookQuestionMark24, "M10.9998 8.01752C10.9905 8.42363 10.6584 8.74999 10.25 8.74999C9.5 8.74999 9.5 7.9989 9.5 7.9989L9.5 7.99777L9.50001 7.99539L9.50006 7.99017C9.50032 7.9755 9.50072 7.96084 9.50144 7.94618C9.50262 7.92198 9.50473 7.89159 9.50846 7.8559C9.51591 7.78477 9.52996 7.69092 9.55665 7.58186C9.60973 7.36492 9.71565 7.07652 9.92848 6.78906C10.3825 6.17582 11.1982 5.72727 12.513 5.7501C13.4627 5.76659 14.3059 6.16497 14.834 6.82047C15.371 7.48704 15.5517 8.3902 15.1964 9.27853C14.8342 10.1839 14.0149 10.5437 13.5442 10.7503L13.4932 10.7728C13.2147 10.8957 13.0813 10.9599 13.0013 11.024L13 11.0251L13 11.7492C13.0001 12.1634 12.6643 12.4999 12.2501 12.5C11.8359 12.5 11.5001 12.1643 11.5 11.7501L11.5 11C11.5 10.4769 11.752 10.1029 12.0633 9.85345C12.3134 9.65303 12.6276 9.51483 12.8491 9.4174L12.8875 9.40049C13.4292 9.16137 13.6868 9.01346 13.8036 8.72145C13.9483 8.35977 13.8789 8.02596 13.6659 7.76153C13.4439 7.48604 13.0371 7.25943 12.487 7.24988C11.5518 7.23364 11.2425 7.53509 11.134 7.68162C11.0656 7.77404 11.0309 7.86797 11.0137 7.93838C11.0052 7.973 11.0017 7.99908 11.0003 8.01197L10.9998 8.01752Z M12.25 15.5C12.8023 15.5 13.25 15.0523 13.25 14.5C13.25 13.9477 12.8023 13.5 12.25 13.5C11.6977 13.5 11.25 13.9477 11.25 14.5C11.25 15.0523 11.6977 15.5 12.25 15.5Z M4 4.5C4 3.11929 5.11929 2 6.5 2H18C19.3807 2 20.5 3.11929 20.5 4.5V18.75C20.5 19.1642 20.1642 19.5 19.75 19.5H5.5C5.5 20.0523 5.94772 20.5 6.5 20.5H19.75C20.1642 20.5 20.5 20.8358 20.5 21.25C20.5 21.6642 20.1642 22 19.75 22H6.5C5.11929 22 4 20.8807 4 19.5V4.5ZM5.5 4.5V18H19V4.5C19 3.94772 18.5523 3.5 18 3.5H6.5C5.94772 3.5 5.5 3.94772 5.5 4.5Z " },
            { FluentSymbol.BookQuestionMark24Filled, "M4 4.5V19.5C4 20.8807 5.11929 22 6.5 22H19.75C20.1642 22 20.5 21.6642 20.5 21.25C20.5 20.8358 20.1642 20.5 19.75 20.5H6.5C5.94772 20.5 5.5 20.0523 5.5 19.5H19.75C20.1642 19.5 20.5 19.1642 20.5 18.75V4.5C20.5 3.11929 19.3807 2 18 2H6.5C5.11929 2 4 3.11929 4 4.5ZM10.9998 8.01752C10.9905 8.42363 10.6584 8.74999 10.25 8.74999C9.5 8.74999 9.5 7.9989 9.5 7.9989L9.5 7.99777L9.50001 7.99539L9.50006 7.99017C9.50032 7.9755 9.50072 7.96084 9.50144 7.94618C9.50262 7.92198 9.50473 7.89159 9.50846 7.8559C9.51591 7.78477 9.52996 7.69092 9.55665 7.58186C9.60973 7.36492 9.71565 7.07652 9.92848 6.78906C10.3825 6.17582 11.1982 5.72727 12.513 5.7501C13.4627 5.76659 14.3059 6.16497 14.834 6.82047C15.371 7.48704 15.5517 8.3902 15.1964 9.27853C14.8342 10.1839 14.0149 10.5437 13.5442 10.7503L13.4932 10.7728C13.2147 10.8957 13.0813 10.9599 13.0013 11.024L13 11.0251L13 11.7492C13.0001 12.1634 12.6643 12.4999 12.2501 12.5C11.8359 12.5 11.5001 12.1643 11.5 11.7501L11.5 11C11.5 10.4769 11.752 10.1029 12.0633 9.85345C12.3134 9.65303 12.6276 9.51483 12.8491 9.4174L12.8875 9.40049C13.4292 9.16137 13.6868 9.01346 13.8036 8.72145C13.9483 8.35977 13.8789 8.02596 13.6659 7.76153C13.4439 7.48604 13.0371 7.25943 12.487 7.24988C11.5518 7.23364 11.2425 7.53509 11.134 7.68162C11.0656 7.77404 11.0309 7.86797 11.0137 7.93838C11.0052 7.973 11.0017 7.99908 11.0003 8.01197L10.9998 8.01752ZM13.25 14.5C13.25 15.0523 12.8023 15.5 12.25 15.5C11.6977 15.5 11.25 15.0523 11.25 14.5C11.25 13.9477 11.6977 13.5 12.25 13.5C12.8023 13.5 13.25 13.9477 13.25 14.5Z " },
            { FluentSymbol.BookSearch24Filled, "M11.7237 7.44737C10.4665 7.44737 9.44737 8.46651 9.44737 9.72368C9.44737 10.9809 10.4665 12 11.7237 12C12.9809 12 14 10.9809 14 9.72368C14 8.46651 12.9809 7.44737 11.7237 7.44737ZM4 4.5C4 3.11929 5.11929 2 6.5 2H18C19.3807 2 20.5 3.11929 20.5 4.5V18.75C20.5 19.1642 20.1642 19.5 19.75 19.5H5.5C5.5 20.0523 5.94772 20.5 6.5 20.5H19.75C20.1642 20.5 20.5 20.8358 20.5 21.25C20.5 21.6642 20.1642 22 19.75 22H6.5C5.11929 22 4 20.8807 4 19.5V4.5ZM14.8185 11.795C15.2156 11.2028 15.4474 10.49 15.4474 9.72368C15.4474 7.66715 13.7802 6 11.7237 6C9.66715 6 8 7.66715 8 9.72368C8 11.7802 9.66715 13.4474 11.7237 13.4474C12.49 13.4474 13.2028 13.2156 13.795 12.8185L16.2711 15.2945L16.3381 15.3524L16.3455 15.3579C16.629 15.5682 17.031 15.5451 17.288 15.288C17.5707 15.0054 17.5707 14.5472 17.288 14.2646L14.8185 11.795Z " },
            { FluentSymbol.BookSearch24, "M14.8185 11.795C15.2156 11.2028 15.4474 10.49 15.4474 9.72368C15.4474 7.66715 13.7802 6 11.7237 6C9.66715 6 8 7.66715 8 9.72368C8 11.7802 9.66715 13.4474 11.7237 13.4474C12.49 13.4474 13.2028 13.2156 13.795 12.8185L16.2711 15.2945L16.3381 15.3524L16.3455 15.3579C16.629 15.5682 17.031 15.5451 17.288 15.288C17.5707 15.0054 17.5707 14.5472 17.288 14.2646L14.8185 11.795ZM11.7237 7.44737C12.9809 7.44737 14 8.46651 14 9.72368C14 10.9809 12.9809 12 11.7237 12C10.4665 12 9.44737 10.9809 9.44737 9.72368C9.44737 8.46651 10.4665 7.44737 11.7237 7.44737ZM6.5 2C5.11929 2 4 3.11929 4 4.5V19.5C4 20.8807 5.11929 22 6.5 22H19.75C20.1642 22 20.5 21.6642 20.5 21.25C20.5 20.8358 20.1642 20.5 19.75 20.5H6.5C5.94772 20.5 5.5 20.0523 5.5 19.5H19.75C20.1642 19.5 20.5 19.1642 20.5 18.75V4.5C20.5 3.11929 19.3807 2 18 2H6.5ZM19 18H5.5V4.5C5.5 3.94772 5.94772 3.5 6.5 3.5H18C18.5523 3.5 19 3.94772 19 4.5V18Z " },
            { FluentSymbol.BookStar24Filled, "M11.6 9.52747C11.5012 9.72761 11.3103 9.86633 11.0894 9.89842L9.6358 10.1096L10.6876 11.1349C10.8474 11.2907 10.9204 11.5152 10.8826 11.7351L10.6343 13.1829L11.9345 12.4993C12.132 12.3955 12.368 12.3955 12.5656 12.4993L13.8657 13.1829L13.6174 11.7351C13.5797 11.5152 13.6526 11.2907 13.8124 11.1349L14.8643 10.1096L13.4107 9.89842C13.1898 9.86633 12.9989 9.72761 12.9001 9.52747L12.25 8.21029L11.6 9.52747Z M4 4.5C4 3.11929 5.11929 2 6.5 2H18C19.3807 2 20.5 3.11929 20.5 4.5V18.75C20.5 19.1642 20.1642 19.5 19.75 19.5H5.5C5.5 20.0523 5.94772 20.5 6.5 20.5H19.75C20.1642 20.5 20.5 20.8358 20.5 21.25C20.5 21.6642 20.1642 22 19.75 22H6.5C5.11929 22 4 20.8807 4 19.5V4.5ZM10.5416 8.60759L8.08108 8.96512C7.5249 9.04594 7.30281 9.72944 7.70527 10.1217L9.48571 11.8572L9.06541 14.3078C8.9704 14.8617 9.55182 15.2842 10.0493 15.0226L12.25 13.8656L14.4508 15.0226C14.9482 15.2842 15.5297 14.8617 15.4347 14.3078L15.0143 11.8572L16.7948 10.1217C17.1972 9.72944 16.9752 9.04594 16.419 8.96512L13.9585 8.60759L12.8581 6.37799C12.6094 5.874 11.8907 5.874 11.642 6.37799L10.5416 8.60759Z " },
            { FluentSymbol.BookStar24, "M10.5416 8.60759L11.642 6.37799C11.8907 5.874 12.6094 5.874 12.8581 6.37799L13.9585 8.60759L16.419 8.96512C16.9752 9.04594 17.1972 9.72944 16.7948 10.1217L15.0143 11.8572L15.4347 14.3078C15.5297 14.8617 14.9482 15.2842 14.4508 15.0226L12.25 13.8656L10.0493 15.0226C9.55182 15.2842 8.9704 14.8617 9.06541 14.3078L9.48571 11.8572L7.70527 10.1217C7.30281 9.72944 7.5249 9.04594 8.08108 8.96512L10.5416 8.60759ZM11.6 9.52747C11.5012 9.72761 11.3103 9.86633 11.0894 9.89842L9.6358 10.1096L10.6876 11.1349C10.8474 11.2907 10.9204 11.5152 10.8826 11.7351L10.6343 13.1829L11.9345 12.4993C12.132 12.3955 12.368 12.3955 12.5656 12.4993L13.8657 13.1829L13.6174 11.7351C13.5797 11.5152 13.6526 11.2907 13.8124 11.1349L14.8643 10.1096L13.4107 9.89842C13.1898 9.86633 12.9989 9.72761 12.9001 9.52747L12.25 8.21029L11.6 9.52747Z M6.5 2C5.11929 2 4 3.11929 4 4.5V19.5C4 20.8807 5.11929 22 6.5 22H19.75C20.1642 22 20.5 21.6642 20.5 21.25C20.5 20.8358 20.1642 20.5 19.75 20.5H6.5C5.94772 20.5 5.5 20.0523 5.5 19.5H19.75C20.1642 19.5 20.5 19.1642 20.5 18.75V4.5C20.5 3.11929 19.3807 2 18 2H6.5ZM19 18H5.5V4.5C5.5 3.94772 5.94772 3.5 6.5 3.5H18C18.5523 3.5 19 3.94772 19 4.5V18Z " },
            { FluentSymbol.BookTheta24Filled, "M14.1153 14.0068C14.4873 13.4954 14.7811 12.8058 14.9173 12H10.0827C10.2189 12.8058 10.5127 13.4954 10.8847 14.0068C11.4039 14.7207 11.9936 15 12.5 15C13.0064 15 13.5961 14.7207 14.1153 14.0068Z M14.1153 7.99317C14.5621 8.60751 14.8962 9.479 14.9797 10.5H10.0203C10.1038 9.479 10.4379 8.60751 10.8847 7.99317C11.4039 7.27928 11.9936 7 12.5 7C13.0064 7 13.5961 7.27928 14.1153 7.99317Z M4 4.5C4 3.11929 5.11929 2 6.5 2H18C19.3807 2 20.5 3.11929 20.5 4.5V18.75C20.5 19.1642 20.1642 19.5 19.75 19.5H5.5C5.5 20.0523 5.94772 20.5 6.5 20.5H19.75C20.1642 20.5 20.5 20.8358 20.5 21.25C20.5 21.6642 20.1642 22 19.75 22H6.5C5.11929 22 4 20.8807 4 19.5V4.5ZM12.5 16.5C14.7091 16.5 16.5 14.0376 16.5 11C16.5 7.96243 14.7091 5.5 12.5 5.5C10.2909 5.5 8.5 7.96243 8.5 11C8.5 14.0376 10.2909 16.5 12.5 16.5Z " },
            { FluentSymbol.BookTheta24, "M12.5 16.5C14.7091 16.5 16.5 14.0376 16.5 11C16.5 7.96243 14.7091 5.5 12.5 5.5C10.2909 5.5 8.5 7.96243 8.5 11C8.5 14.0376 10.2909 16.5 12.5 16.5ZM14.1153 14.0068C13.5961 14.7207 13.0064 15 12.5 15C11.9936 15 11.4039 14.7207 10.8847 14.0068C10.5127 13.4954 10.2189 12.8058 10.0827 12H14.9173C14.7811 12.8058 14.4873 13.4954 14.1153 14.0068ZM14.1153 7.99317C14.5621 8.60751 14.8962 9.479 14.9797 10.5H10.0203C10.1038 9.479 10.4379 8.60751 10.8847 7.99317C11.4039 7.27928 11.9936 7 12.5 7C13.0064 7 13.5961 7.27928 14.1153 7.99317Z M6.5 2C5.11929 2 4 3.11929 4 4.5V19.5C4 20.8807 5.11929 22 6.5 22H19.75C20.1642 22 20.5 21.6642 20.5 21.25C20.5 20.8358 20.1642 20.5 19.75 20.5H6.5C5.94772 20.5 5.5 20.0523 5.5 19.5H19.75C20.1642 19.5 20.5 19.1642 20.5 18.75V4.5C20.5 3.11929 19.3807 2 18 2H6.5ZM19 18H5.5V4.5C5.5 3.94772 5.94772 3.5 6.5 3.5H18C18.5523 3.5 19 3.94772 19 4.5V18Z " },
            { FluentSymbol.Bookmark20Filled, "M4 4.5C4 3.11929 5.11929 2 6.5 2H13.5C14.8807 2 16 3.11929 16 4.5V17.5C16 17.6881 15.8945 17.8602 15.7269 17.9456C15.5593 18.0309 15.358 18.015 15.2059 17.9044L10 14.1183L4.79409 17.9044C4.64199 18.015 4.4407 18.0309 4.27311 17.9456C4.10553 17.8602 4 17.6881 4 17.5V4.5Z " },
            { FluentSymbol.Bookmark20, "M4 4.5C4 3.11929 5.11929 2 6.5 2H13.5C14.8807 2 16 3.11929 16 4.5V17.5C16 17.6881 15.8945 17.8602 15.7269 17.9456C15.5593 18.0309 15.358 18.015 15.2059 17.9044L10 14.1182L4.79409 17.9044C4.64199 18.015 4.4407 18.0309 4.27311 17.9456C4.10553 17.8602 4 17.6881 4 17.5V4.5ZM6.5 3C5.67157 3 5 3.67157 5 4.5V16.5181L9.70592 13.0956C9.88124 12.9681 10.1188 12.9681 10.2941 13.0956L15 16.5181V4.5C15 3.67157 14.3284 3 13.5 3H6.5Z " },
            { FluentSymbol.Bookmark28Filled, "M9.25 3.5C7.45507 3.5 6 4.95507 6 6.75V24.75C6 25.0348 6.16133 25.2951 6.41643 25.4217C6.67153 25.5484 6.97638 25.5197 7.20329 25.3475L14 20.1914L20.7967 25.3475C21.0236 25.5197 21.3285 25.5484 21.5836 25.4217C21.8387 25.2951 22 25.0348 22 24.75V6.75C22 4.95507 20.5449 3.5 18.75 3.5H9.25Z " },
            { FluentSymbol.Bookmark28, "M6 6.75C6 4.95507 7.45507 3.5 9.25 3.5H18.75C20.5449 3.5 22 4.95507 22 6.75V24.75C22 25.0348 21.8387 25.2951 21.5836 25.4217C21.3285 25.5484 21.0236 25.5197 20.7967 25.3475L14 20.1914L7.20329 25.3475C6.97638 25.5197 6.67153 25.5484 6.41643 25.4217C6.16133 25.2951 6 25.0348 6 24.75V6.75ZM9.25 5C8.2835 5 7.5 5.7835 7.5 6.75V23.2396L13.5467 18.6525C13.8147 18.4492 14.1853 18.4492 14.4533 18.6525L20.5 23.2396V6.75C20.5 5.7835 19.7165 5 18.75 5H9.25Z " },
            { FluentSymbol.Bookmark16Filled, "M3.77935 13.9187C3.4471 14.1406 3.00171 13.9024 3.00171 13.5029V4.01174C3.00171 2.90856 3.89496 2.01372 4.99813 2.01174L10.9981 2.00098C12.1027 1.99901 12.9997 2.89284 13.0017 3.9974V13.5029C13.0017 13.9024 12.5563 14.1406 12.2241 13.9187L8.00171 11.0995L3.77935 13.9187Z " },
            { FluentSymbol.Bookmark16, "M3.77935 13.9187C3.4471 14.1406 3.00171 13.9024 3.00171 13.5029V4.01174C3.00171 2.90856 3.89496 2.01372 4.99813 2.01174L10.9981 2.00098C12.1027 1.99901 12.9997 2.89284 13.0017 3.9974V13.5029C13.0017 13.9024 12.5563 14.1406 12.2241 13.9187L8.00171 11.0995L3.77935 13.9187ZM12.0017 4.00098L11.9948 3.88259C11.9361 3.38535 11.5128 3.00007 10.9999 3.00098L4.99992 3.01174C4.44833 3.01273 4.00171 3.46015 4.00171 4.01174V12.5679L7.72406 10.0825C7.89215 9.97024 8.11127 9.97024 8.27936 10.0825L12.0017 12.5679V4.00098Z " },
            { FluentSymbol.Bookmark24Filled, "M6.19045 21.8538C5.69432 22.2107 5.00244 21.8562 5.00244 21.2449V6.24902C5.00244 4.4541 6.45752 2.99902 8.25244 2.99902H15.7508C17.5458 2.99902 19.0008 4.4541 19.0008 6.24902V21.2449C19.0008 21.8562 18.309 22.2107 17.8128 21.8538L12.0016 17.6728L6.19045 21.8538Z " },
            { FluentSymbol.Bookmark24, "M6.19045 21.8538C5.69432 22.2107 5.00244 21.8562 5.00244 21.2449V6.24902C5.00244 4.4541 6.45752 2.99902 8.25244 2.99902H15.7508C17.5458 2.99902 19.0008 4.4541 19.0008 6.24902V21.2449C19.0008 21.8562 18.309 22.2107 17.8128 21.8538L12.0016 17.6728L6.19045 21.8538ZM17.5008 6.24902C17.5008 5.28253 16.7173 4.49902 15.7508 4.49902H8.25244C7.28594 4.49902 6.50244 5.28253 6.50244 6.24902V19.7814L11.5636 16.1401C11.8253 15.9518 12.178 15.9518 12.4397 16.1401L17.5008 19.7814V6.24902Z " },
            { FluentSymbol.Bookmark32Filled, "M10.2 3C7.8804 3 6 4.8804 6 7.2V28C6 28.3755 6.21039 28.7194 6.54475 28.8904C6.87911 29.0613 7.28106 29.0305 7.58549 28.8107L16 22.7335L24.4145 28.8107C24.7189 29.0305 25.1209 29.0613 25.4553 28.8904C25.7896 28.7194 26 28.3755 26 28V7.2C26 4.88041 24.1196 3 21.8 3H10.2Z " },
            { FluentSymbol.Bookmark32, "M6 7.2C6 4.8804 7.8804 3 10.2 3H21.8C24.1196 3 26 4.88041 26 7.2V28C26 28.3755 25.7896 28.7194 25.4553 28.8904C25.1209 29.0613 24.7189 29.0305 24.4145 28.8107L16 22.7335L7.58549 28.8107C7.28106 29.0305 6.87911 29.0613 6.54475 28.8904C6.21039 28.7194 6 28.3755 6 28V7.2ZM10.2 5C8.98497 5 8 5.98497 8 7.2V26.0442L15.4145 20.6893C15.764 20.4369 16.2359 20.4369 16.5854 20.6893L24 26.0442V7.2C24 5.98497 23.015 5 21.8 5H10.2Z " },
            { FluentSymbol.BookmarkMultiple20Filled, "M6.26758 3C6.61339 2.4022 7.25973 2 8.00001 2H12.5C14.433 2 16 3.567 16 5.5V15.5C16 15.6844 15.8985 15.8538 15.7359 15.9408C15.5734 16.0278 15.3761 16.0183 15.2227 15.916L15 15.7676V5.5C15 4.11929 13.8807 3 12.5 3H6.26758Z M6 4C4.89543 4 4 4.89543 4 6V17.5C4 17.6844 4.10149 17.8538 4.26407 17.9408C4.42665 18.0278 4.62392 18.0183 4.77735 17.916L9 15.1009L13.2226 17.916C13.3761 18.0183 13.5733 18.0278 13.7359 17.9408C13.8985 17.8538 14 17.6844 14 17.5V6C14 4.89543 13.1046 4 12 4H6Z " },
            { FluentSymbol.BookmarkMultiple20, "M6.26758 3C6.61339 2.4022 7.25973 2 8.00001 2H12.5C14.433 2 16 3.567 16 5.5V15.5C16 15.6844 15.8985 15.8538 15.7359 15.9408C15.5734 16.0278 15.3761 16.0183 15.2227 15.916L15 15.7676V5.5C15 4.11929 13.8807 3 12.5 3H6.26758Z M6 4C4.89543 4 4 4.89543 4 6V17.5C4 17.6844 4.10149 17.8538 4.26407 17.9408C4.42665 18.0278 4.62392 18.0183 4.77735 17.916L9 15.1009L13.2226 17.916C13.3761 18.0183 13.5733 18.0278 13.7359 17.9408C13.8985 17.8538 14 17.6844 14 17.5V6C14 4.89543 13.1046 4 12 4H6ZM5 6C5 5.44772 5.44772 5 6 5H12C12.5523 5 13 5.44772 13 6V16.5657L9.27735 14.084C9.1094 13.972 8.8906 13.972 8.72265 14.084L5 16.5657V6Z " },
            { FluentSymbol.BookmarkMultiple24Filled, "M4 6.74814C4 5.50535 5.00742 4.49786 6.25013 4.49786H15.2506C16.4933 4.49786 17.5008 5.50535 17.5008 6.74814V21.2499C17.5008 21.5185 17.3572 21.7666 17.1243 21.9003C16.8914 22.0341 16.6048 22.0332 16.3728 21.8978L10.7504 18.6179L5.12797 21.8978C4.89599 22.0332 4.60936 22.0341 4.37648 21.9003C4.14359 21.7666 4 21.5185 4 21.2499V6.74814ZM15.2497 2C17.8732 2 20 4.12691 20 6.75058V18.6232C20 19.0374 19.6642 19.3733 19.25 19.3733C18.8357 19.3733 18.4999 19.0374 18.4999 18.6232V6.75058C18.4999 4.95543 17.0448 3.50018 15.2497 3.50018H6.63687C6.63687 3.50018 6.75015 2.94339 7.43379 2.41948C8.00023 2 8.60182 2 8.60182 2H15.2497Z " },
            { FluentSymbol.BookmarkMultiple24, "M4 6.74814C4 5.50535 5.00742 4.49786 6.25013 4.49786H15.2506C16.4933 4.49786 17.5008 5.50535 17.5008 6.74814V21.2499C17.5008 21.5185 17.3572 21.7666 17.1243 21.9003C16.8914 22.0341 16.6048 22.0332 16.3728 21.8978L10.7504 18.6179L5.12797 21.8978C4.89599 22.0332 4.60936 22.0341 4.37648 21.9003C4.14359 21.7666 4 21.5185 4 21.2499V6.74814ZM6.25013 5.99805C5.83589 5.99805 5.50008 6.33387 5.50008 6.74814V19.944L10.3725 17.1016C10.606 16.9653 10.8948 16.9653 11.1283 17.1016L16.0007 19.944V6.74814C16.0007 6.33387 15.6649 5.99805 15.2506 5.99805H6.25013ZM15.2497 2C17.8732 2 20 4.12691 20 6.75058V18.6232C20 19.0374 19.6642 19.3733 19.25 19.3733C18.8357 19.3733 18.4999 19.0374 18.4999 18.6232V6.75058C18.4999 4.95543 17.0448 3.50018 15.2497 3.50018H6.63687C6.63687 3.50018 6.75015 2.94339 7.43379 2.41948C8.00023 2 8.60182 2 8.60182 2H15.2497Z " },
            { FluentSymbol.BookmarkOff24Filled, "M3.28034 2.21968C2.98745 1.92678 2.51257 1.92677 2.21968 2.21966C1.92678 2.51255 1.92677 2.98743 2.21966 3.28032L5.00752 6.06823C5.00423 6.12813 5.00256 6.18846 5.00256 6.24918V21.2451C5.00256 21.8563 5.69444 22.2109 6.19058 21.8539L12.0018 17.673L17.8129 21.8539C18.3091 22.2109 19.001 21.8563 19.001 21.2451V20.062L20.7194 21.7805C21.0123 22.0734 21.4872 22.0734 21.7801 21.7805C22.073 21.4876 22.073 21.0127 21.7801 20.7198L3.28034 2.21968Z M19.001 6.24918V15.8192L6.62021 3.43824C7.0999 3.15908 7.65756 2.99918 8.25256 2.99918H15.751C17.5459 2.99918 19.001 4.45426 19.001 6.24918Z " },
            { FluentSymbol.BookmarkOff24, "M3.28034 2.21968C2.98745 1.92678 2.51257 1.92677 2.21968 2.21966C1.92678 2.51255 1.92677 2.98743 2.21966 3.28032L5.00752 6.06823C5.00423 6.12813 5.00256 6.18846 5.00256 6.24918V21.2451C5.00256 21.8563 5.69444 22.2109 6.19058 21.8539L12.0018 17.673L17.8129 21.8539C18.3091 22.2109 19.001 21.8563 19.001 21.2451V20.062L20.7194 21.7805C21.0123 22.0734 21.4872 22.0734 21.7801 21.7805C22.073 21.4876 22.073 21.0127 21.7801 20.7198L3.28034 2.21968ZM17.501 18.5619V19.7816L12.4398 16.1402C12.1781 15.952 11.8254 15.952 11.5637 16.1402L6.50256 19.7816V7.56331L17.501 18.5619Z M17.501 6.24918V14.3192L19.001 15.8192V6.24918C19.001 4.45426 17.5459 2.99918 15.751 2.99918H8.25256C7.65756 2.99918 7.0999 3.15908 6.62021 3.43824L7.75336 4.57142C7.91155 4.52442 8.07911 4.49918 8.25256 4.49918H15.751C16.7175 4.49918 17.501 5.28269 17.501 6.24918Z " },
            { FluentSymbol.BorderAll24Filled, "M3 6C3 4.34315 4.34315 3 6 3H18C19.6569 3 21 4.34315 21 6V18C21 19.6569 19.6569 21 18 21H6C4.34315 21 3 19.6569 3 18V6ZM13 19H18C18.5523 19 19 18.5523 19 18V13H13V19ZM11 13H5V18C5 18.5523 5.44772 19 6 19H11V13ZM13 11H19V6C19 5.44772 18.5523 5 18 5H13V11ZM11 5H6C5.44772 5 5 5.44772 5 6V11H11V5Z " },
            { FluentSymbol.BorderAll24, "M3 5.75C3 4.23122 4.23122 3 5.75 3H18.25C19.7688 3 21 4.23122 21 5.75V18.25C21 19.7688 19.7688 21 18.25 21H5.75C4.23122 21 3 19.7688 3 18.25V5.75ZM12.75 19.5H18.25C18.9404 19.5 19.5 18.9404 19.5 18.25V12.75H12.75V19.5ZM11.25 12.75H4.5V18.25C4.5 18.9404 5.05964 19.5 5.75 19.5H11.25V12.75ZM12.75 11.25H19.5V5.75C19.5 5.05964 18.9404 4.5 18.25 4.5H12.75V11.25ZM11.25 4.5H5.75C5.05964 4.5 4.5 5.05964 4.5 5.75V11.25H11.25V4.5Z " },
            { FluentSymbol.BorderBottom24Filled, "M13 5C13.5523 5 14 4.55228 14 4C14 3.44772 13.5523 3 13 3H11C10.4477 3 10 3.44772 10 4C10 4.55228 10.4477 5 11 5L13 5Z M5 11C5 10.4477 4.55228 10 4 10C3.44772 10 3 10.4477 3 11V13C3 13.5523 3.44772 14 4 14C4.55228 14 5 13.5523 5 13V11Z M3 18C3 17.4477 3.44772 17 4 17C4.55228 17 5 17.4477 5 18C5 18.5523 5.44772 19 6 19H18C18.5523 19 19 18.5523 19 18C19 17.4477 19.4477 17 20 17C20.5523 17 21 17.4477 21 18C21 19.6569 19.6569 21 18 21H6C4.34315 21 3 19.6569 3 18Z M20 10C19.4477 10 19 10.4477 19 11V13C19 13.5523 19.4477 14 20 14C20.5523 14 21 13.5523 21 13V11C21 10.4477 20.5523 10 20 10Z M7 4C7 3.44772 6.55228 3 6 3C4.34315 3 3 4.34315 3 6C3 6.55228 3.44772 7 4 7C4.55228 7 5 6.55228 5 6C5 5.44772 5.44772 5 6 5C6.55228 5 7 4.55228 7 4Z M18 3C17.4477 3 17 3.44772 17 4C17 4.55228 17.4477 5 18 5C18.5523 5 19 5.44772 19 6C19 6.55228 19.4477 7 20 7C20.5523 7 21 6.55228 21 6C21 4.34315 19.6569 3 18 3Z " },
            { FluentSymbol.BorderBottom24, "M6.25 3C6.66421 3 7 3.33579 7 3.75C7 4.16421 6.66421 4.5 6.25 4.5H5.75C5.05964 4.5 4.5 5.05964 4.5 5.75V6.25C4.5 6.66421 4.16421 7 3.75 7C3.33579 7 3 6.66421 3 6.25V5.75C3 4.23122 4.23122 3 5.75 3H6.25Z M17.75 3C17.3358 3 17 3.33579 17 3.75C17 4.16421 17.3358 4.5 17.75 4.5H18.25C18.9404 4.5 19.5 5.05964 19.5 5.75V6.25C19.5 6.66421 19.8358 7 20.25 7C20.6642 7 21 6.66421 21 6.25V5.75C21 4.23122 19.7688 3 18.25 3H17.75Z M3.75 10C4.16421 10 4.5 10.3358 4.5 10.75V13.25C4.5 13.6642 4.16421 14 3.75 14C3.33579 14 3 13.6642 3 13.25V10.75C3 10.3358 3.33579 10 3.75 10Z M19.5 10.75C19.5 10.3358 19.8358 10 20.25 10C20.6642 10 21 10.3358 21 10.75V13.25C21 13.6642 20.6642 14 20.25 14C19.8358 14 19.5 13.6642 19.5 13.25V10.75Z M14 3.75C14 4.16421 13.6642 4.5 13.25 4.5L10.75 4.5C10.3358 4.5 10 4.16421 10 3.75C10 3.33579 10.3358 3 10.75 3H13.25C13.6642 3 14 3.33579 14 3.75Z M3 17.75C3 17.3358 3.33579 17 3.75 17C4.16421 17 4.5 17.3358 4.5 17.75V18.25C4.5 18.9404 5.05964 19.5 5.75 19.5H18.25C18.9404 19.5 19.5 18.9404 19.5 18.25V17.75C19.5 17.3358 19.8358 17 20.25 17C20.6642 17 21 17.3358 21 17.75V18.25C21 19.7688 19.7688 21 18.25 21H5.75C4.23122 21 3 19.7688 3 18.25V17.75Z " },
            { FluentSymbol.BorderBottomDouble24Filled, "M13 5C13.5523 5 14 4.55228 14 4C14 3.44772 13.5523 3 13 3H11C10.4477 3 10 3.44772 10 4C10 4.55228 10.4477 5 11 5L13 5Z M5 11C5 10.4477 4.55228 10 4 10C3.44772 10 3 10.4477 3 11V13C3 13.5523 3.44772 14 4 14C4.55228 14 5 13.5523 5 13V11Z M4 18C3.44772 18 3 17.5523 3 17C3 16.4477 3.44772 16 4 16H20C20.5523 16 21 16.4477 21 17C21 17.5523 20.5523 18 20 18H4Z M4 21C3.44772 21 3 20.5523 3 20C3 19.4477 3.44772 19 4 19H20C20.5523 19 21 19.4477 21 20C21 20.5523 20.5523 21 20 21H4Z M20 10C19.4477 10 19 10.4477 19 11V13C19 13.5523 19.4477 14 20 14C20.5523 14 21 13.5523 21 13V11C21 10.4477 20.5523 10 20 10Z M7 4C7 3.44772 6.55228 3 6 3C4.34315 3 3 4.34315 3 6C3 6.55228 3.44772 7 4 7C4.55228 7 5 6.55228 5 6C5 5.44772 5.44772 5 6 5C6.55228 5 7 4.55228 7 4Z M18 3C17.4477 3 17 3.44772 17 4C17 4.55228 17.4477 5 18 5C18.5523 5 19 5.44772 19 6C19 6.55228 19.4477 7 20 7C20.5523 7 21 6.55228 21 6C21 4.34315 19.6569 3 18 3Z " },
            { FluentSymbol.BorderBottomDouble24, "M13.25 4.5C13.6642 4.5 14 4.16421 14 3.75C14 3.33579 13.6642 3 13.25 3H10.75C10.3358 3 10 3.33579 10 3.75C10 4.16421 10.3358 4.5 10.75 4.5L13.25 4.5Z M3.75 10C4.16421 10 4.5 10.3358 4.5 10.75V13.25C4.5 13.6642 4.16421 14 3.75 14C3.33579 14 3 13.6642 3 13.25V10.75C3 10.3358 3.33579 10 3.75 10Z M20.25 10C19.8358 10 19.5 10.3358 19.5 10.75V13.25C19.5 13.6642 19.8358 14 20.25 14C20.6642 14 21 13.6642 21 13.25V10.75C21 10.3358 20.6642 10 20.25 10Z M3.75 21C3.33579 21 3 20.6642 3 20.25C3 19.8358 3.33579 19.5 3.75 19.5H20.25C20.6642 19.5 21 19.8358 21 20.25C21 20.6642 20.6642 21 20.25 21H3.75Z M3 17.75C3 18.1642 3.33579 18.5 3.75 18.5H20.25C20.6642 18.5 21 18.1642 21 17.75C21 17.3358 20.6642 17 20.25 17H3.75C3.33579 17 3 17.3358 3 17.75Z M7 3.75C7 3.33579 6.66421 3 6.25 3H5.75C4.23122 3 3 4.23122 3 5.75V6.25C3 6.66421 3.33579 7 3.75 7C4.16421 7 4.5 6.66421 4.5 6.25V5.75C4.5 5.05964 5.05964 4.5 5.75 4.5H6.25C6.66421 4.5 7 4.16421 7 3.75Z M17.75 3C17.3358 3 17 3.33579 17 3.75C17 4.16421 17.3358 4.5 17.75 4.5H18.25C18.9404 4.5 19.5 5.05964 19.5 5.75V6.25C19.5 6.66421 19.8358 7 20.25 7C20.6642 7 21 6.66421 21 6.25V5.75C21 4.23122 19.7688 3 18.25 3H17.75Z " },
            { FluentSymbol.BorderBottomThick24Filled, "M14 4C14 4.55228 13.5523 5 13 5H11C10.4477 5 10 4.55228 10 4C10 3.44772 10.4477 3 11 3L13 3C13.5523 3 14 3.44772 14 4Z M5 11C5 10.4477 4.55228 10 4 10C3.44772 10 3 10.4477 3 11V13C3 13.5523 3.44772 14 4 14C4.55228 14 5 13.5523 5 13V11Z M19 11C19 10.4477 19.4477 10 20 10C20.5523 10 21 10.4477 21 11V13C21 13.5523 20.5523 14 20 14C19.4477 14 19 13.5523 19 13V11Z M6 3C6.55228 3 7 3.44772 7 4C7 4.55228 6.55228 5 6 5C5.44772 5 5 5.44772 5 6C5 6.55228 4.55228 7 4 7C3.44772 7 3 6.55228 3 6C3 4.34315 4.34315 3 6 3Z M17 4C17 3.44772 17.4477 3 18 3C19.6569 3 21 4.34315 21 6C21 6.55228 20.5523 7 20 7C19.4477 7 19 6.55228 19 6C19 5.44772 18.5523 5 18 5C17.4477 5 17 4.55228 17 4Z M5.5 17.25V17.75C5.5 18.1642 5.83579 18.5 6.25 18.5H17.75C18.1642 18.5 18.5 18.1642 18.5 17.75V17.25C18.5 16.5596 19.0596 16 19.75 16C20.4404 16 21 16.5596 21 17.25V18L20.9905 18.0006C20.8626 19.6784 19.4606 21 17.75 21H6.25C4.53939 21 3.13745 19.6784 3.00952 18.0006L3 18V17.25C3 16.5596 3.55964 16 4.25 16C4.94036 16 5.5 16.5596 5.5 17.25Z " },
            { FluentSymbol.BorderBottomThick24, "M14 3.75C14 4.16421 13.6642 4.5 13.25 4.5L10.75 4.5C10.3358 4.5 10 4.16421 10 3.75C10 3.33579 10.3358 3 10.75 3H13.25C13.6642 3 14 3.33579 14 3.75Z M4.5 10.75C4.5 10.3358 4.16421 10 3.75 10C3.33579 10 3 10.3358 3 10.75V13.25C3 13.6642 3.33579 14 3.75 14C4.16421 14 4.5 13.6642 4.5 13.25V10.75Z M19.5 10.75C19.5 10.3358 19.8358 10 20.25 10C20.6642 10 21 10.3358 21 10.75V13.25C21 13.6642 20.6642 14 20.25 14C19.8358 14 19.5 13.6642 19.5 13.25V10.75Z M6.25 3C6.66421 3 7 3.33579 7 3.75C7 4.16421 6.66421 4.5 6.25 4.5H5.75C5.05964 4.5 4.5 5.05964 4.5 5.75V6.25C4.5 6.66421 4.16421 7 3.75 7C3.33579 7 3 6.66421 3 6.25V5.75C3 4.23122 4.23122 3 5.75 3H6.25Z M17 3.75C17 3.33579 17.3358 3 17.75 3H18.25C19.7688 3 21 4.23122 21 5.75V6.25C21 6.66421 20.6642 7 20.25 7C19.8358 7 19.5 6.66421 19.5 6.25V5.75C19.5 5.05964 18.9404 4.5 18.25 4.5H17.75C17.3358 4.5 17 4.16421 17 3.75Z M3 18C3 17.4477 3.44772 17 4 17C4.55228 17 5 17.4477 5 18C5 18.5523 5.44772 19 6 19H18C18.5523 19 19 18.5523 19 18C19 17.4477 19.4477 17 20 17C20.5523 17 21 17.4477 21 18C21 19.6569 19.6569 21 18 21H6C4.34315 21 3 19.6569 3 18Z " },
            { FluentSymbol.BorderLeft24Filled, "M6 21C6.55228 21 7 20.5523 7 20C7 19.4477 6.55228 19 6 19C5.44772 19 5 18.5523 5 18V6C5 5.44772 5.44772 5 6 5C6.55228 5 7 4.55228 7 4C7 3.44772 6.55228 3 6 3C4.34315 3 3 4.34315 3 6V18C3 19.6569 4.34315 21 6 21Z M13 5C13.5523 5 14 4.55228 14 4C14 3.44772 13.5523 3 13 3H11C10.4477 3 10 3.44772 10 4C10 4.55228 10.4477 5 11 5L13 5Z M19 11C19 10.4477 19.4477 10 20 10C20.5523 10 21 10.4477 21 11V13C21 13.5523 20.5523 14 20 14C19.4477 14 19 13.5523 19 13V11Z M14 20C14 20.5523 13.5523 21 13 21H11C10.4477 21 10 20.5523 10 20C10 19.4477 10.4477 19 11 19H13C13.5523 19 14 19.4477 14 20Z M18 3C17.4477 3 17 3.44772 17 4C17 4.55228 17.4477 5 18 5C18.5523 5 19 5.44772 19 6C19 6.55228 19.4477 7 20 7C20.5523 7 21 6.55228 21 6C21 4.34315 19.6569 3 18 3Z M17 20C17 20.5523 17.4477 21 18 21C19.6569 21 21 19.6569 21 18C21 17.4477 20.5523 17 20 17C19.4477 17 19 17.4477 19 18C19 18.5523 18.5523 19 18 19C17.4477 19 17 19.4477 17 20Z " },
            { FluentSymbol.BorderLeft24, "M6.25 3C6.66421 3 7 3.33579 7 3.75C7 4.16421 6.66421 4.5 6.25 4.5H5.75C5.05964 4.5 4.5 5.05964 4.5 5.75V18.25C4.5 18.9404 5.05964 19.5 5.75 19.5H6.25C6.66421 19.5 7 19.8358 7 20.25C7 20.6642 6.66421 21 6.25 21H5.75C4.23122 21 3 19.7688 3 18.25V5.75C3 4.23122 4.23122 3 5.75 3H6.25Z M13.25 4.5C13.6642 4.5 14 4.16421 14 3.75C14 3.33579 13.6642 3 13.25 3H10.75C10.3358 3 10 3.33579 10 3.75C10 4.16421 10.3358 4.5 10.75 4.5L13.25 4.5Z M19.5 10.75C19.5 10.3358 19.8358 10 20.25 10C20.6642 10 21 10.3358 21 10.75V13.25C21 13.6642 20.6642 14 20.25 14C19.8358 14 19.5 13.6642 19.5 13.25V10.75Z M14 20.25C14 20.6642 13.6642 21 13.25 21H10.75C10.3358 21 10 20.6642 10 20.25C10 19.8358 10.3358 19.5 10.75 19.5H13.25C13.6642 19.5 14 19.8358 14 20.25Z M17.75 3C17.3358 3 17 3.33579 17 3.75C17 4.16421 17.3358 4.5 17.75 4.5H18.25C18.9404 4.5 19.5 5.05964 19.5 5.75V6.25C19.5 6.66421 19.8358 7 20.25 7C20.6642 7 21 6.66421 21 6.25V5.75C21 4.23122 19.7688 3 18.25 3H17.75Z M17 20.25C17 20.6642 17.3358 21 17.75 21H18.25C19.7688 21 21 19.7688 21 18.25V17.75C21 17.3358 20.6642 17 20.25 17C19.8358 17 19.5 17.3358 19.5 17.75V18.25C19.5 18.9404 18.9404 19.5 18.25 19.5H17.75C17.3358 19.5 17 19.8358 17 20.25Z " },
            { FluentSymbol.BorderOutside24Filled, "M3 6C3 4.34315 4.34315 3 6 3H18C19.6569 3 21 4.34315 21 6V18C21 19.6569 19.6569 21 18 21H6C4.34315 21 3 19.6569 3 18V6ZM6 5C5.44772 5 5 5.44772 5 6V18C5 18.5523 5.44772 19 6 19H18C18.5523 19 19 18.5523 19 18V6C19 5.44772 18.5523 5 18 5H6Z " },
            { FluentSymbol.BorderOutside24, "M3 5.75C3 4.23122 4.23122 3 5.75 3H18.25C19.7688 3 21 4.23122 21 5.75V18.25C21 19.7688 19.7688 21 18.25 21H5.75C4.23122 21 3 19.7688 3 18.25V5.75ZM5.75 4.5C5.05964 4.5 4.5 5.05964 4.5 5.75V18.25C4.5 18.9404 5.05964 19.5 5.75 19.5H18.25C18.9404 19.5 19.5 18.9404 19.5 18.25V5.75C19.5 5.05964 18.9404 4.5 18.25 4.5H5.75Z " },
            { FluentSymbol.BorderOutsideThick24Filled, "M2.5 5.75C2.5 3.95507 3.95507 2.5 5.75 2.5H18.25C20.0449 2.5 21.5 3.95507 21.5 5.75V18.25C21.5 20.0449 20.0449 21.5 18.25 21.5H5.75C3.95507 21.5 2.5 20.0449 2.5 18.25V5.75ZM5.75 5C5.33579 5 5 5.33579 5 5.75V18.25C5 18.6642 5.33579 19 5.75 19H18.25C18.6642 19 19 18.6642 19 18.25V5.75C19 5.33579 18.6642 5 18.25 5H5.75Z " },
            { FluentSymbol.BorderOutsideThick24, "M3 6C3 4.34315 4.34315 3 6 3H18C19.6569 3 21 4.34315 21 6V18C21 19.6569 19.6569 21 18 21H6C4.34315 21 3 19.6569 3 18V6ZM6 5C5.44772 5 5 5.44772 5 6V18C5 18.5523 5.44772 19 6 19H18C18.5523 19 19 18.5523 19 18V6C19 5.44772 18.5523 5 18 5H6Z " },
            { FluentSymbol.BorderRight24Filled, "M13 5C13.5523 5 14 4.55228 14 4C14 3.44772 13.5523 3 13 3H11C10.4477 3 10 3.44772 10 4C10 4.55228 10.4477 5 11 5L13 5Z M5 11C5 10.4477 4.55228 10 4 10C3.44772 10 3 10.4477 3 11V13C3 13.5523 3.44772 14 4 14C4.55228 14 5 13.5523 5 13V11Z M14 20C14 20.5523 13.5523 21 13 21H11C10.4477 21 10 20.5523 10 20C10 19.4477 10.4477 19 11 19H13C13.5523 19 14 19.4477 14 20Z M6 3C6.55228 3 7 3.44772 7 4C7 4.55228 6.55228 5 6 5C5.44772 5 5 5.44772 5 6C5 6.55228 4.55228 7 4 7C3.44772 7 3 6.55228 3 6C3 4.34315 4.34315 3 6 3Z M7 20C7 20.5523 6.55228 21 6 21C4.34315 21 3 19.6569 3 18C3 17.4477 3.44772 17 4 17C4.55228 17 5 17.4477 5 18C5 18.5523 5.44772 19 6 19C6.55228 19 7 19.4477 7 20Z M18 21C17.4477 21 17 20.5523 17 20C17 19.4477 17.4477 19 18 19C18.5523 19 19 18.5523 19 18V6C19 5.44772 18.5523 5 18 5C17.4477 5 17 4.55228 17 4C17 3.44772 17.4477 3 18 3C19.6569 3 21 4.34315 21 6V18C21 19.6569 19.6569 21 18 21Z " },
            { FluentSymbol.BorderRight24, "M13.25 4.5C13.6642 4.5 14 4.16421 14 3.75C14 3.33579 13.6642 3 13.25 3H10.75C10.3358 3 10 3.33579 10 3.75C10 4.16421 10.3358 4.5 10.75 4.5L13.25 4.5Z M4.5 10.75C4.5 10.3358 4.16421 10 3.75 10C3.33579 10 3 10.3358 3 10.75V13.25C3 13.6642 3.33579 14 3.75 14C4.16421 14 4.5 13.6642 4.5 13.25V10.75Z M14 20.25C14 20.6642 13.6642 21 13.25 21H10.75C10.3358 21 10 20.6642 10 20.25C10 19.8358 10.3358 19.5 10.75 19.5H13.25C13.6642 19.5 14 19.8358 14 20.25Z M6.25 3C6.66421 3 7 3.33579 7 3.75C7 4.16421 6.66421 4.5 6.25 4.5H5.75C5.05964 4.5 4.5 5.05964 4.5 5.75V6.25C4.5 6.66421 4.16421 7 3.75 7C3.33579 7 3 6.66421 3 6.25V5.75C3 4.23122 4.23122 3 5.75 3H6.25Z M7 20.25C7 20.6642 6.66421 21 6.25 21H5.75C4.23122 21 3 19.7688 3 18.25V17.75C3 17.3358 3.33579 17 3.75 17C4.16421 17 4.5 17.3358 4.5 17.75V18.25C4.5 18.9404 5.05964 19.5 5.75 19.5H6.25C6.66421 19.5 7 19.8358 7 20.25Z M17.75 3C17.3358 3 17 3.33579 17 3.75C17 4.16421 17.3358 4.5 17.75 4.5H18.25C18.9404 4.5 19.5 5.05964 19.5 5.75V18.25C19.5 18.9404 18.9404 19.5 18.25 19.5H17.75C17.3358 19.5 17 19.8358 17 20.25C17 20.6642 17.3358 21 17.75 21H18.25C19.7688 21 21 19.7688 21 18.25V5.75C21 4.23122 19.7688 3 18.25 3H17.75Z " },
            { FluentSymbol.BorderTop24Filled, "M3 6C3 6.55228 3.44772 7 4 7C4.55228 7 5 6.55228 5 6C5 5.44772 5.44772 5 6 5H18C18.5523 5 19 5.44772 19 6C19 6.55228 19.4477 7 20 7C20.5523 7 21 6.55228 21 6C21 4.34315 19.6569 3 18 3H6C4.34315 3 3 4.34315 3 6Z M5 11C5 10.4477 4.55228 10 4 10C3.44772 10 3 10.4477 3 11V13C3 13.5523 3.44772 14 4 14C4.55228 14 5 13.5523 5 13V11Z M19 11C19 10.4477 19.4477 10 20 10C20.5523 10 21 10.4477 21 11V13C21 13.5523 20.5523 14 20 14C19.4477 14 19 13.5523 19 13V11Z M14 20C14 20.5523 13.5523 21 13 21H11C10.4477 21 10 20.5523 10 20C10 19.4477 10.4477 19 11 19H13C13.5523 19 14 19.4477 14 20Z M6 21C6.55228 21 7 20.5523 7 20C7 19.4477 6.55228 19 6 19C5.44772 19 5 18.5523 5 18C5 17.4477 4.55228 17 4 17C3.44772 17 3 17.4477 3 18C3 19.6569 4.34315 21 6 21Z M17 20C17 20.5523 17.4477 21 18 21C19.6569 21 21 19.6569 21 18C21 17.4477 20.5523 17 20 17C19.4477 17 19 17.4477 19 18C19 18.5523 18.5523 19 18 19C17.4477 19 17 19.4477 17 20Z " },
            { FluentSymbol.BorderTop24, "M3 6.25C3 6.66421 3.33579 7 3.75 7C4.16421 7 4.5 6.66421 4.5 6.25V5.75C4.5 5.05964 5.05964 4.5 5.75 4.5H18.25C18.9404 4.5 19.5 5.05964 19.5 5.75V6.25C19.5 6.66421 19.8358 7 20.25 7C20.6642 7 21 6.66421 21 6.25V5.75C21 4.23122 19.7688 3 18.25 3H5.75C4.23122 3 3 4.23122 3 5.75V6.25Z M4.5 10.75C4.5 10.3358 4.16421 10 3.75 10C3.33579 10 3 10.3358 3 10.75V13.25C3 13.6642 3.33579 14 3.75 14C4.16421 14 4.5 13.6642 4.5 13.25V10.75Z M19.5 10.75C19.5 10.3358 19.8358 10 20.25 10C20.6642 10 21 10.3358 21 10.75V13.25C21 13.6642 20.6642 14 20.25 14C19.8358 14 19.5 13.6642 19.5 13.25V10.75Z M14 20.25C14 20.6642 13.6642 21 13.25 21H10.75C10.3358 21 10 20.6642 10 20.25C10 19.8358 10.3358 19.5 10.75 19.5H13.25C13.6642 19.5 14 19.8358 14 20.25Z M6.25 21C6.66421 21 7 20.6642 7 20.25C7 19.8358 6.66421 19.5 6.25 19.5H5.75C5.05964 19.5 4.5 18.9404 4.5 18.25V17.75C4.5 17.3358 4.16421 17 3.75 17C3.33579 17 3 17.3358 3 17.75V18.25C3 19.7688 4.23122 21 5.75 21H6.25Z M17 20.25C17 20.6642 17.3358 21 17.75 21H18.25C19.7688 21 21 19.7688 21 18.25V17.75C21 17.3358 20.6642 17 20.25 17C19.8358 17 19.5 17.3358 19.5 17.75V18.25C19.5 18.9404 18.9404 19.5 18.25 19.5H17.75C17.3358 19.5 17 19.8358 17 20.25Z " },
            { FluentSymbol.BorderTopBottom24Filled, "M4 7C3.44772 7 3 6.55228 3 6C3 4.34315 4.34315 3 6 3H18C19.6569 3 21 4.34315 21 6C21 6.55228 20.5523 7 20 7C19.4477 7 19 6.55228 19 6C19 5.44772 18.5523 5 18 5H6C5.44772 5 5 5.44772 5 6C5 6.55228 4.55228 7 4 7Z M5 11C5 10.4477 4.55228 10 4 10C3.44772 10 3 10.4477 3 11V13C3 13.5523 3.44772 14 4 14C4.55228 14 5 13.5523 5 13V11Z M19 11C19 10.4477 19.4477 10 20 10C20.5523 10 21 10.4477 21 11V13C21 13.5523 20.5523 14 20 14C19.4477 14 19 13.5523 19 13V11Z M3 18C3 17.4477 3.44772 17 4 17C4.55228 17 5 17.4477 5 18C5 18.5523 5.44772 19 6 19H18C18.5523 19 19 18.5523 19 18C19 17.4477 19.4477 17 20 17C20.5523 17 21 17.4477 21 18C21 19.6569 19.6569 21 18 21H6C4.34315 21 3 19.6569 3 18Z " },
            { FluentSymbol.BorderTopBottom24, "M3.75 7C3.33579 7 3 6.66421 3 6.25V5.75C3 4.23122 4.23122 3 5.75 3H18.25C19.7688 3 21 4.23122 21 5.75V6.25C21 6.66421 20.6642 7 20.25 7C19.8358 7 19.5 6.66421 19.5 6.25V5.75C19.5 5.05964 18.9404 4.5 18.25 4.5H5.75C5.05964 4.5 4.5 5.05964 4.5 5.75V6.25C4.5 6.66421 4.16421 7 3.75 7Z M4.5 10.75C4.5 10.3358 4.16421 10 3.75 10C3.33579 10 3 10.3358 3 10.75V13.25C3 13.6642 3.33579 14 3.75 14C4.16421 14 4.5 13.6642 4.5 13.25V10.75Z M19.5 10.75C19.5 10.3358 19.8358 10 20.25 10C20.6642 10 21 10.3358 21 10.75V13.25C21 13.6642 20.6642 14 20.25 14C19.8358 14 19.5 13.6642 19.5 13.25V10.75Z M3 17.75C3 17.3358 3.33579 17 3.75 17C4.16421 17 4.5 17.3358 4.5 17.75V18.25C4.5 18.9404 5.05964 19.5 5.75 19.5H18.25C18.9404 19.5 19.5 18.9404 19.5 18.25V17.75C19.5 17.3358 19.8358 17 20.25 17C20.6642 17 21 17.3358 21 17.75V18.25C21 19.7688 19.7688 21 18.25 21H5.75C4.23122 21 3 19.7688 3 18.25V17.75Z " },
            { FluentSymbol.BorderTopBottomDouble24Filled, "M3 6C3 6.55228 3.44772 7 4 7C4.55228 7 5 6.55228 5 6C5 5.44772 5.44772 5 6 5H18C18.5523 5 19 5.44772 19 6C19 6.55228 19.4477 7 20 7C20.5523 7 21 6.55228 21 6C21 4.34315 19.6569 3 18 3H6C4.34315 3 3 4.34315 3 6Z M5 11C5 10.4477 4.55228 10 4 10C3.44772 10 3 10.4477 3 11V13C3 13.5523 3.44772 14 4 14C4.55228 14 5 13.5523 5 13V11Z M4 18C3.44772 18 3 17.5523 3 17C3 16.4477 3.44772 16 4 16H20C20.5523 16 21 16.4477 21 17C21 17.5523 20.5523 18 20 18H4Z M4 21C3.44772 21 3 20.5523 3 20C3 19.4477 3.44772 19 4 19H20C20.5523 19 21 19.4477 21 20C21 20.5523 20.5523 21 20 21H4Z M20 10C19.4477 10 19 10.4477 19 11V13C19 13.5523 19.4477 14 20 14C20.5523 14 21 13.5523 21 13V11C21 10.4477 20.5523 10 20 10Z " },
            { FluentSymbol.BorderTopBottomDouble24, "M3 6.25C3 6.66421 3.33579 7 3.75 7C4.16421 7 4.5 6.66421 4.5 6.25V5.75C4.5 5.05964 5.05964 4.5 5.75 4.5H18.25C18.9404 4.5 19.5 5.05964 19.5 5.75V6.25C19.5 6.66421 19.8358 7 20.25 7C20.6642 7 21 6.66421 21 6.25V5.75C21 4.23122 19.7688 3 18.25 3H5.75C4.23122 3 3 4.23122 3 5.75V6.25Z M3.75 10C4.16421 10 4.5 10.3358 4.5 10.75V13.25C4.5 13.6642 4.16421 14 3.75 14C3.33579 14 3 13.6642 3 13.25V10.75C3 10.3358 3.33579 10 3.75 10Z M20.25 10C19.8358 10 19.5 10.3358 19.5 10.75V13.25C19.5 13.6642 19.8358 14 20.25 14C20.6642 14 21 13.6642 21 13.25V10.75C21 10.3358 20.6642 10 20.25 10Z M3 20.25C3 20.6642 3.33579 21 3.75 21H20.25C20.6642 21 21 20.6642 21 20.25C21 19.8358 20.6642 19.5 20.25 19.5H3.75C3.33579 19.5 3 19.8358 3 20.25Z M3.75 18.5C3.33579 18.5 3 18.1642 3 17.75C3 17.3358 3.33579 17 3.75 17H20.25C20.6642 17 21 17.3358 21 17.75C21 18.1642 20.6642 18.5 20.25 18.5H3.75Z " },
            { FluentSymbol.BorderTopBottomThick24Filled, "M3 6C3 6.55228 3.44772 7 4 7C4.55228 7 5 6.55228 5 6C5 5.44772 5.44772 5 6 5H18C18.5523 5 19 5.44772 19 6C19 6.55228 19.4477 7 20 7C20.5523 7 21 6.55228 21 6C21 4.34315 19.6569 3 18 3H6C4.34315 3 3 4.34315 3 6Z M5 11C5 10.4477 4.55228 10 4 10C3.44772 10 3 10.4477 3 11V13C3 13.5523 3.44772 14 4 14C4.55228 14 5 13.5523 5 13V11Z M5.5 17.25V17.75C5.5 18.1642 5.83579 18.5 6.25 18.5H17.75C18.1642 18.5 18.5 18.1642 18.5 17.75V17.25C18.5 16.5596 19.0596 16 19.75 16C20.4404 16 21 16.5596 21 17.25V18L20.9905 18.0006C20.8626 19.6784 19.4606 21 17.75 21H6.25C4.53939 21 3.13745 19.6784 3.00952 18.0006L3 18V17.25C3 16.5596 3.55964 16 4.25 16C4.94036 16 5.5 16.5596 5.5 17.25Z M20 10C19.4477 10 19 10.4477 19 11V13C19 13.5523 19.4477 14 20 14C20.5523 14 21 13.5523 21 13V11C21 10.4477 20.5523 10 20 10Z " },
            { FluentSymbol.BorderTopBottomThick24, "M3 6.25C3 6.66421 3.33579 7 3.75 7C4.16421 7 4.5 6.66421 4.5 6.25V5.75C4.5 5.05964 5.05964 4.5 5.75 4.5H18.25C18.9404 4.5 19.5 5.05964 19.5 5.75V6.25C19.5 6.66421 19.8358 7 20.25 7C20.6642 7 21 6.66421 21 6.25V5.75C21 4.23122 19.7688 3 18.25 3H5.75C4.23122 3 3 4.23122 3 5.75V6.25Z M4.5 10.75C4.5 10.3358 4.16421 10 3.75 10C3.33579 10 3 10.3358 3 10.75V13.25C3 13.6642 3.33579 14 3.75 14C4.16421 14 4.5 13.6642 4.5 13.25V10.75Z M19.5 10.75C19.5 10.3358 19.8358 10 20.25 10C20.6642 10 21 10.3358 21 10.75V13.25C21 13.6642 20.6642 14 20.25 14C19.8358 14 19.5 13.6642 19.5 13.25V10.75Z M4 17C3.44772 17 3 17.4477 3 18C3 19.6569 4.34315 21 6 21H18C19.6569 21 21 19.6569 21 18C21 17.4477 20.5523 17 20 17C19.4477 17 19 17.4477 19 18C19 18.5523 18.5523 19 18 19H6C5.44772 19 5 18.5523 5 18C5 17.4477 4.55228 17 4 17Z " },
            { FluentSymbol.Bot20Filled, "M14.6907 11.5031C15.69 11.5031 16.5 12.3131 16.5 13.3124V14.0019H16.4947C16.4607 14.7813 16.247 15.7588 15.3718 16.5574C14.4158 17.4297 12.7655 18 10 18C7.23446 18 5.58423 17.4297 4.6282 16.5574C3.75297 15.7588 3.53931 14.7813 3.50533 14.0019H3.5V13.3124C3.5 12.3131 4.31005 11.5031 5.3093 11.5031H14.6907Z M6.5 3C5.67157 3 5 3.67157 5 4.5V8.5C5 9.32843 5.67157 10 6.5 10H13.5C14.3284 10 15 9.32843 15 8.5V4.5C15 3.67157 14.3284 3 13.5 3H10.5C10.5 3 10.5 2.80859 10.5 2.5C10.5 2.19141 10.2761 2 10 2C9.72386 2 9.5 2.23047 9.5 2.5C9.5 2.76953 9.5 3 9.5 3H6.5ZM7 6.5C7 5.94771 7.44772 5.5 8 5.5C8.55228 5.5 9 5.94771 9 6.5C9 7.05228 8.55228 7.5 8 7.5C7.44772 7.5 7 7.05228 7 6.5ZM11 6.5C11 5.94771 11.4477 5.5 12 5.5C12.5523 5.5 13 5.94771 13 6.5C13 7.05228 12.5523 7.5 12 7.5C11.4477 7.5 11 7.05228 11 6.5Z " },
            { FluentSymbol.Bot20, "M12 5.5C11.4477 5.5 11 5.94772 11 6.5C11 7.05228 11.4477 7.5 12 7.5C12.5523 7.5 13 7.05228 13 6.5C13 5.94772 12.5523 5.5 12 5.5Z M7 6.5C7 5.94772 7.44772 5.5 8 5.5C8.55228 5.5 9 5.94772 9 6.5C9 7.05228 8.55228 7.5 8 7.5C7.44772 7.5 7 7.05228 7 6.5Z M10.5 2.5C10.5 2.22386 10.2761 2 10 2C9.72386 2 9.5 2.22386 9.5 2.5V3H6.5C5.67157 3 5 3.67157 5 4.5V8.5C5 9.32843 5.67157 10 6.5 10H13.5C14.3284 10 15 9.32843 15 8.5V4.5C15 3.67157 14.3284 3 13.5 3H10.5V2.5ZM6.5 4H13.5C13.7761 4 14 4.22386 14 4.5V8.5C14 8.77614 13.7761 9 13.5 9H6.5C6.22386 9 6 8.77614 6 8.5V4.5C6 4.22386 6.22386 4 6.5 4Z M10.25 17.9984C12.8656 17.9649 14.4449 17.4031 15.3718 16.5574C16.247 15.7588 16.4607 14.7813 16.4947 14.0019H16.5V13.3124C16.5 12.3131 15.69 11.5031 14.6907 11.5031H11.5V11.5H8.5V11.5031H5.3093C4.31005 11.5031 3.5 12.3131 3.5 13.3124V14.0019H3.50533C3.53931 14.7813 3.75297 15.7588 4.6282 16.5574C5.55506 17.4031 7.13442 17.9649 9.75 17.9984V18H10.25V17.9984ZM5.3093 12.5031H14.6907C15.1377 12.5031 15.5 12.8654 15.5 13.3124V13.75C15.5 14.4396 15.3688 15.2064 14.6978 15.8187C14.0103 16.446 12.6605 17 10 17C7.33946 17 5.98969 16.446 5.30224 15.8187C4.63123 15.2064 4.5 14.4396 4.5 13.75V13.3124C4.5 12.8654 4.86233 12.5031 5.3093 12.5031Z " },
            { FluentSymbol.Bot24Filled, "M17.7529 14.0004C18.9956 14.0004 20.0029 15.0078 20.0029 16.2504V17.1555C20.0029 18.2492 19.5255 19.2883 18.6957 20.0008C17.1302 21.3447 14.8899 22.0016 11.9999 22.0016C9.11038 22.0016 6.87156 21.345 5.30869 20.0013C4.48007 19.2889 4.00342 18.2505 4.00342 17.1577V16.2504C4.00342 15.0078 5.01078 14.0004 6.25342 14.0004H17.7529ZM11.8984 2.00782L12.0002 2.00098C12.3799 2.00098 12.6937 2.28313 12.7434 2.64921L12.7502 2.75098L12.7494 3.49998L16.2499 3.50048C17.4925 3.50048 18.4999 4.50784 18.4999 5.75048V10.2551C18.4999 11.4977 17.4925 12.5051 16.2499 12.5051H7.74988C6.50724 12.5051 5.49988 11.4977 5.49988 10.2551V5.75048C5.49988 4.50784 6.50724 3.50048 7.74988 3.50048L11.2494 3.49998L11.2502 2.75098C11.2502 2.37128 11.5324 2.05749 11.8984 2.00782L12.0002 2.00098L11.8984 2.00782ZM9.74917 6.50048C9.0592 6.50048 8.49988 7.05981 8.49988 7.74977C8.49988 8.43973 9.0592 8.99906 9.74917 8.99906C10.4391 8.99906 10.9985 8.43973 10.9985 7.74977C10.9985 7.05981 10.4391 6.50048 9.74917 6.50048ZM14.2419 6.50048C13.5519 6.50048 12.9926 7.05981 12.9926 7.74977C12.9926 8.43973 13.5519 8.99906 14.2419 8.99906C14.9319 8.99906 15.4912 8.43973 15.4912 7.74977C15.4912 7.05981 14.9319 6.50048 14.2419 6.50048Z " },
            { FluentSymbol.Bot24, "M17.7529 14.0004C18.9956 14.0004 20.0029 15.0078 20.0029 16.2504V17.1555C20.0029 18.2492 19.5255 19.2883 18.6957 20.0008C17.1302 21.3447 14.8899 22.0016 11.9999 22.0016C9.11038 22.0016 6.87156 21.345 5.30869 20.0013C4.48007 19.2889 4.00342 18.2505 4.00342 17.1577V16.2504C4.00342 15.0078 5.01078 14.0004 6.25342 14.0004H17.7529ZM17.7529 15.5004H6.25342C5.8392 15.5004 5.50342 15.8362 5.50342 16.2504V17.1577C5.50342 17.8134 5.78941 18.4364 6.28658 18.8638C7.54467 19.9455 9.44068 20.5016 11.9999 20.5016C14.5599 20.5016 16.4577 19.9451 17.7186 18.8626C18.2165 18.4352 18.5029 17.8117 18.5029 17.1555V16.2504C18.5029 15.8362 18.1671 15.5004 17.7529 15.5004ZM11.8984 2.00782L12.0002 2.00098C12.3799 2.00098 12.6937 2.28313 12.7434 2.64921L12.7502 2.75098L12.7494 3.49998L16.2499 3.50048C17.4925 3.50048 18.4999 4.50784 18.4999 5.75048V10.2551C18.4999 11.4977 17.4925 12.5051 16.2499 12.5051H7.74988C6.50724 12.5051 5.49988 11.4977 5.49988 10.2551V5.75048C5.49988 4.50784 6.50724 3.50048 7.74988 3.50048L11.2494 3.49998L11.2502 2.75098C11.2502 2.37128 11.5324 2.05749 11.8984 2.00782L12.0002 2.00098L11.8984 2.00782ZM16.2499 5.00048H7.74988C7.33566 5.00048 6.99988 5.33627 6.99988 5.75048V10.2551C6.99988 10.6693 7.33566 11.0051 7.74988 11.0051H16.2499C16.6641 11.0051 16.9999 10.6693 16.9999 10.2551V5.75048C16.9999 5.33627 16.6641 5.00048 16.2499 5.00048ZM9.74917 6.50048C10.4391 6.50048 10.9985 7.05981 10.9985 7.74977C10.9985 8.43973 10.4391 8.99906 9.74917 8.99906C9.0592 8.99906 8.49988 8.43973 8.49988 7.74977C8.49988 7.05981 9.0592 6.50048 9.74917 6.50048ZM14.2419 6.50048C14.9319 6.50048 15.4912 7.05981 15.4912 7.74977C15.4912 8.43973 14.9319 8.99906 14.2419 8.99906C13.5519 8.99906 12.9926 8.43973 12.9926 7.74977C12.9926 7.05981 13.5519 6.50048 14.2419 6.50048Z " },
            { FluentSymbol.BotAdd20Filled, "M14.5 9C14.6377 9 14.7741 9.00506 14.9093 9.015C14.968 8.85439 15 8.68094 15 8.5V4.5C15 3.67157 14.3284 3 13.5 3H10.5V2.5C10.5 2.19141 10.2761 2 10 2C9.72386 2 9.5 2.23047 9.5 2.5V3H6.5C5.67157 3 5 3.67157 5 4.5V8.5C5 9.32843 5.67157 10 6.5 10H11.3369C12.2316 9.36997 13.3226 9 14.5 9ZM7 6.5C7 5.94771 7.44772 5.5 8 5.5C8.55228 5.5 9 5.94771 9 6.5C9 7.05228 8.55228 7.5 8 7.5C7.44772 7.5 7 7.05228 7 6.5ZM11 6.5C11 5.94771 11.4477 5.5 12 5.5C12.5523 5.5 13 5.94771 13 6.5C13 7.05228 12.5523 7.5 12 7.5C11.4477 7.5 11 7.05228 11 6.5ZM9 14.5C9 13.3945 9.32614 12.3652 9.88745 11.5031H5.3093C4.31005 11.5031 3.5 12.3131 3.5 13.3124V14.0019H3.50533C3.53931 14.7813 3.75297 15.7588 4.6282 16.5574C5.58423 17.4297 7.23446 18 10 18C10.0863 18 10.1716 17.9994 10.2558 17.9983C9.47127 17.0476 9 15.8289 9 14.5ZM19 14.5C19 16.9853 16.9853 19 14.5 19C12.0147 19 10 16.9853 10 14.5C10 12.0147 12.0147 10 14.5 10C16.9853 10 19 12.0147 19 14.5ZM15 12.5C15 12.2239 14.7761 12 14.5 12C14.2239 12 14 12.2239 14 12.5V14H12.5C12.2239 14 12 14.2239 12 14.5C12 14.7761 12.2239 15 12.5 15H14V16.5C14 16.7761 14.2239 17 14.5 17C14.7761 17 15 16.7761 15 16.5V15H16.5C16.7761 15 17 14.7761 17 14.5C17 14.2239 16.7761 14 16.5 14H15V12.5Z " },
            { FluentSymbol.BotAdd20, "M12 5.5C11.4477 5.5 11 5.94772 11 6.5C11 7.05228 11.4477 7.5 12 7.5C12.5523 7.5 13 7.05228 13 6.5C13 5.94772 12.5523 5.5 12 5.5ZM7 6.5C7 5.94772 7.44772 5.5 8 5.5C8.55228 5.5 9 5.94772 9 6.5C9 7.05228 8.55228 7.5 8 7.5C7.44772 7.5 7 7.05228 7 6.5ZM10.5 2.5C10.5 2.22386 10.2761 2 10 2C9.72386 2 9.5 2.22386 9.5 2.5V3H6.5C5.67157 3 5 3.67157 5 4.5V8.5C5 9.32843 5.67157 10 6.5 10H11.3369C12.2316 9.36997 13.3226 9 14.5 9C14.6377 9 14.7741 9.00506 14.9093 9.015C14.968 8.85439 15 8.68094 15 8.5V4.5C15 3.67157 14.3284 3 13.5 3H10.5V2.5ZM6.5 4H13.5C13.7761 4 14 4.22386 14 4.5V8.5C14 8.77614 13.7761 9 13.5 9H6.5C6.22386 9 6 8.77614 6 8.5V4.5C6 4.22386 6.22386 4 6.5 4ZM8.5 11.5H9.88947C9.68495 11.8137 9.51157 12.1495 9.37373 12.5031H5.3093C4.86233 12.5031 4.5 12.8654 4.5 13.3124V13.75C4.5 14.4396 4.63123 15.2064 5.30224 15.8187C5.95412 16.4135 7.20156 16.9425 9.59747 16.9956C9.78047 17.3544 10.0017 17.6904 10.2558 17.9983L10.25 17.9984V18H9.75V17.9984C7.13442 17.9649 5.55506 17.4031 4.6282 16.5574C3.75297 15.7588 3.53931 14.7813 3.50533 14.0019H3.5V13.3124C3.5 12.3131 4.31005 11.5031 5.3093 11.5031H8.5V11.5ZM19 14.5C19 16.9853 16.9853 19 14.5 19C12.0147 19 10 16.9853 10 14.5C10 12.0147 12.0147 10 14.5 10C16.9853 10 19 12.0147 19 14.5ZM15 12.5C15 12.2239 14.7761 12 14.5 12C14.2239 12 14 12.2239 14 12.5V14H12.5C12.2239 14 12 14.2239 12 14.5C12 14.7761 12.2239 15 12.5 15H14V16.5C14 16.7761 14.2239 17 14.5 17C14.7761 17 15 16.7761 15 16.5V15H16.5C16.7761 15 17 14.7761 17 14.5C17 14.2239 16.7761 14 16.5 14H15V12.5Z " },
            { FluentSymbol.BotAdd24Filled, "M17.4999 12.0005C20.5374 12.0005 22.9999 14.4629 22.9999 17.5005C22.9999 20.538 20.5374 23.0005 17.4999 23.0005C14.4623 23.0005 11.9999 20.538 11.9999 17.5005C11.9999 14.4629 14.4623 12.0005 17.4999 12.0005ZM12.0221 13.9998C11.375 15.0102 10.9999 16.2115 10.9999 17.5005C10.9999 19.1447 11.6103 20.6463 12.617 21.791C11.8148 21.9318 10.9418 22.0016 9.99988 22.0016C7.11038 22.0016 4.87156 21.345 3.30869 20.0013C2.48007 19.2889 2.00342 18.2505 2.00342 17.1577V16.2504C2.00342 15.0078 3.01078 14.0004 4.25342 14.0004L12.0221 13.9998ZM17.4999 13.9997L17.41 14.0078C17.2059 14.0448 17.045 14.2057 17.0079 14.4098L16.9999 14.4997L16.9995 16.9997L14.4975 17.0005L14.4076 17.0085C14.2036 17.0456 14.0426 17.2065 14.0056 17.4106L13.9975 17.5005L14.0056 17.5904C14.0426 17.7945 14.2036 17.9554 14.4076 17.9924L14.4975 18.0005L17.0005 17.9997L17.001 20.504L17.009 20.5938C17.0461 20.7979 17.207 20.9589 17.4111 20.9959L17.501 21.004L17.5909 20.9959C17.795 20.9589 17.9559 20.7979 17.9929 20.5938L18.001 20.504L18.0005 17.9997L20.5044 18.0005L20.5943 17.9924C20.7984 17.9554 20.9593 17.7945 20.9964 17.5904L21.0044 17.5005L20.9964 17.4106C20.9593 17.2065 20.7984 17.0456 20.5943 17.0085L20.5044 17.0005L17.9995 16.9997L17.9999 14.4997L17.9918 14.4098C17.9548 14.2057 17.7938 14.0448 17.5898 14.0078L17.4999 13.9997ZM10.0002 2.00098C10.3799 2.00098 10.6937 2.28313 10.7434 2.64921L10.7502 2.75098L10.7494 3.49998L14.2499 3.50048C15.4925 3.50048 16.4999 4.50784 16.4999 5.75048V10.2551C16.4999 10.5562 16.4407 10.8435 16.3334 11.1061C15.2081 11.3088 14.1839 11.8023 13.3406 12.5052L5.74988 12.5051C4.50724 12.5051 3.49988 11.4977 3.49988 10.2551V5.75048C3.49988 4.50784 4.50724 3.50048 5.74988 3.50048L9.24942 3.49998L9.25021 2.75098C9.25021 2.4058 9.48339 2.11508 9.80083 2.02777L9.89844 2.00782L10.0002 2.00098ZM7.74917 6.50048C7.0592 6.50048 6.49988 7.05981 6.49988 7.74977C6.49988 8.43973 7.0592 8.99906 7.74917 8.99906C8.43913 8.99906 8.99845 8.43973 8.99845 7.74977C8.99845 7.05981 8.43913 6.50048 7.74917 6.50048ZM12.2419 6.50048C11.5519 6.50048 10.9926 7.05981 10.9926 7.74977C10.9926 8.43973 11.5519 8.99906 12.2419 8.99906C12.9319 8.99906 13.4912 8.43973 13.4912 7.74977C13.4912 7.05981 12.9319 6.50048 12.2419 6.50048Z " },
            { FluentSymbol.BotAdd24, "M17.4999 12.0005C20.5374 12.0005 22.9999 14.4629 22.9999 17.5005C22.9999 20.538 20.5374 23.0005 17.4999 23.0005C14.4623 23.0005 11.9999 20.538 11.9999 17.5005C11.9999 14.4629 14.4623 12.0005 17.4999 12.0005ZM12.0221 13.9998C11.7254 14.4631 11.4859 14.9665 11.3135 15.5001L4.25342 15.5004C3.8392 15.5004 3.50342 15.8362 3.50342 16.2504V17.1577C3.50342 17.8134 3.78941 18.4364 4.28658 18.8638C5.54467 19.9455 7.44068 20.5016 9.99988 20.5016C10.5987 20.5016 11.1613 20.4711 11.688 20.4106C11.9369 20.9108 12.2507 21.3745 12.617 21.791C11.8148 21.9318 10.9418 22.0016 9.99988 22.0016C7.11038 22.0016 4.87156 21.345 3.30869 20.0013C2.48007 19.2889 2.00342 18.2505 2.00342 17.1577V16.2504C2.00342 15.0078 3.01078 14.0004 4.25342 14.0004L12.0221 13.9998ZM17.4999 13.9997L17.41 14.0078C17.2059 14.0448 17.045 14.2057 17.0079 14.4098L16.9999 14.4997L16.9995 16.9997L14.4975 17.0005L14.4076 17.0085C14.2036 17.0456 14.0426 17.2065 14.0056 17.4106L13.9975 17.5005L14.0056 17.5904C14.0426 17.7945 14.2036 17.9554 14.4076 17.9924L14.4975 18.0005L17.0005 17.9997L17.001 20.504L17.009 20.5938C17.0461 20.7979 17.207 20.9589 17.4111 20.9959L17.501 21.004L17.5909 20.9959C17.795 20.9589 17.9559 20.7979 17.9929 20.5938L18.001 20.504L18.0005 17.9997L20.5044 18.0005L20.5943 17.9924C20.7984 17.9554 20.9593 17.7945 20.9964 17.5904L21.0044 17.5005L20.9964 17.4106C20.9593 17.2065 20.7984 17.0456 20.5943 17.0085L20.5044 17.0005L17.9995 16.9997L17.9999 14.4997L17.9918 14.4098C17.9548 14.2057 17.7938 14.0448 17.5898 14.0078L17.4999 13.9997ZM10.0002 2.00098C10.3799 2.00098 10.6937 2.28313 10.7434 2.64921L10.7502 2.75098L10.7494 3.49998L14.2499 3.50048C15.4925 3.50048 16.4999 4.50784 16.4999 5.75048V10.2551C16.4999 10.5562 16.4407 10.8435 16.3334 11.1061C15.2081 11.3088 14.1839 11.8023 13.3406 12.5052L5.74988 12.5051C4.50724 12.5051 3.49988 11.4977 3.49988 10.2551V5.75048C3.49988 4.50784 4.50724 3.50048 5.74988 3.50048L9.24942 3.49998L9.25021 2.75098C9.25021 2.4058 9.48339 2.11508 9.80083 2.02777L9.89844 2.00782L10.0002 2.00098ZM14.2499 5.00048H5.74988C5.33566 5.00048 4.99988 5.33627 4.99988 5.75048V10.2551C4.99988 10.6693 5.33566 11.0051 5.74988 11.0051H14.2499C14.6641 11.0051 14.9999 10.6693 14.9999 10.2551V5.75048C14.9999 5.33627 14.6641 5.00048 14.2499 5.00048ZM7.74917 6.50048C8.43913 6.50048 8.99845 7.05981 8.99845 7.74977C8.99845 8.43973 8.43913 8.99906 7.74917 8.99906C7.0592 8.99906 6.49988 8.43973 6.49988 7.74977C6.49988 7.05981 7.0592 6.50048 7.74917 6.50048ZM12.2419 6.50048C12.9319 6.50048 13.4912 7.05981 13.4912 7.74977C13.4912 8.43973 12.9319 8.99906 12.2419 8.99906C11.5519 8.99906 10.9926 8.43973 10.9926 7.74977C10.9926 7.05981 11.5519 6.50048 12.2419 6.50048Z " },
            { FluentSymbol.Branch24Filled, "M4 5.5C4 3.567 5.567 2 7.5 2C9.433 2 11 3.567 11 5.5C11 7.08957 9.94034 8.43164 8.48889 8.85835C9.17675 11.1112 11.272 12.75 13.75 12.75H14.0805C14.4239 11.1774 15.8244 10 17.5 10C19.433 10 21 11.567 21 13.5C21 15.433 19.433 17 17.5 17C15.8244 17 14.4239 15.8226 14.0805 14.25H13.75C11.519 14.25 9.53183 13.2063 8.25 11.5806L8.25 15.0805C9.82259 15.4239 11 16.8244 11 18.5C11 20.433 9.433 22 7.5 22C5.567 22 4 20.433 4 18.5C4 16.8244 5.17741 15.4239 6.75 15.0805L6.75 8.91946C5.17741 8.57612 4 7.17556 4 5.5Z " },
            { FluentSymbol.Branch24, "M4 5.5C4 3.567 5.567 2 7.5 2C9.433 2 11 3.567 11 5.5C11 7.08956 9.94036 8.43162 8.48893 8.85834C9.17679 11.1112 11.272 12.75 13.75 12.75H14.0805C14.4239 11.1774 15.8244 10 17.5 10C19.433 10 21 11.567 21 13.5C21 15.433 19.433 17 17.5 17C15.8244 17 14.4239 15.8226 14.0805 14.25H13.75C11.519 14.25 9.53183 13.2063 8.25 11.5805L8.25 15.0805C9.82259 15.4239 11 16.8244 11 18.5C11 20.433 9.433 22 7.5 22C5.567 22 4 20.433 4 18.5C4 16.8244 5.17741 15.4239 6.75 15.0805L6.75 8.91946C5.17741 8.57612 4 7.17556 4 5.5ZM7.5 3.5C6.39543 3.5 5.5 4.39543 5.5 5.5C5.5 6.60457 6.39543 7.5 7.5 7.5C8.60457 7.5 9.5 6.60457 9.5 5.5C9.5 4.39543 8.60457 3.5 7.5 3.5ZM7.5 16.5C6.39543 16.5 5.5 17.3954 5.5 18.5C5.5 19.6046 6.39543 20.5 7.5 20.5C8.60457 20.5 9.5 19.6046 9.5 18.5C9.5 17.3954 8.60457 16.5 7.5 16.5ZM15.5 13.5C15.5 14.6046 16.3954 15.5 17.5 15.5C18.6046 15.5 19.5 14.6046 19.5 13.5C19.5 12.3954 18.6046 11.5 17.5 11.5C16.3954 11.5 15.5 12.3954 15.5 13.5Z " },
            { FluentSymbol.Briefcase12Filled, "M5 2C4.44772 2 4 2.44772 4 3V4H3.5C2.67157 4 2 4.67157 2 5.5V8.5C2 9.32843 2.67157 10 3.5 10H8.5C9.32843 10 10 9.32843 10 8.5V5.5C10 4.67157 9.32843 4 8.5 4H8V3C8 2.44772 7.55228 2 7 2H5ZM7 4H5V3H7V4Z " },
            { FluentSymbol.Briefcase12, "M4 3C4 2.44772 4.44772 2 5 2H7C7.55228 2 8 2.44772 8 3V4H8.5C9.32843 4 10 4.67157 10 5.5V8.5C10 9.32843 9.32843 10 8.5 10H3.5C2.67157 10 2 9.32843 2 8.5V5.5C2 4.67157 2.67157 4 3.5 4H4V3ZM7 3H5V4H7V3ZM3.5 5C3.22386 5 3 5.22386 3 5.5V8.5C3 8.77614 3.22386 9 3.5 9H8.5C8.77614 9 9 8.77614 9 8.5V5.5C9 5.22386 8.77614 5 8.5 5H3.5Z " },
            { FluentSymbol.Briefcase20Filled, "M7 3.5C7 3.22386 7.22386 3 7.5 3H12.5C12.7761 3 13 3.22386 13 3.5V6H14.5C15.8807 6 17 7.11929 17 8.5V13.5C17 14.8807 15.8807 16 14.5 16H5.5C4.11929 16 3 14.8807 3 13.5V8.5C3 7.11929 4.11929 6 5.5 6H7V3.5ZM12 6V4H8V6H12Z " },
            { FluentSymbol.Briefcase20, "M7.5 3C7.22386 3 7 3.22386 7 3.5V6H5.5C4.11929 6 3 7.11929 3 8.5V13.5C3 14.8807 4.11929 16 5.5 16H14.5C15.8807 16 17 14.8807 17 13.5V8.5C17 7.11929 15.8807 6 14.5 6H13V3.5C13 3.22386 12.7761 3 12.5 3H7.5ZM12 6H8V4H12V6ZM5.5 7H14.5C15.3284 7 16 7.67157 16 8.5V13.5C16 14.3284 15.3284 15 14.5 15H5.5C4.67157 15 4 14.3284 4 13.5V8.5C4 7.67157 4.67157 7 5.5 7Z " },
            { FluentSymbol.Briefcase28Filled, "M9.75 3C9.33579 3 9 3.33579 9 3.75V8H6.75C4.67893 8 3 9.67893 3 11.75V20.25C3 22.3211 4.67893 24 6.75 24H21.25C23.3211 24 25 22.3211 25 20.25V11.75C25 9.67893 23.3211 8 21.25 8H19V3.75C19 3.33579 18.6642 3 18.25 3H9.75ZM17.5 8H10.5V4.5H17.5V8Z " },
            { FluentSymbol.Briefcase28, "M9.75 3C9.33579 3 9 3.33579 9 3.75V8H6.75C4.67893 8 3 9.67893 3 11.75V20.25C3 22.3211 4.67893 24 6.75 24H21.25C23.3211 24 25 22.3211 25 20.25V11.75C25 9.67893 23.3211 8 21.25 8H19V3.75C19 3.33579 18.6642 3 18.25 3H9.75ZM17.5 8H10.5V4.5H17.5V8ZM4.5 11.75C4.5 10.5074 5.50736 9.5 6.75 9.5H21.25C22.4926 9.5 23.5 10.5074 23.5 11.75V20.25C23.5 21.4926 22.4926 22.5 21.25 22.5H6.75C5.50736 22.5 4.5 21.4926 4.5 20.25V11.75Z " },
            { FluentSymbol.Briefcase32Filled, "M11 3C10.4477 3 10 3.44772 10 4V9H8C5.23858 9 3 11.2386 3 14V23C3 25.7614 5.23858 28 8 28H24C26.7614 28 29 25.7614 29 23V14C29 11.2386 26.7614 9 24 9H22V4C22 3.44772 21.5523 3 21 3H11ZM20 9H12V5H20V9Z " },
            { FluentSymbol.Briefcase32, "M11 3C10.4477 3 10 3.44772 10 4V9H8C5.23858 9 3 11.2386 3 14V23C3 25.7614 5.23858 28 8 28H24C26.7614 28 29 25.7614 29 23V14C29 11.2386 26.7614 9 24 9H22V4C22 3.44772 21.5523 3 21 3H11ZM20 9H12V5H20V9ZM8 11H24C25.6569 11 27 12.3431 27 14V23C27 24.6569 25.6569 26 24 26H8C6.34315 26 5 24.6569 5 23V14C5 12.3431 6.34315 11 8 11Z " },
            { FluentSymbol.Briefcase48Filled, "M17.75 6C17.0596 6 16.5 6.55964 16.5 7.25V14H12.25C8.79822 14 6 16.7982 6 20.25V33.75C6 37.2018 8.79822 40 12.25 40H35.75C39.2018 40 42 37.2018 42 33.75V20.25C42 16.7982 39.2018 14 35.75 14H31.5V7.25C31.5 6.55964 30.9404 6 30.25 6H17.75ZM29 14H19V8.5H29V14Z " },
            { FluentSymbol.Briefcase48, "M17.75 6C17.0596 6 16.5 6.55964 16.5 7.25V14H12.25C8.79822 14 6 16.7982 6 20.25V33.75C6 37.2018 8.79822 40 12.25 40H35.75C39.2018 40 42 37.2018 42 33.75V20.25C42 16.7982 39.2018 14 35.75 14H31.5V7.25C31.5 6.55964 30.9404 6 30.25 6H17.75ZM29 14H19V8.5H29V14ZM8.5 20.25C8.5 18.1789 10.1789 16.5 12.25 16.5H35.75C37.8211 16.5 39.5 18.1789 39.5 20.25V33.75C39.5 35.8211 37.8211 37.5 35.75 37.5H12.25C10.1789 37.5 8.5 35.8211 8.5 33.75V20.25Z " },
            { FluentSymbol.Briefcase24Filled, "M15.25 3C15.6642 3 16 3.33579 16 3.75V7H17.75C19.5449 7 21 8.45507 21 10.25V16.75C21 18.5449 19.5449 20 17.75 20H6.25C4.45507 20 3 18.5449 3 16.75V10.25C3 8.45507 4.45507 7 6.25 7H8V3.75C8 3.3703 8.28215 3.05651 8.64823 3.00685L8.75 3H15.25ZM14.5 4.5H9.5V7H14.5V4.5Z " },
            { FluentSymbol.Briefcase24, "M8.75 3H15.25C15.6297 3 15.9435 3.28215 15.9932 3.64823L16 3.75V7H17.75C19.5449 7 21 8.45507 21 10.25V16.75C21 18.5449 19.5449 20 17.75 20H6.25C4.45507 20 3 18.5449 3 16.75V10.25C3 8.45507 4.45507 7 6.25 7H8V3.75C8 3.3703 8.28215 3.05651 8.64823 3.00685L8.75 3H15.25H8.75ZM17.75 8.5H6.25C5.2835 8.5 4.5 9.2835 4.5 10.25V16.75C4.5 17.7165 5.2835 18.5 6.25 18.5H17.75C18.7165 18.5 19.5 17.7165 19.5 16.75V10.25C19.5 9.2835 18.7165 8.5 17.75 8.5ZM14.5 4.5H9.5V7H14.5V4.5Z " },
            { FluentSymbol.BroadActivityFeed24Filled, "M9.24606 14.0013C10.2126 14.0013 10.9961 14.7848 10.9961 15.7513V19.2513C10.9961 20.2178 10.2126 21.0013 9.24606 21.0013H3.75C2.7835 21.0013 2 20.2178 2 19.2513V15.7513C2 14.7848 2.7835 14.0013 3.75 14.0013H9.24606ZM20.25 14.0013C21.2165 14.0013 22 14.7848 22 15.7513V19.2513C22 20.2178 21.2165 21.0013 20.25 21.0013H14.7539C13.7874 21.0013 13.0039 20.2178 13.0039 19.2513V15.7513C13.0039 14.7848 13.7874 14.0013 14.7539 14.0013H20.25ZM20.25 2.99609C21.2165 2.99609 22 3.7796 22 4.74609V10.2495C22 11.216 21.2165 11.9995 20.25 11.9995H3.75C2.7835 11.9995 2 11.216 2 10.2495V4.74609C2 3.82792 2.70711 3.0749 3.60647 3.00189L3.75 2.99609H20.25Z " },
            { FluentSymbol.BroadActivityFeed24, "M9.25498 14.0045C10.2215 14.0045 11.005 14.788 11.005 15.7545V19.2535C11.005 20.2199 10.2215 21.0035 9.25498 21.0035H3.75C2.7835 21.0035 2 20.2199 2 19.2535V15.7545C2 14.788 2.7835 14.0045 3.75 14.0045H9.25498ZM20.25 14.0045C21.2165 14.0045 22 14.788 22 15.7545V19.2535C22 20.2199 21.2165 21.0035 20.25 21.0035H14.745C13.7785 21.0035 12.995 20.2199 12.995 19.2535V15.7545C12.995 14.788 13.7785 14.0045 14.745 14.0045H20.25ZM9.25498 15.5045H3.75C3.61193 15.5045 3.5 15.6165 3.5 15.7545V19.2535C3.5 19.3915 3.61193 19.5035 3.75 19.5035H9.25498C9.39306 19.5035 9.50498 19.3915 9.50498 19.2535V15.7545C9.50498 15.6165 9.39306 15.5045 9.25498 15.5045ZM20.25 15.5045H14.745C14.6069 15.5045 14.495 15.6165 14.495 15.7545V19.2535C14.495 19.3915 14.6069 19.5035 14.745 19.5035H20.25C20.3881 19.5035 20.5 19.3915 20.5 19.2535V15.7545C20.5 15.6165 20.3881 15.5045 20.25 15.5045ZM20.25 3C21.2165 3 22 3.7835 22 4.75V10.25C22 11.2165 21.2165 12 20.25 12H3.75C2.7835 12 2 11.2165 2 10.25V4.75C2 3.83183 2.70711 3.07881 3.60647 3.0058L3.75 3H20.25ZM20.25 4.5H3.75L3.69268 4.5066C3.58223 4.53251 3.5 4.63165 3.5 4.75V10.25C3.5 10.3881 3.61193 10.5 3.75 10.5H20.25C20.3881 10.5 20.5 10.3881 20.5 10.25V4.75C20.5 4.61193 20.3881 4.5 20.25 4.5Z " },
            { FluentSymbol.Broom20Filled, "M17.9099 2.1816C18.1052 2.37687 18.1052 2.69345 17.9099 2.88871L13.2979 7.50077C13.1919 7.37383 13.0793 7.25054 12.9602 7.13137C12.841 7.01218 12.7177 6.89962 12.5907 6.79366L17.2028 2.1816C17.3981 1.98634 17.7146 1.98634 17.9099 2.1816Z M12.2531 7.83847C10.4957 6.08111 7.64645 6.08111 5.88909 7.83847L5.46751 8.26005L11.8315 14.624L12.2531 14.2024C14.0104 12.4451 14.0104 9.59583 12.2531 7.83847Z M1.74276 10.5917L4.64413 8.85086L4.64645 8.8532L11.1465 15.3532C11.178 15.3847 11.2127 15.4112 11.2495 15.4325L9.49982 18.3487C9.4206 18.4808 9.28498 18.5689 9.13216 18.5878C8.97935 18.6066 8.82639 18.5539 8.71752 18.4451L1.64645 11.374C1.53758 11.2651 1.48494 11.1122 1.50375 10.9593C1.52256 10.8065 1.61073 10.6709 1.74276 10.5917Z " },
            { FluentSymbol.Broom20, "M17.9099 2.1816C18.1052 2.37687 18.1052 2.69345 17.9099 2.88871L12.5872 8.21144C14.0023 9.97829 13.8909 12.5646 12.2531 14.2024L11.5895 14.866L9.49982 18.3488C9.4206 18.4808 9.28498 18.569 9.13216 18.5878C8.97935 18.6066 8.82639 18.554 8.71752 18.4451L1.64645 11.374C1.53758 11.2651 1.48494 11.1122 1.50375 10.9594C1.52256 10.8066 1.61073 10.6709 1.74276 10.5917L5.2255 8.50207L5.88909 7.83847C7.52695 6.20062 10.1132 6.08924 11.8801 7.50433L17.2028 2.1816C17.3981 1.98634 17.7146 1.98634 17.9099 2.1816ZM6.24265 8.89913L11.1924 13.8489L11.5459 13.4953C12.9128 12.1285 12.9128 9.91242 11.5459 8.54558C10.1791 7.17875 7.96303 7.17875 6.5962 8.54558L6.24265 8.89913ZM5.45803 9.52874L2.80638 11.1197L8.9718 17.2852L10.5628 14.6335L5.45803 9.52874Z " },
            { FluentSymbol.Broom24Filled, "M22.4523 1.92279C22.7452 2.21569 22.7452 2.69056 22.4523 2.98345L16.1393 9.29646C15.9927 9.11591 15.8353 8.94117 15.6672 8.77309C15.4768 8.58264 15.2778 8.40594 15.0715 8.24301L21.3917 1.92279C21.6846 1.6299 22.1594 1.6299 22.4523 1.92279Z M15.0277 9.3474C12.7822 7.10189 9.14151 7.10189 6.896 9.34741L6.65197 9.59144L14.7837 17.7232L15.0277 17.4791C17.2732 15.2336 17.2732 11.5929 15.0277 9.3474Z M1.88378 12.966L5.49663 10.5574L13.8177 18.8785L11.4091 22.4913C11.2845 22.6783 11.0826 22.7995 10.859 22.8216C10.6354 22.8438 10.4136 22.7645 10.2548 22.6056L1.76948 14.1203C1.6106 13.9615 1.53132 13.7397 1.55346 13.5161C1.5756 13.2925 1.69683 13.0906 1.88378 12.966Z " },
            { FluentSymbol.Broom24, "M22.4524 1.92279C22.7452 2.21569 22.7452 2.69056 22.4524 2.98345L15.5238 9.91202C17.2589 12.1668 17.0935 15.4134 15.0277 17.4791L14.1963 18.3106L11.4091 22.4913C11.2845 22.6783 11.0826 22.7995 10.859 22.8217C10.6354 22.8438 10.4136 22.7645 10.2548 22.6056L1.76948 14.1204C1.6106 13.9615 1.53132 13.7397 1.55346 13.5161C1.5756 13.2925 1.69683 13.0906 1.88378 12.966L6.06475 10.1787L6.89601 9.34742C8.96179 7.28165 12.2083 7.11629 14.4631 8.85136L21.3917 1.92279C21.6846 1.6299 22.1595 1.6299 22.4524 1.92279ZM7.60312 10.7616L13.6135 16.772L13.9671 16.4185C15.6268 14.7588 15.6268 12.0678 13.9671 10.4081C12.3074 8.74835 9.6164 8.74835 7.95668 10.4081L7.60312 10.7616ZM6.44689 11.7267L3.47704 13.7066L10.6685 20.8981L12.6484 17.9282L6.44689 11.7267Z " },
            { FluentSymbol.Bug16Filled, "M7.30005 1.5C7.30005 1.22386 7.07619 1 6.80005 1C6.52391 1 6.30005 1.22386 6.30005 1.5V2.3C6.30005 2.58901 6.37217 2.86118 6.49939 3.09949C5.6334 3.35179 4.96166 4.05998 4.76135 4.94688C4.31954 4.80407 4 4.38935 4 3.9V2.5C4 2.22386 3.77614 2 3.5 2C3.22386 2 3 2.22386 3 2.5V3.9C3 4.923 3.73149 5.77515 4.69995 5.96194V7H2.5C2.22386 7 2 7.22386 2 7.5C2 7.77614 2.22386 8 2.5 8H4.69995V9.7C4.69995 9.80799 4.70514 9.91478 4.71528 10.0201C3.74557 10.1583 3 10.9921 3 12V13.5C3 13.7761 3.22386 14 3.5 14C3.77614 14 4 13.7761 4 13.5V12C4 11.4591 4.42952 11.0184 4.96612 11.0006C5.47087 12.1764 6.63923 13 7.99995 13C9.36067 13 10.529 12.1764 11.0338 11.0006C11.5704 11.0184 12 11.459 12 12V13.5C12 13.7761 12.2239 14 12.5 14C12.7761 14 13 13.7761 13 13.5V12C13 10.9921 12.2544 10.1583 11.2846 10.0201C11.2948 9.91477 11.3 9.80799 11.3 9.7V8H13.5C13.7761 8 14 7.77614 14 7.5C14 7.22386 13.7761 7 13.5 7H11.3V5.96196C12.2685 5.77521 13 4.92303 13 3.9V2.5C13 2.22386 12.7761 2 12.5 2C12.2239 2 12 2.22386 12 2.5V3.9C12 4.38939 11.6804 4.80412 11.2386 4.94691C11.0383 4.06005 10.3666 3.35188 9.50068 3.09953C9.62792 2.86122 9.70005 2.58903 9.70005 2.3V1.5C9.70005 1.22386 9.47619 1 9.20005 1C8.92391 1 8.70005 1.22386 8.70005 1.5V2.3C8.70005 2.6866 8.38665 3 8.00005 3C7.61345 3 7.30005 2.6866 7.30005 2.3V1.5Z " },
            { FluentSymbol.Bug20Filled, "M9 2.5C9 2.22386 8.77614 2 8.5 2C8.22386 2 8 2.22386 8 2.5V3C8 3.39716 8.11577 3.76729 8.3154 4.07847C6.98842 4.38821 6 5.57867 6 7H5.5C4.67157 7 4 6.32843 4 5.5V3.5C4 3.22386 3.77614 3 3.5 3C3.22386 3 3 3.22386 3 3.5V5.5C3 6.88071 4.11929 8 5.5 8H6V9.5H2.5C2.22386 9.5 2 9.72386 2 10C2 10.2761 2.22386 10.5 2.5 10.5H6V12H5.5C4.11929 12 3 13.1193 3 14.5V16.5C3 16.7761 3.22386 17 3.5 17C3.77614 17 4 16.7761 4 16.5V14.5C4 13.6716 4.67157 13 5.5 13H6C6 15.2091 7.79086 17 10 17C12.2091 17 14 15.2091 14 13H14.5C15.3284 13 16 13.6716 16 14.5V16.5C16 16.7761 16.2239 17 16.5 17C16.7761 17 17 16.7761 17 16.5V14.5C17 13.1193 15.8807 12 14.5 12H14V10.5H17.5C17.7761 10.5 18 10.2761 18 10C18 9.72386 17.7761 9.5 17.5 9.5H14V8H14.5C15.8807 8 17 6.88071 17 5.5V3.5C17 3.22386 16.7761 3 16.5 3C16.2239 3 16 3.22386 16 3.5V5.5C16 6.32843 15.3284 7 14.5 7H14C14 5.57867 13.0116 4.38821 11.6846 4.07847C11.8842 3.76729 12 3.39716 12 3V2.5C12 2.22386 11.7761 2 11.5 2C11.2239 2 11 2.22386 11 2.5V3C11 3.55228 10.5523 4 10 4C9.44772 4 9 3.55228 9 3V2.5Z " },
            { FluentSymbol.Bug16, "M7.30005 1.5C7.30005 1.22386 7.07619 1 6.80005 1C6.52391 1 6.30005 1.22386 6.30005 1.5V2.3C6.30005 2.58901 6.37217 2.86118 6.49939 3.09949C5.6334 3.35179 4.96166 4.05998 4.76135 4.94688C4.31954 4.80407 4 4.38935 4 3.9V2.5C4 2.22386 3.77614 2 3.5 2C3.22386 2 3 2.22386 3 2.5V3.9C3 4.923 3.73149 5.77515 4.69995 5.96194V7H2.5C2.22386 7 2 7.22386 2 7.5C2 7.77614 2.22386 8 2.5 8H4.69995V9.7C4.69995 9.80799 4.70514 9.91478 4.71528 10.0201C3.74557 10.1583 3 10.9921 3 12V13.5C3 13.7761 3.22386 14 3.5 14C3.77614 14 4 13.7761 4 13.5V12C4 11.4591 4.42952 11.0184 4.96612 11.0006C5.47087 12.1764 6.63923 13 7.99995 13C9.36067 13 10.529 12.1764 11.0338 11.0006C11.5704 11.0184 12 11.459 12 12V13.5C12 13.7761 12.2239 14 12.5 14C12.7761 14 13 13.7761 13 13.5V12C13 10.9921 12.2544 10.1583 11.2846 10.0201C11.2948 9.91477 11.3 9.80799 11.3 9.7V8H13.5C13.7761 8 14 7.77614 14 7.5C14 7.22386 13.7761 7 13.5 7H11.3V5.96196C12.2685 5.77521 13 4.92303 13 3.9V2.5C13 2.22386 12.7761 2 12.5 2C12.2239 2 12 2.22386 12 2.5V3.9C12 4.38939 11.6804 4.80412 11.2386 4.94691C11.0383 4.06005 10.3666 3.35188 9.50068 3.09953C9.62792 2.86122 9.70005 2.58903 9.70005 2.3V1.5C9.70005 1.22386 9.47619 1 9.20005 1C8.92391 1 8.70005 1.22386 8.70005 1.5V2.3C8.70005 2.6866 8.38665 3 8.00005 3C7.61345 3 7.30005 2.6866 7.30005 2.3V1.5ZM5.7 7.5L5.69995 7.49294V5.50999L5.70005 5.5L5.69998 5.49135C5.70463 4.6669 6.37441 4 7.19995 4H8.79995C9.62838 4 10.3 4.67157 10.3 5.5V9.7C10.3 10.9703 9.27021 12 7.99995 12C6.7297 12 5.69995 10.9703 5.69995 9.7V7.50706L5.7 7.5Z " },
            { FluentSymbol.Bug20, "M9 2.5C9 2.22386 8.77614 2 8.5 2C8.22386 2 8 2.22386 8 2.5V3C8 3.39716 8.11577 3.76729 8.3154 4.07847C6.98842 4.38821 6 5.57867 6 7H5.5C4.67157 7 4 6.32843 4 5.5V3.5C4 3.22386 3.77614 3 3.5 3C3.22386 3 3 3.22386 3 3.5V5.5C3 6.88071 4.11929 8 5.5 8H6V9.5H2.5C2.22386 9.5 2 9.72386 2 10C2 10.2761 2.22386 10.5 2.5 10.5H6V12H5.5C4.11929 12 3 13.1193 3 14.5V16.5C3 16.7761 3.22386 17 3.5 17C3.77614 17 4 16.7761 4 16.5V14.5C4 13.6716 4.67157 13 5.5 13H6C6 15.2091 7.79086 17 10 17C12.2091 17 14 15.2091 14 13H14.5C15.3284 13 16 13.6716 16 14.5V16.5C16 16.7761 16.2239 17 16.5 17C16.7761 17 17 16.7761 17 16.5V14.5C17 13.1193 15.8807 12 14.5 12H14V10.5H17.5C17.7761 10.5 18 10.2761 18 10C18 9.72386 17.7761 9.5 17.5 9.5H14V8H14.5C15.8807 8 17 6.88071 17 5.5V3.5C17 3.22386 16.7761 3 16.5 3C16.2239 3 16 3.22386 16 3.5V5.5C16 6.32843 15.3284 7 14.5 7H14C14 5.57867 13.0116 4.38821 11.6846 4.07847C11.8842 3.76729 12 3.39716 12 3V2.5C12 2.22386 11.7761 2 11.5 2C11.2239 2 11 2.22386 11 2.5V3C11 3.55228 10.5523 4 10 4C9.44772 4 9 3.55228 9 3V2.5ZM13 7V13C13 14.6569 11.6569 16 10 16C8.34315 16 7 14.6569 7 13V7C7 5.89543 7.89543 5 9 5H11C12.1046 5 13 5.89543 13 7Z " },
            { FluentSymbol.Bug24Filled, "M14.25 2.00098C14.6297 2.00098 14.9435 2.28313 14.9932 2.64921L15 2.75098V3.50309C15 4.13585 14.8041 4.72286 14.4696 5.20678C15.8646 5.68497 16.8883 6.96509 16.9914 8.49751L17.2469 8.49759C18.4895 8.49246 19.4927 7.48094 19.4876 6.23831L19.4814 4.75272C19.4797 4.33851 19.8141 4.00133 20.2283 3.99961C20.6425 3.99791 20.9797 4.33231 20.9814 4.74652L20.9876 6.23211C20.9958 8.23635 19.4302 9.87985 17.4522 9.99156L17.2376 9.99761L17 9.99698V11.499L21.2528 11.4996C21.6325 11.4996 21.9463 11.7818 21.996 12.1478L22.0028 12.2496C22.0028 12.6293 21.7207 12.9431 21.3546 12.9928L21.2528 12.9996H17.0004L17 14.999L17.2376 14.9996L17.4522 15.0057C19.3643 15.1136 20.891 16.653 20.9832 18.5659L20.9876 18.7651L20.9814 20.2507C20.9797 20.6649 20.6425 20.9993 20.2283 20.9976C19.8486 20.996 19.536 20.7126 19.4878 20.3463L19.4814 20.2445L19.4876 18.7589C19.4925 17.5681 18.5714 16.5895 17.4009 16.5055L17.2469 16.4996L16.7713 16.4996C16.1343 18.5284 14.239 20.0001 12 20.0001C9.76098 20.0001 7.86569 18.5284 7.22873 16.4996L6.74073 16.4996C5.4981 16.5048 4.49492 17.5163 4.50005 18.7589L4.50619 20.2445C4.50791 20.6587 4.17351 20.9959 3.7593 20.9976C3.34509 20.9993 3.00792 20.6649 3.00621 20.2507L3 18.7651C2.99178 16.7609 4.55736 15.1174 6.5354 15.0057L6.75003 14.9996L7 14.999V12.999L2.75 12.9996C2.3703 12.9996 2.05651 12.7175 2.00685 12.3514L2 12.2496C2 11.8699 2.28215 11.5561 2.64823 11.5065L2.75 11.4996L7 11.499V9.99698L6.75 9.99761L6.53536 9.99155C4.62326 9.88357 3.09658 8.34421 3.00438 6.43128L3 6.23211L3.00617 4.74651C3.00789 4.3323 3.34506 3.9979 3.75927 3.99961C4.13896 4.00118 4.45159 4.28463 4.49973 4.65091L4.50616 4.75271L4.50002 6.23831C4.4951 7.42916 5.41622 8.40776 6.58667 8.49176L6.7407 8.49759L7.00857 8.49751C7.11171 6.96509 8.13544 5.68497 9.53135 5.20555C9.23317 4.7765 9.04526 4.26501 9.00718 3.71223L9 3.50309V2.75098C9 2.33676 9.33579 2.00098 9.75 2.00098C10.1297 2.00098 10.4435 2.28313 10.4932 2.64921L10.5 2.75098V3.50309C10.5 4.33151 11.1716 5.00309 12 5.00309C12.7797 5.00309 13.4204 4.4082 13.4931 3.64755L13.5 3.50309V2.75098C13.5 2.33676 13.8358 2.00098 14.25 2.00098Z " },
            { FluentSymbol.Bug24, "M10.5 2.75098C10.5 2.33676 10.1642 2.00098 9.75 2.00098C9.33579 2.00098 9 2.33676 9 2.75098V3.50309C9 4.13555 9.19571 4.7223 9.52988 5.20608C8.13703 5.68509 7.11506 6.96142 7.00909 8.48994H6.76245L6.75315 8.48992C5.51052 8.48479 4.50733 7.47327 4.51247 6.23064L4.51861 4.74504C4.52032 4.33083 4.18593 3.99366 3.77172 3.99195C3.35751 3.99024 3.02034 4.32463 3.01863 4.73884L3.01248 6.22444C3.00392 8.29549 4.6759 9.98135 6.74695 9.98991L6.76245 9.98994H7V11.4996H2.75C2.33579 11.4996 2 11.8354 2 12.2496C2 12.6638 2.33579 12.9996 2.75 12.9996H7V14.9919H6.76245L6.74695 14.992C4.6759 15.0005 3.00392 16.6864 3.01248 18.7574L3.01863 20.243C3.02034 20.6572 3.35751 20.9916 3.77172 20.9899C4.18593 20.9882 4.52032 20.651 4.51861 20.2368L4.51247 18.7512C4.50733 17.5086 5.51052 16.4971 6.75315 16.492L6.76245 16.4919H7.22633C7.86093 18.5247 9.75816 20.0001 12 20.0001C14.2418 20.0001 16.1391 18.5247 16.7737 16.4919H17.2375L17.2468 16.492C18.4895 16.4971 19.4927 17.5086 19.4875 18.7512L19.4814 20.2368C19.4797 20.651 19.8141 20.9882 20.2283 20.9899C20.6425 20.9916 20.9797 20.6572 20.9814 20.243L20.9875 18.7574C20.9961 16.6864 19.3241 15.0005 17.253 14.992L17.2375 14.9919H17V12.9996H21.2514C21.6656 12.9996 22.0014 12.6638 22.0014 12.2496C22.0014 11.8354 21.6656 11.4996 21.2514 11.4996H17V9.98994H17.2375L17.253 9.98991C19.3241 9.98135 20.9961 8.29549 20.9875 6.22444L20.9814 4.73884C20.9797 4.32463 20.6425 3.99024 20.2283 3.99195C19.8141 3.99366 19.4797 4.33083 19.4814 4.74504L19.4875 6.23064C19.4927 7.47327 18.4895 8.48479 17.2468 8.48992L17.2375 8.48994H16.9909C16.8849 6.96142 15.863 5.6851 14.4701 5.20608C14.8043 4.7223 15 4.13555 15 3.50309V2.75098C15 2.33676 14.6642 2.00098 14.25 2.00098C13.8358 2.00098 13.5 2.33676 13.5 2.75098V3.50309C13.5 4.33151 12.8284 5.00309 12 5.00309C11.1716 5.00309 10.5 4.33151 10.5 3.50309V2.75098ZM8.5 8.75311C8.5 7.51047 9.50736 6.50311 10.75 6.50311H13.25C14.4926 6.50311 15.5 7.51047 15.5 8.75311V15.0001C15.5 16.9331 13.933 18.5001 12 18.5001C10.067 18.5001 8.5 16.9331 8.5 15.0001V8.75311Z " },
            { FluentSymbol.Building20Filled, "M4 3.5C4 2.67157 4.67157 2 5.5 2H11.5C12.3284 2 13 2.67157 13 3.5V8H14.5C15.3284 8 16 8.67157 16 9.5V17.5C16 17.7761 15.7761 18 15.5 18H13V14.5C13 14.2239 12.7761 14 12.5 14H7.5C7.22386 14 7 14.2239 7 14.5V18H4.5C4.22386 18 4 17.7761 4 17.5V3.5ZM6.75 6.5C7.16421 6.5 7.5 6.16421 7.5 5.75C7.5 5.33579 7.16421 5 6.75 5C6.33579 5 6 5.33579 6 5.75C6 6.16421 6.33579 6.5 6.75 6.5ZM7.5 8.75C7.5 8.33579 7.16421 8 6.75 8C6.33579 8 6 8.33579 6 8.75C6 9.16421 6.33579 9.5 6.75 9.5C7.16421 9.5 7.5 9.16421 7.5 8.75ZM6.75 12.5C7.16421 12.5 7.5 12.1642 7.5 11.75C7.5 11.3358 7.16421 11 6.75 11C6.33579 11 6 11.3358 6 11.75C6 12.1642 6.33579 12.5 6.75 12.5ZM10.5 5.75C10.5 5.33579 10.1642 5 9.75 5C9.33579 5 9 5.33579 9 5.75C9 6.16421 9.33579 6.5 9.75 6.5C10.1642 6.5 10.5 6.16421 10.5 5.75ZM9.75 9.5C10.1642 9.5 10.5 9.16421 10.5 8.75C10.5 8.33579 10.1642 8 9.75 8C9.33579 8 9 8.33579 9 8.75C9 9.16421 9.33579 9.5 9.75 9.5ZM10.5 11.75C10.5 11.3358 10.1642 11 9.75 11C9.33579 11 9 11.3358 9 11.75C9 12.1642 9.33579 12.5 9.75 12.5C10.1642 12.5 10.5 12.1642 10.5 11.75ZM12.75 12.5C13.1642 12.5 13.5 12.1642 13.5 11.75C13.5 11.3358 13.1642 11 12.75 11C12.3358 11 12 11.3358 12 11.75C12 12.1642 12.3358 12.5 12.75 12.5Z M12 15V18H10.5V15H12Z M9.5 15H8V18H9.5V15Z " },
            { FluentSymbol.Building20, "M6.75 6.5C7.16421 6.5 7.5 6.16421 7.5 5.75C7.5 5.33579 7.16421 5 6.75 5C6.33579 5 6 5.33579 6 5.75C6 6.16421 6.33579 6.5 6.75 6.5Z M7.5 8.75C7.5 9.16421 7.16421 9.5 6.75 9.5C6.33579 9.5 6 9.16421 6 8.75C6 8.33579 6.33579 8 6.75 8C7.16421 8 7.5 8.33579 7.5 8.75Z M6.75 12.5C7.16421 12.5 7.5 12.1642 7.5 11.75C7.5 11.3358 7.16421 11 6.75 11C6.33579 11 6 11.3358 6 11.75C6 12.1642 6.33579 12.5 6.75 12.5Z M10.5 5.75C10.5 6.16421 10.1642 6.5 9.75 6.5C9.33579 6.5 9 6.16421 9 5.75C9 5.33579 9.33579 5 9.75 5C10.1642 5 10.5 5.33579 10.5 5.75Z M9.75 9.5C10.1642 9.5 10.5 9.16421 10.5 8.75C10.5 8.33579 10.1642 8 9.75 8C9.33579 8 9 8.33579 9 8.75C9 9.16421 9.33579 9.5 9.75 9.5Z M10.5 11.75C10.5 12.1642 10.1642 12.5 9.75 12.5C9.33579 12.5 9 12.1642 9 11.75C9 11.3358 9.33579 11 9.75 11C10.1642 11 10.5 11.3358 10.5 11.75Z M12.75 12.5C13.1642 12.5 13.5 12.1642 13.5 11.75C13.5 11.3358 13.1642 11 12.75 11C12.3358 11 12 11.3358 12 11.75C12 12.1642 12.3358 12.5 12.75 12.5Z M4.5 18C4.22386 18 4 17.7761 4 17.5V3.5C4 2.67157 4.67157 2 5.5 2H11.5C12.3284 2 13 2.67157 13 3.5V8H14.5C15.3284 8 16 8.67157 16 9.5V17.5C16 17.7761 15.7761 18 15.5 18H4.5ZM5 3.5V17H7V14.5C7 14.2239 7.22386 14 7.5 14H12.5C12.7761 14 13 14.2239 13 14.5V17H15V9.5C15 9.22386 14.7761 9 14.5 9H12.5C12.2239 9 12 8.77614 12 8.5V3.5C12 3.22386 11.7761 3 11.5 3H5.5C5.22386 3 5 3.22386 5 3.5ZM12 15H10.5V17H12V15ZM9.5 15H8V17H9.5V15Z " },
            { FluentSymbol.Building24Filled, "M6.75 2C5.50736 2 4.5 3.00736 4.5 4.25V20.75C4.5 21.1642 4.83579 21.5 5.25 21.5H7.5V17.25C7.5 16.8358 7.83579 16.5 8.25 16.5H15.75C16.1642 16.5 16.5 16.8358 16.5 17.25V21.5H18.75C19.1642 21.5 19.5 21.1642 19.5 20.75V11.7493C19.5 10.5067 18.4926 9.4993 17.25 9.4993H16.5V4.25C16.5 3.00736 15.4926 2 14.25 2H6.75ZM7.5 6.5C7.5 5.94772 7.94772 5.5 8.5 5.5C9.05228 5.5 9.5 5.94772 9.5 6.5C9.5 7.05228 9.05228 7.5 8.5 7.5C7.94772 7.5 7.5 7.05228 7.5 6.5ZM8.5 12.5C9.05228 12.5 9.5 12.9477 9.5 13.5C9.5 14.0523 9.05228 14.5 8.5 14.5C7.94772 14.5 7.5 14.0523 7.5 13.5C7.5 12.9477 7.94772 12.5 8.5 12.5ZM7.5 10C7.5 9.44772 7.94772 9 8.5 9C9.05228 9 9.5 9.44772 9.5 10C9.5 10.5523 9.05228 11 8.5 11C7.94772 11 7.5 10.5523 7.5 10ZM12 5.5C12.5523 5.5 13 5.94772 13 6.5C13 7.05228 12.5523 7.5 12 7.5C11.4477 7.5 11 7.05228 11 6.5C11 5.94772 11.4477 5.5 12 5.5ZM11 13.5C11 12.9477 11.4477 12.5 12 12.5C12.5523 12.5 13 12.9477 13 13.5C13 14.0523 12.5523 14.5 12 14.5C11.4477 14.5 11 14.0523 11 13.5ZM15.5 12.5C16.0523 12.5 16.5 12.9477 16.5 13.5C16.5 14.0523 16.0523 14.5 15.5 14.5C14.9477 14.5 14.5 14.0523 14.5 13.5C14.5 12.9477 14.9477 12.5 15.5 12.5ZM11 10C11 9.44772 11.4477 9 12 9C12.5523 9 13 9.44772 13 10C13 10.5523 12.5523 11 12 11C11.4477 11 11 10.5523 11 10Z M15 21.5V18H12.7499V21.5H15Z M11.2499 21.5V18H9V21.5H11.2499Z " },
            { FluentSymbol.Building24, "M8.5 5.5C7.94772 5.5 7.5 5.94772 7.5 6.5C7.5 7.05228 7.94772 7.5 8.5 7.5C9.05229 7.5 9.5 7.05228 9.5 6.5C9.5 5.94772 9.05229 5.5 8.5 5.5Z M7.5 13.5C7.5 12.9477 7.94772 12.5 8.5 12.5C9.05229 12.5 9.5 12.9477 9.5 13.5C9.5 14.0523 9.05229 14.5 8.5 14.5C7.94772 14.5 7.5 14.0523 7.5 13.5Z M8.5 9C7.94772 9 7.5 9.44771 7.5 10C7.5 10.5523 7.94772 11 8.5 11C9.05229 11 9.5 10.5523 9.5 10C9.5 9.44771 9.05229 9 8.5 9Z M11 6.5C11 5.94772 11.4477 5.5 12 5.5C12.5523 5.5 13 5.94772 13 6.5C13 7.05228 12.5523 7.5 12 7.5C11.4477 7.5 11 7.05228 11 6.5Z M12 12.5C11.4477 12.5 11 12.9477 11 13.5C11 14.0523 11.4477 14.5 12 14.5C12.5523 14.5 13 14.0523 13 13.5C13 12.9477 12.5523 12.5 12 12.5Z M14.5 13.5C14.5 12.9477 14.9477 12.5 15.5 12.5C16.0523 12.5 16.5 12.9477 16.5 13.5C16.5 14.0523 16.0523 14.5 15.5 14.5C14.9477 14.5 14.5 14.0523 14.5 13.5Z M12 9C11.4477 9 11 9.44771 11 10C11 10.5523 11.4477 11 12 11C12.5523 11 13 10.5523 13 10C13 9.44771 12.5523 9 12 9Z M6.25 2C5.00736 2 4 3.00736 4 4.25V20.75C4 21.1642 4.33579 21.5 4.75 21.5H19.2528C19.667 21.5 20.0028 21.1642 20.0028 20.75V11.7493C20.0028 10.5067 18.9954 9.4993 17.7528 9.4993H16.5V4.25C16.5 3.00736 15.4926 2 14.25 2H6.25ZM5.5 4.25C5.5 3.83579 5.83579 3.5 6.25 3.5H14.25C14.6642 3.5 15 3.83579 15 4.25V10.2493C15 10.6635 15.3358 10.9993 15.75 10.9993H17.7528C18.167 10.9993 18.5028 11.3351 18.5028 11.7493V20H16.5V17.25C16.5 16.8358 16.1642 16.5 15.75 16.5H8.25C7.83579 16.5 7.5 16.8358 7.5 17.25V20H5.5V4.25ZM15 18V20H12.75V18H15ZM11.25 18V20H9V18H11.25Z " },
            { FluentSymbol.Building16Filled, "M5.5 2C4.67157 2 4 2.67157 4 3.5V13.5C4 13.7761 4.22386 14 4.5 14H6V11.5C6 11.2239 6.22386 11 6.5 11H10.5C10.7761 11 11 11.2239 11 11.5V14H12.5C12.7761 14 13 13.7761 13 13.5V8.5C13 7.67157 12.3284 7 11.5 7H11V3.5C11 2.67157 10.3284 2 9.5 2H5.5ZM7 4.5C7 4.77614 6.77614 5 6.5 5C6.22386 5 6 4.77614 6 4.5C6 4.22386 6.22386 4 6.5 4C6.77614 4 7 4.22386 7 4.5ZM7 7C7 7.27614 6.77614 7.5 6.5 7.5C6.22386 7.5 6 7.27614 6 7C6 6.72386 6.22386 6.5 6.5 6.5C6.77614 6.5 7 6.72386 7 7ZM7 9.5C7 9.77614 6.77614 10 6.5 10C6.22386 10 6 9.77614 6 9.5C6 9.22386 6.22386 9 6.5 9C6.77614 9 7 9.22386 7 9.5ZM9 4.5C9 4.77614 8.77614 5 8.5 5C8.22386 5 8 4.77614 8 4.5C8 4.22386 8.22386 4 8.5 4C8.77614 4 9 4.22386 9 4.5ZM9 7C9 7.27614 8.77614 7.5 8.5 7.5C8.22386 7.5 8 7.27614 8 7C8 6.72386 8.22386 6.5 8.5 6.5C8.77614 6.5 9 6.72386 9 7ZM9 9.5C9 9.77614 8.77614 10 8.5 10C8.22386 10 8 9.77614 8 9.5C8 9.22386 8.22386 9 8.5 9C8.77614 9 9 9.22386 9 9.5ZM11 9.5C11 9.77614 10.7761 10 10.5 10C10.2239 10 10 9.77614 10 9.5C10 9.22386 10.2239 9 10.5 9C10.7761 9 11 9.22386 11 9.5ZM10 14V12H9.00252V14H10ZM8.00252 14V12H7V14H8.00252Z " },
            { FluentSymbol.Building16, "M6.5 5C6.77614 5 7 4.77614 7 4.5C7 4.22386 6.77614 4 6.5 4C6.22386 4 6 4.22386 6 4.5C6 4.77614 6.22386 5 6.5 5ZM7 7C7 7.27614 6.77614 7.5 6.5 7.5C6.22386 7.5 6 7.27614 6 7C6 6.72386 6.22386 6.5 6.5 6.5C6.77614 6.5 7 6.72386 7 7ZM6.5 10C6.77614 10 7 9.77614 7 9.5C7 9.22386 6.77614 9 6.5 9C6.22386 9 6 9.22386 6 9.5C6 9.77614 6.22386 10 6.5 10ZM9 4.5C9 4.77614 8.77614 5 8.5 5C8.22386 5 8 4.77614 8 4.5C8 4.22386 8.22386 4 8.5 4C8.77614 4 9 4.22386 9 4.5ZM8.5 7.5C8.77614 7.5 9 7.27614 9 7C9 6.72386 8.77614 6.5 8.5 6.5C8.22386 6.5 8 6.72386 8 7C8 7.27614 8.22386 7.5 8.5 7.5ZM9 9.5C9 9.77614 8.77614 10 8.5 10C8.22386 10 8 9.77614 8 9.5C8 9.22386 8.22386 9 8.5 9C8.77614 9 9 9.22386 9 9.5ZM10.5 10C10.7761 10 11 9.77614 11 9.5C11 9.22386 10.7761 9 10.5 9C10.2239 9 10 9.22386 10 9.5C10 9.77614 10.2239 10 10.5 10ZM5.5 2C4.67157 2 4 2.67157 4 3.5V13.5C4 13.7761 4.22386 14 4.5 14H12.5C12.7761 14 13 13.7761 13 13.5V8.5C13 7.67157 12.3284 7 11.5 7H11V3.5C11 2.67157 10.3284 2 9.5 2H5.5ZM5 3.5C5 3.22386 5.22386 3 5.5 3H9.5C9.77614 3 10 3.22386 10 3.5V7.5C10 7.77614 10.2239 8 10.5 8H11.5C11.7761 8 12 8.22386 12 8.5V13H11V11.5C11 11.2239 10.7761 11 10.5 11H6.5C6.22386 11 6 11.2239 6 11.5V13H5V3.5ZM10 12V13H9.00252V12H10ZM8.00252 12V13H7V12H8.00252Z " },
            { FluentSymbol.BuildingBank16Filled, "M7.29198 1.71234C7.71018 1.39276 8.29058 1.39276 8.70877 1.71236L13.6713 5.50483C14.3034 5.98788 13.9636 6.99644 13.1698 7.00027H2.83066C2.03687 6.99644 1.69712 5.98786 2.32921 5.50482L7.29198 1.71234ZM8 5.25027C8.41421 5.25027 8.75 4.91449 8.75 4.50027C8.75 4.08606 8.41421 3.75027 8 3.75027C7.58579 3.75027 7.25 4.08606 7.25 4.50027C7.25 4.91449 7.58579 5.25027 8 5.25027Z M3.5 8.00027V11.0003H5V8.00027H3.5Z M6 8.00027V11.0003H7.5V8.00027H6Z M8.5 8.00027V11.0003H10V8.00027H8.5Z M11 8.00027V11.0003H12.5V8.00027H11Z M2 13.2503C2 12.5599 2.55964 12.0003 3.25 12.0003H12.75C13.4404 12.0003 14 12.5599 14 13.2503V13.5003C14 13.7764 13.7761 14.0003 13.5 14.0003H2.5C2.22386 14.0003 2 13.7764 2 13.5003V13.2503Z " },
            { FluentSymbol.BuildingBank16, "M8 4.99988C8.41421 4.99988 8.75 4.66409 8.75 4.24988C8.75 3.83566 8.41421 3.49988 8 3.49988C7.58579 3.49988 7.25 3.83566 7.25 4.24988C7.25 4.66409 7.58579 4.99988 8 4.99988Z M8.73631 1.45383C8.30759 1.10526 7.69315 1.10523 7.2644 1.45377L2.26246 5.5199C1.65374 6.01474 2.00364 6.99987 2.78811 6.99987H3V11.1998C2.40639 11.5032 2 12.1208 2 12.8332V13.4999C2 13.776 2.22386 13.9999 2.5 13.9999H13.5C13.7761 13.9999 14 13.776 14 13.4999V12.8332C14 12.1208 13.5936 11.5032 13 11.1998V6.99987H13.2116C13.9961 6.99987 14.346 6.01481 13.7374 5.51995L8.73631 1.45383ZM7.89518 2.22972C7.95643 2.17993 8.04421 2.17994 8.10546 2.22973L12.7425 5.99987H3.25736L7.89518 2.22972ZM12 10.9999H11V6.99987H12V10.9999ZM10 10.9999H8.5L8.5 6.99987H10V10.9999ZM7.5 10.9999H6V6.99987H7.5L7.5 10.9999ZM12.1667 11.9999C12.6269 11.9999 13 12.373 13 12.8332V12.9999H3V12.8332C3 12.373 3.3731 11.9999 3.83333 11.9999H12.1667ZM5 10.9999H4V6.99987H5V10.9999Z " },
            { FluentSymbol.BuildingBank20Filled, "M9.22808 2.18434C9.69018 1.85652 10.309 1.85652 10.7711 2.18435L16.6226 6.33577C17.3504 6.8521 16.9863 7.99765 16.0951 8.00006L3.90669 8.00006C3.01341 8.00006 2.64773 6.85263 3.37629 6.33576L9.22808 2.18434ZM10.0001 5.8751C10.4603 5.8751 10.8334 5.50201 10.8334 5.04177C10.8334 4.58153 10.4603 4.20844 10.0001 4.20844C9.53984 4.20844 9.16675 4.58153 9.16675 5.04177C9.16675 5.50201 9.53984 5.8751 10.0001 5.8751Z M4.49976 9.00006V13.0001H6.49976V9.00006H4.49976Z M2.99976 16.1667C2.99976 14.9701 3.96981 14.0001 5.16642 14.0001H14.8331C16.0297 14.0001 16.9998 14.9701 16.9998 16.1667V16.5001C16.9998 16.7762 16.7759 17.0001 16.4998 17.0001H3.49976C3.22361 17.0001 2.99976 16.7762 2.99976 16.5001V16.1667Z M15.4998 9.00006V13.0001H13.4998V9.00006H15.4998Z M12.4998 9.00006V13.0001H10.4998V9.00006H12.4998Z M9.49976 9.00006V13.0001H7.49976V9.00006H9.49976Z " },
            { FluentSymbol.BuildingBank20, "M10.0006 5.8751C10.4608 5.8751 10.8339 5.50201 10.8339 5.04177C10.8339 4.58153 10.4608 4.20844 10.0006 4.20844C9.54033 4.20844 9.16724 4.58153 9.16724 5.04177C9.16724 5.50201 9.54033 5.8751 10.0006 5.8751Z M16.0002 13.3407V8.00007H16.0932C16.9865 8.00007 17.3522 6.85264 16.6236 6.33577L10.772 2.18435C10.31 1.85652 9.69115 1.85652 9.22906 2.18434L3.37727 6.33576C2.64871 6.85263 3.01439 8.00007 3.90767 8.00007H4.00024V13.3407C3.39886 13.7257 3.00024 14.3997 3.00024 15.1667V16.5001C3.00024 16.7762 3.2241 17.0001 3.50024 17.0001H16.5002C16.7764 17.0001 17.0002 16.7762 17.0002 16.5001V15.1667C17.0002 14.3997 16.6016 13.7257 16.0002 13.3407ZM9.80767 2.99994C9.92319 2.91799 10.0779 2.91799 10.1934 2.99995L15.8317 7.00007H12.5023L12.5002 7.00006L12.4981 7.00007H4.16915L9.80767 2.99994ZM15.0002 8.00007V13.0064C14.9452 13.0022 14.8897 13.0001 14.8336 13.0001H13.0002L13.0002 8.00007H15.0002ZM5.00024 13.0064V8.00007H7.00024L7.00024 13.0001H5.16691C5.11083 13.0001 5.05525 13.0022 5.00024 13.0064ZM5.16691 14.0001H14.8336C15.4779 14.0001 16.0002 14.5224 16.0002 15.1667V16.0001H4.00024V15.1667C4.00024 14.5224 4.52258 14.0001 5.16691 14.0001ZM9.50024 13.0001H8.00024L8.00024 8.00007H9.50024L9.50024 13.0001ZM10.5002 13.0001L10.5002 8.00007H12.0002L12.0002 13.0001H10.5002Z " },
            { FluentSymbol.BuildingBank24Filled, "M10.9684 2.32465C11.583 1.87616 12.417 1.87616 13.0316 2.32465L20.4534 7.7406C21.4299 8.45315 20.9268 9.99835 19.7189 10.0003H4.28108C3.07318 9.99835 2.57011 8.45315 3.54657 7.7406L10.9684 2.32465ZM13 6.25034C13 5.69805 12.5523 5.25034 12 5.25034C11.4477 5.25034 11 5.69805 11 6.25034C11 6.80262 11.4477 7.25034 12 7.25034C12.5523 7.25034 13 6.80262 13 6.25034Z M11.25 16.0003H9.25V11.0003H11.25V16.0003Z M14.75 16.0003H12.75V11.0003H14.75V16.0003Z M18.5 16.0003H16.25V11.0003H18.5V16.0003Z M18.75 17.0003H5.25C4.00736 17.0003 3 18.0077 3 19.2503V19.7503C3 20.1645 3.33579 20.5003 3.75 20.5003H20.25C20.6642 20.5003 21 20.1645 21 19.7503V19.2503C21 18.0077 19.9926 17.0003 18.75 17.0003Z M7.75 16.0003H5.5V11.0003H7.75V16.0003Z " },
            { FluentSymbol.BuildingBank24, "M13 6.25034C13 6.80262 12.5523 7.25034 12 7.25034C11.4477 7.25034 11 6.80262 11 6.25034C11 5.69805 11.4477 5.25034 12 5.25034C12.5523 5.25034 13 5.69805 13 6.25034Z M13.0316 2.32465C12.417 1.87616 11.583 1.87616 10.9684 2.32465L3.54657 7.7406C2.56949 8.4536 3.07382 10.0003 4.2834 10.0003H4.5L4.5 15.8002C3.60958 16.2554 3 17.1817 3 18.2503V19.7503C3 20.1645 3.33579 20.5003 3.75 20.5003H20.25C20.6642 20.5003 21 20.1645 21 19.7503V18.2503C21 17.1817 20.3904 16.2554 19.5 15.8002V10.0003H19.7166C20.9262 10.0003 21.4305 8.45361 20.4534 7.7406L13.0316 2.32465ZM11.8526 3.53633C11.9404 3.47226 12.0596 3.47226 12.1474 3.53633L18.9499 8.50034H5.05011L11.8526 3.53633ZM18 10.0003V15.5003H16V10.0003H18ZM14.5 10.0003V15.5003H12.75V10.0003H14.5ZM11.25 10.0003V15.5003H9.5L9.5 10.0003H11.25ZM5.75 17.0003H18.25C18.9404 17.0003 19.5 17.56 19.5 18.2503V19.0003H4.5V18.2503C4.5 17.56 5.05964 17.0003 5.75 17.0003ZM6 15.5003L6 10.0003H8L8 15.5003H6Z " },
            { FluentSymbol.BuildingGovernment24Filled, "M15.5 2H11.75C11.3358 2 11 2.33579 11 2.75V6.07089C7.60771 6.55612 5 9.47353 5 13H4.25C3.00736 13 2 14.0074 2 15.25V21.25C2 21.6642 2.33579 22 2.75 22H10C10.1381 22 10.25 21.8881 10.25 21.75V18.75C10.25 18.4739 10.4739 18.25 10.75 18.25H13.25C13.5261 18.25 13.75 18.4739 13.75 18.75V21.75C13.75 21.8881 13.8619 22 14 22H21.25C21.6642 22 22 21.6642 22 21.25V15.25C22 14.0074 20.9926 13 19.75 13H19C19 9.30212 16.1326 6.27396 12.5 6.01758V5H15.5C15.7761 5 16 4.77614 16 4.5V2.5C16 2.22386 15.7761 2 15.5 2ZM15.5 11.75V13.75C15.5 14.1642 15.1642 14.5 14.75 14.5C14.3358 14.5 14 14.1642 14 13.75V11.75C14 11.3358 14.3358 11 14.75 11C15.1642 11 15.5 11.3358 15.5 11.75ZM11.75 11C12.1642 11 12.5 11.3358 12.5 11.75V13.75C12.5 14.1642 12.1642 14.5 11.75 14.5C11.3358 14.5 11 14.1642 11 13.75V11.75C11 11.3358 11.3358 11 11.75 11ZM9.5 11.75V13.75C9.5 14.1642 9.16421 14.5 8.75 14.5C8.33579 14.5 8 14.1642 8 13.75V11.75C8 11.3358 8.33579 11 8.75 11C9.16421 11 9.5 11.3358 9.5 11.75ZM5.75 15.5C6.16421 15.5 6.5 15.8358 6.5 16.25V18.75C6.5 19.1642 6.16421 19.5 5.75 19.5C5.33579 19.5 5 19.1642 5 18.75V16.25C5 15.8358 5.33579 15.5 5.75 15.5ZM19 16.25V18.75C19 19.1642 18.6642 19.5 18.25 19.5C17.8358 19.5 17.5 19.1642 17.5 18.75V16.25C17.5 15.8358 17.8358 15.5 18.25 15.5C18.6642 15.5 19 15.8358 19 16.25Z " },
            { FluentSymbol.BuildingGovernment24, "M15.5 11.75C15.5 11.3358 15.1642 11 14.75 11C14.3358 11 14 11.3358 14 11.75V13.75C14 14.1642 14.3358 14.5 14.75 14.5C15.1642 14.5 15.5 14.1642 15.5 13.75V11.75Z M11.75 11C12.1642 11 12.5 11.3358 12.5 11.75V13.75C12.5 14.1642 12.1642 14.5 11.75 14.5C11.3358 14.5 11 14.1642 11 13.75V11.75C11 11.3358 11.3358 11 11.75 11Z M9.5 11.75C9.5 11.3358 9.16421 11 8.75 11C8.33579 11 8 11.3358 8 11.75V13.75C8 14.1642 8.33579 14.5 8.75 14.5C9.16421 14.5 9.5 14.1642 9.5 13.75V11.75Z M5.75 15.5C6.16421 15.5 6.5 15.8358 6.5 16.25V18.75C6.5 19.1642 6.16421 19.5 5.75 19.5C5.33579 19.5 5 19.1642 5 18.75V16.25C5 15.8358 5.33579 15.5 5.75 15.5Z M19 16.25C19 15.8358 18.6642 15.5 18.25 15.5C17.8358 15.5 17.5 15.8358 17.5 16.25V18.75C17.5 19.1642 17.8358 19.5 18.25 19.5C18.6642 19.5 19 19.1642 19 18.75V16.25Z M11.75 2H15.5C15.7761 2 16 2.22386 16 2.5V4.5C16 4.77614 15.7761 5 15.5 5H12.5V6.01758C16.1326 6.27396 19 9.30212 19 13H19.75C20.9926 13 22 14.0074 22 15.25V21.25C22 21.6642 21.6642 22 21.25 22H2.75C2.33579 22 2 21.6642 2 21.25V15.25C2 14.0074 3.00736 13 4.25 13H5C5 9.47353 7.60771 6.55612 11 6.07089V2.75C11 2.33579 11.3358 2 11.75 2ZM12 7.5C8.96243 7.5 6.5 9.96243 6.5 13V13.75C6.5 14.1642 6.16421 14.5 5.75 14.5H4.25C3.83579 14.5 3.5 14.8358 3.5 15.25V20.5H9.5V17.75C9.5 17.3358 9.83579 17 10.25 17H13.75C14.1642 17 14.5 17.3358 14.5 17.75V20.5H20.5V15.25C20.5 14.8358 20.1642 14.5 19.75 14.5H18.25C17.8358 14.5 17.5 14.1642 17.5 13.75V13C17.5 9.96243 15.0376 7.5 12 7.5ZM13 18.5H11V20.5H13V18.5Z " },
            { FluentSymbol.BuildingGovernment32Filled, "M20.667 2H16C15.4477 2 15 2.44772 15 3V7.05493C10.5001 7.55237 7 11.3674 7 16L5 16C3.34315 16 2 17.3431 2 19V28C2 28.5523 2.44772 29 3 29H13V25C13 24.4477 13.4477 24 14 24H18C18.5523 24 19 24.4477 19 25V29H29C29.5523 29 30 28.5523 30 28V19C30 17.3431 28.6569 16 27 16L25 16C25 11.3674 21.5 7.55237 17 7.05493V6H20.667C21.0352 6 21.3337 5.70152 21.3337 5.33333V2.66667C21.3337 2.29848 21.0352 2 20.667 2ZM12 13C12.5523 13 13 13.4477 13 14V17C13 17.5523 12.5523 18 12 18C11.4477 18 11 17.5523 11 17V14C11 13.4477 11.4477 13 12 13ZM20 13C20.5523 13 21 13.4477 21 14V17C21 17.5523 20.5523 18 20 18C19.4477 18 19 17.5523 19 17V14C19 13.4477 19.4477 13 20 13ZM17 14V17C17 17.5523 16.5523 18 16 18C15.4477 18 15 17.5523 15 17V14C15 13.4477 15.4477 13 16 13C16.5523 13 17 13.4477 17 14ZM8 20C8.55228 20 9 20.4477 9 21V24C9 24.5522 8.55228 25 8 25C7.44772 25 7 24.5522 7 24V21C7 20.4477 7.44772 20 8 20ZM24 20C24.5523 20 25 20.4477 25 21V24C25 24.5522 24.5523 25 24 25C23.4477 25 23 24.5522 23 24V21C23 20.4477 23.4477 20 24 20Z " },
            { FluentSymbol.BuildingGovernment32, "M21 14C21 13.4477 20.5523 13 20 13C19.4477 13 19 13.4477 19 14V17C19 17.5523 19.4477 18 20 18C20.5523 18 21 17.5523 21 17V14Z M16 13C16.5523 13 17 13.4477 17 14V17C17 17.5523 16.5523 18 16 18C15.4477 18 15 17.5523 15 17V14C15 13.4477 15.4477 13 16 13Z M13 14C13 13.4477 12.5523 13 12 13C11.4477 13 11 13.4477 11 14V17C11 17.5523 11.4477 18 12 18C12.5523 18 13 17.5523 13 17V14Z M8 20C8.55228 20 9 20.4477 9 21V24C9 24.5522 8.55228 25 8 25C7.44772 25 7 24.5522 7 24V21C7 20.4477 7.44772 20 8 20Z M25 21C25 20.4477 24.5523 20 24 20C23.4477 20 23 20.4477 23 21V24C23 24.5522 23.4477 25 24 25C24.5523 25 25 24.5522 25 24V21Z M16 2H20.667C21.0352 2 21.3337 2.29848 21.3337 2.66667V5.33333C21.3337 5.70152 21.0352 6 20.667 6H17V7.05493C21.5 7.55237 25 11.3674 25 16L27 16C28.6569 16 30 17.3431 30 19V28C30 28.5523 29.5523 29 29 29H3C2.44772 29 2 28.5523 2 28V19C2 17.3431 3.34315 16 5 16L7 16C7 11.3674 10.5001 7.55237 15 7.05493V3C15 2.44772 15.4477 2 16 2ZM16 9C12.134 9 9 12.134 9 16V17C9 17.5523 8.55228 18 8 18H5C4.44772 18 4 18.4477 4 19V27H12.5V24C12.5 23.4477 12.9477 23 13.5 23H18.5C19.0523 23 19.5 23.4477 19.5 24V27H28V19C28 18.4477 27.5523 18 27 18H24C23.4477 18 23 17.5523 23 17V16C23 12.134 19.866 9 16 9ZM17.5 25H14.5V27H17.5V25Z " },
            { FluentSymbol.BuildingMultiple24Filled, "M7 16C7.55228 16 8 15.5523 8 15C8 14.4477 7.55228 14 7 14C6.44772 14 6 14.4477 6 15C6 15.5523 6.44772 16 7 16Z M8 18C8 18.5523 7.55228 19 7 19C6.44772 19 6 18.5523 6 18C6 17.4477 6.44772 17 7 17C7.55228 17 8 17.4477 8 18Z M7 13C7.55228 13 8 12.5523 8 12C8 11.4477 7.55228 11 7 11C6.44772 11 6 11.4477 6 12C6 12.5523 6.44772 13 7 13Z M8 9C8 9.55228 7.55228 10 7 10C6.44772 10 6 9.55228 6 9C6 8.44771 6.44772 8 7 8C7.55228 8 8 8.44771 8 9Z M7 7C7.55228 7 8 6.55228 8 6C8 5.44772 7.55228 5 7 5C6.44772 5 6 5.44772 6 6C6 6.55228 6.44772 7 7 7Z M14 4.25V5H18.75C19.9926 5 21 6.00736 21 7.25V20.75C21 21.1642 20.6642 21.5 20.25 21.5H17.75C17.4739 21.5 17.25 21.2761 17.25 21V18.75C17.25 18.4739 17.0261 18.25 16.75 18.25H14.25C13.9739 18.25 13.75 18.4739 13.75 18.75V21C13.75 21.2761 13.5261 21.5 13.25 21.5H3.75C3.33579 21.5 3 21.1642 3 20.75V4.25C3 3.00736 4.00736 2 5.25 2H11.75C12.9926 2 14 3.00736 14 4.25ZM5.25 3.5C4.83579 3.5 4.5 3.83579 4.5 4.25V20H10V7.25C10 6.00736 11.0074 5 12.25 5H12.5V4.25C12.5 3.83579 12.1642 3.5 11.75 3.5H5.25ZM18 15C18 14.4477 17.5523 14 17 14C16.4477 14 16 14.4477 16 15C16 15.5523 16.4477 16 17 16C17.5523 16 18 15.5523 18 15ZM14 16C14.5523 16 15 15.5523 15 15C15 14.4477 14.5523 14 14 14C13.4477 14 13 14.4477 13 15C13 15.5523 13.4477 16 14 16ZM18 12C18 11.4477 17.5523 11 17 11C16.4477 11 16 11.4477 16 12C16 12.5523 16.4477 13 17 13C17.5523 13 18 12.5523 18 12ZM14 13C14.5523 13 15 12.5523 15 12C15 11.4477 14.5523 11 14 11C13.4477 11 13 11.4477 13 12C13 12.5523 13.4477 13 14 13ZM18 9C18 8.44772 17.5523 8 17 8C16.4477 8 16 8.44772 16 9C16 9.55228 16.4477 10 17 10C17.5523 10 18 9.55228 18 9ZM14 10C14.5523 10 15 9.55228 15 9C15 8.44772 14.5523 8 14 8C13.4477 8 13 8.44772 13 9C13 9.55228 13.4477 10 14 10Z " },
            { FluentSymbol.BuildingMultiple24, "M8 6C8 6.55228 7.55228 7 7 7C6.44772 7 6 6.55228 6 6C6 5.44772 6.44772 5 7 5C7.55228 5 8 5.44772 8 6Z M7 10C7.55228 10 8 9.55228 8 9C8 8.44772 7.55228 8 7 8C6.44772 8 6 8.44772 6 9C6 9.55228 6.44772 10 7 10Z M8 12C8 12.5523 7.55228 13 7 13C6.44772 13 6 12.5523 6 12C6 11.4477 6.44772 11 7 11C7.55228 11 8 11.4477 8 12Z M8 15C8 15.5523 7.55228 16 7 16C6.44772 16 6 15.5523 6 15C6 14.4477 6.44772 14 7 14C7.55228 14 8 14.4477 8 15Z M7 19C7.55228 19 8 18.5523 8 18C8 17.4477 7.55228 17 7 17C6.44772 17 6 17.4477 6 18C6 18.5523 6.44772 19 7 19Z M14 16C14.5523 16 15 15.5523 15 15C15 14.4477 14.5523 14 14 14C13.4477 14 13 14.4477 13 15C13 15.5523 13.4477 16 14 16Z M17 16C17.5523 16 18 15.5523 18 15C18 14.4477 17.5523 14 17 14C16.4477 14 16 14.4477 16 15C16 15.5523 16.4477 16 17 16Z M17 13C17.5523 13 18 12.5523 18 12C18 11.4477 17.5523 11 17 11C16.4477 11 16 11.4477 16 12C16 12.5523 16.4477 13 17 13Z M15 12C15 12.5523 14.5523 13 14 13C13.4477 13 13 12.5523 13 12C13 11.4477 13.4477 11 14 11C14.5523 11 15 11.4477 15 12Z M17 10C17.5523 10 18 9.55228 18 9C18 8.44772 17.5523 8 17 8C16.4477 8 16 8.44772 16 9C16 9.55228 16.4477 10 17 10Z M15 9C15 9.55228 14.5523 10 14 10C13.4477 10 13 9.55228 13 9C13 8.44772 13.4477 8 14 8C14.5523 8 15 8.44772 15 9Z M14 5V4.25C14 3.00736 12.9926 2 11.75 2H5.25C4.00736 2 3 3.00736 3 4.25V20.75C3 21.1642 3.33579 21.5 3.75 21.5H20.25C20.6642 21.5 21 21.1642 21 20.75V7.25C21 6.00736 19.9926 5 18.75 5H14ZM4.5 4.25C4.5 3.83579 4.83579 3.5 5.25 3.5H11.75C12.1642 3.5 12.5 3.83579 12.5 4.25V5H12.25C11.0074 5 10 6.00736 10 7.25V20H4.5V4.25ZM14.5 20V18.5H16.5V20H14.5ZM18 17.75C18 17.3358 17.6642 17 17.25 17H13.75C13.3358 17 13 17.3358 13 17.75V20H11.5V7.25C11.5 6.83579 11.8358 6.5 12.25 6.5H18.75C19.1642 6.5 19.5 6.83579 19.5 7.25V20H18V17.75Z " },
            { FluentSymbol.BuildingRetail24Filled, "M7.5 11.5V9.5H16.5V11.5H7.5Z M4 3C2.89543 3 2 3.89543 2 5C2 5.74028 2.4022 6.38663 3 6.73244V20.25C3 20.6642 3.33579 21 3.75 21H6V15.75C6 15.3358 6.33579 15 6.75 15H10.75C11.1642 15 11.5 15.3358 11.5 15.75V21H20.25C20.6642 21 21 20.6642 21 20.25V6.73244C21.5978 6.38663 22 5.74028 22 5C22 3.89543 21.1046 3 20 3H4ZM3.5 5C3.5 4.72386 3.72386 4.5 4 4.5H20C20.2761 4.5 20.5 4.72386 20.5 5C20.5 5.27614 20.2761 5.5 20 5.5H4C3.72386 5.5 3.5 5.27614 3.5 5ZM6.75 8H17.25C17.6642 8 18 8.33579 18 8.75V12.25C18 12.6642 17.6642 13 17.25 13H6.75C6.33579 13 6 12.6642 6 12.25V8.75C6 8.33579 6.33579 8 6.75 8ZM14.75 15H17.25C17.6642 15 18 15.3358 18 15.75V18.25C18 18.6642 17.6642 19 17.25 19H14.75C14.3358 19 14 18.6642 14 18.25V15.75C14 15.3358 14.3358 15 14.75 15Z M10 16.5V21H7.5V16.5H10Z " },
            { FluentSymbol.BuildingRetail24, "M6.75 8C6.33579 8 6 8.33579 6 8.75V12.25C6 12.6642 6.33579 13 6.75 13H17.25C17.6642 13 18 12.6642 18 12.25V8.75C18 8.33579 17.6642 8 17.25 8H6.75ZM7.5 11.5V9.5H16.5V11.5H7.5Z M13.75 14C13.3358 14 13 14.3358 13 14.75V17.25C13 17.6642 13.3358 18 13.75 18H17.25C17.6642 18 18 17.6642 18 17.25V14.75C18 14.3358 17.6642 14 17.25 14H13.75ZM14.5 16.5V15.5H16.5V16.5H14.5Z M4 3C2.89543 3 2 3.89543 2 5C2 5.74028 2.4022 6.38663 3 6.73244V20.25C3 20.6642 3.33579 21 3.75 21H20.25C20.6642 21 21 20.6642 21 20.25V6.73244C21.5978 6.38663 22 5.74028 22 5C22 3.89543 21.1046 3 20 3H4ZM19.5 7V19.5H11.5V14.75C11.5 14.3358 11.1642 14 10.75 14H6.75C6.33579 14 6 14.3358 6 14.75V19.5H4.5V7H19.5ZM3.5 5C3.5 4.72386 3.72386 4.5 4 4.5H20C20.2761 4.5 20.5 4.72386 20.5 5C20.5 5.27614 20.2761 5.5 20 5.5H4C3.72386 5.5 3.5 5.27614 3.5 5ZM10 19.5H7.5V15.5H10V19.5Z " },
            { FluentSymbol.BuildingShop16Filled, "M10 10V11H11V10H10Z M4.18768 1.10957L1.68768 3.10957C1.52187 3.24222 1.5 3.47 1.5 3.67V5.5C1.5 6.06291 1.68604 6.58237 2 7.00024V14.5C2 14.7761 2.22386 15 2.5 15H4V9.5C4 9.22386 4.22386 9 4.5 9H7.5C7.77614 9 8 9.22386 8 9.5V15H13.5C13.7761 15 14 14.7761 14 14.5V7.00024C14.314 6.58237 14.5 6.06291 14.5 5.5V3.6655C14.5 3.46513 14.4782 3.24222 14.3124 3.10957L11.8124 1.10957C11.7237 1.03864 11.6136 1 11.5 1H4.50003C4.38649 1 4.27634 1.03864 4.18768 1.10957ZM2.5 5.5V4H5.5V5.5C5.5 6.32843 4.82843 7 4 7C3.17157 7 2.5 6.32843 2.5 5.5ZM6.5 5.5V4H9.5V5.5C9.5 6.32843 8.82843 7 8 7C7.17157 7 6.5 6.32843 6.5 5.5ZM10.5 5.5V4H13.5V5.5C13.5 6.32843 12.8284 7 12 7C11.1716 7 10.5 6.32843 10.5 5.5ZM3.42542 3L4.67542 2H6.02853L5.65353 3H3.42542ZM6.72153 3L7.09653 2H8.88959L9.22292 3H6.72153ZM9.94368 2H11.3246L12.5746 3H10.277L9.94368 2ZM9 9.5C9 9.22386 9.22386 9 9.5 9H11.5C11.7761 9 12 9.22386 12 9.5V11.5C12 11.7761 11.7761 12 11.5 12H9.5C9.22386 12 9 11.7761 9 11.5V9.5Z M5 15H7V10H5V15Z " },
            { FluentSymbol.BuildingShop16, "M9 9.5C9 9.22386 9.22386 9 9.5 9H11.5C11.7761 9 12 9.22386 12 9.5V11.5C12 11.7761 11.7761 12 11.5 12H9.5C9.22386 12 9 11.7761 9 11.5V9.5ZM10 11H11V10H10V11Z M4.18768 1.10957L1.68768 3.10957C1.52187 3.24222 1.5 3.47 1.5 3.67V5.5C1.5 6.06291 1.68604 6.58237 2 7.00024V14.5C2 14.7761 2.22386 15 2.5 15H13.5C13.7761 15 14 14.7761 14 14.5V7.00024C14.314 6.58237 14.5 6.06291 14.5 5.5V3.6655C14.5 3.46513 14.4782 3.24222 14.3124 3.10957L11.8124 1.10957C11.7237 1.03864 11.6136 1 11.5 1H4.50003C4.38649 1 4.27634 1.03864 4.18768 1.10957ZM5.5 4V5.5C5.5 6.32843 4.82843 7 4 7C3.17157 7 2.5 6.32843 2.5 5.5V4H5.5ZM9.5 4V5.5C9.5 6.32843 8.82843 7 8 7C7.17157 7 6.5 6.32843 6.5 5.5V4H9.5ZM13.5 4V5.5C13.5 6.32843 12.8284 7 12 7C11.1716 7 10.5 6.32843 10.5 5.5V4H13.5ZM6.02853 2L5.65353 3H3.42542L4.67542 2H6.02853ZM6.72153 3L7.09653 2H8.88959L9.22292 3H6.72153ZM9.94368 2H11.3246L12.5746 3H10.277L9.94368 2ZM13 7.79198V14H8V9.5C8 9.22386 7.77614 9 7.5 9H4.5C4.22386 9 4 9.22386 4 9.5V14H3V7.79198C3.30623 7.92578 3.64445 8 4 8C4.8178 8 5.54389 7.60733 6 7.00024C6.45612 7.60733 7.1822 8 8 8C8.8178 8 9.54389 7.60733 10 7.00024C10.4561 7.60733 11.1822 8 12 8C12.3556 8 12.6938 7.92578 13 7.79198ZM7 14H5V10H7V14Z " },
            { FluentSymbol.BuildingShop20Filled, "M12 12H14V14H12V12Z M5.00001 2H15C15.1484 2 15.2891 2.06591 15.3841 2.17991L17.8841 5.17991C18.0009 5.32003 18.0005 5.39121 18.0001 5.48233L18 5.5V7C18 7.8885 17.6137 8.68679 17 9.23611V17.5C17 17.7761 16.7761 18 16.5 18H10V11.5C10 11.2239 9.77614 11 9.5 11H5.5C5.22386 11 5 11.2239 5 11.5V18H3.5C3.22386 18 3 17.7761 3 17.5V9.23611C2.38625 8.68679 2 7.8885 2 7V5.5C2.00002 5.3852 2.03955 5.27152 2.1159 5.17991L4.6159 2.17991C4.71089 2.06591 4.85162 2 5.00001 2ZM3 6V7C3 8.10457 3.89543 9 5 9C6.10457 9 7 8.10457 7 7V6H3ZM8 6V7C8 8.10457 8.89543 9 10 9C11.1046 9 12 8.10457 12 7V6H8ZM13 6V7C13 8.10457 13.8954 9 15 9C16.1046 9 17 8.10457 17 7V6H13ZM5.23419 3L3.56753 5H7.13964L7.8063 3H5.23419ZM11.8063 5L11.1396 3H8.8604L8.19373 5H11.8063ZM12.8604 5H16.4325L14.7658 3H12.1937L12.8604 5ZM11 11.5V14.5C11 14.7761 11.2239 15 11.5 15H14.5C14.7761 15 15 14.7761 15 14.5V11.5C15 11.2239 14.7761 11 14.5 11H11.5C11.2239 11 11 11.2239 11 11.5Z M9 18V12H6V18H9Z " },
            { FluentSymbol.BuildingShop20, "M11 11.5V14.5C11 14.7761 11.2239 15 11.5 15H14.5C14.7761 15 15 14.7761 15 14.5V11.5C15 11.2239 14.7761 11 14.5 11H11.5C11.2239 11 11 11.2239 11 11.5ZM12 14V12H14V14H12Z M5.00001 2C4.85162 2 4.71089 2.06591 4.6159 2.17991L2.1159 5.17991C2.03955 5.27152 2.00002 5.3852 2 5.5V7C2 7.8885 2.38625 8.68679 3 9.23611V17.5C3 17.7761 3.22386 18 3.5 18H16.5C16.7761 18 17 17.7761 17 17.5V9.23611C17.6137 8.68679 18 7.8885 18 7V5.5C18 5.49401 18 5.48813 18.0001 5.48233C18.0005 5.39121 18.0009 5.32003 17.8841 5.17991L15.3841 2.17991C15.2891 2.06591 15.1484 2 15 2H5.00001ZM5 9C3.89543 9 3 8.10457 3 7V6H7V7C7 8.10457 6.10457 9 5 9ZM10 9C8.89543 9 8 8.10457 8 7V6H12V7C12 8.10457 11.1046 9 10 9ZM15 9C13.8954 9 13 8.10457 13 7V6H17V7C17 8.10457 16.1046 9 15 9ZM5 17H4V9.82929C4.31278 9.93985 4.64936 10 5 10C6.04349 10 6.96254 9.46725 7.5 8.6589C8.03746 9.46725 8.95651 10 10 10C11.0435 10 11.9625 9.46724 12.5 8.65889C13.0375 9.46724 13.9565 10 15 10C15.3506 10 15.6872 9.93985 16 9.82929V17H10V11.5C10 11.2239 9.77614 11 9.5 11H5.5C5.22386 11 5 11.2239 5 11.5V17ZM7.13964 5H3.56753L5.23419 3H7.8063L7.13964 5ZM11.8063 5H8.19373L8.8604 3H11.1396L11.8063 5ZM12.8604 5L12.1937 3H14.7658L16.4325 5H12.8604ZM6 17V12H9V17H6Z " },
            { FluentSymbol.BuildingShop24Filled, "M10.4949 14.501L10.4941 21.999H7.49913L7.49989 14.501H10.4949ZM17.2546 13.001H13.7532C13.339 13.001 13.0032 13.3368 13.0032 13.751V17.253C13.0032 17.6672 13.339 18.003 13.7532 18.003H17.2546C17.6688 18.003 18.0046 17.6672 18.0046 17.253V13.751C18.0046 13.3368 17.6688 13.001 17.2546 13.001ZM16.5039 14.501V16.503H14.5029V14.501H16.5039ZM8.16589 7.002H3.50089L3.501 8.16674C3.501 9.34763 4.37852 10.3236 5.51705 10.478L5.67387 10.4939L5.83357 10.4993C7.06813 10.4993 8.07869 9.54019 8.16076 8.32644L8.16614 8.16674L8.16589 7.002ZM14.3309 7.002H9.66589L9.66614 8.16674C9.66614 9.34763 10.5437 10.3236 11.6822 10.478L11.839 10.4939L11.9987 10.4993C13.2333 10.4993 14.2438 9.54019 14.3259 8.32644L14.3313 8.16674L14.3309 7.002ZM20.4979 7.002H15.8329L15.8336 8.16674C15.8336 9.34763 16.7112 10.3236 17.8497 10.478L18.0065 10.4939L18.1662 10.4993C19.4008 10.4993 20.4113 9.54019 20.4934 8.32644L20.4988 8.16674L20.4979 7.002ZM9.06051 3.5H6.32589L4.46889 5.502H8.44551L9.06051 3.5ZM13.3685 3.5H10.6305L10.0145 5.502H13.9845L13.3685 3.5ZM17.6729 3.5H14.9385L15.5535 5.502H19.5299L17.6729 3.5ZM2.20117 5.74193L5.45006 2.23991C5.56833 2.11243 5.7264 2.03081 5.89656 2.00715L5.99989 2H17.9999C18.1738 2 18.3411 2.06037 18.4742 2.16902L18.5497 2.23991L21.822 5.76824L21.8527 5.80714C21.9544 5.94281 22.0003 6.09665 22.0003 6.24775L21.9988 8.16674C21.9988 9.16092 21.6202 10.0667 20.9994 10.7478L20.9986 21.25C20.9986 21.6297 20.7165 21.9435 20.3504 21.9932L20.2486 22L11.9951 21.999L11.9958 13.751C11.9958 13.3368 11.6601 13.001 11.2458 13.001H6.74989C6.33568 13.001 5.99989 13.3368 5.99989 13.751L5.99913 21.999L3.75113 22C3.37144 22 3.05764 21.7178 3.00798 21.3518L3.00113 21.25L3.00035 10.7478C2.42084 10.112 2.05244 9.28045 2.00598 8.36396L2.001 8.16674L2.0008 6.29097C1.99273 6.15366 2.02238 6.01238 2.09673 5.88313L2.14651 5.807L2.20117 5.74193Z " },
            { FluentSymbol.BuildingShop24, "M17.9999 2C18.1738 2 18.3411 2.06037 18.4742 2.16902L18.5497 2.23991L21.822 5.76824L21.8527 5.80714C21.9544 5.94281 22.0003 6.09665 22.0003 6.24775L21.9988 8.16674C21.9988 9.16092 21.6202 10.0667 20.9994 10.7478L20.9986 21.25C20.9986 21.6297 20.7165 21.9435 20.3504 21.9932L20.2486 22H3.75113C3.37144 22 3.05764 21.7178 3.00798 21.3518L3.00113 21.25L3.00035 10.7478C2.42729 10.1191 2.06067 9.29893 2.00765 8.39453L2.001 8.16674L2.0008 6.29097C1.99273 6.15366 2.02238 6.01238 2.09673 5.88313L2.16199 5.78767L2.20117 5.74193L5.45006 2.23991C5.56833 2.11243 5.7264 2.03081 5.89656 2.00715L5.99989 2H17.9999ZM15.0818 10.4421L15.0699 10.4598C14.371 11.3944 13.2555 11.9993 11.9987 11.9993C10.7349 11.9993 9.61393 11.3876 8.9158 10.4441C8.21835 11.3876 7.0974 11.9993 5.83357 11.9993C5.36446 11.9993 4.91504 11.915 4.49962 11.7608L4.50089 20.499H5.99951L5.99989 13.751C5.99989 13.3713 6.28204 13.0575 6.64812 13.0079L6.74989 13.001H11.2458C11.6255 13.001 11.9393 13.2832 11.989 13.6492L11.9958 13.751L11.9955 20.499H19.4979L19.4981 11.7615C19.0833 11.9153 18.6346 11.9993 18.1662 11.9993C16.9015 11.9993 15.7799 11.3867 15.0818 10.4421ZM10.4949 14.501H7.49989V20.499H10.4949V14.501ZM17.2546 13.001C17.6343 13.001 17.9481 13.2832 17.9978 13.6492L18.0046 13.751V17.253C18.0046 17.6327 17.7225 17.9465 17.3564 17.9962L17.2546 18.003H13.7532C13.3735 18.003 13.0597 17.7209 13.01 17.3548L13.0032 17.253V13.751C13.0032 13.3713 13.2853 13.0575 13.6514 13.0079L13.7532 13.001H17.2546ZM16.5039 14.501H14.5029V16.503H16.5039V14.501ZM8.16589 7.002H3.50089L3.501 8.16674L3.50717 8.33777L3.53555 8.569L3.5683 8.72528L3.61768 8.89726L3.67203 9.0451L3.71271 9.1391C3.74388 9.20697 3.77821 9.27309 3.81551 9.33727L3.91846 9.49873L3.97274 9.57344L4.10151 9.72909L4.24329 9.87318L4.33953 9.95811L4.38162 9.99243C4.69615 10.2429 5.07686 10.4138 5.49329 10.4747L5.67387 10.4939L5.83357 10.4993C7.06813 10.4993 8.07869 9.54019 8.16076 8.32644L8.16614 8.16674L8.16589 7.002ZM14.3309 7.002H9.66589L9.66614 8.16674C9.66614 9.34763 10.5437 10.3236 11.6822 10.478L11.839 10.4939L11.9987 10.4993C13.2333 10.4993 14.2438 9.54019 14.3259 8.32644L14.3313 8.16674L14.3309 7.002ZM20.4979 7.002H15.8329L15.8336 8.16674C15.8336 9.34763 16.7112 10.3236 17.8497 10.478L18.0065 10.4939L18.1662 10.4993C18.7305 10.4993 19.248 10.2989 19.6514 9.96542L19.7412 9.88731L19.857 9.7736L20.0032 9.60441C20.0572 9.53545 20.1075 9.46337 20.1536 9.38849L20.2571 9.20179L20.32 9.06383L20.3783 8.90873L20.4081 8.81314L20.4463 8.66108L20.4747 8.50352L20.4927 8.33678L20.4988 8.16674L20.4979 7.002ZM9.06151 3.499H6.32689L4.46889 5.502H8.44551L9.06151 3.499ZM13.3685 3.499H10.6305L10.0145 5.502H13.9845L13.3685 3.499ZM17.6719 3.499H14.9375L15.5535 5.502H19.5299L17.6719 3.499Z " },
            { FluentSymbol.BuildingSkyscraper16Filled, "M6.75 1H6.25C6.11193 1 6 1.11193 6 1.25V2H7V1.25C7 1.11193 6.88807 1 6.75 1Z M8.5 3H4.5C4.22386 3 4 3.22386 4 3.5V4H9V3.5C9 3.22386 8.77614 3 8.5 3Z M11.5 12C11.7761 12 12 11.7761 12 11.5C12 11.2239 11.7761 11 11.5 11C11.2239 11 11 11.2239 11 11.5C11 11.7761 11.2239 12 11.5 12Z M12 9.5C12 9.77614 11.7761 10 11.5 10C11.2239 10 11 9.77614 11 9.5C11 9.22386 11.2239 9 11.5 9C11.7761 9 12 9.22386 12 9.5Z M3 6.45C3 5.83652 3.32495 5.29895 3.81213 5H9.18787C9.67505 5.29895 10 5.83652 10 6.45V6.5H10.3C12.3435 6.5 14 8.15655 14 10.2V13.5C14 13.7761 13.7761 14 13.5 14H7V11.9C7 11.6791 6.82091 11.5 6.6 11.5H6.4C6.17909 11.5 6 11.6791 6 11.9V14H3.5C3.22386 14 3 13.7761 3 13.5V6.45ZM13 10.2C13 8.70883 11.7912 7.5 10.3 7.5H10V13H13V10.2ZM6 7.5C6 7.22386 5.77614 7 5.5 7C5.22386 7 5 7.22386 5 7.5C5 7.77614 5.22386 8 5.5 8C5.77614 8 6 7.77614 6 7.5ZM7.5 8C7.77614 8 8 7.77614 8 7.5C8 7.22386 7.77614 7 7.5 7C7.22386 7 7 7.22386 7 7.5C7 7.77614 7.22386 8 7.5 8ZM6 9.5C6 9.22386 5.77614 9 5.5 9C5.22386 9 5 9.22386 5 9.5C5 9.77614 5.22386 10 5.5 10C5.77614 10 6 9.77614 6 9.5ZM7.5 10C7.77614 10 8 9.77614 8 9.5C8 9.22386 7.77614 9 7.5 9C7.22386 9 7 9.22386 7 9.5C7 9.77614 7.22386 10 7.5 10Z " },
            { FluentSymbol.BuildingSkyscraper16, "M6 7.5C6 7.77614 5.77614 8 5.5 8C5.22386 8 5 7.77614 5 7.5C5 7.22386 5.22386 7 5.5 7C5.77614 7 6 7.22386 6 7.5Z M7.5 8C7.77614 8 8 7.77614 8 7.5C8 7.22386 7.77614 7 7.5 7C7.22386 7 7 7.22386 7 7.5C7 7.77614 7.22386 8 7.5 8Z M6 9.5C6 9.77614 5.77614 10 5.5 10C5.22386 10 5 9.77614 5 9.5C5 9.22386 5.22386 9 5.5 9C5.77614 9 6 9.22386 6 9.5Z M7.5 10C7.77614 10 8 9.77614 8 9.5C8 9.22386 7.77614 9 7.5 9C7.22386 9 7 9.22386 7 9.5C7 9.77614 7.22386 10 7.5 10Z M12 11.5C12 11.7761 11.7761 12 11.5 12C11.2239 12 11 11.7761 11 11.5C11 11.2239 11.2239 11 11.5 11C11.7761 11 12 11.2239 12 11.5Z M11.5 10C11.7761 10 12 9.77614 12 9.5C12 9.22386 11.7761 9 11.5 9C11.2239 9 11 9.22386 11 9.5C11 9.77614 11.2239 10 11.5 10Z M5.5 1C5.22386 1 5 1.22386 5 1.5V3H4.5C4.22386 3 4 3.22386 4 3.5V5.15035C3.4103 5.41715 3 6.01066 3 6.7V13.5C3 13.7761 3.22386 14 3.5 14H13.5C13.7761 14 14 13.7761 14 13.5V10.2C14 8.15655 12.3435 6.5 10.3 6.5H9.98836C9.91773 5.89729 9.53182 5.39096 9 5.15035V3.5C9 3.22386 8.77614 3 8.5 3H8V1.5C8 1.22386 7.77614 1 7.5 1H5.5ZM8 5H5V4H8V5ZM9 6.7V13H8V11.9C8 11.4029 7.59706 11 7.1 11H5.9C5.40294 11 5 11.4029 5 11.9V13H4V6.7C4 6.3134 4.3134 6 4.7 6H8.3C8.6866 6 9 6.3134 9 6.7ZM6 13V12H7V13H6ZM10 13V7.5H10.3C11.7912 7.5 13 8.70883 13 10.2V13H10ZM7 3H6V2H7V3Z " },
            { FluentSymbol.BuildingSkyscraper20Filled, "M7 2.49609C7 2.21995 7.22386 1.99609 7.5 1.99609H8.5C8.77614 1.99609 9 2.21995 9 2.49609V3.00049H7V2.49609Z M5.45836 4.00049C5.2017 4.02165 5 4.23666 5 4.49878V5.00049H11V4.49878C11 4.23666 10.7983 4.02165 10.5416 4.00049H5.45836Z M13.75 15.0005C14.1642 15.0005 14.5 14.6647 14.5 14.2505C14.5 13.8363 14.1642 13.5005 13.75 13.5005C13.3358 13.5005 13 13.8363 13 14.2505C13 14.6647 13.3358 15.0005 13.75 15.0005Z M14.5 11.7505C14.5 12.1647 14.1642 12.5005 13.75 12.5005C13.3358 12.5005 13 12.1647 13 11.7505C13 11.3363 13.3358 11.0005 13.75 11.0005C14.1642 11.0005 14.5 11.3363 14.5 11.7505Z M5 6.00049H11V6.01805C11.5978 6.36386 12 7.01021 12 7.75049V8.00049H12.5C14.9853 8.00049 17 10.0152 17 12.5005V16.5005C17 16.7766 16.7761 17.0005 16.5 17.0005H11.5C11.486 17.0005 11.4721 16.9999 11.4584 16.9988H9V14.5005C9 14.2243 8.77614 14.0005 8.5 14.0005H7.5C7.22386 14.0005 7 14.2243 7 14.5005V16.9988H4.5C4.22386 16.9988 4 16.7749 4 16.4988V7.75049C4 7.01021 4.4022 6.36386 5 6.01805V6.00049ZM12 16.0005H16V12.5005C16 10.5675 14.433 9.00049 12.5 9.00049H12V16.0005ZM7.5 8.75049C7.5 8.33627 7.16421 8.00049 6.75 8.00049C6.33579 8.00049 6 8.33627 6 8.75049C6 9.1647 6.33579 9.50049 6.75 9.50049C7.16421 9.50049 7.5 9.1647 7.5 8.75049ZM9.25 9.50049C9.66421 9.50049 10 9.1647 10 8.75049C10 8.33627 9.66421 8.00049 9.25 8.00049C8.83579 8.00049 8.5 8.33627 8.5 8.75049C8.5 9.1647 8.83579 9.50049 9.25 9.50049ZM7.5 11.2505C7.5 10.8363 7.16421 10.5005 6.75 10.5005C6.33579 10.5005 6 10.8363 6 11.2505C6 11.6647 6.33579 12.0005 6.75 12.0005C7.16421 12.0005 7.5 11.6647 7.5 11.2505ZM9.25 12.0005C9.66421 12.0005 10 11.6647 10 11.2505C10 10.8363 9.66421 10.5005 9.25 10.5005C8.83579 10.5005 8.5 10.8363 8.5 11.2505C8.5 11.6647 8.83579 12.0005 9.25 12.0005Z " },
            { FluentSymbol.BuildingSkyscraper20, "M7.5 8.74957C7.5 9.16379 7.16421 9.49957 6.75 9.49957C6.33579 9.49957 6 9.16379 6 8.74957C6 8.33536 6.33579 7.99957 6.75 7.99957C7.16421 7.99957 7.5 8.33536 7.5 8.74957Z M9.25 9.49957C9.66421 9.49957 10 9.16379 10 8.74957C10 8.33536 9.66421 7.99957 9.25 7.99957C8.83579 7.99957 8.5 8.33536 8.5 8.74957C8.5 9.16379 8.83579 9.49957 9.25 9.49957Z M7.5 11.2496C7.5 11.6638 7.16421 11.9996 6.75 11.9996C6.33579 11.9996 6 11.6638 6 11.2496C6 10.8354 6.33579 10.4996 6.75 10.4996C7.16421 10.4996 7.5 10.8354 7.5 11.2496Z M9.25 11.9996C9.66421 11.9996 10 11.6638 10 11.2496C10 10.8354 9.66421 10.4996 9.25 10.4996C8.83579 10.4996 8.5 10.8354 8.5 11.2496C8.5 11.6638 8.83579 11.9996 9.25 11.9996Z M14.5 14.2496C14.5 14.6638 14.1642 14.9996 13.75 14.9996C13.3358 14.9996 13 14.6638 13 14.2496C13 13.8354 13.3358 13.4996 13.75 13.4996C14.1642 13.4996 14.5 13.8354 14.5 14.2496Z M13.75 12.4996C14.1642 12.4996 14.5 12.1638 14.5 11.7496C14.5 11.3354 14.1642 10.9996 13.75 10.9996C13.3358 10.9996 13 11.3354 13 11.7496C13 12.1638 13.3358 12.4996 13.75 12.4996Z M7 1.99512C6.72386 1.99512 6.5 2.21897 6.5 2.49512V3.99779H5.55518C5.27903 3.99779 5.05518 4.22164 5.05518 4.49779V6.23637C4.42708 6.57365 4 7.23674 4 7.99957V16.4979C4 16.774 4.22386 16.9979 4.5 16.9979H11.4584C11.4721 16.999 11.486 16.9996 11.5 16.9996H16.5C16.7761 16.9996 17 16.7757 17 16.4996V12.4996C17 10.0143 14.9853 7.99957 12.5 7.99957H12C12 7.2823 11.6224 6.65322 11.0552 6.30025V4.49779C11.0552 4.22164 10.8313 3.99779 10.5552 3.99779H9.5V2.49512C9.5 2.21897 9.27614 1.99512 9 1.99512H7ZM10 5.99957H6.05518V4.99779H6.99605L7 4.9978H9L9.00395 4.99779H10.0552V6.00032C10.0368 5.99982 10.0185 5.99957 10 5.99957ZM11 15.9979H10V14.004C10 13.4517 9.55228 13.004 9 13.004H7C6.44771 13.004 6 13.4517 6 14.004V15.9979H5V7.99957C5 7.44729 5.44772 6.99957 6 6.99957H10C10.5523 6.99957 11 7.44729 11 7.99957V15.9979ZM7 15.9979V14.004H9V15.9979H7ZM16 15.9996H12V8.99957H12.5C14.433 8.99957 16 10.5666 16 12.4996V15.9996ZM8.5 3.99779H7.5V2.99512H8.5V3.99779Z " },
            { FluentSymbol.BuildingSkyscraper24Filled, "M8.75 2.00195C8.33579 2.00195 8 2.33774 8 2.75195V4.00055H11V2.75195C11 2.33774 10.6642 2.00195 10.25 2.00195H8.75Z M11 5.00055H8V5.00195H6.75C6.33579 5.00195 6 5.33774 6 5.75195V7.00055H13V5.75195C13 5.33774 12.6642 5.00195 12.25 5.00195H11V5.00055Z M17 16.0002C17.5523 16.0002 18 15.5525 18 15.0002C18 14.448 17.5523 14.0002 17 14.0002C16.4477 14.0002 16 14.448 16 15.0002C16 15.5525 16.4477 16.0002 17 16.0002Z M18 18.0002C18 18.5525 17.5523 19.0002 17 19.0002C16.4477 19.0002 16 18.5525 16 18.0002C16 17.448 16.4477 17.0002 17 17.0002C17.5523 17.0002 18 17.448 18 18.0002Z M4 10.0002C4 8.90746 4.87642 8.01938 5.9647 8.00055H13.0353C14.1236 8.01938 15 8.90746 15 10.0002V10.0056C18.0597 10.1365 20.5 12.6584 20.5 15.7502V20.7502C20.5 21.1645 20.1642 21.5002 19.75 21.5002H11.25V18.5002C11.25 18.2241 11.0261 18.0002 10.75 18.0002H8.25C7.97386 18.0002 7.75 18.2241 7.75 18.5002V21.5002H4.75C4.33579 21.5002 4 21.1645 4 20.7502V10.0002ZM19 15.7502C19 13.487 17.2308 11.6369 15 11.5075V20.0002H19V15.7502ZM12.25 11.0002C12.25 10.448 11.8023 10.0002 11.25 10.0002C10.6977 10.0002 10.25 10.448 10.25 11.0002C10.25 11.5525 10.6977 12.0002 11.25 12.0002C11.8023 12.0002 12.25 11.5525 12.25 11.0002ZM11.25 15.2502C11.8023 15.2502 12.25 14.8025 12.25 14.2502C12.25 13.698 11.8023 13.2502 11.25 13.2502C10.6977 13.2502 10.25 13.698 10.25 14.2502C10.25 14.8025 10.6977 15.2502 11.25 15.2502ZM8.75 11.0002C8.75 10.448 8.30228 10.0002 7.75 10.0002C7.19772 10.0002 6.75 10.448 6.75 11.0002C6.75 11.5525 7.19772 12.0002 7.75 12.0002C8.30228 12.0002 8.75 11.5525 8.75 11.0002ZM7.75 15.2502C8.30228 15.2502 8.75 14.8025 8.75 14.2502C8.75 13.698 8.30228 13.2502 7.75 13.2502C7.19772 13.2502 6.75 13.698 6.75 14.2502C6.75 14.8025 7.19772 15.2502 7.75 15.2502Z " },
            { FluentSymbol.BuildingSkyscraper24, "M12 11.0002C12 11.5525 11.5523 12.0002 11 12.0002C10.4477 12.0002 10 11.5525 10 11.0002C10 10.448 10.4477 10.0002 11 10.0002C11.5523 10.0002 12 10.448 12 11.0002Z M11 15.0002C11.5523 15.0002 12 14.5525 12 14.0002C12 13.448 11.5523 13.0002 11 13.0002C10.4477 13.0002 10 13.448 10 14.0002C10 14.5525 10.4477 15.0002 11 15.0002Z M9 11.0002C9 11.5525 8.55228 12.0002 8 12.0002C7.44772 12.0002 7 11.5525 7 11.0002C7 10.448 7.44772 10.0002 8 10.0002C8.55228 10.0002 9 10.448 9 11.0002Z M8 15.0002C8.55228 15.0002 9 14.5525 9 14.0002C9 13.448 8.55228 13.0002 8 13.0002C7.44772 13.0002 7 13.448 7 14.0002C7 14.5525 7.44772 15.0002 8 15.0002Z M18 15.0002C18 15.5525 17.5523 16.0002 17 16.0002C16.4477 16.0002 16 15.5525 16 15.0002C16 14.448 16.4477 14.0002 17 14.0002C17.5523 14.0002 18 14.448 18 15.0002Z M17 19.0002C17.5523 19.0002 18 18.5525 18 18.0002C18 17.448 17.5523 17.0002 17 17.0002C16.4477 17.0002 16 17.448 16 18.0002C16 18.5525 16.4477 19.0002 17 19.0002Z M8.25 2.00195C7.83579 2.00195 7.5 2.33774 7.5 2.75195V5.00024H6.25C5.83579 5.00024 5.5 5.33603 5.5 5.75024V7.8001C4.60958 8.25528 4 9.18157 4 10.2502V20.7502C4 21.1645 4.33579 21.5002 4.75 21.5002H19.75C20.1642 21.5002 20.5 21.1645 20.5 20.7502V15.7502C20.5 12.6547 18.0539 10.1306 14.9892 10.0051C14.9042 9.04251 14.3232 8.22234 13.5034 7.80183V5.75024C13.5034 5.33603 13.1676 5.00024 12.7534 5.00024H11.5V2.75195C11.5 2.33774 11.1642 2.00195 10.75 2.00195H8.25ZM12.0034 7.50024H7V6.50024H12.0034V7.50024ZM13.5 20.0002H12V17.2502C12 16.836 11.6642 16.5002 11.25 16.5002H7.75C7.33579 16.5002 7 16.836 7 17.2502V20.0002H5.5V10.2502C5.5 9.55989 6.05964 9.00024 6.75 9.00024H12.25C12.9404 9.00024 13.5 9.55989 13.5 10.2502V20.0002ZM8.5 20.0002V18.0002H10.5V20.0002H8.5ZM15 20.0002V11.5075C17.2308 11.6369 19 13.487 19 15.7502V20.0002H15ZM10 5.00024H9V3.50195H10V5.00024Z " },
            { FluentSymbol.Calculator20Filled, "M13.5 2H6.5C5.11929 2 4 3.11929 4 4.5V15.5C4 16.8807 5.11929 18 6.5 18H13.5C14.8807 18 16 16.8807 16 15.5V4.5C16 3.11929 14.8807 2 13.5 2ZM7.5 4H12.5C13.3284 4 14 4.67157 14 5.5V6.5C14 7.32843 13.3284 8 12.5 8H7.5C6.67157 8 6 7.32843 6 6.5V5.5C6 4.67157 6.67157 4 7.5 4ZM8 11C8 11.5523 7.55228 12 7 12C6.44772 12 6 11.5523 6 11C6 10.4477 6.44772 10 7 10C7.55228 10 8 10.4477 8 11ZM8 14C8 14.5523 7.55228 15 7 15C6.44772 15 6 14.5523 6 14C6 13.4477 6.44772 13 7 13C7.55228 13 8 13.4477 8 14ZM13 12C12.4477 12 12 11.5523 12 11C12 10.4477 12.4477 10 13 10C13.5523 10 14 10.4477 14 11C14 11.5523 13.5523 12 13 12ZM14 14C14 14.5523 13.5523 15 13 15C12.4477 15 12 14.5523 12 14C12 13.4477 12.4477 13 13 13C13.5523 13 14 13.4477 14 14ZM10 12C9.44772 12 9 11.5523 9 11C9 10.4477 9.44772 10 10 10C10.5523 10 11 10.4477 11 11C11 11.5523 10.5523 12 10 12ZM11 14C11 14.5523 10.5523 15 10 15C9.44772 15 9 14.5523 9 14C9 13.4477 9.44772 13 10 13C10.5523 13 11 13.4477 11 14Z " },
            { FluentSymbol.Calculator20, "M8 11C8 11.5523 7.55228 12 7 12C6.44772 12 6 11.5523 6 11C6 10.4477 6.44772 10 7 10C7.55228 10 8 10.4477 8 11Z M8 14C8 14.5523 7.55228 15 7 15C6.44772 15 6 14.5523 6 14C6 13.4477 6.44772 13 7 13C7.55228 13 8 13.4477 8 14Z M13 12C13.5523 12 14 11.5523 14 11C14 10.4477 13.5523 10 13 10C12.4477 10 12 10.4477 12 11C12 11.5523 12.4477 12 13 12Z M14 14C14 14.5523 13.5523 15 13 15C12.4477 15 12 14.5523 12 14C12 13.4477 12.4477 13 13 13C13.5523 13 14 13.4477 14 14Z M10 12C10.5523 12 11 11.5523 11 11C11 10.4477 10.5523 10 10 10C9.44772 10 9 10.4477 9 11C9 11.5523 9.44772 12 10 12Z M11 14C11 14.5523 10.5523 15 10 15C9.44772 15 9 14.5523 9 14C9 13.4477 9.44772 13 10 13C10.5523 13 11 13.4477 11 14Z M7.5 4C6.67157 4 6 4.67157 6 5.5V6.5C6 7.32843 6.67157 8 7.5 8H12.5C13.3284 8 14 7.32843 14 6.5V5.5C14 4.67157 13.3284 4 12.5 4H7.5ZM7 5.5C7 5.22386 7.22386 5 7.5 5H12.5C12.7761 5 13 5.22386 13 5.5V6.5C13 6.77614 12.7761 7 12.5 7H7.5C7.22386 7 7 6.77614 7 6.5V5.5Z M16 15.5C16 16.8807 14.8807 18 13.5 18H6.5C5.11929 18 4 16.8807 4 15.5V4.5C4 3.11929 5.11929 2 6.5 2H13.5C14.8807 2 16 3.11929 16 4.5V15.5ZM15 4.5C15 3.67157 14.3284 3 13.5 3H6.5C5.67157 3 5 3.67157 5 4.5V15.5C5 16.3284 5.67157 17 6.5 17H13.5C14.3284 17 15 16.3284 15 15.5V4.5Z " },
            { FluentSymbol.Calculator24Filled, "M4 5.25C4 3.45507 5.45507 2 7.25 2H16.75C18.5449 2 20 3.45507 20 5.25V18.75C20 20.5449 18.5449 22 16.75 22H7.25C5.45507 22 4 20.5449 4 18.75V5.25ZM9 5C7.89543 5 7 5.89543 7 7V8C7 9.10457 7.89543 10 9 10H15C16.1046 10 17 9.10457 17 8V7C17 5.89543 16.1046 5 15 5H9ZM9.5 13.25C9.5 12.5596 8.94036 12 8.25 12C7.55964 12 7 12.5596 7 13.25C7 13.9404 7.55964 14.5 8.25 14.5C8.94036 14.5 9.5 13.9404 9.5 13.25ZM8.25 18.5C8.94036 18.5 9.5 17.9404 9.5 17.25C9.5 16.5596 8.94036 16 8.25 16C7.55964 16 7 16.5596 7 17.25C7 17.9404 7.55964 18.5 8.25 18.5ZM17 13.25C17 12.5596 16.4404 12 15.75 12C15.0596 12 14.5 12.5596 14.5 13.25C14.5 13.9404 15.0596 14.5 15.75 14.5C16.4404 14.5 17 13.9404 17 13.25ZM15.75 18.5C16.4404 18.5 17 17.9404 17 17.25C17 16.5596 16.4404 16 15.75 16C15.0596 16 14.5 16.5596 14.5 17.25C14.5 17.9404 15.0596 18.5 15.75 18.5ZM13.25 13.25C13.25 12.5596 12.6904 12 12 12C11.3096 12 10.75 12.5596 10.75 13.25C10.75 13.9404 11.3096 14.5 12 14.5C12.6904 14.5 13.25 13.9404 13.25 13.25ZM12 18.5C12.6904 18.5 13.25 17.9404 13.25 17.25C13.25 16.5596 12.6904 16 12 16C11.3096 16 10.75 16.5596 10.75 17.25C10.75 17.9404 11.3096 18.5 12 18.5Z " },
            { FluentSymbol.Calculator24, "M7 7C7 5.89543 7.89543 5 9 5H15C16.1046 5 17 5.89543 17 7V8C17 9.10457 16.1046 10 15 10H9C7.89543 10 7 9.10457 7 8V7ZM9 6.5C8.72386 6.5 8.5 6.72386 8.5 7V8C8.5 8.27614 8.72386 8.5 9 8.5H15C15.2761 8.5 15.5 8.27614 15.5 8V7C15.5 6.72386 15.2761 6.5 15 6.5H9ZM8.25 14.5C8.94036 14.5 9.5 13.9404 9.5 13.25C9.5 12.5596 8.94036 12 8.25 12C7.55964 12 7 12.5596 7 13.25C7 13.9404 7.55964 14.5 8.25 14.5ZM9.5 17.25C9.5 17.9404 8.94036 18.5 8.25 18.5C7.55964 18.5 7 17.9404 7 17.25C7 16.5596 7.55964 16 8.25 16C8.94036 16 9.5 16.5596 9.5 17.25ZM15.75 14.5C16.4404 14.5 17 13.9404 17 13.25C17 12.5596 16.4404 12 15.75 12C15.0596 12 14.5 12.5596 14.5 13.25C14.5 13.9404 15.0596 14.5 15.75 14.5ZM17 17.25C17 17.9404 16.4404 18.5 15.75 18.5C15.0596 18.5 14.5 17.9404 14.5 17.25C14.5 16.5596 15.0596 16 15.75 16C16.4404 16 17 16.5596 17 17.25ZM12 14.5C12.6904 14.5 13.25 13.9404 13.25 13.25C13.25 12.5596 12.6904 12 12 12C11.3096 12 10.75 12.5596 10.75 13.25C10.75 13.9404 11.3096 14.5 12 14.5ZM13.25 17.25C13.25 17.9404 12.6904 18.5 12 18.5C11.3096 18.5 10.75 17.9404 10.75 17.25C10.75 16.5596 11.3096 16 12 16C12.6904 16 13.25 16.5596 13.25 17.25ZM7.25 2C5.45507 2 4 3.45507 4 5.25V18.75C4 20.5449 5.45507 22 7.25 22H16.75C18.5449 22 20 20.5449 20 18.75V5.25C20 3.45507 18.5449 2 16.75 2H7.25ZM5.5 5.25C5.5 4.2835 6.2835 3.5 7.25 3.5H16.75C17.7165 3.5 18.5 4.2835 18.5 5.25V18.75C18.5 19.7165 17.7165 20.5 16.75 20.5H7.25C6.2835 20.5 5.5 19.7165 5.5 18.75V5.25Z " },
            { FluentSymbol.Calendar3Day20Filled, "M14.5 3C15.8807 3 17 4.11929 17 5.5V14.5C17 15.8807 15.8807 17 14.5 17H5.5C4.11929 17 3 15.8807 3 14.5V5.5C3 4.11929 4.11929 3 5.5 3H14.5ZM6.5 6C6.25454 6 6.05039 6.17688 6.00806 6.41012L6 6.5V13.5L6.00806 13.5899C6.05039 13.8231 6.25454 14 6.5 14C6.74546 14 6.94961 13.8231 6.99194 13.5899L7 13.5V6.5L6.99194 6.41012C6.94961 6.17688 6.74546 6 6.5 6ZM10 6C9.75454 6 9.55039 6.17688 9.50806 6.41012L9.5 6.5V13.5L9.50806 13.5899C9.55039 13.8231 9.75454 14 10 14C10.2455 14 10.4496 13.8231 10.4919 13.5899L10.5 13.5V6.5L10.4919 6.41012C10.4496 6.17688 10.2455 6 10 6ZM13.5 6C13.2545 6 13.0504 6.17688 13.0081 6.41012L13 6.5V13.5L13.0081 13.5899C13.0504 13.8231 13.2545 14 13.5 14C13.7455 14 13.9496 13.8231 13.9919 13.5899L14 13.5V6.5L13.9919 6.41012C13.9496 6.17688 13.7455 6 13.5 6Z " },
            { FluentSymbol.Calendar3Day20, "M14.5 3C15.8807 3 17 4.11929 17 5.5V14.5C17 15.8807 15.8807 17 14.5 17H5.5C4.11929 17 3 15.8807 3 14.5V5.5C3 4.11929 4.11929 3 5.5 3H14.5ZM14.5 4H5.5C4.67157 4 4 4.67157 4 5.5V14.5C4 15.3284 4.67157 16 5.5 16H14.5C15.3284 16 16 15.3284 16 14.5V5.5C16 4.67157 15.3284 4 14.5 4ZM6.5 6C6.74546 6 6.94961 6.17688 6.99194 6.41012L7 6.5V13.5C7 13.7761 6.77614 14 6.5 14C6.25454 14 6.05039 13.8231 6.00806 13.5899L6 13.5V6.5C6 6.22386 6.22386 6 6.5 6ZM10 6C10.2455 6 10.4496 6.17688 10.4919 6.41012L10.5 6.5V13.5C10.5 13.7761 10.2761 14 10 14C9.75454 14 9.55039 13.8231 9.50806 13.5899L9.5 13.5V6.5C9.5 6.22386 9.72386 6 10 6ZM13.5 6C13.7455 6 13.9496 6.17688 13.9919 6.41012L14 6.5V13.5C14 13.7761 13.7761 14 13.5 14C13.2545 14 13.0504 13.8231 13.0081 13.5899L13 13.5V6.5C13 6.22386 13.2239 6 13.5 6Z " },
            { FluentSymbol.Calendar3Day24Filled, "M17.75 3C19.5449 3 21 4.45507 21 6.25V17.75C21 19.5449 19.5449 21 17.75 21H6.25C4.45507 21 3 19.5449 3 17.75V6.25C3 4.45507 4.45507 3 6.25 3H17.75ZM7.75 7C7.3703 7 7.05651 7.28215 7.00685 7.64823L7 7.75V16.25L7.00685 16.3518C7.05651 16.7178 7.3703 17 7.75 17C8.1297 17 8.44349 16.7178 8.49315 16.3518L8.5 16.25V7.75L8.49315 7.64823C8.44349 7.28215 8.1297 7 7.75 7ZM16.25 7C15.8703 7 15.5565 7.28215 15.5068 7.64823L15.5 7.75V16.25L15.5068 16.3518C15.5565 16.7178 15.8703 17 16.25 17C16.6297 17 16.9435 16.7178 16.9932 16.3518L17 16.25V7.75L16.9932 7.64823C16.9435 7.28215 16.6297 7 16.25 7ZM12 7C11.6203 7 11.3065 7.28215 11.2568 7.64823L11.25 7.75V16.25L11.2568 16.3518C11.3065 16.7178 11.6203 17 12 17C12.3797 17 12.6935 16.7178 12.7432 16.3518L12.75 16.25V7.75L12.7432 7.64823C12.6935 7.28215 12.3797 7 12 7Z " },
            { FluentSymbol.Calendar3Day24, "M17.75 3C19.5449 3 21 4.45507 21 6.25V17.75C21 19.5449 19.5449 21 17.75 21H6.25C4.45507 21 3 19.5449 3 17.75V6.25C3 4.45507 4.45507 3 6.25 3H17.75ZM17.75 4.5H6.25C5.2835 4.5 4.5 5.2835 4.5 6.25V17.75C4.5 18.7165 5.2835 19.5 6.25 19.5H17.75C18.7165 19.5 19.5 18.7165 19.5 17.75V6.25C19.5 5.2835 18.7165 4.5 17.75 4.5ZM7.75 7C8.1297 7 8.44349 7.28215 8.49315 7.64823L8.5 7.75V16.25C8.5 16.6642 8.16421 17 7.75 17C7.3703 17 7.05651 16.7178 7.00685 16.3518L7 16.25V7.75C7 7.33579 7.33579 7 7.75 7ZM16.25 7C16.6297 7 16.9435 7.28215 16.9932 7.64823L17 7.75V16.25C17 16.6642 16.6642 17 16.25 17C15.8703 17 15.5565 16.7178 15.5068 16.3518L15.5 16.25V7.75C15.5 7.33579 15.8358 7 16.25 7ZM12 7C12.3797 7 12.6935 7.28215 12.7432 7.64823L12.75 7.75V16.25C12.75 16.6642 12.4142 17 12 17C11.6203 17 11.3065 16.7178 11.2568 16.3518L11.25 16.25V7.75C11.25 7.33579 11.5858 7 12 7Z " },
            { FluentSymbol.Calendar3Day28Filled, "M21.75 3C23.5449 3 25 4.45507 25 6.25V21.75C25 23.5449 23.5449 25 21.75 25H6.25C4.45507 25 3 23.5449 3 21.75V6.25C3 4.45507 4.45507 3 6.25 3H21.75ZM14 8.25C13.6203 8.25 13.3065 8.53215 13.2568 8.89823L13.25 9V19L13.2568 19.1018C13.3065 19.4678 13.6203 19.75 14 19.75C14.3797 19.75 14.6935 19.4678 14.7432 19.1018L14.75 19V9L14.7432 8.89823C14.6935 8.53215 14.3797 8.25 14 8.25ZM19.25 8.25C18.8703 8.25 18.5565 8.53215 18.5068 8.89823L18.5 9V19L18.5068 19.1018C18.5565 19.4678 18.8703 19.75 19.25 19.75C19.6297 19.75 19.9435 19.4678 19.9932 19.1018L20 19V9L19.9932 8.89823C19.9435 8.53215 19.6297 8.25 19.25 8.25ZM8.75 8.25C8.3703 8.25 8.05651 8.53215 8.00685 8.89823L8 9V19L8.00685 19.1018C8.05651 19.4678 8.3703 19.75 8.75 19.75C9.1297 19.75 9.44349 19.4678 9.49315 19.1018L9.5 19V9L9.49315 8.89823C9.44349 8.53215 9.1297 8.25 8.75 8.25Z " },
            { FluentSymbol.Calendar3Day28, "M21.75 3C23.5449 3 25 4.45507 25 6.25V21.75C25 23.5449 23.5449 25 21.75 25H6.25C4.45507 25 3 23.5449 3 21.75V6.25C3 4.45507 4.45507 3 6.25 3H21.75ZM21.75 4.5H6.25C5.2835 4.5 4.5 5.2835 4.5 6.25V21.75C4.5 22.7165 5.2835 23.5 6.25 23.5H21.75C22.7165 23.5 23.5 22.7165 23.5 21.75V6.25C23.5 5.2835 22.7165 4.5 21.75 4.5ZM14 8.25C14.3797 8.25 14.6935 8.53215 14.7432 8.89823L14.75 9V19C14.75 19.4142 14.4142 19.75 14 19.75C13.6203 19.75 13.3065 19.4678 13.2568 19.1018L13.25 19V9C13.25 8.58579 13.5858 8.25 14 8.25ZM19.25 8.25C19.6297 8.25 19.9435 8.53215 19.9932 8.89823L20 9V19C20 19.4142 19.6642 19.75 19.25 19.75C18.8703 19.75 18.5565 19.4678 18.5068 19.1018L18.5 19V9C18.5 8.58579 18.8358 8.25 19.25 8.25ZM8.75 8.25C9.1297 8.25 9.44349 8.53215 9.49315 8.89823L9.5 9V19C9.5 19.4142 9.16421 19.75 8.75 19.75C8.3703 19.75 8.05651 19.4678 8.00685 19.1018L8 19V9C8 8.58579 8.33579 8.25 8.75 8.25Z " },
            { FluentSymbol.CalendarAdd20Filled, "M17 7V9.59971C16.2499 9.21628 15.4002 9 14.5 9C11.4624 9 9 11.4624 9 14.5C9 15.4002 9.21628 16.2499 9.59971 17H5.5C4.11929 17 3 15.8807 3 14.5V7H17Z M14.5 3C15.8807 3 17 4.11929 17 5.5V6H3V5.5C3 4.11929 4.11929 3 5.5 3H14.5Z M19 14.5C19 16.9853 16.9853 19 14.5 19C12.0147 19 10 16.9853 10 14.5C10 12.0147 12.0147 10 14.5 10C16.9853 10 19 12.0147 19 14.5ZM15 12.5C15 12.2239 14.7761 12 14.5 12C14.2239 12 14 12.2239 14 12.5V14H12.5C12.2239 14 12 14.2239 12 14.5C12 14.7761 12.2239 15 12.5 15H14V16.5C14 16.7761 14.2239 17 14.5 17C14.7761 17 15 16.7761 15 16.5V15H16.5C16.7761 15 17 14.7761 17 14.5C17 14.2239 16.7761 14 16.5 14H15V12.5Z " },
            { FluentSymbol.CalendarAdd20, "M14.5 3C15.8807 3 17 4.11929 17 5.5V9.59971C16.6832 9.43777 16.3486 9.30564 16 9.20703V7H4V14.5C4 15.3284 4.67157 16 5.5 16H9.20703C9.30564 16.3486 9.43777 16.6832 9.59971 17H5.5C4.11929 17 3 15.8807 3 14.5V5.5C3 4.11929 4.11929 3 5.5 3H14.5ZM14.5 4H5.5C4.67157 4 4 4.67157 4 5.5V6H16V5.5C16 4.67157 15.3284 4 14.5 4Z M19 14.5C19 16.9853 16.9853 19 14.5 19C12.0147 19 10 16.9853 10 14.5C10 12.0147 12.0147 10 14.5 10C16.9853 10 19 12.0147 19 14.5ZM15 12.5C15 12.2239 14.7761 12 14.5 12C14.2239 12 14 12.2239 14 12.5V14H12.5C12.2239 14 12 14.2239 12 14.5C12 14.7761 12.2239 15 12.5 15H14V16.5C14 16.7761 14.2239 17 14.5 17C14.7761 17 15 16.7761 15 16.5V15H16.5C16.7761 15 17 14.7761 17 14.5C17 14.2239 16.7761 14 16.5 14H15V12.5Z " },
            { FluentSymbol.CalendarAdd24Filled, "M17.5 12C20.5376 12 23 14.4624 23 17.5C23 20.5376 20.5376 23 17.5 23C14.4624 23 12 20.5376 12 17.5C12 14.4624 14.4624 12 17.5 12ZM21 8.5L21.0012 12.0226C19.9907 11.3753 18.7892 11 17.5 11C13.9101 11 11 13.9101 11 17.5C11 18.7892 11.3753 19.9907 12.0226 21.0012L6.25 21C4.45507 21 3 19.5449 3 17.75V8.5H21ZM17.5 14L17.4101 14.0081C17.206 14.0451 17.0451 14.206 17.0081 14.4101L17 14.5V17H14.5L14.4101 17.0081C14.206 17.0451 14.0451 17.206 14.0081 17.4101L14 17.5L14.0081 17.5899C14.0451 17.794 14.206 17.9549 14.4101 17.9919L14.5 18H17V20.5L17.0081 20.5899C17.0451 20.794 17.206 20.9549 17.4101 20.9919L17.5 21L17.5899 20.9919C17.794 20.9549 17.9549 20.794 17.9919 20.5899L18 20.5V18H20.5L20.5899 17.9919C20.794 17.9549 20.9549 17.794 20.9919 17.5899L21 17.5L20.9919 17.4101C20.9549 17.206 20.794 17.0451 20.5899 17.0081L20.5 17H18V14.5L17.9919 14.4101C17.9549 14.206 17.794 14.0451 17.5899 14.0081L17.5 14ZM17.75 3C19.5449 3 21 4.45507 21 6.25V7H3V6.25C3 4.45507 4.45507 3 6.25 3H17.75Z " },
            { FluentSymbol.CalendarAdd24, "M17.5 12C20.5376 12 23 14.4624 23 17.5C23 20.5376 20.5376 23 17.5 23C14.4624 23 12 20.5376 12 17.5C12 14.4624 14.4624 12 17.5 12ZM17.75 3C19.5449 3 21 4.45507 21 6.25L21.0012 12.0226C20.5378 11.7257 20.0342 11.4861 19.5004 11.3136L19.5 8.5H4.5V17.75C4.5 18.7165 5.2835 19.5 6.25 19.5L11.3136 19.5004C11.4861 20.0342 11.7257 20.5378 12.0226 21.0012L6.25 21C4.45507 21 3 19.5449 3 17.75V6.25C3 4.45507 4.45507 3 6.25 3H17.75ZM17.5 14L17.4101 14.0081C17.206 14.0451 17.0451 14.206 17.0081 14.4101L17 14.5V17H14.5L14.4101 17.0081C14.206 17.0451 14.0451 17.206 14.0081 17.4101L14 17.5L14.0081 17.5899C14.0451 17.794 14.206 17.9549 14.4101 17.9919L14.5 18H17V20.5L17.0081 20.5899C17.0451 20.794 17.206 20.9549 17.4101 20.9919L17.5 21L17.5899 20.9919C17.794 20.9549 17.9549 20.794 17.9919 20.5899L18 20.5V18H20.5L20.5899 17.9919C20.794 17.9549 20.9549 17.794 20.9919 17.5899L21 17.5L20.9919 17.4101C20.9549 17.206 20.794 17.0451 20.5899 17.0081L20.5 17H18V14.5L17.9919 14.4101C17.9549 14.206 17.794 14.0451 17.5899 14.0081L17.5 14ZM17.75 4.5H6.25C5.2835 4.5 4.5 5.2835 4.5 6.25V7H19.5V6.25C19.5 5.2835 18.7165 4.5 17.75 4.5Z " },
            { FluentSymbol.CalendarAgenda20Filled, "M17 14.5C17 15.8807 15.8807 17 14.5 17H5.5C4.11929 17 3 15.8807 3 14.5V5.5C3 4.11929 4.11929 3 5.5 3H14.5C15.8807 3 17 4.11929 17 5.5V14.5ZM14 6.5C14 6.25454 13.8231 6.05039 13.5899 6.00806L13.5 6H6.5L6.41012 6.00806C6.17688 6.05039 6 6.25454 6 6.5C6 6.74546 6.17688 6.94961 6.41012 6.99194L6.5 7H13.5L13.5899 6.99194C13.8231 6.94961 14 6.74546 14 6.5ZM14 10C14 9.75454 13.8231 9.55039 13.5899 9.50806L13.5 9.5H6.5L6.41012 9.50806C6.17688 9.55039 6 9.75454 6 10C6 10.2455 6.17688 10.4496 6.41012 10.4919L6.5 10.5H13.5L13.5899 10.4919C13.8231 10.4496 14 10.2455 14 10ZM14 13.5C14 13.2545 13.8231 13.0504 13.5899 13.0081L13.5 13H6.5L6.41012 13.0081C6.17688 13.0504 6 13.2545 6 13.5C6 13.7455 6.17688 13.9496 6.41012 13.9919L6.5 14H13.5L13.5899 13.9919C13.8231 13.9496 14 13.7455 14 13.5Z " },
            { FluentSymbol.CalendarAgenda20, "M17 14.5C17 15.8807 15.8807 17 14.5 17H5.5C4.11929 17 3 15.8807 3 14.5V5.5C3 4.11929 4.11929 3 5.5 3H14.5C15.8807 3 17 4.11929 17 5.5V14.5ZM16 14.5V5.5C16 4.67157 15.3284 4 14.5 4H5.5C4.67157 4 4 4.67157 4 5.5V14.5C4 15.3284 4.67157 16 5.5 16H14.5C15.3284 16 16 15.3284 16 14.5ZM14 6.5C14 6.74546 13.8231 6.94961 13.5899 6.99194L13.5 7H6.5C6.22386 7 6 6.77614 6 6.5C6 6.25454 6.17688 6.05039 6.41012 6.00806L6.5 6H13.5C13.7761 6 14 6.22386 14 6.5ZM14 10C14 10.2455 13.8231 10.4496 13.5899 10.4919L13.5 10.5H6.5C6.22386 10.5 6 10.2761 6 10C6 9.75454 6.17688 9.55039 6.41012 9.50806L6.5 9.5H13.5C13.7761 9.5 14 9.72386 14 10ZM14 13.5C14 13.7455 13.8231 13.9496 13.5899 13.9919L13.5 14H6.5C6.22386 14 6 13.7761 6 13.5C6 13.2545 6.17688 13.0504 6.41012 13.0081L6.5 13H13.5C13.7761 13 14 13.2239 14 13.5Z " },
            { FluentSymbol.CalendarAgenda24Filled, "M21 17.75C21 19.5449 19.5449 21 17.75 21H6.25C4.45507 21 3 19.5449 3 17.75V6.25C3 4.45507 4.45507 3 6.25 3H17.75C19.5449 3 21 4.45507 21 6.25V17.75ZM17 7.75C17 7.3703 16.7178 7.05651 16.3518 7.00685L16.25 7H7.75L7.64823 7.00685C7.28215 7.05651 7 7.3703 7 7.75C7 8.1297 7.28215 8.44349 7.64823 8.49315L7.75 8.5H16.25L16.3518 8.49315C16.7178 8.44349 17 8.1297 17 7.75ZM17 16.25C17 15.8703 16.7178 15.5565 16.3518 15.5068L16.25 15.5H7.75L7.64823 15.5068C7.28215 15.5565 7 15.8703 7 16.25C7 16.6297 7.28215 16.9435 7.64823 16.9932L7.75 17H16.25L16.3518 16.9932C16.7178 16.9435 17 16.6297 17 16.25ZM17 12C17 11.6203 16.7178 11.3065 16.3518 11.2568L16.25 11.25H7.75L7.64823 11.2568C7.28215 11.3065 7 11.6203 7 12C7 12.3797 7.28215 12.6935 7.64823 12.7432L7.75 12.75H16.25L16.3518 12.7432C16.7178 12.6935 17 12.3797 17 12Z " },
            { FluentSymbol.CalendarAgenda24, "M21 17.75C21 19.5449 19.5449 21 17.75 21H6.25C4.45507 21 3 19.5449 3 17.75V6.25C3 4.45507 4.45507 3 6.25 3H17.75C19.5449 3 21 4.45507 21 6.25V17.75ZM19.5 17.75V6.25C19.5 5.2835 18.7165 4.5 17.75 4.5H6.25C5.2835 4.5 4.5 5.2835 4.5 6.25V17.75C4.5 18.7165 5.2835 19.5 6.25 19.5H17.75C18.7165 19.5 19.5 18.7165 19.5 17.75ZM17 7.75C17 8.1297 16.7178 8.44349 16.3518 8.49315L16.25 8.5H7.75C7.33579 8.5 7 8.16421 7 7.75C7 7.3703 7.28215 7.05651 7.64823 7.00685L7.75 7H16.25C16.6642 7 17 7.33579 17 7.75ZM17 16.25C17 16.6297 16.7178 16.9435 16.3518 16.9932L16.25 17H7.75C7.33579 17 7 16.6642 7 16.25C7 15.8703 7.28215 15.5565 7.64823 15.5068L7.75 15.5H16.25C16.6642 15.5 17 15.8358 17 16.25ZM17 12C17 12.3797 16.7178 12.6935 16.3518 12.7432L16.25 12.75H7.75C7.33579 12.75 7 12.4142 7 12C7 11.6203 7.28215 11.3065 7.64823 11.2568L7.75 11.25H16.25C16.6642 11.25 17 11.5858 17 12Z " },
            { FluentSymbol.CalendarAgenda28Filled, "M25 21.75C25 23.5449 23.5449 25 21.75 25H6.25C4.45507 25 3 23.5449 3 21.75V6.25C3 4.45507 4.45507 3 6.25 3H21.75C23.5449 3 25 4.45507 25 6.25V21.75ZM19.75 14C19.75 13.6203 19.4678 13.3065 19.1018 13.2568L19 13.25H9L8.89823 13.2568C8.53215 13.3065 8.25 13.6203 8.25 14C8.25 14.3797 8.53215 14.6935 8.89823 14.7432L9 14.75H19L19.1018 14.7432C19.4678 14.6935 19.75 14.3797 19.75 14ZM19.75 19.25C19.75 18.8703 19.4678 18.5565 19.1018 18.5068L19 18.5H9L8.89823 18.5068C8.53215 18.5565 8.25 18.8703 8.25 19.25C8.25 19.6297 8.53215 19.9435 8.89823 19.9932L9 20H19L19.1018 19.9932C19.4678 19.9435 19.75 19.6297 19.75 19.25ZM19.75 8.75C19.75 8.3703 19.4678 8.05651 19.1018 8.00685L19 8H9L8.89823 8.00685C8.53215 8.05651 8.25 8.3703 8.25 8.75C8.25 9.1297 8.53215 9.44349 8.89823 9.49315L9 9.5H19L19.1018 9.49315C19.4678 9.44349 19.75 9.1297 19.75 8.75Z " },
            { FluentSymbol.CalendarAgenda28, "M25 21.75C25 23.5449 23.5449 25 21.75 25H6.25C4.45507 25 3 23.5449 3 21.75V6.25C3 4.45507 4.45507 3 6.25 3H21.75C23.5449 3 25 4.45507 25 6.25V21.75ZM23.5 21.75V6.25C23.5 5.2835 22.7165 4.5 21.75 4.5H6.25C5.2835 4.5 4.5 5.2835 4.5 6.25V21.75C4.5 22.7165 5.2835 23.5 6.25 23.5H21.75C22.7165 23.5 23.5 22.7165 23.5 21.75ZM19.75 14C19.75 14.3797 19.4678 14.6935 19.1018 14.7432L19 14.75H9C8.58579 14.75 8.25 14.4142 8.25 14C8.25 13.6203 8.53215 13.3065 8.89823 13.2568L9 13.25H19C19.4142 13.25 19.75 13.5858 19.75 14ZM19.75 19.25C19.75 19.6297 19.4678 19.9435 19.1018 19.9932L19 20H9C8.58579 20 8.25 19.6642 8.25 19.25C8.25 18.8703 8.53215 18.5565 8.89823 18.5068L9 18.5H19C19.4142 18.5 19.75 18.8358 19.75 19.25ZM19.75 8.75C19.75 9.1297 19.4678 9.44349 19.1018 9.49315L19 9.5H9C8.58579 9.5 8.25 9.16421 8.25 8.75C8.25 8.3703 8.53215 8.05651 8.89823 8.00685L9 8H19C19.4142 8 19.75 8.33579 19.75 8.75Z " },
            { FluentSymbol.CalendarArrowRight20Filled, "M17 5.5C17 4.11929 15.8807 3 14.5 3H5.5C4.11929 3 3 4.11929 3 5.5V6H17V5.5Z M17 9.59971V7H3V14.5C3 15.8807 4.11929 17 5.5 17H9.59971C9.21628 16.2499 9 15.4002 9 14.5C9 11.4624 11.4624 9 14.5 9C15.4002 9 16.2499 9.21628 17 9.59971Z M19 14.5C19 16.9853 16.9853 19 14.5 19C12.0147 19 10 16.9853 10 14.5C10 12.0147 12.0147 10 14.5 10C16.9853 10 19 12.0147 19 14.5ZM16.8532 14.854L16.8557 14.8514C16.9026 14.804 16.938 14.7495 16.9621 14.6914C16.9861 14.6333 16.9996 14.5697 17 14.503L17 14.5L17 14.497C16.9996 14.4303 16.9861 14.3667 16.9621 14.3086C16.9377 14.2496 16.9015 14.1944 16.8536 14.1464L14.8536 12.1464C14.6583 11.9512 14.3417 11.9512 14.1464 12.1464C13.9512 12.3417 13.9512 12.6583 14.1464 12.8536L15.2929 14H12.5C12.2239 14 12 14.2239 12 14.5C12 14.7761 12.2239 15 12.5 15H15.2929L14.1464 16.1464C13.9512 16.3417 13.9512 16.6583 14.1464 16.8536C14.3417 17.0488 14.6583 17.0488 14.8536 16.8536L16.8532 14.854Z " },
            { FluentSymbol.CalendarArrowRight20, "M17 5.5C17 4.11929 15.8807 3 14.5 3H5.5C4.11929 3 3 4.11929 3 5.5V14.5C3 15.8807 4.11929 17 5.5 17H9.59971C9.43777 16.6832 9.30564 16.3486 9.20703 16H5.5C4.67157 16 4 15.3284 4 14.5V7H16V9.20703C16.3486 9.30564 16.6832 9.43777 17 9.59971V5.5ZM5.5 4H14.5C15.3284 4 16 4.67157 16 5.5V6H4V5.5C4 4.67157 4.67157 4 5.5 4Z M19 14.5C19 16.9853 16.9853 19 14.5 19C12.0147 19 10 16.9853 10 14.5C10 12.0147 12.0147 10 14.5 10C16.9853 10 19 12.0147 19 14.5ZM16.8532 14.854L16.8557 14.8514C16.9026 14.804 16.938 14.7495 16.9621 14.6914C16.9861 14.6333 16.9996 14.5697 17 14.503L17 14.5L17 14.497C16.9996 14.4303 16.9861 14.3667 16.9621 14.3086C16.9377 14.2496 16.9015 14.1944 16.8536 14.1464L14.8536 12.1464C14.6583 11.9512 14.3417 11.9512 14.1464 12.1464C13.9512 12.3417 13.9512 12.6583 14.1464 12.8536L15.2929 14H12.5C12.2239 14 12 14.2239 12 14.5C12 14.7761 12.2239 15 12.5 15H15.2929L14.1464 16.1464C13.9512 16.3417 13.9512 16.6583 14.1464 16.8536C14.3417 17.0488 14.6583 17.0488 14.8536 16.8536L16.8532 14.854Z " },
            { FluentSymbol.CalendarAssistant20Filled, "M17 7V9.59971C16.2499 9.21628 15.4002 9 14.5 9C11.4624 9 9 11.4624 9 14.5C9 15.4002 9.21628 16.2499 9.59971 17H5.5C4.11929 17 3 15.8807 3 14.5V7H17Z M14.5 3C15.8807 3 17 4.11929 17 5.5V6H3V5.5C3 4.11929 4.11929 3 5.5 3H14.5Z M14.5 19C16.9853 19 19 16.9853 19 14.5C19 12.0147 16.9853 10 14.5 10C12.0147 10 10 12.0147 10 14.5C10 16.9853 12.0147 19 14.5 19ZM13.4083 11.834C13.4788 11.6339 13.6678 11.5 13.88 11.5H15.06C15.2207 11.5 15.3716 11.5773 15.4656 11.7076C15.5596 11.838 15.5852 12.0056 15.5343 12.1581L15.2537 13H16C16.1829 13 16.3512 13.0999 16.4389 13.2604C16.5265 13.4209 16.5195 13.6165 16.4206 13.7704L14.1706 17.2704C14.0372 17.4779 13.7723 17.5571 13.5468 17.4569C13.3214 17.3566 13.2028 17.1069 13.2675 16.8688L13.7758 15H13C12.8378 15 12.6857 14.9213 12.592 14.789C12.4982 14.6566 12.4745 14.487 12.5284 14.334L13.4083 11.834Z " },
            { FluentSymbol.CalendarAssistant20, "M17 5.5C17 4.11929 15.8807 3 14.5 3H5.5C4.11929 3 3 4.11929 3 5.5V14.5C3 15.8807 4.11929 17 5.5 17H9.59971C9.43777 16.6832 9.30564 16.3486 9.20703 16H5.5C4.67157 16 4 15.3284 4 14.5V7H16V9.20703C16.3486 9.30564 16.6832 9.43777 17 9.59971V5.5ZM5.5 4H14.5C15.3284 4 16 4.67157 16 5.5V6H4V5.5C4 4.67157 4.67157 4 5.5 4Z M19 14.5C19 16.9853 16.9853 19 14.5 19C12.0147 19 10 16.9853 10 14.5C10 12.0147 12.0147 10 14.5 10C16.9853 10 19 12.0147 19 14.5ZM13.88 11.5C13.6678 11.5 13.4788 11.6339 13.4083 11.834L12.5284 14.334C12.4745 14.487 12.4982 14.6566 12.592 14.789C12.6857 14.9213 12.8378 15 13 15H13.7758L13.2675 16.8688C13.2028 17.1069 13.3214 17.3566 13.5468 17.4569C13.7723 17.5571 14.0372 17.4779 14.1706 17.2704L16.4206 13.7704C16.5195 13.6165 16.5265 13.4209 16.4389 13.2604C16.3512 13.0999 16.1829 13 16 13H15.2537L15.5343 12.1581C15.5852 12.0056 15.5596 11.838 15.4656 11.7076C15.3716 11.5773 15.2207 11.5 15.06 11.5H13.88Z " },
            { FluentSymbol.CalendarAssistant24Filled, "M21 8.5V12.0218C19.9897 11.375 18.7886 11 17.5 11C13.9101 11 11 13.9101 11 17.5C11 18.7886 11.375 19.9897 12.0218 21H6.25C4.45507 21 3 19.5449 3 17.75V8.5H21Z M17.75 3C19.5449 3 21 4.45507 21 6.25V7H3V6.25C3 4.45507 4.45507 3 6.25 3H17.75Z M17.5 23C20.5376 23 23 20.5376 23 17.5C23 14.4624 20.5376 12 17.5 12C14.4624 12 12 14.4624 12 17.5C12 20.5376 14.4624 23 17.5 23ZM17.0965 14H18.5285C18.8776 14 19.1192 14.3487 18.9967 14.6756L18.5 16H19.1345C19.5072 16 19.7314 16.4132 19.5283 16.7257L16.9032 20.7643C16.8077 20.9113 16.6442 21 16.4688 21C16.1152 21 15.8655 20.6535 15.9773 20.3181L16.75 18H15.9715C15.6224 18 15.3808 17.6513 15.5033 17.3244L16.6283 14.3244C16.7015 14.1293 16.8881 14 17.0965 14Z " },
            { FluentSymbol.CalendarAssistant24, "M17.75 3C19.5449 3 21 4.45507 21 6.25V12.0218C20.5368 11.7253 20.0335 11.4858 19.5 11.3135V8.5H4.5V17.75C4.5 18.7165 5.2835 19.5 6.25 19.5H11.3135C11.4858 20.0335 11.7253 20.5368 12.0218 21H6.25C4.45507 21 3 19.5449 3 17.75V6.25C3 4.45507 4.45507 3 6.25 3H17.75ZM17.75 4.5H6.25C5.2835 4.5 4.5 5.2835 4.5 6.25V7H19.5V6.25C19.5 5.2835 18.7165 4.5 17.75 4.5Z M17.5 23C20.5376 23 23 20.5376 23 17.5C23 14.4624 20.5376 12 17.5 12C14.4624 12 12 14.4624 12 17.5C12 20.5376 14.4624 23 17.5 23ZM17.0965 14H18.5285C18.8776 14 19.1192 14.3487 18.9967 14.6756L18.5 16H19.1345C19.5072 16 19.7314 16.4132 19.5283 16.7257L16.9032 20.7643C16.8077 20.9113 16.6442 21 16.4688 21C16.1152 21 15.8655 20.6535 15.9773 20.3181L16.75 18H15.9715C15.6224 18 15.3808 17.6513 15.5033 17.3244L16.6283 14.3244C16.7015 14.1293 16.8881 14 17.0965 14Z " },
            { FluentSymbol.CalendarCancel16Filled, "M4.5 14H6.25716C5.47182 13.0491 5 11.8296 5 10.5C5 8.63984 5.92345 6.99537 7.33692 6H2V11.5C2 12.8807 3.11929 14 4.5 14Z M14 5H2V4.5C2 3.11929 3.11929 2 4.5 2H11.5C12.8807 2 14 3.11929 14 4.5V5Z M15 10.5C15 12.9853 12.9853 15 10.5 15C8.01472 15 6 12.9853 6 10.5C6 8.01472 8.01472 6 10.5 6C12.9853 6 15 8.01472 15 10.5ZM12.3536 9.35355C12.5488 9.15829 12.5488 8.84171 12.3536 8.64645C12.1583 8.45118 11.8417 8.45118 11.6464 8.64645L10.5 9.79289L9.35355 8.64645C9.15829 8.45118 8.84171 8.45118 8.64645 8.64645C8.45118 8.84171 8.45118 9.15829 8.64645 9.35355L9.79289 10.5L8.64645 11.6464C8.45118 11.8417 8.45118 12.1583 8.64645 12.3536C8.84171 12.5488 9.15829 12.5488 9.35355 12.3536L10.5 11.2071L11.6464 12.3536C11.8417 12.5488 12.1583 12.5488 12.3536 12.3536C12.5488 12.1583 12.5488 11.8417 12.3536 11.6464L11.2071 10.5L12.3536 9.35355Z " },
            { FluentSymbol.CalendarCancel16, "M11.5 2C12.8807 2 14 3.11929 14 4.5V6.25716C13.0491 5.47182 11.8296 5 10.5 5H13V4.5C13 3.67157 12.3284 3 11.5 3H4.5C3.67157 3 3 3.67157 3 4.5V5H10.5C9.32259 5 8.23159 5.36997 7.33692 6H3V11.5C3 12.3284 3.67157 13 4.5 13H5.59971C5.78261 13.3578 6.00353 13.6929 6.25716 14H4.5C3.11929 14 2 12.8807 2 11.5V4.5C2 3.11929 3.11929 2 4.5 2H11.5Z M15 10.5C15 12.9853 12.9853 15 10.5 15C8.01472 15 6 12.9853 6 10.5C6 8.01472 8.01472 6 10.5 6C12.9853 6 15 8.01472 15 10.5ZM12.3536 9.35355C12.5488 9.15829 12.5488 8.84171 12.3536 8.64645C12.1583 8.45118 11.8417 8.45118 11.6464 8.64645L10.5 9.79289L9.35355 8.64645C9.15829 8.45118 8.84171 8.45118 8.64645 8.64645C8.45118 8.84171 8.45118 9.15829 8.64645 9.35355L9.79289 10.5L8.64645 11.6464C8.45118 11.8417 8.45118 12.1583 8.64645 12.3536C8.84171 12.5488 9.15829 12.5488 9.35355 12.3536L10.5 11.2071L11.6464 12.3536C11.8417 12.5488 12.1583 12.5488 12.3536 12.3536C12.5488 12.1583 12.5488 11.8417 12.3536 11.6464L11.2071 10.5L12.3536 9.35355Z " },
            { FluentSymbol.CalendarCancel20Filled, "M17 7V9.59971C16.2499 9.21628 15.4002 9 14.5 9C11.4624 9 9 11.4624 9 14.5C9 15.4002 9.21628 16.2499 9.59971 17H5.5C4.11929 17 3 15.8807 3 14.5V7H17Z M14.5 3C15.8807 3 17 4.11929 17 5.5V6H3V5.5C3 4.11929 4.11929 3 5.5 3H14.5Z M19 14.5C19 16.9853 16.9853 19 14.5 19C12.0147 19 10 16.9853 10 14.5C10 12.0147 12.0147 10 14.5 10C16.9853 10 19 12.0147 19 14.5ZM14.5 15.2071L15.6464 16.3536C15.8417 16.5488 16.1583 16.5488 16.3536 16.3536C16.5488 16.1583 16.5488 15.8417 16.3536 15.6464L15.2071 14.5L16.3536 13.3536C16.5488 13.1583 16.5488 12.8417 16.3536 12.6464C16.1583 12.4512 15.8417 12.4512 15.6464 12.6464L14.5 13.7929L13.3536 12.6464C13.1583 12.4512 12.8417 12.4512 12.6464 12.6464C12.4512 12.8417 12.4512 13.1583 12.6464 13.3536L13.7929 14.5L12.6464 15.6464C12.4512 15.8417 12.4512 16.1583 12.6464 16.3536C12.8417 16.5488 13.1583 16.5488 13.3536 16.3536L14.5 15.2071Z " },
            { FluentSymbol.CalendarCancel20, "M14.5 3C15.8807 3 17 4.11929 17 5.5V9.59971C16.6832 9.43777 16.3486 9.30564 16 9.20703V7H4V14.5C4 15.3284 4.67157 16 5.5 16H9.20703C9.30564 16.3486 9.43777 16.6832 9.59971 17H5.5C4.11929 17 3 15.8807 3 14.5V5.5C3 4.11929 4.11929 3 5.5 3H14.5ZM14.5 4H5.5C4.67157 4 4 4.67157 4 5.5V6H16V5.5C16 4.67157 15.3284 4 14.5 4Z M19 14.5C19 16.9853 16.9853 19 14.5 19C12.0147 19 10 16.9853 10 14.5C10 12.0147 12.0147 10 14.5 10C16.9853 10 19 12.0147 19 14.5ZM14.5 15.2071L15.6464 16.3536C15.8417 16.5488 16.1583 16.5488 16.3536 16.3536C16.5488 16.1583 16.5488 15.8417 16.3536 15.6464L15.2071 14.5L16.3536 13.3536C16.5488 13.1583 16.5488 12.8417 16.3536 12.6464C16.1583 12.4512 15.8417 12.4512 15.6464 12.6464L14.5 13.7929L13.3536 12.6464C13.1583 12.4512 12.8417 12.4512 12.6464 12.6464C12.4512 12.8417 12.4512 13.1583 12.6464 13.3536L13.7929 14.5L12.6464 15.6464C12.4512 15.8417 12.4512 16.1583 12.6464 16.3536C12.8417 16.5488 13.1583 16.5488 13.3536 16.3536L14.5 15.2071Z " },
            { FluentSymbol.CalendarCancel24Filled, "M17.5 12C20.5376 12 23 14.4624 23 17.5C23 20.5376 20.5376 23 17.5 23C14.4624 23 12 20.5376 12 17.5C12 14.4624 14.4624 12 17.5 12ZM15.0238 15.0241C14.8285 15.2194 14.8285 15.536 15.0238 15.7312L16.793 17.501L15.0264 19.2675C14.8311 19.4628 14.8311 19.7793 15.0264 19.9746C15.2217 20.1699 15.5382 20.1699 15.7335 19.9746L17.5 18.208L19.2694 19.9768C19.4647 20.1721 19.7812 20.1721 19.9765 19.9768C20.1718 19.7816 20.1718 19.465 19.9765 19.2697L18.208 17.501L19.9793 15.7313C20.1745 15.536 20.1745 15.2194 19.9793 15.0242C19.784 14.8289 19.4674 14.8289 19.2722 15.0242L17.501 16.794L15.7309 15.0241C15.5356 14.8289 15.2191 14.8289 15.0238 15.0241ZM21 8.5L21.0012 12.0226C19.9907 11.3753 18.7892 11 17.5 11C13.9101 11 11 13.9101 11 17.5C11 18.7892 11.3753 19.9907 12.0226 21.0012L6.25 21C4.45507 21 3 19.5449 3 17.75V8.5H21ZM17.75 3C19.5449 3 21 4.45507 21 6.25V7H3V6.25C3 4.45507 4.45507 3 6.25 3H17.75Z " },
            { FluentSymbol.CalendarCancel24, "M17.5 12C20.5376 12 23 14.4624 23 17.5C23 20.5376 20.5376 23 17.5 23C14.4624 23 12 20.5376 12 17.5C12 14.4624 14.4624 12 17.5 12ZM15.0238 15.0241C14.8285 15.2194 14.8285 15.536 15.0238 15.7312L16.793 17.501L15.0264 19.2675C14.8311 19.4628 14.8311 19.7793 15.0264 19.9746C15.2217 20.1699 15.5382 20.1699 15.7335 19.9746L17.5 18.208L19.2694 19.9768C19.4647 20.1721 19.7812 20.1721 19.9765 19.9768C20.1718 19.7816 20.1718 19.465 19.9765 19.2697L18.208 17.501L19.9793 15.7313C20.1745 15.536 20.1745 15.2194 19.9793 15.0242C19.784 14.8289 19.4674 14.8289 19.2722 15.0242L17.501 16.794L15.7309 15.0241C15.5356 14.8289 15.2191 14.8289 15.0238 15.0241ZM17.75 3C19.5449 3 21 4.45507 21 6.25L21.0012 12.0226C20.5378 11.7257 20.0342 11.4861 19.5004 11.3136L19.5 8.5H4.5V17.75C4.5 18.7165 5.2835 19.5 6.25 19.5L11.3136 19.5004C11.4861 20.0342 11.7257 20.5378 12.0226 21.0012L6.25 21C4.45507 21 3 19.5449 3 17.75V6.25C3 4.45507 4.45507 3 6.25 3H17.75ZM17.75 4.5H6.25C5.2835 4.5 4.5 5.2835 4.5 6.25V7H19.5V6.25C19.5 5.2835 18.7165 4.5 17.75 4.5Z " },
            { FluentSymbol.CalendarCheckmark16Filled, "M4.5 14H6.25716C5.47182 13.0491 5 11.8296 5 10.5C5 8.63984 5.92345 6.99537 7.33692 6H2V11.5C2 12.8807 3.11929 14 4.5 14Z M14 5H2V4.5C2 3.11929 3.11929 2 4.5 2H11.5C12.8807 2 14 3.11929 14 4.5V5Z M15 10.5C15 12.9853 12.9853 15 10.5 15C8.01472 15 6 12.9853 6 10.5C6 8.01472 8.01472 6 10.5 6C12.9853 6 15 8.01472 15 10.5ZM12.8536 8.64645C12.6583 8.45118 12.3417 8.45118 12.1464 8.64645L9.5 11.2929L8.85355 10.6464C8.65829 10.4512 8.34171 10.4512 8.14645 10.6464C7.95118 10.8417 7.95118 11.1583 8.14645 11.3536L9.14645 12.3536C9.34171 12.5488 9.65829 12.5488 9.85355 12.3536L12.8536 9.35355C13.0488 9.15829 13.0488 8.84171 12.8536 8.64645Z " },
            { FluentSymbol.CalendarCheckmark16, "M11.5 2C12.8807 2 14 3.11929 14 4.5V6.25716C13.0491 5.47182 11.8296 5 10.5 5H13V4.5C13 3.67157 12.3284 3 11.5 3H4.5C3.67157 3 3 3.67157 3 4.5V5H10.5C9.32259 5 8.23159 5.36997 7.33692 6H3V11.5C3 12.3284 3.67157 13 4.5 13H5.59971C5.78261 13.3578 6.00353 13.6929 6.25716 14H4.5C3.11929 14 2 12.8807 2 11.5V4.5C2 3.11929 3.11929 2 4.5 2H11.5Z M15 10.5C15 12.9853 12.9853 15 10.5 15C8.01472 15 6 12.9853 6 10.5C6 8.01472 8.01472 6 10.5 6C12.9853 6 15 8.01472 15 10.5ZM12.8536 8.64645C12.6583 8.45118 12.3417 8.45118 12.1464 8.64645L9.5 11.2929L8.85355 10.6464C8.65829 10.4512 8.34171 10.4512 8.14645 10.6464C7.95118 10.8417 7.95118 11.1583 8.14645 11.3536L9.14645 12.3536C9.34171 12.5488 9.65829 12.5488 9.85355 12.3536L12.8536 9.35355C13.0488 9.15829 13.0488 8.84171 12.8536 8.64645Z " },
            { FluentSymbol.CalendarCheckmark20Filled, "M17 7V9.59971C16.2499 9.21628 15.4002 9 14.5 9C11.4624 9 9 11.4624 9 14.5C9 15.4002 9.21628 16.2499 9.59971 17H5.5C4.11929 17 3 15.8807 3 14.5V7H17Z M14.5 3C15.8807 3 17 4.11929 17 5.5V6H3V5.5C3 4.11929 4.11929 3 5.5 3H14.5Z M19 14.5C19 16.9853 16.9853 19 14.5 19C12.0147 19 10 16.9853 10 14.5C10 12.0147 12.0147 10 14.5 10C16.9853 10 19 12.0147 19 14.5ZM16.8536 12.6464C16.6583 12.4512 16.3417 12.4512 16.1464 12.6464L13.5 15.2929L12.8536 14.6464C12.6583 14.4512 12.3417 14.4512 12.1464 14.6464C11.9512 14.8417 11.9512 15.1583 12.1464 15.3536L13.1464 16.3536C13.3417 16.5488 13.6583 16.5488 13.8536 16.3536L16.8536 13.3536C17.0488 13.1583 17.0488 12.8417 16.8536 12.6464Z " },
            { FluentSymbol.CalendarCheckmark20, "M14.5 3C15.8807 3 17 4.11929 17 5.5V9.59971C16.6832 9.43777 16.3486 9.30564 16 9.20703V7H4V14.5C4 15.3284 4.67157 16 5.5 16H9.20703C9.30564 16.3486 9.43777 16.6832 9.59971 17H5.5C4.11929 17 3 15.8807 3 14.5V5.5C3 4.11929 4.11929 3 5.5 3H14.5ZM14.5 4H5.5C4.67157 4 4 4.67157 4 5.5V6H16V5.5C16 4.67157 15.3284 4 14.5 4Z M19 14.5C19 16.9853 16.9853 19 14.5 19C12.0147 19 10 16.9853 10 14.5C10 12.0147 12.0147 10 14.5 10C16.9853 10 19 12.0147 19 14.5ZM16.8536 12.6464C16.6583 12.4512 16.3417 12.4512 16.1464 12.6464L13.5 15.2929L12.8536 14.6464C12.6583 14.4512 12.3417 14.4512 12.1464 14.6464C11.9512 14.8417 11.9512 15.1583 12.1464 15.3536L13.1464 16.3536C13.3417 16.5488 13.6583 16.5488 13.8536 16.3536L16.8536 13.3536C17.0488 13.1583 17.0488 12.8417 16.8536 12.6464Z " },
            { FluentSymbol.CalendarCheckmark24Filled, "M21 8.5V12.0218C19.9897 11.375 18.7886 11 17.5 11C13.9101 11 11 13.9101 11 17.5C11 18.7886 11.375 19.9897 12.0218 21H6.25C4.45507 21 3 19.5449 3 17.75V8.5H21Z M17.75 3C19.5449 3 21 4.45507 21 6.25V7H3V6.25C3 4.45507 4.45507 3 6.25 3H17.75Z M23 17.5C23 20.5376 20.5376 23 17.5 23C14.4624 23 12 20.5376 12 17.5C12 14.4624 14.4624 12 17.5 12C20.5376 12 23 14.4624 23 17.5ZM20.8536 15.1464C20.6583 14.9512 20.3417 14.9512 20.1464 15.1464L16.5 18.7929L14.8536 17.1464C14.6583 16.9512 14.3417 16.9512 14.1464 17.1464C13.9512 17.3417 13.9512 17.6583 14.1464 17.8536L16.1464 19.8536C16.3417 20.0488 16.6583 20.0488 16.8536 19.8536L20.8536 15.8536C21.0488 15.6583 21.0488 15.3417 20.8536 15.1464Z " },
            { FluentSymbol.CalendarCheckmark24, "M17.75 3C19.5449 3 21 4.45507 21 6.25V12.0218C20.5368 11.7253 20.0335 11.4858 19.5 11.3135V8.5H4.5V17.75C4.5 18.7165 5.2835 19.5 6.25 19.5H11.3135C11.4858 20.0335 11.7253 20.5368 12.0218 21H6.25C4.45507 21 3 19.5449 3 17.75V6.25C3 4.45507 4.45507 3 6.25 3H17.75ZM17.75 4.5H6.25C5.2835 4.5 4.5 5.2835 4.5 6.25V7H19.5V6.25C19.5 5.2835 18.7165 4.5 17.75 4.5Z M23 17.5C23 20.5376 20.5376 23 17.5 23C14.4624 23 12 20.5376 12 17.5C12 14.4624 14.4624 12 17.5 12C20.5376 12 23 14.4624 23 17.5ZM20.8536 15.1464C20.6583 14.9512 20.3417 14.9512 20.1464 15.1464L16.5 18.7929L14.8536 17.1464C14.6583 16.9512 14.3417 16.9512 14.1464 17.1464C13.9512 17.3417 13.9512 17.6583 14.1464 17.8536L16.1464 19.8536C16.3417 20.0488 16.6583 20.0488 16.8536 19.8536L20.8536 15.8536C21.0488 15.6583 21.0488 15.3417 20.8536 15.1464Z " },
            { FluentSymbol.CalendarClock16Filled, "M4.5 14H6.25716C5.47182 13.0491 5 11.8296 5 10.5C5 8.63984 5.92345 6.99537 7.33692 6H2V11.5C2 12.8807 3.11929 14 4.5 14Z M14 5H2V4.5C2 3.11929 3.11929 2 4.5 2H11.5C12.8807 2 14 3.11929 14 4.5V5Z M10.5 15C12.9853 15 15 12.9853 15 10.5C15 8.01472 12.9853 6 10.5 6C8.01472 6 6 8.01472 6 10.5C6 12.9853 8.01472 15 10.5 15ZM10 8.5C10 8.22386 10.2239 8 10.5 8C10.7761 8 11 8.22386 11 8.5V10H12C12.2761 10 12.5 10.2239 12.5 10.5C12.5 10.7761 12.2761 11 12 11H10.5C10.2239 11 10 10.7761 10 10.5V8.5Z " },
            { FluentSymbol.CalendarClock16, "M11.5 2C12.8807 2 14 3.11929 14 4.5V6.25716C13.0491 5.47182 11.8296 5 10.5 5H13V4.5C13 3.67157 12.3284 3 11.5 3H4.5C3.67157 3 3 3.67157 3 4.5V5H10.5C9.32259 5 8.23159 5.36997 7.33692 6H3V11.5C3 12.3284 3.67157 13 4.5 13H5.59971C5.78261 13.3578 6.00353 13.6929 6.25716 14H4.5C3.11929 14 2 12.8807 2 11.5V4.5C2 3.11929 3.11929 2 4.5 2H11.5Z M10.5 15C12.9853 15 15 12.9853 15 10.5C15 8.01472 12.9853 6 10.5 6C8.01472 6 6 8.01472 6 10.5C6 12.9853 8.01472 15 10.5 15ZM10 8.5C10 8.22386 10.2239 8 10.5 8C10.7761 8 11 8.22386 11 8.5V10H12C12.2761 10 12.5 10.2239 12.5 10.5C12.5 10.7761 12.2761 11 12 11H10.5C10.2239 11 10 10.7761 10 10.5V8.5Z " },
            { FluentSymbol.CalendarClock20Filled, "M17 5.5C17 4.11929 15.8807 3 14.5 3H5.5C4.11929 3 3 4.11929 3 5.5V6H17V5.5Z M17 9.59971V7H3V14.5C3 15.8807 4.11929 17 5.5 17H9.59971C9.21628 16.2499 9 15.4002 9 14.5C9 11.4624 11.4624 9 14.5 9C15.4002 9 16.2499 9.21628 17 9.59971Z M14.5 19C16.9853 19 19 16.9853 19 14.5C19 12.0147 16.9853 10 14.5 10C12.0147 10 10 12.0147 10 14.5C10 16.9853 12.0147 19 14.5 19ZM14 12.5C14 12.2239 14.2239 12 14.5 12C14.7761 12 15 12.2239 15 12.5V14H16C16.2761 14 16.5 14.2239 16.5 14.5C16.5 14.7761 16.2761 15 16 15H14.5C14.2239 15 14 14.7761 14 14.5V12.5Z " },
            { FluentSymbol.CalendarClock20, "M17 5.5C17 4.11929 15.8807 3 14.5 3H5.5C4.11929 3 3 4.11929 3 5.5V14.5C3 15.8807 4.11929 17 5.5 17H9.59971C9.43777 16.6832 9.30564 16.3486 9.20703 16H5.5C4.67157 16 4 15.3284 4 14.5V7H16V9.20703C16.3486 9.30564 16.6832 9.43777 17 9.59971V5.5ZM5.5 4H14.5C15.3284 4 16 4.67157 16 5.5V6H4V5.5C4 4.67157 4.67157 4 5.5 4Z M14.5 19C16.9853 19 19 16.9853 19 14.5C19 12.0147 16.9853 10 14.5 10C12.0147 10 10 12.0147 10 14.5C10 16.9853 12.0147 19 14.5 19ZM14 12.5C14 12.2239 14.2239 12 14.5 12C14.7761 12 15 12.2239 15 12.5V14H16C16.2761 14 16.5 14.2239 16.5 14.5C16.5 14.7761 16.2761 15 16 15H14.5C14.2239 15 14 14.7761 14 14.5V12.5Z " },
            { FluentSymbol.CalendarClock24Filled, "M17.75 3C19.5449 3 21 4.45507 21 6.25V7H3V6.25C3 4.45507 4.45507 3 6.25 3H17.75Z M21 8.5V12.0218C19.9897 11.375 18.7886 11 17.5 11C13.9101 11 11 13.9101 11 17.5C11 18.7886 11.375 19.9897 12.0218 21H6.25C4.45507 21 3 19.5449 3 17.75V8.5H21Z M23 17.5C23 14.4624 20.5376 12 17.5 12C14.4624 12 12 14.4624 12 17.5C12 20.5376 14.4624 23 17.5 23C20.5376 23 23 20.5376 23 17.5ZM17.5 17.5001H19.5C19.7761 17.5001 20 17.7239 20 18.0001C20 18.2762 19.7761 18.5001 19.5 18.5001H17C16.7239 18.5001 16.5 18.2762 16.5 18.0001L16.5 17.9985L16.5 14.9999C16.5 14.7238 16.7239 14.4999 17 14.4999C17.2761 14.4999 17.5 14.7238 17.5 14.9999L17.5 17.5001Z " },
            { FluentSymbol.CalendarClock24, "M21 6.25C21 4.45507 19.5449 3 17.75 3H6.25C4.45507 3 3 4.45507 3 6.25V17.75C3 19.5449 4.45507 21 6.25 21H12.0218C11.7253 20.5368 11.4858 20.0335 11.3135 19.5H6.25C5.2835 19.5 4.5 18.7165 4.5 17.75V8.5H19.5V11.3135C20.0335 11.4858 20.5368 11.7253 21 12.0218V6.25ZM6.25 4.5H17.75C18.7165 4.5 19.5 5.2835 19.5 6.25V7H4.5V6.25C4.5 5.2835 5.2835 4.5 6.25 4.5Z M23 17.5C23 14.4624 20.5376 12 17.5 12C14.4624 12 12 14.4624 12 17.5C12 20.5376 14.4624 23 17.5 23C20.5376 23 23 20.5376 23 17.5ZM17.5 17.5H19.5C19.7761 17.5 20 17.7239 20 18C20 18.2762 19.7761 18.5 19.5 18.5H17C16.7268 18.5 16.5048 18.2809 16.5001 18.0089L16.5 17.9999V14.9999C16.5 14.7238 16.7239 14.4999 17 14.4999C17.2761 14.4999 17.5 14.7238 17.5 14.9999L17.5 17.5Z " },
            { FluentSymbol.CalendarDay20Filled, "M14.5 3C15.8807 3 17 4.11929 17 5.5V14.5C17 15.8807 15.8807 17 14.5 17H5.5C4.11929 17 3 15.8807 3 14.5V5.5C3 4.11929 4.11929 3 5.5 3H14.5ZM12.7181 9H7.28194C6.83618 9 6.67454 9.04641 6.51158 9.13357C6.34861 9.22072 6.22072 9.34861 6.13357 9.51158C6.05731 9.65417 6.01224 9.79575 6.00216 10.1275L6 10.2819V12.7181C6 13.1638 6.04641 13.3255 6.13357 13.4884C6.22072 13.6514 6.34861 13.7793 6.51158 13.8664C6.65417 13.9427 6.79575 13.9878 7.12754 13.9978L7.28194 14H12.7181C13.1638 14 13.3255 13.9536 13.4884 13.8664C13.6514 13.7793 13.7793 13.6514 13.8664 13.4884C13.9427 13.3458 13.9878 13.2042 13.9978 12.8725L14 12.7181V10.2819C14 9.83618 13.9536 9.67454 13.8664 9.51158C13.7793 9.34861 13.6514 9.22072 13.4884 9.13357C13.3458 9.05731 13.2042 9.01224 12.8725 9.00216L12.7181 9ZM12.9122 10.0018L12.9926 10.0074L12.9982 10.0878V12.9122L12.9926 12.9926L12.9122 12.9982H7.0878L7.0074 12.9926L7.00175 12.9122V10.0878L7.0074 10.0074L7.0878 10.0018H12.9122ZM13.5 6H6.5L6.41012 6.00806C6.17688 6.05039 6 6.25454 6 6.5C6 6.74546 6.17688 6.94961 6.41012 6.99194L6.5 7H13.5L13.5899 6.99194C13.8231 6.94961 14 6.74546 14 6.5C14 6.25454 13.8231 6.05039 13.5899 6.00806L13.5 6Z " },
            { FluentSymbol.CalendarDay20, "M14.5 3C15.8807 3 17 4.11929 17 5.5V14.5C17 15.8807 15.8807 17 14.5 17H5.5C4.11929 17 3 15.8807 3 14.5V5.5C3 4.11929 4.11929 3 5.5 3H14.5ZM14.5 4H5.5C4.67157 4 4 4.67157 4 5.5V14.5C4 15.3284 4.67157 16 5.5 16H14.5C15.3284 16 16 15.3284 16 14.5V5.5C16 4.67157 15.3284 4 14.5 4ZM12.7181 9C13.1638 9 13.3255 9.04641 13.4884 9.13357C13.6514 9.22072 13.7793 9.34861 13.8664 9.51158C13.9536 9.67454 14 9.83618 14 10.2819V12.7181C14 13.1638 13.9536 13.3255 13.8664 13.4884C13.7793 13.6514 13.6514 13.7793 13.4884 13.8664C13.3255 13.9536 13.1638 14 12.7181 14H7.28194C6.83618 14 6.67454 13.9536 6.51158 13.8664C6.34861 13.7793 6.22072 13.6514 6.13357 13.4884C6.04641 13.3255 6 13.1638 6 12.7181V10.2819C6 9.83618 6.04641 9.67454 6.13357 9.51158C6.22072 9.34861 6.34861 9.22072 6.51158 9.13357C6.67454 9.04641 6.83618 9 7.28194 9H12.7181ZM12.9122 10.0018H7.0878L7.0074 10.0074L7.00175 10.0878V12.9122L7.0074 12.9926L7.0878 12.9982H12.9122L12.9926 12.9926L12.9982 12.9122V10.0878L12.9926 10.0074L12.9122 10.0018ZM13.5 6C13.7761 6 14 6.22386 14 6.5C14 6.74546 13.8231 6.94961 13.5899 6.99194L13.5 7H6.5C6.22386 7 6 6.77614 6 6.5C6 6.25454 6.17688 6.05039 6.41012 6.00806L6.5 6H13.5Z " },
            { FluentSymbol.CalendarDay24Filled, "M17.75 3C19.5449 3 21 4.45507 21 6.25V17.75C21 19.5449 19.5449 21 17.75 21H6.25C4.45507 21 3 19.5449 3 17.75V6.25C3 4.45507 4.45507 3 6.25 3H17.75ZM16.25 11H7.75C7.3703 11 7.05651 11.2822 7.00685 11.6482L7 11.75V16.25C7 16.6297 7.28215 16.9435 7.64823 16.9932L7.75 17H16.25C16.6297 17 16.9435 16.7178 16.9932 16.3518L17 16.25V11.75C17 11.3703 16.7178 11.0565 16.3518 11.0068L16.25 11ZM15.5 12.5V15.5H8.5V12.5H15.5ZM16.25 7.25H7.75C7.33579 7.25 7 7.58579 7 8C7 8.41421 7.33579 8.75 7.75 8.75H16.25C16.6642 8.75 17 8.41421 17 8C17 7.58579 16.6642 7.25 16.25 7.25Z " },
            { FluentSymbol.CalendarDay24, "M17.75 3C19.5449 3 21 4.45507 21 6.25V17.75C21 19.5449 19.5449 21 17.75 21H6.25C4.45507 21 3 19.5449 3 17.75V6.25C3 4.45507 4.45507 3 6.25 3H17.75ZM17.75 4.5H6.25C5.2835 4.5 4.5 5.2835 4.5 6.25V17.75C4.5 18.7165 5.2835 19.5 6.25 19.5H17.75C18.7165 19.5 19.5 18.7165 19.5 17.75V6.25C19.5 5.2835 18.7165 4.5 17.75 4.5ZM16.25 11C16.6642 11 17 11.3358 17 11.75V16.25C17 16.6642 16.6642 17 16.25 17H7.75C7.33579 17 7 16.6642 7 16.25V11.75C7 11.3358 7.33579 11 7.75 11H16.25ZM15.5 12.5H8.5V15.5H15.5V12.5ZM7.75 7.25H16.25C16.6642 7.25 17 7.58579 17 8C17 8.3797 16.7178 8.69349 16.3518 8.74315L16.25 8.75H7.75C7.33579 8.75 7 8.41421 7 8C7 7.6203 7.28215 7.30651 7.64823 7.25685L7.75 7.25H16.25H7.75Z " },
            { FluentSymbol.CalendarDay28Filled, "M21.75 3C23.5449 3 25 4.45507 25 6.25V21.75C25 23.5449 23.5449 25 21.75 25H6.25C4.45507 25 3 23.5449 3 21.75V6.25C3 4.45507 4.45507 3 6.25 3H21.75ZM19 12H9C8.48716 12 8.06449 12.386 8.00673 12.8834L8 13V19C8 19.5128 8.38604 19.9355 8.88338 19.9933L9 20H19C19.5128 20 19.9355 19.614 19.9933 19.1166L20 19V13C20 12.4872 19.614 12.0645 19.1166 12.0067L19 12ZM18.5 13.5V18.5H9.5V13.5H18.5ZM19 8H9L8.89823 8.00685C8.53215 8.05651 8.25 8.3703 8.25 8.75C8.25 9.1297 8.53215 9.44349 8.89823 9.49315L9 9.5H19L19.1018 9.49315C19.4678 9.44349 19.75 9.1297 19.75 8.75C19.75 8.3703 19.4678 8.05651 19.1018 8.00685L19 8Z " },
            { FluentSymbol.CalendarDay28, "M21.75 3C23.5449 3 25 4.45507 25 6.25V21.75C25 23.5449 23.5449 25 21.75 25H6.25C4.45507 25 3 23.5449 3 21.75V6.25C3 4.45507 4.45507 3 6.25 3H21.75ZM21.75 4.5H6.25C5.2835 4.5 4.5 5.2835 4.5 6.25V21.75C4.5 22.7165 5.2835 23.5 6.25 23.5H21.75C22.7165 23.5 23.5 22.7165 23.5 21.75V6.25C23.5 5.2835 22.7165 4.5 21.75 4.5ZM19 12C19.5523 12 20 12.4477 20 13V19C20 19.5523 19.5523 20 19 20H9C8.44772 20 8 19.5523 8 19V13C8 12.4477 8.44772 12 9 12H19ZM18.5 13.5H9.5V18.5H18.5V13.5ZM19 8C19.4142 8 19.75 8.33579 19.75 8.75C19.75 9.1297 19.4678 9.44349 19.1018 9.49315L19 9.5H9C8.58579 9.5 8.25 9.16421 8.25 8.75C8.25 8.3703 8.53215 8.05651 8.89823 8.00685L9 8H19Z " },
            { FluentSymbol.CalendarEmpty16Filled, "M14 6V11.5C14 12.8807 12.8807 14 11.5 14H4.5C3.11929 14 2 12.8807 2 11.5V6H14ZM11.5 2C12.8807 2 14 3.11929 14 4.5V5H2V4.5C2 3.11929 3.11929 2 4.5 2H11.5Z " },
            { FluentSymbol.CalendarEmpty16, "M11.5 2C12.8807 2 14 3.11929 14 4.5V11.5C14 12.8807 12.8807 14 11.5 14H4.5C3.11929 14 2 12.8807 2 11.5V4.5C2 3.11929 3.11929 2 4.5 2H11.5ZM13 6H3V11.5C3 12.3284 3.67157 13 4.5 13H11.5C12.3284 13 13 12.3284 13 11.5V6ZM11.5 3H4.5C3.67157 3 3 3.67157 3 4.5V5H13V4.5C13 3.67157 12.3284 3 11.5 3Z " },
            { FluentSymbol.CalendarEmpty20Filled, "M17 7V14.5C17 15.8807 15.8807 17 14.5 17H5.5C4.11929 17 3 15.8807 3 14.5V7H17ZM14.5 3C15.8807 3 17 4.11929 17 5.5V6H3V5.5C3 4.11929 4.11929 3 5.5 3H14.5Z " },
            { FluentSymbol.CalendarEmpty20, "M14.5 3C15.8807 3 17 4.11929 17 5.5V14.5C17 15.8807 15.8807 17 14.5 17H5.5C4.11929 17 3 15.8807 3 14.5V5.5C3 4.11929 4.11929 3 5.5 3H14.5ZM16 7H4V14.5C4 15.3284 4.67157 16 5.5 16H14.5C15.3284 16 16 15.3284 16 14.5V7ZM14.5 4H5.5C4.67157 4 4 4.67157 4 5.5V6H16V5.5C16 4.67157 15.3284 4 14.5 4Z " },
            { FluentSymbol.CalendarEmpty24Filled, "M21 8.5V17.75C21 19.5449 19.5449 21 17.75 21H6.25C4.45507 21 3 19.5449 3 17.75V8.5H21ZM17.75 3C19.5449 3 21 4.45507 21 6.25V7H3V6.25C3 4.45507 4.45507 3 6.25 3H17.75Z " },
            { FluentSymbol.CalendarEmpty24, "M17.75 3C19.5449 3 21 4.45507 21 6.25V17.75C21 19.5449 19.5449 21 17.75 21H6.25C4.45507 21 3 19.5449 3 17.75V6.25C3 4.45507 4.45507 3 6.25 3H17.75ZM19.5 8.5H4.5V17.75C4.5 18.7165 5.2835 19.5 6.25 19.5H17.75C18.7165 19.5 19.5 18.7165 19.5 17.75V8.5ZM17.75 4.5H6.25C5.2835 4.5 4.5 5.2835 4.5 6.25V7H19.5V6.25C19.5 5.2835 18.7165 4.5 17.75 4.5Z " },
            { FluentSymbol.CalendarEmpty28Filled, "M25 9.5V21.75C25 23.5449 23.5449 25 21.75 25H6.25C4.45507 25 3 23.5449 3 21.75V9.5H25ZM21.75 3C23.5449 3 25 4.45507 25 6.25V8H3V6.25C3 4.45507 4.45507 3 6.25 3H21.75Z " },
            { FluentSymbol.CalendarEmpty28, "M21.75 3C23.5449 3 25 4.45507 25 6.25V21.75C25 23.5449 23.5449 25 21.75 25H6.25C4.45507 25 3 23.5449 3 21.75V6.25C3 4.45507 4.45507 3 6.25 3H21.75ZM23.5 9.503H4.5V21.75C4.5 22.7165 5.2835 23.5 6.25 23.5H21.75C22.7165 23.5 23.5 22.7165 23.5 21.75V9.503ZM21.75 4.5H6.25C5.2835 4.5 4.5 5.2835 4.5 6.25V8.003H23.5V6.25C23.5 5.2835 22.7165 4.5 21.75 4.5Z " },
            { FluentSymbol.CalendarEmpty32Filled, "M7.5 3C5.01472 3 3 5.01472 3 7.5V9H29V7.5C29 5.01472 26.9853 3 24.5 3H7.5ZM29 11H3V24.5C3 26.9853 5.01472 29 7.5 29H24.5C26.9853 29 29 26.9853 29 24.5V11Z " },
            { FluentSymbol.CalendarEmpty32, "M7.5 3C5.01472 3 3 5.01472 3 7.5V24.5C3 26.9853 5.01472 29 7.5 29H24.5C26.9853 29 29 26.9853 29 24.5V7.5C29 5.01472 26.9853 3 24.5 3H7.5ZM5 7.5C5 6.11929 6.11929 5 7.5 5H24.5C25.8807 5 27 6.11929 27 7.5V9H5V7.5ZM5 11H27V24.5C27 25.8807 25.8807 27 24.5 27H7.5C6.11929 27 5 25.8807 5 24.5V11Z " },
            { FluentSymbol.CalendarMention20Filled, "M17 7V10.416C16.3875 10.1484 15.7111 10 15 10C12.2386 10 10 12.2386 10 15C10 15.7111 10.1484 16.3875 10.416 17H5.5C4.11929 17 3 15.8807 3 14.5V7H17Z M14.5 3C15.8807 3 17 4.11929 17 5.5V6H3V5.5C3 4.11929 4.11929 3 5.5 3H14.5Z M15.0015 12C13.3438 12 12 13.3438 12 15.0015C12 16.6592 13.3438 18.003 15.0015 18.003C15.4614 18.003 15.8916 17.898 16.2847 17.7105C16.5339 17.5916 16.8324 17.6972 16.9513 17.9465C17.0702 18.1957 16.9645 18.4941 16.7153 18.613C16.1945 18.8615 15.6177 19.003 15.0015 19.003C12.7915 19.003 11 17.2115 11 15.0015C11 12.7915 12.7915 11 15.0015 11C17.2102 11 19.0009 12.7894 19.003 14.9975L19.003 15V15.498C19.003 16.3272 18.3308 16.9995 17.5015 16.9995C17.0428 16.9995 16.6321 16.7938 16.3567 16.4695C16.0001 16.7988 15.5236 17 15 17C13.8954 17 13 16.1046 13 15C13 13.8954 13.8954 13 15 13C15.4359 13 15.8393 13.1395 16.1679 13.3762C16.2562 13.2977 16.3725 13.25 16.5 13.25C16.7761 13.25 17 13.4739 17 13.75V15.498C17 15.775 17.2245 15.9995 17.5015 15.9995C17.7785 15.9995 18.003 15.775 18.003 15.498V15.0015C18.003 13.3438 16.6592 12 15.0015 12ZM14 15C14 15.5523 14.4477 16 15 16C15.5523 16 16 15.5523 16 15C16 14.4477 15.5523 14 15 14C14.4477 14 14 14.4477 14 15Z " },
            { FluentSymbol.CalendarMention20, "M14.5 3C15.8807 3 17 4.11929 17 5.5V10.416C16.6825 10.2773 16.3478 10.1706 16 10.1V7H4V14.5C4 15.3284 4.67157 16 5.5 16H10.1C10.1706 16.3478 10.2773 16.6825 10.416 17H5.5C4.11929 17 3 15.8807 3 14.5V5.5C3 4.11929 4.11929 3 5.5 3H14.5ZM14.5 4H5.5C4.67157 4 4 4.67157 4 5.5V6H16V5.5C16 4.67157 15.3284 4 14.5 4Z M15.0015 12C13.3438 12 12 13.3438 12 15.0015C12 16.6592 13.3438 18.003 15.0015 18.003C15.4614 18.003 15.8916 17.898 16.2847 17.7105C16.5339 17.5916 16.8324 17.6972 16.9513 17.9465C17.0702 18.1957 16.9645 18.4941 16.7153 18.613C16.1945 18.8615 15.6177 19.003 15.0015 19.003C12.7915 19.003 11 17.2115 11 15.0015C11 12.7915 12.7915 11 15.0015 11C17.2102 11 19.0009 12.7894 19.003 14.9975L19.003 15V15.498C19.003 16.3272 18.3308 16.9995 17.5015 16.9995C17.0428 16.9995 16.6321 16.7938 16.3567 16.4695C16.0001 16.7988 15.5236 17 15 17C13.8954 17 13 16.1046 13 15C13 13.8954 13.8954 13 15 13C15.4359 13 15.8393 13.1395 16.1679 13.3762C16.2562 13.2977 16.3725 13.25 16.5 13.25C16.7761 13.25 17 13.4739 17 13.75V15.498C17 15.775 17.2245 15.9995 17.5015 15.9995C17.7785 15.9995 18.003 15.775 18.003 15.498V15.0015C18.003 13.3438 16.6592 12 15.0015 12ZM14 15C14 15.5523 14.4477 16 15 16C15.5523 16 16 15.5523 16 15C16 14.4477 15.5523 14 15 14C14.4477 14 14 14.4477 14 15Z " },
            { FluentSymbol.CalendarMonth20Filled, "M14.5 3C15.8807 3 17 4.11929 17 5.5V14.5C17 15.8807 15.8807 17 14.5 17H5.5C4.11929 17 3 15.8807 3 14.5V5.5C3 4.11929 4.11929 3 5.5 3H14.5ZM7 11C6.44772 11 6 11.4477 6 12C6 12.5523 6.44772 13 7 13C7.55228 13 8 12.5523 8 12C8 11.4477 7.55228 11 7 11ZM10 11C9.44772 11 9 11.4477 9 12C9 12.5523 9.44772 13 10 13C10.5523 13 11 12.5523 11 12C11 11.4477 10.5523 11 10 11ZM7 7C6.44772 7 6 7.44772 6 8C6 8.55228 6.44772 9 7 9C7.55228 9 8 8.55228 8 8C8 7.44772 7.55228 7 7 7ZM10 7C9.44772 7 9 7.44772 9 8C9 8.55228 9.44772 9 10 9C10.5523 9 11 8.55228 11 8C11 7.44772 10.5523 7 10 7ZM13 7C12.4477 7 12 7.44772 12 8C12 8.55228 12.4477 9 13 9C13.5523 9 14 8.55228 14 8C14 7.44772 13.5523 7 13 7Z " },
            { FluentSymbol.CalendarMonth20, "M14.5 3C15.8807 3 17 4.11929 17 5.5V14.5C17 15.8807 15.8807 17 14.5 17H5.5C4.11929 17 3 15.8807 3 14.5V5.5C3 4.11929 4.11929 3 5.5 3H14.5ZM14.5 4H5.5C4.67157 4 4 4.67157 4 5.5V14.5C4 15.3284 4.67157 16 5.5 16H14.5C15.3284 16 16 15.3284 16 14.5V5.5C16 4.67157 15.3284 4 14.5 4ZM7 11C7.55228 11 8 11.4477 8 12C8 12.5523 7.55228 13 7 13C6.44772 13 6 12.5523 6 12C6 11.4477 6.44772 11 7 11ZM10 11C10.5523 11 11 11.4477 11 12C11 12.5523 10.5523 13 10 13C9.44772 13 9 12.5523 9 12C9 11.4477 9.44772 11 10 11ZM7 7C7.55228 7 8 7.44772 8 8C8 8.55228 7.55228 9 7 9C6.44772 9 6 8.55228 6 8C6 7.44772 6.44772 7 7 7ZM10 7C10.5523 7 11 7.44772 11 8C11 8.55228 10.5523 9 10 9C9.44772 9 9 8.55228 9 8C9 7.44772 9.44772 7 10 7ZM13 7C13.5523 7 14 7.44772 14 8C14 8.55228 13.5523 9 13 9C12.4477 9 12 8.55228 12 8C12 7.44772 12.4477 7 13 7Z " },
            { FluentSymbol.CalendarMonth24Filled, "M17.75 3C19.5449 3 21 4.45507 21 6.25V17.75C21 19.5449 19.5449 21 17.75 21H6.25C4.45507 21 3 19.5449 3 17.75V6.25C3 4.45507 4.45507 3 6.25 3H17.75ZM7.75 13.5C7.05964 13.5 6.5 14.0596 6.5 14.75C6.5 15.4404 7.05964 16 7.75 16C8.44036 16 9 15.4404 9 14.75C9 14.0596 8.44036 13.5 7.75 13.5ZM12 13.5C11.3096 13.5 10.75 14.0596 10.75 14.75C10.75 15.4404 11.3096 16 12 16C12.6904 16 13.25 15.4404 13.25 14.75C13.25 14.0596 12.6904 13.5 12 13.5ZM7.75 8.5C7.05964 8.5 6.5 9.05964 6.5 9.75C6.5 10.4404 7.05964 11 7.75 11C8.44036 11 9 10.4404 9 9.75C9 9.05964 8.44036 8.5 7.75 8.5ZM12 8.5C11.3096 8.5 10.75 9.05964 10.75 9.75C10.75 10.4404 11.3096 11 12 11C12.6904 11 13.25 10.4404 13.25 9.75C13.25 9.05964 12.6904 8.5 12 8.5ZM16.25 8.5C15.5596 8.5 15 9.05964 15 9.75C15 10.4404 15.5596 11 16.25 11C16.9404 11 17.5 10.4404 17.5 9.75C17.5 9.05964 16.9404 8.5 16.25 8.5Z " },
            { FluentSymbol.CalendarMonth24, "M17.75 3C19.5449 3 21 4.45507 21 6.25V17.75C21 19.5449 19.5449 21 17.75 21H6.25C4.45507 21 3 19.5449 3 17.75V6.25C3 4.45507 4.45507 3 6.25 3H17.75ZM17.75 4.5H6.25C5.2835 4.5 4.5 5.2835 4.5 6.25V17.75C4.5 18.7165 5.2835 19.5 6.25 19.5H17.75C18.7165 19.5 19.5 18.7165 19.5 17.75V6.25C19.5 5.2835 18.7165 4.5 17.75 4.5ZM7.75 13.5C8.44036 13.5 9 14.0596 9 14.75C9 15.4404 8.44036 16 7.75 16C7.05964 16 6.5 15.4404 6.5 14.75C6.5 14.0596 7.05964 13.5 7.75 13.5ZM12 13.5C12.6904 13.5 13.25 14.0596 13.25 14.75C13.25 15.4404 12.6904 16 12 16C11.3096 16 10.75 15.4404 10.75 14.75C10.75 14.0596 11.3096 13.5 12 13.5ZM7.75 8.5C8.44036 8.5 9 9.05964 9 9.75C9 10.4404 8.44036 11 7.75 11C7.05964 11 6.5 10.4404 6.5 9.75C6.5 9.05964 7.05964 8.5 7.75 8.5ZM12 8.5C12.6904 8.5 13.25 9.05964 13.25 9.75C13.25 10.4404 12.6904 11 12 11C11.3096 11 10.75 10.4404 10.75 9.75C10.75 9.05964 11.3096 8.5 12 8.5ZM16.25 8.5C16.9404 8.5 17.5 9.05964 17.5 9.75C17.5 10.4404 16.9404 11 16.25 11C15.5596 11 15 10.4404 15 9.75C15 9.05964 15.5596 8.5 16.25 8.5Z " },
            { FluentSymbol.CalendarMonth28Filled, "M21.75 3C23.5449 3 25 4.45507 25 6.25V21.75C25 23.5449 23.5449 25 21.75 25H6.25C4.45507 25 3 23.5449 3 21.75V6.25C3 4.45507 4.45507 3 6.25 3H21.75ZM8.5 15.5C7.67157 15.5 7 16.1716 7 17C7 17.8284 7.67157 18.5 8.5 18.5C9.32843 18.5 10 17.8284 10 17C10 16.1716 9.32843 15.5 8.5 15.5ZM14 15.5C13.1716 15.5 12.5 16.1716 12.5 17C12.5 17.8284 13.1716 18.5 14 18.5C14.8284 18.5 15.5 17.8284 15.5 17C15.5 16.1716 14.8284 15.5 14 15.5ZM8.5 9.5C7.67157 9.5 7 10.1716 7 11C7 11.8284 7.67157 12.5 8.5 12.5C9.32843 12.5 10 11.8284 10 11C10 10.1716 9.32843 9.5 8.5 9.5ZM14 9.5C13.1716 9.5 12.5 10.1716 12.5 11C12.5 11.8284 13.1716 12.5 14 12.5C14.8284 12.5 15.5 11.8284 15.5 11C15.5 10.1716 14.8284 9.5 14 9.5ZM19.5 9.5C18.6716 9.5 18 10.1716 18 11C18 11.8284 18.6716 12.5 19.5 12.5C20.3284 12.5 21 11.8284 21 11C21 10.1716 20.3284 9.5 19.5 9.5Z " },
            { FluentSymbol.CalendarMonth28, "M21.75 3C23.5449 3 25 4.45507 25 6.25V21.75C25 23.5449 23.5449 25 21.75 25H6.25C4.45507 25 3 23.5449 3 21.75V6.25C3 4.45507 4.45507 3 6.25 3H21.75ZM21.75 4.5H6.25C5.2835 4.5 4.5 5.2835 4.5 6.25V21.75C4.5 22.7165 5.2835 23.5 6.25 23.5H21.75C22.7165 23.5 23.5 22.7165 23.5 21.75V6.25C23.5 5.2835 22.7165 4.5 21.75 4.5ZM8.5 15.5C9.32843 15.5 10 16.1716 10 17C10 17.8284 9.32843 18.5 8.5 18.5C7.67157 18.5 7 17.8284 7 17C7 16.1716 7.67157 15.5 8.5 15.5ZM14 15.5C14.8284 15.5 15.5 16.1716 15.5 17C15.5 17.8284 14.8284 18.5 14 18.5C13.1716 18.5 12.5 17.8284 12.5 17C12.5 16.1716 13.1716 15.5 14 15.5ZM8.5 9.5C9.32843 9.5 10 10.1716 10 11C10 11.8284 9.32843 12.5 8.5 12.5C7.67157 12.5 7 11.8284 7 11C7 10.1716 7.67157 9.5 8.5 9.5ZM14 9.5C14.8284 9.5 15.5 10.1716 15.5 11C15.5 11.8284 14.8284 12.5 14 12.5C13.1716 12.5 12.5 11.8284 12.5 11C12.5 10.1716 13.1716 9.5 14 9.5ZM19.5 9.5C20.3284 9.5 21 10.1716 21 11C21 11.8284 20.3284 12.5 19.5 12.5C18.6716 12.5 18 11.8284 18 11C18 10.1716 18.6716 9.5 19.5 9.5Z " },
            { FluentSymbol.CalendarMultiple20Filled, "M16 13.5V6H2V13.5C2 14.8807 3.11929 16 4.5 16H13.5C14.8807 16 16 14.8807 16 13.5Z M16 4.5C16 3.11929 14.8807 2 13.5 2H4.5C3.11929 2 2 3.11929 2 4.5V5H16V4.5Z M4.99952 17C5.45562 17.6072 6.18179 18 6.9997 18H13.4999C15.9852 18 17.9999 15.9853 17.9999 13.5L17.9997 6.5C17.9997 5.68209 17.6069 4.9561 16.9997 4.5L16.9999 13.5C16.9999 15.433 15.4329 17 13.4999 17H4.99952Z " },
            { FluentSymbol.CalendarMultiple20, "M16 4.5C16 3.11929 14.8807 2 13.5 2H4.5C3.11929 2 2 3.11929 2 4.5V13.5C2 14.8807 3.11929 16 4.5 16H13.5C14.8807 16 16 14.8807 16 13.5V4.5ZM3 6H15V13.5C15 14.3284 14.3284 15 13.5 15H4.5C3.67157 15 3 14.3284 3 13.5V6ZM4.5 3H13.5C14.3284 3 15 3.67157 15 4.5V5H3V4.5C3 3.67157 3.67157 3 4.5 3Z M4.99952 17C5.45562 17.6072 6.18179 18 6.9997 18H13.4999C15.9852 18 17.9999 15.9853 17.9999 13.5L17.9997 6.5C17.9997 5.68209 17.6069 4.9561 16.9997 4.5L16.9999 13.5C16.9999 15.433 15.4329 17 13.4999 17H4.99952Z " },
            { FluentSymbol.CalendarMultiple24Filled, "M19.9935 5.00676L19.9983 5.12836L20 5.25V16.35C20 18.3658 18.3658 20 16.35 20H5.25C5.16844 20 5.08742 19.9977 5.007 19.9932C5.58285 20.8988 6.59621 21.5 7.75 21.5H16.35C19.1943 21.5 21.5 19.1943 21.5 16.35V7.75C21.5 6.59664 20.8992 5.5836 19.9935 5.00676ZM2 7.5V15.75C2 17.5449 3.45507 19 5.25 19H15.75C17.5449 19 19 17.5449 19 15.75V7.5H2ZM5.25 2C3.45507 2 2 3.45507 2 5.25V6H19V5.25C19 3.45507 17.5449 2 15.75 2H5.25Z " },
            { FluentSymbol.CalendarMultiple24, "M19.9935 5.00676L19.9983 5.12836L20 5.25V16.35C20 18.3658 18.3658 20 16.35 20H5.25C5.16844 20 5.08742 19.9977 5.007 19.9932C5.58285 20.8988 6.59621 21.5 7.75 21.5H16.35C19.1943 21.5 21.5 19.1943 21.5 16.35V7.75C21.5 6.59664 20.8992 5.5836 19.9935 5.00676ZM5.25 2C3.45507 2 2 3.45507 2 5.25V15.75C2 17.5449 3.45507 19 5.25 19H15.75C17.5449 19 19 17.5449 19 15.75V5.25C19 3.45507 17.5449 2 15.75 2H5.25ZM3.5 7.5H17.5V15.75C17.5 16.7165 16.7165 17.5 15.75 17.5H5.25C4.2835 17.5 3.5 16.7165 3.5 15.75V7.5ZM5.25 3.5H15.75C16.7165 3.5 17.5 4.2835 17.5 5.25V6H3.5V5.25C3.5 4.2835 4.2835 3.5 5.25 3.5Z " },
            { FluentSymbol.CalendarMultiple32Filled, "M6.49996 2C4.0147 2 2 4.01473 2 6.50001V7.00002H25.9998V6.50001C25.9998 4.01472 23.9851 2 21.4998 2H6.49996ZM2 21.5001V9.00002H25.9998V21.5001C25.9998 23.9854 23.9851 26.0001 21.4998 26.0001H6.49996C4.0147 26.0001 2 23.9854 2 21.5001ZM28 9.49993C28 9.48647 27.9999 9.47303 27.9997 9.45961V5.75748C29.2059 6.56472 30 7.93958 30 9.49993V22C30 26.4183 26.4183 30 22.0001 30H9.50019C7.94001 30 6.56528 29.206 5.75802 28L22.0001 28C25.3138 28 28 25.3137 28 22V9.49993Z " },
            { FluentSymbol.CalendarMultiple32, "M2 6.50001C2 4.01472 4.01468 2 6.49992 2H21.4997C23.9849 2 25.9996 4.01472 25.9996 6.50001V21.5C25.9996 23.9853 23.9849 26.0001 21.4997 26.0001H6.49992C4.01469 26.0001 2 23.9853 2 21.5V6.50001ZM6.49992 4.00001C5.11924 4.00001 3.99997 5.1193 3.99997 6.50001V7.00001H23.9996V6.50001C23.9996 5.1193 22.8804 4.00001 21.4997 4.00001H6.49992ZM3.99997 21.5C3.99997 22.8808 5.11924 24.0001 6.49992 24.0001H21.4997C22.8804 24.0001 23.9996 22.8808 23.9996 21.5V9.00002H3.99997V21.5ZM28 9.49995C28 9.48347 27.9999 9.46703 27.9996 9.45063V5.75739C29.2058 6.56461 30 7.93953 30 9.49995V22C30 26.4183 26.4183 30 22.0001 30H9.50035C7.9402 30 6.56549 29.206 5.75824 28.0001L22.0001 28C25.3138 28 28 25.3137 28 22V9.49995Z " },
            { FluentSymbol.CalendarOverdue24Filled, "M21 12.0218V8.5H3V17.75C3 19.5449 4.45507 21 6.25 21H12.0218C11.375 19.9897 11 18.7886 11 17.5C11 13.9101 13.9101 11 17.5 11C18.7886 11 19.9897 11.375 21 12.0218Z M21 6.25C21 4.45507 19.5449 3 17.75 3H6.25C4.45507 3 3 4.45507 3 6.25V7H21V6.25Z M23 17.5C23 14.4624 20.5376 12 17.5 12C14.4624 12 12 14.4624 12 17.5C12 20.5376 14.4624 23 17.5 23C20.5376 23 23 20.5376 23 17.5ZM17 14.5C17 14.2239 17.2239 14 17.5 14C17.7761 14 18 14.2239 18 14.5V18.5C18 18.7761 17.7761 19 17.5 19C17.2239 19 17 18.7761 17 18.5V14.5ZM18.125 20.5C18.125 20.8452 17.8452 21.125 17.5 21.125C17.1548 21.125 16.875 20.8452 16.875 20.5C16.875 20.1548 17.1548 19.875 17.5 19.875C17.8452 19.875 18.125 20.1548 18.125 20.5Z " },
            { FluentSymbol.CalendarOverdue24, "M17.75 3C19.5449 3 21 4.45507 21 6.25V12.0218C20.5368 11.7253 20.0335 11.4858 19.5 11.3135V8.5H4.5V17.75C4.5 18.7165 5.2835 19.5 6.25 19.5H11.3135C11.4858 20.0335 11.7253 20.5368 12.0218 21H6.25C4.45507 21 3 19.5449 3 17.75V6.25C3 4.45507 4.45507 3 6.25 3H17.75ZM17.75 4.5H6.25C5.2835 4.5 4.5 5.2835 4.5 6.25V7H19.5V6.25C19.5 5.2835 18.7165 4.5 17.75 4.5Z M23 17.5C23 20.5376 20.5376 23 17.5 23C14.4624 23 12 20.5376 12 17.5C12 14.4624 14.4624 12 17.5 12C20.5376 12 23 14.4624 23 17.5ZM17.5 14C17.2239 14 17 14.2239 17 14.5V18.5C17 18.7761 17.2239 19 17.5 19C17.7761 19 18 18.7761 18 18.5V14.5C18 14.2239 17.7761 14 17.5 14ZM17.5 21.125C17.8452 21.125 18.125 20.8452 18.125 20.5C18.125 20.1548 17.8452 19.875 17.5 19.875C17.1548 19.875 16.875 20.1548 16.875 20.5C16.875 20.8452 17.1548 21.125 17.5 21.125Z " },
            { FluentSymbol.CalendarPerson20Filled, "M17 7V8.76389C16.4692 8.28885 15.7684 8 15 8C13.3431 8 12 9.34315 12 11C12 11.7684 12.2889 12.4692 12.7639 13H12.5C11.1193 13 10 14.1193 10 15.5C10 16.0362 10.0852 16.5389 10.245 17H5.5C4.11929 17 3 15.8807 3 14.5V7H17Z M15 9C16.1046 9 17 9.89543 17 11C17 12.1046 16.1046 13 15 13C13.8954 13 13 12.1046 13 11C13 9.89543 13.8954 9 15 9Z M12.5 14C11.6716 14 11 14.6716 11 15.5C11 16.0584 11.1149 16.5612 11.324 17C11.5329 17.4383 11.8358 17.8127 12.2121 18.1148C12.9534 18.7098 13.9469 19 15 19C16.0531 19 17.0466 18.7098 17.7879 18.1148C18.541 17.5103 19 16.6161 19 15.5C19 14.6716 18.3284 14 17.5 14L12.5 14Z M14.5 3C15.8807 3 17 4.11929 17 5.5V6H3V5.5C3 4.11929 4.11929 3 5.5 3H14.5Z " },
            { FluentSymbol.CalendarPerson20, "M14.5 3C15.8807 3 17 4.11929 17 5.5V8.76389C16.7115 8.50564 16.3726 8.30241 16 8.17071V7H4V14.5C4 15.3284 4.67157 16 5.5 16H10.0254C10.0616 16.351 10.1359 16.6852 10.245 17H5.5C4.11929 17 3 15.8807 3 14.5V5.5C3 4.11929 4.11929 3 5.5 3H14.5ZM14.5 4H5.5C4.67157 4 4 4.67157 4 5.5V6H16V5.5C16 4.67157 15.3284 4 14.5 4Z M16 9.26756C16.5978 9.61337 17 10.2597 17 11C17 11.7403 16.5978 12.3866 16 12.7324C15.7058 12.9026 15.3643 13 15 13C13.8954 13 13 12.1046 13 11C13 9.89543 13.8954 9 15 9C15.3643 9 15.7058 9.09739 16 9.26756Z M11.0321 16C11.0109 15.8388 11 15.672 11 15.5C11 14.6716 11.6716 14 12.5 14L17.5 14C18.3284 14 19 14.6716 19 15.5C19 16.6161 18.541 17.5103 17.7879 18.1148C17.0466 18.7098 16.0531 19 15 19C13.9469 19 12.9534 18.7098 12.2121 18.1148C11.8358 17.8127 11.5329 17.4383 11.324 17C11.1793 16.6964 11.0797 16.3621 11.0321 16Z " },
            { FluentSymbol.CalendarPerson24Filled, "M21 8.5V10.9996C20.3158 10.089 19.2267 9.5 18 9.5C15.9289 9.5 14.25 11.1789 14.25 13.25C14.25 14.3365 14.7121 15.3151 15.4505 16H14.5C13.1193 16 12 17.1193 12 18.5V19C12 19.6993 12.1705 20.3788 12.4875 21H6.25C4.45507 21 3 19.5449 3 17.75V8.5H21Z M17.75 3C19.5449 3 21 4.45507 21 6.25V7H3V6.25C3 4.45507 4.45507 3 6.25 3H17.75Z M23 18.5C23 17.6716 22.3284 17 21.5 17H14.5C13.6716 17 13 17.6716 13 18.5V19C13 20.9714 14.8595 23 18 23C21.1405 23 23 20.9714 23 19V18.5Z M20.75 13.25C20.75 11.7312 19.5188 10.5 18 10.5C16.4812 10.5 15.25 11.7312 15.25 13.25C15.25 14.7688 16.4812 16 18 16C19.5188 16 20.75 14.7688 20.75 13.25Z " },
            { FluentSymbol.CalendarPerson24, "M17.75 3C19.5449 3 21 4.45507 21 6.25V10.9996C20.6133 10.4849 20.0972 10.073 19.5 9.81203V8.5H4.5V17.75C4.5 18.7165 5.2835 19.5 6.25 19.5H12.0292C12.0904 20.0224 12.2467 20.528 12.4875 21H6.25C4.45507 21 3 19.5449 3 17.75V6.25C3 4.45507 4.45507 3 6.25 3H17.75ZM17.75 4.5H6.25C5.2835 4.5 4.5 5.2835 4.5 6.25V7H19.5V6.25C19.5 5.2835 18.7165 4.5 17.75 4.5Z M23 18.5C23 17.6716 22.3284 17 21.5 17H14.5C13.6716 17 13 17.6716 13 18.5V19C13 20.9714 14.8595 23 18 23C21.1405 23 23 20.9714 23 19V18.5Z M20.75 13.25C20.75 11.7312 19.5188 10.5 18 10.5C16.4812 10.5 15.25 11.7312 15.25 13.25C15.25 14.7688 16.4812 16 18 16C19.5188 16 20.75 14.7688 20.75 13.25Z " },
            { FluentSymbol.CalendarQuestionMark16Filled, "M4.5 14H6.25716C5.47182 13.0491 5 11.8296 5 10.5C5 8.63984 5.92345 6.99537 7.33692 6H2V11.5C2 12.8807 3.11929 14 4.5 14Z M14 5H2V4.5C2 3.11929 3.11929 2 4.5 2H11.5C12.8807 2 14 3.11929 14 4.5V5Z M15 10.5C15 12.9853 12.9853 15 10.5 15C8.01472 15 6 12.9853 6 10.5C6 8.01472 8.01472 6 10.5 6C12.9853 6 15 8.01472 15 10.5ZM10.4999 12.3804C10.155 12.3804 9.87542 12.66 9.87542 13.0049C9.87542 13.3498 10.155 13.6294 10.4999 13.6294C10.8448 13.6294 11.1244 13.3498 11.1244 13.0049C11.1244 12.66 10.8448 12.3804 10.4999 12.3804ZM10.5 7.50345C9.45202 7.50345 8.63568 8.32084 8.64659 9.45774C8.64924 9.73387 8.87524 9.95557 9.15137 9.95292C9.4275 9.95026 9.6492 9.72427 9.64655 9.44814C9.64099 8.86913 10.0062 8.50345 10.5 8.50345C10.9723 8.50345 11.3534 8.89534 11.3534 9.45294C11.3534 9.65474 11.2822 9.7679 10.9937 9.9968L10.7157 10.2118C10.2099 10.6161 9.99995 10.9294 9.99993 11.5003C9.99992 11.7764 10.2238 12.0003 10.4999 12.0003C10.7454 12.0003 10.9495 11.8234 10.9919 11.5902L11.0034 11.4341C11.0202 11.2863 11.103 11.1804 11.3487 10.9858L11.6257 10.7715C12.1391 10.3607 12.3534 10.0387 12.3534 9.45294C12.3534 8.34924 11.531 7.50345 10.5 7.50345Z " },
            { FluentSymbol.CalendarQuestionMark16, "M11.5 2C12.8807 2 14 3.11929 14 4.5V6.25716C13.0491 5.47182 11.8296 5 10.5 5H13V4.5C13 3.67157 12.3284 3 11.5 3H4.5C3.67157 3 3 3.67157 3 4.5V5H10.5C9.32259 5 8.23159 5.36997 7.33692 6H3V11.5C3 12.3284 3.67157 13 4.5 13H5.59971C5.78261 13.3578 6.00353 13.6929 6.25716 14H4.5C3.11929 14 2 12.8807 2 11.5V4.5C2 3.11929 3.11929 2 4.5 2H11.5Z M15 10.5C15 12.9853 12.9853 15 10.5 15C8.01472 15 6 12.9853 6 10.5C6 8.01472 8.01472 6 10.5 6C12.9853 6 15 8.01472 15 10.5ZM10.4999 12.3804C10.155 12.3804 9.87542 12.66 9.87542 13.0049C9.87542 13.3498 10.155 13.6294 10.4999 13.6294C10.8448 13.6294 11.1244 13.3498 11.1244 13.0049C11.1244 12.66 10.8448 12.3804 10.4999 12.3804ZM10.5 7.50345C9.45202 7.50345 8.63568 8.32084 8.64659 9.45774C8.64924 9.73387 8.87524 9.95557 9.15137 9.95292C9.4275 9.95026 9.6492 9.72427 9.64655 9.44814C9.64099 8.86913 10.0062 8.50345 10.5 8.50345C10.9723 8.50345 11.3534 8.89534 11.3534 9.45294C11.3534 9.65474 11.2822 9.7679 10.9937 9.9968L10.7157 10.2118C10.2099 10.6161 9.99995 10.9294 9.99993 11.5003C9.99992 11.7764 10.2238 12.0003 10.4999 12.0003C10.7454 12.0003 10.9495 11.8234 10.9919 11.5902L11.0034 11.4341C11.0202 11.2863 11.103 11.1804 11.3487 10.9858L11.6257 10.7715C12.1391 10.3607 12.3534 10.0387 12.3534 9.45294C12.3534 8.34924 11.531 7.50345 10.5 7.50345Z " },
            { FluentSymbol.CalendarQuestionMark20Filled, "M17 5.5C17 4.11929 15.8807 3 14.5 3H5.5C4.11929 3 3 4.11929 3 5.5V6H17V5.5Z M17 9.59971V7H3V14.5C3 15.8807 4.11929 17 5.5 17H9.59971C9.21628 16.2499 9 15.4002 9 14.5C9 11.4624 11.4624 9 14.5 9C15.4002 9 16.2499 9.21628 17 9.59971Z M14.5 19C16.9853 19 19 16.9853 19 14.5C19 12.0147 16.9853 10 14.5 10C12.0147 10 10 12.0147 10 14.5C10 16.9853 12.0147 19 14.5 19ZM13.8754 17.0049C13.8754 16.66 14.155 16.3804 14.4999 16.3804C14.8448 16.3804 15.1244 16.66 15.1244 17.0049C15.1244 17.3498 14.8448 17.6294 14.4999 17.6294C14.155 17.6294 13.8754 17.3498 13.8754 17.0049ZM12.6466 13.4577C12.6357 12.3208 13.452 11.5034 14.5 11.5034C15.531 11.5034 16.3534 12.3492 16.3534 13.4529C16.3534 14.0387 16.1391 14.3607 15.6257 14.7715L15.3487 14.9858C15.103 15.1804 15.0202 15.2863 15.0034 15.4341L14.9919 15.5902C14.9495 15.8234 14.7454 16.0003 14.4999 16.0003C14.2238 16.0003 13.9999 15.7764 13.9999 15.5003C14 14.9294 14.2099 14.6161 14.7157 14.2118L14.9937 13.9968C15.2822 13.7679 15.3534 13.6547 15.3534 13.4529C15.3534 12.8953 14.9723 12.5034 14.5 12.5034C14.0062 12.5034 13.641 12.8691 13.6465 13.4481C13.6492 13.7243 13.4275 13.9503 13.1514 13.9529C12.8752 13.9556 12.6492 13.7339 12.6466 13.4577Z " },
            { FluentSymbol.CalendarQuestionMark20, "M14.5 3C15.8807 3 17 4.11929 17 5.5V9.59971C16.6832 9.43777 16.3486 9.30564 16 9.20703V7H4V14.5C4 15.3284 4.67157 16 5.5 16H9.20703C9.30564 16.3486 9.43777 16.6832 9.59971 17H5.5C4.11929 17 3 15.8807 3 14.5V5.5C3 4.11929 4.11929 3 5.5 3H14.5ZM14.5 4H5.5C4.67157 4 4 4.67157 4 5.5V6H16V5.5C16 4.67157 15.3284 4 14.5 4Z M14.5 19C16.9853 19 19 16.9853 19 14.5C19 12.0147 16.9853 10 14.5 10C12.0147 10 10 12.0147 10 14.5C10 16.9853 12.0147 19 14.5 19ZM13.8754 17.0049C13.8754 16.66 14.155 16.3804 14.4999 16.3804C14.8448 16.3804 15.1244 16.66 15.1244 17.0049C15.1244 17.3498 14.8448 17.6294 14.4999 17.6294C14.155 17.6294 13.8754 17.3498 13.8754 17.0049ZM12.6466 13.4577C12.6357 12.3208 13.452 11.5034 14.5 11.5034C15.531 11.5034 16.3534 12.3492 16.3534 13.4529C16.3534 14.0387 16.1391 14.3607 15.6257 14.7715L15.3487 14.9858C15.103 15.1804 15.0202 15.2863 15.0034 15.4341L14.9919 15.5902C14.9495 15.8234 14.7454 16.0003 14.4999 16.0003C14.2238 16.0003 13.9999 15.7764 13.9999 15.5003C14 14.9294 14.2099 14.6161 14.7157 14.2118L14.9937 13.9968C15.2822 13.7679 15.3534 13.6547 15.3534 13.4529C15.3534 12.8953 14.9723 12.5034 14.5 12.5034C14.0062 12.5034 13.641 12.8691 13.6465 13.4481C13.6492 13.7243 13.4275 13.9503 13.1514 13.9529C12.8752 13.9556 12.6492 13.7339 12.6466 13.4577Z " },
            { FluentSymbol.CalendarQuestionMark24Filled, "M21 6.25C21 4.45507 19.5449 3 17.75 3H6.25C4.45507 3 3 4.45507 3 6.25V7H21V6.25Z M21 12.0218V8.5H3V17.75C3 19.5449 4.45507 21 6.25 21H12.0218C11.375 19.9897 11 18.7886 11 17.5C11 13.9101 13.9101 11 17.5 11C18.7886 11 19.9897 11.375 21 12.0218Z M23 17.5C23 14.4624 20.5376 12 17.5 12C14.4624 12 12 14.4624 12 17.5C12 20.5376 14.4624 23 17.5 23C20.5376 23 23 20.5376 23 17.5ZM16.8755 20.3755C16.8755 20.0306 17.1551 19.751 17.5 19.751C17.8449 19.751 18.1245 20.0306 18.1245 20.3755C18.1245 20.7204 17.8449 21 17.5 21C17.1551 21 16.8755 20.7204 16.8755 20.3755ZM15.6467 15.8284C15.6358 14.6915 16.4521 13.8741 17.5 13.8741C18.5311 13.8741 19.3534 14.7199 19.3534 15.8236C19.3534 16.333 19.2034 16.6653 18.8251 17.1162L18.6905 17.2713L18.4247 17.5617L18.3238 17.6772L18.2389 17.7813C18.0585 18.0126 18 18.1684 18 18.3716C18 18.6477 17.7762 18.8716 17.5 18.8716C17.2239 18.8716 17 18.6477 17 18.3716C17 17.854 17.1513 17.5182 17.5347 17.0615L17.6711 16.9043L17.9365 16.6142L18.0355 16.5009L18.1295 16.3851C18.2981 16.1659 18.3534 16.0158 18.3534 15.8236C18.3534 15.266 17.9724 14.8741 17.5 14.8741C17.0063 14.8741 16.6411 15.2398 16.6466 15.8188C16.6493 16.0949 16.4276 16.3209 16.1514 16.3235C15.8753 16.3262 15.6493 16.1045 15.6467 15.8284Z " },
            { FluentSymbol.CalendarQuestionMark24, "M21 6.25C21 4.45507 19.5449 3 17.75 3H6.25C4.45507 3 3 4.45507 3 6.25V17.75C3 19.5449 4.45507 21 6.25 21H12.0218C11.7253 20.5368 11.4858 20.0335 11.3135 19.5H6.25C5.2835 19.5 4.5 18.7165 4.5 17.75V8.5H19.5V11.3135C20.0335 11.4858 20.5368 11.7253 21 12.0218V6.25ZM6.25 4.5H17.75C18.7165 4.5 19.5 5.2835 19.5 6.25V7H4.5V6.25C4.5 5.2835 5.2835 4.5 6.25 4.5Z M23 17.5C23 14.4624 20.5376 12 17.5 12C14.4624 12 12 14.4624 12 17.5C12 20.5376 14.4624 23 17.5 23C20.5376 23 23 20.5376 23 17.5ZM16.8755 20.3755C16.8755 20.0306 17.1551 19.751 17.5 19.751C17.8449 19.751 18.1245 20.0306 18.1245 20.3755C18.1245 20.7204 17.8449 21 17.5 21C17.1551 21 16.8755 20.7204 16.8755 20.3755ZM15.6467 15.8284C15.6358 14.6915 16.4521 13.8741 17.5 13.8741C18.5311 13.8741 19.3534 14.7199 19.3534 15.8236C19.3534 16.333 19.2034 16.6653 18.8251 17.1162L18.6905 17.2713L18.4247 17.5617L18.3238 17.6772L18.2389 17.7813C18.0585 18.0126 18 18.1684 18 18.3716C18 18.6477 17.7762 18.8716 17.5 18.8716C17.2239 18.8716 17 18.6477 17 18.3716C17 17.854 17.1513 17.5182 17.5347 17.0615L17.6711 16.9043L17.9365 16.6142L18.0355 16.5009L18.1295 16.3851C18.2981 16.1659 18.3534 16.0158 18.3534 15.8236C18.3534 15.266 17.9724 14.8741 17.5 14.8741C17.0063 14.8741 16.6411 15.2398 16.6466 15.8188C16.6493 16.0949 16.4276 16.3209 16.1514 16.3235C15.8753 16.3262 15.6493 16.1045 15.6467 15.8284Z " },
            { FluentSymbol.CalendarReply16Filled, "M14 6V6.25716C13.8911 6.16725 13.7787 6.08145 13.6631 6H14Z M4.5 14H6.25716C5.47182 13.0491 5 11.8296 5 10.5C5 8.63984 5.92345 6.99537 7.33692 6H2V11.5C2 12.8807 3.11929 14 4.5 14Z M14 5H2V4.5C2 3.11929 3.11929 2 4.5 2H11.5C12.8807 2 14 3.11929 14 4.5V5Z M10.5 15C12.9853 15 15 12.9853 15 10.5C15 8.01472 12.9853 6 10.5 6C8.01472 6 6 8.01472 6 10.5C6 12.9853 8.01472 15 10.5 15ZM9.60355 8.60355L8.70711 9.5H10.25C11.7688 9.5 13 10.7312 13 12.25V12.5C13 12.7761 12.7761 13 12.5 13C12.2239 13 12 12.7761 12 12.5V12.25C12 11.2835 11.2165 10.5 10.25 10.5H8.70711L9.60355 11.3964C9.79882 11.5917 9.79882 11.9083 9.60355 12.1036C9.40829 12.2988 9.09171 12.2988 8.89645 12.1036L7.14433 10.3514C7.09744 10.304 7.06198 10.2495 7.03794 10.1914C7.01349 10.1324 7 10.0678 7 10C7 9.93221 7.01349 9.86756 7.03794 9.80861C7.06234 9.74964 7.09851 9.69439 7.14645 9.64645L8.89645 7.89645C9.09171 7.70118 9.40829 7.70118 9.60355 7.89645C9.79882 8.09171 9.79882 8.40829 9.60355 8.60355Z " },
            { FluentSymbol.CalendarReply16, "M11.5 2C12.8807 2 14 3.11929 14 4.5V6.25716C13.0491 5.47182 11.8296 5 10.5 5H13V4.5C13 3.67157 12.3284 3 11.5 3H4.5C3.67157 3 3 3.67157 3 4.5V5H10.5C9.32259 5 8.23159 5.36997 7.33692 6H3V11.5C3 12.3284 3.67157 13 4.5 13H5.59971C5.78261 13.3578 6.00353 13.6929 6.25716 14H4.5C3.11929 14 2 12.8807 2 11.5V4.5C2 3.11929 3.11929 2 4.5 2H11.5Z M10.5 15C12.9853 15 15 12.9853 15 10.5C15 8.01472 12.9853 6 10.5 6C8.01472 6 6 8.01472 6 10.5C6 12.9853 8.01472 15 10.5 15ZM9.60355 8.60355L8.70711 9.5H10.25C11.7688 9.5 13 10.7312 13 12.25V12.5C13 12.7761 12.7761 13 12.5 13C12.2239 13 12 12.7761 12 12.5V12.25C12 11.2835 11.2165 10.5 10.25 10.5H8.70711L9.60355 11.3964C9.79882 11.5917 9.79882 11.9083 9.60355 12.1036C9.40829 12.2988 9.09171 12.2988 8.89645 12.1036L7.14433 10.3514C7.09744 10.304 7.06198 10.2495 7.03794 10.1914C7.01349 10.1324 7 10.0678 7 10C7 9.93221 7.01349 9.86756 7.03794 9.80861C7.06234 9.74964 7.09851 9.69439 7.14645 9.64645L8.89645 7.89645C9.09171 7.70118 9.40829 7.70118 9.60355 7.89645C9.79882 8.09171 9.79882 8.40829 9.60355 8.60355Z " },
            { FluentSymbol.CalendarReply20Filled, "M17 7V9.59971C16.2499 9.21628 15.4002 9 14.5 9C11.4624 9 9 11.4624 9 14.5C9 15.4002 9.21628 16.2499 9.59971 17H5.5C4.11929 17 3 15.8807 3 14.5V7H17Z M14.5 3C15.8807 3 17 4.11929 17 5.5V6H3V5.5C3 4.11929 4.11929 3 5.5 3H14.5Z M14.5 19C16.9853 19 19 16.9853 19 14.5C19 12.0147 16.9853 10 14.5 10C12.0147 10 10 12.0147 10 14.5C10 16.9853 12.0147 19 14.5 19ZM13.6036 12.6036L12.7071 13.5H14.25C15.7688 13.5 17 14.7312 17 16.25V16.5C17 16.7761 16.7761 17 16.5 17C16.2239 17 16 16.7761 16 16.5V16.25C16 15.2835 15.2165 14.5 14.25 14.5H12.7071L13.6036 15.3964C13.7988 15.5917 13.7988 15.9083 13.6036 16.1036C13.4083 16.2988 13.0917 16.2988 12.8964 16.1036L11.1443 14.3514C11.0974 14.304 11.062 14.2495 11.0379 14.1914C11.0135 14.1324 11 14.0678 11 14C11 13.9322 11.0135 13.8676 11.0379 13.8086C11.0623 13.7496 11.0985 13.6944 11.1464 13.6464L12.8964 11.8964C13.0917 11.7012 13.4083 11.7012 13.6036 11.8964C13.7988 12.0917 13.7988 12.4083 13.6036 12.6036Z " },
            { FluentSymbol.CalendarReply20, "M14.5 3C15.8807 3 17 4.11929 17 5.5V9.59971C16.6832 9.43777 16.3486 9.30564 16 9.20703V7H4V14.5C4 15.3284 4.67157 16 5.5 16H9.20703C9.30564 16.3486 9.43777 16.6832 9.59971 17H5.5C4.11929 17 3 15.8807 3 14.5V5.5C3 4.11929 4.11929 3 5.5 3H14.5ZM14.5 4H5.5C4.67157 4 4 4.67157 4 5.5V6H16V5.5C16 4.67157 15.3284 4 14.5 4Z M14.5 19C16.9853 19 19 16.9853 19 14.5C19 12.0147 16.9853 10 14.5 10C12.0147 10 10 12.0147 10 14.5C10 16.9853 12.0147 19 14.5 19ZM13.6036 12.6036L12.7071 13.5H14.25C15.7688 13.5 17 14.7312 17 16.25V16.5C17 16.7761 16.7761 17 16.5 17C16.2239 17 16 16.7761 16 16.5V16.25C16 15.2835 15.2165 14.5 14.25 14.5H12.7071L13.6036 15.3964C13.7988 15.5917 13.7988 15.9083 13.6036 16.1036C13.4083 16.2988 13.0917 16.2988 12.8964 16.1036L11.1443 14.3514C11.0974 14.304 11.062 14.2495 11.0379 14.1914C11.0135 14.1324 11 14.0678 11 14C11 13.9322 11.0135 13.8676 11.0379 13.8086C11.0623 13.7496 11.0985 13.6944 11.1464 13.6464L12.8964 11.8964C13.0917 11.7012 13.4083 11.7012 13.6036 11.8964C13.7988 12.0917 13.7988 12.4083 13.6036 12.6036Z " },
            { FluentSymbol.CalendarReply24Filled, "M21 8.5V12.0218C19.9897 11.375 18.7886 11 17.5 11C13.9101 11 11 13.9101 11 17.5C11 18.7886 11.375 19.9897 12.0218 21H6.25C4.45507 21 3 19.5449 3 17.75V8.5H21Z M17.75 3C19.5449 3 21 4.45507 21 6.25V7H3V6.25C3 4.45507 4.45507 3 6.25 3H17.75Z M23 17.5C23 20.5376 20.5376 23 17.5 23C14.4624 23 12 20.5376 12 17.5C12 14.4624 14.4624 12 17.5 12C20.5376 12 23 14.4624 23 17.5ZM16.3536 15.3536C16.5488 15.1583 16.5488 14.8417 16.3536 14.6464C16.1583 14.4512 15.8417 14.4512 15.6464 14.6464L14.1464 16.1464C13.9512 16.3417 13.9512 16.6583 14.1464 16.8536L15.6464 18.3536C15.8417 18.5488 16.1583 18.5488 16.3536 18.3536C16.5488 18.1583 16.5488 17.8417 16.3536 17.6464L15.7071 17H17.75C18.9926 17 20 18.0074 20 19.25V19.5C20 19.7761 20.2239 20 20.5 20C20.7761 20 21 19.7761 21 19.5V19.25C21 17.4551 19.5449 16 17.75 16H15.7071L16.3536 15.3536Z " },
            { FluentSymbol.CalendarReply24, "M17.75 3C19.5449 3 21 4.45507 21 6.25V12.0218C20.5368 11.7253 20.0335 11.4858 19.5 11.3135V8.5H4.5V17.75C4.5 18.7165 5.2835 19.5 6.25 19.5H11.3135C11.4858 20.0335 11.7253 20.5368 12.0218 21H6.25C4.45507 21 3 19.5449 3 17.75V6.25C3 4.45507 4.45507 3 6.25 3H17.75ZM17.75 4.5H6.25C5.2835 4.5 4.5 5.2835 4.5 6.25V7H19.5V6.25C19.5 5.2835 18.7165 4.5 17.75 4.5Z M23 17.5C23 20.5376 20.5376 23 17.5 23C14.4624 23 12 20.5376 12 17.5C12 14.4624 14.4624 12 17.5 12C20.5376 12 23 14.4624 23 17.5ZM16.3536 15.3536C16.5488 15.1583 16.5488 14.8417 16.3536 14.6464C16.1583 14.4512 15.8417 14.4512 15.6464 14.6464L14.1464 16.1464C13.9512 16.3417 13.9512 16.6583 14.1464 16.8536L15.6464 18.3536C15.8417 18.5488 16.1583 18.5488 16.3536 18.3536C16.5488 18.1583 16.5488 17.8417 16.3536 17.6464L15.7071 17H17.75C18.9926 17 20 18.0074 20 19.25V19.5C20 19.7761 20.2239 20 20.5 20C20.7761 20 21 19.7761 21 19.5V19.25C21 17.4551 19.5449 16 17.75 16H15.7071L16.3536 15.3536Z " },
            { FluentSymbol.CalendarReply28Filled, "M25 9.5V14.4995C23.7465 13.5579 22.1884 13 20.5 13C16.3579 13 13 16.3579 13 20.5C13 22.1884 13.5579 23.7465 14.4995 25H6.25C4.45507 25 3 23.5449 3 21.75V9.5H25Z M21.75 3C23.5449 3 25 4.45507 25 6.25V8H3V6.25C3 4.45507 4.45507 3 6.25 3H21.75Z M27 20.5C27 24.0899 24.0899 27 20.5 27C16.9101 27 14 24.0899 14 20.5C14 16.9101 16.9101 14 20.5 14C24.0899 14 27 16.9101 27 20.5ZM18.8536 17.8536C19.0488 17.6583 19.0488 17.3417 18.8536 17.1464C18.6583 16.9512 18.3417 16.9512 18.1464 17.1464L16.1464 19.1464C15.9512 19.3417 15.9512 19.6583 16.1464 19.8536L18.1464 21.8536C18.3417 22.0488 18.6583 22.0488 18.8536 21.8536C19.0488 21.6583 19.0488 21.3417 18.8536 21.1464L17.7071 20H20.25C21.7688 20 23 21.2312 23 22.75V23C23 23.2761 23.2239 23.5 23.5 23.5C23.7761 23.5 24 23.2761 24 23V22.75C24 20.6789 22.3211 19 20.25 19H17.7071L18.8536 17.8536Z " },
            { FluentSymbol.CalendarReply28, "M21.75 3C23.5449 3 25 4.45507 25 6.25V14.4995C24.5384 14.1527 24.0355 13.858 23.5 13.6241V9.503H4.5V21.75C4.5 22.7165 5.2835 23.5 6.25 23.5H13.6241C13.858 24.0355 14.1527 24.5384 14.4995 25H6.25C4.45507 25 3 23.5449 3 21.75V6.25C3 4.45507 4.45507 3 6.25 3H21.75ZM21.75 4.5H6.25C5.2835 4.5 4.5 5.2835 4.5 6.25V8.003H23.5V6.25C23.5 5.2835 22.7165 4.5 21.75 4.5Z M27 20.5C27 24.0899 24.0899 27 20.5 27C16.9101 27 14 24.0899 14 20.5C14 16.9101 16.9101 14 20.5 14C24.0899 14 27 16.9101 27 20.5ZM18.8536 17.8536C19.0488 17.6583 19.0488 17.3417 18.8536 17.1464C18.6583 16.9512 18.3417 16.9512 18.1464 17.1464L16.1464 19.1464C15.9512 19.3417 15.9512 19.6583 16.1464 19.8536L18.1464 21.8536C18.3417 22.0488 18.6583 22.0488 18.8536 21.8536C19.0488 21.6583 19.0488 21.3417 18.8536 21.1464L17.7071 20H20.25C21.7688 20 23 21.2312 23 22.75V23C23 23.2761 23.2239 23.5 23.5 23.5C23.7761 23.5 24 23.2761 24 23V22.75C24 20.6789 22.3211 19 20.25 19H17.7071L18.8536 17.8536Z " },
            { FluentSymbol.CalendarSettings20Filled, "M17 7V9.59971C16.2499 9.21628 15.4002 9 14.5 9C11.4624 9 9 11.4624 9 14.5C9 15.4002 9.21628 16.2499 9.59971 17H5.5C4.11929 17 3 15.8807 3 14.5V7H17ZM14.5 3C15.8807 3 17 4.11929 17 5.5V6H3V5.5C3 4.11929 4.11929 3 5.5 3H14.5ZM12.0657 11.442C12.369 12.5231 11.723 13.642 10.6351 13.9199L10.174 14.0377C10.159 14.1896 10.1514 14.3438 10.1514 14.4999C10.1514 14.6875 10.1625 14.8725 10.184 15.0541L10.5336 15.1368C11.653 15.4014 12.319 16.5536 11.9897 17.6557L11.8633 18.0785C12.1205 18.2817 12.4002 18.4559 12.698 18.5964L13.023 18.2523C13.8128 17.416 15.1436 17.4167 15.9325 18.2538L16.2698 18.6118C16.5623 18.4769 16.8376 18.3095 17.0917 18.1142L16.9356 17.5575C16.6323 16.4764 17.2783 15.3575 18.3662 15.0795L18.8268 14.9619C18.8417 14.81 18.8494 14.6559 18.8494 14.4999C18.8494 14.3121 18.8383 14.127 18.8167 13.9452L18.4677 13.8627C17.3483 13.598 16.6823 12.4459 17.0116 11.3438L17.1378 10.9215C16.8806 10.7182 16.6008 10.5439 16.303 10.4034L15.9783 10.7472C15.1885 11.5835 13.8577 11.5828 13.0688 10.7457L12.7314 10.3877C12.439 10.5226 12.1636 10.6899 11.9095 10.8852L12.0657 11.442ZM14.5004 15.4999C13.9481 15.4999 13.5004 15.0521 13.5004 14.4999C13.5004 13.9476 13.9481 13.4999 14.5004 13.4999C15.0527 13.4999 15.5004 13.9476 15.5004 14.4999C15.5004 15.0521 15.0527 15.4999 14.5004 15.4999Z " },
            { FluentSymbol.CalendarSettings20, "M14.5 3C15.8807 3 17 4.11929 17 5.5V9.59971C16.6832 9.43777 16.3486 9.30564 16 9.20703V7H4V14.5C4 15.3284 4.67157 16 5.5 16H9.20703C9.30564 16.3486 9.43777 16.6832 9.59971 17H5.5C4.11929 17 3 15.8807 3 14.5V5.5C3 4.11929 4.11929 3 5.5 3H14.5ZM14.5 4H5.5C4.67157 4 4 4.67157 4 5.5V6H16V5.5C16 4.67157 15.3284 4 14.5 4ZM12.0657 11.442C12.369 12.5231 11.723 13.642 10.6351 13.9199L10.174 14.0377C10.159 14.1896 10.1514 14.3438 10.1514 14.4999C10.1514 14.6875 10.1625 14.8725 10.184 15.0541L10.5336 15.1368C11.653 15.4014 12.319 16.5536 11.9897 17.6557L11.8633 18.0785C12.1205 18.2817 12.4002 18.4559 12.698 18.5964L13.023 18.2523C13.8128 17.416 15.1436 17.4167 15.9325 18.2538L16.2698 18.6118C16.5623 18.4769 16.8376 18.3095 17.0917 18.1142L16.9356 17.5575C16.6323 16.4764 17.2783 15.3575 18.3662 15.0795L18.8268 14.9619C18.8417 14.81 18.8494 14.6559 18.8494 14.4999C18.8494 14.3121 18.8383 14.127 18.8167 13.9452L18.4677 13.8627C17.3483 13.598 16.6823 12.4459 17.0116 11.3438L17.1378 10.9215C16.8806 10.7182 16.6008 10.5439 16.303 10.4034L15.9783 10.7472C15.1885 11.5835 13.8577 11.5828 13.0688 10.7457L12.7314 10.3877C12.439 10.5226 12.1636 10.6899 11.9095 10.8852L12.0657 11.442ZM14.5004 15.4999C13.9481 15.4999 13.5004 15.0521 13.5004 14.4999C13.5004 13.9476 13.9481 13.4999 14.5004 13.4999C15.0527 13.4999 15.5004 13.9476 15.5004 14.4999C15.5004 15.0521 15.0527 15.4999 14.5004 15.4999Z " },
            { FluentSymbol.CalendarStar20Filled, "M17 5.5C17 4.11929 15.8807 3 14.5 3H5.5C4.11929 3 3 4.11929 3 5.5V6H17V5.5Z M17 9.59971V7H3V14.5C3 15.8807 4.11929 17 5.5 17H9.59971C9.21628 16.2499 9 15.4002 9 14.5C9 11.4624 11.4624 9 14.5 9C15.4002 9 16.2499 9.21628 17 9.59971Z M19 14.5C19 16.9853 16.9853 19 14.5 19C12.0147 19 10 16.9853 10 14.5C10 12.0147 12.0147 10 14.5 10C16.9853 10 19 12.0147 19 14.5ZM14.976 11.8605C14.8262 11.3798 14.1738 11.3798 14.024 11.8605L13.5465 13.3923H12.0015C11.5166 13.3923 11.315 14.0391 11.7073 14.3362L12.9572 15.2829L12.4798 16.8146C12.33 17.2953 12.8578 17.6951 13.25 17.398L14.5 16.4513L15.75 17.398C16.1422 17.6951 16.67 17.2953 16.5202 16.8146L16.0428 15.2829L17.2927 14.3362C17.685 14.0391 17.4834 13.3923 16.9985 13.3923H15.4535L14.976 11.8605Z " },
            { FluentSymbol.CalendarStar20, "M17 5.5C17 4.11929 15.8807 3 14.5 3H5.5C4.11929 3 3 4.11929 3 5.5V14.5C3 15.8807 4.11929 17 5.5 17H9.59971C9.43777 16.6832 9.30564 16.3486 9.20703 16H5.5C4.67157 16 4 15.3284 4 14.5V7H16V9.20703C16.3486 9.30564 16.6832 9.43777 17 9.59971V5.5ZM5.5 4H14.5C15.3284 4 16 4.67157 16 5.5V6H4V5.5C4 4.67157 4.67157 4 5.5 4Z M19 14.5C19 16.9853 16.9853 19 14.5 19C12.0147 19 10 16.9853 10 14.5C10 12.0147 12.0147 10 14.5 10C16.9853 10 19 12.0147 19 14.5ZM14.976 11.8605C14.8262 11.3798 14.1738 11.3798 14.024 11.8605L13.5465 13.3923H12.0015C11.5166 13.3923 11.315 14.0391 11.7073 14.3362L12.9572 15.2829L12.4798 16.8146C12.33 17.2953 12.8578 17.6951 13.25 17.398L14.5 16.4513L15.75 17.398C16.1422 17.6951 16.67 17.2953 16.5202 16.8146L16.0428 15.2829L17.2927 14.3362C17.685 14.0391 17.4834 13.3923 16.9985 13.3923H15.4535L14.976 11.8605Z " },
            { FluentSymbol.CalendarStar24Filled, "M17.5 12C20.5376 12 23 14.4624 23 17.5C23 20.5376 20.5376 23 17.5 23C14.4624 23 12 20.5376 12 17.5C12 14.4624 14.4624 12 17.5 12ZM21 8.5L21.0012 12.0226C19.9907 11.3753 18.7892 11 17.5 11C13.9101 11 11 13.9101 11 17.5C11 18.7892 11.3753 19.9907 12.0226 21.0012L6.25 21C4.45507 21 3 19.5449 3 17.75V8.5H21ZM16.984 14.0455L16.9446 14.1441L16.3876 15.9311H14.5851C14.0527 15.9311 13.813 16.5995 14.1682 16.9671L14.2418 17.0323L15.7001 18.1368L15.1431 19.9238C14.978 20.4535 15.5181 20.8989 15.9641 20.6548L16.0417 20.6044L17.5 19.5L18.9583 20.6044C19.3905 20.9318 19.9638 20.534 19.8789 20.0163L19.8569 19.9238L19.2999 18.1368L20.7582 17.0323C21.1889 16.7061 21.0059 16.0185 20.5113 15.9387L20.4149 15.9311H18.6124L18.0554 14.1441C17.8915 13.6183 17.2123 13.5854 16.984 14.0455ZM17.75 3C19.5449 3 21 4.45507 21 6.25V7H3V6.25C3 4.45507 4.45507 3 6.25 3H17.75Z " },
            { FluentSymbol.CalendarStar24, "M17.5 12C20.5376 12 23 14.4624 23 17.5C23 20.5376 20.5376 23 17.5 23C14.4624 23 12 20.5376 12 17.5C12 14.4624 14.4624 12 17.5 12ZM17.75 3C19.5449 3 21 4.45507 21 6.25L21.0012 12.0226C20.5378 11.7257 20.0342 11.4861 19.5004 11.3136L19.5 8.5H4.5V17.75C4.5 18.7165 5.2835 19.5 6.25 19.5L11.3136 19.5004C11.4861 20.0342 11.7257 20.5378 12.0226 21.0012L6.25 21C4.45507 21 3 19.5449 3 17.75V6.25C3 4.45507 4.45507 3 6.25 3H17.75ZM16.984 14.0455L16.9446 14.1441L16.3876 15.9311H14.5851C14.0527 15.9311 13.813 16.5995 14.1682 16.9671L14.2418 17.0323L15.7001 18.1368L15.1431 19.9238C14.978 20.4535 15.5181 20.8989 15.9641 20.6548L16.0417 20.6044L17.5 19.5L18.9583 20.6044C19.3905 20.9318 19.9638 20.534 19.8789 20.0163L19.8569 19.9238L19.2999 18.1368L20.7582 17.0323C21.1889 16.7061 21.0059 16.0185 20.5113 15.9387L20.4149 15.9311H18.6124L18.0554 14.1441C17.8915 13.6183 17.2123 13.5854 16.984 14.0455ZM17.75 4.5H6.25C5.2835 4.5 4.5 5.2835 4.5 6.25V7H19.5V6.25C19.5 5.2835 18.7165 4.5 17.75 4.5Z " },
            { FluentSymbol.CalendarSync16Filled, "M6.25716 14H4.5C3.11929 14 2 12.8807 2 11.5V6H7.33692C5.92345 6.99537 5 8.63984 5 10.5C5 11.8296 5.47182 13.0491 6.25716 14Z M14 5V4.5C14 3.11929 12.8807 2 11.5 2H4.5C3.11929 2 2 3.11929 2 4.5V5H14Z M15 10.5C15 12.9853 12.9853 15 10.5 15C8.01472 15 6 12.9853 6 10.5C6 8.01472 8.01472 6 10.5 6C12.9853 6 15 8.01472 15 10.5ZM8.5 7.5C8.22386 7.5 8 7.72386 8 8V9.5C8 9.77614 8.22386 10 8.5 10H10C10.2761 10 10.5 9.77614 10.5 9.5C10.5 9.22386 10.2761 9 10 9H9.53179C9.58213 8.97215 9.63372 8.94644 9.68645 8.92296C9.93176 8.81372 10.1966 8.755 10.465 8.75031C10.7335 8.74561 11.0002 8.79503 11.2492 8.89562C11.4982 8.99621 11.7244 9.1459 11.9143 9.33579C12.1095 9.53105 12.4261 9.53105 12.6214 9.33579C12.8166 9.14052 12.8166 8.82394 12.6214 8.62868C12.3365 8.34386 11.9973 8.11931 11.6238 7.96842C11.2503 7.81754 10.8503 7.74341 10.4476 7.75046C10.0448 7.75751 9.64762 7.84558 9.27966 8.00944C9.18383 8.05211 9.09049 8.0997 9 8.15195V8C9 7.72386 8.77614 7.5 8.5 7.5ZM9.3762 13.0316C9.74967 13.1825 10.1497 13.2566 10.5524 13.2495C10.9552 13.2425 11.3524 13.1544 11.7203 12.9906C11.8162 12.9479 11.9095 12.9003 12 12.8481V13C12 13.2761 12.2239 13.5 12.5 13.5C12.7761 13.5 13 13.2761 13 13V11.5C13 11.2239 12.7761 11 12.5 11H11C10.7239 11 10.5 11.2239 10.5 11.5C10.5 11.7761 10.7239 12 11 12H11.4682C11.4179 12.0278 11.3663 12.0536 11.3135 12.077C11.0682 12.1863 10.8034 12.245 10.535 12.2497C10.2665 12.2544 9.99977 12.205 9.75079 12.1044C9.5018 12.0038 9.27563 11.8541 9.08575 11.6642C8.89049 11.469 8.5739 11.469 8.37864 11.6642C8.18338 11.8595 8.18338 12.1761 8.37864 12.3713C8.66346 12.6561 9.00273 12.8807 9.3762 13.0316Z " },
            { FluentSymbol.CalendarSync16, "M14 4.5C14 3.11929 12.8807 2 11.5 2H4.5C3.11929 2 2 3.11929 2 4.5V11.5C2 12.8807 3.11929 14 4.5 14H6.25716C6.00353 13.6929 5.78261 13.3578 5.59971 13H4.5C3.67157 13 3 12.3284 3 11.5V6H7.33692C8.23159 5.36997 9.32259 5 10.5 5C11.6774 5 12.7684 5.36997 13.6631 6H14V4.5ZM10.5 5H3V4.5C3 3.67157 3.67157 3 4.5 3H11.5C12.3284 3 13 3.67157 13 4.5V5H10.5Z M15 10.5C15 12.9853 12.9853 15 10.5 15C8.01472 15 6 12.9853 6 10.5C6 8.01472 8.01472 6 10.5 6C12.9853 6 15 8.01472 15 10.5ZM8.5 7.5C8.22386 7.5 8 7.72386 8 8V9.5C8 9.77614 8.22386 10 8.5 10H10C10.2761 10 10.5 9.77614 10.5 9.5C10.5 9.22386 10.2761 9 10 9H9.53179C9.58213 8.97215 9.63372 8.94644 9.68645 8.92296C9.93176 8.81372 10.1966 8.755 10.465 8.75031C10.7335 8.74561 11.0002 8.79503 11.2492 8.89562C11.4982 8.99621 11.7244 9.1459 11.9143 9.33579C12.1095 9.53105 12.4261 9.53105 12.6214 9.33579C12.8166 9.14052 12.8166 8.82394 12.6214 8.62868C12.3365 8.34386 11.9973 8.11931 11.6238 7.96842C11.2503 7.81754 10.8503 7.74341 10.4476 7.75046C10.0448 7.75751 9.64762 7.84558 9.27966 8.00944C9.18383 8.05211 9.09049 8.0997 9 8.15195V8C9 7.72386 8.77614 7.5 8.5 7.5ZM9.3762 13.0316C9.74967 13.1825 10.1497 13.2566 10.5524 13.2495C10.9552 13.2425 11.3524 13.1544 11.7203 12.9906C11.8162 12.9479 11.9095 12.9003 12 12.8481V13C12 13.2761 12.2239 13.5 12.5 13.5C12.7761 13.5 13 13.2761 13 13V11.5C13 11.2239 12.7761 11 12.5 11H11C10.7239 11 10.5 11.2239 10.5 11.5C10.5 11.7761 10.7239 12 11 12H11.4682C11.4179 12.0278 11.3663 12.0536 11.3135 12.077C11.0682 12.1863 10.8034 12.245 10.535 12.2497C10.2665 12.2544 9.99977 12.205 9.75079 12.1044C9.5018 12.0038 9.27563 11.8541 9.08575 11.6642C8.89049 11.469 8.5739 11.469 8.37864 11.6642C8.18338 11.8595 8.18338 12.1761 8.37864 12.3713C8.66346 12.6561 9.00273 12.8807 9.3762 13.0316Z " },
            { FluentSymbol.CalendarSync20Filled, "M17 7V9.59971C16.2499 9.21628 15.4002 9 14.5 9C11.4624 9 9 11.4624 9 14.5C9 15.4002 9.21628 16.2499 9.59971 17H5.5C4.11929 17 3 15.8807 3 14.5V7H17Z M14.5 3C15.8807 3 17 4.11929 17 5.5V6H3V5.5C3 4.11929 4.11929 3 5.5 3H14.5Z M19.1539 14.5C19.1539 11.9298 17.0703 9.84616 14.5 9.84616C11.9298 9.84616 9.84616 11.9298 9.84616 14.5C9.84616 17.0703 11.9298 19.1539 14.5 19.1539C17.0703 19.1539 19.1539 17.0703 19.1539 14.5ZM12.5 11.2504C12.7761 11.2504 13 11.4742 13 11.7504V11.923L13.0011 11.9223C13.4035 11.6472 13.8777 11.504 14.4365 11.504C15.4296 11.504 16.332 11.9447 16.8915 12.7208C17.0529 12.9448 17.0023 13.2573 16.7783 13.4188C16.5543 13.5802 16.2418 13.5296 16.0803 13.3056C15.7211 12.8073 15.1298 12.504 14.4365 12.504C14.0595 12.504 13.7861 12.597 13.5655 12.7478C13.4663 12.8156 13.3719 12.8991 13.2806 13H14.2465C14.5227 13 14.7465 13.2239 14.7465 13.5C14.7465 13.7761 14.5227 14 14.2465 14H12.5C12.3674 14 12.2402 13.9473 12.1464 13.8536C12.0527 13.7598 12 13.6326 12 13.5V11.7504C12 11.4742 12.2239 11.2504 12.5 11.2504ZM16.0031 16.9382C15.5813 17.2707 15.0616 17.4951 14.4365 17.4951C13.5274 17.4951 12.6885 17.1331 12.1213 16.4586C11.9435 16.2473 11.9708 15.9319 12.1821 15.7541C12.3935 15.5764 12.7089 15.6036 12.8866 15.815C13.2469 16.2434 13.7953 16.4951 14.4365 16.4951C14.8651 16.4951 15.2403 16.311 15.5589 16H14.7485C14.4723 16 14.2485 15.7761 14.2485 15.5C14.2485 15.2239 14.4723 15 14.7485 15H16.5031C16.7792 15 17.0031 15.2239 17.0031 15.5L17.0031 17.2525C17.0031 17.5286 16.7792 17.7525 16.5031 17.7525C16.227 17.7525 16.0031 17.5286 16.0031 17.2525L16.0031 16.9382Z " },
            { FluentSymbol.CalendarSync20, "M14.5 3C15.8807 3 17 4.11929 17 5.5V9.59971C16.6832 9.43777 16.3486 9.30564 16 9.20703V7H4V14.5C4 15.3284 4.67157 16 5.5 16H9.20703C9.30564 16.3486 9.43777 16.6832 9.59971 17H5.5C4.11929 17 3 15.8807 3 14.5V5.5C3 4.11929 4.11929 3 5.5 3H14.5ZM14.5 4H5.5C4.67157 4 4 4.67157 4 5.5V6H16V5.5C16 4.67157 15.3284 4 14.5 4Z M19.1539 14.5C19.1539 11.9298 17.0703 9.84616 14.5 9.84616C11.9298 9.84616 9.84616 11.9298 9.84616 14.5C9.84616 17.0703 11.9298 19.1539 14.5 19.1539C17.0703 19.1539 19.1539 17.0703 19.1539 14.5ZM12.5 11.2504C12.7761 11.2504 13 11.4742 13 11.7504V11.923L13.0011 11.9223C13.4035 11.6472 13.8777 11.504 14.4365 11.504C15.4296 11.504 16.332 11.9447 16.8915 12.7208C17.0529 12.9448 17.0023 13.2573 16.7783 13.4188C16.5543 13.5802 16.2418 13.5296 16.0803 13.3056C15.7211 12.8073 15.1298 12.504 14.4365 12.504C14.0595 12.504 13.7861 12.597 13.5655 12.7478C13.4663 12.8156 13.3719 12.8991 13.2806 13H14.2465C14.5227 13 14.7465 13.2239 14.7465 13.5C14.7465 13.7761 14.5227 14 14.2465 14H12.5C12.3674 14 12.2402 13.9473 12.1464 13.8536C12.0527 13.7598 12 13.6326 12 13.5V11.7504C12 11.4742 12.2239 11.2504 12.5 11.2504ZM16.0031 16.9382C15.5813 17.2707 15.0616 17.4951 14.4365 17.4951C13.5274 17.4951 12.6885 17.1331 12.1213 16.4586C11.9435 16.2473 11.9708 15.9319 12.1821 15.7541C12.3935 15.5764 12.7089 15.6036 12.8866 15.815C13.2469 16.2434 13.7953 16.4951 14.4365 16.4951C14.8651 16.4951 15.2403 16.311 15.5589 16H14.7485C14.4723 16 14.2485 15.7761 14.2485 15.5C14.2485 15.2239 14.4723 15 14.7485 15H16.5031C16.7792 15 17.0031 15.2239 17.0031 15.5L17.0031 17.2525C17.0031 17.5286 16.7792 17.7525 16.5031 17.7525C16.227 17.7525 16.0031 17.5286 16.0031 17.2525L16.0031 16.9382Z " },
            { FluentSymbol.CalendarSync24Filled, "M21 8.5V12.0218C19.9897 11.375 18.7886 11 17.5 11C13.9101 11 11 13.9101 11 17.5C11 18.7886 11.375 19.9897 12.0218 21H6.25C4.45507 21 3 19.5449 3 17.75V8.5H21Z M17.75 3C19.5449 3 21 4.45507 21 6.25V7H3V6.25C3 4.45507 4.45507 3 6.25 3H17.75Z M23 17.5C23 14.4624 20.5376 12 17.5 12C14.4624 12 12 14.4624 12 17.5C12 20.5376 14.4624 23 17.5 23C20.5376 23 23 20.5376 23 17.5ZM14.5 14C14.7761 14 15 14.2239 15 14.5V15.0506C15.6349 14.4027 16.5203 14 17.5 14C18.6677 14 19.7018 14.5724 20.3368 15.4496C20.4987 15.6733 20.4487 15.9859 20.225 16.1478C20.0013 16.3098 19.6887 16.2597 19.5268 16.036C19.0717 15.4073 18.3334 15 17.5 15C16.6826 15 15.9564 15.392 15.4997 16H16.5C16.7761 16 17 16.2239 17 16.5C17 16.7761 16.7761 17 16.5 17H14.5C14.2239 17 14 16.7761 14 16.5V14.5C14 14.2239 14.2239 14 14.5 14ZM20 19.9494C19.3651 20.5973 18.4797 21 17.5 21C16.4268 21 15.4661 20.5164 14.8248 19.7569C14.6467 19.546 14.6733 19.2305 14.8843 19.0523C15.0952 18.8742 15.4107 18.9008 15.5889 19.1118C16.0482 19.6558 16.7337 20 17.5 20C18.3174 20 19.0436 19.608 19.5002 19H18.5C18.2239 19 18 18.7761 18 18.5C18 18.2239 18.2239 18 18.5 18H20.5C20.7761 18 21 18.2239 21 18.5V20.5C21 20.7761 20.7761 21 20.5 21C20.2239 21 20 20.7761 20 20.5V19.9494Z " },
            { FluentSymbol.CalendarSync24, "M17.75 3C19.5449 3 21 4.45507 21 6.25V12.0218C20.5368 11.7253 20.0335 11.4858 19.5 11.3135V8.5H4.5V17.75C4.5 18.7165 5.2835 19.5 6.25 19.5H11.3135C11.4858 20.0335 11.7253 20.5368 12.0218 21H6.25C4.45507 21 3 19.5449 3 17.75V6.25C3 4.45507 4.45507 3 6.25 3H17.75ZM17.75 4.5H6.25C5.2835 4.5 4.5 5.2835 4.5 6.25V7H19.5V6.25C19.5 5.2835 18.7165 4.5 17.75 4.5Z M23 17.5C23 14.4624 20.5376 12 17.5 12C14.4624 12 12 14.4624 12 17.5C12 20.5376 14.4624 23 17.5 23C20.5376 23 23 20.5376 23 17.5ZM14.5 14C14.7761 14 15 14.2239 15 14.5V15.0506C15.6349 14.4027 16.5203 14 17.5 14C18.6677 14 19.7018 14.5724 20.3368 15.4496C20.4987 15.6733 20.4487 15.9859 20.225 16.1478C20.0013 16.3098 19.6887 16.2597 19.5268 16.036C19.0717 15.4073 18.3334 15 17.5 15C16.6826 15 15.9564 15.392 15.4997 16H16.5C16.7761 16 17 16.2239 17 16.5C17 16.7761 16.7761 17 16.5 17H14.5C14.2239 17 14 16.7761 14 16.5V14.5C14 14.2239 14.2239 14 14.5 14ZM20 19.9494C19.3651 20.5973 18.4797 21 17.5 21C16.4268 21 15.4661 20.5164 14.8248 19.7569C14.6467 19.546 14.6733 19.2305 14.8843 19.0523C15.0952 18.8742 15.4107 18.9008 15.5889 19.1118C16.0482 19.6558 16.7337 20 17.5 20C18.3174 20 19.0436 19.608 19.5002 19H18.5C18.2239 19 18 18.7761 18 18.5C18 18.2239 18.2239 18 18.5 18H20.5C20.7761 18 21 18.2239 21 18.5V20.5C21 20.7761 20.7761 21 20.5 21C20.2239 21 20 20.7761 20 20.5V19.9494Z " },
            { FluentSymbol.CalendarToday16Filled, "M14 11.5V6H8H2V11.5C2 12.8807 3.11929 14 4.5 14H6.5C6.5 14 6.49999 13.6753 6.49999 13.5V12.75C6.07046 12.7498 5.64412 12.5661 5.34764 12.2103C4.8173 11.5739 4.90328 10.628 5.5397 10.0977L6.81338 9.03626C6.46696 8.71652 6.25 8.2586 6.25 7.75C6.25 6.7835 7.0335 6 8 6C8.9665 6 9.75 6.7835 9.75 7.75C9.75 8.25861 9.53303 8.71654 9.18659 9.03628L10.4603 10.0977C11.0967 10.628 11.1827 11.5739 10.6523 12.2103C10.3558 12.566 9.92951 12.7498 9.49999 12.75V13.5C9.49999 13.6753 9.49999 14 9.49999 14H11.5C12.8807 14 14 12.8807 14 11.5Z M7.95778 9.50178C7.972 9.50058 7.98626 9.49998 8.00051 9.5C8.01918 9.50002 8.03784 9.50108 8.05641 9.50318C8.15079 9.51386 8.24275 9.55143 8.3201 9.61589L9.8201 10.8659C10.0322 11.0427 10.0609 11.358 9.88412 11.5701C9.80621 11.6636 9.70139 11.7214 9.59036 11.7418C9.56055 11.7472 9.53029 11.75 9.49999 11.75C9.46447 11.75 9.42889 11.7463 9.39389 11.7387C9.33149 11.7252 9.27093 11.6996 9.21587 11.6615C9.20359 11.653 9.19158 11.6439 9.17988 11.6341L8.50001 11.0675V14.5C8.50001 14.7406 8.33008 14.9415 8.10369 14.9892C8.07135 14.9961 8.03786 14.9998 8.00355 15L8.00001 15L7.99645 15 M7.95778 9.50178C7.91514 9.50538 7.87286 9.51444 7.83206 9.52897L7.95778 9.50178Z M14 4.5C14 3.11929 12.8807 2 11.5 2H4.5C3.11929 2 2 3.11929 2 4.5V5H14V4.5Z M8 8.5C8.41421 8.5 8.75 8.16421 8.75 7.75C8.75 7.33579 8.41421 7 8 7C7.58579 7 7.25 7.33579 7.25 7.75C7.25 8.16421 7.58579 8.5 8 8.5Z M8.00051 9.5C7.98626 9.49998 7.972 9.50058 7.95778 9.50178L7.83206 9.52897C7.77784 9.54829 7.72624 9.57726 7.67988 9.61589L6.17989 10.8659C5.96775 11.0427 5.93908 11.358 6.11587 11.5701C6.17763 11.6442 6.25631 11.6959 6.34159 11.7243C6.36077 11.7307 6.38029 11.7359 6.40002 11.7399C6.43293 11.7466 6.46643 11.75 6.49999 11.75C6.53528 11.75 6.57064 11.7463 6.60543 11.7389C6.68198 11.7224 6.75579 11.6877 6.8201 11.6341L7.49999 11.0675L7.49999 14.5C7.49999 14.6726 7.58743 14.8248 7.72043 14.9146C7.75362 14.937 7.78965 14.9556 7.82787 14.9696C7.88048 14.9889 7.93725 14.9996 7.99645 15L8.00001 15L8.00355 15C8.03786 14.9998 8.07135 14.9961 8.10369 14.9892C8.33008 14.9415 8.50001 14.7406 8.50001 14.5V11.0675L9.17988 11.6341C9.19158 11.6439 9.20359 11.653 9.21587 11.6615C9.27093 11.6996 9.33149 11.7252 9.39389 11.7387C9.42889 11.7463 9.46447 11.75 9.49999 11.75C9.53029 11.75 9.56055 11.7472 9.59036 11.7418C9.70139 11.7214 9.80621 11.6636 9.88412 11.5701C10.0609 11.358 10.0322 11.0427 9.8201 10.8659L8.3201 9.61589C8.24275 9.55143 8.15079 9.51386 8.05641 9.50318C8.03784 9.50108 8.01918 9.50002 8.00051 9.5Z " },
            { FluentSymbol.CalendarToday16, "M14 4.5C14 3.11929 12.8807 2 11.5 2H4.5C3.11929 2 2 3.11929 2 4.5V11.5C2 12.8807 3.11929 14 4.5 14H6.49999C6.49999 14 6.49999 13.6753 6.49999 13.5V13H4.5C3.67157 13 3 12.3284 3 11.5V6H13V11.5C13 12.3284 12.3284 13 11.5 13H9.49999V13.5C9.49999 13.6753 9.49999 14 9.49999 14H11.5C12.8807 14 14 12.8807 14 11.5V4.5ZM4.5 3H11.5C12.3284 3 13 3.67157 13 4.5V5H3V4.5C3 3.67157 3.67157 3 4.5 3Z M8.28126 14.9135C8.4133 14.8235 8.49999 14.6719 8.49999 14.5L8.5 11.0675L9.1799 11.6341C9.39203 11.8109 9.70732 11.7822 9.8841 11.5701C10.0609 11.3579 10.0322 11.0427 9.82008 10.8659L8.32008 9.61588C8.13466 9.46136 7.86532 9.46136 7.6799 9.61588L6.1799 10.8659C5.96776 11.0427 5.93909 11.3579 6.11588 11.5701C6.29266 11.7822 6.60794 11.8109 6.82008 11.6341L7.5 11.0675L7.49999 14.5C7.49999 14.6726 7.58743 14.8248 7.72043 14.9146C7.79932 14.9679 7.89423 14.9993 7.99643 15H8.00355C8.10649 14.9993 8.20203 14.9675 8.28126 14.9135Z M8.75 7.75C8.75 8.16421 8.41421 8.5 8 8.5C7.58579 8.5 7.25 8.16421 7.25 7.75C7.25 7.33579 7.58579 7 8 7C8.41421 7 8.75 7.33579 8.75 7.75Z " },
            { FluentSymbol.CalendarToday20Filled, "M10 10C10.5523 10 11 9.55228 11 9C11 8.44772 10.5523 8 10 8C9.44772 8 9 8.44772 9 9C9 9.55228 9.44772 10 10 10Z M17 14.5V7H10H3V14.5C3 15.8807 4.11929 17 5.5 17H8.5C8.5 17 8.5 16.6753 8.5 16.5V15.25C8.07751 15.2498 7.65763 15.0721 7.36111 14.7262C6.82198 14.0972 6.89482 13.1502 7.52381 12.6111L7.53436 12.6021L9.03047 11.3554C9.31017 11.1185 9.65508 11 10 11C10.3449 11 10.6898 11.1185 10.9695 11.3554L12.4762 12.6111C13.1052 13.1502 13.178 14.0972 12.6389 14.7262C12.3424 15.0721 11.9225 15.2498 11.5 15.25V16.5C11.5 16.6753 11.5 17 11.5 17H14.5C15.8807 17 17 15.8807 17 14.5ZM12 9C12 10.1046 11.1046 11 10 11C8.89543 11 8 10.1046 8 9C8 7.89543 8.89543 7 10 7C11.1046 7 12 7.89543 12 9Z M17 5.5C17 4.11929 15.8807 3 14.5 3H5.5C4.11929 3 3 4.11929 3 5.5V6H17V5.5Z M11.1799 14.1341C11.392 14.3109 11.7073 14.2822 11.8841 14.0701C12.0609 13.858 12.0322 13.5427 11.8201 13.3659L10.3201 12.1159C10.1347 11.9614 9.86531 11.9614 9.67989 12.1159L8.17989 13.3659C7.96775 13.5427 7.93909 13.858 8.11587 14.0701C8.29265 14.2822 8.60794 14.3109 8.82007 14.1341L9.49999 13.5675V17.5C9.49999 17.7762 9.72385 18 9.99999 18C10.2761 18 10.5 17.7762 10.5 17.5L10.5 13.5675L11.1799 14.1341Z " },
            { FluentSymbol.CalendarToday20, "M14.5 3C15.8807 3 17 4.11929 17 5.5V14.5C17 15.8807 15.8807 17 14.5 17H11.5C11.5 17 11.5 16.6753 11.5 16.5V16H14.5C15.3284 16 16 15.3284 16 14.5V7H4V14.5C4 15.3284 4.67157 16 5.5 16H8.5V16.5C8.5 16.6753 8.5 17 8.5 17H5.5C4.11929 17 3 15.8807 3 14.5V5.5C3 4.11929 4.11929 3 5.5 3H14.5ZM14.5 4H5.5C4.67157 4 4 4.67157 4 5.5V6H16V5.5C16 4.67157 15.3284 4 14.5 4Z M11 9C11 9.55228 10.5523 10 10 10C9.44772 10 9 9.55228 9 9C9 8.44772 9.44772 8 10 8C10.5523 8 11 8.44772 11 9Z M11.8841 14.0701C11.7073 14.2822 11.392 14.3109 11.1799 14.1341L10.5 13.5675L10.5 17.5C10.5 17.7762 10.2761 18 9.99999 18C9.72385 18 9.49999 17.7762 9.49999 17.5V13.5675L8.82007 14.1341C8.60794 14.3109 8.29265 14.2822 8.11587 14.0701C7.93909 13.858 7.96775 13.5427 8.17989 13.3659L9.67989 12.1159C9.86531 11.9614 10.1347 11.9614 10.3201 12.1159L11.8201 13.3659C12.0322 13.5427 12.0609 13.858 11.8841 14.0701Z " },
            { FluentSymbol.CalendarToday24Filled, "M13.25 11.75C13.25 12.4404 12.6904 13 12 13C11.3096 13 10.75 12.4404 10.75 11.75C10.75 11.0596 11.3096 10.5 12 10.5C12.6904 10.5 13.25 11.0596 13.25 11.75Z M21 8.5V17.75C21 19.5449 19.5449 21 17.75 21H13.75C13.75 21 13.75 20.5184 13.75 20.25V19.4275C14.3809 19.6151 15.0918 19.4371 15.558 18.9126C16.2001 18.1903 16.135 17.0841 15.4127 16.442L13.1627 14.442C12.4996 13.8527 11.5004 13.8527 10.8374 14.442L8.58738 16.442C7.86501 17.0841 7.79995 18.1903 8.44205 18.9126C8.90825 19.4371 9.61904 19.6151 10.25 19.4275V20.25C10.25 20.5184 10.25 21 10.25 21H6.25C4.45507 21 3 19.5449 3 17.75V8.5H21ZM12 14C13.2426 14 14.25 12.9926 14.25 11.75C14.25 10.5074 13.2426 9.5 12 9.5C10.7574 9.5 9.75 10.5074 9.75 11.75C9.75 12.9926 10.7574 14 12 14Z M17.75 3C19.5449 3 21 4.45507 21 6.25V7H3V6.25C3 4.45507 4.45507 3 6.25 3H17.75Z M14.8105 18.2483C14.5353 18.5579 14.0613 18.5857 13.7517 18.3106L12.75 17.4201V21.25C12.75 21.6642 12.4142 22 12 22C11.5857 22 11.25 21.6642 11.25 21.25V17.4201L10.2482 18.3106C9.93863 18.5857 9.46458 18.5579 9.18939 18.2483C8.9142 17.9387 8.94209 17.4646 9.25167 17.1894L11.5017 15.1894C11.7858 14.9369 12.2141 14.9369 12.4982 15.1894L14.7482 17.1894C15.0578 17.4646 15.0857 17.9387 14.8105 18.2483Z " },
            { FluentSymbol.CalendarToday24, "M21 6.25C21 4.45507 19.5449 3 17.75 3H6.25C4.45507 3 3 4.45507 3 6.25V17.75C3 19.5449 4.45507 21 6.25 21H10.25C10.25 21 10.25 20.5184 10.25 20.25V19.5H6.25C5.2835 19.5 4.5 18.7165 4.5 17.75V8.5H19.5V17.75C19.5 18.7165 18.7165 19.5 17.75 19.5H13.75V20.25C13.75 20.5184 13.75 21 13.75 21H17.75C19.5449 21 21 19.5449 21 17.75V6.25ZM6.25 4.5H17.75C18.7165 4.5 19.5 5.2835 19.5 6.25V7H4.5V6.25C4.5 5.2835 5.2835 4.5 6.25 4.5Z M13.25 11.75C13.25 12.4404 12.6904 13 12 13C11.3096 13 10.75 12.4404 10.75 11.75C10.75 11.0596 11.3096 10.5 12 10.5C12.6904 10.5 13.25 11.0596 13.25 11.75Z M13.7517 18.3106C14.0613 18.5857 14.5353 18.5579 14.8105 18.2483C15.0857 17.9387 15.0578 17.4646 14.7482 17.1894L12.4982 15.1894C12.2141 14.9369 11.7858 14.9369 11.5017 15.1894L9.25167 17.1894C8.94209 17.4646 8.9142 17.9387 9.18939 18.2483C9.46458 18.5579 9.93863 18.5857 10.2482 18.3106L11.25 17.4201V21.25C11.25 21.6642 11.5857 22 12 22C12.4142 22 12.75 21.6642 12.75 21.25V17.4201L13.7517 18.3106Z " },
            { FluentSymbol.CalendarToday28Filled, "M14 14.5C14.6904 14.5 15.25 13.9404 15.25 13.25C15.25 12.5596 14.6904 12 14 12C13.3096 12 12.75 12.5596 12.75 13.25C12.75 13.9404 13.3096 14.5 14 14.5Z M25 21.75V9.5H3V21.75C3 23.5449 4.45507 25 6.25 25H12.25C12.25 25 12.25 24.5184 12.25 24.25V21.4275C11.6191 21.6151 10.9083 21.4371 10.4421 20.9126C9.79995 20.1903 9.86501 19.0841 10.5874 18.442L12.8374 16.442C13.5004 15.8527 14.4996 15.8527 15.1627 16.442L17.4127 18.442C18.135 19.0841 18.2001 20.1903 17.558 20.9126C17.0918 21.4371 16.381 21.6151 15.75 21.4275V24.25C15.75 24.5184 15.75 25 15.75 25H21.75C23.5449 25 25 23.5449 25 21.75ZM16.25 13.25C16.25 14.4926 15.2426 15.5 14 15.5C12.7574 15.5 11.75 14.4926 11.75 13.25C11.75 12.0074 12.7574 11 14 11C15.2426 11 16.25 12.0074 16.25 13.25Z M25 6.25C25 4.45507 23.5449 3 21.75 3H6.25C4.45507 3 3 4.45507 3 6.25V8H25V6.25Z M15.7517 20.3106C16.0613 20.5857 16.5354 20.5579 16.8106 20.2483C17.0858 19.9387 17.0579 19.4646 16.7483 19.1894L14.4983 17.1894C14.2141 16.9369 13.7859 16.9369 13.5017 17.1894L11.2517 19.1894C10.9421 19.4646 10.9143 19.9387 11.1895 20.2483C11.4646 20.5579 11.9387 20.5857 12.2483 20.3106L13.25 19.4201V25.25C13.25 25.6642 13.5858 26 14 26C14.4142 26 14.75 25.6642 14.75 25.25V19.4201L15.7517 20.3106Z " },
            { FluentSymbol.CalendarToday28, "M25 6.25C25 4.45507 23.5449 3 21.75 3H6.25C4.45507 3 3 4.45507 3 6.25V21.75C3 23.5449 4.45507 25 6.25 25H12.2483C12.2483 25 12.25 24.5184 12.25 24.25V23.5H6.25C5.2835 23.5 4.5 22.7165 4.5 21.75V9.503H23.5V21.75C23.5 22.7165 22.7165 23.5 21.75 23.5H15.75V24.25C15.75 24.5184 15.75 25 15.75 25H21.75C23.5449 25 25 23.5449 25 21.75V6.25ZM6.25 4.5H21.75C22.7165 4.5 23.5 5.2835 23.5 6.25V8.003H4.5V6.25C4.5 5.2835 5.2835 4.5 6.25 4.5Z M15.25 13.25C15.25 13.9404 14.6904 14.5 14 14.5C13.3096 14.5 12.75 13.9404 12.75 13.25C12.75 12.5596 13.3096 12 14 12C14.6904 12 15.25 12.5596 15.25 13.25Z M15.7517 20.3105C16.0613 20.5857 16.5354 20.5579 16.8105 20.2483C17.0857 19.9387 17.0579 19.4646 16.7483 19.1894L14.4983 17.1894C14.2141 16.9368 13.7859 16.9368 13.5017 17.1894L11.2517 19.1894C10.9421 19.4646 10.9142 19.9387 11.1894 20.2483C11.4646 20.5579 11.9387 20.5857 12.2483 20.3105L13.25 19.4201V25.25C13.25 25.6642 13.5858 26 14 26C14.4142 26 14.75 25.6642 14.75 25.25V19.4201L15.7517 20.3105Z " },
            { FluentSymbol.CalendarWeekNumbers24Filled, "M17.75 3C19.5449 3 21 4.45507 21 6.25V17.75C21 19.5449 19.5449 21 17.75 21H6.25C4.45507 21 3 19.5449 3 17.75V6.25C3 4.45507 4.45507 3 6.25 3H17.75ZM8.49315 7.64823C8.44349 7.28215 8.1297 7 7.75 7C7.33579 7 7 7.33579 7 7.75V8.75L7.00685 8.85177C7.05651 9.21785 7.3703 9.5 7.75 9.5C8.16421 9.5 8.5 9.16421 8.5 8.75V7.75L8.49315 7.64823ZM8.49315 15.1482C8.44349 14.7822 8.1297 14.5 7.75 14.5C7.33579 14.5 7 14.8358 7 15.25V16.25L7.00685 16.3518C7.05651 16.7178 7.3703 17 7.75 17C8.16421 17 8.5 16.6642 8.5 16.25V15.25L8.49315 15.1482ZM7.75685 10.6729C7.34263 10.6729 7.00685 11.0087 7.00685 11.4229L7 12.5712L7.00685 12.6729C7.05651 13.039 7.3703 13.3212 7.75 13.3212C8.16421 13.3212 8.5 12.9854 8.5 12.5712L8.50685 11.4229L8.5 11.3212C8.45034 10.9551 8.13654 10.6729 7.75685 10.6729Z " },
            { FluentSymbol.CalendarWeekNumbers24, "M17.75 3C19.5449 3 21 4.45507 21 6.25V17.75C21 19.5449 19.5449 21 17.75 21H6.25C4.45507 21 3 19.5449 3 17.75V6.25C3 4.45507 4.45507 3 6.25 3H17.75ZM17.75 4.5H6.25C5.2835 4.5 4.5 5.2835 4.5 6.25V17.75C4.5 18.7165 5.2835 19.5 6.25 19.5H17.75C18.7165 19.5 19.5 18.7165 19.5 17.75V6.25C19.5 5.2835 18.7165 4.5 17.75 4.5ZM7.75 7C8.1297 7 8.44349 7.28215 8.49315 7.64823L8.5 7.75V8.75C8.5 9.16421 8.16421 9.5 7.75 9.5C7.3703 9.5 7.05651 9.21785 7.00685 8.85177L7 8.75V7.75C7 7.33579 7.33579 7 7.75 7Z M8.49315 15.1482C8.44349 14.7822 8.1297 14.5 7.75 14.5C7.33579 14.5 7 14.8358 7 15.25V16.25L7.00685 16.3518C7.05651 16.7178 7.3703 17 7.75 17C8.16421 17 8.5 16.6642 8.5 16.25V15.25L8.49315 15.1482Z M8.5 11.3212C8.45034 10.9551 8.13654 10.6729 7.75685 10.6729C7.34263 10.6729 7.00685 11.0087 7.00685 11.4229L7 12.5712L7.00685 12.6729C7.05651 13.039 7.3703 13.3212 7.75 13.3212C8.16421 13.3212 8.5 12.9854 8.5 12.5712L8.50685 11.4229L8.5 11.3212Z " },
            { FluentSymbol.CalendarWeekStart20Filled, "M14.5 3C15.8807 3 17 4.11929 17 5.5V14.5C17 15.8807 15.8807 17 14.5 17H5.5C4.11929 17 3 15.8807 3 14.5V5.5C3 4.11929 4.11929 3 5.5 3H14.5ZM6.5 6C6.25454 6 6.05039 6.17688 6.00806 6.41012L6 6.5V13.5L6.00806 13.5899C6.05039 13.8231 6.25454 14 6.5 14C6.74546 14 6.94961 13.8231 6.99194 13.5899L7 13.5V6.5L6.99194 6.41012C6.94961 6.17688 6.74546 6 6.5 6Z " },
            { FluentSymbol.CalendarWeekStart20, "M14.5 3C15.8807 3 17 4.11929 17 5.5V14.5C17 15.8807 15.8807 17 14.5 17H5.5C4.11929 17 3 15.8807 3 14.5V5.5C3 4.11929 4.11929 3 5.5 3H14.5ZM14.5 4H5.5C4.67157 4 4 4.67157 4 5.5V14.5C4 15.3284 4.67157 16 5.5 16H14.5C15.3284 16 16 15.3284 16 14.5V5.5C16 4.67157 15.3284 4 14.5 4ZM6.5 6C6.74546 6 6.94961 6.17688 6.99194 6.41012L7 6.5V13.5C7 13.7761 6.77614 14 6.5 14C6.25454 14 6.05039 13.8231 6.00806 13.5899L6 13.5V6.5C6 6.22386 6.22386 6 6.5 6Z " },
            { FluentSymbol.CalendarWeekStart24Filled, "M17.75 3C19.5449 3 21 4.45507 21 6.25V17.75C21 19.5449 19.5449 21 17.75 21H6.25C4.45507 21 3 19.5449 3 17.75V6.25C3 4.45507 4.45507 3 6.25 3H17.75ZM7.75 7C7.33579 7 7 7.33579 7 7.75V16.25C7 16.6642 7.33579 17 7.75 17C8.16421 17 8.5 16.6642 8.5 16.25V7.75C8.5 7.33579 8.16421 7 7.75 7Z " },
            { FluentSymbol.CalendarWeekStart24, "M17.75 3C19.5449 3 21 4.45507 21 6.25V17.75C21 19.5449 19.5449 21 17.75 21H6.25C4.45507 21 3 19.5449 3 17.75V6.25C3 4.45507 4.45507 3 6.25 3H17.75ZM17.75 4.5H6.25C5.2835 4.5 4.5 5.2835 4.5 6.25V17.75C4.5 18.7165 5.2835 19.5 6.25 19.5H17.75C18.7165 19.5 19.5 18.7165 19.5 17.75V6.25C19.5 5.2835 18.7165 4.5 17.75 4.5ZM7.75 7C8.1297 7 8.44349 7.28215 8.49315 7.64823L8.5 7.75V16.25C8.5 16.6642 8.16421 17 7.75 17C7.3703 17 7.05651 16.7178 7.00685 16.3518L7 16.25V7.75C7 7.33579 7.33579 7 7.75 7Z " },
            { FluentSymbol.CalendarWeekStart28Filled, "M6.25 25C4.45507 25 3 23.5449 3 21.75V6.25C3 4.45507 4.45507 3 6.25 3H21.75C23.5449 3 25 4.45507 25 6.25V21.75C25 23.5449 23.5449 25 21.75 25H6.25ZM8.75 19.75C9.1297 19.75 9.44349 19.4678 9.49315 19.1018L9.5 19V9L9.49315 8.89823C9.44349 8.53215 9.1297 8.25 8.75 8.25C8.3703 8.25 8.05651 8.53215 8.00685 8.89823L8 9V19L8.00685 19.1018C8.05651 19.4678 8.3703 19.75 8.75 19.75Z " },
            { FluentSymbol.CalendarWeekStart28, "M6.25 25C4.45507 25 3 23.5449 3 21.75V6.25C3 4.45507 4.45507 3 6.25 3H21.75C23.5449 3 25 4.45507 25 6.25V21.75C25 23.5449 23.5449 25 21.75 25H6.25ZM6.25 23.5H21.75C22.7165 23.5 23.5 22.7165 23.5 21.75V6.25C23.5 5.2835 22.7165 4.5 21.75 4.5H6.25C5.2835 4.5 4.5 5.2835 4.5 6.25V21.75C4.5 22.7165 5.2835 23.5 6.25 23.5ZM8.75 19.75C8.3703 19.75 8.05651 19.4678 8.00685 19.1018L8 19V9C8 8.58579 8.33579 8.25 8.75 8.25C9.1297 8.25 9.44349 8.53215 9.49315 8.89823L9.5 9V19C9.5 19.4142 9.16421 19.75 8.75 19.75Z " },
            { FluentSymbol.CalendarWorkWeek16Filled, "M6 7V6H10V7H6Z M2 4.5C2 3.11929 3.11929 2 4.5 2H11.5C12.8807 2 14 3.11929 14 4.5V11.5C14 12.8807 12.8807 14 11.5 14H4.5C3.11929 14 2 12.8807 2 11.5V4.5ZM5.5 5C5.22386 5 5 5.22386 5 5.5V7.5C5 7.77614 5.22386 8 5.5 8H10.5C10.7761 8 11 7.77614 11 7.5V5.5C11 5.22386 10.7761 5 10.5 5H5.5Z " },
            { FluentSymbol.CalendarWorkWeek16, "M5.5 5C5.22386 5 5 5.22386 5 5.5V7.5C5 7.77614 5.22386 8 5.5 8H10.5C10.7761 8 11 7.77614 11 7.5V5.5C11 5.22386 10.7761 5 10.5 5H5.5ZM6 7V6H10V7H6Z M4.5 2C3.11929 2 2 3.11929 2 4.5V11.5C2 12.8807 3.11929 14 4.5 14H11.5C12.8807 14 14 12.8807 14 11.5V4.5C14 3.11929 12.8807 2 11.5 2H4.5ZM3 4.5C3 3.67157 3.67157 3 4.5 3H11.5C12.3284 3 13 3.67157 13 4.5V11.5C13 12.3284 12.3284 13 11.5 13H4.5C3.67157 13 3 12.3284 3 11.5V4.5Z " },
            { FluentSymbol.CalendarWorkWeek20Filled, "M7 9V7H13V9H7Z M17 5.5C17 4.11929 15.8807 3 14.5 3H5.5C4.11929 3 3 4.11929 3 5.5V14.5C3 15.8807 4.11929 17 5.5 17H14.5C15.8807 17 17 15.8807 17 14.5V5.5ZM6.5 6H13.5C13.7761 6 14 6.22386 14 6.5V9.5C14 9.77614 13.7761 10 13.5 10H6.5C6.22386 10 6 9.77614 6 9.5V6.5C6 6.22386 6.22386 6 6.5 6Z " },
            { FluentSymbol.CalendarWorkWeek20, "M6.5 6C6.22386 6 6 6.22386 6 6.5V9.5C6 9.77614 6.22386 10 6.5 10H13.5C13.7761 10 14 9.77614 14 9.5V6.5C14 6.22386 13.7761 6 13.5 6H6.5ZM7 9V7H13V9H7Z M17 5.5C17 4.11929 15.8807 3 14.5 3H5.5C4.11929 3 3 4.11929 3 5.5V14.5C3 15.8807 4.11929 17 5.5 17H14.5C15.8807 17 17 15.8807 17 14.5V5.5ZM5.5 4H14.5C15.3284 4 16 4.67157 16 5.5V14.5C16 15.3284 15.3284 16 14.5 16H5.5C4.67157 16 4 15.3284 4 14.5V5.5C4 4.67157 4.67157 4 5.5 4Z " },
            { FluentSymbol.CalendarWorkWeek24Filled, "M8.5 11V8.5H15.5V11H8.5Z M17.75 21C19.5449 21 21 19.5449 21 17.75V6.25C21 4.45507 19.5449 3 17.75 3H6.25C4.45507 3 3 4.45507 3 6.25V17.75C3 19.5449 4.45507 21 6.25 21H17.75ZM7.75 7H16.25C16.6642 7 17 7.33579 17 7.75V11.75C17 12.1642 16.6642 12.5 16.25 12.5H7.75C7.33579 12.5 7 12.1642 7 11.75V7.75C7 7.33579 7.33579 7 7.75 7Z " },
            { FluentSymbol.CalendarWorkWeek24, "M7.75 7C7.33579 7 7 7.33579 7 7.75V11.75C7 12.1642 7.33579 12.5 7.75 12.5H16.25C16.6642 12.5 17 12.1642 17 11.75V7.75C17 7.33579 16.6642 7 16.25 7H7.75ZM8.5 11V8.5H15.5V11H8.5Z M17.75 21C19.5449 21 21 19.5449 21 17.75V6.25C21 4.45507 19.5449 3 17.75 3H6.25C4.45507 3 3 4.45507 3 6.25V17.75C3 19.5449 4.45507 21 6.25 21H17.75ZM19.5 6.25V17.75C19.5 18.7165 18.7165 19.5 17.75 19.5H6.25C5.2835 19.5 4.5 18.7165 4.5 17.75V6.25C4.5 5.2835 5.2835 4.5 6.25 4.5H17.75C18.7165 4.5 19.5 5.2835 19.5 6.25Z " },
            { FluentSymbol.CallAdd24Filled, "M9.36712 3.31261L10.2269 5.33995C10.6015 6.22341 10.3936 7.26231 9.71288 7.90844L7.81856 9.70645C7.93545 10.7819 8.29696 11.8409 8.90309 12.8834C9.50923 13.926 10.2663 14.7908 11.1742 15.4778L13.4494 14.7192C14.3118 14.4316 15.2509 14.7621 15.7799 15.5392L17.0123 17.3498C17.6272 18.2532 17.5166 19.4996 16.7536 20.2656L15.9359 21.0865C15.122 21.9036 13.9594 22.2 12.884 21.8646C10.3452 21.0726 8.01085 18.7214 5.88107 14.8109C3.7482 10.8948 2.99546 7.57218 3.62283 4.84317C3.88682 3.69486 4.70434 2.78038 5.77184 2.43927L6.84843 2.09527C7.85725 1.77291 8.9351 2.29386 9.36712 3.31261ZM17.1485 2.00392L17.2503 1.99707C17.63 1.99707 17.9438 2.27922 17.9935 2.6453L18.0003 2.74707L17.9999 6.00107L21.2521 6.00172C21.6318 6.00172 21.9456 6.28388 21.9952 6.64995L22.0021 6.75172C22.0021 7.13142 21.7199 7.44521 21.3538 7.49488L21.2521 7.50172L17.9999 7.50107L18.0003 10.75C18.0003 11.1297 17.7182 11.4435 17.3521 11.4932L17.2503 11.5C16.8706 11.5 16.5568 11.2179 16.5072 10.8518L16.5003 10.75L16.4999 7.50107L13.2486 7.50172C12.8689 7.50172 12.5551 7.21957 12.5054 6.85349L12.4986 6.75172C12.4986 6.37203 12.7807 6.05823 13.1468 6.00857L13.2486 6.00172L16.4999 6.00107L16.5003 2.74707C16.5003 2.36737 16.7825 2.05358 17.1485 2.00392L17.2503 1.99707L17.1485 2.00392Z " },
            { FluentSymbol.CallAdd24, "M9.52531 3.5721L10.427 5.57782C10.9097 6.65165 10.6553 7.91366 9.79427 8.71661L8.29997 10.1101C8.25629 10.1508 8.22864 10.2058 8.22201 10.2652C8.17765 10.6623 8.44688 11.4357 9.06715 12.51C9.5182 13.2913 9.92644 13.8391 10.2739 14.1473C10.516 14.362 10.6493 14.4084 10.7061 14.3915L12.7164 13.7769C13.842 13.4328 15.0618 13.8431 15.7505 14.7976L17.0312 16.5726C17.8373 17.6898 17.6924 19.2311 16.6921 20.1784L15.8057 21.0178C14.8493 21.9236 13.4877 22.2611 12.219 21.907C9.4649 21.1383 6.99559 18.8141 4.78372 14.9831C2.56877 11.1467 1.79158 7.84222 2.50803 5.07043C2.8359 3.80195 3.80203 2.79656 5.05646 2.41844L6.22346 2.06668C7.54596 1.66804 8.95896 2.31227 9.52531 3.5721ZM6.65636 3.50285L5.48936 3.85461C4.7367 4.08148 4.15702 4.68472 3.9603 5.44581C3.35765 7.77732 4.04651 10.7062 6.08276 14.2331C8.11629 17.7552 10.3052 19.8155 12.6223 20.4622C13.3835 20.6747 14.2004 20.4722 14.7743 19.9287L15.6606 19.0893C16.1153 18.6587 16.1812 17.9581 15.8148 17.4503L14.5341 15.6753C14.221 15.2415 13.6666 15.0549 13.1549 15.2114L11.1396 15.8275C9.96987 16.1762 8.9082 15.2347 7.76811 13.26C6.9998 11.9293 6.64171 10.9006 6.73128 10.0987C6.77768 9.68322 6.97125 9.29812 7.27697 9.01303L8.77127 7.61958C9.16266 7.2546 9.27829 6.68096 9.05887 6.19286L8.1572 4.18714C7.89977 3.61449 7.25749 3.32165 6.65636 3.50285ZM17.1483 2.0043L17.2501 1.99745C17.6298 1.99745 17.9436 2.2796 17.9933 2.64568L18.0001 2.74745L17.9995 6.00122L21.2519 6.0021C21.6316 6.0021 21.9453 6.28426 21.995 6.65033L22.0019 6.7521C22.0019 7.1318 21.7197 7.44559 21.3536 7.49525L21.2519 7.5021L17.9995 7.50122L18.0001 10.7504C18.0001 11.1301 17.718 11.4439 17.3519 11.4936L17.2501 11.5004C16.8704 11.5004 16.5566 11.2183 16.507 10.8522L16.5001 10.7504L16.4995 7.50122L13.2484 7.5021C12.8687 7.5021 12.5549 7.21995 12.5052 6.85387L12.4984 6.7521C12.4984 6.37241 12.7805 6.05861 13.1466 6.00895L13.2484 6.0021L16.4995 6.00122L16.5001 2.74745C16.5001 2.36775 16.7823 2.05396 17.1483 2.0043L17.2501 1.99745L17.1483 2.0043Z " },
            { FluentSymbol.CallEnd20Filled, "M17.9594 10.94L17.8015 11.7691C17.6535 12.5461 16.9272 13.0678 16.1042 12.9883L14.4666 12.8301C13.753 12.7612 13.2241 12.24 13 11.5C12.6957 10.4952 12.5 9.75004 12.5 9.75004C11.7522 9.44352 11.0138 9.25 10 9.25C8.98623 9.25 8.26225 9.46487 7.5 9.75004C7.5 9.75004 7.29566 10.4959 7 11.5C6.80244 12.1709 6.49595 12.7566 5.79708 12.8269L4.16895 12.9905C3.35656 13.0721 2.57765 12.5554 2.3467 11.7817L2.09921 10.9525C1.85286 10.1272 2.0727 9.25864 2.67633 8.6724C4.10141 7.28838 6.6656 6.50825 9.99245 6.50392C13.3241 6.49964 15.5858 7.27554 17.154 8.65971C17.8139 9.24215 18.116 10.1179 17.9594 10.94Z " },
            { FluentSymbol.CallEnd20, "M10 6.00001C13.3317 5.99572 15.5858 7.2756 17.154 8.65976C17.8139 9.2422 18.116 10.1179 17.9594 10.94L17.8015 11.7692C17.6535 12.5461 16.9272 13.0679 16.1042 12.9884L14.4666 12.8302C13.753 12.7613 13.2241 12.2401 13 11.5001C12.6957 10.4953 12.5 9.75009 12.5 9.75009C11.7522 9.44357 11.0138 9.25005 10 9.25005C8.98623 9.25005 8.26225 9.46492 7.5 9.75009C7.5 9.75009 7.29566 10.496 7 11.5001C6.80244 12.171 6.49595 12.7567 5.79708 12.8269L4.16895 12.9905C3.35656 13.0722 2.57765 12.5555 2.3467 11.7818L2.09921 10.9526C1.85286 10.1273 2.0727 9.25869 2.67633 8.67245C4.10141 7.28843 6.67315 6.00433 10 6.00001ZM13.4754 9.52689L13.5008 9.62157C13.5232 9.70474 13.5565 9.82664 13.5991 9.97972C13.6846 10.2861 13.8075 10.7163 13.9571 11.2102C14.0936 11.661 14.3462 11.8139 14.5628 11.8348L16.2004 11.993C16.5457 12.0264 16.7746 11.816 16.8191 11.5821L16.9771 10.7529C17.0653 10.2894 16.8963 9.76613 16.4923 9.40948C15.0673 8.1517 13.0404 6.9961 10.0013 7.00001C6.92594 7.00401 4.60599 8.19238 3.37303 9.38982C3.04458 9.70881 2.9145 10.1877 3.05744 10.6666L3.30493 11.4957C3.39647 11.8024 3.72575 12.03 4.06896 11.9955L5.69709 11.8319C5.73551 11.8281 5.74859 11.8203 5.7511 11.8189C5.75521 11.8165 5.77275 11.8057 5.80155 11.7692C5.8711 11.6811 5.9536 11.5135 6.04073 11.2176C6.18728 10.7199 6.31122 10.2861 6.39847 9.97694C6.44208 9.82241 6.47648 9.69914 6.49992 9.61474L6.52663 9.51827C6.62916 9.15132 6.98467 8.89552 7.14961 8.81349C7.96877 8.50703 8.81921 8.25005 10 8.25005C11.1653 8.25005 12.0327 8.47779 12.8793 8.8248C13.0313 8.88736 13.3617 9.10921 13.4672 9.4961L13.4691 9.50315L13.4754 9.52689Z " },
            { FluentSymbol.CallEnd24Filled, "M21.9489 12.9931L21.7515 14.0297C21.5666 15.001 20.659 15.6533 19.6307 15.5539L17.5843 15.3562C16.6926 15.27 15.9328 14.6366 15.7059 13.7902L15.0745 11.435C14.1401 11.0518 13.1101 10.8766 11.9847 10.9095C10.8594 10.9424 9.81256 11.1783 8.84436 11.6171L8.45329 13.8219C8.30505 14.6575 7.6155 15.2809 6.74217 15.3687L4.70765 15.5733C3.69249 15.6753 2.71915 15.0294 2.43056 14.0621L2.12129 13.0255C1.81345 11.9936 2.08816 10.9077 2.84247 10.1748C4.62325 8.44455 7.59228 7.57672 11.7495 7.57131C15.9128 7.56595 18.9743 8.4285 20.9339 10.159C21.7585 10.8871 22.1446 11.9653 21.9489 12.9931Z " },
            { FluentSymbol.CallEnd24, "M21.9034 13.2019L21.7115 14.0185C21.3955 15.3632 20.1311 16.2648 18.7569 16.1253L17.0022 15.9473C15.8309 15.8284 14.8652 14.9771 14.6003 13.83L14.2111 12.144C14.196 12.0786 14.1552 12.022 14.098 11.987C13.7766 11.7905 13.0643 11.6675 12 11.6675C11.2137 11.6675 10.6143 11.7336 10.214 11.8558C10.0735 11.8986 9.97566 11.9406 9.9129 11.9715L9.82228 12.0204L9.80812 12.0604L9.39949 13.8304C9.13472 14.9773 8.16943 15.8285 6.99845 15.9477L5.25276 16.1254C3.88217 16.2649 2.61986 15.3687 2.29961 14.0288L2.1043 13.2116C1.78596 11.8797 2.21895 10.4802 3.23382 9.56073C5.13427 7.83901 8.06359 7 12 7C15.9428 7 18.8753 7.84178 20.7755 9.56922C21.7273 10.4345 22.1653 11.723 21.9485 12.9804L21.9034 13.2019ZM20.4765 12.6878C20.5914 11.9455 20.3279 11.1896 19.7664 10.6791C18.1846 9.241 15.6031 8.5 12 8.5C8.4025 8.5 5.82343 9.23869 4.24092 10.6724C3.632 11.224 3.3722 12.0637 3.56321 12.8629L3.75852 13.6801C3.90409 14.2891 4.47787 14.6965 5.10086 14.6331L6.84656 14.4554C7.37882 14.4012 7.81758 14.0143 7.93794 13.493L8.36009 11.6725L8.40309 11.537C8.77886 10.5385 9.99419 10.1675 12 10.1675C13.3179 10.1675 14.2651 10.331 14.8805 10.7073C15.2815 10.9525 15.567 11.3487 15.6727 11.8066L16.0619 13.4925C16.1823 14.014 16.6212 14.4009 17.1537 14.455L18.9083 14.633C19.5329 14.6964 20.1077 14.2866 20.2513 13.6754L20.4432 12.8587L20.4765 12.6878Z " },
            { FluentSymbol.CallEnd28Filled, "M16.8575 13.3616L17.5631 16.8896C17.7453 17.8006 18.4686 18.5059 19.3839 18.6651L22.2559 19.1646C23.6948 19.4148 25.0783 18.4967 25.4067 17.0736L25.7842 15.4378C26.2691 13.3366 25.4011 11.032 23.2472 10.1877C21.1405 9.36202 17.9674 8.48716 13.9976 8.50014C10.0498 8.51305 6.89051 9.37732 4.78533 10.1917C2.61615 11.0309 1.73328 13.3462 2.2214 15.4614L2.59345 17.0736C2.92185 18.4967 4.30535 19.4148 5.74422 19.1646L8.61622 18.6651C9.53148 18.5059 10.2548 17.8006 10.437 16.8896L11.1426 13.3616C11.3047 13.324 11.5054 13.2805 11.7341 13.2369C12.3656 13.1166 13.1899 13.0002 14.0001 13.0002C14.8103 13.0002 15.6345 13.1166 16.266 13.2369C16.4947 13.2805 16.6954 13.324 16.8575 13.3616Z " },
            { FluentSymbol.CallEnd28, "M22.9606 11.4819C24.1523 12.0517 24.7074 13.4331 24.3755 14.8712L23.9421 16.7493C23.7936 17.3928 23.1701 17.8098 22.5186 17.7012L19.3715 17.1767C19.0699 17.1264 18.829 16.8981 18.7627 16.5996L17.9822 13.0874C17.9251 12.8303 17.7369 12.6218 17.487 12.5385L17.2501 13.2501C17.4872 12.5386 17.487 12.5385 17.487 12.5385L17.486 12.5382L17.4842 12.5376L17.4789 12.5359L17.4619 12.5304C17.4478 12.5258 17.4279 12.5195 17.4028 12.5118C17.3524 12.4963 17.2807 12.4749 17.19 12.4496C17.0087 12.399 16.7506 12.3325 16.4358 12.2662C15.8092 12.1343 14.9426 12.0001 14.0001 12.0001C13.0576 12.0001 12.1909 12.1343 11.5643 12.2662C11.2495 12.3325 10.9915 12.399 10.8102 12.4496C10.7195 12.4749 10.6477 12.4963 10.5974 12.5118C10.5722 12.5195 10.5524 12.5258 10.5382 12.5304L10.5212 12.5359L10.516 12.5376L10.5129 12.5386C10.5129 12.5386 10.5129 12.5386 10.7501 13.2501L10.5129 12.5386C10.263 12.6219 10.0751 12.8302 10.0179 13.0874L9.23745 16.5996C9.17112 16.8981 8.93022 17.1264 8.62861 17.1767L5.48154 17.7012C4.83007 17.8098 4.20656 17.3928 4.05805 16.7493L3.62933 14.8915C3.29547 13.4447 3.85859 12.0553 5.06187 11.4867C7.01624 10.5632 10.0947 9.51289 14.0025 9.50012C17.9235 9.48729 21.0089 10.5486 22.9606 11.4819ZM16.6147 13.8482L17.2984 16.925C17.4974 17.8205 18.2201 18.5055 19.1249 18.6563L22.272 19.1808C23.7052 19.4197 25.077 18.5023 25.4037 17.0866L25.8371 15.2085C26.2908 13.2424 25.568 11.066 23.6077 10.1286C21.5035 9.12247 18.1947 7.9864 13.9976 8.00012C9.8212 8.01378 6.52504 9.13632 4.42103 10.1305C2.44606 11.0637 1.71118 13.2503 2.16774 15.2288L2.59646 17.0866C2.92318 18.5023 4.29492 19.4197 5.72814 19.1808L8.87521 18.6563C9.78005 18.5055 10.5027 17.8205 10.7017 16.925L11.3855 13.8482C11.5201 13.8134 11.6847 13.7737 11.8733 13.734C12.4342 13.616 13.1926 13.5001 14.0001 13.5001C14.8076 13.5001 15.5659 13.616 16.1268 13.734C16.3155 13.7737 16.48 13.8134 16.6147 13.8482Z " },
            { FluentSymbol.CallForward16Filled, "M6.70072 1.17318L5.94626 1.03504C5.19816 0.898074 4.41344 1.16834 3.88345 1.74548C2.62393 3.1171 1.99613 5.25994 2.00002 8.17401C2.00397 11.0839 2.63562 13.162 3.895 14.4084C4.42844 14.9364 5.2188 15.1287 5.9698 14.9132L6.72431 14.6968C7.42835 14.4948 7.89851 13.8135 7.82422 13.1029L7.67534 11.6789C7.61143 11.0676 7.15772 10.585 6.54946 10.4812L4.94475 10.2075C4.62535 9.52978 4.45368 8.79709 4.42973 8.00938C4.40578 7.22167 4.53327 6.50078 4.81219 5.8467L6.52643 5.40479C7.14246 5.24599 7.60347 4.71419 7.66619 4.09001L7.81012 2.65765C7.88245 1.93788 7.40769 1.30262 6.70072 1.17318Z M11.8536 4.14645C11.6583 3.95118 11.3417 3.95118 11.1464 4.14645C10.9512 4.34171 10.9512 4.65829 11.1464 4.85355L13.2929 7H8.5C8.22386 7 8 7.22386 8 7.5C8 7.77614 8.22386 8 8.5 8H13.2929L11.1464 10.1464C10.9512 10.3417 10.9512 10.6583 11.1464 10.8536C11.3417 11.0488 11.6583 11.0488 11.8536 10.8536L14.8536 7.85355C15.0488 7.65829 15.0488 7.34171 14.8536 7.14645L11.8536 4.14645Z " },
            { FluentSymbol.CallForward16, "M6.37849 1.0697L6.22211 1.03814C5.33428 0.886386 4.42456 1.19304 3.81364 1.85936C2.59422 3.18937 2 5.24194 2 8.00159C2 10.7567 2.59226 12.807 3.80764 14.1373C4.45676 14.8477 5.44489 15.1509 6.38528 14.928L6.96198 14.7914C7.908 14.5672 8.54073 13.6836 8.44223 12.7241L8.31681 11.5024C8.23266 10.6828 7.63169 10.0071 6.82198 9.82171L5.57253 9.53571L5.54424 9.52581L5.50976 9.46239C5.48798 9.41847 5.45834 9.34999 5.42807 9.25166C5.3418 8.97145 5.29518 8.55194 5.29518 8.00159C5.29518 7.25672 5.38195 6.7582 5.52067 6.5332C5.5454 6.49309 5.58537 6.46453 5.63158 6.45395L6.82165 6.18154C7.63158 5.99615 8.23263 5.32013 8.31654 4.5002L8.44221 3.27226C8.54065 2.3103 7.90412 1.4252 6.95477 1.20398L6.37849 1.0697ZM3.05903 8.00159C3.05903 5.47971 3.58211 3.67289 4.59728 2.56565C4.95767 2.17258 5.49137 1.98811 6.01549 2.06856L6.13619 2.09185L6.71248 2.22614C7.144 2.32669 7.43333 2.72901 7.38858 3.16627L7.26292 4.3942C7.22478 4.7669 6.95157 5.07418 6.58342 5.15845L5.39332 5.43086C5.06993 5.5049 4.79019 5.7048 4.6171 5.98554C4.35153 6.41626 4.23615 7.07922 4.23615 8.00159C4.23615 9.40554 4.49804 10.2562 5.20297 10.5192L5.29866 10.5493L6.58375 10.8448C6.9518 10.9291 7.22497 11.2362 7.26322 11.6088L7.38864 12.8305C7.43341 13.2666 7.14581 13.6682 6.7158 13.7701L6.1391 13.9068C5.57487 14.0405 4.98199 13.8586 4.59251 13.4323C3.58048 12.3247 3.05903 10.5195 3.05903 8.00159Z M11.8536 4.14645C11.6583 3.95118 11.3417 3.95118 11.1464 4.14645C10.9512 4.34171 10.9512 4.65829 11.1464 4.85355L13.2929 7H8.5C8.22386 7 8 7.22386 8 7.5C8 7.77614 8.22386 8 8.5 8H13.2929L11.1464 10.1464C10.9512 10.3417 10.9512 10.6583 11.1464 10.8536C11.3417 11.0488 11.6583 11.0488 11.8536 10.8536L14.8536 7.85355C15.0488 7.65829 15.0488 7.34171 14.8536 7.14645L11.8536 4.14645Z " },
            { FluentSymbol.CallForward20Filled, "M9.28831 2.19792L8.43954 2.04005C7.59793 1.88351 6.71512 2.19239 6.11889 2.85198C4.70193 4.41954 3.99565 6.86851 4.00002 10.1989C4.00446 13.5244 4.71507 15.8994 6.13187 17.3239C6.732 17.9273 7.62114 18.1471 8.46603 17.9008L9.31485 17.6534C10.1069 17.4226 10.6358 16.644 10.5522 15.8319L10.3848 14.2044C10.3129 13.5058 9.80243 12.9542 9.11814 12.8356L7.31285 12.5228C6.95352 11.7483 6.76039 10.911 6.73345 10.0107C6.70651 9.11048 6.84993 8.2866 7.16371 7.53908L9.09224 7.03405C9.78527 6.85256 10.3039 6.24478 10.3745 5.53144L10.5364 3.89445C10.6178 3.07187 10.0837 2.34585 9.28831 2.19792Z M14.3536 5.64645C14.1583 5.45118 13.8417 5.45118 13.6464 5.64645C13.4512 5.84171 13.4512 6.15829 13.6464 6.35355L16.2929 9H10.5C10.2239 9 10 9.22386 10 9.5C10 9.77614 10.2239 10 10.5 10H16.2929L13.6464 12.6464C13.4512 12.8417 13.4512 13.1583 13.6464 13.3536C13.8417 13.5488 14.1583 13.5488 14.3536 13.3536L17.8536 9.85355C18.0488 9.65829 18.0488 9.34171 17.8536 9.14645L14.3536 5.64645Z " },
            { FluentSymbol.CallForward20, "M8.9258 2.07965L8.74987 2.04359C7.75107 1.87016 6.72763 2.22062 6.04034 2.98213C4.66849 4.50214 4 6.84793 4 10.0018C4 13.1505 4.66629 15.4938 6.03359 17.014C6.76386 17.826 7.8755 18.1724 8.93344 17.9177L9.58223 17.7616C10.6465 17.5054 11.3583 16.4955 11.2475 15.399L11.1064 14.0028C11.0117 13.066 10.3357 12.2938 9.42473 12.082L8.0191 11.7551L7.98727 11.7438L7.94847 11.6713C7.92398 11.6211 7.89063 11.5428 7.85658 11.4305C7.75953 11.1102 7.70708 10.6308 7.70708 10.0018C7.70708 9.15054 7.80469 8.58079 7.96075 8.32366C7.98858 8.27782 8.03354 8.24518 8.08553 8.23309L9.42436 7.92176C10.3355 7.70989 11.0117 6.9373 11.1061 6.00022L11.2475 4.59687C11.3582 3.49749 10.6421 2.48594 9.57412 2.23312L8.9258 2.07965ZM5.19141 10.0018C5.19141 7.11967 5.77987 5.05473 6.92194 3.78932C7.32738 3.34009 7.92779 3.12927 8.51743 3.22121L8.65321 3.24783L9.30154 3.4013C9.787 3.51622 10.1125 3.97601 10.0622 4.47573L9.92078 5.87908C9.87787 6.30503 9.57052 6.6562 9.15635 6.75251L7.81749 7.06384C7.45367 7.14846 7.13897 7.37691 6.94423 7.69776C6.64547 8.19001 6.51567 8.94768 6.51567 10.0018C6.51567 11.6063 6.81029 12.5785 7.60334 12.8791L7.71099 12.9135L9.15672 13.2512C9.57078 13.3475 9.87809 13.6985 9.92112 14.1243L10.0622 15.5205C10.1126 16.0189 9.78904 16.478 9.30528 16.5944L8.65649 16.7506C8.02173 16.9034 7.35474 16.6955 6.91658 16.2084C5.77804 14.9425 5.19141 12.8794 5.19141 10.0018ZM14.3536 5.64645C14.1583 5.45118 13.8417 5.45118 13.6464 5.64645C13.4512 5.84171 13.4512 6.15829 13.6464 6.35355L16.2929 9H10.5C10.2239 9 10 9.22386 10 9.5C10 9.77614 10.2239 10 10.5 10H16.2929L13.6464 12.6464C13.4512 12.8417 13.4512 13.1583 13.6464 13.3536C13.8417 13.5488 14.1583 13.5488 14.3536 13.3536L17.8536 9.85355C18.0488 9.65829 18.0488 9.34171 17.8536 9.14645L14.3536 5.64645Z " },
            { FluentSymbol.CallForward24Filled, "M9.925 2.0501L10.9622 2.24757C11.9341 2.4326 12.5867 3.34073 12.4873 4.36965L12.2894 6.41724C12.2032 7.30952 11.5695 8.06975 10.7226 8.29676L8.36598 8.92848C7.98254 9.8635 7.80728 10.894 7.8402 12.0201C7.87312 13.1461 8.10913 14.1935 8.54822 15.1623L10.7542 15.5536C11.5904 15.7019 12.2142 16.3919 12.302 17.2657L12.5067 19.3014C12.6088 20.3172 11.9625 21.2911 10.9946 21.5799L9.95737 21.8893C8.92495 22.1973 7.83843 21.9224 7.10509 21.1677C5.3738 19.3859 4.50546 16.4151 4.50002 12.2554C4.49469 8.08969 5.35774 5.02645 7.08923 3.06569C7.81781 2.24064 8.89658 1.85429 9.925 2.0501ZM16.6963 7.14678L16.7804 7.21941L20.7771 11.2171C21.0431 11.4832 21.0674 11.8995 20.8499 12.1931L20.7774 12.2772L16.7808 16.2806C16.4882 16.5738 16.0133 16.5742 15.7202 16.2815C15.4537 16.0155 15.4291 15.5989 15.6467 15.3051L15.7193 15.2209L18.4306 12.5037L12.0006 12.5046C11.6209 12.5046 11.3071 12.2225 11.2574 11.8564L11.2506 11.7546C11.2506 11.3749 11.5327 11.0611 11.8988 11.0115L12.0006 11.0046L18.4416 11.0037L15.7197 8.27993C15.4534 8.01363 15.4293 7.59697 15.6472 7.30338L15.7198 7.21927C15.9565 6.98262 16.312 6.93724 16.5943 7.08312L16.6963 7.14678Z " },
            { FluentSymbol.CallForward24, "M9.98012 2.05448L10.2016 2.09956L11.0179 2.2914C12.3625 2.60742 13.2641 3.87185 13.1246 5.24607L12.9467 7.00025C12.8278 8.17158 11.9765 9.13731 10.8293 9.40216L9.14371 9.79131C9.07826 9.80642 9.02165 9.84722 8.98662 9.90452C8.79014 10.2259 8.66724 10.9381 8.66724 12.0022C8.66724 12.7884 8.73328 13.3877 8.85546 13.788C8.89834 13.9285 8.94032 14.0263 8.97116 14.0891L9.02 14.1796L9.06008 14.1938L10.8298 14.6024C11.9766 14.8671 12.8278 15.8324 12.947 17.0034L13.1247 18.7487C13.2642 20.1192 12.368 21.3816 11.0281 21.7018L10.2112 21.897C8.87929 22.2154 7.47972 21.7823 6.56031 20.7674C4.83887 18.8671 4 15.9381 4 12.0022C4 8.05987 4.84164 5.12766 6.56881 3.22765C7.43411 2.27577 8.72262 1.8377 9.98012 2.05448ZM7.67875 4.23663C6.24088 5.81839 5.5 8.39955 5.5 12.0022C5.5 15.5992 6.23856 18.178 7.672 19.7603C8.22365 20.3693 9.06339 20.6291 9.86256 20.4381L10.6794 20.2429C11.2884 20.0973 11.6958 19.5236 11.6324 18.9006L11.4547 17.1553C11.4006 16.623 11.0137 16.1843 10.4924 16.0639L8.67217 15.6418L8.53664 15.5988C7.53818 15.2231 7.16724 14.0078 7.16724 12.0022C7.16724 10.6845 7.33067 9.73746 7.70682 9.12216C7.95199 8.7211 8.3482 8.43553 8.80625 8.32976L10.4919 7.9406C11.0133 7.82022 11.4003 7.38125 11.4543 6.84882L11.6323 5.09464C11.6957 4.47 11.2859 3.89526 10.6747 3.75161L9.85844 3.55978L9.68748 3.5265C8.94512 3.41158 8.1892 3.6751 7.67875 4.23663ZM15.6471 7.30379L15.7197 7.21968C15.986 6.95345 16.4027 6.92929 16.6963 7.14719L16.7804 7.21982L20.777 11.2175C21.0431 11.4836 21.0674 11.8999 20.8499 12.1935L20.7774 12.2776L16.7808 16.281C16.4881 16.5742 16.0133 16.5746 15.7201 16.282C15.4536 16.0159 15.4291 15.5993 15.6467 15.3055L15.7192 15.2213L18.43 12.505L12.0005 12.505C11.6208 12.505 11.3071 12.2229 11.2574 11.8568L11.2505 11.755C11.2505 11.3753 11.5327 11.0615 11.8988 11.0119L12.0005 11.005L18.443 11.005L15.7196 8.28034C15.4534 8.01404 15.4292 7.59737 15.6471 7.30379L15.7197 7.21968L15.6471 7.30379Z " },
            { FluentSymbol.CallForward28Filled, "M7.88114 3.80546C8.99014 2.29481 10.9794 2.18686 12.5923 2.95087L13.4821 3.37235C14.3961 3.80529 14.9089 4.79487 14.7356 5.79127L14.353 7.99147C14.1206 9.32762 13.083 10.379 11.75 10.6289L10.2841 10.9038C10.0478 10.9481 9.86128 11.0942 9.78902 11.2913C9.18943 12.9268 9.36827 15.286 10.0172 16.9239C10.1017 17.1372 10.3075 17.2884 10.5583 17.3218L11.6011 17.4609C13.0079 17.6484 14.1303 18.7272 14.3735 20.1255L14.7253 22.1487C14.904 23.176 14.3534 24.1915 13.3949 24.6023L12.1678 25.1282C10.5037 25.8414 8.49475 25.6342 7.47506 24.0274C6.2934 22.1653 5 18.986 5 13.9996C5 8.86461 6.53136 5.64411 7.88114 3.80546Z M19.7803 8.71918C19.4874 8.42629 19.0126 8.42629 18.7197 8.71918C18.4268 9.01207 18.4268 9.48695 18.7197 9.77984L21.9393 12.9995H13.75C13.3358 12.9995 13 13.3353 13 13.7495C13 14.1637 13.3358 14.4995 13.75 14.4995H21.9393L18.7197 17.7192C18.4268 18.0121 18.4268 18.4869 18.7197 18.7798C19.0126 19.0727 19.4874 19.0727 19.7803 18.7798L24.2803 14.2798C24.5732 13.9869 24.5732 13.5121 24.2803 13.2192L19.7803 8.71918Z " },
            { FluentSymbol.CallForward28, "M13.7771 2.8199C11.5011 1.50222 8.36077 1.59573 6.88454 4.15517C5.66436 6.27069 4.5 9.47894 4.5 13.9998C4.5 18.5207 5.66436 21.7289 6.88455 23.8444C8.36078 26.4038 11.5011 26.4973 13.7771 25.1797L13.9184 25.0979C14.9158 24.5204 15.4473 23.3822 15.2499 22.2467L14.8661 20.04C14.5855 18.4266 13.2904 17.1819 11.6672 16.9654L10.6244 16.8264C10.5291 16.8137 10.4914 16.7635 10.482 16.74C9.86786 15.1897 9.71001 12.9596 10.2585 11.4637C10.2604 11.4585 10.2652 11.4483 10.2826 11.4347C10.3016 11.4199 10.3333 11.4035 10.3763 11.3954L11.8421 11.1206C13.3802 10.8322 14.5775 9.61907 14.8456 8.07735L15.2499 5.75279C15.4473 4.61731 14.9158 3.47914 13.9184 2.90168L13.7771 2.8199ZM8.1839 4.90462C9.09281 3.32877 11.1701 3.04385 13.0256 4.11804L13.1668 4.19982C13.6202 4.4623 13.8618 4.97965 13.772 5.49578L13.3678 7.82034C13.2069 8.74537 12.4885 9.47325 11.5657 9.64628L10.0998 9.92113C9.57908 10.0188 9.06404 10.3639 8.85013 10.9473C8.14825 12.8618 8.3691 15.4792 9.08748 17.2925C9.32233 17.8852 9.86433 18.2383 10.4262 18.3133L11.4689 18.4523C12.4429 18.5822 13.2199 19.329 13.3883 20.297L13.772 22.5038C13.8618 23.0199 13.6202 23.5372 13.1668 23.7997L13.0255 23.8815C11.1701 24.9557 9.09282 24.6708 8.1839 23.095C7.09112 21.2003 6 18.2496 6 13.9998C6 9.75001 7.09112 6.79924 8.1839 4.90462Z M19.7803 8.71943C19.4874 8.42653 19.0126 8.42653 18.7197 8.71943C18.4268 9.01232 18.4268 9.48719 18.7197 9.78009L21.9393 12.9998H13.75C13.3358 12.9998 13 13.3355 13 13.7498C13 14.164 13.3358 14.4998 13.75 14.4998H21.9393L18.7197 17.7194C18.4268 18.0123 18.4268 18.4872 18.7197 18.7801C19.0126 19.073 19.4874 19.073 19.7803 18.7801L24.2803 14.2801C24.5732 13.9872 24.5732 13.5123 24.2803 13.2194L19.7803 8.71943Z " },
            { FluentSymbol.CallForward48Filled, "M17.2792 4.70416C19.4002 4.39327 21.7135 5.0034 23.6299 6.4407C24.8888 7.38482 25.5196 8.94953 25.2678 10.5028L24.5678 14.8195C24.2551 16.7475 22.765 18.2712 20.8446 18.6269L18.8121 19.0033C17.7485 19.2002 16.919 19.8541 16.7073 20.7579C16.2402 22.7517 16.2482 25.2644 16.7097 27.241C16.9207 28.1449 17.7489 28.7989 18.8121 28.9957L20.8446 29.3721C22.765 29.7278 24.2551 31.2515 24.5678 33.1795L25.2227 37.2181C25.5021 38.9412 24.7628 40.671 23.3244 41.66C21.4414 42.9545 19.2152 43.5417 17.1641 43.2771C15.0975 43.0105 13.2232 41.8774 12.1199 39.781C10.2998 36.3228 8.625 31.2919 8.625 24.4995C8.625 17.6527 10.3267 12.2788 12.1538 8.48377C13.2227 6.26377 15.1446 5.01706 17.2792 4.70416Z M33.1339 13.8656C32.6457 13.3775 31.8543 13.3775 31.3661 13.8656C30.878 14.3538 30.878 15.1452 31.3661 15.6334L37.7322 21.9995H23.75C23.0596 21.9995 22.5 22.5592 22.5 23.2495C22.5 23.9399 23.0596 24.4995 23.75 24.4995H37.7322L31.3661 30.8656C30.878 31.3538 30.878 32.1452 31.3661 32.6334C31.8543 33.1215 32.6457 33.1215 33.1339 32.6334L41.6339 24.1334C42.122 23.6452 42.122 22.8538 41.6339 22.3656L33.1339 13.8656Z " },
            { FluentSymbol.CallForward48, "M24.0049 5.94075C21.9667 4.41205 19.4878 3.74879 17.1886 4.08582C14.862 4.42686 12.7553 5.7938 11.5907 8.2127C9.72876 12.0799 8 17.5461 8 24.4996C8 31.3993 9.70234 36.5295 11.5668 40.0722C12.7725 42.3629 14.8323 43.6066 17.0841 43.897C19.3051 44.1835 21.6837 43.5464 23.6785 42.175C25.3161 41.0491 26.1577 39.0798 25.8396 37.1181L25.1847 33.0795C24.8298 30.891 23.1384 29.1613 20.9584 28.7576L18.9259 28.3812C18.0273 28.2148 17.4565 27.691 17.3183 27.0989C16.8784 25.2147 16.871 22.7994 17.3158 20.9005C17.4545 20.3086 18.0264 19.7844 18.9259 19.6179L20.9584 19.2415C23.1384 18.8378 24.8298 17.1081 25.1847 14.9196L25.8847 10.6029C26.1738 8.82018 25.4497 7.02433 24.0049 5.94075ZM13.8432 9.29721C14.6248 7.6739 15.9926 6.78785 17.5512 6.55939C19.1371 6.32692 20.9541 6.77767 22.5049 7.94075C23.2059 8.46648 23.5572 9.33777 23.4169 10.2027L22.7169 14.5194C22.531 15.6658 21.6451 16.5718 20.5031 16.7833L18.4707 17.1597C16.9148 17.4478 15.3126 18.4909 14.8817 20.3303C14.348 22.6088 14.3577 25.4137 14.8837 27.6673C15.3132 29.5069 16.9139 30.5512 18.4707 30.8394L20.5031 31.2158C21.6451 31.4273 22.531 32.3333 22.7169 33.4797L23.3718 37.5183C23.5352 38.5256 23.103 39.5368 22.2621 40.1149C20.7145 41.1789 18.9455 41.6164 17.4039 41.4176C15.8933 41.2227 14.5756 40.4212 13.7791 38.9078C12.0923 35.7027 10.5 30.97 10.5 24.4996C10.5 17.9727 12.1205 12.8754 13.8432 9.29721Z M33.1339 13.8656C32.6457 13.3775 31.8543 13.3775 31.3661 13.8656C30.878 14.3538 30.878 15.1452 31.3661 15.6334L37.7322 21.9995H23.75C23.0596 21.9995 22.5 22.5592 22.5 23.2495C22.5 23.9399 23.0596 24.4995 23.75 24.4995H37.7322L31.3661 30.8656C30.878 31.3538 30.878 32.1452 31.3661 32.6334C31.8543 33.1215 32.6457 33.1215 33.1339 32.6334L41.6339 24.1334C42.122 23.6452 42.122 22.8538 41.6339 22.3656L33.1339 13.8656Z " },
            { FluentSymbol.CallInbound28Filled, "M25.7803 3.28033C26.0732 2.98744 26.0732 2.51256 25.7803 2.21967C25.4874 1.92678 25.0125 1.92678 24.7196 2.21967L16.4999 10.4393V4.25C16.4999 3.83579 16.1641 3.5 15.7499 3.5C15.3357 3.5 14.9999 3.83579 14.9999 4.25V12.25C14.9999 12.6642 15.3357 13 15.7499 13H23.7499C24.1641 13 24.4999 12.6642 24.4999 12.25C24.4999 11.8358 24.1641 11.5 23.7499 11.5H17.5606L25.7803 3.28033Z M4.09127 2.8827C5.21094 2.16352 6.64368 1.88768 8.05881 2.08066L8.30499 2.11423C9.20527 2.23699 9.98679 2.79652 10.3931 3.6092L11.6838 6.19068C12.4168 7.65668 11.9435 9.43908 10.5797 10.3483L8.87181 11.4868C8.47496 11.7514 8.36361 12.1185 8.45156 12.3861C8.98221 14.0005 10.3923 16.1883 11.6209 17.4415C11.852 17.6772 12.2682 17.7465 12.6966 17.5109L14.0006 16.7937C15.8198 15.7931 18.1058 16.4612 19.0999 18.2839L20.1425 20.1953C20.5853 21.0071 20.5901 21.9873 20.1561 22.8036C18.7066 25.5294 15.3991 27.042 12.5927 25.2054C10.199 23.6389 7.25716 21.0435 4.85048 16.875C2.4083 12.6451 1.91902 8.97899 2.0697 6.32442C2.15663 4.79304 2.95617 3.61178 4.09127 2.8827Z " },
            { FluentSymbol.CallInbound28, "M25.7803 3.28033C26.0731 2.98744 26.0731 2.51256 25.7803 2.21967C25.4874 1.92678 25.0125 1.92678 24.7196 2.21967L16.4999 10.4393V4.25C16.4999 3.83579 16.1641 3.5 15.7499 3.5C15.3357 3.5 14.9999 3.83579 14.9999 4.25V12.25C14.9999 12.6642 15.3357 13 15.7499 13H23.7499C24.1641 13 24.4999 12.6642 24.4999 12.25C24.4999 11.8358 24.1641 11.5 23.7499 11.5H17.5606L25.7803 3.28033Z M8.05881 2.08066C6.64368 1.88768 5.21094 2.16352 4.09127 2.8827C2.95617 3.61178 2.15663 4.79304 2.0697 6.32442C1.91902 8.97899 2.4083 12.6451 4.85048 16.875C7.25716 21.0435 10.199 23.6389 12.5927 25.2054C15.3991 27.042 18.7066 25.5294 20.1561 22.8036C20.5901 21.9873 20.5853 21.0071 20.1425 20.1953L18.8784 17.8776C17.9989 16.2652 16.081 15.5271 14.3474 16.1338L12.6877 16.7147C12.2925 16.853 11.9536 16.7729 11.7654 16.5865C10.7116 15.5428 9.73916 13.7876 9.38273 12.3047C9.3176 12.0337 9.42621 11.6939 9.74239 11.4229L11.006 10.3398C12.1383 9.36923 12.4648 7.75264 11.7979 6.41877L10.3931 3.6092C9.98679 2.79652 9.20527 2.23699 8.30499 2.11423L8.05881 2.08066ZM3.56729 6.40943C3.62457 5.40031 4.13389 4.63809 4.90192 4.14478C5.68537 3.64156 6.75002 3.41607 7.85614 3.5669L8.10232 3.60047C8.51154 3.65627 8.86678 3.9106 9.05147 4.28001L10.4562 7.08957C10.8153 7.80781 10.6395 8.67829 10.0298 9.20088L8.76621 10.284C8.13199 10.8276 7.69686 11.7091 7.92427 12.6552C8.34303 14.3975 9.44932 16.4038 10.7099 17.6523C11.4092 18.3449 12.3995 18.4048 13.1832 18.1305L14.8429 17.5496C15.8831 17.1855 17.0338 17.6284 17.5615 18.5959L18.8256 20.9135C19.0268 21.2823 19.0291 21.7281 18.8317 22.0993C17.666 24.2914 15.2684 25.1638 13.4141 23.9503C11.1871 22.4929 8.42212 20.0613 6.14952 16.125C3.86102 12.1612 3.43229 8.78778 3.56729 6.40943Z " },
            { FluentSymbol.CallInbound48Filled, "M14.0094 3.75C9.07787 3.74999 4.37825 7.13021 4.53917 12.4856C4.67456 16.9911 5.74801 23.0192 9.41755 29.375C13.0588 35.6817 17.6796 39.8237 21.4654 42.4141C25.9585 45.4885 31.4721 43.3521 34.109 39.0372C35.2595 37.1546 35.0874 34.7491 33.6807 33.0494L31.2662 30.1319C29.8477 28.418 27.503 27.7842 25.4143 28.5501L22.4557 29.6349C21.6103 29.9449 20.8394 29.7836 20.3856 29.3157C18.5268 27.3992 16.233 24.0907 15.226 21.6406C14.996 21.0809 15.2056 20.3179 16.0182 19.7375L18.7848 17.7613C20.6839 16.4049 21.4596 13.9576 20.6886 11.7548L19.1173 7.2656C18.3803 5.15993 16.393 3.75001 14.1621 3.75H14.0094Z M43.6338 4.36615C44.122 4.8543 44.122 5.64576 43.6338 6.13392L30.2677 19.5H40.75C41.4403 19.5 42 20.0597 42 20.75C42 21.4404 41.4403 22 40.75 22H27.25C26.5596 22 26 21.4404 26 20.75V7.25003C26 6.55968 26.5596 6.00003 27.25 6.00003C27.9403 6.00003 28.5 6.55968 28.5 7.25003V17.7323L41.8661 4.36615C42.3542 3.87799 43.1457 3.87799 43.6338 4.36615Z " },
            { FluentSymbol.CallInbound48, "M14.0094 3.75C9.07787 3.74999 4.37825 7.13021 4.53917 12.4856C4.67456 16.9911 5.74801 23.0192 9.41755 29.375C13.0588 35.6817 17.6796 39.8237 21.4654 42.4141C25.9585 45.4885 31.4721 43.3521 34.109 39.0372C35.2595 37.1546 35.0874 34.7491 33.6807 33.0494L31.0418 29.8608C29.7721 28.3266 27.7437 27.6429 25.8043 28.0954L22.3827 28.8938C21.6147 29.073 20.9673 28.9028 20.5842 28.5167C18.8896 26.8089 16.9503 23.8402 16.1266 21.5335C15.932 20.9887 16.1349 20.2648 16.8454 19.6727L19.1692 17.7363C20.8515 16.3344 21.4869 14.0356 20.7635 11.9687L19.1173 7.2656C18.3803 5.15993 16.393 3.75001 14.1621 3.75H14.0094ZM7.03805 12.4105C6.93172 8.87223 10.0433 6.24999 14.0094 6.25L14.1621 6.25C15.3307 6.25 16.3716 6.98853 16.7577 8.09151L18.4038 12.7946C18.7828 13.8772 18.4499 15.0814 17.5687 15.8157L15.245 17.7521C14.0113 18.7802 13.1156 20.5357 13.7722 22.3742C14.7294 25.055 16.8788 28.3317 18.8095 30.2776C19.9662 31.4433 21.5899 31.646 22.9508 31.3284L26.3724 30.53C27.3883 30.293 28.4508 30.6511 29.1159 31.4547L31.7548 34.6433C32.4807 35.5206 32.5695 36.762 31.9758 37.7336C29.8755 41.1704 25.8815 42.4066 22.8772 40.3509C19.3317 37.9249 14.9993 34.0428 11.5826 28.125C8.15704 22.1917 7.16347 16.5843 7.03805 12.4105Z M43.6338 6.13392C44.122 5.64576 44.122 4.8543 43.6338 4.36615C43.1457 3.87799 42.3542 3.87799 41.8661 4.36615L28.5 17.7323V7.25003C28.5 6.55968 27.9403 6.00003 27.25 6.00003C26.5596 6.00003 26 6.55968 26 7.25003V20.75C26 21.4404 26.5596 22 27.25 22H40.75C41.4403 22 42 21.4404 42 20.75C42 20.0597 41.4403 19.5 40.75 19.5H30.2677L43.6338 6.13392Z " },
            { FluentSymbol.CallInbound16Filled, "M13.8536 2.14645C14.0489 2.34171 14.0489 2.65829 13.8536 2.85355L10.7072 6H12.5024C12.7785 6 13.0024 6.22386 13.0024 6.5C13.0024 6.77614 12.7785 7 12.5024 7H9.50007C9.22393 7 9.00007 6.77614 9.00007 6.5V3.5C9.00007 3.22386 9.22393 3 9.50007 3C9.77621 3 10.0001 3.22386 10.0001 3.5V5.29289L13.1465 2.14645C13.3418 1.95118 13.6584 1.95118 13.8536 2.14645Z M4.37408 2.11972C5.22511 1.79978 6.17939 2.18481 6.57008 3.00577L7.13661 4.19619C7.39917 4.7479 7.30085 5.40373 6.88805 5.85419L5.57157 7.29079C5.58731 7.35216 5.60714 7.42401 5.63169 7.50412C5.71729 7.78343 5.85774 8.15477 6.07636 8.52907C6.29299 8.89998 6.55248 9.20346 6.7602 9.41534C6.82087 9.47723 6.87651 9.53068 6.92455 9.57508L8.8022 9.0861C9.32822 8.94911 9.88718 9.10741 10.2633 9.49987L11.0386 10.309C11.7109 11.0106 11.6829 12.1254 10.9764 12.7924L10.6803 13.0719C9.55438 14.1347 7.80066 14.3617 6.54573 13.3186C5.60593 12.5374 4.47746 11.439 3.62802 10.1058C2.68718 8.6291 2.24792 6.87524 2.03983 5.55515C1.8025 4.04963 2.76057 2.72631 4.11092 2.21865L4.37408 2.11972Z " },
            { FluentSymbol.CallInbound16, "M13.8536 2.14645C14.0489 2.34171 14.0489 2.65829 13.8536 2.85355L10.7072 6H12.5024C12.7785 6 13.0024 6.22386 13.0024 6.5C13.0024 6.77614 12.7785 7 12.5024 7H9.50007C9.22393 7 9.00007 6.77614 9.00007 6.5V3.5C9.00007 3.22386 9.22393 3 9.50007 3C9.77621 3 10.0001 3.22386 10.0001 3.5V5.29289L13.1465 2.14645C13.3418 1.95118 13.6584 1.95118 13.8536 2.14645Z M4.37408 2.11972C5.22511 1.79978 6.17939 2.18481 6.57008 3.00577L7.15449 4.23376C7.4034 4.7568 7.32892 5.37642 6.96314 5.82556L6.01817 6.9859C6.03192 7.05631 6.05094 7.14297 6.07676 7.24155C6.15128 7.52609 6.27958 7.89902 6.49343 8.26515C6.70736 8.63143 6.96875 8.92619 7.17947 9.13059C7.25108 9.20005 7.31592 9.25819 7.36973 9.30425L8.87595 9.0276C9.37214 8.93646 9.88091 9.10086 10.2299 9.46511L11.0386 10.309C11.7109 11.0106 11.6829 12.1254 10.9764 12.7924L10.6803 13.0719C9.55438 14.1347 7.80066 14.3617 6.54573 13.3186C5.60593 12.5374 4.47746 11.439 3.62802 10.1058C2.68718 8.6291 2.24792 6.87524 2.03983 5.55515C1.8025 4.04963 2.76057 2.72631 4.11092 2.21865L4.37408 2.11972ZM7.23625 9.83713C6.94738 10.2452 6.94718 10.2451 6.94718 10.2451L6.94536 10.2438L6.94234 10.2416L6.93335 10.2351C6.92608 10.2298 6.91628 10.2226 6.90418 10.2134C6.87998 10.1951 6.84651 10.1692 6.80555 10.1358C6.72375 10.0693 6.61144 9.97276 6.4832 9.84837C6.22822 9.60103 5.90233 9.23589 5.62993 8.7695C5.35744 8.30296 5.19951 7.83904 5.10938 7.49489C5.06405 7.32181 5.03517 7.17628 5.0174 7.07214C5.0085 7.01999 5.00235 6.97801 4.99831 6.94789C4.99629 6.93283 4.99479 6.92071 4.99373 6.91176L4.99247 6.90071L4.99207 6.89701L4.99193 6.89563C4.99193 6.89563 4.99182 6.89455 5.48921 6.84361L4.99182 6.89455C4.9783 6.76262 5.01777 6.63072 5.10152 6.52788L6.18774 5.19409C6.30967 5.04437 6.3345 4.83783 6.25153 4.66349L5.66712 3.43549C5.49968 3.08365 5.0907 2.91864 4.72598 3.05576L4.46282 3.15469C3.47811 3.52489 2.87651 4.44076 3.02763 5.39944C3.22638 6.66022 3.63699 8.25883 4.47139 9.56847C5.24469 10.7822 6.2889 11.8047 7.18496 12.5495C7.98846 13.2174 9.17335 13.1192 9.99389 12.3447L10.2899 12.0652C10.5927 11.7794 10.6047 11.3016 10.3166 11.0009L9.50793 10.157C9.39158 10.0356 9.22199 9.98077 9.0566 10.0111L7.32657 10.3289C7.19406 10.3532 7.05715 10.3229 6.94718 10.2451L7.23625 9.83713Z " },
            { FluentSymbol.CallInbound20Filled, "M6.53544 2.1168C5.49406 1.85299 4.40494 1.96522 3.55101 2.443C2.68184 2.9293 2.07166 3.79051 2.04156 4.94442C1.99456 6.74577 2.41207 9.1633 4.06815 12.0023C5.70298 14.8048 7.50831 16.4846 9.0056 17.4834C9.95159 18.1144 10.9973 18.1311 11.8903 17.7196C12.7694 17.3145 13.4838 16.506 13.8548 15.503C14.0415 14.9981 13.9975 14.4368 13.7345 13.9672L12.9308 12.532C12.2478 11.3123 10.6974 10.8897 9.4899 11.594L9.05289 11.8489C8.7045 12.0522 8.34925 12.0035 8.15518 11.8005C7.50308 11.1185 6.90993 10.1217 6.64244 9.22429C6.56745 8.97267 6.68733 8.65613 7.01425 8.44857L7.80407 7.94711C8.9327 7.23055 9.29786 5.75287 8.6329 4.59308L7.73513 3.02722C7.47512 2.57372 7.04218 2.24518 6.53544 2.1168Z M17.8535 2.14677C18.0488 2.34203 18.0488 2.65861 17.8535 2.85388L12.7071 8.00032H16.5C16.7761 8.00032 17 8.22418 17 8.50032C17 8.77647 16.7761 9.00032 16.5 9.00032H11.5C11.2238 9.00032 11 8.77647 11 8.50032V3.50032C11 3.22418 11.2238 3.00032 11.5 3.00032C11.7761 3.00032 12 3.22418 12 3.50032V7.29322L17.1464 2.14677C17.3417 1.95151 17.6582 1.95151 17.8535 2.14677Z " },
            { FluentSymbol.CallInbound20, "M6.53544 2.1168C5.49406 1.85299 4.40494 1.96522 3.55101 2.443C2.68184 2.9293 2.07166 3.79051 2.04156 4.94442C1.99456 6.74577 2.41207 9.1633 4.06815 12.0023C5.70298 14.8048 7.50831 16.4846 9.0056 17.4834C9.95159 18.1144 10.9973 18.1311 11.8903 17.7196C12.7694 17.3145 13.4838 16.506 13.8548 15.503C14.0415 14.9981 13.9975 14.4368 13.7345 13.9672L12.781 12.2645C12.1747 11.1817 10.8657 10.7076 9.70661 11.151L9.04092 11.4056C8.71835 11.529 8.42164 11.4721 8.25304 11.3065C7.68784 10.7514 7.28407 9.9976 7.10089 9.18557C7.04329 8.93022 7.1603 8.62828 7.44299 8.41494L8.04412 7.9613C9.04934 7.20269 9.33337 5.81481 8.70699 4.72229L7.73513 3.02722C7.47512 2.57372 7.04218 2.24518 6.53544 2.1168ZM3.04122 4.97051C3.06139 4.19743 3.45254 3.64397 4.03928 3.31569C4.64126 2.97888 5.46263 2.87662 6.28987 3.08618C6.5339 3.148 6.74239 3.30622 6.8676 3.52461L7.83946 5.21969C8.21529 5.8752 8.04487 6.70792 7.44174 7.16309L6.84061 7.61673C6.32141 8.00856 5.96194 8.68096 6.1254 9.40562C6.34709 10.3884 6.83828 11.3187 7.55233 12.02C8.0737 12.5321 8.8175 12.5617 9.39819 12.3396L10.0639 12.085C10.7594 11.8189 11.5447 12.1034 11.9085 12.7531L12.862 14.4558C12.982 14.6699 13.002 14.9259 12.9169 15.1561C12.6267 15.9407 12.0825 16.53 11.4718 16.8114C10.8752 17.0863 10.2001 17.0781 9.56054 16.6515C8.18976 15.7371 6.49007 14.1695 4.93193 11.4984C3.36852 8.81828 2.99912 6.58401 3.04122 4.97051Z M17.8535 2.85388C18.0488 2.65861 18.0488 2.34203 17.8535 2.14677C17.6582 1.95151 17.3417 1.95151 17.1464 2.14677L12 7.29322V3.50032C12 3.22418 11.7761 3.00032 11.5 3.00032C11.2238 3.00032 11 3.22418 11 3.50032V8.50032C11 8.77647 11.2238 9.00032 11.5 9.00032H16.5C16.7761 9.00032 17 8.77647 17 8.50032C17 8.22418 16.7761 8.00032 16.5 8.00032H12.7071L17.8535 2.85388Z " },
            { FluentSymbol.CallInbound24Filled, "M9.36712 3.31297L10.2269 5.34031C10.6015 6.22377 10.3936 7.26267 9.71288 7.9088L7.81856 9.70681C7.93545 10.7823 8.29696 11.8413 8.90309 12.8838C9.50923 13.9263 10.2663 14.7911 11.1742 15.4782L13.4494 14.7195C14.3118 14.4319 15.2509 14.7624 15.7799 15.5396L17.0123 17.3502C17.6272 18.2536 17.5166 19.4999 16.7536 20.2659L15.9359 21.0869C15.122 21.904 13.9594 22.2004 12.884 21.8649C10.3452 21.073 8.01085 18.7218 5.88107 14.8113C3.7482 10.8951 2.99546 7.57254 3.62283 4.84353C3.88682 3.69522 4.70434 2.78074 5.77184 2.43963L6.84843 2.09563C7.85725 1.77327 8.9351 2.29422 9.36712 3.31297ZM14.4979 8.43909L20.7185 2.2159C21.0114 1.92293 21.4862 1.92281 21.7792 2.21563C22.0455 2.48183 22.0699 2.89848 21.8521 3.19215L21.7795 3.27629L15.5589 9.49909L20.2501 9.49911C20.6298 9.49911 20.9436 9.78126 20.9932 10.1473L21.0001 10.2491C21.0001 10.6288 20.7179 10.9426 20.3519 10.9923L20.2501 10.9991L13.6953 10.9984L13.5971 10.9849L13.5017 10.9586L13.4339 10.9301C13.3556 10.8952 13.2826 10.8451 13.2184 10.7809L13.1777 10.7368L13.1526 10.7046L13.1052 10.636L13.0589 10.5445L13.0266 10.453L13.0103 10.3829L13.0003 10.3019L12.9986 10.2491V3.74522C12.9986 3.331 13.3344 2.99522 13.7486 2.99522C14.1283 2.99522 14.4421 3.27737 14.4917 3.64344L14.4986 3.74522L14.4979 8.43909L20.7185 2.2159L14.4979 8.43909Z " },
            { FluentSymbol.CallInbound24, "M9.52531 3.5721L10.427 5.57782C10.9097 6.65165 10.6553 7.91366 9.79427 8.71661L8.29997 10.1101C8.25629 10.1508 8.22864 10.2058 8.22201 10.2652C8.17765 10.6623 8.44688 11.4357 9.06715 12.51C9.5182 13.2913 9.92644 13.8391 10.2739 14.1473C10.516 14.362 10.6493 14.4084 10.7061 14.3915L12.7164 13.7769C13.842 13.4328 15.0618 13.8431 15.7505 14.7976L17.0312 16.5726C17.8373 17.6898 17.6924 19.2311 16.6921 20.1784L15.8057 21.0178C14.8493 21.9236 13.4877 22.2611 12.219 21.907C9.4649 21.1383 6.99559 18.8141 4.78372 14.9831C2.56877 11.1467 1.79158 7.84222 2.50803 5.07043C2.81769 3.87242 3.69665 2.90908 4.85011 2.4872L5.05646 2.41844L6.22346 2.06668C7.54596 1.66804 8.95896 2.31227 9.52531 3.5721ZM6.65636 3.50285L5.48936 3.85461L5.3308 3.90891C4.65584 4.16847 4.14297 4.73908 3.9603 5.44581C3.35765 7.77732 4.04651 10.7062 6.08276 14.2331C8.11629 17.7552 10.3052 19.8155 12.6223 20.4622C13.3835 20.6747 14.2004 20.4722 14.7743 19.9287L15.6606 19.0893C16.1153 18.6587 16.1812 17.9581 15.8148 17.4503L14.5341 15.6753C14.221 15.2415 13.6666 15.0549 13.1549 15.2114L11.1396 15.8275C9.96987 16.1762 8.9082 15.2347 7.76811 13.26C6.9998 11.9293 6.64171 10.9006 6.73128 10.0987C6.77768 9.68322 6.97125 9.29812 7.27697 9.01303L8.77127 7.61958C9.16266 7.2546 9.27829 6.68096 9.05887 6.19286L8.1572 4.18714C7.89977 3.61449 7.25749 3.32165 6.65636 3.50285ZM20.2499 10.9991L13.6962 10.9986L13.5969 10.9849L13.4949 10.9563L13.4471 10.9362C13.3636 10.9008 13.286 10.8487 13.2182 10.7809C13.1749 10.7376 13.138 10.6904 13.1075 10.6403L13.0587 10.5446L13.0337 10.4783L13.0101 10.3829L12.9989 10.2778L12.9984 3.74523C12.9984 3.33102 13.3341 2.99523 13.7484 2.99523C14.1281 2.99523 14.4418 3.27739 14.4915 3.64346L14.4984 3.74523L14.4975 8.43922L20.7183 2.21592C20.9845 1.94958 21.4012 1.92527 21.6949 2.14305L21.779 2.21565C22.0453 2.48184 22.0696 2.8985 21.8519 3.19217L21.7793 3.27631L15.5595 9.49822L20.2499 9.49912C20.6296 9.49912 20.9434 9.78128 20.993 10.1474L20.9999 10.2491C20.9999 10.6288 20.7177 10.9426 20.3517 10.9923L20.2499 10.9991Z " },
            { FluentSymbol.CallMissed16Filled, "M9.75658 5.43185L9.45382 3.91805C9.3753 3.90223 9.28458 3.88492 9.18504 3.86761C8.83792 3.80724 8.40119 3.75 8.00505 3.75C7.60892 3.75 7.17222 3.80724 6.82514 3.86761C6.72561 3.88491 6.63491 3.90222 6.55641 3.91804L6.25365 5.43184C6.13301 6.03504 5.65632 6.50344 5.0511 6.61348L4.37765 6.73592C3.3268 6.92698 2.31127 6.25862 2.0711 5.2179L2.00318 4.92359C1.74309 3.7965 2.16047 2.5296 3.31545 2.0063C4.38329 1.52248 5.99146 1.00664 8.00342 1.00006C10.0271 0.993445 11.6427 1.51566 12.7114 2.00565C13.8583 2.53153 14.2679 3.79252 14.0095 4.91234L13.939 5.21789C13.6988 6.25862 12.6833 6.92698 11.6324 6.73591L10.9591 6.61348C10.3539 6.50344 9.87722 6.03504 9.75658 5.43185Z M4 11C4 8.79086 5.79086 7 8 7C10.2091 7 12 8.79086 12 11C12 13.2091 10.2091 15 8 15C5.79086 15 4 13.2091 4 11ZM7.50244 9C7.2263 9 7.00244 9.22386 7.00244 9.5V11.5C7.00244 11.7761 7.2263 12 7.50244 12H8.99491C9.27105 12 9.49491 11.7761 9.49491 11.5C9.49491 11.2239 9.27105 11 8.99491 11H8.00244V9.5C8.00244 9.22386 7.77858 9 7.50244 9Z " },
            { FluentSymbol.CallMissed16, "M9.20696 4.15154L9.42231 5.12064C9.5992 5.91661 10.2416 6.52551 11.0459 6.65956L11.7435 6.77583C12.737 6.94142 13.6879 6.30553 13.9144 5.32411C14.2296 3.95825 13.7286 2.41165 12.3042 1.82924C11.2501 1.39828 9.78481 0.994237 8.00332 1.00006C6.22939 1.00586 4.76928 1.40759 3.71698 1.83406C2.28906 2.41276 1.78076 3.96017 2.09681 5.32973C2.32257 6.308 3.2704 6.94183 4.26072 6.77678L4.96401 6.65956C5.76831 6.52551 6.41071 5.91661 6.58759 5.12064L6.80295 4.15154C6.85218 4.13958 6.90725 4.12696 6.96735 4.11431C7.24232 4.05642 7.61247 4.00004 8.00496 4.00004C8.39744 4.00004 8.76759 4.05642 9.04256 4.11431C9.10266 4.12696 9.15773 4.13958 9.20696 4.15154ZM11.9257 2.75486C12.7753 3.10221 13.1772 4.07131 12.94 5.09925C12.8323 5.56585 12.3802 5.86816 11.9079 5.78944L11.2103 5.67317C10.8081 5.60614 10.4869 5.30169 10.3985 4.90371L10.118 3.64157C10.0799 3.47012 9.95388 3.33097 9.78726 3.27543C9.78726 3.27543 9.78805 3.27569 9.62993 3.75003L9.78726 3.27543L9.78619 3.27508L9.78323 3.2741L9.77405 3.27113L9.74304 3.2614C9.7169 3.25336 9.67996 3.24235 9.63347 3.22937C9.54061 3.20346 9.40897 3.16953 9.24857 3.13576C8.92979 3.06865 8.48746 3.00004 8.00496 3.00004C7.52246 3.00004 7.08012 3.06865 6.76134 3.13576C6.60094 3.16953 6.4693 3.20346 6.37643 3.22937C6.32994 3.24235 6.29301 3.25336 6.26687 3.2614L6.23585 3.27113L6.22667 3.2741L6.22371 3.27508L6.22186 3.27569C6.05524 3.33123 5.92998 3.47012 5.89188 3.64157L5.6114 4.90371C5.52296 5.30169 5.20177 5.60614 4.79962 5.67317L4.09632 5.79039C3.62717 5.86858 3.17815 5.56831 3.0712 5.10487C2.83389 4.0765 3.23973 3.10648 4.09258 2.76084C5.04981 2.3729 6.38318 2.00537 8.00659 2.00006C9.63352 1.99474 10.9688 2.36361 11.9257 2.75486Z M8.00244 9.5C8.00244 9.22386 7.77858 9 7.50244 9C7.2263 9 7.00244 9.22386 7.00244 9.5V11.5C7.00244 11.7761 7.2263 12 7.50244 12H8.99491C9.27105 12 9.49491 11.7761 9.49491 11.5C9.49491 11.2239 9.27105 11 8.99491 11H8.00244V9.5Z M4 11C4 8.79086 5.79086 7 8 7C10.2091 7 12 8.79086 12 11C12 13.2091 10.2091 15 8 15C5.79086 15 4 13.2091 4 11ZM8 8C6.34315 8 5 9.34315 5 11C5 12.6569 6.34315 14 8 14C9.65685 14 11 12.6569 11 11C11 9.34315 9.65685 8 8 8Z " },
            { FluentSymbol.CallMissed28Filled, "M25.7738 8.93647C25.7489 10.0689 25.2322 11.2111 24.4057 12.1049C23.8618 12.6931 23.0677 12.983 22.2727 12.8837L20.5168 12.6642C19.3899 12.5233 18.4655 11.7042 18.19 10.6024L17.7397 8.80087C17.6472 8.43107 17.4336 8.22222 17.2184 8.16463C16.3874 7.94215 15.2078 7.82411 13.9947 7.82557C12.7819 7.82703 11.605 7.94784 10.7805 8.16681C10.5659 8.2238 10.3527 8.43142 10.2604 8.80087L9.81 10.6024C9.53455 11.7042 8.61013 12.5233 7.4832 12.6642L5.72734 12.8837C4.93237 12.983 4.13824 12.6931 3.59431 12.1049C2.76782 11.2111 2.25115 10.0689 2.22627 8.93647C2.20077 7.77576 2.69884 6.6509 3.83567 5.92588C5.8007 4.67269 8.98498 3.5 14 3.5C19.015 3.5 22.1993 4.67269 24.1644 5.92588C25.3012 6.6509 25.7993 7.77576 25.7738 8.93647Z M14.5 17.25C14.5 16.8358 14.1642 16.5 13.75 16.5C13.3358 16.5 13 16.8358 13 17.25V20.25C13 20.6642 13.3358 21 13.75 21H15.75C16.1642 21 16.5 20.6642 16.5 20.25C16.5 19.8358 16.1642 19.5 15.75 19.5H14.5V17.25Z M20.5 19.5C20.5 23.0899 17.5899 26 14 26C10.4102 26 7.50003 23.0899 7.50003 19.5C7.50003 15.9102 10.4102 13 14 13C17.5899 13 20.5 15.9102 20.5 19.5ZM19 19.5C19 16.7386 16.7615 14.5 14 14.5C11.2386 14.5 9.00003 16.7386 9.00003 19.5C9.00003 22.2614 11.2386 24.5 14 24.5C16.7615 24.5 19 22.2614 19 19.5Z " },
            { FluentSymbol.CallMissed28, "M25.9569 8.93931C25.9059 10.0928 25.4154 11.247 24.6608 12.1888L24.5146 12.3714C23.9322 13.0982 23.0215 13.4809 22.0948 13.3882L19.5756 13.1363C18.4208 13.0208 17.4628 12.1928 17.1813 11.0669L16.7398 9.30087C16.6468 8.92908 16.4291 8.70086 16.1992 8.62938C14.8835 8.22024 13.1013 8.22794 11.8006 8.6306C11.5711 8.70165 11.3534 8.92928 11.2605 9.30087L10.819 11.0669C10.5375 12.1928 9.57954 13.0208 8.42475 13.1363L5.90547 13.3882C4.97875 13.4809 4.0681 13.0982 3.48574 12.3714L3.33947 12.1888C2.58486 11.247 2.09443 10.0928 2.04343 8.93931C1.99157 7.7666 2.39887 6.599 3.42155 5.73927C5.34856 4.11931 8.63059 2.5 14.0002 2.5C19.3697 2.5 22.6517 4.11931 24.5788 5.73927C25.6014 6.599 26.0087 7.76659 25.9569 8.93931ZM24.4583 8.87305C24.4922 8.10819 24.2373 7.41183 23.6135 6.88745C21.9766 5.51135 19.0433 4 14.0002 4C8.95699 4 6.02371 5.51135 4.38678 6.88745C3.76301 7.41183 3.50814 8.10819 3.54196 8.87305C3.57664 9.65717 3.91974 10.5141 4.51007 11.2509L4.65634 11.4335C4.92105 11.7638 5.33498 11.9378 5.75622 11.8957L8.2755 11.6437C8.8004 11.5912 9.23585 11.2149 9.36379 10.7031L9.8053 8.93707C9.98883 8.20295 10.4978 7.4637 11.357 7.19769C12.9431 6.70667 15.0353 6.69659 16.6446 7.19703C17.5031 7.46399 18.0115 8.20315 18.195 8.93707L18.6365 10.7031C18.7645 11.2149 19.1999 11.5912 19.7248 11.6437L22.2441 11.8957C22.6653 11.9378 23.0793 11.7638 23.344 11.4335L23.4902 11.2509C24.0806 10.5141 24.4237 9.65716 24.4583 8.87305Z M14.5001 17.25C14.5001 16.8358 14.1643 16.5 13.7501 16.5C13.3358 16.5 13.0001 16.8358 13.0001 17.25V20.25C13.0001 20.6642 13.3358 21 13.7501 21H15.7501C16.1643 21 16.5001 20.6642 16.5001 20.25C16.5001 19.8358 16.1643 19.5 15.7501 19.5H14.5001V17.25Z M14.0001 26C17.5899 26 20.5001 23.0899 20.5001 19.5C20.5001 15.9101 17.5899 13 14.0001 13C10.4102 13 7.50006 15.9101 7.50006 19.5C7.50006 23.0899 10.4102 26 14.0001 26ZM14.0001 24.5C11.2386 24.5 9.00006 22.2614 9.00006 19.5C9.00006 16.7386 11.2386 14.5 14.0001 14.5C16.7615 14.5 19.0001 16.7386 19.0001 19.5C19.0001 22.2614 16.7615 24.5 14.0001 24.5Z " },
            { FluentSymbol.CallMissed48Filled, "M42.3035 20.1738C44.8779 16.4735 44.2193 11.1254 39.7107 9.18334C35.9467 7.56207 30.6055 6 23.9999 6C17.3944 6 12.0532 7.56207 8.28923 9.18334C3.7806 11.1254 3.12201 16.4735 5.69637 20.1738C6.59231 21.4616 8.12464 22.1514 9.68272 21.9682L12.8482 21.5961C14.8859 21.3565 16.5974 19.9519 17.2297 18L17.9429 15.7986C18.1733 15.0874 18.6016 14.6897 19.0445 14.5906C20.3211 14.3049 22.1329 14.1482 23.9953 14.1462C25.8583 14.1443 27.6724 14.2972 28.9549 14.5867C29.3977 14.6867 29.826 15.0856 30.057 15.7986L30.7702 18C31.4025 19.9519 33.114 21.3565 35.1517 21.5961L38.3172 21.9682C39.8753 22.1514 41.4076 21.4616 42.3035 20.1738Z M24.9999 29.25C24.9999 28.5596 24.4403 28 23.7499 28C23.0595 28 22.4999 28.5596 22.4999 29.25V34.75C22.4999 35.4404 23.0595 36 23.7499 36H27.2499C27.9403 36 28.4999 35.4404 28.4999 34.75C28.4999 34.0596 27.9403 33.5 27.2499 33.5H24.9999V29.25Z M23.9999 44C30.075 44 34.9999 39.0751 34.9999 33C34.9999 26.9249 30.075 22 23.9999 22C17.9248 22 12.9999 26.9249 12.9999 33C12.9999 39.0751 17.9248 44 23.9999 44ZM23.9999 41.5C19.3055 41.5 15.4999 37.6944 15.4999 33C15.4999 28.3056 19.3055 24.5 23.9999 24.5C28.6943 24.5 32.4999 28.3056 32.4999 33C32.4999 37.6944 28.6943 41.5 23.9999 41.5Z " },
            { FluentSymbol.CallMissed48, "M39.609 8.60536C44.3288 10.9204 45.008 16.5954 42.5287 20.7516C41.5443 22.4017 39.6919 23.3305 37.7808 23.1323L34.3498 22.7764C32.1915 22.5525 30.3933 21.0238 29.8248 18.9297L28.9949 15.8723C28.7841 15.0956 28.3286 14.6425 27.844 14.5286C25.653 14.0135 22.3339 14.0229 20.1551 14.532C19.6705 14.6453 19.2153 15.0969 19.0048 15.8723L18.1749 18.9297C17.6065 21.0238 15.8083 22.5525 13.6499 22.7764L10.219 23.1323C8.30787 23.3306 6.4554 22.4017 5.47107 20.7516C2.99172 16.5954 3.67093 10.9204 8.39075 8.60536C12.1537 6.75964 17.4577 5 23.9999 5C30.542 5 35.8461 6.75964 39.609 8.60536ZM40.3817 19.4708C42.3346 16.197 41.5558 12.3448 38.5081 10.8499C35.0133 9.13572 30.0852 7.5 23.9999 7.5C17.9145 7.5 12.9865 9.13572 9.49169 10.8499C6.44397 12.3448 5.66513 16.197 7.61807 19.4708C8.10381 20.2851 9.01796 20.7435 9.96105 20.6456L13.392 20.2897C14.5225 20.1725 15.4645 19.3717 15.7622 18.2748L16.5921 15.2174C16.9579 13.8696 17.9286 12.4849 19.5863 12.0976C22.1342 11.5022 25.8439 11.4902 28.4162 12.095C30.0732 12.4846 31.0422 13.8709 31.4076 15.2174L32.2375 18.2748C32.5353 19.3717 33.4772 20.1725 34.6078 20.2898L38.0387 20.6456C38.9818 20.7435 39.8959 20.2851 40.3817 19.4708Z M25 29.25C25 28.5596 24.4403 28 23.75 28C23.0596 28 22.5 28.5596 22.5 29.25V34.75C22.5 35.4404 23.0596 36 23.75 36H27.25C27.9403 36 28.5 35.4404 28.5 34.75C28.5 34.0596 27.9403 33.5 27.25 33.5H25V29.25Z M24 44C30.0751 44 35 39.0751 35 33C35 26.9249 30.0751 22 24 22C17.9249 22 13 26.9249 13 33C13 39.0751 17.9249 44 24 44ZM24 41.5C19.3056 41.5 15.5 37.6944 15.5 33C15.5 28.3056 19.3056 24.5 24 24.5C28.6944 24.5 32.5 28.3056 32.5 33C32.5 37.6944 28.6944 41.5 24 41.5Z " },
            { FluentSymbol.CallMissed20Filled, "M17.8015 7.76912L17.9594 6.93999C18.116 6.11786 17.8139 5.24215 17.154 4.65971C15.5858 3.27554 13.3241 2.49964 9.99245 2.50392C6.6656 2.50825 4.10141 3.28838 2.67633 4.6724C2.0727 5.25864 1.85286 6.12721 2.09921 6.95254L2.3467 7.78171C2.57765 8.55543 3.35656 9.07212 4.16895 8.99048L5.79708 8.82686C6.49595 8.75663 6.80244 8.17094 7 7.5C7.29566 6.49592 7.5 5.75004 7.5 5.75004C8.26225 5.46487 8.98623 5.25 10 5.25C11.0138 5.25 11.7522 5.44352 12.5 5.75004C12.5 5.75004 12.6957 6.49524 13 7.5C13.2241 8.24003 13.753 8.76121 14.4666 8.83014L16.1042 8.98832C16.9272 9.0678 17.6535 8.54606 17.8015 7.76912Z M9.5 11.5001C9.77614 11.5001 10 11.7239 10 12.0001V13.5001H11.0047C11.2809 13.5001 11.5047 13.724 11.5047 14.0001C11.5047 14.2763 11.2809 14.5001 11.0047 14.5001H9.5C9.22386 14.5001 9 14.2763 9 14.0001V12.0001C9 11.7239 9.22386 11.5001 9.5 11.5001Z M5.5 13.5001C5.5 11.0148 7.51472 9.00006 10 9.00006C12.4853 9.00006 14.5 11.0148 14.5 13.5001C14.5 15.9853 12.4853 18.0001 10 18.0001C7.51472 18.0001 5.5 15.9853 5.5 13.5001ZM10 10.0001C8.067 10.0001 6.5 11.5671 6.5 13.5001C6.5 15.4331 8.067 17.0001 10 17.0001C11.933 17.0001 13.5 15.4331 13.5 13.5001C13.5 11.5671 11.933 10.0001 10 10.0001Z " },
            { FluentSymbol.CallMissed20, "M10 2.00001C13.3317 1.99572 15.5858 3.2756 17.154 4.65976C17.8139 5.2422 18.116 6.11792 17.9594 6.94005L17.8015 7.76918C17.6535 8.54611 16.9272 9.06786 16.1042 8.98837L14.4666 8.8302C13.753 8.76127 13.2241 8.24008 13 7.50005C12.6957 6.4953 12.5 5.75009 12.5 5.75009C11.7522 5.44357 11.0138 5.25005 10 5.25005C8.98623 5.25005 8.26225 5.46492 7.5 5.75009C7.5 5.75009 7.29566 6.49597 7 7.50005C6.80244 8.17099 6.49595 8.75668 5.79708 8.82691L4.16895 8.99053C3.35656 9.07217 2.57765 8.55549 2.3467 7.78177L2.09921 6.95259C1.85286 6.12726 2.0727 5.25869 2.67633 4.67245C4.10141 3.28843 6.67315 2.00433 10 2.00001ZM13.4754 5.52689L13.5008 5.62157C13.5232 5.70474 13.5565 5.82664 13.5991 5.97972C13.6846 6.28606 13.8075 6.71629 13.9571 7.21019C14.0936 7.66095 14.3462 7.81391 14.5628 7.83483L16.2004 7.99301C16.5457 8.02635 16.7746 7.81599 16.8191 7.58206L16.9771 6.75293C17.0653 6.28943 16.8963 5.76613 16.4923 5.40948C15.0673 4.1517 13.0404 2.9961 10.0013 3.00001C6.92594 3.00401 4.60599 4.19238 3.37303 5.38982C3.04458 5.70881 2.9145 6.18768 3.05744 6.66657L3.30493 7.49575C3.39647 7.80242 3.72575 8.03003 4.06896 7.99554L5.69709 7.83193C5.73551 7.82807 5.74859 7.82034 5.7511 7.81886C5.75521 7.81649 5.77275 7.80572 5.80155 7.76923C5.8711 7.6811 5.9536 7.51349 6.04073 7.21759C6.18728 6.71989 6.31122 6.28611 6.39847 5.97694C6.44208 5.82241 6.47648 5.69914 6.49992 5.61474L6.52663 5.51827C6.62916 5.15132 6.98467 4.89552 7.14961 4.81349C7.96877 4.50703 8.81921 4.25005 10 4.25005C11.1653 4.25005 12.0327 4.47779 12.8793 4.8248C13.0313 4.88736 13.3617 5.10921 13.4672 5.4961L13.4691 5.50315L13.4754 5.52689Z M10 12C10 11.7239 9.77614 11.5 9.5 11.5C9.22386 11.5 9 11.7239 9 12V14.0001C9 14.2762 9.22386 14.5001 9.5 14.5001H11.0047C11.2809 14.5001 11.5047 14.2762 11.5047 14.0001C11.5047 13.7239 11.2809 13.5001 11.0047 13.5001H10V12Z M5.5 13.5C5.5 11.0147 7.51472 9 10 9C12.4853 9 14.5 11.0147 14.5 13.5C14.5 15.9853 12.4853 18 10 18C7.51472 18 5.5 15.9853 5.5 13.5ZM10 10C8.067 10 6.5 11.567 6.5 13.5C6.5 15.433 8.067 17 10 17C11.933 17 13.5 15.433 13.5 13.5C13.5 11.567 11.933 10 10 10Z " },
            { FluentSymbol.CallMissed24Filled, "M20.9337 5.65998C18.974 3.9295 15.9126 3.06695 11.7493 3.07229C7.59203 3.07772 4.62301 3.94555 2.84222 5.67584C2.08792 6.40875 1.8132 7.49463 2.12104 8.52645L2.43031 9.56308C2.71891 10.5304 3.69224 11.1763 4.70741 11.0743L6.74193 10.8697C7.61525 10.7819 8.30481 10.1585 8.45304 9.32285L8.84412 7.11812C9.81232 6.67929 10.8591 6.44342 11.9845 6.41052C13.1099 6.37762 14.1398 6.55277 15.0743 6.93598L15.7056 9.29122C15.9325 10.1376 16.6923 10.771 17.5841 10.8572L19.6305 11.0549C20.6588 11.1543 21.5664 10.502 21.7513 9.53067L21.9487 8.4941C22.1443 7.46628 21.7582 6.38814 20.9337 5.65998Z M11.7498 14.0004C12.164 14.0004 12.4998 14.3362 12.4998 14.7504V16.5004H13.4998C13.914 16.5004 14.2498 16.8362 14.2498 17.2504C14.2498 17.6646 13.914 18.0004 13.4998 18.0004H11.7498C11.3356 18.0004 10.9998 17.6646 10.9998 17.2504V14.7504C10.9998 14.3362 11.3355 14.0004 11.7498 14.0004Z M11.9998 11.0004C8.96219 11.0004 6.49976 13.4628 6.49976 16.5004C6.49976 19.5379 8.96219 22.0004 11.9998 22.0004C15.0373 22.0004 17.4998 19.5379 17.4998 16.5004C17.4998 13.4628 15.0373 11.0004 11.9998 11.0004ZM7.99976 16.5004C7.99976 14.2912 9.79062 12.5004 11.9998 12.5004C14.2089 12.5004 15.9998 14.2912 15.9998 16.5004C15.9998 18.7095 14.2089 20.5004 11.9998 20.5004C9.79062 20.5004 7.99976 18.7095 7.99976 16.5004Z " },
            { FluentSymbol.CallMissed24, "M12.0141 2.49609C15.957 2.49609 18.8895 3.33787 20.7896 5.06532C21.7444 5.9333 22.1822 7.22707 21.9607 8.48821L21.9176 8.69802L21.7257 9.51464C21.4097 10.8593 20.1452 11.7609 18.771 11.6214L17.0164 11.4434C15.8451 11.3245 14.8793 10.4732 14.6145 9.32605L14.2253 7.6401C14.2102 7.5747 14.1694 7.51811 14.1121 7.48308C13.7907 7.28655 13.0784 7.16362 12.0141 7.16362C10.5492 7.16362 9.86128 7.39293 9.82228 7.55654L9.41365 9.32651C9.14888 10.4734 8.18359 11.3246 7.01261 11.4438L5.26692 11.6215C3.89633 11.761 2.63402 10.8648 2.31377 9.52485L2.11846 8.70767C1.80012 7.37577 2.23311 5.97625 3.24798 5.05683C5.14843 3.33511 8.07776 2.49609 12.0141 2.49609ZM12.0141 3.99609C8.41666 3.99609 5.83759 4.73479 4.25508 6.16847C3.64616 6.72013 3.38636 7.55983 3.57737 8.35897L3.77268 9.17617C3.91825 9.78522 4.49203 10.1926 5.11502 10.1292L6.86072 9.95148C7.39298 9.8973 7.83175 9.51039 7.9521 8.98909L8.36193 7.214C8.6312 6.08378 9.89168 5.66362 12.0141 5.66362C13.3321 5.66362 14.2793 5.8271 14.8947 6.20338C15.2956 6.44858 15.5811 6.84478 15.6868 7.30271L16.0761 8.98862C16.1964 9.51006 16.6354 9.89702 17.1678 9.95105L18.9224 10.1291C19.5471 10.1925 20.1218 9.78265 20.2655 9.17145L20.4574 8.35484L20.4907 8.18389C20.6056 7.44156 20.3421 6.68567 19.7806 6.17521C18.1987 4.7371 15.6173 3.99609 12.0141 3.99609Z M12.4998 14.7502C12.4998 14.336 12.164 14.0002 11.7498 14.0002C11.3355 14.0002 10.9998 14.336 10.9998 14.7502V17.2502C10.9998 17.6644 11.3356 18.0002 11.7498 18.0002H13.4998C13.914 18.0002 14.2498 17.6644 14.2498 17.2502C14.2498 16.836 13.914 16.5002 13.4998 16.5002H12.4998V14.7502Z M6.49976 16.5002C6.49976 13.4626 8.96219 11.0002 11.9998 11.0002C15.0373 11.0002 17.4998 13.4626 17.4998 16.5002C17.4998 19.5378 15.0373 22.0002 11.9998 22.0002C8.96219 22.0002 6.49976 19.5378 6.49976 16.5002ZM11.9998 12.5002C9.79062 12.5002 7.99976 14.291 7.99976 16.5002C7.99976 18.7093 9.79062 20.5002 11.9998 20.5002C14.2089 20.5002 15.9998 18.7093 15.9998 16.5002C15.9998 14.291 14.2089 12.5002 11.9998 12.5002Z " },
            { FluentSymbol.CallOutbound16Filled, "M10.5 2C10.2239 2 10 2.22386 10 2.5C10 2.77614 10.2239 3 10.5 3H12.2929L9.14644 6.14655C8.95118 6.34181 8.95119 6.6584 9.14645 6.85366C9.34172 7.04892 9.6583 7.04891 9.85356 6.85365L13 3.70713V5.5C13 5.77614 13.2239 6 13.5 6C13.7761 6 14 5.77614 14 5.5V2.5C14 2.22386 13.7761 2 13.5 2H10.5Z M6.57008 3.00577C6.17939 2.18481 5.22511 1.79977 4.37408 2.11971L4.11092 2.21865C2.76057 2.7263 1.8025 4.04962 2.03983 5.55514C2.24792 6.87523 2.68718 8.6291 3.62802 10.1058C4.47746 11.439 5.60593 12.5374 6.54573 13.3186C7.80066 14.3617 9.55438 14.1347 10.6803 13.0718L10.9764 12.7924C11.6829 12.1254 11.7109 11.0106 11.0386 10.309L10.2633 9.49986C9.88718 9.1074 9.32822 8.9491 8.8022 9.08609L6.92455 9.57508C6.87651 9.53067 6.82087 9.47722 6.7602 9.41533C6.55248 9.20345 6.29299 8.89998 6.07636 8.52906C5.85774 8.15477 5.71729 7.78342 5.63169 7.50411C5.60714 7.42401 5.58731 7.35215 5.57157 7.29078L6.88805 5.85419C7.30085 5.40372 7.39917 4.74789 7.13661 4.19618L6.57008 3.00577Z " },
            { FluentSymbol.CallOutbound28Filled, "M15.2196 11.7197C14.9267 12.0126 14.9267 12.4874 15.2196 12.7803C15.5125 13.0732 15.9874 13.0732 16.2803 12.7803L24.4999 4.56066V10.75C24.4999 11.1642 24.8357 11.5 25.2499 11.5C25.6641 11.5 25.9999 11.1642 25.9999 10.75V2.75C25.9999 2.33579 25.6641 2 25.2499 2H17.2499C16.8357 2 16.4999 2.33579 16.4999 2.75C16.4999 3.16421 16.8357 3.5 17.2499 3.5H23.4393L15.2196 11.7197Z M4.09127 2.8827C5.21094 2.16352 6.64368 1.88768 8.05881 2.08066L8.30499 2.11423C9.20527 2.23699 9.98679 2.79652 10.3931 3.6092L11.6838 6.19068C12.4168 7.65668 11.9435 9.43908 10.5797 10.3483L8.87181 11.4868C8.47496 11.7514 8.36361 12.1185 8.45156 12.3861C8.98221 14.0005 10.3923 16.1883 11.6209 17.4415C11.852 17.6772 12.2682 17.7465 12.6966 17.5109L14.0006 16.7937C15.8198 15.7931 18.1058 16.4612 19.0999 18.2839L20.1425 20.1953C20.5853 21.0071 20.5901 21.9873 20.1561 22.8036C18.7066 25.5294 15.3991 27.042 12.5927 25.2054C10.199 23.6389 7.25716 21.0435 4.85048 16.875C2.4083 12.6451 1.91902 8.97899 2.0697 6.32442C2.15663 4.79304 2.95617 3.61178 4.09127 2.8827Z " },
            { FluentSymbol.CallOutbound28, "M15.2196 11.7197C14.9267 12.0126 14.9267 12.4874 15.2196 12.7803C15.5125 13.0732 15.9874 13.0732 16.2803 12.7803L24.4999 4.56066V10.75C24.4999 11.1642 24.8357 11.5 25.2499 11.5C25.6641 11.5 25.9999 11.1642 25.9999 10.75V2.75C25.9999 2.33579 25.6641 2 25.2499 2H17.2499C16.8357 2 16.4999 2.33579 16.4999 2.75C16.4999 3.16421 16.8357 3.5 17.2499 3.5H23.4393L15.2196 11.7197Z M8.05881 2.08066C6.64368 1.88768 5.21094 2.16352 4.09127 2.8827C2.95617 3.61178 2.15663 4.79304 2.0697 6.32442C1.91902 8.97899 2.4083 12.6451 4.85048 16.875C7.25716 21.0435 10.199 23.6389 12.5927 25.2054C15.3991 27.042 18.7066 25.5294 20.1561 22.8036C20.5901 21.9873 20.5853 21.0071 20.1425 20.1953L18.8784 17.8776C17.9989 16.2652 16.081 15.5271 14.3474 16.1338L12.6877 16.7147C12.2925 16.853 11.9536 16.7729 11.7654 16.5865C10.7116 15.5428 9.73916 13.7876 9.38273 12.3047C9.3176 12.0337 9.42621 11.6939 9.74239 11.4229L11.006 10.3398C12.1383 9.36923 12.4648 7.75264 11.7979 6.41877L10.3931 3.6092C9.98679 2.79652 9.20527 2.23699 8.30499 2.11423L8.05881 2.08066ZM3.56729 6.40943C3.62457 5.40031 4.13389 4.63809 4.90192 4.14478C5.68537 3.64156 6.75002 3.41607 7.85614 3.5669L8.10232 3.60047C8.51154 3.65627 8.86678 3.9106 9.05147 4.28001L10.4562 7.08957C10.8153 7.80781 10.6395 8.67829 10.0298 9.20088L8.76621 10.284C8.13199 10.8276 7.69686 11.7091 7.92427 12.6552C8.34303 14.3975 9.44932 16.4038 10.7099 17.6523C11.4092 18.3449 12.3995 18.4048 13.1832 18.1305L14.8429 17.5496C15.8831 17.1855 17.0338 17.6284 17.5615 18.5959L18.8256 20.9135C19.0268 21.2823 19.0291 21.7281 18.8317 22.0993C17.666 24.2914 15.2684 25.1638 13.4141 23.9503C11.1871 22.4929 8.42212 20.0613 6.14952 16.125C3.86102 12.1612 3.43229 8.78778 3.56729 6.40943Z " },
            { FluentSymbol.CallOutbound48Filled, "M14.0094 3.75C9.07787 3.74999 4.37825 7.13021 4.53917 12.4856C4.67456 16.9911 5.74801 23.0192 9.41755 29.375C13.0588 35.6817 17.6796 39.8237 21.4654 42.4141C25.9585 45.4885 31.4721 43.3521 34.109 39.0372C35.2595 37.1546 35.0874 34.7491 33.6807 33.0494L31.2662 30.1319C29.8477 28.418 27.503 27.7842 25.4143 28.5501L22.4557 29.6349C21.6103 29.9449 20.8394 29.7836 20.3856 29.3157C18.5268 27.3992 16.233 24.0907 15.226 21.6406C14.996 21.0809 15.2056 20.3179 16.0182 19.7375L18.7848 17.7613C20.6839 16.4049 21.4596 13.9576 20.6886 11.7548L19.1173 7.2656C18.3803 5.15993 16.393 3.75001 14.1621 3.75H14.0094Z M26.3661 21.6339C25.8779 21.1458 25.8779 20.3543 26.3661 19.8661L39.7322 6.50003H29.25C28.5596 6.50003 28 5.94039 28 5.25003C28 4.55968 28.5596 4.00003 29.25 4.00003H42.75C43.4403 4.00003 44 4.55968 44 5.25003V18.75C44 19.4404 43.4403 20 42.75 20C42.0596 20 41.5 19.4404 41.5 18.75V8.2678L28.1338 21.6339C27.6457 22.1221 26.8542 22.1221 26.3661 21.6339Z " },
            { FluentSymbol.CallOutbound48, "M14.0094 3.75C9.07787 3.74999 4.37825 7.13021 4.53917 12.4856C4.67456 16.9911 5.74801 23.0192 9.41755 29.375C13.0588 35.6817 17.6796 39.8237 21.4654 42.4141C25.9585 45.4885 31.4721 43.3521 34.109 39.0372C35.2595 37.1546 35.0874 34.7491 33.6807 33.0494L31.0418 29.8608C29.7721 28.3266 27.7437 27.6429 25.8043 28.0954L22.3827 28.8938C21.6147 29.073 20.9673 28.9028 20.5842 28.5167C18.8896 26.8089 16.9503 23.8402 16.1266 21.5335C15.932 20.9887 16.1349 20.2648 16.8454 19.6727L19.1692 17.7363C20.8515 16.3344 21.4869 14.0356 20.7635 11.9687L19.1173 7.2656C18.3803 5.15993 16.393 3.75001 14.1621 3.75H14.0094ZM7.03805 12.4105C6.93172 8.87223 10.0433 6.24999 14.0094 6.25L14.1621 6.25C15.3307 6.25 16.3716 6.98853 16.7577 8.09151L18.4038 12.7946C18.7828 13.8772 18.4499 15.0814 17.5687 15.8157L15.245 17.7521C14.0113 18.7802 13.1156 20.5357 13.7722 22.3742C14.7294 25.055 16.8788 28.3317 18.8095 30.2776C19.9662 31.4433 21.5899 31.646 22.9508 31.3284L26.3724 30.53C27.3883 30.293 28.4508 30.6511 29.1159 31.4547L31.7548 34.6433C32.4807 35.5206 32.5695 36.762 31.9758 37.7336C29.8755 41.1704 25.8815 42.4066 22.8772 40.3509C19.3317 37.9249 14.9993 34.0428 11.5826 28.125C8.15704 22.1917 7.16347 16.5843 7.03805 12.4105Z M26.3661 19.8661C25.8779 20.3543 25.8779 21.1458 26.3661 21.6339C26.8542 22.1221 27.6457 22.1221 28.1338 21.6339L41.5 8.2678V18.75C41.5 19.4404 42.0596 20 42.75 20C43.4403 20 44 19.4404 44 18.75V5.25003C44 4.55968 43.4403 4.00003 42.75 4.00003H29.25C28.5596 4.00003 28 4.55968 28 5.25003C28 5.94039 28.5596 6.50003 29.25 6.50003H39.7322L26.3661 19.8661Z " },
            { FluentSymbol.CallOutbound16, "M10.0001 2.5C10.0001 2.22386 10.2239 2 10.5001 2H13.5001C13.7762 2 14.0001 2.22386 14.0001 2.5V5.5C14.0001 5.77614 13.7762 6 13.5001 6C13.2239 6 13.0001 5.77614 13.0001 5.5V3.70713L9.85362 6.85365C9.65836 7.04891 9.34178 7.04892 9.14652 6.85366C8.95125 6.6584 8.95125 6.34181 9.14651 6.14655L12.293 3H10.5001C10.2239 3 10.0001 2.77614 10.0001 2.5Z M4.37408 2.11972C5.22511 1.79977 6.17939 2.18481 6.57008 3.00577L7.15449 4.23376C7.4034 4.7568 7.32892 5.37641 6.96314 5.82556L6.01817 6.9859C6.03192 7.05631 6.05094 7.14296 6.07676 7.24154C6.15128 7.52609 6.27958 7.89902 6.49343 8.26515C6.70736 8.63143 6.96875 8.92618 7.17947 9.13058C7.25108 9.20005 7.31592 9.25819 7.36973 9.30425L8.87595 9.0276C9.37214 8.93646 9.88091 9.10086 10.2299 9.46511L11.0386 10.309C11.7109 11.0106 11.6829 12.1254 10.9764 12.7924L10.6803 13.0718C9.55438 14.1347 7.80066 14.3617 6.54573 13.3186C5.60593 12.5374 4.47746 11.439 3.62802 10.1058C2.68718 8.6291 2.24792 6.87523 2.03983 5.55515C1.8025 4.04962 2.76057 2.72631 4.11092 2.21865L4.37408 2.11972ZM7.23625 9.83713C6.94738 10.2452 6.94718 10.2451 6.94718 10.2451L6.94536 10.2438L6.94234 10.2416L6.93335 10.2351C6.92608 10.2298 6.91628 10.2226 6.90418 10.2134C6.87998 10.1951 6.84651 10.1692 6.80555 10.1358C6.72375 10.0693 6.61144 9.97276 6.4832 9.84837C6.22822 9.60103 5.90233 9.23588 5.62993 8.76949C5.35744 8.30296 5.19951 7.83904 5.10938 7.49489C5.06405 7.32181 5.03517 7.17628 5.0174 7.07213C5.0085 7.01999 5.00235 6.97801 4.99831 6.94789C4.99629 6.93282 4.99479 6.92071 4.99373 6.91175L4.99247 6.90071L4.99207 6.89701L4.99193 6.89562C4.99193 6.89562 4.99182 6.89455 5.48921 6.84361L4.99182 6.89455C4.9783 6.76261 5.01777 6.63071 5.10152 6.52787L6.18774 5.19408C6.30967 5.04437 6.3345 4.83783 6.25153 4.66348L5.66712 3.43549C5.49968 3.08365 5.0907 2.91864 4.72598 3.05575L4.46282 3.15469C3.47811 3.52488 2.87651 4.44075 3.02763 5.39943C3.22638 6.66022 3.63699 8.25882 4.47139 9.56846C5.24469 10.7822 6.2889 11.8047 7.18496 12.5495C7.98846 13.2174 9.17335 13.1192 9.99389 12.3447L10.2899 12.0652C10.5927 11.7794 10.6047 11.3016 10.3166 11.0009L9.50793 10.157C9.39158 10.0356 9.22199 9.98077 9.0566 10.0111L7.32657 10.3289C7.19406 10.3532 7.05715 10.3229 6.94718 10.2451L7.23625 9.83713Z " },
            { FluentSymbol.CallOutbound20Filled, "M6.53544 2.1168C5.49406 1.85299 4.40494 1.96522 3.55101 2.443C2.68184 2.9293 2.07166 3.79051 2.04156 4.94442C1.99456 6.74577 2.41207 9.1633 4.06815 12.0023C5.70298 14.8048 7.50831 16.4846 9.0056 17.4834C9.95159 18.1144 10.9973 18.1311 11.8903 17.7196C12.7694 17.3145 13.4838 16.506 13.8548 15.503C14.0415 14.9981 13.9975 14.4368 13.7345 13.9672L12.9308 12.532C12.2478 11.3123 10.6974 10.8897 9.4899 11.594L9.05289 11.8489C8.7045 12.0522 8.34925 12.0035 8.15518 11.8005C7.50308 11.1185 6.90993 10.1217 6.64244 9.22429C6.56745 8.97267 6.68733 8.65613 7.01425 8.44857L7.80407 7.94711C8.9327 7.23055 9.29786 5.75287 8.6329 4.59308L7.73513 3.02722C7.47512 2.57372 7.04218 2.24518 6.53544 2.1168Z M11.1464 8.85388C10.9511 8.65861 10.9511 8.34203 11.1464 8.14677L16.2928 3.00032H12.5C12.2238 3.00032 12 2.77647 12 2.50032C12 2.22418 12.2238 2.00032 12.5 2.00032H17.5C17.7761 2.00032 18 2.22418 18 2.50032V7.50032C18 7.77647 17.7761 8.00032 17.5 8.00032C17.2238 8.00032 17 7.77647 17 7.50032V3.70743L11.8535 8.85388C11.6582 9.04914 11.3417 9.04914 11.1464 8.85388Z " },
            { FluentSymbol.CallOutbound20, "M6.53544 2.1168C5.49406 1.85299 4.40494 1.96522 3.55101 2.443C2.68184 2.9293 2.07166 3.79051 2.04156 4.94442C1.99456 6.74577 2.41207 9.1633 4.06815 12.0023C5.70298 14.8048 7.50831 16.4846 9.0056 17.4834C9.95159 18.1144 10.9973 18.1311 11.8903 17.7196C12.7694 17.3145 13.4838 16.506 13.8548 15.503C14.0415 14.9981 13.9975 14.4368 13.7345 13.9672L12.781 12.2645C12.1747 11.1817 10.8657 10.7076 9.70661 11.151L9.04092 11.4056C8.71835 11.529 8.42164 11.4721 8.25304 11.3065C7.68784 10.7514 7.28407 9.9976 7.10089 9.18557C7.04329 8.93022 7.1603 8.62828 7.44299 8.41494L8.04412 7.9613C9.04934 7.20269 9.33337 5.81481 8.70699 4.72229L7.73513 3.02722C7.47512 2.57372 7.04218 2.24518 6.53544 2.1168ZM3.04122 4.97051C3.06139 4.19743 3.45254 3.64397 4.03928 3.31569C4.64126 2.97888 5.46263 2.87662 6.28987 3.08618C6.5339 3.148 6.74239 3.30622 6.8676 3.52461L7.83946 5.21969C8.21529 5.8752 8.04487 6.70792 7.44174 7.16309L6.84061 7.61673C6.32141 8.00856 5.96194 8.68096 6.1254 9.40562C6.34709 10.3884 6.83828 11.3187 7.55233 12.02C8.0737 12.5321 8.8175 12.5617 9.39819 12.3396L10.0639 12.085C10.7594 11.8189 11.5447 12.1034 11.9085 12.7531L12.862 14.4558C12.982 14.6699 13.002 14.9259 12.9169 15.1561C12.6267 15.9407 12.0825 16.53 11.4718 16.8114C10.8752 17.0863 10.2001 17.0781 9.56054 16.6515C8.18976 15.7371 6.49007 14.1695 4.93193 11.4984C3.36852 8.81828 2.99912 6.58401 3.04122 4.97051Z M11.1464 8.14677C10.9511 8.34203 10.9511 8.65861 11.1464 8.85388C11.3417 9.04914 11.6582 9.04914 11.8535 8.85388L17 3.70743V7.50032C17 7.77647 17.2238 8.00032 17.5 8.00032C17.7761 8.00032 18 7.77647 18 7.50032V2.50032C18 2.22418 17.7761 2.00032 17.5 2.00032H12.5C12.2238 2.00032 12 2.22418 12 2.50032C12 2.77647 12.2238 3.00032 12.5 3.00032H16.2928L11.1464 8.14677Z " },
            { FluentSymbol.CallOutbound24Filled, "M9.36712 3.31232L10.2269 5.33967C10.6015 6.22312 10.3936 7.26203 9.71288 7.90815L7.81856 9.70616C7.93545 10.7816 8.29696 11.8406 8.90309 12.8832C9.50923 13.9257 10.2663 14.7905 11.1742 15.4776L13.4494 14.7189C14.3118 14.4313 15.2509 14.7618 15.7799 15.539L17.0123 17.3495C17.6272 18.2529 17.5166 19.4993 16.7536 20.2653L15.9359 21.0862C15.122 21.9033 13.9594 22.1997 12.884 21.8643C10.3452 21.0723 8.01085 18.7211 5.88107 14.8107C3.7482 10.8945 2.99546 7.57189 3.62283 4.84289C3.88682 3.69457 4.70434 2.78009 5.77184 2.43899L6.84843 2.09498C7.85725 1.77263 8.9351 2.29358 9.36712 3.31232ZM14.7482 2.00105L21.3018 2.00156L21.4021 2.01546L21.5005 2.04291L21.5644 2.07007C21.6427 2.10494 21.7157 2.15507 21.7799 2.21929L21.8206 2.26332L21.8642 2.31971L21.9161 2.40544L21.9564 2.49826L21.9842 2.59755L21.9972 2.68884L21.9969 2.701L21.9992 2.72138L21.9997 9.25494C21.9997 9.66916 21.6639 10.0049 21.2497 10.0049C20.87 10.0049 20.5562 9.72279 20.5066 9.35671L20.4997 9.25494L20.4993 4.56005L14.2797 10.7843C14.0135 11.0506 13.5969 11.0749 13.3032 10.8571L13.2191 10.7845C12.9527 10.5183 12.9284 10.1017 13.1462 9.80801L13.2188 9.72387L19.4383 3.50005L14.7482 3.50105C14.3685 3.50105 14.0547 3.2189 14.005 2.85282L13.9982 2.75105C13.9982 2.37136 14.2804 2.05756 14.6464 2.0079L14.7482 2.00105Z " },
            { FluentSymbol.CallOutbound24, "M9.52531 3.5721L10.427 5.57782C10.9097 6.65165 10.6553 7.91366 9.79427 8.71661L8.29997 10.1101C8.25629 10.1508 8.22864 10.2058 8.22201 10.2652C8.17765 10.6623 8.44688 11.4357 9.06715 12.51C9.5182 13.2913 9.92644 13.8391 10.2739 14.1473C10.516 14.362 10.6493 14.4084 10.7061 14.3915L12.7164 13.7769C13.842 13.4328 15.0618 13.8431 15.7505 14.7976L17.0312 16.5726C17.8373 17.6898 17.6924 19.2311 16.6921 20.1784L15.8057 21.0178C14.8493 21.9236 13.4877 22.2611 12.219 21.907C9.4649 21.1383 6.99559 18.8141 4.78372 14.9831C2.56877 11.1467 1.79158 7.84222 2.50803 5.07043C2.81769 3.87242 3.69665 2.90908 4.85011 2.4872L5.05646 2.41844L6.22346 2.06668C7.54596 1.66804 8.95896 2.31227 9.52531 3.5721ZM6.65636 3.50285L5.48936 3.85461L5.3308 3.90891C4.65584 4.16847 4.14297 4.73908 3.9603 5.44581C3.35765 7.77732 4.04651 10.7062 6.08276 14.2331C8.11629 17.7552 10.3052 19.8155 12.6223 20.4622C13.3835 20.6747 14.2004 20.4722 14.7743 19.9287L15.6606 19.0893C16.1153 18.6587 16.1812 17.9581 15.8148 17.4503L14.5341 15.6753C14.221 15.2415 13.6666 15.0549 13.1549 15.2114L11.1396 15.8275C9.96987 16.1762 8.9082 15.2347 7.76811 13.26C6.9998 11.9293 6.64171 10.9006 6.73128 10.0987C6.77768 9.68322 6.97125 9.29812 7.27697 9.01303L8.77127 7.61958C9.16266 7.2546 9.27829 6.68096 9.05887 6.19286L8.1572 4.18714C7.89977 3.61449 7.25749 3.32165 6.65636 3.50285ZM14.748 2.00166L21.2638 2.00185C21.2896 2.00104 21.3154 2.00286 21.3411 2.006L21.4027 2.01629L21.4977 2.04266L21.5864 2.08025L21.6538 2.11987C21.6983 2.14704 21.7406 2.18089 21.7797 2.21995C21.8182 2.25844 21.8517 2.30006 21.88 2.34401L21.9221 2.41814L21.9639 2.52152L21.988 2.6189L21.9989 2.71982L21.9995 9.25561C21.9995 9.66982 21.6637 10.0056 21.2495 10.0056C20.8698 10.0056 20.556 9.72345 20.5064 9.35738L20.4995 9.25561L20.4995 4.56122L14.2795 10.7849C14.0133 11.0513 13.5967 11.0756 13.303 10.8578L13.2189 10.7852C12.9525 10.519 12.9282 10.1023 13.146 9.80867L13.2186 9.72453L19.4385 3.50122L14.748 3.50172C14.3683 3.50172 14.0545 3.21956 14.0048 2.85349L13.998 2.75172C13.998 2.3375 14.3338 2.00166 14.748 2.00166Z " },
            { FluentSymbol.CallPark16Filled, "M10.5 2C10.2239 2 10 2.22386 10 2.5V7.5C10 7.77614 10.2239 8 10.5 8C10.7761 8 11 7.77614 11 7.5V6H12C13.1046 6 14 5.10457 14 4C14 2.89543 13.1046 2 12 2H10.5ZM12 5H11V3H12C12.5523 3 13 3.44772 13 4C13 4.55228 12.5523 5 12 5Z M4.37408 2.11971C5.22511 1.79977 6.17939 2.18481 6.57008 3.00577L7.13661 4.19618C7.39917 4.74789 7.30085 5.40372 6.88805 5.85419L5.57157 7.29078C5.58731 7.35215 5.60714 7.42401 5.63169 7.50411C5.71729 7.78342 5.85774 8.15477 6.07636 8.52906C6.29299 8.89998 6.55248 9.20345 6.7602 9.41533C6.82087 9.47722 6.87651 9.53067 6.92455 9.57508L8.8022 9.08609C9.32822 8.9491 9.88718 9.1074 10.2633 9.49986L11.0386 10.309C11.7109 11.0106 11.6829 12.1254 10.9764 12.7924L10.6803 13.0718C9.55438 14.1347 7.80066 14.3617 6.54573 13.3186C5.60593 12.5374 4.47746 11.439 3.62802 10.1058C2.68718 8.6291 2.24792 6.87523 2.03983 5.55514C1.8025 4.04962 2.76057 2.7263 4.11092 2.21865L4.37408 2.11971Z " },
            { FluentSymbol.CallPark16, "M10.5 2C10.2239 2 10 2.22386 10 2.5V7.5C10 7.77614 10.2239 8 10.5 8C10.7761 8 11 7.77614 11 7.5V6H12C13.1046 6 14 5.10457 14 4C14 2.89543 13.1046 2 12 2H10.5ZM12 5H11V3H12C12.5523 3 13 3.44772 13 4C13 4.55228 12.5523 5 12 5Z M6.57008 3.00577C6.17939 2.18481 5.22511 1.79977 4.37408 2.11971L4.11092 2.21865C2.76057 2.7263 1.8025 4.04962 2.03983 5.55514C2.24792 6.87523 2.68718 8.6291 3.62802 10.1058C4.47746 11.439 5.60593 12.5374 6.54573 13.3186C7.80066 14.3617 9.55438 14.1347 10.6803 13.0718L10.9764 12.7924C11.6829 12.1254 11.7109 11.0106 11.0386 10.309L10.2299 9.4651C9.88091 9.10085 9.37214 8.93646 8.87595 9.02759L7.36973 9.30425C7.31592 9.25818 7.25108 9.20005 7.17947 9.13058C6.96875 8.92618 6.70736 8.63142 6.49343 8.26515C6.27958 7.89902 6.15128 7.52609 6.07676 7.24154C6.05094 7.14296 6.03192 7.0563 6.01817 6.9859L6.96314 5.82555C7.32892 5.37641 7.4034 4.7568 7.15449 4.23376L6.57008 3.00577ZM6.94536 10.2438L6.94718 10.2451C7.05715 10.3229 7.19406 10.3532 7.32657 10.3289L9.0566 10.0111C9.22199 9.98076 9.39158 10.0356 9.50793 10.157L10.3166 11.0009C10.6047 11.3016 10.5927 11.7794 10.2899 12.0652L9.99389 12.3447C9.17335 13.1192 7.98846 13.2174 7.18496 12.5495C6.2889 11.8047 5.24469 10.7822 4.47139 9.56846C3.63699 8.25882 3.22638 6.66022 3.02763 5.39943C2.87651 4.44075 3.47811 3.52488 4.46282 3.15468L4.72598 3.05575C5.0907 2.91863 5.49968 3.08365 5.66712 3.43549L6.25153 4.66348C6.3345 4.83783 6.30967 5.04436 6.18774 5.19408L5.10152 6.52787C5.01777 6.63071 4.99182 6.89455 4.99182 6.89455L4.99193 6.89562L4.99207 6.89701L4.99247 6.90071L4.99373 6.91175C4.99479 6.92071 4.99629 6.93282 4.99831 6.94789C5.00235 6.978 5.0085 7.01999 5.0174 7.07213C5.03517 7.17628 5.06405 7.3218 5.10938 7.49489C5.19951 7.83903 5.35744 8.30296 5.62993 8.76949C5.90233 9.23588 6.22822 9.60103 6.4832 9.84837C6.61144 9.97275 6.72375 10.0693 6.80555 10.1358C6.84651 10.1692 6.87998 10.1951 6.90418 10.2134C6.91628 10.2226 6.92608 10.2298 6.93335 10.2351L6.94234 10.2416L6.94536 10.2438Z " },
            { FluentSymbol.CallPark28Filled, "M17.2499 2C16.8357 2 16.4999 2.33579 16.4999 2.75V13.25C16.4999 13.6642 16.8357 14 17.2499 14C17.6641 14 17.9999 13.6642 17.9999 13.25V10H20.9999C23.2091 10 24.9999 8.20914 24.9999 6C24.9999 3.79086 23.2091 2 20.9999 2H17.2499ZM20.9999 8.5H17.9999V3.5H20.9999C22.3806 3.5 23.4999 4.61929 23.4999 6C23.4999 7.38072 22.3806 8.5 20.9999 8.5Z M4.09127 2.8827C5.21094 2.16352 6.64368 1.88768 8.05881 2.08066L8.30499 2.11423C9.20527 2.23699 9.98679 2.79652 10.3931 3.6092L11.6838 6.19068C12.4168 7.65668 11.9435 9.43908 10.5797 10.3483L8.87181 11.4868C8.47496 11.7514 8.36361 12.1185 8.45156 12.3861C8.98221 14.0005 10.3923 16.1883 11.6209 17.4415C11.852 17.6772 12.2682 17.7465 12.6966 17.5109L14.0006 16.7937C15.8198 15.7931 18.1058 16.4612 19.0999 18.2839L20.1425 20.1953C20.5853 21.0071 20.5901 21.9873 20.1561 22.8036C18.7066 25.5294 15.3991 27.042 12.5927 25.2054C10.199 23.6389 7.25716 21.0435 4.85048 16.875C2.4083 12.6451 1.91902 8.97899 2.0697 6.32442C2.15663 4.79304 2.95617 3.61178 4.09127 2.8827Z " },
            { FluentSymbol.CallPark28, "M17.2499 2C16.8357 2 16.4999 2.33579 16.4999 2.75V13.25C16.4999 13.6642 16.8357 14 17.2499 14C17.6641 14 17.9999 13.6642 17.9999 13.25V10H20.9999C23.2091 10 24.9999 8.20914 24.9999 6C24.9999 3.79086 23.2091 2 20.9999 2H17.2499ZM20.9999 8.5H17.9999V3.5H20.9999C22.3806 3.5 23.4999 4.61929 23.4999 6C23.4999 7.38072 22.3806 8.5 20.9999 8.5Z M8.05881 2.08066C6.64368 1.88768 5.21094 2.16352 4.09127 2.8827C2.95617 3.61178 2.15663 4.79304 2.0697 6.32442C1.91902 8.97899 2.4083 12.6451 4.85048 16.875C7.25716 21.0435 10.199 23.6389 12.5927 25.2054C15.3991 27.042 18.7066 25.5294 20.1561 22.8036C20.5901 21.9873 20.5853 21.0071 20.1425 20.1953L18.8784 17.8776C17.9989 16.2652 16.081 15.5271 14.3474 16.1338L12.6877 16.7147C12.2925 16.853 11.9536 16.7729 11.7654 16.5865C10.7116 15.5428 9.73916 13.7876 9.38273 12.3047C9.3176 12.0337 9.42621 11.6939 9.74239 11.4229L11.006 10.3398C12.1383 9.36923 12.4648 7.75264 11.7979 6.41877L10.3931 3.6092C9.98679 2.79652 9.20527 2.23699 8.30499 2.11423L8.05881 2.08066ZM3.56729 6.40943C3.62457 5.40031 4.13389 4.63809 4.90192 4.14478C5.68537 3.64156 6.75002 3.41607 7.85614 3.5669L8.10232 3.60047C8.51154 3.65627 8.86678 3.9106 9.05147 4.28001L10.4562 7.08957C10.8153 7.80781 10.6395 8.67829 10.0298 9.20088L8.76621 10.284C8.13199 10.8276 7.69686 11.7091 7.92427 12.6552C8.34303 14.3975 9.44932 16.4038 10.7099 17.6523C11.4092 18.3449 12.3995 18.4048 13.1832 18.1305L14.8429 17.5496C15.8831 17.1855 17.0338 17.6284 17.5615 18.5959L18.8256 20.9135C19.0268 21.2823 19.0291 21.7281 18.8317 22.0993C17.666 24.2914 15.2684 25.1638 13.4141 23.9503C11.1871 22.4929 8.42212 20.0613 6.14952 16.125C3.86102 12.1612 3.43229 8.78778 3.56729 6.40943Z " },
            { FluentSymbol.CallPark48Filled, "M4.53917 12.4856C4.37825 7.13021 9.07787 3.74999 14.0094 3.75H14.1621C16.393 3.75001 18.3803 5.15993 19.1173 7.2656L20.6886 11.7548C21.4596 13.9576 20.6839 16.4049 18.7848 17.7613L16.0182 19.7375C15.2056 20.3179 14.996 21.0809 15.226 21.6406C16.233 24.0907 18.5268 27.3992 20.3856 29.3157C20.8394 29.7836 21.6103 29.9449 22.4557 29.6349L25.4143 28.5501C27.503 27.7842 29.8477 28.418 31.2662 30.1319L33.6807 33.0494C35.0874 34.7491 35.2595 37.1546 34.109 39.0372C31.4721 43.3521 25.9585 45.4885 21.4654 42.4141C17.6796 39.8237 13.0588 35.6817 9.41755 29.375C5.74801 23.0192 4.67456 16.9911 4.53917 12.4856Z M29.25 4.00003C28.5596 4.00003 28 4.55968 28 5.25003V22.75C28 23.4404 28.5596 24 29.25 24C29.9403 24 30.5 23.4404 30.5 22.75V16.5H35.75C39.2017 16.5 42 13.7018 42 10.25C42 6.79825 39.2017 4.00003 35.75 4.00003H29.25ZM35.75 14H30.5V6.50003H35.75C37.821 6.50003 39.5 8.17897 39.5 10.25C39.5 12.3211 37.821 14 35.75 14Z " },
            { FluentSymbol.CallPark48, "M14.0094 3.75C9.07787 3.74999 4.37825 7.13021 4.53917 12.4856C4.67456 16.9911 5.74801 23.0192 9.41755 29.375C13.0588 35.6817 17.6796 39.8237 21.4654 42.4141C25.9585 45.4885 31.4721 43.3521 34.109 39.0372C35.2595 37.1546 35.0874 34.7491 33.6807 33.0494L31.0418 29.8608C29.7721 28.3266 27.7437 27.6429 25.8043 28.0954L22.3827 28.8938C21.6147 29.073 20.9673 28.9028 20.5842 28.5167C18.8896 26.8089 16.9503 23.8402 16.1266 21.5335C15.932 20.9887 16.1349 20.2648 16.8454 19.6727L19.1692 17.7363C20.8515 16.3344 21.4869 14.0356 20.7635 11.9687L19.1173 7.2656C18.3803 5.15993 16.393 3.75001 14.1621 3.75H14.0094ZM7.03805 12.4105C6.93172 8.87223 10.0433 6.24999 14.0094 6.25L14.1621 6.25C15.3307 6.25 16.3716 6.98853 16.7577 8.09151L18.4038 12.7946C18.7828 13.8772 18.4499 15.0814 17.5687 15.8157L15.245 17.7521C14.0113 18.7802 13.1156 20.5357 13.7722 22.3742C14.7294 25.055 16.8788 28.3317 18.8095 30.2776C19.9662 31.4433 21.5899 31.646 22.9508 31.3284L26.3724 30.53C27.3883 30.293 28.4508 30.6511 29.1159 31.4547L31.7548 34.6433C32.4807 35.5206 32.5695 36.762 31.9758 37.7336C29.8755 41.1704 25.8815 42.4066 22.8772 40.3509C19.3317 37.9249 14.9993 34.0428 11.5826 28.125C8.15704 22.1917 7.16347 16.5843 7.03805 12.4105Z M29.25 4.00003C28.5596 4.00003 28 4.55968 28 5.25003V22.75C28 23.4404 28.5596 24 29.25 24C29.9403 24 30.5 23.4404 30.5 22.75V16.5H35.75C39.2017 16.5 42 13.7018 42 10.25C42 6.79825 39.2017 4.00003 35.75 4.00003H29.25ZM35.75 14H30.5V6.50003H35.75C37.821 6.50003 39.5 8.17897 39.5 10.25C39.5 12.3211 37.821 14 35.75 14Z " },
            { FluentSymbol.CallPark20Filled, "M3.55101 2.443C4.40494 1.96522 5.49406 1.85299 6.53544 2.1168C7.04218 2.24518 7.47512 2.57372 7.73513 3.02722L8.6329 4.59308C9.29786 5.75287 8.9327 7.23055 7.80407 7.94711L7.01425 8.44857C6.68733 8.65613 6.56745 8.97267 6.64244 9.22429C6.90993 10.1217 7.50308 11.1185 8.15518 11.8005C8.34925 12.0035 8.7045 12.0522 9.05289 11.8489L9.4899 11.594C10.6974 10.8897 12.2478 11.3123 12.9308 12.532L13.7345 13.9672C13.9975 14.4368 14.0415 14.9981 13.8548 15.503C13.4838 16.506 12.7694 17.3145 11.8903 17.7196C10.9973 18.1311 9.95159 18.1144 9.0056 17.4834C7.50831 16.4846 5.70298 14.8048 4.06815 12.0023C2.41207 9.1633 1.99456 6.74577 2.04156 4.94442C2.07166 3.79051 2.68184 2.9293 3.55101 2.443Z M12.5 2.00032C12.2238 2.00032 12 2.22418 12 2.50032V9.50032C12 9.77647 12.2238 10.0003 12.5 10.0003C12.7761 10.0003 13 9.77647 13 9.50032V7.00032H14.5C15.8807 7.00032 17 5.88103 17 4.50032C17 3.11961 15.8807 2.00032 14.5 2.00032H12.5ZM14.5 6.00032H13V3.00032H14.5C15.3284 3.00032 16 3.6719 16 4.50032C16 5.32875 15.3284 6.00032 14.5 6.00032Z " },
            { FluentSymbol.CallPark20, "M6.53544 2.1168C5.49406 1.85299 4.40494 1.96522 3.55101 2.443C2.68184 2.9293 2.07166 3.79051 2.04156 4.94442C1.99456 6.74577 2.41207 9.1633 4.06815 12.0023C5.70298 14.8048 7.50831 16.4846 9.0056 17.4834C9.95159 18.1144 10.9973 18.1311 11.8903 17.7196C12.7694 17.3145 13.4838 16.506 13.8548 15.503C14.0415 14.9981 13.9975 14.4368 13.7345 13.9672L12.781 12.2645C12.1747 11.1817 10.8657 10.7076 9.70661 11.151L9.04092 11.4056C8.71835 11.529 8.42164 11.4721 8.25304 11.3065C7.68784 10.7514 7.28407 9.9976 7.10089 9.18557C7.04329 8.93022 7.1603 8.62828 7.44299 8.41494L8.04412 7.9613C9.04934 7.20269 9.33337 5.81481 8.70699 4.72229L7.73513 3.02722C7.47512 2.57372 7.04218 2.24518 6.53544 2.1168ZM3.04122 4.97051C3.06139 4.19743 3.45254 3.64397 4.03928 3.31569C4.64126 2.97888 5.46263 2.87662 6.28987 3.08618C6.5339 3.148 6.74239 3.30622 6.8676 3.52461L7.83946 5.21969C8.21529 5.8752 8.04487 6.70792 7.44174 7.16309L6.84061 7.61673C6.32141 8.00856 5.96194 8.68096 6.1254 9.40562C6.34709 10.3884 6.83828 11.3187 7.55233 12.02C8.0737 12.5321 8.8175 12.5617 9.39819 12.3396L10.0639 12.085C10.7594 11.8189 11.5447 12.1034 11.9085 12.7531L12.862 14.4558C12.982 14.6699 13.002 14.9259 12.9169 15.1561C12.6267 15.9407 12.0825 16.53 11.4718 16.8114C10.8752 17.0863 10.2001 17.0781 9.56054 16.6515C8.18976 15.7371 6.49007 14.1695 4.93193 11.4984C3.36852 8.81828 2.99912 6.58401 3.04122 4.97051Z M12.5 2.00032C12.2238 2.00032 12 2.22418 12 2.50032V9.50032C12 9.77647 12.2238 10.0003 12.5 10.0003C12.7761 10.0003 13 9.77647 13 9.50032V7.00032H14.5C15.8807 7.00032 17 5.88103 17 4.50032C17 3.11961 15.8807 2.00032 14.5 2.00032H12.5ZM14.5 6.00032H13V3.00032H14.5C15.3284 3.00032 16 3.6719 16 4.50032C16 5.32875 15.3284 6.00032 14.5 6.00032Z " },
            { FluentSymbol.CallPark24Filled, "M9.36712 3.31256L10.2269 5.33991C10.6015 6.22336 10.3936 7.26227 9.71288 7.9084L7.81856 9.70641C7.93545 10.7819 8.29696 11.8409 8.90309 12.8834C9.50923 13.9259 10.2663 14.7907 11.1742 15.4778L13.4494 14.7191C14.3118 14.4315 15.2509 14.762 15.7799 15.5392L17.0123 17.3498C17.6272 18.2532 17.5166 19.4995 16.7536 20.2655L15.9359 21.0865C15.122 21.9036 13.9594 22.2 12.884 21.8645C10.3452 21.0726 8.01085 18.7214 5.88107 14.8109C3.7482 10.8947 2.99546 7.57214 3.62283 4.84313C3.88682 3.69482 4.70434 2.78033 5.77184 2.43923L6.84843 2.09522C7.85725 1.77287 8.9351 2.29382 9.36712 3.31256ZM14.7501 2H17.2461C19.6357 2 21.0001 3.13553 21.0001 5.25C21.0001 7.29435 19.7246 8.42259 17.4816 8.49312L17.2461 8.49664L15.5001 8.4966V11.2561C15.5001 11.6703 15.1643 12.0061 14.7501 12.0061C14.3704 12.0061 14.0566 11.724 14.0069 11.3579L14.0001 11.2561V2.75C14.0001 2.3703 14.2822 2.05651 14.6483 2.00685L14.7501 2H17.2461H14.7501ZM17.2461 3.5H15.5001V6.99668L17.247 6.99664C18.8624 6.99845 19.5001 6.46849 19.5001 5.25C19.5001 4.08192 18.914 3.54545 17.443 3.50278L17.2461 3.5Z " },
            { FluentSymbol.CallPark24, "M9.52531 3.5721L10.427 5.57782C10.9097 6.65165 10.6553 7.91366 9.79427 8.71661L8.29997 10.1101C8.25629 10.1508 8.22864 10.2058 8.22201 10.2652C8.17765 10.6623 8.44688 11.4357 9.06715 12.51C9.5182 13.2913 9.92644 13.8391 10.2739 14.1473C10.516 14.362 10.6493 14.4084 10.7061 14.3915L12.7164 13.7769C13.842 13.4328 15.0618 13.8431 15.7505 14.7976L17.0312 16.5726C17.8373 17.6898 17.6924 19.2311 16.6921 20.1784L15.8057 21.0178C14.8493 21.9236 13.4877 22.2611 12.219 21.907C9.4649 21.1383 6.99559 18.8141 4.78372 14.9831C2.56877 11.1467 1.79158 7.84222 2.50803 5.07043C2.8359 3.80195 3.80203 2.79656 5.05646 2.41844L6.22346 2.06668C7.54596 1.66804 8.95896 2.31227 9.52531 3.5721ZM6.65636 3.50285L5.48936 3.85461C4.7367 4.08148 4.15702 4.68472 3.9603 5.44581C3.35765 7.77732 4.04651 10.7062 6.08276 14.2331C8.11629 17.7552 10.3052 19.8155 12.6223 20.4622C13.3835 20.6747 14.2004 20.4722 14.7743 19.9287L15.6606 19.0893C16.1153 18.6587 16.1812 17.9581 15.8148 17.4503L14.5341 15.6753C14.221 15.2415 13.6666 15.0549 13.1549 15.2114L11.1396 15.8275C9.96987 16.1762 8.9082 15.2347 7.76811 13.26C6.9998 11.9293 6.64171 10.9006 6.73128 10.0987C6.77768 9.68322 6.97125 9.29812 7.27697 9.01303L8.77127 7.61958C9.16266 7.2546 9.27829 6.68096 9.05887 6.19286L8.1572 4.18714C7.89977 3.61449 7.25749 3.32165 6.65636 3.50285ZM14.7499 2.00042H17.2459C19.6354 2.00042 20.9999 3.13595 20.9999 5.25042C20.9999 7.29477 19.7244 8.42301 17.4814 8.49354L17.2459 8.49706L15.4999 8.49703V11.2565C15.4999 11.6707 15.1641 12.0065 14.7499 12.0065C14.3702 12.0065 14.0564 11.7244 14.0067 11.3583L13.9999 11.2565V2.75042C13.9999 2.37072 14.282 2.05693 14.6481 2.00727L14.7499 2.00042H17.2459H14.7499ZM17.2459 3.50042H15.4999V6.9971L17.2468 6.99706C18.8622 6.99887 19.4999 6.46891 19.4999 5.25042C19.4999 4.08234 18.9138 3.54588 17.4428 3.5032L17.2459 3.50042Z " },
            { FluentSymbol.CalligraphyPen20, "M6 2.5C6 2.22386 5.77614 2 5.5 2C5.22386 2 5 2.22386 5 2.5V4.5C5 5.32843 5.67157 6 6.5 6H6.70989L5.25073 9.08046C4.89676 9.82771 4.93517 10.7016 5.35333 11.415L8.81578 17.3215C9.06215 17.7418 9.51282 18 9.99999 18C10.4872 18 10.9378 17.7418 11.1842 17.3215L14.6467 11.415C15.0648 10.7016 15.1032 9.82771 14.7493 9.08046L13.2901 6H13.5C14.3284 6 15 5.32843 15 4.5V2.5C15 2.22386 14.7761 2 14.5 2C14.2239 2 14 2.22386 14 2.5V4.5C14 4.77614 13.7761 5 13.5 5H6.5C6.22386 5 6 4.77614 6 4.5V2.5ZM12.1836 6L13.8455 9.50854C14.0579 9.9569 14.0348 10.4813 13.784 10.9093L10.5 16.5113V10.8662C10.7989 10.6933 11 10.3701 11 10C11 9.44772 10.5523 9 10 9C9.44772 9 9 9.44772 9 10C9 10.3701 9.2011 10.6933 9.5 10.8662V16.5113L6.21603 10.9093C5.96513 10.4813 5.94209 9.9569 6.15447 9.50854L7.81641 6H12.1836Z " },
            { FluentSymbol.CalligraphyPen20Filled, "M6 2.5C6 2.22386 5.77614 2 5.5 2C5.22386 2 5 2.22386 5 2.5V4.5C5 5.32843 5.67157 6 6.5 6L6.69982 6L5.24066 9.08045C4.88669 9.82771 4.9251 10.7016 5.34326 11.415L8.80571 17.3215C8.96604 17.595 9.21288 17.7999 9.5 17.9096V10.8662C9.2011 10.6933 9 10.3701 9 10C9 9.44772 9.44772 9 10 9C10.5523 9 11 9.44772 11 10C11 10.3701 10.7989 10.6933 10.5 10.8662V17.9017C10.7785 17.7902 11.0176 17.5886 11.1741 17.3215L14.6366 11.415C15.0547 10.7016 15.0931 9.82771 14.7392 9.08045L13.28 6L13.5 6C14.3284 6 15 5.32843 15 4.5V2.5C15 2.22386 14.7761 2 14.5 2C14.2239 2 14 2.22386 14 2.5V4.5C14 4.77614 13.7761 5 13.5 5H6.5C6.22386 5 6 4.77614 6 4.5V2.5Z " },
            { FluentSymbol.CalligraphyPen24Filled, "M7.5 2.75C7.5 2.33579 7.16421 2 6.75 2C6.33579 2 6 2.33579 6 2.75V5.75C6 6.64648 6.67409 7.38552 7.54305 7.48789L6.52732 9.99292C6.11943 10.9988 6.16369 12.1753 6.64554 13.1355L10.6354 21.0866C10.7846 21.384 10.9988 21.621 11.25 21.7791V12.2993C10.8016 12.04 10.5 11.5552 10.5 11C10.5 10.1716 11.1716 9.5 12 9.5C12.8284 9.5 13.5 10.1716 13.5 11C13.5 11.5552 13.1984 12.04 12.75 12.2993V21.7791C13.0012 21.621 13.2154 21.384 13.3646 21.0866L17.3545 13.1355C17.8363 12.1753 17.8806 10.9988 17.4727 9.99292L16.4569 7.48789C17.3259 7.38552 18 6.64648 18 5.75V2.75C18 2.33579 17.6642 2 17.25 2C16.8358 2 16.5 2.33579 16.5 2.75V5.75C16.5 5.88807 16.3881 6 16.25 6H7.75C7.61193 6 7.5 5.88807 7.5 5.75V2.75Z " },
            { FluentSymbol.CalligraphyPen24, "M7.5 2.75C7.5 2.33579 7.16421 2 6.75 2C6.33579 2 6 2.33579 6 2.75V5.75C6 6.64648 6.67409 7.38552 7.54305 7.48789L6.52732 9.99292C6.11943 10.9988 6.16369 12.1753 6.64554 13.1355L10.6354 21.0866C10.9193 21.6524 11.4386 22 12 22C12.5614 22 13.0807 21.6524 13.3646 21.0866L17.3545 13.1355C17.8363 12.1753 17.8806 10.9988 17.4727 9.99292L16.4569 7.48789C17.3259 7.38552 18 6.64648 18 5.75V2.75C18 2.33579 17.6642 2 17.25 2C16.8358 2 16.5 2.33579 16.5 2.75V5.75C16.5 5.88807 16.3881 6 16.25 6H7.75C7.61193 6 7.5 5.88807 7.5 5.75V2.75ZM14.8432 7.5L16.0826 10.5566C16.3302 11.1672 16.2997 11.8929 16.0138 12.4628L12.75 18.9669V12.2993C13.1984 12.04 13.5 11.5552 13.5 11C13.5 10.1716 12.8284 9.5 12 9.5C11.1716 9.5 10.5 10.1716 10.5 11C10.5 11.5552 10.8016 12.04 11.25 12.2993V18.9669L7.98622 12.4628C7.70026 11.8929 7.66979 11.1672 7.91739 10.5566L9.15676 7.5H14.8432Z " },
            { FluentSymbol.Camera16Filled, "M10 8C10 9.10457 9.10457 10 8 10C6.89543 10 6 9.10457 6 8C6 6.89543 6.89543 6 8 6C9.10457 6 10 6.89543 10 8ZM5.27639 2.82918C5.53048 2.321 6.04988 2 6.61803 2H9.38197C9.95012 2 10.4695 2.321 10.7236 2.82918L11.309 4H12C13.1046 4 14 4.89543 14 6V11C14 12.1046 13.1046 13 12 13H4C2.89543 13 2 12.1046 2 11V6C2 4.89543 2.89543 4 4 4H4.69098L5.27639 2.82918ZM11 8C11 6.34315 9.65685 5 8 5C6.34315 5 5 6.34315 5 8C5 9.65685 6.34315 11 8 11C9.65685 11 11 9.65685 11 8Z " },
            { FluentSymbol.Camera16, "M11 8C11 9.65685 9.65685 11 8 11C6.34315 11 5 9.65685 5 8C5 6.34315 6.34315 5 8 5C9.65685 5 11 6.34315 11 8ZM10 8C10 6.89543 9.10457 6 8 6C6.89543 6 6 6.89543 6 8C6 9.10457 6.89543 10 8 10C9.10457 10 10 9.10457 10 8ZM6.61803 2C6.04988 2 5.53048 2.321 5.27639 2.82918L4.69098 4H4C2.89543 4 2 4.89543 2 6V11C2 12.1046 2.89543 13 4 13H12C13.1046 13 14 12.1046 14 11V6C14 4.89543 13.1046 4 12 4H11.309L10.7236 2.82918C10.4695 2.321 9.95012 2 9.38197 2H6.61803ZM6.17082 3.27639C6.25552 3.107 6.42865 3 6.61803 3H9.38197C9.57135 3 9.74448 3.107 9.82918 3.27639L10.5528 4.72361C10.6375 4.893 10.8106 5 11 5H12C12.5523 5 13 5.44772 13 6V11C13 11.5523 12.5523 12 12 12H4C3.44772 12 3 11.5523 3 11V6C3 5.44772 3.44772 5 4 5H5C5.18939 5 5.36252 4.893 5.44721 4.72361L6.17082 3.27639Z " },
            { FluentSymbol.Camera20Filled, "M6.99994 10C6.99994 8.34315 8.34308 7 9.99994 7C11.6568 7 12.9999 8.34315 12.9999 10C12.9999 11.6569 11.6568 13 9.99994 13C8.34308 13 6.99994 11.6569 6.99994 10Z M6.78361 2.82643C7.03824 2.31977 7.55682 2 8.12387 2H11.8881C12.4563 2 12.9757 2.32106 13.2298 2.8293L13.8147 3.9994H15.5046C16.8854 3.9994 18.0046 5.11869 18.0046 6.4994V14.5C18.0046 15.8807 16.8854 17 15.5046 17H4.50464C3.12393 17 2.00464 15.8807 2.00464 14.5V6.4994C2.00464 5.11868 3.12393 3.9994 4.50464 3.9994H6.19412L6.78361 2.82643ZM9.99994 6C7.7908 6 5.99994 7.79086 5.99994 10C5.99994 12.2091 7.7908 14 9.99994 14C12.2091 14 13.9999 12.2091 13.9999 10C13.9999 7.79086 12.2091 6 9.99994 6Z " },
            { FluentSymbol.Camera20, "M9.99994 6.00003C7.7908 6.00003 5.99994 7.79089 5.99994 10C5.99994 12.2092 7.7908 14 9.99994 14C12.2091 14 13.9999 12.2092 13.9999 10C13.9999 7.79089 12.2091 6.00003 9.99994 6.00003ZM6.99994 10C6.99994 8.34318 8.34308 7.00003 9.99994 7.00003C11.6568 7.00003 12.9999 8.34318 12.9999 10C12.9999 11.6569 11.6568 13 9.99994 13C8.34308 13 6.99994 11.6569 6.99994 10Z M8.12387 2C7.55682 2 7.03824 2.31977 6.78361 2.82643L6.19412 3.9994H4.50464C3.12393 3.9994 2.00464 5.11868 2.00464 6.4994V14.5C2.00464 15.8807 3.12393 17 4.50464 17H15.5046C16.8854 17 18.0046 15.8807 18.0046 14.5V6.4994C18.0046 5.11869 16.8854 3.9994 15.5046 3.9994H13.8147L13.2298 2.8293C12.9757 2.32106 12.4563 2 11.8881 2H8.12387ZM7.67712 3.27548C7.762 3.10659 7.93486 3 8.12387 3H11.8881C12.0775 3 12.2506 3.10702 12.3353 3.27643L13.0584 4.72296C13.1431 4.89238 13.3162 4.9994 13.5056 4.9994H15.5046C16.3331 4.9994 17.0046 5.67097 17.0046 6.4994V14.5C17.0046 15.3284 16.3331 16 15.5046 16H4.50464C3.67621 16 3.00464 15.3284 3.00464 14.5V6.4994C3.00464 5.67097 3.67621 4.9994 4.50464 4.9994H6.50243C6.69145 4.9994 6.86431 4.89281 6.94919 4.72392L7.67712 3.27548Z " },
            { FluentSymbol.Camera24Filled, "M13.9247 2.50293C14.7225 2.50293 15.4607 2.9254 15.8647 3.6133L16.6793 4.99988H18.75C20.5449 4.99988 22 6.45496 22 8.24988V17.7499C22 19.5448 20.5449 20.9999 18.75 20.9999H5.25C3.45507 20.9999 2 19.5448 2 17.7499V8.24988C2 6.45496 3.45507 4.99988 5.25 4.99988H7.33042L8.205 3.57558C8.61425 2.90908 9.34026 2.50293 10.1224 2.50293H13.9247ZM12 7.99988C9.51472 7.99988 7.5 10.0146 7.5 12.4999C7.5 14.9852 9.51472 16.9999 12 16.9999C14.4853 16.9999 16.5 14.9852 16.5 12.4999C16.5 10.0146 14.4853 7.99988 12 7.99988ZM12 9.49988C13.6569 9.49988 15 10.843 15 12.4999C15 14.1567 13.6569 15.4999 12 15.4999C10.3431 15.4999 9 14.1567 9 12.4999C9 10.843 10.3431 9.49988 12 9.49988Z " },
            { FluentSymbol.Camera24, "M13.9247 2.50293C14.7225 2.50293 15.4607 2.9254 15.8647 3.6133L16.6793 4.99988H18.75C20.5449 4.99988 22 6.45496 22 8.24988V17.7499C22 19.5448 20.5449 20.9999 18.75 20.9999H5.25C3.45507 20.9999 2 19.5448 2 17.7499V8.24988C2 6.45496 3.45507 4.99988 5.25 4.99988H7.33042L8.205 3.57558C8.61425 2.90908 9.34026 2.50293 10.1224 2.50293H13.9247ZM13.9247 4.00293H10.1224C9.89892 4.00293 9.6892 4.1024 9.54793 4.27072L9.48325 4.36048L8.38913 6.14233C8.25271 6.3645 8.01071 6.49988 7.75 6.49988H5.25C4.2835 6.49988 3.5 7.28338 3.5 8.24988V17.7499C3.5 18.7164 4.2835 19.4999 5.25 19.4999H18.75C19.7165 19.4999 20.5 18.7164 20.5 17.7499V8.24988C20.5 7.28338 19.7165 6.49988 18.75 6.49988H16.25C15.9841 6.49988 15.738 6.35906 15.6033 6.12976L14.5714 4.37305C14.4367 4.14375 14.1906 4.00293 13.9247 4.00293ZM12 7.99988C14.4853 7.99988 16.5 10.0146 16.5 12.4999C16.5 14.9852 14.4853 16.9999 12 16.9999C9.51472 16.9999 7.5 14.9852 7.5 12.4999C7.5 10.0146 9.51472 7.99988 12 7.99988ZM12 9.49988C10.3431 9.49988 9 10.843 9 12.4999C9 14.1567 10.3431 15.4999 12 15.4999C13.6569 15.4999 15 14.1567 15 12.4999C15 10.843 13.6569 9.49988 12 9.49988Z " },
            { FluentSymbol.Camera28Filled, "M16.9511 2.50293C17.7275 2.50293 18.449 2.90322 18.86 3.56194L20.3811 5.99988H22.75C24.5449 5.99988 26 7.45496 26 9.24988V21.7499C26 23.5448 24.5449 24.9999 22.75 24.9999H5.25C3.45507 24.9999 2 23.5448 2 21.7499V9.24988C2 7.45496 3.45507 5.99988 5.25 5.99988H7.81851L9.20109 3.62199C9.6039 2.92919 10.3448 2.50293 11.1462 2.50293H16.9511ZM14 9.50257C10.9624 9.50257 8.5 11.965 8.5 15.0026C8.5 18.0401 10.9624 20.5026 14 20.5026C17.0376 20.5026 19.5 18.0401 19.5 15.0026C19.5 11.965 17.0376 9.50257 14 9.50257ZM14 11.0026C16.2091 11.0026 18 12.7934 18 15.0026C18 17.2117 16.2091 19.0026 14 19.0026C11.7909 19.0026 10 17.2117 10 15.0026C10 12.7934 11.7909 11.0026 14 11.0026Z " },
            { FluentSymbol.Camera28, "M16.9511 2.50293C17.7275 2.50293 18.449 2.90322 18.86 3.56194L20.3811 5.99988H22.75C24.5449 5.99988 26 7.45496 26 9.24988V21.7499C26 23.5448 24.5449 24.9999 22.75 24.9999H5.25C3.45507 24.9999 2 23.5448 2 21.7499V9.24988C2 7.45496 3.45507 5.99988 5.25 5.99988H7.81851L9.20109 3.62199C9.6039 2.92919 10.3448 2.50293 11.1462 2.50293H16.9511ZM16.9511 4.00293H11.1462C10.9172 4.00293 10.7031 4.10732 10.562 4.28257L10.4978 4.37595L8.89837 7.12686C8.7641 7.3578 8.51713 7.49988 8.25 7.49988H5.25C4.2835 7.49988 3.5 8.28338 3.5 9.24988V21.7499C3.5 22.7164 4.2835 23.4999 5.25 23.4999H22.75C23.7165 23.4999 24.5 22.7164 24.5 21.7499V9.24988C24.5 8.28338 23.7165 7.49988 22.75 7.49988H19.965C19.7062 7.49988 19.4657 7.36645 19.3287 7.14688L17.5874 4.35593C17.4504 4.13636 17.2099 4.00293 16.9511 4.00293ZM14 9.50087C17.0376 9.50087 19.5 11.9633 19.5 15.0009C19.5 18.0384 17.0376 20.5009 14 20.5009C10.9624 20.5009 8.5 18.0384 8.5 15.0009C8.5 11.9633 10.9624 9.50087 14 9.50087ZM14 11.0009C11.7909 11.0009 10 12.7917 10 15.0009C10 17.21 11.7909 19.0009 14 19.0009C16.2091 19.0009 18 17.21 18 15.0009C18 12.7917 16.2091 11.0009 14 11.0009Z " },
            { FluentSymbol.CameraAdd48Filled, "M16.8 9.18602C17.5496 7.83679 18.9717 7 20.5152 7H27.4848C29.0283 7 30.4504 7.83679 31.2 9.18602L32.4855 11.5H36.25C39.4256 11.5 42 14.0744 42 17.25V24.0436C39.9794 22.75 37.5773 22 35 22C33.8186 22 32.6739 22.1576 31.586 22.4529C30.5222 19.2834 27.5278 17 24 17C19.5817 17 16 20.5817 16 25C16 28.7945 18.6418 31.972 22.1865 32.7936C22.0639 33.5107 22 34.2479 22 35C22 36.7718 22.3545 38.4608 22.9963 40H11.75C8.57436 40 6 37.4256 6 34.25V17.25C6 14.0744 8.57436 11.5 11.75 11.5H15.5145L16.8 9.18602Z M24 19.5C20.9624 19.5 18.5 21.9624 18.5 25C18.5 27.6415 20.3622 29.8481 22.8454 30.3786C24.0153 27.3035 26.3187 24.7871 29.2451 23.34C28.5411 21.1138 26.459 19.5 24 19.5Z M35 46C41.0751 46 46 41.0751 46 35C46 28.9249 41.0751 24 35 24C28.9249 24 24 28.9249 24 35C24 41.0751 28.9249 46 35 46ZM35 28C35.5523 28 36 28.4477 36 29V34H41C41.5523 34 42 34.4477 42 35C42 35.5523 41.5523 36 41 36H36V41C36 41.5523 35.5523 42 35 42C34.4477 42 34 41.5523 34 41V36H29C28.4477 36 28 35.5523 28 35C28 34.4477 28.4477 34 29 34H34V29C34 28.4477 34.4477 28 35 28Z " },
            { FluentSymbol.CameraAdd48, "M20.5152 7C18.9718 7 17.5496 7.83679 16.8 9.18602L15.5145 11.5H11.75C8.57436 11.5 6 14.0744 6 17.25V34.25C6 37.4256 8.57436 40 11.75 40H22.9963C22.6642 39.2037 22.4091 38.3672 22.2402 37.5H11.75C9.95507 37.5 8.5 36.0449 8.5 34.25V17.25C8.5 15.4551 9.95507 14 11.75 14H16.9855L18.9854 10.4001C19.2941 9.84456 19.8797 9.5 20.5152 9.5H27.4848C28.1203 9.5 28.7059 9.84456 29.0146 10.4001L31.0145 14H36.25C38.0449 14 39.5 15.4551 39.5 17.25V22.7999C40.3823 23.1255 41.2196 23.544 42 24.0436V17.25C42 14.0744 39.4256 11.5 36.25 11.5H32.4855L31.2 9.18602C30.4504 7.83679 29.0282 7 27.4848 7H20.5152Z M24 17C27.5278 17 30.5222 19.2834 31.586 22.4529C30.7711 22.6741 29.988 22.9726 29.2451 23.34C28.5411 21.1138 26.459 19.5 24 19.5C20.9624 19.5 18.5 21.9624 18.5 25C18.5 27.6415 20.3622 29.8481 22.8454 30.3786C22.5516 31.151 22.3292 31.9587 22.1865 32.7936C18.6418 31.972 16 28.7945 16 25C16 20.5817 19.5817 17 24 17Z M46 35C46 41.0751 41.0751 46 35 46C28.9249 46 24 41.0751 24 35C24 28.9249 28.9249 24 35 24C41.0751 24 46 28.9249 46 35ZM36 29C36 28.4477 35.5523 28 35 28C34.4477 28 34 28.4477 34 29V34H29C28.4477 34 28 34.4477 28 35C28 35.5523 28.4477 36 29 36H34V41C34 41.5523 34.4477 42 35 42C35.5523 42 36 41.5523 36 41V36H41C41.5523 36 42 35.5523 42 35C42 34.4477 41.5523 34 41 34H36V29Z " },
            { FluentSymbol.CameraAdd20Filled, "M6.78386 2.82643C7.03849 2.31977 7.55707 2 8.12412 2H11.8883C12.4565 2 12.976 2.32106 13.23 2.8293L13.8149 3.9994H15.5049C16.8856 3.9994 18.0049 5.11869 18.0049 6.4994V10.261C17.0533 9.47337 15.832 9 14.5002 9C14.2915 9 14.0855 9.01163 13.8828 9.03426C13.4508 7.29168 11.8763 6 10.0002 6C7.79104 6 6.00018 7.79086 6.00018 10C6.00018 11.8762 7.29186 13.4506 9.03445 13.8826C9.01181 14.0853 9.00018 14.2913 9.00018 14.5C9.00018 15.4002 9.21646 16.2499 9.59989 17H4.50488C3.12417 17 2.00488 15.8807 2.00488 14.5V6.4994C2.00488 5.11868 3.12417 3.9994 4.50488 3.9994H6.19437L6.78386 2.82643Z M10.0002 7C11.3929 7 12.564 7.94909 12.902 9.23581C11.1496 9.76712 9.7673 11.1495 9.23599 12.9018C7.94928 12.5639 7.00018 11.3928 7.00018 10C7.00018 8.34315 8.34333 7 10.0002 7Z M19.0002 14.5C19.0002 16.9853 16.9855 19 14.5002 19C12.0149 19 10.0002 16.9853 10.0002 14.5C10.0002 12.0147 12.0149 10 14.5002 10C16.9855 10 19.0002 12.0147 19.0002 14.5ZM15.0002 12.5C15.0002 12.2239 14.7763 12 14.5002 12C14.224 12 14.0002 12.2239 14.0002 12.5V14H12.5002C12.224 14 12.0002 14.2239 12.0002 14.5C12.0002 14.7761 12.224 15 12.5002 15H14.0002V16.5C14.0002 16.7761 14.224 17 14.5002 17C14.7763 17 15.0002 16.7761 15.0002 16.5V15H16.5002C16.7763 15 17.0002 14.7761 17.0002 14.5C17.0002 14.2239 16.7763 14 16.5002 14H15.0002V12.5Z " },
            { FluentSymbol.CameraAdd20, "M8.12412 2C7.55707 2 7.03849 2.31977 6.78386 2.82643L6.19437 3.9994H4.50488C3.12417 3.9994 2.00488 5.11868 2.00488 6.4994V14.5C2.00488 15.8807 3.12417 17 4.50488 17H9.59989C9.43795 16.6832 9.30582 16.3486 9.20722 16H4.50488C3.67646 16 3.00488 15.3284 3.00488 14.5V6.4994C3.00488 5.67097 3.67646 4.9994 4.50488 4.9994H6.50268C6.69169 4.9994 6.86455 4.89281 6.94943 4.72392L7.67736 3.27548C7.76224 3.10659 7.9351 3 8.12412 3H11.8883C12.0777 3 12.2509 3.10702 12.3356 3.27643L13.0587 4.72296C13.1433 4.89238 13.3165 4.9994 13.5059 4.9994H15.5049C16.3333 4.9994 17.0049 5.67097 17.0049 6.4994V9.60212C17.3627 9.78548 17.6978 10.0069 18.0049 10.261V6.4994C18.0049 5.11869 16.8856 3.9994 15.5049 3.9994H13.8149L13.23 2.8293C12.976 2.32106 12.4565 2 11.8883 2H8.12412Z M10.0002 6.00003C11.8763 6.00003 13.4508 7.29169 13.8828 9.03426C13.5457 9.07192 13.2178 9.14004 12.902 9.23581C12.564 7.94911 11.3929 7.00003 10.0002 7.00003C8.34333 7.00003 7.00018 8.34318 7.00018 10C7.00018 11.3928 7.94927 12.5639 9.23598 12.9018C9.14021 13.2177 9.07209 13.5456 9.03444 13.8827C7.29186 13.4507 6.00018 11.8762 6.00018 10C6.00018 7.79089 7.79104 6.00003 10.0002 6.00003Z M19.0002 14.5C19.0002 16.9853 16.9855 19 14.5002 19C12.0149 19 10.0002 16.9853 10.0002 14.5C10.0002 12.0147 12.0149 10 14.5002 10C16.9855 10 19.0002 12.0147 19.0002 14.5ZM15.0002 12.5C15.0002 12.2239 14.7763 12 14.5002 12C14.224 12 14.0002 12.2239 14.0002 12.5V14H12.5002C12.224 14 12.0002 14.2239 12.0002 14.5C12.0002 14.7761 12.224 15 12.5002 15H14.0002V16.5C14.0002 16.7761 14.224 17 14.5002 17C14.7763 17 15.0002 16.7761 15.0002 16.5V15H16.5002C16.7763 15 17.0002 14.7761 17.0002 14.5C17.0002 14.2239 16.7763 14 16.5002 14H15.0002V12.5Z " },
            { FluentSymbol.CameraAdd24Filled, "M17.5 11.9999C20.5376 11.9999 23 14.4623 23 17.4999C23 20.5374 20.5376 22.9999 17.5 22.9999C14.4624 22.9999 12 20.5374 12 17.4999C12 14.4623 14.4624 11.9999 17.5 11.9999ZM17.5 13.9991L17.4101 14.0072C17.206 14.0442 17.0451 14.2051 17.0081 14.4092L17 14.4991L16.9996 16.9991L14.4977 16.9999L14.4078 17.0079C14.2037 17.045 14.0427 17.2059 14.0057 17.41L13.9977 17.4999L14.0057 17.5898C14.0427 17.7939 14.2037 17.9548 14.4078 17.9918L14.4977 17.9999L17.0007 17.9991L17.0011 20.5034L17.0092 20.5932C17.0462 20.7973 17.2071 20.9583 17.4112 20.9953L17.5011 21.0034L17.591 20.9953C17.7951 20.9583 17.956 20.7973 17.9931 20.5932L18.0011 20.5034L18.0007 17.9991L20.5046 17.9999L20.5944 17.9918C20.7985 17.9548 20.9595 17.7939 20.9965 17.5898L21.0046 17.4999L20.9965 17.41C20.9595 17.2059 20.7985 17.045 20.5944 17.0079L20.5046 16.9999L17.9996 16.9991L18 14.4991L17.9919 14.4092C17.9549 14.2051 17.794 14.0442 17.5899 14.0072L17.5 13.9991ZM13.9247 2.50293C14.7225 2.50293 15.4607 2.9254 15.8647 3.6133L16.6793 4.99988H18.75C20.5449 4.99988 22 6.45496 22 8.24988L22.0008 12.8102C20.8328 11.689 19.2469 10.9999 17.5 10.9999C17.0838 10.9999 16.6767 11.039 16.2822 11.1138C15.6983 9.30693 14.0018 7.99988 12 7.99988C9.51472 7.99988 7.5 10.0146 7.5 12.4999C7.5 14.6514 9.00995 16.4503 11.028 16.8946C11.0094 17.0938 11 17.2958 11 17.4999C11 18.7886 11.375 19.9897 12.0219 21.0001L5.25 20.9999C3.45507 20.9999 2 19.5448 2 17.7499V8.24988C2 6.45496 3.45507 4.99988 5.25 4.99988H7.33042L8.205 3.57558C8.61425 2.90908 9.34026 2.50293 10.1224 2.50293H13.9247ZM12 9.49988C13.3296 9.49988 14.4571 10.3648 14.8507 11.5626C13.203 12.2992 11.9187 13.7003 11.3382 15.425C9.99965 15.1251 9 13.9293 9 12.4999C9 10.843 10.3431 9.49988 12 9.49988Z " },
            { FluentSymbol.CameraAdd24, "M17.5 11.9999C20.5376 11.9999 23 14.4623 23 17.4999C23 20.5374 20.5376 22.9999 17.5 22.9999C14.4624 22.9999 12 20.5374 12 17.4999C12 14.4623 14.4624 11.9999 17.5 11.9999ZM17.5 13.9991L17.4101 14.0072C17.206 14.0442 17.0451 14.2051 17.0081 14.4092L17 14.4991L16.9996 16.9991L14.4977 16.9999L14.4078 17.0079C14.2037 17.045 14.0427 17.2059 14.0057 17.41L13.9977 17.4999L14.0057 17.5898C14.0427 17.7939 14.2037 17.9548 14.4078 17.9918L14.4977 17.9999L17.0007 17.9991L17.0011 20.5034L17.0092 20.5932C17.0462 20.7973 17.2071 20.9583 17.4112 20.9953L17.5011 21.0034L17.591 20.9953C17.7951 20.9583 17.956 20.7973 17.9931 20.5932L18.0011 20.5034L18.0007 17.9991L20.5046 17.9999L20.5944 17.9918C20.7985 17.9548 20.9595 17.7939 20.9965 17.5898L21.0046 17.4999L20.9965 17.41C20.9595 17.2059 20.7985 17.045 20.5944 17.0079L20.5046 16.9999L17.9996 16.9991L18 14.4991L17.9919 14.4092C17.9549 14.2051 17.794 14.0442 17.5899 14.0072L17.5 13.9991ZM13.9247 2.50293C14.7225 2.50293 15.4607 2.9254 15.8647 3.6133L16.6793 4.99988H18.75C20.5449 4.99988 22 6.45496 22 8.24988L22.0008 12.8102C21.5566 12.3838 21.052 12.0199 20.5011 11.7327L20.5 8.24988C20.5 7.28338 19.7165 6.49988 18.75 6.49988H16.25C15.9841 6.49988 15.738 6.35906 15.6033 6.12976L14.5714 4.37305C14.4367 4.14375 14.1906 4.00293 13.9247 4.00293H10.1224C9.89892 4.00293 9.6892 4.1024 9.54793 4.27072L9.48325 4.36048L8.38913 6.14233C8.25271 6.3645 8.01071 6.49988 7.75 6.49988H5.25C4.2835 6.49988 3.5 7.28338 3.5 8.24988V17.7499C3.5 18.7164 4.2835 19.4999 5.25 19.4999L11.3133 19.4993C11.4857 20.0331 11.7252 20.5367 12.0219 21.0001L5.25 20.9999C3.45507 20.9999 2 19.5448 2 17.7499V8.24988C2 6.45496 3.45507 4.99988 5.25 4.99988H7.33042L8.205 3.57558C8.61425 2.90908 9.34026 2.50293 10.1224 2.50293H13.9247ZM12 7.99988C14.0018 7.99988 15.6983 9.30693 16.2826 11.1141C15.7821 11.2086 15.3022 11.3607 14.8497 11.563C14.4571 10.3648 13.3296 9.49988 12 9.49988C10.3431 9.49988 9 10.843 9 12.4999C9 13.9293 9.99965 15.1251 11.338 15.4266C11.1806 15.8933 11.0748 16.3854 11.0278 16.8945C9.00995 16.4503 7.5 14.6514 7.5 12.4999C7.5 10.0146 9.51472 7.99988 12 7.99988Z " },
            { FluentSymbol.CameraEdit20Filled, "M8.12314 2C7.55609 2 7.03751 2.31977 6.78288 2.82643L6.19339 3.9994H4.50391C3.1232 3.9994 2.00391 5.11868 2.00391 6.4994V14.5C2.00391 15.8807 3.12319 17 4.50391 17H8.00383C8.01113 16.8859 8.02893 16.7701 8.05813 16.6533L8.43261 15.1554C8.54882 14.6905 8.76769 14.259 9.07164 13.8919C7.30978 13.4736 5.99921 11.8898 5.99921 10C5.99921 7.79086 7.79007 6 9.99921 6C11.8833 6 13.4631 7.30262 13.8873 9.05638L14.103 8.84065C15.1726 7.77107 16.8763 7.72213 18.0039 8.69382V6.4994C18.0039 5.11869 16.8846 3.9994 15.5039 3.9994H13.814L13.229 2.8293C12.975 2.32106 12.4556 2 11.8873 2H8.12314Z M12.9987 9.94493C12.9693 8.31348 11.6377 7 9.99921 7C8.34235 7 6.99921 8.34315 6.99921 10C6.99921 11.6385 8.31269 12.9701 9.94413 12.9995L12.9987 9.94493Z M14.8092 9.54776L9.97975 14.3772C9.69818 14.6588 9.49842 15.0116 9.40184 15.3979L9.02737 16.8958C8.86451 17.5472 9.45456 18.1372 10.106 17.9744L11.6039 17.5999C11.9902 17.5033 12.343 17.3036 12.6246 17.022L17.454 12.1926C18.1843 11.4622 18.1843 10.2781 17.454 9.54776C16.7237 8.81741 15.5395 8.81741 14.8092 9.54776Z " },
            { FluentSymbol.CameraEdit20, "M6.78288 2.82643C7.03751 2.31977 7.55609 2 8.12314 2H11.8873C12.4556 2 12.975 2.32106 13.229 2.8293L13.814 3.9994H15.5039C16.8846 3.9994 18.0039 5.11869 18.0039 6.4994V8.69467C17.7038 8.43584 17.3629 8.24934 17.0039 8.13516V6.4994C17.0039 5.67097 16.3323 4.9994 15.5039 4.9994H13.5049C13.3155 4.9994 13.1424 4.89238 13.0577 4.72296L12.3346 3.27643C12.2499 3.10702 12.0767 3 11.8873 3H8.12314C7.93413 3 7.76127 3.10659 7.67639 3.27548L6.94845 4.72392C6.86358 4.89281 6.69072 4.9994 6.5017 4.9994H4.50391C3.67548 4.9994 3.00391 5.67097 3.00391 6.4994V14.5C3.00391 15.3284 3.67548 16 4.50391 16H8.22047L8.05716 16.6533C8.02796 16.7701 8.01015 16.8859 8.00286 17H4.50391C3.12319 17 2.00391 15.8807 2.00391 14.5V6.4994C2.00391 5.11868 3.1232 3.9994 4.50391 3.9994H6.19339L6.78288 2.82643Z M13.8871 9.0556C13.4626 7.30225 11.883 6.00003 9.99921 6.00003C7.79007 6.00003 5.99921 7.79089 5.99921 10C5.99921 11.8896 7.30936 13.4731 9.0708 13.8917C9.13439 13.8149 9.2017 13.741 9.27258 13.6701L9.94314 12.9995C8.31216 12.9696 6.99921 11.6382 6.99921 10C6.99921 8.34318 8.34235 7.00003 9.99921 7.00003C11.6373 7.00003 12.9688 8.31298 12.9987 9.94397L13.8871 9.0556Z M14.8092 9.54776L9.97975 14.3772C9.69818 14.6588 9.49842 15.0116 9.40184 15.3979L9.02737 16.8958C8.86451 17.5472 9.45456 18.1372 10.106 17.9744L11.6039 17.5999C11.9902 17.5033 12.343 17.3036 12.6246 17.022L17.454 12.1926C18.1843 11.4622 18.1843 10.2781 17.454 9.54776C16.7237 8.81741 15.5395 8.81741 14.8092 9.54776Z " },
            { FluentSymbol.CameraSwitch24Filled, "M21 7C21.5128 7 21.9355 7.38604 21.9933 7.88338L22 8V16.5C22 18.3686 20.5357 19.8951 18.692 19.9948L18.5 20H6.415L6.70711 20.2929C7.06759 20.6534 7.09532 21.2206 6.7903 21.6129L6.70711 21.7071C6.34662 22.0676 5.77939 22.0953 5.3871 21.7903L5.29289 21.7071L3.29289 19.7071L3.27515 19.6889C3.25325 19.6659 3.23243 19.6418 3.21279 19.6168L3.29289 19.7071C3.2575 19.6717 3.22531 19.6343 3.19633 19.5953C3.17849 19.5711 3.16172 19.5463 3.14607 19.5207C3.13861 19.5086 3.1315 19.4964 3.12467 19.4841C3.11379 19.4643 3.10338 19.4439 3.09365 19.4231C3.08568 19.4061 3.0782 19.3888 3.07123 19.3713C3.06332 19.3516 3.05612 19.3318 3.04955 19.3117C3.04473 19.2969 3.0401 19.2815 3.03585 19.266C3.02983 19.2444 3.02464 19.2227 3.02017 19.2008C3.0167 19.1834 3.01363 19.1659 3.01102 19.1485C3.0081 19.1294 3.00575 19.1097 3.00398 19.0898C3.0019 19.066 3.00063 19.0427 3 19.0194C3 19.0129 3 19.0065 3 19L3.00032 18.9747C3.00086 18.9534 3.00207 18.932 3.00397 18.9107L3 19C3 18.9494 3.00376 18.8996 3.01102 18.851C3.01363 18.834 3.0167 18.8166 3.02024 18.7993C3.02464 18.7773 3.02983 18.7556 3.03572 18.7342C3.0401 18.7185 3.04473 18.7031 3.04974 18.6879C3.05612 18.6682 3.06332 18.6484 3.0711 18.6289C3.0782 18.6112 3.08568 18.5939 3.09367 18.5768C3.10338 18.5561 3.11379 18.5357 3.12488 18.5157C3.1315 18.5036 3.13861 18.4914 3.146 18.4793C3.16172 18.4537 3.17849 18.4289 3.19631 18.4048C3.20072 18.3988 3.20517 18.3929 3.2097 18.3871C3.23767 18.3515 3.26443 18.3214 3.29289 18.2929L5.29289 16.2929C5.68342 15.9024 6.31658 15.9024 6.70711 16.2929C7.06759 16.6534 7.09532 17.2206 6.7903 17.6129L6.70711 17.7071L6.414 18H18.5C19.2797 18 19.9204 17.4051 19.9931 16.6445L20 16.5V8C20 7.44772 20.4477 7 21 7ZM18.6129 2.2097L18.7071 2.29289L20.7071 4.29289C20.7356 4.32136 20.7623 4.35153 20.7872 4.38325L20.7071 4.29289C20.738 4.32383 20.7665 4.35628 20.7926 4.39002C20.8145 4.41864 20.8351 4.44844 20.8539 4.47934C20.8614 4.49139 20.8685 4.50361 20.8753 4.51594C20.8853 4.53413 20.895 4.55289 20.904 4.57198C20.9128 4.5905 20.9211 4.60949 20.9288 4.62866C20.9367 4.64842 20.9439 4.6682 20.9505 4.68826C20.9553 4.70315 20.9599 4.71854 20.9642 4.73401C20.9702 4.75556 20.9754 4.77725 20.9798 4.79921C20.9833 4.81662 20.9864 4.83405 20.989 4.85153C20.992 4.87148 20.9945 4.89211 20.9963 4.91293C20.9978 4.93173 20.9989 4.94973 20.9995 4.96775C21 4.97779 21 4.98887 21 5L20.9997 5.02531C20.9992 5.0453 20.9981 5.06528 20.9964 5.08522L21 5C21 5.05062 20.9962 5.10036 20.989 5.14896C20.9864 5.16595 20.9833 5.18338 20.9798 5.20073C20.9754 5.22275 20.9702 5.24444 20.9643 5.26584C20.9599 5.28146 20.9553 5.29685 20.9503 5.31214C20.9439 5.3318 20.9367 5.35158 20.9289 5.37106C20.9218 5.3888 20.9143 5.4061 20.9063 5.42322C20.8966 5.44389 20.8862 5.46429 20.8751 5.48428C20.8685 5.49639 20.8614 5.50861 20.854 5.52071C20.8413 5.54134 20.8279 5.56153 20.8139 5.58118C20.8062 5.59206 20.7983 5.60254 20.7903 5.6129C20.7849 5.61966 20.7826 5.62256 20.7803 5.62545L20.7071 5.70711L18.7071 7.70711C18.3166 8.09763 17.6834 8.09763 17.2929 7.70711C16.9324 7.34662 16.9047 6.77939 17.2097 6.3871L17.2929 6.29289L17.584 6H5.5C4.7203 6 4.07955 6.59489 4.00687 7.35554L4 7.5V16C4 16.5523 3.55228 17 3 17C2.48716 17 2.06449 16.614 2.00673 16.1166L2 16V7.5C2 5.63144 3.46428 4.10487 5.30796 4.00518L5.5 4H17.585L17.2929 3.70711C16.9324 3.34662 16.9047 2.77939 17.2097 2.3871L17.2929 2.29289C17.6534 1.93241 18.2206 1.90468 18.6129 2.2097ZM12 8C14.2091 8 16 9.79086 16 12C16 14.2091 14.2091 16 12 16C9.79086 16 8 14.2091 8 12C8 9.79086 9.79086 8 12 8Z " },
            { FluentSymbol.CameraSwitch24, "M21.25 7.5C21.6297 7.5 21.9435 7.78215 21.9932 8.14823L22 8.25V16.75C22 18.483 20.6435 19.8992 18.9344 19.9949L18.75 20H6.061L6.78033 20.7197C7.0466 20.9859 7.0708 21.4026 6.85295 21.6962L6.78033 21.7803C6.51406 22.0466 6.0974 22.0708 5.80379 21.8529L5.71967 21.7803L3.71967 19.7803L3.65627 19.7083C3.65382 19.7051 3.6514 19.7019 3.649 19.6987L3.71967 19.7803C3.68262 19.7433 3.65025 19.7033 3.62257 19.6612C3.60941 19.641 3.59703 19.62 3.58567 19.5984C3.58084 19.5893 3.57648 19.5806 3.5723 19.5718C3.55956 19.545 3.54805 19.5165 3.5383 19.4873C3.53604 19.4803 3.53412 19.4742 3.53227 19.4682C3.51135 19.3997 3.5 19.3262 3.5 19.25C3.5 19.2116 3.50288 19.1739 3.50845 19.137C3.51025 19.1255 3.51231 19.1138 3.51464 19.1021C3.51959 19.0771 3.52576 19.0528 3.53309 19.029C3.53671 19.0174 3.54074 19.0053 3.54509 18.9933C3.55357 18.97 3.56288 18.948 3.57317 18.9265C3.57867 18.9149 3.58497 18.9025 3.59163 18.8903C3.60487 18.8663 3.61898 18.8436 3.63422 18.8217C3.63814 18.816 3.64254 18.8099 3.64705 18.8038C3.67217 18.7706 3.69507 18.7443 3.71967 18.7197L5.71967 16.7197C6.01256 16.4268 6.48744 16.4268 6.78033 16.7197C7.0466 16.9859 7.0708 17.4026 6.85295 17.6962L6.78033 17.7803L6.06 18.5H18.75C19.6682 18.5 20.4212 17.7929 20.4942 16.8935L20.5 16.75V8.25C20.5 7.83579 20.8358 7.5 21.25 7.5ZM18.1962 2.14705L18.2803 2.21967L20.2803 4.21967C20.3058 4.24512 20.3294 4.27239 20.351 4.30126L20.2803 4.21967C20.3174 4.25672 20.3498 4.29669 20.3774 4.33883C20.3906 4.35898 20.403 4.37997 20.4143 4.40158C20.4192 4.4107 20.4235 4.41943 20.4277 4.42823C20.4404 4.45502 20.4519 4.48348 20.4617 4.51274C20.464 4.51968 20.4659 4.52575 20.4677 4.53184C20.4886 4.60032 20.5 4.67384 20.5 4.75C20.5 4.78839 20.4971 4.82611 20.4916 4.86295C20.4901 4.8725 20.4884 4.88219 20.4865 4.89186C20.4814 4.91897 20.4748 4.94527 20.4669 4.97098C20.4633 4.98264 20.4593 4.99469 20.4549 5.00665C20.4464 5.02995 20.4371 5.05202 20.4268 5.07352C20.4213 5.08512 20.415 5.09746 20.4084 5.10965C20.3951 5.13367 20.381 5.15639 20.3658 5.17826C20.3619 5.18401 20.3575 5.19014 20.3529 5.19621C20.3292 5.22765 20.3078 5.25237 20.285 5.2756L20.2803 5.28033L18.2803 7.28033C17.9874 7.57322 17.5126 7.57322 17.2197 7.28033C16.9534 7.01406 16.9292 6.5974 17.1471 6.30379L17.2197 6.21967L17.938 5.5H5.25C4.33183 5.5 3.57881 6.20711 3.5058 7.10647L3.5 7.25V15.75C3.5 16.1642 3.16421 16.5 2.75 16.5C2.3703 16.5 2.05651 16.2178 2.00685 15.8518L2 15.75V7.25C2 5.51697 3.35645 4.10075 5.06558 4.00514L5.25 4H17.939L17.2197 3.28033C16.9534 3.01406 16.9292 2.5974 17.1471 2.30379L17.2197 2.21967C17.4859 1.9534 17.9026 1.9292 18.1962 2.14705ZM12 8C14.2091 8 16 9.79086 16 12C16 14.2091 14.2091 16 12 16C9.79086 16 8 14.2091 8 12C8 9.79086 9.79086 8 12 8ZM12 9.5C10.6193 9.5 9.5 10.6193 9.5 12C9.5 13.3807 10.6193 14.5 12 14.5C13.3807 14.5 14.5 13.3807 14.5 12C14.5 10.6193 13.3807 9.5 12 9.5Z " },
            { FluentSymbol.Caret16Filled, "M12 4.95708C12 4.06617 10.9228 3.62001 10.2929 4.24998L4.24998 10.2929C3.62001 10.9228 4.06618 12 4.95708 12H10.5C11.3284 12 12 11.3284 12 10.5V4.95708Z " },
            { FluentSymbol.Caret16, "M10.2929 4.25C10.9228 3.62004 12 4.0662 12 4.9571V10.5C12 11.3284 11.3284 12 10.5 12H4.95708C4.06618 12 3.62001 10.9229 4.24998 10.2929L10.2929 4.25ZM11 4.95711L4.95708 11H10.5C10.7761 11 11 10.7761 11 10.5L11 4.95711Z " },
            { FluentSymbol.Caret20Filled, "M15 5.95708C15 5.06618 13.9228 4.62001 13.2929 5.24998L5.24998 13.2929C4.62001 13.9228 5.06618 15 5.95708 15H13.5C14.3284 15 15 14.3284 15 13.5V5.95708Z " },
            { FluentSymbol.Caret24Filled, "M18 7.2071C18 6.09347 16.6536 5.53575 15.8661 6.32321L6.32321 15.8661C5.53576 16.6536 6.09346 18 7.2071 18H16.25C17.2165 18 18 17.2165 18 16.25V7.2071Z " },
            { FluentSymbol.Caret12Filled, "M9.00486 3.962C9.00486 3.0711 7.92772 2.62493 7.29775 3.2549L3.25486 7.29779C2.62489 7.92775 3.07106 9.0049 3.96197 9.0049H7.50486C8.33329 9.0049 9.00486 8.33332 9.00486 7.5049V3.962Z " },
            { FluentSymbol.Caret12, "M7.29775 3.2549C7.92771 2.62493 9.00486 3.0711 9.00486 3.962V7.5049C9.00486 8.33332 8.33329 9.0049 7.50486 9.0049H3.96197C3.07106 9.0049 2.62489 7.92775 3.25486 7.29779L7.29775 3.2549ZM8.00486 3.962L3.96197 8.0049H7.50486C7.781 8.0049 8.00486 7.78104 8.00486 7.5049L8.00486 3.962Z " },
            { FluentSymbol.Caret20, "M13.2929 5.25001C13.9228 4.62004 15 5.06621 15 5.95711V13.5C15 14.3284 14.3284 15 13.5 15H5.95708C5.06618 15 4.62001 13.9229 5.24998 13.2929L13.2929 5.25001ZM14 5.95711L5.95708 14H13.5C13.7761 14 14 13.7761 14 13.5V5.95711Z " },
            { FluentSymbol.Caret24, "M16.5 7.81067L7.81065 16.5H16.25C16.3881 16.5 16.5 16.3881 16.5 16.25V7.81067ZM15.8661 6.32323C16.6536 5.53577 18 6.09348 18 7.20711V16.25C18 17.2165 17.2165 18 16.25 18H7.2071C6.09346 18 5.53576 16.6536 6.32321 15.8661L15.8661 6.32323Z " },
            { FluentSymbol.CaretDown12Filled, "M3.07615 4.61732C3.23093 4.24364 3.59557 4 4.00003 4H8.00003C8.40449 4 8.76913 4.24364 8.92391 4.61732C9.07869 4.99099 8.99313 5.42111 8.70714 5.70711L6.70714 7.70711C6.31661 8.09763 5.68345 8.09763 5.29292 7.70711L3.29292 5.70711C3.00692 5.42111 2.92137 4.99099 3.07615 4.61732Z " },
            { FluentSymbol.CaretDown12, "M3.07615 4.61732C3.23093 4.24364 3.59557 4 4.00003 4H8.00003C8.40449 4 8.76913 4.24364 8.92391 4.61732C9.07869 4.99099 8.99313 5.42111 8.70714 5.70711L6.70714 7.70711C6.31661 8.09763 5.68345 8.09763 5.29292 7.70711L3.29292 5.70711C3.00692 5.42111 2.92137 4.99099 3.07615 4.61732ZM4.00003 5L5.82325 6.82322C5.92088 6.92085 6.07917 6.92085 6.17681 6.82322L8.00003 5H4.00003Z " },
            { FluentSymbol.CaretDown16Filled, "M4.95681 5C4.14912 5 3.67466 5.90803 4.13591 6.57107L6.76854 10.3555C7.36532 11.2134 8.63448 11.2133 9.23126 10.3555L11.8639 6.57106C12.3251 5.90803 11.8507 5 11.043 5H4.95681Z " },
            { FluentSymbol.CaretDown16, "M4.13591 6.57107C3.67466 5.90803 4.14912 5 4.95681 5H11.043C11.8507 5 12.3251 5.90803 11.8639 6.57106L9.23126 10.3555C8.63448 11.2133 7.36532 11.2134 6.76854 10.3555L4.13591 6.57107ZM4.95681 6L7.58945 9.78442C7.78837 10.0704 8.21143 10.0704 8.41035 9.78442L11.043 6L4.95681 6Z " },
            { FluentSymbol.CaretDown20Filled, "M5.79681 7C4.95612 7 4.49064 7.97434 5.01887 8.62834L8.83333 13.351C9.43371 14.0943 10.5668 14.0943 11.1672 13.351L14.9816 8.62834C15.5098 7.97434 15.0444 7 14.2037 7H5.79681Z " },
            { FluentSymbol.CaretDown20, "M5.01887 8.62834C4.49064 7.97434 4.95612 7 5.79681 7H14.2037C15.0444 7 15.5098 7.97434 14.9816 8.62834L11.1672 13.351C10.5668 14.0943 9.43371 14.0943 8.83333 13.351L5.01887 8.62834ZM14.2037 8L5.79681 8L9.61127 12.7227C9.81139 12.9704 10.1891 12.9704 10.3892 12.7227L14.2037 8Z " },
            { FluentSymbol.CaretDown24Filled, "M6.10204 8C5.0281 8 4.45412 9.2649 5.16132 10.0731L10.6831 16.3838C11.3804 17.1806 12.6199 17.1806 13.3172 16.3838L18.839 10.0731C19.5462 9.2649 18.9722 8 17.8983 8H6.10204Z " },
            { FluentSymbol.CaretDown24, "M5.16132 10.0731C4.45412 9.2649 5.0281 8 6.10204 8H17.8983C18.9722 8 19.5462 9.2649 18.839 10.0731L13.3172 16.3838C12.6199 17.1806 11.3804 17.1806 10.6831 16.3838L5.16132 10.0731ZM6.65298 9.5L11.812 15.396C11.9116 15.5099 12.0887 15.5099 12.1883 15.396L17.3473 9.5H6.65298Z " },
            { FluentSymbol.CaretLeft12Filled, "M6.29863 3.28162C6.93081 2.65918 8.00024 3.10702 8.00024 3.99419V8.0062C8.00024 8.89338 6.9308 9.34122 6.29863 8.71877L4.26129 6.71276C3.86342 6.32102 3.86343 5.67936 4.26129 5.28763L6.29863 3.28162Z " },
            { FluentSymbol.CaretLeft12, "M8.00024 3.99419C8.00024 3.10702 6.93081 2.65918 6.29863 3.28162L4.26129 5.28763C3.86343 5.67937 3.86343 6.32102 4.26128 6.71276L6.29863 8.71877C6.9308 9.34122 8.00024 8.89338 8.00024 8.0062V3.99419ZM4.96289 6.00019L7.00024 3.99419V8.0062L4.96289 6.00019Z " },
            { FluentSymbol.CaretLeft16Filled, "M9.42796 11.8398C10.091 12.2982 10.999 11.8267 10.999 11.0239V4.97512C10.999 4.17238 10.091 3.70084 9.42796 4.15925L5.64354 6.77573C4.78567 7.36885 4.78567 8.63021 5.64354 9.22333L9.42796 11.8398Z " },
            { FluentSymbol.CaretLeft16, "M9.42879 11.8639C10.0918 12.3251 10.9999 11.8507 10.9999 11.043V4.95681C10.9999 4.14912 10.0918 3.67466 9.4288 4.13591L5.64438 6.76854C4.78651 7.36532 4.78651 8.63448 5.64438 9.23126L9.42879 11.8639ZM9.99986 11.043L6.21544 8.41035C5.92949 8.21143 5.92949 7.78837 6.21545 7.58945L9.99986 4.95681L9.99986 11.043Z " },
            { FluentSymbol.CaretLeft20Filled, "M12.9998 14.2037C12.9998 15.0444 12.0255 15.5098 11.3715 14.9816L6.6488 11.1671C5.90548 10.5668 5.90548 9.4337 6.6488 8.83333L11.3715 5.01887C12.0255 4.49064 12.9998 4.95613 12.9998 5.79681L12.9998 14.2037Z " },
            { FluentSymbol.CaretLeft20, "M11.3715 14.9816C12.0255 15.5098 12.9998 15.0444 12.9998 14.2037L12.9998 5.79681C12.9998 4.95613 12.0255 4.49063 11.3715 5.01887L6.6488 8.83333C5.90548 9.43371 5.90548 10.5668 6.6488 11.1672L11.3715 14.9816ZM11.9998 5.79681L11.9998 14.2037L7.27714 10.3892C7.02936 10.1891 7.02936 9.81139 7.27714 9.61127L11.9998 5.79681Z " },
            { FluentSymbol.CaretLeft24Filled, "M15 17.8983C15 18.9722 13.7351 19.5462 12.9268 18.839L6.61617 13.3172C5.81935 12.6199 5.81935 11.3804 6.61617 10.6831L12.9268 5.16132C13.7351 4.45412 15 5.02809 15 6.10204L15 17.8983Z " },
            { FluentSymbol.CaretLeft24, "M12.9268 18.839C13.7351 19.5462 15 18.9722 15 17.8983L15 6.10204C15 5.02809 13.7351 4.45412 12.9268 5.16132L6.61617 10.6831C5.81935 11.3804 5.81935 12.6199 6.61617 13.3172L12.9268 18.839ZM13.5 17.3473L7.60393 12.1883C7.4901 12.0887 7.4901 11.9116 7.60393 11.812L13.5 6.65298L13.5 17.3473Z " },
            { FluentSymbol.CaretRight12Filled, "M5.7016 3.28162C5.06943 2.65918 4 3.10702 4 3.99419V8.0062C4 8.89338 5.06944 9.34122 5.70161 8.71877L7.73895 6.71276C8.13681 6.32102 8.13681 5.67936 7.73895 5.28763L5.7016 3.28162Z " },
            { FluentSymbol.CaretRight12, "M4 3.99419C4 3.10702 5.06943 2.65918 5.7016 3.28162L7.73895 5.28763C8.13681 5.67937 8.13681 6.32102 7.73895 6.71276L5.70161 8.71877C5.06944 9.34122 4 8.89338 4 8.0062V3.99419ZM7.03735 6.00019L5 3.99419V8.0062L7.03735 6.00019Z " },
            { FluentSymbol.CaretRight16Filled, "M7.57107 11.8398C6.90803 12.2982 6 11.8267 6 11.0239V4.97512C6 4.17238 6.90803 3.70084 7.57106 4.15925L11.3555 6.77573C12.2133 7.36885 12.2134 8.63021 11.3555 9.22333L7.57107 11.8398Z " },
            { FluentSymbol.CaretRight16, "M7.57107 11.8398C6.90803 12.2982 6 11.8267 6 11.0239V4.97512C6 4.17238 6.90803 3.70084 7.57106 4.15925L11.3555 6.77573C12.2133 7.36885 12.2134 8.63021 11.3555 9.22333L7.57107 11.8398ZM7 11.0239L10.7844 8.40747C11.0704 8.20976 11.0704 7.7893 10.7844 7.5916L7 4.97512L7 11.0239Z " },
            { FluentSymbol.CaretRight20Filled, "M7 14.2037C7 15.0444 7.97434 15.5098 8.62834 14.9816L13.351 11.1671C14.0943 10.5668 14.0943 9.4337 13.351 8.83333L8.62834 5.01887C7.97434 4.49064 7 4.95613 7 5.79681V14.2037Z " },
            { FluentSymbol.CaretRight20, "M8.62834 14.9816C7.97434 15.5098 7 15.0444 7 14.2037L7 5.79681C7 4.95613 7.97434 4.49063 8.62834 5.01887L13.351 8.83333C14.0943 9.43371 14.0943 10.5668 13.351 11.1672L8.62834 14.9816ZM8 5.79681L8 14.2037L12.7227 10.3892C12.9704 10.1891 12.9704 9.81139 12.7227 9.61127L8 5.79681Z " },
            { FluentSymbol.CaretRight24Filled, "M9 17.8983C9 18.9722 10.2649 19.5462 11.0731 18.839L17.3838 13.3172C18.1806 12.6199 18.1806 11.3804 17.3838 10.6831L11.0731 5.16132C10.2649 4.45412 9 5.02809 9 6.10204V17.8983Z " },
            { FluentSymbol.CaretRight24, "M11.0731 18.839C10.2649 19.5462 9 18.9722 9 17.8983L9 6.10204C9 5.02809 10.2649 4.45412 11.0731 5.16132L17.3838 10.6831C18.1806 11.3804 18.1806 12.6199 17.3838 13.3172L11.0731 18.839ZM10.5 17.3473L16.396 12.1883C16.5099 12.0887 16.5099 11.9116 16.396 11.812L10.5 6.65298L10.5 17.3473Z " },
            { FluentSymbol.CaretUp12Filled, "M3.07615 7.38268C3.23093 7.75636 3.59557 8 4.00003 8H8.00003C8.40449 8 8.76913 7.75636 8.92391 7.38268C9.07869 7.00901 8.99313 6.57889 8.70714 6.29289L6.70714 4.29289C6.31661 3.90237 5.68345 3.90237 5.29292 4.29289L3.29292 6.29289C3.00692 6.57889 2.92137 7.00901 3.07615 7.38268Z " },
            { FluentSymbol.CaretUp12, "M3.07615 7.38268C3.23093 7.75636 3.59557 8 4.00003 8H8.00003C8.40449 8 8.76913 7.75636 8.92391 7.38268C9.07869 7.00901 8.99313 6.57889 8.70714 6.29289L6.70714 4.29289C6.31661 3.90237 5.68345 3.90237 5.29292 4.29289L3.29292 6.29289C3.00692 6.57889 2.92137 7.00901 3.07615 7.38268ZM4.00003 7L5.82325 5.17678C5.92088 5.07915 6.07917 5.07915 6.17681 5.17678L8.00003 7H4.00003Z " },
            { FluentSymbol.CaretUp16Filled, "M4.95681 10.999C4.14912 10.999 3.67466 10.091 4.13591 9.42796L6.76854 5.64354C7.36532 4.78567 8.63448 4.78567 9.23126 5.64354L11.8639 9.42796C12.3251 10.091 11.8507 10.999 11.043 10.999H4.95681Z " },
            { FluentSymbol.CaretUp16, "M4.13591 9.42796C3.67466 10.091 4.14912 10.999 4.95681 10.999H11.043C11.8507 10.999 12.3251 10.091 11.8639 9.42796L9.23126 5.64354C8.63448 4.78567 7.36532 4.78567 6.76854 5.64354L4.13591 9.42796ZM4.95681 9.99902L7.58945 6.21461C7.78837 5.92865 8.21143 5.92865 8.41035 6.21461L11.043 9.99902L4.95681 9.99902Z " },
            { FluentSymbol.CaretUp20Filled, "M5.79681 13.9082C4.95612 13.9082 4.49064 12.9339 5.01887 12.2799L8.83333 7.5572C9.43371 6.81387 10.5668 6.81387 11.1672 7.5572L14.9816 12.2799C15.5098 12.9339 15.0444 13.9082 14.2037 13.9082H5.79681Z " },
            { FluentSymbol.CaretUp20, "M5.01887 12.2799C4.49064 12.9339 4.95612 13.9082 5.79681 13.9082H14.2037C15.0444 13.9082 15.5098 12.9339 14.9816 12.2799L11.1672 7.5572C10.5668 6.81387 9.43371 6.81387 8.83333 7.5572L5.01887 12.2799ZM14.2037 12.9082L5.79681 12.9082L9.61127 8.18554C9.81139 7.93776 10.1891 7.93776 10.3892 8.18554L14.2037 12.9082Z " },
            { FluentSymbol.CaretUp24Filled, "M6.10204 16.9814C5.0281 16.9814 4.45412 15.7165 5.16132 14.9083L10.6831 8.59765C11.3804 7.80083 12.6199 7.80083 13.3172 8.59765L18.839 14.9083C19.5462 15.7165 18.9722 16.9814 17.8983 16.9814H6.10204Z " },
            { FluentSymbol.CaretUp24, "M5.16132 14.9083C4.45412 15.7165 5.0281 16.9814 6.10204 16.9814H17.8983C18.9722 16.9814 19.5462 15.7165 18.839 14.9083L13.3172 8.59765C12.6199 7.80083 11.3804 7.80083 10.6831 8.59765L5.16132 14.9083ZM6.65298 15.4814L11.812 9.58541C11.9116 9.47158 12.0887 9.47158 12.1883 9.58541L17.3473 15.4814H6.65298Z " },
            { FluentSymbol.Cart16Filled, "M2.5 2C2.22386 2 2 2.22386 2 2.5C2 2.77614 2.22386 3 2.5 3H2.7457C2.96894 3 3.16513 3.14799 3.22646 3.36264L4.81202 8.91208C4.996 9.55603 5.58458 10 6.2543 10H10.823C11.4363 10 11.9879 9.62657 12.2157 9.05709L13.69 5.37139C13.9527 4.71453 13.4689 4 12.7615 4H4.44858L4.18798 3.08792C4.004 2.44397 3.41542 2 2.7457 2H2.5Z M6.5 14C7.32843 14 8 13.3284 8 12.5C8 11.6716 7.32843 11 6.5 11C5.67157 11 5 11.6716 5 12.5C5 13.3284 5.67157 14 6.5 14Z M10.5 14C11.3284 14 12 13.3284 12 12.5C12 11.6716 11.3284 11 10.5 11C9.67157 11 9 11.6716 9 12.5C9 13.3284 9.67157 14 10.5 14Z " },
            { FluentSymbol.Cart16, "M2.5 2C2.22386 2 2 2.22386 2 2.5C2 2.77614 2.22386 3 2.5 3H2.7457C2.96894 3 3.16513 3.14799 3.22646 3.36264L4.81202 8.91208C4.996 9.55603 5.58458 10 6.2543 10H10.823C11.4363 10 11.9879 9.62657 12.2157 9.05709L13.69 5.37139C13.9527 4.71453 13.4689 4 12.7615 4H4.44858L4.18798 3.08792C4.004 2.44397 3.41542 2 2.7457 2H2.5ZM5.77354 8.63736L4.73429 5H12.7615L11.2872 8.6857C11.2113 8.87552 11.0274 9 10.823 9H6.2543C6.03106 9 5.83487 8.85201 5.77354 8.63736Z M6.5 14C7.32843 14 8 13.3284 8 12.5C8 11.6716 7.32843 11 6.5 11C5.67157 11 5 11.6716 5 12.5C5 13.3284 5.67157 14 6.5 14ZM6.5 13C6.22386 13 6 12.7761 6 12.5C6 12.2239 6.22386 12 6.5 12C6.77614 12 7 12.2239 7 12.5C7 12.7761 6.77614 13 6.5 13Z M10.5 14C11.3284 14 12 13.3284 12 12.5C12 11.6716 11.3284 11 10.5 11C9.67157 11 9 11.6716 9 12.5C9 13.3284 9.67157 14 10.5 14ZM10.5 13C10.2239 13 10 12.7761 10 12.5C10 12.2239 10.2239 12 10.5 12C10.7761 12 11 12.2239 11 12.5C11 12.7761 10.7761 13 10.5 13Z " },
            { FluentSymbol.Cart24Filled, "M2.5 4.25C2.5 3.83579 2.83579 3.5 3.25 3.5H3.80826C4.75873 3.5 5.32782 4.13899 5.65325 4.73299C5.87016 5.12894 6.02708 5.58818 6.14982 6.00395C6.18306 6.00134 6.21674 6 6.2508 6H18.7481C19.5783 6 20.1778 6.79442 19.9502 7.5928L18.1224 14.0019C17.7856 15.1832 16.7062 15.9978 15.4779 15.9978H9.52977C8.29128 15.9978 7.2056 15.1699 6.87783 13.9756L6.11734 11.2045L4.85874 6.95578L4.8567 6.94834C4.701 6.38051 4.55487 5.85005 4.33773 5.4537C4.12686 5.0688 3.95877 5 3.80826 5H3.25C2.83579 5 2.5 4.66421 2.5 4.25Z M9 21C10.1046 21 11 20.1046 11 19C11 17.8954 10.1046 17 9 17C7.89543 17 7 17.8954 7 19C7 20.1046 7.89543 21 9 21Z M16 21C17.1046 21 18 20.1046 18 19C18 17.8954 17.1046 17 16 17C14.8954 17 14 17.8954 14 19C14 20.1046 14.8954 21 16 21Z " },
            { FluentSymbol.Cart24, "M2.5 4.25C2.5 3.83579 2.83579 3.5 3.25 3.5H3.80826C4.75873 3.5 5.32782 4.13899 5.65325 4.73299C5.87016 5.12894 6.02708 5.58818 6.14982 6.00395C6.18306 6.00134 6.21674 6 6.2508 6H18.7481C19.5783 6 20.1778 6.79442 19.9502 7.5928L18.1224 14.0019C17.7856 15.1832 16.7062 15.9978 15.4779 15.9978H9.52977C8.29128 15.9978 7.2056 15.1699 6.87783 13.9756L6.11734 11.2045L4.85874 6.95578L4.8567 6.94834C4.701 6.38051 4.55487 5.85005 4.33773 5.4537C4.12686 5.0688 3.95877 5 3.80826 5H3.25C2.83579 5 2.5 4.66421 2.5 4.25ZM7.57283 10.8403L8.32434 13.5786C8.47333 14.1215 8.96682 14.4978 9.52977 14.4978H15.4779C16.0362 14.4978 16.5268 14.1275 16.68 13.5906L18.4168 7.5H6.58549L7.55906 10.7868C7.56434 10.8046 7.56892 10.8224 7.57283 10.8403Z M11 19C11 20.1046 10.1046 21 9 21C7.89543 21 7 20.1046 7 19C7 17.8954 7.89543 17 9 17C10.1046 17 11 17.8954 11 19ZM9.5 19C9.5 18.7239 9.27614 18.5 9 18.5C8.72386 18.5 8.5 18.7239 8.5 19C8.5 19.2761 8.72386 19.5 9 19.5C9.27614 19.5 9.5 19.2761 9.5 19Z M18 19C18 20.1046 17.1046 21 16 21C14.8954 21 14 20.1046 14 19C14 17.8954 14.8954 17 16 17C17.1046 17 18 17.8954 18 19ZM16.5 19C16.5 18.7239 16.2761 18.5 16 18.5C15.7239 18.5 15.5 18.7239 15.5 19C15.5 19.2761 15.7239 19.5 16 19.5C16.2761 19.5 16.5 19.2761 16.5 19Z " },
            { FluentSymbol.Cart20Filled, "M2.99707 3.49609C2.99707 3.21995 3.22093 2.99609 3.49707 2.99609H3.93543C4.66237 2.99609 5.07976 3.46917 5.32152 3.94075C5.4872 4.2639 5.6065 4.65813 5.70508 4.99951H15.9999C16.6634 4.99951 17.1429 5.63392 16.9619 6.27229L15.4664 11.5468C15.2225 12.4073 14.4368 13.0012 13.5423 13.0012H8.46306C7.56125 13.0012 6.77099 12.3977 6.5336 11.5277L5.89118 9.17338C5.88723 9.16268 5.88361 9.15177 5.88034 9.14067L4.851 5.6429C4.81568 5.52686 4.78318 5.41439 4.7518 5.3058C4.65195 4.96027 4.56346 4.65406 4.43165 4.39696C4.2723 4.08613 4.12597 3.99609 3.93543 3.99609H3.49707C3.22093 3.99609 2.99707 3.77224 2.99707 3.49609Z M8.5 16.9995C9.32843 16.9995 10 16.3279 10 15.4995C10 14.6711 9.32843 13.9995 8.5 13.9995C7.67157 13.9995 7 14.6711 7 15.4995C7 16.3279 7.67157 16.9995 8.5 16.9995Z M13.5 16.9995C14.3284 16.9995 15 16.3279 15 15.4995C15 14.6711 14.3284 13.9995 13.5 13.9995C12.6716 13.9995 12 14.6711 12 15.4995C12 16.3279 12.6716 16.9995 13.5 16.9995Z " },
            { FluentSymbol.Cart20, "M2.99707 3.49609C2.99707 3.21995 3.22093 2.99609 3.49707 2.99609H3.93543C4.66237 2.99609 5.07976 3.46917 5.32152 3.94075C5.4872 4.2639 5.6065 4.65813 5.70508 4.99951H15.9999C16.6634 4.99951 17.1429 5.63392 16.9619 6.27229L15.4664 11.5468C15.2225 12.4073 14.4368 13.0012 13.5423 13.0012H8.46306C7.56125 13.0012 6.77099 12.3977 6.5336 11.5277L5.89118 9.17338C5.88723 9.16268 5.88361 9.15177 5.88034 9.14067L4.851 5.6429C4.81568 5.52686 4.78318 5.41439 4.7518 5.3058C4.65195 4.96027 4.56346 4.65406 4.43165 4.39696C4.2723 4.08613 4.12597 3.99609 3.93543 3.99609H3.49707C3.22093 3.99609 2.99707 3.77224 2.99707 3.49609ZM6.84471 8.86872L7.49833 11.2645C7.61702 11.6995 8.01215 12.0012 8.46306 12.0012H13.5423C13.9895 12.0012 14.3824 11.7043 14.5044 11.274L15.9999 5.99951H6.00063L6.84471 8.86872Z M10 15.4995C10 16.3279 9.32843 16.9995 8.5 16.9995C7.67157 16.9995 7 16.3279 7 15.4995C7 14.6711 7.67157 13.9995 8.5 13.9995C9.32843 13.9995 10 14.6711 10 15.4995ZM9 15.4995C9 15.2234 8.77614 14.9995 8.5 14.9995C8.22386 14.9995 8 15.2234 8 15.4995C8 15.7757 8.22386 15.9995 8.5 15.9995C8.77614 15.9995 9 15.7757 9 15.4995Z M15 15.4995C15 16.3279 14.3284 16.9995 13.5 16.9995C12.6716 16.9995 12 16.3279 12 15.4995C12 14.6711 12.6716 13.9995 13.5 13.9995C14.3284 13.9995 15 14.6711 15 15.4995ZM14 15.4995C14 15.2234 13.7761 14.9995 13.5 14.9995C13.2239 14.9995 13 15.2234 13 15.4995C13 15.7757 13.2239 15.9995 13.5 15.9995C13.7761 15.9995 14 15.7757 14 15.4995Z " },
            { FluentSymbol.Cast28Filled, "M2 6.75C2 5.50736 3.00736 4.5 4.25 4.5H23.75C24.9926 4.5 26 5.50736 26 6.75V21.25C26 22.4926 24.9926 23.5 23.75 23.5H4.25C3.00736 23.5 2 22.4926 2 21.25V6.75ZM5.5 11.25C5.5 11.6642 5.83579 12 6.25 12C10.2577 12 13.505 15.2417 13.505 19.2476C13.505 19.6618 13.8408 19.9976 14.255 19.9976C14.6692 19.9976 15.005 19.6618 15.005 19.2476C15.005 14.4115 11.0843 10.5 6.25 10.5C5.83579 10.5 5.5 10.8358 5.5 11.25ZM6.25 13.9989C5.83579 13.9989 5.5 14.3347 5.5 14.7489C5.5 15.1631 5.83579 15.4989 6.25 15.4989C8.32036 15.4989 9.99872 17.1773 9.99872 19.2476C9.99872 19.6618 10.3345 19.9976 10.7487 19.9976C11.1629 19.9976 11.4987 19.6618 11.4987 19.2476C11.4987 16.3488 9.14879 13.9989 6.25 13.9989ZM6.75 19.9991C7.44036 19.9991 8 19.4394 8 18.7491C8 18.0587 7.44036 17.4991 6.75 17.4991C6.05964 17.4991 5.5 18.0587 5.5 18.7491C5.5 19.4394 6.05964 19.9991 6.75 19.9991Z " },
            { FluentSymbol.Cast28, "M6.25 13.9989C5.83579 13.9989 5.5 14.3347 5.5 14.7489C5.5 15.1631 5.83579 15.4989 6.25 15.4989C8.32036 15.4989 9.99872 17.1773 9.99872 19.2476C9.99872 19.6618 10.3345 19.9976 10.7487 19.9976C11.1629 19.9976 11.4987 19.6618 11.4987 19.2476C11.4987 16.3488 9.14879 13.9989 6.25 13.9989Z M5.5 11.25C5.5 10.8358 5.83579 10.5 6.25 10.5C11.0843 10.5 15.005 14.4115 15.005 19.2476C15.005 19.6618 14.6692 19.9976 14.255 19.9976C13.8408 19.9976 13.505 19.6618 13.505 19.2476C13.505 15.2417 10.2577 12 6.25 12C5.83579 12 5.5 11.6642 5.5 11.25Z M6.75 19.9991C7.44036 19.9991 8 19.4394 8 18.7491C8 18.0587 7.44036 17.4991 6.75 17.4991C6.05964 17.4991 5.5 18.0587 5.5 18.7491C5.5 19.4394 6.05964 19.9991 6.75 19.9991Z M4.25 4.5C3.00736 4.5 2 5.50736 2 6.75V21.25C2 22.4926 3.00736 23.5 4.25 23.5H23.75C24.9926 23.5 26 22.4926 26 21.25V6.75C26 5.50736 24.9926 4.5 23.75 4.5H4.25ZM3.5 6.75C3.5 6.33579 3.83579 6 4.25 6H23.75C24.1642 6 24.5 6.33579 24.5 6.75V21.25C24.5 21.6642 24.1642 22 23.75 22H4.25C3.83579 22 3.5 21.6642 3.5 21.25V6.75Z " },
            { FluentSymbol.Cast20Filled, "M3.5 4C2.67157 4 2 4.67157 2 5.5V14.5C2 15.3284 2.67157 16 3.5 16H16.5C17.3284 16 18 15.3284 18 14.5V5.5C18 4.67157 17.3284 4 16.5 4H3.5ZM3.99731 8C3.99731 7.72386 4.22117 7.5 4.49731 7.5C7.81251 7.5 10.5 10.1875 10.5 13.5027C10.5 13.7788 10.2761 14.0027 10 14.0027C9.72386 14.0027 9.5 13.7788 9.5 13.5027C9.5 10.7398 7.26022 8.5 4.49731 8.5C4.22117 8.5 3.99731 8.27614 3.99731 8ZM4.49731 10C6.4317 10 7.99984 11.5681 7.99984 13.5025C7.99984 13.7787 7.77598 14.0025 7.49984 14.0025C7.2237 14.0025 6.99984 13.7787 6.99984 13.5025C6.99984 12.1204 5.87942 11 4.49731 11C4.22117 11 3.99731 10.7761 3.99731 10.5C3.99731 10.2239 4.22117 10 4.49731 10ZM4.74945 13.9989C4.33554 13.9989 4 13.6634 4 13.2495C4 12.8355 4.33554 12.5 4.74945 12.5C5.16336 12.5 5.4989 12.8355 5.4989 13.2495C5.4989 13.6634 5.16336 13.9989 4.74945 13.9989Z " },
            { FluentSymbol.Cast20, "M2 5.5C2 4.67157 2.67157 4 3.5 4H16.5C17.3284 4 18 4.67157 18 5.5V14.5C18 15.3284 17.3284 16 16.5 16H3.5C2.67157 16 2 15.3284 2 14.5V5.5ZM3.5 5C3.22386 5 3 5.22386 3 5.5V14.5C3 14.7761 3.22386 15 3.5 15H16.5C16.7761 15 17 14.7761 17 14.5V5.5C17 5.22386 16.7761 5 16.5 5H3.5Z M5.4989 13.2495C5.4989 13.6634 5.16336 13.9989 4.74945 13.9989C4.33554 13.9989 4 13.6634 4 13.2495C4 12.8355 4.33554 12.5 4.74945 12.5C5.16336 12.5 5.4989 12.8355 5.4989 13.2495Z M3.9973 10.5C3.9973 10.2239 4.22116 10 4.4973 10C6.43169 10 7.99982 11.5681 7.99982 13.5025C7.99982 13.7787 7.77596 14.0025 7.49982 14.0025C7.22368 14.0025 6.99982 13.7787 6.99982 13.5025C6.99982 12.1204 5.87941 11 4.4973 11C4.22116 11 3.9973 10.7761 3.9973 10.5Z M3.99731 8C3.99731 7.72386 4.22117 7.5 4.49731 7.5C7.81251 7.5 10.5 10.1875 10.5 13.5027C10.5 13.7788 10.2761 14.0027 10 14.0027C9.72386 14.0027 9.5 13.7788 9.5 13.5027C9.5 10.7398 7.26022 8.5 4.49731 8.5C4.22117 8.5 3.99731 8.27614 3.99731 8Z " },
            { FluentSymbol.Cast24Filled, "M4.25 4C3.00736 4 2 5.00736 2 6.25V17.75C2 18.9926 3.00736 20 4.25 20H19.75C20.9926 20 22 18.9926 22 17.75V6.25C22 5.00736 20.9926 4 19.75 4H4.25ZM5.74585 8.9938C9.75201 8.9938 12.9996 12.2414 12.9996 16.2476C12.9996 16.6618 12.6639 16.9976 12.2496 16.9976C11.8354 16.9976 11.4996 16.6618 11.4996 16.2476C11.4996 13.0699 8.92359 10.4938 5.74585 10.4938C5.33164 10.4938 4.99585 10.158 4.99585 9.7438C4.99585 9.32959 5.33164 8.9938 5.74585 8.9938ZM4.99585 12.7506C4.99585 12.3364 5.33164 12.0006 5.74585 12.0006C8.09142 12.0006 9.99289 13.902 9.99289 16.2476C9.99289 16.6618 9.6571 16.9976 9.24289 16.9976C8.82867 16.9976 8.49289 16.6618 8.49289 16.2476C8.49289 14.7305 7.263 13.5006 5.74585 13.5006C5.33164 13.5006 4.99585 13.1648 4.99585 12.7506ZM6.99595 15.9955C6.99595 16.5466 6.54915 16.9934 5.998 16.9934C5.44684 16.9934 5.00005 16.5466 5.00005 15.9955C5.00005 15.4443 5.44684 14.9975 5.998 14.9975C6.54915 14.9975 6.99595 15.4443 6.99595 15.9955Z " },
            { FluentSymbol.Cast24, "M2 6.25C2 5.00736 3.00736 4 4.25 4H19.75C20.9926 4 22 5.00736 22 6.25V17.75C22 18.9926 20.9926 20 19.75 20H4.25C3.00736 20 2 18.9926 2 17.75V6.25ZM4.25 5.5C3.83579 5.5 3.5 5.83579 3.5 6.25V17.75C3.5 18.1642 3.83579 18.5 4.25 18.5H19.75C20.1642 18.5 20.5 18.1642 20.5 17.75V6.25C20.5 5.83579 20.1642 5.5 19.75 5.5H4.25Z M6.9959 15.9955C6.9959 16.5466 6.5491 16.9934 5.99795 16.9934C5.4468 16.9934 5 16.5466 5 15.9955C5 15.4443 5.4468 14.9975 5.99795 14.9975C6.5491 14.9975 6.9959 15.4443 6.9959 15.9955Z M4.9958 12.7506C4.9958 12.3363 5.33159 12.0006 5.7458 12.0006C8.09138 12.0006 9.99284 13.902 9.99284 16.2476C9.99284 16.6618 9.65705 16.9976 9.24284 16.9976C8.82863 16.9976 8.49284 16.6618 8.49284 16.2476C8.49284 14.7304 7.26295 13.5006 5.7458 13.5006C5.33159 13.5006 4.9958 13.1648 4.9958 12.7506Z M4.9958 9.74379C4.9958 9.32958 5.33159 8.99379 5.7458 8.99379C9.75197 8.99379 12.9996 12.2414 12.9996 16.2476C12.9996 16.6618 12.6638 16.9976 12.2496 16.9976C11.8354 16.9976 11.4996 16.6618 11.4996 16.2476C11.4996 13.0699 8.92354 10.4938 5.7458 10.4938C5.33159 10.4938 4.9958 10.158 4.9958 9.74379Z " },
            { FluentSymbol.Cellular3G24Filled, "M12.8965 3.61994L12.896 3.61899L12.8954 3.61802L12.8942 3.61601L12.8917 3.61175L12.8859 3.60226C12.8817 3.59551 12.8769 3.58793 12.8714 3.57958C12.8604 3.56289 12.8468 3.54307 12.8304 3.52071C12.7976 3.47604 12.7532 3.42082 12.6958 3.35986C12.5808 3.23776 12.4129 3.09193 12.1818 2.96285C11.7062 2.69718 11.0269 2.53793 10.1145 2.70538C9.02252 2.90578 8.4838 3.67506 8.23891 4.30182C8.11772 4.612 8.05927 4.90431 8.03035 5.1157C8.01571 5.22275 8.00816 5.31266 8.00425 5.37841C8.00229 5.41137 8.00123 5.43853 8.00066 5.45902L8.00011 5.48475L8.00002 5.49373L8 5.49722L8 5.49871V6.74998C8 8.13069 9.11929 9.24998 10.5 9.24998H10.75C12.1307 9.24998 13.25 8.13069 13.25 6.74998V6.24995C13.25 5.83574 12.9142 5.49995 12.5 5.49995L12.4912 5.5H11.25C10.8358 5.5 10.5 5.83579 10.5 6.25C10.5 6.66421 10.8358 7 11.25 7H11.7185C11.6075 7.4313 11.216 7.74998 10.75 7.74998H10.5C9.94771 7.74998 9.5 7.30227 9.5 6.74998V5.50385L9.50007 5.50088C9.50023 5.49514 9.50064 5.48375 9.50161 5.46746C9.50355 5.4347 9.50772 5.38326 9.51652 5.31897C9.53447 5.18769 9.56976 5.01737 9.63605 4.84771C9.76612 4.51481 9.97732 4.2556 10.3852 4.18074C10.9826 4.07111 11.3034 4.19034 11.4504 4.27242C11.5306 4.31723 11.5796 4.36258 11.6038 4.38822C11.6114 4.3963 11.6165 4.40237 11.6192 4.40574C11.8356 4.74281 12.2817 4.8514 12.6301 4.64658C12.9872 4.43667 13.1065 3.97703 12.8965 3.61994ZM4.43599 4.6103C4.46669 4.58837 4.49075 4.56741 4.49339 4.56511L4.50966 4.55081L4.52711 4.53526C4.53762 4.52598 4.55153 4.514 4.5693 4.49981C4.60534 4.47105 4.65805 4.43263 4.72505 4.39449C4.86035 4.31749 5.03849 4.25 5.25006 4.25C5.4113 4.25 5.50923 4.29901 5.57379 4.35375C5.64534 4.41441 5.70576 4.50879 5.73655 4.62961C5.78143 4.80571 5.74818 4.97219 5.68074 5.07424C5.63184 5.14823 5.52784 5.25 5.25006 5.25C4.83584 5.25 4.50006 5.58579 4.50006 6C4.50006 6.41421 4.83584 6.75 5.25006 6.75C5.50106 6.75 5.60652 6.83391 5.65638 6.89312C5.71964 6.96822 5.76596 7.09394 5.7555 7.25132C5.74564 7.39961 5.68762 7.52938 5.60808 7.6137C5.53925 7.68665 5.43354 7.75 5.25006 7.75C4.84312 7.75 4.57678 7.51021 4.50167 7.44258L4.48815 7.43056C4.17366 7.16099 3.70018 7.19741 3.43062 7.51191C3.16105 7.8264 3.19747 8.29988 3.51196 8.56944C3.49822 8.55766 3.68967 8.74428 3.98419 8.91124C4.28028 9.07909 4.71298 9.25 5.25006 9.25C6.5056 9.25 7.19143 8.26445 7.25219 7.35085C7.28252 6.89472 7.16789 6.40252 6.86222 6.00001C6.88653 5.96794 6.90985 5.93501 6.93217 5.90123C7.26175 5.4025 7.32568 4.79117 7.19009 4.25916C6.9896 3.4725 6.31378 2.75 5.25006 2.75C4.19776 2.75 3.4857 3.44572 3.56413 3.3897C3.22707 3.63046 3.149 4.09887 3.38976 4.43593C3.63051 4.77299 4.09893 4.85106 4.43599 4.6103ZM21 6.99917C21 6.44735 20.5523 6 20 6C19.4477 6 19 6.44735 19 6.99917V20.0008C19 20.5527 19.4477 21 20 21C20.5523 21 21 20.5527 21 20.0008V6.99917ZM17 9.99543C17 9.44567 16.5523 9 16 9C15.4477 9 15 9.44567 15 9.99543V20.0046C15 20.5543 15.4477 21 16 21C16.5523 21 17 20.5543 17 20.0046V9.99543ZM13 13C13 12.4477 12.5523 12 12 12C11.4477 12 11 12.4477 11 13V20C11 20.5523 11.4477 21 12 21C12.5523 21 13 20.5523 13 20V13ZM9 15.9942C9 15.4451 8.55228 15 8 15C7.44772 15 7 15.4451 7 15.9942V20.0058C7 20.5549 7.44772 21 8 21C8.55228 21 9 20.5549 9 20.0058V15.9942ZM5 18.9836C5 18.4403 4.55228 18 4 18C3.44772 18 3 18.4403 3 18.9836V20.0164C3 20.5597 3.44772 21 4 21C4.55228 21 5 20.5597 5 20.0164V18.9836Z " },
            { FluentSymbol.Cellular3G24, "M12.896 3.61899L12.8965 3.61994C13.1065 3.97703 12.9872 4.43667 12.6301 4.64658C12.2817 4.8514 11.8356 4.74281 11.6192 4.40574C11.6165 4.40237 11.6114 4.3963 11.6038 4.38822C11.5796 4.36258 11.5306 4.31723 11.4504 4.27242C11.3034 4.19034 10.9826 4.07111 10.3852 4.18074C9.97732 4.2556 9.76612 4.51481 9.63605 4.84771C9.56976 5.01737 9.53447 5.18769 9.51652 5.31897C9.50772 5.38326 9.50355 5.4347 9.50161 5.46746C9.50064 5.48375 9.50023 5.49514 9.50007 5.50088L9.5 5.50385V6.74998C9.5 7.30227 9.94771 7.74998 10.5 7.74998H10.75C11.216 7.74998 11.6075 7.4313 11.7185 7H11.25C10.8358 7 10.5 6.66421 10.5 6.25C10.5 5.83579 10.8358 5.5 11.25 5.5H12.4912L12.5 5.49995C12.9142 5.49995 13.25 5.83574 13.25 6.24995V6.74998C13.25 8.13069 12.1307 9.24998 10.75 9.24998H10.5C9.11929 9.24998 8 8.13069 8 6.74998V5.49871L8 5.49722L8.00002 5.49373L8.00011 5.48475L8.00066 5.45902C8.00123 5.43853 8.00229 5.41137 8.00425 5.37841C8.00816 5.31266 8.01571 5.22275 8.03035 5.1157C8.05927 4.90431 8.11772 4.612 8.23891 4.30182C8.4838 3.67506 9.02252 2.90578 10.1145 2.70538C11.0269 2.53793 11.7062 2.69718 12.1818 2.96285C12.4129 3.09193 12.5808 3.23776 12.6958 3.35986C12.7532 3.42082 12.7976 3.47604 12.8304 3.52071C12.8468 3.54307 12.8604 3.56289 12.8714 3.57958C12.8769 3.58793 12.8817 3.59551 12.8859 3.60226L12.8917 3.61175L12.8942 3.61601L12.8954 3.61802L12.896 3.61899ZM4.49339 4.56511C4.49075 4.56741 4.46669 4.58837 4.43599 4.6103C4.09893 4.85106 3.63051 4.77299 3.38976 4.43593C3.149 4.09887 3.22707 3.63046 3.56413 3.3897C3.4857 3.44572 4.19776 2.75 5.25006 2.75C6.31378 2.75 6.9896 3.4725 7.19009 4.25916C7.32568 4.79117 7.26175 5.4025 6.93217 5.90123C6.90985 5.93501 6.88653 5.96794 6.86222 6.00001C7.16789 6.40252 7.28252 6.89472 7.25219 7.35085C7.19143 8.26445 6.5056 9.25 5.25006 9.25C4.71298 9.25 4.28028 9.07909 3.98419 8.91124C3.68967 8.74428 3.49822 8.55766 3.51196 8.56944C3.19747 8.29988 3.16105 7.8264 3.43062 7.51191C3.70018 7.19741 4.17366 7.16099 4.48815 7.43056L4.50167 7.44258C4.57678 7.51021 4.84312 7.75 5.25006 7.75C5.43354 7.75 5.53925 7.68665 5.60808 7.6137C5.68762 7.52938 5.74564 7.39961 5.7555 7.25132C5.76596 7.09394 5.71964 6.96822 5.65638 6.89312C5.60652 6.83391 5.50106 6.75 5.25006 6.75C4.83584 6.75 4.50006 6.41421 4.50006 6C4.50006 5.58579 4.83584 5.25 5.25006 5.25C5.52784 5.25 5.63184 5.14823 5.68074 5.07424C5.74818 4.97219 5.78143 4.80571 5.73655 4.62961C5.70576 4.50879 5.64534 4.41441 5.57379 4.35375C5.50923 4.29901 5.4113 4.25 5.25006 4.25C5.03849 4.25 4.86035 4.31749 4.72505 4.39449C4.65805 4.43263 4.60534 4.47105 4.5693 4.49981C4.55153 4.514 4.53762 4.52598 4.52711 4.53526L4.50966 4.55081L4.49339 4.56511ZM11.75 12C12.1297 12 12.4435 12.2822 12.4932 12.6482L12.5 12.75V20.25C12.5 20.6642 12.1642 21 11.75 21C11.3703 21 11.0565 20.7178 11.0068 20.3518L11 20.25V12.75C11 12.3358 11.3358 12 11.75 12ZM15.75 9C16.1297 9 16.4435 9.28216 16.4932 9.64823L16.5 9.75V20.25C16.5 20.6642 16.1642 21 15.75 21C15.3703 21 15.0565 20.7178 15.0068 20.3518L15 20.25V9.75C15 9.33579 15.3358 9 15.75 9ZM3.75 18C4.1297 18 4.44349 18.2822 4.49315 18.6482L4.5 18.75V20.25C4.5 20.6642 4.16421 21 3.75 21C3.3703 21 3.05651 20.7178 3.00685 20.3518L3 20.25V18.75C3 18.3358 3.33579 18 3.75 18ZM19.7427 6C20.1224 5.99636 20.4389 6.27523 20.4921 6.64051L20.5 6.74213V20.2432C20.504 20.657 20.1715 20.9958 19.7573 20.9999C19.3776 21.0035 19.0611 20.7246 19.0079 20.3593L19 20.2577V6.75667C18.996 6.34281 19.3285 6.00406 19.7427 6ZM7.75 15C8.1297 15 8.44349 15.2822 8.49315 15.6482L8.5 15.75V20.2487C8.5 20.6629 8.16421 20.9987 7.75 20.9987C7.3703 20.9987 7.05651 20.7166 7.00685 20.3505L7 20.2487V15.75C7 15.3358 7.33579 15 7.75 15Z " },
            { FluentSymbol.Cellular4G24Filled, "M12.896 3.61899L12.8965 3.61994C13.1065 3.97703 12.9872 4.43667 12.6301 4.64658C12.2817 4.8514 11.8356 4.74281 11.6192 4.40574C11.6165 4.40237 11.6114 4.3963 11.6038 4.38822C11.5796 4.36258 11.5306 4.31723 11.4504 4.27242C11.3034 4.19034 10.9826 4.07111 10.3852 4.18074C9.97732 4.2556 9.76612 4.51481 9.63605 4.84771C9.56976 5.01737 9.53447 5.18769 9.51652 5.31897C9.50772 5.38326 9.50355 5.4347 9.50161 5.46746C9.50064 5.48375 9.50023 5.49514 9.50007 5.50088L9.5 5.50385V6.74998C9.5 7.30227 9.94771 7.74998 10.5 7.74998H10.75C11.216 7.74998 11.6075 7.4313 11.7185 7H11.25C10.8358 7 10.5 6.66421 10.5 6.25C10.5 5.83579 10.8358 5.5 11.25 5.5H12.4912L12.5 5.49995C12.9142 5.49995 13.25 5.83574 13.25 6.24995V6.74998C13.25 8.13069 12.1307 9.24998 10.75 9.24998H10.5C9.11929 9.24998 8 8.13069 8 6.74998V5.49871L8 5.49722L8.00002 5.49373L8.00011 5.48475L8.00066 5.45902C8.00123 5.43853 8.00229 5.41137 8.00425 5.37841C8.00816 5.31266 8.01571 5.22275 8.03035 5.1157C8.05927 4.90431 8.11772 4.612 8.23891 4.30182C8.4838 3.67506 9.02252 2.90578 10.1145 2.70538C11.0269 2.53793 11.7062 2.69718 12.1818 2.96285C12.4129 3.09193 12.5808 3.23776 12.6958 3.35986C12.7532 3.42082 12.7976 3.47604 12.8304 3.52071C12.8468 3.54307 12.8604 3.56289 12.8714 3.57958C12.8769 3.58793 12.8817 3.59551 12.8859 3.60226L12.8917 3.61175L12.8942 3.61601L12.8954 3.61802L12.896 3.61899ZM4.72803 3.06112C5.32444 2.3369 6.49996 2.75864 6.49996 3.69683V6.49999H6.74996C7.16417 6.49999 7.49996 6.83578 7.49996 7.24999C7.49996 7.66421 7.16417 7.99999 6.74996 7.99999H6.49996V8.49999C6.49996 8.91421 6.16417 9.24999 5.74996 9.24999C5.33575 9.24999 4.99996 8.91421 4.99996 8.49999V7.99999H3.2035C2.18936 7.99999 1.63249 6.81999 2.27719 6.03715L4.72803 3.06112ZM4.99996 6.49999V5.0905L3.8392 6.49999H4.99996ZM20 6C20.5523 6 21 6.44735 21 6.99917V20.0008C21 20.5527 20.5523 21 20 21C19.4477 21 19 20.5527 19 20.0008V6.99917C19 6.44735 19.4477 6 20 6ZM16 9C16.5523 9 17 9.44567 17 9.99543V20.0046C17 20.5543 16.5523 21 16 21C15.4477 21 15 20.5543 15 20.0046V9.99543C15 9.44567 15.4477 9 16 9ZM12 12C12.5523 12 13 12.4477 13 13V20C13 20.5523 12.5523 21 12 21C11.4477 21 11 20.5523 11 20V13C11 12.4477 11.4477 12 12 12ZM8 15C8.55228 15 9 15.4451 9 15.9942V20.0058C9 20.5549 8.55228 21 8 21C7.44772 21 7 20.5549 7 20.0058V15.9942C7 15.4451 7.44772 15 8 15ZM4 18C4.55228 18 5 18.4403 5 18.9836V20.0164C5 20.5597 4.55228 21 4 21C3.44772 21 3 20.5597 3 20.0164V18.9836C3 18.4403 3.44772 18 4 18Z " },
            { FluentSymbol.Cellular4G24, "M12.896 3.61899L12.8965 3.61994C13.1065 3.97703 12.9872 4.43667 12.6301 4.64658C12.2817 4.8514 11.8356 4.74281 11.6192 4.40574C11.6165 4.40237 11.6114 4.3963 11.6038 4.38822C11.5796 4.36258 11.5306 4.31723 11.4504 4.27242C11.3034 4.19034 10.9826 4.07111 10.3852 4.18074C9.97732 4.2556 9.76612 4.51481 9.63605 4.84771C9.56976 5.01737 9.53447 5.18769 9.51652 5.31897C9.50772 5.38326 9.50355 5.4347 9.50161 5.46746C9.50064 5.48375 9.50023 5.49514 9.50007 5.50088L9.5 5.50385V6.74998C9.5 7.30227 9.94771 7.74998 10.5 7.74998H10.75C11.216 7.74998 11.6075 7.4313 11.7185 7H11.25C10.8358 7 10.5 6.66421 10.5 6.25C10.5 5.83579 10.8358 5.5 11.25 5.5H12.4912L12.5 5.49995C12.9142 5.49995 13.25 5.83574 13.25 6.24995V6.74998C13.25 8.13069 12.1307 9.24998 10.75 9.24998H10.5C9.11929 9.24998 8 8.13069 8 6.74998V5.49871L8 5.49722L8.00002 5.49373L8.00011 5.48475L8.00066 5.45902C8.00123 5.43853 8.00229 5.41137 8.00425 5.37841C8.00816 5.31266 8.01571 5.22275 8.03035 5.1157C8.05927 4.90431 8.11772 4.612 8.23891 4.30182C8.4838 3.67506 9.02252 2.90578 10.1145 2.70538C11.0269 2.53793 11.7062 2.69718 12.1818 2.96285C12.4129 3.09193 12.5808 3.23776 12.6958 3.35986C12.7532 3.42082 12.7976 3.47604 12.8304 3.52071C12.8468 3.54307 12.8604 3.56289 12.8714 3.57958C12.8769 3.58793 12.8817 3.59551 12.8859 3.60226L12.8917 3.61175L12.8942 3.61601L12.8954 3.61802L12.896 3.61899ZM4.72803 3.06112C5.32444 2.3369 6.49996 2.75864 6.49996 3.69683V6.49999H6.74996C7.16417 6.49999 7.49996 6.83578 7.49996 7.24999C7.49996 7.66421 7.16417 7.99999 6.74996 7.99999H6.49996V8.49999C6.49996 8.91421 6.16417 9.24999 5.74996 9.24999C5.33575 9.24999 4.99996 8.91421 4.99996 8.49999V7.99999H3.2035C2.18936 7.99999 1.63249 6.81999 2.27719 6.03715L4.72803 3.06112ZM4.99996 6.49999V5.0905L3.8392 6.49999H4.99996ZM11.75 12C12.1297 12 12.4435 12.2822 12.4932 12.6483L12.5 12.75V20.25C12.5 20.6642 12.1642 21 11.75 21C11.3703 21 11.0565 20.7179 11.0068 20.3518L11 20.25V12.75C11 12.3358 11.3358 12 11.75 12ZM15.75 9.00004C16.1297 9.00004 16.4435 9.28219 16.4932 9.64826L16.5 9.75004V20.25C16.5 20.6642 16.1642 21 15.75 21C15.3703 21 15.0565 20.7179 15.0068 20.3518L15 20.25V9.75004C15 9.33582 15.3358 9.00004 15.75 9.00004ZM3.75 18C4.1297 18 4.44349 18.2822 4.49315 18.6483L4.5 18.75V20.25C4.5 20.6642 4.16421 21 3.75 21C3.3703 21 3.05651 20.7179 3.00685 20.3518L3 20.25V18.75C3 18.3358 3.33579 18 3.75 18ZM19.7427 6.00004C20.1224 5.99639 20.4389 6.27526 20.4921 6.64054L20.5 6.74216V20.2432C20.504 20.6571 20.1715 20.9958 19.7573 20.9999C19.3776 21.0035 19.0611 20.7246 19.0079 20.3594L19 20.2577V6.7567C18.996 6.34284 19.3285 6.00409 19.7427 6.00004ZM7.75 15C8.1297 15 8.44349 15.2822 8.49315 15.6483L8.5 15.75V20.2488C8.5 20.663 8.16421 20.9988 7.75 20.9988C7.3703 20.9988 7.05651 20.7166 7.00685 20.3505L7 20.2488V15.75C7 15.3358 7.33579 15 7.75 15Z " },
            { FluentSymbol.CellularData120Filled, "M4.75 12.0001C5.12656 12.0001 5.4383 12.2776 5.49187 12.6393L5.5 12.7501V15.2501C5.5 15.6643 5.16421 16.0001 4.75 16.0001C4.37344 16.0001 4.0617 15.7226 4.00813 15.3609L4 15.2501V12.7501C4 12.3359 4.33579 12.0001 4.75 12.0001ZM7.75 10.0001C8.12656 10.0001 8.4383 10.2776 8.49187 10.6393L8.5 10.7501V15.2501C8.5 15.6643 8.16421 16.0001 7.75 16.0001C7.37344 16.0001 7.0617 15.7226 7.00813 15.3609L7 15.2501V10.7501C7 10.3359 7.33579 10.0001 7.75 10.0001ZM10.75 8.0001C11.1266 8.0001 11.4383 8.27761 11.4919 8.63927L11.5 8.7501V15.2501C11.5 15.6643 11.1642 16.0001 10.75 16.0001C10.3734 16.0001 10.0617 15.7226 10.0081 15.3609L10 15.2501V8.7501C10 8.33588 10.3358 8.0001 10.75 8.0001ZM13.75 6.0001C14.1266 6.0001 14.4383 6.27761 14.4919 6.63927L14.5 6.7501V15.2488C14.5 15.663 14.1642 15.9988 13.75 15.9988C13.3734 15.9988 13.0617 15.7213 13.0081 15.3596L13 15.2488V6.7501C13 6.33588 13.3358 6.0001 13.75 6.0001ZM16.75 4.00003C17.1229 3.99661 17.4344 4.26825 17.4909 4.62563L17.5 4.73523L17.4856 15.2506C17.4896 15.6605 17.1602 15.996 16.75 16.0001C16.3771 16.0036 16.0656 15.7319 16.0091 15.3746L16 15.265L16.0144 4.74963C16.0104 4.33973 16.3398 4.00421 16.75 4.00003Z " },
            { FluentSymbol.CellularData120, "M16.5033 4.00098C16.7488 4.00098 16.953 4.17785 16.9953 4.4111L17.0033 4.50098V15.5012C17.0033 15.7774 16.7795 16.0012 16.5033 16.0012C16.2579 16.0012 16.0537 15.8243 16.0114 15.5911L16.0033 15.5012V4.50098C16.0033 4.22483 16.2272 4.00098 16.5033 4.00098ZM7.50335 9.9999C7.74881 9.9999 7.95296 10.1768 7.99529 10.41L8.00335 10.4999V15.5002C8.00335 15.7763 7.77949 16.0002 7.50335 16.0002C7.25789 16.0002 7.05374 15.8233 7.0114 15.59L7.00335 15.5002V10.4999C7.00335 10.2238 7.22721 9.9999 7.50335 9.9999ZM4.5 12.0002C4.74546 12.0002 4.94961 12.177 4.99194 12.4103L5 12.5002V15.5002C5 15.7763 4.77614 16.0002 4.5 16.0002C4.25454 16.0002 4.05039 15.8233 4.00806 15.59L4 15.5002V12.5002C4 12.224 4.22386 12.0002 4.5 12.0002ZM10.5 7.99769C10.7455 7.99769 10.9496 8.17456 10.9919 8.40781L11 8.49769V15.5002C11 15.7763 10.7761 16.0002 10.5 16.0002C10.2545 16.0002 10.0504 15.8233 10.0081 15.59L10 15.5002V8.49769C10 8.22155 10.2239 7.99769 10.5 7.99769ZM13.5 6.00226C13.7455 6.00226 13.9496 6.17913 13.9919 6.41238L14 6.50226V15.5002C14 15.7763 13.7761 16.0002 13.5 16.0002C13.2545 16.0002 13.0504 15.8233 13.0081 15.59L13 15.5002V6.50226C13 6.22612 13.2239 6.00226 13.5 6.00226Z " },
            { FluentSymbol.CellularData124Filled, "M20 5C20.5523 5 21 5.44735 21 5.99917V19.0008C21 19.5527 20.5523 20 20 20C19.4477 20 19 19.5527 19 19.0008V5.99917C19 5.44735 19.4477 5 20 5ZM16 8C16.5523 8 17 8.44567 17 8.99543V19.0046C17 19.5543 16.5523 20 16 20C15.4477 20 15 19.5543 15 19.0046V8.99543C15 8.44567 15.4477 8 16 8ZM12 11C12.5523 11 13 11.4477 13 12V19C13 19.5523 12.5523 20 12 20C11.4477 20 11 19.5523 11 19V12C11 11.4477 11.4477 11 12 11ZM8 14C8.55228 14 9 14.4451 9 14.9942V19.0058C9 19.5549 8.55228 20 8 20C7.44772 20 7 19.5549 7 19.0058V14.9942C7 14.4451 7.44772 14 8 14ZM4 17C4.55228 17 5 17.4403 5 17.9836V19.0164C5 19.5597 4.55228 20 4 20C3.44772 20 3 19.5597 3 19.0164V17.9836C3 17.4403 3.44772 17 4 17Z " },
            { FluentSymbol.CellularData124, "M3.75 17C4.1297 17 4.44349 17.2822 4.49315 17.6483L4.5 17.75V19.25C4.5 19.6642 4.16421 20 3.75 20C3.3703 20 3.05651 19.7179 3.00685 19.3518L3 19.25V17.75C3 17.3358 3.33579 17 3.75 17ZM11.75 11C12.1297 11 12.4435 11.2822 12.4932 11.6483L12.5 11.75V19.25C12.5 19.6642 12.1642 20 11.75 20C11.3703 20 11.0565 19.7179 11.0068 19.3518L11 19.25V11.75C11 11.3358 11.3358 11 11.75 11ZM15.75 8.00004C16.1297 8.00004 16.4435 8.28219 16.4932 8.64826L16.5 8.75004V19.25C16.5 19.6642 16.1642 20 15.75 20C15.3703 20 15.0565 19.7179 15.0068 19.3518L15 19.25V8.75004C15 8.33582 15.3358 8.00004 15.75 8.00004ZM19.7427 5.00004C20.1224 4.99639 20.4389 5.27526 20.4921 5.64054L20.5 5.74216V19.2432C20.504 19.6571 20.1715 19.9958 19.7573 19.9999C19.3776 20.0035 19.0611 19.7246 19.0079 19.3594L19 19.2577V5.7567C18.996 5.34284 19.3285 5.00409 19.7427 5.00004ZM7.75 14C8.1297 14 8.44349 14.2822 8.49315 14.6483L8.5 14.75V19.2488C8.5 19.663 8.16421 19.9988 7.75 19.9988C7.3703 19.9988 7.05651 19.7166 7.00685 19.3505L7 19.2488V14.75C7 14.3358 7.33579 14 7.75 14Z " },
            { FluentSymbol.CellularData220Filled, "M4.74976 12C5.1262 12 5.43784 12.2774 5.49139 12.639L5.49952 12.7498V15.2451C5.49952 15.6592 5.16384 15.9949 4.74976 15.9949C4.37332 15.9949 4.06168 15.7174 4.00813 15.3559L4 15.2451V12.7498C4 12.3357 4.33568 12 4.74976 12ZM7.74976 10C8.1262 10 8.43784 10.2774 8.49139 10.639L8.49952 10.7498V15.2451C8.49952 15.6592 8.16384 15.9949 7.74976 15.9949C7.37332 15.9949 7.06168 15.7174 7.00813 15.3559L7 15.2451V10.7498C7 10.3357 7.33568 10 7.74976 10ZM10.7498 8C11.1262 8 11.4378 8.27742 11.4914 8.63896L11.4995 8.74976V15.2502C11.4995 15.6643 11.1638 16 10.7498 16C10.3733 16 10.0617 15.7226 10.0081 15.361L10 15.2502V8.74976C10 8.33568 10.3357 8 10.7498 8ZM13.7498 6C14.1262 6 14.4378 6.27742 14.4914 6.63897L14.4995 6.74976V15.2502C14.4995 15.6643 14.1638 16 13.7498 16C13.3733 16 13.0617 15.7226 13.0081 15.361L13 15.2502V6.74976C13 6.33568 13.3357 6 13.7498 6Z " },
            { FluentSymbol.CellularData220, "M7.50335 9.99959C7.74881 9.99959 7.95296 10.1765 7.99529 10.4097L8.00335 10.4996V15.4999C8.00335 15.776 7.77949 15.9999 7.50335 15.9999C7.25789 15.9999 7.05374 15.823 7.0114 15.5897L7.00335 15.4999V10.4996C7.00335 10.2235 7.22721 9.99959 7.50335 9.99959ZM4.5 11.9999C4.74546 11.9999 4.94961 12.1767 4.99194 12.41L5 12.4999V15.4999C5 15.776 4.77614 15.9999 4.5 15.9999C4.25454 15.9999 4.05039 15.823 4.00806 15.5897L4 15.4999V12.4999C4 12.2237 4.22386 11.9999 4.5 11.9999ZM10.5 7.99738C10.7455 7.99738 10.9496 8.17426 10.9919 8.40751L11 8.49738V15.4999C11 15.776 10.7761 15.9999 10.5 15.9999C10.2545 15.9999 10.0504 15.823 10.0081 15.5897L10 15.4999V8.49738C10 8.22124 10.2239 7.99738 10.5 7.99738ZM13.5 6.00195C13.7455 6.00195 13.9496 6.17883 13.9919 6.41208L14 6.50195V15.4999C14 15.776 13.7761 15.9999 13.5 15.9999C13.2545 15.9999 13.0504 15.823 13.0081 15.5897L13 15.4999V6.50195C13 6.22581 13.2239 6.00195 13.5 6.00195Z " },
            { FluentSymbol.CellularData224Filled, "M16 8C16.5523 8 17 8.44567 17 8.99543V19.0046C17 19.5543 16.5523 20 16 20C15.4477 20 15 19.5543 15 19.0046V8.99543C15 8.44567 15.4477 8 16 8ZM12 11C12.5523 11 13 11.4477 13 12V19C13 19.5523 12.5523 20 12 20C11.4477 20 11 19.5523 11 19V12C11 11.4477 11.4477 11 12 11ZM8 14C8.55228 14 9 14.4451 9 14.9942V19.0058C9 19.5549 8.55228 20 8 20C7.44772 20 7 19.5549 7 19.0058V14.9942C7 14.4451 7.44772 14 8 14ZM4 17C4.55228 17 5 17.4403 5 17.9836V19.0164C5 19.5597 4.55228 20 4 20C3.44772 20 3 19.5597 3 19.0164V17.9836C3 17.4403 3.44772 17 4 17Z " },
            { FluentSymbol.CellularData224, "M3.75 17C4.1297 17 4.44349 17.2822 4.49315 17.6482L4.5 17.75V19.25C4.5 19.6642 4.16421 20 3.75 20C3.3703 20 3.05651 19.7178 3.00685 19.3518L3 19.25V17.75C3 17.3358 3.33579 17 3.75 17ZM11.75 11C12.1297 11 12.4435 11.2822 12.4932 11.6482L12.5 11.75V19.25C12.5 19.6642 12.1642 20 11.75 20C11.3703 20 11.0565 19.7178 11.0068 19.3518L11 19.25V11.75C11 11.3358 11.3358 11 11.75 11ZM15.75 8C16.1297 8 16.4435 8.28215 16.4932 8.64823L16.5 8.75V19.25C16.5 19.6642 16.1642 20 15.75 20C15.3703 20 15.0565 19.7178 15.0068 19.3518L15 19.25V8.75C15 8.33579 15.3358 8 15.75 8ZM7.75 14C8.1297 14 8.44349 14.2822 8.49315 14.6482L8.5 14.75V19.2487C8.5 19.6629 8.16421 19.9987 7.75 19.9987C7.3703 19.9987 7.05651 19.7166 7.00685 19.3505L7 19.2487V14.75C7 14.3358 7.33579 14 7.75 14Z " },
            { FluentSymbol.CellularData320Filled, "M4.75 12C5.12656 12 5.4383 12.2775 5.49187 12.6392L5.5 12.75V15.2456C5.5 15.6598 5.16421 15.9956 4.75 15.9956C4.37344 15.9956 4.0617 15.7181 4.00813 15.3564L4 15.2456V12.75C4 12.3358 4.33579 12 4.75 12ZM7.75 10C8.12656 10 8.4383 10.2775 8.49187 10.6392L8.5 10.75V15.2456C8.5 15.6598 8.16421 15.9956 7.75 15.9956C7.37344 15.9956 7.0617 15.7181 7.00813 15.3564L7 15.2456V10.75C7 10.3358 7.33579 10 7.75 10ZM10.75 8C11.1266 8 11.4383 8.27751 11.4919 8.63917L11.5 8.75V15.25C11.5 15.6642 11.1642 16 10.75 16C10.3734 16 10.0617 15.7225 10.0081 15.3608L10 15.25V8.75C10 8.33579 10.3358 8 10.75 8Z " },
            { FluentSymbol.CellularData320, "M7.50335 9.99928C7.74881 9.99928 7.95296 10.1762 7.99529 10.4094L8.00335 10.4993V15.4995C8.00335 15.7757 7.77949 15.9995 7.50335 15.9995C7.25789 15.9995 7.05374 15.8227 7.0114 15.5894L7.00335 15.4995V10.4993C7.00335 10.2231 7.22721 9.99928 7.50335 9.99928ZM4.5 11.9995C4.74546 11.9995 4.94961 12.1764 4.99194 12.4097L5 12.4995V15.4995C5 15.7757 4.77614 15.9995 4.5 15.9995C4.25454 15.9995 4.05039 15.8227 4.00806 15.5894L4 15.4995V12.4995C4 12.2234 4.22386 11.9995 4.5 11.9995ZM10.5 7.99707C10.7455 7.99707 10.9496 8.17395 10.9919 8.4072L11 8.49707V15.4995C11 15.7757 10.7761 15.9995 10.5 15.9995C10.2545 15.9995 10.0504 15.8227 10.0081 15.5894L10 15.4995V8.49707C10 8.22093 10.2239 7.99707 10.5 7.99707Z " },
            { FluentSymbol.CellularData324Filled, "M12 11C12.5523 11 13 11.4477 13 12V19C13 19.5523 12.5523 20 12 20C11.4477 20 11 19.5523 11 19V12C11 11.4477 11.4477 11 12 11ZM8 14C8.55228 14 9 14.4451 9 14.9942V19.0058C9 19.5549 8.55228 20 8 20C7.44772 20 7 19.5549 7 19.0058V14.9942C7 14.4451 7.44772 14 8 14ZM4 17C4.55228 17 5 17.4403 5 17.9836V19.0164C5 19.5597 4.55228 20 4 20C3.44772 20 3 19.5597 3 19.0164V17.9836C3 17.4403 3.44772 17 4 17Z " },
            { FluentSymbol.CellularData324, "M3.75 17C4.1297 17 4.44349 17.2822 4.49315 17.6482L4.5 17.75V19.25C4.5 19.6642 4.16421 20 3.75 20C3.3703 20 3.05651 19.7178 3.00685 19.3518L3 19.25V17.75C3 17.3358 3.33579 17 3.75 17ZM11.75 11C12.1297 11 12.4435 11.2822 12.4932 11.6482L12.5 11.75V19.25C12.5 19.6642 12.1642 20 11.75 20C11.3703 20 11.0565 19.7178 11.0068 19.3518L11 19.25V11.75C11 11.3358 11.3358 11 11.75 11ZM7.75 14C8.1297 14 8.44349 14.2822 8.49315 14.6482L8.5 14.75V19.2487C8.5 19.6629 8.16421 19.9987 7.75 19.9987C7.3703 19.9987 7.05651 19.7166 7.00685 19.3505L7 19.2487V14.75C7 14.3358 7.33579 14 7.75 14Z " },
            { FluentSymbol.CellularData420Filled, "M4.75 12C5.12656 12 5.4383 12.2775 5.49187 12.6392L5.5 12.75V15.25C5.5 15.6642 5.16421 16 4.75 16C4.37344 16 4.0617 15.7225 4.00813 15.3608L4 15.25V12.75C4 12.3358 4.33579 12 4.75 12ZM7.75 10C8.12656 10 8.4383 10.2775 8.49187 10.6392L8.5 10.75V15.25C8.5 15.6642 8.16421 16 7.75 16C7.37344 16 7.0617 15.7225 7.00813 15.3608L7 15.25V10.75C7 10.3358 7.33579 10 7.75 10Z " },
            { FluentSymbol.CellularData420, "M7.50335 10C7.74881 10 7.95296 10.1769 7.99529 10.4101L8.00335 10.5V15.5003C8.00335 15.7764 7.77949 16.0003 7.50335 16.0003C7.25789 16.0003 7.05374 15.8234 7.0114 15.5901L7.00335 15.5003V10.5C7.00335 10.2239 7.22721 10 7.50335 10ZM4.5 12.0003C4.74546 12.0003 4.94961 12.1771 4.99194 12.4104L5 12.5003V15.5003C5 15.7764 4.77614 16.0003 4.5 16.0003C4.25454 16.0003 4.05039 15.8234 4.00806 15.5901L4 15.5003V12.5003C4 12.2241 4.22386 12.0003 4.5 12.0003Z " },
            { FluentSymbol.CellularData424Filled, "M8 14C8.55228 14 9 14.4451 9 14.9942V19.0058C9 19.5549 8.55228 20 8 20C7.44772 20 7 19.5549 7 19.0058V14.9942C7 14.4451 7.44772 14 8 14ZM4 17C4.55228 17 5 17.4403 5 17.9836V19.0164C5 19.5597 4.55228 20 4 20C3.44772 20 3 19.5597 3 19.0164V17.9836C3 17.4403 3.44772 17 4 17Z " },
            { FluentSymbol.CellularData424, "M3.75 17C4.1297 17 4.44349 17.2822 4.49315 17.6482L4.5 17.75V19.25C4.5 19.6642 4.16421 20 3.75 20C3.3703 20 3.05651 19.7178 3.00685 19.3518L3 19.25V17.75C3 17.3358 3.33579 17 3.75 17ZM7.75 14C8.1297 14 8.44349 14.2822 8.49315 14.6482L8.5 14.75V19.2487C8.5 19.6629 8.16421 19.9987 7.75 19.9987C7.3703 19.9987 7.05651 19.7166 7.00685 19.3505L7 19.2487V14.75C7 14.3358 7.33579 14 7.75 14Z " },
            { FluentSymbol.CellularData520Filled, "M4.75037 12C5.12711 12 5.439 12.2776 5.4926 12.6395L5.50073 12.7504V15.2528C5.50073 15.6673 5.16478 16.0032 4.75037 16.0032C4.37362 16.0032 4.06173 15.7256 4.00814 15.3637L4 15.2528V12.7504C4 12.336 4.33595 12 4.75037 12Z " },
            { FluentSymbol.CellularData520, "M4.5 12C4.74546 12 4.94961 12.1769 4.99194 12.4101L5 12.5V15.5C5 15.7761 4.77614 16 4.5 16C4.25454 16 4.05039 15.8231 4.00806 15.5899L4 15.5V12.5C4 12.2239 4.22386 12 4.5 12Z " },
            { FluentSymbol.CellularData524Filled, "M4 17C4.55228 17 5 17.4403 5 17.9836V19.0164C5 19.5597 4.55228 20 4 20C3.44772 20 3 19.5597 3 19.0164V17.9836C3 17.4403 3.44772 17 4 17Z " },
            { FluentSymbol.CellularData524, "M3 17.75V19.25C3 19.6642 3.33579 20 3.75 20C4.16421 20 4.5 19.6642 4.5 19.25V17.75C4.5 17.3358 4.16421 17 3.75 17C3.33579 17 3 17.3358 3 17.75Z " },
            { FluentSymbol.Certificate20Filled, "M4 3C2.89543 3 2 3.89543 2 5V13C2 14.1046 2.89543 15 4 15H11.5V14.3287C11.4145 14.223 11.3336 14.1133 11.2578 14H4C3.44772 14 3 13.5523 3 13V5C3 4.44772 3.44772 4 4 4H16C16.5523 4 17 4.44772 17 5V7.46776C17.3641 7.64868 17.7001 7.87745 18 8.14584V5C18 3.89543 17.1046 3 16 3H4Z M18.5 11.5C18.5 13.433 16.933 15 15 15C13.067 15 11.5 13.433 11.5 11.5C11.5 9.567 13.067 8 15 8C16.933 8 18.5 9.567 18.5 11.5Z M15 16C15.9251 16 16.785 15.7209 17.5 15.2422V18C17.5 18.412 17.0296 18.6472 16.7 18.4L15.3 17.35C15.1222 17.2167 14.8778 17.2167 14.7 17.35L13.3 18.4C12.9704 18.6472 12.5 18.412 12.5 18V15.2422C13.215 15.7209 14.0749 16 15 16Z M5 6.5C5 6.22386 5.22386 6 5.5 6H14.5C14.7761 6 15 6.22386 15 6.5C15 6.77614 14.7761 7 14.5 7H5.5C5.22386 7 5 6.77614 5 6.5Z M5.5 11C5.22386 11 5 11.2239 5 11.5C5 11.7761 5.22386 12 5.5 12H9.5C9.77614 12 10 11.7761 10 11.5C10 11.2239 9.77614 11 9.5 11H5.5Z " },
            { FluentSymbol.Certificate20, "M2 5C2 3.89543 2.89543 3 4 3H16C17.1046 3 18 3.89543 18 5V8.14584C17.7001 7.87745 17.3641 7.64868 17 7.46776V5C17 4.44772 16.5523 4 16 4H4C3.44772 4 3 4.44772 3 5V13C3 13.5523 3.44772 14 4 14H11.2578C11.3336 14.1133 11.4145 14.223 11.5 14.3287V15H4C2.89543 15 2 14.1046 2 13V5Z M18.5 11.5C18.5 12.4538 18.1185 13.3184 17.4998 13.9497L17.5 18C17.5 18.412 17.0296 18.6472 16.7 18.4L15.3 17.35C15.1222 17.2167 14.8778 17.2167 14.7 17.35L13.3 18.4C12.9704 18.6472 12.5 18.412 12.5 18V13.9495C11.8814 13.3182 11.5 12.4537 11.5 11.5C11.5 9.567 13.067 8 15 8C16.933 8 18.5 9.567 18.5 11.5ZM15 15C14.4629 15 13.9549 14.8794 13.5 14.6632V16.75L14.7428 16.0043C14.9011 15.9093 15.0989 15.9093 15.2572 16.0043L16.5 16.75V14.6632C16.0454 14.8792 15.5368 15 15 15ZM15 14C16.3807 14 17.5 12.8807 17.5 11.5C17.5 10.1193 16.3807 9 15 9C13.6193 9 12.5 10.1193 12.5 11.5C12.5 12.8807 13.6193 14 15 14Z M5 6.5C5 6.22386 5.22386 6 5.5 6H14.5C14.7761 6 15 6.22386 15 6.5C15 6.77614 14.7761 7 14.5 7H5.5C5.22386 7 5 6.77614 5 6.5Z M5.5 11C5.22386 11 5 11.2239 5 11.5C5 11.7761 5.22386 12 5.5 12H9.5C9.77614 12 10 11.7761 10 11.5C10 11.2239 9.77614 11 9.5 11H5.5Z " },
            { FluentSymbol.Certificate24Filled, "M14.9996 18.0007C15.8354 18.6288 16.8746 19.001 18.0006 19.001C19.1258 19.001 20.1642 18.6294 20.9997 18.0022L21.0002 21.2484C21.0002 21.8192 20.3957 22.1678 19.9101 21.9173L19.8206 21.8632L18.0003 20.5909L16.1806 21.8632C15.7127 22.1901 15.0807 21.8943 15.008 21.3527L15.0011 21.2484L14.9996 18.0007ZM19.25 3.00391C20.7125 3.00391 21.9084 4.14561 21.995 5.58638L22 5.75391L22.0014 10.9998C21.5971 10.4616 21.0867 10.0076 20.5013 9.66887L20.5 5.75391C20.5 5.1067 20.0081 4.57437 19.3778 4.51036L19.25 4.50391H4.75C4.10279 4.50391 3.57047 4.99578 3.50645 5.6261L3.5 5.75391V15.2539C3.5 15.9011 3.99187 16.4334 4.62219 16.4975L4.75 16.5039L13.6709 16.504C13.7707 16.6762 13.8805 16.842 13.9995 17.0004L14 18.0039H4.75C3.28747 18.0039 2.0916 16.8622 2.00502 15.4214L2 15.2539V5.75391C2 4.29137 3.1417 3.0955 4.58248 3.00892L4.75 3.00391H19.25ZM18.0006 9.9997C20.2101 9.9997 22.0013 11.7909 22.0013 14.0003C22.0013 16.2098 20.2101 18.001 18.0006 18.001C15.7911 18.001 14 16.2098 14 14.0003C14 11.7909 15.7911 9.9997 18.0006 9.9997ZM11.25 12.4997C11.6642 12.4997 12 12.8355 12 13.2497C12 13.6294 11.7178 13.9432 11.3518 13.9929L11.25 13.9997H6.75C6.33579 13.9997 6 13.6639 6 13.2497C6 12.87 6.28215 12.5562 6.64823 12.5065L6.75 12.4997H11.25ZM17.25 6.9997C17.6642 6.9997 18 7.33549 18 7.7497C18 8.1294 17.7178 8.44319 17.3518 8.49286L17.25 8.4997H6.75C6.33579 8.4997 6 8.16392 6 7.7497C6 7.37001 6.28215 7.05621 6.64823 7.00655L6.75 6.9997H17.25Z " },
            { FluentSymbol.Certificate24, "M18.0006 9.9997C20.2101 9.9997 22.0013 11.7909 22.0013 14.0003C22.0013 15.0154 21.6232 15.9422 21.0003 16.6475L21.0002 21.2484C21.0002 21.8192 20.3957 22.1678 19.9101 21.9173L19.8206 21.8632L18.0003 20.5909L16.1806 21.8632C15.7127 22.1901 15.0807 21.8943 15.008 21.3527L15.0011 21.2484L15.0001 16.6465C14.3777 15.9413 14 15.0149 14 14.0003C14 11.7909 15.7911 9.9997 18.0006 9.9997ZM19.4994 17.7108C19.0365 17.8979 18.5306 18.001 18.0006 18.001C17.4699 18.001 16.9633 17.8976 16.4999 17.71L16.5003 19.8089L17.5711 19.0618C17.7968 18.9041 18.0878 18.8844 18.3298 19.0027L18.4302 19.0618L19.4993 19.8089L19.4994 17.7108ZM19.25 3.00391C20.7125 3.00391 21.9084 4.14561 21.995 5.58638L22 5.75391L22.0014 10.9998C21.5971 10.4616 21.0867 10.0076 20.5013 9.66887L20.5 5.75391C20.5 5.1067 20.0081 4.57437 19.3778 4.51036L19.25 4.50391H4.75C4.10279 4.50391 3.57047 4.99578 3.50645 5.6261L3.5 5.75391V15.2539C3.5 15.9011 3.99187 16.4334 4.62219 16.4975L4.75 16.5039L13.6716 16.5051L13.7955 16.7076L13.9291 16.9043L14 16.9977L13.999 18.0039H4.75C3.28747 18.0039 2.0916 16.8622 2.00502 15.4214L2 15.2539V5.75391C2 4.29137 3.1417 3.0955 4.58248 3.00892L4.75 3.00391H19.25ZM18.0006 11.4997C16.6196 11.4997 15.5 12.6193 15.5 14.0003C15.5 15.3814 16.6196 16.501 18.0006 16.501C19.3817 16.501 20.5013 15.3814 20.5013 14.0003C20.5013 12.6193 19.3817 11.4997 18.0006 11.4997ZM11.25 12.4997C11.6642 12.4997 12 12.8355 12 13.2497C12 13.6294 11.7178 13.9432 11.3518 13.9929L11.25 13.9997H6.75C6.33579 13.9997 6 13.6639 6 13.2497C6 12.87 6.28215 12.5562 6.64823 12.5065L6.75 12.4997H11.25ZM17.25 6.9997C17.6642 6.9997 18 7.33549 18 7.7497C18 8.1294 17.7178 8.44319 17.3518 8.49286L17.25 8.4997H6.75C6.33579 8.4997 6 8.16392 6 7.7497C6 7.37001 6.28215 7.05621 6.64823 7.00655L6.75 6.9997H17.25Z " },
            { FluentSymbol.Channel20Filled, "M5.5 3C4.46611 3 3.57881 3.6276 3.19828 4.52261C3.29668 4.50772 3.39744 4.5 3.5 4.5C4.60457 4.5 5.5 5.39543 5.5 6.5C5.5 7.60457 4.60457 8.5 3.5 8.5C3.32735 8.5 3.15981 8.47812 3 8.43699V14.5C3 15.8807 4.11929 17 5.5 17H14.5C15.8807 17 17 15.8807 17 14.5V5.5C17 4.11929 15.8807 3 14.5 3H5.5ZM7 8.5C7 8.22386 7.22386 8 7.5 8H12.5C12.7761 8 13 8.22386 13 8.5C13 8.77614 12.7761 9 12.5 9H7.5C7.22386 9 7 8.77614 7 8.5ZM7.5 11H10.5C10.7761 11 11 11.2239 11 11.5C11 11.7761 10.7761 12 10.5 12H7.5C7.22386 12 7 11.7761 7 11.5C7 11.2239 7.22386 11 7.5 11Z M3.5 5.5C3.31786 5.5 3.14709 5.5487 3 5.63378C2.7011 5.80669 2.5 6.12986 2.5 6.5C2.5 6.87014 2.7011 7.19331 3 7.36622C3.14709 7.4513 3.31786 7.5 3.5 7.5C4.05228 7.5 4.5 7.05228 4.5 6.5C4.5 5.94772 4.05228 5.5 3.5 5.5Z " },
            { FluentSymbol.Channel20, "M3.5 5.5C3.31786 5.5 3.14709 5.5487 3 5.63378C2.7011 5.80669 2.5 6.12986 2.5 6.5C2.5 6.87014 2.7011 7.19331 3 7.36622C3.14709 7.4513 3.31786 7.5 3.5 7.5C3.68214 7.5 3.85291 7.4513 4 7.36622C4.2989 7.19331 4.5 6.87014 4.5 6.5C4.5 6.12986 4.2989 5.80669 4 5.63378C3.85291 5.5487 3.68214 5.5 3.5 5.5Z M3.5 4.5C3.39744 4.5 3.29668 4.50772 3.19828 4.52261C3.57881 3.6276 4.46611 3 5.5 3H14.5C15.8807 3 17 4.11929 17 5.5V14.5C17 15.8807 15.8807 17 14.5 17H5.5C4.11929 17 3 15.8807 3 14.5V8.43699C3.15981 8.47812 3.32735 8.5 3.5 8.5C3.67265 8.5 3.84019 8.47812 4 8.43699V14.5C4 15.3284 4.67157 16 5.5 16H14.5C15.3284 16 16 15.3284 16 14.5V5.5C16 4.67157 15.3284 4 14.5 4H5.5C4.98679 4 4.53378 4.25774 4.26334 4.65083C4.02812 4.55363 3.77032 4.5 3.5 4.5Z M7 8.5C7 8.22386 7.22386 8 7.5 8H12.5C12.7761 8 13 8.22386 13 8.5C13 8.77614 12.7761 9 12.5 9H7.5C7.22386 9 7 8.77614 7 8.5Z M7.5 11C7.22386 11 7 11.2239 7 11.5C7 11.7761 7.22386 12 7.5 12H10.5C10.7761 12 11 11.7761 11 11.5C11 11.2239 10.7761 11 10.5 11H7.5Z " },
            { FluentSymbol.Channel28Filled, "M3.00077 7.16804C2.40912 7.44875 2 8.0516 2 8.75C2 9.4481 2.40876 10.0507 3 10.3316C3.22731 10.4396 3.4816 10.5 3.75 10.5C4.7165 10.5 5.5 9.7165 5.5 8.75C5.5 7.7835 4.7165 7 3.75 7C3.48191 7 3.22789 7.06029 3.00077 7.16804Z M3.16838 6.06162C3.35586 6.02125 3.55045 6 3.75 6C5.26878 6 6.5 7.23122 6.5 8.75C6.5 10.2688 5.26878 11.5 3.75 11.5C3.48999 11.5 3.23842 11.4639 3 11.3965V20.75C3 23.0972 4.90279 25 7.25 25H20.75C23.0972 25 25 23.0972 25 20.75V7.25C25 4.90279 23.0972 3 20.75 3H7.25C5.31528 3 3.6825 4.29278 3.16838 6.06162ZM9.75 11H18.25C18.6642 11 19 11.3358 19 11.75C19 12.1642 18.6642 12.5 18.25 12.5H9.75C9.33579 12.5 9 12.1642 9 11.75C9 11.3358 9.33579 11 9.75 11ZM9 15.75C9 15.3358 9.33579 15 9.75 15H15.5C15.9142 15 16.25 15.3358 16.25 15.75C16.25 16.1642 15.9142 16.5 15.5 16.5H9.75C9.33579 16.5 9 16.1642 9 15.75Z " },
            { FluentSymbol.Channel28, "M2 8.75C2 9.4481 2.40876 10.0507 3 10.3316C3.22731 10.4396 3.4816 10.5 3.75 10.5C4.0184 10.5 4.27269 10.4396 4.5 10.3316C5.09124 10.0507 5.5 9.4481 5.5 8.75C5.5 8.05236 5.09178 7.45007 4.50117 7.16896C4.27356 7.06063 4.01886 7 3.75 7C3.48191 7 3.22789 7.06029 3.00077 7.16804C2.40912 7.44875 2 8.0516 2 8.75Z M3 11.3965V20.75C3 23.0972 4.90279 25 7.25 25H20.75C23.0972 25 25 23.0972 25 20.75V7.25C25 4.90279 23.0972 3 20.75 3H7.25C5.31528 3 3.6825 4.29278 3.16838 6.06162C3.35586 6.02125 3.55045 6 3.75 6C4.09067 6 4.41688 6.06195 4.71797 6.17519C5.13648 5.19051 6.1126 4.5 7.25 4.5H20.75C22.2688 4.5 23.5 5.73122 23.5 7.25V20.75C23.5 22.2688 22.2688 23.5 20.75 23.5H7.25C5.73122 23.5 4.5 22.2688 4.5 20.75V11.3965C4.26158 11.4639 4.01001 11.5 3.75 11.5C3.48999 11.5 3.23842 11.4639 3 11.3965Z M9.75 11C9.33579 11 9 11.3358 9 11.75C9 12.1642 9.33579 12.5 9.75 12.5H18.25C18.6642 12.5 19 12.1642 19 11.75C19 11.3358 18.6642 11 18.25 11H9.75Z M9 15.75C9 15.3358 9.33579 15 9.75 15H15.5C15.9142 15 16.25 15.3358 16.25 15.75C16.25 16.1642 15.9142 16.5 15.5 16.5H9.75C9.33579 16.5 9 16.1642 9 15.75Z " },
            { FluentSymbol.Channel48Filled, "M6 12.4998C5.39278 12.9559 5 13.6821 5 14.5C5 15.3179 5.39278 16.0441 6 16.5002C6.41783 16.814 6.9372 17 7.5 17C8.88071 17 10 15.8807 10 14.5C10 13.1193 8.88071 12 7.5 12C6.9372 12 6.41783 12.186 6 12.4998Z M6.18865 10.7199C6.59946 10.5774 7.04069 10.5 7.5 10.5C9.70914 10.5 11.5 12.2909 11.5 14.5C11.5 16.7091 9.70914 18.5 7.5 18.5C6.96955 18.5 6.46322 18.3967 6 18.2092V35.75C6 39.2018 8.79822 42 12.25 42H35.75C39.2018 42 42 39.2018 42 35.75V12.25C42 8.79822 39.2018 6 35.75 6H12.25C9.32609 6 6.87113 8.00781 6.18865 10.7199ZM16 20.25C16 19.5596 16.5596 19 17.25 19H30.75C31.4404 19 32 19.5596 32 20.25C32 20.9404 31.4404 21.5 30.75 21.5H17.25C16.5596 21.5 16 20.9404 16 20.25ZM17.25 26H26.75C27.4404 26 28 26.5596 28 27.25C28 27.9404 27.4404 28.5 26.75 28.5H17.25C16.5596 28.5 16 27.9404 16 27.25C16 26.5596 16.5596 26 17.25 26Z " },
            { FluentSymbol.Channel48, "M6.18865 10.7199C6.87113 8.00782 9.32609 6 12.25 6H35.75C39.2018 6 42 8.79822 42 12.25V35.75C42 39.2018 39.2018 42 35.75 42H12.25C8.79822 42 6 39.2018 6 35.75V18.2092C6.46322 18.3967 6.96955 18.5 7.5 18.5C7.8453 18.5 8.18038 18.4562 8.5 18.374V35.75C8.5 37.8211 10.1789 39.5 12.25 39.5H35.75C37.8211 39.5 39.5 37.8211 39.5 35.75V12.25C39.5 10.1789 37.8211 8.5 35.75 8.5H12.25C10.7223 8.5 9.40795 9.41354 8.82345 10.7241C8.40921 10.5789 7.96383 10.5 7.5 10.5C7.04069 10.5 6.59946 10.5774 6.18865 10.7199Z M6 12.4998C5.39278 12.9559 5 13.6821 5 14.5C5 15.3179 5.39278 16.0441 6 16.5002C6.41783 16.814 6.9372 17 7.5 17C7.85555 17 8.19377 16.9258 8.5 16.792C9.38295 16.4062 10 15.5252 10 14.5C10 13.4749 9.38306 12.594 8.50023 12.2081C8.19394 12.0743 7.85564 12 7.5 12C6.9372 12 6.41783 12.186 6 12.4998Z M17.25 19C16.5596 19 16 19.5596 16 20.25C16 20.9404 16.5596 21.5 17.25 21.5H30.75C31.4404 21.5 32 20.9404 32 20.25C32 19.5596 31.4404 19 30.75 19H17.25Z M16 27.25C16 26.5596 16.5596 26 17.25 26H26.75C27.4404 26 28 26.5596 28 27.25C28 27.9404 27.4404 28.5 26.75 28.5H17.25C16.5596 28.5 16 27.9404 16 27.25Z " },
            { FluentSymbol.Channel16Filled, "M2.50022 4.55309C2.31804 4.55309 2.14727 4.60189 2.00024 4.68713C1.70233 4.85986 1.50195 5.18221 1.50195 5.55136C1.50195 5.92051 1.70233 6.24287 2.00024 6.41559C2.14727 6.50083 2.31804 6.54963 2.50022 6.54963C3.05155 6.54963 3.49849 6.10269 3.49849 5.55136C3.49849 5.00003 3.05155 4.55309 2.50022 4.55309Z M2.50022 3.55309C2.38955 3.55309 2.28098 3.56209 2.1752 3.57939C2.54182 2.65426 3.44463 2 4.50024 2H11.5002C12.881 2 14.0002 3.11929 14.0002 4.5V11.5C14.0002 12.8807 12.881 14 11.5002 14H4.50024C3.11953 14 2.00024 12.8807 2.00024 11.5V7.48657C2.16004 7.52773 2.32757 7.54963 2.50022 7.54963C3.60383 7.54963 4.49849 6.65497 4.49849 5.55136C4.49849 4.44775 3.60383 3.55309 2.50022 3.55309ZM5.50024 6.5C5.50024 6.77614 5.7241 7 6.00024 7H10.0002C10.2764 7 10.5002 6.77614 10.5002 6.5C10.5002 6.22386 10.2764 6 10.0002 6H6.00024C5.7241 6 5.50024 6.22386 5.50024 6.5ZM5.50024 9.5C5.50024 9.77614 5.7241 10 6.00024 10H8.61415C8.89029 10 9.11415 9.77614 9.11415 9.5C9.11415 9.22386 8.89029 9 8.61415 9H6.00024C5.7241 9 5.50024 9.22386 5.50024 9.5Z " },
            { FluentSymbol.Channel16, "M2.50022 6.54963C2.31804 6.54963 2.14727 6.50083 2.00024 6.41559C1.70233 6.24287 1.50195 5.92051 1.50195 5.55136C1.50195 5.18221 1.70233 4.85986 2.00024 4.68713C2.14727 4.60189 2.31804 4.55309 2.50022 4.55309C2.68242 4.55309 2.85321 4.6019 3.00024 4.68716C3.29814 4.85989 3.49849 5.18223 3.49849 5.55136C3.49849 5.92049 3.29814 6.24283 3.00024 6.41556C2.85321 6.50082 2.68242 6.54963 2.50022 6.54963Z M2.1752 3.57939C2.28098 3.56209 2.38955 3.55309 2.50022 3.55309C2.75994 3.55309 3.00809 3.60264 3.23573 3.6928C3.50223 3.27618 3.96899 3 4.50024 3H11.5002C12.3287 3 13.0002 3.67157 13.0002 4.5V11.5C13.0002 12.3284 12.3287 13 11.5002 13H4.50024C3.67182 13 3.00024 12.3284 3.00024 11.5V7.48656C2.84044 7.52773 2.67289 7.54963 2.50022 7.54963C2.32757 7.54963 2.16004 7.52773 2.00024 7.48657V11.5C2.00024 12.8807 3.11953 14 4.50024 14H11.5002C12.881 14 14.0002 12.8807 14.0002 11.5V4.5C14.0002 3.11929 12.881 2 11.5002 2H4.50024C3.44463 2 2.54182 2.65426 2.1752 3.57939Z M6.00024 6C5.7241 6 5.50024 6.22386 5.50024 6.5C5.50024 6.77614 5.7241 7 6.00024 7H10.0002C10.2764 7 10.5002 6.77614 10.5002 6.5C10.5002 6.22386 10.2764 6 10.0002 6H6.00024Z M6.00024 9C5.7241 9 5.50024 9.22386 5.50024 9.5C5.50024 9.77614 5.7241 10 6.00024 10H8.61415C8.89029 10 9.11415 9.77614 9.11415 9.5C9.11415 9.22386 8.89029 9 8.61415 9H6.00024Z " },
            { FluentSymbol.Channel24Filled, "M17.7501 3C19.545 3 21.0001 4.45507 21.0001 6.25V17.75C21.0001 19.5449 19.545 21 17.7501 21H6.2501C4.45518 21 3.0001 19.5449 3.0001 17.75L2.99981 9.37208C3.23448 9.45505 3.48702 9.5002 3.7501 9.5002C4.9928 9.5002 6.0002 8.4928 6.0002 7.2501C6.0002 6.0074 4.9928 5 3.7501 5C3.56887 5 3.39265 5.02142 3.22383 5.06188C3.69846 3.85467 4.87447 3 6.2501 3H17.7501ZM13.2461 13.0031H8.74786L8.64609 13.0099C8.28002 13.0596 7.99786 13.3734 7.99786 13.7531C7.99786 14.1327 8.28002 14.4465 8.64609 14.4962L8.74786 14.5031H13.2461L13.3479 14.4962C13.714 14.4465 13.9961 14.1327 13.9961 13.7531C13.9961 13.3388 13.6603 13.0031 13.2461 13.0031ZM15.2523 9.49623H8.74786L8.64609 9.50307C8.28002 9.55274 7.99786 9.86653 7.99786 10.2462C7.99786 10.6259 8.28002 10.9397 8.64609 10.9894L8.74786 10.9962H15.2523L15.3541 10.9894C15.7202 10.9397 16.0023 10.6259 16.0023 10.2462C16.0023 9.83201 15.6666 9.49623 15.2523 9.49623ZM3.7501 6C4.44051 6 5.0002 6.55969 5.0002 7.2501C5.0002 7.94051 4.44051 8.5002 3.7501 8.5002C3.05969 8.5002 2.5 7.94051 2.5 7.2501C2.5 6.55969 3.05969 6 3.7501 6Z " },
            { FluentSymbol.Channel24, "M17.7501 3C19.4831 3 20.8993 4.35645 20.995 6.06558L21.0001 6.25V17.75C21.0001 19.483 19.6436 20.8992 17.9345 20.9949L17.7501 21H6.2501C4.51707 21 3.10086 19.6435 3.00525 17.9344L3.0001 17.75L2.99981 9.37208C3.23448 9.45505 3.48702 9.5002 3.7501 9.5002C4.01315 9.5002 4.26566 9.45506 4.50031 9.37211L4.5001 17.75C4.5001 18.6682 5.20721 19.4212 6.10657 19.4942L6.2501 19.5H17.7501C18.6683 19.5 19.4213 18.7929 19.4943 17.8935L19.5001 17.75V6.25C19.5001 5.33183 18.793 4.57881 17.8936 4.5058L17.7501 4.5H6.2501C5.64992 4.5 5.12031 4.80213 4.80507 5.2626C4.49114 5.095 4.13172 5 3.7501 5C3.56887 5 3.39265 5.02142 3.22383 5.06188C3.67711 3.90899 4.77007 3.07762 6.06568 3.00514L6.2501 3H17.7501ZM13.2461 13.0031C13.6603 13.0031 13.9961 13.3388 13.9961 13.7531C13.9961 14.1327 13.714 14.4465 13.3479 14.4962L13.2461 14.5031H8.74786C8.33365 14.5031 7.99786 14.1673 7.99786 13.7531C7.99786 13.3734 8.28002 13.0596 8.64609 13.0099L8.74786 13.0031H13.2461ZM15.2523 9.49623C15.6666 9.49623 16.0023 9.83201 16.0023 10.2462C16.0023 10.6259 15.7202 10.9397 15.3541 10.9894L15.2523 10.9962H8.74786C8.33365 10.9962 7.99786 10.6604 7.99786 10.2462C7.99786 9.86653 8.28002 9.55274 8.64609 9.50307L8.74786 9.49623H15.2523ZM3.7501 6C4.44051 6 5.0002 6.55969 5.0002 7.2501C5.0002 7.94051 4.44051 8.5002 3.7501 8.5002C3.05969 8.5002 2.5 7.94051 2.5 7.2501C2.5 6.55969 3.05969 6 3.7501 6Z " },
            { FluentSymbol.ChannelAdd16Filled, "M1.63 2.28919C1.74927 2.26352 1.87306 2.25 2 2.25C2.9665 2.25 3.75 3.0335 3.75 4C3.75 4.9665 2.9665 5.75 2 5.75C1.82626 5.75 1.65843 5.72468 1.5 5.67753V8C1.5 9.10457 2.39543 10 3.5 10H5.02242C5.27504 7.19675 7.63098 5 10.5 5V3C10.5 1.89543 9.60457 1 8.5 1H3.5C2.64577 1 1.91663 1.53554 1.63 2.28919ZM4 4.5C4 4.22386 4.22386 4 4.5 4H7.5C7.77614 4 8 4.22386 8 4.5C8 4.77614 7.77614 5 7.5 5H4.5C4.22386 5 4 4.77614 4 4.5ZM4.5 7C4.22386 7 4 6.77614 4 6.5C4 6.22386 4.22386 6 4.5 6H6C6.27614 6 6.5 6.22386 6.5 6.5C6.5 6.77614 6.27614 7 6 7H4.5Z M2.75 4C2.75 4.41421 2.41421 4.75 2 4.75C1.58579 4.75 1.25 4.41421 1.25 4C1.25 3.58579 1.58579 3.25 2 3.25C2.41421 3.25 2.75 3.58579 2.75 4Z M15 10.5C15 12.9853 12.9853 15 10.5 15C8.01472 15 6 12.9853 6 10.5C6 8.01472 8.01472 6 10.5 6C12.9853 6 15 8.01472 15 10.5ZM11 8.5C11 8.22386 10.7761 8 10.5 8C10.2239 8 10 8.22386 10 8.5V10H8.5C8.22386 10 8 10.2239 8 10.5C8 10.7761 8.22386 11 8.5 11H10V12.5C10 12.7761 10.2239 13 10.5 13C10.7761 13 11 12.7761 11 12.5V11H12.5C12.7761 11 13 10.7761 13 10.5C13 10.2239 12.7761 10 12.5 10H11V8.5Z " },
            { FluentSymbol.ChannelAdd16, "M2 2.25C1.87306 2.25 1.74927 2.26352 1.63 2.28919C1.91663 1.53554 2.64577 1 3.5 1H8.5C9.60457 1 10.5 1.89543 10.5 3V5C10.1585 5 9.82428 5.03112 9.5 5.09069V3C9.5 2.44772 9.05228 2 8.5 2H3.5C3.17433 2 2.88502 2.15568 2.70243 2.39668C2.48743 2.30235 2.24983 2.25 2 2.25Z M5.20703 9H3.5C2.94772 9 2.5 8.55228 2.5 8V5.67753C2.34157 5.72468 2.17374 5.75 2 5.75C1.82626 5.75 1.65843 5.72468 1.5 5.67753V8C1.5 9.10457 2.39543 10 3.5 10H5.02242C5.05337 9.65659 5.11588 9.32228 5.20703 9Z M4 4.5C4 4.22386 4.22386 4 4.5 4H7.5C7.77614 4 8 4.22386 8 4.5C8 4.77614 7.77614 5 7.5 5H4.5C4.22386 5 4 4.77614 4 4.5Z M4.5 6C4.22386 6 4 6.22386 4 6.5C4 6.77614 4.22386 7 4.5 7H6C6.27614 7 6.5 6.77614 6.5 6.5C6.5 6.22386 6.27614 6 6 6H4.5Z M2.75 4C2.75 4.41421 2.41421 4.75 2 4.75C1.58579 4.75 1.25 4.41421 1.25 4C1.25 3.58579 1.58579 3.25 2 3.25C2.41421 3.25 2.75 3.58579 2.75 4Z M15 10.5C15 12.9853 12.9853 15 10.5 15C8.01472 15 6 12.9853 6 10.5C6 8.01472 8.01472 6 10.5 6C12.9853 6 15 8.01472 15 10.5ZM11 8.5C11 8.22386 10.7761 8 10.5 8C10.2239 8 10 8.22386 10 8.5V10H8.5C8.22386 10 8 10.2239 8 10.5C8 10.7761 8.22386 11 8.5 11H10V12.5C10 12.7761 10.2239 13 10.5 13C10.7761 13 11 12.7761 11 12.5V11H12.5C12.7761 11 13 10.7761 13 10.5C13 10.2239 12.7761 10 12.5 10H11V8.5Z " },
            { FluentSymbol.ChannelAdd20Filled, "M5.5 3C4.46611 3 3.57881 3.6276 3.19828 4.52261C3.29668 4.50772 3.39744 4.5 3.5 4.5C4.60457 4.5 5.5 5.39543 5.5 6.5C5.5 7.60457 4.60457 8.5 3.5 8.5C3.32735 8.5 3.15981 8.47812 3 8.43699V14.5C3 15.8807 4.11929 17 5.5 17H9.59971C9.21628 16.2499 9 15.4002 9 14.5C9 13.5998 9.21628 12.7501 9.59971 12H7.5C7.22386 12 7 11.7761 7 11.5C7 11.2239 7.22386 11 7.5 11H10.2572C11.266 9.7785 12.7921 9 14.5 9C15.4002 9 16.2499 9.21628 17 9.59971V5.5C17 4.11929 15.8807 3 14.5 3H5.5ZM7 8.5C7 8.22386 7.22386 8 7.5 8H12.5C12.7761 8 13 8.22386 13 8.5C13 8.77614 12.7761 9 12.5 9H7.5C7.22386 9 7 8.77614 7 8.5Z M3.5 5.5C3.31786 5.5 3.14709 5.5487 3 5.63378C2.7011 5.80669 2.5 6.12986 2.5 6.5C2.5 6.87014 2.7011 7.19331 3 7.36622C3.14709 7.4513 3.31786 7.5 3.5 7.5C4.05228 7.5 4.5 7.05228 4.5 6.5C4.5 5.94772 4.05228 5.5 3.5 5.5Z M19 14.5C19 16.9853 16.9853 19 14.5 19C12.0147 19 10 16.9853 10 14.5C10 12.0147 12.0147 10 14.5 10C16.9853 10 19 12.0147 19 14.5ZM15 12.5C15 12.2239 14.7761 12 14.5 12C14.2239 12 14 12.2239 14 12.5V14H12.5C12.2239 14 12 14.2239 12 14.5C12 14.7761 12.2239 15 12.5 15H14V16.5C14 16.7761 14.2239 17 14.5 17C14.7761 17 15 16.7761 15 16.5V15H16.5C16.7761 15 17 14.7761 17 14.5C17 14.2239 16.7761 14 16.5 14H15V12.5Z " },
            { FluentSymbol.ChannelAdd20, "M3.5 4.5C3.39744 4.5 3.29668 4.50772 3.19828 4.52261C3.57881 3.6276 4.46611 3 5.5 3H14.5C15.8807 3 17 4.11929 17 5.5V9.59971C16.6832 9.43777 16.3486 9.30564 16 9.20703V5.5C16 4.67157 15.3284 4 14.5 4H5.5C4.98679 4 4.53378 4.25774 4.26334 4.65083C4.02812 4.55363 3.77032 4.5 3.5 4.5Z M9.20703 16C9.30564 16.3486 9.43777 16.6832 9.59971 17H5.5C4.11929 17 3 15.8807 3 14.5V8.43699C3.15981 8.47812 3.32735 8.5 3.5 8.5C3.67265 8.5 3.84019 8.47812 4 8.43699V14.5C4 15.3284 4.67157 16 5.5 16H9.20703Z M9.59971 12C9.78261 11.6422 10.0035 11.3071 10.2572 11H7.5C7.22386 11 7 11.2239 7 11.5C7 11.7761 7.22386 12 7.5 12H9.59971Z M3.5 5.5C3.31786 5.5 3.14709 5.5487 3 5.63378C2.7011 5.80669 2.5 6.12986 2.5 6.5C2.5 6.87014 2.7011 7.19331 3 7.36622C3.14709 7.4513 3.31786 7.5 3.5 7.5C3.68214 7.5 3.85291 7.4513 4 7.36622C4.2989 7.19331 4.5 6.87014 4.5 6.5C4.5 6.12986 4.2989 5.80669 4 5.63378C3.85291 5.5487 3.68214 5.5 3.5 5.5Z M7.5 8C7.22386 8 7 8.22386 7 8.5C7 8.77614 7.22386 9 7.5 9H12.5C12.7761 9 13 8.77614 13 8.5C13 8.22386 12.7761 8 12.5 8H7.5Z M19 14.5C19 16.9853 16.9853 19 14.5 19C12.0147 19 10 16.9853 10 14.5C10 12.0147 12.0147 10 14.5 10C16.9853 10 19 12.0147 19 14.5ZM15 12.5C15 12.2239 14.7761 12 14.5 12C14.2239 12 14 12.2239 14 12.5V14H12.5C12.2239 14 12 14.2239 12 14.5C12 14.7761 12.2239 15 12.5 15H14V16.5C14 16.7761 14.2239 17 14.5 17C14.7761 17 15 16.7761 15 16.5V15H16.5C16.7761 15 17 14.7761 17 14.5C17 14.2239 16.7761 14 16.5 14H15V12.5Z " },
            { FluentSymbol.ChannelAdd24Filled, "M17.7501 3C19.545 3 21.0001 4.45507 21.0001 6.25V12.0219C19.9898 11.375 18.7887 11 17.5 11C15.6551 11 13.9898 11.7686 12.8066 13.0031H8.74786L8.64609 13.0099C8.28002 13.0596 7.99786 13.3734 7.99786 13.7531C7.99786 14.1327 8.28002 14.4465 8.64609 14.4962L8.74786 14.5031H11.7306C11.2638 15.3998 11 16.4191 11 17.5C11 18.7886 11.375 19.9897 12.0218 21H6.2501C4.45518 21 3.0001 19.5449 3.0001 17.75L2.99981 9.37208C3.23448 9.45505 3.48702 9.5002 3.7501 9.5002C4.9928 9.5002 6.0002 8.4928 6.0002 7.2501C6.0002 6.0074 4.9928 5 3.7501 5C3.56887 5 3.39265 5.02142 3.22383 5.06188C3.69846 3.85467 4.87447 3 6.2501 3H17.7501ZM15.2523 9.49623H8.74786L8.64609 9.50307C8.28002 9.55274 7.99786 9.86653 7.99786 10.2462C7.99786 10.6259 8.28002 10.9397 8.64609 10.9894L8.74786 10.9962H15.2523L15.3541 10.9894C15.7202 10.9397 16.0023 10.6259 16.0023 10.2462C16.0023 9.83201 15.6666 9.49623 15.2523 9.49623Z M3.7501 6C4.44051 6 5.0002 6.55969 5.0002 7.2501C5.0002 7.94051 4.44051 8.5002 3.7501 8.5002C3.05969 8.5002 2.5 7.94051 2.5 7.2501C2.5 6.55969 3.05969 6 3.7501 6Z M23 17.5C23 14.4624 20.5376 12 17.5 12C14.4624 12 12 14.4624 12 17.5C12 20.5376 14.4624 23 17.5 23C20.5376 23 23 20.5376 23 17.5ZM18.0006 18L18.0011 20.5035C18.0011 20.7797 17.7773 21.0035 17.5011 21.0035C17.225 21.0035 17.0011 20.7797 17.0011 20.5035L17.0006 18H14.4956C14.2197 18 13.9961 17.7762 13.9961 17.5C13.9961 17.2239 14.2197 17 14.4956 17H17.0005L17 14.4993C17 14.2231 17.2239 13.9993 17.5 13.9993C17.7761 13.9993 18 14.2231 18 14.4993L18.0005 17H20.4966C20.7725 17 20.9961 17.2239 20.9961 17.5C20.9961 17.7762 20.7725 18 20.4966 18H18.0006Z " },
            { FluentSymbol.ChannelAdd24, "M17.7501 3C19.4831 3 20.8993 4.35645 20.995 6.06558L21.0001 6.25V12.0219C20.5369 11.7253 20.0336 11.4859 19.5001 11.3135V6.25C19.5001 5.33183 18.793 4.57881 17.8936 4.5058L17.7501 4.5H6.2501C5.64992 4.5 5.12031 4.80213 4.80507 5.2626C4.49114 5.095 4.13172 5 3.7501 5C3.56887 5 3.39265 5.02142 3.22383 5.06188C3.67711 3.90899 4.77007 3.07762 6.06568 3.00514L6.2501 3H17.7501Z M11.3135 19.5C11.4858 20.0335 11.7253 20.5368 12.0218 21H6.2501C4.51707 21 3.10086 19.6435 3.00525 17.9344L3.0001 17.75L2.99981 9.37208C3.23448 9.45505 3.48702 9.5002 3.7501 9.5002C4.01315 9.5002 4.26566 9.45506 4.50031 9.37211L4.5001 17.75C4.5001 18.6682 5.20721 19.4212 6.10657 19.4942L6.2501 19.5H11.3135Z M11.7306 14.5031C12.0174 13.9521 12.3808 13.4474 12.8066 13.0031H8.74786L8.64609 13.0099C8.28002 13.0596 7.99786 13.3734 7.99786 13.7531C7.99786 14.1673 8.33365 14.5031 8.74786 14.5031H11.7306Z M15.2523 9.49623C15.6666 9.49623 16.0023 9.83201 16.0023 10.2462C16.0023 10.6259 15.7202 10.9397 15.3541 10.9894L15.2523 10.9962H8.74786C8.33365 10.9962 7.99786 10.6604 7.99786 10.2462C7.99786 9.86653 8.28002 9.55274 8.64609 9.50307L8.74786 9.49623H15.2523Z M3.7501 6C4.44051 6 5.0002 6.55969 5.0002 7.2501C5.0002 7.94051 4.44051 8.5002 3.7501 8.5002C3.05969 8.5002 2.5 7.94051 2.5 7.2501C2.5 6.55969 3.05969 6 3.7501 6Z M23 17.5C23 14.4624 20.5376 12 17.5 12C14.4624 12 12 14.4624 12 17.5C12 20.5376 14.4624 23 17.5 23C20.5376 23 23 20.5376 23 17.5ZM18.0006 18L18.0011 20.5035C18.0011 20.7797 17.7773 21.0035 17.5011 21.0035C17.225 21.0035 17.0011 20.7797 17.0011 20.5035L17.0006 18H14.4956C14.2197 18 13.9961 17.7762 13.9961 17.5C13.9961 17.2239 14.2197 17 14.4956 17H17.0005L17 14.4993C17 14.2231 17.2239 13.9993 17.5 13.9993C17.7761 13.9993 18 14.2231 18 14.4993L18.0005 17H20.4966C20.7725 17 20.9961 17.2239 20.9961 17.5C20.9961 17.7762 20.7725 18 20.4966 18H18.0006Z " },
            { FluentSymbol.ChannelAdd28Filled, "M3.16838 6.06162C3.35586 6.02125 3.55045 6 3.75 6C5.26878 6 6.5 7.23122 6.5 8.75C6.5 10.2688 5.26878 11.5 3.75 11.5C3.48999 11.5 3.23842 11.4639 3 11.3965V20.75C3 23.0972 4.90279 25 7.25 25H14.4995C13.5579 23.7465 13 22.1884 13 20.5C13 19.0294 13.4232 17.6577 14.1546 16.5H9.75C9.33579 16.5 9 16.1642 9 15.75C9 15.3358 9.33579 15 9.75 15H15.4009C16.7391 13.7588 18.5309 13 20.5 13C22.1884 13 23.7465 13.5579 25 14.4995V7.25C25 4.90279 23.0972 3 20.75 3H7.25C5.31528 3 3.6825 4.29278 3.16838 6.06162ZM9.75 11H18.25C18.6642 11 19 11.3358 19 11.75C19 12.1642 18.6642 12.5 18.25 12.5H9.75C9.33579 12.5 9 12.1642 9 11.75C9 11.3358 9.33579 11 9.75 11Z M3.00077 7.16804C2.40912 7.44875 2 8.0516 2 8.75C2 9.4481 2.40876 10.0507 3 10.3316C3.22731 10.4396 3.4816 10.5 3.75 10.5C4.7165 10.5 5.5 9.7165 5.5 8.75C5.5 7.7835 4.7165 7 3.75 7C3.48191 7 3.22789 7.06029 3.00077 7.16804Z M27 20.5C27 24.0899 24.0899 27 20.5 27C16.9101 27 14 24.0899 14 20.5C14 16.9101 16.9101 14 20.5 14C24.0899 14 27 16.9101 27 20.5ZM21 16.5C21 16.2239 20.7761 16 20.5 16C20.2239 16 20 16.2239 20 16.5V20H16.5C16.2239 20 16 20.2239 16 20.5C16 20.7761 16.2239 21 16.5 21H20V24.5C20 24.7761 20.2239 25 20.5 25C20.7761 25 21 24.7761 21 24.5V21H24.5C24.7761 21 25 20.7761 25 20.5C25 20.2239 24.7761 20 24.5 20H21V16.5Z " },
            { FluentSymbol.ChannelAdd28, "M3 11.3965V20.75C3 23.0972 4.90279 25 7.25 25H14.4995C14.1527 24.5384 13.858 24.0355 13.6241 23.5H7.25C5.73122 23.5 4.5 22.2688 4.5 20.75V11.3965C4.26158 11.4639 4.01001 11.5 3.75 11.5C3.48999 11.5 3.23842 11.4639 3 11.3965Z M25 7.25V14.4995C24.5384 14.1527 24.0355 13.858 23.5 13.6241V7.25C23.5 5.73122 22.2688 4.5 20.75 4.5H7.25C6.1126 4.5 5.13648 5.19051 4.71797 6.17519C4.41688 6.06195 4.09067 6 3.75 6C3.55045 6 3.35586 6.02125 3.16838 6.06162C3.6825 4.29278 5.31528 3 7.25 3H20.75C23.0972 3 25 4.90279 25 7.25Z M9.75 15H15.4009C14.9235 15.4428 14.5039 15.947 14.1546 16.5H9.75C9.33579 16.5 9 16.1642 9 15.75C9 15.3358 9.33579 15 9.75 15Z M2 8.75C2 9.4481 2.40876 10.0507 3 10.3316C3.22731 10.4396 3.4816 10.5 3.75 10.5C4.0184 10.5 4.27269 10.4396 4.5 10.3316C5.09124 10.0507 5.5 9.4481 5.5 8.75C5.5 8.05236 5.09178 7.45007 4.50117 7.16896C4.27356 7.06063 4.01886 7 3.75 7C3.48191 7 3.22789 7.06029 3.00077 7.16804C2.40912 7.44875 2 8.0516 2 8.75Z M9.75 11C9.33579 11 9 11.3358 9 11.75C9 12.1642 9.33579 12.5 9.75 12.5H18.25C18.6642 12.5 19 12.1642 19 11.75C19 11.3358 18.6642 11 18.25 11H9.75Z M27 20.5C27 24.0899 24.0899 27 20.5 27C16.9101 27 14 24.0899 14 20.5C14 16.9101 16.9101 14 20.5 14C24.0899 14 27 16.9101 27 20.5ZM21 16.5C21 16.2239 20.7761 16 20.5 16C20.2239 16 20 16.2239 20 16.5V20H16.5C16.2239 20 16 20.2239 16 20.5C16 20.7761 16.2239 21 16.5 21H20V24.5C20 24.7761 20.2239 25 20.5 25C20.7761 25 21 24.7761 21 24.5V21H24.5C24.7761 21 25 20.7761 25 20.5C25 20.2239 24.7761 20 24.5 20H21V16.5Z " },
            { FluentSymbol.ChannelAdd48Filled, "M12.25 6C9.32609 6 6.87113 8.00781 6.18865 10.7199C6.59946 10.5774 7.04069 10.5 7.5 10.5C9.70914 10.5 11.5 12.2909 11.5 14.5C11.5 16.7091 9.70914 18.5 7.5 18.5C6.96955 18.5 6.46322 18.3967 6 18.2092V35.75C6 39.2018 8.79822 42 12.25 42H24.0436C22.75 39.9794 22 37.5773 22 35C22 32.6321 22.6331 30.4121 23.7392 28.5H17.25C16.5596 28.5 16 27.9404 16 27.25C16 26.5596 16.5596 26 17.25 26H25.6191C27.985 23.5347 31.3133 22 35 22C37.5773 22 39.9794 22.75 42 24.0436V12.25C42 8.79822 39.2018 6 35.75 6H12.25ZM16 20.25C16 19.5596 16.5596 19 17.25 19H30.75C31.4404 19 32 19.5596 32 20.25C32 20.9404 31.4404 21.5 30.75 21.5H17.25C16.5596 21.5 16 20.9404 16 20.25Z M7.5 12C6.9372 12 6.41783 12.186 6 12.4998C5.39278 12.9559 5 13.6821 5 14.5C5 15.3179 5.39278 16.0441 6 16.5002C6.41783 16.814 6.9372 17 7.5 17C8.88071 17 10 15.8807 10 14.5C10 13.1193 8.88071 12 7.5 12Z M46 35C46 41.0751 41.0751 46 35 46C28.9249 46 24 41.0751 24 35C24 28.9249 28.9249 24 35 24C41.0751 24 46 28.9249 46 35ZM36 28C36 27.4477 35.5523 27 35 27C34.4477 27 34 27.4477 34 28V34H28C27.4477 34 27 34.4477 27 35C27 35.5523 27.4477 36 28 36H34V42C34 42.5523 34.4477 43 35 43C35.5523 43 36 42.5523 36 42V36H42C42.5523 36 43 35.5523 43 35C43 34.4477 42.5523 34 42 34H36V28Z " },
            { FluentSymbol.ChannelAdd48, "M7.5 10.5C7.04069 10.5 6.59946 10.5774 6.18865 10.7199C6.87113 8.00781 9.32609 6 12.25 6H35.75C39.2018 6 42 8.79822 42 12.25V24.0436C41.2196 23.544 40.3823 23.1255 39.5 22.7999V12.25C39.5 10.1789 37.8211 8.5 35.75 8.5H12.25C10.7223 8.5 9.40795 9.41353 8.82345 10.7241C8.40921 10.5789 7.96382 10.5 7.5 10.5Z M22.7999 39.5C23.1255 40.3823 23.544 41.2196 24.0436 42H12.25C8.79822 42 6 39.2018 6 35.75V18.2092C6.46322 18.3967 6.96955 18.5 7.5 18.5C7.8453 18.5 8.18038 18.4562 8.5 18.374V35.75C8.5 37.8211 10.1789 39.5 12.25 39.5H22.7999Z M23.7392 28.5C24.2647 27.5914 24.8971 26.7524 25.6191 26H17.25C16.5596 26 16 26.5596 16 27.25C16 27.9404 16.5596 28.5 17.25 28.5H23.7392Z M7.5 12C6.9372 12 6.41783 12.186 6 12.4998C5.39278 12.9559 5 13.6821 5 14.5C5 15.3179 5.39278 16.0441 6 16.5002C6.41783 16.814 6.9372 17 7.5 17C7.85555 17 8.19377 16.9258 8.5 16.792C9.38295 16.4062 10 15.5252 10 14.5C10 13.4749 9.38306 12.594 8.50023 12.2081C8.19394 12.0743 7.85564 12 7.5 12Z M17.25 19C16.5596 19 16 19.5596 16 20.25C16 20.9404 16.5596 21.5 17.25 21.5H30.75C31.4404 21.5 32 20.9404 32 20.25C32 19.5596 31.4404 19 30.75 19H17.25Z M46 35C46 41.0751 41.0751 46 35 46C28.9249 46 24 41.0751 24 35C24 28.9249 28.9249 24 35 24C41.0751 24 46 28.9249 46 35ZM36 28C36 27.4477 35.5523 27 35 27C34.4477 27 34 27.4477 34 28V34H28C27.4477 34 27 34.4477 27 35C27 35.5523 27.4477 36 28 36H34V42C34 42.5523 34.4477 43 35 43C35.5523 43 36 42.5523 36 42V36H42C42.5523 36 43 35.5523 43 35C43 34.4477 42.5523 34 42 34H36V28Z " },
            { FluentSymbol.ChannelAlert16Filled, "M1.63 2.28919C1.74927 2.26352 1.87306 2.25 2 2.25C2.9665 2.25 3.75 3.0335 3.75 4C3.75 4.9665 2.9665 5.75 2 5.75C1.82626 5.75 1.65843 5.72468 1.5 5.67753V8C1.5 9.10457 2.39543 10 3.5 10H5.02242C5.27504 7.19675 7.63098 5 10.5 5V3C10.5 1.89543 9.60457 1 8.5 1H3.5C2.64577 1 1.91663 1.53554 1.63 2.28919ZM4 4.5C4 4.22386 4.22386 4 4.5 4H7.5C7.77614 4 8 4.22386 8 4.5C8 4.77614 7.77614 5 7.5 5H4.5C4.22386 5 4 4.77614 4 4.5ZM4.5 7C4.22386 7 4 6.77614 4 6.5C4 6.22386 4.22386 6 4.5 6H6C6.27614 6 6.5 6.22386 6.5 6.5C6.5 6.77614 6.27614 7 6 7H4.5Z M2.75 4C2.75 4.41421 2.41421 4.75 2 4.75C1.58579 4.75 1.25 4.41421 1.25 4C1.25 3.58579 1.58579 3.25 2 3.25C2.41421 3.25 2.75 3.58579 2.75 4Z M15 10.5C15 12.9853 12.9853 15 10.5 15C8.01472 15 6 12.9853 6 10.5C6 8.01472 8.01472 6 10.5 6C12.9853 6 15 8.01472 15 10.5ZM12.5 9C12.5 7.89543 11.6046 7 10.5 7C9.39544 7 8.50001 7.89543 8.50001 9V10.7929L8.14646 11.1464C8.00346 11.2894 7.96068 11.5045 8.03807 11.6913C8.11546 11.8782 8.29779 12 8.50001 12H12.5C12.7022 12 12.8846 11.8782 12.962 11.6913C13.0393 11.5045 12.9966 11.2894 12.8536 11.1464L12.5 10.7929V9ZM9.08535 13C9.29127 13.5826 9.84689 14 10.5 14C11.1531 14 11.7087 13.5826 11.9146 13H9.08535Z " },
            { FluentSymbol.ChannelAlert16, "M2 2.25C1.87306 2.25 1.74927 2.26352 1.63 2.28919C1.91663 1.53554 2.64577 1 3.5 1H8.5C9.60457 1 10.5 1.89543 10.5 3V5C10.1585 5 9.82428 5.03112 9.5 5.09069V3C9.5 2.44772 9.05228 2 8.5 2H3.5C3.17433 2 2.88502 2.15568 2.70243 2.39668C2.48743 2.30235 2.24983 2.25 2 2.25Z M5.20703 9H3.5C2.94772 9 2.5 8.55228 2.5 8V5.67753C2.34157 5.72468 2.17374 5.75 2 5.75C1.82626 5.75 1.65843 5.72468 1.5 5.67753V8C1.5 9.10457 2.39543 10 3.5 10H5.02242C5.05337 9.65659 5.11588 9.32228 5.20703 9Z M4 4.5C4 4.22386 4.22386 4 4.5 4H7.5C7.77614 4 8 4.22386 8 4.5C8 4.77614 7.77614 5 7.5 5H4.5C4.22386 5 4 4.77614 4 4.5Z M4.5 6C4.22386 6 4 6.22386 4 6.5C4 6.77614 4.22386 7 4.5 7H6C6.27614 7 6.5 6.77614 6.5 6.5C6.5 6.22386 6.27614 6 6 6H4.5Z M2.75 4C2.75 4.41421 2.41421 4.75 2 4.75C1.58579 4.75 1.25 4.41421 1.25 4C1.25 3.58579 1.58579 3.25 2 3.25C2.41421 3.25 2.75 3.58579 2.75 4Z M15 10.5C15 12.9853 12.9853 15 10.5 15C8.01472 15 6 12.9853 6 10.5C6 8.01472 8.01472 6 10.5 6C12.9853 6 15 8.01472 15 10.5ZM12.5 9C12.5 7.89543 11.6046 7 10.5 7C9.39544 7 8.50001 7.89543 8.50001 9V10.7929L8.14646 11.1464C8.00346 11.2894 7.96068 11.5045 8.03807 11.6913C8.11546 11.8782 8.29779 12 8.50001 12H12.5C12.7022 12 12.8846 11.8782 12.962 11.6913C13.0393 11.5045 12.9966 11.2894 12.8536 11.1464L12.5 10.7929V9ZM9.08535 13C9.29127 13.5826 9.84689 14 10.5 14C11.1531 14 11.7087 13.5826 11.9146 13H9.08535Z " },
            { FluentSymbol.ChannelAlert20Filled, "M5.5 3C4.46611 3 3.57881 3.6276 3.19828 4.52261C3.29668 4.50772 3.39744 4.5 3.5 4.5C4.60457 4.5 5.5 5.39543 5.5 6.5C5.5 7.60457 4.60457 8.5 3.5 8.5C3.32735 8.5 3.15981 8.47812 3 8.43699V14.5C3 15.8807 4.11929 17 5.5 17H9.59971C9.21628 16.2499 9 15.4002 9 14.5C9 13.5998 9.21628 12.7501 9.59971 12H7.5C7.22386 12 7 11.7761 7 11.5C7 11.2239 7.22386 11 7.5 11H10.2572C11.266 9.7785 12.7921 9 14.5 9C15.4002 9 16.2499 9.21628 17 9.59971V5.5C17 4.11929 15.8807 3 14.5 3H5.5ZM7 8.5C7 8.22386 7.22386 8 7.5 8H12.5C12.7761 8 13 8.22386 13 8.5C13 8.77614 12.7761 9 12.5 9H7.5C7.22386 9 7 8.77614 7 8.5Z M3.5 5.5C3.31786 5.5 3.14709 5.5487 3 5.63378C2.7011 5.80669 2.5 6.12986 2.5 6.5C2.5 6.87014 2.7011 7.19331 3 7.36622C3.14709 7.4513 3.31786 7.5 3.5 7.5C4.05228 7.5 4.5 7.05228 4.5 6.5C4.5 5.94772 4.05228 5.5 3.5 5.5Z M19 14.5C19 16.9853 16.9853 19 14.5 19C12.0147 19 10 16.9853 10 14.5C10 12.0147 12.0147 10 14.5 10C16.9853 10 19 12.0147 19 14.5ZM16.5 13C16.5 11.8954 15.6046 11 14.5 11C13.3954 11 12.5 11.8954 12.5 13V14.7929L12.1465 15.1464C12.0035 15.2894 11.9607 15.5045 12.0381 15.6913C12.1155 15.8782 12.2978 16 12.5 16H16.5C16.7022 16 16.8846 15.8782 16.962 15.6913C17.0393 15.5045 16.9966 15.2894 16.8536 15.1464L16.5 14.7929V13ZM13.0854 17C13.2913 17.5826 13.8469 18 14.5 18C15.1531 18 15.7087 17.5826 15.9146 17H13.0854Z " },
            { FluentSymbol.ChannelAlert20, "M3.5 4.5C3.39744 4.5 3.29668 4.50772 3.19828 4.52261C3.57881 3.6276 4.46611 3 5.5 3H14.5C15.8807 3 17 4.11929 17 5.5V9.59971C16.6832 9.43777 16.3486 9.30564 16 9.20703V5.5C16 4.67157 15.3284 4 14.5 4H5.5C4.98679 4 4.53378 4.25774 4.26334 4.65083C4.02812 4.55363 3.77032 4.5 3.5 4.5Z M9.20703 16C9.30564 16.3486 9.43777 16.6832 9.59971 17H5.5C4.11929 17 3 15.8807 3 14.5V8.43699C3.15981 8.47812 3.32735 8.5 3.5 8.5C3.67265 8.5 3.84019 8.47812 4 8.43699V14.5C4 15.3284 4.67157 16 5.5 16H9.20703Z M9.59971 12C9.78261 11.6422 10.0035 11.3071 10.2572 11H7.5C7.22386 11 7 11.2239 7 11.5C7 11.7761 7.22386 12 7.5 12H9.59971Z M3.5 5.5C3.31786 5.5 3.14709 5.5487 3 5.63378C2.7011 5.80669 2.5 6.12986 2.5 6.5C2.5 6.87014 2.7011 7.19331 3 7.36622C3.14709 7.4513 3.31786 7.5 3.5 7.5C3.68214 7.5 3.85291 7.4513 4 7.36622C4.2989 7.19331 4.5 6.87014 4.5 6.5C4.5 6.12986 4.2989 5.80669 4 5.63378C3.85291 5.5487 3.68214 5.5 3.5 5.5Z M7.5 8C7.22386 8 7 8.22386 7 8.5C7 8.77614 7.22386 9 7.5 9H12.5C12.7761 9 13 8.77614 13 8.5C13 8.22386 12.7761 8 12.5 8H7.5Z M19 14.5C19 16.9853 16.9853 19 14.5 19C12.0147 19 10 16.9853 10 14.5C10 12.0147 12.0147 10 14.5 10C16.9853 10 19 12.0147 19 14.5ZM16.5 13C16.5 11.8954 15.6046 11 14.5 11C13.3954 11 12.5 11.8954 12.5 13V14.7929L12.1465 15.1464C12.0035 15.2894 11.9607 15.5045 12.0381 15.6913C12.1155 15.8782 12.2978 16 12.5 16H16.5C16.7022 16 16.8846 15.8782 16.962 15.6913C17.0393 15.5045 16.9966 15.2894 16.8536 15.1464L16.5 14.7929V13ZM13.0854 17C13.2913 17.5826 13.8469 18 14.5 18C15.1531 18 15.7087 17.5826 15.9146 17H13.0854Z " },
            { FluentSymbol.ChannelAlert24Filled, "M17.5001 12C20.5377 12 23.0001 14.4624 23.0001 17.5C23.0001 20.5376 20.5377 23 17.5001 23C14.4625 23 12.0001 20.5376 12.0001 17.5C12.0001 14.4624 14.4625 12 17.5001 12ZM17.7501 3C19.4831 3 20.8993 4.35645 20.995 6.06558L21.0001 6.25L21.0008 12.0223C19.9903 11.3752 18.789 11 17.5001 11C15.6551 11 13.9897 11.7687 12.8066 13.0032L8.74786 13.0031L8.64609 13.0099C8.28002 13.0596 7.99786 13.3734 7.99786 13.7531C7.99786 14.1327 8.28002 14.4465 8.64609 14.4962L8.74786 14.5031L11.7308 14.5029C11.264 15.3997 11.0001 16.419 11.0001 17.5C11.0001 18.7892 11.3754 19.9907 12.0227 21.0012L6.2501 21C4.51707 21 3.10086 19.6435 3.00525 17.9344L3.0001 17.75L2.99981 9.37208C3.23448 9.45505 3.48702 9.5002 3.7501 9.5002C4.9928 9.5002 6.0002 8.4928 6.0002 7.2501C6.0002 6.0074 4.9928 5 3.7501 5C3.56887 5 3.39265 5.02142 3.22383 5.06188C3.67586 3.91215 4.76406 3.0822 6.055 3.00576L6.2501 3H17.7501ZM18.5001 20.0015H16.5001L16.5068 20.1181C16.5646 20.6155 16.9873 21.0015 17.5001 21.0015C18.0524 21.0015 18.5001 20.5538 18.5001 20.0015ZM17.5035 14L17.3361 14.0071C16.3993 14.0924 15.6668 14.7714 15.5272 15.6417L15.5088 15.7972L15.5032 16.0009V17.2936L14.647 18.1475C14.3524 18.4413 14.527 18.9306 14.914 18.9945L15.0001 19.0015H20.0001C20.4159 19.0015 20.6379 18.5324 20.4096 18.2137L20.3537 18.148L19.505 17.2993V15.9469L19.4995 15.8007C19.4229 14.7878 18.5559 14 17.5035 14ZM15.2523 9.49623H8.74786L8.64609 9.50307C8.28002 9.55274 7.99786 9.86653 7.99786 10.2462C7.99786 10.6259 8.28002 10.9397 8.64609 10.9894L8.74786 10.9962H15.2523L15.3541 10.9894C15.7202 10.9397 16.0023 10.6259 16.0023 10.2462C16.0023 9.83201 15.6666 9.49623 15.2523 9.49623ZM3.7501 6C4.44051 6 5.0002 6.55969 5.0002 7.2501C5.0002 7.94051 4.44051 8.5002 3.7501 8.5002C3.05969 8.5002 2.5 7.94051 2.5 7.2501C2.5 6.55969 3.05969 6 3.7501 6Z " },
            { FluentSymbol.ChannelAlert24, "M17.5001 12C20.5377 12 23.0001 14.4624 23.0001 17.5C23.0001 20.5376 20.5377 23 17.5001 23C14.4625 23 12.0001 20.5376 12.0001 17.5C12.0001 14.4624 14.4625 12 17.5001 12ZM4.50031 9.37208L4.5001 17.75C4.5001 18.6682 5.20721 19.4212 6.10657 19.4942L6.2501 19.5L11.3137 19.5004C11.4862 20.0342 11.7259 20.5378 12.0227 21.0012L6.2501 21C4.51707 21 3.10086 19.6435 3.00525 17.9344L3.0001 17.75L2.99981 9.37208C3.23448 9.45505 3.48702 9.5002 3.7501 9.5002C4.01315 9.5002 4.26566 9.45506 4.50031 9.37208ZM18.5001 20.0015H16.5001L16.5068 20.1181C16.5646 20.6155 16.9873 21.0015 17.5001 21.0015C18.0524 21.0015 18.5001 20.5538 18.5001 20.0015ZM17.5035 14L17.3361 14.0071C16.3993 14.0924 15.6668 14.7714 15.5272 15.6417L15.5088 15.7972L15.5032 16.0009V17.2936L14.647 18.1475C14.3524 18.4413 14.527 18.9306 14.914 18.9945L15.0001 19.0015H20.0001C20.4159 19.0015 20.6379 18.5324 20.4096 18.2137L20.3537 18.148L19.505 17.2993V15.9469L19.4995 15.8007C19.4229 14.7878 18.5559 14 17.5035 14ZM12.8066 13.0032C12.3808 13.4475 12.0175 13.9521 11.7308 14.5029L8.74786 14.5031C8.33365 14.5031 7.99786 14.1673 7.99786 13.7531C7.99786 13.3734 8.28002 13.0596 8.64609 13.0099L8.74786 13.0031L12.8066 13.0032ZM17.7501 3C19.4831 3 20.8993 4.35645 20.995 6.06558L21.0001 6.25L21.0008 12.0223C20.5375 11.7256 20.0341 11.486 19.5005 11.3136L19.5001 6.25C19.5001 5.33183 18.793 4.57881 17.8936 4.5058L17.7501 4.5H6.2501C5.64992 4.5 5.12031 4.80213 4.80507 5.2626C4.49114 5.095 4.13172 5 3.7501 5C3.56887 5 3.39265 5.02142 3.22383 5.06188C3.67711 3.90899 4.77007 3.07762 6.06568 3.00514L6.2501 3H17.7501ZM15.2523 9.49623C15.6666 9.49623 16.0023 9.83201 16.0023 10.2462C16.0023 10.6259 15.7202 10.9397 15.3541 10.9894L15.2523 10.9962H8.74786C8.33365 10.9962 7.99786 10.6604 7.99786 10.2462C7.99786 9.86653 8.28002 9.55274 8.64609 9.50307L8.74786 9.49623H15.2523ZM3.7501 6C4.44051 6 5.0002 6.55969 5.0002 7.2501C5.0002 7.94051 4.44051 8.5002 3.7501 8.5002C3.05969 8.5002 2.5 7.94051 2.5 7.2501C2.5 6.55969 3.05969 6 3.7501 6Z " },
            { FluentSymbol.ChannelAlert28Filled, "M3.00077 7.16804C2.40912 7.44875 2 8.0516 2 8.75C2 9.4481 2.40876 10.0507 3 10.3316C3.22731 10.4396 3.4816 10.5 3.75 10.5C4.7165 10.5 5.5 9.7165 5.5 8.75C5.5 7.7835 4.7165 7 3.75 7C3.48191 7 3.22789 7.06029 3.00077 7.16804Z M3.16838 6.06162C3.35586 6.02125 3.55045 6 3.75 6C5.26878 6 6.5 7.23122 6.5 8.75C6.5 10.2688 5.26878 11.5 3.75 11.5C3.48999 11.5 3.23842 11.4639 3 11.3965V20.75C3 23.0972 4.90279 25 7.25 25H14.4995C13.5579 23.7465 13 22.1884 13 20.5C13 19.0294 13.4232 17.6577 14.1546 16.5H9.75C9.33579 16.5 9 16.1642 9 15.75C9 15.3358 9.33579 15 9.75 15H15.4009C16.7391 13.7588 18.5309 13 20.5 13C22.1884 13 23.7465 13.5579 25 14.4995V7.25C25 4.90279 23.0972 3 20.75 3H7.25C5.31528 3 3.6825 4.29278 3.16838 6.06162ZM9.75 11H18.25C18.6642 11 19 11.3358 19 11.75C19 12.1642 18.6642 12.5 18.25 12.5H9.75C9.33579 12.5 9 12.1642 9 11.75C9 11.3358 9.33579 11 9.75 11Z M27 20.5C27 24.0899 24.0899 27 20.5 27C16.9101 27 14 24.0899 14 20.5C14 16.9101 16.9101 14 20.5 14C24.0899 14 27 16.9101 27 20.5ZM20.5 16C19.1193 16 18 17.1193 18 18.5V21.2929L17.1465 22.1464C17.0035 22.2894 16.9607 22.5045 17.0381 22.6913C17.1155 22.8782 17.2978 23 17.5 23H23.5C23.7022 23 23.8846 22.8782 23.962 22.6913C24.0393 22.5045 23.9966 22.2894 23.8536 22.1464L23 21.2929V18.5C23 17.1193 21.8807 16 20.5 16ZM19.0854 24C19.2913 24.5826 19.8469 25 20.5 25C21.1531 25 21.7087 24.5826 21.9146 24H19.0854Z " },
            { FluentSymbol.ChannelAlert28, "M3 11.3965V20.75C3 23.0972 4.90279 25 7.25 25H14.4995C14.1527 24.5384 13.858 24.0355 13.6241 23.5H7.25C5.73122 23.5 4.5 22.2688 4.5 20.75V11.3965C4.26158 11.4639 4.01001 11.5 3.75 11.5C3.48999 11.5 3.23842 11.4639 3 11.3965Z M25 7.25V14.4995C24.5384 14.1527 24.0355 13.858 23.5 13.6241V7.25C23.5 5.73122 22.2688 4.5 20.75 4.5H7.25C6.1126 4.5 5.13648 5.19051 4.71797 6.17519C4.41688 6.06195 4.09067 6 3.75 6C3.55045 6 3.35586 6.02125 3.16838 6.06162C3.6825 4.29278 5.31528 3 7.25 3H20.75C23.0972 3 25 4.90279 25 7.25Z M9.75 15H15.4009C14.9235 15.4428 14.5039 15.947 14.1546 16.5H9.75C9.33579 16.5 9 16.1642 9 15.75C9 15.3358 9.33579 15 9.75 15Z M2 8.75C2 9.4481 2.40876 10.0507 3 10.3316C3.22731 10.4396 3.4816 10.5 3.75 10.5C4.0184 10.5 4.27269 10.4396 4.5 10.3316C5.09124 10.0507 5.5 9.4481 5.5 8.75C5.5 8.05236 5.09178 7.45007 4.50117 7.16896C4.27356 7.06063 4.01886 7 3.75 7C3.48191 7 3.22789 7.06029 3.00077 7.16804C2.40912 7.44875 2 8.0516 2 8.75Z M9.75 11C9.33579 11 9 11.3358 9 11.75C9 12.1642 9.33579 12.5 9.75 12.5H18.25C18.6642 12.5 19 12.1642 19 11.75C19 11.3358 18.6642 11 18.25 11H9.75Z M27 20.5C27 24.0899 24.0899 27 20.5 27C16.9101 27 14 24.0899 14 20.5C14 16.9101 16.9101 14 20.5 14C24.0899 14 27 16.9101 27 20.5ZM20.5 16C19.1193 16 18 17.1193 18 18.5V21.2929L17.1465 22.1464C17.0035 22.2894 16.9607 22.5045 17.0381 22.6913C17.1155 22.8782 17.2978 23 17.5 23H23.5C23.7022 23 23.8846 22.8782 23.962 22.6913C24.0393 22.5045 23.9966 22.2894 23.8536 22.1464L23 21.2929V18.5C23 17.1193 21.8807 16 20.5 16ZM19.0854 24C19.2913 24.5826 19.8469 25 20.5 25C21.1531 25 21.7087 24.5826 21.9146 24H19.0854Z " },
            { FluentSymbol.ChannelAlert48Filled, "M12.25 6C9.32609 6 6.87113 8.00781 6.18865 10.7199C6.59946 10.5774 7.04069 10.5 7.5 10.5C9.70914 10.5 11.5 12.2909 11.5 14.5C11.5 16.7091 9.70914 18.5 7.5 18.5C6.96955 18.5 6.46322 18.3967 6 18.2092V35.75C6 39.2018 8.79822 42 12.25 42H24.0436C22.75 39.9794 22 37.5773 22 35C22 32.6321 22.6331 30.4121 23.7392 28.5H17.25C16.5596 28.5 16 27.9404 16 27.25C16 26.5596 16.5596 26 17.25 26H25.6191C27.985 23.5347 31.3133 22 35 22C37.5773 22 39.9794 22.75 42 24.0436V12.25C42 8.79822 39.2018 6 35.75 6H12.25ZM16 20.25C16 19.5596 16.5596 19 17.25 19H30.75C31.4404 19 32 19.5596 32 20.25C32 20.9404 31.4404 21.5 30.75 21.5H17.25C16.5596 21.5 16 20.9404 16 20.25Z M7.5 12C6.9372 12 6.41783 12.186 6 12.4998C5.39278 12.9559 5 13.6821 5 14.5C5 15.3179 5.39278 16.0441 6 16.5002C6.41783 16.814 6.9372 17 7.5 17C8.88071 17 10 15.8807 10 14.5C10 13.1193 8.88071 12 7.5 12Z M46 35C46 41.0751 41.0751 46 35 46C28.9249 46 24 41.0751 24 35C24 28.9249 28.9249 24 35 24C41.0751 24 46 28.9249 46 35ZM35 28C32.2386 28 30 30.2386 30 33V36.382L29.0528 38.2764C28.9753 38.4314 28.9836 38.6155 29.0747 38.7629C29.1658 38.9103 29.3267 39 29.5 39H40.5C40.6733 39 40.8342 38.9103 40.9253 38.7629C41.0164 38.6155 41.0247 38.4314 40.9472 38.2764L40 36.382V33C40 30.2386 37.7614 28 35 28ZM33 40C33 41.1046 33.8954 42 35 42C36.1046 42 37 41.1046 37 40H33Z " },
            { FluentSymbol.ChannelAlert48, "M7.5 10.5C7.04069 10.5 6.59946 10.5774 6.18865 10.7199C6.87113 8.00781 9.32609 6 12.25 6H35.75C39.2018 6 42 8.79822 42 12.25V24.0436C41.2196 23.544 40.3823 23.1255 39.5 22.7999V12.25C39.5 10.1789 37.8211 8.5 35.75 8.5H12.25C10.7223 8.5 9.40795 9.41353 8.82345 10.7241C8.40921 10.5789 7.96382 10.5 7.5 10.5Z M22.7999 39.5C23.1255 40.3823 23.544 41.2196 24.0436 42H12.25C8.79822 42 6 39.2018 6 35.75V18.2092C6.46322 18.3967 6.96955 18.5 7.5 18.5C7.8453 18.5 8.18038 18.4562 8.5 18.374V35.75C8.5 37.8211 10.1789 39.5 12.25 39.5H22.7999Z M23.7392 28.5C24.2647 27.5914 24.8971 26.7524 25.6191 26H17.25C16.5596 26 16 26.5596 16 27.25C16 27.9404 16.5596 28.5 17.25 28.5H23.7392Z M7.5 12C6.9372 12 6.41783 12.186 6 12.4998C5.39278 12.9559 5 13.6821 5 14.5C5 15.3179 5.39278 16.0441 6 16.5002C6.41783 16.814 6.9372 17 7.5 17C7.85555 17 8.19377 16.9258 8.5 16.792C9.38295 16.4062 10 15.5252 10 14.5C10 13.4749 9.38306 12.594 8.50023 12.2081C8.19394 12.0743 7.85564 12 7.5 12Z M17.25 19C16.5596 19 16 19.5596 16 20.25C16 20.9404 16.5596 21.5 17.25 21.5H30.75C31.4404 21.5 32 20.9404 32 20.25C32 19.5596 31.4404 19 30.75 19H17.25Z M46 35C46 41.0751 41.0751 46 35 46C28.9249 46 24 41.0751 24 35C24 28.9249 28.9249 24 35 24C41.0751 24 46 28.9249 46 35ZM35 28C32.2386 28 30 30.2386 30 33V36.382L29.0528 38.2764C28.9753 38.4314 28.9836 38.6155 29.0747 38.7629C29.1658 38.9103 29.3267 39 29.5 39H40.5C40.6733 39 40.8342 38.9103 40.9253 38.7629C41.0164 38.6155 41.0247 38.4314 40.9472 38.2764L40 36.382V33C40 30.2386 37.7614 28 35 28ZM33 40C33 41.1046 33.8954 42 35 42C36.1046 42 37 41.1046 37 40H33Z " },
            { FluentSymbol.ChannelArrowLeft16Filled, "M2 2.25C1.87306 2.25 1.74927 2.26352 1.63 2.28919C1.91663 1.53554 2.64577 1 3.5 1H8.5C9.60457 1 10.5 1.89543 10.5 3V5C7.63098 5 5.27504 7.19675 5.02242 10H3.5C2.39543 10 1.5 9.10457 1.5 8V5.67753C1.65843 5.72468 1.82626 5.75 2 5.75C2.9665 5.75 3.75 4.9665 3.75 4C3.75 3.0335 2.9665 2.25 2 2.25ZM4.5 4C4.22386 4 4 4.22386 4 4.5C4 4.77614 4.22386 5 4.5 5H7.5C7.77614 5 8 4.77614 8 4.5C8 4.22386 7.77614 4 7.5 4H4.5ZM4 6.5C4 6.77614 4.22386 7 4.5 7H6C6.27614 7 6.5 6.77614 6.5 6.5C6.5 6.22386 6.27614 6 6 6H4.5C4.22386 6 4 6.22386 4 6.5Z M2 4.75C2.41421 4.75 2.75 4.41421 2.75 4C2.75 3.58579 2.41421 3.25 2 3.25C1.58579 3.25 1.25 3.58579 1.25 4C1.25 4.41421 1.58579 4.75 2 4.75Z M15 10.5C15 12.9853 12.9853 15 10.5 15C8.01472 15 6 12.9853 6 10.5C6 8.01472 8.01472 6 10.5 6C12.9853 6 15 8.01472 15 10.5ZM8.14684 10.146L8.14433 10.1486C8.09744 10.196 8.06198 10.2505 8.03794 10.3086C8.01385 10.3667 8.0004 10.4303 8.00001 10.497L8 10.5L8.00001 10.503C8.0004 10.5697 8.01385 10.6333 8.03794 10.6914C8.06234 10.7504 8.09851 10.8056 8.14645 10.8536L10.1464 12.8536C10.3417 13.0488 10.6583 13.0488 10.8536 12.8536C11.0488 12.6583 11.0488 12.3417 10.8536 12.1464L9.70711 11H12.5C12.7761 11 13 10.7761 13 10.5C13 10.2239 12.7761 10 12.5 10H9.70711L10.8536 8.85355C11.0488 8.65829 11.0488 8.34171 10.8536 8.14645C10.6583 7.95118 10.3417 7.95118 10.1464 8.14645L8.14684 10.146Z " },
            { FluentSymbol.ChannelArrowLeft16, "M2 2.25C1.87306 2.25 1.74927 2.26352 1.63 2.28919C1.91663 1.53554 2.64577 1 3.5 1H8.5C9.60457 1 10.5 1.89543 10.5 3V5C10.1585 5 9.82428 5.03112 9.5 5.09069V3C9.5 2.44772 9.05228 2 8.5 2H3.5C3.17433 2 2.88502 2.15568 2.70243 2.39668C2.48743 2.30235 2.24983 2.25 2 2.25Z M5.20703 9H3.5C2.94772 9 2.5 8.55228 2.5 8V5.67753C2.34157 5.72468 2.17374 5.75 2 5.75C1.82626 5.75 1.65843 5.72468 1.5 5.67753V8C1.5 9.10457 2.39543 10 3.5 10H5.02242C5.05337 9.65659 5.11588 9.32228 5.20703 9Z M4.5 4C4.22386 4 4 4.22386 4 4.5C4 4.77614 4.22386 5 4.5 5H7.5C7.77614 5 8 4.77614 8 4.5C8 4.22386 7.77614 4 7.5 4H4.5Z M4.5 6C4.22386 6 4 6.22386 4 6.5C4 6.77614 4.22386 7 4.5 7H6C6.27614 7 6.5 6.77614 6.5 6.5C6.5 6.22386 6.27614 6 6 6H4.5Z M2 4.75C2.41421 4.75 2.75 4.41421 2.75 4C2.75 3.58579 2.41421 3.25 2 3.25C1.58579 3.25 1.25 3.58579 1.25 4C1.25 4.41421 1.58579 4.75 2 4.75Z M15 10.5C15 12.9853 12.9853 15 10.5 15C8.01472 15 6 12.9853 6 10.5C6 8.01472 8.01472 6 10.5 6C12.9853 6 15 8.01472 15 10.5ZM8.14684 10.146L8.14433 10.1486C8.09744 10.196 8.06198 10.2505 8.03794 10.3086C8.01385 10.3667 8.0004 10.4303 8.00001 10.497L8 10.5L8.00001 10.503C8.0004 10.5697 8.01385 10.6333 8.03794 10.6914C8.06234 10.7504 8.09851 10.8056 8.14645 10.8536L10.1464 12.8536C10.3417 13.0488 10.6583 13.0488 10.8536 12.8536C11.0488 12.6583 11.0488 12.3417 10.8536 12.1464L9.70711 11H12.5C12.7761 11 13 10.7761 13 10.5C13 10.2239 12.7761 10 12.5 10H9.70711L10.8536 8.85355C11.0488 8.65829 11.0488 8.34171 10.8536 8.14645C10.6583 7.95118 10.3417 7.95118 10.1464 8.14645L8.14684 10.146Z " },
            { FluentSymbol.ChannelArrowLeft20Filled, "M5.5 3C4.46611 3 3.57881 3.6276 3.19828 4.52261C3.29668 4.50772 3.39744 4.5 3.5 4.5C4.60457 4.5 5.5 5.39543 5.5 6.5C5.5 7.60457 4.60457 8.5 3.5 8.5C3.32735 8.5 3.15981 8.47812 3 8.43699V14.5C3 15.8807 4.11929 17 5.5 17H9.59971C9.21628 16.2499 9 15.4002 9 14.5C9 13.5998 9.21628 12.7501 9.59971 12H7.5C7.22386 12 7 11.7761 7 11.5C7 11.2239 7.22386 11 7.5 11H10.2572C11.266 9.7785 12.7921 9 14.5 9C15.4002 9 16.2499 9.21628 17 9.59971V5.5C17 4.11929 15.8807 3 14.5 3H5.5ZM7 8.5C7 8.22386 7.22386 8 7.5 8H12.5C12.7761 8 13 8.22386 13 8.5C13 8.77614 12.7761 9 12.5 9H7.5C7.22386 9 7 8.77614 7 8.5Z M3.5 5.5C3.31786 5.5 3.14709 5.5487 3 5.63378C2.7011 5.80669 2.5 6.12986 2.5 6.5C2.5 6.87014 2.7011 7.19331 3 7.36622C3.14709 7.4513 3.31786 7.5 3.5 7.5C4.05228 7.5 4.5 7.05228 4.5 6.5C4.5 5.94772 4.05228 5.5 3.5 5.5Z M19 14.5C19 16.9853 16.9853 19 14.5 19C12.0147 19 10 16.9853 10 14.5C10 12.0147 12.0147 10 14.5 10C16.9853 10 19 12.0147 19 14.5ZM12.1468 14.146L12.1443 14.1486C12.0974 14.196 12.062 14.2505 12.0379 14.3086C12.0139 14.3667 12.0004 14.4303 12 14.497L12 14.5L12 14.503C12.0004 14.5697 12.0139 14.6333 12.0379 14.6914C12.0623 14.7504 12.0985 14.8056 12.1464 14.8536L14.1464 16.8536C14.3417 17.0488 14.6583 17.0488 14.8536 16.8536C15.0488 16.6583 15.0488 16.3417 14.8536 16.1464L13.7071 15H16.5C16.7761 15 17 14.7761 17 14.5C17 14.2239 16.7761 14 16.5 14H13.7071L14.8536 12.8536C15.0488 12.6583 15.0488 12.3417 14.8536 12.1464C14.6583 11.9512 14.3417 11.9512 14.1464 12.1464L12.1468 14.146Z " },
            { FluentSymbol.ChannelArrowLeft20, "M3.5 4.5C3.39744 4.5 3.29668 4.50772 3.19828 4.52261C3.57881 3.6276 4.46611 3 5.5 3H14.5C15.8807 3 17 4.11929 17 5.5V9.59971C16.6832 9.43777 16.3486 9.30564 16 9.20703V5.5C16 4.67157 15.3284 4 14.5 4H5.5C4.98679 4 4.53378 4.25774 4.26334 4.65083C4.02812 4.55363 3.77032 4.5 3.5 4.5Z M9.20703 16C9.30564 16.3486 9.43777 16.6832 9.59971 17H5.5C4.11929 17 3 15.8807 3 14.5V8.43699C3.15981 8.47812 3.32735 8.5 3.5 8.5C3.67265 8.5 3.84019 8.47812 4 8.43699V14.5C4 15.3284 4.67157 16 5.5 16H9.20703Z M9.59971 12C9.78261 11.6422 10.0035 11.3071 10.2572 11H7.5C7.22386 11 7 11.2239 7 11.5C7 11.7761 7.22386 12 7.5 12H9.59971Z M3.5 5.5C3.31786 5.5 3.14709 5.5487 3 5.63378C2.7011 5.80669 2.5 6.12986 2.5 6.5C2.5 6.87014 2.7011 7.19331 3 7.36622C3.14709 7.4513 3.31786 7.5 3.5 7.5C3.68214 7.5 3.85291 7.4513 4 7.36622C4.2989 7.19331 4.5 6.87014 4.5 6.5C4.5 6.12986 4.2989 5.80669 4 5.63378C3.85291 5.5487 3.68214 5.5 3.5 5.5Z M7.5 8C7.22386 8 7 8.22386 7 8.5C7 8.77614 7.22386 9 7.5 9H12.5C12.7761 9 13 8.77614 13 8.5C13 8.22386 12.7761 8 12.5 8H7.5Z M19 14.5C19 16.9853 16.9853 19 14.5 19C12.0147 19 10 16.9853 10 14.5C10 12.0147 12.0147 10 14.5 10C16.9853 10 19 12.0147 19 14.5ZM12.1468 14.146L12.1443 14.1486C12.0974 14.196 12.062 14.2505 12.0379 14.3086C12.0139 14.3667 12.0004 14.4303 12 14.497L12 14.5L12 14.503C12.0004 14.5697 12.0139 14.6333 12.0379 14.6914C12.0623 14.7504 12.0985 14.8056 12.1464 14.8536L14.1464 16.8536C14.3417 17.0488 14.6583 17.0488 14.8536 16.8536C15.0488 16.6583 15.0488 16.3417 14.8536 16.1464L13.7071 15H16.5C16.7761 15 17 14.7761 17 14.5C17 14.2239 16.7761 14 16.5 14H13.7071L14.8536 12.8536C15.0488 12.6583 15.0488 12.3417 14.8536 12.1464C14.6583 11.9512 14.3417 11.9512 14.1464 12.1464L12.1468 14.146Z " },
            { FluentSymbol.ChannelArrowLeft24Filled, "M17.5001 12C20.5377 12 23.0001 14.4624 23.0001 17.5C23.0001 20.5376 20.5377 23 17.5001 23C14.4625 23 12.0001 20.5376 12.0001 17.5C12.0001 14.4624 14.4625 12 17.5001 12ZM17.7501 3C19.4831 3 20.8993 4.35645 20.995 6.06558L21.0001 6.25L21.0008 12.0223C19.9903 11.3752 18.789 11 17.5001 11C15.6551 11 13.9897 11.7687 12.8066 13.0032L8.74786 13.0031L8.64609 13.0099C8.28002 13.0596 7.99786 13.3734 7.99786 13.7531C7.99786 14.1327 8.28002 14.4465 8.64609 14.4962L8.74786 14.5031L11.7308 14.5029C11.264 15.3997 11.0001 16.419 11.0001 17.5C11.0001 18.7892 11.3754 19.9907 12.0227 21.0012L6.2501 21C4.51707 21 3.10086 19.6435 3.00525 17.9344L3.0001 17.75L2.99981 9.37208C3.23448 9.45505 3.48702 9.5002 3.7501 9.5002C4.9928 9.5002 6.0002 8.4928 6.0002 7.2501C6.0002 6.0074 4.9928 5 3.7501 5C3.56887 5 3.39265 5.02142 3.22383 5.06188C3.67586 3.91215 4.76406 3.0822 6.055 3.00576L6.2501 3H17.7501ZM16.7193 14.5886L16.6501 14.6464L14.1345 17.1628L14.0938 17.2134L14.0497 17.2901L14.0269 17.3488L14.008 17.4341L14.0056 17.5443L14.0206 17.6296L14.0496 17.7098L14.0835 17.7711L14.1344 17.8371L16.6501 20.3536C16.8453 20.5488 17.1619 20.5488 17.3572 20.3536C17.5307 20.18 17.55 19.9106 17.415 19.7157L17.3572 19.6464L15.7111 18H20.5001C20.7456 18 20.9497 17.8231 20.992 17.5899L21.0001 17.5C21.0001 17.2545 20.8232 17.0504 20.59 17.0081L20.5001 17H15.7111L17.3572 15.3536C17.5307 15.18 17.55 14.9106 17.415 14.7157L17.3572 14.6464C17.1836 14.4729 16.9142 14.4536 16.7193 14.5886ZM15.2523 9.49623H8.74786L8.64609 9.50307C8.28002 9.55274 7.99786 9.86653 7.99786 10.2462C7.99786 10.6259 8.28002 10.9397 8.64609 10.9894L8.74786 10.9962H15.2523L15.3541 10.9894C15.7202 10.9397 16.0023 10.6259 16.0023 10.2462C16.0023 9.83201 15.6666 9.49623 15.2523 9.49623ZM3.7501 6C4.44051 6 5.0002 6.55969 5.0002 7.2501C5.0002 7.94051 4.44051 8.5002 3.7501 8.5002C3.05969 8.5002 2.5 7.94051 2.5 7.2501C2.5 6.55969 3.05969 6 3.7501 6Z " },
            { FluentSymbol.ChannelArrowLeft24, "M17.5001 12C20.5377 12 23.0001 14.4624 23.0001 17.5C23.0001 20.5376 20.5377 23 17.5001 23C14.4625 23 12.0001 20.5376 12.0001 17.5C12.0001 14.4624 14.4625 12 17.5001 12ZM4.50031 9.37208L4.5001 17.75C4.5001 18.6682 5.20721 19.4212 6.10657 19.4942L6.2501 19.5L11.3137 19.5004C11.4862 20.0342 11.7259 20.5378 12.0227 21.0012L6.2501 21C4.51707 21 3.10086 19.6435 3.00525 17.9344L3.0001 17.75L2.99981 9.37208C3.23448 9.45505 3.48702 9.5002 3.7501 9.5002C4.01315 9.5002 4.26566 9.45506 4.50031 9.37208ZM16.7193 14.5886L16.6501 14.6464L14.1345 17.1628L14.0938 17.2134L14.0497 17.2901L14.0269 17.3488L14.008 17.4341L14.0056 17.5443L14.0206 17.6296L14.0496 17.7098L14.0835 17.7711L14.1344 17.8371L16.6501 20.3536C16.8453 20.5488 17.1619 20.5488 17.3572 20.3536C17.5307 20.18 17.55 19.9106 17.415 19.7157L17.3572 19.6464L15.7111 18H20.5001C20.7456 18 20.9497 17.8231 20.992 17.5899L21.0001 17.5C21.0001 17.2545 20.8232 17.0504 20.59 17.0081L20.5001 17H15.7111L17.3572 15.3536C17.5307 15.18 17.55 14.9106 17.415 14.7157L17.3572 14.6464C17.1836 14.4729 16.9142 14.4536 16.7193 14.5886ZM12.8066 13.0032C12.3808 13.4475 12.0175 13.9521 11.7308 14.5029L8.74786 14.5031C8.33365 14.5031 7.99786 14.1673 7.99786 13.7531C7.99786 13.3734 8.28002 13.0596 8.64609 13.0099L8.74786 13.0031L12.8066 13.0032ZM17.7501 3C19.4831 3 20.8993 4.35645 20.995 6.06558L21.0001 6.25L21.0008 12.0223C20.5375 11.7256 20.0341 11.486 19.5005 11.3136L19.5001 6.25C19.5001 5.33183 18.793 4.57881 17.8936 4.5058L17.7501 4.5H6.2501C5.64992 4.5 5.12031 4.80213 4.80507 5.2626C4.49114 5.095 4.13172 5 3.7501 5C3.56887 5 3.39265 5.02142 3.22383 5.06188C3.67711 3.90899 4.77007 3.07762 6.06568 3.00514L6.2501 3H17.7501ZM15.2523 9.49623C15.6666 9.49623 16.0023 9.83201 16.0023 10.2462C16.0023 10.6259 15.7202 10.9397 15.3541 10.9894L15.2523 10.9962H8.74786C8.33365 10.9962 7.99786 10.6604 7.99786 10.2462C7.99786 9.86653 8.28002 9.55274 8.64609 9.50307L8.74786 9.49623H15.2523ZM3.7501 6C4.44051 6 5.0002 6.55969 5.0002 7.2501C5.0002 7.94051 4.44051 8.5002 3.7501 8.5002C3.05969 8.5002 2.5 7.94051 2.5 7.2501C2.5 6.55969 3.05969 6 3.7501 6Z " },
            { FluentSymbol.ChannelArrowLeft28Filled, "M3.00077 7.16804C2.40912 7.44875 2 8.0516 2 8.75C2 9.4481 2.40876 10.0507 3 10.3316C3.22731 10.4396 3.4816 10.5 3.75 10.5C4.7165 10.5 5.5 9.7165 5.5 8.75C5.5 7.7835 4.7165 7 3.75 7C3.48191 7 3.22789 7.06029 3.00077 7.16804Z M3.16838 6.06162C3.35586 6.02125 3.55045 6 3.75 6C5.26878 6 6.5 7.23122 6.5 8.75C6.5 10.2688 5.26878 11.5 3.75 11.5C3.48999 11.5 3.23842 11.4639 3 11.3965V20.75C3 23.0972 4.90279 25 7.25 25H14.4995C13.5579 23.7465 13 22.1884 13 20.5C13 19.0294 13.4232 17.6577 14.1546 16.5H9.75C9.33579 16.5 9 16.1642 9 15.75C9 15.3358 9.33579 15 9.75 15H15.4009C16.7391 13.7588 18.5309 13 20.5 13C22.1884 13 23.7465 13.5579 25 14.4995V7.25C25 4.90279 23.0972 3 20.75 3H7.25C5.31528 3 3.6825 4.29278 3.16838 6.06162ZM9.75 11H18.25C18.6642 11 19 11.3358 19 11.75C19 12.1642 18.6642 12.5 18.25 12.5H9.75C9.33579 12.5 9 12.1642 9 11.75C9 11.3358 9.33579 11 9.75 11Z M27 20.5C27 24.0899 24.0899 27 20.5 27C16.9101 27 14 24.0899 14 20.5C14 16.9101 16.9101 14 20.5 14C24.0899 14 27 16.9101 27 20.5ZM24.5 21C24.7761 21 25 20.7761 25 20.5C25 20.2239 24.7761 20 24.5 20H17.7071L19.8536 17.8536C20.0488 17.6583 20.0488 17.3417 19.8536 17.1464C19.6583 16.9512 19.3417 16.9512 19.1464 17.1464L16.1464 20.1464C16.0985 20.1944 16.0623 20.2496 16.0379 20.3086C16.0139 20.3667 16.0004 20.4303 16 20.497L16 20.5L16 20.503C16.0008 20.63 16.0496 20.7567 16.1464 20.8536L19.1464 23.8536C19.3417 24.0488 19.6583 24.0488 19.8536 23.8536C20.0488 23.6583 20.0488 23.3417 19.8536 23.1464L17.7071 21H24.5Z " },
            { FluentSymbol.ChannelArrowLeft28, "M3 11.3965V20.75C3 23.0972 4.90279 25 7.25 25H14.4995C14.1527 24.5384 13.858 24.0355 13.6241 23.5H7.25C5.73122 23.5 4.5 22.2688 4.5 20.75V11.3965C4.26158 11.4639 4.01001 11.5 3.75 11.5C3.48999 11.5 3.23842 11.4639 3 11.3965Z M25 7.25V14.4995C24.5384 14.1527 24.0355 13.858 23.5 13.6241V7.25C23.5 5.73122 22.2688 4.5 20.75 4.5H7.25C6.1126 4.5 5.13648 5.19051 4.71797 6.17519C4.41688 6.06195 4.09067 6 3.75 6C3.55045 6 3.35586 6.02125 3.16838 6.06162C3.6825 4.29278 5.31528 3 7.25 3H20.75C23.0972 3 25 4.90279 25 7.25Z M9.75 15H15.4009C14.9235 15.4428 14.5039 15.947 14.1546 16.5H9.75C9.33579 16.5 9 16.1642 9 15.75C9 15.3358 9.33579 15 9.75 15Z M2 8.75C2 9.4481 2.40876 10.0507 3 10.3316C3.22731 10.4396 3.4816 10.5 3.75 10.5C4.0184 10.5 4.27269 10.4396 4.5 10.3316C5.09124 10.0507 5.5 9.4481 5.5 8.75C5.5 8.05236 5.09178 7.45007 4.50117 7.16896C4.27356 7.06063 4.01886 7 3.75 7C3.48191 7 3.22789 7.06029 3.00077 7.16804C2.40912 7.44875 2 8.0516 2 8.75Z M9.75 11C9.33579 11 9 11.3358 9 11.75C9 12.1642 9.33579 12.5 9.75 12.5H18.25C18.6642 12.5 19 12.1642 19 11.75C19 11.3358 18.6642 11 18.25 11H9.75Z M27 20.5C27 24.0899 24.0899 27 20.5 27C16.9101 27 14 24.0899 14 20.5C14 16.9101 16.9101 14 20.5 14C24.0899 14 27 16.9101 27 20.5ZM24.5 21C24.7761 21 25 20.7761 25 20.5C25 20.2239 24.7761 20 24.5 20H17.7071L19.8536 17.8536C20.0488 17.6583 20.0488 17.3417 19.8536 17.1464C19.6583 16.9512 19.3417 16.9512 19.1464 17.1464L16.1464 20.1464C16.0985 20.1944 16.0623 20.2496 16.0379 20.3086C16.0139 20.3667 16.0004 20.4303 16 20.497L16 20.5L16 20.503C16.0008 20.63 16.0496 20.7567 16.1464 20.8536L19.1464 23.8536C19.3417 24.0488 19.6583 24.0488 19.8536 23.8536C20.0488 23.6583 20.0488 23.3417 19.8536 23.1464L17.7071 21H24.5Z " },
            { FluentSymbol.ChannelArrowLeft48Filled, "M12.25 6C9.32609 6 6.87113 8.00781 6.18865 10.7199C6.59946 10.5774 7.04069 10.5 7.5 10.5C9.70914 10.5 11.5 12.2909 11.5 14.5C11.5 16.7091 9.70914 18.5 7.5 18.5C6.96955 18.5 6.46322 18.3967 6 18.2092V35.75C6 39.2018 8.79822 42 12.25 42H24.0436C22.75 39.9794 22 37.5773 22 35C22 32.6321 22.6331 30.4121 23.7392 28.5H17.25C16.5596 28.5 16 27.9404 16 27.25C16 26.5596 16.5596 26 17.25 26H25.6191C27.985 23.5347 31.3133 22 35 22C37.5773 22 39.9794 22.75 42 24.0436V12.25C42 8.79822 39.2018 6 35.75 6H12.25ZM16 20.25C16 19.5596 16.5596 19 17.25 19H30.75C31.4404 19 32 19.5596 32 20.25C32 20.9404 31.4404 21.5 30.75 21.5H17.25C16.5596 21.5 16 20.9404 16 20.25Z M7.5 12C6.9372 12 6.41783 12.186 6 12.4998C5.39278 12.9559 5 13.6821 5 14.5C5 15.3179 5.39278 16.0441 6 16.5002C6.41783 16.814 6.9372 17 7.5 17C8.88071 17 10 15.8807 10 14.5C10 13.1193 8.88071 12 7.5 12Z M46 35C46 41.0751 41.0751 46 35 46C28.9249 46 24 41.0751 24 35C24 28.9249 28.9249 24 35 24C41.0751 24 46 28.9249 46 35ZM33.7071 29.2929C33.3166 28.9024 32.6834 28.9024 32.2929 29.2929L27.2929 34.2929C26.9024 34.6834 26.9024 35.3166 27.2929 35.7071L32.2929 40.7071C32.6834 41.0976 33.3166 41.0976 33.7071 40.7071C34.0976 40.3166 34.0976 39.6834 33.7071 39.2929L30.4142 36H42C42.5523 36 43 35.5523 43 35C43 34.4477 42.5523 34 42 34H30.4142L33.7071 30.7071C34.0976 30.3166 34.0976 29.6834 33.7071 29.2929Z " },
            { FluentSymbol.ChannelArrowLeft48, "M7.5 10.5C7.04069 10.5 6.59946 10.5774 6.18865 10.7199C6.87113 8.00781 9.32609 6 12.25 6H35.75C39.2018 6 42 8.79822 42 12.25V24.0436C41.2196 23.544 40.3823 23.1255 39.5 22.7999V12.25C39.5 10.1789 37.8211 8.5 35.75 8.5H12.25C10.7223 8.5 9.40795 9.41353 8.82345 10.7241C8.40921 10.5789 7.96382 10.5 7.5 10.5Z M22.7999 39.5C23.1255 40.3823 23.544 41.2196 24.0436 42H12.25C8.79822 42 6 39.2018 6 35.75V18.2092C6.46322 18.3967 6.96955 18.5 7.5 18.5C7.8453 18.5 8.18038 18.4562 8.5 18.374V35.75C8.5 37.8211 10.1789 39.5 12.25 39.5H22.7999Z M23.7392 28.5C24.2647 27.5914 24.8971 26.7524 25.6191 26H17.25C16.5596 26 16 26.5596 16 27.25C16 27.9404 16.5596 28.5 17.25 28.5H23.7392Z M7.5 12C6.9372 12 6.41783 12.186 6 12.4998C5.39278 12.9559 5 13.6821 5 14.5C5 15.3179 5.39278 16.0441 6 16.5002C6.41783 16.814 6.9372 17 7.5 17C7.85555 17 8.19377 16.9258 8.5 16.792C9.38295 16.4062 10 15.5252 10 14.5C10 13.4749 9.38306 12.594 8.50023 12.2081C8.19394 12.0743 7.85564 12 7.5 12Z M17.25 19C16.5596 19 16 19.5596 16 20.25C16 20.9404 16.5596 21.5 17.25 21.5H30.75C31.4404 21.5 32 20.9404 32 20.25C32 19.5596 31.4404 19 30.75 19H17.25Z M46 35C46 41.0751 41.0751 46 35 46C28.9249 46 24 41.0751 24 35C24 28.9249 28.9249 24 35 24C41.0751 24 46 28.9249 46 35ZM33.7071 29.2929C33.3166 28.9024 32.6834 28.9024 32.2929 29.2929L27.2929 34.2929C26.9024 34.6834 26.9024 35.3166 27.2929 35.7071L32.2929 40.7071C32.6834 41.0976 33.3166 41.0976 33.7071 40.7071C34.0976 40.3166 34.0976 39.6834 33.7071 39.2929L30.4142 36H42C42.5523 36 43 35.5523 43 35C43 34.4477 42.5523 34 42 34H30.4142L33.7071 30.7071C34.0976 30.3166 34.0976 29.6834 33.7071 29.2929Z " },
            { FluentSymbol.ChannelDismiss16Filled, "M1.63 2.28919C1.74927 2.26352 1.87306 2.25 2 2.25C2.9665 2.25 3.75 3.0335 3.75 4C3.75 4.9665 2.9665 5.75 2 5.75C1.82626 5.75 1.65843 5.72468 1.5 5.67753V8C1.5 9.10457 2.39543 10 3.5 10H5.02242C5.27504 7.19675 7.63098 5 10.5 5V3C10.5 1.89543 9.60457 1 8.5 1H3.5C2.64577 1 1.91663 1.53554 1.63 2.28919ZM4 4.5C4 4.22386 4.22386 4 4.5 4H7.5C7.77614 4 8 4.22386 8 4.5C8 4.77614 7.77614 5 7.5 5H4.5C4.22386 5 4 4.77614 4 4.5ZM4.5 7C4.22386 7 4 6.77614 4 6.5C4 6.22386 4.22386 6 4.5 6H6C6.27614 6 6.5 6.22386 6.5 6.5C6.5 6.77614 6.27614 7 6 7H4.5Z M2.75 4C2.75 4.41421 2.41421 4.75 2 4.75C1.58579 4.75 1.25 4.41421 1.25 4C1.25 3.58579 1.58579 3.25 2 3.25C2.41421 3.25 2.75 3.58579 2.75 4Z M15 10.5C15 12.9853 12.9853 15 10.5 15C8.01472 15 6 12.9853 6 10.5C6 8.01472 8.01472 6 10.5 6C12.9853 6 15 8.01472 15 10.5ZM12.3536 9.35355C12.5488 9.15829 12.5488 8.84171 12.3536 8.64645C12.1583 8.45118 11.8417 8.45118 11.6464 8.64645L10.5 9.79289L9.35355 8.64645C9.15829 8.45118 8.84171 8.45118 8.64645 8.64645C8.45118 8.84171 8.45118 9.15829 8.64645 9.35355L9.79289 10.5L8.64645 11.6464C8.45118 11.8417 8.45118 12.1583 8.64645 12.3536C8.84171 12.5488 9.15829 12.5488 9.35355 12.3536L10.5 11.2071L11.6464 12.3536C11.8417 12.5488 12.1583 12.5488 12.3536 12.3536C12.5488 12.1583 12.5488 11.8417 12.3536 11.6464L11.2071 10.5L12.3536 9.35355Z " },
            { FluentSymbol.ChannelDismiss16, "M2 2.25C1.87306 2.25 1.74927 2.26352 1.63 2.28919C1.91663 1.53554 2.64577 1 3.5 1H8.5C9.60457 1 10.5 1.89543 10.5 3V5C10.1585 5 9.82428 5.03112 9.5 5.09069V3C9.5 2.44772 9.05228 2 8.5 2H3.5C3.17433 2 2.88502 2.15568 2.70243 2.39668C2.48743 2.30235 2.24983 2.25 2 2.25Z M5.20703 9H3.5C2.94772 9 2.5 8.55228 2.5 8V5.67753C2.34157 5.72468 2.17374 5.75 2 5.75C1.82626 5.75 1.65843 5.72468 1.5 5.67753V8C1.5 9.10457 2.39543 10 3.5 10H5.02242C5.05337 9.65659 5.11588 9.32228 5.20703 9Z M4 4.5C4 4.22386 4.22386 4 4.5 4H7.5C7.77614 4 8 4.22386 8 4.5C8 4.77614 7.77614 5 7.5 5H4.5C4.22386 5 4 4.77614 4 4.5Z M4.5 6C4.22386 6 4 6.22386 4 6.5C4 6.77614 4.22386 7 4.5 7H6C6.27614 7 6.5 6.77614 6.5 6.5C6.5 6.22386 6.27614 6 6 6H4.5Z M2.75 4C2.75 4.41421 2.41421 4.75 2 4.75C1.58579 4.75 1.25 4.41421 1.25 4C1.25 3.58579 1.58579 3.25 2 3.25C2.41421 3.25 2.75 3.58579 2.75 4Z M15 10.5C15 12.9853 12.9853 15 10.5 15C8.01472 15 6 12.9853 6 10.5C6 8.01472 8.01472 6 10.5 6C12.9853 6 15 8.01472 15 10.5ZM11.2071 10.5L12.3536 9.35355C12.5488 9.15829 12.5488 8.84171 12.3536 8.64645C12.1583 8.45118 11.8417 8.45118 11.6464 8.64645L10.5 9.79289L9.35355 8.64645C9.15829 8.45118 8.84171 8.45118 8.64645 8.64645C8.45118 8.84171 8.45118 9.15829 8.64645 9.35355L9.79289 10.5L8.64645 11.6464C8.45118 11.8417 8.45118 12.1583 8.64645 12.3536C8.84171 12.5488 9.15829 12.5488 9.35355 12.3536L10.5 11.2071L11.6464 12.3536C11.8417 12.5488 12.1583 12.5488 12.3536 12.3536C12.5488 12.1583 12.5488 11.8417 12.3536 11.6464L11.2071 10.5Z " },
            { FluentSymbol.ChannelDismiss20Filled, "M5.5 3C4.46611 3 3.57881 3.6276 3.19828 4.52261C3.29668 4.50772 3.39744 4.5 3.5 4.5C4.60457 4.5 5.5 5.39543 5.5 6.5C5.5 7.60457 4.60457 8.5 3.5 8.5C3.32735 8.5 3.15981 8.47812 3 8.43699V14.5C3 15.8807 4.11929 17 5.5 17H9.59971C9.21628 16.2499 9 15.4002 9 14.5C9 13.5998 9.21628 12.7501 9.59971 12H7.5C7.22386 12 7 11.7761 7 11.5C7 11.2239 7.22386 11 7.5 11H10.2572C11.266 9.7785 12.7921 9 14.5 9C15.4002 9 16.2499 9.21628 17 9.59971V5.5C17 4.11929 15.8807 3 14.5 3H5.5ZM7 8.5C7 8.22386 7.22386 8 7.5 8H12.5C12.7761 8 13 8.22386 13 8.5C13 8.77614 12.7761 9 12.5 9H7.5C7.22386 9 7 8.77614 7 8.5Z M3.5 5.5C3.31786 5.5 3.14709 5.5487 3 5.63378C2.7011 5.80669 2.5 6.12986 2.5 6.5C2.5 6.87014 2.7011 7.19331 3 7.36622C3.14709 7.4513 3.31786 7.5 3.5 7.5C4.05228 7.5 4.5 7.05228 4.5 6.5C4.5 5.94772 4.05228 5.5 3.5 5.5Z M19 14.5C19 16.9853 16.9853 19 14.5 19C12.0147 19 10 16.9853 10 14.5C10 12.0147 12.0147 10 14.5 10C16.9853 10 19 12.0147 19 14.5ZM16.3536 13.3536C16.5488 13.1583 16.5488 12.8417 16.3536 12.6464C16.1583 12.4512 15.8417 12.4512 15.6464 12.6464L14.5 13.7929L13.3536 12.6464C13.1583 12.4512 12.8417 12.4512 12.6464 12.6464C12.4512 12.8417 12.4512 13.1583 12.6464 13.3536L13.7929 14.5L12.6464 15.6464C12.4512 15.8417 12.4512 16.1583 12.6464 16.3536C12.8417 16.5488 13.1583 16.5488 13.3536 16.3536L14.5 15.2071L15.6464 16.3536C15.8417 16.5488 16.1583 16.5488 16.3536 16.3536C16.5488 16.1583 16.5488 15.8417 16.3536 15.6464L15.2071 14.5L16.3536 13.3536Z " },
            { FluentSymbol.ChannelDismiss20, "M3.5 4.5C3.39744 4.5 3.29668 4.50772 3.19828 4.52261C3.57881 3.6276 4.46611 3 5.5 3H14.5C15.8807 3 17 4.11929 17 5.5V9.59971C16.6832 9.43777 16.3486 9.30564 16 9.20703V5.5C16 4.67157 15.3284 4 14.5 4H5.5C4.98679 4 4.53378 4.25774 4.26334 4.65083C4.02812 4.55363 3.77032 4.5 3.5 4.5Z M9.20703 16C9.30564 16.3486 9.43777 16.6832 9.59971 17H5.5C4.11929 17 3 15.8807 3 14.5V8.43699C3.15981 8.47812 3.32735 8.5 3.5 8.5C3.67265 8.5 3.84019 8.47812 4 8.43699V14.5C4 15.3284 4.67157 16 5.5 16H9.20703Z M9.59971 12C9.78261 11.6422 10.0035 11.3071 10.2572 11H7.5C7.22386 11 7 11.2239 7 11.5C7 11.7761 7.22386 12 7.5 12H9.59971Z M3.5 5.5C3.31786 5.5 3.14709 5.5487 3 5.63378C2.7011 5.80669 2.5 6.12986 2.5 6.5C2.5 6.87014 2.7011 7.19331 3 7.36622C3.14709 7.4513 3.31786 7.5 3.5 7.5C3.68214 7.5 3.85291 7.4513 4 7.36622C4.2989 7.19331 4.5 6.87014 4.5 6.5C4.5 6.12986 4.2989 5.80669 4 5.63378C3.85291 5.5487 3.68214 5.5 3.5 5.5Z M7.5 8C7.22386 8 7 8.22386 7 8.5C7 8.77614 7.22386 9 7.5 9H12.5C12.7761 9 13 8.77614 13 8.5C13 8.22386 12.7761 8 12.5 8H7.5Z M19 14.5C19 16.9853 16.9853 19 14.5 19C12.0147 19 10 16.9853 10 14.5C10 12.0147 12.0147 10 14.5 10C16.9853 10 19 12.0147 19 14.5ZM16.3536 13.3536C16.5488 13.1583 16.5488 12.8417 16.3536 12.6464C16.1583 12.4512 15.8417 12.4512 15.6464 12.6464L14.5 13.7929L13.3536 12.6464C13.1583 12.4512 12.8417 12.4512 12.6464 12.6464C12.4512 12.8417 12.4512 13.1583 12.6464 13.3536L13.7929 14.5L12.6464 15.6464C12.4512 15.8417 12.4512 16.1583 12.6464 16.3536C12.8417 16.5488 13.1583 16.5488 13.3536 16.3536L14.5 15.2071L15.6464 16.3536C15.8417 16.5488 16.1583 16.5488 16.3536 16.3536C16.5488 16.1583 16.5488 15.8417 16.3536 15.6464L15.2071 14.5L16.3536 13.3536Z " },
            { FluentSymbol.ChannelDismiss24Filled, "M17.5001 12C20.5377 12 23.0001 14.4624 23.0001 17.5C23.0001 20.5376 20.5377 23 17.5001 23C14.4625 23 12.0001 20.5376 12.0001 17.5C12.0001 14.4624 14.4625 12 17.5001 12ZM17.7501 3C19.4831 3 20.8993 4.35645 20.995 6.06558L21.0001 6.25L21.0008 12.0223C19.9903 11.3752 18.789 11 17.5001 11C15.6551 11 13.9897 11.7687 12.8066 13.0032L8.74786 13.0031L8.64609 13.0099C8.28002 13.0596 7.99786 13.3734 7.99786 13.7531C7.99786 14.1327 8.28002 14.4465 8.64609 14.4962L8.74786 14.5031L11.7308 14.5029C11.264 15.3997 11.0001 16.419 11.0001 17.5C11.0001 18.7892 11.3754 19.9907 12.0227 21.0012L6.2501 21C4.51707 21 3.10086 19.6435 3.00525 17.9344L3.0001 17.75L2.99981 9.37208C3.23448 9.45505 3.48702 9.5002 3.7501 9.5002C4.9928 9.5002 6.0002 8.4928 6.0002 7.2501C6.0002 6.0074 4.9928 5 3.7501 5C3.56887 5 3.39265 5.02142 3.22383 5.06188C3.67586 3.91215 4.76406 3.0822 6.055 3.00576L6.2501 3H17.7501ZM15.0931 14.9663L15.0239 15.0241L14.966 15.0934C14.8479 15.2639 14.8479 15.4915 14.966 15.662L15.0239 15.7312L16.7935 17.5007L15.0265 19.2675L14.9686 19.3367C14.8505 19.5072 14.8505 19.7348 14.9686 19.9053L15.0265 19.9746L15.0957 20.0325C15.2662 20.1506 15.4938 20.1506 15.6643 20.0325L15.7336 19.9746L17.5005 18.2077L19.2695 19.9768L19.3387 20.0347C19.5093 20.1528 19.7368 20.1528 19.9074 20.0347L19.9766 19.9768L20.0345 19.9076C20.1526 19.7371 20.1526 19.5095 20.0345 19.339L19.9766 19.2697L18.2075 17.5007L19.9794 15.7313L20.0372 15.662C20.1553 15.4915 20.1553 15.2639 20.0372 15.0934L19.9794 15.0242L19.9101 14.9663C19.7396 14.8482 19.512 14.8482 19.3415 14.9663L19.2723 15.0242L17.5005 16.7937L15.731 15.0241L15.6618 14.9663C15.5156 14.865 15.3275 14.8506 15.1694 14.9229L15.0931 14.9663ZM15.2523 9.49623H8.74786L8.64609 9.50307C8.28002 9.55274 7.99786 9.86653 7.99786 10.2462C7.99786 10.6259 8.28002 10.9397 8.64609 10.9894L8.74786 10.9962H15.2523L15.3541 10.9894C15.7202 10.9397 16.0023 10.6259 16.0023 10.2462C16.0023 9.83201 15.6666 9.49623 15.2523 9.49623ZM3.7501 6C4.44051 6 5.0002 6.55969 5.0002 7.2501C5.0002 7.94051 4.44051 8.5002 3.7501 8.5002C3.05969 8.5002 2.5 7.94051 2.5 7.2501C2.5 6.55969 3.05969 6 3.7501 6Z " },
            { FluentSymbol.ChannelDismiss24, "M17.5001 12C20.5377 12 23.0001 14.4624 23.0001 17.5C23.0001 20.5376 20.5377 23 17.5001 23C14.4625 23 12.0001 20.5376 12.0001 17.5C12.0001 14.4624 14.4625 12 17.5001 12ZM4.50031 9.37208L4.5001 17.75C4.5001 18.6682 5.20721 19.4212 6.10657 19.4942L6.2501 19.5L11.3137 19.5004C11.4862 20.0342 11.7259 20.5378 12.0227 21.0012L6.2501 21C4.51707 21 3.10086 19.6435 3.00525 17.9344L3.0001 17.75L2.99981 9.37208C3.23448 9.45505 3.48702 9.5002 3.7501 9.5002C4.01315 9.5002 4.26566 9.45506 4.50031 9.37208ZM15.0931 14.9663L15.0239 15.0241L14.966 15.0934C14.8479 15.2639 14.8479 15.4915 14.966 15.662L15.0239 15.7312L16.7935 17.5007L15.0265 19.2675L14.9686 19.3367C14.8505 19.5072 14.8505 19.7348 14.9686 19.9053L15.0265 19.9746L15.0957 20.0325C15.2662 20.1506 15.4938 20.1506 15.6643 20.0325L15.7336 19.9746L17.5005 18.2077L19.2695 19.9768L19.3387 20.0347C19.5093 20.1528 19.7368 20.1528 19.9074 20.0347L19.9766 19.9768L20.0345 19.9076C20.1526 19.7371 20.1526 19.5095 20.0345 19.339L19.9766 19.2697L18.2075 17.5007L19.9794 15.7313L20.0372 15.662C20.1553 15.4915 20.1553 15.2639 20.0372 15.0934L19.9794 15.0242L19.9101 14.9663C19.7396 14.8482 19.512 14.8482 19.3415 14.9663L19.2723 15.0242L17.5005 16.7937L15.731 15.0241L15.6618 14.9663C15.5156 14.865 15.3275 14.8506 15.1694 14.9229L15.0931 14.9663ZM12.8066 13.0032C12.3808 13.4475 12.0175 13.9521 11.7308 14.5029L8.74786 14.5031C8.33365 14.5031 7.99786 14.1673 7.99786 13.7531C7.99786 13.3734 8.28002 13.0596 8.64609 13.0099L8.74786 13.0031L12.8066 13.0032ZM17.7501 3C19.4831 3 20.8993 4.35645 20.995 6.06558L21.0001 6.25L21.0008 12.0223C20.5375 11.7256 20.0341 11.486 19.5005 11.3136L19.5001 6.25C19.5001 5.33183 18.793 4.57881 17.8936 4.5058L17.7501 4.5H6.2501C5.64992 4.5 5.12031 4.80213 4.80507 5.2626C4.49114 5.095 4.13172 5 3.7501 5C3.56887 5 3.39265 5.02142 3.22383 5.06188C3.67711 3.90899 4.77007 3.07762 6.06568 3.00514L6.2501 3H17.7501ZM15.2523 9.49623C15.6666 9.49623 16.0023 9.83201 16.0023 10.2462C16.0023 10.6259 15.7202 10.9397 15.3541 10.9894L15.2523 10.9962H8.74786C8.33365 10.9962 7.99786 10.6604 7.99786 10.2462C7.99786 9.86653 8.28002 9.55274 8.64609 9.50307L8.74786 9.49623H15.2523ZM3.7501 6C4.44051 6 5.0002 6.55969 5.0002 7.2501C5.0002 7.94051 4.44051 8.5002 3.7501 8.5002C3.05969 8.5002 2.5 7.94051 2.5 7.2501C2.5 6.55969 3.05969 6 3.7501 6Z " },
            { FluentSymbol.ChannelDismiss28Filled, "M3.00077 7.16804C2.40912 7.44875 2 8.0516 2 8.75C2 9.4481 2.40876 10.0507 3 10.3316C3.22731 10.4396 3.4816 10.5 3.75 10.5C4.7165 10.5 5.5 9.7165 5.5 8.75C5.5 7.7835 4.7165 7 3.75 7C3.48191 7 3.22789 7.06029 3.00077 7.16804Z M3.16838 6.06162C3.35586 6.02125 3.55045 6 3.75 6C5.26878 6 6.5 7.23122 6.5 8.75C6.5 10.2688 5.26878 11.5 3.75 11.5C3.48999 11.5 3.23842 11.4639 3 11.3965V20.75C3 23.0972 4.90279 25 7.25 25H14.4995C13.5579 23.7465 13 22.1884 13 20.5C13 19.0294 13.4232 17.6577 14.1546 16.5H9.75C9.33579 16.5 9 16.1642 9 15.75C9 15.3358 9.33579 15 9.75 15H15.4009C16.7391 13.7588 18.5309 13 20.5 13C22.1884 13 23.7465 13.5579 25 14.4995V7.25C25 4.90279 23.0972 3 20.75 3H7.25C5.31528 3 3.6825 4.29278 3.16838 6.06162ZM9.75 11H18.25C18.6642 11 19 11.3358 19 11.75C19 12.1642 18.6642 12.5 18.25 12.5H9.75C9.33579 12.5 9 12.1642 9 11.75C9 11.3358 9.33579 11 9.75 11Z M27 20.5C27 24.0899 24.0899 27 20.5 27C16.9101 27 14 24.0899 14 20.5C14 16.9101 16.9101 14 20.5 14C24.0899 14 27 16.9101 27 20.5ZM17.8536 17.1464C17.6583 16.9512 17.3417 16.9512 17.1464 17.1464C16.9512 17.3417 16.9512 17.6583 17.1464 17.8536L19.7929 20.5L17.1464 23.1464C16.9512 23.3417 16.9512 23.6583 17.1464 23.8536C17.3417 24.0488 17.6583 24.0488 17.8536 23.8536L20.5 21.2071L23.1464 23.8536C23.3417 24.0488 23.6583 24.0488 23.8536 23.8536C24.0488 23.6583 24.0488 23.3417 23.8536 23.1464L21.2071 20.5L23.8536 17.8536C24.0488 17.6583 24.0488 17.3417 23.8536 17.1464C23.6583 16.9512 23.3417 16.9512 23.1464 17.1464L20.5 19.7929L17.8536 17.1464Z " },
            { FluentSymbol.ChannelDismiss28, "M3 11.3965V20.75C3 23.0972 4.90279 25 7.25 25H14.4995C14.1527 24.5384 13.858 24.0355 13.6241 23.5H7.25C5.73122 23.5 4.5 22.2688 4.5 20.75V11.3965C4.26158 11.4639 4.01001 11.5 3.75 11.5C3.48999 11.5 3.23842 11.4639 3 11.3965Z M25 7.25V14.4995C24.5384 14.1527 24.0355 13.858 23.5 13.6241V7.25C23.5 5.73122 22.2688 4.5 20.75 4.5H7.25C6.1126 4.5 5.13648 5.19051 4.71797 6.17519C4.41688 6.06195 4.09067 6 3.75 6C3.55045 6 3.35586 6.02125 3.16838 6.06162C3.6825 4.29278 5.31528 3 7.25 3H20.75C23.0972 3 25 4.90279 25 7.25Z M9.75 15H15.4009C14.9235 15.4428 14.5039 15.947 14.1546 16.5H9.75C9.33579 16.5 9 16.1642 9 15.75C9 15.3358 9.33579 15 9.75 15Z M2 8.75C2 9.4481 2.40876 10.0507 3 10.3316C3.22731 10.4396 3.4816 10.5 3.75 10.5C4.0184 10.5 4.27269 10.4396 4.5 10.3316C5.09124 10.0507 5.5 9.4481 5.5 8.75C5.5 8.05236 5.09178 7.45007 4.50117 7.16896C4.27356 7.06063 4.01886 7 3.75 7C3.48191 7 3.22789 7.06029 3.00077 7.16804C2.40912 7.44875 2 8.0516 2 8.75Z M9.75 11C9.33579 11 9 11.3358 9 11.75C9 12.1642 9.33579 12.5 9.75 12.5H18.25C18.6642 12.5 19 12.1642 19 11.75C19 11.3358 18.6642 11 18.25 11H9.75Z M27 20.5C27 24.0899 24.0899 27 20.5 27C16.9101 27 14 24.0899 14 20.5C14 16.9101 16.9101 14 20.5 14C24.0899 14 27 16.9101 27 20.5ZM17.8536 17.1464C17.6583 16.9512 17.3417 16.9512 17.1464 17.1464C16.9512 17.3417 16.9512 17.6583 17.1464 17.8536L19.7929 20.5L17.1464 23.1464C16.9512 23.3417 16.9512 23.6583 17.1464 23.8536C17.3417 24.0488 17.6583 24.0488 17.8536 23.8536L20.5 21.2071L23.1464 23.8536C23.3417 24.0488 23.6583 24.0488 23.8536 23.8536C24.0488 23.6583 24.0488 23.3417 23.8536 23.1464L21.2071 20.5L23.8536 17.8536C24.0488 17.6583 24.0488 17.3417 23.8536 17.1464C23.6583 16.9512 23.3417 16.9512 23.1464 17.1464L20.5 19.7929L17.8536 17.1464Z " },
            { FluentSymbol.ChannelDismiss48Filled, "M12.25 6C9.32609 6 6.87113 8.00781 6.18865 10.7199C6.59946 10.5774 7.04069 10.5 7.5 10.5C9.70914 10.5 11.5 12.2909 11.5 14.5C11.5 16.7091 9.70914 18.5 7.5 18.5C6.96955 18.5 6.46322 18.3967 6 18.2092V35.75C6 39.2018 8.79822 42 12.25 42H24.0436C22.75 39.9794 22 37.5773 22 35C22 32.6321 22.6331 30.4121 23.7392 28.5H17.25C16.5596 28.5 16 27.9404 16 27.25C16 26.5596 16.5596 26 17.25 26H25.6191C27.985 23.5347 31.3133 22 35 22C37.5773 22 39.9794 22.75 42 24.0436V12.25C42 8.79822 39.2018 6 35.75 6H12.25ZM16 20.25C16 19.5596 16.5596 19 17.25 19H30.75C31.4404 19 32 19.5596 32 20.25C32 20.9404 31.4404 21.5 30.75 21.5H17.25C16.5596 21.5 16 20.9404 16 20.25Z M7.5 12C6.9372 12 6.41783 12.186 6 12.4998C5.39278 12.9559 5 13.6821 5 14.5C5 15.3179 5.39278 16.0441 6 16.5002C6.41783 16.814 6.9372 17 7.5 17C8.88071 17 10 15.8807 10 14.5C10 13.1193 8.88071 12 7.5 12Z M46 35C46 41.0751 41.0751 46 35 46C28.9249 46 24 41.0751 24 35C24 28.9249 28.9249 24 35 24C41.0751 24 46 28.9249 46 35ZM40.7071 30.7071C41.0976 30.3166 41.0976 29.6834 40.7071 29.2929C40.3166 28.9024 39.6834 28.9024 39.2929 29.2929L35 33.5858L30.7071 29.2929C30.3166 28.9024 29.6834 28.9024 29.2929 29.2929C28.9024 29.6834 28.9024 30.3166 29.2929 30.7071L33.5858 35L29.2929 39.2929C28.9024 39.6834 28.9024 40.3166 29.2929 40.7071C29.6834 41.0976 30.3166 41.0976 30.7071 40.7071L35 36.4142L39.2929 40.7071C39.6834 41.0976 40.3166 41.0976 40.7071 40.7071C41.0976 40.3166 41.0976 39.6834 40.7071 39.2929L36.4142 35L40.7071 30.7071Z " },
            { FluentSymbol.ChannelDismiss48, "M7.5 10.5C7.04069 10.5 6.59946 10.5774 6.18865 10.7199C6.87113 8.00781 9.32609 6 12.25 6H35.75C39.2018 6 42 8.79822 42 12.25V24.0436C41.2196 23.544 40.3823 23.1255 39.5 22.7999V12.25C39.5 10.1789 37.8211 8.5 35.75 8.5H12.25C10.7223 8.5 9.40795 9.41353 8.82345 10.7241C8.40921 10.5789 7.96382 10.5 7.5 10.5Z M22.7999 39.5C23.1255 40.3823 23.544 41.2196 24.0436 42H12.25C8.79822 42 6 39.2018 6 35.75V18.2092C6.46322 18.3967 6.96955 18.5 7.5 18.5C7.8453 18.5 8.18038 18.4562 8.5 18.374V35.75C8.5 37.8211 10.1789 39.5 12.25 39.5H22.7999Z M23.7392 28.5C24.2647 27.5914 24.8971 26.7524 25.6191 26H17.25C16.5596 26 16 26.5596 16 27.25C16 27.9404 16.5596 28.5 17.25 28.5H23.7392Z M7.5 12C6.9372 12 6.41783 12.186 6 12.4998C5.39278 12.9559 5 13.6821 5 14.5C5 15.3179 5.39278 16.0441 6 16.5002C6.41783 16.814 6.9372 17 7.5 17C7.85555 17 8.19377 16.9258 8.5 16.792C9.38295 16.4062 10 15.5252 10 14.5C10 13.4749 9.38306 12.594 8.50023 12.2081C8.19394 12.0743 7.85564 12 7.5 12Z M17.25 19C16.5596 19 16 19.5596 16 20.25C16 20.9404 16.5596 21.5 17.25 21.5H30.75C31.4404 21.5 32 20.9404 32 20.25C32 19.5596 31.4404 19 30.75 19H17.25Z M46 35C46 41.0751 41.0751 46 35 46C28.9249 46 24 41.0751 24 35C24 28.9249 28.9249 24 35 24C41.0751 24 46 28.9249 46 35ZM40.7071 30.7071C41.0976 30.3166 41.0976 29.6834 40.7071 29.2929C40.3166 28.9024 39.6834 28.9024 39.2929 29.2929L35 33.5858L30.7071 29.2929C30.3166 28.9024 29.6834 28.9024 29.2929 29.2929C28.9024 29.6834 28.9024 30.3166 29.2929 30.7071L33.5858 35L29.2929 39.2929C28.9024 39.6834 28.9024 40.3166 29.2929 40.7071C29.6834 41.0976 30.3166 41.0976 30.7071 40.7071L35 36.4142L39.2929 40.7071C39.6834 41.0976 40.3166 41.0976 40.7071 40.7071C41.0976 40.3166 41.0976 39.6834 40.7071 39.2929L36.4142 35L40.7071 30.7071Z " },
            { FluentSymbol.Chat16Filled, "M8.00001 2C4.68631 2 2.00001 4.68629 2.00001 8C2.00001 9.03957 2.2648 10.0186 2.73086 10.872L2.01925 13.3626C1.9683 13.541 2.02025 13.7329 2.15422 13.8612C2.2882 13.9894 2.48217 14.033 2.65813 13.9743L4.99618 13.195C5.87989 13.707 6.90639 14 8.00001 14C11.3137 14 14 11.3137 14 8C14 4.68629 11.3137 2 8.00001 2ZM6 7C6 6.72386 6.22386 6.5 6.5 6.5H9.5C9.77614 6.5 10 6.72386 10 7C10 7.27614 9.77614 7.5 9.5 7.5H6.5C6.22386 7.5 6 7.27614 6 7ZM6.5 8.5H8.5C8.77614 8.5 9 8.72386 9 9C9 9.27614 8.77614 9.5 8.5 9.5H6.5C6.22386 9.5 6 9.